// =================================================================
//
//                           * WARNING *
//
//                    This file is generated!
//
//  Changes made to this file will be overwritten. If changes are
//  required to the generated code, the service_crategen project
//  must be updated to generate the changes.
//
// =================================================================

use std::error::Error;
use std::fmt;

use async_trait::async_trait;
use rusoto_core::credential::ProvideAwsCredentials;
use rusoto_core::region;
use rusoto_core::request::{BufferedHttpResponse, DispatchSignedRequest};
use rusoto_core::{Client, RusotoError};

use rusoto_core::param::{Params, ServiceParams};
use rusoto_core::proto::xml::error::*;
use rusoto_core::proto::xml::util::{
    self as xml_util, deserialize_elements, find_start_element, skip_tree,
};
use rusoto_core::proto::xml::util::{Next, Peek, XmlParseError, XmlResponse};
use rusoto_core::request::HttpResponse;
use rusoto_core::signature::SignedRequest;
#[cfg(feature = "deserialize_structs")]
use serde::Deserialize;
#[cfg(feature = "serialize_structs")]
use serde::Serialize;
use serde_urlencoded;
use std::str::FromStr;
use xml::EventReader;

impl RdsClient {
    fn new_params(&self, operation_name: &str) -> Params {
        let mut params = Params::new();

        params.put("Action", operation_name);
        params.put("Version", "2014-10-31");

        params
    }

    async fn sign_and_dispatch<E>(
        &self,
        request: SignedRequest,
        from_response: fn(BufferedHttpResponse) -> RusotoError<E>,
    ) -> Result<HttpResponse, RusotoError<E>> {
        let mut response = self.client.sign_and_dispatch(request).await?;
        if !response.status.is_success() {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            return Err(from_response(response));
        }

        Ok(response)
    }
}

/// <p>Data returned by the <b>DescribeAccountAttributes</b> action.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AccountAttributesMessage {
    /// <p>A list of <code>AccountQuota</code> objects. Within this list, each quota has a name, a count of usage toward the quota maximum, and a maximum value for the quota.</p>
    pub account_quotas: Option<Vec<AccountQuota>>,
}

#[allow(dead_code)]
struct AccountAttributesMessageDeserializer;
impl AccountAttributesMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AccountAttributesMessage, XmlParseError> {
        deserialize_elements::<_, AccountAttributesMessage, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "AccountQuotas" => {
                        obj.account_quotas.get_or_insert(vec![]).extend(
                            AccountQuotaListDeserializer::deserialize("AccountQuotas", stack)?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Describes a quota for an Amazon Web Services account.</p> <p>The following are account quotas:</p> <ul> <li> <p> <code>AllocatedStorage</code> - The total allocated storage per account, in GiB. The used value is the total allocated storage in the account, in GiB.</p> </li> <li> <p> <code>AuthorizationsPerDBSecurityGroup</code> - The number of ingress rules per DB security group. The used value is the highest number of ingress rules in a DB security group in the account. Other DB security groups in the account might have a lower number of ingress rules.</p> </li> <li> <p> <code>CustomEndpointsPerDBCluster</code> - The number of custom endpoints per DB cluster. The used value is the highest number of custom endpoints in a DB clusters in the account. Other DB clusters in the account might have a lower number of custom endpoints.</p> </li> <li> <p> <code>DBClusterParameterGroups</code> - The number of DB cluster parameter groups per account, excluding default parameter groups. The used value is the count of nondefault DB cluster parameter groups in the account.</p> </li> <li> <p> <code>DBClusterRoles</code> - The number of associated Amazon Web Services Identity and Access Management (IAM) roles per DB cluster. The used value is the highest number of associated IAM roles for a DB cluster in the account. Other DB clusters in the account might have a lower number of associated IAM roles.</p> </li> <li> <p> <code>DBClusters</code> - The number of DB clusters per account. The used value is the count of DB clusters in the account.</p> </li> <li> <p> <code>DBInstanceRoles</code> - The number of associated IAM roles per DB instance. The used value is the highest number of associated IAM roles for a DB instance in the account. Other DB instances in the account might have a lower number of associated IAM roles.</p> </li> <li> <p> <code>DBInstances</code> - The number of DB instances per account. The used value is the count of the DB instances in the account.</p> <p>Amazon RDS DB instances, Amazon Aurora DB instances, Amazon Neptune instances, and Amazon DocumentDB instances apply to this quota.</p> </li> <li> <p> <code>DBParameterGroups</code> - The number of DB parameter groups per account, excluding default parameter groups. The used value is the count of nondefault DB parameter groups in the account.</p> </li> <li> <p> <code>DBSecurityGroups</code> - The number of DB security groups (not VPC security groups) per account, excluding the default security group. The used value is the count of nondefault DB security groups in the account.</p> </li> <li> <p> <code>DBSubnetGroups</code> - The number of DB subnet groups per account. The used value is the count of the DB subnet groups in the account.</p> </li> <li> <p> <code>EventSubscriptions</code> - The number of event subscriptions per account. The used value is the count of the event subscriptions in the account.</p> </li> <li> <p> <code>ManualClusterSnapshots</code> - The number of manual DB cluster snapshots per account. The used value is the count of the manual DB cluster snapshots in the account.</p> </li> <li> <p> <code>ManualSnapshots</code> - The number of manual DB instance snapshots per account. The used value is the count of the manual DB instance snapshots in the account.</p> </li> <li> <p> <code>OptionGroups</code> - The number of DB option groups per account, excluding default option groups. The used value is the count of nondefault DB option groups in the account.</p> </li> <li> <p> <code>ReadReplicasPerMaster</code> - The number of read replicas per DB instance. The used value is the highest number of read replicas for a DB instance in the account. Other DB instances in the account might have a lower number of read replicas.</p> </li> <li> <p> <code>ReservedDBInstances</code> - The number of reserved DB instances per account. The used value is the count of the active reserved DB instances in the account.</p> </li> <li> <p> <code>SubnetsPerDBSubnetGroup</code> - The number of subnets per DB subnet group. The used value is highest number of subnets for a DB subnet group in the account. Other DB subnet groups in the account might have a lower number of subnets.</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Limits.html">Quotas for Amazon RDS</a> in the <i>Amazon RDS User Guide</i> and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_Limits.html">Quotas for Amazon Aurora</a> in the <i>Amazon Aurora User Guide</i>.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AccountQuota {
    /// <p>The name of the Amazon RDS quota for this Amazon Web Services account.</p>
    pub account_quota_name: Option<String>,
    /// <p>The maximum allowed value for the quota.</p>
    pub max: Option<i64>,
    /// <p>The amount currently used toward the quota maximum.</p>
    pub used: Option<i64>,
}

#[allow(dead_code)]
struct AccountQuotaDeserializer;
impl AccountQuotaDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AccountQuota, XmlParseError> {
        deserialize_elements::<_, AccountQuota, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "AccountQuotaName" => {
                    obj.account_quota_name =
                        Some(StringDeserializer::deserialize("AccountQuotaName", stack)?);
                }
                "Max" => {
                    obj.max = Some(LongDeserializer::deserialize("Max", stack)?);
                }
                "Used" => {
                    obj.used = Some(LongDeserializer::deserialize("Used", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct AccountQuotaListDeserializer;
impl AccountQuotaListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<AccountQuota>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "AccountQuota" {
                obj.push(AccountQuotaDeserializer::deserialize(
                    "AccountQuota",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct ActivityStreamModeDeserializer;
impl ActivityStreamModeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct ActivityStreamModeListDeserializer;
impl ActivityStreamModeListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<String>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(StringDeserializer::deserialize("member", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct ActivityStreamStatusDeserializer;
impl ActivityStreamStatusDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AddRoleToDBClusterMessage {
    /// <p>The name of the DB cluster to associate the IAM role with.</p>
    pub db_cluster_identifier: String,
    /// <p>The name of the feature for the DB cluster that the IAM role is to be associated with. For the list of supported feature names, see <a>DBEngineVersion</a>.</p>
    pub feature_name: Option<String>,
    /// <p>The Amazon Resource Name (ARN) of the IAM role to associate with the Aurora DB cluster, for example, <code>arn:aws:iam::123456789012:role/AuroraAccessRole</code>.</p>
    pub role_arn: String,
}

/// Serialize `AddRoleToDBClusterMessage` contents to a `SignedRequest`.
struct AddRoleToDBClusterMessageSerializer;
impl AddRoleToDBClusterMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &AddRoleToDBClusterMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "DBClusterIdentifier"),
            &obj.db_cluster_identifier,
        );
        if let Some(ref field_value) = obj.feature_name {
            params.put(&format!("{}{}", prefix, "FeatureName"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "RoleArn"), &obj.role_arn);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AddRoleToDBInstanceMessage {
    /// <p>The name of the DB instance to associate the IAM role with.</p>
    pub db_instance_identifier: String,
    /// <p>The name of the feature for the DB instance that the IAM role is to be associated with. For the list of supported feature names, see <a>DBEngineVersion</a>. </p>
    pub feature_name: String,
    /// <p>The Amazon Resource Name (ARN) of the IAM role to associate with the DB instance, for example <code>arn:aws:iam::123456789012:role/AccessRole</code>. </p>
    pub role_arn: String,
}

/// Serialize `AddRoleToDBInstanceMessage` contents to a `SignedRequest`.
struct AddRoleToDBInstanceMessageSerializer;
impl AddRoleToDBInstanceMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &AddRoleToDBInstanceMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "DBInstanceIdentifier"),
            &obj.db_instance_identifier,
        );
        params.put(&format!("{}{}", prefix, "FeatureName"), &obj.feature_name);
        params.put(&format!("{}{}", prefix, "RoleArn"), &obj.role_arn);
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AddSourceIdentifierToSubscriptionMessage {
    /// <p><p>The identifier of the event source to be added.</p> <p>Constraints:</p> <ul> <li> <p>If the source type is a DB instance, a <code>DBInstanceIdentifier</code> value must be supplied.</p> </li> <li> <p>If the source type is a DB cluster, a <code>DBClusterIdentifier</code> value must be supplied.</p> </li> <li> <p>If the source type is a DB parameter group, a <code>DBParameterGroupName</code> value must be supplied.</p> </li> <li> <p>If the source type is a DB security group, a <code>DBSecurityGroupName</code> value must be supplied.</p> </li> <li> <p>If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> value must be supplied.</p> </li> <li> <p>If the source type is a DB cluster snapshot, a <code>DBClusterSnapshotIdentifier</code> value must be supplied.</p> </li> </ul></p>
    pub source_identifier: String,
    /// <p>The name of the RDS event notification subscription you want to add a source identifier to.</p>
    pub subscription_name: String,
}

/// Serialize `AddSourceIdentifierToSubscriptionMessage` contents to a `SignedRequest`.
struct AddSourceIdentifierToSubscriptionMessageSerializer;
impl AddSourceIdentifierToSubscriptionMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &AddSourceIdentifierToSubscriptionMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "SourceIdentifier"),
            &obj.source_identifier,
        );
        params.put(
            &format!("{}{}", prefix, "SubscriptionName"),
            &obj.subscription_name,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AddSourceIdentifierToSubscriptionResult {
    pub event_subscription: Option<EventSubscription>,
}

#[allow(dead_code)]
struct AddSourceIdentifierToSubscriptionResultDeserializer;
impl AddSourceIdentifierToSubscriptionResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AddSourceIdentifierToSubscriptionResult, XmlParseError> {
        deserialize_elements::<_, AddSourceIdentifierToSubscriptionResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "EventSubscription" => {
                        obj.event_subscription = Some(EventSubscriptionDeserializer::deserialize(
                            "EventSubscription",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AddTagsToResourceMessage {
    /// <p>The Amazon RDS resource that the tags are added to. This value is an Amazon Resource Name (ARN). For information about creating an ARN, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing"> Constructing an RDS Amazon Resource Name (ARN)</a>.</p>
    pub resource_name: String,
    /// <p>The tags to be assigned to the Amazon RDS resource.</p>
    pub tags: Vec<Tag>,
}

/// Serialize `AddTagsToResourceMessage` contents to a `SignedRequest`.
struct AddTagsToResourceMessageSerializer;
impl AddTagsToResourceMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &AddTagsToResourceMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "ResourceName"), &obj.resource_name);
        TagListSerializer::serialize(params, &format!("{}{}", prefix, "Tag"), &obj.tags);
    }
}

#[allow(dead_code)]
struct ApplyMethodDeserializer;
impl ApplyMethodDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ApplyPendingMaintenanceActionMessage {
    /// <p>The pending maintenance action to apply to this resource.</p> <p>Valid values: <code>system-update</code>, <code>db-upgrade</code>, <code>hardware-maintenance</code>, <code>ca-certificate-rotation</code> </p>
    pub apply_action: String,
    /// <p><p>A value that specifies the type of opt-in request, or undoes an opt-in request. An opt-in request of type <code>immediate</code> can&#39;t be undone.</p> <p>Valid values:</p> <ul> <li> <p> <code>immediate</code> - Apply the maintenance action immediately.</p> </li> <li> <p> <code>next-maintenance</code> - Apply the maintenance action during the next maintenance window for the resource.</p> </li> <li> <p> <code>undo-opt-in</code> - Cancel any existing <code>next-maintenance</code> opt-in requests.</p> </li> </ul></p>
    pub opt_in_type: String,
    /// <p>The RDS Amazon Resource Name (ARN) of the resource that the pending maintenance action applies to. For information about creating an ARN, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing"> Constructing an RDS Amazon Resource Name (ARN)</a>.</p>
    pub resource_identifier: String,
}

/// Serialize `ApplyPendingMaintenanceActionMessage` contents to a `SignedRequest`.
struct ApplyPendingMaintenanceActionMessageSerializer;
impl ApplyPendingMaintenanceActionMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ApplyPendingMaintenanceActionMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "ApplyAction"), &obj.apply_action);
        params.put(&format!("{}{}", prefix, "OptInType"), &obj.opt_in_type);
        params.put(
            &format!("{}{}", prefix, "ResourceIdentifier"),
            &obj.resource_identifier,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ApplyPendingMaintenanceActionResult {
    pub resource_pending_maintenance_actions: Option<ResourcePendingMaintenanceActions>,
}

#[allow(dead_code)]
struct ApplyPendingMaintenanceActionResultDeserializer;
impl ApplyPendingMaintenanceActionResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ApplyPendingMaintenanceActionResult, XmlParseError> {
        deserialize_elements::<_, ApplyPendingMaintenanceActionResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "ResourcePendingMaintenanceActions" => {
                        obj.resource_pending_maintenance_actions =
                            Some(ResourcePendingMaintenanceActionsDeserializer::deserialize(
                                "ResourcePendingMaintenanceActions",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct AttributeValueListDeserializer;
impl AttributeValueListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<String>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "AttributeValue" {
                obj.push(StringDeserializer::deserialize("AttributeValue", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}

/// Serialize `AttributeValueList` contents to a `SignedRequest`.
struct AttributeValueListSerializer;
impl AttributeValueListSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<String>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.member.{}", name, index + 1);
            params.put(&key, &obj);
        }
    }
}

#[allow(dead_code)]
struct AuthSchemeDeserializer;
impl AuthSchemeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AuthorizeDBSecurityGroupIngressMessage {
    /// <p>The IP range to authorize.</p>
    pub cidrip: Option<String>,
    /// <p>The name of the DB security group to add authorization to.</p>
    pub db_security_group_name: String,
    /// <p> Id of the EC2 security group to authorize. For VPC DB security groups, <code>EC2SecurityGroupId</code> must be provided. Otherwise, <code>EC2SecurityGroupOwnerId</code> and either <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided. </p>
    pub ec2_security_group_id: Option<String>,
    /// <p> Name of the EC2 security group to authorize. For VPC DB security groups, <code>EC2SecurityGroupId</code> must be provided. Otherwise, <code>EC2SecurityGroupOwnerId</code> and either <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided. </p>
    pub ec2_security_group_name: Option<String>,
    /// <p> Amazon Web Services account number of the owner of the EC2 security group specified in the <code>EC2SecurityGroupName</code> parameter. The Amazon Web Services access key ID isn't an acceptable value. For VPC DB security groups, <code>EC2SecurityGroupId</code> must be provided. Otherwise, <code>EC2SecurityGroupOwnerId</code> and either <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided. </p>
    pub ec2_security_group_owner_id: Option<String>,
}

/// Serialize `AuthorizeDBSecurityGroupIngressMessage` contents to a `SignedRequest`.
struct AuthorizeDBSecurityGroupIngressMessageSerializer;
impl AuthorizeDBSecurityGroupIngressMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &AuthorizeDBSecurityGroupIngressMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.cidrip {
            params.put(&format!("{}{}", prefix, "CIDRIP"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "DBSecurityGroupName"),
            &obj.db_security_group_name,
        );
        if let Some(ref field_value) = obj.ec2_security_group_id {
            params.put(&format!("{}{}", prefix, "EC2SecurityGroupId"), &field_value);
        }
        if let Some(ref field_value) = obj.ec2_security_group_name {
            params.put(
                &format!("{}{}", prefix, "EC2SecurityGroupName"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.ec2_security_group_owner_id {
            params.put(
                &format!("{}{}", prefix, "EC2SecurityGroupOwnerId"),
                &field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AuthorizeDBSecurityGroupIngressResult {
    pub db_security_group: Option<DBSecurityGroup>,
}

#[allow(dead_code)]
struct AuthorizeDBSecurityGroupIngressResultDeserializer;
impl AuthorizeDBSecurityGroupIngressResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AuthorizeDBSecurityGroupIngressResult, XmlParseError> {
        deserialize_elements::<_, AuthorizeDBSecurityGroupIngressResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DBSecurityGroup" => {
                        obj.db_security_group = Some(DBSecurityGroupDeserializer::deserialize(
                            "DBSecurityGroup",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Contains Availability Zone information.</p> <p> This data type is used as an element in the <code>OrderableDBInstanceOption</code> data type.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AvailabilityZone {
    /// <p>The name of the Availability Zone.</p>
    pub name: Option<String>,
}

#[allow(dead_code)]
struct AvailabilityZoneDeserializer;
impl AvailabilityZoneDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AvailabilityZone, XmlParseError> {
        deserialize_elements::<_, AvailabilityZone, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Name" => {
                    obj.name = Some(StringDeserializer::deserialize("Name", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct AvailabilityZoneListDeserializer;
impl AvailabilityZoneListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<AvailabilityZone>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "AvailabilityZone" {
                obj.push(AvailabilityZoneDeserializer::deserialize(
                    "AvailabilityZone",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct AvailabilityZonesDeserializer;
impl AvailabilityZonesDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<String>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "AvailabilityZone" {
                obj.push(StringDeserializer::deserialize("AvailabilityZone", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}

/// Serialize `AvailabilityZones` contents to a `SignedRequest`.
struct AvailabilityZonesSerializer;
impl AvailabilityZonesSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<String>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.member.{}", name, index + 1);
            params.put(&key, &obj);
        }
    }
}

/// <p>Contains the available processor feature information for the DB instance class of a DB instance.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html#USER_ConfigureProcessor">Configuring the Processor of the DB Instance Class</a> in the <i>Amazon RDS User Guide. </i> </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AvailableProcessorFeature {
    /// <p>The allowed values for the processor feature of the DB instance class.</p>
    pub allowed_values: Option<String>,
    /// <p>The default value for the processor feature of the DB instance class.</p>
    pub default_value: Option<String>,
    /// <p>The name of the processor feature. Valid names are <code>coreCount</code> and <code>threadsPerCore</code>.</p>
    pub name: Option<String>,
}

#[allow(dead_code)]
struct AvailableProcessorFeatureDeserializer;
impl AvailableProcessorFeatureDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AvailableProcessorFeature, XmlParseError> {
        deserialize_elements::<_, AvailableProcessorFeature, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "AllowedValues" => {
                        obj.allowed_values =
                            Some(StringDeserializer::deserialize("AllowedValues", stack)?);
                    }
                    "DefaultValue" => {
                        obj.default_value =
                            Some(StringDeserializer::deserialize("DefaultValue", stack)?);
                    }
                    "Name" => {
                        obj.name = Some(StringDeserializer::deserialize("Name", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct AvailableProcessorFeatureListDeserializer;
impl AvailableProcessorFeatureListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<AvailableProcessorFeature>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "AvailableProcessorFeature" {
                obj.push(AvailableProcessorFeatureDeserializer::deserialize(
                    "AvailableProcessorFeature",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct BacktrackDBClusterMessage {
    /// <p>The timestamp of the time to backtrack the DB cluster to, specified in ISO 8601 format. For more information about ISO 8601, see the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a> </p> <note> <p>If the specified time isn't a consistent time for the DB cluster, Aurora automatically chooses the nearest possible consistent time for the DB cluster.</p> </note> <p>Constraints:</p> <ul> <li> <p>Must contain a valid ISO 8601 timestamp.</p> </li> <li> <p>Can't contain a timestamp set in the future.</p> </li> </ul> <p>Example: <code>2017-07-08T18:00Z</code> </p>
    pub backtrack_to: String,
    /// <p>The DB cluster identifier of the DB cluster to be backtracked. This parameter is stored as a lowercase string.</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li> </ul> <p>Example: <code>my-cluster1</code> </p>
    pub db_cluster_identifier: String,
    /// <p>A value that indicates whether to force the DB cluster to backtrack when binary logging is enabled. Otherwise, an error occurs when binary logging is enabled.</p>
    pub force: Option<bool>,
    /// <p>A value that indicates whether to backtrack the DB cluster to the earliest possible backtrack time when <i>BacktrackTo</i> is set to a timestamp earlier than the earliest backtrack time. When this parameter is disabled and <i>BacktrackTo</i> is set to a timestamp earlier than the earliest backtrack time, an error occurs.</p>
    pub use_earliest_time_on_point_in_time_unavailable: Option<bool>,
}

/// Serialize `BacktrackDBClusterMessage` contents to a `SignedRequest`.
struct BacktrackDBClusterMessageSerializer;
impl BacktrackDBClusterMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &BacktrackDBClusterMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "BacktrackTo"), &obj.backtrack_to);
        params.put(
            &format!("{}{}", prefix, "DBClusterIdentifier"),
            &obj.db_cluster_identifier,
        );
        if let Some(ref field_value) = obj.force {
            params.put(&format!("{}{}", prefix, "Force"), &field_value);
        }
        if let Some(ref field_value) = obj.use_earliest_time_on_point_in_time_unavailable {
            params.put(
                &format!("{}{}", prefix, "UseEarliestTimeOnPointInTimeUnavailable"),
                &field_value,
            );
        }
    }
}

#[allow(dead_code)]
struct BooleanDeserializer;
impl BooleanDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<bool, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, |s| Ok(bool::from_str(&s).unwrap()))
    }
}
#[allow(dead_code)]
struct BooleanOptionalDeserializer;
impl BooleanOptionalDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<bool, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, |s| Ok(bool::from_str(&s).unwrap()))
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CancelExportTaskMessage {
    /// <p>The identifier of the snapshot export task to cancel.</p>
    pub export_task_identifier: String,
}

/// Serialize `CancelExportTaskMessage` contents to a `SignedRequest`.
struct CancelExportTaskMessageSerializer;
impl CancelExportTaskMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CancelExportTaskMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "ExportTaskIdentifier"),
            &obj.export_task_identifier,
        );
    }
}

/// <p>A CA certificate for an Amazon Web Services account.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct Certificate {
    /// <p>The Amazon Resource Name (ARN) for the certificate.</p>
    pub certificate_arn: Option<String>,
    /// <p>The unique key that identifies a certificate.</p>
    pub certificate_identifier: Option<String>,
    /// <p>The type of the certificate.</p>
    pub certificate_type: Option<String>,
    /// <p>Whether there is an override for the default certificate identifier.</p>
    pub customer_override: Option<bool>,
    /// <p>If there is an override for the default certificate identifier, when the override expires.</p>
    pub customer_override_valid_till: Option<String>,
    /// <p>The thumbprint of the certificate.</p>
    pub thumbprint: Option<String>,
    /// <p>The starting date from which the certificate is valid.</p>
    pub valid_from: Option<String>,
    /// <p>The final date that the certificate continues to be valid.</p>
    pub valid_till: Option<String>,
}

#[allow(dead_code)]
struct CertificateDeserializer;
impl CertificateDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Certificate, XmlParseError> {
        deserialize_elements::<_, Certificate, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "CertificateArn" => {
                    obj.certificate_arn =
                        Some(StringDeserializer::deserialize("CertificateArn", stack)?);
                }
                "CertificateIdentifier" => {
                    obj.certificate_identifier = Some(StringDeserializer::deserialize(
                        "CertificateIdentifier",
                        stack,
                    )?);
                }
                "CertificateType" => {
                    obj.certificate_type =
                        Some(StringDeserializer::deserialize("CertificateType", stack)?);
                }
                "CustomerOverride" => {
                    obj.customer_override = Some(BooleanOptionalDeserializer::deserialize(
                        "CustomerOverride",
                        stack,
                    )?);
                }
                "CustomerOverrideValidTill" => {
                    obj.customer_override_valid_till = Some(TStampDeserializer::deserialize(
                        "CustomerOverrideValidTill",
                        stack,
                    )?);
                }
                "Thumbprint" => {
                    obj.thumbprint = Some(StringDeserializer::deserialize("Thumbprint", stack)?);
                }
                "ValidFrom" => {
                    obj.valid_from = Some(TStampDeserializer::deserialize("ValidFrom", stack)?);
                }
                "ValidTill" => {
                    obj.valid_till = Some(TStampDeserializer::deserialize("ValidTill", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct CertificateListDeserializer;
impl CertificateListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<Certificate>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "Certificate" {
                obj.push(CertificateDeserializer::deserialize("Certificate", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Data returned by the <b>DescribeCertificates</b> action.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CertificateMessage {
    /// <p>The list of <code>Certificate</code> objects for the Amazon Web Services account.</p>
    pub certificates: Option<Vec<Certificate>>,
    /// <p> An optional pagination token provided by a previous <code>DescribeCertificates</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> . </p>
    pub marker: Option<String>,
}

#[allow(dead_code)]
struct CertificateMessageDeserializer;
impl CertificateMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CertificateMessage, XmlParseError> {
        deserialize_elements::<_, CertificateMessage, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Certificates" => {
                    obj.certificates.get_or_insert(vec![]).extend(
                        CertificateListDeserializer::deserialize("Certificates", stack)?,
                    );
                }
                "Marker" => {
                    obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p> This data type is used as a response element in the action <code>DescribeDBEngineVersions</code>. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CharacterSet {
    /// <p>The description of the character set.</p>
    pub character_set_description: Option<String>,
    /// <p>The name of the character set.</p>
    pub character_set_name: Option<String>,
}

#[allow(dead_code)]
struct CharacterSetDeserializer;
impl CharacterSetDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CharacterSet, XmlParseError> {
        deserialize_elements::<_, CharacterSet, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "CharacterSetDescription" => {
                    obj.character_set_description = Some(StringDeserializer::deserialize(
                        "CharacterSetDescription",
                        stack,
                    )?);
                }
                "CharacterSetName" => {
                    obj.character_set_name =
                        Some(StringDeserializer::deserialize("CharacterSetName", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>The configuration setting for the log types to be enabled for export to CloudWatch Logs for a specific DB instance or DB cluster.</p> <p>The <code>EnableLogTypes</code> and <code>DisableLogTypes</code> arrays determine which logs will be exported (or not exported) to CloudWatch Logs. The values within these arrays depend on the DB engine being used.</p> <p>For more information about exporting CloudWatch Logs for Amazon RDS DB instances, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs </a> in the <i>Amazon RDS User Guide</i>.</p> <p>For more information about exporting CloudWatch Logs for Amazon Aurora DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Aurora User Guide</i>.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CloudwatchLogsExportConfiguration {
    /// <p>The list of log types to disable.</p>
    pub disable_log_types: Option<Vec<String>>,
    /// <p>The list of log types to enable.</p>
    pub enable_log_types: Option<Vec<String>>,
}

/// Serialize `CloudwatchLogsExportConfiguration` contents to a `SignedRequest`.
struct CloudwatchLogsExportConfigurationSerializer;
impl CloudwatchLogsExportConfigurationSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CloudwatchLogsExportConfiguration) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.disable_log_types {
            LogTypeListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "DisableLogTypes"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.enable_log_types {
            LogTypeListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "EnableLogTypes"),
                field_value,
            );
        }
    }
}

/// <p>This data type is used as a response element in the <code>ModifyDBCluster</code> operation and contains changes that will be applied during the next maintenance window.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ClusterPendingModifiedValues {
    /// <p>The DBClusterIdentifier value for the DB cluster.</p>
    pub db_cluster_identifier: Option<String>,
    /// <p>The database engine version.</p>
    pub engine_version: Option<String>,
    /// <p>A value that indicates whether mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled.</p>
    pub iam_database_authentication_enabled: Option<bool>,
    /// <p>The master credentials for the DB cluster.</p>
    pub master_user_password: Option<String>,
    pub pending_cloudwatch_logs_exports: Option<PendingCloudwatchLogsExports>,
}

#[allow(dead_code)]
struct ClusterPendingModifiedValuesDeserializer;
impl ClusterPendingModifiedValuesDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ClusterPendingModifiedValues, XmlParseError> {
        deserialize_elements::<_, ClusterPendingModifiedValues, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DBClusterIdentifier" => {
                        obj.db_cluster_identifier = Some(StringDeserializer::deserialize(
                            "DBClusterIdentifier",
                            stack,
                        )?);
                    }
                    "EngineVersion" => {
                        obj.engine_version =
                            Some(StringDeserializer::deserialize("EngineVersion", stack)?);
                    }
                    "IAMDatabaseAuthenticationEnabled" => {
                        obj.iam_database_authentication_enabled =
                            Some(BooleanOptionalDeserializer::deserialize(
                                "IAMDatabaseAuthenticationEnabled",
                                stack,
                            )?);
                    }
                    "MasterUserPassword" => {
                        obj.master_user_password = Some(StringDeserializer::deserialize(
                            "MasterUserPassword",
                            stack,
                        )?);
                    }
                    "PendingCloudwatchLogsExports" => {
                        obj.pending_cloudwatch_logs_exports =
                            Some(PendingCloudwatchLogsExportsDeserializer::deserialize(
                                "PendingCloudwatchLogsExports",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Specifies the settings that control the size and behavior of the connection pool associated with a <code>DBProxyTargetGroup</code>.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ConnectionPoolConfiguration {
    /// <p>The number of seconds for a proxy to wait for a connection to become available in the connection pool. Only applies when the proxy has opened its maximum number of connections and all connections are busy with client sessions.</p> <p>Default: 120</p> <p>Constraints: between 1 and 3600, or 0 representing unlimited</p>
    pub connection_borrow_timeout: Option<i64>,
    /// <p> One or more SQL statements for the proxy to run when opening each new database connection. Typically used with <code>SET</code> statements to make sure that each connection has identical settings such as time zone and character set. For multiple statements, use semicolons as the separator. You can also include multiple variables in a single <code>SET</code> statement, such as <code>SET x=1, y=2</code>. </p> <p>Default: no initialization query</p>
    pub init_query: Option<String>,
    /// <p>The maximum size of the connection pool for each target in a target group. For Aurora MySQL, it is expressed as a percentage of the <code>max_connections</code> setting for the RDS DB instance or Aurora DB cluster used by the target group.</p> <p>Default: 100</p> <p>Constraints: between 1 and 100</p>
    pub max_connections_percent: Option<i64>,
    /// <p> Controls how actively the proxy closes idle database connections in the connection pool. A high value enables the proxy to leave a high percentage of idle connections open. A low value causes the proxy to close idle client connections and return the underlying database connections to the connection pool. For Aurora MySQL, it is expressed as a percentage of the <code>max_connections</code> setting for the RDS DB instance or Aurora DB cluster used by the target group. </p> <p>Default: 50</p> <p>Constraints: between 0 and <code>MaxConnectionsPercent</code> </p>
    pub max_idle_connections_percent: Option<i64>,
    /// <p>Each item in the list represents a class of SQL operations that normally cause all later statements in a session using a proxy to be pinned to the same underlying database connection. Including an item in the list exempts that class of SQL operations from the pinning behavior.</p> <p>Default: no session pinning filters</p>
    pub session_pinning_filters: Option<Vec<String>>,
}

/// Serialize `ConnectionPoolConfiguration` contents to a `SignedRequest`.
struct ConnectionPoolConfigurationSerializer;
impl ConnectionPoolConfigurationSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ConnectionPoolConfiguration) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.connection_borrow_timeout {
            params.put(
                &format!("{}{}", prefix, "ConnectionBorrowTimeout"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.init_query {
            params.put(&format!("{}{}", prefix, "InitQuery"), &field_value);
        }
        if let Some(ref field_value) = obj.max_connections_percent {
            params.put(
                &format!("{}{}", prefix, "MaxConnectionsPercent"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.max_idle_connections_percent {
            params.put(
                &format!("{}{}", prefix, "MaxIdleConnectionsPercent"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.session_pinning_filters {
            StringListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "SessionPinningFilters"),
                field_value,
            );
        }
    }
}

/// <p>Displays the settings that control the size and behavior of the connection pool associated with a <code>DBProxyTarget</code>.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ConnectionPoolConfigurationInfo {
    /// <p>The number of seconds for a proxy to wait for a connection to become available in the connection pool. Only applies when the proxy has opened its maximum number of connections and all connections are busy with client sessions.</p>
    pub connection_borrow_timeout: Option<i64>,
    /// <p> One or more SQL statements for the proxy to run when opening each new database connection. Typically used with <code>SET</code> statements to make sure that each connection has identical settings such as time zone and character set. This setting is empty by default. For multiple statements, use semicolons as the separator. You can also include multiple variables in a single <code>SET</code> statement, such as <code>SET x=1, y=2</code>. </p>
    pub init_query: Option<String>,
    /// <p>The maximum size of the connection pool for each target in a target group. For Aurora MySQL, it is expressed as a percentage of the <code>max_connections</code> setting for the RDS DB instance or Aurora DB cluster used by the target group.</p>
    pub max_connections_percent: Option<i64>,
    /// <p> Controls how actively the proxy closes idle database connections in the connection pool. A high value enables the proxy to leave a high percentage of idle connections open. A low value causes the proxy to close idle client connections and return the underlying database connections to the connection pool. For Aurora MySQL, it is expressed as a percentage of the <code>max_connections</code> setting for the RDS DB instance or Aurora DB cluster used by the target group. </p>
    pub max_idle_connections_percent: Option<i64>,
    /// <p>Each item in the list represents a class of SQL operations that normally cause all later statements in a session using a proxy to be pinned to the same underlying database connection. Including an item in the list exempts that class of SQL operations from the pinning behavior. Currently, the only allowed value is <code>EXCLUDE_VARIABLE_SETS</code>.</p>
    pub session_pinning_filters: Option<Vec<String>>,
}

#[allow(dead_code)]
struct ConnectionPoolConfigurationInfoDeserializer;
impl ConnectionPoolConfigurationInfoDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ConnectionPoolConfigurationInfo, XmlParseError> {
        deserialize_elements::<_, ConnectionPoolConfigurationInfo, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "ConnectionBorrowTimeout" => {
                        obj.connection_borrow_timeout = Some(IntegerDeserializer::deserialize(
                            "ConnectionBorrowTimeout",
                            stack,
                        )?);
                    }
                    "InitQuery" => {
                        obj.init_query = Some(StringDeserializer::deserialize("InitQuery", stack)?);
                    }
                    "MaxConnectionsPercent" => {
                        obj.max_connections_percent = Some(IntegerDeserializer::deserialize(
                            "MaxConnectionsPercent",
                            stack,
                        )?);
                    }
                    "MaxIdleConnectionsPercent" => {
                        obj.max_idle_connections_percent = Some(IntegerDeserializer::deserialize(
                            "MaxIdleConnectionsPercent",
                            stack,
                        )?);
                    }
                    "SessionPinningFilters" => {
                        obj.session_pinning_filters.get_or_insert(vec![]).extend(
                            StringListDeserializer::deserialize("SessionPinningFilters", stack)?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CopyDBClusterParameterGroupMessage {
    /// <p><p>The identifier or Amazon Resource Name (ARN) for the source DB cluster parameter group. For information about creating an ARN, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing"> Constructing an ARN for Amazon RDS</a> in the <i>Amazon Aurora User Guide</i>. </p> <p>Constraints:</p> <ul> <li> <p>Must specify a valid DB cluster parameter group.</p> </li> </ul></p>
    pub source_db_cluster_parameter_group_identifier: String,
    pub tags: Option<Vec<Tag>>,
    /// <p>A description for the copied DB cluster parameter group.</p>
    pub target_db_cluster_parameter_group_description: String,
    /// <p>The identifier for the copied DB cluster parameter group.</p> <p>Constraints:</p> <ul> <li> <p>Can't be null, empty, or blank</p> </li> <li> <p>Must contain from 1 to 255 letters, numbers, or hyphens</p> </li> <li> <p>First character must be a letter</p> </li> <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li> </ul> <p>Example: <code>my-cluster-param-group1</code> </p>
    pub target_db_cluster_parameter_group_identifier: String,
}

/// Serialize `CopyDBClusterParameterGroupMessage` contents to a `SignedRequest`.
struct CopyDBClusterParameterGroupMessageSerializer;
impl CopyDBClusterParameterGroupMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CopyDBClusterParameterGroupMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "SourceDBClusterParameterGroupIdentifier"),
            &obj.source_db_cluster_parameter_group_identifier,
        );
        if let Some(ref field_value) = obj.tags {
            TagListSerializer::serialize(params, &format!("{}{}", prefix, "Tag"), field_value);
        }
        params.put(
            &format!("{}{}", prefix, "TargetDBClusterParameterGroupDescription"),
            &obj.target_db_cluster_parameter_group_description,
        );
        params.put(
            &format!("{}{}", prefix, "TargetDBClusterParameterGroupIdentifier"),
            &obj.target_db_cluster_parameter_group_identifier,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CopyDBClusterParameterGroupResult {
    pub db_cluster_parameter_group: Option<DBClusterParameterGroup>,
}

#[allow(dead_code)]
struct CopyDBClusterParameterGroupResultDeserializer;
impl CopyDBClusterParameterGroupResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CopyDBClusterParameterGroupResult, XmlParseError> {
        deserialize_elements::<_, CopyDBClusterParameterGroupResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DBClusterParameterGroup" => {
                        obj.db_cluster_parameter_group =
                            Some(DBClusterParameterGroupDeserializer::deserialize(
                                "DBClusterParameterGroup",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CopyDBClusterSnapshotMessage {
    /// <p>A value that indicates whether to copy all tags from the source DB cluster snapshot to the target DB cluster snapshot. By default, tags are not copied.</p>
    pub copy_tags: Option<bool>,
    /// <p>The Amazon Web Services KMS key identifier for an encrypted DB cluster snapshot. The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the Amazon Web Services KMS customer master key (CMK).</p> <p>If you copy an encrypted DB cluster snapshot from your Amazon Web Services account, you can specify a value for <code>KmsKeyId</code> to encrypt the copy with a new Amazon Web Services KMS CMK. If you don't specify a value for <code>KmsKeyId</code>, then the copy of the DB cluster snapshot is encrypted with the same Amazon Web Services KMS key as the source DB cluster snapshot. </p> <p>If you copy an encrypted DB cluster snapshot that is shared from another Amazon Web Services account, then you must specify a value for <code>KmsKeyId</code>. </p> <p>To copy an encrypted DB cluster snapshot to another Amazon Web Services Region, you must set <code>KmsKeyId</code> to the Amazon Web Services KMS key identifier you want to use to encrypt the copy of the DB cluster snapshot in the destination Amazon Web Services Region. Amazon Web Services KMS CMKs are specific to the Amazon Web Services Region that they are created in, and you can't use CMKs from one Amazon Web Services Region in another Amazon Web Services Region.</p> <p>If you copy an unencrypted DB cluster snapshot and specify a value for the <code>KmsKeyId</code> parameter, an error is returned.</p>
    pub kms_key_id: Option<String>,
    /// <p><p>The URL that contains a Signature Version 4 signed request for the <code>CopyDBClusterSnapshot</code> API action in the Amazon Web Services Region that contains the source DB cluster snapshot to copy. The <code>PreSignedUrl</code> parameter must be used when copying an encrypted DB cluster snapshot from another Amazon Web Services Region. Don&#39;t specify <code>PreSignedUrl</code> when you are copying an encrypted DB cluster snapshot in the same Amazon Web Services Region.</p> <p>The pre-signed URL must be a valid request for the <code>CopyDBClusterSnapshot</code> API action that can be executed in the source Amazon Web Services Region that contains the encrypted DB cluster snapshot to be copied. The pre-signed URL request must contain the following parameter values:</p> <ul> <li> <p> <code>KmsKeyId</code> - The Amazon Web Services KMS key identifier for the customer master key (CMK) to use to encrypt the copy of the DB cluster snapshot in the destination Amazon Web Services Region. This is the same identifier for both the <code>CopyDBClusterSnapshot</code> action that is called in the destination Amazon Web Services Region, and the action contained in the pre-signed URL.</p> </li> <li> <p> <code>DestinationRegion</code> - The name of the Amazon Web Services Region that the DB cluster snapshot is to be created in.</p> </li> <li> <p> <code>SourceDBClusterSnapshotIdentifier</code> - The DB cluster snapshot identifier for the encrypted DB cluster snapshot to be copied. This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web Services Region. For example, if you are copying an encrypted DB cluster snapshot from the us-west-2 Amazon Web Services Region, then your <code>SourceDBClusterSnapshotIdentifier</code> looks like the following example: <code>arn:aws:rds:us-west-2:123456789012:cluster-snapshot:aurora-cluster1-snapshot-20161115</code>.</p> </li> </ul> <p>To learn how to generate a Signature Version 4 signed request, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html"> Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html"> Signature Version 4 Signing Process</a>.</p> <note> <p>If you are using an Amazon Web Services SDK tool or the CLI, you can specify <code>SourceRegion</code> (or <code>--source-region</code> for the CLI) instead of specifying <code>PreSignedUrl</code> manually. Specifying <code>SourceRegion</code> autogenerates a pre-signed URL that is a valid request for the operation that can be executed in the source Amazon Web Services Region.</p> </note></p>
    pub pre_signed_url: Option<String>,
    /// <p>The identifier of the DB cluster snapshot to copy. This parameter isn't case-sensitive.</p> <p>You can't copy an encrypted, shared DB cluster snapshot from one Amazon Web Services Region to another.</p> <p>Constraints:</p> <ul> <li> <p>Must specify a valid system snapshot in the "available" state.</p> </li> <li> <p>If the source snapshot is in the same Amazon Web Services Region as the copy, specify a valid DB snapshot identifier.</p> </li> <li> <p>If the source snapshot is in a different Amazon Web Services Region than the copy, specify a valid DB cluster snapshot ARN. For more information, go to <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_CopySnapshot.html#USER_CopySnapshot.AcrossRegions"> Copying Snapshots Across Amazon Web Services Regions</a> in the <i>Amazon Aurora User Guide.</i> </p> </li> </ul> <p>Example: <code>my-cluster-snapshot1</code> </p>
    pub source_db_cluster_snapshot_identifier: String,
    pub tags: Option<Vec<Tag>>,
    /// <p>The identifier of the new DB cluster snapshot to create from the source DB cluster snapshot. This parameter isn't case-sensitive.</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li> </ul> <p>Example: <code>my-cluster-snapshot2</code> </p>
    pub target_db_cluster_snapshot_identifier: String,
}

/// Serialize `CopyDBClusterSnapshotMessage` contents to a `SignedRequest`.
struct CopyDBClusterSnapshotMessageSerializer;
impl CopyDBClusterSnapshotMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CopyDBClusterSnapshotMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.copy_tags {
            params.put(&format!("{}{}", prefix, "CopyTags"), &field_value);
        }
        if let Some(ref field_value) = obj.kms_key_id {
            params.put(&format!("{}{}", prefix, "KmsKeyId"), &field_value);
        }
        if let Some(ref field_value) = obj.pre_signed_url {
            params.put(&format!("{}{}", prefix, "PreSignedUrl"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "SourceDBClusterSnapshotIdentifier"),
            &obj.source_db_cluster_snapshot_identifier,
        );
        if let Some(ref field_value) = obj.tags {
            TagListSerializer::serialize(params, &format!("{}{}", prefix, "Tag"), field_value);
        }
        params.put(
            &format!("{}{}", prefix, "TargetDBClusterSnapshotIdentifier"),
            &obj.target_db_cluster_snapshot_identifier,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CopyDBClusterSnapshotResult {
    pub db_cluster_snapshot: Option<DBClusterSnapshot>,
}

#[allow(dead_code)]
struct CopyDBClusterSnapshotResultDeserializer;
impl CopyDBClusterSnapshotResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CopyDBClusterSnapshotResult, XmlParseError> {
        deserialize_elements::<_, CopyDBClusterSnapshotResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DBClusterSnapshot" => {
                        obj.db_cluster_snapshot = Some(DBClusterSnapshotDeserializer::deserialize(
                            "DBClusterSnapshot",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CopyDBParameterGroupMessage {
    /// <p><p> The identifier or ARN for the source DB parameter group. For information about creating an ARN, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing"> Constructing an ARN for Amazon RDS</a> in the <i>Amazon RDS User Guide</i>. </p> <p>Constraints:</p> <ul> <li> <p>Must specify a valid DB parameter group.</p> </li> </ul></p>
    pub source_db_parameter_group_identifier: String,
    pub tags: Option<Vec<Tag>>,
    /// <p>A description for the copied DB parameter group.</p>
    pub target_db_parameter_group_description: String,
    /// <p>The identifier for the copied DB parameter group.</p> <p>Constraints:</p> <ul> <li> <p>Can't be null, empty, or blank</p> </li> <li> <p>Must contain from 1 to 255 letters, numbers, or hyphens</p> </li> <li> <p>First character must be a letter</p> </li> <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li> </ul> <p>Example: <code>my-db-parameter-group</code> </p>
    pub target_db_parameter_group_identifier: String,
}

/// Serialize `CopyDBParameterGroupMessage` contents to a `SignedRequest`.
struct CopyDBParameterGroupMessageSerializer;
impl CopyDBParameterGroupMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CopyDBParameterGroupMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "SourceDBParameterGroupIdentifier"),
            &obj.source_db_parameter_group_identifier,
        );
        if let Some(ref field_value) = obj.tags {
            TagListSerializer::serialize(params, &format!("{}{}", prefix, "Tag"), field_value);
        }
        params.put(
            &format!("{}{}", prefix, "TargetDBParameterGroupDescription"),
            &obj.target_db_parameter_group_description,
        );
        params.put(
            &format!("{}{}", prefix, "TargetDBParameterGroupIdentifier"),
            &obj.target_db_parameter_group_identifier,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CopyDBParameterGroupResult {
    pub db_parameter_group: Option<DBParameterGroup>,
}

#[allow(dead_code)]
struct CopyDBParameterGroupResultDeserializer;
impl CopyDBParameterGroupResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CopyDBParameterGroupResult, XmlParseError> {
        deserialize_elements::<_, CopyDBParameterGroupResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DBParameterGroup" => {
                        obj.db_parameter_group = Some(DBParameterGroupDeserializer::deserialize(
                            "DBParameterGroup",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CopyDBSnapshotMessage {
    /// <p>A value that indicates whether to copy all tags from the source DB snapshot to the target DB snapshot. By default, tags are not copied.</p>
    pub copy_tags: Option<bool>,
    /// <p>The Amazon Web Services KMS key identifier for an encrypted DB snapshot. The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the Amazon Web Services KMS customer master key (CMK). </p> <p>If you copy an encrypted DB snapshot from your Amazon Web Services account, you can specify a value for this parameter to encrypt the copy with a new Amazon Web Services KMS CMK. If you don't specify a value for this parameter, then the copy of the DB snapshot is encrypted with the same Amazon Web Services KMS key as the source DB snapshot. </p> <p>If you copy an encrypted DB snapshot that is shared from another Amazon Web Services account, then you must specify a value for this parameter. </p> <p>If you specify this parameter when you copy an unencrypted snapshot, the copy is encrypted. </p> <p>If you copy an encrypted snapshot to a different Amazon Web Services Region, then you must specify a Amazon Web Services KMS key identifier for the destination Amazon Web Services Region. Amazon Web Services KMS CMKs are specific to the Amazon Web Services Region that they are created in, and you can't use CMKs from one Amazon Web Services Region in another Amazon Web Services Region. </p>
    pub kms_key_id: Option<String>,
    /// <p>The name of an option group to associate with the copy of the snapshot.</p> <p>Specify this option if you are copying a snapshot from one Amazon Web Services Region to another, and your DB instance uses a nondefault option group. If your source DB instance uses Transparent Data Encryption for Oracle or Microsoft SQL Server, you must specify this option when copying across Amazon Web Services Regions. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CopySnapshot.html#USER_CopySnapshot.Options">Option group considerations</a> in the <i>Amazon RDS User Guide.</i> </p>
    pub option_group_name: Option<String>,
    /// <p><p>The URL that contains a Signature Version 4 signed request for the <code>CopyDBSnapshot</code> API action in the source Amazon Web Services Region that contains the source DB snapshot to copy. </p> <p>You must specify this parameter when you copy an encrypted DB snapshot from another Amazon Web Services Region by using the Amazon RDS API. Don&#39;t specify <code>PreSignedUrl</code> when you are copying an encrypted DB snapshot in the same Amazon Web Services Region.</p> <p>The presigned URL must be a valid request for the <code>CopyDBSnapshot</code> API action that can be executed in the source Amazon Web Services Region that contains the encrypted DB snapshot to be copied. The presigned URL request must contain the following parameter values: </p> <ul> <li> <p> <code>DestinationRegion</code> - The Amazon Web Services Region that the encrypted DB snapshot is copied to. This Amazon Web Services Region is the same one where the <code>CopyDBSnapshot</code> action is called that contains this presigned URL. </p> <p>For example, if you copy an encrypted DB snapshot from the us-west-2 Amazon Web Services Region to the us-east-1 Amazon Web Services Region, then you call the <code>CopyDBSnapshot</code> action in the us-east-1 Amazon Web Services Region and provide a presigned URL that contains a call to the <code>CopyDBSnapshot</code> action in the us-west-2 Amazon Web Services Region. For this example, the <code>DestinationRegion</code> in the presigned URL must be set to the us-east-1 Amazon Web Services Region. </p> </li> <li> <p> <code>KmsKeyId</code> - The Amazon Web Services KMS key identifier for the customer master key (CMK) to use to encrypt the copy of the DB snapshot in the destination Amazon Web Services Region. This is the same identifier for both the <code>CopyDBSnapshot</code> action that is called in the destination Amazon Web Services Region, and the action contained in the presigned URL. </p> </li> <li> <p> <code>SourceDBSnapshotIdentifier</code> - The DB snapshot identifier for the encrypted snapshot to be copied. This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web Services Region. For example, if you are copying an encrypted DB snapshot from the us-west-2 Amazon Web Services Region, then your <code>SourceDBSnapshotIdentifier</code> looks like the following example: <code>arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20161115</code>. </p> </li> </ul> <p>To learn how to generate a Signature Version 4 signed request, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html">Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 Signing Process</a>. </p> <note> <p>If you are using an Amazon Web Services SDK tool or the CLI, you can specify <code>SourceRegion</code> (or <code>--source-region</code> for the CLI) instead of specifying <code>PreSignedUrl</code> manually. Specifying <code>SourceRegion</code> autogenerates a pre-signed URL that is a valid request for the operation that can be executed in the source Amazon Web Services Region.</p> </note></p>
    pub pre_signed_url: Option<String>,
    /// <p>The identifier for the source DB snapshot.</p> <p>If the source snapshot is in the same Amazon Web Services Region as the copy, specify a valid DB snapshot identifier. For example, you might specify <code>rds:mysql-instance1-snapshot-20130805</code>. </p> <p>If the source snapshot is in a different Amazon Web Services Region than the copy, specify a valid DB snapshot ARN. For example, you might specify <code>arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20130805</code>. </p> <p>If you are copying from a shared manual DB snapshot, this parameter must be the Amazon Resource Name (ARN) of the shared DB snapshot. </p> <p>If you are copying an encrypted snapshot this parameter must be in the ARN format for the source Amazon Web Services Region, and must match the <code>SourceDBSnapshotIdentifier</code> in the <code>PreSignedUrl</code> parameter. </p> <p>Constraints:</p> <ul> <li> <p>Must specify a valid system snapshot in the "available" state.</p> </li> </ul> <p>Example: <code>rds:mydb-2012-04-02-00-01</code> </p> <p>Example: <code>arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20130805</code> </p>
    pub source_db_snapshot_identifier: String,
    pub tags: Option<Vec<Tag>>,
    /// <p>The external custom Availability Zone (CAZ) identifier for the target CAZ.</p> <p>Example: <code>rds-caz-aiqhTgQv</code>.</p>
    pub target_custom_availability_zone: Option<String>,
    /// <p>The identifier for the copy of the snapshot. </p> <p>Constraints:</p> <ul> <li> <p>Can't be null, empty, or blank</p> </li> <li> <p>Must contain from 1 to 255 letters, numbers, or hyphens</p> </li> <li> <p>First character must be a letter</p> </li> <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li> </ul> <p>Example: <code>my-db-snapshot</code> </p>
    pub target_db_snapshot_identifier: String,
}

/// Serialize `CopyDBSnapshotMessage` contents to a `SignedRequest`.
struct CopyDBSnapshotMessageSerializer;
impl CopyDBSnapshotMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CopyDBSnapshotMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.copy_tags {
            params.put(&format!("{}{}", prefix, "CopyTags"), &field_value);
        }
        if let Some(ref field_value) = obj.kms_key_id {
            params.put(&format!("{}{}", prefix, "KmsKeyId"), &field_value);
        }
        if let Some(ref field_value) = obj.option_group_name {
            params.put(&format!("{}{}", prefix, "OptionGroupName"), &field_value);
        }
        if let Some(ref field_value) = obj.pre_signed_url {
            params.put(&format!("{}{}", prefix, "PreSignedUrl"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "SourceDBSnapshotIdentifier"),
            &obj.source_db_snapshot_identifier,
        );
        if let Some(ref field_value) = obj.tags {
            TagListSerializer::serialize(params, &format!("{}{}", prefix, "Tag"), field_value);
        }
        if let Some(ref field_value) = obj.target_custom_availability_zone {
            params.put(
                &format!("{}{}", prefix, "TargetCustomAvailabilityZone"),
                &field_value,
            );
        }
        params.put(
            &format!("{}{}", prefix, "TargetDBSnapshotIdentifier"),
            &obj.target_db_snapshot_identifier,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CopyDBSnapshotResult {
    pub db_snapshot: Option<DBSnapshot>,
}

#[allow(dead_code)]
struct CopyDBSnapshotResultDeserializer;
impl CopyDBSnapshotResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CopyDBSnapshotResult, XmlParseError> {
        deserialize_elements::<_, CopyDBSnapshotResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "DBSnapshot" => {
                    obj.db_snapshot =
                        Some(DBSnapshotDeserializer::deserialize("DBSnapshot", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CopyOptionGroupMessage {
    /// <p><p>The identifier for the source option group. </p> <p>Constraints:</p> <ul> <li> <p>Must specify a valid option group.</p> </li> </ul></p>
    pub source_option_group_identifier: String,
    pub tags: Option<Vec<Tag>>,
    /// <p>The description for the copied option group.</p>
    pub target_option_group_description: String,
    /// <p>The identifier for the copied option group.</p> <p>Constraints:</p> <ul> <li> <p>Can't be null, empty, or blank</p> </li> <li> <p>Must contain from 1 to 255 letters, numbers, or hyphens</p> </li> <li> <p>First character must be a letter</p> </li> <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li> </ul> <p>Example: <code>my-option-group</code> </p>
    pub target_option_group_identifier: String,
}

/// Serialize `CopyOptionGroupMessage` contents to a `SignedRequest`.
struct CopyOptionGroupMessageSerializer;
impl CopyOptionGroupMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CopyOptionGroupMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "SourceOptionGroupIdentifier"),
            &obj.source_option_group_identifier,
        );
        if let Some(ref field_value) = obj.tags {
            TagListSerializer::serialize(params, &format!("{}{}", prefix, "Tag"), field_value);
        }
        params.put(
            &format!("{}{}", prefix, "TargetOptionGroupDescription"),
            &obj.target_option_group_description,
        );
        params.put(
            &format!("{}{}", prefix, "TargetOptionGroupIdentifier"),
            &obj.target_option_group_identifier,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CopyOptionGroupResult {
    pub option_group: Option<OptionGroup>,
}

#[allow(dead_code)]
struct CopyOptionGroupResultDeserializer;
impl CopyOptionGroupResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CopyOptionGroupResult, XmlParseError> {
        deserialize_elements::<_, CopyOptionGroupResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "OptionGroup" => {
                    obj.option_group =
                        Some(OptionGroupDeserializer::deserialize("OptionGroup", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateCustomAvailabilityZoneMessage {
    /// <p>The name of the custom Availability Zone (AZ).</p>
    pub custom_availability_zone_name: String,
    /// <p>The ID of an existing virtual private network (VPN) between the Amazon RDS website and the VMware vSphere cluster.</p>
    pub existing_vpn_id: Option<String>,
    /// <p>The name of a new VPN tunnel between the Amazon RDS website and the VMware vSphere cluster.</p> <p>Specify this parameter only if <code>ExistingVpnId</code> isn't specified.</p>
    pub new_vpn_tunnel_name: Option<String>,
    /// <p>The IP address of network traffic from your on-premises data center. A custom AZ receives the network traffic.</p> <p>Specify this parameter only if <code>ExistingVpnId</code> isn't specified.</p>
    pub vpn_tunnel_originator_ip: Option<String>,
}

/// Serialize `CreateCustomAvailabilityZoneMessage` contents to a `SignedRequest`.
struct CreateCustomAvailabilityZoneMessageSerializer;
impl CreateCustomAvailabilityZoneMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateCustomAvailabilityZoneMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "CustomAvailabilityZoneName"),
            &obj.custom_availability_zone_name,
        );
        if let Some(ref field_value) = obj.existing_vpn_id {
            params.put(&format!("{}{}", prefix, "ExistingVpnId"), &field_value);
        }
        if let Some(ref field_value) = obj.new_vpn_tunnel_name {
            params.put(&format!("{}{}", prefix, "NewVpnTunnelName"), &field_value);
        }
        if let Some(ref field_value) = obj.vpn_tunnel_originator_ip {
            params.put(
                &format!("{}{}", prefix, "VpnTunnelOriginatorIP"),
                &field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateCustomAvailabilityZoneResult {
    pub custom_availability_zone: Option<CustomAvailabilityZone>,
}

#[allow(dead_code)]
struct CreateCustomAvailabilityZoneResultDeserializer;
impl CreateCustomAvailabilityZoneResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateCustomAvailabilityZoneResult, XmlParseError> {
        deserialize_elements::<_, CreateCustomAvailabilityZoneResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "CustomAvailabilityZone" => {
                        obj.custom_availability_zone =
                            Some(CustomAvailabilityZoneDeserializer::deserialize(
                                "CustomAvailabilityZone",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateDBClusterEndpointMessage {
    /// <p>The identifier to use for the new endpoint. This parameter is stored as a lowercase string.</p>
    pub db_cluster_endpoint_identifier: String,
    /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase string.</p>
    pub db_cluster_identifier: String,
    /// <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>
    pub endpoint_type: String,
    /// <p>List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.</p>
    pub excluded_members: Option<Vec<String>>,
    /// <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
    pub static_members: Option<Vec<String>>,
    /// <p>The tags to be assigned to the Amazon RDS resource.</p>
    pub tags: Option<Vec<Tag>>,
}

/// Serialize `CreateDBClusterEndpointMessage` contents to a `SignedRequest`.
struct CreateDBClusterEndpointMessageSerializer;
impl CreateDBClusterEndpointMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateDBClusterEndpointMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "DBClusterEndpointIdentifier"),
            &obj.db_cluster_endpoint_identifier,
        );
        params.put(
            &format!("{}{}", prefix, "DBClusterIdentifier"),
            &obj.db_cluster_identifier,
        );
        params.put(&format!("{}{}", prefix, "EndpointType"), &obj.endpoint_type);
        if let Some(ref field_value) = obj.excluded_members {
            StringListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "ExcludedMembers"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.static_members {
            StringListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "StaticMembers"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.tags {
            TagListSerializer::serialize(params, &format!("{}{}", prefix, "Tag"), field_value);
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateDBClusterMessage {
    /// <p>A list of Availability Zones (AZs) where instances in the DB cluster can be created. For information on Amazon Web Services Regions and Availability Zones, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.RegionsAndAvailabilityZones.html">Choosing the Regions and Availability Zones</a> in the <i>Amazon Aurora User Guide</i>. </p>
    pub availability_zones: Option<Vec<String>>,
    /// <p><p>The target backtrack window, in seconds. To disable backtracking, set this value to 0. </p> <note> <p>Currently, Backtrack is only supported for Aurora MySQL DB clusters.</p> </note> <p>Default: 0</p> <p>Constraints:</p> <ul> <li> <p>If specified, this value must be set to a number from 0 to 259,200 (72 hours).</p> </li> </ul></p>
    pub backtrack_window: Option<i64>,
    /// <p><p>The number of days for which automated backups are retained.</p> <p>Default: 1</p> <p>Constraints:</p> <ul> <li> <p>Must be a value from 1 to 35</p> </li> </ul></p>
    pub backup_retention_period: Option<i64>,
    /// <p>A value that indicates that the DB cluster should be associated with the specified CharacterSet.</p>
    pub character_set_name: Option<String>,
    /// <p>A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster. The default is not to copy them.</p>
    pub copy_tags_to_snapshot: Option<bool>,
    /// <p>The DB cluster identifier. This parameter is stored as a lowercase string.</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li> </ul> <p>Example: <code>my-cluster1</code> </p>
    pub db_cluster_identifier: String,
    /// <p><p> The name of the DB cluster parameter group to associate with this DB cluster. If you do not specify a value, then the default DB cluster parameter group for the specified DB engine and version is used. </p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match the name of an existing DB cluster parameter group.</p> </li> </ul></p>
    pub db_cluster_parameter_group_name: Option<String>,
    /// <p>A DB subnet group to associate with this DB cluster.</p> <p>Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.</p> <p>Example: <code>mySubnetgroup</code> </p>
    pub db_subnet_group_name: Option<String>,
    /// <p>The name for your database of up to 64 alphanumeric characters. If you do not provide a name, Amazon RDS doesn't create a database in the DB cluster you are creating.</p>
    pub database_name: Option<String>,
    /// <p>A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled.</p>
    pub deletion_protection: Option<bool>,
    /// <p>The Active Directory directory ID to create the DB cluster in.</p> <p> For Amazon Aurora DB clusters, Amazon RDS can use Kerberos Authentication to authenticate users that connect to the DB cluster. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html">Kerberos Authentication</a> in the <i>Amazon Aurora User Guide</i>. </p>
    pub domain: Option<String>,
    /// <p>Specify the name of the IAM role to be used when making API calls to the Directory Service.</p>
    pub domain_iam_role_name: Option<String>,
    /// <p>The list of log types that need to be enabled for exporting to CloudWatch Logs. The values in the list depend on the DB engine being used. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Aurora User Guide</i>.</p> <p> <b>Aurora MySQL</b> </p> <p>Possible values are <code>audit</code>, <code>error</code>, <code>general</code>, and <code>slowquery</code>. </p> <p> <b>Aurora PostgreSQL</b> </p> <p>Possible value is <code>postgresql</code>. </p>
    pub enable_cloudwatch_logs_exports: Option<Vec<String>>,
    /// <p>A value that indicates whether to enable this DB cluster to forward write operations to the primary cluster of an Aurora global database (<a>GlobalCluster</a>). By default, write operations are not allowed on Aurora DB clusters that are secondary clusters in an Aurora global database.</p> <p>You can set this value only on Aurora DB clusters that are members of an Aurora global database. With this parameter enabled, a secondary cluster can forward writes to the current primary cluster and the resulting changes are replicated back to this cluster. For the primary DB cluster of an Aurora global database, this value is used immediately if the primary is demoted by the <a>FailoverGlobalCluster</a> API operation, but it does nothing until then. </p>
    pub enable_global_write_forwarding: Option<bool>,
    /// <p>A value that indicates whether to enable the HTTP endpoint for an Aurora Serverless DB cluster. By default, the HTTP endpoint is disabled.</p> <p>When enabled, the HTTP endpoint provides a connectionless web service API for running SQL queries on the Aurora Serverless DB cluster. You can also query your database from inside the RDS console with the query editor.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using the Data API for Aurora Serverless</a> in the <i>Amazon Aurora User Guide</i>.</p>
    pub enable_http_endpoint: Option<bool>,
    /// <p>A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping is disabled.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database Authentication</a> in the <i>Amazon Aurora User Guide.</i> </p>
    pub enable_iam_database_authentication: Option<bool>,
    /// <p>The name of the database engine to be used for this DB cluster.</p> <p>Valid Values: <code>aurora</code> (for MySQL 5.6-compatible Aurora), <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora), and <code>aurora-postgresql</code> </p>
    pub engine: String,
    /// <p><p>The DB engine mode of the DB cluster, either <code>provisioned</code>, <code>serverless</code>, <code>parallelquery</code>, <code>global</code>, or <code>multimaster</code>.</p> <p>The <code>parallelquery</code> engine mode isn&#39;t required for Aurora MySQL version 1.23 and higher 1.x versions, and version 2.09 and higher 2.x versions.</p> <p>The <code>global</code> engine mode isn&#39;t required for Aurora MySQL version 1.22 and higher 1.x versions, and <code>global</code> engine mode isn&#39;t required for any 2.x versions.</p> <p>The <code>multimaster</code> engine mode only applies for DB clusters created with Aurora MySQL version 5.6.10a.</p> <p>For Aurora PostgreSQL, the <code>global</code> engine mode isn&#39;t required, and both the <code>parallelquery</code> and the <code>multimaster</code> engine modes currently aren&#39;t supported.</p> <p>Limitations and requirements apply to some DB engine modes. For more information, see the following sections in the <i>Amazon Aurora User Guide</i>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html#aurora-serverless.limitations"> Limitations of Aurora Serverless</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-mysql-parallel-query.html#aurora-mysql-parallel-query-limitations"> Limitations of Parallel Query</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database.html#aurora-global-database.limitations"> Limitations of Aurora Global Databases</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-multi-master.html#aurora-multi-master-limitations"> Limitations of Multi-Master Clusters</a> </p> </li> </ul></p>
    pub engine_mode: Option<String>,
    /// <p>The version number of the database engine to use.</p> <p>To list all of the available engine versions for <code>aurora</code> (for MySQL 5.6-compatible Aurora), use the following command:</p> <p> <code>aws rds describe-db-engine-versions --engine aurora --query "DBEngineVersions[].EngineVersion"</code> </p> <p>To list all of the available engine versions for <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora), use the following command:</p> <p> <code>aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"</code> </p> <p>To list all of the available engine versions for <code>aurora-postgresql</code>, use the following command:</p> <p> <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"</code> </p> <p> <b>Aurora MySQL</b> </p> <p>Example: <code>5.6.10a</code>, <code>5.6.mysql_aurora.1.19.2</code>, <code>5.7.12</code>, <code>5.7.mysql_aurora.2.04.5</code> </p> <p> <b>Aurora PostgreSQL</b> </p> <p>Example: <code>9.6.3</code>, <code>10.7</code> </p>
    pub engine_version: Option<String>,
    /// <p> The global cluster ID of an Aurora cluster that becomes the primary cluster in the new global database cluster. </p>
    pub global_cluster_identifier: Option<String>,
    /// <p>The Amazon Web Services KMS key identifier for an encrypted DB cluster.</p> <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the Amazon Web Services KMS customer master key (CMK). To use a CMK in a different Amazon Web Services account, specify the key ARN or alias ARN.</p> <p>When a CMK isn't specified in <code>KmsKeyId</code>:</p> <ul> <li> <p>If <code>ReplicationSourceIdentifier</code> identifies an encrypted source, then Amazon RDS will use the CMK used to encrypt the source. Otherwise, Amazon RDS will use your default CMK. </p> </li> <li> <p>If the <code>StorageEncrypted</code> parameter is enabled and <code>ReplicationSourceIdentifier</code> isn't specified, then Amazon RDS will use your default CMK.</p> </li> </ul> <p>There is a default CMK for your Amazon Web Services account. Your Amazon Web Services account has a different default CMK for each Amazon Web Services Region.</p> <p>If you create a read replica of an encrypted DB cluster in another Amazon Web Services Region, you must set <code>KmsKeyId</code> to a Amazon Web Services KMS key identifier that is valid in the destination Amazon Web Services Region. This CMK is used to encrypt the read replica in that Amazon Web Services Region.</p>
    pub kms_key_id: Option<String>,
    /// <p>The password for the master database user. This password can contain any printable ASCII character except "/", """, or "@".</p> <p>Constraints: Must contain from 8 to 41 characters.</p>
    pub master_user_password: Option<String>,
    /// <p><p>The name of the master user for the DB cluster.</p> <p>Constraints:</p> <ul> <li> <p>Must be 1 to 16 letters or numbers.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Can&#39;t be a reserved word for the chosen database engine.</p> </li> </ul></p>
    pub master_username: Option<String>,
    /// <p>A value that indicates that the DB cluster should be associated with the specified option group.</p> <p>Permanent options can't be removed from an option group. The option group can't be removed from a DB cluster once it is associated with a DB cluster.</p>
    pub option_group_name: Option<String>,
    /// <p>The port number on which the instances in the DB cluster accept connections.</p> <p> Default: <code>3306</code> if engine is set as aurora or <code>5432</code> if set to aurora-postgresql. </p>
    pub port: Option<i64>,
    /// <p><p>A URL that contains a Signature Version 4 signed request for the <code>CreateDBCluster</code> action to be called in the source Amazon Web Services Region where the DB cluster is replicated from. You only need to specify <code>PreSignedUrl</code> when you are performing cross-region replication from an encrypted DB cluster.</p> <p>The pre-signed URL must be a valid request for the <code>CreateDBCluster</code> API action that can be executed in the source Amazon Web Services Region that contains the encrypted DB cluster to be copied.</p> <p>The pre-signed URL request must contain the following parameter values:</p> <ul> <li> <p> <code>KmsKeyId</code> - The Amazon Web Services KMS key identifier for the key to use to encrypt the copy of the DB cluster in the destination Amazon Web Services Region. This should refer to the same Amazon Web Services KMS CMK for both the <code>CreateDBCluster</code> action that is called in the destination Amazon Web Services Region, and the action contained in the pre-signed URL.</p> </li> <li> <p> <code>DestinationRegion</code> - The name of the Amazon Web Services Region that Aurora read replica will be created in.</p> </li> <li> <p> <code>ReplicationSourceIdentifier</code> - The DB cluster identifier for the encrypted DB cluster to be copied. This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web Services Region. For example, if you are copying an encrypted DB cluster from the us-west-2 Amazon Web Services Region, then your <code>ReplicationSourceIdentifier</code> would look like Example: <code>arn:aws:rds:us-west-2:123456789012:cluster:aurora-cluster1</code>.</p> </li> </ul> <p>To learn how to generate a Signature Version 4 signed request, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html"> Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html"> Signature Version 4 Signing Process</a>.</p> <note> <p>If you are using an Amazon Web Services SDK tool or the CLI, you can specify <code>SourceRegion</code> (or <code>--source-region</code> for the CLI) instead of specifying <code>PreSignedUrl</code> manually. Specifying <code>SourceRegion</code> autogenerates a pre-signed URL that is a valid request for the operation that can be executed in the source Amazon Web Services Region.</p> </note></p>
    pub pre_signed_url: Option<String>,
    /// <p><p>The daily time range during which automated backups are created if automated backups are enabled using the <code>BackupRetentionPeriod</code> parameter. </p> <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region. To view the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow"> Backup window</a> in the <i>Amazon Aurora User Guide.</i> </p> <p>Constraints:</p> <ul> <li> <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p> </li> <li> <p>Must be in Universal Coordinated Time (UTC).</p> </li> <li> <p>Must not conflict with the preferred maintenance window.</p> </li> <li> <p>Must be at least 30 minutes.</p> </li> </ul></p>
    pub preferred_backup_window: Option<String>,
    /// <p>The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p> <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code> </p> <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region, occurring on a random day of the week. To see the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora"> Adjusting the Preferred DB Cluster Maintenance Window</a> in the <i>Amazon Aurora User Guide.</i> </p> <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p> <p>Constraints: Minimum 30-minute window.</p>
    pub preferred_maintenance_window: Option<String>,
    /// <p>The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB cluster is created as a read replica.</p>
    pub replication_source_identifier: Option<String>,
    /// <p>For DB clusters in <code>serverless</code> DB engine mode, the scaling properties of the DB cluster.</p>
    pub scaling_configuration: Option<ScalingConfiguration>,
    /// <p>A value that indicates whether the DB cluster is encrypted.</p>
    pub storage_encrypted: Option<bool>,
    /// <p>Tags to assign to the DB cluster.</p>
    pub tags: Option<Vec<Tag>>,
    /// <p>A list of EC2 VPC security groups to associate with this DB cluster.</p>
    pub vpc_security_group_ids: Option<Vec<String>>,
}

/// Serialize `CreateDBClusterMessage` contents to a `SignedRequest`.
struct CreateDBClusterMessageSerializer;
impl CreateDBClusterMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateDBClusterMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.availability_zones {
            AvailabilityZonesSerializer::serialize(
                params,
                &format!("{}{}", prefix, "AvailabilityZone"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.backtrack_window {
            params.put(&format!("{}{}", prefix, "BacktrackWindow"), &field_value);
        }
        if let Some(ref field_value) = obj.backup_retention_period {
            params.put(
                &format!("{}{}", prefix, "BackupRetentionPeriod"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.character_set_name {
            params.put(&format!("{}{}", prefix, "CharacterSetName"), &field_value);
        }
        if let Some(ref field_value) = obj.copy_tags_to_snapshot {
            params.put(&format!("{}{}", prefix, "CopyTagsToSnapshot"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "DBClusterIdentifier"),
            &obj.db_cluster_identifier,
        );
        if let Some(ref field_value) = obj.db_cluster_parameter_group_name {
            params.put(
                &format!("{}{}", prefix, "DBClusterParameterGroupName"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.db_subnet_group_name {
            params.put(&format!("{}{}", prefix, "DBSubnetGroupName"), &field_value);
        }
        if let Some(ref field_value) = obj.database_name {
            params.put(&format!("{}{}", prefix, "DatabaseName"), &field_value);
        }
        if let Some(ref field_value) = obj.deletion_protection {
            params.put(&format!("{}{}", prefix, "DeletionProtection"), &field_value);
        }
        if let Some(ref field_value) = obj.domain {
            params.put(&format!("{}{}", prefix, "Domain"), &field_value);
        }
        if let Some(ref field_value) = obj.domain_iam_role_name {
            params.put(&format!("{}{}", prefix, "DomainIAMRoleName"), &field_value);
        }
        if let Some(ref field_value) = obj.enable_cloudwatch_logs_exports {
            LogTypeListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "EnableCloudwatchLogsExports"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.enable_global_write_forwarding {
            params.put(
                &format!("{}{}", prefix, "EnableGlobalWriteForwarding"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.enable_http_endpoint {
            params.put(&format!("{}{}", prefix, "EnableHttpEndpoint"), &field_value);
        }
        if let Some(ref field_value) = obj.enable_iam_database_authentication {
            params.put(
                &format!("{}{}", prefix, "EnableIAMDatabaseAuthentication"),
                &field_value,
            );
        }
        params.put(&format!("{}{}", prefix, "Engine"), &obj.engine);
        if let Some(ref field_value) = obj.engine_mode {
            params.put(&format!("{}{}", prefix, "EngineMode"), &field_value);
        }
        if let Some(ref field_value) = obj.engine_version {
            params.put(&format!("{}{}", prefix, "EngineVersion"), &field_value);
        }
        if let Some(ref field_value) = obj.global_cluster_identifier {
            params.put(
                &format!("{}{}", prefix, "GlobalClusterIdentifier"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.kms_key_id {
            params.put(&format!("{}{}", prefix, "KmsKeyId"), &field_value);
        }
        if let Some(ref field_value) = obj.master_user_password {
            params.put(&format!("{}{}", prefix, "MasterUserPassword"), &field_value);
        }
        if let Some(ref field_value) = obj.master_username {
            params.put(&format!("{}{}", prefix, "MasterUsername"), &field_value);
        }
        if let Some(ref field_value) = obj.option_group_name {
            params.put(&format!("{}{}", prefix, "OptionGroupName"), &field_value);
        }
        if let Some(ref field_value) = obj.port {
            params.put(&format!("{}{}", prefix, "Port"), &field_value);
        }
        if let Some(ref field_value) = obj.pre_signed_url {
            params.put(&format!("{}{}", prefix, "PreSignedUrl"), &field_value);
        }
        if let Some(ref field_value) = obj.preferred_backup_window {
            params.put(
                &format!("{}{}", prefix, "PreferredBackupWindow"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.preferred_maintenance_window {
            params.put(
                &format!("{}{}", prefix, "PreferredMaintenanceWindow"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.replication_source_identifier {
            params.put(
                &format!("{}{}", prefix, "ReplicationSourceIdentifier"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.scaling_configuration {
            ScalingConfigurationSerializer::serialize(
                params,
                &format!("{}{}", prefix, "ScalingConfiguration"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.storage_encrypted {
            params.put(&format!("{}{}", prefix, "StorageEncrypted"), &field_value);
        }
        if let Some(ref field_value) = obj.tags {
            TagListSerializer::serialize(params, &format!("{}{}", prefix, "Tag"), field_value);
        }
        if let Some(ref field_value) = obj.vpc_security_group_ids {
            VpcSecurityGroupIdListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "VpcSecurityGroupId"),
                field_value,
            );
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateDBClusterParameterGroupMessage {
    /// <p><p>The name of the DB cluster parameter group.</p> <p>Constraints:</p> <ul> <li> <p>Must match the name of an existing DB cluster parameter group.</p> </li> </ul> <note> <p>This value is stored as a lowercase string.</p> </note></p>
    pub db_cluster_parameter_group_name: String,
    /// <p><p>The DB cluster parameter group family name. A DB cluster parameter group can be associated with one and only one DB cluster parameter group family, and can be applied only to a DB cluster running a database engine and engine version compatible with that DB cluster parameter group family.</p> <p> <b>Aurora MySQL</b> </p> <p>Example: <code>aurora5.6</code>, <code>aurora-mysql5.7</code> </p> <p> <b>Aurora PostgreSQL</b> </p> <p>Example: <code>aurora-postgresql9.6</code> </p> <p>To list all of the available parameter group families for a DB engine, use the following command:</p> <p> <code>aws rds describe-db-engine-versions --query &quot;DBEngineVersions[].DBParameterGroupFamily&quot; --engine &lt;engine&gt;</code> </p> <p>For example, to list all of the available parameter group families for the Aurora PostgreSQL DB engine, use the following command:</p> <p> <code>aws rds describe-db-engine-versions --query &quot;DBEngineVersions[].DBParameterGroupFamily&quot; --engine aurora-postgresql</code> </p> <note> <p>The output contains duplicates.</p> </note> <p>The following are the valid DB engine values:</p> <ul> <li> <p> <code>aurora</code> (for MySQL 5.6-compatible Aurora)</p> </li> <li> <p> <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora)</p> </li> <li> <p> <code>aurora-postgresql</code> </p> </li> </ul></p>
    pub db_parameter_group_family: String,
    /// <p>The description for the DB cluster parameter group.</p>
    pub description: String,
    /// <p>Tags to assign to the DB cluster parameter group.</p>
    pub tags: Option<Vec<Tag>>,
}

/// Serialize `CreateDBClusterParameterGroupMessage` contents to a `SignedRequest`.
struct CreateDBClusterParameterGroupMessageSerializer;
impl CreateDBClusterParameterGroupMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateDBClusterParameterGroupMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "DBClusterParameterGroupName"),
            &obj.db_cluster_parameter_group_name,
        );
        params.put(
            &format!("{}{}", prefix, "DBParameterGroupFamily"),
            &obj.db_parameter_group_family,
        );
        params.put(&format!("{}{}", prefix, "Description"), &obj.description);
        if let Some(ref field_value) = obj.tags {
            TagListSerializer::serialize(params, &format!("{}{}", prefix, "Tag"), field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateDBClusterParameterGroupResult {
    pub db_cluster_parameter_group: Option<DBClusterParameterGroup>,
}

#[allow(dead_code)]
struct CreateDBClusterParameterGroupResultDeserializer;
impl CreateDBClusterParameterGroupResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateDBClusterParameterGroupResult, XmlParseError> {
        deserialize_elements::<_, CreateDBClusterParameterGroupResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DBClusterParameterGroup" => {
                        obj.db_cluster_parameter_group =
                            Some(DBClusterParameterGroupDeserializer::deserialize(
                                "DBClusterParameterGroup",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateDBClusterResult {
    pub db_cluster: Option<DBCluster>,
}

#[allow(dead_code)]
struct CreateDBClusterResultDeserializer;
impl CreateDBClusterResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateDBClusterResult, XmlParseError> {
        deserialize_elements::<_, CreateDBClusterResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "DBCluster" => {
                    obj.db_cluster = Some(DBClusterDeserializer::deserialize("DBCluster", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateDBClusterSnapshotMessage {
    /// <p>The identifier of the DB cluster to create a snapshot for. This parameter isn't case-sensitive.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing DBCluster.</p> </li> </ul> <p>Example: <code>my-cluster1</code> </p>
    pub db_cluster_identifier: String,
    /// <p>The identifier of the DB cluster snapshot. This parameter is stored as a lowercase string.</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li> </ul> <p>Example: <code>my-cluster1-snapshot1</code> </p>
    pub db_cluster_snapshot_identifier: String,
    /// <p>The tags to be assigned to the DB cluster snapshot.</p>
    pub tags: Option<Vec<Tag>>,
}

/// Serialize `CreateDBClusterSnapshotMessage` contents to a `SignedRequest`.
struct CreateDBClusterSnapshotMessageSerializer;
impl CreateDBClusterSnapshotMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateDBClusterSnapshotMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "DBClusterIdentifier"),
            &obj.db_cluster_identifier,
        );
        params.put(
            &format!("{}{}", prefix, "DBClusterSnapshotIdentifier"),
            &obj.db_cluster_snapshot_identifier,
        );
        if let Some(ref field_value) = obj.tags {
            TagListSerializer::serialize(params, &format!("{}{}", prefix, "Tag"), field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateDBClusterSnapshotResult {
    pub db_cluster_snapshot: Option<DBClusterSnapshot>,
}

#[allow(dead_code)]
struct CreateDBClusterSnapshotResultDeserializer;
impl CreateDBClusterSnapshotResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateDBClusterSnapshotResult, XmlParseError> {
        deserialize_elements::<_, CreateDBClusterSnapshotResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DBClusterSnapshot" => {
                        obj.db_cluster_snapshot = Some(DBClusterSnapshotDeserializer::deserialize(
                            "DBClusterSnapshot",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateDBInstanceMessage {
    /// <p><p>The amount of storage (in gibibytes) to allocate for the DB instance.</p> <p>Type: Integer</p> <p> <b>Amazon Aurora</b> </p> <p>Not applicable. Aurora cluster volumes automatically grow as the amount of data in your database increases, though you are only charged for the space that you use in an Aurora cluster volume.</p> <p> <b>MySQL</b> </p> <p>Constraints to the amount of storage for each storage type are the following: </p> <ul> <li> <p>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</p> </li> <li> <p>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</p> </li> <li> <p>Magnetic storage (standard): Must be an integer from 5 to 3072.</p> </li> </ul> <p> <b>MariaDB</b> </p> <p>Constraints to the amount of storage for each storage type are the following: </p> <ul> <li> <p>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</p> </li> <li> <p>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</p> </li> <li> <p>Magnetic storage (standard): Must be an integer from 5 to 3072.</p> </li> </ul> <p> <b>PostgreSQL</b> </p> <p>Constraints to the amount of storage for each storage type are the following: </p> <ul> <li> <p>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</p> </li> <li> <p>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</p> </li> <li> <p>Magnetic storage (standard): Must be an integer from 5 to 3072.</p> </li> </ul> <p> <b>Oracle</b> </p> <p>Constraints to the amount of storage for each storage type are the following: </p> <ul> <li> <p>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</p> </li> <li> <p>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</p> </li> <li> <p>Magnetic storage (standard): Must be an integer from 10 to 3072.</p> </li> </ul> <p> <b>SQL Server</b> </p> <p>Constraints to the amount of storage for each storage type are the following: </p> <ul> <li> <p>General Purpose (SSD) storage (gp2):</p> <ul> <li> <p>Enterprise and Standard editions: Must be an integer from 200 to 16384.</p> </li> <li> <p>Web and Express editions: Must be an integer from 20 to 16384.</p> </li> </ul> </li> <li> <p>Provisioned IOPS storage (io1):</p> <ul> <li> <p>Enterprise and Standard editions: Must be an integer from 200 to 16384.</p> </li> <li> <p>Web and Express editions: Must be an integer from 100 to 16384.</p> </li> </ul> </li> <li> <p>Magnetic storage (standard):</p> <ul> <li> <p>Enterprise and Standard editions: Must be an integer from 200 to 1024.</p> </li> <li> <p>Web and Express editions: Must be an integer from 20 to 1024.</p> </li> </ul> </li> </ul></p>
    pub allocated_storage: Option<i64>,
    /// <p>A value that indicates whether minor engine upgrades are applied automatically to the DB instance during the maintenance window. By default, minor engine upgrades are applied automatically.</p>
    pub auto_minor_version_upgrade: Option<bool>,
    /// <p><p> The Availability Zone (AZ) where the database will be created. For information on Amazon Web Services Regions and Availability Zones, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html">Regions and Availability Zones</a>. </p> <p>Default: A random, system-chosen Availability Zone in the endpoint&#39;s Amazon Web Services Region.</p> <p> Example: <code>us-east-1d</code> </p> <p> Constraint: The <code>AvailabilityZone</code> parameter can&#39;t be specified if the DB instance is a Multi-AZ deployment. The specified Availability Zone must be in the same Amazon Web Services Region as the current endpoint. </p> <note> <p>If you&#39;re creating a DB instance in an RDS on VMware environment, specify the identifier of the custom Availability Zone to create the DB instance in.</p> <p>For more information about RDS on VMware, see the <a href="https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html"> RDS on VMware User Guide.</a> </p> </note></p>
    pub availability_zone: Option<String>,
    /// <p><p>The number of days for which automated backups are retained. Setting this parameter to a positive number enables backups. Setting this parameter to 0 disables automated backups.</p> <p> <b>Amazon Aurora</b> </p> <p>Not applicable. The retention period for automated backups is managed by the DB cluster.</p> <p>Default: 1</p> <p>Constraints:</p> <ul> <li> <p>Must be a value from 0 to 35</p> </li> <li> <p>Can&#39;t be set to 0 if the DB instance is a source to read replicas</p> </li> </ul></p>
    pub backup_retention_period: Option<i64>,
    /// <p>For supported engines, indicates that the DB instance should be associated with the specified CharacterSet.</p> <p> <b>Amazon Aurora</b> </p> <p>Not applicable. The character set is managed by the DB cluster. For more information, see <code>CreateDBCluster</code>.</p>
    pub character_set_name: Option<String>,
    /// <p>A value that indicates whether to copy tags from the DB instance to snapshots of the DB instance. By default, tags are not copied.</p> <p> <b>Amazon Aurora</b> </p> <p>Not applicable. Copying tags to snapshots is managed by the DB cluster. Setting this value for an Aurora DB instance has no effect on the DB cluster setting.</p>
    pub copy_tags_to_snapshot: Option<bool>,
    /// <p>The identifier of the DB cluster that the instance will belong to.</p>
    pub db_cluster_identifier: Option<String>,
    /// <p>The compute and memory capacity of the DB instance, for example, <code>db.m4.large</code>. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines. For the full list of DB instance classes, and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB Instance Class</a> in the <i>Amazon RDS User Guide.</i> </p>
    pub db_instance_class: String,
    /// <p>The DB instance identifier. This parameter is stored as a lowercase string.</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li> </ul> <p>Example: <code>mydbinstance</code> </p>
    pub db_instance_identifier: String,
    /// <p><p>The meaning of this parameter differs according to the database engine you use.</p> <p> <b>MySQL</b> </p> <p>The name of the database to create when the DB instance is created. If this parameter isn&#39;t specified, no database is created in the DB instance.</p> <p>Constraints:</p> <ul> <li> <p>Must contain 1 to 64 letters or numbers.</p> </li> <li> <p>Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).</p> </li> <li> <p>Can&#39;t be a word reserved by the specified database engine</p> </li> </ul> <p> <b>MariaDB</b> </p> <p>The name of the database to create when the DB instance is created. If this parameter isn&#39;t specified, no database is created in the DB instance.</p> <p>Constraints:</p> <ul> <li> <p>Must contain 1 to 64 letters or numbers.</p> </li> <li> <p>Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).</p> </li> <li> <p>Can&#39;t be a word reserved by the specified database engine</p> </li> </ul> <p> <b>PostgreSQL</b> </p> <p>The name of the database to create when the DB instance is created. If this parameter isn&#39;t specified, a database named <code>postgres</code> is created in the DB instance.</p> <p>Constraints:</p> <ul> <li> <p>Must contain 1 to 63 letters, numbers, or underscores.</p> </li> <li> <p>Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).</p> </li> <li> <p>Can&#39;t be a word reserved by the specified database engine</p> </li> </ul> <p> <b>Oracle</b> </p> <p>The Oracle System ID (SID) of the created DB instance. If you specify <code>null</code>, the default value <code>ORCL</code> is used. You can&#39;t specify the string NULL, or any other reserved word, for <code>DBName</code>. </p> <p>Default: <code>ORCL</code> </p> <p>Constraints:</p> <ul> <li> <p>Can&#39;t be longer than 8 characters</p> </li> </ul> <p> <b>SQL Server</b> </p> <p>Not applicable. Must be null.</p> <p> <b>Amazon Aurora MySQL</b> </p> <p>The name of the database to create when the primary DB instance of the Aurora MySQL DB cluster is created. If this parameter isn&#39;t specified for an Aurora MySQL DB cluster, no database is created in the DB cluster.</p> <p>Constraints:</p> <ul> <li> <p>It must contain 1 to 64 alphanumeric characters.</p> </li> <li> <p>It can&#39;t be a word reserved by the database engine.</p> </li> </ul> <p> <b>Amazon Aurora PostgreSQL</b> </p> <p>The name of the database to create when the primary DB instance of the Aurora PostgreSQL DB cluster is created. If this parameter isn&#39;t specified for an Aurora PostgreSQL DB cluster, a database named <code>postgres</code> is created in the DB cluster.</p> <p>Constraints:</p> <ul> <li> <p>It must contain 1 to 63 alphanumeric characters.</p> </li> <li> <p>It must begin with a letter or an underscore. Subsequent characters can be letters, underscores, or digits (0 to 9).</p> </li> <li> <p>It can&#39;t be a word reserved by the database engine.</p> </li> </ul></p>
    pub db_name: Option<String>,
    /// <p><p>The name of the DB parameter group to associate with this DB instance. If you do not specify a value, then the default DB parameter group for the specified DB engine and version is used.</p> <p>Constraints:</p> <ul> <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li> <li> <p>First character must be a letter</p> </li> <li> <p>Can&#39;t end with a hyphen or contain two consecutive hyphens</p> </li> </ul></p>
    pub db_parameter_group_name: Option<String>,
    /// <p>A list of DB security groups to associate with this DB instance.</p> <p>Default: The default DB security group for the database engine.</p>
    pub db_security_groups: Option<Vec<String>>,
    /// <p>A DB subnet group to associate with this DB instance.</p> <p>If there is no DB subnet group, then it is a non-VPC DB instance.</p>
    pub db_subnet_group_name: Option<String>,
    /// <p>A value that indicates whether the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html"> Deleting a DB Instance</a>. </p> <p> <b>Amazon Aurora</b> </p> <p>Not applicable. You can enable or disable deletion protection for the DB cluster. For more information, see <code>CreateDBCluster</code>. DB instances in a DB cluster can be deleted even when deletion protection is enabled for the DB cluster. </p>
    pub deletion_protection: Option<bool>,
    /// <p>The Active Directory directory ID to create the DB instance in. Currently, only MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances can be created in an Active Directory Domain.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html"> Kerberos Authentication</a> in the <i>Amazon RDS User Guide</i>.</p>
    pub domain: Option<String>,
    /// <p>Specify the name of the IAM role to be used when making API calls to the Directory Service.</p>
    pub domain_iam_role_name: Option<String>,
    /// <p>The list of log types that need to be enabled for exporting to CloudWatch Logs. The values in the list depend on the DB engine being used. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs </a> in the <i>Amazon Relational Database Service User Guide</i>.</p> <p> <b>Amazon Aurora</b> </p> <p>Not applicable. CloudWatch Logs exports are managed by the DB cluster. </p> <p> <b>MariaDB</b> </p> <p>Possible values are <code>audit</code>, <code>error</code>, <code>general</code>, and <code>slowquery</code>. </p> <p> <b>Microsoft SQL Server</b> </p> <p>Possible values are <code>agent</code> and <code>error</code>. </p> <p> <b>MySQL</b> </p> <p>Possible values are <code>audit</code>, <code>error</code>, <code>general</code>, and <code>slowquery</code>. </p> <p> <b>Oracle</b> </p> <p>Possible values are <code>alert</code>, <code>audit</code>, <code>listener</code>, <code>trace</code>, and <code>oemagent</code>. </p> <p> <b>PostgreSQL</b> </p> <p>Possible values are <code>postgresql</code> and <code>upgrade</code>. </p>
    pub enable_cloudwatch_logs_exports: Option<Vec<String>>,
    /// <p>A value that indicates whether to enable a customer-owned IP address (CoIP) for an RDS on Outposts DB instance.</p> <p>A <i>CoIP</i> provides local or external connectivity to resources in your Outpost subnets through your on-premises network. For some use cases, a CoIP can provide lower latency for connections to the DB instance from outside of its virtual private cloud (VPC) on your local network.</p> <p>For more information about RDS on Outposts, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon RDS on Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide</i>.</p> <p>For more information about CoIPs, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#ip-addressing">Customer-owned IP addresses</a> in the <i>Amazon Web Services Outposts User Guide</i>.</p>
    pub enable_customer_owned_ip: Option<bool>,
    /// <p>A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping is disabled.</p> <p>This setting doesn't apply to Amazon Aurora. Mapping Amazon Web Services IAM accounts to database accounts is managed by the DB cluster.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database Authentication for MySQL and PostgreSQL</a> in the <i>Amazon RDS User Guide.</i> </p>
    pub enable_iam_database_authentication: Option<bool>,
    /// <p>A value that indicates whether to enable Performance Insights for the DB instance. </p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon Performance Insights</a> in the <i>Amazon Relational Database Service User Guide</i>. </p>
    pub enable_performance_insights: Option<bool>,
    /// <p><p>The name of the database engine to be used for this instance. </p> <p>Not every database engine is available for every Amazon Web Services Region. </p> <p>Valid Values: </p> <ul> <li> <p> <code>aurora</code> (for MySQL 5.6-compatible Aurora)</p> </li> <li> <p> <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora)</p> </li> <li> <p> <code>aurora-postgresql</code> </p> </li> <li> <p> <code>mariadb</code> </p> </li> <li> <p> <code>mysql</code> </p> </li> <li> <p> <code>oracle-ee</code> </p> </li> <li> <p> <code>oracle-ee-cdb</code> </p> </li> <li> <p> <code>oracle-se2</code> </p> </li> <li> <p> <code>oracle-se2-cdb</code> </p> </li> <li> <p> <code>postgres</code> </p> </li> <li> <p> <code>sqlserver-ee</code> </p> </li> <li> <p> <code>sqlserver-se</code> </p> </li> <li> <p> <code>sqlserver-ex</code> </p> </li> <li> <p> <code>sqlserver-web</code> </p> </li> </ul></p>
    pub engine: String,
    /// <p>The version number of the database engine to use.</p> <p>For a list of valid engine versions, use the <code>DescribeDBEngineVersions</code> action.</p> <p>The following are the database engines and links to information about the major and minor versions that are available with Amazon RDS. Not every database engine is available for every Amazon Web Services Region.</p> <p> <b>Amazon Aurora</b> </p> <p>Not applicable. The version number of the database engine to be used by the DB instance is managed by the DB cluster.</p> <p> <b>MariaDB</b> </p> <p>See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MariaDB.html#MariaDB.Concepts.VersionMgmt">MariaDB on Amazon RDS Versions</a> in the <i>Amazon RDS User Guide.</i> </p> <p> <b>Microsoft SQL Server</b> </p> <p>See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.VersionSupport">Microsoft SQL Server Versions on Amazon RDS</a> in the <i>Amazon RDS User Guide.</i> </p> <p> <b>MySQL</b> </p> <p>See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt">MySQL on Amazon RDS Versions</a> in the <i>Amazon RDS User Guide.</i> </p> <p> <b>Oracle</b> </p> <p>See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.Oracle.PatchComposition.html">Oracle Database Engine Release Notes</a> in the <i>Amazon RDS User Guide.</i> </p> <p> <b>PostgreSQL</b> </p> <p>See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts">Amazon RDS for PostgreSQL versions and extensions</a> in the <i>Amazon RDS User Guide.</i> </p>
    pub engine_version: Option<String>,
    /// <p>The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for the DB instance. For information about valid Iops values, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS Provisioned IOPS Storage to Improve Performance</a> in the <i>Amazon RDS User Guide</i>. </p> <p>Constraints: For MariaDB, MySQL, Oracle, and PostgreSQL DB instances, must be a multiple between .5 and 50 of the storage amount for the DB instance. For SQL Server DB instances, must be a multiple between 1 and 50 of the storage amount for the DB instance. </p>
    pub iops: Option<i64>,
    /// <p>The Amazon Web Services KMS key identifier for an encrypted DB instance.</p> <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the Amazon Web Services KMS customer master key (CMK). To use a CMK in a different Amazon Web Services account, specify the key ARN or alias ARN.</p> <p> <b>Amazon Aurora</b> </p> <p>Not applicable. The Amazon Web Services KMS key identifier is managed by the DB cluster. For more information, see <code>CreateDBCluster</code>.</p> <p>If <code>StorageEncrypted</code> is enabled, and you do not specify a value for the <code>KmsKeyId</code> parameter, then Amazon RDS uses your default CMK. There is a default CMK for your Amazon Web Services account. Your Amazon Web Services account has a different default CMK for each Amazon Web Services Region.</p>
    pub kms_key_id: Option<String>,
    /// <p>License model information for this DB instance.</p> <p> Valid values: <code>license-included</code> | <code>bring-your-own-license</code> | <code>general-public-license</code> </p>
    pub license_model: Option<String>,
    /// <p>The password for the master user. The password can include any printable ASCII character except "/", """, or "@".</p> <p> <b>Amazon Aurora</b> </p> <p>Not applicable. The password for the master user is managed by the DB cluster.</p> <p> <b>MariaDB</b> </p> <p>Constraints: Must contain from 8 to 41 characters.</p> <p> <b>Microsoft SQL Server</b> </p> <p>Constraints: Must contain from 8 to 128 characters.</p> <p> <b>MySQL</b> </p> <p>Constraints: Must contain from 8 to 41 characters.</p> <p> <b>Oracle</b> </p> <p>Constraints: Must contain from 8 to 30 characters.</p> <p> <b>PostgreSQL</b> </p> <p>Constraints: Must contain from 8 to 128 characters.</p>
    pub master_user_password: Option<String>,
    /// <p><p>The name for the master user.</p> <p> <b>Amazon Aurora</b> </p> <p>Not applicable. The name for the master user is managed by the DB cluster. </p> <p> <b>MariaDB</b> </p> <p>Constraints:</p> <ul> <li> <p>Required for MariaDB.</p> </li> <li> <p>Must be 1 to 16 letters or numbers.</p> </li> <li> <p>Can&#39;t be a reserved word for the chosen database engine.</p> </li> </ul> <p> <b>Microsoft SQL Server</b> </p> <p>Constraints:</p> <ul> <li> <p>Required for SQL Server.</p> </li> <li> <p>Must be 1 to 128 letters or numbers.</p> </li> <li> <p>The first character must be a letter.</p> </li> <li> <p>Can&#39;t be a reserved word for the chosen database engine.</p> </li> </ul> <p> <b>MySQL</b> </p> <p>Constraints:</p> <ul> <li> <p>Required for MySQL.</p> </li> <li> <p>Must be 1 to 16 letters or numbers.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Can&#39;t be a reserved word for the chosen database engine.</p> </li> </ul> <p> <b>Oracle</b> </p> <p>Constraints:</p> <ul> <li> <p>Required for Oracle.</p> </li> <li> <p>Must be 1 to 30 letters or numbers.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Can&#39;t be a reserved word for the chosen database engine.</p> </li> </ul> <p> <b>PostgreSQL</b> </p> <p>Constraints:</p> <ul> <li> <p>Required for PostgreSQL.</p> </li> <li> <p>Must be 1 to 63 letters or numbers.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Can&#39;t be a reserved word for the chosen database engine.</p> </li> </ul></p>
    pub master_username: Option<String>,
    /// <p>The upper limit to which Amazon RDS can automatically scale the storage of the DB instance.</p> <p>For more information about this setting, including limitations that apply to it, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling"> Managing capacity automatically with Amazon RDS storage autoscaling</a> in the <i>Amazon RDS User Guide</i>.</p>
    pub max_allocated_storage: Option<i64>,
    /// <p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0. The default is 0.</p> <p>If <code>MonitoringRoleArn</code> is specified, then you must also set <code>MonitoringInterval</code> to a value other than 0.</p> <p>Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code> </p>
    pub monitoring_interval: Option<i64>,
    /// <p>The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs. For example, <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a monitoring role, go to <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling">Setting Up and Enabling Enhanced Monitoring</a> in the <i>Amazon RDS User Guide</i>.</p> <p>If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a <code>MonitoringRoleArn</code> value.</p>
    pub monitoring_role_arn: Option<String>,
    /// <p>A value that indicates whether the DB instance is a Multi-AZ deployment. You can't set the <code>AvailabilityZone</code> parameter if the DB instance is a Multi-AZ deployment.</p>
    pub multi_az: Option<bool>,
    /// <p>The name of the NCHAR character set for the Oracle DB instance.</p>
    pub nchar_character_set_name: Option<String>,
    /// <p>A value that indicates that the DB instance should be associated with the specified option group.</p> <p>Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed from an option group. Also, that option group can't be removed from a DB instance once it is associated with a DB instance</p>
    pub option_group_name: Option<String>,
    /// <p>The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p> <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the Amazon Web Services KMS customer master key (CMK).</p> <p>If you do not specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your default CMK. There is a default CMK for your Amazon Web Services account. Your Amazon Web Services account has a different default CMK for each Amazon Web Services Region.</p>
    pub performance_insights_kms_key_id: Option<String>,
    /// <p>The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years). </p>
    pub performance_insights_retention_period: Option<i64>,
    /// <p>The port number on which the database accepts connections.</p> <p> <b>MySQL</b> </p> <p> Default: <code>3306</code> </p> <p> Valid values: <code>1150-65535</code> </p> <p>Type: Integer</p> <p> <b>MariaDB</b> </p> <p> Default: <code>3306</code> </p> <p> Valid values: <code>1150-65535</code> </p> <p>Type: Integer</p> <p> <b>PostgreSQL</b> </p> <p> Default: <code>5432</code> </p> <p> Valid values: <code>1150-65535</code> </p> <p>Type: Integer</p> <p> <b>Oracle</b> </p> <p> Default: <code>1521</code> </p> <p> Valid values: <code>1150-65535</code> </p> <p> <b>SQL Server</b> </p> <p> Default: <code>1433</code> </p> <p> Valid values: <code>1150-65535</code> except <code>1234</code>, <code>1434</code>, <code>3260</code>, <code>3343</code>, <code>3389</code>, <code>47001</code>, and <code>49152-49156</code>.</p> <p> <b>Amazon Aurora</b> </p> <p> Default: <code>3306</code> </p> <p> Valid values: <code>1150-65535</code> </p> <p>Type: Integer</p>
    pub port: Option<i64>,
    /// <p><p> The daily time range during which automated backups are created if automated backups are enabled, using the <code>BackupRetentionPeriod</code> parameter. The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow">Backup window</a> in the <i>Amazon RDS User Guide</i>. </p> <p> <b>Amazon Aurora</b> </p> <p>Not applicable. The daily time range for creating automated backups is managed by the DB cluster.</p> <p>Constraints:</p> <ul> <li> <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p> </li> <li> <p>Must be in Universal Coordinated Time (UTC).</p> </li> <li> <p>Must not conflict with the preferred maintenance window.</p> </li> <li> <p>Must be at least 30 minutes.</p> </li> </ul></p>
    pub preferred_backup_window: Option<String>,
    /// <p>The time range each week during which system maintenance can occur, in Universal Coordinated Time (UTC). For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance">Amazon RDS Maintenance Window</a>. </p> <p> Format: <code>ddd:hh24:mi-ddd:hh24:mi</code> </p> <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region, occurring on a random day of the week. </p> <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p> <p>Constraints: Minimum 30-minute window.</p>
    pub preferred_maintenance_window: Option<String>,
    /// <p>The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.</p>
    pub processor_features: Option<Vec<ProcessorFeature>>,
    /// <p>A value that specifies the order in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance"> Fault Tolerance for an Aurora DB Cluster</a> in the <i>Amazon Aurora User Guide</i>. </p> <p>Default: 1</p> <p>Valid Values: 0 - 15</p>
    pub promotion_tier: Option<i64>,
    /// <p><p>A value that indicates whether the DB instance is publicly accessible.</p> <p>When the DB instance is publicly accessible, its DNS endpoint resolves to the private IP address from within the DB instance&#39;s VPC, and to the public IP address from outside of the DB instance&#39;s VPC. Access to the DB instance is ultimately controlled by the security group it uses, and that public access is not permitted if the security group assigned to the DB instance doesn&#39;t permit it.</p> <p>When the DB instance isn&#39;t publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address.</p> <p>Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.</p> <p>If <code>DBSubnetGroupName</code> isn&#39;t specified, and <code>PubliclyAccessible</code> isn&#39;t specified, the following applies:</p> <ul> <li> <p>If the default VPC in the target region doesn’t have an Internet gateway attached to it, the DB instance is private.</p> </li> <li> <p>If the default VPC in the target region has an Internet gateway attached to it, the DB instance is public.</p> </li> </ul> <p>If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn&#39;t specified, the following applies:</p> <ul> <li> <p>If the subnets are part of a VPC that doesn’t have an Internet gateway attached to it, the DB instance is private.</p> </li> <li> <p>If the subnets are part of a VPC that has an Internet gateway attached to it, the DB instance is public.</p> </li> </ul></p>
    pub publicly_accessible: Option<bool>,
    /// <p>A value that indicates whether the DB instance is encrypted. By default, it isn't encrypted.</p> <p> <b>Amazon Aurora</b> </p> <p>Not applicable. The encryption for DB instances is managed by the DB cluster.</p>
    pub storage_encrypted: Option<bool>,
    /// <p>Specifies the storage type to be associated with the DB instance.</p> <p> Valid values: <code>standard | gp2 | io1</code> </p> <p> If you specify <code>io1</code>, you must also include a value for the <code>Iops</code> parameter. </p> <p> Default: <code>io1</code> if the <code>Iops</code> parameter is specified, otherwise <code>gp2</code> </p>
    pub storage_type: Option<String>,
    /// <p>Tags to assign to the DB instance.</p>
    pub tags: Option<Vec<Tag>>,
    /// <p>The ARN from the key store with which to associate the instance for TDE encryption.</p>
    pub tde_credential_arn: Option<String>,
    /// <p>The password for the given ARN from the key store in order to access the device.</p>
    pub tde_credential_password: Option<String>,
    /// <p>The time zone of the DB instance. The time zone parameter is currently supported only by <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.TimeZone">Microsoft SQL Server</a>. </p>
    pub timezone: Option<String>,
    /// <p>A list of Amazon EC2 VPC security groups to associate with this DB instance.</p> <p> <b>Amazon Aurora</b> </p> <p>Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster.</p> <p>Default: The default EC2 VPC security group for the DB subnet group's VPC.</p>
    pub vpc_security_group_ids: Option<Vec<String>>,
}

/// Serialize `CreateDBInstanceMessage` contents to a `SignedRequest`.
struct CreateDBInstanceMessageSerializer;
impl CreateDBInstanceMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateDBInstanceMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.allocated_storage {
            params.put(&format!("{}{}", prefix, "AllocatedStorage"), &field_value);
        }
        if let Some(ref field_value) = obj.auto_minor_version_upgrade {
            params.put(
                &format!("{}{}", prefix, "AutoMinorVersionUpgrade"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.availability_zone {
            params.put(&format!("{}{}", prefix, "AvailabilityZone"), &field_value);
        }
        if let Some(ref field_value) = obj.backup_retention_period {
            params.put(
                &format!("{}{}", prefix, "BackupRetentionPeriod"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.character_set_name {
            params.put(&format!("{}{}", prefix, "CharacterSetName"), &field_value);
        }
        if let Some(ref field_value) = obj.copy_tags_to_snapshot {
            params.put(&format!("{}{}", prefix, "CopyTagsToSnapshot"), &field_value);
        }
        if let Some(ref field_value) = obj.db_cluster_identifier {
            params.put(
                &format!("{}{}", prefix, "DBClusterIdentifier"),
                &field_value,
            );
        }
        params.put(
            &format!("{}{}", prefix, "DBInstanceClass"),
            &obj.db_instance_class,
        );
        params.put(
            &format!("{}{}", prefix, "DBInstanceIdentifier"),
            &obj.db_instance_identifier,
        );
        if let Some(ref field_value) = obj.db_name {
            params.put(&format!("{}{}", prefix, "DBName"), &field_value);
        }
        if let Some(ref field_value) = obj.db_parameter_group_name {
            params.put(
                &format!("{}{}", prefix, "DBParameterGroupName"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.db_security_groups {
            DBSecurityGroupNameListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "DBSecurityGroupName"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.db_subnet_group_name {
            params.put(&format!("{}{}", prefix, "DBSubnetGroupName"), &field_value);
        }
        if let Some(ref field_value) = obj.deletion_protection {
            params.put(&format!("{}{}", prefix, "DeletionProtection"), &field_value);
        }
        if let Some(ref field_value) = obj.domain {
            params.put(&format!("{}{}", prefix, "Domain"), &field_value);
        }
        if let Some(ref field_value) = obj.domain_iam_role_name {
            params.put(&format!("{}{}", prefix, "DomainIAMRoleName"), &field_value);
        }
        if let Some(ref field_value) = obj.enable_cloudwatch_logs_exports {
            LogTypeListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "EnableCloudwatchLogsExports"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.enable_customer_owned_ip {
            params.put(
                &format!("{}{}", prefix, "EnableCustomerOwnedIp"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.enable_iam_database_authentication {
            params.put(
                &format!("{}{}", prefix, "EnableIAMDatabaseAuthentication"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.enable_performance_insights {
            params.put(
                &format!("{}{}", prefix, "EnablePerformanceInsights"),
                &field_value,
            );
        }
        params.put(&format!("{}{}", prefix, "Engine"), &obj.engine);
        if let Some(ref field_value) = obj.engine_version {
            params.put(&format!("{}{}", prefix, "EngineVersion"), &field_value);
        }
        if let Some(ref field_value) = obj.iops {
            params.put(&format!("{}{}", prefix, "Iops"), &field_value);
        }
        if let Some(ref field_value) = obj.kms_key_id {
            params.put(&format!("{}{}", prefix, "KmsKeyId"), &field_value);
        }
        if let Some(ref field_value) = obj.license_model {
            params.put(&format!("{}{}", prefix, "LicenseModel"), &field_value);
        }
        if let Some(ref field_value) = obj.master_user_password {
            params.put(&format!("{}{}", prefix, "MasterUserPassword"), &field_value);
        }
        if let Some(ref field_value) = obj.master_username {
            params.put(&format!("{}{}", prefix, "MasterUsername"), &field_value);
        }
        if let Some(ref field_value) = obj.max_allocated_storage {
            params.put(
                &format!("{}{}", prefix, "MaxAllocatedStorage"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.monitoring_interval {
            params.put(&format!("{}{}", prefix, "MonitoringInterval"), &field_value);
        }
        if let Some(ref field_value) = obj.monitoring_role_arn {
            params.put(&format!("{}{}", prefix, "MonitoringRoleArn"), &field_value);
        }
        if let Some(ref field_value) = obj.multi_az {
            params.put(&format!("{}{}", prefix, "MultiAZ"), &field_value);
        }
        if let Some(ref field_value) = obj.nchar_character_set_name {
            params.put(
                &format!("{}{}", prefix, "NcharCharacterSetName"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.option_group_name {
            params.put(&format!("{}{}", prefix, "OptionGroupName"), &field_value);
        }
        if let Some(ref field_value) = obj.performance_insights_kms_key_id {
            params.put(
                &format!("{}{}", prefix, "PerformanceInsightsKMSKeyId"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.performance_insights_retention_period {
            params.put(
                &format!("{}{}", prefix, "PerformanceInsightsRetentionPeriod"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.port {
            params.put(&format!("{}{}", prefix, "Port"), &field_value);
        }
        if let Some(ref field_value) = obj.preferred_backup_window {
            params.put(
                &format!("{}{}", prefix, "PreferredBackupWindow"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.preferred_maintenance_window {
            params.put(
                &format!("{}{}", prefix, "PreferredMaintenanceWindow"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.processor_features {
            ProcessorFeatureListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "ProcessorFeature"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.promotion_tier {
            params.put(&format!("{}{}", prefix, "PromotionTier"), &field_value);
        }
        if let Some(ref field_value) = obj.publicly_accessible {
            params.put(&format!("{}{}", prefix, "PubliclyAccessible"), &field_value);
        }
        if let Some(ref field_value) = obj.storage_encrypted {
            params.put(&format!("{}{}", prefix, "StorageEncrypted"), &field_value);
        }
        if let Some(ref field_value) = obj.storage_type {
            params.put(&format!("{}{}", prefix, "StorageType"), &field_value);
        }
        if let Some(ref field_value) = obj.tags {
            TagListSerializer::serialize(params, &format!("{}{}", prefix, "Tag"), field_value);
        }
        if let Some(ref field_value) = obj.tde_credential_arn {
            params.put(&format!("{}{}", prefix, "TdeCredentialArn"), &field_value);
        }
        if let Some(ref field_value) = obj.tde_credential_password {
            params.put(
                &format!("{}{}", prefix, "TdeCredentialPassword"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.timezone {
            params.put(&format!("{}{}", prefix, "Timezone"), &field_value);
        }
        if let Some(ref field_value) = obj.vpc_security_group_ids {
            VpcSecurityGroupIdListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "VpcSecurityGroupId"),
                field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateDBInstanceReadReplicaMessage {
    /// <p>A value that indicates whether minor engine upgrades are applied automatically to the read replica during the maintenance window.</p> <p>Default: Inherits from the source DB instance</p>
    pub auto_minor_version_upgrade: Option<bool>,
    /// <p>The Availability Zone (AZ) where the read replica will be created.</p> <p>Default: A random, system-chosen Availability Zone in the endpoint's Amazon Web Services Region.</p> <p> Example: <code>us-east-1d</code> </p>
    pub availability_zone: Option<String>,
    /// <p>A value that indicates whether to copy all tags from the read replica to snapshots of the read replica. By default, tags are not copied.</p>
    pub copy_tags_to_snapshot: Option<bool>,
    /// <p>The compute and memory capacity of the read replica, for example, <code>db.m4.large</code>. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines. For the full list of DB instance classes, and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB Instance Class</a> in the <i>Amazon RDS User Guide.</i> </p> <p>Default: Inherits from the source DB instance.</p>
    pub db_instance_class: Option<String>,
    /// <p>The DB instance identifier of the read replica. This identifier is the unique key that identifies a DB instance. This parameter is stored as a lowercase string.</p>
    pub db_instance_identifier: String,
    /// <p><p>The name of the DB parameter group to associate with this DB instance.</p> <p>If you do not specify a value for <code>DBParameterGroupName</code>, then Amazon RDS uses the <code>DBParameterGroup</code> of source DB instance for a same region read replica, or the default <code>DBParameterGroup</code> for the specified DB engine for a cross region read replica.</p> <note> <p>Currently, specifying a parameter group for this operation is only supported for Oracle DB instances.</p> </note> <p>Constraints:</p> <ul> <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li> <li> <p>First character must be a letter</p> </li> <li> <p>Can&#39;t end with a hyphen or contain two consecutive hyphens</p> </li> </ul></p>
    pub db_parameter_group_name: Option<String>,
    /// <p>Specifies a DB subnet group for the DB instance. The new DB instance is created in the VPC associated with the DB subnet group. If no DB subnet group is specified, then the new DB instance isn't created in a VPC.</p> <p>Constraints:</p> <ul> <li> <p>Can only be specified if the source DB instance identifier specifies a DB instance in another Amazon Web Services Region.</p> </li> <li> <p>If supplied, must match the name of an existing DBSubnetGroup.</p> </li> <li> <p>The specified DB subnet group must be in the same Amazon Web Services Region in which the operation is running.</p> </li> <li> <p>All read replicas in one Amazon Web Services Region that are created from the same source DB instance must either:&gt;</p> <ul> <li> <p>Specify DB subnet groups from the same VPC. All these read replicas are created in the same VPC.</p> </li> <li> <p>Not specify a DB subnet group. All these read replicas are created outside of any VPC.</p> </li> </ul> </li> </ul> <p>Example: <code>mySubnetgroup</code> </p>
    pub db_subnet_group_name: Option<String>,
    /// <p>A value that indicates whether the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html"> Deleting a DB Instance</a>. </p>
    pub deletion_protection: Option<bool>,
    /// <p>The Active Directory directory ID to create the DB instance in. Currently, only MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances can be created in an Active Directory Domain.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html"> Kerberos Authentication</a> in the <i>Amazon RDS User Guide</i>.</p>
    pub domain: Option<String>,
    /// <p>Specify the name of the IAM role to be used when making API calls to the Directory Service.</p>
    pub domain_iam_role_name: Option<String>,
    /// <p>The list of logs that the new DB instance is to export to CloudWatch Logs. The values in the list depend on the DB engine being used. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs </a> in the <i>Amazon RDS User Guide</i>.</p>
    pub enable_cloudwatch_logs_exports: Option<Vec<String>>,
    /// <p>A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping is disabled.</p> <p>For more information about IAM database authentication, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database Authentication for MySQL and PostgreSQL</a> in the <i>Amazon RDS User Guide.</i> </p>
    pub enable_iam_database_authentication: Option<bool>,
    /// <p>A value that indicates whether to enable Performance Insights for the read replica. </p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon Performance Insights</a> in the <i>Amazon RDS User Guide</i>. </p>
    pub enable_performance_insights: Option<bool>,
    /// <p>The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for the DB instance.</p>
    pub iops: Option<i64>,
    /// <p>The Amazon Web Services KMS key identifier for an encrypted read replica.</p> <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the Amazon Web Services KMS CMK.</p> <p>If you create an encrypted read replica in the same Amazon Web Services Region as the source DB instance, then do not specify a value for this parameter. A read replica in the same Region is always encrypted with the same Amazon Web Services KMS CMK as the source DB instance.</p> <p>If you create an encrypted read replica in a different Amazon Web Services Region, then you must specify a Amazon Web Services KMS key identifier for the destination Amazon Web Services Region. Amazon Web Services KMS CMKs are specific to the Amazon Web Services Region that they are created in, and you can't use CMKs from one Amazon Web Services Region in another Amazon Web Services Region.</p> <p>You can't create an encrypted read replica from an unencrypted DB instance.</p>
    pub kms_key_id: Option<String>,
    /// <p>The upper limit to which Amazon RDS can automatically scale the storage of the DB instance.</p> <p>For more information about this setting, including limitations that apply to it, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling"> Managing capacity automatically with Amazon RDS storage autoscaling</a> in the <i>Amazon RDS User Guide</i>.</p>
    pub max_allocated_storage: Option<i64>,
    /// <p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the read replica. To disable collecting Enhanced Monitoring metrics, specify 0. The default is 0.</p> <p>If <code>MonitoringRoleArn</code> is specified, then you must also set <code>MonitoringInterval</code> to a value other than 0.</p> <p>Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code> </p>
    pub monitoring_interval: Option<i64>,
    /// <p>The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs. For example, <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a monitoring role, go to <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole">To create an IAM role for Amazon RDS Enhanced Monitoring</a> in the <i>Amazon RDS User Guide</i>.</p> <p>If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a <code>MonitoringRoleArn</code> value.</p>
    pub monitoring_role_arn: Option<String>,
    /// <p>A value that indicates whether the read replica is in a Multi-AZ deployment. </p> <p>You can create a read replica as a Multi-AZ DB instance. RDS creates a standby of your replica in another Availability Zone for failover support for the replica. Creating your read replica as a Multi-AZ DB instance is independent of whether the source database is a Multi-AZ DB instance. </p>
    pub multi_az: Option<bool>,
    /// <p><p>The option group the DB instance is associated with. If omitted, the option group associated with the source instance is used.</p> <note> <p>For SQL Server, you must use the option group associated with the source instance.</p> </note></p>
    pub option_group_name: Option<String>,
    /// <p>The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p> <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the Amazon Web Services KMS customer master key (CMK).</p> <p>If you do not specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your default CMK. There is a default CMK for your Amazon Web Services account. Your Amazon Web Services account has a different default CMK for each Amazon Web Services Region.</p>
    pub performance_insights_kms_key_id: Option<String>,
    /// <p>The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years). </p>
    pub performance_insights_retention_period: Option<i64>,
    /// <p>The port number that the DB instance uses for connections.</p> <p>Default: Inherits from the source DB instance</p> <p>Valid Values: <code>1150-65535</code> </p>
    pub port: Option<i64>,
    /// <p><p>The URL that contains a Signature Version 4 signed request for the <code>CreateDBInstanceReadReplica</code> API action in the source Amazon Web Services Region that contains the source DB instance. </p> <p>You must specify this parameter when you create an encrypted read replica from another Amazon Web Services Region by using the Amazon RDS API. Don&#39;t specify <code>PreSignedUrl</code> when you are creating an encrypted read replica in the same Amazon Web Services Region.</p> <p>The presigned URL must be a valid request for the <code>CreateDBInstanceReadReplica</code> API action that can be executed in the source Amazon Web Services Region that contains the encrypted source DB instance. The presigned URL request must contain the following parameter values: </p> <ul> <li> <p> <code>DestinationRegion</code> - The Amazon Web Services Region that the encrypted read replica is created in. This Amazon Web Services Region is the same one where the <code>CreateDBInstanceReadReplica</code> action is called that contains this presigned URL.</p> <p>For example, if you create an encrypted DB instance in the us-west-1 Amazon Web Services Region, from a source DB instance in the us-east-2 Amazon Web Services Region, then you call the <code>CreateDBInstanceReadReplica</code> action in the us-east-1 Amazon Web Services Region and provide a presigned URL that contains a call to the <code>CreateDBInstanceReadReplica</code> action in the us-west-2 Amazon Web Services Region. For this example, the <code>DestinationRegion</code> in the presigned URL must be set to the us-east-1 Amazon Web Services Region. </p> </li> <li> <p> <code>KmsKeyId</code> - The Amazon Web Services KMS key identifier for the key to use to encrypt the read replica in the destination Amazon Web Services Region. This is the same identifier for both the <code>CreateDBInstanceReadReplica</code> action that is called in the destination Amazon Web Services Region, and the action contained in the presigned URL. </p> </li> <li> <p> <code>SourceDBInstanceIdentifier</code> - The DB instance identifier for the encrypted DB instance to be replicated. This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web Services Region. For example, if you are creating an encrypted read replica from a DB instance in the us-west-2 Amazon Web Services Region, then your <code>SourceDBInstanceIdentifier</code> looks like the following example: <code>arn:aws:rds:us-west-2:123456789012:instance:mysql-instance1-20161115</code>. </p> </li> </ul> <p>To learn how to generate a Signature Version 4 signed request, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html">Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 Signing Process</a>. </p> <note> <p>If you are using an Amazon Web Services SDK tool or the CLI, you can specify <code>SourceRegion</code> (or <code>--source-region</code> for the CLI) instead of specifying <code>PreSignedUrl</code> manually. Specifying <code>SourceRegion</code> autogenerates a presigned URL that is a valid request for the operation that can be executed in the source Amazon Web Services Region.</p> <p> <code>SourceRegion</code> isn&#39;t supported for SQL Server, because SQL Server on Amazon RDS doesn&#39;t support cross-region read replicas.</p> </note></p>
    pub pre_signed_url: Option<String>,
    /// <p>The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.</p>
    pub processor_features: Option<Vec<ProcessorFeature>>,
    /// <p>A value that indicates whether the DB instance is publicly accessible.</p> <p>When the DB instance is publicly accessible, its DNS endpoint resolves to the private IP address from within the DB instance's VPC, and to the public IP address from outside of the DB instance's VPC. Access to the DB instance is ultimately controlled by the security group it uses, and that public access is not permitted if the security group assigned to the DB instance doesn't permit it.</p> <p>When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address.</p> <p>For more information, see <a>CreateDBInstance</a>.</p>
    pub publicly_accessible: Option<bool>,
    /// <p>The open mode of the replica database: mounted or read-only.</p> <note> <p>This parameter is only supported for Oracle DB instances.</p> </note> <p>Mounted DB replicas are included in Oracle Enterprise Edition. The main use case for mounted replicas is cross-Region disaster recovery. The primary database doesn't use Active Data Guard to transmit information to the mounted replica. Because it doesn't accept user connections, a mounted replica can't serve a read-only workload.</p> <p>You can create a combination of mounted and read-only DB replicas for the same primary DB instance. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html">Working with Oracle Read Replicas for Amazon RDS</a> in the <i>Amazon RDS User Guide</i>.</p>
    pub replica_mode: Option<String>,
    /// <p><p>The identifier of the DB instance that will act as the source for the read replica. Each DB instance can have up to five read replicas.</p> <p>Constraints:</p> <ul> <li> <p>Must be the identifier of an existing MySQL, MariaDB, Oracle, PostgreSQL, or SQL Server DB instance.</p> </li> <li> <p>Can specify a DB instance that is a MySQL read replica only if the source is running MySQL 5.6 or later.</p> </li> <li> <p>For the limitations of Oracle read replicas, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html">Read Replica Limitations with Oracle</a> in the <i>Amazon RDS User Guide</i>.</p> </li> <li> <p>For the limitations of SQL Server read replicas, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/SQLServer.ReadReplicas.Limitations.html">Read Replica Limitations with Microsoft SQL Server</a> in the <i>Amazon RDS User Guide</i>.</p> </li> <li> <p>Can specify a PostgreSQL DB instance only if the source is running PostgreSQL 9.3.5 or later (9.4.7 and higher for cross-region replication).</p> </li> <li> <p>The specified DB instance must have automatic backups enabled, that is, its backup retention period must be greater than 0.</p> </li> <li> <p>If the source DB instance is in the same Amazon Web Services Region as the read replica, specify a valid DB instance identifier.</p> </li> <li> <p>If the source DB instance is in a different Amazon Web Services Region from the read replica, specify a valid DB instance ARN. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing">Constructing an ARN for Amazon RDS</a> in the <i>Amazon RDS User Guide</i>. This doesn&#39;t apply to SQL Server, which doesn&#39;t support cross-region replicas.</p> </li> </ul></p>
    pub source_db_instance_identifier: String,
    /// <p>Specifies the storage type to be associated with the read replica.</p> <p> Valid values: <code>standard | gp2 | io1</code> </p> <p> If you specify <code>io1</code>, you must also include a value for the <code>Iops</code> parameter. </p> <p> Default: <code>io1</code> if the <code>Iops</code> parameter is specified, otherwise <code>gp2</code> </p>
    pub storage_type: Option<String>,
    pub tags: Option<Vec<Tag>>,
    /// <p>A value that indicates whether the DB instance class of the DB instance uses its default processor features.</p>
    pub use_default_processor_features: Option<bool>,
    /// <p> A list of EC2 VPC security groups to associate with the read replica. </p> <p> Default: The default EC2 VPC security group for the DB subnet group's VPC. </p>
    pub vpc_security_group_ids: Option<Vec<String>>,
}

/// Serialize `CreateDBInstanceReadReplicaMessage` contents to a `SignedRequest`.
struct CreateDBInstanceReadReplicaMessageSerializer;
impl CreateDBInstanceReadReplicaMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateDBInstanceReadReplicaMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.auto_minor_version_upgrade {
            params.put(
                &format!("{}{}", prefix, "AutoMinorVersionUpgrade"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.availability_zone {
            params.put(&format!("{}{}", prefix, "AvailabilityZone"), &field_value);
        }
        if let Some(ref field_value) = obj.copy_tags_to_snapshot {
            params.put(&format!("{}{}", prefix, "CopyTagsToSnapshot"), &field_value);
        }
        if let Some(ref field_value) = obj.db_instance_class {
            params.put(&format!("{}{}", prefix, "DBInstanceClass"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "DBInstanceIdentifier"),
            &obj.db_instance_identifier,
        );
        if let Some(ref field_value) = obj.db_parameter_group_name {
            params.put(
                &format!("{}{}", prefix, "DBParameterGroupName"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.db_subnet_group_name {
            params.put(&format!("{}{}", prefix, "DBSubnetGroupName"), &field_value);
        }
        if let Some(ref field_value) = obj.deletion_protection {
            params.put(&format!("{}{}", prefix, "DeletionProtection"), &field_value);
        }
        if let Some(ref field_value) = obj.domain {
            params.put(&format!("{}{}", prefix, "Domain"), &field_value);
        }
        if let Some(ref field_value) = obj.domain_iam_role_name {
            params.put(&format!("{}{}", prefix, "DomainIAMRoleName"), &field_value);
        }
        if let Some(ref field_value) = obj.enable_cloudwatch_logs_exports {
            LogTypeListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "EnableCloudwatchLogsExports"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.enable_iam_database_authentication {
            params.put(
                &format!("{}{}", prefix, "EnableIAMDatabaseAuthentication"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.enable_performance_insights {
            params.put(
                &format!("{}{}", prefix, "EnablePerformanceInsights"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.iops {
            params.put(&format!("{}{}", prefix, "Iops"), &field_value);
        }
        if let Some(ref field_value) = obj.kms_key_id {
            params.put(&format!("{}{}", prefix, "KmsKeyId"), &field_value);
        }
        if let Some(ref field_value) = obj.max_allocated_storage {
            params.put(
                &format!("{}{}", prefix, "MaxAllocatedStorage"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.monitoring_interval {
            params.put(&format!("{}{}", prefix, "MonitoringInterval"), &field_value);
        }
        if let Some(ref field_value) = obj.monitoring_role_arn {
            params.put(&format!("{}{}", prefix, "MonitoringRoleArn"), &field_value);
        }
        if let Some(ref field_value) = obj.multi_az {
            params.put(&format!("{}{}", prefix, "MultiAZ"), &field_value);
        }
        if let Some(ref field_value) = obj.option_group_name {
            params.put(&format!("{}{}", prefix, "OptionGroupName"), &field_value);
        }
        if let Some(ref field_value) = obj.performance_insights_kms_key_id {
            params.put(
                &format!("{}{}", prefix, "PerformanceInsightsKMSKeyId"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.performance_insights_retention_period {
            params.put(
                &format!("{}{}", prefix, "PerformanceInsightsRetentionPeriod"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.port {
            params.put(&format!("{}{}", prefix, "Port"), &field_value);
        }
        if let Some(ref field_value) = obj.pre_signed_url {
            params.put(&format!("{}{}", prefix, "PreSignedUrl"), &field_value);
        }
        if let Some(ref field_value) = obj.processor_features {
            ProcessorFeatureListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "ProcessorFeature"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.publicly_accessible {
            params.put(&format!("{}{}", prefix, "PubliclyAccessible"), &field_value);
        }
        if let Some(ref field_value) = obj.replica_mode {
            params.put(&format!("{}{}", prefix, "ReplicaMode"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "SourceDBInstanceIdentifier"),
            &obj.source_db_instance_identifier,
        );
        if let Some(ref field_value) = obj.storage_type {
            params.put(&format!("{}{}", prefix, "StorageType"), &field_value);
        }
        if let Some(ref field_value) = obj.tags {
            TagListSerializer::serialize(params, &format!("{}{}", prefix, "Tag"), field_value);
        }
        if let Some(ref field_value) = obj.use_default_processor_features {
            params.put(
                &format!("{}{}", prefix, "UseDefaultProcessorFeatures"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.vpc_security_group_ids {
            VpcSecurityGroupIdListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "VpcSecurityGroupId"),
                field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateDBInstanceReadReplicaResult {
    pub db_instance: Option<DBInstance>,
}

#[allow(dead_code)]
struct CreateDBInstanceReadReplicaResultDeserializer;
impl CreateDBInstanceReadReplicaResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateDBInstanceReadReplicaResult, XmlParseError> {
        deserialize_elements::<_, CreateDBInstanceReadReplicaResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DBInstance" => {
                        obj.db_instance =
                            Some(DBInstanceDeserializer::deserialize("DBInstance", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateDBInstanceResult {
    pub db_instance: Option<DBInstance>,
}

#[allow(dead_code)]
struct CreateDBInstanceResultDeserializer;
impl CreateDBInstanceResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateDBInstanceResult, XmlParseError> {
        deserialize_elements::<_, CreateDBInstanceResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "DBInstance" => {
                    obj.db_instance =
                        Some(DBInstanceDeserializer::deserialize("DBInstance", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateDBParameterGroupMessage {
    /// <p><p>The DB parameter group family name. A DB parameter group can be associated with one and only one DB parameter group family, and can be applied only to a DB instance running a database engine and engine version compatible with that DB parameter group family.</p> <p>To list all of the available parameter group families for a DB engine, use the following command:</p> <p> <code>aws rds describe-db-engine-versions --query &quot;DBEngineVersions[].DBParameterGroupFamily&quot; --engine &lt;engine&gt;</code> </p> <p>For example, to list all of the available parameter group families for the MySQL DB engine, use the following command:</p> <p> <code>aws rds describe-db-engine-versions --query &quot;DBEngineVersions[].DBParameterGroupFamily&quot; --engine mysql</code> </p> <note> <p>The output contains duplicates.</p> </note> <p>The following are the valid DB engine values:</p> <ul> <li> <p> <code>aurora</code> (for MySQL 5.6-compatible Aurora)</p> </li> <li> <p> <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora)</p> </li> <li> <p> <code>aurora-postgresql</code> </p> </li> <li> <p> <code>mariadb</code> </p> </li> <li> <p> <code>mysql</code> </p> </li> <li> <p> <code>oracle-ee</code> </p> </li> <li> <p> <code>oracle-ee-cdb</code> </p> </li> <li> <p> <code>oracle-se2</code> </p> </li> <li> <p> <code>oracle-se2-cdb</code> </p> </li> <li> <p> <code>postgres</code> </p> </li> <li> <p> <code>sqlserver-ee</code> </p> </li> <li> <p> <code>sqlserver-se</code> </p> </li> <li> <p> <code>sqlserver-ex</code> </p> </li> <li> <p> <code>sqlserver-web</code> </p> </li> </ul></p>
    pub db_parameter_group_family: String,
    /// <p><p>The name of the DB parameter group.</p> <p>Constraints:</p> <ul> <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li> <li> <p>First character must be a letter</p> </li> <li> <p>Can&#39;t end with a hyphen or contain two consecutive hyphens</p> </li> </ul> <note> <p>This value is stored as a lowercase string.</p> </note></p>
    pub db_parameter_group_name: String,
    /// <p>The description for the DB parameter group.</p>
    pub description: String,
    /// <p>Tags to assign to the DB parameter group.</p>
    pub tags: Option<Vec<Tag>>,
}

/// Serialize `CreateDBParameterGroupMessage` contents to a `SignedRequest`.
struct CreateDBParameterGroupMessageSerializer;
impl CreateDBParameterGroupMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateDBParameterGroupMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "DBParameterGroupFamily"),
            &obj.db_parameter_group_family,
        );
        params.put(
            &format!("{}{}", prefix, "DBParameterGroupName"),
            &obj.db_parameter_group_name,
        );
        params.put(&format!("{}{}", prefix, "Description"), &obj.description);
        if let Some(ref field_value) = obj.tags {
            TagListSerializer::serialize(params, &format!("{}{}", prefix, "Tag"), field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateDBParameterGroupResult {
    pub db_parameter_group: Option<DBParameterGroup>,
}

#[allow(dead_code)]
struct CreateDBParameterGroupResultDeserializer;
impl CreateDBParameterGroupResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateDBParameterGroupResult, XmlParseError> {
        deserialize_elements::<_, CreateDBParameterGroupResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DBParameterGroup" => {
                        obj.db_parameter_group = Some(DBParameterGroupDeserializer::deserialize(
                            "DBParameterGroup",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateDBProxyEndpointRequest {
    /// <p>The name of the DB proxy endpoint to create.</p>
    pub db_proxy_endpoint_name: String,
    /// <p>The name of the DB proxy associated with the DB proxy endpoint that you create.</p>
    pub db_proxy_name: String,
    pub tags: Option<Vec<Tag>>,
    /// <p>A value that indicates whether the DB proxy endpoint can be used for read/write or read-only operations. The default is <code>READ_WRITE</code>.</p>
    pub target_role: Option<String>,
    /// <p>The VPC security group IDs for the DB proxy endpoint that you create. You can specify a different set of security group IDs than for the original DB proxy. The default is the default security group for the VPC.</p>
    pub vpc_security_group_ids: Option<Vec<String>>,
    /// <p>The VPC subnet IDs for the DB proxy endpoint that you create. You can specify a different set of subnet IDs than for the original DB proxy.</p>
    pub vpc_subnet_ids: Vec<String>,
}

/// Serialize `CreateDBProxyEndpointRequest` contents to a `SignedRequest`.
struct CreateDBProxyEndpointRequestSerializer;
impl CreateDBProxyEndpointRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateDBProxyEndpointRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "DBProxyEndpointName"),
            &obj.db_proxy_endpoint_name,
        );
        params.put(&format!("{}{}", prefix, "DBProxyName"), &obj.db_proxy_name);
        if let Some(ref field_value) = obj.tags {
            TagListSerializer::serialize(params, &format!("{}{}", prefix, "Tag"), field_value);
        }
        if let Some(ref field_value) = obj.target_role {
            params.put(&format!("{}{}", prefix, "TargetRole"), &field_value);
        }
        if let Some(ref field_value) = obj.vpc_security_group_ids {
            StringListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "VpcSecurityGroupIds"),
                field_value,
            );
        }
        StringListSerializer::serialize(
            params,
            &format!("{}{}", prefix, "VpcSubnetIds"),
            &obj.vpc_subnet_ids,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateDBProxyEndpointResponse {
    /// <p>The <code>DBProxyEndpoint</code> object that is created by the API operation. The DB proxy endpoint that you create might provide capabilities such as read/write or read-only operations, or using a different VPC than the proxy's default VPC.</p>
    pub db_proxy_endpoint: Option<DBProxyEndpoint>,
}

#[allow(dead_code)]
struct CreateDBProxyEndpointResponseDeserializer;
impl CreateDBProxyEndpointResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateDBProxyEndpointResponse, XmlParseError> {
        deserialize_elements::<_, CreateDBProxyEndpointResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DBProxyEndpoint" => {
                        obj.db_proxy_endpoint = Some(DBProxyEndpointDeserializer::deserialize(
                            "DBProxyEndpoint",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateDBProxyRequest {
    /// <p>The authorization mechanism that the proxy uses.</p>
    pub auth: Vec<UserAuthConfig>,
    /// <p>The identifier for the proxy. This name must be unique for all proxies owned by your Amazon Web Services account in the specified Amazon Web Services Region. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.</p>
    pub db_proxy_name: String,
    /// <p>Whether the proxy includes detailed information about SQL statements in its logs. This information helps you to debug issues involving SQL behavior or the performance and scalability of the proxy connections. The debug information includes the text of SQL statements that you submit through the proxy. Thus, only enable this setting when needed for debugging, and only when you have security measures in place to safeguard any sensitive information that appears in the logs.</p>
    pub debug_logging: Option<bool>,
    /// <p>The kinds of databases that the proxy can connect to. This value determines which database network protocol the proxy recognizes when it interprets network traffic to and from the database. The engine family applies to MySQL and PostgreSQL for both RDS and Aurora.</p>
    pub engine_family: String,
    /// <p>The number of seconds that a connection to the proxy can be inactive before the proxy disconnects it. You can set this value higher or lower than the connection timeout limit for the associated database.</p>
    pub idle_client_timeout: Option<i64>,
    /// <p>A Boolean parameter that specifies whether Transport Layer Security (TLS) encryption is required for connections to the proxy. By enabling this setting, you can enforce encrypted TLS connections to the proxy.</p>
    pub require_tls: Option<bool>,
    /// <p>The Amazon Resource Name (ARN) of the IAM role that the proxy uses to access secrets in Amazon Web Services Secrets Manager.</p>
    pub role_arn: String,
    /// <p>An optional set of key-value pairs to associate arbitrary data of your choosing with the proxy.</p>
    pub tags: Option<Vec<Tag>>,
    /// <p>One or more VPC security group IDs to associate with the new proxy.</p>
    pub vpc_security_group_ids: Option<Vec<String>>,
    /// <p>One or more VPC subnet IDs to associate with the new proxy.</p>
    pub vpc_subnet_ids: Vec<String>,
}

/// Serialize `CreateDBProxyRequest` contents to a `SignedRequest`.
struct CreateDBProxyRequestSerializer;
impl CreateDBProxyRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateDBProxyRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        UserAuthConfigListSerializer::serialize(
            params,
            &format!("{}{}", prefix, "Auth"),
            &obj.auth,
        );
        params.put(&format!("{}{}", prefix, "DBProxyName"), &obj.db_proxy_name);
        if let Some(ref field_value) = obj.debug_logging {
            params.put(&format!("{}{}", prefix, "DebugLogging"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "EngineFamily"), &obj.engine_family);
        if let Some(ref field_value) = obj.idle_client_timeout {
            params.put(&format!("{}{}", prefix, "IdleClientTimeout"), &field_value);
        }
        if let Some(ref field_value) = obj.require_tls {
            params.put(&format!("{}{}", prefix, "RequireTLS"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "RoleArn"), &obj.role_arn);
        if let Some(ref field_value) = obj.tags {
            TagListSerializer::serialize(params, &format!("{}{}", prefix, "Tag"), field_value);
        }
        if let Some(ref field_value) = obj.vpc_security_group_ids {
            StringListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "VpcSecurityGroupIds"),
                field_value,
            );
        }
        StringListSerializer::serialize(
            params,
            &format!("{}{}", prefix, "VpcSubnetIds"),
            &obj.vpc_subnet_ids,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateDBProxyResponse {
    /// <p>The <code>DBProxy</code> structure corresponding to the new proxy.</p>
    pub db_proxy: Option<DBProxy>,
}

#[allow(dead_code)]
struct CreateDBProxyResponseDeserializer;
impl CreateDBProxyResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateDBProxyResponse, XmlParseError> {
        deserialize_elements::<_, CreateDBProxyResponse, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "DBProxy" => {
                    obj.db_proxy = Some(DBProxyDeserializer::deserialize("DBProxy", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateDBSecurityGroupMessage {
    /// <p>The description for the DB security group.</p>
    pub db_security_group_description: String,
    /// <p>The name for the DB security group. This value is stored as a lowercase string.</p> <p>Constraints:</p> <ul> <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li> <li> <p>First character must be a letter</p> </li> <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li> <li> <p>Must not be "Default"</p> </li> </ul> <p>Example: <code>mysecuritygroup</code> </p>
    pub db_security_group_name: String,
    /// <p>Tags to assign to the DB security group.</p>
    pub tags: Option<Vec<Tag>>,
}

/// Serialize `CreateDBSecurityGroupMessage` contents to a `SignedRequest`.
struct CreateDBSecurityGroupMessageSerializer;
impl CreateDBSecurityGroupMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateDBSecurityGroupMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "DBSecurityGroupDescription"),
            &obj.db_security_group_description,
        );
        params.put(
            &format!("{}{}", prefix, "DBSecurityGroupName"),
            &obj.db_security_group_name,
        );
        if let Some(ref field_value) = obj.tags {
            TagListSerializer::serialize(params, &format!("{}{}", prefix, "Tag"), field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateDBSecurityGroupResult {
    pub db_security_group: Option<DBSecurityGroup>,
}

#[allow(dead_code)]
struct CreateDBSecurityGroupResultDeserializer;
impl CreateDBSecurityGroupResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateDBSecurityGroupResult, XmlParseError> {
        deserialize_elements::<_, CreateDBSecurityGroupResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DBSecurityGroup" => {
                        obj.db_security_group = Some(DBSecurityGroupDeserializer::deserialize(
                            "DBSecurityGroup",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateDBSnapshotMessage {
    /// <p><p>The identifier of the DB instance that you want to create the snapshot of.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing DBInstance.</p> </li> </ul></p>
    pub db_instance_identifier: String,
    /// <p>The identifier for the DB snapshot.</p> <p>Constraints:</p> <ul> <li> <p>Can't be null, empty, or blank</p> </li> <li> <p>Must contain from 1 to 255 letters, numbers, or hyphens</p> </li> <li> <p>First character must be a letter</p> </li> <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li> </ul> <p>Example: <code>my-snapshot-id</code> </p>
    pub db_snapshot_identifier: String,
    pub tags: Option<Vec<Tag>>,
}

/// Serialize `CreateDBSnapshotMessage` contents to a `SignedRequest`.
struct CreateDBSnapshotMessageSerializer;
impl CreateDBSnapshotMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateDBSnapshotMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "DBInstanceIdentifier"),
            &obj.db_instance_identifier,
        );
        params.put(
            &format!("{}{}", prefix, "DBSnapshotIdentifier"),
            &obj.db_snapshot_identifier,
        );
        if let Some(ref field_value) = obj.tags {
            TagListSerializer::serialize(params, &format!("{}{}", prefix, "Tag"), field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateDBSnapshotResult {
    pub db_snapshot: Option<DBSnapshot>,
}

#[allow(dead_code)]
struct CreateDBSnapshotResultDeserializer;
impl CreateDBSnapshotResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateDBSnapshotResult, XmlParseError> {
        deserialize_elements::<_, CreateDBSnapshotResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "DBSnapshot" => {
                    obj.db_snapshot =
                        Some(DBSnapshotDeserializer::deserialize("DBSnapshot", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateDBSubnetGroupMessage {
    /// <p>The description for the DB subnet group.</p>
    pub db_subnet_group_description: String,
    /// <p>The name for the DB subnet group. This value is stored as a lowercase string.</p> <p>Constraints: Must contain no more than 255 letters, numbers, periods, underscores, spaces, or hyphens. Must not be default.</p> <p>Example: <code>mySubnetgroup</code> </p>
    pub db_subnet_group_name: String,
    /// <p>The EC2 Subnet IDs for the DB subnet group.</p>
    pub subnet_ids: Vec<String>,
    /// <p>Tags to assign to the DB subnet group.</p>
    pub tags: Option<Vec<Tag>>,
}

/// Serialize `CreateDBSubnetGroupMessage` contents to a `SignedRequest`.
struct CreateDBSubnetGroupMessageSerializer;
impl CreateDBSubnetGroupMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateDBSubnetGroupMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "DBSubnetGroupDescription"),
            &obj.db_subnet_group_description,
        );
        params.put(
            &format!("{}{}", prefix, "DBSubnetGroupName"),
            &obj.db_subnet_group_name,
        );
        SubnetIdentifierListSerializer::serialize(
            params,
            &format!("{}{}", prefix, "SubnetIdentifier"),
            &obj.subnet_ids,
        );
        if let Some(ref field_value) = obj.tags {
            TagListSerializer::serialize(params, &format!("{}{}", prefix, "Tag"), field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateDBSubnetGroupResult {
    pub db_subnet_group: Option<DBSubnetGroup>,
}

#[allow(dead_code)]
struct CreateDBSubnetGroupResultDeserializer;
impl CreateDBSubnetGroupResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateDBSubnetGroupResult, XmlParseError> {
        deserialize_elements::<_, CreateDBSubnetGroupResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DBSubnetGroup" => {
                        obj.db_subnet_group = Some(DBSubnetGroupDeserializer::deserialize(
                            "DBSubnetGroup",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateEventSubscriptionMessage {
    /// <p> A value that indicates whether to activate the subscription. If the event notification subscription isn't activated, the subscription is created but not active. </p>
    pub enabled: Option<bool>,
    /// <p> A list of event categories for a particular source type (<code>SourceType</code>) that you want to subscribe to. You can see a list of the categories for a given source type in <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html">Events</a> in the <i>Amazon RDS User Guide</i> or by using the <code>DescribeEventCategories</code> operation. </p>
    pub event_categories: Option<Vec<String>>,
    /// <p>The Amazon Resource Name (ARN) of the SNS topic created for event notification. The ARN is created by Amazon SNS when you create a topic and subscribe to it.</p>
    pub sns_topic_arn: String,
    /// <p><p>The list of identifiers of the event sources for which events are returned. If not specified, then all sources are included in the response. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens. It can&#39;t end with a hyphen or contain two consecutive hyphens.</p> <p>Constraints:</p> <ul> <li> <p>If <code>SourceIds</code> are supplied, <code>SourceType</code> must also be provided.</p> </li> <li> <p>If the source type is a DB instance, a <code>DBInstanceIdentifier</code> value must be supplied.</p> </li> <li> <p>If the source type is a DB cluster, a <code>DBClusterIdentifier</code> value must be supplied.</p> </li> <li> <p>If the source type is a DB parameter group, a <code>DBParameterGroupName</code> value must be supplied.</p> </li> <li> <p>If the source type is a DB security group, a <code>DBSecurityGroupName</code> value must be supplied.</p> </li> <li> <p>If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> value must be supplied.</p> </li> <li> <p>If the source type is a DB cluster snapshot, a <code>DBClusterSnapshotIdentifier</code> value must be supplied.</p> </li> </ul></p>
    pub source_ids: Option<Vec<String>>,
    /// <p>The type of source that is generating the events. For example, if you want to be notified of events generated by a DB instance, you set this parameter to <code>db-instance</code>. If this value isn't specified, all events are returned.</p> <p>Valid values: <code>db-instance</code> | <code>db-cluster</code> | <code>db-parameter-group</code> | <code>db-security-group</code> | <code>db-snapshot</code> | <code>db-cluster-snapshot</code> </p>
    pub source_type: Option<String>,
    /// <p>The name of the subscription.</p> <p>Constraints: The name must be less than 255 characters.</p>
    pub subscription_name: String,
    pub tags: Option<Vec<Tag>>,
}

/// Serialize `CreateEventSubscriptionMessage` contents to a `SignedRequest`.
struct CreateEventSubscriptionMessageSerializer;
impl CreateEventSubscriptionMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateEventSubscriptionMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.enabled {
            params.put(&format!("{}{}", prefix, "Enabled"), &field_value);
        }
        if let Some(ref field_value) = obj.event_categories {
            EventCategoriesListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "EventCategory"),
                field_value,
            );
        }
        params.put(&format!("{}{}", prefix, "SnsTopicArn"), &obj.sns_topic_arn);
        if let Some(ref field_value) = obj.source_ids {
            SourceIdsListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "SourceId"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.source_type {
            params.put(&format!("{}{}", prefix, "SourceType"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "SubscriptionName"),
            &obj.subscription_name,
        );
        if let Some(ref field_value) = obj.tags {
            TagListSerializer::serialize(params, &format!("{}{}", prefix, "Tag"), field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateEventSubscriptionResult {
    pub event_subscription: Option<EventSubscription>,
}

#[allow(dead_code)]
struct CreateEventSubscriptionResultDeserializer;
impl CreateEventSubscriptionResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateEventSubscriptionResult, XmlParseError> {
        deserialize_elements::<_, CreateEventSubscriptionResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "EventSubscription" => {
                        obj.event_subscription = Some(EventSubscriptionDeserializer::deserialize(
                            "EventSubscription",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateGlobalClusterMessage {
    /// <p> The name for your database of up to 64 alpha-numeric characters. If you do not provide a name, Amazon Aurora will not create a database in the global database cluster you are creating. </p>
    pub database_name: Option<String>,
    /// <p> The deletion protection setting for the new global database. The global database can't be deleted when deletion protection is enabled. </p>
    pub deletion_protection: Option<bool>,
    /// <p>The name of the database engine to be used for this DB cluster.</p>
    pub engine: Option<String>,
    /// <p>The engine version of the Aurora global database.</p>
    pub engine_version: Option<String>,
    /// <p>The cluster identifier of the new global database cluster.</p>
    pub global_cluster_identifier: Option<String>,
    /// <p> The Amazon Resource Name (ARN) to use as the primary cluster of the global database. This parameter is optional. </p>
    pub source_db_cluster_identifier: Option<String>,
    /// <p> The storage encryption setting for the new global database cluster. </p>
    pub storage_encrypted: Option<bool>,
}

/// Serialize `CreateGlobalClusterMessage` contents to a `SignedRequest`.
struct CreateGlobalClusterMessageSerializer;
impl CreateGlobalClusterMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateGlobalClusterMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.database_name {
            params.put(&format!("{}{}", prefix, "DatabaseName"), &field_value);
        }
        if let Some(ref field_value) = obj.deletion_protection {
            params.put(&format!("{}{}", prefix, "DeletionProtection"), &field_value);
        }
        if let Some(ref field_value) = obj.engine {
            params.put(&format!("{}{}", prefix, "Engine"), &field_value);
        }
        if let Some(ref field_value) = obj.engine_version {
            params.put(&format!("{}{}", prefix, "EngineVersion"), &field_value);
        }
        if let Some(ref field_value) = obj.global_cluster_identifier {
            params.put(
                &format!("{}{}", prefix, "GlobalClusterIdentifier"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.source_db_cluster_identifier {
            params.put(
                &format!("{}{}", prefix, "SourceDBClusterIdentifier"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.storage_encrypted {
            params.put(&format!("{}{}", prefix, "StorageEncrypted"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateGlobalClusterResult {
    pub global_cluster: Option<GlobalCluster>,
}

#[allow(dead_code)]
struct CreateGlobalClusterResultDeserializer;
impl CreateGlobalClusterResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateGlobalClusterResult, XmlParseError> {
        deserialize_elements::<_, CreateGlobalClusterResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "GlobalCluster" => {
                        obj.global_cluster = Some(GlobalClusterDeserializer::deserialize(
                            "GlobalCluster",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateOptionGroupMessage {
    /// <p><p>Specifies the name of the engine that this option group should be associated with.</p> <p>Valid Values: </p> <ul> <li> <p> <code>mariadb</code> </p> </li> <li> <p> <code>mysql</code> </p> </li> <li> <p> <code>oracle-ee</code> </p> </li> <li> <p> <code>oracle-ee-cdb</code> </p> </li> <li> <p> <code>oracle-se2</code> </p> </li> <li> <p> <code>oracle-se2-cdb</code> </p> </li> <li> <p> <code>postgres</code> </p> </li> <li> <p> <code>sqlserver-ee</code> </p> </li> <li> <p> <code>sqlserver-se</code> </p> </li> <li> <p> <code>sqlserver-ex</code> </p> </li> <li> <p> <code>sqlserver-web</code> </p> </li> </ul></p>
    pub engine_name: String,
    /// <p>Specifies the major version of the engine that this option group should be associated with.</p>
    pub major_engine_version: String,
    /// <p>The description of the option group.</p>
    pub option_group_description: String,
    /// <p>Specifies the name of the option group to be created.</p> <p>Constraints:</p> <ul> <li> <p>Must be 1 to 255 letters, numbers, or hyphens</p> </li> <li> <p>First character must be a letter</p> </li> <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li> </ul> <p>Example: <code>myoptiongroup</code> </p>
    pub option_group_name: String,
    /// <p>Tags to assign to the option group.</p>
    pub tags: Option<Vec<Tag>>,
}

/// Serialize `CreateOptionGroupMessage` contents to a `SignedRequest`.
struct CreateOptionGroupMessageSerializer;
impl CreateOptionGroupMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateOptionGroupMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "EngineName"), &obj.engine_name);
        params.put(
            &format!("{}{}", prefix, "MajorEngineVersion"),
            &obj.major_engine_version,
        );
        params.put(
            &format!("{}{}", prefix, "OptionGroupDescription"),
            &obj.option_group_description,
        );
        params.put(
            &format!("{}{}", prefix, "OptionGroupName"),
            &obj.option_group_name,
        );
        if let Some(ref field_value) = obj.tags {
            TagListSerializer::serialize(params, &format!("{}{}", prefix, "Tag"), field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateOptionGroupResult {
    pub option_group: Option<OptionGroup>,
}

#[allow(dead_code)]
struct CreateOptionGroupResultDeserializer;
impl CreateOptionGroupResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateOptionGroupResult, XmlParseError> {
        deserialize_elements::<_, CreateOptionGroupResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "OptionGroup" => {
                        obj.option_group =
                            Some(OptionGroupDeserializer::deserialize("OptionGroup", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>A custom Availability Zone (AZ) is an on-premises AZ that is integrated with a VMware vSphere cluster.</p> <p>For more information about RDS on VMware, see the <a href="https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html"> RDS on VMware User Guide.</a> </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CustomAvailabilityZone {
    /// <p>The identifier of the custom AZ.</p> <p>Amazon RDS generates a unique identifier when a custom AZ is created.</p>
    pub custom_availability_zone_id: Option<String>,
    /// <p>The name of the custom AZ.</p>
    pub custom_availability_zone_name: Option<String>,
    /// <p>The status of the custom AZ.</p>
    pub custom_availability_zone_status: Option<String>,
    /// <p>Information about the virtual private network (VPN) between the VMware vSphere cluster and the Amazon Web Services website.</p>
    pub vpn_details: Option<VpnDetails>,
}

#[allow(dead_code)]
struct CustomAvailabilityZoneDeserializer;
impl CustomAvailabilityZoneDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CustomAvailabilityZone, XmlParseError> {
        deserialize_elements::<_, CustomAvailabilityZone, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "CustomAvailabilityZoneId" => {
                    obj.custom_availability_zone_id = Some(StringDeserializer::deserialize(
                        "CustomAvailabilityZoneId",
                        stack,
                    )?);
                }
                "CustomAvailabilityZoneName" => {
                    obj.custom_availability_zone_name = Some(StringDeserializer::deserialize(
                        "CustomAvailabilityZoneName",
                        stack,
                    )?);
                }
                "CustomAvailabilityZoneStatus" => {
                    obj.custom_availability_zone_status = Some(StringDeserializer::deserialize(
                        "CustomAvailabilityZoneStatus",
                        stack,
                    )?);
                }
                "VpnDetails" => {
                    obj.vpn_details =
                        Some(VpnDetailsDeserializer::deserialize("VpnDetails", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct CustomAvailabilityZoneListDeserializer;
impl CustomAvailabilityZoneListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<CustomAvailabilityZone>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "CustomAvailabilityZone" {
                obj.push(CustomAvailabilityZoneDeserializer::deserialize(
                    "CustomAvailabilityZone",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CustomAvailabilityZoneMessage {
    /// <p>The list of <a>CustomAvailabilityZone</a> objects for the Amazon Web Services account.</p>
    pub custom_availability_zones: Option<Vec<CustomAvailabilityZone>>,
    /// <p>An optional pagination token provided by a previous <code>DescribeCustomAvailabilityZones</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub marker: Option<String>,
}

#[allow(dead_code)]
struct CustomAvailabilityZoneMessageDeserializer;
impl CustomAvailabilityZoneMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CustomAvailabilityZoneMessage, XmlParseError> {
        deserialize_elements::<_, CustomAvailabilityZoneMessage, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "CustomAvailabilityZones" => {
                        obj.custom_availability_zones.get_or_insert(vec![]).extend(
                            CustomAvailabilityZoneListDeserializer::deserialize(
                                "CustomAvailabilityZones",
                                stack,
                            )?,
                        );
                    }
                    "Marker" => {
                        obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Contains the details of an Amazon Aurora DB cluster. </p> <p>This data type is used as a response element in the <code>DescribeDBClusters</code>, <code>StopDBCluster</code>, and <code>StartDBCluster</code> actions. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DBCluster {
    /// <p>The name of the Amazon Kinesis data stream used for the database activity stream.</p>
    pub activity_stream_kinesis_stream_name: Option<String>,
    /// <p>The Amazon Web Services KMS key identifier used for encrypting messages in the database activity stream.</p> <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the Amazon Web Services KMS customer master key (CMK).</p>
    pub activity_stream_kms_key_id: Option<String>,
    /// <p>The mode of the database activity stream. Database events such as a change or access generate an activity stream event. The database session can handle these events either synchronously or asynchronously. </p>
    pub activity_stream_mode: Option<String>,
    /// <p>The status of the database activity stream.</p>
    pub activity_stream_status: Option<String>,
    /// <p>For all database engines except Amazon Aurora, <code>AllocatedStorage</code> specifies the allocated storage size in gibibytes (GiB). For Aurora, <code>AllocatedStorage</code> always returns 1, because Aurora DB cluster storage size isn't fixed, but instead automatically adjusts as needed.</p>
    pub allocated_storage: Option<i64>,
    /// <p>Provides a list of the Amazon Web Services Identity and Access Management (IAM) roles that are associated with the DB cluster. IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other Amazon Web Services on your behalf.</p>
    pub associated_roles: Option<Vec<DBClusterRole>>,
    /// <p>Provides the list of Availability Zones (AZs) where instances in the DB cluster can be created.</p>
    pub availability_zones: Option<Vec<String>>,
    /// <p>The number of change records stored for Backtrack.</p>
    pub backtrack_consumed_change_records: Option<i64>,
    /// <p>The target backtrack window, in seconds. If this value is set to 0, backtracking is disabled for the DB cluster. Otherwise, backtracking is enabled.</p>
    pub backtrack_window: Option<i64>,
    /// <p>Specifies the number of days for which automatic DB snapshots are retained.</p>
    pub backup_retention_period: Option<i64>,
    /// <p>The current capacity of an Aurora Serverless DB cluster. The capacity is 0 (zero) when the cluster is paused.</p> <p>For more information about Aurora Serverless, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html">Using Amazon Aurora Serverless</a> in the <i>Amazon Aurora User Guide</i>.</p>
    pub capacity: Option<i64>,
    /// <p>If present, specifies the name of the character set that this cluster is associated with.</p>
    pub character_set_name: Option<String>,
    /// <p>Identifies the clone group to which the DB cluster is associated.</p>
    pub clone_group_id: Option<String>,
    /// <p>Specifies the time when the DB cluster was created, in Universal Coordinated Time (UTC).</p>
    pub cluster_create_time: Option<String>,
    /// <p>Specifies whether tags are copied from the DB cluster to snapshots of the DB cluster.</p>
    pub copy_tags_to_snapshot: Option<bool>,
    /// <p>Specifies whether the DB cluster is a clone of a DB cluster owned by a different Amazon Web Services account.</p>
    pub cross_account_clone: Option<bool>,
    /// <p>Identifies all custom endpoints associated with the cluster.</p>
    pub custom_endpoints: Option<Vec<String>>,
    /// <p>The Amazon Resource Name (ARN) for the DB cluster.</p>
    pub db_cluster_arn: Option<String>,
    /// <p>Contains a user-supplied DB cluster identifier. This identifier is the unique key that identifies a DB cluster.</p>
    pub db_cluster_identifier: Option<String>,
    /// <p>Provides the list of instances that make up the DB cluster.</p>
    pub db_cluster_members: Option<Vec<DBClusterMember>>,
    /// <p>Provides the list of option group memberships for this DB cluster.</p>
    pub db_cluster_option_group_memberships: Option<Vec<DBClusterOptionGroupStatus>>,
    /// <p>Specifies the name of the DB cluster parameter group for the DB cluster.</p>
    pub db_cluster_parameter_group: Option<String>,
    /// <p>Specifies information on the subnet group associated with the DB cluster, including the name, description, and subnets in the subnet group.</p>
    pub db_subnet_group: Option<String>,
    /// <p>Contains the name of the initial database of this DB cluster that was provided at create time, if one was specified when the DB cluster was created. This same name is returned for the life of the DB cluster.</p>
    pub database_name: Option<String>,
    /// <p>The Amazon Web Services Region-unique, immutable identifier for the DB cluster. This identifier is found in Amazon Web Services CloudTrail log entries whenever the Amazon Web Services KMS CMK for the DB cluster is accessed.</p>
    pub db_cluster_resource_id: Option<String>,
    /// <p>Indicates if the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. </p>
    pub deletion_protection: Option<bool>,
    /// <p>The Active Directory Domain membership records associated with the DB cluster.</p>
    pub domain_memberships: Option<Vec<DomainMembership>>,
    /// <p>The earliest time to which a DB cluster can be backtracked.</p>
    pub earliest_backtrack_time: Option<String>,
    /// <p>The earliest time to which a database can be restored with point-in-time restore.</p>
    pub earliest_restorable_time: Option<String>,
    /// <p>A list of log types that this DB cluster is configured to export to CloudWatch Logs.</p> <p>Log types vary by DB engine. For information about the log types for each DB engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html">Amazon RDS Database Log Files</a> in the <i>Amazon Aurora User Guide.</i> </p>
    pub enabled_cloudwatch_logs_exports: Option<Vec<String>>,
    /// <p>Specifies the connection endpoint for the primary instance of the DB cluster.</p>
    pub endpoint: Option<String>,
    /// <p>The name of the database engine to be used for this DB cluster.</p>
    pub engine: Option<String>,
    /// <p>The DB engine mode of the DB cluster, either <code>provisioned</code>, <code>serverless</code>, <code>parallelquery</code>, <code>global</code>, or <code>multimaster</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBCluster.html"> CreateDBCluster</a>.</p>
    pub engine_mode: Option<String>,
    /// <p>Indicates the database engine version.</p>
    pub engine_version: Option<String>,
    /// <p>Specifies whether you have requested to enable write forwarding for a secondary cluster in an Aurora global database. Because write forwarding takes time to enable, check the value of <code>GlobalWriteForwardingStatus</code> to confirm that the request has completed before using the write forwarding feature for this cluster.</p>
    pub global_write_forwarding_requested: Option<bool>,
    /// <p>Specifies whether a secondary cluster in an Aurora global database has write forwarding enabled, not enabled, or is in the process of enabling it.</p>
    pub global_write_forwarding_status: Option<String>,
    /// <p>Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.</p>
    pub hosted_zone_id: Option<String>,
    /// <p>A value that indicates whether the HTTP endpoint for an Aurora Serverless DB cluster is enabled.</p> <p>When enabled, the HTTP endpoint provides a connectionless web service API for running SQL queries on the Aurora Serverless DB cluster. You can also query your database from inside the RDS console with the query editor.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using the Data API for Aurora Serverless</a> in the <i>Amazon Aurora User Guide</i>.</p>
    pub http_endpoint_enabled: Option<bool>,
    /// <p>A value that indicates whether the mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled.</p>
    pub iam_database_authentication_enabled: Option<bool>,
    /// <p>If <code>StorageEncrypted</code> is enabled, the Amazon Web Services KMS key identifier for the encrypted DB cluster.</p> <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the Amazon Web Services KMS customer master key (CMK).</p>
    pub kms_key_id: Option<String>,
    /// <p>Specifies the latest time to which a database can be restored with point-in-time restore.</p>
    pub latest_restorable_time: Option<String>,
    /// <p>Contains the master username for the DB cluster.</p>
    pub master_username: Option<String>,
    /// <p>Specifies whether the DB cluster has instances in multiple Availability Zones.</p>
    pub multi_az: Option<bool>,
    /// <p>A value that specifies that changes to the DB cluster are pending. This element is only included when changes are pending. Specific changes are identified by subelements.</p>
    pub pending_modified_values: Option<ClusterPendingModifiedValues>,
    /// <p>Specifies the progress of the operation as a percentage.</p>
    pub percent_progress: Option<String>,
    /// <p>Specifies the port that the database engine is listening on.</p>
    pub port: Option<i64>,
    /// <p>Specifies the daily time range during which automated backups are created if automated backups are enabled, as determined by the <code>BackupRetentionPeriod</code>. </p>
    pub preferred_backup_window: Option<String>,
    /// <p>Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p>
    pub preferred_maintenance_window: Option<String>,
    /// <p>Contains one or more identifiers of the read replicas associated with this DB cluster.</p>
    pub read_replica_identifiers: Option<Vec<String>>,
    /// <p>The reader endpoint for the DB cluster. The reader endpoint for a DB cluster load-balances connections across the Aurora Replicas that are available in a DB cluster. As clients request new connections to the reader endpoint, Aurora distributes the connection requests among the Aurora Replicas in the DB cluster. This functionality can help balance your read workload across multiple Aurora Replicas in your DB cluster. </p> <p>If a failover occurs, and the Aurora Replica that you are connected to is promoted to be the primary instance, your connection is dropped. To continue sending your read workload to other Aurora Replicas in the cluster, you can then reconnect to the reader endpoint.</p>
    pub reader_endpoint: Option<String>,
    /// <p>Contains the identifier of the source DB cluster if this DB cluster is a read replica.</p>
    pub replication_source_identifier: Option<String>,
    pub scaling_configuration_info: Option<ScalingConfigurationInfo>,
    /// <p>Specifies the current state of this DB cluster.</p>
    pub status: Option<String>,
    /// <p>Specifies whether the DB cluster is encrypted.</p>
    pub storage_encrypted: Option<bool>,
    pub tag_list: Option<Vec<Tag>>,
    /// <p>Provides a list of VPC security groups that the DB cluster belongs to.</p>
    pub vpc_security_groups: Option<Vec<VpcSecurityGroupMembership>>,
}

#[allow(dead_code)]
struct DBClusterDeserializer;
impl DBClusterDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DBCluster, XmlParseError> {
        deserialize_elements::<_, DBCluster, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "ActivityStreamKinesisStreamName" => {
                    obj.activity_stream_kinesis_stream_name = Some(
                        StringDeserializer::deserialize("ActivityStreamKinesisStreamName", stack)?,
                    );
                }
                "ActivityStreamKmsKeyId" => {
                    obj.activity_stream_kms_key_id = Some(StringDeserializer::deserialize(
                        "ActivityStreamKmsKeyId",
                        stack,
                    )?);
                }
                "ActivityStreamMode" => {
                    obj.activity_stream_mode = Some(ActivityStreamModeDeserializer::deserialize(
                        "ActivityStreamMode",
                        stack,
                    )?);
                }
                "ActivityStreamStatus" => {
                    obj.activity_stream_status =
                        Some(ActivityStreamStatusDeserializer::deserialize(
                            "ActivityStreamStatus",
                            stack,
                        )?);
                }
                "AllocatedStorage" => {
                    obj.allocated_storage = Some(IntegerOptionalDeserializer::deserialize(
                        "AllocatedStorage",
                        stack,
                    )?);
                }
                "AssociatedRoles" => {
                    obj.associated_roles.get_or_insert(vec![]).extend(
                        DBClusterRolesDeserializer::deserialize("AssociatedRoles", stack)?,
                    );
                }
                "AvailabilityZones" => {
                    obj.availability_zones.get_or_insert(vec![]).extend(
                        AvailabilityZonesDeserializer::deserialize("AvailabilityZones", stack)?,
                    );
                }
                "BacktrackConsumedChangeRecords" => {
                    obj.backtrack_consumed_change_records =
                        Some(LongOptionalDeserializer::deserialize(
                            "BacktrackConsumedChangeRecords",
                            stack,
                        )?);
                }
                "BacktrackWindow" => {
                    obj.backtrack_window = Some(LongOptionalDeserializer::deserialize(
                        "BacktrackWindow",
                        stack,
                    )?);
                }
                "BackupRetentionPeriod" => {
                    obj.backup_retention_period = Some(IntegerOptionalDeserializer::deserialize(
                        "BackupRetentionPeriod",
                        stack,
                    )?);
                }
                "Capacity" => {
                    obj.capacity =
                        Some(IntegerOptionalDeserializer::deserialize("Capacity", stack)?);
                }
                "CharacterSetName" => {
                    obj.character_set_name =
                        Some(StringDeserializer::deserialize("CharacterSetName", stack)?);
                }
                "CloneGroupId" => {
                    obj.clone_group_id =
                        Some(StringDeserializer::deserialize("CloneGroupId", stack)?);
                }
                "ClusterCreateTime" => {
                    obj.cluster_create_time =
                        Some(TStampDeserializer::deserialize("ClusterCreateTime", stack)?);
                }
                "CopyTagsToSnapshot" => {
                    obj.copy_tags_to_snapshot = Some(BooleanOptionalDeserializer::deserialize(
                        "CopyTagsToSnapshot",
                        stack,
                    )?);
                }
                "CrossAccountClone" => {
                    obj.cross_account_clone = Some(BooleanOptionalDeserializer::deserialize(
                        "CrossAccountClone",
                        stack,
                    )?);
                }
                "CustomEndpoints" => {
                    obj.custom_endpoints.get_or_insert(vec![]).extend(
                        StringListDeserializer::deserialize("CustomEndpoints", stack)?,
                    );
                }
                "DBClusterArn" => {
                    obj.db_cluster_arn =
                        Some(StringDeserializer::deserialize("DBClusterArn", stack)?);
                }
                "DBClusterIdentifier" => {
                    obj.db_cluster_identifier = Some(StringDeserializer::deserialize(
                        "DBClusterIdentifier",
                        stack,
                    )?);
                }
                "DBClusterMembers" => {
                    obj.db_cluster_members.get_or_insert(vec![]).extend(
                        DBClusterMemberListDeserializer::deserialize("DBClusterMembers", stack)?,
                    );
                }
                "DBClusterOptionGroupMemberships" => {
                    obj.db_cluster_option_group_memberships
                        .get_or_insert(vec![])
                        .extend(DBClusterOptionGroupMembershipsDeserializer::deserialize(
                            "DBClusterOptionGroupMemberships",
                            stack,
                        )?);
                }
                "DBClusterParameterGroup" => {
                    obj.db_cluster_parameter_group = Some(StringDeserializer::deserialize(
                        "DBClusterParameterGroup",
                        stack,
                    )?);
                }
                "DBSubnetGroup" => {
                    obj.db_subnet_group =
                        Some(StringDeserializer::deserialize("DBSubnetGroup", stack)?);
                }
                "DatabaseName" => {
                    obj.database_name =
                        Some(StringDeserializer::deserialize("DatabaseName", stack)?);
                }
                "DbClusterResourceId" => {
                    obj.db_cluster_resource_id = Some(StringDeserializer::deserialize(
                        "DbClusterResourceId",
                        stack,
                    )?);
                }
                "DeletionProtection" => {
                    obj.deletion_protection = Some(BooleanOptionalDeserializer::deserialize(
                        "DeletionProtection",
                        stack,
                    )?);
                }
                "DomainMemberships" => {
                    obj.domain_memberships.get_or_insert(vec![]).extend(
                        DomainMembershipListDeserializer::deserialize("DomainMemberships", stack)?,
                    );
                }
                "EarliestBacktrackTime" => {
                    obj.earliest_backtrack_time = Some(TStampDeserializer::deserialize(
                        "EarliestBacktrackTime",
                        stack,
                    )?);
                }
                "EarliestRestorableTime" => {
                    obj.earliest_restorable_time = Some(TStampDeserializer::deserialize(
                        "EarliestRestorableTime",
                        stack,
                    )?);
                }
                "EnabledCloudwatchLogsExports" => {
                    obj.enabled_cloudwatch_logs_exports
                        .get_or_insert(vec![])
                        .extend(LogTypeListDeserializer::deserialize(
                            "EnabledCloudwatchLogsExports",
                            stack,
                        )?);
                }
                "Endpoint" => {
                    obj.endpoint = Some(StringDeserializer::deserialize("Endpoint", stack)?);
                }
                "Engine" => {
                    obj.engine = Some(StringDeserializer::deserialize("Engine", stack)?);
                }
                "EngineMode" => {
                    obj.engine_mode = Some(StringDeserializer::deserialize("EngineMode", stack)?);
                }
                "EngineVersion" => {
                    obj.engine_version =
                        Some(StringDeserializer::deserialize("EngineVersion", stack)?);
                }
                "GlobalWriteForwardingRequested" => {
                    obj.global_write_forwarding_requested =
                        Some(BooleanOptionalDeserializer::deserialize(
                            "GlobalWriteForwardingRequested",
                            stack,
                        )?);
                }
                "GlobalWriteForwardingStatus" => {
                    obj.global_write_forwarding_status =
                        Some(WriteForwardingStatusDeserializer::deserialize(
                            "GlobalWriteForwardingStatus",
                            stack,
                        )?);
                }
                "HostedZoneId" => {
                    obj.hosted_zone_id =
                        Some(StringDeserializer::deserialize("HostedZoneId", stack)?);
                }
                "HttpEndpointEnabled" => {
                    obj.http_endpoint_enabled = Some(BooleanOptionalDeserializer::deserialize(
                        "HttpEndpointEnabled",
                        stack,
                    )?);
                }
                "IAMDatabaseAuthenticationEnabled" => {
                    obj.iam_database_authentication_enabled =
                        Some(BooleanOptionalDeserializer::deserialize(
                            "IAMDatabaseAuthenticationEnabled",
                            stack,
                        )?);
                }
                "KmsKeyId" => {
                    obj.kms_key_id = Some(StringDeserializer::deserialize("KmsKeyId", stack)?);
                }
                "LatestRestorableTime" => {
                    obj.latest_restorable_time = Some(TStampDeserializer::deserialize(
                        "LatestRestorableTime",
                        stack,
                    )?);
                }
                "MasterUsername" => {
                    obj.master_username =
                        Some(StringDeserializer::deserialize("MasterUsername", stack)?);
                }
                "MultiAZ" => {
                    obj.multi_az =
                        Some(BooleanOptionalDeserializer::deserialize("MultiAZ", stack)?);
                }
                "PendingModifiedValues" => {
                    obj.pending_modified_values =
                        Some(ClusterPendingModifiedValuesDeserializer::deserialize(
                            "PendingModifiedValues",
                            stack,
                        )?);
                }
                "PercentProgress" => {
                    obj.percent_progress =
                        Some(StringDeserializer::deserialize("PercentProgress", stack)?);
                }
                "Port" => {
                    obj.port = Some(IntegerOptionalDeserializer::deserialize("Port", stack)?);
                }
                "PreferredBackupWindow" => {
                    obj.preferred_backup_window = Some(StringDeserializer::deserialize(
                        "PreferredBackupWindow",
                        stack,
                    )?);
                }
                "PreferredMaintenanceWindow" => {
                    obj.preferred_maintenance_window = Some(StringDeserializer::deserialize(
                        "PreferredMaintenanceWindow",
                        stack,
                    )?);
                }
                "ReadReplicaIdentifiers" => {
                    obj.read_replica_identifiers.get_or_insert(vec![]).extend(
                        ReadReplicaIdentifierListDeserializer::deserialize(
                            "ReadReplicaIdentifiers",
                            stack,
                        )?,
                    );
                }
                "ReaderEndpoint" => {
                    obj.reader_endpoint =
                        Some(StringDeserializer::deserialize("ReaderEndpoint", stack)?);
                }
                "ReplicationSourceIdentifier" => {
                    obj.replication_source_identifier = Some(StringDeserializer::deserialize(
                        "ReplicationSourceIdentifier",
                        stack,
                    )?);
                }
                "ScalingConfigurationInfo" => {
                    obj.scaling_configuration_info =
                        Some(ScalingConfigurationInfoDeserializer::deserialize(
                            "ScalingConfigurationInfo",
                            stack,
                        )?);
                }
                "Status" => {
                    obj.status = Some(StringDeserializer::deserialize("Status", stack)?);
                }
                "StorageEncrypted" => {
                    obj.storage_encrypted =
                        Some(BooleanDeserializer::deserialize("StorageEncrypted", stack)?);
                }
                "TagList" => {
                    obj.tag_list
                        .get_or_insert(vec![])
                        .extend(TagListDeserializer::deserialize("TagList", stack)?);
                }
                "VpcSecurityGroups" => {
                    obj.vpc_security_groups.get_or_insert(vec![]).extend(
                        VpcSecurityGroupMembershipListDeserializer::deserialize(
                            "VpcSecurityGroups",
                            stack,
                        )?,
                    );
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>This data type is used as a response element in the <code>DescribeDBClusterBacktracks</code> action.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DBClusterBacktrack {
    /// <p>Contains the backtrack identifier.</p>
    pub backtrack_identifier: Option<String>,
    /// <p>The timestamp of the time at which the backtrack was requested.</p>
    pub backtrack_request_creation_time: Option<String>,
    /// <p>The timestamp of the time to which the DB cluster was backtracked.</p>
    pub backtrack_to: Option<String>,
    /// <p>The timestamp of the time from which the DB cluster was backtracked.</p>
    pub backtracked_from: Option<String>,
    /// <p>Contains a user-supplied DB cluster identifier. This identifier is the unique key that identifies a DB cluster.</p>
    pub db_cluster_identifier: Option<String>,
    /// <p><p>The status of the backtrack. This property returns one of the following values:</p> <ul> <li> <p> <code>applying</code> - The backtrack is currently being applied to or rolled back from the DB cluster.</p> </li> <li> <p> <code>completed</code> - The backtrack has successfully been applied to or rolled back from the DB cluster.</p> </li> <li> <p> <code>failed</code> - An error occurred while the backtrack was applied to or rolled back from the DB cluster.</p> </li> <li> <p> <code>pending</code> - The backtrack is currently pending application to or rollback from the DB cluster.</p> </li> </ul></p>
    pub status: Option<String>,
}

#[allow(dead_code)]
struct DBClusterBacktrackDeserializer;
impl DBClusterBacktrackDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DBClusterBacktrack, XmlParseError> {
        deserialize_elements::<_, DBClusterBacktrack, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "BacktrackIdentifier" => {
                    obj.backtrack_identifier = Some(StringDeserializer::deserialize(
                        "BacktrackIdentifier",
                        stack,
                    )?);
                }
                "BacktrackRequestCreationTime" => {
                    obj.backtrack_request_creation_time = Some(TStampDeserializer::deserialize(
                        "BacktrackRequestCreationTime",
                        stack,
                    )?);
                }
                "BacktrackTo" => {
                    obj.backtrack_to = Some(TStampDeserializer::deserialize("BacktrackTo", stack)?);
                }
                "BacktrackedFrom" => {
                    obj.backtracked_from =
                        Some(TStampDeserializer::deserialize("BacktrackedFrom", stack)?);
                }
                "DBClusterIdentifier" => {
                    obj.db_cluster_identifier = Some(StringDeserializer::deserialize(
                        "DBClusterIdentifier",
                        stack,
                    )?);
                }
                "Status" => {
                    obj.status = Some(StringDeserializer::deserialize("Status", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct DBClusterBacktrackListDeserializer;
impl DBClusterBacktrackListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<DBClusterBacktrack>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "DBClusterBacktrack" {
                obj.push(DBClusterBacktrackDeserializer::deserialize(
                    "DBClusterBacktrack",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Contains the result of a successful invocation of the <code>DescribeDBClusterBacktracks</code> action.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DBClusterBacktrackMessage {
    /// <p>Contains a list of backtracks for the user.</p>
    pub db_cluster_backtracks: Option<Vec<DBClusterBacktrack>>,
    /// <p>A pagination token that can be used in a later <code>DescribeDBClusterBacktracks</code> request.</p>
    pub marker: Option<String>,
}

#[allow(dead_code)]
struct DBClusterBacktrackMessageDeserializer;
impl DBClusterBacktrackMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DBClusterBacktrackMessage, XmlParseError> {
        deserialize_elements::<_, DBClusterBacktrackMessage, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DBClusterBacktracks" => {
                        obj.db_cluster_backtracks.get_or_insert(vec![]).extend(
                            DBClusterBacktrackListDeserializer::deserialize(
                                "DBClusterBacktracks",
                                stack,
                            )?,
                        );
                    }
                    "Marker" => {
                        obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DBClusterCapacityInfo {
    /// <p>The current capacity of the DB cluster.</p>
    pub current_capacity: Option<i64>,
    /// <p>A user-supplied DB cluster identifier. This identifier is the unique key that identifies a DB cluster. </p>
    pub db_cluster_identifier: Option<String>,
    /// <p>A value that specifies the capacity that the DB cluster scales to next.</p>
    pub pending_capacity: Option<i64>,
    /// <p>The number of seconds before a call to <code>ModifyCurrentDBClusterCapacity</code> times out.</p>
    pub seconds_before_timeout: Option<i64>,
    /// <p>The timeout action of a call to <code>ModifyCurrentDBClusterCapacity</code>, either <code>ForceApplyCapacityChange</code> or <code>RollbackCapacityChange</code>.</p>
    pub timeout_action: Option<String>,
}

#[allow(dead_code)]
struct DBClusterCapacityInfoDeserializer;
impl DBClusterCapacityInfoDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DBClusterCapacityInfo, XmlParseError> {
        deserialize_elements::<_, DBClusterCapacityInfo, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "CurrentCapacity" => {
                    obj.current_capacity = Some(IntegerOptionalDeserializer::deserialize(
                        "CurrentCapacity",
                        stack,
                    )?);
                }
                "DBClusterIdentifier" => {
                    obj.db_cluster_identifier = Some(StringDeserializer::deserialize(
                        "DBClusterIdentifier",
                        stack,
                    )?);
                }
                "PendingCapacity" => {
                    obj.pending_capacity = Some(IntegerOptionalDeserializer::deserialize(
                        "PendingCapacity",
                        stack,
                    )?);
                }
                "SecondsBeforeTimeout" => {
                    obj.seconds_before_timeout = Some(IntegerOptionalDeserializer::deserialize(
                        "SecondsBeforeTimeout",
                        stack,
                    )?);
                }
                "TimeoutAction" => {
                    obj.timeout_action =
                        Some(StringDeserializer::deserialize("TimeoutAction", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>This data type represents the information you need to connect to an Amazon Aurora DB cluster. This data type is used as a response element in the following actions:</p> <ul> <li> <p> <code>CreateDBClusterEndpoint</code> </p> </li> <li> <p> <code>DescribeDBClusterEndpoints</code> </p> </li> <li> <p> <code>ModifyDBClusterEndpoint</code> </p> </li> <li> <p> <code>DeleteDBClusterEndpoint</code> </p> </li> </ul> <p>For the data structure that represents Amazon RDS DB instance endpoints, see <code>Endpoint</code>.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DBClusterEndpoint {
    /// <p>The type associated with a custom endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>
    pub custom_endpoint_type: Option<String>,
    /// <p>The Amazon Resource Name (ARN) for the endpoint.</p>
    pub db_cluster_endpoint_arn: Option<String>,
    /// <p>The identifier associated with the endpoint. This parameter is stored as a lowercase string.</p>
    pub db_cluster_endpoint_identifier: Option<String>,
    /// <p>A unique system-generated identifier for an endpoint. It remains the same for the whole life of the endpoint.</p>
    pub db_cluster_endpoint_resource_identifier: Option<String>,
    /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase string.</p>
    pub db_cluster_identifier: Option<String>,
    /// <p>The DNS address of the endpoint.</p>
    pub endpoint: Option<String>,
    /// <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>CUSTOM</code>.</p>
    pub endpoint_type: Option<String>,
    /// <p>List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.</p>
    pub excluded_members: Option<Vec<String>>,
    /// <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
    pub static_members: Option<Vec<String>>,
    /// <p>The current status of the endpoint. One of: <code>creating</code>, <code>available</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>. The <code>inactive</code> state applies to an endpoint that can't be used for a certain kind of cluster, such as a <code>writer</code> endpoint for a read-only secondary cluster in a global database.</p>
    pub status: Option<String>,
}

#[allow(dead_code)]
struct DBClusterEndpointDeserializer;
impl DBClusterEndpointDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DBClusterEndpoint, XmlParseError> {
        deserialize_elements::<_, DBClusterEndpoint, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "CustomEndpointType" => {
                    obj.custom_endpoint_type = Some(StringDeserializer::deserialize(
                        "CustomEndpointType",
                        stack,
                    )?);
                }
                "DBClusterEndpointArn" => {
                    obj.db_cluster_endpoint_arn = Some(StringDeserializer::deserialize(
                        "DBClusterEndpointArn",
                        stack,
                    )?);
                }
                "DBClusterEndpointIdentifier" => {
                    obj.db_cluster_endpoint_identifier = Some(StringDeserializer::deserialize(
                        "DBClusterEndpointIdentifier",
                        stack,
                    )?);
                }
                "DBClusterEndpointResourceIdentifier" => {
                    obj.db_cluster_endpoint_resource_identifier =
                        Some(StringDeserializer::deserialize(
                            "DBClusterEndpointResourceIdentifier",
                            stack,
                        )?);
                }
                "DBClusterIdentifier" => {
                    obj.db_cluster_identifier = Some(StringDeserializer::deserialize(
                        "DBClusterIdentifier",
                        stack,
                    )?);
                }
                "Endpoint" => {
                    obj.endpoint = Some(StringDeserializer::deserialize("Endpoint", stack)?);
                }
                "EndpointType" => {
                    obj.endpoint_type =
                        Some(StringDeserializer::deserialize("EndpointType", stack)?);
                }
                "ExcludedMembers" => {
                    obj.excluded_members.get_or_insert(vec![]).extend(
                        StringListDeserializer::deserialize("ExcludedMembers", stack)?,
                    );
                }
                "StaticMembers" => {
                    obj.static_members
                        .get_or_insert(vec![])
                        .extend(StringListDeserializer::deserialize("StaticMembers", stack)?);
                }
                "Status" => {
                    obj.status = Some(StringDeserializer::deserialize("Status", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct DBClusterEndpointListDeserializer;
impl DBClusterEndpointListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<DBClusterEndpoint>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "DBClusterEndpointList" {
                obj.push(DBClusterEndpointDeserializer::deserialize(
                    "DBClusterEndpointList",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DBClusterEndpointMessage {
    /// <p>Contains the details of the endpoints associated with the cluster and matching any filter conditions.</p>
    pub db_cluster_endpoints: Option<Vec<DBClusterEndpoint>>,
    /// <p> An optional pagination token provided by a previous <code>DescribeDBClusterEndpoints</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    pub marker: Option<String>,
}

#[allow(dead_code)]
struct DBClusterEndpointMessageDeserializer;
impl DBClusterEndpointMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DBClusterEndpointMessage, XmlParseError> {
        deserialize_elements::<_, DBClusterEndpointMessage, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DBClusterEndpoints" => {
                        obj.db_cluster_endpoints.get_or_insert(vec![]).extend(
                            DBClusterEndpointListDeserializer::deserialize(
                                "DBClusterEndpoints",
                                stack,
                            )?,
                        );
                    }
                    "Marker" => {
                        obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct DBClusterListDeserializer;
impl DBClusterListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<DBCluster>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "DBCluster" {
                obj.push(DBClusterDeserializer::deserialize("DBCluster", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Contains information about an instance that is part of a DB cluster.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DBClusterMember {
    /// <p>Specifies the status of the DB cluster parameter group for this member of the DB cluster.</p>
    pub db_cluster_parameter_group_status: Option<String>,
    /// <p>Specifies the instance identifier for this member of the DB cluster.</p>
    pub db_instance_identifier: Option<String>,
    /// <p>Value that is <code>true</code> if the cluster member is the primary instance for the DB cluster and <code>false</code> otherwise.</p>
    pub is_cluster_writer: Option<bool>,
    /// <p>A value that specifies the order in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance"> Fault Tolerance for an Aurora DB Cluster</a> in the <i>Amazon Aurora User Guide</i>. </p>
    pub promotion_tier: Option<i64>,
}

#[allow(dead_code)]
struct DBClusterMemberDeserializer;
impl DBClusterMemberDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DBClusterMember, XmlParseError> {
        deserialize_elements::<_, DBClusterMember, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "DBClusterParameterGroupStatus" => {
                    obj.db_cluster_parameter_group_status = Some(StringDeserializer::deserialize(
                        "DBClusterParameterGroupStatus",
                        stack,
                    )?);
                }
                "DBInstanceIdentifier" => {
                    obj.db_instance_identifier = Some(StringDeserializer::deserialize(
                        "DBInstanceIdentifier",
                        stack,
                    )?);
                }
                "IsClusterWriter" => {
                    obj.is_cluster_writer =
                        Some(BooleanDeserializer::deserialize("IsClusterWriter", stack)?);
                }
                "PromotionTier" => {
                    obj.promotion_tier = Some(IntegerOptionalDeserializer::deserialize(
                        "PromotionTier",
                        stack,
                    )?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct DBClusterMemberListDeserializer;
impl DBClusterMemberListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<DBClusterMember>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "DBClusterMember" {
                obj.push(DBClusterMemberDeserializer::deserialize(
                    "DBClusterMember",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Contains the result of a successful invocation of the <code>DescribeDBClusters</code> action.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DBClusterMessage {
    /// <p>Contains a list of DB clusters for the user.</p>
    pub db_clusters: Option<Vec<DBCluster>>,
    /// <p>A pagination token that can be used in a later DescribeDBClusters request.</p>
    pub marker: Option<String>,
}

#[allow(dead_code)]
struct DBClusterMessageDeserializer;
impl DBClusterMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DBClusterMessage, XmlParseError> {
        deserialize_elements::<_, DBClusterMessage, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "DBClusters" => {
                    obj.db_clusters
                        .get_or_insert(vec![])
                        .extend(DBClusterListDeserializer::deserialize("DBClusters", stack)?);
                }
                "Marker" => {
                    obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct DBClusterOptionGroupMembershipsDeserializer;
impl DBClusterOptionGroupMembershipsDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<DBClusterOptionGroupStatus>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "DBClusterOptionGroup" {
                obj.push(DBClusterOptionGroupStatusDeserializer::deserialize(
                    "DBClusterOptionGroup",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Contains status information for a DB cluster option group.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DBClusterOptionGroupStatus {
    /// <p>Specifies the name of the DB cluster option group.</p>
    pub db_cluster_option_group_name: Option<String>,
    /// <p>Specifies the status of the DB cluster option group.</p>
    pub status: Option<String>,
}

#[allow(dead_code)]
struct DBClusterOptionGroupStatusDeserializer;
impl DBClusterOptionGroupStatusDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DBClusterOptionGroupStatus, XmlParseError> {
        deserialize_elements::<_, DBClusterOptionGroupStatus, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DBClusterOptionGroupName" => {
                        obj.db_cluster_option_group_name = Some(StringDeserializer::deserialize(
                            "DBClusterOptionGroupName",
                            stack,
                        )?);
                    }
                    "Status" => {
                        obj.status = Some(StringDeserializer::deserialize("Status", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Contains the details of an Amazon RDS DB cluster parameter group. </p> <p>This data type is used as a response element in the <code>DescribeDBClusterParameterGroups</code> action. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DBClusterParameterGroup {
    /// <p>The Amazon Resource Name (ARN) for the DB cluster parameter group.</p>
    pub db_cluster_parameter_group_arn: Option<String>,
    /// <p>The name of the DB cluster parameter group.</p>
    pub db_cluster_parameter_group_name: Option<String>,
    /// <p>The name of the DB parameter group family that this DB cluster parameter group is compatible with.</p>
    pub db_parameter_group_family: Option<String>,
    /// <p>Provides the customer-specified description for this DB cluster parameter group.</p>
    pub description: Option<String>,
}

#[allow(dead_code)]
struct DBClusterParameterGroupDeserializer;
impl DBClusterParameterGroupDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DBClusterParameterGroup, XmlParseError> {
        deserialize_elements::<_, DBClusterParameterGroup, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DBClusterParameterGroupArn" => {
                        obj.db_cluster_parameter_group_arn = Some(StringDeserializer::deserialize(
                            "DBClusterParameterGroupArn",
                            stack,
                        )?);
                    }
                    "DBClusterParameterGroupName" => {
                        obj.db_cluster_parameter_group_name = Some(
                            StringDeserializer::deserialize("DBClusterParameterGroupName", stack)?,
                        );
                    }
                    "DBParameterGroupFamily" => {
                        obj.db_parameter_group_family = Some(StringDeserializer::deserialize(
                            "DBParameterGroupFamily",
                            stack,
                        )?);
                    }
                    "Description" => {
                        obj.description =
                            Some(StringDeserializer::deserialize("Description", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Provides details about a DB cluster parameter group including the parameters in the DB cluster parameter group.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DBClusterParameterGroupDetails {
    /// <p> An optional pagination token provided by a previous DescribeDBClusterParameters request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> . </p>
    pub marker: Option<String>,
    /// <p>Provides a list of parameters for the DB cluster parameter group.</p>
    pub parameters: Option<Vec<Parameter>>,
}

#[allow(dead_code)]
struct DBClusterParameterGroupDetailsDeserializer;
impl DBClusterParameterGroupDetailsDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DBClusterParameterGroupDetails, XmlParseError> {
        deserialize_elements::<_, DBClusterParameterGroupDetails, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Marker" => {
                        obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                    }
                    "Parameters" => {
                        obj.parameters.get_or_insert(vec![]).extend(
                            ParametersListDeserializer::deserialize("Parameters", stack)?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct DBClusterParameterGroupListDeserializer;
impl DBClusterParameterGroupListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<DBClusterParameterGroup>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "DBClusterParameterGroup" {
                obj.push(DBClusterParameterGroupDeserializer::deserialize(
                    "DBClusterParameterGroup",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DBClusterParameterGroupNameMessage {
    /// <p><p>The name of the DB cluster parameter group.</p> <p>Constraints:</p> <ul> <li> <p>Must be 1 to 255 letters or numbers.</p> </li> <li> <p>First character must be a letter</p> </li> <li> <p>Can&#39;t end with a hyphen or contain two consecutive hyphens</p> </li> </ul> <note> <p>This value is stored as a lowercase string.</p> </note></p>
    pub db_cluster_parameter_group_name: Option<String>,
}

#[allow(dead_code)]
struct DBClusterParameterGroupNameMessageDeserializer;
impl DBClusterParameterGroupNameMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DBClusterParameterGroupNameMessage, XmlParseError> {
        deserialize_elements::<_, DBClusterParameterGroupNameMessage, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DBClusterParameterGroupName" => {
                        obj.db_cluster_parameter_group_name = Some(
                            StringDeserializer::deserialize("DBClusterParameterGroupName", stack)?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DBClusterParameterGroupsMessage {
    /// <p>A list of DB cluster parameter groups.</p>
    pub db_cluster_parameter_groups: Option<Vec<DBClusterParameterGroup>>,
    /// <p> An optional pagination token provided by a previous <code>DescribeDBClusterParameterGroups</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    pub marker: Option<String>,
}

#[allow(dead_code)]
struct DBClusterParameterGroupsMessageDeserializer;
impl DBClusterParameterGroupsMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DBClusterParameterGroupsMessage, XmlParseError> {
        deserialize_elements::<_, DBClusterParameterGroupsMessage, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DBClusterParameterGroups" => {
                        obj.db_cluster_parameter_groups
                            .get_or_insert(vec![])
                            .extend(DBClusterParameterGroupListDeserializer::deserialize(
                                "DBClusterParameterGroups",
                                stack,
                            )?);
                    }
                    "Marker" => {
                        obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Describes an Amazon Web Services Identity and Access Management (IAM) role that is associated with a DB cluster.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DBClusterRole {
    /// <p>The name of the feature associated with the Amazon Web Services Identity and Access Management (IAM) role. For the list of supported feature names, see <a>DBEngineVersion</a>. </p>
    pub feature_name: Option<String>,
    /// <p>The Amazon Resource Name (ARN) of the IAM role that is associated with the DB cluster.</p>
    pub role_arn: Option<String>,
    /// <p><p>Describes the state of association between the IAM role and the DB cluster. The Status property returns one of the following values:</p> <ul> <li> <p> <code>ACTIVE</code> - the IAM role ARN is associated with the DB cluster and can be used to access other Amazon Web Services on your behalf.</p> </li> <li> <p> <code>PENDING</code> - the IAM role ARN is being associated with the DB cluster.</p> </li> <li> <p> <code>INVALID</code> - the IAM role ARN is associated with the DB cluster, but the DB cluster is unable to assume the IAM role in order to access other Amazon Web Services on your behalf.</p> </li> </ul></p>
    pub status: Option<String>,
}

#[allow(dead_code)]
struct DBClusterRoleDeserializer;
impl DBClusterRoleDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DBClusterRole, XmlParseError> {
        deserialize_elements::<_, DBClusterRole, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "FeatureName" => {
                    obj.feature_name = Some(StringDeserializer::deserialize("FeatureName", stack)?);
                }
                "RoleArn" => {
                    obj.role_arn = Some(StringDeserializer::deserialize("RoleArn", stack)?);
                }
                "Status" => {
                    obj.status = Some(StringDeserializer::deserialize("Status", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct DBClusterRolesDeserializer;
impl DBClusterRolesDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<DBClusterRole>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "DBClusterRole" {
                obj.push(DBClusterRoleDeserializer::deserialize(
                    "DBClusterRole",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Contains the details for an Amazon RDS DB cluster snapshot </p> <p>This data type is used as a response element in the <code>DescribeDBClusterSnapshots</code> action. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DBClusterSnapshot {
    /// <p>Specifies the allocated storage size in gibibytes (GiB).</p>
    pub allocated_storage: Option<i64>,
    /// <p>Provides the list of Availability Zones (AZs) where instances in the DB cluster snapshot can be restored.</p>
    pub availability_zones: Option<Vec<String>>,
    /// <p>Specifies the time when the DB cluster was created, in Universal Coordinated Time (UTC).</p>
    pub cluster_create_time: Option<String>,
    /// <p>Specifies the DB cluster identifier of the DB cluster that this DB cluster snapshot was created from.</p>
    pub db_cluster_identifier: Option<String>,
    /// <p>The Amazon Resource Name (ARN) for the DB cluster snapshot.</p>
    pub db_cluster_snapshot_arn: Option<String>,
    /// <p>Specifies the identifier for the DB cluster snapshot.</p>
    pub db_cluster_snapshot_identifier: Option<String>,
    /// <p>Specifies the name of the database engine for this DB cluster snapshot.</p>
    pub engine: Option<String>,
    /// <p>Provides the engine mode of the database engine for this DB cluster snapshot.</p>
    pub engine_mode: Option<String>,
    /// <p>Provides the version of the database engine for this DB cluster snapshot.</p>
    pub engine_version: Option<String>,
    /// <p>True if mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.</p>
    pub iam_database_authentication_enabled: Option<bool>,
    /// <p>If <code>StorageEncrypted</code> is true, the Amazon Web Services KMS key identifier for the encrypted DB cluster snapshot.</p> <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the Amazon Web Services KMS customer master key (CMK).</p>
    pub kms_key_id: Option<String>,
    /// <p>Provides the license model information for this DB cluster snapshot.</p>
    pub license_model: Option<String>,
    /// <p>Provides the master username for this DB cluster snapshot.</p>
    pub master_username: Option<String>,
    /// <p>Specifies the percentage of the estimated data that has been transferred.</p>
    pub percent_progress: Option<i64>,
    /// <p>Specifies the port that the DB cluster was listening on at the time of the snapshot.</p>
    pub port: Option<i64>,
    /// <p>Provides the time when the snapshot was taken, in Universal Coordinated Time (UTC).</p>
    pub snapshot_create_time: Option<String>,
    /// <p>Provides the type of the DB cluster snapshot.</p>
    pub snapshot_type: Option<String>,
    /// <p>If the DB cluster snapshot was copied from a source DB cluster snapshot, the Amazon Resource Name (ARN) for the source DB cluster snapshot, otherwise, a null value.</p>
    pub source_db_cluster_snapshot_arn: Option<String>,
    /// <p>Specifies the status of this DB cluster snapshot.</p>
    pub status: Option<String>,
    /// <p>Specifies whether the DB cluster snapshot is encrypted.</p>
    pub storage_encrypted: Option<bool>,
    pub tag_list: Option<Vec<Tag>>,
    /// <p>Provides the VPC ID associated with the DB cluster snapshot.</p>
    pub vpc_id: Option<String>,
}

#[allow(dead_code)]
struct DBClusterSnapshotDeserializer;
impl DBClusterSnapshotDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DBClusterSnapshot, XmlParseError> {
        deserialize_elements::<_, DBClusterSnapshot, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "AllocatedStorage" => {
                    obj.allocated_storage =
                        Some(IntegerDeserializer::deserialize("AllocatedStorage", stack)?);
                }
                "AvailabilityZones" => {
                    obj.availability_zones.get_or_insert(vec![]).extend(
                        AvailabilityZonesDeserializer::deserialize("AvailabilityZones", stack)?,
                    );
                }
                "ClusterCreateTime" => {
                    obj.cluster_create_time =
                        Some(TStampDeserializer::deserialize("ClusterCreateTime", stack)?);
                }
                "DBClusterIdentifier" => {
                    obj.db_cluster_identifier = Some(StringDeserializer::deserialize(
                        "DBClusterIdentifier",
                        stack,
                    )?);
                }
                "DBClusterSnapshotArn" => {
                    obj.db_cluster_snapshot_arn = Some(StringDeserializer::deserialize(
                        "DBClusterSnapshotArn",
                        stack,
                    )?);
                }
                "DBClusterSnapshotIdentifier" => {
                    obj.db_cluster_snapshot_identifier = Some(StringDeserializer::deserialize(
                        "DBClusterSnapshotIdentifier",
                        stack,
                    )?);
                }
                "Engine" => {
                    obj.engine = Some(StringDeserializer::deserialize("Engine", stack)?);
                }
                "EngineMode" => {
                    obj.engine_mode = Some(StringDeserializer::deserialize("EngineMode", stack)?);
                }
                "EngineVersion" => {
                    obj.engine_version =
                        Some(StringDeserializer::deserialize("EngineVersion", stack)?);
                }
                "IAMDatabaseAuthenticationEnabled" => {
                    obj.iam_database_authentication_enabled =
                        Some(BooleanDeserializer::deserialize(
                            "IAMDatabaseAuthenticationEnabled",
                            stack,
                        )?);
                }
                "KmsKeyId" => {
                    obj.kms_key_id = Some(StringDeserializer::deserialize("KmsKeyId", stack)?);
                }
                "LicenseModel" => {
                    obj.license_model =
                        Some(StringDeserializer::deserialize("LicenseModel", stack)?);
                }
                "MasterUsername" => {
                    obj.master_username =
                        Some(StringDeserializer::deserialize("MasterUsername", stack)?);
                }
                "PercentProgress" => {
                    obj.percent_progress =
                        Some(IntegerDeserializer::deserialize("PercentProgress", stack)?);
                }
                "Port" => {
                    obj.port = Some(IntegerDeserializer::deserialize("Port", stack)?);
                }
                "SnapshotCreateTime" => {
                    obj.snapshot_create_time = Some(TStampDeserializer::deserialize(
                        "SnapshotCreateTime",
                        stack,
                    )?);
                }
                "SnapshotType" => {
                    obj.snapshot_type =
                        Some(StringDeserializer::deserialize("SnapshotType", stack)?);
                }
                "SourceDBClusterSnapshotArn" => {
                    obj.source_db_cluster_snapshot_arn = Some(StringDeserializer::deserialize(
                        "SourceDBClusterSnapshotArn",
                        stack,
                    )?);
                }
                "Status" => {
                    obj.status = Some(StringDeserializer::deserialize("Status", stack)?);
                }
                "StorageEncrypted" => {
                    obj.storage_encrypted =
                        Some(BooleanDeserializer::deserialize("StorageEncrypted", stack)?);
                }
                "TagList" => {
                    obj.tag_list
                        .get_or_insert(vec![])
                        .extend(TagListDeserializer::deserialize("TagList", stack)?);
                }
                "VpcId" => {
                    obj.vpc_id = Some(StringDeserializer::deserialize("VpcId", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>Contains the name and values of a manual DB cluster snapshot attribute.</p> <p>Manual DB cluster snapshot attributes are used to authorize other Amazon Web Services accounts to restore a manual DB cluster snapshot. For more information, see the <code>ModifyDBClusterSnapshotAttribute</code> API action.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DBClusterSnapshotAttribute {
    /// <p>The name of the manual DB cluster snapshot attribute.</p> <p>The attribute named <code>restore</code> refers to the list of Amazon Web Services accounts that have permission to copy or restore the manual DB cluster snapshot. For more information, see the <code>ModifyDBClusterSnapshotAttribute</code> API action.</p>
    pub attribute_name: Option<String>,
    /// <p>The value(s) for the manual DB cluster snapshot attribute.</p> <p>If the <code>AttributeName</code> field is set to <code>restore</code>, then this element returns a list of IDs of the Amazon Web Services accounts that are authorized to copy or restore the manual DB cluster snapshot. If a value of <code>all</code> is in the list, then the manual DB cluster snapshot is public and available for any Amazon Web Services account to copy or restore.</p>
    pub attribute_values: Option<Vec<String>>,
}

#[allow(dead_code)]
struct DBClusterSnapshotAttributeDeserializer;
impl DBClusterSnapshotAttributeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DBClusterSnapshotAttribute, XmlParseError> {
        deserialize_elements::<_, DBClusterSnapshotAttribute, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "AttributeName" => {
                        obj.attribute_name =
                            Some(StringDeserializer::deserialize("AttributeName", stack)?);
                    }
                    "AttributeValues" => {
                        obj.attribute_values.get_or_insert(vec![]).extend(
                            AttributeValueListDeserializer::deserialize("AttributeValues", stack)?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct DBClusterSnapshotAttributeListDeserializer;
impl DBClusterSnapshotAttributeListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<DBClusterSnapshotAttribute>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "DBClusterSnapshotAttribute" {
                obj.push(DBClusterSnapshotAttributeDeserializer::deserialize(
                    "DBClusterSnapshotAttribute",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Contains the results of a successful call to the <code>DescribeDBClusterSnapshotAttributes</code> API action.</p> <p>Manual DB cluster snapshot attributes are used to authorize other Amazon Web Services accounts to copy or restore a manual DB cluster snapshot. For more information, see the <code>ModifyDBClusterSnapshotAttribute</code> API action.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DBClusterSnapshotAttributesResult {
    /// <p>The list of attributes and values for the manual DB cluster snapshot.</p>
    pub db_cluster_snapshot_attributes: Option<Vec<DBClusterSnapshotAttribute>>,
    /// <p>The identifier of the manual DB cluster snapshot that the attributes apply to.</p>
    pub db_cluster_snapshot_identifier: Option<String>,
}

#[allow(dead_code)]
struct DBClusterSnapshotAttributesResultDeserializer;
impl DBClusterSnapshotAttributesResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DBClusterSnapshotAttributesResult, XmlParseError> {
        deserialize_elements::<_, DBClusterSnapshotAttributesResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DBClusterSnapshotAttributes" => {
                        obj.db_cluster_snapshot_attributes
                            .get_or_insert(vec![])
                            .extend(DBClusterSnapshotAttributeListDeserializer::deserialize(
                                "DBClusterSnapshotAttributes",
                                stack,
                            )?);
                    }
                    "DBClusterSnapshotIdentifier" => {
                        obj.db_cluster_snapshot_identifier = Some(StringDeserializer::deserialize(
                            "DBClusterSnapshotIdentifier",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct DBClusterSnapshotListDeserializer;
impl DBClusterSnapshotListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<DBClusterSnapshot>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "DBClusterSnapshot" {
                obj.push(DBClusterSnapshotDeserializer::deserialize(
                    "DBClusterSnapshot",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p> Provides a list of DB cluster snapshots for the user as the result of a call to the <code>DescribeDBClusterSnapshots</code> action. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DBClusterSnapshotMessage {
    /// <p>Provides a list of DB cluster snapshots for the user.</p>
    pub db_cluster_snapshots: Option<Vec<DBClusterSnapshot>>,
    /// <p> An optional pagination token provided by a previous <code>DescribeDBClusterSnapshots</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    pub marker: Option<String>,
}

#[allow(dead_code)]
struct DBClusterSnapshotMessageDeserializer;
impl DBClusterSnapshotMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DBClusterSnapshotMessage, XmlParseError> {
        deserialize_elements::<_, DBClusterSnapshotMessage, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DBClusterSnapshots" => {
                        obj.db_cluster_snapshots.get_or_insert(vec![]).extend(
                            DBClusterSnapshotListDeserializer::deserialize(
                                "DBClusterSnapshots",
                                stack,
                            )?,
                        );
                    }
                    "Marker" => {
                        obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p> This data type is used as a response element in the action <code>DescribeDBEngineVersions</code>. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DBEngineVersion {
    /// <p>The description of the database engine.</p>
    pub db_engine_description: Option<String>,
    /// <p>The description of the database engine version.</p>
    pub db_engine_version_description: Option<String>,
    /// <p>The name of the DB parameter group family for the database engine.</p>
    pub db_parameter_group_family: Option<String>,
    /// <p> The default character set for new instances of this engine version, if the <code>CharacterSetName</code> parameter of the CreateDBInstance API isn't specified. </p>
    pub default_character_set: Option<CharacterSet>,
    /// <p>The name of the database engine.</p>
    pub engine: Option<String>,
    /// <p>The version number of the database engine.</p>
    pub engine_version: Option<String>,
    /// <p>The types of logs that the database engine has available for export to CloudWatch Logs.</p>
    pub exportable_log_types: Option<Vec<String>>,
    /// <p>The status of the DB engine version, either <code>available</code> or <code>deprecated</code>.</p>
    pub status: Option<String>,
    /// <p>A list of the character sets supported by this engine for the <code>CharacterSetName</code> parameter of the <code>CreateDBInstance</code> operation. </p>
    pub supported_character_sets: Option<Vec<CharacterSet>>,
    /// <p>A list of the supported DB engine modes.</p>
    pub supported_engine_modes: Option<Vec<String>>,
    /// <p><p> A list of features supported by the DB engine. Supported feature names include the following. </p> <ul> <li> <p>s3Import</p> </li> </ul></p>
    pub supported_feature_names: Option<Vec<String>>,
    /// <p>A list of the character sets supported by the Oracle DB engine for the <code>NcharCharacterSetName</code> parameter of the <code>CreateDBInstance</code> operation. </p>
    pub supported_nchar_character_sets: Option<Vec<CharacterSet>>,
    /// <p>A list of the time zones supported by this engine for the <code>Timezone</code> parameter of the <code>CreateDBInstance</code> action. </p>
    pub supported_timezones: Option<Vec<Timezone>>,
    /// <p>A value that indicates whether you can use Aurora global databases with a specific DB engine version.</p>
    pub supports_global_databases: Option<bool>,
    /// <p>A value that indicates whether the engine version supports exporting the log types specified by ExportableLogTypes to CloudWatch Logs.</p>
    pub supports_log_exports_to_cloudwatch_logs: Option<bool>,
    /// <p>A value that indicates whether you can use Aurora parallel query with a specific DB engine version.</p>
    pub supports_parallel_query: Option<bool>,
    /// <p>Indicates whether the database engine version supports read replicas.</p>
    pub supports_read_replica: Option<bool>,
    /// <p>A list of engine versions that this database engine version can be upgraded to.</p>
    pub valid_upgrade_target: Option<Vec<UpgradeTarget>>,
}

#[allow(dead_code)]
struct DBEngineVersionDeserializer;
impl DBEngineVersionDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DBEngineVersion, XmlParseError> {
        deserialize_elements::<_, DBEngineVersion, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "DBEngineDescription" => {
                    obj.db_engine_description = Some(StringDeserializer::deserialize(
                        "DBEngineDescription",
                        stack,
                    )?);
                }
                "DBEngineVersionDescription" => {
                    obj.db_engine_version_description = Some(StringDeserializer::deserialize(
                        "DBEngineVersionDescription",
                        stack,
                    )?);
                }
                "DBParameterGroupFamily" => {
                    obj.db_parameter_group_family = Some(StringDeserializer::deserialize(
                        "DBParameterGroupFamily",
                        stack,
                    )?);
                }
                "DefaultCharacterSet" => {
                    obj.default_character_set = Some(CharacterSetDeserializer::deserialize(
                        "DefaultCharacterSet",
                        stack,
                    )?);
                }
                "Engine" => {
                    obj.engine = Some(StringDeserializer::deserialize("Engine", stack)?);
                }
                "EngineVersion" => {
                    obj.engine_version =
                        Some(StringDeserializer::deserialize("EngineVersion", stack)?);
                }
                "ExportableLogTypes" => {
                    obj.exportable_log_types.get_or_insert(vec![]).extend(
                        LogTypeListDeserializer::deserialize("ExportableLogTypes", stack)?,
                    );
                }
                "Status" => {
                    obj.status = Some(StringDeserializer::deserialize("Status", stack)?);
                }
                "SupportedCharacterSets" => {
                    obj.supported_character_sets.get_or_insert(vec![]).extend(
                        SupportedCharacterSetsListDeserializer::deserialize(
                            "SupportedCharacterSets",
                            stack,
                        )?,
                    );
                }
                "SupportedEngineModes" => {
                    obj.supported_engine_modes.get_or_insert(vec![]).extend(
                        EngineModeListDeserializer::deserialize("SupportedEngineModes", stack)?,
                    );
                }
                "SupportedFeatureNames" => {
                    obj.supported_feature_names.get_or_insert(vec![]).extend(
                        FeatureNameListDeserializer::deserialize("SupportedFeatureNames", stack)?,
                    );
                }
                "SupportedNcharCharacterSets" => {
                    obj.supported_nchar_character_sets
                        .get_or_insert(vec![])
                        .extend(SupportedCharacterSetsListDeserializer::deserialize(
                            "SupportedNcharCharacterSets",
                            stack,
                        )?);
                }
                "SupportedTimezones" => {
                    obj.supported_timezones.get_or_insert(vec![]).extend(
                        SupportedTimezonesListDeserializer::deserialize(
                            "SupportedTimezones",
                            stack,
                        )?,
                    );
                }
                "SupportsGlobalDatabases" => {
                    obj.supports_global_databases = Some(BooleanDeserializer::deserialize(
                        "SupportsGlobalDatabases",
                        stack,
                    )?);
                }
                "SupportsLogExportsToCloudwatchLogs" => {
                    obj.supports_log_exports_to_cloudwatch_logs =
                        Some(BooleanDeserializer::deserialize(
                            "SupportsLogExportsToCloudwatchLogs",
                            stack,
                        )?);
                }
                "SupportsParallelQuery" => {
                    obj.supports_parallel_query = Some(BooleanDeserializer::deserialize(
                        "SupportsParallelQuery",
                        stack,
                    )?);
                }
                "SupportsReadReplica" => {
                    obj.supports_read_replica = Some(BooleanDeserializer::deserialize(
                        "SupportsReadReplica",
                        stack,
                    )?);
                }
                "ValidUpgradeTarget" => {
                    obj.valid_upgrade_target.get_or_insert(vec![]).extend(
                        ValidUpgradeTargetListDeserializer::deserialize(
                            "ValidUpgradeTarget",
                            stack,
                        )?,
                    );
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct DBEngineVersionListDeserializer;
impl DBEngineVersionListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<DBEngineVersion>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "DBEngineVersion" {
                obj.push(DBEngineVersionDeserializer::deserialize(
                    "DBEngineVersion",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p> Contains the result of a successful invocation of the <code>DescribeDBEngineVersions</code> action. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DBEngineVersionMessage {
    /// <p> A list of <code>DBEngineVersion</code> elements. </p>
    pub db_engine_versions: Option<Vec<DBEngineVersion>>,
    /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    pub marker: Option<String>,
}

#[allow(dead_code)]
struct DBEngineVersionMessageDeserializer;
impl DBEngineVersionMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DBEngineVersionMessage, XmlParseError> {
        deserialize_elements::<_, DBEngineVersionMessage, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "DBEngineVersions" => {
                    obj.db_engine_versions.get_or_insert(vec![]).extend(
                        DBEngineVersionListDeserializer::deserialize("DBEngineVersions", stack)?,
                    );
                }
                "Marker" => {
                    obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>Contains the details of an Amazon RDS DB instance. </p> <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DBInstance {
    /// <p>Indicates whether engine-native audit fields are included in the database activity stream.</p>
    pub activity_stream_engine_native_audit_fields_included: Option<bool>,
    /// <p>The name of the Amazon Kinesis data stream used for the database activity stream.</p>
    pub activity_stream_kinesis_stream_name: Option<String>,
    /// <p>The Amazon Web Services KMS key identifier used for encrypting messages in the database activity stream. The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the Amazon Web Services KMS customer master key (CMK).</p>
    pub activity_stream_kms_key_id: Option<String>,
    /// <p>The mode of the database activity stream. Database events such as a change or access generate an activity stream event. RDS for Oracle always handles these events asynchronously.</p>
    pub activity_stream_mode: Option<String>,
    /// <p>The status of the database activity stream.</p>
    pub activity_stream_status: Option<String>,
    /// <p>Specifies the allocated storage size specified in gibibytes.</p>
    pub allocated_storage: Option<i64>,
    /// <p> The Amazon Web Services Identity and Access Management (IAM) roles associated with the DB instance. </p>
    pub associated_roles: Option<Vec<DBInstanceRole>>,
    /// <p>A value that indicates that minor version patches are applied automatically.</p>
    pub auto_minor_version_upgrade: Option<bool>,
    /// <p>Specifies the name of the Availability Zone the DB instance is located in.</p>
    pub availability_zone: Option<String>,
    /// <p>The Amazon Resource Name (ARN) of the recovery point in Amazon Web Services Backup.</p>
    pub aws_backup_recovery_point_arn: Option<String>,
    /// <p>Specifies the number of days for which automatic DB snapshots are retained.</p>
    pub backup_retention_period: Option<i64>,
    /// <p>The identifier of the CA certificate for this DB instance.</p>
    pub ca_certificate_identifier: Option<String>,
    /// <p>If present, specifies the name of the character set that this instance is associated with.</p>
    pub character_set_name: Option<String>,
    /// <p>Specifies whether tags are copied from the DB instance to snapshots of the DB instance.</p> <p> <b>Amazon Aurora</b> </p> <p>Not applicable. Copying tags to snapshots is managed by the DB cluster. Setting this value for an Aurora DB instance has no effect on the DB cluster setting. For more information, see <code>DBCluster</code>.</p>
    pub copy_tags_to_snapshot: Option<bool>,
    /// <p>Specifies whether a customer-owned IP address (CoIP) is enabled for an RDS on Outposts DB instance.</p> <p>A <i>CoIP </i>provides local or external connectivity to resources in your Outpost subnets through your on-premises network. For some use cases, a CoIP can provide lower latency for connections to the DB instance from outside of its virtual private cloud (VPC) on your local network.</p> <p>For more information about RDS on Outposts, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon RDS on Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide</i>.</p> <p>For more information about CoIPs, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#ip-addressing">Customer-owned IP addresses</a> in the <i>Amazon Web Services Outposts User Guide</i>.</p>
    pub customer_owned_ip_enabled: Option<bool>,
    /// <p>If the DB instance is a member of a DB cluster, contains the name of the DB cluster that the DB instance is a member of.</p>
    pub db_cluster_identifier: Option<String>,
    /// <p>The Amazon Resource Name (ARN) for the DB instance.</p>
    pub db_instance_arn: Option<String>,
    /// <p>The list of replicated automated backups associated with the DB instance.</p>
    pub db_instance_automated_backups_replications:
        Option<Vec<DBInstanceAutomatedBackupsReplication>>,
    /// <p>Contains the name of the compute and memory capacity class of the DB instance.</p>
    pub db_instance_class: Option<String>,
    /// <p>Contains a user-supplied database identifier. This identifier is the unique key that identifies a DB instance.</p>
    pub db_instance_identifier: Option<String>,
    /// <p>Specifies the current state of this database.</p> <p>For information about DB instance statuses, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/accessing-monitoring.html#Overview.DBInstance.Status">Viewing DB instance status</a> in the <i>Amazon RDS User Guide.</i> </p>
    pub db_instance_status: Option<String>,
    /// <p>The meaning of this parameter differs according to the database engine you use.</p> <p> <b>MySQL, MariaDB, SQL Server, PostgreSQL</b> </p> <p>Contains the name of the initial database of this instance that was provided at create time, if one was specified when the DB instance was created. This same name is returned for the life of the DB instance.</p> <p>Type: String</p> <p> <b>Oracle</b> </p> <p>Contains the Oracle System ID (SID) of the created DB instance. Not shown when the returned parameters do not apply to an Oracle DB instance.</p>
    pub db_name: Option<String>,
    /// <p>Provides the list of DB parameter groups applied to this DB instance.</p>
    pub db_parameter_groups: Option<Vec<DBParameterGroupStatus>>,
    /// <p> A list of DB security group elements containing <code>DBSecurityGroup.Name</code> and <code>DBSecurityGroup.Status</code> subelements. </p>
    pub db_security_groups: Option<Vec<DBSecurityGroupMembership>>,
    /// <p>Specifies information on the subnet group associated with the DB instance, including the name, description, and subnets in the subnet group.</p>
    pub db_subnet_group: Option<DBSubnetGroup>,
    /// <p>Specifies the port that the DB instance listens on. If the DB instance is part of a DB cluster, this can be a different port than the DB cluster port.</p>
    pub db_instance_port: Option<i64>,
    /// <p>The Amazon Web Services Region-unique, immutable identifier for the DB instance. This identifier is found in Amazon Web Services CloudTrail log entries whenever the Amazon Web Services KMS customer master key (CMK) for the DB instance is accessed.</p>
    pub dbi_resource_id: Option<String>,
    /// <p>Indicates if the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html"> Deleting a DB Instance</a>. </p>
    pub deletion_protection: Option<bool>,
    /// <p>The Active Directory Domain membership records associated with the DB instance.</p>
    pub domain_memberships: Option<Vec<DomainMembership>>,
    /// <p>A list of log types that this DB instance is configured to export to CloudWatch Logs.</p> <p>Log types vary by DB engine. For information about the log types for each DB engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html">Amazon RDS Database Log Files</a> in the <i>Amazon RDS User Guide.</i> </p>
    pub enabled_cloudwatch_logs_exports: Option<Vec<String>>,
    /// <p>Specifies the connection endpoint.</p>
    pub endpoint: Option<Endpoint>,
    /// <p>The name of the database engine to be used for this DB instance.</p>
    pub engine: Option<String>,
    /// <p>Indicates the database engine version.</p>
    pub engine_version: Option<String>,
    /// <p>The Amazon Resource Name (ARN) of the Amazon CloudWatch Logs log stream that receives the Enhanced Monitoring metrics data for the DB instance.</p>
    pub enhanced_monitoring_resource_arn: Option<String>,
    /// <p><p>True if mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.</p> <p>IAM database authentication can be enabled for the following database engines</p> <ul> <li> <p>For MySQL 5.6, minor version 5.6.34 or higher</p> </li> <li> <p>For MySQL 5.7, minor version 5.7.16 or higher</p> </li> <li> <p>Aurora 5.6 or higher. To enable IAM database authentication for Aurora, see DBCluster Type.</p> </li> </ul></p>
    pub iam_database_authentication_enabled: Option<bool>,
    /// <p>Provides the date and time the DB instance was created.</p>
    pub instance_create_time: Option<String>,
    /// <p>Specifies the Provisioned IOPS (I/O operations per second) value.</p>
    pub iops: Option<i64>,
    /// <p> If <code>StorageEncrypted</code> is true, the Amazon Web Services KMS key identifier for the encrypted DB instance. </p> <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the Amazon Web Services KMS customer master key (CMK).</p>
    pub kms_key_id: Option<String>,
    /// <p>Specifies the latest time to which a database can be restored with point-in-time restore.</p>
    pub latest_restorable_time: Option<String>,
    /// <p>License model information for this DB instance.</p>
    pub license_model: Option<String>,
    /// <p>Specifies the listener connection endpoint for SQL Server Always On.</p>
    pub listener_endpoint: Option<Endpoint>,
    /// <p>Contains the master username for the DB instance.</p>
    pub master_username: Option<String>,
    /// <p>The upper limit to which Amazon RDS can automatically scale the storage of the DB instance.</p>
    pub max_allocated_storage: Option<i64>,
    /// <p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance.</p>
    pub monitoring_interval: Option<i64>,
    /// <p>The ARN for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs.</p>
    pub monitoring_role_arn: Option<String>,
    /// <p>Specifies if the DB instance is a Multi-AZ deployment.</p>
    pub multi_az: Option<bool>,
    /// <p>The name of the NCHAR character set for the Oracle DB instance. This character set specifies the Unicode encoding for data stored in table columns of type NCHAR, NCLOB, or NVARCHAR2. </p>
    pub nchar_character_set_name: Option<String>,
    /// <p>Provides the list of option group memberships for this DB instance.</p>
    pub option_group_memberships: Option<Vec<OptionGroupMembership>>,
    /// <p>A value that specifies that changes to the DB instance are pending. This element is only included when changes are pending. Specific changes are identified by subelements.</p>
    pub pending_modified_values: Option<PendingModifiedValues>,
    /// <p>True if Performance Insights is enabled for the DB instance, and otherwise false.</p>
    pub performance_insights_enabled: Option<bool>,
    /// <p>The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p> <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the Amazon Web Services KMS customer master key (CMK).</p>
    pub performance_insights_kms_key_id: Option<String>,
    /// <p>The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years). </p>
    pub performance_insights_retention_period: Option<i64>,
    /// <p> Specifies the daily time range during which automated backups are created if automated backups are enabled, as determined by the <code>BackupRetentionPeriod</code>. </p>
    pub preferred_backup_window: Option<String>,
    /// <p>Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p>
    pub preferred_maintenance_window: Option<String>,
    /// <p>The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.</p>
    pub processor_features: Option<Vec<ProcessorFeature>>,
    /// <p>A value that specifies the order in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance"> Fault Tolerance for an Aurora DB Cluster</a> in the <i>Amazon Aurora User Guide</i>. </p>
    pub promotion_tier: Option<i64>,
    /// <p>Specifies the accessibility options for the DB instance.</p> <p>When the DB instance is publicly accessible, its DNS endpoint resolves to the private IP address from within the DB instance's VPC, and to the public IP address from outside of the DB instance's VPC. Access to the DB instance is ultimately controlled by the security group it uses, and that public access is not permitted if the security group assigned to the DB instance doesn't permit it.</p> <p>When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address.</p> <p>For more information, see <a>CreateDBInstance</a>.</p>
    pub publicly_accessible: Option<bool>,
    /// <p><p>Contains one or more identifiers of Aurora DB clusters to which the RDS DB instance is replicated as a read replica. For example, when you create an Aurora read replica of an RDS MySQL DB instance, the Aurora MySQL DB cluster for the Aurora read replica is shown. This output does not contain information about cross region Aurora read replicas.</p> <note> <p>Currently, each RDS DB instance can have only one Aurora read replica.</p> </note></p>
    pub read_replica_db_cluster_identifiers: Option<Vec<String>>,
    /// <p>Contains one or more identifiers of the read replicas associated with this DB instance.</p>
    pub read_replica_db_instance_identifiers: Option<Vec<String>>,
    /// <p>Contains the identifier of the source DB instance if this DB instance is a read replica.</p>
    pub read_replica_source_db_instance_identifier: Option<String>,
    /// <p><p>The open mode of an Oracle read replica. The default is <code>open-read-only</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html">Working with Oracle Read Replicas for Amazon RDS</a> in the <i>Amazon RDS User Guide</i>.</p> <note> <p>This attribute is only supported in RDS for Oracle.</p> </note></p>
    pub replica_mode: Option<String>,
    /// <p>If present, specifies the name of the secondary Availability Zone for a DB instance with multi-AZ support.</p>
    pub secondary_availability_zone: Option<String>,
    /// <p>The status of a read replica. If the instance isn't a read replica, this is blank.</p>
    pub status_infos: Option<Vec<DBInstanceStatusInfo>>,
    /// <p>Specifies whether the DB instance is encrypted.</p>
    pub storage_encrypted: Option<bool>,
    /// <p>Specifies the storage type associated with DB instance.</p>
    pub storage_type: Option<String>,
    pub tag_list: Option<Vec<Tag>>,
    /// <p>The ARN from the key store with which the instance is associated for TDE encryption.</p>
    pub tde_credential_arn: Option<String>,
    /// <p>The time zone of the DB instance. In most cases, the <code>Timezone</code> element is empty. <code>Timezone</code> content appears only for Microsoft SQL Server DB instances that were created with a time zone specified. </p>
    pub timezone: Option<String>,
    /// <p>Provides a list of VPC security group elements that the DB instance belongs to.</p>
    pub vpc_security_groups: Option<Vec<VpcSecurityGroupMembership>>,
}

#[allow(dead_code)]
struct DBInstanceDeserializer;
impl DBInstanceDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DBInstance, XmlParseError> {
        deserialize_elements::<_, DBInstance, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "ActivityStreamEngineNativeAuditFieldsIncluded" => {
                    obj.activity_stream_engine_native_audit_fields_included =
                        Some(BooleanOptionalDeserializer::deserialize(
                            "ActivityStreamEngineNativeAuditFieldsIncluded",
                            stack,
                        )?);
                }
                "ActivityStreamKinesisStreamName" => {
                    obj.activity_stream_kinesis_stream_name = Some(
                        StringDeserializer::deserialize("ActivityStreamKinesisStreamName", stack)?,
                    );
                }
                "ActivityStreamKmsKeyId" => {
                    obj.activity_stream_kms_key_id = Some(StringDeserializer::deserialize(
                        "ActivityStreamKmsKeyId",
                        stack,
                    )?);
                }
                "ActivityStreamMode" => {
                    obj.activity_stream_mode = Some(ActivityStreamModeDeserializer::deserialize(
                        "ActivityStreamMode",
                        stack,
                    )?);
                }
                "ActivityStreamStatus" => {
                    obj.activity_stream_status =
                        Some(ActivityStreamStatusDeserializer::deserialize(
                            "ActivityStreamStatus",
                            stack,
                        )?);
                }
                "AllocatedStorage" => {
                    obj.allocated_storage =
                        Some(IntegerDeserializer::deserialize("AllocatedStorage", stack)?);
                }
                "AssociatedRoles" => {
                    obj.associated_roles.get_or_insert(vec![]).extend(
                        DBInstanceRolesDeserializer::deserialize("AssociatedRoles", stack)?,
                    );
                }
                "AutoMinorVersionUpgrade" => {
                    obj.auto_minor_version_upgrade = Some(BooleanDeserializer::deserialize(
                        "AutoMinorVersionUpgrade",
                        stack,
                    )?);
                }
                "AvailabilityZone" => {
                    obj.availability_zone =
                        Some(StringDeserializer::deserialize("AvailabilityZone", stack)?);
                }
                "AwsBackupRecoveryPointArn" => {
                    obj.aws_backup_recovery_point_arn = Some(StringDeserializer::deserialize(
                        "AwsBackupRecoveryPointArn",
                        stack,
                    )?);
                }
                "BackupRetentionPeriod" => {
                    obj.backup_retention_period = Some(IntegerDeserializer::deserialize(
                        "BackupRetentionPeriod",
                        stack,
                    )?);
                }
                "CACertificateIdentifier" => {
                    obj.ca_certificate_identifier = Some(StringDeserializer::deserialize(
                        "CACertificateIdentifier",
                        stack,
                    )?);
                }
                "CharacterSetName" => {
                    obj.character_set_name =
                        Some(StringDeserializer::deserialize("CharacterSetName", stack)?);
                }
                "CopyTagsToSnapshot" => {
                    obj.copy_tags_to_snapshot = Some(BooleanDeserializer::deserialize(
                        "CopyTagsToSnapshot",
                        stack,
                    )?);
                }
                "CustomerOwnedIpEnabled" => {
                    obj.customer_owned_ip_enabled = Some(BooleanOptionalDeserializer::deserialize(
                        "CustomerOwnedIpEnabled",
                        stack,
                    )?);
                }
                "DBClusterIdentifier" => {
                    obj.db_cluster_identifier = Some(StringDeserializer::deserialize(
                        "DBClusterIdentifier",
                        stack,
                    )?);
                }
                "DBInstanceArn" => {
                    obj.db_instance_arn =
                        Some(StringDeserializer::deserialize("DBInstanceArn", stack)?);
                }
                "DBInstanceAutomatedBackupsReplications" => {
                    obj.db_instance_automated_backups_replications
                        .get_or_insert(vec![])
                        .extend(
                            DBInstanceAutomatedBackupsReplicationListDeserializer::deserialize(
                                "DBInstanceAutomatedBackupsReplications",
                                stack,
                            )?,
                        );
                }
                "DBInstanceClass" => {
                    obj.db_instance_class =
                        Some(StringDeserializer::deserialize("DBInstanceClass", stack)?);
                }
                "DBInstanceIdentifier" => {
                    obj.db_instance_identifier = Some(StringDeserializer::deserialize(
                        "DBInstanceIdentifier",
                        stack,
                    )?);
                }
                "DBInstanceStatus" => {
                    obj.db_instance_status =
                        Some(StringDeserializer::deserialize("DBInstanceStatus", stack)?);
                }
                "DBName" => {
                    obj.db_name = Some(StringDeserializer::deserialize("DBName", stack)?);
                }
                "DBParameterGroups" => {
                    obj.db_parameter_groups.get_or_insert(vec![]).extend(
                        DBParameterGroupStatusListDeserializer::deserialize(
                            "DBParameterGroups",
                            stack,
                        )?,
                    );
                }
                "DBSecurityGroups" => {
                    obj.db_security_groups.get_or_insert(vec![]).extend(
                        DBSecurityGroupMembershipListDeserializer::deserialize(
                            "DBSecurityGroups",
                            stack,
                        )?,
                    );
                }
                "DBSubnetGroup" => {
                    obj.db_subnet_group = Some(DBSubnetGroupDeserializer::deserialize(
                        "DBSubnetGroup",
                        stack,
                    )?);
                }
                "DbInstancePort" => {
                    obj.db_instance_port =
                        Some(IntegerDeserializer::deserialize("DbInstancePort", stack)?);
                }
                "DbiResourceId" => {
                    obj.dbi_resource_id =
                        Some(StringDeserializer::deserialize("DbiResourceId", stack)?);
                }
                "DeletionProtection" => {
                    obj.deletion_protection = Some(BooleanDeserializer::deserialize(
                        "DeletionProtection",
                        stack,
                    )?);
                }
                "DomainMemberships" => {
                    obj.domain_memberships.get_or_insert(vec![]).extend(
                        DomainMembershipListDeserializer::deserialize("DomainMemberships", stack)?,
                    );
                }
                "EnabledCloudwatchLogsExports" => {
                    obj.enabled_cloudwatch_logs_exports
                        .get_or_insert(vec![])
                        .extend(LogTypeListDeserializer::deserialize(
                            "EnabledCloudwatchLogsExports",
                            stack,
                        )?);
                }
                "Endpoint" => {
                    obj.endpoint = Some(EndpointDeserializer::deserialize("Endpoint", stack)?);
                }
                "Engine" => {
                    obj.engine = Some(StringDeserializer::deserialize("Engine", stack)?);
                }
                "EngineVersion" => {
                    obj.engine_version =
                        Some(StringDeserializer::deserialize("EngineVersion", stack)?);
                }
                "EnhancedMonitoringResourceArn" => {
                    obj.enhanced_monitoring_resource_arn = Some(StringDeserializer::deserialize(
                        "EnhancedMonitoringResourceArn",
                        stack,
                    )?);
                }
                "IAMDatabaseAuthenticationEnabled" => {
                    obj.iam_database_authentication_enabled =
                        Some(BooleanDeserializer::deserialize(
                            "IAMDatabaseAuthenticationEnabled",
                            stack,
                        )?);
                }
                "InstanceCreateTime" => {
                    obj.instance_create_time = Some(TStampDeserializer::deserialize(
                        "InstanceCreateTime",
                        stack,
                    )?);
                }
                "Iops" => {
                    obj.iops = Some(IntegerOptionalDeserializer::deserialize("Iops", stack)?);
                }
                "KmsKeyId" => {
                    obj.kms_key_id = Some(StringDeserializer::deserialize("KmsKeyId", stack)?);
                }
                "LatestRestorableTime" => {
                    obj.latest_restorable_time = Some(TStampDeserializer::deserialize(
                        "LatestRestorableTime",
                        stack,
                    )?);
                }
                "LicenseModel" => {
                    obj.license_model =
                        Some(StringDeserializer::deserialize("LicenseModel", stack)?);
                }
                "ListenerEndpoint" => {
                    obj.listener_endpoint = Some(EndpointDeserializer::deserialize(
                        "ListenerEndpoint",
                        stack,
                    )?);
                }
                "MasterUsername" => {
                    obj.master_username =
                        Some(StringDeserializer::deserialize("MasterUsername", stack)?);
                }
                "MaxAllocatedStorage" => {
                    obj.max_allocated_storage = Some(IntegerOptionalDeserializer::deserialize(
                        "MaxAllocatedStorage",
                        stack,
                    )?);
                }
                "MonitoringInterval" => {
                    obj.monitoring_interval = Some(IntegerOptionalDeserializer::deserialize(
                        "MonitoringInterval",
                        stack,
                    )?);
                }
                "MonitoringRoleArn" => {
                    obj.monitoring_role_arn =
                        Some(StringDeserializer::deserialize("MonitoringRoleArn", stack)?);
                }
                "MultiAZ" => {
                    obj.multi_az = Some(BooleanDeserializer::deserialize("MultiAZ", stack)?);
                }
                "NcharCharacterSetName" => {
                    obj.nchar_character_set_name = Some(StringDeserializer::deserialize(
                        "NcharCharacterSetName",
                        stack,
                    )?);
                }
                "OptionGroupMemberships" => {
                    obj.option_group_memberships.get_or_insert(vec![]).extend(
                        OptionGroupMembershipListDeserializer::deserialize(
                            "OptionGroupMemberships",
                            stack,
                        )?,
                    );
                }
                "PendingModifiedValues" => {
                    obj.pending_modified_values =
                        Some(PendingModifiedValuesDeserializer::deserialize(
                            "PendingModifiedValues",
                            stack,
                        )?);
                }
                "PerformanceInsightsEnabled" => {
                    obj.performance_insights_enabled =
                        Some(BooleanOptionalDeserializer::deserialize(
                            "PerformanceInsightsEnabled",
                            stack,
                        )?);
                }
                "PerformanceInsightsKMSKeyId" => {
                    obj.performance_insights_kms_key_id = Some(StringDeserializer::deserialize(
                        "PerformanceInsightsKMSKeyId",
                        stack,
                    )?);
                }
                "PerformanceInsightsRetentionPeriod" => {
                    obj.performance_insights_retention_period =
                        Some(IntegerOptionalDeserializer::deserialize(
                            "PerformanceInsightsRetentionPeriod",
                            stack,
                        )?);
                }
                "PreferredBackupWindow" => {
                    obj.preferred_backup_window = Some(StringDeserializer::deserialize(
                        "PreferredBackupWindow",
                        stack,
                    )?);
                }
                "PreferredMaintenanceWindow" => {
                    obj.preferred_maintenance_window = Some(StringDeserializer::deserialize(
                        "PreferredMaintenanceWindow",
                        stack,
                    )?);
                }
                "ProcessorFeatures" => {
                    obj.processor_features.get_or_insert(vec![]).extend(
                        ProcessorFeatureListDeserializer::deserialize("ProcessorFeatures", stack)?,
                    );
                }
                "PromotionTier" => {
                    obj.promotion_tier = Some(IntegerOptionalDeserializer::deserialize(
                        "PromotionTier",
                        stack,
                    )?);
                }
                "PubliclyAccessible" => {
                    obj.publicly_accessible = Some(BooleanDeserializer::deserialize(
                        "PubliclyAccessible",
                        stack,
                    )?);
                }
                "ReadReplicaDBClusterIdentifiers" => {
                    obj.read_replica_db_cluster_identifiers
                        .get_or_insert(vec![])
                        .extend(ReadReplicaDBClusterIdentifierListDeserializer::deserialize(
                            "ReadReplicaDBClusterIdentifiers",
                            stack,
                        )?);
                }
                "ReadReplicaDBInstanceIdentifiers" => {
                    obj.read_replica_db_instance_identifiers
                        .get_or_insert(vec![])
                        .extend(
                            ReadReplicaDBInstanceIdentifierListDeserializer::deserialize(
                                "ReadReplicaDBInstanceIdentifiers",
                                stack,
                            )?,
                        );
                }
                "ReadReplicaSourceDBInstanceIdentifier" => {
                    obj.read_replica_source_db_instance_identifier =
                        Some(StringDeserializer::deserialize(
                            "ReadReplicaSourceDBInstanceIdentifier",
                            stack,
                        )?);
                }
                "ReplicaMode" => {
                    obj.replica_mode =
                        Some(ReplicaModeDeserializer::deserialize("ReplicaMode", stack)?);
                }
                "SecondaryAvailabilityZone" => {
                    obj.secondary_availability_zone = Some(StringDeserializer::deserialize(
                        "SecondaryAvailabilityZone",
                        stack,
                    )?);
                }
                "StatusInfos" => {
                    obj.status_infos.get_or_insert(vec![]).extend(
                        DBInstanceStatusInfoListDeserializer::deserialize("StatusInfos", stack)?,
                    );
                }
                "StorageEncrypted" => {
                    obj.storage_encrypted =
                        Some(BooleanDeserializer::deserialize("StorageEncrypted", stack)?);
                }
                "StorageType" => {
                    obj.storage_type = Some(StringDeserializer::deserialize("StorageType", stack)?);
                }
                "TagList" => {
                    obj.tag_list
                        .get_or_insert(vec![])
                        .extend(TagListDeserializer::deserialize("TagList", stack)?);
                }
                "TdeCredentialArn" => {
                    obj.tde_credential_arn =
                        Some(StringDeserializer::deserialize("TdeCredentialArn", stack)?);
                }
                "Timezone" => {
                    obj.timezone = Some(StringDeserializer::deserialize("Timezone", stack)?);
                }
                "VpcSecurityGroups" => {
                    obj.vpc_security_groups.get_or_insert(vec![]).extend(
                        VpcSecurityGroupMembershipListDeserializer::deserialize(
                            "VpcSecurityGroups",
                            stack,
                        )?,
                    );
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>An automated backup of a DB instance. It consists of system backups, transaction logs, and the database instance properties that existed at the time you deleted the source instance.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DBInstanceAutomatedBackup {
    /// <p>Specifies the allocated storage size in gibibytes (GiB).</p>
    pub allocated_storage: Option<i64>,
    /// <p>The Availability Zone that the automated backup was created in. For information on Amazon Web Services Regions and Availability Zones, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html">Regions and Availability Zones</a>.</p>
    pub availability_zone: Option<String>,
    /// <p>The retention period for the automated backups.</p>
    pub backup_retention_period: Option<i64>,
    /// <p>The Amazon Resource Name (ARN) for the automated backups.</p>
    pub db_instance_arn: Option<String>,
    /// <p>The Amazon Resource Name (ARN) for the replicated automated backups.</p>
    pub db_instance_automated_backups_arn: Option<String>,
    /// <p>The list of replications to different Amazon Web Services Regions associated with the automated backup.</p>
    pub db_instance_automated_backups_replications:
        Option<Vec<DBInstanceAutomatedBackupsReplication>>,
    /// <p>The customer id of the instance that is/was associated with the automated backup. </p>
    pub db_instance_identifier: Option<String>,
    /// <p>The identifier for the source DB instance, which can't be changed and which is unique to an Amazon Web Services Region.</p>
    pub dbi_resource_id: Option<String>,
    /// <p>Specifies whether the automated backup is encrypted.</p>
    pub encrypted: Option<bool>,
    /// <p>The name of the database engine for this automated backup.</p>
    pub engine: Option<String>,
    /// <p>The version of the database engine for the automated backup.</p>
    pub engine_version: Option<String>,
    /// <p>True if mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.</p>
    pub iam_database_authentication_enabled: Option<bool>,
    /// <p>Provides the date and time that the DB instance was created. </p>
    pub instance_create_time: Option<String>,
    /// <p>The IOPS (I/O operations per second) value for the automated backup. </p>
    pub iops: Option<i64>,
    /// <p>The Amazon Web Services KMS key ID for an automated backup.</p> <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the Amazon Web Services KMS customer master key (CMK).</p>
    pub kms_key_id: Option<String>,
    /// <p>License model information for the automated backup.</p>
    pub license_model: Option<String>,
    /// <p>The license model of an automated backup.</p>
    pub master_username: Option<String>,
    /// <p>The option group the automated backup is associated with. If omitted, the default option group for the engine specified is used.</p>
    pub option_group_name: Option<String>,
    /// <p>The port number that the automated backup used for connections.</p> <p>Default: Inherits from the source DB instance</p> <p>Valid Values: <code>1150-65535</code> </p>
    pub port: Option<i64>,
    /// <p>The Amazon Web Services Region associated with the automated backup.</p>
    pub region: Option<String>,
    /// <p>Earliest and latest time an instance can be restored to.</p>
    pub restore_window: Option<RestoreWindow>,
    /// <p><p>Provides a list of status information for an automated backup:</p> <ul> <li> <p> <code>active</code> - automated backups for current instances</p> </li> <li> <p> <code>retained</code> - automated backups for deleted instances</p> </li> <li> <p> <code>creating</code> - automated backups that are waiting for the first automated snapshot to be available.</p> </li> </ul></p>
    pub status: Option<String>,
    /// <p>Specifies the storage type associated with the automated backup.</p>
    pub storage_type: Option<String>,
    /// <p>The ARN from the key store with which the automated backup is associated for TDE encryption.</p>
    pub tde_credential_arn: Option<String>,
    /// <p>The time zone of the automated backup. In most cases, the <code>Timezone</code> element is empty. <code>Timezone</code> content appears only for Microsoft SQL Server DB instances that were created with a time zone specified.</p>
    pub timezone: Option<String>,
    /// <p>Provides the VPC ID associated with the DB instance</p>
    pub vpc_id: Option<String>,
}

#[allow(dead_code)]
struct DBInstanceAutomatedBackupDeserializer;
impl DBInstanceAutomatedBackupDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DBInstanceAutomatedBackup, XmlParseError> {
        deserialize_elements::<_, DBInstanceAutomatedBackup, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "AllocatedStorage" => {
                        obj.allocated_storage =
                            Some(IntegerDeserializer::deserialize("AllocatedStorage", stack)?);
                    }
                    "AvailabilityZone" => {
                        obj.availability_zone =
                            Some(StringDeserializer::deserialize("AvailabilityZone", stack)?);
                    }
                    "BackupRetentionPeriod" => {
                        obj.backup_retention_period =
                            Some(IntegerOptionalDeserializer::deserialize(
                                "BackupRetentionPeriod",
                                stack,
                            )?);
                    }
                    "DBInstanceArn" => {
                        obj.db_instance_arn =
                            Some(StringDeserializer::deserialize("DBInstanceArn", stack)?);
                    }
                    "DBInstanceAutomatedBackupsArn" => {
                        obj.db_instance_automated_backups_arn =
                            Some(StringDeserializer::deserialize(
                                "DBInstanceAutomatedBackupsArn",
                                stack,
                            )?);
                    }
                    "DBInstanceAutomatedBackupsReplications" => {
                        obj.db_instance_automated_backups_replications
                            .get_or_insert(vec![])
                            .extend(
                                DBInstanceAutomatedBackupsReplicationListDeserializer::deserialize(
                                    "DBInstanceAutomatedBackupsReplications",
                                    stack,
                                )?,
                            );
                    }
                    "DBInstanceIdentifier" => {
                        obj.db_instance_identifier = Some(StringDeserializer::deserialize(
                            "DBInstanceIdentifier",
                            stack,
                        )?);
                    }
                    "DbiResourceId" => {
                        obj.dbi_resource_id =
                            Some(StringDeserializer::deserialize("DbiResourceId", stack)?);
                    }
                    "Encrypted" => {
                        obj.encrypted = Some(BooleanDeserializer::deserialize("Encrypted", stack)?);
                    }
                    "Engine" => {
                        obj.engine = Some(StringDeserializer::deserialize("Engine", stack)?);
                    }
                    "EngineVersion" => {
                        obj.engine_version =
                            Some(StringDeserializer::deserialize("EngineVersion", stack)?);
                    }
                    "IAMDatabaseAuthenticationEnabled" => {
                        obj.iam_database_authentication_enabled =
                            Some(BooleanDeserializer::deserialize(
                                "IAMDatabaseAuthenticationEnabled",
                                stack,
                            )?);
                    }
                    "InstanceCreateTime" => {
                        obj.instance_create_time = Some(TStampDeserializer::deserialize(
                            "InstanceCreateTime",
                            stack,
                        )?);
                    }
                    "Iops" => {
                        obj.iops = Some(IntegerOptionalDeserializer::deserialize("Iops", stack)?);
                    }
                    "KmsKeyId" => {
                        obj.kms_key_id = Some(StringDeserializer::deserialize("KmsKeyId", stack)?);
                    }
                    "LicenseModel" => {
                        obj.license_model =
                            Some(StringDeserializer::deserialize("LicenseModel", stack)?);
                    }
                    "MasterUsername" => {
                        obj.master_username =
                            Some(StringDeserializer::deserialize("MasterUsername", stack)?);
                    }
                    "OptionGroupName" => {
                        obj.option_group_name =
                            Some(StringDeserializer::deserialize("OptionGroupName", stack)?);
                    }
                    "Port" => {
                        obj.port = Some(IntegerDeserializer::deserialize("Port", stack)?);
                    }
                    "Region" => {
                        obj.region = Some(StringDeserializer::deserialize("Region", stack)?);
                    }
                    "RestoreWindow" => {
                        obj.restore_window = Some(RestoreWindowDeserializer::deserialize(
                            "RestoreWindow",
                            stack,
                        )?);
                    }
                    "Status" => {
                        obj.status = Some(StringDeserializer::deserialize("Status", stack)?);
                    }
                    "StorageType" => {
                        obj.storage_type =
                            Some(StringDeserializer::deserialize("StorageType", stack)?);
                    }
                    "TdeCredentialArn" => {
                        obj.tde_credential_arn =
                            Some(StringDeserializer::deserialize("TdeCredentialArn", stack)?);
                    }
                    "Timezone" => {
                        obj.timezone = Some(StringDeserializer::deserialize("Timezone", stack)?);
                    }
                    "VpcId" => {
                        obj.vpc_id = Some(StringDeserializer::deserialize("VpcId", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct DBInstanceAutomatedBackupListDeserializer;
impl DBInstanceAutomatedBackupListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<DBInstanceAutomatedBackup>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "DBInstanceAutomatedBackup" {
                obj.push(DBInstanceAutomatedBackupDeserializer::deserialize(
                    "DBInstanceAutomatedBackup",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p> Contains the result of a successful invocation of the <code>DescribeDBInstanceAutomatedBackups</code> action. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DBInstanceAutomatedBackupMessage {
    /// <p> A list of <code>DBInstanceAutomatedBackup</code> instances. </p>
    pub db_instance_automated_backups: Option<Vec<DBInstanceAutomatedBackup>>,
    /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> . </p>
    pub marker: Option<String>,
}

#[allow(dead_code)]
struct DBInstanceAutomatedBackupMessageDeserializer;
impl DBInstanceAutomatedBackupMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DBInstanceAutomatedBackupMessage, XmlParseError> {
        deserialize_elements::<_, DBInstanceAutomatedBackupMessage, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DBInstanceAutomatedBackups" => {
                        obj.db_instance_automated_backups
                            .get_or_insert(vec![])
                            .extend(DBInstanceAutomatedBackupListDeserializer::deserialize(
                                "DBInstanceAutomatedBackups",
                                stack,
                            )?);
                    }
                    "Marker" => {
                        obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Automated backups of a DB instance replicated to another Amazon Web Services Region. They consist of system backups, transaction logs, and database instance properties.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DBInstanceAutomatedBackupsReplication {
    /// <p>The Amazon Resource Name (ARN) of the replicated automated backups.</p>
    pub db_instance_automated_backups_arn: Option<String>,
}

#[allow(dead_code)]
struct DBInstanceAutomatedBackupsReplicationDeserializer;
impl DBInstanceAutomatedBackupsReplicationDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DBInstanceAutomatedBackupsReplication, XmlParseError> {
        deserialize_elements::<_, DBInstanceAutomatedBackupsReplication, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DBInstanceAutomatedBackupsArn" => {
                        obj.db_instance_automated_backups_arn =
                            Some(StringDeserializer::deserialize(
                                "DBInstanceAutomatedBackupsArn",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct DBInstanceAutomatedBackupsReplicationListDeserializer;
impl DBInstanceAutomatedBackupsReplicationListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<DBInstanceAutomatedBackupsReplication>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "DBInstanceAutomatedBackupsReplication" {
                obj.push(
                    DBInstanceAutomatedBackupsReplicationDeserializer::deserialize(
                        "DBInstanceAutomatedBackupsReplication",
                        stack,
                    )?,
                );
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct DBInstanceListDeserializer;
impl DBInstanceListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<DBInstance>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "DBInstance" {
                obj.push(DBInstanceDeserializer::deserialize("DBInstance", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p> Contains the result of a successful invocation of the <code>DescribeDBInstances</code> action. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DBInstanceMessage {
    /// <p> A list of <code>DBInstance</code> instances. </p>
    pub db_instances: Option<Vec<DBInstance>>,
    /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> . </p>
    pub marker: Option<String>,
}

#[allow(dead_code)]
struct DBInstanceMessageDeserializer;
impl DBInstanceMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DBInstanceMessage, XmlParseError> {
        deserialize_elements::<_, DBInstanceMessage, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "DBInstances" => {
                    obj.db_instances.get_or_insert(vec![]).extend(
                        DBInstanceListDeserializer::deserialize("DBInstances", stack)?,
                    );
                }
                "Marker" => {
                    obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>Describes an Amazon Web Services Identity and Access Management (IAM) role that is associated with a DB instance.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DBInstanceRole {
    /// <p>The name of the feature associated with the Amazon Web Services Identity and Access Management (IAM) role. For the list of supported feature names, see <code>DBEngineVersion</code>. </p>
    pub feature_name: Option<String>,
    /// <p>The Amazon Resource Name (ARN) of the IAM role that is associated with the DB instance.</p>
    pub role_arn: Option<String>,
    /// <p><p>Describes the state of association between the IAM role and the DB instance. The Status property returns one of the following values:</p> <ul> <li> <p> <code>ACTIVE</code> - the IAM role ARN is associated with the DB instance and can be used to access other Amazon Web Services services on your behalf.</p> </li> <li> <p> <code>PENDING</code> - the IAM role ARN is being associated with the DB instance.</p> </li> <li> <p> <code>INVALID</code> - the IAM role ARN is associated with the DB instance, but the DB instance is unable to assume the IAM role in order to access other Amazon Web Services services on your behalf.</p> </li> </ul></p>
    pub status: Option<String>,
}

#[allow(dead_code)]
struct DBInstanceRoleDeserializer;
impl DBInstanceRoleDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DBInstanceRole, XmlParseError> {
        deserialize_elements::<_, DBInstanceRole, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "FeatureName" => {
                    obj.feature_name = Some(StringDeserializer::deserialize("FeatureName", stack)?);
                }
                "RoleArn" => {
                    obj.role_arn = Some(StringDeserializer::deserialize("RoleArn", stack)?);
                }
                "Status" => {
                    obj.status = Some(StringDeserializer::deserialize("Status", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct DBInstanceRolesDeserializer;
impl DBInstanceRolesDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<DBInstanceRole>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "DBInstanceRole" {
                obj.push(DBInstanceRoleDeserializer::deserialize(
                    "DBInstanceRole",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Provides a list of status information for a DB instance.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DBInstanceStatusInfo {
    /// <p>Details of the error if there is an error for the instance. If the instance isn't in an error state, this value is blank.</p>
    pub message: Option<String>,
    /// <p>Boolean value that is true if the instance is operating normally, or false if the instance is in an error state.</p>
    pub normal: Option<bool>,
    /// <p>Status of the DB instance. For a StatusType of read replica, the values can be replicating, replication stop point set, replication stop point reached, error, stopped, or terminated.</p>
    pub status: Option<String>,
    /// <p>This value is currently "read replication."</p>
    pub status_type: Option<String>,
}

#[allow(dead_code)]
struct DBInstanceStatusInfoDeserializer;
impl DBInstanceStatusInfoDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DBInstanceStatusInfo, XmlParseError> {
        deserialize_elements::<_, DBInstanceStatusInfo, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Message" => {
                    obj.message = Some(StringDeserializer::deserialize("Message", stack)?);
                }
                "Normal" => {
                    obj.normal = Some(BooleanDeserializer::deserialize("Normal", stack)?);
                }
                "Status" => {
                    obj.status = Some(StringDeserializer::deserialize("Status", stack)?);
                }
                "StatusType" => {
                    obj.status_type = Some(StringDeserializer::deserialize("StatusType", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct DBInstanceStatusInfoListDeserializer;
impl DBInstanceStatusInfoListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<DBInstanceStatusInfo>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "DBInstanceStatusInfo" {
                obj.push(DBInstanceStatusInfoDeserializer::deserialize(
                    "DBInstanceStatusInfo",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Contains the details of an Amazon RDS DB parameter group. </p> <p>This data type is used as a response element in the <code>DescribeDBParameterGroups</code> action. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DBParameterGroup {
    /// <p>The Amazon Resource Name (ARN) for the DB parameter group.</p>
    pub db_parameter_group_arn: Option<String>,
    /// <p>The name of the DB parameter group family that this DB parameter group is compatible with.</p>
    pub db_parameter_group_family: Option<String>,
    /// <p>The name of the DB parameter group.</p>
    pub db_parameter_group_name: Option<String>,
    /// <p>Provides the customer-specified description for this DB parameter group.</p>
    pub description: Option<String>,
}

#[allow(dead_code)]
struct DBParameterGroupDeserializer;
impl DBParameterGroupDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DBParameterGroup, XmlParseError> {
        deserialize_elements::<_, DBParameterGroup, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "DBParameterGroupArn" => {
                    obj.db_parameter_group_arn = Some(StringDeserializer::deserialize(
                        "DBParameterGroupArn",
                        stack,
                    )?);
                }
                "DBParameterGroupFamily" => {
                    obj.db_parameter_group_family = Some(StringDeserializer::deserialize(
                        "DBParameterGroupFamily",
                        stack,
                    )?);
                }
                "DBParameterGroupName" => {
                    obj.db_parameter_group_name = Some(StringDeserializer::deserialize(
                        "DBParameterGroupName",
                        stack,
                    )?);
                }
                "Description" => {
                    obj.description = Some(StringDeserializer::deserialize("Description", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p> Contains the result of a successful invocation of the <code>DescribeDBParameters</code> action. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DBParameterGroupDetails {
    /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    pub marker: Option<String>,
    /// <p> A list of <code>Parameter</code> values. </p>
    pub parameters: Option<Vec<Parameter>>,
}

#[allow(dead_code)]
struct DBParameterGroupDetailsDeserializer;
impl DBParameterGroupDetailsDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DBParameterGroupDetails, XmlParseError> {
        deserialize_elements::<_, DBParameterGroupDetails, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Marker" => {
                        obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                    }
                    "Parameters" => {
                        obj.parameters.get_or_insert(vec![]).extend(
                            ParametersListDeserializer::deserialize("Parameters", stack)?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct DBParameterGroupListDeserializer;
impl DBParameterGroupListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<DBParameterGroup>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "DBParameterGroup" {
                obj.push(DBParameterGroupDeserializer::deserialize(
                    "DBParameterGroup",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p> Contains the result of a successful invocation of the <code>ModifyDBParameterGroup</code> or <code>ResetDBParameterGroup</code> action. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DBParameterGroupNameMessage {
    /// <p>The name of the DB parameter group.</p>
    pub db_parameter_group_name: Option<String>,
}

#[allow(dead_code)]
struct DBParameterGroupNameMessageDeserializer;
impl DBParameterGroupNameMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DBParameterGroupNameMessage, XmlParseError> {
        deserialize_elements::<_, DBParameterGroupNameMessage, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DBParameterGroupName" => {
                        obj.db_parameter_group_name = Some(StringDeserializer::deserialize(
                            "DBParameterGroupName",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p><p>The status of the DB parameter group.</p> <p>This data type is used as a response element in the following actions:</p> <ul> <li> <p> <code>CreateDBInstance</code> </p> </li> <li> <p> <code>CreateDBInstanceReadReplica</code> </p> </li> <li> <p> <code>DeleteDBInstance</code> </p> </li> <li> <p> <code>ModifyDBInstance</code> </p> </li> <li> <p> <code>RebootDBInstance</code> </p> </li> <li> <p> <code>RestoreDBInstanceFromDBSnapshot</code> </p> </li> </ul></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DBParameterGroupStatus {
    /// <p>The name of the DB parameter group.</p>
    pub db_parameter_group_name: Option<String>,
    /// <p>The status of parameter updates.</p>
    pub parameter_apply_status: Option<String>,
}

#[allow(dead_code)]
struct DBParameterGroupStatusDeserializer;
impl DBParameterGroupStatusDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DBParameterGroupStatus, XmlParseError> {
        deserialize_elements::<_, DBParameterGroupStatus, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "DBParameterGroupName" => {
                    obj.db_parameter_group_name = Some(StringDeserializer::deserialize(
                        "DBParameterGroupName",
                        stack,
                    )?);
                }
                "ParameterApplyStatus" => {
                    obj.parameter_apply_status = Some(StringDeserializer::deserialize(
                        "ParameterApplyStatus",
                        stack,
                    )?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct DBParameterGroupStatusListDeserializer;
impl DBParameterGroupStatusListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<DBParameterGroupStatus>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "DBParameterGroup" {
                obj.push(DBParameterGroupStatusDeserializer::deserialize(
                    "DBParameterGroup",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p> Contains the result of a successful invocation of the <code>DescribeDBParameterGroups</code> action. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DBParameterGroupsMessage {
    /// <p> A list of <code>DBParameterGroup</code> instances. </p>
    pub db_parameter_groups: Option<Vec<DBParameterGroup>>,
    /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    pub marker: Option<String>,
}

#[allow(dead_code)]
struct DBParameterGroupsMessageDeserializer;
impl DBParameterGroupsMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DBParameterGroupsMessage, XmlParseError> {
        deserialize_elements::<_, DBParameterGroupsMessage, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DBParameterGroups" => {
                        obj.db_parameter_groups.get_or_insert(vec![]).extend(
                            DBParameterGroupListDeserializer::deserialize(
                                "DBParameterGroups",
                                stack,
                            )?,
                        );
                    }
                    "Marker" => {
                        obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>The data structure representing a proxy managed by the RDS Proxy.</p> <p>This data type is used as a response element in the <code>DescribeDBProxies</code> action.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DBProxy {
    /// <p>One or more data structures specifying the authorization mechanism to connect to the associated RDS DB instance or Aurora DB cluster.</p>
    pub auth: Option<Vec<UserAuthConfigInfo>>,
    /// <p>The date and time when the proxy was first created.</p>
    pub created_date: Option<String>,
    /// <p>The Amazon Resource Name (ARN) for the proxy.</p>
    pub db_proxy_arn: Option<String>,
    /// <p>The identifier for the proxy. This name must be unique for all proxies owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>
    pub db_proxy_name: Option<String>,
    /// <p>Whether the proxy includes detailed information about SQL statements in its logs. This information helps you to debug issues involving SQL behavior or the performance and scalability of the proxy connections. The debug information includes the text of SQL statements that you submit through the proxy. Thus, only enable this setting when needed for debugging, and only when you have security measures in place to safeguard any sensitive information that appears in the logs.</p>
    pub debug_logging: Option<bool>,
    /// <p>The endpoint that you can use to connect to the DB proxy. You include the endpoint value in the connection string for a database client application.</p>
    pub endpoint: Option<String>,
    /// <p>The engine family applies to MySQL and PostgreSQL for both RDS and Aurora.</p>
    pub engine_family: Option<String>,
    /// <p>The number of seconds a connection to the proxy can have no activity before the proxy drops the client connection. The proxy keeps the underlying database connection open and puts it back into the connection pool for reuse by later connection requests.</p> <p>Default: 1800 (30 minutes)</p> <p>Constraints: 1 to 28,800</p>
    pub idle_client_timeout: Option<i64>,
    /// <p>Indicates whether Transport Layer Security (TLS) encryption is required for connections to the proxy.</p>
    pub require_tls: Option<bool>,
    /// <p>The Amazon Resource Name (ARN) for the IAM role that the proxy uses to access Amazon Secrets Manager.</p>
    pub role_arn: Option<String>,
    /// <p>The current status of this proxy. A status of <code>available</code> means the proxy is ready to handle requests. Other values indicate that you must wait for the proxy to be ready, or take some action to resolve an issue.</p>
    pub status: Option<String>,
    /// <p>The date and time when the proxy was last updated.</p>
    pub updated_date: Option<String>,
    /// <p>Provides the VPC ID of the DB proxy.</p>
    pub vpc_id: Option<String>,
    /// <p>Provides a list of VPC security groups that the proxy belongs to.</p>
    pub vpc_security_group_ids: Option<Vec<String>>,
    /// <p>The EC2 subnet IDs for the proxy.</p>
    pub vpc_subnet_ids: Option<Vec<String>>,
}

#[allow(dead_code)]
struct DBProxyDeserializer;
impl DBProxyDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DBProxy, XmlParseError> {
        deserialize_elements::<_, DBProxy, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Auth" => {
                    obj.auth.get_or_insert(vec![]).extend(
                        UserAuthConfigInfoListDeserializer::deserialize("Auth", stack)?,
                    );
                }
                "CreatedDate" => {
                    obj.created_date = Some(TStampDeserializer::deserialize("CreatedDate", stack)?);
                }
                "DBProxyArn" => {
                    obj.db_proxy_arn = Some(StringDeserializer::deserialize("DBProxyArn", stack)?);
                }
                "DBProxyName" => {
                    obj.db_proxy_name =
                        Some(StringDeserializer::deserialize("DBProxyName", stack)?);
                }
                "DebugLogging" => {
                    obj.debug_logging =
                        Some(BooleanDeserializer::deserialize("DebugLogging", stack)?);
                }
                "Endpoint" => {
                    obj.endpoint = Some(StringDeserializer::deserialize("Endpoint", stack)?);
                }
                "EngineFamily" => {
                    obj.engine_family =
                        Some(StringDeserializer::deserialize("EngineFamily", stack)?);
                }
                "IdleClientTimeout" => {
                    obj.idle_client_timeout = Some(IntegerDeserializer::deserialize(
                        "IdleClientTimeout",
                        stack,
                    )?);
                }
                "RequireTLS" => {
                    obj.require_tls = Some(BooleanDeserializer::deserialize("RequireTLS", stack)?);
                }
                "RoleArn" => {
                    obj.role_arn = Some(StringDeserializer::deserialize("RoleArn", stack)?);
                }
                "Status" => {
                    obj.status = Some(DBProxyStatusDeserializer::deserialize("Status", stack)?);
                }
                "UpdatedDate" => {
                    obj.updated_date = Some(TStampDeserializer::deserialize("UpdatedDate", stack)?);
                }
                "VpcId" => {
                    obj.vpc_id = Some(StringDeserializer::deserialize("VpcId", stack)?);
                }
                "VpcSecurityGroupIds" => {
                    obj.vpc_security_group_ids.get_or_insert(vec![]).extend(
                        StringListDeserializer::deserialize("VpcSecurityGroupIds", stack)?,
                    );
                }
                "VpcSubnetIds" => {
                    obj.vpc_subnet_ids
                        .get_or_insert(vec![])
                        .extend(StringListDeserializer::deserialize("VpcSubnetIds", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>The data structure representing an endpoint associated with a DB proxy. RDS automatically creates one endpoint for each DB proxy. For Aurora DB clusters, you can associate additional endpoints with the same DB proxy. These endpoints can be read/write or read-only. They can also reside in different VPCs than the associated DB proxy.</p> <p>This data type is used as a response element in the <code>DescribeDBProxyEndpoints</code> operation.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DBProxyEndpoint {
    /// <p>The date and time when the DB proxy endpoint was first created.</p>
    pub created_date: Option<String>,
    /// <p>The Amazon Resource Name (ARN) for the DB proxy endpoint.</p>
    pub db_proxy_endpoint_arn: Option<String>,
    /// <p>The name for the DB proxy endpoint. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.</p>
    pub db_proxy_endpoint_name: Option<String>,
    /// <p>The identifier for the DB proxy that is associated with this DB proxy endpoint.</p>
    pub db_proxy_name: Option<String>,
    /// <p>The endpoint that you can use to connect to the DB proxy. You include the endpoint value in the connection string for a database client application.</p>
    pub endpoint: Option<String>,
    /// <p>A value that indicates whether this endpoint is the default endpoint for the associated DB proxy. Default DB proxy endpoints always have read/write capability. Other endpoints that you associate with the DB proxy can be either read/write or read-only.</p>
    pub is_default: Option<bool>,
    /// <p>The current status of this DB proxy endpoint. A status of <code>available</code> means the endpoint is ready to handle requests. Other values indicate that you must wait for the endpoint to be ready, or take some action to resolve an issue.</p>
    pub status: Option<String>,
    /// <p>A value that indicates whether the DB proxy endpoint can be used for read/write or read-only operations.</p>
    pub target_role: Option<String>,
    /// <p>Provides the VPC ID of the DB proxy endpoint.</p>
    pub vpc_id: Option<String>,
    /// <p>Provides a list of VPC security groups that the DB proxy endpoint belongs to.</p>
    pub vpc_security_group_ids: Option<Vec<String>>,
    /// <p>The EC2 subnet IDs for the DB proxy endpoint.</p>
    pub vpc_subnet_ids: Option<Vec<String>>,
}

#[allow(dead_code)]
struct DBProxyEndpointDeserializer;
impl DBProxyEndpointDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DBProxyEndpoint, XmlParseError> {
        deserialize_elements::<_, DBProxyEndpoint, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "CreatedDate" => {
                    obj.created_date = Some(TStampDeserializer::deserialize("CreatedDate", stack)?);
                }
                "DBProxyEndpointArn" => {
                    obj.db_proxy_endpoint_arn = Some(StringDeserializer::deserialize(
                        "DBProxyEndpointArn",
                        stack,
                    )?);
                }
                "DBProxyEndpointName" => {
                    obj.db_proxy_endpoint_name = Some(StringDeserializer::deserialize(
                        "DBProxyEndpointName",
                        stack,
                    )?);
                }
                "DBProxyName" => {
                    obj.db_proxy_name =
                        Some(StringDeserializer::deserialize("DBProxyName", stack)?);
                }
                "Endpoint" => {
                    obj.endpoint = Some(StringDeserializer::deserialize("Endpoint", stack)?);
                }
                "IsDefault" => {
                    obj.is_default = Some(BooleanDeserializer::deserialize("IsDefault", stack)?);
                }
                "Status" => {
                    obj.status = Some(DBProxyEndpointStatusDeserializer::deserialize(
                        "Status", stack,
                    )?);
                }
                "TargetRole" => {
                    obj.target_role = Some(DBProxyEndpointTargetRoleDeserializer::deserialize(
                        "TargetRole",
                        stack,
                    )?);
                }
                "VpcId" => {
                    obj.vpc_id = Some(StringDeserializer::deserialize("VpcId", stack)?);
                }
                "VpcSecurityGroupIds" => {
                    obj.vpc_security_group_ids.get_or_insert(vec![]).extend(
                        StringListDeserializer::deserialize("VpcSecurityGroupIds", stack)?,
                    );
                }
                "VpcSubnetIds" => {
                    obj.vpc_subnet_ids
                        .get_or_insert(vec![])
                        .extend(StringListDeserializer::deserialize("VpcSubnetIds", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct DBProxyEndpointListDeserializer;
impl DBProxyEndpointListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<DBProxyEndpoint>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(DBProxyEndpointDeserializer::deserialize("member", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct DBProxyEndpointStatusDeserializer;
impl DBProxyEndpointStatusDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct DBProxyEndpointTargetRoleDeserializer;
impl DBProxyEndpointTargetRoleDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct DBProxyListDeserializer;
impl DBProxyListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<DBProxy>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(DBProxyDeserializer::deserialize("member", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct DBProxyStatusDeserializer;
impl DBProxyStatusDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p>Contains the details for an RDS Proxy target. It represents an RDS DB instance or Aurora DB cluster that the proxy can connect to. One or more targets are associated with an RDS Proxy target group.</p> <p>This data type is used as a response element in the <code>DescribeDBProxyTargets</code> action.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DBProxyTarget {
    /// <p>The writer endpoint for the RDS DB instance or Aurora DB cluster.</p>
    pub endpoint: Option<String>,
    /// <p>The port that the RDS Proxy uses to connect to the target RDS DB instance or Aurora DB cluster.</p>
    pub port: Option<i64>,
    /// <p>The identifier representing the target. It can be the instance identifier for an RDS DB instance, or the cluster identifier for an Aurora DB cluster.</p>
    pub rds_resource_id: Option<String>,
    /// <p>A value that indicates whether the target of the proxy can be used for read/write or read-only operations.</p>
    pub role: Option<String>,
    /// <p>The Amazon Resource Name (ARN) for the RDS DB instance or Aurora DB cluster.</p>
    pub target_arn: Option<String>,
    /// <p>Information about the connection health of the RDS Proxy target.</p>
    pub target_health: Option<TargetHealth>,
    /// <p>The DB cluster identifier when the target represents an Aurora DB cluster. This field is blank when the target represents an RDS DB instance.</p>
    pub tracked_cluster_id: Option<String>,
    /// <p>Specifies the kind of database, such as an RDS DB instance or an Aurora DB cluster, that the target represents.</p>
    pub type_: Option<String>,
}

#[allow(dead_code)]
struct DBProxyTargetDeserializer;
impl DBProxyTargetDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DBProxyTarget, XmlParseError> {
        deserialize_elements::<_, DBProxyTarget, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Endpoint" => {
                    obj.endpoint = Some(StringDeserializer::deserialize("Endpoint", stack)?);
                }
                "Port" => {
                    obj.port = Some(IntegerDeserializer::deserialize("Port", stack)?);
                }
                "RdsResourceId" => {
                    obj.rds_resource_id =
                        Some(StringDeserializer::deserialize("RdsResourceId", stack)?);
                }
                "Role" => {
                    obj.role = Some(TargetRoleDeserializer::deserialize("Role", stack)?);
                }
                "TargetArn" => {
                    obj.target_arn = Some(StringDeserializer::deserialize("TargetArn", stack)?);
                }
                "TargetHealth" => {
                    obj.target_health = Some(TargetHealthDeserializer::deserialize(
                        "TargetHealth",
                        stack,
                    )?);
                }
                "TrackedClusterId" => {
                    obj.tracked_cluster_id =
                        Some(StringDeserializer::deserialize("TrackedClusterId", stack)?);
                }
                "Type" => {
                    obj.type_ = Some(TargetTypeDeserializer::deserialize("Type", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>Represents a set of RDS DB instances, Aurora DB clusters, or both that a proxy can connect to. Currently, each target group is associated with exactly one RDS DB instance or Aurora DB cluster.</p> <p>This data type is used as a response element in the <code>DescribeDBProxyTargetGroups</code> action.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DBProxyTargetGroup {
    /// <p>The settings that determine the size and behavior of the connection pool for the target group.</p>
    pub connection_pool_config: Option<ConnectionPoolConfigurationInfo>,
    /// <p>The date and time when the target group was first created.</p>
    pub created_date: Option<String>,
    /// <p>The identifier for the RDS proxy associated with this target group.</p>
    pub db_proxy_name: Option<String>,
    /// <p>Whether this target group is the first one used for connection requests by the associated proxy. Because each proxy is currently associated with a single target group, currently this setting is always <code>true</code>.</p>
    pub is_default: Option<bool>,
    /// <p>The current status of this target group. A status of <code>available</code> means the target group is correctly associated with a database. Other values indicate that you must wait for the target group to be ready, or take some action to resolve an issue.</p>
    pub status: Option<String>,
    /// <p>The Amazon Resource Name (ARN) representing the target group.</p>
    pub target_group_arn: Option<String>,
    /// <p>The identifier for the target group. This name must be unique for all target groups owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>
    pub target_group_name: Option<String>,
    /// <p>The date and time when the target group was last updated.</p>
    pub updated_date: Option<String>,
}

#[allow(dead_code)]
struct DBProxyTargetGroupDeserializer;
impl DBProxyTargetGroupDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DBProxyTargetGroup, XmlParseError> {
        deserialize_elements::<_, DBProxyTargetGroup, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "ConnectionPoolConfig" => {
                    obj.connection_pool_config =
                        Some(ConnectionPoolConfigurationInfoDeserializer::deserialize(
                            "ConnectionPoolConfig",
                            stack,
                        )?);
                }
                "CreatedDate" => {
                    obj.created_date = Some(TStampDeserializer::deserialize("CreatedDate", stack)?);
                }
                "DBProxyName" => {
                    obj.db_proxy_name =
                        Some(StringDeserializer::deserialize("DBProxyName", stack)?);
                }
                "IsDefault" => {
                    obj.is_default = Some(BooleanDeserializer::deserialize("IsDefault", stack)?);
                }
                "Status" => {
                    obj.status = Some(StringDeserializer::deserialize("Status", stack)?);
                }
                "TargetGroupArn" => {
                    obj.target_group_arn =
                        Some(StringDeserializer::deserialize("TargetGroupArn", stack)?);
                }
                "TargetGroupName" => {
                    obj.target_group_name =
                        Some(StringDeserializer::deserialize("TargetGroupName", stack)?);
                }
                "UpdatedDate" => {
                    obj.updated_date = Some(TStampDeserializer::deserialize("UpdatedDate", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>Contains the details for an Amazon RDS DB security group. </p> <p>This data type is used as a response element in the <code>DescribeDBSecurityGroups</code> action. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DBSecurityGroup {
    /// <p>The Amazon Resource Name (ARN) for the DB security group.</p>
    pub db_security_group_arn: Option<String>,
    /// <p>Provides the description of the DB security group.</p>
    pub db_security_group_description: Option<String>,
    /// <p>Specifies the name of the DB security group.</p>
    pub db_security_group_name: Option<String>,
    /// <p> Contains a list of <code>EC2SecurityGroup</code> elements. </p>
    pub ec2_security_groups: Option<Vec<EC2SecurityGroup>>,
    /// <p> Contains a list of <code>IPRange</code> elements. </p>
    pub ip_ranges: Option<Vec<IPRange>>,
    /// <p>Provides the Amazon Web Services ID of the owner of a specific DB security group.</p>
    pub owner_id: Option<String>,
    /// <p>Provides the VpcId of the DB security group.</p>
    pub vpc_id: Option<String>,
}

#[allow(dead_code)]
struct DBSecurityGroupDeserializer;
impl DBSecurityGroupDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DBSecurityGroup, XmlParseError> {
        deserialize_elements::<_, DBSecurityGroup, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "DBSecurityGroupArn" => {
                    obj.db_security_group_arn = Some(StringDeserializer::deserialize(
                        "DBSecurityGroupArn",
                        stack,
                    )?);
                }
                "DBSecurityGroupDescription" => {
                    obj.db_security_group_description = Some(StringDeserializer::deserialize(
                        "DBSecurityGroupDescription",
                        stack,
                    )?);
                }
                "DBSecurityGroupName" => {
                    obj.db_security_group_name = Some(StringDeserializer::deserialize(
                        "DBSecurityGroupName",
                        stack,
                    )?);
                }
                "EC2SecurityGroups" => {
                    obj.ec2_security_groups.get_or_insert(vec![]).extend(
                        EC2SecurityGroupListDeserializer::deserialize("EC2SecurityGroups", stack)?,
                    );
                }
                "IPRanges" => {
                    obj.ip_ranges
                        .get_or_insert(vec![])
                        .extend(IPRangeListDeserializer::deserialize("IPRanges", stack)?);
                }
                "OwnerId" => {
                    obj.owner_id = Some(StringDeserializer::deserialize("OwnerId", stack)?);
                }
                "VpcId" => {
                    obj.vpc_id = Some(StringDeserializer::deserialize("VpcId", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p><p>This data type is used as a response element in the following actions:</p> <ul> <li> <p> <code>ModifyDBInstance</code> </p> </li> <li> <p> <code>RebootDBInstance</code> </p> </li> <li> <p> <code>RestoreDBInstanceFromDBSnapshot</code> </p> </li> <li> <p> <code>RestoreDBInstanceToPointInTime</code> </p> </li> </ul></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DBSecurityGroupMembership {
    /// <p>The name of the DB security group.</p>
    pub db_security_group_name: Option<String>,
    /// <p>The status of the DB security group.</p>
    pub status: Option<String>,
}

#[allow(dead_code)]
struct DBSecurityGroupMembershipDeserializer;
impl DBSecurityGroupMembershipDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DBSecurityGroupMembership, XmlParseError> {
        deserialize_elements::<_, DBSecurityGroupMembership, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DBSecurityGroupName" => {
                        obj.db_security_group_name = Some(StringDeserializer::deserialize(
                            "DBSecurityGroupName",
                            stack,
                        )?);
                    }
                    "Status" => {
                        obj.status = Some(StringDeserializer::deserialize("Status", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct DBSecurityGroupMembershipListDeserializer;
impl DBSecurityGroupMembershipListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<DBSecurityGroupMembership>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "DBSecurityGroup" {
                obj.push(DBSecurityGroupMembershipDeserializer::deserialize(
                    "DBSecurityGroup",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p> Contains the result of a successful invocation of the <code>DescribeDBSecurityGroups</code> action. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DBSecurityGroupMessage {
    /// <p> A list of <code>DBSecurityGroup</code> instances. </p>
    pub db_security_groups: Option<Vec<DBSecurityGroup>>,
    /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    pub marker: Option<String>,
}

#[allow(dead_code)]
struct DBSecurityGroupMessageDeserializer;
impl DBSecurityGroupMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DBSecurityGroupMessage, XmlParseError> {
        deserialize_elements::<_, DBSecurityGroupMessage, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "DBSecurityGroups" => {
                    obj.db_security_groups.get_or_insert(vec![]).extend(
                        DBSecurityGroupsDeserializer::deserialize("DBSecurityGroups", stack)?,
                    );
                }
                "Marker" => {
                    obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}

/// Serialize `DBSecurityGroupNameList` contents to a `SignedRequest`.
struct DBSecurityGroupNameListSerializer;
impl DBSecurityGroupNameListSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<String>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.member.{}", name, index + 1);
            params.put(&key, &obj);
        }
    }
}

#[allow(dead_code)]
struct DBSecurityGroupsDeserializer;
impl DBSecurityGroupsDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<DBSecurityGroup>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "DBSecurityGroup" {
                obj.push(DBSecurityGroupDeserializer::deserialize(
                    "DBSecurityGroup",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Contains the details of an Amazon RDS DB snapshot. </p> <p>This data type is used as a response element in the <code>DescribeDBSnapshots</code> action. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DBSnapshot {
    /// <p>Specifies the allocated storage size in gibibytes (GiB).</p>
    pub allocated_storage: Option<i64>,
    /// <p>Specifies the name of the Availability Zone the DB instance was located in at the time of the DB snapshot.</p>
    pub availability_zone: Option<String>,
    /// <p>Specifies the DB instance identifier of the DB instance this DB snapshot was created from.</p>
    pub db_instance_identifier: Option<String>,
    /// <p>The Amazon Resource Name (ARN) for the DB snapshot.</p>
    pub db_snapshot_arn: Option<String>,
    /// <p>Specifies the identifier for the DB snapshot.</p>
    pub db_snapshot_identifier: Option<String>,
    /// <p>The identifier for the source DB instance, which can't be changed and which is unique to an Amazon Web Services Region.</p>
    pub dbi_resource_id: Option<String>,
    /// <p>Specifies whether the DB snapshot is encrypted.</p>
    pub encrypted: Option<bool>,
    /// <p>Specifies the name of the database engine.</p>
    pub engine: Option<String>,
    /// <p>Specifies the version of the database engine.</p>
    pub engine_version: Option<String>,
    /// <p>True if mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.</p>
    pub iam_database_authentication_enabled: Option<bool>,
    /// <p>Specifies the time in Coordinated Universal Time (UTC) when the DB instance, from which the snapshot was taken, was created.</p>
    pub instance_create_time: Option<String>,
    /// <p>Specifies the Provisioned IOPS (I/O operations per second) value of the DB instance at the time of the snapshot.</p>
    pub iops: Option<i64>,
    /// <p> If <code>Encrypted</code> is true, the Amazon Web Services KMS key identifier for the encrypted DB snapshot. </p> <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the Amazon Web Services KMS customer master key (CMK).</p>
    pub kms_key_id: Option<String>,
    /// <p>License model information for the restored DB instance.</p>
    pub license_model: Option<String>,
    /// <p>Provides the master username for the DB snapshot.</p>
    pub master_username: Option<String>,
    /// <p>Provides the option group name for the DB snapshot.</p>
    pub option_group_name: Option<String>,
    /// <p>The percentage of the estimated data that has been transferred.</p>
    pub percent_progress: Option<i64>,
    /// <p>Specifies the port that the database engine was listening on at the time of the snapshot.</p>
    pub port: Option<i64>,
    /// <p>The number of CPU cores and the number of threads per core for the DB instance class of the DB instance when the DB snapshot was created.</p>
    pub processor_features: Option<Vec<ProcessorFeature>>,
    /// <p>Specifies when the snapshot was taken in Coordinated Universal Time (UTC).</p>
    pub snapshot_create_time: Option<String>,
    /// <p>Provides the type of the DB snapshot.</p>
    pub snapshot_type: Option<String>,
    /// <p>The DB snapshot Amazon Resource Name (ARN) that the DB snapshot was copied from. It only has value in case of cross-customer or cross-region copy.</p>
    pub source_db_snapshot_identifier: Option<String>,
    /// <p>The Amazon Web Services Region that the DB snapshot was created in or copied from.</p>
    pub source_region: Option<String>,
    /// <p>Specifies the status of this DB snapshot.</p>
    pub status: Option<String>,
    /// <p>Specifies the storage type associated with DB snapshot.</p>
    pub storage_type: Option<String>,
    pub tag_list: Option<Vec<Tag>>,
    /// <p>The ARN from the key store with which to associate the instance for TDE encryption.</p>
    pub tde_credential_arn: Option<String>,
    /// <p>The time zone of the DB snapshot. In most cases, the <code>Timezone</code> element is empty. <code>Timezone</code> content appears only for snapshots taken from Microsoft SQL Server DB instances that were created with a time zone specified. </p>
    pub timezone: Option<String>,
    /// <p>Provides the VPC ID associated with the DB snapshot.</p>
    pub vpc_id: Option<String>,
}

#[allow(dead_code)]
struct DBSnapshotDeserializer;
impl DBSnapshotDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DBSnapshot, XmlParseError> {
        deserialize_elements::<_, DBSnapshot, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "AllocatedStorage" => {
                    obj.allocated_storage =
                        Some(IntegerDeserializer::deserialize("AllocatedStorage", stack)?);
                }
                "AvailabilityZone" => {
                    obj.availability_zone =
                        Some(StringDeserializer::deserialize("AvailabilityZone", stack)?);
                }
                "DBInstanceIdentifier" => {
                    obj.db_instance_identifier = Some(StringDeserializer::deserialize(
                        "DBInstanceIdentifier",
                        stack,
                    )?);
                }
                "DBSnapshotArn" => {
                    obj.db_snapshot_arn =
                        Some(StringDeserializer::deserialize("DBSnapshotArn", stack)?);
                }
                "DBSnapshotIdentifier" => {
                    obj.db_snapshot_identifier = Some(StringDeserializer::deserialize(
                        "DBSnapshotIdentifier",
                        stack,
                    )?);
                }
                "DbiResourceId" => {
                    obj.dbi_resource_id =
                        Some(StringDeserializer::deserialize("DbiResourceId", stack)?);
                }
                "Encrypted" => {
                    obj.encrypted = Some(BooleanDeserializer::deserialize("Encrypted", stack)?);
                }
                "Engine" => {
                    obj.engine = Some(StringDeserializer::deserialize("Engine", stack)?);
                }
                "EngineVersion" => {
                    obj.engine_version =
                        Some(StringDeserializer::deserialize("EngineVersion", stack)?);
                }
                "IAMDatabaseAuthenticationEnabled" => {
                    obj.iam_database_authentication_enabled =
                        Some(BooleanDeserializer::deserialize(
                            "IAMDatabaseAuthenticationEnabled",
                            stack,
                        )?);
                }
                "InstanceCreateTime" => {
                    obj.instance_create_time = Some(TStampDeserializer::deserialize(
                        "InstanceCreateTime",
                        stack,
                    )?);
                }
                "Iops" => {
                    obj.iops = Some(IntegerOptionalDeserializer::deserialize("Iops", stack)?);
                }
                "KmsKeyId" => {
                    obj.kms_key_id = Some(StringDeserializer::deserialize("KmsKeyId", stack)?);
                }
                "LicenseModel" => {
                    obj.license_model =
                        Some(StringDeserializer::deserialize("LicenseModel", stack)?);
                }
                "MasterUsername" => {
                    obj.master_username =
                        Some(StringDeserializer::deserialize("MasterUsername", stack)?);
                }
                "OptionGroupName" => {
                    obj.option_group_name =
                        Some(StringDeserializer::deserialize("OptionGroupName", stack)?);
                }
                "PercentProgress" => {
                    obj.percent_progress =
                        Some(IntegerDeserializer::deserialize("PercentProgress", stack)?);
                }
                "Port" => {
                    obj.port = Some(IntegerDeserializer::deserialize("Port", stack)?);
                }
                "ProcessorFeatures" => {
                    obj.processor_features.get_or_insert(vec![]).extend(
                        ProcessorFeatureListDeserializer::deserialize("ProcessorFeatures", stack)?,
                    );
                }
                "SnapshotCreateTime" => {
                    obj.snapshot_create_time = Some(TStampDeserializer::deserialize(
                        "SnapshotCreateTime",
                        stack,
                    )?);
                }
                "SnapshotType" => {
                    obj.snapshot_type =
                        Some(StringDeserializer::deserialize("SnapshotType", stack)?);
                }
                "SourceDBSnapshotIdentifier" => {
                    obj.source_db_snapshot_identifier = Some(StringDeserializer::deserialize(
                        "SourceDBSnapshotIdentifier",
                        stack,
                    )?);
                }
                "SourceRegion" => {
                    obj.source_region =
                        Some(StringDeserializer::deserialize("SourceRegion", stack)?);
                }
                "Status" => {
                    obj.status = Some(StringDeserializer::deserialize("Status", stack)?);
                }
                "StorageType" => {
                    obj.storage_type = Some(StringDeserializer::deserialize("StorageType", stack)?);
                }
                "TagList" => {
                    obj.tag_list
                        .get_or_insert(vec![])
                        .extend(TagListDeserializer::deserialize("TagList", stack)?);
                }
                "TdeCredentialArn" => {
                    obj.tde_credential_arn =
                        Some(StringDeserializer::deserialize("TdeCredentialArn", stack)?);
                }
                "Timezone" => {
                    obj.timezone = Some(StringDeserializer::deserialize("Timezone", stack)?);
                }
                "VpcId" => {
                    obj.vpc_id = Some(StringDeserializer::deserialize("VpcId", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>Contains the name and values of a manual DB snapshot attribute</p> <p>Manual DB snapshot attributes are used to authorize other Amazon Web Services accounts to restore a manual DB snapshot. For more information, see the <code>ModifyDBSnapshotAttribute</code> API.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DBSnapshotAttribute {
    /// <p>The name of the manual DB snapshot attribute.</p> <p>The attribute named <code>restore</code> refers to the list of Amazon Web Services accounts that have permission to copy or restore the manual DB cluster snapshot. For more information, see the <code>ModifyDBSnapshotAttribute</code> API action.</p>
    pub attribute_name: Option<String>,
    /// <p>The value or values for the manual DB snapshot attribute.</p> <p>If the <code>AttributeName</code> field is set to <code>restore</code>, then this element returns a list of IDs of the Amazon Web Services accounts that are authorized to copy or restore the manual DB snapshot. If a value of <code>all</code> is in the list, then the manual DB snapshot is public and available for any Amazon Web Services account to copy or restore.</p>
    pub attribute_values: Option<Vec<String>>,
}

#[allow(dead_code)]
struct DBSnapshotAttributeDeserializer;
impl DBSnapshotAttributeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DBSnapshotAttribute, XmlParseError> {
        deserialize_elements::<_, DBSnapshotAttribute, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "AttributeName" => {
                    obj.attribute_name =
                        Some(StringDeserializer::deserialize("AttributeName", stack)?);
                }
                "AttributeValues" => {
                    obj.attribute_values.get_or_insert(vec![]).extend(
                        AttributeValueListDeserializer::deserialize("AttributeValues", stack)?,
                    );
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct DBSnapshotAttributeListDeserializer;
impl DBSnapshotAttributeListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<DBSnapshotAttribute>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "DBSnapshotAttribute" {
                obj.push(DBSnapshotAttributeDeserializer::deserialize(
                    "DBSnapshotAttribute",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Contains the results of a successful call to the <code>DescribeDBSnapshotAttributes</code> API action.</p> <p>Manual DB snapshot attributes are used to authorize other Amazon Web Services accounts to copy or restore a manual DB snapshot. For more information, see the <code>ModifyDBSnapshotAttribute</code> API action.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DBSnapshotAttributesResult {
    /// <p>The list of attributes and values for the manual DB snapshot.</p>
    pub db_snapshot_attributes: Option<Vec<DBSnapshotAttribute>>,
    /// <p>The identifier of the manual DB snapshot that the attributes apply to.</p>
    pub db_snapshot_identifier: Option<String>,
}

#[allow(dead_code)]
struct DBSnapshotAttributesResultDeserializer;
impl DBSnapshotAttributesResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DBSnapshotAttributesResult, XmlParseError> {
        deserialize_elements::<_, DBSnapshotAttributesResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DBSnapshotAttributes" => {
                        obj.db_snapshot_attributes.get_or_insert(vec![]).extend(
                            DBSnapshotAttributeListDeserializer::deserialize(
                                "DBSnapshotAttributes",
                                stack,
                            )?,
                        );
                    }
                    "DBSnapshotIdentifier" => {
                        obj.db_snapshot_identifier = Some(StringDeserializer::deserialize(
                            "DBSnapshotIdentifier",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct DBSnapshotListDeserializer;
impl DBSnapshotListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<DBSnapshot>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "DBSnapshot" {
                obj.push(DBSnapshotDeserializer::deserialize("DBSnapshot", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p> Contains the result of a successful invocation of the <code>DescribeDBSnapshots</code> action. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DBSnapshotMessage {
    /// <p> A list of <code>DBSnapshot</code> instances. </p>
    pub db_snapshots: Option<Vec<DBSnapshot>>,
    /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    pub marker: Option<String>,
}

#[allow(dead_code)]
struct DBSnapshotMessageDeserializer;
impl DBSnapshotMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DBSnapshotMessage, XmlParseError> {
        deserialize_elements::<_, DBSnapshotMessage, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "DBSnapshots" => {
                    obj.db_snapshots.get_or_insert(vec![]).extend(
                        DBSnapshotListDeserializer::deserialize("DBSnapshots", stack)?,
                    );
                }
                "Marker" => {
                    obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>Contains the details of an Amazon RDS DB subnet group. </p> <p>This data type is used as a response element in the <code>DescribeDBSubnetGroups</code> action. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DBSubnetGroup {
    /// <p>The Amazon Resource Name (ARN) for the DB subnet group.</p>
    pub db_subnet_group_arn: Option<String>,
    /// <p>Provides the description of the DB subnet group.</p>
    pub db_subnet_group_description: Option<String>,
    /// <p>The name of the DB subnet group.</p>
    pub db_subnet_group_name: Option<String>,
    /// <p>Provides the status of the DB subnet group.</p>
    pub subnet_group_status: Option<String>,
    /// <p> Contains a list of <code>Subnet</code> elements. </p>
    pub subnets: Option<Vec<Subnet>>,
    /// <p>Provides the VpcId of the DB subnet group.</p>
    pub vpc_id: Option<String>,
}

#[allow(dead_code)]
struct DBSubnetGroupDeserializer;
impl DBSubnetGroupDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DBSubnetGroup, XmlParseError> {
        deserialize_elements::<_, DBSubnetGroup, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "DBSubnetGroupArn" => {
                    obj.db_subnet_group_arn =
                        Some(StringDeserializer::deserialize("DBSubnetGroupArn", stack)?);
                }
                "DBSubnetGroupDescription" => {
                    obj.db_subnet_group_description = Some(StringDeserializer::deserialize(
                        "DBSubnetGroupDescription",
                        stack,
                    )?);
                }
                "DBSubnetGroupName" => {
                    obj.db_subnet_group_name =
                        Some(StringDeserializer::deserialize("DBSubnetGroupName", stack)?);
                }
                "SubnetGroupStatus" => {
                    obj.subnet_group_status =
                        Some(StringDeserializer::deserialize("SubnetGroupStatus", stack)?);
                }
                "Subnets" => {
                    obj.subnets
                        .get_or_insert(vec![])
                        .extend(SubnetListDeserializer::deserialize("Subnets", stack)?);
                }
                "VpcId" => {
                    obj.vpc_id = Some(StringDeserializer::deserialize("VpcId", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p> Contains the result of a successful invocation of the <code>DescribeDBSubnetGroups</code> action. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DBSubnetGroupMessage {
    /// <p> A list of <code>DBSubnetGroup</code> instances. </p>
    pub db_subnet_groups: Option<Vec<DBSubnetGroup>>,
    /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    pub marker: Option<String>,
}

#[allow(dead_code)]
struct DBSubnetGroupMessageDeserializer;
impl DBSubnetGroupMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DBSubnetGroupMessage, XmlParseError> {
        deserialize_elements::<_, DBSubnetGroupMessage, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "DBSubnetGroups" => {
                    obj.db_subnet_groups.get_or_insert(vec![]).extend(
                        DBSubnetGroupsDeserializer::deserialize("DBSubnetGroups", stack)?,
                    );
                }
                "Marker" => {
                    obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct DBSubnetGroupsDeserializer;
impl DBSubnetGroupsDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<DBSubnetGroup>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "DBSubnetGroup" {
                obj.push(DBSubnetGroupDeserializer::deserialize(
                    "DBSubnetGroup",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteCustomAvailabilityZoneMessage {
    /// <p>The custom AZ identifier.</p>
    pub custom_availability_zone_id: String,
}

/// Serialize `DeleteCustomAvailabilityZoneMessage` contents to a `SignedRequest`.
struct DeleteCustomAvailabilityZoneMessageSerializer;
impl DeleteCustomAvailabilityZoneMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteCustomAvailabilityZoneMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "CustomAvailabilityZoneId"),
            &obj.custom_availability_zone_id,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeleteCustomAvailabilityZoneResult {
    pub custom_availability_zone: Option<CustomAvailabilityZone>,
}

#[allow(dead_code)]
struct DeleteCustomAvailabilityZoneResultDeserializer;
impl DeleteCustomAvailabilityZoneResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeleteCustomAvailabilityZoneResult, XmlParseError> {
        deserialize_elements::<_, DeleteCustomAvailabilityZoneResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "CustomAvailabilityZone" => {
                        obj.custom_availability_zone =
                            Some(CustomAvailabilityZoneDeserializer::deserialize(
                                "CustomAvailabilityZone",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteDBClusterEndpointMessage {
    /// <p>The identifier associated with the custom endpoint. This parameter is stored as a lowercase string.</p>
    pub db_cluster_endpoint_identifier: String,
}

/// Serialize `DeleteDBClusterEndpointMessage` contents to a `SignedRequest`.
struct DeleteDBClusterEndpointMessageSerializer;
impl DeleteDBClusterEndpointMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteDBClusterEndpointMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "DBClusterEndpointIdentifier"),
            &obj.db_cluster_endpoint_identifier,
        );
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteDBClusterMessage {
    /// <p><p>The DB cluster identifier for the DB cluster to be deleted. This parameter isn&#39;t case-sensitive.</p> <p>Constraints:</p> <ul> <li> <p>Must match an existing DBClusterIdentifier.</p> </li> </ul></p>
    pub db_cluster_identifier: String,
    /// <p><p> The DB cluster snapshot identifier of the new DB cluster snapshot created when <code>SkipFinalSnapshot</code> is disabled. </p> <note> <p> Specifying this parameter and also skipping the creation of a final DB cluster snapshot with the <code>SkipFinalShapshot</code> parameter results in an error.</p> </note> <p>Constraints:</p> <ul> <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li> <li> <p>First character must be a letter</p> </li> <li> <p>Can&#39;t end with a hyphen or contain two consecutive hyphens</p> </li> </ul></p>
    pub final_db_snapshot_identifier: Option<String>,
    /// <p><p>A value that indicates whether to skip the creation of a final DB cluster snapshot before the DB cluster is deleted. If skip is specified, no DB cluster snapshot is created. If skip isn&#39;t specified, a DB cluster snapshot is created before the DB cluster is deleted. By default, skip isn&#39;t specified, and the DB cluster snapshot is created. By default, this parameter is disabled.</p> <note> <p>You must specify a <code>FinalDBSnapshotIdentifier</code> parameter if <code>SkipFinalSnapshot</code> is disabled.</p> </note></p>
    pub skip_final_snapshot: Option<bool>,
}

/// Serialize `DeleteDBClusterMessage` contents to a `SignedRequest`.
struct DeleteDBClusterMessageSerializer;
impl DeleteDBClusterMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteDBClusterMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "DBClusterIdentifier"),
            &obj.db_cluster_identifier,
        );
        if let Some(ref field_value) = obj.final_db_snapshot_identifier {
            params.put(
                &format!("{}{}", prefix, "FinalDBSnapshotIdentifier"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.skip_final_snapshot {
            params.put(&format!("{}{}", prefix, "SkipFinalSnapshot"), &field_value);
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteDBClusterParameterGroupMessage {
    /// <p><p>The name of the DB cluster parameter group.</p> <p>Constraints:</p> <ul> <li> <p>Must be the name of an existing DB cluster parameter group.</p> </li> <li> <p>You can&#39;t delete a default DB cluster parameter group.</p> </li> <li> <p>Can&#39;t be associated with any DB clusters.</p> </li> </ul></p>
    pub db_cluster_parameter_group_name: String,
}

/// Serialize `DeleteDBClusterParameterGroupMessage` contents to a `SignedRequest`.
struct DeleteDBClusterParameterGroupMessageSerializer;
impl DeleteDBClusterParameterGroupMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteDBClusterParameterGroupMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "DBClusterParameterGroupName"),
            &obj.db_cluster_parameter_group_name,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeleteDBClusterResult {
    pub db_cluster: Option<DBCluster>,
}

#[allow(dead_code)]
struct DeleteDBClusterResultDeserializer;
impl DeleteDBClusterResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeleteDBClusterResult, XmlParseError> {
        deserialize_elements::<_, DeleteDBClusterResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "DBCluster" => {
                    obj.db_cluster = Some(DBClusterDeserializer::deserialize("DBCluster", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteDBClusterSnapshotMessage {
    /// <p>The identifier of the DB cluster snapshot to delete.</p> <p>Constraints: Must be the name of an existing DB cluster snapshot in the <code>available</code> state.</p>
    pub db_cluster_snapshot_identifier: String,
}

/// Serialize `DeleteDBClusterSnapshotMessage` contents to a `SignedRequest`.
struct DeleteDBClusterSnapshotMessageSerializer;
impl DeleteDBClusterSnapshotMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteDBClusterSnapshotMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "DBClusterSnapshotIdentifier"),
            &obj.db_cluster_snapshot_identifier,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeleteDBClusterSnapshotResult {
    pub db_cluster_snapshot: Option<DBClusterSnapshot>,
}

#[allow(dead_code)]
struct DeleteDBClusterSnapshotResultDeserializer;
impl DeleteDBClusterSnapshotResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeleteDBClusterSnapshotResult, XmlParseError> {
        deserialize_elements::<_, DeleteDBClusterSnapshotResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DBClusterSnapshot" => {
                        obj.db_cluster_snapshot = Some(DBClusterSnapshotDeserializer::deserialize(
                            "DBClusterSnapshot",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Parameter input for the <code>DeleteDBInstanceAutomatedBackup</code> operation.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteDBInstanceAutomatedBackupMessage {
    /// <p>The Amazon Resource Name (ARN) of the automated backups to delete, for example, <code>arn:aws:rds:us-east-1:123456789012:auto-backup:ab-L2IJCEXJP7XQ7HOJ4SIEXAMPLE</code>.</p>
    pub db_instance_automated_backups_arn: Option<String>,
    /// <p>The identifier for the source DB instance, which can't be changed and which is unique to an Amazon Web Services Region.</p>
    pub dbi_resource_id: Option<String>,
}

/// Serialize `DeleteDBInstanceAutomatedBackupMessage` contents to a `SignedRequest`.
struct DeleteDBInstanceAutomatedBackupMessageSerializer;
impl DeleteDBInstanceAutomatedBackupMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteDBInstanceAutomatedBackupMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.db_instance_automated_backups_arn {
            params.put(
                &format!("{}{}", prefix, "DBInstanceAutomatedBackupsArn"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.dbi_resource_id {
            params.put(&format!("{}{}", prefix, "DbiResourceId"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeleteDBInstanceAutomatedBackupResult {
    pub db_instance_automated_backup: Option<DBInstanceAutomatedBackup>,
}

#[allow(dead_code)]
struct DeleteDBInstanceAutomatedBackupResultDeserializer;
impl DeleteDBInstanceAutomatedBackupResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeleteDBInstanceAutomatedBackupResult, XmlParseError> {
        deserialize_elements::<_, DeleteDBInstanceAutomatedBackupResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DBInstanceAutomatedBackup" => {
                        obj.db_instance_automated_backup =
                            Some(DBInstanceAutomatedBackupDeserializer::deserialize(
                                "DBInstanceAutomatedBackup",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteDBInstanceMessage {
    /// <p><p>The DB instance identifier for the DB instance to be deleted. This parameter isn&#39;t case-sensitive.</p> <p>Constraints:</p> <ul> <li> <p>Must match the name of an existing DB instance.</p> </li> </ul></p>
    pub db_instance_identifier: String,
    /// <p>A value that indicates whether to remove automated backups immediately after the DB instance is deleted. This parameter isn't case-sensitive. The default is to remove automated backups immediately after the DB instance is deleted.</p>
    pub delete_automated_backups: Option<bool>,
    /// <p><p> The <code>DBSnapshotIdentifier</code> of the new <code>DBSnapshot</code> created when the <code>SkipFinalSnapshot</code> parameter is disabled. </p> <note> <p>Specifying this parameter and also specifying to skip final DB snapshot creation in SkipFinalShapshot results in an error.</p> </note> <p>Constraints:</p> <ul> <li> <p>Must be 1 to 255 letters or numbers.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Can&#39;t end with a hyphen or contain two consecutive hyphens.</p> </li> <li> <p>Can&#39;t be specified when deleting a read replica.</p> </li> </ul></p>
    pub final_db_snapshot_identifier: Option<String>,
    /// <p><p>A value that indicates whether to skip the creation of a final DB snapshot before the DB instance is deleted. If skip is specified, no DB snapshot is created. If skip isn&#39;t specified, a DB snapshot is created before the DB instance is deleted. By default, skip isn&#39;t specified, and the DB snapshot is created.</p> <p>When a DB instance is in a failure state and has a status of &#39;failed&#39;, &#39;incompatible-restore&#39;, or &#39;incompatible-network&#39;, it can only be deleted when skip is specified.</p> <p>Specify skip when deleting a read replica.</p> <note> <p>The FinalDBSnapshotIdentifier parameter must be specified if skip isn&#39;t specified.</p> </note></p>
    pub skip_final_snapshot: Option<bool>,
}

/// Serialize `DeleteDBInstanceMessage` contents to a `SignedRequest`.
struct DeleteDBInstanceMessageSerializer;
impl DeleteDBInstanceMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteDBInstanceMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "DBInstanceIdentifier"),
            &obj.db_instance_identifier,
        );
        if let Some(ref field_value) = obj.delete_automated_backups {
            params.put(
                &format!("{}{}", prefix, "DeleteAutomatedBackups"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.final_db_snapshot_identifier {
            params.put(
                &format!("{}{}", prefix, "FinalDBSnapshotIdentifier"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.skip_final_snapshot {
            params.put(&format!("{}{}", prefix, "SkipFinalSnapshot"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeleteDBInstanceResult {
    pub db_instance: Option<DBInstance>,
}

#[allow(dead_code)]
struct DeleteDBInstanceResultDeserializer;
impl DeleteDBInstanceResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeleteDBInstanceResult, XmlParseError> {
        deserialize_elements::<_, DeleteDBInstanceResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "DBInstance" => {
                    obj.db_instance =
                        Some(DBInstanceDeserializer::deserialize("DBInstance", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteDBParameterGroupMessage {
    /// <p><p>The name of the DB parameter group.</p> <p>Constraints:</p> <ul> <li> <p>Must be the name of an existing DB parameter group</p> </li> <li> <p>You can&#39;t delete a default DB parameter group</p> </li> <li> <p>Can&#39;t be associated with any DB instances</p> </li> </ul></p>
    pub db_parameter_group_name: String,
}

/// Serialize `DeleteDBParameterGroupMessage` contents to a `SignedRequest`.
struct DeleteDBParameterGroupMessageSerializer;
impl DeleteDBParameterGroupMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteDBParameterGroupMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "DBParameterGroupName"),
            &obj.db_parameter_group_name,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteDBProxyEndpointRequest {
    /// <p>The name of the DB proxy endpoint to delete.</p>
    pub db_proxy_endpoint_name: String,
}

/// Serialize `DeleteDBProxyEndpointRequest` contents to a `SignedRequest`.
struct DeleteDBProxyEndpointRequestSerializer;
impl DeleteDBProxyEndpointRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteDBProxyEndpointRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "DBProxyEndpointName"),
            &obj.db_proxy_endpoint_name,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeleteDBProxyEndpointResponse {
    /// <p>The data structure representing the details of the DB proxy endpoint that you delete.</p>
    pub db_proxy_endpoint: Option<DBProxyEndpoint>,
}

#[allow(dead_code)]
struct DeleteDBProxyEndpointResponseDeserializer;
impl DeleteDBProxyEndpointResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeleteDBProxyEndpointResponse, XmlParseError> {
        deserialize_elements::<_, DeleteDBProxyEndpointResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DBProxyEndpoint" => {
                        obj.db_proxy_endpoint = Some(DBProxyEndpointDeserializer::deserialize(
                            "DBProxyEndpoint",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteDBProxyRequest {
    /// <p>The name of the DB proxy to delete.</p>
    pub db_proxy_name: String,
}

/// Serialize `DeleteDBProxyRequest` contents to a `SignedRequest`.
struct DeleteDBProxyRequestSerializer;
impl DeleteDBProxyRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteDBProxyRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "DBProxyName"), &obj.db_proxy_name);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeleteDBProxyResponse {
    /// <p>The data structure representing the details of the DB proxy that you delete.</p>
    pub db_proxy: Option<DBProxy>,
}

#[allow(dead_code)]
struct DeleteDBProxyResponseDeserializer;
impl DeleteDBProxyResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeleteDBProxyResponse, XmlParseError> {
        deserialize_elements::<_, DeleteDBProxyResponse, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "DBProxy" => {
                    obj.db_proxy = Some(DBProxyDeserializer::deserialize("DBProxy", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteDBSecurityGroupMessage {
    /// <p><p>The name of the DB security group to delete.</p> <note> <p>You can&#39;t delete the default DB security group.</p> </note> <p>Constraints:</p> <ul> <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li> <li> <p>First character must be a letter</p> </li> <li> <p>Can&#39;t end with a hyphen or contain two consecutive hyphens</p> </li> <li> <p>Must not be &quot;Default&quot;</p> </li> </ul></p>
    pub db_security_group_name: String,
}

/// Serialize `DeleteDBSecurityGroupMessage` contents to a `SignedRequest`.
struct DeleteDBSecurityGroupMessageSerializer;
impl DeleteDBSecurityGroupMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteDBSecurityGroupMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "DBSecurityGroupName"),
            &obj.db_security_group_name,
        );
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteDBSnapshotMessage {
    /// <p>The DB snapshot identifier.</p> <p>Constraints: Must be the name of an existing DB snapshot in the <code>available</code> state.</p>
    pub db_snapshot_identifier: String,
}

/// Serialize `DeleteDBSnapshotMessage` contents to a `SignedRequest`.
struct DeleteDBSnapshotMessageSerializer;
impl DeleteDBSnapshotMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteDBSnapshotMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "DBSnapshotIdentifier"),
            &obj.db_snapshot_identifier,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeleteDBSnapshotResult {
    pub db_snapshot: Option<DBSnapshot>,
}

#[allow(dead_code)]
struct DeleteDBSnapshotResultDeserializer;
impl DeleteDBSnapshotResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeleteDBSnapshotResult, XmlParseError> {
        deserialize_elements::<_, DeleteDBSnapshotResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "DBSnapshot" => {
                    obj.db_snapshot =
                        Some(DBSnapshotDeserializer::deserialize("DBSnapshot", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteDBSubnetGroupMessage {
    /// <p>The name of the database subnet group to delete.</p> <note> <p>You can't delete the default subnet group.</p> </note> <p>Constraints:</p> <p>Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.</p> <p>Example: <code>mySubnetgroup</code> </p>
    pub db_subnet_group_name: String,
}

/// Serialize `DeleteDBSubnetGroupMessage` contents to a `SignedRequest`.
struct DeleteDBSubnetGroupMessageSerializer;
impl DeleteDBSubnetGroupMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteDBSubnetGroupMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "DBSubnetGroupName"),
            &obj.db_subnet_group_name,
        );
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteEventSubscriptionMessage {
    /// <p>The name of the RDS event notification subscription you want to delete.</p>
    pub subscription_name: String,
}

/// Serialize `DeleteEventSubscriptionMessage` contents to a `SignedRequest`.
struct DeleteEventSubscriptionMessageSerializer;
impl DeleteEventSubscriptionMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteEventSubscriptionMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "SubscriptionName"),
            &obj.subscription_name,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeleteEventSubscriptionResult {
    pub event_subscription: Option<EventSubscription>,
}

#[allow(dead_code)]
struct DeleteEventSubscriptionResultDeserializer;
impl DeleteEventSubscriptionResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeleteEventSubscriptionResult, XmlParseError> {
        deserialize_elements::<_, DeleteEventSubscriptionResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "EventSubscription" => {
                        obj.event_subscription = Some(EventSubscriptionDeserializer::deserialize(
                            "EventSubscription",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteGlobalClusterMessage {
    /// <p> The cluster identifier of the global database cluster being deleted. </p>
    pub global_cluster_identifier: String,
}

/// Serialize `DeleteGlobalClusterMessage` contents to a `SignedRequest`.
struct DeleteGlobalClusterMessageSerializer;
impl DeleteGlobalClusterMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteGlobalClusterMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "GlobalClusterIdentifier"),
            &obj.global_cluster_identifier,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeleteGlobalClusterResult {
    pub global_cluster: Option<GlobalCluster>,
}

#[allow(dead_code)]
struct DeleteGlobalClusterResultDeserializer;
impl DeleteGlobalClusterResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeleteGlobalClusterResult, XmlParseError> {
        deserialize_elements::<_, DeleteGlobalClusterResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "GlobalCluster" => {
                        obj.global_cluster = Some(GlobalClusterDeserializer::deserialize(
                            "GlobalCluster",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteInstallationMediaMessage {
    /// <p>The installation medium ID.</p>
    pub installation_media_id: String,
}

/// Serialize `DeleteInstallationMediaMessage` contents to a `SignedRequest`.
struct DeleteInstallationMediaMessageSerializer;
impl DeleteInstallationMediaMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteInstallationMediaMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "InstallationMediaId"),
            &obj.installation_media_id,
        );
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteOptionGroupMessage {
    /// <p><p>The name of the option group to be deleted.</p> <note> <p>You can&#39;t delete default option groups.</p> </note></p>
    pub option_group_name: String,
}

/// Serialize `DeleteOptionGroupMessage` contents to a `SignedRequest`.
struct DeleteOptionGroupMessageSerializer;
impl DeleteOptionGroupMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteOptionGroupMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "OptionGroupName"),
            &obj.option_group_name,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeregisterDBProxyTargetsRequest {
    /// <p>One or more DB cluster identifiers.</p>
    pub db_cluster_identifiers: Option<Vec<String>>,
    /// <p>One or more DB instance identifiers.</p>
    pub db_instance_identifiers: Option<Vec<String>>,
    /// <p>The identifier of the <code>DBProxy</code> that is associated with the <code>DBProxyTargetGroup</code>.</p>
    pub db_proxy_name: String,
    /// <p>The identifier of the <code>DBProxyTargetGroup</code>.</p>
    pub target_group_name: Option<String>,
}

/// Serialize `DeregisterDBProxyTargetsRequest` contents to a `SignedRequest`.
struct DeregisterDBProxyTargetsRequestSerializer;
impl DeregisterDBProxyTargetsRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeregisterDBProxyTargetsRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.db_cluster_identifiers {
            StringListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "DBClusterIdentifiers"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.db_instance_identifiers {
            StringListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "DBInstanceIdentifiers"),
                field_value,
            );
        }
        params.put(&format!("{}{}", prefix, "DBProxyName"), &obj.db_proxy_name);
        if let Some(ref field_value) = obj.target_group_name {
            params.put(&format!("{}{}", prefix, "TargetGroupName"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeregisterDBProxyTargetsResponse {}

#[allow(dead_code)]
struct DeregisterDBProxyTargetsResponseDeserializer;
impl DeregisterDBProxyTargetsResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeregisterDBProxyTargetsResponse, XmlParseError> {
        xml_util::start_element(tag_name, stack)?;

        let obj = DeregisterDBProxyTargetsResponse::default();

        xml_util::end_element(tag_name, stack)?;

        Ok(obj)
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeAccountAttributesMessage {}

/// Serialize `DescribeAccountAttributesMessage` contents to a `SignedRequest`.
struct DescribeAccountAttributesMessageSerializer;
impl DescribeAccountAttributesMessageSerializer {
    fn serialize(_params: &mut Params, name: &str, _obj: &DescribeAccountAttributesMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeCertificatesMessage {
    /// <p><p>The user-supplied certificate identifier. If this parameter is specified, information for only the identified certificate is returned. This parameter isn&#39;t case-sensitive.</p> <p>Constraints:</p> <ul> <li> <p>Must match an existing CertificateIdentifier.</p> </li> </ul></p>
    pub certificate_identifier: Option<String>,
    /// <p>This parameter isn't currently supported.</p>
    pub filters: Option<Vec<Filter>>,
    /// <p> An optional pagination token provided by a previous <code>DescribeCertificates</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    pub marker: Option<String>,
    /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: Option<i64>,
}

/// Serialize `DescribeCertificatesMessage` contents to a `SignedRequest`.
struct DescribeCertificatesMessageSerializer;
impl DescribeCertificatesMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeCertificatesMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.certificate_identifier {
            params.put(
                &format!("{}{}", prefix, "CertificateIdentifier"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeCustomAvailabilityZonesMessage {
    /// <p>The custom AZ identifier. If this parameter is specified, information from only the specific custom AZ is returned.</p>
    pub custom_availability_zone_id: Option<String>,
    /// <p>A filter that specifies one or more custom AZs to describe.</p>
    pub filters: Option<Vec<Filter>>,
    /// <p>An optional pagination token provided by a previous <code>DescribeCustomAvailabilityZones</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub marker: Option<String>,
    /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: Option<i64>,
}

/// Serialize `DescribeCustomAvailabilityZonesMessage` contents to a `SignedRequest`.
struct DescribeCustomAvailabilityZonesMessageSerializer;
impl DescribeCustomAvailabilityZonesMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeCustomAvailabilityZonesMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.custom_availability_zone_id {
            params.put(
                &format!("{}{}", prefix, "CustomAvailabilityZoneId"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeDBClusterBacktracksMessage {
    /// <p>If specified, this value is the backtrack identifier of the backtrack to be described.</p> <p>Constraints:</p> <ul> <li> <p>Must contain a valid universally unique identifier (UUID). For more information about UUIDs, see <a href="http://www.ietf.org/rfc/rfc4122.txt">A Universally Unique Identifier (UUID) URN Namespace</a>.</p> </li> </ul> <p>Example: <code>123e4567-e89b-12d3-a456-426655440000</code> </p>
    pub backtrack_identifier: Option<String>,
    /// <p>The DB cluster identifier of the DB cluster to be described. This parameter is stored as a lowercase string.</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li> </ul> <p>Example: <code>my-cluster1</code> </p>
    pub db_cluster_identifier: String,
    /// <p><p>A filter that specifies one or more DB clusters to describe. Supported filters include the following:</p> <ul> <li> <p> <code>db-cluster-backtrack-id</code> - Accepts backtrack identifiers. The results list includes information about only the backtracks identified by these identifiers.</p> </li> <li> <p> <code>db-cluster-backtrack-status</code> - Accepts any of the following backtrack status values:</p> <ul> <li> <p> <code>applying</code> </p> </li> <li> <p> <code>completed</code> </p> </li> <li> <p> <code>failed</code> </p> </li> <li> <p> <code>pending</code> </p> </li> </ul> <p>The results list includes information about only the backtracks identified by these values.</p> </li> </ul></p>
    pub filters: Option<Vec<Filter>>,
    /// <p> An optional pagination token provided by a previous <code>DescribeDBClusterBacktracks</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    pub marker: Option<String>,
    /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: Option<i64>,
}

/// Serialize `DescribeDBClusterBacktracksMessage` contents to a `SignedRequest`.
struct DescribeDBClusterBacktracksMessageSerializer;
impl DescribeDBClusterBacktracksMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeDBClusterBacktracksMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.backtrack_identifier {
            params.put(
                &format!("{}{}", prefix, "BacktrackIdentifier"),
                &field_value,
            );
        }
        params.put(
            &format!("{}{}", prefix, "DBClusterIdentifier"),
            &obj.db_cluster_identifier,
        );
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeDBClusterEndpointsMessage {
    /// <p>The identifier of the endpoint to describe. This parameter is stored as a lowercase string.</p>
    pub db_cluster_endpoint_identifier: Option<String>,
    /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase string.</p>
    pub db_cluster_identifier: Option<String>,
    /// <p>A set of name-value pairs that define which endpoints to include in the output. The filters are specified as name-value pairs, in the format <code>Name=<i>endpoint_type</i>,Values=<i>endpoint_type1</i>,<i>endpoint_type2</i>,...</code>. <code>Name</code> can be one of: <code>db-cluster-endpoint-type</code>, <code>db-cluster-endpoint-custom-type</code>, <code>db-cluster-endpoint-id</code>, <code>db-cluster-endpoint-status</code>. <code>Values</code> for the <code> db-cluster-endpoint-type</code> filter can be one or more of: <code>reader</code>, <code>writer</code>, <code>custom</code>. <code>Values</code> for the <code>db-cluster-endpoint-custom-type</code> filter can be one or more of: <code>reader</code>, <code>any</code>. <code>Values</code> for the <code>db-cluster-endpoint-status</code> filter can be one or more of: <code>available</code>, <code>creating</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>. </p>
    pub filters: Option<Vec<Filter>>,
    /// <p> An optional pagination token provided by a previous <code>DescribeDBClusterEndpoints</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    pub marker: Option<String>,
    /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: Option<i64>,
}

/// Serialize `DescribeDBClusterEndpointsMessage` contents to a `SignedRequest`.
struct DescribeDBClusterEndpointsMessageSerializer;
impl DescribeDBClusterEndpointsMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeDBClusterEndpointsMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.db_cluster_endpoint_identifier {
            params.put(
                &format!("{}{}", prefix, "DBClusterEndpointIdentifier"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.db_cluster_identifier {
            params.put(
                &format!("{}{}", prefix, "DBClusterIdentifier"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeDBClusterParameterGroupsMessage {
    /// <p><p>The name of a specific DB cluster parameter group to return details for.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p> </li> </ul></p>
    pub db_cluster_parameter_group_name: Option<String>,
    /// <p>This parameter isn't currently supported.</p>
    pub filters: Option<Vec<Filter>>,
    /// <p> An optional pagination token provided by a previous <code>DescribeDBClusterParameterGroups</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    pub marker: Option<String>,
    /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: Option<i64>,
}

/// Serialize `DescribeDBClusterParameterGroupsMessage` contents to a `SignedRequest`.
struct DescribeDBClusterParameterGroupsMessageSerializer;
impl DescribeDBClusterParameterGroupsMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeDBClusterParameterGroupsMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.db_cluster_parameter_group_name {
            params.put(
                &format!("{}{}", prefix, "DBClusterParameterGroupName"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeDBClusterParametersMessage {
    /// <p><p>The name of a specific DB cluster parameter group to return parameter details for.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p> </li> </ul></p>
    pub db_cluster_parameter_group_name: String,
    /// <p>This parameter isn't currently supported.</p>
    pub filters: Option<Vec<Filter>>,
    /// <p> An optional pagination token provided by a previous <code>DescribeDBClusterParameters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    pub marker: Option<String>,
    /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: Option<i64>,
    /// <p> A value that indicates to return only parameters for a specific source. Parameter sources can be <code>engine</code>, <code>service</code>, or <code>customer</code>. </p>
    pub source: Option<String>,
}

/// Serialize `DescribeDBClusterParametersMessage` contents to a `SignedRequest`.
struct DescribeDBClusterParametersMessageSerializer;
impl DescribeDBClusterParametersMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeDBClusterParametersMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "DBClusterParameterGroupName"),
            &obj.db_cluster_parameter_group_name,
        );
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
        if let Some(ref field_value) = obj.source {
            params.put(&format!("{}{}", prefix, "Source"), &field_value);
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeDBClusterSnapshotAttributesMessage {
    /// <p>The identifier for the DB cluster snapshot to describe the attributes for.</p>
    pub db_cluster_snapshot_identifier: String,
}

/// Serialize `DescribeDBClusterSnapshotAttributesMessage` contents to a `SignedRequest`.
struct DescribeDBClusterSnapshotAttributesMessageSerializer;
impl DescribeDBClusterSnapshotAttributesMessageSerializer {
    fn serialize(
        params: &mut Params,
        name: &str,
        obj: &DescribeDBClusterSnapshotAttributesMessage,
    ) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "DBClusterSnapshotIdentifier"),
            &obj.db_cluster_snapshot_identifier,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeDBClusterSnapshotAttributesResult {
    pub db_cluster_snapshot_attributes_result: Option<DBClusterSnapshotAttributesResult>,
}

#[allow(dead_code)]
struct DescribeDBClusterSnapshotAttributesResultDeserializer;
impl DescribeDBClusterSnapshotAttributesResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeDBClusterSnapshotAttributesResult, XmlParseError> {
        deserialize_elements::<_, DescribeDBClusterSnapshotAttributesResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DBClusterSnapshotAttributesResult" => {
                        obj.db_cluster_snapshot_attributes_result =
                            Some(DBClusterSnapshotAttributesResultDeserializer::deserialize(
                                "DBClusterSnapshotAttributesResult",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeDBClusterSnapshotsMessage {
    /// <p><p>The ID of the DB cluster to retrieve the list of DB cluster snapshots for. This parameter can&#39;t be used in conjunction with the <code>DBClusterSnapshotIdentifier</code> parameter. This parameter isn&#39;t case-sensitive. </p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match the identifier of an existing DBCluster.</p> </li> </ul></p>
    pub db_cluster_identifier: Option<String>,
    /// <p><p>A specific DB cluster snapshot identifier to describe. This parameter can&#39;t be used in conjunction with the <code>DBClusterIdentifier</code> parameter. This value is stored as a lowercase string. </p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match the identifier of an existing DBClusterSnapshot.</p> </li> <li> <p>If this identifier is for an automated snapshot, the <code>SnapshotType</code> parameter must also be specified.</p> </li> </ul></p>
    pub db_cluster_snapshot_identifier: Option<String>,
    /// <p><p>A filter that specifies one or more DB cluster snapshots to describe.</p> <p>Supported filters:</p> <ul> <li> <p> <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon Resource Names (ARNs).</p> </li> <li> <p> <code>db-cluster-snapshot-id</code> - Accepts DB cluster snapshot identifiers.</p> </li> <li> <p> <code>snapshot-type</code> - Accepts types of DB cluster snapshots.</p> </li> <li> <p> <code>engine</code> - Accepts names of database engines.</p> </li> </ul></p>
    pub filters: Option<Vec<Filter>>,
    /// <p>A value that indicates whether to include manual DB cluster snapshots that are public and can be copied or restored by any Amazon Web Services account. By default, the public snapshots are not included.</p> <p>You can share a manual DB cluster snapshot as public by using the <a>ModifyDBClusterSnapshotAttribute</a> API action.</p>
    pub include_public: Option<bool>,
    /// <p>A value that indicates whether to include shared manual DB cluster snapshots from other Amazon Web Services accounts that this Amazon Web Services account has been given permission to copy or restore. By default, these snapshots are not included.</p> <p>You can give an Amazon Web Services account permission to restore a manual DB cluster snapshot from another Amazon Web Services account by the <code>ModifyDBClusterSnapshotAttribute</code> API action.</p>
    pub include_shared: Option<bool>,
    /// <p>An optional pagination token provided by a previous <code>DescribeDBClusterSnapshots</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    pub marker: Option<String>,
    /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: Option<i64>,
    /// <p>The type of DB cluster snapshots to be returned. You can specify one of the following values:</p> <ul> <li> <p> <code>automated</code> - Return all DB cluster snapshots that have been automatically taken by Amazon RDS for my Amazon Web Services account.</p> </li> <li> <p> <code>manual</code> - Return all DB cluster snapshots that have been taken by my Amazon Web Services account.</p> </li> <li> <p> <code>shared</code> - Return all manual DB cluster snapshots that have been shared to my Amazon Web Services account.</p> </li> <li> <p> <code>public</code> - Return all DB cluster snapshots that have been marked as public.</p> </li> </ul> <p>If you don't specify a <code>SnapshotType</code> value, then both automated and manual DB cluster snapshots are returned. You can include shared DB cluster snapshots with these results by enabling the <code>IncludeShared</code> parameter. You can include public DB cluster snapshots with these results by enabling the <code>IncludePublic</code> parameter.</p> <p>The <code>IncludeShared</code> and <code>IncludePublic</code> parameters don't apply for <code>SnapshotType</code> values of <code>manual</code> or <code>automated</code>. The <code>IncludePublic</code> parameter doesn't apply when <code>SnapshotType</code> is set to <code>shared</code>. The <code>IncludeShared</code> parameter doesn't apply when <code>SnapshotType</code> is set to <code>public</code>.</p>
    pub snapshot_type: Option<String>,
}

/// Serialize `DescribeDBClusterSnapshotsMessage` contents to a `SignedRequest`.
struct DescribeDBClusterSnapshotsMessageSerializer;
impl DescribeDBClusterSnapshotsMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeDBClusterSnapshotsMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.db_cluster_identifier {
            params.put(
                &format!("{}{}", prefix, "DBClusterIdentifier"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.db_cluster_snapshot_identifier {
            params.put(
                &format!("{}{}", prefix, "DBClusterSnapshotIdentifier"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.include_public {
            params.put(&format!("{}{}", prefix, "IncludePublic"), &field_value);
        }
        if let Some(ref field_value) = obj.include_shared {
            params.put(&format!("{}{}", prefix, "IncludeShared"), &field_value);
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
        if let Some(ref field_value) = obj.snapshot_type {
            params.put(&format!("{}{}", prefix, "SnapshotType"), &field_value);
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeDBClustersMessage {
    /// <p><p>The user-supplied DB cluster identifier. If this parameter is specified, information from only the specific DB cluster is returned. This parameter isn&#39;t case-sensitive.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match an existing DBClusterIdentifier.</p> </li> </ul></p>
    pub db_cluster_identifier: Option<String>,
    /// <p><p>A filter that specifies one or more DB clusters to describe.</p> <p>Supported filters:</p> <ul> <li> <p> <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon Resource Names (ARNs). The results list will only include information about the DB clusters identified by these ARNs.</p> </li> </ul></p>
    pub filters: Option<Vec<Filter>>,
    /// <p>Optional Boolean parameter that specifies whether the output includes information about clusters shared from other Amazon Web Services accounts.</p>
    pub include_shared: Option<bool>,
    /// <p>An optional pagination token provided by a previous <code>DescribeDBClusters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    pub marker: Option<String>,
    /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: Option<i64>,
}

/// Serialize `DescribeDBClustersMessage` contents to a `SignedRequest`.
struct DescribeDBClustersMessageSerializer;
impl DescribeDBClustersMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeDBClustersMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.db_cluster_identifier {
            params.put(
                &format!("{}{}", prefix, "DBClusterIdentifier"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.include_shared {
            params.put(&format!("{}{}", prefix, "IncludeShared"), &field_value);
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeDBEngineVersionsMessage {
    /// <p><p>The name of a specific DB parameter group family to return details for.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match an existing DBParameterGroupFamily.</p> </li> </ul></p>
    pub db_parameter_group_family: Option<String>,
    /// <p>A value that indicates whether only the default version of the specified engine or engine and major version combination is returned.</p>
    pub default_only: Option<bool>,
    /// <p><p>The database engine to return.</p> <p>Valid Values: </p> <ul> <li> <p> <code>aurora</code> (for MySQL 5.6-compatible Aurora)</p> </li> <li> <p> <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora)</p> </li> <li> <p> <code>aurora-postgresql</code> </p> </li> <li> <p> <code>mariadb</code> </p> </li> <li> <p> <code>mysql</code> </p> </li> <li> <p> <code>oracle-ee</code> </p> </li> <li> <p> <code>oracle-ee-cdb</code> </p> </li> <li> <p> <code>oracle-se2</code> </p> </li> <li> <p> <code>oracle-se2-cdb</code> </p> </li> <li> <p> <code>postgres</code> </p> </li> <li> <p> <code>sqlserver-ee</code> </p> </li> <li> <p> <code>sqlserver-se</code> </p> </li> <li> <p> <code>sqlserver-ex</code> </p> </li> <li> <p> <code>sqlserver-web</code> </p> </li> </ul></p>
    pub engine: Option<String>,
    /// <p>The database engine version to return.</p> <p>Example: <code>5.1.49</code> </p>
    pub engine_version: Option<String>,
    /// <p>This parameter isn't currently supported.</p>
    pub filters: Option<Vec<Filter>>,
    /// <p>A value that indicates whether to include engine versions that aren't available in the list. The default is to list only available engine versions.</p>
    pub include_all: Option<bool>,
    /// <p>A value that indicates whether to list the supported character sets for each engine version.</p> <p>If this parameter is enabled and the requested engine supports the <code>CharacterSetName</code> parameter for <code>CreateDBInstance</code>, the response includes a list of supported character sets for each engine version. </p>
    pub list_supported_character_sets: Option<bool>,
    /// <p>A value that indicates whether to list the supported time zones for each engine version.</p> <p>If this parameter is enabled and the requested engine supports the <code>TimeZone</code> parameter for <code>CreateDBInstance</code>, the response includes a list of supported time zones for each engine version. </p>
    pub list_supported_timezones: Option<bool>,
    /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    pub marker: Option<String>,
    /// <p> The maximum number of records to include in the response. If more than the <code>MaxRecords</code> value is available, a pagination token called a marker is included in the response so you can retrieve the remaining results. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: Option<i64>,
}

/// Serialize `DescribeDBEngineVersionsMessage` contents to a `SignedRequest`.
struct DescribeDBEngineVersionsMessageSerializer;
impl DescribeDBEngineVersionsMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeDBEngineVersionsMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.db_parameter_group_family {
            params.put(
                &format!("{}{}", prefix, "DBParameterGroupFamily"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.default_only {
            params.put(&format!("{}{}", prefix, "DefaultOnly"), &field_value);
        }
        if let Some(ref field_value) = obj.engine {
            params.put(&format!("{}{}", prefix, "Engine"), &field_value);
        }
        if let Some(ref field_value) = obj.engine_version {
            params.put(&format!("{}{}", prefix, "EngineVersion"), &field_value);
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.include_all {
            params.put(&format!("{}{}", prefix, "IncludeAll"), &field_value);
        }
        if let Some(ref field_value) = obj.list_supported_character_sets {
            params.put(
                &format!("{}{}", prefix, "ListSupportedCharacterSets"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.list_supported_timezones {
            params.put(
                &format!("{}{}", prefix, "ListSupportedTimezones"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
    }
}

/// <p>Parameter input for DescribeDBInstanceAutomatedBackups. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeDBInstanceAutomatedBackupsMessage {
    /// <p>The Amazon Resource Name (ARN) of the replicated automated backups, for example, <code>arn:aws:rds:us-east-1:123456789012:auto-backup:ab-L2IJCEXJP7XQ7HOJ4SIEXAMPLE</code>.</p>
    pub db_instance_automated_backups_arn: Option<String>,
    /// <p>(Optional) The user-supplied instance identifier. If this parameter is specified, it must match the identifier of an existing DB instance. It returns information from the specific DB instance' automated backup. This parameter isn't case-sensitive. </p>
    pub db_instance_identifier: Option<String>,
    /// <p>The resource ID of the DB instance that is the source of the automated backup. This parameter isn't case-sensitive. </p>
    pub dbi_resource_id: Option<String>,
    /// <p>A filter that specifies which resources to return based on status.</p> <p>Supported filters are the following:</p> <ul> <li> <p> <code>status</code> </p> <ul> <li> <p> <code>active</code> - automated backups for current instances</p> </li> <li> <p> <code>retained</code> - automated backups for deleted instances and after backup replication is stopped</p> </li> <li> <p> <code>creating</code> - automated backups that are waiting for the first automated snapshot to be available</p> </li> </ul> </li> <li> <p> <code>db-instance-id</code> - Accepts DB instance identifiers and Amazon Resource Names (ARNs). The results list includes only information about the DB instance automated backups identified by these ARNs.</p> </li> <li> <p> <code>dbi-resource-id</code> - Accepts DB resource identifiers and Amazon Resource Names (ARNs). The results list includes only information about the DB instance resources identified by these ARNs.</p> </li> </ul> <p>Returns all resources by default. The status for each resource is specified in the response.</p>
    pub filters: Option<Vec<Filter>>,
    /// <p>The pagination token provided in the previous request. If this parameter is specified the response includes only records beyond the marker, up to <code>MaxRecords</code>.</p>
    pub marker: Option<String>,
    /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.</p>
    pub max_records: Option<i64>,
}

/// Serialize `DescribeDBInstanceAutomatedBackupsMessage` contents to a `SignedRequest`.
struct DescribeDBInstanceAutomatedBackupsMessageSerializer;
impl DescribeDBInstanceAutomatedBackupsMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeDBInstanceAutomatedBackupsMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.db_instance_automated_backups_arn {
            params.put(
                &format!("{}{}", prefix, "DBInstanceAutomatedBackupsArn"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.db_instance_identifier {
            params.put(
                &format!("{}{}", prefix, "DBInstanceIdentifier"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.dbi_resource_id {
            params.put(&format!("{}{}", prefix, "DbiResourceId"), &field_value);
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeDBInstancesMessage {
    /// <p><p>The user-supplied instance identifier. If this parameter is specified, information from only the specific DB instance is returned. This parameter isn&#39;t case-sensitive.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match the identifier of an existing DBInstance.</p> </li> </ul></p>
    pub db_instance_identifier: Option<String>,
    /// <p><p>A filter that specifies one or more DB instances to describe.</p> <p>Supported filters:</p> <ul> <li> <p> <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon Resource Names (ARNs). The results list will only include information about the DB instances associated with the DB clusters identified by these ARNs.</p> </li> <li> <p> <code>db-instance-id</code> - Accepts DB instance identifiers and DB instance Amazon Resource Names (ARNs). The results list will only include information about the DB instances identified by these ARNs.</p> </li> <li> <p> <code>dbi-resource-id</code> - Accepts DB instance resource identifiers. The results list will only include information about the DB instances identified by these DB instance resource identifiers.</p> </li> <li> <p> <code>domain</code> - Accepts Active Directory directory IDs. The results list will only include information about the DB instances associated with these domains.</p> </li> <li> <p> <code>engine</code> - Accepts engine names. The results list will only include information about the DB instances for these engines.</p> </li> </ul></p>
    pub filters: Option<Vec<Filter>>,
    /// <p> An optional pagination token provided by a previous <code>DescribeDBInstances</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    pub marker: Option<String>,
    /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: Option<i64>,
}

/// Serialize `DescribeDBInstancesMessage` contents to a `SignedRequest`.
struct DescribeDBInstancesMessageSerializer;
impl DescribeDBInstancesMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeDBInstancesMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.db_instance_identifier {
            params.put(
                &format!("{}{}", prefix, "DBInstanceIdentifier"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
    }
}

/// <p>This data type is used as a response element to <code>DescribeDBLogFiles</code>.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeDBLogFilesDetails {
    /// <p>A POSIX timestamp when the last log entry was written.</p>
    pub last_written: Option<i64>,
    /// <p>The name of the log file for the specified DB instance.</p>
    pub log_file_name: Option<String>,
    /// <p>The size, in bytes, of the log file for the specified DB instance.</p>
    pub size: Option<i64>,
}

#[allow(dead_code)]
struct DescribeDBLogFilesDetailsDeserializer;
impl DescribeDBLogFilesDetailsDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeDBLogFilesDetails, XmlParseError> {
        deserialize_elements::<_, DescribeDBLogFilesDetails, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "LastWritten" => {
                        obj.last_written =
                            Some(LongDeserializer::deserialize("LastWritten", stack)?);
                    }
                    "LogFileName" => {
                        obj.log_file_name =
                            Some(StringDeserializer::deserialize("LogFileName", stack)?);
                    }
                    "Size" => {
                        obj.size = Some(LongDeserializer::deserialize("Size", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct DescribeDBLogFilesListDeserializer;
impl DescribeDBLogFilesListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<DescribeDBLogFilesDetails>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "DescribeDBLogFilesDetails" {
                obj.push(DescribeDBLogFilesDetailsDeserializer::deserialize(
                    "DescribeDBLogFilesDetails",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeDBLogFilesMessage {
    /// <p><p>The customer-assigned name of the DB instance that contains the log files you want to list.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing DBInstance.</p> </li> </ul></p>
    pub db_instance_identifier: String,
    /// <p>Filters the available log files for files written since the specified date, in POSIX timestamp format with milliseconds.</p>
    pub file_last_written: Option<i64>,
    /// <p>Filters the available log files for files larger than the specified size.</p>
    pub file_size: Option<i64>,
    /// <p>Filters the available log files for log file names that contain the specified string.</p>
    pub filename_contains: Option<String>,
    /// <p>This parameter isn't currently supported.</p>
    pub filters: Option<Vec<Filter>>,
    /// <p>The pagination token provided in the previous request. If this parameter is specified the response includes only records beyond the marker, up to MaxRecords.</p>
    pub marker: Option<String>,
    /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p>
    pub max_records: Option<i64>,
}

/// Serialize `DescribeDBLogFilesMessage` contents to a `SignedRequest`.
struct DescribeDBLogFilesMessageSerializer;
impl DescribeDBLogFilesMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeDBLogFilesMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "DBInstanceIdentifier"),
            &obj.db_instance_identifier,
        );
        if let Some(ref field_value) = obj.file_last_written {
            params.put(&format!("{}{}", prefix, "FileLastWritten"), &field_value);
        }
        if let Some(ref field_value) = obj.file_size {
            params.put(&format!("{}{}", prefix, "FileSize"), &field_value);
        }
        if let Some(ref field_value) = obj.filename_contains {
            params.put(&format!("{}{}", prefix, "FilenameContains"), &field_value);
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
    }
}

/// <p> The response from a call to <code>DescribeDBLogFiles</code>. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeDBLogFilesResponse {
    /// <p>The DB log files returned.</p>
    pub describe_db_log_files: Option<Vec<DescribeDBLogFilesDetails>>,
    /// <p>A pagination token that can be used in a later DescribeDBLogFiles request.</p>
    pub marker: Option<String>,
}

#[allow(dead_code)]
struct DescribeDBLogFilesResponseDeserializer;
impl DescribeDBLogFilesResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeDBLogFilesResponse, XmlParseError> {
        deserialize_elements::<_, DescribeDBLogFilesResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DescribeDBLogFiles" => {
                        obj.describe_db_log_files.get_or_insert(vec![]).extend(
                            DescribeDBLogFilesListDeserializer::deserialize(
                                "DescribeDBLogFiles",
                                stack,
                            )?,
                        );
                    }
                    "Marker" => {
                        obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeDBParameterGroupsMessage {
    /// <p><p>The name of a specific DB parameter group to return details for.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p> </li> </ul></p>
    pub db_parameter_group_name: Option<String>,
    /// <p>This parameter isn't currently supported.</p>
    pub filters: Option<Vec<Filter>>,
    /// <p> An optional pagination token provided by a previous <code>DescribeDBParameterGroups</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    pub marker: Option<String>,
    /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: Option<i64>,
}

/// Serialize `DescribeDBParameterGroupsMessage` contents to a `SignedRequest`.
struct DescribeDBParameterGroupsMessageSerializer;
impl DescribeDBParameterGroupsMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeDBParameterGroupsMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.db_parameter_group_name {
            params.put(
                &format!("{}{}", prefix, "DBParameterGroupName"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeDBParametersMessage {
    /// <p><p>The name of a specific DB parameter group to return details for.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match the name of an existing DBParameterGroup.</p> </li> </ul></p>
    pub db_parameter_group_name: String,
    /// <p>This parameter isn't currently supported.</p>
    pub filters: Option<Vec<Filter>>,
    /// <p> An optional pagination token provided by a previous <code>DescribeDBParameters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    pub marker: Option<String>,
    /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: Option<i64>,
    /// <p>The parameter types to return.</p> <p>Default: All parameter types returned</p> <p>Valid Values: <code>user | system | engine-default</code> </p>
    pub source: Option<String>,
}

/// Serialize `DescribeDBParametersMessage` contents to a `SignedRequest`.
struct DescribeDBParametersMessageSerializer;
impl DescribeDBParametersMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeDBParametersMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "DBParameterGroupName"),
            &obj.db_parameter_group_name,
        );
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
        if let Some(ref field_value) = obj.source {
            params.put(&format!("{}{}", prefix, "Source"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeDBProxiesRequest {
    /// <p>The name of the DB proxy. If you omit this parameter, the output includes information about all DB proxies owned by your Amazon Web Services account ID.</p>
    pub db_proxy_name: Option<String>,
    /// <p>This parameter is not currently supported.</p>
    pub filters: Option<Vec<Filter>>,
    /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    pub marker: Option<String>,
    /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: Option<i64>,
}

/// Serialize `DescribeDBProxiesRequest` contents to a `SignedRequest`.
struct DescribeDBProxiesRequestSerializer;
impl DescribeDBProxiesRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeDBProxiesRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.db_proxy_name {
            params.put(&format!("{}{}", prefix, "DBProxyName"), &field_value);
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeDBProxiesResponse {
    /// <p>A return value representing an arbitrary number of <code>DBProxy</code> data structures.</p>
    pub db_proxies: Option<Vec<DBProxy>>,
    /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    pub marker: Option<String>,
}

#[allow(dead_code)]
struct DescribeDBProxiesResponseDeserializer;
impl DescribeDBProxiesResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeDBProxiesResponse, XmlParseError> {
        deserialize_elements::<_, DescribeDBProxiesResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DBProxies" => {
                        obj.db_proxies
                            .get_or_insert(vec![])
                            .extend(DBProxyListDeserializer::deserialize("DBProxies", stack)?);
                    }
                    "Marker" => {
                        obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeDBProxyEndpointsRequest {
    /// <p>The name of a DB proxy endpoint to describe. If you omit this parameter, the output includes information about all DB proxy endpoints associated with the specified proxy.</p>
    pub db_proxy_endpoint_name: Option<String>,
    /// <p>The name of the DB proxy whose endpoints you want to describe. If you omit this parameter, the output includes information about all DB proxy endpoints associated with all your DB proxies.</p>
    pub db_proxy_name: Option<String>,
    /// <p>This parameter is not currently supported.</p>
    pub filters: Option<Vec<Filter>>,
    /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    pub marker: Option<String>,
    /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: Option<i64>,
}

/// Serialize `DescribeDBProxyEndpointsRequest` contents to a `SignedRequest`.
struct DescribeDBProxyEndpointsRequestSerializer;
impl DescribeDBProxyEndpointsRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeDBProxyEndpointsRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.db_proxy_endpoint_name {
            params.put(
                &format!("{}{}", prefix, "DBProxyEndpointName"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.db_proxy_name {
            params.put(&format!("{}{}", prefix, "DBProxyName"), &field_value);
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeDBProxyEndpointsResponse {
    /// <p>The list of <code>ProxyEndpoint</code> objects returned by the API operation.</p>
    pub db_proxy_endpoints: Option<Vec<DBProxyEndpoint>>,
    /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    pub marker: Option<String>,
}

#[allow(dead_code)]
struct DescribeDBProxyEndpointsResponseDeserializer;
impl DescribeDBProxyEndpointsResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeDBProxyEndpointsResponse, XmlParseError> {
        deserialize_elements::<_, DescribeDBProxyEndpointsResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DBProxyEndpoints" => {
                        obj.db_proxy_endpoints.get_or_insert(vec![]).extend(
                            DBProxyEndpointListDeserializer::deserialize(
                                "DBProxyEndpoints",
                                stack,
                            )?,
                        );
                    }
                    "Marker" => {
                        obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeDBProxyTargetGroupsRequest {
    /// <p>The identifier of the <code>DBProxy</code> associated with the target group.</p>
    pub db_proxy_name: String,
    /// <p>This parameter is not currently supported.</p>
    pub filters: Option<Vec<Filter>>,
    /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    pub marker: Option<String>,
    /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: Option<i64>,
    /// <p>The identifier of the <code>DBProxyTargetGroup</code> to describe.</p>
    pub target_group_name: Option<String>,
}

/// Serialize `DescribeDBProxyTargetGroupsRequest` contents to a `SignedRequest`.
struct DescribeDBProxyTargetGroupsRequestSerializer;
impl DescribeDBProxyTargetGroupsRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeDBProxyTargetGroupsRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "DBProxyName"), &obj.db_proxy_name);
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
        if let Some(ref field_value) = obj.target_group_name {
            params.put(&format!("{}{}", prefix, "TargetGroupName"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeDBProxyTargetGroupsResponse {
    /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    pub marker: Option<String>,
    /// <p>An arbitrary number of <code>DBProxyTargetGroup</code> objects, containing details of the corresponding target groups.</p>
    pub target_groups: Option<Vec<DBProxyTargetGroup>>,
}

#[allow(dead_code)]
struct DescribeDBProxyTargetGroupsResponseDeserializer;
impl DescribeDBProxyTargetGroupsResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeDBProxyTargetGroupsResponse, XmlParseError> {
        deserialize_elements::<_, DescribeDBProxyTargetGroupsResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Marker" => {
                        obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                    }
                    "TargetGroups" => {
                        obj.target_groups.get_or_insert(vec![]).extend(
                            TargetGroupListDeserializer::deserialize("TargetGroups", stack)?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeDBProxyTargetsRequest {
    /// <p>The identifier of the <code>DBProxyTarget</code> to describe.</p>
    pub db_proxy_name: String,
    /// <p>This parameter is not currently supported.</p>
    pub filters: Option<Vec<Filter>>,
    /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    pub marker: Option<String>,
    /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: Option<i64>,
    /// <p>The identifier of the <code>DBProxyTargetGroup</code> to describe.</p>
    pub target_group_name: Option<String>,
}

/// Serialize `DescribeDBProxyTargetsRequest` contents to a `SignedRequest`.
struct DescribeDBProxyTargetsRequestSerializer;
impl DescribeDBProxyTargetsRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeDBProxyTargetsRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "DBProxyName"), &obj.db_proxy_name);
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
        if let Some(ref field_value) = obj.target_group_name {
            params.put(&format!("{}{}", prefix, "TargetGroupName"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeDBProxyTargetsResponse {
    /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    pub marker: Option<String>,
    /// <p>An arbitrary number of <code>DBProxyTarget</code> objects, containing details of the corresponding targets.</p>
    pub targets: Option<Vec<DBProxyTarget>>,
}

#[allow(dead_code)]
struct DescribeDBProxyTargetsResponseDeserializer;
impl DescribeDBProxyTargetsResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeDBProxyTargetsResponse, XmlParseError> {
        deserialize_elements::<_, DescribeDBProxyTargetsResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Marker" => {
                        obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                    }
                    "Targets" => {
                        obj.targets
                            .get_or_insert(vec![])
                            .extend(TargetListDeserializer::deserialize("Targets", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeDBSecurityGroupsMessage {
    /// <p>The name of the DB security group to return details for.</p>
    pub db_security_group_name: Option<String>,
    /// <p>This parameter isn't currently supported.</p>
    pub filters: Option<Vec<Filter>>,
    /// <p> An optional pagination token provided by a previous <code>DescribeDBSecurityGroups</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    pub marker: Option<String>,
    /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: Option<i64>,
}

/// Serialize `DescribeDBSecurityGroupsMessage` contents to a `SignedRequest`.
struct DescribeDBSecurityGroupsMessageSerializer;
impl DescribeDBSecurityGroupsMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeDBSecurityGroupsMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.db_security_group_name {
            params.put(
                &format!("{}{}", prefix, "DBSecurityGroupName"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeDBSnapshotAttributesMessage {
    /// <p>The identifier for the DB snapshot to describe the attributes for.</p>
    pub db_snapshot_identifier: String,
}

/// Serialize `DescribeDBSnapshotAttributesMessage` contents to a `SignedRequest`.
struct DescribeDBSnapshotAttributesMessageSerializer;
impl DescribeDBSnapshotAttributesMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeDBSnapshotAttributesMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "DBSnapshotIdentifier"),
            &obj.db_snapshot_identifier,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeDBSnapshotAttributesResult {
    pub db_snapshot_attributes_result: Option<DBSnapshotAttributesResult>,
}

#[allow(dead_code)]
struct DescribeDBSnapshotAttributesResultDeserializer;
impl DescribeDBSnapshotAttributesResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeDBSnapshotAttributesResult, XmlParseError> {
        deserialize_elements::<_, DescribeDBSnapshotAttributesResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DBSnapshotAttributesResult" => {
                        obj.db_snapshot_attributes_result =
                            Some(DBSnapshotAttributesResultDeserializer::deserialize(
                                "DBSnapshotAttributesResult",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeDBSnapshotsMessage {
    /// <p><p>The ID of the DB instance to retrieve the list of DB snapshots for. This parameter can&#39;t be used in conjunction with <code>DBSnapshotIdentifier</code>. This parameter isn&#39;t case-sensitive. </p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match the identifier of an existing DBInstance.</p> </li> </ul></p>
    pub db_instance_identifier: Option<String>,
    /// <p><p> A specific DB snapshot identifier to describe. This parameter can&#39;t be used in conjunction with <code>DBInstanceIdentifier</code>. This value is stored as a lowercase string. </p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match the identifier of an existing DBSnapshot.</p> </li> <li> <p>If this identifier is for an automated snapshot, the <code>SnapshotType</code> parameter must also be specified.</p> </li> </ul></p>
    pub db_snapshot_identifier: Option<String>,
    /// <p>A specific DB resource ID to describe.</p>
    pub dbi_resource_id: Option<String>,
    /// <p><p>A filter that specifies one or more DB snapshots to describe.</p> <p>Supported filters:</p> <ul> <li> <p> <code>db-instance-id</code> - Accepts DB instance identifiers and DB instance Amazon Resource Names (ARNs).</p> </li> <li> <p> <code>db-snapshot-id</code> - Accepts DB snapshot identifiers.</p> </li> <li> <p> <code>dbi-resource-id</code> - Accepts identifiers of source DB instances.</p> </li> <li> <p> <code>snapshot-type</code> - Accepts types of DB snapshots.</p> </li> <li> <p> <code>engine</code> - Accepts names of database engines.</p> </li> </ul></p>
    pub filters: Option<Vec<Filter>>,
    /// <p>A value that indicates whether to include manual DB cluster snapshots that are public and can be copied or restored by any Amazon Web Services account. By default, the public snapshots are not included.</p> <p>You can share a manual DB snapshot as public by using the <a>ModifyDBSnapshotAttribute</a> API.</p>
    pub include_public: Option<bool>,
    /// <p>A value that indicates whether to include shared manual DB cluster snapshots from other Amazon Web Services accounts that this Amazon Web Services account has been given permission to copy or restore. By default, these snapshots are not included.</p> <p>You can give an Amazon Web Services account permission to restore a manual DB snapshot from another Amazon Web Services account by using the <code>ModifyDBSnapshotAttribute</code> API action.</p>
    pub include_shared: Option<bool>,
    /// <p> An optional pagination token provided by a previous <code>DescribeDBSnapshots</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    pub marker: Option<String>,
    /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: Option<i64>,
    /// <p>The type of snapshots to be returned. You can specify one of the following values:</p> <ul> <li> <p> <code>automated</code> - Return all DB snapshots that have been automatically taken by Amazon RDS for my Amazon Web Services account.</p> </li> <li> <p> <code>manual</code> - Return all DB snapshots that have been taken by my Amazon Web Services account.</p> </li> <li> <p> <code>shared</code> - Return all manual DB snapshots that have been shared to my Amazon Web Services account.</p> </li> <li> <p> <code>public</code> - Return all DB snapshots that have been marked as public.</p> </li> <li> <p> <code>awsbackup</code> - Return the DB snapshots managed by the Amazon Web Services Backup service.</p> <p>For information about Amazon Web Services Backup, see the <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html"> <i>Amazon Web Services Backup Developer Guide.</i> </a> </p> <p>The <code>awsbackup</code> type does not apply to Aurora.</p> </li> </ul> <p>If you don't specify a <code>SnapshotType</code> value, then both automated and manual snapshots are returned. Shared and public DB snapshots are not included in the returned results by default. You can include shared snapshots with these results by enabling the <code>IncludeShared</code> parameter. You can include public snapshots with these results by enabling the <code>IncludePublic</code> parameter.</p> <p>The <code>IncludeShared</code> and <code>IncludePublic</code> parameters don't apply for <code>SnapshotType</code> values of <code>manual</code> or <code>automated</code>. The <code>IncludePublic</code> parameter doesn't apply when <code>SnapshotType</code> is set to <code>shared</code>. The <code>IncludeShared</code> parameter doesn't apply when <code>SnapshotType</code> is set to <code>public</code>.</p>
    pub snapshot_type: Option<String>,
}

/// Serialize `DescribeDBSnapshotsMessage` contents to a `SignedRequest`.
struct DescribeDBSnapshotsMessageSerializer;
impl DescribeDBSnapshotsMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeDBSnapshotsMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.db_instance_identifier {
            params.put(
                &format!("{}{}", prefix, "DBInstanceIdentifier"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.db_snapshot_identifier {
            params.put(
                &format!("{}{}", prefix, "DBSnapshotIdentifier"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.dbi_resource_id {
            params.put(&format!("{}{}", prefix, "DbiResourceId"), &field_value);
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.include_public {
            params.put(&format!("{}{}", prefix, "IncludePublic"), &field_value);
        }
        if let Some(ref field_value) = obj.include_shared {
            params.put(&format!("{}{}", prefix, "IncludeShared"), &field_value);
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
        if let Some(ref field_value) = obj.snapshot_type {
            params.put(&format!("{}{}", prefix, "SnapshotType"), &field_value);
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeDBSubnetGroupsMessage {
    /// <p>The name of the DB subnet group to return details for.</p>
    pub db_subnet_group_name: Option<String>,
    /// <p>This parameter isn't currently supported.</p>
    pub filters: Option<Vec<Filter>>,
    /// <p> An optional pagination token provided by a previous DescribeDBSubnetGroups request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    pub marker: Option<String>,
    /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: Option<i64>,
}

/// Serialize `DescribeDBSubnetGroupsMessage` contents to a `SignedRequest`.
struct DescribeDBSubnetGroupsMessageSerializer;
impl DescribeDBSubnetGroupsMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeDBSubnetGroupsMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.db_subnet_group_name {
            params.put(&format!("{}{}", prefix, "DBSubnetGroupName"), &field_value);
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeEngineDefaultClusterParametersMessage {
    /// <p>The name of the DB cluster parameter group family to return engine parameter information for.</p>
    pub db_parameter_group_family: String,
    /// <p>This parameter isn't currently supported.</p>
    pub filters: Option<Vec<Filter>>,
    /// <p> An optional pagination token provided by a previous <code>DescribeEngineDefaultClusterParameters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    pub marker: Option<String>,
    /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: Option<i64>,
}

/// Serialize `DescribeEngineDefaultClusterParametersMessage` contents to a `SignedRequest`.
struct DescribeEngineDefaultClusterParametersMessageSerializer;
impl DescribeEngineDefaultClusterParametersMessageSerializer {
    fn serialize(
        params: &mut Params,
        name: &str,
        obj: &DescribeEngineDefaultClusterParametersMessage,
    ) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "DBParameterGroupFamily"),
            &obj.db_parameter_group_family,
        );
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeEngineDefaultClusterParametersResult {
    pub engine_defaults: Option<EngineDefaults>,
}

#[allow(dead_code)]
struct DescribeEngineDefaultClusterParametersResultDeserializer;
impl DescribeEngineDefaultClusterParametersResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeEngineDefaultClusterParametersResult, XmlParseError> {
        deserialize_elements::<_, DescribeEngineDefaultClusterParametersResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "EngineDefaults" => {
                        obj.engine_defaults = Some(EngineDefaultsDeserializer::deserialize(
                            "EngineDefaults",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeEngineDefaultParametersMessage {
    /// <p>The name of the DB parameter group family.</p>
    pub db_parameter_group_family: String,
    /// <p>This parameter isn't currently supported.</p>
    pub filters: Option<Vec<Filter>>,
    /// <p> An optional pagination token provided by a previous <code>DescribeEngineDefaultParameters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    pub marker: Option<String>,
    /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: Option<i64>,
}

/// Serialize `DescribeEngineDefaultParametersMessage` contents to a `SignedRequest`.
struct DescribeEngineDefaultParametersMessageSerializer;
impl DescribeEngineDefaultParametersMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeEngineDefaultParametersMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "DBParameterGroupFamily"),
            &obj.db_parameter_group_family,
        );
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeEngineDefaultParametersResult {
    pub engine_defaults: Option<EngineDefaults>,
}

#[allow(dead_code)]
struct DescribeEngineDefaultParametersResultDeserializer;
impl DescribeEngineDefaultParametersResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeEngineDefaultParametersResult, XmlParseError> {
        deserialize_elements::<_, DescribeEngineDefaultParametersResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "EngineDefaults" => {
                        obj.engine_defaults = Some(EngineDefaultsDeserializer::deserialize(
                            "EngineDefaults",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeEventCategoriesMessage {
    /// <p>This parameter isn't currently supported.</p>
    pub filters: Option<Vec<Filter>>,
    /// <p>The type of source that is generating the events.</p> <p>Valid values: <code>db-instance</code> | <code>db-cluster</code> | <code>db-parameter-group</code> | <code>db-security-group</code> | <code>db-snapshot</code> | <code>db-cluster-snapshot</code> </p>
    pub source_type: Option<String>,
}

/// Serialize `DescribeEventCategoriesMessage` contents to a `SignedRequest`.
struct DescribeEventCategoriesMessageSerializer;
impl DescribeEventCategoriesMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeEventCategoriesMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.source_type {
            params.put(&format!("{}{}", prefix, "SourceType"), &field_value);
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeEventSubscriptionsMessage {
    /// <p>This parameter isn't currently supported.</p>
    pub filters: Option<Vec<Filter>>,
    /// <p> An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> . </p>
    pub marker: Option<String>,
    /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: Option<i64>,
    /// <p>The name of the RDS event notification subscription you want to describe.</p>
    pub subscription_name: Option<String>,
}

/// Serialize `DescribeEventSubscriptionsMessage` contents to a `SignedRequest`.
struct DescribeEventSubscriptionsMessageSerializer;
impl DescribeEventSubscriptionsMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeEventSubscriptionsMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
        if let Some(ref field_value) = obj.subscription_name {
            params.put(&format!("{}{}", prefix, "SubscriptionName"), &field_value);
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeEventsMessage {
    /// <p>The number of minutes to retrieve events for.</p> <p>Default: 60</p>
    pub duration: Option<i64>,
    /// <p> The end of the time interval for which to retrieve events, specified in ISO 8601 format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a> </p> <p>Example: 2009-07-08T18:00Z</p>
    pub end_time: Option<String>,
    /// <p>A list of event categories that trigger notifications for a event notification subscription.</p>
    pub event_categories: Option<Vec<String>>,
    /// <p>This parameter isn't currently supported.</p>
    pub filters: Option<Vec<Filter>>,
    /// <p> An optional pagination token provided by a previous DescribeEvents request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    pub marker: Option<String>,
    /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: Option<i64>,
    /// <p><p>The identifier of the event source for which events are returned. If not specified, then all sources are included in the response.</p> <p>Constraints:</p> <ul> <li> <p>If <code>SourceIdentifier</code> is supplied, <code>SourceType</code> must also be provided.</p> </li> <li> <p>If the source type is a DB instance, a <code>DBInstanceIdentifier</code> value must be supplied.</p> </li> <li> <p>If the source type is a DB cluster, a <code>DBClusterIdentifier</code> value must be supplied.</p> </li> <li> <p>If the source type is a DB parameter group, a <code>DBParameterGroupName</code> value must be supplied.</p> </li> <li> <p>If the source type is a DB security group, a <code>DBSecurityGroupName</code> value must be supplied.</p> </li> <li> <p>If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> value must be supplied.</p> </li> <li> <p>If the source type is a DB cluster snapshot, a <code>DBClusterSnapshotIdentifier</code> value must be supplied.</p> </li> <li> <p>Can&#39;t end with a hyphen or contain two consecutive hyphens.</p> </li> </ul></p>
    pub source_identifier: Option<String>,
    /// <p>The event source to retrieve events for. If no value is specified, all events are returned.</p>
    pub source_type: Option<String>,
    /// <p> The beginning of the time interval to retrieve events for, specified in ISO 8601 format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a> </p> <p>Example: 2009-07-08T18:00Z</p>
    pub start_time: Option<String>,
}

/// Serialize `DescribeEventsMessage` contents to a `SignedRequest`.
struct DescribeEventsMessageSerializer;
impl DescribeEventsMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeEventsMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.duration {
            params.put(&format!("{}{}", prefix, "Duration"), &field_value);
        }
        if let Some(ref field_value) = obj.end_time {
            params.put(&format!("{}{}", prefix, "EndTime"), &field_value);
        }
        if let Some(ref field_value) = obj.event_categories {
            EventCategoriesListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "EventCategory"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
        if let Some(ref field_value) = obj.source_identifier {
            params.put(&format!("{}{}", prefix, "SourceIdentifier"), &field_value);
        }
        if let Some(ref field_value) = obj.source_type {
            params.put(&format!("{}{}", prefix, "SourceType"), &field_value);
        }
        if let Some(ref field_value) = obj.start_time {
            params.put(&format!("{}{}", prefix, "StartTime"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeExportTasksMessage {
    /// <p>The identifier of the snapshot export task to be described.</p>
    pub export_task_identifier: Option<String>,
    /// <p><p>Filters specify one or more snapshot exports to describe. The filters are specified as name-value pairs that define what to include in the output. Filter names and values are case-sensitive.</p> <p>Supported filters include the following: </p> <ul> <li> <p> <code>export-task-identifier</code> - An identifier for the snapshot export task.</p> </li> <li> <p> <code>s3-bucket</code> - The Amazon S3 bucket the snapshot is exported to.</p> </li> <li> <p> <code>source-arn</code> - The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3</p> </li> <li> <p> <code>status</code> - The status of the export task. Must be lowercase, for example, <code>complete</code>.</p> </li> </ul></p>
    pub filters: Option<Vec<Filter>>,
    /// <p> An optional pagination token provided by a previous <code>DescribeExportTasks</code> request. If you specify this parameter, the response includes only records beyond the marker, up to the value specified by the <code>MaxRecords</code> parameter. </p>
    pub marker: Option<String>,
    /// <p> The maximum number of records to include in the response. If more records exist than the specified value, a pagination token called a marker is included in the response. You can use the marker in a later <code>DescribeExportTasks</code> request to retrieve the remaining results. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: Option<i64>,
    /// <p>The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3.</p>
    pub source_arn: Option<String>,
}

/// Serialize `DescribeExportTasksMessage` contents to a `SignedRequest`.
struct DescribeExportTasksMessageSerializer;
impl DescribeExportTasksMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeExportTasksMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.export_task_identifier {
            params.put(
                &format!("{}{}", prefix, "ExportTaskIdentifier"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
        if let Some(ref field_value) = obj.source_arn {
            params.put(&format!("{}{}", prefix, "SourceArn"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeGlobalClustersMessage {
    /// <p><p>A filter that specifies one or more global DB clusters to describe.</p> <p>Supported filters:</p> <ul> <li> <p> <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon Resource Names (ARNs). The results list will only include information about the DB clusters identified by these ARNs.</p> </li> </ul></p>
    pub filters: Option<Vec<Filter>>,
    /// <p><p> The user-supplied DB cluster identifier. If this parameter is specified, information from only the specific DB cluster is returned. This parameter isn&#39;t case-sensitive. </p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match an existing DBClusterIdentifier.</p> </li> </ul></p>
    pub global_cluster_identifier: Option<String>,
    /// <p> An optional pagination token provided by a previous <code>DescribeGlobalClusters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    pub marker: Option<String>,
    /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: Option<i64>,
}

/// Serialize `DescribeGlobalClustersMessage` contents to a `SignedRequest`.
struct DescribeGlobalClustersMessageSerializer;
impl DescribeGlobalClustersMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeGlobalClustersMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.global_cluster_identifier {
            params.put(
                &format!("{}{}", prefix, "GlobalClusterIdentifier"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeInstallationMediaMessage {
    /// <p><p>A filter that specifies one or more installation media to describe. Supported filters include the following:</p> <ul> <li> <p> <code>custom-availability-zone-id</code> - Accepts custom Availability Zone (AZ) identifiers. The results list includes information about only the custom AZs identified by these identifiers.</p> </li> <li> <p> <code>engine</code> - Accepts database engines. The results list includes information about only the database engines identified by these identifiers.</p> <p>For more information about the valid engines for installation media, see <a>ImportInstallationMedia</a>.</p> </li> </ul></p>
    pub filters: Option<Vec<Filter>>,
    /// <p>The installation medium ID.</p>
    pub installation_media_id: Option<String>,
    /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub marker: Option<String>,
    /// <p>An optional pagination token provided by a previous DescribeInstallationMedia request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub max_records: Option<i64>,
}

/// Serialize `DescribeInstallationMediaMessage` contents to a `SignedRequest`.
struct DescribeInstallationMediaMessageSerializer;
impl DescribeInstallationMediaMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeInstallationMediaMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.installation_media_id {
            params.put(
                &format!("{}{}", prefix, "InstallationMediaId"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeOptionGroupOptionsMessage {
    /// <p><p>A required parameter. Options available for the given engine name are described.</p> <p>Valid Values: </p> <ul> <li> <p> <code>mariadb</code> </p> </li> <li> <p> <code>mysql</code> </p> </li> <li> <p> <code>oracle-ee</code> </p> </li> <li> <p> <code>oracle-ee-cdb</code> </p> </li> <li> <p> <code>oracle-se2</code> </p> </li> <li> <p> <code>oracle-se2-cdb</code> </p> </li> <li> <p> <code>postgres</code> </p> </li> <li> <p> <code>sqlserver-ee</code> </p> </li> <li> <p> <code>sqlserver-se</code> </p> </li> <li> <p> <code>sqlserver-ex</code> </p> </li> <li> <p> <code>sqlserver-web</code> </p> </li> </ul></p>
    pub engine_name: String,
    /// <p>This parameter isn't currently supported.</p>
    pub filters: Option<Vec<Filter>>,
    /// <p>If specified, filters the results to include only options for the specified major engine version.</p>
    pub major_engine_version: Option<String>,
    /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub marker: Option<String>,
    /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: Option<i64>,
}

/// Serialize `DescribeOptionGroupOptionsMessage` contents to a `SignedRequest`.
struct DescribeOptionGroupOptionsMessageSerializer;
impl DescribeOptionGroupOptionsMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeOptionGroupOptionsMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "EngineName"), &obj.engine_name);
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.major_engine_version {
            params.put(&format!("{}{}", prefix, "MajorEngineVersion"), &field_value);
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeOptionGroupsMessage {
    /// <p><p>Filters the list of option groups to only include groups associated with a specific database engine.</p> <p>Valid Values: </p> <ul> <li> <p> <code>mariadb</code> </p> </li> <li> <p> <code>mysql</code> </p> </li> <li> <p> <code>oracle-ee</code> </p> </li> <li> <p> <code>oracle-ee-cdb</code> </p> </li> <li> <p> <code>oracle-se2</code> </p> </li> <li> <p> <code>oracle-se2-cdb</code> </p> </li> <li> <p> <code>postgres</code> </p> </li> <li> <p> <code>sqlserver-ee</code> </p> </li> <li> <p> <code>sqlserver-se</code> </p> </li> <li> <p> <code>sqlserver-ex</code> </p> </li> <li> <p> <code>sqlserver-web</code> </p> </li> </ul></p>
    pub engine_name: Option<String>,
    /// <p>This parameter isn't currently supported.</p>
    pub filters: Option<Vec<Filter>>,
    /// <p>Filters the list of option groups to only include groups associated with a specific database engine version. If specified, then EngineName must also be specified.</p>
    pub major_engine_version: Option<String>,
    /// <p> An optional pagination token provided by a previous DescribeOptionGroups request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    pub marker: Option<String>,
    /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: Option<i64>,
    /// <p>The name of the option group to describe. Can't be supplied together with EngineName or MajorEngineVersion.</p>
    pub option_group_name: Option<String>,
}

/// Serialize `DescribeOptionGroupsMessage` contents to a `SignedRequest`.
struct DescribeOptionGroupsMessageSerializer;
impl DescribeOptionGroupsMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeOptionGroupsMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.engine_name {
            params.put(&format!("{}{}", prefix, "EngineName"), &field_value);
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.major_engine_version {
            params.put(&format!("{}{}", prefix, "MajorEngineVersion"), &field_value);
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
        if let Some(ref field_value) = obj.option_group_name {
            params.put(&format!("{}{}", prefix, "OptionGroupName"), &field_value);
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeOrderableDBInstanceOptionsMessage {
    /// <p>The Availability Zone group associated with a Local Zone. Specify this parameter to retrieve available offerings for the Local Zones in the group.</p> <p>Omit this parameter to show the available offerings in the specified Amazon Web Services Region.</p>
    pub availability_zone_group: Option<String>,
    /// <p>The DB instance class filter value. Specify this parameter to show only the available offerings matching the specified DB instance class.</p>
    pub db_instance_class: Option<String>,
    /// <p><p>The name of the engine to retrieve DB instance options for.</p> <p>Valid Values: </p> <ul> <li> <p> <code>aurora</code> (for MySQL 5.6-compatible Aurora)</p> </li> <li> <p> <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora)</p> </li> <li> <p> <code>aurora-postgresql</code> </p> </li> <li> <p> <code>mariadb</code> </p> </li> <li> <p> <code>mysql</code> </p> </li> <li> <p> <code>oracle-ee</code> </p> </li> <li> <p> <code>oracle-ee-cdb</code> </p> </li> <li> <p> <code>oracle-se2</code> </p> </li> <li> <p> <code>oracle-se2-cdb</code> </p> </li> <li> <p> <code>postgres</code> </p> </li> <li> <p> <code>sqlserver-ee</code> </p> </li> <li> <p> <code>sqlserver-se</code> </p> </li> <li> <p> <code>sqlserver-ex</code> </p> </li> <li> <p> <code>sqlserver-web</code> </p> </li> </ul></p>
    pub engine: String,
    /// <p>The engine version filter value. Specify this parameter to show only the available offerings matching the specified engine version.</p>
    pub engine_version: Option<String>,
    /// <p>This parameter isn't currently supported.</p>
    pub filters: Option<Vec<Filter>>,
    /// <p>The license model filter value. Specify this parameter to show only the available offerings matching the specified license model.</p>
    pub license_model: Option<String>,
    /// <p> An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> . </p>
    pub marker: Option<String>,
    /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: Option<i64>,
    /// <p>A value that indicates whether to show only VPC or non-VPC offerings.</p>
    pub vpc: Option<bool>,
}

/// Serialize `DescribeOrderableDBInstanceOptionsMessage` contents to a `SignedRequest`.
struct DescribeOrderableDBInstanceOptionsMessageSerializer;
impl DescribeOrderableDBInstanceOptionsMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeOrderableDBInstanceOptionsMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.availability_zone_group {
            params.put(
                &format!("{}{}", prefix, "AvailabilityZoneGroup"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.db_instance_class {
            params.put(&format!("{}{}", prefix, "DBInstanceClass"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "Engine"), &obj.engine);
        if let Some(ref field_value) = obj.engine_version {
            params.put(&format!("{}{}", prefix, "EngineVersion"), &field_value);
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.license_model {
            params.put(&format!("{}{}", prefix, "LicenseModel"), &field_value);
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
        if let Some(ref field_value) = obj.vpc {
            params.put(&format!("{}{}", prefix, "Vpc"), &field_value);
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribePendingMaintenanceActionsMessage {
    /// <p><p>A filter that specifies one or more resources to return pending maintenance actions for.</p> <p>Supported filters:</p> <ul> <li> <p> <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon Resource Names (ARNs). The results list will only include pending maintenance actions for the DB clusters identified by these ARNs.</p> </li> <li> <p> <code>db-instance-id</code> - Accepts DB instance identifiers and DB instance ARNs. The results list will only include pending maintenance actions for the DB instances identified by these ARNs.</p> </li> </ul></p>
    pub filters: Option<Vec<Filter>>,
    /// <p> An optional pagination token provided by a previous <code>DescribePendingMaintenanceActions</code> request. If this parameter is specified, the response includes only records beyond the marker, up to a number of records specified by <code>MaxRecords</code>. </p>
    pub marker: Option<String>,
    /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: Option<i64>,
    /// <p>The ARN of a resource to return pending maintenance actions for.</p>
    pub resource_identifier: Option<String>,
}

/// Serialize `DescribePendingMaintenanceActionsMessage` contents to a `SignedRequest`.
struct DescribePendingMaintenanceActionsMessageSerializer;
impl DescribePendingMaintenanceActionsMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribePendingMaintenanceActionsMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
        if let Some(ref field_value) = obj.resource_identifier {
            params.put(&format!("{}{}", prefix, "ResourceIdentifier"), &field_value);
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeReservedDBInstancesMessage {
    /// <p>The DB instance class filter value. Specify this parameter to show only those reservations matching the specified DB instances class.</p>
    pub db_instance_class: Option<String>,
    /// <p>The duration filter value, specified in years or seconds. Specify this parameter to show only reservations for this duration.</p> <p>Valid Values: <code>1 | 3 | 31536000 | 94608000</code> </p>
    pub duration: Option<String>,
    /// <p>This parameter isn't currently supported.</p>
    pub filters: Option<Vec<Filter>>,
    /// <p><p>The lease identifier filter value. Specify this parameter to show only the reservation that matches the specified lease ID.</p> <note> <p>Amazon Web Services Support might request the lease ID for an issue related to a reserved DB instance.</p> </note></p>
    pub lease_id: Option<String>,
    /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    pub marker: Option<String>,
    /// <p> The maximum number of records to include in the response. If more than the <code>MaxRecords</code> value is available, a pagination token called a marker is included in the response so you can retrieve the remaining results. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: Option<i64>,
    /// <p>A value that indicates whether to show only those reservations that support Multi-AZ.</p>
    pub multi_az: Option<bool>,
    /// <p>The offering type filter value. Specify this parameter to show only the available offerings matching the specified offering type.</p> <p>Valid Values: <code>"Partial Upfront" | "All Upfront" | "No Upfront" </code> </p>
    pub offering_type: Option<String>,
    /// <p>The product description filter value. Specify this parameter to show only those reservations matching the specified product description.</p>
    pub product_description: Option<String>,
    /// <p>The reserved DB instance identifier filter value. Specify this parameter to show only the reservation that matches the specified reservation ID.</p>
    pub reserved_db_instance_id: Option<String>,
    /// <p>The offering identifier filter value. Specify this parameter to show only purchased reservations matching the specified offering identifier.</p>
    pub reserved_db_instances_offering_id: Option<String>,
}

/// Serialize `DescribeReservedDBInstancesMessage` contents to a `SignedRequest`.
struct DescribeReservedDBInstancesMessageSerializer;
impl DescribeReservedDBInstancesMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeReservedDBInstancesMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.db_instance_class {
            params.put(&format!("{}{}", prefix, "DBInstanceClass"), &field_value);
        }
        if let Some(ref field_value) = obj.duration {
            params.put(&format!("{}{}", prefix, "Duration"), &field_value);
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.lease_id {
            params.put(&format!("{}{}", prefix, "LeaseId"), &field_value);
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
        if let Some(ref field_value) = obj.multi_az {
            params.put(&format!("{}{}", prefix, "MultiAZ"), &field_value);
        }
        if let Some(ref field_value) = obj.offering_type {
            params.put(&format!("{}{}", prefix, "OfferingType"), &field_value);
        }
        if let Some(ref field_value) = obj.product_description {
            params.put(&format!("{}{}", prefix, "ProductDescription"), &field_value);
        }
        if let Some(ref field_value) = obj.reserved_db_instance_id {
            params.put(
                &format!("{}{}", prefix, "ReservedDBInstanceId"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.reserved_db_instances_offering_id {
            params.put(
                &format!("{}{}", prefix, "ReservedDBInstancesOfferingId"),
                &field_value,
            );
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeReservedDBInstancesOfferingsMessage {
    /// <p>The DB instance class filter value. Specify this parameter to show only the available offerings matching the specified DB instance class.</p>
    pub db_instance_class: Option<String>,
    /// <p>Duration filter value, specified in years or seconds. Specify this parameter to show only reservations for this duration.</p> <p>Valid Values: <code>1 | 3 | 31536000 | 94608000</code> </p>
    pub duration: Option<String>,
    /// <p>This parameter isn't currently supported.</p>
    pub filters: Option<Vec<Filter>>,
    /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    pub marker: Option<String>,
    /// <p> The maximum number of records to include in the response. If more than the <code>MaxRecords</code> value is available, a pagination token called a marker is included in the response so you can retrieve the remaining results. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: Option<i64>,
    /// <p>A value that indicates whether to show only those reservations that support Multi-AZ.</p>
    pub multi_az: Option<bool>,
    /// <p>The offering type filter value. Specify this parameter to show only the available offerings matching the specified offering type.</p> <p>Valid Values: <code>"Partial Upfront" | "All Upfront" | "No Upfront" </code> </p>
    pub offering_type: Option<String>,
    /// <p><p>Product description filter value. Specify this parameter to show only the available offerings that contain the specified product description.</p> <note> <p>The results show offerings that partially match the filter value.</p> </note></p>
    pub product_description: Option<String>,
    /// <p>The offering identifier filter value. Specify this parameter to show only the available offering that matches the specified reservation identifier.</p> <p>Example: <code>438012d3-4052-4cc7-b2e3-8d3372e0e706</code> </p>
    pub reserved_db_instances_offering_id: Option<String>,
}

/// Serialize `DescribeReservedDBInstancesOfferingsMessage` contents to a `SignedRequest`.
struct DescribeReservedDBInstancesOfferingsMessageSerializer;
impl DescribeReservedDBInstancesOfferingsMessageSerializer {
    fn serialize(
        params: &mut Params,
        name: &str,
        obj: &DescribeReservedDBInstancesOfferingsMessage,
    ) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.db_instance_class {
            params.put(&format!("{}{}", prefix, "DBInstanceClass"), &field_value);
        }
        if let Some(ref field_value) = obj.duration {
            params.put(&format!("{}{}", prefix, "Duration"), &field_value);
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
        if let Some(ref field_value) = obj.multi_az {
            params.put(&format!("{}{}", prefix, "MultiAZ"), &field_value);
        }
        if let Some(ref field_value) = obj.offering_type {
            params.put(&format!("{}{}", prefix, "OfferingType"), &field_value);
        }
        if let Some(ref field_value) = obj.product_description {
            params.put(&format!("{}{}", prefix, "ProductDescription"), &field_value);
        }
        if let Some(ref field_value) = obj.reserved_db_instances_offering_id {
            params.put(
                &format!("{}{}", prefix, "ReservedDBInstancesOfferingId"),
                &field_value,
            );
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeSourceRegionsMessage {
    /// <p>This parameter isn't currently supported.</p>
    pub filters: Option<Vec<Filter>>,
    /// <p>An optional pagination token provided by a previous <code>DescribeSourceRegions</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub marker: Option<String>,
    /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: Option<i64>,
    /// <p><p>The source Amazon Web Services Region name. For example, <code>us-east-1</code>.</p> <p>Constraints:</p> <ul> <li> <p>Must specify a valid Amazon Web Services Region name.</p> </li> </ul></p>
    pub region_name: Option<String>,
}

/// Serialize `DescribeSourceRegionsMessage` contents to a `SignedRequest`.
struct DescribeSourceRegionsMessageSerializer;
impl DescribeSourceRegionsMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeSourceRegionsMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
        if let Some(ref field_value) = obj.region_name {
            params.put(&format!("{}{}", prefix, "RegionName"), &field_value);
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeValidDBInstanceModificationsMessage {
    /// <p>The customer identifier or the ARN of your DB instance. </p>
    pub db_instance_identifier: String,
}

/// Serialize `DescribeValidDBInstanceModificationsMessage` contents to a `SignedRequest`.
struct DescribeValidDBInstanceModificationsMessageSerializer;
impl DescribeValidDBInstanceModificationsMessageSerializer {
    fn serialize(
        params: &mut Params,
        name: &str,
        obj: &DescribeValidDBInstanceModificationsMessage,
    ) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "DBInstanceIdentifier"),
            &obj.db_instance_identifier,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeValidDBInstanceModificationsResult {
    pub valid_db_instance_modifications_message: Option<ValidDBInstanceModificationsMessage>,
}

#[allow(dead_code)]
struct DescribeValidDBInstanceModificationsResultDeserializer;
impl DescribeValidDBInstanceModificationsResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeValidDBInstanceModificationsResult, XmlParseError> {
        deserialize_elements::<_, DescribeValidDBInstanceModificationsResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "ValidDBInstanceModificationsMessage" => {
                        obj.valid_db_instance_modifications_message = Some(
                            ValidDBInstanceModificationsMessageDeserializer::deserialize(
                                "ValidDBInstanceModificationsMessage",
                                stack,
                            )?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>An Active Directory Domain membership record associated with the DB instance or cluster.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DomainMembership {
    /// <p>The identifier of the Active Directory Domain.</p>
    pub domain: Option<String>,
    /// <p>The fully qualified domain name of the Active Directory Domain.</p>
    pub fqdn: Option<String>,
    /// <p>The name of the IAM role to be used when making API calls to the Directory Service.</p>
    pub iam_role_name: Option<String>,
    /// <p>The status of the Active Directory Domain membership for the DB instance or cluster. Values include joined, pending-join, failed, and so on.</p>
    pub status: Option<String>,
}

#[allow(dead_code)]
struct DomainMembershipDeserializer;
impl DomainMembershipDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DomainMembership, XmlParseError> {
        deserialize_elements::<_, DomainMembership, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Domain" => {
                    obj.domain = Some(StringDeserializer::deserialize("Domain", stack)?);
                }
                "FQDN" => {
                    obj.fqdn = Some(StringDeserializer::deserialize("FQDN", stack)?);
                }
                "IAMRoleName" => {
                    obj.iam_role_name =
                        Some(StringDeserializer::deserialize("IAMRoleName", stack)?);
                }
                "Status" => {
                    obj.status = Some(StringDeserializer::deserialize("Status", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct DomainMembershipListDeserializer;
impl DomainMembershipListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<DomainMembership>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "DomainMembership" {
                obj.push(DomainMembershipDeserializer::deserialize(
                    "DomainMembership",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct DoubleDeserializer;
impl DoubleDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<f64, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, |s| Ok(f64::from_str(&s).unwrap()))
    }
}
#[allow(dead_code)]
struct DoubleOptionalDeserializer;
impl DoubleOptionalDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<f64, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, |s| Ok(f64::from_str(&s).unwrap()))
    }
}
/// <p>A range of double values.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DoubleRange {
    /// <p>The minimum value in the range.</p>
    pub from: Option<f64>,
    /// <p>The maximum value in the range.</p>
    pub to: Option<f64>,
}

#[allow(dead_code)]
struct DoubleRangeDeserializer;
impl DoubleRangeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DoubleRange, XmlParseError> {
        deserialize_elements::<_, DoubleRange, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "From" => {
                    obj.from = Some(DoubleDeserializer::deserialize("From", stack)?);
                }
                "To" => {
                    obj.to = Some(DoubleDeserializer::deserialize("To", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct DoubleRangeListDeserializer;
impl DoubleRangeListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<DoubleRange>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "DoubleRange" {
                obj.push(DoubleRangeDeserializer::deserialize("DoubleRange", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>This data type is used as a response element to <code>DownloadDBLogFilePortion</code>.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DownloadDBLogFilePortionDetails {
    /// <p>Boolean value that if true, indicates there is more data to be downloaded.</p>
    pub additional_data_pending: Option<bool>,
    /// <p>Entries from the specified log file.</p>
    pub log_file_data: Option<String>,
    /// <p>A pagination token that can be used in a later DownloadDBLogFilePortion request.</p>
    pub marker: Option<String>,
}

#[allow(dead_code)]
struct DownloadDBLogFilePortionDetailsDeserializer;
impl DownloadDBLogFilePortionDetailsDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DownloadDBLogFilePortionDetails, XmlParseError> {
        deserialize_elements::<_, DownloadDBLogFilePortionDetails, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "AdditionalDataPending" => {
                        obj.additional_data_pending = Some(BooleanDeserializer::deserialize(
                            "AdditionalDataPending",
                            stack,
                        )?);
                    }
                    "LogFileData" => {
                        obj.log_file_data =
                            Some(StringDeserializer::deserialize("LogFileData", stack)?);
                    }
                    "Marker" => {
                        obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DownloadDBLogFilePortionMessage {
    /// <p><p>The customer-assigned name of the DB instance that contains the log files you want to list.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing DBInstance.</p> </li> </ul></p>
    pub db_instance_identifier: String,
    /// <p>The name of the log file to be downloaded.</p>
    pub log_file_name: String,
    /// <p>The pagination token provided in the previous request or "0". If the Marker parameter is specified the response includes only records beyond the marker until the end of the file or up to NumberOfLines.</p>
    pub marker: Option<String>,
    /// <p><p>The number of lines to download. If the number of lines specified results in a file over 1 MB in size, the file is truncated at 1 MB in size.</p> <p>If the NumberOfLines parameter is specified, then the block of lines returned can be from the beginning or the end of the log file, depending on the value of the Marker parameter.</p> <ul> <li> <p>If neither Marker or NumberOfLines are specified, the entire log file is returned up to a maximum of 10000 lines, starting with the most recent log entries first.</p> </li> <li> <p>If NumberOfLines is specified and Marker isn&#39;t specified, then the most recent lines from the end of the log file are returned.</p> </li> <li> <p>If Marker is specified as &quot;0&quot;, then the specified number of lines from the beginning of the log file are returned.</p> </li> <li> <p>You can download the log file in blocks of lines by specifying the size of the block using the NumberOfLines parameter, and by specifying a value of &quot;0&quot; for the Marker parameter in your first request. Include the Marker value returned in the response as the Marker value for the next request, continuing until the AdditionalDataPending response element returns false.</p> </li> </ul></p>
    pub number_of_lines: Option<i64>,
}

/// Serialize `DownloadDBLogFilePortionMessage` contents to a `SignedRequest`.
struct DownloadDBLogFilePortionMessageSerializer;
impl DownloadDBLogFilePortionMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DownloadDBLogFilePortionMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "DBInstanceIdentifier"),
            &obj.db_instance_identifier,
        );
        params.put(&format!("{}{}", prefix, "LogFileName"), &obj.log_file_name);
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.number_of_lines {
            params.put(&format!("{}{}", prefix, "NumberOfLines"), &field_value);
        }
    }
}

/// <p><p>This data type is used as a response element in the following actions:</p> <ul> <li> <p> <code>AuthorizeDBSecurityGroupIngress</code> </p> </li> <li> <p> <code>DescribeDBSecurityGroups</code> </p> </li> <li> <p> <code>RevokeDBSecurityGroupIngress</code> </p> </li> </ul></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct EC2SecurityGroup {
    /// <p>Specifies the id of the EC2 security group.</p>
    pub ec2_security_group_id: Option<String>,
    /// <p>Specifies the name of the EC2 security group.</p>
    pub ec2_security_group_name: Option<String>,
    /// <p> Specifies the Amazon Web Services ID of the owner of the EC2 security group specified in the <code>EC2SecurityGroupName</code> field. </p>
    pub ec2_security_group_owner_id: Option<String>,
    /// <p>Provides the status of the EC2 security group. Status can be "authorizing", "authorized", "revoking", and "revoked".</p>
    pub status: Option<String>,
}

#[allow(dead_code)]
struct EC2SecurityGroupDeserializer;
impl EC2SecurityGroupDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<EC2SecurityGroup, XmlParseError> {
        deserialize_elements::<_, EC2SecurityGroup, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "EC2SecurityGroupId" => {
                    obj.ec2_security_group_id = Some(StringDeserializer::deserialize(
                        "EC2SecurityGroupId",
                        stack,
                    )?);
                }
                "EC2SecurityGroupName" => {
                    obj.ec2_security_group_name = Some(StringDeserializer::deserialize(
                        "EC2SecurityGroupName",
                        stack,
                    )?);
                }
                "EC2SecurityGroupOwnerId" => {
                    obj.ec2_security_group_owner_id = Some(StringDeserializer::deserialize(
                        "EC2SecurityGroupOwnerId",
                        stack,
                    )?);
                }
                "Status" => {
                    obj.status = Some(StringDeserializer::deserialize("Status", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct EC2SecurityGroupListDeserializer;
impl EC2SecurityGroupListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<EC2SecurityGroup>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "EC2SecurityGroup" {
                obj.push(EC2SecurityGroupDeserializer::deserialize(
                    "EC2SecurityGroup",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>This data type represents the information you need to connect to an Amazon RDS DB instance. This data type is used as a response element in the following actions:</p> <ul> <li> <p> <code>CreateDBInstance</code> </p> </li> <li> <p> <code>DescribeDBInstances</code> </p> </li> <li> <p> <code>DeleteDBInstance</code> </p> </li> </ul> <p>For the data structure that represents Amazon Aurora DB cluster endpoints, see <code>DBClusterEndpoint</code>.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct Endpoint {
    /// <p>Specifies the DNS address of the DB instance.</p>
    pub address: Option<String>,
    /// <p>Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.</p>
    pub hosted_zone_id: Option<String>,
    /// <p>Specifies the port that the database engine is listening on.</p>
    pub port: Option<i64>,
}

#[allow(dead_code)]
struct EndpointDeserializer;
impl EndpointDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Endpoint, XmlParseError> {
        deserialize_elements::<_, Endpoint, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Address" => {
                    obj.address = Some(StringDeserializer::deserialize("Address", stack)?);
                }
                "HostedZoneId" => {
                    obj.hosted_zone_id =
                        Some(StringDeserializer::deserialize("HostedZoneId", stack)?);
                }
                "Port" => {
                    obj.port = Some(IntegerDeserializer::deserialize("Port", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p> Contains the result of a successful invocation of the <code>DescribeEngineDefaultParameters</code> action. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct EngineDefaults {
    /// <p>Specifies the name of the DB parameter group family that the engine default parameters apply to.</p>
    pub db_parameter_group_family: Option<String>,
    /// <p> An optional pagination token provided by a previous EngineDefaults request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> . </p>
    pub marker: Option<String>,
    /// <p>Contains a list of engine default parameters.</p>
    pub parameters: Option<Vec<Parameter>>,
}

#[allow(dead_code)]
struct EngineDefaultsDeserializer;
impl EngineDefaultsDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<EngineDefaults, XmlParseError> {
        deserialize_elements::<_, EngineDefaults, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "DBParameterGroupFamily" => {
                    obj.db_parameter_group_family = Some(StringDeserializer::deserialize(
                        "DBParameterGroupFamily",
                        stack,
                    )?);
                }
                "Marker" => {
                    obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                }
                "Parameters" => {
                    obj.parameters.get_or_insert(vec![]).extend(
                        ParametersListDeserializer::deserialize("Parameters", stack)?,
                    );
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct EngineModeListDeserializer;
impl EngineModeListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<String>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(StringDeserializer::deserialize("member", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}

/// Serialize `EngineModeList` contents to a `SignedRequest`.
struct EngineModeListSerializer;
impl EngineModeListSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<String>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.member.{}", name, index + 1);
            params.put(&key, &obj);
        }
    }
}

/// <p> This data type is used as a response element in the <code>DescribeEvents</code> action. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct Event {
    /// <p>Specifies the date and time of the event.</p>
    pub date: Option<String>,
    /// <p>Specifies the category for the event.</p>
    pub event_categories: Option<Vec<String>>,
    /// <p>Provides the text of this event.</p>
    pub message: Option<String>,
    /// <p>The Amazon Resource Name (ARN) for the event.</p>
    pub source_arn: Option<String>,
    /// <p>Provides the identifier for the source of the event.</p>
    pub source_identifier: Option<String>,
    /// <p>Specifies the source type for this event.</p>
    pub source_type: Option<String>,
}

#[allow(dead_code)]
struct EventDeserializer;
impl EventDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<Event, XmlParseError> {
        deserialize_elements::<_, Event, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Date" => {
                    obj.date = Some(TStampDeserializer::deserialize("Date", stack)?);
                }
                "EventCategories" => {
                    obj.event_categories.get_or_insert(vec![]).extend(
                        EventCategoriesListDeserializer::deserialize("EventCategories", stack)?,
                    );
                }
                "Message" => {
                    obj.message = Some(StringDeserializer::deserialize("Message", stack)?);
                }
                "SourceArn" => {
                    obj.source_arn = Some(StringDeserializer::deserialize("SourceArn", stack)?);
                }
                "SourceIdentifier" => {
                    obj.source_identifier =
                        Some(StringDeserializer::deserialize("SourceIdentifier", stack)?);
                }
                "SourceType" => {
                    obj.source_type =
                        Some(SourceTypeDeserializer::deserialize("SourceType", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct EventCategoriesListDeserializer;
impl EventCategoriesListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<String>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "EventCategory" {
                obj.push(StringDeserializer::deserialize("EventCategory", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}

/// Serialize `EventCategoriesList` contents to a `SignedRequest`.
struct EventCategoriesListSerializer;
impl EventCategoriesListSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<String>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.member.{}", name, index + 1);
            params.put(&key, &obj);
        }
    }
}

/// <p>Contains the results of a successful invocation of the <code>DescribeEventCategories</code> operation.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct EventCategoriesMap {
    /// <p>The event categories for the specified source type</p>
    pub event_categories: Option<Vec<String>>,
    /// <p>The source type that the returned categories belong to</p>
    pub source_type: Option<String>,
}

#[allow(dead_code)]
struct EventCategoriesMapDeserializer;
impl EventCategoriesMapDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<EventCategoriesMap, XmlParseError> {
        deserialize_elements::<_, EventCategoriesMap, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "EventCategories" => {
                    obj.event_categories.get_or_insert(vec![]).extend(
                        EventCategoriesListDeserializer::deserialize("EventCategories", stack)?,
                    );
                }
                "SourceType" => {
                    obj.source_type = Some(StringDeserializer::deserialize("SourceType", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct EventCategoriesMapListDeserializer;
impl EventCategoriesMapListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<EventCategoriesMap>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "EventCategoriesMap" {
                obj.push(EventCategoriesMapDeserializer::deserialize(
                    "EventCategoriesMap",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Data returned from the <code>DescribeEventCategories</code> operation.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct EventCategoriesMessage {
    /// <p>A list of EventCategoriesMap data types.</p>
    pub event_categories_map_list: Option<Vec<EventCategoriesMap>>,
}

#[allow(dead_code)]
struct EventCategoriesMessageDeserializer;
impl EventCategoriesMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<EventCategoriesMessage, XmlParseError> {
        deserialize_elements::<_, EventCategoriesMessage, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "EventCategoriesMapList" => {
                    obj.event_categories_map_list.get_or_insert(vec![]).extend(
                        EventCategoriesMapListDeserializer::deserialize(
                            "EventCategoriesMapList",
                            stack,
                        )?,
                    );
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct EventListDeserializer;
impl EventListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<Event>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "Event" {
                obj.push(EventDeserializer::deserialize("Event", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct EventSubscription {
    /// <p>The RDS event notification subscription Id.</p>
    pub cust_subscription_id: Option<String>,
    /// <p>The Amazon Web Services customer account associated with the RDS event notification subscription.</p>
    pub customer_aws_id: Option<String>,
    /// <p>A Boolean value indicating if the subscription is enabled. True indicates the subscription is enabled.</p>
    pub enabled: Option<bool>,
    /// <p>A list of event categories for the RDS event notification subscription.</p>
    pub event_categories_list: Option<Vec<String>>,
    /// <p>The Amazon Resource Name (ARN) for the event subscription.</p>
    pub event_subscription_arn: Option<String>,
    /// <p>The topic ARN of the RDS event notification subscription.</p>
    pub sns_topic_arn: Option<String>,
    /// <p>A list of source IDs for the RDS event notification subscription.</p>
    pub source_ids_list: Option<Vec<String>>,
    /// <p>The source type for the RDS event notification subscription.</p>
    pub source_type: Option<String>,
    /// <p>The status of the RDS event notification subscription.</p> <p>Constraints:</p> <p>Can be one of the following: creating | modifying | deleting | active | no-permission | topic-not-exist</p> <p>The status "no-permission" indicates that RDS no longer has permission to post to the SNS topic. The status "topic-not-exist" indicates that the topic was deleted after the subscription was created.</p>
    pub status: Option<String>,
    /// <p>The time the RDS event notification subscription was created.</p>
    pub subscription_creation_time: Option<String>,
}

#[allow(dead_code)]
struct EventSubscriptionDeserializer;
impl EventSubscriptionDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<EventSubscription, XmlParseError> {
        deserialize_elements::<_, EventSubscription, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "CustSubscriptionId" => {
                    obj.cust_subscription_id = Some(StringDeserializer::deserialize(
                        "CustSubscriptionId",
                        stack,
                    )?);
                }
                "CustomerAwsId" => {
                    obj.customer_aws_id =
                        Some(StringDeserializer::deserialize("CustomerAwsId", stack)?);
                }
                "Enabled" => {
                    obj.enabled = Some(BooleanDeserializer::deserialize("Enabled", stack)?);
                }
                "EventCategoriesList" => {
                    obj.event_categories_list.get_or_insert(vec![]).extend(
                        EventCategoriesListDeserializer::deserialize("EventCategoriesList", stack)?,
                    );
                }
                "EventSubscriptionArn" => {
                    obj.event_subscription_arn = Some(StringDeserializer::deserialize(
                        "EventSubscriptionArn",
                        stack,
                    )?);
                }
                "SnsTopicArn" => {
                    obj.sns_topic_arn =
                        Some(StringDeserializer::deserialize("SnsTopicArn", stack)?);
                }
                "SourceIdsList" => {
                    obj.source_ids_list.get_or_insert(vec![]).extend(
                        SourceIdsListDeserializer::deserialize("SourceIdsList", stack)?,
                    );
                }
                "SourceType" => {
                    obj.source_type = Some(StringDeserializer::deserialize("SourceType", stack)?);
                }
                "Status" => {
                    obj.status = Some(StringDeserializer::deserialize("Status", stack)?);
                }
                "SubscriptionCreationTime" => {
                    obj.subscription_creation_time = Some(StringDeserializer::deserialize(
                        "SubscriptionCreationTime",
                        stack,
                    )?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct EventSubscriptionsListDeserializer;
impl EventSubscriptionsListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<EventSubscription>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "EventSubscription" {
                obj.push(EventSubscriptionDeserializer::deserialize(
                    "EventSubscription",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Data returned by the <b>DescribeEventSubscriptions</b> action.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct EventSubscriptionsMessage {
    /// <p>A list of EventSubscriptions data types.</p>
    pub event_subscriptions_list: Option<Vec<EventSubscription>>,
    /// <p> An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    pub marker: Option<String>,
}

#[allow(dead_code)]
struct EventSubscriptionsMessageDeserializer;
impl EventSubscriptionsMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<EventSubscriptionsMessage, XmlParseError> {
        deserialize_elements::<_, EventSubscriptionsMessage, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "EventSubscriptionsList" => {
                        obj.event_subscriptions_list.get_or_insert(vec![]).extend(
                            EventSubscriptionsListDeserializer::deserialize(
                                "EventSubscriptionsList",
                                stack,
                            )?,
                        );
                    }
                    "Marker" => {
                        obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p> Contains the result of a successful invocation of the <code>DescribeEvents</code> action. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct EventsMessage {
    /// <p> A list of <code>Event</code> instances. </p>
    pub events: Option<Vec<Event>>,
    /// <p> An optional pagination token provided by a previous Events request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> . </p>
    pub marker: Option<String>,
}

#[allow(dead_code)]
struct EventsMessageDeserializer;
impl EventsMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<EventsMessage, XmlParseError> {
        deserialize_elements::<_, EventsMessage, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Events" => {
                    obj.events
                        .get_or_insert(vec![])
                        .extend(EventListDeserializer::deserialize("Events", stack)?);
                }
                "Marker" => {
                    obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>Contains the details of a snapshot export to Amazon S3. </p> <p>This data type is used as a response element in the <code>DescribeExportTasks</code> action. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ExportTask {
    /// <p><p>The data exported from the snapshot. Valid values are the following:</p> <ul> <li> <p> <code>database</code> - Export all the data from a specified database.</p> </li> <li> <p> <code>database.table</code> <i>table-name</i> - Export a table of the snapshot. This format is valid only for RDS for MySQL, RDS for MariaDB, and Aurora MySQL.</p> </li> <li> <p> <code>database.schema</code> <i>schema-name</i> - Export a database schema of the snapshot. This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.</p> </li> <li> <p> <code>database.schema.table</code> <i>table-name</i> - Export a table of the database schema. This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.</p> </li> </ul></p>
    pub export_only: Option<Vec<String>>,
    /// <p>A unique identifier for the snapshot export task. This ID isn't an identifier for the Amazon S3 bucket where the snapshot is exported to. </p>
    pub export_task_identifier: Option<String>,
    /// <p>The reason the export failed, if it failed.</p>
    pub failure_cause: Option<String>,
    /// <p>The name of the IAM role that is used to write to Amazon S3 when exporting a snapshot. </p>
    pub iam_role_arn: Option<String>,
    /// <p>The key identifier of the Amazon Web Services KMS customer master key (CMK) that is used to encrypt the snapshot when it's exported to Amazon S3. The Amazon Web Services KMS CMK identifier is its key ARN, key ID, alias ARN, or alias name. The IAM role used for the snapshot export must have encryption and decryption permissions to use this Amazon Web Services KMS CMK. </p>
    pub kms_key_id: Option<String>,
    /// <p>The progress of the snapshot export task as a percentage.</p>
    pub percent_progress: Option<i64>,
    /// <p>The Amazon S3 bucket that the snapshot is exported to.</p>
    pub s3_bucket: Option<String>,
    /// <p>The Amazon S3 bucket prefix that is the file name and path of the exported snapshot.</p>
    pub s3_prefix: Option<String>,
    /// <p>The time that the snapshot was created.</p>
    pub snapshot_time: Option<String>,
    /// <p>The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3.</p>
    pub source_arn: Option<String>,
    /// <p>The progress status of the export task.</p>
    pub status: Option<String>,
    /// <p>The time that the snapshot export task completed.</p>
    pub task_end_time: Option<String>,
    /// <p>The time that the snapshot export task started.</p>
    pub task_start_time: Option<String>,
    /// <p>The total amount of data exported, in gigabytes.</p>
    pub total_extracted_data_in_gb: Option<i64>,
    /// <p>A warning about the snapshot export task.</p>
    pub warning_message: Option<String>,
}

#[allow(dead_code)]
struct ExportTaskDeserializer;
impl ExportTaskDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ExportTask, XmlParseError> {
        deserialize_elements::<_, ExportTask, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "ExportOnly" => {
                    obj.export_only
                        .get_or_insert(vec![])
                        .extend(StringListDeserializer::deserialize("ExportOnly", stack)?);
                }
                "ExportTaskIdentifier" => {
                    obj.export_task_identifier = Some(StringDeserializer::deserialize(
                        "ExportTaskIdentifier",
                        stack,
                    )?);
                }
                "FailureCause" => {
                    obj.failure_cause =
                        Some(StringDeserializer::deserialize("FailureCause", stack)?);
                }
                "IamRoleArn" => {
                    obj.iam_role_arn = Some(StringDeserializer::deserialize("IamRoleArn", stack)?);
                }
                "KmsKeyId" => {
                    obj.kms_key_id = Some(StringDeserializer::deserialize("KmsKeyId", stack)?);
                }
                "PercentProgress" => {
                    obj.percent_progress =
                        Some(IntegerDeserializer::deserialize("PercentProgress", stack)?);
                }
                "S3Bucket" => {
                    obj.s3_bucket = Some(StringDeserializer::deserialize("S3Bucket", stack)?);
                }
                "S3Prefix" => {
                    obj.s3_prefix = Some(StringDeserializer::deserialize("S3Prefix", stack)?);
                }
                "SnapshotTime" => {
                    obj.snapshot_time =
                        Some(TStampDeserializer::deserialize("SnapshotTime", stack)?);
                }
                "SourceArn" => {
                    obj.source_arn = Some(StringDeserializer::deserialize("SourceArn", stack)?);
                }
                "Status" => {
                    obj.status = Some(StringDeserializer::deserialize("Status", stack)?);
                }
                "TaskEndTime" => {
                    obj.task_end_time =
                        Some(TStampDeserializer::deserialize("TaskEndTime", stack)?);
                }
                "TaskStartTime" => {
                    obj.task_start_time =
                        Some(TStampDeserializer::deserialize("TaskStartTime", stack)?);
                }
                "TotalExtractedDataInGB" => {
                    obj.total_extracted_data_in_gb = Some(IntegerDeserializer::deserialize(
                        "TotalExtractedDataInGB",
                        stack,
                    )?);
                }
                "WarningMessage" => {
                    obj.warning_message =
                        Some(StringDeserializer::deserialize("WarningMessage", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct ExportTasksListDeserializer;
impl ExportTasksListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<ExportTask>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "ExportTask" {
                obj.push(ExportTaskDeserializer::deserialize("ExportTask", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ExportTasksMessage {
    /// <p>Information about an export of a snapshot to Amazon S3.</p>
    pub export_tasks: Option<Vec<ExportTask>>,
    /// <p>A pagination token that can be used in a later <code>DescribeExportTasks</code> request. A marker is used for pagination to identify the location to begin output for the next response of <code>DescribeExportTasks</code>.</p>
    pub marker: Option<String>,
}

#[allow(dead_code)]
struct ExportTasksMessageDeserializer;
impl ExportTasksMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ExportTasksMessage, XmlParseError> {
        deserialize_elements::<_, ExportTasksMessage, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "ExportTasks" => {
                    obj.export_tasks.get_or_insert(vec![]).extend(
                        ExportTasksListDeserializer::deserialize("ExportTasks", stack)?,
                    );
                }
                "Marker" => {
                    obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct FailoverDBClusterMessage {
    /// <p><p>A DB cluster identifier to force a failover for. This parameter isn&#39;t case-sensitive.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing DBCluster.</p> </li> </ul></p>
    pub db_cluster_identifier: String,
    /// <p>The name of the instance to promote to the primary instance.</p> <p>You must specify the instance identifier for an Aurora Replica in the DB cluster. For example, <code>mydbcluster-replica1</code>.</p>
    pub target_db_instance_identifier: Option<String>,
}

/// Serialize `FailoverDBClusterMessage` contents to a `SignedRequest`.
struct FailoverDBClusterMessageSerializer;
impl FailoverDBClusterMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &FailoverDBClusterMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "DBClusterIdentifier"),
            &obj.db_cluster_identifier,
        );
        if let Some(ref field_value) = obj.target_db_instance_identifier {
            params.put(
                &format!("{}{}", prefix, "TargetDBInstanceIdentifier"),
                &field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct FailoverDBClusterResult {
    pub db_cluster: Option<DBCluster>,
}

#[allow(dead_code)]
struct FailoverDBClusterResultDeserializer;
impl FailoverDBClusterResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<FailoverDBClusterResult, XmlParseError> {
        deserialize_elements::<_, FailoverDBClusterResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DBCluster" => {
                        obj.db_cluster =
                            Some(DBClusterDeserializer::deserialize("DBCluster", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct FailoverGlobalClusterMessage {
    /// <p><p>Identifier of the Aurora global database (<a>GlobalCluster</a>) that should be failed over. The identifier is the unique key assigned by the user when the Aurora global database was created. In other words, it&#39;s the name of the Aurora global database that you want to fail over. </p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing <a>GlobalCluster</a> (Aurora global database).</p> </li> </ul></p>
    pub global_cluster_identifier: String,
    /// <p>Identifier of the secondary Aurora DB cluster that you want to promote to primary for the Aurora global database (<a>GlobalCluster</a>.) Use the Amazon Resource Name (ARN) for the identifier so that Aurora can locate the cluster in its Amazon Web Services Region. </p>
    pub target_db_cluster_identifier: String,
}

/// Serialize `FailoverGlobalClusterMessage` contents to a `SignedRequest`.
struct FailoverGlobalClusterMessageSerializer;
impl FailoverGlobalClusterMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &FailoverGlobalClusterMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "GlobalClusterIdentifier"),
            &obj.global_cluster_identifier,
        );
        params.put(
            &format!("{}{}", prefix, "TargetDbClusterIdentifier"),
            &obj.target_db_cluster_identifier,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct FailoverGlobalClusterResult {
    pub global_cluster: Option<GlobalCluster>,
}

#[allow(dead_code)]
struct FailoverGlobalClusterResultDeserializer;
impl FailoverGlobalClusterResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<FailoverGlobalClusterResult, XmlParseError> {
        deserialize_elements::<_, FailoverGlobalClusterResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "GlobalCluster" => {
                        obj.global_cluster = Some(GlobalClusterDeserializer::deserialize(
                            "GlobalCluster",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Contains the state of scheduled or in-process failover operations on an Aurora global database (<a>GlobalCluster</a>). This Data type is empty unless a failover operation is scheduled or is currently underway on the Aurora global database. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct FailoverState {
    /// <p>The Amazon Resource Name (ARN) of the Aurora DB cluster that is currently being demoted, and which is associated with this state. </p>
    pub from_db_cluster_arn: Option<String>,
    /// <p><p>The current status of the Aurora global database (<a>GlobalCluster</a>). Possible values are as follows: </p> <ul> <li> <p>pending &#x96; A request to fail over the Aurora global database (<a>GlobalCluster</a>) has been received by the service. The <code>GlobalCluster</code>&#39;s primary DB cluster and the specified secondary DB cluster are being verified before the failover process can start.</p> </li> <li> <p>failing-over &#x96; This status covers the range of Aurora internal operations that take place during the failover process, such as demoting the primary Aurora DB cluster, promoting the secondary Aurora DB, and synchronizing replicas. </p> </li> <li> <p>cancelling &#x96; The request to fail over the Aurora global database (<a>GlobalCluster</a>) was cancelled and the primary Aurora DB cluster and the selected secondary Aurora DB cluster are returning to their previous states. </p> </li> </ul></p>
    pub status: Option<String>,
    /// <p>The Amazon Resource Name (ARN) of the Aurora DB cluster that is currently being promoted, and which is associated with this state.</p>
    pub to_db_cluster_arn: Option<String>,
}

#[allow(dead_code)]
struct FailoverStateDeserializer;
impl FailoverStateDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<FailoverState, XmlParseError> {
        deserialize_elements::<_, FailoverState, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "FromDbClusterArn" => {
                    obj.from_db_cluster_arn =
                        Some(StringDeserializer::deserialize("FromDbClusterArn", stack)?);
                }
                "Status" => {
                    obj.status = Some(FailoverStatusDeserializer::deserialize("Status", stack)?);
                }
                "ToDbClusterArn" => {
                    obj.to_db_cluster_arn =
                        Some(StringDeserializer::deserialize("ToDbClusterArn", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct FailoverStatusDeserializer;
impl FailoverStatusDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct FeatureNameListDeserializer;
impl FeatureNameListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<String>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(StringDeserializer::deserialize("member", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p><p>A filter name and value pair that is used to return a more specific list of results from a describe operation. Filters can be used to match a set of resources by specific criteria, such as IDs. The filters supported by a describe operation are documented with the describe operation.</p> <note> <p>Currently, wildcards are not supported in filters.</p> </note> <p>The following actions can be filtered:</p> <ul> <li> <p> <code>DescribeDBClusterBacktracks</code> </p> </li> <li> <p> <code>DescribeDBClusterEndpoints</code> </p> </li> <li> <p> <code>DescribeDBClusters</code> </p> </li> <li> <p> <code>DescribeDBInstances</code> </p> </li> <li> <p> <code>DescribePendingMaintenanceActions</code> </p> </li> </ul></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct Filter {
    /// <p>The name of the filter. Filter names are case-sensitive.</p>
    pub name: String,
    /// <p>One or more filter values. Filter values are case-sensitive.</p>
    pub values: Vec<String>,
}

/// Serialize `Filter` contents to a `SignedRequest`.
struct FilterSerializer;
impl FilterSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Filter) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "Name"), &obj.name);
        FilterValueListSerializer::serialize(
            params,
            &format!("{}{}", prefix, "Value"),
            &obj.values,
        );
    }
}

/// Serialize `FilterList` contents to a `SignedRequest`.
struct FilterListSerializer;
impl FilterListSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<Filter>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.member.{}", name, index + 1);
            FilterSerializer::serialize(params, &key, obj);
        }
    }
}

/// Serialize `FilterValueList` contents to a `SignedRequest`.
struct FilterValueListSerializer;
impl FilterValueListSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<String>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.member.{}", name, index + 1);
            params.put(&key, &obj);
        }
    }
}

/// <p>A data type representing an Aurora global database.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct GlobalCluster {
    /// <p> The default database name within the new global database cluster. </p>
    pub database_name: Option<String>,
    /// <p> The deletion protection setting for the new global database cluster. </p>
    pub deletion_protection: Option<bool>,
    /// <p> The Aurora database engine used by the global database cluster. </p>
    pub engine: Option<String>,
    /// <p>Indicates the database engine version.</p>
    pub engine_version: Option<String>,
    /// <p>A data object containing all properties for the current state of an in-process or pending failover process for this Aurora global database. This object is empty unless the <a>FailoverGlobalCluster</a> API operation has been called on this Aurora global database (<a>GlobalCluster</a>). </p>
    pub failover_state: Option<FailoverState>,
    /// <p>The Amazon Resource Name (ARN) for the global database cluster.</p>
    pub global_cluster_arn: Option<String>,
    /// <p> Contains a user-supplied global database cluster identifier. This identifier is the unique key that identifies a global database cluster. </p>
    pub global_cluster_identifier: Option<String>,
    /// <p> The list of cluster IDs for secondary clusters within the global database cluster. Currently limited to 1 item. </p>
    pub global_cluster_members: Option<Vec<GlobalClusterMember>>,
    /// <p> The Amazon Web Services Region-unique, immutable identifier for the global database cluster. This identifier is found in Amazon Web Services CloudTrail log entries whenever the Amazon Web Services KMS customer master key (CMK) for the DB cluster is accessed. </p>
    pub global_cluster_resource_id: Option<String>,
    /// <p>Specifies the current state of this global database cluster.</p>
    pub status: Option<String>,
    /// <p> The storage encryption setting for the global database cluster. </p>
    pub storage_encrypted: Option<bool>,
}

#[allow(dead_code)]
struct GlobalClusterDeserializer;
impl GlobalClusterDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<GlobalCluster, XmlParseError> {
        deserialize_elements::<_, GlobalCluster, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "DatabaseName" => {
                    obj.database_name =
                        Some(StringDeserializer::deserialize("DatabaseName", stack)?);
                }
                "DeletionProtection" => {
                    obj.deletion_protection = Some(BooleanOptionalDeserializer::deserialize(
                        "DeletionProtection",
                        stack,
                    )?);
                }
                "Engine" => {
                    obj.engine = Some(StringDeserializer::deserialize("Engine", stack)?);
                }
                "EngineVersion" => {
                    obj.engine_version =
                        Some(StringDeserializer::deserialize("EngineVersion", stack)?);
                }
                "FailoverState" => {
                    obj.failover_state = Some(FailoverStateDeserializer::deserialize(
                        "FailoverState",
                        stack,
                    )?);
                }
                "GlobalClusterArn" => {
                    obj.global_cluster_arn =
                        Some(StringDeserializer::deserialize("GlobalClusterArn", stack)?);
                }
                "GlobalClusterIdentifier" => {
                    obj.global_cluster_identifier = Some(StringDeserializer::deserialize(
                        "GlobalClusterIdentifier",
                        stack,
                    )?);
                }
                "GlobalClusterMembers" => {
                    obj.global_cluster_members.get_or_insert(vec![]).extend(
                        GlobalClusterMemberListDeserializer::deserialize(
                            "GlobalClusterMembers",
                            stack,
                        )?,
                    );
                }
                "GlobalClusterResourceId" => {
                    obj.global_cluster_resource_id = Some(StringDeserializer::deserialize(
                        "GlobalClusterResourceId",
                        stack,
                    )?);
                }
                "Status" => {
                    obj.status = Some(StringDeserializer::deserialize("Status", stack)?);
                }
                "StorageEncrypted" => {
                    obj.storage_encrypted = Some(BooleanOptionalDeserializer::deserialize(
                        "StorageEncrypted",
                        stack,
                    )?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct GlobalClusterListDeserializer;
impl GlobalClusterListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<GlobalCluster>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "GlobalClusterMember" {
                obj.push(GlobalClusterDeserializer::deserialize(
                    "GlobalClusterMember",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p> A data structure with information about any primary and secondary clusters associated with an Aurora global database. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct GlobalClusterMember {
    /// <p> The Amazon Resource Name (ARN) for each Aurora cluster. </p>
    pub db_cluster_arn: Option<String>,
    /// <p>Specifies whether a secondary cluster in an Aurora global database has write forwarding enabled, not enabled, or is in the process of enabling it.</p>
    pub global_write_forwarding_status: Option<String>,
    /// <p> Specifies whether the Aurora cluster is the primary cluster (that is, has read-write capability) for the Aurora global database with which it is associated. </p>
    pub is_writer: Option<bool>,
    /// <p> The Amazon Resource Name (ARN) for each read-only secondary cluster associated with the Aurora global database. </p>
    pub readers: Option<Vec<String>>,
}

#[allow(dead_code)]
struct GlobalClusterMemberDeserializer;
impl GlobalClusterMemberDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<GlobalClusterMember, XmlParseError> {
        deserialize_elements::<_, GlobalClusterMember, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "DBClusterArn" => {
                    obj.db_cluster_arn =
                        Some(StringDeserializer::deserialize("DBClusterArn", stack)?);
                }
                "GlobalWriteForwardingStatus" => {
                    obj.global_write_forwarding_status =
                        Some(WriteForwardingStatusDeserializer::deserialize(
                            "GlobalWriteForwardingStatus",
                            stack,
                        )?);
                }
                "IsWriter" => {
                    obj.is_writer = Some(BooleanDeserializer::deserialize("IsWriter", stack)?);
                }
                "Readers" => {
                    obj.readers
                        .get_or_insert(vec![])
                        .extend(ReadersArnListDeserializer::deserialize("Readers", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct GlobalClusterMemberListDeserializer;
impl GlobalClusterMemberListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<GlobalClusterMember>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "GlobalClusterMember" {
                obj.push(GlobalClusterMemberDeserializer::deserialize(
                    "GlobalClusterMember",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct GlobalClustersMessage {
    /// <p> The list of global clusters returned by this request. </p>
    pub global_clusters: Option<Vec<GlobalCluster>>,
    /// <p> An optional pagination token provided by a previous <code>DescribeGlobalClusters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    pub marker: Option<String>,
}

#[allow(dead_code)]
struct GlobalClustersMessageDeserializer;
impl GlobalClustersMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<GlobalClustersMessage, XmlParseError> {
        deserialize_elements::<_, GlobalClustersMessage, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "GlobalClusters" => {
                    obj.global_clusters.get_or_insert(vec![]).extend(
                        GlobalClusterListDeserializer::deserialize("GlobalClusters", stack)?,
                    );
                }
                "Marker" => {
                    obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct IAMAuthModeDeserializer;
impl IAMAuthModeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p> This data type is used as a response element in the <code>DescribeDBSecurityGroups</code> action. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct IPRange {
    /// <p>Specifies the IP range.</p>
    pub cidrip: Option<String>,
    /// <p>Specifies the status of the IP range. Status can be "authorizing", "authorized", "revoking", and "revoked".</p>
    pub status: Option<String>,
}

#[allow(dead_code)]
struct IPRangeDeserializer;
impl IPRangeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<IPRange, XmlParseError> {
        deserialize_elements::<_, IPRange, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "CIDRIP" => {
                    obj.cidrip = Some(StringDeserializer::deserialize("CIDRIP", stack)?);
                }
                "Status" => {
                    obj.status = Some(StringDeserializer::deserialize("Status", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct IPRangeListDeserializer;
impl IPRangeListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<IPRange>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "IPRange" {
                obj.push(IPRangeDeserializer::deserialize("IPRange", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ImportInstallationMediaMessage {
    /// <p>The identifier of the custom Availability Zone (AZ) to import the installation media to.</p>
    pub custom_availability_zone_id: String,
    /// <p><p>The name of the database engine to be used for this instance. </p> <p>The list only includes supported DB engines that require an on-premises customer provided license. </p> <p>Valid Values: </p> <ul> <li> <p> <code>sqlserver-ee</code> </p> </li> <li> <p> <code>sqlserver-se</code> </p> </li> <li> <p> <code>sqlserver-ex</code> </p> </li> <li> <p> <code>sqlserver-web</code> </p> </li> </ul></p>
    pub engine: String,
    /// <p>The path to the installation medium for the specified DB engine.</p> <p>Example: <code>SQLServerISO/en_sql_server_2016_enterprise_x64_dvd_8701793.iso</code> </p>
    pub engine_installation_media_path: String,
    /// <p>The version number of the database engine to use.</p> <p>For a list of valid engine versions, call <a>DescribeDBEngineVersions</a>.</p> <p>The following are the database engines and links to information about the major and minor versions. The list only includes DB engines that require an on-premises customer provided license.</p> <p> <b>Microsoft SQL Server</b> </p> <p>See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.VersionSupport"> Microsoft SQL Server Versions on Amazon RDS</a> in the <i>Amazon RDS User Guide.</i> </p>
    pub engine_version: String,
    /// <p>The path to the installation medium for the operating system associated with the specified DB engine.</p> <p>Example: <code>WindowsISO/en_windows_server_2016_x64_dvd_9327751.iso</code> </p>
    pub os_installation_media_path: String,
}

/// Serialize `ImportInstallationMediaMessage` contents to a `SignedRequest`.
struct ImportInstallationMediaMessageSerializer;
impl ImportInstallationMediaMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ImportInstallationMediaMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "CustomAvailabilityZoneId"),
            &obj.custom_availability_zone_id,
        );
        params.put(&format!("{}{}", prefix, "Engine"), &obj.engine);
        params.put(
            &format!("{}{}", prefix, "EngineInstallationMediaPath"),
            &obj.engine_installation_media_path,
        );
        params.put(
            &format!("{}{}", prefix, "EngineVersion"),
            &obj.engine_version,
        );
        params.put(
            &format!("{}{}", prefix, "OSInstallationMediaPath"),
            &obj.os_installation_media_path,
        );
    }
}

/// <p>Contains the installation media for a DB engine that requires an on-premises customer provided license, such as Microsoft SQL Server.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct InstallationMedia {
    /// <p>The custom Availability Zone (AZ) that contains the installation media.</p>
    pub custom_availability_zone_id: Option<String>,
    /// <p>The DB engine.</p>
    pub engine: Option<String>,
    /// <p>The path to the installation medium for the DB engine.</p>
    pub engine_installation_media_path: Option<String>,
    /// <p>The engine version of the DB engine.</p>
    pub engine_version: Option<String>,
    /// <p>If an installation media failure occurred, the cause of the failure.</p>
    pub failure_cause: Option<InstallationMediaFailureCause>,
    /// <p>The installation medium ID.</p>
    pub installation_media_id: Option<String>,
    /// <p>The path to the installation medium for the operating system associated with the DB engine.</p>
    pub os_installation_media_path: Option<String>,
    /// <p>The status of the installation medium.</p>
    pub status: Option<String>,
}

#[allow(dead_code)]
struct InstallationMediaDeserializer;
impl InstallationMediaDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<InstallationMedia, XmlParseError> {
        deserialize_elements::<_, InstallationMedia, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "CustomAvailabilityZoneId" => {
                    obj.custom_availability_zone_id = Some(StringDeserializer::deserialize(
                        "CustomAvailabilityZoneId",
                        stack,
                    )?);
                }
                "Engine" => {
                    obj.engine = Some(StringDeserializer::deserialize("Engine", stack)?);
                }
                "EngineInstallationMediaPath" => {
                    obj.engine_installation_media_path = Some(StringDeserializer::deserialize(
                        "EngineInstallationMediaPath",
                        stack,
                    )?);
                }
                "EngineVersion" => {
                    obj.engine_version =
                        Some(StringDeserializer::deserialize("EngineVersion", stack)?);
                }
                "FailureCause" => {
                    obj.failure_cause =
                        Some(InstallationMediaFailureCauseDeserializer::deserialize(
                            "FailureCause",
                            stack,
                        )?);
                }
                "InstallationMediaId" => {
                    obj.installation_media_id = Some(StringDeserializer::deserialize(
                        "InstallationMediaId",
                        stack,
                    )?);
                }
                "OSInstallationMediaPath" => {
                    obj.os_installation_media_path = Some(StringDeserializer::deserialize(
                        "OSInstallationMediaPath",
                        stack,
                    )?);
                }
                "Status" => {
                    obj.status = Some(StringDeserializer::deserialize("Status", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>Contains the cause of an installation media failure. Installation media is used for a DB engine that requires an on-premises customer provided license, such as Microsoft SQL Server.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct InstallationMediaFailureCause {
    /// <p>The reason that an installation media import failed.</p>
    pub message: Option<String>,
}

#[allow(dead_code)]
struct InstallationMediaFailureCauseDeserializer;
impl InstallationMediaFailureCauseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<InstallationMediaFailureCause, XmlParseError> {
        deserialize_elements::<_, InstallationMediaFailureCause, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Message" => {
                        obj.message = Some(StringDeserializer::deserialize("Message", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct InstallationMediaListDeserializer;
impl InstallationMediaListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<InstallationMedia>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "InstallationMedia" {
                obj.push(InstallationMediaDeserializer::deserialize(
                    "InstallationMedia",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct InstallationMediaMessage {
    /// <p>The list of <a>InstallationMedia</a> objects for the Amazon Web Services account.</p>
    pub installation_media: Option<Vec<InstallationMedia>>,
    /// <p>An optional pagination token provided by a previous <a>DescribeInstallationMedia</a> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub marker: Option<String>,
}

#[allow(dead_code)]
struct InstallationMediaMessageDeserializer;
impl InstallationMediaMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<InstallationMediaMessage, XmlParseError> {
        deserialize_elements::<_, InstallationMediaMessage, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "InstallationMedia" => {
                        obj.installation_media.get_or_insert(vec![]).extend(
                            InstallationMediaListDeserializer::deserialize(
                                "InstallationMedia",
                                stack,
                            )?,
                        );
                    }
                    "Marker" => {
                        obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct IntegerDeserializer;
impl IntegerDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<i64, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, |s| Ok(i64::from_str(&s).unwrap()))
    }
}
#[allow(dead_code)]
struct IntegerOptionalDeserializer;
impl IntegerOptionalDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<i64, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, |s| Ok(i64::from_str(&s).unwrap()))
    }
}

/// Serialize `KeyList` contents to a `SignedRequest`.
struct KeyListSerializer;
impl KeyListSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<String>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.member.{}", name, index + 1);
            params.put(&key, &obj);
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListTagsForResourceMessage {
    /// <p>This parameter isn't currently supported.</p>
    pub filters: Option<Vec<Filter>>,
    /// <p>The Amazon RDS resource with tags to be listed. This value is an Amazon Resource Name (ARN). For information about creating an ARN, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing"> Constructing an ARN for Amazon RDS</a> in the <i>Amazon RDS User Guide</i>.</p>
    pub resource_name: String,
}

/// Serialize `ListTagsForResourceMessage` contents to a `SignedRequest`.
struct ListTagsForResourceMessageSerializer;
impl ListTagsForResourceMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ListTagsForResourceMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        params.put(&format!("{}{}", prefix, "ResourceName"), &obj.resource_name);
    }
}

#[allow(dead_code)]
struct LogTypeListDeserializer;
impl LogTypeListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<String>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(StringDeserializer::deserialize("member", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}

/// Serialize `LogTypeList` contents to a `SignedRequest`.
struct LogTypeListSerializer;
impl LogTypeListSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<String>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.member.{}", name, index + 1);
            params.put(&key, &obj);
        }
    }
}

#[allow(dead_code)]
struct LongDeserializer;
impl LongDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<i64, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, |s| Ok(i64::from_str(&s).unwrap()))
    }
}
#[allow(dead_code)]
struct LongOptionalDeserializer;
impl LongOptionalDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<i64, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, |s| Ok(i64::from_str(&s).unwrap()))
    }
}
/// <p>The minimum DB engine version required for each corresponding allowed value for an option setting.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct MinimumEngineVersionPerAllowedValue {
    /// <p>The allowed value for an option setting.</p>
    pub allowed_value: Option<String>,
    /// <p>The minimum DB engine version required for the allowed value.</p>
    pub minimum_engine_version: Option<String>,
}

#[allow(dead_code)]
struct MinimumEngineVersionPerAllowedValueDeserializer;
impl MinimumEngineVersionPerAllowedValueDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<MinimumEngineVersionPerAllowedValue, XmlParseError> {
        deserialize_elements::<_, MinimumEngineVersionPerAllowedValue, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "AllowedValue" => {
                        obj.allowed_value =
                            Some(StringDeserializer::deserialize("AllowedValue", stack)?);
                    }
                    "MinimumEngineVersion" => {
                        obj.minimum_engine_version = Some(StringDeserializer::deserialize(
                            "MinimumEngineVersion",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct MinimumEngineVersionPerAllowedValueListDeserializer;
impl MinimumEngineVersionPerAllowedValueListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<MinimumEngineVersionPerAllowedValue>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "MinimumEngineVersionPerAllowedValue" {
                obj.push(
                    MinimumEngineVersionPerAllowedValueDeserializer::deserialize(
                        "MinimumEngineVersionPerAllowedValue",
                        stack,
                    )?,
                );
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ModifyCertificatesMessage {
    /// <p>The new default certificate identifier to override the current one with.</p> <p>To determine the valid values, use the <code>describe-certificates</code> CLI command or the <code>DescribeCertificates</code> API operation.</p>
    pub certificate_identifier: Option<String>,
    /// <p>A value that indicates whether to remove the override for the default certificate. If the override is removed, the default certificate is the system default.</p>
    pub remove_customer_override: Option<bool>,
}

/// Serialize `ModifyCertificatesMessage` contents to a `SignedRequest`.
struct ModifyCertificatesMessageSerializer;
impl ModifyCertificatesMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ModifyCertificatesMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.certificate_identifier {
            params.put(
                &format!("{}{}", prefix, "CertificateIdentifier"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.remove_customer_override {
            params.put(
                &format!("{}{}", prefix, "RemoveCustomerOverride"),
                &field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ModifyCertificatesResult {
    pub certificate: Option<Certificate>,
}

#[allow(dead_code)]
struct ModifyCertificatesResultDeserializer;
impl ModifyCertificatesResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ModifyCertificatesResult, XmlParseError> {
        deserialize_elements::<_, ModifyCertificatesResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Certificate" => {
                        obj.certificate =
                            Some(CertificateDeserializer::deserialize("Certificate", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ModifyCurrentDBClusterCapacityMessage {
    /// <p><p>The DB cluster capacity.</p> <p>When you change the capacity of a paused Aurora Serverless DB cluster, it automatically resumes.</p> <p>Constraints:</p> <ul> <li> <p>For Aurora MySQL, valid capacity values are <code>1</code>, <code>2</code>, <code>4</code>, <code>8</code>, <code>16</code>, <code>32</code>, <code>64</code>, <code>128</code>, and <code>256</code>.</p> </li> <li> <p>For Aurora PostgreSQL, valid capacity values are <code>2</code>, <code>4</code>, <code>8</code>, <code>16</code>, <code>32</code>, <code>64</code>, <code>192</code>, and <code>384</code>.</p> </li> </ul></p>
    pub capacity: Option<i64>,
    /// <p><p>The DB cluster identifier for the cluster being modified. This parameter isn&#39;t case-sensitive.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing DB cluster.</p> </li> </ul></p>
    pub db_cluster_identifier: String,
    /// <p><p>The amount of time, in seconds, that Aurora Serverless tries to find a scaling point to perform seamless scaling before enforcing the timeout action. The default is 300.</p> <ul> <li> <p>Value must be from 10 through 600.</p> </li> </ul></p>
    pub seconds_before_timeout: Option<i64>,
    /// <p>The action to take when the timeout is reached, either <code>ForceApplyCapacityChange</code> or <code>RollbackCapacityChange</code>.</p> <p> <code>ForceApplyCapacityChange</code>, the default, sets the capacity to the specified value as soon as possible.</p> <p> <code>RollbackCapacityChange</code> ignores the capacity change if a scaling point isn't found in the timeout period.</p>
    pub timeout_action: Option<String>,
}

/// Serialize `ModifyCurrentDBClusterCapacityMessage` contents to a `SignedRequest`.
struct ModifyCurrentDBClusterCapacityMessageSerializer;
impl ModifyCurrentDBClusterCapacityMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ModifyCurrentDBClusterCapacityMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.capacity {
            params.put(&format!("{}{}", prefix, "Capacity"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "DBClusterIdentifier"),
            &obj.db_cluster_identifier,
        );
        if let Some(ref field_value) = obj.seconds_before_timeout {
            params.put(
                &format!("{}{}", prefix, "SecondsBeforeTimeout"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.timeout_action {
            params.put(&format!("{}{}", prefix, "TimeoutAction"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ModifyDBClusterEndpointMessage {
    /// <p>The identifier of the endpoint to modify. This parameter is stored as a lowercase string.</p>
    pub db_cluster_endpoint_identifier: String,
    /// <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>
    pub endpoint_type: Option<String>,
    /// <p>List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.</p>
    pub excluded_members: Option<Vec<String>>,
    /// <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
    pub static_members: Option<Vec<String>>,
}

/// Serialize `ModifyDBClusterEndpointMessage` contents to a `SignedRequest`.
struct ModifyDBClusterEndpointMessageSerializer;
impl ModifyDBClusterEndpointMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ModifyDBClusterEndpointMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "DBClusterEndpointIdentifier"),
            &obj.db_cluster_endpoint_identifier,
        );
        if let Some(ref field_value) = obj.endpoint_type {
            params.put(&format!("{}{}", prefix, "EndpointType"), &field_value);
        }
        if let Some(ref field_value) = obj.excluded_members {
            StringListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "ExcludedMembers"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.static_members {
            StringListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "StaticMembers"),
                field_value,
            );
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ModifyDBClusterMessage {
    /// <p>A value that indicates whether major version upgrades are allowed.</p> <p>Constraints: You must allow major version upgrades when specifying a value for the <code>EngineVersion</code> parameter that is a different major version than the DB cluster's current version.</p>
    pub allow_major_version_upgrade: Option<bool>,
    /// <p>A value that indicates whether the modifications in this request and any pending modifications are asynchronously applied as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code> setting for the DB cluster. If this parameter is disabled, changes to the DB cluster are applied during the next maintenance window.</p> <p>The <code>ApplyImmediately</code> parameter only affects the <code>EnableIAMDatabaseAuthentication</code>, <code>MasterUserPassword</code>, and <code>NewDBClusterIdentifier</code> values. If the <code>ApplyImmediately</code> parameter is disabled, then changes to the <code>EnableIAMDatabaseAuthentication</code>, <code>MasterUserPassword</code>, and <code>NewDBClusterIdentifier</code> values are applied during the next maintenance window. All other changes are applied immediately, regardless of the value of the <code>ApplyImmediately</code> parameter.</p> <p>By default, this parameter is disabled.</p>
    pub apply_immediately: Option<bool>,
    /// <p><p>The target backtrack window, in seconds. To disable backtracking, set this value to 0.</p> <note> <p>Currently, Backtrack is only supported for Aurora MySQL DB clusters.</p> </note> <p>Default: 0</p> <p>Constraints:</p> <ul> <li> <p>If specified, this value must be set to a number from 0 to 259,200 (72 hours).</p> </li> </ul></p>
    pub backtrack_window: Option<i64>,
    /// <p><p>The number of days for which automated backups are retained. You must specify a minimum value of 1.</p> <p>Default: 1</p> <p>Constraints:</p> <ul> <li> <p>Must be a value from 1 to 35</p> </li> </ul></p>
    pub backup_retention_period: Option<i64>,
    /// <p>The configuration setting for the log types to be enabled for export to CloudWatch Logs for a specific DB cluster.</p>
    pub cloudwatch_logs_export_configuration: Option<CloudwatchLogsExportConfiguration>,
    /// <p>A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster. The default is not to copy them.</p>
    pub copy_tags_to_snapshot: Option<bool>,
    /// <p>The DB cluster identifier for the cluster being modified. This parameter isn't case-sensitive.</p> <p>Constraints: This identifier must match the identifier of an existing DB cluster.</p>
    pub db_cluster_identifier: String,
    /// <p>The name of the DB cluster parameter group to use for the DB cluster.</p>
    pub db_cluster_parameter_group_name: Option<String>,
    /// <p><p>The name of the DB parameter group to apply to all instances of the DB cluster. </p> <note> <p>When you apply a parameter group using the <code>DBInstanceParameterGroupName</code> parameter, the DB cluster isn&#39;t rebooted automatically. Also, parameter changes aren&#39;t applied during the next maintenance window but instead are applied immediately.</p> </note> <p>Default: The existing name setting</p> <p>Constraints:</p> <ul> <li> <p>The DB parameter group must be in the same DB parameter group family as this DB cluster.</p> </li> <li> <p>The <code>DBInstanceParameterGroupName</code> parameter is only valid in combination with the <code>AllowMajorVersionUpgrade</code> parameter.</p> </li> </ul></p>
    pub db_instance_parameter_group_name: Option<String>,
    /// <p>A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled. </p>
    pub deletion_protection: Option<bool>,
    /// <p>The Active Directory directory ID to move the DB cluster to. Specify <code>none</code> to remove the cluster from its current domain. The domain must be created prior to this operation. </p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html">Kerberos Authentication</a> in the <i>Amazon Aurora User Guide</i>. </p>
    pub domain: Option<String>,
    /// <p>Specify the name of the IAM role to be used when making API calls to the Directory Service.</p>
    pub domain_iam_role_name: Option<String>,
    /// <p>A value that indicates whether to enable this DB cluster to forward write operations to the primary cluster of an Aurora global database (<a>GlobalCluster</a>). By default, write operations are not allowed on Aurora DB clusters that are secondary clusters in an Aurora global database.</p> <p>You can set this value only on Aurora DB clusters that are members of an Aurora global database. With this parameter enabled, a secondary cluster can forward writes to the current primary cluster and the resulting changes are replicated back to this cluster. For the primary DB cluster of an Aurora global database, this value is used immediately if the primary is demoted by the <a>FailoverGlobalCluster</a> API operation, but it does nothing until then. </p>
    pub enable_global_write_forwarding: Option<bool>,
    /// <p>A value that indicates whether to enable the HTTP endpoint for an Aurora Serverless DB cluster. By default, the HTTP endpoint is disabled.</p> <p>When enabled, the HTTP endpoint provides a connectionless web service API for running SQL queries on the Aurora Serverless DB cluster. You can also query your database from inside the RDS console with the query editor.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using the Data API for Aurora Serverless</a> in the <i>Amazon Aurora User Guide</i>.</p>
    pub enable_http_endpoint: Option<bool>,
    /// <p>A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping is disabled.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database Authentication</a> in the <i>Amazon Aurora User Guide.</i> </p>
    pub enable_iam_database_authentication: Option<bool>,
    /// <p>The version number of the database engine to which you want to upgrade. Changing this parameter results in an outage. The change is applied during the next maintenance window unless <code>ApplyImmediately</code> is enabled.</p> <p>To list all of the available engine versions for <code>aurora</code> (for MySQL 5.6-compatible Aurora), use the following command:</p> <p> <code>aws rds describe-db-engine-versions --engine aurora --query "DBEngineVersions[].EngineVersion"</code> </p> <p>To list all of the available engine versions for <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora), use the following command:</p> <p> <code>aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"</code> </p> <p>To list all of the available engine versions for <code>aurora-postgresql</code>, use the following command:</p> <p> <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"</code> </p>
    pub engine_version: Option<String>,
    /// <p>The new password for the master database user. This password can contain any printable ASCII character except "/", """, or "@".</p> <p>Constraints: Must contain from 8 to 41 characters.</p>
    pub master_user_password: Option<String>,
    /// <p>The new DB cluster identifier for the DB cluster when renaming a DB cluster. This value is stored as a lowercase string.</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens</p> </li> <li> <p>The first character must be a letter</p> </li> <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li> </ul> <p>Example: <code>my-cluster2</code> </p>
    pub new_db_cluster_identifier: Option<String>,
    /// <p>A value that indicates that the DB cluster should be associated with the specified option group. Changing this parameter doesn't result in an outage except in the following case, and the change is applied during the next maintenance window unless the <code>ApplyImmediately</code> is enabled for this request. If the parameter change results in an option group that enables OEM, this change can cause a brief (sub-second) period during which new connections are rejected but existing connections are not interrupted. </p> <p>Permanent options can't be removed from an option group. The option group can't be removed from a DB cluster once it is associated with a DB cluster.</p>
    pub option_group_name: Option<String>,
    /// <p>The port number on which the DB cluster accepts connections.</p> <p>Constraints: Value must be <code>1150-65535</code> </p> <p>Default: The same port as the original DB cluster.</p>
    pub port: Option<i64>,
    /// <p><p>The daily time range during which automated backups are created if automated backups are enabled, using the <code>BackupRetentionPeriod</code> parameter. </p> <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region. To view the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow"> Backup window</a> in the <i>Amazon Aurora User Guide.</i> </p> <p>Constraints:</p> <ul> <li> <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p> </li> <li> <p>Must be in Universal Coordinated Time (UTC).</p> </li> <li> <p>Must not conflict with the preferred maintenance window.</p> </li> <li> <p>Must be at least 30 minutes.</p> </li> </ul></p>
    pub preferred_backup_window: Option<String>,
    /// <p>The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p> <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code> </p> <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region, occurring on a random day of the week. To see the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora"> Adjusting the Preferred DB Cluster Maintenance Window</a> in the <i>Amazon Aurora User Guide.</i> </p> <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p> <p>Constraints: Minimum 30-minute window.</p>
    pub preferred_maintenance_window: Option<String>,
    /// <p>The scaling properties of the DB cluster. You can only modify scaling properties for DB clusters in <code>serverless</code> DB engine mode.</p>
    pub scaling_configuration: Option<ScalingConfiguration>,
    /// <p>A list of VPC security groups that the DB cluster will belong to.</p>
    pub vpc_security_group_ids: Option<Vec<String>>,
}

/// Serialize `ModifyDBClusterMessage` contents to a `SignedRequest`.
struct ModifyDBClusterMessageSerializer;
impl ModifyDBClusterMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ModifyDBClusterMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.allow_major_version_upgrade {
            params.put(
                &format!("{}{}", prefix, "AllowMajorVersionUpgrade"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.apply_immediately {
            params.put(&format!("{}{}", prefix, "ApplyImmediately"), &field_value);
        }
        if let Some(ref field_value) = obj.backtrack_window {
            params.put(&format!("{}{}", prefix, "BacktrackWindow"), &field_value);
        }
        if let Some(ref field_value) = obj.backup_retention_period {
            params.put(
                &format!("{}{}", prefix, "BackupRetentionPeriod"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.cloudwatch_logs_export_configuration {
            CloudwatchLogsExportConfigurationSerializer::serialize(
                params,
                &format!("{}{}", prefix, "CloudwatchLogsExportConfiguration"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.copy_tags_to_snapshot {
            params.put(&format!("{}{}", prefix, "CopyTagsToSnapshot"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "DBClusterIdentifier"),
            &obj.db_cluster_identifier,
        );
        if let Some(ref field_value) = obj.db_cluster_parameter_group_name {
            params.put(
                &format!("{}{}", prefix, "DBClusterParameterGroupName"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.db_instance_parameter_group_name {
            params.put(
                &format!("{}{}", prefix, "DBInstanceParameterGroupName"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.deletion_protection {
            params.put(&format!("{}{}", prefix, "DeletionProtection"), &field_value);
        }
        if let Some(ref field_value) = obj.domain {
            params.put(&format!("{}{}", prefix, "Domain"), &field_value);
        }
        if let Some(ref field_value) = obj.domain_iam_role_name {
            params.put(&format!("{}{}", prefix, "DomainIAMRoleName"), &field_value);
        }
        if let Some(ref field_value) = obj.enable_global_write_forwarding {
            params.put(
                &format!("{}{}", prefix, "EnableGlobalWriteForwarding"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.enable_http_endpoint {
            params.put(&format!("{}{}", prefix, "EnableHttpEndpoint"), &field_value);
        }
        if let Some(ref field_value) = obj.enable_iam_database_authentication {
            params.put(
                &format!("{}{}", prefix, "EnableIAMDatabaseAuthentication"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.engine_version {
            params.put(&format!("{}{}", prefix, "EngineVersion"), &field_value);
        }
        if let Some(ref field_value) = obj.master_user_password {
            params.put(&format!("{}{}", prefix, "MasterUserPassword"), &field_value);
        }
        if let Some(ref field_value) = obj.new_db_cluster_identifier {
            params.put(
                &format!("{}{}", prefix, "NewDBClusterIdentifier"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.option_group_name {
            params.put(&format!("{}{}", prefix, "OptionGroupName"), &field_value);
        }
        if let Some(ref field_value) = obj.port {
            params.put(&format!("{}{}", prefix, "Port"), &field_value);
        }
        if let Some(ref field_value) = obj.preferred_backup_window {
            params.put(
                &format!("{}{}", prefix, "PreferredBackupWindow"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.preferred_maintenance_window {
            params.put(
                &format!("{}{}", prefix, "PreferredMaintenanceWindow"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.scaling_configuration {
            ScalingConfigurationSerializer::serialize(
                params,
                &format!("{}{}", prefix, "ScalingConfiguration"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.vpc_security_group_ids {
            VpcSecurityGroupIdListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "VpcSecurityGroupId"),
                field_value,
            );
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ModifyDBClusterParameterGroupMessage {
    /// <p>The name of the DB cluster parameter group to modify.</p>
    pub db_cluster_parameter_group_name: String,
    /// <p><p>A list of parameters in the DB cluster parameter group to modify.</p> <p>Valid Values (for the application method): <code>immediate | pending-reboot</code> </p> <note> <p>You can use the <code>immediate</code> value with dynamic parameters only. You can use the <code>pending-reboot</code> value for both dynamic and static parameters.</p> <p>When the application method is <code>immediate</code>, changes to dynamic parameters are applied immediately to the DB clusters associated with the parameter group. When the application method is <code>pending-reboot</code>, changes to dynamic and static parameters are applied after a reboot without failover to the DB clusters associated with the parameter group.</p> </note></p>
    pub parameters: Vec<Parameter>,
}

/// Serialize `ModifyDBClusterParameterGroupMessage` contents to a `SignedRequest`.
struct ModifyDBClusterParameterGroupMessageSerializer;
impl ModifyDBClusterParameterGroupMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ModifyDBClusterParameterGroupMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "DBClusterParameterGroupName"),
            &obj.db_cluster_parameter_group_name,
        );
        ParametersListSerializer::serialize(
            params,
            &format!("{}{}", prefix, "Parameter"),
            &obj.parameters,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ModifyDBClusterResult {
    pub db_cluster: Option<DBCluster>,
}

#[allow(dead_code)]
struct ModifyDBClusterResultDeserializer;
impl ModifyDBClusterResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ModifyDBClusterResult, XmlParseError> {
        deserialize_elements::<_, ModifyDBClusterResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "DBCluster" => {
                    obj.db_cluster = Some(DBClusterDeserializer::deserialize("DBCluster", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ModifyDBClusterSnapshotAttributeMessage {
    /// <p><p>The name of the DB cluster snapshot attribute to modify.</p> <p>To manage authorization for other Amazon Web Services accounts to copy or restore a manual DB cluster snapshot, set this value to <code>restore</code>.</p> <note> <p>To view the list of attributes available to modify, use the <a>DescribeDBClusterSnapshotAttributes</a> API action.</p> </note></p>
    pub attribute_name: String,
    /// <p>The identifier for the DB cluster snapshot to modify the attributes for.</p>
    pub db_cluster_snapshot_identifier: String,
    /// <p>A list of DB cluster snapshot attributes to add to the attribute specified by <code>AttributeName</code>.</p> <p>To authorize other Amazon Web Services accounts to copy or restore a manual DB cluster snapshot, set this list to include one or more Amazon Web Services account IDs, or <code>all</code> to make the manual DB cluster snapshot restorable by any Amazon Web Services account. Do not add the <code>all</code> value for any manual DB cluster snapshots that contain private information that you don't want available to all Amazon Web Services accounts.</p>
    pub values_to_add: Option<Vec<String>>,
    /// <p>A list of DB cluster snapshot attributes to remove from the attribute specified by <code>AttributeName</code>.</p> <p>To remove authorization for other Amazon Web Services accounts to copy or restore a manual DB cluster snapshot, set this list to include one or more Amazon Web Services account identifiers, or <code>all</code> to remove authorization for any Amazon Web Services account to copy or restore the DB cluster snapshot. If you specify <code>all</code>, an Amazon Web Services account whose account ID is explicitly added to the <code>restore</code> attribute can still copy or restore a manual DB cluster snapshot.</p>
    pub values_to_remove: Option<Vec<String>>,
}

/// Serialize `ModifyDBClusterSnapshotAttributeMessage` contents to a `SignedRequest`.
struct ModifyDBClusterSnapshotAttributeMessageSerializer;
impl ModifyDBClusterSnapshotAttributeMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ModifyDBClusterSnapshotAttributeMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "AttributeName"),
            &obj.attribute_name,
        );
        params.put(
            &format!("{}{}", prefix, "DBClusterSnapshotIdentifier"),
            &obj.db_cluster_snapshot_identifier,
        );
        if let Some(ref field_value) = obj.values_to_add {
            AttributeValueListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "AttributeValue"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.values_to_remove {
            AttributeValueListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "AttributeValue"),
                field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ModifyDBClusterSnapshotAttributeResult {
    pub db_cluster_snapshot_attributes_result: Option<DBClusterSnapshotAttributesResult>,
}

#[allow(dead_code)]
struct ModifyDBClusterSnapshotAttributeResultDeserializer;
impl ModifyDBClusterSnapshotAttributeResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ModifyDBClusterSnapshotAttributeResult, XmlParseError> {
        deserialize_elements::<_, ModifyDBClusterSnapshotAttributeResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DBClusterSnapshotAttributesResult" => {
                        obj.db_cluster_snapshot_attributes_result =
                            Some(DBClusterSnapshotAttributesResultDeserializer::deserialize(
                                "DBClusterSnapshotAttributesResult",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ModifyDBInstanceMessage {
    /// <p>The new amount of storage (in gibibytes) to allocate for the DB instance. </p> <p>For MariaDB, MySQL, Oracle, and PostgreSQL, the value supplied must be at least 10% greater than the current value. Values that are not at least 10% greater than the existing value are rounded up so that they are 10% greater than the current value. </p> <p>For the valid values for allocated storage for each engine, see <code>CreateDBInstance</code>. </p>
    pub allocated_storage: Option<i64>,
    /// <p>A value that indicates whether major version upgrades are allowed. Changing this parameter doesn't result in an outage and the change is asynchronously applied as soon as possible.</p> <p>Constraints: Major version upgrades must be allowed when specifying a value for the EngineVersion parameter that is a different major version than the DB instance's current version.</p>
    pub allow_major_version_upgrade: Option<bool>,
    /// <p>A value that indicates whether the modifications in this request and any pending modifications are asynchronously applied as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code> setting for the DB instance. By default, this parameter is disabled. </p> <p> If this parameter is disabled, changes to the DB instance are applied during the next maintenance window. Some parameter changes can cause an outage and are applied on the next call to <a>RebootDBInstance</a>, or the next failure reboot. Review the table of parameters in <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.DBInstance.Modifying.html">Modifying a DB Instance</a> in the <i>Amazon RDS User Guide.</i> to see the impact of enabling or disabling <code>ApplyImmediately</code> for each modified parameter and to determine when the changes are applied. </p>
    pub apply_immediately: Option<bool>,
    /// <p> A value that indicates whether minor version upgrades are applied automatically to the DB instance during the maintenance window. Changing this parameter doesn't result in an outage except in the following case and the change is asynchronously applied as soon as possible. An outage results if this parameter is enabled during the maintenance window, and a newer minor version is available, and RDS has enabled auto patching for that engine version. </p>
    pub auto_minor_version_upgrade: Option<bool>,
    /// <p>The Amazon Resource Name (ARN) of the recovery point in Amazon Web Services Backup.</p>
    pub aws_backup_recovery_point_arn: Option<String>,
    /// <p><p>The number of days to retain automated backups. Setting this parameter to a positive number enables backups. Setting this parameter to 0 disables automated backups.</p> <note> <p>Enabling and disabling backups can result in a brief I/O suspension that lasts from a few seconds to a few minutes, depending on the size and class of your DB instance.</p> </note> <p>These changes are applied during the next maintenance window unless the <code>ApplyImmediately</code> parameter is enabled for this request. If you change the parameter from one non-zero value to another non-zero value, the change is asynchronously applied as soon as possible.</p> <p> <b>Amazon Aurora</b> </p> <p>Not applicable. The retention period for automated backups is managed by the DB cluster. For more information, see <code>ModifyDBCluster</code>.</p> <p>Default: Uses existing setting</p> <p>Constraints:</p> <ul> <li> <p>Must be a value from 0 to 35</p> </li> <li> <p>Can be specified for a MySQL read replica only if the source is running MySQL 5.6 or later</p> </li> <li> <p>Can be specified for a PostgreSQL read replica only if the source is running PostgreSQL 9.3.5</p> </li> <li> <p>Can&#39;t be set to 0 if the DB instance is a source to read replicas</p> </li> </ul></p>
    pub backup_retention_period: Option<i64>,
    /// <p>Indicates the certificate that needs to be associated with the instance.</p>
    pub ca_certificate_identifier: Option<String>,
    /// <p><p>A value that indicates whether the DB instance is restarted when you rotate your SSL/TLS certificate.</p> <p>By default, the DB instance is restarted when you rotate your SSL/TLS certificate. The certificate is not updated until the DB instance is restarted.</p> <important> <p>Set this parameter only if you are <i>not</i> using SSL/TLS to connect to the DB instance.</p> </important> <p>If you are using SSL/TLS to connect to the DB instance, follow the appropriate instructions for your DB engine to rotate your SSL/TLS certificate:</p> <ul> <li> <p>For more information about rotating your SSL/TLS certificate for RDS DB engines, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL-certificate-rotation.html"> Rotating Your SSL/TLS Certificate.</a> in the <i>Amazon RDS User Guide.</i> </p> </li> <li> <p>For more information about rotating your SSL/TLS certificate for Aurora DB engines, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL-certificate-rotation.html"> Rotating Your SSL/TLS Certificate</a> in the <i>Amazon Aurora User Guide.</i> </p> </li> </ul></p>
    pub certificate_rotation_restart: Option<bool>,
    /// <p>The configuration setting for the log types to be enabled for export to CloudWatch Logs for a specific DB instance.</p> <p>A change to the <code>CloudwatchLogsExportConfiguration</code> parameter is always applied to the DB instance immediately. Therefore, the <code>ApplyImmediately</code> parameter has no effect.</p>
    pub cloudwatch_logs_export_configuration: Option<CloudwatchLogsExportConfiguration>,
    /// <p>A value that indicates whether to copy all tags from the DB instance to snapshots of the DB instance. By default, tags are not copied.</p> <p> <b>Amazon Aurora</b> </p> <p>Not applicable. Copying tags to snapshots is managed by the DB cluster. Setting this value for an Aurora DB instance has no effect on the DB cluster setting. For more information, see <code>ModifyDBCluster</code>.</p>
    pub copy_tags_to_snapshot: Option<bool>,
    /// <p>The new compute and memory capacity of the DB instance, for example, <code>db.m4.large</code>. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines. For the full list of DB instance classes, and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB Instance Class</a> in the <i>Amazon RDS User Guide.</i> </p> <p>If you modify the DB instance class, an outage occurs during the change. The change is applied during the next maintenance window, unless <code>ApplyImmediately</code> is enabled for this request. </p> <p>Default: Uses existing setting</p>
    pub db_instance_class: Option<String>,
    /// <p><p>The DB instance identifier. This value is stored as a lowercase string.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing DBInstance.</p> </li> </ul></p>
    pub db_instance_identifier: String,
    /// <p>The name of the DB parameter group to apply to the DB instance. Changing this setting doesn't result in an outage. The parameter group name itself is changed immediately, but the actual parameter changes are not applied until you reboot the instance without failover. In this case, the DB instance isn't rebooted automatically and the parameter changes isn't applied during the next maintenance window.</p> <p>Default: Uses existing setting</p> <p>Constraints: The DB parameter group must be in the same DB parameter group family as this DB instance.</p>
    pub db_parameter_group_name: Option<String>,
    /// <p>The port number on which the database accepts connections.</p> <p>The value of the <code>DBPortNumber</code> parameter must not match any of the port values specified for options in the option group for the DB instance.</p> <p>Your database will restart when you change the <code>DBPortNumber</code> value regardless of the value of the <code>ApplyImmediately</code> parameter.</p> <p> <b>MySQL</b> </p> <p> Default: <code>3306</code> </p> <p> Valid values: <code>1150-65535</code> </p> <p> <b>MariaDB</b> </p> <p> Default: <code>3306</code> </p> <p> Valid values: <code>1150-65535</code> </p> <p> <b>PostgreSQL</b> </p> <p> Default: <code>5432</code> </p> <p> Valid values: <code>1150-65535</code> </p> <p>Type: Integer</p> <p> <b>Oracle</b> </p> <p> Default: <code>1521</code> </p> <p> Valid values: <code>1150-65535</code> </p> <p> <b>SQL Server</b> </p> <p> Default: <code>1433</code> </p> <p> Valid values: <code>1150-65535</code> except <code>1234</code>, <code>1434</code>, <code>3260</code>, <code>3343</code>, <code>3389</code>, <code>47001</code>, and <code>49152-49156</code>.</p> <p> <b>Amazon Aurora</b> </p> <p> Default: <code>3306</code> </p> <p> Valid values: <code>1150-65535</code> </p>
    pub db_port_number: Option<i64>,
    /// <p><p>A list of DB security groups to authorize on this DB instance. Changing this setting doesn&#39;t result in an outage and the change is asynchronously applied as soon as possible.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match existing DBSecurityGroups.</p> </li> </ul></p>
    pub db_security_groups: Option<Vec<String>>,
    /// <p>The new DB subnet group for the DB instance. You can use this parameter to move your DB instance to a different VPC. If your DB instance isn't in a VPC, you can also use this parameter to move your DB instance into a VPC. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html#USER_VPC.Non-VPC2VPC">Working with a DB instance in a VPC</a> in the <i>Amazon RDS User Guide.</i> </p> <p>Changing the subnet group causes an outage during the change. The change is applied during the next maintenance window, unless you enable <code>ApplyImmediately</code>. </p> <p>Constraints: If supplied, must match the name of an existing DBSubnetGroup.</p> <p>Example: <code>mySubnetGroup</code> </p>
    pub db_subnet_group_name: Option<String>,
    /// <p>A value that indicates whether the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html"> Deleting a DB Instance</a>. </p>
    pub deletion_protection: Option<bool>,
    /// <p>The Active Directory directory ID to move the DB instance to. Specify <code>none</code> to remove the instance from its current domain. The domain must be created prior to this operation. Currently, only MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances can be created in an Active Directory Domain.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html"> Kerberos Authentication</a> in the <i>Amazon RDS User Guide</i>.</p>
    pub domain: Option<String>,
    /// <p>The name of the IAM role to use when making API calls to the Directory Service.</p>
    pub domain_iam_role_name: Option<String>,
    /// <p>A value that indicates whether to enable a customer-owned IP address (CoIP) for an RDS on Outposts DB instance.</p> <p>A <i>CoIP</i> provides local or external connectivity to resources in your Outpost subnets through your on-premises network. For some use cases, a CoIP can provide lower latency for connections to the DB instance from outside of its virtual private cloud (VPC) on your local network.</p> <p>For more information about RDS on Outposts, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon RDS on Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide</i>.</p> <p>For more information about CoIPs, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#ip-addressing">Customer-owned IP addresses</a> in the <i>Amazon Web Services Outposts User Guide</i>.</p>
    pub enable_customer_owned_ip: Option<bool>,
    /// <p>A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping is disabled.</p> <p>This setting doesn't apply to Amazon Aurora. Mapping Amazon Web Services IAM accounts to database accounts is managed by the DB cluster.</p> <p>For more information about IAM database authentication, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database Authentication for MySQL and PostgreSQL</a> in the <i>Amazon RDS User Guide.</i> </p>
    pub enable_iam_database_authentication: Option<bool>,
    /// <p>A value that indicates whether to enable Performance Insights for the DB instance.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon Performance Insights</a> in the <i>Amazon Relational Database Service User Guide</i>. </p>
    pub enable_performance_insights: Option<bool>,
    /// <p> The version number of the database engine to upgrade to. Changing this parameter results in an outage and the change is applied during the next maintenance window unless the <code>ApplyImmediately</code> parameter is enabled for this request. </p> <p>For major version upgrades, if a nondefault DB parameter group is currently in use, a new DB parameter group in the DB parameter group family for the new engine version must be specified. The new DB parameter group can be the default for that DB parameter group family.</p> <p>If you specify only a major version, Amazon RDS will update the DB instance to the default minor version if the current minor version is lower. For information about valid engine versions, see <code>CreateDBInstance</code>, or call <code>DescribeDBEngineVersions</code>.</p>
    pub engine_version: Option<String>,
    /// <p>The new Provisioned IOPS (I/O operations per second) value for the RDS instance. </p> <p>Changing this setting doesn't result in an outage and the change is applied during the next maintenance window unless the <code>ApplyImmediately</code> parameter is enabled for this request. If you are migrating from Provisioned IOPS to standard storage, set this value to 0. The DB instance will require a reboot for the change in storage type to take effect. </p> <p>If you choose to migrate your DB instance from using standard storage to using Provisioned IOPS, or from using Provisioned IOPS to using standard storage, the process can take time. The duration of the migration depends on several factors such as database load, storage size, storage type (standard or Provisioned IOPS), amount of IOPS provisioned (if any), and the number of prior scale storage operations. Typical migration times are under 24 hours, but the process can take up to several days in some cases. During the migration, the DB instance is available for use, but might experience performance degradation. While the migration takes place, nightly backups for the instance are suspended. No other Amazon RDS operations can take place for the instance, including modifying the instance, rebooting the instance, deleting the instance, creating a read replica for the instance, and creating a DB snapshot of the instance. </p> <p>Constraints: For MariaDB, MySQL, Oracle, and PostgreSQL, the value supplied must be at least 10% greater than the current value. Values that are not at least 10% greater than the existing value are rounded up so that they are 10% greater than the current value. </p> <p>Default: Uses existing setting</p>
    pub iops: Option<i64>,
    /// <p>The license model for the DB instance.</p> <p>Valid values: <code>license-included</code> | <code>bring-your-own-license</code> | <code>general-public-license</code> </p>
    pub license_model: Option<String>,
    /// <p><p>The new password for the master user. The password can include any printable ASCII character except &quot;/&quot;, &quot;&quot;&quot;, or &quot;@&quot;.</p> <p> Changing this parameter doesn&#39;t result in an outage and the change is asynchronously applied as soon as possible. Between the time of the request and the completion of the request, the <code>MasterUserPassword</code> element exists in the <code>PendingModifiedValues</code> element of the operation response. </p> <p> <b>Amazon Aurora</b> </p> <p>Not applicable. The password for the master user is managed by the DB cluster. For more information, see <code>ModifyDBCluster</code>. </p> <p>Default: Uses existing setting</p> <p> <b>MariaDB</b> </p> <p>Constraints: Must contain from 8 to 41 characters.</p> <p> <b>Microsoft SQL Server</b> </p> <p>Constraints: Must contain from 8 to 128 characters.</p> <p> <b>MySQL</b> </p> <p>Constraints: Must contain from 8 to 41 characters.</p> <p> <b>Oracle</b> </p> <p>Constraints: Must contain from 8 to 30 characters.</p> <p> <b>PostgreSQL</b> </p> <p>Constraints: Must contain from 8 to 128 characters.</p> <note> <p>Amazon RDS API actions never return the password, so this action provides a way to regain access to a primary instance user if the password is lost. This includes restoring privileges that might have been accidentally revoked. </p> </note></p>
    pub master_user_password: Option<String>,
    /// <p>The upper limit to which Amazon RDS can automatically scale the storage of the DB instance.</p> <p>For more information about this setting, including limitations that apply to it, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling"> Managing capacity automatically with Amazon RDS storage autoscaling</a> in the <i>Amazon RDS User Guide</i>.</p>
    pub max_allocated_storage: Option<i64>,
    /// <p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0. The default is 0.</p> <p>If <code>MonitoringRoleArn</code> is specified, then you must also set <code>MonitoringInterval</code> to a value other than 0.</p> <p>Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code> </p>
    pub monitoring_interval: Option<i64>,
    /// <p>The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs. For example, <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a monitoring role, go to <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole">To create an IAM role for Amazon RDS Enhanced Monitoring</a> in the <i>Amazon RDS User Guide.</i> </p> <p>If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a <code>MonitoringRoleArn</code> value.</p>
    pub monitoring_role_arn: Option<String>,
    /// <p>A value that indicates whether the DB instance is a Multi-AZ deployment. Changing this parameter doesn't result in an outage and the change is applied during the next maintenance window unless the <code>ApplyImmediately</code> parameter is enabled for this request. </p>
    pub multi_az: Option<bool>,
    /// <p> The new DB instance identifier for the DB instance when renaming a DB instance. When you change the DB instance identifier, an instance reboot occurs immediately if you enable <code>ApplyImmediately</code>, or will occur during the next maintenance window if you disable Apply Immediately. This value is stored as a lowercase string. </p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li> <li> <p>The first character must be a letter.</p> </li> <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li> </ul> <p>Example: <code>mydbinstance</code> </p>
    pub new_db_instance_identifier: Option<String>,
    /// <p> A value that indicates the DB instance should be associated with the specified option group. Changing this parameter doesn't result in an outage except in the following case and the change is applied during the next maintenance window unless the <code>ApplyImmediately</code> parameter is enabled for this request. If the parameter change results in an option group that enables OEM, this change can cause a brief (sub-second) period during which new connections are rejected but existing connections are not interrupted. </p> <p>Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed from an option group, and that option group can't be removed from a DB instance once it is associated with a DB instance</p>
    pub option_group_name: Option<String>,
    /// <p>The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p> <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the Amazon Web Services KMS customer master key (CMK).</p> <p>If you do not specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your default CMK. There is a default CMK for your Amazon Web Services account. Your Amazon Web Services account has a different default CMK for each Amazon Web Services Region.</p>
    pub performance_insights_kms_key_id: Option<String>,
    /// <p>The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years). </p>
    pub performance_insights_retention_period: Option<i64>,
    /// <p><p> The daily time range during which automated backups are created if automated backups are enabled, as determined by the <code>BackupRetentionPeriod</code> parameter. Changing this parameter doesn&#39;t result in an outage and the change is asynchronously applied as soon as possible. The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow">Backup window</a> in the <i>Amazon RDS User Guide.</i> </p> <p> <b>Amazon Aurora</b> </p> <p>Not applicable. The daily time range for creating automated backups is managed by the DB cluster. For more information, see <code>ModifyDBCluster</code>.</p> <p>Constraints:</p> <ul> <li> <p>Must be in the format hh24:mi-hh24:mi</p> </li> <li> <p>Must be in Universal Time Coordinated (UTC)</p> </li> <li> <p>Must not conflict with the preferred maintenance window</p> </li> <li> <p>Must be at least 30 minutes</p> </li> </ul></p>
    pub preferred_backup_window: Option<String>,
    /// <p>The weekly time range (in UTC) during which system maintenance can occur, which might result in an outage. Changing this parameter doesn't result in an outage, except in the following situation, and the change is asynchronously applied as soon as possible. If there are pending actions that cause a reboot, and the maintenance window is changed to include the current time, then changing this parameter will cause a reboot of the DB instance. If moving this window to the current time, there must be at least 30 minutes between the current time and end of the window to ensure pending changes are applied.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance">Amazon RDS Maintenance Window</a> in the <i>Amazon RDS User Guide.</i> </p> <p>Default: Uses existing setting</p> <p>Format: ddd:hh24:mi-ddd:hh24:mi</p> <p>Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun</p> <p>Constraints: Must be at least 30 minutes</p>
    pub preferred_maintenance_window: Option<String>,
    /// <p>The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.</p>
    pub processor_features: Option<Vec<ProcessorFeature>>,
    /// <p>A value that specifies the order in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance"> Fault Tolerance for an Aurora DB Cluster</a> in the <i>Amazon Aurora User Guide</i>. </p> <p>Default: 1</p> <p>Valid Values: 0 - 15</p>
    pub promotion_tier: Option<i64>,
    /// <p>A value that indicates whether the DB instance is publicly accessible. </p> <p>When the DB instance is publicly accessible, its DNS endpoint resolves to the private IP address from within the DB instance's VPC, and to the public IP address from outside of the DB instance's VPC. Access to the DB instance is ultimately controlled by the security group it uses, and that public access is not permitted if the security group assigned to the DB instance doesn't permit it.</p> <p>When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address.</p> <p> <code>PubliclyAccessible</code> only applies to DB instances in a VPC. The DB instance must be part of a public subnet and <code>PubliclyAccessible</code> must be enabled for it to be publicly accessible. </p> <p>Changes to the <code>PubliclyAccessible</code> parameter are applied immediately regardless of the value of the <code>ApplyImmediately</code> parameter.</p>
    pub publicly_accessible: Option<bool>,
    /// <p>A value that sets the open mode of a replica database to either mounted or read-only.</p> <note> <p>Currently, this parameter is only supported for Oracle DB instances.</p> </note> <p>Mounted DB replicas are included in Oracle Enterprise Edition. The main use case for mounted replicas is cross-Region disaster recovery. The primary database doesn't use Active Data Guard to transmit information to the mounted replica. Because it doesn't accept user connections, a mounted replica can't serve a read-only workload. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html">Working with Oracle Read Replicas for Amazon RDS</a> in the <i>Amazon RDS User Guide</i>.</p>
    pub replica_mode: Option<String>,
    /// <p>Specifies the storage type to be associated with the DB instance. </p> <p>If you specify Provisioned IOPS (<code>io1</code>), you must also include a value for the <code>Iops</code> parameter. </p> <p>If you choose to migrate your DB instance from using standard storage to using Provisioned IOPS, or from using Provisioned IOPS to using standard storage, the process can take time. The duration of the migration depends on several factors such as database load, storage size, storage type (standard or Provisioned IOPS), amount of IOPS provisioned (if any), and the number of prior scale storage operations. Typical migration times are under 24 hours, but the process can take up to several days in some cases. During the migration, the DB instance is available for use, but might experience performance degradation. While the migration takes place, nightly backups for the instance are suspended. No other Amazon RDS operations can take place for the instance, including modifying the instance, rebooting the instance, deleting the instance, creating a read replica for the instance, and creating a DB snapshot of the instance. </p> <p> Valid values: <code>standard | gp2 | io1</code> </p> <p>Default: <code>io1</code> if the <code>Iops</code> parameter is specified, otherwise <code>gp2</code> </p>
    pub storage_type: Option<String>,
    /// <p>The ARN from the key store with which to associate the instance for TDE encryption.</p>
    pub tde_credential_arn: Option<String>,
    /// <p>The password for the given ARN from the key store in order to access the device.</p>
    pub tde_credential_password: Option<String>,
    /// <p>A value that indicates whether the DB instance class of the DB instance uses its default processor features.</p>
    pub use_default_processor_features: Option<bool>,
    /// <p><p>A list of EC2 VPC security groups to authorize on this DB instance. This change is asynchronously applied as soon as possible.</p> <p> <b>Amazon Aurora</b> </p> <p>Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster. For more information, see <code>ModifyDBCluster</code>.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match existing VpcSecurityGroupIds.</p> </li> </ul></p>
    pub vpc_security_group_ids: Option<Vec<String>>,
}

/// Serialize `ModifyDBInstanceMessage` contents to a `SignedRequest`.
struct ModifyDBInstanceMessageSerializer;
impl ModifyDBInstanceMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ModifyDBInstanceMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.allocated_storage {
            params.put(&format!("{}{}", prefix, "AllocatedStorage"), &field_value);
        }
        if let Some(ref field_value) = obj.allow_major_version_upgrade {
            params.put(
                &format!("{}{}", prefix, "AllowMajorVersionUpgrade"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.apply_immediately {
            params.put(&format!("{}{}", prefix, "ApplyImmediately"), &field_value);
        }
        if let Some(ref field_value) = obj.auto_minor_version_upgrade {
            params.put(
                &format!("{}{}", prefix, "AutoMinorVersionUpgrade"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.aws_backup_recovery_point_arn {
            params.put(
                &format!("{}{}", prefix, "AwsBackupRecoveryPointArn"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.backup_retention_period {
            params.put(
                &format!("{}{}", prefix, "BackupRetentionPeriod"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.ca_certificate_identifier {
            params.put(
                &format!("{}{}", prefix, "CACertificateIdentifier"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.certificate_rotation_restart {
            params.put(
                &format!("{}{}", prefix, "CertificateRotationRestart"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.cloudwatch_logs_export_configuration {
            CloudwatchLogsExportConfigurationSerializer::serialize(
                params,
                &format!("{}{}", prefix, "CloudwatchLogsExportConfiguration"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.copy_tags_to_snapshot {
            params.put(&format!("{}{}", prefix, "CopyTagsToSnapshot"), &field_value);
        }
        if let Some(ref field_value) = obj.db_instance_class {
            params.put(&format!("{}{}", prefix, "DBInstanceClass"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "DBInstanceIdentifier"),
            &obj.db_instance_identifier,
        );
        if let Some(ref field_value) = obj.db_parameter_group_name {
            params.put(
                &format!("{}{}", prefix, "DBParameterGroupName"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.db_port_number {
            params.put(&format!("{}{}", prefix, "DBPortNumber"), &field_value);
        }
        if let Some(ref field_value) = obj.db_security_groups {
            DBSecurityGroupNameListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "DBSecurityGroupName"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.db_subnet_group_name {
            params.put(&format!("{}{}", prefix, "DBSubnetGroupName"), &field_value);
        }
        if let Some(ref field_value) = obj.deletion_protection {
            params.put(&format!("{}{}", prefix, "DeletionProtection"), &field_value);
        }
        if let Some(ref field_value) = obj.domain {
            params.put(&format!("{}{}", prefix, "Domain"), &field_value);
        }
        if let Some(ref field_value) = obj.domain_iam_role_name {
            params.put(&format!("{}{}", prefix, "DomainIAMRoleName"), &field_value);
        }
        if let Some(ref field_value) = obj.enable_customer_owned_ip {
            params.put(
                &format!("{}{}", prefix, "EnableCustomerOwnedIp"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.enable_iam_database_authentication {
            params.put(
                &format!("{}{}", prefix, "EnableIAMDatabaseAuthentication"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.enable_performance_insights {
            params.put(
                &format!("{}{}", prefix, "EnablePerformanceInsights"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.engine_version {
            params.put(&format!("{}{}", prefix, "EngineVersion"), &field_value);
        }
        if let Some(ref field_value) = obj.iops {
            params.put(&format!("{}{}", prefix, "Iops"), &field_value);
        }
        if let Some(ref field_value) = obj.license_model {
            params.put(&format!("{}{}", prefix, "LicenseModel"), &field_value);
        }
        if let Some(ref field_value) = obj.master_user_password {
            params.put(&format!("{}{}", prefix, "MasterUserPassword"), &field_value);
        }
        if let Some(ref field_value) = obj.max_allocated_storage {
            params.put(
                &format!("{}{}", prefix, "MaxAllocatedStorage"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.monitoring_interval {
            params.put(&format!("{}{}", prefix, "MonitoringInterval"), &field_value);
        }
        if let Some(ref field_value) = obj.monitoring_role_arn {
            params.put(&format!("{}{}", prefix, "MonitoringRoleArn"), &field_value);
        }
        if let Some(ref field_value) = obj.multi_az {
            params.put(&format!("{}{}", prefix, "MultiAZ"), &field_value);
        }
        if let Some(ref field_value) = obj.new_db_instance_identifier {
            params.put(
                &format!("{}{}", prefix, "NewDBInstanceIdentifier"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.option_group_name {
            params.put(&format!("{}{}", prefix, "OptionGroupName"), &field_value);
        }
        if let Some(ref field_value) = obj.performance_insights_kms_key_id {
            params.put(
                &format!("{}{}", prefix, "PerformanceInsightsKMSKeyId"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.performance_insights_retention_period {
            params.put(
                &format!("{}{}", prefix, "PerformanceInsightsRetentionPeriod"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.preferred_backup_window {
            params.put(
                &format!("{}{}", prefix, "PreferredBackupWindow"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.preferred_maintenance_window {
            params.put(
                &format!("{}{}", prefix, "PreferredMaintenanceWindow"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.processor_features {
            ProcessorFeatureListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "ProcessorFeature"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.promotion_tier {
            params.put(&format!("{}{}", prefix, "PromotionTier"), &field_value);
        }
        if let Some(ref field_value) = obj.publicly_accessible {
            params.put(&format!("{}{}", prefix, "PubliclyAccessible"), &field_value);
        }
        if let Some(ref field_value) = obj.replica_mode {
            params.put(&format!("{}{}", prefix, "ReplicaMode"), &field_value);
        }
        if let Some(ref field_value) = obj.storage_type {
            params.put(&format!("{}{}", prefix, "StorageType"), &field_value);
        }
        if let Some(ref field_value) = obj.tde_credential_arn {
            params.put(&format!("{}{}", prefix, "TdeCredentialArn"), &field_value);
        }
        if let Some(ref field_value) = obj.tde_credential_password {
            params.put(
                &format!("{}{}", prefix, "TdeCredentialPassword"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.use_default_processor_features {
            params.put(
                &format!("{}{}", prefix, "UseDefaultProcessorFeatures"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.vpc_security_group_ids {
            VpcSecurityGroupIdListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "VpcSecurityGroupId"),
                field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ModifyDBInstanceResult {
    pub db_instance: Option<DBInstance>,
}

#[allow(dead_code)]
struct ModifyDBInstanceResultDeserializer;
impl ModifyDBInstanceResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ModifyDBInstanceResult, XmlParseError> {
        deserialize_elements::<_, ModifyDBInstanceResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "DBInstance" => {
                    obj.db_instance =
                        Some(DBInstanceDeserializer::deserialize("DBInstance", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ModifyDBParameterGroupMessage {
    /// <p><p>The name of the DB parameter group.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match the name of an existing <code>DBParameterGroup</code>.</p> </li> </ul></p>
    pub db_parameter_group_name: String,
    /// <p><p>An array of parameter names, values, and the application methods for the parameter update. At least one parameter name, value, and application method method must be supplied; later arguments are optional. A maximum of 20 parameters can be modified in a single request.</p> <p>Valid Values (for the application method): <code>immediate | pending-reboot</code> </p> <note> <p>You can use the <code>immediate</code> value with dynamic parameters only. You can use the <code>pending-reboot</code> value for both dynamic and static parameters.</p> <p>When the application method is <code>immediate</code>, changes to dynamic parameters are applied immediately to the DB instances associated with the parameter group. When the application method is <code>pending-reboot</code>, changes to dynamic and static parameters are applied after a reboot without failover to the DB instances associated with the parameter group.</p> </note></p>
    pub parameters: Vec<Parameter>,
}

/// Serialize `ModifyDBParameterGroupMessage` contents to a `SignedRequest`.
struct ModifyDBParameterGroupMessageSerializer;
impl ModifyDBParameterGroupMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ModifyDBParameterGroupMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "DBParameterGroupName"),
            &obj.db_parameter_group_name,
        );
        ParametersListSerializer::serialize(
            params,
            &format!("{}{}", prefix, "Parameter"),
            &obj.parameters,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ModifyDBProxyEndpointRequest {
    /// <p>The name of the DB proxy sociated with the DB proxy endpoint that you want to modify.</p>
    pub db_proxy_endpoint_name: String,
    /// <p>The new identifier for the <code>DBProxyEndpoint</code>. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.</p>
    pub new_db_proxy_endpoint_name: Option<String>,
    /// <p>The VPC security group IDs for the DB proxy endpoint. When the DB proxy endpoint uses a different VPC than the original proxy, you also specify a different set of security group IDs than for the original proxy.</p>
    pub vpc_security_group_ids: Option<Vec<String>>,
}

/// Serialize `ModifyDBProxyEndpointRequest` contents to a `SignedRequest`.
struct ModifyDBProxyEndpointRequestSerializer;
impl ModifyDBProxyEndpointRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ModifyDBProxyEndpointRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "DBProxyEndpointName"),
            &obj.db_proxy_endpoint_name,
        );
        if let Some(ref field_value) = obj.new_db_proxy_endpoint_name {
            params.put(
                &format!("{}{}", prefix, "NewDBProxyEndpointName"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.vpc_security_group_ids {
            StringListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "VpcSecurityGroupIds"),
                field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ModifyDBProxyEndpointResponse {
    /// <p>The <code>DBProxyEndpoint</code> object representing the new settings for the DB proxy endpoint.</p>
    pub db_proxy_endpoint: Option<DBProxyEndpoint>,
}

#[allow(dead_code)]
struct ModifyDBProxyEndpointResponseDeserializer;
impl ModifyDBProxyEndpointResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ModifyDBProxyEndpointResponse, XmlParseError> {
        deserialize_elements::<_, ModifyDBProxyEndpointResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DBProxyEndpoint" => {
                        obj.db_proxy_endpoint = Some(DBProxyEndpointDeserializer::deserialize(
                            "DBProxyEndpoint",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ModifyDBProxyRequest {
    /// <p>The new authentication settings for the <code>DBProxy</code>.</p>
    pub auth: Option<Vec<UserAuthConfig>>,
    /// <p>The identifier for the <code>DBProxy</code> to modify.</p>
    pub db_proxy_name: String,
    /// <p>Whether the proxy includes detailed information about SQL statements in its logs. This information helps you to debug issues involving SQL behavior or the performance and scalability of the proxy connections. The debug information includes the text of SQL statements that you submit through the proxy. Thus, only enable this setting when needed for debugging, and only when you have security measures in place to safeguard any sensitive information that appears in the logs.</p>
    pub debug_logging: Option<bool>,
    /// <p>The number of seconds that a connection to the proxy can be inactive before the proxy disconnects it. You can set this value higher or lower than the connection timeout limit for the associated database.</p>
    pub idle_client_timeout: Option<i64>,
    /// <p>The new identifier for the <code>DBProxy</code>. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.</p>
    pub new_db_proxy_name: Option<String>,
    /// <p>Whether Transport Layer Security (TLS) encryption is required for connections to the proxy. By enabling this setting, you can enforce encrypted TLS connections to the proxy, even if the associated database doesn't use TLS.</p>
    pub require_tls: Option<bool>,
    /// <p>The Amazon Resource Name (ARN) of the IAM role that the proxy uses to access secrets in Amazon Web Services Secrets Manager.</p>
    pub role_arn: Option<String>,
    /// <p>The new list of security groups for the <code>DBProxy</code>.</p>
    pub security_groups: Option<Vec<String>>,
}

/// Serialize `ModifyDBProxyRequest` contents to a `SignedRequest`.
struct ModifyDBProxyRequestSerializer;
impl ModifyDBProxyRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ModifyDBProxyRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.auth {
            UserAuthConfigListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Auth"),
                field_value,
            );
        }
        params.put(&format!("{}{}", prefix, "DBProxyName"), &obj.db_proxy_name);
        if let Some(ref field_value) = obj.debug_logging {
            params.put(&format!("{}{}", prefix, "DebugLogging"), &field_value);
        }
        if let Some(ref field_value) = obj.idle_client_timeout {
            params.put(&format!("{}{}", prefix, "IdleClientTimeout"), &field_value);
        }
        if let Some(ref field_value) = obj.new_db_proxy_name {
            params.put(&format!("{}{}", prefix, "NewDBProxyName"), &field_value);
        }
        if let Some(ref field_value) = obj.require_tls {
            params.put(&format!("{}{}", prefix, "RequireTLS"), &field_value);
        }
        if let Some(ref field_value) = obj.role_arn {
            params.put(&format!("{}{}", prefix, "RoleArn"), &field_value);
        }
        if let Some(ref field_value) = obj.security_groups {
            StringListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "SecurityGroups"),
                field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ModifyDBProxyResponse {
    /// <p>The <code>DBProxy</code> object representing the new settings for the proxy.</p>
    pub db_proxy: Option<DBProxy>,
}

#[allow(dead_code)]
struct ModifyDBProxyResponseDeserializer;
impl ModifyDBProxyResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ModifyDBProxyResponse, XmlParseError> {
        deserialize_elements::<_, ModifyDBProxyResponse, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "DBProxy" => {
                    obj.db_proxy = Some(DBProxyDeserializer::deserialize("DBProxy", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ModifyDBProxyTargetGroupRequest {
    /// <p>The settings that determine the size and behavior of the connection pool for the target group.</p>
    pub connection_pool_config: Option<ConnectionPoolConfiguration>,
    /// <p>The name of the new proxy to which to assign the target group.</p>
    pub db_proxy_name: String,
    /// <p>The new name for the modified <code>DBProxyTarget</code>. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.</p>
    pub new_name: Option<String>,
    /// <p>The name of the new target group to assign to the proxy.</p>
    pub target_group_name: String,
}

/// Serialize `ModifyDBProxyTargetGroupRequest` contents to a `SignedRequest`.
struct ModifyDBProxyTargetGroupRequestSerializer;
impl ModifyDBProxyTargetGroupRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ModifyDBProxyTargetGroupRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.connection_pool_config {
            ConnectionPoolConfigurationSerializer::serialize(
                params,
                &format!("{}{}", prefix, "ConnectionPoolConfig"),
                field_value,
            );
        }
        params.put(&format!("{}{}", prefix, "DBProxyName"), &obj.db_proxy_name);
        if let Some(ref field_value) = obj.new_name {
            params.put(&format!("{}{}", prefix, "NewName"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "TargetGroupName"),
            &obj.target_group_name,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ModifyDBProxyTargetGroupResponse {
    /// <p>The settings of the modified <code>DBProxyTarget</code>.</p>
    pub db_proxy_target_group: Option<DBProxyTargetGroup>,
}

#[allow(dead_code)]
struct ModifyDBProxyTargetGroupResponseDeserializer;
impl ModifyDBProxyTargetGroupResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ModifyDBProxyTargetGroupResponse, XmlParseError> {
        deserialize_elements::<_, ModifyDBProxyTargetGroupResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DBProxyTargetGroup" => {
                        obj.db_proxy_target_group =
                            Some(DBProxyTargetGroupDeserializer::deserialize(
                                "DBProxyTargetGroup",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ModifyDBSnapshotAttributeMessage {
    /// <p><p>The name of the DB snapshot attribute to modify.</p> <p>To manage authorization for other Amazon Web Services accounts to copy or restore a manual DB snapshot, set this value to <code>restore</code>.</p> <note> <p>To view the list of attributes available to modify, use the <a>DescribeDBSnapshotAttributes</a> API action.</p> </note></p>
    pub attribute_name: String,
    /// <p>The identifier for the DB snapshot to modify the attributes for.</p>
    pub db_snapshot_identifier: String,
    /// <p>A list of DB snapshot attributes to add to the attribute specified by <code>AttributeName</code>.</p> <p>To authorize other Amazon Web Services accounts to copy or restore a manual snapshot, set this list to include one or more Amazon Web Services account IDs, or <code>all</code> to make the manual DB snapshot restorable by any Amazon Web Services account. Do not add the <code>all</code> value for any manual DB snapshots that contain private information that you don't want available to all Amazon Web Services accounts.</p>
    pub values_to_add: Option<Vec<String>>,
    /// <p>A list of DB snapshot attributes to remove from the attribute specified by <code>AttributeName</code>.</p> <p>To remove authorization for other Amazon Web Services accounts to copy or restore a manual snapshot, set this list to include one or more Amazon Web Services account identifiers, or <code>all</code> to remove authorization for any Amazon Web Services account to copy or restore the DB snapshot. If you specify <code>all</code>, an Amazon Web Services account whose account ID is explicitly added to the <code>restore</code> attribute can still copy or restore the manual DB snapshot.</p>
    pub values_to_remove: Option<Vec<String>>,
}

/// Serialize `ModifyDBSnapshotAttributeMessage` contents to a `SignedRequest`.
struct ModifyDBSnapshotAttributeMessageSerializer;
impl ModifyDBSnapshotAttributeMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ModifyDBSnapshotAttributeMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "AttributeName"),
            &obj.attribute_name,
        );
        params.put(
            &format!("{}{}", prefix, "DBSnapshotIdentifier"),
            &obj.db_snapshot_identifier,
        );
        if let Some(ref field_value) = obj.values_to_add {
            AttributeValueListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "AttributeValue"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.values_to_remove {
            AttributeValueListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "AttributeValue"),
                field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ModifyDBSnapshotAttributeResult {
    pub db_snapshot_attributes_result: Option<DBSnapshotAttributesResult>,
}

#[allow(dead_code)]
struct ModifyDBSnapshotAttributeResultDeserializer;
impl ModifyDBSnapshotAttributeResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ModifyDBSnapshotAttributeResult, XmlParseError> {
        deserialize_elements::<_, ModifyDBSnapshotAttributeResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DBSnapshotAttributesResult" => {
                        obj.db_snapshot_attributes_result =
                            Some(DBSnapshotAttributesResultDeserializer::deserialize(
                                "DBSnapshotAttributesResult",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ModifyDBSnapshotMessage {
    /// <p>The identifier of the DB snapshot to modify.</p>
    pub db_snapshot_identifier: String,
    /// <p>The engine version to upgrade the DB snapshot to. </p> <p>The following are the database engines and engine versions that are available when you upgrade a DB snapshot. </p> <p> <b>MySQL</b> </p> <ul> <li> <p> <code>5.5.46</code> (supported for 5.1 DB snapshots)</p> </li> </ul> <p> <b>Oracle</b> </p> <ul> <li> <p> <code>12.1.0.2.v8</code> (supported for 12.1.0.1 DB snapshots)</p> </li> <li> <p> <code>11.2.0.4.v12</code> (supported for 11.2.0.2 DB snapshots)</p> </li> <li> <p> <code>11.2.0.4.v11</code> (supported for 11.2.0.3 DB snapshots)</p> </li> </ul> <p> <b>PostgreSQL</b> </p> <p>For the list of engine versions that are available for upgrading a DB snapshot, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.PostgreSQL.html#USER_UpgradeDBInstance.PostgreSQL.MajorVersion"> Upgrading the PostgreSQL DB Engine for Amazon RDS</a>. </p>
    pub engine_version: Option<String>,
    /// <p>The option group to identify with the upgraded DB snapshot. </p> <p>You can specify this parameter when you upgrade an Oracle DB snapshot. The same option group considerations apply when upgrading a DB snapshot as when upgrading a DB instance. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Oracle.html#USER_UpgradeDBInstance.Oracle.OGPG.OG">Option group considerations</a> in the <i>Amazon RDS User Guide.</i> </p>
    pub option_group_name: Option<String>,
}

/// Serialize `ModifyDBSnapshotMessage` contents to a `SignedRequest`.
struct ModifyDBSnapshotMessageSerializer;
impl ModifyDBSnapshotMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ModifyDBSnapshotMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "DBSnapshotIdentifier"),
            &obj.db_snapshot_identifier,
        );
        if let Some(ref field_value) = obj.engine_version {
            params.put(&format!("{}{}", prefix, "EngineVersion"), &field_value);
        }
        if let Some(ref field_value) = obj.option_group_name {
            params.put(&format!("{}{}", prefix, "OptionGroupName"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ModifyDBSnapshotResult {
    pub db_snapshot: Option<DBSnapshot>,
}

#[allow(dead_code)]
struct ModifyDBSnapshotResultDeserializer;
impl ModifyDBSnapshotResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ModifyDBSnapshotResult, XmlParseError> {
        deserialize_elements::<_, ModifyDBSnapshotResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "DBSnapshot" => {
                    obj.db_snapshot =
                        Some(DBSnapshotDeserializer::deserialize("DBSnapshot", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ModifyDBSubnetGroupMessage {
    /// <p>The description for the DB subnet group.</p>
    pub db_subnet_group_description: Option<String>,
    /// <p>The name for the DB subnet group. This value is stored as a lowercase string. You can't modify the default subnet group. </p> <p>Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.</p> <p>Example: <code>mySubnetgroup</code> </p>
    pub db_subnet_group_name: String,
    /// <p>The EC2 subnet IDs for the DB subnet group.</p>
    pub subnet_ids: Vec<String>,
}

/// Serialize `ModifyDBSubnetGroupMessage` contents to a `SignedRequest`.
struct ModifyDBSubnetGroupMessageSerializer;
impl ModifyDBSubnetGroupMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ModifyDBSubnetGroupMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.db_subnet_group_description {
            params.put(
                &format!("{}{}", prefix, "DBSubnetGroupDescription"),
                &field_value,
            );
        }
        params.put(
            &format!("{}{}", prefix, "DBSubnetGroupName"),
            &obj.db_subnet_group_name,
        );
        SubnetIdentifierListSerializer::serialize(
            params,
            &format!("{}{}", prefix, "SubnetIdentifier"),
            &obj.subnet_ids,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ModifyDBSubnetGroupResult {
    pub db_subnet_group: Option<DBSubnetGroup>,
}

#[allow(dead_code)]
struct ModifyDBSubnetGroupResultDeserializer;
impl ModifyDBSubnetGroupResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ModifyDBSubnetGroupResult, XmlParseError> {
        deserialize_elements::<_, ModifyDBSubnetGroupResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DBSubnetGroup" => {
                        obj.db_subnet_group = Some(DBSubnetGroupDeserializer::deserialize(
                            "DBSubnetGroup",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ModifyEventSubscriptionMessage {
    /// <p> A value that indicates whether to activate the subscription. </p>
    pub enabled: Option<bool>,
    /// <p> A list of event categories for a source type (<code>SourceType</code>) that you want to subscribe to. You can see a list of the categories for a given source type in <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html">Events</a> in the <i>Amazon RDS User Guide</i> or by using the <code>DescribeEventCategories</code> operation. </p>
    pub event_categories: Option<Vec<String>>,
    /// <p>The Amazon Resource Name (ARN) of the SNS topic created for event notification. The ARN is created by Amazon SNS when you create a topic and subscribe to it.</p>
    pub sns_topic_arn: Option<String>,
    /// <p>The type of source that is generating the events. For example, if you want to be notified of events generated by a DB instance, you would set this parameter to db-instance. If this value isn't specified, all events are returned.</p> <p>Valid values: <code>db-instance</code> | <code>db-cluster</code> | <code>db-parameter-group</code> | <code>db-security-group</code> | <code>db-snapshot</code> | <code>db-cluster-snapshot</code> </p>
    pub source_type: Option<String>,
    /// <p>The name of the RDS event notification subscription.</p>
    pub subscription_name: String,
}

/// Serialize `ModifyEventSubscriptionMessage` contents to a `SignedRequest`.
struct ModifyEventSubscriptionMessageSerializer;
impl ModifyEventSubscriptionMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ModifyEventSubscriptionMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.enabled {
            params.put(&format!("{}{}", prefix, "Enabled"), &field_value);
        }
        if let Some(ref field_value) = obj.event_categories {
            EventCategoriesListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "EventCategory"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.sns_topic_arn {
            params.put(&format!("{}{}", prefix, "SnsTopicArn"), &field_value);
        }
        if let Some(ref field_value) = obj.source_type {
            params.put(&format!("{}{}", prefix, "SourceType"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "SubscriptionName"),
            &obj.subscription_name,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ModifyEventSubscriptionResult {
    pub event_subscription: Option<EventSubscription>,
}

#[allow(dead_code)]
struct ModifyEventSubscriptionResultDeserializer;
impl ModifyEventSubscriptionResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ModifyEventSubscriptionResult, XmlParseError> {
        deserialize_elements::<_, ModifyEventSubscriptionResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "EventSubscription" => {
                        obj.event_subscription = Some(EventSubscriptionDeserializer::deserialize(
                            "EventSubscription",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ModifyGlobalClusterMessage {
    /// <p>A value that indicates whether major version upgrades are allowed.</p> <p>Constraints: You must allow major version upgrades when specifying a value for the <code>EngineVersion</code> parameter that is a different major version than the DB cluster's current version.</p> <p>If you upgrade the major version of a global database, the cluster and DB instance parameter groups are set to the default parameter groups for the new version. Apply any custom parameter groups after completing the upgrade.</p>
    pub allow_major_version_upgrade: Option<bool>,
    /// <p> Indicates if the global database cluster has deletion protection enabled. The global database cluster can't be deleted when deletion protection is enabled. </p>
    pub deletion_protection: Option<bool>,
    /// <p>The version number of the database engine to which you want to upgrade. Changing this parameter results in an outage. The change is applied during the next maintenance window unless <code>ApplyImmediately</code> is enabled.</p> <p>To list all of the available engine versions for <code>aurora</code> (for MySQL 5.6-compatible Aurora), use the following command:</p> <p> <code>aws rds describe-db-engine-versions --engine aurora --query '*[]|[?SupportsGlobalDatabases == `true`].[EngineVersion]'</code> </p> <p>To list all of the available engine versions for <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora), use the following command:</p> <p> <code>aws rds describe-db-engine-versions --engine aurora-mysql --query '*[]|[?SupportsGlobalDatabases == `true`].[EngineVersion]'</code> </p> <p>To list all of the available engine versions for <code>aurora-postgresql</code>, use the following command:</p> <p> <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query '*[]|[?SupportsGlobalDatabases == `true`].[EngineVersion]'</code> </p>
    pub engine_version: Option<String>,
    /// <p><p> The DB cluster identifier for the global cluster being modified. This parameter isn&#39;t case-sensitive. </p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing global database cluster.</p> </li> </ul></p>
    pub global_cluster_identifier: Option<String>,
    /// <p> The new cluster identifier for the global database cluster when modifying a global database cluster. This value is stored as a lowercase string. </p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens</p> </li> <li> <p>The first character must be a letter</p> </li> <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li> </ul> <p>Example: <code>my-cluster2</code> </p>
    pub new_global_cluster_identifier: Option<String>,
}

/// Serialize `ModifyGlobalClusterMessage` contents to a `SignedRequest`.
struct ModifyGlobalClusterMessageSerializer;
impl ModifyGlobalClusterMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ModifyGlobalClusterMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.allow_major_version_upgrade {
            params.put(
                &format!("{}{}", prefix, "AllowMajorVersionUpgrade"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.deletion_protection {
            params.put(&format!("{}{}", prefix, "DeletionProtection"), &field_value);
        }
        if let Some(ref field_value) = obj.engine_version {
            params.put(&format!("{}{}", prefix, "EngineVersion"), &field_value);
        }
        if let Some(ref field_value) = obj.global_cluster_identifier {
            params.put(
                &format!("{}{}", prefix, "GlobalClusterIdentifier"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.new_global_cluster_identifier {
            params.put(
                &format!("{}{}", prefix, "NewGlobalClusterIdentifier"),
                &field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ModifyGlobalClusterResult {
    pub global_cluster: Option<GlobalCluster>,
}

#[allow(dead_code)]
struct ModifyGlobalClusterResultDeserializer;
impl ModifyGlobalClusterResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ModifyGlobalClusterResult, XmlParseError> {
        deserialize_elements::<_, ModifyGlobalClusterResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "GlobalCluster" => {
                        obj.global_cluster = Some(GlobalClusterDeserializer::deserialize(
                            "GlobalCluster",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ModifyOptionGroupMessage {
    /// <p>A value that indicates whether to apply the change immediately or during the next maintenance window for each instance associated with the option group.</p>
    pub apply_immediately: Option<bool>,
    /// <p>The name of the option group to be modified.</p> <p>Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed from an option group, and that option group can't be removed from a DB instance once it is associated with a DB instance</p>
    pub option_group_name: String,
    /// <p>Options in this list are added to the option group or, if already present, the specified configuration is used to update the existing configuration.</p>
    pub options_to_include: Option<Vec<OptionConfiguration>>,
    /// <p>Options in this list are removed from the option group.</p>
    pub options_to_remove: Option<Vec<String>>,
}

/// Serialize `ModifyOptionGroupMessage` contents to a `SignedRequest`.
struct ModifyOptionGroupMessageSerializer;
impl ModifyOptionGroupMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ModifyOptionGroupMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.apply_immediately {
            params.put(&format!("{}{}", prefix, "ApplyImmediately"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "OptionGroupName"),
            &obj.option_group_name,
        );
        if let Some(ref field_value) = obj.options_to_include {
            OptionConfigurationListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "OptionConfiguration"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.options_to_remove {
            OptionNamesListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "OptionsToRemove"),
                field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ModifyOptionGroupResult {
    pub option_group: Option<OptionGroup>,
}

#[allow(dead_code)]
struct ModifyOptionGroupResultDeserializer;
impl ModifyOptionGroupResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ModifyOptionGroupResult, XmlParseError> {
        deserialize_elements::<_, ModifyOptionGroupResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "OptionGroup" => {
                        obj.option_group =
                            Some(OptionGroupDeserializer::deserialize("OptionGroup", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Option details.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct RDSOption {
    /// <p>If the option requires access to a port, then this DB security group allows access to the port.</p>
    pub db_security_group_memberships: Option<Vec<DBSecurityGroupMembership>>,
    /// <p>The description of the option.</p>
    pub option_description: Option<String>,
    /// <p>The name of the option.</p>
    pub option_name: Option<String>,
    /// <p>The option settings for this option.</p>
    pub option_settings: Option<Vec<OptionSetting>>,
    /// <p>The version of the option.</p>
    pub option_version: Option<String>,
    /// <p>Indicate if this option is permanent.</p>
    pub permanent: Option<bool>,
    /// <p>Indicate if this option is persistent.</p>
    pub persistent: Option<bool>,
    /// <p>If required, the port configured for this option to use.</p>
    pub port: Option<i64>,
    /// <p>If the option requires access to a port, then this VPC security group allows access to the port.</p>
    pub vpc_security_group_memberships: Option<Vec<VpcSecurityGroupMembership>>,
}

#[allow(dead_code)]
struct RDSOptionDeserializer;
impl RDSOptionDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<RDSOption, XmlParseError> {
        deserialize_elements::<_, RDSOption, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "DBSecurityGroupMemberships" => {
                    obj.db_security_group_memberships
                        .get_or_insert(vec![])
                        .extend(DBSecurityGroupMembershipListDeserializer::deserialize(
                            "DBSecurityGroupMemberships",
                            stack,
                        )?);
                }
                "OptionDescription" => {
                    obj.option_description =
                        Some(StringDeserializer::deserialize("OptionDescription", stack)?);
                }
                "OptionName" => {
                    obj.option_name = Some(StringDeserializer::deserialize("OptionName", stack)?);
                }
                "OptionSettings" => {
                    obj.option_settings.get_or_insert(vec![]).extend(
                        OptionSettingConfigurationListDeserializer::deserialize(
                            "OptionSettings",
                            stack,
                        )?,
                    );
                }
                "OptionVersion" => {
                    obj.option_version =
                        Some(StringDeserializer::deserialize("OptionVersion", stack)?);
                }
                "Permanent" => {
                    obj.permanent = Some(BooleanDeserializer::deserialize("Permanent", stack)?);
                }
                "Persistent" => {
                    obj.persistent = Some(BooleanDeserializer::deserialize("Persistent", stack)?);
                }
                "Port" => {
                    obj.port = Some(IntegerOptionalDeserializer::deserialize("Port", stack)?);
                }
                "VpcSecurityGroupMemberships" => {
                    obj.vpc_security_group_memberships
                        .get_or_insert(vec![])
                        .extend(VpcSecurityGroupMembershipListDeserializer::deserialize(
                            "VpcSecurityGroupMemberships",
                            stack,
                        )?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>A list of all available options</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct OptionConfiguration {
    /// <p>A list of DBSecurityGroupMembership name strings used for this option.</p>
    pub db_security_group_memberships: Option<Vec<String>>,
    /// <p>The configuration of options to include in a group.</p>
    pub option_name: String,
    /// <p>The option settings to include in an option group.</p>
    pub option_settings: Option<Vec<OptionSetting>>,
    /// <p>The version for the option.</p>
    pub option_version: Option<String>,
    /// <p>The optional port for the option.</p>
    pub port: Option<i64>,
    /// <p>A list of VpcSecurityGroupMembership name strings used for this option.</p>
    pub vpc_security_group_memberships: Option<Vec<String>>,
}

/// Serialize `OptionConfiguration` contents to a `SignedRequest`.
struct OptionConfigurationSerializer;
impl OptionConfigurationSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &OptionConfiguration) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.db_security_group_memberships {
            DBSecurityGroupNameListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "DBSecurityGroupName"),
                field_value,
            );
        }
        params.put(&format!("{}{}", prefix, "OptionName"), &obj.option_name);
        if let Some(ref field_value) = obj.option_settings {
            OptionSettingsListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "OptionSetting"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.option_version {
            params.put(&format!("{}{}", prefix, "OptionVersion"), &field_value);
        }
        if let Some(ref field_value) = obj.port {
            params.put(&format!("{}{}", prefix, "Port"), &field_value);
        }
        if let Some(ref field_value) = obj.vpc_security_group_memberships {
            VpcSecurityGroupIdListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "VpcSecurityGroupId"),
                field_value,
            );
        }
    }
}

/// Serialize `OptionConfigurationList` contents to a `SignedRequest`.
struct OptionConfigurationListSerializer;
impl OptionConfigurationListSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<OptionConfiguration>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.member.{}", name, index + 1);
            OptionConfigurationSerializer::serialize(params, &key, obj);
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct OptionGroup {
    /// <p>Indicates whether this option group can be applied to both VPC and non-VPC instances. The value <code>true</code> indicates the option group can be applied to both VPC and non-VPC instances. </p>
    pub allows_vpc_and_non_vpc_instance_memberships: Option<bool>,
    /// <p>Indicates the name of the engine that this option group can be applied to.</p>
    pub engine_name: Option<String>,
    /// <p>Indicates the major engine version associated with this option group.</p>
    pub major_engine_version: Option<String>,
    /// <p>The Amazon Resource Name (ARN) for the option group.</p>
    pub option_group_arn: Option<String>,
    /// <p>Provides a description of the option group.</p>
    pub option_group_description: Option<String>,
    /// <p>Specifies the name of the option group.</p>
    pub option_group_name: Option<String>,
    /// <p>Indicates what options are available in the option group.</p>
    pub options: Option<Vec<RDSOption>>,
    /// <p>If <b>AllowsVpcAndNonVpcInstanceMemberships</b> is <code>false</code>, this field is blank. If <b>AllowsVpcAndNonVpcInstanceMemberships</b> is <code>true</code> and this field is blank, then this option group can be applied to both VPC and non-VPC instances. If this field contains a value, then this option group can only be applied to instances that are in the VPC indicated by this field. </p>
    pub vpc_id: Option<String>,
}

#[allow(dead_code)]
struct OptionGroupDeserializer;
impl OptionGroupDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<OptionGroup, XmlParseError> {
        deserialize_elements::<_, OptionGroup, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "AllowsVpcAndNonVpcInstanceMemberships" => {
                    obj.allows_vpc_and_non_vpc_instance_memberships =
                        Some(BooleanDeserializer::deserialize(
                            "AllowsVpcAndNonVpcInstanceMemberships",
                            stack,
                        )?);
                }
                "EngineName" => {
                    obj.engine_name = Some(StringDeserializer::deserialize("EngineName", stack)?);
                }
                "MajorEngineVersion" => {
                    obj.major_engine_version = Some(StringDeserializer::deserialize(
                        "MajorEngineVersion",
                        stack,
                    )?);
                }
                "OptionGroupArn" => {
                    obj.option_group_arn =
                        Some(StringDeserializer::deserialize("OptionGroupArn", stack)?);
                }
                "OptionGroupDescription" => {
                    obj.option_group_description = Some(StringDeserializer::deserialize(
                        "OptionGroupDescription",
                        stack,
                    )?);
                }
                "OptionGroupName" => {
                    obj.option_group_name =
                        Some(StringDeserializer::deserialize("OptionGroupName", stack)?);
                }
                "Options" => {
                    obj.options
                        .get_or_insert(vec![])
                        .extend(OptionsListDeserializer::deserialize("Options", stack)?);
                }
                "VpcId" => {
                    obj.vpc_id = Some(StringDeserializer::deserialize("VpcId", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>Provides information on the option groups the DB instance is a member of.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct OptionGroupMembership {
    /// <p>The name of the option group that the instance belongs to.</p>
    pub option_group_name: Option<String>,
    /// <p>The status of the DB instance's option group membership. Valid values are: <code>in-sync</code>, <code>pending-apply</code>, <code>pending-removal</code>, <code>pending-maintenance-apply</code>, <code>pending-maintenance-removal</code>, <code>applying</code>, <code>removing</code>, and <code>failed</code>. </p>
    pub status: Option<String>,
}

#[allow(dead_code)]
struct OptionGroupMembershipDeserializer;
impl OptionGroupMembershipDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<OptionGroupMembership, XmlParseError> {
        deserialize_elements::<_, OptionGroupMembership, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "OptionGroupName" => {
                    obj.option_group_name =
                        Some(StringDeserializer::deserialize("OptionGroupName", stack)?);
                }
                "Status" => {
                    obj.status = Some(StringDeserializer::deserialize("Status", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct OptionGroupMembershipListDeserializer;
impl OptionGroupMembershipListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<OptionGroupMembership>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "OptionGroupMembership" {
                obj.push(OptionGroupMembershipDeserializer::deserialize(
                    "OptionGroupMembership",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Available option.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct OptionGroupOption {
    /// <p>If the option requires a port, specifies the default port for the option.</p>
    pub default_port: Option<i64>,
    /// <p>The description of the option.</p>
    pub description: Option<String>,
    /// <p>The name of the engine that this option can be applied to.</p>
    pub engine_name: Option<String>,
    /// <p>Indicates the major engine version that the option is available for.</p>
    pub major_engine_version: Option<String>,
    /// <p>The minimum required engine version for the option to be applied.</p>
    pub minimum_required_minor_engine_version: Option<String>,
    /// <p>The name of the option.</p>
    pub name: Option<String>,
    /// <p>The option settings that are available (and the default value) for each option in an option group.</p>
    pub option_group_option_settings: Option<Vec<OptionGroupOptionSetting>>,
    /// <p>The versions that are available for the option.</p>
    pub option_group_option_versions: Option<Vec<OptionVersion>>,
    /// <p>The options that conflict with this option.</p>
    pub options_conflicts_with: Option<Vec<String>>,
    /// <p>The options that are prerequisites for this option.</p>
    pub options_depended_on: Option<Vec<String>>,
    /// <p>Permanent options can never be removed from an option group. An option group containing a permanent option can't be removed from a DB instance.</p>
    pub permanent: Option<bool>,
    /// <p>Persistent options can't be removed from an option group while DB instances are associated with the option group. If you disassociate all DB instances from the option group, your can remove the persistent option from the option group.</p>
    pub persistent: Option<bool>,
    /// <p>Specifies whether the option requires a port.</p>
    pub port_required: Option<bool>,
    /// <p>If true, you must enable the Auto Minor Version Upgrade setting for your DB instance before you can use this option. You can enable Auto Minor Version Upgrade when you first create your DB instance, or by modifying your DB instance later. </p>
    pub requires_auto_minor_engine_version_upgrade: Option<bool>,
    /// <p>If true, you can change the option to an earlier version of the option. This only applies to options that have different versions available. </p>
    pub supports_option_version_downgrade: Option<bool>,
    /// <p>If true, you can only use this option with a DB instance that is in a VPC. </p>
    pub vpc_only: Option<bool>,
}

#[allow(dead_code)]
struct OptionGroupOptionDeserializer;
impl OptionGroupOptionDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<OptionGroupOption, XmlParseError> {
        deserialize_elements::<_, OptionGroupOption, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "DefaultPort" => {
                    obj.default_port = Some(IntegerOptionalDeserializer::deserialize(
                        "DefaultPort",
                        stack,
                    )?);
                }
                "Description" => {
                    obj.description = Some(StringDeserializer::deserialize("Description", stack)?);
                }
                "EngineName" => {
                    obj.engine_name = Some(StringDeserializer::deserialize("EngineName", stack)?);
                }
                "MajorEngineVersion" => {
                    obj.major_engine_version = Some(StringDeserializer::deserialize(
                        "MajorEngineVersion",
                        stack,
                    )?);
                }
                "MinimumRequiredMinorEngineVersion" => {
                    obj.minimum_required_minor_engine_version =
                        Some(StringDeserializer::deserialize(
                            "MinimumRequiredMinorEngineVersion",
                            stack,
                        )?);
                }
                "Name" => {
                    obj.name = Some(StringDeserializer::deserialize("Name", stack)?);
                }
                "OptionGroupOptionSettings" => {
                    obj.option_group_option_settings
                        .get_or_insert(vec![])
                        .extend(OptionGroupOptionSettingsListDeserializer::deserialize(
                            "OptionGroupOptionSettings",
                            stack,
                        )?);
                }
                "OptionGroupOptionVersions" => {
                    obj.option_group_option_versions
                        .get_or_insert(vec![])
                        .extend(OptionGroupOptionVersionsListDeserializer::deserialize(
                            "OptionGroupOptionVersions",
                            stack,
                        )?);
                }
                "OptionsConflictsWith" => {
                    obj.options_conflicts_with.get_or_insert(vec![]).extend(
                        OptionsConflictsWithDeserializer::deserialize(
                            "OptionsConflictsWith",
                            stack,
                        )?,
                    );
                }
                "OptionsDependedOn" => {
                    obj.options_depended_on.get_or_insert(vec![]).extend(
                        OptionsDependedOnDeserializer::deserialize("OptionsDependedOn", stack)?,
                    );
                }
                "Permanent" => {
                    obj.permanent = Some(BooleanDeserializer::deserialize("Permanent", stack)?);
                }
                "Persistent" => {
                    obj.persistent = Some(BooleanDeserializer::deserialize("Persistent", stack)?);
                }
                "PortRequired" => {
                    obj.port_required =
                        Some(BooleanDeserializer::deserialize("PortRequired", stack)?);
                }
                "RequiresAutoMinorEngineVersionUpgrade" => {
                    obj.requires_auto_minor_engine_version_upgrade =
                        Some(BooleanDeserializer::deserialize(
                            "RequiresAutoMinorEngineVersionUpgrade",
                            stack,
                        )?);
                }
                "SupportsOptionVersionDowngrade" => {
                    obj.supports_option_version_downgrade =
                        Some(BooleanOptionalDeserializer::deserialize(
                            "SupportsOptionVersionDowngrade",
                            stack,
                        )?);
                }
                "VpcOnly" => {
                    obj.vpc_only = Some(BooleanDeserializer::deserialize("VpcOnly", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>Option group option settings are used to display settings available for each option with their default values and other information. These values are used with the DescribeOptionGroupOptions action.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct OptionGroupOptionSetting {
    /// <p>Indicates the acceptable values for the option group option.</p>
    pub allowed_values: Option<String>,
    /// <p>The DB engine specific parameter type for the option group option.</p>
    pub apply_type: Option<String>,
    /// <p>The default value for the option group option.</p>
    pub default_value: Option<String>,
    /// <p>Boolean value where true indicates that this option group option can be changed from the default value.</p>
    pub is_modifiable: Option<bool>,
    /// <p>Boolean value where true indicates that a value must be specified for this option setting of the option group option.</p>
    pub is_required: Option<bool>,
    /// <p>The minimum DB engine version required for the corresponding allowed value for this option setting.</p>
    pub minimum_engine_version_per_allowed_value: Option<Vec<MinimumEngineVersionPerAllowedValue>>,
    /// <p>The description of the option group option.</p>
    pub setting_description: Option<String>,
    /// <p>The name of the option group option.</p>
    pub setting_name: Option<String>,
}

#[allow(dead_code)]
struct OptionGroupOptionSettingDeserializer;
impl OptionGroupOptionSettingDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<OptionGroupOptionSetting, XmlParseError> {
        deserialize_elements::<_, OptionGroupOptionSetting, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "AllowedValues" => {
                        obj.allowed_values =
                            Some(StringDeserializer::deserialize("AllowedValues", stack)?);
                    }
                    "ApplyType" => {
                        obj.apply_type = Some(StringDeserializer::deserialize("ApplyType", stack)?);
                    }
                    "DefaultValue" => {
                        obj.default_value =
                            Some(StringDeserializer::deserialize("DefaultValue", stack)?);
                    }
                    "IsModifiable" => {
                        obj.is_modifiable =
                            Some(BooleanDeserializer::deserialize("IsModifiable", stack)?);
                    }
                    "IsRequired" => {
                        obj.is_required =
                            Some(BooleanDeserializer::deserialize("IsRequired", stack)?);
                    }
                    "MinimumEngineVersionPerAllowedValue" => {
                        obj.minimum_engine_version_per_allowed_value
                            .get_or_insert(vec![])
                            .extend(
                                MinimumEngineVersionPerAllowedValueListDeserializer::deserialize(
                                    "MinimumEngineVersionPerAllowedValue",
                                    stack,
                                )?,
                            );
                    }
                    "SettingDescription" => {
                        obj.setting_description = Some(StringDeserializer::deserialize(
                            "SettingDescription",
                            stack,
                        )?);
                    }
                    "SettingName" => {
                        obj.setting_name =
                            Some(StringDeserializer::deserialize("SettingName", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct OptionGroupOptionSettingsListDeserializer;
impl OptionGroupOptionSettingsListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<OptionGroupOptionSetting>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "OptionGroupOptionSetting" {
                obj.push(OptionGroupOptionSettingDeserializer::deserialize(
                    "OptionGroupOptionSetting",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct OptionGroupOptionVersionsListDeserializer;
impl OptionGroupOptionVersionsListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<OptionVersion>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "OptionVersion" {
                obj.push(OptionVersionDeserializer::deserialize(
                    "OptionVersion",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct OptionGroupOptionsListDeserializer;
impl OptionGroupOptionsListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<OptionGroupOption>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "OptionGroupOption" {
                obj.push(OptionGroupOptionDeserializer::deserialize(
                    "OptionGroupOption",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct OptionGroupOptionsMessage {
    /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub marker: Option<String>,
    pub option_group_options: Option<Vec<OptionGroupOption>>,
}

#[allow(dead_code)]
struct OptionGroupOptionsMessageDeserializer;
impl OptionGroupOptionsMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<OptionGroupOptionsMessage, XmlParseError> {
        deserialize_elements::<_, OptionGroupOptionsMessage, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Marker" => {
                        obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                    }
                    "OptionGroupOptions" => {
                        obj.option_group_options.get_or_insert(vec![]).extend(
                            OptionGroupOptionsListDeserializer::deserialize(
                                "OptionGroupOptions",
                                stack,
                            )?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>List of option groups.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct OptionGroups {
    /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    pub marker: Option<String>,
    /// <p>List of option groups.</p>
    pub option_groups_list: Option<Vec<OptionGroup>>,
}

#[allow(dead_code)]
struct OptionGroupsDeserializer;
impl OptionGroupsDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<OptionGroups, XmlParseError> {
        deserialize_elements::<_, OptionGroups, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Marker" => {
                    obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                }
                "OptionGroupsList" => {
                    obj.option_groups_list.get_or_insert(vec![]).extend(
                        OptionGroupsListDeserializer::deserialize("OptionGroupsList", stack)?,
                    );
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct OptionGroupsListDeserializer;
impl OptionGroupsListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<OptionGroup>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "OptionGroup" {
                obj.push(OptionGroupDeserializer::deserialize("OptionGroup", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}

/// Serialize `OptionNamesList` contents to a `SignedRequest`.
struct OptionNamesListSerializer;
impl OptionNamesListSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<String>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.member.{}", name, index + 1);
            params.put(&key, &obj);
        }
    }
}

/// <p>Option settings are the actual settings being applied or configured for that option. It is used when you modify an option group or describe option groups. For example, the NATIVE_NETWORK_ENCRYPTION option has a setting called SQLNET.ENCRYPTION_SERVER that can have several different values.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct OptionSetting {
    /// <p>The allowed values of the option setting.</p>
    pub allowed_values: Option<String>,
    /// <p>The DB engine specific parameter type.</p>
    pub apply_type: Option<String>,
    /// <p>The data type of the option setting.</p>
    pub data_type: Option<String>,
    /// <p>The default value of the option setting.</p>
    pub default_value: Option<String>,
    /// <p>The description of the option setting.</p>
    pub description: Option<String>,
    /// <p>Indicates if the option setting is part of a collection.</p>
    pub is_collection: Option<bool>,
    /// <p>A Boolean value that, when true, indicates the option setting can be modified from the default.</p>
    pub is_modifiable: Option<bool>,
    /// <p>The name of the option that has settings that you can set.</p>
    pub name: Option<String>,
    /// <p>The current value of the option setting.</p>
    pub value: Option<String>,
}

#[allow(dead_code)]
struct OptionSettingDeserializer;
impl OptionSettingDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<OptionSetting, XmlParseError> {
        deserialize_elements::<_, OptionSetting, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "AllowedValues" => {
                    obj.allowed_values =
                        Some(StringDeserializer::deserialize("AllowedValues", stack)?);
                }
                "ApplyType" => {
                    obj.apply_type = Some(StringDeserializer::deserialize("ApplyType", stack)?);
                }
                "DataType" => {
                    obj.data_type = Some(StringDeserializer::deserialize("DataType", stack)?);
                }
                "DefaultValue" => {
                    obj.default_value =
                        Some(StringDeserializer::deserialize("DefaultValue", stack)?);
                }
                "Description" => {
                    obj.description = Some(StringDeserializer::deserialize("Description", stack)?);
                }
                "IsCollection" => {
                    obj.is_collection =
                        Some(BooleanDeserializer::deserialize("IsCollection", stack)?);
                }
                "IsModifiable" => {
                    obj.is_modifiable =
                        Some(BooleanDeserializer::deserialize("IsModifiable", stack)?);
                }
                "Name" => {
                    obj.name = Some(StringDeserializer::deserialize("Name", stack)?);
                }
                "Value" => {
                    obj.value = Some(StringDeserializer::deserialize("Value", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}

/// Serialize `OptionSetting` contents to a `SignedRequest`.
struct OptionSettingSerializer;
impl OptionSettingSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &OptionSetting) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.allowed_values {
            params.put(&format!("{}{}", prefix, "AllowedValues"), &field_value);
        }
        if let Some(ref field_value) = obj.apply_type {
            params.put(&format!("{}{}", prefix, "ApplyType"), &field_value);
        }
        if let Some(ref field_value) = obj.data_type {
            params.put(&format!("{}{}", prefix, "DataType"), &field_value);
        }
        if let Some(ref field_value) = obj.default_value {
            params.put(&format!("{}{}", prefix, "DefaultValue"), &field_value);
        }
        if let Some(ref field_value) = obj.description {
            params.put(&format!("{}{}", prefix, "Description"), &field_value);
        }
        if let Some(ref field_value) = obj.is_collection {
            params.put(&format!("{}{}", prefix, "IsCollection"), &field_value);
        }
        if let Some(ref field_value) = obj.is_modifiable {
            params.put(&format!("{}{}", prefix, "IsModifiable"), &field_value);
        }
        if let Some(ref field_value) = obj.name {
            params.put(&format!("{}{}", prefix, "Name"), &field_value);
        }
        if let Some(ref field_value) = obj.value {
            params.put(&format!("{}{}", prefix, "Value"), &field_value);
        }
    }
}

#[allow(dead_code)]
struct OptionSettingConfigurationListDeserializer;
impl OptionSettingConfigurationListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<OptionSetting>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "OptionSetting" {
                obj.push(OptionSettingDeserializer::deserialize(
                    "OptionSetting",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}

/// Serialize `OptionSettingsList` contents to a `SignedRequest`.
struct OptionSettingsListSerializer;
impl OptionSettingsListSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<OptionSetting>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.member.{}", name, index + 1);
            OptionSettingSerializer::serialize(params, &key, obj);
        }
    }
}

/// <p>The version for an option. Option group option versions are returned by the <code>DescribeOptionGroupOptions</code> action.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct OptionVersion {
    /// <p>True if the version is the default version of the option, and otherwise false.</p>
    pub is_default: Option<bool>,
    /// <p>The version of the option.</p>
    pub version: Option<String>,
}

#[allow(dead_code)]
struct OptionVersionDeserializer;
impl OptionVersionDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<OptionVersion, XmlParseError> {
        deserialize_elements::<_, OptionVersion, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "IsDefault" => {
                    obj.is_default = Some(BooleanDeserializer::deserialize("IsDefault", stack)?);
                }
                "Version" => {
                    obj.version = Some(StringDeserializer::deserialize("Version", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct OptionsConflictsWithDeserializer;
impl OptionsConflictsWithDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<String>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "OptionConflictName" {
                obj.push(StringDeserializer::deserialize(
                    "OptionConflictName",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct OptionsDependedOnDeserializer;
impl OptionsDependedOnDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<String>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "OptionName" {
                obj.push(StringDeserializer::deserialize("OptionName", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct OptionsListDeserializer;
impl OptionsListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<RDSOption>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "Option" {
                obj.push(RDSOptionDeserializer::deserialize("Option", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Contains a list of available options for a DB instance.</p> <p> This data type is used as a response element in the <code>DescribeOrderableDBInstanceOptions</code> action. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct OrderableDBInstanceOption {
    /// <p>The Availability Zone group for a DB instance.</p>
    pub availability_zone_group: Option<String>,
    /// <p>A list of Availability Zones for a DB instance.</p>
    pub availability_zones: Option<Vec<AvailabilityZone>>,
    /// <p>A list of the available processor features for the DB instance class of a DB instance.</p>
    pub available_processor_features: Option<Vec<AvailableProcessorFeature>>,
    /// <p>The DB instance class for a DB instance.</p>
    pub db_instance_class: Option<String>,
    /// <p>The engine type of a DB instance.</p>
    pub engine: Option<String>,
    /// <p>The engine version of a DB instance.</p>
    pub engine_version: Option<String>,
    /// <p>The license model for a DB instance.</p>
    pub license_model: Option<String>,
    /// <p>Maximum total provisioned IOPS for a DB instance.</p>
    pub max_iops_per_db_instance: Option<i64>,
    /// <p>Maximum provisioned IOPS per GiB for a DB instance.</p>
    pub max_iops_per_gib: Option<f64>,
    /// <p>Maximum storage size for a DB instance.</p>
    pub max_storage_size: Option<i64>,
    /// <p>Minimum total provisioned IOPS for a DB instance.</p>
    pub min_iops_per_db_instance: Option<i64>,
    /// <p>Minimum provisioned IOPS per GiB for a DB instance.</p>
    pub min_iops_per_gib: Option<f64>,
    /// <p>Minimum storage size for a DB instance.</p>
    pub min_storage_size: Option<i64>,
    /// <p>Indicates whether a DB instance is Multi-AZ capable.</p>
    pub multi_az_capable: Option<bool>,
    /// <p>Whether a DB instance supports RDS on Outposts.</p> <p>For more information about RDS on Outposts, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Amazon RDS on Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide.</i> </p>
    pub outpost_capable: Option<bool>,
    /// <p>Indicates whether a DB instance can have a read replica.</p>
    pub read_replica_capable: Option<bool>,
    /// <p>Indicates the storage type for a DB instance.</p>
    pub storage_type: Option<String>,
    /// <p>The list of supported modes for Database Activity Streams. Aurora PostgreSQL returns the value <code>[sync, async]</code>. Aurora MySQL and RDS for Oracle return <code>[async]</code> only. If Database Activity Streams isn't supported, the return value is an empty list.</p>
    pub supported_activity_stream_modes: Option<Vec<String>>,
    /// <p>A list of the supported DB engine modes.</p>
    pub supported_engine_modes: Option<Vec<String>>,
    /// <p>Indicates whether a DB instance supports Enhanced Monitoring at intervals from 1 to 60 seconds.</p>
    pub supports_enhanced_monitoring: Option<bool>,
    /// <p>A value that indicates whether you can use Aurora global databases with a specific combination of other DB engine attributes.</p>
    pub supports_global_databases: Option<bool>,
    /// <p>Indicates whether a DB instance supports IAM database authentication.</p>
    pub supports_iam_database_authentication: Option<bool>,
    /// <p>Indicates whether a DB instance supports provisioned IOPS.</p>
    pub supports_iops: Option<bool>,
    /// <p>Whether a DB instance supports Kerberos Authentication.</p>
    pub supports_kerberos_authentication: Option<bool>,
    /// <p>True if a DB instance supports Performance Insights, otherwise false.</p>
    pub supports_performance_insights: Option<bool>,
    /// <p>Whether Amazon RDS can automatically scale storage for DB instances that use the specified DB instance class.</p>
    pub supports_storage_autoscaling: Option<bool>,
    /// <p>Indicates whether a DB instance supports encrypted storage.</p>
    pub supports_storage_encryption: Option<bool>,
    /// <p>Indicates whether a DB instance is in a VPC.</p>
    pub vpc: Option<bool>,
}

#[allow(dead_code)]
struct OrderableDBInstanceOptionDeserializer;
impl OrderableDBInstanceOptionDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<OrderableDBInstanceOption, XmlParseError> {
        deserialize_elements::<_, OrderableDBInstanceOption, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "AvailabilityZoneGroup" => {
                        obj.availability_zone_group = Some(StringDeserializer::deserialize(
                            "AvailabilityZoneGroup",
                            stack,
                        )?);
                    }
                    "AvailabilityZones" => {
                        obj.availability_zones.get_or_insert(vec![]).extend(
                            AvailabilityZoneListDeserializer::deserialize(
                                "AvailabilityZones",
                                stack,
                            )?,
                        );
                    }
                    "AvailableProcessorFeatures" => {
                        obj.available_processor_features
                            .get_or_insert(vec![])
                            .extend(AvailableProcessorFeatureListDeserializer::deserialize(
                                "AvailableProcessorFeatures",
                                stack,
                            )?);
                    }
                    "DBInstanceClass" => {
                        obj.db_instance_class =
                            Some(StringDeserializer::deserialize("DBInstanceClass", stack)?);
                    }
                    "Engine" => {
                        obj.engine = Some(StringDeserializer::deserialize("Engine", stack)?);
                    }
                    "EngineVersion" => {
                        obj.engine_version =
                            Some(StringDeserializer::deserialize("EngineVersion", stack)?);
                    }
                    "LicenseModel" => {
                        obj.license_model =
                            Some(StringDeserializer::deserialize("LicenseModel", stack)?);
                    }
                    "MaxIopsPerDbInstance" => {
                        obj.max_iops_per_db_instance =
                            Some(IntegerOptionalDeserializer::deserialize(
                                "MaxIopsPerDbInstance",
                                stack,
                            )?);
                    }
                    "MaxIopsPerGib" => {
                        obj.max_iops_per_gib = Some(DoubleOptionalDeserializer::deserialize(
                            "MaxIopsPerGib",
                            stack,
                        )?);
                    }
                    "MaxStorageSize" => {
                        obj.max_storage_size = Some(IntegerOptionalDeserializer::deserialize(
                            "MaxStorageSize",
                            stack,
                        )?);
                    }
                    "MinIopsPerDbInstance" => {
                        obj.min_iops_per_db_instance =
                            Some(IntegerOptionalDeserializer::deserialize(
                                "MinIopsPerDbInstance",
                                stack,
                            )?);
                    }
                    "MinIopsPerGib" => {
                        obj.min_iops_per_gib = Some(DoubleOptionalDeserializer::deserialize(
                            "MinIopsPerGib",
                            stack,
                        )?);
                    }
                    "MinStorageSize" => {
                        obj.min_storage_size = Some(IntegerOptionalDeserializer::deserialize(
                            "MinStorageSize",
                            stack,
                        )?);
                    }
                    "MultiAZCapable" => {
                        obj.multi_az_capable =
                            Some(BooleanDeserializer::deserialize("MultiAZCapable", stack)?);
                    }
                    "OutpostCapable" => {
                        obj.outpost_capable =
                            Some(BooleanDeserializer::deserialize("OutpostCapable", stack)?);
                    }
                    "ReadReplicaCapable" => {
                        obj.read_replica_capable = Some(BooleanDeserializer::deserialize(
                            "ReadReplicaCapable",
                            stack,
                        )?);
                    }
                    "StorageType" => {
                        obj.storage_type =
                            Some(StringDeserializer::deserialize("StorageType", stack)?);
                    }
                    "SupportedActivityStreamModes" => {
                        obj.supported_activity_stream_modes
                            .get_or_insert(vec![])
                            .extend(ActivityStreamModeListDeserializer::deserialize(
                                "SupportedActivityStreamModes",
                                stack,
                            )?);
                    }
                    "SupportedEngineModes" => {
                        obj.supported_engine_modes.get_or_insert(vec![]).extend(
                            EngineModeListDeserializer::deserialize("SupportedEngineModes", stack)?,
                        );
                    }
                    "SupportsEnhancedMonitoring" => {
                        obj.supports_enhanced_monitoring = Some(BooleanDeserializer::deserialize(
                            "SupportsEnhancedMonitoring",
                            stack,
                        )?);
                    }
                    "SupportsGlobalDatabases" => {
                        obj.supports_global_databases = Some(BooleanDeserializer::deserialize(
                            "SupportsGlobalDatabases",
                            stack,
                        )?);
                    }
                    "SupportsIAMDatabaseAuthentication" => {
                        obj.supports_iam_database_authentication =
                            Some(BooleanDeserializer::deserialize(
                                "SupportsIAMDatabaseAuthentication",
                                stack,
                            )?);
                    }
                    "SupportsIops" => {
                        obj.supports_iops =
                            Some(BooleanDeserializer::deserialize("SupportsIops", stack)?);
                    }
                    "SupportsKerberosAuthentication" => {
                        obj.supports_kerberos_authentication =
                            Some(BooleanOptionalDeserializer::deserialize(
                                "SupportsKerberosAuthentication",
                                stack,
                            )?);
                    }
                    "SupportsPerformanceInsights" => {
                        obj.supports_performance_insights = Some(BooleanDeserializer::deserialize(
                            "SupportsPerformanceInsights",
                            stack,
                        )?);
                    }
                    "SupportsStorageAutoscaling" => {
                        obj.supports_storage_autoscaling =
                            Some(BooleanOptionalDeserializer::deserialize(
                                "SupportsStorageAutoscaling",
                                stack,
                            )?);
                    }
                    "SupportsStorageEncryption" => {
                        obj.supports_storage_encryption = Some(BooleanDeserializer::deserialize(
                            "SupportsStorageEncryption",
                            stack,
                        )?);
                    }
                    "Vpc" => {
                        obj.vpc = Some(BooleanDeserializer::deserialize("Vpc", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct OrderableDBInstanceOptionsListDeserializer;
impl OrderableDBInstanceOptionsListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<OrderableDBInstanceOption>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "OrderableDBInstanceOption" {
                obj.push(OrderableDBInstanceOptionDeserializer::deserialize(
                    "OrderableDBInstanceOption",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p> Contains the result of a successful invocation of the <code>DescribeOrderableDBInstanceOptions</code> action. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct OrderableDBInstanceOptionsMessage {
    /// <p> An optional pagination token provided by a previous OrderableDBInstanceOptions request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> . </p>
    pub marker: Option<String>,
    /// <p>An <code>OrderableDBInstanceOption</code> structure containing information about orderable options for the DB instance.</p>
    pub orderable_db_instance_options: Option<Vec<OrderableDBInstanceOption>>,
}

#[allow(dead_code)]
struct OrderableDBInstanceOptionsMessageDeserializer;
impl OrderableDBInstanceOptionsMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<OrderableDBInstanceOptionsMessage, XmlParseError> {
        deserialize_elements::<_, OrderableDBInstanceOptionsMessage, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Marker" => {
                        obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                    }
                    "OrderableDBInstanceOptions" => {
                        obj.orderable_db_instance_options
                            .get_or_insert(vec![])
                            .extend(OrderableDBInstanceOptionsListDeserializer::deserialize(
                                "OrderableDBInstanceOptions",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>A data type that represents an Outpost.</p> <p>For more information about RDS on Outposts, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Amazon RDS on Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide.</i> </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct Outpost {
    /// <p>The Amazon Resource Name (ARN) of the Outpost.</p>
    pub arn: Option<String>,
}

#[allow(dead_code)]
struct OutpostDeserializer;
impl OutpostDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Outpost, XmlParseError> {
        deserialize_elements::<_, Outpost, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Arn" => {
                    obj.arn = Some(StringDeserializer::deserialize("Arn", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p> This data type is used as a request parameter in the <code>ModifyDBParameterGroup</code> and <code>ResetDBParameterGroup</code> actions. </p> <p>This data type is used as a response element in the <code>DescribeEngineDefaultParameters</code> and <code>DescribeDBParameters</code> actions.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct Parameter {
    /// <p>Specifies the valid range of values for the parameter.</p>
    pub allowed_values: Option<String>,
    /// <p>Indicates when to apply parameter updates.</p>
    pub apply_method: Option<String>,
    /// <p>Specifies the engine specific parameters type.</p>
    pub apply_type: Option<String>,
    /// <p>Specifies the valid data type for the parameter.</p>
    pub data_type: Option<String>,
    /// <p>Provides a description of the parameter.</p>
    pub description: Option<String>,
    /// <p> Indicates whether (<code>true</code>) or not (<code>false</code>) the parameter can be modified. Some parameters have security or operational implications that prevent them from being changed. </p>
    pub is_modifiable: Option<bool>,
    /// <p>The earliest engine version to which the parameter can apply.</p>
    pub minimum_engine_version: Option<String>,
    /// <p>Specifies the name of the parameter.</p>
    pub parameter_name: Option<String>,
    /// <p>Specifies the value of the parameter.</p>
    pub parameter_value: Option<String>,
    /// <p>Indicates the source of the parameter value.</p>
    pub source: Option<String>,
    /// <p>The valid DB engine modes.</p>
    pub supported_engine_modes: Option<Vec<String>>,
}

#[allow(dead_code)]
struct ParameterDeserializer;
impl ParameterDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Parameter, XmlParseError> {
        deserialize_elements::<_, Parameter, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "AllowedValues" => {
                    obj.allowed_values =
                        Some(StringDeserializer::deserialize("AllowedValues", stack)?);
                }
                "ApplyMethod" => {
                    obj.apply_method =
                        Some(ApplyMethodDeserializer::deserialize("ApplyMethod", stack)?);
                }
                "ApplyType" => {
                    obj.apply_type = Some(StringDeserializer::deserialize("ApplyType", stack)?);
                }
                "DataType" => {
                    obj.data_type = Some(StringDeserializer::deserialize("DataType", stack)?);
                }
                "Description" => {
                    obj.description = Some(StringDeserializer::deserialize("Description", stack)?);
                }
                "IsModifiable" => {
                    obj.is_modifiable =
                        Some(BooleanDeserializer::deserialize("IsModifiable", stack)?);
                }
                "MinimumEngineVersion" => {
                    obj.minimum_engine_version = Some(StringDeserializer::deserialize(
                        "MinimumEngineVersion",
                        stack,
                    )?);
                }
                "ParameterName" => {
                    obj.parameter_name =
                        Some(StringDeserializer::deserialize("ParameterName", stack)?);
                }
                "ParameterValue" => {
                    obj.parameter_value =
                        Some(StringDeserializer::deserialize("ParameterValue", stack)?);
                }
                "Source" => {
                    obj.source = Some(StringDeserializer::deserialize("Source", stack)?);
                }
                "SupportedEngineModes" => {
                    obj.supported_engine_modes.get_or_insert(vec![]).extend(
                        EngineModeListDeserializer::deserialize("SupportedEngineModes", stack)?,
                    );
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}

/// Serialize `Parameter` contents to a `SignedRequest`.
struct ParameterSerializer;
impl ParameterSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Parameter) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.allowed_values {
            params.put(&format!("{}{}", prefix, "AllowedValues"), &field_value);
        }
        if let Some(ref field_value) = obj.apply_method {
            params.put(&format!("{}{}", prefix, "ApplyMethod"), &field_value);
        }
        if let Some(ref field_value) = obj.apply_type {
            params.put(&format!("{}{}", prefix, "ApplyType"), &field_value);
        }
        if let Some(ref field_value) = obj.data_type {
            params.put(&format!("{}{}", prefix, "DataType"), &field_value);
        }
        if let Some(ref field_value) = obj.description {
            params.put(&format!("{}{}", prefix, "Description"), &field_value);
        }
        if let Some(ref field_value) = obj.is_modifiable {
            params.put(&format!("{}{}", prefix, "IsModifiable"), &field_value);
        }
        if let Some(ref field_value) = obj.minimum_engine_version {
            params.put(
                &format!("{}{}", prefix, "MinimumEngineVersion"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.parameter_name {
            params.put(&format!("{}{}", prefix, "ParameterName"), &field_value);
        }
        if let Some(ref field_value) = obj.parameter_value {
            params.put(&format!("{}{}", prefix, "ParameterValue"), &field_value);
        }
        if let Some(ref field_value) = obj.source {
            params.put(&format!("{}{}", prefix, "Source"), &field_value);
        }
        if let Some(ref field_value) = obj.supported_engine_modes {
            EngineModeListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "SupportedEngineModes"),
                field_value,
            );
        }
    }
}

#[allow(dead_code)]
struct ParametersListDeserializer;
impl ParametersListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<Parameter>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "Parameter" {
                obj.push(ParameterDeserializer::deserialize("Parameter", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}

/// Serialize `ParametersList` contents to a `SignedRequest`.
struct ParametersListSerializer;
impl ParametersListSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<Parameter>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.member.{}", name, index + 1);
            ParameterSerializer::serialize(params, &key, obj);
        }
    }
}

/// <p>A list of the log types whose configuration is still pending. In other words, these log types are in the process of being activated or deactivated.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct PendingCloudwatchLogsExports {
    /// <p>Log types that are in the process of being enabled. After they are enabled, these log types are exported to CloudWatch Logs.</p>
    pub log_types_to_disable: Option<Vec<String>>,
    /// <p>Log types that are in the process of being deactivated. After they are deactivated, these log types aren't exported to CloudWatch Logs.</p>
    pub log_types_to_enable: Option<Vec<String>>,
}

#[allow(dead_code)]
struct PendingCloudwatchLogsExportsDeserializer;
impl PendingCloudwatchLogsExportsDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<PendingCloudwatchLogsExports, XmlParseError> {
        deserialize_elements::<_, PendingCloudwatchLogsExports, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "LogTypesToDisable" => {
                        obj.log_types_to_disable.get_or_insert(vec![]).extend(
                            LogTypeListDeserializer::deserialize("LogTypesToDisable", stack)?,
                        );
                    }
                    "LogTypesToEnable" => {
                        obj.log_types_to_enable.get_or_insert(vec![]).extend(
                            LogTypeListDeserializer::deserialize("LogTypesToEnable", stack)?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Provides information about a pending maintenance action for a resource.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct PendingMaintenanceAction {
    /// <p>The type of pending maintenance action that is available for the resource. Valid actions are <code>system-update</code>, <code>db-upgrade</code>, <code>hardware-maintenance</code>, and <code>ca-certificate-rotation</code>.</p>
    pub action: Option<String>,
    /// <p>The date of the maintenance window when the action is applied. The maintenance action is applied to the resource during its first maintenance window after this date.</p>
    pub auto_applied_after_date: Option<String>,
    /// <p>The effective date when the pending maintenance action is applied to the resource. This date takes into account opt-in requests received from the <code>ApplyPendingMaintenanceAction</code> API, the <code>AutoAppliedAfterDate</code>, and the <code>ForcedApplyDate</code>. This value is blank if an opt-in request has not been received and nothing has been specified as <code>AutoAppliedAfterDate</code> or <code>ForcedApplyDate</code>.</p>
    pub current_apply_date: Option<String>,
    /// <p>A description providing more detail about the maintenance action.</p>
    pub description: Option<String>,
    /// <p>The date when the maintenance action is automatically applied.</p> <p>On this date, the maintenance action is applied to the resource as soon as possible, regardless of the maintenance window for the resource. There might be a delay of one or more days from this date before the maintenance action is applied.</p>
    pub forced_apply_date: Option<String>,
    /// <p>Indicates the type of opt-in request that has been received for the resource.</p>
    pub opt_in_status: Option<String>,
}

#[allow(dead_code)]
struct PendingMaintenanceActionDeserializer;
impl PendingMaintenanceActionDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<PendingMaintenanceAction, XmlParseError> {
        deserialize_elements::<_, PendingMaintenanceAction, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Action" => {
                        obj.action = Some(StringDeserializer::deserialize("Action", stack)?);
                    }
                    "AutoAppliedAfterDate" => {
                        obj.auto_applied_after_date = Some(TStampDeserializer::deserialize(
                            "AutoAppliedAfterDate",
                            stack,
                        )?);
                    }
                    "CurrentApplyDate" => {
                        obj.current_apply_date =
                            Some(TStampDeserializer::deserialize("CurrentApplyDate", stack)?);
                    }
                    "Description" => {
                        obj.description =
                            Some(StringDeserializer::deserialize("Description", stack)?);
                    }
                    "ForcedApplyDate" => {
                        obj.forced_apply_date =
                            Some(TStampDeserializer::deserialize("ForcedApplyDate", stack)?);
                    }
                    "OptInStatus" => {
                        obj.opt_in_status =
                            Some(StringDeserializer::deserialize("OptInStatus", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct PendingMaintenanceActionDetailsDeserializer;
impl PendingMaintenanceActionDetailsDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<PendingMaintenanceAction>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "PendingMaintenanceAction" {
                obj.push(PendingMaintenanceActionDeserializer::deserialize(
                    "PendingMaintenanceAction",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct PendingMaintenanceActionsDeserializer;
impl PendingMaintenanceActionsDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<ResourcePendingMaintenanceActions>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "ResourcePendingMaintenanceActions" {
                obj.push(ResourcePendingMaintenanceActionsDeserializer::deserialize(
                    "ResourcePendingMaintenanceActions",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Data returned from the <b>DescribePendingMaintenanceActions</b> action.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct PendingMaintenanceActionsMessage {
    /// <p> An optional pagination token provided by a previous <code>DescribePendingMaintenanceActions</code> request. If this parameter is specified, the response includes only records beyond the marker, up to a number of records specified by <code>MaxRecords</code>. </p>
    pub marker: Option<String>,
    /// <p>A list of the pending maintenance actions for the resource.</p>
    pub pending_maintenance_actions: Option<Vec<ResourcePendingMaintenanceActions>>,
}

#[allow(dead_code)]
struct PendingMaintenanceActionsMessageDeserializer;
impl PendingMaintenanceActionsMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<PendingMaintenanceActionsMessage, XmlParseError> {
        deserialize_elements::<_, PendingMaintenanceActionsMessage, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Marker" => {
                        obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                    }
                    "PendingMaintenanceActions" => {
                        obj.pending_maintenance_actions
                            .get_or_insert(vec![])
                            .extend(PendingMaintenanceActionsDeserializer::deserialize(
                                "PendingMaintenanceActions",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p> This data type is used as a response element in the <code>ModifyDBInstance</code> operation and contains changes that will be applied during the next maintenance window. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct PendingModifiedValues {
    /// <p>The allocated storage size for the DB instance specified in gibibytes .</p>
    pub allocated_storage: Option<i64>,
    /// <p>The number of days for which automated backups are retained.</p>
    pub backup_retention_period: Option<i64>,
    /// <p>The identifier of the CA certificate for the DB instance.</p>
    pub ca_certificate_identifier: Option<String>,
    /// <p>The name of the compute and memory capacity class for the DB instance.</p>
    pub db_instance_class: Option<String>,
    /// <p>The database identifier for the DB instance.</p>
    pub db_instance_identifier: Option<String>,
    /// <p>The DB subnet group for the DB instance.</p>
    pub db_subnet_group_name: Option<String>,
    /// <p>The database engine version.</p>
    pub engine_version: Option<String>,
    /// <p>Whether mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled.</p>
    pub iam_database_authentication_enabled: Option<bool>,
    /// <p>The Provisioned IOPS value for the DB instance.</p>
    pub iops: Option<i64>,
    /// <p>The license model for the DB instance.</p> <p>Valid values: <code>license-included</code> | <code>bring-your-own-license</code> | <code>general-public-license</code> </p>
    pub license_model: Option<String>,
    /// <p>The master credentials for the DB instance.</p>
    pub master_user_password: Option<String>,
    /// <p>A value that indicates that the Single-AZ DB instance will change to a Multi-AZ deployment.</p>
    pub multi_az: Option<bool>,
    pub pending_cloudwatch_logs_exports: Option<PendingCloudwatchLogsExports>,
    /// <p>The port for the DB instance.</p>
    pub port: Option<i64>,
    /// <p>The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.</p>
    pub processor_features: Option<Vec<ProcessorFeature>>,
    /// <p>The storage type of the DB instance.</p>
    pub storage_type: Option<String>,
}

#[allow(dead_code)]
struct PendingModifiedValuesDeserializer;
impl PendingModifiedValuesDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<PendingModifiedValues, XmlParseError> {
        deserialize_elements::<_, PendingModifiedValues, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "AllocatedStorage" => {
                    obj.allocated_storage = Some(IntegerOptionalDeserializer::deserialize(
                        "AllocatedStorage",
                        stack,
                    )?);
                }
                "BackupRetentionPeriod" => {
                    obj.backup_retention_period = Some(IntegerOptionalDeserializer::deserialize(
                        "BackupRetentionPeriod",
                        stack,
                    )?);
                }
                "CACertificateIdentifier" => {
                    obj.ca_certificate_identifier = Some(StringDeserializer::deserialize(
                        "CACertificateIdentifier",
                        stack,
                    )?);
                }
                "DBInstanceClass" => {
                    obj.db_instance_class =
                        Some(StringDeserializer::deserialize("DBInstanceClass", stack)?);
                }
                "DBInstanceIdentifier" => {
                    obj.db_instance_identifier = Some(StringDeserializer::deserialize(
                        "DBInstanceIdentifier",
                        stack,
                    )?);
                }
                "DBSubnetGroupName" => {
                    obj.db_subnet_group_name =
                        Some(StringDeserializer::deserialize("DBSubnetGroupName", stack)?);
                }
                "EngineVersion" => {
                    obj.engine_version =
                        Some(StringDeserializer::deserialize("EngineVersion", stack)?);
                }
                "IAMDatabaseAuthenticationEnabled" => {
                    obj.iam_database_authentication_enabled =
                        Some(BooleanOptionalDeserializer::deserialize(
                            "IAMDatabaseAuthenticationEnabled",
                            stack,
                        )?);
                }
                "Iops" => {
                    obj.iops = Some(IntegerOptionalDeserializer::deserialize("Iops", stack)?);
                }
                "LicenseModel" => {
                    obj.license_model =
                        Some(StringDeserializer::deserialize("LicenseModel", stack)?);
                }
                "MasterUserPassword" => {
                    obj.master_user_password = Some(StringDeserializer::deserialize(
                        "MasterUserPassword",
                        stack,
                    )?);
                }
                "MultiAZ" => {
                    obj.multi_az =
                        Some(BooleanOptionalDeserializer::deserialize("MultiAZ", stack)?);
                }
                "PendingCloudwatchLogsExports" => {
                    obj.pending_cloudwatch_logs_exports =
                        Some(PendingCloudwatchLogsExportsDeserializer::deserialize(
                            "PendingCloudwatchLogsExports",
                            stack,
                        )?);
                }
                "Port" => {
                    obj.port = Some(IntegerOptionalDeserializer::deserialize("Port", stack)?);
                }
                "ProcessorFeatures" => {
                    obj.processor_features.get_or_insert(vec![]).extend(
                        ProcessorFeatureListDeserializer::deserialize("ProcessorFeatures", stack)?,
                    );
                }
                "StorageType" => {
                    obj.storage_type = Some(StringDeserializer::deserialize("StorageType", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>Contains the processor features of a DB instance class.</p> <p>To specify the number of CPU cores, use the <code>coreCount</code> feature name for the <code>Name</code> parameter. To specify the number of threads per core, use the <code>threadsPerCore</code> feature name for the <code>Name</code> parameter.</p> <p>You can set the processor features of the DB instance class for a DB instance when you call one of the following actions:</p> <ul> <li> <p> <code>CreateDBInstance</code> </p> </li> <li> <p> <code>ModifyDBInstance</code> </p> </li> <li> <p> <code>RestoreDBInstanceFromDBSnapshot</code> </p> </li> <li> <p> <code>RestoreDBInstanceFromS3</code> </p> </li> <li> <p> <code>RestoreDBInstanceToPointInTime</code> </p> </li> </ul> <p>You can view the valid processor values for a particular instance class by calling the <code>DescribeOrderableDBInstanceOptions</code> action and specifying the instance class for the <code>DBInstanceClass</code> parameter.</p> <p>In addition, you can use the following actions for DB instance class processor information:</p> <ul> <li> <p> <code>DescribeDBInstances</code> </p> </li> <li> <p> <code>DescribeDBSnapshots</code> </p> </li> <li> <p> <code>DescribeValidDBInstanceModifications</code> </p> </li> </ul> <p>If you call <code>DescribeDBInstances</code>, <code>ProcessorFeature</code> returns non-null values only if the following conditions are met:</p> <ul> <li> <p>You are accessing an Oracle DB instance.</p> </li> <li> <p>Your Oracle DB instance class supports configuring the number of CPU cores and threads per core.</p> </li> <li> <p>The current number CPU cores and threads is set to a non-default value.</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html#USER_ConfigureProcessor">Configuring the Processor of the DB Instance Class</a> in the <i>Amazon RDS User Guide. </i> </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ProcessorFeature {
    /// <p>The name of the processor feature. Valid names are <code>coreCount</code> and <code>threadsPerCore</code>.</p>
    pub name: Option<String>,
    /// <p>The value of a processor feature name.</p>
    pub value: Option<String>,
}

#[allow(dead_code)]
struct ProcessorFeatureDeserializer;
impl ProcessorFeatureDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ProcessorFeature, XmlParseError> {
        deserialize_elements::<_, ProcessorFeature, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Name" => {
                    obj.name = Some(StringDeserializer::deserialize("Name", stack)?);
                }
                "Value" => {
                    obj.value = Some(StringDeserializer::deserialize("Value", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}

/// Serialize `ProcessorFeature` contents to a `SignedRequest`.
struct ProcessorFeatureSerializer;
impl ProcessorFeatureSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ProcessorFeature) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.name {
            params.put(&format!("{}{}", prefix, "Name"), &field_value);
        }
        if let Some(ref field_value) = obj.value {
            params.put(&format!("{}{}", prefix, "Value"), &field_value);
        }
    }
}

#[allow(dead_code)]
struct ProcessorFeatureListDeserializer;
impl ProcessorFeatureListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<ProcessorFeature>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "ProcessorFeature" {
                obj.push(ProcessorFeatureDeserializer::deserialize(
                    "ProcessorFeature",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}

/// Serialize `ProcessorFeatureList` contents to a `SignedRequest`.
struct ProcessorFeatureListSerializer;
impl ProcessorFeatureListSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<ProcessorFeature>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.member.{}", name, index + 1);
            ProcessorFeatureSerializer::serialize(params, &key, obj);
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct PromoteReadReplicaDBClusterMessage {
    /// <p>The identifier of the DB cluster read replica to promote. This parameter isn't case-sensitive. </p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing DB cluster read replica.</p> </li> </ul> <p>Example: <code>my-cluster-replica1</code> </p>
    pub db_cluster_identifier: String,
}

/// Serialize `PromoteReadReplicaDBClusterMessage` contents to a `SignedRequest`.
struct PromoteReadReplicaDBClusterMessageSerializer;
impl PromoteReadReplicaDBClusterMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &PromoteReadReplicaDBClusterMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "DBClusterIdentifier"),
            &obj.db_cluster_identifier,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct PromoteReadReplicaDBClusterResult {
    pub db_cluster: Option<DBCluster>,
}

#[allow(dead_code)]
struct PromoteReadReplicaDBClusterResultDeserializer;
impl PromoteReadReplicaDBClusterResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<PromoteReadReplicaDBClusterResult, XmlParseError> {
        deserialize_elements::<_, PromoteReadReplicaDBClusterResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DBCluster" => {
                        obj.db_cluster =
                            Some(DBClusterDeserializer::deserialize("DBCluster", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct PromoteReadReplicaMessage {
    /// <p><p>The number of days for which automated backups are retained. Setting this parameter to a positive number enables backups. Setting this parameter to 0 disables automated backups.</p> <p>Default: 1</p> <p>Constraints:</p> <ul> <li> <p>Must be a value from 0 to 35.</p> </li> <li> <p>Can&#39;t be set to 0 if the DB instance is a source to read replicas.</p> </li> </ul></p>
    pub backup_retention_period: Option<i64>,
    /// <p>The DB instance identifier. This value is stored as a lowercase string.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing read replica DB instance.</p> </li> </ul> <p>Example: <code>mydbinstance</code> </p>
    pub db_instance_identifier: String,
    /// <p><p> The daily time range during which automated backups are created if automated backups are enabled, using the <code>BackupRetentionPeriod</code> parameter. </p> <p> The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region. To see the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AdjustingTheMaintenanceWindow.html"> Adjusting the Preferred Maintenance Window</a> in the <i>Amazon RDS User Guide.</i> </p> <p>Constraints:</p> <ul> <li> <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p> </li> <li> <p>Must be in Universal Coordinated Time (UTC).</p> </li> <li> <p>Must not conflict with the preferred maintenance window.</p> </li> <li> <p>Must be at least 30 minutes.</p> </li> </ul></p>
    pub preferred_backup_window: Option<String>,
}

/// Serialize `PromoteReadReplicaMessage` contents to a `SignedRequest`.
struct PromoteReadReplicaMessageSerializer;
impl PromoteReadReplicaMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &PromoteReadReplicaMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.backup_retention_period {
            params.put(
                &format!("{}{}", prefix, "BackupRetentionPeriod"),
                &field_value,
            );
        }
        params.put(
            &format!("{}{}", prefix, "DBInstanceIdentifier"),
            &obj.db_instance_identifier,
        );
        if let Some(ref field_value) = obj.preferred_backup_window {
            params.put(
                &format!("{}{}", prefix, "PreferredBackupWindow"),
                &field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct PromoteReadReplicaResult {
    pub db_instance: Option<DBInstance>,
}

#[allow(dead_code)]
struct PromoteReadReplicaResultDeserializer;
impl PromoteReadReplicaResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<PromoteReadReplicaResult, XmlParseError> {
        deserialize_elements::<_, PromoteReadReplicaResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DBInstance" => {
                        obj.db_instance =
                            Some(DBInstanceDeserializer::deserialize("DBInstance", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct PurchaseReservedDBInstancesOfferingMessage {
    /// <p>The number of instances to reserve.</p> <p>Default: <code>1</code> </p>
    pub db_instance_count: Option<i64>,
    /// <p>Customer-specified identifier to track this reservation.</p> <p>Example: myreservationID</p>
    pub reserved_db_instance_id: Option<String>,
    /// <p>The ID of the Reserved DB instance offering to purchase.</p> <p>Example: 438012d3-4052-4cc7-b2e3-8d3372e0e706</p>
    pub reserved_db_instances_offering_id: String,
    pub tags: Option<Vec<Tag>>,
}

/// Serialize `PurchaseReservedDBInstancesOfferingMessage` contents to a `SignedRequest`.
struct PurchaseReservedDBInstancesOfferingMessageSerializer;
impl PurchaseReservedDBInstancesOfferingMessageSerializer {
    fn serialize(
        params: &mut Params,
        name: &str,
        obj: &PurchaseReservedDBInstancesOfferingMessage,
    ) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.db_instance_count {
            params.put(&format!("{}{}", prefix, "DBInstanceCount"), &field_value);
        }
        if let Some(ref field_value) = obj.reserved_db_instance_id {
            params.put(
                &format!("{}{}", prefix, "ReservedDBInstanceId"),
                &field_value,
            );
        }
        params.put(
            &format!("{}{}", prefix, "ReservedDBInstancesOfferingId"),
            &obj.reserved_db_instances_offering_id,
        );
        if let Some(ref field_value) = obj.tags {
            TagListSerializer::serialize(params, &format!("{}{}", prefix, "Tag"), field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct PurchaseReservedDBInstancesOfferingResult {
    pub reserved_db_instance: Option<ReservedDBInstance>,
}

#[allow(dead_code)]
struct PurchaseReservedDBInstancesOfferingResultDeserializer;
impl PurchaseReservedDBInstancesOfferingResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<PurchaseReservedDBInstancesOfferingResult, XmlParseError> {
        deserialize_elements::<_, PurchaseReservedDBInstancesOfferingResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "ReservedDBInstance" => {
                        obj.reserved_db_instance =
                            Some(ReservedDBInstanceDeserializer::deserialize(
                                "ReservedDBInstance",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>A range of integer values.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct Range {
    /// <p>The minimum value in the range.</p>
    pub from: Option<i64>,
    /// <p>The step value for the range. For example, if you have a range of 5,000 to 10,000, with a step value of 1,000, the valid values start at 5,000 and step up by 1,000. Even though 7,500 is within the range, it isn't a valid value for the range. The valid values are 5,000, 6,000, 7,000, 8,000... </p>
    pub step: Option<i64>,
    /// <p>The maximum value in the range.</p>
    pub to: Option<i64>,
}

#[allow(dead_code)]
struct RangeDeserializer;
impl RangeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<Range, XmlParseError> {
        deserialize_elements::<_, Range, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "From" => {
                    obj.from = Some(IntegerDeserializer::deserialize("From", stack)?);
                }
                "Step" => {
                    obj.step = Some(IntegerOptionalDeserializer::deserialize("Step", stack)?);
                }
                "To" => {
                    obj.to = Some(IntegerDeserializer::deserialize("To", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct RangeListDeserializer;
impl RangeListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<Range>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "Range" {
                obj.push(RangeDeserializer::deserialize("Range", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct ReadReplicaDBClusterIdentifierListDeserializer;
impl ReadReplicaDBClusterIdentifierListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<String>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "ReadReplicaDBClusterIdentifier" {
                obj.push(StringDeserializer::deserialize(
                    "ReadReplicaDBClusterIdentifier",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct ReadReplicaDBInstanceIdentifierListDeserializer;
impl ReadReplicaDBInstanceIdentifierListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<String>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "ReadReplicaDBInstanceIdentifier" {
                obj.push(StringDeserializer::deserialize(
                    "ReadReplicaDBInstanceIdentifier",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct ReadReplicaIdentifierListDeserializer;
impl ReadReplicaIdentifierListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<String>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "ReadReplicaIdentifier" {
                obj.push(StringDeserializer::deserialize(
                    "ReadReplicaIdentifier",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct ReadersArnListDeserializer;
impl ReadersArnListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<String>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(StringDeserializer::deserialize("member", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct RebootDBInstanceMessage {
    /// <p><p>The DB instance identifier. This parameter is stored as a lowercase string.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing DBInstance.</p> </li> </ul></p>
    pub db_instance_identifier: String,
    /// <p> A value that indicates whether the reboot is conducted through a Multi-AZ failover. </p> <p>Constraint: You can't enable force failover if the instance isn't configured for Multi-AZ.</p>
    pub force_failover: Option<bool>,
}

/// Serialize `RebootDBInstanceMessage` contents to a `SignedRequest`.
struct RebootDBInstanceMessageSerializer;
impl RebootDBInstanceMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &RebootDBInstanceMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "DBInstanceIdentifier"),
            &obj.db_instance_identifier,
        );
        if let Some(ref field_value) = obj.force_failover {
            params.put(&format!("{}{}", prefix, "ForceFailover"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct RebootDBInstanceResult {
    pub db_instance: Option<DBInstance>,
}

#[allow(dead_code)]
struct RebootDBInstanceResultDeserializer;
impl RebootDBInstanceResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<RebootDBInstanceResult, XmlParseError> {
        deserialize_elements::<_, RebootDBInstanceResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "DBInstance" => {
                    obj.db_instance =
                        Some(DBInstanceDeserializer::deserialize("DBInstance", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p> This data type is used as a response element in the <code>DescribeReservedDBInstances</code> and <code>DescribeReservedDBInstancesOfferings</code> actions. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct RecurringCharge {
    /// <p>The amount of the recurring charge.</p>
    pub recurring_charge_amount: Option<f64>,
    /// <p>The frequency of the recurring charge.</p>
    pub recurring_charge_frequency: Option<String>,
}

#[allow(dead_code)]
struct RecurringChargeDeserializer;
impl RecurringChargeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<RecurringCharge, XmlParseError> {
        deserialize_elements::<_, RecurringCharge, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "RecurringChargeAmount" => {
                    obj.recurring_charge_amount = Some(DoubleDeserializer::deserialize(
                        "RecurringChargeAmount",
                        stack,
                    )?);
                }
                "RecurringChargeFrequency" => {
                    obj.recurring_charge_frequency = Some(StringDeserializer::deserialize(
                        "RecurringChargeFrequency",
                        stack,
                    )?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct RecurringChargeListDeserializer;
impl RecurringChargeListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<RecurringCharge>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "RecurringCharge" {
                obj.push(RecurringChargeDeserializer::deserialize(
                    "RecurringCharge",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct RegisterDBProxyTargetsRequest {
    /// <p>One or more DB cluster identifiers.</p>
    pub db_cluster_identifiers: Option<Vec<String>>,
    /// <p>One or more DB instance identifiers.</p>
    pub db_instance_identifiers: Option<Vec<String>>,
    /// <p>The identifier of the <code>DBProxy</code> that is associated with the <code>DBProxyTargetGroup</code>.</p>
    pub db_proxy_name: String,
    /// <p>The identifier of the <code>DBProxyTargetGroup</code>.</p>
    pub target_group_name: Option<String>,
}

/// Serialize `RegisterDBProxyTargetsRequest` contents to a `SignedRequest`.
struct RegisterDBProxyTargetsRequestSerializer;
impl RegisterDBProxyTargetsRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &RegisterDBProxyTargetsRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.db_cluster_identifiers {
            StringListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "DBClusterIdentifiers"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.db_instance_identifiers {
            StringListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "DBInstanceIdentifiers"),
                field_value,
            );
        }
        params.put(&format!("{}{}", prefix, "DBProxyName"), &obj.db_proxy_name);
        if let Some(ref field_value) = obj.target_group_name {
            params.put(&format!("{}{}", prefix, "TargetGroupName"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct RegisterDBProxyTargetsResponse {
    /// <p>One or more <code>DBProxyTarget</code> objects that are created when you register targets with a target group.</p>
    pub db_proxy_targets: Option<Vec<DBProxyTarget>>,
}

#[allow(dead_code)]
struct RegisterDBProxyTargetsResponseDeserializer;
impl RegisterDBProxyTargetsResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<RegisterDBProxyTargetsResponse, XmlParseError> {
        deserialize_elements::<_, RegisterDBProxyTargetsResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DBProxyTargets" => {
                        obj.db_proxy_targets.get_or_insert(vec![]).extend(
                            TargetListDeserializer::deserialize("DBProxyTargets", stack)?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct RemoveFromGlobalClusterMessage {
    /// <p> The Amazon Resource Name (ARN) identifying the cluster that was detached from the Aurora global database cluster. </p>
    pub db_cluster_identifier: Option<String>,
    /// <p> The cluster identifier to detach from the Aurora global database cluster. </p>
    pub global_cluster_identifier: Option<String>,
}

/// Serialize `RemoveFromGlobalClusterMessage` contents to a `SignedRequest`.
struct RemoveFromGlobalClusterMessageSerializer;
impl RemoveFromGlobalClusterMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &RemoveFromGlobalClusterMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.db_cluster_identifier {
            params.put(
                &format!("{}{}", prefix, "DbClusterIdentifier"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.global_cluster_identifier {
            params.put(
                &format!("{}{}", prefix, "GlobalClusterIdentifier"),
                &field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct RemoveFromGlobalClusterResult {
    pub global_cluster: Option<GlobalCluster>,
}

#[allow(dead_code)]
struct RemoveFromGlobalClusterResultDeserializer;
impl RemoveFromGlobalClusterResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<RemoveFromGlobalClusterResult, XmlParseError> {
        deserialize_elements::<_, RemoveFromGlobalClusterResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "GlobalCluster" => {
                        obj.global_cluster = Some(GlobalClusterDeserializer::deserialize(
                            "GlobalCluster",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct RemoveRoleFromDBClusterMessage {
    /// <p>The name of the DB cluster to disassociate the IAM role from.</p>
    pub db_cluster_identifier: String,
    /// <p>The name of the feature for the DB cluster that the IAM role is to be disassociated from. For the list of supported feature names, see <a>DBEngineVersion</a>.</p>
    pub feature_name: Option<String>,
    /// <p>The Amazon Resource Name (ARN) of the IAM role to disassociate from the Aurora DB cluster, for example <code>arn:aws:iam::123456789012:role/AuroraAccessRole</code>.</p>
    pub role_arn: String,
}

/// Serialize `RemoveRoleFromDBClusterMessage` contents to a `SignedRequest`.
struct RemoveRoleFromDBClusterMessageSerializer;
impl RemoveRoleFromDBClusterMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &RemoveRoleFromDBClusterMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "DBClusterIdentifier"),
            &obj.db_cluster_identifier,
        );
        if let Some(ref field_value) = obj.feature_name {
            params.put(&format!("{}{}", prefix, "FeatureName"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "RoleArn"), &obj.role_arn);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct RemoveRoleFromDBInstanceMessage {
    /// <p>The name of the DB instance to disassociate the IAM role from.</p>
    pub db_instance_identifier: String,
    /// <p>The name of the feature for the DB instance that the IAM role is to be disassociated from. For the list of supported feature names, see <code>DBEngineVersion</code>. </p>
    pub feature_name: String,
    /// <p>The Amazon Resource Name (ARN) of the IAM role to disassociate from the DB instance, for example, <code>arn:aws:iam::123456789012:role/AccessRole</code>.</p>
    pub role_arn: String,
}

/// Serialize `RemoveRoleFromDBInstanceMessage` contents to a `SignedRequest`.
struct RemoveRoleFromDBInstanceMessageSerializer;
impl RemoveRoleFromDBInstanceMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &RemoveRoleFromDBInstanceMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "DBInstanceIdentifier"),
            &obj.db_instance_identifier,
        );
        params.put(&format!("{}{}", prefix, "FeatureName"), &obj.feature_name);
        params.put(&format!("{}{}", prefix, "RoleArn"), &obj.role_arn);
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct RemoveSourceIdentifierFromSubscriptionMessage {
    /// <p> The source identifier to be removed from the subscription, such as the <b>DB instance identifier</b> for a DB instance or the name of a security group. </p>
    pub source_identifier: String,
    /// <p>The name of the RDS event notification subscription you want to remove a source identifier from.</p>
    pub subscription_name: String,
}

/// Serialize `RemoveSourceIdentifierFromSubscriptionMessage` contents to a `SignedRequest`.
struct RemoveSourceIdentifierFromSubscriptionMessageSerializer;
impl RemoveSourceIdentifierFromSubscriptionMessageSerializer {
    fn serialize(
        params: &mut Params,
        name: &str,
        obj: &RemoveSourceIdentifierFromSubscriptionMessage,
    ) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "SourceIdentifier"),
            &obj.source_identifier,
        );
        params.put(
            &format!("{}{}", prefix, "SubscriptionName"),
            &obj.subscription_name,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct RemoveSourceIdentifierFromSubscriptionResult {
    pub event_subscription: Option<EventSubscription>,
}

#[allow(dead_code)]
struct RemoveSourceIdentifierFromSubscriptionResultDeserializer;
impl RemoveSourceIdentifierFromSubscriptionResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<RemoveSourceIdentifierFromSubscriptionResult, XmlParseError> {
        deserialize_elements::<_, RemoveSourceIdentifierFromSubscriptionResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "EventSubscription" => {
                        obj.event_subscription = Some(EventSubscriptionDeserializer::deserialize(
                            "EventSubscription",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct RemoveTagsFromResourceMessage {
    /// <p>The Amazon RDS resource that the tags are removed from. This value is an Amazon Resource Name (ARN). For information about creating an ARN, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing"> Constructing an ARN for Amazon RDS</a> in the <i>Amazon RDS User Guide.</i> </p>
    pub resource_name: String,
    /// <p>The tag key (name) of the tag to be removed.</p>
    pub tag_keys: Vec<String>,
}

/// Serialize `RemoveTagsFromResourceMessage` contents to a `SignedRequest`.
struct RemoveTagsFromResourceMessageSerializer;
impl RemoveTagsFromResourceMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &RemoveTagsFromResourceMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "ResourceName"), &obj.resource_name);
        KeyListSerializer::serialize(params, &format!("{}{}", prefix, "TagKeys"), &obj.tag_keys);
    }
}

#[allow(dead_code)]
struct ReplicaModeDeserializer;
impl ReplicaModeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p> This data type is used as a response element in the <code>DescribeReservedDBInstances</code> and <code>PurchaseReservedDBInstancesOffering</code> actions. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ReservedDBInstance {
    /// <p>The currency code for the reserved DB instance.</p>
    pub currency_code: Option<String>,
    /// <p>The DB instance class for the reserved DB instance.</p>
    pub db_instance_class: Option<String>,
    /// <p>The number of reserved DB instances.</p>
    pub db_instance_count: Option<i64>,
    /// <p>The duration of the reservation in seconds.</p>
    pub duration: Option<i64>,
    /// <p>The fixed price charged for this reserved DB instance.</p>
    pub fixed_price: Option<f64>,
    /// <p><p>The unique identifier for the lease associated with the reserved DB instance.</p> <note> <p>Amazon Web Services Support might request the lease ID for an issue related to a reserved DB instance.</p> </note></p>
    pub lease_id: Option<String>,
    /// <p>Indicates if the reservation applies to Multi-AZ deployments.</p>
    pub multi_az: Option<bool>,
    /// <p>The offering type of this reserved DB instance.</p>
    pub offering_type: Option<String>,
    /// <p>The description of the reserved DB instance.</p>
    pub product_description: Option<String>,
    /// <p>The recurring price charged to run this reserved DB instance.</p>
    pub recurring_charges: Option<Vec<RecurringCharge>>,
    /// <p>The Amazon Resource Name (ARN) for the reserved DB instance.</p>
    pub reserved_db_instance_arn: Option<String>,
    /// <p>The unique identifier for the reservation.</p>
    pub reserved_db_instance_id: Option<String>,
    /// <p>The offering identifier.</p>
    pub reserved_db_instances_offering_id: Option<String>,
    /// <p>The time the reservation started.</p>
    pub start_time: Option<String>,
    /// <p>The state of the reserved DB instance.</p>
    pub state: Option<String>,
    /// <p>The hourly price charged for this reserved DB instance.</p>
    pub usage_price: Option<f64>,
}

#[allow(dead_code)]
struct ReservedDBInstanceDeserializer;
impl ReservedDBInstanceDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ReservedDBInstance, XmlParseError> {
        deserialize_elements::<_, ReservedDBInstance, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "CurrencyCode" => {
                    obj.currency_code =
                        Some(StringDeserializer::deserialize("CurrencyCode", stack)?);
                }
                "DBInstanceClass" => {
                    obj.db_instance_class =
                        Some(StringDeserializer::deserialize("DBInstanceClass", stack)?);
                }
                "DBInstanceCount" => {
                    obj.db_instance_count =
                        Some(IntegerDeserializer::deserialize("DBInstanceCount", stack)?);
                }
                "Duration" => {
                    obj.duration = Some(IntegerDeserializer::deserialize("Duration", stack)?);
                }
                "FixedPrice" => {
                    obj.fixed_price = Some(DoubleDeserializer::deserialize("FixedPrice", stack)?);
                }
                "LeaseId" => {
                    obj.lease_id = Some(StringDeserializer::deserialize("LeaseId", stack)?);
                }
                "MultiAZ" => {
                    obj.multi_az = Some(BooleanDeserializer::deserialize("MultiAZ", stack)?);
                }
                "OfferingType" => {
                    obj.offering_type =
                        Some(StringDeserializer::deserialize("OfferingType", stack)?);
                }
                "ProductDescription" => {
                    obj.product_description = Some(StringDeserializer::deserialize(
                        "ProductDescription",
                        stack,
                    )?);
                }
                "RecurringCharges" => {
                    obj.recurring_charges.get_or_insert(vec![]).extend(
                        RecurringChargeListDeserializer::deserialize("RecurringCharges", stack)?,
                    );
                }
                "ReservedDBInstanceArn" => {
                    obj.reserved_db_instance_arn = Some(StringDeserializer::deserialize(
                        "ReservedDBInstanceArn",
                        stack,
                    )?);
                }
                "ReservedDBInstanceId" => {
                    obj.reserved_db_instance_id = Some(StringDeserializer::deserialize(
                        "ReservedDBInstanceId",
                        stack,
                    )?);
                }
                "ReservedDBInstancesOfferingId" => {
                    obj.reserved_db_instances_offering_id = Some(StringDeserializer::deserialize(
                        "ReservedDBInstancesOfferingId",
                        stack,
                    )?);
                }
                "StartTime" => {
                    obj.start_time = Some(TStampDeserializer::deserialize("StartTime", stack)?);
                }
                "State" => {
                    obj.state = Some(StringDeserializer::deserialize("State", stack)?);
                }
                "UsagePrice" => {
                    obj.usage_price = Some(DoubleDeserializer::deserialize("UsagePrice", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct ReservedDBInstanceListDeserializer;
impl ReservedDBInstanceListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<ReservedDBInstance>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "ReservedDBInstance" {
                obj.push(ReservedDBInstanceDeserializer::deserialize(
                    "ReservedDBInstance",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p> Contains the result of a successful invocation of the <code>DescribeReservedDBInstances</code> action. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ReservedDBInstanceMessage {
    /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    pub marker: Option<String>,
    /// <p>A list of reserved DB instances.</p>
    pub reserved_db_instances: Option<Vec<ReservedDBInstance>>,
}

#[allow(dead_code)]
struct ReservedDBInstanceMessageDeserializer;
impl ReservedDBInstanceMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ReservedDBInstanceMessage, XmlParseError> {
        deserialize_elements::<_, ReservedDBInstanceMessage, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Marker" => {
                        obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                    }
                    "ReservedDBInstances" => {
                        obj.reserved_db_instances.get_or_insert(vec![]).extend(
                            ReservedDBInstanceListDeserializer::deserialize(
                                "ReservedDBInstances",
                                stack,
                            )?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p> This data type is used as a response element in the <code>DescribeReservedDBInstancesOfferings</code> action. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ReservedDBInstancesOffering {
    /// <p>The currency code for the reserved DB instance offering.</p>
    pub currency_code: Option<String>,
    /// <p>The DB instance class for the reserved DB instance.</p>
    pub db_instance_class: Option<String>,
    /// <p>The duration of the offering in seconds.</p>
    pub duration: Option<i64>,
    /// <p>The fixed price charged for this offering.</p>
    pub fixed_price: Option<f64>,
    /// <p>Indicates if the offering applies to Multi-AZ deployments.</p>
    pub multi_az: Option<bool>,
    /// <p>The offering type.</p>
    pub offering_type: Option<String>,
    /// <p>The database engine used by the offering.</p>
    pub product_description: Option<String>,
    /// <p>The recurring price charged to run this reserved DB instance.</p>
    pub recurring_charges: Option<Vec<RecurringCharge>>,
    /// <p>The offering identifier.</p>
    pub reserved_db_instances_offering_id: Option<String>,
    /// <p>The hourly price charged for this offering.</p>
    pub usage_price: Option<f64>,
}

#[allow(dead_code)]
struct ReservedDBInstancesOfferingDeserializer;
impl ReservedDBInstancesOfferingDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ReservedDBInstancesOffering, XmlParseError> {
        deserialize_elements::<_, ReservedDBInstancesOffering, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "CurrencyCode" => {
                        obj.currency_code =
                            Some(StringDeserializer::deserialize("CurrencyCode", stack)?);
                    }
                    "DBInstanceClass" => {
                        obj.db_instance_class =
                            Some(StringDeserializer::deserialize("DBInstanceClass", stack)?);
                    }
                    "Duration" => {
                        obj.duration = Some(IntegerDeserializer::deserialize("Duration", stack)?);
                    }
                    "FixedPrice" => {
                        obj.fixed_price =
                            Some(DoubleDeserializer::deserialize("FixedPrice", stack)?);
                    }
                    "MultiAZ" => {
                        obj.multi_az = Some(BooleanDeserializer::deserialize("MultiAZ", stack)?);
                    }
                    "OfferingType" => {
                        obj.offering_type =
                            Some(StringDeserializer::deserialize("OfferingType", stack)?);
                    }
                    "ProductDescription" => {
                        obj.product_description = Some(StringDeserializer::deserialize(
                            "ProductDescription",
                            stack,
                        )?);
                    }
                    "RecurringCharges" => {
                        obj.recurring_charges.get_or_insert(vec![]).extend(
                            RecurringChargeListDeserializer::deserialize(
                                "RecurringCharges",
                                stack,
                            )?,
                        );
                    }
                    "ReservedDBInstancesOfferingId" => {
                        obj.reserved_db_instances_offering_id =
                            Some(StringDeserializer::deserialize(
                                "ReservedDBInstancesOfferingId",
                                stack,
                            )?);
                    }
                    "UsagePrice" => {
                        obj.usage_price =
                            Some(DoubleDeserializer::deserialize("UsagePrice", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct ReservedDBInstancesOfferingListDeserializer;
impl ReservedDBInstancesOfferingListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<ReservedDBInstancesOffering>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "ReservedDBInstancesOffering" {
                obj.push(ReservedDBInstancesOfferingDeserializer::deserialize(
                    "ReservedDBInstancesOffering",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p> Contains the result of a successful invocation of the <code>DescribeReservedDBInstancesOfferings</code> action. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ReservedDBInstancesOfferingMessage {
    /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    pub marker: Option<String>,
    /// <p>A list of reserved DB instance offerings.</p>
    pub reserved_db_instances_offerings: Option<Vec<ReservedDBInstancesOffering>>,
}

#[allow(dead_code)]
struct ReservedDBInstancesOfferingMessageDeserializer;
impl ReservedDBInstancesOfferingMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ReservedDBInstancesOfferingMessage, XmlParseError> {
        deserialize_elements::<_, ReservedDBInstancesOfferingMessage, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Marker" => {
                        obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                    }
                    "ReservedDBInstancesOfferings" => {
                        obj.reserved_db_instances_offerings
                            .get_or_insert(vec![])
                            .extend(ReservedDBInstancesOfferingListDeserializer::deserialize(
                                "ReservedDBInstancesOfferings",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ResetDBClusterParameterGroupMessage {
    /// <p>The name of the DB cluster parameter group to reset.</p>
    pub db_cluster_parameter_group_name: String,
    /// <p>A list of parameter names in the DB cluster parameter group to reset to the default values. You can't use this parameter if the <code>ResetAllParameters</code> parameter is enabled.</p>
    pub parameters: Option<Vec<Parameter>>,
    /// <p>A value that indicates whether to reset all parameters in the DB cluster parameter group to their default values. You can't use this parameter if there is a list of parameter names specified for the <code>Parameters</code> parameter.</p>
    pub reset_all_parameters: Option<bool>,
}

/// Serialize `ResetDBClusterParameterGroupMessage` contents to a `SignedRequest`.
struct ResetDBClusterParameterGroupMessageSerializer;
impl ResetDBClusterParameterGroupMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ResetDBClusterParameterGroupMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "DBClusterParameterGroupName"),
            &obj.db_cluster_parameter_group_name,
        );
        if let Some(ref field_value) = obj.parameters {
            ParametersListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Parameter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.reset_all_parameters {
            params.put(&format!("{}{}", prefix, "ResetAllParameters"), &field_value);
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ResetDBParameterGroupMessage {
    /// <p><p>The name of the DB parameter group.</p> <p>Constraints:</p> <ul> <li> <p>Must match the name of an existing <code>DBParameterGroup</code>.</p> </li> </ul></p>
    pub db_parameter_group_name: String,
    /// <p>To reset the entire DB parameter group, specify the <code>DBParameterGroup</code> name and <code>ResetAllParameters</code> parameters. To reset specific parameters, provide a list of the following: <code>ParameterName</code> and <code>ApplyMethod</code>. A maximum of 20 parameters can be modified in a single request.</p> <p> <b>MySQL</b> </p> <p>Valid Values (for Apply method): <code>immediate</code> | <code>pending-reboot</code> </p> <p>You can use the immediate value with dynamic parameters only. You can use the <code>pending-reboot</code> value for both dynamic and static parameters, and changes are applied when DB instance reboots.</p> <p> <b>MariaDB</b> </p> <p>Valid Values (for Apply method): <code>immediate</code> | <code>pending-reboot</code> </p> <p>You can use the immediate value with dynamic parameters only. You can use the <code>pending-reboot</code> value for both dynamic and static parameters, and changes are applied when DB instance reboots.</p> <p> <b>Oracle</b> </p> <p>Valid Values (for Apply method): <code>pending-reboot</code> </p>
    pub parameters: Option<Vec<Parameter>>,
    /// <p> A value that indicates whether to reset all parameters in the DB parameter group to default values. By default, all parameters in the DB parameter group are reset to default values. </p>
    pub reset_all_parameters: Option<bool>,
}

/// Serialize `ResetDBParameterGroupMessage` contents to a `SignedRequest`.
struct ResetDBParameterGroupMessageSerializer;
impl ResetDBParameterGroupMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ResetDBParameterGroupMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "DBParameterGroupName"),
            &obj.db_parameter_group_name,
        );
        if let Some(ref field_value) = obj.parameters {
            ParametersListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Parameter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.reset_all_parameters {
            params.put(&format!("{}{}", prefix, "ResetAllParameters"), &field_value);
        }
    }
}

/// <p>Describes the pending maintenance actions for a resource.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ResourcePendingMaintenanceActions {
    /// <p>A list that provides details about the pending maintenance actions for the resource.</p>
    pub pending_maintenance_action_details: Option<Vec<PendingMaintenanceAction>>,
    /// <p>The ARN of the resource that has pending maintenance actions.</p>
    pub resource_identifier: Option<String>,
}

#[allow(dead_code)]
struct ResourcePendingMaintenanceActionsDeserializer;
impl ResourcePendingMaintenanceActionsDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ResourcePendingMaintenanceActions, XmlParseError> {
        deserialize_elements::<_, ResourcePendingMaintenanceActions, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "PendingMaintenanceActionDetails" => {
                        obj.pending_maintenance_action_details
                            .get_or_insert(vec![])
                            .extend(PendingMaintenanceActionDetailsDeserializer::deserialize(
                                "PendingMaintenanceActionDetails",
                                stack,
                            )?);
                    }
                    "ResourceIdentifier" => {
                        obj.resource_identifier = Some(StringDeserializer::deserialize(
                            "ResourceIdentifier",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct RestoreDBClusterFromS3Message {
    /// <p>A list of Availability Zones (AZs) where instances in the restored DB cluster can be created.</p>
    pub availability_zones: Option<Vec<String>>,
    /// <p><p>The target backtrack window, in seconds. To disable backtracking, set this value to 0.</p> <note> <p>Currently, Backtrack is only supported for Aurora MySQL DB clusters.</p> </note> <p>Default: 0</p> <p>Constraints:</p> <ul> <li> <p>If specified, this value must be set to a number from 0 to 259,200 (72 hours).</p> </li> </ul></p>
    pub backtrack_window: Option<i64>,
    /// <p><p>The number of days for which automated backups of the restored DB cluster are retained. You must specify a minimum value of 1.</p> <p>Default: 1</p> <p>Constraints:</p> <ul> <li> <p>Must be a value from 1 to 35</p> </li> </ul></p>
    pub backup_retention_period: Option<i64>,
    /// <p>A value that indicates that the restored DB cluster should be associated with the specified CharacterSet.</p>
    pub character_set_name: Option<String>,
    /// <p>A value that indicates whether to copy all tags from the restored DB cluster to snapshots of the restored DB cluster. The default is not to copy them.</p>
    pub copy_tags_to_snapshot: Option<bool>,
    /// <p>The name of the DB cluster to create from the source data in the Amazon S3 bucket. This parameter isn't case-sensitive.</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li> </ul> <p>Example: <code>my-cluster1</code> </p>
    pub db_cluster_identifier: String,
    /// <p><p>The name of the DB cluster parameter group to associate with the restored DB cluster. If this argument is omitted, <code>default.aurora5.6</code> is used. </p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p> </li> </ul></p>
    pub db_cluster_parameter_group_name: Option<String>,
    /// <p>A DB subnet group to associate with the restored DB cluster.</p> <p>Constraints: If supplied, must match the name of an existing DBSubnetGroup. </p> <p>Example: <code>mySubnetgroup</code> </p>
    pub db_subnet_group_name: Option<String>,
    /// <p>The database name for the restored DB cluster.</p>
    pub database_name: Option<String>,
    /// <p>A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled. </p>
    pub deletion_protection: Option<bool>,
    /// <p>Specify the Active Directory directory ID to restore the DB cluster in. The domain must be created prior to this operation. </p> <p> For Amazon Aurora DB clusters, Amazon RDS can use Kerberos Authentication to authenticate users that connect to the DB cluster. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html">Kerberos Authentication</a> in the <i>Amazon Aurora User Guide</i>. </p>
    pub domain: Option<String>,
    /// <p>Specify the name of the IAM role to be used when making API calls to the Directory Service.</p>
    pub domain_iam_role_name: Option<String>,
    /// <p>The list of logs that the restored DB cluster is to export to CloudWatch Logs. The values in the list depend on the DB engine being used. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Aurora User Guide</i>.</p>
    pub enable_cloudwatch_logs_exports: Option<Vec<String>>,
    /// <p>A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping is disabled.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database Authentication</a> in the <i>Amazon Aurora User Guide.</i> </p>
    pub enable_iam_database_authentication: Option<bool>,
    /// <p>The name of the database engine to be used for this DB cluster.</p> <p>Valid Values: <code>aurora</code> (for MySQL 5.6-compatible Aurora), <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora), and <code>aurora-postgresql</code> </p>
    pub engine: String,
    /// <p>The version number of the database engine to use.</p> <p>To list all of the available engine versions for <code>aurora</code> (for MySQL 5.6-compatible Aurora), use the following command:</p> <p> <code>aws rds describe-db-engine-versions --engine aurora --query "DBEngineVersions[].EngineVersion"</code> </p> <p>To list all of the available engine versions for <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora), use the following command:</p> <p> <code>aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"</code> </p> <p>To list all of the available engine versions for <code>aurora-postgresql</code>, use the following command:</p> <p> <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"</code> </p> <p> <b>Aurora MySQL</b> </p> <p>Example: <code>5.6.10a</code>, <code>5.6.mysql_aurora.1.19.2</code>, <code>5.7.12</code>, <code>5.7.mysql_aurora.2.04.5</code> </p> <p> <b>Aurora PostgreSQL</b> </p> <p>Example: <code>9.6.3</code>, <code>10.7</code> </p>
    pub engine_version: Option<String>,
    /// <p>The Amazon Web Services KMS key identifier for an encrypted DB cluster.</p> <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the Amazon Web Services KMS customer master key (CMK). To use a CMK in a different Amazon Web Services account, specify the key ARN or alias ARN.</p> <p>If the StorageEncrypted parameter is enabled, and you do not specify a value for the <code>KmsKeyId</code> parameter, then Amazon RDS will use your default CMK. There is a default CMK for your Amazon Web Services account. Your Amazon Web Services account has a different default CMK for each Amazon Web Services Region.</p>
    pub kms_key_id: Option<String>,
    /// <p>The password for the master database user. This password can contain any printable ASCII character except "/", """, or "@".</p> <p>Constraints: Must contain from 8 to 41 characters.</p>
    pub master_user_password: String,
    /// <p><p>The name of the master user for the restored DB cluster.</p> <p>Constraints:</p> <ul> <li> <p>Must be 1 to 16 letters or numbers.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Can&#39;t be a reserved word for the chosen database engine.</p> </li> </ul></p>
    pub master_username: String,
    /// <p>A value that indicates that the restored DB cluster should be associated with the specified option group.</p> <p>Permanent options can't be removed from an option group. An option group can't be removed from a DB cluster once it is associated with a DB cluster.</p>
    pub option_group_name: Option<String>,
    /// <p>The port number on which the instances in the restored DB cluster accept connections.</p> <p> Default: <code>3306</code> </p>
    pub port: Option<i64>,
    /// <p><p>The daily time range during which automated backups are created if automated backups are enabled using the <code>BackupRetentionPeriod</code> parameter. </p> <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region. To view the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow"> Backup window</a> in the <i>Amazon Aurora User Guide.</i> </p> <p>Constraints:</p> <ul> <li> <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p> </li> <li> <p>Must be in Universal Coordinated Time (UTC).</p> </li> <li> <p>Must not conflict with the preferred maintenance window.</p> </li> <li> <p>Must be at least 30 minutes.</p> </li> </ul></p>
    pub preferred_backup_window: Option<String>,
    /// <p>The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p> <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code> </p> <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region, occurring on a random day of the week. To see the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora"> Adjusting the Preferred Maintenance Window</a> in the <i>Amazon Aurora User Guide.</i> </p> <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p> <p>Constraints: Minimum 30-minute window.</p>
    pub preferred_maintenance_window: Option<String>,
    /// <p>The name of the Amazon S3 bucket that contains the data used to create the Amazon Aurora DB cluster.</p>
    pub s3_bucket_name: String,
    /// <p>The Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that authorizes Amazon RDS to access the Amazon S3 bucket on your behalf.</p>
    pub s3_ingestion_role_arn: String,
    /// <p>The prefix for all of the file names that contain the data used to create the Amazon Aurora DB cluster. If you do not specify a <b>SourceS3Prefix</b> value, then the Amazon Aurora DB cluster is created by using all of the files in the Amazon S3 bucket.</p>
    pub s3_prefix: Option<String>,
    /// <p>The identifier for the database engine that was backed up to create the files stored in the Amazon S3 bucket. </p> <p>Valid values: <code>mysql</code> </p>
    pub source_engine: String,
    /// <p>The version of the database that the backup files were created from.</p> <p>MySQL versions 5.5, 5.6, and 5.7 are supported. </p> <p>Example: <code>5.6.40</code>, <code>5.7.28</code> </p>
    pub source_engine_version: String,
    /// <p>A value that indicates whether the restored DB cluster is encrypted.</p>
    pub storage_encrypted: Option<bool>,
    pub tags: Option<Vec<Tag>>,
    /// <p>A list of EC2 VPC security groups to associate with the restored DB cluster.</p>
    pub vpc_security_group_ids: Option<Vec<String>>,
}

/// Serialize `RestoreDBClusterFromS3Message` contents to a `SignedRequest`.
struct RestoreDBClusterFromS3MessageSerializer;
impl RestoreDBClusterFromS3MessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &RestoreDBClusterFromS3Message) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.availability_zones {
            AvailabilityZonesSerializer::serialize(
                params,
                &format!("{}{}", prefix, "AvailabilityZone"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.backtrack_window {
            params.put(&format!("{}{}", prefix, "BacktrackWindow"), &field_value);
        }
        if let Some(ref field_value) = obj.backup_retention_period {
            params.put(
                &format!("{}{}", prefix, "BackupRetentionPeriod"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.character_set_name {
            params.put(&format!("{}{}", prefix, "CharacterSetName"), &field_value);
        }
        if let Some(ref field_value) = obj.copy_tags_to_snapshot {
            params.put(&format!("{}{}", prefix, "CopyTagsToSnapshot"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "DBClusterIdentifier"),
            &obj.db_cluster_identifier,
        );
        if let Some(ref field_value) = obj.db_cluster_parameter_group_name {
            params.put(
                &format!("{}{}", prefix, "DBClusterParameterGroupName"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.db_subnet_group_name {
            params.put(&format!("{}{}", prefix, "DBSubnetGroupName"), &field_value);
        }
        if let Some(ref field_value) = obj.database_name {
            params.put(&format!("{}{}", prefix, "DatabaseName"), &field_value);
        }
        if let Some(ref field_value) = obj.deletion_protection {
            params.put(&format!("{}{}", prefix, "DeletionProtection"), &field_value);
        }
        if let Some(ref field_value) = obj.domain {
            params.put(&format!("{}{}", prefix, "Domain"), &field_value);
        }
        if let Some(ref field_value) = obj.domain_iam_role_name {
            params.put(&format!("{}{}", prefix, "DomainIAMRoleName"), &field_value);
        }
        if let Some(ref field_value) = obj.enable_cloudwatch_logs_exports {
            LogTypeListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "EnableCloudwatchLogsExports"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.enable_iam_database_authentication {
            params.put(
                &format!("{}{}", prefix, "EnableIAMDatabaseAuthentication"),
                &field_value,
            );
        }
        params.put(&format!("{}{}", prefix, "Engine"), &obj.engine);
        if let Some(ref field_value) = obj.engine_version {
            params.put(&format!("{}{}", prefix, "EngineVersion"), &field_value);
        }
        if let Some(ref field_value) = obj.kms_key_id {
            params.put(&format!("{}{}", prefix, "KmsKeyId"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "MasterUserPassword"),
            &obj.master_user_password,
        );
        params.put(
            &format!("{}{}", prefix, "MasterUsername"),
            &obj.master_username,
        );
        if let Some(ref field_value) = obj.option_group_name {
            params.put(&format!("{}{}", prefix, "OptionGroupName"), &field_value);
        }
        if let Some(ref field_value) = obj.port {
            params.put(&format!("{}{}", prefix, "Port"), &field_value);
        }
        if let Some(ref field_value) = obj.preferred_backup_window {
            params.put(
                &format!("{}{}", prefix, "PreferredBackupWindow"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.preferred_maintenance_window {
            params.put(
                &format!("{}{}", prefix, "PreferredMaintenanceWindow"),
                &field_value,
            );
        }
        params.put(
            &format!("{}{}", prefix, "S3BucketName"),
            &obj.s3_bucket_name,
        );
        params.put(
            &format!("{}{}", prefix, "S3IngestionRoleArn"),
            &obj.s3_ingestion_role_arn,
        );
        if let Some(ref field_value) = obj.s3_prefix {
            params.put(&format!("{}{}", prefix, "S3Prefix"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "SourceEngine"), &obj.source_engine);
        params.put(
            &format!("{}{}", prefix, "SourceEngineVersion"),
            &obj.source_engine_version,
        );
        if let Some(ref field_value) = obj.storage_encrypted {
            params.put(&format!("{}{}", prefix, "StorageEncrypted"), &field_value);
        }
        if let Some(ref field_value) = obj.tags {
            TagListSerializer::serialize(params, &format!("{}{}", prefix, "Tag"), field_value);
        }
        if let Some(ref field_value) = obj.vpc_security_group_ids {
            VpcSecurityGroupIdListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "VpcSecurityGroupId"),
                field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct RestoreDBClusterFromS3Result {
    pub db_cluster: Option<DBCluster>,
}

#[allow(dead_code)]
struct RestoreDBClusterFromS3ResultDeserializer;
impl RestoreDBClusterFromS3ResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<RestoreDBClusterFromS3Result, XmlParseError> {
        deserialize_elements::<_, RestoreDBClusterFromS3Result, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DBCluster" => {
                        obj.db_cluster =
                            Some(DBClusterDeserializer::deserialize("DBCluster", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct RestoreDBClusterFromSnapshotMessage {
    /// <p>Provides the list of Availability Zones (AZs) where instances in the restored DB cluster can be created.</p>
    pub availability_zones: Option<Vec<String>>,
    /// <p><p>The target backtrack window, in seconds. To disable backtracking, set this value to 0.</p> <note> <p>Currently, Backtrack is only supported for Aurora MySQL DB clusters.</p> </note> <p>Default: 0</p> <p>Constraints:</p> <ul> <li> <p>If specified, this value must be set to a number from 0 to 259,200 (72 hours).</p> </li> </ul></p>
    pub backtrack_window: Option<i64>,
    /// <p>A value that indicates whether to copy all tags from the restored DB cluster to snapshots of the restored DB cluster. The default is not to copy them.</p>
    pub copy_tags_to_snapshot: Option<bool>,
    /// <p>The name of the DB cluster to create from the DB snapshot or DB cluster snapshot. This parameter isn't case-sensitive.</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens</p> </li> <li> <p>First character must be a letter</p> </li> <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li> </ul> <p>Example: <code>my-snapshot-id</code> </p>
    pub db_cluster_identifier: String,
    /// <p><p>The name of the DB cluster parameter group to associate with this DB cluster. If this argument is omitted, the default DB cluster parameter group for the specified engine is used.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match the name of an existing default DB cluster parameter group.</p> </li> <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Can&#39;t end with a hyphen or contain two consecutive hyphens.</p> </li> </ul></p>
    pub db_cluster_parameter_group_name: Option<String>,
    /// <p>The name of the DB subnet group to use for the new DB cluster.</p> <p>Constraints: If supplied, must match the name of an existing DB subnet group.</p> <p>Example: <code>mySubnetgroup</code> </p>
    pub db_subnet_group_name: Option<String>,
    /// <p>The database name for the restored DB cluster.</p>
    pub database_name: Option<String>,
    /// <p>A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled. </p>
    pub deletion_protection: Option<bool>,
    /// <p>Specify the Active Directory directory ID to restore the DB cluster in. The domain must be created prior to this operation. Currently, only MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances can be created in an Active Directory Domain.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html"> Kerberos Authentication</a> in the <i>Amazon RDS User Guide</i>. </p>
    pub domain: Option<String>,
    /// <p>Specify the name of the IAM role to be used when making API calls to the Directory Service.</p>
    pub domain_iam_role_name: Option<String>,
    /// <p>The list of logs that the restored DB cluster is to export to Amazon CloudWatch Logs. The values in the list depend on the DB engine being used. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs </a> in the <i>Amazon Aurora User Guide</i>.</p>
    pub enable_cloudwatch_logs_exports: Option<Vec<String>>,
    /// <p>A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping is disabled.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database Authentication</a> in the <i>Amazon Aurora User Guide.</i> </p>
    pub enable_iam_database_authentication: Option<bool>,
    /// <p>The database engine to use for the new DB cluster.</p> <p>Default: The same as source</p> <p>Constraint: Must be compatible with the engine of the source</p>
    pub engine: String,
    /// <p>The DB engine mode of the DB cluster, either <code>provisioned</code>, <code>serverless</code>, <code>parallelquery</code>, <code>global</code>, or <code>multimaster</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBCluster.html"> CreateDBCluster</a>.</p>
    pub engine_mode: Option<String>,
    /// <p>The version of the database engine to use for the new DB cluster.</p> <p>To list all of the available engine versions for <code>aurora</code> (for MySQL 5.6-compatible Aurora), use the following command:</p> <p> <code>aws rds describe-db-engine-versions --engine aurora --query "DBEngineVersions[].EngineVersion"</code> </p> <p>To list all of the available engine versions for <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora), use the following command:</p> <p> <code>aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"</code> </p> <p>To list all of the available engine versions for <code>aurora-postgresql</code>, use the following command:</p> <p> <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"</code> </p> <note> <p>If you aren't using the default engine version, then you must specify the engine version.</p> </note> <p> <b>Aurora MySQL</b> </p> <p>Example: <code>5.6.10a</code>, <code>5.6.mysql_aurora.1.19.2</code>, <code>5.7.12</code>, <code>5.7.mysql_aurora.2.04.5</code> </p> <p> <b>Aurora PostgreSQL</b> </p> <p>Example: <code>9.6.3</code>, <code>10.7</code> </p>
    pub engine_version: Option<String>,
    /// <p><p>The Amazon Web Services KMS key identifier to use when restoring an encrypted DB cluster from a DB snapshot or DB cluster snapshot.</p> <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the Amazon Web Services KMS customer master key (CMK). To use a CMK in a different Amazon Web Services account, specify the key ARN or alias ARN.</p> <p>When you don&#39;t specify a value for the <code>KmsKeyId</code> parameter, then the following occurs:</p> <ul> <li> <p>If the DB snapshot or DB cluster snapshot in <code>SnapshotIdentifier</code> is encrypted, then the restored DB cluster is encrypted using the Amazon Web Services KMS CMK that was used to encrypt the DB snapshot or DB cluster snapshot.</p> </li> <li> <p>If the DB snapshot or DB cluster snapshot in <code>SnapshotIdentifier</code> isn&#39;t encrypted, then the restored DB cluster isn&#39;t encrypted.</p> </li> </ul></p>
    pub kms_key_id: Option<String>,
    /// <p>The name of the option group to use for the restored DB cluster.</p>
    pub option_group_name: Option<String>,
    /// <p>The port number on which the new DB cluster accepts connections.</p> <p>Constraints: This value must be <code>1150-65535</code> </p> <p>Default: The same port as the original DB cluster.</p>
    pub port: Option<i64>,
    /// <p>For DB clusters in <code>serverless</code> DB engine mode, the scaling properties of the DB cluster.</p>
    pub scaling_configuration: Option<ScalingConfiguration>,
    /// <p><p>The identifier for the DB snapshot or DB cluster snapshot to restore from.</p> <p>You can use either the name or the Amazon Resource Name (ARN) to specify a DB cluster snapshot. However, you can use only the ARN to specify a DB snapshot.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing Snapshot.</p> </li> </ul></p>
    pub snapshot_identifier: String,
    /// <p>The tags to be assigned to the restored DB cluster.</p>
    pub tags: Option<Vec<Tag>>,
    /// <p>A list of VPC security groups that the new DB cluster will belong to.</p>
    pub vpc_security_group_ids: Option<Vec<String>>,
}

/// Serialize `RestoreDBClusterFromSnapshotMessage` contents to a `SignedRequest`.
struct RestoreDBClusterFromSnapshotMessageSerializer;
impl RestoreDBClusterFromSnapshotMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &RestoreDBClusterFromSnapshotMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.availability_zones {
            AvailabilityZonesSerializer::serialize(
                params,
                &format!("{}{}", prefix, "AvailabilityZone"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.backtrack_window {
            params.put(&format!("{}{}", prefix, "BacktrackWindow"), &field_value);
        }
        if let Some(ref field_value) = obj.copy_tags_to_snapshot {
            params.put(&format!("{}{}", prefix, "CopyTagsToSnapshot"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "DBClusterIdentifier"),
            &obj.db_cluster_identifier,
        );
        if let Some(ref field_value) = obj.db_cluster_parameter_group_name {
            params.put(
                &format!("{}{}", prefix, "DBClusterParameterGroupName"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.db_subnet_group_name {
            params.put(&format!("{}{}", prefix, "DBSubnetGroupName"), &field_value);
        }
        if let Some(ref field_value) = obj.database_name {
            params.put(&format!("{}{}", prefix, "DatabaseName"), &field_value);
        }
        if let Some(ref field_value) = obj.deletion_protection {
            params.put(&format!("{}{}", prefix, "DeletionProtection"), &field_value);
        }
        if let Some(ref field_value) = obj.domain {
            params.put(&format!("{}{}", prefix, "Domain"), &field_value);
        }
        if let Some(ref field_value) = obj.domain_iam_role_name {
            params.put(&format!("{}{}", prefix, "DomainIAMRoleName"), &field_value);
        }
        if let Some(ref field_value) = obj.enable_cloudwatch_logs_exports {
            LogTypeListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "EnableCloudwatchLogsExports"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.enable_iam_database_authentication {
            params.put(
                &format!("{}{}", prefix, "EnableIAMDatabaseAuthentication"),
                &field_value,
            );
        }
        params.put(&format!("{}{}", prefix, "Engine"), &obj.engine);
        if let Some(ref field_value) = obj.engine_mode {
            params.put(&format!("{}{}", prefix, "EngineMode"), &field_value);
        }
        if let Some(ref field_value) = obj.engine_version {
            params.put(&format!("{}{}", prefix, "EngineVersion"), &field_value);
        }
        if let Some(ref field_value) = obj.kms_key_id {
            params.put(&format!("{}{}", prefix, "KmsKeyId"), &field_value);
        }
        if let Some(ref field_value) = obj.option_group_name {
            params.put(&format!("{}{}", prefix, "OptionGroupName"), &field_value);
        }
        if let Some(ref field_value) = obj.port {
            params.put(&format!("{}{}", prefix, "Port"), &field_value);
        }
        if let Some(ref field_value) = obj.scaling_configuration {
            ScalingConfigurationSerializer::serialize(
                params,
                &format!("{}{}", prefix, "ScalingConfiguration"),
                field_value,
            );
        }
        params.put(
            &format!("{}{}", prefix, "SnapshotIdentifier"),
            &obj.snapshot_identifier,
        );
        if let Some(ref field_value) = obj.tags {
            TagListSerializer::serialize(params, &format!("{}{}", prefix, "Tag"), field_value);
        }
        if let Some(ref field_value) = obj.vpc_security_group_ids {
            VpcSecurityGroupIdListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "VpcSecurityGroupId"),
                field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct RestoreDBClusterFromSnapshotResult {
    pub db_cluster: Option<DBCluster>,
}

#[allow(dead_code)]
struct RestoreDBClusterFromSnapshotResultDeserializer;
impl RestoreDBClusterFromSnapshotResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<RestoreDBClusterFromSnapshotResult, XmlParseError> {
        deserialize_elements::<_, RestoreDBClusterFromSnapshotResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DBCluster" => {
                        obj.db_cluster =
                            Some(DBClusterDeserializer::deserialize("DBCluster", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct RestoreDBClusterToPointInTimeMessage {
    /// <p><p>The target backtrack window, in seconds. To disable backtracking, set this value to 0.</p> <note> <p>Currently, Backtrack is only supported for Aurora MySQL DB clusters.</p> </note> <p>Default: 0</p> <p>Constraints:</p> <ul> <li> <p>If specified, this value must be set to a number from 0 to 259,200 (72 hours).</p> </li> </ul></p>
    pub backtrack_window: Option<i64>,
    /// <p>A value that indicates whether to copy all tags from the restored DB cluster to snapshots of the restored DB cluster. The default is not to copy them.</p>
    pub copy_tags_to_snapshot: Option<bool>,
    /// <p><p>The name of the new DB cluster to be created.</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens</p> </li> <li> <p>First character must be a letter</p> </li> <li> <p>Can&#39;t end with a hyphen or contain two consecutive hyphens</p> </li> </ul></p>
    pub db_cluster_identifier: String,
    /// <p><p>The name of the DB cluster parameter group to associate with this DB cluster. If this argument is omitted, the default DB cluster parameter group for the specified engine is used.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match the name of an existing DB cluster parameter group.</p> </li> <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Can&#39;t end with a hyphen or contain two consecutive hyphens.</p> </li> </ul></p>
    pub db_cluster_parameter_group_name: Option<String>,
    /// <p>The DB subnet group name to use for the new DB cluster.</p> <p>Constraints: If supplied, must match the name of an existing DBSubnetGroup.</p> <p>Example: <code>mySubnetgroup</code> </p>
    pub db_subnet_group_name: Option<String>,
    /// <p>A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled. </p>
    pub deletion_protection: Option<bool>,
    /// <p>Specify the Active Directory directory ID to restore the DB cluster in. The domain must be created prior to this operation. </p> <p> For Amazon Aurora DB clusters, Amazon RDS can use Kerberos Authentication to authenticate users that connect to the DB cluster. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html">Kerberos Authentication</a> in the <i>Amazon Aurora User Guide</i>. </p>
    pub domain: Option<String>,
    /// <p>Specify the name of the IAM role to be used when making API calls to the Directory Service.</p>
    pub domain_iam_role_name: Option<String>,
    /// <p>The list of logs that the restored DB cluster is to export to CloudWatch Logs. The values in the list depend on the DB engine being used. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Aurora User Guide</i>.</p>
    pub enable_cloudwatch_logs_exports: Option<Vec<String>>,
    /// <p>A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping is disabled.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database Authentication</a> in the <i>Amazon Aurora User Guide.</i> </p>
    pub enable_iam_database_authentication: Option<bool>,
    /// <p>The engine mode of the new cluster. Specify <code>provisioned</code> or <code>serverless</code>, depending on the type of the cluster you are creating. You can create an Aurora Serverless clone from a provisioned cluster, or a provisioned clone from an Aurora Serverless cluster. To create a clone that is an Aurora Serverless cluster, the original cluster must be an Aurora Serverless cluster or an encrypted provisioned cluster.</p>
    pub engine_mode: Option<String>,
    /// <p>The Amazon Web Services KMS key identifier to use when restoring an encrypted DB cluster from an encrypted DB cluster.</p> <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the Amazon Web Services KMS customer master key (CMK). To use a CMK in a different Amazon Web Services account, specify the key ARN or alias ARN.</p> <p>You can restore to a new DB cluster and encrypt the new DB cluster with a Amazon Web Services KMS CMK that is different than the Amazon Web Services KMS key used to encrypt the source DB cluster. The new DB cluster is encrypted with the Amazon Web Services KMS CMK identified by the <code>KmsKeyId</code> parameter.</p> <p>If you don't specify a value for the <code>KmsKeyId</code> parameter, then the following occurs:</p> <ul> <li> <p>If the DB cluster is encrypted, then the restored DB cluster is encrypted using the Amazon Web Services KMS CMK that was used to encrypt the source DB cluster.</p> </li> <li> <p>If the DB cluster isn't encrypted, then the restored DB cluster isn't encrypted.</p> </li> </ul> <p>If <code>DBClusterIdentifier</code> refers to a DB cluster that isn't encrypted, then the restore request is rejected.</p>
    pub kms_key_id: Option<String>,
    /// <p>The name of the option group for the new DB cluster.</p>
    pub option_group_name: Option<String>,
    /// <p>The port number on which the new DB cluster accepts connections.</p> <p>Constraints: A value from <code>1150-65535</code>. </p> <p>Default: The default port for the engine.</p>
    pub port: Option<i64>,
    /// <p>The date and time to restore the DB cluster to.</p> <p>Valid Values: Value must be a time in Universal Coordinated Time (UTC) format</p> <p>Constraints:</p> <ul> <li> <p>Must be before the latest restorable time for the DB instance</p> </li> <li> <p>Must be specified if <code>UseLatestRestorableTime</code> parameter isn't provided</p> </li> <li> <p>Can't be specified if the <code>UseLatestRestorableTime</code> parameter is enabled</p> </li> <li> <p>Can't be specified if the <code>RestoreType</code> parameter is <code>copy-on-write</code> </p> </li> </ul> <p>Example: <code>2015-03-07T23:45:00Z</code> </p>
    pub restore_to_time: Option<String>,
    /// <p>The type of restore to be performed. You can specify one of the following values:</p> <ul> <li> <p> <code>full-copy</code> - The new DB cluster is restored as a full copy of the source DB cluster.</p> </li> <li> <p> <code>copy-on-write</code> - The new DB cluster is restored as a clone of the source DB cluster.</p> </li> </ul> <p>Constraints: You can't specify <code>copy-on-write</code> if the engine version of the source DB cluster is earlier than 1.11.</p> <p>If you don't specify a <code>RestoreType</code> value, then the new DB cluster is restored as a full copy of the source DB cluster.</p>
    pub restore_type: Option<String>,
    /// <p>For DB clusters in <code>serverless</code> DB engine mode, the scaling properties of the DB cluster.</p>
    pub scaling_configuration: Option<ScalingConfiguration>,
    /// <p><p>The identifier of the source DB cluster from which to restore.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing DBCluster.</p> </li> </ul></p>
    pub source_db_cluster_identifier: String,
    pub tags: Option<Vec<Tag>>,
    /// <p>A value that indicates whether to restore the DB cluster to the latest restorable backup time. By default, the DB cluster isn't restored to the latest restorable backup time. </p> <p>Constraints: Can't be specified if <code>RestoreToTime</code> parameter is provided.</p>
    pub use_latest_restorable_time: Option<bool>,
    /// <p>A list of VPC security groups that the new DB cluster belongs to.</p>
    pub vpc_security_group_ids: Option<Vec<String>>,
}

/// Serialize `RestoreDBClusterToPointInTimeMessage` contents to a `SignedRequest`.
struct RestoreDBClusterToPointInTimeMessageSerializer;
impl RestoreDBClusterToPointInTimeMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &RestoreDBClusterToPointInTimeMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.backtrack_window {
            params.put(&format!("{}{}", prefix, "BacktrackWindow"), &field_value);
        }
        if let Some(ref field_value) = obj.copy_tags_to_snapshot {
            params.put(&format!("{}{}", prefix, "CopyTagsToSnapshot"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "DBClusterIdentifier"),
            &obj.db_cluster_identifier,
        );
        if let Some(ref field_value) = obj.db_cluster_parameter_group_name {
            params.put(
                &format!("{}{}", prefix, "DBClusterParameterGroupName"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.db_subnet_group_name {
            params.put(&format!("{}{}", prefix, "DBSubnetGroupName"), &field_value);
        }
        if let Some(ref field_value) = obj.deletion_protection {
            params.put(&format!("{}{}", prefix, "DeletionProtection"), &field_value);
        }
        if let Some(ref field_value) = obj.domain {
            params.put(&format!("{}{}", prefix, "Domain"), &field_value);
        }
        if let Some(ref field_value) = obj.domain_iam_role_name {
            params.put(&format!("{}{}", prefix, "DomainIAMRoleName"), &field_value);
        }
        if let Some(ref field_value) = obj.enable_cloudwatch_logs_exports {
            LogTypeListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "EnableCloudwatchLogsExports"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.enable_iam_database_authentication {
            params.put(
                &format!("{}{}", prefix, "EnableIAMDatabaseAuthentication"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.engine_mode {
            params.put(&format!("{}{}", prefix, "EngineMode"), &field_value);
        }
        if let Some(ref field_value) = obj.kms_key_id {
            params.put(&format!("{}{}", prefix, "KmsKeyId"), &field_value);
        }
        if let Some(ref field_value) = obj.option_group_name {
            params.put(&format!("{}{}", prefix, "OptionGroupName"), &field_value);
        }
        if let Some(ref field_value) = obj.port {
            params.put(&format!("{}{}", prefix, "Port"), &field_value);
        }
        if let Some(ref field_value) = obj.restore_to_time {
            params.put(&format!("{}{}", prefix, "RestoreToTime"), &field_value);
        }
        if let Some(ref field_value) = obj.restore_type {
            params.put(&format!("{}{}", prefix, "RestoreType"), &field_value);
        }
        if let Some(ref field_value) = obj.scaling_configuration {
            ScalingConfigurationSerializer::serialize(
                params,
                &format!("{}{}", prefix, "ScalingConfiguration"),
                field_value,
            );
        }
        params.put(
            &format!("{}{}", prefix, "SourceDBClusterIdentifier"),
            &obj.source_db_cluster_identifier,
        );
        if let Some(ref field_value) = obj.tags {
            TagListSerializer::serialize(params, &format!("{}{}", prefix, "Tag"), field_value);
        }
        if let Some(ref field_value) = obj.use_latest_restorable_time {
            params.put(
                &format!("{}{}", prefix, "UseLatestRestorableTime"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.vpc_security_group_ids {
            VpcSecurityGroupIdListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "VpcSecurityGroupId"),
                field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct RestoreDBClusterToPointInTimeResult {
    pub db_cluster: Option<DBCluster>,
}

#[allow(dead_code)]
struct RestoreDBClusterToPointInTimeResultDeserializer;
impl RestoreDBClusterToPointInTimeResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<RestoreDBClusterToPointInTimeResult, XmlParseError> {
        deserialize_elements::<_, RestoreDBClusterToPointInTimeResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DBCluster" => {
                        obj.db_cluster =
                            Some(DBClusterDeserializer::deserialize("DBCluster", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct RestoreDBInstanceFromDBSnapshotMessage {
    /// <p>A value that indicates whether minor version upgrades are applied automatically to the DB instance during the maintenance window.</p>
    pub auto_minor_version_upgrade: Option<bool>,
    /// <p>The Availability Zone (AZ) where the DB instance will be created.</p> <p>Default: A random, system-chosen Availability Zone.</p> <p>Constraint: You can't specify the <code>AvailabilityZone</code> parameter if the DB instance is a Multi-AZ deployment.</p> <p>Example: <code>us-east-1a</code> </p>
    pub availability_zone: Option<String>,
    /// <p>A value that indicates whether to copy all tags from the restored DB instance to snapshots of the DB instance. By default, tags are not copied.</p>
    pub copy_tags_to_snapshot: Option<bool>,
    /// <p>The compute and memory capacity of the Amazon RDS DB instance, for example, <code>db.m4.large</code>. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines. For the full list of DB instance classes, and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB Instance Class</a> in the <i>Amazon RDS User Guide.</i> </p> <p>Default: The same DBInstanceClass as the original DB instance.</p>
    pub db_instance_class: Option<String>,
    /// <p>Name of the DB instance to create from the DB snapshot. This parameter isn't case-sensitive.</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 numbers, letters, or hyphens</p> </li> <li> <p>First character must be a letter</p> </li> <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li> </ul> <p>Example: <code>my-snapshot-id</code> </p>
    pub db_instance_identifier: String,
    /// <p><p>The database name for the restored DB instance.</p> <note> <p>This parameter doesn&#39;t apply to the MySQL, PostgreSQL, or MariaDB engines.</p> </note></p>
    pub db_name: Option<String>,
    /// <p><p>The name of the DB parameter group to associate with this DB instance.</p> <p>If you do not specify a value for <code>DBParameterGroupName</code>, then the default <code>DBParameterGroup</code> for the specified DB engine is used.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match the name of an existing DBParameterGroup.</p> </li> <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Can&#39;t end with a hyphen or contain two consecutive hyphens.</p> </li> </ul></p>
    pub db_parameter_group_name: Option<String>,
    /// <p><p>The identifier for the DB snapshot to restore from.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing DBSnapshot.</p> </li> <li> <p>If you are restoring from a shared manual DB snapshot, the <code>DBSnapshotIdentifier</code> must be the ARN of the shared DB snapshot.</p> </li> </ul></p>
    pub db_snapshot_identifier: String,
    /// <p>The DB subnet group name to use for the new instance.</p> <p>Constraints: If supplied, must match the name of an existing DBSubnetGroup.</p> <p>Example: <code>mySubnetgroup</code> </p>
    pub db_subnet_group_name: Option<String>,
    /// <p>A value that indicates whether the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html"> Deleting a DB Instance</a>. </p>
    pub deletion_protection: Option<bool>,
    /// <p>Specify the Active Directory directory ID to restore the DB instance in. The domain must be created prior to this operation. Currently, only MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances can be created in an Active Directory Domain.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html"> Kerberos Authentication</a> in the <i>Amazon RDS User Guide</i>.</p>
    pub domain: Option<String>,
    /// <p>Specify the name of the IAM role to be used when making API calls to the Directory Service.</p>
    pub domain_iam_role_name: Option<String>,
    /// <p>The list of logs that the restored DB instance is to export to CloudWatch Logs. The values in the list depend on the DB engine being used. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide</i>.</p>
    pub enable_cloudwatch_logs_exports: Option<Vec<String>>,
    /// <p>A value that indicates whether to enable a customer-owned IP address (CoIP) for an RDS on Outposts DB instance.</p> <p>A <i>CoIP</i> provides local or external connectivity to resources in your Outpost subnets through your on-premises network. For some use cases, a CoIP can provide lower latency for connections to the DB instance from outside of its virtual private cloud (VPC) on your local network.</p> <p>For more information about RDS on Outposts, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon RDS on Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide</i>.</p> <p>For more information about CoIPs, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#ip-addressing">Customer-owned IP addresses</a> in the <i>Amazon Web Services Outposts User Guide</i>.</p>
    pub enable_customer_owned_ip: Option<bool>,
    /// <p>A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping is disabled.</p> <p>For more information about IAM database authentication, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database Authentication for MySQL and PostgreSQL</a> in the <i>Amazon RDS User Guide.</i> </p>
    pub enable_iam_database_authentication: Option<bool>,
    /// <p><p>The database engine to use for the new instance.</p> <p>Default: The same as source</p> <p>Constraint: Must be compatible with the engine of the source. For example, you can restore a MariaDB 10.1 DB instance from a MySQL 5.6 snapshot.</p> <p>Valid Values:</p> <ul> <li> <p> <code>mariadb</code> </p> </li> <li> <p> <code>mysql</code> </p> </li> <li> <p> <code>oracle-ee</code> </p> </li> <li> <p> <code>oracle-ee-cdb</code> </p> </li> <li> <p> <code>oracle-se2</code> </p> </li> <li> <p> <code>oracle-se2-cdb</code> </p> </li> <li> <p> <code>postgres</code> </p> </li> <li> <p> <code>sqlserver-ee</code> </p> </li> <li> <p> <code>sqlserver-se</code> </p> </li> <li> <p> <code>sqlserver-ex</code> </p> </li> <li> <p> <code>sqlserver-web</code> </p> </li> </ul></p>
    pub engine: Option<String>,
    /// <p>Specifies the amount of provisioned IOPS for the DB instance, expressed in I/O operations per second. If this parameter isn't specified, the IOPS value is taken from the backup. If this parameter is set to 0, the new instance is converted to a non-PIOPS instance. The conversion takes additional time, though your DB instance is available for connections before the conversion starts. </p> <p>The provisioned IOPS value must follow the requirements for your database engine. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS Provisioned IOPS Storage to Improve Performance</a> in the <i>Amazon RDS User Guide.</i> </p> <p>Constraints: Must be an integer greater than 1000.</p>
    pub iops: Option<i64>,
    /// <p>License model information for the restored DB instance.</p> <p>Default: Same as source.</p> <p> Valid values: <code>license-included</code> | <code>bring-your-own-license</code> | <code>general-public-license</code> </p>
    pub license_model: Option<String>,
    /// <p>A value that indicates whether the DB instance is a Multi-AZ deployment.</p> <p>Constraint: You can't specify the <code>AvailabilityZone</code> parameter if the DB instance is a Multi-AZ deployment.</p>
    pub multi_az: Option<bool>,
    /// <p>The name of the option group to be used for the restored DB instance.</p> <p>Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed from an option group, and that option group can't be removed from a DB instance once it is associated with a DB instance</p>
    pub option_group_name: Option<String>,
    /// <p>The port number on which the database accepts connections.</p> <p>Default: The same port as the original DB instance</p> <p>Constraints: Value must be <code>1150-65535</code> </p>
    pub port: Option<i64>,
    /// <p>The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.</p>
    pub processor_features: Option<Vec<ProcessorFeature>>,
    /// <p>A value that indicates whether the DB instance is publicly accessible.</p> <p>When the DB instance is publicly accessible, its DNS endpoint resolves to the private IP address from within the DB instance's VPC, and to the public IP address from outside of the DB instance's VPC. Access to the DB instance is ultimately controlled by the security group it uses, and that public access is not permitted if the security group assigned to the DB instance doesn't permit it.</p> <p>When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address.</p> <p>For more information, see <a>CreateDBInstance</a>.</p>
    pub publicly_accessible: Option<bool>,
    /// <p>Specifies the storage type to be associated with the DB instance.</p> <p> Valid values: <code>standard | gp2 | io1</code> </p> <p> If you specify <code>io1</code>, you must also include a value for the <code>Iops</code> parameter. </p> <p> Default: <code>io1</code> if the <code>Iops</code> parameter is specified, otherwise <code>gp2</code> </p>
    pub storage_type: Option<String>,
    pub tags: Option<Vec<Tag>>,
    /// <p>The ARN from the key store with which to associate the instance for TDE encryption.</p>
    pub tde_credential_arn: Option<String>,
    /// <p>The password for the given ARN from the key store in order to access the device.</p>
    pub tde_credential_password: Option<String>,
    /// <p>A value that indicates whether the DB instance class of the DB instance uses its default processor features.</p>
    pub use_default_processor_features: Option<bool>,
    /// <p> A list of EC2 VPC security groups to associate with this DB instance. </p> <p> Default: The default EC2 VPC security group for the DB subnet group's VPC. </p>
    pub vpc_security_group_ids: Option<Vec<String>>,
}

/// Serialize `RestoreDBInstanceFromDBSnapshotMessage` contents to a `SignedRequest`.
struct RestoreDBInstanceFromDBSnapshotMessageSerializer;
impl RestoreDBInstanceFromDBSnapshotMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &RestoreDBInstanceFromDBSnapshotMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.auto_minor_version_upgrade {
            params.put(
                &format!("{}{}", prefix, "AutoMinorVersionUpgrade"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.availability_zone {
            params.put(&format!("{}{}", prefix, "AvailabilityZone"), &field_value);
        }
        if let Some(ref field_value) = obj.copy_tags_to_snapshot {
            params.put(&format!("{}{}", prefix, "CopyTagsToSnapshot"), &field_value);
        }
        if let Some(ref field_value) = obj.db_instance_class {
            params.put(&format!("{}{}", prefix, "DBInstanceClass"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "DBInstanceIdentifier"),
            &obj.db_instance_identifier,
        );
        if let Some(ref field_value) = obj.db_name {
            params.put(&format!("{}{}", prefix, "DBName"), &field_value);
        }
        if let Some(ref field_value) = obj.db_parameter_group_name {
            params.put(
                &format!("{}{}", prefix, "DBParameterGroupName"),
                &field_value,
            );
        }
        params.put(
            &format!("{}{}", prefix, "DBSnapshotIdentifier"),
            &obj.db_snapshot_identifier,
        );
        if let Some(ref field_value) = obj.db_subnet_group_name {
            params.put(&format!("{}{}", prefix, "DBSubnetGroupName"), &field_value);
        }
        if let Some(ref field_value) = obj.deletion_protection {
            params.put(&format!("{}{}", prefix, "DeletionProtection"), &field_value);
        }
        if let Some(ref field_value) = obj.domain {
            params.put(&format!("{}{}", prefix, "Domain"), &field_value);
        }
        if let Some(ref field_value) = obj.domain_iam_role_name {
            params.put(&format!("{}{}", prefix, "DomainIAMRoleName"), &field_value);
        }
        if let Some(ref field_value) = obj.enable_cloudwatch_logs_exports {
            LogTypeListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "EnableCloudwatchLogsExports"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.enable_customer_owned_ip {
            params.put(
                &format!("{}{}", prefix, "EnableCustomerOwnedIp"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.enable_iam_database_authentication {
            params.put(
                &format!("{}{}", prefix, "EnableIAMDatabaseAuthentication"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.engine {
            params.put(&format!("{}{}", prefix, "Engine"), &field_value);
        }
        if let Some(ref field_value) = obj.iops {
            params.put(&format!("{}{}", prefix, "Iops"), &field_value);
        }
        if let Some(ref field_value) = obj.license_model {
            params.put(&format!("{}{}", prefix, "LicenseModel"), &field_value);
        }
        if let Some(ref field_value) = obj.multi_az {
            params.put(&format!("{}{}", prefix, "MultiAZ"), &field_value);
        }
        if let Some(ref field_value) = obj.option_group_name {
            params.put(&format!("{}{}", prefix, "OptionGroupName"), &field_value);
        }
        if let Some(ref field_value) = obj.port {
            params.put(&format!("{}{}", prefix, "Port"), &field_value);
        }
        if let Some(ref field_value) = obj.processor_features {
            ProcessorFeatureListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "ProcessorFeature"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.publicly_accessible {
            params.put(&format!("{}{}", prefix, "PubliclyAccessible"), &field_value);
        }
        if let Some(ref field_value) = obj.storage_type {
            params.put(&format!("{}{}", prefix, "StorageType"), &field_value);
        }
        if let Some(ref field_value) = obj.tags {
            TagListSerializer::serialize(params, &format!("{}{}", prefix, "Tag"), field_value);
        }
        if let Some(ref field_value) = obj.tde_credential_arn {
            params.put(&format!("{}{}", prefix, "TdeCredentialArn"), &field_value);
        }
        if let Some(ref field_value) = obj.tde_credential_password {
            params.put(
                &format!("{}{}", prefix, "TdeCredentialPassword"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.use_default_processor_features {
            params.put(
                &format!("{}{}", prefix, "UseDefaultProcessorFeatures"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.vpc_security_group_ids {
            VpcSecurityGroupIdListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "VpcSecurityGroupId"),
                field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct RestoreDBInstanceFromDBSnapshotResult {
    pub db_instance: Option<DBInstance>,
}

#[allow(dead_code)]
struct RestoreDBInstanceFromDBSnapshotResultDeserializer;
impl RestoreDBInstanceFromDBSnapshotResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<RestoreDBInstanceFromDBSnapshotResult, XmlParseError> {
        deserialize_elements::<_, RestoreDBInstanceFromDBSnapshotResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DBInstance" => {
                        obj.db_instance =
                            Some(DBInstanceDeserializer::deserialize("DBInstance", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct RestoreDBInstanceFromS3Message {
    /// <p><p>The amount of storage (in gigabytes) to allocate initially for the DB instance. Follow the allocation rules specified in <code>CreateDBInstance</code>. </p> <note> <p>Be sure to allocate enough memory for your new DB instance so that the restore operation can succeed. You can also allocate additional memory for future growth. </p> </note></p>
    pub allocated_storage: Option<i64>,
    /// <p>A value that indicates whether minor engine upgrades are applied automatically to the DB instance during the maintenance window. By default, minor engine upgrades are not applied automatically. </p>
    pub auto_minor_version_upgrade: Option<bool>,
    /// <p>The Availability Zone that the DB instance is created in. For information about Amazon Web Services Regions and Availability Zones, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html">Regions and Availability Zones</a> in the <i>Amazon RDS User Guide.</i> </p> <p>Default: A random, system-chosen Availability Zone in the endpoint's Amazon Web Services Region. </p> <p> Example: <code>us-east-1d</code> </p> <p>Constraint: The <code>AvailabilityZone</code> parameter can't be specified if the DB instance is a Multi-AZ deployment. The specified Availability Zone must be in the same Amazon Web Services Region as the current endpoint. </p>
    pub availability_zone: Option<String>,
    /// <p>The number of days for which automated backups are retained. Setting this parameter to a positive number enables backups. For more information, see <code>CreateDBInstance</code>. </p>
    pub backup_retention_period: Option<i64>,
    /// <p>A value that indicates whether to copy all tags from the DB instance to snapshots of the DB instance. By default, tags are not copied. </p>
    pub copy_tags_to_snapshot: Option<bool>,
    /// <p>The compute and memory capacity of the DB instance, for example, <code>db.m4.large</code>. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines. For the full list of DB instance classes, and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB Instance Class</a> in the <i>Amazon RDS User Guide.</i> </p> <p>Importing from Amazon S3 isn't supported on the db.t2.micro DB instance class. </p>
    pub db_instance_class: String,
    /// <p>The DB instance identifier. This parameter is stored as a lowercase string. </p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li> </ul> <p>Example: <code>mydbinstance</code> </p>
    pub db_instance_identifier: String,
    /// <p>The name of the database to create when the DB instance is created. Follow the naming rules specified in <code>CreateDBInstance</code>. </p>
    pub db_name: Option<String>,
    /// <p>The name of the DB parameter group to associate with this DB instance.</p> <p>If you do not specify a value for <code>DBParameterGroupName</code>, then the default <code>DBParameterGroup</code> for the specified DB engine is used.</p>
    pub db_parameter_group_name: Option<String>,
    /// <p>A list of DB security groups to associate with this DB instance.</p> <p>Default: The default DB security group for the database engine.</p>
    pub db_security_groups: Option<Vec<String>>,
    /// <p>A DB subnet group to associate with this DB instance.</p>
    pub db_subnet_group_name: Option<String>,
    /// <p>A value that indicates whether the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html"> Deleting a DB Instance</a>. </p>
    pub deletion_protection: Option<bool>,
    /// <p>The list of logs that the restored DB instance is to export to CloudWatch Logs. The values in the list depend on the DB engine being used. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide</i>.</p>
    pub enable_cloudwatch_logs_exports: Option<Vec<String>>,
    /// <p>A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping is disabled.</p> <p>For more information about IAM database authentication, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database Authentication for MySQL and PostgreSQL</a> in the <i>Amazon RDS User Guide.</i> </p>
    pub enable_iam_database_authentication: Option<bool>,
    /// <p>A value that indicates whether to enable Performance Insights for the DB instance. </p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon Performance Insights</a> in the <i>Amazon Relational Database Service User Guide</i>. </p>
    pub enable_performance_insights: Option<bool>,
    /// <p>The name of the database engine to be used for this instance. </p> <p>Valid Values: <code>mysql</code> </p>
    pub engine: String,
    /// <p>The version number of the database engine to use. Choose the latest minor version of your database engine. For information about engine versions, see <code>CreateDBInstance</code>, or call <code>DescribeDBEngineVersions</code>. </p>
    pub engine_version: Option<String>,
    /// <p>The amount of Provisioned IOPS (input/output operations per second) to allocate initially for the DB instance. For information about valid Iops values, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS Provisioned IOPS Storage to Improve Performance</a> in the <i>Amazon RDS User Guide.</i> </p>
    pub iops: Option<i64>,
    /// <p>The Amazon Web Services KMS key identifier for an encrypted DB instance. </p> <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the Amazon Web Services KMS customer master key (CMK). To use a CMK in a different Amazon Web Services account, specify the key ARN or alias ARN.</p> <p>If the <code>StorageEncrypted</code> parameter is enabled, and you do not specify a value for the <code>KmsKeyId</code> parameter, then Amazon RDS will use your default CMK. There is a default CMK for your Amazon Web Services account. Your Amazon Web Services account has a different default CMK for each Amazon Web Services Region. </p>
    pub kms_key_id: Option<String>,
    /// <p>The license model for this DB instance. Use <code>general-public-license</code>. </p>
    pub license_model: Option<String>,
    /// <p>The password for the master user. The password can include any printable ASCII character except "/", """, or "@". </p> <p>Constraints: Must contain from 8 to 41 characters.</p>
    pub master_user_password: Option<String>,
    /// <p><p>The name for the master user. </p> <p>Constraints: </p> <ul> <li> <p>Must be 1 to 16 letters or numbers.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Can&#39;t be a reserved word for the chosen database engine.</p> </li> </ul></p>
    pub master_username: Option<String>,
    /// <p>The upper limit to which Amazon RDS can automatically scale the storage of the DB instance.</p> <p>For more information about this setting, including limitations that apply to it, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling"> Managing capacity automatically with Amazon RDS storage autoscaling</a> in the <i>Amazon RDS User Guide</i>.</p>
    pub max_allocated_storage: Option<i64>,
    /// <p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0. </p> <p>If <code>MonitoringRoleArn</code> is specified, then you must also set <code>MonitoringInterval</code> to a value other than 0. </p> <p>Valid Values: 0, 1, 5, 10, 15, 30, 60 </p> <p>Default: <code>0</code> </p>
    pub monitoring_interval: Option<i64>,
    /// <p>The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs. For example, <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a monitoring role, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling">Setting Up and Enabling Enhanced Monitoring</a> in the <i>Amazon RDS User Guide.</i> </p> <p>If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a <code>MonitoringRoleArn</code> value. </p>
    pub monitoring_role_arn: Option<String>,
    /// <p>A value that indicates whether the DB instance is a Multi-AZ deployment. If the DB instance is a Multi-AZ deployment, you can't set the <code>AvailabilityZone</code> parameter. </p>
    pub multi_az: Option<bool>,
    /// <p>The name of the option group to associate with this DB instance. If this argument is omitted, the default option group for the specified engine is used. </p>
    pub option_group_name: Option<String>,
    /// <p>The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p> <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the Amazon Web Services KMS customer master key (CMK).</p> <p>If you do not specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your default CMK. There is a default CMK for your Amazon Web Services account. Your Amazon Web Services account has a different default CMK for each Amazon Web Services Region.</p>
    pub performance_insights_kms_key_id: Option<String>,
    /// <p>The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years). </p>
    pub performance_insights_retention_period: Option<i64>,
    /// <p>The port number on which the database accepts connections. </p> <p>Type: Integer </p> <p>Valid Values: <code>1150</code>-<code>65535</code> </p> <p>Default: <code>3306</code> </p>
    pub port: Option<i64>,
    /// <p><p>The time range each day during which automated backups are created if automated backups are enabled. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow">Backup window</a> in the <i>Amazon RDS User Guide.</i> </p> <p>Constraints:</p> <ul> <li> <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p> </li> <li> <p>Must be in Universal Coordinated Time (UTC).</p> </li> <li> <p>Must not conflict with the preferred maintenance window.</p> </li> <li> <p>Must be at least 30 minutes.</p> </li> </ul></p>
    pub preferred_backup_window: Option<String>,
    /// <p><p>The time range each week during which system maintenance can occur, in Universal Coordinated Time (UTC). For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance">Amazon RDS Maintenance Window</a> in the <i>Amazon RDS User Guide.</i> </p> <p>Constraints:</p> <ul> <li> <p>Must be in the format <code>ddd:hh24:mi-ddd:hh24:mi</code>.</p> </li> <li> <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p> </li> <li> <p>Must be in Universal Coordinated Time (UTC).</p> </li> <li> <p>Must not conflict with the preferred backup window.</p> </li> <li> <p>Must be at least 30 minutes.</p> </li> </ul></p>
    pub preferred_maintenance_window: Option<String>,
    /// <p>The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.</p>
    pub processor_features: Option<Vec<ProcessorFeature>>,
    /// <p>A value that indicates whether the DB instance is publicly accessible.</p> <p>When the DB instance is publicly accessible, its DNS endpoint resolves to the private IP address from within the DB instance's VPC, and to the public IP address from outside of the DB instance's VPC. Access to the DB instance is ultimately controlled by the security group it uses, and that public access is not permitted if the security group assigned to the DB instance doesn't permit it.</p> <p>When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address.</p> <p>For more information, see <a>CreateDBInstance</a>.</p>
    pub publicly_accessible: Option<bool>,
    /// <p>The name of your Amazon S3 bucket that contains your database backup file. </p>
    pub s3_bucket_name: String,
    /// <p>An Amazon Web Services Identity and Access Management (IAM) role to allow Amazon RDS to access your Amazon S3 bucket. </p>
    pub s3_ingestion_role_arn: String,
    /// <p>The prefix of your Amazon S3 bucket. </p>
    pub s3_prefix: Option<String>,
    /// <p>The name of the engine of your source database. </p> <p>Valid Values: <code>mysql</code> </p>
    pub source_engine: String,
    /// <p>The version of the database that the backup files were created from.</p> <p>MySQL versions 5.6 and 5.7 are supported. </p> <p>Example: <code>5.6.40</code> </p>
    pub source_engine_version: String,
    /// <p>A value that indicates whether the new DB instance is encrypted or not. </p>
    pub storage_encrypted: Option<bool>,
    /// <p>Specifies the storage type to be associated with the DB instance. </p> <p>Valid values: <code>standard</code> | <code>gp2</code> | <code>io1</code> </p> <p>If you specify <code>io1</code>, you must also include a value for the <code>Iops</code> parameter. </p> <p>Default: <code>io1</code> if the <code>Iops</code> parameter is specified; otherwise <code>gp2</code> </p>
    pub storage_type: Option<String>,
    /// <p>A list of tags to associate with this DB instance. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
    pub tags: Option<Vec<Tag>>,
    /// <p>A value that indicates whether the DB instance class of the DB instance uses its default processor features.</p>
    pub use_default_processor_features: Option<bool>,
    /// <p>A list of VPC security groups to associate with this DB instance. </p>
    pub vpc_security_group_ids: Option<Vec<String>>,
}

/// Serialize `RestoreDBInstanceFromS3Message` contents to a `SignedRequest`.
struct RestoreDBInstanceFromS3MessageSerializer;
impl RestoreDBInstanceFromS3MessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &RestoreDBInstanceFromS3Message) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.allocated_storage {
            params.put(&format!("{}{}", prefix, "AllocatedStorage"), &field_value);
        }
        if let Some(ref field_value) = obj.auto_minor_version_upgrade {
            params.put(
                &format!("{}{}", prefix, "AutoMinorVersionUpgrade"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.availability_zone {
            params.put(&format!("{}{}", prefix, "AvailabilityZone"), &field_value);
        }
        if let Some(ref field_value) = obj.backup_retention_period {
            params.put(
                &format!("{}{}", prefix, "BackupRetentionPeriod"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.copy_tags_to_snapshot {
            params.put(&format!("{}{}", prefix, "CopyTagsToSnapshot"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "DBInstanceClass"),
            &obj.db_instance_class,
        );
        params.put(
            &format!("{}{}", prefix, "DBInstanceIdentifier"),
            &obj.db_instance_identifier,
        );
        if let Some(ref field_value) = obj.db_name {
            params.put(&format!("{}{}", prefix, "DBName"), &field_value);
        }
        if let Some(ref field_value) = obj.db_parameter_group_name {
            params.put(
                &format!("{}{}", prefix, "DBParameterGroupName"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.db_security_groups {
            DBSecurityGroupNameListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "DBSecurityGroupName"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.db_subnet_group_name {
            params.put(&format!("{}{}", prefix, "DBSubnetGroupName"), &field_value);
        }
        if let Some(ref field_value) = obj.deletion_protection {
            params.put(&format!("{}{}", prefix, "DeletionProtection"), &field_value);
        }
        if let Some(ref field_value) = obj.enable_cloudwatch_logs_exports {
            LogTypeListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "EnableCloudwatchLogsExports"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.enable_iam_database_authentication {
            params.put(
                &format!("{}{}", prefix, "EnableIAMDatabaseAuthentication"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.enable_performance_insights {
            params.put(
                &format!("{}{}", prefix, "EnablePerformanceInsights"),
                &field_value,
            );
        }
        params.put(&format!("{}{}", prefix, "Engine"), &obj.engine);
        if let Some(ref field_value) = obj.engine_version {
            params.put(&format!("{}{}", prefix, "EngineVersion"), &field_value);
        }
        if let Some(ref field_value) = obj.iops {
            params.put(&format!("{}{}", prefix, "Iops"), &field_value);
        }
        if let Some(ref field_value) = obj.kms_key_id {
            params.put(&format!("{}{}", prefix, "KmsKeyId"), &field_value);
        }
        if let Some(ref field_value) = obj.license_model {
            params.put(&format!("{}{}", prefix, "LicenseModel"), &field_value);
        }
        if let Some(ref field_value) = obj.master_user_password {
            params.put(&format!("{}{}", prefix, "MasterUserPassword"), &field_value);
        }
        if let Some(ref field_value) = obj.master_username {
            params.put(&format!("{}{}", prefix, "MasterUsername"), &field_value);
        }
        if let Some(ref field_value) = obj.max_allocated_storage {
            params.put(
                &format!("{}{}", prefix, "MaxAllocatedStorage"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.monitoring_interval {
            params.put(&format!("{}{}", prefix, "MonitoringInterval"), &field_value);
        }
        if let Some(ref field_value) = obj.monitoring_role_arn {
            params.put(&format!("{}{}", prefix, "MonitoringRoleArn"), &field_value);
        }
        if let Some(ref field_value) = obj.multi_az {
            params.put(&format!("{}{}", prefix, "MultiAZ"), &field_value);
        }
        if let Some(ref field_value) = obj.option_group_name {
            params.put(&format!("{}{}", prefix, "OptionGroupName"), &field_value);
        }
        if let Some(ref field_value) = obj.performance_insights_kms_key_id {
            params.put(
                &format!("{}{}", prefix, "PerformanceInsightsKMSKeyId"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.performance_insights_retention_period {
            params.put(
                &format!("{}{}", prefix, "PerformanceInsightsRetentionPeriod"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.port {
            params.put(&format!("{}{}", prefix, "Port"), &field_value);
        }
        if let Some(ref field_value) = obj.preferred_backup_window {
            params.put(
                &format!("{}{}", prefix, "PreferredBackupWindow"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.preferred_maintenance_window {
            params.put(
                &format!("{}{}", prefix, "PreferredMaintenanceWindow"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.processor_features {
            ProcessorFeatureListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "ProcessorFeature"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.publicly_accessible {
            params.put(&format!("{}{}", prefix, "PubliclyAccessible"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "S3BucketName"),
            &obj.s3_bucket_name,
        );
        params.put(
            &format!("{}{}", prefix, "S3IngestionRoleArn"),
            &obj.s3_ingestion_role_arn,
        );
        if let Some(ref field_value) = obj.s3_prefix {
            params.put(&format!("{}{}", prefix, "S3Prefix"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "SourceEngine"), &obj.source_engine);
        params.put(
            &format!("{}{}", prefix, "SourceEngineVersion"),
            &obj.source_engine_version,
        );
        if let Some(ref field_value) = obj.storage_encrypted {
            params.put(&format!("{}{}", prefix, "StorageEncrypted"), &field_value);
        }
        if let Some(ref field_value) = obj.storage_type {
            params.put(&format!("{}{}", prefix, "StorageType"), &field_value);
        }
        if let Some(ref field_value) = obj.tags {
            TagListSerializer::serialize(params, &format!("{}{}", prefix, "Tag"), field_value);
        }
        if let Some(ref field_value) = obj.use_default_processor_features {
            params.put(
                &format!("{}{}", prefix, "UseDefaultProcessorFeatures"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.vpc_security_group_ids {
            VpcSecurityGroupIdListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "VpcSecurityGroupId"),
                field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct RestoreDBInstanceFromS3Result {
    pub db_instance: Option<DBInstance>,
}

#[allow(dead_code)]
struct RestoreDBInstanceFromS3ResultDeserializer;
impl RestoreDBInstanceFromS3ResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<RestoreDBInstanceFromS3Result, XmlParseError> {
        deserialize_elements::<_, RestoreDBInstanceFromS3Result, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DBInstance" => {
                        obj.db_instance =
                            Some(DBInstanceDeserializer::deserialize("DBInstance", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct RestoreDBInstanceToPointInTimeMessage {
    /// <p>A value that indicates whether minor version upgrades are applied automatically to the DB instance during the maintenance window.</p>
    pub auto_minor_version_upgrade: Option<bool>,
    /// <p>The Availability Zone (AZ) where the DB instance will be created.</p> <p>Default: A random, system-chosen Availability Zone.</p> <p>Constraint: You can't specify the <code>AvailabilityZone</code> parameter if the DB instance is a Multi-AZ deployment.</p> <p>Example: <code>us-east-1a</code> </p>
    pub availability_zone: Option<String>,
    /// <p>A value that indicates whether to copy all tags from the restored DB instance to snapshots of the DB instance. By default, tags are not copied.</p>
    pub copy_tags_to_snapshot: Option<bool>,
    /// <p>The compute and memory capacity of the Amazon RDS DB instance, for example, <code>db.m4.large</code>. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines. For the full list of DB instance classes, and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB Instance Class</a> in the <i>Amazon RDS User Guide.</i> </p> <p>Default: The same DBInstanceClass as the original DB instance.</p>
    pub db_instance_class: Option<String>,
    /// <p><p>The database name for the restored DB instance.</p> <note> <p>This parameter isn&#39;t used for the MySQL or MariaDB engines.</p> </note></p>
    pub db_name: Option<String>,
    /// <p><p>The name of the DB parameter group to associate with this DB instance.</p> <p>If you do not specify a value for <code>DBParameterGroupName</code>, then the default <code>DBParameterGroup</code> for the specified DB engine is used.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match the name of an existing DBParameterGroup.</p> </li> <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li> <li> <p>First character must 