// =================================================================
//
//                           * WARNING *
//
//                    This file is generated!
//
//  Changes made to this file will be overwritten. If changes are
//  required to the generated code, the service_crategen project
//  must be updated to generate the changes.
//
// =================================================================

use std::error::Error;
use std::fmt;

use async_trait::async_trait;
use rusoto_core::credential::ProvideAwsCredentials;
use rusoto_core::region;
use rusoto_core::request::{BufferedHttpResponse, DispatchSignedRequest};
use rusoto_core::{Client, RusotoError};

use rusoto_core::param::{Params, ServiceParams};
use rusoto_core::proto;
use rusoto_core::signature::SignedRequest;
#[allow(unused_imports)]
use serde::{Deserialize, Serialize};
use serde_json;
/// <p>The criteria that determine when and how a job abort takes place.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct AbortConfig {
    /// <p>The list of criteria that determine when and how to abort the job.</p>
    #[serde(rename = "criteriaList")]
    pub criteria_list: Vec<AbortCriteria>,
}

/// <p>The criteria that determine when and how a job abort takes place.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct AbortCriteria {
    /// <p>The type of job action to take to initiate the job abort.</p>
    #[serde(rename = "action")]
    pub action: String,
    /// <p>The type of job execution failures that can initiate a job abort.</p>
    #[serde(rename = "failureType")]
    pub failure_type: String,
    /// <p>The minimum number of things which must receive job execution notifications before the job can be aborted.</p>
    #[serde(rename = "minNumberOfExecutedThings")]
    pub min_number_of_executed_things: i64,
    /// <p>The minimum percentage of job execution failures that must occur to initiate the job abort.</p> <p>AWS IoT supports up to two digits after the decimal (for example, 10.9 and 10.99, but not 10.999).</p>
    #[serde(rename = "thresholdPercentage")]
    pub threshold_percentage: f64,
}

/// <p>The input for the AcceptCertificateTransfer operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AcceptCertificateTransferRequest {
    /// <p>The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)</p>
    #[serde(rename = "certificateId")]
    pub certificate_id: String,
    /// <p>Specifies whether the certificate is active.</p>
    #[serde(rename = "setAsActive")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub set_as_active: Option<bool>,
}

/// <p>Describes the actions associated with a rule.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct Action {
    /// <p>Change the state of a CloudWatch alarm.</p>
    #[serde(rename = "cloudwatchAlarm")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub cloudwatch_alarm: Option<CloudwatchAlarmAction>,
    /// <p>Send data to CloudWatch Logs.</p>
    #[serde(rename = "cloudwatchLogs")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub cloudwatch_logs: Option<CloudwatchLogsAction>,
    /// <p>Capture a CloudWatch metric.</p>
    #[serde(rename = "cloudwatchMetric")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub cloudwatch_metric: Option<CloudwatchMetricAction>,
    /// <p>Write to a DynamoDB table.</p>
    #[serde(rename = "dynamoDB")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub dynamo_db: Option<DynamoDBAction>,
    /// <p>Write to a DynamoDB table. This is a new version of the DynamoDB action. It allows you to write each attribute in an MQTT message payload into a separate DynamoDB column.</p>
    #[serde(rename = "dynamoDBv2")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub dynamo_d_bv_2: Option<DynamoDBv2Action>,
    /// <p>Write data to an Amazon Elasticsearch Service domain.</p>
    #[serde(rename = "elasticsearch")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub elasticsearch: Option<ElasticsearchAction>,
    /// <p>Write to an Amazon Kinesis Firehose stream.</p>
    #[serde(rename = "firehose")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub firehose: Option<FirehoseAction>,
    /// <p>Send data to an HTTPS endpoint.</p>
    #[serde(rename = "http")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub http: Option<HttpAction>,
    /// <p>Sends message data to an AWS IoT Analytics channel.</p>
    #[serde(rename = "iotAnalytics")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub iot_analytics: Option<IotAnalyticsAction>,
    /// <p>Sends an input to an AWS IoT Events detector.</p>
    #[serde(rename = "iotEvents")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub iot_events: Option<IotEventsAction>,
    /// <p>Sends data from the MQTT message that triggered the rule to AWS IoT SiteWise asset properties.</p>
    #[serde(rename = "iotSiteWise")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub iot_site_wise: Option<IotSiteWiseAction>,
    /// <p>Send messages to an Amazon Managed Streaming for Apache Kafka (Amazon MSK) or self-managed Apache Kafka cluster.</p>
    #[serde(rename = "kafka")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub kafka: Option<KafkaAction>,
    /// <p>Write data to an Amazon Kinesis stream.</p>
    #[serde(rename = "kinesis")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub kinesis: Option<KinesisAction>,
    /// <p>Invoke a Lambda function.</p>
    #[serde(rename = "lambda")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub lambda: Option<LambdaAction>,
    /// <p>Publish to another MQTT topic.</p>
    #[serde(rename = "republish")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub republish: Option<RepublishAction>,
    /// <p>Write to an Amazon S3 bucket.</p>
    #[serde(rename = "s3")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub s_3: Option<S3Action>,
    /// <p>Send a message to a Salesforce IoT Cloud Input Stream.</p>
    #[serde(rename = "salesforce")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub salesforce: Option<SalesforceAction>,
    /// <p>Publish to an Amazon SNS topic.</p>
    #[serde(rename = "sns")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sns: Option<SnsAction>,
    /// <p>Publish to an Amazon SQS queue.</p>
    #[serde(rename = "sqs")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sqs: Option<SqsAction>,
    /// <p>Starts execution of a Step Functions state machine.</p>
    #[serde(rename = "stepFunctions")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub step_functions: Option<StepFunctionsAction>,
    /// <p>The Timestream rule action writes attributes (measures) from an MQTT message into an Amazon Timestream table. For more information, see the <a href="https://docs.aws.amazon.com/iot/latest/developerguide/timestream-rule-action.html">Timestream</a> topic rule action documentation.</p>
    #[serde(rename = "timestream")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub timestream: Option<TimestreamAction>,
}

/// <p>Information about an active Device Defender security profile behavior violation.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ActiveViolation {
    /// <p>The behavior that is being violated.</p>
    #[serde(rename = "behavior")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub behavior: Option<Behavior>,
    /// <p>The time the most recent violation occurred.</p>
    #[serde(rename = "lastViolationTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_violation_time: Option<f64>,
    /// <p>The value of the metric (the measurement) that caused the most recent violation.</p>
    #[serde(rename = "lastViolationValue")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_violation_value: Option<MetricValue>,
    /// <p>The security profile with the behavior is in violation.</p>
    #[serde(rename = "securityProfileName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub security_profile_name: Option<String>,
    /// <p>The name of the thing responsible for the active violation.</p>
    #[serde(rename = "thingName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_name: Option<String>,
    /// <p> The details of a violation event. </p>
    #[serde(rename = "violationEventAdditionalInfo")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub violation_event_additional_info: Option<ViolationEventAdditionalInfo>,
    /// <p>The ID of the active violation.</p>
    #[serde(rename = "violationId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub violation_id: Option<String>,
    /// <p>The time the violation started.</p>
    #[serde(rename = "violationStartTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub violation_start_time: Option<f64>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AddThingToBillingGroupRequest {
    /// <p>The ARN of the billing group.</p>
    #[serde(rename = "billingGroupArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub billing_group_arn: Option<String>,
    /// <p>The name of the billing group.</p>
    #[serde(rename = "billingGroupName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub billing_group_name: Option<String>,
    /// <p>The ARN of the thing to be added to the billing group.</p>
    #[serde(rename = "thingArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_arn: Option<String>,
    /// <p>The name of the thing to be added to the billing group.</p>
    #[serde(rename = "thingName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_name: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct AddThingToBillingGroupResponse {}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AddThingToThingGroupRequest {
    /// <p>Override dynamic thing groups with static thing groups when 10-group limit is reached. If a thing belongs to 10 thing groups, and one or more of those groups are dynamic thing groups, adding a thing to a static group removes the thing from the last dynamic group.</p>
    #[serde(rename = "overrideDynamicGroups")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub override_dynamic_groups: Option<bool>,
    /// <p>The ARN of the thing to add to a group.</p>
    #[serde(rename = "thingArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_arn: Option<String>,
    /// <p>The ARN of the group to which you are adding a thing.</p>
    #[serde(rename = "thingGroupArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_group_arn: Option<String>,
    /// <p>The name of the group to which you are adding a thing.</p>
    #[serde(rename = "thingGroupName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_group_name: Option<String>,
    /// <p>The name of the thing to add to a group.</p>
    #[serde(rename = "thingName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_name: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct AddThingToThingGroupResponse {}

/// <p>Parameters used when defining a mitigation action that move a set of things to a thing group.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct AddThingsToThingGroupParams {
    /// <p>Specifies if this mitigation action can move the things that triggered the mitigation action even if they are part of one or more dynamic thing groups.</p>
    #[serde(rename = "overrideDynamicGroups")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub override_dynamic_groups: Option<bool>,
    /// <p>The list of groups to which you want to add the things that triggered the mitigation action. You can add a thing to a maximum of 10 groups, but you can't add a thing to more than one group in the same hierarchy.</p>
    #[serde(rename = "thingGroupNames")]
    pub thing_group_names: Vec<String>,
}

/// <p>A structure containing the alert target ARN and the role ARN.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct AlertTarget {
    /// <p>The Amazon Resource Name (ARN) of the notification target to which alerts are sent.</p>
    #[serde(rename = "alertTargetArn")]
    pub alert_target_arn: String,
    /// <p>The ARN of the role that grants permission to send alerts to the notification target.</p>
    #[serde(rename = "roleArn")]
    pub role_arn: String,
}

/// <p>Contains information that allowed the authorization.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct Allowed {
    /// <p>A list of policies that allowed the authentication.</p>
    #[serde(rename = "policies")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub policies: Option<Vec<Policy>>,
}

/// <p>An asset property timestamp entry containing the following information.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct AssetPropertyTimestamp {
    /// <p>Optional. A string that contains the nanosecond time offset. Accepts substitution templates.</p>
    #[serde(rename = "offsetInNanos")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub offset_in_nanos: Option<String>,
    /// <p>A string that contains the time in seconds since epoch. Accepts substitution templates.</p>
    #[serde(rename = "timeInSeconds")]
    pub time_in_seconds: String,
}

/// <p>An asset property value entry containing the following information.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct AssetPropertyValue {
    /// <p>Optional. A string that describes the quality of the value. Accepts substitution templates. Must be <code>GOOD</code>, <code>BAD</code>, or <code>UNCERTAIN</code>.</p>
    #[serde(rename = "quality")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub quality: Option<String>,
    /// <p>The asset property value timestamp.</p>
    #[serde(rename = "timestamp")]
    pub timestamp: AssetPropertyTimestamp,
    /// <p>The value of the asset property.</p>
    #[serde(rename = "value")]
    pub value: AssetPropertyVariant,
}

/// <p>Contains an asset property value (of a single type).</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct AssetPropertyVariant {
    /// <p>Optional. A string that contains the boolean value (<code>true</code> or <code>false</code>) of the value entry. Accepts substitution templates.</p>
    #[serde(rename = "booleanValue")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub boolean_value: Option<String>,
    /// <p>Optional. A string that contains the double value of the value entry. Accepts substitution templates.</p>
    #[serde(rename = "doubleValue")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub double_value: Option<String>,
    /// <p>Optional. A string that contains the integer value of the value entry. Accepts substitution templates.</p>
    #[serde(rename = "integerValue")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub integer_value: Option<String>,
    /// <p>Optional. The string value of the value entry. Accepts substitution templates.</p>
    #[serde(rename = "stringValue")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub string_value: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AssociateTargetsWithJobRequest {
    /// <p>An optional comment string describing why the job was associated with the targets.</p>
    #[serde(rename = "comment")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub comment: Option<String>,
    /// <p>The unique identifier you assigned to this job when it was created.</p>
    #[serde(rename = "jobId")]
    pub job_id: String,
    /// <p><p>The namespace used to indicate that a job is a customer-managed job.</p> <p>When you specify a value for this parameter, AWS IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.</p> <p> <code>$aws/things/<i>THING<em>NAME</i>/jobs/<i>JOB</em>ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code> </p> <note> <p>The <code>namespaceId</code> feature is in public preview.</p> </note></p>
    #[serde(rename = "namespaceId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub namespace_id: Option<String>,
    /// <p>A list of thing group ARNs that define the targets of the job.</p>
    #[serde(rename = "targets")]
    pub targets: Vec<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct AssociateTargetsWithJobResponse {
    /// <p>A short text description of the job.</p>
    #[serde(rename = "description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// <p>An ARN identifying the job.</p>
    #[serde(rename = "jobArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub job_arn: Option<String>,
    /// <p>The unique identifier you assigned to this job when it was created.</p>
    #[serde(rename = "jobId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub job_id: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AttachPolicyRequest {
    /// <p>The name of the policy to attach.</p>
    #[serde(rename = "policyName")]
    pub policy_name: String,
    /// <p>The <a href="https://docs.aws.amazon.com/iot/latest/developerguide/security-iam.html">identity</a> to which the policy is attached. For example, a thing group or a certificate.</p>
    #[serde(rename = "target")]
    pub target: String,
}

/// <p>The input for the AttachPrincipalPolicy operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AttachPrincipalPolicyRequest {
    /// <p>The policy name.</p>
    #[serde(rename = "policyName")]
    pub policy_name: String,
    /// <p>The principal, which can be a certificate ARN (as returned from the CreateCertificate operation) or an Amazon Cognito ID.</p>
    #[serde(rename = "principal")]
    pub principal: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AttachSecurityProfileRequest {
    /// <p>The security profile that is attached.</p>
    #[serde(rename = "securityProfileName")]
    pub security_profile_name: String,
    /// <p>The ARN of the target (thing group) to which the security profile is attached.</p>
    #[serde(rename = "securityProfileTargetArn")]
    pub security_profile_target_arn: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct AttachSecurityProfileResponse {}

/// <p>The input for the AttachThingPrincipal operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AttachThingPrincipalRequest {
    /// <p>The principal, which can be a certificate ARN (as returned from the CreateCertificate operation) or an Amazon Cognito ID.</p>
    #[serde(rename = "principal")]
    pub principal: String,
    /// <p>The name of the thing.</p>
    #[serde(rename = "thingName")]
    pub thing_name: String,
}

/// <p>The output from the AttachThingPrincipal operation.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct AttachThingPrincipalResponse {}

/// <p>The attribute payload.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct AttributePayload {
    /// <p>A JSON string containing up to three key-value pair in JSON format. For example:</p> <p> <code>{\"attributes\":{\"string1\":\"string2\"}}</code> </p>
    #[serde(rename = "attributes")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub attributes: Option<::std::collections::HashMap<String, String>>,
    /// <p><p>Specifies whether the list of attributes provided in the <code>AttributePayload</code> is merged with the attributes stored in the registry, instead of overwriting them.</p> <p>To remove an attribute, call <code>UpdateThing</code> with an empty attribute value.</p> <note> <p>The <code>merge</code> attribute is only valid when calling <code>UpdateThing</code> or <code>UpdateThingGroup</code>.</p> </note></p>
    #[serde(rename = "merge")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub merge: Option<bool>,
}

/// <p>Which audit checks are enabled and disabled for this account.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct AuditCheckConfiguration {
    /// <p>True if this audit check is enabled for this account.</p>
    #[serde(rename = "enabled")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
}

/// <p>Information about the audit check.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct AuditCheckDetails {
    /// <p>True if the check is complete and found all resources compliant.</p>
    #[serde(rename = "checkCompliant")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub check_compliant: Option<bool>,
    /// <p>The completion status of this check. One of "IN_PROGRESS", "WAITING_FOR_DATA_COLLECTION", "CANCELED", "COMPLETED_COMPLIANT", "COMPLETED_NON_COMPLIANT", or "FAILED".</p>
    #[serde(rename = "checkRunStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub check_run_status: Option<String>,
    /// <p>The code of any error encountered when this check is performed during this audit. One of "INSUFFICIENT_PERMISSIONS" or "AUDIT_CHECK_DISABLED".</p>
    #[serde(rename = "errorCode")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub error_code: Option<String>,
    /// <p>The message associated with any error encountered when this check is performed during this audit.</p>
    #[serde(rename = "message")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    /// <p>The number of resources that were found noncompliant during the check.</p>
    #[serde(rename = "nonCompliantResourcesCount")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub non_compliant_resources_count: Option<i64>,
    /// <p> Describes how many of the non-compliant resources created during the evaluation of an audit check were marked as suppressed. </p>
    #[serde(rename = "suppressedNonCompliantResourcesCount")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub suppressed_non_compliant_resources_count: Option<i64>,
    /// <p>The number of resources on which the check was performed.</p>
    #[serde(rename = "totalResourcesCount")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub total_resources_count: Option<i64>,
}

/// <p>The findings (results) of the audit.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct AuditFinding {
    /// <p>The audit check that generated this result.</p>
    #[serde(rename = "checkName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub check_name: Option<String>,
    /// <p>A unique identifier for this set of audit findings. This identifier is used to apply mitigation tasks to one or more sets of findings.</p>
    #[serde(rename = "findingId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub finding_id: Option<String>,
    /// <p>The time the result (finding) was discovered.</p>
    #[serde(rename = "findingTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub finding_time: Option<f64>,
    /// <p> Indicates whether the audit finding was suppressed or not during reporting. </p>
    #[serde(rename = "isSuppressed")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub is_suppressed: Option<bool>,
    /// <p>The resource that was found to be noncompliant with the audit check.</p>
    #[serde(rename = "nonCompliantResource")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub non_compliant_resource: Option<NonCompliantResource>,
    /// <p>The reason the resource was noncompliant.</p>
    #[serde(rename = "reasonForNonCompliance")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub reason_for_non_compliance: Option<String>,
    /// <p>A code that indicates the reason that the resource was noncompliant.</p>
    #[serde(rename = "reasonForNonComplianceCode")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub reason_for_non_compliance_code: Option<String>,
    /// <p>The list of related resources.</p>
    #[serde(rename = "relatedResources")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub related_resources: Option<Vec<RelatedResource>>,
    /// <p>The severity of the result (finding).</p>
    #[serde(rename = "severity")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub severity: Option<String>,
    /// <p>The ID of the audit that generated this result (finding).</p>
    #[serde(rename = "taskId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub task_id: Option<String>,
    /// <p>The time the audit started.</p>
    #[serde(rename = "taskStartTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub task_start_time: Option<f64>,
}

/// <p>Returned by ListAuditMitigationActionsTask, this object contains information that describes a mitigation action that has been started.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct AuditMitigationActionExecutionMetadata {
    /// <p>The unique identifier for the mitigation action being applied by the task.</p>
    #[serde(rename = "actionId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub action_id: Option<String>,
    /// <p>The friendly name of the mitigation action being applied by the task.</p>
    #[serde(rename = "actionName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub action_name: Option<String>,
    /// <p>The date and time when the task was completed or canceled. Blank if the task is still running.</p>
    #[serde(rename = "endTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub end_time: Option<f64>,
    /// <p>If an error occurred, the code that indicates which type of error occurred.</p>
    #[serde(rename = "errorCode")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub error_code: Option<String>,
    /// <p>The unique identifier for the findings to which the task and associated mitigation action are applied.</p>
    #[serde(rename = "findingId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub finding_id: Option<String>,
    /// <p>If an error occurred, a message that describes the error.</p>
    #[serde(rename = "message")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    /// <p>The date and time when the task was started.</p>
    #[serde(rename = "startTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub start_time: Option<f64>,
    /// <p>The current status of the task being executed.</p>
    #[serde(rename = "status")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    /// <p>The unique identifier for the task that applies the mitigation action.</p>
    #[serde(rename = "taskId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub task_id: Option<String>,
}

/// <p>Information about an audit mitigation actions task that is returned by <code>ListAuditMitigationActionsTasks</code>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct AuditMitigationActionsTaskMetadata {
    /// <p>The time at which the audit mitigation actions task was started.</p>
    #[serde(rename = "startTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub start_time: Option<f64>,
    /// <p>The unique identifier for the task.</p>
    #[serde(rename = "taskId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub task_id: Option<String>,
    /// <p>The current state of the audit mitigation actions task.</p>
    #[serde(rename = "taskStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub task_status: Option<String>,
}

/// <p>Used in MitigationActionParams, this information identifies the target findings to which the mitigation actions are applied. Only one entry appears.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct AuditMitigationActionsTaskTarget {
    /// <p>Specifies a filter in the form of an audit check and set of reason codes that identify the findings from the audit to which the audit mitigation actions task apply.</p>
    #[serde(rename = "auditCheckToReasonCodeFilter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub audit_check_to_reason_code_filter: Option<::std::collections::HashMap<String, Vec<String>>>,
    /// <p>If the task will apply a mitigation action to findings from a specific audit, this value uniquely identifies the audit.</p>
    #[serde(rename = "auditTaskId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub audit_task_id: Option<String>,
    /// <p>If the task will apply a mitigation action to one or more listed findings, this value uniquely identifies those findings.</p>
    #[serde(rename = "findingIds")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub finding_ids: Option<Vec<String>>,
}

/// <p>Information about the targets to which audit notifications are sent.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct AuditNotificationTarget {
    /// <p>True if notifications to the target are enabled.</p>
    #[serde(rename = "enabled")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
    /// <p>The ARN of the role that grants permission to send notifications to the target.</p>
    #[serde(rename = "roleArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub role_arn: Option<String>,
    /// <p>The ARN of the target (SNS topic) to which audit notifications are sent.</p>
    #[serde(rename = "targetArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub target_arn: Option<String>,
}

/// <p> Filters out specific findings of a Device Defender audit. </p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct AuditSuppression {
    #[serde(rename = "checkName")]
    pub check_name: String,
    /// <p> The description of the audit suppression. </p>
    #[serde(rename = "description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// <p> The expiration date (epoch timestamp in seconds) that you want the suppression to adhere to. </p>
    #[serde(rename = "expirationDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub expiration_date: Option<f64>,
    #[serde(rename = "resourceIdentifier")]
    pub resource_identifier: ResourceIdentifier,
    /// <p> Indicates whether a suppression should exist indefinitely or not. </p>
    #[serde(rename = "suppressIndefinitely")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub suppress_indefinitely: Option<bool>,
}

/// <p>The audits that were performed.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct AuditTaskMetadata {
    /// <p>The ID of this audit.</p>
    #[serde(rename = "taskId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub task_id: Option<String>,
    /// <p>The status of this audit. One of "IN_PROGRESS", "COMPLETED", "FAILED", or "CANCELED".</p>
    #[serde(rename = "taskStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub task_status: Option<String>,
    /// <p>The type of this audit. One of "ON_DEMAND_AUDIT_TASK" or "SCHEDULED_AUDIT_TASK".</p>
    #[serde(rename = "taskType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub task_type: Option<String>,
}

/// <p>A collection of authorization information.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct AuthInfo {
    /// <p>The type of action for which the principal is being authorized.</p>
    #[serde(rename = "actionType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub action_type: Option<String>,
    /// <p>The resources for which the principal is being authorized to perform the specified action.</p>
    #[serde(rename = "resources")]
    pub resources: Vec<String>,
}

/// <p>The authorizer result.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct AuthResult {
    /// <p>The policies and statements that allowed the specified action.</p>
    #[serde(rename = "allowed")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub allowed: Option<Allowed>,
    /// <p>The final authorization decision of this scenario. Multiple statements are taken into account when determining the authorization decision. An explicit deny statement can override multiple allow statements.</p>
    #[serde(rename = "authDecision")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub auth_decision: Option<String>,
    /// <p>Authorization information.</p>
    #[serde(rename = "authInfo")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub auth_info: Option<AuthInfo>,
    /// <p>The policies and statements that denied the specified action.</p>
    #[serde(rename = "denied")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub denied: Option<Denied>,
    /// <p>Contains any missing context values found while evaluating policy.</p>
    #[serde(rename = "missingContextValues")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub missing_context_values: Option<Vec<String>>,
}

/// <p>An object that specifies the authorization service for a domain.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct AuthorizerConfig {
    /// <p>A Boolean that specifies whether the domain configuration's authorization service can be overridden.</p>
    #[serde(rename = "allowAuthorizerOverride")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub allow_authorizer_override: Option<bool>,
    /// <p>The name of the authorization service for a domain configuration.</p>
    #[serde(rename = "defaultAuthorizerName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub default_authorizer_name: Option<String>,
}

/// <p>The authorizer description.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct AuthorizerDescription {
    /// <p>The authorizer ARN.</p>
    #[serde(rename = "authorizerArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub authorizer_arn: Option<String>,
    /// <p>The authorizer's Lambda function ARN.</p>
    #[serde(rename = "authorizerFunctionArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub authorizer_function_arn: Option<String>,
    /// <p>The authorizer name.</p>
    #[serde(rename = "authorizerName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub authorizer_name: Option<String>,
    /// <p>The UNIX timestamp of when the authorizer was created.</p>
    #[serde(rename = "creationDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_date: Option<f64>,
    /// <p>The UNIX timestamp of when the authorizer was last updated.</p>
    #[serde(rename = "lastModifiedDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_date: Option<f64>,
    /// <p>Specifies whether AWS IoT validates the token signature in an authorization request.</p>
    #[serde(rename = "signingDisabled")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub signing_disabled: Option<bool>,
    /// <p>The status of the authorizer.</p>
    #[serde(rename = "status")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    /// <p>The key used to extract the token from the HTTP headers.</p>
    #[serde(rename = "tokenKeyName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub token_key_name: Option<String>,
    /// <p>The public keys used to validate the token signature returned by your custom authentication service.</p>
    #[serde(rename = "tokenSigningPublicKeys")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub token_signing_public_keys: Option<::std::collections::HashMap<String, String>>,
}

/// <p>The authorizer summary.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct AuthorizerSummary {
    /// <p>The authorizer ARN.</p>
    #[serde(rename = "authorizerArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub authorizer_arn: Option<String>,
    /// <p>The authorizer name.</p>
    #[serde(rename = "authorizerName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub authorizer_name: Option<String>,
}

/// <p>The criteria that determine when and how a job abort takes place.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AwsJobAbortConfig {
    /// <p>The list of criteria that determine when and how to abort the job.</p>
    #[serde(rename = "abortCriteriaList")]
    pub abort_criteria_list: Vec<AwsJobAbortCriteria>,
}

/// <p>The criteria that determine when and how a job abort takes place.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AwsJobAbortCriteria {
    /// <p>The type of job action to take to initiate the job abort.</p>
    #[serde(rename = "action")]
    pub action: String,
    /// <p>The type of job execution failures that can initiate a job abort.</p>
    #[serde(rename = "failureType")]
    pub failure_type: String,
    /// <p>The minimum number of things which must receive job execution notifications before the job can be aborted.</p>
    #[serde(rename = "minNumberOfExecutedThings")]
    pub min_number_of_executed_things: i64,
    /// <p>The minimum percentage of job execution failures that must occur to initiate the job abort.</p> <p>AWS IoT supports up to two digits after the decimal (for example, 10.9 and 10.99, but not 10.999).</p>
    #[serde(rename = "thresholdPercentage")]
    pub threshold_percentage: f64,
}

/// <p>Configuration for the rollout of OTA updates.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct AwsJobExecutionsRolloutConfig {
    /// <p>The rate of increase for a job rollout. This parameter allows you to define an exponential rate increase for a job rollout.</p>
    #[serde(rename = "exponentialRate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub exponential_rate: Option<AwsJobExponentialRolloutRate>,
    /// <p>The maximum number of OTA update job executions started per minute.</p>
    #[serde(rename = "maximumPerMinute")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub maximum_per_minute: Option<i64>,
}

/// <p>The rate of increase for a job rollout. This parameter allows you to define an exponential rate increase for a job rollout.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct AwsJobExponentialRolloutRate {
    /// <p>The minimum number of things that will be notified of a pending job, per minute, at the start of the job rollout. This is the initial rate of the rollout.</p>
    #[serde(rename = "baseRatePerMinute")]
    pub base_rate_per_minute: i64,
    /// <p>The rate of increase for a job rollout. The number of things notified is multiplied by this factor.</p>
    #[serde(rename = "incrementFactor")]
    pub increment_factor: f64,
    /// <p>The criteria to initiate the increase in rate of rollout for a job.</p> <p>AWS IoT supports up to one digit after the decimal (for example, 1.5, but not 1.55).</p>
    #[serde(rename = "rateIncreaseCriteria")]
    pub rate_increase_criteria: AwsJobRateIncreaseCriteria,
}

/// <p>Configuration information for pre-signed URLs. Valid when <code>protocols</code> contains HTTP.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct AwsJobPresignedUrlConfig {
    /// <p>How long (in seconds) pre-signed URLs are valid. Valid values are 60 - 3600, the default value is 1800 seconds. Pre-signed URLs are generated when a request for the job document is received.</p>
    #[serde(rename = "expiresInSec")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub expires_in_sec: Option<i64>,
}

/// <p>The criteria to initiate the increase in rate of rollout for a job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct AwsJobRateIncreaseCriteria {
    /// <p>When this number of things have been notified, it will initiate an increase in the rollout rate.</p>
    #[serde(rename = "numberOfNotifiedThings")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub number_of_notified_things: Option<i64>,
    /// <p>When this number of things have succeeded in their job execution, it will initiate an increase in the rollout rate.</p>
    #[serde(rename = "numberOfSucceededThings")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub number_of_succeeded_things: Option<i64>,
}

/// <p>Specifies the amount of time each device has to finish its execution of the job. A timer is started when the job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to another terminal state before the timer expires, it will be automatically set to <code>TIMED_OUT</code>.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AwsJobTimeoutConfig {
    /// <p>Specifies the amount of time, in minutes, this device has to finish execution of this job. The timeout interval can be anywhere between 1 minute and 7 days (1 to 10080 minutes). The in progress timer can't be updated and will apply to all job executions for the job. Whenever a job execution remains in the IN_PROGRESS status for longer than this interval, the job execution will fail and switch to the terminal <code>TIMED_OUT</code> status.</p>
    #[serde(rename = "inProgressTimeoutInMinutes")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub in_progress_timeout_in_minutes: Option<i64>,
}

/// <p>A Device Defender security profile behavior.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct Behavior {
    /// <p>The criteria that determine if a device is behaving normally in regard to the <code>metric</code>.</p>
    #[serde(rename = "criteria")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub criteria: Option<BehaviorCriteria>,
    /// <p>What is measured by the behavior.</p>
    #[serde(rename = "metric")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metric: Option<String>,
    /// <p>The dimension for a metric in your behavior. For example, using a <code>TOPIC_FILTER</code> dimension, you can narrow down the scope of the metric to only MQTT topics where the name matches the pattern specified in the dimension. This can't be used with custom metrics.</p>
    #[serde(rename = "metricDimension")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metric_dimension: Option<MetricDimension>,
    /// <p>The name you've given to the behavior.</p>
    #[serde(rename = "name")]
    pub name: String,
    /// <p> Suppresses alerts. </p>
    #[serde(rename = "suppressAlerts")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub suppress_alerts: Option<bool>,
}

/// <p>The criteria by which the behavior is determined to be normal.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct BehaviorCriteria {
    /// <p><p>The operator that relates the thing measured (<code>metric</code>) to the criteria (containing a <code>value</code> or <code>statisticalThreshold</code>). Valid operators include:</p> <ul> <li> <p> <code>string-list</code>: <code>in-set</code> and <code>not-in-set</code> </p> </li> <li> <p> <code>number-list</code>: <code>in-set</code> and <code>not-in-set</code> </p> </li> <li> <p> <code>ip-address-list</code>: <code>in-cidr-set</code> and <code>not-in-cidr-set</code> </p> </li> <li> <p> <code>number</code>: <code>less-than</code>, <code>less-than-equals</code>, <code>greater-than</code>, and <code>greater-than-equals</code> </p> </li> </ul></p>
    #[serde(rename = "comparisonOperator")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub comparison_operator: Option<String>,
    /// <p>If a device is in violation of the behavior for the specified number of consecutive datapoints, an alarm occurs. If not specified, the default is 1.</p>
    #[serde(rename = "consecutiveDatapointsToAlarm")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub consecutive_datapoints_to_alarm: Option<i64>,
    /// <p>If an alarm has occurred and the offending device is no longer in violation of the behavior for the specified number of consecutive datapoints, the alarm is cleared. If not specified, the default is 1.</p>
    #[serde(rename = "consecutiveDatapointsToClear")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub consecutive_datapoints_to_clear: Option<i64>,
    /// <p>Use this to specify the time duration over which the behavior is evaluated, for those criteria that have a time dimension (for example, <code>NUM_MESSAGES_SENT</code>). For a <code>statisticalThreshhold</code> metric comparison, measurements from all devices are accumulated over this time duration before being used to calculate percentiles, and later, measurements from an individual device are also accumulated over this time duration before being given a percentile rank. Cannot be used with list-based metric datatypes.</p>
    #[serde(rename = "durationSeconds")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub duration_seconds: Option<i64>,
    /// <p> The configuration of an ML Detect </p>
    #[serde(rename = "mlDetectionConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub ml_detection_config: Option<MachineLearningDetectionConfig>,
    /// <p>A statistical ranking (percentile)that indicates a threshold value by which a behavior is determined to be in compliance or in violation of the behavior.</p>
    #[serde(rename = "statisticalThreshold")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub statistical_threshold: Option<StatisticalThreshold>,
    /// <p>The value to be compared with the <code>metric</code>.</p>
    #[serde(rename = "value")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub value: Option<MetricValue>,
}

/// <p> The summary of an ML Detect behavior model. </p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct BehaviorModelTrainingSummary {
    /// <p> The name of the behavior. </p>
    #[serde(rename = "behaviorName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub behavior_name: Option<String>,
    /// <p> The percentage of datapoints collected. </p>
    #[serde(rename = "datapointsCollectionPercentage")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub datapoints_collection_percentage: Option<f64>,
    /// <p> The date the model was last refreshed. </p>
    #[serde(rename = "lastModelRefreshDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_model_refresh_date: Option<f64>,
    /// <p> The status of the behavior model. </p>
    #[serde(rename = "modelStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_status: Option<String>,
    /// <p> The name of the security profile. </p>
    #[serde(rename = "securityProfileName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub security_profile_name: Option<String>,
    /// <p> The date a training model started collecting data. </p>
    #[serde(rename = "trainingDataCollectionStartDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub training_data_collection_start_date: Option<f64>,
}

/// <p>Additional information about the billing group.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct BillingGroupMetadata {
    /// <p>The date the billing group was created.</p>
    #[serde(rename = "creationDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_date: Option<f64>,
}

/// <p>The properties of a billing group.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct BillingGroupProperties {
    /// <p>The description of the billing group.</p>
    #[serde(rename = "billingGroupDescription")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub billing_group_description: Option<String>,
}

/// <p>A CA certificate.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CACertificate {
    /// <p>The ARN of the CA certificate.</p>
    #[serde(rename = "certificateArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub certificate_arn: Option<String>,
    /// <p>The ID of the CA certificate.</p>
    #[serde(rename = "certificateId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub certificate_id: Option<String>,
    /// <p>The date the CA certificate was created.</p>
    #[serde(rename = "creationDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_date: Option<f64>,
    /// <p>The status of the CA certificate.</p> <p>The status value REGISTER_INACTIVE is deprecated and should not be used.</p>
    #[serde(rename = "status")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
}

/// <p>Describes a CA certificate.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CACertificateDescription {
    /// <p>Whether the CA certificate configured for auto registration of device certificates. Valid values are "ENABLE" and "DISABLE"</p>
    #[serde(rename = "autoRegistrationStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub auto_registration_status: Option<String>,
    /// <p>The CA certificate ARN.</p>
    #[serde(rename = "certificateArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub certificate_arn: Option<String>,
    /// <p>The CA certificate ID.</p>
    #[serde(rename = "certificateId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub certificate_id: Option<String>,
    /// <p>The CA certificate data, in PEM format.</p>
    #[serde(rename = "certificatePem")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub certificate_pem: Option<String>,
    /// <p>The date the CA certificate was created.</p>
    #[serde(rename = "creationDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_date: Option<f64>,
    /// <p>The customer version of the CA certificate.</p>
    #[serde(rename = "customerVersion")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub customer_version: Option<i64>,
    /// <p>The generation ID of the CA certificate.</p>
    #[serde(rename = "generationId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub generation_id: Option<String>,
    /// <p>The date the CA certificate was last modified.</p>
    #[serde(rename = "lastModifiedDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_date: Option<f64>,
    /// <p>The owner of the CA certificate.</p>
    #[serde(rename = "ownedBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub owned_by: Option<String>,
    /// <p>The status of a CA certificate.</p>
    #[serde(rename = "status")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    /// <p>When the CA certificate is valid.</p>
    #[serde(rename = "validity")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub validity: Option<CertificateValidity>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CancelAuditMitigationActionsTaskRequest {
    /// <p>The unique identifier for the task that you want to cancel. </p>
    #[serde(rename = "taskId")]
    pub task_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CancelAuditMitigationActionsTaskResponse {}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CancelAuditTaskRequest {
    /// <p>The ID of the audit you want to cancel. You can only cancel an audit that is "IN_PROGRESS".</p>
    #[serde(rename = "taskId")]
    pub task_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CancelAuditTaskResponse {}

/// <p>The input for the CancelCertificateTransfer operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CancelCertificateTransferRequest {
    /// <p>The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)</p>
    #[serde(rename = "certificateId")]
    pub certificate_id: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CancelDetectMitigationActionsTaskRequest {
    /// <p> The unique identifier of the task. </p>
    #[serde(rename = "taskId")]
    pub task_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CancelDetectMitigationActionsTaskResponse {}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CancelJobExecutionRequest {
    /// <p>(Optional) The expected current version of the job execution. Each time you update the job execution, its version is incremented. If the version of the job execution stored in Jobs does not match, the update is rejected with a VersionMismatch error, and an ErrorResponse that contains the current job execution status data is returned. (This makes it unnecessary to perform a separate DescribeJobExecution request in order to obtain the job execution status data.)</p>
    #[serde(rename = "expectedVersion")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub expected_version: Option<i64>,
    /// <p>(Optional) If <code>true</code> the job execution will be canceled if it has status IN_PROGRESS or QUEUED, otherwise the job execution will be canceled only if it has status QUEUED. If you attempt to cancel a job execution that is IN_PROGRESS, and you do not set <code>force</code> to <code>true</code>, then an <code>InvalidStateTransitionException</code> will be thrown. The default is <code>false</code>.</p> <p>Canceling a job execution which is "IN_PROGRESS", will cause the device to be unable to update the job execution status. Use caution and ensure that the device is able to recover to a valid state.</p>
    #[serde(rename = "force")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub force: Option<bool>,
    /// <p>The ID of the job to be canceled.</p>
    #[serde(rename = "jobId")]
    pub job_id: String,
    /// <p>A collection of name/value pairs that describe the status of the job execution. If not specified, the statusDetails are unchanged. You can specify at most 10 name/value pairs.</p>
    #[serde(rename = "statusDetails")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status_details: Option<::std::collections::HashMap<String, String>>,
    /// <p>The name of the thing whose execution of the job will be canceled.</p>
    #[serde(rename = "thingName")]
    pub thing_name: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CancelJobRequest {
    /// <p>An optional comment string describing why the job was canceled.</p>
    #[serde(rename = "comment")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub comment: Option<String>,
    /// <p>(Optional) If <code>true</code> job executions with status "IN_PROGRESS" and "QUEUED" are canceled, otherwise only job executions with status "QUEUED" are canceled. The default is <code>false</code>.</p> <p>Canceling a job which is "IN_PROGRESS", will cause a device which is executing the job to be unable to update the job execution status. Use caution and ensure that each device executing a job which is canceled is able to recover to a valid state.</p>
    #[serde(rename = "force")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub force: Option<bool>,
    /// <p>The unique identifier you assigned to this job when it was created.</p>
    #[serde(rename = "jobId")]
    pub job_id: String,
    /// <p>(Optional)A reason code string that explains why the job was canceled.</p>
    #[serde(rename = "reasonCode")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub reason_code: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CancelJobResponse {
    /// <p>A short text description of the job.</p>
    #[serde(rename = "description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// <p>The job ARN.</p>
    #[serde(rename = "jobArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub job_arn: Option<String>,
    /// <p>The unique identifier you assigned to this job when it was created.</p>
    #[serde(rename = "jobId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub job_id: Option<String>,
}

/// <p>Information about a certificate.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct Certificate {
    /// <p>The ARN of the certificate.</p>
    #[serde(rename = "certificateArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub certificate_arn: Option<String>,
    /// <p>The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)</p>
    #[serde(rename = "certificateId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub certificate_id: Option<String>,
    /// <p>The mode of the certificate.</p>
    #[serde(rename = "certificateMode")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub certificate_mode: Option<String>,
    /// <p>The date and time the certificate was created.</p>
    #[serde(rename = "creationDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_date: Option<f64>,
    /// <p>The status of the certificate.</p> <p>The status value REGISTER_INACTIVE is deprecated and should not be used.</p>
    #[serde(rename = "status")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
}

/// <p>Describes a certificate.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CertificateDescription {
    /// <p>The certificate ID of the CA certificate used to sign this certificate.</p>
    #[serde(rename = "caCertificateId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub ca_certificate_id: Option<String>,
    /// <p>The ARN of the certificate.</p>
    #[serde(rename = "certificateArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub certificate_arn: Option<String>,
    /// <p>The ID of the certificate.</p>
    #[serde(rename = "certificateId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub certificate_id: Option<String>,
    /// <p>The mode of the certificate.</p>
    #[serde(rename = "certificateMode")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub certificate_mode: Option<String>,
    /// <p>The certificate data, in PEM format.</p>
    #[serde(rename = "certificatePem")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub certificate_pem: Option<String>,
    /// <p>The date and time the certificate was created.</p>
    #[serde(rename = "creationDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_date: Option<f64>,
    /// <p>The customer version of the certificate.</p>
    #[serde(rename = "customerVersion")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub customer_version: Option<i64>,
    /// <p>The generation ID of the certificate.</p>
    #[serde(rename = "generationId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub generation_id: Option<String>,
    /// <p>The date and time the certificate was last modified.</p>
    #[serde(rename = "lastModifiedDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_date: Option<f64>,
    /// <p>The ID of the AWS account that owns the certificate.</p>
    #[serde(rename = "ownedBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub owned_by: Option<String>,
    /// <p>The ID of the AWS account of the previous owner of the certificate.</p>
    #[serde(rename = "previousOwnedBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub previous_owned_by: Option<String>,
    /// <p>The status of the certificate.</p>
    #[serde(rename = "status")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    /// <p>The transfer data.</p>
    #[serde(rename = "transferData")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub transfer_data: Option<TransferData>,
    /// <p>When the certificate is valid.</p>
    #[serde(rename = "validity")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub validity: Option<CertificateValidity>,
}

/// <p>When the certificate is valid.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CertificateValidity {
    /// <p>The certificate is not valid after this date.</p>
    #[serde(rename = "notAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub not_after: Option<f64>,
    /// <p>The certificate is not valid before this date.</p>
    #[serde(rename = "notBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub not_before: Option<f64>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ClearDefaultAuthorizerRequest {}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ClearDefaultAuthorizerResponse {}

/// <p>Describes an action that updates a CloudWatch alarm.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct CloudwatchAlarmAction {
    /// <p>The CloudWatch alarm name.</p>
    #[serde(rename = "alarmName")]
    pub alarm_name: String,
    /// <p>The IAM role that allows access to the CloudWatch alarm.</p>
    #[serde(rename = "roleArn")]
    pub role_arn: String,
    /// <p>The reason for the alarm change.</p>
    #[serde(rename = "stateReason")]
    pub state_reason: String,
    /// <p>The value of the alarm state. Acceptable values are: OK, ALARM, INSUFFICIENT_DATA.</p>
    #[serde(rename = "stateValue")]
    pub state_value: String,
}

/// <p>Describes an action that sends data to CloudWatch Logs.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct CloudwatchLogsAction {
    /// <p>The CloudWatch log group to which the action sends data.</p>
    #[serde(rename = "logGroupName")]
    pub log_group_name: String,
    /// <p>The IAM role that allows access to the CloudWatch log.</p>
    #[serde(rename = "roleArn")]
    pub role_arn: String,
}

/// <p>Describes an action that captures a CloudWatch metric.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct CloudwatchMetricAction {
    /// <p>The CloudWatch metric name.</p>
    #[serde(rename = "metricName")]
    pub metric_name: String,
    /// <p>The CloudWatch metric namespace name.</p>
    #[serde(rename = "metricNamespace")]
    pub metric_namespace: String,
    /// <p>An optional <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#about_timestamp">Unix timestamp</a>.</p>
    #[serde(rename = "metricTimestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metric_timestamp: Option<String>,
    /// <p>The <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#Unit">metric unit</a> supported by CloudWatch.</p>
    #[serde(rename = "metricUnit")]
    pub metric_unit: String,
    /// <p>The CloudWatch metric value.</p>
    #[serde(rename = "metricValue")]
    pub metric_value: String,
    /// <p>The IAM role that allows access to the CloudWatch metric.</p>
    #[serde(rename = "roleArn")]
    pub role_arn: String,
}

/// <p>Describes the method to use when code signing a file.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct CodeSigning {
    /// <p>The ID of the AWSSignerJob which was created to sign the file.</p>
    #[serde(rename = "awsSignerJobId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub aws_signer_job_id: Option<String>,
    /// <p>A custom method for code signing a file.</p>
    #[serde(rename = "customCodeSigning")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub custom_code_signing: Option<CustomCodeSigning>,
    /// <p>Describes the code-signing job.</p>
    #[serde(rename = "startSigningJobParameter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub start_signing_job_parameter: Option<StartSigningJobParameter>,
}

/// <p>Describes the certificate chain being used when code signing a file.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct CodeSigningCertificateChain {
    /// <p>The name of the certificate.</p>
    #[serde(rename = "certificateName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub certificate_name: Option<String>,
    /// <p>A base64 encoded binary representation of the code signing certificate chain.</p>
    #[serde(rename = "inlineDocument")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub inline_document: Option<String>,
}

/// <p>Describes the signature for a file.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct CodeSigningSignature {
    /// <p>A base64 encoded binary representation of the code signing signature.</p>
    #[serde(rename = "inlineDocument")]
    #[serde(
        deserialize_with = "::rusoto_core::serialization::SerdeBlob::deserialize_blob",
        serialize_with = "::rusoto_core::serialization::SerdeBlob::serialize_blob",
        default
    )]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub inline_document: Option<bytes::Bytes>,
}

/// <p>Configuration.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct Configuration {
    /// <p>True to enable the configuration.</p>
    #[serde(rename = "Enabled")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ConfirmTopicRuleDestinationRequest {
    /// <p>The token used to confirm ownership or access to the topic rule confirmation URL.</p>
    #[serde(rename = "confirmationToken")]
    pub confirmation_token: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ConfirmTopicRuleDestinationResponse {}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateAuditSuppressionRequest {
    #[serde(rename = "checkName")]
    pub check_name: String,
    /// <p> The epoch timestamp in seconds at which this suppression expires. </p>
    #[serde(rename = "clientRequestToken")]
    pub client_request_token: String,
    /// <p> The description of the audit suppression. </p>
    #[serde(rename = "description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// <p> The epoch timestamp in seconds at which this suppression expires. </p>
    #[serde(rename = "expirationDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub expiration_date: Option<f64>,
    #[serde(rename = "resourceIdentifier")]
    pub resource_identifier: ResourceIdentifier,
    /// <p> Indicates whether a suppression should exist indefinitely or not. </p>
    #[serde(rename = "suppressIndefinitely")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub suppress_indefinitely: Option<bool>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateAuditSuppressionResponse {}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateAuthorizerRequest {
    /// <p>The ARN of the authorizer's Lambda function.</p>
    #[serde(rename = "authorizerFunctionArn")]
    pub authorizer_function_arn: String,
    /// <p>The authorizer name.</p>
    #[serde(rename = "authorizerName")]
    pub authorizer_name: String,
    /// <p>Specifies whether AWS IoT validates the token signature in an authorization request.</p>
    #[serde(rename = "signingDisabled")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub signing_disabled: Option<bool>,
    /// <p>The status of the create authorizer request.</p>
    #[serde(rename = "status")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    /// <p><p>Metadata which can be used to manage the custom authorizer.</p> <note> <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p> <p>For the CLI command-line parameter use format: &amp;&amp;tags &quot;key1=value1&amp;key2=value2...&quot;</p> <p>For the cli-input-json file use format: &quot;tags&quot;: &quot;key1=value1&amp;key2=value2...&quot;</p> </note></p>
    #[serde(rename = "tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
    /// <p>The name of the token key used to extract the token from the HTTP headers.</p>
    #[serde(rename = "tokenKeyName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub token_key_name: Option<String>,
    /// <p>The public keys used to verify the digital signature returned by your custom authentication service.</p>
    #[serde(rename = "tokenSigningPublicKeys")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub token_signing_public_keys: Option<::std::collections::HashMap<String, String>>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateAuthorizerResponse {
    /// <p>The authorizer ARN.</p>
    #[serde(rename = "authorizerArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub authorizer_arn: Option<String>,
    /// <p>The authorizer's name.</p>
    #[serde(rename = "authorizerName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub authorizer_name: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateBillingGroupRequest {
    /// <p>The name you wish to give to the billing group.</p>
    #[serde(rename = "billingGroupName")]
    pub billing_group_name: String,
    /// <p>The properties of the billing group.</p>
    #[serde(rename = "billingGroupProperties")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub billing_group_properties: Option<BillingGroupProperties>,
    /// <p>Metadata which can be used to manage the billing group.</p>
    #[serde(rename = "tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateBillingGroupResponse {
    /// <p>The ARN of the billing group.</p>
    #[serde(rename = "billingGroupArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub billing_group_arn: Option<String>,
    /// <p>The ID of the billing group.</p>
    #[serde(rename = "billingGroupId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub billing_group_id: Option<String>,
    /// <p>The name you gave to the billing group.</p>
    #[serde(rename = "billingGroupName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub billing_group_name: Option<String>,
}

/// <p>The input for the CreateCertificateFromCsr operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateCertificateFromCsrRequest {
    /// <p>The certificate signing request (CSR).</p>
    #[serde(rename = "certificateSigningRequest")]
    pub certificate_signing_request: String,
    /// <p>Specifies whether the certificate is active.</p>
    #[serde(rename = "setAsActive")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub set_as_active: Option<bool>,
}

/// <p>The output from the CreateCertificateFromCsr operation.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateCertificateFromCsrResponse {
    /// <p>The Amazon Resource Name (ARN) of the certificate. You can use the ARN as a principal for policy operations.</p>
    #[serde(rename = "certificateArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub certificate_arn: Option<String>,
    /// <p>The ID of the certificate. Certificate management operations only take a certificateId.</p>
    #[serde(rename = "certificateId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub certificate_id: Option<String>,
    /// <p>The certificate data, in PEM format.</p>
    #[serde(rename = "certificatePem")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub certificate_pem: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateCustomMetricRequest {
    /// <p>Each custom metric must have a unique client request token. If you try to create a new custom metric that already exists with a different token, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
    #[serde(rename = "clientRequestToken")]
    pub client_request_token: String,
    /// <p> Field represents a friendly name in the console for the custom metric; it doesn't have to be unique. Don't use this name as the metric identifier in the device metric report. Can be updated once defined.</p>
    #[serde(rename = "displayName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    /// <p> The name of the custom metric. This will be used in the metric report submitted from the device/thing. Shouldn't begin with <code>aws:</code>. Cannot be updated once defined.</p>
    #[serde(rename = "metricName")]
    pub metric_name: String,
    /// <p> The type of the custom metric. Types include <code>string-list</code>, <code>ip-address-list</code>, <code>number-list</code>, and <code>number</code>. </p>
    #[serde(rename = "metricType")]
    pub metric_type: String,
    /// <p> Metadata that can be used to manage the custom metric. </p>
    #[serde(rename = "tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateCustomMetricResponse {
    /// <p> The Amazon Resource Number (ARN) of the custom metric, e.g. <code>arn:<i>aws-partition</i>:iot:<i>region</i>:<i>accountId</i>:custommetric/<i>metricName</i> </code> </p>
    #[serde(rename = "metricArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metric_arn: Option<String>,
    /// <p> The name of the custom metric to be used in the metric report. </p>
    #[serde(rename = "metricName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metric_name: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateDimensionRequest {
    /// <p>Each dimension must have a unique client request token. If you try to create a new dimension with the same token as a dimension that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request.</p>
    #[serde(rename = "clientRequestToken")]
    pub client_request_token: String,
    /// <p>A unique identifier for the dimension. Choose something that describes the type and value to make it easy to remember what it does.</p>
    #[serde(rename = "name")]
    pub name: String,
    /// <p>Specifies the value or list of values for the dimension. For <code>TOPIC_FILTER</code> dimensions, this is a pattern used to match the MQTT topic (for example, "admin/#").</p>
    #[serde(rename = "stringValues")]
    pub string_values: Vec<String>,
    /// <p>Metadata that can be used to manage the dimension.</p>
    #[serde(rename = "tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
    /// <p>Specifies the type of dimension. Supported types: <code>TOPIC_FILTER.</code> </p>
    #[serde(rename = "type")]
    pub type_: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateDimensionResponse {
    /// <p>The Amazon Resource Name (ARN) of the created dimension.</p>
    #[serde(rename = "arn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub arn: Option<String>,
    /// <p>A unique identifier for the dimension.</p>
    #[serde(rename = "name")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateDomainConfigurationRequest {
    /// <p>An object that specifies the authorization service for a domain.</p>
    #[serde(rename = "authorizerConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub authorizer_config: Option<AuthorizerConfig>,
    /// <p>The name of the domain configuration. This value must be unique to a region.</p>
    #[serde(rename = "domainConfigurationName")]
    pub domain_configuration_name: String,
    /// <p>The name of the domain.</p>
    #[serde(rename = "domainName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub domain_name: Option<String>,
    /// <p>The ARNs of the certificates that AWS IoT passes to the device during the TLS handshake. Currently you can specify only one certificate ARN. This value is not required for AWS-managed domains.</p>
    #[serde(rename = "serverCertificateArns")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub server_certificate_arns: Option<Vec<String>>,
    /// <p><p>The type of service delivered by the endpoint.</p> <note> <p>AWS IoT Core currently supports only the <code>DATA</code> service type.</p> </note></p>
    #[serde(rename = "serviceType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub service_type: Option<String>,
    /// <p><p>Metadata which can be used to manage the domain configuration.</p> <note> <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p> <p>For the CLI command-line parameter use format: &amp;&amp;tags &quot;key1=value1&amp;key2=value2...&quot;</p> <p>For the cli-input-json file use format: &quot;tags&quot;: &quot;key1=value1&amp;key2=value2...&quot;</p> </note></p>
    #[serde(rename = "tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
    /// <p>The certificate used to validate the server certificate and prove domain name ownership. This certificate must be signed by a public certificate authority. This value is not required for AWS-managed domains.</p>
    #[serde(rename = "validationCertificateArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub validation_certificate_arn: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateDomainConfigurationResponse {
    /// <p>The ARN of the domain configuration.</p>
    #[serde(rename = "domainConfigurationArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub domain_configuration_arn: Option<String>,
    /// <p>The name of the domain configuration.</p>
    #[serde(rename = "domainConfigurationName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub domain_configuration_name: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateDynamicThingGroupRequest {
    /// <p><p>The dynamic thing group index name.</p> <note> <p>Currently one index is supported: &quot;AWS_Things&quot;.</p> </note></p>
    #[serde(rename = "indexName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub index_name: Option<String>,
    /// <p>The dynamic thing group search query string.</p> <p>See <a href="https://docs.aws.amazon.com/iot/latest/developerguide/query-syntax.html">Query Syntax</a> for information about query string syntax.</p>
    #[serde(rename = "queryString")]
    pub query_string: String,
    /// <p><p>The dynamic thing group query version.</p> <note> <p>Currently one query version is supported: &quot;2017-09-30&quot;. If not specified, the query version defaults to this value.</p> </note></p>
    #[serde(rename = "queryVersion")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub query_version: Option<String>,
    /// <p>Metadata which can be used to manage the dynamic thing group.</p>
    #[serde(rename = "tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
    /// <p>The dynamic thing group name to create.</p>
    #[serde(rename = "thingGroupName")]
    pub thing_group_name: String,
    /// <p>The dynamic thing group properties.</p>
    #[serde(rename = "thingGroupProperties")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_group_properties: Option<ThingGroupProperties>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateDynamicThingGroupResponse {
    /// <p>The dynamic thing group index name.</p>
    #[serde(rename = "indexName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub index_name: Option<String>,
    /// <p>The dynamic thing group search query string.</p>
    #[serde(rename = "queryString")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub query_string: Option<String>,
    /// <p>The dynamic thing group query version.</p>
    #[serde(rename = "queryVersion")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub query_version: Option<String>,
    /// <p>The dynamic thing group ARN.</p>
    #[serde(rename = "thingGroupArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_group_arn: Option<String>,
    /// <p>The dynamic thing group ID.</p>
    #[serde(rename = "thingGroupId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_group_id: Option<String>,
    /// <p>The dynamic thing group name.</p>
    #[serde(rename = "thingGroupName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_group_name: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateJobRequest {
    /// <p>Allows you to create criteria to abort a job.</p>
    #[serde(rename = "abortConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub abort_config: Option<AbortConfig>,
    /// <p>A short text description of the job.</p>
    #[serde(rename = "description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// <p>The job document. Required if you don't specify a value for <code>documentSource</code>.</p>
    #[serde(rename = "document")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub document: Option<String>,
    /// <p><p>An S3 link to the job document. Required if you don&#39;t specify a value for <code>document</code>.</p> <note> <p>If the job document resides in an S3 bucket, you must use a placeholder link when specifying the document.</p> <p>The placeholder link is of the following form:</p> <p> <code>${aws:iot:s3-presigned-url:https://s3.amazonaws.com/<i>bucket</i>/<i>key</i>}</code> </p> <p>where <i>bucket</i> is your bucket name and <i>key</i> is the object in the bucket to which you are linking.</p> </note></p>
    #[serde(rename = "documentSource")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub document_source: Option<String>,
    /// <p>Allows you to create a staged rollout of the job.</p>
    #[serde(rename = "jobExecutionsRolloutConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub job_executions_rollout_config: Option<JobExecutionsRolloutConfig>,
    /// <p>A job identifier which must be unique for your AWS account. We recommend using a UUID. Alpha-numeric characters, "-" and "_" are valid for use here.</p>
    #[serde(rename = "jobId")]
    pub job_id: String,
    /// <p>The ARN of the job template used to create the job.</p>
    #[serde(rename = "jobTemplateArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub job_template_arn: Option<String>,
    /// <p><p>The namespace used to indicate that a job is a customer-managed job.</p> <p>When you specify a value for this parameter, AWS IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.</p> <p> <code>$aws/things/<i>THING<em>NAME</i>/jobs/<i>JOB</em>ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code> </p> <note> <p>The <code>namespaceId</code> feature is in public preview.</p> </note></p>
    #[serde(rename = "namespaceId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub namespace_id: Option<String>,
    /// <p>Configuration information for pre-signed S3 URLs.</p>
    #[serde(rename = "presignedUrlConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub presigned_url_config: Option<PresignedUrlConfig>,
    /// <p>Metadata which can be used to manage the job.</p>
    #[serde(rename = "tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
    /// <p>Specifies whether the job will continue to run (CONTINUOUS), or will be complete after all those things specified as targets have completed the job (SNAPSHOT). If continuous, the job may also be run on a thing when a change is detected in a target. For example, a job will run on a thing when the thing is added to a target group, even after the job was completed by all things originally in the group.</p>
    #[serde(rename = "targetSelection")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub target_selection: Option<String>,
    /// <p>A list of things and thing groups to which the job should be sent.</p>
    #[serde(rename = "targets")]
    pub targets: Vec<String>,
    /// <p>Specifies the amount of time each device has to finish its execution of the job. The timer is started when the job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to another terminal state before the time expires, it will be automatically set to <code>TIMED_OUT</code>.</p>
    #[serde(rename = "timeoutConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub timeout_config: Option<TimeoutConfig>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateJobResponse {
    /// <p>The job description.</p>
    #[serde(rename = "description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// <p>The job ARN.</p>
    #[serde(rename = "jobArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub job_arn: Option<String>,
    /// <p>The unique identifier you assigned to this job.</p>
    #[serde(rename = "jobId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub job_id: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateJobTemplateRequest {
    #[serde(rename = "abortConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub abort_config: Option<AbortConfig>,
    /// <p>A description of the job document.</p>
    #[serde(rename = "description")]
    pub description: String,
    /// <p>The job document. Required if you don't specify a value for <code>documentSource</code>.</p>
    #[serde(rename = "document")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub document: Option<String>,
    /// <p><p>An S3 link to the job document to use in the template. Required if you don&#39;t specify a value for <code>document</code>.</p> <note> <p>If the job document resides in an S3 bucket, you must use a placeholder link when specifying the document.</p> <p>The placeholder link is of the following form:</p> <p> <code>${aws:iot:s3-presigned-url:https://s3.amazonaws.com/<i>bucket</i>/<i>key</i>}</code> </p> <p>where <i>bucket</i> is your bucket name and <i>key</i> is the object in the bucket to which you are linking.</p> </note></p>
    #[serde(rename = "documentSource")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub document_source: Option<String>,
    /// <p>The ARN of the job to use as the basis for the job template.</p>
    #[serde(rename = "jobArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub job_arn: Option<String>,
    #[serde(rename = "jobExecutionsRolloutConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub job_executions_rollout_config: Option<JobExecutionsRolloutConfig>,
    /// <p>A unique identifier for the job template. We recommend using a UUID. Alpha-numeric characters, "-", and "_" are valid for use here.</p>
    #[serde(rename = "jobTemplateId")]
    pub job_template_id: String,
    #[serde(rename = "presignedUrlConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub presigned_url_config: Option<PresignedUrlConfig>,
    /// <p>Metadata that can be used to manage the job template.</p>
    #[serde(rename = "tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
    #[serde(rename = "timeoutConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub timeout_config: Option<TimeoutConfig>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateJobTemplateResponse {
    /// <p>The ARN of the job template.</p>
    #[serde(rename = "jobTemplateArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub job_template_arn: Option<String>,
    /// <p>The unique identifier of the job template.</p>
    #[serde(rename = "jobTemplateId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub job_template_id: Option<String>,
}

/// <p>The input for the CreateKeysAndCertificate operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateKeysAndCertificateRequest {
    /// <p>Specifies whether the certificate is active.</p>
    #[serde(rename = "setAsActive")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub set_as_active: Option<bool>,
}

/// <p>The output of the CreateKeysAndCertificate operation.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateKeysAndCertificateResponse {
    /// <p>The ARN of the certificate.</p>
    #[serde(rename = "certificateArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub certificate_arn: Option<String>,
    /// <p>The ID of the certificate. AWS IoT issues a default subject name for the certificate (for example, AWS IoT Certificate).</p>
    #[serde(rename = "certificateId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub certificate_id: Option<String>,
    /// <p>The certificate data, in PEM format.</p>
    #[serde(rename = "certificatePem")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub certificate_pem: Option<String>,
    /// <p>The generated key pair.</p>
    #[serde(rename = "keyPair")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub key_pair: Option<KeyPair>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateMitigationActionRequest {
    /// <p>A friendly name for the action. Choose a friendly name that accurately describes the action (for example, <code>EnableLoggingAction</code>).</p>
    #[serde(rename = "actionName")]
    pub action_name: String,
    /// <p>Defines the type of action and the parameters for that action.</p>
    #[serde(rename = "actionParams")]
    pub action_params: MitigationActionParams,
    /// <p>The ARN of the IAM role that is used to apply the mitigation action.</p>
    #[serde(rename = "roleArn")]
    pub role_arn: String,
    /// <p>Metadata that can be used to manage the mitigation action.</p>
    #[serde(rename = "tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateMitigationActionResponse {
    /// <p>The ARN for the new mitigation action.</p>
    #[serde(rename = "actionArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub action_arn: Option<String>,
    /// <p>A unique identifier for the new mitigation action.</p>
    #[serde(rename = "actionId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub action_id: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateOTAUpdateRequest {
    /// <p>A list of additional OTA update parameters which are name-value pairs.</p>
    #[serde(rename = "additionalParameters")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub additional_parameters: Option<::std::collections::HashMap<String, String>>,
    /// <p>The criteria that determine when and how a job abort takes place.</p>
    #[serde(rename = "awsJobAbortConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub aws_job_abort_config: Option<AwsJobAbortConfig>,
    /// <p>Configuration for the rollout of OTA updates.</p>
    #[serde(rename = "awsJobExecutionsRolloutConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub aws_job_executions_rollout_config: Option<AwsJobExecutionsRolloutConfig>,
    /// <p>Configuration information for pre-signed URLs.</p>
    #[serde(rename = "awsJobPresignedUrlConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub aws_job_presigned_url_config: Option<AwsJobPresignedUrlConfig>,
    /// <p>Specifies the amount of time each device has to finish its execution of the job. A timer is started when the job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to another terminal state before the timer expires, it will be automatically set to <code>TIMED_OUT</code>.</p>
    #[serde(rename = "awsJobTimeoutConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub aws_job_timeout_config: Option<AwsJobTimeoutConfig>,
    /// <p>The description of the OTA update.</p>
    #[serde(rename = "description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// <p>The files to be streamed by the OTA update.</p>
    #[serde(rename = "files")]
    pub files: Vec<OTAUpdateFile>,
    /// <p>The ID of the OTA update to be created.</p>
    #[serde(rename = "otaUpdateId")]
    pub ota_update_id: String,
    /// <p>The protocol used to transfer the OTA update image. Valid values are [HTTP], [MQTT], [HTTP, MQTT]. When both HTTP and MQTT are specified, the target device can choose the protocol.</p>
    #[serde(rename = "protocols")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub protocols: Option<Vec<String>>,
    /// <p>The IAM role that grants AWS IoT access to the Amazon S3, AWS IoT jobs and AWS Code Signing resources to create an OTA update job.</p>
    #[serde(rename = "roleArn")]
    pub role_arn: String,
    /// <p>Metadata which can be used to manage updates.</p>
    #[serde(rename = "tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
    /// <p>Specifies whether the update will continue to run (CONTINUOUS), or will be complete after all the things specified as targets have completed the update (SNAPSHOT). If continuous, the update may also be run on a thing when a change is detected in a target. For example, an update will run on a thing when the thing is added to a target group, even after the update was completed by all things originally in the group. Valid values: CONTINUOUS | SNAPSHOT.</p>
    #[serde(rename = "targetSelection")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub target_selection: Option<String>,
    /// <p>The devices targeted to receive OTA updates.</p>
    #[serde(rename = "targets")]
    pub targets: Vec<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateOTAUpdateResponse {
    /// <p>The AWS IoT job ARN associated with the OTA update.</p>
    #[serde(rename = "awsIotJobArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub aws_iot_job_arn: Option<String>,
    /// <p>The AWS IoT job ID associated with the OTA update.</p>
    #[serde(rename = "awsIotJobId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub aws_iot_job_id: Option<String>,
    /// <p>The OTA update ARN.</p>
    #[serde(rename = "otaUpdateArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub ota_update_arn: Option<String>,
    /// <p>The OTA update ID.</p>
    #[serde(rename = "otaUpdateId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub ota_update_id: Option<String>,
    /// <p>The OTA update status.</p>
    #[serde(rename = "otaUpdateStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub ota_update_status: Option<String>,
}

/// <p>The input for the CreatePolicy operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreatePolicyRequest {
    /// <p>The JSON document that describes the policy. <b>policyDocument</b> must have a minimum length of 1, with a maximum length of 2048, excluding whitespace.</p>
    #[serde(rename = "policyDocument")]
    pub policy_document: String,
    /// <p>The policy name.</p>
    #[serde(rename = "policyName")]
    pub policy_name: String,
    /// <p><p>Metadata which can be used to manage the policy.</p> <note> <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p> <p>For the CLI command-line parameter use format: &amp;&amp;tags &quot;key1=value1&amp;key2=value2...&quot;</p> <p>For the cli-input-json file use format: &quot;tags&quot;: &quot;key1=value1&amp;key2=value2...&quot;</p> </note></p>
    #[serde(rename = "tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
}

/// <p>The output from the CreatePolicy operation.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreatePolicyResponse {
    /// <p>The policy ARN.</p>
    #[serde(rename = "policyArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub policy_arn: Option<String>,
    /// <p>The JSON document that describes the policy.</p>
    #[serde(rename = "policyDocument")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub policy_document: Option<String>,
    /// <p>The policy name.</p>
    #[serde(rename = "policyName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub policy_name: Option<String>,
    /// <p>The policy version ID.</p>
    #[serde(rename = "policyVersionId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub policy_version_id: Option<String>,
}

/// <p>The input for the CreatePolicyVersion operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreatePolicyVersionRequest {
    /// <p>The JSON document that describes the policy. Minimum length of 1. Maximum length of 2048, excluding whitespace.</p>
    #[serde(rename = "policyDocument")]
    pub policy_document: String,
    /// <p>The policy name.</p>
    #[serde(rename = "policyName")]
    pub policy_name: String,
    /// <p>Specifies whether the policy version is set as the default. When this parameter is true, the new policy version becomes the operative version (that is, the version that is in effect for the certificates to which the policy is attached).</p>
    #[serde(rename = "setAsDefault")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub set_as_default: Option<bool>,
}

/// <p>The output of the CreatePolicyVersion operation.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreatePolicyVersionResponse {
    /// <p>Specifies whether the policy version is the default.</p>
    #[serde(rename = "isDefaultVersion")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub is_default_version: Option<bool>,
    /// <p>The policy ARN.</p>
    #[serde(rename = "policyArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub policy_arn: Option<String>,
    /// <p>The JSON document that describes the policy.</p>
    #[serde(rename = "policyDocument")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub policy_document: Option<String>,
    /// <p>The policy version ID.</p>
    #[serde(rename = "policyVersionId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub policy_version_id: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateProvisioningClaimRequest {
    /// <p>The name of the provisioning template to use.</p>
    #[serde(rename = "templateName")]
    pub template_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateProvisioningClaimResponse {
    /// <p>The ID of the certificate.</p>
    #[serde(rename = "certificateId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub certificate_id: Option<String>,
    /// <p>The provisioning claim certificate.</p>
    #[serde(rename = "certificatePem")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub certificate_pem: Option<String>,
    /// <p>The provisioning claim expiration time.</p>
    #[serde(rename = "expiration")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub expiration: Option<f64>,
    /// <p>The provisioning claim key pair.</p>
    #[serde(rename = "keyPair")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub key_pair: Option<KeyPair>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateProvisioningTemplateRequest {
    /// <p>The description of the fleet provisioning template.</p>
    #[serde(rename = "description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// <p>True to enable the fleet provisioning template, otherwise false.</p>
    #[serde(rename = "enabled")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
    /// <p>Creates a pre-provisioning hook template.</p>
    #[serde(rename = "preProvisioningHook")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pre_provisioning_hook: Option<ProvisioningHook>,
    /// <p>The role ARN for the role associated with the fleet provisioning template. This IoT role grants permission to provision a device.</p>
    #[serde(rename = "provisioningRoleArn")]
    pub provisioning_role_arn: String,
    /// <p><p>Metadata which can be used to manage the fleet provisioning template.</p> <note> <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p> <p>For the CLI command-line parameter use format: &amp;&amp;tags &quot;key1=value1&amp;key2=value2...&quot;</p> <p>For the cli-input-json file use format: &quot;tags&quot;: &quot;key1=value1&amp;key2=value2...&quot;</p> </note></p>
    #[serde(rename = "tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
    /// <p>The JSON formatted contents of the fleet provisioning template.</p>
    #[serde(rename = "templateBody")]
    pub template_body: String,
    /// <p>The name of the fleet provisioning template.</p>
    #[serde(rename = "templateName")]
    pub template_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateProvisioningTemplateResponse {
    /// <p>The default version of the fleet provisioning template.</p>
    #[serde(rename = "defaultVersionId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub default_version_id: Option<i64>,
    /// <p>The ARN that identifies the provisioning template.</p>
    #[serde(rename = "templateArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub template_arn: Option<String>,
    /// <p>The name of the fleet provisioning template.</p>
    #[serde(rename = "templateName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub template_name: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateProvisioningTemplateVersionRequest {
    /// <p>Sets a fleet provision template version as the default version.</p>
    #[serde(rename = "setAsDefault")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub set_as_default: Option<bool>,
    /// <p>The JSON formatted contents of the fleet provisioning template.</p>
    #[serde(rename = "templateBody")]
    pub template_body: String,
    /// <p>The name of the fleet provisioning template.</p>
    #[serde(rename = "templateName")]
    pub template_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateProvisioningTemplateVersionResponse {
    /// <p>True if the fleet provisioning template version is the default version, otherwise false.</p>
    #[serde(rename = "isDefaultVersion")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub is_default_version: Option<bool>,
    /// <p>The ARN that identifies the provisioning template.</p>
    #[serde(rename = "templateArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub template_arn: Option<String>,
    /// <p>The name of the fleet provisioning template.</p>
    #[serde(rename = "templateName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub template_name: Option<String>,
    /// <p>The version of the fleet provisioning template.</p>
    #[serde(rename = "versionId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub version_id: Option<i64>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateRoleAliasRequest {
    /// <p>How long (in seconds) the credentials will be valid.</p>
    #[serde(rename = "credentialDurationSeconds")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub credential_duration_seconds: Option<i64>,
    /// <p>The role alias that points to a role ARN. This allows you to change the role without having to update the device.</p>
    #[serde(rename = "roleAlias")]
    pub role_alias: String,
    /// <p>The role ARN.</p>
    #[serde(rename = "roleArn")]
    pub role_arn: String,
    /// <p><p>Metadata which can be used to manage the role alias.</p> <note> <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p> <p>For the CLI command-line parameter use format: &amp;&amp;tags &quot;key1=value1&amp;key2=value2...&quot;</p> <p>For the cli-input-json file use format: &quot;tags&quot;: &quot;key1=value1&amp;key2=value2...&quot;</p> </note></p>
    #[serde(rename = "tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateRoleAliasResponse {
    /// <p>The role alias.</p>
    #[serde(rename = "roleAlias")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub role_alias: Option<String>,
    /// <p>The role alias ARN.</p>
    #[serde(rename = "roleAliasArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub role_alias_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateScheduledAuditRequest {
    /// <p>The day of the month on which the scheduled audit takes place. This can be "1" through "31" or "LAST". This field is required if the "frequency" parameter is set to <code>MONTHLY</code>. If days 29 to 31 are specified, and the month doesn't have that many days, the audit takes place on the <code>LAST</code> day of the month.</p>
    #[serde(rename = "dayOfMonth")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub day_of_month: Option<String>,
    /// <p>The day of the week on which the scheduled audit takes place, either <code>SUN</code>, <code>MON</code>, <code>TUE</code>, <code>WED</code>, <code>THU</code>, <code>FRI</code>, or <code>SAT</code>. This field is required if the <code>frequency</code> parameter is set to <code>WEEKLY</code> or <code>BIWEEKLY</code>.</p>
    #[serde(rename = "dayOfWeek")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub day_of_week: Option<String>,
    /// <p>How often the scheduled audit takes place, either <code>DAILY</code>, <code>WEEKLY</code>, <code>BIWEEKLY</code> or <code>MONTHLY</code>. The start time of each audit is determined by the system.</p>
    #[serde(rename = "frequency")]
    pub frequency: String,
    /// <p>The name you want to give to the scheduled audit. (Max. 128 chars)</p>
    #[serde(rename = "scheduledAuditName")]
    pub scheduled_audit_name: String,
    /// <p>Metadata that can be used to manage the scheduled audit.</p>
    #[serde(rename = "tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
    /// <p>Which checks are performed during the scheduled audit. Checks must be enabled for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)</p>
    #[serde(rename = "targetCheckNames")]
    pub target_check_names: Vec<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateScheduledAuditResponse {
    /// <p>The ARN of the scheduled audit.</p>
    #[serde(rename = "scheduledAuditArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub scheduled_audit_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateSecurityProfileRequest {
    /// <p>A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the profile's <code>behaviors</code>, but it is also retained for any metric specified here. Can be used with custom metrics; cannot be used with dimensions.</p>
    #[serde(rename = "additionalMetricsToRetainV2")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub additional_metrics_to_retain_v2: Option<Vec<MetricToRetain>>,
    /// <p>Specifies the destinations to which alerts are sent. (Alerts are always sent to the console.) Alerts are generated when a device (thing) violates a behavior.</p>
    #[serde(rename = "alertTargets")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub alert_targets: Option<::std::collections::HashMap<String, AlertTarget>>,
    /// <p>Specifies the behaviors that, when violated by a device (thing), cause an alert.</p>
    #[serde(rename = "behaviors")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub behaviors: Option<Vec<Behavior>>,
    /// <p>A description of the security profile.</p>
    #[serde(rename = "securityProfileDescription")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub security_profile_description: Option<String>,
    /// <p>The name you are giving to the security profile.</p>
    #[serde(rename = "securityProfileName")]
    pub security_profile_name: String,
    /// <p>Metadata that can be used to manage the security profile.</p>
    #[serde(rename = "tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateSecurityProfileResponse {
    /// <p>The ARN of the security profile.</p>
    #[serde(rename = "securityProfileArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub security_profile_arn: Option<String>,
    /// <p>The name you gave to the security profile.</p>
    #[serde(rename = "securityProfileName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub security_profile_name: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateStreamRequest {
    /// <p>A description of the stream.</p>
    #[serde(rename = "description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// <p>The files to stream.</p>
    #[serde(rename = "files")]
    pub files: Vec<StreamFile>,
    /// <p>An IAM role that allows the IoT service principal assumes to access your S3 files.</p>
    #[serde(rename = "roleArn")]
    pub role_arn: String,
    /// <p>The stream ID.</p>
    #[serde(rename = "streamId")]
    pub stream_id: String,
    /// <p>Metadata which can be used to manage streams.</p>
    #[serde(rename = "tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateStreamResponse {
    /// <p>A description of the stream.</p>
    #[serde(rename = "description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// <p>The stream ARN.</p>
    #[serde(rename = "streamArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub stream_arn: Option<String>,
    /// <p>The stream ID.</p>
    #[serde(rename = "streamId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub stream_id: Option<String>,
    /// <p>The version of the stream.</p>
    #[serde(rename = "streamVersion")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub stream_version: Option<i64>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateThingGroupRequest {
    /// <p>The name of the parent thing group.</p>
    #[serde(rename = "parentGroupName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub parent_group_name: Option<String>,
    /// <p>Metadata which can be used to manage the thing group.</p>
    #[serde(rename = "tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
    /// <p>The thing group name to create.</p>
    #[serde(rename = "thingGroupName")]
    pub thing_group_name: String,
    /// <p>The thing group properties.</p>
    #[serde(rename = "thingGroupProperties")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_group_properties: Option<ThingGroupProperties>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateThingGroupResponse {
    /// <p>The thing group ARN.</p>
    #[serde(rename = "thingGroupArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_group_arn: Option<String>,
    /// <p>The thing group ID.</p>
    #[serde(rename = "thingGroupId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_group_id: Option<String>,
    /// <p>The thing group name.</p>
    #[serde(rename = "thingGroupName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_group_name: Option<String>,
}

/// <p>The input for the CreateThing operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateThingRequest {
    /// <p>The attribute payload, which consists of up to three name/value pairs in a JSON document. For example:</p> <p> <code>{\"attributes\":{\"string1\":\"string2\"}}</code> </p>
    #[serde(rename = "attributePayload")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub attribute_payload: Option<AttributePayload>,
    /// <p>The name of the billing group the thing will be added to.</p>
    #[serde(rename = "billingGroupName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub billing_group_name: Option<String>,
    /// <p>The name of the thing to create.</p> <p>You can't change a thing's name after you create it. To change a thing's name, you must create a new thing, give it the new name, and then delete the old thing.</p>
    #[serde(rename = "thingName")]
    pub thing_name: String,
    /// <p>The name of the thing type associated with the new thing.</p>
    #[serde(rename = "thingTypeName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_type_name: Option<String>,
}

/// <p>The output of the CreateThing operation.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateThingResponse {
    /// <p>The ARN of the new thing.</p>
    #[serde(rename = "thingArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_arn: Option<String>,
    /// <p>The thing ID.</p>
    #[serde(rename = "thingId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_id: Option<String>,
    /// <p>The name of the new thing.</p>
    #[serde(rename = "thingName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_name: Option<String>,
}

/// <p>The input for the CreateThingType operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateThingTypeRequest {
    /// <p>Metadata which can be used to manage the thing type.</p>
    #[serde(rename = "tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
    /// <p>The name of the thing type.</p>
    #[serde(rename = "thingTypeName")]
    pub thing_type_name: String,
    /// <p>The ThingTypeProperties for the thing type to create. It contains information about the new thing type including a description, and a list of searchable thing attribute names.</p>
    #[serde(rename = "thingTypeProperties")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_type_properties: Option<ThingTypeProperties>,
}

/// <p>The output of the CreateThingType operation.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateThingTypeResponse {
    /// <p>The Amazon Resource Name (ARN) of the thing type.</p>
    #[serde(rename = "thingTypeArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_type_arn: Option<String>,
    /// <p>The thing type ID.</p>
    #[serde(rename = "thingTypeId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_type_id: Option<String>,
    /// <p>The name of the thing type.</p>
    #[serde(rename = "thingTypeName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_type_name: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateTopicRuleDestinationRequest {
    /// <p>The topic rule destination configuration.</p>
    #[serde(rename = "destinationConfiguration")]
    pub destination_configuration: TopicRuleDestinationConfiguration,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateTopicRuleDestinationResponse {
    /// <p>The topic rule destination.</p>
    #[serde(rename = "topicRuleDestination")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub topic_rule_destination: Option<TopicRuleDestination>,
}

/// <p>The input for the CreateTopicRule operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateTopicRuleRequest {
    /// <p>The name of the rule.</p>
    #[serde(rename = "ruleName")]
    pub rule_name: String,
    /// <p><p>Metadata which can be used to manage the topic rule.</p> <note> <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p> <p>For the CLI command-line parameter use format: --tags &quot;key1=value1&amp;key2=value2...&quot;</p> <p>For the cli-input-json file use format: &quot;tags&quot;: &quot;key1=value1&amp;key2=value2...&quot;</p> </note></p>
    #[serde(rename = "tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<String>,
    /// <p>The rule payload.</p>
    #[serde(rename = "topicRulePayload")]
    pub topic_rule_payload: TopicRulePayload,
}

/// <p>Describes a custom method used to code sign a file.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct CustomCodeSigning {
    /// <p>The certificate chain.</p>
    #[serde(rename = "certificateChain")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub certificate_chain: Option<CodeSigningCertificateChain>,
    /// <p>The hash algorithm used to code sign the file.</p>
    #[serde(rename = "hashAlgorithm")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub hash_algorithm: Option<String>,
    /// <p>The signature for the file.</p>
    #[serde(rename = "signature")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub signature: Option<CodeSigningSignature>,
    /// <p>The signature algorithm used to code sign the file.</p>
    #[serde(rename = "signatureAlgorithm")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub signature_algorithm: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteAccountAuditConfigurationRequest {
    /// <p>If true, all scheduled audits are deleted.</p>
    #[serde(rename = "deleteScheduledAudits")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub delete_scheduled_audits: Option<bool>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DeleteAccountAuditConfigurationResponse {}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteAuditSuppressionRequest {
    #[serde(rename = "checkName")]
    pub check_name: String,
    #[serde(rename = "resourceIdentifier")]
    pub resource_identifier: ResourceIdentifier,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DeleteAuditSuppressionResponse {}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteAuthorizerRequest {
    /// <p>The name of the authorizer to delete.</p>
    #[serde(rename = "authorizerName")]
    pub authorizer_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DeleteAuthorizerResponse {}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteBillingGroupRequest {
    /// <p>The name of the billing group.</p>
    #[serde(rename = "billingGroupName")]
    pub billing_group_name: String,
    /// <p>The expected version of the billing group. If the version of the billing group does not match the expected version specified in the request, the <code>DeleteBillingGroup</code> request is rejected with a <code>VersionConflictException</code>.</p>
    #[serde(rename = "expectedVersion")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub expected_version: Option<i64>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DeleteBillingGroupResponse {}

/// <p>Input for the DeleteCACertificate operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteCACertificateRequest {
    /// <p>The ID of the certificate to delete. (The last part of the certificate ARN contains the certificate ID.)</p>
    #[serde(rename = "certificateId")]
    pub certificate_id: String,
}

/// <p>The output for the DeleteCACertificate operation.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DeleteCACertificateResponse {}

/// <p>The input for the DeleteCertificate operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteCertificateRequest {
    /// <p>The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)</p>
    #[serde(rename = "certificateId")]
    pub certificate_id: String,
    /// <p>Forces the deletion of a certificate if it is inactive and is not attached to an IoT thing.</p>
    #[serde(rename = "forceDelete")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub force_delete: Option<bool>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteCustomMetricRequest {
    /// <p> The name of the custom metric. </p>
    #[serde(rename = "metricName")]
    pub metric_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DeleteCustomMetricResponse {}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteDimensionRequest {
    /// <p>The unique identifier for the dimension that you want to delete.</p>
    #[serde(rename = "name")]
    pub name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DeleteDimensionResponse {}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteDomainConfigurationRequest {
    /// <p>The name of the domain configuration to be deleted.</p>
    #[serde(rename = "domainConfigurationName")]
    pub domain_configuration_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DeleteDomainConfigurationResponse {}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteDynamicThingGroupRequest {
    /// <p>The expected version of the dynamic thing group to delete.</p>
    #[serde(rename = "expectedVersion")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub expected_version: Option<i64>,
    /// <p>The name of the dynamic thing group to delete.</p>
    #[serde(rename = "thingGroupName")]
    pub thing_group_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DeleteDynamicThingGroupResponse {}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteJobExecutionRequest {
    /// <p>The ID of the job execution to be deleted. The <code>executionNumber</code> refers to the execution of a particular job on a particular device.</p> <p>Note that once a job execution is deleted, the <code>executionNumber</code> may be reused by IoT, so be sure you get and use the correct value here.</p>
    #[serde(rename = "executionNumber")]
    pub execution_number: i64,
    /// <p><p>(Optional) When true, you can delete a job execution which is &quot;IN<em>PROGRESS&quot;. Otherwise, you can only delete a job execution which is in a terminal state (&quot;SUCCEEDED&quot;, &quot;FAILED&quot;, &quot;REJECTED&quot;, &quot;REMOVED&quot; or &quot;CANCELED&quot;) or an exception will occur. The default is false.</p> <note> <p>Deleting a job execution which is &quot;IN</em>PROGRESS&quot;, will cause the device to be unable to access job information or update the job execution status. Use caution and ensure that the device is able to recover to a valid state.</p> </note></p>
    #[serde(rename = "force")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub force: Option<bool>,
    /// <p>The ID of the job whose execution on a particular device will be deleted.</p>
    #[serde(rename = "jobId")]
    pub job_id: String,
    /// <p><p>The namespace used to indicate that a job is a customer-managed job.</p> <p>When you specify a value for this parameter, AWS IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.</p> <p> <code>$aws/things/<i>THING<em>NAME</i>/jobs/<i>JOB</em>ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code> </p> <note> <p>The <code>namespaceId</code> feature is in public preview.</p> </note></p>
    #[serde(rename = "namespaceId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub namespace_id: Option<String>,
    /// <p>The name of the thing whose job execution will be deleted.</p>
    #[serde(rename = "thingName")]
    pub thing_name: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteJobRequest {
    /// <p><p>(Optional) When true, you can delete a job which is &quot;IN<em>PROGRESS&quot;. Otherwise, you can only delete a job which is in a terminal state (&quot;COMPLETED&quot; or &quot;CANCELED&quot;) or an exception will occur. The default is false.</p> <note> <p>Deleting a job which is &quot;IN</em>PROGRESS&quot;, will cause a device which is executing the job to be unable to access job information or update the job execution status. Use caution and ensure that each device executing a job which is deleted is able to recover to a valid state.</p> </note></p>
    #[serde(rename = "force")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub force: Option<bool>,
    /// <p>The ID of the job to be deleted.</p> <p>After a job deletion is completed, you may reuse this jobId when you create a new job. However, this is not recommended, and you must ensure that your devices are not using the jobId to refer to the deleted job.</p>
    #[serde(rename = "jobId")]
    pub job_id: String,
    /// <p><p>The namespace used to indicate that a job is a customer-managed job.</p> <p>When you specify a value for this parameter, AWS IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.</p> <p> <code>$aws/things/<i>THING<em>NAME</i>/jobs/<i>JOB</em>ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code> </p> <note> <p>The <code>namespaceId</code> feature is in public preview.</p> </note></p>
    #[serde(rename = "namespaceId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub namespace_id: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteJobTemplateRequest {
    /// <p>The unique identifier of the job template to delete.</p>
    #[serde(rename = "jobTemplateId")]
    pub job_template_id: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteMitigationActionRequest {
    /// <p>The name of the mitigation action that you want to delete.</p>
    #[serde(rename = "actionName")]
    pub action_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DeleteMitigationActionResponse {}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteOTAUpdateRequest {
    /// <p>When true, the stream created by the OTAUpdate process is deleted when the OTA update is deleted. Ignored if the stream specified in the OTAUpdate is supplied by the user.</p>
    #[serde(rename = "deleteStream")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub delete_stream: Option<bool>,
    /// <p>When true, deletes the AWS job created by the OTAUpdate process even if it is "IN_PROGRESS". Otherwise, if the job is not in a terminal state ("COMPLETED" or "CANCELED") an exception will occur. The default is false.</p>
    #[serde(rename = "forceDeleteAWSJob")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub force_delete_aws_job: Option<bool>,
    /// <p>The ID of the OTA update to delete.</p>
    #[serde(rename = "otaUpdateId")]
    pub ota_update_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DeleteOTAUpdateResponse {}

/// <p>The input for the DeletePolicy operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeletePolicyRequest {
    /// <p>The name of the policy to delete.</p>
    #[serde(rename = "policyName")]
    pub policy_name: String,
}

/// <p>The input for the DeletePolicyVersion operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeletePolicyVersionRequest {
    /// <p>The name of the policy.</p>
    #[serde(rename = "policyName")]
    pub policy_name: String,
    /// <p>The policy version ID.</p>
    #[serde(rename = "policyVersionId")]
    pub policy_version_id: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteProvisioningTemplateRequest {
    /// <p>The name of the fleet provision template to delete.</p>
    #[serde(rename = "templateName")]
    pub template_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DeleteProvisioningTemplateResponse {}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteProvisioningTemplateVersionRequest {
    /// <p>The name of the fleet provisioning template version to delete.</p>
    #[serde(rename = "templateName")]
    pub template_name: String,
    /// <p>The fleet provisioning template version ID to delete.</p>
    #[serde(rename = "versionId")]
    pub version_id: i64,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DeleteProvisioningTemplateVersionResponse {}

/// <p>The input for the DeleteRegistrationCode operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteRegistrationCodeRequest {}

/// <p>The output for the DeleteRegistrationCode operation.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DeleteRegistrationCodeResponse {}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteRoleAliasRequest {
    /// <p>The role alias to delete.</p>
    #[serde(rename = "roleAlias")]
    pub role_alias: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DeleteRoleAliasResponse {}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteScheduledAuditRequest {
    /// <p>The name of the scheduled audit you want to delete.</p>
    #[serde(rename = "scheduledAuditName")]
    pub scheduled_audit_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DeleteScheduledAuditResponse {}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteSecurityProfileRequest {
    /// <p>The expected version of the security profile. A new version is generated whenever the security profile is updated. If you specify a value that is different from the actual version, a <code>VersionConflictException</code> is thrown.</p>
    #[serde(rename = "expectedVersion")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub expected_version: Option<i64>,
    /// <p>The name of the security profile to be deleted.</p>
    #[serde(rename = "securityProfileName")]
    pub security_profile_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DeleteSecurityProfileResponse {}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteStreamRequest {
    /// <p>The stream ID.</p>
    #[serde(rename = "streamId")]
    pub stream_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DeleteStreamResponse {}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteThingGroupRequest {
    /// <p>The expected version of the thing group to delete.</p>
    #[serde(rename = "expectedVersion")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub expected_version: Option<i64>,
    /// <p>The name of the thing group to delete.</p>
    #[serde(rename = "thingGroupName")]
    pub thing_group_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DeleteThingGroupResponse {}

/// <p>The input for the DeleteThing operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteThingRequest {
    /// <p>The expected version of the thing record in the registry. If the version of the record in the registry does not match the expected version specified in the request, the <code>DeleteThing</code> request is rejected with a <code>VersionConflictException</code>.</p>
    #[serde(rename = "expectedVersion")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub expected_version: Option<i64>,
    /// <p>The name of the thing to delete.</p>
    #[serde(rename = "thingName")]
    pub thing_name: String,
}

/// <p>The output of the DeleteThing operation.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DeleteThingResponse {}

/// <p>The input for the DeleteThingType operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteThingTypeRequest {
    /// <p>The name of the thing type.</p>
    #[serde(rename = "thingTypeName")]
    pub thing_type_name: String,
}

/// <p>The output for the DeleteThingType operation.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DeleteThingTypeResponse {}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteTopicRuleDestinationRequest {
    /// <p>The ARN of the topic rule destination to delete.</p>
    #[serde(rename = "arn")]
    pub arn: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DeleteTopicRuleDestinationResponse {}

/// <p>The input for the DeleteTopicRule operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteTopicRuleRequest {
    /// <p>The name of the rule.</p>
    #[serde(rename = "ruleName")]
    pub rule_name: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteV2LoggingLevelRequest {
    /// <p>The name of the resource for which you are configuring logging.</p>
    #[serde(rename = "targetName")]
    pub target_name: String,
    /// <p>The type of resource for which you are configuring logging. Must be <code>THING_Group</code>.</p>
    #[serde(rename = "targetType")]
    pub target_type: String,
}

/// <p>Contains information that denied the authorization.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct Denied {
    /// <p>Information that explicitly denies the authorization. </p>
    #[serde(rename = "explicitDeny")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub explicit_deny: Option<ExplicitDeny>,
    /// <p>Information that implicitly denies the authorization. When a policy doesn't explicitly deny or allow an action on a resource it is considered an implicit deny.</p>
    #[serde(rename = "implicitDeny")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub implicit_deny: Option<ImplicitDeny>,
}

/// <p>The input for the DeprecateThingType operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeprecateThingTypeRequest {
    /// <p>The name of the thing type to deprecate.</p>
    #[serde(rename = "thingTypeName")]
    pub thing_type_name: String,
    /// <p>Whether to undeprecate a deprecated thing type. If <b>true</b>, the thing type will not be deprecated anymore and you can associate it with things.</p>
    #[serde(rename = "undoDeprecate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub undo_deprecate: Option<bool>,
}

/// <p>The output for the DeprecateThingType operation.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DeprecateThingTypeResponse {}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeAccountAuditConfigurationRequest {}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeAccountAuditConfigurationResponse {
    /// <p>Which audit checks are enabled and disabled for this account.</p>
    #[serde(rename = "auditCheckConfigurations")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub audit_check_configurations:
        Option<::std::collections::HashMap<String, AuditCheckConfiguration>>,
    /// <p>Information about the targets to which audit notifications are sent for this account.</p>
    #[serde(rename = "auditNotificationTargetConfigurations")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub audit_notification_target_configurations:
        Option<::std::collections::HashMap<String, AuditNotificationTarget>>,
    /// <p>The ARN of the role that grants permission to AWS IoT to access information about your devices, policies, certificates, and other items as required when performing an audit.</p> <p>On the first call to <code>UpdateAccountAuditConfiguration</code>, this parameter is required.</p>
    #[serde(rename = "roleArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub role_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeAuditFindingRequest {
    /// <p>A unique identifier for a single audit finding. You can use this identifier to apply mitigation actions to the finding.</p>
    #[serde(rename = "findingId")]
    pub finding_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeAuditFindingResponse {
    #[serde(rename = "finding")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub finding: Option<AuditFinding>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeAuditMitigationActionsTaskRequest {
    /// <p>The unique identifier for the audit mitigation task.</p>
    #[serde(rename = "taskId")]
    pub task_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeAuditMitigationActionsTaskResponse {
    /// <p>Specifies the mitigation actions and their parameters that are applied as part of this task.</p>
    #[serde(rename = "actionsDefinition")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub actions_definition: Option<Vec<MitigationAction>>,
    /// <p>Specifies the mitigation actions that should be applied to specific audit checks.</p>
    #[serde(rename = "auditCheckToActionsMapping")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub audit_check_to_actions_mapping: Option<::std::collections::HashMap<String, Vec<String>>>,
    /// <p>The date and time when the task was completed or canceled.</p>
    #[serde(rename = "endTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub end_time: Option<f64>,
    /// <p>The date and time when the task was started.</p>
    #[serde(rename = "startTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub start_time: Option<f64>,
    /// <p>Identifies the findings to which the mitigation actions are applied. This can be by audit checks, by audit task, or a set of findings.</p>
    #[serde(rename = "target")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub target: Option<AuditMitigationActionsTaskTarget>,
    /// <p>Aggregate counts of the results when the mitigation tasks were applied to the findings for this audit mitigation actions task.</p>
    #[serde(rename = "taskStatistics")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub task_statistics: Option<::std::collections::HashMap<String, TaskStatisticsForAuditCheck>>,
    /// <p>The current status of the task.</p>
    #[serde(rename = "taskStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub task_status: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeAuditSuppressionRequest {
    #[serde(rename = "checkName")]
    pub check_name: String,
    #[serde(rename = "resourceIdentifier")]
    pub resource_identifier: ResourceIdentifier,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeAuditSuppressionResponse {
    #[serde(rename = "checkName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub check_name: Option<String>,
    /// <p> The description of the audit suppression. </p>
    #[serde(rename = "description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// <p> The epoch timestamp in seconds at which this suppression expires. </p>
    #[serde(rename = "expirationDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub expiration_date: Option<f64>,
    #[serde(rename = "resourceIdentifier")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub resource_identifier: Option<ResourceIdentifier>,
    /// <p> Indicates whether a suppression should exist indefinitely or not. </p>
    #[serde(rename = "suppressIndefinitely")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub suppress_indefinitely: Option<bool>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeAuditTaskRequest {
    /// <p>The ID of the audit whose information you want to get.</p>
    #[serde(rename = "taskId")]
    pub task_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeAuditTaskResponse {
    /// <p>Detailed information about each check performed during this audit.</p>
    #[serde(rename = "auditDetails")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub audit_details: Option<::std::collections::HashMap<String, AuditCheckDetails>>,
    /// <p>The name of the scheduled audit (only if the audit was a scheduled audit).</p>
    #[serde(rename = "scheduledAuditName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub scheduled_audit_name: Option<String>,
    /// <p>The time the audit started.</p>
    #[serde(rename = "taskStartTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub task_start_time: Option<f64>,
    /// <p>Statistical information about the audit.</p>
    #[serde(rename = "taskStatistics")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub task_statistics: Option<TaskStatistics>,
    /// <p>The status of the audit: one of "IN_PROGRESS", "COMPLETED", "FAILED", or "CANCELED".</p>
    #[serde(rename = "taskStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub task_status: Option<String>,
    /// <p>The type of audit: "ON_DEMAND_AUDIT_TASK" or "SCHEDULED_AUDIT_TASK".</p>
    #[serde(rename = "taskType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub task_type: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeAuthorizerRequest {
    /// <p>The name of the authorizer to describe.</p>
    #[serde(rename = "authorizerName")]
    pub authorizer_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeAuthorizerResponse {
    /// <p>The authorizer description.</p>
    #[serde(rename = "authorizerDescription")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub authorizer_description: Option<AuthorizerDescription>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeBillingGroupRequest {
    /// <p>The name of the billing group.</p>
    #[serde(rename = "billingGroupName")]
    pub billing_group_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeBillingGroupResponse {
    /// <p>The ARN of the billing group.</p>
    #[serde(rename = "billingGroupArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub billing_group_arn: Option<String>,
    /// <p>The ID of the billing group.</p>
    #[serde(rename = "billingGroupId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub billing_group_id: Option<String>,
    /// <p>Additional information about the billing group.</p>
    #[serde(rename = "billingGroupMetadata")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub billing_group_metadata: Option<BillingGroupMetadata>,
    /// <p>The name of the billing group.</p>
    #[serde(rename = "billingGroupName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub billing_group_name: Option<String>,
    /// <p>The properties of the billing group.</p>
    #[serde(rename = "billingGroupProperties")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub billing_group_properties: Option<BillingGroupProperties>,
    /// <p>The version of the billing group.</p>
    #[serde(rename = "version")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub version: Option<i64>,
}

/// <p>The input for the DescribeCACertificate operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeCACertificateRequest {
    /// <p>The CA certificate identifier.</p>
    #[serde(rename = "certificateId")]
    pub certificate_id: String,
}

/// <p>The output from the DescribeCACertificate operation.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeCACertificateResponse {
    /// <p>The CA certificate description.</p>
    #[serde(rename = "certificateDescription")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub certificate_description: Option<CACertificateDescription>,
    /// <p>Information about the registration configuration.</p>
    #[serde(rename = "registrationConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub registration_config: Option<RegistrationConfig>,
}

/// <p>The input for the DescribeCertificate operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeCertificateRequest {
    /// <p>The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)</p>
    #[serde(rename = "certificateId")]
    pub certificate_id: String,
}

/// <p>The output of the DescribeCertificate operation.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeCertificateResponse {
    /// <p>The description of the certificate.</p>
    #[serde(rename = "certificateDescription")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub certificate_description: Option<CertificateDescription>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeCustomMetricRequest {
    /// <p> The name of the custom metric. </p>
    #[serde(rename = "metricName")]
    pub metric_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeCustomMetricResponse {
    /// <p> The creation date of the custom metric in milliseconds since epoch. </p>
    #[serde(rename = "creationDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_date: Option<f64>,
    /// <p> Field represents a friendly name in the console for the custom metric; doesn't have to be unique. Don't use this name as the metric identifier in the device metric report. Can be updated. </p>
    #[serde(rename = "displayName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    /// <p> The time the custom metric was last modified in milliseconds since epoch. </p>
    #[serde(rename = "lastModifiedDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_date: Option<f64>,
    /// <p> The Amazon Resource Number (ARN) of the custom metric. </p>
    #[serde(rename = "metricArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metric_arn: Option<String>,
    /// <p> The name of the custom metric. </p>
    #[serde(rename = "metricName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metric_name: Option<String>,
    /// <p> The type of the custom metric. Types include <code>string-list</code>, <code>ip-address-list</code>, <code>number-list</code>, and <code>number</code>. </p>
    #[serde(rename = "metricType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metric_type: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeDefaultAuthorizerRequest {}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeDefaultAuthorizerResponse {
    /// <p>The default authorizer's description.</p>
    #[serde(rename = "authorizerDescription")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub authorizer_description: Option<AuthorizerDescription>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeDetectMitigationActionsTaskRequest {
    /// <p> The unique identifier of the task. </p>
    #[serde(rename = "taskId")]
    pub task_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeDetectMitigationActionsTaskResponse {
    /// <p> The description of a task. </p>
    #[serde(rename = "taskSummary")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub task_summary: Option<DetectMitigationActionsTaskSummary>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeDimensionRequest {
    /// <p>The unique identifier for the dimension.</p>
    #[serde(rename = "name")]
    pub name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeDimensionResponse {
    /// <p>The Amazon Resource Name (ARN) for the dimension.</p>
    #[serde(rename = "arn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub arn: Option<String>,
    /// <p>The date the dimension was created.</p>
    #[serde(rename = "creationDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_date: Option<f64>,
    /// <p>The date the dimension was last modified.</p>
    #[serde(rename = "lastModifiedDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_date: Option<f64>,
    /// <p>The unique identifier for the dimension.</p>
    #[serde(rename = "name")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    /// <p>The value or list of values used to scope the dimension. For example, for topic filters, this is the pattern used to match the MQTT topic name.</p>
    #[serde(rename = "stringValues")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub string_values: Option<Vec<String>>,
    /// <p>The type of the dimension.</p>
    #[serde(rename = "type")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeDomainConfigurationRequest {
    /// <p>The name of the domain configuration.</p>
    #[serde(rename = "domainConfigurationName")]
    pub domain_configuration_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeDomainConfigurationResponse {
    /// <p>An object that specifies the authorization service for a domain.</p>
    #[serde(rename = "authorizerConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub authorizer_config: Option<AuthorizerConfig>,
    /// <p>The ARN of the domain configuration.</p>
    #[serde(rename = "domainConfigurationArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub domain_configuration_arn: Option<String>,
    /// <p>The name of the domain configuration.</p>
    #[serde(rename = "domainConfigurationName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub domain_configuration_name: Option<String>,
    /// <p>A Boolean value that specifies the current state of the domain configuration.</p>
    #[serde(rename = "domainConfigurationStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub domain_configuration_status: Option<String>,
    /// <p>The name of the domain.</p>
    #[serde(rename = "domainName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub domain_name: Option<String>,
    /// <p>The type of the domain.</p>
    #[serde(rename = "domainType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub domain_type: Option<String>,
    /// <p>The date and time the domain configuration's status was last changed.</p>
    #[serde(rename = "lastStatusChangeDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_status_change_date: Option<f64>,
    /// <p>A list containing summary information about the server certificate included in the domain configuration.</p>
    #[serde(rename = "serverCertificates")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub server_certificates: Option<Vec<ServerCertificateSummary>>,
    /// <p>The type of service delivered by the endpoint.</p>
    #[serde(rename = "serviceType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub service_type: Option<String>,
}

/// <p>The input for the DescribeEndpoint operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeEndpointRequest {
    /// <p>The endpoint type. Valid endpoint types include:</p> <ul> <li> <p> <code>iot:Data</code> - Returns a VeriSign signed data endpoint.</p> </li> </ul> <ul> <li> <p> <code>iot:Data-ATS</code> - Returns an ATS signed data endpoint.</p> </li> </ul> <ul> <li> <p> <code>iot:CredentialProvider</code> - Returns an AWS IoT credentials provider API endpoint.</p> </li> </ul> <ul> <li> <p> <code>iot:Jobs</code> - Returns an AWS IoT device management Jobs API endpoint.</p> </li> </ul> <p>We strongly recommend that customers use the newer <code>iot:Data-ATS</code> endpoint type to avoid issues related to the widespread distrust of Symantec certificate authorities.</p>
    #[serde(rename = "endpointType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub endpoint_type: Option<String>,
}

/// <p>The output from the DescribeEndpoint operation.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeEndpointResponse {
    /// <p>The endpoint. The format of the endpoint is as follows: <i>identifier</i>.iot.<i>region</i>.amazonaws.com.</p>
    #[serde(rename = "endpointAddress")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub endpoint_address: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeEventConfigurationsRequest {}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeEventConfigurationsResponse {
    /// <p>The creation date of the event configuration.</p>
    #[serde(rename = "creationDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_date: Option<f64>,
    /// <p>The event configurations.</p>
    #[serde(rename = "eventConfigurations")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub event_configurations: Option<::std::collections::HashMap<String, Configuration>>,
    /// <p>The date the event configurations were last modified.</p>
    #[serde(rename = "lastModifiedDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_date: Option<f64>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeIndexRequest {
    /// <p>The index name.</p>
    #[serde(rename = "indexName")]
    pub index_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeIndexResponse {
    /// <p>The index name.</p>
    #[serde(rename = "indexName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub index_name: Option<String>,
    /// <p>The index status.</p>
    #[serde(rename = "indexStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub index_status: Option<String>,
    /// <p><p>Contains a value that specifies the type of indexing performed. Valid values are:</p> <ul> <li> <p>REGISTRY – Your thing index contains only registry data.</p> </li> <li> <p>REGISTRY<em>AND</em>SHADOW - Your thing index contains registry data and shadow data.</p> </li> <li> <p>REGISTRY<em>AND</em>CONNECTIVITY<em>STATUS - Your thing index contains registry data and thing connectivity status data.</p> </li> <li> <p>REGISTRY</em>AND<em>SHADOW</em>AND<em>CONNECTIVITY</em>STATUS - Your thing index contains registry data, shadow data, and thing connectivity status data.</p> </li> </ul></p>
    #[serde(rename = "schema")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub schema: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeJobExecutionRequest {
    /// <p>A string (consisting of the digits "0" through "9" which is used to specify a particular job execution on a particular device.</p>
    #[serde(rename = "executionNumber")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub execution_number: Option<i64>,
    /// <p>The unique identifier you assigned to this job when it was created.</p>
    #[serde(rename = "jobId")]
    pub job_id: String,
    /// <p>The name of the thing on which the job execution is running.</p>
    #[serde(rename = "thingName")]
    pub thing_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeJobExecutionResponse {
    /// <p>Information about the job execution.</p>
    #[serde(rename = "execution")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub execution: Option<JobExecution>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeJobRequest {
    /// <p>The unique identifier you assigned to this job when it was created.</p>
    #[serde(rename = "jobId")]
    pub job_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeJobResponse {
    /// <p>An S3 link to the job document.</p>
    #[serde(rename = "documentSource")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub document_source: Option<String>,
    /// <p>Information about the job.</p>
    #[serde(rename = "job")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub job: Option<Job>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeJobTemplateRequest {
    /// <p>The unique identifier of the job template.</p>
    #[serde(rename = "jobTemplateId")]
    pub job_template_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeJobTemplateResponse {
    #[serde(rename = "abortConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub abort_config: Option<AbortConfig>,
    /// <p>The time, in seconds since the epoch, when the job template was created.</p>
    #[serde(rename = "createdAt")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_at: Option<f64>,
    /// <p>A description of the job template.</p>
    #[serde(rename = "description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// <p>The job document.</p>
    #[serde(rename = "document")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub document: Option<String>,
    /// <p>An S3 link to the job document.</p>
    #[serde(rename = "documentSource")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub document_source: Option<String>,
    #[serde(rename = "jobExecutionsRolloutConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub job_executions_rollout_config: Option<JobExecutionsRolloutConfig>,
    /// <p>The ARN of the job template.</p>
    #[serde(rename = "jobTemplateArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub job_template_arn: Option<String>,
    /// <p>The unique identifier of the job template.</p>
    #[serde(rename = "jobTemplateId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub job_template_id: Option<String>,
    #[serde(rename = "presignedUrlConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub presigned_url_config: Option<PresignedUrlConfig>,
    #[serde(rename = "timeoutConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub timeout_config: Option<TimeoutConfig>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeMitigationActionRequest {
    /// <p>The friendly name that uniquely identifies the mitigation action.</p>
    #[serde(rename = "actionName")]
    pub action_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeMitigationActionResponse {
    /// <p>The ARN that identifies this migration action.</p>
    #[serde(rename = "actionArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub action_arn: Option<String>,
    /// <p>A unique identifier for this action.</p>
    #[serde(rename = "actionId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub action_id: Option<String>,
    /// <p>The friendly name that uniquely identifies the mitigation action.</p>
    #[serde(rename = "actionName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub action_name: Option<String>,
    /// <p>Parameters that control how the mitigation action is applied, specific to the type of mitigation action.</p>
    #[serde(rename = "actionParams")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub action_params: Option<MitigationActionParams>,
    /// <p>The type of mitigation action.</p>
    #[serde(rename = "actionType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub action_type: Option<String>,
    /// <p>The date and time when the mitigation action was added to your AWS account.</p>
    #[serde(rename = "creationDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_date: Option<f64>,
    /// <p>The date and time when the mitigation action was last changed.</p>
    #[serde(rename = "lastModifiedDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_date: Option<f64>,
    /// <p>The ARN of the IAM role used to apply this action.</p>
    #[serde(rename = "roleArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub role_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeProvisioningTemplateRequest {
    /// <p>The name of the fleet provisioning template.</p>
    #[serde(rename = "templateName")]
    pub template_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeProvisioningTemplateResponse {
    /// <p>The date when the fleet provisioning template was created.</p>
    #[serde(rename = "creationDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_date: Option<f64>,
    /// <p>The default fleet template version ID.</p>
    #[serde(rename = "defaultVersionId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub default_version_id: Option<i64>,
    /// <p>The description of the fleet provisioning template.</p>
    #[serde(rename = "description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// <p>True if the fleet provisioning template is enabled, otherwise false.</p>
    #[serde(rename = "enabled")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
    /// <p>The date when the fleet provisioning template was last modified.</p>
    #[serde(rename = "lastModifiedDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_date: Option<f64>,
    /// <p>Gets information about a pre-provisioned hook.</p>
    #[serde(rename = "preProvisioningHook")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pre_provisioning_hook: Option<ProvisioningHook>,
    /// <p>The ARN of the role associated with the provisioning template. This IoT role grants permission to provision a device.</p>
    #[serde(rename = "provisioningRoleArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub provisioning_role_arn: Option<String>,
    /// <p>The ARN of the fleet provisioning template.</p>
    #[serde(rename = "templateArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub template_arn: Option<String>,
    /// <p>The JSON formatted contents of the fleet provisioning template.</p>
    #[serde(rename = "templateBody")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub template_body: Option<String>,
    /// <p>The name of the fleet provisioning template.</p>
    #[serde(rename = "templateName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub template_name: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeProvisioningTemplateVersionRequest {
    /// <p>The template name.</p>
    #[serde(rename = "templateName")]
    pub template_name: String,
    /// <p>The fleet provisioning template version ID.</p>
    #[serde(rename = "versionId")]
    pub version_id: i64,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeProvisioningTemplateVersionResponse {
    /// <p>The date when the fleet provisioning template version was created.</p>
    #[serde(rename = "creationDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_date: Option<f64>,
    /// <p>True if the fleet provisioning template version is the default version.</p>
    #[serde(rename = "isDefaultVersion")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub is_default_version: Option<bool>,
    /// <p>The JSON formatted contents of the fleet provisioning template version.</p>
    #[serde(rename = "templateBody")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub template_body: Option<String>,
    /// <p>The fleet provisioning template version ID.</p>
    #[serde(rename = "versionId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub version_id: Option<i64>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeRoleAliasRequest {
    /// <p>The role alias to describe.</p>
    #[serde(rename = "roleAlias")]
    pub role_alias: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeRoleAliasResponse {
    /// <p>The role alias description.</p>
    #[serde(rename = "roleAliasDescription")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub role_alias_description: Option<RoleAliasDescription>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeScheduledAuditRequest {
    /// <p>The name of the scheduled audit whose information you want to get.</p>
    #[serde(rename = "scheduledAuditName")]
    pub scheduled_audit_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeScheduledAuditResponse {
    /// <p>The day of the month on which the scheduled audit takes place. This is will be <code>1</code> through <code>31</code> or <code>LAST</code>. If days <code>29</code>-<code>31</code> are specified, and the month does not have that many days, the audit takes place on the <code>LAST</code> day of the month.</p>
    #[serde(rename = "dayOfMonth")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub day_of_month: Option<String>,
    /// <p>The day of the week on which the scheduled audit takes place, either one of <code>SUN</code>, <code>MON</code>, <code>TUE</code>, <code>WED</code>, <code>THU</code>, <code>FRI</code>, or <code>SAT</code>.</p>
    #[serde(rename = "dayOfWeek")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub day_of_week: Option<String>,
    /// <p>How often the scheduled audit takes place, either one of <code>DAILY</code>, <code>WEEKLY</code>, <code>BIWEEKLY</code>, or <code>MONTHLY</code>. The start time of each audit is determined by the system.</p>
    #[serde(rename = "frequency")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub frequency: Option<String>,
    /// <p>The ARN of the scheduled audit.</p>
    #[serde(rename = "scheduledAuditArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub scheduled_audit_arn: Option<String>,
    /// <p>The name of the scheduled audit.</p>
    #[serde(rename = "scheduledAuditName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub scheduled_audit_name: Option<String>,
    /// <p>Which checks are performed during the scheduled audit. Checks must be enabled for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)</p>
    #[serde(rename = "targetCheckNames")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub target_check_names: Option<Vec<String>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeSecurityProfileRequest {
    /// <p>The name of the security profile whose information you want to get.</p>
    #[serde(rename = "securityProfileName")]
    pub security_profile_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeSecurityProfileResponse {
    /// <p>A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the profile's behaviors, but it is also retained for any metric specified here.</p>
    #[serde(rename = "additionalMetricsToRetainV2")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub additional_metrics_to_retain_v2: Option<Vec<MetricToRetain>>,
    /// <p>Where the alerts are sent. (Alerts are always sent to the console.)</p>
    #[serde(rename = "alertTargets")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub alert_targets: Option<::std::collections::HashMap<String, AlertTarget>>,
    /// <p>Specifies the behaviors that, when violated by a device (thing), cause an alert.</p>
    #[serde(rename = "behaviors")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub behaviors: Option<Vec<Behavior>>,
    /// <p>The time the security profile was created.</p>
    #[serde(rename = "creationDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_date: Option<f64>,
    /// <p>The time the security profile was last modified.</p>
    #[serde(rename = "lastModifiedDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_date: Option<f64>,
    /// <p>The ARN of the security profile.</p>
    #[serde(rename = "securityProfileArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub security_profile_arn: Option<String>,
    /// <p>A description of the security profile (associated with the security profile when it was created or updated).</p>
    #[serde(rename = "securityProfileDescription")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub security_profile_description: Option<String>,
    /// <p>The name of the security profile.</p>
    #[serde(rename = "securityProfileName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub security_profile_name: Option<String>,
    /// <p>The version of the security profile. A new version is generated whenever the security profile is updated.</p>
    #[serde(rename = "version")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub version: Option<i64>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeStreamRequest {
    /// <p>The stream ID.</p>
    #[serde(rename = "streamId")]
    pub stream_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeStreamResponse {
    /// <p>Information about the stream.</p>
    #[serde(rename = "streamInfo")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub stream_info: Option<StreamInfo>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeThingGroupRequest {
    /// <p>The name of the thing group.</p>
    #[serde(rename = "thingGroupName")]
    pub thing_group_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeThingGroupResponse {
    /// <p>The dynamic thing group index name.</p>
    #[serde(rename = "indexName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub index_name: Option<String>,
    /// <p>The dynamic thing group search query string.</p>
    #[serde(rename = "queryString")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub query_string: Option<String>,
    /// <p>The dynamic thing group query version.</p>
    #[serde(rename = "queryVersion")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub query_version: Option<String>,
    /// <p>The dynamic thing group status.</p>
    #[serde(rename = "status")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    /// <p>The thing group ARN.</p>
    #[serde(rename = "thingGroupArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_group_arn: Option<String>,
    /// <p>The thing group ID.</p>
    #[serde(rename = "thingGroupId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_group_id: Option<String>,
    /// <p>Thing group metadata.</p>
    #[serde(rename = "thingGroupMetadata")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_group_metadata: Option<ThingGroupMetadata>,
    /// <p>The name of the thing group.</p>
    #[serde(rename = "thingGroupName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_group_name: Option<String>,
    /// <p>The thing group properties.</p>
    #[serde(rename = "thingGroupProperties")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_group_properties: Option<ThingGroupProperties>,
    /// <p>The version of the thing group.</p>
    #[serde(rename = "version")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub version: Option<i64>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeThingRegistrationTaskRequest {
    /// <p>The task ID.</p>
    #[serde(rename = "taskId")]
    pub task_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeThingRegistrationTaskResponse {
    /// <p>The task creation date.</p>
    #[serde(rename = "creationDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_date: Option<f64>,
    /// <p>The number of things that failed to be provisioned.</p>
    #[serde(rename = "failureCount")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub failure_count: Option<i64>,
    /// <p>The S3 bucket that contains the input file.</p>
    #[serde(rename = "inputFileBucket")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub input_file_bucket: Option<String>,
    /// <p>The input file key.</p>
    #[serde(rename = "inputFileKey")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub input_file_key: Option<String>,
    /// <p>The date when the task was last modified.</p>
    #[serde(rename = "lastModifiedDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_date: Option<f64>,
    /// <p>The message.</p>
    #[serde(rename = "message")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    /// <p>The progress of the bulk provisioning task expressed as a percentage.</p>
    #[serde(rename = "percentageProgress")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub percentage_progress: Option<i64>,
    /// <p>The role ARN that grants access to the input file bucket.</p>
    #[serde(rename = "roleArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub role_arn: Option<String>,
    /// <p>The status of the bulk thing provisioning task.</p>
    #[serde(rename = "status")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    /// <p>The number of things successfully provisioned.</p>
    #[serde(rename = "successCount")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub success_count: Option<i64>,
    /// <p>The task ID.</p>
    #[serde(rename = "taskId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub task_id: Option<String>,
    /// <p>The task's template.</p>
    #[serde(rename = "templateBody")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub template_body: Option<String>,
}

/// <p>The input for the DescribeThing operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeThingRequest {
    /// <p>The name of the thing.</p>
    #[serde(rename = "thingName")]
    pub thing_name: String,
}

/// <p>The output from the DescribeThing operation.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeThingResponse {
    /// <p>The thing attributes.</p>
    #[serde(rename = "attributes")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub attributes: Option<::std::collections::HashMap<String, String>>,
    /// <p>The name of the billing group the thing belongs to.</p>
    #[serde(rename = "billingGroupName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub billing_group_name: Option<String>,
    /// <p>The default MQTT client ID. For a typical device, the thing name is also used as the default MQTT client ID. Although we don’t require a mapping between a thing's registry name and its use of MQTT client IDs, certificates, or shadow state, we recommend that you choose a thing name and use it as the MQTT client ID for the registry and the Device Shadow service.</p> <p>This lets you better organize your AWS IoT fleet without removing the flexibility of the underlying device certificate model or shadows.</p>
    #[serde(rename = "defaultClientId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub default_client_id: Option<String>,
    /// <p>The ARN of the thing to describe.</p>
    #[serde(rename = "thingArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_arn: Option<String>,
    /// <p>The ID of the thing to describe.</p>
    #[serde(rename = "thingId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_id: Option<String>,
    /// <p>The name of the thing.</p>
    #[serde(rename = "thingName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_name: Option<String>,
    /// <p>The thing type name.</p>
    #[serde(rename = "thingTypeName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_type_name: Option<String>,
    /// <p><p>The current version of the thing record in the registry.</p> <note> <p>To avoid unintentional changes to the information in the registry, you can pass the version information in the <code>expectedVersion</code> parameter of the <code>UpdateThing</code> and <code>DeleteThing</code> calls.</p> </note></p>
    #[serde(rename = "version")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub version: Option<i64>,
}

/// <p>The input for the DescribeThingType operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeThingTypeRequest {
    /// <p>The name of the thing type.</p>
    #[serde(rename = "thingTypeName")]
    pub thing_type_name: String,
}

/// <p>The output for the DescribeThingType operation.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeThingTypeResponse {
    /// <p>The thing type ARN.</p>
    #[serde(rename = "thingTypeArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_type_arn: Option<String>,
    /// <p>The thing type ID.</p>
    #[serde(rename = "thingTypeId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_type_id: Option<String>,
    /// <p>The ThingTypeMetadata contains additional information about the thing type including: creation date and time, a value indicating whether the thing type is deprecated, and a date and time when it was deprecated.</p>
    #[serde(rename = "thingTypeMetadata")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_type_metadata: Option<ThingTypeMetadata>,
    /// <p>The name of the thing type.</p>
    #[serde(rename = "thingTypeName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_type_name: Option<String>,
    /// <p>The ThingTypeProperties contains information about the thing type including description, and a list of searchable thing attribute names.</p>
    #[serde(rename = "thingTypeProperties")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_type_properties: Option<ThingTypeProperties>,
}

/// <p>Describes the location of the updated firmware.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct Destination {
    /// <p>Describes the location in S3 of the updated firmware.</p>
    #[serde(rename = "s3Destination")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub s_3_destination: Option<S3Destination>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DetachPolicyRequest {
    /// <p>The policy to detach.</p>
    #[serde(rename = "policyName")]
    pub policy_name: String,
    /// <p>The target from which the policy will be detached.</p>
    #[serde(rename = "target")]
    pub target: String,
}

/// <p>The input for the DetachPrincipalPolicy operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DetachPrincipalPolicyRequest {
    /// <p>The name of the policy to detach.</p>
    #[serde(rename = "policyName")]
    pub policy_name: String,
    /// <p>The principal.</p> <p>Valid principals are CertificateArn (arn:aws:iot:<i>region</i>:<i>accountId</i>:cert/<i>certificateId</i>), thingGroupArn (arn:aws:iot:<i>region</i>:<i>accountId</i>:thinggroup/<i>groupName</i>) and CognitoId (<i>region</i>:<i>id</i>).</p>
    #[serde(rename = "principal")]
    pub principal: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DetachSecurityProfileRequest {
    /// <p>The security profile that is detached.</p>
    #[serde(rename = "securityProfileName")]
    pub security_profile_name: String,
    /// <p>The ARN of the thing group from which the security profile is detached.</p>
    #[serde(rename = "securityProfileTargetArn")]
    pub security_profile_target_arn: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DetachSecurityProfileResponse {}

/// <p>The input for the DetachThingPrincipal operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DetachThingPrincipalRequest {
    /// <p>If the principal is a certificate, this value must be ARN of the certificate. If the principal is an Amazon Cognito identity, this value must be the ID of the Amazon Cognito identity.</p>
    #[serde(rename = "principal")]
    pub principal: String,
    /// <p>The name of the thing.</p>
    #[serde(rename = "thingName")]
    pub thing_name: String,
}

/// <p>The output from the DetachThingPrincipal operation.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DetachThingPrincipalResponse {}

/// <p> Describes which mitigation actions should be executed. </p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DetectMitigationActionExecution {
    /// <p> The friendly name that uniquely identifies the mitigation action. </p>
    #[serde(rename = "actionName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub action_name: Option<String>,
    /// <p> The error code of a mitigation action. </p>
    #[serde(rename = "errorCode")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub error_code: Option<String>,
    /// <p> The date a mitigation action ended. </p>
    #[serde(rename = "executionEndDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub execution_end_date: Option<f64>,
    /// <p> The date a mitigation action was started. </p>
    #[serde(rename = "executionStartDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub execution_start_date: Option<f64>,
    /// <p> The message of a mitigation action. </p>
    #[serde(rename = "message")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    /// <p> The status of a mitigation action. </p>
    #[serde(rename = "status")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    /// <p> The unique identifier of the task. </p>
    #[serde(rename = "taskId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub task_id: Option<String>,
    /// <p> The name of the thing. </p>
    #[serde(rename = "thingName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_name: Option<String>,
    /// <p> The unique identifier of the violation. </p>
    #[serde(rename = "violationId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub violation_id: Option<String>,
}

/// <p> The statistics of a mitigation action task. </p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DetectMitigationActionsTaskStatistics {
    /// <p> The actions that were performed. </p>
    #[serde(rename = "actionsExecuted")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub actions_executed: Option<i64>,
    /// <p> The actions that failed. </p>
    #[serde(rename = "actionsFailed")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub actions_failed: Option<i64>,
    /// <p> The actions that were skipped. </p>
    #[serde(rename = "actionsSkipped")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub actions_skipped: Option<i64>,
}

/// <p> The summary of the mitigation action tasks. </p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DetectMitigationActionsTaskSummary {
    /// <p> The definition of the actions. </p>
    #[serde(rename = "actionsDefinition")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub actions_definition: Option<Vec<MitigationAction>>,
    /// <p> Includes only active violations. </p>
    #[serde(rename = "onlyActiveViolationsIncluded")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub only_active_violations_included: Option<bool>,
    /// <p> Includes suppressed alerts. </p>
    #[serde(rename = "suppressedAlertsIncluded")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub suppressed_alerts_included: Option<bool>,
    /// <p> Specifies the ML Detect findings to which the mitigation actions are applied. </p>
    #[serde(rename = "target")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub target: Option<DetectMitigationActionsTaskTarget>,
    /// <p> The date the task ended. </p>
    #[serde(rename = "taskEndTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub task_end_time: Option<f64>,
    /// <p> The unique identifier of the task. </p>
    #[serde(rename = "taskId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub task_id: Option<String>,
    /// <p> The date the task started. </p>
    #[serde(rename = "taskStartTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub task_start_time: Option<f64>,
    /// <p> The statistics of a mitigation action task. </p>
    #[serde(rename = "taskStatistics")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub task_statistics: Option<DetectMitigationActionsTaskStatistics>,
    /// <p> The status of the task. </p>
    #[serde(rename = "taskStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub task_status: Option<String>,
    /// <p> Specifies the time period of which violation events occurred between. </p>
    #[serde(rename = "violationEventOccurrenceRange")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub violation_event_occurrence_range: Option<ViolationEventOccurrenceRange>,
}

/// <p> The target of a mitigation action task. </p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct DetectMitigationActionsTaskTarget {
    /// <p> The name of the behavior. </p>
    #[serde(rename = "behaviorName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub behavior_name: Option<String>,
    /// <p> The name of the security profile. </p>
    #[serde(rename = "securityProfileName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub security_profile_name: Option<String>,
    /// <p> The unique identifiers of the violations. </p>
    #[serde(rename = "violationIds")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub violation_ids: Option<Vec<String>>,
}

/// <p>The input for the DisableTopicRuleRequest operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DisableTopicRuleRequest {
    /// <p>The name of the rule to disable.</p>
    #[serde(rename = "ruleName")]
    pub rule_name: String,
}

/// <p><p>The summary of a domain configuration. A domain configuration specifies custom IoT-specific information about a domain. A domain configuration can be associated with an AWS-managed domain (for example, dbc123defghijk.iot.us-west-2.amazonaws.com), a customer managed domain, or a default endpoint.</p> <ul> <li> <p>Data</p> </li> <li> <p>Jobs</p> </li> <li> <p>CredentialProvider</p> </li> </ul></p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DomainConfigurationSummary {
    /// <p>The ARN of the domain configuration.</p>
    #[serde(rename = "domainConfigurationArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub domain_configuration_arn: Option<String>,
    /// <p>The name of the domain configuration. This value must be unique to a region.</p>
    #[serde(rename = "domainConfigurationName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub domain_configuration_name: Option<String>,
    /// <p>The type of service delivered by the endpoint.</p>
    #[serde(rename = "serviceType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub service_type: Option<String>,
}

/// <p>Describes an action to write to a DynamoDB table.</p> <p>The <code>tableName</code>, <code>hashKeyField</code>, and <code>rangeKeyField</code> values must match the values used when you created the table.</p> <p>The <code>hashKeyValue</code> and <code>rangeKeyvalue</code> fields use a substitution template syntax. These templates provide data at runtime. The syntax is as follows: ${<i>sql-expression</i>}.</p> <p>You can specify any valid expression in a WHERE or SELECT clause, including JSON properties, comparisons, calculations, and functions. For example, the following field uses the third level of the topic:</p> <p> <code>"hashKeyValue": "${topic(3)}"</code> </p> <p>The following field uses the timestamp:</p> <p> <code>"rangeKeyValue": "${timestamp()}"</code> </p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct DynamoDBAction {
    /// <p>The hash key name.</p>
    #[serde(rename = "hashKeyField")]
    pub hash_key_field: String,
    /// <p>The hash key type. Valid values are "STRING" or "NUMBER"</p>
    #[serde(rename = "hashKeyType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub hash_key_type: Option<String>,
    /// <p>The hash key value.</p>
    #[serde(rename = "hashKeyValue")]
    pub hash_key_value: String,
    /// <p>The type of operation to be performed. This follows the substitution template, so it can be <code>${operation}</code>, but the substitution must result in one of the following: <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>.</p>
    #[serde(rename = "operation")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub operation: Option<String>,
    /// <p>The action payload. This name can be customized.</p>
    #[serde(rename = "payloadField")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub payload_field: Option<String>,
    /// <p>The range key name.</p>
    #[serde(rename = "rangeKeyField")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub range_key_field: Option<String>,
    /// <p>The range key type. Valid values are "STRING" or "NUMBER"</p>
    #[serde(rename = "rangeKeyType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub range_key_type: Option<String>,
    /// <p>The range key value.</p>
    #[serde(rename = "rangeKeyValue")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub range_key_value: Option<String>,
    /// <p>The ARN of the IAM role that grants access to the DynamoDB table.</p>
    #[serde(rename = "roleArn")]
    pub role_arn: String,
    /// <p>The name of the DynamoDB table.</p>
    #[serde(rename = "tableName")]
    pub table_name: String,
}

/// <p>Describes an action to write to a DynamoDB table.</p> <p>This DynamoDB action writes each attribute in the message payload into it's own column in the DynamoDB table.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct DynamoDBv2Action {
    /// <p>Specifies the DynamoDB table to which the message data will be written. For example:</p> <p> <code>{ "dynamoDBv2": { "roleArn": "aws:iam:12341251:my-role" "putItem": { "tableName": "my-table" } } }</code> </p> <p>Each attribute in the message payload will be written to a separate column in the DynamoDB database.</p>
    #[serde(rename = "putItem")]
    pub put_item: PutItemInput,
    /// <p>The ARN of the IAM role that grants access to the DynamoDB table.</p>
    #[serde(rename = "roleArn")]
    pub role_arn: String,
}

/// <p>The policy that has the effect on the authorization results.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct EffectivePolicy {
    /// <p>The policy ARN.</p>
    #[serde(rename = "policyArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub policy_arn: Option<String>,
    /// <p>The IAM policy document.</p>
    #[serde(rename = "policyDocument")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub policy_document: Option<String>,
    /// <p>The policy name.</p>
    #[serde(rename = "policyName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub policy_name: Option<String>,
}

/// <p>Describes an action that writes data to an Amazon Elasticsearch Service domain.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ElasticsearchAction {
    /// <p>The endpoint of your Elasticsearch domain.</p>
    #[serde(rename = "endpoint")]
    pub endpoint: String,
    /// <p>The unique identifier for the document you are storing.</p>
    #[serde(rename = "id")]
    pub id: String,
    /// <p>The Elasticsearch index where you want to store your data.</p>
    #[serde(rename = "index")]
    pub index: String,
    /// <p>The IAM role ARN that has access to Elasticsearch.</p>
    #[serde(rename = "roleArn")]
    pub role_arn: String,
    /// <p>The type of document you are storing.</p>
    #[serde(rename = "type")]
    pub type_: String,
}

/// <p>Parameters used when defining a mitigation action that enable AWS IoT logging.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct EnableIoTLoggingParams {
    /// <p>Specifies the type of information to be logged.</p>
    #[serde(rename = "logLevel")]
    pub log_level: String,
    /// <p>The Amazon Resource Name (ARN) of the IAM role used for logging.</p>
    #[serde(rename = "roleArnForLogging")]
    pub role_arn_for_logging: String,
}

/// <p>The input for the EnableTopicRuleRequest operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct EnableTopicRuleRequest {
    /// <p>The name of the topic rule to enable.</p>
    #[serde(rename = "ruleName")]
    pub rule_name: String,
}

/// <p>Error information.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ErrorInfo {
    /// <p>The error code.</p>
    #[serde(rename = "code")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    /// <p>The error message.</p>
    #[serde(rename = "message")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}

/// <p>Information that explicitly denies authorization.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ExplicitDeny {
    /// <p>The policies that denied the authorization.</p>
    #[serde(rename = "policies")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub policies: Option<Vec<Policy>>,
}

/// <p>Allows you to create an exponential rate of rollout for a job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ExponentialRolloutRate {
    /// <p>The minimum number of things that will be notified of a pending job, per minute at the start of job rollout. This parameter allows you to define the initial rate of rollout.</p>
    #[serde(rename = "baseRatePerMinute")]
    pub base_rate_per_minute: i64,
    /// <p>The exponential factor to increase the rate of rollout for a job.</p> <p>AWS IoT supports up to one digit after the decimal (for example, 1.5, but not 1.55).</p>
    #[serde(rename = "incrementFactor")]
    pub increment_factor: f64,
    /// <p>The criteria to initiate the increase in rate of rollout for a job.</p>
    #[serde(rename = "rateIncreaseCriteria")]
    pub rate_increase_criteria: RateIncreaseCriteria,
}

/// <p>Describes the name and data type at a field.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct Field {
    /// <p>The name of the field.</p>
    #[serde(rename = "name")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    /// <p>The datatype of the field.</p>
    #[serde(rename = "type")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}

/// <p>The location of the OTA update.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct FileLocation {
    /// <p>The location of the updated firmware in S3.</p>
    #[serde(rename = "s3Location")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub s_3_location: Option<S3Location>,
    /// <p>The stream that contains the OTA update.</p>
    #[serde(rename = "stream")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub stream: Option<Stream>,
}

/// <p>Describes an action that writes data to an Amazon Kinesis Firehose stream.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct FirehoseAction {
    /// <p>Whether to deliver the Kinesis Data Firehose stream as a batch by using <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_PutRecordBatch.html"> <code>PutRecordBatch</code> </a>. The default value is <code>false</code>.</p> <p>When <code>batchMode</code> is <code>true</code> and the rule's SQL statement evaluates to an Array, each Array element forms one record in the <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_PutRecordBatch.html"> <code>PutRecordBatch</code> </a> request. The resulting array can't have more than 500 records.</p>
    #[serde(rename = "batchMode")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub batch_mode: Option<bool>,
    /// <p>The delivery stream name.</p>
    #[serde(rename = "deliveryStreamName")]
    pub delivery_stream_name: String,
    /// <p>The IAM role that grants access to the Amazon Kinesis Firehose stream.</p>
    #[serde(rename = "roleArn")]
    pub role_arn: String,
    /// <p>A character separator that will be used to separate records written to the Firehose stream. Valid values are: '\n' (newline), '\t' (tab), '\r\n' (Windows newline), ',' (comma).</p>
    #[serde(rename = "separator")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub separator: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetBehaviorModelTrainingSummariesRequest {
    /// <p> The maximum number of results to return at one time. The default is 25. </p>
    #[serde(rename = "maxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p> The token for the next set of results. </p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p> The name of the security profile. </p>
    #[serde(rename = "securityProfileName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub security_profile_name: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetBehaviorModelTrainingSummariesResponse {
    /// <p> A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results. </p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p> A list of all ML Detect behaviors and their model status for a given Security Profile. </p>
    #[serde(rename = "summaries")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub summaries: Option<Vec<BehaviorModelTrainingSummary>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetCardinalityRequest {
    /// <p>The field to aggregate.</p>
    #[serde(rename = "aggregationField")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub aggregation_field: Option<String>,
    /// <p>The name of the index to search.</p>
    #[serde(rename = "indexName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub index_name: Option<String>,
    /// <p>The search query.</p>
    #[serde(rename = "queryString")]
    pub query_string: String,
    /// <p>The query version.</p>
    #[serde(rename = "queryVersion")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub query_version: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetCardinalityResponse {
    /// <p>The approximate count of unique values that match the query.</p>
    #[serde(rename = "cardinality")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub cardinality: Option<i64>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetEffectivePoliciesRequest {
    /// <p>The Cognito identity pool ID.</p>
    #[serde(rename = "cognitoIdentityPoolId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub cognito_identity_pool_id: Option<String>,
    /// <p>The principal. Valid principals are CertificateArn (arn:aws:iot:<i>region</i>:<i>accountId</i>:cert/<i>certificateId</i>), thingGroupArn (arn:aws:iot:<i>region</i>:<i>accountId</i>:thinggroup/<i>groupName</i>) and CognitoId (<i>region</i>:<i>id</i>).</p>
    #[serde(rename = "principal")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub principal: Option<String>,
    /// <p>The thing name.</p>
    #[serde(rename = "thingName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_name: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetEffectivePoliciesResponse {
    /// <p>The effective policies.</p>
    #[serde(rename = "effectivePolicies")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub effective_policies: Option<Vec<EffectivePolicy>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetIndexingConfigurationRequest {}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetIndexingConfigurationResponse {
    /// <p>The index configuration.</p>
    #[serde(rename = "thingGroupIndexingConfiguration")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_group_indexing_configuration: Option<ThingGroupIndexingConfiguration>,
    /// <p>Thing indexing configuration.</p>
    #[serde(rename = "thingIndexingConfiguration")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_indexing_configuration: Option<ThingIndexingConfiguration>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetJobDocumentRequest {
    /// <p>The unique identifier you assigned to this job when it was created.</p>
    #[serde(rename = "jobId")]
    pub job_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetJobDocumentResponse {
    /// <p>The job document content.</p>
    #[serde(rename = "document")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub document: Option<String>,
}

/// <p>The input for the GetLoggingOptions operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetLoggingOptionsRequest {}

/// <p>The output from the GetLoggingOptions operation.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetLoggingOptionsResponse {
    /// <p>The logging level.</p>
    #[serde(rename = "logLevel")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub log_level: Option<String>,
    /// <p>The ARN of the IAM role that grants access.</p>
    #[serde(rename = "roleArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub role_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetOTAUpdateRequest {
    /// <p>The OTA update ID.</p>
    #[serde(rename = "otaUpdateId")]
    pub ota_update_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetOTAUpdateResponse {
    /// <p>The OTA update info.</p>
    #[serde(rename = "otaUpdateInfo")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub ota_update_info: Option<OTAUpdateInfo>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetPercentilesRequest {
    /// <p>The field to aggregate.</p>
    #[serde(rename = "aggregationField")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub aggregation_field: Option<String>,
    /// <p>The name of the index to search.</p>
    #[serde(rename = "indexName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub index_name: Option<String>,
    /// <p>The percentile groups returned.</p>
    #[serde(rename = "percents")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub percents: Option<Vec<f64>>,
    /// <p>The query string.</p>
    #[serde(rename = "queryString")]
    pub query_string: String,
    /// <p>The query version.</p>
    #[serde(rename = "queryVersion")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub query_version: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetPercentilesResponse {
    /// <p>The percentile values of the aggregated fields.</p>
    #[serde(rename = "percentiles")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub percentiles: Option<Vec<PercentPair>>,
}

/// <p>The input for the GetPolicy operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetPolicyRequest {
    /// <p>The name of the policy.</p>
    #[serde(rename = "policyName")]
    pub policy_name: String,
}

/// <p>The output from the GetPolicy operation.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetPolicyResponse {
    /// <p>The date the policy was created.</p>
    #[serde(rename = "creationDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_date: Option<f64>,
    /// <p>The default policy version ID.</p>
    #[serde(rename = "defaultVersionId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub default_version_id: Option<String>,
    /// <p>The generation ID of the policy.</p>
    #[serde(rename = "generationId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub generation_id: Option<String>,
    /// <p>The date the policy was last modified.</p>
    #[serde(rename = "lastModifiedDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_date: Option<f64>,
    /// <p>The policy ARN.</p>
    #[serde(rename = "policyArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub policy_arn: Option<String>,
    /// <p>The JSON document that describes the policy.</p>
    #[serde(rename = "policyDocument")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub policy_document: Option<String>,
    /// <p>The policy name.</p>
    #[serde(rename = "policyName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub policy_name: Option<String>,
}

/// <p>The input for the GetPolicyVersion operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetPolicyVersionRequest {
    /// <p>The name of the policy.</p>
    #[serde(rename = "policyName")]
    pub policy_name: String,
    /// <p>The policy version ID.</p>
    #[serde(rename = "policyVersionId")]
    pub policy_version_id: String,
}

/// <p>The output from the GetPolicyVersion operation.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetPolicyVersionResponse {
    /// <p>The date the policy was created.</p>
    #[serde(rename = "creationDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_date: Option<f64>,
    /// <p>The generation ID of the policy version.</p>
    #[serde(rename = "generationId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub generation_id: Option<String>,
    /// <p>Specifies whether the policy version is the default.</p>
    #[serde(rename = "isDefaultVersion")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub is_default_version: Option<bool>,
    /// <p>The date the policy was last modified.</p>
    #[serde(rename = "lastModifiedDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_date: Option<f64>,
    /// <p>The policy ARN.</p>
    #[serde(rename = "policyArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub policy_arn: Option<String>,
    /// <p>The JSON document that describes the policy.</p>
    #[serde(rename = "policyDocument")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub policy_document: Option<String>,
    /// <p>The policy name.</p>
    #[serde(rename = "policyName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub policy_name: Option<String>,
    /// <p>The policy version ID.</p>
    #[serde(rename = "policyVersionId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub policy_version_id: Option<String>,
}

/// <p>The input to the GetRegistrationCode operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetRegistrationCodeRequest {}

/// <p>The output from the GetRegistrationCode operation.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetRegistrationCodeResponse {
    /// <p>The CA certificate registration code.</p>
    #[serde(rename = "registrationCode")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub registration_code: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetStatisticsRequest {
    /// <p>The aggregation field name.</p>
    #[serde(rename = "aggregationField")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub aggregation_field: Option<String>,
    /// <p>The name of the index to search. The default value is <code>AWS_Things</code>.</p>
    #[serde(rename = "indexName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub index_name: Option<String>,
    /// <p>The query used to search. You can specify "*" for the query string to get the count of all indexed things in your AWS account.</p>
    #[serde(rename = "queryString")]
    pub query_string: String,
    /// <p>The version of the query used to search.</p>
    #[serde(rename = "queryVersion")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub query_version: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetStatisticsResponse {
    /// <p>The statistics returned by the Fleet Indexing service based on the query and aggregation field.</p>
    #[serde(rename = "statistics")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub statistics: Option<Statistics>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetTopicRuleDestinationRequest {
    /// <p>The ARN of the topic rule destination.</p>
    #[serde(rename = "arn")]
    pub arn: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetTopicRuleDestinationResponse {
    /// <p>The topic rule destination.</p>
    #[serde(rename = "topicRuleDestination")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub topic_rule_destination: Option<TopicRuleDestination>,
}

/// <p>The input for the GetTopicRule operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetTopicRuleRequest {
    /// <p>The name of the rule.</p>
    #[serde(rename = "ruleName")]
    pub rule_name: String,
}

/// <p>The output from the GetTopicRule operation.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetTopicRuleResponse {
    /// <p>The rule.</p>
    #[serde(rename = "rule")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub rule: Option<TopicRule>,
    /// <p>The rule ARN.</p>
    #[serde(rename = "ruleArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub rule_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetV2LoggingOptionsRequest {}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetV2LoggingOptionsResponse {
    /// <p>The default log level.</p>
    #[serde(rename = "defaultLogLevel")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub default_log_level: Option<String>,
    /// <p>Disables all logs.</p>
    #[serde(rename = "disableAllLogs")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub disable_all_logs: Option<bool>,
    /// <p>The IAM role ARN AWS IoT uses to write to your CloudWatch logs.</p>
    #[serde(rename = "roleArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub role_arn: Option<String>,
}

/// <p>The name and ARN of a group.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GroupNameAndArn {
    /// <p>The group ARN.</p>
    #[serde(rename = "groupArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub group_arn: Option<String>,
    /// <p>The group name.</p>
    #[serde(rename = "groupName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub group_name: Option<String>,
}

/// <p>Send data to an HTTPS endpoint.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct HttpAction {
    /// <p>The authentication method to use when sending data to an HTTPS endpoint.</p>
    #[serde(rename = "auth")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub auth: Option<HttpAuthorization>,
    /// <p>The URL to which AWS IoT sends a confirmation message. The value of the confirmation URL must be a prefix of the endpoint URL. If you do not specify a confirmation URL AWS IoT uses the endpoint URL as the confirmation URL. If you use substitution templates in the confirmationUrl, you must create and enable topic rule destinations that match each possible value of the substitution template before traffic is allowed to your endpoint URL.</p>
    #[serde(rename = "confirmationUrl")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub confirmation_url: Option<String>,
    /// <p>The HTTP headers to send with the message data.</p>
    #[serde(rename = "headers")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub headers: Option<Vec<HttpActionHeader>>,
    /// <p>The endpoint URL. If substitution templates are used in the URL, you must also specify a <code>confirmationUrl</code>. If this is a new destination, a new <code>TopicRuleDestination</code> is created if possible.</p>
    #[serde(rename = "url")]
    pub url: String,
}

/// <p>The HTTP action header.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct HttpActionHeader {
    /// <p>The HTTP header key.</p>
    #[serde(rename = "key")]
    pub key: String,
    /// <p>The HTTP header value. Substitution templates are supported.</p>
    #[serde(rename = "value")]
    pub value: String,
}

/// <p>The authorization method used to send messages.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct HttpAuthorization {
    /// <p>Use Sig V4 authorization. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 Signing Process</a>.</p>
    #[serde(rename = "sigv4")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sigv_4: Option<SigV4Authorization>,
}

/// <p>Specifies the HTTP context to use for the test authorizer request.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct HttpContext {
    /// <p>The header keys and values in an HTTP authorization request.</p>
    #[serde(rename = "headers")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub headers: Option<::std::collections::HashMap<String, String>>,
    /// <p>The query string keys and values in an HTTP authorization request.</p>
    #[serde(rename = "queryString")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub query_string: Option<String>,
}

/// <p>HTTP URL destination configuration used by the topic rule's HTTP action.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct HttpUrlDestinationConfiguration {
    /// <p>The URL AWS IoT uses to confirm ownership of or access to the topic rule destination URL.</p>
    #[serde(rename = "confirmationUrl")]
    pub confirmation_url: String,
}

/// <p>HTTP URL destination properties.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct HttpUrlDestinationProperties {
    /// <p>The URL used to confirm the HTTP topic rule destination URL.</p>
    #[serde(rename = "confirmationUrl")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub confirmation_url: Option<String>,
}

/// <p>Information about an HTTP URL destination.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct HttpUrlDestinationSummary {
    /// <p>The URL used to confirm ownership of or access to the HTTP topic rule destination URL.</p>
    #[serde(rename = "confirmationUrl")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub confirmation_url: Option<String>,
}

/// <p>Information that implicitly denies authorization. When policy doesn't explicitly deny or allow an action on a resource it is considered an implicit deny.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ImplicitDeny {
    /// <p>Policies that don't contain a matching allow or deny statement for the specified action on the specified resource. </p>
    #[serde(rename = "policies")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub policies: Option<Vec<Policy>>,
}

/// <p>Sends message data to an AWS IoT Analytics channel.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct IotAnalyticsAction {
    /// <p>Whether to process the action as a batch. The default value is <code>false</code>.</p> <p>When <code>batchMode</code> is <code>true</code> and the rule SQL statement evaluates to an Array, each Array element is delivered as a separate message when passed by <a href="https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_BatchPutMessage.html"> <code>BatchPutMessage</code> </a> to the AWS IoT Analytics channel. The resulting array can't have more than 100 messages.</p>
    #[serde(rename = "batchMode")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub batch_mode: Option<bool>,
    /// <p>(deprecated) The ARN of the IoT Analytics channel to which message data will be sent.</p>
    #[serde(rename = "channelArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub channel_arn: Option<String>,
    /// <p>The name of the IoT Analytics channel to which message data will be sent.</p>
    #[serde(rename = "channelName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub channel_name: Option<String>,
    /// <p>The ARN of the role which has a policy that grants IoT Analytics permission to send message data via IoT Analytics (iotanalytics:BatchPutMessage).</p>
    #[serde(rename = "roleArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub role_arn: Option<String>,
}

/// <p>Sends an input to an AWS IoT Events detector.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct IotEventsAction {
    /// <p>Whether to process the event actions as a batch. The default value is <code>false</code>.</p> <p>When <code>batchMode</code> is <code>true</code>, you can't specify a <code>messageId</code>. </p> <p>When <code>batchMode</code> is <code>true</code> and the rule SQL statement evaluates to an Array, each Array element is treated as a separate message when it's sent to AWS IoT Events by calling <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_BatchPutMessage.html"> <code>BatchPutMessage</code> </a>. The resulting array can't have more than 10 messages.</p>
    #[serde(rename = "batchMode")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub batch_mode: Option<bool>,
    /// <p>The name of the AWS IoT Events input.</p>
    #[serde(rename = "inputName")]
    pub input_name: String,
    /// <p>The ID of the message. The default <code>messageId</code> is a new UUID value.</p> <p>When <code>batchMode</code> is <code>true</code>, you can't specify a <code>messageId</code>--a new UUID value will be assigned.</p> <p>Assign a value to this property to ensure that only one input (message) with a given <code>messageId</code> will be processed by an AWS IoT Events detector.</p>
    #[serde(rename = "messageId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub message_id: Option<String>,
    /// <p>The ARN of the role that grants AWS IoT permission to send an input to an AWS IoT Events detector. ("Action":"iotevents:BatchPutMessage").</p>
    #[serde(rename = "roleArn")]
    pub role_arn: String,
}

/// <p>Describes an action to send data from an MQTT message that triggered the rule to AWS IoT SiteWise asset properties.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct IotSiteWiseAction {
    /// <p>A list of asset property value entries.</p>
    #[serde(rename = "putAssetPropertyValueEntries")]
    pub put_asset_property_value_entries: Vec<PutAssetPropertyValueEntry>,
    /// <p>The ARN of the role that grants AWS IoT permission to send an asset property value to AWS IoTSiteWise. (<code>"Action": "iotsitewise:BatchPutAssetPropertyValue"</code>). The trust policy can restrict access to specific asset hierarchy paths.</p>
    #[serde(rename = "roleArn")]
    pub role_arn: String,
}

/// <p>The <code>Job</code> object contains details about a job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct Job {
    /// <p>Configuration for criteria to abort the job.</p>
    #[serde(rename = "abortConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub abort_config: Option<AbortConfig>,
    /// <p>If the job was updated, describes the reason for the update.</p>
    #[serde(rename = "comment")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub comment: Option<String>,
    /// <p>The time, in seconds since the epoch, when the job was completed.</p>
    #[serde(rename = "completedAt")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub completed_at: Option<f64>,
    /// <p>The time, in seconds since the epoch, when the job was created.</p>
    #[serde(rename = "createdAt")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_at: Option<f64>,
    /// <p>A short text description of the job.</p>
    #[serde(rename = "description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// <p>Will be <code>true</code> if the job was canceled with the optional <code>force</code> parameter set to <code>true</code>.</p>
    #[serde(rename = "forceCanceled")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub force_canceled: Option<bool>,
    /// <p>An ARN identifying the job with format "arn:aws:iot:region:account:job/jobId".</p>
    #[serde(rename = "jobArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub job_arn: Option<String>,
    /// <p>Allows you to create a staged rollout of a job.</p>
    #[serde(rename = "jobExecutionsRolloutConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub job_executions_rollout_config: Option<JobExecutionsRolloutConfig>,
    /// <p>The unique identifier you assigned to this job when it was created.</p>
    #[serde(rename = "jobId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub job_id: Option<String>,
    /// <p>Details about the job process.</p>
    #[serde(rename = "jobProcessDetails")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub job_process_details: Option<JobProcessDetails>,
    /// <p>The ARN of the job template used to create the job.</p>
    #[serde(rename = "jobTemplateArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub job_template_arn: Option<String>,
    /// <p>The time, in seconds since the epoch, when the job was last updated.</p>
    #[serde(rename = "lastUpdatedAt")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_updated_at: Option<f64>,
    /// <p><p>The namespace used to indicate that a job is a customer-managed job.</p> <p>When you specify a value for this parameter, AWS IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.</p> <p> <code>$aws/things/<i>THING<em>NAME</i>/jobs/<i>JOB</em>ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code> </p> <note> <p>The <code>namespaceId</code> feature is in public preview.</p> </note></p>
    #[serde(rename = "namespaceId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub namespace_id: Option<String>,
    /// <p>Configuration for pre-signed S3 URLs.</p>
    #[serde(rename = "presignedUrlConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub presigned_url_config: Option<PresignedUrlConfig>,
    /// <p>If the job was updated, provides the reason code for the update.</p>
    #[serde(rename = "reasonCode")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub reason_code: Option<String>,
    /// <p>The status of the job, one of <code>IN_PROGRESS</code>, <code>CANCELED</code>, <code>DELETION_IN_PROGRESS</code> or <code>COMPLETED</code>. </p>
    #[serde(rename = "status")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    /// <p>Specifies whether the job will continue to run (CONTINUOUS), or will be complete after all those things specified as targets have completed the job (SNAPSHOT). If continuous, the job may also be run on a thing when a change is detected in a target. For example, a job will run on a device when the thing representing the device is added to a target group, even after the job was completed by all things originally in the group. </p>
    #[serde(rename = "targetSelection")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub target_selection: Option<String>,
    /// <p>A list of IoT things and thing groups to which the job should be sent.</p>
    #[serde(rename = "targets")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub targets: Option<Vec<String>>,
    /// <p>Specifies the amount of time each device has to finish its execution of the job. A timer is started when the job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to another terminal state before the timer expires, it will be automatically set to <code>TIMED_OUT</code>.</p>
    #[serde(rename = "timeoutConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub timeout_config: Option<TimeoutConfig>,
}

/// <p>The job execution object represents the execution of a job on a particular device.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct JobExecution {
    /// <p>The estimated number of seconds that remain before the job execution status will be changed to <code>TIMED_OUT</code>. The timeout interval can be anywhere between 1 minute and 7 days (1 to 10080 minutes). The actual job execution timeout can occur up to 60 seconds later than the estimated duration. This value will not be included if the job execution has reached a terminal status.</p>
    #[serde(rename = "approximateSecondsBeforeTimedOut")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub approximate_seconds_before_timed_out: Option<i64>,
    /// <p>A string (consisting of the digits "0" through "9") which identifies this particular job execution on this particular device. It can be used in commands which return or update job execution information. </p>
    #[serde(rename = "executionNumber")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub execution_number: Option<i64>,
    /// <p>Will be <code>true</code> if the job execution was canceled with the optional <code>force</code> parameter set to <code>true</code>.</p>
    #[serde(rename = "forceCanceled")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub force_canceled: Option<bool>,
    /// <p>The unique identifier you assigned to the job when it was created.</p>
    #[serde(rename = "jobId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub job_id: Option<String>,
    /// <p>The time, in seconds since the epoch, when the job execution was last updated.</p>
    #[serde(rename = "lastUpdatedAt")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_updated_at: Option<f64>,
    /// <p>The time, in seconds since the epoch, when the job execution was queued.</p>
    #[serde(rename = "queuedAt")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub queued_at: Option<f64>,
    /// <p>The time, in seconds since the epoch, when the job execution started.</p>
    #[serde(rename = "startedAt")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub started_at: Option<f64>,
    /// <p>The status of the job execution (IN_PROGRESS, QUEUED, FAILED, SUCCEEDED, TIMED_OUT, CANCELED, or REJECTED).</p>
    #[serde(rename = "status")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    /// <p>A collection of name/value pairs that describe the status of the job execution.</p>
    #[serde(rename = "statusDetails")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status_details: Option<JobExecutionStatusDetails>,
    /// <p>The ARN of the thing on which the job execution is running.</p>
    #[serde(rename = "thingArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_arn: Option<String>,
    /// <p>The version of the job execution. Job execution versions are incremented each time they are updated by a device.</p>
    #[serde(rename = "versionNumber")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub version_number: Option<i64>,
}

/// <p>Details of the job execution status.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct JobExecutionStatusDetails {
    /// <p>The job execution status.</p>
    #[serde(rename = "detailsMap")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub details_map: Option<::std::collections::HashMap<String, String>>,
}

/// <p>The job execution summary.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct JobExecutionSummary {
    /// <p>A string (consisting of the digits "0" through "9") which identifies this particular job execution on this particular device. It can be used later in commands which return or update job execution information.</p>
    #[serde(rename = "executionNumber")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub execution_number: Option<i64>,
    /// <p>The time, in seconds since the epoch, when the job execution was last updated.</p>
    #[serde(rename = "lastUpdatedAt")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_updated_at: Option<f64>,
    /// <p>The time, in seconds since the epoch, when the job execution was queued.</p>
    #[serde(rename = "queuedAt")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub queued_at: Option<f64>,
    /// <p>The time, in seconds since the epoch, when the job execution started.</p>
    #[serde(rename = "startedAt")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub started_at: Option<f64>,
    /// <p>The status of the job execution.</p>
    #[serde(rename = "status")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
}

/// <p>Contains a summary of information about job executions for a specific job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct JobExecutionSummaryForJob {
    /// <p>Contains a subset of information about a job execution.</p>
    #[serde(rename = "jobExecutionSummary")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub job_execution_summary: Option<JobExecutionSummary>,
    /// <p>The ARN of the thing on which the job execution is running.</p>
    #[serde(rename = "thingArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_arn: Option<String>,
}

/// <p>The job execution summary for a thing.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct JobExecutionSummaryForThing {
    /// <p>Contains a subset of information about a job execution.</p>
    #[serde(rename = "jobExecutionSummary")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub job_execution_summary: Option<JobExecutionSummary>,
    /// <p>The unique identifier you assigned to this job when it was created.</p>
    #[serde(rename = "jobId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub job_id: Option<String>,
}

/// <p>Allows you to create a staged rollout of a job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct JobExecutionsRolloutConfig {
    /// <p>The rate of increase for a job rollout. This parameter allows you to define an exponential rate for a job rollout.</p>
    #[serde(rename = "exponentialRate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub exponential_rate: Option<ExponentialRolloutRate>,
    /// <p>The maximum number of things that will be notified of a pending job, per minute. This parameter allows you to create a staged rollout.</p>
    #[serde(rename = "maximumPerMinute")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub maximum_per_minute: Option<i64>,
}

/// <p>The job process details.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct JobProcessDetails {
    /// <p>The number of things that cancelled the job.</p>
    #[serde(rename = "numberOfCanceledThings")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub number_of_canceled_things: Option<i64>,
    /// <p>The number of things that failed executing the job.</p>
    #[serde(rename = "numberOfFailedThings")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub number_of_failed_things: Option<i64>,
    /// <p>The number of things currently executing the job.</p>
    #[serde(rename = "numberOfInProgressThings")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub number_of_in_progress_things: Option<i64>,
    /// <p>The number of things that are awaiting execution of the job.</p>
    #[serde(rename = "numberOfQueuedThings")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub number_of_queued_things: Option<i64>,
    /// <p>The number of things that rejected the job.</p>
    #[serde(rename = "numberOfRejectedThings")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub number_of_rejected_things: Option<i64>,
    /// <p>The number of things that are no longer scheduled to execute the job because they have been deleted or have been removed from the group that was a target of the job.</p>
    #[serde(rename = "numberOfRemovedThings")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub number_of_removed_things: Option<i64>,
    /// <p>The number of things which successfully completed the job.</p>
    #[serde(rename = "numberOfSucceededThings")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub number_of_succeeded_things: Option<i64>,
    /// <p>The number of things whose job execution status is <code>TIMED_OUT</code>.</p>
    #[serde(rename = "numberOfTimedOutThings")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub number_of_timed_out_things: Option<i64>,
    /// <p>The target devices to which the job execution is being rolled out. This value will be null after the job execution has finished rolling out to all the target devices.</p>
    #[serde(rename = "processingTargets")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub processing_targets: Option<Vec<String>>,
}

/// <p>The job summary.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct JobSummary {
    /// <p>The time, in seconds since the epoch, when the job completed.</p>
    #[serde(rename = "completedAt")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub completed_at: Option<f64>,
    /// <p>The time, in seconds since the epoch, when the job was created.</p>
    #[serde(rename = "createdAt")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_at: Option<f64>,
    /// <p>The job ARN.</p>
    #[serde(rename = "jobArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub job_arn: Option<String>,
    /// <p>The unique identifier you assigned to this job when it was created.</p>
    #[serde(rename = "jobId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub job_id: Option<String>,
    /// <p>The time, in seconds since the epoch, when the job was last updated.</p>
    #[serde(rename = "lastUpdatedAt")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_updated_at: Option<f64>,
    /// <p>The job summary status.</p>
    #[serde(rename = "status")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    /// <p>Specifies whether the job will continue to run (CONTINUOUS), or will be complete after all those things specified as targets have completed the job (SNAPSHOT). If continuous, the job may also be run on a thing when a change is detected in a target. For example, a job will run on a thing when the thing is added to a target group, even after the job was completed by all things originally in the group.</p>
    #[serde(rename = "targetSelection")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub target_selection: Option<String>,
    /// <p>The ID of the thing group.</p>
    #[serde(rename = "thingGroupId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_group_id: Option<String>,
}

/// <p>An object that contains information about the job template.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct JobTemplateSummary {
    /// <p>The time, in seconds since the epoch, when the job template was created.</p>
    #[serde(rename = "createdAt")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_at: Option<f64>,
    /// <p>A description of the job template.</p>
    #[serde(rename = "description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// <p>The ARN of the job template.</p>
    #[serde(rename = "jobTemplateArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub job_template_arn: Option<String>,
    /// <p>The unique identifier of the job template.</p>
    #[serde(rename = "jobTemplateId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub job_template_id: Option<String>,
}

/// <p>Send messages to an Amazon Managed Streaming for Apache Kafka (Amazon MSK) or self-managed Apache Kafka cluster.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct KafkaAction {
    /// <p>Properties of the Apache Kafka producer client.</p>
    #[serde(rename = "clientProperties")]
    pub client_properties: ::std::collections::HashMap<String, String>,
    /// <p>The ARN of Kafka action's VPC <code>TopicRuleDestination</code>.</p>
    #[serde(rename = "destinationArn")]
    pub destination_arn: String,
    /// <p>The Kafka message key.</p>
    #[serde(rename = "key")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub key: Option<String>,
    /// <p>The Kafka message partition.</p>
    #[serde(rename = "partition")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub partition: Option<String>,
    /// <p>The Kafka topic for messages to be sent to the Kafka broker.</p>
    #[serde(rename = "topic")]
    pub topic: String,
}

/// <p>Describes a key pair.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct KeyPair {
    /// <p>The private key.</p>
    #[serde(rename = "PrivateKey")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub private_key: Option<String>,
    /// <p>The public key.</p>
    #[serde(rename = "PublicKey")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub public_key: Option<String>,
}

/// <p>Describes an action to write data to an Amazon Kinesis stream.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct KinesisAction {
    /// <p>The partition key.</p>
    #[serde(rename = "partitionKey")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub partition_key: Option<String>,
    /// <p>The ARN of the IAM role that grants access to the Amazon Kinesis stream.</p>
    #[serde(rename = "roleArn")]
    pub role_arn: String,
    /// <p>The name of the Amazon Kinesis stream.</p>
    #[serde(rename = "streamName")]
    pub stream_name: String,
}

/// <p>Describes an action to invoke a Lambda function.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct LambdaAction {
    /// <p>The ARN of the Lambda function.</p>
    #[serde(rename = "functionArn")]
    pub function_arn: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListActiveViolationsRequest {
    /// <p> The criteria for a behavior. </p>
    #[serde(rename = "behaviorCriteriaType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub behavior_criteria_type: Option<String>,
    /// <p> A list of all suppressed alerts. </p>
    #[serde(rename = "listSuppressedAlerts")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub list_suppressed_alerts: Option<bool>,
    /// <p>The maximum number of results to return at one time.</p>
    #[serde(rename = "maxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>The token for the next set of results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The name of the Device Defender security profile for which violations are listed.</p>
    #[serde(rename = "securityProfileName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub security_profile_name: Option<String>,
    /// <p>The name of the thing whose active violations are listed.</p>
    #[serde(rename = "thingName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_name: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListActiveViolationsResponse {
    /// <p>The list of active violations.</p>
    #[serde(rename = "activeViolations")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub active_violations: Option<Vec<ActiveViolation>>,
    /// <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListAttachedPoliciesRequest {
    /// <p>The token to retrieve the next set of results.</p>
    #[serde(rename = "marker")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub marker: Option<String>,
    /// <p>The maximum number of results to be returned per request.</p>
    #[serde(rename = "pageSize")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub page_size: Option<i64>,
    /// <p>When true, recursively list attached policies.</p>
    #[serde(rename = "recursive")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub recursive: Option<bool>,
    /// <p>The group or principal for which the policies will be listed. Valid principals are CertificateArn (arn:aws:iot:<i>region</i>:<i>accountId</i>:cert/<i>certificateId</i>), thingGroupArn (arn:aws:iot:<i>region</i>:<i>accountId</i>:thinggroup/<i>groupName</i>) and CognitoId (<i>region</i>:<i>id</i>).</p>
    #[serde(rename = "target")]
    pub target: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListAttachedPoliciesResponse {
    /// <p>The token to retrieve the next set of results, or ``null`` if there are no more results.</p>
    #[serde(rename = "nextMarker")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_marker: Option<String>,
    /// <p>The policies.</p>
    #[serde(rename = "policies")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub policies: Option<Vec<Policy>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListAuditFindingsRequest {
    /// <p>A filter to limit results to the findings for the specified audit check.</p>
    #[serde(rename = "checkName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub check_name: Option<String>,
    /// <p>A filter to limit results to those found before the specified time. You must specify either the startTime and endTime or the taskId, but not both.</p>
    #[serde(rename = "endTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub end_time: Option<f64>,
    /// <p> Boolean flag indicating whether only the suppressed findings or the unsuppressed findings should be listed. If this parameter isn't provided, the response will list both suppressed and unsuppressed findings. </p>
    #[serde(rename = "listSuppressedFindings")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub list_suppressed_findings: Option<bool>,
    /// <p>The maximum number of results to return at one time. The default is 25.</p>
    #[serde(rename = "maxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>The token for the next set of results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>Information identifying the noncompliant resource.</p>
    #[serde(rename = "resourceIdentifier")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub resource_identifier: Option<ResourceIdentifier>,
    /// <p>A filter to limit results to those found after the specified time. You must specify either the startTime and endTime or the taskId, but not both.</p>
    #[serde(rename = "startTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub start_time: Option<f64>,
    /// <p>A filter to limit results to the audit with the specified ID. You must specify either the taskId or the startTime and endTime, but not both.</p>
    #[serde(rename = "taskId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub task_id: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListAuditFindingsResponse {
    /// <p>The findings (results) of the audit.</p>
    #[serde(rename = "findings")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub findings: Option<Vec<AuditFinding>>,
    /// <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListAuditMitigationActionsExecutionsRequest {
    /// <p>Specify this filter to limit results to those with a specific status.</p>
    #[serde(rename = "actionStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub action_status: Option<String>,
    /// <p>Specify this filter to limit results to those that were applied to a specific audit finding.</p>
    #[serde(rename = "findingId")]
    pub finding_id: String,
    /// <p>The maximum number of results to return at one time. The default is 25.</p>
    #[serde(rename = "maxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>The token for the next set of results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>Specify this filter to limit results to actions for a specific audit mitigation actions task.</p>
    #[serde(rename = "taskId")]
    pub task_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListAuditMitigationActionsExecutionsResponse {
    /// <p>A set of task execution results based on the input parameters. Details include the mitigation action applied, start time, and task status.</p>
    #[serde(rename = "actionsExecutions")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub actions_executions: Option<Vec<AuditMitigationActionExecutionMetadata>>,
    /// <p>The token for the next set of results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListAuditMitigationActionsTasksRequest {
    /// <p>Specify this filter to limit results to tasks that were applied to results for a specific audit.</p>
    #[serde(rename = "auditTaskId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub audit_task_id: Option<String>,
    /// <p>Specify this filter to limit results to tasks that were completed or canceled on or before a specific date and time.</p>
    #[serde(rename = "endTime")]
    pub end_time: f64,
    /// <p>Specify this filter to limit results to tasks that were applied to a specific audit finding.</p>
    #[serde(rename = "findingId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub finding_id: Option<String>,
    /// <p>The maximum number of results to return at one time. The default is 25.</p>
    #[serde(rename = "maxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>The token for the next set of results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>Specify this filter to limit results to tasks that began on or after a specific date and time.</p>
    #[serde(rename = "startTime")]
    pub start_time: f64,
    /// <p>Specify this filter to limit results to tasks that are in a specific state.</p>
    #[serde(rename = "taskStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub task_status: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListAuditMitigationActionsTasksResponse {
    /// <p>The token for the next set of results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The collection of audit mitigation tasks that matched the filter criteria.</p>
    #[serde(rename = "tasks")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tasks: Option<Vec<AuditMitigationActionsTaskMetadata>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListAuditSuppressionsRequest {
    /// <p> Determines whether suppressions are listed in ascending order by expiration date or not. If parameter isn't provided, <code>ascendingOrder=true</code>. </p>
    #[serde(rename = "ascendingOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub ascending_order: Option<bool>,
    #[serde(rename = "checkName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub check_name: Option<String>,
    /// <p> The maximum number of results to return at one time. The default is 25. </p>
    #[serde(rename = "maxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p> The token for the next set of results. </p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    #[serde(rename = "resourceIdentifier")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub resource_identifier: Option<ResourceIdentifier>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListAuditSuppressionsResponse {
    /// <p> A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results. </p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p> List of audit suppressions. </p>
    #[serde(rename = "suppressions")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub suppressions: Option<Vec<AuditSuppression>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListAuditTasksRequest {
    /// <p>The end of the time period.</p>
    #[serde(rename = "endTime")]
    pub end_time: f64,
    /// <p>The maximum number of results to return at one time. The default is 25.</p>
    #[serde(rename = "maxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>The token for the next set of results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The beginning of the time period. Audit information is retained for a limited time (90 days). Requesting a start time prior to what is retained results in an "InvalidRequestException".</p>
    #[serde(rename = "startTime")]
    pub start_time: f64,
    /// <p>A filter to limit the output to audits with the specified completion status: can be one of "IN_PROGRESS", "COMPLETED", "FAILED", or "CANCELED".</p>
    #[serde(rename = "taskStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub task_status: Option<String>,
    /// <p>A filter to limit the output to the specified type of audit: can be one of "ON_DEMAND_AUDIT_TASK" or "SCHEDULED__AUDIT_TASK".</p>
    #[serde(rename = "taskType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub task_type: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListAuditTasksResponse {
    /// <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The audits that were performed during the specified time period.</p>
    #[serde(rename = "tasks")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tasks: Option<Vec<AuditTaskMetadata>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListAuthorizersRequest {
    /// <p>Return the list of authorizers in ascending alphabetical order.</p>
    #[serde(rename = "ascendingOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub ascending_order: Option<bool>,
    /// <p>A marker used to get the next set of results.</p>
    #[serde(rename = "marker")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub marker: Option<String>,
    /// <p>The maximum number of results to return at one time.</p>
    #[serde(rename = "pageSize")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub page_size: Option<i64>,
    /// <p>The status of the list authorizers request.</p>
    #[serde(rename = "status")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListAuthorizersResponse {
    /// <p>The authorizers.</p>
    #[serde(rename = "authorizers")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub authorizers: Option<Vec<AuthorizerSummary>>,
    /// <p>A marker used to get the next set of results.</p>
    #[serde(rename = "nextMarker")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_marker: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListBillingGroupsRequest {
    /// <p>The maximum number of results to return per request.</p>
    #[serde(rename = "maxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>Limit the results to billing groups whose names have the given prefix.</p>
    #[serde(rename = "namePrefixFilter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name_prefix_filter: Option<String>,
    /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListBillingGroupsResponse {
    /// <p>The list of billing groups.</p>
    #[serde(rename = "billingGroups")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub billing_groups: Option<Vec<GroupNameAndArn>>,
    /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

/// <p>Input for the ListCACertificates operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListCACertificatesRequest {
    /// <p>Determines the order of the results.</p>
    #[serde(rename = "ascendingOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub ascending_order: Option<bool>,
    /// <p>The marker for the next set of results.</p>
    #[serde(rename = "marker")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub marker: Option<String>,
    /// <p>The result page size.</p>
    #[serde(rename = "pageSize")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub page_size: Option<i64>,
}

/// <p>The output from the ListCACertificates operation.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListCACertificatesResponse {
    /// <p>The CA certificates registered in your AWS account.</p>
    #[serde(rename = "certificates")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub certificates: Option<Vec<CACertificate>>,
    /// <p>The current position within the list of CA certificates.</p>
    #[serde(rename = "nextMarker")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_marker: Option<String>,
}

/// <p>The input to the ListCertificatesByCA operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListCertificatesByCARequest {
    /// <p>Specifies the order for results. If True, the results are returned in ascending order, based on the creation date.</p>
    #[serde(rename = "ascendingOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub ascending_order: Option<bool>,
    /// <p>The ID of the CA certificate. This operation will list all registered device certificate that were signed by this CA certificate.</p>
    #[serde(rename = "caCertificateId")]
    pub ca_certificate_id: String,
    /// <p>The marker for the next set of results.</p>
    #[serde(rename = "marker")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub marker: Option<String>,
    /// <p>The result page size.</p>
    #[serde(rename = "pageSize")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub page_size: Option<i64>,
}

/// <p>The output of the ListCertificatesByCA operation.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListCertificatesByCAResponse {
    /// <p>The device certificates signed by the specified CA certificate.</p>
    #[serde(rename = "certificates")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub certificates: Option<Vec<Certificate>>,
    /// <p>The marker for the next set of results, or null if there are no additional results.</p>
    #[serde(rename = "nextMarker")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_marker: Option<String>,
}

/// <p>The input for the ListCertificates operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListCertificatesRequest {
    /// <p>Specifies the order for results. If True, the results are returned in ascending order, based on the creation date.</p>
    #[serde(rename = "ascendingOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub ascending_order: Option<bool>,
    /// <p>The marker for the next set of results.</p>
    #[serde(rename = "marker")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub marker: Option<String>,
    /// <p>The result page size.</p>
    #[serde(rename = "pageSize")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub page_size: Option<i64>,
}

/// <p>The output of the ListCertificates operation.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListCertificatesResponse {
    /// <p>The descriptions of the certificates.</p>
    #[serde(rename = "certificates")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub certificates: Option<Vec<Certificate>>,
    /// <p>The marker for the next set of results, or null if there are no additional results.</p>
    #[serde(rename = "nextMarker")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_marker: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListCustomMetricsRequest {
    /// <p> The maximum number of results to return at one time. The default is 25. </p>
    #[serde(rename = "maxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p> The token for the next set of results. </p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListCustomMetricsResponse {
    /// <p> The name of the custom metric. </p>
    #[serde(rename = "metricNames")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metric_names: Option<Vec<String>>,
    /// <p> A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results. </p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListDetectMitigationActionsExecutionsRequest {
    /// <p> The end of the time period for which ML Detect mitigation actions executions are returned. </p>
    #[serde(rename = "endTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub end_time: Option<f64>,
    /// <p> The maximum number of results to return at one time. The default is 25. </p>
    #[serde(rename = "maxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p> The token for the next set of results. </p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p> A filter to limit results to those found after the specified time. You must specify either the startTime and endTime or the taskId, but not both. </p>
    #[serde(rename = "startTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub start_time: Option<f64>,
    /// <p> The unique identifier of the task. </p>
    #[serde(rename = "taskId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub task_id: Option<String>,
    /// <p> The name of the thing whose mitigation actions are listed. </p>
    #[serde(rename = "thingName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_name: Option<String>,
    /// <p> The unique identifier of the violation. </p>
    #[serde(rename = "violationId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub violation_id: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListDetectMitigationActionsExecutionsResponse {
    /// <p> List of actions executions. </p>
    #[serde(rename = "actionsExecutions")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub actions_executions: Option<Vec<DetectMitigationActionExecution>>,
    /// <p> A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results. </p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListDetectMitigationActionsTasksRequest {
    /// <p> The end of the time period for which ML Detect mitigation actions tasks are returned. </p>
    #[serde(rename = "endTime")]
    pub end_time: f64,
    /// <p>The maximum number of results to return at one time. The default is 25.</p>
    #[serde(rename = "maxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p> The token for the next set of results. </p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p> A filter to limit results to those found after the specified time. You must specify either the startTime and endTime or the taskId, but not both. </p>
    #[serde(rename = "startTime")]
    pub start_time: f64,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListDetectMitigationActionsTasksResponse {
    /// <p> A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results. </p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p> The collection of ML Detect mitigation tasks that matched the filter criteria. </p>
    #[serde(rename = "tasks")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tasks: Option<Vec<DetectMitigationActionsTaskSummary>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListDimensionsRequest {
    /// <p>The maximum number of results to retrieve at one time.</p>
    #[serde(rename = "maxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>The token for the next set of results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListDimensionsResponse {
    /// <p>A list of the names of the defined dimensions. Use <code>DescribeDimension</code> to get details for a dimension.</p>
    #[serde(rename = "dimensionNames")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub dimension_names: Option<Vec<String>>,
    /// <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListDomainConfigurationsRequest {
    /// <p>The marker for the next set of results.</p>
    #[serde(rename = "marker")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub marker: Option<String>,
    /// <p>The result page size.</p>
    #[serde(rename = "pageSize")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub page_size: Option<i64>,
    /// <p>The type of service delivered by the endpoint.</p>
    #[serde(rename = "serviceType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub service_type: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListDomainConfigurationsResponse {
    /// <p>A list of objects that contain summary information about the user's domain configurations.</p>
    #[serde(rename = "domainConfigurations")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub domain_configurations: Option<Vec<DomainConfigurationSummary>>,
    /// <p>The marker for the next set of results.</p>
    #[serde(rename = "nextMarker")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_marker: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListIndicesRequest {
    /// <p>The maximum number of results to return at one time.</p>
    #[serde(rename = "maxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>The token used to get the next set of results, or <code>null</code> if there are no additional results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListIndicesResponse {
    /// <p>The index names.</p>
    #[serde(rename = "indexNames")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub index_names: Option<Vec<String>>,
    /// <p>The token used to get the next set of results, or <code>null</code> if there are no additional results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListJobExecutionsForJobRequest {
    /// <p>The unique identifier you assigned to this job when it was created.</p>
    #[serde(rename = "jobId")]
    pub job_id: String,
    /// <p>The maximum number of results to be returned per request.</p>
    #[serde(rename = "maxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>The token to retrieve the next set of results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The status of the job.</p>
    #[serde(rename = "status")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListJobExecutionsForJobResponse {
    /// <p>A list of job execution summaries.</p>
    #[serde(rename = "executionSummaries")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub execution_summaries: Option<Vec<JobExecutionSummaryForJob>>,
    /// <p>The token for the next set of results, or <b>null</b> if there are no additional results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListJobExecutionsForThingRequest {
    /// <p>The maximum number of results to be returned per request.</p>
    #[serde(rename = "maxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p><p>The namespace used to indicate that a job is a customer-managed job.</p> <p>When you specify a value for this parameter, AWS IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.</p> <p> <code>$aws/things/<i>THING<em>NAME</i>/jobs/<i>JOB</em>ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code> </p> <note> <p>The <code>namespaceId</code> feature is in public preview.</p> </note></p>
    #[serde(rename = "namespaceId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub namespace_id: Option<String>,
    /// <p>The token to retrieve the next set of results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>An optional filter that lets you search for jobs that have the specified status.</p>
    #[serde(rename = "status")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    /// <p>The thing name.</p>
    #[serde(rename = "thingName")]
    pub thing_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListJobExecutionsForThingResponse {
    /// <p>A list of job execution summaries.</p>
    #[serde(rename = "executionSummaries")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub execution_summaries: Option<Vec<JobExecutionSummaryForThing>>,
    /// <p>The token for the next set of results, or <b>null</b> if there are no additional results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListJobTemplatesRequest {
    /// <p>The maximum number of results to return in the list.</p>
    #[serde(rename = "maxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>The token to use to return the next set of results in the list.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListJobTemplatesResponse {
    /// <p>A list of objects that contain information about the job templates.</p>
    #[serde(rename = "jobTemplates")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub job_templates: Option<Vec<JobTemplateSummary>>,
    /// <p>The token for the next set of results, or <b>null</b> if there are no additional results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListJobsRequest {
    /// <p>The maximum number of results to return per request.</p>
    #[serde(rename = "maxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p><p>The namespace used to indicate that a job is a customer-managed job.</p> <p>When you specify a value for this parameter, AWS IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.</p> <p> <code>$aws/things/<i>THING<em>NAME</i>/jobs/<i>JOB</em>ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code> </p> <note> <p>The <code>namespaceId</code> feature is in public preview.</p> </note></p>
    #[serde(rename = "namespaceId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub namespace_id: Option<String>,
    /// <p>The token to retrieve the next set of results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>An optional filter that lets you search for jobs that have the specified status.</p>
    #[serde(rename = "status")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    /// <p>Specifies whether the job will continue to run (CONTINUOUS), or will be complete after all those things specified as targets have completed the job (SNAPSHOT). If continuous, the job may also be run on a thing when a change is detected in a target. For example, a job will run on a thing when the thing is added to a target group, even after the job was completed by all things originally in the group. </p>
    #[serde(rename = "targetSelection")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub target_selection: Option<String>,
    /// <p>A filter that limits the returned jobs to those for the specified group.</p>
    #[serde(rename = "thingGroupId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_group_id: Option<String>,
    /// <p>A filter that limits the returned jobs to those for the specified group.</p>
    #[serde(rename = "thingGroupName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_group_name: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListJobsResponse {
    /// <p>A list of jobs.</p>
    #[serde(rename = "jobs")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub jobs: Option<Vec<JobSummary>>,
    /// <p>The token for the next set of results, or <b>null</b> if there are no additional results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListMitigationActionsRequest {
    /// <p>Specify a value to limit the result to mitigation actions with a specific action type.</p>
    #[serde(rename = "actionType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub action_type: Option<String>,
    /// <p>The maximum number of results to return at one time. The default is 25.</p>
    #[serde(rename = "maxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>The token for the next set of results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListMitigationActionsResponse {
    /// <p>A set of actions that matched the specified filter criteria.</p>
    #[serde(rename = "actionIdentifiers")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub action_identifiers: Option<Vec<MitigationActionIdentifier>>,
    /// <p>The token for the next set of results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListOTAUpdatesRequest {
    /// <p>The maximum number of results to return at one time.</p>
    #[serde(rename = "maxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>A token used to retrieve the next set of results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The OTA update job status.</p>
    #[serde(rename = "otaUpdateStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub ota_update_status: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListOTAUpdatesResponse {
    /// <p>A token to use to get the next set of results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>A list of OTA update jobs.</p>
    #[serde(rename = "otaUpdates")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub ota_updates: Option<Vec<OTAUpdateSummary>>,
}

/// <p>The input to the ListOutgoingCertificates operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListOutgoingCertificatesRequest {
    /// <p>Specifies the order for results. If True, the results are returned in ascending order, based on the creation date.</p>
    #[serde(rename = "ascendingOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub ascending_order: Option<bool>,
    /// <p>The marker for the next set of results.</p>
    #[serde(rename = "marker")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub marker: Option<String>,
    /// <p>The result page size.</p>
    #[serde(rename = "pageSize")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub page_size: Option<i64>,
}

/// <p>The output from the ListOutgoingCertificates operation.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListOutgoingCertificatesResponse {
    /// <p>The marker for the next set of results.</p>
    #[serde(rename = "nextMarker")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_marker: Option<String>,
    /// <p>The certificates that are being transferred but not yet accepted.</p>
    #[serde(rename = "outgoingCertificates")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub outgoing_certificates: Option<Vec<OutgoingCertificate>>,
}

/// <p>The input for the ListPolicies operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListPoliciesRequest {
    /// <p>Specifies the order for results. If true, the results are returned in ascending creation order.</p>
    #[serde(rename = "ascendingOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub ascending_order: Option<bool>,
    /// <p>The marker for the next set of results.</p>
    #[serde(rename = "marker")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub marker: Option<String>,
    /// <p>The result page size.</p>
    #[serde(rename = "pageSize")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub page_size: Option<i64>,
}

/// <p>The output from the ListPolicies operation.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListPoliciesResponse {
    /// <p>The marker for the next set of results, or null if there are no additional results.</p>
    #[serde(rename = "nextMarker")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_marker: Option<String>,
    /// <p>The descriptions of the policies.</p>
    #[serde(rename = "policies")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub policies: Option<Vec<Policy>>,
}

/// <p>The input for the ListPolicyPrincipals operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListPolicyPrincipalsRequest {
    /// <p>Specifies the order for results. If true, the results are returned in ascending creation order.</p>
    #[serde(rename = "ascendingOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub ascending_order: Option<bool>,
    /// <p>The marker for the next set of results.</p>
    #[serde(rename = "marker")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub marker: Option<String>,
    /// <p>The result page size.</p>
    #[serde(rename = "pageSize")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub page_size: Option<i64>,
    /// <p>The policy name.</p>
    #[serde(rename = "policyName")]
    pub policy_name: String,
}

/// <p>The output from the ListPolicyPrincipals operation.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListPolicyPrincipalsResponse {
    /// <p>The marker for the next set of results, or null if there are no additional results.</p>
    #[serde(rename = "nextMarker")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_marker: Option<String>,
    /// <p>The descriptions of the principals.</p>
    #[serde(rename = "principals")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub principals: Option<Vec<String>>,
}

/// <p>The input for the ListPolicyVersions operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListPolicyVersionsRequest {
    /// <p>The policy name.</p>
    #[serde(rename = "policyName")]
    pub policy_name: String,
}

/// <p>The output from the ListPolicyVersions operation.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListPolicyVersionsResponse {
    /// <p>The policy versions.</p>
    #[serde(rename = "policyVersions")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub policy_versions: Option<Vec<PolicyVersion>>,
}

/// <p>The input for the ListPrincipalPolicies operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListPrincipalPoliciesRequest {
    /// <p>Specifies the order for results. If true, results are returned in ascending creation order.</p>
    #[serde(rename = "ascendingOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub ascending_order: Option<bool>,
    /// <p>The marker for the next set of results.</p>
    #[serde(rename = "marker")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub marker: Option<String>,
    /// <p>The result page size.</p>
    #[serde(rename = "pageSize")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub page_size: Option<i64>,
    /// <p>The principal. Valid principals are CertificateArn (arn:aws:iot:<i>region</i>:<i>accountId</i>:cert/<i>certificateId</i>), thingGroupArn (arn:aws:iot:<i>region</i>:<i>accountId</i>:thinggroup/<i>groupName</i>) and CognitoId (<i>region</i>:<i>id</i>).</p>
    #[serde(rename = "principal")]
    pub principal: String,
}

/// <p>The output from the ListPrincipalPolicies operation.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListPrincipalPoliciesResponse {
    /// <p>The marker for the next set of results, or null if there are no additional results.</p>
    #[serde(rename = "nextMarker")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_marker: Option<String>,
    /// <p>The policies.</p>
    #[serde(rename = "policies")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub policies: Option<Vec<Policy>>,
}

/// <p>The input for the ListPrincipalThings operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListPrincipalThingsRequest {
    /// <p>The maximum number of results to return in this operation.</p>
    #[serde(rename = "maxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The principal.</p>
    #[serde(rename = "principal")]
    pub principal: String,
}

/// <p>The output from the ListPrincipalThings operation.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListPrincipalThingsResponse {
    /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The things.</p>
    #[serde(rename = "things")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub things: Option<Vec<String>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListProvisioningTemplateVersionsRequest {
    /// <p>The maximum number of results to return at one time.</p>
    #[serde(rename = "maxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>A token to retrieve the next set of results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The name of the fleet provisioning template.</p>
    #[serde(rename = "templateName")]
    pub template_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListProvisioningTemplateVersionsResponse {
    /// <p>A token to retrieve the next set of results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The list of fleet provisioning template versions.</p>
    #[serde(rename = "versions")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub versions: Option<Vec<ProvisioningTemplateVersionSummary>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListProvisioningTemplatesRequest {
    /// <p>The maximum number of results to return at one time.</p>
    #[serde(rename = "maxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>A token to retrieve the next set of results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListProvisioningTemplatesResponse {
    /// <p>A token to retrieve the next set of results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>A list of fleet provisioning templates</p>
    #[serde(rename = "templates")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub templates: Option<Vec<ProvisioningTemplateSummary>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListRoleAliasesRequest {
    /// <p>Return the list of role aliases in ascending alphabetical order.</p>
    #[serde(rename = "ascendingOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub ascending_order: Option<bool>,
    /// <p>A marker used to get the next set of results.</p>
    #[serde(rename = "marker")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub marker: Option<String>,
    /// <p>The maximum number of results to return at one time.</p>
    #[serde(rename = "pageSize")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub page_size: Option<i64>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListRoleAliasesResponse {
    /// <p>A marker used to get the next set of results.</p>
    #[serde(rename = "nextMarker")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_marker: Option<String>,
    /// <p>The role aliases.</p>
    #[serde(rename = "roleAliases")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub role_aliases: Option<Vec<String>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListScheduledAuditsRequest {
    /// <p>The maximum number of results to return at one time. The default is 25.</p>
    #[serde(rename = "maxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>The token for the next set of results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListScheduledAuditsResponse {
    /// <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The list of scheduled audits.</p>
    #[serde(rename = "scheduledAudits")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub scheduled_audits: Option<Vec<ScheduledAuditMetadata>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListSecurityProfilesForTargetRequest {
    /// <p>The maximum number of results to return at one time.</p>
    #[serde(rename = "maxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>The token for the next set of results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>If true, return child groups too.</p>
    #[serde(rename = "recursive")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub recursive: Option<bool>,
    /// <p>The ARN of the target (thing group) whose attached security profiles you want to get.</p>
    #[serde(rename = "securityProfileTargetArn")]
    pub security_profile_target_arn: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListSecurityProfilesForTargetResponse {
    /// <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>A list of security profiles and their associated targets.</p>
    #[serde(rename = "securityProfileTargetMappings")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub security_profile_target_mappings: Option<Vec<SecurityProfileTargetMapping>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListSecurityProfilesRequest {
    /// <p>A filter to limit results to the security profiles that use the defined dimension. Cannot be used with <code>metricName</code> </p>
    #[serde(rename = "dimensionName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub dimension_name: Option<String>,
    /// <p>The maximum number of results to return at one time.</p>
    #[serde(rename = "maxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p> The name of the custom metric. Cannot be used with <code>dimensionName</code>. </p>
    #[serde(rename = "metricName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metric_name: Option<String>,
    /// <p>The token for the next set of results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListSecurityProfilesResponse {
    /// <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>A list of security profile identifiers (names and ARNs).</p>
    #[serde(rename = "securityProfileIdentifiers")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub security_profile_identifiers: Option<Vec<SecurityProfileIdentifier>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListStreamsRequest {
    /// <p>Set to true to return the list of streams in ascending order.</p>
    #[serde(rename = "ascendingOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub ascending_order: Option<bool>,
    /// <p>The maximum number of results to return at a time.</p>
    #[serde(rename = "maxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>A token used to get the next set of results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListStreamsResponse {
    /// <p>A token used to get the next set of results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>A list of streams.</p>
    #[serde(rename = "streams")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub streams: Option<Vec<StreamSummary>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListTagsForResourceRequest {
    /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The ARN of the resource.</p>
    #[serde(rename = "resourceArn")]
    pub resource_arn: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListTagsForResourceResponse {
    /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The list of tags assigned to the resource.</p>
    #[serde(rename = "tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListTargetsForPolicyRequest {
    /// <p>A marker used to get the next set of results.</p>
    #[serde(rename = "marker")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub marker: Option<String>,
    /// <p>The maximum number of results to return at one time.</p>
    #[serde(rename = "pageSize")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub page_size: Option<i64>,
    /// <p>The policy name.</p>
    #[serde(rename = "policyName")]
    pub policy_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListTargetsForPolicyResponse {
    /// <p>A marker used to get the next set of results.</p>
    #[serde(rename = "nextMarker")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_marker: Option<String>,
    /// <p>The policy targets.</p>
    #[serde(rename = "targets")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub targets: Option<Vec<String>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListTargetsForSecurityProfileRequest {
    /// <p>The maximum number of results to return at one time.</p>
    #[serde(rename = "maxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>The token for the next set of results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The security profile.</p>
    #[serde(rename = "securityProfileName")]
    pub security_profile_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListTargetsForSecurityProfileResponse {
    /// <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The thing groups to which the security profile is attached.</p>
    #[serde(rename = "securityProfileTargets")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub security_profile_targets: Option<Vec<SecurityProfileTarget>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListThingGroupsForThingRequest {
    /// <p>The maximum number of results to return at one time.</p>
    #[serde(rename = "maxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The thing name.</p>
    #[serde(rename = "thingName")]
    pub thing_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListThingGroupsForThingResponse {
    /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The thing groups.</p>
    #[serde(rename = "thingGroups")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_groups: Option<Vec<GroupNameAndArn>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListThingGroupsRequest {
    /// <p>The maximum number of results to return at one time.</p>
    #[serde(rename = "maxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>A filter that limits the results to those with the specified name prefix.</p>
    #[serde(rename = "namePrefixFilter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name_prefix_filter: Option<String>,
    /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>A filter that limits the results to those with the specified parent group.</p>
    #[serde(rename = "parentGroup")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub parent_group: Option<String>,
    /// <p>If true, return child groups as well.</p>
    #[serde(rename = "recursive")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub recursive: Option<bool>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListThingGroupsResponse {
    /// <p>The token to use to get the next set of results. Will not be returned if operation has returned all results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The thing groups.</p>
    #[serde(rename = "thingGroups")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_groups: Option<Vec<GroupNameAndArn>>,
}

/// <p>The input for the ListThingPrincipal operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListThingPrincipalsRequest {
    /// <p>The maximum number of results to return in this operation.</p>
    #[serde(rename = "maxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The name of the thing.</p>
    #[serde(rename = "thingName")]
    pub thing_name: String,
}

/// <p>The output from the ListThingPrincipals operation.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListThingPrincipalsResponse {
    /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The principals associated with the thing.</p>
    #[serde(rename = "principals")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub principals: Option<Vec<String>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListThingRegistrationTaskReportsRequest {
    /// <p>The maximum number of results to return per request.</p>
    #[serde(rename = "maxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The type of task report.</p>
    #[serde(rename = "reportType")]
    pub report_type: String,
    /// <p>The id of the task.</p>
    #[serde(rename = "taskId")]
    pub task_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListThingRegistrationTaskReportsResponse {
    /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The type of task report.</p>
    #[serde(rename = "reportType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub report_type: Option<String>,
    /// <p>Links to the task resources.</p>
    #[serde(rename = "resourceLinks")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub resource_links: Option<Vec<String>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListThingRegistrationTasksRequest {
    /// <p>The maximum number of results to return at one time.</p>
    #[serde(rename = "maxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The status of the bulk thing provisioning task.</p>
    #[serde(rename = "status")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListThingRegistrationTasksResponse {
    /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>A list of bulk thing provisioning task IDs.</p>
    #[serde(rename = "taskIds")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub task_ids: Option<Vec<String>>,
}

/// <p>The input for the ListThingTypes operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListThingTypesRequest {
    /// <p>The maximum number of results to return in this operation.</p>
    #[serde(rename = "maxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The name of the thing type.</p>
    #[serde(rename = "thingTypeName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_type_name: Option<String>,
}

/// <p>The output for the ListThingTypes operation.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListThingTypesResponse {
    /// <p>The token for the next set of results. Will not be returned if operation has returned all results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The thing types.</p>
    #[serde(rename = "thingTypes")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_types: Option<Vec<ThingTypeDefinition>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListThingsInBillingGroupRequest {
    /// <p>The name of the billing group.</p>
    #[serde(rename = "billingGroupName")]
    pub billing_group_name: String,
    /// <p>The maximum number of results to return per request.</p>
    #[serde(rename = "maxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListThingsInBillingGroupResponse {
    /// <p>The token to use to get the next set of results. Will not be returned if operation has returned all results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>A list of things in the billing group.</p>
    #[serde(rename = "things")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub things: Option<Vec<String>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListThingsInThingGroupRequest {
    /// <p>The maximum number of results to return at one time.</p>
    #[serde(rename = "maxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>When true, list things in this thing group and in all child groups as well.</p>
    #[serde(rename = "recursive")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub recursive: Option<bool>,
    /// <p>The thing group name.</p>
    #[serde(rename = "thingGroupName")]
    pub thing_group_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListThingsInThingGroupResponse {
    /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The things in the specified thing group.</p>
    #[serde(rename = "things")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub things: Option<Vec<String>>,
}

/// <p>The input for the ListThings operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListThingsRequest {
    /// <p>The attribute name used to search for things.</p>
    #[serde(rename = "attributeName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub attribute_name: Option<String>,
    /// <p>The attribute value used to search for things.</p>
    #[serde(rename = "attributeValue")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub attribute_value: Option<String>,
    /// <p>The maximum number of results to return in this operation.</p>
    #[serde(rename = "maxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The name of the thing type used to search for things.</p>
    #[serde(rename = "thingTypeName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_type_name: Option<String>,
    /// <p>When <code>true</code>, the action returns the thing resources with attribute values that start with the <code>attributeValue</code> provided.</p> <p>When <code>false</code>, or not present, the action returns only the thing resources with attribute values that match the entire <code>attributeValue</code> provided. </p>
    #[serde(rename = "usePrefixAttributeValue")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub use_prefix_attribute_value: Option<bool>,
}

/// <p>The output from the ListThings operation.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListThingsResponse {
    /// <p>The token to use to get the next set of results. Will not be returned if operation has returned all results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The things.</p>
    #[serde(rename = "things")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub things: Option<Vec<ThingAttribute>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListTopicRuleDestinationsRequest {
    /// <p>The maximum number of results to return at one time.</p>
    #[serde(rename = "maxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListTopicRuleDestinationsResponse {
    /// <p>Information about a topic rule destination.</p>
    #[serde(rename = "destinationSummaries")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub destination_summaries: Option<Vec<TopicRuleDestinationSummary>>,
    /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

/// <p>The input for the ListTopicRules operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListTopicRulesRequest {
    /// <p>The maximum number of results to return.</p>
    #[serde(rename = "maxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>Specifies whether the rule is disabled.</p>
    #[serde(rename = "ruleDisabled")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub rule_disabled: Option<bool>,
    /// <p>The topic.</p>
    #[serde(rename = "topic")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub topic: Option<String>,
}

/// <p>The output from the ListTopicRules operation.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListTopicRulesResponse {
    /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The rules.</p>
    #[serde(rename = "rules")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub rules: Option<Vec<TopicRuleListItem>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListV2LoggingLevelsRequest {
    /// <p>The maximum number of results to return at one time.</p>
    #[serde(rename = "maxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The type of resource for which you are configuring logging. Must be <code>THING_Group</code>.</p>
    #[serde(rename = "targetType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub target_type: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListV2LoggingLevelsResponse {
    /// <p>The logging configuration for a target.</p>
    #[serde(rename = "logTargetConfigurations")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub log_target_configurations: Option<Vec<LogTargetConfiguration>>,
    /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListViolationEventsRequest {
    /// <p> The criteria for a behavior. </p>
    #[serde(rename = "behaviorCriteriaType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub behavior_criteria_type: Option<String>,
    /// <p>The end time for the alerts to be listed.</p>
    #[serde(rename = "endTime")]
    pub end_time: f64,
    /// <p> A list of all suppressed alerts. </p>
    #[serde(rename = "listSuppressedAlerts")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub list_suppressed_alerts: Option<bool>,
    /// <p>The maximum number of results to return at one time.</p>
    #[serde(rename = "maxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>The token for the next set of results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>A filter to limit results to those alerts generated by the specified security profile.</p>
    #[serde(rename = "securityProfileName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub security_profile_name: Option<String>,
    /// <p>The start time for the alerts to be listed.</p>
    #[serde(rename = "startTime")]
    pub start_time: f64,
    /// <p>A filter to limit results to those alerts caused by the specified thing.</p>
    #[serde(rename = "thingName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_name: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListViolationEventsResponse {
    /// <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The security profile violation alerts issued for this account during the given time period, potentially filtered by security profile, behavior violated, or thing (device) violating.</p>
    #[serde(rename = "violationEvents")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub violation_events: Option<Vec<ViolationEvent>>,
}

/// <p>A log target.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct LogTarget {
    /// <p>The target name.</p>
    #[serde(rename = "targetName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub target_name: Option<String>,
    /// <p>The target type.</p>
    #[serde(rename = "targetType")]
    pub target_type: String,
}

/// <p>The target configuration.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct LogTargetConfiguration {
    /// <p>The logging level.</p>
    #[serde(rename = "logLevel")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub log_level: Option<String>,
    /// <p>A log target</p>
    #[serde(rename = "logTarget")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub log_target: Option<LogTarget>,
}

/// <p>Describes the logging options payload.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct LoggingOptionsPayload {
    /// <p>The log level.</p>
    #[serde(rename = "logLevel")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub log_level: Option<String>,
    /// <p>The ARN of the IAM role that grants access.</p>
    #[serde(rename = "roleArn")]
    pub role_arn: String,
}

/// <p> The configuration of an ML Detect Security Profile. </p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct MachineLearningDetectionConfig {
    /// <p> The sensitivity of anomalous behavior evaluation. Can be <code>Low</code>, <code>Medium</code>, or <code>High</code>. </p>
    #[serde(rename = "confidenceLevel")]
    pub confidence_level: String,
}

/// <p>The dimension of a metric.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct MetricDimension {
    /// <p>A unique identifier for the dimension.</p>
    #[serde(rename = "dimensionName")]
    pub dimension_name: String,
    /// <p>Defines how the <code>dimensionValues</code> of a dimension are interpreted. For example, for dimension type TOPIC_FILTER, the <code>IN</code> operator, a message will be counted only if its topic matches one of the topic filters. With <code>NOT_IN</code> operator, a message will be counted only if it doesn't match any of the topic filters. The operator is optional: if it's not provided (is <code>null</code>), it will be interpreted as <code>IN</code>.</p>
    #[serde(rename = "operator")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub operator: Option<String>,
}

/// <p>The metric you want to retain. Dimensions are optional.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct MetricToRetain {
    /// <p>What is measured by the behavior.</p>
    #[serde(rename = "metric")]
    pub metric: String,
    /// <p>The dimension of a metric. This can't be used with custom metrics.</p>
    #[serde(rename = "metricDimension")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metric_dimension: Option<MetricDimension>,
}

/// <p>The value to be compared with the <code>metric</code>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct MetricValue {
    /// <p>If the <code>comparisonOperator</code> calls for a set of CIDRs, use this to specify that set to be compared with the <code>metric</code>.</p>
    #[serde(rename = "cidrs")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub cidrs: Option<Vec<String>>,
    /// <p>If the <code>comparisonOperator</code> calls for a numeric value, use this to specify that numeric value to be compared with the <code>metric</code>.</p>
    #[serde(rename = "count")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub count: Option<i64>,
    /// <p> The numeral value of a metric. </p>
    #[serde(rename = "number")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub number: Option<f64>,
    /// <p> The numeral values of a metric. </p>
    #[serde(rename = "numbers")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub numbers: Option<Vec<f64>>,
    /// <p>If the <code>comparisonOperator</code> calls for a set of ports, use this to specify that set to be compared with the <code>metric</code>.</p>
    #[serde(rename = "ports")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub ports: Option<Vec<i64>>,
    /// <p> The string values of a metric. </p>
    #[serde(rename = "strings")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub strings: Option<Vec<String>>,
}

/// <p>Describes which changes should be applied as part of a mitigation action.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct MitigationAction {
    /// <p>The set of parameters for this mitigation action. The parameters vary, depending on the kind of action you apply.</p>
    #[serde(rename = "actionParams")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub action_params: Option<MitigationActionParams>,
    /// <p>A unique identifier for the mitigation action.</p>
    #[serde(rename = "id")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    /// <p>A user-friendly name for the mitigation action.</p>
    #[serde(rename = "name")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    /// <p>The IAM role ARN used to apply this mitigation action.</p>
    #[serde(rename = "roleArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub role_arn: Option<String>,
}

/// <p>Information that identifies a mitigation action. This information is returned by ListMitigationActions.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct MitigationActionIdentifier {
    /// <p>The IAM role ARN used to apply this mitigation action.</p>
    #[serde(rename = "actionArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub action_arn: Option<String>,
    /// <p>The friendly name of the mitigation action.</p>
    #[serde(rename = "actionName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub action_name: Option<String>,
    /// <p>The date when this mitigation action was created.</p>
    #[serde(rename = "creationDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_date: Option<f64>,
}

/// <p>The set of parameters for this mitigation action. You can specify only one type of parameter (in other words, you can apply only one action for each defined mitigation action).</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct MitigationActionParams {
    /// <p>Parameters to define a mitigation action that moves devices associated with a certificate to one or more specified thing groups, typically for quarantine.</p>
    #[serde(rename = "addThingsToThingGroupParams")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub add_things_to_thing_group_params: Option<AddThingsToThingGroupParams>,
    /// <p>Parameters to define a mitigation action that enables AWS IoT logging at a specified level of detail.</p>
    #[serde(rename = "enableIoTLoggingParams")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub enable_io_t_logging_params: Option<EnableIoTLoggingParams>,
    /// <p>Parameters to define a mitigation action that publishes findings to Amazon Simple Notification Service (Amazon SNS. You can implement your own custom actions in response to the Amazon SNS messages.</p>
    #[serde(rename = "publishFindingToSnsParams")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub publish_finding_to_sns_params: Option<PublishFindingToSnsParams>,
    /// <p>Parameters to define a mitigation action that adds a blank policy to restrict permissions.</p>
    #[serde(rename = "replaceDefaultPolicyVersionParams")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub replace_default_policy_version_params: Option<ReplaceDefaultPolicyVersionParams>,
    /// <p>Parameters to define a mitigation action that changes the state of the CA certificate to inactive.</p>
    #[serde(rename = "updateCACertificateParams")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub update_ca_certificate_params: Option<UpdateCACertificateParams>,
    /// <p>Parameters to define a mitigation action that changes the state of the device certificate to inactive.</p>
    #[serde(rename = "updateDeviceCertificateParams")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub update_device_certificate_params: Option<UpdateDeviceCertificateParams>,
}

/// <p>Specifies the MQTT context to use for the test authorizer request</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct MqttContext {
    /// <p>The value of the <code>clientId</code> key in an MQTT authorization request.</p>
    #[serde(rename = "clientId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub client_id: Option<String>,
    /// <p>The value of the <code>password</code> key in an MQTT authorization request.</p>
    #[serde(rename = "password")]
    #[serde(
        deserialize_with = "::rusoto_core::serialization::SerdeBlob::deserialize_blob",
        serialize_with = "::rusoto_core::serialization::SerdeBlob::serialize_blob",
        default
    )]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub password: Option<bytes::Bytes>,
    /// <p>The value of the <code>username</code> key in an MQTT authorization request.</p>
    #[serde(rename = "username")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub username: Option<String>,
}

/// <p>Information about the resource that was noncompliant with the audit check.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct NonCompliantResource {
    /// <p>Other information about the noncompliant resource.</p>
    #[serde(rename = "additionalInfo")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub additional_info: Option<::std::collections::HashMap<String, String>>,
    /// <p>Information that identifies the noncompliant resource.</p>
    #[serde(rename = "resourceIdentifier")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub resource_identifier: Option<ResourceIdentifier>,
    /// <p>The type of the noncompliant resource.</p>
    #[serde(rename = "resourceType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub resource_type: Option<String>,
}

/// <p>Describes a file to be associated with an OTA update.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct OTAUpdateFile {
    /// <p>A list of name/attribute pairs.</p>
    #[serde(rename = "attributes")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub attributes: Option<::std::collections::HashMap<String, String>>,
    /// <p>The code signing method of the file.</p>
    #[serde(rename = "codeSigning")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub code_signing: Option<CodeSigning>,
    /// <p>The location of the updated firmware.</p>
    #[serde(rename = "fileLocation")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub file_location: Option<FileLocation>,
    /// <p>The name of the file.</p>
    #[serde(rename = "fileName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub file_name: Option<String>,
    /// <p>An integer value you can include in the job document to allow your devices to identify the type of file received from the cloud.</p>
    #[serde(rename = "fileType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub file_type: Option<i64>,
    /// <p>The file version.</p>
    #[serde(rename = "fileVersion")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub file_version: Option<String>,
}

/// <p>Information about an OTA update.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct OTAUpdateInfo {
    /// <p>A collection of name/value pairs</p>
    #[serde(rename = "additionalParameters")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub additional_parameters: Option<::std::collections::HashMap<String, String>>,
    /// <p>The AWS IoT job ARN associated with the OTA update.</p>
    #[serde(rename = "awsIotJobArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub aws_iot_job_arn: Option<String>,
    /// <p>The AWS IoT job ID associated with the OTA update.</p>
    #[serde(rename = "awsIotJobId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub aws_iot_job_id: Option<String>,
    /// <p>Configuration for the rollout of OTA updates.</p>
    #[serde(rename = "awsJobExecutionsRolloutConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub aws_job_executions_rollout_config: Option<AwsJobExecutionsRolloutConfig>,
    /// <p>Configuration information for pre-signed URLs. Valid when <code>protocols</code> contains HTTP.</p>
    #[serde(rename = "awsJobPresignedUrlConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub aws_job_presigned_url_config: Option<AwsJobPresignedUrlConfig>,
    /// <p>The date when the OTA update was created.</p>
    #[serde(rename = "creationDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_date: Option<f64>,
    /// <p>A description of the OTA update.</p>
    #[serde(rename = "description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// <p>Error information associated with the OTA update.</p>
    #[serde(rename = "errorInfo")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub error_info: Option<ErrorInfo>,
    /// <p>The date when the OTA update was last updated.</p>
    #[serde(rename = "lastModifiedDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_date: Option<f64>,
    /// <p>The OTA update ARN.</p>
    #[serde(rename = "otaUpdateArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub ota_update_arn: Option<String>,
    /// <p>A list of files associated with the OTA update.</p>
    #[serde(rename = "otaUpdateFiles")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub ota_update_files: Option<Vec<OTAUpdateFile>>,
    /// <p>The OTA update ID.</p>
    #[serde(rename = "otaUpdateId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub ota_update_id: Option<String>,
    /// <p>The status of the OTA update.</p>
    #[serde(rename = "otaUpdateStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub ota_update_status: Option<String>,
    /// <p>The protocol used to transfer the OTA update image. Valid values are [HTTP], [MQTT], [HTTP, MQTT]. When both HTTP and MQTT are specified, the target device can choose the protocol.</p>
    #[serde(rename = "protocols")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub protocols: Option<Vec<String>>,
    /// <p>Specifies whether the OTA update will continue to run (CONTINUOUS), or will be complete after all those things specified as targets have completed the OTA update (SNAPSHOT). If continuous, the OTA update may also be run on a thing when a change is detected in a target. For example, an OTA update will run on a thing when the thing is added to a target group, even after the OTA update was completed by all things originally in the group. </p>
    #[serde(rename = "targetSelection")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub target_selection: Option<String>,
    /// <p>The targets of the OTA update.</p>
    #[serde(rename = "targets")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub targets: Option<Vec<String>>,
}

/// <p>An OTA update summary.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct OTAUpdateSummary {
    /// <p>The date when the OTA update was created.</p>
    #[serde(rename = "creationDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_date: Option<f64>,
    /// <p>The OTA update ARN.</p>
    #[serde(rename = "otaUpdateArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub ota_update_arn: Option<String>,
    /// <p>The OTA update ID.</p>
    #[serde(rename = "otaUpdateId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub ota_update_id: Option<String>,
}

/// <p>A certificate that has been transferred but not yet accepted.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct OutgoingCertificate {
    /// <p>The certificate ARN.</p>
    #[serde(rename = "certificateArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub certificate_arn: Option<String>,
    /// <p>The certificate ID.</p>
    #[serde(rename = "certificateId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub certificate_id: Option<String>,
    /// <p>The certificate creation date.</p>
    #[serde(rename = "creationDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_date: Option<f64>,
    /// <p>The date the transfer was initiated.</p>
    #[serde(rename = "transferDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub transfer_date: Option<f64>,
    /// <p>The transfer message.</p>
    #[serde(rename = "transferMessage")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub transfer_message: Option<String>,
    /// <p>The AWS account to which the transfer was made.</p>
    #[serde(rename = "transferredTo")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub transferred_to: Option<String>,
}

/// <p>Describes the percentile and percentile value.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct PercentPair {
    /// <p>The percentile.</p>
    #[serde(rename = "percent")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub percent: Option<f64>,
    /// <p>The value of the percentile.</p>
    #[serde(rename = "value")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub value: Option<f64>,
}

/// <p>Describes an AWS IoT policy.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct Policy {
    /// <p>The policy ARN.</p>
    #[serde(rename = "policyArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub policy_arn: Option<String>,
    /// <p>The policy name.</p>
    #[serde(rename = "policyName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub policy_name: Option<String>,
}

/// <p>Describes a policy version.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct PolicyVersion {
    /// <p>The date and time the policy was created.</p>
    #[serde(rename = "createDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub create_date: Option<f64>,
    /// <p>Specifies whether the policy version is the default.</p>
    #[serde(rename = "isDefaultVersion")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub is_default_version: Option<bool>,
    /// <p>The policy version ID.</p>
    #[serde(rename = "versionId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub version_id: Option<String>,
}

/// <p>Information about the version of the policy associated with the resource.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct PolicyVersionIdentifier {
    /// <p>The name of the policy.</p>
    #[serde(rename = "policyName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub policy_name: Option<String>,
    /// <p>The ID of the version of the policy associated with the resource.</p>
    #[serde(rename = "policyVersionId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub policy_version_id: Option<String>,
}

/// <p>Configuration for pre-signed S3 URLs.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct PresignedUrlConfig {
    /// <p>How long (in seconds) pre-signed URLs are valid. Valid values are 60 - 3600, the default value is 3600 seconds. Pre-signed URLs are generated when Jobs receives an MQTT request for the job document.</p>
    #[serde(rename = "expiresInSec")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub expires_in_sec: Option<i64>,
    /// <p>The ARN of an IAM role that grants grants permission to download files from the S3 bucket where the job data/updates are stored. The role must also grant permission for IoT to download the files.</p>
    #[serde(rename = "roleArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub role_arn: Option<String>,
}

/// <p>Structure that contains <code>payloadVersion</code> and <code>targetArn</code>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ProvisioningHook {
    /// <p>The payload that was sent to the target function.</p> <p> <i>Note:</i> Only Lambda functions are currently supported.</p>
    #[serde(rename = "payloadVersion")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub payload_version: Option<String>,
    /// <p>The ARN of the target function.</p> <p> <i>Note:</i> Only Lambda functions are currently supported.</p>
    #[serde(rename = "targetArn")]
    pub target_arn: String,
}

/// <p>A summary of information about a fleet provisioning template.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ProvisioningTemplateSummary {
    /// <p>The date when the fleet provisioning template summary was created.</p>
    #[serde(rename = "creationDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_date: Option<f64>,
    /// <p>The description of the fleet provisioning template.</p>
    #[serde(rename = "description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// <p>True if the fleet provision template is enabled, otherwise false.</p>
    #[serde(rename = "enabled")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
    /// <p>The date when the fleet provisioning template summary was last modified.</p>
    #[serde(rename = "lastModifiedDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_date: Option<f64>,
    /// <p>The ARN of the fleet provisioning template.</p>
    #[serde(rename = "templateArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub template_arn: Option<String>,
    /// <p>The name of the fleet provisioning template.</p>
    #[serde(rename = "templateName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub template_name: Option<String>,
}

/// <p>A summary of information about a fleet provision template version.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ProvisioningTemplateVersionSummary {
    /// <p>The date when the fleet provisioning template version was created</p>
    #[serde(rename = "creationDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_date: Option<f64>,
    /// <p>True if the fleet provisioning template version is the default version, otherwise false.</p>
    #[serde(rename = "isDefaultVersion")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub is_default_version: Option<bool>,
    /// <p>The ID of the fleet privisioning template version.</p>
    #[serde(rename = "versionId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub version_id: Option<i64>,
}

/// <p>Parameters to define a mitigation action that publishes findings to Amazon SNS. You can implement your own custom actions in response to the Amazon SNS messages.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct PublishFindingToSnsParams {
    /// <p>The ARN of the topic to which you want to publish the findings.</p>
    #[serde(rename = "topicArn")]
    pub topic_arn: String,
}

/// <p>An asset property value entry containing the following information.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct PutAssetPropertyValueEntry {
    /// <p>The ID of the AWS IoT SiteWise asset. You must specify either a <code>propertyAlias</code> or both an <code>aliasId</code> and a <code>propertyId</code>. Accepts substitution templates.</p>
    #[serde(rename = "assetId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub asset_id: Option<String>,
    /// <p>Optional. A unique identifier for this entry that you can define to better track which message caused an error in case of failure. Accepts substitution templates. Defaults to a new UUID.</p>
    #[serde(rename = "entryId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub entry_id: Option<String>,
    /// <p>The name of the property alias associated with your asset property. You must specify either a <code>propertyAlias</code> or both an <code>aliasId</code> and a <code>propertyId</code>. Accepts substitution templates.</p>
    #[serde(rename = "propertyAlias")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub property_alias: Option<String>,
    /// <p>The ID of the asset's property. You must specify either a <code>propertyAlias</code> or both an <code>aliasId</code> and a <code>propertyId</code>. Accepts substitution templates.</p>
    #[serde(rename = "propertyId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub property_id: Option<String>,
    /// <p>A list of property values to insert that each contain timestamp, quality, and value (TQV) information.</p>
    #[serde(rename = "propertyValues")]
    pub property_values: Vec<AssetPropertyValue>,
}

/// <p>The input for the DynamoActionVS action that specifies the DynamoDB table to which the message data will be written.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct PutItemInput {
    /// <p>The table where the message data will be written.</p>
    #[serde(rename = "tableName")]
    pub table_name: String,
}

/// <p>Allows you to define a criteria to initiate the increase in rate of rollout for a job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct RateIncreaseCriteria {
    /// <p>The threshold for number of notified things that will initiate the increase in rate of rollout.</p>
    #[serde(rename = "numberOfNotifiedThings")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub number_of_notified_things: Option<i64>,
    /// <p>The threshold for number of succeeded things that will initiate the increase in rate of rollout.</p>
    #[serde(rename = "numberOfSucceededThings")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub number_of_succeeded_things: Option<i64>,
}

/// <p>The input to the RegisterCACertificate operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct RegisterCACertificateRequest {
    /// <p>Allows this CA certificate to be used for auto registration of device certificates.</p>
    #[serde(rename = "allowAutoRegistration")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub allow_auto_registration: Option<bool>,
    /// <p>The CA certificate.</p>
    #[serde(rename = "caCertificate")]
    pub ca_certificate: String,
    /// <p>Information about the registration configuration.</p>
    #[serde(rename = "registrationConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub registration_config: Option<RegistrationConfig>,
    /// <p>A boolean value that specifies if the CA certificate is set to active.</p>
    #[serde(rename = "setAsActive")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub set_as_active: Option<bool>,
    /// <p><p>Metadata which can be used to manage the CA certificate.</p> <note> <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p> <p>For the CLI command-line parameter use format: &amp;&amp;tags &quot;key1=value1&amp;key2=value2...&quot;</p> <p>For the cli-input-json file use format: &quot;tags&quot;: &quot;key1=value1&amp;key2=value2...&quot;</p> </note></p>
    #[serde(rename = "tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
    /// <p>The private key verification certificate.</p>
    #[serde(rename = "verificationCertificate")]
    pub verification_certificate: String,
}

/// <p>The output from the RegisterCACertificateResponse operation.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct RegisterCACertificateResponse {
    /// <p>The CA certificate ARN.</p>
    #[serde(rename = "certificateArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub certificate_arn: Option<String>,
    /// <p>The CA certificate identifier.</p>
    #[serde(rename = "certificateId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub certificate_id: Option<String>,
}

/// <p>The input to the RegisterCertificate operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct RegisterCertificateRequest {
    /// <p>The CA certificate used to sign the device certificate being registered.</p>
    #[serde(rename = "caCertificatePem")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub ca_certificate_pem: Option<String>,
    /// <p>The certificate data, in PEM format.</p>
    #[serde(rename = "certificatePem")]
    pub certificate_pem: String,
    /// <p>The status of the register certificate request.</p>
    #[serde(rename = "status")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
}

/// <p>The output from the RegisterCertificate operation.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct RegisterCertificateResponse {
    /// <p>The certificate ARN.</p>
    #[serde(rename = "certificateArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub certificate_arn: Option<String>,
    /// <p>The certificate identifier.</p>
    #[serde(rename = "certificateId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub certificate_id: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct RegisterCertificateWithoutCARequest {
    /// <p>The certificate data, in PEM format.</p>
    #[serde(rename = "certificatePem")]
    pub certificate_pem: String,
    /// <p>The status of the register certificate request.</p>
    #[serde(rename = "status")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct RegisterCertificateWithoutCAResponse {
    /// <p>The Amazon Resource Name (ARN) of the registered certificate.</p>
    #[serde(rename = "certificateArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub certificate_arn: Option<String>,
    /// <p>The ID of the registered certificate. (The last part of the certificate ARN contains the certificate ID.</p>
    #[serde(rename = "certificateId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub certificate_id: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct RegisterThingRequest {
    /// <p>The parameters for provisioning a thing. See <a href="https://docs.aws.amazon.com/iot/latest/developerguide/provision-template.html">Provisioning Templates</a> for more information.</p>
    #[serde(rename = "parameters")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub parameters: Option<::std::collections::HashMap<String, String>>,
    /// <p>The provisioning template. See <a href="https://docs.aws.amazon.com/iot/latest/developerguide/provision-w-cert.html">Provisioning Devices That Have Device Certificates</a> for more information.</p>
    #[serde(rename = "templateBody")]
    pub template_body: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct RegisterThingResponse {
    /// <p>The certificate data, in PEM format.</p>
    #[serde(rename = "certificatePem")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub certificate_pem: Option<String>,
    /// <p>ARNs for the generated resources.</p>
    #[serde(rename = "resourceArns")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub resource_arns: Option<::std::collections::HashMap<String, String>>,
}

/// <p>The registration configuration.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct RegistrationConfig {
    /// <p>The ARN of the role.</p>
    #[serde(rename = "roleArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub role_arn: Option<String>,
    /// <p>The template body.</p>
    #[serde(rename = "templateBody")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub template_body: Option<String>,
}

/// <p>The input for the RejectCertificateTransfer operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct RejectCertificateTransferRequest {
    /// <p>The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)</p>
    #[serde(rename = "certificateId")]
    pub certificate_id: String,
    /// <p>The reason the certificate transfer was rejected.</p>
    #[serde(rename = "rejectReason")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub reject_reason: Option<String>,
}

/// <p>Information about a related resource.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct RelatedResource {
    /// <p>Other information about the resource.</p>
    #[serde(rename = "additionalInfo")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub additional_info: Option<::std::collections::HashMap<String, String>>,
    /// <p>Information that identifies the resource.</p>
    #[serde(rename = "resourceIdentifier")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub resource_identifier: Option<ResourceIdentifier>,
    /// <p>The type of resource.</p>
    #[serde(rename = "resourceType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub resource_type: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct RemoveThingFromBillingGroupRequest {
    /// <p>The ARN of the billing group.</p>
    #[serde(rename = "billingGroupArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub billing_group_arn: Option<String>,
    /// <p>The name of the billing group.</p>
    #[serde(rename = "billingGroupName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub billing_group_name: Option<String>,
    /// <p>The ARN of the thing to be removed from the billing group.</p>
    #[serde(rename = "thingArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_arn: Option<String>,
    /// <p>The name of the thing to be removed from the billing group.</p>
    #[serde(rename = "thingName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_name: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct RemoveThingFromBillingGroupResponse {}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct RemoveThingFromThingGroupRequest {
    /// <p>The ARN of the thing to remove from the group.</p>
    #[serde(rename = "thingArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_arn: Option<String>,
    /// <p>The group ARN.</p>
    #[serde(rename = "thingGroupArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_group_arn: Option<String>,
    /// <p>The group name.</p>
    #[serde(rename = "thingGroupName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_group_name: Option<String>,
    /// <p>The name of the thing to remove from the group.</p>
    #[serde(rename = "thingName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_name: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct RemoveThingFromThingGroupResponse {}

/// <p>Parameters to define a mitigation action that adds a blank policy to restrict permissions.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ReplaceDefaultPolicyVersionParams {
    /// <p>The name of the template to be applied. The only supported value is <code>BLANK_POLICY</code>.</p>
    #[serde(rename = "templateName")]
    pub template_name: String,
}

/// <p>The input for the ReplaceTopicRule operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ReplaceTopicRuleRequest {
    /// <p>The name of the rule.</p>
    #[serde(rename = "ruleName")]
    pub rule_name: String,
    /// <p>The rule payload.</p>
    #[serde(rename = "topicRulePayload")]
    pub topic_rule_payload: TopicRulePayload,
}

/// <p>Describes an action to republish to another topic.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct RepublishAction {
    /// <p>The Quality of Service (QoS) level to use when republishing messages. The default value is 0.</p>
    #[serde(rename = "qos")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub qos: Option<i64>,
    /// <p>The ARN of the IAM role that grants access.</p>
    #[serde(rename = "roleArn")]
    pub role_arn: String,
    /// <p>The name of the MQTT topic.</p>
    #[serde(rename = "topic")]
    pub topic: String,
}

/// <p>Information that identifies the noncompliant resource.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ResourceIdentifier {
    /// <p>The account with which the resource is associated.</p>
    #[serde(rename = "account")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub account: Option<String>,
    /// <p>The ID of the CA certificate used to authorize the certificate.</p>
    #[serde(rename = "caCertificateId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub ca_certificate_id: Option<String>,
    /// <p>The client ID.</p>
    #[serde(rename = "clientId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub client_id: Option<String>,
    /// <p>The ID of the Amazon Cognito identity pool.</p>
    #[serde(rename = "cognitoIdentityPoolId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub cognito_identity_pool_id: Option<String>,
    /// <p>The ID of the certificate attached to the resource.</p>
    #[serde(rename = "deviceCertificateId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub device_certificate_id: Option<String>,
    /// <p>The ARN of the IAM role that has overly permissive actions.</p>
    #[serde(rename = "iamRoleArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub iam_role_arn: Option<String>,
    /// <p>The version of the policy associated with the resource.</p>
    #[serde(rename = "policyVersionIdentifier")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub policy_version_identifier: Option<PolicyVersionIdentifier>,
    /// <p>The ARN of the role alias that has overly permissive actions.</p>
    #[serde(rename = "roleAliasArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub role_alias_arn: Option<String>,
}

/// <p>Role alias description.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct RoleAliasDescription {
    /// <p>The UNIX timestamp of when the role alias was created.</p>
    #[serde(rename = "creationDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_date: Option<f64>,
    /// <p>The number of seconds for which the credential is valid.</p>
    #[serde(rename = "credentialDurationSeconds")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub credential_duration_seconds: Option<i64>,
    /// <p>The UNIX timestamp of when the role alias was last modified.</p>
    #[serde(rename = "lastModifiedDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_date: Option<f64>,
    /// <p>The role alias owner.</p>
    #[serde(rename = "owner")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub owner: Option<String>,
    /// <p>The role alias.</p>
    #[serde(rename = "roleAlias")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub role_alias: Option<String>,
    /// <p>The ARN of the role alias.</p>
    #[serde(rename = "roleAliasArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub role_alias_arn: Option<String>,
    /// <p>The role ARN.</p>
    #[serde(rename = "roleArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub role_arn: Option<String>,
}

/// <p>Describes an action to write data to an Amazon S3 bucket.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct S3Action {
    /// <p>The Amazon S3 bucket.</p>
    #[serde(rename = "bucketName")]
    pub bucket_name: String,
    /// <p>The Amazon S3 canned ACL that controls access to the object identified by the object key. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">S3 canned ACLs</a>.</p>
    #[serde(rename = "cannedAcl")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub canned_acl: Option<String>,
    /// <p>The object key. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/list_amazons3.html">Actions, resources, and condition keys for Amazon S3</a>.</p>
    #[serde(rename = "key")]
    pub key: String,
    /// <p>The ARN of the IAM role that grants access.</p>
    #[serde(rename = "roleArn")]
    pub role_arn: String,
}

/// <p>Describes the location of updated firmware in S3.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct S3Destination {
    /// <p>The S3 bucket that contains the updated firmware.</p>
    #[serde(rename = "bucket")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub bucket: Option<String>,
    /// <p>The S3 prefix.</p>
    #[serde(rename = "prefix")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub prefix: Option<String>,
}

/// <p>The S3 location.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct S3Location {
    /// <p>The S3 bucket.</p>
    #[serde(rename = "bucket")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub bucket: Option<String>,
    /// <p>The S3 key.</p>
    #[serde(rename = "key")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub key: Option<String>,
    /// <p>The S3 bucket version.</p>
    #[serde(rename = "version")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
}

/// <p>Describes an action to write a message to a Salesforce IoT Cloud Input Stream.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct SalesforceAction {
    /// <p>The token used to authenticate access to the Salesforce IoT Cloud Input Stream. The token is available from the Salesforce IoT Cloud platform after creation of the Input Stream.</p>
    #[serde(rename = "token")]
    pub token: String,
    /// <p>The URL exposed by the Salesforce IoT Cloud Input Stream. The URL is available from the Salesforce IoT Cloud platform after creation of the Input Stream.</p>
    #[serde(rename = "url")]
    pub url: String,
}

/// <p>Information about the scheduled audit.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ScheduledAuditMetadata {
    /// <p>The day of the month on which the scheduled audit is run (if the <code>frequency</code> is "MONTHLY"). If days 29-31 are specified, and the month does not have that many days, the audit takes place on the "LAST" day of the month.</p>
    #[serde(rename = "dayOfMonth")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub day_of_month: Option<String>,
    /// <p>The day of the week on which the scheduled audit is run (if the <code>frequency</code> is "WEEKLY" or "BIWEEKLY").</p>
    #[serde(rename = "dayOfWeek")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub day_of_week: Option<String>,
    /// <p>How often the scheduled audit occurs.</p>
    #[serde(rename = "frequency")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub frequency: Option<String>,
    /// <p>The ARN of the scheduled audit.</p>
    #[serde(rename = "scheduledAuditArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub scheduled_audit_arn: Option<String>,
    /// <p>The name of the scheduled audit.</p>
    #[serde(rename = "scheduledAuditName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub scheduled_audit_name: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct SearchIndexRequest {
    /// <p>The search index name.</p>
    #[serde(rename = "indexName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub index_name: Option<String>,
    /// <p>The maximum number of results to return at one time.</p>
    #[serde(rename = "maxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>The token used to get the next set of results, or <code>null</code> if there are no additional results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The search query string.</p>
    #[serde(rename = "queryString")]
    pub query_string: String,
    /// <p>The query version.</p>
    #[serde(rename = "queryVersion")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub query_version: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct SearchIndexResponse {
    /// <p>The token used to get the next set of results, or <code>null</code> if there are no additional results.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The thing groups that match the search query.</p>
    #[serde(rename = "thingGroups")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_groups: Option<Vec<ThingGroupDocument>>,
    /// <p>The things that match the search query.</p>
    #[serde(rename = "things")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub things: Option<Vec<ThingDocument>>,
}

/// <p>Identifying information for a Device Defender security profile.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct SecurityProfileIdentifier {
    /// <p>The ARN of the security profile.</p>
    #[serde(rename = "arn")]
    pub arn: String,
    /// <p>The name you've given to the security profile.</p>
    #[serde(rename = "name")]
    pub name: String,
}

/// <p>A target to which an alert is sent when a security profile behavior is violated.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct SecurityProfileTarget {
    /// <p>The ARN of the security profile.</p>
    #[serde(rename = "arn")]
    pub arn: String,
}

/// <p>Information about a security profile and the target associated with it.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct SecurityProfileTargetMapping {
    /// <p>Information that identifies the security profile.</p>
    #[serde(rename = "securityProfileIdentifier")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub security_profile_identifier: Option<SecurityProfileIdentifier>,
    /// <p>Information about the target (thing group) associated with the security profile.</p>
    #[serde(rename = "target")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub target: Option<SecurityProfileTarget>,
}

/// <p>An object that contains information about a server certificate.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ServerCertificateSummary {
    /// <p>The ARN of the server certificate.</p>
    #[serde(rename = "serverCertificateArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub server_certificate_arn: Option<String>,
    /// <p>The status of the server certificate.</p>
    #[serde(rename = "serverCertificateStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub server_certificate_status: Option<String>,
    /// <p>Details that explain the status of the server certificate.</p>
    #[serde(rename = "serverCertificateStatusDetail")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub server_certificate_status_detail: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct SetDefaultAuthorizerRequest {
    /// <p>The authorizer name.</p>
    #[serde(rename = "authorizerName")]
    pub authorizer_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct SetDefaultAuthorizerResponse {
    /// <p>The authorizer ARN.</p>
    #[serde(rename = "authorizerArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub authorizer_arn: Option<String>,
    /// <p>The authorizer name.</p>
    #[serde(rename = "authorizerName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub authorizer_name: Option<String>,
}

/// <p>The input for the SetDefaultPolicyVersion operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct SetDefaultPolicyVersionRequest {
    /// <p>The policy name.</p>
    #[serde(rename = "policyName")]
    pub policy_name: String,
    /// <p>The policy version ID.</p>
    #[serde(rename = "policyVersionId")]
    pub policy_version_id: String,
}

/// <p>The input for the SetLoggingOptions operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct SetLoggingOptionsRequest {
    /// <p>The logging options payload.</p>
    #[serde(rename = "loggingOptionsPayload")]
    pub logging_options_payload: LoggingOptionsPayload,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct SetV2LoggingLevelRequest {
    /// <p>The log level.</p>
    #[serde(rename = "logLevel")]
    pub log_level: String,
    /// <p>The log target.</p>
    #[serde(rename = "logTarget")]
    pub log_target: LogTarget,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct SetV2LoggingOptionsRequest {
    /// <p>The default logging level.</p>
    #[serde(rename = "defaultLogLevel")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub default_log_level: Option<String>,
    /// <p>If true all logs are disabled. The default is false.</p>
    #[serde(rename = "disableAllLogs")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub disable_all_logs: Option<bool>,
    /// <p>The ARN of the role that allows IoT to write to Cloudwatch logs.</p>
    #[serde(rename = "roleArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub role_arn: Option<String>,
}

/// <p>For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 signing process</a>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct SigV4Authorization {
    /// <p>The ARN of the signing role.</p>
    #[serde(rename = "roleArn")]
    pub role_arn: String,
    /// <p>The service name to use while signing with Sig V4.</p>
    #[serde(rename = "serviceName")]
    pub service_name: String,
    /// <p>The signing region.</p>
    #[serde(rename = "signingRegion")]
    pub signing_region: String,
}

/// <p>Describes the code-signing profile.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct SigningProfileParameter {
    /// <p>Certificate ARN.</p>
    #[serde(rename = "certificateArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub certificate_arn: Option<String>,
    /// <p>The location of the code-signing certificate on your device.</p>
    #[serde(rename = "certificatePathOnDevice")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub certificate_path_on_device: Option<String>,
    /// <p>The hardware platform of your device.</p>
    #[serde(rename = "platform")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub platform: Option<String>,
}

/// <p>Describes an action to publish to an Amazon SNS topic.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct SnsAction {
    /// <p>(Optional) The message format of the message to publish. Accepted values are "JSON" and "RAW". The default value of the attribute is "RAW". SNS uses this setting to determine if the payload should be parsed and relevant platform-specific bits of the payload should be extracted. To read more about SNS message formats, see <a href="https://docs.aws.amazon.com/sns/latest/dg/json-formats.html">https://docs.aws.amazon.com/sns/latest/dg/json-formats.html</a> refer to their official documentation.</p>
    #[serde(rename = "messageFormat")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub message_format: Option<String>,
    /// <p>The ARN of the IAM role that grants access.</p>
    #[serde(rename = "roleArn")]
    pub role_arn: String,
    /// <p>The ARN of the SNS topic.</p>
    #[serde(rename = "targetArn")]
    pub target_arn: String,
}

/// <p>Describes an action to publish data to an Amazon SQS queue.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct SqsAction {
    /// <p>The URL of the Amazon SQS queue.</p>
    #[serde(rename = "queueUrl")]
    pub queue_url: String,
    /// <p>The ARN of the IAM role that grants access.</p>
    #[serde(rename = "roleArn")]
    pub role_arn: String,
    /// <p>Specifies whether to use Base64 encoding.</p>
    #[serde(rename = "useBase64")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub use_base_64: Option<bool>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct StartAuditMitigationActionsTaskRequest {
    /// <p>For an audit check, specifies which mitigation actions to apply. Those actions must be defined in your AWS account.</p>
    #[serde(rename = "auditCheckToActionsMapping")]
    pub audit_check_to_actions_mapping: ::std::collections::HashMap<String, Vec<String>>,
    /// <p>Each audit mitigation task must have a unique client request token. If you try to start a new task with the same token as a task that already exists, an exception occurs. If you omit this value, a unique client request token is generated automatically.</p>
    #[serde(rename = "clientRequestToken")]
    pub client_request_token: String,
    /// <p>Specifies the audit findings to which the mitigation actions are applied. You can apply them to a type of audit check, to all findings from an audit, or to a specific set of findings.</p>
    #[serde(rename = "target")]
    pub target: AuditMitigationActionsTaskTarget,
    /// <p>A unique identifier for the task. You can use this identifier to check the status of the task or to cancel it.</p>
    #[serde(rename = "taskId")]
    pub task_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct StartAuditMitigationActionsTaskResponse {
    /// <p>The unique identifier for the audit mitigation task. This matches the <code>taskId</code> that you specified in the request.</p>
    #[serde(rename = "taskId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub task_id: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct StartDetectMitigationActionsTaskRequest {
    /// <p> The actions to be performed when a device has unexpected behavior. </p>
    #[serde(rename = "actions")]
    pub actions: Vec<String>,
    /// <p> Each mitigation action task must have a unique client request token. If you try to create a new task with the same token as a task that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
    #[serde(rename = "clientRequestToken")]
    pub client_request_token: String,
    /// <p> Specifies to list only active violations. </p>
    #[serde(rename = "includeOnlyActiveViolations")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub include_only_active_violations: Option<bool>,
    /// <p> Specifies to include suppressed alerts. </p>
    #[serde(rename = "includeSuppressedAlerts")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub include_suppressed_alerts: Option<bool>,
    /// <p> Specifies the ML Detect findings to which the mitigation actions are applied. </p>
    #[serde(rename = "target")]
    pub target: DetectMitigationActionsTaskTarget,
    /// <p> The unique identifier of the task. </p>
    #[serde(rename = "taskId")]
    pub task_id: String,
    /// <p> Specifies the time period of which violation events occurred between. </p>
    #[serde(rename = "violationEventOccurrenceRange")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub violation_event_occurrence_range: Option<ViolationEventOccurrenceRange>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct StartDetectMitigationActionsTaskResponse {
    /// <p> The unique identifier of the task. </p>
    #[serde(rename = "taskId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub task_id: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct StartOnDemandAuditTaskRequest {
    /// <p>Which checks are performed during the audit. The checks you specify must be enabled for your account or an exception occurs. Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.</p>
    #[serde(rename = "targetCheckNames")]
    pub target_check_names: Vec<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct StartOnDemandAuditTaskResponse {
    /// <p>The ID of the on-demand audit you started.</p>
    #[serde(rename = "taskId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub task_id: Option<String>,
}

/// <p>Information required to start a signing job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct StartSigningJobParameter {
    /// <p>The location to write the code-signed file.</p>
    #[serde(rename = "destination")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub destination: Option<Destination>,
    /// <p>The code-signing profile name.</p>
    #[serde(rename = "signingProfileName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub signing_profile_name: Option<String>,
    /// <p>Describes the code-signing profile.</p>
    #[serde(rename = "signingProfileParameter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub signing_profile_parameter: Option<SigningProfileParameter>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct StartThingRegistrationTaskRequest {
    /// <p>The S3 bucket that contains the input file.</p>
    #[serde(rename = "inputFileBucket")]
    pub input_file_bucket: String,
    /// <p>The name of input file within the S3 bucket. This file contains a newline delimited JSON file. Each line contains the parameter values to provision one device (thing).</p>
    #[serde(rename = "inputFileKey")]
    pub input_file_key: String,
    /// <p>The IAM role ARN that grants permission the input file.</p>
    #[serde(rename = "roleArn")]
    pub role_arn: String,
    /// <p>The provisioning template.</p>
    #[serde(rename = "templateBody")]
    pub template_body: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct StartThingRegistrationTaskResponse {
    /// <p>The bulk thing provisioning task ID.</p>
    #[serde(rename = "taskId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub task_id: Option<String>,
}

/// <p>A statistical ranking (percentile) that indicates a threshold value by which a behavior is determined to be in compliance or in violation of the behavior.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct StatisticalThreshold {
    /// <p>The percentile that resolves to a threshold value by which compliance with a behavior is determined. Metrics are collected over the specified period (<code>durationSeconds</code>) from all reporting devices in your account and statistical ranks are calculated. Then, the measurements from a device are collected over the same period. If the accumulated measurements from the device fall above or below (<code>comparisonOperator</code>) the value associated with the percentile specified, then the device is considered to be in compliance with the behavior, otherwise a violation occurs.</p>
    #[serde(rename = "statistic")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub statistic: Option<String>,
}

/// <p>A map of key-value pairs for all supported statistics. Currently, only count is supported.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct Statistics {
    /// <p>The average of the aggregated field values.</p>
    #[serde(rename = "average")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub average: Option<f64>,
    /// <p>The count of things that match the query.</p>
    #[serde(rename = "count")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub count: Option<i64>,
    /// <p>The maximum aggregated field value.</p>
    #[serde(rename = "maximum")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub maximum: Option<f64>,
    /// <p>The minimum aggregated field value.</p>
    #[serde(rename = "minimum")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub minimum: Option<f64>,
    /// <p>The standard deviation of the aggregated field values.</p>
    #[serde(rename = "stdDeviation")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub std_deviation: Option<f64>,
    /// <p>The sum of the aggregated field values.</p>
    #[serde(rename = "sum")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sum: Option<f64>,
    /// <p>The sum of the squares of the aggregated field values.</p>
    #[serde(rename = "sumOfSquares")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sum_of_squares: Option<f64>,
    /// <p>The variance of the aggregated field values.</p>
    #[serde(rename = "variance")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub variance: Option<f64>,
}

/// <p>Starts execution of a Step Functions state machine.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct StepFunctionsAction {
    /// <p>(Optional) A name will be given to the state machine execution consisting of this prefix followed by a UUID. Step Functions automatically creates a unique name for each state machine execution if one is not provided.</p>
    #[serde(rename = "executionNamePrefix")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub execution_name_prefix: Option<String>,
    /// <p>The ARN of the role that grants IoT permission to start execution of a state machine ("Action":"states:StartExecution").</p>
    #[serde(rename = "roleArn")]
    pub role_arn: String,
    /// <p>The name of the Step Functions state machine whose execution will be started.</p>
    #[serde(rename = "stateMachineName")]
    pub state_machine_name: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct StopThingRegistrationTaskRequest {
    /// <p>The bulk thing provisioning task ID.</p>
    #[serde(rename = "taskId")]
    pub task_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct StopThingRegistrationTaskResponse {}

/// <p>Describes a group of files that can be streamed.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct Stream {
    /// <p>The ID of a file associated with a stream.</p>
    #[serde(rename = "fileId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub file_id: Option<i64>,
    /// <p>The stream ID.</p>
    #[serde(rename = "streamId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub stream_id: Option<String>,
}

/// <p>Represents a file to stream.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct StreamFile {
    /// <p>The file ID.</p>
    #[serde(rename = "fileId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub file_id: Option<i64>,
    /// <p>The location of the file in S3.</p>
    #[serde(rename = "s3Location")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub s_3_location: Option<S3Location>,
}

/// <p>Information about a stream.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct StreamInfo {
    /// <p>The date when the stream was created.</p>
    #[serde(rename = "createdAt")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_at: Option<f64>,
    /// <p>The description of the stream.</p>
    #[serde(rename = "description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// <p>The files to stream.</p>
    #[serde(rename = "files")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub files: Option<Vec<StreamFile>>,
    /// <p>The date when the stream was last updated.</p>
    #[serde(rename = "lastUpdatedAt")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_updated_at: Option<f64>,
    /// <p>An IAM role AWS IoT assumes to access your S3 files.</p>
    #[serde(rename = "roleArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub role_arn: Option<String>,
    /// <p>The stream ARN.</p>
    #[serde(rename = "streamArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub stream_arn: Option<String>,
    /// <p>The stream ID.</p>
    #[serde(rename = "streamId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub stream_id: Option<String>,
    /// <p>The stream version.</p>
    #[serde(rename = "streamVersion")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub stream_version: Option<i64>,
}

/// <p>A summary of a stream.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct StreamSummary {
    /// <p>A description of the stream.</p>
    #[serde(rename = "description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// <p>The stream ARN.</p>
    #[serde(rename = "streamArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub stream_arn: Option<String>,
    /// <p>The stream ID.</p>
    #[serde(rename = "streamId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub stream_id: Option<String>,
    /// <p>The stream version.</p>
    #[serde(rename = "streamVersion")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub stream_version: Option<i64>,
}

/// <p>A set of key/value pairs that are used to manage the resource.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct Tag {
    /// <p>The tag's key.</p>
    #[serde(rename = "Key")]
    pub key: String,
    /// <p>The tag's value.</p>
    #[serde(rename = "Value")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct TagResourceRequest {
    /// <p>The ARN of the resource.</p>
    #[serde(rename = "resourceArn")]
    pub resource_arn: String,
    /// <p>The new or modified tags for the resource.</p>
    #[serde(rename = "tags")]
    pub tags: Vec<Tag>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct TagResourceResponse {}

/// <p>Statistics for the checks performed during the audit.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct TaskStatistics {
    /// <p>The number of checks that did not run because the audit was canceled.</p>
    #[serde(rename = "canceledChecks")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub canceled_checks: Option<i64>,
    /// <p>The number of checks that found compliant resources.</p>
    #[serde(rename = "compliantChecks")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub compliant_checks: Option<i64>,
    /// <p>The number of checks.</p>
    #[serde(rename = "failedChecks")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub failed_checks: Option<i64>,
    /// <p>The number of checks in progress.</p>
    #[serde(rename = "inProgressChecks")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub in_progress_checks: Option<i64>,
    /// <p>The number of checks that found noncompliant resources.</p>
    #[serde(rename = "nonCompliantChecks")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub non_compliant_checks: Option<i64>,
    /// <p>The number of checks in this audit.</p>
    #[serde(rename = "totalChecks")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub total_checks: Option<i64>,
    /// <p>The number of checks waiting for data collection.</p>
    #[serde(rename = "waitingForDataCollectionChecks")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub waiting_for_data_collection_checks: Option<i64>,
}

/// <p>Provides summary counts of how many tasks for findings are in a particular state. This information is included in the response from DescribeAuditMitigationActionsTask.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct TaskStatisticsForAuditCheck {
    /// <p>The number of findings to which the mitigation action task was canceled when applied.</p>
    #[serde(rename = "canceledFindingsCount")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub canceled_findings_count: Option<i64>,
    /// <p>The number of findings for which at least one of the actions failed when applied.</p>
    #[serde(rename = "failedFindingsCount")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub failed_findings_count: Option<i64>,
    /// <p>The number of findings skipped because of filter conditions provided in the parameters to the command.</p>
    #[serde(rename = "skippedFindingsCount")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub skipped_findings_count: Option<i64>,
    /// <p>The number of findings for which all mitigation actions succeeded when applied.</p>
    #[serde(rename = "succeededFindingsCount")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub succeeded_findings_count: Option<i64>,
    /// <p>The total number of findings to which a task is being applied.</p>
    #[serde(rename = "totalFindingsCount")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub total_findings_count: Option<i64>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct TestAuthorizationRequest {
    /// <p>A list of authorization info objects. Simulating authorization will create a response for each <code>authInfo</code> object in the list.</p>
    #[serde(rename = "authInfos")]
    pub auth_infos: Vec<AuthInfo>,
    /// <p>The MQTT client ID.</p>
    #[serde(rename = "clientId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub client_id: Option<String>,
    /// <p>The Cognito identity pool ID.</p>
    #[serde(rename = "cognitoIdentityPoolId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub cognito_identity_pool_id: Option<String>,
    /// <p>When testing custom authorization, the policies specified here are treated as if they are attached to the principal being authorized.</p>
    #[serde(rename = "policyNamesToAdd")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub policy_names_to_add: Option<Vec<String>>,
    /// <p>When testing custom authorization, the policies specified here are treated as if they are not attached to the principal being authorized.</p>
    #[serde(rename = "policyNamesToSkip")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub policy_names_to_skip: Option<Vec<String>>,
    /// <p>The principal. Valid principals are CertificateArn (arn:aws:iot:<i>region</i>:<i>accountId</i>:cert/<i>certificateId</i>), thingGroupArn (arn:aws:iot:<i>region</i>:<i>accountId</i>:thinggroup/<i>groupName</i>) and CognitoId (<i>region</i>:<i>id</i>).</p>
    #[serde(rename = "principal")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub principal: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct TestAuthorizationResponse {
    /// <p>The authentication results.</p>
    #[serde(rename = "authResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub auth_results: Option<Vec<AuthResult>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct TestInvokeAuthorizerRequest {
    /// <p>The custom authorizer name.</p>
    #[serde(rename = "authorizerName")]
    pub authorizer_name: String,
    /// <p>Specifies a test HTTP authorization request.</p>
    #[serde(rename = "httpContext")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub http_context: Option<HttpContext>,
    /// <p>Specifies a test MQTT authorization request.</p>
    #[serde(rename = "mqttContext")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub mqtt_context: Option<MqttContext>,
    /// <p>Specifies a test TLS authorization request.</p>
    #[serde(rename = "tlsContext")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tls_context: Option<TlsContext>,
    /// <p>The token returned by your custom authentication service.</p>
    #[serde(rename = "token")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub token: Option<String>,
    /// <p>The signature made with the token and your custom authentication service's private key. This value must be Base-64-encoded.</p>
    #[serde(rename = "tokenSignature")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub token_signature: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct TestInvokeAuthorizerResponse {
    /// <p>The number of seconds after which the connection is terminated.</p>
    #[serde(rename = "disconnectAfterInSeconds")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub disconnect_after_in_seconds: Option<i64>,
    /// <p>True if the token is authenticated, otherwise false.</p>
    #[serde(rename = "isAuthenticated")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub is_authenticated: Option<bool>,
    /// <p>IAM policy documents.</p>
    #[serde(rename = "policyDocuments")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub policy_documents: Option<Vec<String>>,
    /// <p>The principal ID.</p>
    #[serde(rename = "principalId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub principal_id: Option<String>,
    /// <p>The number of seconds after which the temporary credentials are refreshed.</p>
    #[serde(rename = "refreshAfterInSeconds")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub refresh_after_in_seconds: Option<i64>,
}

/// <p>The properties of the thing, including thing name, thing type name, and a list of thing attributes.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ThingAttribute {
    /// <p>A list of thing attributes which are name-value pairs.</p>
    #[serde(rename = "attributes")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub attributes: Option<::std::collections::HashMap<String, String>>,
    /// <p>The thing ARN.</p>
    #[serde(rename = "thingArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_arn: Option<String>,
    /// <p>The name of the thing.</p>
    #[serde(rename = "thingName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_name: Option<String>,
    /// <p>The name of the thing type, if the thing has been associated with a type.</p>
    #[serde(rename = "thingTypeName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_type_name: Option<String>,
    /// <p>The version of the thing record in the registry.</p>
    #[serde(rename = "version")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub version: Option<i64>,
}

/// <p>The connectivity status of the thing.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ThingConnectivity {
    /// <p>True if the thing is connected to the AWS IoT service; false if it is not connected.</p>
    #[serde(rename = "connected")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub connected: Option<bool>,
    /// <p>The epoch time (in milliseconds) when the thing last connected or disconnected. If the thing has been disconnected for more than a few weeks, the time value might be missing.</p>
    #[serde(rename = "timestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub timestamp: Option<i64>,
}

/// <p>The thing search index document.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ThingDocument {
    /// <p>The attributes.</p>
    #[serde(rename = "attributes")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub attributes: Option<::std::collections::HashMap<String, String>>,
    /// <p>Indicates whether the thing is connected to the AWS IoT service.</p>
    #[serde(rename = "connectivity")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub connectivity: Option<ThingConnectivity>,
    /// <p>The shadow.</p>
    #[serde(rename = "shadow")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub shadow: Option<String>,
    /// <p>Thing group names.</p>
    #[serde(rename = "thingGroupNames")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_group_names: Option<Vec<String>>,
    /// <p>The thing ID.</p>
    #[serde(rename = "thingId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_id: Option<String>,
    /// <p>The thing name.</p>
    #[serde(rename = "thingName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_name: Option<String>,
    /// <p>The thing type name.</p>
    #[serde(rename = "thingTypeName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_type_name: Option<String>,
}

/// <p>The thing group search index document.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ThingGroupDocument {
    /// <p>The thing group attributes.</p>
    #[serde(rename = "attributes")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub attributes: Option<::std::collections::HashMap<String, String>>,
    /// <p>Parent group names.</p>
    #[serde(rename = "parentGroupNames")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub parent_group_names: Option<Vec<String>>,
    /// <p>The thing group description.</p>
    #[serde(rename = "thingGroupDescription")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_group_description: Option<String>,
    /// <p>The thing group ID.</p>
    #[serde(rename = "thingGroupId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_group_id: Option<String>,
    /// <p>The thing group name.</p>
    #[serde(rename = "thingGroupName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_group_name: Option<String>,
}

/// <p>Thing group indexing configuration.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ThingGroupIndexingConfiguration {
    /// <p>A list of thing group fields to index. This list cannot contain any managed fields. Use the GetIndexingConfiguration API to get a list of managed fields.</p> <p>Contains custom field names and their data type.</p>
    #[serde(rename = "customFields")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub custom_fields: Option<Vec<Field>>,
    /// <p>Contains fields that are indexed and whose types are already known by the Fleet Indexing service.</p>
    #[serde(rename = "managedFields")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub managed_fields: Option<Vec<Field>>,
    /// <p>Thing group indexing mode.</p>
    #[serde(rename = "thingGroupIndexingMode")]
    pub thing_group_indexing_mode: String,
}

/// <p>Thing group metadata.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ThingGroupMetadata {
    /// <p>The UNIX timestamp of when the thing group was created.</p>
    #[serde(rename = "creationDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_date: Option<f64>,
    /// <p>The parent thing group name.</p>
    #[serde(rename = "parentGroupName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub parent_group_name: Option<String>,
    /// <p>The root parent thing group.</p>
    #[serde(rename = "rootToParentThingGroups")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub root_to_parent_thing_groups: Option<Vec<GroupNameAndArn>>,
}

/// <p>Thing group properties.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ThingGroupProperties {
    /// <p>The thing group attributes in JSON format.</p>
    #[serde(rename = "attributePayload")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub attribute_payload: Option<AttributePayload>,
    /// <p>The thing group description.</p>
    #[serde(rename = "thingGroupDescription")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_group_description: Option<String>,
}

/// <p>The thing indexing configuration. For more information, see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/managing-index.html">Managing Thing Indexing</a>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ThingIndexingConfiguration {
    /// <p>Contains custom field names and their data type.</p>
    #[serde(rename = "customFields")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub custom_fields: Option<Vec<Field>>,
    /// <p>Contains fields that are indexed and whose types are already known by the Fleet Indexing service.</p>
    #[serde(rename = "managedFields")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub managed_fields: Option<Vec<Field>>,
    /// <p><p>Thing connectivity indexing mode. Valid values are: </p> <ul> <li> <p>STATUS – Your thing index contains connectivity status. To enable thing connectivity indexing, thingIndexMode must not be set to OFF.</p> </li> <li> <p>OFF - Thing connectivity status indexing is disabled.</p> </li> </ul></p>
    #[serde(rename = "thingConnectivityIndexingMode")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_connectivity_indexing_mode: Option<String>,
    /// <p><p>Thing indexing mode. Valid values are:</p> <ul> <li> <p>REGISTRY – Your thing index contains registry data only.</p> </li> <li> <p>REGISTRY<em>AND</em>SHADOW - Your thing index contains registry and shadow data.</p> </li> <li> <p>OFF - Thing indexing is disabled.</p> </li> </ul></p>
    #[serde(rename = "thingIndexingMode")]
    pub thing_indexing_mode: String,
}

/// <p>The definition of the thing type, including thing type name and description.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ThingTypeDefinition {
    /// <p>The thing type ARN.</p>
    #[serde(rename = "thingTypeArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_type_arn: Option<String>,
    /// <p>The ThingTypeMetadata contains additional information about the thing type including: creation date and time, a value indicating whether the thing type is deprecated, and a date and time when it was deprecated.</p>
    #[serde(rename = "thingTypeMetadata")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_type_metadata: Option<ThingTypeMetadata>,
    /// <p>The name of the thing type.</p>
    #[serde(rename = "thingTypeName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_type_name: Option<String>,
    /// <p>The ThingTypeProperties for the thing type.</p>
    #[serde(rename = "thingTypeProperties")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_type_properties: Option<ThingTypeProperties>,
}

/// <p>The ThingTypeMetadata contains additional information about the thing type including: creation date and time, a value indicating whether the thing type is deprecated, and a date and time when time was deprecated.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ThingTypeMetadata {
    /// <p>The date and time when the thing type was created.</p>
    #[serde(rename = "creationDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_date: Option<f64>,
    /// <p>Whether the thing type is deprecated. If <b>true</b>, no new things could be associated with this type.</p>
    #[serde(rename = "deprecated")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub deprecated: Option<bool>,
    /// <p>The date and time when the thing type was deprecated.</p>
    #[serde(rename = "deprecationDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub deprecation_date: Option<f64>,
}

/// <p>The ThingTypeProperties contains information about the thing type including: a thing type description, and a list of searchable thing attribute names.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ThingTypeProperties {
    /// <p>A list of searchable thing attribute names.</p>
    #[serde(rename = "searchableAttributes")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub searchable_attributes: Option<Vec<String>>,
    /// <p>The description of the thing type.</p>
    #[serde(rename = "thingTypeDescription")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_type_description: Option<String>,
}

/// <p>Specifies the amount of time each device has to finish its execution of the job. A timer is started when the job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to another terminal state before the timer expires, it will be automatically set to <code>TIMED_OUT</code>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct TimeoutConfig {
    /// <p>Specifies the amount of time, in minutes, this device has to finish execution of this job. The timeout interval can be anywhere between 1 minute and 7 days (1 to 10080 minutes). The in progress timer can't be updated and will apply to all job executions for the job. Whenever a job execution remains in the IN_PROGRESS status for longer than this interval, the job execution will fail and switch to the terminal <code>TIMED_OUT</code> status.</p>
    #[serde(rename = "inProgressTimeoutInMinutes")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub in_progress_timeout_in_minutes: Option<i64>,
}

/// <p>The Timestream rule action writes attributes (measures) from an MQTT message into an Amazon Timestream table. For more information, see the <a href="https://docs.aws.amazon.com/iot/latest/developerguide/timestream-rule-action.html">Timestream</a> topic rule action documentation.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct TimestreamAction {
    /// <p>The name of an Amazon Timestream database.</p>
    #[serde(rename = "databaseName")]
    pub database_name: String,
    /// <p>Metadata attributes of the time series that are written in each measure record.</p>
    #[serde(rename = "dimensions")]
    pub dimensions: Vec<TimestreamDimension>,
    /// <p>The ARN of the role that grants permission to write to the Amazon Timestream database table.</p>
    #[serde(rename = "roleArn")]
    pub role_arn: String,
    /// <p>The name of the database table into which to write the measure records.</p>
    #[serde(rename = "tableName")]
    pub table_name: String,
    /// <p>Specifies an application-defined value to replace the default value assigned to the Timestream record's timestamp in the <code>time</code> column.</p> <p>You can use this property to specify the value and the precision of the Timestream record's timestamp. You can specify a value from the message payload or a value computed by a substitution template.</p> <p>If omitted, the topic rule action assigns the timestamp, in milliseconds, at the time it processed the rule. </p>
    #[serde(rename = "timestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub timestamp: Option<TimestreamTimestamp>,
}

/// <p>Metadata attributes of the time series that are written in each measure record.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct TimestreamDimension {
    /// <p>The metadata dimension name. This is the name of the column in the Amazon Timestream database table record.</p> <p>Dimensions cannot be named: <code>measure_name</code>, <code>measure_value</code>, or <code>time</code>. These names are reserved. Dimension names cannot start with <code>ts_</code> or <code>measure_value</code> and they cannot contain the colon (<code>:</code>) character.</p>
    #[serde(rename = "name")]
    pub name: String,
    /// <p>The value to write in this column of the database record.</p>
    #[serde(rename = "value")]
    pub value: String,
}

/// <p>Describes how to interpret an application-defined timestamp value from an MQTT message payload and the precision of that value.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct TimestreamTimestamp {
    /// <p>The precision of the timestamp value that results from the expression described in <code>value</code>.</p> <p>Valid values: <code>SECONDS</code> | <code>MILLISECONDS</code> | <code>MICROSECONDS</code> | <code>NANOSECONDS</code>. The default is <code>MILLISECONDS</code>.</p>
    #[serde(rename = "unit")]
    pub unit: String,
    /// <p>An expression that returns a long epoch time value.</p>
    #[serde(rename = "value")]
    pub value: String,
}

/// <p>Specifies the TLS context to use for the test authorizer request.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct TlsContext {
    /// <p>The value of the <code>serverName</code> key in a TLS authorization request.</p>
    #[serde(rename = "serverName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub server_name: Option<String>,
}

/// <p>Describes a rule.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct TopicRule {
    /// <p>The actions associated with the rule.</p>
    #[serde(rename = "actions")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub actions: Option<Vec<Action>>,
    /// <p>The version of the SQL rules engine to use when evaluating the rule.</p>
    #[serde(rename = "awsIotSqlVersion")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub aws_iot_sql_version: Option<String>,
    /// <p>The date and time the rule was created.</p>
    #[serde(rename = "createdAt")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_at: Option<f64>,
    /// <p>The description of the rule.</p>
    #[serde(rename = "description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// <p>The action to perform when an error occurs.</p>
    #[serde(rename = "errorAction")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub error_action: Option<Action>,
    /// <p>Specifies whether the rule is disabled.</p>
    #[serde(rename = "ruleDisabled")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub rule_disabled: Option<bool>,
    /// <p>The name of the rule.</p>
    #[serde(rename = "ruleName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub rule_name: Option<String>,
    /// <p>The SQL statement used to query the topic. When using a SQL query with multiple lines, be sure to escape the newline characters.</p>
    #[serde(rename = "sql")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sql: Option<String>,
}

/// <p>A topic rule destination.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct TopicRuleDestination {
    /// <p>The topic rule destination URL.</p>
    #[serde(rename = "arn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub arn: Option<String>,
    /// <p>The date and time when the topic rule destination was created.</p>
    #[serde(rename = "createdAt")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_at: Option<f64>,
    /// <p>Properties of the HTTP URL.</p>
    #[serde(rename = "httpUrlProperties")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub http_url_properties: Option<HttpUrlDestinationProperties>,
    /// <p>The date and time when the topic rule destination was last updated.</p>
    #[serde(rename = "lastUpdatedAt")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_updated_at: Option<f64>,
    /// <p><p>The status of the topic rule destination. Valid values are:</p> <dl> <dt>IN<em>PROGRESS</dt> <dd> <p>A topic rule destination was created but has not been confirmed. You can set <code>status</code> to <code>IN</em>PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your confirmation endpoint.</p> </dd> <dt>ENABLED</dt> <dd> <p>Confirmation was completed, and traffic to this destination is allowed. You can set <code>status</code> to <code>DISABLED</code> by calling <code>UpdateTopicRuleDestination</code>.</p> </dd> <dt>DISABLED</dt> <dd> <p>Confirmation was completed, and traffic to this destination is not allowed. You can set <code>status</code> to <code>ENABLED</code> by calling <code>UpdateTopicRuleDestination</code>.</p> </dd> <dt>ERROR</dt> <dd> <p>Confirmation could not be completed, for example if the confirmation timed out. You can call <code>GetTopicRuleDestination</code> for details about the error. You can set <code>status</code> to <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your confirmation endpoint.</p> </dd> </dl></p>
    #[serde(rename = "status")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    /// <p>Additional details or reason why the topic rule destination is in the current status.</p>
    #[serde(rename = "statusReason")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status_reason: Option<String>,
    /// <p>Properties of the virtual private cloud (VPC) connection.</p>
    #[serde(rename = "vpcProperties")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub vpc_properties: Option<VpcDestinationProperties>,
}

/// <p>Configuration of the topic rule destination.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct TopicRuleDestinationConfiguration {
    /// <p>Configuration of the HTTP URL.</p>
    #[serde(rename = "httpUrlConfiguration")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub http_url_configuration: Option<HttpUrlDestinationConfiguration>,
    /// <p>Configuration of the virtual private cloud (VPC) connection.</p>
    #[serde(rename = "vpcConfiguration")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub vpc_configuration: Option<VpcDestinationConfiguration>,
}

/// <p>Information about the topic rule destination.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct TopicRuleDestinationSummary {
    /// <p>The topic rule destination ARN.</p>
    #[serde(rename = "arn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub arn: Option<String>,
    /// <p>The date and time when the topic rule destination was created.</p>
    #[serde(rename = "createdAt")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_at: Option<f64>,
    /// <p>Information about the HTTP URL.</p>
    #[serde(rename = "httpUrlSummary")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub http_url_summary: Option<HttpUrlDestinationSummary>,
    /// <p>The date and time when the topic rule destination was last updated.</p>
    #[serde(rename = "lastUpdatedAt")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_updated_at: Option<f64>,
    /// <p><p>The status of the topic rule destination. Valid values are:</p> <dl> <dt>IN<em>PROGRESS</dt> <dd> <p>A topic rule destination was created but has not been confirmed. You can set <code>status</code> to <code>IN</em>PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your confirmation endpoint.</p> </dd> <dt>ENABLED</dt> <dd> <p>Confirmation was completed, and traffic to this destination is allowed. You can set <code>status</code> to <code>DISABLED</code> by calling <code>UpdateTopicRuleDestination</code>.</p> </dd> <dt>DISABLED</dt> <dd> <p>Confirmation was completed, and traffic to this destination is not allowed. You can set <code>status</code> to <code>ENABLED</code> by calling <code>UpdateTopicRuleDestination</code>.</p> </dd> <dt>ERROR</dt> <dd> <p>Confirmation could not be completed, for example if the confirmation timed out. You can call <code>GetTopicRuleDestination</code> for details about the error. You can set <code>status</code> to <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your confirmation endpoint.</p> </dd> </dl></p>
    #[serde(rename = "status")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    /// <p>The reason the topic rule destination is in the current status.</p>
    #[serde(rename = "statusReason")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status_reason: Option<String>,
    /// <p>Information about the virtual private cloud (VPC) connection.</p>
    #[serde(rename = "vpcDestinationSummary")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub vpc_destination_summary: Option<VpcDestinationSummary>,
}

/// <p>Describes a rule.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct TopicRuleListItem {
    /// <p>The date and time the rule was created.</p>
    #[serde(rename = "createdAt")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_at: Option<f64>,
    /// <p>The rule ARN.</p>
    #[serde(rename = "ruleArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub rule_arn: Option<String>,
    /// <p>Specifies whether the rule is disabled.</p>
    #[serde(rename = "ruleDisabled")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub rule_disabled: Option<bool>,
    /// <p>The name of the rule.</p>
    #[serde(rename = "ruleName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub rule_name: Option<String>,
    /// <p>The pattern for the topic names that apply.</p>
    #[serde(rename = "topicPattern")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub topic_pattern: Option<String>,
}

/// <p>Describes a rule.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct TopicRulePayload {
    /// <p>The actions associated with the rule.</p>
    #[serde(rename = "actions")]
    pub actions: Vec<Action>,
    /// <p>The version of the SQL rules engine to use when evaluating the rule.</p>
    #[serde(rename = "awsIotSqlVersion")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub aws_iot_sql_version: Option<String>,
    /// <p>The description of the rule.</p>
    #[serde(rename = "description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// <p>The action to take when an error occurs.</p>
    #[serde(rename = "errorAction")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub error_action: Option<Action>,
    /// <p>Specifies whether the rule is disabled.</p>
    #[serde(rename = "ruleDisabled")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub rule_disabled: Option<bool>,
    /// <p>The SQL statement used to query the topic. For more information, see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-sql-reference.html">AWS IoT SQL Reference</a> in the <i>AWS IoT Developer Guide</i>.</p>
    #[serde(rename = "sql")]
    pub sql: String,
}

/// <p>The input for the TransferCertificate operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct TransferCertificateRequest {
    /// <p>The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)</p>
    #[serde(rename = "certificateId")]
    pub certificate_id: String,
    /// <p>The AWS account.</p>
    #[serde(rename = "targetAwsAccount")]
    pub target_aws_account: String,
    /// <p>The transfer message.</p>
    #[serde(rename = "transferMessage")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub transfer_message: Option<String>,
}

/// <p>The output from the TransferCertificate operation.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct TransferCertificateResponse {
    /// <p>The ARN of the certificate.</p>
    #[serde(rename = "transferredCertificateArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub transferred_certificate_arn: Option<String>,
}

/// <p>Data used to transfer a certificate to an AWS account.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct TransferData {
    /// <p>The date the transfer was accepted.</p>
    #[serde(rename = "acceptDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub accept_date: Option<f64>,
    /// <p>The date the transfer was rejected.</p>
    #[serde(rename = "rejectDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub reject_date: Option<f64>,
    /// <p>The reason why the transfer was rejected.</p>
    #[serde(rename = "rejectReason")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub reject_reason: Option<String>,
    /// <p>The date the transfer took place.</p>
    #[serde(rename = "transferDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub transfer_date: Option<f64>,
    /// <p>The transfer message.</p>
    #[serde(rename = "transferMessage")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub transfer_message: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UntagResourceRequest {
    /// <p>The ARN of the resource.</p>
    #[serde(rename = "resourceArn")]
    pub resource_arn: String,
    /// <p>A list of the keys of the tags to be removed from the resource.</p>
    #[serde(rename = "tagKeys")]
    pub tag_keys: Vec<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UntagResourceResponse {}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateAccountAuditConfigurationRequest {
    /// <p>Specifies which audit checks are enabled and disabled for this account. Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are currently enabled.</p> <p>Some data collection might start immediately when certain checks are enabled. When a check is disabled, any data collected so far in relation to the check is deleted.</p> <p>You cannot disable a check if it's used by any scheduled audit. You must first delete the check from the scheduled audit or delete the scheduled audit itself.</p> <p>On the first call to <code>UpdateAccountAuditConfiguration</code>, this parameter is required and must specify at least one enabled check.</p>
    #[serde(rename = "auditCheckConfigurations")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub audit_check_configurations:
        Option<::std::collections::HashMap<String, AuditCheckConfiguration>>,
    /// <p>Information about the targets to which audit notifications are sent.</p>
    #[serde(rename = "auditNotificationTargetConfigurations")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub audit_notification_target_configurations:
        Option<::std::collections::HashMap<String, AuditNotificationTarget>>,
    /// <p>The Amazon Resource Name (ARN) of the role that grants permission to AWS IoT to access information about your devices, policies, certificates, and other items as required when performing an audit.</p>
    #[serde(rename = "roleArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub role_arn: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateAccountAuditConfigurationResponse {}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateAuditSuppressionRequest {
    #[serde(rename = "checkName")]
    pub check_name: String,
    /// <p> The description of the audit suppression. </p>
    #[serde(rename = "description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// <p> The expiration date (epoch timestamp in seconds) that you want the suppression to adhere to. </p>
    #[serde(rename = "expirationDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub expiration_date: Option<f64>,
    #[serde(rename = "resourceIdentifier")]
    pub resource_identifier: ResourceIdentifier,
    /// <p> Indicates whether a suppression should exist indefinitely or not. </p>
    #[serde(rename = "suppressIndefinitely")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub suppress_indefinitely: Option<bool>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateAuditSuppressionResponse {}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateAuthorizerRequest {
    /// <p>The ARN of the authorizer's Lambda function.</p>
    #[serde(rename = "authorizerFunctionArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub authorizer_function_arn: Option<String>,
    /// <p>The authorizer name.</p>
    #[serde(rename = "authorizerName")]
    pub authorizer_name: String,
    /// <p>The status of the update authorizer request.</p>
    #[serde(rename = "status")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    /// <p>The key used to extract the token from the HTTP headers. </p>
    #[serde(rename = "tokenKeyName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub token_key_name: Option<String>,
    /// <p>The public keys used to verify the token signature.</p>
    #[serde(rename = "tokenSigningPublicKeys")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub token_signing_public_keys: Option<::std::collections::HashMap<String, String>>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateAuthorizerResponse {
    /// <p>The authorizer ARN.</p>
    #[serde(rename = "authorizerArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub authorizer_arn: Option<String>,
    /// <p>The authorizer name.</p>
    #[serde(rename = "authorizerName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub authorizer_name: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateBillingGroupRequest {
    /// <p>The name of the billing group.</p>
    #[serde(rename = "billingGroupName")]
    pub billing_group_name: String,
    /// <p>The properties of the billing group.</p>
    #[serde(rename = "billingGroupProperties")]
    pub billing_group_properties: BillingGroupProperties,
    /// <p>The expected version of the billing group. If the version of the billing group does not match the expected version specified in the request, the <code>UpdateBillingGroup</code> request is rejected with a <code>VersionConflictException</code>.</p>
    #[serde(rename = "expectedVersion")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub expected_version: Option<i64>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateBillingGroupResponse {
    /// <p>The latest version of the billing group.</p>
    #[serde(rename = "version")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub version: Option<i64>,
}

/// <p>Parameters to define a mitigation action that changes the state of the CA certificate to inactive.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct UpdateCACertificateParams {
    /// <p>The action that you want to apply to the CA certificate. The only supported value is <code>DEACTIVATE</code>.</p>
    #[serde(rename = "action")]
    pub action: String,
}

/// <p>The input to the UpdateCACertificate operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateCACertificateRequest {
    /// <p>The CA certificate identifier.</p>
    #[serde(rename = "certificateId")]
    pub certificate_id: String,
    /// <p>The new value for the auto registration status. Valid values are: "ENABLE" or "DISABLE".</p>
    #[serde(rename = "newAutoRegistrationStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub new_auto_registration_status: Option<String>,
    /// <p>The updated status of the CA certificate.</p> <p> <b>Note:</b> The status value REGISTER_INACTIVE is deprecated and should not be used.</p>
    #[serde(rename = "newStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub new_status: Option<String>,
    /// <p>Information about the registration configuration.</p>
    #[serde(rename = "registrationConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub registration_config: Option<RegistrationConfig>,
    /// <p>If true, removes auto registration.</p>
    #[serde(rename = "removeAutoRegistration")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub remove_auto_registration: Option<bool>,
}

/// <p>The input for the UpdateCertificate operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateCertificateRequest {
    /// <p>The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)</p>
    #[serde(rename = "certificateId")]
    pub certificate_id: String,
    /// <p>The new status.</p> <p> <b>Note:</b> Setting the status to PENDING_TRANSFER or PENDING_ACTIVATION will result in an exception being thrown. PENDING_TRANSFER and PENDING_ACTIVATION are statuses used internally by AWS IoT. They are not intended for developer use.</p> <p> <b>Note:</b> The status value REGISTER_INACTIVE is deprecated and should not be used.</p>
    #[serde(rename = "newStatus")]
    pub new_status: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateCustomMetricRequest {
    /// <p> Field represents a friendly name in the console for the custom metric, it doesn't have to be unique. Don't use this name as the metric identifier in the device metric report. Can be updated. </p>
    #[serde(rename = "displayName")]
    pub display_name: String,
    /// <p> The name of the custom metric. Cannot be updated. </p>
    #[serde(rename = "metricName")]
    pub metric_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateCustomMetricResponse {
    /// <p> The creation date of the custom metric in milliseconds since epoch. </p>
    #[serde(rename = "creationDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_date: Option<f64>,
    /// <p> A friendly name in the console for the custom metric </p>
    #[serde(rename = "displayName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    /// <p> The time the custom metric was last modified in milliseconds since epoch. </p>
    #[serde(rename = "lastModifiedDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_date: Option<f64>,
    /// <p> The Amazon Resource Number (ARN) of the custom metric. </p>
    #[serde(rename = "metricArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metric_arn: Option<String>,
    /// <p> The name of the custom metric. </p>
    #[serde(rename = "metricName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metric_name: Option<String>,
    /// <p> The type of the custom metric. Types include <code>string-list</code>, <code>ip-address-list</code>, <code>number-list</code>, and <code>number</code>. </p>
    #[serde(rename = "metricType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metric_type: Option<String>,
}

/// <p>Parameters to define a mitigation action that changes the state of the device certificate to inactive.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct UpdateDeviceCertificateParams {
    /// <p>The action that you want to apply to the device certificate. The only supported value is <code>DEACTIVATE</code>.</p>
    #[serde(rename = "action")]
    pub action: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateDimensionRequest {
    /// <p>A unique identifier for the dimension. Choose something that describes the type and value to make it easy to remember what it does.</p>
    #[serde(rename = "name")]
    pub name: String,
    /// <p>Specifies the value or list of values for the dimension. For <code>TOPIC_FILTER</code> dimensions, this is a pattern used to match the MQTT topic (for example, "admin/#").</p>
    #[serde(rename = "stringValues")]
    pub string_values: Vec<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateDimensionResponse {
    /// <p>The Amazon Resource Name (ARN)of the created dimension.</p>
    #[serde(rename = "arn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub arn: Option<String>,
    /// <p>The date and time, in milliseconds since epoch, when the dimension was initially created.</p>
    #[serde(rename = "creationDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_date: Option<f64>,
    /// <p>The date and time, in milliseconds since epoch, when the dimension was most recently updated.</p>
    #[serde(rename = "lastModifiedDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_date: Option<f64>,
    /// <p>A unique identifier for the dimension.</p>
    #[serde(rename = "name")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    /// <p>The value or list of values used to scope the dimension. For example, for topic filters, this is the pattern used to match the MQTT topic name.</p>
    #[serde(rename = "stringValues")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub string_values: Option<Vec<String>>,
    /// <p>The type of the dimension.</p>
    #[serde(rename = "type")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateDomainConfigurationRequest {
    /// <p>An object that specifies the authorization service for a domain.</p>
    #[serde(rename = "authorizerConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub authorizer_config: Option<AuthorizerConfig>,
    /// <p>The name of the domain configuration to be updated.</p>
    #[serde(rename = "domainConfigurationName")]
    pub domain_configuration_name: String,
    /// <p>The status to which the domain configuration should be updated.</p>
    #[serde(rename = "domainConfigurationStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub domain_configuration_status: Option<String>,
    /// <p>Removes the authorization configuration from a domain.</p>
    #[serde(rename = "removeAuthorizerConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub remove_authorizer_config: Option<bool>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateDomainConfigurationResponse {
    /// <p>The ARN of the domain configuration that was updated.</p>
    #[serde(rename = "domainConfigurationArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub domain_configuration_arn: Option<String>,
    /// <p>The name of the domain configuration that was updated.</p>
    #[serde(rename = "domainConfigurationName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub domain_configuration_name: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateDynamicThingGroupRequest {
    /// <p>The expected version of the dynamic thing group to update.</p>
    #[serde(rename = "expectedVersion")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub expected_version: Option<i64>,
    /// <p><p>The dynamic thing group index to update.</p> <note> <p>Currently one index is supported: &#39;AWS_Things&#39;.</p> </note></p>
    #[serde(rename = "indexName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub index_name: Option<String>,
    /// <p>The dynamic thing group search query string to update.</p>
    #[serde(rename = "queryString")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub query_string: Option<String>,
    /// <p><p>The dynamic thing group query version to update.</p> <note> <p>Currently one query version is supported: &quot;2017-09-30&quot;. If not specified, the query version defaults to this value.</p> </note></p>
    #[serde(rename = "queryVersion")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub query_version: Option<String>,
    /// <p>The name of the dynamic thing group to update.</p>
    #[serde(rename = "thingGroupName")]
    pub thing_group_name: String,
    /// <p>The dynamic thing group properties to update.</p>
    #[serde(rename = "thingGroupProperties")]
    pub thing_group_properties: ThingGroupProperties,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateDynamicThingGroupResponse {
    /// <p>The dynamic thing group version.</p>
    #[serde(rename = "version")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub version: Option<i64>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateEventConfigurationsRequest {
    /// <p>The new event configuration values.</p>
    #[serde(rename = "eventConfigurations")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub event_configurations: Option<::std::collections::HashMap<String, Configuration>>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateEventConfigurationsResponse {}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateIndexingConfigurationRequest {
    /// <p>Thing group indexing configuration.</p>
    #[serde(rename = "thingGroupIndexingConfiguration")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_group_indexing_configuration: Option<ThingGroupIndexingConfiguration>,
    /// <p>Thing indexing configuration.</p>
    #[serde(rename = "thingIndexingConfiguration")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_indexing_configuration: Option<ThingIndexingConfiguration>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateIndexingConfigurationResponse {}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateJobRequest {
    /// <p>Allows you to create criteria to abort a job.</p>
    #[serde(rename = "abortConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub abort_config: Option<AbortConfig>,
    /// <p>A short text description of the job.</p>
    #[serde(rename = "description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// <p>Allows you to create a staged rollout of the job.</p>
    #[serde(rename = "jobExecutionsRolloutConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub job_executions_rollout_config: Option<JobExecutionsRolloutConfig>,
    /// <p>The ID of the job to be updated.</p>
    #[serde(rename = "jobId")]
    pub job_id: String,
    /// <p><p>The namespace used to indicate that a job is a customer-managed job.</p> <p>When you specify a value for this parameter, AWS IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.</p> <p> <code>$aws/things/<i>THING<em>NAME</i>/jobs/<i>JOB</em>ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code> </p> <note> <p>The <code>namespaceId</code> feature is in public preview.</p> </note></p>
    #[serde(rename = "namespaceId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub namespace_id: Option<String>,
    /// <p>Configuration information for pre-signed S3 URLs.</p>
    #[serde(rename = "presignedUrlConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub presigned_url_config: Option<PresignedUrlConfig>,
    /// <p>Specifies the amount of time each device has to finish its execution of the job. The timer is started when the job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to another terminal state before the time expires, it will be automatically set to <code>TIMED_OUT</code>. </p>
    #[serde(rename = "timeoutConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub timeout_config: Option<TimeoutConfig>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateMitigationActionRequest {
    /// <p>The friendly name for the mitigation action. You cannot change the name by using <code>UpdateMitigationAction</code>. Instead, you must delete and recreate the mitigation action with the new name.</p>
    #[serde(rename = "actionName")]
    pub action_name: String,
    /// <p>Defines the type of action and the parameters for that action.</p>
    #[serde(rename = "actionParams")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub action_params: Option<MitigationActionParams>,
    /// <p>The ARN of the IAM role that is used to apply the mitigation action.</p>
    #[serde(rename = "roleArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub role_arn: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateMitigationActionResponse {
    /// <p>The ARN for the new mitigation action.</p>
    #[serde(rename = "actionArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub action_arn: Option<String>,
    /// <p>A unique identifier for the mitigation action.</p>
    #[serde(rename = "actionId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub action_id: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateProvisioningTemplateRequest {
    /// <p>The ID of the default provisioning template version.</p>
    #[serde(rename = "defaultVersionId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub default_version_id: Option<i64>,
    /// <p>The description of the fleet provisioning template.</p>
    #[serde(rename = "description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// <p>True to enable the fleet provisioning template, otherwise false.</p>
    #[serde(rename = "enabled")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
    /// <p>Updates the pre-provisioning hook template.</p>
    #[serde(rename = "preProvisioningHook")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pre_provisioning_hook: Option<ProvisioningHook>,
    /// <p>The ARN of the role associated with the provisioning template. This IoT role grants permission to provision a device.</p>
    #[serde(rename = "provisioningRoleArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub provisioning_role_arn: Option<String>,
    /// <p>Removes pre-provisioning hook template.</p>
    #[serde(rename = "removePreProvisioningHook")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub remove_pre_provisioning_hook: Option<bool>,
    /// <p>The name of the fleet provisioning template.</p>
    #[serde(rename = "templateName")]
    pub template_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateProvisioningTemplateResponse {}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateRoleAliasRequest {
    /// <p>The number of seconds the credential will be valid.</p>
    #[serde(rename = "credentialDurationSeconds")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub credential_duration_seconds: Option<i64>,
    /// <p>The role alias to update.</p>
    #[serde(rename = "roleAlias")]
    pub role_alias: String,
    /// <p>The role ARN.</p>
    #[serde(rename = "roleArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub role_arn: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateRoleAliasResponse {
    /// <p>The role alias.</p>
    #[serde(rename = "roleAlias")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub role_alias: Option<String>,
    /// <p>The role alias ARN.</p>
    #[serde(rename = "roleAliasArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub role_alias_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateScheduledAuditRequest {
    /// <p>The day of the month on which the scheduled audit takes place. This can be <code>1</code> through <code>31</code> or <code>LAST</code>. This field is required if the <code>frequency</code> parameter is set to <code>MONTHLY</code>. If days 29-31 are specified, and the month does not have that many days, the audit takes place on the "LAST" day of the month.</p>
    #[serde(rename = "dayOfMonth")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub day_of_month: Option<String>,
    /// <p>The day of the week on which the scheduled audit takes place. This can be one of <code>SUN</code>, <code>MON</code>, <code>TUE</code>, <code>WED</code>, <code>THU</code>, <code>FRI</code>, or <code>SAT</code>. This field is required if the "frequency" parameter is set to <code>WEEKLY</code> or <code>BIWEEKLY</code>.</p>
    #[serde(rename = "dayOfWeek")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub day_of_week: Option<String>,
    /// <p>How often the scheduled audit takes place, either <code>DAILY</code>, <code>WEEKLY</code>, <code>BIWEEKLY</code>, or <code>MONTHLY</code>. The start time of each audit is determined by the system.</p>
    #[serde(rename = "frequency")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub frequency: Option<String>,
    /// <p>The name of the scheduled audit. (Max. 128 chars)</p>
    #[serde(rename = "scheduledAuditName")]
    pub scheduled_audit_name: String,
    /// <p>Which checks are performed during the scheduled audit. Checks must be enabled for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)</p>
    #[serde(rename = "targetCheckNames")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub target_check_names: Option<Vec<String>>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateScheduledAuditResponse {
    /// <p>The ARN of the scheduled audit.</p>
    #[serde(rename = "scheduledAuditArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub scheduled_audit_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateSecurityProfileRequest {
    /// <p>A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the profile's behaviors, but it is also retained for any metric specified here. Can be used with custom metrics; cannot be used with dimensions.</p>
    #[serde(rename = "additionalMetricsToRetainV2")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub additional_metrics_to_retain_v2: Option<Vec<MetricToRetain>>,
    /// <p>Where the alerts are sent. (Alerts are always sent to the console.)</p>
    #[serde(rename = "alertTargets")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub alert_targets: Option<::std::collections::HashMap<String, AlertTarget>>,
    /// <p>Specifies the behaviors that, when violated by a device (thing), cause an alert.</p>
    #[serde(rename = "behaviors")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub behaviors: Option<Vec<Behavior>>,
    /// <p>If true, delete all <code>additionalMetricsToRetain</code> defined for this security profile. If any <code>additionalMetricsToRetain</code> are defined in the current invocation, an exception occurs.</p>
    #[serde(rename = "deleteAdditionalMetricsToRetain")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub delete_additional_metrics_to_retain: Option<bool>,
    /// <p>If true, delete all <code>alertTargets</code> defined for this security profile. If any <code>alertTargets</code> are defined in the current invocation, an exception occurs.</p>
    #[serde(rename = "deleteAlertTargets")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub delete_alert_targets: Option<bool>,
    /// <p>If true, delete all <code>behaviors</code> defined for this security profile. If any <code>behaviors</code> are defined in the current invocation, an exception occurs.</p>
    #[serde(rename = "deleteBehaviors")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub delete_behaviors: Option<bool>,
    /// <p>The expected version of the security profile. A new version is generated whenever the security profile is updated. If you specify a value that is different from the actual version, a <code>VersionConflictException</code> is thrown.</p>
    #[serde(rename = "expectedVersion")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub expected_version: Option<i64>,
    /// <p>A description of the security profile.</p>
    #[serde(rename = "securityProfileDescription")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub security_profile_description: Option<String>,
    /// <p>The name of the security profile you want to update.</p>
    #[serde(rename = "securityProfileName")]
    pub security_profile_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateSecurityProfileResponse {
    /// <p>A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the profile's behaviors, but it is also retained for any metric specified here. Can be used with custom metrics; cannot be used with dimensions.</p>
    #[serde(rename = "additionalMetricsToRetainV2")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub additional_metrics_to_retain_v2: Option<Vec<MetricToRetain>>,
    /// <p>Where the alerts are sent. (Alerts are always sent to the console.)</p>
    #[serde(rename = "alertTargets")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub alert_targets: Option<::std::collections::HashMap<String, AlertTarget>>,
    /// <p>Specifies the behaviors that, when violated by a device (thing), cause an alert.</p>
    #[serde(rename = "behaviors")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub behaviors: Option<Vec<Behavior>>,
    /// <p>The time the security profile was created.</p>
    #[serde(rename = "creationDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_date: Option<f64>,
    /// <p>The time the security profile was last modified.</p>
    #[serde(rename = "lastModifiedDate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_date: Option<f64>,
    /// <p>The ARN of the security profile that was updated.</p>
    #[serde(rename = "securityProfileArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub security_profile_arn: Option<String>,
    /// <p>The description of the security profile.</p>
    #[serde(rename = "securityProfileDescription")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub security_profile_description: Option<String>,
    /// <p>The name of the security profile that was updated.</p>
    #[serde(rename = "securityProfileName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub security_profile_name: Option<String>,
    /// <p>The updated version of the security profile.</p>
    #[serde(rename = "version")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub version: Option<i64>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateStreamRequest {
    /// <p>The description of the stream.</p>
    #[serde(rename = "description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// <p>The files associated with the stream.</p>
    #[serde(rename = "files")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub files: Option<Vec<StreamFile>>,
    /// <p>An IAM role that allows the IoT service principal assumes to access your S3 files.</p>
    #[serde(rename = "roleArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub role_arn: Option<String>,
    /// <p>The stream ID.</p>
    #[serde(rename = "streamId")]
    pub stream_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateStreamResponse {
    /// <p>A description of the stream.</p>
    #[serde(rename = "description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// <p>The stream ARN.</p>
    #[serde(rename = "streamArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub stream_arn: Option<String>,
    /// <p>The stream ID.</p>
    #[serde(rename = "streamId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub stream_id: Option<String>,
    /// <p>The stream version.</p>
    #[serde(rename = "streamVersion")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub stream_version: Option<i64>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateThingGroupRequest {
    /// <p>The expected version of the thing group. If this does not match the version of the thing group being updated, the update will fail.</p>
    #[serde(rename = "expectedVersion")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub expected_version: Option<i64>,
    /// <p>The thing group to update.</p>
    #[serde(rename = "thingGroupName")]
    pub thing_group_name: String,
    /// <p>The thing group properties.</p>
    #[serde(rename = "thingGroupProperties")]
    pub thing_group_properties: ThingGroupProperties,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateThingGroupResponse {
    /// <p>The version of the updated thing group.</p>
    #[serde(rename = "version")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub version: Option<i64>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateThingGroupsForThingRequest {
    /// <p>Override dynamic thing groups with static thing groups when 10-group limit is reached. If a thing belongs to 10 thing groups, and one or more of those groups are dynamic thing groups, adding a thing to a static group removes the thing from the last dynamic group.</p>
    #[serde(rename = "overrideDynamicGroups")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub override_dynamic_groups: Option<bool>,
    /// <p>The groups to which the thing will be added.</p>
    #[serde(rename = "thingGroupsToAdd")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_groups_to_add: Option<Vec<String>>,
    /// <p>The groups from which the thing will be removed.</p>
    #[serde(rename = "thingGroupsToRemove")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_groups_to_remove: Option<Vec<String>>,
    /// <p>The thing whose group memberships will be updated.</p>
    #[serde(rename = "thingName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_name: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateThingGroupsForThingResponse {}

/// <p>The input for the UpdateThing operation.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateThingRequest {
    /// <p>A list of thing attributes, a JSON string containing name-value pairs. For example:</p> <p> <code>{\"attributes\":{\"name1\":\"value2\"}}</code> </p> <p>This data is used to add new attributes or update existing attributes.</p>
    #[serde(rename = "attributePayload")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub attribute_payload: Option<AttributePayload>,
    /// <p>The expected version of the thing record in the registry. If the version of the record in the registry does not match the expected version specified in the request, the <code>UpdateThing</code> request is rejected with a <code>VersionConflictException</code>.</p>
    #[serde(rename = "expectedVersion")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub expected_version: Option<i64>,
    /// <p>Remove a thing type association. If <b>true</b>, the association is removed.</p>
    #[serde(rename = "removeThingType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub remove_thing_type: Option<bool>,
    /// <p>The name of the thing to update.</p> <p>You can't change a thing's name. To change a thing's name, you must create a new thing, give it the new name, and then delete the old thing.</p>
    #[serde(rename = "thingName")]
    pub thing_name: String,
    /// <p>The name of the thing type.</p>
    #[serde(rename = "thingTypeName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_type_name: Option<String>,
}

/// <p>The output from the UpdateThing operation.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateThingResponse {}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateTopicRuleDestinationRequest {
    /// <p>The ARN of the topic rule destination.</p>
    #[serde(rename = "arn")]
    pub arn: String,
    /// <p><p>The status of the topic rule destination. Valid values are:</p> <dl> <dt>IN<em>PROGRESS</dt> <dd> <p>A topic rule destination was created but has not been confirmed. You can set <code>status</code> to <code>IN</em>PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your confirmation endpoint.</p> </dd> <dt>ENABLED</dt> <dd> <p>Confirmation was completed, and traffic to this destination is allowed. You can set <code>status</code> to <code>DISABLED</code> by calling <code>UpdateTopicRuleDestination</code>.</p> </dd> <dt>DISABLED</dt> <dd> <p>Confirmation was completed, and traffic to this destination is not allowed. You can set <code>status</code> to <code>ENABLED</code> by calling <code>UpdateTopicRuleDestination</code>.</p> </dd> <dt>ERROR</dt> <dd> <p>Confirmation could not be completed, for example if the confirmation timed out. You can call <code>GetTopicRuleDestination</code> for details about the error. You can set <code>status</code> to <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your confirmation endpoint.</p> </dd> </dl></p>
    #[serde(rename = "status")]
    pub status: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateTopicRuleDestinationResponse {}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ValidateSecurityProfileBehaviorsRequest {
    /// <p>Specifies the behaviors that, when violated by a device (thing), cause an alert.</p>
    #[serde(rename = "behaviors")]
    pub behaviors: Vec<Behavior>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ValidateSecurityProfileBehaviorsResponse {
    /// <p>True if the behaviors were valid.</p>
    #[serde(rename = "valid")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub valid: Option<bool>,
    /// <p>The list of any errors found in the behaviors.</p>
    #[serde(rename = "validationErrors")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub validation_errors: Option<Vec<ValidationError>>,
}

/// <p>Information about an error found in a behavior specification.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ValidationError {
    /// <p>The description of an error found in the behaviors.</p>
    #[serde(rename = "errorMessage")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub error_message: Option<String>,
}

/// <p>Information about a Device Defender security profile behavior violation.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ViolationEvent {
    /// <p>The behavior that was violated.</p>
    #[serde(rename = "behavior")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub behavior: Option<Behavior>,
    /// <p>The value of the metric (the measurement).</p>
    #[serde(rename = "metricValue")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metric_value: Option<MetricValue>,
    /// <p>The name of the security profile whose behavior was violated.</p>
    #[serde(rename = "securityProfileName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub security_profile_name: Option<String>,
    /// <p>The name of the thing responsible for the violation event.</p>
    #[serde(rename = "thingName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub thing_name: Option<String>,
    /// <p> The details of a violation event. </p>
    #[serde(rename = "violationEventAdditionalInfo")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub violation_event_additional_info: Option<ViolationEventAdditionalInfo>,
    /// <p>The time the violation event occurred.</p>
    #[serde(rename = "violationEventTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub violation_event_time: Option<f64>,
    /// <p>The type of violation event.</p>
    #[serde(rename = "violationEventType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub violation_event_type: Option<String>,
    /// <p>The ID of the violation event.</p>
    #[serde(rename = "violationId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub violation_id: Option<String>,
}

/// <p> The details of a violation event. </p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ViolationEventAdditionalInfo {
    /// <p> The sensitivity of anomalous behavior evaluation. Can be <code>Low</code>, <code>Medium</code>, or <code>High</code>. </p>
    #[serde(rename = "confidenceLevel")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub confidence_level: Option<String>,
}

/// <p> Specifies the time period of which violation events occurred between. </p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ViolationEventOccurrenceRange {
    /// <p> The end date and time of a time period in which violation events occurred. </p>
    #[serde(rename = "endTime")]
    pub end_time: f64,
    /// <p> The start date and time of a time period in which violation events occurred. </p>
    #[serde(rename = "startTime")]
    pub start_time: f64,
}

/// <p>The configuration information for a virtual private cloud (VPC) destination.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct VpcDestinationConfiguration {
    /// <p>The ARN of a role that has permission to create and attach to elastic network interfaces (ENIs).</p>
    #[serde(rename = "roleArn")]
    pub role_arn: String,
    /// <p>The security groups of the VPC destination.</p>
    #[serde(rename = "securityGroups")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub security_groups: Option<Vec<String>>,
    /// <p>The subnet IDs of the VPC destination.</p>
    #[serde(rename = "subnetIds")]
    pub subnet_ids: Vec<String>,
    /// <p>The ID of the VPC.</p>
    #[serde(rename = "vpcId")]
    pub vpc_id: String,
}

/// <p>The properties of a virtual private cloud (VPC) destination.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct VpcDestinationProperties {
    /// <p>The ARN of a role that has permission to create and attach to elastic network interfaces (ENIs).</p>
    #[serde(rename = "roleArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub role_arn: Option<String>,
    /// <p>The security groups of the VPC destination.</p>
    #[serde(rename = "securityGroups")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub security_groups: Option<Vec<String>>,
    /// <p>The subnet IDs of the VPC destination.</p>
    #[serde(rename = "subnetIds")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub subnet_ids: Option<Vec<String>>,
    /// <p>The ID of the VPC.</p>
    #[serde(rename = "vpcId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub vpc_id: Option<String>,
}

/// <p>The summary of a virtual private cloud (VPC) destination.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct VpcDestinationSummary {
    /// <p>The ARN of a role that has permission to create and attach to elastic network interfaces (ENIs).</p>
    #[serde(rename = "roleArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub role_arn: Option<String>,
    /// <p>The security groups of the VPC destination.</p>
    #[serde(rename = "securityGroups")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub security_groups: Option<Vec<String>>,
    /// <p>The subnet IDs of the VPC destination.</p>
    #[serde(rename = "subnetIds")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub subnet_ids: Option<Vec<String>>,
    /// <p>The ID of the VPC.</p>
    #[serde(rename = "vpcId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub vpc_id: Option<String>,
}

/// Errors returned by AcceptCertificateTransfer
#[derive(Debug, PartialEq)]
pub enum AcceptCertificateTransferError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You can't revert the certificate transfer because the transfer is already complete.</p>
    TransferAlreadyCompleted(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl AcceptCertificateTransferError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<AcceptCertificateTransferError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(AcceptCertificateTransferError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(AcceptCertificateTransferError::InvalidRequest(
                        err.msg,
                    ))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(AcceptCertificateTransferError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        AcceptCertificateTransferError::ServiceUnavailable(err.msg),
                    )
                }
                "ThrottlingException" => {
                    return RusotoError::Service(AcceptCertificateTransferError::Throttling(
                        err.msg,
                    ))
                }
                "TransferAlreadyCompletedException" => {
                    return RusotoError::Service(
                        AcceptCertificateTransferError::TransferAlreadyCompleted(err.msg),
                    )
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(AcceptCertificateTransferError::Unauthorized(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for AcceptCertificateTransferError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            AcceptCertificateTransferError::InternalFailure(ref cause) => write!(f, "{}", cause),
            AcceptCertificateTransferError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            AcceptCertificateTransferError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            AcceptCertificateTransferError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            AcceptCertificateTransferError::Throttling(ref cause) => write!(f, "{}", cause),
            AcceptCertificateTransferError::TransferAlreadyCompleted(ref cause) => {
                write!(f, "{}", cause)
            }
            AcceptCertificateTransferError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for AcceptCertificateTransferError {}
/// Errors returned by AddThingToBillingGroup
#[derive(Debug, PartialEq)]
pub enum AddThingToBillingGroupError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl AddThingToBillingGroupError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<AddThingToBillingGroupError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(AddThingToBillingGroupError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(AddThingToBillingGroupError::InvalidRequest(
                        err.msg,
                    ))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(AddThingToBillingGroupError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(AddThingToBillingGroupError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for AddThingToBillingGroupError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            AddThingToBillingGroupError::InternalFailure(ref cause) => write!(f, "{}", cause),
            AddThingToBillingGroupError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            AddThingToBillingGroupError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            AddThingToBillingGroupError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for AddThingToBillingGroupError {}
/// Errors returned by AddThingToThingGroup
#[derive(Debug, PartialEq)]
pub enum AddThingToThingGroupError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl AddThingToThingGroupError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<AddThingToThingGroupError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(AddThingToThingGroupError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(AddThingToThingGroupError::InvalidRequest(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(AddThingToThingGroupError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(AddThingToThingGroupError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for AddThingToThingGroupError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            AddThingToThingGroupError::InternalFailure(ref cause) => write!(f, "{}", cause),
            AddThingToThingGroupError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            AddThingToThingGroupError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            AddThingToThingGroupError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for AddThingToThingGroupError {}
/// Errors returned by AssociateTargetsWithJob
#[derive(Debug, PartialEq)]
pub enum AssociateTargetsWithJobError {
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>A limit has been exceeded.</p>
    LimitExceeded(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl AssociateTargetsWithJobError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<AssociateTargetsWithJobError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InvalidRequestException" => {
                    return RusotoError::Service(AssociateTargetsWithJobError::InvalidRequest(
                        err.msg,
                    ))
                }
                "LimitExceededException" => {
                    return RusotoError::Service(AssociateTargetsWithJobError::LimitExceeded(
                        err.msg,
                    ))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(AssociateTargetsWithJobError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(AssociateTargetsWithJobError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(AssociateTargetsWithJobError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for AssociateTargetsWithJobError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            AssociateTargetsWithJobError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            AssociateTargetsWithJobError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            AssociateTargetsWithJobError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            AssociateTargetsWithJobError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            AssociateTargetsWithJobError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for AssociateTargetsWithJobError {}
/// Errors returned by AttachPolicy
#[derive(Debug, PartialEq)]
pub enum AttachPolicyError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>A limit has been exceeded.</p>
    LimitExceeded(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl AttachPolicyError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<AttachPolicyError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(AttachPolicyError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(AttachPolicyError::InvalidRequest(err.msg))
                }
                "LimitExceededException" => {
                    return RusotoError::Service(AttachPolicyError::LimitExceeded(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(AttachPolicyError::ResourceNotFound(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(AttachPolicyError::ServiceUnavailable(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(AttachPolicyError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(AttachPolicyError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for AttachPolicyError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            AttachPolicyError::InternalFailure(ref cause) => write!(f, "{}", cause),
            AttachPolicyError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            AttachPolicyError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            AttachPolicyError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            AttachPolicyError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            AttachPolicyError::Throttling(ref cause) => write!(f, "{}", cause),
            AttachPolicyError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for AttachPolicyError {}
/// Errors returned by AttachPrincipalPolicy
#[derive(Debug, PartialEq)]
pub enum AttachPrincipalPolicyError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>A limit has been exceeded.</p>
    LimitExceeded(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl AttachPrincipalPolicyError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<AttachPrincipalPolicyError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(AttachPrincipalPolicyError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(AttachPrincipalPolicyError::InvalidRequest(
                        err.msg,
                    ))
                }
                "LimitExceededException" => {
                    return RusotoError::Service(AttachPrincipalPolicyError::LimitExceeded(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(AttachPrincipalPolicyError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(AttachPrincipalPolicyError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(AttachPrincipalPolicyError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(AttachPrincipalPolicyError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for AttachPrincipalPolicyError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            AttachPrincipalPolicyError::InternalFailure(ref cause) => write!(f, "{}", cause),
            AttachPrincipalPolicyError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            AttachPrincipalPolicyError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            AttachPrincipalPolicyError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            AttachPrincipalPolicyError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            AttachPrincipalPolicyError::Throttling(ref cause) => write!(f, "{}", cause),
            AttachPrincipalPolicyError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for AttachPrincipalPolicyError {}
/// Errors returned by AttachSecurityProfile
#[derive(Debug, PartialEq)]
pub enum AttachSecurityProfileError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>A limit has been exceeded.</p>
    LimitExceeded(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>An exception thrown when the version of an entity specified with the <code>expectedVersion</code> parameter does not match the latest version in the system.</p>
    VersionConflict(String),
}

impl AttachSecurityProfileError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<AttachSecurityProfileError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(AttachSecurityProfileError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(AttachSecurityProfileError::InvalidRequest(
                        err.msg,
                    ))
                }
                "LimitExceededException" => {
                    return RusotoError::Service(AttachSecurityProfileError::LimitExceeded(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(AttachSecurityProfileError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(AttachSecurityProfileError::Throttling(err.msg))
                }
                "VersionConflictException" => {
                    return RusotoError::Service(AttachSecurityProfileError::VersionConflict(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for AttachSecurityProfileError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            AttachSecurityProfileError::InternalFailure(ref cause) => write!(f, "{}", cause),
            AttachSecurityProfileError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            AttachSecurityProfileError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            AttachSecurityProfileError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            AttachSecurityProfileError::Throttling(ref cause) => write!(f, "{}", cause),
            AttachSecurityProfileError::VersionConflict(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for AttachSecurityProfileError {}
/// Errors returned by AttachThingPrincipal
#[derive(Debug, PartialEq)]
pub enum AttachThingPrincipalError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl AttachThingPrincipalError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<AttachThingPrincipalError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(AttachThingPrincipalError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(AttachThingPrincipalError::InvalidRequest(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(AttachThingPrincipalError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(AttachThingPrincipalError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(AttachThingPrincipalError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(AttachThingPrincipalError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for AttachThingPrincipalError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            AttachThingPrincipalError::InternalFailure(ref cause) => write!(f, "{}", cause),
            AttachThingPrincipalError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            AttachThingPrincipalError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            AttachThingPrincipalError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            AttachThingPrincipalError::Throttling(ref cause) => write!(f, "{}", cause),
            AttachThingPrincipalError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for AttachThingPrincipalError {}
/// Errors returned by CancelAuditMitigationActionsTask
#[derive(Debug, PartialEq)]
pub enum CancelAuditMitigationActionsTaskError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl CancelAuditMitigationActionsTaskError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<CancelAuditMitigationActionsTaskError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(
                        CancelAuditMitigationActionsTaskError::InternalFailure(err.msg),
                    )
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(
                        CancelAuditMitigationActionsTaskError::InvalidRequest(err.msg),
                    )
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(
                        CancelAuditMitigationActionsTaskError::ResourceNotFound(err.msg),
                    )
                }
                "ThrottlingException" => {
                    return RusotoError::Service(CancelAuditMitigationActionsTaskError::Throttling(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CancelAuditMitigationActionsTaskError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CancelAuditMitigationActionsTaskError::InternalFailure(ref cause) => {
                write!(f, "{}", cause)
            }
            CancelAuditMitigationActionsTaskError::InvalidRequest(ref cause) => {
                write!(f, "{}", cause)
            }
            CancelAuditMitigationActionsTaskError::ResourceNotFound(ref cause) => {
                write!(f, "{}", cause)
            }
            CancelAuditMitigationActionsTaskError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CancelAuditMitigationActionsTaskError {}
/// Errors returned by CancelAuditTask
#[derive(Debug, PartialEq)]
pub enum CancelAuditTaskError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl CancelAuditTaskError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CancelAuditTaskError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(CancelAuditTaskError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(CancelAuditTaskError::InvalidRequest(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(CancelAuditTaskError::ResourceNotFound(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(CancelAuditTaskError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CancelAuditTaskError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CancelAuditTaskError::InternalFailure(ref cause) => write!(f, "{}", cause),
            CancelAuditTaskError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            CancelAuditTaskError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            CancelAuditTaskError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CancelAuditTaskError {}
/// Errors returned by CancelCertificateTransfer
#[derive(Debug, PartialEq)]
pub enum CancelCertificateTransferError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You can't revert the certificate transfer because the transfer is already complete.</p>
    TransferAlreadyCompleted(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl CancelCertificateTransferError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CancelCertificateTransferError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(CancelCertificateTransferError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(CancelCertificateTransferError::InvalidRequest(
                        err.msg,
                    ))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(CancelCertificateTransferError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        CancelCertificateTransferError::ServiceUnavailable(err.msg),
                    )
                }
                "ThrottlingException" => {
                    return RusotoError::Service(CancelCertificateTransferError::Throttling(
                        err.msg,
                    ))
                }
                "TransferAlreadyCompletedException" => {
                    return RusotoError::Service(
                        CancelCertificateTransferError::TransferAlreadyCompleted(err.msg),
                    )
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(CancelCertificateTransferError::Unauthorized(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CancelCertificateTransferError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CancelCertificateTransferError::InternalFailure(ref cause) => write!(f, "{}", cause),
            CancelCertificateTransferError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            CancelCertificateTransferError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            CancelCertificateTransferError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            CancelCertificateTransferError::Throttling(ref cause) => write!(f, "{}", cause),
            CancelCertificateTransferError::TransferAlreadyCompleted(ref cause) => {
                write!(f, "{}", cause)
            }
            CancelCertificateTransferError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CancelCertificateTransferError {}
/// Errors returned by CancelDetectMitigationActionsTask
#[derive(Debug, PartialEq)]
pub enum CancelDetectMitigationActionsTaskError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl CancelDetectMitigationActionsTaskError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<CancelDetectMitigationActionsTaskError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(
                        CancelDetectMitigationActionsTaskError::InternalFailure(err.msg),
                    )
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(
                        CancelDetectMitigationActionsTaskError::InvalidRequest(err.msg),
                    )
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(
                        CancelDetectMitigationActionsTaskError::ResourceNotFound(err.msg),
                    )
                }
                "ThrottlingException" => {
                    return RusotoError::Service(
                        CancelDetectMitigationActionsTaskError::Throttling(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CancelDetectMitigationActionsTaskError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CancelDetectMitigationActionsTaskError::InternalFailure(ref cause) => {
                write!(f, "{}", cause)
            }
            CancelDetectMitigationActionsTaskError::InvalidRequest(ref cause) => {
                write!(f, "{}", cause)
            }
            CancelDetectMitigationActionsTaskError::ResourceNotFound(ref cause) => {
                write!(f, "{}", cause)
            }
            CancelDetectMitigationActionsTaskError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CancelDetectMitigationActionsTaskError {}
/// Errors returned by CancelJob
#[derive(Debug, PartialEq)]
pub enum CancelJobError {
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl CancelJobError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CancelJobError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InvalidRequestException" => {
                    return RusotoError::Service(CancelJobError::InvalidRequest(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(CancelJobError::ResourceNotFound(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(CancelJobError::ServiceUnavailable(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(CancelJobError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CancelJobError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CancelJobError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            CancelJobError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            CancelJobError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            CancelJobError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CancelJobError {}
/// Errors returned by CancelJobExecution
#[derive(Debug, PartialEq)]
pub enum CancelJobExecutionError {
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>An attempt was made to change to an invalid state, for example by deleting a job or a job execution which is "IN_PROGRESS" without setting the <code>force</code> parameter.</p>
    InvalidStateTransition(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>An exception thrown when the version of an entity specified with the <code>expectedVersion</code> parameter does not match the latest version in the system.</p>
    VersionConflict(String),
}

impl CancelJobExecutionError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CancelJobExecutionError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InvalidRequestException" => {
                    return RusotoError::Service(CancelJobExecutionError::InvalidRequest(err.msg))
                }
                "InvalidStateTransitionException" => {
                    return RusotoError::Service(CancelJobExecutionError::InvalidStateTransition(
                        err.msg,
                    ))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(CancelJobExecutionError::ResourceNotFound(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(CancelJobExecutionError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(CancelJobExecutionError::Throttling(err.msg))
                }
                "VersionConflictException" => {
                    return RusotoError::Service(CancelJobExecutionError::VersionConflict(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CancelJobExecutionError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CancelJobExecutionError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            CancelJobExecutionError::InvalidStateTransition(ref cause) => write!(f, "{}", cause),
            CancelJobExecutionError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            CancelJobExecutionError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            CancelJobExecutionError::Throttling(ref cause) => write!(f, "{}", cause),
            CancelJobExecutionError::VersionConflict(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CancelJobExecutionError {}
/// Errors returned by ClearDefaultAuthorizer
#[derive(Debug, PartialEq)]
pub enum ClearDefaultAuthorizerError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl ClearDefaultAuthorizerError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ClearDefaultAuthorizerError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(ClearDefaultAuthorizerError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(ClearDefaultAuthorizerError::InvalidRequest(
                        err.msg,
                    ))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(ClearDefaultAuthorizerError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(ClearDefaultAuthorizerError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ClearDefaultAuthorizerError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(ClearDefaultAuthorizerError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ClearDefaultAuthorizerError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ClearDefaultAuthorizerError::InternalFailure(ref cause) => write!(f, "{}", cause),
            ClearDefaultAuthorizerError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            ClearDefaultAuthorizerError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            ClearDefaultAuthorizerError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            ClearDefaultAuthorizerError::Throttling(ref cause) => write!(f, "{}", cause),
            ClearDefaultAuthorizerError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ClearDefaultAuthorizerError {}
/// Errors returned by ConfirmTopicRuleDestination
#[derive(Debug, PartialEq)]
pub enum ConfirmTopicRuleDestinationError {
    /// <p>A conflicting resource update exception. This exception is thrown when two pending updates cause a conflict.</p>
    ConflictingResourceUpdate(String),
    /// <p>An unexpected error has occurred.</p>
    Internal(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl ConfirmTopicRuleDestinationError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<ConfirmTopicRuleDestinationError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "ConflictingResourceUpdateException" => {
                    return RusotoError::Service(
                        ConfirmTopicRuleDestinationError::ConflictingResourceUpdate(err.msg),
                    )
                }
                "InternalException" => {
                    return RusotoError::Service(ConfirmTopicRuleDestinationError::Internal(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(ConfirmTopicRuleDestinationError::InvalidRequest(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        ConfirmTopicRuleDestinationError::ServiceUnavailable(err.msg),
                    )
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(ConfirmTopicRuleDestinationError::Unauthorized(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ConfirmTopicRuleDestinationError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ConfirmTopicRuleDestinationError::ConflictingResourceUpdate(ref cause) => {
                write!(f, "{}", cause)
            }
            ConfirmTopicRuleDestinationError::Internal(ref cause) => write!(f, "{}", cause),
            ConfirmTopicRuleDestinationError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            ConfirmTopicRuleDestinationError::ServiceUnavailable(ref cause) => {
                write!(f, "{}", cause)
            }
            ConfirmTopicRuleDestinationError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ConfirmTopicRuleDestinationError {}
/// Errors returned by CreateAuditSuppression
#[derive(Debug, PartialEq)]
pub enum CreateAuditSuppressionError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>A limit has been exceeded.</p>
    LimitExceeded(String),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExists(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl CreateAuditSuppressionError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateAuditSuppressionError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(CreateAuditSuppressionError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(CreateAuditSuppressionError::InvalidRequest(
                        err.msg,
                    ))
                }
                "LimitExceededException" => {
                    return RusotoError::Service(CreateAuditSuppressionError::LimitExceeded(
                        err.msg,
                    ))
                }
                "ResourceAlreadyExistsException" => {
                    return RusotoError::Service(
                        CreateAuditSuppressionError::ResourceAlreadyExists(err.msg),
                    )
                }
                "ThrottlingException" => {
                    return RusotoError::Service(CreateAuditSuppressionError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateAuditSuppressionError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateAuditSuppressionError::InternalFailure(ref cause) => write!(f, "{}", cause),
            CreateAuditSuppressionError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            CreateAuditSuppressionError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            CreateAuditSuppressionError::ResourceAlreadyExists(ref cause) => write!(f, "{}", cause),
            CreateAuditSuppressionError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateAuditSuppressionError {}
/// Errors returned by CreateAuthorizer
#[derive(Debug, PartialEq)]
pub enum CreateAuthorizerError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>A limit has been exceeded.</p>
    LimitExceeded(String),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExists(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl CreateAuthorizerError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateAuthorizerError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(CreateAuthorizerError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(CreateAuthorizerError::InvalidRequest(err.msg))
                }
                "LimitExceededException" => {
                    return RusotoError::Service(CreateAuthorizerError::LimitExceeded(err.msg))
                }
                "ResourceAlreadyExistsException" => {
                    return RusotoError::Service(CreateAuthorizerError::ResourceAlreadyExists(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(CreateAuthorizerError::ServiceUnavailable(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(CreateAuthorizerError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(CreateAuthorizerError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateAuthorizerError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateAuthorizerError::InternalFailure(ref cause) => write!(f, "{}", cause),
            CreateAuthorizerError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            CreateAuthorizerError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            CreateAuthorizerError::ResourceAlreadyExists(ref cause) => write!(f, "{}", cause),
            CreateAuthorizerError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            CreateAuthorizerError::Throttling(ref cause) => write!(f, "{}", cause),
            CreateAuthorizerError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateAuthorizerError {}
/// Errors returned by CreateBillingGroup
#[derive(Debug, PartialEq)]
pub enum CreateBillingGroupError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExists(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl CreateBillingGroupError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateBillingGroupError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(CreateBillingGroupError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(CreateBillingGroupError::InvalidRequest(err.msg))
                }
                "ResourceAlreadyExistsException" => {
                    return RusotoError::Service(CreateBillingGroupError::ResourceAlreadyExists(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(CreateBillingGroupError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateBillingGroupError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateBillingGroupError::InternalFailure(ref cause) => write!(f, "{}", cause),
            CreateBillingGroupError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            CreateBillingGroupError::ResourceAlreadyExists(ref cause) => write!(f, "{}", cause),
            CreateBillingGroupError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateBillingGroupError {}
/// Errors returned by CreateCertificateFromCsr
#[derive(Debug, PartialEq)]
pub enum CreateCertificateFromCsrError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl CreateCertificateFromCsrError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateCertificateFromCsrError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(CreateCertificateFromCsrError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(CreateCertificateFromCsrError::InvalidRequest(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(CreateCertificateFromCsrError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(CreateCertificateFromCsrError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(CreateCertificateFromCsrError::Unauthorized(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateCertificateFromCsrError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateCertificateFromCsrError::InternalFailure(ref cause) => write!(f, "{}", cause),
            CreateCertificateFromCsrError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            CreateCertificateFromCsrError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            CreateCertificateFromCsrError::Throttling(ref cause) => write!(f, "{}", cause),
            CreateCertificateFromCsrError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateCertificateFromCsrError {}
/// Errors returned by CreateCustomMetric
#[derive(Debug, PartialEq)]
pub enum CreateCustomMetricError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>A limit has been exceeded.</p>
    LimitExceeded(String),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExists(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl CreateCustomMetricError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateCustomMetricError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(CreateCustomMetricError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(CreateCustomMetricError::InvalidRequest(err.msg))
                }
                "LimitExceededException" => {
                    return RusotoError::Service(CreateCustomMetricError::LimitExceeded(err.msg))
                }
                "ResourceAlreadyExistsException" => {
                    return RusotoError::Service(CreateCustomMetricError::ResourceAlreadyExists(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(CreateCustomMetricError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateCustomMetricError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateCustomMetricError::InternalFailure(ref cause) => write!(f, "{}", cause),
            CreateCustomMetricError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            CreateCustomMetricError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            CreateCustomMetricError::ResourceAlreadyExists(ref cause) => write!(f, "{}", cause),
            CreateCustomMetricError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateCustomMetricError {}
/// Errors returned by CreateDimension
#[derive(Debug, PartialEq)]
pub enum CreateDimensionError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>A limit has been exceeded.</p>
    LimitExceeded(String),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExists(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl CreateDimensionError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateDimensionError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(CreateDimensionError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(CreateDimensionError::InvalidRequest(err.msg))
                }
                "LimitExceededException" => {
                    return RusotoError::Service(CreateDimensionError::LimitExceeded(err.msg))
                }
                "ResourceAlreadyExistsException" => {
                    return RusotoError::Service(CreateDimensionError::ResourceAlreadyExists(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(CreateDimensionError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateDimensionError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateDimensionError::InternalFailure(ref cause) => write!(f, "{}", cause),
            CreateDimensionError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            CreateDimensionError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            CreateDimensionError::ResourceAlreadyExists(ref cause) => write!(f, "{}", cause),
            CreateDimensionError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateDimensionError {}
/// Errors returned by CreateDomainConfiguration
#[derive(Debug, PartialEq)]
pub enum CreateDomainConfigurationError {
    /// <p>The certificate is invalid.</p>
    CertificateValidation(String),
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>A limit has been exceeded.</p>
    LimitExceeded(String),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExists(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl CreateDomainConfigurationError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateDomainConfigurationError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "CertificateValidationException" => {
                    return RusotoError::Service(
                        CreateDomainConfigurationError::CertificateValidation(err.msg),
                    )
                }
                "InternalFailureException" => {
                    return RusotoError::Service(CreateDomainConfigurationError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(CreateDomainConfigurationError::InvalidRequest(
                        err.msg,
                    ))
                }
                "LimitExceededException" => {
                    return RusotoError::Service(CreateDomainConfigurationError::LimitExceeded(
                        err.msg,
                    ))
                }
                "ResourceAlreadyExistsException" => {
                    return RusotoError::Service(
                        CreateDomainConfigurationError::ResourceAlreadyExists(err.msg),
                    )
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        CreateDomainConfigurationError::ServiceUnavailable(err.msg),
                    )
                }
                "ThrottlingException" => {
                    return RusotoError::Service(CreateDomainConfigurationError::Throttling(
                        err.msg,
                    ))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(CreateDomainConfigurationError::Unauthorized(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateDomainConfigurationError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateDomainConfigurationError::CertificateValidation(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateDomainConfigurationError::InternalFailure(ref cause) => write!(f, "{}", cause),
            CreateDomainConfigurationError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            CreateDomainConfigurationError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            CreateDomainConfigurationError::ResourceAlreadyExists(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateDomainConfigurationError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            CreateDomainConfigurationError::Throttling(ref cause) => write!(f, "{}", cause),
            CreateDomainConfigurationError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateDomainConfigurationError {}
/// Errors returned by CreateDynamicThingGroup
#[derive(Debug, PartialEq)]
pub enum CreateDynamicThingGroupError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The query is invalid.</p>
    InvalidQuery(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>A limit has been exceeded.</p>
    LimitExceeded(String),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExists(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl CreateDynamicThingGroupError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateDynamicThingGroupError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(CreateDynamicThingGroupError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidQueryException" => {
                    return RusotoError::Service(CreateDynamicThingGroupError::InvalidQuery(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(CreateDynamicThingGroupError::InvalidRequest(
                        err.msg,
                    ))
                }
                "LimitExceededException" => {
                    return RusotoError::Service(CreateDynamicThingGroupError::LimitExceeded(
                        err.msg,
                    ))
                }
                "ResourceAlreadyExistsException" => {
                    return RusotoError::Service(
                        CreateDynamicThingGroupError::ResourceAlreadyExists(err.msg),
                    )
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(CreateDynamicThingGroupError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(CreateDynamicThingGroupError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateDynamicThingGroupError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateDynamicThingGroupError::InternalFailure(ref cause) => write!(f, "{}", cause),
            CreateDynamicThingGroupError::InvalidQuery(ref cause) => write!(f, "{}", cause),
            CreateDynamicThingGroupError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            CreateDynamicThingGroupError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            CreateDynamicThingGroupError::ResourceAlreadyExists(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateDynamicThingGroupError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            CreateDynamicThingGroupError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateDynamicThingGroupError {}
/// Errors returned by CreateJob
#[derive(Debug, PartialEq)]
pub enum CreateJobError {
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>A limit has been exceeded.</p>
    LimitExceeded(String),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExists(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl CreateJobError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateJobError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InvalidRequestException" => {
                    return RusotoError::Service(CreateJobError::InvalidRequest(err.msg))
                }
                "LimitExceededException" => {
                    return RusotoError::Service(CreateJobError::LimitExceeded(err.msg))
                }
                "ResourceAlreadyExistsException" => {
                    return RusotoError::Service(CreateJobError::ResourceAlreadyExists(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(CreateJobError::ResourceNotFound(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(CreateJobError::ServiceUnavailable(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(CreateJobError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateJobError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateJobError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            CreateJobError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            CreateJobError::ResourceAlreadyExists(ref cause) => write!(f, "{}", cause),
            CreateJobError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            CreateJobError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            CreateJobError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateJobError {}
/// Errors returned by CreateJobTemplate
#[derive(Debug, PartialEq)]
pub enum CreateJobTemplateError {
    /// <p>A resource with the same name already exists.</p>
    Conflict(String),
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>A limit has been exceeded.</p>
    LimitExceeded(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl CreateJobTemplateError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateJobTemplateError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "ConflictException" => {
                    return RusotoError::Service(CreateJobTemplateError::Conflict(err.msg))
                }
                "InternalFailureException" => {
                    return RusotoError::Service(CreateJobTemplateError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(CreateJobTemplateError::InvalidRequest(err.msg))
                }
                "LimitExceededException" => {
                    return RusotoError::Service(CreateJobTemplateError::LimitExceeded(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(CreateJobTemplateError::ResourceNotFound(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(CreateJobTemplateError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateJobTemplateError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateJobTemplateError::Conflict(ref cause) => write!(f, "{}", cause),
            CreateJobTemplateError::InternalFailure(ref cause) => write!(f, "{}", cause),
            CreateJobTemplateError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            CreateJobTemplateError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            CreateJobTemplateError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            CreateJobTemplateError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateJobTemplateError {}
/// Errors returned by CreateKeysAndCertificate
#[derive(Debug, PartialEq)]
pub enum CreateKeysAndCertificateError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl CreateKeysAndCertificateError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateKeysAndCertificateError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(CreateKeysAndCertificateError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(CreateKeysAndCertificateError::InvalidRequest(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(CreateKeysAndCertificateError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(CreateKeysAndCertificateError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(CreateKeysAndCertificateError::Unauthorized(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateKeysAndCertificateError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateKeysAndCertificateError::InternalFailure(ref cause) => write!(f, "{}", cause),
            CreateKeysAndCertificateError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            CreateKeysAndCertificateError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            CreateKeysAndCertificateError::Throttling(ref cause) => write!(f, "{}", cause),
            CreateKeysAndCertificateError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateKeysAndCertificateError {}
/// Errors returned by CreateMitigationAction
#[derive(Debug, PartialEq)]
pub enum CreateMitigationActionError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>A limit has been exceeded.</p>
    LimitExceeded(String),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExists(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl CreateMitigationActionError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateMitigationActionError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(CreateMitigationActionError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(CreateMitigationActionError::InvalidRequest(
                        err.msg,
                    ))
                }
                "LimitExceededException" => {
                    return RusotoError::Service(CreateMitigationActionError::LimitExceeded(
                        err.msg,
                    ))
                }
                "ResourceAlreadyExistsException" => {
                    return RusotoError::Service(
                        CreateMitigationActionError::ResourceAlreadyExists(err.msg),
                    )
                }
                "ThrottlingException" => {
                    return RusotoError::Service(CreateMitigationActionError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateMitigationActionError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateMitigationActionError::InternalFailure(ref cause) => write!(f, "{}", cause),
            CreateMitigationActionError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            CreateMitigationActionError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            CreateMitigationActionError::ResourceAlreadyExists(ref cause) => write!(f, "{}", cause),
            CreateMitigationActionError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateMitigationActionError {}
/// Errors returned by CreateOTAUpdate
#[derive(Debug, PartialEq)]
pub enum CreateOTAUpdateError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>A limit has been exceeded.</p>
    LimitExceeded(String),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExists(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl CreateOTAUpdateError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateOTAUpdateError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(CreateOTAUpdateError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(CreateOTAUpdateError::InvalidRequest(err.msg))
                }
                "LimitExceededException" => {
                    return RusotoError::Service(CreateOTAUpdateError::LimitExceeded(err.msg))
                }
                "ResourceAlreadyExistsException" => {
                    return RusotoError::Service(CreateOTAUpdateError::ResourceAlreadyExists(
                        err.msg,
                    ))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(CreateOTAUpdateError::ResourceNotFound(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(CreateOTAUpdateError::ServiceUnavailable(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(CreateOTAUpdateError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(CreateOTAUpdateError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateOTAUpdateError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateOTAUpdateError::InternalFailure(ref cause) => write!(f, "{}", cause),
            CreateOTAUpdateError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            CreateOTAUpdateError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            CreateOTAUpdateError::ResourceAlreadyExists(ref cause) => write!(f, "{}", cause),
            CreateOTAUpdateError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            CreateOTAUpdateError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            CreateOTAUpdateError::Throttling(ref cause) => write!(f, "{}", cause),
            CreateOTAUpdateError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateOTAUpdateError {}
/// Errors returned by CreatePolicy
#[derive(Debug, PartialEq)]
pub enum CreatePolicyError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The policy documentation is not valid.</p>
    MalformedPolicy(String),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExists(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl CreatePolicyError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreatePolicyError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(CreatePolicyError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(CreatePolicyError::InvalidRequest(err.msg))
                }
                "MalformedPolicyException" => {
                    return RusotoError::Service(CreatePolicyError::MalformedPolicy(err.msg))
                }
                "ResourceAlreadyExistsException" => {
                    return RusotoError::Service(CreatePolicyError::ResourceAlreadyExists(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(CreatePolicyError::ServiceUnavailable(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(CreatePolicyError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(CreatePolicyError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreatePolicyError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreatePolicyError::InternalFailure(ref cause) => write!(f, "{}", cause),
            CreatePolicyError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            CreatePolicyError::MalformedPolicy(ref cause) => write!(f, "{}", cause),
            CreatePolicyError::ResourceAlreadyExists(ref cause) => write!(f, "{}", cause),
            CreatePolicyError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            CreatePolicyError::Throttling(ref cause) => write!(f, "{}", cause),
            CreatePolicyError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreatePolicyError {}
/// Errors returned by CreatePolicyVersion
#[derive(Debug, PartialEq)]
pub enum CreatePolicyVersionError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The policy documentation is not valid.</p>
    MalformedPolicy(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
    /// <p>The number of policy versions exceeds the limit.</p>
    VersionsLimitExceeded(String),
}

impl CreatePolicyVersionError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreatePolicyVersionError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(CreatePolicyVersionError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(CreatePolicyVersionError::InvalidRequest(err.msg))
                }
                "MalformedPolicyException" => {
                    return RusotoError::Service(CreatePolicyVersionError::MalformedPolicy(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(CreatePolicyVersionError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(CreatePolicyVersionError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(CreatePolicyVersionError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(CreatePolicyVersionError::Unauthorized(err.msg))
                }
                "VersionsLimitExceededException" => {
                    return RusotoError::Service(CreatePolicyVersionError::VersionsLimitExceeded(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreatePolicyVersionError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreatePolicyVersionError::InternalFailure(ref cause) => write!(f, "{}", cause),
            CreatePolicyVersionError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            CreatePolicyVersionError::MalformedPolicy(ref cause) => write!(f, "{}", cause),
            CreatePolicyVersionError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            CreatePolicyVersionError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            CreatePolicyVersionError::Throttling(ref cause) => write!(f, "{}", cause),
            CreatePolicyVersionError::Unauthorized(ref cause) => write!(f, "{}", cause),
            CreatePolicyVersionError::VersionsLimitExceeded(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreatePolicyVersionError {}
/// Errors returned by CreateProvisioningClaim
#[derive(Debug, PartialEq)]
pub enum CreateProvisioningClaimError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl CreateProvisioningClaimError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateProvisioningClaimError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(CreateProvisioningClaimError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(CreateProvisioningClaimError::InvalidRequest(
                        err.msg,
                    ))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(CreateProvisioningClaimError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(CreateProvisioningClaimError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(CreateProvisioningClaimError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(CreateProvisioningClaimError::Unauthorized(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateProvisioningClaimError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateProvisioningClaimError::InternalFailure(ref cause) => write!(f, "{}", cause),
            CreateProvisioningClaimError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            CreateProvisioningClaimError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            CreateProvisioningClaimError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            CreateProvisioningClaimError::Throttling(ref cause) => write!(f, "{}", cause),
            CreateProvisioningClaimError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateProvisioningClaimError {}
/// Errors returned by CreateProvisioningTemplate
#[derive(Debug, PartialEq)]
pub enum CreateProvisioningTemplateError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>A limit has been exceeded.</p>
    LimitExceeded(String),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExists(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl CreateProvisioningTemplateError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<CreateProvisioningTemplateError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(CreateProvisioningTemplateError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(CreateProvisioningTemplateError::InvalidRequest(
                        err.msg,
                    ))
                }
                "LimitExceededException" => {
                    return RusotoError::Service(CreateProvisioningTemplateError::LimitExceeded(
                        err.msg,
                    ))
                }
                "ResourceAlreadyExistsException" => {
                    return RusotoError::Service(
                        CreateProvisioningTemplateError::ResourceAlreadyExists(err.msg),
                    )
                }
                "ThrottlingException" => {
                    return RusotoError::Service(CreateProvisioningTemplateError::Throttling(
                        err.msg,
                    ))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(CreateProvisioningTemplateError::Unauthorized(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateProvisioningTemplateError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateProvisioningTemplateError::InternalFailure(ref cause) => write!(f, "{}", cause),
            CreateProvisioningTemplateError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            CreateProvisioningTemplateError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            CreateProvisioningTemplateError::ResourceAlreadyExists(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateProvisioningTemplateError::Throttling(ref cause) => write!(f, "{}", cause),
            CreateProvisioningTemplateError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateProvisioningTemplateError {}
/// Errors returned by CreateProvisioningTemplateVersion
#[derive(Debug, PartialEq)]
pub enum CreateProvisioningTemplateVersionError {
    /// <p>A conflicting resource update exception. This exception is thrown when two pending updates cause a conflict.</p>
    ConflictingResourceUpdate(String),
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
    /// <p>The number of policy versions exceeds the limit.</p>
    VersionsLimitExceeded(String),
}

impl CreateProvisioningTemplateVersionError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<CreateProvisioningTemplateVersionError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "ConflictingResourceUpdateException" => {
                    return RusotoError::Service(
                        CreateProvisioningTemplateVersionError::ConflictingResourceUpdate(err.msg),
                    )
                }
                "InternalFailureException" => {
                    return RusotoError::Service(
                        CreateProvisioningTemplateVersionError::InternalFailure(err.msg),
                    )
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(
                        CreateProvisioningTemplateVersionError::InvalidRequest(err.msg),
                    )
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(
                        CreateProvisioningTemplateVersionError::ResourceNotFound(err.msg),
                    )
                }
                "ThrottlingException" => {
                    return RusotoError::Service(
                        CreateProvisioningTemplateVersionError::Throttling(err.msg),
                    )
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(
                        CreateProvisioningTemplateVersionError::Unauthorized(err.msg),
                    )
                }
                "VersionsLimitExceededException" => {
                    return RusotoError::Service(
                        CreateProvisioningTemplateVersionError::VersionsLimitExceeded(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateProvisioningTemplateVersionError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateProvisioningTemplateVersionError::ConflictingResourceUpdate(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateProvisioningTemplateVersionError::InternalFailure(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateProvisioningTemplateVersionError::InvalidRequest(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateProvisioningTemplateVersionError::ResourceNotFound(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateProvisioningTemplateVersionError::Throttling(ref cause) => write!(f, "{}", cause),
            CreateProvisioningTemplateVersionError::Unauthorized(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateProvisioningTemplateVersionError::VersionsLimitExceeded(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for CreateProvisioningTemplateVersionError {}
/// Errors returned by CreateRoleAlias
#[derive(Debug, PartialEq)]
pub enum CreateRoleAliasError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>A limit has been exceeded.</p>
    LimitExceeded(String),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExists(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl CreateRoleAliasError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateRoleAliasError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(CreateRoleAliasError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(CreateRoleAliasError::InvalidRequest(err.msg))
                }
                "LimitExceededException" => {
                    return RusotoError::Service(CreateRoleAliasError::LimitExceeded(err.msg))
                }
                "ResourceAlreadyExistsException" => {
                    return RusotoError::Service(CreateRoleAliasError::ResourceAlreadyExists(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(CreateRoleAliasError::ServiceUnavailable(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(CreateRoleAliasError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(CreateRoleAliasError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateRoleAliasError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateRoleAliasError::InternalFailure(ref cause) => write!(f, "{}", cause),
            CreateRoleAliasError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            CreateRoleAliasError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            CreateRoleAliasError::ResourceAlreadyExists(ref cause) => write!(f, "{}", cause),
            CreateRoleAliasError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            CreateRoleAliasError::Throttling(ref cause) => write!(f, "{}", cause),
            CreateRoleAliasError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateRoleAliasError {}
/// Errors returned by CreateScheduledAudit
#[derive(Debug, PartialEq)]
pub enum CreateScheduledAuditError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>A limit has been exceeded.</p>
    LimitExceeded(String),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExists(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl CreateScheduledAuditError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateScheduledAuditError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(CreateScheduledAuditError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(CreateScheduledAuditError::InvalidRequest(err.msg))
                }
                "LimitExceededException" => {
                    return RusotoError::Service(CreateScheduledAuditError::LimitExceeded(err.msg))
                }
                "ResourceAlreadyExistsException" => {
                    return RusotoError::Service(CreateScheduledAuditError::ResourceAlreadyExists(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(CreateScheduledAuditError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateScheduledAuditError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateScheduledAuditError::InternalFailure(ref cause) => write!(f, "{}", cause),
            CreateScheduledAuditError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            CreateScheduledAuditError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            CreateScheduledAuditError::ResourceAlreadyExists(ref cause) => write!(f, "{}", cause),
            CreateScheduledAuditError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateScheduledAuditError {}
/// Errors returned by CreateSecurityProfile
#[derive(Debug, PartialEq)]
pub enum CreateSecurityProfileError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExists(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl CreateSecurityProfileError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateSecurityProfileError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(CreateSecurityProfileError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(CreateSecurityProfileError::InvalidRequest(
                        err.msg,
                    ))
                }
                "ResourceAlreadyExistsException" => {
                    return RusotoError::Service(CreateSecurityProfileError::ResourceAlreadyExists(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(CreateSecurityProfileError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateSecurityProfileError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateSecurityProfileError::InternalFailure(ref cause) => write!(f, "{}", cause),
            CreateSecurityProfileError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            CreateSecurityProfileError::ResourceAlreadyExists(ref cause) => write!(f, "{}", cause),
            CreateSecurityProfileError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateSecurityProfileError {}
/// Errors returned by CreateStream
#[derive(Debug, PartialEq)]
pub enum CreateStreamError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>A limit has been exceeded.</p>
    LimitExceeded(String),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExists(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl CreateStreamError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateStreamError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(CreateStreamError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(CreateStreamError::InvalidRequest(err.msg))
                }
                "LimitExceededException" => {
                    return RusotoError::Service(CreateStreamError::LimitExceeded(err.msg))
                }
                "ResourceAlreadyExistsException" => {
                    return RusotoError::Service(CreateStreamError::ResourceAlreadyExists(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(CreateStreamError::ResourceNotFound(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(CreateStreamError::ServiceUnavailable(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(CreateStreamError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(CreateStreamError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateStreamError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateStreamError::InternalFailure(ref cause) => write!(f, "{}", cause),
            CreateStreamError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            CreateStreamError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            CreateStreamError::ResourceAlreadyExists(ref cause) => write!(f, "{}", cause),
            CreateStreamError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            CreateStreamError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            CreateStreamError::Throttling(ref cause) => write!(f, "{}", cause),
            CreateStreamError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateStreamError {}
/// Errors returned by CreateThing
#[derive(Debug, PartialEq)]
pub enum CreateThingError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExists(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl CreateThingError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateThingError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(CreateThingError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(CreateThingError::InvalidRequest(err.msg))
                }
                "ResourceAlreadyExistsException" => {
                    return RusotoError::Service(CreateThingError::ResourceAlreadyExists(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(CreateThingError::ResourceNotFound(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(CreateThingError::ServiceUnavailable(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(CreateThingError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(CreateThingError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateThingError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateThingError::InternalFailure(ref cause) => write!(f, "{}", cause),
            CreateThingError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            CreateThingError::ResourceAlreadyExists(ref cause) => write!(f, "{}", cause),
            CreateThingError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            CreateThingError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            CreateThingError::Throttling(ref cause) => write!(f, "{}", cause),
            CreateThingError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateThingError {}
/// Errors returned by CreateThingGroup
#[derive(Debug, PartialEq)]
pub enum CreateThingGroupError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExists(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl CreateThingGroupError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateThingGroupError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(CreateThingGroupError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(CreateThingGroupError::InvalidRequest(err.msg))
                }
                "ResourceAlreadyExistsException" => {
                    return RusotoError::Service(CreateThingGroupError::ResourceAlreadyExists(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(CreateThingGroupError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateThingGroupError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateThingGroupError::InternalFailure(ref cause) => write!(f, "{}", cause),
            CreateThingGroupError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            CreateThingGroupError::ResourceAlreadyExists(ref cause) => write!(f, "{}", cause),
            CreateThingGroupError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateThingGroupError {}
/// Errors returned by CreateThingType
#[derive(Debug, PartialEq)]
pub enum CreateThingTypeError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExists(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl CreateThingTypeError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateThingTypeError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(CreateThingTypeError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(CreateThingTypeError::InvalidRequest(err.msg))
                }
                "ResourceAlreadyExistsException" => {
                    return RusotoError::Service(CreateThingTypeError::ResourceAlreadyExists(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(CreateThingTypeError::ServiceUnavailable(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(CreateThingTypeError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(CreateThingTypeError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateThingTypeError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateThingTypeError::InternalFailure(ref cause) => write!(f, "{}", cause),
            CreateThingTypeError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            CreateThingTypeError::ResourceAlreadyExists(ref cause) => write!(f, "{}", cause),
            CreateThingTypeError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            CreateThingTypeError::Throttling(ref cause) => write!(f, "{}", cause),
            CreateThingTypeError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateThingTypeError {}
/// Errors returned by CreateTopicRule
#[derive(Debug, PartialEq)]
pub enum CreateTopicRuleError {
    /// <p>A conflicting resource update exception. This exception is thrown when two pending updates cause a conflict.</p>
    ConflictingResourceUpdate(String),
    /// <p>An unexpected error has occurred.</p>
    Internal(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExists(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The Rule-SQL expression can't be parsed correctly.</p>
    SqlParse(String),
}

impl CreateTopicRuleError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateTopicRuleError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "ConflictingResourceUpdateException" => {
                    return RusotoError::Service(CreateTopicRuleError::ConflictingResourceUpdate(
                        err.msg,
                    ))
                }
                "InternalException" => {
                    return RusotoError::Service(CreateTopicRuleError::Internal(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(CreateTopicRuleError::InvalidRequest(err.msg))
                }
                "ResourceAlreadyExistsException" => {
                    return RusotoError::Service(CreateTopicRuleError::ResourceAlreadyExists(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(CreateTopicRuleError::ServiceUnavailable(err.msg))
                }
                "SqlParseException" => {
                    return RusotoError::Service(CreateTopicRuleError::SqlParse(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateTopicRuleError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateTopicRuleError::ConflictingResourceUpdate(ref cause) => write!(f, "{}", cause),
            CreateTopicRuleError::Internal(ref cause) => write!(f, "{}", cause),
            CreateTopicRuleError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            CreateTopicRuleError::ResourceAlreadyExists(ref cause) => write!(f, "{}", cause),
            CreateTopicRuleError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            CreateTopicRuleError::SqlParse(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateTopicRuleError {}
/// Errors returned by CreateTopicRuleDestination
#[derive(Debug, PartialEq)]
pub enum CreateTopicRuleDestinationError {
    /// <p>A conflicting resource update exception. This exception is thrown when two pending updates cause a conflict.</p>
    ConflictingResourceUpdate(String),
    /// <p>An unexpected error has occurred.</p>
    Internal(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExists(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
}

impl CreateTopicRuleDestinationError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<CreateTopicRuleDestinationError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "ConflictingResourceUpdateException" => {
                    return RusotoError::Service(
                        CreateTopicRuleDestinationError::ConflictingResourceUpdate(err.msg),
                    )
                }
                "InternalException" => {
                    return RusotoError::Service(CreateTopicRuleDestinationError::Internal(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(CreateTopicRuleDestinationError::InvalidRequest(
                        err.msg,
                    ))
                }
                "ResourceAlreadyExistsException" => {
                    return RusotoError::Service(
                        CreateTopicRuleDestinationError::ResourceAlreadyExists(err.msg),
                    )
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        CreateTopicRuleDestinationError::ServiceUnavailable(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateTopicRuleDestinationError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateTopicRuleDestinationError::ConflictingResourceUpdate(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateTopicRuleDestinationError::Internal(ref cause) => write!(f, "{}", cause),
            CreateTopicRuleDestinationError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            CreateTopicRuleDestinationError::ResourceAlreadyExists(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateTopicRuleDestinationError::ServiceUnavailable(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for CreateTopicRuleDestinationError {}
/// Errors returned by DeleteAccountAuditConfiguration
#[derive(Debug, PartialEq)]
pub enum DeleteAccountAuditConfigurationError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl DeleteAccountAuditConfigurationError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<DeleteAccountAuditConfigurationError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(
                        DeleteAccountAuditConfigurationError::InternalFailure(err.msg),
                    )
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(
                        DeleteAccountAuditConfigurationError::InvalidRequest(err.msg),
                    )
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(
                        DeleteAccountAuditConfigurationError::ResourceNotFound(err.msg),
                    )
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DeleteAccountAuditConfigurationError::Throttling(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteAccountAuditConfigurationError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteAccountAuditConfigurationError::InternalFailure(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteAccountAuditConfigurationError::InvalidRequest(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteAccountAuditConfigurationError::ResourceNotFound(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteAccountAuditConfigurationError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteAccountAuditConfigurationError {}
/// Errors returned by DeleteAuditSuppression
#[derive(Debug, PartialEq)]
pub enum DeleteAuditSuppressionError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl DeleteAuditSuppressionError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteAuditSuppressionError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(DeleteAuditSuppressionError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DeleteAuditSuppressionError::InvalidRequest(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DeleteAuditSuppressionError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteAuditSuppressionError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteAuditSuppressionError::InternalFailure(ref cause) => write!(f, "{}", cause),
            DeleteAuditSuppressionError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DeleteAuditSuppressionError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteAuditSuppressionError {}
/// Errors returned by DeleteAuthorizer
#[derive(Debug, PartialEq)]
pub enum DeleteAuthorizerError {
    /// <p>You can't delete the resource because it is attached to one or more resources.</p>
    DeleteConflict(String),
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl DeleteAuthorizerError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteAuthorizerError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "DeleteConflictException" => {
                    return RusotoError::Service(DeleteAuthorizerError::DeleteConflict(err.msg))
                }
                "InternalFailureException" => {
                    return RusotoError::Service(DeleteAuthorizerError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DeleteAuthorizerError::InvalidRequest(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(DeleteAuthorizerError::ResourceNotFound(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DeleteAuthorizerError::ServiceUnavailable(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DeleteAuthorizerError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(DeleteAuthorizerError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteAuthorizerError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteAuthorizerError::DeleteConflict(ref cause) => write!(f, "{}", cause),
            DeleteAuthorizerError::InternalFailure(ref cause) => write!(f, "{}", cause),
            DeleteAuthorizerError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DeleteAuthorizerError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            DeleteAuthorizerError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DeleteAuthorizerError::Throttling(ref cause) => write!(f, "{}", cause),
            DeleteAuthorizerError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteAuthorizerError {}
/// Errors returned by DeleteBillingGroup
#[derive(Debug, PartialEq)]
pub enum DeleteBillingGroupError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>An exception thrown when the version of an entity specified with the <code>expectedVersion</code> parameter does not match the latest version in the system.</p>
    VersionConflict(String),
}

impl DeleteBillingGroupError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteBillingGroupError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(DeleteBillingGroupError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DeleteBillingGroupError::InvalidRequest(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DeleteBillingGroupError::Throttling(err.msg))
                }
                "VersionConflictException" => {
                    return RusotoError::Service(DeleteBillingGroupError::VersionConflict(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteBillingGroupError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteBillingGroupError::InternalFailure(ref cause) => write!(f, "{}", cause),
            DeleteBillingGroupError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DeleteBillingGroupError::Throttling(ref cause) => write!(f, "{}", cause),
            DeleteBillingGroupError::VersionConflict(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteBillingGroupError {}
/// Errors returned by DeleteCACertificate
#[derive(Debug, PartialEq)]
pub enum DeleteCACertificateError {
    /// <p>The certificate operation is not allowed.</p>
    CertificateState(String),
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl DeleteCACertificateError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteCACertificateError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "CertificateStateException" => {
                    return RusotoError::Service(DeleteCACertificateError::CertificateState(
                        err.msg,
                    ))
                }
                "InternalFailureException" => {
                    return RusotoError::Service(DeleteCACertificateError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DeleteCACertificateError::InvalidRequest(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(DeleteCACertificateError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DeleteCACertificateError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DeleteCACertificateError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(DeleteCACertificateError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteCACertificateError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteCACertificateError::CertificateState(ref cause) => write!(f, "{}", cause),
            DeleteCACertificateError::InternalFailure(ref cause) => write!(f, "{}", cause),
            DeleteCACertificateError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DeleteCACertificateError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            DeleteCACertificateError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DeleteCACertificateError::Throttling(ref cause) => write!(f, "{}", cause),
            DeleteCACertificateError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteCACertificateError {}
/// Errors returned by DeleteCertificate
#[derive(Debug, PartialEq)]
pub enum DeleteCertificateError {
    /// <p>The certificate operation is not allowed.</p>
    CertificateState(String),
    /// <p>You can't delete the resource because it is attached to one or more resources.</p>
    DeleteConflict(String),
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl DeleteCertificateError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteCertificateError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "CertificateStateException" => {
                    return RusotoError::Service(DeleteCertificateError::CertificateState(err.msg))
                }
                "DeleteConflictException" => {
                    return RusotoError::Service(DeleteCertificateError::DeleteConflict(err.msg))
                }
                "InternalFailureException" => {
                    return RusotoError::Service(DeleteCertificateError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DeleteCertificateError::InvalidRequest(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(DeleteCertificateError::ResourceNotFound(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DeleteCertificateError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DeleteCertificateError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(DeleteCertificateError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteCertificateError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteCertificateError::CertificateState(ref cause) => write!(f, "{}", cause),
            DeleteCertificateError::DeleteConflict(ref cause) => write!(f, "{}", cause),
            DeleteCertificateError::InternalFailure(ref cause) => write!(f, "{}", cause),
            DeleteCertificateError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DeleteCertificateError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            DeleteCertificateError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DeleteCertificateError::Throttling(ref cause) => write!(f, "{}", cause),
            DeleteCertificateError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteCertificateError {}
/// Errors returned by DeleteCustomMetric
#[derive(Debug, PartialEq)]
pub enum DeleteCustomMetricError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl DeleteCustomMetricError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteCustomMetricError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(DeleteCustomMetricError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DeleteCustomMetricError::InvalidRequest(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DeleteCustomMetricError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteCustomMetricError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteCustomMetricError::InternalFailure(ref cause) => write!(f, "{}", cause),
            DeleteCustomMetricError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DeleteCustomMetricError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteCustomMetricError {}
/// Errors returned by DeleteDimension
#[derive(Debug, PartialEq)]
pub enum DeleteDimensionError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl DeleteDimensionError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteDimensionError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(DeleteDimensionError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DeleteDimensionError::InvalidRequest(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DeleteDimensionError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteDimensionError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteDimensionError::InternalFailure(ref cause) => write!(f, "{}", cause),
            DeleteDimensionError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DeleteDimensionError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteDimensionError {}
/// Errors returned by DeleteDomainConfiguration
#[derive(Debug, PartialEq)]
pub enum DeleteDomainConfigurationError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl DeleteDomainConfigurationError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteDomainConfigurationError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(DeleteDomainConfigurationError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DeleteDomainConfigurationError::InvalidRequest(
                        err.msg,
                    ))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(DeleteDomainConfigurationError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        DeleteDomainConfigurationError::ServiceUnavailable(err.msg),
                    )
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DeleteDomainConfigurationError::Throttling(
                        err.msg,
                    ))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(DeleteDomainConfigurationError::Unauthorized(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteDomainConfigurationError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteDomainConfigurationError::InternalFailure(ref cause) => write!(f, "{}", cause),
            DeleteDomainConfigurationError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DeleteDomainConfigurationError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            DeleteDomainConfigurationError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DeleteDomainConfigurationError::Throttling(ref cause) => write!(f, "{}", cause),
            DeleteDomainConfigurationError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteDomainConfigurationError {}
/// Errors returned by DeleteDynamicThingGroup
#[derive(Debug, PartialEq)]
pub enum DeleteDynamicThingGroupError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>An exception thrown when the version of an entity specified with the <code>expectedVersion</code> parameter does not match the latest version in the system.</p>
    VersionConflict(String),
}

impl DeleteDynamicThingGroupError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteDynamicThingGroupError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(DeleteDynamicThingGroupError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DeleteDynamicThingGroupError::InvalidRequest(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DeleteDynamicThingGroupError::Throttling(err.msg))
                }
                "VersionConflictException" => {
                    return RusotoError::Service(DeleteDynamicThingGroupError::VersionConflict(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteDynamicThingGroupError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteDynamicThingGroupError::InternalFailure(ref cause) => write!(f, "{}", cause),
            DeleteDynamicThingGroupError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DeleteDynamicThingGroupError::Throttling(ref cause) => write!(f, "{}", cause),
            DeleteDynamicThingGroupError::VersionConflict(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteDynamicThingGroupError {}
/// Errors returned by DeleteJob
#[derive(Debug, PartialEq)]
pub enum DeleteJobError {
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>An attempt was made to change to an invalid state, for example by deleting a job or a job execution which is "IN_PROGRESS" without setting the <code>force</code> parameter.</p>
    InvalidStateTransition(String),
    /// <p>A limit has been exceeded.</p>
    LimitExceeded(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl DeleteJobError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteJobError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InvalidRequestException" => {
                    return RusotoError::Service(DeleteJobError::InvalidRequest(err.msg))
                }
                "InvalidStateTransitionException" => {
                    return RusotoError::Service(DeleteJobError::InvalidStateTransition(err.msg))
                }
                "LimitExceededException" => {
                    return RusotoError::Service(DeleteJobError::LimitExceeded(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(DeleteJobError::ResourceNotFound(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DeleteJobError::ServiceUnavailable(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DeleteJobError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteJobError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteJobError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DeleteJobError::InvalidStateTransition(ref cause) => write!(f, "{}", cause),
            DeleteJobError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            DeleteJobError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            DeleteJobError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DeleteJobError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteJobError {}
/// Errors returned by DeleteJobExecution
#[derive(Debug, PartialEq)]
pub enum DeleteJobExecutionError {
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>An attempt was made to change to an invalid state, for example by deleting a job or a job execution which is "IN_PROGRESS" without setting the <code>force</code> parameter.</p>
    InvalidStateTransition(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl DeleteJobExecutionError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteJobExecutionError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InvalidRequestException" => {
                    return RusotoError::Service(DeleteJobExecutionError::InvalidRequest(err.msg))
                }
                "InvalidStateTransitionException" => {
                    return RusotoError::Service(DeleteJobExecutionError::InvalidStateTransition(
                        err.msg,
                    ))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(DeleteJobExecutionError::ResourceNotFound(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DeleteJobExecutionError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DeleteJobExecutionError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteJobExecutionError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteJobExecutionError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DeleteJobExecutionError::InvalidStateTransition(ref cause) => write!(f, "{}", cause),
            DeleteJobExecutionError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            DeleteJobExecutionError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DeleteJobExecutionError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteJobExecutionError {}
/// Errors returned by DeleteJobTemplate
#[derive(Debug, PartialEq)]
pub enum DeleteJobTemplateError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl DeleteJobTemplateError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteJobTemplateError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(DeleteJobTemplateError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DeleteJobTemplateError::InvalidRequest(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(DeleteJobTemplateError::ResourceNotFound(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DeleteJobTemplateError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteJobTemplateError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteJobTemplateError::InternalFailure(ref cause) => write!(f, "{}", cause),
            DeleteJobTemplateError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DeleteJobTemplateError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            DeleteJobTemplateError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteJobTemplateError {}
/// Errors returned by DeleteMitigationAction
#[derive(Debug, PartialEq)]
pub enum DeleteMitigationActionError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl DeleteMitigationActionError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteMitigationActionError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(DeleteMitigationActionError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DeleteMitigationActionError::InvalidRequest(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DeleteMitigationActionError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteMitigationActionError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteMitigationActionError::InternalFailure(ref cause) => write!(f, "{}", cause),
            DeleteMitigationActionError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DeleteMitigationActionError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteMitigationActionError {}
/// Errors returned by DeleteOTAUpdate
#[derive(Debug, PartialEq)]
pub enum DeleteOTAUpdateError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
    /// <p>An exception thrown when the version of an entity specified with the <code>expectedVersion</code> parameter does not match the latest version in the system.</p>
    VersionConflict(String),
}

impl DeleteOTAUpdateError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteOTAUpdateError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(DeleteOTAUpdateError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DeleteOTAUpdateError::InvalidRequest(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(DeleteOTAUpdateError::ResourceNotFound(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DeleteOTAUpdateError::ServiceUnavailable(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DeleteOTAUpdateError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(DeleteOTAUpdateError::Unauthorized(err.msg))
                }
                "VersionConflictException" => {
                    return RusotoError::Service(DeleteOTAUpdateError::VersionConflict(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteOTAUpdateError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteOTAUpdateError::InternalFailure(ref cause) => write!(f, "{}", cause),
            DeleteOTAUpdateError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DeleteOTAUpdateError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            DeleteOTAUpdateError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DeleteOTAUpdateError::Throttling(ref cause) => write!(f, "{}", cause),
            DeleteOTAUpdateError::Unauthorized(ref cause) => write!(f, "{}", cause),
            DeleteOTAUpdateError::VersionConflict(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteOTAUpdateError {}
/// Errors returned by DeletePolicy
#[derive(Debug, PartialEq)]
pub enum DeletePolicyError {
    /// <p>You can't delete the resource because it is attached to one or more resources.</p>
    DeleteConflict(String),
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl DeletePolicyError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeletePolicyError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "DeleteConflictException" => {
                    return RusotoError::Service(DeletePolicyError::DeleteConflict(err.msg))
                }
                "InternalFailureException" => {
                    return RusotoError::Service(DeletePolicyError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DeletePolicyError::InvalidRequest(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(DeletePolicyError::ResourceNotFound(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DeletePolicyError::ServiceUnavailable(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DeletePolicyError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(DeletePolicyError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeletePolicyError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeletePolicyError::DeleteConflict(ref cause) => write!(f, "{}", cause),
            DeletePolicyError::InternalFailure(ref cause) => write!(f, "{}", cause),
            DeletePolicyError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DeletePolicyError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            DeletePolicyError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DeletePolicyError::Throttling(ref cause) => write!(f, "{}", cause),
            DeletePolicyError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeletePolicyError {}
/// Errors returned by DeletePolicyVersion
#[derive(Debug, PartialEq)]
pub enum DeletePolicyVersionError {
    /// <p>You can't delete the resource because it is attached to one or more resources.</p>
    DeleteConflict(String),
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl DeletePolicyVersionError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeletePolicyVersionError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "DeleteConflictException" => {
                    return RusotoError::Service(DeletePolicyVersionError::DeleteConflict(err.msg))
                }
                "InternalFailureException" => {
                    return RusotoError::Service(DeletePolicyVersionError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DeletePolicyVersionError::InvalidRequest(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(DeletePolicyVersionError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DeletePolicyVersionError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DeletePolicyVersionError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(DeletePolicyVersionError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeletePolicyVersionError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeletePolicyVersionError::DeleteConflict(ref cause) => write!(f, "{}", cause),
            DeletePolicyVersionError::InternalFailure(ref cause) => write!(f, "{}", cause),
            DeletePolicyVersionError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DeletePolicyVersionError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            DeletePolicyVersionError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DeletePolicyVersionError::Throttling(ref cause) => write!(f, "{}", cause),
            DeletePolicyVersionError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeletePolicyVersionError {}
/// Errors returned by DeleteProvisioningTemplate
#[derive(Debug, PartialEq)]
pub enum DeleteProvisioningTemplateError {
    /// <p>A conflicting resource update exception. This exception is thrown when two pending updates cause a conflict.</p>
    ConflictingResourceUpdate(String),
    /// <p>You can't delete the resource because it is attached to one or more resources.</p>
    DeleteConflict(String),
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl DeleteProvisioningTemplateError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<DeleteProvisioningTemplateError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "ConflictingResourceUpdateException" => {
                    return RusotoError::Service(
                        DeleteProvisioningTemplateError::ConflictingResourceUpdate(err.msg),
                    )
                }
                "DeleteConflictException" => {
                    return RusotoError::Service(DeleteProvisioningTemplateError::DeleteConflict(
                        err.msg,
                    ))
                }
                "InternalFailureException" => {
                    return RusotoError::Service(DeleteProvisioningTemplateError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DeleteProvisioningTemplateError::InvalidRequest(
                        err.msg,
                    ))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(DeleteProvisioningTemplateError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DeleteProvisioningTemplateError::Throttling(
                        err.msg,
                    ))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(DeleteProvisioningTemplateError::Unauthorized(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteProvisioningTemplateError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteProvisioningTemplateError::ConflictingResourceUpdate(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteProvisioningTemplateError::DeleteConflict(ref cause) => write!(f, "{}", cause),
            DeleteProvisioningTemplateError::InternalFailure(ref cause) => write!(f, "{}", cause),
            DeleteProvisioningTemplateError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DeleteProvisioningTemplateError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            DeleteProvisioningTemplateError::Throttling(ref cause) => write!(f, "{}", cause),
            DeleteProvisioningTemplateError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteProvisioningTemplateError {}
/// Errors returned by DeleteProvisioningTemplateVersion
#[derive(Debug, PartialEq)]
pub enum DeleteProvisioningTemplateVersionError {
    /// <p>A conflicting resource update exception. This exception is thrown when two pending updates cause a conflict.</p>
    ConflictingResourceUpdate(String),
    /// <p>You can't delete the resource because it is attached to one or more resources.</p>
    DeleteConflict(String),
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl DeleteProvisioningTemplateVersionError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<DeleteProvisioningTemplateVersionError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "ConflictingResourceUpdateException" => {
                    return RusotoError::Service(
                        DeleteProvisioningTemplateVersionError::ConflictingResourceUpdate(err.msg),
                    )
                }
                "DeleteConflictException" => {
                    return RusotoError::Service(
                        DeleteProvisioningTemplateVersionError::DeleteConflict(err.msg),
                    )
                }
                "InternalFailureException" => {
                    return RusotoError::Service(
                        DeleteProvisioningTemplateVersionError::InternalFailure(err.msg),
                    )
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(
                        DeleteProvisioningTemplateVersionError::InvalidRequest(err.msg),
                    )
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(
                        DeleteProvisioningTemplateVersionError::ResourceNotFound(err.msg),
                    )
                }
                "ThrottlingException" => {
                    return RusotoError::Service(
                        DeleteProvisioningTemplateVersionError::Throttling(err.msg),
                    )
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(
                        DeleteProvisioningTemplateVersionError::Unauthorized(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteProvisioningTemplateVersionError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteProvisioningTemplateVersionError::ConflictingResourceUpdate(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteProvisioningTemplateVersionError::DeleteConflict(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteProvisioningTemplateVersionError::InternalFailure(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteProvisioningTemplateVersionError::InvalidRequest(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteProvisioningTemplateVersionError::ResourceNotFound(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteProvisioningTemplateVersionError::Throttling(ref cause) => write!(f, "{}", cause),
            DeleteProvisioningTemplateVersionError::Unauthorized(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for DeleteProvisioningTemplateVersionError {}
/// Errors returned by DeleteRegistrationCode
#[derive(Debug, PartialEq)]
pub enum DeleteRegistrationCodeError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl DeleteRegistrationCodeError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteRegistrationCodeError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(DeleteRegistrationCodeError::InternalFailure(
                        err.msg,
                    ))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(DeleteRegistrationCodeError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DeleteRegistrationCodeError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DeleteRegistrationCodeError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(DeleteRegistrationCodeError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteRegistrationCodeError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteRegistrationCodeError::InternalFailure(ref cause) => write!(f, "{}", cause),
            DeleteRegistrationCodeError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            DeleteRegistrationCodeError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DeleteRegistrationCodeError::Throttling(ref cause) => write!(f, "{}", cause),
            DeleteRegistrationCodeError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteRegistrationCodeError {}
/// Errors returned by DeleteRoleAlias
#[derive(Debug, PartialEq)]
pub enum DeleteRoleAliasError {
    /// <p>You can't delete the resource because it is attached to one or more resources.</p>
    DeleteConflict(String),
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl DeleteRoleAliasError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteRoleAliasError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "DeleteConflictException" => {
                    return RusotoError::Service(DeleteRoleAliasError::DeleteConflict(err.msg))
                }
                "InternalFailureException" => {
                    return RusotoError::Service(DeleteRoleAliasError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DeleteRoleAliasError::InvalidRequest(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(DeleteRoleAliasError::ResourceNotFound(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DeleteRoleAliasError::ServiceUnavailable(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DeleteRoleAliasError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(DeleteRoleAliasError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteRoleAliasError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteRoleAliasError::DeleteConflict(ref cause) => write!(f, "{}", cause),
            DeleteRoleAliasError::InternalFailure(ref cause) => write!(f, "{}", cause),
            DeleteRoleAliasError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DeleteRoleAliasError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            DeleteRoleAliasError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DeleteRoleAliasError::Throttling(ref cause) => write!(f, "{}", cause),
            DeleteRoleAliasError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteRoleAliasError {}
/// Errors returned by DeleteScheduledAudit
#[derive(Debug, PartialEq)]
pub enum DeleteScheduledAuditError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl DeleteScheduledAuditError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteScheduledAuditError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(DeleteScheduledAuditError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DeleteScheduledAuditError::InvalidRequest(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(DeleteScheduledAuditError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DeleteScheduledAuditError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteScheduledAuditError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteScheduledAuditError::InternalFailure(ref cause) => write!(f, "{}", cause),
            DeleteScheduledAuditError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DeleteScheduledAuditError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            DeleteScheduledAuditError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteScheduledAuditError {}
/// Errors returned by DeleteSecurityProfile
#[derive(Debug, PartialEq)]
pub enum DeleteSecurityProfileError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>An exception thrown when the version of an entity specified with the <code>expectedVersion</code> parameter does not match the latest version in the system.</p>
    VersionConflict(String),
}

impl DeleteSecurityProfileError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteSecurityProfileError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(DeleteSecurityProfileError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DeleteSecurityProfileError::InvalidRequest(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DeleteSecurityProfileError::Throttling(err.msg))
                }
                "VersionConflictException" => {
                    return RusotoError::Service(DeleteSecurityProfileError::VersionConflict(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteSecurityProfileError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteSecurityProfileError::InternalFailure(ref cause) => write!(f, "{}", cause),
            DeleteSecurityProfileError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DeleteSecurityProfileError::Throttling(ref cause) => write!(f, "{}", cause),
            DeleteSecurityProfileError::VersionConflict(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteSecurityProfileError {}
/// Errors returned by DeleteStream
#[derive(Debug, PartialEq)]
pub enum DeleteStreamError {
    /// <p>You can't delete the resource because it is attached to one or more resources.</p>
    DeleteConflict(String),
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl DeleteStreamError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteStreamError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "DeleteConflictException" => {
                    return RusotoError::Service(DeleteStreamError::DeleteConflict(err.msg))
                }
                "InternalFailureException" => {
                    return RusotoError::Service(DeleteStreamError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DeleteStreamError::InvalidRequest(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(DeleteStreamError::ResourceNotFound(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DeleteStreamError::ServiceUnavailable(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DeleteStreamError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(DeleteStreamError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteStreamError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteStreamError::DeleteConflict(ref cause) => write!(f, "{}", cause),
            DeleteStreamError::InternalFailure(ref cause) => write!(f, "{}", cause),
            DeleteStreamError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DeleteStreamError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            DeleteStreamError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DeleteStreamError::Throttling(ref cause) => write!(f, "{}", cause),
            DeleteStreamError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteStreamError {}
/// Errors returned by DeleteThing
#[derive(Debug, PartialEq)]
pub enum DeleteThingError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
    /// <p>An exception thrown when the version of an entity specified with the <code>expectedVersion</code> parameter does not match the latest version in the system.</p>
    VersionConflict(String),
}

impl DeleteThingError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteThingError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(DeleteThingError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DeleteThingError::InvalidRequest(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(DeleteThingError::ResourceNotFound(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DeleteThingError::ServiceUnavailable(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DeleteThingError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(DeleteThingError::Unauthorized(err.msg))
                }
                "VersionConflictException" => {
                    return RusotoError::Service(DeleteThingError::VersionConflict(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteThingError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteThingError::InternalFailure(ref cause) => write!(f, "{}", cause),
            DeleteThingError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DeleteThingError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            DeleteThingError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DeleteThingError::Throttling(ref cause) => write!(f, "{}", cause),
            DeleteThingError::Unauthorized(ref cause) => write!(f, "{}", cause),
            DeleteThingError::VersionConflict(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteThingError {}
/// Errors returned by DeleteThingGroup
#[derive(Debug, PartialEq)]
pub enum DeleteThingGroupError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>An exception thrown when the version of an entity specified with the <code>expectedVersion</code> parameter does not match the latest version in the system.</p>
    VersionConflict(String),
}

impl DeleteThingGroupError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteThingGroupError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(DeleteThingGroupError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DeleteThingGroupError::InvalidRequest(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DeleteThingGroupError::Throttling(err.msg))
                }
                "VersionConflictException" => {
                    return RusotoError::Service(DeleteThingGroupError::VersionConflict(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteThingGroupError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteThingGroupError::InternalFailure(ref cause) => write!(f, "{}", cause),
            DeleteThingGroupError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DeleteThingGroupError::Throttling(ref cause) => write!(f, "{}", cause),
            DeleteThingGroupError::VersionConflict(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteThingGroupError {}
/// Errors returned by DeleteThingType
#[derive(Debug, PartialEq)]
pub enum DeleteThingTypeError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl DeleteThingTypeError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteThingTypeError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(DeleteThingTypeError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DeleteThingTypeError::InvalidRequest(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(DeleteThingTypeError::ResourceNotFound(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DeleteThingTypeError::ServiceUnavailable(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DeleteThingTypeError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(DeleteThingTypeError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteThingTypeError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteThingTypeError::InternalFailure(ref cause) => write!(f, "{}", cause),
            DeleteThingTypeError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DeleteThingTypeError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            DeleteThingTypeError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DeleteThingTypeError::Throttling(ref cause) => write!(f, "{}", cause),
            DeleteThingTypeError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteThingTypeError {}
/// Errors returned by DeleteTopicRule
#[derive(Debug, PartialEq)]
pub enum DeleteTopicRuleError {
    /// <p>A conflicting resource update exception. This exception is thrown when two pending updates cause a conflict.</p>
    ConflictingResourceUpdate(String),
    /// <p>An unexpected error has occurred.</p>
    Internal(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl DeleteTopicRuleError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteTopicRuleError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "ConflictingResourceUpdateException" => {
                    return RusotoError::Service(DeleteTopicRuleError::ConflictingResourceUpdate(
                        err.msg,
                    ))
                }
                "InternalException" => {
                    return RusotoError::Service(DeleteTopicRuleError::Internal(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DeleteTopicRuleError::InvalidRequest(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DeleteTopicRuleError::ServiceUnavailable(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(DeleteTopicRuleError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteTopicRuleError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteTopicRuleError::ConflictingResourceUpdate(ref cause) => write!(f, "{}", cause),
            DeleteTopicRuleError::Internal(ref cause) => write!(f, "{}", cause),
            DeleteTopicRuleError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DeleteTopicRuleError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DeleteTopicRuleError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteTopicRuleError {}
/// Errors returned by DeleteTopicRuleDestination
#[derive(Debug, PartialEq)]
pub enum DeleteTopicRuleDestinationError {
    /// <p>A conflicting resource update exception. This exception is thrown when two pending updates cause a conflict.</p>
    ConflictingResourceUpdate(String),
    /// <p>An unexpected error has occurred.</p>
    Internal(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl DeleteTopicRuleDestinationError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<DeleteTopicRuleDestinationError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "ConflictingResourceUpdateException" => {
                    return RusotoError::Service(
                        DeleteTopicRuleDestinationError::ConflictingResourceUpdate(err.msg),
                    )
                }
                "InternalException" => {
                    return RusotoError::Service(DeleteTopicRuleDestinationError::Internal(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DeleteTopicRuleDestinationError::InvalidRequest(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        DeleteTopicRuleDestinationError::ServiceUnavailable(err.msg),
                    )
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(DeleteTopicRuleDestinationError::Unauthorized(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteTopicRuleDestinationError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteTopicRuleDestinationError::ConflictingResourceUpdate(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteTopicRuleDestinationError::Internal(ref cause) => write!(f, "{}", cause),
            DeleteTopicRuleDestinationError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DeleteTopicRuleDestinationError::ServiceUnavailable(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteTopicRuleDestinationError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteTopicRuleDestinationError {}
/// Errors returned by DeleteV2LoggingLevel
#[derive(Debug, PartialEq)]
pub enum DeleteV2LoggingLevelError {
    /// <p>An unexpected error has occurred.</p>
    Internal(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
}

impl DeleteV2LoggingLevelError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteV2LoggingLevelError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalException" => {
                    return RusotoError::Service(DeleteV2LoggingLevelError::Internal(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DeleteV2LoggingLevelError::InvalidRequest(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DeleteV2LoggingLevelError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteV2LoggingLevelError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteV2LoggingLevelError::Internal(ref cause) => write!(f, "{}", cause),
            DeleteV2LoggingLevelError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DeleteV2LoggingLevelError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteV2LoggingLevelError {}
/// Errors returned by DeprecateThingType
#[derive(Debug, PartialEq)]
pub enum DeprecateThingTypeError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl DeprecateThingTypeError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeprecateThingTypeError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(DeprecateThingTypeError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DeprecateThingTypeError::InvalidRequest(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(DeprecateThingTypeError::ResourceNotFound(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DeprecateThingTypeError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DeprecateThingTypeError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(DeprecateThingTypeError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeprecateThingTypeError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeprecateThingTypeError::InternalFailure(ref cause) => write!(f, "{}", cause),
            DeprecateThingTypeError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DeprecateThingTypeError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            DeprecateThingTypeError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DeprecateThingTypeError::Throttling(ref cause) => write!(f, "{}", cause),
            DeprecateThingTypeError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeprecateThingTypeError {}
/// Errors returned by DescribeAccountAuditConfiguration
#[derive(Debug, PartialEq)]
pub enum DescribeAccountAuditConfigurationError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl DescribeAccountAuditConfigurationError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<DescribeAccountAuditConfigurationError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(
                        DescribeAccountAuditConfigurationError::InternalFailure(err.msg),
                    )
                }
                "ThrottlingException" => {
                    return RusotoError::Service(
                        DescribeAccountAuditConfigurationError::Throttling(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DescribeAccountAuditConfigurationError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeAccountAuditConfigurationError::InternalFailure(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeAccountAuditConfigurationError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DescribeAccountAuditConfigurationError {}
/// Errors returned by DescribeAuditFinding
#[derive(Debug, PartialEq)]
pub enum DescribeAuditFindingError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl DescribeAuditFindingError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DescribeAuditFindingError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(DescribeAuditFindingError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DescribeAuditFindingError::InvalidRequest(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(DescribeAuditFindingError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DescribeAuditFindingError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DescribeAuditFindingError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeAuditFindingError::InternalFailure(ref cause) => write!(f, "{}", cause),
            DescribeAuditFindingError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DescribeAuditFindingError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            DescribeAuditFindingError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DescribeAuditFindingError {}
/// Errors returned by DescribeAuditMitigationActionsTask
#[derive(Debug, PartialEq)]
pub enum DescribeAuditMitigationActionsTaskError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl DescribeAuditMitigationActionsTaskError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<DescribeAuditMitigationActionsTaskError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(
                        DescribeAuditMitigationActionsTaskError::InternalFailure(err.msg),
                    )
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(
                        DescribeAuditMitigationActionsTaskError::InvalidRequest(err.msg),
                    )
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(
                        DescribeAuditMitigationActionsTaskError::ResourceNotFound(err.msg),
                    )
                }
                "ThrottlingException" => {
                    return RusotoError::Service(
                        DescribeAuditMitigationActionsTaskError::Throttling(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DescribeAuditMitigationActionsTaskError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeAuditMitigationActionsTaskError::InternalFailure(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeAuditMitigationActionsTaskError::InvalidRequest(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeAuditMitigationActionsTaskError::ResourceNotFound(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeAuditMitigationActionsTaskError::Throttling(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for DescribeAuditMitigationActionsTaskError {}
/// Errors returned by DescribeAuditSuppression
#[derive(Debug, PartialEq)]
pub enum DescribeAuditSuppressionError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl DescribeAuditSuppressionError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DescribeAuditSuppressionError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(DescribeAuditSuppressionError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DescribeAuditSuppressionError::InvalidRequest(
                        err.msg,
                    ))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(DescribeAuditSuppressionError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DescribeAuditSuppressionError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DescribeAuditSuppressionError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeAuditSuppressionError::InternalFailure(ref cause) => write!(f, "{}", cause),
            DescribeAuditSuppressionError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DescribeAuditSuppressionError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            DescribeAuditSuppressionError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DescribeAuditSuppressionError {}
/// Errors returned by DescribeAuditTask
#[derive(Debug, PartialEq)]
pub enum DescribeAuditTaskError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl DescribeAuditTaskError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DescribeAuditTaskError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(DescribeAuditTaskError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DescribeAuditTaskError::InvalidRequest(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(DescribeAuditTaskError::ResourceNotFound(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DescribeAuditTaskError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DescribeAuditTaskError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeAuditTaskError::InternalFailure(ref cause) => write!(f, "{}", cause),
            DescribeAuditTaskError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DescribeAuditTaskError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            DescribeAuditTaskError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DescribeAuditTaskError {}
/// Errors returned by DescribeAuthorizer
#[derive(Debug, PartialEq)]
pub enum DescribeAuthorizerError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl DescribeAuthorizerError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DescribeAuthorizerError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(DescribeAuthorizerError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DescribeAuthorizerError::InvalidRequest(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(DescribeAuthorizerError::ResourceNotFound(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DescribeAuthorizerError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DescribeAuthorizerError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(DescribeAuthorizerError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DescribeAuthorizerError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeAuthorizerError::InternalFailure(ref cause) => write!(f, "{}", cause),
            DescribeAuthorizerError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DescribeAuthorizerError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            DescribeAuthorizerError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DescribeAuthorizerError::Throttling(ref cause) => write!(f, "{}", cause),
            DescribeAuthorizerError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DescribeAuthorizerError {}
/// Errors returned by DescribeBillingGroup
#[derive(Debug, PartialEq)]
pub enum DescribeBillingGroupError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl DescribeBillingGroupError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DescribeBillingGroupError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(DescribeBillingGroupError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DescribeBillingGroupError::InvalidRequest(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(DescribeBillingGroupError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DescribeBillingGroupError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DescribeBillingGroupError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeBillingGroupError::InternalFailure(ref cause) => write!(f, "{}", cause),
            DescribeBillingGroupError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DescribeBillingGroupError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            DescribeBillingGroupError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DescribeBillingGroupError {}
/// Errors returned by DescribeCACertificate
#[derive(Debug, PartialEq)]
pub enum DescribeCACertificateError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl DescribeCACertificateError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DescribeCACertificateError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(DescribeCACertificateError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DescribeCACertificateError::InvalidRequest(
                        err.msg,
                    ))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(DescribeCACertificateError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DescribeCACertificateError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DescribeCACertificateError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(DescribeCACertificateError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DescribeCACertificateError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeCACertificateError::InternalFailure(ref cause) => write!(f, "{}", cause),
            DescribeCACertificateError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DescribeCACertificateError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            DescribeCACertificateError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DescribeCACertificateError::Throttling(ref cause) => write!(f, "{}", cause),
            DescribeCACertificateError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DescribeCACertificateError {}
/// Errors returned by DescribeCertificate
#[derive(Debug, PartialEq)]
pub enum DescribeCertificateError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl DescribeCertificateError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DescribeCertificateError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(DescribeCertificateError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DescribeCertificateError::InvalidRequest(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(DescribeCertificateError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DescribeCertificateError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DescribeCertificateError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(DescribeCertificateError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DescribeCertificateError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeCertificateError::InternalFailure(ref cause) => write!(f, "{}", cause),
            DescribeCertificateError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DescribeCertificateError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            DescribeCertificateError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DescribeCertificateError::Throttling(ref cause) => write!(f, "{}", cause),
            DescribeCertificateError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DescribeCertificateError {}
/// Errors returned by DescribeCustomMetric
#[derive(Debug, PartialEq)]
pub enum DescribeCustomMetricError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl DescribeCustomMetricError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DescribeCustomMetricError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(DescribeCustomMetricError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DescribeCustomMetricError::InvalidRequest(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(DescribeCustomMetricError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DescribeCustomMetricError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DescribeCustomMetricError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeCustomMetricError::InternalFailure(ref cause) => write!(f, "{}", cause),
            DescribeCustomMetricError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DescribeCustomMetricError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            DescribeCustomMetricError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DescribeCustomMetricError {}
/// Errors returned by DescribeDefaultAuthorizer
#[derive(Debug, PartialEq)]
pub enum DescribeDefaultAuthorizerError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl DescribeDefaultAuthorizerError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DescribeDefaultAuthorizerError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(DescribeDefaultAuthorizerError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DescribeDefaultAuthorizerError::InvalidRequest(
                        err.msg,
                    ))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(DescribeDefaultAuthorizerError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        DescribeDefaultAuthorizerError::ServiceUnavailable(err.msg),
                    )
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DescribeDefaultAuthorizerError::Throttling(
                        err.msg,
                    ))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(DescribeDefaultAuthorizerError::Unauthorized(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DescribeDefaultAuthorizerError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeDefaultAuthorizerError::InternalFailure(ref cause) => write!(f, "{}", cause),
            DescribeDefaultAuthorizerError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DescribeDefaultAuthorizerError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            DescribeDefaultAuthorizerError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DescribeDefaultAuthorizerError::Throttling(ref cause) => write!(f, "{}", cause),
            DescribeDefaultAuthorizerError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DescribeDefaultAuthorizerError {}
/// Errors returned by DescribeDetectMitigationActionsTask
#[derive(Debug, PartialEq)]
pub enum DescribeDetectMitigationActionsTaskError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl DescribeDetectMitigationActionsTaskError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<DescribeDetectMitigationActionsTaskError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(
                        DescribeDetectMitigationActionsTaskError::InternalFailure(err.msg),
                    )
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(
                        DescribeDetectMitigationActionsTaskError::InvalidRequest(err.msg),
                    )
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(
                        DescribeDetectMitigationActionsTaskError::ResourceNotFound(err.msg),
                    )
                }
                "ThrottlingException" => {
                    return RusotoError::Service(
                        DescribeDetectMitigationActionsTaskError::Throttling(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DescribeDetectMitigationActionsTaskError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeDetectMitigationActionsTaskError::InternalFailure(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeDetectMitigationActionsTaskError::InvalidRequest(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeDetectMitigationActionsTaskError::ResourceNotFound(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeDetectMitigationActionsTaskError::Throttling(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for DescribeDetectMitigationActionsTaskError {}
/// Errors returned by DescribeDimension
#[derive(Debug, PartialEq)]
pub enum DescribeDimensionError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl DescribeDimensionError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DescribeDimensionError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(DescribeDimensionError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DescribeDimensionError::InvalidRequest(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(DescribeDimensionError::ResourceNotFound(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DescribeDimensionError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DescribeDimensionError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeDimensionError::InternalFailure(ref cause) => write!(f, "{}", cause),
            DescribeDimensionError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DescribeDimensionError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            DescribeDimensionError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DescribeDimensionError {}
/// Errors returned by DescribeDomainConfiguration
#[derive(Debug, PartialEq)]
pub enum DescribeDomainConfigurationError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl DescribeDomainConfigurationError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<DescribeDomainConfigurationError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(DescribeDomainConfigurationError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DescribeDomainConfigurationError::InvalidRequest(
                        err.msg,
                    ))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(
                        DescribeDomainConfigurationError::ResourceNotFound(err.msg),
                    )
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        DescribeDomainConfigurationError::ServiceUnavailable(err.msg),
                    )
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DescribeDomainConfigurationError::Throttling(
                        err.msg,
                    ))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(DescribeDomainConfigurationError::Unauthorized(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DescribeDomainConfigurationError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeDomainConfigurationError::InternalFailure(ref cause) => write!(f, "{}", cause),
            DescribeDomainConfigurationError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DescribeDomainConfigurationError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            DescribeDomainConfigurationError::ServiceUnavailable(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeDomainConfigurationError::Throttling(ref cause) => write!(f, "{}", cause),
            DescribeDomainConfigurationError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DescribeDomainConfigurationError {}
/// Errors returned by DescribeEndpoint
#[derive(Debug, PartialEq)]
pub enum DescribeEndpointError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl DescribeEndpointError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DescribeEndpointError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(DescribeEndpointError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DescribeEndpointError::InvalidRequest(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DescribeEndpointError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(DescribeEndpointError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DescribeEndpointError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeEndpointError::InternalFailure(ref cause) => write!(f, "{}", cause),
            DescribeEndpointError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DescribeEndpointError::Throttling(ref cause) => write!(f, "{}", cause),
            DescribeEndpointError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DescribeEndpointError {}
/// Errors returned by DescribeEventConfigurations
#[derive(Debug, PartialEq)]
pub enum DescribeEventConfigurationsError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl DescribeEventConfigurationsError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<DescribeEventConfigurationsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(DescribeEventConfigurationsError::InternalFailure(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DescribeEventConfigurationsError::Throttling(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DescribeEventConfigurationsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeEventConfigurationsError::InternalFailure(ref cause) => write!(f, "{}", cause),
            DescribeEventConfigurationsError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DescribeEventConfigurationsError {}
/// Errors returned by DescribeIndex
#[derive(Debug, PartialEq)]
pub enum DescribeIndexError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl DescribeIndexError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DescribeIndexError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(DescribeIndexError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DescribeIndexError::InvalidRequest(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(DescribeIndexError::ResourceNotFound(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DescribeIndexError::ServiceUnavailable(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DescribeIndexError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(DescribeIndexError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DescribeIndexError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeIndexError::InternalFailure(ref cause) => write!(f, "{}", cause),
            DescribeIndexError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DescribeIndexError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            DescribeIndexError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DescribeIndexError::Throttling(ref cause) => write!(f, "{}", cause),
            DescribeIndexError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DescribeIndexError {}
/// Errors returned by DescribeJob
#[derive(Debug, PartialEq)]
pub enum DescribeJobError {
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl DescribeJobError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DescribeJobError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InvalidRequestException" => {
                    return RusotoError::Service(DescribeJobError::InvalidRequest(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(DescribeJobError::ResourceNotFound(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DescribeJobError::ServiceUnavailable(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DescribeJobError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DescribeJobError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeJobError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DescribeJobError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            DescribeJobError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DescribeJobError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DescribeJobError {}
/// Errors returned by DescribeJobExecution
#[derive(Debug, PartialEq)]
pub enum DescribeJobExecutionError {
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl DescribeJobExecutionError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DescribeJobExecutionError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InvalidRequestException" => {
                    return RusotoError::Service(DescribeJobExecutionError::InvalidRequest(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(DescribeJobExecutionError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DescribeJobExecutionError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DescribeJobExecutionError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DescribeJobExecutionError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeJobExecutionError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DescribeJobExecutionError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            DescribeJobExecutionError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DescribeJobExecutionError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DescribeJobExecutionError {}
/// Errors returned by DescribeJobTemplate
#[derive(Debug, PartialEq)]
pub enum DescribeJobTemplateError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl DescribeJobTemplateError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DescribeJobTemplateError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(DescribeJobTemplateError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DescribeJobTemplateError::InvalidRequest(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(DescribeJobTemplateError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DescribeJobTemplateError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DescribeJobTemplateError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeJobTemplateError::InternalFailure(ref cause) => write!(f, "{}", cause),
            DescribeJobTemplateError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DescribeJobTemplateError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            DescribeJobTemplateError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DescribeJobTemplateError {}
/// Errors returned by DescribeMitigationAction
#[derive(Debug, PartialEq)]
pub enum DescribeMitigationActionError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl DescribeMitigationActionError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DescribeMitigationActionError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(DescribeMitigationActionError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DescribeMitigationActionError::InvalidRequest(
                        err.msg,
                    ))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(DescribeMitigationActionError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DescribeMitigationActionError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DescribeMitigationActionError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeMitigationActionError::InternalFailure(ref cause) => write!(f, "{}", cause),
            DescribeMitigationActionError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DescribeMitigationActionError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            DescribeMitigationActionError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DescribeMitigationActionError {}
/// Errors returned by DescribeProvisioningTemplate
#[derive(Debug, PartialEq)]
pub enum DescribeProvisioningTemplateError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl DescribeProvisioningTemplateError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<DescribeProvisioningTemplateError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(
                        DescribeProvisioningTemplateError::InternalFailure(err.msg),
                    )
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DescribeProvisioningTemplateError::InvalidRequest(
                        err.msg,
                    ))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(
                        DescribeProvisioningTemplateError::ResourceNotFound(err.msg),
                    )
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DescribeProvisioningTemplateError::Throttling(
                        err.msg,
                    ))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(DescribeProvisioningTemplateError::Unauthorized(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DescribeProvisioningTemplateError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeProvisioningTemplateError::InternalFailure(ref cause) => write!(f, "{}", cause),
            DescribeProvisioningTemplateError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DescribeProvisioningTemplateError::ResourceNotFound(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeProvisioningTemplateError::Throttling(ref cause) => write!(f, "{}", cause),
            DescribeProvisioningTemplateError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DescribeProvisioningTemplateError {}
/// Errors returned by DescribeProvisioningTemplateVersion
#[derive(Debug, PartialEq)]
pub enum DescribeProvisioningTemplateVersionError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl DescribeProvisioningTemplateVersionError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<DescribeProvisioningTemplateVersionError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(
                        DescribeProvisioningTemplateVersionError::InternalFailure(err.msg),
                    )
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(
                        DescribeProvisioningTemplateVersionError::InvalidRequest(err.msg),
                    )
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(
                        DescribeProvisioningTemplateVersionError::ResourceNotFound(err.msg),
                    )
                }
                "ThrottlingException" => {
                    return RusotoError::Service(
                        DescribeProvisioningTemplateVersionError::Throttling(err.msg),
                    )
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(
                        DescribeProvisioningTemplateVersionError::Unauthorized(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DescribeProvisioningTemplateVersionError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeProvisioningTemplateVersionError::InternalFailure(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeProvisioningTemplateVersionError::InvalidRequest(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeProvisioningTemplateVersionError::ResourceNotFound(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeProvisioningTemplateVersionError::Throttling(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeProvisioningTemplateVersionError::Unauthorized(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for DescribeProvisioningTemplateVersionError {}
/// Errors returned by DescribeRoleAlias
#[derive(Debug, PartialEq)]
pub enum DescribeRoleAliasError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl DescribeRoleAliasError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DescribeRoleAliasError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(DescribeRoleAliasError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DescribeRoleAliasError::InvalidRequest(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(DescribeRoleAliasError::ResourceNotFound(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DescribeRoleAliasError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DescribeRoleAliasError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(DescribeRoleAliasError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DescribeRoleAliasError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeRoleAliasError::InternalFailure(ref cause) => write!(f, "{}", cause),
            DescribeRoleAliasError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DescribeRoleAliasError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            DescribeRoleAliasError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DescribeRoleAliasError::Throttling(ref cause) => write!(f, "{}", cause),
            DescribeRoleAliasError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DescribeRoleAliasError {}
/// Errors returned by DescribeScheduledAudit
#[derive(Debug, PartialEq)]
pub enum DescribeScheduledAuditError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl DescribeScheduledAuditError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DescribeScheduledAuditError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(DescribeScheduledAuditError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DescribeScheduledAuditError::InvalidRequest(
                        err.msg,
                    ))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(DescribeScheduledAuditError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DescribeScheduledAuditError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DescribeScheduledAuditError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeScheduledAuditError::InternalFailure(ref cause) => write!(f, "{}", cause),
            DescribeScheduledAuditError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DescribeScheduledAuditError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            DescribeScheduledAuditError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DescribeScheduledAuditError {}
/// Errors returned by DescribeSecurityProfile
#[derive(Debug, PartialEq)]
pub enum DescribeSecurityProfileError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl DescribeSecurityProfileError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DescribeSecurityProfileError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(DescribeSecurityProfileError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DescribeSecurityProfileError::InvalidRequest(
                        err.msg,
                    ))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(DescribeSecurityProfileError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DescribeSecurityProfileError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DescribeSecurityProfileError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeSecurityProfileError::InternalFailure(ref cause) => write!(f, "{}", cause),
            DescribeSecurityProfileError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DescribeSecurityProfileError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            DescribeSecurityProfileError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DescribeSecurityProfileError {}
/// Errors returned by DescribeStream
#[derive(Debug, PartialEq)]
pub enum DescribeStreamError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl DescribeStreamError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DescribeStreamError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(DescribeStreamError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DescribeStreamError::InvalidRequest(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(DescribeStreamError::ResourceNotFound(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DescribeStreamError::ServiceUnavailable(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DescribeStreamError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(DescribeStreamError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DescribeStreamError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeStreamError::InternalFailure(ref cause) => write!(f, "{}", cause),
            DescribeStreamError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DescribeStreamError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            DescribeStreamError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DescribeStreamError::Throttling(ref cause) => write!(f, "{}", cause),
            DescribeStreamError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DescribeStreamError {}
/// Errors returned by DescribeThing
#[derive(Debug, PartialEq)]
pub enum DescribeThingError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl DescribeThingError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DescribeThingError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(DescribeThingError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DescribeThingError::InvalidRequest(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(DescribeThingError::ResourceNotFound(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DescribeThingError::ServiceUnavailable(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DescribeThingError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(DescribeThingError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DescribeThingError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeThingError::InternalFailure(ref cause) => write!(f, "{}", cause),
            DescribeThingError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DescribeThingError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            DescribeThingError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DescribeThingError::Throttling(ref cause) => write!(f, "{}", cause),
            DescribeThingError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DescribeThingError {}
/// Errors returned by DescribeThingGroup
#[derive(Debug, PartialEq)]
pub enum DescribeThingGroupError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl DescribeThingGroupError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DescribeThingGroupError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(DescribeThingGroupError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DescribeThingGroupError::InvalidRequest(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(DescribeThingGroupError::ResourceNotFound(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DescribeThingGroupError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DescribeThingGroupError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeThingGroupError::InternalFailure(ref cause) => write!(f, "{}", cause),
            DescribeThingGroupError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DescribeThingGroupError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            DescribeThingGroupError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DescribeThingGroupError {}
/// Errors returned by DescribeThingRegistrationTask
#[derive(Debug, PartialEq)]
pub enum DescribeThingRegistrationTaskError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl DescribeThingRegistrationTaskError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<DescribeThingRegistrationTaskError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(
                        DescribeThingRegistrationTaskError::InternalFailure(err.msg),
                    )
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(
                        DescribeThingRegistrationTaskError::InvalidRequest(err.msg),
                    )
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(
                        DescribeThingRegistrationTaskError::ResourceNotFound(err.msg),
                    )
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DescribeThingRegistrationTaskError::Throttling(
                        err.msg,
                    ))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(DescribeThingRegistrationTaskError::Unauthorized(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DescribeThingRegistrationTaskError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeThingRegistrationTaskError::InternalFailure(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeThingRegistrationTaskError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DescribeThingRegistrationTaskError::ResourceNotFound(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeThingRegistrationTaskError::Throttling(ref cause) => write!(f, "{}", cause),
            DescribeThingRegistrationTaskError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DescribeThingRegistrationTaskError {}
/// Errors returned by DescribeThingType
#[derive(Debug, PartialEq)]
pub enum DescribeThingTypeError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl DescribeThingTypeError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DescribeThingTypeError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(DescribeThingTypeError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DescribeThingTypeError::InvalidRequest(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(DescribeThingTypeError::ResourceNotFound(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DescribeThingTypeError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DescribeThingTypeError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(DescribeThingTypeError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DescribeThingTypeError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeThingTypeError::InternalFailure(ref cause) => write!(f, "{}", cause),
            DescribeThingTypeError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DescribeThingTypeError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            DescribeThingTypeError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DescribeThingTypeError::Throttling(ref cause) => write!(f, "{}", cause),
            DescribeThingTypeError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DescribeThingTypeError {}
/// Errors returned by DetachPolicy
#[derive(Debug, PartialEq)]
pub enum DetachPolicyError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>A limit has been exceeded.</p>
    LimitExceeded(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl DetachPolicyError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DetachPolicyError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(DetachPolicyError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DetachPolicyError::InvalidRequest(err.msg))
                }
                "LimitExceededException" => {
                    return RusotoError::Service(DetachPolicyError::LimitExceeded(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DetachPolicyError::ServiceUnavailable(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DetachPolicyError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(DetachPolicyError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DetachPolicyError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DetachPolicyError::InternalFailure(ref cause) => write!(f, "{}", cause),
            DetachPolicyError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DetachPolicyError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            DetachPolicyError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DetachPolicyError::Throttling(ref cause) => write!(f, "{}", cause),
            DetachPolicyError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DetachPolicyError {}
/// Errors returned by DetachPrincipalPolicy
#[derive(Debug, PartialEq)]
pub enum DetachPrincipalPolicyError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl DetachPrincipalPolicyError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DetachPrincipalPolicyError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(DetachPrincipalPolicyError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DetachPrincipalPolicyError::InvalidRequest(
                        err.msg,
                    ))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(DetachPrincipalPolicyError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DetachPrincipalPolicyError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DetachPrincipalPolicyError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(DetachPrincipalPolicyError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DetachPrincipalPolicyError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DetachPrincipalPolicyError::InternalFailure(ref cause) => write!(f, "{}", cause),
            DetachPrincipalPolicyError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DetachPrincipalPolicyError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            DetachPrincipalPolicyError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DetachPrincipalPolicyError::Throttling(ref cause) => write!(f, "{}", cause),
            DetachPrincipalPolicyError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DetachPrincipalPolicyError {}
/// Errors returned by DetachSecurityProfile
#[derive(Debug, PartialEq)]
pub enum DetachSecurityProfileError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl DetachSecurityProfileError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DetachSecurityProfileError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(DetachSecurityProfileError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DetachSecurityProfileError::InvalidRequest(
                        err.msg,
                    ))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(DetachSecurityProfileError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DetachSecurityProfileError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DetachSecurityProfileError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DetachSecurityProfileError::InternalFailure(ref cause) => write!(f, "{}", cause),
            DetachSecurityProfileError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DetachSecurityProfileError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            DetachSecurityProfileError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DetachSecurityProfileError {}
/// Errors returned by DetachThingPrincipal
#[derive(Debug, PartialEq)]
pub enum DetachThingPrincipalError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl DetachThingPrincipalError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DetachThingPrincipalError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(DetachThingPrincipalError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DetachThingPrincipalError::InvalidRequest(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(DetachThingPrincipalError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DetachThingPrincipalError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DetachThingPrincipalError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(DetachThingPrincipalError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DetachThingPrincipalError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DetachThingPrincipalError::InternalFailure(ref cause) => write!(f, "{}", cause),
            DetachThingPrincipalError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DetachThingPrincipalError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            DetachThingPrincipalError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DetachThingPrincipalError::Throttling(ref cause) => write!(f, "{}", cause),
            DetachThingPrincipalError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DetachThingPrincipalError {}
/// Errors returned by DisableTopicRule
#[derive(Debug, PartialEq)]
pub enum DisableTopicRuleError {
    /// <p>A conflicting resource update exception. This exception is thrown when two pending updates cause a conflict.</p>
    ConflictingResourceUpdate(String),
    /// <p>An unexpected error has occurred.</p>
    Internal(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl DisableTopicRuleError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DisableTopicRuleError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "ConflictingResourceUpdateException" => {
                    return RusotoError::Service(DisableTopicRuleError::ConflictingResourceUpdate(
                        err.msg,
                    ))
                }
                "InternalException" => {
                    return RusotoError::Service(DisableTopicRuleError::Internal(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(DisableTopicRuleError::InvalidRequest(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DisableTopicRuleError::ServiceUnavailable(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(DisableTopicRuleError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DisableTopicRuleError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DisableTopicRuleError::ConflictingResourceUpdate(ref cause) => write!(f, "{}", cause),
            DisableTopicRuleError::Internal(ref cause) => write!(f, "{}", cause),
            DisableTopicRuleError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            DisableTopicRuleError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DisableTopicRuleError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DisableTopicRuleError {}
/// Errors returned by EnableTopicRule
#[derive(Debug, PartialEq)]
pub enum EnableTopicRuleError {
    /// <p>A conflicting resource update exception. This exception is thrown when two pending updates cause a conflict.</p>
    ConflictingResourceUpdate(String),
    /// <p>An unexpected error has occurred.</p>
    Internal(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl EnableTopicRuleError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<EnableTopicRuleError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "ConflictingResourceUpdateException" => {
                    return RusotoError::Service(EnableTopicRuleError::ConflictingResourceUpdate(
                        err.msg,
                    ))
                }
                "InternalException" => {
                    return RusotoError::Service(EnableTopicRuleError::Internal(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(EnableTopicRuleError::InvalidRequest(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(EnableTopicRuleError::ServiceUnavailable(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(EnableTopicRuleError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for EnableTopicRuleError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            EnableTopicRuleError::ConflictingResourceUpdate(ref cause) => write!(f, "{}", cause),
            EnableTopicRuleError::Internal(ref cause) => write!(f, "{}", cause),
            EnableTopicRuleError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            EnableTopicRuleError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            EnableTopicRuleError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for EnableTopicRuleError {}
/// Errors returned by GetBehaviorModelTrainingSummaries
#[derive(Debug, PartialEq)]
pub enum GetBehaviorModelTrainingSummariesError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl GetBehaviorModelTrainingSummariesError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<GetBehaviorModelTrainingSummariesError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(
                        GetBehaviorModelTrainingSummariesError::InternalFailure(err.msg),
                    )
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(
                        GetBehaviorModelTrainingSummariesError::InvalidRequest(err.msg),
                    )
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(
                        GetBehaviorModelTrainingSummariesError::ResourceNotFound(err.msg),
                    )
                }
                "ThrottlingException" => {
                    return RusotoError::Service(
                        GetBehaviorModelTrainingSummariesError::Throttling(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for GetBehaviorModelTrainingSummariesError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetBehaviorModelTrainingSummariesError::InternalFailure(ref cause) => {
                write!(f, "{}", cause)
            }
            GetBehaviorModelTrainingSummariesError::InvalidRequest(ref cause) => {
                write!(f, "{}", cause)
            }
            GetBehaviorModelTrainingSummariesError::ResourceNotFound(ref cause) => {
                write!(f, "{}", cause)
            }
            GetBehaviorModelTrainingSummariesError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetBehaviorModelTrainingSummariesError {}
/// Errors returned by GetCardinality
#[derive(Debug, PartialEq)]
pub enum GetCardinalityError {
    /// <p>The index is not ready.</p>
    IndexNotReady(String),
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The aggregation is invalid.</p>
    InvalidAggregation(String),
    /// <p>The query is invalid.</p>
    InvalidQuery(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl GetCardinalityError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetCardinalityError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "IndexNotReadyException" => {
                    return RusotoError::Service(GetCardinalityError::IndexNotReady(err.msg))
                }
                "InternalFailureException" => {
                    return RusotoError::Service(GetCardinalityError::InternalFailure(err.msg))
                }
                "InvalidAggregationException" => {
                    return RusotoError::Service(GetCardinalityError::InvalidAggregation(err.msg))
                }
                "InvalidQueryException" => {
                    return RusotoError::Service(GetCardinalityError::InvalidQuery(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(GetCardinalityError::InvalidRequest(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(GetCardinalityError::ResourceNotFound(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(GetCardinalityError::ServiceUnavailable(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(GetCardinalityError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(GetCardinalityError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for GetCardinalityError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetCardinalityError::IndexNotReady(ref cause) => write!(f, "{}", cause),
            GetCardinalityError::InternalFailure(ref cause) => write!(f, "{}", cause),
            GetCardinalityError::InvalidAggregation(ref cause) => write!(f, "{}", cause),
            GetCardinalityError::InvalidQuery(ref cause) => write!(f, "{}", cause),
            GetCardinalityError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            GetCardinalityError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            GetCardinalityError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            GetCardinalityError::Throttling(ref cause) => write!(f, "{}", cause),
            GetCardinalityError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetCardinalityError {}
/// Errors returned by GetEffectivePolicies
#[derive(Debug, PartialEq)]
pub enum GetEffectivePoliciesError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>A limit has been exceeded.</p>
    LimitExceeded(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl GetEffectivePoliciesError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetEffectivePoliciesError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(GetEffectivePoliciesError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(GetEffectivePoliciesError::InvalidRequest(err.msg))
                }
                "LimitExceededException" => {
                    return RusotoError::Service(GetEffectivePoliciesError::LimitExceeded(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(GetEffectivePoliciesError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(GetEffectivePoliciesError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(GetEffectivePoliciesError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(GetEffectivePoliciesError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for GetEffectivePoliciesError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetEffectivePoliciesError::InternalFailure(ref cause) => write!(f, "{}", cause),
            GetEffectivePoliciesError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            GetEffectivePoliciesError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            GetEffectivePoliciesError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            GetEffectivePoliciesError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            GetEffectivePoliciesError::Throttling(ref cause) => write!(f, "{}", cause),
            GetEffectivePoliciesError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetEffectivePoliciesError {}
/// Errors returned by GetIndexingConfiguration
#[derive(Debug, PartialEq)]
pub enum GetIndexingConfigurationError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl GetIndexingConfigurationError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetIndexingConfigurationError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(GetIndexingConfigurationError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(GetIndexingConfigurationError::InvalidRequest(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(GetIndexingConfigurationError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(GetIndexingConfigurationError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(GetIndexingConfigurationError::Unauthorized(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for GetIndexingConfigurationError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetIndexingConfigurationError::InternalFailure(ref cause) => write!(f, "{}", cause),
            GetIndexingConfigurationError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            GetIndexingConfigurationError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            GetIndexingConfigurationError::Throttling(ref cause) => write!(f, "{}", cause),
            GetIndexingConfigurationError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetIndexingConfigurationError {}
/// Errors returned by GetJobDocument
#[derive(Debug, PartialEq)]
pub enum GetJobDocumentError {
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl GetJobDocumentError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetJobDocumentError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InvalidRequestException" => {
                    return RusotoError::Service(GetJobDocumentError::InvalidRequest(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(GetJobDocumentError::ResourceNotFound(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(GetJobDocumentError::ServiceUnavailable(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(GetJobDocumentError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for GetJobDocumentError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetJobDocumentError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            GetJobDocumentError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            GetJobDocumentError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            GetJobDocumentError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetJobDocumentError {}
/// Errors returned by GetLoggingOptions
#[derive(Debug, PartialEq)]
pub enum GetLoggingOptionsError {
    /// <p>An unexpected error has occurred.</p>
    Internal(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
}

impl GetLoggingOptionsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetLoggingOptionsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalException" => {
                    return RusotoError::Service(GetLoggingOptionsError::Internal(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(GetLoggingOptionsError::InvalidRequest(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(GetLoggingOptionsError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for GetLoggingOptionsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetLoggingOptionsError::Internal(ref cause) => write!(f, "{}", cause),
            GetLoggingOptionsError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            GetLoggingOptionsError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetLoggingOptionsError {}
/// Errors returned by GetOTAUpdate
#[derive(Debug, PartialEq)]
pub enum GetOTAUpdateError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl GetOTAUpdateError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetOTAUpdateError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(GetOTAUpdateError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(GetOTAUpdateError::InvalidRequest(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(GetOTAUpdateError::ResourceNotFound(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(GetOTAUpdateError::ServiceUnavailable(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(GetOTAUpdateError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(GetOTAUpdateError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for GetOTAUpdateError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetOTAUpdateError::InternalFailure(ref cause) => write!(f, "{}", cause),
            GetOTAUpdateError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            GetOTAUpdateError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            GetOTAUpdateError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            GetOTAUpdateError::Throttling(ref cause) => write!(f, "{}", cause),
            GetOTAUpdateError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetOTAUpdateError {}
/// Errors returned by GetPercentiles
#[derive(Debug, PartialEq)]
pub enum GetPercentilesError {
    /// <p>The index is not ready.</p>
    IndexNotReady(String),
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The aggregation is invalid.</p>
    InvalidAggregation(String),
    /// <p>The query is invalid.</p>
    InvalidQuery(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl GetPercentilesError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetPercentilesError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "IndexNotReadyException" => {
                    return RusotoError::Service(GetPercentilesError::IndexNotReady(err.msg))
                }
                "InternalFailureException" => {
                    return RusotoError::Service(GetPercentilesError::InternalFailure(err.msg))
                }
                "InvalidAggregationException" => {
                    return RusotoError::Service(GetPercentilesError::InvalidAggregation(err.msg))
                }
                "InvalidQueryException" => {
                    return RusotoError::Service(GetPercentilesError::InvalidQuery(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(GetPercentilesError::InvalidRequest(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(GetPercentilesError::ResourceNotFound(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(GetPercentilesError::ServiceUnavailable(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(GetPercentilesError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(GetPercentilesError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for GetPercentilesError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetPercentilesError::IndexNotReady(ref cause) => write!(f, "{}", cause),
            GetPercentilesError::InternalFailure(ref cause) => write!(f, "{}", cause),
            GetPercentilesError::InvalidAggregation(ref cause) => write!(f, "{}", cause),
            GetPercentilesError::InvalidQuery(ref cause) => write!(f, "{}", cause),
            GetPercentilesError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            GetPercentilesError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            GetPercentilesError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            GetPercentilesError::Throttling(ref cause) => write!(f, "{}", cause),
            GetPercentilesError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetPercentilesError {}
/// Errors returned by GetPolicy
#[derive(Debug, PartialEq)]
pub enum GetPolicyError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl GetPolicyError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetPolicyError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(GetPolicyError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(GetPolicyError::InvalidRequest(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(GetPolicyError::ResourceNotFound(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(GetPolicyError::ServiceUnavailable(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(GetPolicyError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(GetPolicyError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for GetPolicyError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetPolicyError::InternalFailure(ref cause) => write!(f, "{}", cause),
            GetPolicyError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            GetPolicyError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            GetPolicyError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            GetPolicyError::Throttling(ref cause) => write!(f, "{}", cause),
            GetPolicyError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetPolicyError {}
/// Errors returned by GetPolicyVersion
#[derive(Debug, PartialEq)]
pub enum GetPolicyVersionError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl GetPolicyVersionError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetPolicyVersionError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(GetPolicyVersionError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(GetPolicyVersionError::InvalidRequest(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(GetPolicyVersionError::ResourceNotFound(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(GetPolicyVersionError::ServiceUnavailable(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(GetPolicyVersionError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(GetPolicyVersionError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for GetPolicyVersionError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetPolicyVersionError::InternalFailure(ref cause) => write!(f, "{}", cause),
            GetPolicyVersionError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            GetPolicyVersionError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            GetPolicyVersionError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            GetPolicyVersionError::Throttling(ref cause) => write!(f, "{}", cause),
            GetPolicyVersionError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetPolicyVersionError {}
/// Errors returned by GetRegistrationCode
#[derive(Debug, PartialEq)]
pub enum GetRegistrationCodeError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl GetRegistrationCodeError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetRegistrationCodeError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(GetRegistrationCodeError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(GetRegistrationCodeError::InvalidRequest(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(GetRegistrationCodeError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(GetRegistrationCodeError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(GetRegistrationCodeError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for GetRegistrationCodeError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetRegistrationCodeError::InternalFailure(ref cause) => write!(f, "{}", cause),
            GetRegistrationCodeError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            GetRegistrationCodeError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            GetRegistrationCodeError::Throttling(ref cause) => write!(f, "{}", cause),
            GetRegistrationCodeError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetRegistrationCodeError {}
/// Errors returned by GetStatistics
#[derive(Debug, PartialEq)]
pub enum GetStatisticsError {
    /// <p>The index is not ready.</p>
    IndexNotReady(String),
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The aggregation is invalid.</p>
    InvalidAggregation(String),
    /// <p>The query is invalid.</p>
    InvalidQuery(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl GetStatisticsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetStatisticsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "IndexNotReadyException" => {
                    return RusotoError::Service(GetStatisticsError::IndexNotReady(err.msg))
                }
                "InternalFailureException" => {
                    return RusotoError::Service(GetStatisticsError::InternalFailure(err.msg))
                }
                "InvalidAggregationException" => {
                    return RusotoError::Service(GetStatisticsError::InvalidAggregation(err.msg))
                }
                "InvalidQueryException" => {
                    return RusotoError::Service(GetStatisticsError::InvalidQuery(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(GetStatisticsError::InvalidRequest(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(GetStatisticsError::ResourceNotFound(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(GetStatisticsError::ServiceUnavailable(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(GetStatisticsError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(GetStatisticsError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for GetStatisticsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetStatisticsError::IndexNotReady(ref cause) => write!(f, "{}", cause),
            GetStatisticsError::InternalFailure(ref cause) => write!(f, "{}", cause),
            GetStatisticsError::InvalidAggregation(ref cause) => write!(f, "{}", cause),
            GetStatisticsError::InvalidQuery(ref cause) => write!(f, "{}", cause),
            GetStatisticsError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            GetStatisticsError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            GetStatisticsError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            GetStatisticsError::Throttling(ref cause) => write!(f, "{}", cause),
            GetStatisticsError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetStatisticsError {}
/// Errors returned by GetTopicRule
#[derive(Debug, PartialEq)]
pub enum GetTopicRuleError {
    /// <p>An unexpected error has occurred.</p>
    Internal(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl GetTopicRuleError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetTopicRuleError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalException" => {
                    return RusotoError::Service(GetTopicRuleError::Internal(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(GetTopicRuleError::InvalidRequest(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(GetTopicRuleError::ServiceUnavailable(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(GetTopicRuleError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for GetTopicRuleError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetTopicRuleError::Internal(ref cause) => write!(f, "{}", cause),
            GetTopicRuleError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            GetTopicRuleError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            GetTopicRuleError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetTopicRuleError {}
/// Errors returned by GetTopicRuleDestination
#[derive(Debug, PartialEq)]
pub enum GetTopicRuleDestinationError {
    /// <p>An unexpected error has occurred.</p>
    Internal(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl GetTopicRuleDestinationError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetTopicRuleDestinationError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalException" => {
                    return RusotoError::Service(GetTopicRuleDestinationError::Internal(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(GetTopicRuleDestinationError::InvalidRequest(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(GetTopicRuleDestinationError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(GetTopicRuleDestinationError::Unauthorized(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for GetTopicRuleDestinationError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetTopicRuleDestinationError::Internal(ref cause) => write!(f, "{}", cause),
            GetTopicRuleDestinationError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            GetTopicRuleDestinationError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            GetTopicRuleDestinationError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetTopicRuleDestinationError {}
/// Errors returned by GetV2LoggingOptions
#[derive(Debug, PartialEq)]
pub enum GetV2LoggingOptionsError {
    /// <p>An unexpected error has occurred.</p>
    Internal(String),
    /// <p>The resource is not configured.</p>
    NotConfigured(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
}

impl GetV2LoggingOptionsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetV2LoggingOptionsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalException" => {
                    return RusotoError::Service(GetV2LoggingOptionsError::Internal(err.msg))
                }
                "NotConfiguredException" => {
                    return RusotoError::Service(GetV2LoggingOptionsError::NotConfigured(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(GetV2LoggingOptionsError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for GetV2LoggingOptionsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetV2LoggingOptionsError::Internal(ref cause) => write!(f, "{}", cause),
            GetV2LoggingOptionsError::NotConfigured(ref cause) => write!(f, "{}", cause),
            GetV2LoggingOptionsError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetV2LoggingOptionsError {}
/// Errors returned by ListActiveViolations
#[derive(Debug, PartialEq)]
pub enum ListActiveViolationsError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl ListActiveViolationsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListActiveViolationsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(ListActiveViolationsError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(ListActiveViolationsError::InvalidRequest(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(ListActiveViolationsError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListActiveViolationsError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListActiveViolationsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListActiveViolationsError::InternalFailure(ref cause) => write!(f, "{}", cause),
            ListActiveViolationsError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            ListActiveViolationsError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            ListActiveViolationsError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListActiveViolationsError {}
/// Errors returned by ListAttachedPolicies
#[derive(Debug, PartialEq)]
pub enum ListAttachedPoliciesError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>A limit has been exceeded.</p>
    LimitExceeded(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl ListAttachedPoliciesError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListAttachedPoliciesError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(ListAttachedPoliciesError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(ListAttachedPoliciesError::InvalidRequest(err.msg))
                }
                "LimitExceededException" => {
                    return RusotoError::Service(ListAttachedPoliciesError::LimitExceeded(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(ListAttachedPoliciesError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(ListAttachedPoliciesError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListAttachedPoliciesError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(ListAttachedPoliciesError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListAttachedPoliciesError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListAttachedPoliciesError::InternalFailure(ref cause) => write!(f, "{}", cause),
            ListAttachedPoliciesError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            ListAttachedPoliciesError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            ListAttachedPoliciesError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            ListAttachedPoliciesError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            ListAttachedPoliciesError::Throttling(ref cause) => write!(f, "{}", cause),
            ListAttachedPoliciesError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListAttachedPoliciesError {}
/// Errors returned by ListAuditFindings
#[derive(Debug, PartialEq)]
pub enum ListAuditFindingsError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl ListAuditFindingsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListAuditFindingsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(ListAuditFindingsError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(ListAuditFindingsError::InvalidRequest(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListAuditFindingsError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListAuditFindingsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListAuditFindingsError::InternalFailure(ref cause) => write!(f, "{}", cause),
            ListAuditFindingsError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            ListAuditFindingsError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListAuditFindingsError {}
/// Errors returned by ListAuditMitigationActionsExecutions
#[derive(Debug, PartialEq)]
pub enum ListAuditMitigationActionsExecutionsError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl ListAuditMitigationActionsExecutionsError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<ListAuditMitigationActionsExecutionsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(
                        ListAuditMitigationActionsExecutionsError::InternalFailure(err.msg),
                    )
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(
                        ListAuditMitigationActionsExecutionsError::InvalidRequest(err.msg),
                    )
                }
                "ThrottlingException" => {
                    return RusotoError::Service(
                        ListAuditMitigationActionsExecutionsError::Throttling(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListAuditMitigationActionsExecutionsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListAuditMitigationActionsExecutionsError::InternalFailure(ref cause) => {
                write!(f, "{}", cause)
            }
            ListAuditMitigationActionsExecutionsError::InvalidRequest(ref cause) => {
                write!(f, "{}", cause)
            }
            ListAuditMitigationActionsExecutionsError::Throttling(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for ListAuditMitigationActionsExecutionsError {}
/// Errors returned by ListAuditMitigationActionsTasks
#[derive(Debug, PartialEq)]
pub enum ListAuditMitigationActionsTasksError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl ListAuditMitigationActionsTasksError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<ListAuditMitigationActionsTasksError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(
                        ListAuditMitigationActionsTasksError::InternalFailure(err.msg),
                    )
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(
                        ListAuditMitigationActionsTasksError::InvalidRequest(err.msg),
                    )
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListAuditMitigationActionsTasksError::Throttling(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListAuditMitigationActionsTasksError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListAuditMitigationActionsTasksError::InternalFailure(ref cause) => {
                write!(f, "{}", cause)
            }
            ListAuditMitigationActionsTasksError::InvalidRequest(ref cause) => {
                write!(f, "{}", cause)
            }
            ListAuditMitigationActionsTasksError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListAuditMitigationActionsTasksError {}
/// Errors returned by ListAuditSuppressions
#[derive(Debug, PartialEq)]
pub enum ListAuditSuppressionsError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl ListAuditSuppressionsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListAuditSuppressionsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(ListAuditSuppressionsError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(ListAuditSuppressionsError::InvalidRequest(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListAuditSuppressionsError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListAuditSuppressionsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListAuditSuppressionsError::InternalFailure(ref cause) => write!(f, "{}", cause),
            ListAuditSuppressionsError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            ListAuditSuppressionsError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListAuditSuppressionsError {}
/// Errors returned by ListAuditTasks
#[derive(Debug, PartialEq)]
pub enum ListAuditTasksError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl ListAuditTasksError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListAuditTasksError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(ListAuditTasksError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(ListAuditTasksError::InvalidRequest(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListAuditTasksError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListAuditTasksError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListAuditTasksError::InternalFailure(ref cause) => write!(f, "{}", cause),
            ListAuditTasksError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            ListAuditTasksError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListAuditTasksError {}
/// Errors returned by ListAuthorizers
#[derive(Debug, PartialEq)]
pub enum ListAuthorizersError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl ListAuthorizersError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListAuthorizersError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(ListAuthorizersError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(ListAuthorizersError::InvalidRequest(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(ListAuthorizersError::ServiceUnavailable(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListAuthorizersError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(ListAuthorizersError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListAuthorizersError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListAuthorizersError::InternalFailure(ref cause) => write!(f, "{}", cause),
            ListAuthorizersError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            ListAuthorizersError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            ListAuthorizersError::Throttling(ref cause) => write!(f, "{}", cause),
            ListAuthorizersError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListAuthorizersError {}
/// Errors returned by ListBillingGroups
#[derive(Debug, PartialEq)]
pub enum ListBillingGroupsError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl ListBillingGroupsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListBillingGroupsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(ListBillingGroupsError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(ListBillingGroupsError::InvalidRequest(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(ListBillingGroupsError::ResourceNotFound(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListBillingGroupsError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListBillingGroupsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListBillingGroupsError::InternalFailure(ref cause) => write!(f, "{}", cause),
            ListBillingGroupsError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            ListBillingGroupsError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            ListBillingGroupsError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListBillingGroupsError {}
/// Errors returned by ListCACertificates
#[derive(Debug, PartialEq)]
pub enum ListCACertificatesError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl ListCACertificatesError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListCACertificatesError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(ListCACertificatesError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(ListCACertificatesError::InvalidRequest(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(ListCACertificatesError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListCACertificatesError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(ListCACertificatesError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListCACertificatesError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListCACertificatesError::InternalFailure(ref cause) => write!(f, "{}", cause),
            ListCACertificatesError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            ListCACertificatesError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            ListCACertificatesError::Throttling(ref cause) => write!(f, "{}", cause),
            ListCACertificatesError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListCACertificatesError {}
/// Errors returned by ListCertificates
#[derive(Debug, PartialEq)]
pub enum ListCertificatesError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl ListCertificatesError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListCertificatesError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(ListCertificatesError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(ListCertificatesError::InvalidRequest(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(ListCertificatesError::ServiceUnavailable(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListCertificatesError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(ListCertificatesError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListCertificatesError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListCertificatesError::InternalFailure(ref cause) => write!(f, "{}", cause),
            ListCertificatesError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            ListCertificatesError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            ListCertificatesError::Throttling(ref cause) => write!(f, "{}", cause),
            ListCertificatesError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListCertificatesError {}
/// Errors returned by ListCertificatesByCA
#[derive(Debug, PartialEq)]
pub enum ListCertificatesByCAError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl ListCertificatesByCAError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListCertificatesByCAError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(ListCertificatesByCAError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(ListCertificatesByCAError::InvalidRequest(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(ListCertificatesByCAError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListCertificatesByCAError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(ListCertificatesByCAError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListCertificatesByCAError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListCertificatesByCAError::InternalFailure(ref cause) => write!(f, "{}", cause),
            ListCertificatesByCAError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            ListCertificatesByCAError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            ListCertificatesByCAError::Throttling(ref cause) => write!(f, "{}", cause),
            ListCertificatesByCAError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListCertificatesByCAError {}
/// Errors returned by ListCustomMetrics
#[derive(Debug, PartialEq)]
pub enum ListCustomMetricsError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl ListCustomMetricsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListCustomMetricsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(ListCustomMetricsError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(ListCustomMetricsError::InvalidRequest(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListCustomMetricsError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListCustomMetricsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListCustomMetricsError::InternalFailure(ref cause) => write!(f, "{}", cause),
            ListCustomMetricsError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            ListCustomMetricsError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListCustomMetricsError {}
/// Errors returned by ListDetectMitigationActionsExecutions
#[derive(Debug, PartialEq)]
pub enum ListDetectMitigationActionsExecutionsError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl ListDetectMitigationActionsExecutionsError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<ListDetectMitigationActionsExecutionsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(
                        ListDetectMitigationActionsExecutionsError::InternalFailure(err.msg),
                    )
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(
                        ListDetectMitigationActionsExecutionsError::InvalidRequest(err.msg),
                    )
                }
                "ThrottlingException" => {
                    return RusotoError::Service(
                        ListDetectMitigationActionsExecutionsError::Throttling(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListDetectMitigationActionsExecutionsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListDetectMitigationActionsExecutionsError::InternalFailure(ref cause) => {
                write!(f, "{}", cause)
            }
            ListDetectMitigationActionsExecutionsError::InvalidRequest(ref cause) => {
                write!(f, "{}", cause)
            }
            ListDetectMitigationActionsExecutionsError::Throttling(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for ListDetectMitigationActionsExecutionsError {}
/// Errors returned by ListDetectMitigationActionsTasks
#[derive(Debug, PartialEq)]
pub enum ListDetectMitigationActionsTasksError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl ListDetectMitigationActionsTasksError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<ListDetectMitigationActionsTasksError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(
                        ListDetectMitigationActionsTasksError::InternalFailure(err.msg),
                    )
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(
                        ListDetectMitigationActionsTasksError::InvalidRequest(err.msg),
                    )
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListDetectMitigationActionsTasksError::Throttling(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListDetectMitigationActionsTasksError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListDetectMitigationActionsTasksError::InternalFailure(ref cause) => {
                write!(f, "{}", cause)
            }
            ListDetectMitigationActionsTasksError::InvalidRequest(ref cause) => {
                write!(f, "{}", cause)
            }
            ListDetectMitigationActionsTasksError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListDetectMitigationActionsTasksError {}
/// Errors returned by ListDimensions
#[derive(Debug, PartialEq)]
pub enum ListDimensionsError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl ListDimensionsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListDimensionsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(ListDimensionsError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(ListDimensionsError::InvalidRequest(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListDimensionsError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListDimensionsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListDimensionsError::InternalFailure(ref cause) => write!(f, "{}", cause),
            ListDimensionsError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            ListDimensionsError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListDimensionsError {}
/// Errors returned by ListDomainConfigurations
#[derive(Debug, PartialEq)]
pub enum ListDomainConfigurationsError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl ListDomainConfigurationsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListDomainConfigurationsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(ListDomainConfigurationsError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(ListDomainConfigurationsError::InvalidRequest(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(ListDomainConfigurationsError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListDomainConfigurationsError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(ListDomainConfigurationsError::Unauthorized(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListDomainConfigurationsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListDomainConfigurationsError::InternalFailure(ref cause) => write!(f, "{}", cause),
            ListDomainConfigurationsError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            ListDomainConfigurationsError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            ListDomainConfigurationsError::Throttling(ref cause) => write!(f, "{}", cause),
            ListDomainConfigurationsError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListDomainConfigurationsError {}
/// Errors returned by ListIndices
#[derive(Debug, PartialEq)]
pub enum ListIndicesError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl ListIndicesError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListIndicesError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(ListIndicesError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(ListIndicesError::InvalidRequest(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(ListIndicesError::ServiceUnavailable(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListIndicesError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(ListIndicesError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListIndicesError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListIndicesError::InternalFailure(ref cause) => write!(f, "{}", cause),
            ListIndicesError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            ListIndicesError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            ListIndicesError::Throttling(ref cause) => write!(f, "{}", cause),
            ListIndicesError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListIndicesError {}
/// Errors returned by ListJobExecutionsForJob
#[derive(Debug, PartialEq)]
pub enum ListJobExecutionsForJobError {
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl ListJobExecutionsForJobError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListJobExecutionsForJobError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InvalidRequestException" => {
                    return RusotoError::Service(ListJobExecutionsForJobError::InvalidRequest(
                        err.msg,
                    ))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(ListJobExecutionsForJobError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(ListJobExecutionsForJobError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListJobExecutionsForJobError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListJobExecutionsForJobError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListJobExecutionsForJobError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            ListJobExecutionsForJobError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            ListJobExecutionsForJobError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            ListJobExecutionsForJobError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListJobExecutionsForJobError {}
/// Errors returned by ListJobExecutionsForThing
#[derive(Debug, PartialEq)]
pub enum ListJobExecutionsForThingError {
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl ListJobExecutionsForThingError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListJobExecutionsForThingError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InvalidRequestException" => {
                    return RusotoError::Service(ListJobExecutionsForThingError::InvalidRequest(
                        err.msg,
                    ))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(ListJobExecutionsForThingError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        ListJobExecutionsForThingError::ServiceUnavailable(err.msg),
                    )
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListJobExecutionsForThingError::Throttling(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListJobExecutionsForThingError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListJobExecutionsForThingError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            ListJobExecutionsForThingError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            ListJobExecutionsForThingError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            ListJobExecutionsForThingError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListJobExecutionsForThingError {}
/// Errors returned by ListJobTemplates
#[derive(Debug, PartialEq)]
pub enum ListJobTemplatesError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl ListJobTemplatesError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListJobTemplatesError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(ListJobTemplatesError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(ListJobTemplatesError::InvalidRequest(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListJobTemplatesError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListJobTemplatesError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListJobTemplatesError::InternalFailure(ref cause) => write!(f, "{}", cause),
            ListJobTemplatesError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            ListJobTemplatesError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListJobTemplatesError {}
/// Errors returned by ListJobs
#[derive(Debug, PartialEq)]
pub enum ListJobsError {
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl ListJobsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListJobsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InvalidRequestException" => {
                    return RusotoError::Service(ListJobsError::InvalidRequest(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(ListJobsError::ResourceNotFound(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(ListJobsError::ServiceUnavailable(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListJobsError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListJobsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListJobsError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            ListJobsError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            ListJobsError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            ListJobsError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListJobsError {}
/// Errors returned by ListMitigationActions
#[derive(Debug, PartialEq)]
pub enum ListMitigationActionsError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl ListMitigationActionsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListMitigationActionsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(ListMitigationActionsError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(ListMitigationActionsError::InvalidRequest(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListMitigationActionsError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListMitigationActionsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListMitigationActionsError::InternalFailure(ref cause) => write!(f, "{}", cause),
            ListMitigationActionsError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            ListMitigationActionsError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListMitigationActionsError {}
/// Errors returned by ListOTAUpdates
#[derive(Debug, PartialEq)]
pub enum ListOTAUpdatesError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl ListOTAUpdatesError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListOTAUpdatesError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(ListOTAUpdatesError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(ListOTAUpdatesError::InvalidRequest(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(ListOTAUpdatesError::ServiceUnavailable(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListOTAUpdatesError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(ListOTAUpdatesError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListOTAUpdatesError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListOTAUpdatesError::InternalFailure(ref cause) => write!(f, "{}", cause),
            ListOTAUpdatesError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            ListOTAUpdatesError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            ListOTAUpdatesError::Throttling(ref cause) => write!(f, "{}", cause),
            ListOTAUpdatesError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListOTAUpdatesError {}
/// Errors returned by ListOutgoingCertificates
#[derive(Debug, PartialEq)]
pub enum ListOutgoingCertificatesError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl ListOutgoingCertificatesError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListOutgoingCertificatesError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(ListOutgoingCertificatesError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(ListOutgoingCertificatesError::InvalidRequest(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(ListOutgoingCertificatesError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListOutgoingCertificatesError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(ListOutgoingCertificatesError::Unauthorized(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListOutgoingCertificatesError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListOutgoingCertificatesError::InternalFailure(ref cause) => write!(f, "{}", cause),
            ListOutgoingCertificatesError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            ListOutgoingCertificatesError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            ListOutgoingCertificatesError::Throttling(ref cause) => write!(f, "{}", cause),
            ListOutgoingCertificatesError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListOutgoingCertificatesError {}
/// Errors returned by ListPolicies
#[derive(Debug, PartialEq)]
pub enum ListPoliciesError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl ListPoliciesError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListPoliciesError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(ListPoliciesError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(ListPoliciesError::InvalidRequest(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(ListPoliciesError::ServiceUnavailable(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListPoliciesError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(ListPoliciesError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListPoliciesError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListPoliciesError::InternalFailure(ref cause) => write!(f, "{}", cause),
            ListPoliciesError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            ListPoliciesError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            ListPoliciesError::Throttling(ref cause) => write!(f, "{}", cause),
            ListPoliciesError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListPoliciesError {}
/// Errors returned by ListPolicyPrincipals
#[derive(Debug, PartialEq)]
pub enum ListPolicyPrincipalsError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl ListPolicyPrincipalsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListPolicyPrincipalsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(ListPolicyPrincipalsError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(ListPolicyPrincipalsError::InvalidRequest(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(ListPolicyPrincipalsError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(ListPolicyPrincipalsError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListPolicyPrincipalsError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(ListPolicyPrincipalsError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListPolicyPrincipalsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListPolicyPrincipalsError::InternalFailure(ref cause) => write!(f, "{}", cause),
            ListPolicyPrincipalsError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            ListPolicyPrincipalsError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            ListPolicyPrincipalsError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            ListPolicyPrincipalsError::Throttling(ref cause) => write!(f, "{}", cause),
            ListPolicyPrincipalsError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListPolicyPrincipalsError {}
/// Errors returned by ListPolicyVersions
#[derive(Debug, PartialEq)]
pub enum ListPolicyVersionsError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl ListPolicyVersionsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListPolicyVersionsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(ListPolicyVersionsError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(ListPolicyVersionsError::InvalidRequest(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(ListPolicyVersionsError::ResourceNotFound(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(ListPolicyVersionsError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListPolicyVersionsError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(ListPolicyVersionsError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListPolicyVersionsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListPolicyVersionsError::InternalFailure(ref cause) => write!(f, "{}", cause),
            ListPolicyVersionsError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            ListPolicyVersionsError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            ListPolicyVersionsError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            ListPolicyVersionsError::Throttling(ref cause) => write!(f, "{}", cause),
            ListPolicyVersionsError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListPolicyVersionsError {}
/// Errors returned by ListPrincipalPolicies
#[derive(Debug, PartialEq)]
pub enum ListPrincipalPoliciesError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl ListPrincipalPoliciesError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListPrincipalPoliciesError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(ListPrincipalPoliciesError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(ListPrincipalPoliciesError::InvalidRequest(
                        err.msg,
                    ))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(ListPrincipalPoliciesError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(ListPrincipalPoliciesError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListPrincipalPoliciesError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(ListPrincipalPoliciesError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListPrincipalPoliciesError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListPrincipalPoliciesError::InternalFailure(ref cause) => write!(f, "{}", cause),
            ListPrincipalPoliciesError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            ListPrincipalPoliciesError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            ListPrincipalPoliciesError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            ListPrincipalPoliciesError::Throttling(ref cause) => write!(f, "{}", cause),
            ListPrincipalPoliciesError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListPrincipalPoliciesError {}
/// Errors returned by ListPrincipalThings
#[derive(Debug, PartialEq)]
pub enum ListPrincipalThingsError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl ListPrincipalThingsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListPrincipalThingsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(ListPrincipalThingsError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(ListPrincipalThingsError::InvalidRequest(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(ListPrincipalThingsError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(ListPrincipalThingsError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListPrincipalThingsError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(ListPrincipalThingsError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListPrincipalThingsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListPrincipalThingsError::InternalFailure(ref cause) => write!(f, "{}", cause),
            ListPrincipalThingsError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            ListPrincipalThingsError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            ListPrincipalThingsError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            ListPrincipalThingsError::Throttling(ref cause) => write!(f, "{}", cause),
            ListPrincipalThingsError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListPrincipalThingsError {}
/// Errors returned by ListProvisioningTemplateVersions
#[derive(Debug, PartialEq)]
pub enum ListProvisioningTemplateVersionsError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl ListProvisioningTemplateVersionsError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<ListProvisioningTemplateVersionsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(
                        ListProvisioningTemplateVersionsError::InternalFailure(err.msg),
                    )
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(
                        ListProvisioningTemplateVersionsError::InvalidRequest(err.msg),
                    )
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(
                        ListProvisioningTemplateVersionsError::ResourceNotFound(err.msg),
                    )
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListProvisioningTemplateVersionsError::Throttling(
                        err.msg,
                    ))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(
                        ListProvisioningTemplateVersionsError::Unauthorized(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListProvisioningTemplateVersionsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListProvisioningTemplateVersionsError::InternalFailure(ref cause) => {
                write!(f, "{}", cause)
            }
            ListProvisioningTemplateVersionsError::InvalidRequest(ref cause) => {
                write!(f, "{}", cause)
            }
            ListProvisioningTemplateVersionsError::ResourceNotFound(ref cause) => {
                write!(f, "{}", cause)
            }
            ListProvisioningTemplateVersionsError::Throttling(ref cause) => write!(f, "{}", cause),
            ListProvisioningTemplateVersionsError::Unauthorized(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for ListProvisioningTemplateVersionsError {}
/// Errors returned by ListProvisioningTemplates
#[derive(Debug, PartialEq)]
pub enum ListProvisioningTemplatesError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl ListProvisioningTemplatesError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListProvisioningTemplatesError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(ListProvisioningTemplatesError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(ListProvisioningTemplatesError::InvalidRequest(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListProvisioningTemplatesError::Throttling(
                        err.msg,
                    ))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(ListProvisioningTemplatesError::Unauthorized(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListProvisioningTemplatesError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListProvisioningTemplatesError::InternalFailure(ref cause) => write!(f, "{}", cause),
            ListProvisioningTemplatesError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            ListProvisioningTemplatesError::Throttling(ref cause) => write!(f, "{}", cause),
            ListProvisioningTemplatesError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListProvisioningTemplatesError {}
/// Errors returned by ListRoleAliases
#[derive(Debug, PartialEq)]
pub enum ListRoleAliasesError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl ListRoleAliasesError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListRoleAliasesError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(ListRoleAliasesError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(ListRoleAliasesError::InvalidRequest(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(ListRoleAliasesError::ServiceUnavailable(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListRoleAliasesError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(ListRoleAliasesError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListRoleAliasesError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListRoleAliasesError::InternalFailure(ref cause) => write!(f, "{}", cause),
            ListRoleAliasesError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            ListRoleAliasesError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            ListRoleAliasesError::Throttling(ref cause) => write!(f, "{}", cause),
            ListRoleAliasesError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListRoleAliasesError {}
/// Errors returned by ListScheduledAudits
#[derive(Debug, PartialEq)]
pub enum ListScheduledAuditsError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl ListScheduledAuditsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListScheduledAuditsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(ListScheduledAuditsError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(ListScheduledAuditsError::InvalidRequest(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListScheduledAuditsError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListScheduledAuditsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListScheduledAuditsError::InternalFailure(ref cause) => write!(f, "{}", cause),
            ListScheduledAuditsError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            ListScheduledAuditsError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListScheduledAuditsError {}
/// Errors returned by ListSecurityProfiles
#[derive(Debug, PartialEq)]
pub enum ListSecurityProfilesError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl ListSecurityProfilesError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListSecurityProfilesError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(ListSecurityProfilesError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(ListSecurityProfilesError::InvalidRequest(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(ListSecurityProfilesError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListSecurityProfilesError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListSecurityProfilesError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListSecurityProfilesError::InternalFailure(ref cause) => write!(f, "{}", cause),
            ListSecurityProfilesError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            ListSecurityProfilesError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            ListSecurityProfilesError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListSecurityProfilesError {}
/// Errors returned by ListSecurityProfilesForTarget
#[derive(Debug, PartialEq)]
pub enum ListSecurityProfilesForTargetError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl ListSecurityProfilesForTargetError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<ListSecurityProfilesForTargetError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(
                        ListSecurityProfilesForTargetError::InternalFailure(err.msg),
                    )
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(
                        ListSecurityProfilesForTargetError::InvalidRequest(err.msg),
                    )
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(
                        ListSecurityProfilesForTargetError::ResourceNotFound(err.msg),
                    )
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListSecurityProfilesForTargetError::Throttling(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListSecurityProfilesForTargetError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListSecurityProfilesForTargetError::InternalFailure(ref cause) => {
                write!(f, "{}", cause)
            }
            ListSecurityProfilesForTargetError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            ListSecurityProfilesForTargetError::ResourceNotFound(ref cause) => {
                write!(f, "{}", cause)
            }
            ListSecurityProfilesForTargetError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListSecurityProfilesForTargetError {}
/// Errors returned by ListStreams
#[derive(Debug, PartialEq)]
pub enum ListStreamsError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl ListStreamsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListStreamsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(ListStreamsError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(ListStreamsError::InvalidRequest(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(ListStreamsError::ServiceUnavailable(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListStreamsError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(ListStreamsError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListStreamsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListStreamsError::InternalFailure(ref cause) => write!(f, "{}", cause),
            ListStreamsError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            ListStreamsError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            ListStreamsError::Throttling(ref cause) => write!(f, "{}", cause),
            ListStreamsError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListStreamsError {}
/// Errors returned by ListTagsForResource
#[derive(Debug, PartialEq)]
pub enum ListTagsForResourceError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl ListTagsForResourceError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListTagsForResourceError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(ListTagsForResourceError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(ListTagsForResourceError::InvalidRequest(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(ListTagsForResourceError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListTagsForResourceError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListTagsForResourceError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListTagsForResourceError::InternalFailure(ref cause) => write!(f, "{}", cause),
            ListTagsForResourceError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            ListTagsForResourceError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            ListTagsForResourceError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListTagsForResourceError {}
/// Errors returned by ListTargetsForPolicy
#[derive(Debug, PartialEq)]
pub enum ListTargetsForPolicyError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>A limit has been exceeded.</p>
    LimitExceeded(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl ListTargetsForPolicyError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListTargetsForPolicyError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(ListTargetsForPolicyError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(ListTargetsForPolicyError::InvalidRequest(err.msg))
                }
                "LimitExceededException" => {
                    return RusotoError::Service(ListTargetsForPolicyError::LimitExceeded(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(ListTargetsForPolicyError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(ListTargetsForPolicyError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListTargetsForPolicyError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(ListTargetsForPolicyError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListTargetsForPolicyError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListTargetsForPolicyError::InternalFailure(ref cause) => write!(f, "{}", cause),
            ListTargetsForPolicyError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            ListTargetsForPolicyError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            ListTargetsForPolicyError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            ListTargetsForPolicyError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            ListTargetsForPolicyError::Throttling(ref cause) => write!(f, "{}", cause),
            ListTargetsForPolicyError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListTargetsForPolicyError {}
/// Errors returned by ListTargetsForSecurityProfile
#[derive(Debug, PartialEq)]
pub enum ListTargetsForSecurityProfileError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl ListTargetsForSecurityProfileError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<ListTargetsForSecurityProfileError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(
                        ListTargetsForSecurityProfileError::InternalFailure(err.msg),
                    )
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(
                        ListTargetsForSecurityProfileError::InvalidRequest(err.msg),
                    )
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(
                        ListTargetsForSecurityProfileError::ResourceNotFound(err.msg),
                    )
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListTargetsForSecurityProfileError::Throttling(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListTargetsForSecurityProfileError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListTargetsForSecurityProfileError::InternalFailure(ref cause) => {
                write!(f, "{}", cause)
            }
            ListTargetsForSecurityProfileError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            ListTargetsForSecurityProfileError::ResourceNotFound(ref cause) => {
                write!(f, "{}", cause)
            }
            ListTargetsForSecurityProfileError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListTargetsForSecurityProfileError {}
/// Errors returned by ListThingGroups
#[derive(Debug, PartialEq)]
pub enum ListThingGroupsError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl ListThingGroupsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListThingGroupsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(ListThingGroupsError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(ListThingGroupsError::InvalidRequest(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(ListThingGroupsError::ResourceNotFound(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListThingGroupsError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListThingGroupsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListThingGroupsError::InternalFailure(ref cause) => write!(f, "{}", cause),
            ListThingGroupsError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            ListThingGroupsError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            ListThingGroupsError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListThingGroupsError {}
/// Errors returned by ListThingGroupsForThing
#[derive(Debug, PartialEq)]
pub enum ListThingGroupsForThingError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl ListThingGroupsForThingError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListThingGroupsForThingError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(ListThingGroupsForThingError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(ListThingGroupsForThingError::InvalidRequest(
                        err.msg,
                    ))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(ListThingGroupsForThingError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListThingGroupsForThingError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListThingGroupsForThingError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListThingGroupsForThingError::InternalFailure(ref cause) => write!(f, "{}", cause),
            ListThingGroupsForThingError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            ListThingGroupsForThingError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            ListThingGroupsForThingError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListThingGroupsForThingError {}
/// Errors returned by ListThingPrincipals
#[derive(Debug, PartialEq)]
pub enum ListThingPrincipalsError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl ListThingPrincipalsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListThingPrincipalsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(ListThingPrincipalsError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(ListThingPrincipalsError::InvalidRequest(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(ListThingPrincipalsError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(ListThingPrincipalsError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListThingPrincipalsError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(ListThingPrincipalsError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListThingPrincipalsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListThingPrincipalsError::InternalFailure(ref cause) => write!(f, "{}", cause),
            ListThingPrincipalsError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            ListThingPrincipalsError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            ListThingPrincipalsError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            ListThingPrincipalsError::Throttling(ref cause) => write!(f, "{}", cause),
            ListThingPrincipalsError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListThingPrincipalsError {}
/// Errors returned by ListThingRegistrationTaskReports
#[derive(Debug, PartialEq)]
pub enum ListThingRegistrationTaskReportsError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl ListThingRegistrationTaskReportsError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<ListThingRegistrationTaskReportsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(
                        ListThingRegistrationTaskReportsError::InternalFailure(err.msg),
                    )
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(
                        ListThingRegistrationTaskReportsError::InvalidRequest(err.msg),
                    )
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListThingRegistrationTaskReportsError::Throttling(
                        err.msg,
                    ))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(
                        ListThingRegistrationTaskReportsError::Unauthorized(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListThingRegistrationTaskReportsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListThingRegistrationTaskReportsError::InternalFailure(ref cause) => {
                write!(f, "{}", cause)
            }
            ListThingRegistrationTaskReportsError::InvalidRequest(ref cause) => {
                write!(f, "{}", cause)
            }
            ListThingRegistrationTaskReportsError::Throttling(ref cause) => write!(f, "{}", cause),
            ListThingRegistrationTaskReportsError::Unauthorized(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for ListThingRegistrationTaskReportsError {}
/// Errors returned by ListThingRegistrationTasks
#[derive(Debug, PartialEq)]
pub enum ListThingRegistrationTasksError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl ListThingRegistrationTasksError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<ListThingRegistrationTasksError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(ListThingRegistrationTasksError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(ListThingRegistrationTasksError::InvalidRequest(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListThingRegistrationTasksError::Throttling(
                        err.msg,
                    ))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(ListThingRegistrationTasksError::Unauthorized(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListThingRegistrationTasksError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListThingRegistrationTasksError::InternalFailure(ref cause) => write!(f, "{}", cause),
            ListThingRegistrationTasksError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            ListThingRegistrationTasksError::Throttling(ref cause) => write!(f, "{}", cause),
            ListThingRegistrationTasksError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListThingRegistrationTasksError {}
/// Errors returned by ListThingTypes
#[derive(Debug, PartialEq)]
pub enum ListThingTypesError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl ListThingTypesError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListThingTypesError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(ListThingTypesError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(ListThingTypesError::InvalidRequest(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(ListThingTypesError::ServiceUnavailable(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListThingTypesError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(ListThingTypesError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListThingTypesError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListThingTypesError::InternalFailure(ref cause) => write!(f, "{}", cause),
            ListThingTypesError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            ListThingTypesError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            ListThingTypesError::Throttling(ref cause) => write!(f, "{}", cause),
            ListThingTypesError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListThingTypesError {}
/// Errors returned by ListThings
#[derive(Debug, PartialEq)]
pub enum ListThingsError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl ListThingsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListThingsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(ListThingsError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(ListThingsError::InvalidRequest(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(ListThingsError::ServiceUnavailable(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListThingsError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(ListThingsError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListThingsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListThingsError::InternalFailure(ref cause) => write!(f, "{}", cause),
            ListThingsError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            ListThingsError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            ListThingsError::Throttling(ref cause) => write!(f, "{}", cause),
            ListThingsError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListThingsError {}
/// Errors returned by ListThingsInBillingGroup
#[derive(Debug, PartialEq)]
pub enum ListThingsInBillingGroupError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl ListThingsInBillingGroupError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListThingsInBillingGroupError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(ListThingsInBillingGroupError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(ListThingsInBillingGroupError::InvalidRequest(
                        err.msg,
                    ))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(ListThingsInBillingGroupError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListThingsInBillingGroupError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListThingsInBillingGroupError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListThingsInBillingGroupError::InternalFailure(ref cause) => write!(f, "{}", cause),
            ListThingsInBillingGroupError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            ListThingsInBillingGroupError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            ListThingsInBillingGroupError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListThingsInBillingGroupError {}
/// Errors returned by ListThingsInThingGroup
#[derive(Debug, PartialEq)]
pub enum ListThingsInThingGroupError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl ListThingsInThingGroupError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListThingsInThingGroupError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(ListThingsInThingGroupError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(ListThingsInThingGroupError::InvalidRequest(
                        err.msg,
                    ))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(ListThingsInThingGroupError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListThingsInThingGroupError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListThingsInThingGroupError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListThingsInThingGroupError::InternalFailure(ref cause) => write!(f, "{}", cause),
            ListThingsInThingGroupError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            ListThingsInThingGroupError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            ListThingsInThingGroupError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListThingsInThingGroupError {}
/// Errors returned by ListTopicRuleDestinations
#[derive(Debug, PartialEq)]
pub enum ListTopicRuleDestinationsError {
    /// <p>An unexpected error has occurred.</p>
    Internal(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl ListTopicRuleDestinationsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListTopicRuleDestinationsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalException" => {
                    return RusotoError::Service(ListTopicRuleDestinationsError::Internal(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(ListTopicRuleDestinationsError::InvalidRequest(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        ListTopicRuleDestinationsError::ServiceUnavailable(err.msg),
                    )
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(ListTopicRuleDestinationsError::Unauthorized(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListTopicRuleDestinationsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListTopicRuleDestinationsError::Internal(ref cause) => write!(f, "{}", cause),
            ListTopicRuleDestinationsError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            ListTopicRuleDestinationsError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            ListTopicRuleDestinationsError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListTopicRuleDestinationsError {}
/// Errors returned by ListTopicRules
#[derive(Debug, PartialEq)]
pub enum ListTopicRulesError {
    /// <p>An unexpected error has occurred.</p>
    Internal(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
}

impl ListTopicRulesError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListTopicRulesError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalException" => {
                    return RusotoError::Service(ListTopicRulesError::Internal(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(ListTopicRulesError::InvalidRequest(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(ListTopicRulesError::ServiceUnavailable(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListTopicRulesError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListTopicRulesError::Internal(ref cause) => write!(f, "{}", cause),
            ListTopicRulesError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            ListTopicRulesError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListTopicRulesError {}
/// Errors returned by ListV2LoggingLevels
#[derive(Debug, PartialEq)]
pub enum ListV2LoggingLevelsError {
    /// <p>An unexpected error has occurred.</p>
    Internal(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The resource is not configured.</p>
    NotConfigured(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
}

impl ListV2LoggingLevelsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListV2LoggingLevelsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalException" => {
                    return RusotoError::Service(ListV2LoggingLevelsError::Internal(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(ListV2LoggingLevelsError::InvalidRequest(err.msg))
                }
                "NotConfiguredException" => {
                    return RusotoError::Service(ListV2LoggingLevelsError::NotConfigured(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(ListV2LoggingLevelsError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListV2LoggingLevelsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListV2LoggingLevelsError::Internal(ref cause) => write!(f, "{}", cause),
            ListV2LoggingLevelsError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            ListV2LoggingLevelsError::NotConfigured(ref cause) => write!(f, "{}", cause),
            ListV2LoggingLevelsError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListV2LoggingLevelsError {}
/// Errors returned by ListViolationEvents
#[derive(Debug, PartialEq)]
pub enum ListViolationEventsError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl ListViolationEventsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListViolationEventsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(ListViolationEventsError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(ListViolationEventsError::InvalidRequest(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListViolationEventsError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListViolationEventsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListViolationEventsError::InternalFailure(ref cause) => write!(f, "{}", cause),
            ListViolationEventsError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            ListViolationEventsError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListViolationEventsError {}
/// Errors returned by RegisterCACertificate
#[derive(Debug, PartialEq)]
pub enum RegisterCACertificateError {
    /// <p>The certificate is invalid.</p>
    CertificateValidation(String),
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>A limit has been exceeded.</p>
    LimitExceeded(String),
    /// <p>The registration code is invalid.</p>
    RegistrationCodeValidation(String),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExists(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl RegisterCACertificateError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<RegisterCACertificateError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "CertificateValidationException" => {
                    return RusotoError::Service(RegisterCACertificateError::CertificateValidation(
                        err.msg,
                    ))
                }
                "InternalFailureException" => {
                    return RusotoError::Service(RegisterCACertificateError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(RegisterCACertificateError::InvalidRequest(
                        err.msg,
                    ))
                }
                "LimitExceededException" => {
                    return RusotoError::Service(RegisterCACertificateError::LimitExceeded(err.msg))
                }
                "RegistrationCodeValidationException" => {
                    return RusotoError::Service(
                        RegisterCACertificateError::RegistrationCodeValidation(err.msg),
                    )
                }
                "ResourceAlreadyExistsException" => {
                    return RusotoError::Service(RegisterCACertificateError::ResourceAlreadyExists(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(RegisterCACertificateError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(RegisterCACertificateError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(RegisterCACertificateError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for RegisterCACertificateError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            RegisterCACertificateError::CertificateValidation(ref cause) => write!(f, "{}", cause),
            RegisterCACertificateError::InternalFailure(ref cause) => write!(f, "{}", cause),
            RegisterCACertificateError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            RegisterCACertificateError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            RegisterCACertificateError::RegistrationCodeValidation(ref cause) => {
                write!(f, "{}", cause)
            }
            RegisterCACertificateError::ResourceAlreadyExists(ref cause) => write!(f, "{}", cause),
            RegisterCACertificateError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            RegisterCACertificateError::Throttling(ref cause) => write!(f, "{}", cause),
            RegisterCACertificateError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for RegisterCACertificateError {}
/// Errors returned by RegisterCertificate
#[derive(Debug, PartialEq)]
pub enum RegisterCertificateError {
    /// <p>Unable to verify the CA certificate used to sign the device certificate you are attempting to register. This is happens when you have registered more than one CA certificate that has the same subject field and public key.</p>
    CertificateConflict(String),
    /// <p>The certificate operation is not allowed.</p>
    CertificateState(String),
    /// <p>The certificate is invalid.</p>
    CertificateValidation(String),
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExists(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl RegisterCertificateError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<RegisterCertificateError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "CertificateConflictException" => {
                    return RusotoError::Service(RegisterCertificateError::CertificateConflict(
                        err.msg,
                    ))
                }
                "CertificateStateException" => {
                    return RusotoError::Service(RegisterCertificateError::CertificateState(
                        err.msg,
                    ))
                }
                "CertificateValidationException" => {
                    return RusotoError::Service(RegisterCertificateError::CertificateValidation(
                        err.msg,
                    ))
                }
                "InternalFailureException" => {
                    return RusotoError::Service(RegisterCertificateError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(RegisterCertificateError::InvalidRequest(err.msg))
                }
                "ResourceAlreadyExistsException" => {
                    return RusotoError::Service(RegisterCertificateError::ResourceAlreadyExists(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(RegisterCertificateError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(RegisterCertificateError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(RegisterCertificateError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for RegisterCertificateError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            RegisterCertificateError::CertificateConflict(ref cause) => write!(f, "{}", cause),
            RegisterCertificateError::CertificateState(ref cause) => write!(f, "{}", cause),
            RegisterCertificateError::CertificateValidation(ref cause) => write!(f, "{}", cause),
            RegisterCertificateError::InternalFailure(ref cause) => write!(f, "{}", cause),
            RegisterCertificateError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            RegisterCertificateError::ResourceAlreadyExists(ref cause) => write!(f, "{}", cause),
            RegisterCertificateError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            RegisterCertificateError::Throttling(ref cause) => write!(f, "{}", cause),
            RegisterCertificateError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for RegisterCertificateError {}
/// Errors returned by RegisterCertificateWithoutCA
#[derive(Debug, PartialEq)]
pub enum RegisterCertificateWithoutCAError {
    /// <p>The certificate operation is not allowed.</p>
    CertificateState(String),
    /// <p>The certificate is invalid.</p>
    CertificateValidation(String),
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExists(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl RegisterCertificateWithoutCAError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<RegisterCertificateWithoutCAError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "CertificateStateException" => {
                    return RusotoError::Service(
                        RegisterCertificateWithoutCAError::CertificateState(err.msg),
                    )
                }
                "CertificateValidationException" => {
                    return RusotoError::Service(
                        RegisterCertificateWithoutCAError::CertificateValidation(err.msg),
                    )
                }
                "InternalFailureException" => {
                    return RusotoError::Service(
                        RegisterCertificateWithoutCAError::InternalFailure(err.msg),
                    )
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(RegisterCertificateWithoutCAError::InvalidRequest(
                        err.msg,
                    ))
                }
                "ResourceAlreadyExistsException" => {
                    return RusotoError::Service(
                        RegisterCertificateWithoutCAError::ResourceAlreadyExists(err.msg),
                    )
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        RegisterCertificateWithoutCAError::ServiceUnavailable(err.msg),
                    )
                }
                "ThrottlingException" => {
                    return RusotoError::Service(RegisterCertificateWithoutCAError::Throttling(
                        err.msg,
                    ))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(RegisterCertificateWithoutCAError::Unauthorized(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for RegisterCertificateWithoutCAError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            RegisterCertificateWithoutCAError::CertificateState(ref cause) => {
                write!(f, "{}", cause)
            }
            RegisterCertificateWithoutCAError::CertificateValidation(ref cause) => {
                write!(f, "{}", cause)
            }
            RegisterCertificateWithoutCAError::InternalFailure(ref cause) => write!(f, "{}", cause),
            RegisterCertificateWithoutCAError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            RegisterCertificateWithoutCAError::ResourceAlreadyExists(ref cause) => {
                write!(f, "{}", cause)
            }
            RegisterCertificateWithoutCAError::ServiceUnavailable(ref cause) => {
                write!(f, "{}", cause)
            }
            RegisterCertificateWithoutCAError::Throttling(ref cause) => write!(f, "{}", cause),
            RegisterCertificateWithoutCAError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for RegisterCertificateWithoutCAError {}
/// Errors returned by RegisterThing
#[derive(Debug, PartialEq)]
pub enum RegisterThingError {
    /// <p>A conflicting resource update exception. This exception is thrown when two pending updates cause a conflict.</p>
    ConflictingResourceUpdate(String),
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The resource registration failed.</p>
    ResourceRegistrationFailure(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl RegisterThingError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<RegisterThingError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "ConflictingResourceUpdateException" => {
                    return RusotoError::Service(RegisterThingError::ConflictingResourceUpdate(
                        err.msg,
                    ))
                }
                "InternalFailureException" => {
                    return RusotoError::Service(RegisterThingError::InternalFailure(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(RegisterThingError::InvalidRequest(err.msg))
                }
                "ResourceRegistrationFailureException" => {
                    return RusotoError::Service(RegisterThingError::ResourceRegistrationFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(RegisterThingError::ServiceUnavailable(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(RegisterThingError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(RegisterThingError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for RegisterThingError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            RegisterThingError::ConflictingResourceUpdate(ref cause) => write!(f, "{}", cause),
            RegisterThingError::InternalFailure(ref cause) => write!(f, "{}", cause),
            RegisterThingError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            RegisterThingError::ResourceRegistrationFailure(ref cause) => write!(f, "{}", cause),
            RegisterThingError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            RegisterThingError::Throttling(ref cause) => write!(f, "{}", cause),
            RegisterThingError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for RegisterThingError {}
/// Errors returned by RejectCertificateTransfer
#[derive(Debug, PartialEq)]
pub enum RejectCertificateTransferError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You can't revert the certificate transfer because the transfer is already complete.</p>
    TransferAlreadyCompleted(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl RejectCertificateTransferError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<RejectCertificateTransferError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(RejectCertificateTransferError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(RejectCertificateTransferError::InvalidRequest(
                        err.msg,
                    ))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(RejectCertificateTransferError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        RejectCertificateTransferError::ServiceUnavailable(err.msg),
                    )
                }
                "ThrottlingException" => {
                    return RusotoError::Service(RejectCertificateTransferError::Throttling(
                        err.msg,
                    ))
                }
                "TransferAlreadyCompletedException" => {
                    return RusotoError::Service(
                        RejectCertificateTransferError::TransferAlreadyCompleted(err.msg),
                    )
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(RejectCertificateTransferError::Unauthorized(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for RejectCertificateTransferError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            RejectCertificateTransferError::InternalFailure(ref cause) => write!(f, "{}", cause),
            RejectCertificateTransferError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            RejectCertificateTransferError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            RejectCertificateTransferError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            RejectCertificateTransferError::Throttling(ref cause) => write!(f, "{}", cause),
            RejectCertificateTransferError::TransferAlreadyCompleted(ref cause) => {
                write!(f, "{}", cause)
            }
            RejectCertificateTransferError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for RejectCertificateTransferError {}
/// Errors returned by RemoveThingFromBillingGroup
#[derive(Debug, PartialEq)]
pub enum RemoveThingFromBillingGroupError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl RemoveThingFromBillingGroupError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<RemoveThingFromBillingGroupError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(RemoveThingFromBillingGroupError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(RemoveThingFromBillingGroupError::InvalidRequest(
                        err.msg,
                    ))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(
                        RemoveThingFromBillingGroupError::ResourceNotFound(err.msg),
                    )
                }
                "ThrottlingException" => {
                    return RusotoError::Service(RemoveThingFromBillingGroupError::Throttling(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for RemoveThingFromBillingGroupError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            RemoveThingFromBillingGroupError::InternalFailure(ref cause) => write!(f, "{}", cause),
            RemoveThingFromBillingGroupError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            RemoveThingFromBillingGroupError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            RemoveThingFromBillingGroupError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for RemoveThingFromBillingGroupError {}
/// Errors returned by RemoveThingFromThingGroup
#[derive(Debug, PartialEq)]
pub enum RemoveThingFromThingGroupError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl RemoveThingFromThingGroupError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<RemoveThingFromThingGroupError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(RemoveThingFromThingGroupError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(RemoveThingFromThingGroupError::InvalidRequest(
                        err.msg,
                    ))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(RemoveThingFromThingGroupError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(RemoveThingFromThingGroupError::Throttling(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for RemoveThingFromThingGroupError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            RemoveThingFromThingGroupError::InternalFailure(ref cause) => write!(f, "{}", cause),
            RemoveThingFromThingGroupError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            RemoveThingFromThingGroupError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            RemoveThingFromThingGroupError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for RemoveThingFromThingGroupError {}
/// Errors returned by ReplaceTopicRule
#[derive(Debug, PartialEq)]
pub enum ReplaceTopicRuleError {
    /// <p>A conflicting resource update exception. This exception is thrown when two pending updates cause a conflict.</p>
    ConflictingResourceUpdate(String),
    /// <p>An unexpected error has occurred.</p>
    Internal(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The Rule-SQL expression can't be parsed correctly.</p>
    SqlParse(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl ReplaceTopicRuleError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ReplaceTopicRuleError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "ConflictingResourceUpdateException" => {
                    return RusotoError::Service(ReplaceTopicRuleError::ConflictingResourceUpdate(
                        err.msg,
                    ))
                }
                "InternalException" => {
                    return RusotoError::Service(ReplaceTopicRuleError::Internal(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(ReplaceTopicRuleError::InvalidRequest(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(ReplaceTopicRuleError::ServiceUnavailable(err.msg))
                }
                "SqlParseException" => {
                    return RusotoError::Service(ReplaceTopicRuleError::SqlParse(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(ReplaceTopicRuleError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ReplaceTopicRuleError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ReplaceTopicRuleError::ConflictingResourceUpdate(ref cause) => write!(f, "{}", cause),
            ReplaceTopicRuleError::Internal(ref cause) => write!(f, "{}", cause),
            ReplaceTopicRuleError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            ReplaceTopicRuleError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            ReplaceTopicRuleError::SqlParse(ref cause) => write!(f, "{}", cause),
            ReplaceTopicRuleError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ReplaceTopicRuleError {}
/// Errors returned by SearchIndex
#[derive(Debug, PartialEq)]
pub enum SearchIndexError {
    /// <p>The index is not ready.</p>
    IndexNotReady(String),
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The query is invalid.</p>
    InvalidQuery(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl SearchIndexError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<SearchIndexError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "IndexNotReadyException" => {
                    return RusotoError::Service(SearchIndexError::IndexNotReady(err.msg))
                }
                "InternalFailureException" => {
                    return RusotoError::Service(SearchIndexError::InternalFailure(err.msg))
                }
                "InvalidQueryException" => {
                    return RusotoError::Service(SearchIndexError::InvalidQuery(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(SearchIndexError::InvalidRequest(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(SearchIndexError::ResourceNotFound(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(SearchIndexError::ServiceUnavailable(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(SearchIndexError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(SearchIndexError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for SearchIndexError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            SearchIndexError::IndexNotReady(ref cause) => write!(f, "{}", cause),
            SearchIndexError::InternalFailure(ref cause) => write!(f, "{}", cause),
            SearchIndexError::InvalidQuery(ref cause) => write!(f, "{}", cause),
            SearchIndexError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            SearchIndexError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            SearchIndexError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            SearchIndexError::Throttling(ref cause) => write!(f, "{}", cause),
            SearchIndexError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for SearchIndexError {}
/// Errors returned by SetDefaultAuthorizer
#[derive(Debug, PartialEq)]
pub enum SetDefaultAuthorizerError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExists(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl SetDefaultAuthorizerError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<SetDefaultAuthorizerError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(SetDefaultAuthorizerError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(SetDefaultAuthorizerError::InvalidRequest(err.msg))
                }
                "ResourceAlreadyExistsException" => {
                    return RusotoError::Service(SetDefaultAuthorizerError::ResourceAlreadyExists(
                        err.msg,
                    ))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(SetDefaultAuthorizerError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(SetDefaultAuthorizerError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(SetDefaultAuthorizerError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(SetDefaultAuthorizerError::Unauthorized(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for SetDefaultAuthorizerError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            SetDefaultAuthorizerError::InternalFailure(ref cause) => write!(f, "{}", cause),
            SetDefaultAuthorizerError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            SetDefaultAuthorizerError::ResourceAlreadyExists(ref cause) => write!(f, "{}", cause),
            SetDefaultAuthorizerError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            SetDefaultAuthorizerError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            SetDefaultAuthorizerError::Throttling(ref cause) => write!(f, "{}", cause),
            SetDefaultAuthorizerError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for SetDefaultAuthorizerError {}
/// Errors returned by SetDefaultPolicyVersion
#[derive(Debug, PartialEq)]
pub enum SetDefaultPolicyVersionError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFound(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
    /// <p>You are not authorized to perform this operation.</p>
    Unauthorized(String),
}

impl SetDefaultPolicyVersionError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<SetDefaultPolicyVersionError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalFailureException" => {
                    return RusotoError::Service(SetDefaultPolicyVersionError::InternalFailure(
                        err.msg,
                    ))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(SetDefaultPolicyVersionError::InvalidRequest(
                        err.msg,
                    ))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(SetDefaultPolicyVersionError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(SetDefaultPolicyVersionError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(SetDefaultPolicyVersionError::Throttling(err.msg))
                }
                "UnauthorizedException" => {
                    return RusotoError::Service(SetDefaultPolicyVersionError::Unauthorized(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for SetDefaultPolicyVersionError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            SetDefaultPolicyVersionError::InternalFailure(ref cause) => write!(f, "{}", cause),
            SetDefaultPolicyVersionError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            SetDefaultPolicyVersionError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            SetDefaultPolicyVersionError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            SetDefaultPolicyVersionError::Throttling(ref cause) => write!(f, "{}", cause),
            SetDefaultPolicyVersionError::Unauthorized(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for SetDefaultPolicyVersionError {}
/// Errors returned by SetLoggingOptions
#[derive(Debug, PartialEq)]
pub enum SetLoggingOptionsError {
    /// <p>An unexpected error has occurred.</p>
    Internal(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
}

impl SetLoggingOptionsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<SetLoggingOptionsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalException" => {
                    return RusotoError::Service(SetLoggingOptionsError::Internal(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(SetLoggingOptionsError::InvalidRequest(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(SetLoggingOptionsError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for SetLoggingOptionsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            SetLoggingOptionsError::Internal(ref cause) => write!(f, "{}", cause),
            SetLoggingOptionsError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            SetLoggingOptionsError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for SetLoggingOptionsError {}
/// Errors returned by SetV2LoggingLevel
#[derive(Debug, PartialEq)]
pub enum SetV2LoggingLevelError {
    /// <p>An unexpected error has occurred.</p>
    Internal(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>A limit has been exceeded.</p>
    LimitExceeded(String),
    /// <p>The resource is not configured.</p>
    NotConfigured(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
}

impl SetV2LoggingLevelError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<SetV2LoggingLevelError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalException" => {
                    return RusotoError::Service(SetV2LoggingLevelError::Internal(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(SetV2LoggingLevelError::InvalidRequest(err.msg))
                }
                "LimitExceededException" => {
                    return RusotoError::Service(SetV2LoggingLevelError::LimitExceeded(err.msg))
                }
                "NotConfiguredException" => {
                    return RusotoError::Service(SetV2LoggingLevelError::NotConfigured(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(SetV2LoggingLevelError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for SetV2LoggingLevelError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            SetV2LoggingLevelError::Internal(ref cause) => write!(f, "{}", cause),
            SetV2LoggingLevelError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            SetV2LoggingLevelError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            SetV2LoggingLevelError::NotConfigured(ref cause) => write!(f, "{}", cause),
            SetV2LoggingLevelError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for SetV2LoggingLevelError {}
/// Errors returned by SetV2LoggingOptions
#[derive(Debug, PartialEq)]
pub enum SetV2LoggingOptionsError {
    /// <p>An unexpected error has occurred.</p>
    Internal(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailable(String),
}

impl SetV2LoggingOptionsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<SetV2LoggingOptionsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "InternalException" => {
                    return RusotoError::Service(SetV2LoggingOptionsError::Internal(err.msg))
                }
                "InvalidRequestException" => {
                    return RusotoError::Service(SetV2LoggingOptionsError::InvalidRequest(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(SetV2LoggingOptionsError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for SetV2LoggingOptionsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            SetV2LoggingOptionsError::Internal(ref cause) => write!(f, "{}", cause),
            SetV2LoggingOptionsError::InvalidRequest(ref cause) => write!(f, "{}", cause),
            SetV2LoggingOptionsError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for SetV2LoggingOptionsError {}
/// Errors returned by StartAuditMitigationActionsTask
#[derive(Debug, PartialEq)]
pub enum StartAuditMitigationActionsTaskError {
    /// <p>An unexpected error has occurred.</p>
    InternalFailure(String),
    /// <p>The request is not valid.</p>
    InvalidRequest(String),
    /// <p>A limit has been exceeded.</p>
    LimitExceeded(String),
    /// <p> This exception occurs if you attempt to start a task with the same task-id as an existing task but with a different clientRequestToken. </p>
    TaskAlreadyExists(String),
    /// <p>The rate exceeds the limit.</p>
    Throttling(String),
}

impl StartAuditMitigationActionsTaskError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<StartAuditMitigationActionsTaskError> {
        if let Some(err) =