// =================================================================
//
//                           * WARNING *
//
//                    This file is generated!
//
//  Changes made to this file will be overwritten. If changes are
//  required to the generated code, the service_crategen project
//  must be updated to generate the changes.
//
// =================================================================

use std::error::Error;
use std::fmt;

use async_trait::async_trait;
use rusoto_core::credential::ProvideAwsCredentials;
use rusoto_core::region;
use rusoto_core::request::{BufferedHttpResponse, DispatchSignedRequest};
use rusoto_core::{Client, RusotoError};

use rusoto_core::param::{Params, ServiceParams};
use rusoto_core::proto::xml::error::*;
use rusoto_core::proto::xml::util::{
    self as xml_util, deserialize_elements, find_start_element, skip_tree,
};
use rusoto_core::proto::xml::util::{Next, Peek, XmlParseError, XmlResponse};
use rusoto_core::request::HttpResponse;
use rusoto_core::signature::SignedRequest;
#[cfg(feature = "deserialize_structs")]
use serde::Deserialize;
#[cfg(feature = "serialize_structs")]
use serde::Serialize;
use serde_urlencoded;
use std::str::FromStr;
use xml::EventReader;

impl IamClient {
    fn new_params(&self, operation_name: &str) -> Params {
        let mut params = Params::new();

        params.put("Action", operation_name);
        params.put("Version", "2010-05-08");

        params
    }

    async fn sign_and_dispatch<E>(
        &self,
        request: SignedRequest,
        from_response: fn(BufferedHttpResponse) -> RusotoError<E>,
    ) -> Result<HttpResponse, RusotoError<E>> {
        let mut response = self.client.sign_and_dispatch(request).await?;
        if !response.status.is_success() {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            return Err(from_response(response));
        }

        Ok(response)
    }
}

#[allow(dead_code)]
struct AccessAdvisorUsageGranularityTypeDeserializer;
impl AccessAdvisorUsageGranularityTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p>An object that contains details about when a principal in the reported AWS Organizations entity last attempted to access an AWS service. A principal can be an IAM user, an IAM role, or the AWS account root user within the reported Organizations entity.</p> <p>This data type is a response element in the <a>GetOrganizationsAccessReport</a> operation.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AccessDetail {
    /// <p>The path of the Organizations entity (root, organizational unit, or account) from which an authenticated principal last attempted to access the service. AWS does not report unauthenticated requests.</p> <p>This field is null if no principals (IAM users, IAM roles, or root users) in the reported Organizations entity attempted to access the service within the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>.</p>
    pub entity_path: Option<String>,
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when an authenticated principal most recently attempted to access the service. AWS does not report unauthenticated requests.</p> <p>This field is null if no principals in the reported Organizations entity attempted to access the service within the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>.</p>
    pub last_authenticated_time: Option<String>,
    /// <p>The Region where the last service access attempt occurred.</p> <p>This field is null if no principals in the reported Organizations entity attempted to access the service within the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>.</p>
    pub region: Option<String>,
    /// <p>The name of the service in which access was attempted.</p>
    pub service_name: String,
    /// <p>The namespace of the service in which access was attempted.</p> <p>To learn the service namespace of a service, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html">Actions, resources, and condition keys for AWS services</a> in the <i>Service Authorization Reference</i>. Choose the name of the service to view details for that service. In the first paragraph, find the service prefix. For example, <code>(service prefix: a4b)</code>. For more information about service namespaces, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces">AWS service namespaces</a> in the <i>AWS General Reference</i>.</p>
    pub service_namespace: String,
    /// <p>The number of accounts with authenticated principals (root users, IAM users, and IAM roles) that attempted to access the service in the reporting period.</p>
    pub total_authenticated_entities: Option<i64>,
}

#[allow(dead_code)]
struct AccessDetailDeserializer;
impl AccessDetailDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AccessDetail, XmlParseError> {
        deserialize_elements::<_, AccessDetail, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "EntityPath" => {
                    obj.entity_path = Some(OrganizationsEntityPathTypeDeserializer::deserialize(
                        "EntityPath",
                        stack,
                    )?);
                }
                "LastAuthenticatedTime" => {
                    obj.last_authenticated_time = Some(DateTypeDeserializer::deserialize(
                        "LastAuthenticatedTime",
                        stack,
                    )?);
                }
                "Region" => {
                    obj.region = Some(StringTypeDeserializer::deserialize("Region", stack)?);
                }
                "ServiceName" => {
                    obj.service_name =
                        ServiceNameTypeDeserializer::deserialize("ServiceName", stack)?;
                }
                "ServiceNamespace" => {
                    obj.service_namespace =
                        ServiceNamespaceTypeDeserializer::deserialize("ServiceNamespace", stack)?;
                }
                "TotalAuthenticatedEntities" => {
                    obj.total_authenticated_entities = Some(IntegerTypeDeserializer::deserialize(
                        "TotalAuthenticatedEntities",
                        stack,
                    )?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct AccessDetailsDeserializer;
impl AccessDetailsDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<AccessDetail>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(AccessDetailDeserializer::deserialize("member", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p><p>Contains information about an AWS access key.</p> <p> This data type is used as a response element in the <a>CreateAccessKey</a> and <a>ListAccessKeys</a> operations. </p> <note> <p>The <code>SecretAccessKey</code> value is returned only in response to <a>CreateAccessKey</a>. You can get a secret access key only when you first create an access key; you cannot recover the secret access key later. If you lose a secret access key, you must create a new access key.</p> </note></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AccessKey {
    /// <p>The ID for this access key.</p>
    pub access_key_id: String,
    /// <p>The date when the access key was created.</p>
    pub create_date: Option<String>,
    /// <p>The secret key used to sign requests.</p>
    pub secret_access_key: String,
    /// <p>The status of the access key. <code>Active</code> means that the key is valid for API calls, while <code>Inactive</code> means it is not. </p>
    pub status: String,
    /// <p>The name of the IAM user that the access key is associated with.</p>
    pub user_name: String,
}

#[allow(dead_code)]
struct AccessKeyDeserializer;
impl AccessKeyDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AccessKey, XmlParseError> {
        deserialize_elements::<_, AccessKey, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "AccessKeyId" => {
                    obj.access_key_id =
                        AccessKeyIdTypeDeserializer::deserialize("AccessKeyId", stack)?;
                }
                "CreateDate" => {
                    obj.create_date = Some(DateTypeDeserializer::deserialize("CreateDate", stack)?);
                }
                "SecretAccessKey" => {
                    obj.secret_access_key =
                        AccessKeySecretTypeDeserializer::deserialize("SecretAccessKey", stack)?;
                }
                "Status" => {
                    obj.status = StatusTypeDeserializer::deserialize("Status", stack)?;
                }
                "UserName" => {
                    obj.user_name = UserNameTypeDeserializer::deserialize("UserName", stack)?;
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct AccessKeyIdTypeDeserializer;
impl AccessKeyIdTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p>Contains information about the last time an AWS access key was used since IAM began tracking this information on April 22, 2015.</p> <p>This data type is used as a response element in the <a>GetAccessKeyLastUsed</a> operation.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AccessKeyLastUsed {
    /// <p><p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the access key was most recently used. This field is null in the following situations:</p> <ul> <li> <p>The user does not have an access key.</p> </li> <li> <p>An access key exists but has not been used since IAM began tracking this information.</p> </li> <li> <p>There is no sign-in data associated with the user.</p> </li> </ul></p>
    pub last_used_date: String,
    /// <p>The AWS Region where this access key was most recently used. The value for this field is "N/A" in the following situations:</p> <ul> <li> <p>The user does not have an access key.</p> </li> <li> <p>An access key exists but has not been used since IAM began tracking this information.</p> </li> <li> <p>There is no sign-in data associated with the user.</p> </li> </ul> <p>For more information about AWS Regions, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and endpoints</a> in the Amazon Web Services General Reference.</p>
    pub region: String,
    /// <p><p>The name of the AWS service with which this access key was most recently used. The value of this field is &quot;N/A&quot; in the following situations:</p> <ul> <li> <p>The user does not have an access key.</p> </li> <li> <p>An access key exists but has not been used since IAM started tracking this information.</p> </li> <li> <p>There is no sign-in data associated with the user.</p> </li> </ul></p>
    pub service_name: String,
}

#[allow(dead_code)]
struct AccessKeyLastUsedDeserializer;
impl AccessKeyLastUsedDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AccessKeyLastUsed, XmlParseError> {
        deserialize_elements::<_, AccessKeyLastUsed, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "LastUsedDate" => {
                    obj.last_used_date = DateTypeDeserializer::deserialize("LastUsedDate", stack)?;
                }
                "Region" => {
                    obj.region = StringTypeDeserializer::deserialize("Region", stack)?;
                }
                "ServiceName" => {
                    obj.service_name = StringTypeDeserializer::deserialize("ServiceName", stack)?;
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>Contains information about an AWS access key, without its secret key.</p> <p>This data type is used as a response element in the <a>ListAccessKeys</a> operation.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AccessKeyMetadata {
    /// <p>The ID for this access key.</p>
    pub access_key_id: Option<String>,
    /// <p>The date when the access key was created.</p>
    pub create_date: Option<String>,
    /// <p>The status of the access key. <code>Active</code> means that the key is valid for API calls; <code>Inactive</code> means it is not.</p>
    pub status: Option<String>,
    /// <p>The name of the IAM user that the key is associated with.</p>
    pub user_name: Option<String>,
}

#[allow(dead_code)]
struct AccessKeyMetadataDeserializer;
impl AccessKeyMetadataDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AccessKeyMetadata, XmlParseError> {
        deserialize_elements::<_, AccessKeyMetadata, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "AccessKeyId" => {
                    obj.access_key_id = Some(AccessKeyIdTypeDeserializer::deserialize(
                        "AccessKeyId",
                        stack,
                    )?);
                }
                "CreateDate" => {
                    obj.create_date = Some(DateTypeDeserializer::deserialize("CreateDate", stack)?);
                }
                "Status" => {
                    obj.status = Some(StatusTypeDeserializer::deserialize("Status", stack)?);
                }
                "UserName" => {
                    obj.user_name = Some(UserNameTypeDeserializer::deserialize("UserName", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct AccessKeyMetadataListTypeDeserializer;
impl AccessKeyMetadataListTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<AccessKeyMetadata>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(AccessKeyMetadataDeserializer::deserialize("member", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct AccessKeySecretTypeDeserializer;
impl AccessKeySecretTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct AccountAliasListTypeDeserializer;
impl AccountAliasListTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<String>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(AccountAliasTypeDeserializer::deserialize("member", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct AccountAliasTypeDeserializer;
impl AccountAliasTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}

/// Serialize `ActionNameListType` contents to a `SignedRequest`.
struct ActionNameListTypeSerializer;
impl ActionNameListTypeSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<String>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.member.{}", name, index + 1);
            params.put(&key, &obj);
        }
    }
}

#[allow(dead_code)]
struct ActionNameTypeDeserializer;
impl ActionNameTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AddClientIDToOpenIDConnectProviderRequest {
    /// <p>The client ID (also known as audience) to add to the IAM OpenID Connect provider resource.</p>
    pub client_id: String,
    /// <p>The Amazon Resource Name (ARN) of the IAM OpenID Connect (OIDC) provider resource to add the client ID to. You can get a list of OIDC provider ARNs by using the <a>ListOpenIDConnectProviders</a> operation.</p>
    pub open_id_connect_provider_arn: String,
}

/// Serialize `AddClientIDToOpenIDConnectProviderRequest` contents to a `SignedRequest`.
struct AddClientIDToOpenIDConnectProviderRequestSerializer;
impl AddClientIDToOpenIDConnectProviderRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &AddClientIDToOpenIDConnectProviderRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "ClientID"), &obj.client_id);
        params.put(
            &format!("{}{}", prefix, "OpenIDConnectProviderArn"),
            &obj.open_id_connect_provider_arn,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AddRoleToInstanceProfileRequest {
    /// <p>The name of the instance profile to update.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub instance_profile_name: String,
    /// <p>The name of the role to add.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub role_name: String,
}

/// Serialize `AddRoleToInstanceProfileRequest` contents to a `SignedRequest`.
struct AddRoleToInstanceProfileRequestSerializer;
impl AddRoleToInstanceProfileRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &AddRoleToInstanceProfileRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "InstanceProfileName"),
            &obj.instance_profile_name,
        );
        params.put(&format!("{}{}", prefix, "RoleName"), &obj.role_name);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AddUserToGroupRequest {
    /// <p>The name of the group to update.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub group_name: String,
    /// <p>The name of the user to add.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub user_name: String,
}

/// Serialize `AddUserToGroupRequest` contents to a `SignedRequest`.
struct AddUserToGroupRequestSerializer;
impl AddUserToGroupRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &AddUserToGroupRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "GroupName"), &obj.group_name);
        params.put(&format!("{}{}", prefix, "UserName"), &obj.user_name);
    }
}

#[allow(dead_code)]
struct ArnListTypeDeserializer;
impl ArnListTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<String>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(ArnTypeDeserializer::deserialize("member", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct ArnTypeDeserializer;
impl ArnTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AttachGroupPolicyRequest {
    /// <p>The name (friendly name, not ARN) of the group to attach the policy to.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub group_name: String,
    /// <p>The Amazon Resource Name (ARN) of the IAM policy you want to attach.</p> <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub policy_arn: String,
}

/// Serialize `AttachGroupPolicyRequest` contents to a `SignedRequest`.
struct AttachGroupPolicyRequestSerializer;
impl AttachGroupPolicyRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &AttachGroupPolicyRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "GroupName"), &obj.group_name);
        params.put(&format!("{}{}", prefix, "PolicyArn"), &obj.policy_arn);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AttachRolePolicyRequest {
    /// <p>The Amazon Resource Name (ARN) of the IAM policy you want to attach.</p> <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub policy_arn: String,
    /// <p>The name (friendly name, not ARN) of the role to attach the policy to.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub role_name: String,
}

/// Serialize `AttachRolePolicyRequest` contents to a `SignedRequest`.
struct AttachRolePolicyRequestSerializer;
impl AttachRolePolicyRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &AttachRolePolicyRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "PolicyArn"), &obj.policy_arn);
        params.put(&format!("{}{}", prefix, "RoleName"), &obj.role_name);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AttachUserPolicyRequest {
    /// <p>The Amazon Resource Name (ARN) of the IAM policy you want to attach.</p> <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub policy_arn: String,
    /// <p>The name (friendly name, not ARN) of the IAM user to attach the policy to.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub user_name: String,
}

/// Serialize `AttachUserPolicyRequest` contents to a `SignedRequest`.
struct AttachUserPolicyRequestSerializer;
impl AttachUserPolicyRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &AttachUserPolicyRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "PolicyArn"), &obj.policy_arn);
        params.put(&format!("{}{}", prefix, "UserName"), &obj.user_name);
    }
}

/// <p>Contains information about an attached permissions boundary.</p> <p>An attached permissions boundary is a managed policy that has been attached to a user or role to set the permissions boundary.</p> <p>For more information about permissions boundaries, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM identities </a> in the <i>IAM User Guide</i>.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AttachedPermissionsBoundary {
    /// <p> The ARN of the policy used to set the permissions boundary for the user or role.</p>
    pub permissions_boundary_arn: Option<String>,
    /// <p> The permissions boundary usage type that indicates what type of IAM resource is used as the permissions boundary for an entity. This data type can only have a value of <code>Policy</code>.</p>
    pub permissions_boundary_type: Option<String>,
}

#[allow(dead_code)]
struct AttachedPermissionsBoundaryDeserializer;
impl AttachedPermissionsBoundaryDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AttachedPermissionsBoundary, XmlParseError> {
        deserialize_elements::<_, AttachedPermissionsBoundary, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "PermissionsBoundaryArn" => {
                        obj.permissions_boundary_arn = Some(ArnTypeDeserializer::deserialize(
                            "PermissionsBoundaryArn",
                            stack,
                        )?);
                    }
                    "PermissionsBoundaryType" => {
                        obj.permissions_boundary_type =
                            Some(PermissionsBoundaryAttachmentTypeDeserializer::deserialize(
                                "PermissionsBoundaryType",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct AttachedPoliciesListTypeDeserializer;
impl AttachedPoliciesListTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<AttachedPolicy>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(AttachedPolicyDeserializer::deserialize("member", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Contains information about an attached policy.</p> <p>An attached policy is a managed policy that has been attached to a user, group, or role. This data type is used as a response element in the <a>ListAttachedGroupPolicies</a>, <a>ListAttachedRolePolicies</a>, <a>ListAttachedUserPolicies</a>, and <a>GetAccountAuthorizationDetails</a> operations. </p> <p>For more information about managed policies, refer to <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline policies</a> in the <i>IAM User Guide</i>. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AttachedPolicy {
    pub policy_arn: Option<String>,
    /// <p>The friendly name of the attached policy.</p>
    pub policy_name: Option<String>,
}

#[allow(dead_code)]
struct AttachedPolicyDeserializer;
impl AttachedPolicyDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AttachedPolicy, XmlParseError> {
        deserialize_elements::<_, AttachedPolicy, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "PolicyArn" => {
                    obj.policy_arn = Some(ArnTypeDeserializer::deserialize("PolicyArn", stack)?);
                }
                "PolicyName" => {
                    obj.policy_name = Some(PolicyNameTypeDeserializer::deserialize(
                        "PolicyName",
                        stack,
                    )?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct AttachmentCountTypeDeserializer;
impl AttachmentCountTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<i64, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, |s| Ok(i64::from_str(&s).unwrap()))
    }
}
#[allow(dead_code)]
struct BooleanObjectTypeDeserializer;
impl BooleanObjectTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<bool, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, |s| Ok(bool::from_str(&s).unwrap()))
    }
}
#[allow(dead_code)]
struct BooleanTypeDeserializer;
impl BooleanTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<bool, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, |s| Ok(bool::from_str(&s).unwrap()))
    }
}
#[allow(dead_code)]
struct BootstrapDatumDeserializer;
impl BootstrapDatumDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<bytes::Bytes, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, |s| Ok(s.into()))
    }
}
#[allow(dead_code)]
struct CertificateBodyTypeDeserializer;
impl CertificateBodyTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct CertificateChainTypeDeserializer;
impl CertificateChainTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct CertificateIdTypeDeserializer;
impl CertificateIdTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct CertificateListTypeDeserializer;
impl CertificateListTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<SigningCertificate>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(SigningCertificateDeserializer::deserialize(
                    "member", stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ChangePasswordRequest {
    /// <p>The new password. The new password must conform to the AWS account's password policy, if one exists.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a string of characters. That string can include almost any printable ASCII character from the space (<code>\u0020</code>) through the end of the ASCII character range (<code>\u00FF</code>). You can also include the tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>) characters. Any of these characters are valid in a password. However, many tools, such as the AWS Management Console, might restrict the ability to type certain characters because they have special meaning within that tool.</p>
    pub new_password: String,
    /// <p>The IAM user's current password.</p>
    pub old_password: String,
}

/// Serialize `ChangePasswordRequest` contents to a `SignedRequest`.
struct ChangePasswordRequestSerializer;
impl ChangePasswordRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ChangePasswordRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "NewPassword"), &obj.new_password);
        params.put(&format!("{}{}", prefix, "OldPassword"), &obj.old_password);
    }
}

#[allow(dead_code)]
struct ClientIDListTypeDeserializer;
impl ClientIDListTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<String>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(ClientIDTypeDeserializer::deserialize("member", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}

/// Serialize `ClientIDListType` contents to a `SignedRequest`.
struct ClientIDListTypeSerializer;
impl ClientIDListTypeSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<String>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.member.{}", name, index + 1);
            params.put(&key, &obj);
        }
    }
}

#[allow(dead_code)]
struct ClientIDTypeDeserializer;
impl ClientIDTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct ColumnNumberDeserializer;
impl ColumnNumberDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<i64, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, |s| Ok(i64::from_str(&s).unwrap()))
    }
}
/// <p>Contains information about a condition context key. It includes the name of the key and specifies the value (or values, if the context key supports multiple values) to use in the simulation. This information is used when evaluating the <code>Condition</code> elements of the input policies.</p> <p>This data type is used as an input parameter to <a>SimulateCustomPolicy</a> and <a>SimulatePrincipalPolicy</a>.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ContextEntry {
    /// <p>The full name of a condition context key, including the service prefix. For example, <code>aws:SourceIp</code> or <code>s3:VersionId</code>.</p>
    pub context_key_name: Option<String>,
    /// <p>The data type of the value (or values) specified in the <code>ContextKeyValues</code> parameter.</p>
    pub context_key_type: Option<String>,
    /// <p>The value (or values, if the condition context key supports multiple values) to provide to the simulation when the key is referenced by a <code>Condition</code> element in an input policy.</p>
    pub context_key_values: Option<Vec<String>>,
}

/// Serialize `ContextEntry` contents to a `SignedRequest`.
struct ContextEntrySerializer;
impl ContextEntrySerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ContextEntry) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.context_key_name {
            params.put(&format!("{}{}", prefix, "ContextKeyName"), &field_value);
        }
        if let Some(ref field_value) = obj.context_key_type {
            params.put(&format!("{}{}", prefix, "ContextKeyType"), &field_value);
        }
        if let Some(ref field_value) = obj.context_key_values {
            ContextKeyValueListTypeSerializer::serialize(
                params,
                &format!("{}{}", prefix, "ContextKeyValues"),
                field_value,
            );
        }
    }
}

/// Serialize `ContextEntryListType` contents to a `SignedRequest`.
struct ContextEntryListTypeSerializer;
impl ContextEntryListTypeSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<ContextEntry>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.member.{}", name, index + 1);
            ContextEntrySerializer::serialize(params, &key, obj);
        }
    }
}

#[allow(dead_code)]
struct ContextKeyNameTypeDeserializer;
impl ContextKeyNameTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct ContextKeyNamesResultListTypeDeserializer;
impl ContextKeyNamesResultListTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<String>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(ContextKeyNameTypeDeserializer::deserialize(
                    "member", stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}

/// Serialize `ContextKeyValueListType` contents to a `SignedRequest`.
struct ContextKeyValueListTypeSerializer;
impl ContextKeyValueListTypeSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<String>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.member.{}", name, index + 1);
            params.put(&key, &obj);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateAccessKeyRequest {
    /// <p>The name of the IAM user that the new key will belong to.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub user_name: Option<String>,
}

/// Serialize `CreateAccessKeyRequest` contents to a `SignedRequest`.
struct CreateAccessKeyRequestSerializer;
impl CreateAccessKeyRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateAccessKeyRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.user_name {
            params.put(&format!("{}{}", prefix, "UserName"), &field_value);
        }
    }
}

/// <p>Contains the response to a successful <a>CreateAccessKey</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateAccessKeyResponse {
    /// <p>A structure with details about the access key.</p>
    pub access_key: AccessKey,
}

#[allow(dead_code)]
struct CreateAccessKeyResponseDeserializer;
impl CreateAccessKeyResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateAccessKeyResponse, XmlParseError> {
        deserialize_elements::<_, CreateAccessKeyResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "AccessKey" => {
                        obj.access_key = AccessKeyDeserializer::deserialize("AccessKey", stack)?;
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateAccountAliasRequest {
    /// <p>The account alias to create.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of lowercase letters, digits, and dashes. You cannot start or finish with a dash, nor can you have two dashes in a row.</p>
    pub account_alias: String,
}

/// Serialize `CreateAccountAliasRequest` contents to a `SignedRequest`.
struct CreateAccountAliasRequestSerializer;
impl CreateAccountAliasRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateAccountAliasRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "AccountAlias"), &obj.account_alias);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateGroupRequest {
    /// <p>The name of the group to create. Do not include the path in this value.</p> <p>IAM user, group, role, and policy names must be unique within the account. Names are not distinguished by case. For example, you cannot create resources named both "MyResource" and "myresource".</p>
    pub group_name: String,
    /// <p> The path to the group. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the <i>IAM User Guide</i>.</p> <p>This parameter is optional. If it is not included, it defaults to a slash (/).</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes. In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including most punctuation characters, digits, and upper and lowercased letters.</p>
    pub path: Option<String>,
}

/// Serialize `CreateGroupRequest` contents to a `SignedRequest`.
struct CreateGroupRequestSerializer;
impl CreateGroupRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateGroupRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "GroupName"), &obj.group_name);
        if let Some(ref field_value) = obj.path {
            params.put(&format!("{}{}", prefix, "Path"), &field_value);
        }
    }
}

/// <p>Contains the response to a successful <a>CreateGroup</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateGroupResponse {
    /// <p>A structure containing details about the new group.</p>
    pub group: Group,
}

#[allow(dead_code)]
struct CreateGroupResponseDeserializer;
impl CreateGroupResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateGroupResponse, XmlParseError> {
        deserialize_elements::<_, CreateGroupResponse, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Group" => {
                    obj.group = GroupDeserializer::deserialize("Group", stack)?;
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateInstanceProfileRequest {
    /// <p>The name of the instance profile to create.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub instance_profile_name: String,
    /// <p> The path to the instance profile. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the <i>IAM User Guide</i>.</p> <p>This parameter is optional. If it is not included, it defaults to a slash (/).</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes. In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including most punctuation characters, digits, and upper and lowercased letters.</p>
    pub path: Option<String>,
    /// <p><p>A list of tags that you want to attach to the newly created IAM instance profile. Each tag consists of a key name and an associated value. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User Guide</i>.</p> <note> <p>If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request fails and the resource is not created.</p> </note></p>
    pub tags: Option<Vec<Tag>>,
}

/// Serialize `CreateInstanceProfileRequest` contents to a `SignedRequest`.
struct CreateInstanceProfileRequestSerializer;
impl CreateInstanceProfileRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateInstanceProfileRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "InstanceProfileName"),
            &obj.instance_profile_name,
        );
        if let Some(ref field_value) = obj.path {
            params.put(&format!("{}{}", prefix, "Path"), &field_value);
        }
        if let Some(ref field_value) = obj.tags {
            TagListTypeSerializer::serialize(params, &format!("{}{}", prefix, "Tags"), field_value);
        }
    }
}

/// <p>Contains the response to a successful <a>CreateInstanceProfile</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateInstanceProfileResponse {
    /// <p>A structure containing details about the new instance profile.</p>
    pub instance_profile: InstanceProfile,
}

#[allow(dead_code)]
struct CreateInstanceProfileResponseDeserializer;
impl CreateInstanceProfileResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateInstanceProfileResponse, XmlParseError> {
        deserialize_elements::<_, CreateInstanceProfileResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "InstanceProfile" => {
                        obj.instance_profile =
                            InstanceProfileDeserializer::deserialize("InstanceProfile", stack)?;
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateLoginProfileRequest {
    /// <p>The new password for the user.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a string of characters. That string can include almost any printable ASCII character from the space (<code>\u0020</code>) through the end of the ASCII character range (<code>\u00FF</code>). You can also include the tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>) characters. Any of these characters are valid in a password. However, many tools, such as the AWS Management Console, might restrict the ability to type certain characters because they have special meaning within that tool.</p>
    pub password: String,
    /// <p>Specifies whether the user is required to set a new password on next sign-in.</p>
    pub password_reset_required: Option<bool>,
    /// <p>The name of the IAM user to create a password for. The user must already exist.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub user_name: String,
}

/// Serialize `CreateLoginProfileRequest` contents to a `SignedRequest`.
struct CreateLoginProfileRequestSerializer;
impl CreateLoginProfileRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateLoginProfileRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "Password"), &obj.password);
        if let Some(ref field_value) = obj.password_reset_required {
            params.put(
                &format!("{}{}", prefix, "PasswordResetRequired"),
                &field_value,
            );
        }
        params.put(&format!("{}{}", prefix, "UserName"), &obj.user_name);
    }
}

/// <p>Contains the response to a successful <a>CreateLoginProfile</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateLoginProfileResponse {
    /// <p>A structure containing the user name and password create date.</p>
    pub login_profile: LoginProfile,
}

#[allow(dead_code)]
struct CreateLoginProfileResponseDeserializer;
impl CreateLoginProfileResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateLoginProfileResponse, XmlParseError> {
        deserialize_elements::<_, CreateLoginProfileResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "LoginProfile" => {
                        obj.login_profile =
                            LoginProfileDeserializer::deserialize("LoginProfile", stack)?;
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateOpenIDConnectProviderRequest {
    /// <p>A list of client IDs (also known as audiences). When a mobile or web app registers with an OpenID Connect provider, they establish a value that identifies the application. (This is the value that's sent as the <code>client_id</code> parameter on OAuth requests.)</p> <p>You can register multiple client IDs with the same provider. For example, you might have multiple applications that use the same OIDC provider. You cannot register more than 100 client IDs with a single IAM OIDC provider.</p> <p>There is no defined format for a client ID. The <code>CreateOpenIDConnectProviderRequest</code> operation accepts client IDs up to 255 characters long.</p>
    pub client_id_list: Option<Vec<String>>,
    /// <p><p>A list of tags that you want to attach to the new IAM OpenID Connect (OIDC) provider. Each tag consists of a key name and an associated value. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User Guide</i>.</p> <note> <p>If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request fails and the resource is not created.</p> </note></p>
    pub tags: Option<Vec<Tag>>,
    /// <p>A list of server certificate thumbprints for the OpenID Connect (OIDC) identity provider's server certificates. Typically this list includes only one entry. However, IAM lets you have up to five thumbprints for an OIDC provider. This lets you maintain multiple thumbprints if the identity provider is rotating certificates.</p> <p>The server certificate thumbprint is the hex-encoded SHA-1 hash value of the X.509 certificate used by the domain where the OpenID Connect provider makes its keys available. It is always a 40-character string.</p> <p>You must provide at least one thumbprint when creating an IAM OIDC provider. For example, assume that the OIDC provider is <code>server.example.com</code> and the provider stores its keys at https://keys.server.example.com/openid-connect. In that case, the thumbprint string would be the hex-encoded SHA-1 hash value of the certificate used by https://keys.server.example.com.</p> <p>For more information about obtaining the OIDC provider's thumbprint, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/identity-providers-oidc-obtain-thumbprint.html">Obtaining the thumbprint for an OpenID Connect provider</a> in the <i>IAM User Guide</i>.</p>
    pub thumbprint_list: Vec<String>,
    /// <p>The URL of the identity provider. The URL must begin with <code>https://</code> and should correspond to the <code>iss</code> claim in the provider's OpenID Connect ID tokens. Per the OIDC standard, path components are allowed but query parameters are not. Typically the URL consists of only a hostname, like <code>https://server.example.org</code> or <code>https://example.com</code>.</p> <p>You cannot register the same provider multiple times in a single AWS account. If you try to submit a URL that has already been used for an OpenID Connect provider in the AWS account, you will get an error.</p>
    pub url: String,
}

/// Serialize `CreateOpenIDConnectProviderRequest` contents to a `SignedRequest`.
struct CreateOpenIDConnectProviderRequestSerializer;
impl CreateOpenIDConnectProviderRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateOpenIDConnectProviderRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.client_id_list {
            ClientIDListTypeSerializer::serialize(
                params,
                &format!("{}{}", prefix, "ClientIDList"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.tags {
            TagListTypeSerializer::serialize(params, &format!("{}{}", prefix, "Tags"), field_value);
        }
        ThumbprintListTypeSerializer::serialize(
            params,
            &format!("{}{}", prefix, "ThumbprintList"),
            &obj.thumbprint_list,
        );
        params.put(&format!("{}{}", prefix, "Url"), &obj.url);
    }
}

/// <p>Contains the response to a successful <a>CreateOpenIDConnectProvider</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateOpenIDConnectProviderResponse {
    /// <p>The Amazon Resource Name (ARN) of the new IAM OpenID Connect provider that is created. For more information, see <a>OpenIDConnectProviderListEntry</a>. </p>
    pub open_id_connect_provider_arn: Option<String>,
    /// <p>A list of tags that are attached to the new IAM OIDC provider. The returned list of tags is sorted by tag key. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User Guide</i>.</p>
    pub tags: Option<Vec<Tag>>,
}

#[allow(dead_code)]
struct CreateOpenIDConnectProviderResponseDeserializer;
impl CreateOpenIDConnectProviderResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateOpenIDConnectProviderResponse, XmlParseError> {
        deserialize_elements::<_, CreateOpenIDConnectProviderResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "OpenIDConnectProviderArn" => {
                        obj.open_id_connect_provider_arn = Some(ArnTypeDeserializer::deserialize(
                            "OpenIDConnectProviderArn",
                            stack,
                        )?);
                    }
                    "Tags" => {
                        obj.tags
                            .get_or_insert(vec![])
                            .extend(TagListTypeDeserializer::deserialize("Tags", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreatePolicyRequest {
    /// <p>A friendly description of the policy.</p> <p>Typically used to store information about the permissions defined in the policy. For example, "Grants access to production DynamoDB tables."</p> <p>The policy description is immutable. After a value is assigned, it cannot be changed.</p>
    pub description: Option<String>,
    /// <p>The path for the policy.</p> <p>For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the <i>IAM User Guide</i>.</p> <p>This parameter is optional. If it is not included, it defaults to a slash (/).</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes. In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including most punctuation characters, digits, and upper and lowercased letters.</p>
    pub path: Option<String>,
    /// <p><p>The JSON policy document that you want to use as the content for the new policy.</p> <p>You must provide policies in JSON format in IAM. However, for AWS CloudFormation templates formatted in YAML, you can provide the policy in JSON or YAML format. AWS CloudFormation always converts a YAML policy to JSON format before submitting it to IAM.</p> <p>To learn more about JSON policy grammar, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_grammar.html">Grammar of the IAM JSON policy language</a> in the <i>IAM User Guide</i>. </p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of characters consisting of the following:</p> <ul> <li> <p>Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p> </li> <li> <p>The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>)</p> </li> <li> <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>)</p> </li> </ul></p>
    pub policy_document: String,
    /// <p>The friendly name of the policy.</p> <p>IAM user, group, role, and policy names must be unique within the account. Names are not distinguished by case. For example, you cannot create resources named both "MyResource" and "myresource".</p>
    pub policy_name: String,
    /// <p><p>A list of tags that you want to attach to the new IAM customer managed policy. Each tag consists of a key name and an associated value. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User Guide</i>.</p> <note> <p>If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request fails and the resource is not created.</p> </note></p>
    pub tags: Option<Vec<Tag>>,
}

/// Serialize `CreatePolicyRequest` contents to a `SignedRequest`.
struct CreatePolicyRequestSerializer;
impl CreatePolicyRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreatePolicyRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.description {
            params.put(&format!("{}{}", prefix, "Description"), &field_value);
        }
        if let Some(ref field_value) = obj.path {
            params.put(&format!("{}{}", prefix, "Path"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "PolicyDocument"),
            &obj.policy_document,
        );
        params.put(&format!("{}{}", prefix, "PolicyName"), &obj.policy_name);
        if let Some(ref field_value) = obj.tags {
            TagListTypeSerializer::serialize(params, &format!("{}{}", prefix, "Tags"), field_value);
        }
    }
}

/// <p>Contains the response to a successful <a>CreatePolicy</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreatePolicyResponse {
    /// <p>A structure containing details about the new policy.</p>
    pub policy: Option<Policy>,
}

#[allow(dead_code)]
struct CreatePolicyResponseDeserializer;
impl CreatePolicyResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreatePolicyResponse, XmlParseError> {
        deserialize_elements::<_, CreatePolicyResponse, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Policy" => {
                    obj.policy = Some(PolicyDeserializer::deserialize("Policy", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreatePolicyVersionRequest {
    /// <p>The Amazon Resource Name (ARN) of the IAM policy to which you want to add a new version.</p> <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub policy_arn: String,
    /// <p><p>The JSON policy document that you want to use as the content for this new version of the policy.</p> <p>You must provide policies in JSON format in IAM. However, for AWS CloudFormation templates formatted in YAML, you can provide the policy in JSON or YAML format. AWS CloudFormation always converts a YAML policy to JSON format before submitting it to IAM.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of characters consisting of the following:</p> <ul> <li> <p>Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p> </li> <li> <p>The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>)</p> </li> <li> <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>)</p> </li> </ul></p>
    pub policy_document: String,
    /// <p>Specifies whether to set this version as the policy's default version.</p> <p>When this parameter is <code>true</code>, the new policy version becomes the operative version. That is, it becomes the version that is in effect for the IAM users, groups, and roles that the policy is attached to.</p> <p>For more information about managed policy versions, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed policies</a> in the <i>IAM User Guide</i>.</p>
    pub set_as_default: Option<bool>,
}

/// Serialize `CreatePolicyVersionRequest` contents to a `SignedRequest`.
struct CreatePolicyVersionRequestSerializer;
impl CreatePolicyVersionRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreatePolicyVersionRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "PolicyArn"), &obj.policy_arn);
        params.put(
            &format!("{}{}", prefix, "PolicyDocument"),
            &obj.policy_document,
        );
        if let Some(ref field_value) = obj.set_as_default {
            params.put(&format!("{}{}", prefix, "SetAsDefault"), &field_value);
        }
    }
}

/// <p>Contains the response to a successful <a>CreatePolicyVersion</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreatePolicyVersionResponse {
    /// <p>A structure containing details about the new policy version.</p>
    pub policy_version: Option<PolicyVersion>,
}

#[allow(dead_code)]
struct CreatePolicyVersionResponseDeserializer;
impl CreatePolicyVersionResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreatePolicyVersionResponse, XmlParseError> {
        deserialize_elements::<_, CreatePolicyVersionResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "PolicyVersion" => {
                        obj.policy_version = Some(PolicyVersionDeserializer::deserialize(
                            "PolicyVersion",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateRoleRequest {
    /// <p>The trust relationship policy document that grants an entity permission to assume the role.</p> <p>In IAM, you must provide a JSON policy that has been converted to a string. However, for AWS CloudFormation templates formatted in YAML, you can provide the policy in JSON or YAML format. AWS CloudFormation always converts a YAML policy to JSON format before submitting it to IAM.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of characters consisting of the following:</p> <ul> <li> <p>Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p> </li> <li> <p>The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>)</p> </li> <li> <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>)</p> </li> </ul> <p> Upon success, the response includes the same trust policy in JSON format.</p>
    pub assume_role_policy_document: String,
    /// <p>A description of the role.</p>
    pub description: Option<String>,
    /// <p>The maximum session duration (in seconds) that you want to set for the specified role. If you do not specify a value for this setting, the default maximum of one hour is applied. This setting can have a value from 1 hour to 12 hours.</p> <p>Anyone who assumes the role from the AWS CLI or API can use the <code>DurationSeconds</code> API parameter or the <code>duration-seconds</code> CLI parameter to request a longer session. The <code>MaxSessionDuration</code> setting determines the maximum duration that can be requested using the <code>DurationSeconds</code> parameter. If users don't specify a value for the <code>DurationSeconds</code> parameter, their security credentials are valid for one hour by default. This applies when you use the <code>AssumeRole*</code> API operations or the <code>assume-role*</code> CLI operations but does not apply when you use those operations to create a console URL. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html">Using IAM roles</a> in the <i>IAM User Guide</i>.</p>
    pub max_session_duration: Option<i64>,
    /// <p> The path to the role. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the <i>IAM User Guide</i>.</p> <p>This parameter is optional. If it is not included, it defaults to a slash (/).</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes. In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including most punctuation characters, digits, and upper and lowercased letters.</p>
    pub path: Option<String>,
    /// <p>The ARN of the policy that is used to set the permissions boundary for the role.</p>
    pub permissions_boundary: Option<String>,
    /// <p>The name of the role to create.</p> <p>IAM user, group, role, and policy names must be unique within the account. Names are not distinguished by case. For example, you cannot create resources named both "MyResource" and "myresource".</p>
    pub role_name: String,
    /// <p><p>A list of tags that you want to attach to the new role. Each tag consists of a key name and an associated value. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User Guide</i>.</p> <note> <p>If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request fails and the resource is not created.</p> </note></p>
    pub tags: Option<Vec<Tag>>,
}

/// Serialize `CreateRoleRequest` contents to a `SignedRequest`.
struct CreateRoleRequestSerializer;
impl CreateRoleRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateRoleRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "AssumeRolePolicyDocument"),
            &obj.assume_role_policy_document,
        );
        if let Some(ref field_value) = obj.description {
            params.put(&format!("{}{}", prefix, "Description"), &field_value);
        }
        if let Some(ref field_value) = obj.max_session_duration {
            params.put(&format!("{}{}", prefix, "MaxSessionDuration"), &field_value);
        }
        if let Some(ref field_value) = obj.path {
            params.put(&format!("{}{}", prefix, "Path"), &field_value);
        }
        if let Some(ref field_value) = obj.permissions_boundary {
            params.put(
                &format!("{}{}", prefix, "PermissionsBoundary"),
                &field_value,
            );
        }
        params.put(&format!("{}{}", prefix, "RoleName"), &obj.role_name);
        if let Some(ref field_value) = obj.tags {
            TagListTypeSerializer::serialize(params, &format!("{}{}", prefix, "Tags"), field_value);
        }
    }
}

/// <p>Contains the response to a successful <a>CreateRole</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateRoleResponse {
    /// <p>A structure containing details about the new role.</p>
    pub role: Role,
}

#[allow(dead_code)]
struct CreateRoleResponseDeserializer;
impl CreateRoleResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateRoleResponse, XmlParseError> {
        deserialize_elements::<_, CreateRoleResponse, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Role" => {
                    obj.role = RoleDeserializer::deserialize("Role", stack)?;
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateSAMLProviderRequest {
    /// <p>The name of the provider to create.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub name: String,
    /// <p>An XML document generated by an identity provider (IdP) that supports SAML 2.0. The document includes the issuer's name, expiration information, and keys that can be used to validate the SAML authentication response (assertions) that are received from the IdP. You must generate the metadata document using the identity management software that is used as your organization's IdP.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html">About SAML 2.0-based federation</a> in the <i>IAM User Guide</i> </p>
    pub saml_metadata_document: String,
    /// <p><p>A list of tags that you want to attach to the new IAM SAML provider. Each tag consists of a key name and an associated value. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User Guide</i>.</p> <note> <p>If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request fails and the resource is not created.</p> </note></p>
    pub tags: Option<Vec<Tag>>,
}

/// Serialize `CreateSAMLProviderRequest` contents to a `SignedRequest`.
struct CreateSAMLProviderRequestSerializer;
impl CreateSAMLProviderRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateSAMLProviderRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "Name"), &obj.name);
        params.put(
            &format!("{}{}", prefix, "SAMLMetadataDocument"),
            &obj.saml_metadata_document,
        );
        if let Some(ref field_value) = obj.tags {
            TagListTypeSerializer::serialize(params, &format!("{}{}", prefix, "Tags"), field_value);
        }
    }
}

/// <p>Contains the response to a successful <a>CreateSAMLProvider</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateSAMLProviderResponse {
    /// <p>The Amazon Resource Name (ARN) of the new SAML provider resource in IAM.</p>
    pub saml_provider_arn: Option<String>,
    /// <p>A list of tags that are attached to the new IAM SAML provider. The returned list of tags is sorted by tag key. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User Guide</i>.</p>
    pub tags: Option<Vec<Tag>>,
}

#[allow(dead_code)]
struct CreateSAMLProviderResponseDeserializer;
impl CreateSAMLProviderResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateSAMLProviderResponse, XmlParseError> {
        deserialize_elements::<_, CreateSAMLProviderResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "SAMLProviderArn" => {
                        obj.saml_provider_arn =
                            Some(ArnTypeDeserializer::deserialize("SAMLProviderArn", stack)?);
                    }
                    "Tags" => {
                        obj.tags
                            .get_or_insert(vec![])
                            .extend(TagListTypeDeserializer::deserialize("Tags", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateServiceLinkedRoleRequest {
    /// <p>The service principal for the AWS service to which this role is attached. You use a string similar to a URL but without the http:// in front. For example: <code>elasticbeanstalk.amazonaws.com</code>. </p> <p>Service principals are unique and case-sensitive. To find the exact service principal for your service-linked role, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-services-that-work-with-iam.html">AWS services that work with IAM</a> in the <i>IAM User Guide</i>. Look for the services that have <b>Yes </b>in the <b>Service-Linked Role</b> column. Choose the <b>Yes</b> link to view the service-linked role documentation for that service.</p>
    pub aws_service_name: String,
    /// <p><p/> <p>A string that you provide, which is combined with the service-provided prefix to form the complete role name. If you make multiple requests for the same service, then you must supply a different <code>CustomSuffix</code> for each request. Otherwise the request fails with a duplicate role name error. For example, you could add <code>-1</code> or <code>-debug</code> to the suffix.</p> <p>Some services do not support the <code>CustomSuffix</code> parameter. If you provide an optional suffix and the operation fails, try the operation again without the suffix.</p></p>
    pub custom_suffix: Option<String>,
    /// <p>The description of the role.</p>
    pub description: Option<String>,
}

/// Serialize `CreateServiceLinkedRoleRequest` contents to a `SignedRequest`.
struct CreateServiceLinkedRoleRequestSerializer;
impl CreateServiceLinkedRoleRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateServiceLinkedRoleRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "AWSServiceName"),
            &obj.aws_service_name,
        );
        if let Some(ref field_value) = obj.custom_suffix {
            params.put(&format!("{}{}", prefix, "CustomSuffix"), &field_value);
        }
        if let Some(ref field_value) = obj.description {
            params.put(&format!("{}{}", prefix, "Description"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateServiceLinkedRoleResponse {
    /// <p>A <a>Role</a> object that contains details about the newly created role.</p>
    pub role: Option<Role>,
}

#[allow(dead_code)]
struct CreateServiceLinkedRoleResponseDeserializer;
impl CreateServiceLinkedRoleResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateServiceLinkedRoleResponse, XmlParseError> {
        deserialize_elements::<_, CreateServiceLinkedRoleResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Role" => {
                        obj.role = Some(RoleDeserializer::deserialize("Role", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateServiceSpecificCredentialRequest {
    /// <p>The name of the AWS service that is to be associated with the credentials. The service you specify here is the only service that can be accessed using these credentials.</p>
    pub service_name: String,
    /// <p>The name of the IAM user that is to be associated with the credentials. The new service-specific credentials have the same permissions as the associated user except that they can be used only to access the specified service.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub user_name: String,
}

/// Serialize `CreateServiceSpecificCredentialRequest` contents to a `SignedRequest`.
struct CreateServiceSpecificCredentialRequestSerializer;
impl CreateServiceSpecificCredentialRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateServiceSpecificCredentialRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "ServiceName"), &obj.service_name);
        params.put(&format!("{}{}", prefix, "UserName"), &obj.user_name);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateServiceSpecificCredentialResponse {
    /// <p><p>A structure that contains information about the newly created service-specific credential.</p> <important> <p>This is the only time that the password for this credential set is available. It cannot be recovered later. Instead, you must reset the password with <a>ResetServiceSpecificCredential</a>.</p> </important></p>
    pub service_specific_credential: Option<ServiceSpecificCredential>,
}

#[allow(dead_code)]
struct CreateServiceSpecificCredentialResponseDeserializer;
impl CreateServiceSpecificCredentialResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateServiceSpecificCredentialResponse, XmlParseError> {
        deserialize_elements::<_, CreateServiceSpecificCredentialResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "ServiceSpecificCredential" => {
                        obj.service_specific_credential =
                            Some(ServiceSpecificCredentialDeserializer::deserialize(
                                "ServiceSpecificCredential",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateUserRequest {
    /// <p> The path for the user name. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the <i>IAM User Guide</i>.</p> <p>This parameter is optional. If it is not included, it defaults to a slash (/).</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes. In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including most punctuation characters, digits, and upper and lowercased letters.</p>
    pub path: Option<String>,
    /// <p>The ARN of the policy that is used to set the permissions boundary for the user.</p>
    pub permissions_boundary: Option<String>,
    /// <p><p>A list of tags that you want to attach to the new user. Each tag consists of a key name and an associated value. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User Guide</i>.</p> <note> <p>If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request fails and the resource is not created.</p> </note></p>
    pub tags: Option<Vec<Tag>>,
    /// <p>The name of the user to create.</p> <p>IAM user, group, role, and policy names must be unique within the account. Names are not distinguished by case. For example, you cannot create resources named both "MyResource" and "myresource".</p>
    pub user_name: String,
}

/// Serialize `CreateUserRequest` contents to a `SignedRequest`.
struct CreateUserRequestSerializer;
impl CreateUserRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateUserRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.path {
            params.put(&format!("{}{}", prefix, "Path"), &field_value);
        }
        if let Some(ref field_value) = obj.permissions_boundary {
            params.put(
                &format!("{}{}", prefix, "PermissionsBoundary"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.tags {
            TagListTypeSerializer::serialize(params, &format!("{}{}", prefix, "Tags"), field_value);
        }
        params.put(&format!("{}{}", prefix, "UserName"), &obj.user_name);
    }
}

/// <p>Contains the response to a successful <a>CreateUser</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateUserResponse {
    /// <p>A structure with details about the new IAM user.</p>
    pub user: Option<User>,
}

#[allow(dead_code)]
struct CreateUserResponseDeserializer;
impl CreateUserResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateUserResponse, XmlParseError> {
        deserialize_elements::<_, CreateUserResponse, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "User" => {
                    obj.user = Some(UserDeserializer::deserialize("User", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateVirtualMFADeviceRequest {
    /// <p> The path for the virtual MFA device. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the <i>IAM User Guide</i>.</p> <p>This parameter is optional. If it is not included, it defaults to a slash (/).</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes. In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including most punctuation characters, digits, and upper and lowercased letters.</p>
    pub path: Option<String>,
    /// <p><p>A list of tags that you want to attach to the new IAM virtual MFA device. Each tag consists of a key name and an associated value. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User Guide</i>.</p> <note> <p>If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request fails and the resource is not created.</p> </note></p>
    pub tags: Option<Vec<Tag>>,
    /// <p>The name of the virtual MFA device. Use with path to uniquely identify a virtual MFA device.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub virtual_mfa_device_name: String,
}

/// Serialize `CreateVirtualMFADeviceRequest` contents to a `SignedRequest`.
struct CreateVirtualMFADeviceRequestSerializer;
impl CreateVirtualMFADeviceRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateVirtualMFADeviceRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.path {
            params.put(&format!("{}{}", prefix, "Path"), &field_value);
        }
        if let Some(ref field_value) = obj.tags {
            TagListTypeSerializer::serialize(params, &format!("{}{}", prefix, "Tags"), field_value);
        }
        params.put(
            &format!("{}{}", prefix, "VirtualMFADeviceName"),
            &obj.virtual_mfa_device_name,
        );
    }
}

/// <p>Contains the response to a successful <a>CreateVirtualMFADevice</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateVirtualMFADeviceResponse {
    /// <p>A structure containing details about the new virtual MFA device.</p>
    pub virtual_mfa_device: VirtualMFADevice,
}

#[allow(dead_code)]
struct CreateVirtualMFADeviceResponseDeserializer;
impl CreateVirtualMFADeviceResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateVirtualMFADeviceResponse, XmlParseError> {
        deserialize_elements::<_, CreateVirtualMFADeviceResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "VirtualMFADevice" => {
                        obj.virtual_mfa_device =
                            VirtualMFADeviceDeserializer::deserialize("VirtualMFADevice", stack)?;
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct DateTypeDeserializer;
impl DateTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeactivateMFADeviceRequest {
    /// <p>The serial number that uniquely identifies the MFA device. For virtual MFA devices, the serial number is the device ARN.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@:/-</p>
    pub serial_number: String,
    /// <p>The name of the user whose MFA device you want to deactivate.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub user_name: String,
}

/// Serialize `DeactivateMFADeviceRequest` contents to a `SignedRequest`.
struct DeactivateMFADeviceRequestSerializer;
impl DeactivateMFADeviceRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeactivateMFADeviceRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "SerialNumber"), &obj.serial_number);
        params.put(&format!("{}{}", prefix, "UserName"), &obj.user_name);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteAccessKeyRequest {
    /// <p>The access key ID for the access key ID and secret access key you want to delete.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that can consist of any upper or lowercased letter or digit.</p>
    pub access_key_id: String,
    /// <p>The name of the user whose access key pair you want to delete.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub user_name: Option<String>,
}

/// Serialize `DeleteAccessKeyRequest` contents to a `SignedRequest`.
struct DeleteAccessKeyRequestSerializer;
impl DeleteAccessKeyRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteAccessKeyRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "AccessKeyId"), &obj.access_key_id);
        if let Some(ref field_value) = obj.user_name {
            params.put(&format!("{}{}", prefix, "UserName"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteAccountAliasRequest {
    /// <p>The name of the account alias to delete.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of lowercase letters, digits, and dashes. You cannot start or finish with a dash, nor can you have two dashes in a row.</p>
    pub account_alias: String,
}

/// Serialize `DeleteAccountAliasRequest` contents to a `SignedRequest`.
struct DeleteAccountAliasRequestSerializer;
impl DeleteAccountAliasRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteAccountAliasRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "AccountAlias"), &obj.account_alias);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteGroupPolicyRequest {
    /// <p>The name (friendly name, not ARN) identifying the group that the policy is embedded in.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub group_name: String,
    /// <p>The name identifying the policy document to delete.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub policy_name: String,
}

/// Serialize `DeleteGroupPolicyRequest` contents to a `SignedRequest`.
struct DeleteGroupPolicyRequestSerializer;
impl DeleteGroupPolicyRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteGroupPolicyRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "GroupName"), &obj.group_name);
        params.put(&format!("{}{}", prefix, "PolicyName"), &obj.policy_name);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteGroupRequest {
    /// <p>The name of the IAM group to delete.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub group_name: String,
}

/// Serialize `DeleteGroupRequest` contents to a `SignedRequest`.
struct DeleteGroupRequestSerializer;
impl DeleteGroupRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteGroupRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "GroupName"), &obj.group_name);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteInstanceProfileRequest {
    /// <p>The name of the instance profile to delete.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub instance_profile_name: String,
}

/// Serialize `DeleteInstanceProfileRequest` contents to a `SignedRequest`.
struct DeleteInstanceProfileRequestSerializer;
impl DeleteInstanceProfileRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteInstanceProfileRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "InstanceProfileName"),
            &obj.instance_profile_name,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteLoginProfileRequest {
    /// <p>The name of the user whose password you want to delete.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub user_name: String,
}

/// Serialize `DeleteLoginProfileRequest` contents to a `SignedRequest`.
struct DeleteLoginProfileRequestSerializer;
impl DeleteLoginProfileRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteLoginProfileRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "UserName"), &obj.user_name);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteOpenIDConnectProviderRequest {
    /// <p>The Amazon Resource Name (ARN) of the IAM OpenID Connect provider resource object to delete. You can get a list of OpenID Connect provider resource ARNs by using the <a>ListOpenIDConnectProviders</a> operation.</p>
    pub open_id_connect_provider_arn: String,
}

/// Serialize `DeleteOpenIDConnectProviderRequest` contents to a `SignedRequest`.
struct DeleteOpenIDConnectProviderRequestSerializer;
impl DeleteOpenIDConnectProviderRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteOpenIDConnectProviderRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "OpenIDConnectProviderArn"),
            &obj.open_id_connect_provider_arn,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeletePolicyRequest {
    /// <p>The Amazon Resource Name (ARN) of the IAM policy you want to delete.</p> <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub policy_arn: String,
}

/// Serialize `DeletePolicyRequest` contents to a `SignedRequest`.
struct DeletePolicyRequestSerializer;
impl DeletePolicyRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeletePolicyRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "PolicyArn"), &obj.policy_arn);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeletePolicyVersionRequest {
    /// <p>The Amazon Resource Name (ARN) of the IAM policy from which you want to delete a version.</p> <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub policy_arn: String,
    /// <p>The policy version to delete.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that consists of the lowercase letter 'v' followed by one or two digits, and optionally followed by a period '.' and a string of letters and digits.</p> <p>For more information about managed policy versions, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed policies</a> in the <i>IAM User Guide</i>.</p>
    pub version_id: String,
}

/// Serialize `DeletePolicyVersionRequest` contents to a `SignedRequest`.
struct DeletePolicyVersionRequestSerializer;
impl DeletePolicyVersionRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeletePolicyVersionRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "PolicyArn"), &obj.policy_arn);
        params.put(&format!("{}{}", prefix, "VersionId"), &obj.version_id);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteRolePermissionsBoundaryRequest {
    /// <p>The name (friendly name, not ARN) of the IAM role from which you want to remove the permissions boundary.</p>
    pub role_name: String,
}

/// Serialize `DeleteRolePermissionsBoundaryRequest` contents to a `SignedRequest`.
struct DeleteRolePermissionsBoundaryRequestSerializer;
impl DeleteRolePermissionsBoundaryRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteRolePermissionsBoundaryRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "RoleName"), &obj.role_name);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteRolePolicyRequest {
    /// <p>The name of the inline policy to delete from the specified IAM role.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub policy_name: String,
    /// <p>The name (friendly name, not ARN) identifying the role that the policy is embedded in.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub role_name: String,
}

/// Serialize `DeleteRolePolicyRequest` contents to a `SignedRequest`.
struct DeleteRolePolicyRequestSerializer;
impl DeleteRolePolicyRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteRolePolicyRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "PolicyName"), &obj.policy_name);
        params.put(&format!("{}{}", prefix, "RoleName"), &obj.role_name);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteRoleRequest {
    /// <p>The name of the role to delete.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub role_name: String,
}

/// Serialize `DeleteRoleRequest` contents to a `SignedRequest`.
struct DeleteRoleRequestSerializer;
impl DeleteRoleRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteRoleRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "RoleName"), &obj.role_name);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteSAMLProviderRequest {
    /// <p>The Amazon Resource Name (ARN) of the SAML provider to delete.</p>
    pub saml_provider_arn: String,
}

/// Serialize `DeleteSAMLProviderRequest` contents to a `SignedRequest`.
struct DeleteSAMLProviderRequestSerializer;
impl DeleteSAMLProviderRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteSAMLProviderRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "SAMLProviderArn"),
            &obj.saml_provider_arn,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteSSHPublicKeyRequest {
    /// <p>The unique identifier for the SSH public key.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that can consist of any upper or lowercased letter or digit.</p>
    pub ssh_public_key_id: String,
    /// <p>The name of the IAM user associated with the SSH public key.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub user_name: String,
}

/// Serialize `DeleteSSHPublicKeyRequest` contents to a `SignedRequest`.
struct DeleteSSHPublicKeyRequestSerializer;
impl DeleteSSHPublicKeyRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteSSHPublicKeyRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "SSHPublicKeyId"),
            &obj.ssh_public_key_id,
        );
        params.put(&format!("{}{}", prefix, "UserName"), &obj.user_name);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteServerCertificateRequest {
    /// <p>The name of the server certificate you want to delete.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub server_certificate_name: String,
}

/// Serialize `DeleteServerCertificateRequest` contents to a `SignedRequest`.
struct DeleteServerCertificateRequestSerializer;
impl DeleteServerCertificateRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteServerCertificateRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "ServerCertificateName"),
            &obj.server_certificate_name,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteServiceLinkedRoleRequest {
    /// <p>The name of the service-linked role to be deleted.</p>
    pub role_name: String,
}

/// Serialize `DeleteServiceLinkedRoleRequest` contents to a `SignedRequest`.
struct DeleteServiceLinkedRoleRequestSerializer;
impl DeleteServiceLinkedRoleRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteServiceLinkedRoleRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "RoleName"), &obj.role_name);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeleteServiceLinkedRoleResponse {
    /// <p>The deletion task identifier that you can use to check the status of the deletion. This identifier is returned in the format <code>task/aws-service-role/&lt;service-principal-name&gt;/&lt;role-name&gt;/&lt;task-uuid&gt;</code>.</p>
    pub deletion_task_id: String,
}

#[allow(dead_code)]
struct DeleteServiceLinkedRoleResponseDeserializer;
impl DeleteServiceLinkedRoleResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeleteServiceLinkedRoleResponse, XmlParseError> {
        deserialize_elements::<_, DeleteServiceLinkedRoleResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DeletionTaskId" => {
                        obj.deletion_task_id =
                            DeletionTaskIdTypeDeserializer::deserialize("DeletionTaskId", stack)?;
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteServiceSpecificCredentialRequest {
    /// <p>The unique identifier of the service-specific credential. You can get this value by calling <a>ListServiceSpecificCredentials</a>.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that can consist of any upper or lowercased letter or digit.</p>
    pub service_specific_credential_id: String,
    /// <p>The name of the IAM user associated with the service-specific credential. If this value is not specified, then the operation assumes the user whose credentials are used to call the operation.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub user_name: Option<String>,
}

/// Serialize `DeleteServiceSpecificCredentialRequest` contents to a `SignedRequest`.
struct DeleteServiceSpecificCredentialRequestSerializer;
impl DeleteServiceSpecificCredentialRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteServiceSpecificCredentialRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "ServiceSpecificCredentialId"),
            &obj.service_specific_credential_id,
        );
        if let Some(ref field_value) = obj.user_name {
            params.put(&format!("{}{}", prefix, "UserName"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteSigningCertificateRequest {
    /// <p>The ID of the signing certificate to delete.</p> <p>The format of this parameter, as described by its <a href="http://wikipedia.org/wiki/regex">regex</a> pattern, is a string of characters that can be upper- or lower-cased letters or digits.</p>
    pub certificate_id: String,
    /// <p>The name of the user the signing certificate belongs to.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub user_name: Option<String>,
}

/// Serialize `DeleteSigningCertificateRequest` contents to a `SignedRequest`.
struct DeleteSigningCertificateRequestSerializer;
impl DeleteSigningCertificateRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteSigningCertificateRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "CertificateId"),
            &obj.certificate_id,
        );
        if let Some(ref field_value) = obj.user_name {
            params.put(&format!("{}{}", prefix, "UserName"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteUserPermissionsBoundaryRequest {
    /// <p>The name (friendly name, not ARN) of the IAM user from which you want to remove the permissions boundary.</p>
    pub user_name: String,
}

/// Serialize `DeleteUserPermissionsBoundaryRequest` contents to a `SignedRequest`.
struct DeleteUserPermissionsBoundaryRequestSerializer;
impl DeleteUserPermissionsBoundaryRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteUserPermissionsBoundaryRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "UserName"), &obj.user_name);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteUserPolicyRequest {
    /// <p>The name identifying the policy document to delete.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub policy_name: String,
    /// <p>The name (friendly name, not ARN) identifying the user that the policy is embedded in.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub user_name: String,
}

/// Serialize `DeleteUserPolicyRequest` contents to a `SignedRequest`.
struct DeleteUserPolicyRequestSerializer;
impl DeleteUserPolicyRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteUserPolicyRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "PolicyName"), &obj.policy_name);
        params.put(&format!("{}{}", prefix, "UserName"), &obj.user_name);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteUserRequest {
    /// <p>The name of the user to delete.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub user_name: String,
}

/// Serialize `DeleteUserRequest` contents to a `SignedRequest`.
struct DeleteUserRequestSerializer;
impl DeleteUserRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteUserRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "UserName"), &obj.user_name);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteVirtualMFADeviceRequest {
    /// <p>The serial number that uniquely identifies the MFA device. For virtual MFA devices, the serial number is the same as the ARN.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@:/-</p>
    pub serial_number: String,
}

/// Serialize `DeleteVirtualMFADeviceRequest` contents to a `SignedRequest`.
struct DeleteVirtualMFADeviceRequestSerializer;
impl DeleteVirtualMFADeviceRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteVirtualMFADeviceRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "SerialNumber"), &obj.serial_number);
    }
}

/// <p>The reason that the service-linked role deletion failed.</p> <p>This data type is used as a response element in the <a>GetServiceLinkedRoleDeletionStatus</a> operation.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeletionTaskFailureReasonType {
    /// <p>A short description of the reason that the service-linked role deletion failed.</p>
    pub reason: Option<String>,
    /// <p>A list of objects that contains details about the service-linked role deletion failure, if that information is returned by the service. If the service-linked role has active sessions or if any resources that were used by the role have not been deleted from the linked service, the role can't be deleted. This parameter includes a list of the resources that are associated with the role and the Region in which the resources are being used.</p>
    pub role_usage_list: Option<Vec<RoleUsageType>>,
}

#[allow(dead_code)]
struct DeletionTaskFailureReasonTypeDeserializer;
impl DeletionTaskFailureReasonTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeletionTaskFailureReasonType, XmlParseError> {
        deserialize_elements::<_, DeletionTaskFailureReasonType, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Reason" => {
                        obj.reason = Some(ReasonTypeDeserializer::deserialize("Reason", stack)?);
                    }
                    "RoleUsageList" => {
                        obj.role_usage_list.get_or_insert(vec![]).extend(
                            RoleUsageListTypeDeserializer::deserialize("RoleUsageList", stack)?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct DeletionTaskIdTypeDeserializer;
impl DeletionTaskIdTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct DeletionTaskStatusTypeDeserializer;
impl DeletionTaskStatusTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DetachGroupPolicyRequest {
    /// <p>The name (friendly name, not ARN) of the IAM group to detach the policy from.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub group_name: String,
    /// <p>The Amazon Resource Name (ARN) of the IAM policy you want to detach.</p> <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub policy_arn: String,
}

/// Serialize `DetachGroupPolicyRequest` contents to a `SignedRequest`.
struct DetachGroupPolicyRequestSerializer;
impl DetachGroupPolicyRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DetachGroupPolicyRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "GroupName"), &obj.group_name);
        params.put(&format!("{}{}", prefix, "PolicyArn"), &obj.policy_arn);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DetachRolePolicyRequest {
    /// <p>The Amazon Resource Name (ARN) of the IAM policy you want to detach.</p> <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub policy_arn: String,
    /// <p>The name (friendly name, not ARN) of the IAM role to detach the policy from.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub role_name: String,
}

/// Serialize `DetachRolePolicyRequest` contents to a `SignedRequest`.
struct DetachRolePolicyRequestSerializer;
impl DetachRolePolicyRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DetachRolePolicyRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "PolicyArn"), &obj.policy_arn);
        params.put(&format!("{}{}", prefix, "RoleName"), &obj.role_name);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DetachUserPolicyRequest {
    /// <p>The Amazon Resource Name (ARN) of the IAM policy you want to detach.</p> <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub policy_arn: String,
    /// <p>The name (friendly name, not ARN) of the IAM user to detach the policy from.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub user_name: String,
}

/// Serialize `DetachUserPolicyRequest` contents to a `SignedRequest`.
struct DetachUserPolicyRequestSerializer;
impl DetachUserPolicyRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DetachUserPolicyRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "PolicyArn"), &obj.policy_arn);
        params.put(&format!("{}{}", prefix, "UserName"), &obj.user_name);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct EnableMFADeviceRequest {
    /// <p><p>An authentication code emitted by the device. </p> <p>The format for this parameter is a string of six digits.</p> <important> <p>Submit your request immediately after generating the authentication codes. If you generate the codes and then wait too long to submit the request, the MFA device successfully associates with the user but the MFA device becomes out of sync. This happens because time-based one-time passwords (TOTP) expire after a short period of time. If this happens, you can <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_mfa_sync.html">resync the device</a>.</p> </important></p>
    pub authentication_code_1: String,
    /// <p><p>A subsequent authentication code emitted by the device.</p> <p>The format for this parameter is a string of six digits.</p> <important> <p>Submit your request immediately after generating the authentication codes. If you generate the codes and then wait too long to submit the request, the MFA device successfully associates with the user but the MFA device becomes out of sync. This happens because time-based one-time passwords (TOTP) expire after a short period of time. If this happens, you can <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_mfa_sync.html">resync the device</a>.</p> </important></p>
    pub authentication_code_2: String,
    /// <p>The serial number that uniquely identifies the MFA device. For virtual MFA devices, the serial number is the device ARN.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@:/-</p>
    pub serial_number: String,
    /// <p>The name of the IAM user for whom you want to enable the MFA device.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub user_name: String,
}

/// Serialize `EnableMFADeviceRequest` contents to a `SignedRequest`.
struct EnableMFADeviceRequestSerializer;
impl EnableMFADeviceRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &EnableMFADeviceRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "AuthenticationCode1"),
            &obj.authentication_code_1,
        );
        params.put(
            &format!("{}{}", prefix, "AuthenticationCode2"),
            &obj.authentication_code_2,
        );
        params.put(&format!("{}{}", prefix, "SerialNumber"), &obj.serial_number);
        params.put(&format!("{}{}", prefix, "UserName"), &obj.user_name);
    }
}

/// <p>An object that contains details about when the IAM entities (users or roles) were last used in an attempt to access the specified AWS service.</p> <p>This data type is a response element in the <a>GetServiceLastAccessedDetailsWithEntities</a> operation.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct EntityDetails {
    /// <p>The <code>EntityInfo</code> object that contains details about the entity (user or role).</p>
    pub entity_info: EntityInfo,
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the authenticated entity last attempted to access AWS. AWS does not report unauthenticated requests.</p> <p>This field is null if no IAM entities attempted to access the service within the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>.</p>
    pub last_authenticated: Option<String>,
}

#[allow(dead_code)]
struct EntityDetailsDeserializer;
impl EntityDetailsDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<EntityDetails, XmlParseError> {
        deserialize_elements::<_, EntityDetails, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "EntityInfo" => {
                    obj.entity_info = EntityInfoDeserializer::deserialize("EntityInfo", stack)?;
                }
                "LastAuthenticated" => {
                    obj.last_authenticated = Some(DateTypeDeserializer::deserialize(
                        "LastAuthenticated",
                        stack,
                    )?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct EntityDetailsListTypeDeserializer;
impl EntityDetailsListTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<EntityDetails>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(EntityDetailsDeserializer::deserialize("member", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Contains details about the specified entity (user or role).</p> <p>This data type is an element of the <a>EntityDetails</a> object.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct EntityInfo {
    pub arn: String,
    /// <p>The identifier of the entity (user or role).</p>
    pub id: String,
    /// <p>The name of the entity (user or role).</p>
    pub name: String,
    /// <p>The path to the entity (user or role). For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the <i>IAM User Guide</i>. </p>
    pub path: Option<String>,
    /// <p>The type of entity (user or role).</p>
    pub type_: String,
}

#[allow(dead_code)]
struct EntityInfoDeserializer;
impl EntityInfoDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<EntityInfo, XmlParseError> {
        deserialize_elements::<_, EntityInfo, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Arn" => {
                    obj.arn = ArnTypeDeserializer::deserialize("Arn", stack)?;
                }
                "Id" => {
                    obj.id = IdTypeDeserializer::deserialize("Id", stack)?;
                }
                "Name" => {
                    obj.name = UserNameTypeDeserializer::deserialize("Name", stack)?;
                }
                "Path" => {
                    obj.path = Some(PathTypeDeserializer::deserialize("Path", stack)?);
                }
                "Type" => {
                    obj.type_ = PolicyOwnerEntityTypeDeserializer::deserialize("Type", stack)?;
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}

/// Serialize `EntityListType` contents to a `SignedRequest`.
struct EntityListTypeSerializer;
impl EntityListTypeSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<String>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.member.{}", name, index + 1);
            params.put(&key, &obj);
        }
    }
}

#[allow(dead_code)]
struct EntityNameTypeDeserializer;
impl EntityNameTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p>Contains information about the reason that the operation failed.</p> <p>This data type is used as a response element in the <a>GetOrganizationsAccessReport</a>, <a>GetServiceLastAccessedDetails</a>, and <a>GetServiceLastAccessedDetailsWithEntities</a> operations.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ErrorDetails {
    /// <p>The error code associated with the operation failure.</p>
    pub code: String,
    /// <p>Detailed information about the reason that the operation failed.</p>
    pub message: String,
}

#[allow(dead_code)]
struct ErrorDetailsDeserializer;
impl ErrorDetailsDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ErrorDetails, XmlParseError> {
        deserialize_elements::<_, ErrorDetails, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Code" => {
                    obj.code = StringTypeDeserializer::deserialize("Code", stack)?;
                }
                "Message" => {
                    obj.message = StringTypeDeserializer::deserialize("Message", stack)?;
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct EvalDecisionDetailsTypeDeserializer;
impl EvalDecisionDetailsTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<::std::collections::HashMap<String, String>, XmlParseError> {
        xml_util::start_element(tag_name, stack)?;

        let mut obj = ::std::collections::HashMap::new();

        while xml_util::peek_at_name(stack)? == "entry" {
            xml_util::start_element("entry", stack)?;
            let key = EvalDecisionSourceTypeDeserializer::deserialize("key", stack)?;
            let value = PolicyEvaluationDecisionTypeDeserializer::deserialize("value", stack)?;
            obj.insert(key, value);
            xml_util::end_element("entry", stack)?;
        }

        xml_util::end_element(tag_name, stack)?;
        Ok(obj)
    }
}
#[allow(dead_code)]
struct EvalDecisionSourceTypeDeserializer;
impl EvalDecisionSourceTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p>Contains the results of a simulation.</p> <p>This data type is used by the return parameter of <code> <a>SimulateCustomPolicy</a> </code> and <code> <a>SimulatePrincipalPolicy</a> </code>.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct EvaluationResult {
    /// <p>The name of the API operation tested on the indicated resource.</p>
    pub eval_action_name: String,
    /// <p>The result of the simulation.</p>
    pub eval_decision: String,
    /// <p>Additional details about the results of the cross-account evaluation decision. This parameter is populated for only cross-account simulations. It contains a brief summary of how each policy type contributes to the final evaluation decision.</p> <p>If the simulation evaluates policies within the same account and includes a resource ARN, then the parameter is present but the response is empty. If the simulation evaluates policies within the same account and specifies all resources (<code>*</code>), then the parameter is not returned.</p> <p>When you make a cross-account request, AWS evaluates the request in the trusting account and the trusted account. The request is allowed only if both evaluations return <code>true</code>. For more information about how policies are evaluated, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics">Evaluating policies within a single account</a>.</p> <p>If an AWS Organizations SCP included in the evaluation denies access, the simulation ends. In this case, policy evaluation does not proceed any further and this parameter is not returned.</p>
    pub eval_decision_details: Option<::std::collections::HashMap<String, String>>,
    /// <p>The ARN of the resource that the indicated API operation was tested on.</p>
    pub eval_resource_name: Option<String>,
    /// <p>A list of the statements in the input policies that determine the result for this scenario. Remember that even if multiple statements allow the operation on the resource, if only one statement denies that operation, then the explicit deny overrides any allow. In addition, the deny statement is the only entry included in the result.</p>
    pub matched_statements: Option<Vec<Statement>>,
    /// <p>A list of context keys that are required by the included input policies but that were not provided by one of the input parameters. This list is used when the resource in a simulation is "*", either explicitly, or when the <code>ResourceArns</code> parameter blank. If you include a list of resources, then any missing context values are instead included under the <code>ResourceSpecificResults</code> section. To discover the context keys used by a set of policies, you can call <a>GetContextKeysForCustomPolicy</a> or <a>GetContextKeysForPrincipalPolicy</a>.</p>
    pub missing_context_values: Option<Vec<String>>,
    /// <p>A structure that details how Organizations and its service control policies affect the results of the simulation. Only applies if the simulated user's account is part of an organization.</p>
    pub organizations_decision_detail: Option<OrganizationsDecisionDetail>,
    /// <p>Contains information about the effect that a permissions boundary has on a policy simulation when the boundary is applied to an IAM entity.</p>
    pub permissions_boundary_decision_detail: Option<PermissionsBoundaryDecisionDetail>,
    /// <p>The individual results of the simulation of the API operation specified in EvalActionName on each resource.</p>
    pub resource_specific_results: Option<Vec<ResourceSpecificResult>>,
}

#[allow(dead_code)]
struct EvaluationResultDeserializer;
impl EvaluationResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<EvaluationResult, XmlParseError> {
        deserialize_elements::<_, EvaluationResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "EvalActionName" => {
                    obj.eval_action_name =
                        ActionNameTypeDeserializer::deserialize("EvalActionName", stack)?;
                }
                "EvalDecision" => {
                    obj.eval_decision = PolicyEvaluationDecisionTypeDeserializer::deserialize(
                        "EvalDecision",
                        stack,
                    )?;
                }
                "EvalDecisionDetails" => {
                    obj.eval_decision_details =
                        Some(EvalDecisionDetailsTypeDeserializer::deserialize(
                            "EvalDecisionDetails",
                            stack,
                        )?);
                }
                "EvalResourceName" => {
                    obj.eval_resource_name = Some(ResourceNameTypeDeserializer::deserialize(
                        "EvalResourceName",
                        stack,
                    )?);
                }
                "MatchedStatements" => {
                    obj.matched_statements.get_or_insert(vec![]).extend(
                        StatementListTypeDeserializer::deserialize("MatchedStatements", stack)?,
                    );
                }
                "MissingContextValues" => {
                    obj.missing_context_values.get_or_insert(vec![]).extend(
                        ContextKeyNamesResultListTypeDeserializer::deserialize(
                            "MissingContextValues",
                            stack,
                        )?,
                    );
                }
                "OrganizationsDecisionDetail" => {
                    obj.organizations_decision_detail =
                        Some(OrganizationsDecisionDetailDeserializer::deserialize(
                            "OrganizationsDecisionDetail",
                            stack,
                        )?);
                }
                "PermissionsBoundaryDecisionDetail" => {
                    obj.permissions_boundary_decision_detail =
                        Some(PermissionsBoundaryDecisionDetailDeserializer::deserialize(
                            "PermissionsBoundaryDecisionDetail",
                            stack,
                        )?);
                }
                "ResourceSpecificResults" => {
                    obj.resource_specific_results.get_or_insert(vec![]).extend(
                        ResourceSpecificResultListTypeDeserializer::deserialize(
                            "ResourceSpecificResults",
                            stack,
                        )?,
                    );
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct EvaluationResultsListTypeDeserializer;
impl EvaluationResultsListTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<EvaluationResult>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(EvaluationResultDeserializer::deserialize("member", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct ExistingUserNameTypeDeserializer;
impl ExistingUserNameTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p>Contains the response to a successful <a>GenerateCredentialReport</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct GenerateCredentialReportResponse {
    /// <p>Information about the credential report.</p>
    pub description: Option<String>,
    /// <p>Information about the state of the credential report.</p>
    pub state: Option<String>,
}

#[allow(dead_code)]
struct GenerateCredentialReportResponseDeserializer;
impl GenerateCredentialReportResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<GenerateCredentialReportResponse, XmlParseError> {
        deserialize_elements::<_, GenerateCredentialReportResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Description" => {
                        obj.description =
                            Some(ReportStateDescriptionTypeDeserializer::deserialize(
                                "Description",
                                stack,
                            )?);
                    }
                    "State" => {
                        obj.state = Some(ReportStateTypeDeserializer::deserialize("State", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GenerateOrganizationsAccessReportRequest {
    /// <p>The path of the AWS Organizations entity (root, OU, or account). You can build an entity path using the known structure of your organization. For example, assume that your account ID is <code>123456789012</code> and its parent OU ID is <code>ou-rge0-awsabcde</code>. The organization root ID is <code>r-f6g7h8i9j0example</code> and your organization ID is <code>o-a1b2c3d4e5</code>. Your entity path is <code>o-a1b2c3d4e5/r-f6g7h8i9j0example/ou-rge0-awsabcde/123456789012</code>.</p>
    pub entity_path: String,
    /// <p>The identifier of the AWS Organizations service control policy (SCP). This parameter is optional.</p> <p>This ID is used to generate information about when an account principal that is limited by the SCP attempted to access an AWS service.</p>
    pub organizations_policy_id: Option<String>,
}

/// Serialize `GenerateOrganizationsAccessReportRequest` contents to a `SignedRequest`.
struct GenerateOrganizationsAccessReportRequestSerializer;
impl GenerateOrganizationsAccessReportRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &GenerateOrganizationsAccessReportRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "EntityPath"), &obj.entity_path);
        if let Some(ref field_value) = obj.organizations_policy_id {
            params.put(
                &format!("{}{}", prefix, "OrganizationsPolicyId"),
                &field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct GenerateOrganizationsAccessReportResponse {
    /// <p>The job identifier that you can use in the <a>GetOrganizationsAccessReport</a> operation.</p>
    pub job_id: Option<String>,
}

#[allow(dead_code)]
struct GenerateOrganizationsAccessReportResponseDeserializer;
impl GenerateOrganizationsAccessReportResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<GenerateOrganizationsAccessReportResponse, XmlParseError> {
        deserialize_elements::<_, GenerateOrganizationsAccessReportResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "JobId" => {
                        obj.job_id = Some(JobIDTypeDeserializer::deserialize("JobId", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GenerateServiceLastAccessedDetailsRequest {
    /// <p>The ARN of the IAM resource (user, group, role, or managed policy) used to generate information about when the resource was last used in an attempt to access an AWS service.</p>
    pub arn: String,
    /// <p>The level of detail that you want to generate. You can specify whether you want to generate information about the last attempt to access services or actions. If you specify service-level granularity, this operation generates only service data. If you specify action-level granularity, it generates service and action data. If you don't include this optional parameter, the operation generates service data.</p>
    pub granularity: Option<String>,
}

/// Serialize `GenerateServiceLastAccessedDetailsRequest` contents to a `SignedRequest`.
struct GenerateServiceLastAccessedDetailsRequestSerializer;
impl GenerateServiceLastAccessedDetailsRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &GenerateServiceLastAccessedDetailsRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "Arn"), &obj.arn);
        if let Some(ref field_value) = obj.granularity {
            params.put(&format!("{}{}", prefix, "Granularity"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct GenerateServiceLastAccessedDetailsResponse {
    /// <p>The <code>JobId</code> that you can use in the <a>GetServiceLastAccessedDetails</a> or <a>GetServiceLastAccessedDetailsWithEntities</a> operations. The <code>JobId</code> returned by <code>GenerateServiceLastAccessedDetail</code> must be used by the same role within a session, or by the same user when used to call <code>GetServiceLastAccessedDetail</code>.</p>
    pub job_id: Option<String>,
}

#[allow(dead_code)]
struct GenerateServiceLastAccessedDetailsResponseDeserializer;
impl GenerateServiceLastAccessedDetailsResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<GenerateServiceLastAccessedDetailsResponse, XmlParseError> {
        deserialize_elements::<_, GenerateServiceLastAccessedDetailsResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "JobId" => {
                        obj.job_id = Some(JobIDTypeDeserializer::deserialize("JobId", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetAccessKeyLastUsedRequest {
    /// <p>The identifier of an access key.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that can consist of any upper or lowercased letter or digit.</p>
    pub access_key_id: String,
}

/// Serialize `GetAccessKeyLastUsedRequest` contents to a `SignedRequest`.
struct GetAccessKeyLastUsedRequestSerializer;
impl GetAccessKeyLastUsedRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &GetAccessKeyLastUsedRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "AccessKeyId"), &obj.access_key_id);
    }
}

/// <p>Contains the response to a successful <a>GetAccessKeyLastUsed</a> request. It is also returned as a member of the <a>AccessKeyMetaData</a> structure returned by the <a>ListAccessKeys</a> action.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct GetAccessKeyLastUsedResponse {
    /// <p>Contains information about the last time the access key was used.</p>
    pub access_key_last_used: Option<AccessKeyLastUsed>,
    /// <p><p>The name of the AWS IAM user that owns this access key.</p> <p/></p>
    pub user_name: Option<String>,
}

#[allow(dead_code)]
struct GetAccessKeyLastUsedResponseDeserializer;
impl GetAccessKeyLastUsedResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<GetAccessKeyLastUsedResponse, XmlParseError> {
        deserialize_elements::<_, GetAccessKeyLastUsedResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "AccessKeyLastUsed" => {
                        obj.access_key_last_used = Some(
                            AccessKeyLastUsedDeserializer::deserialize("AccessKeyLastUsed", stack)?,
                        );
                    }
                    "UserName" => {
                        obj.user_name = Some(ExistingUserNameTypeDeserializer::deserialize(
                            "UserName", stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetAccountAuthorizationDetailsRequest {
    /// <p>A list of entity types used to filter the results. Only the entities that match the types you specify are included in the output. Use the value <code>LocalManagedPolicy</code> to include customer managed policies.</p> <p>The format for this parameter is a comma-separated (if more than one) list of strings. Each string value in the list must be one of the valid values listed below.</p>
    pub filter: Option<Vec<String>>,
    /// <p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>
    pub marker: Option<String>,
    /// <p>Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>
    pub max_items: Option<i64>,
}

/// Serialize `GetAccountAuthorizationDetailsRequest` contents to a `SignedRequest`.
struct GetAccountAuthorizationDetailsRequestSerializer;
impl GetAccountAuthorizationDetailsRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &GetAccountAuthorizationDetailsRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.filter {
            EntityListTypeSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_items {
            params.put(&format!("{}{}", prefix, "MaxItems"), &field_value);
        }
    }
}

/// <p>Contains the response to a successful <a>GetAccountAuthorizationDetails</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct GetAccountAuthorizationDetailsResponse {
    /// <p>A list containing information about IAM groups.</p>
    pub group_detail_list: Option<Vec<GroupDetail>>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: Option<bool>,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: Option<String>,
    /// <p>A list containing information about managed policies.</p>
    pub policies: Option<Vec<ManagedPolicyDetail>>,
    /// <p>A list containing information about IAM roles.</p>
    pub role_detail_list: Option<Vec<RoleDetail>>,
    /// <p>A list containing information about IAM users.</p>
    pub user_detail_list: Option<Vec<UserDetail>>,
}

#[allow(dead_code)]
struct GetAccountAuthorizationDetailsResponseDeserializer;
impl GetAccountAuthorizationDetailsResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<GetAccountAuthorizationDetailsResponse, XmlParseError> {
        deserialize_elements::<_, GetAccountAuthorizationDetailsResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "GroupDetailList" => {
                        obj.group_detail_list.get_or_insert(vec![]).extend(
                            GroupDetailListTypeDeserializer::deserialize("GroupDetailList", stack)?,
                        );
                    }
                    "IsTruncated" => {
                        obj.is_truncated =
                            Some(BooleanTypeDeserializer::deserialize("IsTruncated", stack)?);
                    }
                    "Marker" => {
                        obj.marker = Some(ResponseMarkerTypeDeserializer::deserialize(
                            "Marker", stack,
                        )?);
                    }
                    "Policies" => {
                        obj.policies.get_or_insert(vec![]).extend(
                            ManagedPolicyDetailListTypeDeserializer::deserialize(
                                "Policies", stack,
                            )?,
                        );
                    }
                    "RoleDetailList" => {
                        obj.role_detail_list.get_or_insert(vec![]).extend(
                            RoleDetailListTypeDeserializer::deserialize("RoleDetailList", stack)?,
                        );
                    }
                    "UserDetailList" => {
                        obj.user_detail_list.get_or_insert(vec![]).extend(
                            UserDetailListTypeDeserializer::deserialize("UserDetailList", stack)?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Contains the response to a successful <a>GetAccountPasswordPolicy</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct GetAccountPasswordPolicyResponse {
    /// <p>A structure that contains details about the account's password policy.</p>
    pub password_policy: PasswordPolicy,
}

#[allow(dead_code)]
struct GetAccountPasswordPolicyResponseDeserializer;
impl GetAccountPasswordPolicyResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<GetAccountPasswordPolicyResponse, XmlParseError> {
        deserialize_elements::<_, GetAccountPasswordPolicyResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "PasswordPolicy" => {
                        obj.password_policy =
                            PasswordPolicyDeserializer::deserialize("PasswordPolicy", stack)?;
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Contains the response to a successful <a>GetAccountSummary</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct GetAccountSummaryResponse {
    /// <p>A set of key–value pairs containing information about IAM entity usage and IAM quotas.</p>
    pub summary_map: Option<::std::collections::HashMap<String, i64>>,
}

#[allow(dead_code)]
struct GetAccountSummaryResponseDeserializer;
impl GetAccountSummaryResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<GetAccountSummaryResponse, XmlParseError> {
        deserialize_elements::<_, GetAccountSummaryResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "SummaryMap" => {
                        obj.summary_map = Some(SummaryMapTypeDeserializer::deserialize(
                            "SummaryMap",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetContextKeysForCustomPolicyRequest {
    /// <p><p>A list of policies for which you want the list of context keys referenced in those policies. Each document is specified as a string containing the complete, valid JSON text of an IAM policy.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of characters consisting of the following:</p> <ul> <li> <p>Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p> </li> <li> <p>The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>)</p> </li> <li> <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>)</p> </li> </ul></p>
    pub policy_input_list: Vec<String>,
}

/// Serialize `GetContextKeysForCustomPolicyRequest` contents to a `SignedRequest`.
struct GetContextKeysForCustomPolicyRequestSerializer;
impl GetContextKeysForCustomPolicyRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &GetContextKeysForCustomPolicyRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        SimulationPolicyListTypeSerializer::serialize(
            params,
            &format!("{}{}", prefix, "PolicyInputList"),
            &obj.policy_input_list,
        );
    }
}

/// <p>Contains the response to a successful <a>GetContextKeysForPrincipalPolicy</a> or <a>GetContextKeysForCustomPolicy</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct GetContextKeysForPolicyResponse {
    /// <p>The list of context keys that are referenced in the input policies.</p>
    pub context_key_names: Option<Vec<String>>,
}

#[allow(dead_code)]
struct GetContextKeysForPolicyResponseDeserializer;
impl GetContextKeysForPolicyResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<GetContextKeysForPolicyResponse, XmlParseError> {
        deserialize_elements::<_, GetContextKeysForPolicyResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "ContextKeyNames" => {
                        obj.context_key_names.get_or_insert(vec![]).extend(
                            ContextKeyNamesResultListTypeDeserializer::deserialize(
                                "ContextKeyNames",
                                stack,
                            )?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetContextKeysForPrincipalPolicyRequest {
    /// <p><p>An optional list of additional policies for which you want the list of context keys that are referenced.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of characters consisting of the following:</p> <ul> <li> <p>Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p> </li> <li> <p>The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>)</p> </li> <li> <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>)</p> </li> </ul></p>
    pub policy_input_list: Option<Vec<String>>,
    /// <p>The ARN of a user, group, or role whose policies contain the context keys that you want listed. If you specify a user, the list includes context keys that are found in all policies that are attached to the user. The list also includes all groups that the user is a member of. If you pick a group or a role, then it includes only those context keys that are found in policies attached to that entity. Note that all parameters are shown in unencoded form here for clarity, but must be URL encoded to be included as a part of a real HTML request.</p> <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub policy_source_arn: String,
}

/// Serialize `GetContextKeysForPrincipalPolicyRequest` contents to a `SignedRequest`.
struct GetContextKeysForPrincipalPolicyRequestSerializer;
impl GetContextKeysForPrincipalPolicyRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &GetContextKeysForPrincipalPolicyRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.policy_input_list {
            SimulationPolicyListTypeSerializer::serialize(
                params,
                &format!("{}{}", prefix, "PolicyInputList"),
                field_value,
            );
        }
        params.put(
            &format!("{}{}", prefix, "PolicySourceArn"),
            &obj.policy_source_arn,
        );
    }
}

/// <p>Contains the response to a successful <a>GetCredentialReport</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct GetCredentialReportResponse {
    /// <p>Contains the credential report. The report is Base64-encoded.</p>
    pub content: Option<bytes::Bytes>,
    /// <p> The date and time when the credential report was created, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>.</p>
    pub generated_time: Option<String>,
    /// <p>The format (MIME type) of the credential report.</p>
    pub report_format: Option<String>,
}

#[allow(dead_code)]
struct GetCredentialReportResponseDeserializer;
impl GetCredentialReportResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<GetCredentialReportResponse, XmlParseError> {
        deserialize_elements::<_, GetCredentialReportResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Content" => {
                        obj.content = Some(ReportContentTypeDeserializer::deserialize(
                            "Content", stack,
                        )?);
                    }
                    "GeneratedTime" => {
                        obj.generated_time =
                            Some(DateTypeDeserializer::deserialize("GeneratedTime", stack)?);
                    }
                    "ReportFormat" => {
                        obj.report_format = Some(ReportFormatTypeDeserializer::deserialize(
                            "ReportFormat",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetGroupPolicyRequest {
    /// <p>The name of the group the policy is associated with.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub group_name: String,
    /// <p>The name of the policy document to get.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub policy_name: String,
}

/// Serialize `GetGroupPolicyRequest` contents to a `SignedRequest`.
struct GetGroupPolicyRequestSerializer;
impl GetGroupPolicyRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &GetGroupPolicyRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "GroupName"), &obj.group_name);
        params.put(&format!("{}{}", prefix, "PolicyName"), &obj.policy_name);
    }
}

/// <p>Contains the response to a successful <a>GetGroupPolicy</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct GetGroupPolicyResponse {
    /// <p>The group the policy is associated with.</p>
    pub group_name: String,
    /// <p>The policy document.</p> <p>IAM stores policies in JSON format. However, resources that were created using AWS CloudFormation templates can be formatted in YAML. AWS CloudFormation always converts a YAML policy to JSON format before submitting it to IAM.</p>
    pub policy_document: String,
    /// <p>The name of the policy.</p>
    pub policy_name: String,
}

#[allow(dead_code)]
struct GetGroupPolicyResponseDeserializer;
impl GetGroupPolicyResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<GetGroupPolicyResponse, XmlParseError> {
        deserialize_elements::<_, GetGroupPolicyResponse, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "GroupName" => {
                    obj.group_name = GroupNameTypeDeserializer::deserialize("GroupName", stack)?;
                }
                "PolicyDocument" => {
                    obj.policy_document =
                        PolicyDocumentTypeDeserializer::deserialize("PolicyDocument", stack)?;
                }
                "PolicyName" => {
                    obj.policy_name = PolicyNameTypeDeserializer::deserialize("PolicyName", stack)?;
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetGroupRequest {
    /// <p>The name of the group.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub group_name: String,
    /// <p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>
    pub marker: Option<String>,
    /// <p>Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>
    pub max_items: Option<i64>,
}

/// Serialize `GetGroupRequest` contents to a `SignedRequest`.
struct GetGroupRequestSerializer;
impl GetGroupRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &GetGroupRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "GroupName"), &obj.group_name);
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_items {
            params.put(&format!("{}{}", prefix, "MaxItems"), &field_value);
        }
    }
}

/// <p>Contains the response to a successful <a>GetGroup</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct GetGroupResponse {
    /// <p>A structure that contains details about the group.</p>
    pub group: Group,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: Option<bool>,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: Option<String>,
    /// <p>A list of users in the group.</p>
    pub users: Vec<User>,
}

#[allow(dead_code)]
struct GetGroupResponseDeserializer;
impl GetGroupResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<GetGroupResponse, XmlParseError> {
        deserialize_elements::<_, GetGroupResponse, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Group" => {
                    obj.group = GroupDeserializer::deserialize("Group", stack)?;
                }
                "IsTruncated" => {
                    obj.is_truncated =
                        Some(BooleanTypeDeserializer::deserialize("IsTruncated", stack)?);
                }
                "Marker" => {
                    obj.marker = Some(ResponseMarkerTypeDeserializer::deserialize(
                        "Marker", stack,
                    )?);
                }
                "Users" => {
                    obj.users
                        .extend(UserListTypeDeserializer::deserialize("Users", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetInstanceProfileRequest {
    /// <p>The name of the instance profile to get information about.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub instance_profile_name: String,
}

/// Serialize `GetInstanceProfileRequest` contents to a `SignedRequest`.
struct GetInstanceProfileRequestSerializer;
impl GetInstanceProfileRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &GetInstanceProfileRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "InstanceProfileName"),
            &obj.instance_profile_name,
        );
    }
}

/// <p>Contains the response to a successful <a>GetInstanceProfile</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct GetInstanceProfileResponse {
    /// <p>A structure containing details about the instance profile.</p>
    pub instance_profile: InstanceProfile,
}

#[allow(dead_code)]
struct GetInstanceProfileResponseDeserializer;
impl GetInstanceProfileResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<GetInstanceProfileResponse, XmlParseError> {
        deserialize_elements::<_, GetInstanceProfileResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "InstanceProfile" => {
                        obj.instance_profile =
                            InstanceProfileDeserializer::deserialize("InstanceProfile", stack)?;
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetLoginProfileRequest {
    /// <p>The name of the user whose login profile you want to retrieve.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub user_name: String,
}

/// Serialize `GetLoginProfileRequest` contents to a `SignedRequest`.
struct GetLoginProfileRequestSerializer;
impl GetLoginProfileRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &GetLoginProfileRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "UserName"), &obj.user_name);
    }
}

/// <p>Contains the response to a successful <a>GetLoginProfile</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct GetLoginProfileResponse {
    /// <p>A structure containing the user name and password create date for the user.</p>
    pub login_profile: LoginProfile,
}

#[allow(dead_code)]
struct GetLoginProfileResponseDeserializer;
impl GetLoginProfileResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<GetLoginProfileResponse, XmlParseError> {
        deserialize_elements::<_, GetLoginProfileResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "LoginProfile" => {
                        obj.login_profile =
                            LoginProfileDeserializer::deserialize("LoginProfile", stack)?;
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetOpenIDConnectProviderRequest {
    /// <p>The Amazon Resource Name (ARN) of the OIDC provider resource object in IAM to get information for. You can get a list of OIDC provider resource ARNs by using the <a>ListOpenIDConnectProviders</a> operation.</p> <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub open_id_connect_provider_arn: String,
}

/// Serialize `GetOpenIDConnectProviderRequest` contents to a `SignedRequest`.
struct GetOpenIDConnectProviderRequestSerializer;
impl GetOpenIDConnectProviderRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &GetOpenIDConnectProviderRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "OpenIDConnectProviderArn"),
            &obj.open_id_connect_provider_arn,
        );
    }
}

/// <p>Contains the response to a successful <a>GetOpenIDConnectProvider</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct GetOpenIDConnectProviderResponse {
    /// <p>A list of client IDs (also known as audiences) that are associated with the specified IAM OIDC provider resource object. For more information, see <a>CreateOpenIDConnectProvider</a>.</p>
    pub client_id_list: Option<Vec<String>>,
    /// <p>The date and time when the IAM OIDC provider resource object was created in the AWS account.</p>
    pub create_date: Option<String>,
    /// <p>A list of tags that are attached to the specified IAM OIDC provider. The returned list of tags is sorted by tag key. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User Guide</i>.</p>
    pub tags: Option<Vec<Tag>>,
    /// <p>A list of certificate thumbprints that are associated with the specified IAM OIDC provider resource object. For more information, see <a>CreateOpenIDConnectProvider</a>. </p>
    pub thumbprint_list: Option<Vec<String>>,
    /// <p>The URL that the IAM OIDC provider resource object is associated with. For more information, see <a>CreateOpenIDConnectProvider</a>.</p>
    pub url: Option<String>,
}

#[allow(dead_code)]
struct GetOpenIDConnectProviderResponseDeserializer;
impl GetOpenIDConnectProviderResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<GetOpenIDConnectProviderResponse, XmlParseError> {
        deserialize_elements::<_, GetOpenIDConnectProviderResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "ClientIDList" => {
                        obj.client_id_list.get_or_insert(vec![]).extend(
                            ClientIDListTypeDeserializer::deserialize("ClientIDList", stack)?,
                        );
                    }
                    "CreateDate" => {
                        obj.create_date =
                            Some(DateTypeDeserializer::deserialize("CreateDate", stack)?);
                    }
                    "Tags" => {
                        obj.tags
                            .get_or_insert(vec![])
                            .extend(TagListTypeDeserializer::deserialize("Tags", stack)?);
                    }
                    "ThumbprintList" => {
                        obj.thumbprint_list.get_or_insert(vec![]).extend(
                            ThumbprintListTypeDeserializer::deserialize("ThumbprintList", stack)?,
                        );
                    }
                    "Url" => {
                        obj.url = Some(OpenIDConnectProviderUrlTypeDeserializer::deserialize(
                            "Url", stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetOrganizationsAccessReportRequest {
    /// <p>The identifier of the request generated by the <a>GenerateOrganizationsAccessReport</a> operation.</p>
    pub job_id: String,
    /// <p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>
    pub marker: Option<String>,
    /// <p>Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>
    pub max_items: Option<i64>,
    /// <p>The key that is used to sort the results. If you choose the namespace key, the results are returned in alphabetical order. If you choose the time key, the results are sorted numerically by the date and time.</p>
    pub sort_key: Option<String>,
}

/// Serialize `GetOrganizationsAccessReportRequest` contents to a `SignedRequest`.
struct GetOrganizationsAccessReportRequestSerializer;
impl GetOrganizationsAccessReportRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &GetOrganizationsAccessReportRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "JobId"), &obj.job_id);
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_items {
            params.put(&format!("{}{}", prefix, "MaxItems"), &field_value);
        }
        if let Some(ref field_value) = obj.sort_key {
            params.put(&format!("{}{}", prefix, "SortKey"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct GetOrganizationsAccessReportResponse {
    /// <p>An object that contains details about the most recent attempt to access the service.</p>
    pub access_details: Option<Vec<AccessDetail>>,
    pub error_details: Option<ErrorDetails>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: Option<bool>,
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the generated report job was completed or failed.</p> <p>This field is null if the job is still in progress, as indicated by a job status value of <code>IN_PROGRESS</code>.</p>
    pub job_completion_date: Option<String>,
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the report job was created.</p>
    pub job_creation_date: String,
    /// <p>The status of the job.</p>
    pub job_status: String,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: Option<String>,
    /// <p>The number of services that the applicable SCPs allow account principals to access.</p>
    pub number_of_services_accessible: Option<i64>,
    /// <p>The number of services that account principals are allowed but did not attempt to access.</p>
    pub number_of_services_not_accessed: Option<i64>,
}

#[allow(dead_code)]
struct GetOrganizationsAccessReportResponseDeserializer;
impl GetOrganizationsAccessReportResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<GetOrganizationsAccessReportResponse, XmlParseError> {
        deserialize_elements::<_, GetOrganizationsAccessReportResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "AccessDetails" => {
                        obj.access_details.get_or_insert(vec![]).extend(
                            AccessDetailsDeserializer::deserialize("AccessDetails", stack)?,
                        );
                    }
                    "ErrorDetails" => {
                        obj.error_details = Some(ErrorDetailsDeserializer::deserialize(
                            "ErrorDetails",
                            stack,
                        )?);
                    }
                    "IsTruncated" => {
                        obj.is_truncated =
                            Some(BooleanTypeDeserializer::deserialize("IsTruncated", stack)?);
                    }
                    "JobCompletionDate" => {
                        obj.job_completion_date = Some(DateTypeDeserializer::deserialize(
                            "JobCompletionDate",
                            stack,
                        )?);
                    }
                    "JobCreationDate" => {
                        obj.job_creation_date =
                            DateTypeDeserializer::deserialize("JobCreationDate", stack)?;
                    }
                    "JobStatus" => {
                        obj.job_status =
                            JobStatusTypeDeserializer::deserialize("JobStatus", stack)?;
                    }
                    "Marker" => {
                        obj.marker = Some(MarkerTypeDeserializer::deserialize("Marker", stack)?);
                    }
                    "NumberOfServicesAccessible" => {
                        obj.number_of_services_accessible =
                            Some(IntegerTypeDeserializer::deserialize(
                                "NumberOfServicesAccessible",
                                stack,
                            )?);
                    }
                    "NumberOfServicesNotAccessed" => {
                        obj.number_of_services_not_accessed =
                            Some(IntegerTypeDeserializer::deserialize(
                                "NumberOfServicesNotAccessed",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetPolicyRequest {
    /// <p>The Amazon Resource Name (ARN) of the managed policy that you want information about.</p> <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub policy_arn: String,
}

/// Serialize `GetPolicyRequest` contents to a `SignedRequest`.
struct GetPolicyRequestSerializer;
impl GetPolicyRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &GetPolicyRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "PolicyArn"), &obj.policy_arn);
    }
}

/// <p>Contains the response to a successful <a>GetPolicy</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct GetPolicyResponse {
    /// <p>A structure containing details about the policy.</p>
    pub policy: Option<Policy>,
}

#[allow(dead_code)]
struct GetPolicyResponseDeserializer;
impl GetPolicyResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<GetPolicyResponse, XmlParseError> {
        deserialize_elements::<_, GetPolicyResponse, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Policy" => {
                    obj.policy = Some(PolicyDeserializer::deserialize("Policy", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetPolicyVersionRequest {
    /// <p>The Amazon Resource Name (ARN) of the managed policy that you want information about.</p> <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub policy_arn: String,
    /// <p>Identifies the policy version to retrieve.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that consists of the lowercase letter 'v' followed by one or two digits, and optionally followed by a period '.' and a string of letters and digits.</p>
    pub version_id: String,
}

/// Serialize `GetPolicyVersionRequest` contents to a `SignedRequest`.
struct GetPolicyVersionRequestSerializer;
impl GetPolicyVersionRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &GetPolicyVersionRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "PolicyArn"), &obj.policy_arn);
        params.put(&format!("{}{}", prefix, "VersionId"), &obj.version_id);
    }
}

/// <p>Contains the response to a successful <a>GetPolicyVersion</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct GetPolicyVersionResponse {
    /// <p>A structure containing details about the policy version.</p>
    pub policy_version: Option<PolicyVersion>,
}

#[allow(dead_code)]
struct GetPolicyVersionResponseDeserializer;
impl GetPolicyVersionResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<GetPolicyVersionResponse, XmlParseError> {
        deserialize_elements::<_, GetPolicyVersionResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "PolicyVersion" => {
                        obj.policy_version = Some(PolicyVersionDeserializer::deserialize(
                            "PolicyVersion",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetRolePolicyRequest {
    /// <p>The name of the policy document to get.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub policy_name: String,
    /// <p>The name of the role associated with the policy.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub role_name: String,
}

/// Serialize `GetRolePolicyRequest` contents to a `SignedRequest`.
struct GetRolePolicyRequestSerializer;
impl GetRolePolicyRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &GetRolePolicyRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "PolicyName"), &obj.policy_name);
        params.put(&format!("{}{}", prefix, "RoleName"), &obj.role_name);
    }
}

/// <p>Contains the response to a successful <a>GetRolePolicy</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct GetRolePolicyResponse {
    /// <p>The policy document.</p> <p>IAM stores policies in JSON format. However, resources that were created using AWS CloudFormation templates can be formatted in YAML. AWS CloudFormation always converts a YAML policy to JSON format before submitting it to IAM.</p>
    pub policy_document: String,
    /// <p>The name of the policy.</p>
    pub policy_name: String,
    /// <p>The role the policy is associated with.</p>
    pub role_name: String,
}

#[allow(dead_code)]
struct GetRolePolicyResponseDeserializer;
impl GetRolePolicyResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<GetRolePolicyResponse, XmlParseError> {
        deserialize_elements::<_, GetRolePolicyResponse, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "PolicyDocument" => {
                    obj.policy_document =
                        PolicyDocumentTypeDeserializer::deserialize("PolicyDocument", stack)?;
                }
                "PolicyName" => {
                    obj.policy_name = PolicyNameTypeDeserializer::deserialize("PolicyName", stack)?;
                }
                "RoleName" => {
                    obj.role_name = RoleNameTypeDeserializer::deserialize("RoleName", stack)?;
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetRoleRequest {
    /// <p>The name of the IAM role to get information about.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub role_name: String,
}

/// Serialize `GetRoleRequest` contents to a `SignedRequest`.
struct GetRoleRequestSerializer;
impl GetRoleRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &GetRoleRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "RoleName"), &obj.role_name);
    }
}

/// <p>Contains the response to a successful <a>GetRole</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct GetRoleResponse {
    /// <p>A structure containing details about the IAM role.</p>
    pub role: Role,
}

#[allow(dead_code)]
struct GetRoleResponseDeserializer;
impl GetRoleResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<GetRoleResponse, XmlParseError> {
        deserialize_elements::<_, GetRoleResponse, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Role" => {
                    obj.role = RoleDeserializer::deserialize("Role", stack)?;
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetSAMLProviderRequest {
    /// <p>The Amazon Resource Name (ARN) of the SAML provider resource object in IAM to get information about.</p> <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub saml_provider_arn: String,
}

/// Serialize `GetSAMLProviderRequest` contents to a `SignedRequest`.
struct GetSAMLProviderRequestSerializer;
impl GetSAMLProviderRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &GetSAMLProviderRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "SAMLProviderArn"),
            &obj.saml_provider_arn,
        );
    }
}

/// <p>Contains the response to a successful <a>GetSAMLProvider</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct GetSAMLProviderResponse {
    /// <p>The date and time when the SAML provider was created.</p>
    pub create_date: Option<String>,
    /// <p>The XML metadata document that includes information about an identity provider.</p>
    pub saml_metadata_document: Option<String>,
    /// <p>A list of tags that are attached to the specified IAM SAML provider. The returned list of tags is sorted by tag key. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User Guide</i>.</p>
    pub tags: Option<Vec<Tag>>,
    /// <p>The expiration date and time for the SAML provider.</p>
    pub valid_until: Option<String>,
}

#[allow(dead_code)]
struct GetSAMLProviderResponseDeserializer;
impl GetSAMLProviderResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<GetSAMLProviderResponse, XmlParseError> {
        deserialize_elements::<_, GetSAMLProviderResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "CreateDate" => {
                        obj.create_date =
                            Some(DateTypeDeserializer::deserialize("CreateDate", stack)?);
                    }
                    "SAMLMetadataDocument" => {
                        obj.saml_metadata_document =
                            Some(SAMLMetadataDocumentTypeDeserializer::deserialize(
                                "SAMLMetadataDocument",
                                stack,
                            )?);
                    }
                    "Tags" => {
                        obj.tags
                            .get_or_insert(vec![])
                            .extend(TagListTypeDeserializer::deserialize("Tags", stack)?);
                    }
                    "ValidUntil" => {
                        obj.valid_until =
                            Some(DateTypeDeserializer::deserialize("ValidUntil", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetSSHPublicKeyRequest {
    /// <p>Specifies the public key encoding format to use in the response. To retrieve the public key in ssh-rsa format, use <code>SSH</code>. To retrieve the public key in PEM format, use <code>PEM</code>.</p>
    pub encoding: String,
    /// <p>The unique identifier for the SSH public key.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that can consist of any upper or lowercased letter or digit.</p>
    pub ssh_public_key_id: String,
    /// <p>The name of the IAM user associated with the SSH public key.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub user_name: String,
}

/// Serialize `GetSSHPublicKeyRequest` contents to a `SignedRequest`.
struct GetSSHPublicKeyRequestSerializer;
impl GetSSHPublicKeyRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &GetSSHPublicKeyRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "Encoding"), &obj.encoding);
        params.put(
            &format!("{}{}", prefix, "SSHPublicKeyId"),
            &obj.ssh_public_key_id,
        );
        params.put(&format!("{}{}", prefix, "UserName"), &obj.user_name);
    }
}

/// <p>Contains the response to a successful <a>GetSSHPublicKey</a> request.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct GetSSHPublicKeyResponse {
    /// <p>A structure containing details about the SSH public key.</p>
    pub ssh_public_key: Option<SSHPublicKey>,
}

#[allow(dead_code)]
struct GetSSHPublicKeyResponseDeserializer;
impl GetSSHPublicKeyResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<GetSSHPublicKeyResponse, XmlParseError> {
        deserialize_elements::<_, GetSSHPublicKeyResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "SSHPublicKey" => {
                        obj.ssh_public_key = Some(SSHPublicKeyDeserializer::deserialize(
                            "SSHPublicKey",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetServerCertificateRequest {
    /// <p>The name of the server certificate you want to retrieve information about.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub server_certificate_name: String,
}

/// Serialize `GetServerCertificateRequest` contents to a `SignedRequest`.
struct GetServerCertificateRequestSerializer;
impl GetServerCertificateRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &GetServerCertificateRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "ServerCertificateName"),
            &obj.server_certificate_name,
        );
    }
}

/// <p>Contains the response to a successful <a>GetServerCertificate</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct GetServerCertificateResponse {
    /// <p>A structure containing details about the server certificate.</p>
    pub server_certificate: ServerCertificate,
}

#[allow(dead_code)]
struct GetServerCertificateResponseDeserializer;
impl GetServerCertificateResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<GetServerCertificateResponse, XmlParseError> {
        deserialize_elements::<_, GetServerCertificateResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "ServerCertificate" => {
                        obj.server_certificate =
                            ServerCertificateDeserializer::deserialize("ServerCertificate", stack)?;
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetServiceLastAccessedDetailsRequest {
    /// <p>The ID of the request generated by the <a>GenerateServiceLastAccessedDetails</a> operation. The <code>JobId</code> returned by <code>GenerateServiceLastAccessedDetail</code> must be used by the same role within a session, or by the same user when used to call <code>GetServiceLastAccessedDetail</code>.</p>
    pub job_id: String,
    /// <p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>
    pub marker: Option<String>,
    /// <p>Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>
    pub max_items: Option<i64>,
}

/// Serialize `GetServiceLastAccessedDetailsRequest` contents to a `SignedRequest`.
struct GetServiceLastAccessedDetailsRequestSerializer;
impl GetServiceLastAccessedDetailsRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &GetServiceLastAccessedDetailsRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "JobId"), &obj.job_id);
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_items {
            params.put(&format!("{}{}", prefix, "MaxItems"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct GetServiceLastAccessedDetailsResponse {
    /// <p>An object that contains details about the reason the operation failed.</p>
    pub error: Option<ErrorDetails>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: Option<bool>,
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the generated report job was completed or failed.</p> <p>This field is null if the job is still in progress, as indicated by a job status value of <code>IN_PROGRESS</code>.</p>
    pub job_completion_date: String,
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the report job was created.</p>
    pub job_creation_date: String,
    /// <p>The status of the job.</p>
    pub job_status: String,
    /// <p>The type of job. Service jobs return information about when each service was last accessed. Action jobs also include information about when tracked actions within the service were last accessed.</p>
    pub job_type: Option<String>,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: Option<String>,
    /// <p> A <code>ServiceLastAccessed</code> object that contains details about the most recent attempt to access the service.</p>
    pub services_last_accessed: Vec<ServiceLastAccessed>,
}

#[allow(dead_code)]
struct GetServiceLastAccessedDetailsResponseDeserializer;
impl GetServiceLastAccessedDetailsResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<GetServiceLastAccessedDetailsResponse, XmlParseError> {
        deserialize_elements::<_, GetServiceLastAccessedDetailsResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Error" => {
                        obj.error = Some(ErrorDetailsDeserializer::deserialize("Error", stack)?);
                    }
                    "IsTruncated" => {
                        obj.is_truncated =
                            Some(BooleanTypeDeserializer::deserialize("IsTruncated", stack)?);
                    }
                    "JobCompletionDate" => {
                        obj.job_completion_date =
                            DateTypeDeserializer::deserialize("JobCompletionDate", stack)?;
                    }
                    "JobCreationDate" => {
                        obj.job_creation_date =
                            DateTypeDeserializer::deserialize("JobCreationDate", stack)?;
                    }
                    "JobStatus" => {
                        obj.job_status =
                            JobStatusTypeDeserializer::deserialize("JobStatus", stack)?;
                    }
                    "JobType" => {
                        obj.job_type =
                            Some(AccessAdvisorUsageGranularityTypeDeserializer::deserialize(
                                "JobType", stack,
                            )?);
                    }
                    "Marker" => {
                        obj.marker = Some(ResponseMarkerTypeDeserializer::deserialize(
                            "Marker", stack,
                        )?);
                    }
                    "ServicesLastAccessed" => {
                        obj.services_last_accessed.extend(
                            ServicesLastAccessedDeserializer::deserialize(
                                "ServicesLastAccessed",
                                stack,
                            )?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetServiceLastAccessedDetailsWithEntitiesRequest {
    /// <p>The ID of the request generated by the <code>GenerateServiceLastAccessedDetails</code> operation.</p>
    pub job_id: String,
    /// <p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>
    pub marker: Option<String>,
    /// <p>Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>
    pub max_items: Option<i64>,
    /// <p>The service namespace for an AWS service. Provide the service namespace to learn when the IAM entity last attempted to access the specified service.</p> <p>To learn the service namespace for a service, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html">Actions, resources, and condition keys for AWS services</a> in the <i>IAM User Guide</i>. Choose the name of the service to view details for that service. In the first paragraph, find the service prefix. For example, <code>(service prefix: a4b)</code>. For more information about service namespaces, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces">AWS service namespaces</a> in the <i>AWS General Reference</i>.</p>
    pub service_namespace: String,
}

/// Serialize `GetServiceLastAccessedDetailsWithEntitiesRequest` contents to a `SignedRequest`.
struct GetServiceLastAccessedDetailsWithEntitiesRequestSerializer;
impl GetServiceLastAccessedDetailsWithEntitiesRequestSerializer {
    fn serialize(
        params: &mut Params,
        name: &str,
        obj: &GetServiceLastAccessedDetailsWithEntitiesRequest,
    ) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "JobId"), &obj.job_id);
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_items {
            params.put(&format!("{}{}", prefix, "MaxItems"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "ServiceNamespace"),
            &obj.service_namespace,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct GetServiceLastAccessedDetailsWithEntitiesResponse {
    /// <p>An <code>EntityDetailsList</code> object that contains details about when an IAM entity (user or role) used group or policy permissions in an attempt to access the specified AWS service.</p>
    pub entity_details_list: Vec<EntityDetails>,
    /// <p>An object that contains details about the reason the operation failed.</p>
    pub error: Option<ErrorDetails>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: Option<bool>,
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the generated report job was completed or failed.</p> <p>This field is null if the job is still in progress, as indicated by a job status value of <code>IN_PROGRESS</code>.</p>
    pub job_completion_date: String,
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the report job was created.</p>
    pub job_creation_date: String,
    /// <p>The status of the job.</p>
    pub job_status: String,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: Option<String>,
}

#[allow(dead_code)]
struct GetServiceLastAccessedDetailsWithEntitiesResponseDeserializer;
impl GetServiceLastAccessedDetailsWithEntitiesResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<GetServiceLastAccessedDetailsWithEntitiesResponse, XmlParseError> {
        deserialize_elements::<_, GetServiceLastAccessedDetailsWithEntitiesResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "EntityDetailsList" => {
                        obj.entity_details_list.extend(
                            EntityDetailsListTypeDeserializer::deserialize(
                                "EntityDetailsList",
                                stack,
                            )?,
                        );
                    }
                    "Error" => {
                        obj.error = Some(ErrorDetailsDeserializer::deserialize("Error", stack)?);
                    }
                    "IsTruncated" => {
                        obj.is_truncated =
                            Some(BooleanTypeDeserializer::deserialize("IsTruncated", stack)?);
                    }
                    "JobCompletionDate" => {
                        obj.job_completion_date =
                            DateTypeDeserializer::deserialize("JobCompletionDate", stack)?;
                    }
                    "JobCreationDate" => {
                        obj.job_creation_date =
                            DateTypeDeserializer::deserialize("JobCreationDate", stack)?;
                    }
                    "JobStatus" => {
                        obj.job_status =
                            JobStatusTypeDeserializer::deserialize("JobStatus", stack)?;
                    }
                    "Marker" => {
                        obj.marker = Some(ResponseMarkerTypeDeserializer::deserialize(
                            "Marker", stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetServiceLinkedRoleDeletionStatusRequest {
    /// <p>The deletion task identifier. This identifier is returned by the <a>DeleteServiceLinkedRole</a> operation in the format <code>task/aws-service-role/&lt;service-principal-name&gt;/&lt;role-name&gt;/&lt;task-uuid&gt;</code>.</p>
    pub deletion_task_id: String,
}

/// Serialize `GetServiceLinkedRoleDeletionStatusRequest` contents to a `SignedRequest`.
struct GetServiceLinkedRoleDeletionStatusRequestSerializer;
impl GetServiceLinkedRoleDeletionStatusRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &GetServiceLinkedRoleDeletionStatusRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "DeletionTaskId"),
            &obj.deletion_task_id,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct GetServiceLinkedRoleDeletionStatusResponse {
    /// <p>An object that contains details about the reason the deletion failed.</p>
    pub reason: Option<DeletionTaskFailureReasonType>,
    /// <p>The status of the deletion.</p>
    pub status: String,
}

#[allow(dead_code)]
struct GetServiceLinkedRoleDeletionStatusResponseDeserializer;
impl GetServiceLinkedRoleDeletionStatusResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<GetServiceLinkedRoleDeletionStatusResponse, XmlParseError> {
        deserialize_elements::<_, GetServiceLinkedRoleDeletionStatusResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Reason" => {
                        obj.reason = Some(DeletionTaskFailureReasonTypeDeserializer::deserialize(
                            "Reason", stack,
                        )?);
                    }
                    "Status" => {
                        obj.status =
                            DeletionTaskStatusTypeDeserializer::deserialize("Status", stack)?;
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetUserPolicyRequest {
    /// <p>The name of the policy document to get.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub policy_name: String,
    /// <p>The name of the user who the policy is associated with.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub user_name: String,
}

/// Serialize `GetUserPolicyRequest` contents to a `SignedRequest`.
struct GetUserPolicyRequestSerializer;
impl GetUserPolicyRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &GetUserPolicyRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "PolicyName"), &obj.policy_name);
        params.put(&format!("{}{}", prefix, "UserName"), &obj.user_name);
    }
}

/// <p>Contains the response to a successful <a>GetUserPolicy</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct GetUserPolicyResponse {
    /// <p>The policy document.</p> <p>IAM stores policies in JSON format. However, resources that were created using AWS CloudFormation templates can be formatted in YAML. AWS CloudFormation always converts a YAML policy to JSON format before submitting it to IAM.</p>
    pub policy_document: String,
    /// <p>The name of the policy.</p>
    pub policy_name: String,
    /// <p>The user the policy is associated with.</p>
    pub user_name: String,
}

#[allow(dead_code)]
struct GetUserPolicyResponseDeserializer;
impl GetUserPolicyResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<GetUserPolicyResponse, XmlParseError> {
        deserialize_elements::<_, GetUserPolicyResponse, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "PolicyDocument" => {
                    obj.policy_document =
                        PolicyDocumentTypeDeserializer::deserialize("PolicyDocument", stack)?;
                }
                "PolicyName" => {
                    obj.policy_name = PolicyNameTypeDeserializer::deserialize("PolicyName", stack)?;
                }
                "UserName" => {
                    obj.user_name =
                        ExistingUserNameTypeDeserializer::deserialize("UserName", stack)?;
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetUserRequest {
    /// <p>The name of the user to get information about.</p> <p>This parameter is optional. If it is not included, it defaults to the user making the request. This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub user_name: Option<String>,
}

/// Serialize `GetUserRequest` contents to a `SignedRequest`.
struct GetUserRequestSerializer;
impl GetUserRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &GetUserRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.user_name {
            params.put(&format!("{}{}", prefix, "UserName"), &field_value);
        }
    }
}

/// <p>Contains the response to a successful <a>GetUser</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct GetUserResponse {
    /// <p><p>A structure containing details about the IAM user.</p> <important> <p>Due to a service issue, password last used data does not include password use from May 3, 2018 22:50 PDT to May 23, 2018 14:08 PDT. This affects <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_finding-unused.html">last sign-in</a> dates shown in the IAM console and password last used dates in the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_getting-report.html">IAM credential report</a>, and returned by this operation. If users signed in during the affected time, the password last used date that is returned is the date the user last signed in before May 3, 2018. For users that signed in after May 23, 2018 14:08 PDT, the returned password last used date is accurate.</p> <p>You can use password last used information to identify unused credentials for deletion. For example, you might delete users who did not sign in to AWS in the last 90 days. In cases like this, we recommend that you adjust your evaluation window to include dates after May 23, 2018. Alternatively, if your users use access keys to access AWS programmatically you can refer to access key last used information because it is accurate for all dates. </p> </important></p>
    pub user: User,
}

#[allow(dead_code)]
struct GetUserResponseDeserializer;
impl GetUserResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<GetUserResponse, XmlParseError> {
        deserialize_elements::<_, GetUserResponse, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "User" => {
                    obj.user = UserDeserializer::deserialize("User", stack)?;
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p><p>Contains information about an IAM group entity.</p> <p>This data type is used as a response element in the following operations:</p> <ul> <li> <p> <a>CreateGroup</a> </p> </li> <li> <p> <a>GetGroup</a> </p> </li> <li> <p> <a>ListGroups</a> </p> </li> </ul></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct Group {
    /// <p> The Amazon Resource Name (ARN) specifying the group. For more information about ARNs and how to use them in policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the <i>IAM User Guide</i>. </p>
    pub arn: String,
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the group was created.</p>
    pub create_date: String,
    /// <p> The stable and unique string identifying the group. For more information about IDs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the <i>IAM User Guide</i>. </p>
    pub group_id: String,
    /// <p>The friendly name that identifies the group.</p>
    pub group_name: String,
    /// <p>The path to the group. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the <i>IAM User Guide</i>. </p>
    pub path: String,
}

#[allow(dead_code)]
struct GroupDeserializer;
impl GroupDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<Group, XmlParseError> {
        deserialize_elements::<_, Group, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Arn" => {
                    obj.arn = ArnTypeDeserializer::deserialize("Arn", stack)?;
                }
                "CreateDate" => {
                    obj.create_date = DateTypeDeserializer::deserialize("CreateDate", stack)?;
                }
                "GroupId" => {
                    obj.group_id = IdTypeDeserializer::deserialize("GroupId", stack)?;
                }
                "GroupName" => {
                    obj.group_name = GroupNameTypeDeserializer::deserialize("GroupName", stack)?;
                }
                "Path" => {
                    obj.path = PathTypeDeserializer::deserialize("Path", stack)?;
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>Contains information about an IAM group, including all of the group's policies.</p> <p>This data type is used as a response element in the <a>GetAccountAuthorizationDetails</a> operation.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct GroupDetail {
    pub arn: Option<String>,
    /// <p>A list of the managed policies attached to the group.</p>
    pub attached_managed_policies: Option<Vec<AttachedPolicy>>,
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the group was created.</p>
    pub create_date: Option<String>,
    /// <p>The stable and unique string identifying the group. For more information about IDs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the <i>IAM User Guide</i>.</p>
    pub group_id: Option<String>,
    /// <p>The friendly name that identifies the group.</p>
    pub group_name: Option<String>,
    /// <p>A list of the inline policies embedded in the group.</p>
    pub group_policy_list: Option<Vec<PolicyDetail>>,
    /// <p>The path to the group. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the <i>IAM User Guide</i>.</p>
    pub path: Option<String>,
}

#[allow(dead_code)]
struct GroupDetailDeserializer;
impl GroupDetailDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<GroupDetail, XmlParseError> {
        deserialize_elements::<_, GroupDetail, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Arn" => {
                    obj.arn = Some(ArnTypeDeserializer::deserialize("Arn", stack)?);
                }
                "AttachedManagedPolicies" => {
                    obj.attached_managed_policies.get_or_insert(vec![]).extend(
                        AttachedPoliciesListTypeDeserializer::deserialize(
                            "AttachedManagedPolicies",
                            stack,
                        )?,
                    );
                }
                "CreateDate" => {
                    obj.create_date = Some(DateTypeDeserializer::deserialize("CreateDate", stack)?);
                }
                "GroupId" => {
                    obj.group_id = Some(IdTypeDeserializer::deserialize("GroupId", stack)?);
                }
                "GroupName" => {
                    obj.group_name =
                        Some(GroupNameTypeDeserializer::deserialize("GroupName", stack)?);
                }
                "GroupPolicyList" => {
                    obj.group_policy_list.get_or_insert(vec![]).extend(
                        PolicyDetailListTypeDeserializer::deserialize("GroupPolicyList", stack)?,
                    );
                }
                "Path" => {
                    obj.path = Some(PathTypeDeserializer::deserialize("Path", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct GroupDetailListTypeDeserializer;
impl GroupDetailListTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<GroupDetail>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(GroupDetailDeserializer::deserialize("member", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct GroupListTypeDeserializer;
impl GroupListTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<Group>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(GroupDeserializer::deserialize("member", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct GroupNameListTypeDeserializer;
impl GroupNameListTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<String>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(GroupNameTypeDeserializer::deserialize("member", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct GroupNameTypeDeserializer;
impl GroupNameTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct IdTypeDeserializer;
impl IdTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p><p>Contains information about an instance profile.</p> <p>This data type is used as a response element in the following operations:</p> <ul> <li> <p> <a>CreateInstanceProfile</a> </p> </li> <li> <p> <a>GetInstanceProfile</a> </p> </li> <li> <p> <a>ListInstanceProfiles</a> </p> </li> <li> <p> <a>ListInstanceProfilesForRole</a> </p> </li> </ul></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct InstanceProfile {
    /// <p> The Amazon Resource Name (ARN) specifying the instance profile. For more information about ARNs and how to use them in policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the <i>IAM User Guide</i>. </p>
    pub arn: String,
    /// <p>The date when the instance profile was created.</p>
    pub create_date: String,
    /// <p> The stable and unique string identifying the instance profile. For more information about IDs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the <i>IAM User Guide</i>. </p>
    pub instance_profile_id: String,
    /// <p>The name identifying the instance profile.</p>
    pub instance_profile_name: String,
    /// <p> The path to the instance profile. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the <i>IAM User Guide</i>. </p>
    pub path: String,
    /// <p>The role associated with the instance profile.</p>
    pub roles: Vec<Role>,
    /// <p>A list of tags that are attached to the instance profile. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User Guide</i>.</p>
    pub tags: Option<Vec<Tag>>,
}

#[allow(dead_code)]
struct InstanceProfileDeserializer;
impl InstanceProfileDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<InstanceProfile, XmlParseError> {
        deserialize_elements::<_, InstanceProfile, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Arn" => {
                    obj.arn = ArnTypeDeserializer::deserialize("Arn", stack)?;
                }
                "CreateDate" => {
                    obj.create_date = DateTypeDeserializer::deserialize("CreateDate", stack)?;
                }
                "InstanceProfileId" => {
                    obj.instance_profile_id =
                        IdTypeDeserializer::deserialize("InstanceProfileId", stack)?;
                }
                "InstanceProfileName" => {
                    obj.instance_profile_name = InstanceProfileNameTypeDeserializer::deserialize(
                        "InstanceProfileName",
                        stack,
                    )?;
                }
                "Path" => {
                    obj.path = PathTypeDeserializer::deserialize("Path", stack)?;
                }
                "Roles" => {
                    obj.roles
                        .extend(RoleListTypeDeserializer::deserialize("Roles", stack)?);
                }
                "Tags" => {
                    obj.tags
                        .get_or_insert(vec![])
                        .extend(TagListTypeDeserializer::deserialize("Tags", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct InstanceProfileListTypeDeserializer;
impl InstanceProfileListTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<InstanceProfile>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(InstanceProfileDeserializer::deserialize("member", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct InstanceProfileNameTypeDeserializer;
impl InstanceProfileNameTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct IntegerTypeDeserializer;
impl IntegerTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<i64, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, |s| Ok(i64::from_str(&s).unwrap()))
    }
}
#[allow(dead_code)]
struct JobIDTypeDeserializer;
impl JobIDTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct JobStatusTypeDeserializer;
impl JobStatusTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct LineNumberDeserializer;
impl LineNumberDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<i64, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, |s| Ok(i64::from_str(&s).unwrap()))
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListAccessKeysRequest {
    /// <p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>
    pub marker: Option<String>,
    /// <p>Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>
    pub max_items: Option<i64>,
    /// <p>The name of the user.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub user_name: Option<String>,
}

/// Serialize `ListAccessKeysRequest` contents to a `SignedRequest`.
struct ListAccessKeysRequestSerializer;
impl ListAccessKeysRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ListAccessKeysRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_items {
            params.put(&format!("{}{}", prefix, "MaxItems"), &field_value);
        }
        if let Some(ref field_value) = obj.user_name {
            params.put(&format!("{}{}", prefix, "UserName"), &field_value);
        }
    }
}

/// <p>Contains the response to a successful <a>ListAccessKeys</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ListAccessKeysResponse {
    /// <p>A list of objects containing metadata about the access keys.</p>
    pub access_key_metadata: Vec<AccessKeyMetadata>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: Option<bool>,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: Option<String>,
}

#[allow(dead_code)]
struct ListAccessKeysResponseDeserializer;
impl ListAccessKeysResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ListAccessKeysResponse, XmlParseError> {
        deserialize_elements::<_, ListAccessKeysResponse, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "AccessKeyMetadata" => {
                    obj.access_key_metadata.extend(
                        AccessKeyMetadataListTypeDeserializer::deserialize(
                            "AccessKeyMetadata",
                            stack,
                        )?,
                    );
                }
                "IsTruncated" => {
                    obj.is_truncated =
                        Some(BooleanTypeDeserializer::deserialize("IsTruncated", stack)?);
                }
                "Marker" => {
                    obj.marker = Some(ResponseMarkerTypeDeserializer::deserialize(
                        "Marker", stack,
                    )?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListAccountAliasesRequest {
    /// <p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>
    pub marker: Option<String>,
    /// <p>Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>
    pub max_items: Option<i64>,
}

/// Serialize `ListAccountAliasesRequest` contents to a `SignedRequest`.
struct ListAccountAliasesRequestSerializer;
impl ListAccountAliasesRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ListAccountAliasesRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_items {
            params.put(&format!("{}{}", prefix, "MaxItems"), &field_value);
        }
    }
}

/// <p>Contains the response to a successful <a>ListAccountAliases</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ListAccountAliasesResponse {
    /// <p>A list of aliases associated with the account. AWS supports only one alias per account.</p>
    pub account_aliases: Vec<String>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: Option<bool>,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: Option<String>,
}

#[allow(dead_code)]
struct ListAccountAliasesResponseDeserializer;
impl ListAccountAliasesResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ListAccountAliasesResponse, XmlParseError> {
        deserialize_elements::<_, ListAccountAliasesResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "AccountAliases" => {
                        obj.account_aliases
                            .extend(AccountAliasListTypeDeserializer::deserialize(
                                "AccountAliases",
                                stack,
                            )?);
                    }
                    "IsTruncated" => {
                        obj.is_truncated =
                            Some(BooleanTypeDeserializer::deserialize("IsTruncated", stack)?);
                    }
                    "Marker" => {
                        obj.marker = Some(ResponseMarkerTypeDeserializer::deserialize(
                            "Marker", stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListAttachedGroupPoliciesRequest {
    /// <p>The name (friendly name, not ARN) of the group to list attached policies for.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub group_name: String,
    /// <p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>
    pub marker: Option<String>,
    /// <p>Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>
    pub max_items: Option<i64>,
    /// <p>The path prefix for filtering the results. This parameter is optional. If it is not included, it defaults to a slash (/), listing all policies.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes. In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including most punctuation characters, digits, and upper and lowercased letters.</p>
    pub path_prefix: Option<String>,
}

/// Serialize `ListAttachedGroupPoliciesRequest` contents to a `SignedRequest`.
struct ListAttachedGroupPoliciesRequestSerializer;
impl ListAttachedGroupPoliciesRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ListAttachedGroupPoliciesRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "GroupName"), &obj.group_name);
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_items {
            params.put(&format!("{}{}", prefix, "MaxItems"), &field_value);
        }
        if let Some(ref field_value) = obj.path_prefix {
            params.put(&format!("{}{}", prefix, "PathPrefix"), &field_value);
        }
    }
}

/// <p>Contains the response to a successful <a>ListAttachedGroupPolicies</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ListAttachedGroupPoliciesResponse {
    /// <p>A list of the attached policies.</p>
    pub attached_policies: Option<Vec<AttachedPolicy>>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: Option<bool>,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: Option<String>,
}

#[allow(dead_code)]
struct ListAttachedGroupPoliciesResponseDeserializer;
impl ListAttachedGroupPoliciesResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ListAttachedGroupPoliciesResponse, XmlParseError> {
        deserialize_elements::<_, ListAttachedGroupPoliciesResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "AttachedPolicies" => {
                        obj.attached_policies.get_or_insert(vec![]).extend(
                            AttachedPoliciesListTypeDeserializer::deserialize(
                                "AttachedPolicies",
                                stack,
                            )?,
                        );
                    }
                    "IsTruncated" => {
                        obj.is_truncated =
                            Some(BooleanTypeDeserializer::deserialize("IsTruncated", stack)?);
                    }
                    "Marker" => {
                        obj.marker = Some(ResponseMarkerTypeDeserializer::deserialize(
                            "Marker", stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListAttachedRolePoliciesRequest {
    /// <p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>
    pub marker: Option<String>,
    /// <p>Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>
    pub max_items: Option<i64>,
    /// <p>The path prefix for filtering the results. This parameter is optional. If it is not included, it defaults to a slash (/), listing all policies.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes. In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including most punctuation characters, digits, and upper and lowercased letters.</p>
    pub path_prefix: Option<String>,
    /// <p>The name (friendly name, not ARN) of the role to list attached policies for.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub role_name: String,
}

/// Serialize `ListAttachedRolePoliciesRequest` contents to a `SignedRequest`.
struct ListAttachedRolePoliciesRequestSerializer;
impl ListAttachedRolePoliciesRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ListAttachedRolePoliciesRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_items {
            params.put(&format!("{}{}", prefix, "MaxItems"), &field_value);
        }
        if let Some(ref field_value) = obj.path_prefix {
            params.put(&format!("{}{}", prefix, "PathPrefix"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "RoleName"), &obj.role_name);
    }
}

/// <p>Contains the response to a successful <a>ListAttachedRolePolicies</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ListAttachedRolePoliciesResponse {
    /// <p>A list of the attached policies.</p>
    pub attached_policies: Option<Vec<AttachedPolicy>>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: Option<bool>,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: Option<String>,
}

#[allow(dead_code)]
struct ListAttachedRolePoliciesResponseDeserializer;
impl ListAttachedRolePoliciesResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ListAttachedRolePoliciesResponse, XmlParseError> {
        deserialize_elements::<_, ListAttachedRolePoliciesResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "AttachedPolicies" => {
                        obj.attached_policies.get_or_insert(vec![]).extend(
                            AttachedPoliciesListTypeDeserializer::deserialize(
                                "AttachedPolicies",
                                stack,
                            )?,
                        );
                    }
                    "IsTruncated" => {
                        obj.is_truncated =
                            Some(BooleanTypeDeserializer::deserialize("IsTruncated", stack)?);
                    }
                    "Marker" => {
                        obj.marker = Some(ResponseMarkerTypeDeserializer::deserialize(
                            "Marker", stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListAttachedUserPoliciesRequest {
    /// <p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>
    pub marker: Option<String>,
    /// <p>Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>
    pub max_items: Option<i64>,
    /// <p>The path prefix for filtering the results. This parameter is optional. If it is not included, it defaults to a slash (/), listing all policies.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes. In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including most punctuation characters, digits, and upper and lowercased letters.</p>
    pub path_prefix: Option<String>,
    /// <p>The name (friendly name, not ARN) of the user to list attached policies for.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub user_name: String,
}

/// Serialize `ListAttachedUserPoliciesRequest` contents to a `SignedRequest`.
struct ListAttachedUserPoliciesRequestSerializer;
impl ListAttachedUserPoliciesRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ListAttachedUserPoliciesRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_items {
            params.put(&format!("{}{}", prefix, "MaxItems"), &field_value);
        }
        if let Some(ref field_value) = obj.path_prefix {
            params.put(&format!("{}{}", prefix, "PathPrefix"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "UserName"), &obj.user_name);
    }
}

/// <p>Contains the response to a successful <a>ListAttachedUserPolicies</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ListAttachedUserPoliciesResponse {
    /// <p>A list of the attached policies.</p>
    pub attached_policies: Option<Vec<AttachedPolicy>>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: Option<bool>,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: Option<String>,
}

#[allow(dead_code)]
struct ListAttachedUserPoliciesResponseDeserializer;
impl ListAttachedUserPoliciesResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ListAttachedUserPoliciesResponse, XmlParseError> {
        deserialize_elements::<_, ListAttachedUserPoliciesResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "AttachedPolicies" => {
                        obj.attached_policies.get_or_insert(vec![]).extend(
                            AttachedPoliciesListTypeDeserializer::deserialize(
                                "AttachedPolicies",
                                stack,
                            )?,
                        );
                    }
                    "IsTruncated" => {
                        obj.is_truncated =
                            Some(BooleanTypeDeserializer::deserialize("IsTruncated", stack)?);
                    }
                    "Marker" => {
                        obj.marker = Some(ResponseMarkerTypeDeserializer::deserialize(
                            "Marker", stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListEntitiesForPolicyRequest {
    /// <p>The entity type to use for filtering the results.</p> <p>For example, when <code>EntityFilter</code> is <code>Role</code>, only the roles that are attached to the specified policy are returned. This parameter is optional. If it is not included, all attached entities (users, groups, and roles) are returned. The argument for this parameter must be one of the valid values listed below.</p>
    pub entity_filter: Option<String>,
    /// <p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>
    pub marker: Option<String>,
    /// <p>Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>
    pub max_items: Option<i64>,
    /// <p>The path prefix for filtering the results. This parameter is optional. If it is not included, it defaults to a slash (/), listing all entities.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes. In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including most punctuation characters, digits, and upper and lowercased letters.</p>
    pub path_prefix: Option<String>,
    /// <p>The Amazon Resource Name (ARN) of the IAM policy for which you want the versions.</p> <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub policy_arn: String,
    /// <p>The policy usage method to use for filtering the results.</p> <p>To list only permissions policies, set <code>PolicyUsageFilter</code> to <code>PermissionsPolicy</code>. To list only the policies used to set permissions boundaries, set the value to <code>PermissionsBoundary</code>.</p> <p>This parameter is optional. If it is not included, all policies are returned. </p>
    pub policy_usage_filter: Option<String>,
}

/// Serialize `ListEntitiesForPolicyRequest` contents to a `SignedRequest`.
struct ListEntitiesForPolicyRequestSerializer;
impl ListEntitiesForPolicyRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ListEntitiesForPolicyRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.entity_filter {
            params.put(&format!("{}{}", prefix, "EntityFilter"), &field_value);
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_items {
            params.put(&format!("{}{}", prefix, "MaxItems"), &field_value);
        }
        if let Some(ref field_value) = obj.path_prefix {
            params.put(&format!("{}{}", prefix, "PathPrefix"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "PolicyArn"), &obj.policy_arn);
        if let Some(ref field_value) = obj.policy_usage_filter {
            params.put(&format!("{}{}", prefix, "PolicyUsageFilter"), &field_value);
        }
    }
}

/// <p>Contains the response to a successful <a>ListEntitiesForPolicy</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ListEntitiesForPolicyResponse {
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: Option<bool>,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: Option<String>,
    /// <p>A list of IAM groups that the policy is attached to.</p>
    pub policy_groups: Option<Vec<PolicyGroup>>,
    /// <p>A list of IAM roles that the policy is attached to.</p>
    pub policy_roles: Option<Vec<PolicyRole>>,
    /// <p>A list of IAM users that the policy is attached to.</p>
    pub policy_users: Option<Vec<PolicyUser>>,
}

#[allow(dead_code)]
struct ListEntitiesForPolicyResponseDeserializer;
impl ListEntitiesForPolicyResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ListEntitiesForPolicyResponse, XmlParseError> {
        deserialize_elements::<_, ListEntitiesForPolicyResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "IsTruncated" => {
                        obj.is_truncated =
                            Some(BooleanTypeDeserializer::deserialize("IsTruncated", stack)?);
                    }
                    "Marker" => {
                        obj.marker = Some(ResponseMarkerTypeDeserializer::deserialize(
                            "Marker", stack,
                        )?);
                    }
                    "PolicyGroups" => {
                        obj.policy_groups.get_or_insert(vec![]).extend(
                            PolicyGroupListTypeDeserializer::deserialize("PolicyGroups", stack)?,
                        );
                    }
                    "PolicyRoles" => {
                        obj.policy_roles.get_or_insert(vec![]).extend(
                            PolicyRoleListTypeDeserializer::deserialize("PolicyRoles", stack)?,
                        );
                    }
                    "PolicyUsers" => {
                        obj.policy_users.get_or_insert(vec![]).extend(
                            PolicyUserListTypeDeserializer::deserialize("PolicyUsers", stack)?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListGroupPoliciesRequest {
    /// <p>The name of the group to list policies for.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub group_name: String,
    /// <p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>
    pub marker: Option<String>,
    /// <p>Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>
    pub max_items: Option<i64>,
}

/// Serialize `ListGroupPoliciesRequest` contents to a `SignedRequest`.
struct ListGroupPoliciesRequestSerializer;
impl ListGroupPoliciesRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ListGroupPoliciesRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "GroupName"), &obj.group_name);
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_items {
            params.put(&format!("{}{}", prefix, "MaxItems"), &field_value);
        }
    }
}

/// <p>Contains the response to a successful <a>ListGroupPolicies</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ListGroupPoliciesResponse {
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: Option<bool>,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: Option<String>,
    /// <p>A list of policy names.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub policy_names: Vec<String>,
}

#[allow(dead_code)]
struct ListGroupPoliciesResponseDeserializer;
impl ListGroupPoliciesResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ListGroupPoliciesResponse, XmlParseError> {
        deserialize_elements::<_, ListGroupPoliciesResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "IsTruncated" => {
                        obj.is_truncated =
                            Some(BooleanTypeDeserializer::deserialize("IsTruncated", stack)?);
                    }
                    "Marker" => {
                        obj.marker = Some(ResponseMarkerTypeDeserializer::deserialize(
                            "Marker", stack,
                        )?);
                    }
                    "PolicyNames" => {
                        obj.policy_names
                            .extend(PolicyNameListTypeDeserializer::deserialize(
                                "PolicyNames",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListGroupsForUserRequest {
    /// <p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>
    pub marker: Option<String>,
    /// <p>Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>
    pub max_items: Option<i64>,
    /// <p>The name of the user to list groups for.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub user_name: String,
}

/// Serialize `ListGroupsForUserRequest` contents to a `SignedRequest`.
struct ListGroupsForUserRequestSerializer;
impl ListGroupsForUserRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ListGroupsForUserRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_items {
            params.put(&format!("{}{}", prefix, "MaxItems"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "UserName"), &obj.user_name);
    }
}

/// <p>Contains the response to a successful <a>ListGroupsForUser</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ListGroupsForUserResponse {
    /// <p>A list of groups.</p>
    pub groups: Vec<Group>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: Option<bool>,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: Option<String>,
}

#[allow(dead_code)]
struct ListGroupsForUserResponseDeserializer;
impl ListGroupsForUserResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ListGroupsForUserResponse, XmlParseError> {
        deserialize_elements::<_, ListGroupsForUserResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Groups" => {
                        obj.groups
                            .extend(GroupListTypeDeserializer::deserialize("Groups", stack)?);
                    }
                    "IsTruncated" => {
                        obj.is_truncated =
                            Some(BooleanTypeDeserializer::deserialize("IsTruncated", stack)?);
                    }
                    "Marker" => {
                        obj.marker = Some(ResponseMarkerTypeDeserializer::deserialize(
                            "Marker", stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListGroupsRequest {
    /// <p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>
    pub marker: Option<String>,
    /// <p>Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>
    pub max_items: Option<i64>,
    /// <p> The path prefix for filtering the results. For example, the prefix <code>/division_abc/subdivision_xyz/</code> gets all groups whose path starts with <code>/division_abc/subdivision_xyz/</code>.</p> <p>This parameter is optional. If it is not included, it defaults to a slash (/), listing all groups. This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes. In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including most punctuation characters, digits, and upper and lowercased letters.</p>
    pub path_prefix: Option<String>,
}

/// Serialize `ListGroupsRequest` contents to a `SignedRequest`.
struct ListGroupsRequestSerializer;
impl ListGroupsRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ListGroupsRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_items {
            params.put(&format!("{}{}", prefix, "MaxItems"), &field_value);
        }
        if let Some(ref field_value) = obj.path_prefix {
            params.put(&format!("{}{}", prefix, "PathPrefix"), &field_value);
        }
    }
}

/// <p>Contains the response to a successful <a>ListGroups</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ListGroupsResponse {
    /// <p>A list of groups.</p>
    pub groups: Vec<Group>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: Option<bool>,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: Option<String>,
}

#[allow(dead_code)]
struct ListGroupsResponseDeserializer;
impl ListGroupsResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ListGroupsResponse, XmlParseError> {
        deserialize_elements::<_, ListGroupsResponse, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Groups" => {
                    obj.groups
                        .extend(GroupListTypeDeserializer::deserialize("Groups", stack)?);
                }
                "IsTruncated" => {
                    obj.is_truncated =
                        Some(BooleanTypeDeserializer::deserialize("IsTruncated", stack)?);
                }
                "Marker" => {
                    obj.marker = Some(ResponseMarkerTypeDeserializer::deserialize(
                        "Marker", stack,
                    )?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListInstanceProfileTagsRequest {
    /// <p>The name of the IAM instance profile whose tags you want to see.</p> <p>This parameter accepts (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that consist of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>
    pub instance_profile_name: String,
    /// <p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>
    pub marker: Option<String>,
    /// <p>(Optional) Use this only when paginating results to indicate the maximum number of items that you want in the response. If additional items exist beyond the maximum that you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, it defaults to 100. Note that IAM might return fewer results, even when more results are available. In that case, the <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>
    pub max_items: Option<i64>,
}

/// Serialize `ListInstanceProfileTagsRequest` contents to a `SignedRequest`.
struct ListInstanceProfileTagsRequestSerializer;
impl ListInstanceProfileTagsRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ListInstanceProfileTagsRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "InstanceProfileName"),
            &obj.instance_profile_name,
        );
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_items {
            params.put(&format!("{}{}", prefix, "MaxItems"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ListInstanceProfileTagsResponse {
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can use the <code>Marker</code> request parameter to make a subsequent pagination request that retrieves more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when more results are available. Check <code>IsTruncated</code> after every call to ensure that you receive all of your results.</p>
    pub is_truncated: Option<bool>,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: Option<String>,
    /// <p>The list of tags that are currently attached to the IAM instance profile. Each tag consists of a key name and an associated value. If no tags are attached to the specified resource, the response contains an empty list.</p>
    pub tags: Vec<Tag>,
}

#[allow(dead_code)]
struct ListInstanceProfileTagsResponseDeserializer;
impl ListInstanceProfileTagsResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ListInstanceProfileTagsResponse, XmlParseError> {
        deserialize_elements::<_, ListInstanceProfileTagsResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "IsTruncated" => {
                        obj.is_truncated =
                            Some(BooleanTypeDeserializer::deserialize("IsTruncated", stack)?);
                    }
                    "Marker" => {
                        obj.marker = Some(ResponseMarkerTypeDeserializer::deserialize(
                            "Marker", stack,
                        )?);
                    }
                    "Tags" => {
                        obj.tags
                            .extend(TagListTypeDeserializer::deserialize("Tags", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListInstanceProfilesForRoleRequest {
    /// <p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>
    pub marker: Option<String>,
    /// <p>Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>
    pub max_items: Option<i64>,
    /// <p>The name of the role to list instance profiles for.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub role_name: String,
}

/// Serialize `ListInstanceProfilesForRoleRequest` contents to a `SignedRequest`.
struct ListInstanceProfilesForRoleRequestSerializer;
impl ListInstanceProfilesForRoleRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ListInstanceProfilesForRoleRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_items {
            params.put(&format!("{}{}", prefix, "MaxItems"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "RoleName"), &obj.role_name);
    }
}

/// <p>Contains the response to a successful <a>ListInstanceProfilesForRole</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ListInstanceProfilesForRoleResponse {
    /// <p>A list of instance profiles.</p>
    pub instance_profiles: Vec<InstanceProfile>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: Option<bool>,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: Option<String>,
}

#[allow(dead_code)]
struct ListInstanceProfilesForRoleResponseDeserializer;
impl ListInstanceProfilesForRoleResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ListInstanceProfilesForRoleResponse, XmlParseError> {
        deserialize_elements::<_, ListInstanceProfilesForRoleResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "InstanceProfiles" => {
                        obj.instance_profiles.extend(
                            InstanceProfileListTypeDeserializer::deserialize(
                                "InstanceProfiles",
                                stack,
                            )?,
                        );
                    }
                    "IsTruncated" => {
                        obj.is_truncated =
                            Some(BooleanTypeDeserializer::deserialize("IsTruncated", stack)?);
                    }
                    "Marker" => {
                        obj.marker = Some(ResponseMarkerTypeDeserializer::deserialize(
                            "Marker", stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListInstanceProfilesRequest {
    /// <p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>
    pub marker: Option<String>,
    /// <p>Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>
    pub max_items: Option<i64>,
    /// <p> The path prefix for filtering the results. For example, the prefix <code>/application_abc/component_xyz/</code> gets all instance profiles whose path starts with <code>/application_abc/component_xyz/</code>.</p> <p>This parameter is optional. If it is not included, it defaults to a slash (/), listing all instance profiles. This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes. In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including most punctuation characters, digits, and upper and lowercased letters.</p>
    pub path_prefix: Option<String>,
}

/// Serialize `ListInstanceProfilesRequest` contents to a `SignedRequest`.
struct ListInstanceProfilesRequestSerializer;
impl ListInstanceProfilesRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ListInstanceProfilesRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_items {
            params.put(&format!("{}{}", prefix, "MaxItems"), &field_value);
        }
        if let Some(ref field_value) = obj.path_prefix {
            params.put(&format!("{}{}", prefix, "PathPrefix"), &field_value);
        }
    }
}

/// <p>Contains the response to a successful <a>ListInstanceProfiles</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ListInstanceProfilesResponse {
    /// <p>A list of instance profiles.</p>
    pub instance_profiles: Vec<InstanceProfile>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: Option<bool>,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: Option<String>,
}

#[allow(dead_code)]
struct ListInstanceProfilesResponseDeserializer;
impl ListInstanceProfilesResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ListInstanceProfilesResponse, XmlParseError> {
        deserialize_elements::<_, ListInstanceProfilesResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "InstanceProfiles" => {
                        obj.instance_profiles.extend(
                            InstanceProfileListTypeDeserializer::deserialize(
                                "InstanceProfiles",
                                stack,
                            )?,
                        );
                    }
                    "IsTruncated" => {
                        obj.is_truncated =
                            Some(BooleanTypeDeserializer::deserialize("IsTruncated", stack)?);
                    }
                    "Marker" => {
                        obj.marker = Some(ResponseMarkerTypeDeserializer::deserialize(
                            "Marker", stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListMFADeviceTagsRequest {
    /// <p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>
    pub marker: Option<String>,
    /// <p>(Optional) Use this only when paginating results to indicate the maximum number of items that you want in the response. If additional items exist beyond the maximum that you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, it defaults to 100. Note that IAM might return fewer results, even when more results are available. In that case, the <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>
    pub max_items: Option<i64>,
    /// <p>The unique identifier for the IAM virtual MFA device whose tags you want to see. For virtual MFA devices, the serial number is the same as the ARN.</p> <p>This parameter accepts (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that consist of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>
    pub serial_number: String,
}

/// Serialize `ListMFADeviceTagsRequest` contents to a `SignedRequest`.
struct ListMFADeviceTagsRequestSerializer;
impl ListMFADeviceTagsRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ListMFADeviceTagsRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_items {
            params.put(&format!("{}{}", prefix, "MaxItems"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "SerialNumber"), &obj.serial_number);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ListMFADeviceTagsResponse {
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can use the <code>Marker</code> request parameter to make a subsequent pagination request that retrieves more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when more results are available. Check <code>IsTruncated</code> after every call to ensure that you receive all of your results.</p>
    pub is_truncated: Option<bool>,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: Option<String>,
    /// <p>The list of tags that are currently attached to the virtual MFA device. Each tag consists of a key name and an associated value. If no tags are attached to the specified resource, the response contains an empty list.</p>
    pub tags: Vec<Tag>,
}

#[allow(dead_code)]
struct ListMFADeviceTagsResponseDeserializer;
impl ListMFADeviceTagsResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ListMFADeviceTagsResponse, XmlParseError> {
        deserialize_elements::<_, ListMFADeviceTagsResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "IsTruncated" => {
                        obj.is_truncated =
                            Some(BooleanTypeDeserializer::deserialize("IsTruncated", stack)?);
                    }
                    "Marker" => {
                        obj.marker = Some(ResponseMarkerTypeDeserializer::deserialize(
                            "Marker", stack,
                        )?);
                    }
                    "Tags" => {
                        obj.tags
                            .extend(TagListTypeDeserializer::deserialize("Tags", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListMFADevicesRequest {
    /// <p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>
    pub marker: Option<String>,
    /// <p>Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>
    pub max_items: Option<i64>,
    /// <p>The name of the user whose MFA devices you want to list.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub user_name: Option<String>,
}

/// Serialize `ListMFADevicesRequest` contents to a `SignedRequest`.
struct ListMFADevicesRequestSerializer;
impl ListMFADevicesRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ListMFADevicesRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_items {
            params.put(&format!("{}{}", prefix, "MaxItems"), &field_value);
        }
        if let Some(ref field_value) = obj.user_name {
            params.put(&format!("{}{}", prefix, "UserName"), &field_value);
        }
    }
}

/// <p>Contains the response to a successful <a>ListMFADevices</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ListMFADevicesResponse {
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: Option<bool>,
    /// <p>A list of MFA devices.</p>
    pub mfa_devices: Vec<MFADevice>,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: Option<String>,
}

#[allow(dead_code)]
struct ListMFADevicesResponseDeserializer;
impl ListMFADevicesResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ListMFADevicesResponse, XmlParseError> {
        deserialize_elements::<_, ListMFADevicesResponse, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "IsTruncated" => {
                    obj.is_truncated =
                        Some(BooleanTypeDeserializer::deserialize("IsTruncated", stack)?);
                }
                "MFADevices" => {
                    obj.mfa_devices
                        .extend(MfaDeviceListTypeDeserializer::deserialize(
                            "MFADevices",
                            stack,
                        )?);
                }
                "Marker" => {
                    obj.marker = Some(ResponseMarkerTypeDeserializer::deserialize(
                        "Marker", stack,
                    )?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListOpenIDConnectProviderTagsRequest {
    /// <p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>
    pub marker: Option<String>,
    /// <p>(Optional) Use this only when paginating results to indicate the maximum number of items that you want in the response. If additional items exist beyond the maximum that you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, it defaults to 100. Note that IAM might return fewer results, even when more results are available. In that case, the <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>
    pub max_items: Option<i64>,
    /// <p>The ARN of the OpenID Connect (OIDC) identity provider whose tags you want to see.</p> <p>This parameter accepts (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that consist of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>
    pub open_id_connect_provider_arn: String,
}

/// Serialize `ListOpenIDConnectProviderTagsRequest` contents to a `SignedRequest`.
struct ListOpenIDConnectProviderTagsRequestSerializer;
impl ListOpenIDConnectProviderTagsRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ListOpenIDConnectProviderTagsRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_items {
            params.put(&format!("{}{}", prefix, "MaxItems"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "OpenIDConnectProviderArn"),
            &obj.open_id_connect_provider_arn,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ListOpenIDConnectProviderTagsResponse {
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can use the <code>Marker</code> request parameter to make a subsequent pagination request that retrieves more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when more results are available. Check <code>IsTruncated</code> after every call to ensure that you receive all of your results.</p>
    pub is_truncated: Option<bool>,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: Option<String>,
    /// <p>The list of tags that are currently attached to the OpenID Connect (OIDC) identity provider. Each tag consists of a key name and an associated value. If no tags are attached to the specified resource, the response contains an empty list.</p>
    pub tags: Vec<Tag>,
}

#[allow(dead_code)]
struct ListOpenIDConnectProviderTagsResponseDeserializer;
impl ListOpenIDConnectProviderTagsResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ListOpenIDConnectProviderTagsResponse, XmlParseError> {
        deserialize_elements::<_, ListOpenIDConnectProviderTagsResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "IsTruncated" => {
                        obj.is_truncated =
                            Some(BooleanTypeDeserializer::deserialize("IsTruncated", stack)?);
                    }
                    "Marker" => {
                        obj.marker = Some(ResponseMarkerTypeDeserializer::deserialize(
                            "Marker", stack,
                        )?);
                    }
                    "Tags" => {
                        obj.tags
                            .extend(TagListTypeDeserializer::deserialize("Tags", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListOpenIDConnectProvidersRequest {}

/// Serialize `ListOpenIDConnectProvidersRequest` contents to a `SignedRequest`.
struct ListOpenIDConnectProvidersRequestSerializer;
impl ListOpenIDConnectProvidersRequestSerializer {
    fn serialize(_params: &mut Params, name: &str, _obj: &ListOpenIDConnectProvidersRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }
    }
}

/// <p>Contains the response to a successful <a>ListOpenIDConnectProviders</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ListOpenIDConnectProvidersResponse {
    /// <p>The list of IAM OIDC provider resource objects defined in the AWS account.</p>
    pub open_id_connect_provider_list: Option<Vec<OpenIDConnectProviderListEntry>>,
}

#[allow(dead_code)]
struct ListOpenIDConnectProvidersResponseDeserializer;
impl ListOpenIDConnectProvidersResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ListOpenIDConnectProvidersResponse, XmlParseError> {
        deserialize_elements::<_, ListOpenIDConnectProvidersResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "OpenIDConnectProviderList" => {
                        obj.open_id_connect_provider_list
                            .get_or_insert(vec![])
                            .extend(OpenIDConnectProviderListTypeDeserializer::deserialize(
                                "OpenIDConnectProviderList",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Contains details about the permissions policies that are attached to the specified identity (user, group, or role).</p> <p>This data type is used as a response element in the <a>ListPoliciesGrantingServiceAccess</a> operation.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ListPoliciesGrantingServiceAccessEntry {
    /// <p>The <code>PoliciesGrantingServiceAccess</code> object that contains details about the policy.</p>
    pub policies: Option<Vec<PolicyGrantingServiceAccess>>,
    /// <p>The namespace of the service that was accessed.</p> <p>To learn the service namespace of a service, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html">Actions, resources, and condition keys for AWS services</a> in the <i>Service Authorization Reference</i>. Choose the name of the service to view details for that service. In the first paragraph, find the service prefix. For example, <code>(service prefix: a4b)</code>. For more information about service namespaces, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces">AWS service namespaces</a> in the <i>AWS General Reference</i>.</p>
    pub service_namespace: Option<String>,
}

#[allow(dead_code)]
struct ListPoliciesGrantingServiceAccessEntryDeserializer;
impl ListPoliciesGrantingServiceAccessEntryDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ListPoliciesGrantingServiceAccessEntry, XmlParseError> {
        deserialize_elements::<_, ListPoliciesGrantingServiceAccessEntry, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Policies" => {
                        obj.policies.get_or_insert(vec![]).extend(
                            PolicyGrantingServiceAccessListTypeDeserializer::deserialize(
                                "Policies", stack,
                            )?,
                        );
                    }
                    "ServiceNamespace" => {
                        obj.service_namespace =
                            Some(ServiceNamespaceTypeDeserializer::deserialize(
                                "ServiceNamespace",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListPoliciesGrantingServiceAccessRequest {
    /// <p>The ARN of the IAM identity (user, group, or role) whose policies you want to list.</p>
    pub arn: String,
    /// <p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>
    pub marker: Option<String>,
    /// <p>The service namespace for the AWS services whose policies you want to list.</p> <p>To learn the service namespace for a service, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html">Actions, resources, and condition keys for AWS services</a> in the <i>IAM User Guide</i>. Choose the name of the service to view details for that service. In the first paragraph, find the service prefix. For example, <code>(service prefix: a4b)</code>. For more information about service namespaces, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces">AWS service namespaces</a> in the <i>AWS General Reference</i>.</p>
    pub service_namespaces: Vec<String>,
}

/// Serialize `ListPoliciesGrantingServiceAccessRequest` contents to a `SignedRequest`.
struct ListPoliciesGrantingServiceAccessRequestSerializer;
impl ListPoliciesGrantingServiceAccessRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ListPoliciesGrantingServiceAccessRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "Arn"), &obj.arn);
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        ServiceNamespaceListTypeSerializer::serialize(
            params,
            &format!("{}{}", prefix, "ServiceNamespaces"),
            &obj.service_namespaces,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ListPoliciesGrantingServiceAccessResponse {
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: Option<bool>,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: Option<String>,
    /// <p>A <code>ListPoliciesGrantingServiceAccess</code> object that contains details about the permissions policies attached to the specified identity (user, group, or role).</p>
    pub policies_granting_service_access: Vec<ListPoliciesGrantingServiceAccessEntry>,
}

#[allow(dead_code)]
struct ListPoliciesGrantingServiceAccessResponseDeserializer;
impl ListPoliciesGrantingServiceAccessResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ListPoliciesGrantingServiceAccessResponse, XmlParseError> {
        deserialize_elements::<_, ListPoliciesGrantingServiceAccessResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "IsTruncated" => {
                        obj.is_truncated =
                            Some(BooleanTypeDeserializer::deserialize("IsTruncated", stack)?);
                    }
                    "Marker" => {
                        obj.marker = Some(ResponseMarkerTypeDeserializer::deserialize(
                            "Marker", stack,
                        )?);
                    }
                    "PoliciesGrantingServiceAccess" => {
                        obj.policies_granting_service_access.extend(ListPolicyGrantingServiceAccessResponseListTypeDeserializer::deserialize("PoliciesGrantingServiceAccess", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListPoliciesRequest {
    /// <p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>
    pub marker: Option<String>,
    /// <p>Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>
    pub max_items: Option<i64>,
    /// <p>A flag to filter the results to only the attached policies.</p> <p>When <code>OnlyAttached</code> is <code>true</code>, the returned list contains only the policies that are attached to an IAM user, group, or role. When <code>OnlyAttached</code> is <code>false</code>, or when the parameter is not included, all policies are returned.</p>
    pub only_attached: Option<bool>,
    /// <p>The path prefix for filtering the results. This parameter is optional. If it is not included, it defaults to a slash (/), listing all policies. This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes. In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including most punctuation characters, digits, and upper and lowercased letters.</p>
    pub path_prefix: Option<String>,
    /// <p>The policy usage method to use for filtering the results.</p> <p>To list only permissions policies, set <code>PolicyUsageFilter</code> to <code>PermissionsPolicy</code>. To list only the policies used to set permissions boundaries, set the value to <code>PermissionsBoundary</code>.</p> <p>This parameter is optional. If it is not included, all policies are returned. </p>
    pub policy_usage_filter: Option<String>,
    /// <p>The scope to use for filtering the results.</p> <p>To list only AWS managed policies, set <code>Scope</code> to <code>AWS</code>. To list only the customer managed policies in your AWS account, set <code>Scope</code> to <code>Local</code>.</p> <p>This parameter is optional. If it is not included, or if it is set to <code>All</code>, all policies are returned.</p>
    pub scope: Option<String>,
}

/// Serialize `ListPoliciesRequest` contents to a `SignedRequest`.
struct ListPoliciesRequestSerializer;
impl ListPoliciesRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ListPoliciesRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_items {
            params.put(&format!("{}{}", prefix, "MaxItems"), &field_value);
        }
        if let Some(ref field_value) = obj.only_attached {
            params.put(&format!("{}{}", prefix, "OnlyAttached"), &field_value);
        }
        if let Some(ref field_value) = obj.path_prefix {
            params.put(&format!("{}{}", prefix, "PathPrefix"), &field_value);
        }
        if let Some(ref field_value) = obj.policy_usage_filter {
            params.put(&format!("{}{}", prefix, "PolicyUsageFilter"), &field_value);
        }
        if let Some(ref field_value) = obj.scope {
            params.put(&format!("{}{}", prefix, "Scope"), &field_value);
        }
    }
}

/// <p>Contains the response to a successful <a>ListPolicies</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ListPoliciesResponse {
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: Option<bool>,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: Option<String>,
    /// <p>A list of policies.</p>
    pub policies: Option<Vec<Policy>>,
}

#[allow(dead_code)]
struct ListPoliciesResponseDeserializer;
impl ListPoliciesResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ListPoliciesResponse, XmlParseError> {
        deserialize_elements::<_, ListPoliciesResponse, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "IsTruncated" => {
                    obj.is_truncated =
                        Some(BooleanTypeDeserializer::deserialize("IsTruncated", stack)?);
                }
                "Marker" => {
                    obj.marker = Some(ResponseMarkerTypeDeserializer::deserialize(
                        "Marker", stack,
                    )?);
                }
                "Policies" => {
                    obj.policies
                        .get_or_insert(vec![])
                        .extend(PolicyListTypeDeserializer::deserialize("Policies", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct ListPolicyGrantingServiceAccessResponseListTypeDeserializer;
impl ListPolicyGrantingServiceAccessResponseListTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<ListPoliciesGrantingServiceAccessEntry>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(
                    ListPoliciesGrantingServiceAccessEntryDeserializer::deserialize(
                        "member", stack,
                    )?,
                );
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListPolicyTagsRequest {
    /// <p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>
    pub marker: Option<String>,
    /// <p>(Optional) Use this only when paginating results to indicate the maximum number of items that you want in the response. If additional items exist beyond the maximum that you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, it defaults to 100. Note that IAM might return fewer results, even when more results are available. In that case, the <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>
    pub max_items: Option<i64>,
    /// <p>The ARN of the IAM customer managed policy whose tags you want to see.</p> <p>This parameter accepts (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that consist of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>
    pub policy_arn: String,
}

/// Serialize `ListPolicyTagsRequest` contents to a `SignedRequest`.
struct ListPolicyTagsRequestSerializer;
impl ListPolicyTagsRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ListPolicyTagsRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_items {
            params.put(&format!("{}{}", prefix, "MaxItems"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "PolicyArn"), &obj.policy_arn);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ListPolicyTagsResponse {
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can use the <code>Marker</code> request parameter to make a subsequent pagination request that retrieves more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when more results are available. Check <code>IsTruncated</code> after every call to ensure that you receive all of your results.</p>
    pub is_truncated: Option<bool>,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: Option<String>,
    /// <p>The list of tags that are currently attached to the IAM customer managed policy. Each tag consists of a key name and an associated value. If no tags are attached to the specified resource, the response contains an empty list.</p>
    pub tags: Vec<Tag>,
}

#[allow(dead_code)]
struct ListPolicyTagsResponseDeserializer;
impl ListPolicyTagsResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ListPolicyTagsResponse, XmlParseError> {
        deserialize_elements::<_, ListPolicyTagsResponse, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "IsTruncated" => {
                    obj.is_truncated =
                        Some(BooleanTypeDeserializer::deserialize("IsTruncated", stack)?);
                }
                "Marker" => {
                    obj.marker = Some(ResponseMarkerTypeDeserializer::deserialize(
                        "Marker", stack,
                    )?);
                }
                "Tags" => {
                    obj.tags
                        .extend(TagListTypeDeserializer::deserialize("Tags", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListPolicyVersionsRequest {
    /// <p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>
    pub marker: Option<String>,
    /// <p>Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>
    pub max_items: Option<i64>,
    /// <p>The Amazon Resource Name (ARN) of the IAM policy for which you want the versions.</p> <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub policy_arn: String,
}

/// Serialize `ListPolicyVersionsRequest` contents to a `SignedRequest`.
struct ListPolicyVersionsRequestSerializer;
impl ListPolicyVersionsRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ListPolicyVersionsRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_items {
            params.put(&format!("{}{}", prefix, "MaxItems"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "PolicyArn"), &obj.policy_arn);
    }
}

/// <p>Contains the response to a successful <a>ListPolicyVersions</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ListPolicyVersionsResponse {
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: Option<bool>,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: Option<String>,
    /// <p>A list of policy versions.</p> <p>For more information about managed policy versions, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed policies</a> in the <i>IAM User Guide</i>.</p>
    pub versions: Option<Vec<PolicyVersion>>,
}

#[allow(dead_code)]
struct ListPolicyVersionsResponseDeserializer;
impl ListPolicyVersionsResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ListPolicyVersionsResponse, XmlParseError> {
        deserialize_elements::<_, ListPolicyVersionsResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "IsTruncated" => {
                        obj.is_truncated =
                            Some(BooleanTypeDeserializer::deserialize("IsTruncated", stack)?);
                    }
                    "Marker" => {
                        obj.marker = Some(ResponseMarkerTypeDeserializer::deserialize(
                            "Marker", stack,
                        )?);
                    }
                    "Versions" => {
                        obj.versions.get_or_insert(vec![]).extend(
                            PolicyDocumentVersionListTypeDeserializer::deserialize(
                                "Versions", stack,
                            )?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListRolePoliciesRequest {
    /// <p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>
    pub marker: Option<String>,
    /// <p>Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>
    pub max_items: Option<i64>,
    /// <p>The name of the role to list policies for.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub role_name: String,
}

/// Serialize `ListRolePoliciesRequest` contents to a `SignedRequest`.
struct ListRolePoliciesRequestSerializer;
impl ListRolePoliciesRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ListRolePoliciesRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_items {
            params.put(&format!("{}{}", prefix, "MaxItems"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "RoleName"), &obj.role_name);
    }
}

/// <p>Contains the response to a successful <a>ListRolePolicies</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ListRolePoliciesResponse {
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: Option<bool>,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: Option<String>,
    /// <p>A list of policy names.</p>
    pub policy_names: Vec<String>,
}

#[allow(dead_code)]
struct ListRolePoliciesResponseDeserializer;
impl ListRolePoliciesResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ListRolePoliciesResponse, XmlParseError> {
        deserialize_elements::<_, ListRolePoliciesResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "IsTruncated" => {
                        obj.is_truncated =
                            Some(BooleanTypeDeserializer::deserialize("IsTruncated", stack)?);
                    }
                    "Marker" => {
                        obj.marker = Some(ResponseMarkerTypeDeserializer::deserialize(
                            "Marker", stack,
                        )?);
                    }
                    "PolicyNames" => {
                        obj.policy_names
                            .extend(PolicyNameListTypeDeserializer::deserialize(
                                "PolicyNames",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListRoleTagsRequest {
    /// <p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>
    pub marker: Option<String>,
    /// <p>(Optional) Use this only when paginating results to indicate the maximum number of items that you want in the response. If additional items exist beyond the maximum that you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, it defaults to 100. Note that IAM might return fewer results, even when more results are available. In that case, the <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>
    pub max_items: Option<i64>,
    /// <p>The name of the IAM role for which you want to see the list of tags.</p> <p>This parameter accepts (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that consist of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub role_name: String,
}

/// Serialize `ListRoleTagsRequest` contents to a `SignedRequest`.
struct ListRoleTagsRequestSerializer;
impl ListRoleTagsRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ListRoleTagsRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_items {
            params.put(&format!("{}{}", prefix, "MaxItems"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "RoleName"), &obj.role_name);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ListRoleTagsResponse {
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can use the <code>Marker</code> request parameter to make a subsequent pagination request that retrieves more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when more results are available. Check <code>IsTruncated</code> after every call to ensure that you receive all of your results.</p>
    pub is_truncated: Option<bool>,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: Option<String>,
    /// <p>The list of tags that are currently attached to the role. Each tag consists of a key name and an associated value. If no tags are attached to the specified resource, the response contains an empty list.</p>
    pub tags: Vec<Tag>,
}

#[allow(dead_code)]
struct ListRoleTagsResponseDeserializer;
impl ListRoleTagsResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ListRoleTagsResponse, XmlParseError> {
        deserialize_elements::<_, ListRoleTagsResponse, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "IsTruncated" => {
                    obj.is_truncated =
                        Some(BooleanTypeDeserializer::deserialize("IsTruncated", stack)?);
                }
                "Marker" => {
                    obj.marker = Some(ResponseMarkerTypeDeserializer::deserialize(
                        "Marker", stack,
                    )?);
                }
                "Tags" => {
                    obj.tags
                        .extend(TagListTypeDeserializer::deserialize("Tags", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListRolesRequest {
    /// <p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>
    pub marker: Option<String>,
    /// <p>Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>
    pub max_items: Option<i64>,
    /// <p> The path prefix for filtering the results. For example, the prefix <code>/application_abc/component_xyz/</code> gets all roles whose path starts with <code>/application_abc/component_xyz/</code>.</p> <p>This parameter is optional. If it is not included, it defaults to a slash (/), listing all roles. This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes. In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including most punctuation characters, digits, and upper and lowercased letters.</p>
    pub path_prefix: Option<String>,
}

/// Serialize `ListRolesRequest` contents to a `SignedRequest`.
struct ListRolesRequestSerializer;
impl ListRolesRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ListRolesRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_items {
            params.put(&format!("{}{}", prefix, "MaxItems"), &field_value);
        }
        if let Some(ref field_value) = obj.path_prefix {
            params.put(&format!("{}{}", prefix, "PathPrefix"), &field_value);
        }
    }
}

/// <p>Contains the response to a successful <a>ListRoles</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ListRolesResponse {
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: Option<bool>,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: Option<String>,
    /// <p>A list of roles.</p>
    pub roles: Vec<Role>,
}

#[allow(dead_code)]
struct ListRolesResponseDeserializer;
impl ListRolesResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ListRolesResponse, XmlParseError> {
        deserialize_elements::<_, ListRolesResponse, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "IsTruncated" => {
                    obj.is_truncated =
                        Some(BooleanTypeDeserializer::deserialize("IsTruncated", stack)?);
                }
                "Marker" => {
                    obj.marker = Some(ResponseMarkerTypeDeserializer::deserialize(
                        "Marker", stack,
                    )?);
                }
                "Roles" => {
                    obj.roles
                        .extend(RoleListTypeDeserializer::deserialize("Roles", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListSAMLProviderTagsRequest {
    /// <p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>
    pub marker: Option<String>,
    /// <p>(Optional) Use this only when paginating results to indicate the maximum number of items that you want in the response. If additional items exist beyond the maximum that you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, it defaults to 100. Note that IAM might return fewer results, even when more results are available. In that case, the <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>
    pub max_items: Option<i64>,
    /// <p>The ARN of the Security Assertion Markup Language (SAML) identity provider whose tags you want to see.</p> <p>This parameter accepts (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that consist of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>
    pub saml_provider_arn: String,
}

/// Serialize `ListSAMLProviderTagsRequest` contents to a `SignedRequest`.
struct ListSAMLProviderTagsRequestSerializer;
impl ListSAMLProviderTagsRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ListSAMLProviderTagsRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_items {
            params.put(&format!("{}{}", prefix, "MaxItems"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "SAMLProviderArn"),
            &obj.saml_provider_arn,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ListSAMLProviderTagsResponse {
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can use the <code>Marker</code> request parameter to make a subsequent pagination request that retrieves more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when more results are available. Check <code>IsTruncated</code> after every call to ensure that you receive all of your results.</p>
    pub is_truncated: Option<bool>,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: Option<String>,
    /// <p>The list of tags that are currently attached to the Security Assertion Markup Language (SAML) identity provider. Each tag consists of a key name and an associated value. If no tags are attached to the specified resource, the response contains an empty list.</p>
    pub tags: Vec<Tag>,
}

#[allow(dead_code)]
struct ListSAMLProviderTagsResponseDeserializer;
impl ListSAMLProviderTagsResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ListSAMLProviderTagsResponse, XmlParseError> {
        deserialize_elements::<_, ListSAMLProviderTagsResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "IsTruncated" => {
                        obj.is_truncated =
                            Some(BooleanTypeDeserializer::deserialize("IsTruncated", stack)?);
                    }
                    "Marker" => {
                        obj.marker = Some(ResponseMarkerTypeDeserializer::deserialize(
                            "Marker", stack,
                        )?);
                    }
                    "Tags" => {
                        obj.tags
                            .extend(TagListTypeDeserializer::deserialize("Tags", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListSAMLProvidersRequest {}

/// Serialize `ListSAMLProvidersRequest` contents to a `SignedRequest`.
struct ListSAMLProvidersRequestSerializer;
impl ListSAMLProvidersRequestSerializer {
    fn serialize(_params: &mut Params, name: &str, _obj: &ListSAMLProvidersRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }
    }
}

/// <p>Contains the response to a successful <a>ListSAMLProviders</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ListSAMLProvidersResponse {
    /// <p>The list of SAML provider resource objects defined in IAM for this AWS account.</p>
    pub saml_provider_list: Option<Vec<SAMLProviderListEntry>>,
}

#[allow(dead_code)]
struct ListSAMLProvidersResponseDeserializer;
impl ListSAMLProvidersResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ListSAMLProvidersResponse, XmlParseError> {
        deserialize_elements::<_, ListSAMLProvidersResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "SAMLProviderList" => {
                        obj.saml_provider_list.get_or_insert(vec![]).extend(
                            SAMLProviderListTypeDeserializer::deserialize(
                                "SAMLProviderList",
                                stack,
                            )?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListSSHPublicKeysRequest {
    /// <p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>
    pub marker: Option<String>,
    /// <p>Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>
    pub max_items: Option<i64>,
    /// <p>The name of the IAM user to list SSH public keys for. If none is specified, the <code>UserName</code> field is determined implicitly based on the AWS access key used to sign the request.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub user_name: Option<String>,
}

/// Serialize `ListSSHPublicKeysRequest` contents to a `SignedRequest`.
struct ListSSHPublicKeysRequestSerializer;
impl ListSSHPublicKeysRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ListSSHPublicKeysRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_items {
            params.put(&format!("{}{}", prefix, "MaxItems"), &field_value);
        }
        if let Some(ref field_value) = obj.user_name {
            params.put(&format!("{}{}", prefix, "UserName"), &field_value);
        }
    }
}

/// <p>Contains the response to a successful <a>ListSSHPublicKeys</a> request.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ListSSHPublicKeysResponse {
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: Option<bool>,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: Option<String>,
    /// <p>A list of the SSH public keys assigned to IAM user.</p>
    pub ssh_public_keys: Option<Vec<SSHPublicKeyMetadata>>,
}

#[allow(dead_code)]
struct ListSSHPublicKeysResponseDeserializer;
impl ListSSHPublicKeysResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ListSSHPublicKeysResponse, XmlParseError> {
        deserialize_elements::<_, ListSSHPublicKeysResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "IsTruncated" => {
                        obj.is_truncated =
                            Some(BooleanTypeDeserializer::deserialize("IsTruncated", stack)?);
                    }
                    "Marker" => {
                        obj.marker = Some(ResponseMarkerTypeDeserializer::deserialize(
                            "Marker", stack,
                        )?);
                    }
                    "SSHPublicKeys" => {
                        obj.ssh_public_keys.get_or_insert(vec![]).extend(
                            SSHPublicKeyListTypeDeserializer::deserialize("SSHPublicKeys", stack)?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListServerCertificateTagsRequest {
    /// <p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>
    pub marker: Option<String>,
    /// <p>(Optional) Use this only when paginating results to indicate the maximum number of items that you want in the response. If additional items exist beyond the maximum that you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, it defaults to 100. Note that IAM might return fewer results, even when more results are available. In that case, the <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>
    pub max_items: Option<i64>,
    /// <p>The name of the IAM server certificate whose tags you want to see.</p> <p>This parameter accepts (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that consist of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>
    pub server_certificate_name: String,
}

/// Serialize `ListServerCertificateTagsRequest` contents to a `SignedRequest`.
struct ListServerCertificateTagsRequestSerializer;
impl ListServerCertificateTagsRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ListServerCertificateTagsRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_items {
            params.put(&format!("{}{}", prefix, "MaxItems"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "ServerCertificateName"),
            &obj.server_certificate_name,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ListServerCertificateTagsResponse {
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can use the <code>Marker</code> request parameter to make a subsequent pagination request that retrieves more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when more results are available. Check <code>IsTruncated</code> after every call to ensure that you receive all of your results.</p>
    pub is_truncated: Option<bool>,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: Option<String>,
    /// <p>The list of tags that are currently attached to the IAM server certificate. Each tag consists of a key name and an associated value. If no tags are attached to the specified resource, the response contains an empty list.</p>
    pub tags: Vec<Tag>,
}

#[allow(dead_code)]
struct ListServerCertificateTagsResponseDeserializer;
impl ListServerCertificateTagsResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ListServerCertificateTagsResponse, XmlParseError> {
        deserialize_elements::<_, ListServerCertificateTagsResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "IsTruncated" => {
                        obj.is_truncated =
                            Some(BooleanTypeDeserializer::deserialize("IsTruncated", stack)?);
                    }
                    "Marker" => {
                        obj.marker = Some(ResponseMarkerTypeDeserializer::deserialize(
                            "Marker", stack,
                        )?);
                    }
                    "Tags" => {
                        obj.tags
                            .extend(TagListTypeDeserializer::deserialize("Tags", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListServerCertificatesRequest {
    /// <p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>
    pub marker: Option<String>,
    /// <p>Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>
    pub max_items: Option<i64>,
    /// <p> The path prefix for filtering the results. For example: <code>/company/servercerts</code> would get all server certificates for which the path starts with <code>/company/servercerts</code>.</p> <p>This parameter is optional. If it is not included, it defaults to a slash (/), listing all server certificates. This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes. In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including most punctuation characters, digits, and upper and lowercased letters.</p>
    pub path_prefix: Option<String>,
}

/// Serialize `ListServerCertificatesRequest` contents to a `SignedRequest`.
struct ListServerCertificatesRequestSerializer;
impl ListServerCertificatesRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ListServerCertificatesRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_items {
            params.put(&format!("{}{}", prefix, "MaxItems"), &field_value);
        }
        if let Some(ref field_value) = obj.path_prefix {
            params.put(&format!("{}{}", prefix, "PathPrefix"), &field_value);
        }
    }
}

/// <p>Contains the response to a successful <a>ListServerCertificates</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ListServerCertificatesResponse {
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: Option<bool>,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: Option<String>,
    /// <p>A list of server certificates.</p>
    pub server_certificate_metadata_list: Vec<ServerCertificateMetadata>,
}

#[allow(dead_code)]
struct ListServerCertificatesResponseDeserializer;
impl ListServerCertificatesResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ListServerCertificatesResponse, XmlParseError> {
        deserialize_elements::<_, ListServerCertificatesResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "IsTruncated" => {
                        obj.is_truncated =
                            Some(BooleanTypeDeserializer::deserialize("IsTruncated", stack)?);
                    }
                    "Marker" => {
                        obj.marker = Some(ResponseMarkerTypeDeserializer::deserialize(
                            "Marker", stack,
                        )?);
                    }
                    "ServerCertificateMetadataList" => {
                        obj.server_certificate_metadata_list.extend(
                            ServerCertificateMetadataListTypeDeserializer::deserialize(
                                "ServerCertificateMetadataList",
                                stack,
                            )?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListServiceSpecificCredentialsRequest {
    /// <p>Filters the returned results to only those for the specified AWS service. If not specified, then AWS returns service-specific credentials for all services.</p>
    pub service_name: Option<String>,
    /// <p>The name of the user whose service-specific credentials you want information about. If this value is not specified, then the operation assumes the user whose credentials are used to call the operation.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub user_name: Option<String>,
}

/// Serialize `ListServiceSpecificCredentialsRequest` contents to a `SignedRequest`.
struct ListServiceSpecificCredentialsRequestSerializer;
impl ListServiceSpecificCredentialsRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ListServiceSpecificCredentialsRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.service_name {
            params.put(&format!("{}{}", prefix, "ServiceName"), &field_value);
        }
        if let Some(ref field_value) = obj.user_name {
            params.put(&format!("{}{}", prefix, "UserName"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ListServiceSpecificCredentialsResponse {
    /// <p>A list of structures that each contain details about a service-specific credential.</p>
    pub service_specific_credentials: Option<Vec<ServiceSpecificCredentialMetadata>>,
}

#[allow(dead_code)]
struct ListServiceSpecificCredentialsResponseDeserializer;
impl ListServiceSpecificCredentialsResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ListServiceSpecificCredentialsResponse, XmlParseError> {
        deserialize_elements::<_, ListServiceSpecificCredentialsResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "ServiceSpecificCredentials" => {
                        obj.service_specific_credentials
                            .get_or_insert(vec![])
                            .extend(ServiceSpecificCredentialsListTypeDeserializer::deserialize(
                                "ServiceSpecificCredentials",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListSigningCertificatesRequest {
    /// <p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>
    pub marker: Option<String>,
    /// <p>Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>
    pub max_items: Option<i64>,
    /// <p>The name of the IAM user whose signing certificates you want to examine.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub user_name: Option<String>,
}

/// Serialize `ListSigningCertificatesRequest` contents to a `SignedRequest`.
struct ListSigningCertificatesRequestSerializer;
impl ListSigningCertificatesRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ListSigningCertificatesRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_items {
            params.put(&format!("{}{}", prefix, "MaxItems"), &field_value);
        }
        if let Some(ref field_value) = obj.user_name {
            params.put(&format!("{}{}", prefix, "UserName"), &field_value);
        }
    }
}

/// <p>Contains the response to a successful <a>ListSigningCertificates</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ListSigningCertificatesResponse {
    /// <p>A list of the user's signing certificate information.</p>
    pub certificates: Vec<SigningCertificate>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: Option<bool>,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: Option<String>,
}

#[allow(dead_code)]
struct ListSigningCertificatesResponseDeserializer;
impl ListSigningCertificatesResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ListSigningCertificatesResponse, XmlParseError> {
        deserialize_elements::<_, ListSigningCertificatesResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Certificates" => {
                        obj.certificates
                            .extend(CertificateListTypeDeserializer::deserialize(
                                "Certificates",
                                stack,
                            )?);
                    }
                    "IsTruncated" => {
                        obj.is_truncated =
                            Some(BooleanTypeDeserializer::deserialize("IsTruncated", stack)?);
                    }
                    "Marker" => {
                        obj.marker = Some(ResponseMarkerTypeDeserializer::deserialize(
                            "Marker", stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListUserPoliciesRequest {
    /// <p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>
    pub marker: Option<String>,
    /// <p>Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>
    pub max_items: Option<i64>,
    /// <p>The name of the user to list policies for.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub user_name: String,
}

/// Serialize `ListUserPoliciesRequest` contents to a `SignedRequest`.
struct ListUserPoliciesRequestSerializer;
impl ListUserPoliciesRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ListUserPoliciesRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_items {
            params.put(&format!("{}{}", prefix, "MaxItems"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "UserName"), &obj.user_name);
    }
}

/// <p>Contains the response to a successful <a>ListUserPolicies</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ListUserPoliciesResponse {
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: Option<bool>,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: Option<String>,
    /// <p>A list of policy names.</p>
    pub policy_names: Vec<String>,
}

#[allow(dead_code)]
struct ListUserPoliciesResponseDeserializer;
impl ListUserPoliciesResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ListUserPoliciesResponse, XmlParseError> {
        deserialize_elements::<_, ListUserPoliciesResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "IsTruncated" => {
                        obj.is_truncated =
                            Some(BooleanTypeDeserializer::deserialize("IsTruncated", stack)?);
                    }
                    "Marker" => {
                        obj.marker = Some(ResponseMarkerTypeDeserializer::deserialize(
                            "Marker", stack,
                        )?);
                    }
                    "PolicyNames" => {
                        obj.policy_names
                            .extend(PolicyNameListTypeDeserializer::deserialize(
                                "PolicyNames",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListUserTagsRequest {
    /// <p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>
    pub marker: Option<String>,
    /// <p>(Optional) Use this only when paginating results to indicate the maximum number of items that you want in the response. If additional items exist beyond the maximum that you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, it defaults to 100. Note that IAM might return fewer results, even when more results are available. In that case, the <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>
    pub max_items: Option<i64>,
    /// <p>The name of the IAM user whose tags you want to see.</p> <p>This parameter accepts (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that consist of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>
    pub user_name: String,
}

/// Serialize `ListUserTagsRequest` contents to a `SignedRequest`.
struct ListUserTagsRequestSerializer;
impl ListUserTagsRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ListUserTagsRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_items {
            params.put(&format!("{}{}", prefix, "MaxItems"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "UserName"), &obj.user_name);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ListUserTagsResponse {
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can use the <code>Marker</code> request parameter to make a subsequent pagination request that retrieves more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when more results are available. Check <code>IsTruncated</code> after every call to ensure that you receive all of your results.</p>
    pub is_truncated: Option<bool>,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: Option<String>,
    /// <p>The list of tags that are currently attached to the user. Each tag consists of a key name and an associated value. If no tags are attached to the specified resource, the response contains an empty list.</p>
    pub tags: Vec<Tag>,
}

#[allow(dead_code)]
struct ListUserTagsResponseDeserializer;
impl ListUserTagsResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ListUserTagsResponse, XmlParseError> {
        deserialize_elements::<_, ListUserTagsResponse, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "IsTruncated" => {
                    obj.is_truncated =
                        Some(BooleanTypeDeserializer::deserialize("IsTruncated", stack)?);
                }
                "Marker" => {
                    obj.marker = Some(ResponseMarkerTypeDeserializer::deserialize(
                        "Marker", stack,
                    )?);
                }
                "Tags" => {
                    obj.tags
                        .extend(TagListTypeDeserializer::deserialize("Tags", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListUsersRequest {
    /// <p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>
    pub marker: Option<String>,
    /// <p>Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>
    pub max_items: Option<i64>,
    /// <p> The path prefix for filtering the results. For example: <code>/division_abc/subdivision_xyz/</code>, which would get all user names whose path starts with <code>/division_abc/subdivision_xyz/</code>.</p> <p>This parameter is optional. If it is not included, it defaults to a slash (/), listing all user names. This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes. In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including most punctuation characters, digits, and upper and lowercased letters.</p>
    pub path_prefix: Option<String>,
}

/// Serialize `ListUsersRequest` contents to a `SignedRequest`.
struct ListUsersRequestSerializer;
impl ListUsersRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ListUsersRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_items {
            params.put(&format!("{}{}", prefix, "MaxItems"), &field_value);
        }
        if let Some(ref field_value) = obj.path_prefix {
            params.put(&format!("{}{}", prefix, "PathPrefix"), &field_value);
        }
    }
}

/// <p>Contains the response to a successful <a>ListUsers</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ListUsersResponse {
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: Option<bool>,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: Option<String>,
    /// <p>A list of users.</p>
    pub users: Vec<User>,
}

#[allow(dead_code)]
struct ListUsersResponseDeserializer;
impl ListUsersResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ListUsersResponse, XmlParseError> {
        deserialize_elements::<_, ListUsersResponse, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "IsTruncated" => {
                    obj.is_truncated =
                        Some(BooleanTypeDeserializer::deserialize("IsTruncated", stack)?);
                }
                "Marker" => {
                    obj.marker = Some(ResponseMarkerTypeDeserializer::deserialize(
                        "Marker", stack,
                    )?);
                }
                "Users" => {
                    obj.users
                        .extend(UserListTypeDeserializer::deserialize("Users", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListVirtualMFADevicesRequest {
    /// <p> The status (<code>Unassigned</code> or <code>Assigned</code>) of the devices to list. If you do not specify an <code>AssignmentStatus</code>, the operation defaults to <code>Any</code>, which lists both assigned and unassigned virtual MFA devices.,</p>
    pub assignment_status: Option<String>,
    /// <p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>
    pub marker: Option<String>,
    /// <p>Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>
    pub max_items: Option<i64>,
}

/// Serialize `ListVirtualMFADevicesRequest` contents to a `SignedRequest`.
struct ListVirtualMFADevicesRequestSerializer;
impl ListVirtualMFADevicesRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ListVirtualMFADevicesRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.assignment_status {
            params.put(&format!("{}{}", prefix, "AssignmentStatus"), &field_value);
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_items {
            params.put(&format!("{}{}", prefix, "MaxItems"), &field_value);
        }
    }
}

/// <p>Contains the response to a successful <a>ListVirtualMFADevices</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ListVirtualMFADevicesResponse {
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: Option<bool>,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: Option<String>,
    /// <p> The list of virtual MFA devices in the current account that match the <code>AssignmentStatus</code> value that was passed in the request.</p>
    pub virtual_mfa_devices: Vec<VirtualMFADevice>,
}

#[allow(dead_code)]
struct ListVirtualMFADevicesResponseDeserializer;
impl ListVirtualMFADevicesResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ListVirtualMFADevicesResponse, XmlParseError> {
        deserialize_elements::<_, ListVirtualMFADevicesResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "IsTruncated" => {
                        obj.is_truncated =
                            Some(BooleanTypeDeserializer::deserialize("IsTruncated", stack)?);
                    }
                    "Marker" => {
                        obj.marker = Some(ResponseMarkerTypeDeserializer::deserialize(
                            "Marker", stack,
                        )?);
                    }
                    "VirtualMFADevices" => {
                        obj.virtual_mfa_devices.extend(
                            VirtualMFADeviceListTypeDeserializer::deserialize(
                                "VirtualMFADevices",
                                stack,
                            )?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Contains the user name and password create date for a user.</p> <p> This data type is used as a response element in the <a>CreateLoginProfile</a> and <a>GetLoginProfile</a> operations. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct LoginProfile {
    /// <p>The date when the password for the user was created.</p>
    pub create_date: String,
    /// <p>Specifies whether the user is required to set a new password on next sign-in.</p>
    pub password_reset_required: Option<bool>,
    /// <p>The name of the user, which can be used for signing in to the AWS Management Console.</p>
    pub user_name: String,
}

#[allow(dead_code)]
struct LoginProfileDeserializer;
impl LoginProfileDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<LoginProfile, XmlParseError> {
        deserialize_elements::<_, LoginProfile, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "CreateDate" => {
                    obj.create_date = DateTypeDeserializer::deserialize("CreateDate", stack)?;
                }
                "PasswordResetRequired" => {
                    obj.password_reset_required = Some(BooleanTypeDeserializer::deserialize(
                        "PasswordResetRequired",
                        stack,
                    )?);
                }
                "UserName" => {
                    obj.user_name = UserNameTypeDeserializer::deserialize("UserName", stack)?;
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>Contains information about an MFA device.</p> <p>This data type is used as a response element in the <a>ListMFADevices</a> operation.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct MFADevice {
    /// <p>The date when the MFA device was enabled for the user.</p>
    pub enable_date: String,
    /// <p>The serial number that uniquely identifies the MFA device. For virtual MFA devices, the serial number is the device ARN.</p>
    pub serial_number: String,
    /// <p>The user with whom the MFA device is associated.</p>
    pub user_name: String,
}

#[allow(dead_code)]
struct MFADeviceDeserializer;
impl MFADeviceDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<MFADevice, XmlParseError> {
        deserialize_elements::<_, MFADevice, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "EnableDate" => {
                    obj.enable_date = DateTypeDeserializer::deserialize("EnableDate", stack)?;
                }
                "SerialNumber" => {
                    obj.serial_number =
                        SerialNumberTypeDeserializer::deserialize("SerialNumber", stack)?;
                }
                "UserName" => {
                    obj.user_name = UserNameTypeDeserializer::deserialize("UserName", stack)?;
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>Contains information about a managed policy, including the policy's ARN, versions, and the number of principal entities (users, groups, and roles) that the policy is attached to.</p> <p>This data type is used as a response element in the <a>GetAccountAuthorizationDetails</a> operation.</p> <p>For more information about managed policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline policies</a> in the <i>IAM User Guide</i>. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ManagedPolicyDetail {
    pub arn: Option<String>,
    /// <p>The number of principal entities (users, groups, and roles) that the policy is attached to.</p>
    pub attachment_count: Option<i64>,
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the policy was created.</p>
    pub create_date: Option<String>,
    /// <p>The identifier for the version of the policy that is set as the default (operative) version.</p> <p>For more information about policy versions, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed policies</a> in the <i>IAM User Guide</i>. </p>
    pub default_version_id: Option<String>,
    /// <p>A friendly description of the policy.</p>
    pub description: Option<String>,
    /// <p>Specifies whether the policy can be attached to an IAM user, group, or role.</p>
    pub is_attachable: Option<bool>,
    /// <p>The path to the policy.</p> <p>For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the <i>IAM User Guide</i>.</p>
    pub path: Option<String>,
    /// <p>The number of entities (users and roles) for which the policy is used as the permissions boundary. </p> <p>For more information about permissions boundaries, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM identities </a> in the <i>IAM User Guide</i>.</p>
    pub permissions_boundary_usage_count: Option<i64>,
    /// <p>The stable and unique string identifying the policy.</p> <p>For more information about IDs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the <i>IAM User Guide</i>.</p>
    pub policy_id: Option<String>,
    /// <p>The friendly name (not ARN) identifying the policy.</p>
    pub policy_name: Option<String>,
    /// <p>A list containing information about the versions of the policy.</p>
    pub policy_version_list: Option<Vec<PolicyVersion>>,
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the policy was last updated.</p> <p>When a policy has only one version, this field contains the date and time when the policy was created. When a policy has more than one version, this field contains the date and time when the most recent policy version was created.</p>
    pub update_date: Option<String>,
}

#[allow(dead_code)]
struct ManagedPolicyDetailDeserializer;
impl ManagedPolicyDetailDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ManagedPolicyDetail, XmlParseError> {
        deserialize_elements::<_, ManagedPolicyDetail, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Arn" => {
                    obj.arn = Some(ArnTypeDeserializer::deserialize("Arn", stack)?);
                }
                "AttachmentCount" => {
                    obj.attachment_count = Some(AttachmentCountTypeDeserializer::deserialize(
                        "AttachmentCount",
                        stack,
                    )?);
                }
                "CreateDate" => {
                    obj.create_date = Some(DateTypeDeserializer::deserialize("CreateDate", stack)?);
                }
                "DefaultVersionId" => {
                    obj.default_version_id = Some(PolicyVersionIdTypeDeserializer::deserialize(
                        "DefaultVersionId",
                        stack,
                    )?);
                }
                "Description" => {
                    obj.description = Some(PolicyDescriptionTypeDeserializer::deserialize(
                        "Description",
                        stack,
                    )?);
                }
                "IsAttachable" => {
                    obj.is_attachable =
                        Some(BooleanTypeDeserializer::deserialize("IsAttachable", stack)?);
                }
                "Path" => {
                    obj.path = Some(PolicyPathTypeDeserializer::deserialize("Path", stack)?);
                }
                "PermissionsBoundaryUsageCount" => {
                    obj.permissions_boundary_usage_count =
                        Some(AttachmentCountTypeDeserializer::deserialize(
                            "PermissionsBoundaryUsageCount",
                            stack,
                        )?);
                }
                "PolicyId" => {
                    obj.policy_id = Some(IdTypeDeserializer::deserialize("PolicyId", stack)?);
                }
                "PolicyName" => {
                    obj.policy_name = Some(PolicyNameTypeDeserializer::deserialize(
                        "PolicyName",
                        stack,
                    )?);
                }
                "PolicyVersionList" => {
                    obj.policy_version_list.get_or_insert(vec![]).extend(
                        PolicyDocumentVersionListTypeDeserializer::deserialize(
                            "PolicyVersionList",
                            stack,
                        )?,
                    );
                }
                "UpdateDate" => {
                    obj.update_date = Some(DateTypeDeserializer::deserialize("UpdateDate", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct ManagedPolicyDetailListTypeDeserializer;
impl ManagedPolicyDetailListTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<ManagedPolicyDetail>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(ManagedPolicyDetailDeserializer::deserialize(
                    "member", stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct MarkerTypeDeserializer;
impl MarkerTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct MaxPasswordAgeTypeDeserializer;
impl MaxPasswordAgeTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<i64, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, |s| Ok(i64::from_str(&s).unwrap()))
    }
}
#[allow(dead_code)]
struct MfaDeviceListTypeDeserializer;
impl MfaDeviceListTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<MFADevice>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(MFADeviceDeserializer::deserialize("member", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct MinimumPasswordLengthTypeDeserializer;
impl MinimumPasswordLengthTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<i64, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, |s| Ok(i64::from_str(&s).unwrap()))
    }
}
/// <p>Contains the Amazon Resource Name (ARN) for an IAM OpenID Connect provider.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct OpenIDConnectProviderListEntry {
    pub arn: Option<String>,
}

#[allow(dead_code)]
struct OpenIDConnectProviderListEntryDeserializer;
impl OpenIDConnectProviderListEntryDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<OpenIDConnectProviderListEntry, XmlParseError> {
        deserialize_elements::<_, OpenIDConnectProviderListEntry, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Arn" => {
                        obj.arn = Some(ArnTypeDeserializer::deserialize("Arn", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct OpenIDConnectProviderListTypeDeserializer;
impl OpenIDConnectProviderListTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<OpenIDConnectProviderListEntry>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(OpenIDConnectProviderListEntryDeserializer::deserialize(
                    "member", stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct OpenIDConnectProviderUrlTypeDeserializer;
impl OpenIDConnectProviderUrlTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p>Contains information about the effect that Organizations has on a policy simulation.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct OrganizationsDecisionDetail {
    /// <p>Specifies whether the simulated operation is allowed by the Organizations service control policies that impact the simulated user's account.</p>
    pub allowed_by_organizations: Option<bool>,
}

#[allow(dead_code)]
struct OrganizationsDecisionDetailDeserializer;
impl OrganizationsDecisionDetailDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<OrganizationsDecisionDetail, XmlParseError> {
        deserialize_elements::<_, OrganizationsDecisionDetail, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "AllowedByOrganizations" => {
                        obj.allowed_by_organizations = Some(BooleanTypeDeserializer::deserialize(
                            "AllowedByOrganizations",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct OrganizationsEntityPathTypeDeserializer;
impl OrganizationsEntityPathTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p>Contains information about the account password policy.</p> <p> This data type is used as a response element in the <a>GetAccountPasswordPolicy</a> operation. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct PasswordPolicy {
    /// <p>Specifies whether IAM users are allowed to change their own password.</p>
    pub allow_users_to_change_password: Option<bool>,
    /// <p>Indicates whether passwords in the account expire. Returns true if <code>MaxPasswordAge</code> contains a value greater than 0. Returns false if MaxPasswordAge is 0 or not present.</p>
    pub expire_passwords: Option<bool>,
    /// <p>Specifies whether IAM users are prevented from setting a new password after their password has expired.</p>
    pub hard_expiry: Option<bool>,
    /// <p>The number of days that an IAM user password is valid.</p>
    pub max_password_age: Option<i64>,
    /// <p>Minimum length to require for IAM user passwords.</p>
    pub minimum_password_length: Option<i64>,
    /// <p>Specifies the number of previous passwords that IAM users are prevented from reusing.</p>
    pub password_reuse_prevention: Option<i64>,
    /// <p>Specifies whether IAM user passwords must contain at least one lowercase character (a to z).</p>
    pub require_lowercase_characters: Option<bool>,
    /// <p>Specifies whether IAM user passwords must contain at least one numeric character (0 to 9).</p>
    pub require_numbers: Option<bool>,
    /// <p>Specifies whether IAM user passwords must contain at least one of the following symbols:</p> <p>! @ # $ % ^ &amp; * ( ) _ + - = [ ] { } | '</p>
    pub require_symbols: Option<bool>,
    /// <p>Specifies whether IAM user passwords must contain at least one uppercase character (A to Z).</p>
    pub require_uppercase_characters: Option<bool>,
}

#[allow(dead_code)]
struct PasswordPolicyDeserializer;
impl PasswordPolicyDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<PasswordPolicy, XmlParseError> {
        deserialize_elements::<_, PasswordPolicy, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "AllowUsersToChangePassword" => {
                    obj.allow_users_to_change_password = Some(
                        BooleanTypeDeserializer::deserialize("AllowUsersToChangePassword", stack)?,
                    );
                }
                "ExpirePasswords" => {
                    obj.expire_passwords = Some(BooleanTypeDeserializer::deserialize(
                        "ExpirePasswords",
                        stack,
                    )?);
                }
                "HardExpiry" => {
                    obj.hard_expiry = Some(BooleanObjectTypeDeserializer::deserialize(
                        "HardExpiry",
                        stack,
                    )?);
                }
                "MaxPasswordAge" => {
                    obj.max_password_age = Some(MaxPasswordAgeTypeDeserializer::deserialize(
                        "MaxPasswordAge",
                        stack,
                    )?);
                }
                "MinimumPasswordLength" => {
                    obj.minimum_password_length =
                        Some(MinimumPasswordLengthTypeDeserializer::deserialize(
                            "MinimumPasswordLength",
                            stack,
                        )?);
                }
                "PasswordReusePrevention" => {
                    obj.password_reuse_prevention =
                        Some(PasswordReusePreventionTypeDeserializer::deserialize(
                            "PasswordReusePrevention",
                            stack,
                        )?);
                }
                "RequireLowercaseCharacters" => {
                    obj.require_lowercase_characters = Some(BooleanTypeDeserializer::deserialize(
                        "RequireLowercaseCharacters",
                        stack,
                    )?);
                }
                "RequireNumbers" => {
                    obj.require_numbers = Some(BooleanTypeDeserializer::deserialize(
                        "RequireNumbers",
                        stack,
                    )?);
                }
                "RequireSymbols" => {
                    obj.require_symbols = Some(BooleanTypeDeserializer::deserialize(
                        "RequireSymbols",
                        stack,
                    )?);
                }
                "RequireUppercaseCharacters" => {
                    obj.require_uppercase_characters = Some(BooleanTypeDeserializer::deserialize(
                        "RequireUppercaseCharacters",
                        stack,
                    )?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct PasswordReusePreventionTypeDeserializer;
impl PasswordReusePreventionTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<i64, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, |s| Ok(i64::from_str(&s).unwrap()))
    }
}
#[allow(dead_code)]
struct PathTypeDeserializer;
impl PathTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct PermissionsBoundaryAttachmentTypeDeserializer;
impl PermissionsBoundaryAttachmentTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p>Contains information about the effect that a permissions boundary has on a policy simulation when the boundary is applied to an IAM entity.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct PermissionsBoundaryDecisionDetail {
    /// <p>Specifies whether an action is allowed by a permissions boundary that is applied to an IAM entity (user or role). A value of <code>true</code> means that the permissions boundary does not deny the action. This means that the policy includes an <code>Allow</code> statement that matches the request. In this case, if an identity-based policy also allows the action, the request is allowed. A value of <code>false</code> means that either the requested action is not allowed (implicitly denied) or that the action is explicitly denied by the permissions boundary. In both of these cases, the action is not allowed, regardless of the identity-based policy.</p>
    pub allowed_by_permissions_boundary: Option<bool>,
}

#[allow(dead_code)]
struct PermissionsBoundaryDecisionDetailDeserializer;
impl PermissionsBoundaryDecisionDetailDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<PermissionsBoundaryDecisionDetail, XmlParseError> {
        deserialize_elements::<_, PermissionsBoundaryDecisionDetail, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "AllowedByPermissionsBoundary" => {
                        obj.allowed_by_permissions_boundary =
                            Some(BooleanTypeDeserializer::deserialize(
                                "AllowedByPermissionsBoundary",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Contains information about a managed policy.</p> <p>This data type is used as a response element in the <a>CreatePolicy</a>, <a>GetPolicy</a>, and <a>ListPolicies</a> operations. </p> <p>For more information about managed policies, refer to <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline policies</a> in the <i>IAM User Guide</i>. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct Policy {
    pub arn: Option<String>,
    /// <p>The number of entities (users, groups, and roles) that the policy is attached to.</p>
    pub attachment_count: Option<i64>,
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the policy was created.</p>
    pub create_date: Option<String>,
    /// <p>The identifier for the version of the policy that is set as the default version.</p>
    pub default_version_id: Option<String>,
    /// <p>A friendly description of the policy.</p> <p>This element is included in the response to the <a>GetPolicy</a> operation. It is not included in the response to the <a>ListPolicies</a> operation. </p>
    pub description: Option<String>,
    /// <p>Specifies whether the policy can be attached to an IAM user, group, or role.</p>
    pub is_attachable: Option<bool>,
    /// <p>The path to the policy.</p> <p>For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the <i>IAM User Guide</i>.</p>
    pub path: Option<String>,
    /// <p>The number of entities (users and roles) for which the policy is used to set the permissions boundary. </p> <p>For more information about permissions boundaries, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM identities </a> in the <i>IAM User Guide</i>.</p>
    pub permissions_boundary_usage_count: Option<i64>,
    /// <p>The stable and unique string identifying the policy.</p> <p>For more information about IDs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the <i>IAM User Guide</i>.</p>
    pub policy_id: Option<String>,
    /// <p>The friendly name (not ARN) identifying the policy.</p>
    pub policy_name: Option<String>,
    /// <p>A list of tags that are attached to the instance profile. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User Guide</i>.</p>
    pub tags: Option<Vec<Tag>>,
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the policy was last updated.</p> <p>When a policy has only one version, this field contains the date and time when the policy was created. When a policy has more than one version, this field contains the date and time when the most recent policy version was created.</p>
    pub update_date: Option<String>,
}

#[allow(dead_code)]
struct PolicyDeserializer;
impl PolicyDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<Policy, XmlParseError> {
        deserialize_elements::<_, Policy, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Arn" => {
                    obj.arn = Some(ArnTypeDeserializer::deserialize("Arn", stack)?);
                }
                "AttachmentCount" => {
                    obj.attachment_count = Some(AttachmentCountTypeDeserializer::deserialize(
                        "AttachmentCount",
                        stack,
                    )?);
                }
                "CreateDate" => {
                    obj.create_date = Some(DateTypeDeserializer::deserialize("CreateDate", stack)?);
                }
                "DefaultVersionId" => {
                    obj.default_version_id = Some(PolicyVersionIdTypeDeserializer::deserialize(
                        "DefaultVersionId",
                        stack,
                    )?);
                }
                "Description" => {
                    obj.description = Some(PolicyDescriptionTypeDeserializer::deserialize(
                        "Description",
                        stack,
                    )?);
                }
                "IsAttachable" => {
                    obj.is_attachable =
                        Some(BooleanTypeDeserializer::deserialize("IsAttachable", stack)?);
                }
                "Path" => {
                    obj.path = Some(PolicyPathTypeDeserializer::deserialize("Path", stack)?);
                }
                "PermissionsBoundaryUsageCount" => {
                    obj.permissions_boundary_usage_count =
                        Some(AttachmentCountTypeDeserializer::deserialize(
                            "PermissionsBoundaryUsageCount",
                            stack,
                        )?);
                }
                "PolicyId" => {
                    obj.policy_id = Some(IdTypeDeserializer::deserialize("PolicyId", stack)?);
                }
                "PolicyName" => {
                    obj.policy_name = Some(PolicyNameTypeDeserializer::deserialize(
                        "PolicyName",
                        stack,
                    )?);
                }
                "Tags" => {
                    obj.tags
                        .get_or_insert(vec![])
                        .extend(TagListTypeDeserializer::deserialize("Tags", stack)?);
                }
                "UpdateDate" => {
                    obj.update_date = Some(DateTypeDeserializer::deserialize("UpdateDate", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct PolicyDescriptionTypeDeserializer;
impl PolicyDescriptionTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p>Contains information about an IAM policy, including the policy document.</p> <p>This data type is used as a response element in the <a>GetAccountAuthorizationDetails</a> operation.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct PolicyDetail {
    /// <p>The policy document.</p>
    pub policy_document: Option<String>,
    /// <p>The name of the policy.</p>
    pub policy_name: Option<String>,
}

#[allow(dead_code)]
struct PolicyDetailDeserializer;
impl PolicyDetailDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<PolicyDetail, XmlParseError> {
        deserialize_elements::<_, PolicyDetail, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "PolicyDocument" => {
                    obj.policy_document = Some(PolicyDocumentTypeDeserializer::deserialize(
                        "PolicyDocument",
                        stack,
                    )?);
                }
                "PolicyName" => {
                    obj.policy_name = Some(PolicyNameTypeDeserializer::deserialize(
                        "PolicyName",
                        stack,
                    )?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct PolicyDetailListTypeDeserializer;
impl PolicyDetailListTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<PolicyDetail>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(PolicyDetailDeserializer::deserialize("member", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct PolicyDocumentTypeDeserializer;
impl PolicyDocumentTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, |s| {
            Ok(rusoto_core::signature::decode_uri(&s))
        })
    }
}
#[allow(dead_code)]
struct PolicyDocumentVersionListTypeDeserializer;
impl PolicyDocumentVersionListTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<PolicyVersion>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(PolicyVersionDeserializer::deserialize("member", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct PolicyEvaluationDecisionTypeDeserializer;
impl PolicyEvaluationDecisionTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p>Contains details about the permissions policies that are attached to the specified identity (user, group, or role).</p> <p>This data type is an element of the <a>ListPoliciesGrantingServiceAccessEntry</a> object.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct PolicyGrantingServiceAccess {
    /// <p>The name of the entity (user or role) to which the inline policy is attached.</p> <p>This field is null for managed policies. For more information about these policy types, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html">Managed policies and inline policies</a> in the <i>IAM User Guide</i>.</p>
    pub entity_name: Option<String>,
    /// <p>The type of entity (user or role) that used the policy to access the service to which the inline policy is attached.</p> <p>This field is null for managed policies. For more information about these policy types, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html">Managed policies and inline policies</a> in the <i>IAM User Guide</i>.</p>
    pub entity_type: Option<String>,
    pub policy_arn: Option<String>,
    /// <p>The policy name.</p>
    pub policy_name: String,
    /// <p>The policy type. For more information about these policy types, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html">Managed policies and inline policies</a> in the <i>IAM User Guide</i>.</p>
    pub policy_type: String,
}

#[allow(dead_code)]
struct PolicyGrantingServiceAccessDeserializer;
impl PolicyGrantingServiceAccessDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<PolicyGrantingServiceAccess, XmlParseError> {
        deserialize_elements::<_, PolicyGrantingServiceAccess, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "EntityName" => {
                        obj.entity_name = Some(EntityNameTypeDeserializer::deserialize(
                            "EntityName",
                            stack,
                        )?);
                    }
                    "EntityType" => {
                        obj.entity_type = Some(PolicyOwnerEntityTypeDeserializer::deserialize(
                            "EntityType",
                            stack,
                        )?);
                    }
                    "PolicyArn" => {
                        obj.policy_arn =
                            Some(ArnTypeDeserializer::deserialize("PolicyArn", stack)?);
                    }
                    "PolicyName" => {
                        obj.policy_name =
                            PolicyNameTypeDeserializer::deserialize("PolicyName", stack)?;
                    }
                    "PolicyType" => {
                        obj.policy_type = PolicyTypeDeserializer::deserialize("PolicyType", stack)?;
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct PolicyGrantingServiceAccessListTypeDeserializer;
impl PolicyGrantingServiceAccessListTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<PolicyGrantingServiceAccess>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(PolicyGrantingServiceAccessDeserializer::deserialize(
                    "member", stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Contains information about a group that a managed policy is attached to.</p> <p>This data type is used as a response element in the <a>ListEntitiesForPolicy</a> operation. </p> <p>For more information about managed policies, refer to <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline policies</a> in the <i>IAM User Guide</i>. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct PolicyGroup {
    /// <p>The stable and unique string identifying the group. For more information about IDs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM identifiers</a> in the <i>IAM User Guide</i>.</p>
    pub group_id: Option<String>,
    /// <p>The name (friendly name, not ARN) identifying the group.</p>
    pub group_name: Option<String>,
}

#[allow(dead_code)]
struct PolicyGroupDeserializer;
impl PolicyGroupDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<PolicyGroup, XmlParseError> {
        deserialize_elements::<_, PolicyGroup, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "GroupId" => {
                    obj.group_id = Some(IdTypeDeserializer::deserialize("GroupId", stack)?);
                }
                "GroupName" => {
                    obj.group_name =
                        Some(GroupNameTypeDeserializer::deserialize("GroupName", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct PolicyGroupListTypeDeserializer;
impl PolicyGroupListTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<PolicyGroup>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(PolicyGroupDeserializer::deserialize("member", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct PolicyIdentifierTypeDeserializer;
impl PolicyIdentifierTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct PolicyListTypeDeserializer;
impl PolicyListTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<Policy>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(PolicyDeserializer::deserialize("member", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct PolicyNameListTypeDeserializer;
impl PolicyNameListTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<String>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(PolicyNameTypeDeserializer::deserialize("member", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct PolicyNameTypeDeserializer;
impl PolicyNameTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct PolicyOwnerEntityTypeDeserializer;
impl PolicyOwnerEntityTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct PolicyPathTypeDeserializer;
impl PolicyPathTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p>Contains information about a role that a managed policy is attached to.</p> <p>This data type is used as a response element in the <a>ListEntitiesForPolicy</a> operation. </p> <p>For more information about managed policies, refer to <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline policies</a> in the <i>IAM User Guide</i>. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct PolicyRole {
    /// <p>The stable and unique string identifying the role. For more information about IDs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM identifiers</a> in the <i>IAM User Guide</i>.</p>
    pub role_id: Option<String>,
    /// <p>The name (friendly name, not ARN) identifying the role.</p>
    pub role_name: Option<String>,
}

#[allow(dead_code)]
struct PolicyRoleDeserializer;
impl PolicyRoleDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<PolicyRole, XmlParseError> {
        deserialize_elements::<_, PolicyRole, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "RoleId" => {
                    obj.role_id = Some(IdTypeDeserializer::deserialize("RoleId", stack)?);
                }
                "RoleName" => {
                    obj.role_name = Some(RoleNameTypeDeserializer::deserialize("RoleName", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct PolicyRoleListTypeDeserializer;
impl PolicyRoleListTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<PolicyRole>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(PolicyRoleDeserializer::deserialize("member", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct PolicySourceTypeDeserializer;
impl PolicySourceTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct PolicyTypeDeserializer;
impl PolicyTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p>Contains information about a user that a managed policy is attached to.</p> <p>This data type is used as a response element in the <a>ListEntitiesForPolicy</a> operation. </p> <p>For more information about managed policies, refer to <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline policies</a> in the <i>IAM User Guide</i>. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct PolicyUser {
    /// <p>The stable and unique string identifying the user. For more information about IDs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM identifiers</a> in the <i>IAM User Guide</i>.</p>
    pub user_id: Option<String>,
    /// <p>The name (friendly name, not ARN) identifying the user.</p>
    pub user_name: Option<String>,
}

#[allow(dead_code)]
struct PolicyUserDeserializer;
impl PolicyUserDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<PolicyUser, XmlParseError> {
        deserialize_elements::<_, PolicyUser, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "UserId" => {
                    obj.user_id = Some(IdTypeDeserializer::deserialize("UserId", stack)?);
                }
                "UserName" => {
                    obj.user_name = Some(UserNameTypeDeserializer::deserialize("UserName", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct PolicyUserListTypeDeserializer;
impl PolicyUserListTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<PolicyUser>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(PolicyUserDeserializer::deserialize("member", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Contains information about a version of a managed policy.</p> <p>This data type is used as a response element in the <a>CreatePolicyVersion</a>, <a>GetPolicyVersion</a>, <a>ListPolicyVersions</a>, and <a>GetAccountAuthorizationDetails</a> operations. </p> <p>For more information about managed policies, refer to <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline policies</a> in the <i>IAM User Guide</i>. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct PolicyVersion {
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the policy version was created.</p>
    pub create_date: Option<String>,
    /// <p>The policy document.</p> <p>The policy document is returned in the response to the <a>GetPolicyVersion</a> and <a>GetAccountAuthorizationDetails</a> operations. It is not returned in the response to the <a>CreatePolicyVersion</a> or <a>ListPolicyVersions</a> operations. </p> <p>The policy document returned in this structure is URL-encoded compliant with <a href="https://tools.ietf.org/html/rfc3986">RFC 3986</a>. You can use a URL decoding method to convert the policy back to plain JSON text. For example, if you use Java, you can use the <code>decode</code> method of the <code>java.net.URLDecoder</code> utility class in the Java SDK. Other languages and SDKs provide similar functionality.</p>
    pub document: Option<String>,
    /// <p>Specifies whether the policy version is set as the policy's default version.</p>
    pub is_default_version: Option<bool>,
    /// <p>The identifier for the policy version.</p> <p>Policy version identifiers always begin with <code>v</code> (always lowercase). When a policy is created, the first policy version is <code>v1</code>. </p>
    pub version_id: Option<String>,
}

#[allow(dead_code)]
struct PolicyVersionDeserializer;
impl PolicyVersionDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<PolicyVersion, XmlParseError> {
        deserialize_elements::<_, PolicyVersion, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "CreateDate" => {
                    obj.create_date = Some(DateTypeDeserializer::deserialize("CreateDate", stack)?);
                }
                "Document" => {
                    obj.document = Some(PolicyDocumentTypeDeserializer::deserialize(
                        "Document", stack,
                    )?);
                }
                "IsDefaultVersion" => {
                    obj.is_default_version = Some(BooleanTypeDeserializer::deserialize(
                        "IsDefaultVersion",
                        stack,
                    )?);
                }
                "VersionId" => {
                    obj.version_id = Some(PolicyVersionIdTypeDeserializer::deserialize(
                        "VersionId",
                        stack,
                    )?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct PolicyVersionIdTypeDeserializer;
impl PolicyVersionIdTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p>Contains the row and column of a location of a <code>Statement</code> element in a policy document.</p> <p>This data type is used as a member of the <code> <a>Statement</a> </code> type.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct Position {
    /// <p>The column in the line containing the specified position in the document.</p>
    pub column: Option<i64>,
    /// <p>The line containing the specified position in the document.</p>
    pub line: Option<i64>,
}

#[allow(dead_code)]
struct PositionDeserializer;
impl PositionDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Position, XmlParseError> {
        deserialize_elements::<_, Position, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Column" => {
                    obj.column = Some(ColumnNumberDeserializer::deserialize("Column", stack)?);
                }
                "Line" => {
                    obj.line = Some(LineNumberDeserializer::deserialize("Line", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct PublicKeyFingerprintTypeDeserializer;
impl PublicKeyFingerprintTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct PublicKeyIdTypeDeserializer;
impl PublicKeyIdTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct PublicKeyMaterialTypeDeserializer;
impl PublicKeyMaterialTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct PutGroupPolicyRequest {
    /// <p>The name of the group to associate the policy with.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.</p>
    pub group_name: String,
    /// <p><p>The policy document.</p> <p>You must provide policies in JSON format in IAM. However, for AWS CloudFormation templates formatted in YAML, you can provide the policy in JSON or YAML format. AWS CloudFormation always converts a YAML policy to JSON format before submitting it to IAM.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of characters consisting of the following:</p> <ul> <li> <p>Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p> </li> <li> <p>The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>)</p> </li> <li> <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>)</p> </li> </ul></p>
    pub policy_document: String,
    /// <p>The name of the policy document.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub policy_name: String,
}

/// Serialize `PutGroupPolicyRequest` contents to a `SignedRequest`.
struct PutGroupPolicyRequestSerializer;
impl PutGroupPolicyRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &PutGroupPolicyRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "GroupName"), &obj.group_name);
        params.put(
            &format!("{}{}", prefix, "PolicyDocument"),
            &obj.policy_document,
        );
        params.put(&format!("{}{}", prefix, "PolicyName"), &obj.policy_name);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct PutRolePermissionsBoundaryRequest {
    /// <p>The ARN of the policy that is used to set the permissions boundary for the role.</p>
    pub permissions_boundary: String,
    /// <p>The name (friendly name, not ARN) of the IAM role for which you want to set the permissions boundary.</p>
    pub role_name: String,
}

/// Serialize `PutRolePermissionsBoundaryRequest` contents to a `SignedRequest`.
struct PutRolePermissionsBoundaryRequestSerializer;
impl PutRolePermissionsBoundaryRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &PutRolePermissionsBoundaryRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "PermissionsBoundary"),
            &obj.permissions_boundary,
        );
        params.put(&format!("{}{}", prefix, "RoleName"), &obj.role_name);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct PutRolePolicyRequest {
    /// <p><p>The policy document.</p> <p>You must provide policies in JSON format in IAM. However, for AWS CloudFormation templates formatted in YAML, you can provide the policy in JSON or YAML format. AWS CloudFormation always converts a YAML policy to JSON format before submitting it to IAM.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of characters consisting of the following:</p> <ul> <li> <p>Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p> </li> <li> <p>The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>)</p> </li> <li> <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>)</p> </li> </ul></p>
    pub policy_document: String,
    /// <p>The name of the policy document.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub policy_name: String,
    /// <p>The name of the role to associate the policy with.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub role_name: String,
}

/// Serialize `PutRolePolicyRequest` contents to a `SignedRequest`.
struct PutRolePolicyRequestSerializer;
impl PutRolePolicyRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &PutRolePolicyRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "PolicyDocument"),
            &obj.policy_document,
        );
        params.put(&format!("{}{}", prefix, "PolicyName"), &obj.policy_name);
        params.put(&format!("{}{}", prefix, "RoleName"), &obj.role_name);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct PutUserPermissionsBoundaryRequest {
    /// <p>The ARN of the policy that is used to set the permissions boundary for the user.</p>
    pub permissions_boundary: String,
    /// <p>The name (friendly name, not ARN) of the IAM user for which you want to set the permissions boundary.</p>
    pub user_name: String,
}

/// Serialize `PutUserPermissionsBoundaryRequest` contents to a `SignedRequest`.
struct PutUserPermissionsBoundaryRequestSerializer;
impl PutUserPermissionsBoundaryRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &PutUserPermissionsBoundaryRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "PermissionsBoundary"),
            &obj.permissions_boundary,
        );
        params.put(&format!("{}{}", prefix, "UserName"), &obj.user_name);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct PutUserPolicyRequest {
    /// <p><p>The policy document.</p> <p>You must provide policies in JSON format in IAM. However, for AWS CloudFormation templates formatted in YAML, you can provide the policy in JSON or YAML format. AWS CloudFormation always converts a YAML policy to JSON format before submitting it to IAM.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of characters consisting of the following:</p> <ul> <li> <p>Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p> </li> <li> <p>The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>)</p> </li> <li> <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>)</p> </li> </ul></p>
    pub policy_document: String,
    /// <p>The name of the policy document.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub policy_name: String,
    /// <p>The name of the user to associate the policy with.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub user_name: String,
}

/// Serialize `PutUserPolicyRequest` contents to a `SignedRequest`.
struct PutUserPolicyRequestSerializer;
impl PutUserPolicyRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &PutUserPolicyRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "PolicyDocument"),
            &obj.policy_document,
        );
        params.put(&format!("{}{}", prefix, "PolicyName"), &obj.policy_name);
        params.put(&format!("{}{}", prefix, "UserName"), &obj.user_name);
    }
}

#[allow(dead_code)]
struct ReasonTypeDeserializer;
impl ReasonTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct RegionNameTypeDeserializer;
impl RegionNameTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct RemoveClientIDFromOpenIDConnectProviderRequest {
    /// <p>The client ID (also known as audience) to remove from the IAM OIDC provider resource. For more information about client IDs, see <a>CreateOpenIDConnectProvider</a>.</p>
    pub client_id: String,
    /// <p>The Amazon Resource Name (ARN) of the IAM OIDC provider resource to remove the client ID from. You can get a list of OIDC provider ARNs by using the <a>ListOpenIDConnectProviders</a> operation.</p> <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub open_id_connect_provider_arn: String,
}

/// Serialize `RemoveClientIDFromOpenIDConnectProviderRequest` contents to a `SignedRequest`.
struct RemoveClientIDFromOpenIDConnectProviderRequestSerializer;
impl RemoveClientIDFromOpenIDConnectProviderRequestSerializer {
    fn serialize(
        params: &mut Params,
        name: &str,
        obj: &RemoveClientIDFromOpenIDConnectProviderRequest,
    ) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "ClientID"), &obj.client_id);
        params.put(
            &format!("{}{}", prefix, "OpenIDConnectProviderArn"),
            &obj.open_id_connect_provider_arn,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct RemoveRoleFromInstanceProfileRequest {
    /// <p>The name of the instance profile to update.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub instance_profile_name: String,
    /// <p>The name of the role to remove.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub role_name: String,
}

/// Serialize `RemoveRoleFromInstanceProfileRequest` contents to a `SignedRequest`.
struct RemoveRoleFromInstanceProfileRequestSerializer;
impl RemoveRoleFromInstanceProfileRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &RemoveRoleFromInstanceProfileRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "InstanceProfileName"),
            &obj.instance_profile_name,
        );
        params.put(&format!("{}{}", prefix, "RoleName"), &obj.role_name);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct RemoveUserFromGroupRequest {
    /// <p>The name of the group to update.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub group_name: String,
    /// <p>The name of the user to remove.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub user_name: String,
}

/// Serialize `RemoveUserFromGroupRequest` contents to a `SignedRequest`.
struct RemoveUserFromGroupRequestSerializer;
impl RemoveUserFromGroupRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &RemoveUserFromGroupRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "GroupName"), &obj.group_name);
        params.put(&format!("{}{}", prefix, "UserName"), &obj.user_name);
    }
}

#[allow(dead_code)]
struct ReportContentTypeDeserializer;
impl ReportContentTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<bytes::Bytes, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, |s| Ok(s.into()))
    }
}
#[allow(dead_code)]
struct ReportFormatTypeDeserializer;
impl ReportFormatTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct ReportStateDescriptionTypeDeserializer;
impl ReportStateDescriptionTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct ReportStateTypeDeserializer;
impl ReportStateTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ResetServiceSpecificCredentialRequest {
    /// <p>The unique identifier of the service-specific credential.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that can consist of any upper or lowercased letter or digit.</p>
    pub service_specific_credential_id: String,
    /// <p>The name of the IAM user associated with the service-specific credential. If this value is not specified, then the operation assumes the user whose credentials are used to call the operation.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub user_name: Option<String>,
}

/// Serialize `ResetServiceSpecificCredentialRequest` contents to a `SignedRequest`.
struct ResetServiceSpecificCredentialRequestSerializer;
impl ResetServiceSpecificCredentialRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ResetServiceSpecificCredentialRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "ServiceSpecificCredentialId"),
            &obj.service_specific_credential_id,
        );
        if let Some(ref field_value) = obj.user_name {
            params.put(&format!("{}{}", prefix, "UserName"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ResetServiceSpecificCredentialResponse {
    /// <p><p>A structure with details about the updated service-specific credential, including the new password.</p> <important> <p>This is the <b>only</b> time that you can access the password. You cannot recover the password later, but you can reset it again.</p> </important></p>
    pub service_specific_credential: Option<ServiceSpecificCredential>,
}

#[allow(dead_code)]
struct ResetServiceSpecificCredentialResponseDeserializer;
impl ResetServiceSpecificCredentialResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ResetServiceSpecificCredentialResponse, XmlParseError> {
        deserialize_elements::<_, ResetServiceSpecificCredentialResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "ServiceSpecificCredential" => {
                        obj.service_specific_credential =
                            Some(ServiceSpecificCredentialDeserializer::deserialize(
                                "ServiceSpecificCredential",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}

/// Serialize `ResourceNameListType` contents to a `SignedRequest`.
struct ResourceNameListTypeSerializer;
impl ResourceNameListTypeSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<String>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.member.{}", name, index + 1);
            params.put(&key, &obj);
        }
    }
}

#[allow(dead_code)]
struct ResourceNameTypeDeserializer;
impl ResourceNameTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p>Contains the result of the simulation of a single API operation call on a single resource.</p> <p>This data type is used by a member of the <a>EvaluationResult</a> data type.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ResourceSpecificResult {
    /// <p>Additional details about the results of the evaluation decision on a single resource. This parameter is returned only for cross-account simulations. This parameter explains how each policy type contributes to the resource-specific evaluation decision.</p>
    pub eval_decision_details: Option<::std::collections::HashMap<String, String>>,
    /// <p>The result of the simulation of the simulated API operation on the resource specified in <code>EvalResourceName</code>.</p>
    pub eval_resource_decision: String,
    /// <p>The name of the simulated resource, in Amazon Resource Name (ARN) format.</p>
    pub eval_resource_name: String,
    /// <p>A list of the statements in the input policies that determine the result for this part of the simulation. Remember that even if multiple statements allow the operation on the resource, if <i>any</i> statement denies that operation, then the explicit deny overrides any allow. In addition, the deny statement is the only entry included in the result.</p>
    pub matched_statements: Option<Vec<Statement>>,
    /// <p>A list of context keys that are required by the included input policies but that were not provided by one of the input parameters. This list is used when a list of ARNs is included in the <code>ResourceArns</code> parameter instead of "*". If you do not specify individual resources, by setting <code>ResourceArns</code> to "*" or by not including the <code>ResourceArns</code> parameter, then any missing context values are instead included under the <code>EvaluationResults</code> section. To discover the context keys used by a set of policies, you can call <a>GetContextKeysForCustomPolicy</a> or <a>GetContextKeysForPrincipalPolicy</a>.</p>
    pub missing_context_values: Option<Vec<String>>,
    /// <p>Contains information about the effect that a permissions boundary has on a policy simulation when that boundary is applied to an IAM entity.</p>
    pub permissions_boundary_decision_detail: Option<PermissionsBoundaryDecisionDetail>,
}

#[allow(dead_code)]
struct ResourceSpecificResultDeserializer;
impl ResourceSpecificResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ResourceSpecificResult, XmlParseError> {
        deserialize_elements::<_, ResourceSpecificResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "EvalDecisionDetails" => {
                    obj.eval_decision_details =
                        Some(EvalDecisionDetailsTypeDeserializer::deserialize(
                            "EvalDecisionDetails",
                            stack,
                        )?);
                }
                "EvalResourceDecision" => {
                    obj.eval_resource_decision =
                        PolicyEvaluationDecisionTypeDeserializer::deserialize(
                            "EvalResourceDecision",
                            stack,
                        )?;
                }
                "EvalResourceName" => {
                    obj.eval_resource_name =
                        ResourceNameTypeDeserializer::deserialize("EvalResourceName", stack)?;
                }
                "MatchedStatements" => {
                    obj.matched_statements.get_or_insert(vec![]).extend(
                        StatementListTypeDeserializer::deserialize("MatchedStatements", stack)?,
                    );
                }
                "MissingContextValues" => {
                    obj.missing_context_values.get_or_insert(vec![]).extend(
                        ContextKeyNamesResultListTypeDeserializer::deserialize(
                            "MissingContextValues",
                            stack,
                        )?,
                    );
                }
                "PermissionsBoundaryDecisionDetail" => {
                    obj.permissions_boundary_decision_detail =
                        Some(PermissionsBoundaryDecisionDetailDeserializer::deserialize(
                            "PermissionsBoundaryDecisionDetail",
                            stack,
                        )?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct ResourceSpecificResultListTypeDeserializer;
impl ResourceSpecificResultListTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<ResourceSpecificResult>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(ResourceSpecificResultDeserializer::deserialize(
                    "member", stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct ResponseMarkerTypeDeserializer;
impl ResponseMarkerTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ResyncMFADeviceRequest {
    /// <p>An authentication code emitted by the device.</p> <p>The format for this parameter is a sequence of six digits.</p>
    pub authentication_code_1: String,
    /// <p>A subsequent authentication code emitted by the device.</p> <p>The format for this parameter is a sequence of six digits.</p>
    pub authentication_code_2: String,
    /// <p>Serial number that uniquely identifies the MFA device.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub serial_number: String,
    /// <p>The name of the user whose MFA device you want to resynchronize.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub user_name: String,
}

/// Serialize `ResyncMFADeviceRequest` contents to a `SignedRequest`.
struct ResyncMFADeviceRequestSerializer;
impl ResyncMFADeviceRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ResyncMFADeviceRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "AuthenticationCode1"),
            &obj.authentication_code_1,
        );
        params.put(
            &format!("{}{}", prefix, "AuthenticationCode2"),
            &obj.authentication_code_2,
        );
        params.put(&format!("{}{}", prefix, "SerialNumber"), &obj.serial_number);
        params.put(&format!("{}{}", prefix, "UserName"), &obj.user_name);
    }
}

/// <p>Contains information about an IAM role. This structure is returned as a response element in several API operations that interact with roles.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct Role {
    /// <p> The Amazon Resource Name (ARN) specifying the role. For more information about ARNs and how to use them in policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the <i>IAM User Guide</i> guide. </p>
    pub arn: String,
    /// <p>The policy that grants an entity permission to assume the role.</p>
    pub assume_role_policy_document: Option<String>,
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the role was created.</p>
    pub create_date: String,
    /// <p>A description of the role that you provide.</p>
    pub description: Option<String>,
    /// <p>The maximum session duration (in seconds) for the specified role. Anyone who uses the AWS CLI, or API to assume the role can specify the duration using the optional <code>DurationSeconds</code> API parameter or <code>duration-seconds</code> CLI parameter.</p>
    pub max_session_duration: Option<i64>,
    /// <p> The path to the role. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the <i>IAM User Guide</i>. </p>
    pub path: String,
    /// <p>The ARN of the policy used to set the permissions boundary for the role.</p> <p>For more information about permissions boundaries, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM identities </a> in the <i>IAM User Guide</i>.</p>
    pub permissions_boundary: Option<AttachedPermissionsBoundary>,
    /// <p> The stable and unique string identifying the role. For more information about IDs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the <i>IAM User Guide</i>. </p>
    pub role_id: String,
    /// <p>Contains information about the last time that an IAM role was used. This includes the date and time and the Region in which the role was last used. Activity is only reported for the trailing 400 days. This period can be shorter if your Region began supporting these features within the last year. The role might have been used more than 400 days ago. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#access-advisor_tracking-period">Regions where data is tracked</a> in the <i>IAM User Guide</i>.</p>
    pub role_last_used: Option<RoleLastUsed>,
    /// <p>The friendly name that identifies the role.</p>
    pub role_name: String,
    /// <p>A list of tags that are attached to the role. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User Guide</i>.</p>
    pub tags: Option<Vec<Tag>>,
}

#[allow(dead_code)]
struct RoleDeserializer;
impl RoleDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<Role, XmlParseError> {
        deserialize_elements::<_, Role, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Arn" => {
                    obj.arn = ArnTypeDeserializer::deserialize("Arn", stack)?;
                }
                "AssumeRolePolicyDocument" => {
                    obj.assume_role_policy_document =
                        Some(PolicyDocumentTypeDeserializer::deserialize(
                            "AssumeRolePolicyDocument",
                            stack,
                        )?);
                }
                "CreateDate" => {
                    obj.create_date = DateTypeDeserializer::deserialize("CreateDate", stack)?;
                }
                "Description" => {
                    obj.description = Some(RoleDescriptionTypeDeserializer::deserialize(
                        "Description",
                        stack,
                    )?);
                }
                "MaxSessionDuration" => {
                    obj.max_session_duration =
                        Some(RoleMaxSessionDurationTypeDeserializer::deserialize(
                            "MaxSessionDuration",
                            stack,
                        )?);
                }
                "Path" => {
                    obj.path = PathTypeDeserializer::deserialize("Path", stack)?;
                }
                "PermissionsBoundary" => {
                    obj.permissions_boundary =
                        Some(AttachedPermissionsBoundaryDeserializer::deserialize(
                            "PermissionsBoundary",
                            stack,
                        )?);
                }
                "RoleId" => {
                    obj.role_id = IdTypeDeserializer::deserialize("RoleId", stack)?;
                }
                "RoleLastUsed" => {
                    obj.role_last_used = Some(RoleLastUsedDeserializer::deserialize(
                        "RoleLastUsed",
                        stack,
                    )?);
                }
                "RoleName" => {
                    obj.role_name = RoleNameTypeDeserializer::deserialize("RoleName", stack)?;
                }
                "Tags" => {
                    obj.tags
                        .get_or_insert(vec![])
                        .extend(TagListTypeDeserializer::deserialize("Tags", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct RoleDescriptionTypeDeserializer;
impl RoleDescriptionTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p>Contains information about an IAM role, including all of the role's policies.</p> <p>This data type is used as a response element in the <a>GetAccountAuthorizationDetails</a> operation.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct RoleDetail {
    pub arn: Option<String>,
    /// <p>The trust policy that grants permission to assume the role.</p>
    pub assume_role_policy_document: Option<String>,
    /// <p>A list of managed policies attached to the role. These policies are the role's access (permissions) policies.</p>
    pub attached_managed_policies: Option<Vec<AttachedPolicy>>,
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the role was created.</p>
    pub create_date: Option<String>,
    /// <p>A list of instance profiles that contain this role.</p>
    pub instance_profile_list: Option<Vec<InstanceProfile>>,
    /// <p>The path to the role. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the <i>IAM User Guide</i>.</p>
    pub path: Option<String>,
    /// <p>The ARN of the policy used to set the permissions boundary for the role.</p> <p>For more information about permissions boundaries, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM identities </a> in the <i>IAM User Guide</i>.</p>
    pub permissions_boundary: Option<AttachedPermissionsBoundary>,
    /// <p>The stable and unique string identifying the role. For more information about IDs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the <i>IAM User Guide</i>.</p>
    pub role_id: Option<String>,
    /// <p>Contains information about the last time that an IAM role was used. This includes the date and time and the Region in which the role was last used. Activity is only reported for the trailing 400 days. This period can be shorter if your Region began supporting these features within the last year. The role might have been used more than 400 days ago. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#access-advisor_tracking-period">Regions where data is tracked</a> in the <i>IAM User Guide</i>.</p>
    pub role_last_used: Option<RoleLastUsed>,
    /// <p>The friendly name that identifies the role.</p>
    pub role_name: Option<String>,
    /// <p>A list of inline policies embedded in the role. These policies are the role's access (permissions) policies.</p>
    pub role_policy_list: Option<Vec<PolicyDetail>>,
    /// <p>A list of tags that are attached to the role. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User Guide</i>.</p>
    pub tags: Option<Vec<Tag>>,
}

#[allow(dead_code)]
struct RoleDetailDeserializer;
impl RoleDetailDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<RoleDetail, XmlParseError> {
        deserialize_elements::<_, RoleDetail, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Arn" => {
                    obj.arn = Some(ArnTypeDeserializer::deserialize("Arn", stack)?);
                }
                "AssumeRolePolicyDocument" => {
                    obj.assume_role_policy_document =
                        Some(PolicyDocumentTypeDeserializer::deserialize(
                            "AssumeRolePolicyDocument",
                            stack,
                        )?);
                }
                "AttachedManagedPolicies" => {
                    obj.attached_managed_policies.get_or_insert(vec![]).extend(
                        AttachedPoliciesListTypeDeserializer::deserialize(
                            "AttachedManagedPolicies",
                            stack,
                        )?,
                    );
                }
                "CreateDate" => {
                    obj.create_date = Some(DateTypeDeserializer::deserialize("CreateDate", stack)?);
                }
                "InstanceProfileList" => {
                    obj.instance_profile_list.get_or_insert(vec![]).extend(
                        InstanceProfileListTypeDeserializer::deserialize(
                            "InstanceProfileList",
                            stack,
                        )?,
                    );
                }
                "Path" => {
                    obj.path = Some(PathTypeDeserializer::deserialize("Path", stack)?);
                }
                "PermissionsBoundary" => {
                    obj.permissions_boundary =
                        Some(AttachedPermissionsBoundaryDeserializer::deserialize(
                            "PermissionsBoundary",
                            stack,
                        )?);
                }
                "RoleId" => {
                    obj.role_id = Some(IdTypeDeserializer::deserialize("RoleId", stack)?);
                }
                "RoleLastUsed" => {
                    obj.role_last_used = Some(RoleLastUsedDeserializer::deserialize(
                        "RoleLastUsed",
                        stack,
                    )?);
                }
                "RoleName" => {
                    obj.role_name = Some(RoleNameTypeDeserializer::deserialize("RoleName", stack)?);
                }
                "RolePolicyList" => {
                    obj.role_policy_list.get_or_insert(vec![]).extend(
                        PolicyDetailListTypeDeserializer::deserialize("RolePolicyList", stack)?,
                    );
                }
                "Tags" => {
                    obj.tags
                        .get_or_insert(vec![])
                        .extend(TagListTypeDeserializer::deserialize("Tags", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct RoleDetailListTypeDeserializer;
impl RoleDetailListTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<RoleDetail>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(RoleDetailDeserializer::deserialize("member", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Contains information about the last time that an IAM role was used. This includes the date and time and the Region in which the role was last used. Activity is only reported for the trailing 400 days. This period can be shorter if your Region began supporting these features within the last year. The role might have been used more than 400 days ago. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#access-advisor_tracking-period">Regions where data is tracked</a> in the <i>IAM User Guide</i>.</p> <p>This data type is returned as a response element in the <a>GetRole</a> and <a>GetAccountAuthorizationDetails</a> operations.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct RoleLastUsed {
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a> that the role was last used.</p> <p>This field is null if the role has not been used within the IAM tracking period. For more information about the tracking period, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#access-advisor_tracking-period">Regions where data is tracked</a> in the <i>IAM User Guide</i>. </p>
    pub last_used_date: Option<String>,
    /// <p>The name of the AWS Region in which the role was last used.</p>
    pub region: Option<String>,
}

#[allow(dead_code)]
struct RoleLastUsedDeserializer;
impl RoleLastUsedDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<RoleLastUsed, XmlParseError> {
        deserialize_elements::<_, RoleLastUsed, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "LastUsedDate" => {
                    obj.last_used_date =
                        Some(DateTypeDeserializer::deserialize("LastUsedDate", stack)?);
                }
                "Region" => {
                    obj.region = Some(StringTypeDeserializer::deserialize("Region", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct RoleListTypeDeserializer;
impl RoleListTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<Role>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(RoleDeserializer::deserialize("member", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct RoleMaxSessionDurationTypeDeserializer;
impl RoleMaxSessionDurationTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<i64, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, |s| Ok(i64::from_str(&s).unwrap()))
    }
}
#[allow(dead_code)]
struct RoleNameTypeDeserializer;
impl RoleNameTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct RoleUsageListTypeDeserializer;
impl RoleUsageListTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<RoleUsageType>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(RoleUsageTypeDeserializer::deserialize("member", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>An object that contains details about how a service-linked role is used, if that information is returned by the service.</p> <p>This data type is used as a response element in the <a>GetServiceLinkedRoleDeletionStatus</a> operation.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct RoleUsageType {
    /// <p>The name of the Region where the service-linked role is being used.</p>
    pub region: Option<String>,
    /// <p>The name of the resource that is using the service-linked role.</p>
    pub resources: Option<Vec<String>>,
}

#[allow(dead_code)]
struct RoleUsageTypeDeserializer;
impl RoleUsageTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<RoleUsageType, XmlParseError> {
        deserialize_elements::<_, RoleUsageType, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Region" => {
                    obj.region = Some(RegionNameTypeDeserializer::deserialize("Region", stack)?);
                }
                "Resources" => {
                    obj.resources
                        .get_or_insert(vec![])
                        .extend(ArnListTypeDeserializer::deserialize("Resources", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct SAMLMetadataDocumentTypeDeserializer;
impl SAMLMetadataDocumentTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p>Contains the list of SAML providers for this account.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct SAMLProviderListEntry {
    /// <p>The Amazon Resource Name (ARN) of the SAML provider.</p>
    pub arn: Option<String>,
    /// <p>The date and time when the SAML provider was created.</p>
    pub create_date: Option<String>,
    /// <p>The expiration date and time for the SAML provider.</p>
    pub valid_until: Option<String>,
}

#[allow(dead_code)]
struct SAMLProviderListEntryDeserializer;
impl SAMLProviderListEntryDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<SAMLProviderListEntry, XmlParseError> {
        deserialize_elements::<_, SAMLProviderListEntry, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Arn" => {
                    obj.arn = Some(ArnTypeDeserializer::deserialize("Arn", stack)?);
                }
                "CreateDate" => {
                    obj.create_date = Some(DateTypeDeserializer::deserialize("CreateDate", stack)?);
                }
                "ValidUntil" => {
                    obj.valid_until = Some(DateTypeDeserializer::deserialize("ValidUntil", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct SAMLProviderListTypeDeserializer;
impl SAMLProviderListTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<SAMLProviderListEntry>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(SAMLProviderListEntryDeserializer::deserialize(
                    "member", stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Contains information about an SSH public key.</p> <p>This data type is used as a response element in the <a>GetSSHPublicKey</a> and <a>UploadSSHPublicKey</a> operations. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct SSHPublicKey {
    /// <p>The MD5 message digest of the SSH public key.</p>
    pub fingerprint: String,
    /// <p>The SSH public key.</p>
    pub ssh_public_key_body: String,
    /// <p>The unique identifier for the SSH public key.</p>
    pub ssh_public_key_id: String,
    /// <p>The status of the SSH public key. <code>Active</code> means that the key can be used for authentication with an AWS CodeCommit repository. <code>Inactive</code> means that the key cannot be used.</p>
    pub status: String,
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the SSH public key was uploaded.</p>
    pub upload_date: Option<String>,
    /// <p>The name of the IAM user associated with the SSH public key.</p>
    pub user_name: String,
}

#[allow(dead_code)]
struct SSHPublicKeyDeserializer;
impl SSHPublicKeyDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<SSHPublicKey, XmlParseError> {
        deserialize_elements::<_, SSHPublicKey, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Fingerprint" => {
                    obj.fingerprint =
                        PublicKeyFingerprintTypeDeserializer::deserialize("Fingerprint", stack)?;
                }
                "SSHPublicKeyBody" => {
                    obj.ssh_public_key_body =
                        PublicKeyMaterialTypeDeserializer::deserialize("SSHPublicKeyBody", stack)?;
                }
                "SSHPublicKeyId" => {
                    obj.ssh_public_key_id =
                        PublicKeyIdTypeDeserializer::deserialize("SSHPublicKeyId", stack)?;
                }
                "Status" => {
                    obj.status = StatusTypeDeserializer::deserialize("Status", stack)?;
                }
                "UploadDate" => {
                    obj.upload_date = Some(DateTypeDeserializer::deserialize("UploadDate", stack)?);
                }
                "UserName" => {
                    obj.user_name = UserNameTypeDeserializer::deserialize("UserName", stack)?;
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct SSHPublicKeyListTypeDeserializer;
impl SSHPublicKeyListTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<SSHPublicKeyMetadata>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(SSHPublicKeyMetadataDeserializer::deserialize(
                    "member", stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Contains information about an SSH public key, without the key's body or fingerprint.</p> <p>This data type is used as a response element in the <a>ListSSHPublicKeys</a> operation.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct SSHPublicKeyMetadata {
    /// <p>The unique identifier for the SSH public key.</p>
    pub ssh_public_key_id: String,
    /// <p>The status of the SSH public key. <code>Active</code> means that the key can be used for authentication with an AWS CodeCommit repository. <code>Inactive</code> means that the key cannot be used.</p>
    pub status: String,
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the SSH public key was uploaded.</p>
    pub upload_date: String,
    /// <p>The name of the IAM user associated with the SSH public key.</p>
    pub user_name: String,
}

#[allow(dead_code)]
struct SSHPublicKeyMetadataDeserializer;
impl SSHPublicKeyMetadataDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<SSHPublicKeyMetadata, XmlParseError> {
        deserialize_elements::<_, SSHPublicKeyMetadata, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "SSHPublicKeyId" => {
                    obj.ssh_public_key_id =
                        PublicKeyIdTypeDeserializer::deserialize("SSHPublicKeyId", stack)?;
                }
                "Status" => {
                    obj.status = StatusTypeDeserializer::deserialize("Status", stack)?;
                }
                "UploadDate" => {
                    obj.upload_date = DateTypeDeserializer::deserialize("UploadDate", stack)?;
                }
                "UserName" => {
                    obj.user_name = UserNameTypeDeserializer::deserialize("UserName", stack)?;
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct SerialNumberTypeDeserializer;
impl SerialNumberTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p>Contains information about a server certificate.</p> <p> This data type is used as a response element in the <a>GetServerCertificate</a> operation. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ServerCertificate {
    /// <p>The contents of the public key certificate.</p>
    pub certificate_body: String,
    /// <p>The contents of the public key certificate chain.</p>
    pub certificate_chain: Option<String>,
    /// <p>The meta information of the server certificate, such as its name, path, ID, and ARN.</p>
    pub server_certificate_metadata: ServerCertificateMetadata,
    /// <p>A list of tags that are attached to the server certificate. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User Guide</i>.</p>
    pub tags: Option<Vec<Tag>>,
}

#[allow(dead_code)]
struct ServerCertificateDeserializer;
impl ServerCertificateDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ServerCertificate, XmlParseError> {
        deserialize_elements::<_, ServerCertificate, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "CertificateBody" => {
                    obj.certificate_body =
                        CertificateBodyTypeDeserializer::deserialize("CertificateBody", stack)?;
                }
                "CertificateChain" => {
                    obj.certificate_chain = Some(CertificateChainTypeDeserializer::deserialize(
                        "CertificateChain",
                        stack,
                    )?);
                }
                "ServerCertificateMetadata" => {
                    obj.server_certificate_metadata =
                        ServerCertificateMetadataDeserializer::deserialize(
                            "ServerCertificateMetadata",
                            stack,
                        )?;
                }
                "Tags" => {
                    obj.tags
                        .get_or_insert(vec![])
                        .extend(TagListTypeDeserializer::deserialize("Tags", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>Contains information about a server certificate without its certificate body, certificate chain, and private key.</p> <p> This data type is used as a response element in the <a>UploadServerCertificate</a> and <a>ListServerCertificates</a> operations. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ServerCertificateMetadata {
    /// <p> The Amazon Resource Name (ARN) specifying the server certificate. For more information about ARNs and how to use them in policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the <i>IAM User Guide</i>. </p>
    pub arn: String,
    /// <p>The date on which the certificate is set to expire.</p>
    pub expiration: Option<String>,
    /// <p> The path to the server certificate. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the <i>IAM User Guide</i>. </p>
    pub path: String,
    /// <p> The stable and unique string identifying the server certificate. For more information about IDs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the <i>IAM User Guide</i>. </p>
    pub server_certificate_id: String,
    /// <p>The name that identifies the server certificate.</p>
    pub server_certificate_name: String,
    /// <p>The date when the server certificate was uploaded.</p>
    pub upload_date: Option<String>,
}

#[allow(dead_code)]
struct ServerCertificateMetadataDeserializer;
impl ServerCertificateMetadataDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ServerCertificateMetadata, XmlParseError> {
        deserialize_elements::<_, ServerCertificateMetadata, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Arn" => {
                        obj.arn = ArnTypeDeserializer::deserialize("Arn", stack)?;
                    }
                    "Expiration" => {
                        obj.expiration =
                            Some(DateTypeDeserializer::deserialize("Expiration", stack)?);
                    }
                    "Path" => {
                        obj.path = PathTypeDeserializer::deserialize("Path", stack)?;
                    }
                    "ServerCertificateId" => {
                        obj.server_certificate_id =
                            IdTypeDeserializer::deserialize("ServerCertificateId", stack)?;
                    }
                    "ServerCertificateName" => {
                        obj.server_certificate_name =
                            ServerCertificateNameTypeDeserializer::deserialize(
                                "ServerCertificateName",
                                stack,
                            )?;
                    }
                    "UploadDate" => {
                        obj.upload_date =
                            Some(DateTypeDeserializer::deserialize("UploadDate", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct ServerCertificateMetadataListTypeDeserializer;
impl ServerCertificateMetadataListTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<ServerCertificateMetadata>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(ServerCertificateMetadataDeserializer::deserialize(
                    "member", stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct ServerCertificateNameTypeDeserializer;
impl ServerCertificateNameTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p>Contains details about the most recent attempt to access the service.</p> <p>This data type is used as a response element in the <a>GetServiceLastAccessedDetails</a> operation.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ServiceLastAccessed {
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when an authenticated entity most recently attempted to access the service. AWS does not report unauthenticated requests.</p> <p>This field is null if no IAM entities attempted to access the service within the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>.</p>
    pub last_authenticated: Option<String>,
    /// <p>The ARN of the authenticated entity (user or role) that last attempted to access the service. AWS does not report unauthenticated requests.</p> <p>This field is null if no IAM entities attempted to access the service within the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>.</p>
    pub last_authenticated_entity: Option<String>,
    /// <p>The Region from which the authenticated entity (user or role) last attempted to access the service. AWS does not report unauthenticated requests.</p> <p>This field is null if no IAM entities attempted to access the service within the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>.</p>
    pub last_authenticated_region: Option<String>,
    /// <p>The name of the service in which access was attempted.</p>
    pub service_name: String,
    /// <p>The namespace of the service in which access was attempted.</p> <p>To learn the service namespace of a service, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html">Actions, resources, and condition keys for AWS services</a> in the <i>Service Authorization Reference</i>. Choose the name of the service to view details for that service. In the first paragraph, find the service prefix. For example, <code>(service prefix: a4b)</code>. For more information about service namespaces, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces">AWS Service Namespaces</a> in the <i>AWS General Reference</i>.</p>
    pub service_namespace: String,
    /// <p>The total number of authenticated principals (root user, IAM users, or IAM roles) that have attempted to access the service.</p> <p>This field is null if no principals attempted to access the service within the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>.</p>
    pub total_authenticated_entities: Option<i64>,
    /// <p>An object that contains details about the most recent attempt to access a tracked action within the service.</p> <p>This field is null if there no tracked actions or if the principal did not use the tracked actions within the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>. This field is also null if the report was generated at the service level and not the action level. For more information, see the <code>Granularity</code> field in <a>GenerateServiceLastAccessedDetails</a>.</p>
    pub tracked_actions_last_accessed: Option<Vec<TrackedActionLastAccessed>>,
}

#[allow(dead_code)]
struct ServiceLastAccessedDeserializer;
impl ServiceLastAccessedDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ServiceLastAccessed, XmlParseError> {
        deserialize_elements::<_, ServiceLastAccessed, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "LastAuthenticated" => {
                    obj.last_authenticated = Some(DateTypeDeserializer::deserialize(
                        "LastAuthenticated",
                        stack,
                    )?);
                }
                "LastAuthenticatedEntity" => {
                    obj.last_authenticated_entity = Some(ArnTypeDeserializer::deserialize(
                        "LastAuthenticatedEntity",
                        stack,
                    )?);
                }
                "LastAuthenticatedRegion" => {
                    obj.last_authenticated_region = Some(StringTypeDeserializer::deserialize(
                        "LastAuthenticatedRegion",
                        stack,
                    )?);
                }
                "ServiceName" => {
                    obj.service_name =
                        ServiceNameTypeDeserializer::deserialize("ServiceName", stack)?;
                }
                "ServiceNamespace" => {
                    obj.service_namespace =
                        ServiceNamespaceTypeDeserializer::deserialize("ServiceNamespace", stack)?;
                }
                "TotalAuthenticatedEntities" => {
                    obj.total_authenticated_entities = Some(IntegerTypeDeserializer::deserialize(
                        "TotalAuthenticatedEntities",
                        stack,
                    )?);
                }
                "TrackedActionsLastAccessed" => {
                    obj.tracked_actions_last_accessed
                        .get_or_insert(vec![])
                        .extend(TrackedActionsLastAccessedDeserializer::deserialize(
                            "TrackedActionsLastAccessed",
                            stack,
                        )?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct ServiceNameDeserializer;
impl ServiceNameDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct ServiceNameTypeDeserializer;
impl ServiceNameTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}

/// Serialize `ServiceNamespaceListType` contents to a `SignedRequest`.
struct ServiceNamespaceListTypeSerializer;
impl ServiceNamespaceListTypeSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<String>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.member.{}", name, index + 1);
            params.put(&key, &obj);
        }
    }
}

#[allow(dead_code)]
struct ServiceNamespaceTypeDeserializer;
impl ServiceNamespaceTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct ServicePasswordDeserializer;
impl ServicePasswordDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p>Contains the details of a service-specific credential.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ServiceSpecificCredential {
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the service-specific credential were created.</p>
    pub create_date: String,
    /// <p>The name of the service associated with the service-specific credential.</p>
    pub service_name: String,
    /// <p>The generated password for the service-specific credential.</p>
    pub service_password: String,
    /// <p>The unique identifier for the service-specific credential.</p>
    pub service_specific_credential_id: String,
    /// <p>The generated user name for the service-specific credential. This value is generated by combining the IAM user's name combined with the ID number of the AWS account, as in <code>jane-at-123456789012</code>, for example. This value cannot be configured by the user.</p>
    pub service_user_name: String,
    /// <p>The status of the service-specific credential. <code>Active</code> means that the key is valid for API calls, while <code>Inactive</code> means it is not.</p>
    pub status: String,
    /// <p>The name of the IAM user associated with the service-specific credential.</p>
    pub user_name: String,
}

#[allow(dead_code)]
struct ServiceSpecificCredentialDeserializer;
impl ServiceSpecificCredentialDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ServiceSpecificCredential, XmlParseError> {
        deserialize_elements::<_, ServiceSpecificCredential, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "CreateDate" => {
                        obj.create_date = DateTypeDeserializer::deserialize("CreateDate", stack)?;
                    }
                    "ServiceName" => {
                        obj.service_name =
                            ServiceNameDeserializer::deserialize("ServiceName", stack)?;
                    }
                    "ServicePassword" => {
                        obj.service_password =
                            ServicePasswordDeserializer::deserialize("ServicePassword", stack)?;
                    }
                    "ServiceSpecificCredentialId" => {
                        obj.service_specific_credential_id =
                            ServiceSpecificCredentialIdDeserializer::deserialize(
                                "ServiceSpecificCredentialId",
                                stack,
                            )?;
                    }
                    "ServiceUserName" => {
                        obj.service_user_name =
                            ServiceUserNameDeserializer::deserialize("ServiceUserName", stack)?;
                    }
                    "Status" => {
                        obj.status = StatusTypeDeserializer::deserialize("Status", stack)?;
                    }
                    "UserName" => {
                        obj.user_name = UserNameTypeDeserializer::deserialize("UserName", stack)?;
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct ServiceSpecificCredentialIdDeserializer;
impl ServiceSpecificCredentialIdDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p>Contains additional details about a service-specific credential.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ServiceSpecificCredentialMetadata {
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the service-specific credential were created.</p>
    pub create_date: String,
    /// <p>The name of the service associated with the service-specific credential.</p>
    pub service_name: String,
    /// <p>The unique identifier for the service-specific credential.</p>
    pub service_specific_credential_id: String,
    /// <p>The generated user name for the service-specific credential.</p>
    pub service_user_name: String,
    /// <p>The status of the service-specific credential. <code>Active</code> means that the key is valid for API calls, while <code>Inactive</code> means it is not.</p>
    pub status: String,
    /// <p>The name of the IAM user associated with the service-specific credential.</p>
    pub user_name: String,
}

#[allow(dead_code)]
struct ServiceSpecificCredentialMetadataDeserializer;
impl ServiceSpecificCredentialMetadataDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ServiceSpecificCredentialMetadata, XmlParseError> {
        deserialize_elements::<_, ServiceSpecificCredentialMetadata, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "CreateDate" => {
                        obj.create_date = DateTypeDeserializer::deserialize("CreateDate", stack)?;
                    }
                    "ServiceName" => {
                        obj.service_name =
                            ServiceNameDeserializer::deserialize("ServiceName", stack)?;
                    }
                    "ServiceSpecificCredentialId" => {
                        obj.service_specific_credential_id =
                            ServiceSpecificCredentialIdDeserializer::deserialize(
                                "ServiceSpecificCredentialId",
                                stack,
                            )?;
                    }
                    "ServiceUserName" => {
                        obj.service_user_name =
                            ServiceUserNameDeserializer::deserialize("ServiceUserName", stack)?;
                    }
                    "Status" => {
                        obj.status = StatusTypeDeserializer::deserialize("Status", stack)?;
                    }
                    "UserName" => {
                        obj.user_name = UserNameTypeDeserializer::deserialize("UserName", stack)?;
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct ServiceSpecificCredentialsListTypeDeserializer;
impl ServiceSpecificCredentialsListTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<ServiceSpecificCredentialMetadata>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(ServiceSpecificCredentialMetadataDeserializer::deserialize(
                    "member", stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct ServiceUserNameDeserializer;
impl ServiceUserNameDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct ServicesLastAccessedDeserializer;
impl ServicesLastAccessedDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<ServiceLastAccessed>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(ServiceLastAccessedDeserializer::deserialize(
                    "member", stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct SetDefaultPolicyVersionRequest {
    /// <p>The Amazon Resource Name (ARN) of the IAM policy whose default version you want to set.</p> <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub policy_arn: String,
    /// <p>The version of the policy to set as the default (operative) version.</p> <p>For more information about managed policy versions, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed policies</a> in the <i>IAM User Guide</i>.</p>
    pub version_id: String,
}

/// Serialize `SetDefaultPolicyVersionRequest` contents to a `SignedRequest`.
struct SetDefaultPolicyVersionRequestSerializer;
impl SetDefaultPolicyVersionRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &SetDefaultPolicyVersionRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "PolicyArn"), &obj.policy_arn);
        params.put(&format!("{}{}", prefix, "VersionId"), &obj.version_id);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct SetSecurityTokenServicePreferencesRequest {
    /// <p>The version of the global endpoint token. Version 1 tokens are valid only in AWS Regions that are available by default. These tokens do not work in manually enabled Regions, such as Asia Pacific (Hong Kong). Version 2 tokens are valid in all Regions. However, version 2 tokens are longer and might affect systems where you temporarily store tokens.</p> <p>For information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating and deactivating STS in an AWS region</a> in the <i>IAM User Guide</i>.</p>
    pub global_endpoint_token_version: String,
}

/// Serialize `SetSecurityTokenServicePreferencesRequest` contents to a `SignedRequest`.
struct SetSecurityTokenServicePreferencesRequestSerializer;
impl SetSecurityTokenServicePreferencesRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &SetSecurityTokenServicePreferencesRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "GlobalEndpointTokenVersion"),
            &obj.global_endpoint_token_version,
        );
    }
}

/// <p>Contains information about an X.509 signing certificate.</p> <p>This data type is used as a response element in the <a>UploadSigningCertificate</a> and <a>ListSigningCertificates</a> operations. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct SigningCertificate {
    /// <p>The contents of the signing certificate.</p>
    pub certificate_body: String,
    /// <p>The ID for the signing certificate.</p>
    pub certificate_id: String,
    /// <p>The status of the signing certificate. <code>Active</code> means that the key is valid for API calls, while <code>Inactive</code> means it is not.</p>
    pub status: String,
    /// <p>The date when the signing certificate was uploaded.</p>
    pub upload_date: Option<String>,
    /// <p>The name of the user the signing certificate is associated with.</p>
    pub user_name: String,
}

#[allow(dead_code)]
struct SigningCertificateDeserializer;
impl SigningCertificateDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<SigningCertificate, XmlParseError> {
        deserialize_elements::<_, SigningCertificate, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "CertificateBody" => {
                    obj.certificate_body =
                        CertificateBodyTypeDeserializer::deserialize("CertificateBody", stack)?;
                }
                "CertificateId" => {
                    obj.certificate_id =
                        CertificateIdTypeDeserializer::deserialize("CertificateId", stack)?;
                }
                "Status" => {
                    obj.status = StatusTypeDeserializer::deserialize("Status", stack)?;
                }
                "UploadDate" => {
                    obj.upload_date = Some(DateTypeDeserializer::deserialize("UploadDate", stack)?);
                }
                "UserName" => {
                    obj.user_name = UserNameTypeDeserializer::deserialize("UserName", stack)?;
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct SimulateCustomPolicyRequest {
    /// <p>A list of names of API operations to evaluate in the simulation. Each operation is evaluated against each resource. Each operation must include the service identifier, such as <code>iam:CreateUser</code>. This operation does not support using wildcards (*) in an action name.</p>
    pub action_names: Vec<String>,
    /// <p>The ARN of the IAM user that you want to use as the simulated caller of the API operations. <code>CallerArn</code> is required if you include a <code>ResourcePolicy</code> so that the policy's <code>Principal</code> element has a value to use in evaluating the policy.</p> <p>You can specify only the ARN of an IAM user. You cannot specify the ARN of an assumed role, federated user, or a service principal.</p>
    pub caller_arn: Option<String>,
    /// <p>A list of context keys and corresponding values for the simulation to use. Whenever a context key is evaluated in one of the simulated IAM permissions policies, the corresponding value is supplied.</p>
    pub context_entries: Option<Vec<ContextEntry>>,
    /// <p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>
    pub marker: Option<String>,
    /// <p>Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>
    pub max_items: Option<i64>,
    /// <p><p>The IAM permissions boundary policy to simulate. The permissions boundary sets the maximum permissions that an IAM entity can have. You can input only one permissions boundary when you pass a policy to this operation. For more information about permissions boundaries, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM entities</a> in the <i>IAM User Guide</i>. The policy input is specified as a string that contains the complete, valid JSON text of a permissions boundary policy.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of characters consisting of the following:</p> <ul> <li> <p>Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p> </li> <li> <p>The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>)</p> </li> <li> <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>)</p> </li> </ul></p>
    pub permissions_boundary_policy_input_list: Option<Vec<String>>,
    /// <p><p>A list of policy documents to include in the simulation. Each document is specified as a string containing the complete, valid JSON text of an IAM policy. Do not include any resource-based policies in this parameter. Any resource-based policy must be submitted with the <code>ResourcePolicy</code> parameter. The policies cannot be &quot;scope-down&quot; policies, such as you could include in a call to <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetFederationToken.html">GetFederationToken</a> or one of the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_AssumeRole.html">AssumeRole</a> API operations. In other words, do not use policies designed to restrict what a user can do while using the temporary credentials.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of characters consisting of the following:</p> <ul> <li> <p>Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p> </li> <li> <p>The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>)</p> </li> <li> <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>)</p> </li> </ul></p>
    pub policy_input_list: Vec<String>,
    /// <p>A list of ARNs of AWS resources to include in the simulation. If this parameter is not provided, then the value defaults to <code>*</code> (all resources). Each API in the <code>ActionNames</code> parameter is evaluated for each resource in this list. The simulation determines the access result (allowed or denied) of each combination and reports it in the response. You can simulate resources that don't exist in your account.</p> <p>The simulation does not automatically retrieve policies for the specified resources. If you want to include a resource policy in the simulation, then you must include the policy as a string in the <code>ResourcePolicy</code> parameter.</p> <p>If you include a <code>ResourcePolicy</code>, then it must be applicable to all of the resources included in the simulation or you receive an invalid input error.</p> <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub resource_arns: Option<Vec<String>>,
    /// <p><p>Specifies the type of simulation to run. Different API operations that support resource-based policies require different combinations of resources. By specifying the type of simulation to run, you enable the policy simulator to enforce the presence of the required resources to ensure reliable simulation results. If your simulation does not match one of the following scenarios, then you can omit this parameter. The following list shows each of the supported scenario values and the resources that you must define to run the simulation.</p> <p>Each of the EC2 scenarios requires that you specify instance, image, and security-group resources. If your scenario includes an EBS volume, then you must specify that volume as a resource. If the EC2 scenario includes VPC, then you must supply the network-interface resource. If it includes an IP subnet, then you must specify the subnet resource. For more information on the EC2 scenario options, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported platforms</a> in the <i>Amazon EC2 User Guide</i>.</p> <ul> <li> <p> <b>EC2-Classic-InstanceStore</b> </p> <p>instance, image, security-group</p> </li> <li> <p> <b>EC2-Classic-EBS</b> </p> <p>instance, image, security-group, volume</p> </li> <li> <p> <b>EC2-VPC-InstanceStore</b> </p> <p>instance, image, security-group, network-interface</p> </li> <li> <p> <b>EC2-VPC-InstanceStore-Subnet</b> </p> <p>instance, image, security-group, network-interface, subnet</p> </li> <li> <p> <b>EC2-VPC-EBS</b> </p> <p>instance, image, security-group, network-interface, volume</p> </li> <li> <p> <b>EC2-VPC-EBS-Subnet</b> </p> <p>instance, image, security-group, network-interface, subnet, volume</p> </li> </ul></p>
    pub resource_handling_option: Option<String>,
    /// <p>An ARN representing the AWS account ID that specifies the owner of any simulated resource that does not identify its owner in the resource ARN. Examples of resource ARNs include an S3 bucket or object. If <code>ResourceOwner</code> is specified, it is also used as the account owner of any <code>ResourcePolicy</code> included in the simulation. If the <code>ResourceOwner</code> parameter is not specified, then the owner of the resources and the resource policy defaults to the account of the identity provided in <code>CallerArn</code>. This parameter is required only if you specify a resource-based policy and account that owns the resource is different from the account that owns the simulated calling user <code>CallerArn</code>.</p> <p>The ARN for an account uses the following syntax: <code>arn:aws:iam::<i>AWS-account-ID</i>:root</code>. For example, to represent the account with the 112233445566 ID, use the following ARN: <code>arn:aws:iam::112233445566-ID:root</code>. </p>
    pub resource_owner: Option<String>,
    /// <p><p>A resource-based policy to include in the simulation provided as a string. Each resource in the simulation is treated as if it had this policy attached. You can include only one resource-based policy in a simulation.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of characters consisting of the following:</p> <ul> <li> <p>Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p> </li> <li> <p>The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>)</p> </li> <li> <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>)</p> </li> </ul></p>
    pub resource_policy: Option<String>,
}

/// Serialize `SimulateCustomPolicyRequest` contents to a `SignedRequest`.
struct SimulateCustomPolicyRequestSerializer;
impl SimulateCustomPolicyRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &SimulateCustomPolicyRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        ActionNameListTypeSerializer::serialize(
            params,
            &format!("{}{}", prefix, "ActionNames"),
            &obj.action_names,
        );
        if let Some(ref field_value) = obj.caller_arn {
            params.put(&format!("{}{}", prefix, "CallerArn"), &field_value);
        }
        if let Some(ref field_value) = obj.context_entries {
            ContextEntryListTypeSerializer::serialize(
                params,
                &format!("{}{}", prefix, "ContextEntries"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_items {
            params.put(&format!("{}{}", prefix, "MaxItems"), &field_value);
        }
        if let Some(ref field_value) = obj.permissions_boundary_policy_input_list {
            SimulationPolicyListTypeSerializer::serialize(
                params,
                &format!("{}{}", prefix, "PermissionsBoundaryPolicyInputList"),
                field_value,
            );
        }
        SimulationPolicyListTypeSerializer::serialize(
            params,
            &format!("{}{}", prefix, "PolicyInputList"),
            &obj.policy_input_list,
        );
        if let Some(ref field_value) = obj.resource_arns {
            ResourceNameListTypeSerializer::serialize(
                params,
                &format!("{}{}", prefix, "ResourceArns"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.resource_handling_option {
            params.put(
                &format!("{}{}", prefix, "ResourceHandlingOption"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.resource_owner {
            params.put(&format!("{}{}", prefix, "ResourceOwner"), &field_value);
        }
        if let Some(ref field_value) = obj.resource_policy {
            params.put(&format!("{}{}", prefix, "ResourcePolicy"), &field_value);
        }
    }
}

/// <p>Contains the response to a successful <a>SimulatePrincipalPolicy</a> or <a>SimulateCustomPolicy</a> request.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct SimulatePolicyResponse {
    /// <p>The results of the simulation.</p>
    pub evaluation_results: Option<Vec<EvaluationResult>>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: Option<bool>,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: Option<String>,
}

#[allow(dead_code)]
struct SimulatePolicyResponseDeserializer;
impl SimulatePolicyResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<SimulatePolicyResponse, XmlParseError> {
        deserialize_elements::<_, SimulatePolicyResponse, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "EvaluationResults" => {
                    obj.evaluation_results.get_or_insert(vec![]).extend(
                        EvaluationResultsListTypeDeserializer::deserialize(
                            "EvaluationResults",
                            stack,
                        )?,
                    );
                }
                "IsTruncated" => {
                    obj.is_truncated =
                        Some(BooleanTypeDeserializer::deserialize("IsTruncated", stack)?);
                }
                "Marker" => {
                    obj.marker = Some(ResponseMarkerTypeDeserializer::deserialize(
                        "Marker", stack,
                    )?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct SimulatePrincipalPolicyRequest {
    /// <p>A list of names of API operations to evaluate in the simulation. Each operation is evaluated for each resource. Each operation must include the service identifier, such as <code>iam:CreateUser</code>.</p>
    pub action_names: Vec<String>,
    /// <p>The ARN of the IAM user that you want to specify as the simulated caller of the API operations. If you do not specify a <code>CallerArn</code>, it defaults to the ARN of the user that you specify in <code>PolicySourceArn</code>, if you specified a user. If you include both a <code>PolicySourceArn</code> (for example, <code>arn:aws:iam::123456789012:user/David</code>) and a <code>CallerArn</code> (for example, <code>arn:aws:iam::123456789012:user/Bob</code>), the result is that you simulate calling the API operations as Bob, as if Bob had David's policies.</p> <p>You can specify only the ARN of an IAM user. You cannot specify the ARN of an assumed role, federated user, or a service principal.</p> <p> <code>CallerArn</code> is required if you include a <code>ResourcePolicy</code> and the <code>PolicySourceArn</code> is not the ARN for an IAM user. This is required so that the resource-based policy's <code>Principal</code> element has a value to use in evaluating the policy.</p> <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub caller_arn: Option<String>,
    /// <p>A list of context keys and corresponding values for the simulation to use. Whenever a context key is evaluated in one of the simulated IAM permissions policies, the corresponding value is supplied.</p>
    pub context_entries: Option<Vec<ContextEntry>>,
    /// <p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>
    pub marker: Option<String>,
    /// <p>Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>
    pub max_items: Option<i64>,
    /// <p><p>The IAM permissions boundary policy to simulate. The permissions boundary sets the maximum permissions that the entity can have. You can input only one permissions boundary when you pass a policy to this operation. An IAM entity can only have one permissions boundary in effect at a time. For example, if a permissions boundary is attached to an entity and you pass in a different permissions boundary policy using this parameter, then the new permissions boundary policy is used for the simulation. For more information about permissions boundaries, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM entities</a> in the <i>IAM User Guide</i>. The policy input is specified as a string containing the complete, valid JSON text of a permissions boundary policy.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of characters consisting of the following:</p> <ul> <li> <p>Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p> </li> <li> <p>The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>)</p> </li> <li> <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>)</p> </li> </ul></p>
    pub permissions_boundary_policy_input_list: Option<Vec<String>>,
    /// <p><p>An optional list of additional policy documents to include in the simulation. Each document is specified as a string containing the complete, valid JSON text of an IAM policy.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of characters consisting of the following:</p> <ul> <li> <p>Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p> </li> <li> <p>The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>)</p> </li> <li> <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>)</p> </li> </ul></p>
    pub policy_input_list: Option<Vec<String>>,
    /// <p>The Amazon Resource Name (ARN) of a user, group, or role whose policies you want to include in the simulation. If you specify a user, group, or role, the simulation includes all policies that are associated with that entity. If you specify a user, the simulation also includes all policies that are attached to any groups the user belongs to.</p> <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub policy_source_arn: String,
    /// <p>A list of ARNs of AWS resources to include in the simulation. If this parameter is not provided, then the value defaults to <code>*</code> (all resources). Each API in the <code>ActionNames</code> parameter is evaluated for each resource in this list. The simulation determines the access result (allowed or denied) of each combination and reports it in the response. You can simulate resources that don't exist in your account.</p> <p>The simulation does not automatically retrieve policies for the specified resources. If you want to include a resource policy in the simulation, then you must include the policy as a string in the <code>ResourcePolicy</code> parameter.</p> <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub resource_arns: Option<Vec<String>>,
    /// <p><p>Specifies the type of simulation to run. Different API operations that support resource-based policies require different combinations of resources. By specifying the type of simulation to run, you enable the policy simulator to enforce the presence of the required resources to ensure reliable simulation results. If your simulation does not match one of the following scenarios, then you can omit this parameter. The following list shows each of the supported scenario values and the resources that you must define to run the simulation.</p> <p>Each of the EC2 scenarios requires that you specify instance, image, and security group resources. If your scenario includes an EBS volume, then you must specify that volume as a resource. If the EC2 scenario includes VPC, then you must supply the network interface resource. If it includes an IP subnet, then you must specify the subnet resource. For more information on the EC2 scenario options, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported platforms</a> in the <i>Amazon EC2 User Guide</i>.</p> <ul> <li> <p> <b>EC2-Classic-InstanceStore</b> </p> <p>instance, image, security group</p> </li> <li> <p> <b>EC2-Classic-EBS</b> </p> <p>instance, image, security group, volume</p> </li> <li> <p> <b>EC2-VPC-InstanceStore</b> </p> <p>instance, image, security group, network interface</p> </li> <li> <p> <b>EC2-VPC-InstanceStore-Subnet</b> </p> <p>instance, image, security group, network interface, subnet</p> </li> <li> <p> <b>EC2-VPC-EBS</b> </p> <p>instance, image, security group, network interface, volume</p> </li> <li> <p> <b>EC2-VPC-EBS-Subnet</b> </p> <p>instance, image, security group, network interface, subnet, volume</p> </li> </ul></p>
    pub resource_handling_option: Option<String>,
    /// <p>An AWS account ID that specifies the owner of any simulated resource that does not identify its owner in the resource ARN. Examples of resource ARNs include an S3 bucket or object. If <code>ResourceOwner</code> is specified, it is also used as the account owner of any <code>ResourcePolicy</code> included in the simulation. If the <code>ResourceOwner</code> parameter is not specified, then the owner of the resources and the resource policy defaults to the account of the identity provided in <code>CallerArn</code>. This parameter is required only if you specify a resource-based policy and account that owns the resource is different from the account that owns the simulated calling user <code>CallerArn</code>.</p>
    pub resource_owner: Option<String>,
    /// <p><p>A resource-based policy to include in the simulation provided as a string. Each resource in the simulation is treated as if it had this policy attached. You can include only one resource-based policy in a simulation.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of characters consisting of the following:</p> <ul> <li> <p>Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p> </li> <li> <p>The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>)</p> </li> <li> <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>)</p> </li> </ul></p>
    pub resource_policy: Option<String>,
}

/// Serialize `SimulatePrincipalPolicyRequest` contents to a `SignedRequest`.
struct SimulatePrincipalPolicyRequestSerializer;
impl SimulatePrincipalPolicyRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &SimulatePrincipalPolicyRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        ActionNameListTypeSerializer::serialize(
            params,
            &format!("{}{}", prefix, "ActionNames"),
            &obj.action_names,
        );
        if let Some(ref field_value) = obj.caller_arn {
            params.put(&format!("{}{}", prefix, "CallerArn"), &field_value);
        }
        if let Some(ref field_value) = obj.context_entries {
            ContextEntryListTypeSerializer::serialize(
                params,
                &format!("{}{}", prefix, "ContextEntries"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_items {
            params.put(&format!("{}{}", prefix, "MaxItems"), &field_value);
        }
        if let Some(ref field_value) = obj.permissions_boundary_policy_input_list {
            SimulationPolicyListTypeSerializer::serialize(
                params,
                &format!("{}{}", prefix, "PermissionsBoundaryPolicyInputList"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.policy_input_list {
            SimulationPolicyListTypeSerializer::serialize(
                params,
                &format!("{}{}", prefix, "PolicyInputList"),
                field_value,
            );
        }
        params.put(
            &format!("{}{}", prefix, "PolicySourceArn"),
            &obj.policy_source_arn,
        );
        if let Some(ref field_value) = obj.resource_arns {
            ResourceNameListTypeSerializer::serialize(
                params,
                &format!("{}{}", prefix, "ResourceArns"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.resource_handling_option {
            params.put(
                &format!("{}{}", prefix, "ResourceHandlingOption"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.resource_owner {
            params.put(&format!("{}{}", prefix, "ResourceOwner"), &field_value);
        }
        if let Some(ref field_value) = obj.resource_policy {
            params.put(&format!("{}{}", prefix, "ResourcePolicy"), &field_value);
        }
    }
}

/// Serialize `SimulationPolicyListType` contents to a `SignedRequest`.
struct SimulationPolicyListTypeSerializer;
impl SimulationPolicyListTypeSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<String>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.member.{}", name, index + 1);
            params.put(&key, &obj);
        }
    }
}

/// <p>Contains a reference to a <code>Statement</code> element in a policy document that determines the result of the simulation.</p> <p>This data type is used by the <code>MatchedStatements</code> member of the <code> <a>EvaluationResult</a> </code> type.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct Statement {
    /// <p>The row and column of the end of a <code>Statement</code> in an IAM policy.</p>
    pub end_position: Option<Position>,
    /// <p>The identifier of the policy that was provided as an input.</p>
    pub source_policy_id: Option<String>,
    /// <p>The type of the policy.</p>
    pub source_policy_type: Option<String>,
    /// <p>The row and column of the beginning of the <code>Statement</code> in an IAM policy.</p>
    pub start_position: Option<Position>,
}

#[allow(dead_code)]
struct StatementDeserializer;
impl StatementDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Statement, XmlParseError> {
        deserialize_elements::<_, Statement, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "EndPosition" => {
                    obj.end_position =
                        Some(PositionDeserializer::deserialize("EndPosition", stack)?);
                }
                "SourcePolicyId" => {
                    obj.source_policy_id = Some(PolicyIdentifierTypeDeserializer::deserialize(
                        "SourcePolicyId",
                        stack,
                    )?);
                }
                "SourcePolicyType" => {
                    obj.source_policy_type = Some(PolicySourceTypeDeserializer::deserialize(
                        "SourcePolicyType",
                        stack,
                    )?);
                }
                "StartPosition" => {
                    obj.start_position =
                        Some(PositionDeserializer::deserialize("StartPosition", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct StatementListTypeDeserializer;
impl StatementListTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<Statement>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(StatementDeserializer::deserialize("member", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct StatusTypeDeserializer;
impl StatusTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct StringTypeDeserializer;
impl StringTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct SummaryKeyTypeDeserializer;
impl SummaryKeyTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct SummaryMapTypeDeserializer;
impl SummaryMapTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<::std::collections::HashMap<String, i64>, XmlParseError> {
        xml_util::start_element(tag_name, stack)?;

        let mut obj = ::std::collections::HashMap::new();

        while xml_util::peek_at_name(stack)? == "entry" {
            xml_util::start_element("entry", stack)?;
            let key = SummaryKeyTypeDeserializer::deserialize("key", stack)?;
            let value = SummaryValueTypeDeserializer::deserialize("value", stack)?;
            obj.insert(key, value);
            xml_util::end_element("entry", stack)?;
        }

        xml_util::end_element(tag_name, stack)?;
        Ok(obj)
    }
}
#[allow(dead_code)]
struct SummaryValueTypeDeserializer;
impl SummaryValueTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<i64, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, |s| Ok(i64::from_str(&s).unwrap()))
    }
}
/// <p>A structure that represents user-provided metadata that can be associated with an IAM resource. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User Guide</i>.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct Tag {
    /// <p>The key name that can be used to look up or retrieve the associated value. For example, <code>Department</code> or <code>Cost Center</code> are common choices.</p>
    pub key: String,
    /// <p><p>The value associated with this tag. For example, tags with a key name of <code>Department</code> could have values such as <code>Human Resources</code>, <code>Accounting</code>, and <code>Support</code>. Tags with a key name of <code>Cost Center</code> might have values that consist of the number associated with the different cost centers in your company. Typically, many resources have tags with the same key name but with different values.</p> <note> <p>AWS always interprets the tag <code>Value</code> as a single string. If you need to store an array, you can store comma-separated values in the string. However, you must interpret the value in your code.</p> </note></p>
    pub value: String,
}

#[allow(dead_code)]
struct TagDeserializer;
impl TagDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<Tag, XmlParseError> {
        deserialize_elements::<_, Tag, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Key" => {
                    obj.key = TagKeyTypeDeserializer::deserialize("Key", stack)?;
                }
                "Value" => {
                    obj.value = TagValueTypeDeserializer::deserialize("Value", stack)?;
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}

/// Serialize `Tag` contents to a `SignedRequest`.
struct TagSerializer;
impl TagSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Tag) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "Key"), &obj.key);
        params.put(&format!("{}{}", prefix, "Value"), &obj.value);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct TagInstanceProfileRequest {
    /// <p>The name of the IAM instance profile to which you want to add tags.</p> <p>This parameter accepts (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that consist of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>
    pub instance_profile_name: String,
    /// <p>The list of tags that you want to attach to the IAM instance profile. Each tag consists of a key name and an associated value.</p>
    pub tags: Vec<Tag>,
}

/// Serialize `TagInstanceProfileRequest` contents to a `SignedRequest`.
struct TagInstanceProfileRequestSerializer;
impl TagInstanceProfileRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &TagInstanceProfileRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "InstanceProfileName"),
            &obj.instance_profile_name,
        );
        TagListTypeSerializer::serialize(params, &format!("{}{}", prefix, "Tags"), &obj.tags);
    }
}

/// Serialize `TagKeyListType` contents to a `SignedRequest`.
struct TagKeyListTypeSerializer;
impl TagKeyListTypeSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<String>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.member.{}", name, index + 1);
            params.put(&key, &obj);
        }
    }
}

#[allow(dead_code)]
struct TagKeyTypeDeserializer;
impl TagKeyTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct TagListTypeDeserializer;
impl TagListTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<Tag>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(TagDeserializer::deserialize("member", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}

/// Serialize `TagListType` contents to a `SignedRequest`.
struct TagListTypeSerializer;
impl TagListTypeSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<Tag>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.member.{}", name, index + 1);
            TagSerializer::serialize(params, &key, obj);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct TagMFADeviceRequest {
    /// <p>The unique identifier for the IAM virtual MFA device to which you want to add tags. For virtual MFA devices, the serial number is the same as the ARN.</p> <p>This parameter accepts (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that consist of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>
    pub serial_number: String,
    /// <p>The list of tags that you want to attach to the IAM virtual MFA device. Each tag consists of a key name and an associated value.</p>
    pub tags: Vec<Tag>,
}

/// Serialize `TagMFADeviceRequest` contents to a `SignedRequest`.
struct TagMFADeviceRequestSerializer;
impl TagMFADeviceRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &TagMFADeviceRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "SerialNumber"), &obj.serial_number);
        TagListTypeSerializer::serialize(params, &format!("{}{}", prefix, "Tags"), &obj.tags);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct TagOpenIDConnectProviderRequest {
    /// <p>The ARN of the OIDC identity provider in IAM to which you want to add tags.</p> <p>This parameter accepts (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that consist of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>
    pub open_id_connect_provider_arn: String,
    /// <p>The list of tags that you want to attach to the OIDC identity provider in IAM. Each tag consists of a key name and an associated value.</p>
    pub tags: Vec<Tag>,
}

/// Serialize `TagOpenIDConnectProviderRequest` contents to a `SignedRequest`.
struct TagOpenIDConnectProviderRequestSerializer;
impl TagOpenIDConnectProviderRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &TagOpenIDConnectProviderRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "OpenIDConnectProviderArn"),
            &obj.open_id_connect_provider_arn,
        );
        TagListTypeSerializer::serialize(params, &format!("{}{}", prefix, "Tags"), &obj.tags);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct TagPolicyRequest {
    /// <p>The ARN of the IAM customer managed policy to which you want to add tags.</p> <p>This parameter accepts (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that consist of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>
    pub policy_arn: String,
    /// <p>The list of tags that you want to attach to the IAM customer managed policy. Each tag consists of a key name and an associated value.</p>
    pub tags: Vec<Tag>,
}

/// Serialize `TagPolicyRequest` contents to a `SignedRequest`.
struct TagPolicyRequestSerializer;
impl TagPolicyRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &TagPolicyRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "PolicyArn"), &obj.policy_arn);
        TagListTypeSerializer::serialize(params, &format!("{}{}", prefix, "Tags"), &obj.tags);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct TagRoleRequest {
    /// <p>The name of the IAM role to which you want to add tags.</p> <p>This parameter accepts (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that consist of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub role_name: String,
    /// <p>The list of tags that you want to attach to the IAM role. Each tag consists of a key name and an associated value.</p>
    pub tags: Vec<Tag>,
}

/// Serialize `TagRoleRequest` contents to a `SignedRequest`.
struct TagRoleRequestSerializer;
impl TagRoleRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &TagRoleRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "RoleName"), &obj.role_name);
        TagListTypeSerializer::serialize(params, &format!("{}{}", prefix, "Tags"), &obj.tags);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct TagSAMLProviderRequest {
    /// <p>The ARN of the SAML identity provider in IAM to which you want to add tags.</p> <p>This parameter accepts (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that consist of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>
    pub saml_provider_arn: String,
    /// <p>The list of tags that you want to attach to the SAML identity provider in IAM. Each tag consists of a key name and an associated value.</p>
    pub tags: Vec<Tag>,
}

/// Serialize `TagSAMLProviderRequest` contents to a `SignedRequest`.
struct TagSAMLProviderRequestSerializer;
impl TagSAMLProviderRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &TagSAMLProviderRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "SAMLProviderArn"),
            &obj.saml_provider_arn,
        );
        TagListTypeSerializer::serialize(params, &format!("{}{}", prefix, "Tags"), &obj.tags);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct TagServerCertificateRequest {
    /// <p>The name of the IAM server certificate to which you want to add tags.</p> <p>This parameter accepts (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that consist of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>
    pub server_certificate_name: String,
    /// <p>The list of tags that you want to attach to the IAM server certificate. Each tag consists of a key name and an associated value.</p>
    pub tags: Vec<Tag>,
}

/// Serialize `TagServerCertificateRequest` contents to a `SignedRequest`.
struct TagServerCertificateRequestSerializer;
impl TagServerCertificateRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &TagServerCertificateRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "ServerCertificateName"),
            &obj.server_certificate_name,
        );
        TagListTypeSerializer::serialize(params, &format!("{}{}", prefix, "Tags"), &obj.tags);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct TagUserRequest {
    /// <p>The list of tags that you want to attach to the IAM user. Each tag consists of a key name and an associated value.</p>
    pub tags: Vec<Tag>,
    /// <p>The name of the IAM user to which you want to add tags.</p> <p>This parameter accepts (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that consist of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>
    pub user_name: String,
}

/// Serialize `TagUserRequest` contents to a `SignedRequest`.
struct TagUserRequestSerializer;
impl TagUserRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &TagUserRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        TagListTypeSerializer::serialize(params, &format!("{}{}", prefix, "Tags"), &obj.tags);
        params.put(&format!("{}{}", prefix, "UserName"), &obj.user_name);
    }
}

#[allow(dead_code)]
struct TagValueTypeDeserializer;
impl TagValueTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct ThumbprintListTypeDeserializer;
impl ThumbprintListTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<String>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(ThumbprintTypeDeserializer::deserialize("member", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}

/// Serialize `ThumbprintListType` contents to a `SignedRequest`.
struct ThumbprintListTypeSerializer;
impl ThumbprintListTypeSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<String>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.member.{}", name, index + 1);
            params.put(&key, &obj);
        }
    }
}

#[allow(dead_code)]
struct ThumbprintTypeDeserializer;
impl ThumbprintTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p>Contains details about the most recent attempt to access an action within the service.</p> <p>This data type is used as a response element in the <a>GetServiceLastAccessedDetails</a> operation.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct TrackedActionLastAccessed {
    /// <p>The name of the tracked action to which access was attempted. Tracked actions are actions that report activity to IAM.</p>
    pub action_name: Option<String>,
    pub last_accessed_entity: Option<String>,
    /// <p>The Region from which the authenticated entity (user or role) last attempted to access the tracked action. AWS does not report unauthenticated requests.</p> <p>This field is null if no IAM entities attempted to access the service within the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>.</p>
    pub last_accessed_region: Option<String>,
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when an authenticated entity most recently attempted to access the tracked service. AWS does not report unauthenticated requests.</p> <p>This field is null if no IAM entities attempted to access the service within the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>.</p>
    pub last_accessed_time: Option<String>,
}

#[allow(dead_code)]
struct TrackedActionLastAccessedDeserializer;
impl TrackedActionLastAccessedDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<TrackedActionLastAccessed, XmlParseError> {
        deserialize_elements::<_, TrackedActionLastAccessed, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "ActionName" => {
                        obj.action_name =
                            Some(StringTypeDeserializer::deserialize("ActionName", stack)?);
                    }
                    "LastAccessedEntity" => {
                        obj.last_accessed_entity = Some(ArnTypeDeserializer::deserialize(
                            "LastAccessedEntity",
                            stack,
                        )?);
                    }
                    "LastAccessedRegion" => {
                        obj.last_accessed_region = Some(StringTypeDeserializer::deserialize(
                            "LastAccessedRegion",
                            stack,
                        )?);
                    }
                    "LastAccessedTime" => {
                        obj.last_accessed_time = Some(DateTypeDeserializer::deserialize(
                            "LastAccessedTime",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct TrackedActionsLastAccessedDeserializer;
impl TrackedActionsLastAccessedDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<TrackedActionLastAccessed>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(TrackedActionLastAccessedDeserializer::deserialize(
                    "member", stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UntagInstanceProfileRequest {
    /// <p>The name of the IAM instance profile from which you want to remove tags.</p> <p>This parameter accepts (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that consist of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>
    pub instance_profile_name: String,
    /// <p>A list of key names as a simple array of strings. The tags with matching keys are removed from the specified instance profile.</p>
    pub tag_keys: Vec<String>,
}

/// Serialize `UntagInstanceProfileRequest` contents to a `SignedRequest`.
struct UntagInstanceProfileRequestSerializer;
impl UntagInstanceProfileRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &UntagInstanceProfileRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "InstanceProfileName"),
            &obj.instance_profile_name,
        );
        TagKeyListTypeSerializer::serialize(
            params,
            &format!("{}{}", prefix, "TagKeys"),
            &obj.tag_keys,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UntagMFADeviceRequest {
    /// <p>The unique identifier for the IAM virtual MFA device from which you want to remove tags. For virtual MFA devices, the serial number is the same as the ARN.</p> <p>This parameter accepts (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that consist of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>
    pub serial_number: String,
    /// <p>A list of key names as a simple array of strings. The tags with matching keys are removed from the specified instance profile.</p>
    pub tag_keys: Vec<String>,
}

/// Serialize `UntagMFADeviceRequest` contents to a `SignedRequest`.
struct UntagMFADeviceRequestSerializer;
impl UntagMFADeviceRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &UntagMFADeviceRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "SerialNumber"), &obj.serial_number);
        TagKeyListTypeSerializer::serialize(
            params,
            &format!("{}{}", prefix, "TagKeys"),
            &obj.tag_keys,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UntagOpenIDConnectProviderRequest {
    /// <p>The ARN of the OIDC provider in IAM from which you want to remove tags.</p> <p>This parameter accepts (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that consist of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>
    pub open_id_connect_provider_arn: String,
    /// <p>A list of key names as a simple array of strings. The tags with matching keys are removed from the specified OIDC provider.</p>
    pub tag_keys: Vec<String>,
}

/// Serialize `UntagOpenIDConnectProviderRequest` contents to a `SignedRequest`.
struct UntagOpenIDConnectProviderRequestSerializer;
impl UntagOpenIDConnectProviderRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &UntagOpenIDConnectProviderRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "OpenIDConnectProviderArn"),
            &obj.open_id_connect_provider_arn,
        );
        TagKeyListTypeSerializer::serialize(
            params,
            &format!("{}{}", prefix, "TagKeys"),
            &obj.tag_keys,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UntagPolicyRequest {
    /// <p>The ARN of the IAM customer managed policy from which you want to remove tags.</p> <p>This parameter accepts (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that consist of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>
    pub policy_arn: String,
    /// <p>A list of key names as a simple array of strings. The tags with matching keys are removed from the specified policy.</p>
    pub tag_keys: Vec<String>,
}

/// Serialize `UntagPolicyRequest` contents to a `SignedRequest`.
struct UntagPolicyRequestSerializer;
impl UntagPolicyRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &UntagPolicyRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "PolicyArn"), &obj.policy_arn);
        TagKeyListTypeSerializer::serialize(
            params,
            &format!("{}{}", prefix, "TagKeys"),
            &obj.tag_keys,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UntagRoleRequest {
    /// <p>The name of the IAM role from which you want to remove tags.</p> <p>This parameter accepts (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that consist of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub role_name: String,
    /// <p>A list of key names as a simple array of strings. The tags with matching keys are removed from the specified role.</p>
    pub tag_keys: Vec<String>,
}

/// Serialize `UntagRoleRequest` contents to a `SignedRequest`.
struct UntagRoleRequestSerializer;
impl UntagRoleRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &UntagRoleRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "RoleName"), &obj.role_name);
        TagKeyListTypeSerializer::serialize(
            params,
            &format!("{}{}", prefix, "TagKeys"),
            &obj.tag_keys,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UntagSAMLProviderRequest {
    /// <p>The ARN of the SAML identity provider in IAM from which you want to remove tags.</p> <p>This parameter accepts (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that consist of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>
    pub saml_provider_arn: String,
    /// <p>A list of key names as a simple array of strings. The tags with matching keys are removed from the specified SAML identity provider.</p>
    pub tag_keys: Vec<String>,
}

/// Serialize `UntagSAMLProviderRequest` contents to a `SignedRequest`.
struct UntagSAMLProviderRequestSerializer;
impl UntagSAMLProviderRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &UntagSAMLProviderRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "SAMLProviderArn"),
            &obj.saml_provider_arn,
        );
        TagKeyListTypeSerializer::serialize(
            params,
            &format!("{}{}", prefix, "TagKeys"),
            &obj.tag_keys,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UntagServerCertificateRequest {
    /// <p>The name of the IAM server certificate from which you want to remove tags.</p> <p>This parameter accepts (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that consist of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>
    pub server_certificate_name: String,
    /// <p>A list of key names as a simple array of strings. The tags with matching keys are removed from the specified IAM server certificate.</p>
    pub tag_keys: Vec<String>,
}

/// Serialize `UntagServerCertificateRequest` contents to a `SignedRequest`.
struct UntagServerCertificateRequestSerializer;
impl UntagServerCertificateRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &UntagServerCertificateRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "ServerCertificateName"),
            &obj.server_certificate_name,
        );
        TagKeyListTypeSerializer::serialize(
            params,
            &format!("{}{}", prefix, "TagKeys"),
            &obj.tag_keys,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UntagUserRequest {
    /// <p>A list of key names as a simple array of strings. The tags with matching keys are removed from the specified user.</p>
    pub tag_keys: Vec<String>,
    /// <p>The name of the IAM user from which you want to remove tags.</p> <p>This parameter accepts (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that consist of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>
    pub user_name: String,
}

/// Serialize `UntagUserRequest` contents to a `SignedRequest`.
struct UntagUserRequestSerializer;
impl UntagUserRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &UntagUserRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        TagKeyListTypeSerializer::serialize(
            params,
            &format!("{}{}", prefix, "TagKeys"),
            &obj.tag_keys,
        );
        params.put(&format!("{}{}", prefix, "UserName"), &obj.user_name);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateAccessKeyRequest {
    /// <p>The access key ID of the secret access key you want to update.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that can consist of any upper or lowercased letter or digit.</p>
    pub access_key_id: String,
    /// <p> The status you want to assign to the secret access key. <code>Active</code> means that the key can be used for programmatic calls to AWS, while <code>Inactive</code> means that the key cannot be used.</p>
    pub status: String,
    /// <p>The name of the user whose key you want to update.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub user_name: Option<String>,
}

/// Serialize `UpdateAccessKeyRequest` contents to a `SignedRequest`.
struct UpdateAccessKeyRequestSerializer;
impl UpdateAccessKeyRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &UpdateAccessKeyRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "AccessKeyId"), &obj.access_key_id);
        params.put(&format!("{}{}", prefix, "Status"), &obj.status);
        if let Some(ref field_value) = obj.user_name {
            params.put(&format!("{}{}", prefix, "UserName"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateAccountPasswordPolicyRequest {
    /// <p> Allows all IAM users in your account to use the AWS Management Console to change their own passwords. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/HowToPwdIAMUser.html">Letting IAM users change their own passwords</a> in the <i>IAM User Guide</i>.</p> <p>If you do not specify a value for this parameter, then the operation uses the default value of <code>false</code>. The result is that IAM users in the account do not automatically have permissions to change their own password.</p>
    pub allow_users_to_change_password: Option<bool>,
    /// <p>Prevents IAM users from setting a new password after their password has expired. The IAM user cannot be accessed until an administrator resets the password.</p> <p>If you do not specify a value for this parameter, then the operation uses the default value of <code>false</code>. The result is that IAM users can change their passwords after they expire and continue to sign in as the user.</p>
    pub hard_expiry: Option<bool>,
    /// <p>The number of days that an IAM user password is valid.</p> <p>If you do not specify a value for this parameter, then the operation uses the default value of <code>0</code>. The result is that IAM user passwords never expire.</p>
    pub max_password_age: Option<i64>,
    /// <p>The minimum number of characters allowed in an IAM user password.</p> <p>If you do not specify a value for this parameter, then the operation uses the default value of <code>6</code>.</p>
    pub minimum_password_length: Option<i64>,
    /// <p>Specifies the number of previous passwords that IAM users are prevented from reusing.</p> <p>If you do not specify a value for this parameter, then the operation uses the default value of <code>0</code>. The result is that IAM users are not prevented from reusing previous passwords.</p>
    pub password_reuse_prevention: Option<i64>,
    /// <p>Specifies whether IAM user passwords must contain at least one lowercase character from the ISO basic Latin alphabet (a to z).</p> <p>If you do not specify a value for this parameter, then the operation uses the default value of <code>false</code>. The result is that passwords do not require at least one lowercase character.</p>
    pub require_lowercase_characters: Option<bool>,
    /// <p>Specifies whether IAM user passwords must contain at least one numeric character (0 to 9).</p> <p>If you do not specify a value for this parameter, then the operation uses the default value of <code>false</code>. The result is that passwords do not require at least one numeric character.</p>
    pub require_numbers: Option<bool>,
    /// <p>Specifies whether IAM user passwords must contain at least one of the following non-alphanumeric characters:</p> <p>! @ # $ % ^ &amp; * ( ) _ + - = [ ] { } | '</p> <p>If you do not specify a value for this parameter, then the operation uses the default value of <code>false</code>. The result is that passwords do not require at least one symbol character.</p>
    pub require_symbols: Option<bool>,
    /// <p>Specifies whether IAM user passwords must contain at least one uppercase character from the ISO basic Latin alphabet (A to Z).</p> <p>If you do not specify a value for this parameter, then the operation uses the default value of <code>false</code>. The result is that passwords do not require at least one uppercase character.</p>
    pub require_uppercase_characters: Option<bool>,
}

/// Serialize `UpdateAccountPasswordPolicyRequest` contents to a `SignedRequest`.
struct UpdateAccountPasswordPolicyRequestSerializer;
impl UpdateAccountPasswordPolicyRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &UpdateAccountPasswordPolicyRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.allow_users_to_change_password {
            params.put(
                &format!("{}{}", prefix, "AllowUsersToChangePassword"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.hard_expiry {
            params.put(&format!("{}{}", prefix, "HardExpiry"), &field_value);
        }
        if let Some(ref field_value) = obj.max_password_age {
            params.put(&format!("{}{}", prefix, "MaxPasswordAge"), &field_value);
        }
        if let Some(ref field_value) = obj.minimum_password_length {
            params.put(
                &format!("{}{}", prefix, "MinimumPasswordLength"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.password_reuse_prevention {
            params.put(
                &format!("{}{}", prefix, "PasswordReusePrevention"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.require_lowercase_characters {
            params.put(
                &format!("{}{}", prefix, "RequireLowercaseCharacters"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.require_numbers {
            params.put(&format!("{}{}", prefix, "RequireNumbers"), &field_value);
        }
        if let Some(ref field_value) = obj.require_symbols {
            params.put(&format!("{}{}", prefix, "RequireSymbols"), &field_value);
        }
        if let Some(ref field_value) = obj.require_uppercase_characters {
            params.put(
                &format!("{}{}", prefix, "RequireUppercaseCharacters"),
                &field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateAssumeRolePolicyRequest {
    /// <p><p>The policy that grants an entity permission to assume the role.</p> <p>You must provide policies in JSON format in IAM. However, for AWS CloudFormation templates formatted in YAML, you can provide the policy in JSON or YAML format. AWS CloudFormation always converts a YAML policy to JSON format before submitting it to IAM.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of characters consisting of the following:</p> <ul> <li> <p>Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p> </li> <li> <p>The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>)</p> </li> <li> <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>)</p> </li> </ul></p>
    pub policy_document: String,
    /// <p>The name of the role to update with the new policy.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub role_name: String,
}

/// Serialize `UpdateAssumeRolePolicyRequest` contents to a `SignedRequest`.
struct UpdateAssumeRolePolicyRequestSerializer;
impl UpdateAssumeRolePolicyRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &UpdateAssumeRolePolicyRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "PolicyDocument"),
            &obj.policy_document,
        );
        params.put(&format!("{}{}", prefix, "RoleName"), &obj.role_name);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateGroupRequest {
    /// <p>Name of the IAM group to update. If you're changing the name of the group, this is the original name.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub group_name: String,
    /// <p>New name for the IAM group. Only include this if changing the group's name.</p> <p>IAM user, group, role, and policy names must be unique within the account. Names are not distinguished by case. For example, you cannot create resources named both "MyResource" and "myresource".</p>
    pub new_group_name: Option<String>,
    /// <p>New path for the IAM group. Only include this if changing the group's path.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes. In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including most punctuation characters, digits, and upper and lowercased letters.</p>
    pub new_path: Option<String>,
}

/// Serialize `UpdateGroupRequest` contents to a `SignedRequest`.
struct UpdateGroupRequestSerializer;
impl UpdateGroupRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &UpdateGroupRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "GroupName"), &obj.group_name);
        if let Some(ref field_value) = obj.new_group_name {
            params.put(&format!("{}{}", prefix, "NewGroupName"), &field_value);
        }
        if let Some(ref field_value) = obj.new_path {
            params.put(&format!("{}{}", prefix, "NewPath"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateLoginProfileRequest {
    /// <p>The new password for the specified IAM user.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of characters consisting of the following:</p> <ul> <li> <p>Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p> </li> <li> <p>The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>)</p> </li> <li> <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>)</p> </li> </ul> <p>However, the format can be further restricted by the account administrator by setting a password policy on the AWS account. For more information, see <a>UpdateAccountPasswordPolicy</a>.</p>
    pub password: Option<String>,
    /// <p>Allows this new password to be used only once by requiring the specified IAM user to set a new password on next sign-in.</p>
    pub password_reset_required: Option<bool>,
    /// <p>The name of the user whose password you want to update.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub user_name: String,
}

/// Serialize `UpdateLoginProfileRequest` contents to a `SignedRequest`.
struct UpdateLoginProfileRequestSerializer;
impl UpdateLoginProfileRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &UpdateLoginProfileRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.password {
            params.put(&format!("{}{}", prefix, "Password"), &field_value);
        }
        if let Some(ref field_value) = obj.password_reset_required {
            params.put(
                &format!("{}{}", prefix, "PasswordResetRequired"),
                &field_value,
            );
        }
        params.put(&format!("{}{}", prefix, "UserName"), &obj.user_name);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateOpenIDConnectProviderThumbprintRequest {
    /// <p>The Amazon Resource Name (ARN) of the IAM OIDC provider resource object for which you want to update the thumbprint. You can get a list of OIDC provider ARNs by using the <a>ListOpenIDConnectProviders</a> operation.</p> <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub open_id_connect_provider_arn: String,
    /// <p>A list of certificate thumbprints that are associated with the specified IAM OpenID Connect provider. For more information, see <a>CreateOpenIDConnectProvider</a>. </p>
    pub thumbprint_list: Vec<String>,
}

/// Serialize `UpdateOpenIDConnectProviderThumbprintRequest` contents to a `SignedRequest`.
struct UpdateOpenIDConnectProviderThumbprintRequestSerializer;
impl UpdateOpenIDConnectProviderThumbprintRequestSerializer {
    fn serialize(
        params: &mut Params,
        name: &str,
        obj: &UpdateOpenIDConnectProviderThumbprintRequest,
    ) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "OpenIDConnectProviderArn"),
            &obj.open_id_connect_provider_arn,
        );
        ThumbprintListTypeSerializer::serialize(
            params,
            &format!("{}{}", prefix, "ThumbprintList"),
            &obj.thumbprint_list,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateRoleDescriptionRequest {
    /// <p>The new description that you want to apply to the specified role.</p>
    pub description: String,
    /// <p>The name of the role that you want to modify.</p>
    pub role_name: String,
}

/// Serialize `UpdateRoleDescriptionRequest` contents to a `SignedRequest`.
struct UpdateRoleDescriptionRequestSerializer;
impl UpdateRoleDescriptionRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &UpdateRoleDescriptionRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "Description"), &obj.description);
        params.put(&format!("{}{}", prefix, "RoleName"), &obj.role_name);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct UpdateRoleDescriptionResponse {
    /// <p>A structure that contains details about the modified role.</p>
    pub role: Option<Role>,
}

#[allow(dead_code)]
struct UpdateRoleDescriptionResponseDeserializer;
impl UpdateRoleDescriptionResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<UpdateRoleDescriptionResponse, XmlParseError> {
        deserialize_elements::<_, UpdateRoleDescriptionResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Role" => {
                        obj.role = Some(RoleDeserializer::deserialize("Role", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateRoleRequest {
    /// <p>The new description that you want to apply to the specified role.</p>
    pub description: Option<String>,
    /// <p>The maximum session duration (in seconds) that you want to set for the specified role. If you do not specify a value for this setting, the default maximum of one hour is applied. This setting can have a value from 1 hour to 12 hours.</p> <p>Anyone who assumes the role from the AWS CLI or API can use the <code>DurationSeconds</code> API parameter or the <code>duration-seconds</code> CLI parameter to request a longer session. The <code>MaxSessionDuration</code> setting determines the maximum duration that can be requested using the <code>DurationSeconds</code> parameter. If users don't specify a value for the <code>DurationSeconds</code> parameter, their security credentials are valid for one hour by default. This applies when you use the <code>AssumeRole*</code> API operations or the <code>assume-role*</code> CLI operations but does not apply when you use those operations to create a console URL. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html">Using IAM roles</a> in the <i>IAM User Guide</i>.</p>
    pub max_session_duration: Option<i64>,
    /// <p>The name of the role that you want to modify.</p>
    pub role_name: String,
}

/// Serialize `UpdateRoleRequest` contents to a `SignedRequest`.
struct UpdateRoleRequestSerializer;
impl UpdateRoleRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &UpdateRoleRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.description {
            params.put(&format!("{}{}", prefix, "Description"), &field_value);
        }
        if let Some(ref field_value) = obj.max_session_duration {
            params.put(&format!("{}{}", prefix, "MaxSessionDuration"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "RoleName"), &obj.role_name);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct UpdateRoleResponse {}

#[allow(dead_code)]
struct UpdateRoleResponseDeserializer;
impl UpdateRoleResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<UpdateRoleResponse, XmlParseError> {
        xml_util::start_element(tag_name, stack)?;

        let obj = UpdateRoleResponse::default();

        xml_util::end_element(tag_name, stack)?;

        Ok(obj)
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateSAMLProviderRequest {
    /// <p>An XML document generated by an identity provider (IdP) that supports SAML 2.0. The document includes the issuer's name, expiration information, and keys that can be used to validate the SAML authentication response (assertions) that are received from the IdP. You must generate the metadata document using the identity management software that is used as your organization's IdP.</p>
    pub saml_metadata_document: String,
    /// <p>The Amazon Resource Name (ARN) of the SAML provider to update.</p> <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub saml_provider_arn: String,
}

/// Serialize `UpdateSAMLProviderRequest` contents to a `SignedRequest`.
struct UpdateSAMLProviderRequestSerializer;
impl UpdateSAMLProviderRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &UpdateSAMLProviderRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "SAMLMetadataDocument"),
            &obj.saml_metadata_document,
        );
        params.put(
            &format!("{}{}", prefix, "SAMLProviderArn"),
            &obj.saml_provider_arn,
        );
    }
}

/// <p>Contains the response to a successful <a>UpdateSAMLProvider</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct UpdateSAMLProviderResponse {
    /// <p>The Amazon Resource Name (ARN) of the SAML provider that was updated.</p>
    pub saml_provider_arn: Option<String>,
}

#[allow(dead_code)]
struct UpdateSAMLProviderResponseDeserializer;
impl UpdateSAMLProviderResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<UpdateSAMLProviderResponse, XmlParseError> {
        deserialize_elements::<_, UpdateSAMLProviderResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "SAMLProviderArn" => {
                        obj.saml_provider_arn =
                            Some(ArnTypeDeserializer::deserialize("SAMLProviderArn", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateSSHPublicKeyRequest {
    /// <p>The unique identifier for the SSH public key.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that can consist of any upper or lowercased letter or digit.</p>
    pub ssh_public_key_id: String,
    /// <p>The status to assign to the SSH public key. <code>Active</code> means that the key can be used for authentication with an AWS CodeCommit repository. <code>Inactive</code> means that the key cannot be used.</p>
    pub status: String,
    /// <p>The name of the IAM user associated with the SSH public key.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub user_name: String,
}

/// Serialize `UpdateSSHPublicKeyRequest` contents to a `SignedRequest`.
struct UpdateSSHPublicKeyRequestSerializer;
impl UpdateSSHPublicKeyRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &UpdateSSHPublicKeyRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "SSHPublicKeyId"),
            &obj.ssh_public_key_id,
        );
        params.put(&format!("{}{}", prefix, "Status"), &obj.status);
        params.put(&format!("{}{}", prefix, "UserName"), &obj.user_name);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateServerCertificateRequest {
    /// <p>The new path for the server certificate. Include this only if you are updating the server certificate's path.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes. In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including most punctuation characters, digits, and upper and lowercased letters.</p>
    pub new_path: Option<String>,
    /// <p>The new name for the server certificate. Include this only if you are updating the server certificate's name. The name of the certificate cannot contain any spaces.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub new_server_certificate_name: Option<String>,
    /// <p>The name of the server certificate that you want to update.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub server_certificate_name: String,
}

/// Serialize `UpdateServerCertificateRequest` contents to a `SignedRequest`.
struct UpdateServerCertificateRequestSerializer;
impl UpdateServerCertificateRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &UpdateServerCertificateRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.new_path {
            params.put(&format!("{}{}", prefix, "NewPath"), &field_value);
        }
        if let Some(ref field_value) = obj.new_server_certificate_name {
            params.put(
                &format!("{}{}", prefix, "NewServerCertificateName"),
                &field_value,
            );
        }
        params.put(
            &format!("{}{}", prefix, "ServerCertificateName"),
            &obj.server_certificate_name,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateServiceSpecificCredentialRequest {
    /// <p>The unique identifier of the service-specific credential.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that can consist of any upper or lowercased letter or digit.</p>
    pub service_specific_credential_id: String,
    /// <p>The status to be assigned to the service-specific credential.</p>
    pub status: String,
    /// <p>The name of the IAM user associated with the service-specific credential. If you do not specify this value, then the operation assumes the user whose credentials are used to call the operation.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub user_name: Option<String>,
}

/// Serialize `UpdateServiceSpecificCredentialRequest` contents to a `SignedRequest`.
struct UpdateServiceSpecificCredentialRequestSerializer;
impl UpdateServiceSpecificCredentialRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &UpdateServiceSpecificCredentialRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "ServiceSpecificCredentialId"),
            &obj.service_specific_credential_id,
        );
        params.put(&format!("{}{}", prefix, "Status"), &obj.status);
        if let Some(ref field_value) = obj.user_name {
            params.put(&format!("{}{}", prefix, "UserName"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateSigningCertificateRequest {
    /// <p>The ID of the signing certificate you want to update.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that can consist of any upper or lowercased letter or digit.</p>
    pub certificate_id: String,
    /// <p> The status you want to assign to the certificate. <code>Active</code> means that the certificate can be used for programmatic calls to AWS <code>Inactive</code> means that the certificate cannot be used.</p>
    pub status: String,
    /// <p>The name of the IAM user the signing certificate belongs to.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub user_name: Option<String>,
}

/// Serialize `UpdateSigningCertificateRequest` contents to a `SignedRequest`.
struct UpdateSigningCertificateRequestSerializer;
impl UpdateSigningCertificateRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &UpdateSigningCertificateRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "CertificateId"),
            &obj.certificate_id,
        );
        params.put(&format!("{}{}", prefix, "Status"), &obj.status);
        if let Some(ref field_value) = obj.user_name {
            params.put(&format!("{}{}", prefix, "UserName"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateUserRequest {
    /// <p>New path for the IAM user. Include this parameter only if you're changing the user's path.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes. In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including most punctuation characters, digits, and upper and lowercased letters.</p>
    pub new_path: Option<String>,
    /// <p>New name for the user. Include this parameter only if you're changing the user's name.</p> <p>IAM user, group, role, and policy names must be unique within the account. Names are not distinguished by case. For example, you cannot create resources named both "MyResource" and "myresource".</p>
    pub new_user_name: Option<String>,
    /// <p>Name of the user to update. If you're changing the name of the user, this is the original user name.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub user_name: String,
}

/// Serialize `UpdateUserRequest` contents to a `SignedRequest`.
struct UpdateUserRequestSerializer;
impl UpdateUserRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &UpdateUserRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.new_path {
            params.put(&format!("{}{}", prefix, "NewPath"), &field_value);
        }
        if let Some(ref field_value) = obj.new_user_name {
            params.put(&format!("{}{}", prefix, "NewUserName"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "UserName"), &obj.user_name);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UploadSSHPublicKeyRequest {
    /// <p><p>The SSH public key. The public key must be encoded in ssh-rsa format or PEM format. The minimum bit-length of the public key is 2048 bits. For example, you can generate a 2048-bit key, and the resulting PEM file is 1679 bytes long.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of characters consisting of the following:</p> <ul> <li> <p>Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p> </li> <li> <p>The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>)</p> </li> <li> <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>)</p> </li> </ul></p>
    pub ssh_public_key_body: String,
    /// <p>The name of the IAM user to associate the SSH public key with.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub user_name: String,
}

/// Serialize `UploadSSHPublicKeyRequest` contents to a `SignedRequest`.
struct UploadSSHPublicKeyRequestSerializer;
impl UploadSSHPublicKeyRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &UploadSSHPublicKeyRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "SSHPublicKeyBody"),
            &obj.ssh_public_key_body,
        );
        params.put(&format!("{}{}", prefix, "UserName"), &obj.user_name);
    }
}

/// <p>Contains the response to a successful <a>UploadSSHPublicKey</a> request.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct UploadSSHPublicKeyResponse {
    /// <p>Contains information about the SSH public key.</p>
    pub ssh_public_key: Option<SSHPublicKey>,
}

#[allow(dead_code)]
struct UploadSSHPublicKeyResponseDeserializer;
impl UploadSSHPublicKeyResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<UploadSSHPublicKeyResponse, XmlParseError> {
        deserialize_elements::<_, UploadSSHPublicKeyResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "SSHPublicKey" => {
                        obj.ssh_public_key = Some(SSHPublicKeyDeserializer::deserialize(
                            "SSHPublicKey",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UploadServerCertificateRequest {
    /// <p><p>The contents of the public key certificate in PEM-encoded format.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of characters consisting of the following:</p> <ul> <li> <p>Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p> </li> <li> <p>The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>)</p> </li> <li> <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>)</p> </li> </ul></p>
    pub certificate_body: String,
    /// <p><p>The contents of the certificate chain. This is typically a concatenation of the PEM-encoded public key certificates of the chain.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of characters consisting of the following:</p> <ul> <li> <p>Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p> </li> <li> <p>The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>)</p> </li> <li> <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>)</p> </li> </ul></p>
    pub certificate_chain: Option<String>,
    /// <p><p>The path for the server certificate. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the <i>IAM User Guide</i>.</p> <p>This parameter is optional. If it is not included, it defaults to a slash (/). This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes. In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including most punctuation characters, digits, and upper and lowercased letters.</p> <note> <p> If you are uploading a server certificate specifically for use with Amazon CloudFront distributions, you must specify a path using the <code>path</code> parameter. The path must begin with <code>/cloudfront</code> and must include a trailing slash (for example, <code>/cloudfront/test/</code>).</p> </note></p>
    pub path: Option<String>,
    /// <p><p>The contents of the private key in PEM-encoded format.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of characters consisting of the following:</p> <ul> <li> <p>Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p> </li> <li> <p>The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>)</p> </li> <li> <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>)</p> </li> </ul></p>
    pub private_key: String,
    /// <p>The name for the server certificate. Do not include the path in this value. The name of the certificate cannot contain any spaces.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub server_certificate_name: String,
    /// <p><p>A list of tags that you want to attach to the new IAM server certificate resource. Each tag consists of a key name and an associated value. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User Guide</i>.</p> <note> <p>If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request fails and the resource is not created.</p> </note></p>
    pub tags: Option<Vec<Tag>>,
}

/// Serialize `UploadServerCertificateRequest` contents to a `SignedRequest`.
struct UploadServerCertificateRequestSerializer;
impl UploadServerCertificateRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &UploadServerCertificateRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "CertificateBody"),
            &obj.certificate_body,
        );
        if let Some(ref field_value) = obj.certificate_chain {
            params.put(&format!("{}{}", prefix, "CertificateChain"), &field_value);
        }
        if let Some(ref field_value) = obj.path {
            params.put(&format!("{}{}", prefix, "Path"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "PrivateKey"), &obj.private_key);
        params.put(
            &format!("{}{}", prefix, "ServerCertificateName"),
            &obj.server_certificate_name,
        );
        if let Some(ref field_value) = obj.tags {
            TagListTypeSerializer::serialize(params, &format!("{}{}", prefix, "Tags"), field_value);
        }
    }
}

/// <p>Contains the response to a successful <a>UploadServerCertificate</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct UploadServerCertificateResponse {
    /// <p>The meta information of the uploaded server certificate without its certificate body, certificate chain, and private key.</p>
    pub server_certificate_metadata: Option<ServerCertificateMetadata>,
    /// <p>A list of tags that are attached to the new IAM server certificate. The returned list of tags is sorted by tag key. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User Guide</i>.</p>
    pub tags: Option<Vec<Tag>>,
}

#[allow(dead_code)]
struct UploadServerCertificateResponseDeserializer;
impl UploadServerCertificateResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<UploadServerCertificateResponse, XmlParseError> {
        deserialize_elements::<_, UploadServerCertificateResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "ServerCertificateMetadata" => {
                        obj.server_certificate_metadata =
                            Some(ServerCertificateMetadataDeserializer::deserialize(
                                "ServerCertificateMetadata",
                                stack,
                            )?);
                    }
                    "Tags" => {
                        obj.tags
                            .get_or_insert(vec![])
                            .extend(TagListTypeDeserializer::deserialize("Tags", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UploadSigningCertificateRequest {
    /// <p><p>The contents of the signing certificate.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of characters consisting of the following:</p> <ul> <li> <p>Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p> </li> <li> <p>The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>)</p> </li> <li> <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>)</p> </li> </ul></p>
    pub certificate_body: String,
    /// <p>The name of the user the signing certificate is for.</p> <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub user_name: Option<String>,
}

/// Serialize `UploadSigningCertificateRequest` contents to a `SignedRequest`.
struct UploadSigningCertificateRequestSerializer;
impl UploadSigningCertificateRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &UploadSigningCertificateRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "CertificateBody"),
            &obj.certificate_body,
        );
        if let Some(ref field_value) = obj.user_name {
            params.put(&format!("{}{}", prefix, "UserName"), &field_value);
        }
    }
}

/// <p>Contains the response to a successful <a>UploadSigningCertificate</a> request. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct UploadSigningCertificateResponse {
    /// <p>Information about the certificate.</p>
    pub certificate: SigningCertificate,
}

#[allow(dead_code)]
struct UploadSigningCertificateResponseDeserializer;
impl UploadSigningCertificateResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<UploadSigningCertificateResponse, XmlParseError> {
        deserialize_elements::<_, UploadSigningCertificateResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Certificate" => {
                        obj.certificate =
                            SigningCertificateDeserializer::deserialize("Certificate", stack)?;
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p><p>Contains information about an IAM user entity.</p> <p>This data type is used as a response element in the following operations:</p> <ul> <li> <p> <a>CreateUser</a> </p> </li> <li> <p> <a>GetUser</a> </p> </li> <li> <p> <a>ListUsers</a> </p> </li> </ul></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct User {
    /// <p>The Amazon Resource Name (ARN) that identifies the user. For more information about ARNs and how to use ARNs in policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the <i>IAM User Guide</i>. </p>
    pub arn: String,
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the user was created.</p>
    pub create_date: String,
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the user's password was last used to sign in to an AWS website. For a list of AWS websites that capture a user's last sign-in time, see the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html">Credential reports</a> topic in the <i>IAM User Guide</i>. If a password is used more than once in a five-minute span, only the first use is returned in this field. If the field is null (no value), then it indicates that they never signed in with a password. This can be because:</p> <ul> <li> <p>The user never had a password.</p> </li> <li> <p>A password exists but has not been used since IAM started tracking this information on October 20, 2014.</p> </li> </ul> <p>A null value does not mean that the user <i>never</i> had a password. Also, if the user does not currently have a password but had one in the past, then this field contains the date and time the most recent password was used.</p> <p>This value is returned only in the <a>GetUser</a> and <a>ListUsers</a> operations. </p>
    pub password_last_used: Option<String>,
    /// <p>The path to the user. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the <i>IAM User Guide</i>.</p> <p>The ARN of the policy used to set the permissions boundary for the user.</p>
    pub path: String,
    /// <p>For more information about permissions boundaries, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM identities </a> in the <i>IAM User Guide</i>.</p>
    pub permissions_boundary: Option<AttachedPermissionsBoundary>,
    /// <p>A list of tags that are associated with the user. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User Guide</i>.</p>
    pub tags: Option<Vec<Tag>>,
    /// <p>The stable and unique string identifying the user. For more information about IDs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the <i>IAM User Guide</i>.</p>
    pub user_id: String,
    /// <p>The friendly name identifying the user.</p>
    pub user_name: String,
}

#[allow(dead_code)]
struct UserDeserializer;
impl UserDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<User, XmlParseError> {
        deserialize_elements::<_, User, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Arn" => {
                    obj.arn = ArnTypeDeserializer::deserialize("Arn", stack)?;
                }
                "CreateDate" => {
                    obj.create_date = DateTypeDeserializer::deserialize("CreateDate", stack)?;
                }
                "PasswordLastUsed" => {
                    obj.password_last_used = Some(DateTypeDeserializer::deserialize(
                        "PasswordLastUsed",
                        stack,
                    )?);
                }
                "Path" => {
                    obj.path = PathTypeDeserializer::deserialize("Path", stack)?;
                }
                "PermissionsBoundary" => {
                    obj.permissions_boundary =
                        Some(AttachedPermissionsBoundaryDeserializer::deserialize(
                            "PermissionsBoundary",
                            stack,
                        )?);
                }
                "Tags" => {
                    obj.tags
                        .get_or_insert(vec![])
                        .extend(TagListTypeDeserializer::deserialize("Tags", stack)?);
                }
                "UserId" => {
                    obj.user_id = IdTypeDeserializer::deserialize("UserId", stack)?;
                }
                "UserName" => {
                    obj.user_name = UserNameTypeDeserializer::deserialize("UserName", stack)?;
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>Contains information about an IAM user, including all the user's policies and all the IAM groups the user is in.</p> <p>This data type is used as a response element in the <a>GetAccountAuthorizationDetails</a> operation.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct UserDetail {
    pub arn: Option<String>,
    /// <p>A list of the managed policies attached to the user.</p>
    pub attached_managed_policies: Option<Vec<AttachedPolicy>>,
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the user was created.</p>
    pub create_date: Option<String>,
    /// <p>A list of IAM groups that the user is in.</p>
    pub group_list: Option<Vec<String>>,
    /// <p>The path to the user. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the <i>IAM User Guide</i>.</p>
    pub path: Option<String>,
    /// <p>The ARN of the policy used to set the permissions boundary for the user.</p> <p>For more information about permissions boundaries, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM identities </a> in the <i>IAM User Guide</i>.</p>
    pub permissions_boundary: Option<AttachedPermissionsBoundary>,
    /// <p>A list of tags that are associated with the user. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User Guide</i>.</p>
    pub tags: Option<Vec<Tag>>,
    /// <p>The stable and unique string identifying the user. For more information about IDs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the <i>IAM User Guide</i>.</p>
    pub user_id: Option<String>,
    /// <p>The friendly name identifying the user.</p>
    pub user_name: Option<String>,
    /// <p>A list of the inline policies embedded in the user.</p>
    pub user_policy_list: Option<Vec<PolicyDetail>>,
}

#[allow(dead_code)]
struct UserDetailDeserializer;
impl UserDetailDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<UserDetail, XmlParseError> {
        deserialize_elements::<_, UserDetail, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Arn" => {
                    obj.arn = Some(ArnTypeDeserializer::deserialize("Arn", stack)?);
                }
                "AttachedManagedPolicies" => {
                    obj.attached_managed_policies.get_or_insert(vec![]).extend(
                        AttachedPoliciesListTypeDeserializer::deserialize(
                            "AttachedManagedPolicies",
                            stack,
                        )?,
                    );
                }
                "CreateDate" => {
                    obj.create_date = Some(DateTypeDeserializer::deserialize("CreateDate", stack)?);
                }
                "GroupList" => {
                    obj.group_list.get_or_insert(vec![]).extend(
                        GroupNameListTypeDeserializer::deserialize("GroupList", stack)?,
                    );
                }
                "Path" => {
                    obj.path = Some(PathTypeDeserializer::deserialize("Path", stack)?);
                }
                "PermissionsBoundary" => {
                    obj.permissions_boundary =
                        Some(AttachedPermissionsBoundaryDeserializer::deserialize(
                            "PermissionsBoundary",
                            stack,
                        )?);
                }
                "Tags" => {
                    obj.tags
                        .get_or_insert(vec![])
                        .extend(TagListTypeDeserializer::deserialize("Tags", stack)?);
                }
                "UserId" => {
                    obj.user_id = Some(IdTypeDeserializer::deserialize("UserId", stack)?);
                }
                "UserName" => {
                    obj.user_name = Some(UserNameTypeDeserializer::deserialize("UserName", stack)?);
                }
                "UserPolicyList" => {
                    obj.user_policy_list.get_or_insert(vec![]).extend(
                        PolicyDetailListTypeDeserializer::deserialize("UserPolicyList", stack)?,
                    );
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct UserDetailListTypeDeserializer;
impl UserDetailListTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<UserDetail>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(UserDetailDeserializer::deserialize("member", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct UserListTypeDeserializer;
impl UserListTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<User>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(UserDeserializer::deserialize("member", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct UserNameTypeDeserializer;
impl UserNameTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p>Contains information about a virtual MFA device.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct VirtualMFADevice {
    /// <p> The base32 seed defined as specified in <a href="https://tools.ietf.org/html/rfc3548.txt">RFC3548</a>. The <code>Base32StringSeed</code> is base64-encoded. </p>
    pub base_32_string_seed: Option<bytes::Bytes>,
    /// <p>The date and time on which the virtual MFA device was enabled.</p>
    pub enable_date: Option<String>,
    /// <p> A QR code PNG image that encodes <code>otpauth://totp/$virtualMFADeviceName@$AccountName?secret=$Base32String</code> where <code>$virtualMFADeviceName</code> is one of the create call arguments. <code>AccountName</code> is the user name if set (otherwise, the account ID otherwise), and <code>Base32String</code> is the seed in base32 format. The <code>Base32String</code> value is base64-encoded. </p>
    pub qr_code_png: Option<bytes::Bytes>,
    /// <p>The serial number associated with <code>VirtualMFADevice</code>.</p>
    pub serial_number: String,
    /// <p>A list of tags that are attached to the virtual MFA device. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User Guide</i>.</p>
    pub tags: Option<Vec<Tag>>,
    /// <p>The IAM user associated with this virtual MFA device.</p>
    pub user: Option<User>,
}

#[allow(dead_code)]
struct VirtualMFADeviceDeserializer;
impl VirtualMFADeviceDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<VirtualMFADevice, XmlParseError> {
        deserialize_elements::<_, VirtualMFADevice, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Base32StringSeed" => {
                    obj.base_32_string_seed = Some(BootstrapDatumDeserializer::deserialize(
                        "Base32StringSeed",
                        stack,
                    )?);
                }
                "EnableDate" => {
                    obj.enable_date = Some(DateTypeDeserializer::deserialize("EnableDate", stack)?);
                }
                "QRCodePNG" => {
                    obj.qr_code_png =
                        Some(BootstrapDatumDeserializer::deserialize("QRCodePNG", stack)?);
                }
                "SerialNumber" => {
                    obj.serial_number =
                        SerialNumberTypeDeserializer::deserialize("SerialNumber", stack)?;
                }
                "Tags" => {
                    obj.tags
                        .get_or_insert(vec![])
                        .extend(TagListTypeDeserializer::deserialize("Tags", stack)?);
                }
                "User" => {
                    obj.user = Some(UserDeserializer::deserialize("User", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct VirtualMFADeviceListTypeDeserializer;
impl VirtualMFADeviceListTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<VirtualMFADevice>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(VirtualMFADeviceDeserializer::deserialize("member", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// Errors returned by AddClientIDToOpenIDConnectProvider
#[derive(Debug, PartialEq)]
pub enum AddClientIDToOpenIDConnectProviderError {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an input parameter.</p>
    InvalidInput(String),
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl AddClientIDToOpenIDConnectProviderError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<AddClientIDToOpenIDConnectProviderError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidInput" => {
                        return RusotoError::Service(
                            AddClientIDToOpenIDConnectProviderError::InvalidInput(
                                parsed_error.message,
                            ),
                        )
                    }
                    "LimitExceeded" => {
                        return RusotoError::Service(
                            AddClientIDToOpenIDConnectProviderError::LimitExceeded(
                                parsed_error.message,
                            ),
                        )
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(
                            AddClientIDToOpenIDConnectProviderError::NoSuchEntity(
                                parsed_error.message,
                            ),
                        )
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(
                            AddClientIDToOpenIDConnectProviderError::ServiceFailure(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for AddClientIDToOpenIDConnectProviderError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            AddClientIDToOpenIDConnectProviderError::InvalidInput(ref cause) => {
                write!(f, "{}", cause)
            }
            AddClientIDToOpenIDConnectProviderError::LimitExceeded(ref cause) => {
                write!(f, "{}", cause)
            }
            AddClientIDToOpenIDConnectProviderError::NoSuchEntity(ref cause) => {
                write!(f, "{}", cause)
            }
            AddClientIDToOpenIDConnectProviderError::ServiceFailure(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for AddClientIDToOpenIDConnectProviderError {}
/// Errors returned by AddRoleToInstanceProfile
#[derive(Debug, PartialEq)]
pub enum AddRoleToInstanceProfileError {
    /// <p>The request was rejected because it attempted to create a resource that already exists.</p>
    EntityAlreadyExists(String),
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
    /// <p>The request was rejected because only the service that depends on the service-linked role can modify or delete the role on your behalf. The error message includes the name of the service that depends on this service-linked role. You must request the change through that service.</p>
    UnmodifiableEntity(String),
}

impl AddRoleToInstanceProfileError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<AddRoleToInstanceProfileError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "EntityAlreadyExists" => {
                        return RusotoError::Service(
                            AddRoleToInstanceProfileError::EntityAlreadyExists(
                                parsed_error.message,
                            ),
                        )
                    }
                    "LimitExceeded" => {
                        return RusotoError::Service(AddRoleToInstanceProfileError::LimitExceeded(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(AddRoleToInstanceProfileError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(AddRoleToInstanceProfileError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    "UnmodifiableEntity" => {
                        return RusotoError::Service(
                            AddRoleToInstanceProfileError::UnmodifiableEntity(parsed_error.message),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for AddRoleToInstanceProfileError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            AddRoleToInstanceProfileError::EntityAlreadyExists(ref cause) => write!(f, "{}", cause),
            AddRoleToInstanceProfileError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            AddRoleToInstanceProfileError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            AddRoleToInstanceProfileError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            AddRoleToInstanceProfileError::UnmodifiableEntity(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for AddRoleToInstanceProfileError {}
/// Errors returned by AddUserToGroup
#[derive(Debug, PartialEq)]
pub enum AddUserToGroupError {
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl AddUserToGroupError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<AddUserToGroupError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "LimitExceeded" => {
                        return RusotoError::Service(AddUserToGroupError::LimitExceeded(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(AddUserToGroupError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(AddUserToGroupError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for AddUserToGroupError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            AddUserToGroupError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            AddUserToGroupError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            AddUserToGroupError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for AddUserToGroupError {}
/// Errors returned by AttachGroupPolicy
#[derive(Debug, PartialEq)]
pub enum AttachGroupPolicyError {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an input parameter.</p>
    InvalidInput(String),
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request failed because AWS service role policies can only be attached to the service-linked role for that service.</p>
    PolicyNotAttachable(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl AttachGroupPolicyError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<AttachGroupPolicyError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidInput" => {
                        return RusotoError::Service(AttachGroupPolicyError::InvalidInput(
                            parsed_error.message,
                        ))
                    }
                    "LimitExceeded" => {
                        return RusotoError::Service(AttachGroupPolicyError::LimitExceeded(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(AttachGroupPolicyError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "PolicyNotAttachable" => {
                        return RusotoError::Service(AttachGroupPolicyError::PolicyNotAttachable(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(AttachGroupPolicyError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for AttachGroupPolicyError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            AttachGroupPolicyError::InvalidInput(ref cause) => write!(f, "{}", cause),
            AttachGroupPolicyError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            AttachGroupPolicyError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            AttachGroupPolicyError::PolicyNotAttachable(ref cause) => write!(f, "{}", cause),
            AttachGroupPolicyError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for AttachGroupPolicyError {}
/// Errors returned by AttachRolePolicy
#[derive(Debug, PartialEq)]
pub enum AttachRolePolicyError {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an input parameter.</p>
    InvalidInput(String),
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request failed because AWS service role policies can only be attached to the service-linked role for that service.</p>
    PolicyNotAttachable(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
    /// <p>The request was rejected because only the service that depends on the service-linked role can modify or delete the role on your behalf. The error message includes the name of the service that depends on this service-linked role. You must request the change through that service.</p>
    UnmodifiableEntity(String),
}

impl AttachRolePolicyError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<AttachRolePolicyError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidInput" => {
                        return RusotoError::Service(AttachRolePolicyError::InvalidInput(
                            parsed_error.message,
                        ))
                    }
                    "LimitExceeded" => {
                        return RusotoError::Service(AttachRolePolicyError::LimitExceeded(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(AttachRolePolicyError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "PolicyNotAttachable" => {
                        return RusotoError::Service(AttachRolePolicyError::PolicyNotAttachable(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(AttachRolePolicyError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    "UnmodifiableEntity" => {
                        return RusotoError::Service(AttachRolePolicyError::UnmodifiableEntity(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for AttachRolePolicyError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            AttachRolePolicyError::InvalidInput(ref cause) => write!(f, "{}", cause),
            AttachRolePolicyError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            AttachRolePolicyError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            AttachRolePolicyError::PolicyNotAttachable(ref cause) => write!(f, "{}", cause),
            AttachRolePolicyError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            AttachRolePolicyError::UnmodifiableEntity(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for AttachRolePolicyError {}
/// Errors returned by AttachUserPolicy
#[derive(Debug, PartialEq)]
pub enum AttachUserPolicyError {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an input parameter.</p>
    InvalidInput(String),
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request failed because AWS service role policies can only be attached to the service-linked role for that service.</p>
    PolicyNotAttachable(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl AttachUserPolicyError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<AttachUserPolicyError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidInput" => {
                        return RusotoError::Service(AttachUserPolicyError::InvalidInput(
                            parsed_error.message,
                        ))
                    }
                    "LimitExceeded" => {
                        return RusotoError::Service(AttachUserPolicyError::LimitExceeded(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(AttachUserPolicyError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "PolicyNotAttachable" => {
                        return RusotoError::Service(AttachUserPolicyError::PolicyNotAttachable(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(AttachUserPolicyError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for AttachUserPolicyError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            AttachUserPolicyError::InvalidInput(ref cause) => write!(f, "{}", cause),
            AttachUserPolicyError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            AttachUserPolicyError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            AttachUserPolicyError::PolicyNotAttachable(ref cause) => write!(f, "{}", cause),
            AttachUserPolicyError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for AttachUserPolicyError {}
/// Errors returned by ChangePassword
#[derive(Debug, PartialEq)]
pub enum ChangePasswordError {
    /// <p>The request was rejected because it referenced an entity that is temporarily unmodifiable, such as a user name that was deleted and then recreated. The error indicates that the request is likely to succeed if you try again after waiting several minutes. The error message describes the entity.</p>
    EntityTemporarilyUnmodifiable(String),
    /// <p>The request was rejected because the type of user for the transaction was incorrect.</p>
    InvalidUserType(String),
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request was rejected because the provided password did not meet the requirements imposed by the account password policy.</p>
    PasswordPolicyViolation(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl ChangePasswordError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ChangePasswordError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "EntityTemporarilyUnmodifiable" => {
                        return RusotoError::Service(
                            ChangePasswordError::EntityTemporarilyUnmodifiable(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidUserType" => {
                        return RusotoError::Service(ChangePasswordError::InvalidUserType(
                            parsed_error.message,
                        ))
                    }
                    "LimitExceeded" => {
                        return RusotoError::Service(ChangePasswordError::LimitExceeded(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(ChangePasswordError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "PasswordPolicyViolation" => {
                        return RusotoError::Service(ChangePasswordError::PasswordPolicyViolation(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(ChangePasswordError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ChangePasswordError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ChangePasswordError::EntityTemporarilyUnmodifiable(ref cause) => write!(f, "{}", cause),
            ChangePasswordError::InvalidUserType(ref cause) => write!(f, "{}", cause),
            ChangePasswordError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            ChangePasswordError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            ChangePasswordError::PasswordPolicyViolation(ref cause) => write!(f, "{}", cause),
            ChangePasswordError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ChangePasswordError {}
/// Errors returned by CreateAccessKey
#[derive(Debug, PartialEq)]
pub enum CreateAccessKeyError {
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl CreateAccessKeyError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateAccessKeyError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "LimitExceeded" => {
                        return RusotoError::Service(CreateAccessKeyError::LimitExceeded(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(CreateAccessKeyError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(CreateAccessKeyError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for CreateAccessKeyError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateAccessKeyError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            CreateAccessKeyError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            CreateAccessKeyError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateAccessKeyError {}
/// Errors returned by CreateAccountAlias
#[derive(Debug, PartialEq)]
pub enum CreateAccountAliasError {
    /// <p>The request was rejected because it attempted to create a resource that already exists.</p>
    EntityAlreadyExists(String),
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl CreateAccountAliasError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateAccountAliasError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "EntityAlreadyExists" => {
                        return RusotoError::Service(CreateAccountAliasError::EntityAlreadyExists(
                            parsed_error.message,
                        ))
                    }
                    "LimitExceeded" => {
                        return RusotoError::Service(CreateAccountAliasError::LimitExceeded(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(CreateAccountAliasError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for CreateAccountAliasError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateAccountAliasError::EntityAlreadyExists(ref cause) => write!(f, "{}", cause),
            CreateAccountAliasError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            CreateAccountAliasError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateAccountAliasError {}
/// Errors returned by CreateGroup
#[derive(Debug, PartialEq)]
pub enum CreateGroupError {
    /// <p>The request was rejected because it attempted to create a resource that already exists.</p>
    EntityAlreadyExists(String),
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl CreateGroupError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateGroupError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "EntityAlreadyExists" => {
                        return RusotoError::Service(CreateGroupError::EntityAlreadyExists(
                            parsed_error.message,
                        ))
                    }
                    "LimitExceeded" => {
                        return RusotoError::Service(CreateGroupError::LimitExceeded(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(CreateGroupError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(CreateGroupError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for CreateGroupError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateGroupError::EntityAlreadyExists(ref cause) => write!(f, "{}", cause),
            CreateGroupError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            CreateGroupError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            CreateGroupError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateGroupError {}
/// Errors returned by CreateInstanceProfile
#[derive(Debug, PartialEq)]
pub enum CreateInstanceProfileError {
    /// <p>The request was rejected because multiple requests to change this object were submitted simultaneously. Wait a few minutes and submit your request again.</p>
    ConcurrentModification(String),
    /// <p>The request was rejected because it attempted to create a resource that already exists.</p>
    EntityAlreadyExists(String),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an input parameter.</p>
    InvalidInput(String),
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl CreateInstanceProfileError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateInstanceProfileError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ConcurrentModification" => {
                        return RusotoError::Service(
                            CreateInstanceProfileError::ConcurrentModification(
                                parsed_error.message,
                            ),
                        )
                    }
                    "EntityAlreadyExists" => {
                        return RusotoError::Service(
                            CreateInstanceProfileError::EntityAlreadyExists(parsed_error.message),
                        )
                    }
                    "InvalidInput" => {
                        return RusotoError::Service(CreateInstanceProfileError::InvalidInput(
                            parsed_error.message,
                        ))
                    }
                    "LimitExceeded" => {
                        return RusotoError::Service(CreateInstanceProfileError::LimitExceeded(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(CreateInstanceProfileError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for CreateInstanceProfileError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateInstanceProfileError::ConcurrentModification(ref cause) => write!(f, "{}", cause),
            CreateInstanceProfileError::EntityAlreadyExists(ref cause) => write!(f, "{}", cause),
            CreateInstanceProfileError::InvalidInput(ref cause) => write!(f, "{}", cause),
            CreateInstanceProfileError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            CreateInstanceProfileError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateInstanceProfileError {}
/// Errors returned by CreateLoginProfile
#[derive(Debug, PartialEq)]
pub enum CreateLoginProfileError {
    /// <p>The request was rejected because it attempted to create a resource that already exists.</p>
    EntityAlreadyExists(String),
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request was rejected because the provided password did not meet the requirements imposed by the account password policy.</p>
    PasswordPolicyViolation(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl CreateLoginProfileError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateLoginProfileError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "EntityAlreadyExists" => {
                        return RusotoError::Service(CreateLoginProfileError::EntityAlreadyExists(
                            parsed_error.message,
                        ))
                    }
                    "LimitExceeded" => {
                        return RusotoError::Service(CreateLoginProfileError::LimitExceeded(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(CreateLoginProfileError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "PasswordPolicyViolation" => {
                        return RusotoError::Service(
                            CreateLoginProfileError::PasswordPolicyViolation(parsed_error.message),
                        )
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(CreateLoginProfileError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for CreateLoginProfileError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateLoginProfileError::EntityAlreadyExists(ref cause) => write!(f, "{}", cause),
            CreateLoginProfileError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            CreateLoginProfileError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            CreateLoginProfileError::PasswordPolicyViolation(ref cause) => write!(f, "{}", cause),
            CreateLoginProfileError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateLoginProfileError {}
/// Errors returned by CreateOpenIDConnectProvider
#[derive(Debug, PartialEq)]
pub enum CreateOpenIDConnectProviderError {
    /// <p>The request was rejected because multiple requests to change this object were submitted simultaneously. Wait a few minutes and submit your request again.</p>
    ConcurrentModification(String),
    /// <p>The request was rejected because it attempted to create a resource that already exists.</p>
    EntityAlreadyExists(String),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an input parameter.</p>
    InvalidInput(String),
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl CreateOpenIDConnectProviderError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<CreateOpenIDConnectProviderError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ConcurrentModification" => {
                        return RusotoError::Service(
                            CreateOpenIDConnectProviderError::ConcurrentModification(
                                parsed_error.message,
                            ),
                        )
                    }
                    "EntityAlreadyExists" => {
                        return RusotoError::Service(
                            CreateOpenIDConnectProviderError::EntityAlreadyExists(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidInput" => {
                        return RusotoError::Service(
                            CreateOpenIDConnectProviderError::InvalidInput(parsed_error.message),
                        )
                    }
                    "LimitExceeded" => {
                        return RusotoError::Service(
                            CreateOpenIDConnectProviderError::LimitExceeded(parsed_error.message),
                        )
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(
                            CreateOpenIDConnectProviderError::ServiceFailure(parsed_error.message),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for CreateOpenIDConnectProviderError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateOpenIDConnectProviderError::ConcurrentModification(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateOpenIDConnectProviderError::EntityAlreadyExists(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateOpenIDConnectProviderError::InvalidInput(ref cause) => write!(f, "{}", cause),
            CreateOpenIDConnectProviderError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            CreateOpenIDConnectProviderError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateOpenIDConnectProviderError {}
/// Errors returned by CreatePolicy
#[derive(Debug, PartialEq)]
pub enum CreatePolicyError {
    /// <p>The request was rejected because multiple requests to change this object were submitted simultaneously. Wait a few minutes and submit your request again.</p>
    ConcurrentModification(String),
    /// <p>The request was rejected because it attempted to create a resource that already exists.</p>
    EntityAlreadyExists(String),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an input parameter.</p>
    InvalidInput(String),
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request was rejected because the policy document was malformed. The error message describes the specific error.</p>
    MalformedPolicyDocument(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl CreatePolicyError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreatePolicyError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ConcurrentModification" => {
                        return RusotoError::Service(CreatePolicyError::ConcurrentModification(
                            parsed_error.message,
                        ))
                    }
                    "EntityAlreadyExists" => {
                        return RusotoError::Service(CreatePolicyError::EntityAlreadyExists(
                            parsed_error.message,
                        ))
                    }
                    "InvalidInput" => {
                        return RusotoError::Service(CreatePolicyError::InvalidInput(
                            parsed_error.message,
                        ))
                    }
                    "LimitExceeded" => {
                        return RusotoError::Service(CreatePolicyError::LimitExceeded(
                            parsed_error.message,
                        ))
                    }
                    "MalformedPolicyDocument" => {
                        return RusotoError::Service(CreatePolicyError::MalformedPolicyDocument(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(CreatePolicyError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for CreatePolicyError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreatePolicyError::ConcurrentModification(ref cause) => write!(f, "{}", cause),
            CreatePolicyError::EntityAlreadyExists(ref cause) => write!(f, "{}", cause),
            CreatePolicyError::InvalidInput(ref cause) => write!(f, "{}", cause),
            CreatePolicyError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            CreatePolicyError::MalformedPolicyDocument(ref cause) => write!(f, "{}", cause),
            CreatePolicyError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreatePolicyError {}
/// Errors returned by CreatePolicyVersion
#[derive(Debug, PartialEq)]
pub enum CreatePolicyVersionError {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an input parameter.</p>
    InvalidInput(String),
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request was rejected because the policy document was malformed. The error message describes the specific error.</p>
    MalformedPolicyDocument(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl CreatePolicyVersionError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreatePolicyVersionError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidInput" => {
                        return RusotoError::Service(CreatePolicyVersionError::InvalidInput(
                            parsed_error.message,
                        ))
                    }
                    "LimitExceeded" => {
                        return RusotoError::Service(CreatePolicyVersionError::LimitExceeded(
                            parsed_error.message,
                        ))
                    }
                    "MalformedPolicyDocument" => {
                        return RusotoError::Service(
                            CreatePolicyVersionError::MalformedPolicyDocument(parsed_error.message),
                        )
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(CreatePolicyVersionError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(CreatePolicyVersionError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for CreatePolicyVersionError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreatePolicyVersionError::InvalidInput(ref cause) => write!(f, "{}", cause),
            CreatePolicyVersionError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            CreatePolicyVersionError::MalformedPolicyDocument(ref cause) => write!(f, "{}", cause),
            CreatePolicyVersionError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            CreatePolicyVersionError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreatePolicyVersionError {}
/// Errors returned by CreateRole
#[derive(Debug, PartialEq)]
pub enum CreateRoleError {
    /// <p>The request was rejected because multiple requests to change this object were submitted simultaneously. Wait a few minutes and submit your request again.</p>
    ConcurrentModification(String),
    /// <p>The request was rejected because it attempted to create a resource that already exists.</p>
    EntityAlreadyExists(String),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an input parameter.</p>
    InvalidInput(String),
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request was rejected because the policy document was malformed. The error message describes the specific error.</p>
    MalformedPolicyDocument(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl CreateRoleError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateRoleError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ConcurrentModification" => {
                        return RusotoError::Service(CreateRoleError::ConcurrentModification(
                            parsed_error.message,
                        ))
                    }
                    "EntityAlreadyExists" => {
                        return RusotoError::Service(CreateRoleError::EntityAlreadyExists(
                            parsed_error.message,
                        ))
                    }
                    "InvalidInput" => {
                        return RusotoError::Service(CreateRoleError::InvalidInput(
                            parsed_error.message,
                        ))
                    }
                    "LimitExceeded" => {
                        return RusotoError::Service(CreateRoleError::LimitExceeded(
                            parsed_error.message,
                        ))
                    }
                    "MalformedPolicyDocument" => {
                        return RusotoError::Service(CreateRoleError::MalformedPolicyDocument(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(CreateRoleError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for CreateRoleError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateRoleError::ConcurrentModification(ref cause) => write!(f, "{}", cause),
            CreateRoleError::EntityAlreadyExists(ref cause) => write!(f, "{}", cause),
            CreateRoleError::InvalidInput(ref cause) => write!(f, "{}", cause),
            CreateRoleError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            CreateRoleError::MalformedPolicyDocument(ref cause) => write!(f, "{}", cause),
            CreateRoleError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateRoleError {}
/// Errors returned by CreateSAMLProvider
#[derive(Debug, PartialEq)]
pub enum CreateSAMLProviderError {
    /// <p>The request was rejected because multiple requests to change this object were submitted simultaneously. Wait a few minutes and submit your request again.</p>
    ConcurrentModification(String),
    /// <p>The request was rejected because it attempted to create a resource that already exists.</p>
    EntityAlreadyExists(String),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an input parameter.</p>
    InvalidInput(String),
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl CreateSAMLProviderError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateSAMLProviderError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ConcurrentModification" => {
                        return RusotoError::Service(
                            CreateSAMLProviderError::ConcurrentModification(parsed_error.message),
                        )
                    }
                    "EntityAlreadyExists" => {
                        return RusotoError::Service(CreateSAMLProviderError::EntityAlreadyExists(
                            parsed_error.message,
                        ))
                    }
                    "InvalidInput" => {
                        return RusotoError::Service(CreateSAMLProviderError::InvalidInput(
                            parsed_error.message,
                        ))
                    }
                    "LimitExceeded" => {
                        return RusotoError::Service(CreateSAMLProviderError::LimitExceeded(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(CreateSAMLProviderError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for CreateSAMLProviderError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateSAMLProviderError::ConcurrentModification(ref cause) => write!(f, "{}", cause),
            CreateSAMLProviderError::EntityAlreadyExists(ref cause) => write!(f, "{}", cause),
            CreateSAMLProviderError::InvalidInput(ref cause) => write!(f, "{}", cause),
            CreateSAMLProviderError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            CreateSAMLProviderError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateSAMLProviderError {}
/// Errors returned by CreateServiceLinkedRole
#[derive(Debug, PartialEq)]
pub enum CreateServiceLinkedRoleError {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an input parameter.</p>
    InvalidInput(String),
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl CreateServiceLinkedRoleError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateServiceLinkedRoleError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidInput" => {
                        return RusotoError::Service(CreateServiceLinkedRoleError::InvalidInput(
                            parsed_error.message,
                        ))
                    }
                    "LimitExceeded" => {
                        return RusotoError::Service(CreateServiceLinkedRoleError::LimitExceeded(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(CreateServiceLinkedRoleError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(CreateServiceLinkedRoleError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for CreateServiceLinkedRoleError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateServiceLinkedRoleError::InvalidInput(ref cause) => write!(f, "{}", cause),
            CreateServiceLinkedRoleError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            CreateServiceLinkedRoleError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            CreateServiceLinkedRoleError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateServiceLinkedRoleError {}
/// Errors returned by CreateServiceSpecificCredential
#[derive(Debug, PartialEq)]
pub enum CreateServiceSpecificCredentialError {
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The specified service does not support service-specific credentials.</p>
    ServiceNotSupported(String),
}

impl CreateServiceSpecificCredentialError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<CreateServiceSpecificCredentialError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "LimitExceeded" => {
                        return RusotoError::Service(
                            CreateServiceSpecificCredentialError::LimitExceeded(
                                parsed_error.message,
                            ),
                        )
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(
                            CreateServiceSpecificCredentialError::NoSuchEntity(
                                parsed_error.message,
                            ),
                        )
                    }
                    "NotSupportedService" => {
                        return RusotoError::Service(
                            CreateServiceSpecificCredentialError::ServiceNotSupported(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for CreateServiceSpecificCredentialError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateServiceSpecificCredentialError::LimitExceeded(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateServiceSpecificCredentialError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            CreateServiceSpecificCredentialError::ServiceNotSupported(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for CreateServiceSpecificCredentialError {}
/// Errors returned by CreateUser
#[derive(Debug, PartialEq)]
pub enum CreateUserError {
    /// <p>The request was rejected because multiple requests to change this object were submitted simultaneously. Wait a few minutes and submit your request again.</p>
    ConcurrentModification(String),
    /// <p>The request was rejected because it attempted to create a resource that already exists.</p>
    EntityAlreadyExists(String),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an input parameter.</p>
    InvalidInput(String),
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl CreateUserError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateUserError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ConcurrentModification" => {
                        return RusotoError::Service(CreateUserError::ConcurrentModification(
                            parsed_error.message,
                        ))
                    }
                    "EntityAlreadyExists" => {
                        return RusotoError::Service(CreateUserError::EntityAlreadyExists(
                            parsed_error.message,
                        ))
                    }
                    "InvalidInput" => {
                        return RusotoError::Service(CreateUserError::InvalidInput(
                            parsed_error.message,
                        ))
                    }
                    "LimitExceeded" => {
                        return RusotoError::Service(CreateUserError::LimitExceeded(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(CreateUserError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(CreateUserError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for CreateUserError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateUserError::ConcurrentModification(ref cause) => write!(f, "{}", cause),
            CreateUserError::EntityAlreadyExists(ref cause) => write!(f, "{}", cause),
            CreateUserError::InvalidInput(ref cause) => write!(f, "{}", cause),
            CreateUserError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            CreateUserError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            CreateUserError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateUserError {}
/// Errors returned by CreateVirtualMFADevice
#[derive(Debug, PartialEq)]
pub enum CreateVirtualMFADeviceError {
    /// <p>The request was rejected because multiple requests to change this object were submitted simultaneously. Wait a few minutes and submit your request again.</p>
    ConcurrentModification(String),
    /// <p>The request was rejected because it attempted to create a resource that already exists.</p>
    EntityAlreadyExists(String),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an input parameter.</p>
    InvalidInput(String),
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl CreateVirtualMFADeviceError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateVirtualMFADeviceError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ConcurrentModification" => {
                        return RusotoError::Service(
                            CreateVirtualMFADeviceError::ConcurrentModification(
                                parsed_error.message,
                            ),
                        )
                    }
                    "EntityAlreadyExists" => {
                        return RusotoError::Service(
                            CreateVirtualMFADeviceError::EntityAlreadyExists(parsed_error.message),
                        )
                    }
                    "InvalidInput" => {
                        return RusotoError::Service(CreateVirtualMFADeviceError::InvalidInput(
                            parsed_error.message,
                        ))
                    }
                    "LimitExceeded" => {
                        return RusotoError::Service(CreateVirtualMFADeviceError::LimitExceeded(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(CreateVirtualMFADeviceError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for CreateVirtualMFADeviceError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateVirtualMFADeviceError::ConcurrentModification(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateVirtualMFADeviceError::EntityAlreadyExists(ref cause) => write!(f, "{}", cause),
            CreateVirtualMFADeviceError::InvalidInput(ref cause) => write!(f, "{}", cause),
            CreateVirtualMFADeviceError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            CreateVirtualMFADeviceError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateVirtualMFADeviceError {}
/// Errors returned by DeactivateMFADevice
#[derive(Debug, PartialEq)]
pub enum DeactivateMFADeviceError {
    /// <p>The request was rejected because it referenced an entity that is temporarily unmodifiable, such as a user name that was deleted and then recreated. The error indicates that the request is likely to succeed if you try again after waiting several minutes. The error message describes the entity.</p>
    EntityTemporarilyUnmodifiable(String),
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl DeactivateMFADeviceError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeactivateMFADeviceError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "EntityTemporarilyUnmodifiable" => {
                        return RusotoError::Service(
                            DeactivateMFADeviceError::EntityTemporarilyUnmodifiable(
                                parsed_error.message,
                            ),
                        )
                    }
                    "LimitExceeded" => {
                        return RusotoError::Service(DeactivateMFADeviceError::LimitExceeded(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(DeactivateMFADeviceError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(DeactivateMFADeviceError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DeactivateMFADeviceError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeactivateMFADeviceError::EntityTemporarilyUnmodifiable(ref cause) => {
                write!(f, "{}", cause)
            }
            DeactivateMFADeviceError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            DeactivateMFADeviceError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            DeactivateMFADeviceError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeactivateMFADeviceError {}
/// Errors returned by DeleteAccessKey
#[derive(Debug, PartialEq)]
pub enum DeleteAccessKeyError {
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl DeleteAccessKeyError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteAccessKeyError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "LimitExceeded" => {
                        return RusotoError::Service(DeleteAccessKeyError::LimitExceeded(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(DeleteAccessKeyError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(DeleteAccessKeyError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DeleteAccessKeyError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteAccessKeyError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            DeleteAccessKeyError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            DeleteAccessKeyError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteAccessKeyError {}
/// Errors returned by DeleteAccountAlias
#[derive(Debug, PartialEq)]
pub enum DeleteAccountAliasError {
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl DeleteAccountAliasError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteAccountAliasError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "LimitExceeded" => {
                        return RusotoError::Service(DeleteAccountAliasError::LimitExceeded(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(DeleteAccountAliasError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(DeleteAccountAliasError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DeleteAccountAliasError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteAccountAliasError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            DeleteAccountAliasError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            DeleteAccountAliasError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteAccountAliasError {}
/// Errors returned by DeleteAccountPasswordPolicy
#[derive(Debug, PartialEq)]
pub enum DeleteAccountPasswordPolicyError {
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl DeleteAccountPasswordPolicyError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<DeleteAccountPasswordPolicyError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "LimitExceeded" => {
                        return RusotoError::Service(
                            DeleteAccountPasswordPolicyError::LimitExceeded(parsed_error.message),
                        )
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(
                            DeleteAccountPasswordPolicyError::NoSuchEntity(parsed_error.message),
                        )
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(
                            DeleteAccountPasswordPolicyError::ServiceFailure(parsed_error.message),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DeleteAccountPasswordPolicyError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteAccountPasswordPolicyError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            DeleteAccountPasswordPolicyError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            DeleteAccountPasswordPolicyError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteAccountPasswordPolicyError {}
/// Errors returned by DeleteGroup
#[derive(Debug, PartialEq)]
pub enum DeleteGroupError {
    /// <p>The request was rejected because it attempted to delete a resource that has attached subordinate entities. The error message describes these entities.</p>
    DeleteConflict(String),
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl DeleteGroupError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteGroupError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "DeleteConflict" => {
                        return RusotoError::Service(DeleteGroupError::DeleteConflict(
                            parsed_error.message,
                        ))
                    }
                    "LimitExceeded" => {
                        return RusotoError::Service(DeleteGroupError::LimitExceeded(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(DeleteGroupError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(DeleteGroupError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DeleteGroupError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteGroupError::DeleteConflict(ref cause) => write!(f, "{}", cause),
            DeleteGroupError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            DeleteGroupError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            DeleteGroupError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteGroupError {}
/// Errors returned by DeleteGroupPolicy
#[derive(Debug, PartialEq)]
pub enum DeleteGroupPolicyError {
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl DeleteGroupPolicyError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteGroupPolicyError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "LimitExceeded" => {
                        return RusotoError::Service(DeleteGroupPolicyError::LimitExceeded(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(DeleteGroupPolicyError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(DeleteGroupPolicyError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DeleteGroupPolicyError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteGroupPolicyError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            DeleteGroupPolicyError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            DeleteGroupPolicyError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteGroupPolicyError {}
/// Errors returned by DeleteInstanceProfile
#[derive(Debug, PartialEq)]
pub enum DeleteInstanceProfileError {
    /// <p>The request was rejected because it attempted to delete a resource that has attached subordinate entities. The error message describes these entities.</p>
    DeleteConflict(String),
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl DeleteInstanceProfileError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteInstanceProfileError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "DeleteConflict" => {
                        return RusotoError::Service(DeleteInstanceProfileError::DeleteConflict(
                            parsed_error.message,
                        ))
                    }
                    "LimitExceeded" => {
                        return RusotoError::Service(DeleteInstanceProfileError::LimitExceeded(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(DeleteInstanceProfileError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(DeleteInstanceProfileError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DeleteInstanceProfileError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteInstanceProfileError::DeleteConflict(ref cause) => write!(f, "{}", cause),
            DeleteInstanceProfileError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            DeleteInstanceProfileError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            DeleteInstanceProfileError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteInstanceProfileError {}
/// Errors returned by DeleteLoginProfile
#[derive(Debug, PartialEq)]
pub enum DeleteLoginProfileError {
    /// <p>The request was rejected because it referenced an entity that is temporarily unmodifiable, such as a user name that was deleted and then recreated. The error indicates that the request is likely to succeed if you try again after waiting several minutes. The error message describes the entity.</p>
    EntityTemporarilyUnmodifiable(String),
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl DeleteLoginProfileError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteLoginProfileError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "EntityTemporarilyUnmodifiable" => {
                        return RusotoError::Service(
                            DeleteLoginProfileError::EntityTemporarilyUnmodifiable(
                                parsed_error.message,
                            ),
                        )
                    }
                    "LimitExceeded" => {
                        return RusotoError::Service(DeleteLoginProfileError::LimitExceeded(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(DeleteLoginProfileError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(DeleteLoginProfileError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DeleteLoginProfileError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteLoginProfileError::EntityTemporarilyUnmodifiable(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteLoginProfileError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            DeleteLoginProfileError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            DeleteLoginProfileError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteLoginProfileError {}
/// Errors returned by DeleteOpenIDConnectProvider
#[derive(Debug, PartialEq)]
pub enum DeleteOpenIDConnectProviderError {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an input parameter.</p>
    InvalidInput(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl DeleteOpenIDConnectProviderError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<DeleteOpenIDConnectProviderError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidInput" => {
                        return RusotoError::Service(
                            DeleteOpenIDConnectProviderError::InvalidInput(parsed_error.message),
                        )
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(
                            DeleteOpenIDConnectProviderError::NoSuchEntity(parsed_error.message),
                        )
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(
                            DeleteOpenIDConnectProviderError::ServiceFailure(parsed_error.message),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DeleteOpenIDConnectProviderError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteOpenIDConnectProviderError::InvalidInput(ref cause) => write!(f, "{}", cause),
            DeleteOpenIDConnectProviderError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            DeleteOpenIDConnectProviderError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteOpenIDConnectProviderError {}
/// Errors returned by DeletePolicy
#[derive(Debug, PartialEq)]
pub enum DeletePolicyError {
    /// <p>The request was rejected because it attempted to delete a resource that has attached subordinate entities. The error message describes these entities.</p>
    DeleteConflict(String),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an input parameter.</p>
    InvalidInput(String),
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl DeletePolicyError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeletePolicyError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "DeleteConflict" => {
                        return RusotoError::Service(DeletePolicyError::DeleteConflict(
                            parsed_error.message,
                        ))
                    }
                    "InvalidInput" => {
                        return RusotoError::Service(DeletePolicyError::InvalidInput(
                            parsed_error.message,
                        ))
                    }
                    "LimitExceeded" => {
                        return RusotoError::Service(DeletePolicyError::LimitExceeded(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(DeletePolicyError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(DeletePolicyError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DeletePolicyError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeletePolicyError::DeleteConflict(ref cause) => write!(f, "{}", cause),
            DeletePolicyError::InvalidInput(ref cause) => write!(f, "{}", cause),
            DeletePolicyError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            DeletePolicyError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            DeletePolicyError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeletePolicyError {}
/// Errors returned by DeletePolicyVersion
#[derive(Debug, PartialEq)]
pub enum DeletePolicyVersionError {
    /// <p>The request was rejected because it attempted to delete a resource that has attached subordinate entities. The error message describes these entities.</p>
    DeleteConflict(String),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an input parameter.</p>
    InvalidInput(String),
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl DeletePolicyVersionError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeletePolicyVersionError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "DeleteConflict" => {
                        return RusotoError::Service(DeletePolicyVersionError::DeleteConflict(
                            parsed_error.message,
                        ))
                    }
                    "InvalidInput" => {
                        return RusotoError::Service(DeletePolicyVersionError::InvalidInput(
                            parsed_error.message,
                        ))
                    }
                    "LimitExceeded" => {
                        return RusotoError::Service(DeletePolicyVersionError::LimitExceeded(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(DeletePolicyVersionError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(DeletePolicyVersionError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DeletePolicyVersionError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeletePolicyVersionError::DeleteConflict(ref cause) => write!(f, "{}", cause),
            DeletePolicyVersionError::InvalidInput(ref cause) => write!(f, "{}", cause),
            DeletePolicyVersionError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            DeletePolicyVersionError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            DeletePolicyVersionError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeletePolicyVersionError {}
/// Errors returned by DeleteRole
#[derive(Debug, PartialEq)]
pub enum DeleteRoleError {
    /// <p>The request was rejected because multiple requests to change this object were submitted simultaneously. Wait a few minutes and submit your request again.</p>
    ConcurrentModification(String),
    /// <p>The request was rejected because it attempted to delete a resource that has attached subordinate entities. The error message describes these entities.</p>
    DeleteConflict(String),
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
    /// <p>The request was rejected because only the service that depends on the service-linked role can modify or delete the role on your behalf. The error message includes the name of the service that depends on this service-linked role. You must request the change through that service.</p>
    UnmodifiableEntity(String),
}

impl DeleteRoleError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteRoleError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ConcurrentModification" => {
                        return RusotoError::Service(DeleteRoleError::ConcurrentModification(
                            parsed_error.message,
                        ))
                    }
                    "DeleteConflict" => {
                        return RusotoError::Service(DeleteRoleError::DeleteConflict(
                            parsed_error.message,
                        ))
                    }
                    "LimitExceeded" => {
                        return RusotoError::Service(DeleteRoleError::LimitExceeded(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(DeleteRoleError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(DeleteRoleError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    "UnmodifiableEntity" => {
                        return RusotoError::Service(DeleteRoleError::UnmodifiableEntity(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DeleteRoleError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteRoleError::ConcurrentModification(ref cause) => write!(f, "{}", cause),
            DeleteRoleError::DeleteConflict(ref cause) => write!(f, "{}", cause),
            DeleteRoleError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            DeleteRoleError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            DeleteRoleError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            DeleteRoleError::UnmodifiableEntity(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteRoleError {}
/// Errors returned by DeleteRolePermissionsBoundary
#[derive(Debug, PartialEq)]
pub enum DeleteRolePermissionsBoundaryError {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
    /// <p>The request was rejected because only the service that depends on the service-linked role can modify or delete the role on your behalf. The error message includes the name of the service that depends on this service-linked role. You must request the change through that service.</p>
    UnmodifiableEntity(String),
}

impl DeleteRolePermissionsBoundaryError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<DeleteRolePermissionsBoundaryError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "NoSuchEntity" => {
                        return RusotoError::Service(
                            DeleteRolePermissionsBoundaryError::NoSuchEntity(parsed_error.message),
                        )
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(
                            DeleteRolePermissionsBoundaryError::ServiceFailure(
                                parsed_error.message,
                            ),
                        )
                    }
                    "UnmodifiableEntity" => {
                        return RusotoError::Service(
                            DeleteRolePermissionsBoundaryError::UnmodifiableEntity(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DeleteRolePermissionsBoundaryError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteRolePermissionsBoundaryError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            DeleteRolePermissionsBoundaryError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            DeleteRolePermissionsBoundaryError::UnmodifiableEntity(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for DeleteRolePermissionsBoundaryError {}
/// Errors returned by DeleteRolePolicy
#[derive(Debug, PartialEq)]
pub enum DeleteRolePolicyError {
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
    /// <p>The request was rejected because only the service that depends on the service-linked role can modify or delete the role on your behalf. The error message includes the name of the service that depends on this service-linked role. You must request the change through that service.</p>
    UnmodifiableEntity(String),
}

impl DeleteRolePolicyError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteRolePolicyError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "LimitExceeded" => {
                        return RusotoError::Service(DeleteRolePolicyError::LimitExceeded(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(DeleteRolePolicyError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(DeleteRolePolicyError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    "UnmodifiableEntity" => {
                        return RusotoError::Service(DeleteRolePolicyError::UnmodifiableEntity(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DeleteRolePolicyError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteRolePolicyError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            DeleteRolePolicyError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            DeleteRolePolicyError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            DeleteRolePolicyError::UnmodifiableEntity(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteRolePolicyError {}
/// Errors returned by DeleteSAMLProvider
#[derive(Debug, PartialEq)]
pub enum DeleteSAMLProviderError {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an input parameter.</p>
    InvalidInput(String),
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl DeleteSAMLProviderError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteSAMLProviderError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidInput" => {
                        return RusotoError::Service(DeleteSAMLProviderError::InvalidInput(
                            parsed_error.message,
                        ))
                    }
                    "LimitExceeded" => {
                        return RusotoError::Service(DeleteSAMLProviderError::LimitExceeded(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(DeleteSAMLProviderError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(DeleteSAMLProviderError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DeleteSAMLProviderError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteSAMLProviderError::InvalidInput(ref cause) => write!(f, "{}", cause),
            DeleteSAMLProviderError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            DeleteSAMLProviderError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            DeleteSAMLProviderError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteSAMLProviderError {}
/// Errors returned by DeleteSSHPublicKey
#[derive(Debug, PartialEq)]
pub enum DeleteSSHPublicKeyError {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
}

impl DeleteSSHPublicKeyError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteSSHPublicKeyError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "NoSuchEntity" => {
                        return RusotoError::Service(DeleteSSHPublicKeyError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DeleteSSHPublicKeyError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteSSHPublicKeyError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteSSHPublicKeyError {}
/// Errors returned by DeleteServerCertificate
#[derive(Debug, PartialEq)]
pub enum DeleteServerCertificateError {
    /// <p>The request was rejected because it attempted to delete a resource that has attached subordinate entities. The error message describes these entities.</p>
    DeleteConflict(String),
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl DeleteServerCertificateError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteServerCertificateError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "DeleteConflict" => {
                        return RusotoError::Service(DeleteServerCertificateError::DeleteConflict(
                            parsed_error.message,
                        ))
                    }
                    "LimitExceeded" => {
                        return RusotoError::Service(DeleteServerCertificateError::LimitExceeded(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(DeleteServerCertificateError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(DeleteServerCertificateError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DeleteServerCertificateError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteServerCertificateError::DeleteConflict(ref cause) => write!(f, "{}", cause),
            DeleteServerCertificateError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            DeleteServerCertificateError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            DeleteServerCertificateError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteServerCertificateError {}
/// Errors returned by DeleteServiceLinkedRole
#[derive(Debug, PartialEq)]
pub enum DeleteServiceLinkedRoleError {
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl DeleteServiceLinkedRoleError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteServiceLinkedRoleError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "LimitExceeded" => {
                        return RusotoError::Service(DeleteServiceLinkedRoleError::LimitExceeded(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(DeleteServiceLinkedRoleError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(DeleteServiceLinkedRoleError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DeleteServiceLinkedRoleError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteServiceLinkedRoleError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            DeleteServiceLinkedRoleError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            DeleteServiceLinkedRoleError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteServiceLinkedRoleError {}
/// Errors returned by DeleteServiceSpecificCredential
#[derive(Debug, PartialEq)]
pub enum DeleteServiceSpecificCredentialError {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
}

impl DeleteServiceSpecificCredentialError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<DeleteServiceSpecificCredentialError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "NoSuchEntity" => {
                        return RusotoError::Service(
                            DeleteServiceSpecificCredentialError::NoSuchEntity(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DeleteServiceSpecificCredentialError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteServiceSpecificCredentialError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteServiceSpecificCredentialError {}
/// Errors returned by DeleteSigningCertificate
#[derive(Debug, PartialEq)]
pub enum DeleteSigningCertificateError {
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl DeleteSigningCertificateError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteSigningCertificateError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "LimitExceeded" => {
                        return RusotoError::Service(DeleteSigningCertificateError::LimitExceeded(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(DeleteSigningCertificateError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(DeleteSigningCertificateError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DeleteSigningCertificateError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteSigningCertificateError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            DeleteSigningCertificateError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            DeleteSigningCertificateError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteSigningCertificateError {}
/// Errors returned by DeleteUser
#[derive(Debug, PartialEq)]
pub enum DeleteUserError {
    /// <p>The request was rejected because multiple requests to change this object were submitted simultaneously. Wait a few minutes and submit your request again.</p>
    ConcurrentModification(String),
    /// <p>The request was rejected because it attempted to delete a resource that has attached subordinate entities. The error message describes these entities.</p>
    DeleteConflict(String),
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl DeleteUserError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteUserError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ConcurrentModification" => {
                        return RusotoError::Service(DeleteUserError::ConcurrentModification(
                            parsed_error.message,
                        ))
                    }
                    "DeleteConflict" => {
                        return RusotoError::Service(DeleteUserError::DeleteConflict(
                            parsed_error.message,
                        ))
                    }
                    "LimitExceeded" => {
                        return RusotoError::Service(DeleteUserError::LimitExceeded(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(DeleteUserError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(DeleteUserError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DeleteUserError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteUserError::ConcurrentModification(ref cause) => write!(f, "{}", cause),
            DeleteUserError::DeleteConflict(ref cause) => write!(f, "{}", cause),
            DeleteUserError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            DeleteUserError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            DeleteUserError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteUserError {}
/// Errors returned by DeleteUserPermissionsBoundary
#[derive(Debug, PartialEq)]
pub enum DeleteUserPermissionsBoundaryError {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl DeleteUserPermissionsBoundaryError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<DeleteUserPermissionsBoundaryError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "NoSuchEntity" => {
                        return RusotoError::Service(
                            DeleteUserPermissionsBoundaryError::NoSuchEntity(parsed_error.message),
                        )
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(
                            DeleteUserPermissionsBoundaryError::ServiceFailure(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DeleteUserPermissionsBoundaryError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteUserPermissionsBoundaryError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            DeleteUserPermissionsBoundaryError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteUserPermissionsBoundaryError {}
/// Errors returned by DeleteUserPolicy
#[derive(Debug, PartialEq)]
pub enum DeleteUserPolicyError {
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl DeleteUserPolicyError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteUserPolicyError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "LimitExceeded" => {
                        return RusotoError::Service(DeleteUserPolicyError::LimitExceeded(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(DeleteUserPolicyError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(DeleteUserPolicyError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DeleteUserPolicyError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteUserPolicyError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            DeleteUserPolicyError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            DeleteUserPolicyError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteUserPolicyError {}
/// Errors returned by DeleteVirtualMFADevice
#[derive(Debug, PartialEq)]
pub enum DeleteVirtualMFADeviceError {
    /// <p>The request was rejected because it attempted to delete a resource that has attached subordinate entities. The error message describes these entities.</p>
    DeleteConflict(String),
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl DeleteVirtualMFADeviceError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteVirtualMFADeviceError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "DeleteConflict" => {
                        return RusotoError::Service(DeleteVirtualMFADeviceError::DeleteConflict(
                            parsed_error.message,
                        ))
                    }
                    "LimitExceeded" => {
                        return RusotoError::Service(DeleteVirtualMFADeviceError::LimitExceeded(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(DeleteVirtualMFADeviceError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(DeleteVirtualMFADeviceError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DeleteVirtualMFADeviceError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteVirtualMFADeviceError::DeleteConflict(ref cause) => write!(f, "{}", cause),
            DeleteVirtualMFADeviceError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            DeleteVirtualMFADeviceError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            DeleteVirtualMFADeviceError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteVirtualMFADeviceError {}
/// Errors returned by DetachGroupPolicy
#[derive(Debug, PartialEq)]
pub enum DetachGroupPolicyError {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an input parameter.</p>
    InvalidInput(String),
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl DetachGroupPolicyError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DetachGroupPolicyError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidInput" => {
                        return RusotoError::Service(DetachGroupPolicyError::InvalidInput(
                            parsed_error.message,
                        ))
                    }
                    "LimitExceeded" => {
                        return RusotoError::Service(DetachGroupPolicyError::LimitExceeded(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(DetachGroupPolicyError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(DetachGroupPolicyError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DetachGroupPolicyError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DetachGroupPolicyError::InvalidInput(ref cause) => write!(f, "{}", cause),
            DetachGroupPolicyError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            DetachGroupPolicyError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            DetachGroupPolicyError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DetachGroupPolicyError {}
/// Errors returned by DetachRolePolicy
#[derive(Debug, PartialEq)]
pub enum DetachRolePolicyError {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an input parameter.</p>
    InvalidInput(String),
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
    /// <p>The request was rejected because only the service that depends on the service-linked role can modify or delete the role on your behalf. The error message includes the name of the service that depends on this service-linked role. You must request the change through that service.</p>
    UnmodifiableEntity(String),
}

impl DetachRolePolicyError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DetachRolePolicyError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidInput" => {
                        return RusotoError::Service(DetachRolePolicyError::InvalidInput(
                            parsed_error.message,
                        ))
                    }
                    "LimitExceeded" => {
                        return RusotoError::Service(DetachRolePolicyError::LimitExceeded(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(DetachRolePolicyError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(DetachRolePolicyError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    "UnmodifiableEntity" => {
                        return RusotoError::Service(DetachRolePolicyError::UnmodifiableEntity(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DetachRolePolicyError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DetachRolePolicyError::InvalidInput(ref cause) => write!(f, "{}", cause),
            DetachRolePolicyError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            DetachRolePolicyError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            DetachRolePolicyError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            DetachRolePolicyError::UnmodifiableEntity(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DetachRolePolicyError {}
/// Errors returned by DetachUserPolicy
#[derive(Debug, PartialEq)]
pub enum DetachUserPolicyError {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an input parameter.</p>
    InvalidInput(String),
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl DetachUserPolicyError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DetachUserPolicyError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidInput" => {
                        return RusotoError::Service(DetachUserPolicyError::InvalidInput(
                            parsed_error.message,
                        ))
                    }
                    "LimitExceeded" => {
                        return RusotoError::Service(DetachUserPolicyError::LimitExceeded(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(DetachUserPolicyError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(DetachUserPolicyError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DetachUserPolicyError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DetachUserPolicyError::InvalidInput(ref cause) => write!(f, "{}", cause),
            DetachUserPolicyError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            DetachUserPolicyError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            DetachUserPolicyError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DetachUserPolicyError {}
/// Errors returned by EnableMFADevice
#[derive(Debug, PartialEq)]
pub enum EnableMFADeviceError {
    /// <p>The request was rejected because it attempted to create a resource that already exists.</p>
    EntityAlreadyExists(String),
    /// <p>The request was rejected because it referenced an entity that is temporarily unmodifiable, such as a user name that was deleted and then recreated. The error indicates that the request is likely to succeed if you try again after waiting several minutes. The error message describes the entity.</p>
    EntityTemporarilyUnmodifiable(String),
    /// <p>The request was rejected because the authentication code was not recognized. The error message describes the specific error.</p>
    InvalidAuthenticationCode(String),
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl EnableMFADeviceError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<EnableMFADeviceError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "EntityAlreadyExists" => {
                        return RusotoError::Service(EnableMFADeviceError::EntityAlreadyExists(
                            parsed_error.message,
                        ))
                    }
                    "EntityTemporarilyUnmodifiable" => {
                        return RusotoError::Service(
                            EnableMFADeviceError::EntityTemporarilyUnmodifiable(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidAuthenticationCode" => {
                        return RusotoError::Service(
                            EnableMFADeviceError::InvalidAuthenticationCode(parsed_error.message),
                        )
                    }
                    "LimitExceeded" => {
                        return RusotoError::Service(EnableMFADeviceError::LimitExceeded(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(EnableMFADeviceError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(EnableMFADeviceError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for EnableMFADeviceError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            EnableMFADeviceError::EntityAlreadyExists(ref cause) => write!(f, "{}", cause),
            EnableMFADeviceError::EntityTemporarilyUnmodifiable(ref cause) => {
                write!(f, "{}", cause)
            }
            EnableMFADeviceError::InvalidAuthenticationCode(ref cause) => write!(f, "{}", cause),
            EnableMFADeviceError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            EnableMFADeviceError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            EnableMFADeviceError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for EnableMFADeviceError {}
/// Errors returned by GenerateCredentialReport
#[derive(Debug, PartialEq)]
pub enum GenerateCredentialReportError {
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl GenerateCredentialReportError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GenerateCredentialReportError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "LimitExceeded" => {
                        return RusotoError::Service(GenerateCredentialReportError::LimitExceeded(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(GenerateCredentialReportError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for GenerateCredentialReportError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GenerateCredentialReportError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            GenerateCredentialReportError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GenerateCredentialReportError {}
/// Errors returned by GenerateOrganizationsAccessReport
#[derive(Debug, PartialEq)]
pub enum GenerateOrganizationsAccessReportError {
    /// <p>The request failed because the maximum number of concurrent requests for this account are already running.</p>
    ReportGenerationLimitExceeded(String),
}

impl GenerateOrganizationsAccessReportError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<GenerateOrganizationsAccessReportError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ReportGenerationLimitExceeded" => {
                        return RusotoError::Service(
                            GenerateOrganizationsAccessReportError::ReportGenerationLimitExceeded(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for GenerateOrganizationsAccessReportError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GenerateOrganizationsAccessReportError::ReportGenerationLimitExceeded(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for GenerateOrganizationsAccessReportError {}
/// Errors returned by GenerateServiceLastAccessedDetails
#[derive(Debug, PartialEq)]
pub enum GenerateServiceLastAccessedDetailsError {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an input parameter.</p>
    InvalidInput(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
}

impl GenerateServiceLastAccessedDetailsError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<GenerateServiceLastAccessedDetailsError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidInput" => {
                        return RusotoError::Service(
                            GenerateServiceLastAccessedDetailsError::InvalidInput(
                                parsed_error.message,
                            ),
                        )
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(
                            GenerateServiceLastAccessedDetailsError::NoSuchEntity(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for GenerateServiceLastAccessedDetailsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GenerateServiceLastAccessedDetailsError::InvalidInput(ref cause) => {
                write!(f, "{}", cause)
            }
            GenerateServiceLastAccessedDetailsError::NoSuchEntity(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for GenerateServiceLastAccessedDetailsError {}
/// Errors returned by GetAccessKeyLastUsed
#[derive(Debug, PartialEq)]
pub enum GetAccessKeyLastUsedError {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
}

impl GetAccessKeyLastUsedError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetAccessKeyLastUsedError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "NoSuchEntity" => {
                        return RusotoError::Service(GetAccessKeyLastUsedError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for GetAccessKeyLastUsedError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetAccessKeyLastUsedError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetAccessKeyLastUsedError {}
/// Errors returned by GetAccountAuthorizationDetails
#[derive(Debug, PartialEq)]
pub enum GetAccountAuthorizationDetailsError {
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl GetAccountAuthorizationDetailsError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<GetAccountAuthorizationDetailsError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ServiceFailure" => {
                        return RusotoError::Service(
                            GetAccountAuthorizationDetailsError::ServiceFailure(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for GetAccountAuthorizationDetailsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetAccountAuthorizationDetailsError::ServiceFailure(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for GetAccountAuthorizationDetailsError {}
/// Errors returned by GetAccountPasswordPolicy
#[derive(Debug, PartialEq)]
pub enum GetAccountPasswordPolicyError {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl GetAccountPasswordPolicyError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetAccountPasswordPolicyError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "NoSuchEntity" => {
                        return RusotoError::Service(GetAccountPasswordPolicyError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(GetAccountPasswordPolicyError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for GetAccountPasswordPolicyError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetAccountPasswordPolicyError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            GetAccountPasswordPolicyError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetAccountPasswordPolicyError {}
/// Errors returned by GetAccountSummary
#[derive(Debug, PartialEq)]
pub enum GetAccountSummaryError {
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl GetAccountSummaryError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetAccountSummaryError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ServiceFailure" => {
                        return RusotoError::Service(GetAccountSummaryError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for GetAccountSummaryError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetAccountSummaryError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetAccountSummaryError {}
/// Errors returned by GetContextKeysForCustomPolicy
#[derive(Debug, PartialEq)]
pub enum GetContextKeysForCustomPolicyError {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an input parameter.</p>
    InvalidInput(String),
}

impl GetContextKeysForCustomPolicyError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<GetContextKeysForCustomPolicyError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidInput" => {
                        return RusotoError::Service(
                            GetContextKeysForCustomPolicyError::InvalidInput(parsed_error.message),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for GetContextKeysForCustomPolicyError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetContextKeysForCustomPolicyError::InvalidInput(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetContextKeysForCustomPolicyError {}
/// Errors returned by GetContextKeysForPrincipalPolicy
#[derive(Debug, PartialEq)]
pub enum GetContextKeysForPrincipalPolicyError {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an input parameter.</p>
    InvalidInput(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
}

impl GetContextKeysForPrincipalPolicyError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<GetContextKeysForPrincipalPolicyError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidInput" => {
                        return RusotoError::Service(
                            GetContextKeysForPrincipalPolicyError::InvalidInput(
                                parsed_error.message,
                            ),
                        )
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(
                            GetContextKeysForPrincipalPolicyError::NoSuchEntity(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for GetContextKeysForPrincipalPolicyError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetContextKeysForPrincipalPolicyError::InvalidInput(ref cause) => {
                write!(f, "{}", cause)
            }
            GetContextKeysForPrincipalPolicyError::NoSuchEntity(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for GetContextKeysForPrincipalPolicyError {}
/// Errors returned by GetCredentialReport
#[derive(Debug, PartialEq)]
pub enum GetCredentialReportError {
    /// <p>The request was rejected because the most recent credential report has expired. To generate a new credential report, use <a>GenerateCredentialReport</a>. For more information about credential report expiration, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html">Getting credential reports</a> in the <i>IAM User Guide</i>.</p>
    CredentialReportExpired(String),
    /// <p>The request was rejected because the credential report does not exist. To generate a credential report, use <a>GenerateCredentialReport</a>.</p>
    CredentialReportNotPresent(String),
    /// <p>The request was rejected because the credential report is still being generated.</p>
    CredentialReportNotReady(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl GetCredentialReportError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetCredentialReportError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ReportExpired" => {
                        return RusotoError::Service(
                            GetCredentialReportError::CredentialReportExpired(parsed_error.message),
                        )
                    }
                    "ReportNotPresent" => {
                        return RusotoError::Service(
                            GetCredentialReportError::CredentialReportNotPresent(
                                parsed_error.message,
                            ),
                        )
                    }
                    "ReportInProgress" => {
                        return RusotoError::Service(
                            GetCredentialReportError::CredentialReportNotReady(
                                parsed_error.message,
                            ),
                        )
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(GetCredentialReportError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for GetCredentialReportError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetCredentialReportError::CredentialReportExpired(ref cause) => write!(f, "{}", cause),
            GetCredentialReportError::CredentialReportNotPresent(ref cause) => {
                write!(f, "{}", cause)
            }
            GetCredentialReportError::CredentialReportNotReady(ref cause) => write!(f, "{}", cause),
            GetCredentialReportError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetCredentialReportError {}
/// Errors returned by GetGroup
#[derive(Debug, PartialEq)]
pub enum GetGroupError {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl GetGroupError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetGroupError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "NoSuchEntity" => {
                        return RusotoError::Service(GetGroupError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(GetGroupError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for GetGroupError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetGroupError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            GetGroupError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetGroupError {}
/// Errors returned by GetGroupPolicy
#[derive(Debug, PartialEq)]
pub enum GetGroupPolicyError {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl GetGroupPolicyError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetGroupPolicyError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "NoSuchEntity" => {
                        return RusotoError::Service(GetGroupPolicyError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(GetGroupPolicyError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for GetGroupPolicyError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetGroupPolicyError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            GetGroupPolicyError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetGroupPolicyError {}
/// Errors returned by GetInstanceProfile
#[derive(Debug, PartialEq)]
pub enum GetInstanceProfileError {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl GetInstanceProfileError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetInstanceProfileError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "NoSuchEntity" => {
                        return RusotoError::Service(GetInstanceProfileError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(GetInstanceProfileError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for GetInstanceProfileError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetInstanceProfileError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            GetInstanceProfileError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetInstanceProfileError {}
/// Errors returned by GetLoginProfile
#[derive(Debug, PartialEq)]
pub enum GetLoginProfileError {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl GetLoginProfileError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetLoginProfileError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "NoSuchEntity" => {
                        return RusotoError::Service(GetLoginProfileError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(GetLoginProfileError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for GetLoginProfileError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetLoginProfileError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            GetLoginProfileError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetLoginProfileError {}
/// Errors returned by GetOpenIDConnectProvider
#[derive(Debug, PartialEq)]
pub enum GetOpenIDConnectProviderError {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an input parameter.</p>
    InvalidInput(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl GetOpenIDConnectProviderError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetOpenIDConnectProviderError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidInput" => {
                        return RusotoError::Service(GetOpenIDConnectProviderError::InvalidInput(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(GetOpenIDConnectProviderError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(GetOpenIDConnectProviderError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for GetOpenIDConnectProviderError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetOpenIDConnectProviderError::InvalidInput(ref cause) => write!(f, "{}", cause),
            GetOpenIDConnectProviderError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            GetOpenIDConnectProviderError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetOpenIDConnectProviderError {}
/// Errors returned by GetOrganizationsAccessReport
#[derive(Debug, PartialEq)]
pub enum GetOrganizationsAccessReportError {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
}

impl GetOrganizationsAccessReportError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<GetOrganizationsAccessReportError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "NoSuchEntity" => {
                        return RusotoError::Service(
                            GetOrganizationsAccessReportError::NoSuchEntity(parsed_error.message),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for GetOrganizationsAccessReportError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetOrganizationsAccessReportError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetOrganizationsAccessReportError {}
/// Errors returned by GetPolicy
#[derive(Debug, PartialEq)]
pub enum GetPolicyError {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an input parameter.</p>
    InvalidInput(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl GetPolicyError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetPolicyError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidInput" => {
                        return RusotoError::Service(GetPolicyError::InvalidInput(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(GetPolicyError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(GetPolicyError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for GetPolicyError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetPolicyError::InvalidInput(ref cause) => write!(f, "{}", cause),
            GetPolicyError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            GetPolicyError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetPolicyError {}
/// Errors returned by GetPolicyVersion
#[derive(Debug, PartialEq)]
pub enum GetPolicyVersionError {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an input parameter.</p>
    InvalidInput(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl GetPolicyVersionError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetPolicyVersionError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidInput" => {
                        return RusotoError::Service(GetPolicyVersionError::InvalidInput(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(GetPolicyVersionError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(GetPolicyVersionError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for GetPolicyVersionError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetPolicyVersionError::InvalidInput(ref cause) => write!(f, "{}", cause),
            GetPolicyVersionError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            GetPolicyVersionError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetPolicyVersionError {}
/// Errors returned by GetRole
#[derive(Debug, PartialEq)]
pub enum GetRoleError {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl GetRoleError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetRoleError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "NoSuchEntity" => {
                        return RusotoError::Service(GetRoleError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(GetRoleError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for GetRoleError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetRoleError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            GetRoleError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetRoleError {}
/// Errors returned by GetRolePolicy
#[derive(Debug, PartialEq)]
pub enum GetRolePolicyError {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl GetRolePolicyError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetRolePolicyError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "NoSuchEntity" => {
                        return RusotoError::Service(GetRolePolicyError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(GetRolePolicyError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for GetRolePolicyError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetRolePolicyError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            GetRolePolicyError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetRolePolicyError {}
/// Errors returned by GetSAMLProvider
#[derive(Debug, PartialEq)]
pub enum GetSAMLProviderError {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an input parameter.</p>
    InvalidInput(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl GetSAMLProviderError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetSAMLProviderError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidInput" => {
                        return RusotoError::Service(GetSAMLProviderError::InvalidInput(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(GetSAMLProviderError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(GetSAMLProviderError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for GetSAMLProviderError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetSAMLProviderError::InvalidInput(ref cause) => write!(f, "{}", cause),
            GetSAMLProviderError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            GetSAMLProviderError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetSAMLProviderError {}
/// Errors returned by GetSSHPublicKey
#[derive(Debug, PartialEq)]
pub enum GetSSHPublicKeyError {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request was rejected because the public key encoding format is unsupported or unrecognized.</p>
    UnrecognizedPublicKeyEncoding(String),
}

impl GetSSHPublicKeyError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetSSHPublicKeyError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "NoSuchEntity" => {
                        return RusotoError::Service(GetSSHPublicKeyError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "UnrecognizedPublicKeyEncoding" => {
                        return RusotoError::Service(
                            GetSSHPublicKeyError::UnrecognizedPublicKeyEncoding(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for GetSSHPublicKeyError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetSSHPublicKeyError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            GetSSHPublicKeyError::UnrecognizedPublicKeyEncoding(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for GetSSHPublicKeyError {}
/// Errors returned by GetServerCertificate
#[derive(Debug, PartialEq)]
pub enum GetServerCertificateError {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl GetServerCertificateError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetServerCertificateError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "NoSuchEntity" => {
                        return RusotoError::Service(GetServerCertificateError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(GetServerCertificateError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for GetServerCertificateError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetServerCertificateError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            GetServerCertificateError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetServerCertificateError {}
/// Errors returned by GetServiceLastAccessedDetails
#[derive(Debug, PartialEq)]
pub enum GetServiceLastAccessedDetailsError {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an input parameter.</p>
    InvalidInput(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
}

impl GetServiceLastAccessedDetailsError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<GetServiceLastAccessedDetailsError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidInput" => {
                        return RusotoError::Service(
                            GetServiceLastAccessedDetailsError::InvalidInput(parsed_error.message),
                        )
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(
                            GetServiceLastAccessedDetailsError::NoSuchEntity(parsed_error.message),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for GetServiceLastAccessedDetailsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetServiceLastAccessedDetailsError::InvalidInput(ref cause) => write!(f, "{}", cause),
            GetServiceLastAccessedDetailsError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetServiceLastAccessedDetailsError {}
/// Errors returned by GetServiceLastAccessedDetailsWithEntities
#[derive(Debug, PartialEq)]
pub enum GetServiceLastAccessedDetailsWithEntitiesError {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an input parameter.</p>
    InvalidInput(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
}

impl GetServiceLastAccessedDetailsWithEntitiesError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<GetServiceLastAccessedDetailsWithEntitiesError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidInput" => {
                        return RusotoError::Service(
                            GetServiceLastAccessedDetailsWithEntitiesError::InvalidInput(
                                parsed_error.message,
                            ),
                        )
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(
                            GetServiceLastAccessedDetailsWithEntitiesError::NoSuchEntity(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for GetServiceLastAccessedDetailsWithEntitiesError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetServiceLastAccessedDetailsWithEntitiesError::InvalidInput(ref cause) => {
                write!(f, "{}", cause)
            }
            GetServiceLastAccessedDetailsWithEntitiesError::NoSuchEntity(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for GetServiceLastAccessedDetailsWithEntitiesError {}
/// Errors returned by GetServiceLinkedRoleDeletionStatus
#[derive(Debug, PartialEq)]
pub enum GetServiceLinkedRoleDeletionStatusError {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an input parameter.</p>
    InvalidInput(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl GetServiceLinkedRoleDeletionStatusError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<GetServiceLinkedRoleDeletionStatusError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidInput" => {
                        return RusotoError::Service(
                            GetServiceLinkedRoleDeletionStatusError::InvalidInput(
                                parsed_error.message,
                            ),
                        )
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(
                            GetServiceLinkedRoleDeletionStatusError::NoSuchEntity(
                                parsed_error.message,
                            ),
                        )
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(
                            GetServiceLinkedRoleDeletionStatusError::ServiceFailure(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for GetServiceLinkedRoleDeletionStatusError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetServiceLinkedRoleDeletionStatusError::InvalidInput(ref cause) => {
                write!(f, "{}", cause)
            }
            GetServiceLinkedRoleDeletionStatusError::NoSuchEntity(ref cause) => {
                write!(f, "{}", cause)
            }
            GetServiceLinkedRoleDeletionStatusError::ServiceFailure(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for GetServiceLinkedRoleDeletionStatusError {}
/// Errors returned by GetUser
#[derive(Debug, PartialEq)]
pub enum GetUserError {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl GetUserError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetUserError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "NoSuchEntity" => {
                        return RusotoError::Service(GetUserError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(GetUserError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for GetUserError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetUserError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            GetUserError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetUserError {}
/// Errors returned by GetUserPolicy
#[derive(Debug, PartialEq)]
pub enum GetUserPolicyError {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl GetUserPolicyError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetUserPolicyError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "NoSuchEntity" => {
                        return RusotoError::Service(GetUserPolicyError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(GetUserPolicyError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for GetUserPolicyError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetUserPolicyError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            GetUserPolicyError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetUserPolicyError {}
/// Errors returned by ListAccessKeys
#[derive(Debug, PartialEq)]
pub enum ListAccessKeysError {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl ListAccessKeysError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListAccessKeysError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "NoSuchEntity" => {
                        return RusotoError::Service(ListAccessKeysError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(ListAccessKeysError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ListAccessKeysError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListAccessKeysError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            ListAccessKeysError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListAccessKeysError {}
/// Errors returned by ListAccountAliases
#[derive(Debug, PartialEq)]
pub enum ListAccountAliasesError {
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl ListAccountAliasesError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListAccountAliasesError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ServiceFailure" => {
                        return RusotoError::Service(ListAccountAliasesError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ListAccountAliasesError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListAccountAliasesError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListAccountAliasesError {}
/// Errors returned by ListAttachedGroupPolicies
#[derive(Debug, PartialEq)]
pub enum ListAttachedGroupPoliciesError {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an input parameter.</p>
    InvalidInput(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl ListAttachedGroupPoliciesError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListAttachedGroupPoliciesError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidInput" => {
                        return RusotoError::Service(ListAttachedGroupPoliciesError::InvalidInput(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(ListAttachedGroupPoliciesError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(
                            ListAttachedGroupPoliciesError::ServiceFailure(parsed_error.message),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ListAttachedGroupPoliciesError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListAttachedGroupPoliciesError::InvalidInput(ref cause) => write!(f, "{}", cause),
            ListAttachedGroupPoliciesError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            ListAttachedGroupPoliciesError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListAttachedGroupPoliciesError {}
/// Errors returned by ListAttachedRolePolicies
#[derive(Debug, PartialEq)]
pub enum ListAttachedRolePoliciesError {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an input parameter.</p>
    InvalidInput(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl ListAttachedRolePoliciesError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListAttachedRolePoliciesError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidInput" => {
                        return RusotoError::Service(ListAttachedRolePoliciesError::InvalidInput(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(ListAttachedRolePoliciesError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(ListAttachedRolePoliciesError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ListAttachedRolePoliciesError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListAttachedRolePoliciesError::InvalidInput(ref cause) => write!(f, "{}", cause),
            ListAttachedRolePoliciesError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            ListAttachedRolePoliciesError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListAttachedRolePoliciesError {}
/// Errors returned by ListAttachedUserPolicies
#[derive(Debug, PartialEq)]
pub enum ListAttachedUserPoliciesError {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an input parameter.</p>
    InvalidInput(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl ListAttachedUserPoliciesError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListAttachedUserPoliciesError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidInput" => {
                        return RusotoError::Service(ListAttachedUserPoliciesError::InvalidInput(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(ListAttachedUserPoliciesError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(ListAttachedUserPoliciesError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ListAttachedUserPoliciesError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListAttachedUserPoliciesError::InvalidInput(ref cause) => write!(f, "{}", cause),
            ListAttachedUserPoliciesError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            ListAttachedUserPoliciesError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListAttachedUserPoliciesError {}
/// Errors returned by ListEntitiesForPolicy
#[derive(Debug, PartialEq)]
pub enum ListEntitiesForPolicyError {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an input parameter.</p>
    InvalidInput(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl ListEntitiesForPolicyError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListEntitiesForPolicyError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidInput" => {
                        return RusotoError::Service(ListEntitiesForPolicyError::InvalidInput(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(ListEntitiesForPolicyError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(ListEntitiesForPolicyError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ListEntitiesForPolicyError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListEntitiesForPolicyError::InvalidInput(ref cause) => write!(f, "{}", cause),
            ListEntitiesForPolicyError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            ListEntitiesForPolicyError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListEntitiesForPolicyError {}
/// Errors returned by ListGroupPolicies
#[derive(Debug, PartialEq)]
pub enum ListGroupPoliciesError {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl ListGroupPoliciesError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListGroupPoliciesError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "NoSuchEntity" => {
                        return RusotoError::Service(ListGroupPoliciesError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(ListGroupPoliciesError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ListGroupPoliciesError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListGroupPoliciesError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            ListGroupPoliciesError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListGroupPoliciesError {}
/// Errors returned by ListGroups
#[derive(Debug, PartialEq)]
pub enum ListGroupsError {
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl ListGroupsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListGroupsError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ServiceFailure" => {
                        return RusotoError::Service(ListGroupsError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ListGroupsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListGroupsError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListGroupsError {}
/// Errors returned by ListGroupsForUser
#[derive(Debug, PartialEq)]
pub enum ListGroupsForUserError {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl ListGroupsForUserError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListGroupsForUserError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "NoSuchEntity" => {
                        return RusotoError::Service(ListGroupsForUserError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(ListGroupsForUserError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ListGroupsForUserError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListGroupsForUserError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            ListGroupsForUserError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListGroupsForUserError {}
/// Errors returned by ListInstanceProfileTags
#[derive(Debug, PartialEq)]
pub enum ListInstanceProfileTagsError {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl ListInstanceProfileTagsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListInstanceProfileTagsError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "NoSuchEntity" => {
                        return RusotoError::Service(ListInstanceProfileTagsError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(ListInstanceProfileTagsError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ListInstanceProfileTagsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListInstanceProfileTagsError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            ListInstanceProfileTagsError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListInstanceProfileTagsError {}
/// Errors returned by ListInstanceProfiles
#[derive(Debug, PartialEq)]
pub enum ListInstanceProfilesError {
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl ListInstanceProfilesError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListInstanceProfilesError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ServiceFailure" => {
                        return RusotoError::Service(ListInstanceProfilesError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ListInstanceProfilesError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListInstanceProfilesError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListInstanceProfilesError {}
/// Errors returned by ListInstanceProfilesForRole
#[derive(Debug, PartialEq)]
pub enum ListInstanceProfilesForRoleError {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl ListInstanceProfilesForRoleError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<ListInstanceProfilesForRoleError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "NoSuchEntity" => {
                        return RusotoError::Service(
                            ListInstanceProfilesForRoleError::NoSuchEntity(parsed_error.message),
                        )
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(
                            ListInstanceProfilesForRoleError::ServiceFailure(parsed_error.message),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ListInstanceProfilesForRoleError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListInstanceProfilesForRoleError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            ListInstanceProfilesForRoleError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListInstanceProfilesForRoleError {}
/// Errors returned by ListMFADeviceTags
#[derive(Debug, PartialEq)]
pub enum ListMFADeviceTagsError {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an input parameter.</p>
    InvalidInput(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl ListMFADeviceTagsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListMFADeviceTagsError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidInput" => {
                        return RusotoError::Service(ListMFADeviceTagsError::InvalidInput(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(ListMFADeviceTagsError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(ListMFADeviceTagsError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ListMFADeviceTagsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListMFADeviceTagsError::InvalidInput(ref cause) => write!(f, "{}", cause),
            ListMFADeviceTagsError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            ListMFADeviceTagsError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListMFADeviceTagsError {}
/// Errors returned by ListMFADevices
#[derive(Debug, PartialEq)]
pub enum ListMFADevicesError {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl ListMFADevicesError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListMFADevicesError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "NoSuchEntity" => {
                        return RusotoError::Service(ListMFADevicesError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(ListMFADevicesError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ListMFADevicesError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListMFADevicesError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            ListMFADevicesError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListMFADevicesError {}
/// Errors returned by ListOpenIDConnectProviderTags
#[derive(Debug, PartialEq)]
pub enum ListOpenIDConnectProviderTagsError {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an input parameter.</p>
    InvalidInput(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl ListOpenIDConnectProviderTagsError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<ListOpenIDConnectProviderTagsError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidInput" => {
                        return RusotoError::Service(
                            ListOpenIDConnectProviderTagsError::InvalidInput(parsed_error.message),
                        )
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(
                            ListOpenIDConnectProviderTagsError::NoSuchEntity(parsed_error.message),
                        )
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(
                            ListOpenIDConnectProviderTagsError::ServiceFailure(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ListOpenIDConnectProviderTagsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListOpenIDConnectProviderTagsError::InvalidInput(ref cause) => write!(f, "{}", cause),
            ListOpenIDConnectProviderTagsError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            ListOpenIDConnectProviderTagsError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListOpenIDConnectProviderTagsError {}
/// Errors returned by ListOpenIDConnectProviders
#[derive(Debug, PartialEq)]
pub enum ListOpenIDConnectProvidersError {
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl ListOpenIDConnectProvidersError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<ListOpenIDConnectProvidersError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ServiceFailure" => {
                        return RusotoError::Service(
                            ListOpenIDConnectProvidersError::ServiceFailure(parsed_error.message),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ListOpenIDConnectProvidersError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListOpenIDConnectProvidersError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListOpenIDConnectProvidersError {}
/// Errors returned by ListPolicies
#[derive(Debug, PartialEq)]
pub enum ListPoliciesError {
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl ListPoliciesError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListPoliciesError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ServiceFailure" => {
                        return RusotoError::Service(ListPoliciesError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ListPoliciesError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListPoliciesError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListPoliciesError {}
/// Errors returned by ListPoliciesGrantingServiceAccess
#[derive(Debug, PartialEq)]
pub enum ListPoliciesGrantingServiceAccessError {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an input parameter.</p>
    InvalidInput(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
}

impl ListPoliciesGrantingServiceAccessError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<ListPoliciesGrantingServiceAccessError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidInput" => {
                        return RusotoError::Service(
                            ListPoliciesGrantingServiceAccessError::InvalidInput(
                                parsed_error.message,
                            ),
                        )
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(
                            ListPoliciesGrantingServiceAccessError::NoSuchEntity(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ListPoliciesGrantingServiceAccessError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListPoliciesGrantingServiceAccessError::InvalidInput(ref cause) => {
                write!(f, "{}", cause)
            }
            ListPoliciesGrantingServiceAccessError::NoSuchEntity(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for ListPoliciesGrantingServiceAccessError {}
/// Errors returned by ListPolicyTags
#[derive(Debug, PartialEq)]
pub enum ListPolicyTagsError {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an input parameter.</p>
    InvalidInput(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl ListPolicyTagsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListPolicyTagsError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidInput" => {
                        return RusotoError::Service(ListPolicyTagsError::InvalidInput(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(ListPolicyTagsError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(ListPolicyTagsError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ListPolicyTagsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListPolicyTagsError::InvalidInput(ref cause) => write!(f, "{}", cause),
            ListPolicyTagsError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            ListPolicyTagsError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListPolicyTagsError {}
/// Errors returned by ListPolicyVersions
#[derive(Debug, PartialEq)]
pub enum ListPolicyVersionsError {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an input parameter.</p>
    InvalidInput(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl ListPolicyVersionsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListPolicyVersionsError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidInput" => {
                        return RusotoError::Service(ListPolicyVersionsError::InvalidInput(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(ListPolicyVersionsError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(ListPolicyVersionsError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ListPolicyVersionsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListPolicyVersionsError::InvalidInput(ref cause) => write!(f, "{}", cause),
            ListPolicyVersionsError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            ListPolicyVersionsError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListPolicyVersionsError {}
/// Errors returned by ListRolePolicies
#[derive(Debug, PartialEq)]
pub enum ListRolePoliciesError {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl ListRolePoliciesError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListRolePoliciesError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "NoSuchEntity" => {
                        return RusotoError::Service(ListRolePoliciesError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(ListRolePoliciesError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ListRolePoliciesError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListRolePoliciesError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            ListRolePoliciesError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListRolePoliciesError {}
/// Errors returned by ListRoleTags
#[derive(Debug, PartialEq)]
pub enum ListRoleTagsError {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl ListRoleTagsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListRoleTagsError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "NoSuchEntity" => {
                        return RusotoError::Service(ListRoleTagsError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(ListRoleTagsError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ListRoleTagsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListRoleTagsError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            ListRoleTagsError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListRoleTagsError {}
/// Errors returned by ListRoles
#[derive(Debug, PartialEq)]
pub enum ListRolesError {
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl ListRolesError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListRolesError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ServiceFailure" => {
                        return RusotoError::Service(ListRolesError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ListRolesError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListRolesError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListRolesError {}
/// Errors returned by ListSAMLProviderTags
#[derive(Debug, PartialEq)]
pub enum ListSAMLProviderTagsError {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an input parameter.</p>
    InvalidInput(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl ListSAMLProviderTagsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListSAMLProviderTagsError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidInput" => {
                        return RusotoError::Service(ListSAMLProviderTagsError::InvalidInput(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(ListSAMLProviderTagsError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(ListSAMLProviderTagsError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ListSAMLProviderTagsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListSAMLProviderTagsError::InvalidInput(ref cause) => write!(f, "{}", cause),
            ListSAMLProviderTagsError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            ListSAMLProviderTagsError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListSAMLProviderTagsError {}
/// Errors returned by ListSAMLProviders
#[derive(Debug, PartialEq)]
pub enum ListSAMLProvidersError {
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl ListSAMLProvidersError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListSAMLProvidersError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ServiceFailure" => {
                        return RusotoError::Service(ListSAMLProvidersError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ListSAMLProvidersError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListSAMLProvidersError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListSAMLProvidersError {}
/// Errors returned by ListSSHPublicKeys
#[derive(Debug, PartialEq)]
pub enum ListSSHPublicKeysError {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
}

impl ListSSHPublicKeysError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListSSHPublicKeysError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "NoSuchEntity" => {
                        return RusotoError::Service(ListSSHPublicKeysError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ListSSHPublicKeysError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListSSHPublicKeysError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListSSHPublicKeysError {}
/// Errors returned by ListServerCertificateTags
#[derive(Debug, PartialEq)]
pub enum ListServerCertificateTagsError {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl ListServerCertificateTagsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListServerCertificateTagsError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "NoSuchEntity" => {
                        return RusotoError::Service(ListServerCertificateTagsError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(
                            ListServerCertificateTagsError::ServiceFailure(parsed_error.message),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ListServerCertificateTagsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListServerCertificateTagsError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            ListServerCertificateTagsError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListServerCertificateTagsError {}
/// Errors returned by ListServerCertificates
#[derive(Debug, PartialEq)]
pub enum ListServerCertificatesError {
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl ListServerCertificatesError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListServerCertificatesError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ServiceFailure" => {
                        return RusotoError::Service(ListServerCertificatesError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ListServerCertificatesError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListServerCertificatesError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListServerCertificatesError {}
/// Errors returned by ListServiceSpecificCredentials
#[derive(Debug, PartialEq)]
pub enum ListServiceSpecificCredentialsError {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The specified service does not support service-specific credentials.</p>
    ServiceNotSupported(String),
}

impl ListServiceSpecificCredentialsError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<ListServiceSpecificCredentialsError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "NoSuchEntity" => {
                        return RusotoError::Service(
                            ListServiceSpecificCredentialsError::NoSuchEntity(parsed_error.message),
                        )
                    }
                    "NotSupportedService" => {
                        return RusotoError::Service(
                            ListServiceSpecificCredentialsError::ServiceNotSupported(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ListServiceSpecificCredentialsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListServiceSpecificCredentialsError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            ListServiceSpecificCredentialsError::ServiceNotSupported(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for ListServiceSpecificCredentialsError {}
/// Errors returned by ListSigningCertificates
#[derive(Debug, PartialEq)]
pub enum ListSigningCertificatesError {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl ListSigningCertificatesError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListSigningCertificatesError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "NoSuchEntity" => {
                        return RusotoError::Service(ListSigningCertificatesError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(ListSigningCertificatesError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ListSigningCertificatesError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListSigningCertificatesError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            ListSigningCertificatesError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListSigningCertificatesError {}
/// Errors returned by ListUserPolicies
#[derive(Debug, PartialEq)]
pub enum ListUserPoliciesError {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl ListUserPoliciesError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListUserPoliciesError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "NoSuchEntity" => {
                        return RusotoError::Service(ListUserPoliciesError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(ListUserPoliciesError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ListUserPoliciesError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListUserPoliciesError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            ListUserPoliciesError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListUserPoliciesError {}
/// Errors returned by ListUserTags
#[derive(Debug, PartialEq)]
pub enum ListUserTagsError {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl ListUserTagsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListUserTagsError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "NoSuchEntity" => {
                        return RusotoError::Service(ListUserTagsError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(ListUserTagsError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ListUserTagsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListUserTagsError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            ListUserTagsError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListUserTagsError {}
/// Errors returned by ListUsers
#[derive(Debug, PartialEq)]
pub enum ListUsersError {
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl ListUsersError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListUsersError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ServiceFailure" => {
                        return RusotoError::Service(ListUsersError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ListUsersError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListUsersError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListUsersError {}
/// Errors returned by ListVirtualMFADevices
#[derive(Debug, PartialEq)]
pub enum ListVirtualMFADevicesError {}

impl ListVirtualMFADevicesError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListVirtualMFADevicesError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ListVirtualMFADevicesError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {}
    }
}
impl Error for ListVirtualMFADevicesError {}
/// Errors returned by PutGroupPolicy
#[derive(Debug, PartialEq)]
pub enum PutGroupPolicyError {
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request was rejected because the policy document was malformed. The error message describes the specific error.</p>
    MalformedPolicyDocument(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl PutGroupPolicyError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<PutGroupPolicyError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "LimitExceeded" => {
                        return RusotoError::Service(PutGroupPolicyError::LimitExceeded(
                            parsed_error.message,
                        ))
                    }
                    "MalformedPolicyDocument" => {
                        return RusotoError::Service(PutGroupPolicyError::MalformedPolicyDocument(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(PutGroupPolicyError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(PutGroupPolicyError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for PutGroupPolicyError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            PutGroupPolicyError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            PutGroupPolicyError::MalformedPolicyDocument(ref cause) => write!(f, "{}", cause),
            PutGroupPolicyError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            PutGroupPolicyError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for PutGroupPolicyError {}
/// Errors returned by PutRolePermissionsBoundary
#[derive(Debug, PartialEq)]
pub enum PutRolePermissionsBoundaryError {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an input parameter.</p>
    InvalidInput(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request failed because AWS service role policies can only be attached to the service-linked role for that service.</p>
    PolicyNotAttachable(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
    /// <p>The request was rejected because only the service that depends on the service-linked role can modify or delete the role on your behalf. The error message includes the name of the service that depends on this service-linked role. You must request the change through that service.</p>
    UnmodifiableEntity(String),
}

impl PutRolePermissionsBoundaryError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<PutRolePermissionsBoundaryError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidInput" => {
                        return RusotoError::Service(PutRolePermissionsBoundaryError::InvalidInput(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(PutRolePermissionsBoundaryError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "PolicyNotAttachable" => {
                        return RusotoError::Service(
                            PutRolePermissionsBoundaryError::PolicyNotAttachable(
                                parsed_error.message,
                            ),
                        )
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(
                            PutRolePermissionsBoundaryError::ServiceFailure(parsed_error.message),
                        )
                    }
                    "UnmodifiableEntity" => {
                        return RusotoError::Service(
                            PutRolePermissionsBoundaryError::UnmodifiableEntity(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for PutRolePermissionsBoundaryError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            PutRolePermissionsBoundaryError::InvalidInput(ref cause) => write!(f, "{}", cause),
            PutRolePermissionsBoundaryError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            PutRolePermissionsBoundaryError::PolicyNotAttachable(ref cause) => {
                write!(f, "{}", cause)
            }
            PutRolePermissionsBoundaryError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            PutRolePermissionsBoundaryError::UnmodifiableEntity(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for PutRolePermissionsBoundaryError {}
/// Errors returned by PutRolePolicy
#[derive(Debug, PartialEq)]
pub enum PutRolePolicyError {
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request was rejected because the policy document was malformed. The error message describes the specific error.</p>
    MalformedPolicyDocument(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
    /// <p>The request was rejected because only the service that depends on the service-linked role can modify or delete the role on your behalf. The error message includes the name of the service that depends on this service-linked role. You must request the change through that service.</p>
    UnmodifiableEntity(String),
}

impl PutRolePolicyError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<PutRolePolicyError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "LimitExceeded" => {
                        return RusotoError::Service(PutRolePolicyError::LimitExceeded(
                            parsed_error.message,
                        ))
                    }
                    "MalformedPolicyDocument" => {
                        return RusotoError::Service(PutRolePolicyError::MalformedPolicyDocument(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(PutRolePolicyError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(PutRolePolicyError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    "UnmodifiableEntity" => {
                        return RusotoError::Service(PutRolePolicyError::UnmodifiableEntity(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for PutRolePolicyError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            PutRolePolicyError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            PutRolePolicyError::MalformedPolicyDocument(ref cause) => write!(f, "{}", cause),
            PutRolePolicyError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            PutRolePolicyError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            PutRolePolicyError::UnmodifiableEntity(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for PutRolePolicyError {}
/// Errors returned by PutUserPermissionsBoundary
#[derive(Debug, PartialEq)]
pub enum PutUserPermissionsBoundaryError {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an input parameter.</p>
    InvalidInput(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request failed because AWS service role policies can only be attached to the service-linked role for that service.</p>
    PolicyNotAttachable(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl PutUserPermissionsBoundaryError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<PutUserPermissionsBoundaryError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidInput" => {
                        return RusotoError::Service(PutUserPermissionsBoundaryError::InvalidInput(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(PutUserPermissionsBoundaryError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "PolicyNotAttachable" => {
                        return RusotoError::Service(
                            PutUserPermissionsBoundaryError::PolicyNotAttachable(
                                parsed_error.message,
                            ),
                        )
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(
                            PutUserPermissionsBoundaryError::ServiceFailure(parsed_error.message),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for PutUserPermissionsBoundaryError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            PutUserPermissionsBoundaryError::InvalidInput(ref cause) => write!(f, "{}", cause),
            PutUserPermissionsBoundaryError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            PutUserPermissionsBoundaryError::PolicyNotAttachable(ref cause) => {
                write!(f, "{}", cause)
            }
            PutUserPermissionsBoundaryError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for PutUserPermissionsBoundaryError {}
/// Errors returned by PutUserPolicy
#[derive(Debug, PartialEq)]
pub enum PutUserPolicyError {
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request was rejected because the policy document was malformed. The error message describes the specific error.</p>
    MalformedPolicyDocument(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl PutUserPolicyError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<PutUserPolicyError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "LimitExceeded" => {
                        return RusotoError::Service(PutUserPolicyError::LimitExceeded(
                            parsed_error.message,
                        ))
                    }
                    "MalformedPolicyDocument" => {
                        return RusotoError::Service(PutUserPolicyError::MalformedPolicyDocument(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(PutUserPolicyError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(PutUserPolicyError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for PutUserPolicyError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            PutUserPolicyError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            PutUserPolicyError::MalformedPolicyDocument(ref cause) => write!(f, "{}", cause),
            PutUserPolicyError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            PutUserPolicyError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for PutUserPolicyError {}
/// Errors returned by RemoveClientIDFromOpenIDConnectProvider
#[derive(Debug, PartialEq)]
pub enum RemoveClientIDFromOpenIDConnectProviderError {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an input parameter.</p>
    InvalidInput(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl RemoveClientIDFromOpenIDConnectProviderError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<RemoveClientIDFromOpenIDConnectProviderError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidInput" => {
                        return RusotoError::Service(
                            RemoveClientIDFromOpenIDConnectProviderError::InvalidInput(
                                parsed_error.message,
                            ),
                        )
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(
                            RemoveClientIDFromOpenIDConnectProviderError::NoSuchEntity(
                                parsed_error.message,
                            ),
                        )
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(
                            RemoveClientIDFromOpenIDConnectProviderError::ServiceFailure(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for RemoveClientIDFromOpenIDConnectProviderError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            RemoveClientIDFromOpenIDConnectProviderError::InvalidInput(ref cause) => {
                write!(f, "{}", cause)
            }
            RemoveClientIDFromOpenIDConnectProviderError::NoSuchEntity(ref cause) => {
                write!(f, "{}", cause)
            }
            RemoveClientIDFromOpenIDConnectProviderError::ServiceFailure(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for RemoveClientIDFromOpenIDConnectProviderError {}
/// Errors returned by RemoveRoleFromInstanceProfile
#[derive(Debug, PartialEq)]
pub enum RemoveRoleFromInstanceProfileError {
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
    /// <p>The request was rejected because only the service that depends on the service-linked role can modify or delete the role on your behalf. The error message includes the name of the service that depends on this service-linked role. You must request the change through that service.</p>
    UnmodifiableEntity(String),
}

impl RemoveRoleFromInstanceProfileError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<RemoveRoleFromInstanceProfileError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "LimitExceeded" => {
                        return RusotoError::Service(
                            RemoveRoleFromInstanceProfileError::LimitExceeded(parsed_error.message),
                        )
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(
                            RemoveRoleFromInstanceProfileError::NoSuchEntity(parsed_error.message),
                        )
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(
                            RemoveRoleFromInstanceProfileError::ServiceFailure(
                                parsed_error.message,
                            ),
                        )
                    }
                    "UnmodifiableEntity" => {
                        return RusotoError::Service(
                            RemoveRoleFromInstanceProfileError::UnmodifiableEntity(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for RemoveRoleFromInstanceProfileError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            RemoveRoleFromInstanceProfileError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            RemoveRoleFromInstanceProfileError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            RemoveRoleFromInstanceProfileError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            RemoveRoleFromInstanceProfileError::UnmodifiableEntity(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for RemoveRoleFromInstanceProfileError {}
/// Errors returned by RemoveUserFromGroup
#[derive(Debug, PartialEq)]
pub enum RemoveUserFromGroupError {
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl RemoveUserFromGroupError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<RemoveUserFromGroupError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "LimitExceeded" => {
                        return RusotoError::Service(RemoveUserFromGroupError::LimitExceeded(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(RemoveUserFromGroupError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(RemoveUserFromGroupError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for RemoveUserFromGroupError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            RemoveUserFromGroupError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            RemoveUserFromGroupError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            RemoveUserFromGroupError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for RemoveUserFromGroupError {}
/// Errors returned by ResetServiceSpecificCredential
#[derive(Debug, PartialEq)]
pub enum ResetServiceSpecificCredentialError {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
}

impl ResetServiceSpecificCredentialError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<ResetServiceSpecificCredentialError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "NoSuchEntity" => {
                        return RusotoError::Service(
                            ResetServiceSpecificCredentialError::NoSuchEntity(parsed_error.message),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ResetServiceSpecificCredentialError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ResetServiceSpecificCredentialError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ResetServiceSpecificCredentialError {}
/// Errors returned by ResyncMFADevice
#[derive(Debug, PartialEq)]
pub enum ResyncMFADeviceError {
    /// <p>The request was rejected because the authentication code was not recognized. The error message describes the specific error.</p>
    InvalidAuthenticationCode(String),
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl ResyncMFADeviceError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ResyncMFADeviceError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidAuthenticationCode" => {
                        return RusotoError::Service(
                            ResyncMFADeviceError::InvalidAuthenticationCode(parsed_error.message),
                        )
                    }
                    "LimitExceeded" => {
                        return RusotoError::Service(ResyncMFADeviceError::LimitExceeded(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(ResyncMFADeviceError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(ResyncMFADeviceError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ResyncMFADeviceError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ResyncMFADeviceError::InvalidAuthenticationCode(ref cause) => write!(f, "{}", cause),
            ResyncMFADeviceError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            ResyncMFADeviceError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            ResyncMFADeviceError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ResyncMFADeviceError {}
/// Errors returned by SetDefaultPolicyVersion
#[derive(Debug, PartialEq)]
pub enum SetDefaultPolicyVersionError {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an input parameter.</p>
    InvalidInput(String),
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl SetDefaultPolicyVersionError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<SetDefaultPolicyVersionError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidInput" => {
                        return RusotoError::Service(SetDefaultPolicyVersionError::InvalidInput(
                            parsed_error.message,
                        ))
                    }
                    "LimitExceeded" => {
                        return RusotoError::Service(SetDefaultPolicyVersionError::LimitExceeded(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(SetDefaultPolicyVersionError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(SetDefaultPolicyVersionError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for SetDefaultPolicyVersionError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            SetDefaultPolicyVersionError::InvalidInput(ref cause) => write!(f, "{}", cause),
            SetDefaultPolicyVersionError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            SetDefaultPolicyVersionError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            SetDefaultPolicyVersionError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for SetDefaultPolicyVersionError {}
/// Errors returned by SetSecurityTokenServicePreferences
#[derive(Debug, PartialEq)]
pub enum SetSecurityTokenServicePreferencesError {
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl SetSecurityTokenServicePreferencesError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<SetSecurityTokenServicePreferencesError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ServiceFailure" => {
                        return RusotoError::Service(
                            SetSecurityTokenServicePreferencesError::ServiceFailure(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for SetSecurityTokenServicePreferencesError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            SetSecurityTokenServicePreferencesError::ServiceFailure(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for SetSecurityTokenServicePreferencesError {}
/// Errors returned by SimulateCustomPolicy
#[derive(Debug, PartialEq)]
pub enum SimulateCustomPolicyError {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an input parameter.</p>
    InvalidInput(String),
    /// <p>The request failed because a provided policy could not be successfully evaluated. An additional detailed message indicates the source of the failure.</p>
    PolicyEvaluation(String),
}

impl SimulateCustomPolicyError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<SimulateCustomPolicyError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidInput" => {
                        return RusotoError::Service(SimulateCustomPolicyError::InvalidInput(
                            parsed_error.message,
                        ))
                    }
                    "PolicyEvaluation" => {
                        return RusotoError::Service(SimulateCustomPolicyError::PolicyEvaluation(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for SimulateCustomPolicyError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            SimulateCustomPolicyError::InvalidInput(ref cause) => write!(f, "{}", cause),
            SimulateCustomPolicyError::PolicyEvaluation(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for SimulateCustomPolicyError {}
/// Errors returned by SimulatePrincipalPolicy
#[derive(Debug, PartialEq)]
pub enum SimulatePrincipalPolicyError {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an input parameter.</p>
    InvalidInput(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request failed because a provided policy could not be successfully evaluated. An additional detailed message indicates the source of the failure.</p>
    PolicyEvaluation(String),
}

impl SimulatePrincipalPolicyError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<SimulatePrincipalPolicyError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidInput" => {
                        return RusotoError::Service(SimulatePrincipalPolicyError::InvalidInput(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(SimulatePrincipalPolicyError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "PolicyEvaluation" => {
                        return RusotoError::Service(
                            SimulatePrincipalPolicyError::PolicyEvaluation(parsed_error.message),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for SimulatePrincipalPolicyError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            SimulatePrincipalPolicyError::InvalidInput(ref cause) => write!(f, "{}", cause),
            SimulatePrincipalPolicyError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            SimulatePrincipalPolicyError::PolicyEvaluation(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for SimulatePrincipalPolicyError {}
/// Errors returned by TagInstanceProfile
#[derive(Debug, PartialEq)]
pub enum TagInstanceProfileError {
    /// <p>The request was rejected because multiple requests to change this object were submitted simultaneously. Wait a few minutes and submit your request again.</p>
    ConcurrentModification(String),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an input parameter.</p>
    InvalidInput(String),
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl TagInstanceProfileError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<TagInstanceProfileError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ConcurrentModification" => {
                        return RusotoError::Service(
                            TagInstanceProfileError::ConcurrentModification(parsed_error.message),
                        )
                    }
                    "InvalidInput" => {
                        return RusotoError::Service(TagInstanceProfileError::InvalidInput(
                            parsed_error.message,
                        ))
                    }
                    "LimitExceeded" => {
                        return RusotoError::Service(TagInstanceProfileError::LimitExceeded(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(TagInstanceProfileError::NoSuchEntity(
                            parsed_error.message,
                        ))
                    }
                    "ServiceFailure" => {
                        return RusotoError::Service(TagInstanceProfileError::ServiceFailure(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for TagInstanceProfileError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            TagInstanceProfileError::ConcurrentModification(ref cause) => write!(f, "{}", cause),
            TagInstanceProfileError::InvalidInput(ref cause) => write!(f, "{}", cause),
            TagInstanceProfileError::LimitExceeded(ref cause) => write!(f, "{}", cause),
            TagInstanceProfileError::NoSuchEntity(ref cause) => write!(f, "{}", cause),
            TagInstanceProfileError::ServiceFailure(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for TagInstanceProfileError {}
/// Errors returned by TagMFADevice
#[derive(Debug, PartialEq)]
pub enum TagMFADeviceError {
    /// <p>The request was rejected because multiple requests to change this object were submitted simultaneously. Wait a few minutes and submit your request again.</p>
    ConcurrentModification(String),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an input parameter.</p>
    InvalidInput(String),
    /// <p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>
    LimitExceeded(String),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The error message describes the resource.</p>
    NoSuchEntity(String),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    ServiceFailure(String),
}

impl TagMFADeviceError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<TagMFADeviceError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ConcurrentModification" => {
                        return RusotoError::Service(TagMFADeviceError::ConcurrentModification(
                            parsed_error.message,
                        ))
                    }
                    "InvalidInput" => {
                        return RusotoError::Service(TagMFADeviceError::InvalidInput(
                            parsed_error.message,
                        ))
                    }
                    "LimitExceeded" => {
                        return RusotoError::Service(TagMFADeviceError::LimitExceeded(
                            parsed_error.message,
                        ))
                    }
                    "NoSuchEntity" => {
                        return RusotoError::Service(TagMFADeviceError::NoSuchEntity(
                            parsed_er