// =================================================================
//
//                           * WARNING *
//
//                    This file is generated!
//
//  Changes made to this file will be overwritten. If changes are
//  required to the generated code, the service_crategen project
//  must be updated to generate the changes.
//
// =================================================================

use std::error::Error;
use std::fmt;

use async_trait::async_trait;
use rusoto_core::credential::ProvideAwsCredentials;
use rusoto_core::region;
use rusoto_core::request::{BufferedHttpResponse, DispatchSignedRequest};
use rusoto_core::{Client, RusotoError};

use rusoto_core::param::{Params, ServiceParams};
use rusoto_core::proto::xml::error::*;
use rusoto_core::proto::xml::util::{
    self as xml_util, deserialize_elements, find_start_element, skip_tree,
};
use rusoto_core::proto::xml::util::{Next, Peek, XmlParseError, XmlResponse};
use rusoto_core::request::HttpResponse;
use rusoto_core::signature::SignedRequest;
#[cfg(feature = "deserialize_structs")]
use serde::Deserialize;
#[cfg(feature = "serialize_structs")]
use serde::Serialize;
use serde_urlencoded;
use std::str::FromStr;
use xml::EventReader;

impl Ec2Client {
    fn new_params(&self, operation_name: &str) -> Params {
        let mut params = Params::new();

        params.put("Action", operation_name);
        params.put("Version", "2016-11-15");

        params
    }

    async fn sign_and_dispatch<E>(
        &self,
        request: SignedRequest,
        from_response: fn(BufferedHttpResponse) -> RusotoError<E>,
    ) -> Result<HttpResponse, RusotoError<E>> {
        let mut response = self.client.sign_and_dispatch(request).await?;
        if !response.status.is_success() {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            return Err(from_response(response));
        }

        Ok(response)
    }
}

/// <p>Contains the parameters for accepting the quote.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AcceptReservedInstancesExchangeQuoteRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The IDs of the Convertible Reserved Instances to exchange for another Convertible Reserved Instance of the same or higher value.</p>
    pub reserved_instance_ids: Vec<String>,
    /// <p>The configuration of the target Convertible Reserved Instance to exchange for your current Convertible Reserved Instances.</p>
    pub target_configurations: Option<Vec<TargetConfigurationRequest>>,
}

/// Serialize `AcceptReservedInstancesExchangeQuoteRequest` contents to a `SignedRequest`.
struct AcceptReservedInstancesExchangeQuoteRequestSerializer;
impl AcceptReservedInstancesExchangeQuoteRequestSerializer {
    fn serialize(
        params: &mut Params,
        name: &str,
        obj: &AcceptReservedInstancesExchangeQuoteRequest,
    ) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        ReservedInstanceIdSetSerializer::serialize(
            params,
            &format!("{}{}", prefix, "ReservedInstanceId"),
            &obj.reserved_instance_ids,
        );
        if let Some(ref field_value) = obj.target_configurations {
            TargetConfigurationRequestSetSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TargetConfiguration"),
                field_value,
            );
        }
    }
}

/// <p>The result of the exchange and whether it was <code>successful</code>.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AcceptReservedInstancesExchangeQuoteResult {
    /// <p>The ID of the successful exchange.</p>
    pub exchange_id: Option<String>,
}

#[allow(dead_code)]
struct AcceptReservedInstancesExchangeQuoteResultDeserializer;
impl AcceptReservedInstancesExchangeQuoteResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AcceptReservedInstancesExchangeQuoteResult, XmlParseError> {
        deserialize_elements::<_, AcceptReservedInstancesExchangeQuoteResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "exchangeId" => {
                        obj.exchange_id =
                            Some(StringDeserializer::deserialize("exchangeId", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AcceptTransitGatewayMulticastDomainAssociationsRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The IDs of the subnets to associate with the transit gateway multicast domain.</p>
    pub subnet_ids: Option<Vec<String>>,
    /// <p>The ID of the transit gateway attachment.</p>
    pub transit_gateway_attachment_id: Option<String>,
    /// <p>The ID of the transit gateway multicast domain.</p>
    pub transit_gateway_multicast_domain_id: Option<String>,
}

/// Serialize `AcceptTransitGatewayMulticastDomainAssociationsRequest` contents to a `SignedRequest`.
struct AcceptTransitGatewayMulticastDomainAssociationsRequestSerializer;
impl AcceptTransitGatewayMulticastDomainAssociationsRequestSerializer {
    fn serialize(
        params: &mut Params,
        name: &str,
        obj: &AcceptTransitGatewayMulticastDomainAssociationsRequest,
    ) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.subnet_ids {
            ValueStringListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "SubnetIds"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.transit_gateway_attachment_id {
            params.put(
                &format!("{}{}", prefix, "TransitGatewayAttachmentId"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.transit_gateway_multicast_domain_id {
            params.put(
                &format!("{}{}", prefix, "TransitGatewayMulticastDomainId"),
                &field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AcceptTransitGatewayMulticastDomainAssociationsResult {
    pub associations: Option<TransitGatewayMulticastDomainAssociations>,
}

#[allow(dead_code)]
struct AcceptTransitGatewayMulticastDomainAssociationsResultDeserializer;
impl AcceptTransitGatewayMulticastDomainAssociationsResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AcceptTransitGatewayMulticastDomainAssociationsResult, XmlParseError> {
        deserialize_elements::<_, AcceptTransitGatewayMulticastDomainAssociationsResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "associations" => {
                        obj.associations = Some(
                            TransitGatewayMulticastDomainAssociationsDeserializer::deserialize(
                                "associations",
                                stack,
                            )?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AcceptTransitGatewayPeeringAttachmentRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the transit gateway attachment.</p>
    pub transit_gateway_attachment_id: String,
}

/// Serialize `AcceptTransitGatewayPeeringAttachmentRequest` contents to a `SignedRequest`.
struct AcceptTransitGatewayPeeringAttachmentRequestSerializer;
impl AcceptTransitGatewayPeeringAttachmentRequestSerializer {
    fn serialize(
        params: &mut Params,
        name: &str,
        obj: &AcceptTransitGatewayPeeringAttachmentRequest,
    ) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "TransitGatewayAttachmentId"),
            &obj.transit_gateway_attachment_id,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AcceptTransitGatewayPeeringAttachmentResult {
    /// <p>The transit gateway peering attachment.</p>
    pub transit_gateway_peering_attachment: Option<TransitGatewayPeeringAttachment>,
}

#[allow(dead_code)]
struct AcceptTransitGatewayPeeringAttachmentResultDeserializer;
impl AcceptTransitGatewayPeeringAttachmentResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AcceptTransitGatewayPeeringAttachmentResult, XmlParseError> {
        deserialize_elements::<_, AcceptTransitGatewayPeeringAttachmentResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "transitGatewayPeeringAttachment" => {
                        obj.transit_gateway_peering_attachment =
                            Some(TransitGatewayPeeringAttachmentDeserializer::deserialize(
                                "transitGatewayPeeringAttachment",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AcceptTransitGatewayVpcAttachmentRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the attachment.</p>
    pub transit_gateway_attachment_id: String,
}

/// Serialize `AcceptTransitGatewayVpcAttachmentRequest` contents to a `SignedRequest`.
struct AcceptTransitGatewayVpcAttachmentRequestSerializer;
impl AcceptTransitGatewayVpcAttachmentRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &AcceptTransitGatewayVpcAttachmentRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "TransitGatewayAttachmentId"),
            &obj.transit_gateway_attachment_id,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AcceptTransitGatewayVpcAttachmentResult {
    /// <p>The VPC attachment.</p>
    pub transit_gateway_vpc_attachment: Option<TransitGatewayVpcAttachment>,
}

#[allow(dead_code)]
struct AcceptTransitGatewayVpcAttachmentResultDeserializer;
impl AcceptTransitGatewayVpcAttachmentResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AcceptTransitGatewayVpcAttachmentResult, XmlParseError> {
        deserialize_elements::<_, AcceptTransitGatewayVpcAttachmentResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "transitGatewayVpcAttachment" => {
                        obj.transit_gateway_vpc_attachment =
                            Some(TransitGatewayVpcAttachmentDeserializer::deserialize(
                                "transitGatewayVpcAttachment",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AcceptVpcEndpointConnectionsRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the VPC endpoint service.</p>
    pub service_id: String,
    /// <p>The IDs of one or more interface VPC endpoints.</p>
    pub vpc_endpoint_ids: Vec<String>,
}

/// Serialize `AcceptVpcEndpointConnectionsRequest` contents to a `SignedRequest`.
struct AcceptVpcEndpointConnectionsRequestSerializer;
impl AcceptVpcEndpointConnectionsRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &AcceptVpcEndpointConnectionsRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "ServiceId"), &obj.service_id);
        VpcEndpointIdListSerializer::serialize(
            params,
            &format!("{}{}", prefix, "VpcEndpointId"),
            &obj.vpc_endpoint_ids,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AcceptVpcEndpointConnectionsResult {
    /// <p>Information about the interface endpoints that were not accepted, if applicable.</p>
    pub unsuccessful: Option<Vec<UnsuccessfulItem>>,
}

#[allow(dead_code)]
struct AcceptVpcEndpointConnectionsResultDeserializer;
impl AcceptVpcEndpointConnectionsResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AcceptVpcEndpointConnectionsResult, XmlParseError> {
        deserialize_elements::<_, AcceptVpcEndpointConnectionsResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "unsuccessful" => {
                        obj.unsuccessful.get_or_insert(vec![]).extend(
                            UnsuccessfulItemSetDeserializer::deserialize("unsuccessful", stack)?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AcceptVpcPeeringConnectionRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the VPC peering connection. You must specify this parameter in the request.</p>
    pub vpc_peering_connection_id: Option<String>,
}

/// Serialize `AcceptVpcPeeringConnectionRequest` contents to a `SignedRequest`.
struct AcceptVpcPeeringConnectionRequestSerializer;
impl AcceptVpcPeeringConnectionRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &AcceptVpcPeeringConnectionRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.vpc_peering_connection_id {
            params.put(
                &format!("{}{}", prefix, "VpcPeeringConnectionId"),
                &field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AcceptVpcPeeringConnectionResult {
    /// <p>Information about the VPC peering connection.</p>
    pub vpc_peering_connection: Option<VpcPeeringConnection>,
}

#[allow(dead_code)]
struct AcceptVpcPeeringConnectionResultDeserializer;
impl AcceptVpcPeeringConnectionResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AcceptVpcPeeringConnectionResult, XmlParseError> {
        deserialize_elements::<_, AcceptVpcPeeringConnectionResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "vpcPeeringConnection" => {
                        obj.vpc_peering_connection =
                            Some(VpcPeeringConnectionDeserializer::deserialize(
                                "vpcPeeringConnection",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Describes an account attribute.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AccountAttribute {
    /// <p>The name of the account attribute.</p>
    pub attribute_name: Option<String>,
    /// <p>The values for the account attribute.</p>
    pub attribute_values: Option<Vec<AccountAttributeValue>>,
}

#[allow(dead_code)]
struct AccountAttributeDeserializer;
impl AccountAttributeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AccountAttribute, XmlParseError> {
        deserialize_elements::<_, AccountAttribute, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "attributeName" => {
                    obj.attribute_name =
                        Some(StringDeserializer::deserialize("attributeName", stack)?);
                }
                "attributeValueSet" => {
                    obj.attribute_values.get_or_insert(vec![]).extend(
                        AccountAttributeValueListDeserializer::deserialize(
                            "attributeValueSet",
                            stack,
                        )?,
                    );
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct AccountAttributeListDeserializer;
impl AccountAttributeListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<AccountAttribute>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "item" {
                obj.push(AccountAttributeDeserializer::deserialize("item", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}

/// Serialize `AccountAttributeNameStringList` contents to a `SignedRequest`.
struct AccountAttributeNameStringListSerializer;
impl AccountAttributeNameStringListSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<String>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.{}", name, index + 1);
            params.put(&key, &obj);
        }
    }
}

/// <p>Describes a value of an account attribute.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AccountAttributeValue {
    /// <p>The value of the attribute.</p>
    pub attribute_value: Option<String>,
}

#[allow(dead_code)]
struct AccountAttributeValueDeserializer;
impl AccountAttributeValueDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AccountAttributeValue, XmlParseError> {
        deserialize_elements::<_, AccountAttributeValue, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "attributeValue" => {
                    obj.attribute_value =
                        Some(StringDeserializer::deserialize("attributeValue", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct AccountAttributeValueListDeserializer;
impl AccountAttributeValueListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<AccountAttributeValue>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "item" {
                obj.push(AccountAttributeValueDeserializer::deserialize(
                    "item", stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Describes a running instance in a Spot Fleet.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ActiveInstance {
    /// <p>The health status of the instance. If the status of either the instance status check or the system status check is <code>impaired</code>, the health status of the instance is <code>unhealthy</code>. Otherwise, the health status is <code>healthy</code>.</p>
    pub instance_health: Option<String>,
    /// <p>The ID of the instance.</p>
    pub instance_id: Option<String>,
    /// <p>The instance type.</p>
    pub instance_type: Option<String>,
    /// <p>The ID of the Spot Instance request.</p>
    pub spot_instance_request_id: Option<String>,
}

#[allow(dead_code)]
struct ActiveInstanceDeserializer;
impl ActiveInstanceDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ActiveInstance, XmlParseError> {
        deserialize_elements::<_, ActiveInstance, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "instanceHealth" => {
                    obj.instance_health = Some(InstanceHealthStatusDeserializer::deserialize(
                        "instanceHealth",
                        stack,
                    )?);
                }
                "instanceId" => {
                    obj.instance_id = Some(StringDeserializer::deserialize("instanceId", stack)?);
                }
                "instanceType" => {
                    obj.instance_type =
                        Some(StringDeserializer::deserialize("instanceType", stack)?);
                }
                "spotInstanceRequestId" => {
                    obj.spot_instance_request_id = Some(StringDeserializer::deserialize(
                        "spotInstanceRequestId",
                        stack,
                    )?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct ActiveInstanceSetDeserializer;
impl ActiveInstanceSetDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<ActiveInstance>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "item" {
                obj.push(ActiveInstanceDeserializer::deserialize("item", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct ActivityStatusDeserializer;
impl ActivityStatusDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}

/// Serialize `AddPrefixListEntries` contents to a `SignedRequest`.
struct AddPrefixListEntriesSerializer;
impl AddPrefixListEntriesSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<AddPrefixListEntry>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.{}", name, index + 1);
            AddPrefixListEntrySerializer::serialize(params, &key, obj);
        }
    }
}

/// <p>An entry for a prefix list.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AddPrefixListEntry {
    /// <p>The CIDR block.</p>
    pub cidr: String,
    /// <p>A description for the entry.</p> <p>Constraints: Up to 255 characters in length.</p>
    pub description: Option<String>,
}

/// Serialize `AddPrefixListEntry` contents to a `SignedRequest`.
struct AddPrefixListEntrySerializer;
impl AddPrefixListEntrySerializer {
    fn serialize(params: &mut Params, name: &str, obj: &AddPrefixListEntry) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "Cidr"), &obj.cidr);
        if let Some(ref field_value) = obj.description {
            params.put(&format!("{}{}", prefix, "Description"), &field_value);
        }
    }
}

/// <p>Describes an Elastic IP address, or a carrier IP address.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct Address {
    /// <p>The ID representing the allocation of the address for use with EC2-VPC.</p>
    pub allocation_id: Option<String>,
    /// <p>The ID representing the association of the address with an instance in a VPC.</p>
    pub association_id: Option<String>,
    /// <p>The carrier IP address associated. This option is only available for network interfaces which reside in a subnet in a Wavelength Zone (for example an EC2 instance). </p>
    pub carrier_ip: Option<String>,
    /// <p>The customer-owned IP address.</p>
    pub customer_owned_ip: Option<String>,
    /// <p>The ID of the customer-owned address pool.</p>
    pub customer_owned_ipv_4_pool: Option<String>,
    /// <p>Indicates whether this Elastic IP address is for use with instances in EC2-Classic (<code>standard</code>) or instances in a VPC (<code>vpc</code>).</p>
    pub domain: Option<String>,
    /// <p>The ID of the instance that the address is associated with (if any).</p>
    pub instance_id: Option<String>,
    /// <p>The name of the unique set of Availability Zones, Local Zones, or Wavelength Zones from which AWS advertises IP addresses. </p>
    pub network_border_group: Option<String>,
    /// <p>The ID of the network interface.</p>
    pub network_interface_id: Option<String>,
    /// <p>The ID of the account that owns the network interface.</p>
    pub network_interface_owner_id: Option<String>,
    /// <p>The private IP address associated with the Elastic IP address.</p>
    pub private_ip_address: Option<String>,
    /// <p>The Elastic IP address.</p>
    pub public_ip: Option<String>,
    /// <p>The ID of an address pool.</p>
    pub public_ipv_4_pool: Option<String>,
    /// <p>Any tags assigned to the Elastic IP address.</p>
    pub tags: Option<Vec<Tag>>,
}

#[allow(dead_code)]
struct AddressDeserializer;
impl AddressDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Address, XmlParseError> {
        deserialize_elements::<_, Address, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "allocationId" => {
                    obj.allocation_id =
                        Some(StringDeserializer::deserialize("allocationId", stack)?);
                }
                "associationId" => {
                    obj.association_id =
                        Some(StringDeserializer::deserialize("associationId", stack)?);
                }
                "carrierIp" => {
                    obj.carrier_ip = Some(StringDeserializer::deserialize("carrierIp", stack)?);
                }
                "customerOwnedIp" => {
                    obj.customer_owned_ip =
                        Some(StringDeserializer::deserialize("customerOwnedIp", stack)?);
                }
                "customerOwnedIpv4Pool" => {
                    obj.customer_owned_ipv_4_pool = Some(StringDeserializer::deserialize(
                        "customerOwnedIpv4Pool",
                        stack,
                    )?);
                }
                "domain" => {
                    obj.domain = Some(DomainTypeDeserializer::deserialize("domain", stack)?);
                }
                "instanceId" => {
                    obj.instance_id = Some(StringDeserializer::deserialize("instanceId", stack)?);
                }
                "networkBorderGroup" => {
                    obj.network_border_group = Some(StringDeserializer::deserialize(
                        "networkBorderGroup",
                        stack,
                    )?);
                }
                "networkInterfaceId" => {
                    obj.network_interface_id = Some(StringDeserializer::deserialize(
                        "networkInterfaceId",
                        stack,
                    )?);
                }
                "networkInterfaceOwnerId" => {
                    obj.network_interface_owner_id = Some(StringDeserializer::deserialize(
                        "networkInterfaceOwnerId",
                        stack,
                    )?);
                }
                "privateIpAddress" => {
                    obj.private_ip_address =
                        Some(StringDeserializer::deserialize("privateIpAddress", stack)?);
                }
                "publicIp" => {
                    obj.public_ip = Some(StringDeserializer::deserialize("publicIp", stack)?);
                }
                "publicIpv4Pool" => {
                    obj.public_ipv_4_pool =
                        Some(StringDeserializer::deserialize("publicIpv4Pool", stack)?);
                }
                "tagSet" => {
                    obj.tags
                        .get_or_insert(vec![])
                        .extend(TagListDeserializer::deserialize("tagSet", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>The attributes associated with an Elastic IP address.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AddressAttribute {
    /// <p>[EC2-VPC] The allocation ID.</p>
    pub allocation_id: Option<String>,
    /// <p>The pointer (PTR) record for the IP address.</p>
    pub ptr_record: Option<String>,
    /// <p>The updated PTR record for the IP address.</p>
    pub ptr_record_update: Option<PtrUpdateStatus>,
    /// <p>The public IP address.</p>
    pub public_ip: Option<String>,
}

#[allow(dead_code)]
struct AddressAttributeDeserializer;
impl AddressAttributeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AddressAttribute, XmlParseError> {
        deserialize_elements::<_, AddressAttribute, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "allocationId" => {
                    obj.allocation_id = Some(AllocationIdDeserializer::deserialize(
                        "allocationId",
                        stack,
                    )?);
                }
                "ptrRecord" => {
                    obj.ptr_record = Some(StringDeserializer::deserialize("ptrRecord", stack)?);
                }
                "ptrRecordUpdate" => {
                    obj.ptr_record_update = Some(PtrUpdateStatusDeserializer::deserialize(
                        "ptrRecordUpdate",
                        stack,
                    )?);
                }
                "publicIp" => {
                    obj.public_ip =
                        Some(PublicIpAddressDeserializer::deserialize("publicIp", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct AddressListDeserializer;
impl AddressListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<Address>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "item" {
                obj.push(AddressDeserializer::deserialize("item", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct AddressSetDeserializer;
impl AddressSetDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<AddressAttribute>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "item" {
                obj.push(AddressAttributeDeserializer::deserialize("item", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AdvertiseByoipCidrRequest {
    /// <p>The address range, in CIDR notation. This must be the exact range that you provisioned. You can't advertise only a portion of the provisioned range.</p>
    pub cidr: String,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
}

/// Serialize `AdvertiseByoipCidrRequest` contents to a `SignedRequest`.
struct AdvertiseByoipCidrRequestSerializer;
impl AdvertiseByoipCidrRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &AdvertiseByoipCidrRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "Cidr"), &obj.cidr);
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AdvertiseByoipCidrResult {
    /// <p>Information about the address range.</p>
    pub byoip_cidr: Option<ByoipCidr>,
}

#[allow(dead_code)]
struct AdvertiseByoipCidrResultDeserializer;
impl AdvertiseByoipCidrResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AdvertiseByoipCidrResult, XmlParseError> {
        deserialize_elements::<_, AdvertiseByoipCidrResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "byoipCidr" => {
                        obj.byoip_cidr =
                            Some(ByoipCidrDeserializer::deserialize("byoipCidr", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AllocateAddressRequest {
    /// <p>[EC2-VPC] The Elastic IP address to recover or an IPv4 address from an address pool.</p>
    pub address: Option<String>,
    /// <p>The ID of a customer-owned address pool. Use this parameter to let Amazon EC2 select an address from the address pool. Alternatively, specify a specific address from the address pool.</p>
    pub customer_owned_ipv_4_pool: Option<String>,
    /// <p>Indicates whether the Elastic IP address is for use with instances in a VPC or instances in EC2-Classic.</p> <p>Default: If the Region supports EC2-Classic, the default is <code>standard</code>. Otherwise, the default is <code>vpc</code>.</p>
    pub domain: Option<String>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p><p> A unique set of Availability Zones, Local Zones, or Wavelength Zones from which AWS advertises IP addresses. Use this parameter to limit the IP address to this location. IP addresses cannot move between network border groups.</p> <p>Use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAvailabilityZones.html">DescribeAvailabilityZones</a> to view the network border groups.</p> <note> <p>You cannot use a network border group with EC2 Classic. If you attempt this operation on EC2 classic, you will receive an <code>InvalidParameterCombination</code> error. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html">Error Codes</a>.</p> </note></p>
    pub network_border_group: Option<String>,
    /// <p>The ID of an address pool that you own. Use this parameter to let Amazon EC2 select an address from the address pool. To specify a specific address from the address pool, use the <code>Address</code> parameter instead.</p>
    pub public_ipv_4_pool: Option<String>,
    /// <p>The tags to assign to the Elastic IP address.</p>
    pub tag_specifications: Option<Vec<TagSpecification>>,
}

/// Serialize `AllocateAddressRequest` contents to a `SignedRequest`.
struct AllocateAddressRequestSerializer;
impl AllocateAddressRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &AllocateAddressRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.address {
            params.put(&format!("{}{}", prefix, "Address"), &field_value);
        }
        if let Some(ref field_value) = obj.customer_owned_ipv_4_pool {
            params.put(
                &format!("{}{}", prefix, "CustomerOwnedIpv4Pool"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.domain {
            params.put(&format!("{}{}", prefix, "Domain"), &field_value);
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.network_border_group {
            params.put(&format!("{}{}", prefix, "NetworkBorderGroup"), &field_value);
        }
        if let Some(ref field_value) = obj.public_ipv_4_pool {
            params.put(&format!("{}{}", prefix, "PublicIpv4Pool"), &field_value);
        }
        if let Some(ref field_value) = obj.tag_specifications {
            TagSpecificationListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagSpecification"),
                field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AllocateAddressResult {
    /// <p>[EC2-VPC] The ID that Amazon Web Services assigns to represent the allocation of the Elastic IP address for use with instances in a VPC.</p>
    pub allocation_id: Option<String>,
    /// <p>The carrier IP address. This option is only available for network interfaces which reside in a subnet in a Wavelength Zone (for example an EC2 instance). </p>
    pub carrier_ip: Option<String>,
    /// <p>The customer-owned IP address.</p>
    pub customer_owned_ip: Option<String>,
    /// <p>The ID of the customer-owned address pool.</p>
    pub customer_owned_ipv_4_pool: Option<String>,
    /// <p>Indicates whether the Elastic IP address is for use with instances in a VPC (<code>vpc</code>) or instances in EC2-Classic (<code>standard</code>).</p>
    pub domain: Option<String>,
    /// <p>The set of Availability Zones, Local Zones, or Wavelength Zones from which AWS advertises IP addresses.</p>
    pub network_border_group: Option<String>,
    /// <p>The Elastic IP address.</p>
    pub public_ip: Option<String>,
    /// <p>The ID of an address pool.</p>
    pub public_ipv_4_pool: Option<String>,
}

#[allow(dead_code)]
struct AllocateAddressResultDeserializer;
impl AllocateAddressResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AllocateAddressResult, XmlParseError> {
        deserialize_elements::<_, AllocateAddressResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "allocationId" => {
                    obj.allocation_id =
                        Some(StringDeserializer::deserialize("allocationId", stack)?);
                }
                "carrierIp" => {
                    obj.carrier_ip = Some(StringDeserializer::deserialize("carrierIp", stack)?);
                }
                "customerOwnedIp" => {
                    obj.customer_owned_ip =
                        Some(StringDeserializer::deserialize("customerOwnedIp", stack)?);
                }
                "customerOwnedIpv4Pool" => {
                    obj.customer_owned_ipv_4_pool = Some(StringDeserializer::deserialize(
                        "customerOwnedIpv4Pool",
                        stack,
                    )?);
                }
                "domain" => {
                    obj.domain = Some(DomainTypeDeserializer::deserialize("domain", stack)?);
                }
                "networkBorderGroup" => {
                    obj.network_border_group = Some(StringDeserializer::deserialize(
                        "networkBorderGroup",
                        stack,
                    )?);
                }
                "publicIp" => {
                    obj.public_ip = Some(StringDeserializer::deserialize("publicIp", stack)?);
                }
                "publicIpv4Pool" => {
                    obj.public_ipv_4_pool =
                        Some(StringDeserializer::deserialize("publicIpv4Pool", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AllocateHostsRequest {
    /// <p>Indicates whether the host accepts any untargeted instance launches that match its instance type configuration, or if it only accepts Host tenancy instance launches that specify its unique host ID. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/how-dedicated-hosts-work.html#dedicated-hosts-understanding"> Understanding auto-placement and affinity</a> in the <i>Amazon EC2 User Guide</i>.</p> <p>Default: <code>on</code> </p>
    pub auto_placement: Option<String>,
    /// <p>The Availability Zone in which to allocate the Dedicated Host.</p>
    pub availability_zone: String,
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
    pub client_token: Option<String>,
    /// <p>Indicates whether to enable or disable host recovery for the Dedicated Host. Host recovery is disabled by default. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-recovery.html"> Host recovery</a> in the <i>Amazon EC2 User Guide</i>.</p> <p>Default: <code>off</code> </p>
    pub host_recovery: Option<String>,
    /// <p>Specifies the instance family to be supported by the Dedicated Hosts. If you specify an instance family, the Dedicated Hosts support multiple instance types within that instance family.</p> <p>If you want the Dedicated Hosts to support a specific instance type only, omit this parameter and specify <b>InstanceType</b> instead. You cannot specify <b>InstanceFamily</b> and <b>InstanceType</b> in the same request.</p>
    pub instance_family: Option<String>,
    /// <p>Specifies the instance type to be supported by the Dedicated Hosts. If you specify an instance type, the Dedicated Hosts support instances of the specified instance type only.</p> <p>If you want the Dedicated Hosts to support multiple instance types in a specific instance family, omit this parameter and specify <b>InstanceFamily</b> instead. You cannot specify <b>InstanceType</b> and <b>InstanceFamily</b> in the same request.</p>
    pub instance_type: Option<String>,
    /// <p>The number of Dedicated Hosts to allocate to your account with these parameters.</p>
    pub quantity: i64,
    /// <p>The tags to apply to the Dedicated Host during creation.</p>
    pub tag_specifications: Option<Vec<TagSpecification>>,
}

/// Serialize `AllocateHostsRequest` contents to a `SignedRequest`.
struct AllocateHostsRequestSerializer;
impl AllocateHostsRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &AllocateHostsRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.auto_placement {
            params.put(&format!("{}{}", prefix, "AutoPlacement"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "AvailabilityZone"),
            &obj.availability_zone,
        );
        if let Some(ref field_value) = obj.client_token {
            params.put(&format!("{}{}", prefix, "ClientToken"), &field_value);
        }
        if let Some(ref field_value) = obj.host_recovery {
            params.put(&format!("{}{}", prefix, "HostRecovery"), &field_value);
        }
        if let Some(ref field_value) = obj.instance_family {
            params.put(&format!("{}{}", prefix, "InstanceFamily"), &field_value);
        }
        if let Some(ref field_value) = obj.instance_type {
            params.put(&format!("{}{}", prefix, "InstanceType"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "Quantity"), &obj.quantity);
        if let Some(ref field_value) = obj.tag_specifications {
            TagSpecificationListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagSpecification"),
                field_value,
            );
        }
    }
}

/// <p>Contains the output of AllocateHosts.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AllocateHostsResult {
    /// <p>The ID of the allocated Dedicated Host. This is used to launch an instance onto a specific host.</p>
    pub host_ids: Option<Vec<String>>,
}

#[allow(dead_code)]
struct AllocateHostsResultDeserializer;
impl AllocateHostsResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AllocateHostsResult, XmlParseError> {
        deserialize_elements::<_, AllocateHostsResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "hostIdSet" => {
                    obj.host_ids.get_or_insert(vec![]).extend(
                        ResponseHostIdListDeserializer::deserialize("hostIdSet", stack)?,
                    );
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct AllocationIdDeserializer;
impl AllocationIdDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}

/// Serialize `AllocationIdList` contents to a `SignedRequest`.
struct AllocationIdListSerializer;
impl AllocationIdListSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<String>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.{}", name, index + 1);
            params.put(&key, &obj);
        }
    }
}

/// Serialize `AllocationIds` contents to a `SignedRequest`.
struct AllocationIdsSerializer;
impl AllocationIdsSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<String>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.{}", name, index + 1);
            params.put(&key, &obj);
        }
    }
}

#[allow(dead_code)]
struct AllocationStateDeserializer;
impl AllocationStateDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct AllocationStrategyDeserializer;
impl AllocationStrategyDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p>Describes a principal.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AllowedPrincipal {
    /// <p>The Amazon Resource Name (ARN) of the principal.</p>
    pub principal: Option<String>,
    /// <p>The type of principal.</p>
    pub principal_type: Option<String>,
}

#[allow(dead_code)]
struct AllowedPrincipalDeserializer;
impl AllowedPrincipalDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AllowedPrincipal, XmlParseError> {
        deserialize_elements::<_, AllowedPrincipal, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "principal" => {
                    obj.principal = Some(StringDeserializer::deserialize("principal", stack)?);
                }
                "principalType" => {
                    obj.principal_type = Some(PrincipalTypeDeserializer::deserialize(
                        "principalType",
                        stack,
                    )?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct AllowedPrincipalSetDeserializer;
impl AllowedPrincipalSetDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<AllowedPrincipal>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "item" {
                obj.push(AllowedPrincipalDeserializer::deserialize("item", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct AllowsMultipleInstanceTypesDeserializer;
impl AllowsMultipleInstanceTypesDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p>Describes an potential intermediate component of a feasible path.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AlternatePathHint {
    /// <p>The Amazon Resource Name (ARN) of the component.</p>
    pub component_arn: Option<String>,
    /// <p>The ID of the component.</p>
    pub component_id: Option<String>,
}

#[allow(dead_code)]
struct AlternatePathHintDeserializer;
impl AlternatePathHintDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AlternatePathHint, XmlParseError> {
        deserialize_elements::<_, AlternatePathHint, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "componentArn" => {
                    obj.component_arn =
                        Some(StringDeserializer::deserialize("componentArn", stack)?);
                }
                "componentId" => {
                    obj.component_id = Some(StringDeserializer::deserialize("componentId", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct AlternatePathHintListDeserializer;
impl AlternatePathHintListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<AlternatePathHint>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "item" {
                obj.push(AlternatePathHintDeserializer::deserialize("item", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Describes a network access control (ACL) rule.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AnalysisAclRule {
    /// <p>The IPv4 address range, in CIDR notation.</p>
    pub cidr: Option<String>,
    /// <p>Indicates whether the rule is an outbound rule.</p>
    pub egress: Option<bool>,
    /// <p>The range of ports.</p>
    pub port_range: Option<PortRange>,
    /// <p>The protocol.</p>
    pub protocol: Option<String>,
    /// <p>Indicates whether to allow or deny traffic that matches the rule.</p>
    pub rule_action: Option<String>,
    /// <p>The rule number.</p>
    pub rule_number: Option<i64>,
}

#[allow(dead_code)]
struct AnalysisAclRuleDeserializer;
impl AnalysisAclRuleDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AnalysisAclRule, XmlParseError> {
        deserialize_elements::<_, AnalysisAclRule, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "cidr" => {
                    obj.cidr = Some(StringDeserializer::deserialize("cidr", stack)?);
                }
                "egress" => {
                    obj.egress = Some(BooleanDeserializer::deserialize("egress", stack)?);
                }
                "portRange" => {
                    obj.port_range = Some(PortRangeDeserializer::deserialize("portRange", stack)?);
                }
                "protocol" => {
                    obj.protocol = Some(StringDeserializer::deserialize("protocol", stack)?);
                }
                "ruleAction" => {
                    obj.rule_action = Some(StringDeserializer::deserialize("ruleAction", stack)?);
                }
                "ruleNumber" => {
                    obj.rule_number = Some(IntegerDeserializer::deserialize("ruleNumber", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>Describes a path component.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AnalysisComponent {
    /// <p>The Amazon Resource Name (ARN) of the component.</p>
    pub arn: Option<String>,
    /// <p>The ID of the component.</p>
    pub id: Option<String>,
}

#[allow(dead_code)]
struct AnalysisComponentDeserializer;
impl AnalysisComponentDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AnalysisComponent, XmlParseError> {
        deserialize_elements::<_, AnalysisComponent, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "arn" => {
                    obj.arn = Some(StringDeserializer::deserialize("arn", stack)?);
                }
                "id" => {
                    obj.id = Some(StringDeserializer::deserialize("id", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct AnalysisComponentListDeserializer;
impl AnalysisComponentListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<AnalysisComponent>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "item" {
                obj.push(AnalysisComponentDeserializer::deserialize("item", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Describes a load balancer listener.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AnalysisLoadBalancerListener {
    /// <p>[Classic Load Balancers] The back-end port for the listener.</p>
    pub instance_port: Option<i64>,
    /// <p>The port on which the load balancer is listening.</p>
    pub load_balancer_port: Option<i64>,
}

#[allow(dead_code)]
struct AnalysisLoadBalancerListenerDeserializer;
impl AnalysisLoadBalancerListenerDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AnalysisLoadBalancerListener, XmlParseError> {
        deserialize_elements::<_, AnalysisLoadBalancerListener, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "instancePort" => {
                        obj.instance_port =
                            Some(PortDeserializer::deserialize("instancePort", stack)?);
                    }
                    "loadBalancerPort" => {
                        obj.load_balancer_port =
                            Some(PortDeserializer::deserialize("loadBalancerPort", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Describes a load balancer target.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AnalysisLoadBalancerTarget {
    /// <p>The IP address.</p>
    pub address: Option<String>,
    /// <p>The Availability Zone.</p>
    pub availability_zone: Option<String>,
    /// <p>Information about the instance.</p>
    pub instance: Option<AnalysisComponent>,
    /// <p>The port on which the target is listening.</p>
    pub port: Option<i64>,
}

#[allow(dead_code)]
struct AnalysisLoadBalancerTargetDeserializer;
impl AnalysisLoadBalancerTargetDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AnalysisLoadBalancerTarget, XmlParseError> {
        deserialize_elements::<_, AnalysisLoadBalancerTarget, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "address" => {
                        obj.address = Some(IpAddressDeserializer::deserialize("address", stack)?);
                    }
                    "availabilityZone" => {
                        obj.availability_zone =
                            Some(StringDeserializer::deserialize("availabilityZone", stack)?);
                    }
                    "instance" => {
                        obj.instance = Some(AnalysisComponentDeserializer::deserialize(
                            "instance", stack,
                        )?);
                    }
                    "port" => {
                        obj.port = Some(PortDeserializer::deserialize("port", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Describes a header. Reflects any changes made by a component as traffic passes through. The fields of an inbound header are null except for the first component of a path.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AnalysisPacketHeader {
    /// <p>The destination addresses.</p>
    pub destination_addresses: Option<Vec<String>>,
    /// <p>The destination port ranges.</p>
    pub destination_port_ranges: Option<Vec<PortRange>>,
    /// <p>The protocol.</p>
    pub protocol: Option<String>,
    /// <p>The source addresses.</p>
    pub source_addresses: Option<Vec<String>>,
    /// <p>The source port ranges.</p>
    pub source_port_ranges: Option<Vec<PortRange>>,
}

#[allow(dead_code)]
struct AnalysisPacketHeaderDeserializer;
impl AnalysisPacketHeaderDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AnalysisPacketHeader, XmlParseError> {
        deserialize_elements::<_, AnalysisPacketHeader, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "destinationAddressSet" => {
                    obj.destination_addresses.get_or_insert(vec![]).extend(
                        IpAddressListDeserializer::deserialize("destinationAddressSet", stack)?,
                    );
                }
                "destinationPortRangeSet" => {
                    obj.destination_port_ranges.get_or_insert(vec![]).extend(
                        PortRangeListDeserializer::deserialize("destinationPortRangeSet", stack)?,
                    );
                }
                "protocol" => {
                    obj.protocol = Some(StringDeserializer::deserialize("protocol", stack)?);
                }
                "sourceAddressSet" => {
                    obj.source_addresses.get_or_insert(vec![]).extend(
                        IpAddressListDeserializer::deserialize("sourceAddressSet", stack)?,
                    );
                }
                "sourcePortRangeSet" => {
                    obj.source_port_ranges.get_or_insert(vec![]).extend(
                        PortRangeListDeserializer::deserialize("sourcePortRangeSet", stack)?,
                    );
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>Describes a route table route.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AnalysisRouteTableRoute {
    /// <p>The destination IPv4 address, in CIDR notation.</p>
    pub destination_cidr: Option<String>,
    /// <p>The prefix of the AWS service.</p>
    pub destination_prefix_list_id: Option<String>,
    /// <p>The ID of an egress-only internet gateway.</p>
    pub egress_only_internet_gateway_id: Option<String>,
    /// <p>The ID of the gateway, such as an internet gateway or virtual private gateway.</p>
    pub gateway_id: Option<String>,
    /// <p>The ID of the instance, such as a NAT instance.</p>
    pub instance_id: Option<String>,
    /// <p>The ID of a NAT gateway.</p>
    pub nat_gateway_id: Option<String>,
    /// <p>The ID of a network interface.</p>
    pub network_interface_id: Option<String>,
    /// <p><p>Describes how the route was created. The following are possible values:</p> <ul> <li> <p> <code>CreateRouteTable</code> - The route was automatically created when the route table was created.</p> </li> <li> <p> <code>CreateRoute</code> - The route was manually added to the route table.</p> </li> <li> <p> <code>EnableVgwRoutePropagation</code> - The route was propagated by route propagation.</p> </li> </ul></p>
    pub origin: Option<String>,
    /// <p>The ID of a transit gateway.</p>
    pub transit_gateway_id: Option<String>,
    /// <p>The ID of a VPC peering connection.</p>
    pub vpc_peering_connection_id: Option<String>,
}

#[allow(dead_code)]
struct AnalysisRouteTableRouteDeserializer;
impl AnalysisRouteTableRouteDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AnalysisRouteTableRoute, XmlParseError> {
        deserialize_elements::<_, AnalysisRouteTableRoute, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "destinationCidr" => {
                        obj.destination_cidr =
                            Some(StringDeserializer::deserialize("destinationCidr", stack)?);
                    }
                    "destinationPrefixListId" => {
                        obj.destination_prefix_list_id = Some(StringDeserializer::deserialize(
                            "destinationPrefixListId",
                            stack,
                        )?);
                    }
                    "egressOnlyInternetGatewayId" => {
                        obj.egress_only_internet_gateway_id = Some(
                            StringDeserializer::deserialize("egressOnlyInternetGatewayId", stack)?,
                        );
                    }
                    "gatewayId" => {
                        obj.gateway_id = Some(StringDeserializer::deserialize("gatewayId", stack)?);
                    }
                    "instanceId" => {
                        obj.instance_id =
                            Some(StringDeserializer::deserialize("instanceId", stack)?);
                    }
                    "natGatewayId" => {
                        obj.nat_gateway_id =
                            Some(StringDeserializer::deserialize("natGatewayId", stack)?);
                    }
                    "networkInterfaceId" => {
                        obj.network_interface_id = Some(StringDeserializer::deserialize(
                            "networkInterfaceId",
                            stack,
                        )?);
                    }
                    "origin" => {
                        obj.origin = Some(StringDeserializer::deserialize("origin", stack)?);
                    }
                    "transitGatewayId" => {
                        obj.transit_gateway_id =
                            Some(StringDeserializer::deserialize("transitGatewayId", stack)?);
                    }
                    "vpcPeeringConnectionId" => {
                        obj.vpc_peering_connection_id = Some(StringDeserializer::deserialize(
                            "vpcPeeringConnectionId",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Describes a security group rule.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AnalysisSecurityGroupRule {
    /// <p>The IPv4 address range, in CIDR notation.</p>
    pub cidr: Option<String>,
    /// <p><p>The direction. The following are possible values:</p> <ul> <li> <p>egress</p> </li> <li> <p>ingress</p> </li> </ul></p>
    pub direction: Option<String>,
    /// <p>The port range.</p>
    pub port_range: Option<PortRange>,
    /// <p>The prefix list ID.</p>
    pub prefix_list_id: Option<String>,
    /// <p>The protocol name.</p>
    pub protocol: Option<String>,
    /// <p>The security group ID.</p>
    pub security_group_id: Option<String>,
}

#[allow(dead_code)]
struct AnalysisSecurityGroupRuleDeserializer;
impl AnalysisSecurityGroupRuleDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AnalysisSecurityGroupRule, XmlParseError> {
        deserialize_elements::<_, AnalysisSecurityGroupRule, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "cidr" => {
                        obj.cidr = Some(StringDeserializer::deserialize("cidr", stack)?);
                    }
                    "direction" => {
                        obj.direction = Some(StringDeserializer::deserialize("direction", stack)?);
                    }
                    "portRange" => {
                        obj.port_range =
                            Some(PortRangeDeserializer::deserialize("portRange", stack)?);
                    }
                    "prefixListId" => {
                        obj.prefix_list_id =
                            Some(StringDeserializer::deserialize("prefixListId", stack)?);
                    }
                    "protocol" => {
                        obj.protocol = Some(StringDeserializer::deserialize("protocol", stack)?);
                    }
                    "securityGroupId" => {
                        obj.security_group_id =
                            Some(StringDeserializer::deserialize("securityGroupId", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct AnalysisStatusDeserializer;
impl AnalysisStatusDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct ApplianceModeSupportValueDeserializer;
impl ApplianceModeSupportValueDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ApplySecurityGroupsToClientVpnTargetNetworkRequest {
    /// <p>The ID of the Client VPN endpoint.</p>
    pub client_vpn_endpoint_id: String,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The IDs of the security groups to apply to the associated target network. Up to 5 security groups can be applied to an associated target network.</p>
    pub security_group_ids: Vec<String>,
    /// <p>The ID of the VPC in which the associated target network is located.</p>
    pub vpc_id: String,
}

/// Serialize `ApplySecurityGroupsToClientVpnTargetNetworkRequest` contents to a `SignedRequest`.
struct ApplySecurityGroupsToClientVpnTargetNetworkRequestSerializer;
impl ApplySecurityGroupsToClientVpnTargetNetworkRequestSerializer {
    fn serialize(
        params: &mut Params,
        name: &str,
        obj: &ApplySecurityGroupsToClientVpnTargetNetworkRequest,
    ) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "ClientVpnEndpointId"),
            &obj.client_vpn_endpoint_id,
        );
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        ClientVpnSecurityGroupIdSetSerializer::serialize(
            params,
            &format!("{}{}", prefix, "SecurityGroupId"),
            &obj.security_group_ids,
        );
        params.put(&format!("{}{}", prefix, "VpcId"), &obj.vpc_id);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ApplySecurityGroupsToClientVpnTargetNetworkResult {
    /// <p>The IDs of the applied security groups.</p>
    pub security_group_ids: Option<Vec<String>>,
}

#[allow(dead_code)]
struct ApplySecurityGroupsToClientVpnTargetNetworkResultDeserializer;
impl ApplySecurityGroupsToClientVpnTargetNetworkResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ApplySecurityGroupsToClientVpnTargetNetworkResult, XmlParseError> {
        deserialize_elements::<_, ApplySecurityGroupsToClientVpnTargetNetworkResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "securityGroupIds" => {
                        obj.security_group_ids.get_or_insert(vec![]).extend(
                            ClientVpnSecurityGroupIdSetDeserializer::deserialize(
                                "securityGroupIds",
                                stack,
                            )?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct ArchitectureTypeDeserializer;
impl ArchitectureTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct ArchitectureTypeListDeserializer;
impl ArchitectureTypeListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<String>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "item" {
                obj.push(ArchitectureTypeDeserializer::deserialize("item", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct ArchitectureValuesDeserializer;
impl ArchitectureValuesDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct ArnListDeserializer;
impl ArnListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<String>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "item" {
                obj.push(ResourceArnDeserializer::deserialize("item", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}

/// Serialize `ArnList` contents to a `SignedRequest`.
struct ArnListSerializer;
impl ArnListSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<String>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.{}", name, index + 1);
            params.put(&key, &obj);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AssignIpv6AddressesRequest {
    /// <p>The number of additional IPv6 addresses to assign to the network interface. The specified number of IPv6 addresses are assigned in addition to the existing IPv6 addresses that are already assigned to the network interface. Amazon EC2 automatically selects the IPv6 addresses from the subnet range. You can't use this option if specifying specific IPv6 addresses.</p>
    pub ipv_6_address_count: Option<i64>,
    /// <p>One or more specific IPv6 addresses to be assigned to the network interface. You can't use this option if you're specifying a number of IPv6 addresses.</p>
    pub ipv_6_addresses: Option<Vec<String>>,
    /// <p>The ID of the network interface.</p>
    pub network_interface_id: String,
}

/// Serialize `AssignIpv6AddressesRequest` contents to a `SignedRequest`.
struct AssignIpv6AddressesRequestSerializer;
impl AssignIpv6AddressesRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &AssignIpv6AddressesRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.ipv_6_address_count {
            params.put(&format!("{}{}", prefix, "Ipv6AddressCount"), &field_value);
        }
        if let Some(ref field_value) = obj.ipv_6_addresses {
            Ipv6AddressListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Ipv6Addresses"),
                field_value,
            );
        }
        params.put(
            &format!("{}{}", prefix, "NetworkInterfaceId"),
            &obj.network_interface_id,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AssignIpv6AddressesResult {
    /// <p>The new IPv6 addresses assigned to the network interface. Existing IPv6 addresses that were assigned to the network interface before the request are not included.</p>
    pub assigned_ipv_6_addresses: Option<Vec<String>>,
    /// <p>The ID of the network interface.</p>
    pub network_interface_id: Option<String>,
}

#[allow(dead_code)]
struct AssignIpv6AddressesResultDeserializer;
impl AssignIpv6AddressesResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AssignIpv6AddressesResult, XmlParseError> {
        deserialize_elements::<_, AssignIpv6AddressesResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "assignedIpv6Addresses" => {
                        obj.assigned_ipv_6_addresses.get_or_insert(vec![]).extend(
                            Ipv6AddressListDeserializer::deserialize(
                                "assignedIpv6Addresses",
                                stack,
                            )?,
                        );
                    }
                    "networkInterfaceId" => {
                        obj.network_interface_id = Some(StringDeserializer::deserialize(
                            "networkInterfaceId",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Contains the parameters for AssignPrivateIpAddresses.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AssignPrivateIpAddressesRequest {
    /// <p>Indicates whether to allow an IP address that is already assigned to another network interface or instance to be reassigned to the specified network interface.</p>
    pub allow_reassignment: Option<bool>,
    /// <p>The ID of the network interface.</p>
    pub network_interface_id: String,
    /// <p>One or more IP addresses to be assigned as a secondary private IP address to the network interface. You can't specify this parameter when also specifying a number of secondary IP addresses.</p> <p>If you don't specify an IP address, Amazon EC2 automatically selects an IP address within the subnet range.</p>
    pub private_ip_addresses: Option<Vec<String>>,
    /// <p>The number of secondary IP addresses to assign to the network interface. You can't specify this parameter when also specifying private IP addresses.</p>
    pub secondary_private_ip_address_count: Option<i64>,
}

/// Serialize `AssignPrivateIpAddressesRequest` contents to a `SignedRequest`.
struct AssignPrivateIpAddressesRequestSerializer;
impl AssignPrivateIpAddressesRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &AssignPrivateIpAddressesRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.allow_reassignment {
            params.put(&format!("{}{}", prefix, "AllowReassignment"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "NetworkInterfaceId"),
            &obj.network_interface_id,
        );
        if let Some(ref field_value) = obj.private_ip_addresses {
            PrivateIpAddressStringListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "PrivateIpAddress"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.secondary_private_ip_address_count {
            params.put(
                &format!("{}{}", prefix, "SecondaryPrivateIpAddressCount"),
                &field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AssignPrivateIpAddressesResult {
    /// <p>The private IP addresses assigned to the network interface.</p>
    pub assigned_private_ip_addresses: Option<Vec<AssignedPrivateIpAddress>>,
    /// <p>The ID of the network interface.</p>
    pub network_interface_id: Option<String>,
}

#[allow(dead_code)]
struct AssignPrivateIpAddressesResultDeserializer;
impl AssignPrivateIpAddressesResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AssignPrivateIpAddressesResult, XmlParseError> {
        deserialize_elements::<_, AssignPrivateIpAddressesResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "assignedPrivateIpAddressesSet" => {
                        obj.assigned_private_ip_addresses
                            .get_or_insert(vec![])
                            .extend(AssignedPrivateIpAddressListDeserializer::deserialize(
                                "assignedPrivateIpAddressesSet",
                                stack,
                            )?);
                    }
                    "networkInterfaceId" => {
                        obj.network_interface_id = Some(StringDeserializer::deserialize(
                            "networkInterfaceId",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Describes the private IP addresses assigned to a network interface.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AssignedPrivateIpAddress {
    /// <p>The private IP address assigned to the network interface.</p>
    pub private_ip_address: Option<String>,
}

#[allow(dead_code)]
struct AssignedPrivateIpAddressDeserializer;
impl AssignedPrivateIpAddressDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AssignedPrivateIpAddress, XmlParseError> {
        deserialize_elements::<_, AssignedPrivateIpAddress, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "privateIpAddress" => {
                        obj.private_ip_address =
                            Some(StringDeserializer::deserialize("privateIpAddress", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct AssignedPrivateIpAddressListDeserializer;
impl AssignedPrivateIpAddressListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<AssignedPrivateIpAddress>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "item" {
                obj.push(AssignedPrivateIpAddressDeserializer::deserialize(
                    "item", stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AssociateAddressRequest {
    /// <p>[EC2-VPC] The allocation ID. This is required for EC2-VPC.</p>
    pub allocation_id: Option<String>,
    /// <p>[EC2-VPC] For a VPC in an EC2-Classic account, specify true to allow an Elastic IP address that is already associated with an instance or network interface to be reassociated with the specified instance or network interface. Otherwise, the operation fails. In a VPC in an EC2-VPC-only account, reassociation is automatic, therefore you can specify false to ensure the operation fails if the Elastic IP address is already associated with another resource.</p>
    pub allow_reassociation: Option<bool>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the instance. The instance must have exactly one attached network interface. For EC2-VPC, you can specify either the instance ID or the network interface ID, but not both. For EC2-Classic, you must specify an instance ID and the instance must be in the running state.</p>
    pub instance_id: Option<String>,
    /// <p>[EC2-VPC] The ID of the network interface. If the instance has more than one network interface, you must specify a network interface ID.</p> <p>For EC2-VPC, you can specify either the instance ID or the network interface ID, but not both. </p>
    pub network_interface_id: Option<String>,
    /// <p>[EC2-VPC] The primary or secondary private IP address to associate with the Elastic IP address. If no private IP address is specified, the Elastic IP address is associated with the primary private IP address.</p>
    pub private_ip_address: Option<String>,
    /// <p>[EC2-Classic] The Elastic IP address to associate with the instance. This is required for EC2-Classic.</p>
    pub public_ip: Option<String>,
}

/// Serialize `AssociateAddressRequest` contents to a `SignedRequest`.
struct AssociateAddressRequestSerializer;
impl AssociateAddressRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &AssociateAddressRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.allocation_id {
            params.put(&format!("{}{}", prefix, "AllocationId"), &field_value);
        }
        if let Some(ref field_value) = obj.allow_reassociation {
            params.put(&format!("{}{}", prefix, "AllowReassociation"), &field_value);
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.instance_id {
            params.put(&format!("{}{}", prefix, "InstanceId"), &field_value);
        }
        if let Some(ref field_value) = obj.network_interface_id {
            params.put(&format!("{}{}", prefix, "NetworkInterfaceId"), &field_value);
        }
        if let Some(ref field_value) = obj.private_ip_address {
            params.put(&format!("{}{}", prefix, "PrivateIpAddress"), &field_value);
        }
        if let Some(ref field_value) = obj.public_ip {
            params.put(&format!("{}{}", prefix, "PublicIp"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AssociateAddressResult {
    /// <p>[EC2-VPC] The ID that represents the association of the Elastic IP address with an instance.</p>
    pub association_id: Option<String>,
}

#[allow(dead_code)]
struct AssociateAddressResultDeserializer;
impl AssociateAddressResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AssociateAddressResult, XmlParseError> {
        deserialize_elements::<_, AssociateAddressResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "associationId" => {
                    obj.association_id =
                        Some(StringDeserializer::deserialize("associationId", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AssociateClientVpnTargetNetworkRequest {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure Idempotency</a>.</p>
    pub client_token: Option<String>,
    /// <p>The ID of the Client VPN endpoint.</p>
    pub client_vpn_endpoint_id: String,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the subnet to associate with the Client VPN endpoint.</p>
    pub subnet_id: String,
}

/// Serialize `AssociateClientVpnTargetNetworkRequest` contents to a `SignedRequest`.
struct AssociateClientVpnTargetNetworkRequestSerializer;
impl AssociateClientVpnTargetNetworkRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &AssociateClientVpnTargetNetworkRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.client_token {
            params.put(&format!("{}{}", prefix, "ClientToken"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "ClientVpnEndpointId"),
            &obj.client_vpn_endpoint_id,
        );
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "SubnetId"), &obj.subnet_id);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AssociateClientVpnTargetNetworkResult {
    /// <p>The unique ID of the target network association.</p>
    pub association_id: Option<String>,
    /// <p>The current state of the target network association.</p>
    pub status: Option<AssociationStatus>,
}

#[allow(dead_code)]
struct AssociateClientVpnTargetNetworkResultDeserializer;
impl AssociateClientVpnTargetNetworkResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AssociateClientVpnTargetNetworkResult, XmlParseError> {
        deserialize_elements::<_, AssociateClientVpnTargetNetworkResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "associationId" => {
                        obj.association_id =
                            Some(StringDeserializer::deserialize("associationId", stack)?);
                    }
                    "status" => {
                        obj.status =
                            Some(AssociationStatusDeserializer::deserialize("status", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AssociateDhcpOptionsRequest {
    /// <p>The ID of the DHCP options set, or <code>default</code> to associate no DHCP options with the VPC.</p>
    pub dhcp_options_id: String,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the VPC.</p>
    pub vpc_id: String,
}

/// Serialize `AssociateDhcpOptionsRequest` contents to a `SignedRequest`.
struct AssociateDhcpOptionsRequestSerializer;
impl AssociateDhcpOptionsRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &AssociateDhcpOptionsRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "DhcpOptionsId"),
            &obj.dhcp_options_id,
        );
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "VpcId"), &obj.vpc_id);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AssociateEnclaveCertificateIamRoleRequest {
    /// <p>The ARN of the ACM certificate with which to associate the IAM role.</p>
    pub certificate_arn: Option<String>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ARN of the IAM role to associate with the ACM certificate. You can associate up to 16 IAM roles with an ACM certificate.</p>
    pub role_arn: Option<String>,
}

/// Serialize `AssociateEnclaveCertificateIamRoleRequest` contents to a `SignedRequest`.
struct AssociateEnclaveCertificateIamRoleRequestSerializer;
impl AssociateEnclaveCertificateIamRoleRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &AssociateEnclaveCertificateIamRoleRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.certificate_arn {
            params.put(&format!("{}{}", prefix, "CertificateArn"), &field_value);
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.role_arn {
            params.put(&format!("{}{}", prefix, "RoleArn"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AssociateEnclaveCertificateIamRoleResult {
    /// <p>The name of the Amazon S3 bucket to which the certificate was uploaded.</p>
    pub certificate_s3_bucket_name: Option<String>,
    /// <p>The Amazon S3 object key where the certificate, certificate chain, and encrypted private key bundle are stored. The object key is formatted as follows: <code>role_arn</code>/<code>certificate_arn</code>.</p>
    pub certificate_s3_object_key: Option<String>,
    /// <p>The ID of the AWS KMS CMK used to encrypt the private key of the certificate.</p>
    pub encryption_kms_key_id: Option<String>,
}

#[allow(dead_code)]
struct AssociateEnclaveCertificateIamRoleResultDeserializer;
impl AssociateEnclaveCertificateIamRoleResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AssociateEnclaveCertificateIamRoleResult, XmlParseError> {
        deserialize_elements::<_, AssociateEnclaveCertificateIamRoleResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "certificateS3BucketName" => {
                        obj.certificate_s3_bucket_name = Some(StringDeserializer::deserialize(
                            "certificateS3BucketName",
                            stack,
                        )?);
                    }
                    "certificateS3ObjectKey" => {
                        obj.certificate_s3_object_key = Some(StringDeserializer::deserialize(
                            "certificateS3ObjectKey",
                            stack,
                        )?);
                    }
                    "encryptionKmsKeyId" => {
                        obj.encryption_kms_key_id = Some(StringDeserializer::deserialize(
                            "encryptionKmsKeyId",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AssociateIamInstanceProfileRequest {
    /// <p>The IAM instance profile.</p>
    pub iam_instance_profile: IamInstanceProfileSpecification,
    /// <p>The ID of the instance.</p>
    pub instance_id: String,
}

/// Serialize `AssociateIamInstanceProfileRequest` contents to a `SignedRequest`.
struct AssociateIamInstanceProfileRequestSerializer;
impl AssociateIamInstanceProfileRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &AssociateIamInstanceProfileRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        IamInstanceProfileSpecificationSerializer::serialize(
            params,
            &format!("{}{}", prefix, "IamInstanceProfile"),
            &obj.iam_instance_profile,
        );
        params.put(&format!("{}{}", prefix, "InstanceId"), &obj.instance_id);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AssociateIamInstanceProfileResult {
    /// <p>Information about the IAM instance profile association.</p>
    pub iam_instance_profile_association: Option<IamInstanceProfileAssociation>,
}

#[allow(dead_code)]
struct AssociateIamInstanceProfileResultDeserializer;
impl AssociateIamInstanceProfileResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AssociateIamInstanceProfileResult, XmlParseError> {
        deserialize_elements::<_, AssociateIamInstanceProfileResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "iamInstanceProfileAssociation" => {
                        obj.iam_instance_profile_association =
                            Some(IamInstanceProfileAssociationDeserializer::deserialize(
                                "iamInstanceProfileAssociation",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AssociateRouteTableRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the internet gateway or virtual private gateway.</p>
    pub gateway_id: Option<String>,
    /// <p>The ID of the route table.</p>
    pub route_table_id: String,
    /// <p>The ID of the subnet.</p>
    pub subnet_id: Option<String>,
}

/// Serialize `AssociateRouteTableRequest` contents to a `SignedRequest`.
struct AssociateRouteTableRequestSerializer;
impl AssociateRouteTableRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &AssociateRouteTableRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.gateway_id {
            params.put(&format!("{}{}", prefix, "GatewayId"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "RouteTableId"),
            &obj.route_table_id,
        );
        if let Some(ref field_value) = obj.subnet_id {
            params.put(&format!("{}{}", prefix, "SubnetId"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AssociateRouteTableResult {
    /// <p>The route table association ID. This ID is required for disassociating the route table.</p>
    pub association_id: Option<String>,
    /// <p>The state of the association.</p>
    pub association_state: Option<RouteTableAssociationState>,
}

#[allow(dead_code)]
struct AssociateRouteTableResultDeserializer;
impl AssociateRouteTableResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AssociateRouteTableResult, XmlParseError> {
        deserialize_elements::<_, AssociateRouteTableResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "associationId" => {
                        obj.association_id =
                            Some(StringDeserializer::deserialize("associationId", stack)?);
                    }
                    "associationState" => {
                        obj.association_state =
                            Some(RouteTableAssociationStateDeserializer::deserialize(
                                "associationState",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AssociateSubnetCidrBlockRequest {
    /// <p>The IPv6 CIDR block for your subnet. The subnet must have a /64 prefix length.</p>
    pub ipv_6_cidr_block: String,
    /// <p>The ID of your subnet.</p>
    pub subnet_id: String,
}

/// Serialize `AssociateSubnetCidrBlockRequest` contents to a `SignedRequest`.
struct AssociateSubnetCidrBlockRequestSerializer;
impl AssociateSubnetCidrBlockRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &AssociateSubnetCidrBlockRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "Ipv6CidrBlock"),
            &obj.ipv_6_cidr_block,
        );
        params.put(&format!("{}{}", prefix, "SubnetId"), &obj.subnet_id);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AssociateSubnetCidrBlockResult {
    /// <p>Information about the IPv6 CIDR block association.</p>
    pub ipv_6_cidr_block_association: Option<SubnetIpv6CidrBlockAssociation>,
    /// <p>The ID of the subnet.</p>
    pub subnet_id: Option<String>,
}

#[allow(dead_code)]
struct AssociateSubnetCidrBlockResultDeserializer;
impl AssociateSubnetCidrBlockResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AssociateSubnetCidrBlockResult, XmlParseError> {
        deserialize_elements::<_, AssociateSubnetCidrBlockResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "ipv6CidrBlockAssociation" => {
                        obj.ipv_6_cidr_block_association =
                            Some(SubnetIpv6CidrBlockAssociationDeserializer::deserialize(
                                "ipv6CidrBlockAssociation",
                                stack,
                            )?);
                    }
                    "subnetId" => {
                        obj.subnet_id = Some(StringDeserializer::deserialize("subnetId", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AssociateTransitGatewayMulticastDomainRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The IDs of the subnets to associate with the transit gateway multicast domain.</p>
    pub subnet_ids: Option<Vec<String>>,
    /// <p>The ID of the transit gateway attachment to associate with the transit gateway multicast domain.</p>
    pub transit_gateway_attachment_id: Option<String>,
    /// <p>The ID of the transit gateway multicast domain.</p>
    pub transit_gateway_multicast_domain_id: Option<String>,
}

/// Serialize `AssociateTransitGatewayMulticastDomainRequest` contents to a `SignedRequest`.
struct AssociateTransitGatewayMulticastDomainRequestSerializer;
impl AssociateTransitGatewayMulticastDomainRequestSerializer {
    fn serialize(
        params: &mut Params,
        name: &str,
        obj: &AssociateTransitGatewayMulticastDomainRequest,
    ) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.subnet_ids {
            TransitGatewaySubnetIdListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "SubnetIds"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.transit_gateway_attachment_id {
            params.put(
                &format!("{}{}", prefix, "TransitGatewayAttachmentId"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.transit_gateway_multicast_domain_id {
            params.put(
                &format!("{}{}", prefix, "TransitGatewayMulticastDomainId"),
                &field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AssociateTransitGatewayMulticastDomainResult {
    /// <p>Information about the transit gateway multicast domain associations.</p>
    pub associations: Option<TransitGatewayMulticastDomainAssociations>,
}

#[allow(dead_code)]
struct AssociateTransitGatewayMulticastDomainResultDeserializer;
impl AssociateTransitGatewayMulticastDomainResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AssociateTransitGatewayMulticastDomainResult, XmlParseError> {
        deserialize_elements::<_, AssociateTransitGatewayMulticastDomainResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "associations" => {
                        obj.associations = Some(
                            TransitGatewayMulticastDomainAssociationsDeserializer::deserialize(
                                "associations",
                                stack,
                            )?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AssociateTransitGatewayRouteTableRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the attachment.</p>
    pub transit_gateway_attachment_id: String,
    /// <p>The ID of the transit gateway route table.</p>
    pub transit_gateway_route_table_id: String,
}

/// Serialize `AssociateTransitGatewayRouteTableRequest` contents to a `SignedRequest`.
struct AssociateTransitGatewayRouteTableRequestSerializer;
impl AssociateTransitGatewayRouteTableRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &AssociateTransitGatewayRouteTableRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "TransitGatewayAttachmentId"),
            &obj.transit_gateway_attachment_id,
        );
        params.put(
            &format!("{}{}", prefix, "TransitGatewayRouteTableId"),
            &obj.transit_gateway_route_table_id,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AssociateTransitGatewayRouteTableResult {
    /// <p>The ID of the association.</p>
    pub association: Option<TransitGatewayAssociation>,
}

#[allow(dead_code)]
struct AssociateTransitGatewayRouteTableResultDeserializer;
impl AssociateTransitGatewayRouteTableResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AssociateTransitGatewayRouteTableResult, XmlParseError> {
        deserialize_elements::<_, AssociateTransitGatewayRouteTableResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "association" => {
                        obj.association = Some(TransitGatewayAssociationDeserializer::deserialize(
                            "association",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AssociateTrunkInterfaceRequest {
    /// <p>The ID of the branch network interface.</p>
    pub branch_interface_id: String,
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure Idempotency</a>.</p>
    pub client_token: Option<String>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The application key. This applies to the GRE protocol.</p>
    pub gre_key: Option<i64>,
    /// <p>The ID of the trunk network interface.</p>
    pub trunk_interface_id: String,
    /// <p>The ID of the VLAN. This applies to the VLAN protocol.</p>
    pub vlan_id: Option<i64>,
}

/// Serialize `AssociateTrunkInterfaceRequest` contents to a `SignedRequest`.
struct AssociateTrunkInterfaceRequestSerializer;
impl AssociateTrunkInterfaceRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &AssociateTrunkInterfaceRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "BranchInterfaceId"),
            &obj.branch_interface_id,
        );
        if let Some(ref field_value) = obj.client_token {
            params.put(&format!("{}{}", prefix, "ClientToken"), &field_value);
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.gre_key {
            params.put(&format!("{}{}", prefix, "GreKey"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "TrunkInterfaceId"),
            &obj.trunk_interface_id,
        );
        if let Some(ref field_value) = obj.vlan_id {
            params.put(&format!("{}{}", prefix, "VlanId"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AssociateTrunkInterfaceResult {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure Idempotency</a>.</p>
    pub client_token: Option<String>,
    /// <p>Information about the association between the trunk network interface and branch network interface.</p>
    pub interface_association: Option<TrunkInterfaceAssociation>,
}

#[allow(dead_code)]
struct AssociateTrunkInterfaceResultDeserializer;
impl AssociateTrunkInterfaceResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AssociateTrunkInterfaceResult, XmlParseError> {
        deserialize_elements::<_, AssociateTrunkInterfaceResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "clientToken" => {
                        obj.client_token =
                            Some(StringDeserializer::deserialize("clientToken", stack)?);
                    }
                    "interfaceAssociation" => {
                        obj.interface_association =
                            Some(TrunkInterfaceAssociationDeserializer::deserialize(
                                "interfaceAssociation",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AssociateVpcCidrBlockRequest {
    /// <p>Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC. You cannot specify the range of IPv6 addresses, or the size of the CIDR block.</p>
    pub amazon_provided_ipv_6_cidr_block: Option<bool>,
    /// <p>An IPv4 CIDR block to associate with the VPC.</p>
    pub cidr_block: Option<String>,
    /// <p>An IPv6 CIDR block from the IPv6 address pool. You must also specify <code>Ipv6Pool</code> in the request.</p> <p>To let Amazon choose the IPv6 CIDR block for you, omit this parameter.</p>
    pub ipv_6_cidr_block: Option<String>,
    /// <p>The name of the location from which we advertise the IPV6 CIDR block. Use this parameter to limit the CIDR block to this location.</p> <p> You must set <code>AmazonProvidedIpv6CidrBlock</code> to <code>true</code> to use this parameter.</p> <p> You can have one IPv6 CIDR block association per network border group.</p>
    pub ipv_6_cidr_block_network_border_group: Option<String>,
    /// <p>The ID of an IPv6 address pool from which to allocate the IPv6 CIDR block.</p>
    pub ipv_6_pool: Option<String>,
    /// <p>The ID of the VPC.</p>
    pub vpc_id: String,
}

/// Serialize `AssociateVpcCidrBlockRequest` contents to a `SignedRequest`.
struct AssociateVpcCidrBlockRequestSerializer;
impl AssociateVpcCidrBlockRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &AssociateVpcCidrBlockRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.amazon_provided_ipv_6_cidr_block {
            params.put(
                &format!("{}{}", prefix, "AmazonProvidedIpv6CidrBlock"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.cidr_block {
            params.put(&format!("{}{}", prefix, "CidrBlock"), &field_value);
        }
        if let Some(ref field_value) = obj.ipv_6_cidr_block {
            params.put(&format!("{}{}", prefix, "Ipv6CidrBlock"), &field_value);
        }
        if let Some(ref field_value) = obj.ipv_6_cidr_block_network_border_group {
            params.put(
                &format!("{}{}", prefix, "Ipv6CidrBlockNetworkBorderGroup"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.ipv_6_pool {
            params.put(&format!("{}{}", prefix, "Ipv6Pool"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "VpcId"), &obj.vpc_id);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AssociateVpcCidrBlockResult {
    /// <p>Information about the IPv4 CIDR block association.</p>
    pub cidr_block_association: Option<VpcCidrBlockAssociation>,
    /// <p>Information about the IPv6 CIDR block association.</p>
    pub ipv_6_cidr_block_association: Option<VpcIpv6CidrBlockAssociation>,
    /// <p>The ID of the VPC.</p>
    pub vpc_id: Option<String>,
}

#[allow(dead_code)]
struct AssociateVpcCidrBlockResultDeserializer;
impl AssociateVpcCidrBlockResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AssociateVpcCidrBlockResult, XmlParseError> {
        deserialize_elements::<_, AssociateVpcCidrBlockResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "cidrBlockAssociation" => {
                        obj.cidr_block_association =
                            Some(VpcCidrBlockAssociationDeserializer::deserialize(
                                "cidrBlockAssociation",
                                stack,
                            )?);
                    }
                    "ipv6CidrBlockAssociation" => {
                        obj.ipv_6_cidr_block_association =
                            Some(VpcIpv6CidrBlockAssociationDeserializer::deserialize(
                                "ipv6CidrBlockAssociation",
                                stack,
                            )?);
                    }
                    "vpcId" => {
                        obj.vpc_id = Some(StringDeserializer::deserialize("vpcId", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Information about the associated IAM roles.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AssociatedRole {
    /// <p>The ARN of the associated IAM role.</p>
    pub associated_role_arn: Option<String>,
    /// <p>The name of the Amazon S3 bucket in which the Amazon S3 object is stored.</p>
    pub certificate_s3_bucket_name: Option<String>,
    /// <p>The key of the Amazon S3 object ey where the certificate, certificate chain, and encrypted private key bundle is stored. The object key is formated as follows: <code>role_arn</code>/<code>certificate_arn</code>. </p>
    pub certificate_s3_object_key: Option<String>,
    /// <p>The ID of the KMS customer master key (CMK) used to encrypt the private key.</p>
    pub encryption_kms_key_id: Option<String>,
}

#[allow(dead_code)]
struct AssociatedRoleDeserializer;
impl AssociatedRoleDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AssociatedRole, XmlParseError> {
        deserialize_elements::<_, AssociatedRole, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "associatedRoleArn" => {
                    obj.associated_role_arn = Some(ResourceArnDeserializer::deserialize(
                        "associatedRoleArn",
                        stack,
                    )?);
                }
                "certificateS3BucketName" => {
                    obj.certificate_s3_bucket_name = Some(StringDeserializer::deserialize(
                        "certificateS3BucketName",
                        stack,
                    )?);
                }
                "certificateS3ObjectKey" => {
                    obj.certificate_s3_object_key = Some(StringDeserializer::deserialize(
                        "certificateS3ObjectKey",
                        stack,
                    )?);
                }
                "encryptionKmsKeyId" => {
                    obj.encryption_kms_key_id = Some(StringDeserializer::deserialize(
                        "encryptionKmsKeyId",
                        stack,
                    )?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct AssociatedRolesListDeserializer;
impl AssociatedRolesListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<AssociatedRole>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "item" {
                obj.push(AssociatedRoleDeserializer::deserialize("item", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Describes a target network that is associated with a Client VPN endpoint. A target network is a subnet in a VPC.</p>
#[derive(Clone, Debug, Default, PartialEq)]
pub struct AssociatedTargetNetwork {
    /// <p>The ID of the subnet.</p>
    pub network_id: Option<String>,
    /// <p>The target network type.</p>
    pub network_type: Option<String>,
}

/// Serialize `AssociationIdList` contents to a `SignedRequest`.
struct AssociationIdListSerializer;
impl AssociationIdListSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<String>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.{}", name, index + 1);
            params.put(&key, &obj);
        }
    }
}

/// <p>Describes the state of a target network association.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AssociationStatus {
    /// <p>The state of the target network association.</p>
    pub code: Option<String>,
    /// <p>A message about the status of the target network association, if applicable.</p>
    pub message: Option<String>,
}

#[allow(dead_code)]
struct AssociationStatusDeserializer;
impl AssociationStatusDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AssociationStatus, XmlParseError> {
        deserialize_elements::<_, AssociationStatus, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "code" => {
                    obj.code = Some(AssociationStatusCodeDeserializer::deserialize(
                        "code", stack,
                    )?);
                }
                "message" => {
                    obj.message = Some(StringDeserializer::deserialize("message", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct AssociationStatusCodeDeserializer;
impl AssociationStatusCodeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p>Describes integration options for Amazon Athena.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AthenaIntegration {
    /// <p>The location in Amazon S3 to store the generated CloudFormation template.</p>
    pub integration_result_s3_destination_arn: String,
    /// <p>The end date for the partition.</p>
    pub partition_end_date: Option<String>,
    /// <p>The schedule for adding new partitions to the table.</p>
    pub partition_load_frequency: String,
    /// <p>The start date for the partition.</p>
    pub partition_start_date: Option<String>,
}

/// Serialize `AthenaIntegration` contents to a `SignedRequest`.
struct AthenaIntegrationSerializer;
impl AthenaIntegrationSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &AthenaIntegration) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "IntegrationResultS3DestinationArn"),
            &obj.integration_result_s3_destination_arn,
        );
        if let Some(ref field_value) = obj.partition_end_date {
            params.put(&format!("{}{}", prefix, "PartitionEndDate"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "PartitionLoadFrequency"),
            &obj.partition_load_frequency,
        );
        if let Some(ref field_value) = obj.partition_start_date {
            params.put(&format!("{}{}", prefix, "PartitionStartDate"), &field_value);
        }
    }
}

/// Serialize `AthenaIntegrationsSet` contents to a `SignedRequest`.
struct AthenaIntegrationsSetSerializer;
impl AthenaIntegrationsSetSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<AthenaIntegration>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.{}", name, index + 1);
            AthenaIntegrationSerializer::serialize(params, &key, obj);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AttachClassicLinkVpcRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of one or more of the VPC's security groups. You cannot specify security groups from a different VPC.</p>
    pub groups: Vec<String>,
    /// <p>The ID of an EC2-Classic instance to link to the ClassicLink-enabled VPC.</p>
    pub instance_id: String,
    /// <p>The ID of a ClassicLink-enabled VPC.</p>
    pub vpc_id: String,
}

/// Serialize `AttachClassicLinkVpcRequest` contents to a `SignedRequest`.
struct AttachClassicLinkVpcRequestSerializer;
impl AttachClassicLinkVpcRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &AttachClassicLinkVpcRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        GroupIdStringListSerializer::serialize(
            params,
            &format!("{}{}", prefix, "SecurityGroupId"),
            &obj.groups,
        );
        params.put(&format!("{}{}", prefix, "InstanceId"), &obj.instance_id);
        params.put(&format!("{}{}", prefix, "VpcId"), &obj.vpc_id);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AttachClassicLinkVpcResult {
    /// <p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>
    pub return_: Option<bool>,
}

#[allow(dead_code)]
struct AttachClassicLinkVpcResultDeserializer;
impl AttachClassicLinkVpcResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AttachClassicLinkVpcResult, XmlParseError> {
        deserialize_elements::<_, AttachClassicLinkVpcResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "return" => {
                        obj.return_ = Some(BooleanDeserializer::deserialize("return", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AttachInternetGatewayRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the internet gateway.</p>
    pub internet_gateway_id: String,
    /// <p>The ID of the VPC.</p>
    pub vpc_id: String,
}

/// Serialize `AttachInternetGatewayRequest` contents to a `SignedRequest`.
struct AttachInternetGatewayRequestSerializer;
impl AttachInternetGatewayRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &AttachInternetGatewayRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "InternetGatewayId"),
            &obj.internet_gateway_id,
        );
        params.put(&format!("{}{}", prefix, "VpcId"), &obj.vpc_id);
    }
}

/// <p>Contains the parameters for AttachNetworkInterface.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AttachNetworkInterfaceRequest {
    /// <p>The index of the device for the network interface attachment.</p>
    pub device_index: i64,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the instance.</p>
    pub instance_id: String,
    /// <p>The index of the network card. Some instance types support multiple network cards. The primary network interface must be assigned to network card index 0. The default is network card index 0.</p>
    pub network_card_index: Option<i64>,
    /// <p>The ID of the network interface.</p>
    pub network_interface_id: String,
}

/// Serialize `AttachNetworkInterfaceRequest` contents to a `SignedRequest`.
struct AttachNetworkInterfaceRequestSerializer;
impl AttachNetworkInterfaceRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &AttachNetworkInterfaceRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "DeviceIndex"), &obj.device_index);
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "InstanceId"), &obj.instance_id);
        if let Some(ref field_value) = obj.network_card_index {
            params.put(&format!("{}{}", prefix, "NetworkCardIndex"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "NetworkInterfaceId"),
            &obj.network_interface_id,
        );
    }
}

/// <p>Contains the output of AttachNetworkInterface.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AttachNetworkInterfaceResult {
    /// <p>The ID of the network interface attachment.</p>
    pub attachment_id: Option<String>,
    /// <p>The index of the network card.</p>
    pub network_card_index: Option<i64>,
}

#[allow(dead_code)]
struct AttachNetworkInterfaceResultDeserializer;
impl AttachNetworkInterfaceResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AttachNetworkInterfaceResult, XmlParseError> {
        deserialize_elements::<_, AttachNetworkInterfaceResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "attachmentId" => {
                        obj.attachment_id =
                            Some(StringDeserializer::deserialize("attachmentId", stack)?);
                    }
                    "networkCardIndex" => {
                        obj.network_card_index =
                            Some(IntegerDeserializer::deserialize("networkCardIndex", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AttachVolumeRequest {
    /// <p>The device name (for example, <code>/dev/sdh</code> or <code>xvdh</code>).</p>
    pub device: String,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the instance.</p>
    pub instance_id: String,
    /// <p>The ID of the EBS volume. The volume and instance must be within the same Availability Zone.</p>
    pub volume_id: String,
}

/// Serialize `AttachVolumeRequest` contents to a `SignedRequest`.
struct AttachVolumeRequestSerializer;
impl AttachVolumeRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &AttachVolumeRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "Device"), &obj.device);
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "InstanceId"), &obj.instance_id);
        params.put(&format!("{}{}", prefix, "VolumeId"), &obj.volume_id);
    }
}

/// <p>Contains the parameters for AttachVpnGateway.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AttachVpnGatewayRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the VPC.</p>
    pub vpc_id: String,
    /// <p>The ID of the virtual private gateway.</p>
    pub vpn_gateway_id: String,
}

/// Serialize `AttachVpnGatewayRequest` contents to a `SignedRequest`.
struct AttachVpnGatewayRequestSerializer;
impl AttachVpnGatewayRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &AttachVpnGatewayRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "VpcId"), &obj.vpc_id);
        params.put(
            &format!("{}{}", prefix, "VpnGatewayId"),
            &obj.vpn_gateway_id,
        );
    }
}

/// <p>Contains the output of AttachVpnGateway.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AttachVpnGatewayResult {
    /// <p>Information about the attachment.</p>
    pub vpc_attachment: Option<VpcAttachment>,
}

#[allow(dead_code)]
struct AttachVpnGatewayResultDeserializer;
impl AttachVpnGatewayResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AttachVpnGatewayResult, XmlParseError> {
        deserialize_elements::<_, AttachVpnGatewayResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "attachment" => {
                    obj.vpc_attachment =
                        Some(VpcAttachmentDeserializer::deserialize("attachment", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct AttachmentStatusDeserializer;
impl AttachmentStatusDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p>Describes a value for a resource attribute that is a Boolean value.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AttributeBooleanValue {
    /// <p>The attribute value. The valid values are <code>true</code> or <code>false</code>.</p>
    pub value: Option<bool>,
}

#[allow(dead_code)]
struct AttributeBooleanValueDeserializer;
impl AttributeBooleanValueDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AttributeBooleanValue, XmlParseError> {
        deserialize_elements::<_, AttributeBooleanValue, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "value" => {
                    obj.value = Some(BooleanDeserializer::deserialize("value", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}

/// Serialize `AttributeBooleanValue` contents to a `SignedRequest`.
struct AttributeBooleanValueSerializer;
impl AttributeBooleanValueSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &AttributeBooleanValue) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.value {
            params.put(&format!("{}{}", prefix, "Value"), &field_value);
        }
    }
}

/// <p>Describes a value for a resource attribute that is a String.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AttributeValue {
    /// <p>The attribute value. The value is case-sensitive.</p>
    pub value: Option<String>,
}

#[allow(dead_code)]
struct AttributeValueDeserializer;
impl AttributeValueDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AttributeValue, XmlParseError> {
        deserialize_elements::<_, AttributeValue, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "value" => {
                    obj.value = Some(StringDeserializer::deserialize("value", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}

/// Serialize `AttributeValue` contents to a `SignedRequest`.
struct AttributeValueSerializer;
impl AttributeValueSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &AttributeValue) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.value {
            params.put(&format!("{}{}", prefix, "Value"), &field_value);
        }
    }
}

/// <p>Information about an authorization rule.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AuthorizationRule {
    /// <p>Indicates whether the authorization rule grants access to all clients.</p>
    pub access_all: Option<bool>,
    /// <p>The ID of the Client VPN endpoint with which the authorization rule is associated.</p>
    pub client_vpn_endpoint_id: Option<String>,
    /// <p>A brief description of the authorization rule.</p>
    pub description: Option<String>,
    /// <p>The IPv4 address range, in CIDR notation, of the network to which the authorization rule applies.</p>
    pub destination_cidr: Option<String>,
    /// <p>The ID of the Active Directory group to which the authorization rule grants access.</p>
    pub group_id: Option<String>,
    /// <p>The current state of the authorization rule.</p>
    pub status: Option<ClientVpnAuthorizationRuleStatus>,
}

#[allow(dead_code)]
struct AuthorizationRuleDeserializer;
impl AuthorizationRuleDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AuthorizationRule, XmlParseError> {
        deserialize_elements::<_, AuthorizationRule, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "accessAll" => {
                    obj.access_all = Some(BooleanDeserializer::deserialize("accessAll", stack)?);
                }
                "clientVpnEndpointId" => {
                    obj.client_vpn_endpoint_id = Some(StringDeserializer::deserialize(
                        "clientVpnEndpointId",
                        stack,
                    )?);
                }
                "description" => {
                    obj.description = Some(StringDeserializer::deserialize("description", stack)?);
                }
                "destinationCidr" => {
                    obj.destination_cidr =
                        Some(StringDeserializer::deserialize("destinationCidr", stack)?);
                }
                "groupId" => {
                    obj.group_id = Some(StringDeserializer::deserialize("groupId", stack)?);
                }
                "status" => {
                    obj.status = Some(ClientVpnAuthorizationRuleStatusDeserializer::deserialize(
                        "status", stack,
                    )?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct AuthorizationRuleSetDeserializer;
impl AuthorizationRuleSetDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<AuthorizationRule>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "item" {
                obj.push(AuthorizationRuleDeserializer::deserialize("item", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AuthorizeClientVpnIngressRequest {
    /// <p>The ID of the group to grant access to, for example, the Active Directory group or identity provider (IdP) group. Required if <code>AuthorizeAllGroups</code> is <code>false</code> or not specified.</p>
    pub access_group_id: Option<String>,
    /// <p>Indicates whether to grant access to all clients. Specify <code>true</code> to grant all clients who successfully establish a VPN connection access to the network. Must be set to <code>true</code> if <code>AccessGroupId</code> is not specified.</p>
    pub authorize_all_groups: Option<bool>,
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure Idempotency</a>.</p>
    pub client_token: Option<String>,
    /// <p>The ID of the Client VPN endpoint.</p>
    pub client_vpn_endpoint_id: String,
    /// <p>A brief description of the authorization rule.</p>
    pub description: Option<String>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The IPv4 address range, in CIDR notation, of the network for which access is being authorized.</p>
    pub target_network_cidr: String,
}

/// Serialize `AuthorizeClientVpnIngressRequest` contents to a `SignedRequest`.
struct AuthorizeClientVpnIngressRequestSerializer;
impl AuthorizeClientVpnIngressRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &AuthorizeClientVpnIngressRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.access_group_id {
            params.put(&format!("{}{}", prefix, "AccessGroupId"), &field_value);
        }
        if let Some(ref field_value) = obj.authorize_all_groups {
            params.put(&format!("{}{}", prefix, "AuthorizeAllGroups"), &field_value);
        }
        if let Some(ref field_value) = obj.client_token {
            params.put(&format!("{}{}", prefix, "ClientToken"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "ClientVpnEndpointId"),
            &obj.client_vpn_endpoint_id,
        );
        if let Some(ref field_value) = obj.description {
            params.put(&format!("{}{}", prefix, "Description"), &field_value);
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "TargetNetworkCidr"),
            &obj.target_network_cidr,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AuthorizeClientVpnIngressResult {
    /// <p>The current state of the authorization rule.</p>
    pub status: Option<ClientVpnAuthorizationRuleStatus>,
}

#[allow(dead_code)]
struct AuthorizeClientVpnIngressResultDeserializer;
impl AuthorizeClientVpnIngressResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AuthorizeClientVpnIngressResult, XmlParseError> {
        deserialize_elements::<_, AuthorizeClientVpnIngressResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "status" => {
                        obj.status =
                            Some(ClientVpnAuthorizationRuleStatusDeserializer::deserialize(
                                "status", stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AuthorizeSecurityGroupEgressRequest {
    /// <p>Not supported. Use a set of IP permissions to specify the CIDR.</p>
    pub cidr_ip: Option<String>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>Not supported. Use a set of IP permissions to specify the port.</p>
    pub from_port: Option<i64>,
    /// <p>The ID of the security group.</p>
    pub group_id: String,
    /// <p>The sets of IP permissions. You can't specify a destination security group and a CIDR IP address range in the same set of permissions.</p>
    pub ip_permissions: Option<Vec<IpPermission>>,
    /// <p>Not supported. Use a set of IP permissions to specify the protocol name or number.</p>
    pub ip_protocol: Option<String>,
    /// <p>Not supported. Use a set of IP permissions to specify a destination security group.</p>
    pub source_security_group_name: Option<String>,
    /// <p>Not supported. Use a set of IP permissions to specify a destination security group.</p>
    pub source_security_group_owner_id: Option<String>,
    /// <p>Not supported. Use a set of IP permissions to specify the port.</p>
    pub to_port: Option<i64>,
}

/// Serialize `AuthorizeSecurityGroupEgressRequest` contents to a `SignedRequest`.
struct AuthorizeSecurityGroupEgressRequestSerializer;
impl AuthorizeSecurityGroupEgressRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &AuthorizeSecurityGroupEgressRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.cidr_ip {
            params.put(&format!("{}{}", prefix, "CidrIp"), &field_value);
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.from_port {
            params.put(&format!("{}{}", prefix, "FromPort"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "GroupId"), &obj.group_id);
        if let Some(ref field_value) = obj.ip_permissions {
            IpPermissionListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "IpPermissions"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.ip_protocol {
            params.put(&format!("{}{}", prefix, "IpProtocol"), &field_value);
        }
        if let Some(ref field_value) = obj.source_security_group_name {
            params.put(
                &format!("{}{}", prefix, "SourceSecurityGroupName"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.source_security_group_owner_id {
            params.put(
                &format!("{}{}", prefix, "SourceSecurityGroupOwnerId"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.to_port {
            params.put(&format!("{}{}", prefix, "ToPort"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AuthorizeSecurityGroupIngressRequest {
    /// <p>The IPv4 address range, in CIDR format. You can't specify this parameter when specifying a source security group. To specify an IPv6 address range, use a set of IP permissions.</p> <p>Alternatively, use a set of IP permissions to specify multiple rules and a description for the rule.</p>
    pub cidr_ip: Option<String>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The start of port range for the TCP and UDP protocols, or an ICMP type number. For the ICMP type number, use <code>-1</code> to specify all types. If you specify all ICMP types, you must specify all codes.</p> <p>Alternatively, use a set of IP permissions to specify multiple rules and a description for the rule.</p>
    pub from_port: Option<i64>,
    /// <p>The ID of the security group. You must specify either the security group ID or the security group name in the request. For security groups in a nondefault VPC, you must specify the security group ID.</p>
    pub group_id: Option<String>,
    /// <p>[EC2-Classic, default VPC] The name of the security group. You must specify either the security group ID or the security group name in the request.</p>
    pub group_name: Option<String>,
    /// <p>The sets of IP permissions.</p>
    pub ip_permissions: Option<Vec<IpPermission>>,
    /// <p>The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>) or number (see <a href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a>). To specify <code>icmpv6</code>, use a set of IP permissions.</p> <p>[VPC only] Use <code>-1</code> to specify all protocols. If you specify <code>-1</code> or a protocol other than <code>tcp</code>, <code>udp</code>, or <code>icmp</code>, traffic on all ports is allowed, regardless of any ports you specify.</p> <p>Alternatively, use a set of IP permissions to specify multiple rules and a description for the rule.</p>
    pub ip_protocol: Option<String>,
    /// <p>[EC2-Classic, default VPC] The name of the source security group. You can't specify this parameter in combination with the following parameters: the CIDR IP address range, the start of the port range, the IP protocol, and the end of the port range. Creates rules that grant full ICMP, UDP, and TCP access. To create a rule with a specific IP protocol and port range, use a set of IP permissions instead. For EC2-VPC, the source security group must be in the same VPC.</p>
    pub source_security_group_name: Option<String>,
    /// <p>[nondefault VPC] The AWS account ID for the source security group, if the source security group is in a different account. You can't specify this parameter in combination with the following parameters: the CIDR IP address range, the IP protocol, the start of the port range, and the end of the port range. Creates rules that grant full ICMP, UDP, and TCP access. To create a rule with a specific IP protocol and port range, use a set of IP permissions instead.</p>
    pub source_security_group_owner_id: Option<String>,
    /// <p>The end of port range for the TCP and UDP protocols, or an ICMP code number. For the ICMP code number, use <code>-1</code> to specify all codes. If you specify all ICMP types, you must specify all codes.</p> <p>Alternatively, use a set of IP permissions to specify multiple rules and a description for the rule.</p>
    pub to_port: Option<i64>,
}

/// Serialize `AuthorizeSecurityGroupIngressRequest` contents to a `SignedRequest`.
struct AuthorizeSecurityGroupIngressRequestSerializer;
impl AuthorizeSecurityGroupIngressRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &AuthorizeSecurityGroupIngressRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.cidr_ip {
            params.put(&format!("{}{}", prefix, "CidrIp"), &field_value);
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.from_port {
            params.put(&format!("{}{}", prefix, "FromPort"), &field_value);
        }
        if let Some(ref field_value) = obj.group_id {
            params.put(&format!("{}{}", prefix, "GroupId"), &field_value);
        }
        if let Some(ref field_value) = obj.group_name {
            params.put(&format!("{}{}", prefix, "GroupName"), &field_value);
        }
        if let Some(ref field_value) = obj.ip_permissions {
            IpPermissionListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "IpPermissions"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.ip_protocol {
            params.put(&format!("{}{}", prefix, "IpProtocol"), &field_value);
        }
        if let Some(ref field_value) = obj.source_security_group_name {
            params.put(
                &format!("{}{}", prefix, "SourceSecurityGroupName"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.source_security_group_owner_id {
            params.put(
                &format!("{}{}", prefix, "SourceSecurityGroupOwnerId"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.to_port {
            params.put(&format!("{}{}", prefix, "ToPort"), &field_value);
        }
    }
}

#[allow(dead_code)]
struct AutoAcceptSharedAssociationsValueDeserializer;
impl AutoAcceptSharedAssociationsValueDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct AutoAcceptSharedAttachmentsValueDeserializer;
impl AutoAcceptSharedAttachmentsValueDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct AutoPlacementDeserializer;
impl AutoPlacementDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct AutoRecoveryFlagDeserializer;
impl AutoRecoveryFlagDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<bool, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, |s| Ok(bool::from_str(&s).unwrap()))
    }
}
/// <p>Describes Availability Zones, Local Zones, and Wavelength Zones.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AvailabilityZone {
    /// <p> For Availability Zones, this parameter has the same value as the Region name.</p> <p>For Local Zones, the name of the associated group, for example <code>us-west-2-lax-1</code>.</p> <p>For Wavelength Zones, the name of the associated group, for example <code>us-east-1-wl1-bos-wlz-1</code>.</p>
    pub group_name: Option<String>,
    /// <p>Any messages about the Availability Zone, Local Zone, or Wavelength Zone.</p>
    pub messages: Option<Vec<AvailabilityZoneMessage>>,
    /// <p>The name of the network border group.</p>
    pub network_border_group: Option<String>,
    /// <p>For Availability Zones, this parameter always has the value of <code>opt-in-not-required</code>.</p> <p>For Local Zones and Wavelength Zones, this parameter is the opt-in status. The possible values are <code>opted-in</code>, and <code>not-opted-in</code>.</p>
    pub opt_in_status: Option<String>,
    /// <p>The ID of the zone that handles some of the Local Zone or Wavelength Zone control plane operations, such as API calls.</p>
    pub parent_zone_id: Option<String>,
    /// <p>The name of the zone that handles some of the Local Zone or Wavelength Zone control plane operations, such as API calls.</p>
    pub parent_zone_name: Option<String>,
    /// <p>The name of the Region.</p>
    pub region_name: Option<String>,
    /// <p>The state of the Availability Zone, Local Zone, or Wavelength Zone.</p>
    pub state: Option<String>,
    /// <p>The ID of the Availability Zone, Local Zone, or Wavelength Zone.</p>
    pub zone_id: Option<String>,
    /// <p>The name of the Availability Zone, Local Zone, or Wavelength Zone.</p>
    pub zone_name: Option<String>,
    /// <p>The type of zone. The valid values are <code>availability-zone</code>, <code>local-zone</code>, and <code>wavelength-zone</code>.</p>
    pub zone_type: Option<String>,
}

#[allow(dead_code)]
struct AvailabilityZoneDeserializer;
impl AvailabilityZoneDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AvailabilityZone, XmlParseError> {
        deserialize_elements::<_, AvailabilityZone, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "groupName" => {
                    obj.group_name = Some(StringDeserializer::deserialize("groupName", stack)?);
                }
                "messageSet" => {
                    obj.messages.get_or_insert(vec![]).extend(
                        AvailabilityZoneMessageListDeserializer::deserialize("messageSet", stack)?,
                    );
                }
                "networkBorderGroup" => {
                    obj.network_border_group = Some(StringDeserializer::deserialize(
                        "networkBorderGroup",
                        stack,
                    )?);
                }
                "optInStatus" => {
                    obj.opt_in_status = Some(AvailabilityZoneOptInStatusDeserializer::deserialize(
                        "optInStatus",
                        stack,
                    )?);
                }
                "parentZoneId" => {
                    obj.parent_zone_id =
                        Some(StringDeserializer::deserialize("parentZoneId", stack)?);
                }
                "parentZoneName" => {
                    obj.parent_zone_name =
                        Some(StringDeserializer::deserialize("parentZoneName", stack)?);
                }
                "regionName" => {
                    obj.region_name = Some(StringDeserializer::deserialize("regionName", stack)?);
                }
                "zoneState" => {
                    obj.state = Some(AvailabilityZoneStateDeserializer::deserialize(
                        "zoneState",
                        stack,
                    )?);
                }
                "zoneId" => {
                    obj.zone_id = Some(StringDeserializer::deserialize("zoneId", stack)?);
                }
                "zoneName" => {
                    obj.zone_name = Some(StringDeserializer::deserialize("zoneName", stack)?);
                }
                "zoneType" => {
                    obj.zone_type = Some(StringDeserializer::deserialize("zoneType", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct AvailabilityZoneListDeserializer;
impl AvailabilityZoneListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<AvailabilityZone>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "item" {
                obj.push(AvailabilityZoneDeserializer::deserialize("item", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Describes a message about an Availability Zone, Local Zone, or Wavelength Zone.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AvailabilityZoneMessage {
    /// <p>The message about the Availability Zone, Local Zone, or Wavelength Zone.</p>
    pub message: Option<String>,
}

#[allow(dead_code)]
struct AvailabilityZoneMessageDeserializer;
impl AvailabilityZoneMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AvailabilityZoneMessage, XmlParseError> {
        deserialize_elements::<_, AvailabilityZoneMessage, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "message" => {
                        obj.message = Some(StringDeserializer::deserialize("message", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct AvailabilityZoneMessageListDeserializer;
impl AvailabilityZoneMessageListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<AvailabilityZoneMessage>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "item" {
                obj.push(AvailabilityZoneMessageDeserializer::deserialize(
                    "item", stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct AvailabilityZoneOptInStatusDeserializer;
impl AvailabilityZoneOptInStatusDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct AvailabilityZoneStateDeserializer;
impl AvailabilityZoneStateDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}

/// Serialize `AvailabilityZoneStringList` contents to a `SignedRequest`.
struct AvailabilityZoneStringListSerializer;
impl AvailabilityZoneStringListSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<String>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.{}", name, index + 1);
            params.put(&key, &obj);
        }
    }
}

/// <p>The capacity information for instances that can be launched onto the Dedicated Host. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AvailableCapacity {
    /// <p>The number of instances that can be launched onto the Dedicated Host depending on the host's available capacity. For Dedicated Hosts that support multiple instance types, this parameter represents the number of instances for each instance size that is supported on the host.</p>
    pub available_instance_capacity: Option<Vec<InstanceCapacity>>,
    /// <p>The number of vCPUs available for launching instances onto the Dedicated Host.</p>
    pub available_v_cpus: Option<i64>,
}

#[allow(dead_code)]
struct AvailableCapacityDeserializer;
impl AvailableCapacityDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AvailableCapacity, XmlParseError> {
        deserialize_elements::<_, AvailableCapacity, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "availableInstanceCapacity" => {
                    obj.available_instance_capacity
                        .get_or_insert(vec![])
                        .extend(AvailableInstanceCapacityListDeserializer::deserialize(
                            "availableInstanceCapacity",
                            stack,
                        )?);
                }
                "availableVCpus" => {
                    obj.available_v_cpus =
                        Some(IntegerDeserializer::deserialize("availableVCpus", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct AvailableInstanceCapacityListDeserializer;
impl AvailableInstanceCapacityListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<InstanceCapacity>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "item" {
                obj.push(InstanceCapacityDeserializer::deserialize("item", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct BareMetalFlagDeserializer;
impl BareMetalFlagDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<bool, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, |s| Ok(bool::from_str(&s).unwrap()))
    }
}
#[allow(dead_code)]
struct BaselineBandwidthInMbpsDeserializer;
impl BaselineBandwidthInMbpsDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<i64, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, |s| Ok(i64::from_str(&s).unwrap()))
    }
}
#[allow(dead_code)]
struct BaselineIopsDeserializer;
impl BaselineIopsDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<i64, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, |s| Ok(i64::from_str(&s).unwrap()))
    }
}
#[allow(dead_code)]
struct BaselineThroughputInMBpsDeserializer;
impl BaselineThroughputInMBpsDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<f64, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, |s| Ok(f64::from_str(&s).unwrap()))
    }
}
#[allow(dead_code)]
struct BatchStateDeserializer;
impl BatchStateDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct BgpStatusDeserializer;
impl BgpStatusDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}

/// Serialize `BillingProductList` contents to a `SignedRequest`.
struct BillingProductListSerializer;
impl BillingProductListSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<String>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.{}", name, index + 1);
            params.put(&key, &obj);
        }
    }
}

#[allow(dead_code)]
struct BlobDeserializer;
impl BlobDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<bytes::Bytes, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, |s| Ok(s.into()))
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct BlobAttributeValue {
    pub value: Option<bytes::Bytes>,
}

/// Serialize `BlobAttributeValue` contents to a `SignedRequest`.
struct BlobAttributeValueSerializer;
impl BlobAttributeValueSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &BlobAttributeValue) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.value {
            params.put(
                &format!("{}{}", prefix, "Value"),
                ::std::str::from_utf8(&field_value).unwrap(),
            );
        }
    }
}

/// <p>Describes a block device mapping.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct BlockDeviceMapping {
    /// <p>The device name (for example, <code>/dev/sdh</code> or <code>xvdh</code>).</p>
    pub device_name: Option<String>,
    /// <p>Parameters used to automatically set up EBS volumes when the instance is launched.</p>
    pub ebs: Option<EbsBlockDevice>,
    /// <p>To omit the device from the block device mapping, specify an empty string.</p>
    pub no_device: Option<String>,
    /// <p>The virtual device name (<code>ephemeral</code>N). Instance store volumes are numbered starting from 0. An instance type with 2 available instance store volumes can specify mappings for <code>ephemeral0</code> and <code>ephemeral1</code>. The number of available instance store volumes depends on the instance type. After you connect to the instance, you must mount the volume.</p> <p>NVMe instance store volumes are automatically enumerated and assigned a device name. Including them in your block device mapping has no effect.</p> <p>Constraints: For M3 instances, you must specify instance store volumes in the block device mapping for the instance. When you launch an M3 instance, we ignore any instance store volumes specified in the block device mapping for the AMI.</p>
    pub virtual_name: Option<String>,
}

#[allow(dead_code)]
struct BlockDeviceMappingDeserializer;
impl BlockDeviceMappingDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<BlockDeviceMapping, XmlParseError> {
        deserialize_elements::<_, BlockDeviceMapping, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "deviceName" => {
                    obj.device_name = Some(StringDeserializer::deserialize("deviceName", stack)?);
                }
                "ebs" => {
                    obj.ebs = Some(EbsBlockDeviceDeserializer::deserialize("ebs", stack)?);
                }
                "noDevice" => {
                    obj.no_device = Some(StringDeserializer::deserialize("noDevice", stack)?);
                }
                "virtualName" => {
                    obj.virtual_name = Some(StringDeserializer::deserialize("virtualName", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}

/// Serialize `BlockDeviceMapping` contents to a `SignedRequest`.
struct BlockDeviceMappingSerializer;
impl BlockDeviceMappingSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &BlockDeviceMapping) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.device_name {
            params.put(&format!("{}{}", prefix, "DeviceName"), &field_value);
        }
        if let Some(ref field_value) = obj.ebs {
            EbsBlockDeviceSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Ebs"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.no_device {
            params.put(&format!("{}{}", prefix, "NoDevice"), &field_value);
        }
        if let Some(ref field_value) = obj.virtual_name {
            params.put(&format!("{}{}", prefix, "VirtualName"), &field_value);
        }
    }
}

#[allow(dead_code)]
struct BlockDeviceMappingListDeserializer;
impl BlockDeviceMappingListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<BlockDeviceMapping>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "item" {
                obj.push(BlockDeviceMappingDeserializer::deserialize("item", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}

/// Serialize `BlockDeviceMappingList` contents to a `SignedRequest`.
struct BlockDeviceMappingListSerializer;
impl BlockDeviceMappingListSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<BlockDeviceMapping>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.{}", name, index + 1);
            BlockDeviceMappingSerializer::serialize(params, &key, obj);
        }
    }
}

/// Serialize `BlockDeviceMappingRequestList` contents to a `SignedRequest`.
struct BlockDeviceMappingRequestListSerializer;
impl BlockDeviceMappingRequestListSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<BlockDeviceMapping>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.{}", name, index + 1);
            BlockDeviceMappingSerializer::serialize(params, &key, obj);
        }
    }
}

#[allow(dead_code)]
struct BooleanDeserializer;
impl BooleanDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<bool, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, |s| Ok(bool::from_str(&s).unwrap()))
    }
}
#[allow(dead_code)]
struct BootModeTypeDeserializer;
impl BootModeTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct BootModeTypeListDeserializer;
impl BootModeTypeListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<String>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "item" {
                obj.push(BootModeTypeDeserializer::deserialize("item", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct BootModeValuesDeserializer;
impl BootModeValuesDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}

/// Serialize `BundleIdStringList` contents to a `SignedRequest`.
struct BundleIdStringListSerializer;
impl BundleIdStringListSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<String>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.{}", name, index + 1);
            params.put(&key, &obj);
        }
    }
}

/// <p>Contains the parameters for BundleInstance.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct BundleInstanceRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the instance to bundle.</p> <p>Type: String</p> <p>Default: None</p> <p>Required: Yes</p>
    pub instance_id: String,
    /// <p>The bucket in which to store the AMI. You can specify a bucket that you already own or a new bucket that Amazon EC2 creates on your behalf. If you specify a bucket that belongs to someone else, Amazon EC2 returns an error.</p>
    pub storage: Storage,
}

/// Serialize `BundleInstanceRequest` contents to a `SignedRequest`.
struct BundleInstanceRequestSerializer;
impl BundleInstanceRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &BundleInstanceRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "InstanceId"), &obj.instance_id);
        StorageSerializer::serialize(params, &format!("{}{}", prefix, "Storage"), &obj.storage);
    }
}

/// <p>Contains the output of BundleInstance.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct BundleInstanceResult {
    /// <p>Information about the bundle task.</p>
    pub bundle_task: Option<BundleTask>,
}

#[allow(dead_code)]
struct BundleInstanceResultDeserializer;
impl BundleInstanceResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<BundleInstanceResult, XmlParseError> {
        deserialize_elements::<_, BundleInstanceResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "bundleInstanceTask" => {
                    obj.bundle_task = Some(BundleTaskDeserializer::deserialize(
                        "bundleInstanceTask",
                        stack,
                    )?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>Describes a bundle task.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct BundleTask {
    /// <p>The ID of the bundle task.</p>
    pub bundle_id: Option<String>,
    /// <p>If the task fails, a description of the error.</p>
    pub bundle_task_error: Option<BundleTaskError>,
    /// <p>The ID of the instance associated with this bundle task.</p>
    pub instance_id: Option<String>,
    /// <p>The level of task completion, as a percent (for example, 20%).</p>
    pub progress: Option<String>,
    /// <p>The time this task started.</p>
    pub start_time: Option<String>,
    /// <p>The state of the task.</p>
    pub state: Option<String>,
    /// <p>The Amazon S3 storage locations.</p>
    pub storage: Option<Storage>,
    /// <p>The time of the most recent update for the task.</p>
    pub update_time: Option<String>,
}

#[allow(dead_code)]
struct BundleTaskDeserializer;
impl BundleTaskDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<BundleTask, XmlParseError> {
        deserialize_elements::<_, BundleTask, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "bundleId" => {
                    obj.bundle_id = Some(StringDeserializer::deserialize("bundleId", stack)?);
                }
                "error" => {
                    obj.bundle_task_error =
                        Some(BundleTaskErrorDeserializer::deserialize("error", stack)?);
                }
                "instanceId" => {
                    obj.instance_id = Some(StringDeserializer::deserialize("instanceId", stack)?);
                }
                "progress" => {
                    obj.progress = Some(StringDeserializer::deserialize("progress", stack)?);
                }
                "startTime" => {
                    obj.start_time = Some(DateTimeDeserializer::deserialize("startTime", stack)?);
                }
                "state" => {
                    obj.state = Some(BundleTaskStateDeserializer::deserialize("state", stack)?);
                }
                "storage" => {
                    obj.storage = Some(StorageDeserializer::deserialize("storage", stack)?);
                }
                "updateTime" => {
                    obj.update_time = Some(DateTimeDeserializer::deserialize("updateTime", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>Describes an error for <a>BundleInstance</a>.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct BundleTaskError {
    /// <p>The error code.</p>
    pub code: Option<String>,
    /// <p>The error message.</p>
    pub message: Option<String>,
}

#[allow(dead_code)]
struct BundleTaskErrorDeserializer;
impl BundleTaskErrorDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<BundleTaskError, XmlParseError> {
        deserialize_elements::<_, BundleTaskError, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "code" => {
                    obj.code = Some(StringDeserializer::deserialize("code", stack)?);
                }
                "message" => {
                    obj.message = Some(StringDeserializer::deserialize("message", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct BundleTaskListDeserializer;
impl BundleTaskListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<BundleTask>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "item" {
                obj.push(BundleTaskDeserializer::deserialize("item", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct BundleTaskStateDeserializer;
impl BundleTaskStateDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct BurstablePerformanceFlagDeserializer;
impl BurstablePerformanceFlagDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<bool, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, |s| Ok(bool::from_str(&s).unwrap()))
    }
}
/// <p>Information about an address range that is provisioned for use with your Amazon Web Services resources through bring your own IP addresses (BYOIP).</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ByoipCidr {
    /// <p>The address range, in CIDR notation.</p>
    pub cidr: Option<String>,
    /// <p>The description of the address range.</p>
    pub description: Option<String>,
    /// <p>The state of the address pool.</p>
    pub state: Option<String>,
    /// <p>Upon success, contains the ID of the address pool. Otherwise, contains an error message.</p>
    pub status_message: Option<String>,
}

#[allow(dead_code)]
struct ByoipCidrDeserializer;
impl ByoipCidrDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ByoipCidr, XmlParseError> {
        deserialize_elements::<_, ByoipCidr, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "cidr" => {
                    obj.cidr = Some(StringDeserializer::deserialize("cidr", stack)?);
                }
                "description" => {
                    obj.description = Some(StringDeserializer::deserialize("description", stack)?);
                }
                "state" => {
                    obj.state = Some(ByoipCidrStateDeserializer::deserialize("state", stack)?);
                }
                "statusMessage" => {
                    obj.status_message =
                        Some(StringDeserializer::deserialize("statusMessage", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct ByoipCidrSetDeserializer;
impl ByoipCidrSetDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<ByoipCidr>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "item" {
                obj.push(ByoipCidrDeserializer::deserialize("item", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct ByoipCidrStateDeserializer;
impl ByoipCidrStateDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct CancelBatchErrorCodeDeserializer;
impl CancelBatchErrorCodeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p>Contains the parameters for CancelBundleTask.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CancelBundleTaskRequest {
    /// <p>The ID of the bundle task.</p>
    pub bundle_id: String,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
}

/// Serialize `CancelBundleTaskRequest` contents to a `SignedRequest`.
struct CancelBundleTaskRequestSerializer;
impl CancelBundleTaskRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CancelBundleTaskRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "BundleId"), &obj.bundle_id);
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
    }
}

/// <p>Contains the output of CancelBundleTask.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CancelBundleTaskResult {
    /// <p>Information about the bundle task.</p>
    pub bundle_task: Option<BundleTask>,
}

#[allow(dead_code)]
struct CancelBundleTaskResultDeserializer;
impl CancelBundleTaskResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CancelBundleTaskResult, XmlParseError> {
        deserialize_elements::<_, CancelBundleTaskResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "bundleInstanceTask" => {
                    obj.bundle_task = Some(BundleTaskDeserializer::deserialize(
                        "bundleInstanceTask",
                        stack,
                    )?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CancelCapacityReservationRequest {
    /// <p>The ID of the Capacity Reservation to be cancelled.</p>
    pub capacity_reservation_id: String,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
}

/// Serialize `CancelCapacityReservationRequest` contents to a `SignedRequest`.
struct CancelCapacityReservationRequestSerializer;
impl CancelCapacityReservationRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CancelCapacityReservationRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "CapacityReservationId"),
            &obj.capacity_reservation_id,
        );
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CancelCapacityReservationResult {
    /// <p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>
    pub return_: Option<bool>,
}

#[allow(dead_code)]
struct CancelCapacityReservationResultDeserializer;
impl CancelCapacityReservationResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CancelCapacityReservationResult, XmlParseError> {
        deserialize_elements::<_, CancelCapacityReservationResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "return" => {
                        obj.return_ = Some(BooleanDeserializer::deserialize("return", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CancelConversionRequest {
    /// <p>The ID of the conversion task.</p>
    pub conversion_task_id: String,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The reason for canceling the conversion task.</p>
    pub reason_message: Option<String>,
}

/// Serialize `CancelConversionRequest` contents to a `SignedRequest`.
struct CancelConversionRequestSerializer;
impl CancelConversionRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CancelConversionRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "ConversionTaskId"),
            &obj.conversion_task_id,
        );
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.reason_message {
            params.put(&format!("{}{}", prefix, "ReasonMessage"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CancelExportTaskRequest {
    /// <p>The ID of the export task. This is the ID returned by <code>CreateInstanceExportTask</code>.</p>
    pub export_task_id: String,
}

/// Serialize `CancelExportTaskRequest` contents to a `SignedRequest`.
struct CancelExportTaskRequestSerializer;
impl CancelExportTaskRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CancelExportTaskRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "ExportTaskId"),
            &obj.export_task_id,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CancelImportTaskRequest {
    /// <p>The reason for canceling the task.</p>
    pub cancel_reason: Option<String>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the import image or import snapshot task to be canceled.</p>
    pub import_task_id: Option<String>,
}

/// Serialize `CancelImportTaskRequest` contents to a `SignedRequest`.
struct CancelImportTaskRequestSerializer;
impl CancelImportTaskRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CancelImportTaskRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.cancel_reason {
            params.put(&format!("{}{}", prefix, "CancelReason"), &field_value);
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.import_task_id {
            params.put(&format!("{}{}", prefix, "ImportTaskId"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CancelImportTaskResult {
    /// <p>The ID of the task being canceled.</p>
    pub import_task_id: Option<String>,
    /// <p>The current state of the task being canceled.</p>
    pub previous_state: Option<String>,
    /// <p>The current state of the task being canceled.</p>
    pub state: Option<String>,
}

#[allow(dead_code)]
struct CancelImportTaskResultDeserializer;
impl CancelImportTaskResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CancelImportTaskResult, XmlParseError> {
        deserialize_elements::<_, CancelImportTaskResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "importTaskId" => {
                    obj.import_task_id =
                        Some(StringDeserializer::deserialize("importTaskId", stack)?);
                }
                "previousState" => {
                    obj.previous_state =
                        Some(StringDeserializer::deserialize("previousState", stack)?);
                }
                "state" => {
                    obj.state = Some(StringDeserializer::deserialize("state", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>Contains the parameters for CancelReservedInstancesListing.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CancelReservedInstancesListingRequest {
    /// <p>The ID of the Reserved Instance listing.</p>
    pub reserved_instances_listing_id: String,
}

/// Serialize `CancelReservedInstancesListingRequest` contents to a `SignedRequest`.
struct CancelReservedInstancesListingRequestSerializer;
impl CancelReservedInstancesListingRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CancelReservedInstancesListingRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "ReservedInstancesListingId"),
            &obj.reserved_instances_listing_id,
        );
    }
}

/// <p>Contains the output of CancelReservedInstancesListing.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CancelReservedInstancesListingResult {
    /// <p>The Reserved Instance listing.</p>
    pub reserved_instances_listings: Option<Vec<ReservedInstancesListing>>,
}

#[allow(dead_code)]
struct CancelReservedInstancesListingResultDeserializer;
impl CancelReservedInstancesListingResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CancelReservedInstancesListingResult, XmlParseError> {
        deserialize_elements::<_, CancelReservedInstancesListingResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "reservedInstancesListingsSet" => {
                        obj.reserved_instances_listings
                            .get_or_insert(vec![])
                            .extend(ReservedInstancesListingListDeserializer::deserialize(
                                "reservedInstancesListingsSet",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Describes a Spot Fleet error.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CancelSpotFleetRequestsError {
    /// <p>The error code.</p>
    pub code: Option<String>,
    /// <p>The description for the error code.</p>
    pub message: Option<String>,
}

#[allow(dead_code)]
struct CancelSpotFleetRequestsErrorDeserializer;
impl CancelSpotFleetRequestsErrorDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CancelSpotFleetRequestsError, XmlParseError> {
        deserialize_elements::<_, CancelSpotFleetRequestsError, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "code" => {
                        obj.code = Some(CancelBatchErrorCodeDeserializer::deserialize(
                            "code", stack,
                        )?);
                    }
                    "message" => {
                        obj.message = Some(StringDeserializer::deserialize("message", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Describes a Spot Fleet request that was not successfully canceled.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CancelSpotFleetRequestsErrorItem {
    /// <p>The error.</p>
    pub error: Option<CancelSpotFleetRequestsError>,
    /// <p>The ID of the Spot Fleet request.</p>
    pub spot_fleet_request_id: Option<String>,
}

#[allow(dead_code)]
struct CancelSpotFleetRequestsErrorItemDeserializer;
impl CancelSpotFleetRequestsErrorItemDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CancelSpotFleetRequestsErrorItem, XmlParseError> {
        deserialize_elements::<_, CancelSpotFleetRequestsErrorItem, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "error" => {
                        obj.error = Some(CancelSpotFleetRequestsErrorDeserializer::deserialize(
                            "error", stack,
                        )?);
                    }
                    "spotFleetRequestId" => {
                        obj.spot_fleet_request_id = Some(StringDeserializer::deserialize(
                            "spotFleetRequestId",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct CancelSpotFleetRequestsErrorSetDeserializer;
impl CancelSpotFleetRequestsErrorSetDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<CancelSpotFleetRequestsErrorItem>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "item" {
                obj.push(CancelSpotFleetRequestsErrorItemDeserializer::deserialize(
                    "item", stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Contains the parameters for CancelSpotFleetRequests.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CancelSpotFleetRequestsRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The IDs of the Spot Fleet requests.</p>
    pub spot_fleet_request_ids: Vec<String>,
    /// <p>Indicates whether to terminate instances for a Spot Fleet request if it is canceled successfully.</p>
    pub terminate_instances: bool,
}

/// Serialize `CancelSpotFleetRequestsRequest` contents to a `SignedRequest`.
struct CancelSpotFleetRequestsRequestSerializer;
impl CancelSpotFleetRequestsRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CancelSpotFleetRequestsRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        SpotFleetRequestIdListSerializer::serialize(
            params,
            &format!("{}{}", prefix, "SpotFleetRequestId"),
            &obj.spot_fleet_request_ids,
        );
        params.put(
            &format!("{}{}", prefix, "TerminateInstances"),
            &obj.terminate_instances,
        );
    }
}

/// <p>Contains the output of CancelSpotFleetRequests.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CancelSpotFleetRequestsResponse {
    /// <p>Information about the Spot Fleet requests that are successfully canceled.</p>
    pub successful_fleet_requests: Option<Vec<CancelSpotFleetRequestsSuccessItem>>,
    /// <p>Information about the Spot Fleet requests that are not successfully canceled.</p>
    pub unsuccessful_fleet_requests: Option<Vec<CancelSpotFleetRequestsErrorItem>>,
}

#[allow(dead_code)]
struct CancelSpotFleetRequestsResponseDeserializer;
impl CancelSpotFleetRequestsResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CancelSpotFleetRequestsResponse, XmlParseError> {
        deserialize_elements::<_, CancelSpotFleetRequestsResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "successfulFleetRequestSet" => {
                        obj.successful_fleet_requests.get_or_insert(vec![]).extend(
                            CancelSpotFleetRequestsSuccessSetDeserializer::deserialize(
                                "successfulFleetRequestSet",
                                stack,
                            )?,
                        );
                    }
                    "unsuccessfulFleetRequestSet" => {
                        obj.unsuccessful_fleet_requests
                            .get_or_insert(vec![])
                            .extend(CancelSpotFleetRequestsErrorSetDeserializer::deserialize(
                                "unsuccessfulFleetRequestSet",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Describes a Spot Fleet request that was successfully canceled.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CancelSpotFleetRequestsSuccessItem {
    /// <p>The current state of the Spot Fleet request.</p>
    pub current_spot_fleet_request_state: Option<String>,
    /// <p>The previous state of the Spot Fleet request.</p>
    pub previous_spot_fleet_request_state: Option<String>,
    /// <p>The ID of the Spot Fleet request.</p>
    pub spot_fleet_request_id: Option<String>,
}

#[allow(dead_code)]
struct CancelSpotFleetRequestsSuccessItemDeserializer;
impl CancelSpotFleetRequestsSuccessItemDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CancelSpotFleetRequestsSuccessItem, XmlParseError> {
        deserialize_elements::<_, CancelSpotFleetRequestsSuccessItem, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "currentSpotFleetRequestState" => {
                        obj.current_spot_fleet_request_state =
                            Some(BatchStateDeserializer::deserialize(
                                "currentSpotFleetRequestState",
                                stack,
                            )?);
                    }
                    "previousSpotFleetRequestState" => {
                        obj.previous_spot_fleet_request_state =
                            Some(BatchStateDeserializer::deserialize(
                                "previousSpotFleetRequestState",
                                stack,
                            )?);
                    }
                    "spotFleetRequestId" => {
                        obj.spot_fleet_request_id = Some(StringDeserializer::deserialize(
                            "spotFleetRequestId",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct CancelSpotFleetRequestsSuccessSetDeserializer;
impl CancelSpotFleetRequestsSuccessSetDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<CancelSpotFleetRequestsSuccessItem>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "item" {
                obj.push(CancelSpotFleetRequestsSuccessItemDeserializer::deserialize(
                    "item", stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct CancelSpotInstanceRequestStateDeserializer;
impl CancelSpotInstanceRequestStateDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p>Contains the parameters for CancelSpotInstanceRequests.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CancelSpotInstanceRequestsRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>One or more Spot Instance request IDs.</p>
    pub spot_instance_request_ids: Vec<String>,
}

/// Serialize `CancelSpotInstanceRequestsRequest` contents to a `SignedRequest`.
struct CancelSpotInstanceRequestsRequestSerializer;
impl CancelSpotInstanceRequestsRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CancelSpotInstanceRequestsRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        SpotInstanceRequestIdListSerializer::serialize(
            params,
            &format!("{}{}", prefix, "SpotInstanceRequestId"),
            &obj.spot_instance_request_ids,
        );
    }
}

/// <p>Contains the output of CancelSpotInstanceRequests.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CancelSpotInstanceRequestsResult {
    /// <p>One or more Spot Instance requests.</p>
    pub cancelled_spot_instance_requests: Option<Vec<CancelledSpotInstanceRequest>>,
}

#[allow(dead_code)]
struct CancelSpotInstanceRequestsResultDeserializer;
impl CancelSpotInstanceRequestsResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CancelSpotInstanceRequestsResult, XmlParseError> {
        deserialize_elements::<_, CancelSpotInstanceRequestsResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "spotInstanceRequestSet" => {
                        obj.cancelled_spot_instance_requests
                            .get_or_insert(vec![])
                            .extend(CancelledSpotInstanceRequestListDeserializer::deserialize(
                                "spotInstanceRequestSet",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Describes a request to cancel a Spot Instance.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CancelledSpotInstanceRequest {
    /// <p>The ID of the Spot Instance request.</p>
    pub spot_instance_request_id: Option<String>,
    /// <p>The state of the Spot Instance request.</p>
    pub state: Option<String>,
}

#[allow(dead_code)]
struct CancelledSpotInstanceRequestDeserializer;
impl CancelledSpotInstanceRequestDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CancelledSpotInstanceRequest, XmlParseError> {
        deserialize_elements::<_, CancelledSpotInstanceRequest, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "spotInstanceRequestId" => {
                        obj.spot_instance_request_id = Some(StringDeserializer::deserialize(
                            "spotInstanceRequestId",
                            stack,
                        )?);
                    }
                    "state" => {
                        obj.state = Some(CancelSpotInstanceRequestStateDeserializer::deserialize(
                            "state", stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct CancelledSpotInstanceRequestListDeserializer;
impl CancelledSpotInstanceRequestListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<CancelledSpotInstanceRequest>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "item" {
                obj.push(CancelledSpotInstanceRequestDeserializer::deserialize(
                    "item", stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Describes a Capacity Reservation.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CapacityReservation {
    /// <p>The Availability Zone in which the capacity is reserved.</p>
    pub availability_zone: Option<String>,
    /// <p>The Availability Zone ID of the Capacity Reservation.</p>
    pub availability_zone_id: Option<String>,
    /// <p>The remaining capacity. Indicates the number of instances that can be launched in the Capacity Reservation.</p>
    pub available_instance_count: Option<i64>,
    /// <p>The Amazon Resource Name (ARN) of the Capacity Reservation.</p>
    pub capacity_reservation_arn: Option<String>,
    /// <p>The ID of the Capacity Reservation.</p>
    pub capacity_reservation_id: Option<String>,
    /// <p>The date and time at which the Capacity Reservation was created.</p>
    pub create_date: Option<String>,
    /// <p>Indicates whether the Capacity Reservation supports EBS-optimized instances. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS- optimized instance.</p>
    pub ebs_optimized: Option<bool>,
    /// <p>The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved capacity is released and you can no longer launch instances into it. The Capacity Reservation's state changes to <code>expired</code> when it reaches its end date and time.</p>
    pub end_date: Option<String>,
    /// <p><p>Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following end types:</p> <ul> <li> <p> <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it.</p> </li> <li> <p> <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time.</p> </li> </ul></p>
    pub end_date_type: Option<String>,
    /// <p>Indicates whether the Capacity Reservation supports instances with temporary, block-level storage.</p>
    pub ephemeral_storage: Option<bool>,
    /// <p><p>Indicates the type of instance launches that the Capacity Reservation accepts. The options include:</p> <ul> <li> <p> <code>open</code> - The Capacity Reservation accepts all instances that have matching attributes (instance type, platform, and Availability Zone). Instances that have matching attributes launch into the Capacity Reservation automatically without specifying any additional parameters.</p> </li> <li> <p> <code>targeted</code> - The Capacity Reservation only accepts instances that have matching attributes (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This ensures that only permitted instances can use the reserved capacity. </p> </li> </ul></p>
    pub instance_match_criteria: Option<String>,
    /// <p>The type of operating system for which the Capacity Reservation reserves capacity.</p>
    pub instance_platform: Option<String>,
    /// <p>The type of instance for which the Capacity Reservation reserves capacity.</p>
    pub instance_type: Option<String>,
    /// <p>The Amazon Resource Name (ARN) of the Outpost on which the Capacity Reservation was created.</p>
    pub outpost_arn: Option<String>,
    /// <p>The ID of the AWS account that owns the Capacity Reservation.</p>
    pub owner_id: Option<String>,
    /// <p>The date and time at which the Capacity Reservation was started.</p>
    pub start_date: Option<String>,
    /// <p><p>The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following states:</p> <ul> <li> <p> <code>active</code> - The Capacity Reservation is active and the capacity is available for your use.</p> </li> <li> <p> <code>expired</code> - The Capacity Reservation expired automatically at the date and time specified in your request. The reserved capacity is no longer available for your use.</p> </li> <li> <p> <code>cancelled</code> - The Capacity Reservation was cancelled. The reserved capacity is no longer available for your use.</p> </li> <li> <p> <code>pending</code> - The Capacity Reservation request was successful but the capacity provisioning is still pending.</p> </li> <li> <p> <code>failed</code> - The Capacity Reservation request has failed. A request might fail due to invalid request parameters, capacity constraints, or instance limit constraints. Failed requests are retained for 60 minutes.</p> </li> </ul></p>
    pub state: Option<String>,
    /// <p>Any tags assigned to the Capacity Reservation.</p>
    pub tags: Option<Vec<Tag>>,
    /// <p><p>Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following tenancy settings:</p> <ul> <li> <p> <code>default</code> - The Capacity Reservation is created on hardware that is shared with other AWS accounts.</p> </li> <li> <p> <code>dedicated</code> - The Capacity Reservation is created on single-tenant hardware that is dedicated to a single AWS account.</p> </li> </ul></p>
    pub tenancy: Option<String>,
    /// <p>The total number of instances for which the Capacity Reservation reserves capacity.</p>
    pub total_instance_count: Option<i64>,
}

#[allow(dead_code)]
struct CapacityReservationDeserializer;
impl CapacityReservationDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CapacityReservation, XmlParseError> {
        deserialize_elements::<_, CapacityReservation, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "availabilityZone" => {
                    obj.availability_zone =
                        Some(StringDeserializer::deserialize("availabilityZone", stack)?);
                }
                "availabilityZoneId" => {
                    obj.availability_zone_id = Some(StringDeserializer::deserialize(
                        "availabilityZoneId",
                        stack,
                    )?);
                }
                "availableInstanceCount" => {
                    obj.available_instance_count = Some(IntegerDeserializer::deserialize(
                        "availableInstanceCount",
                        stack,
                    )?);
                }
                "capacityReservationArn" => {
                    obj.capacity_reservation_arn = Some(StringDeserializer::deserialize(
                        "capacityReservationArn",
                        stack,
                    )?);
                }
                "capacityReservationId" => {
                    obj.capacity_reservation_id = Some(StringDeserializer::deserialize(
                        "capacityReservationId",
                        stack,
                    )?);
                }
                "createDate" => {
                    obj.create_date = Some(DateTimeDeserializer::deserialize("createDate", stack)?);
                }
                "ebsOptimized" => {
                    obj.ebs_optimized =
                        Some(BooleanDeserializer::deserialize("ebsOptimized", stack)?);
                }
                "endDate" => {
                    obj.end_date = Some(DateTimeDeserializer::deserialize("endDate", stack)?);
                }
                "endDateType" => {
                    obj.end_date_type =
                        Some(EndDateTypeDeserializer::deserialize("endDateType", stack)?);
                }
                "ephemeralStorage" => {
                    obj.ephemeral_storage =
                        Some(BooleanDeserializer::deserialize("ephemeralStorage", stack)?);
                }
                "instanceMatchCriteria" => {
                    obj.instance_match_criteria =
                        Some(InstanceMatchCriteriaDeserializer::deserialize(
                            "instanceMatchCriteria",
                            stack,
                        )?);
                }
                "instancePlatform" => {
                    obj.instance_platform = Some(
                        CapacityReservationInstancePlatformDeserializer::deserialize(
                            "instancePlatform",
                            stack,
                        )?,
                    );
                }
                "instanceType" => {
                    obj.instance_type =
                        Some(StringDeserializer::deserialize("instanceType", stack)?);
                }
                "outpostArn" => {
                    obj.outpost_arn =
                        Some(OutpostArnDeserializer::deserialize("outpostArn", stack)?);
                }
                "ownerId" => {
                    obj.owner_id = Some(StringDeserializer::deserialize("ownerId", stack)?);
                }
                "startDate" => {
                    obj.start_date = Some(MillisecondDateTimeDeserializer::deserialize(
                        "startDate",
                        stack,
                    )?);
                }
                "state" => {
                    obj.state = Some(CapacityReservationStateDeserializer::deserialize(
                        "state", stack,
                    )?);
                }
                "tagSet" => {
                    obj.tags
                        .get_or_insert(vec![])
                        .extend(TagListDeserializer::deserialize("tagSet", stack)?);
                }
                "tenancy" => {
                    obj.tenancy = Some(CapacityReservationTenancyDeserializer::deserialize(
                        "tenancy", stack,
                    )?);
                }
                "totalInstanceCount" => {
                    obj.total_instance_count = Some(IntegerDeserializer::deserialize(
                        "totalInstanceCount",
                        stack,
                    )?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>Describes a resource group to which a Capacity Reservation has been added.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CapacityReservationGroup {
    /// <p>The ARN of the resource group.</p>
    pub group_arn: Option<String>,
    /// <p>The ID of the AWS account that owns the resource group.</p>
    pub owner_id: Option<String>,
}

#[allow(dead_code)]
struct CapacityReservationGroupDeserializer;
impl CapacityReservationGroupDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CapacityReservationGroup, XmlParseError> {
        deserialize_elements::<_, CapacityReservationGroup, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "groupArn" => {
                        obj.group_arn = Some(StringDeserializer::deserialize("groupArn", stack)?);
                    }
                    "ownerId" => {
                        obj.owner_id = Some(StringDeserializer::deserialize("ownerId", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct CapacityReservationGroupSetDeserializer;
impl CapacityReservationGroupSetDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<CapacityReservationGroup>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "item" {
                obj.push(CapacityReservationGroupDeserializer::deserialize(
                    "item", stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}

/// Serialize `CapacityReservationIdSet` contents to a `SignedRequest`.
struct CapacityReservationIdSetSerializer;
impl CapacityReservationIdSetSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<String>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.{}", name, index + 1);
            params.put(&key, &obj);
        }
    }
}

#[allow(dead_code)]
struct CapacityReservationInstancePlatformDeserializer;
impl CapacityReservationInstancePlatformDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p>Describes the strategy for using unused Capacity Reservations for fulfilling On-Demand capacity.</p> <note> <p>This strategy can only be used if the EC2 Fleet is of type <code>instant</code>.</p> </note> <p>For more information about Capacity Reservations, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-capacity-reservations.html">On-Demand Capacity Reservations</a> in the <i>Amazon EC2 User Guide</i>. For examples of using Capacity Reservations in an EC2 Fleet, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-examples.html">EC2 Fleet example configurations</a> in the <i>Amazon EC2 User Guide</i>.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CapacityReservationOptions {
    /// <p>Indicates whether to use unused Capacity Reservations for fulfilling On-Demand capacity.</p> <p>If you specify <code>use-capacity-reservations-first</code>, the fleet uses unused Capacity Reservations to fulfill On-Demand capacity up to the target On-Demand capacity. If multiple instance pools have unused Capacity Reservations, the On-Demand allocation strategy (<code>lowest-price</code> or <code>prioritized</code>) is applied. If the number of unused Capacity Reservations is less than the On-Demand target capacity, the remaining On-Demand target capacity is launched according to the On-Demand allocation strategy (<code>lowest-price</code> or <code>prioritized</code>).</p> <p>If you do not specify a value, the fleet fulfils the On-Demand capacity according to the chosen On-Demand allocation strategy.</p>
    pub usage_strategy: Option<String>,
}

#[allow(dead_code)]
struct CapacityReservationOptionsDeserializer;
impl CapacityReservationOptionsDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CapacityReservationOptions, XmlParseError> {
        deserialize_elements::<_, CapacityReservationOptions, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "usageStrategy" => {
                        obj.usage_strategy = Some(
                            FleetCapacityReservationUsageStrategyDeserializer::deserialize(
                                "usageStrategy",
                                stack,
                            )?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Describes the strategy for using unused Capacity Reservations for fulfilling On-Demand capacity.</p> <note> <p>This strategy can only be used if the EC2 Fleet is of type <code>instant</code>.</p> </note> <p>For more information about Capacity Reservations, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-capacity-reservations.html">On-Demand Capacity Reservations</a> in the <i>Amazon EC2 User Guide</i>. For examples of using Capacity Reservations in an EC2 Fleet, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-examples.html">EC2 Fleet example configurations</a> in the <i>Amazon EC2 User Guide</i>.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CapacityReservationOptionsRequest {
    /// <p>Indicates whether to use unused Capacity Reservations for fulfilling On-Demand capacity.</p> <p>If you specify <code>use-capacity-reservations-first</code>, the fleet uses unused Capacity Reservations to fulfill On-Demand capacity up to the target On-Demand capacity. If multiple instance pools have unused Capacity Reservations, the On-Demand allocation strategy (<code>lowest-price</code> or <code>prioritized</code>) is applied. If the number of unused Capacity Reservations is less than the On-Demand target capacity, the remaining On-Demand target capacity is launched according to the On-Demand allocation strategy (<code>lowest-price</code> or <code>prioritized</code>).</p> <p>If you do not specify a value, the fleet fulfils the On-Demand capacity according to the chosen On-Demand allocation strategy.</p>
    pub usage_strategy: Option<String>,
}

/// Serialize `CapacityReservationOptionsRequest` contents to a `SignedRequest`.
struct CapacityReservationOptionsRequestSerializer;
impl CapacityReservationOptionsRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CapacityReservationOptionsRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.usage_strategy {
            params.put(&format!("{}{}", prefix, "UsageStrategy"), &field_value);
        }
    }
}

#[allow(dead_code)]
struct CapacityReservationPreferenceDeserializer;
impl CapacityReservationPreferenceDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct CapacityReservationSetDeserializer;
impl CapacityReservationSetDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<CapacityReservation>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "item" {
                obj.push(CapacityReservationDeserializer::deserialize("item", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Describes an instance's Capacity Reservation targeting option. You can specify only one parameter at a time. If you specify <code>CapacityReservationPreference</code> and <code>CapacityReservationTarget</code>, the request fails.</p> <p>Use the <code>CapacityReservationPreference</code> parameter to configure the instance to run as an On-Demand Instance or to run in any <code>open</code> Capacity Reservation that has matching attributes (instance type, platform, Availability Zone). Use the <code>CapacityReservationTarget</code> parameter to explicitly target a specific Capacity Reservation or a Capacity Reservation group.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CapacityReservationSpecification {
    /// <p><p>Indicates the instance&#39;s Capacity Reservation preferences. Possible preferences include:</p> <ul> <li> <p> <code>open</code> - The instance can run in any <code>open</code> Capacity Reservation that has matching attributes (instance type, platform, Availability Zone).</p> </li> <li> <p> <code>none</code> - The instance avoids running in a Capacity Reservation even if one is available. The instance runs as an On-Demand Instance.</p> </li> </ul></p>
    pub capacity_reservation_preference: Option<String>,
    /// <p>Information about the target Capacity Reservation or Capacity Reservation group.</p>
    pub capacity_reservation_target: Option<CapacityReservationTarget>,
}

/// Serialize `CapacityReservationSpecification` contents to a `SignedRequest`.
struct CapacityReservationSpecificationSerializer;
impl CapacityReservationSpecificationSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CapacityReservationSpecification) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.capacity_reservation_preference {
            params.put(
                &format!("{}{}", prefix, "CapacityReservationPreference"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.capacity_reservation_target {
            CapacityReservationTargetSerializer::serialize(
                params,
                &format!("{}{}", prefix, "CapacityReservationTarget"),
                field_value,
            );
        }
    }
}

/// <p>Describes the instance's Capacity Reservation targeting preferences. The action returns the <code>capacityReservationPreference</code> response element if the instance is configured to run in On-Demand capacity, or if it is configured in run in any <code>open</code> Capacity Reservation that has matching attributes (instance type, platform, Availability Zone). The action returns the <code>capacityReservationTarget</code> response element if the instance explicily targets a specific Capacity Reservation or Capacity Reservation group.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CapacityReservationSpecificationResponse {
    /// <p><p>Describes the instance&#39;s Capacity Reservation preferences. Possible preferences include:</p> <ul> <li> <p> <code>open</code> - The instance can run in any <code>open</code> Capacity Reservation that has matching attributes (instance type, platform, Availability Zone).</p> </li> <li> <p> <code>none</code> - The instance avoids running in a Capacity Reservation even if one is available. The instance runs in On-Demand capacity.</p> </li> </ul></p>
    pub capacity_reservation_preference: Option<String>,
    /// <p>Information about the targeted Capacity Reservation or Capacity Reservation group.</p>
    pub capacity_reservation_target: Option<CapacityReservationTargetResponse>,
}

#[allow(dead_code)]
struct CapacityReservationSpecificationResponseDeserializer;
impl CapacityReservationSpecificationResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CapacityReservationSpecificationResponse, XmlParseError> {
        deserialize_elements::<_, CapacityReservationSpecificationResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "capacityReservationPreference" => {
                        obj.capacity_reservation_preference =
                            Some(CapacityReservationPreferenceDeserializer::deserialize(
                                "capacityReservationPreference",
                                stack,
                            )?);
                    }
                    "capacityReservationTarget" => {
                        obj.capacity_reservation_target =
                            Some(CapacityReservationTargetResponseDeserializer::deserialize(
                                "capacityReservationTarget",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct CapacityReservationStateDeserializer;
impl CapacityReservationStateDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p>Describes a target Capacity Reservation or Capacity Reservation group.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CapacityReservationTarget {
    /// <p>The ID of the Capacity Reservation in which to run the instance.</p>
    pub capacity_reservation_id: Option<String>,
    /// <p>The ARN of the Capacity Reservation resource group in which to run the instance.</p>
    pub capacity_reservation_resource_group_arn: Option<String>,
}

/// Serialize `CapacityReservationTarget` contents to a `SignedRequest`.
struct CapacityReservationTargetSerializer;
impl CapacityReservationTargetSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CapacityReservationTarget) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.capacity_reservation_id {
            params.put(
                &format!("{}{}", prefix, "CapacityReservationId"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.capacity_reservation_resource_group_arn {
            params.put(
                &format!("{}{}", prefix, "CapacityReservationResourceGroupArn"),
                &field_value,
            );
        }
    }
}

/// <p>Describes a target Capacity Reservation or Capacity Reservation group.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CapacityReservationTargetResponse {
    /// <p>The ID of the targeted Capacity Reservation.</p>
    pub capacity_reservation_id: Option<String>,
    /// <p>The ARN of the targeted Capacity Reservation group.</p>
    pub capacity_reservation_resource_group_arn: Option<String>,
}

#[allow(dead_code)]
struct CapacityReservationTargetResponseDeserializer;
impl CapacityReservationTargetResponseDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CapacityReservationTargetResponse, XmlParseError> {
        deserialize_elements::<_, CapacityReservationTargetResponse, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "capacityReservationId" => {
                        obj.capacity_reservation_id = Some(StringDeserializer::deserialize(
                            "capacityReservationId",
                            stack,
                        )?);
                    }
                    "capacityReservationResourceGroupArn" => {
                        obj.capacity_reservation_resource_group_arn =
                            Some(StringDeserializer::deserialize(
                                "capacityReservationResourceGroupArn",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct CapacityReservationTenancyDeserializer;
impl CapacityReservationTenancyDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p>Describes a carrier gateway.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CarrierGateway {
    /// <p>The ID of the carrier gateway.</p>
    pub carrier_gateway_id: Option<String>,
    /// <p>The AWS account ID of the owner of the carrier gateway.</p>
    pub owner_id: Option<String>,
    /// <p>The state of the carrier gateway.</p>
    pub state: Option<String>,
    /// <p>The tags assigned to the carrier gateway.</p>
    pub tags: Option<Vec<Tag>>,
    /// <p>The ID of the VPC associated with the carrier gateway.</p>
    pub vpc_id: Option<String>,
}

#[allow(dead_code)]
struct CarrierGatewayDeserializer;
impl CarrierGatewayDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CarrierGateway, XmlParseError> {
        deserialize_elements::<_, CarrierGateway, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "carrierGatewayId" => {
                    obj.carrier_gateway_id = Some(CarrierGatewayIdDeserializer::deserialize(
                        "carrierGatewayId",
                        stack,
                    )?);
                }
                "ownerId" => {
                    obj.owner_id = Some(StringDeserializer::deserialize("ownerId", stack)?);
                }
                "state" => {
                    obj.state = Some(CarrierGatewayStateDeserializer::deserialize(
                        "state", stack,
                    )?);
                }
                "tagSet" => {
                    obj.tags
                        .get_or_insert(vec![])
                        .extend(TagListDeserializer::deserialize("tagSet", stack)?);
                }
                "vpcId" => {
                    obj.vpc_id = Some(VpcIdDeserializer::deserialize("vpcId", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct CarrierGatewayIdDeserializer;
impl CarrierGatewayIdDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}

/// Serialize `CarrierGatewayIdSet` contents to a `SignedRequest`.
struct CarrierGatewayIdSetSerializer;
impl CarrierGatewayIdSetSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<String>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.{}", name, index + 1);
            params.put(&key, &obj);
        }
    }
}

#[allow(dead_code)]
struct CarrierGatewaySetDeserializer;
impl CarrierGatewaySetDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<CarrierGateway>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "item" {
                obj.push(CarrierGatewayDeserializer::deserialize("item", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct CarrierGatewayStateDeserializer;
impl CarrierGatewayStateDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p>Information about the client certificate used for authentication.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CertificateAuthentication {
    /// <p>The ARN of the client certificate. </p>
    pub client_root_certificate_chain: Option<String>,
}

#[allow(dead_code)]
struct CertificateAuthenticationDeserializer;
impl CertificateAuthenticationDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CertificateAuthentication, XmlParseError> {
        deserialize_elements::<_, CertificateAuthentication, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "clientRootCertificateChain" => {
                        obj.client_root_certificate_chain = Some(StringDeserializer::deserialize(
                            "clientRootCertificateChain",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Information about the client certificate to be used for authentication.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CertificateAuthenticationRequest {
    /// <p>The ARN of the client certificate. The certificate must be signed by a certificate authority (CA) and it must be provisioned in AWS Certificate Manager (ACM).</p>
    pub client_root_certificate_chain_arn: Option<String>,
}

/// Serialize `CertificateAuthenticationRequest` contents to a `SignedRequest`.
struct CertificateAuthenticationRequestSerializer;
impl CertificateAuthenticationRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CertificateAuthenticationRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.client_root_certificate_chain_arn {
            params.put(
                &format!("{}{}", prefix, "ClientRootCertificateChainArn"),
                &field_value,
            );
        }
    }
}

/// <p>Provides authorization for Amazon to bring a specific IP address range to a specific account using bring your own IP addresses (BYOIP). For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html#prepare-for-byoip">Configuring your BYOIP address range</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CidrAuthorizationContext {
    /// <p>The plain-text authorization message for the prefix and account.</p>
    pub message: String,
    /// <p>The signed authorization message for the prefix and account.</p>
    pub signature: String,
}

/// Serialize `CidrAuthorizationContext` contents to a `SignedRequest`.
struct CidrAuthorizationContextSerializer;
impl CidrAuthorizationContextSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CidrAuthorizationContext) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "Message"), &obj.message);
        params.put(&format!("{}{}", prefix, "Signature"), &obj.signature);
    }
}

/// <p>Describes an IPv4 CIDR block.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CidrBlock {
    /// <p>The IPv4 CIDR block.</p>
    pub cidr_block: Option<String>,
}

#[allow(dead_code)]
struct CidrBlockDeserializer;
impl CidrBlockDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CidrBlock, XmlParseError> {
        deserialize_elements::<_, CidrBlock, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "cidrBlock" => {
                    obj.cidr_block = Some(StringDeserializer::deserialize("cidrBlock", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct CidrBlockSetDeserializer;
impl CidrBlockSetDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<CidrBlock>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "item" {
                obj.push(CidrBlockDeserializer::deserialize("item", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Describes the ClassicLink DNS support status of a VPC.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ClassicLinkDnsSupport {
    /// <p>Indicates whether ClassicLink DNS support is enabled for the VPC.</p>
    pub classic_link_dns_supported: Option<bool>,
    /// <p>The ID of the VPC.</p>
    pub vpc_id: Option<String>,
}

#[allow(dead_code)]
struct ClassicLinkDnsSupportDeserializer;
impl ClassicLinkDnsSupportDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ClassicLinkDnsSupport, XmlParseError> {
        deserialize_elements::<_, ClassicLinkDnsSupport, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "classicLinkDnsSupported" => {
                    obj.classic_link_dns_supported = Some(BooleanDeserializer::deserialize(
                        "classicLinkDnsSupported",
                        stack,
                    )?);
                }
                "vpcId" => {
                    obj.vpc_id = Some(StringDeserializer::deserialize("vpcId", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct ClassicLinkDnsSupportListDeserializer;
impl ClassicLinkDnsSupportListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<ClassicLinkDnsSupport>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "item" {
                obj.push(ClassicLinkDnsSupportDeserializer::deserialize(
                    "item", stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Describes a linked EC2-Classic instance.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ClassicLinkInstance {
    /// <p>A list of security groups.</p>
    pub groups: Option<Vec<GroupIdentifier>>,
    /// <p>The ID of the instance.</p>
    pub instance_id: Option<String>,
    /// <p>Any tags assigned to the instance.</p>
    pub tags: Option<Vec<Tag>>,
    /// <p>The ID of the VPC.</p>
    pub vpc_id: Option<String>,
}

#[allow(dead_code)]
struct ClassicLinkInstanceDeserializer;
impl ClassicLinkInstanceDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ClassicLinkInstance, XmlParseError> {
        deserialize_elements::<_, ClassicLinkInstance, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "groupSet" => {
                    obj.groups.get_or_insert(vec![]).extend(
                        GroupIdentifierListDeserializer::deserialize("groupSet", stack)?,
                    );
                }
                "instanceId" => {
                    obj.instance_id = Some(StringDeserializer::deserialize("instanceId", stack)?);
                }
                "tagSet" => {
                    obj.tags
                        .get_or_insert(vec![])
                        .extend(TagListDeserializer::deserialize("tagSet", stack)?);
                }
                "vpcId" => {
                    obj.vpc_id = Some(StringDeserializer::deserialize("vpcId", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct ClassicLinkInstanceListDeserializer;
impl ClassicLinkInstanceListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<ClassicLinkInstance>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "item" {
                obj.push(ClassicLinkInstanceDeserializer::deserialize("item", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Describes a Classic Load Balancer.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ClassicLoadBalancer {
    /// <p>The name of the load balancer.</p>
    pub name: Option<String>,
}

#[allow(dead_code)]
struct ClassicLoadBalancerDeserializer;
impl ClassicLoadBalancerDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ClassicLoadBalancer, XmlParseError> {
        deserialize_elements::<_, ClassicLoadBalancer, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "name" => {
                    obj.name = Some(StringDeserializer::deserialize("name", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}

/// Serialize `ClassicLoadBalancer` contents to a `SignedRequest`.
struct ClassicLoadBalancerSerializer;
impl ClassicLoadBalancerSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ClassicLoadBalancer) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.name {
            params.put(&format!("{}{}", prefix, "Name"), &field_value);
        }
    }
}

#[allow(dead_code)]
struct ClassicLoadBalancersDeserializer;
impl ClassicLoadBalancersDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<ClassicLoadBalancer>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "item" {
                obj.push(ClassicLoadBalancerDeserializer::deserialize("item", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}

/// Serialize `ClassicLoadBalancers` contents to a `SignedRequest`.
struct ClassicLoadBalancersSerializer;
impl ClassicLoadBalancersSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<ClassicLoadBalancer>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.{}", name, index + 1);
            ClassicLoadBalancerSerializer::serialize(params, &key, obj);
        }
    }
}

/// <p>Describes the Classic Load Balancers to attach to a Spot Fleet. Spot Fleet registers the running Spot Instances with these Classic Load Balancers.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ClassicLoadBalancersConfig {
    /// <p>One or more Classic Load Balancers.</p>
    pub classic_load_balancers: Option<Vec<ClassicLoadBalancer>>,
}

#[allow(dead_code)]
struct ClassicLoadBalancersConfigDeserializer;
impl ClassicLoadBalancersConfigDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ClassicLoadBalancersConfig, XmlParseError> {
        deserialize_elements::<_, ClassicLoadBalancersConfig, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "classicLoadBalancers" => {
                        obj.classic_load_balancers.get_or_insert(vec![]).extend(
                            ClassicLoadBalancersDeserializer::deserialize(
                                "classicLoadBalancers",
                                stack,
                            )?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}

/// Serialize `ClassicLoadBalancersConfig` contents to a `SignedRequest`.
struct ClassicLoadBalancersConfigSerializer;
impl ClassicLoadBalancersConfigSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ClassicLoadBalancersConfig) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.classic_load_balancers {
            ClassicLoadBalancersSerializer::serialize(
                params,
                &format!("{}{}", prefix, "ClassicLoadBalancers"),
                field_value,
            );
        }
    }
}

/// <p>Describes the state of a client certificate revocation list.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ClientCertificateRevocationListStatus {
    /// <p>The state of the client certificate revocation list.</p>
    pub code: Option<String>,
    /// <p>A message about the status of the client certificate revocation list, if applicable.</p>
    pub message: Option<String>,
}

#[allow(dead_code)]
struct ClientCertificateRevocationListStatusDeserializer;
impl ClientCertificateRevocationListStatusDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ClientCertificateRevocationListStatus, XmlParseError> {
        deserialize_elements::<_, ClientCertificateRevocationListStatus, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "code" => {
                        obj.code = Some(
                            ClientCertificateRevocationListStatusCodeDeserializer::deserialize(
                                "code", stack,
                            )?,
                        );
                    }
                    "message" => {
                        obj.message = Some(StringDeserializer::deserialize("message", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct ClientCertificateRevocationListStatusCodeDeserializer;
impl ClientCertificateRevocationListStatusCodeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p>The options for managing connection authorization for new client connections.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ClientConnectOptions {
    /// <p>Indicates whether client connect options are enabled. The default is <code>false</code> (not enabled).</p>
    pub enabled: Option<bool>,
    /// <p>The Amazon Resource Name (ARN) of the AWS Lambda function used for connection authorization.</p>
    pub lambda_function_arn: Option<String>,
}

/// Serialize `ClientConnectOptions` contents to a `SignedRequest`.
struct ClientConnectOptionsSerializer;
impl ClientConnectOptionsSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ClientConnectOptions) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.enabled {
            params.put(&format!("{}{}", prefix, "Enabled"), &field_value);
        }
        if let Some(ref field_value) = obj.lambda_function_arn {
            params.put(&format!("{}{}", prefix, "LambdaFunctionArn"), &field_value);
        }
    }
}

/// <p>The options for managing connection authorization for new client connections.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ClientConnectResponseOptions {
    /// <p>Indicates whether client connect options are enabled.</p>
    pub enabled: Option<bool>,
    /// <p>The Amazon Resource Name (ARN) of the AWS Lambda function used for connection authorization.</p>
    pub lambda_function_arn: Option<String>,
    /// <p>The status of any updates to the client connect options.</p>
    pub status: Option<ClientVpnEndpointAttributeStatus>,
}

#[allow(dead_code)]
struct ClientConnectResponseOptionsDeserializer;
impl ClientConnectResponseOptionsDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ClientConnectResponseOptions, XmlParseError> {
        deserialize_elements::<_, ClientConnectResponseOptions, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "enabled" => {
                        obj.enabled = Some(BooleanDeserializer::deserialize("enabled", stack)?);
                    }
                    "lambdaFunctionArn" => {
                        obj.lambda_function_arn =
                            Some(StringDeserializer::deserialize("lambdaFunctionArn", stack)?);
                    }
                    "status" => {
                        obj.status =
                            Some(ClientVpnEndpointAttributeStatusDeserializer::deserialize(
                                "status", stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Describes the client-specific data.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ClientData {
    /// <p>A user-defined comment about the disk upload.</p>
    pub comment: Option<String>,
    /// <p>The time that the disk upload ends.</p>
    pub upload_end: Option<String>,
    /// <p>The size of the uploaded disk image, in GiB.</p>
    pub upload_size: Option<f64>,
    /// <p>The time that the disk upload starts.</p>
    pub upload_start: Option<String>,
}

/// Serialize `ClientData` contents to a `SignedRequest`.
struct ClientDataSerializer;
impl ClientDataSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ClientData) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.comment {
            params.put(&format!("{}{}", prefix, "Comment"), &field_value);
        }
        if let Some(ref field_value) = obj.upload_end {
            params.put(&format!("{}{}", prefix, "UploadEnd"), &field_value);
        }
        if let Some(ref field_value) = obj.upload_size {
            params.put(&format!("{}{}", prefix, "UploadSize"), &field_value);
        }
        if let Some(ref field_value) = obj.upload_start {
            params.put(&format!("{}{}", prefix, "UploadStart"), &field_value);
        }
    }
}

/// <p>Describes the authentication methods used by a Client VPN endpoint. For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/client-authentication.html">Authentication</a> in the <i>AWS Client VPN Administrator Guide</i>.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ClientVpnAuthentication {
    /// <p>Information about the Active Directory, if applicable.</p>
    pub active_directory: Option<DirectoryServiceAuthentication>,
    /// <p>Information about the IAM SAML identity provider, if applicable.</p>
    pub federated_authentication: Option<FederatedAuthentication>,
    /// <p>Information about the authentication certificates, if applicable.</p>
    pub mutual_authentication: Option<CertificateAuthentication>,
    /// <p>The authentication type used.</p>
    pub type_: Option<String>,
}

#[allow(dead_code)]
struct ClientVpnAuthenticationDeserializer;
impl ClientVpnAuthenticationDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ClientVpnAuthentication, XmlParseError> {
        deserialize_elements::<_, ClientVpnAuthentication, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "activeDirectory" => {
                        obj.active_directory =
                            Some(DirectoryServiceAuthenticationDeserializer::deserialize(
                                "activeDirectory",
                                stack,
                            )?);
                    }
                    "federatedAuthentication" => {
                        obj.federated_authentication =
                            Some(FederatedAuthenticationDeserializer::deserialize(
                                "federatedAuthentication",
                                stack,
                            )?);
                    }
                    "mutualAuthentication" => {
                        obj.mutual_authentication =
                            Some(CertificateAuthenticationDeserializer::deserialize(
                                "mutualAuthentication",
                                stack,
                            )?);
                    }
                    "type" => {
                        obj.type_ = Some(ClientVpnAuthenticationTypeDeserializer::deserialize(
                            "type", stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct ClientVpnAuthenticationListDeserializer;
impl ClientVpnAuthenticationListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<ClientVpnAuthentication>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "item" {
                obj.push(ClientVpnAuthenticationDeserializer::deserialize(
                    "item", stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Describes the authentication method to be used by a Client VPN endpoint. For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/authentication-authrization.html#client-authentication">Authentication</a> in the <i>AWS Client VPN Administrator Guide</i>.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ClientVpnAuthenticationRequest {
    /// <p>Information about the Active Directory to be used, if applicable. You must provide this information if <b>Type</b> is <code>directory-service-authentication</code>.</p>
    pub active_directory: Option<DirectoryServiceAuthenticationRequest>,
    /// <p>Information about the IAM SAML identity provider to be used, if applicable. You must provide this information if <b>Type</b> is <code>federated-authentication</code>.</p>
    pub federated_authentication: Option<FederatedAuthenticationRequest>,
    /// <p>Information about the authentication certificates to be used, if applicable. You must provide this information if <b>Type</b> is <code>certificate-authentication</code>.</p>
    pub mutual_authentication: Option<CertificateAuthenticationRequest>,
    /// <p>The type of client authentication to be used.</p>
    pub type_: Option<String>,
}

/// Serialize `ClientVpnAuthenticationRequest` contents to a `SignedRequest`.
struct ClientVpnAuthenticationRequestSerializer;
impl ClientVpnAuthenticationRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ClientVpnAuthenticationRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.active_directory {
            DirectoryServiceAuthenticationRequestSerializer::serialize(
                params,
                &format!("{}{}", prefix, "ActiveDirectory"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.federated_authentication {
            FederatedAuthenticationRequestSerializer::serialize(
                params,
                &format!("{}{}", prefix, "FederatedAuthentication"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.mutual_authentication {
            CertificateAuthenticationRequestSerializer::serialize(
                params,
                &format!("{}{}", prefix, "MutualAuthentication"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.type_ {
            params.put(&format!("{}{}", prefix, "Type"), &field_value);
        }
    }
}

/// Serialize `ClientVpnAuthenticationRequestList` contents to a `SignedRequest`.
struct ClientVpnAuthenticationRequestListSerializer;
impl ClientVpnAuthenticationRequestListSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<ClientVpnAuthenticationRequest>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.{}", name, index + 1);
            ClientVpnAuthenticationRequestSerializer::serialize(params, &key, obj);
        }
    }
}

#[allow(dead_code)]
struct ClientVpnAuthenticationTypeDeserializer;
impl ClientVpnAuthenticationTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p>Describes the state of an authorization rule.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ClientVpnAuthorizationRuleStatus {
    /// <p>The state of the authorization rule.</p>
    pub code: Option<String>,
    /// <p>A message about the status of the authorization rule, if applicable.</p>
    pub message: Option<String>,
}

#[allow(dead_code)]
struct ClientVpnAuthorizationRuleStatusDeserializer;
impl ClientVpnAuthorizationRuleStatusDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ClientVpnAuthorizationRuleStatus, XmlParseError> {
        deserialize_elements::<_, ClientVpnAuthorizationRuleStatus, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "code" => {
                        obj.code = Some(
                            ClientVpnAuthorizationRuleStatusCodeDeserializer::deserialize(
                                "code", stack,
                            )?,
                        );
                    }
                    "message" => {
                        obj.message = Some(StringDeserializer::deserialize("message", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct ClientVpnAuthorizationRuleStatusCodeDeserializer;
impl ClientVpnAuthorizationRuleStatusCodeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p>Describes a client connection.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ClientVpnConnection {
    /// <p>The IP address of the client.</p>
    pub client_ip: Option<String>,
    /// <p>The ID of the Client VPN endpoint to which the client is connected.</p>
    pub client_vpn_endpoint_id: Option<String>,
    /// <p>The common name associated with the client. This is either the name of the client certificate, or the Active Directory user name.</p>
    pub common_name: Option<String>,
    /// <p>The date and time the client connection was terminated.</p>
    pub connection_end_time: Option<String>,
    /// <p>The date and time the client connection was established.</p>
    pub connection_established_time: Option<String>,
    /// <p>The ID of the client connection.</p>
    pub connection_id: Option<String>,
    /// <p>The number of bytes received by the client.</p>
    pub egress_bytes: Option<String>,
    /// <p>The number of packets received by the client.</p>
    pub egress_packets: Option<String>,
    /// <p>The number of bytes sent by the client.</p>
    pub ingress_bytes: Option<String>,
    /// <p>The number of packets sent by the client.</p>
    pub ingress_packets: Option<String>,
    /// <p>The statuses returned by the client connect handler for posture compliance, if applicable.</p>
    pub posture_compliance_statuses: Option<Vec<String>>,
    /// <p>The current state of the client connection.</p>
    pub status: Option<ClientVpnConnectionStatus>,
    /// <p>The current date and time.</p>
    pub timestamp: Option<String>,
    /// <p>The username of the client who established the client connection. This information is only provided if Active Directory client authentication is used.</p>
    pub username: Option<String>,
}

#[allow(dead_code)]
struct ClientVpnConnectionDeserializer;
impl ClientVpnConnectionDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ClientVpnConnection, XmlParseError> {
        deserialize_elements::<_, ClientVpnConnection, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "clientIp" => {
                    obj.client_ip = Some(StringDeserializer::deserialize("clientIp", stack)?);
                }
                "clientVpnEndpointId" => {
                    obj.client_vpn_endpoint_id = Some(StringDeserializer::deserialize(
                        "clientVpnEndpointId",
                        stack,
                    )?);
                }
                "commonName" => {
                    obj.common_name = Some(StringDeserializer::deserialize("commonName", stack)?);
                }
                "connectionEndTime" => {
                    obj.connection_end_time =
                        Some(StringDeserializer::deserialize("connectionEndTime", stack)?);
                }
                "connectionEstablishedTime" => {
                    obj.connection_established_time = Some(StringDeserializer::deserialize(
                        "connectionEstablishedTime",
                        stack,
                    )?);
                }
                "connectionId" => {
                    obj.connection_id =
                        Some(StringDeserializer::deserialize("connectionId", stack)?);
                }
                "egressBytes" => {
                    obj.egress_bytes = Some(StringDeserializer::deserialize("egressBytes", stack)?);
                }
                "egressPackets" => {
                    obj.egress_packets =
                        Some(StringDeserializer::deserialize("egressPackets", stack)?);
                }
                "ingressBytes" => {
                    obj.ingress_bytes =
                        Some(StringDeserializer::deserialize("ingressBytes", stack)?);
                }
                "ingressPackets" => {
                    obj.ingress_packets =
                        Some(StringDeserializer::deserialize("ingressPackets", stack)?);
                }
                "postureComplianceStatusSet" => {
                    obj.posture_compliance_statuses
                        .get_or_insert(vec![])
                        .extend(ValueStringListDeserializer::deserialize(
                            "postureComplianceStatusSet",
                            stack,
                        )?);
                }
                "status" => {
                    obj.status = Some(ClientVpnConnectionStatusDeserializer::deserialize(
                        "status", stack,
                    )?);
                }
                "timestamp" => {
                    obj.timestamp = Some(StringDeserializer::deserialize("timestamp", stack)?);
                }
                "username" => {
                    obj.username = Some(StringDeserializer::deserialize("username", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct ClientVpnConnectionSetDeserializer;
impl ClientVpnConnectionSetDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<ClientVpnConnection>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "item" {
                obj.push(ClientVpnConnectionDeserializer::deserialize("item", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Describes the status of a client connection.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ClientVpnConnectionStatus {
    /// <p>The state of the client connection.</p>
    pub code: Option<String>,
    /// <p>A message about the status of the client connection, if applicable.</p>
    pub message: Option<String>,
}

#[allow(dead_code)]
struct ClientVpnConnectionStatusDeserializer;
impl ClientVpnConnectionStatusDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ClientVpnConnectionStatus, XmlParseError> {
        deserialize_elements::<_, ClientVpnConnectionStatus, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "code" => {
                        obj.code = Some(ClientVpnConnectionStatusCodeDeserializer::deserialize(
                            "code", stack,
                        )?);
                    }
                    "message" => {
                        obj.message = Some(StringDeserializer::deserialize("message", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct ClientVpnConnectionStatusCodeDeserializer;
impl ClientVpnConnectionStatusCodeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p>Describes a Client VPN endpoint.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ClientVpnEndpoint {
    /// <p>Information about the authentication method used by the Client VPN endpoint.</p>
    pub authentication_options: Option<Vec<ClientVpnAuthentication>>,
    /// <p>The IPv4 address range, in CIDR notation, from which client IP addresses are assigned.</p>
    pub client_cidr_block: Option<String>,
    /// <p>The options for managing connection authorization for new client connections.</p>
    pub client_connect_options: Option<ClientConnectResponseOptions>,
    /// <p>The ID of the Client VPN endpoint.</p>
    pub client_vpn_endpoint_id: Option<String>,
    /// <p>Information about the client connection logging options for the Client VPN endpoint.</p>
    pub connection_log_options: Option<ConnectionLogResponseOptions>,
    /// <p>The date and time the Client VPN endpoint was created.</p>
    pub creation_time: Option<String>,
    /// <p>The date and time the Client VPN endpoint was deleted, if applicable.</p>
    pub deletion_time: Option<String>,
    /// <p>A brief description of the endpoint.</p>
    pub description: Option<String>,
    /// <p>The DNS name to be used by clients when connecting to the Client VPN endpoint.</p>
    pub dns_name: Option<String>,
    /// <p>Information about the DNS servers to be used for DNS resolution. </p>
    pub dns_servers: Option<Vec<String>>,
    /// <p>The IDs of the security groups for the target network.</p>
    pub security_group_ids: Option<Vec<String>>,
    /// <p>The URL of the self-service portal.</p>
    pub self_service_portal_url: Option<String>,
    /// <p>The ARN of the server certificate.</p>
    pub server_certificate_arn: Option<String>,
    /// <p>Indicates whether split-tunnel is enabled in the AWS Client VPN endpoint.</p> <p>For information about split-tunnel VPN endpoints, see <a href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html">Split-Tunnel AWS Client VPN Endpoint</a> in the <i>AWS Client VPN Administrator Guide</i>.</p>
    pub split_tunnel: Option<bool>,
    /// <p>The current state of the Client VPN endpoint.</p>
    pub status: Option<ClientVpnEndpointStatus>,
    /// <p>Any tags assigned to the Client VPN endpoint.</p>
    pub tags: Option<Vec<Tag>>,
    /// <p>The transport protocol used by the Client VPN endpoint.</p>
    pub transport_protocol: Option<String>,
    /// <p>The ID of the VPC.</p>
    pub vpc_id: Option<String>,
    /// <p>The port number for the Client VPN endpoint.</p>
    pub vpn_port: Option<i64>,
    /// <p>The protocol used by the VPN session.</p>
    pub vpn_protocol: Option<String>,
}

#[allow(dead_code)]
struct ClientVpnEndpointDeserializer;
impl ClientVpnEndpointDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ClientVpnEndpoint, XmlParseError> {
        deserialize_elements::<_, ClientVpnEndpoint, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "authenticationOptions" => {
                    obj.authentication_options.get_or_insert(vec![]).extend(
                        ClientVpnAuthenticationListDeserializer::deserialize(
                            "authenticationOptions",
                            stack,
                        )?,
                    );
                }
                "clientCidrBlock" => {
                    obj.client_cidr_block =
                        Some(StringDeserializer::deserialize("clientCidrBlock", stack)?);
                }
                "clientConnectOptions" => {
                    obj.client_connect_options =
                        Some(ClientConnectResponseOptionsDeserializer::deserialize(
                            "clientConnectOptions",
                            stack,
                        )?);
                }
                "clientVpnEndpointId" => {
                    obj.client_vpn_endpoint_id = Some(StringDeserializer::deserialize(
                        "clientVpnEndpointId",
                        stack,
                    )?);
                }
                "connectionLogOptions" => {
                    obj.connection_log_options =
                        Some(ConnectionLogResponseOptionsDeserializer::deserialize(
                            "connectionLogOptions",
                            stack,
                        )?);
                }
                "creationTime" => {
                    obj.creation_time =
                        Some(StringDeserializer::deserialize("creationTime", stack)?);
                }
                "deletionTime" => {
                    obj.deletion_time =
                        Some(StringDeserializer::deserialize("deletionTime", stack)?);
                }
                "description" => {
                    obj.description = Some(StringDeserializer::deserialize("description", stack)?);
                }
                "dnsName" => {
                    obj.dns_name = Some(StringDeserializer::deserialize("dnsName", stack)?);
                }
                "dnsServer" => {
                    obj.dns_servers.get_or_insert(vec![]).extend(
                        ValueStringListDeserializer::deserialize("dnsServer", stack)?,
                    );
                }
                "securityGroupIdSet" => {
                    obj.security_group_ids.get_or_insert(vec![]).extend(
                        ClientVpnSecurityGroupIdSetDeserializer::deserialize(
                            "securityGroupIdSet",
                            stack,
                        )?,
                    );
                }
                "selfServicePortalUrl" => {
                    obj.self_service_portal_url = Some(StringDeserializer::deserialize(
                        "selfServicePortalUrl",
                        stack,
                    )?);
                }
                "serverCertificateArn" => {
                    obj.server_certificate_arn = Some(StringDeserializer::deserialize(
                        "serverCertificateArn",
                        stack,
                    )?);
                }
                "splitTunnel" => {
                    obj.split_tunnel =
                        Some(BooleanDeserializer::deserialize("splitTunnel", stack)?);
                }
                "status" => {
                    obj.status = Some(ClientVpnEndpointStatusDeserializer::deserialize(
                        "status", stack,
                    )?);
                }
                "tagSet" => {
                    obj.tags
                        .get_or_insert(vec![])
                        .extend(TagListDeserializer::deserialize("tagSet", stack)?);
                }
                "transportProtocol" => {
                    obj.transport_protocol = Some(TransportProtocolDeserializer::deserialize(
                        "transportProtocol",
                        stack,
                    )?);
                }
                "vpcId" => {
                    obj.vpc_id = Some(VpcIdDeserializer::deserialize("vpcId", stack)?);
                }
                "vpnPort" => {
                    obj.vpn_port = Some(IntegerDeserializer::deserialize("vpnPort", stack)?);
                }
                "vpnProtocol" => {
                    obj.vpn_protocol =
                        Some(VpnProtocolDeserializer::deserialize("vpnProtocol", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>Describes the status of the Client VPN endpoint attribute.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ClientVpnEndpointAttributeStatus {
    /// <p>The status code.</p>
    pub code: Option<String>,
    /// <p>The status message.</p>
    pub message: Option<String>,
}

#[allow(dead_code)]
struct ClientVpnEndpointAttributeStatusDeserializer;
impl ClientVpnEndpointAttributeStatusDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ClientVpnEndpointAttributeStatus, XmlParseError> {
        deserialize_elements::<_, ClientVpnEndpointAttributeStatus, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "code" => {
                        obj.code = Some(
                            ClientVpnEndpointAttributeStatusCodeDeserializer::deserialize(
                                "code", stack,
                            )?,
                        );
                    }
                    "message" => {
                        obj.message = Some(StringDeserializer::deserialize("message", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct ClientVpnEndpointAttributeStatusCodeDeserializer;
impl ClientVpnEndpointAttributeStatusCodeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}

/// Serialize `ClientVpnEndpointIdList` contents to a `SignedRequest`.
struct ClientVpnEndpointIdListSerializer;
impl ClientVpnEndpointIdListSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<String>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.{}", name, index + 1);
            params.put(&key, &obj);
        }
    }
}

/// <p>Describes the state of a Client VPN endpoint.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ClientVpnEndpointStatus {
    /// <p><p>The state of the Client VPN endpoint. Possible states include:</p> <ul> <li> <p> <code>pending-associate</code> - The Client VPN endpoint has been created but no target networks have been associated. The Client VPN endpoint cannot accept connections.</p> </li> <li> <p> <code>available</code> - The Client VPN endpoint has been created and a target network has been associated. The Client VPN endpoint can accept connections.</p> </li> <li> <p> <code>deleting</code> - The Client VPN endpoint is being deleted. The Client VPN endpoint cannot accept connections.</p> </li> <li> <p> <code>deleted</code> - The Client VPN endpoint has been deleted. The Client VPN endpoint cannot accept connections.</p> </li> </ul></p>
    pub code: Option<String>,
    /// <p>A message about the status of the Client VPN endpoint.</p>
    pub message: Option<String>,
}

#[allow(dead_code)]
struct ClientVpnEndpointStatusDeserializer;
impl ClientVpnEndpointStatusDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ClientVpnEndpointStatus, XmlParseError> {
        deserialize_elements::<_, ClientVpnEndpointStatus, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "code" => {
                        obj.code = Some(ClientVpnEndpointStatusCodeDeserializer::deserialize(
                            "code", stack,
                        )?);
                    }
                    "message" => {
                        obj.message = Some(StringDeserializer::deserialize("message", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct ClientVpnEndpointStatusCodeDeserializer;
impl ClientVpnEndpointStatusCodeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p>Information about a Client VPN endpoint route.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ClientVpnRoute {
    /// <p>The ID of the Client VPN endpoint with which the route is associated.</p>
    pub client_vpn_endpoint_id: Option<String>,
    /// <p>A brief description of the route.</p>
    pub description: Option<String>,
    /// <p>The IPv4 address range, in CIDR notation, of the route destination.</p>
    pub destination_cidr: Option<String>,
    /// <p>Indicates how the route was associated with the Client VPN endpoint. <code>associate</code> indicates that the route was automatically added when the target network was associated with the Client VPN endpoint. <code>add-route</code> indicates that the route was manually added using the <b>CreateClientVpnRoute</b> action.</p>
    pub origin: Option<String>,
    /// <p>The current state of the route.</p>
    pub status: Option<ClientVpnRouteStatus>,
    /// <p>The ID of the subnet through which traffic is routed.</p>
    pub target_subnet: Option<String>,
    /// <p>The route type.</p>
    pub type_: Option<String>,
}

#[allow(dead_code)]
struct ClientVpnRouteDeserializer;
impl ClientVpnRouteDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ClientVpnRoute, XmlParseError> {
        deserialize_elements::<_, ClientVpnRoute, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "clientVpnEndpointId" => {
                    obj.client_vpn_endpoint_id = Some(StringDeserializer::deserialize(
                        "clientVpnEndpointId",
                        stack,
                    )?);
                }
                "description" => {
                    obj.description = Some(StringDeserializer::deserialize("description", stack)?);
                }
                "destinationCidr" => {
                    obj.destination_cidr =
                        Some(StringDeserializer::deserialize("destinationCidr", stack)?);
                }
                "origin" => {
                    obj.origin = Some(StringDeserializer::deserialize("origin", stack)?);
                }
                "status" => {
                    obj.status = Some(ClientVpnRouteStatusDeserializer::deserialize(
                        "status", stack,
                    )?);
                }
                "targetSubnet" => {
                    obj.target_subnet =
                        Some(StringDeserializer::deserialize("targetSubnet", stack)?);
                }
                "type" => {
                    obj.type_ = Some(StringDeserializer::deserialize("type", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct ClientVpnRouteSetDeserializer;
impl ClientVpnRouteSetDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<ClientVpnRoute>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "item" {
                obj.push(ClientVpnRouteDeserializer::deserialize("item", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Describes the state of a Client VPN endpoint route.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ClientVpnRouteStatus {
    /// <p>The state of the Client VPN endpoint route.</p>
    pub code: Option<String>,
    /// <p>A message about the status of the Client VPN endpoint route, if applicable.</p>
    pub message: Option<String>,
}

#[allow(dead_code)]
struct ClientVpnRouteStatusDeserializer;
impl ClientVpnRouteStatusDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ClientVpnRouteStatus, XmlParseError> {
        deserialize_elements::<_, ClientVpnRouteStatus, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "code" => {
                    obj.code = Some(ClientVpnRouteStatusCodeDeserializer::deserialize(
                        "code", stack,
                    )?);
                }
                "message" => {
                    obj.message = Some(StringDeserializer::deserialize("message", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct ClientVpnRouteStatusCodeDeserializer;
impl ClientVpnRouteStatusCodeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct ClientVpnSecurityGroupIdSetDeserializer;
impl ClientVpnSecurityGroupIdSetDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<String>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "item" {
                obj.push(SecurityGroupIdDeserializer::deserialize("item", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}

/// Serialize `ClientVpnSecurityGroupIdSet` contents to a `SignedRequest`.
struct ClientVpnSecurityGroupIdSetSerializer;
impl ClientVpnSecurityGroupIdSetSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<String>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.{}", name, index + 1);
            params.put(&key, &obj);
        }
    }
}

/// <p>Describes address usage for a customer-owned address pool.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CoipAddressUsage {
    /// <p>The allocation ID of the address.</p>
    pub allocation_id: Option<String>,
    /// <p>The AWS account ID.</p>
    pub aws_account_id: Option<String>,
    /// <p>The AWS service.</p>
    pub aws_service: Option<String>,
    /// <p>The customer-owned IP address.</p>
    pub co_ip: Option<String>,
}

#[allow(dead_code)]
struct CoipAddressUsageDeserializer;
impl CoipAddressUsageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CoipAddressUsage, XmlParseError> {
        deserialize_elements::<_, CoipAddressUsage, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "allocationId" => {
                    obj.allocation_id =
                        Some(StringDeserializer::deserialize("allocationId", stack)?);
                }
                "awsAccountId" => {
                    obj.aws_account_id =
                        Some(StringDeserializer::deserialize("awsAccountId", stack)?);
                }
                "awsService" => {
                    obj.aws_service = Some(StringDeserializer::deserialize("awsService", stack)?);
                }
                "coIp" => {
                    obj.co_ip = Some(StringDeserializer::deserialize("coIp", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct CoipAddressUsageSetDeserializer;
impl CoipAddressUsageSetDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<CoipAddressUsage>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "item" {
                obj.push(CoipAddressUsageDeserializer::deserialize("item", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Describes a customer-owned address pool.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CoipPool {
    /// <p>The ID of the local gateway route table.</p>
    pub local_gateway_route_table_id: Option<String>,
    /// <p>The ARN of the address pool.</p>
    pub pool_arn: Option<String>,
    /// <p>The address ranges of the address pool.</p>
    pub pool_cidrs: Option<Vec<String>>,
    /// <p>The ID of the address pool.</p>
    pub pool_id: Option<String>,
    /// <p>The tags.</p>
    pub tags: Option<Vec<Tag>>,
}

#[allow(dead_code)]
struct CoipPoolDeserializer;
impl CoipPoolDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CoipPool, XmlParseError> {
        deserialize_elements::<_, CoipPool, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "localGatewayRouteTableId" => {
                    obj.local_gateway_route_table_id =
                        Some(LocalGatewayRoutetableIdDeserializer::deserialize(
                            "localGatewayRouteTableId",
                            stack,
                        )?);
                }
                "poolArn" => {
                    obj.pool_arn = Some(ResourceArnDeserializer::deserialize("poolArn", stack)?);
                }
                "poolCidrSet" => {
                    obj.pool_cidrs.get_or_insert(vec![]).extend(
                        ValueStringListDeserializer::deserialize("poolCidrSet", stack)?,
                    );
                }
                "poolId" => {
                    obj.pool_id = Some(CoipPoolIdDeserializer::deserialize("poolId", stack)?);
                }
                "tagSet" => {
                    obj.tags
                        .get_or_insert(vec![])
                        .extend(TagListDeserializer::deserialize("tagSet", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct CoipPoolIdDeserializer;
impl CoipPoolIdDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}

/// Serialize `CoipPoolIdSet` contents to a `SignedRequest`.
struct CoipPoolIdSetSerializer;
impl CoipPoolIdSetSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<String>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.{}", name, index + 1);
            params.put(&key, &obj);
        }
    }
}

#[allow(dead_code)]
struct CoipPoolSetDeserializer;
impl CoipPoolSetDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<CoipPool>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "item" {
                obj.push(CoipPoolDeserializer::deserialize("item", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ConfirmProductInstanceRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the instance.</p>
    pub instance_id: String,
    /// <p>The product code. This must be a product code that you own.</p>
    pub product_code: String,
}

/// Serialize `ConfirmProductInstanceRequest` contents to a `SignedRequest`.
struct ConfirmProductInstanceRequestSerializer;
impl ConfirmProductInstanceRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ConfirmProductInstanceRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "InstanceId"), &obj.instance_id);
        params.put(&format!("{}{}", prefix, "ProductCode"), &obj.product_code);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ConfirmProductInstanceResult {
    /// <p>The AWS account ID of the instance owner. This is only present if the product code is attached to the instance.</p>
    pub owner_id: Option<String>,
    /// <p>The return value of the request. Returns <code>true</code> if the specified product code is owned by the requester and associated with the specified instance.</p>
    pub return_: Option<bool>,
}

#[allow(dead_code)]
struct ConfirmProductInstanceResultDeserializer;
impl ConfirmProductInstanceResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ConfirmProductInstanceResult, XmlParseError> {
        deserialize_elements::<_, ConfirmProductInstanceResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "ownerId" => {
                        obj.owner_id = Some(StringDeserializer::deserialize("ownerId", stack)?);
                    }
                    "return" => {
                        obj.return_ = Some(BooleanDeserializer::deserialize("return", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Describes the client connection logging options for the Client VPN endpoint.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ConnectionLogOptions {
    /// <p>The name of the CloudWatch Logs log group. Required if connection logging is enabled.</p>
    pub cloudwatch_log_group: Option<String>,
    /// <p>The name of the CloudWatch Logs log stream to which the connection data is published.</p>
    pub cloudwatch_log_stream: Option<String>,
    /// <p>Indicates whether connection logging is enabled.</p>
    pub enabled: Option<bool>,
}

/// Serialize `ConnectionLogOptions` contents to a `SignedRequest`.
struct ConnectionLogOptionsSerializer;
impl ConnectionLogOptionsSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ConnectionLogOptions) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.cloudwatch_log_group {
            params.put(&format!("{}{}", prefix, "CloudwatchLogGroup"), &field_value);
        }
        if let Some(ref field_value) = obj.cloudwatch_log_stream {
            params.put(
                &format!("{}{}", prefix, "CloudwatchLogStream"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.enabled {
            params.put(&format!("{}{}", prefix, "Enabled"), &field_value);
        }
    }
}

/// <p>Information about the client connection logging options for a Client VPN endpoint.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ConnectionLogResponseOptions {
    /// <p>The name of the Amazon CloudWatch Logs log group to which connection logging data is published.</p>
    pub cloudwatch_log_group: Option<String>,
    /// <p>The name of the Amazon CloudWatch Logs log stream to which connection logging data is published.</p>
    pub cloudwatch_log_stream: Option<String>,
    /// <p>Indicates whether client connection logging is enabled for the Client VPN endpoint.</p>
    pub enabled: Option<bool>,
}

#[allow(dead_code)]
struct ConnectionLogResponseOptionsDeserializer;
impl ConnectionLogResponseOptionsDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ConnectionLogResponseOptions, XmlParseError> {
        deserialize_elements::<_, ConnectionLogResponseOptions, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "CloudwatchLogGroup" => {
                        obj.cloudwatch_log_group = Some(StringDeserializer::deserialize(
                            "CloudwatchLogGroup",
                            stack,
                        )?);
                    }
                    "CloudwatchLogStream" => {
                        obj.cloudwatch_log_stream = Some(StringDeserializer::deserialize(
                            "CloudwatchLogStream",
                            stack,
                        )?);
                    }
                    "Enabled" => {
                        obj.enabled = Some(BooleanDeserializer::deserialize("Enabled", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Describes a connection notification for a VPC endpoint or VPC endpoint service.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ConnectionNotification {
    /// <p>The events for the notification. Valid values are <code>Accept</code>, <code>Connect</code>, <code>Delete</code>, and <code>Reject</code>.</p>
    pub connection_events: Option<Vec<String>>,
    /// <p>The ARN of the SNS topic for the notification.</p>
    pub connection_notification_arn: Option<String>,
    /// <p>The ID of the notification.</p>
    pub connection_notification_id: Option<String>,
    /// <p>The state of the notification.</p>
    pub connection_notification_state: Option<String>,
    /// <p>The type of notification.</p>
    pub connection_notification_type: Option<String>,
    /// <p>The ID of the endpoint service.</p>
    pub service_id: Option<String>,
    /// <p>The ID of the VPC endpoint.</p>
    pub vpc_endpoint_id: Option<String>,
}

#[allow(dead_code)]
struct ConnectionNotificationDeserializer;
impl ConnectionNotificationDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ConnectionNotification, XmlParseError> {
        deserialize_elements::<_, ConnectionNotification, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "connectionEvents" => {
                    obj.connection_events.get_or_insert(vec![]).extend(
                        ValueStringListDeserializer::deserialize("connectionEvents", stack)?,
                    );
                }
                "connectionNotificationArn" => {
                    obj.connection_notification_arn = Some(StringDeserializer::deserialize(
                        "connectionNotificationArn",
                        stack,
                    )?);
                }
                "connectionNotificationId" => {
                    obj.connection_notification_id = Some(StringDeserializer::deserialize(
                        "connectionNotificationId",
                        stack,
                    )?);
                }
                "connectionNotificationState" => {
                    obj.connection_notification_state =
                        Some(ConnectionNotificationStateDeserializer::deserialize(
                            "connectionNotificationState",
                            stack,
                        )?);
                }
                "connectionNotificationType" => {
                    obj.connection_notification_type =
                        Some(ConnectionNotificationTypeDeserializer::deserialize(
                            "connectionNotificationType",
                            stack,
                        )?);
                }
                "serviceId" => {
                    obj.service_id = Some(StringDeserializer::deserialize("serviceId", stack)?);
                }
                "vpcEndpointId" => {
                    obj.vpc_endpoint_id =
                        Some(StringDeserializer::deserialize("vpcEndpointId", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}

/// Serialize `ConnectionNotificationIdsList` contents to a `SignedRequest`.
struct ConnectionNotificationIdsListSerializer;
impl ConnectionNotificationIdsListSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<String>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.{}", name, index + 1);
            params.put(&key, &obj);
        }
    }
}

#[allow(dead_code)]
struct ConnectionNotificationSetDeserializer;
impl ConnectionNotificationSetDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<ConnectionNotification>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "item" {
                obj.push(ConnectionNotificationDeserializer::deserialize(
                    "item", stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct ConnectionNotificationStateDeserializer;
impl ConnectionNotificationStateDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct ConnectionNotificationTypeDeserializer;
impl ConnectionNotificationTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct ConnectivityTypeDeserializer;
impl ConnectivityTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct ContainerFormatDeserializer;
impl ContainerFormatDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}

/// Serialize `ConversionIdStringList` contents to a `SignedRequest`.
struct ConversionIdStringListSerializer;
impl ConversionIdStringListSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<String>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.{}", name, index + 1);
            params.put(&key, &obj);
        }
    }
}

/// <p>Describes a conversion task.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ConversionTask {
    /// <p>The ID of the conversion task.</p>
    pub conversion_task_id: Option<String>,
    /// <p>The time when the task expires. If the upload isn't complete before the expiration time, we automatically cancel the task.</p>
    pub expiration_time: Option<String>,
    /// <p>If the task is for importing an instance, this contains information about the import instance task.</p>
    pub import_instance: Option<ImportInstanceTaskDetails>,
    /// <p>If the task is for importing a volume, this contains information about the import volume task.</p>
    pub import_volume: Option<ImportVolumeTaskDetails>,
    /// <p>The state of the conversion task.</p>
    pub state: Option<String>,
    /// <p>The status message related to the conversion task.</p>
    pub status_message: Option<String>,
    /// <p>Any tags assigned to the task.</p>
    pub tags: Option<Vec<Tag>>,
}

#[allow(dead_code)]
struct ConversionTaskDeserializer;
impl ConversionTaskDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ConversionTask, XmlParseError> {
        deserialize_elements::<_, ConversionTask, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "conversionTaskId" => {
                    obj.conversion_task_id =
                        Some(StringDeserializer::deserialize("conversionTaskId", stack)?);
                }
                "expirationTime" => {
                    obj.expiration_time =
                        Some(StringDeserializer::deserialize("expirationTime", stack)?);
                }
                "importInstance" => {
                    obj.import_instance = Some(ImportInstanceTaskDetailsDeserializer::deserialize(
                        "importInstance",
                        stack,
                    )?);
                }
                "importVolume" => {
                    obj.import_volume = Some(ImportVolumeTaskDetailsDeserializer::deserialize(
                        "importVolume",
                        stack,
                    )?);
                }
                "state" => {
                    obj.state = Some(ConversionTaskStateDeserializer::deserialize(
                        "state", stack,
                    )?);
                }
                "statusMessage" => {
                    obj.status_message =
                        Some(StringDeserializer::deserialize("statusMessage", stack)?);
                }
                "tagSet" => {
                    obj.tags
                        .get_or_insert(vec![])
                        .extend(TagListDeserializer::deserialize("tagSet", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct ConversionTaskStateDeserializer;
impl ConversionTaskStateDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CopyFpgaImageRequest {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
    pub client_token: Option<String>,
    /// <p>The description for the new AFI.</p>
    pub description: Option<String>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The name for the new AFI. The default is the name of the source AFI.</p>
    pub name: Option<String>,
    /// <p>The ID of the source AFI.</p>
    pub source_fpga_image_id: String,
    /// <p>The Region that contains the source AFI.</p>
    pub source_region: String,
}

/// Serialize `CopyFpgaImageRequest` contents to a `SignedRequest`.
struct CopyFpgaImageRequestSerializer;
impl CopyFpgaImageRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CopyFpgaImageRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.client_token {
            params.put(&format!("{}{}", prefix, "ClientToken"), &field_value);
        }
        if let Some(ref field_value) = obj.description {
            params.put(&format!("{}{}", prefix, "Description"), &field_value);
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.name {
            params.put(&format!("{}{}", prefix, "Name"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "SourceFpgaImageId"),
            &obj.source_fpga_image_id,
        );
        params.put(&format!("{}{}", prefix, "SourceRegion"), &obj.source_region);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CopyFpgaImageResult {
    /// <p>The ID of the new AFI.</p>
    pub fpga_image_id: Option<String>,
}

#[allow(dead_code)]
struct CopyFpgaImageResultDeserializer;
impl CopyFpgaImageResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CopyFpgaImageResult, XmlParseError> {
        deserialize_elements::<_, CopyFpgaImageResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "fpgaImageId" => {
                    obj.fpga_image_id =
                        Some(StringDeserializer::deserialize("fpgaImageId", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>Contains the parameters for CopyImage.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CopyImageRequest {
    /// <p>Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a> in the <i>Amazon EC2 API Reference</i>.</p>
    pub client_token: Option<String>,
    /// <p>A description for the new AMI in the destination Region.</p>
    pub description: Option<String>,
    /// <p>The Amazon Resource Name (ARN) of the Outpost to which to copy the AMI. Only specify this parameter when copying an AMI from an AWS Region to an Outpost. The AMI must be in the Region of the destination Outpost. You cannot copy an AMI from an Outpost to a Region, from one Outpost to another, or within the same Outpost.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#copy-amis"> Copying AMIs from an AWS Region to an Outpost</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
    pub destination_outpost_arn: Option<String>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>Specifies whether the destination snapshots of the copied image should be encrypted. You can encrypt a copy of an unencrypted snapshot, but you cannot create an unencrypted copy of an encrypted snapshot. The default CMK for EBS is used unless you specify a non-default AWS Key Management Service (AWS KMS) CMK using <code>KmsKeyId</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
    pub encrypted: Option<bool>,
    /// <p>The identifier of the symmetric AWS Key Management Service (AWS KMS) customer master key (CMK) to use when creating encrypted volumes. If this parameter is not specified, your AWS managed CMK for EBS is used. If you specify a CMK, you must also set the encrypted state to <code>true</code>.</p> <p>You can specify a CMK using any of the following:</p> <ul> <li> <p>Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.</p> </li> <li> <p>Key alias. For example, alias/ExampleAlias.</p> </li> <li> <p>Key ARN. For example, arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.</p> </li> <li> <p>Alias ARN. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.</p> </li> </ul> <p>AWS authenticates the CMK asynchronously. Therefore, if you specify an identifier that is not valid, the action can appear to complete, but eventually fails.</p> <p>The specified CMK must exist in the destination Region.</p> <p>Amazon EBS does not support asymmetric CMKs.</p>
    pub kms_key_id: Option<String>,
    /// <p>The name of the new AMI in the destination Region.</p>
    pub name: String,
    /// <p>The ID of the AMI to copy.</p>
    pub source_image_id: String,
    /// <p>The name of the Region that contains the AMI to copy.</p>
    pub source_region: String,
}

/// Serialize `CopyImageRequest` contents to a `SignedRequest`.
struct CopyImageRequestSerializer;
impl CopyImageRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CopyImageRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.client_token {
            params.put(&format!("{}{}", prefix, "ClientToken"), &field_value);
        }
        if let Some(ref field_value) = obj.description {
            params.put(&format!("{}{}", prefix, "Description"), &field_value);
        }
        if let Some(ref field_value) = obj.destination_outpost_arn {
            params.put(
                &format!("{}{}", prefix, "DestinationOutpostArn"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.encrypted {
            params.put(&format!("{}{}", prefix, "Encrypted"), &field_value);
        }
        if let Some(ref field_value) = obj.kms_key_id {
            params.put(&format!("{}{}", prefix, "KmsKeyId"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "Name"), &obj.name);
        params.put(
            &format!("{}{}", prefix, "SourceImageId"),
            &obj.source_image_id,
        );
        params.put(&format!("{}{}", prefix, "SourceRegion"), &obj.source_region);
    }
}

/// <p>Contains the output of CopyImage.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CopyImageResult {
    /// <p>The ID of the new AMI.</p>
    pub image_id: Option<String>,
}

#[allow(dead_code)]
struct CopyImageResultDeserializer;
impl CopyImageResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CopyImageResult, XmlParseError> {
        deserialize_elements::<_, CopyImageResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "imageId" => {
                    obj.image_id = Some(StringDeserializer::deserialize("imageId", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CopySnapshotRequest {
    /// <p>A description for the EBS snapshot.</p>
    pub description: Option<String>,
    /// <p>The Amazon Resource Name (ARN) of the Outpost to which to copy the snapshot. Only specify this parameter when copying a snapshot from an AWS Region to an Outpost. The snapshot must be in the Region for the destination Outpost. You cannot copy a snapshot from an Outpost to a Region, from one Outpost to another, or within the same Outpost.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#copy-snapshots"> Copying snapshots from an AWS Region to an Outpost</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
    pub destination_outpost_arn: Option<String>,
    /// <p>The destination Region to use in the <code>PresignedUrl</code> parameter of a snapshot copy operation. This parameter is only valid for specifying the destination Region in a <code>PresignedUrl</code> parameter, where it is required.</p> <p>The snapshot copy is sent to the regional endpoint that you sent the HTTP request to (for example, <code>ec2.us-east-1.amazonaws.com</code>). With the AWS CLI, this is specified using the <code>--region</code> parameter or the default Region in your AWS configuration file.</p>
    pub destination_region: Option<String>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>To encrypt a copy of an unencrypted snapshot if encryption by default is not enabled, enable encryption using this parameter. Otherwise, omit this parameter. Encrypted snapshots are encrypted, even if you omit this parameter and encryption by default is not enabled. You cannot set this parameter to false. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
    pub encrypted: Option<bool>,
    /// <p>The identifier of the AWS Key Management Service (AWS KMS) customer master key (CMK) to use for Amazon EBS encryption. If this parameter is not specified, your AWS managed CMK for EBS is used. If <code>KmsKeyId</code> is specified, the encrypted state must be <code>true</code>.</p> <p>You can specify the CMK using any of the following:</p> <ul> <li> <p>Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.</p> </li> <li> <p>Key alias. For example, alias/ExampleAlias.</p> </li> <li> <p>Key ARN. For example, arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.</p> </li> <li> <p>Alias ARN. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.</p> </li> </ul> <p>AWS authenticates the CMK asynchronously. Therefore, if you specify an ID, alias, or ARN that is not valid, the action can appear to complete, but eventually fails.</p>
    pub kms_key_id: Option<String>,
    /// <p>When you copy an encrypted source snapshot using the Amazon EC2 Query API, you must supply a pre-signed URL. This parameter is optional for unencrypted snapshots. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html">Query requests</a>.</p> <p>The <code>PresignedUrl</code> should use the snapshot source endpoint, the <code>CopySnapshot</code> action, and include the <code>SourceRegion</code>, <code>SourceSnapshotId</code>, and <code>DestinationRegion</code> parameters. The <code>PresignedUrl</code> must be signed using AWS Signature Version 4. Because EBS snapshots are stored in Amazon S3, the signing algorithm for this parameter uses the same logic that is described in <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html">Authenticating Requests: Using Query Parameters (AWS Signature Version 4)</a> in the <i>Amazon Simple Storage Service API Reference</i>. An invalid or improperly signed <code>PresignedUrl</code> will cause the copy operation to fail asynchronously, and the snapshot will move to an <code>error</code> state.</p>
    pub presigned_url: Option<String>,
    /// <p>The ID of the Region that contains the snapshot to be copied.</p>
    pub source_region: String,
    /// <p>The ID of the EBS snapshot to copy.</p>
    pub source_snapshot_id: String,
    /// <p>The tags to apply to the new snapshot.</p>
    pub tag_specifications: Option<Vec<TagSpecification>>,
}

/// Serialize `CopySnapshotRequest` contents to a `SignedRequest`.
struct CopySnapshotRequestSerializer;
impl CopySnapshotRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CopySnapshotRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.description {
            params.put(&format!("{}{}", prefix, "Description"), &field_value);
        }
        if let Some(ref field_value) = obj.destination_outpost_arn {
            params.put(
                &format!("{}{}", prefix, "DestinationOutpostArn"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.destination_region {
            params.put(&format!("{}{}", prefix, "DestinationRegion"), &field_value);
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.encrypted {
            params.put(&format!("{}{}", prefix, "Encrypted"), &field_value);
        }
        if let Some(ref field_value) = obj.kms_key_id {
            params.put(&format!("{}{}", prefix, "KmsKeyId"), &field_value);
        }
        if let Some(ref field_value) = obj.presigned_url {
            params.put(&format!("{}{}", prefix, "PresignedUrl"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "SourceRegion"), &obj.source_region);
        params.put(
            &format!("{}{}", prefix, "SourceSnapshotId"),
            &obj.source_snapshot_id,
        );
        if let Some(ref field_value) = obj.tag_specifications {
            TagSpecificationListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagSpecification"),
                field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CopySnapshotResult {
    /// <p>The ID of the new snapshot.</p>
    pub snapshot_id: Option<String>,
    /// <p>Any tags applied to the new snapshot.</p>
    pub tags: Option<Vec<Tag>>,
}

#[allow(dead_code)]
struct CopySnapshotResultDeserializer;
impl CopySnapshotResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CopySnapshotResult, XmlParseError> {
        deserialize_elements::<_, CopySnapshotResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "snapshotId" => {
                    obj.snapshot_id = Some(StringDeserializer::deserialize("snapshotId", stack)?);
                }
                "tagSet" => {
                    obj.tags
                        .get_or_insert(vec![])
                        .extend(TagListDeserializer::deserialize("tagSet", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct CoreCountDeserializer;
impl CoreCountDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<i64, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, |s| Ok(i64::from_str(&s).unwrap()))
    }
}
#[allow(dead_code)]
struct CoreCountListDeserializer;
impl CoreCountListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<i64>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "item" {
                obj.push(CoreCountDeserializer::deserialize("item", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>The CPU options for the instance.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CpuOptions {
    /// <p>The number of CPU cores for the instance.</p>
    pub core_count: Option<i64>,
    /// <p>The number of threads per CPU core.</p>
    pub threads_per_core: Option<i64>,
}

#[allow(dead_code)]
struct CpuOptionsDeserializer;
impl CpuOptionsDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CpuOptions, XmlParseError> {
        deserialize_elements::<_, CpuOptions, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "coreCount" => {
                    obj.core_count = Some(IntegerDeserializer::deserialize("coreCount", stack)?);
                }
                "threadsPerCore" => {
                    obj.threads_per_core =
                        Some(IntegerDeserializer::deserialize("threadsPerCore", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>The CPU options for the instance. Both the core count and threads per core must be specified in the request.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CpuOptionsRequest {
    /// <p>The number of CPU cores for the instance.</p>
    pub core_count: Option<i64>,
    /// <p>The number of threads per CPU core. To disable multithreading for the instance, specify a value of <code>1</code>. Otherwise, specify the default value of <code>2</code>.</p>
    pub threads_per_core: Option<i64>,
}

/// Serialize `CpuOptionsRequest` contents to a `SignedRequest`.
struct CpuOptionsRequestSerializer;
impl CpuOptionsRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CpuOptionsRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.core_count {
            params.put(&format!("{}{}", prefix, "CoreCount"), &field_value);
        }
        if let Some(ref field_value) = obj.threads_per_core {
            params.put(&format!("{}{}", prefix, "ThreadsPerCore"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateCapacityReservationRequest {
    /// <p>The Availability Zone in which to create the Capacity Reservation.</p>
    pub availability_zone: Option<String>,
    /// <p>The ID of the Availability Zone in which to create the Capacity Reservation.</p>
    pub availability_zone_id: Option<String>,
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensure Idempotency</a>.</p>
    pub client_token: Option<String>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>Indicates whether the Capacity Reservation supports EBS-optimized instances. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS- optimized instance.</p>
    pub ebs_optimized: Option<bool>,
    /// <p>The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved capacity is released and you can no longer launch instances into it. The Capacity Reservation's state changes to <code>expired</code> when it reaches its end date and time.</p> <p>You must provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>limited</code>. Omit <code>EndDate</code> if <code>EndDateType</code> is <code>unlimited</code>.</p> <p>If the <code>EndDateType</code> is <code>limited</code>, the Capacity Reservation is cancelled within an hour from the specified time. For example, if you specify 5/31/2019, 13:30:55, the Capacity Reservation is guaranteed to end between 13:30:55 and 14:30:55 on 5/31/2019.</p>
    pub end_date: Option<String>,
    /// <p><p>Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following end types:</p> <ul> <li> <p> <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it. Do not provide an <code>EndDate</code> if the <code>EndDateType</code> is <code>unlimited</code>.</p> </li> <li> <p> <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time. You must provide an <code>EndDate</code> value if the <code>EndDateType</code> value is <code>limited</code>.</p> </li> </ul></p>
    pub end_date_type: Option<String>,
    /// <p>Indicates whether the Capacity Reservation supports instances with temporary, block-level storage.</p>
    pub ephemeral_storage: Option<bool>,
    /// <p>The number of instances for which to reserve capacity.</p>
    pub instance_count: i64,
    /// <p>Indicates the type of instance launches that the Capacity Reservation accepts. The options include:</p> <ul> <li> <p> <code>open</code> - The Capacity Reservation automatically matches all instances that have matching attributes (instance type, platform, and Availability Zone). Instances that have matching attributes run in the Capacity Reservation automatically without specifying any additional parameters.</p> </li> <li> <p> <code>targeted</code> - The Capacity Reservation only accepts instances that have matching attributes (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This ensures that only permitted instances can use the reserved capacity. </p> </li> </ul> <p>Default: <code>open</code> </p>
    pub instance_match_criteria: Option<String>,
    /// <p>The type of operating system for which to reserve capacity.</p>
    pub instance_platform: String,
    /// <p>The instance type for which to reserve capacity. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the <i>Amazon EC2 User Guide</i>.</p>
    pub instance_type: String,
    /// <p>The Amazon Resource Name (ARN) of the Outpost on which to create the Capacity Reservation.</p>
    pub outpost_arn: Option<String>,
    /// <p>The tags to apply to the Capacity Reservation during launch.</p>
    pub tag_specifications: Option<Vec<TagSpecification>>,
    /// <p><p>Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following tenancy settings:</p> <ul> <li> <p> <code>default</code> - The Capacity Reservation is created on hardware that is shared with other AWS accounts.</p> </li> <li> <p> <code>dedicated</code> - The Capacity Reservation is created on single-tenant hardware that is dedicated to a single AWS account.</p> </li> </ul></p>
    pub tenancy: Option<String>,
}

/// Serialize `CreateCapacityReservationRequest` contents to a `SignedRequest`.
struct CreateCapacityReservationRequestSerializer;
impl CreateCapacityReservationRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateCapacityReservationRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.availability_zone {
            params.put(&format!("{}{}", prefix, "AvailabilityZone"), &field_value);
        }
        if let Some(ref field_value) = obj.availability_zone_id {
            params.put(&format!("{}{}", prefix, "AvailabilityZoneId"), &field_value);
        }
        if let Some(ref field_value) = obj.client_token {
            params.put(&format!("{}{}", prefix, "ClientToken"), &field_value);
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.ebs_optimized {
            params.put(&format!("{}{}", prefix, "EbsOptimized"), &field_value);
        }
        if let Some(ref field_value) = obj.end_date {
            params.put(&format!("{}{}", prefix, "EndDate"), &field_value);
        }
        if let Some(ref field_value) = obj.end_date_type {
            params.put(&format!("{}{}", prefix, "EndDateType"), &field_value);
        }
        if let Some(ref field_value) = obj.ephemeral_storage {
            params.put(&format!("{}{}", prefix, "EphemeralStorage"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "InstanceCount"),
            &obj.instance_count,
        );
        if let Some(ref field_value) = obj.instance_match_criteria {
            params.put(
                &format!("{}{}", prefix, "InstanceMatchCriteria"),
                &field_value,
            );
        }
        params.put(
            &format!("{}{}", prefix, "InstancePlatform"),
            &obj.instance_platform,
        );
        params.put(&format!("{}{}", prefix, "InstanceType"), &obj.instance_type);
        if let Some(ref field_value) = obj.outpost_arn {
            params.put(&format!("{}{}", prefix, "OutpostArn"), &field_value);
        }
        if let Some(ref field_value) = obj.tag_specifications {
            TagSpecificationListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagSpecifications"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.tenancy {
            params.put(&format!("{}{}", prefix, "Tenancy"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateCapacityReservationResult {
    /// <p>Information about the Capacity Reservation.</p>
    pub capacity_reservation: Option<CapacityReservation>,
}

#[allow(dead_code)]
struct CreateCapacityReservationResultDeserializer;
impl CreateCapacityReservationResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateCapacityReservationResult, XmlParseError> {
        deserialize_elements::<_, CreateCapacityReservationResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "capacityReservation" => {
                        obj.capacity_reservation =
                            Some(CapacityReservationDeserializer::deserialize(
                                "capacityReservation",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateCarrierGatewayRequest {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure Idempotency</a>.</p>
    pub client_token: Option<String>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The tags to associate with the carrier gateway.</p>
    pub tag_specifications: Option<Vec<TagSpecification>>,
    /// <p>The ID of the VPC to associate with the carrier gateway.</p>
    pub vpc_id: String,
}

/// Serialize `CreateCarrierGatewayRequest` contents to a `SignedRequest`.
struct CreateCarrierGatewayRequestSerializer;
impl CreateCarrierGatewayRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateCarrierGatewayRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.client_token {
            params.put(&format!("{}{}", prefix, "ClientToken"), &field_value);
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.tag_specifications {
            TagSpecificationListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagSpecification"),
                field_value,
            );
        }
        params.put(&format!("{}{}", prefix, "VpcId"), &obj.vpc_id);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateCarrierGatewayResult {
    /// <p>Information about the carrier gateway.</p>
    pub carrier_gateway: Option<CarrierGateway>,
}

#[allow(dead_code)]
struct CreateCarrierGatewayResultDeserializer;
impl CreateCarrierGatewayResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateCarrierGatewayResult, XmlParseError> {
        deserialize_elements::<_, CreateCarrierGatewayResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "carrierGateway" => {
                        obj.carrier_gateway = Some(CarrierGatewayDeserializer::deserialize(
                            "carrierGateway",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateClientVpnEndpointRequest {
    /// <p>Information about the authentication method to be used to authenticate clients.</p>
    pub authentication_options: Vec<ClientVpnAuthenticationRequest>,
    /// <p>The IPv4 address range, in CIDR notation, from which to assign client IP addresses. The address range cannot overlap with the local CIDR of the VPC in which the associated subnet is located, or the routes that you add manually. The address range cannot be changed after the Client VPN endpoint has been created. The CIDR block should be /22 or greater.</p>
    pub client_cidr_block: String,
    /// <p>The options for managing connection authorization for new client connections.</p>
    pub client_connect_options: Option<ClientConnectOptions>,
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure Idempotency</a>.</p>
    pub client_token: Option<String>,
    /// <p><p>Information about the client connection logging options.</p> <p>If you enable client connection logging, data about client connections is sent to a Cloudwatch Logs log stream. The following information is logged:</p> <ul> <li> <p>Client connection requests</p> </li> <li> <p>Client connection results (successful and unsuccessful)</p> </li> <li> <p>Reasons for unsuccessful client connection requests</p> </li> <li> <p>Client connection termination time</p> </li> </ul></p>
    pub connection_log_options: ConnectionLogOptions,
    /// <p>A brief description of the Client VPN endpoint.</p>
    pub description: Option<String>,
    /// <p>Information about the DNS servers to be used for DNS resolution. A Client VPN endpoint can have up to two DNS servers. If no DNS server is specified, the DNS address configured on the device is used for the DNS server.</p>
    pub dns_servers: Option<Vec<String>>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The IDs of one or more security groups to apply to the target network. You must also specify the ID of the VPC that contains the security groups.</p>
    pub security_group_ids: Option<Vec<String>>,
    /// <p>Specify whether to enable the self-service portal for the Client VPN endpoint.</p> <p>Default Value: <code>enabled</code> </p>
    pub self_service_portal: Option<String>,
    /// <p>The ARN of the server certificate. For more information, see the <a href="https://docs.aws.amazon.com/acm/latest/userguide/">AWS Certificate Manager User Guide</a>.</p>
    pub server_certificate_arn: String,
    /// <p>Indicates whether split-tunnel is enabled on the AWS Client VPN endpoint.</p> <p>By default, split-tunnel on a VPN endpoint is disabled.</p> <p>For information about split-tunnel VPN endpoints, see <a href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html">Split-Tunnel AWS Client VPN Endpoint</a> in the <i>AWS Client VPN Administrator Guide</i>.</p>
    pub split_tunnel: Option<bool>,
    /// <p>The tags to apply to the Client VPN endpoint during creation.</p>
    pub tag_specifications: Option<Vec<TagSpecification>>,
    /// <p>The transport protocol to be used by the VPN session.</p> <p>Default value: <code>udp</code> </p>
    pub transport_protocol: Option<String>,
    /// <p>The ID of the VPC to associate with the Client VPN endpoint. If no security group IDs are specified in the request, the default security group for the VPC is applied.</p>
    pub vpc_id: Option<String>,
    /// <p>The port number to assign to the Client VPN endpoint for TCP and UDP traffic.</p> <p>Valid Values: <code>443</code> | <code>1194</code> </p> <p>Default Value: <code>443</code> </p>
    pub vpn_port: Option<i64>,
}

/// Serialize `CreateClientVpnEndpointRequest` contents to a `SignedRequest`.
struct CreateClientVpnEndpointRequestSerializer;
impl CreateClientVpnEndpointRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateClientVpnEndpointRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        ClientVpnAuthenticationRequestListSerializer::serialize(
            params,
            &format!("{}{}", prefix, "Authentication"),
            &obj.authentication_options,
        );
        params.put(
            &format!("{}{}", prefix, "ClientCidrBlock"),
            &obj.client_cidr_block,
        );
        if let Some(ref field_value) = obj.client_connect_options {
            ClientConnectOptionsSerializer::serialize(
                params,
                &format!("{}{}", prefix, "ClientConnectOptions"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.client_token {
            params.put(&format!("{}{}", prefix, "ClientToken"), &field_value);
        }
        ConnectionLogOptionsSerializer::serialize(
            params,
            &format!("{}{}", prefix, "ConnectionLogOptions"),
            &obj.connection_log_options,
        );
        if let Some(ref field_value) = obj.description {
            params.put(&format!("{}{}", prefix, "Description"), &field_value);
        }
        if let Some(ref field_value) = obj.dns_servers {
            ValueStringListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "DnsServers"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.security_group_ids {
            ClientVpnSecurityGroupIdSetSerializer::serialize(
                params,
                &format!("{}{}", prefix, "SecurityGroupId"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.self_service_portal {
            params.put(&format!("{}{}", prefix, "SelfServicePortal"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "ServerCertificateArn"),
            &obj.server_certificate_arn,
        );
        if let Some(ref field_value) = obj.split_tunnel {
            params.put(&format!("{}{}", prefix, "SplitTunnel"), &field_value);
        }
        if let Some(ref field_value) = obj.tag_specifications {
            TagSpecificationListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagSpecification"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.transport_protocol {
            params.put(&format!("{}{}", prefix, "TransportProtocol"), &field_value);
        }
        if let Some(ref field_value) = obj.vpc_id {
            params.put(&format!("{}{}", prefix, "VpcId"), &field_value);
        }
        if let Some(ref field_value) = obj.vpn_port {
            params.put(&format!("{}{}", prefix, "VpnPort"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateClientVpnEndpointResult {
    /// <p>The ID of the Client VPN endpoint.</p>
    pub client_vpn_endpoint_id: Option<String>,
    /// <p>The DNS name to be used by clients when establishing their VPN session.</p>
    pub dns_name: Option<String>,
    /// <p>The current state of the Client VPN endpoint.</p>
    pub status: Option<ClientVpnEndpointStatus>,
}

#[allow(dead_code)]
struct CreateClientVpnEndpointResultDeserializer;
impl CreateClientVpnEndpointResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateClientVpnEndpointResult, XmlParseError> {
        deserialize_elements::<_, CreateClientVpnEndpointResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "clientVpnEndpointId" => {
                        obj.client_vpn_endpoint_id = Some(StringDeserializer::deserialize(
                            "clientVpnEndpointId",
                            stack,
                        )?);
                    }
                    "dnsName" => {
                        obj.dns_name = Some(StringDeserializer::deserialize("dnsName", stack)?);
                    }
                    "status" => {
                        obj.status = Some(ClientVpnEndpointStatusDeserializer::deserialize(
                            "status", stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateClientVpnRouteRequest {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure Idempotency</a>.</p>
    pub client_token: Option<String>,
    /// <p>The ID of the Client VPN endpoint to which to add the route.</p>
    pub client_vpn_endpoint_id: String,
    /// <p>A brief description of the route.</p>
    pub description: Option<String>,
    /// <p><p>The IPv4 address range, in CIDR notation, of the route destination. For example:</p> <ul> <li> <p>To add a route for Internet access, enter <code>0.0.0.0/0</code> </p> </li> <li> <p>To add a route for a peered VPC, enter the peered VPC&#39;s IPv4 CIDR range</p> </li> <li> <p>To add a route for an on-premises network, enter the AWS Site-to-Site VPN connection&#39;s IPv4 CIDR range</p> </li> <li> <p>To add a route for the local network, enter the client CIDR range</p> </li> </ul></p>
    pub destination_cidr_block: String,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the subnet through which you want to route traffic. The specified subnet must be an existing target network of the Client VPN endpoint.</p> <p>Alternatively, if you're adding a route for the local network, specify <code>local</code>.</p>
    pub target_vpc_subnet_id: String,
}

/// Serialize `CreateClientVpnRouteRequest` contents to a `SignedRequest`.
struct CreateClientVpnRouteRequestSerializer;
impl CreateClientVpnRouteRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateClientVpnRouteRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.client_token {
            params.put(&format!("{}{}", prefix, "ClientToken"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "ClientVpnEndpointId"),
            &obj.client_vpn_endpoint_id,
        );
        if let Some(ref field_value) = obj.description {
            params.put(&format!("{}{}", prefix, "Description"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "DestinationCidrBlock"),
            &obj.destination_cidr_block,
        );
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "TargetVpcSubnetId"),
            &obj.target_vpc_subnet_id,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateClientVpnRouteResult {
    /// <p>The current state of the route.</p>
    pub status: Option<ClientVpnRouteStatus>,
}

#[allow(dead_code)]
struct CreateClientVpnRouteResultDeserializer;
impl CreateClientVpnRouteResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateClientVpnRouteResult, XmlParseError> {
        deserialize_elements::<_, CreateClientVpnRouteResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "status" => {
                        obj.status = Some(ClientVpnRouteStatusDeserializer::deserialize(
                            "status", stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Contains the parameters for CreateCustomerGateway.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateCustomerGatewayRequest {
    /// <p>For devices that support BGP, the customer gateway's BGP ASN.</p> <p>Default: 65000</p>
    pub bgp_asn: i64,
    /// <p>The Amazon Resource Name (ARN) for the customer gateway certificate.</p>
    pub certificate_arn: Option<String>,
    /// <p>A name for the customer gateway device.</p> <p>Length Constraints: Up to 255 characters.</p>
    pub device_name: Option<String>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The Internet-routable IP address for the customer gateway's outside interface. The address must be static.</p>
    pub public_ip: Option<String>,
    /// <p>The tags to apply to the customer gateway.</p>
    pub tag_specifications: Option<Vec<TagSpecification>>,
    /// <p>The type of VPN connection that this customer gateway supports (<code>ipsec.1</code>).</p>
    pub type_: String,
}

/// Serialize `CreateCustomerGatewayRequest` contents to a `SignedRequest`.
struct CreateCustomerGatewayRequestSerializer;
impl CreateCustomerGatewayRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateCustomerGatewayRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "BgpAsn"), &obj.bgp_asn);
        if let Some(ref field_value) = obj.certificate_arn {
            params.put(&format!("{}{}", prefix, "CertificateArn"), &field_value);
        }
        if let Some(ref field_value) = obj.device_name {
            params.put(&format!("{}{}", prefix, "DeviceName"), &field_value);
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.public_ip {
            params.put(&format!("{}{}", prefix, "IpAddress"), &field_value);
        }
        if let Some(ref field_value) = obj.tag_specifications {
            TagSpecificationListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagSpecification"),
                field_value,
            );
        }
        params.put(&format!("{}{}", prefix, "Type"), &obj.type_);
    }
}

/// <p>Contains the output of CreateCustomerGateway.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateCustomerGatewayResult {
    /// <p>Information about the customer gateway.</p>
    pub customer_gateway: Option<CustomerGateway>,
}

#[allow(dead_code)]
struct CreateCustomerGatewayResultDeserializer;
impl CreateCustomerGatewayResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateCustomerGatewayResult, XmlParseError> {
        deserialize_elements::<_, CreateCustomerGatewayResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "customerGateway" => {
                        obj.customer_gateway = Some(CustomerGatewayDeserializer::deserialize(
                            "customerGateway",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateDefaultSubnetRequest {
    /// <p>The Availability Zone in which to create the default subnet.</p>
    pub availability_zone: String,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
}

/// Serialize `CreateDefaultSubnetRequest` contents to a `SignedRequest`.
struct CreateDefaultSubnetRequestSerializer;
impl CreateDefaultSubnetRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateDefaultSubnetRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "AvailabilityZone"),
            &obj.availability_zone,
        );
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateDefaultSubnetResult {
    /// <p>Information about the subnet.</p>
    pub subnet: Option<Subnet>,
}

#[allow(dead_code)]
struct CreateDefaultSubnetResultDeserializer;
impl CreateDefaultSubnetResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateDefaultSubnetResult, XmlParseError> {
        deserialize_elements::<_, CreateDefaultSubnetResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "subnet" => {
                        obj.subnet = Some(SubnetDeserializer::deserialize("subnet", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateDefaultVpcRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
}

/// Serialize `CreateDefaultVpcRequest` contents to a `SignedRequest`.
struct CreateDefaultVpcRequestSerializer;
impl CreateDefaultVpcRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateDefaultVpcRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateDefaultVpcResult {
    /// <p>Information about the VPC.</p>
    pub vpc: Option<Vpc>,
}

#[allow(dead_code)]
struct CreateDefaultVpcResultDeserializer;
impl CreateDefaultVpcResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateDefaultVpcResult, XmlParseError> {
        deserialize_elements::<_, CreateDefaultVpcResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "vpc" => {
                    obj.vpc = Some(VpcDeserializer::deserialize("vpc", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateDhcpOptionsRequest {
    /// <p>A DHCP configuration option.</p>
    pub dhcp_configurations: Vec<NewDhcpConfiguration>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The tags to assign to the DHCP option.</p>
    pub tag_specifications: Option<Vec<TagSpecification>>,
}

/// Serialize `CreateDhcpOptionsRequest` contents to a `SignedRequest`.
struct CreateDhcpOptionsRequestSerializer;
impl CreateDhcpOptionsRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateDhcpOptionsRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        NewDhcpConfigurationListSerializer::serialize(
            params,
            &format!("{}{}", prefix, "DhcpConfiguration"),
            &obj.dhcp_configurations,
        );
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.tag_specifications {
            TagSpecificationListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagSpecification"),
                field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateDhcpOptionsResult {
    /// <p>A set of DHCP options.</p>
    pub dhcp_options: Option<DhcpOptions>,
}

#[allow(dead_code)]
struct CreateDhcpOptionsResultDeserializer;
impl CreateDhcpOptionsResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateDhcpOptionsResult, XmlParseError> {
        deserialize_elements::<_, CreateDhcpOptionsResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "dhcpOptions" => {
                        obj.dhcp_options =
                            Some(DhcpOptionsDeserializer::deserialize("dhcpOptions", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateEgressOnlyInternetGatewayRequest {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure Idempotency</a>.</p>
    pub client_token: Option<String>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The tags to assign to the egress-only internet gateway.</p>
    pub tag_specifications: Option<Vec<TagSpecification>>,
    /// <p>The ID of the VPC for which to create the egress-only internet gateway.</p>
    pub vpc_id: String,
}

/// Serialize `CreateEgressOnlyInternetGatewayRequest` contents to a `SignedRequest`.
struct CreateEgressOnlyInternetGatewayRequestSerializer;
impl CreateEgressOnlyInternetGatewayRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateEgressOnlyInternetGatewayRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.client_token {
            params.put(&format!("{}{}", prefix, "ClientToken"), &field_value);
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.tag_specifications {
            TagSpecificationListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagSpecification"),
                field_value,
            );
        }
        params.put(&format!("{}{}", prefix, "VpcId"), &obj.vpc_id);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateEgressOnlyInternetGatewayResult {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub client_token: Option<String>,
    /// <p>Information about the egress-only internet gateway.</p>
    pub egress_only_internet_gateway: Option<EgressOnlyInternetGateway>,
}

#[allow(dead_code)]
struct CreateEgressOnlyInternetGatewayResultDeserializer;
impl CreateEgressOnlyInternetGatewayResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateEgressOnlyInternetGatewayResult, XmlParseError> {
        deserialize_elements::<_, CreateEgressOnlyInternetGatewayResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "clientToken" => {
                        obj.client_token =
                            Some(StringDeserializer::deserialize("clientToken", stack)?);
                    }
                    "egressOnlyInternetGateway" => {
                        obj.egress_only_internet_gateway =
                            Some(EgressOnlyInternetGatewayDeserializer::deserialize(
                                "egressOnlyInternetGateway",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Describes the instances that could not be launched by the fleet.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct EC2CreateFleetError {
    /// <p>The error code that indicates why the instance could not be launched. For more information about error codes, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html.html">Error Codes</a>.</p>
    pub error_code: Option<String>,
    /// <p>The error message that describes why the instance could not be launched. For more information about error messages, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html.html">Error Codes</a>.</p>
    pub error_message: Option<String>,
    /// <p>The launch templates and overrides that were used for launching the instances. The values that you specify in the Overrides replace the values in the launch template.</p>
    pub launch_template_and_overrides: Option<LaunchTemplateAndOverridesResponse>,
    /// <p>Indicates if the instance that could not be launched was a Spot Instance or On-Demand Instance.</p>
    pub lifecycle: Option<String>,
}

#[allow(dead_code)]
struct EC2CreateFleetErrorDeserializer;
impl EC2CreateFleetErrorDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<EC2CreateFleetError, XmlParseError> {
        deserialize_elements::<_, EC2CreateFleetError, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "errorCode" => {
                    obj.error_code = Some(StringDeserializer::deserialize("errorCode", stack)?);
                }
                "errorMessage" => {
                    obj.error_message =
                        Some(StringDeserializer::deserialize("errorMessage", stack)?);
                }
                "launchTemplateAndOverrides" => {
                    obj.launch_template_and_overrides =
                        Some(LaunchTemplateAndOverridesResponseDeserializer::deserialize(
                            "launchTemplateAndOverrides",
                            stack,
                        )?);
                }
                "lifecycle" => {
                    obj.lifecycle = Some(InstanceLifecycleDeserializer::deserialize(
                        "lifecycle",
                        stack,
                    )?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct CreateFleetErrorsSetDeserializer;
impl CreateFleetErrorsSetDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<EC2CreateFleetError>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "item" {
                obj.push(EC2CreateFleetErrorDeserializer::deserialize("item", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Describes the instances that were launched by the fleet.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateFleetInstance {
    /// <p>The IDs of the instances.</p>
    pub instance_ids: Option<Vec<String>>,
    /// <p>The instance type.</p>
    pub instance_type: Option<String>,
    /// <p>The launch templates and overrides that were used for launching the instances. The values that you specify in the Overrides replace the values in the launch template.</p>
    pub launch_template_and_overrides: Option<LaunchTemplateAndOverridesResponse>,
    /// <p>Indicates if the instance that was launched is a Spot Instance or On-Demand Instance.</p>
    pub lifecycle: Option<String>,
    /// <p>The value is <code>Windows</code> for Windows instances. Otherwise, the value is blank.</p>
    pub platform: Option<String>,
}

#[allow(dead_code)]
struct CreateFleetInstanceDeserializer;
impl CreateFleetInstanceDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateFleetInstance, XmlParseError> {
        deserialize_elements::<_, CreateFleetInstance, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "instanceIds" => {
                    obj.instance_ids.get_or_insert(vec![]).extend(
                        InstanceIdsSetDeserializer::deserialize("instanceIds", stack)?,
                    );
                }
                "instanceType" => {
                    obj.instance_type = Some(InstanceTypeDeserializer::deserialize(
                        "instanceType",
                        stack,
                    )?);
                }
                "launchTemplateAndOverrides" => {
                    obj.launch_template_and_overrides =
                        Some(LaunchTemplateAndOverridesResponseDeserializer::deserialize(
                            "launchTemplateAndOverrides",
                            stack,
                        )?);
                }
                "lifecycle" => {
                    obj.lifecycle = Some(InstanceLifecycleDeserializer::deserialize(
                        "lifecycle",
                        stack,
                    )?);
                }
                "platform" => {
                    obj.platform =
                        Some(PlatformValuesDeserializer::deserialize("platform", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct CreateFleetInstancesSetDeserializer;
impl CreateFleetInstancesSetDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<CreateFleetInstance>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "item" {
                obj.push(CreateFleetInstanceDeserializer::deserialize("item", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateFleetRequest {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
    pub client_token: Option<String>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>Indicates whether running instances should be terminated if the total target capacity of the EC2 Fleet is decreased below the current size of the EC2 Fleet.</p>
    pub excess_capacity_termination_policy: Option<String>,
    /// <p>The configuration for the EC2 Fleet.</p>
    pub launch_template_configs: Vec<FleetLaunchTemplateConfigRequest>,
    /// <p>Describes the configuration of On-Demand Instances in an EC2 Fleet.</p>
    pub on_demand_options: Option<OnDemandOptionsRequest>,
    /// <p>Indicates whether EC2 Fleet should replace unhealthy Spot Instances. Supported only for fleets of type <code>maintain</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#ec2-fleet-health-checks">EC2 Fleet health checks</a> in the <i>Amazon EC2 User Guide</i>.</p>
    pub replace_unhealthy_instances: Option<bool>,
    /// <p>Describes the configuration of Spot Instances in an EC2 Fleet.</p>
    pub spot_options: Option<SpotOptionsRequest>,
    /// <p>The key-value pair for tagging the EC2 Fleet request on creation. The value for <code>ResourceType</code> must be <code>fleet</code>, otherwise the fleet request fails. To tag instances at launch, specify the tags in the <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template">launch template</a>. For information about tagging after launch, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources">Tagging your resources</a>.</p>
    pub tag_specifications: Option<Vec<TagSpecification>>,
    /// <p>The number of units to request.</p>
    pub target_capacity_specification: TargetCapacitySpecificationRequest,
    /// <p>Indicates whether running instances should be terminated when the EC2 Fleet expires.</p>
    pub terminate_instances_with_expiration: Option<bool>,
    /// <p>The type of request. The default value is <code>maintain</code>.</p> <ul> <li> <p> <code>maintain</code> - The EC2 Fleet places an asynchronous request for your desired capacity, and continues to maintain your desired Spot capacity by replenishing interrupted Spot Instances.</p> </li> <li> <p> <code>request</code> - The EC2 Fleet places an asynchronous one-time request for your desired capacity, but does submit Spot requests in alternative capacity pools if Spot capacity is unavailable, and does not maintain Spot capacity if Spot Instances are interrupted.</p> </li> <li> <p> <code>instant</code> - The EC2 Fleet places a synchronous one-time request for your desired capacity, and returns errors for any instances that could not be launched.</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-configuration-strategies.html#ec2-fleet-request-type">EC2 Fleet request types</a> in the <i>Amazon EC2 User Guide</i>.</p>
    pub type_: Option<String>,
    /// <p>The start date and time of the request, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). The default is to start fulfilling the request immediately.</p>
    pub valid_from: Option<String>,
    /// <p>The end date and time of the request, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). At this point, no new EC2 Fleet requests are placed or able to fulfill the request. If no value is specified, the request remains until you cancel it.</p>
    pub valid_until: Option<String>,
}

/// Serialize `CreateFleetRequest` contents to a `SignedRequest`.
struct CreateFleetRequestSerializer;
impl CreateFleetRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateFleetRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.client_token {
            params.put(&format!("{}{}", prefix, "ClientToken"), &field_value);
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.excess_capacity_termination_policy {
            params.put(
                &format!("{}{}", prefix, "ExcessCapacityTerminationPolicy"),
                &field_value,
            );
        }
        FleetLaunchTemplateConfigListRequestSerializer::serialize(
            params,
            &format!("{}{}", prefix, "LaunchTemplateConfigs"),
            &obj.launch_template_configs,
        );
        if let Some(ref field_value) = obj.on_demand_options {
            OnDemandOptionsRequestSerializer::serialize(
                params,
                &format!("{}{}", prefix, "OnDemandOptions"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.replace_unhealthy_instances {
            params.put(
                &format!("{}{}", prefix, "ReplaceUnhealthyInstances"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.spot_options {
            SpotOptionsRequestSerializer::serialize(
                params,
                &format!("{}{}", prefix, "SpotOptions"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.tag_specifications {
            TagSpecificationListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagSpecification"),
                field_value,
            );
        }
        TargetCapacitySpecificationRequestSerializer::serialize(
            params,
            &format!("{}{}", prefix, "TargetCapacitySpecification"),
            &obj.target_capacity_specification,
        );
        if let Some(ref field_value) = obj.terminate_instances_with_expiration {
            params.put(
                &format!("{}{}", prefix, "TerminateInstancesWithExpiration"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.type_ {
            params.put(&format!("{}{}", prefix, "Type"), &field_value);
        }
        if let Some(ref field_value) = obj.valid_from {
            params.put(&format!("{}{}", prefix, "ValidFrom"), &field_value);
        }
        if let Some(ref field_value) = obj.valid_until {
            params.put(&format!("{}{}", prefix, "ValidUntil"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateFleetResult {
    /// <p>Information about the instances that could not be launched by the fleet. Valid only when <b>Type</b> is set to <code>instant</code>.</p>
    pub errors: Option<Vec<EC2CreateFleetError>>,
    /// <p>The ID of the EC2 Fleet.</p>
    pub fleet_id: Option<String>,
    /// <p>Information about the instances that were launched by the fleet. Valid only when <b>Type</b> is set to <code>instant</code>.</p>
    pub instances: Option<Vec<CreateFleetInstance>>,
}

#[allow(dead_code)]
struct CreateFleetResultDeserializer;
impl CreateFleetResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateFleetResult, XmlParseError> {
        deserialize_elements::<_, CreateFleetResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "errorSet" => {
                    obj.errors.get_or_insert(vec![]).extend(
                        CreateFleetErrorsSetDeserializer::deserialize("errorSet", stack)?,
                    );
                }
                "fleetId" => {
                    obj.fleet_id = Some(FleetIdDeserializer::deserialize("fleetId", stack)?);
                }
                "fleetInstanceSet" => {
                    obj.instances.get_or_insert(vec![]).extend(
                        CreateFleetInstancesSetDeserializer::deserialize(
                            "fleetInstanceSet",
                            stack,
                        )?,
                    );
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateFlowLogsRequest {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure Idempotency</a>.</p>
    pub client_token: Option<String>,
    /// <p>The ARN for the IAM role that permits Amazon EC2 to publish flow logs to a CloudWatch Logs log group in your account.</p> <p>If you specify <code>LogDestinationType</code> as <code>s3</code>, do not specify <code>DeliverLogsPermissionArn</code> or <code>LogGroupName</code>.</p>
    pub deliver_logs_permission_arn: Option<String>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>Specifies the destination to which the flow log data is to be published. Flow log data can be published to a CloudWatch Logs log group or an Amazon S3 bucket. The value specified for this parameter depends on the value specified for <code>LogDestinationType</code>.</p> <p>If <code>LogDestinationType</code> is not specified or <code>cloud-watch-logs</code>, specify the Amazon Resource Name (ARN) of the CloudWatch Logs log group. For example, to publish to a log group called <code>my-logs</code>, specify <code>arn:aws:logs:us-east-1:123456789012:log-group:my-logs</code>. Alternatively, use <code>LogGroupName</code> instead.</p> <p>If LogDestinationType is <code>s3</code>, specify the ARN of the Amazon S3 bucket. You can also specify a subfolder in the bucket. To specify a subfolder in the bucket, use the following ARN format: <code>bucket_ARN/subfolder_name/</code>. For example, to specify a subfolder named <code>my-logs</code> in a bucket named <code>my-bucket</code>, use the following ARN: <code>arn:aws:s3:::my-bucket/my-logs/</code>. You cannot use <code>AWSLogs</code> as a subfolder name. This is a reserved term.</p>
    pub log_destination: Option<String>,
    /// <p>Specifies the type of destination to which the flow log data is to be published. Flow log data can be published to CloudWatch Logs or Amazon S3. To publish flow log data to CloudWatch Logs, specify <code>cloud-watch-logs</code>. To publish flow log data to Amazon S3, specify <code>s3</code>.</p> <p>If you specify <code>LogDestinationType</code> as <code>s3</code>, do not specify <code>DeliverLogsPermissionArn</code> or <code>LogGroupName</code>.</p> <p>Default: <code>cloud-watch-logs</code> </p>
    pub log_destination_type: Option<String>,
    /// <p>The fields to include in the flow log record, in the order in which they should appear. For a list of available fields, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html#flow-log-records">Flow Log Records</a>. If you omit this parameter, the flow log is created using the default format. If you specify this parameter, you must specify at least one field.</p> <p>Specify the fields using the <code>${field-id}</code> format, separated by spaces. For the AWS CLI, use single quotation marks (' ') to surround the parameter value.</p>
    pub log_format: Option<String>,
    /// <p>The name of a new or existing CloudWatch Logs log group where Amazon EC2 publishes your flow logs.</p> <p>If you specify <code>LogDestinationType</code> as <code>s3</code>, do not specify <code>DeliverLogsPermissionArn</code> or <code>LogGroupName</code>.</p>
    pub log_group_name: Option<String>,
    /// <p>The maximum interval of time during which a flow of packets is captured and aggregated into a flow log record. You can specify 60 seconds (1 minute) or 600 seconds (10 minutes).</p> <p>When a network interface is attached to a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Nitro-based instance</a>, the aggregation interval is always 60 seconds or less, regardless of the value that you specify.</p> <p>Default: 600</p>
    pub max_aggregation_interval: Option<i64>,
    /// <p>The ID of the subnet, network interface, or VPC for which you want to create a flow log.</p> <p>Constraints: Maximum of 1000 resources</p>
    pub resource_ids: Vec<String>,
    /// <p>The type of resource for which to create the flow log. For example, if you specified a VPC ID for the <code>ResourceId</code> property, specify <code>VPC</code> for this property.</p>
    pub resource_type: String,
    /// <p>The tags to apply to the flow logs.</p>
    pub tag_specifications: Option<Vec<TagSpecification>>,
    /// <p>The type of traffic to log. You can log traffic that the resource accepts or rejects, or all traffic.</p>
    pub traffic_type: String,
}

/// Serialize `CreateFlowLogsRequest` contents to a `SignedRequest`.
struct CreateFlowLogsRequestSerializer;
impl CreateFlowLogsRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateFlowLogsRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.client_token {
            params.put(&format!("{}{}", prefix, "ClientToken"), &field_value);
        }
        if let Some(ref field_value) = obj.deliver_logs_permission_arn {
            params.put(
                &format!("{}{}", prefix, "DeliverLogsPermissionArn"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.log_destination {
            params.put(&format!("{}{}", prefix, "LogDestination"), &field_value);
        }
        if let Some(ref field_value) = obj.log_destination_type {
            params.put(&format!("{}{}", prefix, "LogDestinationType"), &field_value);
        }
        if let Some(ref field_value) = obj.log_format {
            params.put(&format!("{}{}", prefix, "LogFormat"), &field_value);
        }
        if let Some(ref field_value) = obj.log_group_name {
            params.put(&format!("{}{}", prefix, "LogGroupName"), &field_value);
        }
        if let Some(ref field_value) = obj.max_aggregation_interval {
            params.put(
                &format!("{}{}", prefix, "MaxAggregationInterval"),
                &field_value,
            );
        }
        FlowLogResourceIdsSerializer::serialize(
            params,
            &format!("{}{}", prefix, "ResourceId"),
            &obj.resource_ids,
        );
        params.put(&format!("{}{}", prefix, "ResourceType"), &obj.resource_type);
        if let Some(ref field_value) = obj.tag_specifications {
            TagSpecificationListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagSpecification"),
                field_value,
            );
        }
        params.put(&format!("{}{}", prefix, "TrafficType"), &obj.traffic_type);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateFlowLogsResult {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub client_token: Option<String>,
    /// <p>The IDs of the flow logs.</p>
    pub flow_log_ids: Option<Vec<String>>,
    /// <p>Information about the flow logs that could not be created successfully.</p>
    pub unsuccessful: Option<Vec<UnsuccessfulItem>>,
}

#[allow(dead_code)]
struct CreateFlowLogsResultDeserializer;
impl CreateFlowLogsResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateFlowLogsResult, XmlParseError> {
        deserialize_elements::<_, CreateFlowLogsResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "clientToken" => {
                    obj.client_token = Some(StringDeserializer::deserialize("clientToken", stack)?);
                }
                "flowLogIdSet" => {
                    obj.flow_log_ids.get_or_insert(vec![]).extend(
                        ValueStringListDeserializer::deserialize("flowLogIdSet", stack)?,
                    );
                }
                "unsuccessful" => {
                    obj.unsuccessful.get_or_insert(vec![]).extend(
                        UnsuccessfulItemSetDeserializer::deserialize("unsuccessful", stack)?,
                    );
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateFpgaImageRequest {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
    pub client_token: Option<String>,
    /// <p>A description for the AFI.</p>
    pub description: Option<String>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The location of the encrypted design checkpoint in Amazon S3. The input must be a tarball.</p>
    pub input_storage_location: StorageLocation,
    /// <p>The location in Amazon S3 for the output logs.</p>
    pub logs_storage_location: Option<StorageLocation>,
    /// <p>A name for the AFI.</p>
    pub name: Option<String>,
    /// <p>The tags to apply to the FPGA image during creation.</p>
    pub tag_specifications: Option<Vec<TagSpecification>>,
}

/// Serialize `CreateFpgaImageRequest` contents to a `SignedRequest`.
struct CreateFpgaImageRequestSerializer;
impl CreateFpgaImageRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateFpgaImageRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.client_token {
            params.put(&format!("{}{}", prefix, "ClientToken"), &field_value);
        }
        if let Some(ref field_value) = obj.description {
            params.put(&format!("{}{}", prefix, "Description"), &field_value);
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        StorageLocationSerializer::serialize(
            params,
            &format!("{}{}", prefix, "InputStorageLocation"),
            &obj.input_storage_location,
        );
        if let Some(ref field_value) = obj.logs_storage_location {
            StorageLocationSerializer::serialize(
                params,
                &format!("{}{}", prefix, "LogsStorageLocation"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.name {
            params.put(&format!("{}{}", prefix, "Name"), &field_value);
        }
        if let Some(ref field_value) = obj.tag_specifications {
            TagSpecificationListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagSpecification"),
                field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateFpgaImageResult {
    /// <p>The global FPGA image identifier (AGFI ID).</p>
    pub fpga_image_global_id: Option<String>,
    /// <p>The FPGA image identifier (AFI ID).</p>
    pub fpga_image_id: Option<String>,
}

#[allow(dead_code)]
struct CreateFpgaImageResultDeserializer;
impl CreateFpgaImageResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateFpgaImageResult, XmlParseError> {
        deserialize_elements::<_, CreateFpgaImageResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "fpgaImageGlobalId" => {
                    obj.fpga_image_global_id =
                        Some(StringDeserializer::deserialize("fpgaImageGlobalId", stack)?);
                }
                "fpgaImageId" => {
                    obj.fpga_image_id =
                        Some(StringDeserializer::deserialize("fpgaImageId", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateImageRequest {
    /// <p>The block device mappings. This parameter cannot be used to modify the encryption status of existing volumes or snapshots. To create an AMI with encrypted snapshots, use the <a>CopyImage</a> action.</p>
    pub block_device_mappings: Option<Vec<BlockDeviceMapping>>,
    /// <p>A description for the new image.</p>
    pub description: Option<String>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the instance.</p>
    pub instance_id: String,
    /// <p>A name for the new image.</p> <p>Constraints: 3-128 alphanumeric characters, parentheses (()), square brackets ([]), spaces ( ), periods (.), slashes (/), dashes (-), single quotes ('), at-signs (@), or underscores(_)</p>
    pub name: String,
    /// <p>By default, Amazon EC2 attempts to shut down and reboot the instance before creating the image. If the <code>No Reboot</code> option is set, Amazon EC2 doesn't shut down the instance before creating the image. When this option is used, file system integrity on the created image can't be guaranteed.</p>
    pub no_reboot: Option<bool>,
    /// <p>The tags to apply to the AMI and snapshots on creation. You can tag the AMI, the snapshots, or both.</p> <ul> <li> <p>To tag the AMI, the value for <code>ResourceType</code> must be <code>image</code>.</p> </li> <li> <p>To tag the snapshots that are created of the root volume and of other EBS volumes that are attached to the instance, the value for <code>ResourceType</code> must be <code>snapshot</code>. The same tag is applied to all of the snapshots that are created.</p> </li> </ul> <p>If you specify other values for <code>ResourceType</code>, the request fails.</p> <p>To tag an AMI or snapshot after it has been created, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html">CreateTags</a>. </p>
    pub tag_specifications: Option<Vec<TagSpecification>>,
}

/// Serialize `CreateImageRequest` contents to a `SignedRequest`.
struct CreateImageRequestSerializer;
impl CreateImageRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateImageRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.block_device_mappings {
            BlockDeviceMappingRequestListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "BlockDeviceMapping"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.description {
            params.put(&format!("{}{}", prefix, "Description"), &field_value);
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "InstanceId"), &obj.instance_id);
        params.put(&format!("{}{}", prefix, "Name"), &obj.name);
        if let Some(ref field_value) = obj.no_reboot {
            params.put(&format!("{}{}", prefix, "NoReboot"), &field_value);
        }
        if let Some(ref field_value) = obj.tag_specifications {
            TagSpecificationListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagSpecification"),
                field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateImageResult {
    /// <p>The ID of the new AMI.</p>
    pub image_id: Option<String>,
}

#[allow(dead_code)]
struct CreateImageResultDeserializer;
impl CreateImageResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateImageResult, XmlParseError> {
        deserialize_elements::<_, CreateImageResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "imageId" => {
                    obj.image_id = Some(StringDeserializer::deserialize("imageId", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateInstanceExportTaskRequest {
    /// <p>A description for the conversion task or the resource being exported. The maximum length is 255 characters.</p>
    pub description: Option<String>,
    /// <p>The format and location for an export instance task.</p>
    pub export_to_s3_task: ExportToS3TaskSpecification,
    /// <p>The ID of the instance.</p>
    pub instance_id: String,
    /// <p>The tags to apply to the export instance task during creation.</p>
    pub tag_specifications: Option<Vec<TagSpecification>>,
    /// <p>The target virtualization environment.</p>
    pub target_environment: String,
}

/// Serialize `CreateInstanceExportTaskRequest` contents to a `SignedRequest`.
struct CreateInstanceExportTaskRequestSerializer;
impl CreateInstanceExportTaskRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateInstanceExportTaskRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.description {
            params.put(&format!("{}{}", prefix, "Description"), &field_value);
        }
        ExportToS3TaskSpecificationSerializer::serialize(
            params,
            &format!("{}{}", prefix, "ExportToS3"),
            &obj.export_to_s3_task,
        );
        params.put(&format!("{}{}", prefix, "InstanceId"), &obj.instance_id);
        if let Some(ref field_value) = obj.tag_specifications {
            TagSpecificationListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagSpecification"),
                field_value,
            );
        }
        params.put(
            &format!("{}{}", prefix, "TargetEnvironment"),
            &obj.target_environment,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateInstanceExportTaskResult {
    /// <p>Information about the export instance task.</p>
    pub export_task: Option<ExportTask>,
}

#[allow(dead_code)]
struct CreateInstanceExportTaskResultDeserializer;
impl CreateInstanceExportTaskResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateInstanceExportTaskResult, XmlParseError> {
        deserialize_elements::<_, CreateInstanceExportTaskResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "exportTask" => {
                        obj.export_task =
                            Some(ExportTaskDeserializer::deserialize("exportTask", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateInternetGatewayRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The tags to assign to the internet gateway.</p>
    pub tag_specifications: Option<Vec<TagSpecification>>,
}

/// Serialize `CreateInternetGatewayRequest` contents to a `SignedRequest`.
struct CreateInternetGatewayRequestSerializer;
impl CreateInternetGatewayRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateInternetGatewayRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.tag_specifications {
            TagSpecificationListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagSpecification"),
                field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateInternetGatewayResult {
    /// <p>Information about the internet gateway.</p>
    pub internet_gateway: Option<InternetGateway>,
}

#[allow(dead_code)]
struct CreateInternetGatewayResultDeserializer;
impl CreateInternetGatewayResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateInternetGatewayResult, XmlParseError> {
        deserialize_elements::<_, CreateInternetGatewayResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "internetGateway" => {
                        obj.internet_gateway = Some(InternetGatewayDeserializer::deserialize(
                            "internetGateway",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateKeyPairRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>A unique name for the key pair.</p> <p>Constraints: Up to 255 ASCII characters</p>
    pub key_name: String,
    /// <p>The tags to apply to the new key pair.</p>
    pub tag_specifications: Option<Vec<TagSpecification>>,
}

/// Serialize `CreateKeyPairRequest` contents to a `SignedRequest`.
struct CreateKeyPairRequestSerializer;
impl CreateKeyPairRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateKeyPairRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "KeyName"), &obj.key_name);
        if let Some(ref field_value) = obj.tag_specifications {
            TagSpecificationListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagSpecification"),
                field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateLaunchTemplateRequest {
    /// <p>Unique, case-sensitive identifier you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p> <p>Constraint: Maximum 128 ASCII characters.</p>
    pub client_token: Option<String>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The information for the launch template.</p>
    pub launch_template_data: RequestLaunchTemplateData,
    /// <p>A name for the launch template.</p>
    pub launch_template_name: String,
    /// <p>The tags to apply to the launch template during creation.</p>
    pub tag_specifications: Option<Vec<TagSpecification>>,
    /// <p>A description for the first version of the launch template.</p>
    pub version_description: Option<String>,
}

/// Serialize `CreateLaunchTemplateRequest` contents to a `SignedRequest`.
struct CreateLaunchTemplateRequestSerializer;
impl CreateLaunchTemplateRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateLaunchTemplateRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.client_token {
            params.put(&format!("{}{}", prefix, "ClientToken"), &field_value);
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        RequestLaunchTemplateDataSerializer::serialize(
            params,
            &format!("{}{}", prefix, "LaunchTemplateData"),
            &obj.launch_template_data,
        );
        params.put(
            &format!("{}{}", prefix, "LaunchTemplateName"),
            &obj.launch_template_name,
        );
        if let Some(ref field_value) = obj.tag_specifications {
            TagSpecificationListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagSpecification"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.version_description {
            params.put(&format!("{}{}", prefix, "VersionDescription"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateLaunchTemplateResult {
    /// <p>Information about the launch template.</p>
    pub launch_template: Option<LaunchTemplate>,
    /// <p>If the launch template contains parameters or parameter combinations that are not valid, an error code and an error message are returned for each issue that's found.</p>
    pub warning: Option<ValidationWarning>,
}

#[allow(dead_code)]
struct CreateLaunchTemplateResultDeserializer;
impl CreateLaunchTemplateResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateLaunchTemplateResult, XmlParseError> {
        deserialize_elements::<_, CreateLaunchTemplateResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "launchTemplate" => {
                        obj.launch_template = Some(LaunchTemplateDeserializer::deserialize(
                            "launchTemplate",
                            stack,
                        )?);
                    }
                    "warning" => {
                        obj.warning = Some(ValidationWarningDeserializer::deserialize(
                            "warning", stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateLaunchTemplateVersionRequest {
    /// <p>Unique, case-sensitive identifier you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p> <p>Constraint: Maximum 128 ASCII characters.</p>
    pub client_token: Option<String>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The information for the launch template.</p>
    pub launch_template_data: RequestLaunchTemplateData,
    /// <p>The ID of the launch template. You must specify either the launch template ID or launch template name in the request.</p>
    pub launch_template_id: Option<String>,
    /// <p>The name of the launch template. You must specify either the launch template ID or launch template name in the request.</p>
    pub launch_template_name: Option<String>,
    /// <p>The version number of the launch template version on which to base the new version. The new version inherits the same launch parameters as the source version, except for parameters that you specify in <code>LaunchTemplateData</code>. Snapshots applied to the block device mapping are ignored when creating a new version unless they are explicitly included.</p>
    pub source_version: Option<String>,
    /// <p>A description for the version of the launch template.</p>
    pub version_description: Option<String>,
}

/// Serialize `CreateLaunchTemplateVersionRequest` contents to a `SignedRequest`.
struct CreateLaunchTemplateVersionRequestSerializer;
impl CreateLaunchTemplateVersionRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateLaunchTemplateVersionRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.client_token {
            params.put(&format!("{}{}", prefix, "ClientToken"), &field_value);
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        RequestLaunchTemplateDataSerializer::serialize(
            params,
            &format!("{}{}", prefix, "LaunchTemplateData"),
            &obj.launch_template_data,
        );
        if let Some(ref field_value) = obj.launch_template_id {
            params.put(&format!("{}{}", prefix, "LaunchTemplateId"), &field_value);
        }
        if let Some(ref field_value) = obj.launch_template_name {
            params.put(&format!("{}{}", prefix, "LaunchTemplateName"), &field_value);
        }
        if let Some(ref field_value) = obj.source_version {
            params.put(&format!("{}{}", prefix, "SourceVersion"), &field_value);
        }
        if let Some(ref field_value) = obj.version_description {
            params.put(&format!("{}{}", prefix, "VersionDescription"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateLaunchTemplateVersionResult {
    /// <p>Information about the launch template version.</p>
    pub launch_template_version: Option<LaunchTemplateVersion>,
    /// <p>If the new version of the launch template contains parameters or parameter combinations that are not valid, an error code and an error message are returned for each issue that's found.</p>
    pub warning: Option<ValidationWarning>,
}

#[allow(dead_code)]
struct CreateLaunchTemplateVersionResultDeserializer;
impl CreateLaunchTemplateVersionResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateLaunchTemplateVersionResult, XmlParseError> {
        deserialize_elements::<_, CreateLaunchTemplateVersionResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "launchTemplateVersion" => {
                        obj.launch_template_version =
                            Some(LaunchTemplateVersionDeserializer::deserialize(
                                "launchTemplateVersion",
                                stack,
                            )?);
                    }
                    "warning" => {
                        obj.warning = Some(ValidationWarningDeserializer::deserialize(
                            "warning", stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateLocalGatewayRouteRequest {
    /// <p>The CIDR range used for destination matches. Routing decisions are based on the most specific match.</p>
    pub destination_cidr_block: String,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the local gateway route table.</p>
    pub local_gateway_route_table_id: String,
    /// <p>The ID of the virtual interface group.</p>
    pub local_gateway_virtual_interface_group_id: String,
}

/// Serialize `CreateLocalGatewayRouteRequest` contents to a `SignedRequest`.
struct CreateLocalGatewayRouteRequestSerializer;
impl CreateLocalGatewayRouteRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateLocalGatewayRouteRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "DestinationCidrBlock"),
            &obj.destination_cidr_block,
        );
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "LocalGatewayRouteTableId"),
            &obj.local_gateway_route_table_id,
        );
        params.put(
            &format!("{}{}", prefix, "LocalGatewayVirtualInterfaceGroupId"),
            &obj.local_gateway_virtual_interface_group_id,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateLocalGatewayRouteResult {
    /// <p>Information about the route.</p>
    pub route: Option<LocalGatewayRoute>,
}

#[allow(dead_code)]
struct CreateLocalGatewayRouteResultDeserializer;
impl CreateLocalGatewayRouteResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateLocalGatewayRouteResult, XmlParseError> {
        deserialize_elements::<_, CreateLocalGatewayRouteResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "route" => {
                        obj.route =
                            Some(LocalGatewayRouteDeserializer::deserialize("route", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateLocalGatewayRouteTableVpcAssociationRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the local gateway route table.</p>
    pub local_gateway_route_table_id: String,
    /// <p>The tags to assign to the local gateway route table VPC association.</p>
    pub tag_specifications: Option<Vec<TagSpecification>>,
    /// <p>The ID of the VPC.</p>
    pub vpc_id: String,
}

/// Serialize `CreateLocalGatewayRouteTableVpcAssociationRequest` contents to a `SignedRequest`.
struct CreateLocalGatewayRouteTableVpcAssociationRequestSerializer;
impl CreateLocalGatewayRouteTableVpcAssociationRequestSerializer {
    fn serialize(
        params: &mut Params,
        name: &str,
        obj: &CreateLocalGatewayRouteTableVpcAssociationRequest,
    ) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "LocalGatewayRouteTableId"),
            &obj.local_gateway_route_table_id,
        );
        if let Some(ref field_value) = obj.tag_specifications {
            TagSpecificationListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagSpecification"),
                field_value,
            );
        }
        params.put(&format!("{}{}", prefix, "VpcId"), &obj.vpc_id);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateLocalGatewayRouteTableVpcAssociationResult {
    /// <p>Information about the association.</p>
    pub local_gateway_route_table_vpc_association: Option<LocalGatewayRouteTableVpcAssociation>,
}

#[allow(dead_code)]
struct CreateLocalGatewayRouteTableVpcAssociationResultDeserializer;
impl CreateLocalGatewayRouteTableVpcAssociationResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateLocalGatewayRouteTableVpcAssociationResult, XmlParseError> {
        deserialize_elements::<_, CreateLocalGatewayRouteTableVpcAssociationResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "localGatewayRouteTableVpcAssociation" => {
                        obj.local_gateway_route_table_vpc_association = Some(
                            LocalGatewayRouteTableVpcAssociationDeserializer::deserialize(
                                "localGatewayRouteTableVpcAssociation",
                                stack,
                            )?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateManagedPrefixListRequest {
    /// <p>The IP address type.</p> <p>Valid Values: <code>IPv4</code> | <code>IPv6</code> </p>
    pub address_family: String,
    /// <p>Unique, case-sensitive identifier you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p> <p>Constraints: Up to 255 UTF-8 characters in length.</p>
    pub client_token: Option<String>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>One or more entries for the prefix list.</p>
    pub entries: Option<Vec<AddPrefixListEntry>>,
    /// <p>The maximum number of entries for the prefix list.</p>
    pub max_entries: i64,
    /// <p>A name for the prefix list.</p> <p>Constraints: Up to 255 characters in length. The name cannot start with <code>com.amazonaws</code>.</p>
    pub prefix_list_name: String,
    /// <p>The tags to apply to the prefix list during creation.</p>
    pub tag_specifications: Option<Vec<TagSpecification>>,
}

/// Serialize `CreateManagedPrefixListRequest` contents to a `SignedRequest`.
struct CreateManagedPrefixListRequestSerializer;
impl CreateManagedPrefixListRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateManagedPrefixListRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "AddressFamily"),
            &obj.address_family,
        );
        if let Some(ref field_value) = obj.client_token {
            params.put(&format!("{}{}", prefix, "ClientToken"), &field_value);
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.entries {
            AddPrefixListEntriesSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Entry"),
                field_value,
            );
        }
        params.put(&format!("{}{}", prefix, "MaxEntries"), &obj.max_entries);
        params.put(
            &format!("{}{}", prefix, "PrefixListName"),
            &obj.prefix_list_name,
        );
        if let Some(ref field_value) = obj.tag_specifications {
            TagSpecificationListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagSpecification"),
                field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateManagedPrefixListResult {
    /// <p>Information about the prefix list.</p>
    pub prefix_list: Option<ManagedPrefixList>,
}

#[allow(dead_code)]
struct CreateManagedPrefixListResultDeserializer;
impl CreateManagedPrefixListResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateManagedPrefixListResult, XmlParseError> {
        deserialize_elements::<_, CreateManagedPrefixListResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "prefixList" => {
                        obj.prefix_list = Some(ManagedPrefixListDeserializer::deserialize(
                            "prefixList",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateNatGatewayRequest {
    /// <p>[Public NAT gateways only] The allocation ID of an Elastic IP address to associate with the NAT gateway. You cannot specify an Elastic IP address with a private NAT gateway. If the Elastic IP address is associated with another resource, you must first disassociate it.</p>
    pub allocation_id: Option<String>,
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure Idempotency</a>.</p> <p>Constraint: Maximum 64 ASCII characters.</p>
    pub client_token: Option<String>,
    /// <p>Indicates whether the NAT gateway supports public or private connectivity. The default is public connectivity.</p>
    pub connectivity_type: Option<String>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The subnet in which to create the NAT gateway.</p>
    pub subnet_id: String,
    /// <p>The tags to assign to the NAT gateway.</p>
    pub tag_specifications: Option<Vec<TagSpecification>>,
}

/// Serialize `CreateNatGatewayRequest` contents to a `SignedRequest`.
struct CreateNatGatewayRequestSerializer;
impl CreateNatGatewayRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateNatGatewayRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.allocation_id {
            params.put(&format!("{}{}", prefix, "AllocationId"), &field_value);
        }
        if let Some(ref field_value) = obj.client_token {
            params.put(&format!("{}{}", prefix, "ClientToken"), &field_value);
        }
        if let Some(ref field_value) = obj.connectivity_type {
            params.put(&format!("{}{}", prefix, "ConnectivityType"), &field_value);
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "SubnetId"), &obj.subnet_id);
        if let Some(ref field_value) = obj.tag_specifications {
            TagSpecificationListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagSpecification"),
                field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateNatGatewayResult {
    /// <p>Unique, case-sensitive identifier to ensure the idempotency of the request. Only returned if a client token was provided in the request.</p>
    pub client_token: Option<String>,
    /// <p>Information about the NAT gateway.</p>
    pub nat_gateway: Option<NatGateway>,
}

#[allow(dead_code)]
struct CreateNatGatewayResultDeserializer;
impl CreateNatGatewayResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateNatGatewayResult, XmlParseError> {
        deserialize_elements::<_, CreateNatGatewayResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "clientToken" => {
                    obj.client_token = Some(StringDeserializer::deserialize("clientToken", stack)?);
                }
                "natGateway" => {
                    obj.nat_gateway =
                        Some(NatGatewayDeserializer::deserialize("natGateway", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateNetworkAclEntryRequest {
    /// <p>The IPv4 network range to allow or deny, in CIDR notation (for example <code>172.16.0.0/24</code>). We modify the specified CIDR block to its canonical form; for example, if you specify <code>100.68.0.18/18</code>, we modify it to <code>100.68.0.0/18</code>.</p>
    pub cidr_block: Option<String>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>Indicates whether this is an egress rule (rule is applied to traffic leaving the subnet).</p>
    pub egress: bool,
    /// <p>ICMP protocol: The ICMP or ICMPv6 type and code. Required if specifying protocol 1 (ICMP) or protocol 58 (ICMPv6) with an IPv6 CIDR block.</p>
    pub icmp_type_code: Option<IcmpTypeCode>,
    /// <p>The IPv6 network range to allow or deny, in CIDR notation (for example <code>2001:db8:1234:1a00::/64</code>).</p>
    pub ipv_6_cidr_block: Option<String>,
    /// <p>The ID of the network ACL.</p>
    pub network_acl_id: String,
    /// <p>TCP or UDP protocols: The range of ports the rule applies to. Required if specifying protocol 6 (TCP) or 17 (UDP).</p>
    pub port_range: Option<PortRange>,
    /// <p>The protocol number. A value of "-1" means all protocols. If you specify "-1" or a protocol number other than "6" (TCP), "17" (UDP), or "1" (ICMP), traffic on all ports is allowed, regardless of any ports or ICMP types or codes that you specify. If you specify protocol "58" (ICMPv6) and specify an IPv4 CIDR block, traffic for all ICMP types and codes allowed, regardless of any that you specify. If you specify protocol "58" (ICMPv6) and specify an IPv6 CIDR block, you must specify an ICMP type and code.</p>
    pub protocol: String,
    /// <p>Indicates whether to allow or deny the traffic that matches the rule.</p>
    pub rule_action: String,
    /// <p>The rule number for the entry (for example, 100). ACL entries are processed in ascending order by rule number.</p> <p>Constraints: Positive integer from 1 to 32766. The range 32767 to 65535 is reserved for internal use.</p>
    pub rule_number: i64,
}

/// Serialize `CreateNetworkAclEntryRequest` contents to a `SignedRequest`.
struct CreateNetworkAclEntryRequestSerializer;
impl CreateNetworkAclEntryRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateNetworkAclEntryRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.cidr_block {
            params.put(&format!("{}{}", prefix, "CidrBlock"), &field_value);
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "Egress"), &obj.egress);
        if let Some(ref field_value) = obj.icmp_type_code {
            IcmpTypeCodeSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Icmp"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.ipv_6_cidr_block {
            params.put(&format!("{}{}", prefix, "Ipv6CidrBlock"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "NetworkAclId"),
            &obj.network_acl_id,
        );
        if let Some(ref field_value) = obj.port_range {
            PortRangeSerializer::serialize(
                params,
                &format!("{}{}", prefix, "PortRange"),
                field_value,
            );
        }
        params.put(&format!("{}{}", prefix, "Protocol"), &obj.protocol);
        params.put(&format!("{}{}", prefix, "RuleAction"), &obj.rule_action);
        params.put(&format!("{}{}", prefix, "RuleNumber"), &obj.rule_number);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateNetworkAclRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The tags to assign to the network ACL.</p>
    pub tag_specifications: Option<Vec<TagSpecification>>,
    /// <p>The ID of the VPC.</p>
    pub vpc_id: String,
}

/// Serialize `CreateNetworkAclRequest` contents to a `SignedRequest`.
struct CreateNetworkAclRequestSerializer;
impl CreateNetworkAclRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateNetworkAclRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.tag_specifications {
            TagSpecificationListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagSpecification"),
                field_value,
            );
        }
        params.put(&format!("{}{}", prefix, "VpcId"), &obj.vpc_id);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateNetworkAclResult {
    /// <p>Information about the network ACL.</p>
    pub network_acl: Option<NetworkAcl>,
}

#[allow(dead_code)]
struct CreateNetworkAclResultDeserializer;
impl CreateNetworkAclResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateNetworkAclResult, XmlParseError> {
        deserialize_elements::<_, CreateNetworkAclResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "networkAcl" => {
                    obj.network_acl =
                        Some(NetworkAclDeserializer::deserialize("networkAcl", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateNetworkInsightsPathRequest {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure Idempotency</a>.</p>
    pub client_token: String,
    /// <p>The AWS resource that is the destination of the path.</p>
    pub destination: String,
    /// <p>The IP address of the AWS resource that is the destination of the path.</p>
    pub destination_ip: Option<String>,
    /// <p>The destination port.</p>
    pub destination_port: Option<i64>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The protocol.</p>
    pub protocol: String,
    /// <p>The AWS resource that is the source of the path.</p>
    pub source: String,
    /// <p>The IP address of the AWS resource that is the source of the path.</p>
    pub source_ip: Option<String>,
    /// <p>The tags to add to the path.</p>
    pub tag_specifications: Option<Vec<TagSpecification>>,
}

/// Serialize `CreateNetworkInsightsPathRequest` contents to a `SignedRequest`.
struct CreateNetworkInsightsPathRequestSerializer;
impl CreateNetworkInsightsPathRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateNetworkInsightsPathRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "ClientToken"), &obj.client_token);
        params.put(&format!("{}{}", prefix, "Destination"), &obj.destination);
        if let Some(ref field_value) = obj.destination_ip {
            params.put(&format!("{}{}", prefix, "DestinationIp"), &field_value);
        }
        if let Some(ref field_value) = obj.destination_port {
            params.put(&format!("{}{}", prefix, "DestinationPort"), &field_value);
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "Protocol"), &obj.protocol);
        params.put(&format!("{}{}", prefix, "Source"), &obj.source);
        if let Some(ref field_value) = obj.source_ip {
            params.put(&format!("{}{}", prefix, "SourceIp"), &field_value);
        }
        if let Some(ref field_value) = obj.tag_specifications {
            TagSpecificationListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagSpecification"),
                field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateNetworkInsightsPathResult {
    /// <p>Information about the path.</p>
    pub network_insights_path: Option<NetworkInsightsPath>,
}

#[allow(dead_code)]
struct CreateNetworkInsightsPathResultDeserializer;
impl CreateNetworkInsightsPathResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateNetworkInsightsPathResult, XmlParseError> {
        deserialize_elements::<_, CreateNetworkInsightsPathResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "networkInsightsPath" => {
                        obj.network_insights_path =
                            Some(NetworkInsightsPathDeserializer::deserialize(
                                "networkInsightsPath",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Contains the parameters for CreateNetworkInterfacePermission.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateNetworkInterfacePermissionRequest {
    /// <p>The account ID.</p>
    pub aws_account_id: Option<String>,
    /// <p>The Amazon Web Service. Currently not supported.</p>
    pub aws_service: Option<String>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the network interface.</p>
    pub network_interface_id: String,
    /// <p>The type of permission to grant.</p>
    pub permission: String,
}

/// Serialize `CreateNetworkInterfacePermissionRequest` contents to a `SignedRequest`.
struct CreateNetworkInterfacePermissionRequestSerializer;
impl CreateNetworkInterfacePermissionRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateNetworkInterfacePermissionRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.aws_account_id {
            params.put(&format!("{}{}", prefix, "AwsAccountId"), &field_value);
        }
        if let Some(ref field_value) = obj.aws_service {
            params.put(&format!("{}{}", prefix, "AwsService"), &field_value);
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "NetworkInterfaceId"),
            &obj.network_interface_id,
        );
        params.put(&format!("{}{}", prefix, "Permission"), &obj.permission);
    }
}

/// <p>Contains the output of CreateNetworkInterfacePermission.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateNetworkInterfacePermissionResult {
    /// <p>Information about the permission for the network interface.</p>
    pub interface_permission: Option<NetworkInterfacePermission>,
}

#[allow(dead_code)]
struct CreateNetworkInterfacePermissionResultDeserializer;
impl CreateNetworkInterfacePermissionResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateNetworkInterfacePermissionResult, XmlParseError> {
        deserialize_elements::<_, CreateNetworkInterfacePermissionResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "interfacePermission" => {
                        obj.interface_permission =
                            Some(NetworkInterfacePermissionDeserializer::deserialize(
                                "interfacePermission",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Contains the parameters for CreateNetworkInterface.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateNetworkInterfaceRequest {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
    pub client_token: Option<String>,
    /// <p>A description for the network interface.</p>
    pub description: Option<String>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The IDs of one or more security groups.</p>
    pub groups: Option<Vec<String>>,
    /// <p>Indicates the type of network interface. To create an Elastic Fabric Adapter (EFA), specify <code>efa</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/efa.html"> Elastic Fabric Adapter</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. To create a trunk network interface, specify <code>efa</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/eni-trunking.html"> Network interface trunking</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
    pub interface_type: Option<String>,
    /// <p>The number of IPv6 addresses to assign to a network interface. Amazon EC2 automatically selects the IPv6 addresses from the subnet range. You can't use this option if specifying specific IPv6 addresses. If your subnet has the <code>AssignIpv6AddressOnCreation</code> attribute set to <code>true</code>, you can specify <code>0</code> to override this setting.</p>
    pub ipv_6_address_count: Option<i64>,
    /// <p>One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet. You can't use this option if you're specifying a number of IPv6 addresses.</p>
    pub ipv_6_addresses: Option<Vec<InstanceIpv6Address>>,
    /// <p>The primary private IPv4 address of the network interface. If you don't specify an IPv4 address, Amazon EC2 selects one for you from the subnet's IPv4 CIDR range. If you specify an IP address, you cannot indicate any IP addresses specified in <code>privateIpAddresses</code> as primary (only one IP address can be designated as primary).</p>
    pub private_ip_address: Option<String>,
    /// <p>One or more private IPv4 addresses.</p>
    pub private_ip_addresses: Option<Vec<PrivateIpAddressSpecification>>,
    /// <p>The number of secondary private IPv4 addresses to assign to a network interface. When you specify a number of secondary IPv4 addresses, Amazon EC2 selects these IP addresses within the subnet's IPv4 CIDR range. You can't specify this option and specify more than one private IP address using <code>privateIpAddresses</code>.</p> <p>The number of IP addresses you can assign to a network interface varies by instance type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI">IP Addresses Per ENI Per Instance Type</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>
    pub secondary_private_ip_address_count: Option<i64>,
    /// <p>The ID of the subnet to associate with the network interface.</p>
    pub subnet_id: String,
    /// <p>The tags to apply to the new network interface.</p>
    pub tag_specifications: Option<Vec<TagSpecification>>,
}

/// Serialize `CreateNetworkInterfaceRequest` contents to a `SignedRequest`.
struct CreateNetworkInterfaceRequestSerializer;
impl CreateNetworkInterfaceRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateNetworkInterfaceRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.client_token {
            params.put(&format!("{}{}", prefix, "ClientToken"), &field_value);
        }
        if let Some(ref field_value) = obj.description {
            params.put(&format!("{}{}", prefix, "Description"), &field_value);
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.groups {
            SecurityGroupIdStringListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "SecurityGroupId"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.interface_type {
            params.put(&format!("{}{}", prefix, "InterfaceType"), &field_value);
        }
        if let Some(ref field_value) = obj.ipv_6_address_count {
            params.put(&format!("{}{}", prefix, "Ipv6AddressCount"), &field_value);
        }
        if let Some(ref field_value) = obj.ipv_6_addresses {
            InstanceIpv6AddressListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Ipv6Addresses"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.private_ip_address {
            params.put(&format!("{}{}", prefix, "PrivateIpAddress"), &field_value);
        }
        if let Some(ref field_value) = obj.private_ip_addresses {
            PrivateIpAddressSpecificationListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "PrivateIpAddresses"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.secondary_private_ip_address_count {
            params.put(
                &format!("{}{}", prefix, "SecondaryPrivateIpAddressCount"),
                &field_value,
            );
        }
        params.put(&format!("{}{}", prefix, "SubnetId"), &obj.subnet_id);
        if let Some(ref field_value) = obj.tag_specifications {
            TagSpecificationListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagSpecification"),
                field_value,
            );
        }
    }
}

/// <p>Contains the output of CreateNetworkInterface.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateNetworkInterfaceResult {
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub client_token: Option<String>,
    /// <p>Information about the network interface.</p>
    pub network_interface: Option<NetworkInterface>,
}

#[allow(dead_code)]
struct CreateNetworkInterfaceResultDeserializer;
impl CreateNetworkInterfaceResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateNetworkInterfaceResult, XmlParseError> {
        deserialize_elements::<_, CreateNetworkInterfaceResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "clientToken" => {
                        obj.client_token =
                            Some(StringDeserializer::deserialize("clientToken", stack)?);
                    }
                    "networkInterface" => {
                        obj.network_interface = Some(NetworkInterfaceDeserializer::deserialize(
                            "networkInterface",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreatePlacementGroupRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>A name for the placement group. Must be unique within the scope of your account for the Region.</p> <p>Constraints: Up to 255 ASCII characters</p>
    pub group_name: Option<String>,
    /// <p>The number of partitions. Valid only when <b>Strategy</b> is set to <code>partition</code>.</p>
    pub partition_count: Option<i64>,
    /// <p>The placement strategy.</p>
    pub strategy: Option<String>,
    /// <p>The tags to apply to the new placement group.</p>
    pub tag_specifications: Option<Vec<TagSpecification>>,
}

/// Serialize `CreatePlacementGroupRequest` contents to a `SignedRequest`.
struct CreatePlacementGroupRequestSerializer;
impl CreatePlacementGroupRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreatePlacementGroupRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.group_name {
            params.put(&format!("{}{}", prefix, "GroupName"), &field_value);
        }
        if let Some(ref field_value) = obj.partition_count {
            params.put(&format!("{}{}", prefix, "PartitionCount"), &field_value);
        }
        if let Some(ref field_value) = obj.strategy {
            params.put(&format!("{}{}", prefix, "Strategy"), &field_value);
        }
        if let Some(ref field_value) = obj.tag_specifications {
            TagSpecificationListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagSpecification"),
                field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreatePlacementGroupResult {
    pub placement_group: Option<PlacementGroup>,
}

#[allow(dead_code)]
struct CreatePlacementGroupResultDeserializer;
impl CreatePlacementGroupResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreatePlacementGroupResult, XmlParseError> {
        deserialize_elements::<_, CreatePlacementGroupResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "placementGroup" => {
                        obj.placement_group = Some(PlacementGroupDeserializer::deserialize(
                            "placementGroup",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateReplaceRootVolumeTaskRequest {
    /// <p>Unique, case-sensitive identifier you provide to ensure the idempotency of the request. If you do not specify a client token, a randomly generated token is used for the request to ensure idempotency. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
    pub client_token: Option<String>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the instance for which to replace the root volume.</p>
    pub instance_id: String,
    /// <p>The ID of the snapshot from which to restore the replacement root volume. If you want to restore the volume to the initial launch state, omit this parameter.</p>
    pub snapshot_id: Option<String>,
    /// <p>The tags to apply to the root volume replacement task.</p>
    pub tag_specifications: Option<Vec<TagSpecification>>,
}

/// Serialize `CreateReplaceRootVolumeTaskRequest` contents to a `SignedRequest`.
struct CreateReplaceRootVolumeTaskRequestSerializer;
impl CreateReplaceRootVolumeTaskRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateReplaceRootVolumeTaskRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.client_token {
            params.put(&format!("{}{}", prefix, "ClientToken"), &field_value);
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "InstanceId"), &obj.instance_id);
        if let Some(ref field_value) = obj.snapshot_id {
            params.put(&format!("{}{}", prefix, "SnapshotId"), &field_value);
        }
        if let Some(ref field_value) = obj.tag_specifications {
            TagSpecificationListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagSpecification"),
                field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateReplaceRootVolumeTaskResult {
    /// <p>Information about the root volume replacement task.</p>
    pub replace_root_volume_task: Option<ReplaceRootVolumeTask>,
}

#[allow(dead_code)]
struct CreateReplaceRootVolumeTaskResultDeserializer;
impl CreateReplaceRootVolumeTaskResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateReplaceRootVolumeTaskResult, XmlParseError> {
        deserialize_elements::<_, CreateReplaceRootVolumeTaskResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "replaceRootVolumeTask" => {
                        obj.replace_root_volume_task =
                            Some(ReplaceRootVolumeTaskDeserializer::deserialize(
                                "replaceRootVolumeTask",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Contains the parameters for CreateReservedInstancesListing.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateReservedInstancesListingRequest {
    /// <p>Unique, case-sensitive identifier you provide to ensure idempotency of your listings. This helps avoid duplicate listings. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
    pub client_token: String,
    /// <p>The number of instances that are a part of a Reserved Instance account to be listed in the Reserved Instance Marketplace. This number should be less than or equal to the instance count associated with the Reserved Instance ID specified in this call.</p>
    pub instance_count: i64,
    /// <p>A list specifying the price of the Standard Reserved Instance for each month remaining in the Reserved Instance term.</p>
    pub price_schedules: Vec<PriceScheduleSpecification>,
    /// <p>The ID of the active Standard Reserved Instance.</p>
    pub reserved_instances_id: String,
}

/// Serialize `CreateReservedInstancesListingRequest` contents to a `SignedRequest`.
struct CreateReservedInstancesListingRequestSerializer;
impl CreateReservedInstancesListingRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateReservedInstancesListingRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "ClientToken"), &obj.client_token);
        params.put(
            &format!("{}{}", prefix, "InstanceCount"),
            &obj.instance_count,
        );
        PriceScheduleSpecificationListSerializer::serialize(
            params,
            &format!("{}{}", prefix, "PriceSchedules"),
            &obj.price_schedules,
        );
        params.put(
            &format!("{}{}", prefix, "ReservedInstancesId"),
            &obj.reserved_instances_id,
        );
    }
}

/// <p>Contains the output of CreateReservedInstancesListing.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateReservedInstancesListingResult {
    /// <p>Information about the Standard Reserved Instance listing.</p>
    pub reserved_instances_listings: Option<Vec<ReservedInstancesListing>>,
}

#[allow(dead_code)]
struct CreateReservedInstancesListingResultDeserializer;
impl CreateReservedInstancesListingResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateReservedInstancesListingResult, XmlParseError> {
        deserialize_elements::<_, CreateReservedInstancesListingResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "reservedInstancesListingsSet" => {
                        obj.reserved_instances_listings
                            .get_or_insert(vec![])
                            .extend(ReservedInstancesListingListDeserializer::deserialize(
                                "reservedInstancesListingsSet",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateRestoreImageTaskRequest {
    /// <p>The name of the S3 bucket that contains the stored AMI object.</p>
    pub bucket: String,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The name for the restored AMI. The name must be unique for AMIs in the Region for this account. If you do not provide a name, the new AMI gets the same name as the original AMI.</p>
    pub name: Option<String>,
    /// <p>The name of the stored AMI object in the bucket.</p>
    pub object_key: String,
    /// <p><p>The tags to apply to the AMI and snapshots on restoration. You can tag the AMI, the snapshots, or both.</p> <ul> <li> <p>To tag the AMI, the value for <code>ResourceType</code> must be <code>image</code>.</p> </li> <li> <p>To tag the snapshots, the value for <code>ResourceType</code> must be <code>snapshot</code>. The same tag is applied to all of the snapshots that are created.</p> </li> </ul></p>
    pub tag_specifications: Option<Vec<TagSpecification>>,
}

/// Serialize `CreateRestoreImageTaskRequest` contents to a `SignedRequest`.
struct CreateRestoreImageTaskRequestSerializer;
impl CreateRestoreImageTaskRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateRestoreImageTaskRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "Bucket"), &obj.bucket);
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.name {
            params.put(&format!("{}{}", prefix, "Name"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "ObjectKey"), &obj.object_key);
        if let Some(ref field_value) = obj.tag_specifications {
            TagSpecificationListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagSpecification"),
                field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateRestoreImageTaskResult {
    /// <p>The AMI ID.</p>
    pub image_id: Option<String>,
}

#[allow(dead_code)]
struct CreateRestoreImageTaskResultDeserializer;
impl CreateRestoreImageTaskResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateRestoreImageTaskResult, XmlParseError> {
        deserialize_elements::<_, CreateRestoreImageTaskResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "imageId" => {
                        obj.image_id = Some(StringDeserializer::deserialize("imageId", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateRouteRequest {
    /// <p>The ID of the carrier gateway.</p> <p>You can only use this option when the VPC contains a subnet which is associated with a Wavelength Zone.</p>
    pub carrier_gateway_id: Option<String>,
    /// <p>The IPv4 CIDR address block used for the destination match. Routing decisions are based on the most specific match. We modify the specified CIDR block to its canonical form; for example, if you specify <code>100.68.0.18/18</code>, we modify it to <code>100.68.0.0/18</code>.</p>
    pub destination_cidr_block: Option<String>,
    /// <p>The IPv6 CIDR block used for the destination match. Routing decisions are based on the most specific match.</p>
    pub destination_ipv_6_cidr_block: Option<String>,
    /// <p>The ID of a prefix list used for the destination match.</p>
    pub destination_prefix_list_id: Option<String>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>[IPv6 traffic only] The ID of an egress-only internet gateway.</p>
    pub egress_only_internet_gateway_id: Option<String>,
    /// <p>The ID of an internet gateway or virtual private gateway attached to your VPC.</p>
    pub gateway_id: Option<String>,
    /// <p>The ID of a NAT instance in your VPC. The operation fails if you specify an instance ID unless exactly one network interface is attached.</p>
    pub instance_id: Option<String>,
    /// <p>The ID of the local gateway.</p>
    pub local_gateway_id: Option<String>,
    /// <p>[IPv4 traffic only] The ID of a NAT gateway.</p>
    pub nat_gateway_id: Option<String>,
    /// <p>The ID of a network interface.</p>
    pub network_interface_id: Option<String>,
    /// <p>The ID of the route table for the route.</p>
    pub route_table_id: String,
    /// <p>The ID of a transit gateway.</p>
    pub transit_gateway_id: Option<String>,
    /// <p>The ID of a VPC endpoint. Supported for Gateway Load Balancer endpoints only.</p>
    pub vpc_endpoint_id: Option<String>,
    /// <p>The ID of a VPC peering connection.</p>
    pub vpc_peering_connection_id: Option<String>,
}

/// Serialize `CreateRouteRequest` contents to a `SignedRequest`.
struct CreateRouteRequestSerializer;
impl CreateRouteRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateRouteRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.carrier_gateway_id {
            params.put(&format!("{}{}", prefix, "CarrierGatewayId"), &field_value);
        }
        if let Some(ref field_value) = obj.destination_cidr_block {
            params.put(
                &format!("{}{}", prefix, "DestinationCidrBlock"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.destination_ipv_6_cidr_block {
            params.put(
                &format!("{}{}", prefix, "DestinationIpv6CidrBlock"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.destination_prefix_list_id {
            params.put(
                &format!("{}{}", prefix, "DestinationPrefixListId"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.egress_only_internet_gateway_id {
            params.put(
                &format!("{}{}", prefix, "EgressOnlyInternetGatewayId"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.gateway_id {
            params.put(&format!("{}{}", prefix, "GatewayId"), &field_value);
        }
        if let Some(ref field_value) = obj.instance_id {
            params.put(&format!("{}{}", prefix, "InstanceId"), &field_value);
        }
        if let Some(ref field_value) = obj.local_gateway_id {
            params.put(&format!("{}{}", prefix, "LocalGatewayId"), &field_value);
        }
        if let Some(ref field_value) = obj.nat_gateway_id {
            params.put(&format!("{}{}", prefix, "NatGatewayId"), &field_value);
        }
        if let Some(ref field_value) = obj.network_interface_id {
            params.put(&format!("{}{}", prefix, "NetworkInterfaceId"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "RouteTableId"),
            &obj.route_table_id,
        );
        if let Some(ref field_value) = obj.transit_gateway_id {
            params.put(&format!("{}{}", prefix, "TransitGatewayId"), &field_value);
        }
        if let Some(ref field_value) = obj.vpc_endpoint_id {
            params.put(&format!("{}{}", prefix, "VpcEndpointId"), &field_value);
        }
        if let Some(ref field_value) = obj.vpc_peering_connection_id {
            params.put(
                &format!("{}{}", prefix, "VpcPeeringConnectionId"),
                &field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateRouteResult {
    /// <p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>
    pub return_: Option<bool>,
}

#[allow(dead_code)]
struct CreateRouteResultDeserializer;
impl CreateRouteResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateRouteResult, XmlParseError> {
        deserialize_elements::<_, CreateRouteResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "return" => {
                    obj.return_ = Some(BooleanDeserializer::deserialize("return", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateRouteTableRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The tags to assign to the route table.</p>
    pub tag_specifications: Option<Vec<TagSpecification>>,
    /// <p>The ID of the VPC.</p>
    pub vpc_id: String,
}

/// Serialize `CreateRouteTableRequest` contents to a `SignedRequest`.
struct CreateRouteTableRequestSerializer;
impl CreateRouteTableRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateRouteTableRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.tag_specifications {
            TagSpecificationListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagSpecification"),
                field_value,
            );
        }
        params.put(&format!("{}{}", prefix, "VpcId"), &obj.vpc_id);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateRouteTableResult {
    /// <p>Information about the route table.</p>
    pub route_table: Option<RouteTable>,
}

#[allow(dead_code)]
struct CreateRouteTableResultDeserializer;
impl CreateRouteTableResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateRouteTableResult, XmlParseError> {
        deserialize_elements::<_, CreateRouteTableResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "routeTable" => {
                    obj.route_table =
                        Some(RouteTableDeserializer::deserialize("routeTable", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateSecurityGroupRequest {
    /// <p>A description for the security group. This is informational only.</p> <p>Constraints: Up to 255 characters in length</p> <p>Constraints for EC2-Classic: ASCII characters</p> <p>Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=&amp;;{}!$*</p>
    pub description: String,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The name of the security group.</p> <p>Constraints: Up to 255 characters in length. Cannot start with <code>sg-</code>.</p> <p>Constraints for EC2-Classic: ASCII characters</p> <p>Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=&amp;;{}!$*</p>
    pub group_name: String,
    /// <p>The tags to assign to the security group.</p>
    pub tag_specifications: Option<Vec<TagSpecification>>,
    /// <p>[EC2-VPC] The ID of the VPC. Required for EC2-VPC.</p>
    pub vpc_id: Option<String>,
}

/// Serialize `CreateSecurityGroupRequest` contents to a `SignedRequest`.
struct CreateSecurityGroupRequestSerializer;
impl CreateSecurityGroupRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateSecurityGroupRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "GroupDescription"),
            &obj.description,
        );
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "GroupName"), &obj.group_name);
        if let Some(ref field_value) = obj.tag_specifications {
            TagSpecificationListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagSpecification"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.vpc_id {
            params.put(&format!("{}{}", prefix, "VpcId"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateSecurityGroupResult {
    /// <p>The ID of the security group.</p>
    pub group_id: Option<String>,
    /// <p>The tags assigned to the security group.</p>
    pub tags: Option<Vec<Tag>>,
}

#[allow(dead_code)]
struct CreateSecurityGroupResultDeserializer;
impl CreateSecurityGroupResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateSecurityGroupResult, XmlParseError> {
        deserialize_elements::<_, CreateSecurityGroupResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "groupId" => {
                        obj.group_id = Some(StringDeserializer::deserialize("groupId", stack)?);
                    }
                    "tagSet" => {
                        obj.tags
                            .get_or_insert(vec![])
                            .extend(TagListDeserializer::deserialize("tagSet", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateSnapshotRequest {
    /// <p>A description for the snapshot.</p>
    pub description: Option<String>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The Amazon Resource Name (ARN) of the AWS Outpost on which to create a local snapshot.</p> <ul> <li> <p>To create a snapshot of a volume in a Region, omit this parameter. The snapshot is created in the same Region as the volume.</p> </li> <li> <p>To create a snapshot of a volume on an Outpost and store the snapshot in the Region, omit this parameter. The snapshot is created in the Region for the Outpost.</p> </li> <li> <p>To create a snapshot of a volume on an Outpost and store the snapshot on an Outpost, specify the ARN of the destination Outpost. The snapshot must be created on the same Outpost as the volume.</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#create-snapshot"> Creating local snapshots from volumes on an Outpost</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
    pub outpost_arn: Option<String>,
    /// <p>The tags to apply to the snapshot during creation.</p>
    pub tag_specifications: Option<Vec<TagSpecification>>,
    /// <p>The ID of the EBS volume.</p>
    pub volume_id: String,
}

/// Serialize `CreateSnapshotRequest` contents to a `SignedRequest`.
struct CreateSnapshotRequestSerializer;
impl CreateSnapshotRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateSnapshotRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.description {
            params.put(&format!("{}{}", prefix, "Description"), &field_value);
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.outpost_arn {
            params.put(&format!("{}{}", prefix, "OutpostArn"), &field_value);
        }
        if let Some(ref field_value) = obj.tag_specifications {
            TagSpecificationListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagSpecification"),
                field_value,
            );
        }
        params.put(&format!("{}{}", prefix, "VolumeId"), &obj.volume_id);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateSnapshotsRequest {
    /// <p>Copies the tags from the specified volume to corresponding snapshot.</p>
    pub copy_tags_from_source: Option<String>,
    /// <p> A description propagated to every snapshot specified by the instance.</p>
    pub description: Option<String>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The instance to specify which volumes should be included in the snapshots.</p>
    pub instance_specification: InstanceSpecification,
    /// <p>The Amazon Resource Name (ARN) of the AWS Outpost on which to create the local snapshots.</p> <ul> <li> <p>To create snapshots from an instance in a Region, omit this parameter. The snapshots are created in the same Region as the instance.</p> </li> <li> <p>To create snapshots from an instance on an Outpost and store the snapshots in the Region, omit this parameter. The snapshots are created in the Region for the Outpost.</p> </li> <li> <p>To create snapshots from an instance on an Outpost and store the snapshots on an Outpost, specify the ARN of the destination Outpost. The snapshots must be created on the same Outpost as the instance.</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#create-multivol-snapshot"> Creating multi-volume local snapshots from instances on an Outpost</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
    pub outpost_arn: Option<String>,
    /// <p>Tags to apply to every snapshot specified by the instance.</p>
    pub tag_specifications: Option<Vec<TagSpecification>>,
}

/// Serialize `CreateSnapshotsRequest` contents to a `SignedRequest`.
struct CreateSnapshotsRequestSerializer;
impl CreateSnapshotsRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateSnapshotsRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.copy_tags_from_source {
            params.put(&format!("{}{}", prefix, "CopyTagsFromSource"), &field_value);
        }
        if let Some(ref field_value) = obj.description {
            params.put(&format!("{}{}", prefix, "Description"), &field_value);
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        InstanceSpecificationSerializer::serialize(
            params,
            &format!("{}{}", prefix, "InstanceSpecification"),
            &obj.instance_specification,
        );
        if let Some(ref field_value) = obj.outpost_arn {
            params.put(&format!("{}{}", prefix, "OutpostArn"), &field_value);
        }
        if let Some(ref field_value) = obj.tag_specifications {
            TagSpecificationListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagSpecification"),
                field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateSnapshotsResult {
    /// <p>List of snapshots.</p>
    pub snapshots: Option<Vec<SnapshotInfo>>,
}

#[allow(dead_code)]
struct CreateSnapshotsResultDeserializer;
impl CreateSnapshotsResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateSnapshotsResult, XmlParseError> {
        deserialize_elements::<_, CreateSnapshotsResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "snapshotSet" => {
                    obj.snapshots
                        .get_or_insert(vec![])
                        .extend(SnapshotSetDeserializer::deserialize("snapshotSet", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>Contains the parameters for CreateSpotDatafeedSubscription.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateSpotDatafeedSubscriptionRequest {
    /// <p>The name of the Amazon S3 bucket in which to store the Spot Instance data feed. For more information about bucket names, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html#bucketnamingrules">Rules for bucket naming</a> in the <i>Amazon S3 Developer Guide</i>.</p>
    pub bucket: String,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The prefix for the data feed file names.</p>
    pub prefix: Option<String>,
}

/// Serialize `CreateSpotDatafeedSubscriptionRequest` contents to a `SignedRequest`.
struct CreateSpotDatafeedSubscriptionRequestSerializer;
impl CreateSpotDatafeedSubscriptionRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateSpotDatafeedSubscriptionRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "Bucket"), &obj.bucket);
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.prefix {
            params.put(&format!("{}{}", prefix, "Prefix"), &field_value);
        }
    }
}

/// <p>Contains the output of CreateSpotDatafeedSubscription.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateSpotDatafeedSubscriptionResult {
    /// <p>The Spot Instance data feed subscription.</p>
    pub spot_datafeed_subscription: Option<SpotDatafeedSubscription>,
}

#[allow(dead_code)]
struct CreateSpotDatafeedSubscriptionResultDeserializer;
impl CreateSpotDatafeedSubscriptionResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateSpotDatafeedSubscriptionResult, XmlParseError> {
        deserialize_elements::<_, CreateSpotDatafeedSubscriptionResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "spotDatafeedSubscription" => {
                        obj.spot_datafeed_subscription =
                            Some(SpotDatafeedSubscriptionDeserializer::deserialize(
                                "spotDatafeedSubscription",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateStoreImageTaskRequest {
    /// <p>The name of the S3 bucket in which the AMI object will be stored. The bucket must be in the Region in which the request is being made. The AMI object appears in the bucket only after the upload task has completed. </p>
    pub bucket: String,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the AMI.</p>
    pub image_id: String,
    /// <p>The tags to apply to the AMI object that will be stored in the S3 bucket. </p>
    pub s3_object_tags: Option<Vec<S3ObjectTag>>,
}

/// Serialize `CreateStoreImageTaskRequest` contents to a `SignedRequest`.
struct CreateStoreImageTaskRequestSerializer;
impl CreateStoreImageTaskRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateStoreImageTaskRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "Bucket"), &obj.bucket);
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "ImageId"), &obj.image_id);
        if let Some(ref field_value) = obj.s3_object_tags {
            S3ObjectTagListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "S3ObjectTag"),
                field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateStoreImageTaskResult {
    /// <p>The name of the stored AMI object in the S3 bucket.</p>
    pub object_key: Option<String>,
}

#[allow(dead_code)]
struct CreateStoreImageTaskResultDeserializer;
impl CreateStoreImageTaskResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateStoreImageTaskResult, XmlParseError> {
        deserialize_elements::<_, CreateStoreImageTaskResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "objectKey" => {
                        obj.object_key = Some(StringDeserializer::deserialize("objectKey", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateSubnetRequest {
    /// <p>The Availability Zone or Local Zone for the subnet.</p> <p>Default: AWS selects one for you. If you create more than one subnet in your VPC, we do not necessarily select a different zone for each subnet.</p> <p>To create a subnet in a Local Zone, set this value to the Local Zone ID, for example <code>us-west-2-lax-1a</code>. For information about the Regions that support Local Zones, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-available-regions">Available Regions</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>To create a subnet in an Outpost, set this value to the Availability Zone for the Outpost and specify the Outpost ARN.</p>
    pub availability_zone: Option<String>,
    /// <p>The AZ ID or the Local Zone ID of the subnet.</p>
    pub availability_zone_id: Option<String>,
    /// <p>The IPv4 network range for the subnet, in CIDR notation. For example, <code>10.0.0.0/24</code>. We modify the specified CIDR block to its canonical form; for example, if you specify <code>100.68.0.18/18</code>, we modify it to <code>100.68.0.0/18</code>.</p>
    pub cidr_block: String,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The IPv6 network range for the subnet, in CIDR notation. The subnet size must use a /64 prefix length.</p>
    pub ipv_6_cidr_block: Option<String>,
    /// <p>The Amazon Resource Name (ARN) of the Outpost. If you specify an Outpost ARN, you must also specify the Availability Zone of the Outpost subnet.</p>
    pub outpost_arn: Option<String>,
    /// <p>The tags to assign to the subnet.</p>
    pub tag_specifications: Option<Vec<TagSpecification>>,
    /// <p>The ID of the VPC.</p>
    pub vpc_id: String,
}

/// Serialize `CreateSubnetRequest` contents to a `SignedRequest`.
struct CreateSubnetRequestSerializer;
impl CreateSubnetRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateSubnetRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.availability_zone {
            params.put(&format!("{}{}", prefix, "AvailabilityZone"), &field_value);
        }
        if let Some(ref field_value) = obj.availability_zone_id {
            params.put(&format!("{}{}", prefix, "AvailabilityZoneId"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "CidrBlock"), &obj.cidr_block);
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.ipv_6_cidr_block {
            params.put(&format!("{}{}", prefix, "Ipv6CidrBlock"), &field_value);
        }
        if let Some(ref field_value) = obj.outpost_arn {
            params.put(&format!("{}{}", prefix, "OutpostArn"), &field_value);
        }
        if let Some(ref field_value) = obj.tag_specifications {
            TagSpecificationListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagSpecification"),
                field_value,
            );
        }
        params.put(&format!("{}{}", prefix, "VpcId"), &obj.vpc_id);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateSubnetResult {
    /// <p>Information about the subnet.</p>
    pub subnet: Option<Subnet>,
}

#[allow(dead_code)]
struct CreateSubnetResultDeserializer;
impl CreateSubnetResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateSubnetResult, XmlParseError> {
        deserialize_elements::<_, CreateSubnetResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "subnet" => {
                    obj.subnet = Some(SubnetDeserializer::deserialize("subnet", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateTagsRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The IDs of the resources, separated by spaces.</p> <p>Constraints: Up to 1000 resource IDs. We recommend breaking up this request into smaller batches.</p>
    pub resources: Vec<String>,
    /// <p>The tags. The <code>value</code> parameter is required, but if you don't want the tag to have a value, specify the parameter with no value, and we set the value to an empty string.</p>
    pub tags: Vec<Tag>,
}

/// Serialize `CreateTagsRequest` contents to a `SignedRequest`.
struct CreateTagsRequestSerializer;
impl CreateTagsRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateTagsRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        ResourceIdListSerializer::serialize(
            params,
            &format!("{}{}", prefix, "ResourceId"),
            &obj.resources,
        );
        TagListSerializer::serialize(params, &format!("{}{}", prefix, "Tag"), &obj.tags);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateTrafficMirrorFilterRequest {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure Idempotency</a>.</p>
    pub client_token: Option<String>,
    /// <p>The description of the Traffic Mirror filter.</p>
    pub description: Option<String>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The tags to assign to a Traffic Mirror filter.</p>
    pub tag_specifications: Option<Vec<TagSpecification>>,
}

/// Serialize `CreateTrafficMirrorFilterRequest` contents to a `SignedRequest`.
struct CreateTrafficMirrorFilterRequestSerializer;
impl CreateTrafficMirrorFilterRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateTrafficMirrorFilterRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.client_token {
            params.put(&format!("{}{}", prefix, "ClientToken"), &field_value);
        }
        if let Some(ref field_value) = obj.description {
            params.put(&format!("{}{}", prefix, "Description"), &field_value);
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.tag_specifications {
            TagSpecificationListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagSpecification"),
                field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateTrafficMirrorFilterResult {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure Idempotency</a>.</p>
    pub client_token: Option<String>,
    /// <p>Information about the Traffic Mirror filter.</p>
    pub traffic_mirror_filter: Option<TrafficMirrorFilter>,
}

#[allow(dead_code)]
struct CreateTrafficMirrorFilterResultDeserializer;
impl CreateTrafficMirrorFilterResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateTrafficMirrorFilterResult, XmlParseError> {
        deserialize_elements::<_, CreateTrafficMirrorFilterResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "clientToken" => {
                        obj.client_token =
                            Some(StringDeserializer::deserialize("clientToken", stack)?);
                    }
                    "trafficMirrorFilter" => {
                        obj.traffic_mirror_filter =
                            Some(TrafficMirrorFilterDeserializer::deserialize(
                                "trafficMirrorFilter",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateTrafficMirrorFilterRuleRequest {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure Idempotency</a>.</p>
    pub client_token: Option<String>,
    /// <p>The description of the Traffic Mirror rule.</p>
    pub description: Option<String>,
    /// <p>The destination CIDR block to assign to the Traffic Mirror rule.</p>
    pub destination_cidr_block: String,
    /// <p>The destination port range.</p>
    pub destination_port_range: Option<TrafficMirrorPortRangeRequest>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The protocol, for example UDP, to assign to the Traffic Mirror rule.</p> <p>For information about the protocol value, see <a href="https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a> on the Internet Assigned Numbers Authority (IANA) website.</p>
    pub protocol: Option<i64>,
    /// <p>The action to take (<code>accept</code> | <code>reject</code>) on the filtered traffic.</p>
    pub rule_action: String,
    /// <p>The number of the Traffic Mirror rule. This number must be unique for each Traffic Mirror rule in a given direction. The rules are processed in ascending order by rule number.</p>
    pub rule_number: i64,
    /// <p>The source CIDR block to assign to the Traffic Mirror rule.</p>
    pub source_cidr_block: String,
    /// <p>The source port range.</p>
    pub source_port_range: Option<TrafficMirrorPortRangeRequest>,
    /// <p>The type of traffic (<code>ingress</code> | <code>egress</code>).</p>
    pub traffic_direction: String,
    /// <p>The ID of the filter that this rule is associated with.</p>
    pub traffic_mirror_filter_id: String,
}

/// Serialize `CreateTrafficMirrorFilterRuleRequest` contents to a `SignedRequest`.
struct CreateTrafficMirrorFilterRuleRequestSerializer;
impl CreateTrafficMirrorFilterRuleRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateTrafficMirrorFilterRuleRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.client_token {
            params.put(&format!("{}{}", prefix, "ClientToken"), &field_value);
        }
        if let Some(ref field_value) = obj.description {
            params.put(&format!("{}{}", prefix, "Description"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "DestinationCidrBlock"),
            &obj.destination_cidr_block,
        );
        if let Some(ref field_value) = obj.destination_port_range {
            TrafficMirrorPortRangeRequestSerializer::serialize(
                params,
                &format!("{}{}", prefix, "DestinationPortRange"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.protocol {
            params.put(&format!("{}{}", prefix, "Protocol"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "RuleAction"), &obj.rule_action);
        params.put(&format!("{}{}", prefix, "RuleNumber"), &obj.rule_number);
        params.put(
            &format!("{}{}", prefix, "SourceCidrBlock"),
            &obj.source_cidr_block,
        );
        if let Some(ref field_value) = obj.source_port_range {
            TrafficMirrorPortRangeRequestSerializer::serialize(
                params,
                &format!("{}{}", prefix, "SourcePortRange"),
                field_value,
            );
        }
        params.put(
            &format!("{}{}", prefix, "TrafficDirection"),
            &obj.traffic_direction,
        );
        params.put(
            &format!("{}{}", prefix, "TrafficMirrorFilterId"),
            &obj.traffic_mirror_filter_id,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateTrafficMirrorFilterRuleResult {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure Idempotency</a>.</p>
    pub client_token: Option<String>,
    /// <p>The Traffic Mirror rule.</p>
    pub traffic_mirror_filter_rule: Option<TrafficMirrorFilterRule>,
}

#[allow(dead_code)]
struct CreateTrafficMirrorFilterRuleResultDeserializer;
impl CreateTrafficMirrorFilterRuleResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateTrafficMirrorFilterRuleResult, XmlParseError> {
        deserialize_elements::<_, CreateTrafficMirrorFilterRuleResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "clientToken" => {
                        obj.client_token =
                            Some(StringDeserializer::deserialize("clientToken", stack)?);
                    }
                    "trafficMirrorFilterRule" => {
                        obj.traffic_mirror_filter_rule =
                            Some(TrafficMirrorFilterRuleDeserializer::deserialize(
                                "trafficMirrorFilterRule",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateTrafficMirrorSessionRequest {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure Idempotency</a>.</p>
    pub client_token: Option<String>,
    /// <p>The description of the Traffic Mirror session.</p>
    pub description: Option<String>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the source network interface.</p>
    pub network_interface_id: String,
    /// <p>The number of bytes in each packet to mirror. These are bytes after the VXLAN header. Do not specify this parameter when you want to mirror the entire packet. To mirror a subset of the packet, set this to the length (in bytes) that you want to mirror. For example, if you set this value to 100, then the first 100 bytes that meet the filter criteria are copied to the target.</p> <p>If you do not want to mirror the entire packet, use the <code>PacketLength</code> parameter to specify the number of bytes in each packet to mirror.</p>
    pub packet_length: Option<i64>,
    /// <p>The session number determines the order in which sessions are evaluated when an interface is used by multiple sessions. The first session with a matching filter is the one that mirrors the packets.</p> <p>Valid values are 1-32766.</p>
    pub session_number: i64,
    /// <p>The tags to assign to a Traffic Mirror session.</p>
    pub tag_specifications: Option<Vec<TagSpecification>>,
    /// <p>The ID of the Traffic Mirror filter.</p>
    pub traffic_mirror_filter_id: String,
    /// <p>The ID of the Traffic Mirror target.</p>
    pub traffic_mirror_target_id: String,
    /// <p>The VXLAN ID for the Traffic Mirror session. For more information about the VXLAN protocol, see <a href="https://tools.ietf.org/html/rfc7348">RFC 7348</a>. If you do not specify a <code>VirtualNetworkId</code>, an account-wide unique id is chosen at random.</p>
    pub virtual_network_id: Option<i64>,
}

/// Serialize `CreateTrafficMirrorSessionRequest` contents to a `SignedRequest`.
struct CreateTrafficMirrorSessionRequestSerializer;
impl CreateTrafficMirrorSessionRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateTrafficMirrorSessionRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.client_token {
            params.put(&format!("{}{}", prefix, "ClientToken"), &field_value);
        }
        if let Some(ref field_value) = obj.description {
            params.put(&format!("{}{}", prefix, "Description"), &field_value);
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "NetworkInterfaceId"),
            &obj.network_interface_id,
        );
        if let Some(ref field_value) = obj.packet_length {
            params.put(&format!("{}{}", prefix, "PacketLength"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "SessionNumber"),
            &obj.session_number,
        );
        if let Some(ref field_value) = obj.tag_specifications {
            TagSpecificationListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagSpecification"),
                field_value,
            );
        }
        params.put(
            &format!("{}{}", prefix, "TrafficMirrorFilterId"),
            &obj.traffic_mirror_filter_id,
        );
        params.put(
            &format!("{}{}", prefix, "TrafficMirrorTargetId"),
            &obj.traffic_mirror_target_id,
        );
        if let Some(ref field_value) = obj.virtual_network_id {
            params.put(&format!("{}{}", prefix, "VirtualNetworkId"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateTrafficMirrorSessionResult {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure Idempotency</a>.</p>
    pub client_token: Option<String>,
    /// <p>Information about the Traffic Mirror session.</p>
    pub traffic_mirror_session: Option<TrafficMirrorSession>,
}

#[allow(dead_code)]
struct CreateTrafficMirrorSessionResultDeserializer;
impl CreateTrafficMirrorSessionResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateTrafficMirrorSessionResult, XmlParseError> {
        deserialize_elements::<_, CreateTrafficMirrorSessionResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "clientToken" => {
                        obj.client_token =
                            Some(StringDeserializer::deserialize("clientToken", stack)?);
                    }
                    "trafficMirrorSession" => {
                        obj.traffic_mirror_session =
                            Some(TrafficMirrorSessionDeserializer::deserialize(
                                "trafficMirrorSession",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateTrafficMirrorTargetRequest {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure Idempotency</a>.</p>
    pub client_token: Option<String>,
    /// <p>The description of the Traffic Mirror target.</p>
    pub description: Option<String>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The network interface ID that is associated with the target.</p>
    pub network_interface_id: Option<String>,
    /// <p>The Amazon Resource Name (ARN) of the Network Load Balancer that is associated with the target.</p>
    pub network_load_balancer_arn: Option<String>,
    /// <p>The tags to assign to the Traffic Mirror target.</p>
    pub tag_specifications: Option<Vec<TagSpecification>>,
}

/// Serialize `CreateTrafficMirrorTargetRequest` contents to a `SignedRequest`.
struct CreateTrafficMirrorTargetRequestSerializer;
impl CreateTrafficMirrorTargetRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateTrafficMirrorTargetRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.client_token {
            params.put(&format!("{}{}", prefix, "ClientToken"), &field_value);
        }
        if let Some(ref field_value) = obj.description {
            params.put(&format!("{}{}", prefix, "Description"), &field_value);
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.network_interface_id {
            params.put(&format!("{}{}", prefix, "NetworkInterfaceId"), &field_value);
        }
        if let Some(ref field_value) = obj.network_load_balancer_arn {
            params.put(
                &format!("{}{}", prefix, "NetworkLoadBalancerArn"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.tag_specifications {
            TagSpecificationListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagSpecification"),
                field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateTrafficMirrorTargetResult {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure Idempotency</a>.</p>
    pub client_token: Option<String>,
    /// <p>Information about the Traffic Mirror target.</p>
    pub traffic_mirror_target: Option<TrafficMirrorTarget>,
}

#[allow(dead_code)]
struct CreateTrafficMirrorTargetResultDeserializer;
impl CreateTrafficMirrorTargetResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateTrafficMirrorTargetResult, XmlParseError> {
        deserialize_elements::<_, CreateTrafficMirrorTargetResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "clientToken" => {
                        obj.client_token =
                            Some(StringDeserializer::deserialize("clientToken", stack)?);
                    }
                    "trafficMirrorTarget" => {
                        obj.traffic_mirror_target =
                            Some(TrafficMirrorTargetDeserializer::deserialize(
                                "trafficMirrorTarget",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateTransitGatewayConnectPeerRequest {
    /// <p>The BGP options for the Connect peer.</p>
    pub bgp_options: Option<TransitGatewayConnectRequestBgpOptions>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The range of inside IP addresses that are used for BGP peering. You must specify a size /29 IPv4 CIDR block from the <code>169.254.0.0/16</code> range. The first address from the range must be configured on the appliance as the BGP IP address. You can also optionally specify a size /125 IPv6 CIDR block from the <code>fd00::/8</code> range.</p>
    pub inside_cidr_blocks: Vec<String>,
    /// <p>The peer IP address (GRE outer IP address) on the appliance side of the Connect peer.</p>
    pub peer_address: String,
    /// <p>The tags to apply to the Connect peer.</p>
    pub tag_specifications: Option<Vec<TagSpecification>>,
    /// <p>The peer IP address (GRE outer IP address) on the transit gateway side of the Connect peer, which must be specified from a transit gateway CIDR block. If not specified, Amazon automatically assigns the first available IP address from the transit gateway CIDR block.</p>
    pub transit_gateway_address: Option<String>,
    /// <p>The ID of the Connect attachment.</p>
    pub transit_gateway_attachment_id: String,
}

/// Serialize `CreateTransitGatewayConnectPeerRequest` contents to a `SignedRequest`.
struct CreateTransitGatewayConnectPeerRequestSerializer;
impl CreateTransitGatewayConnectPeerRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateTransitGatewayConnectPeerRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.bgp_options {
            TransitGatewayConnectRequestBgpOptionsSerializer::serialize(
                params,
                &format!("{}{}", prefix, "BgpOptions"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        InsideCidrBlocksStringListSerializer::serialize(
            params,
            &format!("{}{}", prefix, "InsideCidrBlocks"),
            &obj.inside_cidr_blocks,
        );
        params.put(&format!("{}{}", prefix, "PeerAddress"), &obj.peer_address);
        if let Some(ref field_value) = obj.tag_specifications {
            TagSpecificationListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagSpecification"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.transit_gateway_address {
            params.put(
                &format!("{}{}", prefix, "TransitGatewayAddress"),
                &field_value,
            );
        }
        params.put(
            &format!("{}{}", prefix, "TransitGatewayAttachmentId"),
            &obj.transit_gateway_attachment_id,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateTransitGatewayConnectPeerResult {
    /// <p>Information about the Connect peer.</p>
    pub transit_gateway_connect_peer: Option<TransitGatewayConnectPeer>,
}

#[allow(dead_code)]
struct CreateTransitGatewayConnectPeerResultDeserializer;
impl CreateTransitGatewayConnectPeerResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateTransitGatewayConnectPeerResult, XmlParseError> {
        deserialize_elements::<_, CreateTransitGatewayConnectPeerResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "transitGatewayConnectPeer" => {
                        obj.transit_gateway_connect_peer =
                            Some(TransitGatewayConnectPeerDeserializer::deserialize(
                                "transitGatewayConnectPeer",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateTransitGatewayConnectRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The Connect attachment options.</p>
    pub options: CreateTransitGatewayConnectRequestOptions,
    /// <p>The tags to apply to the Connect attachment.</p>
    pub tag_specifications: Option<Vec<TagSpecification>>,
    /// <p>The ID of the transit gateway attachment. You can specify a VPC attachment or a AWS Direct Connect attachment.</p>
    pub transport_transit_gateway_attachment_id: String,
}

/// Serialize `CreateTransitGatewayConnectRequest` contents to a `SignedRequest`.
struct CreateTransitGatewayConnectRequestSerializer;
impl CreateTransitGatewayConnectRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateTransitGatewayConnectRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        CreateTransitGatewayConnectRequestOptionsSerializer::serialize(
            params,
            &format!("{}{}", prefix, "Options"),
            &obj.options,
        );
        if let Some(ref field_value) = obj.tag_specifications {
            TagSpecificationListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagSpecification"),
                field_value,
            );
        }
        params.put(
            &format!("{}{}", prefix, "TransportTransitGatewayAttachmentId"),
            &obj.transport_transit_gateway_attachment_id,
        );
    }
}

/// <p>The options for a Connect attachment.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateTransitGatewayConnectRequestOptions {
    /// <p>The tunnel protocol.</p>
    pub protocol: String,
}

/// Serialize `CreateTransitGatewayConnectRequestOptions` contents to a `SignedRequest`.
struct CreateTransitGatewayConnectRequestOptionsSerializer;
impl CreateTransitGatewayConnectRequestOptionsSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateTransitGatewayConnectRequestOptions) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "Protocol"), &obj.protocol);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateTransitGatewayConnectResult {
    /// <p>Information about the Connect attachment.</p>
    pub transit_gateway_connect: Option<TransitGatewayConnect>,
}

#[allow(dead_code)]
struct CreateTransitGatewayConnectResultDeserializer;
impl CreateTransitGatewayConnectResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateTransitGatewayConnectResult, XmlParseError> {
        deserialize_elements::<_, CreateTransitGatewayConnectResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "transitGatewayConnect" => {
                        obj.transit_gateway_connect =
                            Some(TransitGatewayConnectDeserializer::deserialize(
                                "transitGatewayConnect",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateTransitGatewayMulticastDomainRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The options for the transit gateway multicast domain.</p>
    pub options: Option<CreateTransitGatewayMulticastDomainRequestOptions>,
    /// <p>The tags for the transit gateway multicast domain.</p>
    pub tag_specifications: Option<Vec<TagSpecification>>,
    /// <p>The ID of the transit gateway.</p>
    pub transit_gateway_id: String,
}

/// Serialize `CreateTransitGatewayMulticastDomainRequest` contents to a `SignedRequest`.
struct CreateTransitGatewayMulticastDomainRequestSerializer;
impl CreateTransitGatewayMulticastDomainRequestSerializer {
    fn serialize(
        params: &mut Params,
        name: &str,
        obj: &CreateTransitGatewayMulticastDomainRequest,
    ) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.options {
            CreateTransitGatewayMulticastDomainRequestOptionsSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Options"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.tag_specifications {
            TagSpecificationListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagSpecification"),
                field_value,
            );
        }
        params.put(
            &format!("{}{}", prefix, "TransitGatewayId"),
            &obj.transit_gateway_id,
        );
    }
}

/// <p>The options for the transit gateway multicast domain.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateTransitGatewayMulticastDomainRequestOptions {
    /// <p>Indicates whether to automatically accept cross-account subnet associations that are associated with the transit gateway multicast domain.</p>
    pub auto_accept_shared_associations: Option<String>,
    /// <p>Specify whether to enable Internet Group Management Protocol (IGMP) version 2 for the transit gateway multicast domain.</p>
    pub igmpv_2_support: Option<String>,
    /// <p>Specify whether to enable support for statically configuring multicast group sources for a domain.</p>
    pub static_sources_support: Option<String>,
}

/// Serialize `CreateTransitGatewayMulticastDomainRequestOptions` contents to a `SignedRequest`.
struct CreateTransitGatewayMulticastDomainRequestOptionsSerializer;
impl CreateTransitGatewayMulticastDomainRequestOptionsSerializer {
    fn serialize(
        params: &mut Params,
        name: &str,
        obj: &CreateTransitGatewayMulticastDomainRequestOptions,
    ) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.auto_accept_shared_associations {
            params.put(
                &format!("{}{}", prefix, "AutoAcceptSharedAssociations"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.igmpv_2_support {
            params.put(&format!("{}{}", prefix, "Igmpv2Support"), &field_value);
        }
        if let Some(ref field_value) = obj.static_sources_support {
            params.put(
                &format!("{}{}", prefix, "StaticSourcesSupport"),
                &field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateTransitGatewayMulticastDomainResult {
    /// <p>Information about the transit gateway multicast domain.</p>
    pub transit_gateway_multicast_domain: Option<TransitGatewayMulticastDomain>,
}

#[allow(dead_code)]
struct CreateTransitGatewayMulticastDomainResultDeserializer;
impl CreateTransitGatewayMulticastDomainResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateTransitGatewayMulticastDomainResult, XmlParseError> {
        deserialize_elements::<_, CreateTransitGatewayMulticastDomainResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "transitGatewayMulticastDomain" => {
                        obj.transit_gateway_multicast_domain =
                            Some(TransitGatewayMulticastDomainDeserializer::deserialize(
                                "transitGatewayMulticastDomain",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateTransitGatewayPeeringAttachmentRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The AWS account ID of the owner of the peer transit gateway.</p>
    pub peer_account_id: String,
    /// <p>The Region where the peer transit gateway is located.</p>
    pub peer_region: String,
    /// <p>The ID of the peer transit gateway with which to create the peering attachment.</p>
    pub peer_transit_gateway_id: String,
    /// <p>The tags to apply to the transit gateway peering attachment.</p>
    pub tag_specifications: Option<Vec<TagSpecification>>,
    /// <p>The ID of the transit gateway.</p>
    pub transit_gateway_id: String,
}

/// Serialize `CreateTransitGatewayPeeringAttachmentRequest` contents to a `SignedRequest`.
struct CreateTransitGatewayPeeringAttachmentRequestSerializer;
impl CreateTransitGatewayPeeringAttachmentRequestSerializer {
    fn serialize(
        params: &mut Params,
        name: &str,
        obj: &CreateTransitGatewayPeeringAttachmentRequest,
    ) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "PeerAccountId"),
            &obj.peer_account_id,
        );
        params.put(&format!("{}{}", prefix, "PeerRegion"), &obj.peer_region);
        params.put(
            &format!("{}{}", prefix, "PeerTransitGatewayId"),
            &obj.peer_transit_gateway_id,
        );
        if let Some(ref field_value) = obj.tag_specifications {
            TagSpecificationListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagSpecification"),
                field_value,
            );
        }
        params.put(
            &format!("{}{}", prefix, "TransitGatewayId"),
            &obj.transit_gateway_id,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateTransitGatewayPeeringAttachmentResult {
    /// <p>The transit gateway peering attachment.</p>
    pub transit_gateway_peering_attachment: Option<TransitGatewayPeeringAttachment>,
}

#[allow(dead_code)]
struct CreateTransitGatewayPeeringAttachmentResultDeserializer;
impl CreateTransitGatewayPeeringAttachmentResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateTransitGatewayPeeringAttachmentResult, XmlParseError> {
        deserialize_elements::<_, CreateTransitGatewayPeeringAttachmentResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "transitGatewayPeeringAttachment" => {
                        obj.transit_gateway_peering_attachment =
                            Some(TransitGatewayPeeringAttachmentDeserializer::deserialize(
                                "transitGatewayPeeringAttachment",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateTransitGatewayPrefixListReferenceRequest {
    /// <p>Indicates whether to drop traffic that matches this route.</p>
    pub blackhole: Option<bool>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the prefix list that is used for destination matches.</p>
    pub prefix_list_id: String,
    /// <p>The ID of the attachment to which traffic is routed.</p>
    pub transit_gateway_attachment_id: Option<String>,
    /// <p>The ID of the transit gateway route table.</p>
    pub transit_gateway_route_table_id: String,
}

/// Serialize `CreateTransitGatewayPrefixListReferenceRequest` contents to a `SignedRequest`.
struct CreateTransitGatewayPrefixListReferenceRequestSerializer;
impl CreateTransitGatewayPrefixListReferenceRequestSerializer {
    fn serialize(
        params: &mut Params,
        name: &str,
        obj: &CreateTransitGatewayPrefixListReferenceRequest,
    ) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.blackhole {
            params.put(&format!("{}{}", prefix, "Blackhole"), &field_value);
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "PrefixListId"),
            &obj.prefix_list_id,
        );
        if let Some(ref field_value) = obj.transit_gateway_attachment_id {
            params.put(
                &format!("{}{}", prefix, "TransitGatewayAttachmentId"),
                &field_value,
            );
        }
        params.put(
            &format!("{}{}", prefix, "TransitGatewayRouteTableId"),
            &obj.transit_gateway_route_table_id,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateTransitGatewayPrefixListReferenceResult {
    /// <p>Information about the prefix list reference.</p>
    pub transit_gateway_prefix_list_reference: Option<TransitGatewayPrefixListReference>,
}

#[allow(dead_code)]
struct CreateTransitGatewayPrefixListReferenceResultDeserializer;
impl CreateTransitGatewayPrefixListReferenceResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateTransitGatewayPrefixListReferenceResult, XmlParseError> {
        deserialize_elements::<_, CreateTransitGatewayPrefixListReferenceResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "transitGatewayPrefixListReference" => {
                        obj.transit_gateway_prefix_list_reference =
                            Some(TransitGatewayPrefixListReferenceDeserializer::deserialize(
                                "transitGatewayPrefixListReference",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateTransitGatewayRequest {
    /// <p>A description of the transit gateway.</p>
    pub description: Option<String>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The transit gateway options.</p>
    pub options: Option<TransitGatewayRequestOptions>,
    /// <p>The tags to apply to the transit gateway.</p>
    pub tag_specifications: Option<Vec<TagSpecification>>,
}

/// Serialize `CreateTransitGatewayRequest` contents to a `SignedRequest`.
struct CreateTransitGatewayRequestSerializer;
impl CreateTransitGatewayRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateTransitGatewayRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.description {
            params.put(&format!("{}{}", prefix, "Description"), &field_value);
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.options {
            TransitGatewayRequestOptionsSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Options"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.tag_specifications {
            TagSpecificationListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagSpecification"),
                field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateTransitGatewayResult {
    /// <p>Information about the transit gateway.</p>
    pub transit_gateway: Option<TransitGateway>,
}

#[allow(dead_code)]
struct CreateTransitGatewayResultDeserializer;
impl CreateTransitGatewayResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateTransitGatewayResult, XmlParseError> {
        deserialize_elements::<_, CreateTransitGatewayResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "transitGateway" => {
                        obj.transit_gateway = Some(TransitGatewayDeserializer::deserialize(
                            "transitGateway",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateTransitGatewayRouteRequest {
    /// <p>Indicates whether to drop traffic that matches this route.</p>
    pub blackhole: Option<bool>,
    /// <p>The CIDR range used for destination matches. Routing decisions are based on the most specific match.</p>
    pub destination_cidr_block: String,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the attachment.</p>
    pub transit_gateway_attachment_id: Option<String>,
    /// <p>The ID of the transit gateway route table.</p>
    pub transit_gateway_route_table_id: String,
}

/// Serialize `CreateTransitGatewayRouteRequest` contents to a `SignedRequest`.
struct CreateTransitGatewayRouteRequestSerializer;
impl CreateTransitGatewayRouteRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateTransitGatewayRouteRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.blackhole {
            params.put(&format!("{}{}", prefix, "Blackhole"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "DestinationCidrBlock"),
            &obj.destination_cidr_block,
        );
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.transit_gateway_attachment_id {
            params.put(
                &format!("{}{}", prefix, "TransitGatewayAttachmentId"),
                &field_value,
            );
        }
        params.put(
            &format!("{}{}", prefix, "TransitGatewayRouteTableId"),
            &obj.transit_gateway_route_table_id,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateTransitGatewayRouteResult {
    /// <p>Information about the route.</p>
    pub route: Option<TransitGatewayRoute>,
}

#[allow(dead_code)]
struct CreateTransitGatewayRouteResultDeserializer;
impl CreateTransitGatewayRouteResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateTransitGatewayRouteResult, XmlParseError> {
        deserialize_elements::<_, CreateTransitGatewayRouteResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "route" => {
                        obj.route = Some(TransitGatewayRouteDeserializer::deserialize(
                            "route", stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateTransitGatewayRouteTableRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The tags to apply to the transit gateway route table.</p>
    pub tag_specifications: Option<Vec<TagSpecification>>,
    /// <p>The ID of the transit gateway.</p>
    pub transit_gateway_id: String,
}

/// Serialize `CreateTransitGatewayRouteTableRequest` contents to a `SignedRequest`.
struct CreateTransitGatewayRouteTableRequestSerializer;
impl CreateTransitGatewayRouteTableRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateTransitGatewayRouteTableRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.tag_specifications {
            TagSpecificationListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagSpecifications"),
                field_value,
            );
        }
        params.put(
            &format!("{}{}", prefix, "TransitGatewayId"),
            &obj.transit_gateway_id,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateTransitGatewayRouteTableResult {
    /// <p>Information about the transit gateway route table.</p>
    pub transit_gateway_route_table: Option<TransitGatewayRouteTable>,
}

#[allow(dead_code)]
struct CreateTransitGatewayRouteTableResultDeserializer;
impl CreateTransitGatewayRouteTableResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateTransitGatewayRouteTableResult, XmlParseError> {
        deserialize_elements::<_, CreateTransitGatewayRouteTableResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "transitGatewayRouteTable" => {
                        obj.transit_gateway_route_table =
                            Some(TransitGatewayRouteTableDeserializer::deserialize(
                                "transitGatewayRouteTable",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateTransitGatewayVpcAttachmentRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The VPC attachment options.</p>
    pub options: Option<CreateTransitGatewayVpcAttachmentRequestOptions>,
    /// <p>The IDs of one or more subnets. You can specify only one subnet per Availability Zone. You must specify at least one subnet, but we recommend that you specify two subnets for better availability. The transit gateway uses one IP address from each specified subnet.</p>
    pub subnet_ids: Vec<String>,
    /// <p>The tags to apply to the VPC attachment.</p>
    pub tag_specifications: Option<Vec<TagSpecification>>,
    /// <p>The ID of the transit gateway.</p>
    pub transit_gateway_id: String,
    /// <p>The ID of the VPC.</p>
    pub vpc_id: String,
}

/// Serialize `CreateTransitGatewayVpcAttachmentRequest` contents to a `SignedRequest`.
struct CreateTransitGatewayVpcAttachmentRequestSerializer;
impl CreateTransitGatewayVpcAttachmentRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateTransitGatewayVpcAttachmentRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.options {
            CreateTransitGatewayVpcAttachmentRequestOptionsSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Options"),
                field_value,
            );
        }
        TransitGatewaySubnetIdListSerializer::serialize(
            params,
            &format!("{}{}", prefix, "SubnetIds"),
            &obj.subnet_ids,
        );
        if let Some(ref field_value) = obj.tag_specifications {
            TagSpecificationListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagSpecifications"),
                field_value,
            );
        }
        params.put(
            &format!("{}{}", prefix, "TransitGatewayId"),
            &obj.transit_gateway_id,
        );
        params.put(&format!("{}{}", prefix, "VpcId"), &obj.vpc_id);
    }
}

/// <p>Describes the options for a VPC attachment.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateTransitGatewayVpcAttachmentRequestOptions {
    /// <p>Enable or disable support for appliance mode. If enabled, a traffic flow between a source and destination uses the same Availability Zone for the VPC attachment for the lifetime of that flow. The default is <code>disable</code>.</p>
    pub appliance_mode_support: Option<String>,
    /// <p>Enable or disable DNS support. The default is <code>enable</code>.</p>
    pub dns_support: Option<String>,
    /// <p>Enable or disable IPv6 support. The default is <code>disable</code>.</p>
    pub ipv_6_support: Option<String>,
}

/// Serialize `CreateTransitGatewayVpcAttachmentRequestOptions` contents to a `SignedRequest`.
struct CreateTransitGatewayVpcAttachmentRequestOptionsSerializer;
impl CreateTransitGatewayVpcAttachmentRequestOptionsSerializer {
    fn serialize(
        params: &mut Params,
        name: &str,
        obj: &CreateTransitGatewayVpcAttachmentRequestOptions,
    ) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.appliance_mode_support {
            params.put(
                &format!("{}{}", prefix, "ApplianceModeSupport"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.dns_support {
            params.put(&format!("{}{}", prefix, "DnsSupport"), &field_value);
        }
        if let Some(ref field_value) = obj.ipv_6_support {
            params.put(&format!("{}{}", prefix, "Ipv6Support"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateTransitGatewayVpcAttachmentResult {
    /// <p>Information about the VPC attachment.</p>
    pub transit_gateway_vpc_attachment: Option<TransitGatewayVpcAttachment>,
}

#[allow(dead_code)]
struct CreateTransitGatewayVpcAttachmentResultDeserializer;
impl CreateTransitGatewayVpcAttachmentResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateTransitGatewayVpcAttachmentResult, XmlParseError> {
        deserialize_elements::<_, CreateTransitGatewayVpcAttachmentResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "transitGatewayVpcAttachment" => {
                        obj.transit_gateway_vpc_attachment =
                            Some(TransitGatewayVpcAttachmentDeserializer::deserialize(
                                "transitGatewayVpcAttachment",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Describes the user or group to be added or removed from the list of create volume permissions for a volume.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateVolumePermission {
    /// <p>The group to be added or removed. The possible value is <code>all</code>.</p>
    pub group: Option<String>,
    /// <p>The AWS account ID to be added or removed.</p>
    pub user_id: Option<String>,
}

#[allow(dead_code)]
struct CreateVolumePermissionDeserializer;
impl CreateVolumePermissionDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateVolumePermission, XmlParseError> {
        deserialize_elements::<_, CreateVolumePermission, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "group" => {
                    obj.group = Some(PermissionGroupDeserializer::deserialize("group", stack)?);
                }
                "userId" => {
                    obj.user_id = Some(StringDeserializer::deserialize("userId", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}

/// Serialize `CreateVolumePermission` contents to a `SignedRequest`.
struct CreateVolumePermissionSerializer;
impl CreateVolumePermissionSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateVolumePermission) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.group {
            params.put(&format!("{}{}", prefix, "Group"), &field_value);
        }
        if let Some(ref field_value) = obj.user_id {
            params.put(&format!("{}{}", prefix, "UserId"), &field_value);
        }
    }
}

#[allow(dead_code)]
struct CreateVolumePermissionListDeserializer;
impl CreateVolumePermissionListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<CreateVolumePermission>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "item" {
                obj.push(CreateVolumePermissionDeserializer::deserialize(
                    "item", stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}

/// Serialize `CreateVolumePermissionList` contents to a `SignedRequest`.
struct CreateVolumePermissionListSerializer;
impl CreateVolumePermissionListSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<CreateVolumePermission>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.{}", name, index + 1);
            CreateVolumePermissionSerializer::serialize(params, &key, obj);
        }
    }
}

/// <p>Describes modifications to the list of create volume permissions for a volume.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateVolumePermissionModifications {
    /// <p>Adds the specified AWS account ID or group to the list.</p>
    pub add: Option<Vec<CreateVolumePermission>>,
    /// <p>Removes the specified AWS account ID or group from the list.</p>
    pub remove: Option<Vec<CreateVolumePermission>>,
}

/// Serialize `CreateVolumePermissionModifications` contents to a `SignedRequest`.
struct CreateVolumePermissionModificationsSerializer;
impl CreateVolumePermissionModificationsSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateVolumePermissionModifications) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.add {
            CreateVolumePermissionListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Add"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.remove {
            CreateVolumePermissionListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Remove"),
                field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateVolumeRequest {
    /// <p>The Availability Zone in which to create the volume.</p>
    pub availability_zone: String,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>Indicates whether the volume should be encrypted. The effect of setting the encryption state to <code>true</code> depends on the volume origin (new or from a snapshot), starting encryption state, ownership, and whether encryption by default is enabled. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#encryption-by-default">Encryption by default</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>Encrypted Amazon EBS volumes must be attached to instances that support Amazon EBS encryption. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#EBSEncryption_supported_instances">Supported instance types</a>.</p>
    pub encrypted: Option<bool>,
    /// <p>The number of I/O operations per second (IOPS). For <code>gp3</code>, <code>io1</code>, and <code>io2</code> volumes, this represents the number of IOPS that are provisioned for the volume. For <code>gp2</code> volumes, this represents the baseline performance of the volume and the rate at which the volume accumulates I/O credits for bursting.</p> <p>The following are the supported values for each volume type:</p> <ul> <li> <p> <code>gp3</code>: 3,000-16,000 IOPS</p> </li> <li> <p> <code>io1</code>: 100-64,000 IOPS</p> </li> <li> <p> <code>io2</code>: 100-64,000 IOPS</p> </li> </ul> <p>For <code>io1</code> and <code>io2</code> volumes, we guarantee 64,000 IOPS only for <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Instances built on the Nitro System</a>. Other instance families guarantee performance up to 32,000 IOPS.</p> <p>This parameter is required for <code>io1</code> and <code>io2</code> volumes. The default for <code>gp3</code> volumes is 3,000 IOPS. This parameter is not supported for <code>gp2</code>, <code>st1</code>, <code>sc1</code>, or <code>standard</code> volumes.</p>
    pub iops: Option<i64>,
    /// <p>The identifier of the AWS Key Management Service (AWS KMS) customer master key (CMK) to use for Amazon EBS encryption. If this parameter is not specified, your AWS managed CMK for EBS is used. If <code>KmsKeyId</code> is specified, the encrypted state must be <code>true</code>.</p> <p>You can specify the CMK using any of the following:</p> <ul> <li> <p>Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.</p> </li> <li> <p>Key alias. For example, alias/ExampleAlias.</p> </li> <li> <p>Key ARN. For example, arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.</p> </li> <li> <p>Alias ARN. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.</p> </li> </ul> <p>AWS authenticates the CMK asynchronously. Therefore, if you specify an ID, alias, or ARN that is not valid, the action can appear to complete, but eventually fails.</p>
    pub kms_key_id: Option<String>,
    /// <p>Indicates whether to enable Amazon EBS Multi-Attach. If you enable Multi-Attach, you can attach the volume to up to 16 <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Instances built on the Nitro System</a> in the same Availability Zone. This parameter is supported with <code>io1</code> and <code>io2</code> volumes only. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-volumes-multi.html"> Amazon EBS Multi-Attach</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
    pub multi_attach_enabled: Option<bool>,
    /// <p>The Amazon Resource Name (ARN) of the Outpost.</p>
    pub outpost_arn: Option<String>,
    /// <p><p>The size of the volume, in GiBs. You must specify either a snapshot ID or a volume size. If you specify a snapshot, the default is the snapshot size. You can specify a volume size that is equal to or larger than the snapshot size.</p> <p>The following are the supported volumes sizes for each volume type:</p> <ul> <li> <p> <code>gp2</code> and <code>gp3</code>: 1-16,384</p> </li> <li> <p> <code>io1</code> and <code>io2</code>: 4-16,384</p> </li> <li> <p> <code>st1</code> and <code>sc1</code>: 125-16,384</p> </li> <li> <p> <code>standard</code>: 1-1,024</p> </li> </ul></p>
    pub size: Option<i64>,
    /// <p>The snapshot from which to create the volume. You must specify either a snapshot ID or a volume size.</p>
    pub snapshot_id: Option<String>,
    /// <p>The tags to apply to the volume during creation.</p>
    pub tag_specifications: Option<Vec<TagSpecification>>,
    /// <p>The throughput to provision for a volume, with a maximum of 1,000 MiB/s.</p> <p>This parameter is valid only for <code>gp3</code> volumes.</p> <p>Valid Range: Minimum value of 125. Maximum value of 1000.</p>
    pub throughput: Option<i64>,
    /// <p>The volume type. This parameter can be one of the following values:</p> <ul> <li> <p>General Purpose SSD: <code>gp2</code> | <code>gp3</code> </p> </li> <li> <p>Provisioned IOPS SSD: <code>io1</code> | <code>io2</code> </p> </li> <li> <p>Throughput Optimized HDD: <code>st1</code> </p> </li> <li> <p>Cold HDD: <code>sc1</code> </p> </li> <li> <p>Magnetic: <code>standard</code> </p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS volume types</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>Default: <code>gp2</code> </p>
    pub volume_type: Option<String>,
}

/// Serialize `CreateVolumeRequest` contents to a `SignedRequest`.
struct CreateVolumeRequestSerializer;
impl CreateVolumeRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateVolumeRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "AvailabilityZone"),
            &obj.availability_zone,
        );
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.encrypted {
            params.put(&format!("{}{}", prefix, "Encrypted"), &field_value);
        }
        if let Some(ref field_value) = obj.iops {
            params.put(&format!("{}{}", prefix, "Iops"), &field_value);
        }
        if let Some(ref field_value) = obj.kms_key_id {
            params.put(&format!("{}{}", prefix, "KmsKeyId"), &field_value);
        }
        if let Some(ref field_value) = obj.multi_attach_enabled {
            params.put(&format!("{}{}", prefix, "MultiAttachEnabled"), &field_value);
        }
        if let Some(ref field_value) = obj.outpost_arn {
            params.put(&format!("{}{}", prefix, "OutpostArn"), &field_value);
        }
        if let Some(ref field_value) = obj.size {
            params.put(&format!("{}{}", prefix, "Size"), &field_value);
        }
        if let Some(ref field_value) = obj.snapshot_id {
            params.put(&format!("{}{}", prefix, "SnapshotId"), &field_value);
        }
        if let Some(ref field_value) = obj.tag_specifications {
            TagSpecificationListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagSpecification"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.throughput {
            params.put(&format!("{}{}", prefix, "Throughput"), &field_value);
        }
        if let Some(ref field_value) = obj.volume_type {
            params.put(&format!("{}{}", prefix, "VolumeType"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateVpcEndpointConnectionNotificationRequest {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure Idempotency</a>.</p>
    pub client_token: Option<String>,
    /// <p>One or more endpoint events for which to receive notifications. Valid values are <code>Accept</code>, <code>Connect</code>, <code>Delete</code>, and <code>Reject</code>.</p>
    pub connection_events: Vec<String>,
    /// <p>The ARN of the SNS topic for the notifications.</p>
    pub connection_notification_arn: String,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the endpoint service.</p>
    pub service_id: Option<String>,
    /// <p>The ID of the endpoint.</p>
    pub vpc_endpoint_id: Option<String>,
}

/// Serialize `CreateVpcEndpointConnectionNotificationRequest` contents to a `SignedRequest`.
struct CreateVpcEndpointConnectionNotificationRequestSerializer;
impl CreateVpcEndpointConnectionNotificationRequestSerializer {
    fn serialize(
        params: &mut Params,
        name: &str,
        obj: &CreateVpcEndpointConnectionNotificationRequest,
    ) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.client_token {
            params.put(&format!("{}{}", prefix, "ClientToken"), &field_value);
        }
        ValueStringListSerializer::serialize(
            params,
            &format!("{}{}", prefix, "ConnectionEvents"),
            &obj.connection_events,
        );
        params.put(
            &format!("{}{}", prefix, "ConnectionNotificationArn"),
            &obj.connection_notification_arn,
        );
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.service_id {
            params.put(&format!("{}{}", prefix, "ServiceId"), &field_value);
        }
        if let Some(ref field_value) = obj.vpc_endpoint_id {
            params.put(&format!("{}{}", prefix, "VpcEndpointId"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateVpcEndpointConnectionNotificationResult {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub client_token: Option<String>,
    /// <p>Information about the notification.</p>
    pub connection_notification: Option<ConnectionNotification>,
}

#[allow(dead_code)]
struct CreateVpcEndpointConnectionNotificationResultDeserializer;
impl CreateVpcEndpointConnectionNotificationResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateVpcEndpointConnectionNotificationResult, XmlParseError> {
        deserialize_elements::<_, CreateVpcEndpointConnectionNotificationResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "clientToken" => {
                        obj.client_token =
                            Some(StringDeserializer::deserialize("clientToken", stack)?);
                    }
                    "connectionNotification" => {
                        obj.connection_notification =
                            Some(ConnectionNotificationDeserializer::deserialize(
                                "connectionNotification",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Contains the parameters for CreateVpcEndpoint.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateVpcEndpointRequest {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure Idempotency</a>.</p>
    pub client_token: Option<String>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>(Interface and gateway endpoints) A policy to attach to the endpoint that controls access to the service. The policy must be in valid JSON format. If this parameter is not specified, we attach a default policy that allows full access to the service.</p>
    pub policy_document: Option<String>,
    /// <p>(Interface endpoint) Indicates whether to associate a private hosted zone with the specified VPC. The private hosted zone contains a record set for the default public DNS name for the service for the Region (for example, <code>kinesis.us-east-1.amazonaws.com</code>), which resolves to the private IP addresses of the endpoint network interfaces in the VPC. This enables you to make requests to the default public DNS name for the service instead of the public DNS names that are automatically generated by the VPC endpoint service.</p> <p>To use a private hosted zone, you must set the following VPC attributes to <code>true</code>: <code>enableDnsHostnames</code> and <code>enableDnsSupport</code>. Use <a>ModifyVpcAttribute</a> to set the VPC attributes.</p> <p>Default: <code>true</code> </p>
    pub private_dns_enabled: Option<bool>,
    /// <p>(Gateway endpoint) One or more route table IDs.</p>
    pub route_table_ids: Option<Vec<String>>,
    /// <p>(Interface endpoint) The ID of one or more security groups to associate with the endpoint network interface.</p>
    pub security_group_ids: Option<Vec<String>>,
    /// <p>The service name. To get a list of available services, use the <a>DescribeVpcEndpointServices</a> request, or get the name from the service provider.</p>
    pub service_name: String,
    /// <p>(Interface and Gateway Load Balancer endpoints) The ID of one or more subnets in which to create an endpoint network interface. For a Gateway Load Balancer endpoint, you can specify one subnet only.</p>
    pub subnet_ids: Option<Vec<String>>,
    /// <p>The tags to associate with the endpoint.</p>
    pub tag_specifications: Option<Vec<TagSpecification>>,
    /// <p>The type of endpoint.</p> <p>Default: Gateway</p>
    pub vpc_endpoint_type: Option<String>,
    /// <p>The ID of the VPC in which the endpoint will be used.</p>
    pub vpc_id: String,
}

/// Serialize `CreateVpcEndpointRequest` contents to a `SignedRequest`.
struct CreateVpcEndpointRequestSerializer;
impl CreateVpcEndpointRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateVpcEndpointRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.client_token {
            params.put(&format!("{}{}", prefix, "ClientToken"), &field_value);
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.policy_document {
            params.put(&format!("{}{}", prefix, "PolicyDocument"), &field_value);
        }
        if let Some(ref field_value) = obj.private_dns_enabled {
            params.put(&format!("{}{}", prefix, "PrivateDnsEnabled"), &field_value);
        }
        if let Some(ref field_value) = obj.route_table_ids {
            VpcEndpointRouteTableIdListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "RouteTableId"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.security_group_ids {
            VpcEndpointSecurityGroupIdListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "SecurityGroupId"),
                field_value,
            );
        }
        params.put(&format!("{}{}", prefix, "ServiceName"), &obj.service_name);
        if let Some(ref field_value) = obj.subnet_ids {
            VpcEndpointSubnetIdListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "SubnetId"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.tag_specifications {
            TagSpecificationListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagSpecification"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.vpc_endpoint_type {
            params.put(&format!("{}{}", prefix, "VpcEndpointType"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "VpcId"), &obj.vpc_id);
    }
}

/// <p>Contains the output of CreateVpcEndpoint.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateVpcEndpointResult {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub client_token: Option<String>,
    /// <p>Information about the endpoint.</p>
    pub vpc_endpoint: Option<VpcEndpoint>,
}

#[allow(dead_code)]
struct CreateVpcEndpointResultDeserializer;
impl CreateVpcEndpointResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateVpcEndpointResult, XmlParseError> {
        deserialize_elements::<_, CreateVpcEndpointResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "clientToken" => {
                        obj.client_token =
                            Some(StringDeserializer::deserialize("clientToken", stack)?);
                    }
                    "vpcEndpoint" => {
                        obj.vpc_endpoint =
                            Some(VpcEndpointDeserializer::deserialize("vpcEndpoint", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateVpcEndpointServiceConfigurationRequest {
    /// <p>Indicates whether requests from service consumers to create an endpoint to your service must be accepted. To accept a request, use <a>AcceptVpcEndpointConnections</a>.</p>
    pub acceptance_required: Option<bool>,
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure Idempotency</a>.</p>
    pub client_token: Option<String>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The Amazon Resource Names (ARNs) of one or more Gateway Load Balancers.</p>
    pub gateway_load_balancer_arns: Option<Vec<String>>,
    /// <p>The Amazon Resource Names (ARNs) of one or more Network Load Balancers for your service.</p>
    pub network_load_balancer_arns: Option<Vec<String>>,
    /// <p>(Interface endpoint configuration) The private DNS name to assign to the VPC endpoint service.</p>
    pub private_dns_name: Option<String>,
    /// <p>The tags to associate with the service.</p>
    pub tag_specifications: Option<Vec<TagSpecification>>,
}

/// Serialize `CreateVpcEndpointServiceConfigurationRequest` contents to a `SignedRequest`.
struct CreateVpcEndpointServiceConfigurationRequestSerializer;
impl CreateVpcEndpointServiceConfigurationRequestSerializer {
    fn serialize(
        params: &mut Params,
        name: &str,
        obj: &CreateVpcEndpointServiceConfigurationRequest,
    ) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.acceptance_required {
            params.put(&format!("{}{}", prefix, "AcceptanceRequired"), &field_value);
        }
        if let Some(ref field_value) = obj.client_token {
            params.put(&format!("{}{}", prefix, "ClientToken"), &field_value);
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.gateway_load_balancer_arns {
            ValueStringListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "GatewayLoadBalancerArn"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.network_load_balancer_arns {
            ValueStringListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "NetworkLoadBalancerArn"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.private_dns_name {
            params.put(&format!("{}{}", prefix, "PrivateDnsName"), &field_value);
        }
        if let Some(ref field_value) = obj.tag_specifications {
            TagSpecificationListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagSpecification"),
                field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateVpcEndpointServiceConfigurationResult {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub client_token: Option<String>,
    /// <p>Information about the service configuration.</p>
    pub service_configuration: Option<ServiceConfiguration>,
}

#[allow(dead_code)]
struct CreateVpcEndpointServiceConfigurationResultDeserializer;
impl CreateVpcEndpointServiceConfigurationResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateVpcEndpointServiceConfigurationResult, XmlParseError> {
        deserialize_elements::<_, CreateVpcEndpointServiceConfigurationResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "clientToken" => {
                        obj.client_token =
                            Some(StringDeserializer::deserialize("clientToken", stack)?);
                    }
                    "serviceConfiguration" => {
                        obj.service_configuration =
                            Some(ServiceConfigurationDeserializer::deserialize(
                                "serviceConfiguration",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateVpcPeeringConnectionRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The AWS account ID of the owner of the accepter VPC.</p> <p>Default: Your AWS account ID</p>
    pub peer_owner_id: Option<String>,
    /// <p>The Region code for the accepter VPC, if the accepter VPC is located in a Region other than the Region in which you make the request.</p> <p>Default: The Region in which you make the request.</p>
    pub peer_region: Option<String>,
    /// <p>The ID of the VPC with which you are creating the VPC peering connection. You must specify this parameter in the request.</p>
    pub peer_vpc_id: Option<String>,
    /// <p>The tags to assign to the peering connection.</p>
    pub tag_specifications: Option<Vec<TagSpecification>>,
    /// <p>The ID of the requester VPC. You must specify this parameter in the request.</p>
    pub vpc_id: Option<String>,
}

/// Serialize `CreateVpcPeeringConnectionRequest` contents to a `SignedRequest`.
struct CreateVpcPeeringConnectionRequestSerializer;
impl CreateVpcPeeringConnectionRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateVpcPeeringConnectionRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.peer_owner_id {
            params.put(&format!("{}{}", prefix, "PeerOwnerId"), &field_value);
        }
        if let Some(ref field_value) = obj.peer_region {
            params.put(&format!("{}{}", prefix, "PeerRegion"), &field_value);
        }
        if let Some(ref field_value) = obj.peer_vpc_id {
            params.put(&format!("{}{}", prefix, "PeerVpcId"), &field_value);
        }
        if let Some(ref field_value) = obj.tag_specifications {
            TagSpecificationListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagSpecification"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.vpc_id {
            params.put(&format!("{}{}", prefix, "VpcId"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateVpcPeeringConnectionResult {
    /// <p>Information about the VPC peering connection.</p>
    pub vpc_peering_connection: Option<VpcPeeringConnection>,
}

#[allow(dead_code)]
struct CreateVpcPeeringConnectionResultDeserializer;
impl CreateVpcPeeringConnectionResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateVpcPeeringConnectionResult, XmlParseError> {
        deserialize_elements::<_, CreateVpcPeeringConnectionResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "vpcPeeringConnection" => {
                        obj.vpc_peering_connection =
                            Some(VpcPeeringConnectionDeserializer::deserialize(
                                "vpcPeeringConnection",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateVpcRequest {
    /// <p>Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC. You cannot specify the range of IP addresses, or the size of the CIDR block.</p>
    pub amazon_provided_ipv_6_cidr_block: Option<bool>,
    /// <p>The IPv4 network range for the VPC, in CIDR notation. For example, <code>10.0.0.0/16</code>. We modify the specified CIDR block to its canonical form; for example, if you specify <code>100.68.0.18/18</code>, we modify it to <code>100.68.0.0/18</code>.</p>
    pub cidr_block: String,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The tenancy options for instances launched into the VPC. For <code>default</code>, instances are launched with shared tenancy by default. You can launch instances with any tenancy into a shared tenancy VPC. For <code>dedicated</code>, instances are launched as dedicated tenancy instances by default. You can only launch instances with a tenancy of <code>dedicated</code> or <code>host</code> into a dedicated tenancy VPC. </p> <p> <b>Important:</b> The <code>host</code> value cannot be used with this parameter. Use the <code>default</code> or <code>dedicated</code> values only.</p> <p>Default: <code>default</code> </p>
    pub instance_tenancy: Option<String>,
    /// <p>The IPv6 CIDR block from the IPv6 address pool. You must also specify <code>Ipv6Pool</code> in the request.</p> <p>To let Amazon choose the IPv6 CIDR block for you, omit this parameter.</p>
    pub ipv_6_cidr_block: Option<String>,
    /// <p>The name of the location from which we advertise the IPV6 CIDR block. Use this parameter to limit the address to this location.</p> <p> You must set <code>AmazonProvidedIpv6CidrBlock</code> to <code>true</code> to use this parameter.</p>
    pub ipv_6_cidr_block_network_border_group: Option<String>,
    /// <p>The ID of an IPv6 address pool from which to allocate the IPv6 CIDR block.</p>
    pub ipv_6_pool: Option<String>,
    /// <p>The tags to assign to the VPC.</p>
    pub tag_specifications: Option<Vec<TagSpecification>>,
}

/// Serialize `CreateVpcRequest` contents to a `SignedRequest`.
struct CreateVpcRequestSerializer;
impl CreateVpcRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateVpcRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.amazon_provided_ipv_6_cidr_block {
            params.put(
                &format!("{}{}", prefix, "AmazonProvidedIpv6CidrBlock"),
                &field_value,
            );
        }
        params.put(&format!("{}{}", prefix, "CidrBlock"), &obj.cidr_block);
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.instance_tenancy {
            params.put(&format!("{}{}", prefix, "InstanceTenancy"), &field_value);
        }
        if let Some(ref field_value) = obj.ipv_6_cidr_block {
            params.put(&format!("{}{}", prefix, "Ipv6CidrBlock"), &field_value);
        }
        if let Some(ref field_value) = obj.ipv_6_cidr_block_network_border_group {
            params.put(
                &format!("{}{}", prefix, "Ipv6CidrBlockNetworkBorderGroup"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.ipv_6_pool {
            params.put(&format!("{}{}", prefix, "Ipv6Pool"), &field_value);
        }
        if let Some(ref field_value) = obj.tag_specifications {
            TagSpecificationListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagSpecification"),
                field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateVpcResult {
    /// <p>Information about the VPC.</p>
    pub vpc: Option<Vpc>,
}

#[allow(dead_code)]
struct CreateVpcResultDeserializer;
impl CreateVpcResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateVpcResult, XmlParseError> {
        deserialize_elements::<_, CreateVpcResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "vpc" => {
                    obj.vpc = Some(VpcDeserializer::deserialize("vpc", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>Contains the parameters for CreateVpnConnection.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateVpnConnectionRequest {
    /// <p>The ID of the customer gateway.</p>
    pub customer_gateway_id: String,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The options for the VPN connection.</p>
    pub options: Option<VpnConnectionOptionsSpecification>,
    /// <p>The tags to apply to the VPN connection.</p>
    pub tag_specifications: Option<Vec<TagSpecification>>,
    /// <p>The ID of the transit gateway. If you specify a transit gateway, you cannot specify a virtual private gateway.</p>
    pub transit_gateway_id: Option<String>,
    /// <p>The type of VPN connection (<code>ipsec.1</code>).</p>
    pub type_: String,
    /// <p>The ID of the virtual private gateway. If you specify a virtual private gateway, you cannot specify a transit gateway.</p>
    pub vpn_gateway_id: Option<String>,
}

/// Serialize `CreateVpnConnectionRequest` contents to a `SignedRequest`.
struct CreateVpnConnectionRequestSerializer;
impl CreateVpnConnectionRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateVpnConnectionRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "CustomerGatewayId"),
            &obj.customer_gateway_id,
        );
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.options {
            VpnConnectionOptionsSpecificationSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Options"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.tag_specifications {
            TagSpecificationListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagSpecification"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.transit_gateway_id {
            params.put(&format!("{}{}", prefix, "TransitGatewayId"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "Type"), &obj.type_);
        if let Some(ref field_value) = obj.vpn_gateway_id {
            params.put(&format!("{}{}", prefix, "VpnGatewayId"), &field_value);
        }
    }
}

/// <p>Contains the output of CreateVpnConnection.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateVpnConnectionResult {
    /// <p>Information about the VPN connection.</p>
    pub vpn_connection: Option<VpnConnection>,
}

#[allow(dead_code)]
struct CreateVpnConnectionResultDeserializer;
impl CreateVpnConnectionResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateVpnConnectionResult, XmlParseError> {
        deserialize_elements::<_, CreateVpnConnectionResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "vpnConnection" => {
                        obj.vpn_connection = Some(VpnConnectionDeserializer::deserialize(
                            "vpnConnection",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Contains the parameters for CreateVpnConnectionRoute.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateVpnConnectionRouteRequest {
    /// <p>The CIDR block associated with the local subnet of the customer network.</p>
    pub destination_cidr_block: String,
    /// <p>The ID of the VPN connection.</p>
    pub vpn_connection_id: String,
}

/// Serialize `CreateVpnConnectionRouteRequest` contents to a `SignedRequest`.
struct CreateVpnConnectionRouteRequestSerializer;
impl CreateVpnConnectionRouteRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateVpnConnectionRouteRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "DestinationCidrBlock"),
            &obj.destination_cidr_block,
        );
        params.put(
            &format!("{}{}", prefix, "VpnConnectionId"),
            &obj.vpn_connection_id,
        );
    }
}

/// <p>Contains the parameters for CreateVpnGateway.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateVpnGatewayRequest {
    /// <p>A private Autonomous System Number (ASN) for the Amazon side of a BGP session. If you're using a 16-bit ASN, it must be in the 64512 to 65534 range. If you're using a 32-bit ASN, it must be in the 4200000000 to 4294967294 range.</p> <p>Default: 64512</p>
    pub amazon_side_asn: Option<i64>,
    /// <p>The Availability Zone for the virtual private gateway.</p>
    pub availability_zone: Option<String>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The tags to apply to the virtual private gateway.</p>
    pub tag_specifications: Option<Vec<TagSpecification>>,
    /// <p>The type of VPN connection this virtual private gateway supports.</p>
    pub type_: String,
}

/// Serialize `CreateVpnGatewayRequest` contents to a `SignedRequest`.
struct CreateVpnGatewayRequestSerializer;
impl CreateVpnGatewayRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateVpnGatewayRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.amazon_side_asn {
            params.put(&format!("{}{}", prefix, "AmazonSideAsn"), &field_value);
        }
        if let Some(ref field_value) = obj.availability_zone {
            params.put(&format!("{}{}", prefix, "AvailabilityZone"), &field_value);
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.tag_specifications {
            TagSpecificationListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagSpecification"),
                field_value,
            );
        }
        params.put(&format!("{}{}", prefix, "Type"), &obj.type_);
    }
}

/// <p>Contains the output of CreateVpnGateway.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateVpnGatewayResult {
    /// <p>Information about the virtual private gateway.</p>
    pub vpn_gateway: Option<VpnGateway>,
}

#[allow(dead_code)]
struct CreateVpnGatewayResultDeserializer;
impl CreateVpnGatewayResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateVpnGatewayResult, XmlParseError> {
        deserialize_elements::<_, CreateVpnGatewayResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "vpnGateway" => {
                    obj.vpn_gateway =
                        Some(VpnGatewayDeserializer::deserialize("vpnGateway", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>Describes the credit option for CPU usage of a T2, T3, or T3a instance.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreditSpecification {
    /// <p>The credit option for CPU usage of a T2, T3, or T3a instance. Valid values are <code>standard</code> and <code>unlimited</code>.</p>
    pub cpu_credits: Option<String>,
}

#[allow(dead_code)]
struct CreditSpecificationDeserializer;
impl CreditSpecificationDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreditSpecification, XmlParseError> {
        deserialize_elements::<_, CreditSpecification, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "cpuCredits" => {
                    obj.cpu_credits = Some(StringDeserializer::deserialize("cpuCredits", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>The credit option for CPU usage of a T2, T3, or T3a instance.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreditSpecificationRequest {
    /// <p>The credit option for CPU usage of a T2, T3, or T3a instance. Valid values are <code>standard</code> and <code>unlimited</code>.</p>
    pub cpu_credits: String,
}

/// Serialize `CreditSpecificationRequest` contents to a `SignedRequest`.
struct CreditSpecificationRequestSerializer;
impl CreditSpecificationRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreditSpecificationRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "CpuCredits"), &obj.cpu_credits);
    }
}

#[allow(dead_code)]
struct CurrencyCodeValuesDeserializer;
impl CurrencyCodeValuesDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct CurrentGenerationFlagDeserializer;
impl CurrentGenerationFlagDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<bool, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, |s| Ok(bool::from_str(&s).unwrap()))
    }
}
/// <p>Describes a customer gateway.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CustomerGateway {
    /// <p>The customer gateway's Border Gateway Protocol (BGP) Autonomous System Number (ASN).</p>
    pub bgp_asn: Option<String>,
    /// <p>The Amazon Resource Name (ARN) for the customer gateway certificate.</p>
    pub certificate_arn: Option<String>,
    /// <p>The ID of the customer gateway.</p>
    pub customer_gateway_id: Option<String>,
    /// <p>The name of customer gateway device.</p>
    pub device_name: Option<String>,
    /// <p>The Internet-routable IP address of the customer gateway's outside interface.</p>
    pub ip_address: Option<String>,
    /// <p>The current state of the customer gateway (<code>pending | available | deleting | deleted</code>).</p>
    pub state: Option<String>,
    /// <p>Any tags assigned to the customer gateway.</p>
    pub tags: Option<Vec<Tag>>,
    /// <p>The type of VPN connection the customer gateway supports (<code>ipsec.1</code>).</p>
    pub type_: Option<String>,
}

#[allow(dead_code)]
struct CustomerGatewayDeserializer;
impl CustomerGatewayDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CustomerGateway, XmlParseError> {
        deserialize_elements::<_, CustomerGateway, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "bgpAsn" => {
                    obj.bgp_asn = Some(StringDeserializer::deserialize("bgpAsn", stack)?);
                }
                "certificateArn" => {
                    obj.certificate_arn =
                        Some(StringDeserializer::deserialize("certificateArn", stack)?);
                }
                "customerGatewayId" => {
                    obj.customer_gateway_id =
                        Some(StringDeserializer::deserialize("customerGatewayId", stack)?);
                }
                "deviceName" => {
                    obj.device_name = Some(StringDeserializer::deserialize("deviceName", stack)?);
                }
                "ipAddress" => {
                    obj.ip_address = Some(StringDeserializer::deserialize("ipAddress", stack)?);
                }
                "state" => {
                    obj.state = Some(StringDeserializer::deserialize("state", stack)?);
                }
                "tagSet" => {
                    obj.tags
                        .get_or_insert(vec![])
                        .extend(TagListDeserializer::deserialize("tagSet", stack)?);
                }
                "type" => {
                    obj.type_ = Some(StringDeserializer::deserialize("type", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}

/// Serialize `CustomerGatewayIdStringList` contents to a `SignedRequest`.
struct CustomerGatewayIdStringListSerializer;
impl CustomerGatewayIdStringListSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<String>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.{}", name, index + 1);
            params.put(&key, &obj);
        }
    }
}

#[allow(dead_code)]
struct CustomerGatewayListDeserializer;
impl CustomerGatewayListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<CustomerGateway>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "item" {
                obj.push(CustomerGatewayDeserializer::deserialize("item", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct DatafeedSubscriptionStateDeserializer;
impl DatafeedSubscriptionStateDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct DateTimeDeserializer;
impl DateTimeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct DedicatedHostFlagDeserializer;
impl DedicatedHostFlagDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<bool, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, |s| Ok(bool::from_str(&s).unwrap()))
    }
}
#[allow(dead_code)]
struct DefaultNetworkCardIndexDeserializer;
impl DefaultNetworkCardIndexDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<i64, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, |s| Ok(i64::from_str(&s).unwrap()))
    }
}
#[allow(dead_code)]
struct DefaultRouteTableAssociationValueDeserializer;
impl DefaultRouteTableAssociationValueDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct DefaultRouteTablePropagationValueDeserializer;
impl DefaultRouteTablePropagationValueDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct DefaultTargetCapacityTypeDeserializer;
impl DefaultTargetCapacityTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteCarrierGatewayRequest {
    /// <p>The ID of the carrier gateway.</p>
    pub carrier_gateway_id: String,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
}

/// Serialize `DeleteCarrierGatewayRequest` contents to a `SignedRequest`.
struct DeleteCarrierGatewayRequestSerializer;
impl DeleteCarrierGatewayRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteCarrierGatewayRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "CarrierGatewayId"),
            &obj.carrier_gateway_id,
        );
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeleteCarrierGatewayResult {
    /// <p>Information about the carrier gateway.</p>
    pub carrier_gateway: Option<CarrierGateway>,
}

#[allow(dead_code)]
struct DeleteCarrierGatewayResultDeserializer;
impl DeleteCarrierGatewayResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeleteCarrierGatewayResult, XmlParseError> {
        deserialize_elements::<_, DeleteCarrierGatewayResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "carrierGateway" => {
                        obj.carrier_gateway = Some(CarrierGatewayDeserializer::deserialize(
                            "carrierGateway",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteClientVpnEndpointRequest {
    /// <p>The ID of the Client VPN to be deleted.</p>
    pub client_vpn_endpoint_id: String,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
}

/// Serialize `DeleteClientVpnEndpointRequest` contents to a `SignedRequest`.
struct DeleteClientVpnEndpointRequestSerializer;
impl DeleteClientVpnEndpointRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteClientVpnEndpointRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "ClientVpnEndpointId"),
            &obj.client_vpn_endpoint_id,
        );
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeleteClientVpnEndpointResult {
    /// <p>The current state of the Client VPN endpoint.</p>
    pub status: Option<ClientVpnEndpointStatus>,
}

#[allow(dead_code)]
struct DeleteClientVpnEndpointResultDeserializer;
impl DeleteClientVpnEndpointResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeleteClientVpnEndpointResult, XmlParseError> {
        deserialize_elements::<_, DeleteClientVpnEndpointResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "status" => {
                        obj.status = Some(ClientVpnEndpointStatusDeserializer::deserialize(
                            "status", stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteClientVpnRouteRequest {
    /// <p>The ID of the Client VPN endpoint from which the route is to be deleted.</p>
    pub client_vpn_endpoint_id: String,
    /// <p>The IPv4 address range, in CIDR notation, of the route to be deleted.</p>
    pub destination_cidr_block: String,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the target subnet used by the route.</p>
    pub target_vpc_subnet_id: Option<String>,
}

/// Serialize `DeleteClientVpnRouteRequest` contents to a `SignedRequest`.
struct DeleteClientVpnRouteRequestSerializer;
impl DeleteClientVpnRouteRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteClientVpnRouteRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "ClientVpnEndpointId"),
            &obj.client_vpn_endpoint_id,
        );
        params.put(
            &format!("{}{}", prefix, "DestinationCidrBlock"),
            &obj.destination_cidr_block,
        );
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.target_vpc_subnet_id {
            params.put(&format!("{}{}", prefix, "TargetVpcSubnetId"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeleteClientVpnRouteResult {
    /// <p>The current state of the route.</p>
    pub status: Option<ClientVpnRouteStatus>,
}

#[allow(dead_code)]
struct DeleteClientVpnRouteResultDeserializer;
impl DeleteClientVpnRouteResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeleteClientVpnRouteResult, XmlParseError> {
        deserialize_elements::<_, DeleteClientVpnRouteResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "status" => {
                        obj.status = Some(ClientVpnRouteStatusDeserializer::deserialize(
                            "status", stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Contains the parameters for DeleteCustomerGateway.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteCustomerGatewayRequest {
    /// <p>The ID of the customer gateway.</p>
    pub customer_gateway_id: String,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
}

/// Serialize `DeleteCustomerGatewayRequest` contents to a `SignedRequest`.
struct DeleteCustomerGatewayRequestSerializer;
impl DeleteCustomerGatewayRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteCustomerGatewayRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "CustomerGatewayId"),
            &obj.customer_gateway_id,
        );
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteDhcpOptionsRequest {
    /// <p>The ID of the DHCP options set.</p>
    pub dhcp_options_id: String,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
}

/// Serialize `DeleteDhcpOptionsRequest` contents to a `SignedRequest`.
struct DeleteDhcpOptionsRequestSerializer;
impl DeleteDhcpOptionsRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteDhcpOptionsRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "DhcpOptionsId"),
            &obj.dhcp_options_id,
        );
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteEgressOnlyInternetGatewayRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the egress-only internet gateway.</p>
    pub egress_only_internet_gateway_id: String,
}

/// Serialize `DeleteEgressOnlyInternetGatewayRequest` contents to a `SignedRequest`.
struct DeleteEgressOnlyInternetGatewayRequestSerializer;
impl DeleteEgressOnlyInternetGatewayRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteEgressOnlyInternetGatewayRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "EgressOnlyInternetGatewayId"),
            &obj.egress_only_internet_gateway_id,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeleteEgressOnlyInternetGatewayResult {
    /// <p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>
    pub return_code: Option<bool>,
}

#[allow(dead_code)]
struct DeleteEgressOnlyInternetGatewayResultDeserializer;
impl DeleteEgressOnlyInternetGatewayResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeleteEgressOnlyInternetGatewayResult, XmlParseError> {
        deserialize_elements::<_, DeleteEgressOnlyInternetGatewayResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "returnCode" => {
                        obj.return_code =
                            Some(BooleanDeserializer::deserialize("returnCode", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Describes an EC2 Fleet error.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeleteFleetError {
    /// <p>The error code.</p>
    pub code: Option<String>,
    /// <p>The description for the error code.</p>
    pub message: Option<String>,
}

#[allow(dead_code)]
struct DeleteFleetErrorDeserializer;
impl DeleteFleetErrorDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeleteFleetError, XmlParseError> {
        deserialize_elements::<_, DeleteFleetError, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "code" => {
                    obj.code = Some(DeleteFleetErrorCodeDeserializer::deserialize(
                        "code", stack,
                    )?);
                }
                "message" => {
                    obj.message = Some(StringDeserializer::deserialize("message", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct DeleteFleetErrorCodeDeserializer;
impl DeleteFleetErrorCodeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p>Describes an EC2 Fleet that was not successfully deleted.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeleteFleetErrorItem {
    /// <p>The error.</p>
    pub error: Option<DeleteFleetError>,
    /// <p>The ID of the EC2 Fleet.</p>
    pub fleet_id: Option<String>,
}

#[allow(dead_code)]
struct DeleteFleetErrorItemDeserializer;
impl DeleteFleetErrorItemDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeleteFleetErrorItem, XmlParseError> {
        deserialize_elements::<_, DeleteFleetErrorItem, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "error" => {
                    obj.error = Some(DeleteFleetErrorDeserializer::deserialize("error", stack)?);
                }
                "fleetId" => {
                    obj.fleet_id = Some(FleetIdDeserializer::deserialize("fleetId", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct DeleteFleetErrorSetDeserializer;
impl DeleteFleetErrorSetDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<DeleteFleetErrorItem>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "item" {
                obj.push(DeleteFleetErrorItemDeserializer::deserialize(
                    "item", stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Describes an EC2 Fleet that was successfully deleted.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeleteFleetSuccessItem {
    /// <p>The current state of the EC2 Fleet.</p>
    pub current_fleet_state: Option<String>,
    /// <p>The ID of the EC2 Fleet.</p>
    pub fleet_id: Option<String>,
    /// <p>The previous state of the EC2 Fleet.</p>
    pub previous_fleet_state: Option<String>,
}

#[allow(dead_code)]
struct DeleteFleetSuccessItemDeserializer;
impl DeleteFleetSuccessItemDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeleteFleetSuccessItem, XmlParseError> {
        deserialize_elements::<_, DeleteFleetSuccessItem, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "currentFleetState" => {
                    obj.current_fleet_state = Some(FleetStateCodeDeserializer::deserialize(
                        "currentFleetState",
                        stack,
                    )?);
                }
                "fleetId" => {
                    obj.fleet_id = Some(FleetIdDeserializer::deserialize("fleetId", stack)?);
                }
                "previousFleetState" => {
                    obj.previous_fleet_state = Some(FleetStateCodeDeserializer::deserialize(
                        "previousFleetState",
                        stack,
                    )?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct DeleteFleetSuccessSetDeserializer;
impl DeleteFleetSuccessSetDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<DeleteFleetSuccessItem>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "item" {
                obj.push(DeleteFleetSuccessItemDeserializer::deserialize(
                    "item", stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteFleetsRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The IDs of the EC2 Fleets.</p>
    pub fleet_ids: Vec<String>,
    /// <p>Indicates whether to terminate the instances when the EC2 Fleet is deleted. The default is to terminate the instances.</p> <p>To let the instances continue to run after the EC2 Fleet is deleted, specify <code>NoTerminateInstances</code>. Supported only for fleets of type <code>maintain</code> and <code>request</code>.</p> <p>For <code>instant</code> fleets, you cannot specify <code>NoTerminateInstances</code>. A deleted <code>instant</code> fleet with running instances is not supported.</p>
    pub terminate_instances: bool,
}

/// Serialize `DeleteFleetsRequest` contents to a `SignedRequest`.
struct DeleteFleetsRequestSerializer;
impl DeleteFleetsRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteFleetsRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        FleetIdSetSerializer::serialize(
            params,
            &format!("{}{}", prefix, "FleetId"),
            &obj.fleet_ids,
        );
        params.put(
            &format!("{}{}", prefix, "TerminateInstances"),
            &obj.terminate_instances,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeleteFleetsResult {
    /// <p>Information about the EC2 Fleets that are successfully deleted.</p>
    pub successful_fleet_deletions: Option<Vec<DeleteFleetSuccessItem>>,
    /// <p>Information about the EC2 Fleets that are not successfully deleted.</p>
    pub unsuccessful_fleet_deletions: Option<Vec<DeleteFleetErrorItem>>,
}

#[allow(dead_code)]
struct DeleteFleetsResultDeserializer;
impl DeleteFleetsResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeleteFleetsResult, XmlParseError> {
        deserialize_elements::<_, DeleteFleetsResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "successfulFleetDeletionSet" => {
                    obj.successful_fleet_deletions.get_or_insert(vec![]).extend(
                        DeleteFleetSuccessSetDeserializer::deserialize(
                            "successfulFleetDeletionSet",
                            stack,
                        )?,
                    );
                }
                "unsuccessfulFleetDeletionSet" => {
                    obj.unsuccessful_fleet_deletions
                        .get_or_insert(vec![])
                        .extend(DeleteFleetErrorSetDeserializer::deserialize(
                            "unsuccessfulFleetDeletionSet",
                            stack,
                        )?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteFlowLogsRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>One or more flow log IDs.</p> <p>Constraint: Maximum of 1000 flow log IDs.</p>
    pub flow_log_ids: Vec<String>,
}

/// Serialize `DeleteFlowLogsRequest` contents to a `SignedRequest`.
struct DeleteFlowLogsRequestSerializer;
impl DeleteFlowLogsRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteFlowLogsRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        FlowLogIdListSerializer::serialize(
            params,
            &format!("{}{}", prefix, "FlowLogId"),
            &obj.flow_log_ids,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeleteFlowLogsResult {
    /// <p>Information about the flow logs that could not be deleted successfully.</p>
    pub unsuccessful: Option<Vec<UnsuccessfulItem>>,
}

#[allow(dead_code)]
struct DeleteFlowLogsResultDeserializer;
impl DeleteFlowLogsResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeleteFlowLogsResult, XmlParseError> {
        deserialize_elements::<_, DeleteFlowLogsResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "unsuccessful" => {
                    obj.unsuccessful.get_or_insert(vec![]).extend(
                        UnsuccessfulItemSetDeserializer::deserialize("unsuccessful", stack)?,
                    );
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteFpgaImageRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the AFI.</p>
    pub fpga_image_id: String,
}

/// Serialize `DeleteFpgaImageRequest` contents to a `SignedRequest`.
struct DeleteFpgaImageRequestSerializer;
impl DeleteFpgaImageRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteFpgaImageRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "FpgaImageId"), &obj.fpga_image_id);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeleteFpgaImageResult {
    /// <p>Is <code>true</code> if the request succeeds, and an error otherwise.</p>
    pub return_: Option<bool>,
}

#[allow(dead_code)]
struct DeleteFpgaImageResultDeserializer;
impl DeleteFpgaImageResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeleteFpgaImageResult, XmlParseError> {
        deserialize_elements::<_, DeleteFpgaImageResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "return" => {
                    obj.return_ = Some(BooleanDeserializer::deserialize("return", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteInternetGatewayRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the internet gateway.</p>
    pub internet_gateway_id: String,
}

/// Serialize `DeleteInternetGatewayRequest` contents to a `SignedRequest`.
struct DeleteInternetGatewayRequestSerializer;
impl DeleteInternetGatewayRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteInternetGatewayRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "InternetGatewayId"),
            &obj.internet_gateway_id,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteKeyPairRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The name of the key pair.</p>
    pub key_name: Option<String>,
    /// <p>The ID of the key pair.</p>
    pub key_pair_id: Option<String>,
}

/// Serialize `DeleteKeyPairRequest` contents to a `SignedRequest`.
struct DeleteKeyPairRequestSerializer;
impl DeleteKeyPairRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteKeyPairRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.key_name {
            params.put(&format!("{}{}", prefix, "KeyName"), &field_value);
        }
        if let Some(ref field_value) = obj.key_pair_id {
            params.put(&format!("{}{}", prefix, "KeyPairId"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteLaunchTemplateRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the launch template. You must specify either the launch template ID or launch template name in the request.</p>
    pub launch_template_id: Option<String>,
    /// <p>The name of the launch template. You must specify either the launch template ID or launch template name in the request.</p>
    pub launch_template_name: Option<String>,
}

/// Serialize `DeleteLaunchTemplateRequest` contents to a `SignedRequest`.
struct DeleteLaunchTemplateRequestSerializer;
impl DeleteLaunchTemplateRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteLaunchTemplateRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.launch_template_id {
            params.put(&format!("{}{}", prefix, "LaunchTemplateId"), &field_value);
        }
        if let Some(ref field_value) = obj.launch_template_name {
            params.put(&format!("{}{}", prefix, "LaunchTemplateName"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeleteLaunchTemplateResult {
    /// <p>Information about the launch template.</p>
    pub launch_template: Option<LaunchTemplate>,
}

#[allow(dead_code)]
struct DeleteLaunchTemplateResultDeserializer;
impl DeleteLaunchTemplateResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeleteLaunchTemplateResult, XmlParseError> {
        deserialize_elements::<_, DeleteLaunchTemplateResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "launchTemplate" => {
                        obj.launch_template = Some(LaunchTemplateDeserializer::deserialize(
                            "launchTemplate",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteLaunchTemplateVersionsRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the launch template. You must specify either the launch template ID or launch template name in the request.</p>
    pub launch_template_id: Option<String>,
    /// <p>The name of the launch template. You must specify either the launch template ID or launch template name in the request.</p>
    pub launch_template_name: Option<String>,
    /// <p>The version numbers of one or more launch template versions to delete.</p>
    pub versions: Vec<String>,
}

/// Serialize `DeleteLaunchTemplateVersionsRequest` contents to a `SignedRequest`.
struct DeleteLaunchTemplateVersionsRequestSerializer;
impl DeleteLaunchTemplateVersionsRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteLaunchTemplateVersionsRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.launch_template_id {
            params.put(&format!("{}{}", prefix, "LaunchTemplateId"), &field_value);
        }
        if let Some(ref field_value) = obj.launch_template_name {
            params.put(&format!("{}{}", prefix, "LaunchTemplateName"), &field_value);
        }
        VersionStringListSerializer::serialize(
            params,
            &format!("{}{}", prefix, "LaunchTemplateVersion"),
            &obj.versions,
        );
    }
}

/// <p>Describes a launch template version that could not be deleted.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeleteLaunchTemplateVersionsResponseErrorItem {
    /// <p>The ID of the launch template.</p>
    pub launch_template_id: Option<String>,
    /// <p>The name of the launch template.</p>
    pub launch_template_name: Option<String>,
    /// <p>Information about the error.</p>
    pub response_error: Option<ResponseError>,
    /// <p>The version number of the launch template.</p>
    pub version_number: Option<i64>,
}

#[allow(dead_code)]
struct DeleteLaunchTemplateVersionsResponseErrorItemDeserializer;
impl DeleteLaunchTemplateVersionsResponseErrorItemDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeleteLaunchTemplateVersionsResponseErrorItem, XmlParseError> {
        deserialize_elements::<_, DeleteLaunchTemplateVersionsResponseErrorItem, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "launchTemplateId" => {
                        obj.launch_template_id =
                            Some(StringDeserializer::deserialize("launchTemplateId", stack)?);
                    }
                    "launchTemplateName" => {
                        obj.launch_template_name = Some(StringDeserializer::deserialize(
                            "launchTemplateName",
                            stack,
                        )?);
                    }
                    "responseError" => {
                        obj.response_error = Some(ResponseErrorDeserializer::deserialize(
                            "responseError",
                            stack,
                        )?);
                    }
                    "versionNumber" => {
                        obj.version_number =
                            Some(LongDeserializer::deserialize("versionNumber", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct DeleteLaunchTemplateVersionsResponseErrorSetDeserializer;
impl DeleteLaunchTemplateVersionsResponseErrorSetDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<DeleteLaunchTemplateVersionsResponseErrorItem>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "item" {
                obj.push(
                    DeleteLaunchTemplateVersionsResponseErrorItemDeserializer::deserialize(
                        "item", stack,
                    )?,
                );
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Describes a launch template version that was successfully deleted.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeleteLaunchTemplateVersionsResponseSuccessItem {
    /// <p>The ID of the launch template.</p>
    pub launch_template_id: Option<String>,
    /// <p>The name of the launch template.</p>
    pub launch_template_name: Option<String>,
    /// <p>The version number of the launch template.</p>
    pub version_number: Option<i64>,
}

#[allow(dead_code)]
struct DeleteLaunchTemplateVersionsResponseSuccessItemDeserializer;
impl DeleteLaunchTemplateVersionsResponseSuccessItemDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeleteLaunchTemplateVersionsResponseSuccessItem, XmlParseError> {
        deserialize_elements::<_, DeleteLaunchTemplateVersionsResponseSuccessItem, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "launchTemplateId" => {
                        obj.launch_template_id =
                            Some(StringDeserializer::deserialize("launchTemplateId", stack)?);
                    }
                    "launchTemplateName" => {
                        obj.launch_template_name = Some(StringDeserializer::deserialize(
                            "launchTemplateName",
                            stack,
                        )?);
                    }
                    "versionNumber" => {
                        obj.version_number =
                            Some(LongDeserializer::deserialize("versionNumber", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct DeleteLaunchTemplateVersionsResponseSuccessSetDeserializer;
impl DeleteLaunchTemplateVersionsResponseSuccessSetDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<DeleteLaunchTemplateVersionsResponseSuccessItem>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "item" {
                obj.push(
                    DeleteLaunchTemplateVersionsResponseSuccessItemDeserializer::deserialize(
                        "item", stack,
                    )?,
                );
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeleteLaunchTemplateVersionsResult {
    /// <p>Information about the launch template versions that were successfully deleted.</p>
    pub successfully_deleted_launch_template_versions:
        Option<Vec<DeleteLaunchTemplateVersionsResponseSuccessItem>>,
    /// <p>Information about the launch template versions that could not be deleted.</p>
    pub unsuccessfully_deleted_launch_template_versions:
        Option<Vec<DeleteLaunchTemplateVersionsResponseErrorItem>>,
}

#[allow(dead_code)]
struct DeleteLaunchTemplateVersionsResultDeserializer;
impl DeleteLaunchTemplateVersionsResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeleteLaunchTemplateVersionsResult, XmlParseError> {
        deserialize_elements::<_, DeleteLaunchTemplateVersionsResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "successfullyDeletedLaunchTemplateVersionSet" => {
                        obj.successfully_deleted_launch_template_versions
                                .get_or_insert(vec![])
                                .extend(DeleteLaunchTemplateVersionsResponseSuccessSetDeserializer::deserialize("successfullyDeletedLaunchTemplateVersionSet", stack)?);
                    }
                    "unsuccessfullyDeletedLaunchTemplateVersionSet" => {
                        obj.unsuccessfully_deleted_launch_template_versions
                                .get_or_insert(vec![])
                                .extend(DeleteLaunchTemplateVersionsResponseErrorSetDeserializer::deserialize("unsuccessfullyDeletedLaunchTemplateVersionSet", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteLocalGatewayRouteRequest {
    /// <p>The CIDR range for the route. This must match the CIDR for the route exactly.</p>
    pub destination_cidr_block: String,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the local gateway route table.</p>
    pub local_gateway_route_table_id: String,
}

/// Serialize `DeleteLocalGatewayRouteRequest` contents to a `SignedRequest`.
struct DeleteLocalGatewayRouteRequestSerializer;
impl DeleteLocalGatewayRouteRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteLocalGatewayRouteRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "DestinationCidrBlock"),
            &obj.destination_cidr_block,
        );
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "LocalGatewayRouteTableId"),
            &obj.local_gateway_route_table_id,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeleteLocalGatewayRouteResult {
    /// <p>Information about the route.</p>
    pub route: Option<LocalGatewayRoute>,
}

#[allow(dead_code)]
struct DeleteLocalGatewayRouteResultDeserializer;
impl DeleteLocalGatewayRouteResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeleteLocalGatewayRouteResult, XmlParseError> {
        deserialize_elements::<_, DeleteLocalGatewayRouteResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "route" => {
                        obj.route =
                            Some(LocalGatewayRouteDeserializer::deserialize("route", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteLocalGatewayRouteTableVpcAssociationRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the association.</p>
    pub local_gateway_route_table_vpc_association_id: String,
}

/// Serialize `DeleteLocalGatewayRouteTableVpcAssociationRequest` contents to a `SignedRequest`.
struct DeleteLocalGatewayRouteTableVpcAssociationRequestSerializer;
impl DeleteLocalGatewayRouteTableVpcAssociationRequestSerializer {
    fn serialize(
        params: &mut Params,
        name: &str,
        obj: &DeleteLocalGatewayRouteTableVpcAssociationRequest,
    ) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "LocalGatewayRouteTableVpcAssociationId"),
            &obj.local_gateway_route_table_vpc_association_id,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeleteLocalGatewayRouteTableVpcAssociationResult {
    /// <p>Information about the association.</p>
    pub local_gateway_route_table_vpc_association: Option<LocalGatewayRouteTableVpcAssociation>,
}

#[allow(dead_code)]
struct DeleteLocalGatewayRouteTableVpcAssociationResultDeserializer;
impl DeleteLocalGatewayRouteTableVpcAssociationResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeleteLocalGatewayRouteTableVpcAssociationResult, XmlParseError> {
        deserialize_elements::<_, DeleteLocalGatewayRouteTableVpcAssociationResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "localGatewayRouteTableVpcAssociation" => {
                        obj.local_gateway_route_table_vpc_association = Some(
                            LocalGatewayRouteTableVpcAssociationDeserializer::deserialize(
                                "localGatewayRouteTableVpcAssociation",
                                stack,
                            )?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteManagedPrefixListRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the prefix list.</p>
    pub prefix_list_id: String,
}

/// Serialize `DeleteManagedPrefixListRequest` contents to a `SignedRequest`.
struct DeleteManagedPrefixListRequestSerializer;
impl DeleteManagedPrefixListRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteManagedPrefixListRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "PrefixListId"),
            &obj.prefix_list_id,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeleteManagedPrefixListResult {
    /// <p>Information about the prefix list.</p>
    pub prefix_list: Option<ManagedPrefixList>,
}

#[allow(dead_code)]
struct DeleteManagedPrefixListResultDeserializer;
impl DeleteManagedPrefixListResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeleteManagedPrefixListResult, XmlParseError> {
        deserialize_elements::<_, DeleteManagedPrefixListResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "prefixList" => {
                        obj.prefix_list = Some(ManagedPrefixListDeserializer::deserialize(
                            "prefixList",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteNatGatewayRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the NAT gateway.</p>
    pub nat_gateway_id: String,
}

/// Serialize `DeleteNatGatewayRequest` contents to a `SignedRequest`.
struct DeleteNatGatewayRequestSerializer;
impl DeleteNatGatewayRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteNatGatewayRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "NatGatewayId"),
            &obj.nat_gateway_id,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeleteNatGatewayResult {
    /// <p>The ID of the NAT gateway.</p>
    pub nat_gateway_id: Option<String>,
}

#[allow(dead_code)]
struct DeleteNatGatewayResultDeserializer;
impl DeleteNatGatewayResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeleteNatGatewayResult, XmlParseError> {
        deserialize_elements::<_, DeleteNatGatewayResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "natGatewayId" => {
                    obj.nat_gateway_id =
                        Some(StringDeserializer::deserialize("natGatewayId", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteNetworkAclEntryRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>Indicates whether the rule is an egress rule.</p>
    pub egress: bool,
    /// <p>The ID of the network ACL.</p>
    pub network_acl_id: String,
    /// <p>The rule number of the entry to delete.</p>
    pub rule_number: i64,
}

/// Serialize `DeleteNetworkAclEntryRequest` contents to a `SignedRequest`.
struct DeleteNetworkAclEntryRequestSerializer;
impl DeleteNetworkAclEntryRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteNetworkAclEntryRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "Egress"), &obj.egress);
        params.put(
            &format!("{}{}", prefix, "NetworkAclId"),
            &obj.network_acl_id,
        );
        params.put(&format!("{}{}", prefix, "RuleNumber"), &obj.rule_number);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteNetworkAclRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the network ACL.</p>
    pub network_acl_id: String,
}

/// Serialize `DeleteNetworkAclRequest` contents to a `SignedRequest`.
struct DeleteNetworkAclRequestSerializer;
impl DeleteNetworkAclRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteNetworkAclRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "NetworkAclId"),
            &obj.network_acl_id,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteNetworkInsightsAnalysisRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the network insights analysis.</p>
    pub network_insights_analysis_id: String,
}

/// Serialize `DeleteNetworkInsightsAnalysisRequest` contents to a `SignedRequest`.
struct DeleteNetworkInsightsAnalysisRequestSerializer;
impl DeleteNetworkInsightsAnalysisRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteNetworkInsightsAnalysisRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "NetworkInsightsAnalysisId"),
            &obj.network_insights_analysis_id,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeleteNetworkInsightsAnalysisResult {
    /// <p>The ID of the network insights analysis.</p>
    pub network_insights_analysis_id: Option<String>,
}

#[allow(dead_code)]
struct DeleteNetworkInsightsAnalysisResultDeserializer;
impl DeleteNetworkInsightsAnalysisResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeleteNetworkInsightsAnalysisResult, XmlParseError> {
        deserialize_elements::<_, DeleteNetworkInsightsAnalysisResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "networkInsightsAnalysisId" => {
                        obj.network_insights_analysis_id =
                            Some(NetworkInsightsAnalysisIdDeserializer::deserialize(
                                "networkInsightsAnalysisId",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteNetworkInsightsPathRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the path.</p>
    pub network_insights_path_id: String,
}

/// Serialize `DeleteNetworkInsightsPathRequest` contents to a `SignedRequest`.
struct DeleteNetworkInsightsPathRequestSerializer;
impl DeleteNetworkInsightsPathRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteNetworkInsightsPathRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "NetworkInsightsPathId"),
            &obj.network_insights_path_id,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeleteNetworkInsightsPathResult {
    /// <p>The ID of the path.</p>
    pub network_insights_path_id: Option<String>,
}

#[allow(dead_code)]
struct DeleteNetworkInsightsPathResultDeserializer;
impl DeleteNetworkInsightsPathResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeleteNetworkInsightsPathResult, XmlParseError> {
        deserialize_elements::<_, DeleteNetworkInsightsPathResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "networkInsightsPathId" => {
                        obj.network_insights_path_id =
                            Some(NetworkInsightsPathIdDeserializer::deserialize(
                                "networkInsightsPathId",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Contains the parameters for DeleteNetworkInterfacePermission.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteNetworkInterfacePermissionRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>Specify <code>true</code> to remove the permission even if the network interface is attached to an instance.</p>
    pub force: Option<bool>,
    /// <p>The ID of the network interface permission.</p>
    pub network_interface_permission_id: String,
}

/// Serialize `DeleteNetworkInterfacePermissionRequest` contents to a `SignedRequest`.
struct DeleteNetworkInterfacePermissionRequestSerializer;
impl DeleteNetworkInterfacePermissionRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteNetworkInterfacePermissionRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.force {
            params.put(&format!("{}{}", prefix, "Force"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "NetworkInterfacePermissionId"),
            &obj.network_interface_permission_id,
        );
    }
}

/// <p>Contains the output for DeleteNetworkInterfacePermission.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeleteNetworkInterfacePermissionResult {
    /// <p>Returns <code>true</code> if the request succeeds, otherwise returns an error.</p>
    pub return_: Option<bool>,
}

#[allow(dead_code)]
struct DeleteNetworkInterfacePermissionResultDeserializer;
impl DeleteNetworkInterfacePermissionResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeleteNetworkInterfacePermissionResult, XmlParseError> {
        deserialize_elements::<_, DeleteNetworkInterfacePermissionResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "return" => {
                        obj.return_ = Some(BooleanDeserializer::deserialize("return", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Contains the parameters for DeleteNetworkInterface.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteNetworkInterfaceRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the network interface.</p>
    pub network_interface_id: String,
}

/// Serialize `DeleteNetworkInterfaceRequest` contents to a `SignedRequest`.
struct DeleteNetworkInterfaceRequestSerializer;
impl DeleteNetworkInterfaceRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteNetworkInterfaceRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "NetworkInterfaceId"),
            &obj.network_interface_id,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeletePlacementGroupRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The name of the placement group.</p>
    pub group_name: String,
}

/// Serialize `DeletePlacementGroupRequest` contents to a `SignedRequest`.
struct DeletePlacementGroupRequestSerializer;
impl DeletePlacementGroupRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeletePlacementGroupRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "GroupName"), &obj.group_name);
    }
}

/// <p>Describes the error for a Reserved Instance whose queued purchase could not be deleted.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct EC2DeleteQueuedReservedInstancesError {
    /// <p>The error code.</p>
    pub code: Option<String>,
    /// <p>The error message.</p>
    pub message: Option<String>,
}

#[allow(dead_code)]
struct EC2DeleteQueuedReservedInstancesErrorDeserializer;
impl EC2DeleteQueuedReservedInstancesErrorDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<EC2DeleteQueuedReservedInstancesError, XmlParseError> {
        deserialize_elements::<_, EC2DeleteQueuedReservedInstancesError, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "code" => {
                        obj.code = Some(
                            DeleteQueuedReservedInstancesErrorCodeDeserializer::deserialize(
                                "code", stack,
                            )?,
                        );
                    }
                    "message" => {
                        obj.message = Some(StringDeserializer::deserialize("message", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct DeleteQueuedReservedInstancesErrorCodeDeserializer;
impl DeleteQueuedReservedInstancesErrorCodeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}

/// Serialize `DeleteQueuedReservedInstancesIdList` contents to a `SignedRequest`.
struct DeleteQueuedReservedInstancesIdListSerializer;
impl DeleteQueuedReservedInstancesIdListSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<String>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.{}", name, index + 1);
            params.put(&key, &obj);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteQueuedReservedInstancesRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The IDs of the Reserved Instances.</p>
    pub reserved_instances_ids: Vec<String>,
}

/// Serialize `DeleteQueuedReservedInstancesRequest` contents to a `SignedRequest`.
struct DeleteQueuedReservedInstancesRequestSerializer;
impl DeleteQueuedReservedInstancesRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteQueuedReservedInstancesRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        DeleteQueuedReservedInstancesIdListSerializer::serialize(
            params,
            &format!("{}{}", prefix, "ReservedInstancesId"),
            &obj.reserved_instances_ids,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeleteQueuedReservedInstancesResult {
    /// <p>Information about the queued purchases that could not be deleted.</p>
    pub failed_queued_purchase_deletions: Option<Vec<FailedQueuedPurchaseDeletion>>,
    /// <p>Information about the queued purchases that were successfully deleted.</p>
    pub successful_queued_purchase_deletions: Option<Vec<SuccessfulQueuedPurchaseDeletion>>,
}

#[allow(dead_code)]
struct DeleteQueuedReservedInstancesResultDeserializer;
impl DeleteQueuedReservedInstancesResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeleteQueuedReservedInstancesResult, XmlParseError> {
        deserialize_elements::<_, DeleteQueuedReservedInstancesResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "failedQueuedPurchaseDeletionSet" => {
                        obj.failed_queued_purchase_deletions
                            .get_or_insert(vec![])
                            .extend(FailedQueuedPurchaseDeletionSetDeserializer::deserialize(
                                "failedQueuedPurchaseDeletionSet",
                                stack,
                            )?);
                    }
                    "successfulQueuedPurchaseDeletionSet" => {
                        obj.successful_queued_purchase_deletions
                            .get_or_insert(vec![])
                            .extend(
                                SuccessfulQueuedPurchaseDeletionSetDeserializer::deserialize(
                                    "successfulQueuedPurchaseDeletionSet",
                                    stack,
                                )?,
                            );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteRouteRequest {
    /// <p>The IPv4 CIDR range for the route. The value you specify must match the CIDR for the route exactly.</p>
    pub destination_cidr_block: Option<String>,
    /// <p>The IPv6 CIDR range for the route. The value you specify must match the CIDR for the route exactly.</p>
    pub destination_ipv_6_cidr_block: Option<String>,
    /// <p>The ID of the prefix list for the route.</p>
    pub destination_prefix_list_id: Option<String>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the route table.</p>
    pub route_table_id: String,
}

/// Serialize `DeleteRouteRequest` contents to a `SignedRequest`.
struct DeleteRouteRequestSerializer;
impl DeleteRouteRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteRouteRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.destination_cidr_block {
            params.put(
                &format!("{}{}", prefix, "DestinationCidrBlock"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.destination_ipv_6_cidr_block {
            params.put(
                &format!("{}{}", prefix, "DestinationIpv6CidrBlock"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.destination_prefix_list_id {
            params.put(
                &format!("{}{}", prefix, "DestinationPrefixListId"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "RouteTableId"),
            &obj.route_table_id,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteRouteTableRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the route table.</p>
    pub route_table_id: String,
}

/// Serialize `DeleteRouteTableRequest` contents to a `SignedRequest`.
struct DeleteRouteTableRequestSerializer;
impl DeleteRouteTableRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteRouteTableRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "RouteTableId"),
            &obj.route_table_id,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteSecurityGroupRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the security group. Required for a nondefault VPC.</p>
    pub group_id: Option<String>,
    /// <p>[EC2-Classic, default VPC] The name of the security group. You can specify either the security group name or the security group ID.</p>
    pub group_name: Option<String>,
}

/// Serialize `DeleteSecurityGroupRequest` contents to a `SignedRequest`.
struct DeleteSecurityGroupRequestSerializer;
impl DeleteSecurityGroupRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteSecurityGroupRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.group_id {
            params.put(&format!("{}{}", prefix, "GroupId"), &field_value);
        }
        if let Some(ref field_value) = obj.group_name {
            params.put(&format!("{}{}", prefix, "GroupName"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteSnapshotRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the EBS snapshot.</p>
    pub snapshot_id: String,
}

/// Serialize `DeleteSnapshotRequest` contents to a `SignedRequest`.
struct DeleteSnapshotRequestSerializer;
impl DeleteSnapshotRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteSnapshotRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "SnapshotId"), &obj.snapshot_id);
    }
}

/// <p>Contains the parameters for DeleteSpotDatafeedSubscription.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteSpotDatafeedSubscriptionRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
}

/// Serialize `DeleteSpotDatafeedSubscriptionRequest` contents to a `SignedRequest`.
struct DeleteSpotDatafeedSubscriptionRequestSerializer;
impl DeleteSpotDatafeedSubscriptionRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteSpotDatafeedSubscriptionRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteSubnetRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the subnet.</p>
    pub subnet_id: String,
}

/// Serialize `DeleteSubnetRequest` contents to a `SignedRequest`.
struct DeleteSubnetRequestSerializer;
impl DeleteSubnetRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteSubnetRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "SubnetId"), &obj.subnet_id);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteTagsRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The IDs of the resources, separated by spaces.</p> <p>Constraints: Up to 1000 resource IDs. We recommend breaking up this request into smaller batches.</p>
    pub resources: Vec<String>,
    /// <p>The tags to delete. Specify a tag key and an optional tag value to delete specific tags. If you specify a tag key without a tag value, we delete any tag with this key regardless of its value. If you specify a tag key with an empty string as the tag value, we delete the tag only if its value is an empty string.</p> <p>If you omit this parameter, we delete all user-defined tags for the specified resources. We do not delete AWS-generated tags (tags that have the <code>aws:</code> prefix).</p>
    pub tags: Option<Vec<Tag>>,
}

/// Serialize `DeleteTagsRequest` contents to a `SignedRequest`.
struct DeleteTagsRequestSerializer;
impl DeleteTagsRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteTagsRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        ResourceIdListSerializer::serialize(
            params,
            &format!("{}{}", prefix, "ResourceId"),
            &obj.resources,
        );
        if let Some(ref field_value) = obj.tags {
            TagListSerializer::serialize(params, &format!("{}{}", prefix, "Tag"), field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteTrafficMirrorFilterRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the Traffic Mirror filter.</p>
    pub traffic_mirror_filter_id: String,
}

/// Serialize `DeleteTrafficMirrorFilterRequest` contents to a `SignedRequest`.
struct DeleteTrafficMirrorFilterRequestSerializer;
impl DeleteTrafficMirrorFilterRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteTrafficMirrorFilterRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "TrafficMirrorFilterId"),
            &obj.traffic_mirror_filter_id,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeleteTrafficMirrorFilterResult {
    /// <p>The ID of the Traffic Mirror filter.</p>
    pub traffic_mirror_filter_id: Option<String>,
}

#[allow(dead_code)]
struct DeleteTrafficMirrorFilterResultDeserializer;
impl DeleteTrafficMirrorFilterResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeleteTrafficMirrorFilterResult, XmlParseError> {
        deserialize_elements::<_, DeleteTrafficMirrorFilterResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "trafficMirrorFilterId" => {
                        obj.traffic_mirror_filter_id = Some(StringDeserializer::deserialize(
                            "trafficMirrorFilterId",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteTrafficMirrorFilterRuleRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the Traffic Mirror rule.</p>
    pub traffic_mirror_filter_rule_id: String,
}

/// Serialize `DeleteTrafficMirrorFilterRuleRequest` contents to a `SignedRequest`.
struct DeleteTrafficMirrorFilterRuleRequestSerializer;
impl DeleteTrafficMirrorFilterRuleRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteTrafficMirrorFilterRuleRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "TrafficMirrorFilterRuleId"),
            &obj.traffic_mirror_filter_rule_id,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeleteTrafficMirrorFilterRuleResult {
    /// <p>The ID of the deleted Traffic Mirror rule.</p>
    pub traffic_mirror_filter_rule_id: Option<String>,
}

#[allow(dead_code)]
struct DeleteTrafficMirrorFilterRuleResultDeserializer;
impl DeleteTrafficMirrorFilterRuleResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeleteTrafficMirrorFilterRuleResult, XmlParseError> {
        deserialize_elements::<_, DeleteTrafficMirrorFilterRuleResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "trafficMirrorFilterRuleId" => {
                        obj.traffic_mirror_filter_rule_id = Some(StringDeserializer::deserialize(
                            "trafficMirrorFilterRuleId",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteTrafficMirrorSessionRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the Traffic Mirror session.</p>
    pub traffic_mirror_session_id: String,
}

/// Serialize `DeleteTrafficMirrorSessionRequest` contents to a `SignedRequest`.
struct DeleteTrafficMirrorSessionRequestSerializer;
impl DeleteTrafficMirrorSessionRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteTrafficMirrorSessionRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "TrafficMirrorSessionId"),
            &obj.traffic_mirror_session_id,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeleteTrafficMirrorSessionResult {
    /// <p>The ID of the deleted Traffic Mirror session.</p>
    pub traffic_mirror_session_id: Option<String>,
}

#[allow(dead_code)]
struct DeleteTrafficMirrorSessionResultDeserializer;
impl DeleteTrafficMirrorSessionResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeleteTrafficMirrorSessionResult, XmlParseError> {
        deserialize_elements::<_, DeleteTrafficMirrorSessionResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "trafficMirrorSessionId" => {
                        obj.traffic_mirror_session_id = Some(StringDeserializer::deserialize(
                            "trafficMirrorSessionId",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteTrafficMirrorTargetRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the Traffic Mirror target.</p>
    pub traffic_mirror_target_id: String,
}

/// Serialize `DeleteTrafficMirrorTargetRequest` contents to a `SignedRequest`.
struct DeleteTrafficMirrorTargetRequestSerializer;
impl DeleteTrafficMirrorTargetRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteTrafficMirrorTargetRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "TrafficMirrorTargetId"),
            &obj.traffic_mirror_target_id,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeleteTrafficMirrorTargetResult {
    /// <p>The ID of the deleted Traffic Mirror target.</p>
    pub traffic_mirror_target_id: Option<String>,
}

#[allow(dead_code)]
struct DeleteTrafficMirrorTargetResultDeserializer;
impl DeleteTrafficMirrorTargetResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeleteTrafficMirrorTargetResult, XmlParseError> {
        deserialize_elements::<_, DeleteTrafficMirrorTargetResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "trafficMirrorTargetId" => {
                        obj.traffic_mirror_target_id = Some(StringDeserializer::deserialize(
                            "trafficMirrorTargetId",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteTransitGatewayConnectPeerRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the Connect peer.</p>
    pub transit_gateway_connect_peer_id: String,
}

/// Serialize `DeleteTransitGatewayConnectPeerRequest` contents to a `SignedRequest`.
struct DeleteTransitGatewayConnectPeerRequestSerializer;
impl DeleteTransitGatewayConnectPeerRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteTransitGatewayConnectPeerRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "TransitGatewayConnectPeerId"),
            &obj.transit_gateway_connect_peer_id,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeleteTransitGatewayConnectPeerResult {
    /// <p>Information about the deleted Connect peer.</p>
    pub transit_gateway_connect_peer: Option<TransitGatewayConnectPeer>,
}

#[allow(dead_code)]
struct DeleteTransitGatewayConnectPeerResultDeserializer;
impl DeleteTransitGatewayConnectPeerResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeleteTransitGatewayConnectPeerResult, XmlParseError> {
        deserialize_elements::<_, DeleteTransitGatewayConnectPeerResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "transitGatewayConnectPeer" => {
                        obj.transit_gateway_connect_peer =
                            Some(TransitGatewayConnectPeerDeserializer::deserialize(
                                "transitGatewayConnectPeer",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteTransitGatewayConnectRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the Connect attachment.</p>
    pub transit_gateway_attachment_id: String,
}

/// Serialize `DeleteTransitGatewayConnectRequest` contents to a `SignedRequest`.
struct DeleteTransitGatewayConnectRequestSerializer;
impl DeleteTransitGatewayConnectRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteTransitGatewayConnectRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "TransitGatewayAttachmentId"),
            &obj.transit_gateway_attachment_id,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeleteTransitGatewayConnectResult {
    /// <p>Information about the deleted Connect attachment.</p>
    pub transit_gateway_connect: Option<TransitGatewayConnect>,
}

#[allow(dead_code)]
struct DeleteTransitGatewayConnectResultDeserializer;
impl DeleteTransitGatewayConnectResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeleteTransitGatewayConnectResult, XmlParseError> {
        deserialize_elements::<_, DeleteTransitGatewayConnectResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "transitGatewayConnect" => {
                        obj.transit_gateway_connect =
                            Some(TransitGatewayConnectDeserializer::deserialize(
                                "transitGatewayConnect",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteTransitGatewayMulticastDomainRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the transit gateway multicast domain.</p>
    pub transit_gateway_multicast_domain_id: String,
}

/// Serialize `DeleteTransitGatewayMulticastDomainRequest` contents to a `SignedRequest`.
struct DeleteTransitGatewayMulticastDomainRequestSerializer;
impl DeleteTransitGatewayMulticastDomainRequestSerializer {
    fn serialize(
        params: &mut Params,
        name: &str,
        obj: &DeleteTransitGatewayMulticastDomainRequest,
    ) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "TransitGatewayMulticastDomainId"),
            &obj.transit_gateway_multicast_domain_id,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeleteTransitGatewayMulticastDomainResult {
    /// <p>Information about the deleted transit gateway multicast domain.</p>
    pub transit_gateway_multicast_domain: Option<TransitGatewayMulticastDomain>,
}

#[allow(dead_code)]
struct DeleteTransitGatewayMulticastDomainResultDeserializer;
impl DeleteTransitGatewayMulticastDomainResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeleteTransitGatewayMulticastDomainResult, XmlParseError> {
        deserialize_elements::<_, DeleteTransitGatewayMulticastDomainResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "transitGatewayMulticastDomain" => {
                        obj.transit_gateway_multicast_domain =
                            Some(TransitGatewayMulticastDomainDeserializer::deserialize(
                                "transitGatewayMulticastDomain",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteTransitGatewayPeeringAttachmentRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the transit gateway peering attachment.</p>
    pub transit_gateway_attachment_id: String,
}

/// Serialize `DeleteTransitGatewayPeeringAttachmentRequest` contents to a `SignedRequest`.
struct DeleteTransitGatewayPeeringAttachmentRequestSerializer;
impl DeleteTransitGatewayPeeringAttachmentRequestSerializer {
    fn serialize(
        params: &mut Params,
        name: &str,
        obj: &DeleteTransitGatewayPeeringAttachmentRequest,
    ) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "TransitGatewayAttachmentId"),
            &obj.transit_gateway_attachment_id,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeleteTransitGatewayPeeringAttachmentResult {
    /// <p>The transit gateway peering attachment.</p>
    pub transit_gateway_peering_attachment: Option<TransitGatewayPeeringAttachment>,
}

#[allow(dead_code)]
struct DeleteTransitGatewayPeeringAttachmentResultDeserializer;
impl DeleteTransitGatewayPeeringAttachmentResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeleteTransitGatewayPeeringAttachmentResult, XmlParseError> {
        deserialize_elements::<_, DeleteTransitGatewayPeeringAttachmentResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "transitGatewayPeeringAttachment" => {
                        obj.transit_gateway_peering_attachment =
                            Some(TransitGatewayPeeringAttachmentDeserializer::deserialize(
                                "transitGatewayPeeringAttachment",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteTransitGatewayPrefixListReferenceRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the prefix list.</p>
    pub prefix_list_id: String,
    /// <p>The ID of the route table.</p>
    pub transit_gateway_route_table_id: String,
}

/// Serialize `DeleteTransitGatewayPrefixListReferenceRequest` contents to a `SignedRequest`.
struct DeleteTransitGatewayPrefixListReferenceRequestSerializer;
impl DeleteTransitGatewayPrefixListReferenceRequestSerializer {
    fn serialize(
        params: &mut Params,
        name: &str,
        obj: &DeleteTransitGatewayPrefixListReferenceRequest,
    ) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "PrefixListId"),
            &obj.prefix_list_id,
        );
        params.put(
            &format!("{}{}", prefix, "TransitGatewayRouteTableId"),
            &obj.transit_gateway_route_table_id,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeleteTransitGatewayPrefixListReferenceResult {
    /// <p>Information about the deleted prefix list reference.</p>
    pub transit_gateway_prefix_list_reference: Option<TransitGatewayPrefixListReference>,
}

#[allow(dead_code)]
struct DeleteTransitGatewayPrefixListReferenceResultDeserializer;
impl DeleteTransitGatewayPrefixListReferenceResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeleteTransitGatewayPrefixListReferenceResult, XmlParseError> {
        deserialize_elements::<_, DeleteTransitGatewayPrefixListReferenceResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "transitGatewayPrefixListReference" => {
                        obj.transit_gateway_prefix_list_reference =
                            Some(TransitGatewayPrefixListReferenceDeserializer::deserialize(
                                "transitGatewayPrefixListReference",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteTransitGatewayRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the transit gateway.</p>
    pub transit_gateway_id: String,
}

/// Serialize `DeleteTransitGatewayRequest` contents to a `SignedRequest`.
struct DeleteTransitGatewayRequestSerializer;
impl DeleteTransitGatewayRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteTransitGatewayRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "TransitGatewayId"),
            &obj.transit_gateway_id,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeleteTransitGatewayResult {
    /// <p>Information about the deleted transit gateway.</p>
    pub transit_gateway: Option<TransitGateway>,
}

#[allow(dead_code)]
struct DeleteTransitGatewayResultDeserializer;
impl DeleteTransitGatewayResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeleteTransitGatewayResult, XmlParseError> {
        deserialize_elements::<_, DeleteTransitGatewayResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "transitGateway" => {
                        obj.transit_gateway = Some(TransitGatewayDeserializer::deserialize(
                            "transitGateway",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteTransitGatewayRouteRequest {
    /// <p>The CIDR range for the route. This must match the CIDR for the route exactly.</p>
    pub destination_cidr_block: String,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the transit gateway route table.</p>
    pub transit_gateway_route_table_id: String,
}

/// Serialize `DeleteTransitGatewayRouteRequest` contents to a `SignedRequest`.
struct DeleteTransitGatewayRouteRequestSerializer;
impl DeleteTransitGatewayRouteRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteTransitGatewayRouteRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "DestinationCidrBlock"),
            &obj.destination_cidr_block,
        );
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "TransitGatewayRouteTableId"),
            &obj.transit_gateway_route_table_id,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeleteTransitGatewayRouteResult {
    /// <p>Information about the route.</p>
    pub route: Option<TransitGatewayRoute>,
}

#[allow(dead_code)]
struct DeleteTransitGatewayRouteResultDeserializer;
impl DeleteTransitGatewayRouteResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeleteTransitGatewayRouteResult, XmlParseError> {
        deserialize_elements::<_, DeleteTransitGatewayRouteResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "route" => {
                        obj.route = Some(TransitGatewayRouteDeserializer::deserialize(
                            "route", stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteTransitGatewayRouteTableRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the transit gateway route table.</p>
    pub transit_gateway_route_table_id: String,
}

/// Serialize `DeleteTransitGatewayRouteTableRequest` contents to a `SignedRequest`.
struct DeleteTransitGatewayRouteTableRequestSerializer;
impl DeleteTransitGatewayRouteTableRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteTransitGatewayRouteTableRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "TransitGatewayRouteTableId"),
            &obj.transit_gateway_route_table_id,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeleteTransitGatewayRouteTableResult {
    /// <p>Information about the deleted transit gateway route table.</p>
    pub transit_gateway_route_table: Option<TransitGatewayRouteTable>,
}

#[allow(dead_code)]
struct DeleteTransitGatewayRouteTableResultDeserializer;
impl DeleteTransitGatewayRouteTableResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeleteTransitGatewayRouteTableResult, XmlParseError> {
        deserialize_elements::<_, DeleteTransitGatewayRouteTableResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "transitGatewayRouteTable" => {
                        obj.transit_gateway_route_table =
                            Some(TransitGatewayRouteTableDeserializer::deserialize(
                                "transitGatewayRouteTable",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteTransitGatewayVpcAttachmentRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the attachment.</p>
    pub transit_gateway_attachment_id: String,
}

/// Serialize `DeleteTransitGatewayVpcAttachmentRequest` contents to a `SignedRequest`.
struct DeleteTransitGatewayVpcAttachmentRequestSerializer;
impl DeleteTransitGatewayVpcAttachmentRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteTransitGatewayVpcAttachmentRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "TransitGatewayAttachmentId"),
            &obj.transit_gateway_attachment_id,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeleteTransitGatewayVpcAttachmentResult {
    /// <p>Information about the deleted VPC attachment.</p>
    pub transit_gateway_vpc_attachment: Option<TransitGatewayVpcAttachment>,
}

#[allow(dead_code)]
struct DeleteTransitGatewayVpcAttachmentResultDeserializer;
impl DeleteTransitGatewayVpcAttachmentResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeleteTransitGatewayVpcAttachmentResult, XmlParseError> {
        deserialize_elements::<_, DeleteTransitGatewayVpcAttachmentResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "transitGatewayVpcAttachment" => {
                        obj.transit_gateway_vpc_attachment =
                            Some(TransitGatewayVpcAttachmentDeserializer::deserialize(
                                "transitGatewayVpcAttachment",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteVolumeRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the volume.</p>
    pub volume_id: String,
}

/// Serialize `DeleteVolumeRequest` contents to a `SignedRequest`.
struct DeleteVolumeRequestSerializer;
impl DeleteVolumeRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteVolumeRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "VolumeId"), &obj.volume_id);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteVpcEndpointConnectionNotificationsRequest {
    /// <p>One or more notification IDs.</p>
    pub connection_notification_ids: Vec<String>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
}

/// Serialize `DeleteVpcEndpointConnectionNotificationsRequest` contents to a `SignedRequest`.
struct DeleteVpcEndpointConnectionNotificationsRequestSerializer;
impl DeleteVpcEndpointConnectionNotificationsRequestSerializer {
    fn serialize(
        params: &mut Params,
        name: &str,
        obj: &DeleteVpcEndpointConnectionNotificationsRequest,
    ) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        ConnectionNotificationIdsListSerializer::serialize(
            params,
            &format!("{}{}", prefix, "ConnectionNotificationId"),
            &obj.connection_notification_ids,
        );
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeleteVpcEndpointConnectionNotificationsResult {
    /// <p>Information about the notifications that could not be deleted successfully.</p>
    pub unsuccessful: Option<Vec<UnsuccessfulItem>>,
}

#[allow(dead_code)]
struct DeleteVpcEndpointConnectionNotificationsResultDeserializer;
impl DeleteVpcEndpointConnectionNotificationsResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeleteVpcEndpointConnectionNotificationsResult, XmlParseError> {
        deserialize_elements::<_, DeleteVpcEndpointConnectionNotificationsResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "unsuccessful" => {
                        obj.unsuccessful.get_or_insert(vec![]).extend(
                            UnsuccessfulItemSetDeserializer::deserialize("unsuccessful", stack)?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteVpcEndpointServiceConfigurationsRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The IDs of one or more services.</p>
    pub service_ids: Vec<String>,
}

/// Serialize `DeleteVpcEndpointServiceConfigurationsRequest` contents to a `SignedRequest`.
struct DeleteVpcEndpointServiceConfigurationsRequestSerializer;
impl DeleteVpcEndpointServiceConfigurationsRequestSerializer {
    fn serialize(
        params: &mut Params,
        name: &str,
        obj: &DeleteVpcEndpointServiceConfigurationsRequest,
    ) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        VpcEndpointServiceIdListSerializer::serialize(
            params,
            &format!("{}{}", prefix, "ServiceId"),
            &obj.service_ids,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeleteVpcEndpointServiceConfigurationsResult {
    /// <p>Information about the service configurations that were not deleted, if applicable.</p>
    pub unsuccessful: Option<Vec<UnsuccessfulItem>>,
}

#[allow(dead_code)]
struct DeleteVpcEndpointServiceConfigurationsResultDeserializer;
impl DeleteVpcEndpointServiceConfigurationsResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeleteVpcEndpointServiceConfigurationsResult, XmlParseError> {
        deserialize_elements::<_, DeleteVpcEndpointServiceConfigurationsResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "unsuccessful" => {
                        obj.unsuccessful.get_or_insert(vec![]).extend(
                            UnsuccessfulItemSetDeserializer::deserialize("unsuccessful", stack)?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Contains the parameters for DeleteVpcEndpoints.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteVpcEndpointsRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>One or more VPC endpoint IDs.</p>
    pub vpc_endpoint_ids: Vec<String>,
}

/// Serialize `DeleteVpcEndpointsRequest` contents to a `SignedRequest`.
struct DeleteVpcEndpointsRequestSerializer;
impl DeleteVpcEndpointsRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteVpcEndpointsRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        VpcEndpointIdListSerializer::serialize(
            params,
            &format!("{}{}", prefix, "VpcEndpointId"),
            &obj.vpc_endpoint_ids,
        );
    }
}

/// <p>Contains the output of DeleteVpcEndpoints.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeleteVpcEndpointsResult {
    /// <p>Information about the VPC endpoints that were not successfully deleted.</p>
    pub unsuccessful: Option<Vec<UnsuccessfulItem>>,
}

#[allow(dead_code)]
struct DeleteVpcEndpointsResultDeserializer;
impl DeleteVpcEndpointsResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeleteVpcEndpointsResult, XmlParseError> {
        deserialize_elements::<_, DeleteVpcEndpointsResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "unsuccessful" => {
                        obj.unsuccessful.get_or_insert(vec![]).extend(
                            UnsuccessfulItemSetDeserializer::deserialize("unsuccessful", stack)?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteVpcPeeringConnectionRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the VPC peering connection.</p>
    pub vpc_peering_connection_id: String,
}

/// Serialize `DeleteVpcPeeringConnectionRequest` contents to a `SignedRequest`.
struct DeleteVpcPeeringConnectionRequestSerializer;
impl DeleteVpcPeeringConnectionRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteVpcPeeringConnectionRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "VpcPeeringConnectionId"),
            &obj.vpc_peering_connection_id,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeleteVpcPeeringConnectionResult {
    /// <p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>
    pub return_: Option<bool>,
}

#[allow(dead_code)]
struct DeleteVpcPeeringConnectionResultDeserializer;
impl DeleteVpcPeeringConnectionResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeleteVpcPeeringConnectionResult, XmlParseError> {
        deserialize_elements::<_, DeleteVpcPeeringConnectionResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "return" => {
                        obj.return_ = Some(BooleanDeserializer::deserialize("return", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteVpcRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the VPC.</p>
    pub vpc_id: String,
}

/// Serialize `DeleteVpcRequest` contents to a `SignedRequest`.
struct DeleteVpcRequestSerializer;
impl DeleteVpcRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteVpcRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "VpcId"), &obj.vpc_id);
    }
}

/// <p>Contains the parameters for DeleteVpnConnection.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteVpnConnectionRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the VPN connection.</p>
    pub vpn_connection_id: String,
}

/// Serialize `DeleteVpnConnectionRequest` contents to a `SignedRequest`.
struct DeleteVpnConnectionRequestSerializer;
impl DeleteVpnConnectionRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteVpnConnectionRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "VpnConnectionId"),
            &obj.vpn_connection_id,
        );
    }
}

/// <p>Contains the parameters for DeleteVpnConnectionRoute.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteVpnConnectionRouteRequest {
    /// <p>The CIDR block associated with the local subnet of the customer network.</p>
    pub destination_cidr_block: String,
    /// <p>The ID of the VPN connection.</p>
    pub vpn_connection_id: String,
}

/// Serialize `DeleteVpnConnectionRouteRequest` contents to a `SignedRequest`.
struct DeleteVpnConnectionRouteRequestSerializer;
impl DeleteVpnConnectionRouteRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteVpnConnectionRouteRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "DestinationCidrBlock"),
            &obj.destination_cidr_block,
        );
        params.put(
            &format!("{}{}", prefix, "VpnConnectionId"),
            &obj.vpn_connection_id,
        );
    }
}

/// <p>Contains the parameters for DeleteVpnGateway.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteVpnGatewayRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the virtual private gateway.</p>
    pub vpn_gateway_id: String,
}

/// Serialize `DeleteVpnGatewayRequest` contents to a `SignedRequest`.
struct DeleteVpnGatewayRequestSerializer;
impl DeleteVpnGatewayRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteVpnGatewayRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "VpnGatewayId"),
            &obj.vpn_gateway_id,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeprovisionByoipCidrRequest {
    /// <p>The address range, in CIDR notation. The prefix must be the same prefix that you specified when you provisioned the address range.</p>
    pub cidr: String,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
}

/// Serialize `DeprovisionByoipCidrRequest` contents to a `SignedRequest`.
struct DeprovisionByoipCidrRequestSerializer;
impl DeprovisionByoipCidrRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeprovisionByoipCidrRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "Cidr"), &obj.cidr);
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeprovisionByoipCidrResult {
    /// <p>Information about the address range.</p>
    pub byoip_cidr: Option<ByoipCidr>,
}

#[allow(dead_code)]
struct DeprovisionByoipCidrResultDeserializer;
impl DeprovisionByoipCidrResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeprovisionByoipCidrResult, XmlParseError> {
        deserialize_elements::<_, DeprovisionByoipCidrResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "byoipCidr" => {
                        obj.byoip_cidr =
                            Some(ByoipCidrDeserializer::deserialize("byoipCidr", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Contains the parameters for DeregisterImage.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeregisterImageRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the AMI.</p>
    pub image_id: String,
}

/// Serialize `DeregisterImageRequest` contents to a `SignedRequest`.
struct DeregisterImageRequestSerializer;
impl DeregisterImageRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeregisterImageRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "ImageId"), &obj.image_id);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeregisterInstanceEventNotificationAttributesRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>Information about the tag keys to deregister.</p>
    pub instance_tag_attribute: Option<DeregisterInstanceTagAttributeRequest>,
}

/// Serialize `DeregisterInstanceEventNotificationAttributesRequest` contents to a `SignedRequest`.
struct DeregisterInstanceEventNotificationAttributesRequestSerializer;
impl DeregisterInstanceEventNotificationAttributesRequestSerializer {
    fn serialize(
        params: &mut Params,
        name: &str,
        obj: &DeregisterInstanceEventNotificationAttributesRequest,
    ) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.instance_tag_attribute {
            DeregisterInstanceTagAttributeRequestSerializer::serialize(
                params,
                &format!("{}{}", prefix, "InstanceTagAttribute"),
                field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeregisterInstanceEventNotificationAttributesResult {
    /// <p>The resulting set of tag keys.</p>
    pub instance_tag_attribute: Option<InstanceTagNotificationAttribute>,
}

#[allow(dead_code)]
struct DeregisterInstanceEventNotificationAttributesResultDeserializer;
impl DeregisterInstanceEventNotificationAttributesResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeregisterInstanceEventNotificationAttributesResult, XmlParseError> {
        deserialize_elements::<_, DeregisterInstanceEventNotificationAttributesResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "instanceTagAttribute" => {
                        obj.instance_tag_attribute =
                            Some(InstanceTagNotificationAttributeDeserializer::deserialize(
                                "instanceTagAttribute",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Information about the tag keys to deregister for the current Region. You can either specify individual tag keys or deregister all tag keys in the current Region. You must specify either <code>IncludeAllTagsOfInstance</code> or <code>InstanceTagKeys</code> in the request</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeregisterInstanceTagAttributeRequest {
    /// <p>Indicates whether to deregister all tag keys in the current Region. Specify <code>false</code> to deregister all tag keys.</p>
    pub include_all_tags_of_instance: Option<bool>,
    /// <p>Information about the tag keys to deregister.</p>
    pub instance_tag_keys: Option<Vec<String>>,
}

/// Serialize `DeregisterInstanceTagAttributeRequest` contents to a `SignedRequest`.
struct DeregisterInstanceTagAttributeRequestSerializer;
impl DeregisterInstanceTagAttributeRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeregisterInstanceTagAttributeRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.include_all_tags_of_instance {
            params.put(
                &format!("{}{}", prefix, "IncludeAllTagsOfInstance"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.instance_tag_keys {
            InstanceTagKeySetSerializer::serialize(
                params,
                &format!("{}{}", prefix, "InstanceTagKey"),
                field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeregisterTransitGatewayMulticastGroupMembersRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The IP address assigned to the transit gateway multicast group.</p>
    pub group_ip_address: Option<String>,
    /// <p>The IDs of the group members' network interfaces.</p>
    pub network_interface_ids: Option<Vec<String>>,
    /// <p>The ID of the transit gateway multicast domain.</p>
    pub transit_gateway_multicast_domain_id: Option<String>,
}

/// Serialize `DeregisterTransitGatewayMulticastGroupMembersRequest` contents to a `SignedRequest`.
struct DeregisterTransitGatewayMulticastGroupMembersRequestSerializer;
impl DeregisterTransitGatewayMulticastGroupMembersRequestSerializer {
    fn serialize(
        params: &mut Params,
        name: &str,
        obj: &DeregisterTransitGatewayMulticastGroupMembersRequest,
    ) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.group_ip_address {
            params.put(&format!("{}{}", prefix, "GroupIpAddress"), &field_value);
        }
        if let Some(ref field_value) = obj.network_interface_ids {
            TransitGatewayNetworkInterfaceIdListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "NetworkInterfaceIds"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.transit_gateway_multicast_domain_id {
            params.put(
                &format!("{}{}", prefix, "TransitGatewayMulticastDomainId"),
                &field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeregisterTransitGatewayMulticastGroupMembersResult {
    /// <p>Information about the deregistered members.</p>
    pub deregistered_multicast_group_members:
        Option<TransitGatewayMulticastDeregisteredGroupMembers>,
}

#[allow(dead_code)]
struct DeregisterTransitGatewayMulticastGroupMembersResultDeserializer;
impl DeregisterTransitGatewayMulticastGroupMembersResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeregisterTransitGatewayMulticastGroupMembersResult, XmlParseError> {
        deserialize_elements::<_, DeregisterTransitGatewayMulticastGroupMembersResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "deregisteredMulticastGroupMembers" => {
                        obj.deregistered_multicast_group_members = Some(TransitGatewayMulticastDeregisteredGroupMembersDeserializer::deserialize("deregisteredMulticastGroupMembers", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeregisterTransitGatewayMulticastGroupSourcesRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The IP address assigned to the transit gateway multicast group.</p>
    pub group_ip_address: Option<String>,
    /// <p>The IDs of the group sources' network interfaces.</p>
    pub network_interface_ids: Option<Vec<String>>,
    /// <p>The ID of the transit gateway multicast domain.</p>
    pub transit_gateway_multicast_domain_id: Option<String>,
}

/// Serialize `DeregisterTransitGatewayMulticastGroupSourcesRequest` contents to a `SignedRequest`.
struct DeregisterTransitGatewayMulticastGroupSourcesRequestSerializer;
impl DeregisterTransitGatewayMulticastGroupSourcesRequestSerializer {
    fn serialize(
        params: &mut Params,
        name: &str,
        obj: &DeregisterTransitGatewayMulticastGroupSourcesRequest,
    ) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.group_ip_address {
            params.put(&format!("{}{}", prefix, "GroupIpAddress"), &field_value);
        }
        if let Some(ref field_value) = obj.network_interface_ids {
            TransitGatewayNetworkInterfaceIdListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "NetworkInterfaceIds"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.transit_gateway_multicast_domain_id {
            params.put(
                &format!("{}{}", prefix, "TransitGatewayMulticastDomainId"),
                &field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeregisterTransitGatewayMulticastGroupSourcesResult {
    /// <p>Information about the deregistered group sources.</p>
    pub deregistered_multicast_group_sources:
        Option<TransitGatewayMulticastDeregisteredGroupSources>,
}

#[allow(dead_code)]
struct DeregisterTransitGatewayMulticastGroupSourcesResultDeserializer;
impl DeregisterTransitGatewayMulticastGroupSourcesResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeregisterTransitGatewayMulticastGroupSourcesResult, XmlParseError> {
        deserialize_elements::<_, DeregisterTransitGatewayMulticastGroupSourcesResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "deregisteredMulticastGroupSources" => {
                        obj.deregistered_multicast_group_sources = Some(TransitGatewayMulticastDeregisteredGroupSourcesDeserializer::deserialize("deregisteredMulticastGroupSources", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeAccountAttributesRequest {
    /// <p>The account attribute names.</p>
    pub attribute_names: Option<Vec<String>>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
}

/// Serialize `DescribeAccountAttributesRequest` contents to a `SignedRequest`.
struct DescribeAccountAttributesRequestSerializer;
impl DescribeAccountAttributesRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeAccountAttributesRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.attribute_names {
            AccountAttributeNameStringListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "AttributeName"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeAccountAttributesResult {
    /// <p>Information about the account attributes.</p>
    pub account_attributes: Option<Vec<AccountAttribute>>,
}

#[allow(dead_code)]
struct DescribeAccountAttributesResultDeserializer;
impl DescribeAccountAttributesResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeAccountAttributesResult, XmlParseError> {
        deserialize_elements::<_, DescribeAccountAttributesResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "accountAttributeSet" => {
                        obj.account_attributes.get_or_insert(vec![]).extend(
                            AccountAttributeListDeserializer::deserialize(
                                "accountAttributeSet",
                                stack,
                            )?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeAddressesAttributeRequest {
    /// <p>[EC2-VPC] The allocation IDs.</p>
    pub allocation_ids: Option<Vec<String>>,
    /// <p>The attribute of the IP address.</p>
    pub attribute: Option<String>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    pub max_results: Option<i64>,
    /// <p>The token for the next page of results.</p>
    pub next_token: Option<String>,
}

/// Serialize `DescribeAddressesAttributeRequest` contents to a `SignedRequest`.
struct DescribeAddressesAttributeRequestSerializer;
impl DescribeAddressesAttributeRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeAddressesAttributeRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.allocation_ids {
            AllocationIdsSerializer::serialize(
                params,
                &format!("{}{}", prefix, "AllocationId"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.attribute {
            params.put(&format!("{}{}", prefix, "Attribute"), &field_value);
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.max_results {
            params.put(&format!("{}{}", prefix, "MaxResults"), &field_value);
        }
        if let Some(ref field_value) = obj.next_token {
            params.put(&format!("{}{}", prefix, "NextToken"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeAddressesAttributeResult {
    /// <p>Information about the IP addresses.</p>
    pub addresses: Option<Vec<AddressAttribute>>,
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: Option<String>,
}

#[allow(dead_code)]
struct DescribeAddressesAttributeResultDeserializer;
impl DescribeAddressesAttributeResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeAddressesAttributeResult, XmlParseError> {
        deserialize_elements::<_, DescribeAddressesAttributeResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "addressSet" => {
                        obj.addresses
                            .get_or_insert(vec![])
                            .extend(AddressSetDeserializer::deserialize("addressSet", stack)?);
                    }
                    "nextToken" => {
                        obj.next_token =
                            Some(NextTokenDeserializer::deserialize("nextToken", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeAddressesRequest {
    /// <p>[EC2-VPC] Information about the allocation IDs.</p>
    pub allocation_ids: Option<Vec<String>>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p><p>One or more filters. Filter names and values are case-sensitive.</p> <ul> <li> <p> <code>allocation-id</code> - [EC2-VPC] The allocation ID for the address.</p> </li> <li> <p> <code>association-id</code> - [EC2-VPC] The association ID for the address.</p> </li> <li> <p> <code>domain</code> - Indicates whether the address is for use in EC2-Classic (<code>standard</code>) or in a VPC (<code>vpc</code>).</p> </li> <li> <p> <code>instance-id</code> - The ID of the instance the address is associated with, if any.</p> </li> <li> <p> <code>network-border-group</code> - A unique set of Availability Zones, Local Zones, or Wavelength Zones from where Amazon Web Services advertises IP addresses. </p> </li> <li> <p> <code>network-interface-id</code> - [EC2-VPC] The ID of the network interface that the address is associated with, if any.</p> </li> <li> <p> <code>network-interface-owner-id</code> - The account ID of the owner.</p> </li> <li> <p> <code>private-ip-address</code> - [EC2-VPC] The private IP address associated with the Elastic IP address.</p> </li> <li> <p> <code>public-ip</code> - The Elastic IP address, or the carrier IP address.</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> </ul></p>
    pub filters: Option<Vec<Filter>>,
    /// <p>One or more Elastic IP addresses.</p> <p>Default: Describes all your Elastic IP addresses.</p>
    pub public_ips: Option<Vec<String>>,
}

/// Serialize `DescribeAddressesRequest` contents to a `SignedRequest`.
struct DescribeAddressesRequestSerializer;
impl DescribeAddressesRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeAddressesRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.allocation_ids {
            AllocationIdListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "AllocationId"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.public_ips {
            PublicIpStringListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "PublicIp"),
                field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeAddressesResult {
    /// <p>Information about the Elastic IP addresses.</p>
    pub addresses: Option<Vec<Address>>,
}

#[allow(dead_code)]
struct DescribeAddressesResultDeserializer;
impl DescribeAddressesResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeAddressesResult, XmlParseError> {
        deserialize_elements::<_, DescribeAddressesResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "addressesSet" => {
                        obj.addresses
                            .get_or_insert(vec![])
                            .extend(AddressListDeserializer::deserialize("addressesSet", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeAggregateIdFormatRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
}

/// Serialize `DescribeAggregateIdFormatRequest` contents to a `SignedRequest`.
struct DescribeAggregateIdFormatRequestSerializer;
impl DescribeAggregateIdFormatRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeAggregateIdFormatRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeAggregateIdFormatResult {
    /// <p>Information about each resource's ID format.</p>
    pub statuses: Option<Vec<IdFormat>>,
    /// <p>Indicates whether all resource types in the Region are configured to use longer IDs. This value is only <code>true</code> if all users are configured to use longer IDs for all resources types in the Region.</p>
    pub use_long_ids_aggregated: Option<bool>,
}

#[allow(dead_code)]
struct DescribeAggregateIdFormatResultDeserializer;
impl DescribeAggregateIdFormatResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeAggregateIdFormatResult, XmlParseError> {
        deserialize_elements::<_, DescribeAggregateIdFormatResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "statusSet" => {
                        obj.statuses
                            .get_or_insert(vec![])
                            .extend(IdFormatListDeserializer::deserialize("statusSet", stack)?);
                    }
                    "useLongIdsAggregated" => {
                        obj.use_long_ids_aggregated = Some(BooleanDeserializer::deserialize(
                            "useLongIdsAggregated",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeAvailabilityZonesRequest {
    /// <p>Include all Availability Zones, Local Zones, and Wavelength Zones regardless of your opt-in status.</p> <p>If you do not use this parameter, the results include only the zones for the Regions where you have chosen the option to opt in.</p>
    pub all_availability_zones: Option<bool>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p><p>The filters.</p> <ul> <li> <p> <code>group-name</code> - For Availability Zones, use the Region name. For Local Zones, use the name of the group associated with the Local Zone (for example, <code>us-west-2-lax-1</code>) For Wavelength Zones, use the name of the group associated with the Wavelength Zone (for example, <code>us-east-1-wl1-bos-wlz-1</code>).</p> </li> <li> <p> <code>message</code> - The Zone message.</p> </li> <li> <p> <code>opt-in-status</code> - The opt-in status (<code>opted-in</code>, and <code>not-opted-in</code> | <code>opt-in-not-required</code>).</p> </li> <li> <p> <code>parent-zoneID</code> - The ID of the zone that handles some of the Local Zone and Wavelength Zone control plane operations, such as API calls.</p> </li> <li> <p> <code>parent-zoneName</code> - The ID of the zone that handles some of the Local Zone and Wavelength Zone control plane operations, such as API calls.</p> </li> <li> <p> <code>region-name</code> - The name of the Region for the Zone (for example, <code>us-east-1</code>).</p> </li> <li> <p> <code>state</code> - The state of the Availability Zone, the Local Zone, or the Wavelength Zone (<code>available</code> | <code>information</code> | <code>impaired</code> | <code>unavailable</code>).</p> </li> <li> <p> <code>zone-id</code> - The ID of the Availability Zone (for example, <code>use1-az1</code>), the Local Zone (for example, <code>usw2-lax1-az1</code>), or the Wavelength Zone (for example, <code>us-east-1-wl1-bos-wlz-1</code>).</p> </li> <li> <p> <code>zone-type</code> - The type of zone, for example, <code>local-zone</code>.</p> </li> <li> <p> <code>zone-name</code> - The name of the Availability Zone (for example, <code>us-east-1a</code>), the Local Zone (for example, <code>us-west-2-lax-1a</code>), or the Wavelength Zone (for example, <code>us-east-1-wl1-bos-wlz-1</code>).</p> </li> <li> <p> <code>zone-type</code> - The type of zone, for example, <code>local-zone</code>.</p> </li> </ul></p>
    pub filters: Option<Vec<Filter>>,
    /// <p>The IDs of the Availability Zones, Local Zones, and Wavelength Zones.</p>
    pub zone_ids: Option<Vec<String>>,
    /// <p>The names of the Availability Zones, Local Zones, and Wavelength Zones.</p>
    pub zone_names: Option<Vec<String>>,
}

/// Serialize `DescribeAvailabilityZonesRequest` contents to a `SignedRequest`.
struct DescribeAvailabilityZonesRequestSerializer;
impl DescribeAvailabilityZonesRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeAvailabilityZonesRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.all_availability_zones {
            params.put(
                &format!("{}{}", prefix, "AllAvailabilityZones"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.zone_ids {
            ZoneIdStringListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "ZoneId"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.zone_names {
            ZoneNameStringListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "ZoneName"),
                field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeAvailabilityZonesResult {
    /// <p>Information about the Availability Zones, Local Zones, and Wavelength Zones.</p>
    pub availability_zones: Option<Vec<AvailabilityZone>>,
}

#[allow(dead_code)]
struct DescribeAvailabilityZonesResultDeserializer;
impl DescribeAvailabilityZonesResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeAvailabilityZonesResult, XmlParseError> {
        deserialize_elements::<_, DescribeAvailabilityZonesResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "availabilityZoneInfo" => {
                        obj.availability_zones.get_or_insert(vec![]).extend(
                            AvailabilityZoneListDeserializer::deserialize(
                                "availabilityZoneInfo",
                                stack,
                            )?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeBundleTasksRequest {
    /// <p>The bundle task IDs.</p> <p>Default: Describes all your bundle tasks.</p>
    pub bundle_ids: Option<Vec<String>>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p><p>The filters.</p> <ul> <li> <p> <code>bundle-id</code> - The ID of the bundle task.</p> </li> <li> <p> <code>error-code</code> - If the task failed, the error code returned.</p> </li> <li> <p> <code>error-message</code> - If the task failed, the error message returned.</p> </li> <li> <p> <code>instance-id</code> - The ID of the instance.</p> </li> <li> <p> <code>progress</code> - The level of task completion, as a percentage (for example, 20%).</p> </li> <li> <p> <code>s3-bucket</code> - The Amazon S3 bucket to store the AMI.</p> </li> <li> <p> <code>s3-prefix</code> - The beginning of the AMI name.</p> </li> <li> <p> <code>start-time</code> - The time the task started (for example, 2013-09-15T17:15:20.000Z).</p> </li> <li> <p> <code>state</code> - The state of the task (<code>pending</code> | <code>waiting-for-shutdown</code> | <code>bundling</code> | <code>storing</code> | <code>cancelling</code> | <code>complete</code> | <code>failed</code>).</p> </li> <li> <p> <code>update-time</code> - The time of the most recent update for the task.</p> </li> </ul></p>
    pub filters: Option<Vec<Filter>>,
}

/// Serialize `DescribeBundleTasksRequest` contents to a `SignedRequest`.
struct DescribeBundleTasksRequestSerializer;
impl DescribeBundleTasksRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeBundleTasksRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.bundle_ids {
            BundleIdStringListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "BundleId"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeBundleTasksResult {
    /// <p>Information about the bundle tasks.</p>
    pub bundle_tasks: Option<Vec<BundleTask>>,
}

#[allow(dead_code)]
struct DescribeBundleTasksResultDeserializer;
impl DescribeBundleTasksResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeBundleTasksResult, XmlParseError> {
        deserialize_elements::<_, DescribeBundleTasksResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "bundleInstanceTasksSet" => {
                        obj.bundle_tasks.get_or_insert(vec![]).extend(
                            BundleTaskListDeserializer::deserialize(
                                "bundleInstanceTasksSet",
                                stack,
                            )?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeByoipCidrsRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    pub max_results: i64,
    /// <p>The token for the next page of results.</p>
    pub next_token: Option<String>,
}

/// Serialize `DescribeByoipCidrsRequest` contents to a `SignedRequest`.
struct DescribeByoipCidrsRequestSerializer;
impl DescribeByoipCidrsRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeByoipCidrsRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "MaxResults"), &obj.max_results);
        if let Some(ref field_value) = obj.next_token {
            params.put(&format!("{}{}", prefix, "NextToken"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeByoipCidrsResult {
    /// <p>Information about your address ranges.</p>
    pub byoip_cidrs: Option<Vec<ByoipCidr>>,
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: Option<String>,
}

#[allow(dead_code)]
struct DescribeByoipCidrsResultDeserializer;
impl DescribeByoipCidrsResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeByoipCidrsResult, XmlParseError> {
        deserialize_elements::<_, DescribeByoipCidrsResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "byoipCidrSet" => {
                        obj.byoip_cidrs.get_or_insert(vec![]).extend(
                            ByoipCidrSetDeserializer::deserialize("byoipCidrSet", stack)?,
                        );
                    }
                    "nextToken" => {
                        obj.next_token = Some(StringDeserializer::deserialize("nextToken", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeCapacityReservationsRequest {
    /// <p>The ID of the Capacity Reservation.</p>
    pub capacity_reservation_ids: Option<Vec<String>>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p><p>One or more filters.</p> <ul> <li> <p> <code>instance-type</code> - The type of instance for which the Capacity Reservation reserves capacity.</p> </li> <li> <p> <code>owner-id</code> - The ID of the AWS account that owns the Capacity Reservation.</p> </li> <li> <p> <code>availability-zone-id</code> - The Availability Zone ID of the Capacity Reservation.</p> </li> <li> <p> <code>instance-platform</code> - The type of operating system for which the Capacity Reservation reserves capacity.</p> </li> <li> <p> <code>availability-zone</code> - The Availability Zone ID of the Capacity Reservation.</p> </li> <li> <p> <code>tenancy</code> - Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following tenancy settings:</p> <ul> <li> <p> <code>default</code> - The Capacity Reservation is created on hardware that is shared with other AWS accounts.</p> </li> <li> <p> <code>dedicated</code> - The Capacity Reservation is created on single-tenant hardware that is dedicated to a single AWS account.</p> </li> </ul> </li> <li> <p> <code>outpost-arn</code> - The Amazon Resource Name (ARN) of the Outpost on which the Capacity Reservation was created.</p> </li> <li> <p> <code>state</code> - The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following states:</p> <ul> <li> <p> <code>active</code>- The Capacity Reservation is active and the capacity is available for your use.</p> </li> <li> <p> <code>expired</code> - The Capacity Reservation expired automatically at the date and time specified in your request. The reserved capacity is no longer available for your use.</p> </li> <li> <p> <code>cancelled</code> - The Capacity Reservation was cancelled. The reserved capacity is no longer available for your use.</p> </li> <li> <p> <code>pending</code> - The Capacity Reservation request was successful but the capacity provisioning is still pending.</p> </li> <li> <p> <code>failed</code> - The Capacity Reservation request has failed. A request might fail due to invalid request parameters, capacity constraints, or instance limit constraints. Failed requests are retained for 60 minutes.</p> </li> </ul> </li> <li> <p> <code>start-date</code> - The date and time at which the Capacity Reservation was started.</p> </li> <li> <p> <code>end-date</code> - The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved capacity is released and you can no longer launch instances into it. The Capacity Reservation&#39;s state changes to expired when it reaches its end date and time.</p> </li> <li> <p> <code>end-date-type</code> - Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following end types:</p> <ul> <li> <p> <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it.</p> </li> <li> <p> <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time.</p> </li> </ul> </li> <li> <p> <code>instance-match-criteria</code> - Indicates the type of instance launches that the Capacity Reservation accepts. The options include:</p> <ul> <li> <p> <code>open</code> - The Capacity Reservation accepts all instances that have matching attributes (instance type, platform, and Availability Zone). Instances that have matching attributes launch into the Capacity Reservation automatically without specifying any additional parameters.</p> </li> <li> <p> <code>targeted</code> - The Capacity Reservation only accepts instances that have matching attributes (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This ensures that only permitted instances can use the reserved capacity.</p> </li> </ul> </li> </ul></p>
    pub filters: Option<Vec<Filter>>,
    /// <p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the returned <code>nextToken</code> value. This value can be between 5 and 500. If <code>maxResults</code> is given a larger value than 500, you receive an error.</p>
    pub max_results: Option<i64>,
    /// <p>The token to use to retrieve the next page of results.</p>
    pub next_token: Option<String>,
}

/// Serialize `DescribeCapacityReservationsRequest` contents to a `SignedRequest`.
struct DescribeCapacityReservationsRequestSerializer;
impl DescribeCapacityReservationsRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeCapacityReservationsRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.capacity_reservation_ids {
            CapacityReservationIdSetSerializer::serialize(
                params,
                &format!("{}{}", prefix, "CapacityReservationId"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.max_results {
            params.put(&format!("{}{}", prefix, "MaxResults"), &field_value);
        }
        if let Some(ref field_value) = obj.next_token {
            params.put(&format!("{}{}", prefix, "NextToken"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeCapacityReservationsResult {
    /// <p>Information about the Capacity Reservations.</p>
    pub capacity_reservations: Option<Vec<CapacityReservation>>,
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: Option<String>,
}

#[allow(dead_code)]
struct DescribeCapacityReservationsResultDeserializer;
impl DescribeCapacityReservationsResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeCapacityReservationsResult, XmlParseError> {
        deserialize_elements::<_, DescribeCapacityReservationsResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "capacityReservationSet" => {
                        obj.capacity_reservations.get_or_insert(vec![]).extend(
                            CapacityReservationSetDeserializer::deserialize(
                                "capacityReservationSet",
                                stack,
                            )?,
                        );
                    }
                    "nextToken" => {
                        obj.next_token = Some(StringDeserializer::deserialize("nextToken", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeCarrierGatewaysRequest {
    /// <p>One or more carrier gateway IDs.</p>
    pub carrier_gateway_ids: Option<Vec<String>>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p><p>One or more filters.</p> <ul> <li> <p> <code>carrier-gateway-id</code> - The ID of the carrier gateway.</p> </li> <li> <p> <code>state</code> - The state of the carrier gateway (<code>pending</code> | <code>failed</code> | <code>available</code> | <code>deleting</code> | <code>deleted</code>).</p> </li> <li> <p> <code>owner-id</code> - The AWS account ID of the owner of the carrier gateway.</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> <li> <p> <code>vpc-id</code> - The ID of the VPC associated with the carrier gateway.</p> </li> </ul></p>
    pub filters: Option<Vec<Filter>>,
    /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    pub max_results: Option<i64>,
    /// <p>The token for the next page of results.</p>
    pub next_token: Option<String>,
}

/// Serialize `DescribeCarrierGatewaysRequest` contents to a `SignedRequest`.
struct DescribeCarrierGatewaysRequestSerializer;
impl DescribeCarrierGatewaysRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeCarrierGatewaysRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.carrier_gateway_ids {
            CarrierGatewayIdSetSerializer::serialize(
                params,
                &format!("{}{}", prefix, "CarrierGatewayId"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.max_results {
            params.put(&format!("{}{}", prefix, "MaxResults"), &field_value);
        }
        if let Some(ref field_value) = obj.next_token {
            params.put(&format!("{}{}", prefix, "NextToken"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeCarrierGatewaysResult {
    /// <p>Information about the carrier gateway.</p>
    pub carrier_gateways: Option<Vec<CarrierGateway>>,
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: Option<String>,
}

#[allow(dead_code)]
struct DescribeCarrierGatewaysResultDeserializer;
impl DescribeCarrierGatewaysResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeCarrierGatewaysResult, XmlParseError> {
        deserialize_elements::<_, DescribeCarrierGatewaysResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "carrierGatewaySet" => {
                        obj.carrier_gateways.get_or_insert(vec![]).extend(
                            CarrierGatewaySetDeserializer::deserialize("carrierGatewaySet", stack)?,
                        );
                    }
                    "nextToken" => {
                        obj.next_token = Some(StringDeserializer::deserialize("nextToken", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeClassicLinkInstancesRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p><p>One or more filters.</p> <ul> <li> <p> <code>group-id</code> - The ID of a VPC security group that&#39;s associated with the instance.</p> </li> <li> <p> <code>instance-id</code> - The ID of the instance.</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> <li> <p> <code>vpc-id</code> - The ID of the VPC to which the instance is linked.</p> <p> <code>vpc-id</code> - The ID of the VPC that the instance is linked to.</p> </li> </ul></p>
    pub filters: Option<Vec<Filter>>,
    /// <p>One or more instance IDs. Must be instances linked to a VPC through ClassicLink.</p>
    pub instance_ids: Option<Vec<String>>,
    /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p> <p>Constraint: If the value is greater than 1000, we return only 1000 items.</p>
    pub max_results: Option<i64>,
    /// <p>The token for the next page of results.</p>
    pub next_token: Option<String>,
}

/// Serialize `DescribeClassicLinkInstancesRequest` contents to a `SignedRequest`.
struct DescribeClassicLinkInstancesRequestSerializer;
impl DescribeClassicLinkInstancesRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeClassicLinkInstancesRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.instance_ids {
            InstanceIdStringListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "InstanceId"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.max_results {
            params.put(&format!("{}{}", prefix, "MaxResults"), &field_value);
        }
        if let Some(ref field_value) = obj.next_token {
            params.put(&format!("{}{}", prefix, "NextToken"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeClassicLinkInstancesResult {
    /// <p>Information about one or more linked EC2-Classic instances.</p>
    pub instances: Option<Vec<ClassicLinkInstance>>,
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: Option<String>,
}

#[allow(dead_code)]
struct DescribeClassicLinkInstancesResultDeserializer;
impl DescribeClassicLinkInstancesResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeClassicLinkInstancesResult, XmlParseError> {
        deserialize_elements::<_, DescribeClassicLinkInstancesResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "instancesSet" => {
                        obj.instances.get_or_insert(vec![]).extend(
                            ClassicLinkInstanceListDeserializer::deserialize(
                                "instancesSet",
                                stack,
                            )?,
                        );
                    }
                    "nextToken" => {
                        obj.next_token = Some(StringDeserializer::deserialize("nextToken", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeClientVpnAuthorizationRulesRequest {
    /// <p>The ID of the Client VPN endpoint.</p>
    pub client_vpn_endpoint_id: String,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p><p>One or more filters. Filter names and values are case-sensitive.</p> <ul> <li> <p> <code>description</code> - The description of the authorization rule.</p> </li> <li> <p> <code>destination-cidr</code> - The CIDR of the network to which the authorization rule applies.</p> </li> <li> <p> <code>group-id</code> - The ID of the Active Directory group to which the authorization rule grants access.</p> </li> </ul></p>
    pub filters: Option<Vec<Filter>>,
    /// <p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the nextToken value.</p>
    pub max_results: Option<i64>,
    /// <p>The token to retrieve the next page of results.</p>
    pub next_token: Option<String>,
}

/// Serialize `DescribeClientVpnAuthorizationRulesRequest` contents to a `SignedRequest`.
struct DescribeClientVpnAuthorizationRulesRequestSerializer;
impl DescribeClientVpnAuthorizationRulesRequestSerializer {
    fn serialize(
        params: &mut Params,
        name: &str,
        obj: &DescribeClientVpnAuthorizationRulesRequest,
    ) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "ClientVpnEndpointId"),
            &obj.client_vpn_endpoint_id,
        );
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.max_results {
            params.put(&format!("{}{}", prefix, "MaxResults"), &field_value);
        }
        if let Some(ref field_value) = obj.next_token {
            params.put(&format!("{}{}", prefix, "NextToken"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeClientVpnAuthorizationRulesResult {
    /// <p>Information about the authorization rules.</p>
    pub authorization_rules: Option<Vec<AuthorizationRule>>,
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: Option<String>,
}

#[allow(dead_code)]
struct DescribeClientVpnAuthorizationRulesResultDeserializer;
impl DescribeClientVpnAuthorizationRulesResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeClientVpnAuthorizationRulesResult, XmlParseError> {
        deserialize_elements::<_, DescribeClientVpnAuthorizationRulesResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "authorizationRule" => {
                        obj.authorization_rules.get_or_insert(vec![]).extend(
                            AuthorizationRuleSetDeserializer::deserialize(
                                "authorizationRule",
                                stack,
                            )?,
                        );
                    }
                    "nextToken" => {
                        obj.next_token =
                            Some(NextTokenDeserializer::deserialize("nextToken", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeClientVpnConnectionsRequest {
    /// <p>The ID of the Client VPN endpoint.</p>
    pub client_vpn_endpoint_id: String,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p><p>One or more filters. Filter names and values are case-sensitive.</p> <ul> <li> <p> <code>connection-id</code> - The ID of the connection.</p> </li> <li> <p> <code>username</code> - For Active Directory client authentication, the user name of the client who established the client connection.</p> </li> </ul></p>
    pub filters: Option<Vec<Filter>>,
    /// <p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the nextToken value.</p>
    pub max_results: Option<i64>,
    /// <p>The token to retrieve the next page of results.</p>
    pub next_token: Option<String>,
}

/// Serialize `DescribeClientVpnConnectionsRequest` contents to a `SignedRequest`.
struct DescribeClientVpnConnectionsRequestSerializer;
impl DescribeClientVpnConnectionsRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeClientVpnConnectionsRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "ClientVpnEndpointId"),
            &obj.client_vpn_endpoint_id,
        );
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.max_results {
            params.put(&format!("{}{}", prefix, "MaxResults"), &field_value);
        }
        if let Some(ref field_value) = obj.next_token {
            params.put(&format!("{}{}", prefix, "NextToken"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeClientVpnConnectionsResult {
    /// <p>Information about the active and terminated client connections.</p>
    pub connections: Option<Vec<ClientVpnConnection>>,
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: Option<String>,
}

#[allow(dead_code)]
struct DescribeClientVpnConnectionsResultDeserializer;
impl DescribeClientVpnConnectionsResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeClientVpnConnectionsResult, XmlParseError> {
        deserialize_elements::<_, DescribeClientVpnConnectionsResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "connections" => {
                        obj.connections.get_or_insert(vec![]).extend(
                            ClientVpnConnectionSetDeserializer::deserialize("connections", stack)?,
                        );
                    }
                    "nextToken" => {
                        obj.next_token =
                            Some(NextTokenDeserializer::deserialize("nextToken", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeClientVpnEndpointsRequest {
    /// <p>The ID of the Client VPN endpoint.</p>
    pub client_vpn_endpoint_ids: Option<Vec<String>>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p><p>One or more filters. Filter names and values are case-sensitive.</p> <ul> <li> <p> <code>endpoint-id</code> - The ID of the Client VPN endpoint.</p> </li> <li> <p> <code>transport-protocol</code> - The transport protocol (<code>tcp</code> | <code>udp</code>).</p> </li> </ul></p>
    pub filters: Option<Vec<Filter>>,
    /// <p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the nextToken value.</p>
    pub max_results: Option<i64>,
    /// <p>The token to retrieve the next page of results.</p>
    pub next_token: Option<String>,
}

/// Serialize `DescribeClientVpnEndpointsRequest` contents to a `SignedRequest`.
struct DescribeClientVpnEndpointsRequestSerializer;
impl DescribeClientVpnEndpointsRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeClientVpnEndpointsRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.client_vpn_endpoint_ids {
            ClientVpnEndpointIdListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "ClientVpnEndpointId"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.max_results {
            params.put(&format!("{}{}", prefix, "MaxResults"), &field_value);
        }
        if let Some(ref field_value) = obj.next_token {
            params.put(&format!("{}{}", prefix, "NextToken"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeClientVpnEndpointsResult {
    /// <p>Information about the Client VPN endpoints.</p>
    pub client_vpn_endpoints: Option<Vec<ClientVpnEndpoint>>,
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: Option<String>,
}

#[allow(dead_code)]
struct DescribeClientVpnEndpointsResultDeserializer;
impl DescribeClientVpnEndpointsResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeClientVpnEndpointsResult, XmlParseError> {
        deserialize_elements::<_, DescribeClientVpnEndpointsResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "clientVpnEndpoint" => {
                        obj.client_vpn_endpoints.get_or_insert(vec![]).extend(
                            EndpointSetDeserializer::deserialize("clientVpnEndpoint", stack)?,
                        );
                    }
                    "nextToken" => {
                        obj.next_token =
                            Some(NextTokenDeserializer::deserialize("nextToken", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeClientVpnRoutesRequest {
    /// <p>The ID of the Client VPN endpoint.</p>
    pub client_vpn_endpoint_id: String,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p><p>One or more filters. Filter names and values are case-sensitive.</p> <ul> <li> <p> <code>destination-cidr</code> - The CIDR of the route destination.</p> </li> <li> <p> <code>origin</code> - How the route was associated with the Client VPN endpoint (<code>associate</code> | <code>add-route</code>).</p> </li> <li> <p> <code>target-subnet</code> - The ID of the subnet through which traffic is routed.</p> </li> </ul></p>
    pub filters: Option<Vec<Filter>>,
    /// <p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the nextToken value.</p>
    pub max_results: Option<i64>,
    /// <p>The token to retrieve the next page of results.</p>
    pub next_token: Option<String>,
}

/// Serialize `DescribeClientVpnRoutesRequest` contents to a `SignedRequest`.
struct DescribeClientVpnRoutesRequestSerializer;
impl DescribeClientVpnRoutesRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeClientVpnRoutesRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "ClientVpnEndpointId"),
            &obj.client_vpn_endpoint_id,
        );
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.max_results {
            params.put(&format!("{}{}", prefix, "MaxResults"), &field_value);
        }
        if let Some(ref field_value) = obj.next_token {
            params.put(&format!("{}{}", prefix, "NextToken"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeClientVpnRoutesResult {
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: Option<String>,
    /// <p>Information about the Client VPN endpoint routes.</p>
    pub routes: Option<Vec<ClientVpnRoute>>,
}

#[allow(dead_code)]
struct DescribeClientVpnRoutesResultDeserializer;
impl DescribeClientVpnRoutesResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeClientVpnRoutesResult, XmlParseError> {
        deserialize_elements::<_, DescribeClientVpnRoutesResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "nextToken" => {
                        obj.next_token =
                            Some(NextTokenDeserializer::deserialize("nextToken", stack)?);
                    }
                    "routes" => {
                        obj.routes
                            .get_or_insert(vec![])
                            .extend(ClientVpnRouteSetDeserializer::deserialize("routes", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeClientVpnTargetNetworksRequest {
    /// <p>The IDs of the target network associations.</p>
    pub association_ids: Option<Vec<String>>,
    /// <p>The ID of the Client VPN endpoint.</p>
    pub client_vpn_endpoint_id: String,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p><p>One or more filters. Filter names and values are case-sensitive.</p> <ul> <li> <p> <code>association-id</code> - The ID of the association.</p> </li> <li> <p> <code>target-network-id</code> - The ID of the subnet specified as the target network.</p> </li> <li> <p> <code>vpc-id</code> - The ID of the VPC in which the target network is located.</p> </li> </ul></p>
    pub filters: Option<Vec<Filter>>,
    /// <p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the nextToken value.</p>
    pub max_results: Option<i64>,
    /// <p>The token to retrieve the next page of results.</p>
    pub next_token: Option<String>,
}

/// Serialize `DescribeClientVpnTargetNetworksRequest` contents to a `SignedRequest`.
struct DescribeClientVpnTargetNetworksRequestSerializer;
impl DescribeClientVpnTargetNetworksRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeClientVpnTargetNetworksRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.association_ids {
            ValueStringListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "AssociationIds"),
                field_value,
            );
        }
        params.put(
            &format!("{}{}", prefix, "ClientVpnEndpointId"),
            &obj.client_vpn_endpoint_id,
        );
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.max_results {
            params.put(&format!("{}{}", prefix, "MaxResults"), &field_value);
        }
        if let Some(ref field_value) = obj.next_token {
            params.put(&format!("{}{}", prefix, "NextToken"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeClientVpnTargetNetworksResult {
    /// <p>Information about the associated target networks.</p>
    pub client_vpn_target_networks: Option<Vec<TargetNetwork>>,
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: Option<String>,
}

#[allow(dead_code)]
struct DescribeClientVpnTargetNetworksResultDeserializer;
impl DescribeClientVpnTargetNetworksResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeClientVpnTargetNetworksResult, XmlParseError> {
        deserialize_elements::<_, DescribeClientVpnTargetNetworksResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "clientVpnTargetNetworks" => {
                        obj.client_vpn_target_networks.get_or_insert(vec![]).extend(
                            TargetNetworkSetDeserializer::deserialize(
                                "clientVpnTargetNetworks",
                                stack,
                            )?,
                        );
                    }
                    "nextToken" => {
                        obj.next_token =
                            Some(NextTokenDeserializer::deserialize("nextToken", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeCoipPoolsRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p><p>The filters. The following are the possible values:</p> <ul> <li> <p> <code>coip-pool.pool-id</code> </p> </li> </ul> <ul> <li> <p> <code>coip-pool.local-gateway-route-table-id</code> </p> </li> </ul></p>
    pub filters: Option<Vec<Filter>>,
    /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    pub max_results: Option<i64>,
    /// <p>The token for the next page of results.</p>
    pub next_token: Option<String>,
    /// <p>The IDs of the address pools.</p>
    pub pool_ids: Option<Vec<String>>,
}

/// Serialize `DescribeCoipPoolsRequest` contents to a `SignedRequest`.
struct DescribeCoipPoolsRequestSerializer;
impl DescribeCoipPoolsRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeCoipPoolsRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.max_results {
            params.put(&format!("{}{}", prefix, "MaxResults"), &field_value);
        }
        if let Some(ref field_value) = obj.next_token {
            params.put(&format!("{}{}", prefix, "NextToken"), &field_value);
        }
        if let Some(ref field_value) = obj.pool_ids {
            CoipPoolIdSetSerializer::serialize(
                params,
                &format!("{}{}", prefix, "PoolId"),
                field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeCoipPoolsResult {
    /// <p>Information about the address pools.</p>
    pub coip_pools: Option<Vec<CoipPool>>,
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: Option<String>,
}

#[allow(dead_code)]
struct DescribeCoipPoolsResultDeserializer;
impl DescribeCoipPoolsResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeCoipPoolsResult, XmlParseError> {
        deserialize_elements::<_, DescribeCoipPoolsResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "coipPoolSet" => {
                        obj.coip_pools
                            .get_or_insert(vec![])
                            .extend(CoipPoolSetDeserializer::deserialize("coipPoolSet", stack)?);
                    }
                    "nextToken" => {
                        obj.next_token = Some(StringDeserializer::deserialize("nextToken", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct DescribeConversionTaskListDeserializer;
impl DescribeConversionTaskListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<ConversionTask>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "item" {
                obj.push(ConversionTaskDeserializer::deserialize("item", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeConversionTasksRequest {
    /// <p>The conversion task IDs.</p>
    pub conversion_task_ids: Option<Vec<String>>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
}

/// Serialize `DescribeConversionTasksRequest` contents to a `SignedRequest`.
struct DescribeConversionTasksRequestSerializer;
impl DescribeConversionTasksRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeConversionTasksRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.conversion_task_ids {
            ConversionIdStringListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "ConversionTaskId"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeConversionTasksResult {
    /// <p>Information about the conversion tasks.</p>
    pub conversion_tasks: Option<Vec<ConversionTask>>,
}

#[allow(dead_code)]
struct DescribeConversionTasksResultDeserializer;
impl DescribeConversionTasksResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeConversionTasksResult, XmlParseError> {
        deserialize_elements::<_, DescribeConversionTasksResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "conversionTasks" => {
                        obj.conversion_tasks.get_or_insert(vec![]).extend(
                            DescribeConversionTaskListDeserializer::deserialize(
                                "conversionTasks",
                                stack,
                            )?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Contains the parameters for DescribeCustomerGateways.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeCustomerGatewaysRequest {
    /// <p>One or more customer gateway IDs.</p> <p>Default: Describes all your customer gateways.</p>
    pub customer_gateway_ids: Option<Vec<String>>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p><p>One or more filters.</p> <ul> <li> <p> <code>bgp-asn</code> - The customer gateway&#39;s Border Gateway Protocol (BGP) Autonomous System Number (ASN).</p> </li> <li> <p> <code>customer-gateway-id</code> - The ID of the customer gateway.</p> </li> <li> <p> <code>ip-address</code> - The IP address of the customer gateway&#39;s Internet-routable external interface.</p> </li> <li> <p> <code>state</code> - The state of the customer gateway (<code>pending</code> | <code>available</code> | <code>deleting</code> | <code>deleted</code>).</p> </li> <li> <p> <code>type</code> - The type of customer gateway. Currently, the only supported type is <code>ipsec.1</code>.</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> </ul></p>
    pub filters: Option<Vec<Filter>>,
}

/// Serialize `DescribeCustomerGatewaysRequest` contents to a `SignedRequest`.
struct DescribeCustomerGatewaysRequestSerializer;
impl DescribeCustomerGatewaysRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeCustomerGatewaysRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.customer_gateway_ids {
            CustomerGatewayIdStringListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "CustomerGatewayId"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
    }
}

/// <p>Contains the output of DescribeCustomerGateways.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeCustomerGatewaysResult {
    /// <p>Information about one or more customer gateways.</p>
    pub customer_gateways: Option<Vec<CustomerGateway>>,
}

#[allow(dead_code)]
struct DescribeCustomerGatewaysResultDeserializer;
impl DescribeCustomerGatewaysResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeCustomerGatewaysResult, XmlParseError> {
        deserialize_elements::<_, DescribeCustomerGatewaysResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "customerGatewaySet" => {
                        obj.customer_gateways.get_or_insert(vec![]).extend(
                            CustomerGatewayListDeserializer::deserialize(
                                "customerGatewaySet",
                                stack,
                            )?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeDhcpOptionsRequest {
    /// <p>The IDs of one or more DHCP options sets.</p> <p>Default: Describes all your DHCP options sets.</p>
    pub dhcp_options_ids: Option<Vec<String>>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p><p>One or more filters.</p> <ul> <li> <p> <code>dhcp-options-id</code> - The ID of a DHCP options set.</p> </li> <li> <p> <code>key</code> - The key for one of the options (for example, <code>domain-name</code>).</p> </li> <li> <p> <code>value</code> - The value for one of the options.</p> </li> <li> <p> <code>owner-id</code> - The ID of the AWS account that owns the DHCP options set.</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> </ul></p>
    pub filters: Option<Vec<Filter>>,
    /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    pub max_results: Option<i64>,
    /// <p>The token for the next page of results.</p>
    pub next_token: Option<String>,
}

/// Serialize `DescribeDhcpOptionsRequest` contents to a `SignedRequest`.
struct DescribeDhcpOptionsRequestSerializer;
impl DescribeDhcpOptionsRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeDhcpOptionsRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dhcp_options_ids {
            DhcpOptionsIdStringListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "DhcpOptionsId"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.max_results {
            params.put(&format!("{}{}", prefix, "MaxResults"), &field_value);
        }
        if let Some(ref field_value) = obj.next_token {
            params.put(&format!("{}{}", prefix, "NextToken"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeDhcpOptionsResult {
    /// <p>Information about one or more DHCP options sets.</p>
    pub dhcp_options: Option<Vec<DhcpOptions>>,
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: Option<String>,
}

#[allow(dead_code)]
struct DescribeDhcpOptionsResultDeserializer;
impl DescribeDhcpOptionsResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeDhcpOptionsResult, XmlParseError> {
        deserialize_elements::<_, DescribeDhcpOptionsResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "dhcpOptionsSet" => {
                        obj.dhcp_options.get_or_insert(vec![]).extend(
                            DhcpOptionsListDeserializer::deserialize("dhcpOptionsSet", stack)?,
                        );
                    }
                    "nextToken" => {
                        obj.next_token = Some(StringDeserializer::deserialize("nextToken", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeEgressOnlyInternetGatewaysRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>One or more egress-only internet gateway IDs.</p>
    pub egress_only_internet_gateway_ids: Option<Vec<String>>,
    /// <p><p>One or more filters.</p> <ul> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> </ul></p>
    pub filters: Option<Vec<Filter>>,
    /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    pub max_results: Option<i64>,
    /// <p>The token for the next page of results.</p>
    pub next_token: Option<String>,
}

/// Serialize `DescribeEgressOnlyInternetGatewaysRequest` contents to a `SignedRequest`.
struct DescribeEgressOnlyInternetGatewaysRequestSerializer;
impl DescribeEgressOnlyInternetGatewaysRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeEgressOnlyInternetGatewaysRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.egress_only_internet_gateway_ids {
            EgressOnlyInternetGatewayIdListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "EgressOnlyInternetGatewayId"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.max_results {
            params.put(&format!("{}{}", prefix, "MaxResults"), &field_value);
        }
        if let Some(ref field_value) = obj.next_token {
            params.put(&format!("{}{}", prefix, "NextToken"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeEgressOnlyInternetGatewaysResult {
    /// <p>Information about the egress-only internet gateways.</p>
    pub egress_only_internet_gateways: Option<Vec<EgressOnlyInternetGateway>>,
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: Option<String>,
}

#[allow(dead_code)]
struct DescribeEgressOnlyInternetGatewaysResultDeserializer;
impl DescribeEgressOnlyInternetGatewaysResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeEgressOnlyInternetGatewaysResult, XmlParseError> {
        deserialize_elements::<_, DescribeEgressOnlyInternetGatewaysResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "egressOnlyInternetGatewaySet" => {
                        obj.egress_only_internet_gateways
                            .get_or_insert(vec![])
                            .extend(EgressOnlyInternetGatewayListDeserializer::deserialize(
                                "egressOnlyInternetGatewaySet",
                                stack,
                            )?);
                    }
                    "nextToken" => {
                        obj.next_token = Some(StringDeserializer::deserialize("nextToken", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeElasticGpusRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The Elastic Graphics accelerator IDs.</p>
    pub elastic_gpu_ids: Option<Vec<String>>,
    /// <p><p>The filters.</p> <ul> <li> <p> <code>availability-zone</code> - The Availability Zone in which the Elastic Graphics accelerator resides.</p> </li> <li> <p> <code>elastic-gpu-health</code> - The status of the Elastic Graphics accelerator (<code>OK</code> | <code>IMPAIRED</code>).</p> </li> <li> <p> <code>elastic-gpu-state</code> - The state of the Elastic Graphics accelerator (<code>ATTACHED</code>).</p> </li> <li> <p> <code>elastic-gpu-type</code> - The type of Elastic Graphics accelerator; for example, <code>eg1.medium</code>.</p> </li> <li> <p> <code>instance-id</code> - The ID of the instance to which the Elastic Graphics accelerator is associated.</p> </li> </ul></p>
    pub filters: Option<Vec<Filter>>,
    /// <p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value. This value can be between 5 and 1000.</p>
    pub max_results: Option<i64>,
    /// <p>The token to request the next page of results.</p>
    pub next_token: Option<String>,
}

/// Serialize `DescribeElasticGpusRequest` contents to a `SignedRequest`.
struct DescribeElasticGpusRequestSerializer;
impl DescribeElasticGpusRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeElasticGpusRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.elastic_gpu_ids {
            ElasticGpuIdSetSerializer::serialize(
                params,
                &format!("{}{}", prefix, "ElasticGpuId"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.max_results {
            params.put(&format!("{}{}", prefix, "MaxResults"), &field_value);
        }
        if let Some(ref field_value) = obj.next_token {
            params.put(&format!("{}{}", prefix, "NextToken"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeElasticGpusResult {
    /// <p>Information about the Elastic Graphics accelerators.</p>
    pub elastic_gpu_set: Option<Vec<ElasticGpus>>,
    /// <p>The total number of items to return. If the total number of items available is more than the value specified in max-items then a Next-Token will be provided in the output that you can use to resume pagination.</p>
    pub max_results: Option<i64>,
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: Option<String>,
}

#[allow(dead_code)]
struct DescribeElasticGpusResultDeserializer;
impl DescribeElasticGpusResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeElasticGpusResult, XmlParseError> {
        deserialize_elements::<_, DescribeElasticGpusResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "elasticGpuSet" => {
                        obj.elastic_gpu_set.get_or_insert(vec![]).extend(
                            ElasticGpuSetDeserializer::deserialize("elasticGpuSet", stack)?,
                        );
                    }
                    "maxResults" => {
                        obj.max_results =
                            Some(IntegerDeserializer::deserialize("maxResults", stack)?);
                    }
                    "nextToken" => {
                        obj.next_token = Some(StringDeserializer::deserialize("nextToken", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeExportImageTasksRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The IDs of the export image tasks.</p>
    pub export_image_task_ids: Option<Vec<String>>,
    /// <p>Filter tasks using the <code>task-state</code> filter and one of the following values: <code>active</code>, <code>completed</code>, <code>deleting</code>, or <code>deleted</code>.</p>
    pub filters: Option<Vec<Filter>>,
    /// <p>The maximum number of results to return in a single call.</p>
    pub max_results: Option<i64>,
    /// <p>A token that indicates the next page of results.</p>
    pub next_token: Option<String>,
}

/// Serialize `DescribeExportImageTasksRequest` contents to a `SignedRequest`.
struct DescribeExportImageTasksRequestSerializer;
impl DescribeExportImageTasksRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeExportImageTasksRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.export_image_task_ids {
            ExportImageTaskIdListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "ExportImageTaskId"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.max_results {
            params.put(&format!("{}{}", prefix, "MaxResults"), &field_value);
        }
        if let Some(ref field_value) = obj.next_token {
            params.put(&format!("{}{}", prefix, "NextToken"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeExportImageTasksResult {
    /// <p>Information about the export image tasks.</p>
    pub export_image_tasks: Option<Vec<ExportImageTask>>,
    /// <p>The token to use to get the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: Option<String>,
}

#[allow(dead_code)]
struct DescribeExportImageTasksResultDeserializer;
impl DescribeExportImageTasksResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeExportImageTasksResult, XmlParseError> {
        deserialize_elements::<_, DescribeExportImageTasksResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "exportImageTaskSet" => {
                        obj.export_image_tasks.get_or_insert(vec![]).extend(
                            ExportImageTaskListDeserializer::deserialize(
                                "exportImageTaskSet",
                                stack,
                            )?,
                        );
                    }
                    "nextToken" => {
                        obj.next_token =
                            Some(NextTokenDeserializer::deserialize("nextToken", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeExportTasksRequest {
    /// <p>The export task IDs.</p>
    pub export_task_ids: Option<Vec<String>>,
    /// <p>the filters for the export tasks.</p>
    pub filters: Option<Vec<Filter>>,
}

/// Serialize `DescribeExportTasksRequest` contents to a `SignedRequest`.
struct DescribeExportTasksRequestSerializer;
impl DescribeExportTasksRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeExportTasksRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.export_task_ids {
            ExportTaskIdStringListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "ExportTaskId"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeExportTasksResult {
    /// <p>Information about the export tasks.</p>
    pub export_tasks: Option<Vec<ExportTask>>,
}

#[allow(dead_code)]
struct DescribeExportTasksResultDeserializer;
impl DescribeExportTasksResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeExportTasksResult, XmlParseError> {
        deserialize_elements::<_, DescribeExportTasksResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "exportTaskSet" => {
                        obj.export_tasks.get_or_insert(vec![]).extend(
                            ExportTaskListDeserializer::deserialize("exportTaskSet", stack)?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Describes fast snapshot restores for a snapshot.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeFastSnapshotRestoreSuccessItem {
    /// <p>The Availability Zone.</p>
    pub availability_zone: Option<String>,
    /// <p>The time at which fast snapshot restores entered the <code>disabled</code> state.</p>
    pub disabled_time: Option<String>,
    /// <p>The time at which fast snapshot restores entered the <code>disabling</code> state.</p>
    pub disabling_time: Option<String>,
    /// <p>The time at which fast snapshot restores entered the <code>enabled</code> state.</p>
    pub enabled_time: Option<String>,
    /// <p>The time at which fast snapshot restores entered the <code>enabling</code> state.</p>
    pub enabling_time: Option<String>,
    /// <p>The time at which fast snapshot restores entered the <code>optimizing</code> state.</p>
    pub optimizing_time: Option<String>,
    /// <p>The AWS owner alias that enabled fast snapshot restores on the snapshot. This is intended for future use.</p>
    pub owner_alias: Option<String>,
    /// <p>The ID of the AWS account that enabled fast snapshot restores on the snapshot.</p>
    pub owner_id: Option<String>,
    /// <p>The ID of the snapshot.</p>
    pub snapshot_id: Option<String>,
    /// <p>The state of fast snapshot restores.</p>
    pub state: Option<String>,
    /// <p><p>The reason for the state transition. The possible values are as follows:</p> <ul> <li> <p> <code>Client.UserInitiated</code> - The state successfully transitioned to <code>enabling</code> or <code>disabling</code>.</p> </li> <li> <p> <code>Client.UserInitiated - Lifecycle state transition</code> - The state successfully transitioned to <code>optimizing</code>, <code>enabled</code>, or <code>disabled</code>.</p> </li> </ul></p>
    pub state_transition_reason: Option<String>,
}

#[allow(dead_code)]
struct DescribeFastSnapshotRestoreSuccessItemDeserializer;
impl DescribeFastSnapshotRestoreSuccessItemDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeFastSnapshotRestoreSuccessItem, XmlParseError> {
        deserialize_elements::<_, DescribeFastSnapshotRestoreSuccessItem, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "availabilityZone" => {
                        obj.availability_zone =
                            Some(StringDeserializer::deserialize("availabilityZone", stack)?);
                    }
                    "disabledTime" => {
                        obj.disabled_time = Some(MillisecondDateTimeDeserializer::deserialize(
                            "disabledTime",
                            stack,
                        )?);
                    }
                    "disablingTime" => {
                        obj.disabling_time = Some(MillisecondDateTimeDeserializer::deserialize(
                            "disablingTime",
                            stack,
                        )?);
                    }
                    "enabledTime" => {
                        obj.enabled_time = Some(MillisecondDateTimeDeserializer::deserialize(
                            "enabledTime",
                            stack,
                        )?);
                    }
                    "enablingTime" => {
                        obj.enabling_time = Some(MillisecondDateTimeDeserializer::deserialize(
                            "enablingTime",
                            stack,
                        )?);
                    }
                    "optimizingTime" => {
                        obj.optimizing_time = Some(MillisecondDateTimeDeserializer::deserialize(
                            "optimizingTime",
                            stack,
                        )?);
                    }
                    "ownerAlias" => {
                        obj.owner_alias =
                            Some(StringDeserializer::deserialize("ownerAlias", stack)?);
                    }
                    "ownerId" => {
                        obj.owner_id = Some(StringDeserializer::deserialize("ownerId", stack)?);
                    }
                    "snapshotId" => {
                        obj.snapshot_id =
                            Some(StringDeserializer::deserialize("snapshotId", stack)?);
                    }
                    "state" => {
                        obj.state = Some(FastSnapshotRestoreStateCodeDeserializer::deserialize(
                            "state", stack,
                        )?);
                    }
                    "stateTransitionReason" => {
                        obj.state_transition_reason = Some(StringDeserializer::deserialize(
                            "stateTransitionReason",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct DescribeFastSnapshotRestoreSuccessSetDeserializer;
impl DescribeFastSnapshotRestoreSuccessSetDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<DescribeFastSnapshotRestoreSuccessItem>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "item" {
                obj.push(
                    DescribeFastSnapshotRestoreSuccessItemDeserializer::deserialize("item", stack)?,
                );
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeFastSnapshotRestoresRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p><p>The filters. The possible values are:</p> <ul> <li> <p> <code>availability-zone</code>: The Availability Zone of the snapshot.</p> </li> <li> <p> <code>owner-id</code>: The ID of the AWS account that enabled fast snapshot restore on the snapshot.</p> </li> <li> <p> <code>snapshot-id</code>: The ID of the snapshot.</p> </li> <li> <p> <code>state</code>: The state of fast snapshot restores for the snapshot (<code>enabling</code> | <code>optimizing</code> | <code>enabled</code> | <code>disabling</code> | <code>disabled</code>).</p> </li> </ul></p>
    pub filters: Option<Vec<Filter>>,
    /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    pub max_results: Option<i64>,
    /// <p>The token for the next page of results.</p>
    pub next_token: Option<String>,
}

/// Serialize `DescribeFastSnapshotRestoresRequest` contents to a `SignedRequest`.
struct DescribeFastSnapshotRestoresRequestSerializer;
impl DescribeFastSnapshotRestoresRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeFastSnapshotRestoresRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.max_results {
            params.put(&format!("{}{}", prefix, "MaxResults"), &field_value);
        }
        if let Some(ref field_value) = obj.next_token {
            params.put(&format!("{}{}", prefix, "NextToken"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeFastSnapshotRestoresResult {
    /// <p>Information about the state of fast snapshot restores.</p>
    pub fast_snapshot_restores: Option<Vec<DescribeFastSnapshotRestoreSuccessItem>>,
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: Option<String>,
}

#[allow(dead_code)]
struct DescribeFastSnapshotRestoresResultDeserializer;
impl DescribeFastSnapshotRestoresResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeFastSnapshotRestoresResult, XmlParseError> {
        deserialize_elements::<_, DescribeFastSnapshotRestoresResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "fastSnapshotRestoreSet" => {
                        obj.fast_snapshot_restores.get_or_insert(vec![]).extend(
                            DescribeFastSnapshotRestoreSuccessSetDeserializer::deserialize(
                                "fastSnapshotRestoreSet",
                                stack,
                            )?,
                        );
                    }
                    "nextToken" => {
                        obj.next_token =
                            Some(NextTokenDeserializer::deserialize("nextToken", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Describes the instances that could not be launched by the fleet.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeFleetError {
    /// <p>The error code that indicates why the instance could not be launched. For more information about error codes, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html.html">Error Codes</a>.</p>
    pub error_code: Option<String>,
    /// <p>The error message that describes why the instance could not be launched. For more information about error messages, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html.html">Error Codes</a>.</p>
    pub error_message: Option<String>,
    /// <p>The launch templates and overrides that were used for launching the instances. The values that you specify in the Overrides replace the values in the launch template.</p>
    pub launch_template_and_overrides: Option<LaunchTemplateAndOverridesResponse>,
    /// <p>Indicates if the instance that could not be launched was a Spot Instance or On-Demand Instance.</p>
    pub lifecycle: Option<String>,
}

#[allow(dead_code)]
struct DescribeFleetErrorDeserializer;
impl DescribeFleetErrorDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeFleetError, XmlParseError> {
        deserialize_elements::<_, DescribeFleetError, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "errorCode" => {
                    obj.error_code = Some(StringDeserializer::deserialize("errorCode", stack)?);
                }
                "errorMessage" => {
                    obj.error_message =
                        Some(StringDeserializer::deserialize("errorMessage", stack)?);
                }
                "launchTemplateAndOverrides" => {
                    obj.launch_template_and_overrides =
                        Some(LaunchTemplateAndOverridesResponseDeserializer::deserialize(
                            "launchTemplateAndOverrides",
                            stack,
                        )?);
                }
                "lifecycle" => {
                    obj.lifecycle = Some(InstanceLifecycleDeserializer::deserialize(
                        "lifecycle",
                        stack,
                    )?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeFleetHistoryRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The type of events to describe. By default, all events are described.</p>
    pub event_type: Option<String>,
    /// <p>The ID of the EC2 Fleet.</p>
    pub fleet_id: String,
    /// <p>The maximum number of results to return in a single call. Specify a value between 1 and 1000. The default value is 1000. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>
    pub max_results: Option<i64>,
    /// <p>The token for the next set of results.</p>
    pub next_token: Option<String>,
    /// <p>The start date and time for the events, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>
    pub start_time: String,
}

/// Serialize `DescribeFleetHistoryRequest` contents to a `SignedRequest`.
struct DescribeFleetHistoryRequestSerializer;
impl DescribeFleetHistoryRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeFleetHistoryRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.event_type {
            params.put(&format!("{}{}", prefix, "EventType"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "FleetId"), &obj.fleet_id);
        if let Some(ref field_value) = obj.max_results {
            params.put(&format!("{}{}", prefix, "MaxResults"), &field_value);
        }
        if let Some(ref field_value) = obj.next_token {
            params.put(&format!("{}{}", prefix, "NextToken"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "StartTime"), &obj.start_time);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeFleetHistoryResult {
    /// <p>The ID of the EC Fleet.</p>
    pub fleet_id: Option<String>,
    /// <p>Information about the events in the history of the EC2 Fleet.</p>
    pub history_records: Option<Vec<HistoryRecordEntry>>,
    /// <p>The last date and time for the events, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). All records up to this time were retrieved.</p> <p>If <code>nextToken</code> indicates that there are more results, this value is not present.</p>
    pub last_evaluated_time: Option<String>,
    /// <p>The token for the next set of results.</p>
    pub next_token: Option<String>,
    /// <p>The start date and time for the events, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>
    pub start_time: Option<String>,
}

#[allow(dead_code)]
struct DescribeFleetHistoryResultDeserializer;
impl DescribeFleetHistoryResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeFleetHistoryResult, XmlParseError> {
        deserialize_elements::<_, DescribeFleetHistoryResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "fleetId" => {
                        obj.fleet_id = Some(FleetIdDeserializer::deserialize("fleetId", stack)?);
                    }
                    "historyRecordSet" => {
                        obj.history_records.get_or_insert(vec![]).extend(
                            HistoryRecordSetDeserializer::deserialize("historyRecordSet", stack)?,
                        );
                    }
                    "lastEvaluatedTime" => {
                        obj.last_evaluated_time = Some(DateTimeDeserializer::deserialize(
                            "lastEvaluatedTime",
                            stack,
                        )?);
                    }
                    "nextToken" => {
                        obj.next_token = Some(StringDeserializer::deserialize("nextToken", stack)?);
                    }
                    "startTime" => {
                        obj.start_time =
                            Some(DateTimeDeserializer::deserialize("startTime", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeFleetInstancesRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p><p>The filters.</p> <ul> <li> <p> <code>instance-type</code> - The instance type.</p> </li> </ul></p>
    pub filters: Option<Vec<Filter>>,
    /// <p>The ID of the EC2 Fleet.</p>
    pub fleet_id: String,
    /// <p>The maximum number of results to return in a single call. Specify a value between 1 and 1000. The default value is 1000. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>
    pub max_results: Option<i64>,
    /// <p>The token for the next set of results.</p>
    pub next_token: Option<String>,
}

/// Serialize `DescribeFleetInstancesRequest` contents to a `SignedRequest`.
struct DescribeFleetInstancesRequestSerializer;
impl DescribeFleetInstancesRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeFleetInstancesRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        params.put(&format!("{}{}", prefix, "FleetId"), &obj.fleet_id);
        if let Some(ref field_value) = obj.max_results {
            params.put(&format!("{}{}", prefix, "MaxResults"), &field_value);
        }
        if let Some(ref field_value) = obj.next_token {
            params.put(&format!("{}{}", prefix, "NextToken"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeFleetInstancesResult {
    /// <p>The running instances. This list is refreshed periodically and might be out of date.</p>
    pub active_instances: Option<Vec<ActiveInstance>>,
    /// <p>The ID of the EC2 Fleet.</p>
    pub fleet_id: Option<String>,
    /// <p>The token for the next set of results.</p>
    pub next_token: Option<String>,
}

#[allow(dead_code)]
struct DescribeFleetInstancesResultDeserializer;
impl DescribeFleetInstancesResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeFleetInstancesResult, XmlParseError> {
        deserialize_elements::<_, DescribeFleetInstancesResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "activeInstanceSet" => {
                        obj.active_instances.get_or_insert(vec![]).extend(
                            ActiveInstanceSetDeserializer::deserialize("activeInstanceSet", stack)?,
                        );
                    }
                    "fleetId" => {
                        obj.fleet_id = Some(FleetIdDeserializer::deserialize("fleetId", stack)?);
                    }
                    "nextToken" => {
                        obj.next_token = Some(StringDeserializer::deserialize("nextToken", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct DescribeFleetsErrorSetDeserializer;
impl DescribeFleetsErrorSetDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<DescribeFleetError>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "item" {
                obj.push(DescribeFleetErrorDeserializer::deserialize("item", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Describes the instances that were launched by the fleet.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeFleetsInstances {
    /// <p>The IDs of the instances.</p>
    pub instance_ids: Option<Vec<String>>,
    /// <p>The instance type.</p>
    pub instance_type: Option<String>,
    /// <p>The launch templates and overrides that were used for launching the instances. The values that you specify in the Overrides replace the values in the launch template.</p>
    pub launch_template_and_overrides: Option<LaunchTemplateAndOverridesResponse>,
    /// <p>Indicates if the instance that was launched is a Spot Instance or On-Demand Instance.</p>
    pub lifecycle: Option<String>,
    /// <p>The value is <code>Windows</code> for Windows instances. Otherwise, the value is blank.</p>
    pub platform: Option<String>,
}

#[allow(dead_code)]
struct DescribeFleetsInstancesDeserializer;
impl DescribeFleetsInstancesDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeFleetsInstances, XmlParseError> {
        deserialize_elements::<_, DescribeFleetsInstances, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "instanceIds" => {
                        obj.instance_ids.get_or_insert(vec![]).extend(
                            InstanceIdsSetDeserializer::deserialize("instanceIds", stack)?,
                        );
                    }
                    "instanceType" => {
                        obj.instance_type = Some(InstanceTypeDeserializer::deserialize(
                            "instanceType",
                            stack,
                        )?);
                    }
                    "launchTemplateAndOverrides" => {
                        obj.launch_template_and_overrides =
                            Some(LaunchTemplateAndOverridesResponseDeserializer::deserialize(
                                "launchTemplateAndOverrides",
                                stack,
                            )?);
                    }
                    "lifecycle" => {
                        obj.lifecycle = Some(InstanceLifecycleDeserializer::deserialize(
                            "lifecycle",
                            stack,
                        )?);
                    }
                    "platform" => {
                        obj.platform =
                            Some(PlatformValuesDeserializer::deserialize("platform", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct DescribeFleetsInstancesSetDeserializer;
impl DescribeFleetsInstancesSetDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<DescribeFleetsInstances>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "item" {
                obj.push(DescribeFleetsInstancesDeserializer::deserialize(
                    "item", stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeFleetsRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p><p>The filters.</p> <ul> <li> <p> <code>activity-status</code> - The progress of the EC2 Fleet ( <code>error</code> | <code>pending-fulfillment</code> | <code>pending-termination</code> | <code>fulfilled</code>).</p> </li> <li> <p> <code>excess-capacity-termination-policy</code> - Indicates whether to terminate running instances if the target capacity is decreased below the current EC2 Fleet size (<code>true</code> | <code>false</code>).</p> </li> <li> <p> <code>fleet-state</code> - The state of the EC2 Fleet (<code>submitted</code> | <code>active</code> | <code>deleted</code> | <code>failed</code> | <code>deleted-running</code> | <code>deleted-terminating</code> | <code>modifying</code>).</p> </li> <li> <p> <code>replace-unhealthy-instances</code> - Indicates whether EC2 Fleet should replace unhealthy instances (<code>true</code> | <code>false</code>).</p> </li> <li> <p> <code>type</code> - The type of request (<code>instant</code> | <code>request</code> | <code>maintain</code>).</p> </li> </ul></p>
    pub filters: Option<Vec<Filter>>,
    /// <p>The ID of the EC2 Fleets.</p>
    pub fleet_ids: Option<Vec<String>>,
    /// <p>The maximum number of results to return in a single call. Specify a value between 1 and 1000. The default value is 1000. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>
    pub max_results: Option<i64>,
    /// <p>The token for the next set of results.</p>
    pub next_token: Option<String>,
}

/// Serialize `DescribeFleetsRequest` contents to a `SignedRequest`.
struct DescribeFleetsRequestSerializer;
impl DescribeFleetsRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeFleetsRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.fleet_ids {
            FleetIdSetSerializer::serialize(
                params,
                &format!("{}{}", prefix, "FleetId"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.max_results {
            params.put(&format!("{}{}", prefix, "MaxResults"), &field_value);
        }
        if let Some(ref field_value) = obj.next_token {
            params.put(&format!("{}{}", prefix, "NextToken"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeFleetsResult {
    /// <p>Information about the EC2 Fleets.</p>
    pub fleets: Option<Vec<FleetData>>,
    /// <p>The token for the next set of results.</p>
    pub next_token: Option<String>,
}

#[allow(dead_code)]
struct DescribeFleetsResultDeserializer;
impl DescribeFleetsResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeFleetsResult, XmlParseError> {
        deserialize_elements::<_, DescribeFleetsResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "fleetSet" => {
                    obj.fleets
                        .get_or_insert(vec![])
                        .extend(FleetSetDeserializer::deserialize("fleetSet", stack)?);
                }
                "nextToken" => {
                    obj.next_token = Some(StringDeserializer::deserialize("nextToken", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeFlowLogsRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p><p>One or more filters.</p> <ul> <li> <p> <code>deliver-log-status</code> - The status of the logs delivery (<code>SUCCESS</code> | <code>FAILED</code>).</p> </li> <li> <p> <code>log-destination-type</code> - The type of destination to which the flow log publishes data. Possible destination types include <code>cloud-watch-logs</code> and <code>s3</code>.</p> </li> <li> <p> <code>flow-log-id</code> - The ID of the flow log.</p> </li> <li> <p> <code>log-group-name</code> - The name of the log group.</p> </li> <li> <p> <code>resource-id</code> - The ID of the VPC, subnet, or network interface.</p> </li> <li> <p> <code>traffic-type</code> - The type of traffic (<code>ACCEPT</code> | <code>REJECT</code> | <code>ALL</code>).</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> </ul></p>
    pub filter: Option<Vec<Filter>>,
    /// <p>One or more flow log IDs.</p> <p>Constraint: Maximum of 1000 flow log IDs.</p>
    pub flow_log_ids: Option<Vec<String>>,
    /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    pub max_results: Option<i64>,
    /// <p>The token for the next page of results.</p>
    pub next_token: Option<String>,
}

/// Serialize `DescribeFlowLogsRequest` contents to a `SignedRequest`.
struct DescribeFlowLogsRequestSerializer;
impl DescribeFlowLogsRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeFlowLogsRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.filter {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.flow_log_ids {
            FlowLogIdListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "FlowLogId"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.max_results {
            params.put(&format!("{}{}", prefix, "MaxResults"), &field_value);
        }
        if let Some(ref field_value) = obj.next_token {
            params.put(&format!("{}{}", prefix, "NextToken"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeFlowLogsResult {
    /// <p>Information about the flow logs.</p>
    pub flow_logs: Option<Vec<FlowLog>>,
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: Option<String>,
}

#[allow(dead_code)]
struct DescribeFlowLogsResultDeserializer;
impl DescribeFlowLogsResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeFlowLogsResult, XmlParseError> {
        deserialize_elements::<_, DescribeFlowLogsResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "flowLogSet" => {
                    obj.flow_logs
                        .get_or_insert(vec![])
                        .extend(FlowLogSetDeserializer::deserialize("flowLogSet", stack)?);
                }
                "nextToken" => {
                    obj.next_token = Some(StringDeserializer::deserialize("nextToken", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeFpgaImageAttributeRequest {
    /// <p>The AFI attribute.</p>
    pub attribute: String,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the AFI.</p>
    pub fpga_image_id: String,
}

/// Serialize `DescribeFpgaImageAttributeRequest` contents to a `SignedRequest`.
struct DescribeFpgaImageAttributeRequestSerializer;
impl DescribeFpgaImageAttributeRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeFpgaImageAttributeRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "Attribute"), &obj.attribute);
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "FpgaImageId"), &obj.fpga_image_id);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeFpgaImageAttributeResult {
    /// <p>Information about the attribute.</p>
    pub fpga_image_attribute: Option<FpgaImageAttribute>,
}

#[allow(dead_code)]
struct DescribeFpgaImageAttributeResultDeserializer;
impl DescribeFpgaImageAttributeResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeFpgaImageAttributeResult, XmlParseError> {
        deserialize_elements::<_, DescribeFpgaImageAttributeResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "fpgaImageAttribute" => {
                        obj.fpga_image_attribute =
                            Some(FpgaImageAttributeDeserializer::deserialize(
                                "fpgaImageAttribute",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeFpgaImagesRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p><p>The filters.</p> <ul> <li> <p> <code>create-time</code> - The creation time of the AFI.</p> </li> <li> <p> <code>fpga-image-id</code> - The FPGA image identifier (AFI ID).</p> </li> <li> <p> <code>fpga-image-global-id</code> - The global FPGA image identifier (AGFI ID).</p> </li> <li> <p> <code>name</code> - The name of the AFI.</p> </li> <li> <p> <code>owner-id</code> - The AWS account ID of the AFI owner.</p> </li> <li> <p> <code>product-code</code> - The product code.</p> </li> <li> <p> <code>shell-version</code> - The version of the AWS Shell that was used to create the bitstream.</p> </li> <li> <p> <code>state</code> - The state of the AFI (<code>pending</code> | <code>failed</code> | <code>available</code> | <code>unavailable</code>).</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> <li> <p> <code>update-time</code> - The time of the most recent update.</p> </li> </ul></p>
    pub filters: Option<Vec<Filter>>,
    /// <p>The AFI IDs.</p>
    pub fpga_image_ids: Option<Vec<String>>,
    /// <p>The maximum number of results to return in a single call.</p>
    pub max_results: Option<i64>,
    /// <p>The token to retrieve the next page of results.</p>
    pub next_token: Option<String>,
    /// <p>Filters the AFI by owner. Specify an AWS account ID, <code>self</code> (owner is the sender of the request), or an AWS owner alias (valid values are <code>amazon</code> | <code>aws-marketplace</code>).</p>
    pub owners: Option<Vec<String>>,
}

/// Serialize `DescribeFpgaImagesRequest` contents to a `SignedRequest`.
struct DescribeFpgaImagesRequestSerializer;
impl DescribeFpgaImagesRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeFpgaImagesRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.fpga_image_ids {
            FpgaImageIdListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "FpgaImageId"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.max_results {
            params.put(&format!("{}{}", prefix, "MaxResults"), &field_value);
        }
        if let Some(ref field_value) = obj.next_token {
            params.put(&format!("{}{}", prefix, "NextToken"), &field_value);
        }
        if let Some(ref field_value) = obj.owners {
            OwnerStringListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Owner"),
                field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeFpgaImagesResult {
    /// <p>Information about the FPGA images.</p>
    pub fpga_images: Option<Vec<FpgaImage>>,
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: Option<String>,
}

#[allow(dead_code)]
struct DescribeFpgaImagesResultDeserializer;
impl DescribeFpgaImagesResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeFpgaImagesResult, XmlParseError> {
        deserialize_elements::<_, DescribeFpgaImagesResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "fpgaImageSet" => {
                        obj.fpga_images.get_or_insert(vec![]).extend(
                            FpgaImageListDeserializer::deserialize("fpgaImageSet", stack)?,
                        );
                    }
                    "nextToken" => {
                        obj.next_token =
                            Some(NextTokenDeserializer::deserialize("nextToken", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeHostReservationOfferingsRequest {
    /// <p><p>The filters.</p> <ul> <li> <p> <code>instance-family</code> - The instance family of the offering (for example, <code>m4</code>).</p> </li> <li> <p> <code>payment-option</code> - The payment option (<code>NoUpfront</code> | <code>PartialUpfront</code> | <code>AllUpfront</code>).</p> </li> </ul></p>
    pub filter: Option<Vec<Filter>>,
    /// <p>This is the maximum duration of the reservation to purchase, specified in seconds. Reservations are available in one-year and three-year terms. The number of seconds specified must be the number of seconds in a year (365x24x60x60) times one of the supported durations (1 or 3). For example, specify 94608000 for three years.</p>
    pub max_duration: Option<i64>,
    /// <p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the returned <code>nextToken</code> value. This value can be between 5 and 500. If <code>maxResults</code> is given a larger value than 500, you receive an error.</p>
    pub max_results: Option<i64>,
    /// <p>This is the minimum duration of the reservation you'd like to purchase, specified in seconds. Reservations are available in one-year and three-year terms. The number of seconds specified must be the number of seconds in a year (365x24x60x60) times one of the supported durations (1 or 3). For example, specify 31536000 for one year.</p>
    pub min_duration: Option<i64>,
    /// <p>The token to use to retrieve the next page of results.</p>
    pub next_token: Option<String>,
    /// <p>The ID of the reservation offering.</p>
    pub offering_id: Option<String>,
}

/// Serialize `DescribeHostReservationOfferingsRequest` contents to a `SignedRequest`.
struct DescribeHostReservationOfferingsRequestSerializer;
impl DescribeHostReservationOfferingsRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeHostReservationOfferingsRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.filter {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.max_duration {
            params.put(&format!("{}{}", prefix, "MaxDuration"), &field_value);
        }
        if let Some(ref field_value) = obj.max_results {
            params.put(&format!("{}{}", prefix, "MaxResults"), &field_value);
        }
        if let Some(ref field_value) = obj.min_duration {
            params.put(&format!("{}{}", prefix, "MinDuration"), &field_value);
        }
        if let Some(ref field_value) = obj.next_token {
            params.put(&format!("{}{}", prefix, "NextToken"), &field_value);
        }
        if let Some(ref field_value) = obj.offering_id {
            params.put(&format!("{}{}", prefix, "OfferingId"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeHostReservationOfferingsResult {
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: Option<String>,
    /// <p>Information about the offerings.</p>
    pub offering_set: Option<Vec<HostOffering>>,
}

#[allow(dead_code)]
struct DescribeHostReservationOfferingsResultDeserializer;
impl DescribeHostReservationOfferingsResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeHostReservationOfferingsResult, XmlParseError> {
        deserialize_elements::<_, DescribeHostReservationOfferingsResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "nextToken" => {
                        obj.next_token = Some(StringDeserializer::deserialize("nextToken", stack)?);
                    }
                    "offeringSet" => {
                        obj.offering_set.get_or_insert(vec![]).extend(
                            HostOfferingSetDeserializer::deserialize("offeringSet", stack)?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeHostReservationsRequest {
    /// <p><p>The filters.</p> <ul> <li> <p> <code>instance-family</code> - The instance family (for example, <code>m4</code>).</p> </li> <li> <p> <code>payment-option</code> - The payment option (<code>NoUpfront</code> | <code>PartialUpfront</code> | <code>AllUpfront</code>).</p> </li> <li> <p> <code>state</code> - The state of the reservation (<code>payment-pending</code> | <code>payment-failed</code> | <code>active</code> | <code>retired</code>).</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> </ul></p>
    pub filter: Option<Vec<Filter>>,
    /// <p>The host reservation IDs.</p>
    pub host_reservation_id_set: Option<Vec<String>>,
    /// <p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the returned <code>nextToken</code> value. This value can be between 5 and 500. If <code>maxResults</code> is given a larger value than 500, you receive an error.</p>
    pub max_results: Option<i64>,
    /// <p>The token to use to retrieve the next page of results.</p>
    pub next_token: Option<String>,
}

/// Serialize `DescribeHostReservationsRequest` contents to a `SignedRequest`.
struct DescribeHostReservationsRequestSerializer;
impl DescribeHostReservationsRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeHostReservationsRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.filter {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.host_reservation_id_set {
            HostReservationIdSetSerializer::serialize(
                params,
                &format!("{}{}", prefix, "HostReservationIdSet"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.max_results {
            params.put(&format!("{}{}", prefix, "MaxResults"), &field_value);
        }
        if let Some(ref field_value) = obj.next_token {
            params.put(&format!("{}{}", prefix, "NextToken"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeHostReservationsResult {
    /// <p>Details about the reservation's configuration.</p>
    pub host_reservation_set: Option<Vec<HostReservation>>,
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: Option<String>,
}

#[allow(dead_code)]
struct DescribeHostReservationsResultDeserializer;
impl DescribeHostReservationsResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeHostReservationsResult, XmlParseError> {
        deserialize_elements::<_, DescribeHostReservationsResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "hostReservationSet" => {
                        obj.host_reservation_set.get_or_insert(vec![]).extend(
                            HostReservationSetDeserializer::deserialize(
                                "hostReservationSet",
                                stack,
                            )?,
                        );
                    }
                    "nextToken" => {
                        obj.next_token = Some(StringDeserializer::deserialize("nextToken", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeHostsRequest {
    /// <p><p>The filters.</p> <ul> <li> <p> <code>auto-placement</code> - Whether auto-placement is enabled or disabled (<code>on</code> | <code>off</code>).</p> </li> <li> <p> <code>availability-zone</code> - The Availability Zone of the host.</p> </li> <li> <p> <code>client-token</code> - The idempotency token that you provided when you allocated the host.</p> </li> <li> <p> <code>host-reservation-id</code> - The ID of the reservation assigned to this host.</p> </li> <li> <p> <code>instance-type</code> - The instance type size that the Dedicated Host is configured to support.</p> </li> <li> <p> <code>state</code> - The allocation state of the Dedicated Host (<code>available</code> | <code>under-assessment</code> | <code>permanent-failure</code> | <code>released</code> | <code>released-permanent-failure</code>).</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> </ul></p>
    pub filter: Option<Vec<Filter>>,
    /// <p>The IDs of the Dedicated Hosts. The IDs are used for targeted instance launches.</p>
    pub host_ids: Option<Vec<String>>,
    /// <p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the returned <code>nextToken</code> value. This value can be between 5 and 500. If <code>maxResults</code> is given a larger value than 500, you receive an error.</p> <p>You cannot specify this parameter and the host IDs parameter in the same request.</p>
    pub max_results: Option<i64>,
    /// <p>The token to use to retrieve the next page of results.</p>
    pub next_token: Option<String>,
}

/// Serialize `DescribeHostsRequest` contents to a `SignedRequest`.
struct DescribeHostsRequestSerializer;
impl DescribeHostsRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeHostsRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.filter {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.host_ids {
            RequestHostIdListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "HostId"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.max_results {
            params.put(&format!("{}{}", prefix, "MaxResults"), &field_value);
        }
        if let Some(ref field_value) = obj.next_token {
            params.put(&format!("{}{}", prefix, "NextToken"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeHostsResult {
    /// <p>Information about the Dedicated Hosts.</p>
    pub hosts: Option<Vec<Host>>,
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: Option<String>,
}

#[allow(dead_code)]
struct DescribeHostsResultDeserializer;
impl DescribeHostsResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeHostsResult, XmlParseError> {
        deserialize_elements::<_, DescribeHostsResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "hostSet" => {
                    obj.hosts
                        .get_or_insert(vec![])
                        .extend(HostListDeserializer::deserialize("hostSet", stack)?);
                }
                "nextToken" => {
                    obj.next_token = Some(StringDeserializer::deserialize("nextToken", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeIamInstanceProfileAssociationsRequest {
    /// <p>The IAM instance profile associations.</p>
    pub association_ids: Option<Vec<String>>,
    /// <p><p>The filters.</p> <ul> <li> <p> <code>instance-id</code> - The ID of the instance.</p> </li> <li> <p> <code>state</code> - The state of the association (<code>associating</code> | <code>associated</code> | <code>disassociating</code>).</p> </li> </ul></p>
    pub filters: Option<Vec<Filter>>,
    /// <p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>
    pub max_results: Option<i64>,
    /// <p>The token to request the next page of results.</p>
    pub next_token: Option<String>,
}

/// Serialize `DescribeIamInstanceProfileAssociationsRequest` contents to a `SignedRequest`.
struct DescribeIamInstanceProfileAssociationsRequestSerializer;
impl DescribeIamInstanceProfileAssociationsRequestSerializer {
    fn serialize(
        params: &mut Params,
        name: &str,
        obj: &DescribeIamInstanceProfileAssociationsRequest,
    ) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.association_ids {
            AssociationIdListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "AssociationId"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.max_results {
            params.put(&format!("{}{}", prefix, "MaxResults"), &field_value);
        }
        if let Some(ref field_value) = obj.next_token {
            params.put(&format!("{}{}", prefix, "NextToken"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeIamInstanceProfileAssociationsResult {
    /// <p>Information about the IAM instance profile associations.</p>
    pub iam_instance_profile_associations: Option<Vec<IamInstanceProfileAssociation>>,
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: Option<String>,
}

#[allow(dead_code)]
struct DescribeIamInstanceProfileAssociationsResultDeserializer;
impl DescribeIamInstanceProfileAssociationsResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeIamInstanceProfileAssociationsResult, XmlParseError> {
        deserialize_elements::<_, DescribeIamInstanceProfileAssociationsResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "iamInstanceProfileAssociationSet" => {
                        obj.iam_instance_profile_associations
                            .get_or_insert(vec![])
                            .extend(IamInstanceProfileAssociationSetDeserializer::deserialize(
                                "iamInstanceProfileAssociationSet",
                                stack,
                            )?);
                    }
                    "nextToken" => {
                        obj.next_token =
                            Some(NextTokenDeserializer::deserialize("nextToken", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeIdFormatRequest {
    /// <p>The type of resource: <code>bundle</code> | <code>conversion-task</code> | <code>customer-gateway</code> | <code>dhcp-options</code> | <code>elastic-ip-allocation</code> | <code>elastic-ip-association</code> | <code>export-task</code> | <code>flow-log</code> | <code>image</code> | <code>import-task</code> | <code>instance</code> | <code>internet-gateway</code> | <code>network-acl</code> | <code>network-acl-association</code> | <code>network-interface</code> | <code>network-interface-attachment</code> | <code>prefix-list</code> | <code>reservation</code> | <code>route-table</code> | <code>route-table-association</code> | <code>security-group</code> | <code>snapshot</code> | <code>subnet</code> | <code>subnet-cidr-block-association</code> | <code>volume</code> | <code>vpc</code> | <code>vpc-cidr-block-association</code> | <code>vpc-endpoint</code> | <code>vpc-peering-connection</code> | <code>vpn-connection</code> | <code>vpn-gateway</code> </p>
    pub resource: Option<String>,
}

/// Serialize `DescribeIdFormatRequest` contents to a `SignedRequest`.
struct DescribeIdFormatRequestSerializer;
impl DescribeIdFormatRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeIdFormatRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.resource {
            params.put(&format!("{}{}", prefix, "Resource"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeIdFormatResult {
    /// <p>Information about the ID format for the resource.</p>
    pub statuses: Option<Vec<IdFormat>>,
}

#[allow(dead_code)]
struct DescribeIdFormatResultDeserializer;
impl DescribeIdFormatResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeIdFormatResult, XmlParseError> {
        deserialize_elements::<_, DescribeIdFormatResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "statusSet" => {
                    obj.statuses
                        .get_or_insert(vec![])
                        .extend(IdFormatListDeserializer::deserialize("statusSet", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeIdentityIdFormatRequest {
    /// <p>The ARN of the principal, which can be an IAM role, IAM user, or the root user.</p>
    pub principal_arn: String,
    /// <p>The type of resource: <code>bundle</code> | <code>conversion-task</code> | <code>customer-gateway</code> | <code>dhcp-options</code> | <code>elastic-ip-allocation</code> | <code>elastic-ip-association</code> | <code>export-task</code> | <code>flow-log</code> | <code>image</code> | <code>import-task</code> | <code>instance</code> | <code>internet-gateway</code> | <code>network-acl</code> | <code>network-acl-association</code> | <code>network-interface</code> | <code>network-interface-attachment</code> | <code>prefix-list</code> | <code>reservation</code> | <code>route-table</code> | <code>route-table-association</code> | <code>security-group</code> | <code>snapshot</code> | <code>subnet</code> | <code>subnet-cidr-block-association</code> | <code>volume</code> | <code>vpc</code> | <code>vpc-cidr-block-association</code> | <code>vpc-endpoint</code> | <code>vpc-peering-connection</code> | <code>vpn-connection</code> | <code>vpn-gateway</code> </p>
    pub resource: Option<String>,
}

/// Serialize `DescribeIdentityIdFormatRequest` contents to a `SignedRequest`.
struct DescribeIdentityIdFormatRequestSerializer;
impl DescribeIdentityIdFormatRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeIdentityIdFormatRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "PrincipalArn"), &obj.principal_arn);
        if let Some(ref field_value) = obj.resource {
            params.put(&format!("{}{}", prefix, "Resource"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeIdentityIdFormatResult {
    /// <p>Information about the ID format for the resources.</p>
    pub statuses: Option<Vec<IdFormat>>,
}

#[allow(dead_code)]
struct DescribeIdentityIdFormatResultDeserializer;
impl DescribeIdentityIdFormatResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeIdentityIdFormatResult, XmlParseError> {
        deserialize_elements::<_, DescribeIdentityIdFormatResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "statusSet" => {
                        obj.statuses
                            .get_or_insert(vec![])
                            .extend(IdFormatListDeserializer::deserialize("statusSet", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Contains the parameters for DescribeImageAttribute.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeImageAttributeRequest {
    /// <p>The AMI attribute.</p> <p> <b>Note</b>: The <code>blockDeviceMapping</code> attribute is deprecated. Using this attribute returns the <code>Client.AuthFailure</code> error. To get information about the block device mappings for an AMI, use the <a>DescribeImages</a> action.</p>
    pub attribute: String,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the AMI.</p>
    pub image_id: String,
}

/// Serialize `DescribeImageAttributeRequest` contents to a `SignedRequest`.
struct DescribeImageAttributeRequestSerializer;
impl DescribeImageAttributeRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeImageAttributeRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "Attribute"), &obj.attribute);
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "ImageId"), &obj.image_id);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeImagesRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>Scopes the images by users with explicit launch permissions. Specify an AWS account ID, <code>self</code> (the sender of the request), or <code>all</code> (public AMIs).</p>
    pub executable_users: Option<Vec<String>>,
    /// <p><p>The filters.</p> <ul> <li> <p> <code>architecture</code> - The image architecture (<code>i386</code> | <code>x86_64</code> | <code>arm64</code>).</p> </li> <li> <p> <code>block-device-mapping.delete-on-termination</code> - A Boolean value that indicates whether the Amazon EBS volume is deleted on instance termination.</p> </li> <li> <p> <code>block-device-mapping.device-name</code> - The device name specified in the block device mapping (for example, <code>/dev/sdh</code> or <code>xvdh</code>).</p> </li> <li> <p> <code>block-device-mapping.snapshot-id</code> - The ID of the snapshot used for the EBS volume.</p> </li> <li> <p> <code>block-device-mapping.volume-size</code> - The volume size of the EBS volume, in GiB.</p> </li> <li> <p> <code>block-device-mapping.volume-type</code> - The volume type of the EBS volume (<code>gp2</code> | <code>io1</code> | <code>io2</code> | <code>st1 </code>| <code>sc1</code> | <code>standard</code>).</p> </li> <li> <p> <code>block-device-mapping.encrypted</code> - A Boolean that indicates whether the EBS volume is encrypted.</p> </li> <li> <p> <code>description</code> - The description of the image (provided during image creation).</p> </li> <li> <p> <code>ena-support</code> - A Boolean that indicates whether enhanced networking with ENA is enabled.</p> </li> <li> <p> <code>hypervisor</code> - The hypervisor type (<code>ovm</code> | <code>xen</code>).</p> </li> <li> <p> <code>image-id</code> - The ID of the image.</p> </li> <li> <p> <code>image-type</code> - The image type (<code>machine</code> | <code>kernel</code> | <code>ramdisk</code>).</p> </li> <li> <p> <code>is-public</code> - A Boolean that indicates whether the image is public.</p> </li> <li> <p> <code>kernel-id</code> - The kernel ID.</p> </li> <li> <p> <code>manifest-location</code> - The location of the image manifest.</p> </li> <li> <p> <code>name</code> - The name of the AMI (provided during image creation).</p> </li> <li> <p> <code>owner-alias</code> - The owner alias (<code>amazon</code> | <code>aws-marketplace</code>). The valid aliases are defined in an Amazon-maintained list. This is not the AWS account alias that can be set using the IAM console. We recommend that you use the <b>Owner</b> request parameter instead of this filter.</p> </li> <li> <p> <code>owner-id</code> - The AWS account ID of the owner. We recommend that you use the <b>Owner</b> request parameter instead of this filter.</p> </li> <li> <p> <code>platform</code> - The platform. To only list Windows-based AMIs, use <code>windows</code>.</p> </li> <li> <p> <code>product-code</code> - The product code.</p> </li> <li> <p> <code>product-code.type</code> - The type of the product code (<code>devpay</code> | <code>marketplace</code>).</p> </li> <li> <p> <code>ramdisk-id</code> - The RAM disk ID.</p> </li> <li> <p> <code>root-device-name</code> - The device name of the root device volume (for example, <code>/dev/sda1</code>).</p> </li> <li> <p> <code>root-device-type</code> - The type of the root device volume (<code>ebs</code> | <code>instance-store</code>).</p> </li> <li> <p> <code>state</code> - The state of the image (<code>available</code> | <code>pending</code> | <code>failed</code>).</p> </li> <li> <p> <code>state-reason-code</code> - The reason code for the state change.</p> </li> <li> <p> <code>state-reason-message</code> - The message for the state change.</p> </li> <li> <p> <code>sriov-net-support</code> - A value of <code>simple</code> indicates that enhanced networking with the Intel 82599 VF interface is enabled.</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> <li> <p> <code>virtualization-type</code> - The virtualization type (<code>paravirtual</code> | <code>hvm</code>).</p> </li> </ul></p>
    pub filters: Option<Vec<Filter>>,
    /// <p>The image IDs.</p> <p>Default: Describes all images available to you.</p>
    pub image_ids: Option<Vec<String>>,
    /// <p><p>If <code>true</code>, all deprecated AMIs are included in the response. If <code>false</code>, no deprecated AMIs are included in the response. If no value is specified, the default value is <code>false</code>.</p> <note> <p>If you are the AMI owner, all deprecated AMIs appear in the response regardless of the value (<code>true</code> or <code>false</code>) that you set for this parameter.</p> </note></p>
    pub include_deprecated: Option<bool>,
    /// <p>Scopes the results to images with the specified owners. You can specify a combination of AWS account IDs, <code>self</code>, <code>amazon</code>, and <code>aws-marketplace</code>. If you omit this parameter, the results include all images for which you have launch permissions, regardless of ownership.</p>
    pub owners: Option<Vec<String>>,
}

/// Serialize `DescribeImagesRequest` contents to a `SignedRequest`.
struct DescribeImagesRequestSerializer;
impl DescribeImagesRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeImagesRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.executable_users {
            ExecutableByStringListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "ExecutableBy"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.image_ids {
            ImageIdStringListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "ImageId"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.include_deprecated {
            params.put(&format!("{}{}", prefix, "IncludeDeprecated"), &field_value);
        }
        if let Some(ref field_value) = obj.owners {
            OwnerStringListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Owner"),
                field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeImagesResult {
    /// <p>Information about the images.</p>
    pub images: Option<Vec<Image>>,
}

#[allow(dead_code)]
struct DescribeImagesResultDeserializer;
impl DescribeImagesResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeImagesResult, XmlParseError> {
        deserialize_elements::<_, DescribeImagesResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "imagesSet" => {
                    obj.images
                        .get_or_insert(vec![])
                        .extend(ImageListDeserializer::deserialize("imagesSet", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeImportImageTasksRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>Filter tasks using the <code>task-state</code> filter and one of the following values: <code>active</code>, <code>completed</code>, <code>deleting</code>, or <code>deleted</code>.</p>
    pub filters: Option<Vec<Filter>>,
    /// <p>The IDs of the import image tasks.</p>
    pub import_task_ids: Option<Vec<String>>,
    /// <p>The maximum number of results to return in a single call.</p>
    pub max_results: Option<i64>,
    /// <p>A token that indicates the next page of results.</p>
    pub next_token: Option<String>,
}

/// Serialize `DescribeImportImageTasksRequest` contents to a `SignedRequest`.
struct DescribeImportImageTasksRequestSerializer;
impl DescribeImportImageTasksRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeImportImageTasksRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filters"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.import_task_ids {
            ImportTaskIdListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "ImportTaskId"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.max_results {
            params.put(&format!("{}{}", prefix, "MaxResults"), &field_value);
        }
        if let Some(ref field_value) = obj.next_token {
            params.put(&format!("{}{}", prefix, "NextToken"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeImportImageTasksResult {
    /// <p>A list of zero or more import image tasks that are currently active or were completed or canceled in the previous 7 days.</p>
    pub import_image_tasks: Option<Vec<ImportImageTask>>,
    /// <p>The token to use to get the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: Option<String>,
}

#[allow(dead_code)]
struct DescribeImportImageTasksResultDeserializer;
impl DescribeImportImageTasksResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeImportImageTasksResult, XmlParseError> {
        deserialize_elements::<_, DescribeImportImageTasksResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "importImageTaskSet" => {
                        obj.import_image_tasks.get_or_insert(vec![]).extend(
                            ImportImageTaskListDeserializer::deserialize(
                                "importImageTaskSet",
                                stack,
                            )?,
                        );
                    }
                    "nextToken" => {
                        obj.next_token = Some(StringDeserializer::deserialize("nextToken", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeImportSnapshotTasksRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The filters.</p>
    pub filters: Option<Vec<Filter>>,
    /// <p>A list of import snapshot task IDs.</p>
    pub import_task_ids: Option<Vec<String>>,
    /// <p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>
    pub max_results: Option<i64>,
    /// <p>A token that indicates the next page of results.</p>
    pub next_token: Option<String>,
}

/// Serialize `DescribeImportSnapshotTasksRequest` contents to a `SignedRequest`.
struct DescribeImportSnapshotTasksRequestSerializer;
impl DescribeImportSnapshotTasksRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeImportSnapshotTasksRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filters"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.import_task_ids {
            ImportSnapshotTaskIdListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "ImportTaskId"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.max_results {
            params.put(&format!("{}{}", prefix, "MaxResults"), &field_value);
        }
        if let Some(ref field_value) = obj.next_token {
            params.put(&format!("{}{}", prefix, "NextToken"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeImportSnapshotTasksResult {
    /// <p>A list of zero or more import snapshot tasks that are currently active or were completed or canceled in the previous 7 days.</p>
    pub import_snapshot_tasks: Option<Vec<ImportSnapshotTask>>,
    /// <p>The token to use to get the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: Option<String>,
}

#[allow(dead_code)]
struct DescribeImportSnapshotTasksResultDeserializer;
impl DescribeImportSnapshotTasksResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeImportSnapshotTasksResult, XmlParseError> {
        deserialize_elements::<_, DescribeImportSnapshotTasksResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "importSnapshotTaskSet" => {
                        obj.import_snapshot_tasks.get_or_insert(vec![]).extend(
                            ImportSnapshotTaskListDeserializer::deserialize(
                                "importSnapshotTaskSet",
                                stack,
                            )?,
                        );
                    }
                    "nextToken" => {
                        obj.next_token = Some(StringDeserializer::deserialize("nextToken", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeInstanceAttributeRequest {
    /// <p>The instance attribute.</p> <p>Note: The <code>enaSupport</code> attribute is not supported at this time.</p>
    pub attribute: String,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p>The ID of the instance.</p>
    pub instance_id: String,
}

/// Serialize `DescribeInstanceAttributeRequest` contents to a `SignedRequest`.
struct DescribeInstanceAttributeRequestSerializer;
impl DescribeInstanceAttributeRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeInstanceAttributeRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "Attribute"), &obj.attribute);
        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "InstanceId"), &obj.instance_id);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeInstanceCreditSpecificationsRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p><p>The filters.</p> <ul> <li> <p> <code>instance-id</code> - The ID of the instance.</p> </li> </ul></p>
    pub filters: Option<Vec<Filter>>,
    /// <p>The instance IDs.</p> <p>Default: Describes all your instances.</p> <p>Constraints: Maximum 1000 explicitly specified instance IDs.</p>
    pub instance_ids: Option<Vec<String>>,
    /// <p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value. This value can be between 5 and 1000. You cannot specify this parameter and the instance IDs parameter in the same call.</p>
    pub max_results: Option<i64>,
    /// <p>The token to retrieve the next page of results.</p>
    pub next_token: Option<String>,
}

/// Serialize `DescribeInstanceCreditSpecificationsRequest` contents to a `SignedRequest`.
struct DescribeInstanceCreditSpecificationsRequestSerializer;
impl DescribeInstanceCreditSpecificationsRequestSerializer {
    fn serialize(
        params: &mut Params,
        name: &str,
        obj: &DescribeInstanceCreditSpecificationsRequest,
    ) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.instance_ids {
            InstanceIdStringListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "InstanceId"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.max_results {
            params.put(&format!("{}{}", prefix, "MaxResults"), &field_value);
        }
        if let Some(ref field_value) = obj.next_token {
            params.put(&format!("{}{}", prefix, "NextToken"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeInstanceCreditSpecificationsResult {
    /// <p>Information about the credit option for CPU usage of an instance.</p>
    pub instance_credit_specifications: Option<Vec<InstanceCreditSpecification>>,
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: Option<String>,
}

#[allow(dead_code)]
struct DescribeInstanceCreditSpecificationsResultDeserializer;
impl DescribeInstanceCreditSpecificationsResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeInstanceCreditSpecificationsResult, XmlParseError> {
        deserialize_elements::<_, DescribeInstanceCreditSpecificationsResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "instanceCreditSpecificationSet" => {
                        obj.instance_credit_specifications
                            .get_or_insert(vec![])
                            .extend(InstanceCreditSpecificationListDeserializer::deserialize(
                                "instanceCreditSpecificationSet",
                                stack,
                            )?);
                    }
                    "nextToken" => {
                        obj.next_token = Some(StringDeserializer::deserialize("nextToken", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeInstanceEventNotificationAttributesRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
}

/// Serialize `DescribeInstanceEventNotificationAttributesRequest` contents to a `SignedRequest`.
struct DescribeInstanceEventNotificationAttributesRequestSerializer;
impl DescribeInstanceEventNotificationAttributesRequestSerializer {
    fn serialize(
        params: &mut Params,
        name: &str,
        obj: &DescribeInstanceEventNotificationAttributesRequest,
    ) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeInstanceEventNotificationAttributesResult {
    /// <p>Information about the registered tag keys.</p>
    pub instance_tag_attribute: Option<InstanceTagNotificationAttribute>,
}

#[allow(dead_code)]
struct DescribeInstanceEventNotificationAttributesResultDeserializer;
impl DescribeInstanceEventNotificationAttributesResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeInstanceEventNotificationAttributesResult, XmlParseError> {
        deserialize_elements::<_, DescribeInstanceEventNotificationAttributesResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "instanceTagAttribute" => {
                        obj.instance_tag_attribute =
                            Some(InstanceTagNotificationAttributeDeserializer::deserialize(
                                "instanceTagAttribute",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeInstanceStatusRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p><p>The filters.</p> <ul> <li> <p> <code>availability-zone</code> - The Availability Zone of the instance.</p> </li> <li> <p> <code>event.code</code> - The code for the scheduled event (<code>instance-reboot</code> | <code>system-reboot</code> | <code>system-maintenance</code> | <code>instance-retirement</code> | <code>instance-stop</code>).</p> </li> <li> <p> <code>event.description</code> - A description of the event.</p> </li> <li> <p> <code>event.instance-event-id</code> - The ID of the event whose date and time you are modifying.</p> </li> <li> <p> <code>event.not-after</code> - The latest end time for the scheduled event (for example, <code>2014-09-15T17:15:20.000Z</code>).</p> </li> <li> <p> <code>event.not-before</code> - The earliest start time for the scheduled event (for example, <code>2014-09-15T17:15:20.000Z</code>).</p> </li> <li> <p> <code>event.not-before-deadline</code> - The deadline for starting the event (for example, <code>2014-09-15T17:15:20.000Z</code>).</p> </li> <li> <p> <code>instance-state-code</code> - The code for the instance state, as a 16-bit unsigned integer. The high byte is used for internal purposes and should be ignored. The low byte is set based on the state represented. The valid values are 0 (pending), 16 (running), 32 (shutting-down), 48 (terminated), 64 (stopping), and 80 (stopped).</p> </li> <li> <p> <code>instance-state-name</code> - The state of the instance (<code>pending</code> | <code>running</code> | <code>shutting-down</code> | <code>terminated</code> | <code>stopping</code> | <code>stopped</code>).</p> </li> <li> <p> <code>instance-status.reachability</code> - Filters on instance status where the name is <code>reachability</code> (<code>passed</code> | <code>failed</code> | <code>initializing</code> | <code>insufficient-data</code>).</p> </li> <li> <p> <code>instance-status.status</code> - The status of the instance (<code>ok</code> | <code>impaired</code> | <code>initializing</code> | <code>insufficient-data</code> | <code>not-applicable</code>).</p> </li> <li> <p> <code>system-status.reachability</code> - Filters on system status where the name is <code>reachability</code> (<code>passed</code> | <code>failed</code> | <code>initializing</code> | <code>insufficient-data</code>).</p> </li> <li> <p> <code>system-status.status</code> - The system status of the instance (<code>ok</code> | <code>impaired</code> | <code>initializing</code> | <code>insufficient-data</code> | <code>not-applicable</code>).</p> </li> </ul></p>
    pub filters: Option<Vec<Filter>>,
    /// <p>When <code>true</code>, includes the health status for all instances. When <code>false</code>, includes the health status for running instances only.</p> <p>Default: <code>false</code> </p>
    pub include_all_instances: Option<bool>,
    /// <p>The instance IDs.</p> <p>Default: Describes all your instances.</p> <p>Constraints: Maximum 100 explicitly specified instance IDs.</p>
    pub instance_ids: Option<Vec<String>>,
    /// <p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value. This value can be between 5 and 1000. You cannot specify this parameter and the instance IDs parameter in the same call.</p>
    pub max_results: Option<i64>,
    /// <p>The token to retrieve the next page of results.</p>
    pub next_token: Option<String>,
}

/// Serialize `DescribeInstanceStatusRequest` contents to a `SignedRequest`.
struct DescribeInstanceStatusRequestSerializer;
impl DescribeInstanceStatusRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeInstanceStatusRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.include_all_instances {
            params.put(
                &format!("{}{}", prefix, "IncludeAllInstances"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.instance_ids {
            InstanceIdStringListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "InstanceId"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.max_results {
            params.put(&format!("{}{}", prefix, "MaxResults"), &field_value);
        }
        if let Some(ref field_value) = obj.next_token {
            params.put(&format!("{}{}", prefix, "NextToken"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeInstanceStatusResult {
    /// <p>Information about the status of the instances.</p>
    pub instance_statuses: Option<Vec<InstanceStatus>>,
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: Option<String>,
}

#[allow(dead_code)]
struct DescribeInstanceStatusResultDeserializer;
impl DescribeInstanceStatusResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeInstanceStatusResult, XmlParseError> {
        deserialize_elements::<_, DescribeInstanceStatusResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "instanceStatusSet" => {
                        obj.instance_statuses.get_or_insert(vec![]).extend(
                            InstanceStatusListDeserializer::deserialize(
                                "instanceStatusSet",
                                stack,
                            )?,
                        );
                    }
                    "nextToken" => {
                        obj.next_token = Some(StringDeserializer::deserialize("nextToken", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeInstanceTypeOfferingsRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p><p>One or more filters. Filter names and values are case-sensitive.</p> <ul> <li> <p> <code>location</code> - This depends on the location type. For example, if the location type is <code>region</code> (default), the location is the Region code (for example, <code>us-east-2</code>.)</p> </li> <li> <p> <code>instance-type</code> - The instance type. For example, <code>c5.2xlarge</code>.</p> </li> </ul></p>
    pub filters: Option<Vec<Filter>>,
    /// <p>The location type.</p>
    pub location_type: Option<String>,
    /// <p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the next token value.</p>
    pub max_results: Option<i64>,
    /// <p>The token to retrieve the next page of results.</p>
    pub next_token: Option<String>,
}

/// Serialize `DescribeInstanceTypeOfferingsRequest` contents to a `SignedRequest`.
struct DescribeInstanceTypeOfferingsRequestSerializer;
impl DescribeInstanceTypeOfferingsRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeInstanceTypeOfferingsRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.location_type {
            params.put(&format!("{}{}", prefix, "LocationType"), &field_value);
        }
        if let Some(ref field_value) = obj.max_results {
            params.put(&format!("{}{}", prefix, "MaxResults"), &field_value);
        }
        if let Some(ref field_value) = obj.next_token {
            params.put(&format!("{}{}", prefix, "NextToken"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeInstanceTypeOfferingsResult {
    /// <p>The instance types offered.</p>
    pub instance_type_offerings: Option<Vec<InstanceTypeOffering>>,
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: Option<String>,
}

#[allow(dead_code)]
struct DescribeInstanceTypeOfferingsResultDeserializer;
impl DescribeInstanceTypeOfferingsResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeInstanceTypeOfferingsResult, XmlParseError> {
        deserialize_elements::<_, DescribeInstanceTypeOfferingsResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "instanceTypeOfferingSet" => {
                        obj.instance_type_offerings.get_or_insert(vec![]).extend(
                            InstanceTypeOfferingsListDeserializer::deserialize(
                                "instanceTypeOfferingSet",
                                stack,
                            )?,
                        );
                    }
                    "nextToken" => {
                        obj.next_token =
                            Some(NextTokenDeserializer::deserialize("nextToken", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeInstanceTypesRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p><p>One or more filters. Filter names and values are case-sensitive.</p> <ul> <li> <p> <code>auto-recovery-supported</code> - Indicates whether auto recovery is supported (<code>true</code> | <code>false</code>).</p> </li> <li> <p> <code>bare-metal</code> - Indicates whether it is a bare metal instance type (<code>true</code> | <code>false</code>).</p> </li> <li> <p> <code>burstable-performance-supported</code> - Indicates whether it is a burstable performance instance type (<code>true</code> | <code>false</code>).</p> </li> <li> <p> <code>current-generation</code> - Indicates whether this instance type is the latest generation instance type of an instance family (<code>true</code> | <code>false</code>).</p> </li> <li> <p> <code>ebs-info.ebs-optimized-info.baseline-bandwidth-in-mbps</code> - The baseline bandwidth performance for an EBS-optimized instance type, in Mbps.</p> </li> <li> <p> <code>ebs-info.ebs-optimized-info.baseline-iops</code> - The baseline input/output storage operations per second for an EBS-optimized instance type.</p> </li> <li> <p> <code>ebs-info.ebs-optimized-info.baseline-throughput-in-mbps</code> - The baseline throughput performance for an EBS-optimized instance type, in MB/s.</p> </li> <li> <p> <code>ebs-info.ebs-optimized-info.maximum-bandwidth-in-mbps</code> - The maximum bandwidth performance for an EBS-optimized instance type, in Mbps.</p> </li> <li> <p> <code>ebs-info.ebs-optimized-info.maximum-iops</code> - The maximum input/output storage operations per second for an EBS-optimized instance type.</p> </li> <li> <p> <code>ebs-info.ebs-optimized-info.maximum-throughput-in-mbps</code> - The maximum throughput performance for an EBS-optimized instance type, in MB/s.</p> </li> <li> <p> <code>ebs-info.ebs-optimized-support</code> - Indicates whether the instance type is EBS-optimized (<code>supported</code> | <code>unsupported</code> | <code>default</code>).</p> </li> <li> <p> <code>ebs-info.encryption-support</code> - Indicates whether EBS encryption is supported (<code>supported</code> | <code>unsupported</code>).</p> </li> <li> <p> <code>ebs-info.nvme-support</code> - Indicates whether non-volatile memory express (NVMe) is supported for EBS volumes (<code>required</code> | <code>supported</code> | <code>unsupported</code>).</p> </li> <li> <p> <code>free-tier-eligible</code> - Indicates whether the instance type is eligible to use in the free tier (<code>true</code> | <code>false</code>).</p> </li> <li> <p> <code>hibernation-supported</code> - Indicates whether On-Demand hibernation is supported (<code>true</code> | <code>false</code>).</p> </li> <li> <p> <code>hypervisor</code> - The hypervisor (<code>nitro</code> | <code>xen</code>).</p> </li> <li> <p> <code>instance-storage-info.disk.count</code> - The number of local disks.</p> </li> <li> <p> <code>instance-storage-info.disk.size-in-gb</code> - The storage size of each instance storage disk, in GB.</p> </li> <li> <p> <code>instance-storage-info.disk.type</code> - The storage technology for the local instance storage disks (<code>hdd</code> | <code>ssd</code>).</p> </li> <li> <p> <code>instance-storage-info.nvme-support</code> - Indicates whether non-volatile memory express (NVMe) is supported for instance store (<code>required</code> | <code>supported</code>) | <code>unsupported</code>).</p> </li> <li> <p> <code>instance-storage-info.total-size-in-gb</code> - The total amount of storage available from all local instance storage, in GB.</p> </li> <li> <p> <code>instance-storage-supported</code> - Indicates whether the instance type has local instance storage (<code>true</code> | <code>false</code>).</p> </li> <li> <p> <code>instance-type</code> - The instance type (for example <code>c5.2xlarge</code> or c5*).</p> </li> <li> <p> <code>memory-info.size-in-mib</code> - The memory size.</p> </li> <li> <p> <code>network-info.efa-info.maximum-efa-interfaces</code> - The maximum number of Elastic Fabric Adapters (EFAs) per instance.</p> </li> <li> <p> <code>network-info.efa-supported</code> - Indicates whether the instance type supports Elastic Fabric Adapter (EFA) (<code>true</code> | <code>false</code>).</p> </li> <li> <p> <code>network-info.ena-support</code> - Indicates whether Elastic Network Adapter (ENA) is supported or required (<code>required</code> | <code>supported</code> | <code>unsupported</code>).</p> </li> <li> <p> <code>network-info.ipv4-addresses-per-interface</code> - The maximum number of private IPv4 addresses per network interface.</p> </li> <li> <p> <code>network-info.ipv6-addresses-per-interface</code> - The maximum number of private IPv6 addresses per network interface.</p> </li> <li> <p> <code>network-info.ipv6-supported</code> - Indicates whether the instance type supports IPv6 (<code>true</code> | <code>false</code>).</p> </li> <li> <p> <code>network-info.maximum-network-interfaces</code> - The maximum number of network interfaces per instance.</p> </li> <li> <p> <code>network-info.network-performance</code> - The network performance (for example, &quot;25 Gigabit&quot;).</p> </li> <li> <p> <code>processor-info.supported-architecture</code> - The CPU architecture (<code>arm64</code> | <code>i386</code> | <code>x86_64</code>).</p> </li> <li> <p> <code>processor-info.sustained-clock-speed-in-ghz</code> - The CPU clock speed, in GHz.</p> </li> <li> <p> <code>supported-boot-mode</code> - The boot mode (<code>legacy-bios</code> | <code>uefi</code>).</p> </li> <li> <p> <code>supported-root-device-type</code> - The root device type (<code>ebs</code> | <code>instance-store</code>).</p> </li> <li> <p> <code>supported-usage-class</code> - The usage class (<code>on-demand</code> | <code>spot</code>).</p> </li> <li> <p> <code>supported-virtualization-type</code> - The virtualization type (<code>hvm</code> | <code>paravirtual</code>).</p> </li> <li> <p> <code>vcpu-info.default-cores</code> - The default number of cores for the instance type.</p> </li> <li> <p> <code>vcpu-info.default-threads-per-core</code> - The default number of threads per core for the instance type.</p> </li> <li> <p> <code>vcpu-info.default-vcpus</code> - The default number of vCPUs for the instance type.</p> </li> <li> <p> <code>vcpu-info.valid-cores</code> - The number of cores that can be configured for the instance type.</p> </li> <li> <p> <code>vcpu-info.valid-threads-per-core</code> - The number of threads per core that can be configured for the instance type. For example, &quot;1&quot; or &quot;1,2&quot;.</p> </li> </ul></p>
    pub filters: Option<Vec<Filter>>,
    /// <p>The instance types. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the <i>Amazon EC2 User Guide</i>.</p>
    pub instance_types: Option<Vec<String>>,
    /// <p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the next token value.</p>
    pub max_results: Option<i64>,
    /// <p>The token to retrieve the next page of results.</p>
    pub next_token: Option<String>,
}

/// Serialize `DescribeInstanceTypesRequest` contents to a `SignedRequest`.
struct DescribeInstanceTypesRequestSerializer;
impl DescribeInstanceTypesRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeInstanceTypesRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.instance_types {
            RequestInstanceTypeListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "InstanceType"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.max_results {
            params.put(&format!("{}{}", prefix, "MaxResults"), &field_value);
        }
        if let Some(ref field_value) = obj.next_token {
            params.put(&format!("{}{}", prefix, "NextToken"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeInstanceTypesResult {
    /// <p>The instance type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the <i>Amazon EC2 User Guide</i>.</p>
    pub instance_types: Option<Vec<InstanceTypeInfo>>,
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: Option<String>,
}

#[allow(dead_code)]
struct DescribeInstanceTypesResultDeserializer;
impl DescribeInstanceTypesResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeInstanceTypesResult, XmlParseError> {
        deserialize_elements::<_, DescribeInstanceTypesResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "instanceTypeSet" => {
                        obj.instance_types.get_or_insert(vec![]).extend(
                            InstanceTypeInfoListDeserializer::deserialize(
                                "instanceTypeSet",
                                stack,
                            )?,
                        );
                    }
                    "nextToken" => {
                        obj.next_token =
                            Some(NextTokenDeserializer::deserialize("nextToken", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeInstancesRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p><p>The filters.</p> <ul> <li> <p> <code>affinity</code> - The affinity setting for an instance running on a Dedicated Host (<code>default</code> | <code>host</code>).</p> </li> <li> <p> <code>architecture</code> - The instance architecture (<code>i386</code> | <code>x86_64</code> | <code>arm64</code>).</p> </li> <li> <p> <code>availability-zone</code> - The Availability Zone of the instance.</p> </li> <li> <p> <code>block-device-mapping.attach-time</code> - The attach time for an EBS volume mapped to the instance, for example, <code>2010-09-15T17:15:20.000Z</code>.</p> </li> <li> <p> <code>block-device-mapping.delete-on-termination</code> - A Boolean that indicates whether the EBS volume is deleted on instance termination.</p> </li> <li> <p> <code>block-device-mapping.device-name</code> - The device name specified in the block device mapping (for example, <code>/dev/sdh</code> or <code>xvdh</code>).</p> </li> <li> <p> <code>block-device-mapping.status</code> - The status for the EBS volume (<code>attaching</code> | <code>attached</code> | <code>detaching</code> | <code>detached</code>).</p> </li> <li> <p> <code>block-device-mapping.volume-id</code> - The volume ID of the EBS volume.</p> </li> <li> <p> <code>client-token</code> - The idempotency token you provided when you launched the instance.</p> </li> <li> <p> <code>dns-name</code> - The public DNS name of the instance.</p> </li> <li> <p> <code>group-id</code> - The ID of the security group for the instance. EC2-Classic only.</p> </li> <li> <p> <code>group-name</code> - The name of the security group for the instance. EC2-Classic only.</p> </li> <li> <p> <code>hibernation-options.configured</code> - A Boolean that indicates whether the instance is enabled for hibernation. A value of <code>true</code> means that the instance is enabled for hibernation. </p> </li> <li> <p> <code>host-id</code> - The ID of the Dedicated Host on which the instance is running, if applicable.</p> </li> <li> <p> <code>hypervisor</code> - The hypervisor type of the instance (<code>ovm</code> | <code>xen</code>). The value <code>xen</code> is used for both Xen and Nitro hypervisors.</p> </li> <li> <p> <code>iam-instance-profile.arn</code> - The instance profile associated with the instance. Specified as an ARN.</p> </li> <li> <p> <code>image-id</code> - The ID of the image used to launch the instance.</p> </li> <li> <p> <code>instance-id</code> - The ID of the instance.</p> </li> <li> <p> <code>instance-lifecycle</code> - Indicates whether this is a Spot Instance or a Scheduled Instance (<code>spot</code> | <code>scheduled</code>).</p> </li> <li> <p> <code>instance-state-code</code> - The state of the instance, as a 16-bit unsigned integer. The high byte is used for internal purposes and should be ignored. The low byte is set based on the state represented. The valid values are: 0 (pending), 16 (running), 32 (shutting-down), 48 (terminated), 64 (stopping), and 80 (stopped).</p> </li> <li> <p> <code>instance-state-name</code> - The state of the instance (<code>pending</code> | <code>running</code> | <code>shutting-down</code> | <code>terminated</code> | <code>stopping</code> | <code>stopped</code>).</p> </li> <li> <p> <code>instance-type</code> - The type of instance (for example, <code>t2.micro</code>).</p> </li> <li> <p> <code>instance.group-id</code> - The ID of the security group for the instance. </p> </li> <li> <p> <code>instance.group-name</code> - The name of the security group for the instance. </p> </li> <li> <p> <code>ip-address</code> - The public IPv4 address of the instance.</p> </li> <li> <p> <code>kernel-id</code> - The kernel ID.</p> </li> <li> <p> <code>key-name</code> - The name of the key pair used when the instance was launched.</p> </li> <li> <p> <code>launch-index</code> - When launching multiple instances, this is the index for the instance in the launch group (for example, 0, 1, 2, and so on). </p> </li> <li> <p> <code>launch-time</code> - The time when the instance was launched.</p> </li> <li> <p> <code>metadata-options.http-tokens</code> - The metadata request authorization state (<code>optional</code> | <code>required</code>)</p> </li> <li> <p> <code>metadata-options.http-put-response-hop-limit</code> - The http metadata request put response hop limit (integer, possible values <code>1</code> to <code>64</code>)</p> </li> <li> <p> <code>metadata-options.http-endpoint</code> - Enable or disable metadata access on http endpoint (<code>enabled</code> | <code>disabled</code>)</p> </li> <li> <p> <code>monitoring-state</code> - Indicates whether detailed monitoring is enabled (<code>disabled</code> | <code>enabled</code>).</p> </li> <li> <p> <code>network-interface.addresses.private-ip-address</code> - The private IPv4 address associated with the network interface.</p> </li> <li> <p> <code>network-interface.addresses.primary</code> - Specifies whether the IPv4 address of the network interface is the primary private IPv4 address.</p> </li> <li> <p> <code>network-interface.addresses.association.public-ip</code> - The ID of the association of an Elastic IP address (IPv4) with a network interface.</p> </li> <li> <p> <code>network-interface.addresses.association.ip-owner-id</code> - The owner ID of the private IPv4 address associated with the network interface.</p> </li> <li> <p> <code>network-interface.association.public-ip</code> - The address of the Elastic IP address (IPv4) bound to the network interface.</p> </li> <li> <p> <code>network-interface.association.ip-owner-id</code> - The owner of the Elastic IP address (IPv4) associated with the network interface.</p> </li> <li> <p> <code>network-interface.association.allocation-id</code> - The allocation ID returned when you allocated the Elastic IP address (IPv4) for your network interface.</p> </li> <li> <p> <code>network-interface.association.association-id</code> - The association ID returned when the network interface was associated with an IPv4 address.</p> </li> <li> <p> <code>network-interface.attachment.attachment-id</code> - The ID of the interface attachment.</p> </li> <li> <p> <code>network-interface.attachment.instance-id</code> - The ID of the instance to which the network interface is attached.</p> </li> <li> <p> <code>network-interface.attachment.instance-owner-id</code> - The owner ID of the instance to which the network interface is attached.</p> </li> <li> <p> <code>network-interface.attachment.device-index</code> - The device index to which the network interface is attached.</p> </li> <li> <p> <code>network-interface.attachment.status</code> - The status of the attachment (<code>attaching</code> | <code>attached</code> | <code>detaching</code> | <code>detached</code>).</p> </li> <li> <p> <code>network-interface.attachment.attach-time</code> - The time that the network interface was attached to an instance.</p> </li> <li> <p> <code>network-interface.attachment.delete-on-termination</code> - Specifies whether the attachment is deleted when an instance is terminated.</p> </li> <li> <p> <code>network-interface.availability-zone</code> - The Availability Zone for the network interface.</p> </li> <li> <p> <code>network-interface.description</code> - The description of the network interface.</p> </li> <li> <p> <code>network-interface.group-id</code> - The ID of a security group associated with the network interface.</p> </li> <li> <p> <code>network-interface.group-name</code> - The name of a security group associated with the network interface.</p> </li> <li> <p> <code>network-interface.ipv6-addresses.ipv6-address</code> - The IPv6 address associated with the network interface.</p> </li> <li> <p> <code>network-interface.mac-address</code> - The MAC address of the network interface.</p> </li> <li> <p> <code>network-interface.network-interface-id</code> - The ID of the network interface.</p> </li> <li> <p> <code>network-interface.owner-id</code> - The ID of the owner of the network interface.</p> </li> <li> <p> <code>network-interface.private-dns-name</code> - The private DNS name of the network interface.</p> </li> <li> <p> <code>network-interface.requester-id</code> - The requester ID for the network interface.</p> </li> <li> <p> <code>network-interface.requester-managed</code> - Indicates whether the network interface is being managed by AWS.</p> </li> <li> <p> <code>network-interface.status</code> - The status of the network interface (<code>available</code>) | <code>in-use</code>).</p> </li> <li> <p> <code>network-interface.source-dest-check</code> - Whether the network interface performs source/destination checking. A value of <code>true</code> means that checking is enabled, and <code>false</code> means that checking is disabled. The value must be <code>false</code> for the network interface to perform network address translation (NAT) in your VPC.</p> </li> <li> <p> <code>network-interface.subnet-id</code> - The ID of the subnet for the network interface.</p> </li> <li> <p> <code>network-interface.vpc-id</code> - The ID of the VPC for the network interface.</p> </li> <li> <p> <code>outpost-arn</code> - The Amazon Resource Name (ARN) of the Outpost.</p> </li> <li> <p> <code>owner-id</code> - The AWS account ID of the instance owner.</p> </li> <li> <p> <code>placement-group-name</code> - The name of the placement group for the instance.</p> </li> <li> <p> <code>placement-partition-number</code> - The partition in which the instance is located.</p> </li> <li> <p> <code>platform</code> - The platform. To list only Windows instances, use <code>windows</code>.</p> </li> <li> <p> <code>private-dns-name</code> - The private IPv4 DNS name of the instance.</p> </li> <li> <p> <code>private-ip-address</code> - The private IPv4 address of the instance.</p> </li> <li> <p> <code>product-code</code> - The product code associated with the AMI used to launch the instance.</p> </li> <li> <p> <code>product-code.type</code> - The type of product code (<code>devpay</code> | <code>marketplace</code>).</p> </li> <li> <p> <code>ramdisk-id</code> - The RAM disk ID.</p> </li> <li> <p> <code>reason</code> - The reason for the current state of the instance (for example, shows &quot;User Initiated [date]&quot; when you stop or terminate the instance). Similar to the state-reason-code filter.</p> </li> <li> <p> <code>requester-id</code> - The ID of the entity that launched the instance on your behalf (for example, AWS Management Console, Auto Scaling, and so on).</p> </li> <li> <p> <code>reservation-id</code> - The ID of the instance&#39;s reservation. A reservation ID is created any time you launch an instance. A reservation ID has a one-to-one relationship with an instance launch request, but can be associated with more than one instance if you launch multiple instances using the same launch request. For example, if you launch one instance, you get one reservation ID. If you launch ten instances using the same launch request, you also get one reservation ID.</p> </li> <li> <p> <code>root-device-name</code> - The device name of the root device volume (for example, <code>/dev/sda1</code>).</p> </li> <li> <p> <code>root-device-type</code> - The type of the root device volume (<code>ebs</code> | <code>instance-store</code>).</p> </li> <li> <p> <code>source-dest-check</code> - Indicates whether the instance performs source/destination checking. A value of <code>true</code> means that checking is enabled, and <code>false</code> means that checking is disabled. The value must be <code>false</code> for the instance to perform network address translation (NAT) in your VPC. </p> </li> <li> <p> <code>spot-instance-request-id</code> - The ID of the Spot Instance request.</p> </li> <li> <p> <code>state-reason-code</code> - The reason code for the state change.</p> </li> <li> <p> <code>state-reason-message</code> - A message that describes the state change.</p> </li> <li> <p> <code>subnet-id</code> - The ID of the subnet for the instance.</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources that have a tag with a specific key, regardless of the tag value.</p> </li> <li> <p> <code>tenancy</code> - The tenancy of an instance (<code>dedicated</code> | <code>default</code> | <code>host</code>).</p> </li> <li> <p> <code>virtualization-type</code> - The virtualization type of the instance (<code>paravirtual</code> | <code>hvm</code>).</p> </li> <li> <p> <code>vpc-id</code> - The ID of the VPC that the instance is running in.</p> </li> </ul></p>
    pub filters: Option<Vec<Filter>>,
    /// <p>The instance IDs.</p> <p>Default: Describes all your instances.</p>
    pub instance_ids: Option<Vec<String>>,
    /// <p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value. This value can be between 5 and 1000. You cannot specify this parameter and the instance IDs parameter in the same call.</p>
    pub max_results: Option<i64>,
    /// <p>The token to request the next page of results.</p>
    pub next_token: Option<String>,
}

/// Serialize `DescribeInstancesRequest` contents to a `SignedRequest`.
struct DescribeInstancesRequestSerializer;
impl DescribeInstancesRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeInstancesRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.filters {
            FilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Filter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.instance_ids {
            InstanceIdStringListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "InstanceId"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.max_results {
            params.put(&format!("{}{}", prefix, "MaxResults"), &field_value);
        }
        if let Some(ref field_value) = obj.next_token {
            params.put(&format!("{}{}", prefix, "NextToken"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeInstancesResult {
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: Option<String>,
    /// <p>Information about the reservations.</p>
    pub reservations: Option<Vec<Reservation>>,
}

#[allow(dead_code)]
struct DescribeInstancesResultDeserializer;
impl DescribeInstancesResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeInstancesResult, XmlParseError> {
        deserialize_elements::<_, DescribeInstancesResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "nextToken" => {
                        obj.next_token = Some(StringDeserializer::deserialize("nextToken", stack)?);
                    }
                    "reservationSet" => {
                        obj.reservations.get_or_insert(vec![]).extend(
                            ReservationListDeserializer::deserialize("reservationSet", stack)?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeInternetGatewaysRequest {
    /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    pub dry_run: Option<bool>,
    /// <p><p>One or more filters.</p> <ul> <li> <p> <code>attachment.state</code> - The current state of the attachment between the gateway and the VPC (<code>available</code>). Present only if a VPC is attached.</p> </li> <li> <p> <code>attachment.vpc-id</code> - The ID of an attached VPC.</p> </li> <li> <p> <code>internet-gateway-id</code> - The ID of the Internet gateway.</p> </li> <li> <p> <code>owner-id</code> - The ID of the AWS account that owns the internet gateway.</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> </ul></p>
    pub filters: Option<Vec<Filter>>,
    /// <p>One or more internet gateway IDs.</p> <p>Default: Describes all your internet gateways.</p>
    pub internet_gateway_ids: Option<Vec<String>>,
    /// <p>The maximum number of results to return with a single cal