// =================================================================
//
//                           * WARNING *
//
//                    This file is generated!
//
//  Changes made to this file will be overwritten. If changes are
//  required to the generated code, the service_crategen project
//  must be updated to generate the changes.
//
// =================================================================

use std::error::Error;
use std::fmt;

use async_trait::async_trait;
use rusoto_core::credential::ProvideAwsCredentials;
use rusoto_core::region;
use rusoto_core::request::{BufferedHttpResponse, DispatchSignedRequest};
use rusoto_core::{Client, RusotoError};

use rusoto_core::param::{Params, ServiceParams};
use rusoto_core::proto;
use rusoto_core::signature::SignedRequest;
#[allow(unused_imports)]
use serde::{Deserialize, Serialize};
use serde_json;
/// <p>The Amazon Chime account details. An AWS account can have multiple Amazon Chime accounts.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct Account {
    /// <p>The Amazon Chime account ID.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>The Amazon Chime account type. For more information about different account types, see <a href="https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html">Managing Your Amazon Chime Accounts</a> in the <i>Amazon Chime Administration Guide</i>.</p>
    #[serde(rename = "AccountType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub account_type: Option<String>,
    /// <p>The AWS account ID.</p>
    #[serde(rename = "AwsAccountId")]
    pub aws_account_id: String,
    /// <p>The Amazon Chime account creation timestamp, in ISO 8601 format.</p>
    #[serde(rename = "CreatedTimestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_timestamp: Option<f64>,
    /// <p>The default license for the Amazon Chime account.</p>
    #[serde(rename = "DefaultLicense")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub default_license: Option<String>,
    /// <p>The Amazon Chime account name.</p>
    #[serde(rename = "Name")]
    pub name: String,
    /// <p>The sign-in delegate groups associated with the account.</p>
    #[serde(rename = "SigninDelegateGroups")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub signin_delegate_groups: Option<Vec<SigninDelegateGroup>>,
    /// <p>Supported licenses for the Amazon Chime account.</p>
    #[serde(rename = "SupportedLicenses")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub supported_licenses: Option<Vec<String>>,
}

/// <p>Settings related to the Amazon Chime account. This includes settings that start or stop remote control of shared screens, or start or stop the dial-out option in the Amazon Chime web application. For more information about these settings, see <a href="https://docs.aws.amazon.com/chime/latest/ag/policies.html">Use the Policies Page</a> in the <i>Amazon Chime Administration Guide</i>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct AccountSettings {
    /// <p>Setting that stops or starts remote control of shared screens during meetings.</p>
    #[serde(rename = "DisableRemoteControl")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub disable_remote_control: Option<bool>,
    /// <p>Setting that allows meeting participants to choose the <b>Call me at a phone number</b> option. For more information, see <a href="https://docs.aws.amazon.com/chime/latest/ug/chime-join-meeting.html">Join a Meeting without the Amazon Chime App</a>.</p>
    #[serde(rename = "EnableDialOut")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub enable_dial_out: Option<bool>,
}

/// <p>The Alexa for Business metadata associated with an Amazon Chime user, used to integrate Alexa for Business with a device.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct AlexaForBusinessMetadata {
    /// <p>The ARN of the room resource.</p>
    #[serde(rename = "AlexaForBusinessRoomArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub alexa_for_business_room_arn: Option<String>,
    /// <p>Starts or stops Alexa for Business.</p>
    #[serde(rename = "IsAlexaForBusinessEnabled")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub is_alexa_for_business_enabled: Option<bool>,
}

/// <p>The details of an <code>AppInstance</code>, an instance of an Amazon Chime SDK messaging application.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct AppInstance {
    /// <p>The ARN of the messaging instance.</p>
    #[serde(rename = "AppInstanceArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub app_instance_arn: Option<String>,
    /// <p>The time at which an <code>AppInstance</code> was created. In epoch milliseconds.</p>
    #[serde(rename = "CreatedTimestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_timestamp: Option<f64>,
    /// <p>The time an <code>AppInstance</code> was last updated. In epoch milliseconds.</p>
    #[serde(rename = "LastUpdatedTimestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_updated_timestamp: Option<f64>,
    /// <p>The metadata of an <code>AppInstance</code>.</p>
    #[serde(rename = "Metadata")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metadata: Option<String>,
    /// <p>The name of an <code>AppInstance</code>.</p>
    #[serde(rename = "Name")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
}

/// <p>The details of an <code>AppInstanceAdmin</code>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct AppInstanceAdmin {
    /// <p>The <code>AppInstanceAdmin</code> data.</p>
    #[serde(rename = "Admin")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub admin: Option<Identity>,
    /// <p>The ARN of the <code>AppInstance</code> for which the user is an administrator.</p>
    #[serde(rename = "AppInstanceArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub app_instance_arn: Option<String>,
    /// <p>The time at which an administrator was created.</p>
    #[serde(rename = "CreatedTimestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_timestamp: Option<f64>,
}

/// <p>Summary of the details of an <code>AppInstanceAdmin</code>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct AppInstanceAdminSummary {
    /// <p>The details of the <code>AppInstanceAdmin</code>.</p>
    #[serde(rename = "Admin")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub admin: Option<Identity>,
}

/// <p>The details of the data-retention settings for an <code>AppInstance</code>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct AppInstanceRetentionSettings {
    /// <p>The length of time in days to retain the messages in a channel.</p>
    #[serde(rename = "ChannelRetentionSettings")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub channel_retention_settings: Option<ChannelRetentionSettings>,
}

/// <p>The details of the streaming configuration of an <code>AppInstance</code>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct AppInstanceStreamingConfiguration {
    /// <p>The type of data to be streamed.</p>
    #[serde(rename = "AppInstanceDataType")]
    pub app_instance_data_type: String,
    /// <p>The resource ARN.</p>
    #[serde(rename = "ResourceArn")]
    pub resource_arn: String,
}

/// <p>Summary of the data for an <code>AppInstance</code>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct AppInstanceSummary {
    /// <p>The <code>AppInstance</code> ARN.</p>
    #[serde(rename = "AppInstanceArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub app_instance_arn: Option<String>,
    /// <p>The metadata of the <code>AppInstance</code>.</p>
    #[serde(rename = "Metadata")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metadata: Option<String>,
    /// <p>The name of the <code>AppInstance</code>.</p>
    #[serde(rename = "Name")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
}

/// <p>The details of an <code>AppInstanceUser</code>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct AppInstanceUser {
    /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
    #[serde(rename = "AppInstanceUserArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub app_instance_user_arn: Option<String>,
    /// <p>The time at which the <code>AppInstanceUser</code> was created.</p>
    #[serde(rename = "CreatedTimestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_timestamp: Option<f64>,
    /// <p>The time at which the <code>AppInstanceUser</code> was last updated.</p>
    #[serde(rename = "LastUpdatedTimestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_updated_timestamp: Option<f64>,
    /// <p>The metadata of the <code>AppInstanceUser</code>.</p>
    #[serde(rename = "Metadata")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metadata: Option<String>,
    /// <p>The name of the <code>AppInstanceUser</code>.</p>
    #[serde(rename = "Name")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
}

/// <p>Summary of the membership details of an <code>AppInstanceUser</code>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct AppInstanceUserMembershipSummary {
    /// <p>The time at which a message was last read.</p>
    #[serde(rename = "ReadMarkerTimestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub read_marker_timestamp: Option<f64>,
    /// <p>The type of <code>ChannelMembership</code>.</p>
    #[serde(rename = "Type")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}

/// <p>Summary of the details of an <code>AppInstanceUser</code>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct AppInstanceUserSummary {
    /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
    #[serde(rename = "AppInstanceUserArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub app_instance_user_arn: Option<String>,
    /// <p>The metadata of the <code>AppInstanceUser</code>.</p>
    #[serde(rename = "Metadata")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metadata: Option<String>,
    /// <p>The name of an <code>AppInstanceUser</code>.</p>
    #[serde(rename = "Name")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AssociatePhoneNumberWithUserRequest {
    /// <p>The Amazon Chime account ID.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>The phone number, in E.164 format.</p>
    #[serde(rename = "E164PhoneNumber")]
    pub e164_phone_number: String,
    /// <p>The user ID.</p>
    #[serde(rename = "UserId")]
    pub user_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct AssociatePhoneNumberWithUserResponse {}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AssociatePhoneNumbersWithVoiceConnectorGroupRequest {
    /// <p>List of phone numbers, in E.164 format.</p>
    #[serde(rename = "E164PhoneNumbers")]
    pub e164_phone_numbers: Vec<String>,
    /// <p>If true, associates the provided phone numbers with the provided Amazon Chime Voice Connector Group and removes any previously existing associations. If false, does not associate any phone numbers that have previously existing associations.</p>
    #[serde(rename = "ForceAssociate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub force_associate: Option<bool>,
    /// <p>The Amazon Chime Voice Connector group ID.</p>
    #[serde(rename = "VoiceConnectorGroupId")]
    pub voice_connector_group_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct AssociatePhoneNumbersWithVoiceConnectorGroupResponse {
    /// <p>If the action fails for one or more of the phone numbers in the request, a list of the phone numbers is returned, along with error codes and error messages.</p>
    #[serde(rename = "PhoneNumberErrors")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub phone_number_errors: Option<Vec<PhoneNumberError>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AssociatePhoneNumbersWithVoiceConnectorRequest {
    /// <p>List of phone numbers, in E.164 format.</p>
    #[serde(rename = "E164PhoneNumbers")]
    pub e164_phone_numbers: Vec<String>,
    /// <p>If true, associates the provided phone numbers with the provided Amazon Chime Voice Connector and removes any previously existing associations. If false, does not associate any phone numbers that have previously existing associations.</p>
    #[serde(rename = "ForceAssociate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub force_associate: Option<bool>,
    /// <p>The Amazon Chime Voice Connector ID.</p>
    #[serde(rename = "VoiceConnectorId")]
    pub voice_connector_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct AssociatePhoneNumbersWithVoiceConnectorResponse {
    /// <p>If the action fails for one or more of the phone numbers in the request, a list of the phone numbers is returned, along with error codes and error messages.</p>
    #[serde(rename = "PhoneNumberErrors")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub phone_number_errors: Option<Vec<PhoneNumberError>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AssociateSigninDelegateGroupsWithAccountRequest {
    /// <p>The Amazon Chime account ID.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>The sign-in delegate groups.</p>
    #[serde(rename = "SigninDelegateGroups")]
    pub signin_delegate_groups: Vec<SigninDelegateGroup>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct AssociateSigninDelegateGroupsWithAccountResponse {}

/// <p> An Amazon Chime SDK meeting attendee. Includes a unique <code>AttendeeId</code> and <code>JoinToken</code> . The <code>JoinToken</code> allows a client to authenticate and join as the specified attendee. The <code>JoinToken</code> expires when the meeting ends or when <a>DeleteAttendee</a> is called. After that, the attendee is unable to join the meeting. </p> <p>We recommend securely transferring each <code>JoinToken</code> from your server application to the client so that no other client has access to the token except for the one authorized to represent the attendee.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct Attendee {
    /// <p>The Amazon Chime SDK attendee ID.</p>
    #[serde(rename = "AttendeeId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub attendee_id: Option<String>,
    /// <p>The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.</p>
    #[serde(rename = "ExternalUserId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub external_user_id: Option<String>,
    /// <p>The join token used by the Amazon Chime SDK attendee.</p>
    #[serde(rename = "JoinToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub join_token: Option<String>,
}

/// <p>The membership information, including member ARNs, the channel ARN, and membership types.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct BatchChannelMemberships {
    /// <p>The ARN of the channel to which you're adding users.</p>
    #[serde(rename = "ChannelArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub channel_arn: Option<String>,
    #[serde(rename = "InvitedBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub invited_by: Option<Identity>,
    /// <p>The users successfully added to the request.</p>
    #[serde(rename = "Members")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub members: Option<Vec<Identity>>,
    /// <p>The membership types set for the channel users.</p>
    #[serde(rename = "Type")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct BatchCreateAttendeeRequest {
    /// <p>The request containing the attendees to create.</p>
    #[serde(rename = "Attendees")]
    pub attendees: Vec<CreateAttendeeRequestItem>,
    /// <p>The Amazon Chime SDK meeting ID.</p>
    #[serde(rename = "MeetingId")]
    pub meeting_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct BatchCreateAttendeeResponse {
    /// <p>The attendee information, including attendees IDs and join tokens.</p>
    #[serde(rename = "Attendees")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub attendees: Option<Vec<Attendee>>,
    /// <p>If the action fails for one or more of the attendees in the request, a list of the attendees is returned, along with error codes and error messages.</p>
    #[serde(rename = "Errors")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub errors: Option<Vec<ChimeCreateAttendeeError>>,
}

/// <p>A list of failed member ARNs, error codes, and error messages.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ChimeBatchCreateChannelMembershipError {
    /// <p>The error code.</p>
    #[serde(rename = "ErrorCode")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub error_code: Option<String>,
    /// <p>The error message.</p>
    #[serde(rename = "ErrorMessage")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub error_message: Option<String>,
    /// <p>The ARN of the member that the service couldn't add.</p>
    #[serde(rename = "MemberArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub member_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct BatchCreateChannelMembershipRequest {
    /// <p>The ARN of the channel to which you're adding users.</p>
    #[serde(rename = "ChannelArn")]
    pub channel_arn: String,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    #[serde(rename = "ChimeBearer")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub chime_bearer: Option<String>,
    /// <p>The ARNs of the members you want to add to the channel.</p>
    #[serde(rename = "MemberArns")]
    pub member_arns: Vec<String>,
    /// <p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always returned as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are not returned. This is only supported by moderators.</p>
    #[serde(rename = "Type")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct BatchCreateChannelMembershipResponse {
    /// <p>The list of channel memberships in the response.</p>
    #[serde(rename = "BatchChannelMemberships")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub batch_channel_memberships: Option<BatchChannelMemberships>,
    /// <p>If the action fails for one or more of the memberships in the request, a list of the memberships is returned, along with error codes and error messages.</p>
    #[serde(rename = "Errors")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub errors: Option<Vec<ChimeBatchCreateChannelMembershipError>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct BatchCreateRoomMembershipRequest {
    /// <p>The Amazon Chime account ID.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>The list of membership items.</p>
    #[serde(rename = "MembershipItemList")]
    pub membership_item_list: Vec<MembershipItem>,
    /// <p>The room ID.</p>
    #[serde(rename = "RoomId")]
    pub room_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct BatchCreateRoomMembershipResponse {
    /// <p>If the action fails for one or more of the member IDs in the request, a list of the member IDs is returned, along with error codes and error messages.</p>
    #[serde(rename = "Errors")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub errors: Option<Vec<MemberError>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct BatchDeletePhoneNumberRequest {
    /// <p>List of phone number IDs.</p>
    #[serde(rename = "PhoneNumberIds")]
    pub phone_number_ids: Vec<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct BatchDeletePhoneNumberResponse {
    /// <p>If the action fails for one or more of the phone numbers in the request, a list of the phone numbers is returned, along with error codes and error messages.</p>
    #[serde(rename = "PhoneNumberErrors")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub phone_number_errors: Option<Vec<PhoneNumberError>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct BatchSuspendUserRequest {
    /// <p>The Amazon Chime account ID.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>The request containing the user IDs to suspend.</p>
    #[serde(rename = "UserIdList")]
    pub user_id_list: Vec<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct BatchSuspendUserResponse {
    /// <p>If the <a>BatchSuspendUser</a> action fails for one or more of the user IDs in the request, a list of the user IDs is returned, along with error codes and error messages.</p>
    #[serde(rename = "UserErrors")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub user_errors: Option<Vec<UserError>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct BatchUnsuspendUserRequest {
    /// <p>The Amazon Chime account ID.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>The request containing the user IDs to unsuspend.</p>
    #[serde(rename = "UserIdList")]
    pub user_id_list: Vec<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct BatchUnsuspendUserResponse {
    /// <p>If the <a>BatchUnsuspendUser</a> action fails for one or more of the user IDs in the request, a list of the user IDs is returned, along with error codes and error messages.</p>
    #[serde(rename = "UserErrors")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub user_errors: Option<Vec<UserError>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct BatchUpdatePhoneNumberRequest {
    /// <p>The request containing the phone number IDs and product types or calling names to update.</p>
    #[serde(rename = "UpdatePhoneNumberRequestItems")]
    pub update_phone_number_request_items: Vec<UpdatePhoneNumberRequestItem>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct BatchUpdatePhoneNumberResponse {
    /// <p>If the action fails for one or more of the phone numbers in the request, a list of the phone numbers is returned, along with error codes and error messages.</p>
    #[serde(rename = "PhoneNumberErrors")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub phone_number_errors: Option<Vec<PhoneNumberError>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct BatchUpdateUserRequest {
    /// <p>The Amazon Chime account ID.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>The request containing the user IDs and details to update.</p>
    #[serde(rename = "UpdateUserRequestItems")]
    pub update_user_request_items: Vec<UpdateUserRequestItem>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct BatchUpdateUserResponse {
    /// <p>If the <a>BatchUpdateUser</a> action fails for one or more of the user IDs in the request, a list of the user IDs is returned, along with error codes and error messages.</p>
    #[serde(rename = "UserErrors")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub user_errors: Option<Vec<UserError>>,
}

/// <p>A resource that allows Enterprise account administrators to configure an interface to receive events from Amazon Chime.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct Bot {
    /// <p>The bot email address.</p>
    #[serde(rename = "BotEmail")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub bot_email: Option<String>,
    /// <p>The bot ID.</p>
    #[serde(rename = "BotId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub bot_id: Option<String>,
    /// <p>The bot type.</p>
    #[serde(rename = "BotType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub bot_type: Option<String>,
    /// <p>The bot creation timestamp, in ISO 8601 format.</p>
    #[serde(rename = "CreatedTimestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_timestamp: Option<f64>,
    /// <p>When true, the bot is stopped from running in your account.</p>
    #[serde(rename = "Disabled")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub disabled: Option<bool>,
    /// <p>The bot display name.</p>
    #[serde(rename = "DisplayName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    /// <p>The security token used to authenticate Amazon Chime with the outgoing event endpoint.</p>
    #[serde(rename = "SecurityToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub security_token: Option<String>,
    /// <p>The updated bot timestamp, in ISO 8601 format.</p>
    #[serde(rename = "UpdatedTimestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub updated_timestamp: Option<f64>,
    /// <p>The unique ID for the bot user.</p>
    #[serde(rename = "UserId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub user_id: Option<String>,
}

/// <p>The Amazon Chime Business Calling settings for the administrator's AWS account. Includes any Amazon S3 buckets designated for storing call detail records.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct BusinessCallingSettings {
    /// <p>The Amazon S3 bucket designated for call detail record storage.</p>
    #[serde(rename = "CdrBucket")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub cdr_bucket: Option<String>,
}

/// <p>The details of a channel.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct Channel {
    /// <p>The ARN of the channel.</p>
    #[serde(rename = "ChannelArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub channel_arn: Option<String>,
    /// <p>The <code>AppInstanceUser</code> who created the channel.</p>
    #[serde(rename = "CreatedBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_by: Option<Identity>,
    /// <p>The time at which the <code>AppInstanceUser</code> created the channel.</p>
    #[serde(rename = "CreatedTimestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_timestamp: Option<f64>,
    /// <p>The time at which a member sent the last message in the channel.</p>
    #[serde(rename = "LastMessageTimestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_message_timestamp: Option<f64>,
    /// <p>The time at which a channel was last updated.</p>
    #[serde(rename = "LastUpdatedTimestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_updated_timestamp: Option<f64>,
    /// <p>The channel's metadata.</p>
    #[serde(rename = "Metadata")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metadata: Option<String>,
    /// <p>The mode of the channel.</p>
    #[serde(rename = "Mode")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub mode: Option<String>,
    /// <p>The name of the channel.</p>
    #[serde(rename = "Name")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    /// <p>The channel's privacy setting.</p>
    #[serde(rename = "Privacy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub privacy: Option<String>,
}

/// <p>The details of a channel ban.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ChannelBan {
    /// <p>The ARN of the channel from which a member is being banned.</p>
    #[serde(rename = "ChannelArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub channel_arn: Option<String>,
    /// <p>The <code>AppInstanceUser</code> who created the ban.</p>
    #[serde(rename = "CreatedBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_by: Option<Identity>,
    /// <p>The time at which the ban was created.</p>
    #[serde(rename = "CreatedTimestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_timestamp: Option<f64>,
    /// <p>The member being banned from the channel.</p>
    #[serde(rename = "Member")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub member: Option<Identity>,
}

/// <p>Summary of the details of a <code>ChannelBan</code>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ChannelBanSummary {
    /// <p>The member being banned from a channel.</p>
    #[serde(rename = "Member")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub member: Option<Identity>,
}

/// <p>The details of a channel member.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ChannelMembership {
    /// <p>The ARN of the member's channel.</p>
    #[serde(rename = "ChannelArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub channel_arn: Option<String>,
    /// <p>The time at which the channel membership was created.</p>
    #[serde(rename = "CreatedTimestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_timestamp: Option<f64>,
    /// <p>The identifier of the member who invited another member.</p>
    #[serde(rename = "InvitedBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub invited_by: Option<Identity>,
    /// <p>The time at which a channel membership was last updated.</p>
    #[serde(rename = "LastUpdatedTimestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_updated_timestamp: Option<f64>,
    /// <p>The data of the channel member.</p>
    #[serde(rename = "Member")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub member: Option<Identity>,
    /// <p>The membership type set for the channel member.</p>
    #[serde(rename = "Type")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}

/// <p>Summary of the channel membership details of an <code>AppInstanceUser</code>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ChannelMembershipForAppInstanceUserSummary {
    /// <p>Returns the channel membership data for an <code>AppInstance</code>.</p>
    #[serde(rename = "AppInstanceUserMembershipSummary")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub app_instance_user_membership_summary: Option<AppInstanceUserMembershipSummary>,
    #[serde(rename = "ChannelSummary")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub channel_summary: Option<ChannelSummary>,
}

/// <p>Summary of the details of a <code>ChannelMembership</code>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ChannelMembershipSummary {
    /// <p>A member's summary data.</p>
    #[serde(rename = "Member")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub member: Option<Identity>,
}

/// <p>The details of a message in a channel.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ChannelMessage {
    /// <p>The ARN of the channel.</p>
    #[serde(rename = "ChannelArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub channel_arn: Option<String>,
    /// <p>The message content.</p>
    #[serde(rename = "Content")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub content: Option<String>,
    /// <p>The time at which the message was created.</p>
    #[serde(rename = "CreatedTimestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_timestamp: Option<f64>,
    /// <p>The time at which a message was edited.</p>
    #[serde(rename = "LastEditedTimestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_edited_timestamp: Option<f64>,
    /// <p>The time at which a message was updated.</p>
    #[serde(rename = "LastUpdatedTimestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_updated_timestamp: Option<f64>,
    /// <p>The ID of a message.</p>
    #[serde(rename = "MessageId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub message_id: Option<String>,
    /// <p>The message metadata.</p>
    #[serde(rename = "Metadata")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metadata: Option<String>,
    /// <p>The persistence setting for a channel message.</p>
    #[serde(rename = "Persistence")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub persistence: Option<String>,
    /// <p>Hides the content of a message.</p>
    #[serde(rename = "Redacted")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub redacted: Option<bool>,
    /// <p>The message sender.</p>
    #[serde(rename = "Sender")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sender: Option<Identity>,
    /// <p>The message type.</p>
    #[serde(rename = "Type")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}

/// <p>Summary of the messages in a <code>Channel</code>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ChannelMessageSummary {
    /// <p>The content of the message.</p>
    #[serde(rename = "Content")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub content: Option<String>,
    /// <p>The time at which the message summary was created.</p>
    #[serde(rename = "CreatedTimestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_timestamp: Option<f64>,
    /// <p>The time at which a message was last edited.</p>
    #[serde(rename = "LastEditedTimestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_edited_timestamp: Option<f64>,
    /// <p>The time at which a message was last updated.</p>
    #[serde(rename = "LastUpdatedTimestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_updated_timestamp: Option<f64>,
    /// <p>The ID of the message.</p>
    #[serde(rename = "MessageId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub message_id: Option<String>,
    /// <p>The metadata of the message.</p>
    #[serde(rename = "Metadata")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metadata: Option<String>,
    /// <p>Indicates whether a message was redacted.</p>
    #[serde(rename = "Redacted")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub redacted: Option<bool>,
    /// <p>The message sender.</p>
    #[serde(rename = "Sender")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sender: Option<Identity>,
    /// <p>The type of message.</p>
    #[serde(rename = "Type")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}

/// <p>Summary of the details of a moderated channel.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ChannelModeratedByAppInstanceUserSummary {
    #[serde(rename = "ChannelSummary")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub channel_summary: Option<ChannelSummary>,
}

/// <p>The details of a channel moderator.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ChannelModerator {
    /// <p>The ARN of the moderator's channel.</p>
    #[serde(rename = "ChannelArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub channel_arn: Option<String>,
    /// <p>The <code>AppInstanceUser</code> who created the moderator.</p>
    #[serde(rename = "CreatedBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_by: Option<Identity>,
    /// <p>The time at which the moderator was created.</p>
    #[serde(rename = "CreatedTimestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_timestamp: Option<f64>,
    /// <p>The moderator's data.</p>
    #[serde(rename = "Moderator")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub moderator: Option<Identity>,
}

/// <p>Summary of the details of a <code>ChannelModerator</code>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ChannelModeratorSummary {
    /// <p>The data for a moderator.</p>
    #[serde(rename = "Moderator")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub moderator: Option<Identity>,
}

/// <p>The details of the retention settings for a channel.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ChannelRetentionSettings {
    /// <p>The time in days to retain the messages in a channel.</p>
    #[serde(rename = "RetentionDays")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub retention_days: Option<i64>,
}

/// <p>Summary of the details of a <code>Channel</code>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ChannelSummary {
    /// <p>The ARN of the channel.</p>
    #[serde(rename = "ChannelArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub channel_arn: Option<String>,
    /// <p>The time at which the last message in a channel was sent.</p>
    #[serde(rename = "LastMessageTimestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_message_timestamp: Option<f64>,
    /// <p>The metadata of the channel.</p>
    #[serde(rename = "Metadata")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metadata: Option<String>,
    /// <p>The mode of the channel.</p>
    #[serde(rename = "Mode")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub mode: Option<String>,
    /// <p>The name of the channel.</p>
    #[serde(rename = "Name")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    /// <p>The privacy setting of the channel.</p>
    #[serde(rename = "Privacy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub privacy: Option<String>,
}

/// <p>The retention settings that determine how long to retain conversation messages for an Amazon Chime Enterprise account.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ConversationRetentionSettings {
    /// <p>The number of days for which to retain conversation messages.</p>
    #[serde(rename = "RetentionDays")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub retention_days: Option<i64>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateAccountRequest {
    /// <p>The name of the Amazon Chime account.</p>
    #[serde(rename = "Name")]
    pub name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateAccountResponse {
    /// <p>The Amazon Chime account details.</p>
    #[serde(rename = "Account")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub account: Option<Account>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateAppInstanceAdminRequest {
    /// <p>The ARN of the administrator of the current <code>AppInstance</code>.</p>
    #[serde(rename = "AppInstanceAdminArn")]
    pub app_instance_admin_arn: String,
    /// <p>The ARN of the <code>AppInstance</code>.</p>
    #[serde(rename = "AppInstanceArn")]
    pub app_instance_arn: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateAppInstanceAdminResponse {
    /// <p>The name and ARN of the admin for the <code>AppInstance</code>.</p>
    #[serde(rename = "AppInstanceAdmin")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub app_instance_admin: Option<Identity>,
    /// <p>The ARN of the of the admin for the <code>AppInstance</code>.</p>
    #[serde(rename = "AppInstanceArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub app_instance_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateAppInstanceRequest {
    /// <p>The <code>ClientRequestToken</code> of the <code>AppInstance</code>.</p>
    #[serde(rename = "ClientRequestToken")]
    pub client_request_token: String,
    /// <p>The metadata of the <code>AppInstance</code>. Limited to a 1KB string in UTF-8.</p>
    #[serde(rename = "Metadata")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metadata: Option<String>,
    /// <p>The name of the <code>AppInstance</code>.</p>
    #[serde(rename = "Name")]
    pub name: String,
    /// <p>Tags assigned to the <code>AppInstanceUser</code>.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateAppInstanceResponse {
    /// <p>The Amazon Resource Number (ARN) of the <code>AppInstance</code>.</p>
    #[serde(rename = "AppInstanceArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub app_instance_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateAppInstanceUserRequest {
    /// <p>The ARN of the <code>AppInstance</code> request.</p>
    #[serde(rename = "AppInstanceArn")]
    pub app_instance_arn: String,
    /// <p>The user ID of the <code>AppInstance</code>.</p>
    #[serde(rename = "AppInstanceUserId")]
    pub app_instance_user_id: String,
    /// <p>The token assigned to the user requesting an <code>AppInstance</code>.</p>
    #[serde(rename = "ClientRequestToken")]
    pub client_request_token: String,
    /// <p>The request's metadata. Limited to a 1KB string in UTF-8.</p>
    #[serde(rename = "Metadata")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metadata: Option<String>,
    /// <p>The user's name.</p>
    #[serde(rename = "Name")]
    pub name: String,
    /// <p>Tags assigned to the <code>AppInstanceUser</code>.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateAppInstanceUserResponse {
    /// <p>The user's ARN.</p>
    #[serde(rename = "AppInstanceUserArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub app_instance_user_arn: Option<String>,
}

/// <p>The list of errors returned when errors are encountered during the BatchCreateAttendee and CreateAttendee actions. This includes external user IDs, error codes, and error messages.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ChimeCreateAttendeeError {
    /// <p>The error code.</p>
    #[serde(rename = "ErrorCode")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub error_code: Option<String>,
    /// <p>The error message.</p>
    #[serde(rename = "ErrorMessage")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub error_message: Option<String>,
    /// <p>The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.</p>
    #[serde(rename = "ExternalUserId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub external_user_id: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateAttendeeRequest {
    /// <p>The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.</p>
    #[serde(rename = "ExternalUserId")]
    pub external_user_id: String,
    /// <p>The Amazon Chime SDK meeting ID.</p>
    #[serde(rename = "MeetingId")]
    pub meeting_id: String,
    /// <p>The tag key-value pairs.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
}

/// <p>The Amazon Chime SDK attendee fields to create, used with the BatchCreateAttendee action.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateAttendeeRequestItem {
    /// <p>The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.</p>
    #[serde(rename = "ExternalUserId")]
    pub external_user_id: String,
    /// <p>The tag key-value pairs.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateAttendeeResponse {
    /// <p>The attendee information, including attendee ID and join token.</p>
    #[serde(rename = "Attendee")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub attendee: Option<Attendee>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateBotRequest {
    /// <p>The Amazon Chime account ID.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>The bot display name.</p>
    #[serde(rename = "DisplayName")]
    pub display_name: String,
    /// <p>The domain of the Amazon Chime Enterprise account.</p>
    #[serde(rename = "Domain")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub domain: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateBotResponse {
    /// <p>The bot details.</p>
    #[serde(rename = "Bot")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub bot: Option<Bot>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateChannelBanRequest {
    /// <p>The ARN of the ban request.</p>
    #[serde(rename = "ChannelArn")]
    pub channel_arn: String,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    #[serde(rename = "ChimeBearer")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub chime_bearer: Option<String>,
    /// <p>The ARN of the member being banned.</p>
    #[serde(rename = "MemberArn")]
    pub member_arn: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateChannelBanResponse {
    /// <p>The ARN of the response to the ban request.</p>
    #[serde(rename = "ChannelArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub channel_arn: Option<String>,
    /// <p>The <code>ChannelArn</code> and <code>BannedIdentity</code> of the member in the ban response.</p>
    #[serde(rename = "Member")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub member: Option<Identity>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateChannelMembershipRequest {
    /// <p>The ARN of the channel to which you're adding users.</p>
    #[serde(rename = "ChannelArn")]
    pub channel_arn: String,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    #[serde(rename = "ChimeBearer")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub chime_bearer: Option<String>,
    /// <p>The ARN of the member you want to add to the channel.</p>
    #[serde(rename = "MemberArn")]
    pub member_arn: String,
    /// <p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always returned as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are not returned. This is only supported by moderators.</p>
    #[serde(rename = "Type")]
    pub type_: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateChannelMembershipResponse {
    /// <p>The ARN of the channel.</p>
    #[serde(rename = "ChannelArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub channel_arn: Option<String>,
    /// <p>The ARN and metadata of the member being added.</p>
    #[serde(rename = "Member")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub member: Option<Identity>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateChannelModeratorRequest {
    /// <p>The ARN of the channel.</p>
    #[serde(rename = "ChannelArn")]
    pub channel_arn: String,
    /// <p>The ARN of the moderator.</p>
    #[serde(rename = "ChannelModeratorArn")]
    pub channel_moderator_arn: String,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    #[serde(rename = "ChimeBearer")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub chime_bearer: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateChannelModeratorResponse {
    /// <p>The ARN of the channel.</p>
    #[serde(rename = "ChannelArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub channel_arn: Option<String>,
    /// <p>The ARNs of the channel and the moderator.</p>
    #[serde(rename = "ChannelModerator")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub channel_moderator: Option<Identity>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateChannelRequest {
    /// <p>The ARN of the channel request.</p>
    #[serde(rename = "AppInstanceArn")]
    pub app_instance_arn: String,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    #[serde(rename = "ChimeBearer")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub chime_bearer: Option<String>,
    /// <p>The client token for the request. An <code>Idempotency</code> token.</p>
    #[serde(rename = "ClientRequestToken")]
    pub client_request_token: String,
    /// <p>The metadata of the creation request. Limited to 1KB and UTF-8.</p>
    #[serde(rename = "Metadata")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metadata: Option<String>,
    /// <p>The channel mode: <code>UNRESTRICTED</code> or <code>RESTRICTED</code>. Administrators, moderators, and channel members can add themselves and other members to unrestricted channels. Only administrators and moderators can add members to restricted channels.</p>
    #[serde(rename = "Mode")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub mode: Option<String>,
    /// <p>The name of the channel.</p>
    #[serde(rename = "Name")]
    pub name: String,
    /// <p>The channel's privacy level: <code>PUBLIC</code> or <code>PRIVATE</code>. Private channels aren't discoverable by users outside the channel. Public channels are discoverable by anyone in the <code>AppInstance</code>.</p>
    #[serde(rename = "Privacy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub privacy: Option<String>,
    /// <p>The tags for the creation request.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateChannelResponse {
    /// <p>The ARN of the channel.</p>
    #[serde(rename = "ChannelArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub channel_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateMeetingDialOutRequest {
    /// <p>Phone number used as the caller ID when the remote party receives a call.</p>
    #[serde(rename = "FromPhoneNumber")]
    pub from_phone_number: String,
    /// <p>Token used by the Amazon Chime SDK attendee. Call the <a href="https://docs.aws.amazon.com/chime/latest/APIReference/API_CreateAttendee.html">CreateAttendee</a> action to get a join token.</p>
    #[serde(rename = "JoinToken")]
    pub join_token: String,
    /// <p>The Amazon Chime SDK meeting ID.</p>
    #[serde(rename = "MeetingId")]
    pub meeting_id: String,
    /// <p>Phone number called when inviting someone to a meeting.</p>
    #[serde(rename = "ToPhoneNumber")]
    pub to_phone_number: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateMeetingDialOutResponse {
    /// <p>Unique ID that tracks API calls.</p>
    #[serde(rename = "TransactionId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub transaction_id: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateMeetingRequest {
    /// <p>The unique identifier for the client request. Use a different token for different meetings.</p>
    #[serde(rename = "ClientRequestToken")]
    pub client_request_token: String,
    /// <p>The external meeting ID.</p>
    #[serde(rename = "ExternalMeetingId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub external_meeting_id: Option<String>,
    /// <p> The Region in which to create the meeting. Default: <code>us-east-1</code>. </p> <p> Available values: <code>af-south-1</code> , <code>ap-northeast-1</code> , <code>ap-northeast-2</code> , <code>ap-south-1</code> , <code>ap-southeast-1</code> , <code>ap-southeast-2</code> , <code>ca-central-1</code> , <code>eu-central-1</code> , <code>eu-north-1</code> , <code>eu-south-1</code> , <code>eu-west-1</code> , <code>eu-west-2</code> , <code>eu-west-3</code> , <code>sa-east-1</code> , <code>us-east-1</code> , <code>us-east-2</code> , <code>us-west-1</code> , <code>us-west-2</code> . </p>
    #[serde(rename = "MediaRegion")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub media_region: Option<String>,
    /// <p>Reserved.</p>
    #[serde(rename = "MeetingHostId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub meeting_host_id: Option<String>,
    /// <p>The configuration for resource targets to receive notifications when meeting and attendee events occur.</p>
    #[serde(rename = "NotificationsConfiguration")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub notifications_configuration: Option<MeetingNotificationConfiguration>,
    /// <p>The tag key-value pairs.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateMeetingResponse {
    /// <p> The meeting information, including the meeting ID and <code>MediaPlacement</code> . </p>
    #[serde(rename = "Meeting")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub meeting: Option<Meeting>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateMeetingWithAttendeesRequest {
    /// <p>The request containing the attendees to create.</p>
    #[serde(rename = "Attendees")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub attendees: Option<Vec<CreateAttendeeRequestItem>>,
    /// <p>The unique identifier for the client request. Use a different token for different meetings.</p>
    #[serde(rename = "ClientRequestToken")]
    pub client_request_token: String,
    /// <p>The external meeting ID.</p>
    #[serde(rename = "ExternalMeetingId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub external_meeting_id: Option<String>,
    /// <p> The Region in which to create the meeting. Default: <code>us-east-1</code> . </p> <p> Available values: <code>af-south-1</code> , <code>ap-northeast-1</code> , <code>ap-northeast-2</code> , <code>ap-south-1</code> , <code>ap-southeast-1</code> , <code>ap-southeast-2</code> , <code>ca-central-1</code> , <code>eu-central-1</code> , <code>eu-north-1</code> , <code>eu-south-1</code> , <code>eu-west-1</code> , <code>eu-west-2</code> , <code>eu-west-3</code> , <code>sa-east-1</code> , <code>us-east-1</code> , <code>us-east-2</code> , <code>us-west-1</code> , <code>us-west-2</code> . </p>
    #[serde(rename = "MediaRegion")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub media_region: Option<String>,
    /// <p>Reserved.</p>
    #[serde(rename = "MeetingHostId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub meeting_host_id: Option<String>,
    #[serde(rename = "NotificationsConfiguration")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub notifications_configuration: Option<MeetingNotificationConfiguration>,
    /// <p>The tag key-value pairs.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateMeetingWithAttendeesResponse {
    /// <p>The attendee information, including attendees IDs and join tokens.</p>
    #[serde(rename = "Attendees")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub attendees: Option<Vec<Attendee>>,
    /// <p>If the action fails for one or more of the attendees in the request, a list of the attendees is returned, along with error codes and error messages.</p>
    #[serde(rename = "Errors")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub errors: Option<Vec<ChimeCreateAttendeeError>>,
    #[serde(rename = "Meeting")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub meeting: Option<Meeting>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreatePhoneNumberOrderRequest {
    /// <p>List of phone numbers, in E.164 format.</p>
    #[serde(rename = "E164PhoneNumbers")]
    pub e164_phone_numbers: Vec<String>,
    /// <p>The phone number product type.</p>
    #[serde(rename = "ProductType")]
    pub product_type: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreatePhoneNumberOrderResponse {
    /// <p>The phone number order details.</p>
    #[serde(rename = "PhoneNumberOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub phone_number_order: Option<PhoneNumberOrder>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateProxySessionRequest {
    /// <p>The proxy session capabilities.</p>
    #[serde(rename = "Capabilities")]
    pub capabilities: Vec<String>,
    /// <p>The number of minutes allowed for the proxy session.</p>
    #[serde(rename = "ExpiryMinutes")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub expiry_minutes: Option<i64>,
    /// <p>The preference for matching the country or area code of the proxy phone number with that of the first participant.</p>
    #[serde(rename = "GeoMatchLevel")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub geo_match_level: Option<String>,
    /// <p>The country and area code for the proxy phone number.</p>
    #[serde(rename = "GeoMatchParams")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub geo_match_params: Option<GeoMatchParams>,
    /// <p>The name of the proxy session.</p>
    #[serde(rename = "Name")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    /// <p>The preference for proxy phone number reuse, or stickiness, between the same participants across sessions.</p>
    #[serde(rename = "NumberSelectionBehavior")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub number_selection_behavior: Option<String>,
    /// <p>The participant phone numbers.</p>
    #[serde(rename = "ParticipantPhoneNumbers")]
    pub participant_phone_numbers: Vec<String>,
    /// <p>The Amazon Chime voice connector ID.</p>
    #[serde(rename = "VoiceConnectorId")]
    pub voice_connector_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateProxySessionResponse {
    /// <p>The proxy session details.</p>
    #[serde(rename = "ProxySession")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub proxy_session: Option<ProxySession>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateRoomMembershipRequest {
    /// <p>The Amazon Chime account ID.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>The Amazon Chime member ID (user ID or bot ID).</p>
    #[serde(rename = "MemberId")]
    pub member_id: String,
    /// <p>The role of the member.</p>
    #[serde(rename = "Role")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub role: Option<String>,
    /// <p>The room ID.</p>
    #[serde(rename = "RoomId")]
    pub room_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateRoomMembershipResponse {
    /// <p>The room membership details.</p>
    #[serde(rename = "RoomMembership")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub room_membership: Option<RoomMembership>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateRoomRequest {
    /// <p>The Amazon Chime account ID.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>The idempotency token for the request.</p>
    #[serde(rename = "ClientRequestToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub client_request_token: Option<String>,
    /// <p>The room name.</p>
    #[serde(rename = "Name")]
    pub name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateRoomResponse {
    /// <p>The room details.</p>
    #[serde(rename = "Room")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub room: Option<Room>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateSipMediaApplicationCallRequest {
    /// <p>The phone number that a user calls from. This is a phone number in your Amazon Chime phone number inventory.</p>
    #[serde(rename = "FromPhoneNumber")]
    pub from_phone_number: String,
    /// <p>The ID of the SIP media application.</p>
    #[serde(rename = "SipMediaApplicationId")]
    pub sip_media_application_id: String,
    /// <p>The phone number that the service should call.</p>
    #[serde(rename = "ToPhoneNumber")]
    pub to_phone_number: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateSipMediaApplicationCallResponse {
    /// <p>The actual call.</p>
    #[serde(rename = "SipMediaApplicationCall")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sip_media_application_call: Option<SipMediaApplicationCall>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateSipMediaApplicationRequest {
    /// <p>The AWS Region assigned to the SIP media application.</p>
    #[serde(rename = "AwsRegion")]
    pub aws_region: String,
    /// <p>List of endpoints (Lambda Amazon Resource Names) specified for the SIP media application. Currently, only one endpoint is supported.</p>
    #[serde(rename = "Endpoints")]
    pub endpoints: Vec<SipMediaApplicationEndpoint>,
    /// <p>The SIP media application name.</p>
    #[serde(rename = "Name")]
    pub name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateSipMediaApplicationResponse {
    /// <p>The SIP media application details.</p>
    #[serde(rename = "SipMediaApplication")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sip_media_application: Option<SipMediaApplication>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateSipRuleRequest {
    /// <p>Enables or disables a rule. You must disable rules before you can delete them.</p>
    #[serde(rename = "Disabled")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub disabled: Option<bool>,
    /// <p>The name of the SIP rule.</p>
    #[serde(rename = "Name")]
    pub name: String,
    /// <p>List of SIP media applications with priority and AWS Region. Only one SIP application per AWS Region can be used.</p>
    #[serde(rename = "TargetApplications")]
    pub target_applications: Vec<SipRuleTargetApplication>,
    /// <p>The type of trigger assigned to the SIP rule in <code>TriggerValue</code>, currently <code>RequestUriHostname</code> or <code>ToPhoneNumber</code>.</p>
    #[serde(rename = "TriggerType")]
    pub trigger_type: String,
    /// <p>If <code>TriggerType</code> is <code>RequestUriHostname</code>, the value can be the outbound host name of an Amazon Chime Voice Connector. If <code>TriggerType</code> is <code>ToPhoneNumber</code>, the value can be a customer-owned phone number in the E164 format. The <code>SipMediaApplication</code> specified in the <code>SipRule</code> is triggered if the request URI in an incoming SIP request matches the <code>RequestUriHostname</code>, or if the <code>To</code> header in the incoming SIP request matches the <code>ToPhoneNumber</code> value.</p>
    #[serde(rename = "TriggerValue")]
    pub trigger_value: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateSipRuleResponse {
    /// <p>Returns the SIP rule information, including the rule ID, triggers, and target applications.</p>
    #[serde(rename = "SipRule")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sip_rule: Option<SipRule>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateUserRequest {
    /// <p>The Amazon Chime account ID.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>The user's email address.</p>
    #[serde(rename = "Email")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub email: Option<String>,
    /// <p>The user type.</p>
    #[serde(rename = "UserType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub user_type: Option<String>,
    /// <p>The user name.</p>
    #[serde(rename = "Username")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub username: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateUserResponse {
    #[serde(rename = "User")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub user: Option<User>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateVoiceConnectorGroupRequest {
    /// <p>The name of the Amazon Chime Voice Connector group.</p>
    #[serde(rename = "Name")]
    pub name: String,
    /// <p>The Amazon Chime Voice Connectors to route inbound calls to.</p>
    #[serde(rename = "VoiceConnectorItems")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub voice_connector_items: Option<Vec<VoiceConnectorItem>>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateVoiceConnectorGroupResponse {
    /// <p>The Amazon Chime Voice Connector group details.</p>
    #[serde(rename = "VoiceConnectorGroup")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub voice_connector_group: Option<VoiceConnectorGroup>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateVoiceConnectorRequest {
    /// <p> The AWS Region in which the Amazon Chime Voice Connector is created. Default value: <code>us-east-1</code> . </p>
    #[serde(rename = "AwsRegion")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub aws_region: Option<String>,
    /// <p>The name of the Amazon Chime Voice Connector.</p>
    #[serde(rename = "Name")]
    pub name: String,
    /// <p>When enabled, requires encryption for the Amazon Chime Voice Connector.</p>
    #[serde(rename = "RequireEncryption")]
    pub require_encryption: bool,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateVoiceConnectorResponse {
    /// <p>The Amazon Chime Voice Connector details.</p>
    #[serde(rename = "VoiceConnector")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub voice_connector: Option<VoiceConnector>,
}

/// <p>The SIP credentials used to authenticate requests to your Amazon Chime Voice Connector.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct Credential {
    /// <p>The RFC2617 compliant password associated with the SIP credentials, in US-ASCII format.</p>
    #[serde(rename = "Password")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub password: Option<String>,
    /// <p>The RFC2617 compliant user name associated with the SIP credentials, in US-ASCII format.</p>
    #[serde(rename = "Username")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub username: Option<String>,
}

/// <p>The Dialed Number Identification Service (DNIS) emergency calling configuration details associated with an Amazon Chime Voice Connector's emergency calling configuration.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct DNISEmergencyCallingConfiguration {
    /// <p>The country from which emergency calls are allowed, in ISO 3166-1 alpha-2 format.</p>
    #[serde(rename = "CallingCountry")]
    pub calling_country: String,
    /// <p>The DNIS phone number to route emergency calls to, in E.164 format.</p>
    #[serde(rename = "EmergencyPhoneNumber")]
    pub emergency_phone_number: String,
    /// <p>The DNIS phone number to route test emergency calls to, in E.164 format.</p>
    #[serde(rename = "TestPhoneNumber")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub test_phone_number: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteAccountRequest {
    /// <p>The Amazon Chime account ID.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DeleteAccountResponse {}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteAppInstanceAdminRequest {
    /// <p>The ARN of the <code>AppInstance</code>'s administrator.</p>
    #[serde(rename = "AppInstanceAdminArn")]
    pub app_instance_admin_arn: String,
    /// <p>The ARN of the <code>AppInstance</code>.</p>
    #[serde(rename = "AppInstanceArn")]
    pub app_instance_arn: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteAppInstanceRequest {
    /// <p>The ARN of the <code>AppInstance</code>.</p>
    #[serde(rename = "AppInstanceArn")]
    pub app_instance_arn: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteAppInstanceStreamingConfigurationsRequest {
    /// <p>The ARN of the streaming configurations being deleted.</p>
    #[serde(rename = "AppInstanceArn")]
    pub app_instance_arn: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteAppInstanceUserRequest {
    /// <p>The ARN of the user request being deleted.</p>
    #[serde(rename = "AppInstanceUserArn")]
    pub app_instance_user_arn: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteAttendeeRequest {
    /// <p>The Amazon Chime SDK attendee ID.</p>
    #[serde(rename = "AttendeeId")]
    pub attendee_id: String,
    /// <p>The Amazon Chime SDK meeting ID.</p>
    #[serde(rename = "MeetingId")]
    pub meeting_id: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteChannelBanRequest {
    /// <p>The ARN of the channel from which the <code>AppInstanceUser</code> was banned.</p>
    #[serde(rename = "ChannelArn")]
    pub channel_arn: String,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    #[serde(rename = "ChimeBearer")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub chime_bearer: Option<String>,
    /// <p>The ARN of the <code>AppInstanceUser</code> that you want to reinstate.</p>
    #[serde(rename = "MemberArn")]
    pub member_arn: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteChannelMembershipRequest {
    /// <p>The ARN of the channel from which you want to remove the user.</p>
    #[serde(rename = "ChannelArn")]
    pub channel_arn: String,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    #[serde(rename = "ChimeBearer")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub chime_bearer: Option<String>,
    /// <p>The ARN of the member that you're removing from the channel.</p>
    #[serde(rename = "MemberArn")]
    pub member_arn: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteChannelMessageRequest {
    /// <p>The ARN of the channel.</p>
    #[serde(rename = "ChannelArn")]
    pub channel_arn: String,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    #[serde(rename = "ChimeBearer")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub chime_bearer: Option<String>,
    /// <p>The ID of the message being deleted.</p>
    #[serde(rename = "MessageId")]
    pub message_id: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteChannelModeratorRequest {
    /// <p>The ARN of the channel.</p>
    #[serde(rename = "ChannelArn")]
    pub channel_arn: String,
    /// <p>The ARN of the moderator being deleted.</p>
    #[serde(rename = "ChannelModeratorArn")]
    pub channel_moderator_arn: String,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    #[serde(rename = "ChimeBearer")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub chime_bearer: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteChannelRequest {
    /// <p>The ARN of the channel being deleted.</p>
    #[serde(rename = "ChannelArn")]
    pub channel_arn: String,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    #[serde(rename = "ChimeBearer")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub chime_bearer: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteEventsConfigurationRequest {
    /// <p>The Amazon Chime account ID.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>The bot ID.</p>
    #[serde(rename = "BotId")]
    pub bot_id: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteMeetingRequest {
    /// <p>The Amazon Chime SDK meeting ID.</p>
    #[serde(rename = "MeetingId")]
    pub meeting_id: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeletePhoneNumberRequest {
    /// <p>The phone number ID.</p>
    #[serde(rename = "PhoneNumberId")]
    pub phone_number_id: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteProxySessionRequest {
    /// <p>The proxy session ID.</p>
    #[serde(rename = "ProxySessionId")]
    pub proxy_session_id: String,
    /// <p>The Amazon Chime voice connector ID.</p>
    #[serde(rename = "VoiceConnectorId")]
    pub voice_connector_id: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteRoomMembershipRequest {
    /// <p>The Amazon Chime account ID.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>The member ID (user ID or bot ID).</p>
    #[serde(rename = "MemberId")]
    pub member_id: String,
    /// <p>The room ID.</p>
    #[serde(rename = "RoomId")]
    pub room_id: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteRoomRequest {
    /// <p>The Amazon Chime account ID.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>The chat room ID.</p>
    #[serde(rename = "RoomId")]
    pub room_id: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteSipMediaApplicationRequest {
    /// <p>The SIP media application ID.</p>
    #[serde(rename = "SipMediaApplicationId")]
    pub sip_media_application_id: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteSipRuleRequest {
    /// <p>The SIP rule ID.</p>
    #[serde(rename = "SipRuleId")]
    pub sip_rule_id: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteVoiceConnectorEmergencyCallingConfigurationRequest {
    /// <p>The Amazon Chime Voice Connector ID.</p>
    #[serde(rename = "VoiceConnectorId")]
    pub voice_connector_id: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteVoiceConnectorGroupRequest {
    /// <p>The Amazon Chime Voice Connector group ID.</p>
    #[serde(rename = "VoiceConnectorGroupId")]
    pub voice_connector_group_id: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteVoiceConnectorOriginationRequest {
    /// <p>The Amazon Chime Voice Connector ID.</p>
    #[serde(rename = "VoiceConnectorId")]
    pub voice_connector_id: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteVoiceConnectorProxyRequest {
    /// <p>The Amazon Chime Voice Connector ID.</p>
    #[serde(rename = "VoiceConnectorId")]
    pub voice_connector_id: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteVoiceConnectorRequest {
    /// <p>The Amazon Chime Voice Connector ID.</p>
    #[serde(rename = "VoiceConnectorId")]
    pub voice_connector_id: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteVoiceConnectorStreamingConfigurationRequest {
    /// <p>The Amazon Chime Voice Connector ID.</p>
    #[serde(rename = "VoiceConnectorId")]
    pub voice_connector_id: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteVoiceConnectorTerminationCredentialsRequest {
    /// <p>The RFC2617 compliant username associated with the SIP credentials, in US-ASCII format.</p>
    #[serde(rename = "Usernames")]
    pub usernames: Vec<String>,
    /// <p>The Amazon Chime Voice Connector ID.</p>
    #[serde(rename = "VoiceConnectorId")]
    pub voice_connector_id: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteVoiceConnectorTerminationRequest {
    /// <p>The Amazon Chime Voice Connector ID.</p>
    #[serde(rename = "VoiceConnectorId")]
    pub voice_connector_id: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeAppInstanceAdminRequest {
    /// <p>The ARN of the <code>AppInstanceAdmin</code>.</p>
    #[serde(rename = "AppInstanceAdminArn")]
    pub app_instance_admin_arn: String,
    /// <p>The ARN of the <code>AppInstance</code>.</p>
    #[serde(rename = "AppInstanceArn")]
    pub app_instance_arn: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeAppInstanceAdminResponse {
    /// <p>The ARN and name of the <code>AppInstanceUser</code>, the ARN of the <code>AppInstance</code>, and the created and last-updated timestamps. All timestamps use epoch milliseconds.</p>
    #[serde(rename = "AppInstanceAdmin")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub app_instance_admin: Option<AppInstanceAdmin>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeAppInstanceRequest {
    /// <p>The ARN of the <code>AppInstance</code>.</p>
    #[serde(rename = "AppInstanceArn")]
    pub app_instance_arn: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeAppInstanceResponse {
    /// <p>The ARN, metadata, created and last-updated timestamps, and the name of the <code>AppInstance</code>. All timestamps use epoch milliseconds.</p>
    #[serde(rename = "AppInstance")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub app_instance: Option<AppInstance>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeAppInstanceUserRequest {
    /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
    #[serde(rename = "AppInstanceUserArn")]
    pub app_instance_user_arn: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeAppInstanceUserResponse {
    /// <p>The name of the <code>AppInstanceUser</code>.</p>
    #[serde(rename = "AppInstanceUser")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub app_instance_user: Option<AppInstanceUser>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeChannelBanRequest {
    /// <p>The ARN of the channel from which the user is banned.</p>
    #[serde(rename = "ChannelArn")]
    pub channel_arn: String,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    #[serde(rename = "ChimeBearer")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub chime_bearer: Option<String>,
    /// <p>The ARN of the member being banned.</p>
    #[serde(rename = "MemberArn")]
    pub member_arn: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeChannelBanResponse {
    /// <p>The details of the ban.</p>
    #[serde(rename = "ChannelBan")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub channel_ban: Option<ChannelBan>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeChannelMembershipForAppInstanceUserRequest {
    /// <p>The ARN of the user in a channel.</p>
    #[serde(rename = "AppInstanceUserArn")]
    pub app_instance_user_arn: String,
    /// <p>The ARN of the channel to which the user belongs.</p>
    #[serde(rename = "ChannelArn")]
    pub channel_arn: String,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    #[serde(rename = "ChimeBearer")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub chime_bearer: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeChannelMembershipForAppInstanceUserResponse {
    /// <p>The channel to which a user belongs.</p>
    #[serde(rename = "ChannelMembership")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub channel_membership: Option<ChannelMembershipForAppInstanceUserSummary>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeChannelMembershipRequest {
    /// <p>The ARN of the channel.</p>
    #[serde(rename = "ChannelArn")]
    pub channel_arn: String,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    #[serde(rename = "ChimeBearer")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub chime_bearer: Option<String>,
    /// <p>The ARN of the member.</p>
    #[serde(rename = "MemberArn")]
    pub member_arn: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeChannelMembershipResponse {
    /// <p>The details of the membership.</p>
    #[serde(rename = "ChannelMembership")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub channel_membership: Option<ChannelMembership>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeChannelModeratedByAppInstanceUserRequest {
    /// <p>The ARN of the <code>AppInstanceUser</code> in the moderated channel.</p>
    #[serde(rename = "AppInstanceUserArn")]
    pub app_instance_user_arn: String,
    /// <p>The ARN of the moderated channel.</p>
    #[serde(rename = "ChannelArn")]
    pub channel_arn: String,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    #[serde(rename = "ChimeBearer")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub chime_bearer: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeChannelModeratedByAppInstanceUserResponse {
    /// <p>The moderated channel.</p>
    #[serde(rename = "Channel")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub channel: Option<ChannelModeratedByAppInstanceUserSummary>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeChannelModeratorRequest {
    /// <p>The ARN of the channel.</p>
    #[serde(rename = "ChannelArn")]
    pub channel_arn: String,
    /// <p>The ARN of the channel moderator.</p>
    #[serde(rename = "ChannelModeratorArn")]
    pub channel_moderator_arn: String,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    #[serde(rename = "ChimeBearer")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub chime_bearer: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeChannelModeratorResponse {
    /// <p>The details of the channel moderator.</p>
    #[serde(rename = "ChannelModerator")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub channel_moderator: Option<ChannelModerator>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeChannelRequest {
    /// <p>The ARN of the channel.</p>
    #[serde(rename = "ChannelArn")]
    pub channel_arn: String,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    #[serde(rename = "ChimeBearer")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub chime_bearer: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeChannelResponse {
    /// <p>The channel details.</p>
    #[serde(rename = "Channel")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub channel: Option<Channel>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DisassociatePhoneNumberFromUserRequest {
    /// <p>The Amazon Chime account ID.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>The user ID.</p>
    #[serde(rename = "UserId")]
    pub user_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DisassociatePhoneNumberFromUserResponse {}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DisassociatePhoneNumbersFromVoiceConnectorGroupRequest {
    /// <p>List of phone numbers, in E.164 format.</p>
    #[serde(rename = "E164PhoneNumbers")]
    pub e164_phone_numbers: Vec<String>,
    /// <p>The Amazon Chime Voice Connector group ID.</p>
    #[serde(rename = "VoiceConnectorGroupId")]
    pub voice_connector_group_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DisassociatePhoneNumbersFromVoiceConnectorGroupResponse {
    /// <p>If the action fails for one or more of the phone numbers in the request, a list of the phone numbers is returned, along with error codes and error messages.</p>
    #[serde(rename = "PhoneNumberErrors")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub phone_number_errors: Option<Vec<PhoneNumberError>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DisassociatePhoneNumbersFromVoiceConnectorRequest {
    /// <p>List of phone numbers, in E.164 format.</p>
    #[serde(rename = "E164PhoneNumbers")]
    pub e164_phone_numbers: Vec<String>,
    /// <p>The Amazon Chime Voice Connector ID.</p>
    #[serde(rename = "VoiceConnectorId")]
    pub voice_connector_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DisassociatePhoneNumbersFromVoiceConnectorResponse {
    /// <p>If the action fails for one or more of the phone numbers in the request, a list of the phone numbers is returned, along with error codes and error messages.</p>
    #[serde(rename = "PhoneNumberErrors")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub phone_number_errors: Option<Vec<PhoneNumberError>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DisassociateSigninDelegateGroupsFromAccountRequest {
    /// <p>The Amazon Chime account ID.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>The sign-in delegate group names.</p>
    #[serde(rename = "GroupNames")]
    pub group_names: Vec<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DisassociateSigninDelegateGroupsFromAccountResponse {}

/// <p>The emergency calling configuration details associated with an Amazon Chime Voice Connector.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct EmergencyCallingConfiguration {
    /// <p>The Dialed Number Identification Service (DNIS) emergency calling configuration details.</p>
    #[serde(rename = "DNIS")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub dnis: Option<Vec<DNISEmergencyCallingConfiguration>>,
}

/// <p>The configuration that allows a bot to receive outgoing events. Can be either an HTTPS endpoint or a Lambda function ARN.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct EventsConfiguration {
    /// <p>The bot ID.</p>
    #[serde(rename = "BotId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub bot_id: Option<String>,
    /// <p>Lambda function ARN that allows a bot to receive outgoing events.</p>
    #[serde(rename = "LambdaFunctionArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub lambda_function_arn: Option<String>,
    /// <p>HTTPS endpoint that allows a bot to receive outgoing events.</p>
    #[serde(rename = "OutboundEventsHTTPSEndpoint")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub outbound_events_https_endpoint: Option<String>,
}

/// <p>The country and area code for a proxy phone number in a proxy phone session.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct GeoMatchParams {
    /// <p>The area code.</p>
    #[serde(rename = "AreaCode")]
    pub area_code: String,
    /// <p>The country.</p>
    #[serde(rename = "Country")]
    pub country: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetAccountRequest {
    /// <p>The Amazon Chime account ID.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetAccountResponse {
    /// <p>The Amazon Chime account details.</p>
    #[serde(rename = "Account")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub account: Option<Account>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetAccountSettingsRequest {
    /// <p>The Amazon Chime account ID.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetAccountSettingsResponse {
    /// <p>The Amazon Chime account settings.</p>
    #[serde(rename = "AccountSettings")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub account_settings: Option<AccountSettings>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetAppInstanceRetentionSettingsRequest {
    /// <p>The ARN of the <code>AppInstance</code>.</p>
    #[serde(rename = "AppInstanceArn")]
    pub app_instance_arn: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetAppInstanceRetentionSettingsResponse {
    /// <p>The retention settings for the <code>AppInstance</code>.</p>
    #[serde(rename = "AppInstanceRetentionSettings")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub app_instance_retention_settings: Option<AppInstanceRetentionSettings>,
    /// <p>The timestamp representing the time at which the specified items are retained, in Epoch Seconds.</p>
    #[serde(rename = "InitiateDeletionTimestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub initiate_deletion_timestamp: Option<f64>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetAppInstanceStreamingConfigurationsRequest {
    /// <p>The ARN of the <code>AppInstance</code>.</p>
    #[serde(rename = "AppInstanceArn")]
    pub app_instance_arn: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetAppInstanceStreamingConfigurationsResponse {
    /// <p>The streaming settings.</p>
    #[serde(rename = "AppInstanceStreamingConfigurations")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub app_instance_streaming_configurations: Option<Vec<AppInstanceStreamingConfiguration>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetAttendeeRequest {
    /// <p>The Amazon Chime SDK attendee ID.</p>
    #[serde(rename = "AttendeeId")]
    pub attendee_id: String,
    /// <p>The Amazon Chime SDK meeting ID.</p>
    #[serde(rename = "MeetingId")]
    pub meeting_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetAttendeeResponse {
    /// <p>The Amazon Chime SDK attendee information.</p>
    #[serde(rename = "Attendee")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub attendee: Option<Attendee>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetBotRequest {
    /// <p>The Amazon Chime account ID.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>The bot ID.</p>
    #[serde(rename = "BotId")]
    pub bot_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetBotResponse {
    /// <p>The chat bot details.</p>
    #[serde(rename = "Bot")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub bot: Option<Bot>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetChannelMessageRequest {
    /// <p>The ARN of the channel.</p>
    #[serde(rename = "ChannelArn")]
    pub channel_arn: String,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    #[serde(rename = "ChimeBearer")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub chime_bearer: Option<String>,
    /// <p>The ID of the message.</p>
    #[serde(rename = "MessageId")]
    pub message_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetChannelMessageResponse {
    /// <p>The details of and content in the message.</p>
    #[serde(rename = "ChannelMessage")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub channel_message: Option<ChannelMessage>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetEventsConfigurationRequest {
    /// <p>The Amazon Chime account ID.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>The bot ID.</p>
    #[serde(rename = "BotId")]
    pub bot_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetEventsConfigurationResponse {
    /// <p>The events configuration details.</p>
    #[serde(rename = "EventsConfiguration")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub events_configuration: Option<EventsConfiguration>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetGlobalSettingsResponse {
    /// <p>The Amazon Chime Business Calling settings.</p>
    #[serde(rename = "BusinessCalling")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub business_calling: Option<BusinessCallingSettings>,
    /// <p>The Amazon Chime Voice Connector settings.</p>
    #[serde(rename = "VoiceConnector")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub voice_connector: Option<VoiceConnectorSettings>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetMeetingRequest {
    /// <p>The Amazon Chime SDK meeting ID.</p>
    #[serde(rename = "MeetingId")]
    pub meeting_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetMeetingResponse {
    /// <p>The Amazon Chime SDK meeting information.</p>
    #[serde(rename = "Meeting")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub meeting: Option<Meeting>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetMessagingSessionEndpointRequest {}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetMessagingSessionEndpointResponse {
    /// <p>The endpoint returned in the response.</p>
    #[serde(rename = "Endpoint")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub endpoint: Option<MessagingSessionEndpoint>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetPhoneNumberOrderRequest {
    /// <p>The ID for the phone number order.</p>
    #[serde(rename = "PhoneNumberOrderId")]
    pub phone_number_order_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetPhoneNumberOrderResponse {
    /// <p>The phone number order details.</p>
    #[serde(rename = "PhoneNumberOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub phone_number_order: Option<PhoneNumberOrder>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetPhoneNumberRequest {
    /// <p>The phone number ID.</p>
    #[serde(rename = "PhoneNumberId")]
    pub phone_number_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetPhoneNumberResponse {
    /// <p>The phone number details.</p>
    #[serde(rename = "PhoneNumber")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub phone_number: Option<PhoneNumber>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetPhoneNumberSettingsResponse {
    /// <p>The default outbound calling name for the account.</p>
    #[serde(rename = "CallingName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub calling_name: Option<String>,
    /// <p>The updated outbound calling name timestamp, in ISO 8601 format.</p>
    #[serde(rename = "CallingNameUpdatedTimestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub calling_name_updated_timestamp: Option<f64>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetProxySessionRequest {
    /// <p>The proxy session ID.</p>
    #[serde(rename = "ProxySessionId")]
    pub proxy_session_id: String,
    /// <p>The Amazon Chime voice connector ID.</p>
    #[serde(rename = "VoiceConnectorId")]
    pub voice_connector_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetProxySessionResponse {
    /// <p>The proxy session details.</p>
    #[serde(rename = "ProxySession")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub proxy_session: Option<ProxySession>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetRetentionSettingsRequest {
    /// <p>The Amazon Chime account ID.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetRetentionSettingsResponse {
    /// <p>The timestamp representing the time at which the specified items are permanently deleted, in ISO 8601 format.</p>
    #[serde(rename = "InitiateDeletionTimestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub initiate_deletion_timestamp: Option<f64>,
    /// <p>The retention settings.</p>
    #[serde(rename = "RetentionSettings")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub retention_settings: Option<RetentionSettings>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetRoomRequest {
    /// <p>The Amazon Chime account ID.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>The room ID.</p>
    #[serde(rename = "RoomId")]
    pub room_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetRoomResponse {
    /// <p>The room details.</p>
    #[serde(rename = "Room")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub room: Option<Room>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetSipMediaApplicationLoggingConfigurationRequest {
    /// <p>The SIP media application ID.</p>
    #[serde(rename = "SipMediaApplicationId")]
    pub sip_media_application_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetSipMediaApplicationLoggingConfigurationResponse {
    /// <p>The actual logging configuration.</p>
    #[serde(rename = "SipMediaApplicationLoggingConfiguration")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sip_media_application_logging_configuration:
        Option<SipMediaApplicationLoggingConfiguration>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetSipMediaApplicationRequest {
    /// <p>The SIP media application ID.</p>
    #[serde(rename = "SipMediaApplicationId")]
    pub sip_media_application_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetSipMediaApplicationResponse {
    /// <p>The SIP media application details.</p>
    #[serde(rename = "SipMediaApplication")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sip_media_application: Option<SipMediaApplication>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetSipRuleRequest {
    /// <p>The SIP rule ID.</p>
    #[serde(rename = "SipRuleId")]
    pub sip_rule_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetSipRuleResponse {
    /// <p>The SIP rule details.</p>
    #[serde(rename = "SipRule")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sip_rule: Option<SipRule>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetUserRequest {
    /// <p>The Amazon Chime account ID.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>The user ID.</p>
    #[serde(rename = "UserId")]
    pub user_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetUserResponse {
    /// <p>The user details.</p>
    #[serde(rename = "User")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub user: Option<User>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetUserSettingsRequest {
    /// <p>The Amazon Chime account ID.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>The user ID.</p>
    #[serde(rename = "UserId")]
    pub user_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetUserSettingsResponse {
    /// <p>The user settings.</p>
    #[serde(rename = "UserSettings")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub user_settings: Option<UserSettings>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetVoiceConnectorEmergencyCallingConfigurationRequest {
    /// <p>The Amazon Chime Voice Connector ID.</p>
    #[serde(rename = "VoiceConnectorId")]
    pub voice_connector_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetVoiceConnectorEmergencyCallingConfigurationResponse {
    /// <p>The emergency calling configuration details.</p>
    #[serde(rename = "EmergencyCallingConfiguration")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub emergency_calling_configuration: Option<EmergencyCallingConfiguration>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetVoiceConnectorGroupRequest {
    /// <p>The Amazon Chime Voice Connector group ID.</p>
    #[serde(rename = "VoiceConnectorGroupId")]
    pub voice_connector_group_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetVoiceConnectorGroupResponse {
    /// <p>The Amazon Chime Voice Connector group details.</p>
    #[serde(rename = "VoiceConnectorGroup")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub voice_connector_group: Option<VoiceConnectorGroup>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetVoiceConnectorLoggingConfigurationRequest {
    /// <p>The Amazon Chime Voice Connector ID.</p>
    #[serde(rename = "VoiceConnectorId")]
    pub voice_connector_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetVoiceConnectorLoggingConfigurationResponse {
    /// <p>The logging configuration details.</p>
    #[serde(rename = "LoggingConfiguration")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub logging_configuration: Option<LoggingConfiguration>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetVoiceConnectorOriginationRequest {
    /// <p>The Amazon Chime Voice Connector ID.</p>
    #[serde(rename = "VoiceConnectorId")]
    pub voice_connector_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetVoiceConnectorOriginationResponse {
    /// <p>The origination setting details.</p>
    #[serde(rename = "Origination")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub origination: Option<Origination>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetVoiceConnectorProxyRequest {
    /// <p>The Amazon Chime voice connector ID.</p>
    #[serde(rename = "VoiceConnectorId")]
    pub voice_connector_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetVoiceConnectorProxyResponse {
    /// <p>The proxy configuration details.</p>
    #[serde(rename = "Proxy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub proxy: Option<Proxy>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetVoiceConnectorRequest {
    /// <p>The Amazon Chime Voice Connector ID.</p>
    #[serde(rename = "VoiceConnectorId")]
    pub voice_connector_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetVoiceConnectorResponse {
    /// <p>The Amazon Chime Voice Connector details.</p>
    #[serde(rename = "VoiceConnector")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub voice_connector: Option<VoiceConnector>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetVoiceConnectorStreamingConfigurationRequest {
    /// <p>The Amazon Chime Voice Connector ID.</p>
    #[serde(rename = "VoiceConnectorId")]
    pub voice_connector_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetVoiceConnectorStreamingConfigurationResponse {
    /// <p>The streaming configuration details.</p>
    #[serde(rename = "StreamingConfiguration")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub streaming_configuration: Option<StreamingConfiguration>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetVoiceConnectorTerminationHealthRequest {
    /// <p>The Amazon Chime Voice Connector ID.</p>
    #[serde(rename = "VoiceConnectorId")]
    pub voice_connector_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetVoiceConnectorTerminationHealthResponse {
    /// <p>The termination health details.</p>
    #[serde(rename = "TerminationHealth")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub termination_health: Option<TerminationHealth>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetVoiceConnectorTerminationRequest {
    /// <p>The Amazon Chime Voice Connector ID.</p>
    #[serde(rename = "VoiceConnectorId")]
    pub voice_connector_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetVoiceConnectorTerminationResponse {
    /// <p>The termination setting details.</p>
    #[serde(rename = "Termination")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub termination: Option<Termination>,
}

/// <p>The details of a user.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct Identity {
    /// <p>The ARN in an Identity.</p>
    #[serde(rename = "Arn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub arn: Option<String>,
    /// <p>The name in an Identity.</p>
    #[serde(rename = "Name")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
}

/// <p>Invitation object returned after emailing users to invite them to join the Amazon Chime <code>Team</code> account.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct Invite {
    /// <p>The email address to which the invite is sent.</p>
    #[serde(rename = "EmailAddress")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub email_address: Option<String>,
    /// <p>The status of the invite email.</p>
    #[serde(rename = "EmailStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub email_status: Option<String>,
    /// <p>The invite ID.</p>
    #[serde(rename = "InviteId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub invite_id: Option<String>,
    /// <p>The status of the invite.</p>
    #[serde(rename = "Status")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct InviteUsersRequest {
    /// <p>The Amazon Chime account ID.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>The user email addresses to which to send the email invitation.</p>
    #[serde(rename = "UserEmailList")]
    pub user_email_list: Vec<String>,
    /// <p>The user type.</p>
    #[serde(rename = "UserType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub user_type: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct InviteUsersResponse {
    /// <p>The email invitation details.</p>
    #[serde(rename = "Invites")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub invites: Option<Vec<Invite>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListAccountsRequest {
    /// <p>The maximum number of results to return in a single call. Defaults to 100.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>Amazon Chime account name prefix with which to filter results.</p>
    #[serde(rename = "Name")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    /// <p>The token to use to retrieve the next page of results.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>User email address with which to filter results.</p>
    #[serde(rename = "UserEmail")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub user_email: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListAccountsResponse {
    /// <p>List of Amazon Chime accounts and account details.</p>
    #[serde(rename = "Accounts")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub accounts: Option<Vec<Account>>,
    /// <p>The token to use to retrieve the next page of results.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListAppInstanceAdminsRequest {
    /// <p>The ARN of the <code>AppInstance</code>.</p>
    #[serde(rename = "AppInstanceArn")]
    pub app_instance_arn: String,
    /// <p>The maximum number of administrators that you want to return.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>The token returned from previous API requests until the number of administrators is reached.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListAppInstanceAdminsResponse {
    /// <p>The information for each administrator.</p>
    #[serde(rename = "AppInstanceAdmins")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub app_instance_admins: Option<Vec<AppInstanceAdminSummary>>,
    /// <p>The ARN of the <code>AppInstance</code>.</p>
    #[serde(rename = "AppInstanceArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub app_instance_arn: Option<String>,
    /// <p>The token returned from previous API requests until the number of administrators is reached.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListAppInstanceUsersRequest {
    /// <p>The ARN of the <code>AppInstance</code>.</p>
    #[serde(rename = "AppInstanceArn")]
    pub app_instance_arn: String,
    /// <p>The maximum number of requests that you want returned.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>The token passed by previous API calls until all requested users are returned.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListAppInstanceUsersResponse {
    /// <p>The ARN of the <code>AppInstance</code>.</p>
    #[serde(rename = "AppInstanceArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub app_instance_arn: Option<String>,
    /// <p>The information for each requested <code>AppInstanceUser</code>.</p>
    #[serde(rename = "AppInstanceUsers")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub app_instance_users: Option<Vec<AppInstanceUserSummary>>,
    /// <p>The token passed by previous API calls until all requested users are returned.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListAppInstancesRequest {
    /// <p>The maximum number of <code>AppInstance</code>s that you want to return.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>The token passed by previous API requests until you reach the maximum number of <code>AppInstance</code>s.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListAppInstancesResponse {
    /// <p>The information for each <code>AppInstance</code>.</p>
    #[serde(rename = "AppInstances")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub app_instances: Option<Vec<AppInstanceSummary>>,
    /// <p>The token passed by previous API requests until the maximum number of <code>AppInstance</code>s is reached.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListAttendeeTagsRequest {
    /// <p>The Amazon Chime SDK attendee ID.</p>
    #[serde(rename = "AttendeeId")]
    pub attendee_id: String,
    /// <p>The Amazon Chime SDK meeting ID.</p>
    #[serde(rename = "MeetingId")]
    pub meeting_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListAttendeeTagsResponse {
    /// <p>A list of tag key-value pairs.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListAttendeesRequest {
    /// <p>The maximum number of results to return in a single call.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>The Amazon Chime SDK meeting ID.</p>
    #[serde(rename = "MeetingId")]
    pub meeting_id: String,
    /// <p>The token to use to retrieve the next page of results.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListAttendeesResponse {
    /// <p>The Amazon Chime SDK attendee information.</p>
    #[serde(rename = "Attendees")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub attendees: Option<Vec<Attendee>>,
    /// <p>The token to use to retrieve the next page of results.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListBotsRequest {
    /// <p>The Amazon Chime account ID.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>The maximum number of results to return in a single call. The default is 10.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>The token to use to retrieve the next page of results.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListBotsResponse {
    /// <p>List of bots and bot details.</p>
    #[serde(rename = "Bots")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub bots: Option<Vec<Bot>>,
    /// <p>The token to use to retrieve the next page of results.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListChannelBansRequest {
    /// <p>The ARN of the channel.</p>
    #[serde(rename = "ChannelArn")]
    pub channel_arn: String,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    #[serde(rename = "ChimeBearer")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub chime_bearer: Option<String>,
    /// <p>The maximum number of bans that you want returned.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>The token passed by previous API calls until all requested bans are returned.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListChannelBansResponse {
    /// <p>The ARN of the channel.</p>
    #[serde(rename = "ChannelArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub channel_arn: Option<String>,
    /// <p>The information for each requested ban.</p>
    #[serde(rename = "ChannelBans")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub channel_bans: Option<Vec<ChannelBanSummary>>,
    /// <p>The token passed by previous API calls until all requested bans are returned.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListChannelMembershipsForAppInstanceUserRequest {
    /// <p>The ARN of the <code>AppInstanceUser</code>s</p>
    #[serde(rename = "AppInstanceUserArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub app_instance_user_arn: Option<String>,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    #[serde(rename = "ChimeBearer")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub chime_bearer: Option<String>,
    /// <p>The maximum number of users that you want returned.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>The token returned from previous API requests until the number of channel memberships is reached.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListChannelMembershipsForAppInstanceUserResponse {
    /// <p>The token passed by previous API calls until all requested users are returned.</p>
    #[serde(rename = "ChannelMemberships")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub channel_memberships: Option<Vec<ChannelMembershipForAppInstanceUserSummary>>,
    /// <p>The token passed by previous API calls until all requested users are returned.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListChannelMembershipsRequest {
    /// <p>The maximum number of channel memberships that you want returned.</p>
    #[serde(rename = "ChannelArn")]
    pub channel_arn: String,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    #[serde(rename = "ChimeBearer")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub chime_bearer: Option<String>,
    /// <p>The maximum number of channel memberships that you want returned.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>The token passed by previous API calls until all requested channel memberships are returned.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always returned as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are not returned.</p>
    #[serde(rename = "Type")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListChannelMembershipsResponse {
    /// <p>The ARN of the channel.</p>
    #[serde(rename = "ChannelArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub channel_arn: Option<String>,
    /// <p>The information for the requested channel memberships.</p>
    #[serde(rename = "ChannelMemberships")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub channel_memberships: Option<Vec<ChannelMembershipSummary>>,
    /// <p>The token passed by previous API calls until all requested channel memberships are returned.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListChannelMessagesRequest {
    /// <p>The ARN of the channel.</p>
    #[serde(rename = "ChannelArn")]
    pub channel_arn: String,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    #[serde(rename = "ChimeBearer")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub chime_bearer: Option<String>,
    /// <p>The maximum number of messages that you want returned.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>The token passed by previous API calls until all requested messages are returned.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The final or ending time stamp for your requested messages.</p>
    #[serde(rename = "NotAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub not_after: Option<f64>,
    /// <p>The initial or starting time stamp for your requested messages.</p>
    #[serde(rename = "NotBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub not_before: Option<f64>,
    /// <p>The order in which you want messages sorted. Default is Descending, based on time created.</p>
    #[serde(rename = "SortOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_order: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListChannelMessagesResponse {
    /// <p>The ARN of the channel containing the requested messages.</p>
    #[serde(rename = "ChannelArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub channel_arn: Option<String>,
    /// <p>The information about, and content of, each requested message.</p>
    #[serde(rename = "ChannelMessages")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub channel_messages: Option<Vec<ChannelMessageSummary>>,
    /// <p>The token passed by previous API calls until all requested messages are returned.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListChannelModeratorsRequest {
    /// <p>The ARN of the channel.</p>
    #[serde(rename = "ChannelArn")]
    pub channel_arn: String,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    #[serde(rename = "ChimeBearer")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub chime_bearer: Option<String>,
    /// <p>The maximum number of moderators that you want returned.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>The token passed by previous API calls until all requested moderators are returned.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListChannelModeratorsResponse {
    /// <p>The ARN of the channel.</p>
    #[serde(rename = "ChannelArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub channel_arn: Option<String>,
    /// <p>The information about and names of each moderator.</p>
    #[serde(rename = "ChannelModerators")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub channel_moderators: Option<Vec<ChannelModeratorSummary>>,
    /// <p>The token passed by previous API calls until all requested moderators are returned.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListChannelsModeratedByAppInstanceUserRequest {
    /// <p>The ARN of the user in the moderated channel.</p>
    #[serde(rename = "AppInstanceUserArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub app_instance_user_arn: Option<String>,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    #[serde(rename = "ChimeBearer")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub chime_bearer: Option<String>,
    /// <p>The maximum number of channels in the request.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>The token returned from previous API requests until the number of channels moderated by the user is reached.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListChannelsModeratedByAppInstanceUserResponse {
    /// <p>The moderated channels in the request.</p>
    #[serde(rename = "Channels")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub channels: Option<Vec<ChannelModeratedByAppInstanceUserSummary>>,
    /// <p>The token returned from previous API requests until the number of channels moderated by the user is reached.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListChannelsRequest {
    /// <p>The ARN of the <code>AppInstance</code>.</p>
    #[serde(rename = "AppInstanceArn")]
    pub app_instance_arn: String,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    #[serde(rename = "ChimeBearer")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub chime_bearer: Option<String>,
    /// <p>The maximum number of channels that you want to return.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>The token passed by previous API calls until all requested channels are returned.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The privacy setting. <code>PUBLIC</code> retrieves all the public channels. <code>PRIVATE</code> retrieves private channels. Only an <code>AppInstanceAdmin</code> can retrieve private channels. </p>
    #[serde(rename = "Privacy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub privacy: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListChannelsResponse {
    /// <p>The information about each channel.</p>
    #[serde(rename = "Channels")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub channels: Option<Vec<ChannelSummary>>,
    /// <p>The token returned from previous API requests until the number of channels is reached.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListMeetingTagsRequest {
    /// <p>The Amazon Chime SDK meeting ID.</p>
    #[serde(rename = "MeetingId")]
    pub meeting_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListMeetingTagsResponse {
    /// <p>A list of tag key-value pairs.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListMeetingsRequest {
    /// <p>The maximum number of results to return in a single call.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>The token to use to retrieve the next page of results.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListMeetingsResponse {
    /// <p>The Amazon Chime SDK meeting information.</p>
    #[serde(rename = "Meetings")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub meetings: Option<Vec<Meeting>>,
    /// <p>The token to use to retrieve the next page of results.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListPhoneNumberOrdersRequest {
    /// <p>The maximum number of results to return in a single call.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>The token to use to retrieve the next page of results.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListPhoneNumberOrdersResponse {
    /// <p>The token to use to retrieve the next page of results.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The phone number order details.</p>
    #[serde(rename = "PhoneNumberOrders")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub phone_number_orders: Option<Vec<PhoneNumberOrder>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListPhoneNumbersRequest {
    /// <p>The filter to use to limit the number of results.</p>
    #[serde(rename = "FilterName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub filter_name: Option<String>,
    /// <p>The value to use for the filter.</p>
    #[serde(rename = "FilterValue")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub filter_value: Option<String>,
    /// <p>The maximum number of results to return in a single call.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>The token to use to retrieve the next page of results.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The phone number product type.</p>
    #[serde(rename = "ProductType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub product_type: Option<String>,
    /// <p>The phone number status.</p>
    #[serde(rename = "Status")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListPhoneNumbersResponse {
    /// <p>The token to use to retrieve the next page of results.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The phone number details.</p>
    #[serde(rename = "PhoneNumbers")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub phone_numbers: Option<Vec<PhoneNumber>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListProxySessionsRequest {
    /// <p>The maximum number of results to return in a single call.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>The token to use to retrieve the next page of results.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The proxy session status.</p>
    #[serde(rename = "Status")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    /// <p>The Amazon Chime voice connector ID.</p>
    #[serde(rename = "VoiceConnectorId")]
    pub voice_connector_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListProxySessionsResponse {
    /// <p>The token to use to retrieve the next page of results.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The proxy session details.</p>
    #[serde(rename = "ProxySessions")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub proxy_sessions: Option<Vec<ProxySession>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListRoomMembershipsRequest {
    /// <p>The Amazon Chime account ID.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>The maximum number of results to return in a single call.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>The token to use to retrieve the next page of results.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The room ID.</p>
    #[serde(rename = "RoomId")]
    pub room_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListRoomMembershipsResponse {
    /// <p>The token to use to retrieve the next page of results.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The room membership details.</p>
    #[serde(rename = "RoomMemberships")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub room_memberships: Option<Vec<RoomMembership>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListRoomsRequest {
    /// <p>The Amazon Chime account ID.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>The maximum number of results to return in a single call.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>The member ID (user ID or bot ID).</p>
    #[serde(rename = "MemberId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub member_id: Option<String>,
    /// <p>The token to use to retrieve the next page of results.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListRoomsResponse {
    /// <p>The token to use to retrieve the next page of results.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The room details.</p>
    #[serde(rename = "Rooms")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub rooms: Option<Vec<Room>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListSipMediaApplicationsRequest {
    /// <p>The maximum number of results to return in a single call. Defaults to 100.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>The token to use to retrieve the next page of results.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListSipMediaApplicationsResponse {
    /// <p>The token to use to retrieve the next page of results.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>List of SIP media applications and application details.</p>
    #[serde(rename = "SipMediaApplications")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sip_media_applications: Option<Vec<SipMediaApplication>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListSipRulesRequest {
    /// <p>The maximum number of results to return in a single call. Defaults to 100.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>The token to use to retrieve the next page of results.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The SIP media application ID.</p>
    #[serde(rename = "SipMediaApplicationId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sip_media_application_id: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListSipRulesResponse {
    /// <p>The token to use to retrieve the next page of results.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>List of SIP rules and rule details.</p>
    #[serde(rename = "SipRules")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sip_rules: Option<Vec<SipRule>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListSupportedPhoneNumberCountriesRequest {
    /// <p>The phone number product type.</p>
    #[serde(rename = "ProductType")]
    pub product_type: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListSupportedPhoneNumberCountriesResponse {
    /// <p>The supported phone number countries.</p>
    #[serde(rename = "PhoneNumberCountries")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub phone_number_countries: Option<Vec<PhoneNumberCountry>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListTagsForResourceRequest {
    /// <p>The resource ARN.</p>
    #[serde(rename = "ResourceARN")]
    pub resource_arn: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListTagsForResourceResponse {
    /// <p>A list of tag-key value pairs.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListUsersRequest {
    /// <p>The Amazon Chime account ID.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>The maximum number of results to return in a single call. Defaults to 100.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>The token to use to retrieve the next page of results.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>Optional. The user email address used to filter results. Maximum 1.</p>
    #[serde(rename = "UserEmail")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub user_email: Option<String>,
    /// <p>The user type.</p>
    #[serde(rename = "UserType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub user_type: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListUsersResponse {
    /// <p>The token to use to retrieve the next page of results.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>List of users and user details.</p>
    #[serde(rename = "Users")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub users: Option<Vec<User>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListVoiceConnectorGroupsRequest {
    /// <p>The maximum number of results to return in a single call.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>The token to use to retrieve the next page of results.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListVoiceConnectorGroupsResponse {
    /// <p>The token to use to retrieve the next page of results.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The details of the Amazon Chime Voice Connector groups.</p>
    #[serde(rename = "VoiceConnectorGroups")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub voice_connector_groups: Option<Vec<VoiceConnectorGroup>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListVoiceConnectorTerminationCredentialsRequest {
    /// <p>The Amazon Chime Voice Connector ID.</p>
    #[serde(rename = "VoiceConnectorId")]
    pub voice_connector_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListVoiceConnectorTerminationCredentialsResponse {
    /// <p>A list of user names.</p>
    #[serde(rename = "Usernames")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub usernames: Option<Vec<String>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListVoiceConnectorsRequest {
    /// <p>The maximum number of results to return in a single call.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>The token to use to retrieve the next page of results.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListVoiceConnectorsResponse {
    /// <p>The token to use to retrieve the next page of results.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The details of the Amazon Chime Voice Connectors.</p>
    #[serde(rename = "VoiceConnectors")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub voice_connectors: Option<Vec<VoiceConnector>>,
}

/// <p>The logging configuration associated with an Amazon Chime Voice Connector. Specifies whether SIP message logs are enabled for sending to Amazon CloudWatch Logs.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct LoggingConfiguration {
    /// <p>When true, enables SIP message logs for sending to Amazon CloudWatch Logs.</p>
    #[serde(rename = "EnableSIPLogs")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub enable_sip_logs: Option<bool>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct LogoutUserRequest {
    /// <p>The Amazon Chime account ID.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>The user ID.</p>
    #[serde(rename = "UserId")]
    pub user_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct LogoutUserResponse {}

/// <p>A set of endpoints used by clients to connect to the media service group for a Amazon Chime SDK meeting.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct MediaPlacement {
    /// <p>The audio fallback URL.</p>
    #[serde(rename = "AudioFallbackUrl")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub audio_fallback_url: Option<String>,
    /// <p>The audio host URL.</p>
    #[serde(rename = "AudioHostUrl")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub audio_host_url: Option<String>,
    /// <p>The event ingestion URL.</p>
    #[serde(rename = "EventIngestionUrl")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub event_ingestion_url: Option<String>,
    /// <p>The screen data URL.</p>
    #[serde(rename = "ScreenDataUrl")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub screen_data_url: Option<String>,
    /// <p>The screen sharing URL.</p>
    #[serde(rename = "ScreenSharingUrl")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub screen_sharing_url: Option<String>,
    /// <p>The screen viewing URL.</p>
    #[serde(rename = "ScreenViewingUrl")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub screen_viewing_url: Option<String>,
    /// <p>The signaling URL.</p>
    #[serde(rename = "SignalingUrl")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub signaling_url: Option<String>,
    /// <p>The turn control URL.</p>
    #[serde(rename = "TurnControlUrl")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub turn_control_url: Option<String>,
}

/// <p>A meeting created using the Amazon Chime SDK.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct Meeting {
    /// <p>The external meeting ID.</p>
    #[serde(rename = "ExternalMeetingId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub external_meeting_id: Option<String>,
    /// <p>The media placement for the meeting.</p>
    #[serde(rename = "MediaPlacement")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub media_placement: Option<MediaPlacement>,
    /// <p>The Region in which you create the meeting. Available values: <code>af-south-1</code>, <code>ap-northeast-1</code>, <code>ap-northeast-2</code>, <code>ap-south-1</code>, <code>ap-southeast-1</code>, <code>ap-southeast-2</code>, <code>ca-central-1</code>, <code>eu-central-1</code>, <code>eu-north-1</code>, <code>eu-south-1</code>, <code>eu-west-1</code>, <code>eu-west-2</code>, <code>eu-west-3</code>, <code>sa-east-1</code>, <code>us-east-1</code>, <code>us-east-2</code>, <code>us-west-1</code>, <code>us-west-2</code>.</p>
    #[serde(rename = "MediaRegion")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub media_region: Option<String>,
    /// <p>The Amazon Chime SDK meeting ID.</p>
    #[serde(rename = "MeetingId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub meeting_id: Option<String>,
}

/// <p> The resource target configurations for receiving Amazon Chime SDK meeting and attendee event notifications. The Amazon Chime SDK supports resource targets located in the US East (N. Virginia) AWS Region (<code>us-east-1</code>). </p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct MeetingNotificationConfiguration {
    /// <p>The SNS topic ARN.</p>
    #[serde(rename = "SnsTopicArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sns_topic_arn: Option<String>,
    /// <p>The SQS queue ARN.</p>
    #[serde(rename = "SqsQueueArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sqs_queue_arn: Option<String>,
}

/// <p>The member details, such as email address, name, member ID, and member type.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct Member {
    /// <p>The Amazon Chime account ID.</p>
    #[serde(rename = "AccountId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub account_id: Option<String>,
    /// <p>The member email address.</p>
    #[serde(rename = "Email")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub email: Option<String>,
    /// <p>The member name.</p>
    #[serde(rename = "FullName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub full_name: Option<String>,
    /// <p>The member ID (user ID or bot ID).</p>
    #[serde(rename = "MemberId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub member_id: Option<String>,
    /// <p>The member type.</p>
    #[serde(rename = "MemberType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub member_type: Option<String>,
}

/// <p>The list of errors returned when a member action results in an error.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct MemberError {
    /// <p>The error code.</p>
    #[serde(rename = "ErrorCode")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub error_code: Option<String>,
    /// <p>The error message.</p>
    #[serde(rename = "ErrorMessage")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub error_message: Option<String>,
    /// <p>The member ID.</p>
    #[serde(rename = "MemberId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub member_id: Option<String>,
}

/// <p>Membership details, such as member ID and member role.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct MembershipItem {
    /// <p>The member ID.</p>
    #[serde(rename = "MemberId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub member_id: Option<String>,
    /// <p>The member role.</p>
    #[serde(rename = "Role")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub role: Option<String>,
}

/// <p>The websocket endpoint used to connect to Amazon Chime SDK messaging.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct MessagingSessionEndpoint {
    /// <p>The endpoint to which you establish a websocket connection.</p>
    #[serde(rename = "Url")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
}

/// <p>A phone number for which an order has been placed.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct OrderedPhoneNumber {
    /// <p>The phone number, in E.164 format.</p>
    #[serde(rename = "E164PhoneNumber")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub e164_phone_number: Option<String>,
    /// <p>The phone number status.</p>
    #[serde(rename = "Status")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
}

/// <p>Origination settings enable your SIP hosts to receive inbound calls using your Amazon Chime Voice Connector.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct Origination {
    /// <p>When origination settings are disabled, inbound calls are not enabled for your Amazon Chime Voice Connector.</p>
    #[serde(rename = "Disabled")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub disabled: Option<bool>,
    /// <p>The call distribution properties defined for your SIP hosts. Valid range: Minimum value of 1. Maximum value of 20.</p>
    #[serde(rename = "Routes")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub routes: Option<Vec<OriginationRoute>>,
}

/// <p>Origination routes define call distribution properties for your SIP hosts to receive inbound calls using your Amazon Chime Voice Connector. Limit: Ten origination routes for each Amazon Chime Voice Connector.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct OriginationRoute {
    /// <p>The FQDN or IP address to contact for origination traffic.</p>
    #[serde(rename = "Host")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub host: Option<String>,
    /// <p>The designated origination route port. Defaults to 5060.</p>
    #[serde(rename = "Port")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub port: Option<i64>,
    /// <p>The priority associated with the host, with 1 being the highest priority. Higher priority hosts are attempted first.</p>
    #[serde(rename = "Priority")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub priority: Option<i64>,
    /// <p>The protocol to use for the origination route. Encryption-enabled Amazon Chime Voice Connectors use TCP protocol by default.</p>
    #[serde(rename = "Protocol")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub protocol: Option<String>,
    /// <p>The weight associated with the host. If hosts are equal in priority, calls are redistributed among them based on their relative weight.</p>
    #[serde(rename = "Weight")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub weight: Option<i64>,
}

/// <p>The phone number and proxy phone number for a participant in an Amazon Chime Voice Connector proxy session.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct Participant {
    /// <p>The participant's phone number.</p>
    #[serde(rename = "PhoneNumber")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub phone_number: Option<String>,
    /// <p>The participant's proxy phone number.</p>
    #[serde(rename = "ProxyPhoneNumber")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub proxy_phone_number: Option<String>,
}

/// <p>A phone number used for Amazon Chime Business Calling or an Amazon Chime Voice Connector.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct PhoneNumber {
    /// <p>The phone number associations.</p>
    #[serde(rename = "Associations")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub associations: Option<Vec<PhoneNumberAssociation>>,
    /// <p>The outbound calling name associated with the phone number.</p>
    #[serde(rename = "CallingName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub calling_name: Option<String>,
    /// <p>The outbound calling name status.</p>
    #[serde(rename = "CallingNameStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub calling_name_status: Option<String>,
    /// <p>The phone number capabilities.</p>
    #[serde(rename = "Capabilities")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub capabilities: Option<PhoneNumberCapabilities>,
    /// <p>The phone number country. Format: ISO 3166-1 alpha-2.</p>
    #[serde(rename = "Country")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub country: Option<String>,
    /// <p>The phone number creation timestamp, in ISO 8601 format.</p>
    #[serde(rename = "CreatedTimestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_timestamp: Option<f64>,
    /// <p>The deleted phone number timestamp, in ISO 8601 format.</p>
    #[serde(rename = "DeletionTimestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub deletion_timestamp: Option<f64>,
    /// <p>The phone number, in E.164 format.</p>
    #[serde(rename = "E164PhoneNumber")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub e164_phone_number: Option<String>,
    /// <p>The phone number ID.</p>
    #[serde(rename = "PhoneNumberId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub phone_number_id: Option<String>,
    /// <p>The phone number product type.</p>
    #[serde(rename = "ProductType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub product_type: Option<String>,
    /// <p>The phone number status.</p>
    #[serde(rename = "Status")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    /// <p>The phone number type.</p>
    #[serde(rename = "Type")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    /// <p>The updated phone number timestamp, in ISO 8601 format.</p>
    #[serde(rename = "UpdatedTimestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub updated_timestamp: Option<f64>,
}

/// <p>The phone number associations, such as Amazon Chime account ID, Amazon Chime user ID, Amazon Chime Voice Connector ID, or Amazon Chime Voice Connector group ID.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct PhoneNumberAssociation {
    /// <p>The timestamp of the phone number association, in ISO 8601 format.</p>
    #[serde(rename = "AssociatedTimestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub associated_timestamp: Option<f64>,
    /// <p>Defines the association with an Amazon Chime account ID, user ID, Amazon Chime Voice Connector ID, or Amazon Chime Voice Connector group ID.</p>
    #[serde(rename = "Name")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    /// <p>Contains the ID for the entity specified in Name.</p>
    #[serde(rename = "Value")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}

/// <p>The phone number capabilities for Amazon Chime Business Calling phone numbers, such as enabled inbound and outbound calling and text messaging.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct PhoneNumberCapabilities {
    /// <p>Allows or denies inbound calling for the specified phone number.</p>
    #[serde(rename = "InboundCall")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub inbound_call: Option<bool>,
    /// <p>Allows or denies inbound MMS messaging for the specified phone number.</p>
    #[serde(rename = "InboundMMS")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub inbound_mms: Option<bool>,
    /// <p>Allows or denies inbound SMS messaging for the specified phone number.</p>
    #[serde(rename = "InboundSMS")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub inbound_sms: Option<bool>,
    /// <p>Allows or denies outbound calling for the specified phone number.</p>
    #[serde(rename = "OutboundCall")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub outbound_call: Option<bool>,
    /// <p>Allows or denies outbound MMS messaging for the specified phone number.</p>
    #[serde(rename = "OutboundMMS")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub outbound_mms: Option<bool>,
    /// <p>Allows or denies outbound SMS messaging for the specified phone number.</p>
    #[serde(rename = "OutboundSMS")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub outbound_sms: Option<bool>,
}

/// <p>The phone number country.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct PhoneNumberCountry {
    /// <p>The phone number country code. Format: ISO 3166-1 alpha-2.</p>
    #[serde(rename = "CountryCode")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub country_code: Option<String>,
    /// <p>The supported phone number types. </p>
    #[serde(rename = "SupportedPhoneNumberTypes")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub supported_phone_number_types: Option<Vec<String>>,
}

/// <p>If the phone number action fails for one or more of the phone numbers in the request, a list of the phone numbers is returned, along with error codes and error messages.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct PhoneNumberError {
    /// <p>The error code.</p>
    #[serde(rename = "ErrorCode")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub error_code: Option<String>,
    /// <p>The error message.</p>
    #[serde(rename = "ErrorMessage")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub error_message: Option<String>,
    /// <p>The phone number ID for which the action failed.</p>
    #[serde(rename = "PhoneNumberId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub phone_number_id: Option<String>,
}

/// <p>The details of a phone number order created for Amazon Chime.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct PhoneNumberOrder {
    /// <p>The phone number order creation time stamp, in ISO 8601 format.</p>
    #[serde(rename = "CreatedTimestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_timestamp: Option<f64>,
    /// <p>The ordered phone number details, such as the phone number in E.164 format and the phone number status.</p>
    #[serde(rename = "OrderedPhoneNumbers")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub ordered_phone_numbers: Option<Vec<OrderedPhoneNumber>>,
    /// <p>The phone number order ID.</p>
    #[serde(rename = "PhoneNumberOrderId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub phone_number_order_id: Option<String>,
    /// <p>The phone number order product type.</p>
    #[serde(rename = "ProductType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub product_type: Option<String>,
    /// <p>The status of the phone number order.</p>
    #[serde(rename = "Status")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    /// <p>The updated phone number order time stamp, in ISO 8601 format.</p>
    #[serde(rename = "UpdatedTimestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub updated_timestamp: Option<f64>,
}

/// <p>The proxy configuration for an Amazon Chime Voice Connector.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct Proxy {
    /// <p>The default number of minutes allowed for proxy sessions.</p>
    #[serde(rename = "DefaultSessionExpiryMinutes")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub default_session_expiry_minutes: Option<i64>,
    /// <p>When true, stops proxy sessions from being created on the specified Amazon Chime Voice Connector.</p>
    #[serde(rename = "Disabled")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub disabled: Option<bool>,
    /// <p>The phone number to route calls to after a proxy session expires.</p>
    #[serde(rename = "FallBackPhoneNumber")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub fall_back_phone_number: Option<String>,
    /// <p>The countries for proxy phone numbers to be selected from.</p>
    #[serde(rename = "PhoneNumberCountries")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub phone_number_countries: Option<Vec<String>>,
}

/// <p>The proxy session for an Amazon Chime Voice Connector.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ProxySession {
    /// <p>The proxy session capabilities.</p>
    #[serde(rename = "Capabilities")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub capabilities: Option<Vec<String>>,
    /// <p>The created time stamp, in ISO 8601 format.</p>
    #[serde(rename = "CreatedTimestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_timestamp: Option<f64>,
    /// <p>The ended time stamp, in ISO 8601 format.</p>
    #[serde(rename = "EndedTimestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub ended_timestamp: Option<f64>,
    /// <p>The number of minutes allowed for the proxy session.</p>
    #[serde(rename = "ExpiryMinutes")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub expiry_minutes: Option<i64>,
    /// <p>The preference for matching the country or area code of the proxy phone number with that of the first participant.</p>
    #[serde(rename = "GeoMatchLevel")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub geo_match_level: Option<String>,
    /// <p>The country and area code for the proxy phone number.</p>
    #[serde(rename = "GeoMatchParams")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub geo_match_params: Option<GeoMatchParams>,
    /// <p>The name of the proxy session.</p>
    #[serde(rename = "Name")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    /// <p>The preference for proxy phone number reuse, or stickiness, between the same participants across sessions.</p>
    #[serde(rename = "NumberSelectionBehavior")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub number_selection_behavior: Option<String>,
    /// <p>The proxy session participants.</p>
    #[serde(rename = "Participants")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub participants: Option<Vec<Participant>>,
    /// <p>The proxy session ID.</p>
    #[serde(rename = "ProxySessionId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub proxy_session_id: Option<String>,
    /// <p>The status of the proxy session.</p>
    #[serde(rename = "Status")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    /// <p>The updated time stamp, in ISO 8601 format.</p>
    #[serde(rename = "UpdatedTimestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub updated_timestamp: Option<f64>,
    /// <p>The Amazon Chime voice connector ID.</p>
    #[serde(rename = "VoiceConnectorId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub voice_connector_id: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct PutAppInstanceRetentionSettingsRequest {
    /// <p>The ARN of the <code>AppInstance</code>.</p>
    #[serde(rename = "AppInstanceArn")]
    pub app_instance_arn: String,
    /// <p>The time in days to retain data. Data type: number.</p>
    #[serde(rename = "AppInstanceRetentionSettings")]
    pub app_instance_retention_settings: AppInstanceRetentionSettings,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct PutAppInstanceRetentionSettingsResponse {
    /// <p>The time in days to retain data. Data type: number.</p>
    #[serde(rename = "AppInstanceRetentionSettings")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub app_instance_retention_settings: Option<AppInstanceRetentionSettings>,
    /// <p>The time at which the API deletes data.</p>
    #[serde(rename = "InitiateDeletionTimestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub initiate_deletion_timestamp: Option<f64>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct PutAppInstanceStreamingConfigurationsRequest {
    /// <p>The ARN of the <code>AppInstance</code>.</p>
    #[serde(rename = "AppInstanceArn")]
    pub app_instance_arn: String,
    /// <p>The streaming configurations set for an <code>AppInstance</code>.</p>
    #[serde(rename = "AppInstanceStreamingConfigurations")]
    pub app_instance_streaming_configurations: Vec<AppInstanceStreamingConfiguration>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct PutAppInstanceStreamingConfigurationsResponse {
    /// <p>The streaming configurations of an <code>AppInstance</code>.</p>
    #[serde(rename = "AppInstanceStreamingConfigurations")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub app_instance_streaming_configurations: Option<Vec<AppInstanceStreamingConfiguration>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct PutEventsConfigurationRequest {
    /// <p>The Amazon Chime account ID.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>The bot ID.</p>
    #[serde(rename = "BotId")]
    pub bot_id: String,
    /// <p>Lambda function ARN that allows the bot to receive outgoing events.</p>
    #[serde(rename = "LambdaFunctionArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub lambda_function_arn: Option<String>,
    /// <p>HTTPS endpoint that allows the bot to receive outgoing events.</p>
    #[serde(rename = "OutboundEventsHTTPSEndpoint")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub outbound_events_https_endpoint: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct PutEventsConfigurationResponse {
    #[serde(rename = "EventsConfiguration")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub events_configuration: Option<EventsConfiguration>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct PutRetentionSettingsRequest {
    /// <p>The Amazon Chime account ID.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>The retention settings.</p>
    #[serde(rename = "RetentionSettings")]
    pub retention_settings: RetentionSettings,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct PutRetentionSettingsResponse {
    /// <p>The timestamp representing the time at which the specified items are permanently deleted, in ISO 8601 format.</p>
    #[serde(rename = "InitiateDeletionTimestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub initiate_deletion_timestamp: Option<f64>,
    /// <p>The retention settings.</p>
    #[serde(rename = "RetentionSettings")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub retention_settings: Option<RetentionSettings>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct PutSipMediaApplicationLoggingConfigurationRequest {
    /// <p>The SIP media application ID.</p>
    #[serde(rename = "SipMediaApplicationId")]
    pub sip_media_application_id: String,
    /// <p>The actual logging configuration.</p>
    #[serde(rename = "SipMediaApplicationLoggingConfiguration")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sip_media_application_logging_configuration:
        Option<SipMediaApplicationLoggingConfiguration>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct PutSipMediaApplicationLoggingConfigurationResponse {
    #[serde(rename = "SipMediaApplicationLoggingConfiguration")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sip_media_application_logging_configuration:
        Option<SipMediaApplicationLoggingConfiguration>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct PutVoiceConnectorEmergencyCallingConfigurationRequest {
    /// <p>The emergency calling configuration details.</p>
    #[serde(rename = "EmergencyCallingConfiguration")]
    pub emergency_calling_configuration: EmergencyCallingConfiguration,
    /// <p>The Amazon Chime Voice Connector ID.</p>
    #[serde(rename = "VoiceConnectorId")]
    pub voice_connector_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct PutVoiceConnectorEmergencyCallingConfigurationResponse {
    /// <p>The emergency calling configuration details.</p>
    #[serde(rename = "EmergencyCallingConfiguration")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub emergency_calling_configuration: Option<EmergencyCallingConfiguration>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct PutVoiceConnectorLoggingConfigurationRequest {
    /// <p>The logging configuration details to add.</p>
    #[serde(rename = "LoggingConfiguration")]
    pub logging_configuration: LoggingConfiguration,
    /// <p>The Amazon Chime Voice Connector ID.</p>
    #[serde(rename = "VoiceConnectorId")]
    pub voice_connector_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct PutVoiceConnectorLoggingConfigurationResponse {
    /// <p>The updated logging configuration details.</p>
    #[serde(rename = "LoggingConfiguration")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub logging_configuration: Option<LoggingConfiguration>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct PutVoiceConnectorOriginationRequest {
    /// <p>The origination setting details to add.</p>
    #[serde(rename = "Origination")]
    pub origination: Origination,
    /// <p>The Amazon Chime Voice Connector ID.</p>
    #[serde(rename = "VoiceConnectorId")]
    pub voice_connector_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct PutVoiceConnectorOriginationResponse {
    /// <p>The updated origination setting details.</p>
    #[serde(rename = "Origination")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub origination: Option<Origination>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct PutVoiceConnectorProxyRequest {
    /// <p>The default number of minutes allowed for proxy sessions.</p>
    #[serde(rename = "DefaultSessionExpiryMinutes")]
    pub default_session_expiry_minutes: i64,
    /// <p>When true, stops proxy sessions from being created on the specified Amazon Chime Voice Connector.</p>
    #[serde(rename = "Disabled")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub disabled: Option<bool>,
    /// <p>The phone number to route calls to after a proxy session expires.</p>
    #[serde(rename = "FallBackPhoneNumber")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub fall_back_phone_number: Option<String>,
    /// <p>The countries for proxy phone numbers to be selected from.</p>
    #[serde(rename = "PhoneNumberPoolCountries")]
    pub phone_number_pool_countries: Vec<String>,
    /// <p>The Amazon Chime voice connector ID.</p>
    #[serde(rename = "VoiceConnectorId")]
    pub voice_connector_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct PutVoiceConnectorProxyResponse {
    /// <p>The proxy configuration details.</p>
    #[serde(rename = "Proxy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub proxy: Option<Proxy>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct PutVoiceConnectorStreamingConfigurationRequest {
    /// <p>The streaming configuration details to add.</p>
    #[serde(rename = "StreamingConfiguration")]
    pub streaming_configuration: StreamingConfiguration,
    /// <p>The Amazon Chime Voice Connector ID.</p>
    #[serde(rename = "VoiceConnectorId")]
    pub voice_connector_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct PutVoiceConnectorStreamingConfigurationResponse {
    /// <p>The updated streaming configuration details.</p>
    #[serde(rename = "StreamingConfiguration")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub streaming_configuration: Option<StreamingConfiguration>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct PutVoiceConnectorTerminationCredentialsRequest {
    /// <p>The termination SIP credentials.</p>
    #[serde(rename = "Credentials")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub credentials: Option<Vec<Credential>>,
    /// <p>The Amazon Chime Voice Connector ID.</p>
    #[serde(rename = "VoiceConnectorId")]
    pub voice_connector_id: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct PutVoiceConnectorTerminationRequest {
    /// <p>The termination setting details to add.</p>
    #[serde(rename = "Termination")]
    pub termination: Termination,
    /// <p>The Amazon Chime Voice Connector ID.</p>
    #[serde(rename = "VoiceConnectorId")]
    pub voice_connector_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct PutVoiceConnectorTerminationResponse {
    /// <p>The updated termination setting details.</p>
    #[serde(rename = "Termination")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub termination: Option<Termination>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct RedactChannelMessageRequest {
    /// <p>The ARN of the channel containing the messages that you want to redact.</p>
    #[serde(rename = "ChannelArn")]
    pub channel_arn: String,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    #[serde(rename = "ChimeBearer")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub chime_bearer: Option<String>,
    /// <p>The ID of the message being redacted.</p>
    #[serde(rename = "MessageId")]
    pub message_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct RedactChannelMessageResponse {
    /// <p>The ARN of the channel containing the messages that you want to redact.</p>
    #[serde(rename = "ChannelArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub channel_arn: Option<String>,
    /// <p>The ID of the message being redacted.</p>
    #[serde(rename = "MessageId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub message_id: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct RedactConversationMessageRequest {
    /// <p>The Amazon Chime account ID.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>The conversation ID.</p>
    #[serde(rename = "ConversationId")]
    pub conversation_id: String,
    /// <p>The message ID.</p>
    #[serde(rename = "MessageId")]
    pub message_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct RedactConversationMessageResponse {}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct RedactRoomMessageRequest {
    /// <p>The Amazon Chime account ID.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>The message ID.</p>
    #[serde(rename = "MessageId")]
    pub message_id: String,
    /// <p>The room ID.</p>
    #[serde(rename = "RoomId")]
    pub room_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct RedactRoomMessageResponse {}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct RegenerateSecurityTokenRequest {
    /// <p>The Amazon Chime account ID.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>The bot ID.</p>
    #[serde(rename = "BotId")]
    pub bot_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct RegenerateSecurityTokenResponse {
    #[serde(rename = "Bot")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub bot: Option<Bot>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ResetPersonalPINRequest {
    /// <p>The Amazon Chime account ID.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>The user ID.</p>
    #[serde(rename = "UserId")]
    pub user_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ResetPersonalPINResponse {
    /// <p>The user details and new personal meeting PIN.</p>
    #[serde(rename = "User")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub user: Option<User>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct RestorePhoneNumberRequest {
    /// <p>The phone number.</p>
    #[serde(rename = "PhoneNumberId")]
    pub phone_number_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct RestorePhoneNumberResponse {
    /// <p>The phone number details.</p>
    #[serde(rename = "PhoneNumber")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub phone_number: Option<PhoneNumber>,
}

/// <p>The retention settings for an Amazon Chime Enterprise account that determine how long to retain items such as chat-room messages and chat-conversation messages.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct RetentionSettings {
    /// <p>The chat conversation retention settings.</p>
    #[serde(rename = "ConversationRetentionSettings")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub conversation_retention_settings: Option<ConversationRetentionSettings>,
    /// <p>The chat room retention settings.</p>
    #[serde(rename = "RoomRetentionSettings")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub room_retention_settings: Option<RoomRetentionSettings>,
}

/// <p>The Amazon Chime chat room details.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct Room {
    /// <p>The Amazon Chime account ID.</p>
    #[serde(rename = "AccountId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub account_id: Option<String>,
    /// <p>The identifier of the room creator.</p>
    #[serde(rename = "CreatedBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_by: Option<String>,
    /// <p>The room creation timestamp, in ISO 8601 format.</p>
    #[serde(rename = "CreatedTimestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_timestamp: Option<f64>,
    /// <p>The room name.</p>
    #[serde(rename = "Name")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    /// <p>The room ID.</p>
    #[serde(rename = "RoomId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub room_id: Option<String>,
    /// <p>The room update timestamp, in ISO 8601 format.</p>
    #[serde(rename = "UpdatedTimestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub updated_timestamp: Option<f64>,
}

/// <p>The room membership details.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct RoomMembership {
    /// <p>The identifier of the user that invited the room member.</p>
    #[serde(rename = "InvitedBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub invited_by: Option<String>,
    #[serde(rename = "Member")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub member: Option<Member>,
    /// <p>The membership role.</p>
    #[serde(rename = "Role")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub role: Option<String>,
    /// <p>The room ID.</p>
    #[serde(rename = "RoomId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub room_id: Option<String>,
    /// <p>The room membership update timestamp, in ISO 8601 format.</p>
    #[serde(rename = "UpdatedTimestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub updated_timestamp: Option<f64>,
}

/// <p>The retention settings that determine how long to retain chat-room messages for an Amazon Chime Enterprise account.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct RoomRetentionSettings {
    /// <p>The number of days for which to retain chat-room messages.</p>
    #[serde(rename = "RetentionDays")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub retention_days: Option<i64>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct SearchAvailablePhoneNumbersRequest {
    /// <p>The area code used to filter results. Only applies to the US.</p>
    #[serde(rename = "AreaCode")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub area_code: Option<String>,
    /// <p>The city used to filter results. Only applies to the US.</p>
    #[serde(rename = "City")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub city: Option<String>,
    /// <p>The country used to filter results. Defaults to the US Format: ISO 3166-1 alpha-2.</p>
    #[serde(rename = "Country")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub country: Option<String>,
    /// <p>The maximum number of results to return in a single call.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>The token used to retrieve the next page of results.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The phone number type used to filter results. Required for non-US numbers.</p>
    #[serde(rename = "PhoneNumberType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub phone_number_type: Option<String>,
    /// <p>The state used to filter results. Required only if you provide <code>City</code>. Only applies to the US.</p>
    #[serde(rename = "State")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
    /// <p>The toll-free prefix that you use to filter results. Only applies to the US.</p>
    #[serde(rename = "TollFreePrefix")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub toll_free_prefix: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct SearchAvailablePhoneNumbersResponse {
    /// <p>List of phone numbers, in E.164 format.</p>
    #[serde(rename = "E164PhoneNumbers")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub e164_phone_numbers: Option<Vec<String>>,
    /// <p>The token used to retrieve the next page of search results.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct SendChannelMessageRequest {
    /// <p>The ARN of the channel.</p>
    #[serde(rename = "ChannelArn")]
    pub channel_arn: String,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    #[serde(rename = "ChimeBearer")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub chime_bearer: Option<String>,
    /// <p>The <code>Idempotency</code> token for each client request.</p>
    #[serde(rename = "ClientRequestToken")]
    pub client_request_token: String,
    /// <p>The content of the message.</p>
    #[serde(rename = "Content")]
    pub content: String,
    /// <p>The optional metadata for each message.</p>
    #[serde(rename = "Metadata")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metadata: Option<String>,
    /// <p>Boolean that controls whether the message is persisted on the back end. Required.</p>
    #[serde(rename = "Persistence")]
    pub persistence: String,
    /// <p>The type of message, <code>STANDARD</code> or <code>CONTROL</code>.</p>
    #[serde(rename = "Type")]
    pub type_: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct SendChannelMessageResponse {
    /// <p>The ARN of the channel.</p>
    #[serde(rename = "ChannelArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub channel_arn: Option<String>,
    /// <p>The ID string assigned to each message.</p>
    #[serde(rename = "MessageId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub message_id: Option<String>,
}

/// <p>An Active Directory (AD) group whose members are granted permission to act as delegates.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct SigninDelegateGroup {
    /// <p>The group name.</p>
    #[serde(rename = "GroupName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub group_name: Option<String>,
}

/// <p>The details of the SIP media application, including name and endpoints. An AWS account can have multiple SIP media applications.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct SipMediaApplication {
    /// <p>The AWS Region in which the SIP media application is created.</p>
    #[serde(rename = "AwsRegion")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub aws_region: Option<String>,
    /// <p>The SIP media application creation timestamp, in ISO 8601 format.</p>
    #[serde(rename = "CreatedTimestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_timestamp: Option<f64>,
    /// <p>List of endpoints for SIP media application. Currently, only one endpoint per SIP media application is permitted.</p>
    #[serde(rename = "Endpoints")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub endpoints: Option<Vec<SipMediaApplicationEndpoint>>,
    /// <p>The name of the SIP media application.</p>
    #[serde(rename = "Name")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    /// <p>The SIP media application ID.</p>
    #[serde(rename = "SipMediaApplicationId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sip_media_application_id: Option<String>,
    /// <p>The SIP media application updated timestamp, in ISO 8601 format.</p>
    #[serde(rename = "UpdatedTimestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub updated_timestamp: Option<f64>,
}

/// <p>A <code>Call</code> instance for a SIP media application.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct SipMediaApplicationCall {
    /// <p>The transaction ID of a call.</p>
    #[serde(rename = "TransactionId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub transaction_id: Option<String>,
}

/// <p>The endpoint assigned to the SIP media application.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct SipMediaApplicationEndpoint {
    /// <p>Valid Amazon Resource Name (ARN) of the Lambda function. The function must be created in the same AWS Region as the SIP media application.</p>
    #[serde(rename = "LambdaArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub lambda_arn: Option<String>,
}

/// <p>Logging configuration of the SIP media application.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct SipMediaApplicationLoggingConfiguration {
    /// <p>Enables application message logs for the SIP media application.</p>
    #[serde(rename = "EnableSipMediaApplicationMessageLogs")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub enable_sip_media_application_message_logs: Option<bool>,
}

/// <p>The SIP rule details, including name, triggers, and target applications. An AWS account can have multiple SIP rules.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct SipRule {
    /// <p>The time at which the SIP rule was created, in ISO 8601 format.</p>
    #[serde(rename = "CreatedTimestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_timestamp: Option<f64>,
    /// <p>Indicates whether the SIP rule is enabled or disabled. You must disable a rule before you can delete it.</p>
    #[serde(rename = "Disabled")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub disabled: Option<bool>,
    /// <p>The name of the SIP rule.</p>
    #[serde(rename = "Name")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    /// <p>The SIP rule ID.</p>
    #[serde(rename = "SipRuleId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sip_rule_id: Option<String>,
    /// <p>Target SIP media application and other details, such as priority and AWS Region, to be specified in the SIP rule. Only one SIP rule per AWS Region can be provided.</p>
    #[serde(rename = "TargetApplications")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub target_applications: Option<Vec<SipRuleTargetApplication>>,
    /// <p>The type of trigger assigned to the SIP rule in <code>TriggerValue</code>, currently <code>RequestUriHostname</code> or <code>ToPhoneNumber</code>.</p>
    #[serde(rename = "TriggerType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub trigger_type: Option<String>,
    /// <p>If <code>TriggerType</code> is <code>RequestUriHostname</code>, then the value can be the outbound host name of the Amazon Chime Voice Connector. If <code>TriggerType</code> is <code>ToPhoneNumber</code>, then the value can be a customer-owned phone number in E164 format. <code>SipRule</code> is triggered when a SIP rule requests host name or <code>ToPhoneNumber</code> matches in the incoming SIP request.</p>
    #[serde(rename = "TriggerValue")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub trigger_value: Option<String>,
    /// <p>The time at which the SIP rule was last updated, in ISO 8601 format.</p>
    #[serde(rename = "UpdatedTimestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub updated_timestamp: Option<f64>,
}

/// <p>Target SIP media application and other details, such as priority and AWS Region, to be specified in the SIP rule. Only one SIP rule per AWS Region can be provided.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct SipRuleTargetApplication {
    /// <p>The AWS Region of the target application.</p>
    #[serde(rename = "AwsRegion")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub aws_region: Option<String>,
    /// <p>Priority of the SIP media application in the target list.</p>
    #[serde(rename = "Priority")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub priority: Option<i64>,
    /// <p>The SIP media application ID.</p>
    #[serde(rename = "SipMediaApplicationId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sip_media_application_id: Option<String>,
}

/// <p>The streaming configuration associated with an Amazon Chime Voice Connector. Specifies whether media streaming is enabled for sending to Amazon Kinesis, and shows the retention period for the Amazon Kinesis data, in hours.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct StreamingConfiguration {
    /// <p>The retention period, in hours, for the Amazon Kinesis data.</p>
    #[serde(rename = "DataRetentionInHours")]
    pub data_retention_in_hours: i64,
    /// <p>When true, media streaming to Amazon Kinesis is turned off.</p>
    #[serde(rename = "Disabled")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub disabled: Option<bool>,
    /// <p>The streaming notification targets.</p>
    #[serde(rename = "StreamingNotificationTargets")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub streaming_notification_targets: Option<Vec<StreamingNotificationTarget>>,
}

/// <p>The targeted recipient for a streaming configuration notification.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct StreamingNotificationTarget {
    /// <p>The streaming notification target.</p>
    #[serde(rename = "NotificationTarget")]
    pub notification_target: String,
}

/// <p>Describes a tag applied to a resource.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct Tag {
    /// <p>The key of the tag.</p>
    #[serde(rename = "Key")]
    pub key: String,
    /// <p>The value of the tag.</p>
    #[serde(rename = "Value")]
    pub value: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct TagAttendeeRequest {
    /// <p>The Amazon Chime SDK attendee ID.</p>
    #[serde(rename = "AttendeeId")]
    pub attendee_id: String,
    /// <p>The Amazon Chime SDK meeting ID.</p>
    #[serde(rename = "MeetingId")]
    pub meeting_id: String,
    /// <p>The tag key-value pairs.</p>
    #[serde(rename = "Tags")]
    pub tags: Vec<Tag>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct TagMeetingRequest {
    /// <p>The Amazon Chime SDK meeting ID.</p>
    #[serde(rename = "MeetingId")]
    pub meeting_id: String,
    /// <p>The tag key-value pairs.</p>
    #[serde(rename = "Tags")]
    pub tags: Vec<Tag>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct TagResourceRequest {
    /// <p>The resource ARN.</p>
    #[serde(rename = "ResourceARN")]
    pub resource_arn: String,
    /// <p>The tag key-value pairs.</p>
    #[serde(rename = "Tags")]
    pub tags: Vec<Tag>,
}

/// <p>Settings that allow management of telephony permissions for an Amazon Chime user, such as inbound and outbound calling and text messaging.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct TelephonySettings {
    /// <p>Allows or denies inbound calling.</p>
    #[serde(rename = "InboundCalling")]
    pub inbound_calling: bool,
    /// <p>Allows or denies outbound calling.</p>
    #[serde(rename = "OutboundCalling")]
    pub outbound_calling: bool,
    /// <p>Allows or denies SMS messaging.</p>
    #[serde(rename = "SMS")]
    pub sms: bool,
}

/// <p>Termination settings enable your SIP hosts to make outbound calls using your Amazon Chime Voice Connector.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct Termination {
    /// <p>The countries to which calls are allowed, in ISO 3166-1 alpha-2 format. Required.</p>
    #[serde(rename = "CallingRegions")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub calling_regions: Option<Vec<String>>,
    /// <p>The IP addresses allowed to make calls, in CIDR format. Required.</p>
    #[serde(rename = "CidrAllowedList")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub cidr_allowed_list: Option<Vec<String>>,
    /// <p>The limit on calls per second. Max value based on account service quota. Default value of 1.</p>
    #[serde(rename = "CpsLimit")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub cps_limit: Option<i64>,
    /// <p>The default caller ID phone number.</p>
    #[serde(rename = "DefaultPhoneNumber")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub default_phone_number: Option<String>,
    /// <p>When termination settings are disabled, outbound calls can not be made.</p>
    #[serde(rename = "Disabled")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub disabled: Option<bool>,
}

/// <p>The termination health details, including the source IP address and timestamp of the last successful SIP <code>OPTIONS</code> message from your SIP infrastructure.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct TerminationHealth {
    /// <p>The source IP address.</p>
    #[serde(rename = "Source")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub source: Option<String>,
    /// <p>The timestamp, in ISO 8601 format.</p>
    #[serde(rename = "Timestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub timestamp: Option<f64>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UntagAttendeeRequest {
    /// <p>The Amazon Chime SDK attendee ID.</p>
    #[serde(rename = "AttendeeId")]
    pub attendee_id: String,
    /// <p>The Amazon Chime SDK meeting ID.</p>
    #[serde(rename = "MeetingId")]
    pub meeting_id: String,
    /// <p>The tag keys.</p>
    #[serde(rename = "TagKeys")]
    pub tag_keys: Vec<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UntagMeetingRequest {
    /// <p>The Amazon Chime SDK meeting ID.</p>
    #[serde(rename = "MeetingId")]
    pub meeting_id: String,
    /// <p>The tag keys.</p>
    #[serde(rename = "TagKeys")]
    pub tag_keys: Vec<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UntagResourceRequest {
    /// <p>The resource ARN.</p>
    #[serde(rename = "ResourceARN")]
    pub resource_arn: String,
    /// <p>The tag keys.</p>
    #[serde(rename = "TagKeys")]
    pub tag_keys: Vec<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateAccountRequest {
    /// <p>The Amazon Chime account ID.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>The default license applied when you add users to an Amazon Chime account.</p>
    #[serde(rename = "DefaultLicense")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub default_license: Option<String>,
    /// <p>The new name for the specified Amazon Chime account.</p>
    #[serde(rename = "Name")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateAccountResponse {
    /// <p>The updated Amazon Chime account details.</p>
    #[serde(rename = "Account")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub account: Option<Account>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateAccountSettingsRequest {
    /// <p>The Amazon Chime account ID.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>The Amazon Chime account settings to update.</p>
    #[serde(rename = "AccountSettings")]
    pub account_settings: AccountSettings,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateAccountSettingsResponse {}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateAppInstanceRequest {
    /// <p>The ARN of the <code>AppInstance</code>.</p>
    #[serde(rename = "AppInstanceArn")]
    pub app_instance_arn: String,
    /// <p>The metadata that you want to change.</p>
    #[serde(rename = "Metadata")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metadata: Option<String>,
    /// <p>The name that you want to change.</p>
    #[serde(rename = "Name")]
    pub name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateAppInstanceResponse {
    /// <p>The ARN of the <code>AppInstance</code>.</p>
    #[serde(rename = "AppInstanceArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub app_instance_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateAppInstanceUserRequest {
    /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
    #[serde(rename = "AppInstanceUserArn")]
    pub app_instance_user_arn: String,
    /// <p>The metadata of the <code>AppInstanceUser</code>.</p>
    #[serde(rename = "Metadata")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metadata: Option<String>,
    /// <p>The name of the <code>AppInstanceUser</code>.</p>
    #[serde(rename = "Name")]
    pub name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateAppInstanceUserResponse {
    /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
    #[serde(rename = "AppInstanceUserArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub app_instance_user_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateBotRequest {
    /// <p>The Amazon Chime account ID.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>The bot ID.</p>
    #[serde(rename = "BotId")]
    pub bot_id: String,
    /// <p>When true, stops the specified bot from running in your account.</p>
    #[serde(rename = "Disabled")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub disabled: Option<bool>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateBotResponse {
    /// <p>The updated bot details.</p>
    #[serde(rename = "Bot")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub bot: Option<Bot>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateChannelMessageRequest {
    /// <p>The ARN of the channel.</p>
    #[serde(rename = "ChannelArn")]
    pub channel_arn: String,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    #[serde(rename = "ChimeBearer")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub chime_bearer: Option<String>,
    /// <p>The content of the message being updated.</p>
    #[serde(rename = "Content")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub content: Option<String>,
    /// <p>The ID string of the message being updated.</p>
    #[serde(rename = "MessageId")]
    pub message_id: String,
    /// <p>The metadata of the message being updated.</p>
    #[serde(rename = "Metadata")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metadata: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateChannelMessageResponse {
    /// <p>The ARN of the channel.</p>
    #[serde(rename = "ChannelArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub channel_arn: Option<String>,
    /// <p>The ID string of the message being updated.</p>
    #[serde(rename = "MessageId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub message_id: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateChannelReadMarkerRequest {
    /// <p>The ARN of the channel.</p>
    #[serde(rename = "ChannelArn")]
    pub channel_arn: String,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    #[serde(rename = "ChimeBearer")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub chime_bearer: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateChannelReadMarkerResponse {
    /// <p>The ARN of the channel.</p>
    #[serde(rename = "ChannelArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub channel_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateChannelRequest {
    /// <p>The ARN of the channel.</p>
    #[serde(rename = "ChannelArn")]
    pub channel_arn: String,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    #[serde(rename = "ChimeBearer")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub chime_bearer: Option<String>,
    /// <p>The metadata for the update request.</p>
    #[serde(rename = "Metadata")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metadata: Option<String>,
    /// <p>The mode of the update request.</p>
    #[serde(rename = "Mode")]
    pub mode: String,
    /// <p>The name of the channel.</p>
    #[serde(rename = "Name")]
    pub name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateChannelResponse {
    /// <p>The ARN of the channel.</p>
    #[serde(rename = "ChannelArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub channel_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateGlobalSettingsRequest {
    /// <p>The Amazon Chime Business Calling settings.</p>
    #[serde(rename = "BusinessCalling")]
    pub business_calling: BusinessCallingSettings,
    /// <p>The Amazon Chime Voice Connector settings.</p>
    #[serde(rename = "VoiceConnector")]
    pub voice_connector: VoiceConnectorSettings,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdatePhoneNumberRequest {
    /// <p>The outbound calling name associated with the phone number.</p>
    #[serde(rename = "CallingName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub calling_name: Option<String>,
    /// <p>The phone number ID.</p>
    #[serde(rename = "PhoneNumberId")]
    pub phone_number_id: String,
    /// <p>The product type.</p>
    #[serde(rename = "ProductType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub product_type: Option<String>,
}

/// <p>The phone number ID, product type, or calling name fields to update, used with the <a>BatchUpdatePhoneNumber</a> and <a>UpdatePhoneNumber</a> actions.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdatePhoneNumberRequestItem {
    /// <p>The outbound calling name to update.</p>
    #[serde(rename = "CallingName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub calling_name: Option<String>,
    /// <p>The phone number ID to update.</p>
    #[serde(rename = "PhoneNumberId")]
    pub phone_number_id: String,
    /// <p>The product type to update.</p>
    #[serde(rename = "ProductType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub product_type: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdatePhoneNumberResponse {
    /// <p>The updated phone number details.</p>
    #[serde(rename = "PhoneNumber")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub phone_number: Option<PhoneNumber>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdatePhoneNumberSettingsRequest {
    /// <p>The default outbound calling name for the account.</p>
    #[serde(rename = "CallingName")]
    pub calling_name: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateProxySessionRequest {
    /// <p>The proxy session capabilities.</p>
    #[serde(rename = "Capabilities")]
    pub capabilities: Vec<String>,
    /// <p>The number of minutes allowed for the proxy session.</p>
    #[serde(rename = "ExpiryMinutes")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub expiry_minutes: Option<i64>,
    /// <p>The proxy session ID.</p>
    #[serde(rename = "ProxySessionId")]
    pub proxy_session_id: String,
    /// <p>The Amazon Chime voice connector ID.</p>
    #[serde(rename = "VoiceConnectorId")]
    pub voice_connector_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateProxySessionResponse {
    /// <p>The proxy session details.</p>
    #[serde(rename = "ProxySession")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub proxy_session: Option<ProxySession>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateRoomMembershipRequest {
    /// <p>The Amazon Chime account ID.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>The member ID.</p>
    #[serde(rename = "MemberId")]
    pub member_id: String,
    /// <p>The role of the member.</p>
    #[serde(rename = "Role")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub role: Option<String>,
    /// <p>The room ID.</p>
    #[serde(rename = "RoomId")]
    pub room_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateRoomMembershipResponse {
    /// <p>The room membership details.</p>
    #[serde(rename = "RoomMembership")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub room_membership: Option<RoomMembership>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateRoomRequest {
    /// <p>The Amazon Chime account ID.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>The room name.</p>
    #[serde(rename = "Name")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    /// <p>The room ID.</p>
    #[serde(rename = "RoomId")]
    pub room_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateRoomResponse {
    /// <p>The room details.</p>
    #[serde(rename = "Room")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub room: Option<Room>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateSipMediaApplicationCallRequest {
    /// <p>Arguments made available to the Lambda function as part of the <code>CALL_UPDATE_REQUESTED</code> event. Can contain 0-20 key-value pairs.</p>
    #[serde(rename = "Arguments")]
    pub arguments: ::std::collections::HashMap<String, String>,
    /// <p>The ID of the SIP media application handling the call.</p>
    #[serde(rename = "SipMediaApplicationId")]
    pub sip_media_application_id: String,
    /// <p>The ID of the call transaction.</p>
    #[serde(rename = "TransactionId")]
    pub transaction_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateSipMediaApplicationCallResponse {
    #[serde(rename = "SipMediaApplicationCall")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sip_media_application_call: Option<SipMediaApplicationCall>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateSipMediaApplicationRequest {
    /// <p>The new set of endpoints for the specified SIP media application.</p>
    #[serde(rename = "Endpoints")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub endpoints: Option<Vec<SipMediaApplicationEndpoint>>,
    /// <p>The new name for the specified SIP media application.</p>
    #[serde(rename = "Name")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    /// <p>The SIP media application ID.</p>
    #[serde(rename = "SipMediaApplicationId")]
    pub sip_media_application_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateSipMediaApplicationResponse {
    /// <p>The updated SIP media application details.</p>
    #[serde(rename = "SipMediaApplication")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sip_media_application: Option<SipMediaApplication>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateSipRuleRequest {
    /// <p>The new value specified to indicate whether the rule is disabled.</p>
    #[serde(rename = "Disabled")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub disabled: Option<bool>,
    /// <p>The new name for the specified SIP rule.</p>
    #[serde(rename = "Name")]
    pub name: String,
    /// <p>The SIP rule ID.</p>
    #[serde(rename = "SipRuleId")]
    pub sip_rule_id: String,
    /// <p>The new value of the list of target applications.</p>
    #[serde(rename = "TargetApplications")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub target_applications: Option<Vec<SipRuleTargetApplication>>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateSipRuleResponse {
    /// <p>Updated SIP rule details.</p>
    #[serde(rename = "SipRule")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sip_rule: Option<SipRule>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateUserRequest {
    /// <p>The Amazon Chime account ID.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>The Alexa for Business metadata.</p>
    #[serde(rename = "AlexaForBusinessMetadata")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub alexa_for_business_metadata: Option<AlexaForBusinessMetadata>,
    /// <p>The user license type to update. This must be a supported license type for the Amazon Chime account that the user belongs to.</p>
    #[serde(rename = "LicenseType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub license_type: Option<String>,
    /// <p>The user ID.</p>
    #[serde(rename = "UserId")]
    pub user_id: String,
    /// <p>The user type.</p>
    #[serde(rename = "UserType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub user_type: Option<String>,
}

/// <p>The user ID and user fields to update, used with the <a>BatchUpdateUser</a> action.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateUserRequestItem {
    /// <p>The Alexa for Business metadata.</p>
    #[serde(rename = "AlexaForBusinessMetadata")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub alexa_for_business_metadata: Option<AlexaForBusinessMetadata>,
    /// <p>The user license type.</p>
    #[serde(rename = "LicenseType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub license_type: Option<String>,
    /// <p>The user ID.</p>
    #[serde(rename = "UserId")]
    pub user_id: String,
    /// <p>The user type.</p>
    #[serde(rename = "UserType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub user_type: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateUserResponse {
    /// <p>The updated user details.</p>
    #[serde(rename = "User")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub user: Option<User>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateUserSettingsRequest {
    /// <p>The Amazon Chime account ID.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>The user ID.</p>
    #[serde(rename = "UserId")]
    pub user_id: String,
    /// <p>The user settings to update.</p>
    #[serde(rename = "UserSettings")]
    pub user_settings: UserSettings,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateVoiceConnectorGroupRequest {
    /// <p>The name of the Amazon Chime Voice Connector group.</p>
    #[serde(rename = "Name")]
    pub name: String,
    /// <p>The Amazon Chime Voice Connector group ID.</p>
    #[serde(rename = "VoiceConnectorGroupId")]
    pub voice_connector_group_id: String,
    /// <p>The <code>VoiceConnectorItems</code> to associate with the group.</p>
    #[serde(rename = "VoiceConnectorItems")]
    pub voice_connector_items: Vec<VoiceConnectorItem>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateVoiceConnectorGroupResponse {
    /// <p>The updated Amazon Chime Voice Connector group details.</p>
    #[serde(rename = "VoiceConnectorGroup")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub voice_connector_group: Option<VoiceConnectorGroup>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateVoiceConnectorRequest {
    /// <p>The name of the Amazon Chime Voice Connector.</p>
    #[serde(rename = "Name")]
    pub name: String,
    /// <p>When enabled, requires encryption for the Amazon Chime Voice Connector.</p>
    #[serde(rename = "RequireEncryption")]
    pub require_encryption: bool,
    /// <p>The Amazon Chime Voice Connector ID.</p>
    #[serde(rename = "VoiceConnectorId")]
    pub voice_connector_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateVoiceConnectorResponse {
    /// <p>The updated Amazon Chime Voice Connector details.</p>
    #[serde(rename = "VoiceConnector")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub voice_connector: Option<VoiceConnector>,
}

/// <p>The user on the Amazon Chime account.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct User {
    /// <p>The Amazon Chime account ID.</p>
    #[serde(rename = "AccountId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub account_id: Option<String>,
    /// <p>The Alexa for Business metadata.</p>
    #[serde(rename = "AlexaForBusinessMetadata")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub alexa_for_business_metadata: Option<AlexaForBusinessMetadata>,
    /// <p>The display name of the user.</p>
    #[serde(rename = "DisplayName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    /// <p>Date and time when the user is invited to the Amazon Chime account, in ISO 8601 format.</p>
    #[serde(rename = "InvitedOn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub invited_on: Option<f64>,
    /// <p>The license type for the user.</p>
    #[serde(rename = "LicenseType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub license_type: Option<String>,
    /// <p>The user's personal meeting PIN.</p>
    #[serde(rename = "PersonalPIN")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub personal_pin: Option<String>,
    /// <p>The primary email address of the user.</p>
    #[serde(rename = "PrimaryEmail")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub primary_email: Option<String>,
    /// <p>The primary phone number associated with the user.</p>
    #[serde(rename = "PrimaryProvisionedNumber")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub primary_provisioned_number: Option<String>,
    /// <p>Date and time when the user is registered, in ISO 8601 format.</p>
    #[serde(rename = "RegisteredOn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub registered_on: Option<f64>,
    /// <p>The user ID.</p>
    #[serde(rename = "UserId")]
    pub user_id: String,
    /// <p>The user invite status.</p>
    #[serde(rename = "UserInvitationStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub user_invitation_status: Option<String>,
    /// <p>The user registration status.</p>
    #[serde(rename = "UserRegistrationStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub user_registration_status: Option<String>,
    /// <p>The user type.</p>
    #[serde(rename = "UserType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub user_type: Option<String>,
}

/// <p>The list of errors returned when errors are encountered during the <a>BatchSuspendUser</a>, <a>BatchUnsuspendUser</a>, or <a>BatchUpdateUser</a> actions. This includes user IDs, error codes, and error messages.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UserError {
    /// <p>The error code.</p>
    #[serde(rename = "ErrorCode")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub error_code: Option<String>,
    /// <p>The error message.</p>
    #[serde(rename = "ErrorMessage")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub error_message: Option<String>,
    /// <p>The user ID for which the action failed.</p>
    #[serde(rename = "UserId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub user_id: Option<String>,
}

/// <p>Settings associated with an Amazon Chime user, including inbound and outbound calling and text messaging.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct UserSettings {
    /// <p>The telephony settings associated with the user.</p>
    #[serde(rename = "Telephony")]
    pub telephony: TelephonySettings,
}

/// <p>The Amazon Chime Voice Connector configuration, including outbound host name and encryption settings.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct VoiceConnector {
    /// <p> The AWS Region in which the Amazon Chime Voice Connector is created. Default: <code>us-east-1</code>. </p>
    #[serde(rename = "AwsRegion")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub aws_region: Option<String>,
    /// <p>The Amazon Chime Voice Connector creation timestamp, in ISO 8601 format.</p>
    #[serde(rename = "CreatedTimestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_timestamp: Option<f64>,
    /// <p>The name of the Amazon Chime Voice Connector.</p>
    #[serde(rename = "Name")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    /// <p>The outbound host name for the Amazon Chime Voice Connector.</p>
    #[serde(rename = "OutboundHostName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub outbound_host_name: Option<String>,
    /// <p>Designates whether encryption is required for the Amazon Chime Voice Connector.</p>
    #[serde(rename = "RequireEncryption")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub require_encryption: Option<bool>,
    /// <p>The updated Amazon Chime Voice Connector timestamp, in ISO 8601 format.</p>
    #[serde(rename = "UpdatedTimestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub updated_timestamp: Option<f64>,
    /// <p>The Amazon Chime Voice Connector ID.</p>
    #[serde(rename = "VoiceConnectorId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub voice_connector_id: Option<String>,
}

/// <p>The Amazon Chime Voice Connector group configuration, including associated Amazon Chime Voice Connectors. You can include Amazon Chime Voice Connectors from different AWS Regions in your group. This creates a fault tolerant mechanism for fallback in case of availability events.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct VoiceConnectorGroup {
    /// <p>The Amazon Chime Voice Connector group creation time stamp, in ISO 8601 format.</p>
    #[serde(rename = "CreatedTimestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_timestamp: Option<f64>,
    /// <p>The name of the Amazon Chime Voice Connector group.</p>
    #[serde(rename = "Name")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    /// <p>The updated Amazon Chime Voice Connector group time stamp, in ISO 8601 format.</p>
    #[serde(rename = "UpdatedTimestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub updated_timestamp: Option<f64>,
    /// <p>The Amazon Chime Voice Connector group ID.</p>
    #[serde(rename = "VoiceConnectorGroupId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub voice_connector_group_id: Option<String>,
    /// <p>The Amazon Chime Voice Connectors to which to route inbound calls.</p>
    #[serde(rename = "VoiceConnectorItems")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub voice_connector_items: Option<Vec<VoiceConnectorItem>>,
}

/// <p>For Amazon Chime Voice Connector groups, the Amazon Chime Voice Connectors to which to route inbound calls. Includes priority configuration settings. Limit: 3 <code>VoiceConnectorItems</code> per Amazon Chime Voice Connector group.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct VoiceConnectorItem {
    /// <p>The priority associated with the Amazon Chime Voice Connector, with 1 being the highest priority. Higher priority Amazon Chime Voice Connectors are attempted first.</p>
    #[serde(rename = "Priority")]
    pub priority: i64,
    /// <p>The Amazon Chime Voice Connector ID.</p>
    #[serde(rename = "VoiceConnectorId")]
    pub voice_connector_id: String,
}

/// <p>The Amazon Chime Voice Connector settings. Includes any Amazon S3 buckets designated for storing call detail records.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct VoiceConnectorSettings {
    /// <p>The Amazon S3 bucket designated for call detail record storage.</p>
    #[serde(rename = "CdrBucket")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub cdr_bucket: Option<String>,
}

/// Errors returned by AssociatePhoneNumberWithUser
#[derive(Debug, PartialEq)]
pub enum AssociatePhoneNumberWithUserError {
    /// <p>You don't have permissions to perform the requested operation.</p>
    AccessDenied(String),
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl AssociatePhoneNumberWithUserError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<AssociatePhoneNumberWithUserError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(AssociatePhoneNumberWithUserError::AccessDenied(
                        err.msg,
                    ))
                }
                "BadRequestException" => {
                    return RusotoError::Service(AssociatePhoneNumberWithUserError::BadRequest(
                        err.msg,
                    ))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(AssociatePhoneNumberWithUserError::Forbidden(
                        err.msg,
                    ))
                }
                "NotFoundException" => {
                    return RusotoError::Service(AssociatePhoneNumberWithUserError::NotFound(
                        err.msg,
                    ))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(AssociatePhoneNumberWithUserError::ServiceFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        AssociatePhoneNumberWithUserError::ServiceUnavailable(err.msg),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(
                        AssociatePhoneNumberWithUserError::ThrottledClient(err.msg),
                    )
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        AssociatePhoneNumberWithUserError::UnauthorizedClient(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for AssociatePhoneNumberWithUserError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            AssociatePhoneNumberWithUserError::AccessDenied(ref cause) => write!(f, "{}", cause),
            AssociatePhoneNumberWithUserError::BadRequest(ref cause) => write!(f, "{}", cause),
            AssociatePhoneNumberWithUserError::Forbidden(ref cause) => write!(f, "{}", cause),
            AssociatePhoneNumberWithUserError::NotFound(ref cause) => write!(f, "{}", cause),
            AssociatePhoneNumberWithUserError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            AssociatePhoneNumberWithUserError::ServiceUnavailable(ref cause) => {
                write!(f, "{}", cause)
            }
            AssociatePhoneNumberWithUserError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            AssociatePhoneNumberWithUserError::UnauthorizedClient(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for AssociatePhoneNumberWithUserError {}
/// Errors returned by AssociatePhoneNumbersWithVoiceConnector
#[derive(Debug, PartialEq)]
pub enum AssociatePhoneNumbersWithVoiceConnectorError {
    /// <p>You don't have permissions to perform the requested operation.</p>
    AccessDenied(String),
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl AssociatePhoneNumbersWithVoiceConnectorError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<AssociatePhoneNumbersWithVoiceConnectorError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(
                        AssociatePhoneNumbersWithVoiceConnectorError::AccessDenied(err.msg),
                    )
                }
                "BadRequestException" => {
                    return RusotoError::Service(
                        AssociatePhoneNumbersWithVoiceConnectorError::BadRequest(err.msg),
                    )
                }
                "ForbiddenException" => {
                    return RusotoError::Service(
                        AssociatePhoneNumbersWithVoiceConnectorError::Forbidden(err.msg),
                    )
                }
                "NotFoundException" => {
                    return RusotoError::Service(
                        AssociatePhoneNumbersWithVoiceConnectorError::NotFound(err.msg),
                    )
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(
                        AssociatePhoneNumbersWithVoiceConnectorError::ServiceFailure(err.msg),
                    )
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        AssociatePhoneNumbersWithVoiceConnectorError::ServiceUnavailable(err.msg),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(
                        AssociatePhoneNumbersWithVoiceConnectorError::ThrottledClient(err.msg),
                    )
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        AssociatePhoneNumbersWithVoiceConnectorError::UnauthorizedClient(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for AssociatePhoneNumbersWithVoiceConnectorError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            AssociatePhoneNumbersWithVoiceConnectorError::AccessDenied(ref cause) => {
                write!(f, "{}", cause)
            }
            AssociatePhoneNumbersWithVoiceConnectorError::BadRequest(ref cause) => {
                write!(f, "{}", cause)
            }
            AssociatePhoneNumbersWithVoiceConnectorError::Forbidden(ref cause) => {
                write!(f, "{}", cause)
            }
            AssociatePhoneNumbersWithVoiceConnectorError::NotFound(ref cause) => {
                write!(f, "{}", cause)
            }
            AssociatePhoneNumbersWithVoiceConnectorError::ServiceFailure(ref cause) => {
                write!(f, "{}", cause)
            }
            AssociatePhoneNumbersWithVoiceConnectorError::ServiceUnavailable(ref cause) => {
                write!(f, "{}", cause)
            }
            AssociatePhoneNumbersWithVoiceConnectorError::ThrottledClient(ref cause) => {
                write!(f, "{}", cause)
            }
            AssociatePhoneNumbersWithVoiceConnectorError::UnauthorizedClient(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for AssociatePhoneNumbersWithVoiceConnectorError {}
/// Errors returned by AssociatePhoneNumbersWithVoiceConnectorGroup
#[derive(Debug, PartialEq)]
pub enum AssociatePhoneNumbersWithVoiceConnectorGroupError {
    /// <p>You don't have permissions to perform the requested operation.</p>
    AccessDenied(String),
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl AssociatePhoneNumbersWithVoiceConnectorGroupError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<AssociatePhoneNumbersWithVoiceConnectorGroupError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(
                        AssociatePhoneNumbersWithVoiceConnectorGroupError::AccessDenied(err.msg),
                    )
                }
                "BadRequestException" => {
                    return RusotoError::Service(
                        AssociatePhoneNumbersWithVoiceConnectorGroupError::BadRequest(err.msg),
                    )
                }
                "ForbiddenException" => {
                    return RusotoError::Service(
                        AssociatePhoneNumbersWithVoiceConnectorGroupError::Forbidden(err.msg),
                    )
                }
                "NotFoundException" => {
                    return RusotoError::Service(
                        AssociatePhoneNumbersWithVoiceConnectorGroupError::NotFound(err.msg),
                    )
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(
                        AssociatePhoneNumbersWithVoiceConnectorGroupError::ServiceFailure(err.msg),
                    )
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        AssociatePhoneNumbersWithVoiceConnectorGroupError::ServiceUnavailable(
                            err.msg,
                        ),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(
                        AssociatePhoneNumbersWithVoiceConnectorGroupError::ThrottledClient(err.msg),
                    )
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        AssociatePhoneNumbersWithVoiceConnectorGroupError::UnauthorizedClient(
                            err.msg,
                        ),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for AssociatePhoneNumbersWithVoiceConnectorGroupError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            AssociatePhoneNumbersWithVoiceConnectorGroupError::AccessDenied(ref cause) => {
                write!(f, "{}", cause)
            }
            AssociatePhoneNumbersWithVoiceConnectorGroupError::BadRequest(ref cause) => {
                write!(f, "{}", cause)
            }
            AssociatePhoneNumbersWithVoiceConnectorGroupError::Forbidden(ref cause) => {
                write!(f, "{}", cause)
            }
            AssociatePhoneNumbersWithVoiceConnectorGroupError::NotFound(ref cause) => {
                write!(f, "{}", cause)
            }
            AssociatePhoneNumbersWithVoiceConnectorGroupError::ServiceFailure(ref cause) => {
                write!(f, "{}", cause)
            }
            AssociatePhoneNumbersWithVoiceConnectorGroupError::ServiceUnavailable(ref cause) => {
                write!(f, "{}", cause)
            }
            AssociatePhoneNumbersWithVoiceConnectorGroupError::ThrottledClient(ref cause) => {
                write!(f, "{}", cause)
            }
            AssociatePhoneNumbersWithVoiceConnectorGroupError::UnauthorizedClient(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for AssociatePhoneNumbersWithVoiceConnectorGroupError {}
/// Errors returned by AssociateSigninDelegateGroupsWithAccount
#[derive(Debug, PartialEq)]
pub enum AssociateSigninDelegateGroupsWithAccountError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl AssociateSigninDelegateGroupsWithAccountError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<AssociateSigninDelegateGroupsWithAccountError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(
                        AssociateSigninDelegateGroupsWithAccountError::BadRequest(err.msg),
                    )
                }
                "ForbiddenException" => {
                    return RusotoError::Service(
                        AssociateSigninDelegateGroupsWithAccountError::Forbidden(err.msg),
                    )
                }
                "NotFoundException" => {
                    return RusotoError::Service(
                        AssociateSigninDelegateGroupsWithAccountError::NotFound(err.msg),
                    )
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(
                        AssociateSigninDelegateGroupsWithAccountError::ServiceFailure(err.msg),
                    )
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        AssociateSigninDelegateGroupsWithAccountError::ServiceUnavailable(err.msg),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(
                        AssociateSigninDelegateGroupsWithAccountError::ThrottledClient(err.msg),
                    )
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        AssociateSigninDelegateGroupsWithAccountError::UnauthorizedClient(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for AssociateSigninDelegateGroupsWithAccountError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            AssociateSigninDelegateGroupsWithAccountError::BadRequest(ref cause) => {
                write!(f, "{}", cause)
            }
            AssociateSigninDelegateGroupsWithAccountError::Forbidden(ref cause) => {
                write!(f, "{}", cause)
            }
            AssociateSigninDelegateGroupsWithAccountError::NotFound(ref cause) => {
                write!(f, "{}", cause)
            }
            AssociateSigninDelegateGroupsWithAccountError::ServiceFailure(ref cause) => {
                write!(f, "{}", cause)
            }
            AssociateSigninDelegateGroupsWithAccountError::ServiceUnavailable(ref cause) => {
                write!(f, "{}", cause)
            }
            AssociateSigninDelegateGroupsWithAccountError::ThrottledClient(ref cause) => {
                write!(f, "{}", cause)
            }
            AssociateSigninDelegateGroupsWithAccountError::UnauthorizedClient(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for AssociateSigninDelegateGroupsWithAccountError {}
/// Errors returned by BatchCreateAttendee
#[derive(Debug, PartialEq)]
pub enum BatchCreateAttendeeError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceeded(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl BatchCreateAttendeeError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<BatchCreateAttendeeError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(BatchCreateAttendeeError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(BatchCreateAttendeeError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(BatchCreateAttendeeError::NotFound(err.msg))
                }
                "ResourceLimitExceededException" => {
                    return RusotoError::Service(BatchCreateAttendeeError::ResourceLimitExceeded(
                        err.msg,
                    ))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(BatchCreateAttendeeError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(BatchCreateAttendeeError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(BatchCreateAttendeeError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(BatchCreateAttendeeError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for BatchCreateAttendeeError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            BatchCreateAttendeeError::BadRequest(ref cause) => write!(f, "{}", cause),
            BatchCreateAttendeeError::Forbidden(ref cause) => write!(f, "{}", cause),
            BatchCreateAttendeeError::NotFound(ref cause) => write!(f, "{}", cause),
            BatchCreateAttendeeError::ResourceLimitExceeded(ref cause) => write!(f, "{}", cause),
            BatchCreateAttendeeError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            BatchCreateAttendeeError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            BatchCreateAttendeeError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            BatchCreateAttendeeError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for BatchCreateAttendeeError {}
/// Errors returned by BatchCreateChannelMembership
#[derive(Debug, PartialEq)]
pub enum BatchCreateChannelMembershipError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl BatchCreateChannelMembershipError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<BatchCreateChannelMembershipError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(BatchCreateChannelMembershipError::BadRequest(
                        err.msg,
                    ))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(BatchCreateChannelMembershipError::Forbidden(
                        err.msg,
                    ))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(BatchCreateChannelMembershipError::ServiceFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        BatchCreateChannelMembershipError::ServiceUnavailable(err.msg),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(
                        BatchCreateChannelMembershipError::ThrottledClient(err.msg),
                    )
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        BatchCreateChannelMembershipError::UnauthorizedClient(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for BatchCreateChannelMembershipError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            BatchCreateChannelMembershipError::BadRequest(ref cause) => write!(f, "{}", cause),
            BatchCreateChannelMembershipError::Forbidden(ref cause) => write!(f, "{}", cause),
            BatchCreateChannelMembershipError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            BatchCreateChannelMembershipError::ServiceUnavailable(ref cause) => {
                write!(f, "{}", cause)
            }
            BatchCreateChannelMembershipError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            BatchCreateChannelMembershipError::UnauthorizedClient(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for BatchCreateChannelMembershipError {}
/// Errors returned by BatchCreateRoomMembership
#[derive(Debug, PartialEq)]
pub enum BatchCreateRoomMembershipError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl BatchCreateRoomMembershipError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<BatchCreateRoomMembershipError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(BatchCreateRoomMembershipError::BadRequest(
                        err.msg,
                    ))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(BatchCreateRoomMembershipError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(BatchCreateRoomMembershipError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(BatchCreateRoomMembershipError::ServiceFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        BatchCreateRoomMembershipError::ServiceUnavailable(err.msg),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(BatchCreateRoomMembershipError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        BatchCreateRoomMembershipError::UnauthorizedClient(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for BatchCreateRoomMembershipError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            BatchCreateRoomMembershipError::BadRequest(ref cause) => write!(f, "{}", cause),
            BatchCreateRoomMembershipError::Forbidden(ref cause) => write!(f, "{}", cause),
            BatchCreateRoomMembershipError::NotFound(ref cause) => write!(f, "{}", cause),
            BatchCreateRoomMembershipError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            BatchCreateRoomMembershipError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            BatchCreateRoomMembershipError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            BatchCreateRoomMembershipError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for BatchCreateRoomMembershipError {}
/// Errors returned by BatchDeletePhoneNumber
#[derive(Debug, PartialEq)]
pub enum BatchDeletePhoneNumberError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl BatchDeletePhoneNumberError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<BatchDeletePhoneNumberError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(BatchDeletePhoneNumberError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(BatchDeletePhoneNumberError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(BatchDeletePhoneNumberError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(BatchDeletePhoneNumberError::ServiceFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(BatchDeletePhoneNumberError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(BatchDeletePhoneNumberError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(BatchDeletePhoneNumberError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for BatchDeletePhoneNumberError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            BatchDeletePhoneNumberError::BadRequest(ref cause) => write!(f, "{}", cause),
            BatchDeletePhoneNumberError::Forbidden(ref cause) => write!(f, "{}", cause),
            BatchDeletePhoneNumberError::NotFound(ref cause) => write!(f, "{}", cause),
            BatchDeletePhoneNumberError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            BatchDeletePhoneNumberError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            BatchDeletePhoneNumberError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            BatchDeletePhoneNumberError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for BatchDeletePhoneNumberError {}
/// Errors returned by BatchSuspendUser
#[derive(Debug, PartialEq)]
pub enum BatchSuspendUserError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl BatchSuspendUserError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<BatchSuspendUserError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(BatchSuspendUserError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(BatchSuspendUserError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(BatchSuspendUserError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(BatchSuspendUserError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(BatchSuspendUserError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(BatchSuspendUserError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(BatchSuspendUserError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for BatchSuspendUserError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            BatchSuspendUserError::BadRequest(ref cause) => write!(f, "{}", cause),
            BatchSuspendUserError::Forbidden(ref cause) => write!(f, "{}", cause),
            BatchSuspendUserError::NotFound(ref cause) => write!(f, "{}", cause),
            BatchSuspendUserError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            BatchSuspendUserError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            BatchSuspendUserError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            BatchSuspendUserError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for BatchSuspendUserError {}
/// Errors returned by BatchUnsuspendUser
#[derive(Debug, PartialEq)]
pub enum BatchUnsuspendUserError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl BatchUnsuspendUserError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<BatchUnsuspendUserError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(BatchUnsuspendUserError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(BatchUnsuspendUserError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(BatchUnsuspendUserError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(BatchUnsuspendUserError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(BatchUnsuspendUserError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(BatchUnsuspendUserError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(BatchUnsuspendUserError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for BatchUnsuspendUserError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            BatchUnsuspendUserError::BadRequest(ref cause) => write!(f, "{}", cause),
            BatchUnsuspendUserError::Forbidden(ref cause) => write!(f, "{}", cause),
            BatchUnsuspendUserError::NotFound(ref cause) => write!(f, "{}", cause),
            BatchUnsuspendUserError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            BatchUnsuspendUserError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            BatchUnsuspendUserError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            BatchUnsuspendUserError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for BatchUnsuspendUserError {}
/// Errors returned by BatchUpdatePhoneNumber
#[derive(Debug, PartialEq)]
pub enum BatchUpdatePhoneNumberError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl BatchUpdatePhoneNumberError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<BatchUpdatePhoneNumberError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(BatchUpdatePhoneNumberError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(BatchUpdatePhoneNumberError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(BatchUpdatePhoneNumberError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(BatchUpdatePhoneNumberError::ServiceFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(BatchUpdatePhoneNumberError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(BatchUpdatePhoneNumberError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(BatchUpdatePhoneNumberError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for BatchUpdatePhoneNumberError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            BatchUpdatePhoneNumberError::BadRequest(ref cause) => write!(f, "{}", cause),
            BatchUpdatePhoneNumberError::Forbidden(ref cause) => write!(f, "{}", cause),
            BatchUpdatePhoneNumberError::NotFound(ref cause) => write!(f, "{}", cause),
            BatchUpdatePhoneNumberError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            BatchUpdatePhoneNumberError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            BatchUpdatePhoneNumberError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            BatchUpdatePhoneNumberError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for BatchUpdatePhoneNumberError {}
/// Errors returned by BatchUpdateUser
#[derive(Debug, PartialEq)]
pub enum BatchUpdateUserError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl BatchUpdateUserError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<BatchUpdateUserError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(BatchUpdateUserError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(BatchUpdateUserError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(BatchUpdateUserError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(BatchUpdateUserError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(BatchUpdateUserError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(BatchUpdateUserError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(BatchUpdateUserError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for BatchUpdateUserError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            BatchUpdateUserError::BadRequest(ref cause) => write!(f, "{}", cause),
            BatchUpdateUserError::Forbidden(ref cause) => write!(f, "{}", cause),
            BatchUpdateUserError::NotFound(ref cause) => write!(f, "{}", cause),
            BatchUpdateUserError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            BatchUpdateUserError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            BatchUpdateUserError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            BatchUpdateUserError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for BatchUpdateUserError {}
/// Errors returned by CreateAccount
#[derive(Debug, PartialEq)]
pub enum CreateAccountError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl CreateAccountError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateAccountError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(CreateAccountError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(CreateAccountError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(CreateAccountError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(CreateAccountError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(CreateAccountError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(CreateAccountError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(CreateAccountError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateAccountError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateAccountError::BadRequest(ref cause) => write!(f, "{}", cause),
            CreateAccountError::Forbidden(ref cause) => write!(f, "{}", cause),
            CreateAccountError::NotFound(ref cause) => write!(f, "{}", cause),
            CreateAccountError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            CreateAccountError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            CreateAccountError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            CreateAccountError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateAccountError {}
/// Errors returned by CreateAppInstance
#[derive(Debug, PartialEq)]
pub enum CreateAppInstanceError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The request could not be processed because of conflict in the current state of the resource.</p>
    Conflict(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceeded(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl CreateAppInstanceError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateAppInstanceError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(CreateAppInstanceError::BadRequest(err.msg))
                }
                "ConflictException" => {
                    return RusotoError::Service(CreateAppInstanceError::Conflict(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(CreateAppInstanceError::Forbidden(err.msg))
                }
                "ResourceLimitExceededException" => {
                    return RusotoError::Service(CreateAppInstanceError::ResourceLimitExceeded(
                        err.msg,
                    ))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(CreateAppInstanceError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(CreateAppInstanceError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(CreateAppInstanceError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(CreateAppInstanceError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateAppInstanceError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateAppInstanceError::BadRequest(ref cause) => write!(f, "{}", cause),
            CreateAppInstanceError::Conflict(ref cause) => write!(f, "{}", cause),
            CreateAppInstanceError::Forbidden(ref cause) => write!(f, "{}", cause),
            CreateAppInstanceError::ResourceLimitExceeded(ref cause) => write!(f, "{}", cause),
            CreateAppInstanceError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            CreateAppInstanceError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            CreateAppInstanceError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            CreateAppInstanceError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateAppInstanceError {}
/// Errors returned by CreateAppInstanceAdmin
#[derive(Debug, PartialEq)]
pub enum CreateAppInstanceAdminError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The request could not be processed because of conflict in the current state of the resource.</p>
    Conflict(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceeded(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl CreateAppInstanceAdminError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateAppInstanceAdminError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(CreateAppInstanceAdminError::BadRequest(err.msg))
                }
                "ConflictException" => {
                    return RusotoError::Service(CreateAppInstanceAdminError::Conflict(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(CreateAppInstanceAdminError::Forbidden(err.msg))
                }
                "ResourceLimitExceededException" => {
                    return RusotoError::Service(
                        CreateAppInstanceAdminError::ResourceLimitExceeded(err.msg),
                    )
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(CreateAppInstanceAdminError::ServiceFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(CreateAppInstanceAdminError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(CreateAppInstanceAdminError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(CreateAppInstanceAdminError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateAppInstanceAdminError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateAppInstanceAdminError::BadRequest(ref cause) => write!(f, "{}", cause),
            CreateAppInstanceAdminError::Conflict(ref cause) => write!(f, "{}", cause),
            CreateAppInstanceAdminError::Forbidden(ref cause) => write!(f, "{}", cause),
            CreateAppInstanceAdminError::ResourceLimitExceeded(ref cause) => write!(f, "{}", cause),
            CreateAppInstanceAdminError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            CreateAppInstanceAdminError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            CreateAppInstanceAdminError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            CreateAppInstanceAdminError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateAppInstanceAdminError {}
/// Errors returned by CreateAppInstanceUser
#[derive(Debug, PartialEq)]
pub enum CreateAppInstanceUserError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The request could not be processed because of conflict in the current state of the resource.</p>
    Conflict(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceeded(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl CreateAppInstanceUserError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateAppInstanceUserError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(CreateAppInstanceUserError::BadRequest(err.msg))
                }
                "ConflictException" => {
                    return RusotoError::Service(CreateAppInstanceUserError::Conflict(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(CreateAppInstanceUserError::Forbidden(err.msg))
                }
                "ResourceLimitExceededException" => {
                    return RusotoError::Service(CreateAppInstanceUserError::ResourceLimitExceeded(
                        err.msg,
                    ))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(CreateAppInstanceUserError::ServiceFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(CreateAppInstanceUserError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(CreateAppInstanceUserError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(CreateAppInstanceUserError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateAppInstanceUserError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateAppInstanceUserError::BadRequest(ref cause) => write!(f, "{}", cause),
            CreateAppInstanceUserError::Conflict(ref cause) => write!(f, "{}", cause),
            CreateAppInstanceUserError::Forbidden(ref cause) => write!(f, "{}", cause),
            CreateAppInstanceUserError::ResourceLimitExceeded(ref cause) => write!(f, "{}", cause),
            CreateAppInstanceUserError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            CreateAppInstanceUserError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            CreateAppInstanceUserError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            CreateAppInstanceUserError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateAppInstanceUserError {}
/// Errors returned by CreateAttendee
#[derive(Debug, PartialEq)]
pub enum CreateAttendeeError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceeded(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl CreateAttendeeError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateAttendeeError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(CreateAttendeeError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(CreateAttendeeError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(CreateAttendeeError::NotFound(err.msg))
                }
                "ResourceLimitExceededException" => {
                    return RusotoError::Service(CreateAttendeeError::ResourceLimitExceeded(
                        err.msg,
                    ))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(CreateAttendeeError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(CreateAttendeeError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(CreateAttendeeError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(CreateAttendeeError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateAttendeeError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateAttendeeError::BadRequest(ref cause) => write!(f, "{}", cause),
            CreateAttendeeError::Forbidden(ref cause) => write!(f, "{}", cause),
            CreateAttendeeError::NotFound(ref cause) => write!(f, "{}", cause),
            CreateAttendeeError::ResourceLimitExceeded(ref cause) => write!(f, "{}", cause),
            CreateAttendeeError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            CreateAttendeeError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            CreateAttendeeError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            CreateAttendeeError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateAttendeeError {}
/// Errors returned by CreateBot
#[derive(Debug, PartialEq)]
pub enum CreateBotError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceeded(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl CreateBotError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateBotError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(CreateBotError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(CreateBotError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(CreateBotError::NotFound(err.msg))
                }
                "ResourceLimitExceededException" => {
                    return RusotoError::Service(CreateBotError::ResourceLimitExceeded(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(CreateBotError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(CreateBotError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(CreateBotError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(CreateBotError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateBotError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateBotError::BadRequest(ref cause) => write!(f, "{}", cause),
            CreateBotError::Forbidden(ref cause) => write!(f, "{}", cause),
            CreateBotError::NotFound(ref cause) => write!(f, "{}", cause),
            CreateBotError::ResourceLimitExceeded(ref cause) => write!(f, "{}", cause),
            CreateBotError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            CreateBotError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            CreateBotError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            CreateBotError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateBotError {}
/// Errors returned by CreateChannel
#[derive(Debug, PartialEq)]
pub enum CreateChannelError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The request could not be processed because of conflict in the current state of the resource.</p>
    Conflict(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceeded(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl CreateChannelError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateChannelError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(CreateChannelError::BadRequest(err.msg))
                }
                "ConflictException" => {
                    return RusotoError::Service(CreateChannelError::Conflict(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(CreateChannelError::Forbidden(err.msg))
                }
                "ResourceLimitExceededException" => {
                    return RusotoError::Service(CreateChannelError::ResourceLimitExceeded(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(CreateChannelError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(CreateChannelError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(CreateChannelError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(CreateChannelError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateChannelError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateChannelError::BadRequest(ref cause) => write!(f, "{}", cause),
            CreateChannelError::Conflict(ref cause) => write!(f, "{}", cause),
            CreateChannelError::Forbidden(ref cause) => write!(f, "{}", cause),
            CreateChannelError::ResourceLimitExceeded(ref cause) => write!(f, "{}", cause),
            CreateChannelError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            CreateChannelError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            CreateChannelError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            CreateChannelError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateChannelError {}
/// Errors returned by CreateChannelBan
#[derive(Debug, PartialEq)]
pub enum CreateChannelBanError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The request could not be processed because of conflict in the current state of the resource.</p>
    Conflict(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceeded(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl CreateChannelBanError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateChannelBanError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(CreateChannelBanError::BadRequest(err.msg))
                }
                "ConflictException" => {
                    return RusotoError::Service(CreateChannelBanError::Conflict(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(CreateChannelBanError::Forbidden(err.msg))
                }
                "ResourceLimitExceededException" => {
                    return RusotoError::Service(CreateChannelBanError::ResourceLimitExceeded(
                        err.msg,
                    ))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(CreateChannelBanError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(CreateChannelBanError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(CreateChannelBanError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(CreateChannelBanError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateChannelBanError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateChannelBanError::BadRequest(ref cause) => write!(f, "{}", cause),
            CreateChannelBanError::Conflict(ref cause) => write!(f, "{}", cause),
            CreateChannelBanError::Forbidden(ref cause) => write!(f, "{}", cause),
            CreateChannelBanError::ResourceLimitExceeded(ref cause) => write!(f, "{}", cause),
            CreateChannelBanError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            CreateChannelBanError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            CreateChannelBanError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            CreateChannelBanError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateChannelBanError {}
/// Errors returned by CreateChannelMembership
#[derive(Debug, PartialEq)]
pub enum CreateChannelMembershipError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The request could not be processed because of conflict in the current state of the resource.</p>
    Conflict(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceeded(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl CreateChannelMembershipError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateChannelMembershipError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(CreateChannelMembershipError::BadRequest(err.msg))
                }
                "ConflictException" => {
                    return RusotoError::Service(CreateChannelMembershipError::Conflict(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(CreateChannelMembershipError::Forbidden(err.msg))
                }
                "ResourceLimitExceededException" => {
                    return RusotoError::Service(
                        CreateChannelMembershipError::ResourceLimitExceeded(err.msg),
                    )
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(CreateChannelMembershipError::ServiceFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(CreateChannelMembershipError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(CreateChannelMembershipError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(CreateChannelMembershipError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateChannelMembershipError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateChannelMembershipError::BadRequest(ref cause) => write!(f, "{}", cause),
            CreateChannelMembershipError::Conflict(ref cause) => write!(f, "{}", cause),
            CreateChannelMembershipError::Forbidden(ref cause) => write!(f, "{}", cause),
            CreateChannelMembershipError::ResourceLimitExceeded(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateChannelMembershipError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            CreateChannelMembershipError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            CreateChannelMembershipError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            CreateChannelMembershipError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateChannelMembershipError {}
/// Errors returned by CreateChannelModerator
#[derive(Debug, PartialEq)]
pub enum CreateChannelModeratorError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The request could not be processed because of conflict in the current state of the resource.</p>
    Conflict(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceeded(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl CreateChannelModeratorError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateChannelModeratorError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(CreateChannelModeratorError::BadRequest(err.msg))
                }
                "ConflictException" => {
                    return RusotoError::Service(CreateChannelModeratorError::Conflict(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(CreateChannelModeratorError::Forbidden(err.msg))
                }
                "ResourceLimitExceededException" => {
                    return RusotoError::Service(
                        CreateChannelModeratorError::ResourceLimitExceeded(err.msg),
                    )
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(CreateChannelModeratorError::ServiceFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(CreateChannelModeratorError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(CreateChannelModeratorError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(CreateChannelModeratorError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateChannelModeratorError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateChannelModeratorError::BadRequest(ref cause) => write!(f, "{}", cause),
            CreateChannelModeratorError::Conflict(ref cause) => write!(f, "{}", cause),
            CreateChannelModeratorError::Forbidden(ref cause) => write!(f, "{}", cause),
            CreateChannelModeratorError::ResourceLimitExceeded(ref cause) => write!(f, "{}", cause),
            CreateChannelModeratorError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            CreateChannelModeratorError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            CreateChannelModeratorError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            CreateChannelModeratorError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateChannelModeratorError {}
/// Errors returned by CreateMeeting
#[derive(Debug, PartialEq)]
pub enum CreateMeetingError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceeded(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl CreateMeetingError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateMeetingError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(CreateMeetingError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(CreateMeetingError::Forbidden(err.msg))
                }
                "ResourceLimitExceededException" => {
                    return RusotoError::Service(CreateMeetingError::ResourceLimitExceeded(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(CreateMeetingError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(CreateMeetingError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(CreateMeetingError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(CreateMeetingError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateMeetingError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateMeetingError::BadRequest(ref cause) => write!(f, "{}", cause),
            CreateMeetingError::Forbidden(ref cause) => write!(f, "{}", cause),
            CreateMeetingError::ResourceLimitExceeded(ref cause) => write!(f, "{}", cause),
            CreateMeetingError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            CreateMeetingError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            CreateMeetingError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            CreateMeetingError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateMeetingError {}
/// Errors returned by CreateMeetingDialOut
#[derive(Debug, PartialEq)]
pub enum CreateMeetingDialOutError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceeded(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl CreateMeetingDialOutError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateMeetingDialOutError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(CreateMeetingDialOutError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(CreateMeetingDialOutError::Forbidden(err.msg))
                }
                "ResourceLimitExceededException" => {
                    return RusotoError::Service(CreateMeetingDialOutError::ResourceLimitExceeded(
                        err.msg,
                    ))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(CreateMeetingDialOutError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(CreateMeetingDialOutError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(CreateMeetingDialOutError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(CreateMeetingDialOutError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateMeetingDialOutError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateMeetingDialOutError::BadRequest(ref cause) => write!(f, "{}", cause),
            CreateMeetingDialOutError::Forbidden(ref cause) => write!(f, "{}", cause),
            CreateMeetingDialOutError::ResourceLimitExceeded(ref cause) => write!(f, "{}", cause),
            CreateMeetingDialOutError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            CreateMeetingDialOutError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            CreateMeetingDialOutError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            CreateMeetingDialOutError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateMeetingDialOutError {}
/// Errors returned by CreateMeetingWithAttendees
#[derive(Debug, PartialEq)]
pub enum CreateMeetingWithAttendeesError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceeded(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl CreateMeetingWithAttendeesError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<CreateMeetingWithAttendeesError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(CreateMeetingWithAttendeesError::BadRequest(
                        err.msg,
                    ))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(CreateMeetingWithAttendeesError::Forbidden(
                        err.msg,
                    ))
                }
                "ResourceLimitExceededException" => {
                    return RusotoError::Service(
                        CreateMeetingWithAttendeesError::ResourceLimitExceeded(err.msg),
                    )
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(CreateMeetingWithAttendeesError::ServiceFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        CreateMeetingWithAttendeesError::ServiceUnavailable(err.msg),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(CreateMeetingWithAttendeesError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        CreateMeetingWithAttendeesError::UnauthorizedClient(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateMeetingWithAttendeesError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateMeetingWithAttendeesError::BadRequest(ref cause) => write!(f, "{}", cause),
            CreateMeetingWithAttendeesError::Forbidden(ref cause) => write!(f, "{}", cause),
            CreateMeetingWithAttendeesError::ResourceLimitExceeded(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateMeetingWithAttendeesError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            CreateMeetingWithAttendeesError::ServiceUnavailable(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateMeetingWithAttendeesError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            CreateMeetingWithAttendeesError::UnauthorizedClient(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for CreateMeetingWithAttendeesError {}
/// Errors returned by CreatePhoneNumberOrder
#[derive(Debug, PartialEq)]
pub enum CreatePhoneNumberOrderError {
    /// <p>You don't have permissions to perform the requested operation.</p>
    AccessDenied(String),
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceeded(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl CreatePhoneNumberOrderError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreatePhoneNumberOrderError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(CreatePhoneNumberOrderError::AccessDenied(err.msg))
                }
                "BadRequestException" => {
                    return RusotoError::Service(CreatePhoneNumberOrderError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(CreatePhoneNumberOrderError::Forbidden(err.msg))
                }
                "ResourceLimitExceededException" => {
                    return RusotoError::Service(
                        CreatePhoneNumberOrderError::ResourceLimitExceeded(err.msg),
                    )
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(CreatePhoneNumberOrderError::ServiceFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(CreatePhoneNumberOrderError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(CreatePhoneNumberOrderError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(CreatePhoneNumberOrderError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreatePhoneNumberOrderError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreatePhoneNumberOrderError::AccessDenied(ref cause) => write!(f, "{}", cause),
            CreatePhoneNumberOrderError::BadRequest(ref cause) => write!(f, "{}", cause),
            CreatePhoneNumberOrderError::Forbidden(ref cause) => write!(f, "{}", cause),
            CreatePhoneNumberOrderError::ResourceLimitExceeded(ref cause) => write!(f, "{}", cause),
            CreatePhoneNumberOrderError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            CreatePhoneNumberOrderError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            CreatePhoneNumberOrderError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            CreatePhoneNumberOrderError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreatePhoneNumberOrderError {}
/// Errors returned by CreateProxySession
#[derive(Debug, PartialEq)]
pub enum CreateProxySessionError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl CreateProxySessionError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateProxySessionError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(CreateProxySessionError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(CreateProxySessionError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(CreateProxySessionError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(CreateProxySessionError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(CreateProxySessionError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(CreateProxySessionError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(CreateProxySessionError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateProxySessionError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateProxySessionError::BadRequest(ref cause) => write!(f, "{}", cause),
            CreateProxySessionError::Forbidden(ref cause) => write!(f, "{}", cause),
            CreateProxySessionError::NotFound(ref cause) => write!(f, "{}", cause),
            CreateProxySessionError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            CreateProxySessionError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            CreateProxySessionError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            CreateProxySessionError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateProxySessionError {}
/// Errors returned by CreateRoom
#[derive(Debug, PartialEq)]
pub enum CreateRoomError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceeded(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl CreateRoomError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateRoomError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(CreateRoomError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(CreateRoomError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(CreateRoomError::NotFound(err.msg))
                }
                "ResourceLimitExceededException" => {
                    return RusotoError::Service(CreateRoomError::ResourceLimitExceeded(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(CreateRoomError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(CreateRoomError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(CreateRoomError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(CreateRoomError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateRoomError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateRoomError::BadRequest(ref cause) => write!(f, "{}", cause),
            CreateRoomError::Forbidden(ref cause) => write!(f, "{}", cause),
            CreateRoomError::NotFound(ref cause) => write!(f, "{}", cause),
            CreateRoomError::ResourceLimitExceeded(ref cause) => write!(f, "{}", cause),
            CreateRoomError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            CreateRoomError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            CreateRoomError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            CreateRoomError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateRoomError {}
/// Errors returned by CreateRoomMembership
#[derive(Debug, PartialEq)]
pub enum CreateRoomMembershipError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The request could not be processed because of conflict in the current state of the resource.</p>
    Conflict(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceeded(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl CreateRoomMembershipError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateRoomMembershipError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(CreateRoomMembershipError::BadRequest(err.msg))
                }
                "ConflictException" => {
                    return RusotoError::Service(CreateRoomMembershipError::Conflict(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(CreateRoomMembershipError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(CreateRoomMembershipError::NotFound(err.msg))
                }
                "ResourceLimitExceededException" => {
                    return RusotoError::Service(CreateRoomMembershipError::ResourceLimitExceeded(
                        err.msg,
                    ))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(CreateRoomMembershipError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(CreateRoomMembershipError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(CreateRoomMembershipError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(CreateRoomMembershipError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateRoomMembershipError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateRoomMembershipError::BadRequest(ref cause) => write!(f, "{}", cause),
            CreateRoomMembershipError::Conflict(ref cause) => write!(f, "{}", cause),
            CreateRoomMembershipError::Forbidden(ref cause) => write!(f, "{}", cause),
            CreateRoomMembershipError::NotFound(ref cause) => write!(f, "{}", cause),
            CreateRoomMembershipError::ResourceLimitExceeded(ref cause) => write!(f, "{}", cause),
            CreateRoomMembershipError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            CreateRoomMembershipError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            CreateRoomMembershipError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            CreateRoomMembershipError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateRoomMembershipError {}
/// Errors returned by CreateSipMediaApplication
#[derive(Debug, PartialEq)]
pub enum CreateSipMediaApplicationError {
    /// <p>You don't have permissions to perform the requested operation.</p>
    AccessDenied(String),
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The request could not be processed because of conflict in the current state of the resource.</p>
    Conflict(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceeded(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl CreateSipMediaApplicationError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateSipMediaApplicationError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(CreateSipMediaApplicationError::AccessDenied(
                        err.msg,
                    ))
                }
                "BadRequestException" => {
                    return RusotoError::Service(CreateSipMediaApplicationError::BadRequest(
                        err.msg,
                    ))
                }
                "ConflictException" => {
                    return RusotoError::Service(CreateSipMediaApplicationError::Conflict(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(CreateSipMediaApplicationError::Forbidden(err.msg))
                }
                "ResourceLimitExceededException" => {
                    return RusotoError::Service(
                        CreateSipMediaApplicationError::ResourceLimitExceeded(err.msg),
                    )
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(CreateSipMediaApplicationError::ServiceFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        CreateSipMediaApplicationError::ServiceUnavailable(err.msg),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(CreateSipMediaApplicationError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        CreateSipMediaApplicationError::UnauthorizedClient(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateSipMediaApplicationError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateSipMediaApplicationError::AccessDenied(ref cause) => write!(f, "{}", cause),
            CreateSipMediaApplicationError::BadRequest(ref cause) => write!(f, "{}", cause),
            CreateSipMediaApplicationError::Conflict(ref cause) => write!(f, "{}", cause),
            CreateSipMediaApplicationError::Forbidden(ref cause) => write!(f, "{}", cause),
            CreateSipMediaApplicationError::ResourceLimitExceeded(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateSipMediaApplicationError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            CreateSipMediaApplicationError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            CreateSipMediaApplicationError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            CreateSipMediaApplicationError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateSipMediaApplicationError {}
/// Errors returned by CreateSipMediaApplicationCall
#[derive(Debug, PartialEq)]
pub enum CreateSipMediaApplicationCallError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceeded(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl CreateSipMediaApplicationCallError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<CreateSipMediaApplicationCallError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(CreateSipMediaApplicationCallError::BadRequest(
                        err.msg,
                    ))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(CreateSipMediaApplicationCallError::Forbidden(
                        err.msg,
                    ))
                }
                "ResourceLimitExceededException" => {
                    return RusotoError::Service(
                        CreateSipMediaApplicationCallError::ResourceLimitExceeded(err.msg),
                    )
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(
                        CreateSipMediaApplicationCallError::ServiceFailure(err.msg),
                    )
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        CreateSipMediaApplicationCallError::ServiceUnavailable(err.msg),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(
                        CreateSipMediaApplicationCallError::ThrottledClient(err.msg),
                    )
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        CreateSipMediaApplicationCallError::UnauthorizedClient(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateSipMediaApplicationCallError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateSipMediaApplicationCallError::BadRequest(ref cause) => write!(f, "{}", cause),
            CreateSipMediaApplicationCallError::Forbidden(ref cause) => write!(f, "{}", cause),
            CreateSipMediaApplicationCallError::ResourceLimitExceeded(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateSipMediaApplicationCallError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            CreateSipMediaApplicationCallError::ServiceUnavailable(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateSipMediaApplicationCallError::ThrottledClient(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateSipMediaApplicationCallError::UnauthorizedClient(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for CreateSipMediaApplicationCallError {}
/// Errors returned by CreateSipRule
#[derive(Debug, PartialEq)]
pub enum CreateSipRuleError {
    /// <p>You don't have permissions to perform the requested operation.</p>
    AccessDenied(String),
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The request could not be processed because of conflict in the current state of the resource.</p>
    Conflict(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceeded(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl CreateSipRuleError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateSipRuleError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(CreateSipRuleError::AccessDenied(err.msg))
                }
                "BadRequestException" => {
                    return RusotoError::Service(CreateSipRuleError::BadRequest(err.msg))
                }
                "ConflictException" => {
                    return RusotoError::Service(CreateSipRuleError::Conflict(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(CreateSipRuleError::Forbidden(err.msg))
                }
                "ResourceLimitExceededException" => {
                    return RusotoError::Service(CreateSipRuleError::ResourceLimitExceeded(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(CreateSipRuleError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(CreateSipRuleError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(CreateSipRuleError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(CreateSipRuleError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateSipRuleError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateSipRuleError::AccessDenied(ref cause) => write!(f, "{}", cause),
            CreateSipRuleError::BadRequest(ref cause) => write!(f, "{}", cause),
            CreateSipRuleError::Conflict(ref cause) => write!(f, "{}", cause),
            CreateSipRuleError::Forbidden(ref cause) => write!(f, "{}", cause),
            CreateSipRuleError::ResourceLimitExceeded(ref cause) => write!(f, "{}", cause),
            CreateSipRuleError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            CreateSipRuleError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            CreateSipRuleError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            CreateSipRuleError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateSipRuleError {}
/// Errors returned by CreateUser
#[derive(Debug, PartialEq)]
pub enum CreateUserError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The request could not be processed because of conflict in the current state of the resource.</p>
    Conflict(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl CreateUserError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateUserError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(CreateUserError::BadRequest(err.msg))
                }
                "ConflictException" => {
                    return RusotoError::Service(CreateUserError::Conflict(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(CreateUserError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(CreateUserError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(CreateUserError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(CreateUserError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(CreateUserError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(CreateUserError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateUserError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateUserError::BadRequest(ref cause) => write!(f, "{}", cause),
            CreateUserError::Conflict(ref cause) => write!(f, "{}", cause),
            CreateUserError::Forbidden(ref cause) => write!(f, "{}", cause),
            CreateUserError::NotFound(ref cause) => write!(f, "{}", cause),
            CreateUserError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            CreateUserError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            CreateUserError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            CreateUserError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateUserError {}
/// Errors returned by CreateVoiceConnector
#[derive(Debug, PartialEq)]
pub enum CreateVoiceConnectorError {
    /// <p>You don't have permissions to perform the requested operation.</p>
    AccessDenied(String),
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceeded(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl CreateVoiceConnectorError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateVoiceConnectorError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(CreateVoiceConnectorError::AccessDenied(err.msg))
                }
                "BadRequestException" => {
                    return RusotoError::Service(CreateVoiceConnectorError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(CreateVoiceConnectorError::Forbidden(err.msg))
                }
                "ResourceLimitExceededException" => {
                    return RusotoError::Service(CreateVoiceConnectorError::ResourceLimitExceeded(
                        err.msg,
                    ))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(CreateVoiceConnectorError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(CreateVoiceConnectorError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(CreateVoiceConnectorError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(CreateVoiceConnectorError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateVoiceConnectorError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateVoiceConnectorError::AccessDenied(ref cause) => write!(f, "{}", cause),
            CreateVoiceConnectorError::BadRequest(ref cause) => write!(f, "{}", cause),
            CreateVoiceConnectorError::Forbidden(ref cause) => write!(f, "{}", cause),
            CreateVoiceConnectorError::ResourceLimitExceeded(ref cause) => write!(f, "{}", cause),
            CreateVoiceConnectorError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            CreateVoiceConnectorError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            CreateVoiceConnectorError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            CreateVoiceConnectorError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateVoiceConnectorError {}
/// Errors returned by CreateVoiceConnectorGroup
#[derive(Debug, PartialEq)]
pub enum CreateVoiceConnectorGroupError {
    /// <p>You don't have permissions to perform the requested operation.</p>
    AccessDenied(String),
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceeded(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl CreateVoiceConnectorGroupError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateVoiceConnectorGroupError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(CreateVoiceConnectorGroupError::AccessDenied(
                        err.msg,
                    ))
                }
                "BadRequestException" => {
                    return RusotoError::Service(CreateVoiceConnectorGroupError::BadRequest(
                        err.msg,
                    ))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(CreateVoiceConnectorGroupError::Forbidden(err.msg))
                }
                "ResourceLimitExceededException" => {
                    return RusotoError::Service(
                        CreateVoiceConnectorGroupError::ResourceLimitExceeded(err.msg),
                    )
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(CreateVoiceConnectorGroupError::ServiceFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        CreateVoiceConnectorGroupError::ServiceUnavailable(err.msg),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(CreateVoiceConnectorGroupError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        CreateVoiceConnectorGroupError::UnauthorizedClient(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateVoiceConnectorGroupError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateVoiceConnectorGroupError::AccessDenied(ref cause) => write!(f, "{}", cause),
            CreateVoiceConnectorGroupError::BadRequest(ref cause) => write!(f, "{}", cause),
            CreateVoiceConnectorGroupError::Forbidden(ref cause) => write!(f, "{}", cause),
            CreateVoiceConnectorGroupError::ResourceLimitExceeded(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateVoiceConnectorGroupError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            CreateVoiceConnectorGroupError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            CreateVoiceConnectorGroupError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            CreateVoiceConnectorGroupError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateVoiceConnectorGroupError {}
/// Errors returned by DeleteAccount
#[derive(Debug, PartialEq)]
pub enum DeleteAccountError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
    /// <p>The request was well-formed but was unable to be followed due to semantic errors.</p>
    UnprocessableEntity(String),
}

impl DeleteAccountError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteAccountError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(DeleteAccountError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(DeleteAccountError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(DeleteAccountError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(DeleteAccountError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DeleteAccountError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(DeleteAccountError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(DeleteAccountError::UnauthorizedClient(err.msg))
                }
                "UnprocessableEntityException" => {
                    return RusotoError::Service(DeleteAccountError::UnprocessableEntity(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteAccountError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteAccountError::BadRequest(ref cause) => write!(f, "{}", cause),
            DeleteAccountError::Forbidden(ref cause) => write!(f, "{}", cause),
            DeleteAccountError::NotFound(ref cause) => write!(f, "{}", cause),
            DeleteAccountError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            DeleteAccountError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DeleteAccountError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            DeleteAccountError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
            DeleteAccountError::UnprocessableEntity(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteAccountError {}
/// Errors returned by DeleteAppInstance
#[derive(Debug, PartialEq)]
pub enum DeleteAppInstanceError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl DeleteAppInstanceError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteAppInstanceError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(DeleteAppInstanceError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(DeleteAppInstanceError::Forbidden(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(DeleteAppInstanceError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DeleteAppInstanceError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(DeleteAppInstanceError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(DeleteAppInstanceError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteAppInstanceError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteAppInstanceError::BadRequest(ref cause) => write!(f, "{}", cause),
            DeleteAppInstanceError::Forbidden(ref cause) => write!(f, "{}", cause),
            DeleteAppInstanceError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            DeleteAppInstanceError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DeleteAppInstanceError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            DeleteAppInstanceError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteAppInstanceError {}
/// Errors returned by DeleteAppInstanceAdmin
#[derive(Debug, PartialEq)]
pub enum DeleteAppInstanceAdminError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The request could not be processed because of conflict in the current state of the resource.</p>
    Conflict(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl DeleteAppInstanceAdminError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteAppInstanceAdminError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(DeleteAppInstanceAdminError::BadRequest(err.msg))
                }
                "ConflictException" => {
                    return RusotoError::Service(DeleteAppInstanceAdminError::Conflict(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(DeleteAppInstanceAdminError::Forbidden(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(DeleteAppInstanceAdminError::ServiceFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DeleteAppInstanceAdminError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(DeleteAppInstanceAdminError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(DeleteAppInstanceAdminError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteAppInstanceAdminError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteAppInstanceAdminError::BadRequest(ref cause) => write!(f, "{}", cause),
            DeleteAppInstanceAdminError::Conflict(ref cause) => write!(f, "{}", cause),
            DeleteAppInstanceAdminError::Forbidden(ref cause) => write!(f, "{}", cause),
            DeleteAppInstanceAdminError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            DeleteAppInstanceAdminError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DeleteAppInstanceAdminError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            DeleteAppInstanceAdminError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteAppInstanceAdminError {}
/// Errors returned by DeleteAppInstanceStreamingConfigurations
#[derive(Debug, PartialEq)]
pub enum DeleteAppInstanceStreamingConfigurationsError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl DeleteAppInstanceStreamingConfigurationsError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<DeleteAppInstanceStreamingConfigurationsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(
                        DeleteAppInstanceStreamingConfigurationsError::BadRequest(err.msg),
                    )
                }
                "ForbiddenException" => {
                    return RusotoError::Service(
                        DeleteAppInstanceStreamingConfigurationsError::Forbidden(err.msg),
                    )
                }
                "NotFoundException" => {
                    return RusotoError::Service(
                        DeleteAppInstanceStreamingConfigurationsError::NotFound(err.msg),
                    )
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(
                        DeleteAppInstanceStreamingConfigurationsError::ServiceFailure(err.msg),
                    )
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        DeleteAppInstanceStreamingConfigurationsError::ServiceUnavailable(err.msg),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(
                        DeleteAppInstanceStreamingConfigurationsError::ThrottledClient(err.msg),
                    )
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        DeleteAppInstanceStreamingConfigurationsError::UnauthorizedClient(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteAppInstanceStreamingConfigurationsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteAppInstanceStreamingConfigurationsError::BadRequest(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteAppInstanceStreamingConfigurationsError::Forbidden(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteAppInstanceStreamingConfigurationsError::NotFound(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteAppInstanceStreamingConfigurationsError::ServiceFailure(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteAppInstanceStreamingConfigurationsError::ServiceUnavailable(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteAppInstanceStreamingConfigurationsError::ThrottledClient(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteAppInstanceStreamingConfigurationsError::UnauthorizedClient(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for DeleteAppInstanceStreamingConfigurationsError {}
/// Errors returned by DeleteAppInstanceUser
#[derive(Debug, PartialEq)]
pub enum DeleteAppInstanceUserError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl DeleteAppInstanceUserError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteAppInstanceUserError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(DeleteAppInstanceUserError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(DeleteAppInstanceUserError::Forbidden(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(DeleteAppInstanceUserError::ServiceFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DeleteAppInstanceUserError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(DeleteAppInstanceUserError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(DeleteAppInstanceUserError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteAppInstanceUserError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteAppInstanceUserError::BadRequest(ref cause) => write!(f, "{}", cause),
            DeleteAppInstanceUserError::Forbidden(ref cause) => write!(f, "{}", cause),
            DeleteAppInstanceUserError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            DeleteAppInstanceUserError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DeleteAppInstanceUserError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            DeleteAppInstanceUserError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteAppInstanceUserError {}
/// Errors returned by DeleteAttendee
#[derive(Debug, PartialEq)]
pub enum DeleteAttendeeError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl DeleteAttendeeError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteAttendeeError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(DeleteAttendeeError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(DeleteAttendeeError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(DeleteAttendeeError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(DeleteAttendeeError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DeleteAttendeeError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(DeleteAttendeeError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(DeleteAttendeeError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteAttendeeError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteAttendeeError::BadRequest(ref cause) => write!(f, "{}", cause),
            DeleteAttendeeError::Forbidden(ref cause) => write!(f, "{}", cause),
            DeleteAttendeeError::NotFound(ref cause) => write!(f, "{}", cause),
            DeleteAttendeeError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            DeleteAttendeeError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DeleteAttendeeError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            DeleteAttendeeError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteAttendeeError {}
/// Errors returned by DeleteChannel
#[derive(Debug, PartialEq)]
pub enum DeleteChannelError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl DeleteChannelError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteChannelError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(DeleteChannelError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(DeleteChannelError::Forbidden(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(DeleteChannelError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DeleteChannelError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(DeleteChannelError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(DeleteChannelError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteChannelError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteChannelError::BadRequest(ref cause) => write!(f, "{}", cause),
            DeleteChannelError::Forbidden(ref cause) => write!(f, "{}", cause),
            DeleteChannelError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            DeleteChannelError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DeleteChannelError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            DeleteChannelError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteChannelError {}
/// Errors returned by DeleteChannelBan
#[derive(Debug, PartialEq)]
pub enum DeleteChannelBanError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl DeleteChannelBanError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteChannelBanError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(DeleteChannelBanError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(DeleteChannelBanError::Forbidden(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(DeleteChannelBanError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DeleteChannelBanError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(DeleteChannelBanError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(DeleteChannelBanError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteChannelBanError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteChannelBanError::BadRequest(ref cause) => write!(f, "{}", cause),
            DeleteChannelBanError::Forbidden(ref cause) => write!(f, "{}", cause),
            DeleteChannelBanError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            DeleteChannelBanError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DeleteChannelBanError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            DeleteChannelBanError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteChannelBanError {}
/// Errors returned by DeleteChannelMembership
#[derive(Debug, PartialEq)]
pub enum DeleteChannelMembershipError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The request could not be processed because of conflict in the current state of the resource.</p>
    Conflict(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl DeleteChannelMembershipError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteChannelMembershipError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(DeleteChannelMembershipError::BadRequest(err.msg))
                }
                "ConflictException" => {
                    return RusotoError::Service(DeleteChannelMembershipError::Conflict(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(DeleteChannelMembershipError::Forbidden(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(DeleteChannelMembershipError::ServiceFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DeleteChannelMembershipError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(DeleteChannelMembershipError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(DeleteChannelMembershipError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteChannelMembershipError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteChannelMembershipError::BadRequest(ref cause) => write!(f, "{}", cause),
            DeleteChannelMembershipError::Conflict(ref cause) => write!(f, "{}", cause),
            DeleteChannelMembershipError::Forbidden(ref cause) => write!(f, "{}", cause),
            DeleteChannelMembershipError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            DeleteChannelMembershipError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DeleteChannelMembershipError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            DeleteChannelMembershipError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteChannelMembershipError {}
/// Errors returned by DeleteChannelMessage
#[derive(Debug, PartialEq)]
pub enum DeleteChannelMessageError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl DeleteChannelMessageError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteChannelMessageError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(DeleteChannelMessageError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(DeleteChannelMessageError::Forbidden(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(DeleteChannelMessageError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DeleteChannelMessageError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(DeleteChannelMessageError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(DeleteChannelMessageError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteChannelMessageError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteChannelMessageError::BadRequest(ref cause) => write!(f, "{}", cause),
            DeleteChannelMessageError::Forbidden(ref cause) => write!(f, "{}", cause),
            DeleteChannelMessageError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            DeleteChannelMessageError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DeleteChannelMessageError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            DeleteChannelMessageError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteChannelMessageError {}
/// Errors returned by DeleteChannelModerator
#[derive(Debug, PartialEq)]
pub enum DeleteChannelModeratorError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl DeleteChannelModeratorError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteChannelModeratorError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(DeleteChannelModeratorError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(DeleteChannelModeratorError::Forbidden(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(DeleteChannelModeratorError::ServiceFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DeleteChannelModeratorError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(DeleteChannelModeratorError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(DeleteChannelModeratorError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteChannelModeratorError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteChannelModeratorError::BadRequest(ref cause) => write!(f, "{}", cause),
            DeleteChannelModeratorError::Forbidden(ref cause) => write!(f, "{}", cause),
            DeleteChannelModeratorError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            DeleteChannelModeratorError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DeleteChannelModeratorError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            DeleteChannelModeratorError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteChannelModeratorError {}
/// Errors returned by DeleteEventsConfiguration
#[derive(Debug, PartialEq)]
pub enum DeleteEventsConfigurationError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceeded(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl DeleteEventsConfigurationError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteEventsConfigurationError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(DeleteEventsConfigurationError::BadRequest(
                        err.msg,
                    ))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(DeleteEventsConfigurationError::Forbidden(err.msg))
                }
                "ResourceLimitExceededException" => {
                    return RusotoError::Service(
                        DeleteEventsConfigurationError::ResourceLimitExceeded(err.msg),
                    )
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(DeleteEventsConfigurationError::ServiceFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        DeleteEventsConfigurationError::ServiceUnavailable(err.msg),
                    )
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        DeleteEventsConfigurationError::UnauthorizedClient(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteEventsConfigurationError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteEventsConfigurationError::BadRequest(ref cause) => write!(f, "{}", cause),
            DeleteEventsConfigurationError::Forbidden(ref cause) => write!(f, "{}", cause),
            DeleteEventsConfigurationError::ResourceLimitExceeded(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteEventsConfigurationError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            DeleteEventsConfigurationError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DeleteEventsConfigurationError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteEventsConfigurationError {}
/// Errors returned by DeleteMeeting
#[derive(Debug, PartialEq)]
pub enum DeleteMeetingError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl DeleteMeetingError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteMeetingError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(DeleteMeetingError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(DeleteMeetingError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(DeleteMeetingError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(DeleteMeetingError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DeleteMeetingError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(DeleteMeetingError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(DeleteMeetingError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteMeetingError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteMeetingError::BadRequest(ref cause) => write!(f, "{}", cause),
            DeleteMeetingError::Forbidden(ref cause) => write!(f, "{}", cause),
            DeleteMeetingError::NotFound(ref cause) => write!(f, "{}", cause),
            DeleteMeetingError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            DeleteMeetingError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DeleteMeetingError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            DeleteMeetingError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteMeetingError {}
/// Errors returned by DeletePhoneNumber
#[derive(Debug, PartialEq)]
pub enum DeletePhoneNumberError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl DeletePhoneNumberError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeletePhoneNumberError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(DeletePhoneNumberError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(DeletePhoneNumberError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(DeletePhoneNumberError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(DeletePhoneNumberError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DeletePhoneNumberError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(DeletePhoneNumberError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(DeletePhoneNumberError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeletePhoneNumberError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeletePhoneNumberError::BadRequest(ref cause) => write!(f, "{}", cause),
            DeletePhoneNumberError::Forbidden(ref cause) => write!(f, "{}", cause),
            DeletePhoneNumberError::NotFound(ref cause) => write!(f, "{}", cause),
            DeletePhoneNumberError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            DeletePhoneNumberError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DeletePhoneNumberError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            DeletePhoneNumberError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeletePhoneNumberError {}
/// Errors returned by DeleteProxySession
#[derive(Debug, PartialEq)]
pub enum DeleteProxySessionError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl DeleteProxySessionError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteProxySessionError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(DeleteProxySessionError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(DeleteProxySessionError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(DeleteProxySessionError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(DeleteProxySessionError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DeleteProxySessionError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(DeleteProxySessionError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(DeleteProxySessionError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteProxySessionError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteProxySessionError::BadRequest(ref cause) => write!(f, "{}", cause),
            DeleteProxySessionError::Forbidden(ref cause) => write!(f, "{}", cause),
            DeleteProxySessionError::NotFound(ref cause) => write!(f, "{}", cause),
            DeleteProxySessionError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            DeleteProxySessionError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DeleteProxySessionError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            DeleteProxySessionError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteProxySessionError {}
/// Errors returned by DeleteRoom
#[derive(Debug, PartialEq)]
pub enum DeleteRoomError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl DeleteRoomError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteRoomError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(DeleteRoomError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(DeleteRoomError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(DeleteRoomError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(DeleteRoomError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DeleteRoomError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(DeleteRoomError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(DeleteRoomError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteRoomError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteRoomError::BadRequest(ref cause) => write!(f, "{}", cause),
            DeleteRoomError::Forbidden(ref cause) => write!(f, "{}", cause),
            DeleteRoomError::NotFound(ref cause) => write!(f, "{}", cause),
            DeleteRoomError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            DeleteRoomError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DeleteRoomError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            DeleteRoomError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteRoomError {}
/// Errors returned by DeleteRoomMembership
#[derive(Debug, PartialEq)]
pub enum DeleteRoomMembershipError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl DeleteRoomMembershipError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteRoomMembershipError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(DeleteRoomMembershipError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(DeleteRoomMembershipError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(DeleteRoomMembershipError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(DeleteRoomMembershipError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DeleteRoomMembershipError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(DeleteRoomMembershipError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(DeleteRoomMembershipError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteRoomMembershipError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteRoomMembershipError::BadRequest(ref cause) => write!(f, "{}", cause),
            DeleteRoomMembershipError::Forbidden(ref cause) => write!(f, "{}", cause),
            DeleteRoomMembershipError::NotFound(ref cause) => write!(f, "{}", cause),
            DeleteRoomMembershipError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            DeleteRoomMembershipError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DeleteRoomMembershipError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            DeleteRoomMembershipError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteRoomMembershipError {}
/// Errors returned by DeleteSipMediaApplication
#[derive(Debug, PartialEq)]
pub enum DeleteSipMediaApplicationError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The request could not be processed because of conflict in the current state of the resource.</p>
    Conflict(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl DeleteSipMediaApplicationError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteSipMediaApplicationError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(DeleteSipMediaApplicationError::BadRequest(
                        err.msg,
                    ))
                }
                "ConflictException" => {
                    return RusotoError::Service(DeleteSipMediaApplicationError::Conflict(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(DeleteSipMediaApplicationError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(DeleteSipMediaApplicationError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(DeleteSipMediaApplicationError::ServiceFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        DeleteSipMediaApplicationError::ServiceUnavailable(err.msg),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(DeleteSipMediaApplicationError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        DeleteSipMediaApplicationError::UnauthorizedClient(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteSipMediaApplicationError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteSipMediaApplicationError::BadRequest(ref cause) => write!(f, "{}", cause),
            DeleteSipMediaApplicationError::Conflict(ref cause) => write!(f, "{}", cause),
            DeleteSipMediaApplicationError::Forbidden(ref cause) => write!(f, "{}", cause),
            DeleteSipMediaApplicationError::NotFound(ref cause) => write!(f, "{}", cause),
            DeleteSipMediaApplicationError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            DeleteSipMediaApplicationError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DeleteSipMediaApplicationError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            DeleteSipMediaApplicationError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteSipMediaApplicationError {}
/// Errors returned by DeleteSipRule
#[derive(Debug, PartialEq)]
pub enum DeleteSipRuleError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The request could not be processed because of conflict in the current state of the resource.</p>
    Conflict(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl DeleteSipRuleError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteSipRuleError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(DeleteSipRuleError::BadRequest(err.msg))
                }
                "ConflictException" => {
                    return RusotoError::Service(DeleteSipRuleError::Conflict(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(DeleteSipRuleError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(DeleteSipRuleError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(DeleteSipRuleError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DeleteSipRuleError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(DeleteSipRuleError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(DeleteSipRuleError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteSipRuleError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteSipRuleError::BadRequest(ref cause) => write!(f, "{}", cause),
            DeleteSipRuleError::Conflict(ref cause) => write!(f, "{}", cause),
            DeleteSipRuleError::Forbidden(ref cause) => write!(f, "{}", cause),
            DeleteSipRuleError::NotFound(ref cause) => write!(f, "{}", cause),
            DeleteSipRuleError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            DeleteSipRuleError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DeleteSipRuleError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            DeleteSipRuleError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteSipRuleError {}
/// Errors returned by DeleteVoiceConnector
#[derive(Debug, PartialEq)]
pub enum DeleteVoiceConnectorError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The request could not be processed because of conflict in the current state of the resource.</p>
    Conflict(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl DeleteVoiceConnectorError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteVoiceConnectorError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(DeleteVoiceConnectorError::BadRequest(err.msg))
                }
                "ConflictException" => {
                    return RusotoError::Service(DeleteVoiceConnectorError::Conflict(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(DeleteVoiceConnectorError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(DeleteVoiceConnectorError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(DeleteVoiceConnectorError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DeleteVoiceConnectorError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(DeleteVoiceConnectorError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(DeleteVoiceConnectorError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteVoiceConnectorError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteVoiceConnectorError::BadRequest(ref cause) => write!(f, "{}", cause),
            DeleteVoiceConnectorError::Conflict(ref cause) => write!(f, "{}", cause),
            DeleteVoiceConnectorError::Forbidden(ref cause) => write!(f, "{}", cause),
            DeleteVoiceConnectorError::NotFound(ref cause) => write!(f, "{}", cause),
            DeleteVoiceConnectorError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            DeleteVoiceConnectorError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DeleteVoiceConnectorError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            DeleteVoiceConnectorError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteVoiceConnectorError {}
/// Errors returned by DeleteVoiceConnectorEmergencyCallingConfiguration
#[derive(Debug, PartialEq)]
pub enum DeleteVoiceConnectorEmergencyCallingConfigurationError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl DeleteVoiceConnectorEmergencyCallingConfigurationError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<DeleteVoiceConnectorEmergencyCallingConfigurationError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(
                        DeleteVoiceConnectorEmergencyCallingConfigurationError::BadRequest(err.msg),
                    )
                }
                "ForbiddenException" => {
                    return RusotoError::Service(
                        DeleteVoiceConnectorEmergencyCallingConfigurationError::Forbidden(err.msg),
                    )
                }
                "NotFoundException" => {
                    return RusotoError::Service(
                        DeleteVoiceConnectorEmergencyCallingConfigurationError::NotFound(err.msg),
                    )
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(
                        DeleteVoiceConnectorEmergencyCallingConfigurationError::ServiceFailure(
                            err.msg,
                        ),
                    )
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        DeleteVoiceConnectorEmergencyCallingConfigurationError::ServiceUnavailable(
                            err.msg,
                        ),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(
                        DeleteVoiceConnectorEmergencyCallingConfigurationError::ThrottledClient(
                            err.msg,
                        ),
                    )
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        DeleteVoiceConnectorEmergencyCallingConfigurationError::UnauthorizedClient(
                            err.msg,
                        ),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteVoiceConnectorEmergencyCallingConfigurationError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteVoiceConnectorEmergencyCallingConfigurationError::BadRequest(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteVoiceConnectorEmergencyCallingConfigurationError::Forbidden(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteVoiceConnectorEmergencyCallingConfigurationError::NotFound(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteVoiceConnectorEmergencyCallingConfigurationError::ServiceFailure(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteVoiceConnectorEmergencyCallingConfigurationError::ServiceUnavailable(
                ref cause,
            ) => write!(f, "{}", cause),
            DeleteVoiceConnectorEmergencyCallingConfigurationError::ThrottledClient(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteVoiceConnectorEmergencyCallingConfigurationError::UnauthorizedClient(
                ref cause,
            ) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteVoiceConnectorEmergencyCallingConfigurationError {}
/// Errors returned by DeleteVoiceConnectorGroup
#[derive(Debug, PartialEq)]
pub enum DeleteVoiceConnectorGroupError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The request could not be processed because of conflict in the current state of the resource.</p>
    Conflict(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl DeleteVoiceConnectorGroupError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteVoiceConnectorGroupError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(DeleteVoiceConnectorGroupError::BadRequest(
                        err.msg,
                    ))
                }
                "ConflictException" => {
                    return RusotoError::Service(DeleteVoiceConnectorGroupError::Conflict(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(DeleteVoiceConnectorGroupError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(DeleteVoiceConnectorGroupError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(DeleteVoiceConnectorGroupError::ServiceFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        DeleteVoiceConnectorGroupError::ServiceUnavailable(err.msg),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(DeleteVoiceConnectorGroupError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        DeleteVoiceConnectorGroupError::UnauthorizedClient(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteVoiceConnectorGroupError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteVoiceConnectorGroupError::BadRequest(ref cause) => write!(f, "{}", cause),
            DeleteVoiceConnectorGroupError::Conflict(ref cause) => write!(f, "{}", cause),
            DeleteVoiceConnectorGroupError::Forbidden(ref cause) => write!(f, "{}", cause),
            DeleteVoiceConnectorGroupError::NotFound(ref cause) => write!(f, "{}", cause),
            DeleteVoiceConnectorGroupError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            DeleteVoiceConnectorGroupError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DeleteVoiceConnectorGroupError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            DeleteVoiceConnectorGroupError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteVoiceConnectorGroupError {}
/// Errors returned by DeleteVoiceConnectorOrigination
#[derive(Debug, PartialEq)]
pub enum DeleteVoiceConnectorOriginationError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl DeleteVoiceConnectorOriginationError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<DeleteVoiceConnectorOriginationError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(DeleteVoiceConnectorOriginationError::BadRequest(
                        err.msg,
                    ))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(DeleteVoiceConnectorOriginationError::Forbidden(
                        err.msg,
                    ))
                }
                "NotFoundException" => {
                    return RusotoError::Service(DeleteVoiceConnectorOriginationError::NotFound(
                        err.msg,
                    ))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(
                        DeleteVoiceConnectorOriginationError::ServiceFailure(err.msg),
                    )
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        DeleteVoiceConnectorOriginationError::ServiceUnavailable(err.msg),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(
                        DeleteVoiceConnectorOriginationError::ThrottledClient(err.msg),
                    )
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        DeleteVoiceConnectorOriginationError::UnauthorizedClient(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteVoiceConnectorOriginationError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteVoiceConnectorOriginationError::BadRequest(ref cause) => write!(f, "{}", cause),
            DeleteVoiceConnectorOriginationError::Forbidden(ref cause) => write!(f, "{}", cause),
            DeleteVoiceConnectorOriginationError::NotFound(ref cause) => write!(f, "{}", cause),
            DeleteVoiceConnectorOriginationError::ServiceFailure(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteVoiceConnectorOriginationError::ServiceUnavailable(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteVoiceConnectorOriginationError::ThrottledClient(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteVoiceConnectorOriginationError::UnauthorizedClient(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for DeleteVoiceConnectorOriginationError {}
/// Errors returned by DeleteVoiceConnectorProxy
#[derive(Debug, PartialEq)]
pub enum DeleteVoiceConnectorProxyError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl DeleteVoiceConnectorProxyError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteVoiceConnectorProxyError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(DeleteVoiceConnectorProxyError::BadRequest(
                        err.msg,
                    ))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(DeleteVoiceConnectorProxyError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(DeleteVoiceConnectorProxyError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(DeleteVoiceConnectorProxyError::ServiceFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        DeleteVoiceConnectorProxyError::ServiceUnavailable(err.msg),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(DeleteVoiceConnectorProxyError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        DeleteVoiceConnectorProxyError::UnauthorizedClient(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteVoiceConnectorProxyError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteVoiceConnectorProxyError::BadRequest(ref cause) => write!(f, "{}", cause),
            DeleteVoiceConnectorProxyError::Forbidden(ref cause) => write!(f, "{}", cause),
            DeleteVoiceConnectorProxyError::NotFound(ref cause) => write!(f, "{}", cause),
            DeleteVoiceConnectorProxyError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            DeleteVoiceConnectorProxyError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DeleteVoiceConnectorProxyError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            DeleteVoiceConnectorProxyError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteVoiceConnectorProxyError {}
/// Errors returned by DeleteVoiceConnectorStreamingConfiguration
#[derive(Debug, PartialEq)]
pub enum DeleteVoiceConnectorStreamingConfigurationError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl DeleteVoiceConnectorStreamingConfigurationError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<DeleteVoiceConnectorStreamingConfigurationError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(
                        DeleteVoiceConnectorStreamingConfigurationError::BadRequest(err.msg),
                    )
                }
                "ForbiddenException" => {
                    return RusotoError::Service(
                        DeleteVoiceConnectorStreamingConfigurationError::Forbidden(err.msg),
                    )
                }
                "NotFoundException" => {
                    return RusotoError::Service(
                        DeleteVoiceConnectorStreamingConfigurationError::NotFound(err.msg),
                    )
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(
                        DeleteVoiceConnectorStreamingConfigurationError::ServiceFailure(err.msg),
                    )
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        DeleteVoiceConnectorStreamingConfigurationError::ServiceUnavailable(
                            err.msg,
                        ),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(
                        DeleteVoiceConnectorStreamingConfigurationError::ThrottledClient(err.msg),
                    )
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        DeleteVoiceConnectorStreamingConfigurationError::UnauthorizedClient(
                            err.msg,
                        ),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteVoiceConnectorStreamingConfigurationError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteVoiceConnectorStreamingConfigurationError::BadRequest(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteVoiceConnectorStreamingConfigurationError::Forbidden(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteVoiceConnectorStreamingConfigurationError::NotFound(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteVoiceConnectorStreamingConfigurationError::ServiceFailure(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteVoiceConnectorStreamingConfigurationError::ServiceUnavailable(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteVoiceConnectorStreamingConfigurationError::ThrottledClient(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteVoiceConnectorStreamingConfigurationError::UnauthorizedClient(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for DeleteVoiceConnectorStreamingConfigurationError {}
/// Errors returned by DeleteVoiceConnectorTermination
#[derive(Debug, PartialEq)]
pub enum DeleteVoiceConnectorTerminationError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl DeleteVoiceConnectorTerminationError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<DeleteVoiceConnectorTerminationError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(DeleteVoiceConnectorTerminationError::BadRequest(
                        err.msg,
                    ))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(DeleteVoiceConnectorTerminationError::Forbidden(
                        err.msg,
                    ))
                }
                "NotFoundException" => {
                    return RusotoError::Service(DeleteVoiceConnectorTerminationError::NotFound(
                        err.msg,
                    ))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(
                        DeleteVoiceConnectorTerminationError::ServiceFailure(err.msg),
                    )
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        DeleteVoiceConnectorTerminationError::ServiceUnavailable(err.msg),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(
                        DeleteVoiceConnectorTerminationError::ThrottledClient(err.msg),
                    )
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        DeleteVoiceConnectorTerminationError::UnauthorizedClient(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteVoiceConnectorTerminationError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteVoiceConnectorTerminationError::BadRequest(ref cause) => write!(f, "{}", cause),
            DeleteVoiceConnectorTerminationError::Forbidden(ref cause) => write!(f, "{}", cause),
            DeleteVoiceConnectorTerminationError::NotFound(ref cause) => write!(f, "{}", cause),
            DeleteVoiceConnectorTerminationError::ServiceFailure(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteVoiceConnectorTerminationError::ServiceUnavailable(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteVoiceConnectorTerminationError::ThrottledClient(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteVoiceConnectorTerminationError::UnauthorizedClient(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for DeleteVoiceConnectorTerminationError {}
/// Errors returned by DeleteVoiceConnectorTerminationCredentials
#[derive(Debug, PartialEq)]
pub enum DeleteVoiceConnectorTerminationCredentialsError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl DeleteVoiceConnectorTerminationCredentialsError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<DeleteVoiceConnectorTerminationCredentialsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(
                        DeleteVoiceConnectorTerminationCredentialsError::BadRequest(err.msg),
                    )
                }
                "ForbiddenException" => {
                    return RusotoError::Service(
                        DeleteVoiceConnectorTerminationCredentialsError::Forbidden(err.msg),
                    )
                }
                "NotFoundException" => {
                    return RusotoError::Service(
                        DeleteVoiceConnectorTerminationCredentialsError::NotFound(err.msg),
                    )
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(
                        DeleteVoiceConnectorTerminationCredentialsError::ServiceFailure(err.msg),
                    )
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        DeleteVoiceConnectorTerminationCredentialsError::ServiceUnavailable(
                            err.msg,
                        ),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(
                        DeleteVoiceConnectorTerminationCredentialsError::ThrottledClient(err.msg),
                    )
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        DeleteVoiceConnectorTerminationCredentialsError::UnauthorizedClient(
                            err.msg,
                        ),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteVoiceConnectorTerminationCredentialsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteVoiceConnectorTerminationCredentialsError::BadRequest(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteVoiceConnectorTerminationCredentialsError::Forbidden(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteVoiceConnectorTerminationCredentialsError::NotFound(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteVoiceConnectorTerminationCredentialsError::ServiceFailure(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteVoiceConnectorTerminationCredentialsError::ServiceUnavailable(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteVoiceConnectorTerminationCredentialsError::ThrottledClient(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteVoiceConnectorTerminationCredentialsError::UnauthorizedClient(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for DeleteVoiceConnectorTerminationCredentialsError {}
/// Errors returned by DescribeAppInstance
#[derive(Debug, PartialEq)]
pub enum DescribeAppInstanceError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl DescribeAppInstanceError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DescribeAppInstanceError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(DescribeAppInstanceError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(DescribeAppInstanceError::Forbidden(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(DescribeAppInstanceError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DescribeAppInstanceError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(DescribeAppInstanceError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(DescribeAppInstanceError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DescribeAppInstanceError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeAppInstanceError::BadRequest(ref cause) => write!(f, "{}", cause),
            DescribeAppInstanceError::Forbidden(ref cause) => write!(f, "{}", cause),
            DescribeAppInstanceError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            DescribeAppInstanceError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DescribeAppInstanceError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            DescribeAppInstanceError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DescribeAppInstanceError {}
/// Errors returned by DescribeAppInstanceAdmin
#[derive(Debug, PartialEq)]
pub enum DescribeAppInstanceAdminError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl DescribeAppInstanceAdminError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DescribeAppInstanceAdminError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(DescribeAppInstanceAdminError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(DescribeAppInstanceAdminError::Forbidden(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(DescribeAppInstanceAdminError::ServiceFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DescribeAppInstanceAdminError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(DescribeAppInstanceAdminError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(DescribeAppInstanceAdminError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DescribeAppInstanceAdminError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeAppInstanceAdminError::BadRequest(ref cause) => write!(f, "{}", cause),
            DescribeAppInstanceAdminError::Forbidden(ref cause) => write!(f, "{}", cause),
            DescribeAppInstanceAdminError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            DescribeAppInstanceAdminError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DescribeAppInstanceAdminError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            DescribeAppInstanceAdminError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DescribeAppInstanceAdminError {}
/// Errors returned by DescribeAppInstanceUser
#[derive(Debug, PartialEq)]
pub enum DescribeAppInstanceUserError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl DescribeAppInstanceUserError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DescribeAppInstanceUserError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(DescribeAppInstanceUserError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(DescribeAppInstanceUserError::Forbidden(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(DescribeAppInstanceUserError::ServiceFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DescribeAppInstanceUserError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(DescribeAppInstanceUserError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(DescribeAppInstanceUserError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DescribeAppInstanceUserError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeAppInstanceUserError::BadRequest(ref cause) => write!(f, "{}", cause),
            DescribeAppInstanceUserError::Forbidden(ref cause) => write!(f, "{}", cause),
            DescribeAppInstanceUserError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            DescribeAppInstanceUserError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DescribeAppInstanceUserError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            DescribeAppInstanceUserError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DescribeAppInstanceUserError {}
/// Errors returned by DescribeChannel
#[derive(Debug, PartialEq)]
pub enum DescribeChannelError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl DescribeChannelError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DescribeChannelError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(DescribeChannelError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(DescribeChannelError::Forbidden(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(DescribeChannelError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DescribeChannelError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(DescribeChannelError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(DescribeChannelError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DescribeChannelError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeChannelError::BadRequest(ref cause) => write!(f, "{}", cause),
            DescribeChannelError::Forbidden(ref cause) => write!(f, "{}", cause),
            DescribeChannelError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            DescribeChannelError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DescribeChannelError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            DescribeChannelError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DescribeChannelError {}
/// Errors returned by DescribeChannelBan
#[derive(Debug, PartialEq)]
pub enum DescribeChannelBanError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl DescribeChannelBanError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DescribeChannelBanError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(DescribeChannelBanError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(DescribeChannelBanError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(DescribeChannelBanError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(DescribeChannelBanError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DescribeChannelBanError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(DescribeChannelBanError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(DescribeChannelBanError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DescribeChannelBanError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeChannelBanError::BadRequest(ref cause) => write!(f, "{}", cause),
            DescribeChannelBanError::Forbidden(ref cause) => write!(f, "{}", cause),
            DescribeChannelBanError::NotFound(ref cause) => write!(f, "{}", cause),
            DescribeChannelBanError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            DescribeChannelBanError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DescribeChannelBanError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            DescribeChannelBanError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DescribeChannelBanError {}
/// Errors returned by DescribeChannelMembership
#[derive(Debug, PartialEq)]
pub enum DescribeChannelMembershipError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl DescribeChannelMembershipError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DescribeChannelMembershipError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(DescribeChannelMembershipError::BadRequest(
                        err.msg,
                    ))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(DescribeChannelMembershipError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(DescribeChannelMembershipError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(DescribeChannelMembershipError::ServiceFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        DescribeChannelMembershipError::ServiceUnavailable(err.msg),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(DescribeChannelMembershipError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        DescribeChannelMembershipError::UnauthorizedClient(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DescribeChannelMembershipError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeChannelMembershipError::BadRequest(ref cause) => write!(f, "{}", cause),
            DescribeChannelMembershipError::Forbidden(ref cause) => write!(f, "{}", cause),
            DescribeChannelMembershipError::NotFound(ref cause) => write!(f, "{}", cause),
            DescribeChannelMembershipError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            DescribeChannelMembershipError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DescribeChannelMembershipError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            DescribeChannelMembershipError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DescribeChannelMembershipError {}
/// Errors returned by DescribeChannelMembershipForAppInstanceUser
#[derive(Debug, PartialEq)]
pub enum DescribeChannelMembershipForAppInstanceUserError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl DescribeChannelMembershipForAppInstanceUserError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<DescribeChannelMembershipForAppInstanceUserError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(
                        DescribeChannelMembershipForAppInstanceUserError::BadRequest(err.msg),
                    )
                }
                "ForbiddenException" => {
                    return RusotoError::Service(
                        DescribeChannelMembershipForAppInstanceUserError::Forbidden(err.msg),
                    )
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(
                        DescribeChannelMembershipForAppInstanceUserError::ServiceFailure(err.msg),
                    )
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        DescribeChannelMembershipForAppInstanceUserError::ServiceUnavailable(
                            err.msg,
                        ),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(
                        DescribeChannelMembershipForAppInstanceUserError::ThrottledClient(err.msg),
                    )
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        DescribeChannelMembershipForAppInstanceUserError::UnauthorizedClient(
                            err.msg,
                        ),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DescribeChannelMembershipForAppInstanceUserError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeChannelMembershipForAppInstanceUserError::BadRequest(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeChannelMembershipForAppInstanceUserError::Forbidden(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeChannelMembershipForAppInstanceUserError::ServiceFailure(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeChannelMembershipForAppInstanceUserError::ServiceUnavailable(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeChannelMembershipForAppInstanceUserError::ThrottledClient(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeChannelMembershipForAppInstanceUserError::UnauthorizedClient(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for DescribeChannelMembershipForAppInstanceUserError {}
/// Errors returned by DescribeChannelModeratedByAppInstanceUser
#[derive(Debug, PartialEq)]
pub enum DescribeChannelModeratedByAppInstanceUserError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl DescribeChannelModeratedByAppInstanceUserError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<DescribeChannelModeratedByAppInstanceUserError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(
                        DescribeChannelModeratedByAppInstanceUserError::BadRequest(err.msg),
                    )
                }
                "ForbiddenException" => {
                    return RusotoError::Service(
                        DescribeChannelModeratedByAppInstanceUserError::Forbidden(err.msg),
                    )
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(
                        DescribeChannelModeratedByAppInstanceUserError::ServiceFailure(err.msg),
                    )
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        DescribeChannelModeratedByAppInstanceUserError::ServiceUnavailable(err.msg),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(
                        DescribeChannelModeratedByAppInstanceUserError::ThrottledClient(err.msg),
                    )
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        DescribeChannelModeratedByAppInstanceUserError::UnauthorizedClient(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DescribeChannelModeratedByAppInstanceUserError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeChannelModeratedByAppInstanceUserError::BadRequest(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeChannelModeratedByAppInstanceUserError::Forbidden(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeChannelModeratedByAppInstanceUserError::ServiceFailure(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeChannelModeratedByAppInstanceUserError::ServiceUnavailable(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeChannelModeratedByAppInstanceUserError::ThrottledClient(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeChannelModeratedByAppInstanceUserError::UnauthorizedClient(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for DescribeChannelModeratedByAppInstanceUserError {}
/// Errors returned by DescribeChannelModerator
#[derive(Debug, PartialEq)]
pub enum DescribeChannelModeratorError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl DescribeChannelModeratorError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DescribeChannelModeratorError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(DescribeChannelModeratorError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(DescribeChannelModeratorError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(DescribeChannelModeratorError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(DescribeChannelModeratorError::ServiceFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(DescribeChannelModeratorError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(DescribeChannelModeratorError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(DescribeChannelModeratorError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DescribeChannelModeratorError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeChannelModeratorError::BadRequest(ref cause) => write!(f, "{}", cause),
            DescribeChannelModeratorError::Forbidden(ref cause) => write!(f, "{}", cause),
            DescribeChannelModeratorError::NotFound(ref cause) => write!(f, "{}", cause),
            DescribeChannelModeratorError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            DescribeChannelModeratorError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            DescribeChannelModeratorError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            DescribeChannelModeratorError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DescribeChannelModeratorError {}
/// Errors returned by DisassociatePhoneNumberFromUser
#[derive(Debug, PartialEq)]
pub enum DisassociatePhoneNumberFromUserError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl DisassociatePhoneNumberFromUserError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<DisassociatePhoneNumberFromUserError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(DisassociatePhoneNumberFromUserError::BadRequest(
                        err.msg,
                    ))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(DisassociatePhoneNumberFromUserError::Forbidden(
                        err.msg,
                    ))
                }
                "NotFoundException" => {
                    return RusotoError::Service(DisassociatePhoneNumberFromUserError::NotFound(
                        err.msg,
                    ))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(
                        DisassociatePhoneNumberFromUserError::ServiceFailure(err.msg),
                    )
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        DisassociatePhoneNumberFromUserError::ServiceUnavailable(err.msg),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(
                        DisassociatePhoneNumberFromUserError::ThrottledClient(err.msg),
                    )
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        DisassociatePhoneNumberFromUserError::UnauthorizedClient(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DisassociatePhoneNumberFromUserError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DisassociatePhoneNumberFromUserError::BadRequest(ref cause) => write!(f, "{}", cause),
            DisassociatePhoneNumberFromUserError::Forbidden(ref cause) => write!(f, "{}", cause),
            DisassociatePhoneNumberFromUserError::NotFound(ref cause) => write!(f, "{}", cause),
            DisassociatePhoneNumberFromUserError::ServiceFailure(ref cause) => {
                write!(f, "{}", cause)
            }
            DisassociatePhoneNumberFromUserError::ServiceUnavailable(ref cause) => {
                write!(f, "{}", cause)
            }
            DisassociatePhoneNumberFromUserError::ThrottledClient(ref cause) => {
                write!(f, "{}", cause)
            }
            DisassociatePhoneNumberFromUserError::UnauthorizedClient(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for DisassociatePhoneNumberFromUserError {}
/// Errors returned by DisassociatePhoneNumbersFromVoiceConnector
#[derive(Debug, PartialEq)]
pub enum DisassociatePhoneNumbersFromVoiceConnectorError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl DisassociatePhoneNumbersFromVoiceConnectorError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<DisassociatePhoneNumbersFromVoiceConnectorError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(
                        DisassociatePhoneNumbersFromVoiceConnectorError::BadRequest(err.msg),
                    )
                }
                "ForbiddenException" => {
                    return RusotoError::Service(
                        DisassociatePhoneNumbersFromVoiceConnectorError::Forbidden(err.msg),
                    )
                }
                "NotFoundException" => {
                    return RusotoError::Service(
                        DisassociatePhoneNumbersFromVoiceConnectorError::NotFound(err.msg),
                    )
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(
                        DisassociatePhoneNumbersFromVoiceConnectorError::ServiceFailure(err.msg),
                    )
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        DisassociatePhoneNumbersFromVoiceConnectorError::ServiceUnavailable(
                            err.msg,
                        ),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(
                        DisassociatePhoneNumbersFromVoiceConnectorError::ThrottledClient(err.msg),
                    )
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        DisassociatePhoneNumbersFromVoiceConnectorError::UnauthorizedClient(
                            err.msg,
                        ),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DisassociatePhoneNumbersFromVoiceConnectorError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DisassociatePhoneNumbersFromVoiceConnectorError::BadRequest(ref cause) => {
                write!(f, "{}", cause)
            }
            DisassociatePhoneNumbersFromVoiceConnectorError::Forbidden(ref cause) => {
                write!(f, "{}", cause)
            }
            DisassociatePhoneNumbersFromVoiceConnectorError::NotFound(ref cause) => {
                write!(f, "{}", cause)
            }
            DisassociatePhoneNumbersFromVoiceConnectorError::ServiceFailure(ref cause) => {
                write!(f, "{}", cause)
            }
            DisassociatePhoneNumbersFromVoiceConnectorError::ServiceUnavailable(ref cause) => {
                write!(f, "{}", cause)
            }
            DisassociatePhoneNumbersFromVoiceConnectorError::ThrottledClient(ref cause) => {
                write!(f, "{}", cause)
            }
            DisassociatePhoneNumbersFromVoiceConnectorError::UnauthorizedClient(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for DisassociatePhoneNumbersFromVoiceConnectorError {}
/// Errors returned by DisassociatePhoneNumbersFromVoiceConnectorGroup
#[derive(Debug, PartialEq)]
pub enum DisassociatePhoneNumbersFromVoiceConnectorGroupError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl DisassociatePhoneNumbersFromVoiceConnectorGroupError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<DisassociatePhoneNumbersFromVoiceConnectorGroupError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(
                        DisassociatePhoneNumbersFromVoiceConnectorGroupError::BadRequest(err.msg),
                    )
                }
                "ForbiddenException" => {
                    return RusotoError::Service(
                        DisassociatePhoneNumbersFromVoiceConnectorGroupError::Forbidden(err.msg),
                    )
                }
                "NotFoundException" => {
                    return RusotoError::Service(
                        DisassociatePhoneNumbersFromVoiceConnectorGroupError::NotFound(err.msg),
                    )
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(
                        DisassociatePhoneNumbersFromVoiceConnectorGroupError::ServiceFailure(
                            err.msg,
                        ),
                    )
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        DisassociatePhoneNumbersFromVoiceConnectorGroupError::ServiceUnavailable(
                            err.msg,
                        ),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(
                        DisassociatePhoneNumbersFromVoiceConnectorGroupError::ThrottledClient(
                            err.msg,
                        ),
                    )
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        DisassociatePhoneNumbersFromVoiceConnectorGroupError::UnauthorizedClient(
                            err.msg,
                        ),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DisassociatePhoneNumbersFromVoiceConnectorGroupError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DisassociatePhoneNumbersFromVoiceConnectorGroupError::BadRequest(ref cause) => {
                write!(f, "{}", cause)
            }
            DisassociatePhoneNumbersFromVoiceConnectorGroupError::Forbidden(ref cause) => {
                write!(f, "{}", cause)
            }
            DisassociatePhoneNumbersFromVoiceConnectorGroupError::NotFound(ref cause) => {
                write!(f, "{}", cause)
            }
            DisassociatePhoneNumbersFromVoiceConnectorGroupError::ServiceFailure(ref cause) => {
                write!(f, "{}", cause)
            }
            DisassociatePhoneNumbersFromVoiceConnectorGroupError::ServiceUnavailable(ref cause) => {
                write!(f, "{}", cause)
            }
            DisassociatePhoneNumbersFromVoiceConnectorGroupError::ThrottledClient(ref cause) => {
                write!(f, "{}", cause)
            }
            DisassociatePhoneNumbersFromVoiceConnectorGroupError::UnauthorizedClient(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for DisassociatePhoneNumbersFromVoiceConnectorGroupError {}
/// Errors returned by DisassociateSigninDelegateGroupsFromAccount
#[derive(Debug, PartialEq)]
pub enum DisassociateSigninDelegateGroupsFromAccountError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl DisassociateSigninDelegateGroupsFromAccountError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<DisassociateSigninDelegateGroupsFromAccountError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(
                        DisassociateSigninDelegateGroupsFromAccountError::BadRequest(err.msg),
                    )
                }
                "ForbiddenException" => {
                    return RusotoError::Service(
                        DisassociateSigninDelegateGroupsFromAccountError::Forbidden(err.msg),
                    )
                }
                "NotFoundException" => {
                    return RusotoError::Service(
                        DisassociateSigninDelegateGroupsFromAccountError::NotFound(err.msg),
                    )
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(
                        DisassociateSigninDelegateGroupsFromAccountError::ServiceFailure(err.msg),
                    )
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        DisassociateSigninDelegateGroupsFromAccountError::ServiceUnavailable(
                            err.msg,
                        ),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(
                        DisassociateSigninDelegateGroupsFromAccountError::ThrottledClient(err.msg),
                    )
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        DisassociateSigninDelegateGroupsFromAccountError::UnauthorizedClient(
                            err.msg,
                        ),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DisassociateSigninDelegateGroupsFromAccountError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DisassociateSigninDelegateGroupsFromAccountError::BadRequest(ref cause) => {
                write!(f, "{}", cause)
            }
            DisassociateSigninDelegateGroupsFromAccountError::Forbidden(ref cause) => {
                write!(f, "{}", cause)
            }
            DisassociateSigninDelegateGroupsFromAccountError::NotFound(ref cause) => {
                write!(f, "{}", cause)
            }
            DisassociateSigninDelegateGroupsFromAccountError::ServiceFailure(ref cause) => {
                write!(f, "{}", cause)
            }
            DisassociateSigninDelegateGroupsFromAccountError::ServiceUnavailable(ref cause) => {
                write!(f, "{}", cause)
            }
            DisassociateSigninDelegateGroupsFromAccountError::ThrottledClient(ref cause) => {
                write!(f, "{}", cause)
            }
            DisassociateSigninDelegateGroupsFromAccountError::UnauthorizedClient(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for DisassociateSigninDelegateGroupsFromAccountError {}
/// Errors returned by GetAccount
#[derive(Debug, PartialEq)]
pub enum GetAccountError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl GetAccountError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetAccountError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(GetAccountError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(GetAccountError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(GetAccountError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(GetAccountError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(GetAccountError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(GetAccountError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(GetAccountError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for GetAccountError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetAccountError::BadRequest(ref cause) => write!(f, "{}", cause),
            GetAccountError::Forbidden(ref cause) => write!(f, "{}", cause),
            GetAccountError::NotFound(ref cause) => write!(f, "{}", cause),
            GetAccountError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            GetAccountError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            GetAccountError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            GetAccountError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetAccountError {}
/// Errors returned by GetAccountSettings
#[derive(Debug, PartialEq)]
pub enum GetAccountSettingsError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl GetAccountSettingsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetAccountSettingsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(GetAccountSettingsError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(GetAccountSettingsError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(GetAccountSettingsError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(GetAccountSettingsError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(GetAccountSettingsError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(GetAccountSettingsError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(GetAccountSettingsError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for GetAccountSettingsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetAccountSettingsError::BadRequest(ref cause) => write!(f, "{}", cause),
            GetAccountSettingsError::Forbidden(ref cause) => write!(f, "{}", cause),
            GetAccountSettingsError::NotFound(ref cause) => write!(f, "{}", cause),
            GetAccountSettingsError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            GetAccountSettingsError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            GetAccountSettingsError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            GetAccountSettingsError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetAccountSettingsError {}
/// Errors returned by GetAppInstanceRetentionSettings
#[derive(Debug, PartialEq)]
pub enum GetAppInstanceRetentionSettingsError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl GetAppInstanceRetentionSettingsError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<GetAppInstanceRetentionSettingsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(GetAppInstanceRetentionSettingsError::BadRequest(
                        err.msg,
                    ))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(GetAppInstanceRetentionSettingsError::Forbidden(
                        err.msg,
                    ))
                }
                "NotFoundException" => {
                    return RusotoError::Service(GetAppInstanceRetentionSettingsError::NotFound(
                        err.msg,
                    ))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(
                        GetAppInstanceRetentionSettingsError::ServiceFailure(err.msg),
                    )
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        GetAppInstanceRetentionSettingsError::ServiceUnavailable(err.msg),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(
                        GetAppInstanceRetentionSettingsError::ThrottledClient(err.msg),
                    )
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        GetAppInstanceRetentionSettingsError::UnauthorizedClient(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for GetAppInstanceRetentionSettingsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetAppInstanceRetentionSettingsError::BadRequest(ref cause) => write!(f, "{}", cause),
            GetAppInstanceRetentionSettingsError::Forbidden(ref cause) => write!(f, "{}", cause),
            GetAppInstanceRetentionSettingsError::NotFound(ref cause) => write!(f, "{}", cause),
            GetAppInstanceRetentionSettingsError::ServiceFailure(ref cause) => {
                write!(f, "{}", cause)
            }
            GetAppInstanceRetentionSettingsError::ServiceUnavailable(ref cause) => {
                write!(f, "{}", cause)
            }
            GetAppInstanceRetentionSettingsError::ThrottledClient(ref cause) => {
                write!(f, "{}", cause)
            }
            GetAppInstanceRetentionSettingsError::UnauthorizedClient(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for GetAppInstanceRetentionSettingsError {}
/// Errors returned by GetAppInstanceStreamingConfigurations
#[derive(Debug, PartialEq)]
pub enum GetAppInstanceStreamingConfigurationsError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl GetAppInstanceStreamingConfigurationsError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<GetAppInstanceStreamingConfigurationsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(
                        GetAppInstanceStreamingConfigurationsError::BadRequest(err.msg),
                    )
                }
                "ForbiddenException" => {
                    return RusotoError::Service(
                        GetAppInstanceStreamingConfigurationsError::Forbidden(err.msg),
                    )
                }
                "NotFoundException" => {
                    return RusotoError::Service(
                        GetAppInstanceStreamingConfigurationsError::NotFound(err.msg),
                    )
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(
                        GetAppInstanceStreamingConfigurationsError::ServiceFailure(err.msg),
                    )
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        GetAppInstanceStreamingConfigurationsError::ServiceUnavailable(err.msg),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(
                        GetAppInstanceStreamingConfigurationsError::ThrottledClient(err.msg),
                    )
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        GetAppInstanceStreamingConfigurationsError::UnauthorizedClient(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for GetAppInstanceStreamingConfigurationsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetAppInstanceStreamingConfigurationsError::BadRequest(ref cause) => {
                write!(f, "{}", cause)
            }
            GetAppInstanceStreamingConfigurationsError::Forbidden(ref cause) => {
                write!(f, "{}", cause)
            }
            GetAppInstanceStreamingConfigurationsError::NotFound(ref cause) => {
                write!(f, "{}", cause)
            }
            GetAppInstanceStreamingConfigurationsError::ServiceFailure(ref cause) => {
                write!(f, "{}", cause)
            }
            GetAppInstanceStreamingConfigurationsError::ServiceUnavailable(ref cause) => {
                write!(f, "{}", cause)
            }
            GetAppInstanceStreamingConfigurationsError::ThrottledClient(ref cause) => {
                write!(f, "{}", cause)
            }
            GetAppInstanceStreamingConfigurationsError::UnauthorizedClient(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for GetAppInstanceStreamingConfigurationsError {}
/// Errors returned by GetAttendee
#[derive(Debug, PartialEq)]
pub enum GetAttendeeError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl GetAttendeeError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetAttendeeError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(GetAttendeeError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(GetAttendeeError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(GetAttendeeError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(GetAttendeeError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(GetAttendeeError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(GetAttendeeError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(GetAttendeeError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for GetAttendeeError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetAttendeeError::BadRequest(ref cause) => write!(f, "{}", cause),
            GetAttendeeError::Forbidden(ref cause) => write!(f, "{}", cause),
            GetAttendeeError::NotFound(ref cause) => write!(f, "{}", cause),
            GetAttendeeError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            GetAttendeeError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            GetAttendeeError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            GetAttendeeError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetAttendeeError {}
/// Errors returned by GetBot
#[derive(Debug, PartialEq)]
pub enum GetBotError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl GetBotError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetBotError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(GetBotError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(GetBotError::Forbidden(err.msg))
                }
                "NotFoundException" => return RusotoError::Service(GetBotError::NotFound(err.msg)),
                "ServiceFailureException" => {
                    return RusotoError::Service(GetBotError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(GetBotError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(GetBotError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(GetBotError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for GetBotError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetBotError::BadRequest(ref cause) => write!(f, "{}", cause),
            GetBotError::Forbidden(ref cause) => write!(f, "{}", cause),
            GetBotError::NotFound(ref cause) => write!(f, "{}", cause),
            GetBotError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            GetBotError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            GetBotError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            GetBotError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetBotError {}
/// Errors returned by GetChannelMessage
#[derive(Debug, PartialEq)]
pub enum GetChannelMessageError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl GetChannelMessageError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetChannelMessageError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(GetChannelMessageError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(GetChannelMessageError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(GetChannelMessageError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(GetChannelMessageError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(GetChannelMessageError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(GetChannelMessageError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(GetChannelMessageError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for GetChannelMessageError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetChannelMessageError::BadRequest(ref cause) => write!(f, "{}", cause),
            GetChannelMessageError::Forbidden(ref cause) => write!(f, "{}", cause),
            GetChannelMessageError::NotFound(ref cause) => write!(f, "{}", cause),
            GetChannelMessageError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            GetChannelMessageError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            GetChannelMessageError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            GetChannelMessageError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetChannelMessageError {}
/// Errors returned by GetEventsConfiguration
#[derive(Debug, PartialEq)]
pub enum GetEventsConfigurationError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceeded(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl GetEventsConfigurationError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetEventsConfigurationError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(GetEventsConfigurationError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(GetEventsConfigurationError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(GetEventsConfigurationError::NotFound(err.msg))
                }
                "ResourceLimitExceededException" => {
                    return RusotoError::Service(
                        GetEventsConfigurationError::ResourceLimitExceeded(err.msg),
                    )
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(GetEventsConfigurationError::ServiceFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(GetEventsConfigurationError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(GetEventsConfigurationError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for GetEventsConfigurationError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetEventsConfigurationError::BadRequest(ref cause) => write!(f, "{}", cause),
            GetEventsConfigurationError::Forbidden(ref cause) => write!(f, "{}", cause),
            GetEventsConfigurationError::NotFound(ref cause) => write!(f, "{}", cause),
            GetEventsConfigurationError::ResourceLimitExceeded(ref cause) => write!(f, "{}", cause),
            GetEventsConfigurationError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            GetEventsConfigurationError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            GetEventsConfigurationError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetEventsConfigurationError {}
/// Errors returned by GetGlobalSettings
#[derive(Debug, PartialEq)]
pub enum GetGlobalSettingsError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl GetGlobalSettingsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetGlobalSettingsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(GetGlobalSettingsError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(GetGlobalSettingsError::Forbidden(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(GetGlobalSettingsError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(GetGlobalSettingsError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(GetGlobalSettingsError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(GetGlobalSettingsError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for GetGlobalSettingsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetGlobalSettingsError::BadRequest(ref cause) => write!(f, "{}", cause),
            GetGlobalSettingsError::Forbidden(ref cause) => write!(f, "{}", cause),
            GetGlobalSettingsError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            GetGlobalSettingsError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            GetGlobalSettingsError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            GetGlobalSettingsError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetGlobalSettingsError {}
/// Errors returned by GetMeeting
#[derive(Debug, PartialEq)]
pub enum GetMeetingError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl GetMeetingError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetMeetingError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(GetMeetingError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(GetMeetingError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(GetMeetingError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(GetMeetingError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(GetMeetingError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(GetMeetingError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(GetMeetingError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for GetMeetingError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetMeetingError::BadRequest(ref cause) => write!(f, "{}", cause),
            GetMeetingError::Forbidden(ref cause) => write!(f, "{}", cause),
            GetMeetingError::NotFound(ref cause) => write!(f, "{}", cause),
            GetMeetingError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            GetMeetingError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            GetMeetingError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            GetMeetingError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetMeetingError {}
/// Errors returned by GetMessagingSessionEndpoint
#[derive(Debug, PartialEq)]
pub enum GetMessagingSessionEndpointError {
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl GetMessagingSessionEndpointError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<GetMessagingSessionEndpointError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "ForbiddenException" => {
                    return RusotoError::Service(GetMessagingSessionEndpointError::Forbidden(
                        err.msg,
                    ))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(GetMessagingSessionEndpointError::ServiceFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        GetMessagingSessionEndpointError::ServiceUnavailable(err.msg),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(GetMessagingSessionEndpointError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        GetMessagingSessionEndpointError::UnauthorizedClient(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for GetMessagingSessionEndpointError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetMessagingSessionEndpointError::Forbidden(ref cause) => write!(f, "{}", cause),
            GetMessagingSessionEndpointError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            GetMessagingSessionEndpointError::ServiceUnavailable(ref cause) => {
                write!(f, "{}", cause)
            }
            GetMessagingSessionEndpointError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            GetMessagingSessionEndpointError::UnauthorizedClient(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for GetMessagingSessionEndpointError {}
/// Errors returned by GetPhoneNumber
#[derive(Debug, PartialEq)]
pub enum GetPhoneNumberError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl GetPhoneNumberError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetPhoneNumberError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(GetPhoneNumberError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(GetPhoneNumberError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(GetPhoneNumberError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(GetPhoneNumberError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(GetPhoneNumberError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(GetPhoneNumberError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(GetPhoneNumberError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for GetPhoneNumberError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetPhoneNumberError::BadRequest(ref cause) => write!(f, "{}", cause),
            GetPhoneNumberError::Forbidden(ref cause) => write!(f, "{}", cause),
            GetPhoneNumberError::NotFound(ref cause) => write!(f, "{}", cause),
            GetPhoneNumberError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            GetPhoneNumberError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            GetPhoneNumberError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            GetPhoneNumberError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetPhoneNumberError {}
/// Errors returned by GetPhoneNumberOrder
#[derive(Debug, PartialEq)]
pub enum GetPhoneNumberOrderError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl GetPhoneNumberOrderError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetPhoneNumberOrderError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(GetPhoneNumberOrderError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(GetPhoneNumberOrderError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(GetPhoneNumberOrderError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(GetPhoneNumberOrderError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(GetPhoneNumberOrderError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(GetPhoneNumberOrderError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(GetPhoneNumberOrderError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for GetPhoneNumberOrderError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetPhoneNumberOrderError::BadRequest(ref cause) => write!(f, "{}", cause),
            GetPhoneNumberOrderError::Forbidden(ref cause) => write!(f, "{}", cause),
            GetPhoneNumberOrderError::NotFound(ref cause) => write!(f, "{}", cause),
            GetPhoneNumberOrderError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            GetPhoneNumberOrderError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            GetPhoneNumberOrderError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            GetPhoneNumberOrderError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetPhoneNumberOrderError {}
/// Errors returned by GetPhoneNumberSettings
#[derive(Debug, PartialEq)]
pub enum GetPhoneNumberSettingsError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl GetPhoneNumberSettingsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetPhoneNumberSettingsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(GetPhoneNumberSettingsError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(GetPhoneNumberSettingsError::Forbidden(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(GetPhoneNumberSettingsError::ServiceFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(GetPhoneNumberSettingsError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(GetPhoneNumberSettingsError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(GetPhoneNumberSettingsError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for GetPhoneNumberSettingsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetPhoneNumberSettingsError::BadRequest(ref cause) => write!(f, "{}", cause),
            GetPhoneNumberSettingsError::Forbidden(ref cause) => write!(f, "{}", cause),
            GetPhoneNumberSettingsError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            GetPhoneNumberSettingsError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            GetPhoneNumberSettingsError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            GetPhoneNumberSettingsError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetPhoneNumberSettingsError {}
/// Errors returned by GetProxySession
#[derive(Debug, PartialEq)]
pub enum GetProxySessionError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl GetProxySessionError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetProxySessionError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(GetProxySessionError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(GetProxySessionError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(GetProxySessionError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(GetProxySessionError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(GetProxySessionError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(GetProxySessionError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(GetProxySessionError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for GetProxySessionError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetProxySessionError::BadRequest(ref cause) => write!(f, "{}", cause),
            GetProxySessionError::Forbidden(ref cause) => write!(f, "{}", cause),
            GetProxySessionError::NotFound(ref cause) => write!(f, "{}", cause),
            GetProxySessionError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            GetProxySessionError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            GetProxySessionError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            GetProxySessionError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetProxySessionError {}
/// Errors returned by GetRetentionSettings
#[derive(Debug, PartialEq)]
pub enum GetRetentionSettingsError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl GetRetentionSettingsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetRetentionSettingsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(GetRetentionSettingsError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(GetRetentionSettingsError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(GetRetentionSettingsError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(GetRetentionSettingsError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(GetRetentionSettingsError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(GetRetentionSettingsError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(GetRetentionSettingsError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for GetRetentionSettingsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetRetentionSettingsError::BadRequest(ref cause) => write!(f, "{}", cause),
            GetRetentionSettingsError::Forbidden(ref cause) => write!(f, "{}", cause),
            GetRetentionSettingsError::NotFound(ref cause) => write!(f, "{}", cause),
            GetRetentionSettingsError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            GetRetentionSettingsError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            GetRetentionSettingsError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            GetRetentionSettingsError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetRetentionSettingsError {}
/// Errors returned by GetRoom
#[derive(Debug, PartialEq)]
pub enum GetRoomError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl GetRoomError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetRoomError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(GetRoomError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(GetRoomError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(GetRoomError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(GetRoomError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(GetRoomError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(GetRoomError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(GetRoomError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for GetRoomError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetRoomError::BadRequest(ref cause) => write!(f, "{}", cause),
            GetRoomError::Forbidden(ref cause) => write!(f, "{}", cause),
            GetRoomError::NotFound(ref cause) => write!(f, "{}", cause),
            GetRoomError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            GetRoomError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            GetRoomError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            GetRoomError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetRoomError {}
/// Errors returned by GetSipMediaApplication
#[derive(Debug, PartialEq)]
pub enum GetSipMediaApplicationError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl GetSipMediaApplicationError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetSipMediaApplicationError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(GetSipMediaApplicationError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(GetSipMediaApplicationError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(GetSipMediaApplicationError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(GetSipMediaApplicationError::ServiceFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(GetSipMediaApplicationError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(GetSipMediaApplicationError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(GetSipMediaApplicationError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for GetSipMediaApplicationError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetSipMediaApplicationError::BadRequest(ref cause) => write!(f, "{}", cause),
            GetSipMediaApplicationError::Forbidden(ref cause) => write!(f, "{}", cause),
            GetSipMediaApplicationError::NotFound(ref cause) => write!(f, "{}", cause),
            GetSipMediaApplicationError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            GetSipMediaApplicationError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            GetSipMediaApplicationError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            GetSipMediaApplicationError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetSipMediaApplicationError {}
/// Errors returned by GetSipMediaApplicationLoggingConfiguration
#[derive(Debug, PartialEq)]
pub enum GetSipMediaApplicationLoggingConfigurationError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl GetSipMediaApplicationLoggingConfigurationError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<GetSipMediaApplicationLoggingConfigurationError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(
                        GetSipMediaApplicationLoggingConfigurationError::BadRequest(err.msg),
                    )
                }
                "ForbiddenException" => {
                    return RusotoError::Service(
                        GetSipMediaApplicationLoggingConfigurationError::Forbidden(err.msg),
                    )
                }
                "NotFoundException" => {
                    return RusotoError::Service(
                        GetSipMediaApplicationLoggingConfigurationError::NotFound(err.msg),
                    )
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(
                        GetSipMediaApplicationLoggingConfigurationError::ServiceFailure(err.msg),
                    )
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        GetSipMediaApplicationLoggingConfigurationError::ServiceUnavailable(
                            err.msg,
                        ),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(
                        GetSipMediaApplicationLoggingConfigurationError::ThrottledClient(err.msg),
                    )
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        GetSipMediaApplicationLoggingConfigurationError::UnauthorizedClient(
                            err.msg,
                        ),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for GetSipMediaApplicationLoggingConfigurationError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetSipMediaApplicationLoggingConfigurationError::BadRequest(ref cause) => {
                write!(f, "{}", cause)
            }
            GetSipMediaApplicationLoggingConfigurationError::Forbidden(ref cause) => {
                write!(f, "{}", cause)
            }
            GetSipMediaApplicationLoggingConfigurationError::NotFound(ref cause) => {
                write!(f, "{}", cause)
            }
            GetSipMediaApplicationLoggingConfigurationError::ServiceFailure(ref cause) => {
                write!(f, "{}", cause)
            }
            GetSipMediaApplicationLoggingConfigurationError::ServiceUnavailable(ref cause) => {
                write!(f, "{}", cause)
            }
            GetSipMediaApplicationLoggingConfigurationError::ThrottledClient(ref cause) => {
                write!(f, "{}", cause)
            }
            GetSipMediaApplicationLoggingConfigurationError::UnauthorizedClient(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for GetSipMediaApplicationLoggingConfigurationError {}
/// Errors returned by GetSipRule
#[derive(Debug, PartialEq)]
pub enum GetSipRuleError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl GetSipRuleError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetSipRuleError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(GetSipRuleError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(GetSipRuleError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(GetSipRuleError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(GetSipRuleError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(GetSipRuleError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(GetSipRuleError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(GetSipRuleError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for GetSipRuleError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetSipRuleError::BadRequest(ref cause) => write!(f, "{}", cause),
            GetSipRuleError::Forbidden(ref cause) => write!(f, "{}", cause),
            GetSipRuleError::NotFound(ref cause) => write!(f, "{}", cause),
            GetSipRuleError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            GetSipRuleError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            GetSipRuleError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            GetSipRuleError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetSipRuleError {}
/// Errors returned by GetUser
#[derive(Debug, PartialEq)]
pub enum GetUserError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl GetUserError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetUserError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(GetUserError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(GetUserError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(GetUserError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(GetUserError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(GetUserError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(GetUserError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(GetUserError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for GetUserError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetUserError::BadRequest(ref cause) => write!(f, "{}", cause),
            GetUserError::Forbidden(ref cause) => write!(f, "{}", cause),
            GetUserError::NotFound(ref cause) => write!(f, "{}", cause),
            GetUserError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            GetUserError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            GetUserError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            GetUserError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetUserError {}
/// Errors returned by GetUserSettings
#[derive(Debug, PartialEq)]
pub enum GetUserSettingsError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl GetUserSettingsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetUserSettingsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(GetUserSettingsError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(GetUserSettingsError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(GetUserSettingsError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(GetUserSettingsError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(GetUserSettingsError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(GetUserSettingsError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(GetUserSettingsError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for GetUserSettingsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetUserSettingsError::BadRequest(ref cause) => write!(f, "{}", cause),
            GetUserSettingsError::Forbidden(ref cause) => write!(f, "{}", cause),
            GetUserSettingsError::NotFound(ref cause) => write!(f, "{}", cause),
            GetUserSettingsError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            GetUserSettingsError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            GetUserSettingsError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            GetUserSettingsError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetUserSettingsError {}
/// Errors returned by GetVoiceConnector
#[derive(Debug, PartialEq)]
pub enum GetVoiceConnectorError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl GetVoiceConnectorError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetVoiceConnectorError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(GetVoiceConnectorError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(GetVoiceConnectorError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(GetVoiceConnectorError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(GetVoiceConnectorError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(GetVoiceConnectorError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(GetVoiceConnectorError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(GetVoiceConnectorError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for GetVoiceConnectorError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetVoiceConnectorError::BadRequest(ref cause) => write!(f, "{}", cause),
            GetVoiceConnectorError::Forbidden(ref cause) => write!(f, "{}", cause),
            GetVoiceConnectorError::NotFound(ref cause) => write!(f, "{}", cause),
            GetVoiceConnectorError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            GetVoiceConnectorError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            GetVoiceConnectorError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            GetVoiceConnectorError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetVoiceConnectorError {}
/// Errors returned by GetVoiceConnectorEmergencyCallingConfiguration
#[derive(Debug, PartialEq)]
pub enum GetVoiceConnectorEmergencyCallingConfigurationError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl GetVoiceConnectorEmergencyCallingConfigurationError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<GetVoiceConnectorEmergencyCallingConfigurationError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(
                        GetVoiceConnectorEmergencyCallingConfigurationError::BadRequest(err.msg),
                    )
                }
                "ForbiddenException" => {
                    return RusotoError::Service(
                        GetVoiceConnectorEmergencyCallingConfigurationError::Forbidden(err.msg),
                    )
                }
                "NotFoundException" => {
                    return RusotoError::Service(
                        GetVoiceConnectorEmergencyCallingConfigurationError::NotFound(err.msg),
                    )
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(
                        GetVoiceConnectorEmergencyCallingConfigurationError::ServiceFailure(
                            err.msg,
                        ),
                    )
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        GetVoiceConnectorEmergencyCallingConfigurationError::ServiceUnavailable(
                            err.msg,
                        ),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(
                        GetVoiceConnectorEmergencyCallingConfigurationError::ThrottledClient(
                            err.msg,
                        ),
                    )
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        GetVoiceConnectorEmergencyCallingConfigurationError::UnauthorizedClient(
                            err.msg,
                        ),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for GetVoiceConnectorEmergencyCallingConfigurationError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetVoiceConnectorEmergencyCallingConfigurationError::BadRequest(ref cause) => {
                write!(f, "{}", cause)
            }
            GetVoiceConnectorEmergencyCallingConfigurationError::Forbidden(ref cause) => {
                write!(f, "{}", cause)
            }
            GetVoiceConnectorEmergencyCallingConfigurationError::NotFound(ref cause) => {
                write!(f, "{}", cause)
            }
            GetVoiceConnectorEmergencyCallingConfigurationError::ServiceFailure(ref cause) => {
                write!(f, "{}", cause)
            }
            GetVoiceConnectorEmergencyCallingConfigurationError::ServiceUnavailable(ref cause) => {
                write!(f, "{}", cause)
            }
            GetVoiceConnectorEmergencyCallingConfigurationError::ThrottledClient(ref cause) => {
                write!(f, "{}", cause)
            }
            GetVoiceConnectorEmergencyCallingConfigurationError::UnauthorizedClient(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for GetVoiceConnectorEmergencyCallingConfigurationError {}
/// Errors returned by GetVoiceConnectorGroup
#[derive(Debug, PartialEq)]
pub enum GetVoiceConnectorGroupError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl GetVoiceConnectorGroupError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetVoiceConnectorGroupError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(GetVoiceConnectorGroupError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(GetVoiceConnectorGroupError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(GetVoiceConnectorGroupError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(GetVoiceConnectorGroupError::ServiceFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(GetVoiceConnectorGroupError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(GetVoiceConnectorGroupError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(GetVoiceConnectorGroupError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for GetVoiceConnectorGroupError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetVoiceConnectorGroupError::BadRequest(ref cause) => write!(f, "{}", cause),
            GetVoiceConnectorGroupError::Forbidden(ref cause) => write!(f, "{}", cause),
            GetVoiceConnectorGroupError::NotFound(ref cause) => write!(f, "{}", cause),
            GetVoiceConnectorGroupError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            GetVoiceConnectorGroupError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            GetVoiceConnectorGroupError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            GetVoiceConnectorGroupError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetVoiceConnectorGroupError {}
/// Errors returned by GetVoiceConnectorLoggingConfiguration
#[derive(Debug, PartialEq)]
pub enum GetVoiceConnectorLoggingConfigurationError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl GetVoiceConnectorLoggingConfigurationError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<GetVoiceConnectorLoggingConfigurationError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(
                        GetVoiceConnectorLoggingConfigurationError::BadRequest(err.msg),
                    )
                }
                "ForbiddenException" => {
                    return RusotoError::Service(
                        GetVoiceConnectorLoggingConfigurationError::Forbidden(err.msg),
                    )
                }
                "NotFoundException" => {
                    return RusotoError::Service(
                        GetVoiceConnectorLoggingConfigurationError::NotFound(err.msg),
                    )
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(
                        GetVoiceConnectorLoggingConfigurationError::ServiceFailure(err.msg),
                    )
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        GetVoiceConnectorLoggingConfigurationError::ServiceUnavailable(err.msg),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(
                        GetVoiceConnectorLoggingConfigurationError::ThrottledClient(err.msg),
                    )
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        GetVoiceConnectorLoggingConfigurationError::UnauthorizedClient(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for GetVoiceConnectorLoggingConfigurationError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetVoiceConnectorLoggingConfigurationError::BadRequest(ref cause) => {
                write!(f, "{}", cause)
            }
            GetVoiceConnectorLoggingConfigurationError::Forbidden(ref cause) => {
                write!(f, "{}", cause)
            }
            GetVoiceConnectorLoggingConfigurationError::NotFound(ref cause) => {
                write!(f, "{}", cause)
            }
            GetVoiceConnectorLoggingConfigurationError::ServiceFailure(ref cause) => {
                write!(f, "{}", cause)
            }
            GetVoiceConnectorLoggingConfigurationError::ServiceUnavailable(ref cause) => {
                write!(f, "{}", cause)
            }
            GetVoiceConnectorLoggingConfigurationError::ThrottledClient(ref cause) => {
                write!(f, "{}", cause)
            }
            GetVoiceConnectorLoggingConfigurationError::UnauthorizedClient(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for GetVoiceConnectorLoggingConfigurationError {}
/// Errors returned by GetVoiceConnectorOrigination
#[derive(Debug, PartialEq)]
pub enum GetVoiceConnectorOriginationError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl GetVoiceConnectorOriginationError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<GetVoiceConnectorOriginationError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(GetVoiceConnectorOriginationError::BadRequest(
                        err.msg,
                    ))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(GetVoiceConnectorOriginationError::Forbidden(
                        err.msg,
                    ))
                }
                "NotFoundException" => {
                    return RusotoError::Service(GetVoiceConnectorOriginationError::NotFound(
                        err.msg,
                    ))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(GetVoiceConnectorOriginationError::ServiceFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        GetVoiceConnectorOriginationError::ServiceUnavailable(err.msg),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(
                        GetVoiceConnectorOriginationError::ThrottledClient(err.msg),
                    )
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        GetVoiceConnectorOriginationError::UnauthorizedClient(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for GetVoiceConnectorOriginationError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetVoiceConnectorOriginationError::BadRequest(ref cause) => write!(f, "{}", cause),
            GetVoiceConnectorOriginationError::Forbidden(ref cause) => write!(f, "{}", cause),
            GetVoiceConnectorOriginationError::NotFound(ref cause) => write!(f, "{}", cause),
            GetVoiceConnectorOriginationError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            GetVoiceConnectorOriginationError::ServiceUnavailable(ref cause) => {
                write!(f, "{}", cause)
            }
            GetVoiceConnectorOriginationError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            GetVoiceConnectorOriginationError::UnauthorizedClient(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for GetVoiceConnectorOriginationError {}
/// Errors returned by GetVoiceConnectorProxy
#[derive(Debug, PartialEq)]
pub enum GetVoiceConnectorProxyError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl GetVoiceConnectorProxyError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetVoiceConnectorProxyError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(GetVoiceConnectorProxyError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(GetVoiceConnectorProxyError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(GetVoiceConnectorProxyError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(GetVoiceConnectorProxyError::ServiceFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(GetVoiceConnectorProxyError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(GetVoiceConnectorProxyError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(GetVoiceConnectorProxyError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for GetVoiceConnectorProxyError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetVoiceConnectorProxyError::BadRequest(ref cause) => write!(f, "{}", cause),
            GetVoiceConnectorProxyError::Forbidden(ref cause) => write!(f, "{}", cause),
            GetVoiceConnectorProxyError::NotFound(ref cause) => write!(f, "{}", cause),
            GetVoiceConnectorProxyError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            GetVoiceConnectorProxyError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            GetVoiceConnectorProxyError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            GetVoiceConnectorProxyError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetVoiceConnectorProxyError {}
/// Errors returned by GetVoiceConnectorStreamingConfiguration
#[derive(Debug, PartialEq)]
pub enum GetVoiceConnectorStreamingConfigurationError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl GetVoiceConnectorStreamingConfigurationError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<GetVoiceConnectorStreamingConfigurationError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(
                        GetVoiceConnectorStreamingConfigurationError::BadRequest(err.msg),
                    )
                }
                "ForbiddenException" => {
                    return RusotoError::Service(
                        GetVoiceConnectorStreamingConfigurationError::Forbidden(err.msg),
                    )
                }
                "NotFoundException" => {
                    return RusotoError::Service(
                        GetVoiceConnectorStreamingConfigurationError::NotFound(err.msg),
                    )
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(
                        GetVoiceConnectorStreamingConfigurationError::ServiceFailure(err.msg),
                    )
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        GetVoiceConnectorStreamingConfigurationError::ServiceUnavailable(err.msg),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(
                        GetVoiceConnectorStreamingConfigurationError::ThrottledClient(err.msg),
                    )
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        GetVoiceConnectorStreamingConfigurationError::UnauthorizedClient(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for GetVoiceConnectorStreamingConfigurationError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetVoiceConnectorStreamingConfigurationError::BadRequest(ref cause) => {
                write!(f, "{}", cause)
            }
            GetVoiceConnectorStreamingConfigurationError::Forbidden(ref cause) => {
                write!(f, "{}", cause)
            }
            GetVoiceConnectorStreamingConfigurationError::NotFound(ref cause) => {
                write!(f, "{}", cause)
            }
            GetVoiceConnectorStreamingConfigurationError::ServiceFailure(ref cause) => {
                write!(f, "{}", cause)
            }
            GetVoiceConnectorStreamingConfigurationError::ServiceUnavailable(ref cause) => {
                write!(f, "{}", cause)
            }
            GetVoiceConnectorStreamingConfigurationError::ThrottledClient(ref cause) => {
                write!(f, "{}", cause)
            }
            GetVoiceConnectorStreamingConfigurationError::UnauthorizedClient(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for GetVoiceConnectorStreamingConfigurationError {}
/// Errors returned by GetVoiceConnectorTermination
#[derive(Debug, PartialEq)]
pub enum GetVoiceConnectorTerminationError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl GetVoiceConnectorTerminationError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<GetVoiceConnectorTerminationError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(GetVoiceConnectorTerminationError::BadRequest(
                        err.msg,
                    ))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(GetVoiceConnectorTerminationError::Forbidden(
                        err.msg,
                    ))
                }
                "NotFoundException" => {
                    return RusotoError::Service(GetVoiceConnectorTerminationError::NotFound(
                        err.msg,
                    ))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(GetVoiceConnectorTerminationError::ServiceFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        GetVoiceConnectorTerminationError::ServiceUnavailable(err.msg),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(
                        GetVoiceConnectorTerminationError::ThrottledClient(err.msg),
                    )
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        GetVoiceConnectorTerminationError::UnauthorizedClient(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for GetVoiceConnectorTerminationError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetVoiceConnectorTerminationError::BadRequest(ref cause) => write!(f, "{}", cause),
            GetVoiceConnectorTerminationError::Forbidden(ref cause) => write!(f, "{}", cause),
            GetVoiceConnectorTerminationError::NotFound(ref cause) => write!(f, "{}", cause),
            GetVoiceConnectorTerminationError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            GetVoiceConnectorTerminationError::ServiceUnavailable(ref cause) => {
                write!(f, "{}", cause)
            }
            GetVoiceConnectorTerminationError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            GetVoiceConnectorTerminationError::UnauthorizedClient(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for GetVoiceConnectorTerminationError {}
/// Errors returned by GetVoiceConnectorTerminationHealth
#[derive(Debug, PartialEq)]
pub enum GetVoiceConnectorTerminationHealthError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl GetVoiceConnectorTerminationHealthError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<GetVoiceConnectorTerminationHealthError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(
                        GetVoiceConnectorTerminationHealthError::BadRequest(err.msg),
                    )
                }
                "ForbiddenException" => {
                    return RusotoError::Service(
                        GetVoiceConnectorTerminationHealthError::Forbidden(err.msg),
                    )
                }
                "NotFoundException" => {
                    return RusotoError::Service(GetVoiceConnectorTerminationHealthError::NotFound(
                        err.msg,
                    ))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(
                        GetVoiceConnectorTerminationHealthError::ServiceFailure(err.msg),
                    )
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        GetVoiceConnectorTerminationHealthError::ServiceUnavailable(err.msg),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(
                        GetVoiceConnectorTerminationHealthError::ThrottledClient(err.msg),
                    )
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        GetVoiceConnectorTerminationHealthError::UnauthorizedClient(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for GetVoiceConnectorTerminationHealthError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetVoiceConnectorTerminationHealthError::BadRequest(ref cause) => {
                write!(f, "{}", cause)
            }
            GetVoiceConnectorTerminationHealthError::Forbidden(ref cause) => write!(f, "{}", cause),
            GetVoiceConnectorTerminationHealthError::NotFound(ref cause) => write!(f, "{}", cause),
            GetVoiceConnectorTerminationHealthError::ServiceFailure(ref cause) => {
                write!(f, "{}", cause)
            }
            GetVoiceConnectorTerminationHealthError::ServiceUnavailable(ref cause) => {
                write!(f, "{}", cause)
            }
            GetVoiceConnectorTerminationHealthError::ThrottledClient(ref cause) => {
                write!(f, "{}", cause)
            }
            GetVoiceConnectorTerminationHealthError::UnauthorizedClient(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for GetVoiceConnectorTerminationHealthError {}
/// Errors returned by InviteUsers
#[derive(Debug, PartialEq)]
pub enum InviteUsersError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl InviteUsersError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<InviteUsersError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(InviteUsersError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(InviteUsersError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(InviteUsersError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(InviteUsersError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(InviteUsersError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(InviteUsersError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(InviteUsersError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for InviteUsersError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            InviteUsersError::BadRequest(ref cause) => write!(f, "{}", cause),
            InviteUsersError::Forbidden(ref cause) => write!(f, "{}", cause),
            InviteUsersError::NotFound(ref cause) => write!(f, "{}", cause),
            InviteUsersError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            InviteUsersError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            InviteUsersError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            InviteUsersError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for InviteUsersError {}
/// Errors returned by ListAccounts
#[derive(Debug, PartialEq)]
pub enum ListAccountsError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl ListAccountsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListAccountsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(ListAccountsError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(ListAccountsError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(ListAccountsError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(ListAccountsError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(ListAccountsError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(ListAccountsError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(ListAccountsError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListAccountsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListAccountsError::BadRequest(ref cause) => write!(f, "{}", cause),
            ListAccountsError::Forbidden(ref cause) => write!(f, "{}", cause),
            ListAccountsError::NotFound(ref cause) => write!(f, "{}", cause),
            ListAccountsError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            ListAccountsError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            ListAccountsError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            ListAccountsError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListAccountsError {}
/// Errors returned by ListAppInstanceAdmins
#[derive(Debug, PartialEq)]
pub enum ListAppInstanceAdminsError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl ListAppInstanceAdminsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListAppInstanceAdminsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(ListAppInstanceAdminsError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(ListAppInstanceAdminsError::Forbidden(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(ListAppInstanceAdminsError::ServiceFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(ListAppInstanceAdminsError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(ListAppInstanceAdminsError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(ListAppInstanceAdminsError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListAppInstanceAdminsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListAppInstanceAdminsError::BadRequest(ref cause) => write!(f, "{}", cause),
            ListAppInstanceAdminsError::Forbidden(ref cause) => write!(f, "{}", cause),
            ListAppInstanceAdminsError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            ListAppInstanceAdminsError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            ListAppInstanceAdminsError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            ListAppInstanceAdminsError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListAppInstanceAdminsError {}
/// Errors returned by ListAppInstanceUsers
#[derive(Debug, PartialEq)]
pub enum ListAppInstanceUsersError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl ListAppInstanceUsersError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListAppInstanceUsersError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(ListAppInstanceUsersError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(ListAppInstanceUsersError::Forbidden(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(ListAppInstanceUsersError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(ListAppInstanceUsersError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(ListAppInstanceUsersError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(ListAppInstanceUsersError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListAppInstanceUsersError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListAppInstanceUsersError::BadRequest(ref cause) => write!(f, "{}", cause),
            ListAppInstanceUsersError::Forbidden(ref cause) => write!(f, "{}", cause),
            ListAppInstanceUsersError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            ListAppInstanceUsersError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            ListAppInstanceUsersError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            ListAppInstanceUsersError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListAppInstanceUsersError {}
/// Errors returned by ListAppInstances
#[derive(Debug, PartialEq)]
pub enum ListAppInstancesError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl ListAppInstancesError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListAppInstancesError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(ListAppInstancesError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(ListAppInstancesError::Forbidden(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(ListAppInstancesError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(ListAppInstancesError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(ListAppInstancesError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(ListAppInstancesError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListAppInstancesError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListAppInstancesError::BadRequest(ref cause) => write!(f, "{}", cause),
            ListAppInstancesError::Forbidden(ref cause) => write!(f, "{}", cause),
            ListAppInstancesError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            ListAppInstancesError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            ListAppInstancesError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            ListAppInstancesError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListAppInstancesError {}
/// Errors returned by ListAttendeeTags
#[derive(Debug, PartialEq)]
pub enum ListAttendeeTagsError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl ListAttendeeTagsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListAttendeeTagsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(ListAttendeeTagsError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(ListAttendeeTagsError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(ListAttendeeTagsError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(ListAttendeeTagsError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(ListAttendeeTagsError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(ListAttendeeTagsError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(ListAttendeeTagsError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListAttendeeTagsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListAttendeeTagsError::BadRequest(ref cause) => write!(f, "{}", cause),
            ListAttendeeTagsError::Forbidden(ref cause) => write!(f, "{}", cause),
            ListAttendeeTagsError::NotFound(ref cause) => write!(f, "{}", cause),
            ListAttendeeTagsError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            ListAttendeeTagsError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            ListAttendeeTagsError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            ListAttendeeTagsError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListAttendeeTagsError {}
/// Errors returned by ListAttendees
#[derive(Debug, PartialEq)]
pub enum ListAttendeesError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl ListAttendeesError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListAttendeesError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(ListAttendeesError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(ListAttendeesError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(ListAttendeesError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(ListAttendeesError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(ListAttendeesError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(ListAttendeesError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(ListAttendeesError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListAttendeesError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListAttendeesError::BadRequest(ref cause) => write!(f, "{}", cause),
            ListAttendeesError::Forbidden(ref cause) => write!(f, "{}", cause),
            ListAttendeesError::NotFound(ref cause) => write!(f, "{}", cause),
            ListAttendeesError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            ListAttendeesError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            ListAttendeesError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            ListAttendeesError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListAttendeesError {}
/// Errors returned by ListBots
#[derive(Debug, PartialEq)]
pub enum ListBotsError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl ListBotsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListBotsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(ListBotsError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(ListBotsError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(ListBotsError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(ListBotsError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(ListBotsError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(ListBotsError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(ListBotsError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListBotsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListBotsError::BadRequest(ref cause) => write!(f, "{}", cause),
            ListBotsError::Forbidden(ref cause) => write!(f, "{}", cause),
            ListBotsError::NotFound(ref cause) => write!(f, "{}", cause),
            ListBotsError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            ListBotsError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            ListBotsError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            ListBotsError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListBotsError {}
/// Errors returned by ListChannelBans
#[derive(Debug, PartialEq)]
pub enum ListChannelBansError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl ListChannelBansError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListChannelBansError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(ListChannelBansError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(ListChannelBansError::Forbidden(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(ListChannelBansError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(ListChannelBansError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(ListChannelBansError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(ListChannelBansError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListChannelBansError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListChannelBansError::BadRequest(ref cause) => write!(f, "{}", cause),
            ListChannelBansError::Forbidden(ref cause) => write!(f, "{}", cause),
            ListChannelBansError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            ListChannelBansError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            ListChannelBansError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            ListChannelBansError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListChannelBansError {}
/// Errors returned by ListChannelMemberships
#[derive(Debug, PartialEq)]
pub enum ListChannelMembershipsError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl ListChannelMembershipsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListChannelMembershipsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(ListChannelMembershipsError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(ListChannelMembershipsError::Forbidden(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(ListChannelMembershipsError::ServiceFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(ListChannelMembershipsError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(ListChannelMembershipsError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(ListChannelMembershipsError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListChannelMembershipsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListChannelMembershipsError::BadRequest(ref cause) => write!(f, "{}", cause),
            ListChannelMembershipsError::Forbidden(ref cause) => write!(f, "{}", cause),
            ListChannelMembershipsError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            ListChannelMembershipsError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            ListChannelMembershipsError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            ListChannelMembershipsError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListChannelMembershipsError {}
/// Errors returned by ListChannelMembershipsForAppInstanceUser
#[derive(Debug, PartialEq)]
pub enum ListChannelMembershipsForAppInstanceUserError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl ListChannelMembershipsForAppInstanceUserError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<ListChannelMembershipsForAppInstanceUserError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(
                        ListChannelMembershipsForAppInstanceUserError::BadRequest(err.msg),
                    )
                }
                "ForbiddenException" => {
                    return RusotoError::Service(
                        ListChannelMembershipsForAppInstanceUserError::Forbidden(err.msg),
                    )
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(
                        ListChannelMembershipsForAppInstanceUserError::ServiceFailure(err.msg),
                    )
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        ListChannelMembershipsForAppInstanceUserError::ServiceUnavailable(err.msg),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(
                        ListChannelMembershipsForAppInstanceUserError::ThrottledClient(err.msg),
                    )
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        ListChannelMembershipsForAppInstanceUserError::UnauthorizedClient(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListChannelMembershipsForAppInstanceUserError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListChannelMembershipsForAppInstanceUserError::BadRequest(ref cause) => {
                write!(f, "{}", cause)
            }
            ListChannelMembershipsForAppInstanceUserError::Forbidden(ref cause) => {
                write!(f, "{}", cause)
            }
            ListChannelMembershipsForAppInstanceUserError::ServiceFailure(ref cause) => {
                write!(f, "{}", cause)
            }
            ListChannelMembershipsForAppInstanceUserError::ServiceUnavailable(ref cause) => {
                write!(f, "{}", cause)
            }
            ListChannelMembershipsForAppInstanceUserError::ThrottledClient(ref cause) => {
                write!(f, "{}", cause)
            }
            ListChannelMembershipsForAppInstanceUserError::UnauthorizedClient(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for ListChannelMembershipsForAppInstanceUserError {}
/// Errors returned by ListChannelMessages
#[derive(Debug, PartialEq)]
pub enum ListChannelMessagesError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl ListChannelMessagesError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListChannelMessagesError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(ListChannelMessagesError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(ListChannelMessagesError::Forbidden(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(ListChannelMessagesError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(ListChannelMessagesError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(ListChannelMessagesError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(ListChannelMessagesError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListChannelMessagesError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListChannelMessagesError::BadRequest(ref cause) => write!(f, "{}", cause),
            ListChannelMessagesError::Forbidden(ref cause) => write!(f, "{}", cause),
            ListChannelMessagesError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            ListChannelMessagesError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            ListChannelMessagesError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            ListChannelMessagesError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListChannelMessagesError {}
/// Errors returned by ListChannelModerators
#[derive(Debug, PartialEq)]
pub enum ListChannelModeratorsError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl ListChannelModeratorsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListChannelModeratorsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(ListChannelModeratorsError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(ListChannelModeratorsError::Forbidden(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(ListChannelModeratorsError::ServiceFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(ListChannelModeratorsError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(ListChannelModeratorsError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(ListChannelModeratorsError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListChannelModeratorsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListChannelModeratorsError::BadRequest(ref cause) => write!(f, "{}", cause),
            ListChannelModeratorsError::Forbidden(ref cause) => write!(f, "{}", cause),
            ListChannelModeratorsError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            ListChannelModeratorsError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            ListChannelModeratorsError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            ListChannelModeratorsError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListChannelModeratorsError {}
/// Errors returned by ListChannels
#[derive(Debug, PartialEq)]
pub enum ListChannelsError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl ListChannelsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListChannelsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(ListChannelsError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(ListChannelsError::Forbidden(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(ListChannelsError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(ListChannelsError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(ListChannelsError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(ListChannelsError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListChannelsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListChannelsError::BadRequest(ref cause) => write!(f, "{}", cause),
            ListChannelsError::Forbidden(ref cause) => write!(f, "{}", cause),
            ListChannelsError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            ListChannelsError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            ListChannelsError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            ListChannelsError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListChannelsError {}
/// Errors returned by ListChannelsModeratedByAppInstanceUser
#[derive(Debug, PartialEq)]
pub enum ListChannelsModeratedByAppInstanceUserError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl ListChannelsModeratedByAppInstanceUserError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<ListChannelsModeratedByAppInstanceUserError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(
                        ListChannelsModeratedByAppInstanceUserError::BadRequest(err.msg),
                    )
                }
                "ForbiddenException" => {
                    return RusotoError::Service(
                        ListChannelsModeratedByAppInstanceUserError::Forbidden(err.msg),
                    )
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(
                        ListChannelsModeratedByAppInstanceUserError::ServiceFailure(err.msg),
                    )
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        ListChannelsModeratedByAppInstanceUserError::ServiceUnavailable(err.msg),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(
                        ListChannelsModeratedByAppInstanceUserError::ThrottledClient(err.msg),
                    )
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        ListChannelsModeratedByAppInstanceUserError::UnauthorizedClient(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListChannelsModeratedByAppInstanceUserError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListChannelsModeratedByAppInstanceUserError::BadRequest(ref cause) => {
                write!(f, "{}", cause)
            }
            ListChannelsModeratedByAppInstanceUserError::Forbidden(ref cause) => {
                write!(f, "{}", cause)
            }
            ListChannelsModeratedByAppInstanceUserError::ServiceFailure(ref cause) => {
                write!(f, "{}", cause)
            }
            ListChannelsModeratedByAppInstanceUserError::ServiceUnavailable(ref cause) => {
                write!(f, "{}", cause)
            }
            ListChannelsModeratedByAppInstanceUserError::ThrottledClient(ref cause) => {
                write!(f, "{}", cause)
            }
            ListChannelsModeratedByAppInstanceUserError::UnauthorizedClient(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for ListChannelsModeratedByAppInstanceUserError {}
/// Errors returned by ListMeetingTags
#[derive(Debug, PartialEq)]
pub enum ListMeetingTagsError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl ListMeetingTagsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListMeetingTagsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(ListMeetingTagsError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(ListMeetingTagsError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(ListMeetingTagsError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(ListMeetingTagsError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(ListMeetingTagsError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(ListMeetingTagsError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(ListMeetingTagsError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListMeetingTagsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListMeetingTagsError::BadRequest(ref cause) => write!(f, "{}", cause),
            ListMeetingTagsError::Forbidden(ref cause) => write!(f, "{}", cause),
            ListMeetingTagsError::NotFound(ref cause) => write!(f, "{}", cause),
            ListMeetingTagsError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            ListMeetingTagsError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            ListMeetingTagsError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            ListMeetingTagsError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListMeetingTagsError {}
/// Errors returned by ListMeetings
#[derive(Debug, PartialEq)]
pub enum ListMeetingsError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl ListMeetingsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListMeetingsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(ListMeetingsError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(ListMeetingsError::Forbidden(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(ListMeetingsError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(ListMeetingsError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(ListMeetingsError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(ListMeetingsError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListMeetingsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListMeetingsError::BadRequest(ref cause) => write!(f, "{}", cause),
            ListMeetingsError::Forbidden(ref cause) => write!(f, "{}", cause),
            ListMeetingsError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            ListMeetingsError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            ListMeetingsError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            ListMeetingsError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListMeetingsError {}
/// Errors returned by ListPhoneNumberOrders
#[derive(Debug, PartialEq)]
pub enum ListPhoneNumberOrdersError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl ListPhoneNumberOrdersError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListPhoneNumberOrdersError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(ListPhoneNumberOrdersError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(ListPhoneNumberOrdersError::Forbidden(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(ListPhoneNumberOrdersError::ServiceFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(ListPhoneNumberOrdersError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(ListPhoneNumberOrdersError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(ListPhoneNumberOrdersError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListPhoneNumberOrdersError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListPhoneNumberOrdersError::BadRequest(ref cause) => write!(f, "{}", cause),
            ListPhoneNumberOrdersError::Forbidden(ref cause) => write!(f, "{}", cause),
            ListPhoneNumberOrdersError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            ListPhoneNumberOrdersError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            ListPhoneNumberOrdersError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            ListPhoneNumberOrdersError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListPhoneNumberOrdersError {}
/// Errors returned by ListPhoneNumbers
#[derive(Debug, PartialEq)]
pub enum ListPhoneNumbersError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl ListPhoneNumbersError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListPhoneNumbersError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(ListPhoneNumbersError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(ListPhoneNumbersError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(ListPhoneNumbersError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(ListPhoneNumbersError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(ListPhoneNumbersError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(ListPhoneNumbersError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(ListPhoneNumbersError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListPhoneNumbersError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListPhoneNumbersError::BadRequest(ref cause) => write!(f, "{}", cause),
            ListPhoneNumbersError::Forbidden(ref cause) => write!(f, "{}", cause),
            ListPhoneNumbersError::NotFound(ref cause) => write!(f, "{}", cause),
            ListPhoneNumbersError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            ListPhoneNumbersError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            ListPhoneNumbersError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            ListPhoneNumbersError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListPhoneNumbersError {}
/// Errors returned by ListProxySessions
#[derive(Debug, PartialEq)]
pub enum ListProxySessionsError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl ListProxySessionsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListProxySessionsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(ListProxySessionsError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(ListProxySessionsError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(ListProxySessionsError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(ListProxySessionsError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(ListProxySessionsError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(ListProxySessionsError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(ListProxySessionsError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListProxySessionsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListProxySessionsError::BadRequest(ref cause) => write!(f, "{}", cause),
            ListProxySessionsError::Forbidden(ref cause) => write!(f, "{}", cause),
            ListProxySessionsError::NotFound(ref cause) => write!(f, "{}", cause),
            ListProxySessionsError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            ListProxySessionsError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            ListProxySessionsError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            ListProxySessionsError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListProxySessionsError {}
/// Errors returned by ListRoomMemberships
#[derive(Debug, PartialEq)]
pub enum ListRoomMembershipsError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl ListRoomMembershipsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListRoomMembershipsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(ListRoomMembershipsError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(ListRoomMembershipsError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(ListRoomMembershipsError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(ListRoomMembershipsError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(ListRoomMembershipsError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(ListRoomMembershipsError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(ListRoomMembershipsError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListRoomMembershipsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListRoomMembershipsError::BadRequest(ref cause) => write!(f, "{}", cause),
            ListRoomMembershipsError::Forbidden(ref cause) => write!(f, "{}", cause),
            ListRoomMembershipsError::NotFound(ref cause) => write!(f, "{}", cause),
            ListRoomMembershipsError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            ListRoomMembershipsError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            ListRoomMembershipsError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            ListRoomMembershipsError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListRoomMembershipsError {}
/// Errors returned by ListRooms
#[derive(Debug, PartialEq)]
pub enum ListRoomsError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl ListRoomsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListRoomsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(ListRoomsError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(ListRoomsError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(ListRoomsError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(ListRoomsError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(ListRoomsError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(ListRoomsError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(ListRoomsError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListRoomsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListRoomsError::BadRequest(ref cause) => write!(f, "{}", cause),
            ListRoomsError::Forbidden(ref cause) => write!(f, "{}", cause),
            ListRoomsError::NotFound(ref cause) => write!(f, "{}", cause),
            ListRoomsError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            ListRoomsError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            ListRoomsError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            ListRoomsError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListRoomsError {}
/// Errors returned by ListSipMediaApplications
#[derive(Debug, PartialEq)]
pub enum ListSipMediaApplicationsError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl ListSipMediaApplicationsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListSipMediaApplicationsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(ListSipMediaApplicationsError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(ListSipMediaApplicationsError::Forbidden(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(ListSipMediaApplicationsError::ServiceFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(ListSipMediaApplicationsError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(ListSipMediaApplicationsError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(ListSipMediaApplicationsError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListSipMediaApplicationsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListSipMediaApplicationsError::BadRequest(ref cause) => write!(f, "{}", cause),
            ListSipMediaApplicationsError::Forbidden(ref cause) => write!(f, "{}", cause),
            ListSipMediaApplicationsError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            ListSipMediaApplicationsError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            ListSipMediaApplicationsError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            ListSipMediaApplicationsError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListSipMediaApplicationsError {}
/// Errors returned by ListSipRules
#[derive(Debug, PartialEq)]
pub enum ListSipRulesError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl ListSipRulesError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListSipRulesError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(ListSipRulesError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(ListSipRulesError::Forbidden(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(ListSipRulesError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(ListSipRulesError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(ListSipRulesError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(ListSipRulesError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListSipRulesError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListSipRulesError::BadRequest(ref cause) => write!(f, "{}", cause),
            ListSipRulesError::Forbidden(ref cause) => write!(f, "{}", cause),
            ListSipRulesError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            ListSipRulesError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            ListSipRulesError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            ListSipRulesError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListSipRulesError {}
/// Errors returned by ListSupportedPhoneNumberCountries
#[derive(Debug, PartialEq)]
pub enum ListSupportedPhoneNumberCountriesError {
    /// <p>You don't have permissions to perform the requested operation.</p>
    AccessDenied(String),
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl ListSupportedPhoneNumberCountriesError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<ListSupportedPhoneNumberCountriesError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(
                        ListSupportedPhoneNumberCountriesError::AccessDenied(err.msg),
                    )
                }
                "BadRequestException" => {
                    return RusotoError::Service(
                        ListSupportedPhoneNumberCountriesError::BadRequest(err.msg),
                    )
                }
                "ForbiddenException" => {
                    return RusotoError::Service(ListSupportedPhoneNumberCountriesError::Forbidden(
                        err.msg,
                    ))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(
                        ListSupportedPhoneNumberCountriesError::ServiceFailure(err.msg),
                    )
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        ListSupportedPhoneNumberCountriesError::ServiceUnavailable(err.msg),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(
                        ListSupportedPhoneNumberCountriesError::ThrottledClient(err.msg),
                    )
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        ListSupportedPhoneNumberCountriesError::UnauthorizedClient(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListSupportedPhoneNumberCountriesError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListSupportedPhoneNumberCountriesError::AccessDenied(ref cause) => {
                write!(f, "{}", cause)
            }
            ListSupportedPhoneNumberCountriesError::BadRequest(ref cause) => write!(f, "{}", cause),
            ListSupportedPhoneNumberCountriesError::Forbidden(ref cause) => write!(f, "{}", cause),
            ListSupportedPhoneNumberCountriesError::ServiceFailure(ref cause) => {
                write!(f, "{}", cause)
            }
            ListSupportedPhoneNumberCountriesError::ServiceUnavailable(ref cause) => {
                write!(f, "{}", cause)
            }
            ListSupportedPhoneNumberCountriesError::ThrottledClient(ref cause) => {
                write!(f, "{}", cause)
            }
            ListSupportedPhoneNumberCountriesError::UnauthorizedClient(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for ListSupportedPhoneNumberCountriesError {}
/// Errors returned by ListTagsForResource
#[derive(Debug, PartialEq)]
pub enum ListTagsForResourceError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl ListTagsForResourceError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListTagsForResourceError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(ListTagsForResourceError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(ListTagsForResourceError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(ListTagsForResourceError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(ListTagsForResourceError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(ListTagsForResourceError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(ListTagsForResourceError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListTagsForResourceError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListTagsForResourceError::BadRequest(ref cause) => write!(f, "{}", cause),
            ListTagsForResourceError::Forbidden(ref cause) => write!(f, "{}", cause),
            ListTagsForResourceError::NotFound(ref cause) => write!(f, "{}", cause),
            ListTagsForResourceError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            ListTagsForResourceError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            ListTagsForResourceError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListTagsForResourceError {}
/// Errors returned by ListUsers
#[derive(Debug, PartialEq)]
pub enum ListUsersError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl ListUsersError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListUsersError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(ListUsersError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(ListUsersError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(ListUsersError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(ListUsersError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(ListUsersError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(ListUsersError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(ListUsersError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListUsersError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListUsersError::BadRequest(ref cause) => write!(f, "{}", cause),
            ListUsersError::Forbidden(ref cause) => write!(f, "{}", cause),
            ListUsersError::NotFound(ref cause) => write!(f, "{}", cause),
            ListUsersError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            ListUsersError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            ListUsersError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            ListUsersError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListUsersError {}
/// Errors returned by ListVoiceConnectorGroups
#[derive(Debug, PartialEq)]
pub enum ListVoiceConnectorGroupsError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl ListVoiceConnectorGroupsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListVoiceConnectorGroupsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(ListVoiceConnectorGroupsError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(ListVoiceConnectorGroupsError::Forbidden(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(ListVoiceConnectorGroupsError::ServiceFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(ListVoiceConnectorGroupsError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(ListVoiceConnectorGroupsError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(ListVoiceConnectorGroupsError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListVoiceConnectorGroupsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListVoiceConnectorGroupsError::BadRequest(ref cause) => write!(f, "{}", cause),
            ListVoiceConnectorGroupsError::Forbidden(ref cause) => write!(f, "{}", cause),
            ListVoiceConnectorGroupsError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            ListVoiceConnectorGroupsError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            ListVoiceConnectorGroupsError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            ListVoiceConnectorGroupsError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListVoiceConnectorGroupsError {}
/// Errors returned by ListVoiceConnectorTerminationCredentials
#[derive(Debug, PartialEq)]
pub enum ListVoiceConnectorTerminationCredentialsError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl ListVoiceConnectorTerminationCredentialsError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<ListVoiceConnectorTerminationCredentialsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(
                        ListVoiceConnectorTerminationCredentialsError::BadRequest(err.msg),
                    )
                }
                "ForbiddenException" => {
                    return RusotoError::Service(
                        ListVoiceConnectorTerminationCredentialsError::Forbidden(err.msg),
                    )
                }
                "NotFoundException" => {
                    return RusotoError::Service(
                        ListVoiceConnectorTerminationCredentialsError::NotFound(err.msg),
                    )
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(
                        ListVoiceConnectorTerminationCredentialsError::ServiceFailure(err.msg),
                    )
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        ListVoiceConnectorTerminationCredentialsError::ServiceUnavailable(err.msg),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(
                        ListVoiceConnectorTerminationCredentialsError::ThrottledClient(err.msg),
                    )
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        ListVoiceConnectorTerminationCredentialsError::UnauthorizedClient(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListVoiceConnectorTerminationCredentialsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListVoiceConnectorTerminationCredentialsError::BadRequest(ref cause) => {
                write!(f, "{}", cause)
            }
            ListVoiceConnectorTerminationCredentialsError::Forbidden(ref cause) => {
                write!(f, "{}", cause)
            }
            ListVoiceConnectorTerminationCredentialsError::NotFound(ref cause) => {
                write!(f, "{}", cause)
            }
            ListVoiceConnectorTerminationCredentialsError::ServiceFailure(ref cause) => {
                write!(f, "{}", cause)
            }
            ListVoiceConnectorTerminationCredentialsError::ServiceUnavailable(ref cause) => {
                write!(f, "{}", cause)
            }
            ListVoiceConnectorTerminationCredentialsError::ThrottledClient(ref cause) => {
                write!(f, "{}", cause)
            }
            ListVoiceConnectorTerminationCredentialsError::UnauthorizedClient(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for ListVoiceConnectorTerminationCredentialsError {}
/// Errors returned by ListVoiceConnectors
#[derive(Debug, PartialEq)]
pub enum ListVoiceConnectorsError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl ListVoiceConnectorsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListVoiceConnectorsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(ListVoiceConnectorsError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(ListVoiceConnectorsError::Forbidden(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(ListVoiceConnectorsError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(ListVoiceConnectorsError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(ListVoiceConnectorsError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(ListVoiceConnectorsError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListVoiceConnectorsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListVoiceConnectorsError::BadRequest(ref cause) => write!(f, "{}", cause),
            ListVoiceConnectorsError::Forbidden(ref cause) => write!(f, "{}", cause),
            ListVoiceConnectorsError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            ListVoiceConnectorsError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            ListVoiceConnectorsError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            ListVoiceConnectorsError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListVoiceConnectorsError {}
/// Errors returned by LogoutUser
#[derive(Debug, PartialEq)]
pub enum LogoutUserError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl LogoutUserError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<LogoutUserError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(LogoutUserError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(LogoutUserError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(LogoutUserError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(LogoutUserError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(LogoutUserError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(LogoutUserError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(LogoutUserError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for LogoutUserError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            LogoutUserError::BadRequest(ref cause) => write!(f, "{}", cause),
            LogoutUserError::Forbidden(ref cause) => write!(f, "{}", cause),
            LogoutUserError::NotFound(ref cause) => write!(f, "{}", cause),
            LogoutUserError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            LogoutUserError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            LogoutUserError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            LogoutUserError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for LogoutUserError {}
/// Errors returned by PutAppInstanceRetentionSettings
#[derive(Debug, PartialEq)]
pub enum PutAppInstanceRetentionSettingsError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The request could not be processed because of conflict in the current state of the resource.</p>
    Conflict(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl PutAppInstanceRetentionSettingsError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<PutAppInstanceRetentionSettingsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(PutAppInstanceRetentionSettingsError::BadRequest(
                        err.msg,
                    ))
                }
                "ConflictException" => {
                    return RusotoError::Service(PutAppInstanceRetentionSettingsError::Conflict(
                        err.msg,
                    ))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(PutAppInstanceRetentionSettingsError::Forbidden(
                        err.msg,
                    ))
                }
                "NotFoundException" => {
                    return RusotoError::Service(PutAppInstanceRetentionSettingsError::NotFound(
                        err.msg,
                    ))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(
                        PutAppInstanceRetentionSettingsError::ServiceFailure(err.msg),
                    )
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        PutAppInstanceRetentionSettingsError::ServiceUnavailable(err.msg),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(
                        PutAppInstanceRetentionSettingsError::ThrottledClient(err.msg),
                    )
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        PutAppInstanceRetentionSettingsError::UnauthorizedClient(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for PutAppInstanceRetentionSettingsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            PutAppInstanceRetentionSettingsError::BadRequest(ref cause) => write!(f, "{}", cause),
            PutAppInstanceRetentionSettingsError::Conflict(ref cause) => write!(f, "{}", cause),
            PutAppInstanceRetentionSettingsError::Forbidden(ref cause) => write!(f, "{}", cause),
            PutAppInstanceRetentionSettingsError::NotFound(ref cause) => write!(f, "{}", cause),
            PutAppInstanceRetentionSettingsError::ServiceFailure(ref cause) => {
                write!(f, "{}", cause)
            }
            PutAppInstanceRetentionSettingsError::ServiceUnavailable(ref cause) => {
                write!(f, "{}", cause)
            }
            PutAppInstanceRetentionSettingsError::ThrottledClient(ref cause) => {
                write!(f, "{}", cause)
            }
            PutAppInstanceRetentionSettingsError::UnauthorizedClient(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for PutAppInstanceRetentionSettingsError {}
/// Errors returned by PutAppInstanceStreamingConfigurations
#[derive(Debug, PartialEq)]
pub enum PutAppInstanceStreamingConfigurationsError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl PutAppInstanceStreamingConfigurationsError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<PutAppInstanceStreamingConfigurationsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(
                        PutAppInstanceStreamingConfigurationsError::BadRequest(err.msg),
                    )
                }
                "ForbiddenException" => {
                    return RusotoError::Service(
                        PutAppInstanceStreamingConfigurationsError::Forbidden(err.msg),
                    )
                }
                "NotFoundException" => {
                    return RusotoError::Service(
                        PutAppInstanceStreamingConfigurationsError::NotFound(err.msg),
                    )
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(
                        PutAppInstanceStreamingConfigurationsError::ServiceFailure(err.msg),
                    )
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        PutAppInstanceStreamingConfigurationsError::ServiceUnavailable(err.msg),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(
                        PutAppInstanceStreamingConfigurationsError::ThrottledClient(err.msg),
                    )
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        PutAppInstanceStreamingConfigurationsError::UnauthorizedClient(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for PutAppInstanceStreamingConfigurationsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            PutAppInstanceStreamingConfigurationsError::BadRequest(ref cause) => {
                write!(f, "{}", cause)
            }
            PutAppInstanceStreamingConfigurationsError::Forbidden(ref cause) => {
                write!(f, "{}", cause)
            }
            PutAppInstanceStreamingConfigurationsError::NotFound(ref cause) => {
                write!(f, "{}", cause)
            }
            PutAppInstanceStreamingConfigurationsError::ServiceFailure(ref cause) => {
                write!(f, "{}", cause)
            }
            PutAppInstanceStreamingConfigurationsError::ServiceUnavailable(ref cause) => {
                write!(f, "{}", cause)
            }
            PutAppInstanceStreamingConfigurationsError::ThrottledClient(ref cause) => {
                write!(f, "{}", cause)
            }
            PutAppInstanceStreamingConfigurationsError::UnauthorizedClient(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for PutAppInstanceStreamingConfigurationsError {}
/// Errors returned by PutEventsConfiguration
#[derive(Debug, PartialEq)]
pub enum PutEventsConfigurationError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceeded(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl PutEventsConfigurationError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<PutEventsConfigurationError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(PutEventsConfigurationError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(PutEventsConfigurationError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(PutEventsConfigurationError::NotFound(err.msg))
                }
                "ResourceLimitExceededException" => {
                    return RusotoError::Service(
                        PutEventsConfigurationError::ResourceLimitExceeded(err.msg),
                    )
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(PutEventsConfigurationError::ServiceFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(PutEventsConfigurationError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(PutEventsConfigurationError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for PutEventsConfigurationError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            PutEventsConfigurationError::BadRequest(ref cause) => write!(f, "{}", cause),
            PutEventsConfigurationError::Forbidden(ref cause) => write!(f, "{}", cause),
            PutEventsConfigurationError::NotFound(ref cause) => write!(f, "{}", cause),
            PutEventsConfigurationError::ResourceLimitExceeded(ref cause) => write!(f, "{}", cause),
            PutEventsConfigurationError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            PutEventsConfigurationError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            PutEventsConfigurationError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for PutEventsConfigurationError {}
/// Errors returned by PutRetentionSettings
#[derive(Debug, PartialEq)]
pub enum PutRetentionSettingsError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The request could not be processed because of conflict in the current state of the resource.</p>
    Conflict(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl PutRetentionSettingsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<PutRetentionSettingsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(PutRetentionSettingsError::BadRequest(err.msg))
                }
                "ConflictException" => {
                    return RusotoError::Service(PutRetentionSettingsError::Conflict(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(PutRetentionSettingsError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(PutRetentionSettingsError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(PutRetentionSettingsError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(PutRetentionSettingsError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(PutRetentionSettingsError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(PutRetentionSettingsError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for PutRetentionSettingsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            PutRetentionSettingsError::BadRequest(ref cause) => write!(f, "{}", cause),
            PutRetentionSettingsError::Conflict(ref cause) => write!(f, "{}", cause),
            PutRetentionSettingsError::Forbidden(ref cause) => write!(f, "{}", cause),
            PutRetentionSettingsError::NotFound(ref cause) => write!(f, "{}", cause),
            PutRetentionSettingsError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            PutRetentionSettingsError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            PutRetentionSettingsError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            PutRetentionSettingsError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for PutRetentionSettingsError {}
/// Errors returned by PutSipMediaApplicationLoggingConfiguration
#[derive(Debug, PartialEq)]
pub enum PutSipMediaApplicationLoggingConfigurationError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl PutSipMediaApplicationLoggingConfigurationError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<PutSipMediaApplicationLoggingConfigurationError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(
                        PutSipMediaApplicationLoggingConfigurationError::BadRequest(err.msg),
                    )
                }
                "ForbiddenException" => {
                    return RusotoError::Service(
                        PutSipMediaApplicationLoggingConfigurationError::Forbidden(err.msg),
                    )
                }
                "NotFoundException" => {
                    return RusotoError::Service(
                        PutSipMediaApplicationLoggingConfigurationError::NotFound(err.msg),
                    )
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(
                        PutSipMediaApplicationLoggingConfigurationError::ServiceFailure(err.msg),
                    )
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        PutSipMediaApplicationLoggingConfigurationError::ServiceUnavailable(
                            err.msg,
                        ),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(
                        PutSipMediaApplicationLoggingConfigurationError::ThrottledClient(err.msg),
                    )
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        PutSipMediaApplicationLoggingConfigurationError::UnauthorizedClient(
                            err.msg,
                        ),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for PutSipMediaApplicationLoggingConfigurationError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            PutSipMediaApplicationLoggingConfigurationError::BadRequest(ref cause) => {
                write!(f, "{}", cause)
            }
            PutSipMediaApplicationLoggingConfigurationError::Forbidden(ref cause) => {
                write!(f, "{}", cause)
            }
            PutSipMediaApplicationLoggingConfigurationError::NotFound(ref cause) => {
                write!(f, "{}", cause)
            }
            PutSipMediaApplicationLoggingConfigurationError::ServiceFailure(ref cause) => {
                write!(f, "{}", cause)
            }
            PutSipMediaApplicationLoggingConfigurationError::ServiceUnavailable(ref cause) => {
                write!(f, "{}", cause)
            }
            PutSipMediaApplicationLoggingConfigurationError::ThrottledClient(ref cause) => {
                write!(f, "{}", cause)
            }
            PutSipMediaApplicationLoggingConfigurationError::UnauthorizedClient(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for PutSipMediaApplicationLoggingConfigurationError {}
/// Errors returned by PutVoiceConnectorEmergencyCallingConfiguration
#[derive(Debug, PartialEq)]
pub enum PutVoiceConnectorEmergencyCallingConfigurationError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl PutVoiceConnectorEmergencyCallingConfigurationError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<PutVoiceConnectorEmergencyCallingConfigurationError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(
                        PutVoiceConnectorEmergencyCallingConfigurationError::BadRequest(err.msg),
                    )
                }
                "ForbiddenException" => {
                    return RusotoError::Service(
                        PutVoiceConnectorEmergencyCallingConfigurationError::Forbidden(err.msg),
                    )
                }
                "NotFoundException" => {
                    return RusotoError::Service(
                        PutVoiceConnectorEmergencyCallingConfigurationError::NotFound(err.msg),
                    )
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(
                        PutVoiceConnectorEmergencyCallingConfigurationError::ServiceFailure(
                            err.msg,
                        ),
                    )
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        PutVoiceConnectorEmergencyCallingConfigurationError::ServiceUnavailable(
                            err.msg,
                        ),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(
                        PutVoiceConnectorEmergencyCallingConfigurationError::ThrottledClient(
                            err.msg,
                        ),
                    )
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        PutVoiceConnectorEmergencyCallingConfigurationError::UnauthorizedClient(
                            err.msg,
                        ),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for PutVoiceConnectorEmergencyCallingConfigurationError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            PutVoiceConnectorEmergencyCallingConfigurationError::BadRequest(ref cause) => {
                write!(f, "{}", cause)
            }
            PutVoiceConnectorEmergencyCallingConfigurationError::Forbidden(ref cause) => {
                write!(f, "{}", cause)
            }
            PutVoiceConnectorEmergencyCallingConfigurationError::NotFound(ref cause) => {
                write!(f, "{}", cause)
            }
            PutVoiceConnectorEmergencyCallingConfigurationError::ServiceFailure(ref cause) => {
                write!(f, "{}", cause)
            }
            PutVoiceConnectorEmergencyCallingConfigurationError::ServiceUnavailable(ref cause) => {
                write!(f, "{}", cause)
            }
            PutVoiceConnectorEmergencyCallingConfigurationError::ThrottledClient(ref cause) => {
                write!(f, "{}", cause)
            }
            PutVoiceConnectorEmergencyCallingConfigurationError::UnauthorizedClient(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for PutVoiceConnectorEmergencyCallingConfigurationError {}
/// Errors returned by PutVoiceConnectorLoggingConfiguration
#[derive(Debug, PartialEq)]
pub enum PutVoiceConnectorLoggingConfigurationError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl PutVoiceConnectorLoggingConfigurationError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<PutVoiceConnectorLoggingConfigurationError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(
                        PutVoiceConnectorLoggingConfigurationError::BadRequest(err.msg),
                    )
                }
                "ForbiddenException" => {
                    return RusotoError::Service(
                        PutVoiceConnectorLoggingConfigurationError::Forbidden(err.msg),
                    )
                }
                "NotFoundException" => {
                    return RusotoError::Service(
                        PutVoiceConnectorLoggingConfigurationError::NotFound(err.msg),
                    )
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(
                        PutVoiceConnectorLoggingConfigurationError::ServiceFailure(err.msg),
                    )
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        PutVoiceConnectorLoggingConfigurationError::ServiceUnavailable(err.msg),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(
                        PutVoiceConnectorLoggingConfigurationError::ThrottledClient(err.msg),
                    )
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        PutVoiceConnectorLoggingConfigurationError::UnauthorizedClient(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for PutVoiceConnectorLoggingConfigurationError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            PutVoiceConnectorLoggingConfigurationError::BadRequest(ref cause) => {
                write!(f, "{}", cause)
            }
            PutVoiceConnectorLoggingConfigurationError::Forbidden(ref cause) => {
                write!(f, "{}", cause)
            }
            PutVoiceConnectorLoggingConfigurationError::NotFound(ref cause) => {
                write!(f, "{}", cause)
            }
            PutVoiceConnectorLoggingConfigurationError::ServiceFailure(ref cause) => {
                write!(f, "{}", cause)
            }
            PutVoiceConnectorLoggingConfigurationError::ServiceUnavailable(ref cause) => {
                write!(f, "{}", cause)
            }
            PutVoiceConnectorLoggingConfigurationError::ThrottledClient(ref cause) => {
                write!(f, "{}", cause)
            }
            PutVoiceConnectorLoggingConfigurationError::UnauthorizedClient(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for PutVoiceConnectorLoggingConfigurationError {}
/// Errors returned by PutVoiceConnectorOrigination
#[derive(Debug, PartialEq)]
pub enum PutVoiceConnectorOriginationError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl PutVoiceConnectorOriginationError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<PutVoiceConnectorOriginationError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(PutVoiceConnectorOriginationError::BadRequest(
                        err.msg,
                    ))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(PutVoiceConnectorOriginationError::Forbidden(
                        err.msg,
                    ))
                }
                "NotFoundException" => {
                    return RusotoError::Service(PutVoiceConnectorOriginationError::NotFound(
                        err.msg,
                    ))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(PutVoiceConnectorOriginationError::ServiceFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        PutVoiceConnectorOriginationError::ServiceUnavailable(err.msg),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(
                        PutVoiceConnectorOriginationError::ThrottledClient(err.msg),
                    )
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        PutVoiceConnectorOriginationError::UnauthorizedClient(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for PutVoiceConnectorOriginationError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            PutVoiceConnectorOriginationError::BadRequest(ref cause) => write!(f, "{}", cause),
            PutVoiceConnectorOriginationError::Forbidden(ref cause) => write!(f, "{}", cause),
            PutVoiceConnectorOriginationError::NotFound(ref cause) => write!(f, "{}", cause),
            PutVoiceConnectorOriginationError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            PutVoiceConnectorOriginationError::ServiceUnavailable(ref cause) => {
                write!(f, "{}", cause)
            }
            PutVoiceConnectorOriginationError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            PutVoiceConnectorOriginationError::UnauthorizedClient(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for PutVoiceConnectorOriginationError {}
/// Errors returned by PutVoiceConnectorProxy
#[derive(Debug, PartialEq)]
pub enum PutVoiceConnectorProxyError {
    /// <p>You don't have permissions to perform the requested operation.</p>
    AccessDenied(String),
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl PutVoiceConnectorProxyError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<PutVoiceConnectorProxyError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(PutVoiceConnectorProxyError::AccessDenied(err.msg))
                }
                "BadRequestException" => {
                    return RusotoError::Service(PutVoiceConnectorProxyError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(PutVoiceConnectorProxyError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(PutVoiceConnectorProxyError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(PutVoiceConnectorProxyError::ServiceFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(PutVoiceConnectorProxyError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(PutVoiceConnectorProxyError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(PutVoiceConnectorProxyError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for PutVoiceConnectorProxyError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            PutVoiceConnectorProxyError::AccessDenied(ref cause) => write!(f, "{}", cause),
            PutVoiceConnectorProxyError::BadRequest(ref cause) => write!(f, "{}", cause),
            PutVoiceConnectorProxyError::Forbidden(ref cause) => write!(f, "{}", cause),
            PutVoiceConnectorProxyError::NotFound(ref cause) => write!(f, "{}", cause),
            PutVoiceConnectorProxyError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            PutVoiceConnectorProxyError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            PutVoiceConnectorProxyError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            PutVoiceConnectorProxyError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for PutVoiceConnectorProxyError {}
/// Errors returned by PutVoiceConnectorStreamingConfiguration
#[derive(Debug, PartialEq)]
pub enum PutVoiceConnectorStreamingConfigurationError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl PutVoiceConnectorStreamingConfigurationError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<PutVoiceConnectorStreamingConfigurationError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(
                        PutVoiceConnectorStreamingConfigurationError::BadRequest(err.msg),
                    )
                }
                "ForbiddenException" => {
                    return RusotoError::Service(
                        PutVoiceConnectorStreamingConfigurationError::Forbidden(err.msg),
                    )
                }
                "NotFoundException" => {
                    return RusotoError::Service(
                        PutVoiceConnectorStreamingConfigurationError::NotFound(err.msg),
                    )
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(
                        PutVoiceConnectorStreamingConfigurationError::ServiceFailure(err.msg),
                    )
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        PutVoiceConnectorStreamingConfigurationError::ServiceUnavailable(err.msg),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(
                        PutVoiceConnectorStreamingConfigurationError::ThrottledClient(err.msg),
                    )
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        PutVoiceConnectorStreamingConfigurationError::UnauthorizedClient(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for PutVoiceConnectorStreamingConfigurationError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            PutVoiceConnectorStreamingConfigurationError::BadRequest(ref cause) => {
                write!(f, "{}", cause)
            }
            PutVoiceConnectorStreamingConfigurationError::Forbidden(ref cause) => {
                write!(f, "{}", cause)
            }
            PutVoiceConnectorStreamingConfigurationError::NotFound(ref cause) => {
                write!(f, "{}", cause)
            }
            PutVoiceConnectorStreamingConfigurationError::ServiceFailure(ref cause) => {
                write!(f, "{}", cause)
            }
            PutVoiceConnectorStreamingConfigurationError::ServiceUnavailable(ref cause) => {
                write!(f, "{}", cause)
            }
            PutVoiceConnectorStreamingConfigurationError::ThrottledClient(ref cause) => {
                write!(f, "{}", cause)
            }
            PutVoiceConnectorStreamingConfigurationError::UnauthorizedClient(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for PutVoiceConnectorStreamingConfigurationError {}
/// Errors returned by PutVoiceConnectorTermination
#[derive(Debug, PartialEq)]
pub enum PutVoiceConnectorTerminationError {
    /// <p>You don't have permissions to perform the requested operation.</p>
    AccessDenied(String),
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl PutVoiceConnectorTerminationError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<PutVoiceConnectorTerminationError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(PutVoiceConnectorTerminationError::AccessDenied(
                        err.msg,
                    ))
                }
                "BadRequestException" => {
                    return RusotoError::Service(PutVoiceConnectorTerminationError::BadRequest(
                        err.msg,
                    ))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(PutVoiceConnectorTerminationError::Forbidden(
                        err.msg,
                    ))
                }
                "NotFoundException" => {
                    return RusotoError::Service(PutVoiceConnectorTerminationError::NotFound(
                        err.msg,
                    ))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(PutVoiceConnectorTerminationError::ServiceFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        PutVoiceConnectorTerminationError::ServiceUnavailable(err.msg),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(
                        PutVoiceConnectorTerminationError::ThrottledClient(err.msg),
                    )
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        PutVoiceConnectorTerminationError::UnauthorizedClient(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for PutVoiceConnectorTerminationError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            PutVoiceConnectorTerminationError::AccessDenied(ref cause) => write!(f, "{}", cause),
            PutVoiceConnectorTerminationError::BadRequest(ref cause) => write!(f, "{}", cause),
            PutVoiceConnectorTerminationError::Forbidden(ref cause) => write!(f, "{}", cause),
            PutVoiceConnectorTerminationError::NotFound(ref cause) => write!(f, "{}", cause),
            PutVoiceConnectorTerminationError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            PutVoiceConnectorTerminationError::ServiceUnavailable(ref cause) => {
                write!(f, "{}", cause)
            }
            PutVoiceConnectorTerminationError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            PutVoiceConnectorTerminationError::UnauthorizedClient(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for PutVoiceConnectorTerminationError {}
/// Errors returned by PutVoiceConnectorTerminationCredentials
#[derive(Debug, PartialEq)]
pub enum PutVoiceConnectorTerminationCredentialsError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl PutVoiceConnectorTerminationCredentialsError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<PutVoiceConnectorTerminationCredentialsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(
                        PutVoiceConnectorTerminationCredentialsError::BadRequest(err.msg),
                    )
                }
                "ForbiddenException" => {
                    return RusotoError::Service(
                        PutVoiceConnectorTerminationCredentialsError::Forbidden(err.msg),
                    )
                }
                "NotFoundException" => {
                    return RusotoError::Service(
                        PutVoiceConnectorTerminationCredentialsError::NotFound(err.msg),
                    )
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(
                        PutVoiceConnectorTerminationCredentialsError::ServiceFailure(err.msg),
                    )
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        PutVoiceConnectorTerminationCredentialsError::ServiceUnavailable(err.msg),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(
                        PutVoiceConnectorTerminationCredentialsError::ThrottledClient(err.msg),
                    )
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        PutVoiceConnectorTerminationCredentialsError::UnauthorizedClient(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for PutVoiceConnectorTerminationCredentialsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            PutVoiceConnectorTerminationCredentialsError::BadRequest(ref cause) => {
                write!(f, "{}", cause)
            }
            PutVoiceConnectorTerminationCredentialsError::Forbidden(ref cause) => {
                write!(f, "{}", cause)
            }
            PutVoiceConnectorTerminationCredentialsError::NotFound(ref cause) => {
                write!(f, "{}", cause)
            }
            PutVoiceConnectorTerminationCredentialsError::ServiceFailure(ref cause) => {
                write!(f, "{}", cause)
            }
            PutVoiceConnectorTerminationCredentialsError::ServiceUnavailable(ref cause) => {
                write!(f, "{}", cause)
            }
            PutVoiceConnectorTerminationCredentialsError::ThrottledClient(ref cause) => {
                write!(f, "{}", cause)
            }
            PutVoiceConnectorTerminationCredentialsError::UnauthorizedClient(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for PutVoiceConnectorTerminationCredentialsError {}
/// Errors returned by RedactChannelMessage
#[derive(Debug, PartialEq)]
pub enum RedactChannelMessageError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl RedactChannelMessageError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<RedactChannelMessageError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(RedactChannelMessageError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(RedactChannelMessageError::Forbidden(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(RedactChannelMessageError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(RedactChannelMessageError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(RedactChannelMessageError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(RedactChannelMessageError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for RedactChannelMessageError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            RedactChannelMessageError::BadRequest(ref cause) => write!(f, "{}", cause),
            RedactChannelMessageError::Forbidden(ref cause) => write!(f, "{}", cause),
            RedactChannelMessageError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            RedactChannelMessageError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            RedactChannelMessageError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            RedactChannelMessageError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for RedactChannelMessageError {}
/// Errors returned by RedactConversationMessage
#[derive(Debug, PartialEq)]
pub enum RedactConversationMessageError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl RedactConversationMessageError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<RedactConversationMessageError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(RedactConversationMessageError::BadRequest(
                        err.msg,
                    ))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(RedactConversationMessageError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(RedactConversationMessageError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(RedactConversationMessageError::ServiceFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        RedactConversationMessageError::ServiceUnavailable(err.msg),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(RedactConversationMessageError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        RedactConversationMessageError::UnauthorizedClient(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for RedactConversationMessageError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            RedactConversationMessageError::BadRequest(ref cause) => write!(f, "{}", cause),
            RedactConversationMessageError::Forbidden(ref cause) => write!(f, "{}", cause),
            RedactConversationMessageError::NotFound(ref cause) => write!(f, "{}", cause),
            RedactConversationMessageError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            RedactConversationMessageError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            RedactConversationMessageError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            RedactConversationMessageError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for RedactConversationMessageError {}
/// Errors returned by RedactRoomMessage
#[derive(Debug, PartialEq)]
pub enum RedactRoomMessageError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl RedactRoomMessageError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<RedactRoomMessageError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(RedactRoomMessageError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(RedactRoomMessageError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(RedactRoomMessageError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(RedactRoomMessageError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(RedactRoomMessageError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(RedactRoomMessageError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(RedactRoomMessageError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for RedactRoomMessageError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            RedactRoomMessageError::BadRequest(ref cause) => write!(f, "{}", cause),
            RedactRoomMessageError::Forbidden(ref cause) => write!(f, "{}", cause),
            RedactRoomMessageError::NotFound(ref cause) => write!(f, "{}", cause),
            RedactRoomMessageError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            RedactRoomMessageError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            RedactRoomMessageError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            RedactRoomMessageError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for RedactRoomMessageError {}
/// Errors returned by RegenerateSecurityToken
#[derive(Debug, PartialEq)]
pub enum RegenerateSecurityTokenError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl RegenerateSecurityTokenError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<RegenerateSecurityTokenError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(RegenerateSecurityTokenError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(RegenerateSecurityTokenError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(RegenerateSecurityTokenError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(RegenerateSecurityTokenError::ServiceFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(RegenerateSecurityTokenError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(RegenerateSecurityTokenError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(RegenerateSecurityTokenError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for RegenerateSecurityTokenError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            RegenerateSecurityTokenError::BadRequest(ref cause) => write!(f, "{}", cause),
            RegenerateSecurityTokenError::Forbidden(ref cause) => write!(f, "{}", cause),
            RegenerateSecurityTokenError::NotFound(ref cause) => write!(f, "{}", cause),
            RegenerateSecurityTokenError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            RegenerateSecurityTokenError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            RegenerateSecurityTokenError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            RegenerateSecurityTokenError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for RegenerateSecurityTokenError {}
/// Errors returned by ResetPersonalPIN
#[derive(Debug, PartialEq)]
pub enum ResetPersonalPINError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl ResetPersonalPINError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ResetPersonalPINError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(ResetPersonalPINError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(ResetPersonalPINError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(ResetPersonalPINError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(ResetPersonalPINError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(ResetPersonalPINError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(ResetPersonalPINError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(ResetPersonalPINError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ResetPersonalPINError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ResetPersonalPINError::BadRequest(ref cause) => write!(f, "{}", cause),
            ResetPersonalPINError::Forbidden(ref cause) => write!(f, "{}", cause),
            ResetPersonalPINError::NotFound(ref cause) => write!(f, "{}", cause),
            ResetPersonalPINError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            ResetPersonalPINError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            ResetPersonalPINError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            ResetPersonalPINError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ResetPersonalPINError {}
/// Errors returned by RestorePhoneNumber
#[derive(Debug, PartialEq)]
pub enum RestorePhoneNumberError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceeded(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl RestorePhoneNumberError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<RestorePhoneNumberError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(RestorePhoneNumberError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(RestorePhoneNumberError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(RestorePhoneNumberError::NotFound(err.msg))
                }
                "ResourceLimitExceededException" => {
                    return RusotoError::Service(RestorePhoneNumberError::ResourceLimitExceeded(
                        err.msg,
                    ))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(RestorePhoneNumberError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(RestorePhoneNumberError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(RestorePhoneNumberError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(RestorePhoneNumberError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for RestorePhoneNumberError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            RestorePhoneNumberError::BadRequest(ref cause) => write!(f, "{}", cause),
            RestorePhoneNumberError::Forbidden(ref cause) => write!(f, "{}", cause),
            RestorePhoneNumberError::NotFound(ref cause) => write!(f, "{}", cause),
            RestorePhoneNumberError::ResourceLimitExceeded(ref cause) => write!(f, "{}", cause),
            RestorePhoneNumberError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            RestorePhoneNumberError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            RestorePhoneNumberError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            RestorePhoneNumberError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for RestorePhoneNumberError {}
/// Errors returned by SearchAvailablePhoneNumbers
#[derive(Debug, PartialEq)]
pub enum SearchAvailablePhoneNumbersError {
    /// <p>You don't have permissions to perform the requested operation.</p>
    AccessDenied(String),
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl SearchAvailablePhoneNumbersError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<SearchAvailablePhoneNumbersError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(SearchAvailablePhoneNumbersError::AccessDenied(
                        err.msg,
                    ))
                }
                "BadRequestException" => {
                    return RusotoError::Service(SearchAvailablePhoneNumbersError::BadRequest(
                        err.msg,
                    ))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(SearchAvailablePhoneNumbersError::Forbidden(
                        err.msg,
                    ))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(SearchAvailablePhoneNumbersError::ServiceFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        SearchAvailablePhoneNumbersError::ServiceUnavailable(err.msg),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(SearchAvailablePhoneNumbersError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        SearchAvailablePhoneNumbersError::UnauthorizedClient(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for SearchAvailablePhoneNumbersError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            SearchAvailablePhoneNumbersError::AccessDenied(ref cause) => write!(f, "{}", cause),
            SearchAvailablePhoneNumbersError::BadRequest(ref cause) => write!(f, "{}", cause),
            SearchAvailablePhoneNumbersError::Forbidden(ref cause) => write!(f, "{}", cause),
            SearchAvailablePhoneNumbersError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            SearchAvailablePhoneNumbersError::ServiceUnavailable(ref cause) => {
                write!(f, "{}", cause)
            }
            SearchAvailablePhoneNumbersError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            SearchAvailablePhoneNumbersError::UnauthorizedClient(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for SearchAvailablePhoneNumbersError {}
/// Errors returned by SendChannelMessage
#[derive(Debug, PartialEq)]
pub enum SendChannelMessageError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The request could not be processed because of conflict in the current state of the resource.</p>
    Conflict(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl SendChannelMessageError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<SendChannelMessageError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(SendChannelMessageError::BadRequest(err.msg))
                }
                "ConflictException" => {
                    return RusotoError::Service(SendChannelMessageError::Conflict(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(SendChannelMessageError::Forbidden(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(SendChannelMessageError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(SendChannelMessageError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(SendChannelMessageError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(SendChannelMessageError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for SendChannelMessageError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            SendChannelMessageError::BadRequest(ref cause) => write!(f, "{}", cause),
            SendChannelMessageError::Conflict(ref cause) => write!(f, "{}", cause),
            SendChannelMessageError::Forbidden(ref cause) => write!(f, "{}", cause),
            SendChannelMessageError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            SendChannelMessageError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            SendChannelMessageError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            SendChannelMessageError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for SendChannelMessageError {}
/// Errors returned by TagAttendee
#[derive(Debug, PartialEq)]
pub enum TagAttendeeError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceeded(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl TagAttendeeError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<TagAttendeeError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(TagAttendeeError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(TagAttendeeError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(TagAttendeeError::NotFound(err.msg))
                }
                "ResourceLimitExceededException" => {
                    return RusotoError::Service(TagAttendeeError::ResourceLimitExceeded(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(TagAttendeeError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(TagAttendeeError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(TagAttendeeError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(TagAttendeeError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for TagAttendeeError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            TagAttendeeError::BadRequest(ref cause) => write!(f, "{}", cause),
            TagAttendeeError::Forbidden(ref cause) => write!(f, "{}", cause),
            TagAttendeeError::NotFound(ref cause) => write!(f, "{}", cause),
            TagAttendeeError::ResourceLimitExceeded(ref cause) => write!(f, "{}", cause),
            TagAttendeeError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            TagAttendeeError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            TagAttendeeError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            TagAttendeeError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for TagAttendeeError {}
/// Errors returned by TagMeeting
#[derive(Debug, PartialEq)]
pub enum TagMeetingError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceeded(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl TagMeetingError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<TagMeetingError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(TagMeetingError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(TagMeetingError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(TagMeetingError::NotFound(err.msg))
                }
                "ResourceLimitExceededException" => {
                    return RusotoError::Service(TagMeetingError::ResourceLimitExceeded(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(TagMeetingError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(TagMeetingError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(TagMeetingError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(TagMeetingError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for TagMeetingError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            TagMeetingError::BadRequest(ref cause) => write!(f, "{}", cause),
            TagMeetingError::Forbidden(ref cause) => write!(f, "{}", cause),
            TagMeetingError::NotFound(ref cause) => write!(f, "{}", cause),
            TagMeetingError::ResourceLimitExceeded(ref cause) => write!(f, "{}", cause),
            TagMeetingError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            TagMeetingError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            TagMeetingError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            TagMeetingError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for TagMeetingError {}
/// Errors returned by TagResource
#[derive(Debug, PartialEq)]
pub enum TagResourceError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl TagResourceError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<TagResourceError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(TagResourceError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(TagResourceError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(TagResourceError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(TagResourceError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(TagResourceError::ServiceUnavailable(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(TagResourceError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for TagResourceError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            TagResourceError::BadRequest(ref cause) => write!(f, "{}", cause),
            TagResourceError::Forbidden(ref cause) => write!(f, "{}", cause),
            TagResourceError::NotFound(ref cause) => write!(f, "{}", cause),
            TagResourceError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            TagResourceError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            TagResourceError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for TagResourceError {}
/// Errors returned by UntagAttendee
#[derive(Debug, PartialEq)]
pub enum UntagAttendeeError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl UntagAttendeeError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<UntagAttendeeError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(UntagAttendeeError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(UntagAttendeeError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(UntagAttendeeError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(UntagAttendeeError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(UntagAttendeeError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(UntagAttendeeError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(UntagAttendeeError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for UntagAttendeeError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            UntagAttendeeError::BadRequest(ref cause) => write!(f, "{}", cause),
            UntagAttendeeError::Forbidden(ref cause) => write!(f, "{}", cause),
            UntagAttendeeError::NotFound(ref cause) => write!(f, "{}", cause),
            UntagAttendeeError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            UntagAttendeeError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            UntagAttendeeError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            UntagAttendeeError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for UntagAttendeeError {}
/// Errors returned by UntagMeeting
#[derive(Debug, PartialEq)]
pub enum UntagMeetingError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl UntagMeetingError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<UntagMeetingError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(UntagMeetingError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(UntagMeetingError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(UntagMeetingError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(UntagMeetingError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(UntagMeetingError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(UntagMeetingError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(UntagMeetingError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for UntagMeetingError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            UntagMeetingError::BadRequest(ref cause) => write!(f, "{}", cause),
            UntagMeetingError::Forbidden(ref cause) => write!(f, "{}", cause),
            UntagMeetingError::NotFound(ref cause) => write!(f, "{}", cause),
            UntagMeetingError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            UntagMeetingError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            UntagMeetingError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            UntagMeetingError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for UntagMeetingError {}
/// Errors returned by UntagResource
#[derive(Debug, PartialEq)]
pub enum UntagResourceError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl UntagResourceError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<UntagResourceError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(UntagResourceError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(UntagResourceError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(UntagResourceError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(UntagResourceError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(UntagResourceError::ServiceUnavailable(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(UntagResourceError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for UntagResourceError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            UntagResourceError::BadRequest(ref cause) => write!(f, "{}", cause),
            UntagResourceError::Forbidden(ref cause) => write!(f, "{}", cause),
            UntagResourceError::NotFound(ref cause) => write!(f, "{}", cause),
            UntagResourceError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            UntagResourceError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            UntagResourceError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for UntagResourceError {}
/// Errors returned by UpdateAccount
#[derive(Debug, PartialEq)]
pub enum UpdateAccountError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl UpdateAccountError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<UpdateAccountError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(UpdateAccountError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(UpdateAccountError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(UpdateAccountError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(UpdateAccountError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(UpdateAccountError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(UpdateAccountError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(UpdateAccountError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for UpdateAccountError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            UpdateAccountError::BadRequest(ref cause) => write!(f, "{}", cause),
            UpdateAccountError::Forbidden(ref cause) => write!(f, "{}", cause),
            UpdateAccountError::NotFound(ref cause) => write!(f, "{}", cause),
            UpdateAccountError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            UpdateAccountError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            UpdateAccountError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            UpdateAccountError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for UpdateAccountError {}
/// Errors returned by UpdateAccountSettings
#[derive(Debug, PartialEq)]
pub enum UpdateAccountSettingsError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The request could not be processed because of conflict in the current state of the resource.</p>
    Conflict(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl UpdateAccountSettingsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<UpdateAccountSettingsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(UpdateAccountSettingsError::BadRequest(err.msg))
                }
                "ConflictException" => {
                    return RusotoError::Service(UpdateAccountSettingsError::Conflict(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(UpdateAccountSettingsError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(UpdateAccountSettingsError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(UpdateAccountSettingsError::ServiceFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(UpdateAccountSettingsError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(UpdateAccountSettingsError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(UpdateAccountSettingsError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for UpdateAccountSettingsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            UpdateAccountSettingsError::BadRequest(ref cause) => write!(f, "{}", cause),
            UpdateAccountSettingsError::Conflict(ref cause) => write!(f, "{}", cause),
            UpdateAccountSettingsError::Forbidden(ref cause) => write!(f, "{}", cause),
            UpdateAccountSettingsError::NotFound(ref cause) => write!(f, "{}", cause),
            UpdateAccountSettingsError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            UpdateAccountSettingsError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            UpdateAccountSettingsError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            UpdateAccountSettingsError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for UpdateAccountSettingsError {}
/// Errors returned by UpdateAppInstance
#[derive(Debug, PartialEq)]
pub enum UpdateAppInstanceError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The request could not be processed because of conflict in the current state of the resource.</p>
    Conflict(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl UpdateAppInstanceError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<UpdateAppInstanceError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(UpdateAppInstanceError::BadRequest(err.msg))
                }
                "ConflictException" => {
                    return RusotoError::Service(UpdateAppInstanceError::Conflict(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(UpdateAppInstanceError::Forbidden(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(UpdateAppInstanceError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(UpdateAppInstanceError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(UpdateAppInstanceError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(UpdateAppInstanceError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for UpdateAppInstanceError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            UpdateAppInstanceError::BadRequest(ref cause) => write!(f, "{}", cause),
            UpdateAppInstanceError::Conflict(ref cause) => write!(f, "{}", cause),
            UpdateAppInstanceError::Forbidden(ref cause) => write!(f, "{}", cause),
            UpdateAppInstanceError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            UpdateAppInstanceError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            UpdateAppInstanceError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            UpdateAppInstanceError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for UpdateAppInstanceError {}
/// Errors returned by UpdateAppInstanceUser
#[derive(Debug, PartialEq)]
pub enum UpdateAppInstanceUserError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The request could not be processed because of conflict in the current state of the resource.</p>
    Conflict(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl UpdateAppInstanceUserError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<UpdateAppInstanceUserError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(UpdateAppInstanceUserError::BadRequest(err.msg))
                }
                "ConflictException" => {
                    return RusotoError::Service(UpdateAppInstanceUserError::Conflict(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(UpdateAppInstanceUserError::Forbidden(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(UpdateAppInstanceUserError::ServiceFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(UpdateAppInstanceUserError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(UpdateAppInstanceUserError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(UpdateAppInstanceUserError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for UpdateAppInstanceUserError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            UpdateAppInstanceUserError::BadRequest(ref cause) => write!(f, "{}", cause),
            UpdateAppInstanceUserError::Conflict(ref cause) => write!(f, "{}", cause),
            UpdateAppInstanceUserError::Forbidden(ref cause) => write!(f, "{}", cause),
            UpdateAppInstanceUserError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            UpdateAppInstanceUserError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            UpdateAppInstanceUserError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            UpdateAppInstanceUserError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for UpdateAppInstanceUserError {}
/// Errors returned by UpdateBot
#[derive(Debug, PartialEq)]
pub enum UpdateBotError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl UpdateBotError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<UpdateBotError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(UpdateBotError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(UpdateBotError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(UpdateBotError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(UpdateBotError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(UpdateBotError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(UpdateBotError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(UpdateBotError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for UpdateBotError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            UpdateBotError::BadRequest(ref cause) => write!(f, "{}", cause),
            UpdateBotError::Forbidden(ref cause) => write!(f, "{}", cause),
            UpdateBotError::NotFound(ref cause) => write!(f, "{}", cause),
            UpdateBotError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            UpdateBotError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            UpdateBotError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            UpdateBotError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for UpdateBotError {}
/// Errors returned by UpdateChannel
#[derive(Debug, PartialEq)]
pub enum UpdateChannelError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The request could not be processed because of conflict in the current state of the resource.</p>
    Conflict(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl UpdateChannelError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<UpdateChannelError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(UpdateChannelError::BadRequest(err.msg))
                }
                "ConflictException" => {
                    return RusotoError::Service(UpdateChannelError::Conflict(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(UpdateChannelError::Forbidden(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(UpdateChannelError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(UpdateChannelError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(UpdateChannelError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(UpdateChannelError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for UpdateChannelError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            UpdateChannelError::BadRequest(ref cause) => write!(f, "{}", cause),
            UpdateChannelError::Conflict(ref cause) => write!(f, "{}", cause),
            UpdateChannelError::Forbidden(ref cause) => write!(f, "{}", cause),
            UpdateChannelError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            UpdateChannelError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            UpdateChannelError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            UpdateChannelError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for UpdateChannelError {}
/// Errors returned by UpdateChannelMessage
#[derive(Debug, PartialEq)]
pub enum UpdateChannelMessageError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The request could not be processed because of conflict in the current state of the resource.</p>
    Conflict(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl UpdateChannelMessageError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<UpdateChannelMessageError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(UpdateChannelMessageError::BadRequest(err.msg))
                }
                "ConflictException" => {
                    return RusotoError::Service(UpdateChannelMessageError::Conflict(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(UpdateChannelMessageError::Forbidden(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(UpdateChannelMessageError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(UpdateChannelMessageError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(UpdateChannelMessageError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(UpdateChannelMessageError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for UpdateChannelMessageError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            UpdateChannelMessageError::BadRequest(ref cause) => write!(f, "{}", cause),
            UpdateChannelMessageError::Conflict(ref cause) => write!(f, "{}", cause),
            UpdateChannelMessageError::Forbidden(ref cause) => write!(f, "{}", cause),
            UpdateChannelMessageError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            UpdateChannelMessageError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            UpdateChannelMessageError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            UpdateChannelMessageError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for UpdateChannelMessageError {}
/// Errors returned by UpdateChannelReadMarker
#[derive(Debug, PartialEq)]
pub enum UpdateChannelReadMarkerError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The request could not be processed because of conflict in the current state of the resource.</p>
    Conflict(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl UpdateChannelReadMarkerError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<UpdateChannelReadMarkerError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(UpdateChannelReadMarkerError::BadRequest(err.msg))
                }
                "ConflictException" => {
                    return RusotoError::Service(UpdateChannelReadMarkerError::Conflict(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(UpdateChannelReadMarkerError::Forbidden(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(UpdateChannelReadMarkerError::ServiceFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(UpdateChannelReadMarkerError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(UpdateChannelReadMarkerError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(UpdateChannelReadMarkerError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for UpdateChannelReadMarkerError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            UpdateChannelReadMarkerError::BadRequest(ref cause) => write!(f, "{}", cause),
            UpdateChannelReadMarkerError::Conflict(ref cause) => write!(f, "{}", cause),
            UpdateChannelReadMarkerError::Forbidden(ref cause) => write!(f, "{}", cause),
            UpdateChannelReadMarkerError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            UpdateChannelReadMarkerError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            UpdateChannelReadMarkerError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            UpdateChannelReadMarkerError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for UpdateChannelReadMarkerError {}
/// Errors returned by UpdateGlobalSettings
#[derive(Debug, PartialEq)]
pub enum UpdateGlobalSettingsError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl UpdateGlobalSettingsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<UpdateGlobalSettingsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(UpdateGlobalSettingsError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(UpdateGlobalSettingsError::Forbidden(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(UpdateGlobalSettingsError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(UpdateGlobalSettingsError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(UpdateGlobalSettingsError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(UpdateGlobalSettingsError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for UpdateGlobalSettingsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            UpdateGlobalSettingsError::BadRequest(ref cause) => write!(f, "{}", cause),
            UpdateGlobalSettingsError::Forbidden(ref cause) => write!(f, "{}", cause),
            UpdateGlobalSettingsError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            UpdateGlobalSettingsError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            UpdateGlobalSettingsError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            UpdateGlobalSettingsError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for UpdateGlobalSettingsError {}
/// Errors returned by UpdatePhoneNumber
#[derive(Debug, PartialEq)]
pub enum UpdatePhoneNumberError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl UpdatePhoneNumberError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<UpdatePhoneNumberError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(UpdatePhoneNumberError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(UpdatePhoneNumberError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(UpdatePhoneNumberError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(UpdatePhoneNumberError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(UpdatePhoneNumberError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(UpdatePhoneNumberError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(UpdatePhoneNumberError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for UpdatePhoneNumberError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            UpdatePhoneNumberError::BadRequest(ref cause) => write!(f, "{}", cause),
            UpdatePhoneNumberError::Forbidden(ref cause) => write!(f, "{}", cause),
            UpdatePhoneNumberError::NotFound(ref cause) => write!(f, "{}", cause),
            UpdatePhoneNumberError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            UpdatePhoneNumberError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            UpdatePhoneNumberError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            UpdatePhoneNumberError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for UpdatePhoneNumberError {}
/// Errors returned by UpdatePhoneNumberSettings
#[derive(Debug, PartialEq)]
pub enum UpdatePhoneNumberSettingsError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl UpdatePhoneNumberSettingsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<UpdatePhoneNumberSettingsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(UpdatePhoneNumberSettingsError::BadRequest(
                        err.msg,
                    ))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(UpdatePhoneNumberSettingsError::Forbidden(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(UpdatePhoneNumberSettingsError::ServiceFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        UpdatePhoneNumberSettingsError::ServiceUnavailable(err.msg),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(UpdatePhoneNumberSettingsError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        UpdatePhoneNumberSettingsError::UnauthorizedClient(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for UpdatePhoneNumberSettingsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            UpdatePhoneNumberSettingsError::BadRequest(ref cause) => write!(f, "{}", cause),
            UpdatePhoneNumberSettingsError::Forbidden(ref cause) => write!(f, "{}", cause),
            UpdatePhoneNumberSettingsError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            UpdatePhoneNumberSettingsError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            UpdatePhoneNumberSettingsError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            UpdatePhoneNumberSettingsError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for UpdatePhoneNumberSettingsError {}
/// Errors returned by UpdateProxySession
#[derive(Debug, PartialEq)]
pub enum UpdateProxySessionError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl UpdateProxySessionError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<UpdateProxySessionError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(UpdateProxySessionError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(UpdateProxySessionError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(UpdateProxySessionError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(UpdateProxySessionError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(UpdateProxySessionError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(UpdateProxySessionError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(UpdateProxySessionError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for UpdateProxySessionError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            UpdateProxySessionError::BadRequest(ref cause) => write!(f, "{}", cause),
            UpdateProxySessionError::Forbidden(ref cause) => write!(f, "{}", cause),
            UpdateProxySessionError::NotFound(ref cause) => write!(f, "{}", cause),
            UpdateProxySessionError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            UpdateProxySessionError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            UpdateProxySessionError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            UpdateProxySessionError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for UpdateProxySessionError {}
/// Errors returned by UpdateRoom
#[derive(Debug, PartialEq)]
pub enum UpdateRoomError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl UpdateRoomError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<UpdateRoomError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(UpdateRoomError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(UpdateRoomError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(UpdateRoomError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(UpdateRoomError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(UpdateRoomError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(UpdateRoomError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(UpdateRoomError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for UpdateRoomError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            UpdateRoomError::BadRequest(ref cause) => write!(f, "{}", cause),
            UpdateRoomError::Forbidden(ref cause) => write!(f, "{}", cause),
            UpdateRoomError::NotFound(ref cause) => write!(f, "{}", cause),
            UpdateRoomError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            UpdateRoomError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            UpdateRoomError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            UpdateRoomError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for UpdateRoomError {}
/// Errors returned by UpdateRoomMembership
#[derive(Debug, PartialEq)]
pub enum UpdateRoomMembershipError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl UpdateRoomMembershipError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<UpdateRoomMembershipError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(UpdateRoomMembershipError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(UpdateRoomMembershipError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(UpdateRoomMembershipError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(UpdateRoomMembershipError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(UpdateRoomMembershipError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(UpdateRoomMembershipError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(UpdateRoomMembershipError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for UpdateRoomMembershipError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            UpdateRoomMembershipError::BadRequest(ref cause) => write!(f, "{}", cause),
            UpdateRoomMembershipError::Forbidden(ref cause) => write!(f, "{}", cause),
            UpdateRoomMembershipError::NotFound(ref cause) => write!(f, "{}", cause),
            UpdateRoomMembershipError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            UpdateRoomMembershipError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            UpdateRoomMembershipError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            UpdateRoomMembershipError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for UpdateRoomMembershipError {}
/// Errors returned by UpdateSipMediaApplication
#[derive(Debug, PartialEq)]
pub enum UpdateSipMediaApplicationError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The request could not be processed because of conflict in the current state of the resource.</p>
    Conflict(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl UpdateSipMediaApplicationError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<UpdateSipMediaApplicationError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(UpdateSipMediaApplicationError::BadRequest(
                        err.msg,
                    ))
                }
                "ConflictException" => {
                    return RusotoError::Service(UpdateSipMediaApplicationError::Conflict(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(UpdateSipMediaApplicationError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(UpdateSipMediaApplicationError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(UpdateSipMediaApplicationError::ServiceFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        UpdateSipMediaApplicationError::ServiceUnavailable(err.msg),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(UpdateSipMediaApplicationError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        UpdateSipMediaApplicationError::UnauthorizedClient(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for UpdateSipMediaApplicationError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            UpdateSipMediaApplicationError::BadRequest(ref cause) => write!(f, "{}", cause),
            UpdateSipMediaApplicationError::Conflict(ref cause) => write!(f, "{}", cause),
            UpdateSipMediaApplicationError::Forbidden(ref cause) => write!(f, "{}", cause),
            UpdateSipMediaApplicationError::NotFound(ref cause) => write!(f, "{}", cause),
            UpdateSipMediaApplicationError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            UpdateSipMediaApplicationError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            UpdateSipMediaApplicationError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            UpdateSipMediaApplicationError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for UpdateSipMediaApplicationError {}
/// Errors returned by UpdateSipMediaApplicationCall
#[derive(Debug, PartialEq)]
pub enum UpdateSipMediaApplicationCallError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceeded(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl UpdateSipMediaApplicationCallError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<UpdateSipMediaApplicationCallError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(UpdateSipMediaApplicationCallError::BadRequest(
                        err.msg,
                    ))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(UpdateSipMediaApplicationCallError::Forbidden(
                        err.msg,
                    ))
                }
                "NotFoundException" => {
                    return RusotoError::Service(UpdateSipMediaApplicationCallError::NotFound(
                        err.msg,
                    ))
                }
                "ResourceLimitExceededException" => {
                    return RusotoError::Service(
                        UpdateSipMediaApplicationCallError::ResourceLimitExceeded(err.msg),
                    )
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(
                        UpdateSipMediaApplicationCallError::ServiceFailure(err.msg),
                    )
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        UpdateSipMediaApplicationCallError::ServiceUnavailable(err.msg),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(
                        UpdateSipMediaApplicationCallError::ThrottledClient(err.msg),
                    )
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        UpdateSipMediaApplicationCallError::UnauthorizedClient(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for UpdateSipMediaApplicationCallError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            UpdateSipMediaApplicationCallError::BadRequest(ref cause) => write!(f, "{}", cause),
            UpdateSipMediaApplicationCallError::Forbidden(ref cause) => write!(f, "{}", cause),
            UpdateSipMediaApplicationCallError::NotFound(ref cause) => write!(f, "{}", cause),
            UpdateSipMediaApplicationCallError::ResourceLimitExceeded(ref cause) => {
                write!(f, "{}", cause)
            }
            UpdateSipMediaApplicationCallError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            UpdateSipMediaApplicationCallError::ServiceUnavailable(ref cause) => {
                write!(f, "{}", cause)
            }
            UpdateSipMediaApplicationCallError::ThrottledClient(ref cause) => {
                write!(f, "{}", cause)
            }
            UpdateSipMediaApplicationCallError::UnauthorizedClient(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for UpdateSipMediaApplicationCallError {}
/// Errors returned by UpdateSipRule
#[derive(Debug, PartialEq)]
pub enum UpdateSipRuleError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The request could not be processed because of conflict in the current state of the resource.</p>
    Conflict(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceeded(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl UpdateSipRuleError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<UpdateSipRuleError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(UpdateSipRuleError::BadRequest(err.msg))
                }
                "ConflictException" => {
                    return RusotoError::Service(UpdateSipRuleError::Conflict(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(UpdateSipRuleError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(UpdateSipRuleError::NotFound(err.msg))
                }
                "ResourceLimitExceededException" => {
                    return RusotoError::Service(UpdateSipRuleError::ResourceLimitExceeded(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(UpdateSipRuleError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(UpdateSipRuleError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(UpdateSipRuleError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(UpdateSipRuleError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for UpdateSipRuleError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            UpdateSipRuleError::BadRequest(ref cause) => write!(f, "{}", cause),
            UpdateSipRuleError::Conflict(ref cause) => write!(f, "{}", cause),
            UpdateSipRuleError::Forbidden(ref cause) => write!(f, "{}", cause),
            UpdateSipRuleError::NotFound(ref cause) => write!(f, "{}", cause),
            UpdateSipRuleError::ResourceLimitExceeded(ref cause) => write!(f, "{}", cause),
            UpdateSipRuleError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            UpdateSipRuleError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            UpdateSipRuleError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            UpdateSipRuleError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for UpdateSipRuleError {}
/// Errors returned by UpdateUser
#[derive(Debug, PartialEq)]
pub enum UpdateUserError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl UpdateUserError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<UpdateUserError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(UpdateUserError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(UpdateUserError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(UpdateUserError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(UpdateUserError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(UpdateUserError::ServiceUnavailable(err.msg))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(UpdateUserError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(UpdateUserError::UnauthorizedClient(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for UpdateUserError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            UpdateUserError::BadRequest(ref cause) => write!(f, "{}", cause),
            UpdateUserError::Forbidden(ref cause) => write!(f, "{}", cause),
            UpdateUserError::NotFound(ref cause) => write!(f, "{}", cause),
            UpdateUserError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            UpdateUserError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            UpdateUserError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            UpdateUserError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for UpdateUserError {}
/// Errors returned by UpdateUserSettings
#[derive(Debug, PartialEq)]
pub enum UpdateUserSettingsError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl UpdateUserSettingsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<UpdateUserSettingsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(UpdateUserSettingsError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(UpdateUserSettingsError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(UpdateUserSettingsError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(UpdateUserSettingsError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(UpdateUserSettingsError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(UpdateUserSettingsError::ThrottledClient(err.msg))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(UpdateUserSettingsError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for UpdateUserSettingsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            UpdateUserSettingsError::BadRequest(ref cause) => write!(f, "{}", cause),
            UpdateUserSettingsError::Forbidden(ref cause) => write!(f, "{}", cause),
            UpdateUserSettingsError::NotFound(ref cause) => write!(f, "{}", cause),
            UpdateUserSettingsError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            UpdateUserSettingsError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            UpdateUserSettingsError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            UpdateUserSettingsError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for UpdateUserSettingsError {}
/// Errors returned by UpdateVoiceConnector
#[derive(Debug, PartialEq)]
pub enum UpdateVoiceConnectorError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl UpdateVoiceConnectorError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<UpdateVoiceConnectorError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(UpdateVoiceConnectorError::BadRequest(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(UpdateVoiceConnectorError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(UpdateVoiceConnectorError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(UpdateVoiceConnectorError::ServiceFailure(err.msg))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(UpdateVoiceConnectorError::ServiceUnavailable(
                        err.msg,
                    ))
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(UpdateVoiceConnectorError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(UpdateVoiceConnectorError::UnauthorizedClient(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for UpdateVoiceConnectorError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            UpdateVoiceConnectorError::BadRequest(ref cause) => write!(f, "{}", cause),
            UpdateVoiceConnectorError::Forbidden(ref cause) => write!(f, "{}", cause),
            UpdateVoiceConnectorError::NotFound(ref cause) => write!(f, "{}", cause),
            UpdateVoiceConnectorError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            UpdateVoiceConnectorError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            UpdateVoiceConnectorError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            UpdateVoiceConnectorError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for UpdateVoiceConnectorError {}
/// Errors returned by UpdateVoiceConnectorGroup
#[derive(Debug, PartialEq)]
pub enum UpdateVoiceConnectorGroupError {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequest(String),
    /// <p>The request could not be processed because of conflict in the current state of the resource.</p>
    Conflict(String),
    /// <p>The client is permanently forbidden from making the request.</p>
    Forbidden(String),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFound(String),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailure(String),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailable(String),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClient(String),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClient(String),
}

impl UpdateVoiceConnectorGroupError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<UpdateVoiceConnectorGroupError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "BadRequestException" => {
                    return RusotoError::Service(UpdateVoiceConnectorGroupError::BadRequest(
                        err.msg,
                    ))
                }
                "ConflictException" => {
                    return RusotoError::Service(UpdateVoiceConnectorGroupError::Conflict(err.msg))
                }
                "ForbiddenException" => {
                    return RusotoError::Service(UpdateVoiceConnectorGroupError::Forbidden(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(UpdateVoiceConnectorGroupError::NotFound(err.msg))
                }
                "ServiceFailureException" => {
                    return RusotoError::Service(UpdateVoiceConnectorGroupError::ServiceFailure(
                        err.msg,
                    ))
                }
                "ServiceUnavailableException" => {
                    return RusotoError::Service(
                        UpdateVoiceConnectorGroupError::ServiceUnavailable(err.msg),
                    )
                }
                "ThrottledClientException" => {
                    return RusotoError::Service(UpdateVoiceConnectorGroupError::ThrottledClient(
                        err.msg,
                    ))
                }
                "UnauthorizedClientException" => {
                    return RusotoError::Service(
                        UpdateVoiceConnectorGroupError::UnauthorizedClient(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for UpdateVoiceConnectorGroupError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            UpdateVoiceConnectorGroupError::BadRequest(ref cause) => write!(f, "{}", cause),
            UpdateVoiceConnectorGroupError::Conflict(ref cause) => write!(f, "{}", cause),
            UpdateVoiceConnectorGroupError::Forbidden(ref cause) => write!(f, "{}", cause),
            UpdateVoiceConnectorGroupError::NotFound(ref cause) => write!(f, "{}", cause),
            UpdateVoiceConnectorGroupError::ServiceFailure(ref cause) => write!(f, "{}", cause),
            UpdateVoiceConnectorGroupError::ServiceUnavailable(ref cause) => write!(f, "{}", cause),
            UpdateVoiceConnectorGroupError::ThrottledClient(ref cause) => write!(f, "{}", cause),
            UpdateVoiceConnectorGroupError::UnauthorizedClient(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for UpdateVoiceConnectorGroupError {}
/// Trait representing the capabilities of the Amazon Chime API. Amazon Chime clients implement this trait.
#[async_trait]
pub trait Chime {
    /// <p>Associates a phone number with the specified Amazon Chime user.</p>
    async fn associate_phone_number_with_user(
        &self,
        input: AssociatePhoneNumberWithUserRequest,
    ) -> Result<AssociatePhoneNumberWithUserResponse, RusotoError<AssociatePhoneNumberWithUserError>>;

    /// <p>Associates phone numbers with the specified Amazon Chime Voice Connector.</p>
    async fn associate_phone_numbers_with_voice_connector(
        &self,
        input: AssociatePhoneNumbersWithVoiceConnectorRequest,
    ) -> Result<
        AssociatePhoneNumbersWithVoiceConnectorResponse,
        RusotoError<AssociatePhoneNumbersWithVoiceConnectorError>,
    >;

    /// <p>Associates phone numbers with the specified Amazon Chime Voice Connector group.</p>
    async fn associate_phone_numbers_with_voice_connector_group(
        &self,
        input: AssociatePhoneNumbersWithVoiceConnectorGroupRequest,
    ) -> Result<
        AssociatePhoneNumbersWithVoiceConnectorGroupResponse,
        RusotoError<AssociatePhoneNumbersWithVoiceConnectorGroupError>,
    >;

    /// <p>Associates the specified sign-in delegate groups with the specified Amazon Chime account.</p>
    async fn associate_signin_delegate_groups_with_account(
        &self,
        input: AssociateSigninDelegateGroupsWithAccountRequest,
    ) -> Result<
        AssociateSigninDelegateGroupsWithAccountResponse,
        RusotoError<AssociateSigninDelegateGroupsWithAccountError>,
    >;

    /// <p> Creates up to 100 new attendees for an active Amazon Chime SDK meeting. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i>. </p>
    async fn batch_create_attendee(
        &self,
        input: BatchCreateAttendeeRequest,
    ) -> Result<BatchCreateAttendeeResponse, RusotoError<BatchCreateAttendeeError>>;

    /// <p>Adds a specified number of users to a channel. </p>
    async fn batch_create_channel_membership(
        &self,
        input: BatchCreateChannelMembershipRequest,
    ) -> Result<BatchCreateChannelMembershipResponse, RusotoError<BatchCreateChannelMembershipError>>;

    /// <p>Adds up to 50 members to a chat room in an Amazon Chime Enterprise account. Members can be users or bots. The member role designates whether the member is a chat room administrator or a general chat room member.</p>
    async fn batch_create_room_membership(
        &self,
        input: BatchCreateRoomMembershipRequest,
    ) -> Result<BatchCreateRoomMembershipResponse, RusotoError<BatchCreateRoomMembershipError>>;

    /// <p> Moves phone numbers into the <b>Deletion queue</b>. Phone numbers must be disassociated from any users or Amazon Chime Voice Connectors before they can be deleted. </p> <p> Phone numbers remain in the <b>Deletion queue</b> for 7 days before they are deleted permanently. </p>
    async fn batch_delete_phone_number(
        &self,
        input: BatchDeletePhoneNumberRequest,
    ) -> Result<BatchDeletePhoneNumberResponse, RusotoError<BatchDeletePhoneNumberError>>;

    /// <p>Suspends up to 50 users from a <code>Team</code> or <code>EnterpriseLWA</code> Amazon Chime account. For more information about different account types, see <a href="https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html">Managing Your Amazon Chime Accounts</a> in the <i>Amazon Chime Administration Guide</i>.</p> <p>Users suspended from a <code>Team</code> account are disassociated from the account,but they can continue to use Amazon Chime as free users. To remove the suspension from suspended <code>Team</code> account users, invite them to the <code>Team</code> account again. You can use the <a>InviteUsers</a> action to do so.</p> <p>Users suspended from an <code>EnterpriseLWA</code> account are immediately signed out of Amazon Chime and can no longer sign in. To remove the suspension from suspended <code>EnterpriseLWA</code> account users, use the <a>BatchUnsuspendUser</a> action.</p> <p> To sign out users without suspending them, use the <a>LogoutUser</a> action. </p>
    async fn batch_suspend_user(
        &self,
        input: BatchSuspendUserRequest,
    ) -> Result<BatchSuspendUserResponse, RusotoError<BatchSuspendUserError>>;

    /// <p>Removes the suspension from up to 50 previously suspended users for the specified Amazon Chime <code>EnterpriseLWA</code> account. Only users on <code>EnterpriseLWA</code> accounts can be unsuspended using this action. For more information about different account types, see <a href="https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html"> Managing Your Amazon Chime Accounts </a> in the account types, in the <i>Amazon Chime Administration Guide</i>. </p> <p> Previously suspended users who are unsuspended using this action are returned to <code>Registered</code> status. Users who are not previously suspended are ignored. </p>
    async fn batch_unsuspend_user(
        &self,
        input: BatchUnsuspendUserRequest,
    ) -> Result<BatchUnsuspendUserResponse, RusotoError<BatchUnsuspendUserError>>;

    /// <p>Updates phone number product types or calling names. You can update one attribute at a time for each <code>UpdatePhoneNumberRequestItem</code>. For example, you can update the product type or the calling name.</p> <p>For toll-free numbers, you cannot use the Amazon Chime Business Calling product type. For numbers outside the U.S., you must use the Amazon Chime SIP Media Application Dial-In product type.</p> <p>Updates to outbound calling names can take up to 72 hours to complete. Pending updates to outbound calling names must be complete before you can request another update.</p>
    async fn batch_update_phone_number(
        &self,
        input: BatchUpdatePhoneNumberRequest,
    ) -> Result<BatchUpdatePhoneNumberResponse, RusotoError<BatchUpdatePhoneNumberError>>;

    /// <p>Updates user details within the <a>UpdateUserRequestItem</a> object for up to 20 users for the specified Amazon Chime account. Currently, only <code>LicenseType</code> updates are supported for this action.</p>
    async fn batch_update_user(
        &self,
        input: BatchUpdateUserRequest,
    ) -> Result<BatchUpdateUserResponse, RusotoError<BatchUpdateUserError>>;

    /// <p>Creates an Amazon Chime account under the administrator's AWS account. Only <code>Team</code> account types are currently supported for this action. For more information about different account types, see <a href="https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html">Managing Your Amazon Chime Accounts</a> in the <i>Amazon Chime Administration Guide</i>.</p>
    async fn create_account(
        &self,
        input: CreateAccountRequest,
    ) -> Result<CreateAccountResponse, RusotoError<CreateAccountError>>;

    /// <p>Creates an Amazon Chime SDK messaging <code>AppInstance</code> under an AWS account. Only SDK messaging customers use this API. <code>CreateAppInstance</code> supports idempotency behavior as described in the AWS API Standard.</p>
    async fn create_app_instance(
        &self,
        input: CreateAppInstanceRequest,
    ) -> Result<CreateAppInstanceResponse, RusotoError<CreateAppInstanceError>>;

    /// <p>Promotes an <code>AppInstanceUser</code> to an <code>AppInstanceAdmin</code>. The promoted user can perform the following actions. </p> <ul> <li> <p> <code>ChannelModerator</code> actions across all channels in the <code>AppInstance</code>.</p> </li> <li> <p> <code>DeleteChannelMessage</code> actions.</p> </li> </ul> <p>Only an <code>AppInstanceUser</code> can be promoted to an <code>AppInstanceAdmin</code> role.</p>
    async fn create_app_instance_admin(
        &self,
        input: CreateAppInstanceAdminRequest,
    ) -> Result<CreateAppInstanceAdminResponse, RusotoError<CreateAppInstanceAdminError>>;

    /// <p>Creates a user under an Amazon Chime <code>AppInstance</code>. The request consists of a unique <code>appInstanceUserId</code> and <code>Name</code> for that user.</p>
    async fn create_app_instance_user(
        &self,
        input: CreateAppInstanceUserRequest,
    ) -> Result<CreateAppInstanceUserResponse, RusotoError<CreateAppInstanceUserError>>;

    /// <p> Creates a new attendee for an active Amazon Chime SDK meeting. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i>. </p>
    async fn create_attendee(
        &self,
        input: CreateAttendeeRequest,
    ) -> Result<CreateAttendeeResponse, RusotoError<CreateAttendeeError>>;

    /// <p>Creates a bot for an Amazon Chime Enterprise account.</p>
    async fn create_bot(
        &self,
        input: CreateBotRequest,
    ) -> Result<CreateBotResponse, RusotoError<CreateBotError>>;

    /// <p><p>Creates a channel to which you can add users and send messages.</p> <p> <b>Restriction</b>: You can&#39;t change a channel&#39;s privacy.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note></p>
    async fn create_channel(
        &self,
        input: CreateChannelRequest,
    ) -> Result<CreateChannelResponse, RusotoError<CreateChannelError>>;

    /// <p><p>Permanently bans a member from a channel. Moderators can&#39;t add banned members to a channel. To undo a ban, you first have to <code>DeleteChannelBan</code>, and then <code>CreateChannelMembership</code>. Bans are cleaned up when you delete users or channels.</p> <p>If you ban a user who is already part of a channel, that user is automatically kicked from the channel.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note></p>
    async fn create_channel_ban(
        &self,
        input: CreateChannelBanRequest,
    ) -> Result<CreateChannelBanResponse, RusotoError<CreateChannelBanError>>;

    /// <p><p>Adds a user to a channel. The <code>InvitedBy</code> response field is derived from the request header. A channel member can:</p> <ul> <li> <p>List messages</p> </li> <li> <p>Send messages</p> </li> <li> <p>Receive messages</p> </li> <li> <p>Edit their own messages</p> </li> <li> <p>Leave the channel</p> </li> </ul> <p>Privacy settings impact this action as follows:</p> <ul> <li> <p>Public Channels: You do not need to be a member to list messages, but you must be a member to send messages.</p> </li> <li> <p>Private Channels: You must be a member to list or send messages.</p> </li> </ul> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note></p>
    async fn create_channel_membership(
        &self,
        input: CreateChannelMembershipRequest,
    ) -> Result<CreateChannelMembershipResponse, RusotoError<CreateChannelMembershipError>>;

    /// <p><p>Creates a new <code>ChannelModerator</code>. A channel moderator can:</p> <ul> <li> <p>Add and remove other members of the channel.</p> </li> <li> <p>Add and remove other moderators of the channel.</p> </li> <li> <p>Add and remove user bans for the channel.</p> </li> <li> <p>Redact messages in the channel.</p> </li> <li> <p>List messages in the channel.</p> </li> </ul> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note></p>
    async fn create_channel_moderator(
        &self,
        input: CreateChannelModeratorRequest,
    ) -> Result<CreateChannelModeratorResponse, RusotoError<CreateChannelModeratorError>>;

    /// <p> Creates a new Amazon Chime SDK meeting in the specified media Region with no initial attendees. For more information about specifying media Regions, see <a href="https://docs.aws.amazon.com/chime/latest/dg/chime-sdk-meetings-regions.html">Amazon Chime SDK Media Regions</a> in the <i>Amazon Chime Developer Guide</i> . For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i> . </p>
    async fn create_meeting(
        &self,
        input: CreateMeetingRequest,
    ) -> Result<CreateMeetingResponse, RusotoError<CreateMeetingError>>;

    /// <p>Uses the join token and call metadata in a meeting request (From number, To number, and so forth) to initiate an outbound call to a public switched telephone network (PSTN) and join them into a Chime meeting. Also ensures that the From number belongs to the customer.</p> <p>To play welcome audio or implement an interactive voice response (IVR), use the <code>CreateSipMediaApplicationCall</code> action with the corresponding SIP media application ID.</p>
    async fn create_meeting_dial_out(
        &self,
        input: CreateMeetingDialOutRequest,
    ) -> Result<CreateMeetingDialOutResponse, RusotoError<CreateMeetingDialOutError>>;

    /// <p> Creates a new Amazon Chime SDK meeting in the specified media Region, with attendees. For more information about specifying media Regions, see <a href="https://docs.aws.amazon.com/chime/latest/dg/chime-sdk-meetings-regions.html">Amazon Chime SDK Media Regions</a> in the <i>Amazon Chime Developer Guide</i> . For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i> . </p>
    async fn create_meeting_with_attendees(
        &self,
        input: CreateMeetingWithAttendeesRequest,
    ) -> Result<CreateMeetingWithAttendeesResponse, RusotoError<CreateMeetingWithAttendeesError>>;

    /// <p>Creates an order for phone numbers to be provisioned. For toll-free numbers, you cannot use the Amazon Chime Business Calling product type. For numbers outside the U.S., you must use the Amazon Chime SIP Media Application Dial-In product type.</p>
    async fn create_phone_number_order(
        &self,
        input: CreatePhoneNumberOrderRequest,
    ) -> Result<CreatePhoneNumberOrderResponse, RusotoError<CreatePhoneNumberOrderError>>;

    /// <p>Creates a proxy session on the specified Amazon Chime Voice Connector for the specified participant phone numbers.</p>
    async fn create_proxy_session(
        &self,
        input: CreateProxySessionRequest,
    ) -> Result<CreateProxySessionResponse, RusotoError<CreateProxySessionError>>;

    /// <p>Creates a chat room for the specified Amazon Chime Enterprise account.</p>
    async fn create_room(
        &self,
        input: CreateRoomRequest,
    ) -> Result<CreateRoomResponse, RusotoError<CreateRoomError>>;

    /// <p>Adds a member to a chat room in an Amazon Chime Enterprise account. A member can be either a user or a bot. The member role designates whether the member is a chat room administrator or a general chat room member.</p>
    async fn create_room_membership(
        &self,
        input: CreateRoomMembershipRequest,
    ) -> Result<CreateRoomMembershipResponse, RusotoError<CreateRoomMembershipError>>;

    /// <p>Creates a SIP media application.</p>
    async fn create_sip_media_application(
        &self,
        input: CreateSipMediaApplicationRequest,
    ) -> Result<CreateSipMediaApplicationResponse, RusotoError<CreateSipMediaApplicationError>>;

    /// <p>Creates an outbound call to a phone number from the phone number specified in the request, and it invokes the endpoint of the specified <code>sipMediaApplicationId</code>.</p>
    async fn create_sip_media_application_call(
        &self,
        input: CreateSipMediaApplicationCallRequest,
    ) -> Result<
        CreateSipMediaApplicationCallResponse,
        RusotoError<CreateSipMediaApplicationCallError>,
    >;

    /// <p>Creates a SIP rule which can be used to run a SIP media application as a target for a specific trigger type.</p>
    async fn create_sip_rule(
        &self,
        input: CreateSipRuleRequest,
    ) -> Result<CreateSipRuleResponse, RusotoError<CreateSipRuleError>>;

    /// <p>Creates a user under the specified Amazon Chime account.</p>
    async fn create_user(
        &self,
        input: CreateUserRequest,
    ) -> Result<CreateUserResponse, RusotoError<CreateUserError>>;

    /// <p>Creates an Amazon Chime Voice Connector under the administrator's AWS account. You can choose to create an Amazon Chime Voice Connector in a specific AWS Region.</p> <p> Enabling <a>CreateVoiceConnectorRequest$RequireEncryption</a> configures your Amazon Chime Voice Connector to use TLS transport for SIP signaling and Secure RTP (SRTP) for media. Inbound calls use TLS transport, and unencrypted outbound calls are blocked. </p>
    async fn create_voice_connector(
        &self,
        input: CreateVoiceConnectorRequest,
    ) -> Result<CreateVoiceConnectorResponse, RusotoError<CreateVoiceConnectorError>>;

    /// <p>Creates an Amazon Chime Voice Connector group under the administrator's AWS account. You can associate Amazon Chime Voice Connectors with the Amazon Chime Voice Connector group by including <code>VoiceConnectorItems</code> in the request.</p> <p>You can include Amazon Chime Voice Connectors from different AWS Regions in your group. This creates a fault tolerant mechanism for fallback in case of availability events.</p>
    async fn create_voice_connector_group(
        &self,
        input: CreateVoiceConnectorGroupRequest,
    ) -> Result<CreateVoiceConnectorGroupResponse, RusotoError<CreateVoiceConnectorGroupError>>;

    /// <p>Deletes the specified Amazon Chime account. You must suspend all users before deleting <code>Team</code> account. You can use the <a>BatchSuspendUser</a> action to dodo.</p> <p>For <code>EnterpriseLWA</code> and <code>EnterpriseAD</code> accounts, you must release the claimed domains for your Amazon Chime account before deletion. As soon as you release the domain, all users under that account are suspended.</p> <p>Deleted accounts appear in your <code>Disabled</code> accounts list for 90 days. To restore deleted account from your <code>Disabled</code> accounts list, you must contact AWS Support.</p> <p>After 90 days, deleted accounts are permanently removed from your <code>Disabled</code> accounts list.</p>
    async fn delete_account(
        &self,
        input: DeleteAccountRequest,
    ) -> Result<DeleteAccountResponse, RusotoError<DeleteAccountError>>;

    /// <p>Deletes an <code>AppInstance</code> and all associated data asynchronously.</p>
    async fn delete_app_instance(
        &self,
        input: DeleteAppInstanceRequest,
    ) -> Result<(), RusotoError<DeleteAppInstanceError>>;

    /// <p>Demotes an <code>AppInstanceAdmin</code> to an <code>AppInstanceUser</code>. This action does not delete the user.</p>
    async fn delete_app_instance_admin(
        &self,
        input: DeleteAppInstanceAdminRequest,
    ) -> Result<(), RusotoError<DeleteAppInstanceAdminError>>;

    /// <p>Deletes the streaming configurations of an <code>AppInstance</code>.</p>
    async fn delete_app_instance_streaming_configurations(
        &self,
        input: DeleteAppInstanceStreamingConfigurationsRequest,
    ) -> Result<(), RusotoError<DeleteAppInstanceStreamingConfigurationsError>>;

    /// <p>Deletes an <code>AppInstanceUser</code>.</p>
    async fn delete_app_instance_user(
        &self,
        input: DeleteAppInstanceUserRequest,
    ) -> Result<(), RusotoError<DeleteAppInstanceUserError>>;

    /// <p>Deletes an attendee from the specified Amazon Chime SDK meeting and deletes their <code>JoinToken</code>. Attendees are automatically deleted when a Amazon Chime SDK meeting is deleted. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i>.</p>
    async fn delete_attendee(
        &self,
        input: DeleteAttendeeRequest,
    ) -> Result<(), RusotoError<DeleteAttendeeError>>;

    /// <p><p>Immediately makes a channel and its memberships inaccessible and marks them for deletion. This is an irreversible process.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note></p>
    async fn delete_channel(
        &self,
        input: DeleteChannelRequest,
    ) -> Result<(), RusotoError<DeleteChannelError>>;

    /// <p><p>Removes a user from a channel&#39;s ban list.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note></p>
    async fn delete_channel_ban(
        &self,
        input: DeleteChannelBanRequest,
    ) -> Result<(), RusotoError<DeleteChannelBanError>>;

    /// <p><p>Removes a member from a channel.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note></p>
    async fn delete_channel_membership(
        &self,
        input: DeleteChannelMembershipRequest,
    ) -> Result<(), RusotoError<DeleteChannelMembershipError>>;

    /// <p><p>Deletes a channel message. Only admins can perform this action. Deletion makes messages inaccessible immediately. A background process deletes any revisions created by <code>UpdateChannelMessage</code>.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note></p>
    async fn delete_channel_message(
        &self,
        input: DeleteChannelMessageRequest,
    ) -> Result<(), RusotoError<DeleteChannelMessageError>>;

    /// <p><p>Deletes a channel moderator.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note></p>
    async fn delete_channel_moderator(
        &self,
        input: DeleteChannelModeratorRequest,
    ) -> Result<(), RusotoError<DeleteChannelModeratorError>>;

    /// <p>Deletes the events configuration that allows a bot to receive outgoing events.</p>
    async fn delete_events_configuration(
        &self,
        input: DeleteEventsConfigurationRequest,
    ) -> Result<(), RusotoError<DeleteEventsConfigurationError>>;

    /// <p>Deletes the specified Amazon Chime SDK meeting. The operation deletes all attendees, disconnects all clients, and prevents new clients from joining the meeting. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i>.</p>
    async fn delete_meeting(
        &self,
        input: DeleteMeetingRequest,
    ) -> Result<(), RusotoError<DeleteMeetingError>>;

    /// <p>Moves the specified phone number into the <b>Deletion queue</b>. A phone number must be disassociated from any users or Amazon Chime Voice Connectors before it can be deleted.</p> <p>Deleted phone numbers remain in the <b>Deletion queue</b> for 7 days before they are deleted permanently.</p>
    async fn delete_phone_number(
        &self,
        input: DeletePhoneNumberRequest,
    ) -> Result<(), RusotoError<DeletePhoneNumberError>>;

    /// <p>Deletes the specified proxy session from the specified Amazon Chime Voice Connector.</p>
    async fn delete_proxy_session(
        &self,
        input: DeleteProxySessionRequest,
    ) -> Result<(), RusotoError<DeleteProxySessionError>>;

    /// <p>Deletes a chat room in an Amazon Chime Enterprise account.</p>
    async fn delete_room(
        &self,
        input: DeleteRoomRequest,
    ) -> Result<(), RusotoError<DeleteRoomError>>;

    /// <p>Removes a member from a chat room in an Amazon Chime Enterprise account.</p>
    async fn delete_room_membership(
        &self,
        input: DeleteRoomMembershipRequest,
    ) -> Result<(), RusotoError<DeleteRoomMembershipError>>;

    /// <p>Deletes a SIP media application.</p>
    async fn delete_sip_media_application(
        &self,
        input: DeleteSipMediaApplicationRequest,
    ) -> Result<(), RusotoError<DeleteSipMediaApplicationError>>;

    /// <p>Deletes a SIP rule. You must disable a SIP rule before you can delete it.</p>
    async fn delete_sip_rule(
        &self,
        input: DeleteSipRuleRequest,
    ) -> Result<(), RusotoError<DeleteSipRuleError>>;

    /// <p>Deletes the specified Amazon Chime Voice Connector. Any phone numbers associated with the Amazon Chime Voice Connector must be disassociated from it before it can be deleted.</p>
    async fn delete_voice_connector(
        &self,
        input: DeleteVoiceConnectorRequest,
    ) -> Result<(), RusotoError<DeleteVoiceConnectorError>>;

    /// <p>Deletes the emergency calling configuration details from the specified Amazon Chime Voice Connector.</p>
    async fn delete_voice_connector_emergency_calling_configuration(
        &self,
        input: DeleteVoiceConnectorEmergencyCallingConfigurationRequest,
    ) -> Result<(), RusotoError<DeleteVoiceConnectorEmergencyCallingConfigurationError>>;

    /// <p>Deletes the specified Amazon Chime Voice Connector group. Any <code>VoiceConnectorItems</code> and phone numbers associated with the group must be removed before it can be deleted.</p>
    async fn delete_voice_connector_group(
        &self,
        input: DeleteVoiceConnectorGroupRequest,
    ) -> Result<(), RusotoError<DeleteVoiceConnectorGroupError>>;

    /// <p><p>Deletes the origination settings for the specified Amazon Chime Voice Connector.</p> <note> <p>If emergency calling is configured for the Amazon Chime Voice Connector, it must be deleted prior to deleting the origination settings.</p> </note></p>
    async fn delete_voice_connector_origination(
        &self,
        input: DeleteVoiceConnectorOriginationRequest,
    ) -> Result<(), RusotoError<DeleteVoiceConnectorOriginationError>>;

    /// <p>Deletes the proxy configuration from the specified Amazon Chime Voice Connector.</p>
    async fn delete_voice_connector_proxy(
        &self,
        input: DeleteVoiceConnectorProxyRequest,
    ) -> Result<(), RusotoError<DeleteVoiceConnectorProxyError>>;

    /// <p>Deletes the streaming configuration for the specified Amazon Chime Voice Connector.</p>
    async fn delete_voice_connector_streaming_configuration(
        &self,
        input: DeleteVoiceConnectorStreamingConfigurationRequest,
    ) -> Result<(), RusotoError<DeleteVoiceConnectorStreamingConfigurationError>>;

    /// <p><p>Deletes the termination settings for the specified Amazon Chime Voice Connector.</p> <note> <p>If emergency calling is configured for the Amazon Chime Voice Connector, it must be deleted prior to deleting the termination settings.</p> </note></p>
    async fn delete_voice_connector_termination(
        &self,
        input: DeleteVoiceConnectorTerminationRequest,
    ) -> Result<(), RusotoError<DeleteVoiceConnectorTerminationError>>;

    /// <p>Deletes the specified SIP credentials used by your equipment to authenticate during call termination.</p>
    async fn delete_voice_connector_termination_credentials(
        &self,
        input: DeleteVoiceConnectorTerminationCredentialsRequest,
    ) -> Result<(), RusotoError<DeleteVoiceConnectorTerminationCredentialsError>>;

    /// <p>Returns the full details of an <code>AppInstance</code>.</p>
    async fn describe_app_instance(
        &self,
        input: DescribeAppInstanceRequest,
    ) -> Result<DescribeAppInstanceResponse, RusotoError<DescribeAppInstanceError>>;

    /// <p>Returns the full details of an <code>AppInstanceAdmin</code>.</p>
    async fn describe_app_instance_admin(
        &self,
        input: DescribeAppInstanceAdminRequest,
    ) -> Result<DescribeAppInstanceAdminResponse, RusotoError<DescribeAppInstanceAdminError>>;

    /// <p> Returns the full details of an <code>AppInstanceUser</code> . </p>
    async fn describe_app_instance_user(
        &self,
        input: DescribeAppInstanceUserRequest,
    ) -> Result<DescribeAppInstanceUserResponse, RusotoError<DescribeAppInstanceUserError>>;

    /// <p><p>Returns the full details of a channel in an Amazon Chime <code>AppInstance</code>.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note></p>
    async fn describe_channel(
        &self,
        input: DescribeChannelRequest,
    ) -> Result<DescribeChannelResponse, RusotoError<DescribeChannelError>>;

    /// <p><p>Returns the full details of a channel ban.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note></p>
    async fn describe_channel_ban(
        &self,
        input: DescribeChannelBanRequest,
    ) -> Result<DescribeChannelBanResponse, RusotoError<DescribeChannelBanError>>;

    /// <p><p>Returns the full details of a user&#39;s channel membership.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note></p>
    async fn describe_channel_membership(
        &self,
        input: DescribeChannelMembershipRequest,
    ) -> Result<DescribeChannelMembershipResponse, RusotoError<DescribeChannelMembershipError>>;

    /// <p><p> Returns the details of a channel based on the membership of the specified <code>AppInstanceUser</code>.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note></p>
    async fn describe_channel_membership_for_app_instance_user(
        &self,
        input: DescribeChannelMembershipForAppInstanceUserRequest,
    ) -> Result<
        DescribeChannelMembershipForAppInstanceUserResponse,
        RusotoError<DescribeChannelMembershipForAppInstanceUserError>,
    >;

    /// <p><p>Returns the full details of a channel moderated by the specified <code>AppInstanceUser</code>.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note></p>
    async fn describe_channel_moderated_by_app_instance_user(
        &self,
        input: DescribeChannelModeratedByAppInstanceUserRequest,
    ) -> Result<
        DescribeChannelModeratedByAppInstanceUserResponse,
        RusotoError<DescribeChannelModeratedByAppInstanceUserError>,
    >;

    /// <p><p>Returns the full details of a single ChannelModerator.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note></p>
    async fn describe_channel_moderator(
        &self,
        input: DescribeChannelModeratorRequest,
    ) -> Result<DescribeChannelModeratorResponse, RusotoError<DescribeChannelModeratorError>>;

    /// <p>Disassociates the primary provisioned phone number from the specified Amazon Chime user.</p>
    async fn disassociate_phone_number_from_user(
        &self,
        input: DisassociatePhoneNumberFromUserRequest,
    ) -> Result<
        DisassociatePhoneNumberFromUserResponse,
        RusotoError<DisassociatePhoneNumberFromUserError>,
    >;

    /// <p>Disassociates the specified phone numbers from the specified Amazon Chime Voice Connector.</p>
    async fn disassociate_phone_numbers_from_voice_connector(
        &self,
        input: DisassociatePhoneNumbersFromVoiceConnectorRequest,
    ) -> Result<
        DisassociatePhoneNumbersFromVoiceConnectorResponse,
        RusotoError<DisassociatePhoneNumbersFromVoiceConnectorError>,
    >;

    /// <p>Disassociates the specified phone numbers from the specified Amazon Chime Voice Connector group.</p>
    async fn disassociate_phone_numbers_from_voice_connector_group(
        &self,
        input: DisassociatePhoneNumbersFromVoiceConnectorGroupRequest,
    ) -> Result<
        DisassociatePhoneNumbersFromVoiceConnectorGroupResponse,
        RusotoError<DisassociatePhoneNumbersFromVoiceConnectorGroupError>,
    >;

    /// <p>Disassociates the specified sign-in delegate groups from the specified Amazon Chime account.</p>
    async fn disassociate_signin_delegate_groups_from_account(
        &self,
        input: DisassociateSigninDelegateGroupsFromAccountRequest,
    ) -> Result<
        DisassociateSigninDelegateGroupsFromAccountResponse,
        RusotoError<DisassociateSigninDelegateGroupsFromAccountError>,
    >;

    /// <p>Retrieves details for the specified Amazon Chime account, such as account type and supported licenses.</p>
    async fn get_account(
        &self,
        input: GetAccountRequest,
    ) -> Result<GetAccountResponse, RusotoError<GetAccountError>>;

    /// <p>Retrieves account settings for the specified Amazon Chime account ID, such as remote control and dialout settings. For more information about these settings, see <a href="https://docs.aws.amazon.com/chime/latest/ag/policies.html">Use the Policies Page</a> in the <i>Amazon Chime Administration Guide</i>. </p>
    async fn get_account_settings(
        &self,
        input: GetAccountSettingsRequest,
    ) -> Result<GetAccountSettingsResponse, RusotoError<GetAccountSettingsError>>;

    /// <p>Gets the retention settings for an <code>AppInstance</code>.</p>
    async fn get_app_instance_retention_settings(
        &self,
        input: GetAppInstanceRetentionSettingsRequest,
    ) -> Result<
        GetAppInstanceRetentionSettingsResponse,
        RusotoError<GetAppInstanceRetentionSettingsError>,
    >;

    /// <p>Gets the streaming settings for an <code>AppInstance</code>.</p>
    async fn get_app_instance_streaming_configurations(
        &self,
        input: GetAppInstanceStreamingConfigurationsRequest,
    ) -> Result<
        GetAppInstanceStreamingConfigurationsResponse,
        RusotoError<GetAppInstanceStreamingConfigurationsError>,
    >;

    /// <p> Gets the Amazon Chime SDK attendee details for a specified meeting ID and attendee ID. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i> . </p>
    async fn get_attendee(
        &self,
        input: GetAttendeeRequest,
    ) -> Result<GetAttendeeResponse, RusotoError<GetAttendeeError>>;

    /// <p>Retrieves details for the specified bot, such as bot email address, bot type, status, and display name.</p>
    async fn get_bot(
        &self,
        input: GetBotRequest,
    ) -> Result<GetBotResponse, RusotoError<GetBotError>>;

    /// <p><p>Gets the full details of a channel message.</p> <note> <p>The x-amz-chime-bearer request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note></p>
    async fn get_channel_message(
        &self,
        input: GetChannelMessageRequest,
    ) -> Result<GetChannelMessageResponse, RusotoError<GetChannelMessageError>>;

    /// <p>Gets details for an events configuration that allows a bot to receive outgoing events, such as an HTTPS endpoint or Lambda function ARN.</p>
    async fn get_events_configuration(
        &self,
        input: GetEventsConfigurationRequest,
    ) -> Result<GetEventsConfigurationResponse, RusotoError<GetEventsConfigurationError>>;

    /// <p>Retrieves global settings for the administrator's AWS account, such as Amazon Chime Business Calling and Amazon Chime Voice Connector settings.</p>
    async fn get_global_settings(
        &self,
    ) -> Result<GetGlobalSettingsResponse, RusotoError<GetGlobalSettingsError>>;

    /// <p> Gets the Amazon Chime SDK meeting details for the specified meeting ID. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i> . </p>
    async fn get_meeting(
        &self,
        input: GetMeetingRequest,
    ) -> Result<GetMeetingResponse, RusotoError<GetMeetingError>>;

    /// <p>The details of the endpoint for the messaging session.</p>
    async fn get_messaging_session_endpoint(
        &self,
    ) -> Result<GetMessagingSessionEndpointResponse, RusotoError<GetMessagingSessionEndpointError>>;

    /// <p>Retrieves details for the specified phone number ID, such as associations, capabilities, and product type.</p>
    async fn get_phone_number(
        &self,
        input: GetPhoneNumberRequest,
    ) -> Result<GetPhoneNumberResponse, RusotoError<GetPhoneNumberError>>;

    /// <p>Retrieves details for the specified phone number order, such as the order creation timestamp, phone numbers in E.164 format, product type, and order status.</p>
    async fn get_phone_number_order(
        &self,
        input: GetPhoneNumberOrderRequest,
    ) -> Result<GetPhoneNumberOrderResponse, RusotoError<GetPhoneNumberOrderError>>;

    /// <p>Retrieves the phone number settings for the administrator's AWS account, such as the default outbound calling name.</p>
    async fn get_phone_number_settings(
        &self,
    ) -> Result<GetPhoneNumberSettingsResponse, RusotoError<GetPhoneNumberSettingsError>>;

    /// <p>Gets the specified proxy session details for the specified Amazon Chime Voice Connector.</p>
    async fn get_proxy_session(
        &self,
        input: GetProxySessionRequest,
    ) -> Result<GetProxySessionResponse, RusotoError<GetProxySessionError>>;

    /// <p> Gets the retention settings for the specified Amazon Chime Enterprise account. For more information about retention settings, see <a href="https://docs.aws.amazon.com/chime/latest/ag/chat-retention.html">Managing Chat Retention Policies</a> in the <i>Amazon Chime Administration Guide</i>. </p>
    async fn get_retention_settings(
        &self,
        input: GetRetentionSettingsRequest,
    ) -> Result<GetRetentionSettingsResponse, RusotoError<GetRetentionSettingsError>>;

    /// <p>Retrieves room details, such as the room name, for a room in an Amazon Chime Enterprise account.</p>
    async fn get_room(
        &self,
        input: GetRoomRequest,
    ) -> Result<GetRoomResponse, RusotoError<GetRoomError>>;

    /// <p>Retrieves the information for a SIP media application, including name, AWS Region, and endpoints.</p>
    async fn get_sip_media_application(
        &self,
        input: GetSipMediaApplicationRequest,
    ) -> Result<GetSipMediaApplicationResponse, RusotoError<GetSipMediaApplicationError>>;

    /// <p>Returns the logging configuration for the specified SIP media application.</p>
    async fn get_sip_media_application_logging_configuration(
        &self,
        input: GetSipMediaApplicationLoggingConfigurationRequest,
    ) -> Result<
        GetSipMediaApplicationLoggingConfigurationResponse,
        RusotoError<GetSipMediaApplicationLoggingConfigurationError>,
    >;

    /// <p>Retrieves the details of a SIP rule, such as the rule ID, name, triggers, and target endpoints.</p>
    async fn get_sip_rule(
        &self,
        input: GetSipRuleRequest,
    ) -> Result<GetSipRuleResponse, RusotoError<GetSipRuleError>>;

    /// <p>Retrieves details for the specified user ID, such as primary email address, license type,and personal meeting PIN.</p> <p> To retrieve user details with an email address instead of a user ID, use the <a>ListUsers</a> action, and then filter by email address. </p>
    async fn get_user(
        &self,
        input: GetUserRequest,
    ) -> Result<GetUserResponse, RusotoError<GetUserError>>;

    /// <p>Retrieves settings for the specified user ID, such as any associated phone number settings.</p>
    async fn get_user_settings(
        &self,
        input: GetUserSettingsRequest,
    ) -> Result<GetUserSettingsResponse, RusotoError<GetUserSettingsError>>;

    /// <p>Retrieves details for the specified Amazon Chime Voice Connector, such as timestamps,name, outbound host, and encryption requirements.</p>
    async fn get_voice_connector(
        &self,
        input: GetVoiceConnectorRequest,
    ) -> Result<GetVoiceConnectorResponse, RusotoError<GetVoiceConnectorError>>;

    /// <p>Gets the emergency calling configuration details for the specified Amazon Chime Voice Connector.</p>
    async fn get_voice_connector_emergency_calling_configuration(
        &self,
        input: GetVoiceConnectorEmergencyCallingConfigurationRequest,
    ) -> Result<
        GetVoiceConnectorEmergencyCallingConfigurationResponse,
        RusotoError<GetVoiceConnectorEmergencyCallingConfigurationError>,
    >;

    /// <p> Retrieves details for the specified Amazon Chime Voice Connector group, such as timestamps,name, and associated <code>VoiceConnectorItems</code>.</p>
    async fn get_voice_connector_group(
        &self,
        input: GetVoiceConnectorGroupRequest,
    ) -> Result<GetVoiceConnectorGroupResponse, RusotoError<GetVoiceConnectorGroupError>>;

    /// <p>Retrieves the logging configuration details for the specified Amazon Chime Voice Connector. Shows whether SIP message logs are enabled for sending to Amazon CloudWatch Logs.</p>
    async fn get_voice_connector_logging_configuration(
        &self,
        input: GetVoiceConnectorLoggingConfigurationRequest,
    ) -> Result<
        GetVoiceConnectorLoggingConfigurationResponse,
        RusotoError<GetVoiceConnectorLoggingConfigurationError>,
    >;

    /// <p>Retrieves origination setting details for the specified Amazon Chime Voice Connector.</p>
    async fn get_voice_connector_origination(
        &self,
        input: GetVoiceConnectorOriginationRequest,
    ) -> Result<GetVoiceConnectorOriginationResponse, RusotoError<GetVoiceConnectorOriginationError>>;

    /// <p>Gets the proxy configuration details for the specified Amazon Chime Voice Connector.</p>
    async fn get_voice_connector_proxy(
        &self,
        input: GetVoiceConnectorProxyRequest,
    ) -> Result<GetVoiceConnectorProxyResponse, RusotoError<GetVoiceConnectorProxyError>>;

    /// <p>Retrieves the streaming configuration details for the specified Amazon Chime Voice Connector. Shows whether media streaming is enabled for sending to Amazon Kinesis. It also shows the retention period, in hours, for the Amazon Kinesis data.</p>
    async fn get_voice_connector_streaming_configuration(
        &self,
        input: GetVoiceConnectorStreamingConfigurationRequest,
    ) -> Result<
        GetVoiceConnectorStreamingConfigurationResponse,
        RusotoError<GetVoiceConnectorStreamingConfigurationError>,
    >;

    /// <p>Retrieves termination setting details for the specified Amazon Chime Voice Connector.</p>
    async fn get_voice_connector_termination(
        &self,
        input: GetVoiceConnectorTerminationRequest,
    ) -> Result<GetVoiceConnectorTerminationResponse, RusotoError<GetVoiceConnectorTerminationError>>;

    /// <p>Retrieves information about the last time a SIP <code>OPTIONS</code> ping was received from your SIP infrastructure for the specified Amazon Chime Voice Connector.</p>
    async fn get_voice_connector_termination_health(
        &self,
        input: GetVoiceConnectorTerminationHealthRequest,
    ) -> Result<
        GetVoiceConnectorTerminationHealthResponse,
        RusotoError<GetVoiceConnectorTerminationHealthError>,
    >;

    /// <p>Sends email to a maximum of 50 users, inviting them to the specified Amazon Chime <code>Team</code> account. Only <code>Team</code> account types are currently supported for this action.</p>
    async fn invite_users(
        &self,
        input: InviteUsersRequest,
    ) -> Result<InviteUsersResponse, RusotoError<InviteUsersError>>;

    /// <p>Lists the Amazon Chime accounts under the administrator's AWS account. You can filter accounts by account name prefix. To find out which Amazon Chime account a user belongs to, you can filter by the user's email address, which returns one account result.</p>
    async fn list_accounts(
        &self,
        input: ListAccountsRequest,
    ) -> Result<ListAccountsResponse, RusotoError<ListAccountsError>>;

    /// <p>Returns a list of the administrators in the <code>AppInstance</code>.</p>
    async fn list_app_instance_admins(
        &self,
        input: ListAppInstanceAdminsRequest,
    ) -> Result<ListAppInstanceAdminsResponse, RusotoError<ListAppInstanceAdminsError>>;

    /// <p> List all <code>AppInstanceUsers</code> created under a single <code>AppInstance</code>. </p>
    async fn list_app_instance_users(
        &self,
        input: ListAppInstanceUsersRequest,
    ) -> Result<ListAppInstanceUsersResponse, RusotoError<ListAppInstanceUsersError>>;

    /// <p>Lists all Amazon Chime <code>AppInstance</code>s created under a single AWS account.</p>
    async fn list_app_instances(
        &self,
        input: ListAppInstancesRequest,
    ) -> Result<ListAppInstancesResponse, RusotoError<ListAppInstancesError>>;

    /// <p>Lists the tags applied to an Amazon Chime SDK attendee resource.</p>
    async fn list_attendee_tags(
        &self,
        input: ListAttendeeTagsRequest,
    ) -> Result<ListAttendeeTagsResponse, RusotoError<ListAttendeeTagsError>>;

    /// <p> Lists the attendees for the specified Amazon Chime SDK meeting. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i>. </p>
    async fn list_attendees(
        &self,
        input: ListAttendeesRequest,
    ) -> Result<ListAttendeesResponse, RusotoError<ListAttendeesError>>;

    /// <p>Lists the bots associated with the administrator's Amazon Chime Enterprise account ID.</p>
    async fn list_bots(
        &self,
        input: ListBotsRequest,
    ) -> Result<ListBotsResponse, RusotoError<ListBotsError>>;

    /// <p><p>Lists all the users banned from a particular channel.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note></p>
    async fn list_channel_bans(
        &self,
        input: ListChannelBansRequest,
    ) -> Result<ListChannelBansResponse, RusotoError<ListChannelBansError>>;

    /// <p><p>Lists all channel memberships in a channel.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note></p>
    async fn list_channel_memberships(
        &self,
        input: ListChannelMembershipsRequest,
    ) -> Result<ListChannelMembershipsResponse, RusotoError<ListChannelMembershipsError>>;

    /// <p><p> Lists all channels that a particular <code>AppInstanceUser</code> is a part of. Only an <code>AppInstanceAdmin</code> can call the API with a user ARN that is not their own. </p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note></p>
    async fn list_channel_memberships_for_app_instance_user(
        &self,
        input: ListChannelMembershipsForAppInstanceUserRequest,
    ) -> Result<
        ListChannelMembershipsForAppInstanceUserResponse,
        RusotoError<ListChannelMembershipsForAppInstanceUserError>,
    >;

    /// <p><p>List all the messages in a channel. Returns a paginated list of <code>ChannelMessages</code>. By default, sorted by creation timestamp in descending order.</p> <note> <p>Redacted messages appear in the results as empty, since they are only redacted, not deleted. Deleted messages do not appear in the results. This action always returns the latest version of an edited message.</p> <p>Also, the x-amz-chime-bearer request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note></p>
    async fn list_channel_messages(
        &self,
        input: ListChannelMessagesRequest,
    ) -> Result<ListChannelMessagesResponse, RusotoError<ListChannelMessagesError>>;

    /// <p><p>Lists all the moderators for a channel.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note></p>
    async fn list_channel_moderators(
        &self,
        input: ListChannelModeratorsRequest,
    ) -> Result<ListChannelModeratorsResponse, RusotoError<ListChannelModeratorsError>>;

    /// <p><p>Lists all Channels created under a single Chime App as a paginated list. You can specify filters to narrow results.</p> <p class="title"> <b>Functionality &amp; restrictions</b> </p> <ul> <li> <p>Use privacy = <code>PUBLIC</code> to retrieve all public channels in the account.</p> </li> <li> <p>Only an <code>AppInstanceAdmin</code> can set privacy = <code>PRIVATE</code> to list the private channels in an account.</p> </li> </ul> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note></p>
    async fn list_channels(
        &self,
        input: ListChannelsRequest,
    ) -> Result<ListChannelsResponse, RusotoError<ListChannelsError>>;

    /// <p><p>A list of the channels moderated by an <code>AppInstanceUser</code>.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note></p>
    async fn list_channels_moderated_by_app_instance_user(
        &self,
        input: ListChannelsModeratedByAppInstanceUserRequest,
    ) -> Result<
        ListChannelsModeratedByAppInstanceUserResponse,
        RusotoError<ListChannelsModeratedByAppInstanceUserError>,
    >;

    /// <p>Lists the tags applied to an Amazon Chime SDK meeting resource.</p>
    async fn list_meeting_tags(
        &self,
        input: ListMeetingTagsRequest,
    ) -> Result<ListMeetingTagsResponse, RusotoError<ListMeetingTagsError>>;

    /// <p> Lists up to 100 active Amazon Chime SDK meetings. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i>.</p>
    async fn list_meetings(
        &self,
        input: ListMeetingsRequest,
    ) -> Result<ListMeetingsResponse, RusotoError<ListMeetingsError>>;

    /// <p>Lists the phone number orders for the administrator's Amazon Chime account.</p>
    async fn list_phone_number_orders(
        &self,
        input: ListPhoneNumberOrdersRequest,
    ) -> Result<ListPhoneNumberOrdersResponse, RusotoError<ListPhoneNumberOrdersError>>;

    /// <p>Lists the phone numbers for the specified Amazon Chime account, Amazon Chime user, Amazon Chime Voice Connector, or Amazon Chime Voice Connector group.</p>
    async fn list_phone_numbers(
        &self,
        input: ListPhoneNumbersRequest,
    ) -> Result<ListPhoneNumbersResponse, RusotoError<ListPhoneNumbersError>>;

    /// <p>Lists the proxy sessions for the specified Amazon Chime Voice Connector.</p>
    async fn list_proxy_sessions(
        &self,
        input: ListProxySessionsRequest,
    ) -> Result<ListProxySessionsResponse, RusotoError<ListProxySessionsError>>;

    /// <p>Lists the membership details for the specified room in an Amazon Chime Enterprise account, such as the members' IDs, email addresses, and names.</p>
    async fn list_room_memberships(
        &self,
        input: ListRoomMembershipsRequest,
    ) -> Result<ListRoomMembershipsResponse, RusotoError<ListRoomMembershipsError>>;

    /// <p>Lists the room details for the specified Amazon Chime Enterprise account. Optionally, filter the results by a member ID (user ID or bot ID) to see a list of rooms that the member belongs to.</p>
    async fn list_rooms(
        &self,
        input: ListRoomsRequest,
    ) -> Result<ListRoomsResponse, RusotoError<ListRoomsError>>;

    /// <p>Lists the SIP media applications under the administrator's AWS account.</p>
    async fn list_sip_media_applications(
        &self,
        input: ListSipMediaApplicationsRequest,
    ) -> Result<ListSipMediaApplicationsResponse, RusotoError<ListSipMediaApplicationsError>>;

    /// <p>Lists the SIP rules under the administrator's AWS account.</p>
    async fn list_sip_rules(
        &self,
        input: ListSipRulesRequest,
    ) -> Result<ListSipRulesResponse, RusotoError<ListSipRulesError>>;

    /// <p>Lists supported phone number countries.</p>
    async fn list_supported_phone_number_countries(
        &self,
        input: ListSupportedPhoneNumberCountriesRequest,
    ) -> Result<
        ListSupportedPhoneNumberCountriesResponse,
        RusotoError<ListSupportedPhoneNumberCountriesError>,
    >;

    /// <p>Lists the tags applied to an Amazon Chime SDK meeting resource.</p>
    async fn list_tags_for_resource(
        &self,
        input: ListTagsForResourceRequest,
    ) -> Result<ListTagsForResourceResponse, RusotoError<ListTagsForResourceError>>;

    /// <p>Lists the users that belong to the specified Amazon Chime account. You can specify an email address to list only the user that the email address belongs to.</p>
    async fn list_users(
        &self,
        input: ListUsersRequest,
    ) -> Result<ListUsersResponse, RusotoError<ListUsersError>>;

    /// <p>Lists the Amazon Chime Voice Connector groups for the administrator's AWS account.</p>
    async fn list_voice_connector_groups(
        &self,
        input: ListVoiceConnectorGroupsRequest,
    ) -> Result<ListVoiceConnectorGroupsResponse, RusotoError<ListVoiceConnectorGroupsError>>;

    /// <p>Lists the SIP credentials for the specified Amazon Chime Voice Connector.</p>
    async fn list_voice_connector_termination_credentials(
        &self,
        input: ListVoiceConnectorTerminationCredentialsRequest,
    ) -> Result<
        ListVoiceConnectorTerminationCredentialsResponse,
        RusotoError<ListVoiceConnectorTerminationCredentialsError>,
    >;

    /// <p>Lists the Amazon Chime Voice Connectors for the administrator's AWS account.</p>
    async fn list_voice_connectors(
        &self,
        input: ListVoiceConnectorsRequest,
    ) -> Result<ListVoiceConnectorsResponse, RusotoError<ListVoiceConnectorsError>>;

    /// <p>Logs out the specified user from all of the devices they are currently logged into.</p>
    async fn logout_user(
        &self,
        input: LogoutUserRequest,
    ) -> Result<LogoutUserResponse, RusotoError<LogoutUserError>>;

    /// <p>Sets the amount of time in days that a given <code>AppInstance</code> retains data.</p>
    async fn put_app_instance_retention_settings(
        &self,
        input: PutAppInstanceRetentionSettingsRequest,
    ) -> Result<
        PutAppInstanceRetentionSettingsResponse,
        RusotoError<PutAppInstanceRetentionSettingsError>,
    >;

    /// <p>The data streaming configurations of an <code>AppInstance</code>.</p>
    async fn put_app_instance_streaming_configurations(
        &self,
        input: PutAppInstanceStreamingConfigurationsRequest,
    ) -> Result<
        PutAppInstanceStreamingConfigurationsResponse,
        RusotoError<PutAppInstanceStreamingConfigurationsError>,
    >;

    /// <p>Creates an events configuration that allows a bot to receive outgoing events sent by Amazon Chime. Choose either an HTTPS endpoint or a Lambda function ARN. For more information, see <a>Bot</a>.</p>
    async fn put_events_configuration(
        &self,
        input: PutEventsConfigurationRequest,
    ) -> Result<PutEventsConfigurationResponse, RusotoError<PutEventsConfigurationError>>;

    /// <p> Puts retention settings for the specified Amazon Chime Enterprise account. We recommend using AWS CloudTrail to monitor usage of this API for your account. For more information, see <a href="https://docs.aws.amazon.com/chime/latest/ag/cloudtrail.html">Logging Amazon Chime API Calls with AWS CloudTrail</a> in the <i>Amazon Chime Administration Guide</i>.</p> <p> To turn off existing retention settings, remove the number of days from the corresponding <b>RetentionDays</b> field in the <b>RetentionSettings</b> object. For more information about retention settings, see <a href="https://docs.aws.amazon.com/chime/latest/ag/chat-retention.html">Managing Chat Retention Policies</a> in the <i>Amazon Chime Administration Guide</i>.</p>
    async fn put_retention_settings(
        &self,
        input: PutRetentionSettingsRequest,
    ) -> Result<PutRetentionSettingsResponse, RusotoError<PutRetentionSettingsError>>;

    /// <p>Updates the logging configuration for the specified SIP media application.</p>
    async fn put_sip_media_application_logging_configuration(
        &self,
        input: PutSipMediaApplicationLoggingConfigurationRequest,
    ) -> Result<
        PutSipMediaApplicationLoggingConfigurationResponse,
        RusotoError<PutSipMediaApplicationLoggingConfigurationError>,
    >;

    /// <p>Puts emergency calling configuration details to the specified Amazon Chime Voice Connector, such as emergency phone numbers and calling countries. Origination and termination settings must be enabled for the Amazon Chime Voice Connector before emergency calling can be configured.</p>
    async fn put_voice_connector_emergency_calling_configuration(
        &self,
        input: PutVoiceConnectorEmergencyCallingConfigurationRequest,
    ) -> Result<
        PutVoiceConnectorEmergencyCallingConfigurationResponse,
        RusotoError<PutVoiceConnectorEmergencyCallingConfigurationError>,
    >;

    /// <p>Adds a logging configuration for the specified Amazon Chime Voice Connector. The logging configuration specifies whether SIP message logs are enabled for sending to Amazon CloudWatch Logs.</p>
    async fn put_voice_connector_logging_configuration(
        &self,
        input: PutVoiceConnectorLoggingConfigurationRequest,
    ) -> Result<
        PutVoiceConnectorLoggingConfigurationResponse,
        RusotoError<PutVoiceConnectorLoggingConfigurationError>,
    >;

    /// <p><p>Adds origination settings for the specified Amazon Chime Voice Connector.</p> <note> <p>If emergency calling is configured for the Amazon Chime Voice Connector, it must be deleted prior to turning off origination settings.</p> </note></p>
    async fn put_voice_connector_origination(
        &self,
        input: PutVoiceConnectorOriginationRequest,
    ) -> Result<PutVoiceConnectorOriginationResponse, RusotoError<PutVoiceConnectorOriginationError>>;

    /// <p>Puts the specified proxy configuration to the specified Amazon Chime Voice Connector.</p>
    async fn put_voice_connector_proxy(
        &self,
        input: PutVoiceConnectorProxyRequest,
    ) -> Result<PutVoiceConnectorProxyResponse, RusotoError<PutVoiceConnectorProxyError>>;

    /// <p>Adds a streaming configuration for the specified Amazon Chime Voice Connector. The streaming configuration specifies whether media streaming is enabled for sending to Indonesians. It also sets the retention period, in hours, for the Amazon Kinesis data.</p>
    async fn put_voice_connector_streaming_configuration(
        &self,
        input: PutVoiceConnectorStreamingConfigurationRequest,
    ) -> Result<
        PutVoiceConnectorStreamingConfigurationResponse,
        RusotoError<PutVoiceConnectorStreamingConfigurationError>,
    >;

    /// <p><p>Adds termination settings for the specified Amazon Chime Voice Connector.</p> <note> <p>If emergency calling is configured for the Amazon Chime Voice Connector, it must be deleted prior to turning off termination settings.</p> </note></p>
    async fn put_voice_connector_termination(
        &self,
        input: PutVoiceConnectorTerminationRequest,
    ) -> Result<PutVoiceConnectorTerminationResponse, RusotoError<PutVoiceConnectorTerminationError>>;

    /// <p>Adds termination SIP credentials for the specified Amazon Chime Voice Connector.</p>
    async fn put_voice_connector_termination_credentials(
        &self,
        input: PutVoiceConnectorTerminationCredentialsRequest,
    ) -> Result<(), RusotoError<PutVoiceConnectorTerminationCredentialsError>>;

    /// <p><p>Redacts message content, but not metadata. The message exists in the back end, but the action returns null content, and the state shows as redacted.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note></p>
    async fn redact_channel_message(
        &self,
        input: RedactChannelMessageRequest,
    ) -> Result<RedactChannelMessageResponse, RusotoError<RedactChannelMessageError>>;

    /// <p>Redacts the specified message from the specified Amazon Chime conversation.</p>
    async fn redact_conversation_message(
        &self,
        input: RedactConversationMessageRequest,
    ) -> Result<RedactConversationMessageResponse, RusotoError<RedactConversationMessageError>>;

    /// <p>Redacts the specified message from the specified Amazon Chime channel.</p>
    async fn redact_room_message(
        &self,
        input: RedactRoomMessageRequest,
    ) -> Result<RedactRoomMessageResponse, RusotoError<RedactRoomMessageError>>;

    /// <p>Regenerates the security token for a bot.</p>
    async fn regenerate_security_token(
        &self,
        input: RegenerateSecurityTokenRequest,
    ) -> Result<RegenerateSecurityTokenResponse, RusotoError<RegenerateSecurityTokenError>>;

    /// <p>Resets the personal meeting PIN for the specified user on an Amazon Chime account. Returns the <a>User</a> object with the updated personal meeting PIN.</p>
    async fn reset_personal_pin(
        &self,
        input: ResetPersonalPINRequest,
    ) -> Result<ResetPersonalPINResponse, RusotoError<ResetPersonalPINError>>;

    /// <p>Moves a phone number from the <b>Deletion queue</b> back into the phone number <b>Inventory</b>.</p>
    async fn restore_phone_number(
        &self,
        input: RestorePhoneNumberRequest,
    ) -> Result<RestorePhoneNumberResponse, RusotoError<RestorePhoneNumberError>>;

    /// <p>Searches for phone numbers that can be ordered. For US numbers, provide at least one of the following search filters: <code>AreaCode</code>, <code>City</code>, <code>State</code>, or <code>TollFreePrefix</code>. If you provide <code>City</code>, you must also provide <code>State</code>. Numbers outside the US only support the <code>PhoneNumberType</code> filter, which you must use.</p>
    async fn search_available_phone_numbers(
        &self,
        input: SearchAvailablePhoneNumbersRequest,
    ) -> Result<SearchAvailablePhoneNumbersResponse, RusotoError<SearchAvailablePhoneNumbersError>>;

    /// <p><p>Sends a message to a particular channel that the member is a part of.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> <p>Also, <code>STANDARD</code> messages can contain 4KB of data and the 1KB of metadata. <code>CONTROL</code> messages can contain 30 bytes of data and no metadata.</p> </note></p>
    async fn send_channel_message(
        &self,
        input: SendChannelMessageRequest,
    ) -> Result<SendChannelMessageResponse, RusotoError<SendChannelMessageError>>;

    /// <p>Applies the specified tags to the specified Amazon Chime SDK attendee.</p>
    async fn tag_attendee(
        &self,
        input: TagAttendeeRequest,
    ) -> Result<(), RusotoError<TagAttendeeError>>;

    /// <p>Applies the specified tags to the specified Amazon Chime SDK meeting.</p>
    async fn tag_meeting(
        &self,
        input: TagMeetingRequest,
    ) -> Result<(), RusotoError<TagMeetingError>>;

    /// <p>Applies the specified tags to the specified Amazon Chime SDK meeting resource.</p>
    async fn tag_resource(
        &self,
        input: TagResourceRequest,
    ) -> Result<(), RusotoError<TagResourceError>>;

    /// <p>Untags the specified tags from the specified Amazon Chime SDK attendee.</p>
    async fn untag_attendee(
        &self,
        input: UntagAttendeeRequest,
    ) -> Result<(), RusotoError<UntagAttendeeError>>;

    /// <p>Untags the specified tags from the specified Amazon Chime SDK meeting.</p>
    async fn untag_meeting(
        &self,
        input: UntagMeetingRequest,
    ) -> Result<(), RusotoError<UntagMeetingError>>;

    /// <p>Untags the specified tags from the specified Amazon Chime SDK meeting resource.</p>
    async fn untag_resource(
        &self,
        input: UntagResourceRequest,
    ) -> Result<(), RusotoError<UntagResourceError>>;

    /// <p>Updates account details for the specified Amazon Chime account. Currently, only account name and default license updates are supported for this action.</p>
    async fn update_account(
        &self,
        input: UpdateAccountRequest,
    ) -> Result<UpdateAccountResponse, RusotoError<UpdateAccountError>>;

    /// <p>Updates the settings for the specified Amazon Chime account. You can update settings for remote control of shared screens, or for the dial-out option. For more information about these settings, see <a href="https://docs.aws.amazon.com/chime/latest/ag/policies.html">Use the Policies Page</a> in the <i>Amazon Chime Administration Guide</i>.</p>
    async fn update_account_settings(
        &self,
        input: UpdateAccountSettingsRequest,
    ) -> Result<UpdateAccountSettingsResponse, RusotoError<UpdateAccountSettingsError>>;

    /// <p>Updates <code>AppInstance</code> metadata.</p>
    async fn update_app_instance(
        &self,
        input: UpdateAppInstanceRequest,
    ) -> Result<UpdateAppInstanceResponse, RusotoError<UpdateAppInstanceError>>;

    /// <p>Updates the details of an <code>AppInstanceUser</code>. You can update names and metadata.</p>
    async fn update_app_instance_user(
        &self,
        input: UpdateAppInstanceUserRequest,
    ) -> Result<UpdateAppInstanceUserResponse, RusotoError<UpdateAppInstanceUserError>>;

    /// <p>Updates the status of the specified bot, such as starting or stopping the bot from running in your Amazon Chime Enterprise account.</p>
    async fn update_bot(
        &self,
        input: UpdateBotRequest,
    ) -> Result<UpdateBotResponse, RusotoError<UpdateBotError>>;

    /// <p><p>Update a channel&#39;s attributes.</p> <p> <b>Restriction</b>: You can&#39;t change a channel&#39;s privacy. </p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note></p>
    async fn update_channel(
        &self,
        input: UpdateChannelRequest,
    ) -> Result<UpdateChannelResponse, RusotoError<UpdateChannelError>>;

    /// <p><p>Updates the content of a message.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note></p>
    async fn update_channel_message(
        &self,
        input: UpdateChannelMessageRequest,
    ) -> Result<UpdateChannelMessageResponse, RusotoError<UpdateChannelMessageError>>;

    /// <p><p>The details of the time when a user last read messages in a channel.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note></p>
    async fn update_channel_read_marker(
        &self,
        input: UpdateChannelReadMarkerRequest,
    ) -> Result<UpdateChannelReadMarkerResponse, RusotoError<UpdateChannelReadMarkerError>>;

    /// <p>Updates global settings for the administrator's AWS account, such as Amazon Chime Business Calling and Amazon Chime Voice Connector settings.</p>
    async fn update_global_settings(
        &self,
        input: UpdateGlobalSettingsRequest,
    ) -> Result<(), RusotoError<UpdateGlobalSettingsError>>;

    /// <p>Updates phone number details, such as product type or calling name, for the specified phone number ID. You can update one phone number detail at a time. For example, you can update either the product type or the calling name in one action.</p> <p>For toll-free numbers, you cannot use the Amazon Chime Business Calling product type. For numbers outside the U.S., you must use the Amazon Chime SIP Media Application Dial-In product type.</p> <p>Updates to outbound calling names can take 72 hours to complete. Pending updates to outbound calling names must be complete before you can request another update.</p>
    async fn update_phone_number(
        &self,
        input: UpdatePhoneNumberRequest,
    ) -> Result<UpdatePhoneNumberResponse, RusotoError<UpdatePhoneNumberError>>;

    /// <p>Updates the phone number settings for the administrator's AWS account, such as the default outbound calling name. You can update the default outbound calling name once every seven days. Outbound calling names can take up to 72 hours to update.</p>
    async fn update_phone_number_settings(
        &self,
        input: UpdatePhoneNumberSettingsRequest,
    ) -> Result<(), RusotoError<UpdatePhoneNumberSettingsError>>;

    /// <p>Updates the specified proxy session details, such as voice or SMS capabilities.</p>
    async fn update_proxy_session(
        &self,
        input: UpdateProxySessionRequest,
    ) -> Result<UpdateProxySessionResponse, RusotoError<UpdateProxySessionError>>;

    /// <p>Updates room details, such as the room name, for a room in an Amazon Chime Enterprise account.</p>
    async fn update_room(
        &self,
        input: UpdateRoomRequest,
    ) -> Result<UpdateRoomResponse, RusotoError<UpdateRoomError>>;

    /// <p>Updates room membership details, such as the member role, for a room in an Amazon Chime Enterprise account. The member role designates whether the member is a chat room administrator or a general chat room member. The member role can be updated only for user IDs.</p>
    async fn update_room_membership(
        &self,
        input: UpdateRoomMembershipRequest,
    ) -> Result<UpdateRoomMembershipResponse, RusotoError<UpdateRoomMembershipError>>;

    /// <p>Updates the details of the specified SIP media application.</p>
    async fn update_sip_media_application(
        &self,
        input: UpdateSipMediaApplicationRequest,
    ) -> Result<UpdateSipMediaApplicationResponse, RusotoError<UpdateSipMediaApplicationError>>;

    /// <p>Allows you to trigger a Lambda function at any time while a call is active, and replace the current actions with new actions returned by the invocation.</p>
    async fn update_sip_media_application_call(
        &self,
        input: UpdateSipMediaApplicationCallRequest,
    ) -> Result<
        UpdateSipMediaApplicationCallResponse,
        RusotoError<UpdateSipMediaApplicationCallError>,
    >;

    /// <p>Updates the details of the specified SIP rule.</p>
    async fn update_sip_rule(
        &self,
        input: UpdateSipRuleRequest,
    ) -> Result<UpdateSipRuleResponse, RusotoError<UpdateSipRuleError>>;

    /// <p>Updates user details for a specified user ID. Currently, only <code>LicenseType</code> updates are supported for this action.</p>
    async fn update_user(
        &self,
        input: UpdateUserRequest,
    ) -> Result<UpdateUserResponse, RusotoError<UpdateUserError>>;

    /// <p>Updates the settings for the specified user, such as phone number settings.</p>
    async fn update_user_settings(
        &self,
        input: UpdateUserSettingsRequest,
    ) -> Result<(), RusotoError<UpdateUserSettingsError>>;

    /// <p>Updates details for the specified Amazon Chime Voice Connector.</p>
    async fn update_voice_connector(
        &self,
        input: UpdateVoiceConnectorRequest,
    ) -> Result<UpdateVoiceConnectorResponse, RusotoError<UpdateVoiceConnectorError>>;

    /// <p>Updates details of the specified Amazon Chime Voice Connector group, such as the name and Amazon Chime Voice Connector priority ranking.</p>
    async fn update_voice_connector_group(
        &self,
        input: UpdateVoiceConnectorGroupRequest,
    ) -> Result<UpdateVoiceConnectorGroupResponse, RusotoError<UpdateVoiceConnectorGroupError>>;
}
/// A client for the Amazon Chime API.
#[derive(Clone)]
pub struct ChimeClient {
    client: Client,
    region: region::Region,
}

impl ChimeClient {
    /// Creates a client backed by the default tokio event loop.
    ///
    /// The client will use the default credentials provider and tls client.
    pub fn new(region: region::Region) -> ChimeClient {
        ChimeClient {
            client: Client::shared(),
            region,
        }
    }

    pub fn new_with<P, D>(
        request_dispatcher: D,
        credentials_provider: P,
        region: region::Region,
    ) -> ChimeClient
    where
        P: ProvideAwsCredentials + Send + Sync + 'static,
        D: DispatchSignedRequest + Send + Sync + 'static,
    {
        ChimeClient {
            client: Client::new_with(credentials_provider, request_dispatcher),
            region,
        }
    }

    pub fn new_with_client(client: Client, region: region::Region) -> ChimeClient {
        ChimeClient { client, region }
    }
}

#[async_trait]
impl Chime for ChimeClient {
    /// <p>Associates a phone number with the specified Amazon Chime user.</p>
    #[allow(unused_mut)]
    async fn associate_phone_number_with_user(
        &self,
        input: AssociatePhoneNumberWithUserRequest,
    ) -> Result<AssociatePhoneNumberWithUserResponse, RusotoError<AssociatePhoneNumberWithUserError>>
    {
        let request_uri = format!(
            "/accounts/{account_id}/users/{user_id}",
            account_id = input.account_id,
            user_id = input.user_id
        );

        let mut request = SignedRequest::new("POST", "chime", &self.region, &request_uri);
        request.set_content_type("application/x-amz-json-1.1".to_owned());

        let encoded = Some(serde_json::to_vec(&input).unwrap());
        request.set_payload(encoded);

        let mut params = Params::new();
        params.put("operation", "associate-phone-number");
        request.set_params(params);

        let mut response = self
            .client
            .sign_and_dispatch(request)
            .await
            .map_err(RusotoError::from)?;
        if response.status.as_u16() == 200 {
            let mut response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            let result = proto::json::ResponsePayload::new(&response)
                .deserialize::<AssociatePhoneNumberWithUserResponse, _>()?;

            Ok(result)
        } else {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            Err(AssociatePhoneNumberWithUserError::from_response(response))
        }
    }

    /// <p>Associates phone numbers with the specified Amazon Chime Voice Connector.</p>
    #[allow(unused_mut)]
    async fn associate_phone_numbers_with_voice_connector(
        &self,
        input: AssociatePhoneNumbersWithVoiceConnectorRequest,
    ) -> Result<
        AssociatePhoneNumbersWithVoiceConnectorResponse,
        RusotoError<AssociatePhoneNumbersWithVoiceConnectorError>,
    > {
        let request_uri = format!(
            "/voice-connectors/{voice_connector_id}",
            voice_connector_id = input.voice_connector_id
        );

        let mut request = SignedRequest::new("POST", "chime", &self.region, &request_uri);
        request.set_content_type("application/x-amz-json-1.1".to_owned());

        let encoded = Some(serde_json::to_vec(&input).unwrap());
        request.set_payload(encoded);

        let mut params = Params::new();
        params.put("operation", "associate-phone-numbers");
        request.set_params(params);

        let mut response = self
            .client
            .sign_and_dispatch(request)
            .await
            .map_err(RusotoError::from)?;
        if response.status.as_u16() == 200 {
            let mut response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            let result = proto::json::ResponsePayload::new(&response)
                .deserialize::<AssociatePhoneNumbersWithVoiceConnectorResponse, _>()?;

            Ok(result)
        } else {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            Err(AssociatePhoneNumbersWithVoiceConnectorError::from_response(
                response,
            ))
        }
    }

    /// <p>Associates phone numbers with the specified Amazon Chime Voice Connector group.</p>
    #[allow(unused_mut)]
    async fn associate_phone_numbers_with_voice_connector_group(
        &self,
        input: AssociatePhoneNumbersWithVoiceConnectorGroupRequest,
    ) -> Result<
        AssociatePhoneNumbersWithVoiceConnectorGroupResponse,
        RusotoError<AssociatePhoneNumbersWithVoiceConnectorGroupError>,
    > {
        let request_uri = format!(
            "/voice-connector-groups/{voice_connector_group_id}",
            voice_connector_group_id = input.voice_connector_group_id
        );

        let mut request = SignedRequest::new("POST", "chime", &self.region, &request_uri);
        request.set_content_type("application/x-amz-json-1.1".to_owned());

        let encoded = Some(serde_json::to_vec(&input).unwrap());
        request.set_payload(encoded);

        let mut params = Params::new();
        params.put("operation", "associate-phone-numbers");
        request.set_params(params);

        let mut response = self
            .client
            .sign_and_dispatch(request)
            .await
            .map_err(RusotoError::from)?;
        if response.status.as_u16() == 200 {
            let mut response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            let result = proto::json::ResponsePayload::new(&response)
                .deserialize::<AssociatePhoneNumbersWithVoiceConnectorGroupResponse, _>(
            )?;

            Ok(result)
        } else {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            Err(AssociatePhoneNumbersWithVoiceConnectorGroupError::from_response(response))
        }
    }

    /// <p>Associates the specified sign-in delegate groups with the specified Amazon Chime account.</p>
    #[allow(unused_mut)]
    async fn associate_signin_delegate_groups_with_account(
        &self,
        input: AssociateSigninDelegateGroupsWithAccountRequest,
    ) -> Result<
        AssociateSigninDelegateGroupsWithAccountResponse,
        RusotoError<AssociateSigninDelegateGroupsWithAccountError>,
    > {
        let request_uri = format!("/accounts/{account_id}", account_id = input.account_id);

        let mut request = SignedRequest::new("POST", "chime", &self.region, &request_uri);
        request.set_content_type("application/x-amz-json-1.1".to_owned());

        let encoded = Some(serde_json::to_vec(&input).unwrap());
        request.set_payload(encoded);

        let mut params = Params::new();
        params.put("operation", "associate-signin-delegate-groups");
        request.set_params(params);

        let mut response = self
            .client
            .sign_and_dispatch(request)
            .await
            .map_err(RusotoError::from)?;
        if response.status.as_u16() == 200 {
            let mut response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            let result = proto::json::ResponsePayload::new(&response)
                .deserialize::<AssociateSigninDelegateGroupsWithAccountResponse, _>()?;

            Ok(result)
        } else {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            Err(AssociateSigninDelegateGroupsWithAccountError::from_response(response))
        }
    }

    /// <p> Creates up to 100 new attendees for an active Amazon Chime SDK meeting. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i>. </p>
    #[allow(unused_mut)]
    async fn batch_create_attendee(
        &self,
        input: BatchCreateAttendeeRequest,
    ) -> Result<BatchCreateAttendeeResponse, RusotoError<BatchCreateAttendeeError>> {
        let request_uri = format!(
            "/meetings/{meeting_id}/attendees",
            meeting_id = input.meeting_id
        );

        let mut request = SignedRequest::new("POST", "chime", &self.region, &request_uri);
        request.set_content_type("application/x-amz-json-1.1".to_owned());

        let encoded = Some(serde_json::to_vec(&input).unwrap());
        request.set_payload(encoded);

        let mut params = Params::new();
        params.put("operation", "batch-create");
        request.set_params(params);

        let mut response = self
            .client
            .sign_and_dispatch(request)
            .await
            .map_err(RusotoError::from)?;
        if response.status.as_u16() == 201 {
            let mut response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            let result = proto::json::ResponsePayload::new(&response)
                .deserialize::<BatchCreateAttendeeResponse, _>()?;

            Ok(result)
        } else {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            Err(BatchCreateAttendeeError::from_response(response))
        }
    }

    /// <p>Adds a specified number of users to a channel. </p>
    #[allow(unused_mut)]
    async fn batch_create_channel_membership(
        &self,
        input: BatchCreateChannelMembershipRequest,
    ) -> Result<BatchCreateChannelMembershipResponse, RusotoError<BatchCreateChannelMembershipError>>
    {
        let request_uri = format!(
            "/channels/{channel_arn}/memberships",
            channel_arn = input.channel_arn
        );

        let mut request = SignedRequest::new("POST", "chime", &self.region, &request_uri);
        request.set_content_type("application/x-amz-json-1.1".to_owned());

        let encoded = Some(serde_json::to_vec(&input).unwrap());
        request.set_payload(encoded);
        request.add_optional_header("x-amz-chime-bearer", input.chime_bearer.as_ref());
        let mut params = Params::new();
        params.put("operation", "batch-create");
        request.set_params(params);

        let mut response = self
            .client
            .sign_and_dispatch(request)
            .await
            .map_err(RusotoError::from)?;
        if response.status.as_u16() == 200 {
            let mut response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            let result = proto::json::ResponsePayload::new(&response)
                .deserialize::<BatchCreateChannelMembershipResponse, _>()?;

            Ok(result)
        } else {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            Err(BatchCreateChannelMembershipError::from_response(response))
        }
    }

    /// <p>Adds up to 50 members to a chat room in an Amazon Chime Enterprise account. Members can be users or bots. The member role designates whether the member is a chat room administrator or a general chat room member.</p>
    #[allow(unused_mut)]
    async fn batch_create_room_membership(
        &self,
        input: BatchCreateRoomMembershipRequest,
    ) -> Result<BatchCreateRoomMembershipResponse, RusotoError<BatchCreateRoomMembershipError>>
    {
        let request_uri = format!(
            "/accounts/{account_id}/rooms/{room_id}/memberships",
            account_id = input.account_id,
            room_id = input.room_id
        );

        let mut request = SignedRequest::new("POST", "chime", &self.region, &request_uri);
        request.set_content_type("application/x-amz-json-1.1".to_owned());

        let encoded = Some(serde_json::to_vec(&input).unwrap());
        request.set_payload(encoded);

        let mut params = Params::new();
        params.put("operation", "batch-create");
        request.set_params(params);

        let mut response = self
            .client
            .sign_and_dispatch(request)
            .await
            .map_err(RusotoError::from)?;
        if response.status.as_u16() == 201 {
            let mut response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            let result = proto::json::ResponsePayload::new(&response)
                .deserialize::<BatchCreateRoomMembershipResponse, _>()?;

            Ok(result)
        } else {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            Err(BatchCreateRoomMembershipError::from_response(response))
        }
    }

    /// <p> Moves phone numbers into the <b>Deletion queue</b>. Phone numbers must be disassociated from any users or Amazon Chime Voice Connectors before they can be deleted. </p> <p> Phone numbers remain in the <b>Deletion queue</b> for 7 days before they are deleted permanently. </p>
    #[allow(unused_mut)]
    async fn batch_delete_phone_number(
        &self,
        input: BatchDeletePhoneNumberRequest,
    ) -> Result<BatchDeletePhoneNumberResponse, RusotoError<BatchDeletePhoneNumberError>> {
        let request_uri = "/phone-numbers";

        let mut request = SignedRequest::new("POST", "chime", &self.region, &request_uri);
        request.set_content_type("application/x-amz-json-1.1".to_owned());

        let encoded = Some(serde_json::to_vec(&input).unwrap());
        request.set_payload(encoded);

        let mut params = Params::new();
        params.put("operation", "batch-delete");
        request.set_params(params);

        let mut response = self
            .client
            .sign_and_dispatch(request)
            .await
            .map_err(RusotoError::from)?;
        if response.status.as_u16() == 200 {
            let mut response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            let result = proto::json::ResponsePayload::new(&response)
                .deserialize::<BatchDeletePhoneNumberResponse, _>()?;

            Ok(result)
        } else {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            Err(BatchDeletePhoneNumberError::from_response(response))
        }
    }

    /// <p>Suspends up to 50 users from a <code>Team</code> or <code>EnterpriseLWA</code> Amazon Chime account. For more information about different account types, see <a href="https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html">Managing Your Amazon Chime Accounts</a> in the <i>Amazon Chime Administration Guide</i>.</p> <p>Users suspended from a <code>Team</code> account are disassociated from the account,but they can continue to use Amazon Chime as free users. To remove the suspension from suspended <code>Team</code> account users, invite them to the <code>Team</code> account again. You can use the <a>InviteUsers</a> action to do so.</p> <p>Users suspended from an <code>EnterpriseLWA</code> account are immediately signed out of Amazon Chime and can no longer sign in. To remove the suspension from suspended <code>EnterpriseLWA</code> account users, use the <a>BatchUnsuspendUser</a> action.</p> <p> To sign out users without suspending them, use the <a>LogoutUser</a> action. </p>
    #[allow(unused_mut)]
    async fn batch_suspend_user(
        &self,
        input: BatchSuspendUserRequest,
    ) -> Result<BatchSuspendUserResponse, RusotoError<BatchSuspendUserError>> {
        let request_uri = format!(
            "/accounts/{account_id}/users",
            account_id = input.account_id
        );

        let mut request = SignedRequest::new("POST", "chime", &self.region, &request_uri);
        request.set_content_type("application/x-amz-json-1.1".to_owned());

        let encoded = Some(serde_json::to_vec(&input).unwrap());
        request.set_payload(encoded);

        let mut params = Params::new();
        params.put("operation", "suspend");
        request.set_params(params);

        let mut response = self
            .client
            .sign_and_dispatch(request)
            .await
            .map_err(RusotoError::from)?;
        if response.status.as_u16() == 200 {
            let mut response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            let result = proto::json::ResponsePayload::new(&response)
                .deserialize::<BatchSuspendUserResponse, _>()?;

            Ok(result)
        } else {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            Err(BatchSuspendUserError::from_response(response))
        }
    }

    /// <p>Removes the suspension from up to 50 previously suspended users for the specified Amazon Chime <code>EnterpriseLWA</code> account. Only users on <code>EnterpriseLWA</code> accounts can be unsuspended using this action. For more information about different account types, see <a href="https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html"> Managing Your Amazon Chime Accounts </a> in the account types, in the <i>Amazon Chime Administration Guide</i>. </p> <p> Previously suspended users who are unsuspended using this action are returned to <code>Registered</code> status. Users who are not previously suspended are ignored. </p>
    #[allow(unused_mut)]
    async fn batch_unsuspend_user(
        &self,
        input: BatchUnsuspendUserRequest,
    ) -> Result<BatchUnsuspendUserResponse, RusotoError<BatchUnsuspendUserError>> {
        let request_uri = format!(
            "/accounts/{account_id}/users",
            account_id = input.account_id
        );

        let mut request = SignedRequest::new("POST", "chime", &self.region, &request_uri);
        request.set_content_type("application/x-amz-json-1.1".to_owned());

        let encoded = Some(serde_json::to_vec(&input).unwrap());
        request.set_payload(encoded);

        let mut params = Params::new();
        params.put("operation", "unsuspend");
        request.set_params(params);

        let mut response = self
            .client
            .sign_and_dispatch(request)
            .await
            .map_err(RusotoError::from)?;
        if response.status.as_u16() == 200 {
            let mut response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            let result = proto::json::ResponsePayload::new(&response)
                .deserialize::<BatchUnsuspendUserResponse, _>()?;

            Ok(result)
        } else {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            Err(BatchUnsuspendUserError::from_response(response))
        }
    }

    /// <p>Updates phone number product types or calling names. You can update one attribute at a time for each <code>UpdatePhoneNumberRequestItem</code>. For example, you can update the product type or the calling name.</p> <p>For toll-free numbers, you cannot use the Amazon Chime Business Calling product type. For numbers outside the U.S., you must use the Amazon Chime SIP Media Application Dial-In product type.</p> <p>Updates to outbound calling names can take up to 72 hours to complete. Pending updates to outbound calling names must be complete before you can request another update.</p>
    #[allow(unused_mut)]
    async fn batch_update_phone_number(
        &self,
        input: BatchUpdatePhoneNumberRequest,
    ) -> Result<BatchUpdatePhoneNumberResponse, RusotoError<BatchUpdatePhoneNumberError>> {
        let request_uri = "/phone-numbers";

        let mut request = SignedRequest::new("POST", "chime", &self.region, &request_uri);
        request.set_content_type("application/x-amz-json-1.1".to_owned());

        let encoded = Some(serde_json::to_vec(&input).unwrap());
        request.set_payload(encoded);

        let mut params = Params::new();
        params.put("operation", "batch-update");
        request.set_params(params);

        let mut response = self
            .client
            .sign_and_dispatch(request)
            .await
            .map_err(RusotoError::from)?;
        if response.status.as_u16() == 200 {
            let mut response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            let result = proto::json::ResponsePayload::new(&response)
                .deserialize::<BatchUpdatePhoneNumberResponse, _>()?;

            Ok(result)
        } else {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            Err(BatchUpdatePhoneNumberError::from_response(response))
        }
    }

    /// <p>Updates user details within the <a>UpdateUserRequestItem</a> object for up to 20 users for the specified Amazon Chime account. Currently, only <code>LicenseType</code> updates are supported for this action.</p>
    #[allow(unused_mut)]
    async fn batch_update_user(
        &self,
        input: BatchUpdateUserRequest,
    ) -> Result<BatchUpdateUserResponse, RusotoError<BatchUpdateUserError>> {
        let request_uri = format!(
            "/accounts/{account_id}/users",
            account_id = input.account_id
        );

        let mut request = SignedRequest::new("POST", "chime", &self.region, &request_uri);
        request.set_content_type("application/x-amz-json-1.1".to_owned());

        let encoded = Some(serde_json::to_vec(&input).unwrap());
        request.set_payload(encoded);

        let mut response = self
            .client
            .sign_and_dispatch(request)
            .await
            .map_err(RusotoError::from)?;
        if response.status.as_u16() == 200 {
            let mut response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            let result = proto::json::ResponsePayload::new(&response)
                .deserialize::<BatchUpdateUserResponse, _>()?;

            Ok(result)
        } else {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            Err(BatchUpdateUserError::from_response(response))
        }
    }

    /// <p>Creates an Amazon Chime account under the administrator's AWS account. Only <code>Team</code> account types are currently supported for this action. For more information about different account types, see <a href="https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html">Managing Your Amazon Chime Accounts</a> in the <i>Amazon Chime Administration Guide</i>.</p>
    #[allow(unused_mut)]
    async fn create_account(
        &self,
        input: CreateAccountRequest,
    ) -> Result<CreateAccountResponse, RusotoError<CreateAccountError>> {
        let request_uri = "/accounts";

        let mut request = SignedRequest::new("POST", "chime", &self.region, &request_uri);
        request.set_content_type("application/x-amz-json-1.1".to_owned());

        let encoded = Some(serde_json::to_vec(&input).unwrap());
        request.set_payload(encoded);

        let mut response = self
            .client
            .sign_and_dispatch(request)
            .await
            .map_err(RusotoError::from)?;
        if response.status.as_u16() == 201 {
            let mut response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            let result = proto::json::ResponsePayload::new(&response)
                .deserialize::<CreateAccountResponse, _>()?;

            Ok(result)
        } else {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            Err(CreateAccountError::from_response(response))
        }
    }

    /// <p>Creates an Amazon Chime SDK messaging <code>AppInstance</code> under an AWS account. Only SDK messaging customers use this API. <code>CreateAppInstance</code> supports idempotency behavior as described in the AWS API Standard.</p>
    #[allow(unused_mut)]
    async fn create_app_instance(
        &self,
        input: CreateAppInstanceRequest,
    ) -> Result<CreateAppInstanceResponse, RusotoError<CreateAppInstanceError>> {
        let request_uri = "/app-instances";

        let mut request = SignedRequest::new("POST", "chime", &self.region, &request_uri);
        request.set_content_type("application/x-amz-json-1.1".to_owned());

        let encoded = Some(serde_json::to_vec(&input).unwrap());
        request.set_payload(encoded);

        let mut response = self
            .client
            .sign_and_dispatch(request)
            .await
            .map_err(RusotoError::from)?;
        if response.status.as_u16() == 201 {
            let mut response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            let result = proto::json::ResponsePayload::new(&response)
                .deserialize::<CreateAppInstanceResponse, _>()?;

            Ok(result)
        } else {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            Err(CreateAppInstanceError::from_response(response))
        }
    }

    /// <p>Promotes an <code>AppInstanceUser</code> to an <code>AppInstanceAdmin</code>. The promoted user can perform the following actions. </p> <ul> <li> <p> <code>ChannelModerator</code> actions across all channels in the <code>AppInstance</code>.</p> </li> <li> <p> <code>DeleteChannelMessage</code> actions.</p> </li> </ul> <p>Only an <code>AppInstanceUser</code> can be promoted to an <code>AppInstanceAdmin</code> role.</p>
    #[allow(unused_mut)]
    async fn create_app_instance_admin(
        &self,
        input: CreateAppInstanceAdminRequest,
    ) -> Result<CreateAppInstanceAdminResponse, RusotoError<CreateAppInstanceAdminError>> {
        let request_uri = format!(
            "/app-instances/{app_instance_arn}/admins",
            app_instance_arn = input.app_instance_arn
        );

        let mut request = SignedRequest::new("POST", "chime", &self.region, &request_uri);
        request.set_content_type("application/x-amz-json-1.1".to_owned());

        let encoded = Some(serde_json::to_vec(&input).unwrap());
        request.set_payload(encoded);

        let mut response = self
            .client
            .sign_and_dispatch(request)
            .await
            .map_err(RusotoError::from)?;
        if response.status.as_u16() == 201 {
            let mut response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            let result = proto::json::ResponsePayload::new(&response)
                .deserialize::<CreateAppInstanceAdminResponse, _>()?;

            Ok(result)
        } else {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            Err(CreateAppInstanceAdminError::from_response(response))
        }
    }

    /// <p>Creates a user under an Amazon Chime <code>AppInstance</code>. The request consists of a unique <code>appInstanceUserId</code> and <code>Name</code> for that user.</p>
    #[allow(unused_mut)]
    async fn create_app_instance_user(
        &self,
        input: CreateAppInstanceUserRequest,
    ) -> Result<CreateAppInstanceUserResponse, RusotoError<CreateAppInstanceUserError>> {
        let request_uri = "/app-instance-users";

        let mut request = SignedRequest::new("POST", "chime", &self.region, &request_uri);
        request.set_content_type("application/x-amz-json-1.1".to_owned());

        let encoded = Some(serde_json::to_vec(&input).unwrap());
        request.set_payload(encoded);

        let mut response = self
            .client
            .sign_and_dispatch(request)
            .await
            .map_err(RusotoError::from)?;
        if response.status.as_u16() == 201 {
            let mut response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            let result = proto::json::ResponsePayload::new(&response)
                .deserialize::<CreateAppInstanceUserResponse, _>()?;

            Ok(result)
        } else {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            Err(CreateAppInstanceUserError::from_response(response))
        }
    }

    /// <p> Creates a new attendee for an active Amazon Chime SDK meeting. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i>. </p>
    #[allow(unused_mut)]
    async fn create_attendee(
        &self,
        input: CreateAttendeeRequest,
    ) -> Result<CreateAttendeeResponse, RusotoError<CreateAttendeeError>> {
        let request_uri = format!(
            "/meetings/{meeting_id}/attendees",
            meeting_id = input.meeting_id
        );

        let mut request = SignedRequest::new("POST", "chime", &self.region, &request_uri);
        request.set_content_type("application/x-amz-json-1.1".to_owned());

        let encoded = Some(serde_json::to_vec(&input).unwrap());
        request.set_payload(encoded);

        let mut response = self
            .client
            .sign_and_dispatch(request)
            .await
            .map_err(RusotoError::from)?;
        if response.status.as_u16() == 201 {
            let mut response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            let result = proto::json::ResponsePayload::new(&response)
                .deserialize::<CreateAttendeeResponse, _>()?;

            Ok(result)
        } else {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            Err(CreateAttendeeError::from_response(response))
        }
    }

    /// <p>Creates a bot for an Amazon Chime Enterprise account.</p>
    #[allow(unused_mut)]
    async fn create_bot(
        &self,
        input: CreateBotRequest,
    ) -> Result<CreateBotResponse, RusotoError<CreateBotError>> {
        let request_uri = format!("/accounts/{account_id}/bots", account_id = input.account_id);

        let mut request = SignedRequest::new("POST", "chime", &self.region, &request_uri);
        request.set_content_type("application/x-amz-json-1.1".to_owned());

        let encoded = Some(serde_json::to_vec(&input).unwrap());
        request.set_payload(encoded);

        let mut response = self
            .client
            .sign_and_dispatch(request)
            .await
            .map_err(RusotoError::from)?;
        if response.status.as_u16() == 201 {
            let mut response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            let result = proto::json::ResponsePayload::new(&response)
                .deserialize::<CreateBotResponse, _>()?;

            Ok(result)
        } else {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            Err(CreateBotError::from_response(response))
        }
    }

    /// <p><p>Creates a channel to which you can add users and send messages.</p> <p> <b>Restriction</b>: You can&#39;t change a channel&#39;s privacy.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note></p>
    #[allow(unused_mut)]
    async fn create_channel(
        &self,
        input: CreateChannelRequest,
    ) -> Result<CreateChannelResponse, RusotoError<CreateChannelError>> {
        let request_uri = "/channels";

        let mut request = SignedRequest::new("POST", "chime", &self.region, &request_uri);
        request.set_content_type("application/x-amz-json-1.1".to_owned());

        let encoded = Some(serde_json::to_vec(&input).unwrap());
        request.set_payload(encoded);
        request.add_optional_header("x-amz-chime-bearer", input.chime_bearer.as_ref());

        let mut response = self
            .client
            .sign_and_dispatch(request)
            .await
            .map_err(RusotoError::from)?;
        if response.status.as_u16() == 201 {
            let mut response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            let result = proto::json::ResponsePayload::new(&response)
                .deserialize::<CreateChannelResponse, _>()?;

            Ok(result)
        } else {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            Err(CreateChannelError::from_response(response))
        }
    }

    /// <p><p>Permanently bans a member from a channel. Moderators can&#39;t add banned members to a channel. To undo a ban, you first have to <code>DeleteChannelBan</code>, and then <code>CreateChannelMembership</code>. Bans are cleaned up when you delete users or channels.</p> <p>If you ban a user who is already part of a channel, that user is automatically kicked from the channel.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note></p>
    #[allow(unused_mut)]
    async fn create_channel_ban(
        &self,
        input: CreateChannelBanRequest,
    ) -> Result<CreateChannelBanResponse, RusotoError<CreateChannelBanError>> {
        let request_uri = format!(
            "/channels/{channel_arn}/bans",
            channel_arn = input.channel_arn
        );

        let mut request = SignedRequest::new("POST", "chime", &self.region, &request_uri);
        request.set_content_type("application/x-amz-json-1.1".to_owned());

        let encoded = Some(serde_json::to_vec(&input).unwrap());
        request.set_payload(encoded);
        request.add_optional_header("x-amz-chime-bearer", input.chime_bearer.as_ref());

        let mut response = self
            .client
            .sign_and_dispatch(request)
            .await
            .map_err(RusotoError::from)?;
        if response.status.as_u16() == 201 {
            let mut response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            let result = proto::json::ResponsePayload::new(&response)
                .deserialize::<CreateChannelBanResponse, _>()?;

            Ok(result)
        } else {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            Err(CreateChannelBanError::from_response(response))
        }
    }

    /// <p><p>Adds a user to a channel. The <code>InvitedBy</code> response field is derived from the request header. A channel member can:</p> <ul> <li> <p>List messages</p> </li> <li> <p>Send messages</p> </li> <li> <p>Receive messages</p> </li> <li> <p>Edit their own messages</p> </li> <li> <p>Leave the channel</p> </li> </ul> <p>Privacy settings impact this action as follows:</p> <ul> <li> <p>Public Channels: You do not need to be a member to list messages, but you must be a member to send messages.</p> </li> <li> <p>Private Channels: You must be a member to list or send messages.</p> </li> </ul> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note></p>
    #[allow(unused_mut)]
    async fn create_channel_membership(
        &self,
        input: CreateChannelMembershipRequest,
    ) -> Result<CreateChannelMembershipResponse, RusotoError<CreateChannelMembershipError>> {
        let request_uri = format!(
            "/channels/{channel_arn}/memberships",
            channel_arn = input.channel_arn
        );

        let mut request = SignedRequest::new("POST", "chime", &self.region, &request_uri);
        request.set_content_type("application/x-amz-json-1.1".to_owned());

        let encoded = Some(serde_json::to_vec(&input).unwrap());
        request.set_payload(encoded);
        request.add_optional_header("x-amz-chime-bearer", input.chime_bearer.as_ref());

        let mut response = self
            .client
            .sign_and_dispatch(request)
            .await
            .map_err(RusotoError::from)?;
        if response.status.as_u16() == 201 {
            let mut response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            let result = proto::json::ResponsePayload::new(&response)
                .deserialize::<CreateChannelMembershipResponse, _>()?;

            Ok(result)
        } else {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            Err(CreateChannelMembershipError::from_response(response))
        }
    }

    /// <p><p>Creates a new <code>ChannelModerator</code>. A channel moderator can:</p> <ul> <li> <p>Add and remove other members of the channel.</p> </li> <li> <p>Add and remove other moderators of the channel.</p> </li> <li> <p>Add and remove user bans for the channel.</p> </li> <li> <p>Redact messages in the channel.</p> </li> <li> <p>List messages in the channel.</p> </li> </ul> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note></p>
    #[allow(unused_mut)]
    async fn create_channel_moderator(
        &self,
        input: CreateChannelModeratorRequest,
    ) -> Result<CreateChannelModeratorResponse, RusotoError<CreateChannelModeratorError>> {
        let request_uri = format!(
            "/channels/{channel_arn}/moderators",
            channel_arn = input.channel_arn
        );

        let mut request = SignedRequest::new("POST", "chime", &self.region, &request_uri);
        request.set_content_type("application/x-amz-json-1.1".to_owned());

        let encoded = Some(serde_json::to_vec(&input).unwrap());
        request.set_payload(encoded);
        request.add_optional_header("x-amz-chime-bearer", input.chime_bearer.as_ref());

        let mut response = self
            .client
            .sign_and_dispatch(request)
            .await
            .map_err(RusotoError::from)?;
        if response.status.as_u16() == 201 {
            let mut response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            let result = proto::json::ResponsePayload::new(&response)
                .deserialize::<CreateChannelModeratorResponse, _>()?;

         