// =================================================================
//
//                           * WARNING *
//
//                    This file is generated!
//
//  Changes made to this file will be overwritten. If changes are
//  required to the generated code, the service_crategen project
//  must be updated to generate the changes.
//
// =================================================================

use std::error::Error;
use std::fmt;

use async_trait::async_trait;
use rusoto_core::credential::ProvideAwsCredentials;
use rusoto_core::region;
use rusoto_core::request::{BufferedHttpResponse, DispatchSignedRequest};
use rusoto_core::{Client, RusotoError};

use rusoto_core::proto;
use rusoto_core::request::HttpResponse;
use rusoto_core::signature::SignedRequest;
#[allow(unused_imports)]
use serde::{Deserialize, Serialize};

impl BudgetsClient {
    fn new_signed_request(&self, http_method: &str, request_uri: &str) -> SignedRequest {
        let mut request = SignedRequest::new(http_method, "budgets", &self.region, request_uri);

        request.set_content_type("application/x-amz-json-1.1".to_owned());

        request
    }

    async fn sign_and_dispatch<E>(
        &self,
        request: SignedRequest,
        from_response: fn(BufferedHttpResponse) -> RusotoError<E>,
    ) -> Result<HttpResponse, RusotoError<E>> {
        let mut response = self.client.sign_and_dispatch(request).await?;
        if !response.status.is_success() {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            return Err(from_response(response));
        }

        Ok(response)
    }
}

use serde_json;
/// <p> A budget action resource. </p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct Action {
    /// <p> A system-generated universally unique identifier (UUID) for the action. </p>
    #[serde(rename = "ActionId")]
    pub action_id: String,
    /// <p> The trigger threshold of the action. </p>
    #[serde(rename = "ActionThreshold")]
    pub action_threshold: ActionThreshold,
    /// <p> The type of action. This defines the type of tasks that can be carried out by this action. This field also determines the format for definition. </p>
    #[serde(rename = "ActionType")]
    pub action_type: String,
    /// <p> This specifies if the action needs manual or automatic approval. </p>
    #[serde(rename = "ApprovalModel")]
    pub approval_model: String,
    #[serde(rename = "BudgetName")]
    pub budget_name: String,
    /// <p> Where you specify all of the type-specific parameters. </p>
    #[serde(rename = "Definition")]
    pub definition: Definition,
    /// <p> The role passed for action execution and reversion. Roles and actions must be in the same account. </p>
    #[serde(rename = "ExecutionRoleArn")]
    pub execution_role_arn: String,
    #[serde(rename = "NotificationType")]
    pub notification_type: String,
    /// <p> The status of action. </p>
    #[serde(rename = "Status")]
    pub status: String,
    #[serde(rename = "Subscribers")]
    pub subscribers: Vec<Subscriber>,
}

/// <p> The historical records for a budget action. </p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ActionHistory {
    /// <p> The description of details of the event. </p>
    #[serde(rename = "ActionHistoryDetails")]
    pub action_history_details: ActionHistoryDetails,
    /// <p> This distinguishes between whether the events are triggered by the user or generated by the system. </p>
    #[serde(rename = "EventType")]
    pub event_type: String,
    /// <p> The status of action at the time of the event. </p>
    #[serde(rename = "Status")]
    pub status: String,
    #[serde(rename = "Timestamp")]
    pub timestamp: f64,
}

/// <p> The description of details of the event. </p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ActionHistoryDetails {
    /// <p> The budget action resource. </p>
    #[serde(rename = "Action")]
    pub action: Action,
    #[serde(rename = "Message")]
    pub message: String,
}

/// <p> The trigger threshold of the action. </p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ActionThreshold {
    #[serde(rename = "ActionThresholdType")]
    pub action_threshold_type: String,
    #[serde(rename = "ActionThresholdValue")]
    pub action_threshold_value: f64,
}

/// <p>Represents the output of the <code>CreateBudget</code> operation. The content consists of the detailed metadata and data file information, and the current status of the <code>budget</code> object.</p> <p>This is the ARN pattern for a budget: </p> <p> <code>arn:aws:budgets::AccountId:budget/budgetName</code> </p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct Budget {
    /// <p>The total amount of cost, usage, RI utilization, RI coverage, Savings Plans utilization, or Savings Plans coverage that you want to track with your budget.</p> <p> <code>BudgetLimit</code> is required for cost or usage budgets, but optional for RI or Savings Plans utilization or coverage budgets. RI and Savings Plans utilization or coverage budgets default to <code>100</code>, which is the only valid value for RI or Savings Plans utilization or coverage budgets. You can't use <code>BudgetLimit</code> with <code>PlannedBudgetLimits</code> for <code>CreateBudget</code> and <code>UpdateBudget</code> actions. </p>
    #[serde(rename = "BudgetLimit")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub budget_limit: Option<Spend>,
    /// <p>The name of a budget. The name must be unique within an account. The <code>:</code> and <code>&bsol;</code> characters aren't allowed in <code>BudgetName</code>.</p>
    #[serde(rename = "BudgetName")]
    pub budget_name: String,
    /// <p>Whether this budget tracks costs, usage, RI utilization, RI coverage, Savings Plans utilization, or Savings Plans coverage.</p>
    #[serde(rename = "BudgetType")]
    pub budget_type: String,
    /// <p>The actual and forecasted cost or usage that the budget tracks.</p>
    #[serde(rename = "CalculatedSpend")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub calculated_spend: Option<CalculatedSpend>,
    /// <p><p>The cost filters, such as service or tag, that are applied to a budget.</p> <p>AWS Budgets supports the following services as a filter for RI budgets:</p> <ul> <li> <p>Amazon Elastic Compute Cloud - Compute</p> </li> <li> <p>Amazon Redshift</p> </li> <li> <p>Amazon Relational Database Service</p> </li> <li> <p>Amazon ElastiCache</p> </li> <li> <p>Amazon Elasticsearch Service</p> </li> </ul></p>
    #[serde(rename = "CostFilters")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub cost_filters: Option<::std::collections::HashMap<String, Vec<String>>>,
    /// <p>The types of costs that are included in this <code>COST</code> budget.</p> <p> <code>USAGE</code>, <code>RI_UTILIZATION</code>, <code>RI_COVERAGE</code>, <code>SAVINGS_PLANS_UTILIZATION</code>, and <code>SAVINGS_PLANS_COVERAGE</code> budgets do not have <code>CostTypes</code>.</p>
    #[serde(rename = "CostTypes")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub cost_types: Option<CostTypes>,
    /// <p>The last time that you updated this budget.</p>
    #[serde(rename = "LastUpdatedTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_updated_time: Option<f64>,
    /// <p>A map containing multiple <code>BudgetLimit</code>, including current or future limits.</p> <p> <code>PlannedBudgetLimits</code> is available for cost or usage budget and supports monthly and quarterly <code>TimeUnit</code>. </p> <p>For monthly budgets, provide 12 months of <code>PlannedBudgetLimits</code> values. This must start from the current month and include the next 11 months. The <code>key</code> is the start of the month, <code>UTC</code> in epoch seconds. </p> <p>For quarterly budgets, provide 4 quarters of <code>PlannedBudgetLimits</code> value entries in standard calendar quarter increments. This must start from the current quarter and include the next 3 quarters. The <code>key</code> is the start of the quarter, <code>UTC</code> in epoch seconds. </p> <p>If the planned budget expires before 12 months for monthly or 4 quarters for quarterly, provide the <code>PlannedBudgetLimits</code> values only for the remaining periods.</p> <p>If the budget begins at a date in the future, provide <code>PlannedBudgetLimits</code> values from the start date of the budget. </p> <p>After all of the <code>BudgetLimit</code> values in <code>PlannedBudgetLimits</code> are used, the budget continues to use the last limit as the <code>BudgetLimit</code>. At that point, the planned budget provides the same experience as a fixed budget. </p> <p> <code>DescribeBudget</code> and <code>DescribeBudgets</code> response along with <code>PlannedBudgetLimits</code> will also contain <code>BudgetLimit</code> representing the current month or quarter limit present in <code>PlannedBudgetLimits</code>. This only applies to budgets created with <code>PlannedBudgetLimits</code>. Budgets created without <code>PlannedBudgetLimits</code> will only contain <code>BudgetLimit</code>, and no <code>PlannedBudgetLimits</code>.</p>
    #[serde(rename = "PlannedBudgetLimits")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub planned_budget_limits: Option<::std::collections::HashMap<String, Spend>>,
    /// <p>The period of time that is covered by a budget. The period has a start date and an end date. The start date must come before the end date. The end date must come before <code>06/15/87 00:00 UTC</code>. </p> <p>If you create your budget and don't specify a start date, AWS defaults to the start of your chosen time period (DAILY, MONTHLY, QUARTERLY, or ANNUALLY). For example, if you created your budget on January 24, 2018, chose <code>DAILY</code>, and didn't set a start date, AWS set your start date to <code>01/24/18 00:00 UTC</code>. If you chose <code>MONTHLY</code>, AWS set your start date to <code>01/01/18 00:00 UTC</code>. If you didn't specify an end date, AWS set your end date to <code>06/15/87 00:00 UTC</code>. The defaults are the same for the AWS Billing and Cost Management console and the API. </p> <p>You can change either date with the <code>UpdateBudget</code> operation.</p> <p>After the end date, AWS deletes the budget and all associated notifications and subscribers.</p>
    #[serde(rename = "TimePeriod")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub time_period: Option<TimePeriod>,
    /// <p>The length of time until a budget resets the actual and forecasted spend.</p>
    #[serde(rename = "TimeUnit")]
    pub time_unit: String,
}

/// <p>A history of the state of a budget at the end of the budget's specified time period.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct BudgetPerformanceHistory {
    #[serde(rename = "BudgetName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub budget_name: Option<String>,
    #[serde(rename = "BudgetType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub budget_type: Option<String>,
    /// <p>A list of amounts of cost or usage that you created budgets for, compared to your actual costs or usage.</p>
    #[serde(rename = "BudgetedAndActualAmountsList")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub budgeted_and_actual_amounts_list: Option<Vec<BudgetedAndActualAmounts>>,
    /// <p>The history of the cost filters for a budget during the specified time period.</p>
    #[serde(rename = "CostFilters")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub cost_filters: Option<::std::collections::HashMap<String, Vec<String>>>,
    /// <p>The history of the cost types for a budget during the specified time period.</p>
    #[serde(rename = "CostTypes")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub cost_types: Option<CostTypes>,
    #[serde(rename = "TimeUnit")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub time_unit: Option<String>,
}

/// <p>The amount of cost or usage that you created the budget for, compared to your actual costs or usage.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct BudgetedAndActualAmounts {
    /// <p>Your actual costs or usage for a budget period.</p>
    #[serde(rename = "ActualAmount")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub actual_amount: Option<Spend>,
    /// <p>The amount of cost or usage that you created the budget for.</p>
    #[serde(rename = "BudgetedAmount")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub budgeted_amount: Option<Spend>,
    /// <p>The time period covered by this budget comparison.</p>
    #[serde(rename = "TimePeriod")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub time_period: Option<TimePeriod>,
}

/// <p>The spend objects that are associated with this budget. The <code>actualSpend</code> tracks how much you've used, cost, usage, RI units, or Savings Plans units and the <code>forecastedSpend</code> tracks how much you are predicted to spend based on your historical usage profile.</p> <p>For example, if it is the 20th of the month and you have spent <code>50</code> dollars on Amazon EC2, your <code>actualSpend</code> is <code>50 USD</code>, and your <code>forecastedSpend</code> is <code>75 USD</code>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct CalculatedSpend {
    /// <p>The amount of cost, usage, RI units, or Savings Plans units that you have used.</p>
    #[serde(rename = "ActualSpend")]
    pub actual_spend: Spend,
    /// <p>The amount of cost, usage, RI units, or Savings Plans units that you are forecasted to use.</p>
    #[serde(rename = "ForecastedSpend")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub forecasted_spend: Option<Spend>,
}

/// <p>The types of cost that are included in a <code>COST</code> budget, such as tax and subscriptions.</p> <p> <code>USAGE</code>, <code>RI_UTILIZATION</code>, <code>RI_COVERAGE</code>, <code>SAVINGS_PLANS_UTILIZATION</code>, and <code>SAVINGS_PLANS_COVERAGE</code> budgets do not have <code>CostTypes</code>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct CostTypes {
    /// <p>Specifies whether a budget includes credits.</p> <p>The default value is <code>true</code>.</p>
    #[serde(rename = "IncludeCredit")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub include_credit: Option<bool>,
    /// <p>Specifies whether a budget includes discounts.</p> <p>The default value is <code>true</code>.</p>
    #[serde(rename = "IncludeDiscount")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub include_discount: Option<bool>,
    /// <p>Specifies whether a budget includes non-RI subscription costs.</p> <p>The default value is <code>true</code>.</p>
    #[serde(rename = "IncludeOtherSubscription")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub include_other_subscription: Option<bool>,
    /// <p>Specifies whether a budget includes recurring fees such as monthly RI fees.</p> <p>The default value is <code>true</code>.</p>
    #[serde(rename = "IncludeRecurring")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub include_recurring: Option<bool>,
    /// <p>Specifies whether a budget includes refunds.</p> <p>The default value is <code>true</code>.</p>
    #[serde(rename = "IncludeRefund")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub include_refund: Option<bool>,
    /// <p>Specifies whether a budget includes subscriptions.</p> <p>The default value is <code>true</code>.</p>
    #[serde(rename = "IncludeSubscription")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub include_subscription: Option<bool>,
    /// <p>Specifies whether a budget includes support subscription fees.</p> <p>The default value is <code>true</code>.</p>
    #[serde(rename = "IncludeSupport")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub include_support: Option<bool>,
    /// <p>Specifies whether a budget includes taxes.</p> <p>The default value is <code>true</code>.</p>
    #[serde(rename = "IncludeTax")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub include_tax: Option<bool>,
    /// <p>Specifies whether a budget includes upfront RI costs.</p> <p>The default value is <code>true</code>.</p>
    #[serde(rename = "IncludeUpfront")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub include_upfront: Option<bool>,
    /// <p>Specifies whether a budget uses the amortized rate.</p> <p>The default value is <code>false</code>.</p>
    #[serde(rename = "UseAmortized")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub use_amortized: Option<bool>,
    /// <p>Specifies whether a budget uses a blended rate.</p> <p>The default value is <code>false</code>.</p>
    #[serde(rename = "UseBlended")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub use_blended: Option<bool>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateBudgetActionRequest {
    #[serde(rename = "AccountId")]
    pub account_id: String,
    #[serde(rename = "ActionThreshold")]
    pub action_threshold: ActionThreshold,
    /// <p> The type of action. This defines the type of tasks that can be carried out by this action. This field also determines the format for definition. </p>
    #[serde(rename = "ActionType")]
    pub action_type: String,
    /// <p> This specifies if the action needs manual or automatic approval. </p>
    #[serde(rename = "ApprovalModel")]
    pub approval_model: String,
    #[serde(rename = "BudgetName")]
    pub budget_name: String,
    #[serde(rename = "Definition")]
    pub definition: Definition,
    /// <p> The role passed for action execution and reversion. Roles and actions must be in the same account. </p>
    #[serde(rename = "ExecutionRoleArn")]
    pub execution_role_arn: String,
    #[serde(rename = "NotificationType")]
    pub notification_type: String,
    #[serde(rename = "Subscribers")]
    pub subscribers: Vec<Subscriber>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateBudgetActionResponse {
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p> A system-generated universally unique identifier (UUID) for the action. </p>
    #[serde(rename = "ActionId")]
    pub action_id: String,
    #[serde(rename = "BudgetName")]
    pub budget_name: String,
}

/// <p> Request of CreateBudget </p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateBudgetRequest {
    /// <p>The <code>accountId</code> that is associated with the budget.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>The budget object that you want to create.</p>
    #[serde(rename = "Budget")]
    pub budget: Budget,
    /// <p>A notification that you want to associate with a budget. A budget can have up to five notifications, and each notification can have one SNS subscriber and up to 10 email subscribers. If you include notifications and subscribers in your <code>CreateBudget</code> call, AWS creates the notifications and subscribers for you.</p>
    #[serde(rename = "NotificationsWithSubscribers")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub notifications_with_subscribers: Option<Vec<NotificationWithSubscribers>>,
}

/// <p> Response of CreateBudget </p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateBudgetResponse {}

/// <p> Request of CreateNotification </p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateNotificationRequest {
    /// <p>The <code>accountId</code> that is associated with the budget that you want to create a notification for.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>The name of the budget that you want AWS to notify you about. Budget names must be unique within an account.</p>
    #[serde(rename = "BudgetName")]
    pub budget_name: String,
    /// <p>The notification that you want to create.</p>
    #[serde(rename = "Notification")]
    pub notification: Notification,
    /// <p>A list of subscribers that you want to associate with the notification. Each notification can have one SNS subscriber and up to 10 email subscribers.</p>
    #[serde(rename = "Subscribers")]
    pub subscribers: Vec<Subscriber>,
}

/// <p> Response of CreateNotification </p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateNotificationResponse {}

/// <p> Request of CreateSubscriber </p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateSubscriberRequest {
    /// <p>The <code>accountId</code> that is associated with the budget that you want to create a subscriber for.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>The name of the budget that you want to subscribe to. Budget names must be unique within an account.</p>
    #[serde(rename = "BudgetName")]
    pub budget_name: String,
    /// <p>The notification that you want to create a subscriber for.</p>
    #[serde(rename = "Notification")]
    pub notification: Notification,
    /// <p>The subscriber that you want to associate with a budget notification.</p>
    #[serde(rename = "Subscriber")]
    pub subscriber: Subscriber,
}

/// <p> Response of CreateSubscriber </p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateSubscriberResponse {}

/// <p> Specifies all of the type-specific parameters. </p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct Definition {
    /// <p> The AWS Identity and Access Management (IAM) action definition details. </p>
    #[serde(rename = "IamActionDefinition")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub iam_action_definition: Option<IamActionDefinition>,
    /// <p> The service control policies (SCPs) action definition details. </p>
    #[serde(rename = "ScpActionDefinition")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub scp_action_definition: Option<ScpActionDefinition>,
    /// <p> The AWS Systems Manager (SSM) action definition details. </p>
    #[serde(rename = "SsmActionDefinition")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub ssm_action_definition: Option<SsmActionDefinition>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteBudgetActionRequest {
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p> A system-generated universally unique identifier (UUID) for the action. </p>
    #[serde(rename = "ActionId")]
    pub action_id: String,
    #[serde(rename = "BudgetName")]
    pub budget_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DeleteBudgetActionResponse {
    #[serde(rename = "AccountId")]
    pub account_id: String,
    #[serde(rename = "Action")]
    pub action: Action,
    #[serde(rename = "BudgetName")]
    pub budget_name: String,
}

/// <p> Request of DeleteBudget </p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteBudgetRequest {
    /// <p>The <code>accountId</code> that is associated with the budget that you want to delete.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>The name of the budget that you want to delete.</p>
    #[serde(rename = "BudgetName")]
    pub budget_name: String,
}

/// <p> Response of DeleteBudget </p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DeleteBudgetResponse {}

/// <p> Request of DeleteNotification </p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteNotificationRequest {
    /// <p>The <code>accountId</code> that is associated with the budget whose notification you want to delete.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>The name of the budget whose notification you want to delete.</p>
    #[serde(rename = "BudgetName")]
    pub budget_name: String,
    /// <p>The notification that you want to delete.</p>
    #[serde(rename = "Notification")]
    pub notification: Notification,
}

/// <p> Response of DeleteNotification </p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DeleteNotificationResponse {}

/// <p> Request of DeleteSubscriber </p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteSubscriberRequest {
    /// <p>The <code>accountId</code> that is associated with the budget whose subscriber you want to delete.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>The name of the budget whose subscriber you want to delete.</p>
    #[serde(rename = "BudgetName")]
    pub budget_name: String,
    /// <p>The notification whose subscriber you want to delete.</p>
    #[serde(rename = "Notification")]
    pub notification: Notification,
    /// <p>The subscriber that you want to delete.</p>
    #[serde(rename = "Subscriber")]
    pub subscriber: Subscriber,
}

/// <p> Response of DeleteSubscriber </p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DeleteSubscriberResponse {}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeBudgetActionHistoriesRequest {
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p> A system-generated universally unique identifier (UUID) for the action. </p>
    #[serde(rename = "ActionId")]
    pub action_id: String,
    #[serde(rename = "BudgetName")]
    pub budget_name: String,
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    #[serde(rename = "TimePeriod")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub time_period: Option<TimePeriod>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeBudgetActionHistoriesResponse {
    /// <p> The historical record of the budget action resource. </p>
    #[serde(rename = "ActionHistories")]
    pub action_histories: Vec<ActionHistory>,
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeBudgetActionRequest {
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p> A system-generated universally unique identifier (UUID) for the action. </p>
    #[serde(rename = "ActionId")]
    pub action_id: String,
    #[serde(rename = "BudgetName")]
    pub budget_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeBudgetActionResponse {
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p> A budget action resource. </p>
    #[serde(rename = "Action")]
    pub action: Action,
    #[serde(rename = "BudgetName")]
    pub budget_name: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeBudgetActionsForAccountRequest {
    #[serde(rename = "AccountId")]
    pub account_id: String,
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeBudgetActionsForAccountResponse {
    /// <p> A list of the budget action resources information. </p>
    #[serde(rename = "Actions")]
    pub actions: Vec<Action>,
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeBudgetActionsForBudgetRequest {
    #[serde(rename = "AccountId")]
    pub account_id: String,
    #[serde(rename = "BudgetName")]
    pub budget_name: String,
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeBudgetActionsForBudgetResponse {
    /// <p> A list of the budget action resources information. </p>
    #[serde(rename = "Actions")]
    pub actions: Vec<Action>,
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeBudgetPerformanceHistoryRequest {
    #[serde(rename = "AccountId")]
    pub account_id: String,
    #[serde(rename = "BudgetName")]
    pub budget_name: String,
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>Retrieves how often the budget went into an <code>ALARM</code> state for the specified time period.</p>
    #[serde(rename = "TimePeriod")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub time_period: Option<TimePeriod>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeBudgetPerformanceHistoryResponse {
    /// <p>The history of how often the budget has gone into an <code>ALARM</code> state.</p> <p>For <code>DAILY</code> budgets, the history saves the state of the budget for the last 60 days. For <code>MONTHLY</code> budgets, the history saves the state of the budget for the current month plus the last 12 months. For <code>QUARTERLY</code> budgets, the history saves the state of the budget for the last four quarters.</p>
    #[serde(rename = "BudgetPerformanceHistory")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub budget_performance_history: Option<BudgetPerformanceHistory>,
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

/// <p> Request of DescribeBudget </p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeBudgetRequest {
    /// <p>The <code>accountId</code> that is associated with the budget that you want a description of.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>The name of the budget that you want a description of.</p>
    #[serde(rename = "BudgetName")]
    pub budget_name: String,
}

/// <p> Response of DescribeBudget </p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeBudgetResponse {
    /// <p>The description of the budget.</p>
    #[serde(rename = "Budget")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub budget: Option<Budget>,
}

/// <p> Request of DescribeBudgets </p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeBudgetsRequest {
    /// <p>The <code>accountId</code> that is associated with the budgets that you want descriptions of.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>An optional integer that represents how many entries a paginated response contains. The maximum is 100.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>The pagination token that you include in your request to indicate the next set of results that you want to retrieve.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

/// <p> Response of DescribeBudgets </p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeBudgetsResponse {
    /// <p>A list of budgets.</p>
    #[serde(rename = "Budgets")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub budgets: Option<Vec<Budget>>,
    /// <p>The pagination token in the service response that indicates the next set of results that you can retrieve.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

/// <p> Request of DescribeNotificationsForBudget </p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeNotificationsForBudgetRequest {
    /// <p>The <code>accountId</code> that is associated with the budget whose notifications you want descriptions of.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>The name of the budget whose notifications you want descriptions of.</p>
    #[serde(rename = "BudgetName")]
    pub budget_name: String,
    /// <p>An optional integer that represents how many entries a paginated response contains. The maximum is 100.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>The pagination token that you include in your request to indicate the next set of results that you want to retrieve.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

/// <p> Response of GetNotificationsForBudget </p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeNotificationsForBudgetResponse {
    /// <p>The pagination token in the service response that indicates the next set of results that you can retrieve.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>A list of notifications that are associated with a budget.</p>
    #[serde(rename = "Notifications")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub notifications: Option<Vec<Notification>>,
}

/// <p> Request of DescribeSubscribersForNotification </p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeSubscribersForNotificationRequest {
    /// <p>The <code>accountId</code> that is associated with the budget whose subscribers you want descriptions of.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>The name of the budget whose subscribers you want descriptions of.</p>
    #[serde(rename = "BudgetName")]
    pub budget_name: String,
    /// <p>An optional integer that represents how many entries a paginated response contains. The maximum is 100.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>The pagination token that you include in your request to indicate the next set of results that you want to retrieve.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The notification whose subscribers you want to list.</p>
    #[serde(rename = "Notification")]
    pub notification: Notification,
}

/// <p> Response of DescribeSubscribersForNotification </p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeSubscribersForNotificationResponse {
    /// <p>The pagination token in the service response that indicates the next set of results that you can retrieve.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>A list of subscribers that are associated with a notification.</p>
    #[serde(rename = "Subscribers")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub subscribers: Option<Vec<Subscriber>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ExecuteBudgetActionRequest {
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p> A system-generated universally unique identifier (UUID) for the action. </p>
    #[serde(rename = "ActionId")]
    pub action_id: String,
    #[serde(rename = "BudgetName")]
    pub budget_name: String,
    /// <p> The type of execution. </p>
    #[serde(rename = "ExecutionType")]
    pub execution_type: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ExecuteBudgetActionResponse {
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p> A system-generated universally unique identifier (UUID) for the action. </p>
    #[serde(rename = "ActionId")]
    pub action_id: String,
    #[serde(rename = "BudgetName")]
    pub budget_name: String,
    /// <p> The type of execution. </p>
    #[serde(rename = "ExecutionType")]
    pub execution_type: String,
}

/// <p> The AWS Identity and Access Management (IAM) action definition details. </p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct IamActionDefinition {
    /// <p> A list of groups to be attached. There must be at least one group. </p>
    #[serde(rename = "Groups")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub groups: Option<Vec<String>>,
    /// <p> The Amazon Resource Name (ARN) of the policy to be attached. </p>
    #[serde(rename = "PolicyArn")]
    pub policy_arn: String,
    /// <p> A list of roles to be attached. There must be at least one role. </p>
    #[serde(rename = "Roles")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub roles: Option<Vec<String>>,
    /// <p> A list of users to be attached. There must be at least one user. </p>
    #[serde(rename = "Users")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub users: Option<Vec<String>>,
}

/// <p><p>A notification that is associated with a budget. A budget can have up to ten notifications. </p> <p>Each notification must have at least one subscriber. A notification can have one SNS subscriber and up to 10 email subscribers, for a total of 11 subscribers.</p> <p>For example, if you have a budget for 200 dollars and you want to be notified when you go over 160 dollars, create a notification with the following parameters:</p> <ul> <li> <p>A notificationType of <code>ACTUAL</code> </p> </li> <li> <p>A <code>thresholdType</code> of <code>PERCENTAGE</code> </p> </li> <li> <p>A <code>comparisonOperator</code> of <code>GREATER_THAN</code> </p> </li> <li> <p>A notification <code>threshold</code> of <code>80</code> </p> </li> </ul></p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct Notification {
    /// <p>The comparison that is used for this notification.</p>
    #[serde(rename = "ComparisonOperator")]
    pub comparison_operator: String,
    /// <p>Whether this notification is in alarm. If a budget notification is in the <code>ALARM</code> state, you have passed the set threshold for the budget.</p>
    #[serde(rename = "NotificationState")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub notification_state: Option<String>,
    /// <p>Whether the notification is for how much you have spent (<code>ACTUAL</code>) or for how much you're forecasted to spend (<code>FORECASTED</code>).</p>
    #[serde(rename = "NotificationType")]
    pub notification_type: String,
    /// <p>The threshold that is associated with a notification. Thresholds are always a percentage, and many customers find value being alerted between 50% - 200% of the budgeted amount. The maximum limit for your threshold is 1,000,000% above the budgeted amount.</p>
    #[serde(rename = "Threshold")]
    pub threshold: f64,
    /// <p>The type of threshold for a notification. For <code>ABSOLUTE_VALUE</code> thresholds, AWS notifies you when you go over or are forecasted to go over your total cost threshold. For <code>PERCENTAGE</code> thresholds, AWS notifies you when you go over or are forecasted to go over a certain percentage of your forecasted spend. For example, if you have a budget for 200 dollars and you have a <code>PERCENTAGE</code> threshold of 80%, AWS notifies you when you go over 160 dollars.</p>
    #[serde(rename = "ThresholdType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub threshold_type: Option<String>,
}

/// <p>A notification with subscribers. A notification can have one SNS subscriber and up to 10 email subscribers, for a total of 11 subscribers.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct NotificationWithSubscribers {
    /// <p>The notification that is associated with a budget.</p>
    #[serde(rename = "Notification")]
    pub notification: Notification,
    /// <p>A list of subscribers who are subscribed to this notification.</p>
    #[serde(rename = "Subscribers")]
    pub subscribers: Vec<Subscriber>,
}

/// <p> The service control policies (SCP) action definition details. </p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ScpActionDefinition {
    /// <p> The policy ID attached. </p>
    #[serde(rename = "PolicyId")]
    pub policy_id: String,
    /// <p> A list of target IDs. </p>
    #[serde(rename = "TargetIds")]
    pub target_ids: Vec<String>,
}

/// <p><p>The amount of cost or usage that is measured for a budget.</p> <p>For example, a <code>Spend</code> for <code>3 GB</code> of S3 usage would have the following parameters:</p> <ul> <li> <p>An <code>Amount</code> of <code>3</code> </p> </li> <li> <p>A <code>unit</code> of <code>GB</code> </p> </li> </ul></p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct Spend {
    /// <p>The cost or usage amount that is associated with a budget forecast, actual spend, or budget threshold.</p>
    #[serde(rename = "Amount")]
    pub amount: String,
    /// <p>The unit of measurement that is used for the budget forecast, actual spend, or budget threshold, such as dollars or GB.</p>
    #[serde(rename = "Unit")]
    pub unit: String,
}

/// <p> The AWS Systems Manager (SSM) action definition details. </p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct SsmActionDefinition {
    /// <p> The action subType. </p>
    #[serde(rename = "ActionSubType")]
    pub action_sub_type: String,
    /// <p> The EC2 and RDS instance IDs. </p>
    #[serde(rename = "InstanceIds")]
    pub instance_ids: Vec<String>,
    /// <p> The Region to run the SSM document. </p>
    #[serde(rename = "Region")]
    pub region: String,
}

/// <p><p>The subscriber to a budget notification. The subscriber consists of a subscription type and either an Amazon SNS topic or an email address.</p> <p>For example, an email subscriber would have the following parameters:</p> <ul> <li> <p>A <code>subscriptionType</code> of <code>EMAIL</code> </p> </li> <li> <p>An <code>address</code> of <code>example@example.com</code> </p> </li> </ul></p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct Subscriber {
    /// <p>The address that AWS sends budget notifications to, either an SNS topic or an email.</p> <p>When you create a subscriber, the value of <code>Address</code> can't contain line breaks.</p>
    #[serde(rename = "Address")]
    pub address: String,
    /// <p>The type of notification that AWS sends to a subscriber.</p>
    #[serde(rename = "SubscriptionType")]
    pub subscription_type: String,
}

/// <p>The period of time that is covered by a budget. The period has a start date and an end date. The start date must come before the end date. There are no restrictions on the end date. </p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct TimePeriod {
    /// <p>The end date for a budget. If you didn't specify an end date, AWS set your end date to <code>06/15/87 00:00 UTC</code>. The defaults are the same for the AWS Billing and Cost Management console and the API.</p> <p>After the end date, AWS deletes the budget and all associated notifications and subscribers. You can change your end date with the <code>UpdateBudget</code> operation.</p>
    #[serde(rename = "End")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub end: Option<f64>,
    /// <p>The start date for a budget. If you created your budget and didn't specify a start date, AWS defaults to the start of your chosen time period (DAILY, MONTHLY, QUARTERLY, or ANNUALLY). For example, if you created your budget on January 24, 2018, chose <code>DAILY</code>, and didn't set a start date, AWS set your start date to <code>01/24/18 00:00 UTC</code>. If you chose <code>MONTHLY</code>, AWS set your start date to <code>01/01/18 00:00 UTC</code>. The defaults are the same for the AWS Billing and Cost Management console and the API.</p> <p>You can change your start date with the <code>UpdateBudget</code> operation.</p>
    #[serde(rename = "Start")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub start: Option<f64>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateBudgetActionRequest {
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p> A system-generated universally unique identifier (UUID) for the action. </p>
    #[serde(rename = "ActionId")]
    pub action_id: String,
    #[serde(rename = "ActionThreshold")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub action_threshold: Option<ActionThreshold>,
    /// <p> This specifies if the action needs manual or automatic approval. </p>
    #[serde(rename = "ApprovalModel")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub approval_model: Option<String>,
    #[serde(rename = "BudgetName")]
    pub budget_name: String,
    #[serde(rename = "Definition")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub definition: Option<Definition>,
    /// <p> The role passed for action execution and reversion. Roles and actions must be in the same account. </p>
    #[serde(rename = "ExecutionRoleArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub execution_role_arn: Option<String>,
    #[serde(rename = "NotificationType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub notification_type: Option<String>,
    #[serde(rename = "Subscribers")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub subscribers: Option<Vec<Subscriber>>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateBudgetActionResponse {
    #[serde(rename = "AccountId")]
    pub account_id: String,
    #[serde(rename = "BudgetName")]
    pub budget_name: String,
    /// <p> The updated action resource information. </p>
    #[serde(rename = "NewAction")]
    pub new_action: Action,
    /// <p> The previous action resource information. </p>
    #[serde(rename = "OldAction")]
    pub old_action: Action,
}

/// <p> Request of UpdateBudget </p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateBudgetRequest {
    /// <p>The <code>accountId</code> that is associated with the budget that you want to update.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>The budget that you want to update your budget to.</p>
    #[serde(rename = "NewBudget")]
    pub new_budget: Budget,
}

/// <p> Response of UpdateBudget </p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateBudgetResponse {}

/// <p> Request of UpdateNotification </p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateNotificationRequest {
    /// <p>The <code>accountId</code> that is associated with the budget whose notification you want to update.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>The name of the budget whose notification you want to update.</p>
    #[serde(rename = "BudgetName")]
    pub budget_name: String,
    /// <p>The updated notification to be associated with a budget.</p>
    #[serde(rename = "NewNotification")]
    pub new_notification: Notification,
    /// <p>The previous notification that is associated with a budget.</p>
    #[serde(rename = "OldNotification")]
    pub old_notification: Notification,
}

/// <p> Response of UpdateNotification </p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateNotificationResponse {}

/// <p> Request of UpdateSubscriber </p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateSubscriberRequest {
    /// <p>The <code>accountId</code> that is associated with the budget whose subscriber you want to update.</p>
    #[serde(rename = "AccountId")]
    pub account_id: String,
    /// <p>The name of the budget whose subscriber you want to update.</p>
    #[serde(rename = "BudgetName")]
    pub budget_name: String,
    /// <p>The updated subscriber that is associated with a budget notification.</p>
    #[serde(rename = "NewSubscriber")]
    pub new_subscriber: Subscriber,
    /// <p>The notification whose subscriber you want to update.</p>
    #[serde(rename = "Notification")]
    pub notification: Notification,
    /// <p>The previous subscriber that is associated with a budget notification.</p>
    #[serde(rename = "OldSubscriber")]
    pub old_subscriber: Subscriber,
}

/// <p> Response of UpdateSubscriber </p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateSubscriberResponse {}

/// Errors returned by CreateBudget
#[derive(Debug, PartialEq)]
pub enum CreateBudgetError {
    /// <p>You are not authorized to use this operation with the given parameters.</p>
    AccessDenied(String),
    /// <p>You've exceeded the notification or subscriber limit.</p>
    CreationLimitExceeded(String),
    /// <p>The budget name already exists. Budget names must be unique within an account.</p>
    DuplicateRecord(String),
    /// <p>An error on the server occurred during the processing of your request. Try again later.</p>
    InternalError(String),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidParameter(String),
}

impl CreateBudgetError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateBudgetError> {
        if let Some(err) = proto::json::Error::parse(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(CreateBudgetError::AccessDenied(err.msg))
                }
                "CreationLimitExceededException" => {
                    return RusotoError::Service(CreateBudgetError::CreationLimitExceeded(err.msg))
                }
                "DuplicateRecordException" => {
                    return RusotoError::Service(CreateBudgetError::DuplicateRecord(err.msg))
                }
                "InternalErrorException" => {
                    return RusotoError::Service(CreateBudgetError::InternalError(err.msg))
                }
                "InvalidParameterException" => {
                    return RusotoError::Service(CreateBudgetError::InvalidParameter(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateBudgetError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateBudgetError::AccessDenied(ref cause) => write!(f, "{}", cause),
            CreateBudgetError::CreationLimitExceeded(ref cause) => write!(f, "{}", cause),
            CreateBudgetError::DuplicateRecord(ref cause) => write!(f, "{}", cause),
            CreateBudgetError::InternalError(ref cause) => write!(f, "{}", cause),
            CreateBudgetError::InvalidParameter(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateBudgetError {}
/// Errors returned by CreateBudgetAction
#[derive(Debug, PartialEq)]
pub enum CreateBudgetActionError {
    /// <p>You are not authorized to use this operation with the given parameters.</p>
    AccessDenied(String),
    /// <p>You've exceeded the notification or subscriber limit.</p>
    CreationLimitExceeded(String),
    /// <p>The budget name already exists. Budget names must be unique within an account.</p>
    DuplicateRecord(String),
    /// <p>An error on the server occurred during the processing of your request. Try again later.</p>
    InternalError(String),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidParameter(String),
    /// <p>We can’t locate the resource that you specified.</p>
    NotFound(String),
}

impl CreateBudgetActionError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateBudgetActionError> {
        if let Some(err) = proto::json::Error::parse(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(CreateBudgetActionError::AccessDenied(err.msg))
                }
                "CreationLimitExceededException" => {
                    return RusotoError::Service(CreateBudgetActionError::CreationLimitExceeded(
                        err.msg,
                    ))
                }
                "DuplicateRecordException" => {
                    return RusotoError::Service(CreateBudgetActionError::DuplicateRecord(err.msg))
                }
                "InternalErrorException" => {
                    return RusotoError::Service(CreateBudgetActionError::InternalError(err.msg))
                }
                "InvalidParameterException" => {
                    return RusotoError::Service(CreateBudgetActionError::InvalidParameter(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(CreateBudgetActionError::NotFound(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateBudgetActionError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateBudgetActionError::AccessDenied(ref cause) => write!(f, "{}", cause),
            CreateBudgetActionError::CreationLimitExceeded(ref cause) => write!(f, "{}", cause),
            CreateBudgetActionError::DuplicateRecord(ref cause) => write!(f, "{}", cause),
            CreateBudgetActionError::InternalError(ref cause) => write!(f, "{}", cause),
            CreateBudgetActionError::InvalidParameter(ref cause) => write!(f, "{}", cause),
            CreateBudgetActionError::NotFound(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateBudgetActionError {}
/// Errors returned by CreateNotification
#[derive(Debug, PartialEq)]
pub enum CreateNotificationError {
    /// <p>You are not authorized to use this operation with the given parameters.</p>
    AccessDenied(String),
    /// <p>You've exceeded the notification or subscriber limit.</p>
    CreationLimitExceeded(String),
    /// <p>The budget name already exists. Budget names must be unique within an account.</p>
    DuplicateRecord(String),
    /// <p>An error on the server occurred during the processing of your request. Try again later.</p>
    InternalError(String),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidParameter(String),
    /// <p>We can’t locate the resource that you specified.</p>
    NotFound(String),
}

impl CreateNotificationError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateNotificationError> {
        if let Some(err) = proto::json::Error::parse(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(CreateNotificationError::AccessDenied(err.msg))
                }
                "CreationLimitExceededException" => {
                    return RusotoError::Service(CreateNotificationError::CreationLimitExceeded(
                        err.msg,
                    ))
                }
                "DuplicateRecordException" => {
                    return RusotoError::Service(CreateNotificationError::DuplicateRecord(err.msg))
                }
                "InternalErrorException" => {
                    return RusotoError::Service(CreateNotificationError::InternalError(err.msg))
                }
                "InvalidParameterException" => {
                    return RusotoError::Service(CreateNotificationError::InvalidParameter(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(CreateNotificationError::NotFound(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateNotificationError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateNotificationError::AccessDenied(ref cause) => write!(f, "{}", cause),
            CreateNotificationError::CreationLimitExceeded(ref cause) => write!(f, "{}", cause),
            CreateNotificationError::DuplicateRecord(ref cause) => write!(f, "{}", cause),
            CreateNotificationError::InternalError(ref cause) => write!(f, "{}", cause),
            CreateNotificationError::InvalidParameter(ref cause) => write!(f, "{}", cause),
            CreateNotificationError::NotFound(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateNotificationError {}
/// Errors returned by CreateSubscriber
#[derive(Debug, PartialEq)]
pub enum CreateSubscriberError {
    /// <p>You are not authorized to use this operation with the given parameters.</p>
    AccessDenied(String),
    /// <p>You've exceeded the notification or subscriber limit.</p>
    CreationLimitExceeded(String),
    /// <p>The budget name already exists. Budget names must be unique within an account.</p>
    DuplicateRecord(String),
    /// <p>An error on the server occurred during the processing of your request. Try again later.</p>
    InternalError(String),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidParameter(String),
    /// <p>We can’t locate the resource that you specified.</p>
    NotFound(String),
}

impl CreateSubscriberError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateSubscriberError> {
        if let Some(err) = proto::json::Error::parse(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(CreateSubscriberError::AccessDenied(err.msg))
                }
                "CreationLimitExceededException" => {
                    return RusotoError::Service(CreateSubscriberError::CreationLimitExceeded(
                        err.msg,
                    ))
                }
                "DuplicateRecordException" => {
                    return RusotoError::Service(CreateSubscriberError::DuplicateRecord(err.msg))
                }
                "InternalErrorException" => {
                    return RusotoError::Service(CreateSubscriberError::InternalError(err.msg))
                }
                "InvalidParameterException" => {
                    return RusotoError::Service(CreateSubscriberError::InvalidParameter(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(CreateSubscriberError::NotFound(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateSubscriberError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateSubscriberError::AccessDenied(ref cause) => write!(f, "{}", cause),
            CreateSubscriberError::CreationLimitExceeded(ref cause) => write!(f, "{}", cause),
            CreateSubscriberError::DuplicateRecord(ref cause) => write!(f, "{}", cause),
            CreateSubscriberError::InternalError(ref cause) => write!(f, "{}", cause),
            CreateSubscriberError::InvalidParameter(ref cause) => write!(f, "{}", cause),
            CreateSubscriberError::NotFound(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateSubscriberError {}
/// Errors returned by DeleteBudget
#[derive(Debug, PartialEq)]
pub enum DeleteBudgetError {
    /// <p>You are not authorized to use this operation with the given parameters.</p>
    AccessDenied(String),
    /// <p>An error on the server occurred during the processing of your request. Try again later.</p>
    InternalError(String),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidParameter(String),
    /// <p>We can’t locate the resource that you specified.</p>
    NotFound(String),
}

impl DeleteBudgetError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteBudgetError> {
        if let Some(err) = proto::json::Error::parse(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(DeleteBudgetError::AccessDenied(err.msg))
                }
                "InternalErrorException" => {
                    return RusotoError::Service(DeleteBudgetError::InternalError(err.msg))
                }
                "InvalidParameterException" => {
                    return RusotoError::Service(DeleteBudgetError::InvalidParameter(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(DeleteBudgetError::NotFound(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteBudgetError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteBudgetError::AccessDenied(ref cause) => write!(f, "{}", cause),
            DeleteBudgetError::InternalError(ref cause) => write!(f, "{}", cause),
            DeleteBudgetError::InvalidParameter(ref cause) => write!(f, "{}", cause),
            DeleteBudgetError::NotFound(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteBudgetError {}
/// Errors returned by DeleteBudgetAction
#[derive(Debug, PartialEq)]
pub enum DeleteBudgetActionError {
    /// <p>You are not authorized to use this operation with the given parameters.</p>
    AccessDenied(String),
    /// <p>An error on the server occurred during the processing of your request. Try again later.</p>
    InternalError(String),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidParameter(String),
    /// <p>We can’t locate the resource that you specified.</p>
    NotFound(String),
    /// <p> The request was received and recognized by the server, but the server rejected that particular method for the requested resource. </p>
    ResourceLocked(String),
}

impl DeleteBudgetActionError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteBudgetActionError> {
        if let Some(err) = proto::json::Error::parse(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(DeleteBudgetActionError::AccessDenied(err.msg))
                }
                "InternalErrorException" => {
                    return RusotoError::Service(DeleteBudgetActionError::InternalError(err.msg))
                }
                "InvalidParameterException" => {
                    return RusotoError::Service(DeleteBudgetActionError::InvalidParameter(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(DeleteBudgetActionError::NotFound(err.msg))
                }
                "ResourceLockedException" => {
                    return RusotoError::Service(DeleteBudgetActionError::ResourceLocked(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteBudgetActionError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteBudgetActionError::AccessDenied(ref cause) => write!(f, "{}", cause),
            DeleteBudgetActionError::InternalError(ref cause) => write!(f, "{}", cause),
            DeleteBudgetActionError::InvalidParameter(ref cause) => write!(f, "{}", cause),
            DeleteBudgetActionError::NotFound(ref cause) => write!(f, "{}", cause),
            DeleteBudgetActionError::ResourceLocked(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteBudgetActionError {}
/// Errors returned by DeleteNotification
#[derive(Debug, PartialEq)]
pub enum DeleteNotificationError {
    /// <p>You are not authorized to use this operation with the given parameters.</p>
    AccessDenied(String),
    /// <p>An error on the server occurred during the processing of your request. Try again later.</p>
    InternalError(String),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidParameter(String),
    /// <p>We can’t locate the resource that you specified.</p>
    NotFound(String),
}

impl DeleteNotificationError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteNotificationError> {
        if let Some(err) = proto::json::Error::parse(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(DeleteNotificationError::AccessDenied(err.msg))
                }
                "InternalErrorException" => {
                    return RusotoError::Service(DeleteNotificationError::InternalError(err.msg))
                }
                "InvalidParameterException" => {
                    return RusotoError::Service(DeleteNotificationError::InvalidParameter(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(DeleteNotificationError::NotFound(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteNotificationError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteNotificationError::AccessDenied(ref cause) => write!(f, "{}", cause),
            DeleteNotificationError::InternalError(ref cause) => write!(f, "{}", cause),
            DeleteNotificationError::InvalidParameter(ref cause) => write!(f, "{}", cause),
            DeleteNotificationError::NotFound(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteNotificationError {}
/// Errors returned by DeleteSubscriber
#[derive(Debug, PartialEq)]
pub enum DeleteSubscriberError {
    /// <p>You are not authorized to use this operation with the given parameters.</p>
    AccessDenied(String),
    /// <p>An error on the server occurred during the processing of your request. Try again later.</p>
    InternalError(String),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidParameter(String),
    /// <p>We can’t locate the resource that you specified.</p>
    NotFound(String),
}

impl DeleteSubscriberError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteSubscriberError> {
        if let Some(err) = proto::json::Error::parse(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(DeleteSubscriberError::AccessDenied(err.msg))
                }
                "InternalErrorException" => {
                    return RusotoError::Service(DeleteSubscriberError::InternalError(err.msg))
                }
                "InvalidParameterException" => {
                    return RusotoError::Service(DeleteSubscriberError::InvalidParameter(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(DeleteSubscriberError::NotFound(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteSubscriberError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteSubscriberError::AccessDenied(ref cause) => write!(f, "{}", cause),
            DeleteSubscriberError::InternalError(ref cause) => write!(f, "{}", cause),
            DeleteSubscriberError::InvalidParameter(ref cause) => write!(f, "{}", cause),
            DeleteSubscriberError::NotFound(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteSubscriberError {}
/// Errors returned by DescribeBudget
#[derive(Debug, PartialEq)]
pub enum DescribeBudgetError {
    /// <p>You are not authorized to use this operation with the given parameters.</p>
    AccessDenied(String),
    /// <p>An error on the server occurred during the processing of your request. Try again later.</p>
    InternalError(String),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidParameter(String),
    /// <p>We can’t locate the resource that you specified.</p>
    NotFound(String),
}

impl DescribeBudgetError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DescribeBudgetError> {
        if let Some(err) = proto::json::Error::parse(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(DescribeBudgetError::AccessDenied(err.msg))
                }
                "InternalErrorException" => {
                    return RusotoError::Service(DescribeBudgetError::InternalError(err.msg))
                }
                "InvalidParameterException" => {
                    return RusotoError::Service(DescribeBudgetError::InvalidParameter(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(DescribeBudgetError::NotFound(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DescribeBudgetError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeBudgetError::AccessDenied(ref cause) => write!(f, "{}", cause),
            DescribeBudgetError::InternalError(ref cause) => write!(f, "{}", cause),
            DescribeBudgetError::InvalidParameter(ref cause) => write!(f, "{}", cause),
            DescribeBudgetError::NotFound(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DescribeBudgetError {}
/// Errors returned by DescribeBudgetAction
#[derive(Debug, PartialEq)]
pub enum DescribeBudgetActionError {
    /// <p>You are not authorized to use this operation with the given parameters.</p>
    AccessDenied(String),
    /// <p>An error on the server occurred during the processing of your request. Try again later.</p>
    InternalError(String),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidParameter(String),
    /// <p>We can’t locate the resource that you specified.</p>
    NotFound(String),
}

impl DescribeBudgetActionError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DescribeBudgetActionError> {
        if let Some(err) = proto::json::Error::parse(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(DescribeBudgetActionError::AccessDenied(err.msg))
                }
                "InternalErrorException" => {
                    return RusotoError::Service(DescribeBudgetActionError::InternalError(err.msg))
                }
                "InvalidParameterException" => {
                    return RusotoError::Service(DescribeBudgetActionError::InvalidParameter(
                        err.msg,
                    ))
                }
                "NotFoundException" => {
                    return RusotoError::Service(DescribeBudgetActionError::NotFound(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DescribeBudgetActionError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeBudgetActionError::AccessDenied(ref cause) => write!(f, "{}", cause),
            DescribeBudgetActionError::InternalError(ref cause) => write!(f, "{}", cause),
            DescribeBudgetActionError::InvalidParameter(ref cause) => write!(f, "{}", cause),
            DescribeBudgetActionError::NotFound(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DescribeBudgetActionError {}
/// Errors returned by DescribeBudgetActionHistories
#[derive(Debug, PartialEq)]
pub enum DescribeBudgetActionHistoriesError {
    /// <p>You are not authorized to use this operation with the given parameters.</p>
    AccessDenied(String),
    /// <p>An error on the server occurred during the processing of your request. Try again later.</p>
    InternalError(String),
    /// <p>The pagination token is invalid.</p>
    InvalidNextToken(String),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidParameter(String),
    /// <p>We can’t locate the resource that you specified.</p>
    NotFound(String),
}

impl DescribeBudgetActionHistoriesError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<DescribeBudgetActionHistoriesError> {
        if let Some(err) = proto::json::Error::parse(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(DescribeBudgetActionHistoriesError::AccessDenied(
                        err.msg,
                    ))
                }
                "InternalErrorException" => {
                    return RusotoError::Service(DescribeBudgetActionHistoriesError::InternalError(
                        err.msg,
                    ))
                }
                "InvalidNextTokenException" => {
                    return RusotoError::Service(
                        DescribeBudgetActionHistoriesError::InvalidNextToken(err.msg),
                    )
                }
                "InvalidParameterException" => {
                    return RusotoError::Service(
                        DescribeBudgetActionHistoriesError::InvalidParameter(err.msg),
                    )
                }
                "NotFoundException" => {
                    return RusotoError::Service(DescribeBudgetActionHistoriesError::NotFound(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DescribeBudgetActionHistoriesError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeBudgetActionHistoriesError::AccessDenied(ref cause) => write!(f, "{}", cause),
            DescribeBudgetActionHistoriesError::InternalError(ref cause) => write!(f, "{}", cause),
            DescribeBudgetActionHistoriesError::InvalidNextToken(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeBudgetActionHistoriesError::InvalidParameter(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeBudgetActionHistoriesError::NotFound(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DescribeBudgetActionHistoriesError {}
/// Errors returned by DescribeBudgetActionsForAccount
#[derive(Debug, PartialEq)]
pub enum DescribeBudgetActionsForAccountError {
    /// <p>You are not authorized to use this operation with the given parameters.</p>
    AccessDenied(String),
    /// <p>An error on the server occurred during the processing of your request. Try again later.</p>
    InternalError(String),
    /// <p>The pagination token is invalid.</p>
    InvalidNextToken(String),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidParameter(String),
}

impl DescribeBudgetActionsForAccountError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<DescribeBudgetActionsForAccountError> {
        if let Some(err) = proto::json::Error::parse(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(
                        DescribeBudgetActionsForAccountError::AccessDenied(err.msg),
                    )
                }
                "InternalErrorException" => {
                    return RusotoError::Service(
                        DescribeBudgetActionsForAccountError::InternalError(err.msg),
                    )
                }
                "InvalidNextTokenException" => {
                    return RusotoError::Service(
                        DescribeBudgetActionsForAccountError::InvalidNextToken(err.msg),
                    )
                }
                "InvalidParameterException" => {
                    return RusotoError::Service(
                        DescribeBudgetActionsForAccountError::InvalidParameter(err.msg),
                    )
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DescribeBudgetActionsForAccountError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeBudgetActionsForAccountError::AccessDenied(ref cause) => write!(f, "{}", cause),
            DescribeBudgetActionsForAccountError::InternalError(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeBudgetActionsForAccountError::InvalidNextToken(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeBudgetActionsForAccountError::InvalidParameter(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for DescribeBudgetActionsForAccountError {}
/// Errors returned by DescribeBudgetActionsForBudget
#[derive(Debug, PartialEq)]
pub enum DescribeBudgetActionsForBudgetError {
    /// <p>You are not authorized to use this operation with the given parameters.</p>
    AccessDenied(String),
    /// <p>An error on the server occurred during the processing of your request. Try again later.</p>
    InternalError(String),
    /// <p>The pagination token is invalid.</p>
    InvalidNextToken(String),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidParameter(String),
    /// <p>We can’t locate the resource that you specified.</p>
    NotFound(String),
}

impl DescribeBudgetActionsForBudgetError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<DescribeBudgetActionsForBudgetError> {
        if let Some(err) = proto::json::Error::parse(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(DescribeBudgetActionsForBudgetError::AccessDenied(
                        err.msg,
                    ))
                }
                "InternalErrorException" => {
                    return RusotoError::Service(
                        DescribeBudgetActionsForBudgetError::InternalError(err.msg),
                    )
                }
                "InvalidNextTokenException" => {
                    return RusotoError::Service(
                        DescribeBudgetActionsForBudgetError::InvalidNextToken(err.msg),
                    )
                }
                "InvalidParameterException" => {
                    return RusotoError::Service(
                        DescribeBudgetActionsForBudgetError::InvalidParameter(err.msg),
                    )
                }
                "NotFoundException" => {
                    return RusotoError::Service(DescribeBudgetActionsForBudgetError::NotFound(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DescribeBudgetActionsForBudgetError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeBudgetActionsForBudgetError::AccessDenied(ref cause) => write!(f, "{}", cause),
            DescribeBudgetActionsForBudgetError::InternalError(ref cause) => write!(f, "{}", cause),
            DescribeBudgetActionsForBudgetError::InvalidNextToken(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeBudgetActionsForBudgetError::InvalidParameter(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeBudgetActionsForBudgetError::NotFound(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DescribeBudgetActionsForBudgetError {}
/// Errors returned by DescribeBudgetPerformanceHistory
#[derive(Debug, PartialEq)]
pub enum DescribeBudgetPerformanceHistoryError {
    /// <p>You are not authorized to use this operation with the given parameters.</p>
    AccessDenied(String),
    /// <p>The pagination token expired.</p>
    ExpiredNextToken(String),
    /// <p>An error on the server occurred during the processing of your request. Try again later.</p>
    InternalError(String),
    /// <p>The pagination token is invalid.</p>
    InvalidNextToken(String),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidParameter(String),
    /// <p>We can’t locate the resource that you specified.</p>
    NotFound(String),
}

impl DescribeBudgetPerformanceHistoryError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<DescribeBudgetPerformanceHistoryError> {
        if let Some(err) = proto::json::Error::parse(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(
                        DescribeBudgetPerformanceHistoryError::AccessDenied(err.msg),
                    )
                }
                "ExpiredNextTokenException" => {
                    return RusotoError::Service(
                        DescribeBudgetPerformanceHistoryError::ExpiredNextToken(err.msg),
                    )
                }
                "InternalErrorException" => {
                    return RusotoError::Service(
                        DescribeBudgetPerformanceHistoryError::InternalError(err.msg),
                    )
                }
                "InvalidNextTokenException" => {
                    return RusotoError::Service(
                        DescribeBudgetPerformanceHistoryError::InvalidNextToken(err.msg),
                    )
                }
                "InvalidParameterException" => {
                    return RusotoError::Service(
                        DescribeBudgetPerformanceHistoryError::InvalidParameter(err.msg),
                    )
                }
                "NotFoundException" => {
                    return RusotoError::Service(DescribeBudgetPerformanceHistoryError::NotFound(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DescribeBudgetPerformanceHistoryError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeBudgetPerformanceHistoryError::AccessDenied(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeBudgetPerformanceHistoryError::ExpiredNextToken(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeBudgetPerformanceHistoryError::InternalError(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeBudgetPerformanceHistoryError::InvalidNextToken(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeBudgetPerformanceHistoryError::InvalidParameter(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeBudgetPerformanceHistoryError::NotFound(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DescribeBudgetPerformanceHistoryError {}
/// Errors returned by DescribeBudgets
#[derive(Debug, PartialEq)]
pub enum DescribeBudgetsError {
    /// <p>You are not authorized to use this operation with the given parameters.</p>
    AccessDenied(String),
    /// <p>The pagination token expired.</p>
    ExpiredNextToken(String),
    /// <p>An error on the server occurred during the processing of your request. Try again later.</p>
    InternalError(String),
    /// <p>The pagination token is invalid.</p>
    InvalidNextToken(String),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidParameter(String),
    /// <p>We can’t locate the resource that you specified.</p>
    NotFound(String),
}

impl DescribeBudgetsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DescribeBudgetsError> {
        if let Some(err) = proto::json::Error::parse(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(DescribeBudgetsError::AccessDenied(err.msg))
                }
                "ExpiredNextTokenException" => {
                    return RusotoError::Service(DescribeBudgetsError::ExpiredNextToken(err.msg))
                }
                "InternalErrorException" => {
                    return RusotoError::Service(DescribeBudgetsError::InternalError(err.msg))
                }
                "InvalidNextTokenException" => {
                    return RusotoError::Service(DescribeBudgetsError::InvalidNextToken(err.msg))
                }
                "InvalidParameterException" => {
                    return RusotoError::Service(DescribeBudgetsError::InvalidParameter(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(DescribeBudgetsError::NotFound(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DescribeBudgetsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeBudgetsError::AccessDenied(ref cause) => write!(f, "{}", cause),
            DescribeBudgetsError::ExpiredNextToken(ref cause) => write!(f, "{}", cause),
            DescribeBudgetsError::InternalError(ref cause) => write!(f, "{}", cause),
            DescribeBudgetsError::InvalidNextToken(ref cause) => write!(f, "{}", cause),
            DescribeBudgetsError::InvalidParameter(ref cause) => write!(f, "{}", cause),
            DescribeBudgetsError::NotFound(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DescribeBudgetsError {}
/// Errors returned by DescribeNotificationsForBudget
#[derive(Debug, PartialEq)]
pub enum DescribeNotificationsForBudgetError {
    /// <p>You are not authorized to use this operation with the given parameters.</p>
    AccessDenied(String),
    /// <p>The pagination token expired.</p>
    ExpiredNextToken(String),
    /// <p>An error on the server occurred during the processing of your request. Try again later.</p>
    InternalError(String),
    /// <p>The pagination token is invalid.</p>
    InvalidNextToken(String),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidParameter(String),
    /// <p>We can’t locate the resource that you specified.</p>
    NotFound(String),
}

impl DescribeNotificationsForBudgetError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<DescribeNotificationsForBudgetError> {
        if let Some(err) = proto::json::Error::parse(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(DescribeNotificationsForBudgetError::AccessDenied(
                        err.msg,
                    ))
                }
                "ExpiredNextTokenException" => {
                    return RusotoError::Service(
                        DescribeNotificationsForBudgetError::ExpiredNextToken(err.msg),
                    )
                }
                "InternalErrorException" => {
                    return RusotoError::Service(
                        DescribeNotificationsForBudgetError::InternalError(err.msg),
                    )
                }
                "InvalidNextTokenException" => {
                    return RusotoError::Service(
                        DescribeNotificationsForBudgetError::InvalidNextToken(err.msg),
                    )
                }
                "InvalidParameterException" => {
                    return RusotoError::Service(
                        DescribeNotificationsForBudgetError::InvalidParameter(err.msg),
                    )
                }
                "NotFoundException" => {
                    return RusotoError::Service(DescribeNotificationsForBudgetError::NotFound(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DescribeNotificationsForBudgetError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeNotificationsForBudgetError::AccessDenied(ref cause) => write!(f, "{}", cause),
            DescribeNotificationsForBudgetError::ExpiredNextToken(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeNotificationsForBudgetError::InternalError(ref cause) => write!(f, "{}", cause),
            DescribeNotificationsForBudgetError::InvalidNextToken(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeNotificationsForBudgetError::InvalidParameter(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeNotificationsForBudgetError::NotFound(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DescribeNotificationsForBudgetError {}
/// Errors returned by DescribeSubscribersForNotification
#[derive(Debug, PartialEq)]
pub enum DescribeSubscribersForNotificationError {
    /// <p>You are not authorized to use this operation with the given parameters.</p>
    AccessDenied(String),
    /// <p>The pagination token expired.</p>
    ExpiredNextToken(String),
    /// <p>An error on the server occurred during the processing of your request. Try again later.</p>
    InternalError(String),
    /// <p>The pagination token is invalid.</p>
    InvalidNextToken(String),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidParameter(String),
    /// <p>We can’t locate the resource that you specified.</p>
    NotFound(String),
}

impl DescribeSubscribersForNotificationError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<DescribeSubscribersForNotificationError> {
        if let Some(err) = proto::json::Error::parse(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(
                        DescribeSubscribersForNotificationError::AccessDenied(err.msg),
                    )
                }
                "ExpiredNextTokenException" => {
                    return RusotoError::Service(
                        DescribeSubscribersForNotificationError::ExpiredNextToken(err.msg),
                    )
                }
                "InternalErrorException" => {
                    return RusotoError::Service(
                        DescribeSubscribersForNotificationError::InternalError(err.msg),
                    )
                }
                "InvalidNextTokenException" => {
                    return RusotoError::Service(
                        DescribeSubscribersForNotificationError::InvalidNextToken(err.msg),
                    )
                }
                "InvalidParameterException" => {
                    return RusotoError::Service(
                        DescribeSubscribersForNotificationError::InvalidParameter(err.msg),
                    )
                }
                "NotFoundException" => {
                    return RusotoError::Service(DescribeSubscribersForNotificationError::NotFound(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DescribeSubscribersForNotificationError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeSubscribersForNotificationError::AccessDenied(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeSubscribersForNotificationError::ExpiredNextToken(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeSubscribersForNotificationError::InternalError(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeSubscribersForNotificationError::InvalidNextToken(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeSubscribersForNotificationError::InvalidParameter(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeSubscribersForNotificationError::NotFound(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DescribeSubscribersForNotificationError {}
/// Errors returned by ExecuteBudgetAction
#[derive(Debug, PartialEq)]
pub enum ExecuteBudgetActionError {
    /// <p>You are not authorized to use this operation with the given parameters.</p>
    AccessDenied(String),
    /// <p>An error on the server occurred during the processing of your request. Try again later.</p>
    InternalError(String),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidParameter(String),
    /// <p>We can’t locate the resource that you specified.</p>
    NotFound(String),
    /// <p> The request was received and recognized by the server, but the server rejected that particular method for the requested resource. </p>
    ResourceLocked(String),
}

impl ExecuteBudgetActionError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ExecuteBudgetActionError> {
        if let Some(err) = proto::json::Error::parse(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(ExecuteBudgetActionError::AccessDenied(err.msg))
                }
                "InternalErrorException" => {
                    return RusotoError::Service(ExecuteBudgetActionError::InternalError(err.msg))
                }
                "InvalidParameterException" => {
                    return RusotoError::Service(ExecuteBudgetActionError::InvalidParameter(
                        err.msg,
                    ))
                }
                "NotFoundException" => {
                    return RusotoError::Service(ExecuteBudgetActionError::NotFound(err.msg))
                }
                "ResourceLockedException" => {
                    return RusotoError::Service(ExecuteBudgetActionError::ResourceLocked(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ExecuteBudgetActionError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ExecuteBudgetActionError::AccessDenied(ref cause) => write!(f, "{}", cause),
            ExecuteBudgetActionError::InternalError(ref cause) => write!(f, "{}", cause),
            ExecuteBudgetActionError::InvalidParameter(ref cause) => write!(f, "{}", cause),
            ExecuteBudgetActionError::NotFound(ref cause) => write!(f, "{}", cause),
            ExecuteBudgetActionError::ResourceLocked(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ExecuteBudgetActionError {}
/// Errors returned by UpdateBudget
#[derive(Debug, PartialEq)]
pub enum UpdateBudgetError {
    /// <p>You are not authorized to use this operation with the given parameters.</p>
    AccessDenied(String),
    /// <p>An error on the server occurred during the processing of your request. Try again later.</p>
    InternalError(String),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidParameter(String),
    /// <p>We can’t locate the resource that you specified.</p>
    NotFound(String),
}

impl UpdateBudgetError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<UpdateBudgetError> {
        if let Some(err) = proto::json::Error::parse(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(UpdateBudgetError::AccessDenied(err.msg))
                }
                "InternalErrorException" => {
                    return RusotoError::Service(UpdateBudgetError::InternalError(err.msg))
                }
                "InvalidParameterException" => {
                    return RusotoError::Service(UpdateBudgetError::InvalidParameter(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(UpdateBudgetError::NotFound(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for UpdateBudgetError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            UpdateBudgetError::AccessDenied(ref cause) => write!(f, "{}", cause),
            UpdateBudgetError::InternalError(ref cause) => write!(f, "{}", cause),
            UpdateBudgetError::InvalidParameter(ref cause) => write!(f, "{}", cause),
            UpdateBudgetError::NotFound(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for UpdateBudgetError {}
/// Errors returned by UpdateBudgetAction
#[derive(Debug, PartialEq)]
pub enum UpdateBudgetActionError {
    /// <p>You are not authorized to use this operation with the given parameters.</p>
    AccessDenied(String),
    /// <p>An error on the server occurred during the processing of your request. Try again later.</p>
    InternalError(String),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidParameter(String),
    /// <p>We can’t locate the resource that you specified.</p>
    NotFound(String),
    /// <p> The request was received and recognized by the server, but the server rejected that particular method for the requested resource. </p>
    ResourceLocked(String),
}

impl UpdateBudgetActionError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<UpdateBudgetActionError> {
        if let Some(err) = proto::json::Error::parse(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(UpdateBudgetActionError::AccessDenied(err.msg))
                }
                "InternalErrorException" => {
                    return RusotoError::Service(UpdateBudgetActionError::InternalError(err.msg))
                }
                "InvalidParameterException" => {
                    return RusotoError::Service(UpdateBudgetActionError::InvalidParameter(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(UpdateBudgetActionError::NotFound(err.msg))
                }
                "ResourceLockedException" => {
                    return RusotoError::Service(UpdateBudgetActionError::ResourceLocked(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for UpdateBudgetActionError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            UpdateBudgetActionError::AccessDenied(ref cause) => write!(f, "{}", cause),
            UpdateBudgetActionError::InternalError(ref cause) => write!(f, "{}", cause),
            UpdateBudgetActionError::InvalidParameter(ref cause) => write!(f, "{}", cause),
            UpdateBudgetActionError::NotFound(ref cause) => write!(f, "{}", cause),
            UpdateBudgetActionError::ResourceLocked(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for UpdateBudgetActionError {}
/// Errors returned by UpdateNotification
#[derive(Debug, PartialEq)]
pub enum UpdateNotificationError {
    /// <p>You are not authorized to use this operation with the given parameters.</p>
    AccessDenied(String),
    /// <p>The budget name already exists. Budget names must be unique within an account.</p>
    DuplicateRecord(String),
    /// <p>An error on the server occurred during the processing of your request. Try again later.</p>
    InternalError(String),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidParameter(String),
    /// <p>We can’t locate the resource that you specified.</p>
    NotFound(String),
}

impl UpdateNotificationError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<UpdateNotificationError> {
        if let Some(err) = proto::json::Error::parse(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(UpdateNotificationError::AccessDenied(err.msg))
                }
                "DuplicateRecordException" => {
                    return RusotoError::Service(UpdateNotificationError::DuplicateRecord(err.msg))
                }
                "InternalErrorException" => {
                    return RusotoError::Service(UpdateNotificationError::InternalError(err.msg))
                }
                "InvalidParameterException" => {
                    return RusotoError::Service(UpdateNotificationError::InvalidParameter(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(UpdateNotificationError::NotFound(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for UpdateNotificationError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            UpdateNotificationError::AccessDenied(ref cause) => write!(f, "{}", cause),
            UpdateNotificationError::DuplicateRecord(ref cause) => write!(f, "{}", cause),
            UpdateNotificationError::InternalError(ref cause) => write!(f, "{}", cause),
            UpdateNotificationError::InvalidParameter(ref cause) => write!(f, "{}", cause),
            UpdateNotificationError::NotFound(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for UpdateNotificationError {}
/// Errors returned by UpdateSubscriber
#[derive(Debug, PartialEq)]
pub enum UpdateSubscriberError {
    /// <p>You are not authorized to use this operation with the given parameters.</p>
    AccessDenied(String),
    /// <p>The budget name already exists. Budget names must be unique within an account.</p>
    DuplicateRecord(String),
    /// <p>An error on the server occurred during the processing of your request. Try again later.</p>
    InternalError(String),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidParameter(String),
    /// <p>We can’t locate the resource that you specified.</p>
    NotFound(String),
}

impl UpdateSubscriberError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<UpdateSubscriberError> {
        if let Some(err) = proto::json::Error::parse(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(UpdateSubscriberError::AccessDenied(err.msg))
                }
                "DuplicateRecordException" => {
                    return RusotoError::Service(UpdateSubscriberError::DuplicateRecord(err.msg))
                }
                "InternalErrorException" => {
                    return RusotoError::Service(UpdateSubscriberError::InternalError(err.msg))
                }
                "InvalidParameterException" => {
                    return RusotoError::Service(UpdateSubscriberError::InvalidParameter(err.msg))
                }
                "NotFoundException" => {
                    return RusotoError::Service(UpdateSubscriberError::NotFound(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for UpdateSubscriberError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            UpdateSubscriberError::AccessDenied(ref cause) => write!(f, "{}", cause),
            UpdateSubscriberError::DuplicateRecord(ref cause) => write!(f, "{}", cause),
            UpdateSubscriberError::InternalError(ref cause) => write!(f, "{}", cause),
            UpdateSubscriberError::InvalidParameter(ref cause) => write!(f, "{}", cause),
            UpdateSubscriberError::NotFound(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for UpdateSubscriberError {}
/// Trait representing the capabilities of the AWSBudgets API. AWSBudgets clients implement this trait.
#[async_trait]
pub trait Budgets {
    /// <p><p>Creates a budget and, if included, notifications and subscribers. </p> <important> <p>Only one of <code>BudgetLimit</code> or <code>PlannedBudgetLimits</code> can be present in the syntax at one time. Use the syntax that matches your case. The Request Syntax section shows the <code>BudgetLimit</code> syntax. For <code>PlannedBudgetLimits</code>, see the <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_CreateBudget.html#API_CreateBudget_Examples">Examples</a> section. </p> </important></p>
    async fn create_budget(
        &self,
        input: CreateBudgetRequest,
    ) -> Result<CreateBudgetResponse, RusotoError<CreateBudgetError>>;

    /// <p> Creates a budget action. </p>
    async fn create_budget_action(
        &self,
        input: CreateBudgetActionRequest,
    ) -> Result<CreateBudgetActionResponse, RusotoError<CreateBudgetActionError>>;

    /// <p>Creates a notification. You must create the budget before you create the associated notification.</p>
    async fn create_notification(
        &self,
        input: CreateNotificationRequest,
    ) -> Result<CreateNotificationResponse, RusotoError<CreateNotificationError>>;

    /// <p>Creates a subscriber. You must create the associated budget and notification before you create the subscriber.</p>
    async fn create_subscriber(
        &self,
        input: CreateSubscriberRequest,
    ) -> Result<CreateSubscriberResponse, RusotoError<CreateSubscriberError>>;

    /// <p><p>Deletes a budget. You can delete your budget at any time.</p> <important> <p>Deleting a budget also deletes the notifications and subscribers that are associated with that budget.</p> </important></p>
    async fn delete_budget(
        &self,
        input: DeleteBudgetRequest,
    ) -> Result<DeleteBudgetResponse, RusotoError<DeleteBudgetError>>;

    /// <p> Deletes a budget action. </p>
    async fn delete_budget_action(
        &self,
        input: DeleteBudgetActionRequest,
    ) -> Result<DeleteBudgetActionResponse, RusotoError<DeleteBudgetActionError>>;

    /// <p><p>Deletes a notification.</p> <important> <p>Deleting a notification also deletes the subscribers that are associated with the notification.</p> </important></p>
    async fn delete_notification(
        &self,
        input: DeleteNotificationRequest,
    ) -> Result<DeleteNotificationResponse, RusotoError<DeleteNotificationError>>;

    /// <p><p>Deletes a subscriber.</p> <important> <p>Deleting the last subscriber to a notification also deletes the notification.</p> </important></p>
    async fn delete_subscriber(
        &self,
        input: DeleteSubscriberRequest,
    ) -> Result<DeleteSubscriberResponse, RusotoError<DeleteSubscriberError>>;

    /// <p><p>Describes a budget.</p> <important> <p>The Request Syntax section shows the <code>BudgetLimit</code> syntax. For <code>PlannedBudgetLimits</code>, see the <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_DescribeBudget.html#API_DescribeBudget_Examples">Examples</a> section. </p> </important></p>
    async fn describe_budget(
        &self,
        input: DescribeBudgetRequest,
    ) -> Result<DescribeBudgetResponse, RusotoError<DescribeBudgetError>>;

    /// <p> Describes a budget action detail. </p>
    async fn describe_budget_action(
        &self,
        input: DescribeBudgetActionRequest,
    ) -> Result<DescribeBudgetActionResponse, RusotoError<DescribeBudgetActionError>>;

    /// <p> Describes a budget action history detail. </p>
    async fn describe_budget_action_histories(
        &self,
        input: DescribeBudgetActionHistoriesRequest,
    ) -> Result<
        DescribeBudgetActionHistoriesResponse,
        RusotoError<DescribeBudgetActionHistoriesError>,
    >;

    /// <p> Describes all of the budget actions for an account. </p>
    async fn describe_budget_actions_for_account(
        &self,
        input: DescribeBudgetActionsForAccountRequest,
    ) -> Result<
        DescribeBudgetActionsForAccountResponse,
        RusotoError<DescribeBudgetActionsForAccountError>,
    >;

    /// <p> Describes all of the budget actions for a budget. </p>
    async fn describe_budget_actions_for_budget(
        &self,
        input: DescribeBudgetActionsForBudgetRequest,
    ) -> Result<
        DescribeBudgetActionsForBudgetResponse,
        RusotoError<DescribeBudgetActionsForBudgetError>,
    >;

    /// <p>Describes the history for <code>DAILY</code>, <code>MONTHLY</code>, and <code>QUARTERLY</code> budgets. Budget history isn't available for <code>ANNUAL</code> budgets.</p>
    async fn describe_budget_performance_history(
        &self,
        input: DescribeBudgetPerformanceHistoryRequest,
    ) -> Result<
        DescribeBudgetPerformanceHistoryResponse,
        RusotoError<DescribeBudgetPerformanceHistoryError>,
    >;

    /// <p><p>Lists the budgets that are associated with an account.</p> <important> <p>The Request Syntax section shows the <code>BudgetLimit</code> syntax. For <code>PlannedBudgetLimits</code>, see the <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_DescribeBudgets.html#API_DescribeBudgets_Examples">Examples</a> section. </p> </important></p>
    async fn describe_budgets(
        &self,
        input: DescribeBudgetsRequest,
    ) -> Result<DescribeBudgetsResponse, RusotoError<DescribeBudgetsError>>;

    /// <p>Lists the notifications that are associated with a budget.</p>
    async fn describe_notifications_for_budget(
        &self,
        input: DescribeNotificationsForBudgetRequest,
    ) -> Result<
        DescribeNotificationsForBudgetResponse,
        RusotoError<DescribeNotificationsForBudgetError>,
    >;

    /// <p>Lists the subscribers that are associated with a notification.</p>
    async fn describe_subscribers_for_notification(
        &self,
        input: DescribeSubscribersForNotificationRequest,
    ) -> Result<
        DescribeSubscribersForNotificationResponse,
        RusotoError<DescribeSubscribersForNotificationError>,
    >;

    /// <p> Executes a budget action. </p>
    async fn execute_budget_action(
        &self,
        input: ExecuteBudgetActionRequest,
    ) -> Result<ExecuteBudgetActionResponse, RusotoError<ExecuteBudgetActionError>>;

    /// <p><p>Updates a budget. You can change every part of a budget except for the <code>budgetName</code> and the <code>calculatedSpend</code>. When you modify a budget, the <code>calculatedSpend</code> drops to zero until AWS has new usage data to use for forecasting.</p> <important> <p>Only one of <code>BudgetLimit</code> or <code>PlannedBudgetLimits</code> can be present in the syntax at one time. Use the syntax that matches your case. The Request Syntax section shows the <code>BudgetLimit</code> syntax. For <code>PlannedBudgetLimits</code>, see the <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_UpdateBudget.html#API_UpdateBudget_Examples">Examples</a> section. </p> </important></p>
    async fn update_budget(
        &self,
        input: UpdateBudgetRequest,
    ) -> Result<UpdateBudgetResponse, RusotoError<UpdateBudgetError>>;

    /// <p> Updates a budget action. </p>
    async fn update_budget_action(
        &self,
        input: UpdateBudgetActionRequest,
    ) -> Result<UpdateBudgetActionResponse, RusotoError<UpdateBudgetActionError>>;

    /// <p>Updates a notification.</p>
    async fn update_notification(
        &self,
        input: UpdateNotificationRequest,
    ) -> Result<UpdateNotificationResponse, RusotoError<UpdateNotificationError>>;

    /// <p>Updates a subscriber.</p>
    async fn update_subscriber(
        &self,
        input: UpdateSubscriberRequest,
    ) -> Result<UpdateSubscriberResponse, RusotoError<UpdateSubscriberError>>;
}
/// A client for the AWSBudgets API.
#[derive(Clone)]
pub struct BudgetsClient {
    client: Client,
    region: region::Region,
}

impl BudgetsClient {
    /// Creates a client backed by the default tokio event loop.
    ///
    /// The client will use the default credentials provider and tls client.
    pub fn new(region: region::Region) -> BudgetsClient {
        BudgetsClient {
            client: Client::shared(),
            region,
        }
    }

    pub fn new_with<P, D>(
        request_dispatcher: D,
        credentials_provider: P,
        region: region::Region,
    ) -> BudgetsClient
    where
        P: ProvideAwsCredentials + Send + Sync + 'static,
        D: DispatchSignedRequest + Send + Sync + 'static,
    {
        BudgetsClient {
            client: Client::new_with(credentials_provider, request_dispatcher),
            region,
        }
    }

    pub fn new_with_client(client: Client, region: region::Region) -> BudgetsClient {
        BudgetsClient { client, region }
    }
}

#[async_trait]
impl Budgets for BudgetsClient {
    /// <p><p>Creates a budget and, if included, notifications and subscribers. </p> <important> <p>Only one of <code>BudgetLimit</code> or <code>PlannedBudgetLimits</code> can be present in the syntax at one time. Use the syntax that matches your case. The Request Syntax section shows the <code>BudgetLimit</code> syntax. For <code>PlannedBudgetLimits</code>, see the <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_CreateBudget.html#API_CreateBudget_Examples">Examples</a> section. </p> </important></p>
    async fn create_budget(
        &self,
        input: CreateBudgetRequest,
    ) -> Result<CreateBudgetResponse, RusotoError<CreateBudgetError>> {
        let mut request = self.new_signed_request("POST", "/");
        request.add_header("x-amz-target", "AWSBudgetServiceGateway.CreateBudget");
        let encoded = serde_json::to_string(&input).unwrap();
        request.set_payload(Some(encoded));

        let response = self
            .sign_and_dispatch(request, CreateBudgetError::from_response)
            .await?;
        let mut response = response;
        let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
        proto::json::ResponsePayload::new(&response).deserialize::<CreateBudgetResponse, _>()
    }

    /// <p> Creates a budget action. </p>
    async fn create_budget_action(
        &self,
        input: CreateBudgetActionRequest,
    ) -> Result<CreateBudgetActionResponse, RusotoError<CreateBudgetActionError>> {
        let mut request = self.new_signed_request("POST", "/");
        request.add_header("x-amz-target", "AWSBudgetServiceGateway.CreateBudgetAction");
        let encoded = serde_json::to_string(&input).unwrap();
        request.set_payload(Some(encoded));

        let response = self
            .sign_and_dispatch(request, CreateBudgetActionError::from_response)
            .await?;
        let mut response = response;
        let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
        proto::json::ResponsePayload::new(&response).deserialize::<CreateBudgetActionResponse, _>()
    }

    /// <p>Creates a notification. You must create the budget before you create the associated notification.</p>
    async fn create_notification(
        &self,
        input: CreateNotificationRequest,
    ) -> Result<CreateNotificationResponse, RusotoError<CreateNotificationError>> {
        let mut request = self.new_signed_request("POST", "/");
        request.add_header("x-amz-target", "AWSBudgetServiceGateway.CreateNotification");
        let encoded = serde_json::to_string(&input).unwrap();
        request.set_payload(Some(encoded));

        let response = self
            .sign_and_dispatch(request, CreateNotificationError::from_response)
            .await?;
        let mut response = response;
        let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
        proto::json::ResponsePayload::new(&response).deserialize::<CreateNotificationResponse, _>()
    }

    /// <p>Creates a subscriber. You must create the associated budget and notification before you create the subscriber.</p>
    async fn create_subscriber(
        &self,
        input: CreateSubscriberRequest,
    ) -> Result<CreateSubscriberResponse, RusotoError<CreateSubscriberError>> {
        let mut request = self.new_signed_request("POST", "/");
        request.add_header("x-amz-target", "AWSBudgetServiceGateway.CreateSubscriber");
        let encoded = serde_json::to_string(&input).unwrap();
        request.set_payload(Some(encoded));

        let response = self
            .sign_and_dispatch(request, CreateSubscriberError::from_response)
            .await?;
        let mut response = response;
        let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
        proto::json::ResponsePayload::new(&response).deserialize::<CreateSubscriberResponse, _>()
    }

    /// <p><p>Deletes a budget. You can delete your budget at any time.</p> <important> <p>Deleting a budget also deletes the notifications and subscribers that are associated with that budget.</p> </important></p>
    async fn delete_budget(
        &self,
        input: DeleteBudgetRequest,
    ) -> Result<DeleteBudgetResponse, RusotoError<DeleteBudgetError>> {
        let mut request = self.new_signed_request("POST", "/");
        request.add_header("x-amz-target", "AWSBudgetServiceGateway.DeleteBudget");
        let encoded = serde_json::to_string(&input).unwrap();
        request.set_payload(Some(encoded));

        let response = self
            .sign_and_dispatch(request, DeleteBudgetError::from_response)
            .await?;
        let mut response = response;
        let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
        proto::json::ResponsePayload::new(&response).deserialize::<DeleteBudgetResponse, _>()
    }

    /// <p> Deletes a budget action. </p>
    async fn delete_budget_action(
        &self,
        input: DeleteBudgetActionRequest,
    ) -> Result<DeleteBudgetActionResponse, RusotoError<DeleteBudgetActionError>> {
        let mut request = self.new_signed_request("POST", "/");
        request.add_header("x-amz-target", "AWSBudgetServiceGateway.DeleteBudgetAction");
        let encoded = serde_json::to_string(&input).unwrap();
        request.set_payload(Some(encoded));

        let response = self
            .sign_and_dispatch(request, DeleteBudgetActionError::from_response)
            .await?;
        let mut response = response;
        let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
        proto::json::ResponsePayload::new(&response).deserialize::<DeleteBudgetActionResponse, _>()
    }

    /// <p><p>Deletes a notification.</p> <important> <p>Deleting a notification also deletes the subscribers that are associated with the notification.</p> </important></p>
    async fn delete_notification(
        &self,
        input: DeleteNotificationRequest,
    ) -> Result<DeleteNotificationResponse, RusotoError<DeleteNotificationError>> {
        let mut request = self.new_signed_request("POST", "/");
        request.add_header("x-amz-target", "AWSBudgetServiceGateway.DeleteNotification");
        let encoded = serde_json::to_string(&input).unwrap();
        request.set_payload(Some(encoded));

        let response = self
            .sign_and_dispatch(request, DeleteNotificationError::from_response)
            .await?;
        let mut response = response;
        let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
        proto::json::ResponsePayload::new(&response).deserialize::<DeleteNotificationResponse, _>()
    }

    /// <p><p>Deletes a subscriber.</p> <important> <p>Deleting the last subscriber to a notification also deletes the notification.</p> </important></p>
    async fn delete_subscriber(
        &self,
        input: DeleteSubscriberRequest,
    ) -> Result<DeleteSubscriberResponse, RusotoError<DeleteSubscriberError>> {
        let mut request = self.new_signed_request("POST", "/");
        request.add_header("x-amz-target", "AWSBudgetServiceGateway.DeleteSubscriber");
        let encoded = serde_json::to_string(&input).unwrap();
        request.set_payload(Some(encoded));

        let response = self
            .sign_and_dispatch(request, DeleteSubscriberError::from_response)
            .await?;
        let mut response = response;
        let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
        proto::json::ResponsePayload::new(&response).deserialize::<DeleteSubscriberResponse, _>()
    }

    /// <p><p>Describes a budget.</p> <important> <p>The Request Syntax section shows the <code>BudgetLimit</code> syntax. For <code>PlannedBudgetLimits</code>, see the <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_DescribeBudget.html#API_DescribeBudget_Examples">Examples</a> section. </p> </important></p>
    async fn describe_budget(
        &self,
        input: DescribeBudgetRequest,
    ) -> Result<DescribeBudgetResponse, RusotoError<DescribeBudgetError>> {
        let mut request = self.new_signed_request("POST", "/");
        request.add_header("x-amz-target", "AWSBudgetServiceGateway.DescribeBudget");
        let encoded = serde_json::to_string(&input).unwrap();
        request.set_payload(Some(encoded));

        let response = self
            .sign_and_dispatch(request, DescribeBudgetError::from_response)
            .await?;
        let mut response = response;
        let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
        proto::json::ResponsePayload::new(&response).deserialize::<DescribeBudgetResponse, _>()
    }

    /// <p> Describes a budget action detail. </p>
    async fn describe_budget_action(
        &self,
        input: DescribeBudgetActionRequest,
    ) -> Result<DescribeBudgetActionResponse, RusotoError<DescribeBudgetActionError>> {
        let mut request = self.new_signed_request("POST", "/");
        request.add_header(
            "x-amz-target",
            "AWSBudgetServiceGateway.DescribeBudgetAction",
        );
        let encoded = serde_json::to_string(&input).unwrap();
        request.set_payload(Some(encoded));

        let response = self
            .sign_and_dispatch(request, DescribeBudgetActionError::from_response)
            .await?;
        let mut response = response;
        let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
        proto::json::ResponsePayload::new(&response)
            .deserialize::<DescribeBudgetActionResponse, _>()
    }

    /// <p> Describes a budget action history detail. </p>
    async fn describe_budget_action_histories(
        &self,
        input: DescribeBudgetActionHistoriesRequest,
    ) -> Result<
        DescribeBudgetActionHistoriesResponse,
        RusotoError<DescribeBudgetActionHistoriesError>,
    > {
        let mut request = self.new_signed_request("POST", "/");
        request.add_header(
            "x-amz-target",
            "AWSBudgetServiceGateway.DescribeBudgetActionHistories",
        );
        let encoded = serde_json::to_string(&input).unwrap();
        request.set_payload(Some(encoded));

        let response = self
            .sign_and_dispatch(request, DescribeBudgetActionHistoriesError::from_response)
            .await?;
        let mut response = response;
        let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
        proto::json::ResponsePayload::new(&response)
            .deserialize::<DescribeBudgetActionHistoriesResponse, _>()
    }

    /// <p> Describes all of the budget actions for an account. </p>
    async fn describe_budget_actions_for_account(
        &self,
        input: DescribeBudgetActionsForAccountRequest,
    ) -> Result<
        DescribeBudgetActionsForAccountResponse,
        RusotoError<DescribeBudgetActionsForAccountError>,
    > {
        let mut request = self.new_signed_request("POST", "/");
        request.add_header(
            "x-amz-target",
            "AWSBudgetServiceGateway.DescribeBudgetActionsForAccount",
        );
        let encoded = serde_json::to_string(&input).unwrap();
        request.set_payload(Some(encoded));

        let response = self
            .sign_and_dispatch(request, DescribeBudgetActionsForAccountError::from_response)
            .await?;
        let mut response = response;
        let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
        proto::json::ResponsePayload::new(&response)
            .deserialize::<DescribeBudgetActionsForAccountResponse, _>()
    }

    /// <p> Describes all of the budget actions for a budget. </p>
    async fn describe_budget_actions_for_budget(
        &self,
        input: DescribeBudgetActionsForBudgetRequest,
    ) -> Result<
        DescribeBudgetActionsForBudgetResponse,
        RusotoError<DescribeBudgetActionsForBudgetError>,
    > {
        let mut request = self.new_signed_request("POST", "/");
        request.add_header(
            "x-amz-target",
            "AWSBudgetServiceGateway.DescribeBudgetActionsForBudget",
        );
        let encoded = serde_json::to_string(&input).unwrap();
        request.set_payload(Some(encoded));

        let response = self
            .sign_and_dispatch(request, DescribeBudgetActionsForBudgetError::from_response)
            .await?;
        let mut response = response;
        let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
        proto::json::ResponsePayload::new(&response)
            .deserialize::<DescribeBudgetActionsForBudgetResponse, _>()
    }

    /// <p>Describes the history for <code>DAILY</code>, <code>MONTHLY</code>, and <code>QUARTERLY</code> budgets. Budget history isn't available for <code>ANNUAL</code> budgets.</p>
    async fn describe_budget_performance_history(
        &self,
        input: DescribeBudgetPerformanceHistoryRequest,
    ) -> Result<
        DescribeBudgetPerformanceHistoryResponse,
        RusotoError<DescribeBudgetPerformanceHistoryError>,
    > {
        let mut request = self.new_signed_request("POST", "/");
        request.add_header(
            "x-amz-target",
            "AWSBudgetServiceGateway.DescribeBudgetPerformanceHistory",
        );
        let encoded = serde_json::to_string(&input).unwrap();
        request.set_payload(Some(encoded));

        let response = self
            .sign_and_dispatch(
                request,
                DescribeBudgetPerformanceHistoryError::from_response,
            )
            .await?;
        let mut response = response;
        let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
        proto::json::ResponsePayload::new(&response)
            .deserialize::<DescribeBudgetPerformanceHistoryResponse, _>()
    }

    /// <p><p>Lists the budgets that are associated with an account.</p> <important> <p>The Request Syntax section shows the <code>BudgetLimit</code> syntax. For <code>PlannedBudgetLimits</code>, see the <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_DescribeBudgets.html#API_DescribeBudgets_Examples">Examples</a> section. </p> </important></p>
    async fn describe_budgets(
        &self,
        input: DescribeBudgetsRequest,
    ) -> Result<DescribeBudgetsResponse, RusotoError<DescribeBudgetsError>> {
        let mut request = self.new_signed_request("POST", "/");
        request.add_header("x-amz-target", "AWSBudgetServiceGateway.DescribeBudgets");
        let encoded = serde_json::to_string(&input).unwrap();
        request.set_payload(Some(encoded));

        let response = self
            .sign_and_dispatch(request, DescribeBudgetsError::from_response)
            .await?;
        let mut response = response;
        let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
        proto::json::ResponsePayload::new(&response).deserialize::<DescribeBudgetsResponse, _>()
    }

    /// <p>Lists the notifications that are associated with a budget.</p>
    async fn describe_notifications_for_budget(
        &self,
        input: DescribeNotificationsForBudgetRequest,
    ) -> Result<
        DescribeNotificationsForBudgetResponse,
        RusotoError<DescribeNotificationsForBudgetError>,
    > {
        let mut request = self.new_signed_request("POST", "/");
        request.add_header(
            "x-amz-target",
            "AWSBudgetServiceGateway.DescribeNotificationsForBudget",
        );
        let encoded = serde_json::to_string(&input).unwrap();
        request.set_payload(Some(encoded));

        let response = self
            .sign_and_dispatch(request, DescribeNotificationsForBudgetError::from_response)
            .await?;
        let mut response = response;
        let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
        proto::json::ResponsePayload::new(&response)
            .deserialize::<DescribeNotificationsForBudgetResponse, _>()
    }

    /// <p>Lists the subscribers that are associated with a notification.</p>
    async fn describe_subscribers_for_notification(
        &self,
        input: DescribeSubscribersForNotificationRequest,
    ) -> Result<
        DescribeSubscribersForNotificationResponse,
        RusotoError<DescribeSubscribersForNotificationError>,
    > {
        let mut request = self.new_signed_request("POST", "/");
        request.add_header(
            "x-amz-target",
            "AWSBudgetServiceGateway.DescribeSubscribersForNotification",
        );
        let encoded = serde_json::to_string(&input).unwrap();
        request.set_payload(Some(encoded));

        let response = self
            .sign_and_dispatch(
                request,
                DescribeSubscribersForNotificationError::from_response,
            )
            .await?;
        let mut response = response;
        let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
        proto::json::ResponsePayload::new(&response)
            .deserialize::<DescribeSubscribersForNotificationResponse, _>()
    }

    /// <p> Executes a budget action. </p>
    async fn execute_budget_action(
        &self,
        input: ExecuteBudgetActionRequest,
    ) -> Result<ExecuteBudgetActionResponse, RusotoError<ExecuteBudgetActionError>> {
        let mut request = self.new_signed_request("POST", "/");
        request.add_header(
            "x-amz-target",
            "AWSBudgetServiceGateway.ExecuteBudgetAction",
        );
        let encoded = serde_json::to_string(&input).unwrap();
        request.set_payload(Some(encoded));

        let response = self
            .sign_and_dispatch(request, ExecuteBudgetActionError::from_response)
            .await?;
        let mut response = response;
        let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
        proto::json::ResponsePayload::new(&response).deserialize::<ExecuteBudgetActionResponse, _>()
    }

    /// <p><p>Updates a budget. You can change every part of a budget except for the <code>budgetName</code> and the <code>calculatedSpend</code>. When you modify a budget, the <code>calculatedSpend</code> drops to zero until AWS has new usage data to use for forecasting.</p> <important> <p>Only one of <code>BudgetLimit</code> or <code>PlannedBudgetLimits</code> can be present in the syntax at one time. Use the syntax that matches your case. The Request Syntax section shows the <code>BudgetLimit</code> syntax. For <code>PlannedBudgetLimits</code>, see the <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_UpdateBudget.html#API_UpdateBudget_Examples">Examples</a> section. </p> </important></p>
    async fn update_budget(
        &self,
        input: UpdateBudgetRequest,
    ) -> Result<UpdateBudgetResponse, RusotoError<UpdateBudgetError>> {
        let mut request = self.new_signed_request("POST", "/");
        request.add_header("x-amz-target", "AWSBudgetServiceGateway.UpdateBudget");
        let encoded = serde_json::to_string(&input).unwrap();
        request.set_payload(Some(encoded));

        let response = self
            .sign_and_dispatch(request, UpdateBudgetError::from_response)
            .await?;
        let mut response = response;
        let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
        proto::json::ResponsePayload::new(&response).deserialize::<UpdateBudgetResponse, _>()
    }

    /// <p> Updates a budget action. </p>
    async fn update_budget_action(
        &self,
        input: UpdateBudgetActionRequest,
    ) -> Result<UpdateBudgetActionResponse, RusotoError<UpdateBudgetActionError>> {
        let mut request = self.new_signed_request("POST", "/");
        request.add_header("x-amz-target", "AWSBudgetServiceGateway.UpdateBudgetAction");
        let encoded = serde_json::to_string(&input).unwrap();
        request.set_payload(Some(encoded));

        let response = self
            .sign_and_dispatch(request, UpdateBudgetActionError::from_response)
            .await?;
        let mut response = response;
        let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
        proto::json::ResponsePayload::new(&response).deserialize::<UpdateBudgetActionResponse, _>()
    }

    /// <p>Updates a notification.</p>
    async fn update_notification(
        &self,
        input: UpdateNotificationRequest,
    ) -> Result<UpdateNotificationResponse, RusotoError<UpdateNotificationError>> {
        let mut request = self.new_signed_request("POST", "/");
        request.add_header("x-amz-target", "AWSBudgetServiceGateway.UpdateNotification");
        let encoded = serde_json::to_string(&input).unwrap();
        request.set_payload(Some(encoded));

        let response = self
            .sign_and_dispatch(request, UpdateNotificationError::from_response)
            .await?;
        let mut response = response;
        let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
        proto::json::ResponsePayload::new(&response).deserialize::<UpdateNotificationResponse, _>()
    }

    /// <p>Updates a subscriber.</p>
    async fn update_subscriber(
        &self,
        input: UpdateSubscriberRequest,
    ) -> Result<UpdateSubscriberResponse, RusotoError<UpdateSubscriberError>> {
        let mut request = self.new_signed_request("POST", "/");
        request.add_header("x-amz-target", "AWSBudgetServiceGateway.UpdateSubscriber");
        let encoded = serde_json::to_string(&input).unwrap();
        request.set_payload(Some(encoded));

        let response = self
            .sign_and_dispatch(request, UpdateSubscriberError::from_response)
            .await?;
        let mut response = response;
        let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
        proto::json::ResponsePayload::new(&response).deserialize::<UpdateSubscriberResponse, _>()
    }
}
