// =================================================================
//
//                           * WARNING *
//
//                    This file is generated!
//
//  Changes made to this file will be overwritten. If changes are
//  required to the generated code, the service_crategen project
//  must be updated to generate the changes.
//
// =================================================================

use std::error::Error;
use std::fmt;

use async_trait::async_trait;
use rusoto_core::credential::ProvideAwsCredentials;
use rusoto_core::region;
use rusoto_core::request::{BufferedHttpResponse, DispatchSignedRequest};
use rusoto_core::{Client, RusotoError};

use rusoto_core::param::{Params, ServiceParams};
use rusoto_core::proto;
use rusoto_core::signature::SignedRequest;
#[allow(unused_imports)]
use serde::{Deserialize, Serialize};
use serde_json;
/// <p>Contains information about an access preview.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct AccessPreview {
    /// <p>The ARN of the analyzer used to generate the access preview.</p>
    #[serde(rename = "analyzerArn")]
    pub analyzer_arn: String,
    /// <p>A map of resource ARNs for the proposed resource configuration.</p>
    #[serde(rename = "configurations")]
    pub configurations: ::std::collections::HashMap<String, Configuration>,
    /// <p>The time at which the access preview was created.</p>
    #[serde(rename = "createdAt")]
    pub created_at: f64,
    /// <p>The unique ID for the access preview.</p>
    #[serde(rename = "id")]
    pub id: String,
    /// <p><p>The status of the access preview.</p> <ul> <li> <p> <code>Creating</code> - The access preview creation is in progress.</p> </li> <li> <p> <code>Completed</code> - The access preview is complete. You can preview findings for external access to the resource.</p> </li> <li> <p> <code>Failed</code> - The access preview creation has failed.</p> </li> </ul></p>
    #[serde(rename = "status")]
    pub status: String,
    /// <p>Provides more details about the current status of the access preview.</p> <p>For example, if the creation of the access preview fails, a <code>Failed</code> status is returned. This failure can be due to an internal issue with the analysis or due to an invalid resource configuration.</p>
    #[serde(rename = "statusReason")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status_reason: Option<AccessPreviewStatusReason>,
}

/// <p>An access preview finding generated by the access preview.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct AccessPreviewFinding {
    /// <p>The action in the analyzed policy statement that an external principal has permission to perform.</p>
    #[serde(rename = "action")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub action: Option<Vec<String>>,
    /// <p>Provides context on how the access preview finding compares to existing access identified in Access Analyzer.</p> <ul> <li> <p> <code>New</code> - The finding is for newly-introduced access.</p> </li> <li> <p> <code>Unchanged</code> - The preview finding is an existing finding that would remain unchanged.</p> </li> <li> <p> <code>Changed</code> - The preview finding is an existing finding with a change in status.</p> </li> </ul> <p>For example, a <code>Changed</code> finding with preview status <code>Resolved</code> and existing status <code>Active</code> indicates the existing <code>Active</code> finding would become <code>Resolved</code> as a result of the proposed permissions change.</p>
    #[serde(rename = "changeType")]
    pub change_type: String,
    /// <p>The condition in the analyzed policy statement that resulted in a finding.</p>
    #[serde(rename = "condition")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub condition: Option<::std::collections::HashMap<String, String>>,
    /// <p>The time at which the access preview finding was created.</p>
    #[serde(rename = "createdAt")]
    pub created_at: f64,
    /// <p>An error.</p>
    #[serde(rename = "error")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub error: Option<String>,
    /// <p>The existing ID of the finding in Access Analyzer, provided only for existing findings.</p>
    #[serde(rename = "existingFindingId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub existing_finding_id: Option<String>,
    /// <p>The existing status of the finding, provided only for existing findings.</p>
    #[serde(rename = "existingFindingStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub existing_finding_status: Option<String>,
    /// <p>The ID of the access preview finding. This ID uniquely identifies the element in the list of access preview findings and is not related to the finding ID in Access Analyzer.</p>
    #[serde(rename = "id")]
    pub id: String,
    /// <p>Indicates whether the policy that generated the finding allows public access to the resource.</p>
    #[serde(rename = "isPublic")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub is_public: Option<bool>,
    /// <p>The external principal that has access to a resource within the zone of trust.</p>
    #[serde(rename = "principal")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub principal: Option<::std::collections::HashMap<String, String>>,
    /// <p>The resource that an external principal has access to. This is the resource associated with the access preview.</p>
    #[serde(rename = "resource")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub resource: Option<String>,
    /// <p>The AWS account ID that owns the resource. For most AWS resources, the owning account is the account in which the resource was created.</p>
    #[serde(rename = "resourceOwnerAccount")]
    pub resource_owner_account: String,
    /// <p>The type of the resource that can be accessed in the finding.</p>
    #[serde(rename = "resourceType")]
    pub resource_type: String,
    /// <p>The sources of the finding. This indicates how the access that generated the finding is granted. It is populated for Amazon S3 bucket findings.</p>
    #[serde(rename = "sources")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sources: Option<Vec<FindingSource>>,
    /// <p>The preview status of the finding. This is what the status of the finding would be after permissions deployment. For example, a <code>Changed</code> finding with preview status <code>Resolved</code> and existing status <code>Active</code> indicates the existing <code>Active</code> finding would become <code>Resolved</code> as a result of the proposed permissions change.</p>
    #[serde(rename = "status")]
    pub status: String,
}

/// <p>Provides more details about the current status of the access preview. For example, if the creation of the access preview fails, a <code>Failed</code> status is returned. This failure can be due to an internal issue with the analysis or due to an invalid proposed resource configuration.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct AccessPreviewStatusReason {
    /// <p>The reason code for the current status of the access preview.</p>
    #[serde(rename = "code")]
    pub code: String,
}

/// <p>Contains a summary of information about an access preview.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct AccessPreviewSummary {
    /// <p>The ARN of the analyzer used to generate the access preview.</p>
    #[serde(rename = "analyzerArn")]
    pub analyzer_arn: String,
    /// <p>The time at which the access preview was created.</p>
    #[serde(rename = "createdAt")]
    pub created_at: f64,
    /// <p>The unique ID for the access preview.</p>
    #[serde(rename = "id")]
    pub id: String,
    /// <p><p>The status of the access preview.</p> <ul> <li> <p> <code>Creating</code> - The access preview creation is in progress.</p> </li> <li> <p> <code>Completed</code> - The access preview is complete and previews the findings for external access to the resource.</p> </li> <li> <p> <code>Failed</code> - The access preview creation has failed.</p> </li> </ul></p>
    #[serde(rename = "status")]
    pub status: String,
    #[serde(rename = "statusReason")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status_reason: Option<AccessPreviewStatusReason>,
}

/// <p>You specify each grantee as a type-value pair using one of these types. You can specify only one type of grantee. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketAcl.html">PutBucketAcl</a>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct AclGrantee {
    /// <p>The value specified is the canonical user ID of an AWS account.</p>
    #[serde(rename = "id")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    /// <p>Used for granting permissions to a predefined group.</p>
    #[serde(rename = "uri")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub uri: Option<String>,
}

/// <p>Contains details about the analyzed resource.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct AnalyzedResource {
    /// <p>The actions that an external principal is granted permission to use by the policy that generated the finding.</p>
    #[serde(rename = "actions")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub actions: Option<Vec<String>>,
    /// <p>The time at which the resource was analyzed.</p>
    #[serde(rename = "analyzedAt")]
    pub analyzed_at: f64,
    /// <p>The time at which the finding was created.</p>
    #[serde(rename = "createdAt")]
    pub created_at: f64,
    /// <p>An error message.</p>
    #[serde(rename = "error")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub error: Option<String>,
    /// <p>Indicates whether the policy that generated the finding grants public access to the resource.</p>
    #[serde(rename = "isPublic")]
    pub is_public: bool,
    /// <p>The ARN of the resource that was analyzed.</p>
    #[serde(rename = "resourceArn")]
    pub resource_arn: String,
    /// <p>The AWS account ID that owns the resource.</p>
    #[serde(rename = "resourceOwnerAccount")]
    pub resource_owner_account: String,
    /// <p>The type of the resource that was analyzed.</p>
    #[serde(rename = "resourceType")]
    pub resource_type: String,
    /// <p>Indicates how the access that generated the finding is granted. This is populated for Amazon S3 bucket findings.</p>
    #[serde(rename = "sharedVia")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub shared_via: Option<Vec<String>>,
    /// <p>The current status of the finding generated from the analyzed resource.</p>
    #[serde(rename = "status")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    /// <p>The time at which the finding was updated.</p>
    #[serde(rename = "updatedAt")]
    pub updated_at: f64,
}

/// <p>Contains the ARN of the analyzed resource.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct AnalyzedResourceSummary {
    /// <p>The ARN of the analyzed resource.</p>
    #[serde(rename = "resourceArn")]
    pub resource_arn: String,
    /// <p>The AWS account ID that owns the resource.</p>
    #[serde(rename = "resourceOwnerAccount")]
    pub resource_owner_account: String,
    /// <p>The type of resource that was analyzed.</p>
    #[serde(rename = "resourceType")]
    pub resource_type: String,
}

/// <p>Contains information about the analyzer.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct AnalyzerSummary {
    /// <p>The ARN of the analyzer.</p>
    #[serde(rename = "arn")]
    pub arn: String,
    /// <p>A timestamp for the time at which the analyzer was created.</p>
    #[serde(rename = "createdAt")]
    pub created_at: f64,
    /// <p>The resource that was most recently analyzed by the analyzer.</p>
    #[serde(rename = "lastResourceAnalyzed")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_resource_analyzed: Option<String>,
    /// <p>The time at which the most recently analyzed resource was analyzed.</p>
    #[serde(rename = "lastResourceAnalyzedAt")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_resource_analyzed_at: Option<f64>,
    /// <p>The name of the analyzer.</p>
    #[serde(rename = "name")]
    pub name: String,
    /// <p>The status of the analyzer. An <code>Active</code> analyzer successfully monitors supported resources and generates new findings. The analyzer is <code>Disabled</code> when a user action, such as removing trusted access for AWS IAM Access Analyzer from AWS Organizations, causes the analyzer to stop generating new findings. The status is <code>Creating</code> when the analyzer creation is in progress and <code>Failed</code> when the analyzer creation has failed. </p>
    #[serde(rename = "status")]
    pub status: String,
    /// <p>The <code>statusReason</code> provides more details about the current status of the analyzer. For example, if the creation for the analyzer fails, a <code>Failed</code> status is returned. For an analyzer with organization as the type, this failure can be due to an issue with creating the service-linked roles required in the member accounts of the AWS organization.</p>
    #[serde(rename = "statusReason")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status_reason: Option<StatusReason>,
    /// <p>The tags added to the analyzer.</p>
    #[serde(rename = "tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<::std::collections::HashMap<String, String>>,
    /// <p>The type of analyzer, which corresponds to the zone of trust chosen for the analyzer.</p>
    #[serde(rename = "type")]
    pub type_: String,
}

/// <p>Retroactively applies an archive rule.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ApplyArchiveRuleRequest {
    /// <p>The Amazon resource name (ARN) of the analyzer.</p>
    #[serde(rename = "analyzerArn")]
    pub analyzer_arn: String,
    /// <p>A client token.</p>
    #[serde(rename = "clientToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub client_token: Option<String>,
    /// <p>The name of the rule to apply.</p>
    #[serde(rename = "ruleName")]
    pub rule_name: String,
}

/// <p>Contains information about an archive rule.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ArchiveRuleSummary {
    /// <p>The time at which the archive rule was created.</p>
    #[serde(rename = "createdAt")]
    pub created_at: f64,
    /// <p>A filter used to define the archive rule.</p>
    #[serde(rename = "filter")]
    pub filter: ::std::collections::HashMap<String, Criterion>,
    /// <p>The name of the archive rule.</p>
    #[serde(rename = "ruleName")]
    pub rule_name: String,
    /// <p>The time at which the archive rule was last updated.</p>
    #[serde(rename = "updatedAt")]
    pub updated_at: f64,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CancelPolicyGenerationRequest {
    /// <p>The <code>JobId</code> that is returned by the <code>StartPolicyGeneration</code> operation. The <code>JobId</code> can be used with <code>GetGeneratedPolicy</code> to retrieve the generated policies or used with <code>CancelPolicyGeneration</code> to cancel the policy generation request.</p>
    #[serde(rename = "jobId")]
    pub job_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CancelPolicyGenerationResponse {}

/// <p>Contains information about CloudTrail access.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CloudTrailDetails {
    /// <p>The ARN of the service role that Access Analyzer uses to access your CloudTrail trail and service last accessed information.</p>
    #[serde(rename = "accessRole")]
    pub access_role: String,
    /// <p>The end of the time range for which Access Analyzer reviews your CloudTrail events. Events with a timestamp after this time are not considered to generate a policy. If this is not included in the request, the default value is the current time.</p>
    #[serde(rename = "endTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub end_time: Option<f64>,
    /// <p>The start of the time range for which Access Analyzer reviews your CloudTrail events. Events with a timestamp before this time are not considered to generate a policy.</p>
    #[serde(rename = "startTime")]
    pub start_time: f64,
    /// <p>A <code>Trail</code> object that contains settings for a trail.</p>
    #[serde(rename = "trails")]
    pub trails: Vec<Trail>,
}

/// <p>Contains information about CloudTrail access.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CloudTrailProperties {
    /// <p>The end of the time range for which Access Analyzer reviews your CloudTrail events. Events with a timestamp after this time are not considered to generate a policy. If this is not included in the request, the default value is the current time.</p>
    #[serde(rename = "endTime")]
    pub end_time: f64,
    /// <p>The start of the time range for which Access Analyzer reviews your CloudTrail events. Events with a timestamp before this time are not considered to generate a policy.</p>
    #[serde(rename = "startTime")]
    pub start_time: f64,
    /// <p>A <code>TrailProperties</code> object that contains settings for trail properties.</p>
    #[serde(rename = "trailProperties")]
    pub trail_properties: Vec<TrailProperties>,
}

/// <p>Access control configuration structures for your resource. You specify the configuration as a type-value pair. You can specify only one type of access control configuration.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct Configuration {
    /// <p>The access control configuration is for an IAM role. </p>
    #[serde(rename = "iamRole")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub iam_role: Option<IamRoleConfiguration>,
    /// <p>The access control configuration is for a KMS key. </p>
    #[serde(rename = "kmsKey")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub kms_key: Option<KmsKeyConfiguration>,
    /// <p>The access control configuration is for an Amazon S3 Bucket. </p>
    #[serde(rename = "s3Bucket")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub s_3_bucket: Option<S3BucketConfiguration>,
    /// <p>The access control configuration is for a Secrets Manager secret.</p>
    #[serde(rename = "secretsManagerSecret")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub secrets_manager_secret: Option<SecretsManagerSecretConfiguration>,
    /// <p>The access control configuration is for an SQS queue. </p>
    #[serde(rename = "sqsQueue")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sqs_queue: Option<SqsQueueConfiguration>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateAccessPreviewRequest {
    /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the account analyzer</a> used to generate the access preview. You can only create an access preview for analyzers with an <code>Account</code> type and <code>Active</code> status.</p>
    #[serde(rename = "analyzerArn")]
    pub analyzer_arn: String,
    /// <p>A client token.</p>
    #[serde(rename = "clientToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub client_token: Option<String>,
    /// <p>Access control configuration for your resource that is used to generate the access preview. The access preview includes findings for external access allowed to the resource with the proposed access control configuration. The configuration must contain exactly one element.</p>
    #[serde(rename = "configurations")]
    pub configurations: ::std::collections::HashMap<String, Configuration>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateAccessPreviewResponse {
    /// <p>The unique ID for the access preview.</p>
    #[serde(rename = "id")]
    pub id: String,
}

/// <p>Creates an analyzer.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateAnalyzerRequest {
    /// <p>The name of the analyzer to create.</p>
    #[serde(rename = "analyzerName")]
    pub analyzer_name: String,
    /// <p>Specifies the archive rules to add for the analyzer. Archive rules automatically archive findings that meet the criteria you define for the rule.</p>
    #[serde(rename = "archiveRules")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub archive_rules: Option<Vec<InlineArchiveRule>>,
    /// <p>A client token.</p>
    #[serde(rename = "clientToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub client_token: Option<String>,
    /// <p>The tags to apply to the analyzer.</p>
    #[serde(rename = "tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<::std::collections::HashMap<String, String>>,
    /// <p>The type of analyzer to create. Only ACCOUNT and ORGANIZATION analyzers are supported. You can create only one analyzer per account per Region. You can create up to 5 analyzers per organization per Region.</p>
    #[serde(rename = "type")]
    pub type_: String,
}

/// <p>The response to the request to create an analyzer.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateAnalyzerResponse {
    /// <p>The ARN of the analyzer that was created by the request.</p>
    #[serde(rename = "arn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub arn: Option<String>,
}

/// <p>Creates an archive rule.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateArchiveRuleRequest {
    /// <p>The name of the created analyzer.</p>
    #[serde(rename = "analyzerName")]
    pub analyzer_name: String,
    /// <p>A client token.</p>
    #[serde(rename = "clientToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub client_token: Option<String>,
    /// <p>The criteria for the rule.</p>
    #[serde(rename = "filter")]
    pub filter: ::std::collections::HashMap<String, Criterion>,
    /// <p>The name of the rule to create.</p>
    #[serde(rename = "ruleName")]
    pub rule_name: String,
}

/// <p>The criteria to use in the filter that defines the archive rule.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct Criterion {
    /// <p>A "contains" operator to match for the filter used to create the rule.</p>
    #[serde(rename = "contains")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub contains: Option<Vec<String>>,
    /// <p>An "equals" operator to match for the filter used to create the rule.</p>
    #[serde(rename = "eq")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub eq: Option<Vec<String>>,
    /// <p>An "exists" operator to match for the filter used to create the rule. </p>
    #[serde(rename = "exists")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub exists: Option<bool>,
    /// <p>A "not equals" operator to match for the filter used to create the rule.</p>
    #[serde(rename = "neq")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub neq: Option<Vec<String>>,
}

/// <p>Deletes an analyzer.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteAnalyzerRequest {
    /// <p>The name of the analyzer to delete.</p>
    #[serde(rename = "analyzerName")]
    pub analyzer_name: String,
    /// <p>A client token.</p>
    #[serde(rename = "clientToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub client_token: Option<String>,
}

/// <p>Deletes an archive rule.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteArchiveRuleRequest {
    /// <p>The name of the analyzer that associated with the archive rule to delete.</p>
    #[serde(rename = "analyzerName")]
    pub analyzer_name: String,
    /// <p>A client token.</p>
    #[serde(rename = "clientToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub client_token: Option<String>,
    /// <p>The name of the rule to delete.</p>
    #[serde(rename = "ruleName")]
    pub rule_name: String,
}

/// <p>Contains information about a finding.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct Finding {
    /// <p>The action in the analyzed policy statement that an external principal has permission to use.</p>
    #[serde(rename = "action")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub action: Option<Vec<String>>,
    /// <p>The time at which the resource was analyzed.</p>
    #[serde(rename = "analyzedAt")]
    pub analyzed_at: f64,
    /// <p>The condition in the analyzed policy statement that resulted in a finding.</p>
    #[serde(rename = "condition")]
    pub condition: ::std::collections::HashMap<String, String>,
    /// <p>The time at which the finding was generated.</p>
    #[serde(rename = "createdAt")]
    pub created_at: f64,
    /// <p>An error.</p>
    #[serde(rename = "error")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub error: Option<String>,
    /// <p>The ID of the finding.</p>
    #[serde(rename = "id")]
    pub id: String,
    /// <p>Indicates whether the policy that generated the finding allows public access to the resource.</p>
    #[serde(rename = "isPublic")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub is_public: Option<bool>,
    /// <p>The external principal that access to a resource within the zone of trust.</p>
    #[serde(rename = "principal")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub principal: Option<::std::collections::HashMap<String, String>>,
    /// <p>The resource that an external principal has access to.</p>
    #[serde(rename = "resource")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub resource: Option<String>,
    /// <p>The AWS account ID that owns the resource.</p>
    #[serde(rename = "resourceOwnerAccount")]
    pub resource_owner_account: String,
    /// <p>The type of the resource identified in the finding.</p>
    #[serde(rename = "resourceType")]
    pub resource_type: String,
    /// <p>The sources of the finding. This indicates how the access that generated the finding is granted. It is populated for Amazon S3 bucket findings.</p>
    #[serde(rename = "sources")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sources: Option<Vec<FindingSource>>,
    /// <p>The current status of the finding.</p>
    #[serde(rename = "status")]
    pub status: String,
    /// <p>The time at which the finding was updated.</p>
    #[serde(rename = "updatedAt")]
    pub updated_at: f64,
}

/// <p>The source of the finding. This indicates how the access that generated the finding is granted. It is populated for Amazon S3 bucket findings.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct FindingSource {
    /// <p>Includes details about how the access that generated the finding is granted. This is populated for Amazon S3 bucket findings.</p>
    #[serde(rename = "detail")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub detail: Option<FindingSourceDetail>,
    /// <p>Indicates the type of access that generated the finding.</p>
    #[serde(rename = "type")]
    pub type_: String,
}

/// <p>Includes details about how the access that generated the finding is granted. This is populated for Amazon S3 bucket findings.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct FindingSourceDetail {
    /// <p>The ARN of the access point that generated the finding.</p>
    #[serde(rename = "accessPointArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub access_point_arn: Option<String>,
}

/// <p>Contains information about a finding.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct FindingSummary {
    /// <p>The action in the analyzed policy statement that an external principal has permission to use.</p>
    #[serde(rename = "action")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub action: Option<Vec<String>>,
    /// <p>The time at which the resource-based policy that generated the finding was analyzed.</p>
    #[serde(rename = "analyzedAt")]
    pub analyzed_at: f64,
    /// <p>The condition in the analyzed policy statement that resulted in a finding.</p>
    #[serde(rename = "condition")]
    pub condition: ::std::collections::HashMap<String, String>,
    /// <p>The time at which the finding was created.</p>
    #[serde(rename = "createdAt")]
    pub created_at: f64,
    /// <p>The error that resulted in an Error finding.</p>
    #[serde(rename = "error")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub error: Option<String>,
    /// <p>The ID of the finding.</p>
    #[serde(rename = "id")]
    pub id: String,
    /// <p>Indicates whether the finding reports a resource that has a policy that allows public access.</p>
    #[serde(rename = "isPublic")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub is_public: Option<bool>,
    /// <p>The external principal that has access to a resource within the zone of trust.</p>
    #[serde(rename = "principal")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub principal: Option<::std::collections::HashMap<String, String>>,
    /// <p>The resource that the external principal has access to.</p>
    #[serde(rename = "resource")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub resource: Option<String>,
    /// <p>The AWS account ID that owns the resource.</p>
    #[serde(rename = "resourceOwnerAccount")]
    pub resource_owner_account: String,
    /// <p>The type of the resource that the external principal has access to.</p>
    #[serde(rename = "resourceType")]
    pub resource_type: String,
    /// <p>The sources of the finding. This indicates how the access that generated the finding is granted. It is populated for Amazon S3 bucket findings.</p>
    #[serde(rename = "sources")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sources: Option<Vec<FindingSource>>,
    /// <p>The status of the finding.</p>
    #[serde(rename = "status")]
    pub status: String,
    /// <p>The time at which the finding was most recently updated.</p>
    #[serde(rename = "updatedAt")]
    pub updated_at: f64,
}

/// <p>Contains the text for the generated policy.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GeneratedPolicy {
    /// <p>The text to use as the content for the new policy. The policy is created using the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreatePolicy.html">CreatePolicy</a> action.</p>
    #[serde(rename = "policy")]
    pub policy: String,
}

/// <p>Contains the generated policy details.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GeneratedPolicyProperties {
    /// <p>Lists details about the <code>Trail</code> used to generated policy.</p>
    #[serde(rename = "cloudTrailProperties")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub cloud_trail_properties: Option<CloudTrailProperties>,
    /// <p>This value is set to <code>true</code> if the generated policy contains all possible actions for a service that Access Analyzer identified from the CloudTrail trail that you specified, and <code>false</code> otherwise.</p>
    #[serde(rename = "isComplete")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub is_complete: Option<bool>,
    /// <p>The ARN of the IAM entity (user or role) for which you are generating a policy.</p>
    #[serde(rename = "principalArn")]
    pub principal_arn: String,
}

/// <p>Contains the text for the generated policy and its details.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GeneratedPolicyResult {
    /// <p>The text to use as the content for the new policy. The policy is created using the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreatePolicy.html">CreatePolicy</a> action.</p>
    #[serde(rename = "generatedPolicies")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub generated_policies: Option<Vec<GeneratedPolicy>>,
    /// <p>A <code>GeneratedPolicyProperties</code> object that contains properties of the generated policy.</p>
    #[serde(rename = "properties")]
    pub properties: GeneratedPolicyProperties,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetAccessPreviewRequest {
    /// <p>The unique ID for the access preview.</p>
    #[serde(rename = "accessPreviewId")]
    pub access_preview_id: String,
    /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> used to generate the access preview.</p>
    #[serde(rename = "analyzerArn")]
    pub analyzer_arn: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetAccessPreviewResponse {
    /// <p>An object that contains information about the access preview.</p>
    #[serde(rename = "accessPreview")]
    pub access_preview: AccessPreview,
}

/// <p>Retrieves an analyzed resource.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetAnalyzedResourceRequest {
    /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> to retrieve information from.</p>
    #[serde(rename = "analyzerArn")]
    pub analyzer_arn: String,
    /// <p>The ARN of the resource to retrieve information about.</p>
    #[serde(rename = "resourceArn")]
    pub resource_arn: String,
}

/// <p>The response to the request.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetAnalyzedResourceResponse {
    /// <p>An <code>AnalyzedResource</code> object that contains information that Access Analyzer found when it analyzed the resource.</p>
    #[serde(rename = "resource")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub resource: Option<AnalyzedResource>,
}

/// <p>Retrieves an analyzer.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetAnalyzerRequest {
    /// <p>The name of the analyzer retrieved.</p>
    #[serde(rename = "analyzerName")]
    pub analyzer_name: String,
}

/// <p>The response to the request.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetAnalyzerResponse {
    /// <p>An <code>AnalyzerSummary</code> object that contains information about the analyzer.</p>
    #[serde(rename = "analyzer")]
    pub analyzer: AnalyzerSummary,
}

/// <p>Retrieves an archive rule.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetArchiveRuleRequest {
    /// <p>The name of the analyzer to retrieve rules from.</p>
    #[serde(rename = "analyzerName")]
    pub analyzer_name: String,
    /// <p>The name of the rule to retrieve.</p>
    #[serde(rename = "ruleName")]
    pub rule_name: String,
}

/// <p>The response to the request.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetArchiveRuleResponse {
    #[serde(rename = "archiveRule")]
    pub archive_rule: ArchiveRuleSummary,
}

/// <p>Retrieves a finding.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetFindingRequest {
    /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> that generated the finding.</p>
    #[serde(rename = "analyzerArn")]
    pub analyzer_arn: String,
    /// <p>The ID of the finding to retrieve.</p>
    #[serde(rename = "id")]
    pub id: String,
}

/// <p>The response to the request.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetFindingResponse {
    /// <p>A <code>finding</code> object that contains finding details.</p>
    #[serde(rename = "finding")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub finding: Option<Finding>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetGeneratedPolicyRequest {
    /// <p>The level of detail that you want to generate. You can specify whether to generate policies with placeholders for resource ARNs for actions that support resource level granularity in policies.</p> <p>For example, in the resource section of a policy, you can receive a placeholder such as <code>"Resource":"arn:aws:s3:::${BucketName}"</code> instead of <code>"*"</code>.</p>
    #[serde(rename = "includeResourcePlaceholders")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub include_resource_placeholders: Option<bool>,
    /// <p>The level of detail that you want to generate. You can specify whether to generate service-level policies. </p> <p>Access Analyzer uses <code>iam:servicelastaccessed</code> to identify services that have been used recently to create this service-level template.</p>
    #[serde(rename = "includeServiceLevelTemplate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub include_service_level_template: Option<bool>,
    /// <p>The <code>JobId</code> that is returned by the <code>StartPolicyGeneration</code> operation. The <code>JobId</code> can be used with <code>GetGeneratedPolicy</code> to retrieve the generated policies or used with <code>CancelPolicyGeneration</code> to cancel the policy generation request.</p>
    #[serde(rename = "jobId")]
    pub job_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetGeneratedPolicyResponse {
    /// <p>A <code>GeneratedPolicyResult</code> object that contains the generated policies and associated details.</p>
    #[serde(rename = "generatedPolicyResult")]
    pub generated_policy_result: GeneratedPolicyResult,
    /// <p>A <code>GeneratedPolicyDetails</code> object that contains details about the generated policy.</p>
    #[serde(rename = "jobDetails")]
    pub job_details: JobDetails,
}

/// <p>The proposed access control configuration for an IAM role. You can propose a configuration for a new IAM role or an existing IAM role that you own by specifying the trust policy. If the configuration is for a new IAM role, you must specify the trust policy. If the configuration is for an existing IAM role that you own and you do not propose the trust policy, the access preview uses the existing trust policy for the role. The proposed trust policy cannot be an empty string. For more information about role trust policy limits, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas</a>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct IamRoleConfiguration {
    /// <p>The proposed trust policy for the IAM role.</p>
    #[serde(rename = "trustPolicy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub trust_policy: Option<String>,
}

/// <p>An criterion statement in an archive rule. Each archive rule may have multiple criteria.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct InlineArchiveRule {
    /// <p>The condition and values for a criterion.</p>
    #[serde(rename = "filter")]
    pub filter: ::std::collections::HashMap<String, Criterion>,
    /// <p>The name of the rule.</p>
    #[serde(rename = "ruleName")]
    pub rule_name: String,
}

/// <p>This configuration sets the Amazon S3 access point network origin to <code>Internet</code>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct InternetConfiguration {}

/// <p>Contains details about the policy generation request.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct JobDetails {
    /// <p>A timestamp of when the job was completed.</p>
    #[serde(rename = "completedOn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub completed_on: Option<f64>,
    #[serde(rename = "jobError")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub job_error: Option<JobError>,
    /// <p>The <code>JobId</code> that is returned by the <code>StartPolicyGeneration</code> operation. The <code>JobId</code> can be used with <code>GetGeneratedPolicy</code> to retrieve the generated policies or used with <code>CancelPolicyGeneration</code> to cancel the policy generation request.</p>
    #[serde(rename = "jobId")]
    pub job_id: String,
    /// <p>A timestamp of when the job was started.</p>
    #[serde(rename = "startedOn")]
    pub started_on: f64,
    /// <p>The status of the job request.</p>
    #[serde(rename = "status")]
    pub status: String,
}

/// <p>Contains the details about the policy generation error.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct JobError {
    /// <p>The job error code.</p>
    #[serde(rename = "code")]
    pub code: String,
    /// <p>Specific information about the error. For example, which service quota was exceeded or which resource was not found.</p>
    #[serde(rename = "message")]
    pub message: String,
}

/// <p>A proposed grant configuration for a KMS key. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateGrant.html">CreateGrant</a>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct KmsGrantConfiguration {
    /// <p>Use this structure to propose allowing <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic operations</a> in the grant only when the operation request includes the specified <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">encryption context</a>.</p>
    #[serde(rename = "constraints")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub constraints: Option<KmsGrantConstraints>,
    /// <p>The principal that is given permission to perform the operations that the grant permits.</p>
    #[serde(rename = "granteePrincipal")]
    pub grantee_principal: String,
    /// <p> The AWS account under which the grant was issued. The account is used to propose KMS grants issued by accounts other than the owner of the key.</p>
    #[serde(rename = "issuingAccount")]
    pub issuing_account: String,
    /// <p>A list of operations that the grant permits.</p>
    #[serde(rename = "operations")]
    pub operations: Vec<String>,
    /// <p>The principal that is given permission to retire the grant by using <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_RetireGrant.html">RetireGrant</a> operation.</p>
    #[serde(rename = "retiringPrincipal")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub retiring_principal: Option<String>,
}

/// <p>Use this structure to propose allowing <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic operations</a> in the grant only when the operation request includes the specified <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">encryption context</a>. You can specify only one type of encryption context. An empty map is treated as not specified. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_GrantConstraints.html">GrantConstraints</a>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct KmsGrantConstraints {
    /// <p>A list of key-value pairs that must match the encryption context in the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic operation</a> request. The grant allows the operation only when the encryption context in the request is the same as the encryption context specified in this constraint.</p>
    #[serde(rename = "encryptionContextEquals")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub encryption_context_equals: Option<::std::collections::HashMap<String, String>>,
    /// <p>A list of key-value pairs that must be included in the encryption context of the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic operation</a> request. The grant allows the cryptographic operation only when the encryption context in the request includes the key-value pairs specified in this constraint, although it can include additional key-value pairs.</p>
    #[serde(rename = "encryptionContextSubset")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub encryption_context_subset: Option<::std::collections::HashMap<String, String>>,
}

/// <p><p>Proposed access control configuration for a KMS key. You can propose a configuration for a new KMS key or an existing KMS key that you own by specifying the key policy and KMS grant configuration. If the configuration is for an existing key and you do not specify the key policy, the access preview uses the existing policy for the key. If the access preview is for a new resource and you do not specify the key policy, then the access preview uses the default key policy. The proposed key policy cannot be an empty string. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default">Default key policy</a>. For more information about key policy limits, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/resource-limits.html">Resource quotas</a>.</p> <p/></p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct KmsKeyConfiguration {
    /// <p>A list of proposed grant configurations for the KMS key. If the proposed grant configuration is for an existing key, the access preview uses the proposed list of grant configurations in place of the existing grants. Otherwise, the access preview uses the existing grants for the key.</p>
    #[serde(rename = "grants")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub grants: Option<Vec<KmsGrantConfiguration>>,
    /// <p>Resource policy configuration for the KMS key. The only valid value for the name of the key policy is <code>default</code>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default">Default key policy</a>.</p>
    #[serde(rename = "keyPolicies")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub key_policies: Option<::std::collections::HashMap<String, String>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListAccessPreviewFindingsRequest {
    /// <p>The unique ID for the access preview.</p>
    #[serde(rename = "accessPreviewId")]
    pub access_preview_id: String,
    /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> used to generate the access.</p>
    #[serde(rename = "analyzerArn")]
    pub analyzer_arn: String,
    /// <p>Criteria to filter the returned findings.</p>
    #[serde(rename = "filter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub filter: Option<::std::collections::HashMap<String, Criterion>>,
    /// <p>The maximum number of results to return in the response.</p>
    #[serde(rename = "maxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>A token used for pagination of results returned.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListAccessPreviewFindingsResponse {
    /// <p>A list of access preview findings that match the specified filter criteria.</p>
    #[serde(rename = "findings")]
    pub findings: Vec<AccessPreviewFinding>,
    /// <p>A token used for pagination of results returned.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListAccessPreviewsRequest {
    /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> used to generate the access preview.</p>
    #[serde(rename = "analyzerArn")]
    pub analyzer_arn: String,
    /// <p>The maximum number of results to return in the response.</p>
    #[serde(rename = "maxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>A token used for pagination of results returned.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListAccessPreviewsResponse {
    /// <p>A list of access previews retrieved for the analyzer.</p>
    #[serde(rename = "accessPreviews")]
    pub access_previews: Vec<AccessPreviewSummary>,
    /// <p>A token used for pagination of results returned.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

/// <p>Retrieves a list of resources that have been analyzed.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListAnalyzedResourcesRequest {
    /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> to retrieve a list of analyzed resources from.</p>
    #[serde(rename = "analyzerArn")]
    pub analyzer_arn: String,
    /// <p>The maximum number of results to return in the response.</p>
    #[serde(rename = "maxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>A token used for pagination of results returned.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The type of resource.</p>
    #[serde(rename = "resourceType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub resource_type: Option<String>,
}

/// <p>The response to the request.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListAnalyzedResourcesResponse {
    /// <p>A list of resources that were analyzed.</p>
    #[serde(rename = "analyzedResources")]
    pub analyzed_resources: Vec<AnalyzedResourceSummary>,
    /// <p>A token used for pagination of results returned.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

/// <p>Retrieves a list of analyzers.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListAnalyzersRequest {
    /// <p>The maximum number of results to return in the response.</p>
    #[serde(rename = "maxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>A token used for pagination of results returned.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The type of analyzer.</p>
    #[serde(rename = "type")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}

/// <p>The response to the request.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListAnalyzersResponse {
    /// <p>The analyzers retrieved.</p>
    #[serde(rename = "analyzers")]
    pub analyzers: Vec<AnalyzerSummary>,
    /// <p>A token used for pagination of results returned.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

/// <p>Retrieves a list of archive rules created for the specified analyzer.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListArchiveRulesRequest {
    /// <p>The name of the analyzer to retrieve rules from.</p>
    #[serde(rename = "analyzerName")]
    pub analyzer_name: String,
    /// <p>The maximum number of results to return in the request.</p>
    #[serde(rename = "maxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>A token used for pagination of results returned.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

/// <p>The response to the request.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListArchiveRulesResponse {
    /// <p>A list of archive rules created for the specified analyzer.</p>
    #[serde(rename = "archiveRules")]
    pub archive_rules: Vec<ArchiveRuleSummary>,
    /// <p>A token used for pagination of results returned.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

/// <p>Retrieves a list of findings generated by the specified analyzer.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListFindingsRequest {
    /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> to retrieve findings from.</p>
    #[serde(rename = "analyzerArn")]
    pub analyzer_arn: String,
    /// <p>A filter to match for the findings to return.</p>
    #[serde(rename = "filter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub filter: Option<::std::collections::HashMap<String, Criterion>>,
    /// <p>The maximum number of results to return in the response.</p>
    #[serde(rename = "maxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>A token used for pagination of results returned.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The sort order for the findings returned.</p>
    #[serde(rename = "sort")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort: Option<SortCriteria>,
}

/// <p>The response to the request.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListFindingsResponse {
    /// <p>A list of findings retrieved from the analyzer that match the filter criteria specified, if any.</p>
    #[serde(rename = "findings")]
    pub findings: Vec<FindingSummary>,
    /// <p>A token used for pagination of results returned.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListPolicyGenerationsRequest {
    /// <p>The maximum number of results to return in the response.</p>
    #[serde(rename = "maxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>A token used for pagination of results returned.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The ARN of the IAM entity (user or role) for which you are generating a policy. Use this with <code>ListGeneratedPolicies</code> to filter the results to only include results for a specific principal.</p>
    #[serde(rename = "principalArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub principal_arn: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListPolicyGenerationsResponse {
    /// <p>A token used for pagination of results returned.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>A <code>PolicyGeneration</code> object that contains details about the generated policy.</p>
    #[serde(rename = "policyGenerations")]
    pub policy_generations: Vec<PolicyGeneration>,
}

/// <p>Retrieves a list of tags applied to the specified resource.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListTagsForResourceRequest {
    /// <p>The ARN of the resource to retrieve tags from.</p>
    #[serde(rename = "resourceArn")]
    pub resource_arn: String,
}

/// <p>The response to the request.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListTagsForResourceResponse {
    /// <p>The tags that are applied to the specified resource.</p>
    #[serde(rename = "tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<::std::collections::HashMap<String, String>>,
}

/// <p>A location in a policy that is represented as a path through the JSON representation and a corresponding span.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct Location {
    /// <p>A path in a policy, represented as a sequence of path elements.</p>
    #[serde(rename = "path")]
    pub path: Vec<PathElement>,
    /// <p>A span in a policy.</p>
    #[serde(rename = "span")]
    pub span: Span,
}

/// <p>The proposed <code>InternetConfiguration</code> or <code>VpcConfiguration</code> to apply to the Amazon S3 Access point. You can make the access point accessible from the internet, or you can specify that all requests made through that access point must originate from a specific virtual private cloud (VPC). You can specify only one type of network configuration. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/creating-access-points.html">Creating access points</a>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct NetworkOriginConfiguration {
    /// <p>The configuration for the Amazon S3 access point with an <code>Internet</code> origin.</p>
    #[serde(rename = "internetConfiguration")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub internet_configuration: Option<InternetConfiguration>,
    #[serde(rename = "vpcConfiguration")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub vpc_configuration: Option<VpcConfiguration>,
}

/// <p>A single element in a path through the JSON representation of a policy.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct PathElement {
    /// <p>Refers to an index in a JSON array.</p>
    #[serde(rename = "index")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub index: Option<i64>,
    /// <p>Refers to a key in a JSON object.</p>
    #[serde(rename = "key")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub key: Option<String>,
    /// <p>Refers to a substring of a literal string in a JSON object.</p>
    #[serde(rename = "substring")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub substring: Option<Substring>,
    /// <p>Refers to the value associated with a given key in a JSON object.</p>
    #[serde(rename = "value")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}

/// <p>Contains details about the policy generation status and properties.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct PolicyGeneration {
    /// <p>A timestamp of when the policy generation was completed.</p>
    #[serde(rename = "completedOn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub completed_on: Option<f64>,
    /// <p>The <code>JobId</code> that is returned by the <code>StartPolicyGeneration</code> operation. The <code>JobId</code> can be used with <code>GetGeneratedPolicy</code> to retrieve the generated policies or used with <code>CancelPolicyGeneration</code> to cancel the policy generation request.</p>
    #[serde(rename = "jobId")]
    pub job_id: String,
    /// <p>The ARN of the IAM entity (user or role) for which you are generating a policy.</p>
    #[serde(rename = "principalArn")]
    pub principal_arn: String,
    /// <p>A timestamp of when the policy generation started.</p>
    #[serde(rename = "startedOn")]
    pub started_on: f64,
    /// <p>The status of the policy generation request.</p>
    #[serde(rename = "status")]
    pub status: String,
}

/// <p>Contains the ARN details about the IAM entity for which the policy is generated.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct PolicyGenerationDetails {
    /// <p>The ARN of the IAM entity (user or role) for which you are generating a policy.</p>
    #[serde(rename = "principalArn")]
    pub principal_arn: String,
}

/// <p>A position in a policy.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct Position {
    /// <p>The column of the position, starting from 0.</p>
    #[serde(rename = "column")]
    pub column: i64,
    /// <p>The line of the position, starting from 1.</p>
    #[serde(rename = "line")]
    pub line: i64,
    /// <p>The offset within the policy that corresponds to the position, starting from 0.</p>
    #[serde(rename = "offset")]
    pub offset: i64,
}

/// <p>The configuration for an Amazon S3 access point for the bucket. You can propose up to 10 access points per bucket. If the proposed Amazon S3 access point configuration is for an existing bucket, the access preview uses the proposed access point configuration in place of the existing access points. To propose an access point without a policy, you can provide an empty string as the access point policy. For more information, see <a href="https://docs.aws.amazon.com/https:/docs.aws.amazon.com/AmazonS3/latest/dev/creating-access-points.html">Creating access points</a>. For more information about access point policy limits, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-points-restrictions-limitations.html">Access points restrictions and limitations</a>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct S3AccessPointConfiguration {
    /// <p>The access point policy.</p>
    #[serde(rename = "accessPointPolicy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub access_point_policy: Option<String>,
    /// <p>The proposed <code>Internet</code> and <code>VpcConfiguration</code> to apply to this Amazon S3 access point. If the access preview is for a new resource and neither is specified, the access preview uses <code>Internet</code> for the network origin. If the access preview is for an existing resource and neither is specified, the access preview uses the exiting network origin.</p>
    #[serde(rename = "networkOrigin")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub network_origin: Option<NetworkOriginConfiguration>,
    /// <p>The proposed <code>S3PublicAccessBlock</code> configuration to apply to this Amazon S3 Access Point.</p>
    #[serde(rename = "publicAccessBlock")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub public_access_block: Option<S3PublicAccessBlockConfiguration>,
}

/// <p>A proposed access control list grant configuration for an Amazon S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#setting-acls">How to Specify an ACL</a>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct S3BucketAclGrantConfiguration {
    /// <p>The grantee to whom you’re assigning access rights.</p>
    #[serde(rename = "grantee")]
    pub grantee: AclGrantee,
    /// <p>The permissions being granted.</p>
    #[serde(rename = "permission")]
    pub permission: String,
}

/// <p>Proposed access control configuration for an Amazon S3 bucket. You can propose a configuration for a new Amazon S3 bucket or an existing Amazon S3 bucket that you own by specifying the Amazon S3 bucket policy, bucket ACLs, bucket BPA settings, and Amazon S3 access points attached to the bucket. If the configuration is for an existing Amazon S3 bucket and you do not specify the Amazon S3 bucket policy, the access preview uses the existing policy attached to the bucket. If the access preview is for a new resource and you do not specify the Amazon S3 bucket policy, the access preview assumes a bucket without a policy. To propose deletion of an existing bucket policy, you can specify an empty string. For more information about bucket policy limits, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/example-bucket-policies.html">Bucket Policy Examples</a>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct S3BucketConfiguration {
    /// <p>The configuration of Amazon S3 access points for the bucket.</p>
    #[serde(rename = "accessPoints")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub access_points: Option<::std::collections::HashMap<String, S3AccessPointConfiguration>>,
    /// <p>The proposed list of ACL grants for the Amazon S3 bucket. You can propose up to 100 ACL grants per bucket. If the proposed grant configuration is for an existing bucket, the access preview uses the proposed list of grant configurations in place of the existing grants. Otherwise, the access preview uses the existing grants for the bucket.</p>
    #[serde(rename = "bucketAclGrants")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub bucket_acl_grants: Option<Vec<S3BucketAclGrantConfiguration>>,
    /// <p>The proposed bucket policy for the Amazon S3 bucket.</p>
    #[serde(rename = "bucketPolicy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub bucket_policy: Option<String>,
    /// <p>The proposed block public access configuration for the Amazon S3 bucket.</p>
    #[serde(rename = "bucketPublicAccessBlock")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub bucket_public_access_block: Option<S3PublicAccessBlockConfiguration>,
}

/// <p>The <code>PublicAccessBlock</code> configuration to apply to this Amazon S3 bucket. If the proposed configuration is for an existing Amazon S3 bucket and the configuration is not specified, the access preview uses the existing setting. If the proposed configuration is for a new bucket and the configuration is not specified, the access preview uses <code>false</code>. If the proposed configuration is for a new access point and the access point BPA configuration is not specified, the access preview uses <code>true</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html">PublicAccessBlockConfiguration</a>. </p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct S3PublicAccessBlockConfiguration {
    /// <p> Specifies whether Amazon S3 should ignore public ACLs for this bucket and objects in this bucket. </p>
    #[serde(rename = "ignorePublicAcls")]
    pub ignore_public_acls: bool,
    /// <p> Specifies whether Amazon S3 should restrict public bucket policies for this bucket. </p>
    #[serde(rename = "restrictPublicBuckets")]
    pub restrict_public_buckets: bool,
}

/// <p>The configuration for a Secrets Manager secret. For more information, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/apireference/API_CreateSecret.html">CreateSecret</a>.</p> <p>You can propose a configuration for a new secret or an existing secret that you own by specifying the secret policy and optional KMS encryption key. If the configuration is for an existing secret and you do not specify the secret policy, the access preview uses the existing policy for the secret. If the access preview is for a new resource and you do not specify the policy, the access preview assumes a secret without a policy. To propose deletion of an existing policy, you can specify an empty string. If the proposed configuration is for a new secret and you do not specify the KMS key ID, the access preview uses the default CMK of the AWS account. If you specify an empty string for the KMS key ID, the access preview uses the default CMK of the AWS account. For more information about secret policy limits, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_limits.html">Quotas for AWS Secrets Manager.</a>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct SecretsManagerSecretConfiguration {
    /// <p>The proposed ARN, key ID, or alias of the AWS KMS customer master key (CMK).</p>
    #[serde(rename = "kmsKeyId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub kms_key_id: Option<String>,
    /// <p>The proposed resource policy defining who can access or manage the secret.</p>
    #[serde(rename = "secretPolicy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub secret_policy: Option<String>,
}

/// <p>The criteria used to sort.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct SortCriteria {
    /// <p>The name of the attribute to sort on.</p>
    #[serde(rename = "attributeName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub attribute_name: Option<String>,
    /// <p>The sort order, ascending or descending.</p>
    #[serde(rename = "orderBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub order_by: Option<String>,
}

/// <p>A span in a policy. The span consists of a start position (inclusive) and end position (exclusive).</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct Span {
    /// <p>The end position of the span (exclusive).</p>
    #[serde(rename = "end")]
    pub end: Position,
    /// <p>The start position of the span (inclusive).</p>
    #[serde(rename = "start")]
    pub start: Position,
}

/// <p>The proposed access control configuration for an SQS queue. You can propose a configuration for a new SQS queue or an existing SQS queue that you own by specifying the SQS policy. If the configuration is for an existing SQS queue and you do not specify the SQS policy, the access preview uses the existing SQS policy for the queue. If the access preview is for a new resource and you do not specify the policy, the access preview assumes an SQS queue without a policy. To propose deletion of an existing SQS queue policy, you can specify an empty string for the SQS policy. For more information about SQS policy limits, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/quotas-policies.html">Quotas related to policies</a>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct SqsQueueConfiguration {
    /// <p> The proposed resource policy for the SQS queue. </p>
    #[serde(rename = "queuePolicy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub queue_policy: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct StartPolicyGenerationRequest {
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, the subsequent retries with the same client token return the result from the original successful request and they have no additional effect.</p> <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
    #[serde(rename = "clientToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub client_token: Option<String>,
    /// <p>A <code>CloudTrailDetails</code> object that contains details about a <code>Trail</code> that you want to analyze to generate policies.</p>
    #[serde(rename = "cloudTrailDetails")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub cloud_trail_details: Option<CloudTrailDetails>,
    /// <p>Contains the ARN of the IAM entity (user or role) for which you are generating a policy.</p>
    #[serde(rename = "policyGenerationDetails")]
    pub policy_generation_details: PolicyGenerationDetails,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct StartPolicyGenerationResponse {
    /// <p>The <code>JobId</code> that is returned by the <code>StartPolicyGeneration</code> operation. The <code>JobId</code> can be used with <code>GetGeneratedPolicy</code> to retrieve the generated policies or used with <code>CancelPolicyGeneration</code> to cancel the policy generation request.</p>
    #[serde(rename = "jobId")]
    pub job_id: String,
}

/// <p>Starts a scan of the policies applied to the specified resource.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct StartResourceScanRequest {
    /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> to use to scan the policies applied to the specified resource.</p>
    #[serde(rename = "analyzerArn")]
    pub analyzer_arn: String,
    /// <p>The ARN of the resource to scan.</p>
    #[serde(rename = "resourceArn")]
    pub resource_arn: String,
}

/// <p>Provides more details about the current status of the analyzer. For example, if the creation for the analyzer fails, a <code>Failed</code> status is returned. For an analyzer with organization as the type, this failure can be due to an issue with creating the service-linked roles required in the member accounts of the AWS organization.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct StatusReason {
    /// <p>The reason code for the current status of the analyzer.</p>
    #[serde(rename = "code")]
    pub code: String,
}

/// <p>A reference to a substring of a literal string in a JSON document.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct Substring {
    /// <p>The length of the substring.</p>
    #[serde(rename = "length")]
    pub length: i64,
    /// <p>The start index of the substring, starting from 0.</p>
    #[serde(rename = "start")]
    pub start: i64,
}

/// <p>Adds a tag to the specified resource.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct TagResourceRequest {
    /// <p>The ARN of the resource to add the tag to.</p>
    #[serde(rename = "resourceArn")]
    pub resource_arn: String,
    /// <p>The tags to add to the resource.</p>
    #[serde(rename = "tags")]
    pub tags: ::std::collections::HashMap<String, String>,
}

/// <p>The response to the request.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct TagResourceResponse {}

/// <p>Contains details about the CloudTrail trail being analyzed to generate a policy.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct Trail {
    /// <p>Possible values are <code>true</code> or <code>false</code>. If set to <code>true</code>, Access Analyzer retrieves CloudTrail data from all regions to analyze and generate a policy.</p>
    #[serde(rename = "allRegions")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub all_regions: Option<bool>,
    /// <p>Specifies the ARN of the trail. The format of a trail ARN is <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>.</p>
    #[serde(rename = "cloudTrailArn")]
    pub cloud_trail_arn: String,
    /// <p>A list of regions to get CloudTrail data from and analyze to generate a policy.</p>
    #[serde(rename = "regions")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub regions: Option<Vec<String>>,
}

/// <p>Contains details about the CloudTrail trail being analyzed to generate a policy.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct TrailProperties {
    /// <p>Possible values are <code>true</code> or <code>false</code>. If set to <code>true</code>, Access Analyzer retrieves CloudTrail data from all regions to analyze and generate a policy.</p>
    #[serde(rename = "allRegions")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub all_regions: Option<bool>,
    /// <p>Specifies the ARN of the trail. The format of a trail ARN is <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>.</p>
    #[serde(rename = "cloudTrailArn")]
    pub cloud_trail_arn: String,
    /// <p>A list of regions to get CloudTrail data from and analyze to generate a policy.</p>
    #[serde(rename = "regions")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub regions: Option<Vec<String>>,
}

/// <p>Removes a tag from the specified resource.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UntagResourceRequest {
    /// <p>The ARN of the resource to remove the tag from.</p>
    #[serde(rename = "resourceArn")]
    pub resource_arn: String,
    /// <p>The key for the tag to add.</p>
    #[serde(rename = "tagKeys")]
    pub tag_keys: Vec<String>,
}

/// <p>The response to the request.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UntagResourceResponse {}

/// <p>Updates the specified archive rule.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateArchiveRuleRequest {
    /// <p>The name of the analyzer to update the archive rules for.</p>
    #[serde(rename = "analyzerName")]
    pub analyzer_name: String,
    /// <p>A client token.</p>
    #[serde(rename = "clientToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub client_token: Option<String>,
    /// <p>A filter to match for the rules to update. Only rules that match the filter are updated.</p>
    #[serde(rename = "filter")]
    pub filter: ::std::collections::HashMap<String, Criterion>,
    /// <p>The name of the rule to update.</p>
    #[serde(rename = "ruleName")]
    pub rule_name: String,
}

/// <p>Updates findings with the new values provided in the request.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateFindingsRequest {
    /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> that generated the findings to update.</p>
    #[serde(rename = "analyzerArn")]
    pub analyzer_arn: String,
    /// <p>A client token.</p>
    #[serde(rename = "clientToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub client_token: Option<String>,
    /// <p>The IDs of the findings to update.</p>
    #[serde(rename = "ids")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub ids: Option<Vec<String>>,
    /// <p>The ARN of the resource identified in the finding.</p>
    #[serde(rename = "resourceArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub resource_arn: Option<String>,
    /// <p>The state represents the action to take to update the finding Status. Use <code>ARCHIVE</code> to change an Active finding to an Archived finding. Use <code>ACTIVE</code> to change an Archived finding to an Active finding.</p>
    #[serde(rename = "status")]
    pub status: String,
}

/// <p>A finding in a policy. Each finding is an actionable recommendation that can be used to improve the policy.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ValidatePolicyFinding {
    /// <p>A localized message that explains the finding and provides guidance on how to address it.</p>
    #[serde(rename = "findingDetails")]
    pub finding_details: String,
    /// <p>The impact of the finding.</p> <p>Security warnings report when the policy allows access that we consider overly permissive.</p> <p>Errors report when a part of the policy is not functional.</p> <p>Warnings report non-security issues when a policy does not conform to policy writing best practices.</p> <p>Suggestions recommend stylistic improvements in the policy that do not impact access.</p>
    #[serde(rename = "findingType")]
    pub finding_type: String,
    /// <p>The issue code provides an identifier of the issue associated with this finding.</p>
    #[serde(rename = "issueCode")]
    pub issue_code: String,
    /// <p>A link to additional documentation about the type of finding.</p>
    #[serde(rename = "learnMoreLink")]
    pub learn_more_link: String,
    /// <p>The list of locations in the policy document that are related to the finding. The issue code provides a summary of an issue identified by the finding.</p>
    #[serde(rename = "locations")]
    pub locations: Vec<Location>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ValidatePolicyRequest {
    /// <p>The locale to use for localizing the findings.</p>
    #[serde(rename = "locale")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub locale: Option<String>,
    /// <p>The maximum number of results to return in the response.</p>
    #[serde(rename = "maxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>A token used for pagination of results returned.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The JSON policy document to use as the content for the policy.</p>
    #[serde(rename = "policyDocument")]
    pub policy_document: String,
    /// <p>The type of policy to validate. Identity policies grant permissions to IAM principals. Identity policies include managed and inline policies for IAM roles, users, and groups. They also include service-control policies (SCPs) that are attached to an AWS organization, organizational unit (OU), or an account.</p> <p>Resource policies grant permissions on AWS resources. Resource policies include trust policies for IAM roles and bucket policies for S3 buckets. You can provide a generic input such as identity policy or resource policy or a specific input such as managed policy or S3 bucket policy. </p>
    #[serde(rename = "policyType")]
    pub policy_type: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ValidatePolicyResponse {
    /// <p>The list of findings in a policy returned by Access Analyzer based on its suite of policy checks.</p>
    #[serde(rename = "findings")]
    pub findings: Vec<ValidatePolicyFinding>,
    /// <p>A token used for pagination of results returned.</p>
    #[serde(rename = "nextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

/// <p>Contains information about a validation exception.</p>
#[derive(Clone, Debug, Default, PartialEq)]
pub struct ValidationExceptionField {
    /// <p>A message about the validation exception.</p>
    pub message: String,
    /// <p>The name of the validation exception.</p>
    pub name: String,
}

/// <p> The proposed virtual private cloud (VPC) configuration for the Amazon S3 access point. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_VpcConfiguration.html">VpcConfiguration</a>. </p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct VpcConfiguration {
    /// <p> If this field is specified, this access point will only allow connections from the specified VPC ID. </p>
    #[serde(rename = "vpcId")]
    pub vpc_id: String,
}

/// Errors returned by ApplyArchiveRule
#[derive(Debug, PartialEq)]
pub enum ApplyArchiveRuleError {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDenied(String),
    /// <p>Internal server error.</p>
    InternalServer(String),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFound(String),
    /// <p>Throttling limit exceeded error.</p>
    Throttling(String),
}

impl ApplyArchiveRuleError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ApplyArchiveRuleError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(ApplyArchiveRuleError::AccessDenied(err.msg))
                }
                "InternalServerException" => {
                    return RusotoError::Service(ApplyArchiveRuleError::InternalServer(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(ApplyArchiveRuleError::ResourceNotFound(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ApplyArchiveRuleError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ApplyArchiveRuleError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ApplyArchiveRuleError::AccessDenied(ref cause) => write!(f, "{}", cause),
            ApplyArchiveRuleError::InternalServer(ref cause) => write!(f, "{}", cause),
            ApplyArchiveRuleError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            ApplyArchiveRuleError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ApplyArchiveRuleError {}
/// Errors returned by CancelPolicyGeneration
#[derive(Debug, PartialEq)]
pub enum CancelPolicyGenerationError {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDenied(String),
    /// <p>Internal server error.</p>
    InternalServer(String),
    /// <p>Throttling limit exceeded error.</p>
    Throttling(String),
}

impl CancelPolicyGenerationError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CancelPolicyGenerationError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(CancelPolicyGenerationError::AccessDenied(err.msg))
                }
                "InternalServerException" => {
                    return RusotoError::Service(CancelPolicyGenerationError::InternalServer(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(CancelPolicyGenerationError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CancelPolicyGenerationError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CancelPolicyGenerationError::AccessDenied(ref cause) => write!(f, "{}", cause),
            CancelPolicyGenerationError::InternalServer(ref cause) => write!(f, "{}", cause),
            CancelPolicyGenerationError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CancelPolicyGenerationError {}
/// Errors returned by CreateAccessPreview
#[derive(Debug, PartialEq)]
pub enum CreateAccessPreviewError {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDenied(String),
    /// <p>A conflict exception error.</p>
    Conflict(String),
    /// <p>Internal server error.</p>
    InternalServer(String),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFound(String),
    /// <p>Service quote met error.</p>
    ServiceQuotaExceeded(String),
    /// <p>Throttling limit exceeded error.</p>
    Throttling(String),
}

impl CreateAccessPreviewError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateAccessPreviewError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(CreateAccessPreviewError::AccessDenied(err.msg))
                }
                "ConflictException" => {
                    return RusotoError::Service(CreateAccessPreviewError::Conflict(err.msg))
                }
                "InternalServerException" => {
                    return RusotoError::Service(CreateAccessPreviewError::InternalServer(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(CreateAccessPreviewError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ServiceQuotaExceededException" => {
                    return RusotoError::Service(CreateAccessPreviewError::ServiceQuotaExceeded(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(CreateAccessPreviewError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateAccessPreviewError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateAccessPreviewError::AccessDenied(ref cause) => write!(f, "{}", cause),
            CreateAccessPreviewError::Conflict(ref cause) => write!(f, "{}", cause),
            CreateAccessPreviewError::InternalServer(ref cause) => write!(f, "{}", cause),
            CreateAccessPreviewError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            CreateAccessPreviewError::ServiceQuotaExceeded(ref cause) => write!(f, "{}", cause),
            CreateAccessPreviewError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateAccessPreviewError {}
/// Errors returned by CreateAnalyzer
#[derive(Debug, PartialEq)]
pub enum CreateAnalyzerError {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDenied(String),
    /// <p>A conflict exception error.</p>
    Conflict(String),
    /// <p>Internal server error.</p>
    InternalServer(String),
    /// <p>Service quote met error.</p>
    ServiceQuotaExceeded(String),
    /// <p>Throttling limit exceeded error.</p>
    Throttling(String),
}

impl CreateAnalyzerError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateAnalyzerError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(CreateAnalyzerError::AccessDenied(err.msg))
                }
                "ConflictException" => {
                    return RusotoError::Service(CreateAnalyzerError::Conflict(err.msg))
                }
                "InternalServerException" => {
                    return RusotoError::Service(CreateAnalyzerError::InternalServer(err.msg))
                }
                "ServiceQuotaExceededException" => {
                    return RusotoError::Service(CreateAnalyzerError::ServiceQuotaExceeded(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(CreateAnalyzerError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateAnalyzerError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateAnalyzerError::AccessDenied(ref cause) => write!(f, "{}", cause),
            CreateAnalyzerError::Conflict(ref cause) => write!(f, "{}", cause),
            CreateAnalyzerError::InternalServer(ref cause) => write!(f, "{}", cause),
            CreateAnalyzerError::ServiceQuotaExceeded(ref cause) => write!(f, "{}", cause),
            CreateAnalyzerError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateAnalyzerError {}
/// Errors returned by CreateArchiveRule
#[derive(Debug, PartialEq)]
pub enum CreateArchiveRuleError {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDenied(String),
    /// <p>A conflict exception error.</p>
    Conflict(String),
    /// <p>Internal server error.</p>
    InternalServer(String),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFound(String),
    /// <p>Service quote met error.</p>
    ServiceQuotaExceeded(String),
    /// <p>Throttling limit exceeded error.</p>
    Throttling(String),
}

impl CreateArchiveRuleError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateArchiveRuleError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(CreateArchiveRuleError::AccessDenied(err.msg))
                }
                "ConflictException" => {
                    return RusotoError::Service(CreateArchiveRuleError::Conflict(err.msg))
                }
                "InternalServerException" => {
                    return RusotoError::Service(CreateArchiveRuleError::InternalServer(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(CreateArchiveRuleError::ResourceNotFound(err.msg))
                }
                "ServiceQuotaExceededException" => {
                    return RusotoError::Service(CreateArchiveRuleError::ServiceQuotaExceeded(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(CreateArchiveRuleError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for CreateArchiveRuleError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateArchiveRuleError::AccessDenied(ref cause) => write!(f, "{}", cause),
            CreateArchiveRuleError::Conflict(ref cause) => write!(f, "{}", cause),
            CreateArchiveRuleError::InternalServer(ref cause) => write!(f, "{}", cause),
            CreateArchiveRuleError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            CreateArchiveRuleError::ServiceQuotaExceeded(ref cause) => write!(f, "{}", cause),
            CreateArchiveRuleError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateArchiveRuleError {}
/// Errors returned by DeleteAnalyzer
#[derive(Debug, PartialEq)]
pub enum DeleteAnalyzerError {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDenied(String),
    /// <p>Internal server error.</p>
    InternalServer(String),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFound(String),
    /// <p>Throttling limit exceeded error.</p>
    Throttling(String),
}

impl DeleteAnalyzerError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteAnalyzerError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(DeleteAnalyzerError::AccessDenied(err.msg))
                }
                "InternalServerException" => {
                    return RusotoError::Service(DeleteAnalyzerError::InternalServer(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(DeleteAnalyzerError::ResourceNotFound(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DeleteAnalyzerError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteAnalyzerError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteAnalyzerError::AccessDenied(ref cause) => write!(f, "{}", cause),
            DeleteAnalyzerError::InternalServer(ref cause) => write!(f, "{}", cause),
            DeleteAnalyzerError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            DeleteAnalyzerError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteAnalyzerError {}
/// Errors returned by DeleteArchiveRule
#[derive(Debug, PartialEq)]
pub enum DeleteArchiveRuleError {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDenied(String),
    /// <p>Internal server error.</p>
    InternalServer(String),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFound(String),
    /// <p>Throttling limit exceeded error.</p>
    Throttling(String),
}

impl DeleteArchiveRuleError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteArchiveRuleError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(DeleteArchiveRuleError::AccessDenied(err.msg))
                }
                "InternalServerException" => {
                    return RusotoError::Service(DeleteArchiveRuleError::InternalServer(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(DeleteArchiveRuleError::ResourceNotFound(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(DeleteArchiveRuleError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for DeleteArchiveRuleError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteArchiveRuleError::AccessDenied(ref cause) => write!(f, "{}", cause),
            DeleteArchiveRuleError::InternalServer(ref cause) => write!(f, "{}", cause),
            DeleteArchiveRuleError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            DeleteArchiveRuleError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteArchiveRuleError {}
/// Errors returned by GetAccessPreview
#[derive(Debug, PartialEq)]
pub enum GetAccessPreviewError {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDenied(String),
    /// <p>Internal server error.</p>
    InternalServer(String),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFound(String),
    /// <p>Throttling limit exceeded error.</p>
    Throttling(String),
}

impl GetAccessPreviewError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetAccessPreviewError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(GetAccessPreviewError::AccessDenied(err.msg))
                }
                "InternalServerException" => {
                    return RusotoError::Service(GetAccessPreviewError::InternalServer(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(GetAccessPreviewError::ResourceNotFound(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(GetAccessPreviewError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for GetAccessPreviewError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetAccessPreviewError::AccessDenied(ref cause) => write!(f, "{}", cause),
            GetAccessPreviewError::InternalServer(ref cause) => write!(f, "{}", cause),
            GetAccessPreviewError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            GetAccessPreviewError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetAccessPreviewError {}
/// Errors returned by GetAnalyzedResource
#[derive(Debug, PartialEq)]
pub enum GetAnalyzedResourceError {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDenied(String),
    /// <p>Internal server error.</p>
    InternalServer(String),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFound(String),
    /// <p>Throttling limit exceeded error.</p>
    Throttling(String),
}

impl GetAnalyzedResourceError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetAnalyzedResourceError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(GetAnalyzedResourceError::AccessDenied(err.msg))
                }
                "InternalServerException" => {
                    return RusotoError::Service(GetAnalyzedResourceError::InternalServer(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(GetAnalyzedResourceError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(GetAnalyzedResourceError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for GetAnalyzedResourceError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetAnalyzedResourceError::AccessDenied(ref cause) => write!(f, "{}", cause),
            GetAnalyzedResourceError::InternalServer(ref cause) => write!(f, "{}", cause),
            GetAnalyzedResourceError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            GetAnalyzedResourceError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetAnalyzedResourceError {}
/// Errors returned by GetAnalyzer
#[derive(Debug, PartialEq)]
pub enum GetAnalyzerError {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDenied(String),
    /// <p>Internal server error.</p>
    InternalServer(String),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFound(String),
    /// <p>Throttling limit exceeded error.</p>
    Throttling(String),
}

impl GetAnalyzerError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetAnalyzerError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(GetAnalyzerError::AccessDenied(err.msg))
                }
                "InternalServerException" => {
                    return RusotoError::Service(GetAnalyzerError::InternalServer(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(GetAnalyzerError::ResourceNotFound(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(GetAnalyzerError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for GetAnalyzerError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetAnalyzerError::AccessDenied(ref cause) => write!(f, "{}", cause),
            GetAnalyzerError::InternalServer(ref cause) => write!(f, "{}", cause),
            GetAnalyzerError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            GetAnalyzerError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetAnalyzerError {}
/// Errors returned by GetArchiveRule
#[derive(Debug, PartialEq)]
pub enum GetArchiveRuleError {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDenied(String),
    /// <p>Internal server error.</p>
    InternalServer(String),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFound(String),
    /// <p>Throttling limit exceeded error.</p>
    Throttling(String),
}

impl GetArchiveRuleError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetArchiveRuleError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(GetArchiveRuleError::AccessDenied(err.msg))
                }
                "InternalServerException" => {
                    return RusotoError::Service(GetArchiveRuleError::InternalServer(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(GetArchiveRuleError::ResourceNotFound(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(GetArchiveRuleError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for GetArchiveRuleError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetArchiveRuleError::AccessDenied(ref cause) => write!(f, "{}", cause),
            GetArchiveRuleError::InternalServer(ref cause) => write!(f, "{}", cause),
            GetArchiveRuleError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            GetArchiveRuleError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetArchiveRuleError {}
/// Errors returned by GetFinding
#[derive(Debug, PartialEq)]
pub enum GetFindingError {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDenied(String),
    /// <p>Internal server error.</p>
    InternalServer(String),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFound(String),
    /// <p>Throttling limit exceeded error.</p>
    Throttling(String),
}

impl GetFindingError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetFindingError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(GetFindingError::AccessDenied(err.msg))
                }
                "InternalServerException" => {
                    return RusotoError::Service(GetFindingError::InternalServer(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(GetFindingError::ResourceNotFound(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(GetFindingError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for GetFindingError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetFindingError::AccessDenied(ref cause) => write!(f, "{}", cause),
            GetFindingError::InternalServer(ref cause) => write!(f, "{}", cause),
            GetFindingError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            GetFindingError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetFindingError {}
/// Errors returned by GetGeneratedPolicy
#[derive(Debug, PartialEq)]
pub enum GetGeneratedPolicyError {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDenied(String),
    /// <p>Internal server error.</p>
    InternalServer(String),
    /// <p>Throttling limit exceeded error.</p>
    Throttling(String),
}

impl GetGeneratedPolicyError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetGeneratedPolicyError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(GetGeneratedPolicyError::AccessDenied(err.msg))
                }
                "InternalServerException" => {
                    return RusotoError::Service(GetGeneratedPolicyError::InternalServer(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(GetGeneratedPolicyError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for GetGeneratedPolicyError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetGeneratedPolicyError::AccessDenied(ref cause) => write!(f, "{}", cause),
            GetGeneratedPolicyError::InternalServer(ref cause) => write!(f, "{}", cause),
            GetGeneratedPolicyError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for GetGeneratedPolicyError {}
/// Errors returned by ListAccessPreviewFindings
#[derive(Debug, PartialEq)]
pub enum ListAccessPreviewFindingsError {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDenied(String),
    /// <p>A conflict exception error.</p>
    Conflict(String),
    /// <p>Internal server error.</p>
    InternalServer(String),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFound(String),
    /// <p>Throttling limit exceeded error.</p>
    Throttling(String),
}

impl ListAccessPreviewFindingsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListAccessPreviewFindingsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(ListAccessPreviewFindingsError::AccessDenied(
                        err.msg,
                    ))
                }
                "ConflictException" => {
                    return RusotoError::Service(ListAccessPreviewFindingsError::Conflict(err.msg))
                }
                "InternalServerException" => {
                    return RusotoError::Service(ListAccessPreviewFindingsError::InternalServer(
                        err.msg,
                    ))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(ListAccessPreviewFindingsError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListAccessPreviewFindingsError::Throttling(
                        err.msg,
                    ))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListAccessPreviewFindingsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListAccessPreviewFindingsError::AccessDenied(ref cause) => write!(f, "{}", cause),
            ListAccessPreviewFindingsError::Conflict(ref cause) => write!(f, "{}", cause),
            ListAccessPreviewFindingsError::InternalServer(ref cause) => write!(f, "{}", cause),
            ListAccessPreviewFindingsError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            ListAccessPreviewFindingsError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListAccessPreviewFindingsError {}
/// Errors returned by ListAccessPreviews
#[derive(Debug, PartialEq)]
pub enum ListAccessPreviewsError {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDenied(String),
    /// <p>Internal server error.</p>
    InternalServer(String),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFound(String),
    /// <p>Throttling limit exceeded error.</p>
    Throttling(String),
}

impl ListAccessPreviewsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListAccessPreviewsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(ListAccessPreviewsError::AccessDenied(err.msg))
                }
                "InternalServerException" => {
                    return RusotoError::Service(ListAccessPreviewsError::InternalServer(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(ListAccessPreviewsError::ResourceNotFound(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListAccessPreviewsError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListAccessPreviewsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListAccessPreviewsError::AccessDenied(ref cause) => write!(f, "{}", cause),
            ListAccessPreviewsError::InternalServer(ref cause) => write!(f, "{}", cause),
            ListAccessPreviewsError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            ListAccessPreviewsError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListAccessPreviewsError {}
/// Errors returned by ListAnalyzedResources
#[derive(Debug, PartialEq)]
pub enum ListAnalyzedResourcesError {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDenied(String),
    /// <p>Internal server error.</p>
    InternalServer(String),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFound(String),
    /// <p>Throttling limit exceeded error.</p>
    Throttling(String),
}

impl ListAnalyzedResourcesError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListAnalyzedResourcesError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(ListAnalyzedResourcesError::AccessDenied(err.msg))
                }
                "InternalServerException" => {
                    return RusotoError::Service(ListAnalyzedResourcesError::InternalServer(
                        err.msg,
                    ))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(ListAnalyzedResourcesError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListAnalyzedResourcesError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListAnalyzedResourcesError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListAnalyzedResourcesError::AccessDenied(ref cause) => write!(f, "{}", cause),
            ListAnalyzedResourcesError::InternalServer(ref cause) => write!(f, "{}", cause),
            ListAnalyzedResourcesError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            ListAnalyzedResourcesError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListAnalyzedResourcesError {}
/// Errors returned by ListAnalyzers
#[derive(Debug, PartialEq)]
pub enum ListAnalyzersError {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDenied(String),
    /// <p>Internal server error.</p>
    InternalServer(String),
    /// <p>Throttling limit exceeded error.</p>
    Throttling(String),
}

impl ListAnalyzersError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListAnalyzersError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(ListAnalyzersError::AccessDenied(err.msg))
                }
                "InternalServerException" => {
                    return RusotoError::Service(ListAnalyzersError::InternalServer(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListAnalyzersError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListAnalyzersError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListAnalyzersError::AccessDenied(ref cause) => write!(f, "{}", cause),
            ListAnalyzersError::InternalServer(ref cause) => write!(f, "{}", cause),
            ListAnalyzersError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListAnalyzersError {}
/// Errors returned by ListArchiveRules
#[derive(Debug, PartialEq)]
pub enum ListArchiveRulesError {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDenied(String),
    /// <p>Internal server error.</p>
    InternalServer(String),
    /// <p>Throttling limit exceeded error.</p>
    Throttling(String),
}

impl ListArchiveRulesError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListArchiveRulesError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(ListArchiveRulesError::AccessDenied(err.msg))
                }
                "InternalServerException" => {
                    return RusotoError::Service(ListArchiveRulesError::InternalServer(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListArchiveRulesError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListArchiveRulesError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListArchiveRulesError::AccessDenied(ref cause) => write!(f, "{}", cause),
            ListArchiveRulesError::InternalServer(ref cause) => write!(f, "{}", cause),
            ListArchiveRulesError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListArchiveRulesError {}
/// Errors returned by ListFindings
#[derive(Debug, PartialEq)]
pub enum ListFindingsError {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDenied(String),
    /// <p>Internal server error.</p>
    InternalServer(String),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFound(String),
    /// <p>Throttling limit exceeded error.</p>
    Throttling(String),
}

impl ListFindingsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListFindingsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(ListFindingsError::AccessDenied(err.msg))
                }
                "InternalServerException" => {
                    return RusotoError::Service(ListFindingsError::InternalServer(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(ListFindingsError::ResourceNotFound(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListFindingsError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListFindingsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListFindingsError::AccessDenied(ref cause) => write!(f, "{}", cause),
            ListFindingsError::InternalServer(ref cause) => write!(f, "{}", cause),
            ListFindingsError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            ListFindingsError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListFindingsError {}
/// Errors returned by ListPolicyGenerations
#[derive(Debug, PartialEq)]
pub enum ListPolicyGenerationsError {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDenied(String),
    /// <p>Internal server error.</p>
    InternalServer(String),
    /// <p>Throttling limit exceeded error.</p>
    Throttling(String),
}

impl ListPolicyGenerationsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListPolicyGenerationsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(ListPolicyGenerationsError::AccessDenied(err.msg))
                }
                "InternalServerException" => {
                    return RusotoError::Service(ListPolicyGenerationsError::InternalServer(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListPolicyGenerationsError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListPolicyGenerationsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListPolicyGenerationsError::AccessDenied(ref cause) => write!(f, "{}", cause),
            ListPolicyGenerationsError::InternalServer(ref cause) => write!(f, "{}", cause),
            ListPolicyGenerationsError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListPolicyGenerationsError {}
/// Errors returned by ListTagsForResource
#[derive(Debug, PartialEq)]
pub enum ListTagsForResourceError {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDenied(String),
    /// <p>Internal server error.</p>
    InternalServer(String),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFound(String),
    /// <p>Throttling limit exceeded error.</p>
    Throttling(String),
}

impl ListTagsForResourceError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ListTagsForResourceError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(ListTagsForResourceError::AccessDenied(err.msg))
                }
                "InternalServerException" => {
                    return RusotoError::Service(ListTagsForResourceError::InternalServer(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(ListTagsForResourceError::ResourceNotFound(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ListTagsForResourceError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ListTagsForResourceError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ListTagsForResourceError::AccessDenied(ref cause) => write!(f, "{}", cause),
            ListTagsForResourceError::InternalServer(ref cause) => write!(f, "{}", cause),
            ListTagsForResourceError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            ListTagsForResourceError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ListTagsForResourceError {}
/// Errors returned by StartPolicyGeneration
#[derive(Debug, PartialEq)]
pub enum StartPolicyGenerationError {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDenied(String),
    /// <p>A conflict exception error.</p>
    Conflict(String),
    /// <p>Internal server error.</p>
    InternalServer(String),
    /// <p>Service quote met error.</p>
    ServiceQuotaExceeded(String),
    /// <p>Throttling limit exceeded error.</p>
    Throttling(String),
}

impl StartPolicyGenerationError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<StartPolicyGenerationError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(StartPolicyGenerationError::AccessDenied(err.msg))
                }
                "ConflictException" => {
                    return RusotoError::Service(StartPolicyGenerationError::Conflict(err.msg))
                }
                "InternalServerException" => {
                    return RusotoError::Service(StartPolicyGenerationError::InternalServer(
                        err.msg,
                    ))
                }
                "ServiceQuotaExceededException" => {
                    return RusotoError::Service(StartPolicyGenerationError::ServiceQuotaExceeded(
                        err.msg,
                    ))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(StartPolicyGenerationError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for StartPolicyGenerationError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            StartPolicyGenerationError::AccessDenied(ref cause) => write!(f, "{}", cause),
            StartPolicyGenerationError::Conflict(ref cause) => write!(f, "{}", cause),
            StartPolicyGenerationError::InternalServer(ref cause) => write!(f, "{}", cause),
            StartPolicyGenerationError::ServiceQuotaExceeded(ref cause) => write!(f, "{}", cause),
            StartPolicyGenerationError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for StartPolicyGenerationError {}
/// Errors returned by StartResourceScan
#[derive(Debug, PartialEq)]
pub enum StartResourceScanError {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDenied(String),
    /// <p>Internal server error.</p>
    InternalServer(String),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFound(String),
    /// <p>Throttling limit exceeded error.</p>
    Throttling(String),
}

impl StartResourceScanError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<StartResourceScanError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(StartResourceScanError::AccessDenied(err.msg))
                }
                "InternalServerException" => {
                    return RusotoError::Service(StartResourceScanError::InternalServer(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(StartResourceScanError::ResourceNotFound(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(StartResourceScanError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for StartResourceScanError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            StartResourceScanError::AccessDenied(ref cause) => write!(f, "{}", cause),
            StartResourceScanError::InternalServer(ref cause) => write!(f, "{}", cause),
            StartResourceScanError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            StartResourceScanError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for StartResourceScanError {}
/// Errors returned by TagResource
#[derive(Debug, PartialEq)]
pub enum TagResourceError {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDenied(String),
    /// <p>Internal server error.</p>
    InternalServer(String),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFound(String),
    /// <p>Throttling limit exceeded error.</p>
    Throttling(String),
}

impl TagResourceError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<TagResourceError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(TagResourceError::AccessDenied(err.msg))
                }
                "InternalServerException" => {
                    return RusotoError::Service(TagResourceError::InternalServer(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(TagResourceError::ResourceNotFound(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(TagResourceError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for TagResourceError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            TagResourceError::AccessDenied(ref cause) => write!(f, "{}", cause),
            TagResourceError::InternalServer(ref cause) => write!(f, "{}", cause),
            TagResourceError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            TagResourceError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for TagResourceError {}
/// Errors returned by UntagResource
#[derive(Debug, PartialEq)]
pub enum UntagResourceError {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDenied(String),
    /// <p>Internal server error.</p>
    InternalServer(String),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFound(String),
    /// <p>Throttling limit exceeded error.</p>
    Throttling(String),
}

impl UntagResourceError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<UntagResourceError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(UntagResourceError::AccessDenied(err.msg))
                }
                "InternalServerException" => {
                    return RusotoError::Service(UntagResourceError::InternalServer(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(UntagResourceError::ResourceNotFound(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(UntagResourceError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for UntagResourceError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            UntagResourceError::AccessDenied(ref cause) => write!(f, "{}", cause),
            UntagResourceError::InternalServer(ref cause) => write!(f, "{}", cause),
            UntagResourceError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            UntagResourceError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for UntagResourceError {}
/// Errors returned by UpdateArchiveRule
#[derive(Debug, PartialEq)]
pub enum UpdateArchiveRuleError {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDenied(String),
    /// <p>Internal server error.</p>
    InternalServer(String),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFound(String),
    /// <p>Throttling limit exceeded error.</p>
    Throttling(String),
}

impl UpdateArchiveRuleError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<UpdateArchiveRuleError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(UpdateArchiveRuleError::AccessDenied(err.msg))
                }
                "InternalServerException" => {
                    return RusotoError::Service(UpdateArchiveRuleError::InternalServer(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(UpdateArchiveRuleError::ResourceNotFound(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(UpdateArchiveRuleError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for UpdateArchiveRuleError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            UpdateArchiveRuleError::AccessDenied(ref cause) => write!(f, "{}", cause),
            UpdateArchiveRuleError::InternalServer(ref cause) => write!(f, "{}", cause),
            UpdateArchiveRuleError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            UpdateArchiveRuleError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for UpdateArchiveRuleError {}
/// Errors returned by UpdateFindings
#[derive(Debug, PartialEq)]
pub enum UpdateFindingsError {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDenied(String),
    /// <p>Internal server error.</p>
    InternalServer(String),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFound(String),
    /// <p>Throttling limit exceeded error.</p>
    Throttling(String),
}

impl UpdateFindingsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<UpdateFindingsError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(UpdateFindingsError::AccessDenied(err.msg))
                }
                "InternalServerException" => {
                    return RusotoError::Service(UpdateFindingsError::InternalServer(err.msg))
                }
                "ResourceNotFoundException" => {
                    return RusotoError::Service(UpdateFindingsError::ResourceNotFound(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(UpdateFindingsError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for UpdateFindingsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            UpdateFindingsError::AccessDenied(ref cause) => write!(f, "{}", cause),
            UpdateFindingsError::InternalServer(ref cause) => write!(f, "{}", cause),
            UpdateFindingsError::ResourceNotFound(ref cause) => write!(f, "{}", cause),
            UpdateFindingsError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for UpdateFindingsError {}
/// Errors returned by ValidatePolicy
#[derive(Debug, PartialEq)]
pub enum ValidatePolicyError {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDenied(String),
    /// <p>Internal server error.</p>
    InternalServer(String),
    /// <p>Throttling limit exceeded error.</p>
    Throttling(String),
}

impl ValidatePolicyError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ValidatePolicyError> {
        if let Some(err) = proto::json::Error::parse_rest(&res) {
            match err.typ.as_str() {
                "AccessDeniedException" => {
                    return RusotoError::Service(ValidatePolicyError::AccessDenied(err.msg))
                }
                "InternalServerException" => {
                    return RusotoError::Service(ValidatePolicyError::InternalServer(err.msg))
                }
                "ThrottlingException" => {
                    return RusotoError::Service(ValidatePolicyError::Throttling(err.msg))
                }
                "ValidationException" => return RusotoError::Validation(err.msg),
                _ => {}
            }
        }
        RusotoError::Unknown(res)
    }
}
impl fmt::Display for ValidatePolicyError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ValidatePolicyError::AccessDenied(ref cause) => write!(f, "{}", cause),
            ValidatePolicyError::InternalServer(ref cause) => write!(f, "{}", cause),
            ValidatePolicyError::Throttling(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ValidatePolicyError {}
/// Trait representing the capabilities of the Access Analyzer API. Access Analyzer clients implement this trait.
#[async_trait]
pub trait AccessAnalyzer {
    /// <p>Retroactively applies the archive rule to existing findings that meet the archive rule criteria.</p>
    async fn apply_archive_rule(
        &self,
        input: ApplyArchiveRuleRequest,
    ) -> Result<(), RusotoError<ApplyArchiveRuleError>>;

    /// <p>Cancels the requested policy generation.</p>
    async fn cancel_policy_generation(
        &self,
        input: CancelPolicyGenerationRequest,
    ) -> Result<CancelPolicyGenerationResponse, RusotoError<CancelPolicyGenerationError>>;

    /// <p>Creates an access preview that allows you to preview Access Analyzer findings for your resource before deploying resource permissions.</p>
    async fn create_access_preview(
        &self,
        input: CreateAccessPreviewRequest,
    ) -> Result<CreateAccessPreviewResponse, RusotoError<CreateAccessPreviewError>>;

    /// <p>Creates an analyzer for your account.</p>
    async fn create_analyzer(
        &self,
        input: CreateAnalyzerRequest,
    ) -> Result<CreateAnalyzerResponse, RusotoError<CreateAnalyzerError>>;

    /// <p>Creates an archive rule for the specified analyzer. Archive rules automatically archive new findings that meet the criteria you define when you create the rule.</p> <p>To learn about filter keys that you can use to create an archive rule, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-reference-filter-keys.html">Access Analyzer filter keys</a> in the <b>IAM User Guide</b>.</p>
    async fn create_archive_rule(
        &self,
        input: CreateArchiveRuleRequest,
    ) -> Result<(), RusotoError<CreateArchiveRuleError>>;

    /// <p>Deletes the specified analyzer. When you delete an analyzer, Access Analyzer is disabled for the account or organization in the current or specific Region. All findings that were generated by the analyzer are deleted. You cannot undo this action.</p>
    async fn delete_analyzer(
        &self,
        input: DeleteAnalyzerRequest,
    ) -> Result<(), RusotoError<DeleteAnalyzerError>>;

    /// <p>Deletes the specified archive rule.</p>
    async fn delete_archive_rule(
        &self,
        input: DeleteArchiveRuleRequest,
    ) -> Result<(), RusotoError<DeleteArchiveRuleError>>;

    /// <p>Retrieves information about an access preview for the specified analyzer.</p>
    async fn get_access_preview(
        &self,
        input: GetAccessPreviewRequest,
    ) -> Result<GetAccessPreviewResponse, RusotoError<GetAccessPreviewError>>;

    /// <p>Retrieves information about a resource that was analyzed.</p>
    async fn get_analyzed_resource(
        &self,
        input: GetAnalyzedResourceRequest,
    ) -> Result<GetAnalyzedResourceResponse, RusotoError<GetAnalyzedResourceError>>;

    /// <p>Retrieves information about the specified analyzer.</p>
    async fn get_analyzer(
        &self,
        input: GetAnalyzerRequest,
    ) -> Result<GetAnalyzerResponse, RusotoError<GetAnalyzerError>>;

    /// <p>Retrieves information about an archive rule.</p> <p>To learn about filter keys that you can use to create an archive rule, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-reference-filter-keys.html">Access Analyzer filter keys</a> in the <b>IAM User Guide</b>.</p>
    async fn get_archive_rule(
        &self,
        input: GetArchiveRuleRequest,
    ) -> Result<GetArchiveRuleResponse, RusotoError<GetArchiveRuleError>>;

    /// <p>Retrieves information about the specified finding.</p>
    async fn get_finding(
        &self,
        input: GetFindingRequest,
    ) -> Result<GetFindingResponse, RusotoError<GetFindingError>>;

    /// <p>Retrieves the policy that was generated using <code>StartPolicyGeneration</code>. </p>
    async fn get_generated_policy(
        &self,
        input: GetGeneratedPolicyRequest,
    ) -> Result<GetGeneratedPolicyResponse, RusotoError<GetGeneratedPolicyError>>;

    /// <p>Retrieves a list of access preview findings generated by the specified access preview.</p>
    async fn list_access_preview_findings(
        &self,
        input: ListAccessPreviewFindingsRequest,
    ) -> Result<ListAccessPreviewFindingsResponse, RusotoError<ListAccessPreviewFindingsError>>;

    /// <p>Retrieves a list of access previews for the specified analyzer.</p>
    async fn list_access_previews(
        &self,
        input: ListAccessPreviewsRequest,
    ) -> Result<ListAccessPreviewsResponse, RusotoError<ListAccessPreviewsError>>;

    /// <p>Retrieves a list of resources of the specified type that have been analyzed by the specified analyzer..</p>
    async fn list_analyzed_resources(
        &self,
        input: ListAnalyzedResourcesRequest,
    ) -> Result<ListAnalyzedResourcesResponse, RusotoError<ListAnalyzedResourcesError>>;

    /// <p>Retrieves a list of analyzers.</p>
    async fn list_analyzers(
        &self,
        input: ListAnalyzersRequest,
    ) -> Result<ListAnalyzersResponse, RusotoError<ListAnalyzersError>>;

    /// <p>Retrieves a list of archive rules created for the specified analyzer.</p>
    async fn list_archive_rules(
        &self,
        input: ListArchiveRulesRequest,
    ) -> Result<ListArchiveRulesResponse, RusotoError<ListArchiveRulesError>>;

    /// <p>Retrieves a list of findings generated by the specified analyzer.</p> <p>To learn about filter keys that you can use to retrieve a list of findings, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-reference-filter-keys.html">Access Analyzer filter keys</a> in the <b>IAM User Guide</b>.</p>
    async fn list_findings(
        &self,
        input: ListFindingsRequest,
    ) -> Result<ListFindingsResponse, RusotoError<ListFindingsError>>;

    /// <p>Lists all of the policy generations requested in the last seven days.</p>
    async fn list_policy_generations(
        &self,
        input: ListPolicyGenerationsRequest,
    ) -> Result<ListPolicyGenerationsResponse, RusotoError<ListPolicyGenerationsError>>;

    /// <p>Retrieves a list of tags applied to the specified resource.</p>
    async fn list_tags_for_resource(
        &self,
        input: ListTagsForResourceRequest,
    ) -> Result<ListTagsForResourceResponse, RusotoError<ListTagsForResourceError>>;

    /// <p>Starts the policy generation request.</p>
    async fn start_policy_generation(
        &self,
        input: StartPolicyGenerationRequest,
    ) -> Result<StartPolicyGenerationResponse, RusotoError<StartPolicyGenerationError>>;

    /// <p>Immediately starts a scan of the policies applied to the specified resource.</p>
    async fn start_resource_scan(
        &self,
        input: StartResourceScanRequest,
    ) -> Result<(), RusotoError<StartResourceScanError>>;

    /// <p>Adds a tag to the specified resource.</p>
    async fn tag_resource(
        &self,
        input: TagResourceRequest,
    ) -> Result<TagResourceResponse, RusotoError<TagResourceError>>;

    /// <p>Removes a tag from the specified resource.</p>
    async fn untag_resource(
        &self,
        input: UntagResourceRequest,
    ) -> Result<UntagResourceResponse, RusotoError<UntagResourceError>>;

    /// <p>Updates the criteria and values for the specified archive rule.</p>
    async fn update_archive_rule(
        &self,
        input: UpdateArchiveRuleRequest,
    ) -> Result<(), RusotoError<UpdateArchiveRuleError>>;

    /// <p>Updates the status for the specified findings.</p>
    async fn update_findings(
        &self,
        input: UpdateFindingsRequest,
    ) -> Result<(), RusotoError<UpdateFindingsError>>;

    /// <p>Requests the validation of a policy and returns a list of findings. The findings help you identify issues and provide actionable recommendations to resolve the issue and enable you to author functional policies that meet security best practices. </p>
    async fn validate_policy(
        &self,
        input: ValidatePolicyRequest,
    ) -> Result<ValidatePolicyResponse, RusotoError<ValidatePolicyError>>;
}
/// A client for the Access Analyzer API.
#[derive(Clone)]
pub struct AccessAnalyzerClient {
    client: Client,
    region: region::Region,
}

impl AccessAnalyzerClient {
    /// Creates a client backed by the default tokio event loop.
    ///
    /// The client will use the default credentials provider and tls client.
    pub fn new(region: region::Region) -> AccessAnalyzerClient {
        AccessAnalyzerClient {
            client: Client::shared(),
            region,
        }
    }

    pub fn new_with<P, D>(
        request_dispatcher: D,
        credentials_provider: P,
        region: region::Region,
    ) -> AccessAnalyzerClient
    where
        P: ProvideAwsCredentials + Send + Sync + 'static,
        D: DispatchSignedRequest + Send + Sync + 'static,
    {
        AccessAnalyzerClient {
            client: Client::new_with(credentials_provider, request_dispatcher),
            region,
        }
    }

    pub fn new_with_client(client: Client, region: region::Region) -> AccessAnalyzerClient {
        AccessAnalyzerClient { client, region }
    }
}

#[async_trait]
impl AccessAnalyzer for AccessAnalyzerClient {
    /// <p>Retroactively applies the archive rule to existing findings that meet the archive rule criteria.</p>
    #[allow(unused_mut)]
    async fn apply_archive_rule(
        &self,
        input: ApplyArchiveRuleRequest,
    ) -> Result<(), RusotoError<ApplyArchiveRuleError>> {
        let request_uri = "/archive-rule";

        let mut request = SignedRequest::new("PUT", "access-analyzer", &self.region, &request_uri);
        request.set_content_type("application/x-amz-json-1.1".to_owned());

        let encoded = Some(serde_json::to_vec(&input).unwrap());
        request.set_payload(encoded);

        let mut response = self
            .client
            .sign_and_dispatch(request)
            .await
            .map_err(RusotoError::from)?;
        if response.status.as_u16() == 200 {
            let mut response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            let result = ::std::mem::drop(response);

            Ok(result)
        } else {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            Err(ApplyArchiveRuleError::from_response(response))
        }
    }

    /// <p>Cancels the requested policy generation.</p>
    #[allow(unused_mut)]
    async fn cancel_policy_generation(
        &self,
        input: CancelPolicyGenerationRequest,
    ) -> Result<CancelPolicyGenerationResponse, RusotoError<CancelPolicyGenerationError>> {
        let request_uri = format!("/policy/generation/{job_id}", job_id = input.job_id);

        let mut request = SignedRequest::new("PUT", "access-analyzer", &self.region, &request_uri);
        request.set_content_type("application/x-amz-json-1.1".to_owned());

        let mut response = self
            .client
            .sign_and_dispatch(request)
            .await
            .map_err(RusotoError::from)?;
        if response.status.as_u16() == 200 {
            let mut response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            let result = proto::json::ResponsePayload::new(&response)
                .deserialize::<CancelPolicyGenerationResponse, _>()?;

            Ok(result)
        } else {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            Err(CancelPolicyGenerationError::from_response(response))
        }
    }

    /// <p>Creates an access preview that allows you to preview Access Analyzer findings for your resource before deploying resource permissions.</p>
    #[allow(unused_mut)]
    async fn create_access_preview(
        &self,
        input: CreateAccessPreviewRequest,
    ) -> Result<CreateAccessPreviewResponse, RusotoError<CreateAccessPreviewError>> {
        let request_uri = "/access-preview";

        let mut request = SignedRequest::new("PUT", "access-analyzer", &self.region, &request_uri);
        request.set_content_type("application/x-amz-json-1.1".to_owned());

        let encoded = Some(serde_json::to_vec(&input).unwrap());
        request.set_payload(encoded);

        let mut response = self
            .client
            .sign_and_dispatch(request)
            .await
            .map_err(RusotoError::from)?;
        if response.status.as_u16() == 200 {
            let mut response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            let result = proto::json::ResponsePayload::new(&response)
                .deserialize::<CreateAccessPreviewResponse, _>()?;

            Ok(result)
        } else {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            Err(CreateAccessPreviewError::from_response(response))
        }
    }

    /// <p>Creates an analyzer for your account.</p>
    #[allow(unused_mut)]
    async fn create_analyzer(
        &self,
        input: CreateAnalyzerRequest,
    ) -> Result<CreateAnalyzerResponse, RusotoError<CreateAnalyzerError>> {
        let request_uri = "/analyzer";

        let mut request = SignedRequest::new("PUT", "access-analyzer", &self.region, &request_uri);
        request.set_content_type("application/x-amz-json-1.1".to_owned());

        let encoded = Some(serde_json::to_vec(&input).unwrap());
        request.set_payload(encoded);

        let mut response = self
            .client
            .sign_and_dispatch(request)
            .await
            .map_err(RusotoError::from)?;
        if response.status.as_u16() == 200 {
            let mut response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            let result = proto::json::ResponsePayload::new(&response)
                .deserialize::<CreateAnalyzerResponse, _>()?;

            Ok(result)
        } else {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            Err(CreateAnalyzerError::from_response(response))
        }
    }

    /// <p>Creates an archive rule for the specified analyzer. Archive rules automatically archive new findings that meet the criteria you define when you create the rule.</p> <p>To learn about filter keys that you can use to create an archive rule, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-reference-filter-keys.html">Access Analyzer filter keys</a> in the <b>IAM User Guide</b>.</p>
    #[allow(unused_mut)]
    async fn create_archive_rule(
        &self,
        input: CreateArchiveRuleRequest,
    ) -> Result<(), RusotoError<CreateArchiveRuleError>> {
        let request_uri = format!(
            "/analyzer/{analyzer_name}/archive-rule",
            analyzer_name = input.analyzer_name
        );

        let mut request = SignedRequest::new("PUT", "access-analyzer", &self.region, &request_uri);
        request.set_content_type("application/x-amz-json-1.1".to_owned());

        let encoded = Some(serde_json::to_vec(&input).unwrap());
        request.set_payload(encoded);

        let mut response = self
            .client
            .sign_and_dispatch(request)
            .await
            .map_err(RusotoError::from)?;
        if response.status.as_u16() == 200 {
            let mut response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            let result = ::std::mem::drop(response);

            Ok(result)
        } else {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            Err(CreateArchiveRuleError::from_response(response))
        }
    }

    /// <p>Deletes the specified analyzer. When you delete an analyzer, Access Analyzer is disabled for the account or organization in the current or specific Region. All findings that were generated by the analyzer are deleted. You cannot undo this action.</p>
    #[allow(unused_mut)]
    async fn delete_analyzer(
        &self,
        input: DeleteAnalyzerRequest,
    ) -> Result<(), RusotoError<DeleteAnalyzerError>> {
        let request_uri = format!(
            "/analyzer/{analyzer_name}",
            analyzer_name = input.analyzer_name
        );

        let mut request =
            SignedRequest::new("DELETE", "access-analyzer", &self.region, &request_uri);
        request.set_content_type("application/x-amz-json-1.1".to_owned());

        let mut params = Params::new();
        if let Some(ref x) = input.client_token {
            params.put("clientToken", x);
        }
        request.set_params(params);

        let mut response = self
            .client
            .sign_and_dispatch(request)
            .await
            .map_err(RusotoError::from)?;
        if response.status.as_u16() == 200 {
            let mut response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            let result = ::std::mem::drop(response);

            Ok(result)
        } else {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            Err(DeleteAnalyzerError::from_response(response))
        }
    }

    /// <p>Deletes the specified archive rule.</p>
    #[allow(unused_mut)]
    async fn delete_archive_rule(
        &self,
        input: DeleteArchiveRuleRequest,
    ) -> Result<(), RusotoError<DeleteArchiveRuleError>> {
        let request_uri = format!(
            "/analyzer/{analyzer_name}/archive-rule/{rule_name}",
            analyzer_name = input.analyzer_name,
            rule_name = input.rule_name
        );

        let mut request =
            SignedRequest::new("DELETE", "access-analyzer", &self.region, &request_uri);
        request.set_content_type("application/x-amz-json-1.1".to_owned());

        let mut params = Params::new();
        if let Some(ref x) = input.client_token {
            params.put("clientToken", x);
        }
        request.set_params(params);

        let mut response = self
            .client
            .sign_and_dispatch(request)
            .await
            .map_err(RusotoError::from)?;
        if response.status.as_u16() == 200 {
            let mut response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            let result = ::std::mem::drop(response);

            Ok(result)
        } else {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            Err(DeleteArchiveRuleError::from_response(response))
        }
    }

    /// <p>Retrieves information about an access preview for the specified analyzer.</p>
    #[allow(unused_mut)]
    async fn get_access_preview(
        &self,
        input: GetAccessPreviewRequest,
    ) -> Result<GetAccessPreviewResponse, RusotoError<GetAccessPreviewError>> {
        let request_uri = format!(
            "/access-preview/{access_preview_id}",
            access_preview_id = input.access_preview_id
        );

        let mut request = SignedRequest::new("GET", "access-analyzer", &self.region, &request_uri);
        request.set_content_type("application/x-amz-json-1.1".to_owned());

        let mut params = Params::new();
        params.put("analyzerArn", &input.analyzer_arn);
        request.set_params(params);

        let mut response = self
            .client
            .sign_and_dispatch(request)
            .await
            .map_err(RusotoError::from)?;
        if response.status.as_u16() == 200 {
            let mut response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            let result = proto::json::ResponsePayload::new(&response)
                .deserialize::<GetAccessPreviewResponse, _>()?;

            Ok(result)
        } else {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            Err(GetAccessPreviewError::from_response(response))
        }
    }

    /// <p>Retrieves information about a resource that was analyzed.</p>
    #[allow(unused_mut)]
    async fn get_analyzed_resource(
        &self,
        input: GetAnalyzedResourceRequest,
    ) -> Result<GetAnalyzedResourceResponse, RusotoError<GetAnalyzedResourceError>> {
        let request_uri = "/analyzed-resource";

        let mut request = SignedRequest::new("GET", "access-analyzer", &self.region, &request_uri);
        request.set_content_type("application/x-amz-json-1.1".to_owned());

        let mut params = Params::new();
        params.put("analyzerArn", &input.analyzer_arn);
        params.put("resourceArn", &input.resource_arn);
        request.set_params(params);

        let mut response = self
            .client
            .sign_and_dispatch(request)
            .await
            .map_err(RusotoError::from)?;
        if response.status.as_u16() == 200 {
            let mut response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            let result = proto::json::ResponsePayload::new(&response)
                .deserialize::<GetAnalyzedResourceResponse, _>()?;

            Ok(result)
        } else {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            Err(GetAnalyzedResourceError::from_response(response))
        }
    }

    /// <p>Retrieves information about the specified analyzer.</p>
    #[allow(unused_mut)]
    async fn get_analyzer(
        &self,
        input: GetAnalyzerRequest,
    ) -> Result<GetAnalyzerResponse, RusotoError<GetAnalyzerError>> {
        let request_uri = format!(
            "/analyzer/{analyzer_name}",
            analyzer_name = input.analyzer_name
        );

        let mut request = SignedRequest::new("GET", "access-analyzer", &self.region, &request_uri);
        request.set_content_type("application/x-amz-json-1.1".to_owned());

        let mut response = self
            .client
            .sign_and_dispatch(request)
            .await
            .map_err(RusotoError::from)?;
        if response.status.as_u16() == 200 {
            let mut response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            let result = proto::json::ResponsePayload::new(&response)
                .deserialize::<GetAnalyzerResponse, _>()?;

            Ok(result)
        } else {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            Err(GetAnalyzerError::from_response(response))
        }
    }

    /// <p>Retrieves information about an archive rule.</p> <p>To learn about filter keys that you can use to create an archive rule, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-reference-filter-keys.html">Access Analyzer filter keys</a> in the <b>IAM User Guide</b>.</p>
    #[allow(unused_mut)]
    async fn get_archive_rule(
        &self,
        input: GetArchiveRuleRequest,
    ) -> Result<GetArchiveRuleResponse, RusotoError<GetArchiveRuleError>> {
        let request_uri = format!(
            "/analyzer/{analyzer_name}/archive-rule/{rule_name}",
            analyzer_name = input.analyzer_name,
            rule_name = input.rule_name
        );

        let mut request = SignedRequest::new("GET", "access-analyzer", &self.region, &request_uri);
        request.set_content_type("application/x-amz-json-1.1".to_owned());

        let mut response = self
            .client
            .sign_and_dispatch(request)
            .await
            .map_err(RusotoError::from)?;
        if response.status.as_u16() == 200 {
            let mut response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            let result = proto::json::ResponsePayload::new(&response)
                .deserialize::<GetArchiveRuleResponse, _>()?;

            Ok(result)
        } else {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            Err(GetArchiveRuleError::from_response(response))
        }
    }

    /// <p>Retrieves information about the specified finding.</p>
    #[allow(unused_mut)]
    async fn get_finding(
        &self,
        input: GetFindingRequest,
    ) -> Result<GetFindingResponse, RusotoError<GetFindingError>> {
        let request_uri = format!("/finding/{id}", id = input.id);

        let mut request = SignedRequest::new("GET", "access-analyzer", &self.region, &request_uri);
        request.set_content_type("application/x-amz-json-1.1".to_owned());

        let mut params = Params::new();
        params.put("analyzerArn", &input.analyzer_arn);
        request.set_params(params);

        let mut response = self
            .client
            .sign_and_dispatch(request)
            .await
            .map_err(RusotoError::from)?;
        if response.status.as_u16() == 200 {
            let mut response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            let result = proto::json::ResponsePayload::new(&response)
                .deserialize::<GetFindingResponse, _>()?;

            Ok(result)
        } else {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            Err(GetFindingError::from_response(response))
        }
    }

    /// <p>Retrieves the policy that was generated using <code>StartPolicyGeneration</code>. </p>
    #[allow(unused_mut)]
    async fn get_generated_policy(
        &self,
        input: GetGeneratedPolicyRequest,
    ) -> Result<GetGeneratedPolicyResponse, RusotoError<GetGeneratedPolicyError>> {
        let request_uri = format!("/policy/generation/{job_id}", job_id = input.job_id);

        let mut request = SignedRequest::new("GET", "access-analyzer", &self.region, &request_uri);
        request.set_content_type("application/x-amz-json-1.1".to_owned());

        let mut params = Params::new();
        if let Some(ref x) = input.include_resource_placeholders {
            params.put("includeResourcePlaceholders", x);
        }
        if let Some(ref x) = input.include_service_level_template {
            params.put("includeServiceLevelTemplate", x);
        }
        request.set_params(params);

        let mut response = self
            .client
            .sign_and_dispatch(request)
            .await
            .map_err(RusotoError::from)?;
        if response.status.as_u16() == 200 {
            let mut response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            let result = proto::json::ResponsePayload::new(&response)
                .deserialize::<GetGeneratedPolicyResponse, _>()?;

            Ok(result)
        } else {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            Err(GetGeneratedPolicyError::from_response(response))
        }
    }

    /// <p>Retrieves a list of access preview findings generated by the specified access preview.</p>
    #[allow(unused_mut)]
    async fn list_access_preview_findings(
        &self,
        input: ListAccessPreviewFindingsRequest,
    ) -> Result<ListAccessPreviewFindingsResponse, RusotoError<ListAccessPreviewFindingsError>>
    {
        let request_uri = format!(
            "/access-preview/{access_preview_id}",
            access_preview_id = input.access_preview_id
        );

        let mut request = SignedRequest::new("POST", "access-analyzer", &self.region, &request_uri);
        request.set_content_type("application/x-amz-json-1.1".to_owned());

        let encoded = Some(serde_json::to_vec(&input).unwrap());
        request.set_payload(encoded);

        let mut response = self
            .client
            .sign_and_dispatch(request)
            .await
            .map_err(RusotoError::from)?;
        if response.status.as_u16() == 200 {
            let mut response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            let result = proto::json::ResponsePayload::new(&response)
                .deserialize::<ListAccessPreviewFindingsResponse, _>()?;

            Ok(result)
        } else {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            Err(ListAccessPreviewFindingsError::from_response(response))
        }
    }

    /// <p>Retrieves a list of access previews for the specified analyzer.</p>
    #[allow(unused_mut)]
    async fn list_access_previews(
        &self,
        input: ListAccessPreviewsRequest,
    ) -> Result<ListAccessPreviewsResponse, RusotoError<ListAccessPreviewsError>> {
        let request_uri = "/access-preview";

        let mut request = SignedRequest::new("GET", "access-analyzer", &self.region, &request_uri);
        request.set_content_type("application/x-amz-json-1.1".to_owned());

        let mut params = Params::new();
        params.put("analyzerArn", &input.analyzer_arn);
        if let Some(ref x) = input.max_results {
            params.put("maxResults", x);
        }
        if let Some(ref x) = input.next_token {
            params.put("nextToken", x);
        }
        request.set_params(params);

        let mut response = self
            .client
            .sign_and_dispatch(request)
            .await
            .map_err(RusotoError::from)?;
        if response.status.as_u16() == 200 {
            let mut response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            let result = proto::json::ResponsePayload::new(&response)
                .deserialize::<ListAccessPreviewsResponse, _>()?;

            Ok(result)
        } else {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            Err(ListAccessPreviewsError::from_response(response))
        }
    }

    /// <p>Retrieves a list of resources of the specified type that have been analyzed by the specified analyzer..</p>
    #[allow(unused_mut)]
    async fn list_analyzed_resources(
        &self,
        input: ListAnalyzedResourcesRequest,
    ) -> Result<ListAnalyzedResourcesResponse, RusotoError<ListAnalyzedResourcesError>> {
        let request_uri = "/analyzed-resource";

        let mut request = SignedRequest::new("POST", "access-analyzer", &self.region, &request_uri);
        request.set_content_type("application/x-amz-json-1.1".to_owned());

        let encoded = Some(serde_json::to_vec(&input).unwrap());
        request.set_payload(encoded);

        let mut response = self
            .client
            .sign_and_dispatch(request)
            .await
            .map_err(RusotoError::from)?;
        if response.status.as_u16() == 200 {
            let mut response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            let result = proto::json::ResponsePayload::new(&response)
                .deserialize::<ListAnalyzedResourcesResponse, _>()?;

            Ok(result)
        } else {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            Err(ListAnalyzedResourcesError::from_response(response))
        }
    }

    /// <p>Retrieves a list of analyzers.</p>
    #[allow(unused_mut)]
    async fn list_analyzers(
        &self,
        input: ListAnalyzersRequest,
    ) -> Result<ListAnalyzersResponse, RusotoError<ListAnalyzersError>> {
        let request_uri = "/analyzer";

        let mut request = SignedRequest::new("GET", "access-analyzer", &self.region, &request_uri);
        request.set_content_type("application/x-amz-json-1.1".to_owned());

        let mut params = Params::new();
        if let Some(ref x) = input.max_results {
            params.put("maxResults", x);
        }
        if let Some(ref x) = input.next_token {
            params.put("nextToken", x);
        }
        if let Some(ref x) = input.type_ {
            params.put("type", x);
        }
        request.set_params(params);

        let mut response = self
            .client
            .sign_and_dispatch(request)
            .await
            .map_err(RusotoError::from)?;
        if response.status.as_u16() == 200 {
            let mut response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            let result = proto::json::ResponsePayload::new(&response)
                .deserialize::<ListAnalyzersResponse, _>()?;

            Ok(result)
        } else {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            Err(ListAnalyzersError::from_response(response))
        }
    }

    /// <p>Retrieves a list of archive rules created for the specified analyzer.</p>
    #[allow(unused_mut)]
    async fn list_archive_rules(
        &self,
        input: ListArchiveRulesRequest,
    ) -> Result<ListArchiveRulesResponse, RusotoError<ListArchiveRulesError>> {
        let request_uri = format!(
            "/analyzer/{analyzer_name}/archive-rule",
            analyzer_name = input.analyzer_name
        );

        let mut request = SignedRequest::new("GET", "access-analyzer", &self.region, &request_uri);
        request.set_content_type("application/x-amz-json-1.1".to_owned());

        let mut params = Params::new();
        if let Some(ref x) = input.max_results {
            params.put("maxResults", x);
        }
        if let Some(ref x) = input.next_token {
            params.put("nextToken", x);
        }
        request.set_params(params);

        let mut response = self
            .client
            .sign_and_dispatch(request)
            .await
            .map_err(RusotoError::from)?;
        if response.status.as_u16() == 200 {
            let mut response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            let result = proto::json::ResponsePayload::new(&response)
                .deserialize::<ListArchiveRulesResponse, _>()?;

            Ok(result)
        } else {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            Err(ListArchiveRulesError::from_response(response))
        }
    }

    /// <p>Retrieves a list of findings generated by the specified analyzer.</p> <p>To learn about filter keys that you can use to retrieve a list of findings, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-reference-filter-keys.html">Access Analyzer filter keys</a> in the <b>IAM User Guide</b>.</p>
    #[allow(unused_mut)]
    async fn list_findings(
        &self,
        input: ListFindingsRequest,
    ) -> Result<ListFindingsResponse, RusotoError<ListFindingsError>> {
        let request_uri = "/finding";

        let mut request = SignedRequest::new("POST", "access-analyzer", &self.region, &request_uri);
        request.set_content_type("application/x-amz-json-1.1".to_owned());

        let encoded = Some(serde_json::to_vec(&input).unwrap());
        request.set_payload(encoded);

        let mut response = self
            .client
            .sign_and_dispatch(request)
            .await
            .map_err(RusotoError::from)?;
        if response.status.as_u16() == 200 {
            let mut response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            let result = proto::json::ResponsePayload::new(&response)
                .deserialize::<ListFindingsResponse, _>()?;

            Ok(result)
        } else {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            Err(ListFindingsError::from_response(response))
        }
    }

    /// <p>Lists all of the policy generations requested in the last seven days.</p>
    #[allow(unused_mut)]
    async fn list_policy_generations(
        &self,
        input: ListPolicyGenerationsRequest,
    ) -> Result<ListPolicyGenerationsResponse, RusotoError<ListPolicyGenerationsError>> {
        let request_uri = "/policy/generation";

        let mut request = SignedRequest::new("GET", "access-analyzer", &self.region, &request_uri);
        request.set_content_type("application/x-amz-json-1.1".to_owned());

        let mut params = Params::new();
        if let Some(ref x) = input.max_results {
            params.put("maxResults", x);
        }
        if let Some(ref x) = input.next_token {
            params.put("nextToken", x);
        }
        if let Some(ref x) = input.principal_arn {
            params.put("principalArn", x);
        }
        request.set_params(params);

        let mut response = self
            .client
            .sign_and_dispatch(request)
            .await
            .map_err(RusotoError::from)?;
        if response.status.as_u16() == 200 {
            let mut response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            let result = proto::json::ResponsePayload::new(&response)
                .deserialize::<ListPolicyGenerationsResponse, _>()?;

            Ok(result)
        } else {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            Err(ListPolicyGenerationsError::from_response(response))
        }
    }

    /// <p>Retrieves a list of tags applied to the specified resource.</p>
    #[allow(unused_mut)]
    async fn list_tags_for_resource(
        &self,
        input: ListTagsForResourceRequest,
    ) -> Result<ListTagsForResourceResponse, RusotoError<ListTagsForResourceError>> {
        let request_uri = format!("/tags/{resource_arn}", resource_arn = input.resource_arn);

        let mut request = SignedRequest::new("GET", "access-analyzer", &self.region, &request_uri);
        request.set_content_type("application/x-amz-json-1.1".to_owned());

        let mut response = self
            .client
            .sign_and_dispatch(request)
            .await
            .map_err(RusotoError::from)?;
        if response.status.as_u16() == 200 {
            let mut response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            let result = proto::json::ResponsePayload::new(&response)
                .deserialize::<ListTagsForResourceResponse, _>()?;

            Ok(result)
        } else {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            Err(ListTagsForResourceError::from_response(response))
        }
    }

    /// <p>Starts the policy generation request.</p>
    #[allow(unused_mut)]
    async fn start_policy_generation(
        &self,
        input: StartPolicyGenerationRequest,
    ) -> Result<StartPolicyGenerationResponse, RusotoError<StartPolicyGenerationError>> {
        let request_uri = "/policy/generation";

        let mut request = SignedRequest::new("PUT", "access-analyzer", &self.region, &request_uri);
        request.set_content_type("application/x-amz-json-1.1".to_owned());

        let encoded = Some(serde_json::to_vec(&input).unwrap());
        request.set_payload(encoded);

        let mut response = self
            .client
            .sign_and_dispatch(request)
            .await
            .map_err(RusotoError::from)?;
        if response.status.as_u16() == 200 {
            let mut response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            let result = proto::json::ResponsePayload::new(&response)
                .deserialize::<StartPolicyGenerationResponse, _>()?;

            Ok(result)
        } else {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            Err(StartPolicyGenerationError::from_response(response))
        }
    }

    /// <p>Immediately starts a scan of the policies applied to the specified resource.</p>
    #[allow(unused_mut)]
    async fn start_resource_scan(
        &self,
        input: StartResourceScanRequest,
    ) -> Result<(), RusotoError<StartResourceScanError>> {
        let request_uri = "/resource/scan";

        let mut request = SignedRequest::new("POST", "access-analyzer", &self.region, &request_uri);
        request.set_content_type("application/x-amz-json-1.1".to_owned());

        let encoded = Some(serde_json::to_vec(&input).unwrap());
        request.set_payload(encoded);

        let mut response = self
            .client
            .sign_and_dispatch(request)
            .await
            .map_err(RusotoError::from)?;
        if response.status.as_u16() == 200 {
            let mut response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            let result = ::std::mem::drop(response);

            Ok(result)
        } else {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            Err(StartResourceScanError::from_response(response))
        }
    }

    /// <p>Adds a tag to the specified resource.</p>
    #[allow(unused_mut)]
    async fn tag_resource(
        &self,
        input: TagResourceRequest,
    ) -> Result<TagResourceResponse, RusotoError<TagResourceError>> {
        let request_uri = format!("/tags/{resource_arn}", resource_arn = input.resource_arn);

        let mut request = SignedRequest::new("POST", "access-analyzer", &self.region, &request_uri);
        request.set_content_type("application/x-amz-json-1.1".to_owned());

        let encoded = Some(serde_json::to_vec(&input).unwrap());
        request.set_payload(encoded);

        let mut response = self
            .client
            .sign_and_dispatch(request)
            .await
            .map_err(RusotoError::from)?;
        if response.status.as_u16() == 200 {
            let mut response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            let result = proto::json::ResponsePayload::new(&response)
                .deserialize::<TagResourceResponse, _>()?;

            Ok(result)
        } else {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            Err(TagResourceError::from_response(response))
        }
    }

    /// <p>Removes a tag from the specified resource.</p>
    #[allow(unused_mut)]
    async fn untag_resource(
        &self,
        input: UntagResourceRequest,
    ) -> Result<UntagResourceResponse, RusotoError<UntagResourceError>> {
        let request_uri = format!("/tags/{resource_arn}", resource_arn = input.resource_arn);

        let mut request =
            SignedRequest::new("DELETE", "access-analyzer", &self.region, &request_uri);
        request.set_content_type("application/x-amz-json-1.1".to_owned());

        let mut params = Params::new();
        for item in input.tag_keys.iter() {
            params.put("tagKeys", item);
        }
        request.set_params(params);

        let mut response = self
            .client
            .sign_and_dispatch(request)
            .await
            .map_err(RusotoError::from)?;
        if response.status.as_u16() == 200 {
            let mut response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            let result = proto::json::ResponsePayload::new(&response)
                .deserialize::<UntagResourceResponse, _>()?;

            Ok(result)
        } else {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            Err(UntagResourceError::from_response(response))
        }
    }

    /// <p>Updates the criteria and values for the specified archive rule.</p>
    #[allow(unused_mut)]
    async fn update_archive_rule(
        &self,
        input: UpdateArchiveRuleRequest,
    ) -> Result<(), RusotoError<UpdateArchiveRuleError>> {
        let request_uri = format!(
            "/analyzer/{analyzer_name}/archive-rule/{rule_name}",
            analyzer_name = input.analyzer_name,
            rule_name = input.rule_name
        );

        let mut request = SignedRequest::new("PUT", "access-analyzer", &self.region, &request_uri);
        request.set_content_type("application/x-amz-json-1.1".to_owned());

        let encoded = Some(serde_json::to_vec(&input).unwrap());
        request.set_payload(encoded);

        let mut response = self
            .client
            .sign_and_dispatch(request)
            .await
            .map_err(RusotoError::from)?;
        if response.status.as_u16() == 200 {
            let mut response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            let result = ::std::mem::drop(response);

            Ok(result)
        } else {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            Err(UpdateArchiveRuleError::from_response(response))
        }
    }

    /// <p>Updates the status for the specified findings.</p>
    #[allow(unused_mut)]
    async fn update_findings(
        &self,
        input: UpdateFindingsRequest,
    ) -> Result<(), RusotoError<UpdateFindingsError>> {
        let request_uri = "/finding";

        let mut request = SignedRequest::new("PUT", "access-analyzer", &self.region, &request_uri);
        request.set_content_type("application/x-amz-json-1.1".to_owned());

        let encoded = Some(serde_json::to_vec(&input).unwrap());
        request.set_payload(encoded);

        let mut response = self
            .client
            .sign_and_dispatch(request)
            .await
            .map_err(RusotoError::from)?;
        if response.status.as_u16() == 200 {
            let mut response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            let result = ::std::mem::drop(response);

            Ok(result)
        } else {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            Err(UpdateFindingsError::from_response(response))
        }
    }

    /// <p>Requests the validation of a policy and returns a list of findings. The findings help you identify issues and provide actionable recommendations to resolve the issue and enable you to author functional policies that meet security best practices. </p>
    #[allow(unused_mut)]
    async fn validate_policy(
        &self,
        input: ValidatePolicyRequest,
    ) -> Result<ValidatePolicyResponse, RusotoError<ValidatePolicyError>> {
        let request_uri = "/policy/validation";

        let mut request = SignedRequest::new("POST", "access-analyzer", &self.region, &request_uri);
        request.set_content_type("application/x-amz-json-1.1".to_owned());

        let encoded = Some(serde_json::to_vec(&input).unwrap());
        request.set_payload(encoded);

        let mut params = Params::new();
        if let Some(ref x) = input.max_results {
            params.put("maxResults", x);
        }
        if let Some(ref x) = input.next_token {
            params.put("nextToken", x);
        }
        request.set_params(params);

        let mut response = self
            .client
            .sign_and_dispatch(request)
            .await
            .map_err(RusotoError::from)?;
        if response.status.as_u16() == 200 {
            let mut response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            let result = proto::json::ResponsePayload::new(&response)
                .deserialize::<ValidatePolicyResponse, _>()?;

            Ok(result)
        } else {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            Err(ValidatePolicyError::from_response(response))
        }
    }
}
