mod kubernetes;

use clap::{App, Arg};

fn main() {
    let runner = App::new("Runner")
        .version("0.1")
        .author("Frank Z.")
        .about("Infrastructure as Code for Kubernetes")
        .arg(
            Arg::with_name("init")
                .long("init")
                .help("Initialize a new Runner project")
        )
        .arg(
            Arg::with_name("run")
                .long("run")
                .help("Run the application")
        )
        .get_matches();
    if runner.is_present("init") {
        println!("Initializing Runner")
    }
    if runner.is_present("run") {
        println!("Running Runner")
    }
}

//fn group_types() {
//    let resources: Vec<Types> = vec![
//        Types::Deployment(test_deployment::test_deployment()),
//        Types::Service(test_deployment::test_service()),
//        Types::Namespace(test_namespace::test_namespace()),
//    ];
//
//    serialize(resources);
//}

//fn serialize(resource: Vec<Types>) {
//    let serialize_resource = serde_json::to_string_pretty(&resource).unwrap();
//    println!("{}", serialize_resource)
//}
