use serde::{Serialize, Deserialize};
use crate::kubernetes::metadata::Metadata;
use std::collections::HashMap;

#[derive(Serialize, Deserialize, Debug)]
#[serde(rename_all = "camelCase")]
pub struct Service {
    pub api_version: String,
    pub kind: String,
    pub metadata: Metadata,
    pub spec: ServiceSpec,
}
#[derive(Serialize, Deserialize, Debug)]
pub struct ServiceSpec {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub selector: Option<Vec<HashMap<String, String>>>,
    #[serde(skip_serializing_if = "Option::is_none")]
    pub ports: Option<Vec<Ports>>
}
#[derive(Serialize, Deserialize, Debug)]
#[serde(rename_all = "camelCase")]
pub struct Ports {
    pub name: String,
    pub port: u32,
    pub target_port: u32,
}