use serde::{Serialize, Deserialize};
use crate::kubernetes::metadata::Metadata;
use std::collections::HashMap;

#[derive(Serialize, Deserialize, Debug)]
#[serde(rename_all = "camelCase")]
pub struct Deployment {
    pub api_version: String,
    pub kind: String,
    pub metadata: Metadata,
    pub spec: Spec,
}
#[derive(Serialize, Deserialize, Debug)]
pub struct Spec {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub selector: Option<Selector>,
    pub template: Template,
}
#[derive(Serialize, Deserialize, Debug)]
#[serde(rename_all = "camelCase")]
pub struct Selector {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub match_labels: Option<HashMap<String, String>>,
}
#[derive(Serialize, Deserialize, Debug)]
pub struct Template {
    pub metadata: Metadata,
    pub spec: PodSpec,
}
#[derive(Serialize, Deserialize, Debug)]
pub struct PodSpec {
    pub containers: Vec<Containers>,
}
#[derive(Serialize, Deserialize, Debug)]
pub struct Containers {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    pub image: String,
    //Add the resources declaration
    //resources: 
    #[serde(skip_serializing_if = "Option::is_none")]
    pub ports: Option<Vec<HashMap<String, u32>>>
}