//! The `std::ops` module.

use crate::{ContextError, Module, Protocol, Range, Value};

/// Construct the `std::ops` module.
pub fn module() -> Result<Module, ContextError> {
    let mut module = Module::with_crate_item("std", &["ops"]);
    module.ty::<Range>()?;
    module.inst_fn("contains_int", Range::contains_int)?;
    module.field_fn(Protocol::SET, "start", range_set_start)?;
    module.field_fn(Protocol::SET, "end", range_set_end)?;
    Ok(module)
}

fn range_set_start(range: &mut Range, start: Option<Value>) {
    range.start = start;
}

fn range_set_end(range: &mut Range, end: Option<Value>) {
    range.end = end;
}
