use crate::quote;

/// This file has been generated from `assets\tokens.yaml`
/// DO NOT modify by hand!

pub(crate) fn kind_from_ident(ident: &str) -> Option<quote::Kind> {
    match ident {
        "abstract" => Some(quote::Kind("Abstract")),
        "alignof" => Some(quote::Kind("AlignOf")),
        "as" => Some(quote::Kind("As")),
        "async" => Some(quote::Kind("Async")),
        "await" => Some(quote::Kind("Await")),
        "become" => Some(quote::Kind("Become")),
        "break" => Some(quote::Kind("Break")),
        "const" => Some(quote::Kind("Const")),
        "continue" => Some(quote::Kind("Continue")),
        "crate" => Some(quote::Kind("Crate")),
        "default" => Some(quote::Kind("Default")),
        "do" => Some(quote::Kind("Do")),
        "else" => Some(quote::Kind("Else")),
        "enum" => Some(quote::Kind("Enum")),
        "extern" => Some(quote::Kind("Extern")),
        "false" => Some(quote::Kind("False")),
        "final" => Some(quote::Kind("Final")),
        "fn" => Some(quote::Kind("Fn")),
        "for" => Some(quote::Kind("For")),
        "if" => Some(quote::Kind("If")),
        "impl" => Some(quote::Kind("Impl")),
        "in" => Some(quote::Kind("In")),
        "is" => Some(quote::Kind("Is")),
        "let" => Some(quote::Kind("Let")),
        "loop" => Some(quote::Kind("Loop")),
        "macro" => Some(quote::Kind("Macro")),
        "match" => Some(quote::Kind("Match")),
        "mod" => Some(quote::Kind("Mod")),
        "move" => Some(quote::Kind("Move")),
        "not" => Some(quote::Kind("Not")),
        "offsetof" => Some(quote::Kind("OffsetOf")),
        "override" => Some(quote::Kind("Override")),
        "priv" => Some(quote::Kind("Priv")),
        "proc" => Some(quote::Kind("Proc")),
        "pub" => Some(quote::Kind("Pub")),
        "pure" => Some(quote::Kind("Pure")),
        "ref" => Some(quote::Kind("Ref")),
        "return" => Some(quote::Kind("Return")),
        "select" => Some(quote::Kind("Select")),
        "Self" => Some(quote::Kind("SelfType")),
        "self" => Some(quote::Kind("SelfValue")),
        "sizeof" => Some(quote::Kind("SizeOf")),
        "static" => Some(quote::Kind("Static")),
        "struct" => Some(quote::Kind("Struct")),
        "super" => Some(quote::Kind("Super")),
        "true" => Some(quote::Kind("True")),
        "typeof" => Some(quote::Kind("TypeOf")),
        "unsafe" => Some(quote::Kind("Unsafe")),
        "use" => Some(quote::Kind("Use")),
        "virtual" => Some(quote::Kind("Virtual")),
        "while" => Some(quote::Kind("While")),
        "yield" => Some(quote::Kind("Yield")),
        _ => None,
    }
}

pub(crate) fn kind_from_punct(buf: &[char]) -> Option<quote::Kind> {
    match buf {
        ['&', '\u{0}', '\u{0}'] => Some(quote::Kind("Amp")),
        ['&', '&', '\u{0}'] => Some(quote::Kind("AmpAmp")),
        ['&', '=', '\u{0}'] => Some(quote::Kind("AmpEq")),
        ['-', '>', '\u{0}'] => Some(quote::Kind("Arrow")),
        ['@', '\u{0}', '\u{0}'] => Some(quote::Kind("At")),
        ['!', '\u{0}', '\u{0}'] => Some(quote::Kind("Bang")),
        ['!', '=', '\u{0}'] => Some(quote::Kind("BangEq")),
        ['^', '\u{0}', '\u{0}'] => Some(quote::Kind("Caret")),
        ['^', '=', '\u{0}'] => Some(quote::Kind("CaretEq")),
        [':', '\u{0}', '\u{0}'] => Some(quote::Kind("Colon")),
        [':', ':', '\u{0}'] => Some(quote::Kind("ColonColon")),
        [',', '\u{0}', '\u{0}'] => Some(quote::Kind("Comma")),
        ['-', '\u{0}', '\u{0}'] => Some(quote::Kind("Dash")),
        ['-', '=', '\u{0}'] => Some(quote::Kind("DashEq")),
        ['/', '\u{0}', '\u{0}'] => Some(quote::Kind("Div")),
        ['$', '\u{0}', '\u{0}'] => Some(quote::Kind("Dollar")),
        ['.', '\u{0}', '\u{0}'] => Some(quote::Kind("Dot")),
        ['.', '.', '\u{0}'] => Some(quote::Kind("DotDot")),
        ['.', '.', '='] => Some(quote::Kind("DotDotEq")),
        ['=', '\u{0}', '\u{0}'] => Some(quote::Kind("Eq")),
        ['=', '=', '\u{0}'] => Some(quote::Kind("EqEq")),
        ['>', '\u{0}', '\u{0}'] => Some(quote::Kind("Gt")),
        ['>', '=', '\u{0}'] => Some(quote::Kind("GtEq")),
        ['>', '>', '\u{0}'] => Some(quote::Kind("GtGt")),
        ['>', '>', '='] => Some(quote::Kind("GtGtEq")),
        ['<', '\u{0}', '\u{0}'] => Some(quote::Kind("Lt")),
        ['<', '=', '\u{0}'] => Some(quote::Kind("LtEq")),
        ['<', '<', '\u{0}'] => Some(quote::Kind("LtLt")),
        ['<', '<', '='] => Some(quote::Kind("LtLtEq")),
        ['%', '\u{0}', '\u{0}'] => Some(quote::Kind("Perc")),
        ['%', '=', '\u{0}'] => Some(quote::Kind("PercEq")),
        ['|', '\u{0}', '\u{0}'] => Some(quote::Kind("Pipe")),
        ['|', '=', '\u{0}'] => Some(quote::Kind("PipeEq")),
        ['|', '|', '\u{0}'] => Some(quote::Kind("PipePipe")),
        ['+', '\u{0}', '\u{0}'] => Some(quote::Kind("Plus")),
        ['+', '=', '\u{0}'] => Some(quote::Kind("PlusEq")),
        ['#', '\u{0}', '\u{0}'] => Some(quote::Kind("Pound")),
        ['?', '\u{0}', '\u{0}'] => Some(quote::Kind("QuestionMark")),
        ['=', '>', '\u{0}'] => Some(quote::Kind("Rocket")),
        [';', '\u{0}', '\u{0}'] => Some(quote::Kind("SemiColon")),
        ['/', '=', '\u{0}'] => Some(quote::Kind("SlashEq")),
        ['*', '\u{0}', '\u{0}'] => Some(quote::Kind("Star")),
        ['*', '=', '\u{0}'] => Some(quote::Kind("StarEq")),
        ['~', '\u{0}', '\u{0}'] => Some(quote::Kind("Tilde")),
        ['_', '\u{0}', '\u{0}'] => Some(quote::Kind("Underscore")),
        _ => None,
    }
}
