Since version 0.15.1 of ruma-api, ruma-api-macros is versioned in lockstep with ruma-api. Since
ruma-api-macros cannot be used independently anyway, it no longer maintains a separate change log or
its own version. Instead, refer to ruma-api's change log for changes in versions 0.15.1 and above.

# 0.12.0

Breaking changes:

* Update code generation to match the changes in ruma-api 0.15.0

# 0.11.0

Breaking changes:

* Use `TryFrom<&str>` instead of serde_json for path segment deserialization

# 0.10.1

Improvements:

* Derive `Debug` for `Incoming` types

# 0.10.0

Breaking changes:

* Update code generation to match the changes in ruma-api 0.13.0

# 0.9.1

Improvements:

* Add `#[ruma_api(raw_body)]` attribute to `ruma_api!`'s grammar
  * This attribute is used to bypass (de)serialization for endpoints where the HTTP request /
    response is arbitrary data rather than some JSON structure

# 0.9.0

Breaking changes:

* Updated code generation to match the changes in ruma-api 0.12.0

New features:

* Added a derive macro for the new `Outgoing` trait from ruma-api

# 0.8.2

Bug fixes:

* Fix handling of `request` / `response` blocks containing fields with serde attributes ([#31][])

[#31]: https://github.com/ruma/ruma-api/pull/31

# 0.8.1

Improvements:

* Add spans to almost every error that can come up in `ruma_api!`
* Add a new field kind: `#[ruma_api(query_map)]` ([#30][])
    * This allows endpoints that have a dynamic set of query parameters to be implemented
    * For details see the documentation of `ruma_api!`
* Add more sanity checks
    * No multiple `#[ruma_api(body)]` fields in one request / response definition
    * No multiple field kind declarations `#[ruma_api(body|query|path)]` on one field
    * No (newtype) body fields in GET endpoints
* Lots of refactoring of the internals

[#30]: https://github.com/ruma/ruma-api/pull/30

# 0.7.1

Bug fixes:

* Removed unnecessary dependency on ruma-api 0.9.0.

# 0.7.0

Breaking changes:

* Updated to ruma-api 0.10.0.

Improvements:

* ruma-api now re-exports the `ruma_api` macro from ruma-api-macros. Downstream crates no longer need to depend on ruma-api-macros directly.
* The code generated by the `ruma_api` macro now refers to external dependencies via re-exports in ruma-api, so it is no longer necessary to add them to the dependencies of downstream crates directly.
* The ruma-api and ruma-api-macros repositories have been merged into one Cargo workspace for easier dependency management and development.

# 0.6.0

Breaking changes:

* Updated to ruma-api 0.9.0.

# 0.5.0

Breaking changes:

* Updated to ruma-api 0.8.0.

Improvements:

* Generated documentation now includes the names and descriptions of API endpoints.
* Remove unidiomatic use of `Tokens::append_all` from the `quote` crate.
* ruma-api-macros now uses clippy to improve code quality.

# 0.4.0

Improvements:

* ruma-api-macros now runs on stable Rust, requiring version 1.34 or higher.
* Updated all dependencies for upstream improvements.

# 0.3.1

Improved:

* Code updated to use Rust 2018 idioms.

Bug fixes:

* The crate will now compile when serde's `derive` feature is enabled.

# 0.3.0

Breaking changes:

* The procedural macro now uses hyper's `Body` type instead of `Vec<u8>`. This may prove to be a temporary change as ideally we want ruma-api-macros to be agnostic to HTTP client library.

Improvements:

* Updated to the latest versions of all dependencies.
* Improved error reporting for the procedural macro.
* Conversions between this crate's request and response types and the http crate's request and response types are now bidirectional.
* Request and response types now implement `Clone`.

# 0.2.2

Improvements:

* Updated to proc-macro2 0.4 for compatibility with the latest nightly Rust.

Bug fixes:

* Attributes that don't affect the macro are now ignored instead of causing a panic.
* Added missing commas in request query struct initialization that was causing a syntax error.
* Fixed stripping of serde attributes that was causing them to leak through and trigger a custom attribute error.
* Fixed creation of requests with an empty body that were not correctly using a `Vec<u8>` as the body type.

# 0.2.1

Version 0.2.1 was yanked from crates.io due to a dependency issue. Changes since version 0.2.0 are in the release notes for version 0.2.2.

# 0.2.0

Breaking changes:

* The dependency on the `hyper` crate has been removed. The macro now uses types from the `http` crate. The macro is also compatible with the forthcoming version 0.12 of `hyper`.
* The `method` field in the `metadata` block is now written as the name of an associated constant from `http::Method`, e.g. `GET`.
* HTTP headers are now specified in request and response blocks using `String` as the type, and the name of the constant of the header from `http::header` in the field's attributes. For example:
  ``` rust
  #[ruma_api(header = "CONTENT_TYPE")]
  pub content_type: String
  ```

Improvements:

* The macro is built using version 0.13 of the `syn` crate.

# 0.1.0

Initial release.
