# Contributing to RudderStack Rust SDK

Thanks for taking the time and for your help improving this project!

## Table of Contents

- [RudderStack Contributor Agreement](#rudderstack-contributor-agreement)
- [Submitting a Pull Request](#submitting-a-pull-request)
- [Committing](#committing)
- [Getting Help](#getting-help)

## RudderStack Contributor Agreement

To contribute to this project, we need you to sign to [Contributor License Agreement (“CLA”)][cla] for the first commit you make. By agreeing to the [CLA][cla]
we can add you to list of approved contributors and review the changes proposed by you.

## Submitting a Pull Request

Do you have an improvement?

1. Submit an [issue][issue] describing your proposed change.
2. We will try to respond to your issue promptly.
3. Fork this repo, develop and test your code changes. See the project's [README](README.md) for further information about working in this repository.
4. Submit a pull request against this repo's `main` branch.
   - Include instructions on how to test your changes.
5. Your branch may be merged once all configured checks pass, including:
   - A review from appropriate maintainers

## Committing

We prefer squash or rebase commits so that all changes from a branch are
committed to master as a single commit. All pull requests are squashed when
merged, but rebasing prior to merge gives you better control over the commit
message.

We look forward to your feedback on improving this project.

<!----variable's---->

[slack]: https://resources.rudderstack.com/join-rudderstack-slack
[issue]: https://github.com/rudderlabs/rudder-sdk-rust/issues/new
[cla]: https://rudderlabs.wufoo.com/forms/rudderlabs-contributor-license-agreement

## Getting Help

If you have a question about rudder or have encountered problems using it,
start by asking a question on [Slack][slack].
