//! This module provides error reporting functionality for the frontend.

#![forbid(unused_must_use)] // disallow discarding errors
#![warn(
    missing_docs,
    missing_debug_implementations,
    missing_copy_implementations,
    trivial_casts,
    trivial_numeric_casts,
    unsafe_code,
    unstable_features,
    unused_import_braces,
    unused_qualifications
)]

mod reporting;

pub use codespan_reporting::diagnostic::Diagnostic as RawDiagnostic;
pub use reporting::*;
