
/// # Example
/// 
/// ```rust
/// 
/// #[tokio::main]
/// async fn main() {
/// 
///     
///     let dl = RConcurrentStorage::<Document>::open("tester".to_owned(), 1000).await;
/// 
///     // Insert / Update
///     let _ = dl.insert_entry(format!("102xa"), Document::new()).await;
///  
///     // Remove
///     dl.remove_entry(&format("102xa")).await;
/// 
/// 
///     // Read
///     dl.table.read().await
///             .iter()
///             .for_each(|(key, doc)| {
///                 println!("==> {} -> {}", key, &doc.funame)
//               });
/// 
/// }
/// 
/// 
/// #[derive(Serialize, Deserialize, Clone)]
/// struct Document {
///     funame: String,
///     age: i32,
/// }
/// impl Document {
///     pub fn new() -> Self {
///         Document { 
///             funame: String::from("DanyalMhai@gmail.com"), 
///             age: 24, 
///         }
///     }
/// }
/// 
/// ``` 
/// 

mod storage;

/// Optimized for Read Heavy Concurrent
pub use storage::RConcurrentStorage;

/// Optimized for Write Heavy Concurrent
pub use storage::WConcurrentStorage;
