# durableMap

durableMap is in-memory, durable storage
optimized for ( write-heavy, read-heavy )


# Why need to DurableMap ??

it is a concurrent hashMap using NonBlocking wal engine for persist to disk 
it avoid any loss data



# Example

 ```rust
 
 #[tokio::main]
 async fn main() {
 
     
    // Optimized for write concurrent (API is same) 
    let dlw = WConcurrentStorage::<Document>::open("tester".to_owned(), 1000).await;
    
    // Optimized for read concurrent
    let dlr = RConcurrentStorage::<Document>::open("tester".to_owned(), 1000).await;
 
    
    // Insert / Update
    let _ = dlr.insert_entry(format!("102xa"), Document::new()).await;

    let _ = dlw.insert_entry(format!("102xa"), Document::new()).await;

    
    // Remove
    dlr.remove_entry(&format("102xa")).await;

    dlw.remove_entry(&format("102xa")).await;

    // Read
    dlr.table.read().await
            .iter()
            .for_each(|(key, doc)| {
                println!("==> {} -> {}", key, &doc.funame)
            });


    // Just Difference (RConcurrentStorage) and (WConcurrentStorage) is
    //  WConcurrentStorage for iter  table dont need lock
    //      because internally used sharded lock

    dlw.table
            .iter()
            .for_each(|(key, doc)| {
                println!("==> {} -> {}", key, &doc.funame)
            });
 }  
 
 
 #[derive(Serialize, Deserialize, Clone)]
 struct Document {
     funame: String,
     age: i32,
 }
 impl Document {
     pub fn new() -> Self {
         Document { 
             funame: String::from("DanyalMh"), 
             age: 24, 
         }
     }
 }
 
 
 
``` 
 

# Installation

``` 
[dependencies]

rstorage = "1.0.2"

``` 