
/// # Example
/// 
/// ```rust
/// 
/// #[tokio::main]
/// async fn main() {
/// 
///     
///     let dl = RConcurrentStorage::<Document>::open("tester".to_owned(), 1000).await;
/// 
///     for _ in 0..=5 {
///         let now = Instant::now();
///         // ----------------------------
/// 
///         for elem in 0..50_000 {
///             let _ = dl.insert_entry(format!("{}", elem), 
///                                     Document::new()).await;
///         }
/// 
///         // ----------------------------
///         let nnow = Instant::now();
///         println!("==> {:?}", nnow.duration_since(now));
///     }
/// 
///     tokio::time::sleep(Duration::from_secs(3)).await;
/// }
/// 
/// 
/// #[derive(Serialize, Deserialize, Clone)]
/// struct Document {
///     funame: String,
///     age: i32,
/// }
/// impl Document {
///     pub fn new() -> Self {
///         Document { 
///             funame: String::from("DanyalMhai@gmail.com"), 
///             age: 24, 
///         }
///     }
/// }
/// 
/// ``` 
/// 

mod storage;

/// Optimized for Read Heavy Concurrent
pub use storage::RConcurrentStorage;

/// Optimized for Write Heavy Concurrent
pub use storage::WConcurrentStorage;
