use bsp::hal;
use pyportal as bsp;

use super::SharedPeripherals;

use bsp::gpio::v2 as gpio;
use hal::pac::TC3;
use hal::timer::TimerCounter;
use pyportal::prelude::*;
use ws2812_timer_delay as ws2812;

pub(crate) struct NeopixelBuilder {
    pub pin: gpio::Pin<gpio::PB22, gpio::Input<gpio::Floating>>,
    pub tc3: TC3,
}

pub type Neopixel =
    ws2812::Ws2812<TimerCounter<TC3>, gpio::Pin<gpio::PB22, gpio::Output<gpio::PushPull>>>;

impl NeopixelBuilder {
    pub fn create(self, peripherals: &mut SharedPeripherals) -> Neopixel {
        let gclk0 = peripherals.clocks.gclk0();
        let timer_clock = peripherals.clocks.tc2_tc3(&gclk0).unwrap();
        let mut timer = TimerCounter::tc3_(&timer_clock, self.tc3, &mut peripherals.mclk);
        let pin = self.pin.into_push_pull_output();
        timer.start(3u32.mhz());
        ws2812::Ws2812::new(timer, pin)
    }
}
