use bsp::hal;
use pyportal as bsp;

use bsp::delay::Delay;
use bsp::pins;
use hal::prelude::*;

use display_interface_parallel_gpio::{Generic8BitBus, PGPIO8BitInterface};
use ili9341::{DisplaySize240x320, Ili9341, Orientation};

pub(crate) struct DisplayBuilder {
    pub pins: pins::Display,
}

macro_rules! v2_pin {
    ($pin:expr) => {
        bsp::gpio::v2::Pin::from($pin).into_push_pull_output()
    };
}

// wtf
pub type Display = Ili9341<
    PGPIO8BitInterface<
        Generic8BitBus<
            pyportal::gpio::v2::Pin<
                pyportal::gpio::v2::PA16,
                pyportal::gpio::v2::Output<pyportal::gpio::v2::PushPull>,
            >,
            pyportal::gpio::v2::Pin<
                pyportal::gpio::v2::PA17,
                pyportal::gpio::v2::Output<pyportal::gpio::v2::PushPull>,
            >,
            pyportal::gpio::v2::Pin<
                pyportal::gpio::v2::PA18,
                pyportal::gpio::v2::Output<pyportal::gpio::v2::PushPull>,
            >,
            pyportal::gpio::v2::Pin<
                pyportal::gpio::v2::PA19,
                pyportal::gpio::v2::Output<pyportal::gpio::v2::PushPull>,
            >,
            pyportal::gpio::v2::Pin<
                pyportal::gpio::v2::PA20,
                pyportal::gpio::v2::Output<pyportal::gpio::v2::PushPull>,
            >,
            pyportal::gpio::v2::Pin<
                pyportal::gpio::v2::PA21,
                pyportal::gpio::v2::Output<pyportal::gpio::v2::PushPull>,
            >,
            pyportal::gpio::v2::Pin<
                pyportal::gpio::v2::PA22,
                pyportal::gpio::v2::Output<pyportal::gpio::v2::PushPull>,
            >,
            pyportal::gpio::v2::Pin<
                pyportal::gpio::v2::PA23,
                pyportal::gpio::v2::Output<pyportal::gpio::v2::PushPull>,
            >,
        >,
        pyportal::gpio::v2::Pin<
            pyportal::gpio::v2::PB05,
            pyportal::gpio::v2::Output<pyportal::gpio::v2::PushPull>,
        >,
        pyportal::gpio::v2::Pin<
            pyportal::gpio::v2::PB09,
            pyportal::gpio::v2::Output<pyportal::gpio::v2::PushPull>,
        >,
    >,
    pyportal::gpio::v2::Pin<
        pyportal::gpio::v2::PA00,
        pyportal::gpio::v2::Output<pyportal::gpio::v2::PushPull>,
    >,
>;

impl DisplayBuilder {
    pub fn create(self, delay: &mut Delay) -> Display {
        let mut backlight = v2_pin!(self.pins.tft_backlight);
        backlight.set_high().unwrap();

        let bus = Generic8BitBus::new((
            v2_pin!(self.pins.lcd_data0),
            v2_pin!(self.pins.lcd_data1),
            v2_pin!(self.pins.lcd_data2),
            v2_pin!(self.pins.lcd_data3),
            v2_pin!(self.pins.lcd_data4),
            v2_pin!(self.pins.lcd_data5),
            v2_pin!(self.pins.lcd_data6),
            v2_pin!(self.pins.lcd_data7),
        ))
        .unwrap();

        let iface =
            PGPIO8BitInterface::new(bus, v2_pin!(self.pins.tft_rs), v2_pin!(self.pins.tft_wr));
        // Pull low to enable the chip
        let mut cs = v2_pin!(self.pins.tft_cs);
        cs.set_low().unwrap();

        Ili9341::new(
            iface,
            v2_pin!(self.pins.tft_reset),
            delay,
            Orientation::Landscape,
            DisplaySize240x320,
        )
        .unwrap()
    }
}
