# Contributing

Thank you for thinking of contributing! We very much welcome contributions from the community. To make the process
easier and more valuable for everyone involved we have a few rules and guidelines to follow.

Anyone with a Github account is free to file issues on the project. However, if you want to contribute documentation or
code then you will need to sign InfluxData's Individual Contributor License Agreement (CLA), which can be found with
more information [on our website](https://www.influxdata.com/legal/cla/).

## Submitting Issues and Feature Requests

Before you file an [issue](https://github.com/influxdata/rskafka/issues/new), please search existing issues in case
the same or similar issues have already been filed. If you find an existing open ticket covering your issue then please
avoid adding "👍" or "me too" comments; Github notifications can cause a lot of noise for the project maintainers who
triage the back-log.

However, if you have a new piece of information for an existing ticket and you think it may help the investigation or
resolution, then please do add it as a comment!

You can signal to the team that you're experiencing an existing issue with one of Github's emoji reactions (these are a
good way to add "weight" to an issue from a prioritization perspective).

## Running Tests

Tests can be run using `cargo`

```shell
cargo test --workspace
```
