use rsconnect::{Connect, ConnectInterface, ConnectNodeInterface};
mod common;

#[test]
#[should_panic(expected = "This node does not belong in current Connect graph")]
fn wrong_connect_graph_access() {
	// Observed and Computed nodes implement copy. They may outlive their
	// Connect graph. So, unless there were precautions, it would cause panic or
	// undefined behavior when accessing them from within another Connect graph.

	let b = {
		let conn = Connect::new();

		conn.observed(1);
		conn.observed(2)
	};

	let conn = Connect::new();
	conn.get(b);
}
