use std::{cell::RefCell, rc::Rc};

use common::Count;
use rsconnect::{Connect, ConnectInterface, ConnectNodeInterface};
mod common;

#[test]
fn effected() {
	let conn = Rc::new(RefCell::new(Connect::new()));

	let effect_calls: Count = Default::default();
	let effect_calls_closure: Count = effect_calls.clone();

	let effect_result: Count = Default::default();
	let effect_result_closure: Count = effect_result.clone();

	let conn_ref = conn.borrow();
	let a = conn_ref.observed(100_u32);
	let b = conn_ref.observed(0_u32);

	conn_ref.effected(move |conn| *conn.get(a), {
		let conn = conn.clone();
		move |a| {
			effect_calls_closure.increase();
			effect_result_closure.set(a + conn.borrow().get(b));
		}
	});

	assert_eq!(effect_calls.get(), 1);
	assert_eq!(effect_result.get(), 100);

	conn_ref.set(a, 200);

	assert_eq!(effect_calls.get(), 2);
	assert_eq!(effect_result.get(), 200);

	conn_ref.set(b, 300);

	assert_eq!(effect_calls.get(), 2);

	conn_ref.set(a, 400);

	assert_eq!(effect_calls.get(), 3);
	assert_eq!(effect_result.get(), 700);
}
