use common::Count;
use rsconnect::{Connect, ConnectInterface, ConnectNodeInterface};
mod common;

#[test]
fn deep_level() {
	let conn = Connect::new();

	let c_calls: Count = Default::default();
	let d_calls: Count = Default::default();
	let e_calls: Count = Default::default();

	let a = conn.observed(1);
	let b = conn.observed(2);
	let c = conn.computed({
		let c_calls = c_calls.clone();
		move |conn| {
			c_calls.increase();
			conn.get(a) + conn.get(b)
		}
	});
	let d = conn.computed({
		let d_calls = d_calls.clone();
		move |conn| {
			d_calls.increase();
			conn.get(a) + conn.get(b) + conn.get(c)
		}
	});
	let e = conn.computed({
		let e_calls = e_calls.clone();
		move |conn| {
			e_calls.increase();
			conn.get(a) + conn.get(b) + conn.get(c) + conn.get(d)
		}
	});

	assert_eq!(*conn.get(e), 12);
	assert_eq!(c_calls.get(), 1);
	assert_eq!(d_calls.get(), 1);
	assert_eq!(e_calls.get(), 1);

	conn.set(a, 100);
	assert_eq!(*conn.get(e), 408);

	assert_eq!(c_calls.get(), 2);
	assert_eq!(d_calls.get(), 2);
	assert_eq!(e_calls.get(), 2);
}
