use std::cell::RefCell;

use crate::node_traits::Nodes;

pub(crate) struct CurrentUpdate {
	pub(crate) dependencies: Vec<usize>,
}

impl CurrentUpdate {
	pub(crate) fn new() -> Self {
		Self {
			dependencies: Vec::new(),
		}
	}
}

#[derive(Default)]
pub struct Connect {
	pub(crate) modified_ids: RefCell<Option<Vec<usize>>>,
	pub(crate) nodes: RefCell<Vec<RefCell<Nodes>>>,
	pub(crate) current_update: RefCell<Option<CurrentUpdate>>,
}

impl Connect {
	pub fn new() -> Self {
		Default::default()
	}
}
