// automatically generated by the FlatBuffers compiler, do not modify


#ifndef FLATBUFFERS_GENERATED_FBRESULT_OSRM_ENGINE_API_FBRESULT_H_
#define FLATBUFFERS_GENERATED_FBRESULT_OSRM_ENGINE_API_FBRESULT_H_

#include "flatbuffers/flatbuffers.h"

namespace osrm {
namespace engine {
namespace api {
namespace fbresult {

struct Position;

struct Uint64Pair;

struct Waypoint;
struct WaypointT;

struct Metadata;
struct MetadataT;

struct Annotation;
struct AnnotationT;

struct StepManeuver;
struct StepManeuverT;

struct Lane;
struct LaneT;

struct Intersection;
struct IntersectionT;

struct Step;
struct StepT;

struct Leg;
struct LegT;

struct RouteObject;
struct RouteObjectT;

struct Table;
struct TableT;

struct Error;
struct ErrorT;

struct FBResult;
struct FBResultT;

enum ManeuverType {
  ManeuverType_Turn = 0,
  ManeuverType_NewName = 1,
  ManeuverType_Depart = 2,
  ManeuverType_Arrive = 3,
  ManeuverType_Merge = 4,
  ManeuverType_OnRamp = 5,
  ManeuverType_OffRamp = 6,
  ManeuverType_Fork = 7,
  ManeuverType_EndOfRoad = 8,
  ManeuverType_Continue = 9,
  ManeuverType_Roundabout = 10,
  ManeuverType_Rotary = 11,
  ManeuverType_RoundaboutTurn = 12,
  ManeuverType_Notification = 13,
  ManeuverType_ExitRoundabout = 14,
  ManeuverType_ExitRotary = 15,
  ManeuverType_MIN = ManeuverType_Turn,
  ManeuverType_MAX = ManeuverType_ExitRotary
};

inline const ManeuverType (&EnumValuesManeuverType())[16] {
  static const ManeuverType values[] = {
    ManeuverType_Turn,
    ManeuverType_NewName,
    ManeuverType_Depart,
    ManeuverType_Arrive,
    ManeuverType_Merge,
    ManeuverType_OnRamp,
    ManeuverType_OffRamp,
    ManeuverType_Fork,
    ManeuverType_EndOfRoad,
    ManeuverType_Continue,
    ManeuverType_Roundabout,
    ManeuverType_Rotary,
    ManeuverType_RoundaboutTurn,
    ManeuverType_Notification,
    ManeuverType_ExitRoundabout,
    ManeuverType_ExitRotary
  };
  return values;
}

inline const char * const *EnumNamesManeuverType() {
  static const char * const names[17] = {
    "Turn",
    "NewName",
    "Depart",
    "Arrive",
    "Merge",
    "OnRamp",
    "OffRamp",
    "Fork",
    "EndOfRoad",
    "Continue",
    "Roundabout",
    "Rotary",
    "RoundaboutTurn",
    "Notification",
    "ExitRoundabout",
    "ExitRotary",
    nullptr
  };
  return names;
}

inline const char *EnumNameManeuverType(ManeuverType e) {
  if (e < ManeuverType_Turn || e > ManeuverType_ExitRotary) return "";
  const size_t index = static_cast<size_t>(e);
  return EnumNamesManeuverType()[index];
}

enum Turn {
  Turn_None = 0,
  Turn_UTurn = 1,
  Turn_SharpRight = 2,
  Turn_Right = 3,
  Turn_SlightRight = 4,
  Turn_Straight = 5,
  Turn_SlightLeft = 6,
  Turn_Left = 7,
  Turn_SharpLeft = 8,
  Turn_MIN = Turn_None,
  Turn_MAX = Turn_SharpLeft
};

inline const Turn (&EnumValuesTurn())[9] {
  static const Turn values[] = {
    Turn_None,
    Turn_UTurn,
    Turn_SharpRight,
    Turn_Right,
    Turn_SlightRight,
    Turn_Straight,
    Turn_SlightLeft,
    Turn_Left,
    Turn_SharpLeft
  };
  return values;
}

inline const char * const *EnumNamesTurn() {
  static const char * const names[10] = {
    "None",
    "UTurn",
    "SharpRight",
    "Right",
    "SlightRight",
    "Straight",
    "SlightLeft",
    "Left",
    "SharpLeft",
    nullptr
  };
  return names;
}

inline const char *EnumNameTurn(Turn e) {
  if (e < Turn_None || e > Turn_SharpLeft) return "";
  const size_t index = static_cast<size_t>(e);
  return EnumNamesTurn()[index];
}

FLATBUFFERS_MANUALLY_ALIGNED_STRUCT(4) Position FLATBUFFERS_FINAL_CLASS {
 private:
  float longitude_;
  float latitude_;

 public:
  Position() {
    memset(static_cast<void *>(this), 0, sizeof(Position));
  }
  Position(float _longitude, float _latitude)
      : longitude_(flatbuffers::EndianScalar(_longitude)),
        latitude_(flatbuffers::EndianScalar(_latitude)) {
  }
  float longitude() const {
    return flatbuffers::EndianScalar(longitude_);
  }
  float latitude() const {
    return flatbuffers::EndianScalar(latitude_);
  }
};
FLATBUFFERS_STRUCT_END(Position, 8);

FLATBUFFERS_MANUALLY_ALIGNED_STRUCT(8) Uint64Pair FLATBUFFERS_FINAL_CLASS {
 private:
  uint64_t first_;
  uint64_t second_;

 public:
  Uint64Pair() {
    memset(static_cast<void *>(this), 0, sizeof(Uint64Pair));
  }
  Uint64Pair(uint64_t _first, uint64_t _second)
      : first_(flatbuffers::EndianScalar(_first)),
        second_(flatbuffers::EndianScalar(_second)) {
  }
  uint64_t first() const {
    return flatbuffers::EndianScalar(first_);
  }
  uint64_t second() const {
    return flatbuffers::EndianScalar(second_);
  }
};
FLATBUFFERS_STRUCT_END(Uint64Pair, 16);

struct WaypointT : public flatbuffers::NativeTable {
  typedef Waypoint TableType;
  std::string hint;
  float distance;
  std::string name;
  std::unique_ptr<osrm::engine::api::fbresult::Position> location;
  std::unique_ptr<osrm::engine::api::fbresult::Uint64Pair> nodes;
  uint32_t matchings_index;
  uint32_t waypoint_index;
  uint32_t alternatives_count;
  uint32_t trips_index;
  WaypointT()
      : distance(0.0f),
        matchings_index(0),
        waypoint_index(0),
        alternatives_count(0),
        trips_index(0) {
  }
};

struct Waypoint FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef WaypointT NativeTableType;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_HINT = 4,
    VT_DISTANCE = 6,
    VT_NAME = 8,
    VT_LOCATION = 10,
    VT_NODES = 12,
    VT_MATCHINGS_INDEX = 14,
    VT_WAYPOINT_INDEX = 16,
    VT_ALTERNATIVES_COUNT = 18,
    VT_TRIPS_INDEX = 20
  };
  const flatbuffers::String *hint() const {
    return GetPointer<const flatbuffers::String *>(VT_HINT);
  }
  float distance() const {
    return GetField<float>(VT_DISTANCE, 0.0f);
  }
  const flatbuffers::String *name() const {
    return GetPointer<const flatbuffers::String *>(VT_NAME);
  }
  const osrm::engine::api::fbresult::Position *location() const {
    return GetStruct<const osrm::engine::api::fbresult::Position *>(VT_LOCATION);
  }
  const osrm::engine::api::fbresult::Uint64Pair *nodes() const {
    return GetStruct<const osrm::engine::api::fbresult::Uint64Pair *>(VT_NODES);
  }
  uint32_t matchings_index() const {
    return GetField<uint32_t>(VT_MATCHINGS_INDEX, 0);
  }
  uint32_t waypoint_index() const {
    return GetField<uint32_t>(VT_WAYPOINT_INDEX, 0);
  }
  uint32_t alternatives_count() const {
    return GetField<uint32_t>(VT_ALTERNATIVES_COUNT, 0);
  }
  uint32_t trips_index() const {
    return GetField<uint32_t>(VT_TRIPS_INDEX, 0);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_HINT) &&
           verifier.VerifyString(hint()) &&
           VerifyField<float>(verifier, VT_DISTANCE) &&
           VerifyOffset(verifier, VT_NAME) &&
           verifier.VerifyString(name()) &&
           VerifyField<osrm::engine::api::fbresult::Position>(verifier, VT_LOCATION) &&
           VerifyField<osrm::engine::api::fbresult::Uint64Pair>(verifier, VT_NODES) &&
           VerifyField<uint32_t>(verifier, VT_MATCHINGS_INDEX) &&
           VerifyField<uint32_t>(verifier, VT_WAYPOINT_INDEX) &&
           VerifyField<uint32_t>(verifier, VT_ALTERNATIVES_COUNT) &&
           VerifyField<uint32_t>(verifier, VT_TRIPS_INDEX) &&
           verifier.EndTable();
  }
  WaypointT *UnPack(const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(WaypointT *_o, const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<Waypoint> Pack(flatbuffers::FlatBufferBuilder &_fbb, const WaypointT* _o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct WaypointBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_hint(flatbuffers::Offset<flatbuffers::String> hint) {
    fbb_.AddOffset(Waypoint::VT_HINT, hint);
  }
  void add_distance(float distance) {
    fbb_.AddElement<float>(Waypoint::VT_DISTANCE, distance, 0.0f);
  }
  void add_name(flatbuffers::Offset<flatbuffers::String> name) {
    fbb_.AddOffset(Waypoint::VT_NAME, name);
  }
  void add_location(const osrm::engine::api::fbresult::Position *location) {
    fbb_.AddStruct(Waypoint::VT_LOCATION, location);
  }
  void add_nodes(const osrm::engine::api::fbresult::Uint64Pair *nodes) {
    fbb_.AddStruct(Waypoint::VT_NODES, nodes);
  }
  void add_matchings_index(uint32_t matchings_index) {
    fbb_.AddElement<uint32_t>(Waypoint::VT_MATCHINGS_INDEX, matchings_index, 0);
  }
  void add_waypoint_index(uint32_t waypoint_index) {
    fbb_.AddElement<uint32_t>(Waypoint::VT_WAYPOINT_INDEX, waypoint_index, 0);
  }
  void add_alternatives_count(uint32_t alternatives_count) {
    fbb_.AddElement<uint32_t>(Waypoint::VT_ALTERNATIVES_COUNT, alternatives_count, 0);
  }
  void add_trips_index(uint32_t trips_index) {
    fbb_.AddElement<uint32_t>(Waypoint::VT_TRIPS_INDEX, trips_index, 0);
  }
  explicit WaypointBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  WaypointBuilder &operator=(const WaypointBuilder &);
  flatbuffers::Offset<Waypoint> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<Waypoint>(end);
    return o;
  }
};

inline flatbuffers::Offset<Waypoint> CreateWaypoint(
    flatbuffers::FlatBufferBuilder &_fbb,
    flatbuffers::Offset<flatbuffers::String> hint = 0,
    float distance = 0.0f,
    flatbuffers::Offset<flatbuffers::String> name = 0,
    const osrm::engine::api::fbresult::Position *location = 0,
    const osrm::engine::api::fbresult::Uint64Pair *nodes = 0,
    uint32_t matchings_index = 0,
    uint32_t waypoint_index = 0,
    uint32_t alternatives_count = 0,
    uint32_t trips_index = 0) {
  WaypointBuilder builder_(_fbb);
  builder_.add_trips_index(trips_index);
  builder_.add_alternatives_count(alternatives_count);
  builder_.add_waypoint_index(waypoint_index);
  builder_.add_matchings_index(matchings_index);
  builder_.add_nodes(nodes);
  builder_.add_location(location);
  builder_.add_name(name);
  builder_.add_distance(distance);
  builder_.add_hint(hint);
  return builder_.Finish();
}

inline flatbuffers::Offset<Waypoint> CreateWaypointDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    const char *hint = nullptr,
    float distance = 0.0f,
    const char *name = nullptr,
    const osrm::engine::api::fbresult::Position *location = 0,
    const osrm::engine::api::fbresult::Uint64Pair *nodes = 0,
    uint32_t matchings_index = 0,
    uint32_t waypoint_index = 0,
    uint32_t alternatives_count = 0,
    uint32_t trips_index = 0) {
  auto hint__ = hint ? _fbb.CreateString(hint) : 0;
  auto name__ = name ? _fbb.CreateString(name) : 0;
  return osrm::engine::api::fbresult::CreateWaypoint(
      _fbb,
      hint__,
      distance,
      name__,
      location,
      nodes,
      matchings_index,
      waypoint_index,
      alternatives_count,
      trips_index);
}

flatbuffers::Offset<Waypoint> CreateWaypoint(flatbuffers::FlatBufferBuilder &_fbb, const WaypointT *_o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct MetadataT : public flatbuffers::NativeTable {
  typedef Metadata TableType;
  std::vector<std::string> datasource_names;
  MetadataT() {
  }
};

struct Metadata FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef MetadataT NativeTableType;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_DATASOURCE_NAMES = 4
  };
  const flatbuffers::Vector<flatbuffers::Offset<flatbuffers::String>> *datasource_names() const {
    return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<flatbuffers::String>> *>(VT_DATASOURCE_NAMES);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_DATASOURCE_NAMES) &&
           verifier.VerifyVector(datasource_names()) &&
           verifier.VerifyVectorOfStrings(datasource_names()) &&
           verifier.EndTable();
  }
  MetadataT *UnPack(const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(MetadataT *_o, const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<Metadata> Pack(flatbuffers::FlatBufferBuilder &_fbb, const MetadataT* _o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct MetadataBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_datasource_names(flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<flatbuffers::String>>> datasource_names) {
    fbb_.AddOffset(Metadata::VT_DATASOURCE_NAMES, datasource_names);
  }
  explicit MetadataBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  MetadataBuilder &operator=(const MetadataBuilder &);
  flatbuffers::Offset<Metadata> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<Metadata>(end);
    return o;
  }
};

inline flatbuffers::Offset<Metadata> CreateMetadata(
    flatbuffers::FlatBufferBuilder &_fbb,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<flatbuffers::String>>> datasource_names = 0) {
  MetadataBuilder builder_(_fbb);
  builder_.add_datasource_names(datasource_names);
  return builder_.Finish();
}

inline flatbuffers::Offset<Metadata> CreateMetadataDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    const std::vector<flatbuffers::Offset<flatbuffers::String>> *datasource_names = nullptr) {
  auto datasource_names__ = datasource_names ? _fbb.CreateVector<flatbuffers::Offset<flatbuffers::String>>(*datasource_names) : 0;
  return osrm::engine::api::fbresult::CreateMetadata(
      _fbb,
      datasource_names__);
}

flatbuffers::Offset<Metadata> CreateMetadata(flatbuffers::FlatBufferBuilder &_fbb, const MetadataT *_o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct AnnotationT : public flatbuffers::NativeTable {
  typedef Annotation TableType;
  std::vector<uint32_t> distance;
  std::vector<uint32_t> duration;
  std::vector<uint32_t> datasources;
  std::vector<uint32_t> nodes;
  std::vector<uint32_t> weight;
  std::vector<float> speed;
  std::unique_ptr<osrm::engine::api::fbresult::MetadataT> metadata;
  AnnotationT() {
  }
};

struct Annotation FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef AnnotationT NativeTableType;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_DISTANCE = 4,
    VT_DURATION = 6,
    VT_DATASOURCES = 8,
    VT_NODES = 10,
    VT_WEIGHT = 12,
    VT_SPEED = 14,
    VT_METADATA = 16
  };
  const flatbuffers::Vector<uint32_t> *distance() const {
    return GetPointer<const flatbuffers::Vector<uint32_t> *>(VT_DISTANCE);
  }
  const flatbuffers::Vector<uint32_t> *duration() const {
    return GetPointer<const flatbuffers::Vector<uint32_t> *>(VT_DURATION);
  }
  const flatbuffers::Vector<uint32_t> *datasources() const {
    return GetPointer<const flatbuffers::Vector<uint32_t> *>(VT_DATASOURCES);
  }
  const flatbuffers::Vector<uint32_t> *nodes() const {
    return GetPointer<const flatbuffers::Vector<uint32_t> *>(VT_NODES);
  }
  const flatbuffers::Vector<uint32_t> *weight() const {
    return GetPointer<const flatbuffers::Vector<uint32_t> *>(VT_WEIGHT);
  }
  const flatbuffers::Vector<float> *speed() const {
    return GetPointer<const flatbuffers::Vector<float> *>(VT_SPEED);
  }
  const osrm::engine::api::fbresult::Metadata *metadata() const {
    return GetPointer<const osrm::engine::api::fbresult::Metadata *>(VT_METADATA);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_DISTANCE) &&
           verifier.VerifyVector(distance()) &&
           VerifyOffset(verifier, VT_DURATION) &&
           verifier.VerifyVector(duration()) &&
           VerifyOffset(verifier, VT_DATASOURCES) &&
           verifier.VerifyVector(datasources()) &&
           VerifyOffset(verifier, VT_NODES) &&
           verifier.VerifyVector(nodes()) &&
           VerifyOffset(verifier, VT_WEIGHT) &&
           verifier.VerifyVector(weight()) &&
           VerifyOffset(verifier, VT_SPEED) &&
           verifier.VerifyVector(speed()) &&
           VerifyOffset(verifier, VT_METADATA) &&
           verifier.VerifyTable(metadata()) &&
           verifier.EndTable();
  }
  AnnotationT *UnPack(const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(AnnotationT *_o, const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<Annotation> Pack(flatbuffers::FlatBufferBuilder &_fbb, const AnnotationT* _o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct AnnotationBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_distance(flatbuffers::Offset<flatbuffers::Vector<uint32_t>> distance) {
    fbb_.AddOffset(Annotation::VT_DISTANCE, distance);
  }
  void add_duration(flatbuffers::Offset<flatbuffers::Vector<uint32_t>> duration) {
    fbb_.AddOffset(Annotation::VT_DURATION, duration);
  }
  void add_datasources(flatbuffers::Offset<flatbuffers::Vector<uint32_t>> datasources) {
    fbb_.AddOffset(Annotation::VT_DATASOURCES, datasources);
  }
  void add_nodes(flatbuffers::Offset<flatbuffers::Vector<uint32_t>> nodes) {
    fbb_.AddOffset(Annotation::VT_NODES, nodes);
  }
  void add_weight(flatbuffers::Offset<flatbuffers::Vector<uint32_t>> weight) {
    fbb_.AddOffset(Annotation::VT_WEIGHT, weight);
  }
  void add_speed(flatbuffers::Offset<flatbuffers::Vector<float>> speed) {
    fbb_.AddOffset(Annotation::VT_SPEED, speed);
  }
  void add_metadata(flatbuffers::Offset<osrm::engine::api::fbresult::Metadata> metadata) {
    fbb_.AddOffset(Annotation::VT_METADATA, metadata);
  }
  explicit AnnotationBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  AnnotationBuilder &operator=(const AnnotationBuilder &);
  flatbuffers::Offset<Annotation> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<Annotation>(end);
    return o;
  }
};

inline flatbuffers::Offset<Annotation> CreateAnnotation(
    flatbuffers::FlatBufferBuilder &_fbb,
    flatbuffers::Offset<flatbuffers::Vector<uint32_t>> distance = 0,
    flatbuffers::Offset<flatbuffers::Vector<uint32_t>> duration = 0,
    flatbuffers::Offset<flatbuffers::Vector<uint32_t>> datasources = 0,
    flatbuffers::Offset<flatbuffers::Vector<uint32_t>> nodes = 0,
    flatbuffers::Offset<flatbuffers::Vector<uint32_t>> weight = 0,
    flatbuffers::Offset<flatbuffers::Vector<float>> speed = 0,
    flatbuffers::Offset<osrm::engine::api::fbresult::Metadata> metadata = 0) {
  AnnotationBuilder builder_(_fbb);
  builder_.add_metadata(metadata);
  builder_.add_speed(speed);
  builder_.add_weight(weight);
  builder_.add_nodes(nodes);
  builder_.add_datasources(datasources);
  builder_.add_duration(duration);
  builder_.add_distance(distance);
  return builder_.Finish();
}

inline flatbuffers::Offset<Annotation> CreateAnnotationDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    const std::vector<uint32_t> *distance = nullptr,
    const std::vector<uint32_t> *duration = nullptr,
    const std::vector<uint32_t> *datasources = nullptr,
    const std::vector<uint32_t> *nodes = nullptr,
    const std::vector<uint32_t> *weight = nullptr,
    const std::vector<float> *speed = nullptr,
    flatbuffers::Offset<osrm::engine::api::fbresult::Metadata> metadata = 0) {
  auto distance__ = distance ? _fbb.CreateVector<uint32_t>(*distance) : 0;
  auto duration__ = duration ? _fbb.CreateVector<uint32_t>(*duration) : 0;
  auto datasources__ = datasources ? _fbb.CreateVector<uint32_t>(*datasources) : 0;
  auto nodes__ = nodes ? _fbb.CreateVector<uint32_t>(*nodes) : 0;
  auto weight__ = weight ? _fbb.CreateVector<uint32_t>(*weight) : 0;
  auto speed__ = speed ? _fbb.CreateVector<float>(*speed) : 0;
  return osrm::engine::api::fbresult::CreateAnnotation(
      _fbb,
      distance__,
      duration__,
      datasources__,
      nodes__,
      weight__,
      speed__,
      metadata);
}

flatbuffers::Offset<Annotation> CreateAnnotation(flatbuffers::FlatBufferBuilder &_fbb, const AnnotationT *_o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct StepManeuverT : public flatbuffers::NativeTable {
  typedef StepManeuver TableType;
  std::unique_ptr<osrm::engine::api::fbresult::Position> location;
  uint16_t bearing_before;
  uint16_t bearing_after;
  osrm::engine::api::fbresult::ManeuverType type;
  osrm::engine::api::fbresult::Turn modifier;
  uint8_t exit;
  StepManeuverT()
      : bearing_before(0),
        bearing_after(0),
        type(osrm::engine::api::fbresult::ManeuverType_Turn),
        modifier(osrm::engine::api::fbresult::Turn_None),
        exit(0) {
  }
};

struct StepManeuver FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef StepManeuverT NativeTableType;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_LOCATION = 4,
    VT_BEARING_BEFORE = 6,
    VT_BEARING_AFTER = 8,
    VT_TYPE = 10,
    VT_MODIFIER = 12,
    VT_EXIT = 14
  };
  const osrm::engine::api::fbresult::Position *location() const {
    return GetStruct<const osrm::engine::api::fbresult::Position *>(VT_LOCATION);
  }
  uint16_t bearing_before() const {
    return GetField<uint16_t>(VT_BEARING_BEFORE, 0);
  }
  uint16_t bearing_after() const {
    return GetField<uint16_t>(VT_BEARING_AFTER, 0);
  }
  osrm::engine::api::fbresult::ManeuverType type() const {
    return static_cast<osrm::engine::api::fbresult::ManeuverType>(GetField<int8_t>(VT_TYPE, 0));
  }
  osrm::engine::api::fbresult::Turn modifier() const {
    return static_cast<osrm::engine::api::fbresult::Turn>(GetField<int8_t>(VT_MODIFIER, 0));
  }
  uint8_t exit() const {
    return GetField<uint8_t>(VT_EXIT, 0);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<osrm::engine::api::fbresult::Position>(verifier, VT_LOCATION) &&
           VerifyField<uint16_t>(verifier, VT_BEARING_BEFORE) &&
           VerifyField<uint16_t>(verifier, VT_BEARING_AFTER) &&
           VerifyField<int8_t>(verifier, VT_TYPE) &&
           VerifyField<int8_t>(verifier, VT_MODIFIER) &&
           VerifyField<uint8_t>(verifier, VT_EXIT) &&
           verifier.EndTable();
  }
  StepManeuverT *UnPack(const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(StepManeuverT *_o, const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<StepManeuver> Pack(flatbuffers::FlatBufferBuilder &_fbb, const StepManeuverT* _o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct StepManeuverBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_location(const osrm::engine::api::fbresult::Position *location) {
    fbb_.AddStruct(StepManeuver::VT_LOCATION, location);
  }
  void add_bearing_before(uint16_t bearing_before) {
    fbb_.AddElement<uint16_t>(StepManeuver::VT_BEARING_BEFORE, bearing_before, 0);
  }
  void add_bearing_after(uint16_t bearing_after) {
    fbb_.AddElement<uint16_t>(StepManeuver::VT_BEARING_AFTER, bearing_after, 0);
  }
  void add_type(osrm::engine::api::fbresult::ManeuverType type) {
    fbb_.AddElement<int8_t>(StepManeuver::VT_TYPE, static_cast<int8_t>(type), 0);
  }
  void add_modifier(osrm::engine::api::fbresult::Turn modifier) {
    fbb_.AddElement<int8_t>(StepManeuver::VT_MODIFIER, static_cast<int8_t>(modifier), 0);
  }
  void add_exit(uint8_t exit) {
    fbb_.AddElement<uint8_t>(StepManeuver::VT_EXIT, exit, 0);
  }
  explicit StepManeuverBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  StepManeuverBuilder &operator=(const StepManeuverBuilder &);
  flatbuffers::Offset<StepManeuver> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<StepManeuver>(end);
    return o;
  }
};

inline flatbuffers::Offset<StepManeuver> CreateStepManeuver(
    flatbuffers::FlatBufferBuilder &_fbb,
    const osrm::engine::api::fbresult::Position *location = 0,
    uint16_t bearing_before = 0,
    uint16_t bearing_after = 0,
    osrm::engine::api::fbresult::ManeuverType type = osrm::engine::api::fbresult::ManeuverType_Turn,
    osrm::engine::api::fbresult::Turn modifier = osrm::engine::api::fbresult::Turn_None,
    uint8_t exit = 0) {
  StepManeuverBuilder builder_(_fbb);
  builder_.add_location(location);
  builder_.add_bearing_after(bearing_after);
  builder_.add_bearing_before(bearing_before);
  builder_.add_exit(exit);
  builder_.add_modifier(modifier);
  builder_.add_type(type);
  return builder_.Finish();
}

flatbuffers::Offset<StepManeuver> CreateStepManeuver(flatbuffers::FlatBufferBuilder &_fbb, const StepManeuverT *_o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct LaneT : public flatbuffers::NativeTable {
  typedef Lane TableType;
  std::vector<osrm::engine::api::fbresult::Turn> indications;
  bool valid;
  LaneT()
      : valid(false) {
  }
};

struct Lane FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef LaneT NativeTableType;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_INDICATIONS = 4,
    VT_VALID = 6
  };
  const flatbuffers::Vector<int8_t> *indications() const {
    return GetPointer<const flatbuffers::Vector<int8_t> *>(VT_INDICATIONS);
  }
  bool valid() const {
    return GetField<uint8_t>(VT_VALID, 0) != 0;
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_INDICATIONS) &&
           verifier.VerifyVector(indications()) &&
           VerifyField<uint8_t>(verifier, VT_VALID) &&
           verifier.EndTable();
  }
  LaneT *UnPack(const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(LaneT *_o, const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<Lane> Pack(flatbuffers::FlatBufferBuilder &_fbb, const LaneT* _o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct LaneBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_indications(flatbuffers::Offset<flatbuffers::Vector<int8_t>> indications) {
    fbb_.AddOffset(Lane::VT_INDICATIONS, indications);
  }
  void add_valid(bool valid) {
    fbb_.AddElement<uint8_t>(Lane::VT_VALID, static_cast<uint8_t>(valid), 0);
  }
  explicit LaneBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  LaneBuilder &operator=(const LaneBuilder &);
  flatbuffers::Offset<Lane> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<Lane>(end);
    return o;
  }
};

inline flatbuffers::Offset<Lane> CreateLane(
    flatbuffers::FlatBufferBuilder &_fbb,
    flatbuffers::Offset<flatbuffers::Vector<int8_t>> indications = 0,
    bool valid = false) {
  LaneBuilder builder_(_fbb);
  builder_.add_indications(indications);
  builder_.add_valid(valid);
  return builder_.Finish();
}

inline flatbuffers::Offset<Lane> CreateLaneDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    const std::vector<int8_t> *indications = nullptr,
    bool valid = false) {
  auto indications__ = indications ? _fbb.CreateVector<int8_t>(*indications) : 0;
  return osrm::engine::api::fbresult::CreateLane(
      _fbb,
      indications__,
      valid);
}

flatbuffers::Offset<Lane> CreateLane(flatbuffers::FlatBufferBuilder &_fbb, const LaneT *_o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct IntersectionT : public flatbuffers::NativeTable {
  typedef Intersection TableType;
  std::unique_ptr<osrm::engine::api::fbresult::Position> location;
  std::vector<int16_t> bearings;
  std::vector<std::string> classes;
  std::vector<bool> entry;
  uint32_t in_bearing;
  uint32_t out_bearing;
  std::vector<std::unique_ptr<osrm::engine::api::fbresult::LaneT>> lanes;
  IntersectionT()
      : in_bearing(0),
        out_bearing(0) {
  }
};

struct Intersection FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef IntersectionT NativeTableType;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_LOCATION = 4,
    VT_BEARINGS = 6,
    VT_CLASSES = 8,
    VT_ENTRY = 10,
    VT_IN_BEARING = 12,
    VT_OUT_BEARING = 14,
    VT_LANES = 16
  };
  const osrm::engine::api::fbresult::Position *location() const {
    return GetStruct<const osrm::engine::api::fbresult::Position *>(VT_LOCATION);
  }
  const flatbuffers::Vector<int16_t> *bearings() const {
    return GetPointer<const flatbuffers::Vector<int16_t> *>(VT_BEARINGS);
  }
  const flatbuffers::Vector<flatbuffers::Offset<flatbuffers::String>> *classes() const {
    return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<flatbuffers::String>> *>(VT_CLASSES);
  }
  const flatbuffers::Vector<uint8_t> *entry() const {
    return GetPointer<const flatbuffers::Vector<uint8_t> *>(VT_ENTRY);
  }
  uint32_t in_bearing() const {
    return GetField<uint32_t>(VT_IN_BEARING, 0);
  }
  uint32_t out_bearing() const {
    return GetField<uint32_t>(VT_OUT_BEARING, 0);
  }
  const flatbuffers::Vector<flatbuffers::Offset<osrm::engine::api::fbresult::Lane>> *lanes() const {
    return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<osrm::engine::api::fbresult::Lane>> *>(VT_LANES);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<osrm::engine::api::fbresult::Position>(verifier, VT_LOCATION) &&
           VerifyOffset(verifier, VT_BEARINGS) &&
           verifier.VerifyVector(bearings()) &&
           VerifyOffset(verifier, VT_CLASSES) &&
           verifier.VerifyVector(classes()) &&
           verifier.VerifyVectorOfStrings(classes()) &&
           VerifyOffset(verifier, VT_ENTRY) &&
           verifier.VerifyVector(entry()) &&
           VerifyField<uint32_t>(verifier, VT_IN_BEARING) &&
           VerifyField<uint32_t>(verifier, VT_OUT_BEARING) &&
           VerifyOffset(verifier, VT_LANES) &&
           verifier.VerifyVector(lanes()) &&
           verifier.VerifyVectorOfTables(lanes()) &&
           verifier.EndTable();
  }
  IntersectionT *UnPack(const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(IntersectionT *_o, const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<Intersection> Pack(flatbuffers::FlatBufferBuilder &_fbb, const IntersectionT* _o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct IntersectionBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_location(const osrm::engine::api::fbresult::Position *location) {
    fbb_.AddStruct(Intersection::VT_LOCATION, location);
  }
  void add_bearings(flatbuffers::Offset<flatbuffers::Vector<int16_t>> bearings) {
    fbb_.AddOffset(Intersection::VT_BEARINGS, bearings);
  }
  void add_classes(flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<flatbuffers::String>>> classes) {
    fbb_.AddOffset(Intersection::VT_CLASSES, classes);
  }
  void add_entry(flatbuffers::Offset<flatbuffers::Vector<uint8_t>> entry) {
    fbb_.AddOffset(Intersection::VT_ENTRY, entry);
  }
  void add_in_bearing(uint32_t in_bearing) {
    fbb_.AddElement<uint32_t>(Intersection::VT_IN_BEARING, in_bearing, 0);
  }
  void add_out_bearing(uint32_t out_bearing) {
    fbb_.AddElement<uint32_t>(Intersection::VT_OUT_BEARING, out_bearing, 0);
  }
  void add_lanes(flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<osrm::engine::api::fbresult::Lane>>> lanes) {
    fbb_.AddOffset(Intersection::VT_LANES, lanes);
  }
  explicit IntersectionBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  IntersectionBuilder &operator=(const IntersectionBuilder &);
  flatbuffers::Offset<Intersection> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<Intersection>(end);
    return o;
  }
};

inline flatbuffers::Offset<Intersection> CreateIntersection(
    flatbuffers::FlatBufferBuilder &_fbb,
    const osrm::engine::api::fbresult::Position *location = 0,
    flatbuffers::Offset<flatbuffers::Vector<int16_t>> bearings = 0,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<flatbuffers::String>>> classes = 0,
    flatbuffers::Offset<flatbuffers::Vector<uint8_t>> entry = 0,
    uint32_t in_bearing = 0,
    uint32_t out_bearing = 0,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<osrm::engine::api::fbresult::Lane>>> lanes = 0) {
  IntersectionBuilder builder_(_fbb);
  builder_.add_lanes(lanes);
  builder_.add_out_bearing(out_bearing);
  builder_.add_in_bearing(in_bearing);
  builder_.add_entry(entry);
  builder_.add_classes(classes);
  builder_.add_bearings(bearings);
  builder_.add_location(location);
  return builder_.Finish();
}

inline flatbuffers::Offset<Intersection> CreateIntersectionDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    const osrm::engine::api::fbresult::Position *location = 0,
    const std::vector<int16_t> *bearings = nullptr,
    const std::vector<flatbuffers::Offset<flatbuffers::String>> *classes = nullptr,
    const std::vector<uint8_t> *entry = nullptr,
    uint32_t in_bearing = 0,
    uint32_t out_bearing = 0,
    const std::vector<flatbuffers::Offset<osrm::engine::api::fbresult::Lane>> *lanes = nullptr) {
  auto bearings__ = bearings ? _fbb.CreateVector<int16_t>(*bearings) : 0;
  auto classes__ = classes ? _fbb.CreateVector<flatbuffers::Offset<flatbuffers::String>>(*classes) : 0;
  auto entry__ = entry ? _fbb.CreateVector<uint8_t>(*entry) : 0;
  auto lanes__ = lanes ? _fbb.CreateVector<flatbuffers::Offset<osrm::engine::api::fbresult::Lane>>(*lanes) : 0;
  return osrm::engine::api::fbresult::CreateIntersection(
      _fbb,
      location,
      bearings__,
      classes__,
      entry__,
      in_bearing,
      out_bearing,
      lanes__);
}

flatbuffers::Offset<Intersection> CreateIntersection(flatbuffers::FlatBufferBuilder &_fbb, const IntersectionT *_o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct StepT : public flatbuffers::NativeTable {
  typedef Step TableType;
  float distance;
  float duration;
  std::string polyline;
  std::vector<osrm::engine::api::fbresult::Position> coordinates;
  float weight;
  std::string name;
  std::string ref;
  std::string pronunciation;
  std::string destinations;
  std::string exits;
  std::string mode;
  std::unique_ptr<osrm::engine::api::fbresult::StepManeuverT> maneuver;
  std::vector<std::unique_ptr<osrm::engine::api::fbresult::IntersectionT>> intersections;
  std::string rotary_name;
  std::string rotary_pronunciation;
  bool driving_side;
  StepT()
      : distance(0.0f),
        duration(0.0f),
        weight(0.0f),
        driving_side(false) {
  }
};

struct Step FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef StepT NativeTableType;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_DISTANCE = 4,
    VT_DURATION = 6,
    VT_POLYLINE = 8,
    VT_COORDINATES = 10,
    VT_WEIGHT = 12,
    VT_NAME = 14,
    VT_REF = 16,
    VT_PRONUNCIATION = 18,
    VT_DESTINATIONS = 20,
    VT_EXITS = 22,
    VT_MODE = 24,
    VT_MANEUVER = 26,
    VT_INTERSECTIONS = 28,
    VT_ROTARY_NAME = 30,
    VT_ROTARY_PRONUNCIATION = 32,
    VT_DRIVING_SIDE = 34
  };
  float distance() const {
    return GetField<float>(VT_DISTANCE, 0.0f);
  }
  float duration() const {
    return GetField<float>(VT_DURATION, 0.0f);
  }
  const flatbuffers::String *polyline() const {
    return GetPointer<const flatbuffers::String *>(VT_POLYLINE);
  }
  const flatbuffers::Vector<const osrm::engine::api::fbresult::Position *> *coordinates() const {
    return GetPointer<const flatbuffers::Vector<const osrm::engine::api::fbresult::Position *> *>(VT_COORDINATES);
  }
  float weight() const {
    return GetField<float>(VT_WEIGHT, 0.0f);
  }
  const flatbuffers::String *name() const {
    return GetPointer<const flatbuffers::String *>(VT_NAME);
  }
  const flatbuffers::String *ref() const {
    return GetPointer<const flatbuffers::String *>(VT_REF);
  }
  const flatbuffers::String *pronunciation() const {
    return GetPointer<const flatbuffers::String *>(VT_PRONUNCIATION);
  }
  const flatbuffers::String *destinations() const {
    return GetPointer<const flatbuffers::String *>(VT_DESTINATIONS);
  }
  const flatbuffers::String *exits() const {
    return GetPointer<const flatbuffers::String *>(VT_EXITS);
  }
  const flatbuffers::String *mode() const {
    return GetPointer<const flatbuffers::String *>(VT_MODE);
  }
  const osrm::engine::api::fbresult::StepManeuver *maneuver() const {
    return GetPointer<const osrm::engine::api::fbresult::StepManeuver *>(VT_MANEUVER);
  }
  const flatbuffers::Vector<flatbuffers::Offset<osrm::engine::api::fbresult::Intersection>> *intersections() const {
    return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<osrm::engine::api::fbresult::Intersection>> *>(VT_INTERSECTIONS);
  }
  const flatbuffers::String *rotary_name() const {
    return GetPointer<const flatbuffers::String *>(VT_ROTARY_NAME);
  }
  const flatbuffers::String *rotary_pronunciation() const {
    return GetPointer<const flatbuffers::String *>(VT_ROTARY_PRONUNCIATION);
  }
  bool driving_side() const {
    return GetField<uint8_t>(VT_DRIVING_SIDE, 0) != 0;
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<float>(verifier, VT_DISTANCE) &&
           VerifyField<float>(verifier, VT_DURATION) &&
           VerifyOffset(verifier, VT_POLYLINE) &&
           verifier.VerifyString(polyline()) &&
           VerifyOffset(verifier, VT_COORDINATES) &&
           verifier.VerifyVector(coordinates()) &&
           VerifyField<float>(verifier, VT_WEIGHT) &&
           VerifyOffset(verifier, VT_NAME) &&
           verifier.VerifyString(name()) &&
           VerifyOffset(verifier, VT_REF) &&
           verifier.VerifyString(ref()) &&
           VerifyOffset(verifier, VT_PRONUNCIATION) &&
           verifier.VerifyString(pronunciation()) &&
           VerifyOffset(verifier, VT_DESTINATIONS) &&
           verifier.VerifyString(destinations()) &&
           VerifyOffset(verifier, VT_EXITS) &&
           verifier.VerifyString(exits()) &&
           VerifyOffset(verifier, VT_MODE) &&
           verifier.VerifyString(mode()) &&
           VerifyOffset(verifier, VT_MANEUVER) &&
           verifier.VerifyTable(maneuver()) &&
           VerifyOffset(verifier, VT_INTERSECTIONS) &&
           verifier.VerifyVector(intersections()) &&
           verifier.VerifyVectorOfTables(intersections()) &&
           VerifyOffset(verifier, VT_ROTARY_NAME) &&
           verifier.VerifyString(rotary_name()) &&
           VerifyOffset(verifier, VT_ROTARY_PRONUNCIATION) &&
           verifier.VerifyString(rotary_pronunciation()) &&
           VerifyField<uint8_t>(verifier, VT_DRIVING_SIDE) &&
           verifier.EndTable();
  }
  StepT *UnPack(const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(StepT *_o, const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<Step> Pack(flatbuffers::FlatBufferBuilder &_fbb, const StepT* _o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct StepBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_distance(float distance) {
    fbb_.AddElement<float>(Step::VT_DISTANCE, distance, 0.0f);
  }
  void add_duration(float duration) {
    fbb_.AddElement<float>(Step::VT_DURATION, duration, 0.0f);
  }
  void add_polyline(flatbuffers::Offset<flatbuffers::String> polyline) {
    fbb_.AddOffset(Step::VT_POLYLINE, polyline);
  }
  void add_coordinates(flatbuffers::Offset<flatbuffers::Vector<const osrm::engine::api::fbresult::Position *>> coordinates) {
    fbb_.AddOffset(Step::VT_COORDINATES, coordinates);
  }
  void add_weight(float weight) {
    fbb_.AddElement<float>(Step::VT_WEIGHT, weight, 0.0f);
  }
  void add_name(flatbuffers::Offset<flatbuffers::String> name) {
    fbb_.AddOffset(Step::VT_NAME, name);
  }
  void add_ref(flatbuffers::Offset<flatbuffers::String> ref) {
    fbb_.AddOffset(Step::VT_REF, ref);
  }
  void add_pronunciation(flatbuffers::Offset<flatbuffers::String> pronunciation) {
    fbb_.AddOffset(Step::VT_PRONUNCIATION, pronunciation);
  }
  void add_destinations(flatbuffers::Offset<flatbuffers::String> destinations) {
    fbb_.AddOffset(Step::VT_DESTINATIONS, destinations);
  }
  void add_exits(flatbuffers::Offset<flatbuffers::String> exits) {
    fbb_.AddOffset(Step::VT_EXITS, exits);
  }
  void add_mode(flatbuffers::Offset<flatbuffers::String> mode) {
    fbb_.AddOffset(Step::VT_MODE, mode);
  }
  void add_maneuver(flatbuffers::Offset<osrm::engine::api::fbresult::StepManeuver> maneuver) {
    fbb_.AddOffset(Step::VT_MANEUVER, maneuver);
  }
  void add_intersections(flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<osrm::engine::api::fbresult::Intersection>>> intersections) {
    fbb_.AddOffset(Step::VT_INTERSECTIONS, intersections);
  }
  void add_rotary_name(flatbuffers::Offset<flatbuffers::String> rotary_name) {
    fbb_.AddOffset(Step::VT_ROTARY_NAME, rotary_name);
  }
  void add_rotary_pronunciation(flatbuffers::Offset<flatbuffers::String> rotary_pronunciation) {
    fbb_.AddOffset(Step::VT_ROTARY_PRONUNCIATION, rotary_pronunciation);
  }
  void add_driving_side(bool driving_side) {
    fbb_.AddElement<uint8_t>(Step::VT_DRIVING_SIDE, static_cast<uint8_t>(driving_side), 0);
  }
  explicit StepBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  StepBuilder &operator=(const StepBuilder &);
  flatbuffers::Offset<Step> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<Step>(end);
    return o;
  }
};

inline flatbuffers::Offset<Step> CreateStep(
    flatbuffers::FlatBufferBuilder &_fbb,
    float distance = 0.0f,
    float duration = 0.0f,
    flatbuffers::Offset<flatbuffers::String> polyline = 0,
    flatbuffers::Offset<flatbuffers::Vector<const osrm::engine::api::fbresult::Position *>> coordinates = 0,
    float weight = 0.0f,
    flatbuffers::Offset<flatbuffers::String> name = 0,
    flatbuffers::Offset<flatbuffers::String> ref = 0,
    flatbuffers::Offset<flatbuffers::String> pronunciation = 0,
    flatbuffers::Offset<flatbuffers::String> destinations = 0,
    flatbuffers::Offset<flatbuffers::String> exits = 0,
    flatbuffers::Offset<flatbuffers::String> mode = 0,
    flatbuffers::Offset<osrm::engine::api::fbresult::StepManeuver> maneuver = 0,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<osrm::engine::api::fbresult::Intersection>>> intersections = 0,
    flatbuffers::Offset<flatbuffers::String> rotary_name = 0,
    flatbuffers::Offset<flatbuffers::String> rotary_pronunciation = 0,
    bool driving_side = false) {
  StepBuilder builder_(_fbb);
  builder_.add_rotary_pronunciation(rotary_pronunciation);
  builder_.add_rotary_name(rotary_name);
  builder_.add_intersections(intersections);
  builder_.add_maneuver(maneuver);
  builder_.add_mode(mode);
  builder_.add_exits(exits);
  builder_.add_destinations(destinations);
  builder_.add_pronunciation(pronunciation);
  builder_.add_ref(ref);
  builder_.add_name(name);
  builder_.add_weight(weight);
  builder_.add_coordinates(coordinates);
  builder_.add_polyline(polyline);
  builder_.add_duration(duration);
  builder_.add_distance(distance);
  builder_.add_driving_side(driving_side);
  return builder_.Finish();
}

inline flatbuffers::Offset<Step> CreateStepDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    float distance = 0.0f,
    float duration = 0.0f,
    const char *polyline = nullptr,
    const std::vector<osrm::engine::api::fbresult::Position> *coordinates = nullptr,
    float weight = 0.0f,
    const char *name = nullptr,
    const char *ref = nullptr,
    const char *pronunciation = nullptr,
    const char *destinations = nullptr,
    const char *exits = nullptr,
    const char *mode = nullptr,
    flatbuffers::Offset<osrm::engine::api::fbresult::StepManeuver> maneuver = 0,
    const std::vector<flatbuffers::Offset<osrm::engine::api::fbresult::Intersection>> *intersections = nullptr,
    const char *rotary_name = nullptr,
    const char *rotary_pronunciation = nullptr,
    bool driving_side = false) {
  auto polyline__ = polyline ? _fbb.CreateString(polyline) : 0;
  auto coordinates__ = coordinates ? _fbb.CreateVectorOfStructs<osrm::engine::api::fbresult::Position>(*coordinates) : 0;
  auto name__ = name ? _fbb.CreateString(name) : 0;
  auto ref__ = ref ? _fbb.CreateString(ref) : 0;
  auto pronunciation__ = pronunciation ? _fbb.CreateString(pronunciation) : 0;
  auto destinations__ = destinations ? _fbb.CreateString(destinations) : 0;
  auto exits__ = exits ? _fbb.CreateString(exits) : 0;
  auto mode__ = mode ? _fbb.CreateString(mode) : 0;
  auto intersections__ = intersections ? _fbb.CreateVector<flatbuffers::Offset<osrm::engine::api::fbresult::Intersection>>(*intersections) : 0;
  auto rotary_name__ = rotary_name ? _fbb.CreateString(rotary_name) : 0;
  auto rotary_pronunciation__ = rotary_pronunciation ? _fbb.CreateString(rotary_pronunciation) : 0;
  return osrm::engine::api::fbresult::CreateStep(
      _fbb,
      distance,
      duration,
      polyline__,
      coordinates__,
      weight,
      name__,
      ref__,
      pronunciation__,
      destinations__,
      exits__,
      mode__,
      maneuver,
      intersections__,
      rotary_name__,
      rotary_pronunciation__,
      driving_side);
}

flatbuffers::Offset<Step> CreateStep(flatbuffers::FlatBufferBuilder &_fbb, const StepT *_o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct LegT : public flatbuffers::NativeTable {
  typedef Leg TableType;
  double distance;
  double duration;
  double weight;
  std::string summary;
  std::unique_ptr<osrm::engine::api::fbresult::AnnotationT> annotations;
  std::vector<std::unique_ptr<osrm::engine::api::fbresult::StepT>> steps;
  LegT()
      : distance(0.0),
        duration(0.0),
        weight(0.0) {
  }
};

struct Leg FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef LegT NativeTableType;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_DISTANCE = 4,
    VT_DURATION = 6,
    VT_WEIGHT = 8,
    VT_SUMMARY = 10,
    VT_ANNOTATIONS = 12,
    VT_STEPS = 14
  };
  double distance() const {
    return GetField<double>(VT_DISTANCE, 0.0);
  }
  double duration() const {
    return GetField<double>(VT_DURATION, 0.0);
  }
  double weight() const {
    return GetField<double>(VT_WEIGHT, 0.0);
  }
  const flatbuffers::String *summary() const {
    return GetPointer<const flatbuffers::String *>(VT_SUMMARY);
  }
  const osrm::engine::api::fbresult::Annotation *annotations() const {
    return GetPointer<const osrm::engine::api::fbresult::Annotation *>(VT_ANNOTATIONS);
  }
  const flatbuffers::Vector<flatbuffers::Offset<osrm::engine::api::fbresult::Step>> *steps() const {
    return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<osrm::engine::api::fbresult::Step>> *>(VT_STEPS);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<double>(verifier, VT_DISTANCE) &&
           VerifyField<double>(verifier, VT_DURATION) &&
           VerifyField<double>(verifier, VT_WEIGHT) &&
           VerifyOffset(verifier, VT_SUMMARY) &&
           verifier.VerifyString(summary()) &&
           VerifyOffset(verifier, VT_ANNOTATIONS) &&
           verifier.VerifyTable(annotations()) &&
           VerifyOffset(verifier, VT_STEPS) &&
           verifier.VerifyVector(steps()) &&
           verifier.VerifyVectorOfTables(steps()) &&
           verifier.EndTable();
  }
  LegT *UnPack(const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(LegT *_o, const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<Leg> Pack(flatbuffers::FlatBufferBuilder &_fbb, const LegT* _o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct LegBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_distance(double distance) {
    fbb_.AddElement<double>(Leg::VT_DISTANCE, distance, 0.0);
  }
  void add_duration(double duration) {
    fbb_.AddElement<double>(Leg::VT_DURATION, duration, 0.0);
  }
  void add_weight(double weight) {
    fbb_.AddElement<double>(Leg::VT_WEIGHT, weight, 0.0);
  }
  void add_summary(flatbuffers::Offset<flatbuffers::String> summary) {
    fbb_.AddOffset(Leg::VT_SUMMARY, summary);
  }
  void add_annotations(flatbuffers::Offset<osrm::engine::api::fbresult::Annotation> annotations) {
    fbb_.AddOffset(Leg::VT_ANNOTATIONS, annotations);
  }
  void add_steps(flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<osrm::engine::api::fbresult::Step>>> steps) {
    fbb_.AddOffset(Leg::VT_STEPS, steps);
  }
  explicit LegBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  LegBuilder &operator=(const LegBuilder &);
  flatbuffers::Offset<Leg> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<Leg>(end);
    return o;
  }
};

inline flatbuffers::Offset<Leg> CreateLeg(
    flatbuffers::FlatBufferBuilder &_fbb,
    double distance = 0.0,
    double duration = 0.0,
    double weight = 0.0,
    flatbuffers::Offset<flatbuffers::String> summary = 0,
    flatbuffers::Offset<osrm::engine::api::fbresult::Annotation> annotations = 0,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<osrm::engine::api::fbresult::Step>>> steps = 0) {
  LegBuilder builder_(_fbb);
  builder_.add_weight(weight);
  builder_.add_duration(duration);
  builder_.add_distance(distance);
  builder_.add_steps(steps);
  builder_.add_annotations(annotations);
  builder_.add_summary(summary);
  return builder_.Finish();
}

inline flatbuffers::Offset<Leg> CreateLegDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    double distance = 0.0,
    double duration = 0.0,
    double weight = 0.0,
    const char *summary = nullptr,
    flatbuffers::Offset<osrm::engine::api::fbresult::Annotation> annotations = 0,
    const std::vector<flatbuffers::Offset<osrm::engine::api::fbresult::Step>> *steps = nullptr) {
  auto summary__ = summary ? _fbb.CreateString(summary) : 0;
  auto steps__ = steps ? _fbb.CreateVector<flatbuffers::Offset<osrm::engine::api::fbresult::Step>>(*steps) : 0;
  return osrm::engine::api::fbresult::CreateLeg(
      _fbb,
      distance,
      duration,
      weight,
      summary__,
      annotations,
      steps__);
}

flatbuffers::Offset<Leg> CreateLeg(flatbuffers::FlatBufferBuilder &_fbb, const LegT *_o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct RouteObjectT : public flatbuffers::NativeTable {
  typedef RouteObject TableType;
  float distance;
  float duration;
  float weight;
  std::string weight_name;
  float confidence;
  std::string polyline;
  std::vector<osrm::engine::api::fbresult::Position> coordinates;
  std::vector<std::unique_ptr<osrm::engine::api::fbresult::LegT>> legs;
  RouteObjectT()
      : distance(0.0f),
        duration(0.0f),
        weight(0.0f),
        confidence(0.0f) {
  }
};

struct RouteObject FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef RouteObjectT NativeTableType;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_DISTANCE = 4,
    VT_DURATION = 6,
    VT_WEIGHT = 8,
    VT_WEIGHT_NAME = 10,
    VT_CONFIDENCE = 12,
    VT_POLYLINE = 14,
    VT_COORDINATES = 16,
    VT_LEGS = 18
  };
  float distance() const {
    return GetField<float>(VT_DISTANCE, 0.0f);
  }
  float duration() const {
    return GetField<float>(VT_DURATION, 0.0f);
  }
  float weight() const {
    return GetField<float>(VT_WEIGHT, 0.0f);
  }
  const flatbuffers::String *weight_name() const {
    return GetPointer<const flatbuffers::String *>(VT_WEIGHT_NAME);
  }
  float confidence() const {
    return GetField<float>(VT_CONFIDENCE, 0.0f);
  }
  const flatbuffers::String *polyline() const {
    return GetPointer<const flatbuffers::String *>(VT_POLYLINE);
  }
  const flatbuffers::Vector<const osrm::engine::api::fbresult::Position *> *coordinates() const {
    return GetPointer<const flatbuffers::Vector<const osrm::engine::api::fbresult::Position *> *>(VT_COORDINATES);
  }
  const flatbuffers::Vector<flatbuffers::Offset<osrm::engine::api::fbresult::Leg>> *legs() const {
    return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<osrm::engine::api::fbresult::Leg>> *>(VT_LEGS);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<float>(verifier, VT_DISTANCE) &&
           VerifyField<float>(verifier, VT_DURATION) &&
           VerifyField<float>(verifier, VT_WEIGHT) &&
           VerifyOffset(verifier, VT_WEIGHT_NAME) &&
           verifier.VerifyString(weight_name()) &&
           VerifyField<float>(verifier, VT_CONFIDENCE) &&
           VerifyOffset(verifier, VT_POLYLINE) &&
           verifier.VerifyString(polyline()) &&
           VerifyOffset(verifier, VT_COORDINATES) &&
           verifier.VerifyVector(coordinates()) &&
           VerifyOffset(verifier, VT_LEGS) &&
           verifier.VerifyVector(legs()) &&
           verifier.VerifyVectorOfTables(legs()) &&
           verifier.EndTable();
  }
  RouteObjectT *UnPack(const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(RouteObjectT *_o, const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<RouteObject> Pack(flatbuffers::FlatBufferBuilder &_fbb, const RouteObjectT* _o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct RouteObjectBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_distance(float distance) {
    fbb_.AddElement<float>(RouteObject::VT_DISTANCE, distance, 0.0f);
  }
  void add_duration(float duration) {
    fbb_.AddElement<float>(RouteObject::VT_DURATION, duration, 0.0f);
  }
  void add_weight(float weight) {
    fbb_.AddElement<float>(RouteObject::VT_WEIGHT, weight, 0.0f);
  }
  void add_weight_name(flatbuffers::Offset<flatbuffers::String> weight_name) {
    fbb_.AddOffset(RouteObject::VT_WEIGHT_NAME, weight_name);
  }
  void add_confidence(float confidence) {
    fbb_.AddElement<float>(RouteObject::VT_CONFIDENCE, confidence, 0.0f);
  }
  void add_polyline(flatbuffers::Offset<flatbuffers::String> polyline) {
    fbb_.AddOffset(RouteObject::VT_POLYLINE, polyline);
  }
  void add_coordinates(flatbuffers::Offset<flatbuffers::Vector<const osrm::engine::api::fbresult::Position *>> coordinates) {
    fbb_.AddOffset(RouteObject::VT_COORDINATES, coordinates);
  }
  void add_legs(flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<osrm::engine::api::fbresult::Leg>>> legs) {
    fbb_.AddOffset(RouteObject::VT_LEGS, legs);
  }
  explicit RouteObjectBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  RouteObjectBuilder &operator=(const RouteObjectBuilder &);
  flatbuffers::Offset<RouteObject> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<RouteObject>(end);
    return o;
  }
};

inline flatbuffers::Offset<RouteObject> CreateRouteObject(
    flatbuffers::FlatBufferBuilder &_fbb,
    float distance = 0.0f,
    float duration = 0.0f,
    float weight = 0.0f,
    flatbuffers::Offset<flatbuffers::String> weight_name = 0,
    float confidence = 0.0f,
    flatbuffers::Offset<flatbuffers::String> polyline = 0,
    flatbuffers::Offset<flatbuffers::Vector<const osrm::engine::api::fbresult::Position *>> coordinates = 0,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<osrm::engine::api::fbresult::Leg>>> legs = 0) {
  RouteObjectBuilder builder_(_fbb);
  builder_.add_legs(legs);
  builder_.add_coordinates(coordinates);
  builder_.add_polyline(polyline);
  builder_.add_confidence(confidence);
  builder_.add_weight_name(weight_name);
  builder_.add_weight(weight);
  builder_.add_duration(duration);
  builder_.add_distance(distance);
  return builder_.Finish();
}

inline flatbuffers::Offset<RouteObject> CreateRouteObjectDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    float distance = 0.0f,
    float duration = 0.0f,
    float weight = 0.0f,
    const char *weight_name = nullptr,
    float confidence = 0.0f,
    const char *polyline = nullptr,
    const std::vector<osrm::engine::api::fbresult::Position> *coordinates = nullptr,
    const std::vector<flatbuffers::Offset<osrm::engine::api::fbresult::Leg>> *legs = nullptr) {
  auto weight_name__ = weight_name ? _fbb.CreateString(weight_name) : 0;
  auto polyline__ = polyline ? _fbb.CreateString(polyline) : 0;
  auto coordinates__ = coordinates ? _fbb.CreateVectorOfStructs<osrm::engine::api::fbresult::Position>(*coordinates) : 0;
  auto legs__ = legs ? _fbb.CreateVector<flatbuffers::Offset<osrm::engine::api::fbresult::Leg>>(*legs) : 0;
  return osrm::engine::api::fbresult::CreateRouteObject(
      _fbb,
      distance,
      duration,
      weight,
      weight_name__,
      confidence,
      polyline__,
      coordinates__,
      legs__);
}

flatbuffers::Offset<RouteObject> CreateRouteObject(flatbuffers::FlatBufferBuilder &_fbb, const RouteObjectT *_o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct TableT : public flatbuffers::NativeTable {
  typedef Table TableType;
  std::vector<float> durations;
  uint16_t rows;
  uint16_t cols;
  std::vector<float> distances;
  std::vector<std::unique_ptr<osrm::engine::api::fbresult::WaypointT>> destinations;
  std::vector<uint32_t> fallback_speed_cells;
  TableT()
      : rows(0),
        cols(0) {
  }
};

struct Table FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef TableT NativeTableType;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_DURATIONS = 4,
    VT_ROWS = 6,
    VT_COLS = 8,
    VT_DISTANCES = 10,
    VT_DESTINATIONS = 12,
    VT_FALLBACK_SPEED_CELLS = 14
  };
  const flatbuffers::Vector<float> *durations() const {
    return GetPointer<const flatbuffers::Vector<float> *>(VT_DURATIONS);
  }
  uint16_t rows() const {
    return GetField<uint16_t>(VT_ROWS, 0);
  }
  uint16_t cols() const {
    return GetField<uint16_t>(VT_COLS, 0);
  }
  const flatbuffers::Vector<float> *distances() const {
    return GetPointer<const flatbuffers::Vector<float> *>(VT_DISTANCES);
  }
  const flatbuffers::Vector<flatbuffers::Offset<osrm::engine::api::fbresult::Waypoint>> *destinations() const {
    return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<osrm::engine::api::fbresult::Waypoint>> *>(VT_DESTINATIONS);
  }
  const flatbuffers::Vector<uint32_t> *fallback_speed_cells() const {
    return GetPointer<const flatbuffers::Vector<uint32_t> *>(VT_FALLBACK_SPEED_CELLS);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_DURATIONS) &&
           verifier.VerifyVector(durations()) &&
           VerifyField<uint16_t>(verifier, VT_ROWS) &&
           VerifyField<uint16_t>(verifier, VT_COLS) &&
           VerifyOffset(verifier, VT_DISTANCES) &&
           verifier.VerifyVector(distances()) &&
           VerifyOffset(verifier, VT_DESTINATIONS) &&
           verifier.VerifyVector(destinations()) &&
           verifier.VerifyVectorOfTables(destinations()) &&
           VerifyOffset(verifier, VT_FALLBACK_SPEED_CELLS) &&
           verifier.VerifyVector(fallback_speed_cells()) &&
           verifier.EndTable();
  }
  TableT *UnPack(const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(TableT *_o, const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<Table> Pack(flatbuffers::FlatBufferBuilder &_fbb, const TableT* _o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct TableBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_durations(flatbuffers::Offset<flatbuffers::Vector<float>> durations) {
    fbb_.AddOffset(Table::VT_DURATIONS, durations);
  }
  void add_rows(uint16_t rows) {
    fbb_.AddElement<uint16_t>(Table::VT_ROWS, rows, 0);
  }
  void add_cols(uint16_t cols) {
    fbb_.AddElement<uint16_t>(Table::VT_COLS, cols, 0);
  }
  void add_distances(flatbuffers::Offset<flatbuffers::Vector<float>> distances) {
    fbb_.AddOffset(Table::VT_DISTANCES, distances);
  }
  void add_destinations(flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<osrm::engine::api::fbresult::Waypoint>>> destinations) {
    fbb_.AddOffset(Table::VT_DESTINATIONS, destinations);
  }
  void add_fallback_speed_cells(flatbuffers::Offset<flatbuffers::Vector<uint32_t>> fallback_speed_cells) {
    fbb_.AddOffset(Table::VT_FALLBACK_SPEED_CELLS, fallback_speed_cells);
  }
  explicit TableBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  TableBuilder &operator=(const TableBuilder &);
  flatbuffers::Offset<Table> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<Table>(end);
    return o;
  }
};

inline flatbuffers::Offset<Table> CreateTable(
    flatbuffers::FlatBufferBuilder &_fbb,
    flatbuffers::Offset<flatbuffers::Vector<float>> durations = 0,
    uint16_t rows = 0,
    uint16_t cols = 0,
    flatbuffers::Offset<flatbuffers::Vector<float>> distances = 0,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<osrm::engine::api::fbresult::Waypoint>>> destinations = 0,
    flatbuffers::Offset<flatbuffers::Vector<uint32_t>> fallback_speed_cells = 0) {
  TableBuilder builder_(_fbb);
  builder_.add_fallback_speed_cells(fallback_speed_cells);
  builder_.add_destinations(destinations);
  builder_.add_distances(distances);
  builder_.add_durations(durations);
  builder_.add_cols(cols);
  builder_.add_rows(rows);
  return builder_.Finish();
}

inline flatbuffers::Offset<Table> CreateTableDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    const std::vector<float> *durations = nullptr,
    uint16_t rows = 0,
    uint16_t cols = 0,
    const std::vector<float> *distances = nullptr,
    const std::vector<flatbuffers::Offset<osrm::engine::api::fbresult::Waypoint>> *destinations = nullptr,
    const std::vector<uint32_t> *fallback_speed_cells = nullptr) {
  auto durations__ = durations ? _fbb.CreateVector<float>(*durations) : 0;
  auto distances__ = distances ? _fbb.CreateVector<float>(*distances) : 0;
  auto destinations__ = destinations ? _fbb.CreateVector<flatbuffers::Offset<osrm::engine::api::fbresult::Waypoint>>(*destinations) : 0;
  auto fallback_speed_cells__ = fallback_speed_cells ? _fbb.CreateVector<uint32_t>(*fallback_speed_cells) : 0;
  return osrm::engine::api::fbresult::CreateTable(
      _fbb,
      durations__,
      rows,
      cols,
      distances__,
      destinations__,
      fallback_speed_cells__);
}

flatbuffers::Offset<Table> CreateTable(flatbuffers::FlatBufferBuilder &_fbb, const TableT *_o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct ErrorT : public flatbuffers::NativeTable {
  typedef Error TableType;
  std::string code;
  std::string message;
  ErrorT() {
  }
};

struct Error FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef ErrorT NativeTableType;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_CODE = 4,
    VT_MESSAGE = 6
  };
  const flatbuffers::String *code() const {
    return GetPointer<const flatbuffers::String *>(VT_CODE);
  }
  const flatbuffers::String *message() const {
    return GetPointer<const flatbuffers::String *>(VT_MESSAGE);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_CODE) &&
           verifier.VerifyString(code()) &&
           VerifyOffset(verifier, VT_MESSAGE) &&
           verifier.VerifyString(message()) &&
           verifier.EndTable();
  }
  ErrorT *UnPack(const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(ErrorT *_o, const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<Error> Pack(flatbuffers::FlatBufferBuilder &_fbb, const ErrorT* _o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct ErrorBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_code(flatbuffers::Offset<flatbuffers::String> code) {
    fbb_.AddOffset(Error::VT_CODE, code);
  }
  void add_message(flatbuffers::Offset<flatbuffers::String> message) {
    fbb_.AddOffset(Error::VT_MESSAGE, message);
  }
  explicit ErrorBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  ErrorBuilder &operator=(const ErrorBuilder &);
  flatbuffers::Offset<Error> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<Error>(end);
    return o;
  }
};

inline flatbuffers::Offset<Error> CreateError(
    flatbuffers::FlatBufferBuilder &_fbb,
    flatbuffers::Offset<flatbuffers::String> code = 0,
    flatbuffers::Offset<flatbuffers::String> message = 0) {
  ErrorBuilder builder_(_fbb);
  builder_.add_message(message);
  builder_.add_code(code);
  return builder_.Finish();
}

inline flatbuffers::Offset<Error> CreateErrorDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    const char *code = nullptr,
    const char *message = nullptr) {
  auto code__ = code ? _fbb.CreateString(code) : 0;
  auto message__ = message ? _fbb.CreateString(message) : 0;
  return osrm::engine::api::fbresult::CreateError(
      _fbb,
      code__,
      message__);
}

flatbuffers::Offset<Error> CreateError(flatbuffers::FlatBufferBuilder &_fbb, const ErrorT *_o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct FBResultT : public flatbuffers::NativeTable {
  typedef FBResult TableType;
  bool error;
  std::unique_ptr<osrm::engine::api::fbresult::ErrorT> code;
  std::string data_version;
  std::vector<std::unique_ptr<osrm::engine::api::fbresult::WaypointT>> waypoints;
  std::vector<std::unique_ptr<osrm::engine::api::fbresult::RouteObjectT>> routes;
  std::unique_ptr<osrm::engine::api::fbresult::TableT> table;
  FBResultT()
      : error(false) {
  }
};

struct FBResult FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef FBResultT NativeTableType;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_ERROR = 4,
    VT_CODE = 6,
    VT_DATA_VERSION = 8,
    VT_WAYPOINTS = 10,
    VT_ROUTES = 12,
    VT_TABLE = 14
  };
  bool error() const {
    return GetField<uint8_t>(VT_ERROR, 0) != 0;
  }
  const osrm::engine::api::fbresult::Error *code() const {
    return GetPointer<const osrm::engine::api::fbresult::Error *>(VT_CODE);
  }
  const flatbuffers::String *data_version() const {
    return GetPointer<const flatbuffers::String *>(VT_DATA_VERSION);
  }
  const flatbuffers::Vector<flatbuffers::Offset<osrm::engine::api::fbresult::Waypoint>> *waypoints() const {
    return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<osrm::engine::api::fbresult::Waypoint>> *>(VT_WAYPOINTS);
  }
  const flatbuffers::Vector<flatbuffers::Offset<osrm::engine::api::fbresult::RouteObject>> *routes() const {
    return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<osrm::engine::api::fbresult::RouteObject>> *>(VT_ROUTES);
  }
  const osrm::engine::api::fbresult::Table *table() const {
    return GetPointer<const osrm::engine::api::fbresult::Table *>(VT_TABLE);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<uint8_t>(verifier, VT_ERROR) &&
           VerifyOffset(verifier, VT_CODE) &&
           verifier.VerifyTable(code()) &&
           VerifyOffset(verifier, VT_DATA_VERSION) &&
           verifier.VerifyString(data_version()) &&
           VerifyOffset(verifier, VT_WAYPOINTS) &&
           verifier.VerifyVector(waypoints()) &&
           verifier.VerifyVectorOfTables(waypoints()) &&
           VerifyOffset(verifier, VT_ROUTES) &&
           verifier.VerifyVector(routes()) &&
           verifier.VerifyVectorOfTables(routes()) &&
           VerifyOffset(verifier, VT_TABLE) &&
           verifier.VerifyTable(table()) &&
           verifier.EndTable();
  }
  FBResultT *UnPack(const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(FBResultT *_o, const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<FBResult> Pack(flatbuffers::FlatBufferBuilder &_fbb, const FBResultT* _o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct FBResultBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_error(bool error) {
    fbb_.AddElement<uint8_t>(FBResult::VT_ERROR, static_cast<uint8_t>(error), 0);
  }
  void add_code(flatbuffers::Offset<osrm::engine::api::fbresult::Error> code) {
    fbb_.AddOffset(FBResult::VT_CODE, code);
  }
  void add_data_version(flatbuffers::Offset<flatbuffers::String> data_version) {
    fbb_.AddOffset(FBResult::VT_DATA_VERSION, data_version);
  }
  void add_waypoints(flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<osrm::engine::api::fbresult::Waypoint>>> waypoints) {
    fbb_.AddOffset(FBResult::VT_WAYPOINTS, waypoints);
  }
  void add_routes(flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<osrm::engine::api::fbresult::RouteObject>>> routes) {
    fbb_.AddOffset(FBResult::VT_ROUTES, routes);
  }
  void add_table(flatbuffers::Offset<osrm::engine::api::fbresult::Table> table) {
    fbb_.AddOffset(FBResult::VT_TABLE, table);
  }
  explicit FBResultBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  FBResultBuilder &operator=(const FBResultBuilder &);
  flatbuffers::Offset<FBResult> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<FBResult>(end);
    return o;
  }
};

inline flatbuffers::Offset<FBResult> CreateFBResult(
    flatbuffers::FlatBufferBuilder &_fbb,
    bool error = false,
    flatbuffers::Offset<osrm::engine::api::fbresult::Error> code = 0,
    flatbuffers::Offset<flatbuffers::String> data_version = 0,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<osrm::engine::api::fbresult::Waypoint>>> waypoints = 0,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<osrm::engine::api::fbresult::RouteObject>>> routes = 0,
    flatbuffers::Offset<osrm::engine::api::fbresult::Table> table = 0) {
  FBResultBuilder builder_(_fbb);
  builder_.add_table(table);
  builder_.add_routes(routes);
  builder_.add_waypoints(waypoints);
  builder_.add_data_version(data_version);
  builder_.add_code(code);
  builder_.add_error(error);
  return builder_.Finish();
}

inline flatbuffers::Offset<FBResult> CreateFBResultDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    bool error = false,
    flatbuffers::Offset<osrm::engine::api::fbresult::Error> code = 0,
    const char *data_version = nullptr,
    const std::vector<flatbuffers::Offset<osrm::engine::api::fbresult::Waypoint>> *waypoints = nullptr,
    const std::vector<flatbuffers::Offset<osrm::engine::api::fbresult::RouteObject>> *routes = nullptr,
    flatbuffers::Offset<osrm::engine::api::fbresult::Table> table = 0) {
  auto data_version__ = data_version ? _fbb.CreateString(data_version) : 0;
  auto waypoints__ = waypoints ? _fbb.CreateVector<flatbuffers::Offset<osrm::engine::api::fbresult::Waypoint>>(*waypoints) : 0;
  auto routes__ = routes ? _fbb.CreateVector<flatbuffers::Offset<osrm::engine::api::fbresult::RouteObject>>(*routes) : 0;
  return osrm::engine::api::fbresult::CreateFBResult(
      _fbb,
      error,
      code,
      data_version__,
      waypoints__,
      routes__,
      table);
}

flatbuffers::Offset<FBResult> CreateFBResult(flatbuffers::FlatBufferBuilder &_fbb, const FBResultT *_o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);

inline WaypointT *Waypoint::UnPack(const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new WaypointT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void Waypoint::UnPackTo(WaypointT *_o, const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  { auto _e = hint(); if (_e) _o->hint = _e->str(); };
  { auto _e = distance(); _o->distance = _e; };
  { auto _e = name(); if (_e) _o->name = _e->str(); };
  { auto _e = location(); if (_e) _o->location = std::unique_ptr<osrm::engine::api::fbresult::Position>(new osrm::engine::api::fbresult::Position(*_e)); };
  { auto _e = nodes(); if (_e) _o->nodes = std::unique_ptr<osrm::engine::api::fbresult::Uint64Pair>(new osrm::engine::api::fbresult::Uint64Pair(*_e)); };
  { auto _e = matchings_index(); _o->matchings_index = _e; };
  { auto _e = waypoint_index(); _o->waypoint_index = _e; };
  { auto _e = alternatives_count(); _o->alternatives_count = _e; };
  { auto _e = trips_index(); _o->trips_index = _e; };
}

inline flatbuffers::Offset<Waypoint> Waypoint::Pack(flatbuffers::FlatBufferBuilder &_fbb, const WaypointT* _o, const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateWaypoint(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<Waypoint> CreateWaypoint(flatbuffers::FlatBufferBuilder &_fbb, const WaypointT *_o, const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs { flatbuffers::FlatBufferBuilder *__fbb; const WaypointT* __o; const flatbuffers::rehasher_function_t *__rehasher; } _va = { &_fbb, _o, _rehasher}; (void)_va;
  auto _hint = _o->hint.empty() ? 0 : _fbb.CreateString(_o->hint);
  auto _distance = _o->distance;
  auto _name = _o->name.empty() ? 0 : _fbb.CreateString(_o->name);
  auto _location = _o->location ? _o->location.get() : 0;
  auto _nodes = _o->nodes ? _o->nodes.get() : 0;
  auto _matchings_index = _o->matchings_index;
  auto _waypoint_index = _o->waypoint_index;
  auto _alternatives_count = _o->alternatives_count;
  auto _trips_index = _o->trips_index;
  return osrm::engine::api::fbresult::CreateWaypoint(
      _fbb,
      _hint,
      _distance,
      _name,
      _location,
      _nodes,
      _matchings_index,
      _waypoint_index,
      _alternatives_count,
      _trips_index);
}

inline MetadataT *Metadata::UnPack(const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new MetadataT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void Metadata::UnPackTo(MetadataT *_o, const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  { auto _e = datasource_names(); if (_e) { _o->datasource_names.resize(_e->size()); for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->datasource_names[_i] = _e->Get(_i)->str(); } } };
}

inline flatbuffers::Offset<Metadata> Metadata::Pack(flatbuffers::FlatBufferBuilder &_fbb, const MetadataT* _o, const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateMetadata(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<Metadata> CreateMetadata(flatbuffers::FlatBufferBuilder &_fbb, const MetadataT *_o, const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs { flatbuffers::FlatBufferBuilder *__fbb; const MetadataT* __o; const flatbuffers::rehasher_function_t *__rehasher; } _va = { &_fbb, _o, _rehasher}; (void)_va;
  auto _datasource_names = _o->datasource_names.size() ? _fbb.CreateVectorOfStrings(_o->datasource_names) : 0;
  return osrm::engine::api::fbresult::CreateMetadata(
      _fbb,
      _datasource_names);
}

inline AnnotationT *Annotation::UnPack(const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new AnnotationT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void Annotation::UnPackTo(AnnotationT *_o, const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  { auto _e = distance(); if (_e) { _o->distance.resize(_e->size()); for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->distance[_i] = _e->Get(_i); } } };
  { auto _e = duration(); if (_e) { _o->duration.resize(_e->size()); for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->duration[_i] = _e->Get(_i); } } };
  { auto _e = datasources(); if (_e) { _o->datasources.resize(_e->size()); for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->datasources[_i] = _e->Get(_i); } } };
  { auto _e = nodes(); if (_e) { _o->nodes.resize(_e->size()); for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->nodes[_i] = _e->Get(_i); } } };
  { auto _e = weight(); if (_e) { _o->weight.resize(_e->size()); for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->weight[_i] = _e->Get(_i); } } };
  { auto _e = speed(); if (_e) { _o->speed.resize(_e->size()); for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->speed[_i] = _e->Get(_i); } } };
  { auto _e = metadata(); if (_e) _o->metadata = std::unique_ptr<osrm::engine::api::fbresult::MetadataT>(_e->UnPack(_resolver)); };
}

inline flatbuffers::Offset<Annotation> Annotation::Pack(flatbuffers::FlatBufferBuilder &_fbb, const AnnotationT* _o, const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateAnnotation(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<Annotation> CreateAnnotation(flatbuffers::FlatBufferBuilder &_fbb, const AnnotationT *_o, const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs { flatbuffers::FlatBufferBuilder *__fbb; const AnnotationT* __o; const flatbuffers::rehasher_function_t *__rehasher; } _va = { &_fbb, _o, _rehasher}; (void)_va;
  auto _distance = _o->distance.size() ? _fbb.CreateVector(_o->distance) : 0;
  auto _duration = _o->duration.size() ? _fbb.CreateVector(_o->duration) : 0;
  auto _datasources = _o->datasources.size() ? _fbb.CreateVector(_o->datasources) : 0;
  auto _nodes = _o->nodes.size() ? _fbb.CreateVector(_o->nodes) : 0;
  auto _weight = _o->weight.size() ? _fbb.CreateVector(_o->weight) : 0;
  auto _speed = _o->speed.size() ? _fbb.CreateVector(_o->speed) : 0;
  auto _metadata = _o->metadata ? CreateMetadata(_fbb, _o->metadata.get(), _rehasher) : 0;
  return osrm::engine::api::fbresult::CreateAnnotation(
      _fbb,
      _distance,
      _duration,
      _datasources,
      _nodes,
      _weight,
      _speed,
      _metadata);
}

inline StepManeuverT *StepManeuver::UnPack(const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new StepManeuverT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void StepManeuver::UnPackTo(StepManeuverT *_o, const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  { auto _e = location(); if (_e) _o->location = std::unique_ptr<osrm::engine::api::fbresult::Position>(new osrm::engine::api::fbresult::Position(*_e)); };
  { auto _e = bearing_before(); _o->bearing_before = _e; };
  { auto _e = bearing_after(); _o->bearing_after = _e; };
  { auto _e = type(); _o->type = _e; };
  { auto _e = modifier(); _o->modifier = _e; };
  { auto _e = exit(); _o->exit = _e; };
}

inline flatbuffers::Offset<StepManeuver> StepManeuver::Pack(flatbuffers::FlatBufferBuilder &_fbb, const StepManeuverT* _o, const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateStepManeuver(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<StepManeuver> CreateStepManeuver(flatbuffers::FlatBufferBuilder &_fbb, const StepManeuverT *_o, const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs { flatbuffers::FlatBufferBuilder *__fbb; const StepManeuverT* __o; const flatbuffers::rehasher_function_t *__rehasher; } _va = { &_fbb, _o, _rehasher}; (void)_va;
  auto _location = _o->location ? _o->location.get() : 0;
  auto _bearing_before = _o->bearing_before;
  auto _bearing_after = _o->bearing_after;
  auto _type = _o->type;
  auto _modifier = _o->modifier;
  auto _exit = _o->exit;
  return osrm::engine::api::fbresult::CreateStepManeuver(
      _fbb,
      _location,
      _bearing_before,
      _bearing_after,
      _type,
      _modifier,
      _exit);
}

inline LaneT *Lane::UnPack(const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new LaneT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void Lane::UnPackTo(LaneT *_o, const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  { auto _e = indications(); if (_e) { _o->indications.resize(_e->size()); for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->indications[_i] = static_cast<osrm::engine::api::fbresult::Turn>(_e->Get(_i)); } } };
  { auto _e = valid(); _o->valid = _e; };
}

inline flatbuffers::Offset<Lane> Lane::Pack(flatbuffers::FlatBufferBuilder &_fbb, const LaneT* _o, const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateLane(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<Lane> CreateLane(flatbuffers::FlatBufferBuilder &_fbb, const LaneT *_o, const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs { flatbuffers::FlatBufferBuilder *__fbb; const LaneT* __o; const flatbuffers::rehasher_function_t *__rehasher; } _va = { &_fbb, _o, _rehasher}; (void)_va;
  auto _indications = _o->indications.size() ? _fbb.CreateVectorScalarCast<int8_t>(flatbuffers::data(_o->indications), _o->indications.size()) : 0;
  auto _valid = _o->valid;
  return osrm::engine::api::fbresult::CreateLane(
      _fbb,
      _indications,
      _valid);
}

inline IntersectionT *Intersection::UnPack(const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new IntersectionT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void Intersection::UnPackTo(IntersectionT *_o, const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  { auto _e = location(); if (_e) _o->location = std::unique_ptr<osrm::engine::api::fbresult::Position>(new osrm::engine::api::fbresult::Position(*_e)); };
  { auto _e = bearings(); if (_e) { _o->bearings.resize(_e->size()); for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->bearings[_i] = _e->Get(_i); } } };
  { auto _e = classes(); if (_e) { _o->classes.resize(_e->size()); for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->classes[_i] = _e->Get(_i)->str(); } } };
  { auto _e = entry(); if (_e) { _o->entry.resize(_e->size()); for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->entry[_i] = _e->Get(_i) != 0; } } };
  { auto _e = in_bearing(); _o->in_bearing = _e; };
  { auto _e = out_bearing(); _o->out_bearing = _e; };
  { auto _e = lanes(); if (_e) { _o->lanes.resize(_e->size()); for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->lanes[_i] = std::unique_ptr<osrm::engine::api::fbresult::LaneT>(_e->Get(_i)->UnPack(_resolver)); } } };
}

inline flatbuffers::Offset<Intersection> Intersection::Pack(flatbuffers::FlatBufferBuilder &_fbb, const IntersectionT* _o, const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateIntersection(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<Intersection> CreateIntersection(flatbuffers::FlatBufferBuilder &_fbb, const IntersectionT *_o, const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs { flatbuffers::FlatBufferBuilder *__fbb; const IntersectionT* __o; const flatbuffers::rehasher_function_t *__rehasher; } _va = { &_fbb, _o, _rehasher}; (void)_va;
  auto _location = _o->location ? _o->location.get() : 0;
  auto _bearings = _o->bearings.size() ? _fbb.CreateVector(_o->bearings) : 0;
  auto _classes = _o->classes.size() ? _fbb.CreateVectorOfStrings(_o->classes) : 0;
  auto _entry = _o->entry.size() ? _fbb.CreateVector(_o->entry) : 0;
  auto _in_bearing = _o->in_bearing;
  auto _out_bearing = _o->out_bearing;
  auto _lanes = _o->lanes.size() ? _fbb.CreateVector<flatbuffers::Offset<osrm::engine::api::fbresult::Lane>> (_o->lanes.size(), [](size_t i, _VectorArgs *__va) { return CreateLane(*__va->__fbb, __va->__o->lanes[i].get(), __va->__rehasher); }, &_va ) : 0;
  return osrm::engine::api::fbresult::CreateIntersection(
      _fbb,
      _location,
      _bearings,
      _classes,
      _entry,
      _in_bearing,
      _out_bearing,
      _lanes);
}

inline StepT *Step::UnPack(const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new StepT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void Step::UnPackTo(StepT *_o, const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  { auto _e = distance(); _o->distance = _e; };
  { auto _e = duration(); _o->duration = _e; };
  { auto _e = polyline(); if (_e) _o->polyline = _e->str(); };
  { auto _e = coordinates(); if (_e) { _o->coordinates.resize(_e->size()); for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->coordinates[_i] = *_e->Get(_i); } } };
  { auto _e = weight(); _o->weight = _e; };
  { auto _e = name(); if (_e) _o->name = _e->str(); };
  { auto _e = ref(); if (_e) _o->ref = _e->str(); };
  { auto _e = pronunciation(); if (_e) _o->pronunciation = _e->str(); };
  { auto _e = destinations(); if (_e) _o->destinations = _e->str(); };
  { auto _e = exits(); if (_e) _o->exits = _e->str(); };
  { auto _e = mode(); if (_e) _o->mode = _e->str(); };
  { auto _e = maneuver(); if (_e) _o->maneuver = std::unique_ptr<osrm::engine::api::fbresult::StepManeuverT>(_e->UnPack(_resolver)); };
  { auto _e = intersections(); if (_e) { _o->intersections.resize(_e->size()); for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->intersections[_i] = std::unique_ptr<osrm::engine::api::fbresult::IntersectionT>(_e->Get(_i)->UnPack(_resolver)); } } };
  { auto _e = rotary_name(); if (_e) _o->rotary_name = _e->str(); };
  { auto _e = rotary_pronunciation(); if (_e) _o->rotary_pronunciation = _e->str(); };
  { auto _e = driving_side(); _o->driving_side = _e; };
}

inline flatbuffers::Offset<Step> Step::Pack(flatbuffers::FlatBufferBuilder &_fbb, const StepT* _o, const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateStep(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<Step> CreateStep(flatbuffers::FlatBufferBuilder &_fbb, const StepT *_o, const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs { flatbuffers::FlatBufferBuilder *__fbb; const StepT* __o; const flatbuffers::rehasher_function_t *__rehasher; } _va = { &_fbb, _o, _rehasher}; (void)_va;
  auto _distance = _o->distance;
  auto _duration = _o->duration;
  auto _polyline = _o->polyline.empty() ? 0 : _fbb.CreateString(_o->polyline);
  auto _coordinates = _o->coordinates.size() ? _fbb.CreateVectorOfStructs(_o->coordinates) : 0;
  auto _weight = _o->weight;
  auto _name = _o->name.empty() ? 0 : _fbb.CreateString(_o->name);
  auto _ref = _o->ref.empty() ? 0 : _fbb.CreateString(_o->ref);
  auto _pronunciation = _o->pronunciation.empty() ? 0 : _fbb.CreateString(_o->pronunciation);
  auto _destinations = _o->destinations.empty() ? 0 : _fbb.CreateString(_o->destinations);
  auto _exits = _o->exits.empty() ? 0 : _fbb.CreateString(_o->exits);
  auto _mode = _o->mode.empty() ? 0 : _fbb.CreateString(_o->mode);
  auto _maneuver = _o->maneuver ? CreateStepManeuver(_fbb, _o->maneuver.get(), _rehasher) : 0;
  auto _intersections = _o->intersections.size() ? _fbb.CreateVector<flatbuffers::Offset<osrm::engine::api::fbresult::Intersection>> (_o->intersections.size(), [](size_t i, _VectorArgs *__va) { return CreateIntersection(*__va->__fbb, __va->__o->intersections[i].get(), __va->__rehasher); }, &_va ) : 0;
  auto _rotary_name = _o->rotary_name.empty() ? 0 : _fbb.CreateString(_o->rotary_name);
  auto _rotary_pronunciation = _o->rotary_pronunciation.empty() ? 0 : _fbb.CreateString(_o->rotary_pronunciation);
  auto _driving_side = _o->driving_side;
  return osrm::engine::api::fbresult::CreateStep(
      _fbb,
      _distance,
      _duration,
      _polyline,
      _coordinates,
      _weight,
      _name,
      _ref,
      _pronunciation,
      _destinations,
      _exits,
      _mode,
      _maneuver,
      _intersections,
      _rotary_name,
      _rotary_pronunciation,
      _driving_side);
}

inline LegT *Leg::UnPack(const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new LegT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void Leg::UnPackTo(LegT *_o, const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  { auto _e = distance(); _o->distance = _e; };
  { auto _e = duration(); _o->duration = _e; };
  { auto _e = weight(); _o->weight = _e; };
  { auto _e = summary(); if (_e) _o->summary = _e->str(); };
  { auto _e = annotations(); if (_e) _o->annotations = std::unique_ptr<osrm::engine::api::fbresult::AnnotationT>(_e->UnPack(_resolver)); };
  { auto _e = steps(); if (_e) { _o->steps.resize(_e->size()); for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->steps[_i] = std::unique_ptr<osrm::engine::api::fbresult::StepT>(_e->Get(_i)->UnPack(_resolver)); } } };
}

inline flatbuffers::Offset<Leg> Leg::Pack(flatbuffers::FlatBufferBuilder &_fbb, const LegT* _o, const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateLeg(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<Leg> CreateLeg(flatbuffers::FlatBufferBuilder &_fbb, const LegT *_o, const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs { flatbuffers::FlatBufferBuilder *__fbb; const LegT* __o; const flatbuffers::rehasher_function_t *__rehasher; } _va = { &_fbb, _o, _rehasher}; (void)_va;
  auto _distance = _o->distance;
  auto _duration = _o->duration;
  auto _weight = _o->weight;
  auto _summary = _o->summary.empty() ? 0 : _fbb.CreateString(_o->summary);
  auto _annotations = _o->annotations ? CreateAnnotation(_fbb, _o->annotations.get(), _rehasher) : 0;
  auto _steps = _o->steps.size() ? _fbb.CreateVector<flatbuffers::Offset<osrm::engine::api::fbresult::Step>> (_o->steps.size(), [](size_t i, _VectorArgs *__va) { return CreateStep(*__va->__fbb, __va->__o->steps[i].get(), __va->__rehasher); }, &_va ) : 0;
  return osrm::engine::api::fbresult::CreateLeg(
      _fbb,
      _distance,
      _duration,
      _weight,
      _summary,
      _annotations,
      _steps);
}

inline RouteObjectT *RouteObject::UnPack(const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new RouteObjectT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void RouteObject::UnPackTo(RouteObjectT *_o, const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  { auto _e = distance(); _o->distance = _e; };
  { auto _e = duration(); _o->duration = _e; };
  { auto _e = weight(); _o->weight = _e; };
  { auto _e = weight_name(); if (_e) _o->weight_name = _e->str(); };
  { auto _e = confidence(); _o->confidence = _e; };
  { auto _e = polyline(); if (_e) _o->polyline = _e->str(); };
  { auto _e = coordinates(); if (_e) { _o->coordinates.resize(_e->size()); for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->coordinates[_i] = *_e->Get(_i); } } };
  { auto _e = legs(); if (_e) { _o->legs.resize(_e->size()); for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->legs[_i] = std::unique_ptr<osrm::engine::api::fbresult::LegT>(_e->Get(_i)->UnPack(_resolver)); } } };
}

inline flatbuffers::Offset<RouteObject> RouteObject::Pack(flatbuffers::FlatBufferBuilder &_fbb, const RouteObjectT* _o, const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateRouteObject(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<RouteObject> CreateRouteObject(flatbuffers::FlatBufferBuilder &_fbb, const RouteObjectT *_o, const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs { flatbuffers::FlatBufferBuilder *__fbb; const RouteObjectT* __o; const flatbuffers::rehasher_function_t *__rehasher; } _va = { &_fbb, _o, _rehasher}; (void)_va;
  auto _distance = _o->distance;
  auto _duration = _o->duration;
  auto _weight = _o->weight;
  auto _weight_name = _o->weight_name.empty() ? 0 : _fbb.CreateString(_o->weight_name);
  auto _confidence = _o->confidence;
  auto _polyline = _o->polyline.empty() ? 0 : _fbb.CreateString(_o->polyline);
  auto _coordinates = _o->coordinates.size() ? _fbb.CreateVectorOfStructs(_o->coordinates) : 0;
  auto _legs = _o->legs.size() ? _fbb.CreateVector<flatbuffers::Offset<osrm::engine::api::fbresult::Leg>> (_o->legs.size(), [](size_t i, _VectorArgs *__va) { return CreateLeg(*__va->__fbb, __va->__o->legs[i].get(), __va->__rehasher); }, &_va ) : 0;
  return osrm::engine::api::fbresult::CreateRouteObject(
      _fbb,
      _distance,
      _duration,
      _weight,
      _weight_name,
      _confidence,
      _polyline,
      _coordinates,
      _legs);
}

inline TableT *Table::UnPack(const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new TableT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void Table::UnPackTo(TableT *_o, const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  { auto _e = durations(); if (_e) { _o->durations.resize(_e->size()); for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->durations[_i] = _e->Get(_i); } } };
  { auto _e = rows(); _o->rows = _e; };
  { auto _e = cols(); _o->cols = _e; };
  { auto _e = distances(); if (_e) { _o->distances.resize(_e->size()); for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->distances[_i] = _e->Get(_i); } } };
  { auto _e = destinations(); if (_e) { _o->destinations.resize(_e->size()); for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->destinations[_i] = std::unique_ptr<osrm::engine::api::fbresult::WaypointT>(_e->Get(_i)->UnPack(_resolver)); } } };
  { auto _e = fallback_speed_cells(); if (_e) { _o->fallback_speed_cells.resize(_e->size()); for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->fallback_speed_cells[_i] = _e->Get(_i); } } };
}

inline flatbuffers::Offset<Table> Table::Pack(flatbuffers::FlatBufferBuilder &_fbb, const TableT* _o, const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateTable(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<Table> CreateTable(flatbuffers::FlatBufferBuilder &_fbb, const TableT *_o, const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs { flatbuffers::FlatBufferBuilder *__fbb; const TableT* __o; const flatbuffers::rehasher_function_t *__rehasher; } _va = { &_fbb, _o, _rehasher}; (void)_va;
  auto _durations = _o->durations.size() ? _fbb.CreateVector(_o->durations) : 0;
  auto _rows = _o->rows;
  auto _cols = _o->cols;
  auto _distances = _o->distances.size() ? _fbb.CreateVector(_o->distances) : 0;
  auto _destinations = _o->destinations.size() ? _fbb.CreateVector<flatbuffers::Offset<osrm::engine::api::fbresult::Waypoint>> (_o->destinations.size(), [](size_t i, _VectorArgs *__va) { return CreateWaypoint(*__va->__fbb, __va->__o->destinations[i].get(), __va->__rehasher); }, &_va ) : 0;
  auto _fallback_speed_cells = _o->fallback_speed_cells.size() ? _fbb.CreateVector(_o->fallback_speed_cells) : 0;
  return osrm::engine::api::fbresult::CreateTable(
      _fbb,
      _durations,
      _rows,
      _cols,
      _distances,
      _destinations,
      _fallback_speed_cells);
}

inline ErrorT *Error::UnPack(const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new ErrorT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void Error::UnPackTo(ErrorT *_o, const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  { auto _e = code(); if (_e) _o->code = _e->str(); };
  { auto _e = message(); if (_e) _o->message = _e->str(); };
}

inline flatbuffers::Offset<Error> Error::Pack(flatbuffers::FlatBufferBuilder &_fbb, const ErrorT* _o, const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateError(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<Error> CreateError(flatbuffers::FlatBufferBuilder &_fbb, const ErrorT *_o, const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs { flatbuffers::FlatBufferBuilder *__fbb; const ErrorT* __o; const flatbuffers::rehasher_function_t *__rehasher; } _va = { &_fbb, _o, _rehasher}; (void)_va;
  auto _code = _o->code.empty() ? 0 : _fbb.CreateString(_o->code);
  auto _message = _o->message.empty() ? 0 : _fbb.CreateString(_o->message);
  return osrm::engine::api::fbresult::CreateError(
      _fbb,
      _code,
      _message);
}

inline FBResultT *FBResult::UnPack(const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new FBResultT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void FBResult::UnPackTo(FBResultT *_o, const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  { auto _e = error(); _o->error = _e; };
  { auto _e = code(); if (_e) _o->code = std::unique_ptr<osrm::engine::api::fbresult::ErrorT>(_e->UnPack(_resolver)); };
  { auto _e = data_version(); if (_e) _o->data_version = _e->str(); };
  { auto _e = waypoints(); if (_e) { _o->waypoints.resize(_e->size()); for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->waypoints[_i] = std::unique_ptr<osrm::engine::api::fbresult::WaypointT>(_e->Get(_i)->UnPack(_resolver)); } } };
  { auto _e = routes(); if (_e) { _o->routes.resize(_e->size()); for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->routes[_i] = std::unique_ptr<osrm::engine::api::fbresult::RouteObjectT>(_e->Get(_i)->UnPack(_resolver)); } } };
  { auto _e = table(); if (_e) _o->table = std::unique_ptr<osrm::engine::api::fbresult::TableT>(_e->UnPack(_resolver)); };
}

inline flatbuffers::Offset<FBResult> FBResult::Pack(flatbuffers::FlatBufferBuilder &_fbb, const FBResultT* _o, const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateFBResult(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<FBResult> CreateFBResult(flatbuffers::FlatBufferBuilder &_fbb, const FBResultT *_o, const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs { flatbuffers::FlatBufferBuilder *__fbb; const FBResultT* __o; const flatbuffers::rehasher_function_t *__rehasher; } _va = { &_fbb, _o, _rehasher}; (void)_va;
  auto _error = _o->error;
  auto _code = _o->code ? CreateError(_fbb, _o->code.get(), _rehasher) : 0;
  auto _data_version = _o->data_version.empty() ? 0 : _fbb.CreateString(_o->data_version);
  auto _waypoints = _o->waypoints.size() ? _fbb.CreateVector<flatbuffers::Offset<osrm::engine::api::fbresult::Waypoint>> (_o->waypoints.size(), [](size_t i, _VectorArgs *__va) { return CreateWaypoint(*__va->__fbb, __va->__o->waypoints[i].get(), __va->__rehasher); }, &_va ) : 0;
  auto _routes = _o->routes.size() ? _fbb.CreateVector<flatbuffers::Offset<osrm::engine::api::fbresult::RouteObject>> (_o->routes.size(), [](size_t i, _VectorArgs *__va) { return CreateRouteObject(*__va->__fbb, __va->__o->routes[i].get(), __va->__rehasher); }, &_va ) : 0;
  auto _table = _o->table ? CreateTable(_fbb, _o->table.get(), _rehasher) : 0;
  return osrm::engine::api::fbresult::CreateFBResult(
      _fbb,
      _error,
      _code,
      _data_version,
      _waypoints,
      _routes,
      _table);
}

inline const osrm::engine::api::fbresult::FBResult *GetFBResult(const void *buf) {
  return flatbuffers::GetRoot<osrm::engine::api::fbresult::FBResult>(buf);
}

inline const osrm::engine::api::fbresult::FBResult *GetSizePrefixedFBResult(const void *buf) {
  return flatbuffers::GetSizePrefixedRoot<osrm::engine::api::fbresult::FBResult>(buf);
}

inline bool VerifyFBResultBuffer(
    flatbuffers::Verifier &verifier) {
  return verifier.VerifyBuffer<osrm::engine::api::fbresult::FBResult>(nullptr);
}

inline bool VerifySizePrefixedFBResultBuffer(
    flatbuffers::Verifier &verifier) {
  return verifier.VerifySizePrefixedBuffer<osrm::engine::api::fbresult::FBResult>(nullptr);
}

inline void FinishFBResultBuffer(
    flatbuffers::FlatBufferBuilder &fbb,
    flatbuffers::Offset<osrm::engine::api::fbresult::FBResult> root) {
  fbb.Finish(root);
}

inline void FinishSizePrefixedFBResultBuffer(
    flatbuffers::FlatBufferBuilder &fbb,
    flatbuffers::Offset<osrm::engine::api::fbresult::FBResult> root) {
  fbb.FinishSizePrefixed(root);
}

inline std::unique_ptr<osrm::engine::api::fbresult::FBResultT> UnPackFBResult(
    const void *buf,
    const flatbuffers::resolver_function_t *res = nullptr) {
  return std::unique_ptr<osrm::engine::api::fbresult::FBResultT>(GetFBResult(buf)->UnPack(res));
}

inline std::unique_ptr<osrm::engine::api::fbresult::FBResultT> UnPackSizePrefixedFBResult(
    const void *buf,
    const flatbuffers::resolver_function_t *res = nullptr) {
  return std::unique_ptr<osrm::engine::api::fbresult::FBResultT>(GetSizePrefixedFBResult(buf)->UnPack(res));
}

}  // namespace fbresult
}  // namespace api
}  // namespace engine
}  // namespace osrm

#endif  // FLATBUFFERS_GENERATED_FBRESULT_OSRM_ENGINE_API_FBRESULT_H_
