use super::fix;
use super::Parser;

#[test]
fn test_fix() {
    assert_eq!(fix("a"), "-a");
    assert_eq!(fix("ab"), "--ab");
    assert_eq!(fix("abc"), "--abc");
}

#[test]
fn test_parser() {
    let parser = Parser::new(&vec!["a".to_string(), "ab".to_string(), "abc".to_string()]);

    assert_eq!(parser.fix("a"), "-a");
    assert_eq!(parser.fix("ab"), "--ab");
    assert_eq!(parser.fix("abc"), "--abc");

    assert_eq!(parser.get("a").unwrap(), "ab");
    assert_eq!(parser.len(), 3);
}
