pub fn fix(arg: &str) -> String {
    Parser::new(&Vec::new()).fix(arg)
}

#[derive(Debug, Clone, PartialEq, Eq, PartialOrd, Ord)]
pub struct Parser {
    inner: Vec<String>,
}

impl Parser {
    pub fn new(argv: &Vec<String>) -> Self {
        Parser {
            inner: argv.clone(),
        }
    }

    pub fn fix(&self, arg: &str) -> String {
        if arg.len() == 1 {
            format!("-{}", arg)
        } else {
            format!("--{}", arg)
        }
    }

    pub fn get(&self, arg: &str) -> Option<&String> {
        let arg = self.fix(arg);

        for (i, arg_) in self.inner.iter().enumerate() {
            if self.fix(arg_) == arg {
                return self.inner.get(i + 1);
            }
        }

        None
    }

    pub fn last(&self) -> Option<&String> {
        self.inner.last()
    }

    pub fn len(&self) -> usize {
        self.inner.len()
    }
}

#[cfg(test)]
mod tests;
