use super::*;
use std::env;

#[test]
fn test_collect() {
    assert_eq!(collect(), env::args().collect::<Vec<String>>());
}

#[test]
fn test_fix() {
    assert_eq!(fix("test").unwrap(), "--test");
}

#[test]
fn test_get() {
    match get("test", &collect()) {
        Ok(ok) => panic!("expected error, not `{}`", ok),
        Err(err) => assert_eq!(err.to_string(), "no such argument"),
    }
}

#[test]
fn test_contains() {
    assert!(!contains("test", &collect()));
}
