use super::*;

pub struct Parser {
    argv: Vec<String>
}

impl Parser {
    pub fn new() -> Parser {
        Parser {
            argv: args::collect()
        }
    }

    pub fn from(argv: Vec<String>) -> Parser {
        Parser { argv }
    }

    pub fn contains<S: AsRef<str>>(&self, noprefix: S) -> bool {
        self.argv.contains(&args::prefix(noprefix.as_ref().to_string()))
    }

    pub fn value_of<S: AsRef<str>>(&self, noprefix: S) -> Result<String, mtk::ValueError> {
        let fixed = args::prefix(noprefix.as_ref().to_string());

        if self.contains(noprefix.as_ref().to_string()) {
            for idx in 0..self.argv.len() {
                let idx_value = match self.argv.get(idx) {
                    Some(some) => some.clone(),
                    None => return Err(mtk::ValueError::from(format!("could not get from index {}", idx)))
                };

                if idx_value == fixed {
                    let arg_value = match self.argv.get(idx + 1) {
                        Some(some) => some.clone(),
                        None => return Err(mtk::ValueError::from(format!("could not get from index {}", idx)))
                    };

                    return Ok(arg_value);
                }
            }
        } else {
            return Err(mtk::ValueError::from(format!("could not get value of '{}'", noprefix.as_ref().to_string())));
        }

        Err(mtk::ValueError::from(format!("could not get value of '{}'", noprefix.as_ref().to_string())))
    }

    pub fn clone_argv(&self) -> Vec<String> {
        self.argv.clone()
    }
}
