pub mod parse;
pub mod args;

pub use parse::*;

#[cfg(test)]
mod tests {
    use super::*;

    #[test]
    fn test_args() {
        // consider fn args::collect() -> Vec<String> as working
        assert!(true);

        assert_eq!(args::prefix("a"), "-a");
        assert_eq!(args::prefix("abc"), "--abc");
    }

    #[test]
    fn test_parse() {
        let parser = Parser::from(vec!["-a".to_string(), "--abc".to_string(), "0".to_string()]);

        assert_eq!(parser.contains("a"), true);
        assert_eq!(parser.contains("abc"), true);
        assert_eq!(parser.contains("abcdef"), false);

        assert_eq!(match parser.value_of("abc") {
            Ok(ok) => ok,
            Err(err) => panic!("{}", err.to_string())
        }, "0");
    }
}
