use std::env;

pub fn collect() -> Vec<String> {
    env::args().collect()
}

pub fn prefix<S: AsRef<str>>(noprefix: S) -> String {
    let mut modifiable = noprefix.as_ref().to_string();

    if modifiable.len() == 1 {
        modifiable = format!("-{}", modifiable);
    } else {
        modifiable = format!("--{}", modifiable);
    }

    modifiable
}
