#[cfg(test)]
mod tests {
    use super::*;

    #[test]
    fn test_fix() {
        assert_eq!(fix("f"), "-f");
        assert_eq!(fix("fixed"), "--fixed");
    }

    #[test]
    fn test_parser() {
        let parser: Parser = Parser::from(&vec![String::from("--test"), String::from("value"), String::from("-t")]);

        assert_eq!(parser.contains("test"), true);
        assert_eq!(parser.contains("t"), true);

        assert_eq!(parser.contains("abc"), false);
        assert_eq!(parser.contains("a"), false);

        assert_eq!(parser.value_of("test"), "value");
    }

    #[test]
    fn test_clean() {
        let vec: Vec<String> = vec![String::from("./a.out"), String::from(".")];

        assert_eq!(clean(vec), vec![String::from(".")]);
    }
}

use std::env;

struct Parser {
    pub args: Vec<String>
}

impl Parser {
    pub fn from(new_args: &Vec<String>) -> Parser {
        Parser {
            args: new_args.clone()
        }
    }

    pub fn contains(&self, ufixed: &str) -> bool {
        self.args.contains(&fix(ufixed))
    }

    pub fn value_of(&self, ufixed: &str) -> String {
        let mut res: String = String::new();
        
        let mut i: usize = 0;

        for x in self.args.iter() {
            if String::from(x) == fix(ufixed) {
                res = self.args[i + 1].clone();
            }

            i = i + 1;
        }

        res
    }
}

pub fn fix(ufixed: &str) -> String {
    let res = if ufixed.len() == 1 { "-" } else { "--" };

    String::from(res) + ufixed
}

pub fn clean(collected: Vec<String>) -> Vec<String> {
    let mut clone = collected.clone();

    clone.remove(0);
    clone
}

pub fn collect() -> Vec<String> {
    clean(env::args().collect()).clone()
}
