//! Matrices used by the SobolSampler.

// see sobolmatrices.h

pub const NUM_SOBOL_DIMENSIONS: u16 = 1024_u16;
pub const SOBOL_MATRIX_SIZE: u8 = 52_u8;
pub const SOBOL_MATRICES_32: [u32; (NUM_SOBOL_DIMENSIONS * SOBOL_MATRIX_SIZE as u16) as usize] = [
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x1000_0000,
    0x0800_0000,
    0x0400_0000,
    0x0200_0000,
    0x0100_0000,
    0x0080_0000,
    0x0040_0000,
    0x0020_0000,
    0x0010_0000,
    0x0008_0000,
    0x0004_0000,
    0x0002_0000,
    0x0001_0000,
    0x0000_8000,
    0x0000_4000,
    0x0000_2000,
    0x0000_1000,
    0x0000_0800,
    0x0000_0400,
    0x0000_0200,
    0x0000_0100,
    0x0000_0080,
    0x0000_0040,
    0x0000_0020,
    0x0000_0010,
    0x0000_0008,
    0x0000_0004,
    0x0000_0002,
    0x0000_0001,
    0x0000_0000,
    0x0000_0000,
    0x0000_0000,
    0x0000_0000,
    0x0000_0000,
    0x0000_0000,
    0x0000_0000,
    0x0000_0000,
    0x0000_0000,
    0x0000_0000,
    0x0000_0000,
    0x0000_0000,
    0x0000_0000,
    0x0000_0000,
    0x0000_0000,
    0x0000_0000,
    0x0000_0000,
    0x0000_0000,
    0x0000_0000,
    0x0000_0000,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0xf000_0000,
    0x8800_0000,
    0xcc00_0000,
    0xaa00_0000,
    0xff00_0000,
    0x8080_0000,
    0xc0c0_0000,
    0xa0a0_0000,
    0xf0f0_0000,
    0x8888_0000,
    0xcccc_0000,
    0xaaaa_0000,
    0xffff_0000,
    0x8000_8000,
    0xc000_c000,
    0xa000_a000,
    0xf000_f000,
    0x8800_8800,
    0xcc00_cc00,
    0xaa00_aa00,
    0xff00_ff00,
    0x8080_8080,
    0xc0c0_c0c0,
    0xa0a0_a0a0,
    0xf0f0_f0f0,
    0x8888_8888,
    0xcccc_cccc,
    0xaaaa_aaaa,
    0xffff_ffff,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0xf000_0000,
    0x8800_0000,
    0xcc00_0000,
    0xaa00_0000,
    0xff00_0000,
    0x8080_0000,
    0xc0c0_0000,
    0xa0a0_0000,
    0xf0f0_0000,
    0x8888_0000,
    0xcccc_0000,
    0xaaaa_0000,
    0xffff_0000,
    0x8000_8000,
    0xc000_c000,
    0xa000_a000,
    0xf000_f000,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x9000_0000,
    0xe800_0000,
    0x5c00_0000,
    0x8e00_0000,
    0xc500_0000,
    0x6880_0000,
    0x9cc0_0000,
    0xee60_0000,
    0x5590_0000,
    0x8068_0000,
    0xc09c_0000,
    0x60ee_0000,
    0x9055_0000,
    0xe880_8000,
    0x5cc0_c000,
    0x8e60_6000,
    0xc590_9000,
    0x6868_e800,
    0x9c9c_5c00,
    0xeeee_8e00,
    0x5555_c500,
    0x8000_e880,
    0xc000_5cc0,
    0x6000_8e60,
    0x9000_c590,
    0xe800_6868,
    0x5c00_9c9c,
    0x8e00_eeee,
    0xc500_5555,
    0x6880_8000,
    0x9cc0_c000,
    0xee60_6000,
    0x5590_9000,
    0x8068_e800,
    0xc09c_5c00,
    0x60ee_8e00,
    0x9055_c500,
    0xe880_e880,
    0x5cc0_5cc0,
    0x8e60_8e60,
    0xc590_c590,
    0x6868_6868,
    0x9c9c_9c9c,
    0xeeee_eeee,
    0x5555_5555,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x9000_0000,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x5000_0000,
    0xf800_0000,
    0x7400_0000,
    0xa200_0000,
    0x9300_0000,
    0xd880_0000,
    0x2540_0000,
    0x59e0_0000,
    0xe6d0_0000,
    0x7808_0000,
    0xb40c_0000,
    0x8202_0000,
    0xc305_0000,
    0x208f_8000,
    0x5147_4000,
    0xfbea_2000,
    0x75d9_3000,
    0xa085_8800,
    0x914e_5400,
    0xdbe7_9e00,
    0x25db_6d00,
    0x5880_0080,
    0xe540_00c0,
    0x79e0_0020,
    0xb6d0_0050,
    0x8008_00f8,
    0xc00c_0074,
    0x2002_00a2,
    0x5005_0093,
    0xf80f_80d8,
    0x7407_4025,
    0xa20a_2059,
    0x9309_30e6,
    0xd88d_8878,
    0x2542_54b4,
    0x59e5_9e82,
    0xe6de_6dc3,
    0x780f_80a0,
    0xb407_4091,
    0x820a_20db,
    0xc309_3025,
    0x208d_8858,
    0x5142_54e5,
    0xfbe5_9e79,
    0x75de_6db6,
    0xa08f_8000,
    0x9147_4000,
    0xdbea_2000,
    0x25d9_3000,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xb000_0000,
    0xf800_0000,
    0xdc00_0000,
    0x7a00_0000,
    0x9d00_0000,
    0x5a80_0000,
    0x2fc0_0000,
    0xa160_0000,
    0xf0b0_0000,
    0xda88_0000,
    0x6fc4_0000,
    0x8162_0000,
    0x40bb_0000,
    0x2287_8000,
    0xb3c9_c000,
    0xfb65_a000,
    0xddb2_d000,
    0x7802_2800,
    0x9c0b_3c00,
    0x5a0f_b600,
    0x2d0d_db00,
    0xa287_8080,
    0xf3c9_c040,
    0xdb65_a020,
    0x6db2_d0b0,
    0x8002_28f8,
    0x400b_3cdc,
    0x200f_b67a,
    0xb00d_db9d,
    0xf807_80da,
    0xdc09_c06f,
    0x7a05_a081,
    0x9d02_d040,
    0x5a8a_2822,
    0x2fcf_3cb3,
    0xa16d_b6fb,
    0xf0b6_dbdd,
    0xda80_00f8,
    0x6fc0_00dc,
    0x8160_007a,
    0x40b0_009d,
    0x2288_005a,
    0xb3c4_002f,
    0xfb62_00a1,
    0xddbb_00f0,
    0x7807_80da,
    0x9c09_c06f,
    0x5a05_a081,
    0x2d02_d040,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x3000_0000,
    0xc800_0000,
    0x2400_0000,
    0x5600_0000,
    0xfb00_0000,
    0xe080_0000,
    0x7040_0000,
    0xa860_0000,
    0x1430_0000,
    0x9ec8_0000,
    0xdf24_0000,
    0xb6d6_0000,
    0x8bbb_0000,
    0x4800_8000,
    0x6400_4000,
    0x3600_6000,
    0xcb00_3000,
    0x2880_c800,
    0x5440_2400,
    0xfe60_5600,
    0xef30_fb00,
    0x7e48_e080,
    0xaf64_7040,
    0x1eb6_a860,
    0x9f8b_1430,
    0xd6c8_1ec8,
    0xbb24_9f24,
    0x80d6_d6d6,
    0x40bb_bbbb,
    0x6080_0000,
    0x3040_0000,
    0xc860_0000,
    0x2430_0000,
    0x56c8_0000,
    0xfb24_0000,
    0xe0d6_0000,
    0x70bb_0000,
    0xa880_8000,
    0x1440_4000,
    0x9e60_6000,
    0xdf30_3000,
    0xb648_c800,
    0x8b64_2400,
    0x48b6_5600,
    0x648b_fb00,
    0x3648_6080,
    0xcb64_3040,
    0x28b6_c860,
    0x548b_2430,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0xd000_0000,
    0x5800_0000,
    0x9400_0000,
    0x3e00_0000,
    0xe300_0000,
    0xbe80_0000,
    0x23c0_0000,
    0x1e20_0000,
    0xf310_0000,
    0x4678_0000,
    0x6784_0000,
    0x7846_0000,
    0x8467_0000,
    0xc678_8000,
    0xa784_c000,
    0xd846_a000,
    0x5467_d000,
    0x9e78_d800,
    0x3384_5400,
    0xe646_9e00,
    0xb767_3300,
    0x20f8_6680,
    0x1044_77c0,
    0xf866_8020,
    0x4477_c010,
    0x6680_20f8,
    0x77c0_1044,
    0x8020_f866,
    0xc010_4477,
    0xa0f8_6680,
    0xd044_77c0,
    0x5866_8020,
    0x9477_c010,
    0x3e80_20f8,
    0xe3c0_1044,
    0xbe20_f866,
    0x2310_4477,
    0x1e78_6680,
    0xf384_77c0,
    0x4646_8020,
    0x6767_c010,
    0x78f8_20f8,
    0x8444_1044,
    0xc666_f866,
    0xa777_4477,
    0xd800_e680,
    0x5400_b7c0,
    0x9e00_2020,
    0x3300_1010,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x5000_0000,
    0x8800_0000,
    0x2400_0000,
    0x1200_0000,
    0x2d00_0000,
    0x7680_0000,
    0x9e40_0000,
    0x0820_0000,
    0x6410_0000,
    0xb228_0000,
    0x7d14_0000,
    0xfea2_0000,
    0xba49_0000,
    0x1a24_8000,
    0x491b_4000,
    0xc4b5_a000,
    0xe373_9000,
    0xf680_0800,
    0xde40_0400,
    0xa820_0a00,
    0x3410_0500,
    0x3a28_0880,
    0x5914_0240,
    0xeca2_0120,
    0x9749_02d0,
    0x6ca4_8768,
    0xd75b_49e4,
    0xcc95_a082,
    0x8763_9641,
    0x44a8_0322,
    0xa354_03d1,
    0x5682_05ea,
    0x8e59_0ea4,
    0x200c_8922,
    0x100f_46d1,
    0x2817_ad6b,
    0x743a_9ce7,
    0x9a24_8000,
    0x091b_4000,
    0x64b5_a000,
    0xb373_9000,
    0x7e80_0800,
    0xfa40_0400,
    0xba20_0a00,
    0x1910_0500,
    0x4ca8_0880,
    0xc754_0240,
    0xe482_0120,
    0xf359_02d0,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x5000_0000,
    0x2800_0000,
    0xd400_0000,
    0x6a00_0000,
    0x7100_0000,
    0x3880_0000,
    0x5840_0000,
    0xea20_0000,
    0x3110_0000,
    0x98a8_0000,
    0x0854_0000,
    0xc22a_0000,
    0xe525_0000,
    0xf2b2_8000,
    0x7948_4000,
    0xfaa4_2000,
    0xbd73_1000,
    0x18a8_0800,
    0x4854_0400,
    0x622a_0a00,
    0xb525_0500,
    0xdab2_8280,
    0xad48_4d40,
    0x90a4_26a0,
    0xcc73_1710,
    0x2028_0b88,
    0x1014_0184,
    0x880a_04a2,
    0x8435_0611,
    0x421a_8b0a,
    0xa51c_4dc5,
    0x528e_2a82,
    0x2956_1942,
    0xd29a_84a3,
    0x695c_4610,
    0x72ae_2b08,
    0x3946_1dc6,
    0x5ab2_8280,
    0xed48_4d40,
    0x30a4_26a0,
    0x9c73_1710,
    0x0828_0b88,
    0xc414_0184,
    0xe20a_04a2,
    0xf535_0611,
    0x7a9a_8b0a,
    0xfd5c_4dc5,
    0xb8ae_2a82,
    0x1846_1942,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0xb000_0000,
    0x9800_0000,
    0x9400_0000,
    0x8a00_0000,
    0x5b00_0000,
    0x3380_0000,
    0xd9c0_0000,
    0x7220_0000,
    0x3f10_0000,
    0xc1b8_0000,
    0xa6ec_0000,
    0x5386_0000,
    0x29f5_0000,
    0x0a3a_8000,
    0x1b2a_c000,
    0xd392_e000,
    0x69ff_7000,
    0xea38_0800,
    0xab2c_0400,
    0x4ba6_0e00,
    0xfde5_0b00,
    0x6002_8980,
    0xf006_c940,
    0x7834_e8a0,
    0x241a_75b0,
    0x123a_8b38,
    0xcf2a_c99c,
    0xb992_e922,
    0x82ff_78f1,
    0x41b8_0d9b,
    0xe6ec_072e,
    0xb386_0398,
    0x99f5_0c2f,
    0x923a_8a1b,
    0x8f2a_c56e,
    0x5992_e2bb,
    0x32ff_70de,
    0xd9b8_0980,
    0x72ec_0940,
    0x3986_08a0,
    0xc2f5_05b0,
    0xa1ba_8338,
    0x56ea_cd9c,
    0x2bb2_e722,
    0x0def_73f1,
    0x1800_041b,
    0xd400_0e6e,
    0x6a00_0b38,
    0xeb00_099f,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x1000_0000,
    0x0800_0000,
    0x6c00_0000,
    0x9e00_0000,
    0x2300_0000,
    0x5780_0000,
    0xadc0_0000,
    0x7fa0_0000,
    0x91d0_0000,
    0x4988_0000,
    0xced4_0000,
    0x880a_0000,
    0x2c0f_0000,
    0x3e0d_8000,
    0x3317_c000,
    0x5fb0_6000,
    0xc1f8_b000,
    0xe18d_8800,
    0xb2d7_c400,
    0x1e10_6a00,
    0x6328_b100,
    0xf785_8880,
    0xbdc3_c2c0,
    0x77ba_63e0,
    0xfdf7_b330,
    0xd780_0df8,
    0xedc0_081c,
    0xdfa0_041a,
    0x81d0_0a2d,
    0x4188_0160,
    0xa2d4_00f1,
    0x160a_069a,
    0x0f0f_09ed,
    0x698d_8200,
    0x9ed7_c500,
    0x2010_6a81,
    0x5028_b7c2,
    0xa805_8160,
    0x7c03_c0f1,
    0x961a_669a,
    0x4f27_b9ed,
    0xc988_0a00,
    0x8ed4_0100,
    0x280a_0081,
    0x3c0f_06c2,
    0x360d_89e0,
    0x5f17_c231,
    0xc1b0_657a,
    0xe2f8_badd,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x3000_0000,
    0x5800_0000,
    0xac00_0000,
    0x9600_0000,
    0x2b00_0000,
    0xd480_0000,
    0x0940_0000,
    0xe2a0_0000,
    0x5250_0000,
    0x4e28_0000,
    0xc71c_0000,
    0x629e_0000,
    0x1267_0000,
    0x6e13_8000,
    0xf731_c000,
    0x3a98_a000,
    0xbe44_9000,
    0xf83b_8800,
    0xdc2d_c400,
    0xee06_a200,
    0xb723_9300,
    0x1aa8_0d80,
    0x8e5c_0ec0,
    0xa03e_0b60,
    0x7037_01b0,
    0x783b_88c8,
    0x9c2d_ca54,
    0xce06_a74a,
    0x8723_9795,
    0x42a8_01aa,
    0x225c_08e5,
    0x363e_0a03,
    0x5b37_0703,
    0xacbb_8783,
    0x956d_c9c2,
    0x2ca6_ace0,
    0xd573_9872,
    0x0c80_0c2a,
    0xe540_0625,
    0x54a0_0163,
    0x4950_06b3,
    0xc2a8_0f4b,
    0x625c_0396,
    0x163e_0baa,
    0x6b37_0fe7,
    0xf4bb_8d80,
    0x396d_cec0,
    0xbaa6_ab60,
    0xfe73_91b0,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x5000_0000,
    0xf800_0000,
    0x8c00_0000,
    0xe200_0000,
    0x3300_0000,
    0x0f80_0000,
    0x2140_0000,
    0x95a0_0000,
    0x5e70_0000,
    0xd808_0000,
    0x1c24_0000,
    0xba16_0000,
    0xef37_0000,
    0x1586_8000,
    0x9e6f_c000,
    0x781b_6000,
    0x4c34_9000,
    0x420e_8800,
    0x630b_cc00,
    0xf7ad_6a00,
    0xad73_9500,
    0x7780_0780,
    0x6d40_04c0,
    0xd7a0_0420,
    0x3d70_0630,
    0x2f88_0f78,
    0xb164_0ad4,
    0xcdb6_077a,
    0x8247_06d7,
    0xc20e_8d78,
    0xa30b_c3d6,
    0x57ad_62fb,
    0xfd73_9b14,
    0x8f80_04d8,
    0xe140_0424,
    0x35a0_0620,
    0x0e70_0f30,
    0x2008_0af8,
    0x9024_0716,
    0x5816_06db,
    0xdc37_0d24,
    0x1a06_83a0,
    0xbf2f_c2f0,
    0xedbb_6b5a,
    0x1244_9ce7,
    0x9a06_8000,
    0x7f2f_c000,
    0x4dbb_6000,
    0x4244_9000,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x9000_0000,
    0x3800_0000,
    0xc400_0000,
    0x4200_0000,
    0xa300_0000,
    0xf180_0000,
    0xaa40_0000,
    0xfce0_0000,
    0x8510_0000,
    0xe008_0000,
    0x500c_0000,
    0x5806_0000,
    0x5409_0000,
    0x7a03_8000,
    0x670c_4000,
    0xb384_2000,
    0x094a_3000,
    0x0d6f_1800,
    0x2f5a_a400,
    0x1ce7_ce00,
    0xd514_5100,
    0xb800_0080,
    0x0400_00c0,
    0x2200_0060,
    0x3300_0090,
    0xc980_0038,
    0x6e40_00c4,
    0xbee0_0042,
    0x2610_00a3,
    0x1188_00f1,
    0xfa4c_00aa,
    0xa4e6_00fc,
    0xd119_0085,
    0x9a0b_80e0,
    0x3700_4050,
    0xeb82_2058,
    0x5d43_3054,
    0x776c_987a,
    0x4856_e467,
    0xaf63_eeb3,
    0xdc5e_6109,
    0xb56f_188d,
    0x2b5a_a4ef,
    0x3ee7_ce7c,
    0xe614_5145,
    0x7180_0000,
    0x6a40_0000,
    0x9ce0_0000,
    0x1510_0000,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xf000_0000,
    0xa800_0000,
    0x5400_0000,
    0x9a00_0000,
    0x9d00_0000,
    0x1e80_0000,
    0x5cc0_0000,
    0x7d20_0000,
    0x8d10_0000,
    0x2488_0000,
    0x71c4_0000,
    0xeba2_0000,
    0x75df_0000,
    0x6ba2_8000,
    0x35d1_4000,
    0x4ba3_a000,
    0xc5d2_d000,
    0xe3a1_6800,
    0x91db_8c00,
    0x79ae_f200,
    0x0cdf_4100,
    0x672a_8080,
    0x5015_4040,
    0x1a01_a020,
    0xdd0d_d0f0,
    0x3e83_e8a8,
    0xacca_cc54,
    0xd52d_529a,
    0xd91d_919d,
    0xbe83_e89e,
    0xecca_cc1c,
    0xf52d_525d,
    0x291d_917d,
    0x1683_e80c,
    0xb8ca_cc65,
    0x6f2d_5251,
    0xb41d_9118,
    0x0803_e85d,
    0xe40a_cc7d,
    0x120d_528c,
    0x390d_9125,
    0x2c8b_e8f1,
    0x95ce_cca8,
    0xf9af_5255,
    0x4cd2_9199,
    0x4729_681e,
    0xa01f_8c5c,
    0xb20c_f27d,
    0x8900_418d,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0xd000_0000,
    0xd800_0000,
    0xc400_0000,
    0x4600_0000,
    0x8500_0000,
    0xa580_0000,
    0x76c0_0000,
    0xada0_0000,
    0x6ab0_0000,
    0x2da8_0000,
    0xaabc_0000,
    0x0daa_0000,
    0x7ab1_0000,
    0xd5a7_8000,
    0xbebd_4000,
    0x93a3_e000,
    0x3bb5_1000,
    0x3629_b800,
    0x4d72_7c00,
    0x9b83_6200,
    0x27c4_d700,
    0xb629_b880,
    0x8d72_7cc0,
    0xbb83_6220,
    0xf7c4_d7d0,
    0x6e29_b858,
    0x4972_7c04,
    0xfd83_6266,
    0x72c4_d755,
    0xcba9_b8fd,
    0x3fb2_7c72,
    0x5023_62cb,
    0x1874_d73f,
    0xe601_b8d0,
    0x950e_7cd8,
    0x5d89_62c6,
    0x62c5_d745,
    0x33a6_3805,
    0x2bb3_3c66,
    0xce2a_8255,
    0x5970_c77e,
    0x058f_8033,
    0x66c1_402b,
    0x55a9_e0ce,
    0x7eb4_1059,
    0xb3a6_3805,
    0xebb3_3c66,
    0xee2a_8255,
    0x8970_c77e,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xf000_0000,
    0x3800_0000,
    0x1400_0000,
    0xf600_0000,
    0x6700_0000,
    0x8f80_0000,
    0x5040_0000,
    0x8aa0_0000,
    0x0ff0_0000,
    0x12a8_0000,
    0xabf4_0000,
    0xfcaa_0000,
    0x28fb_0000,
    0xbd29_8000,
    0x0bba_4000,
    0x4e06_e000,
    0x330c_3000,
    0x5986_1800,
    0xc74d_3400,
    0x3d2c_b200,
    0x4bb2_cb00,
    0x6e06_1880,
    0xc30d_3440,
    0x618c_b220,
    0xd342_cbf0,
    0xcb2e_18b8,
    0x2cb9_3454,
    0xe186_b2d6,
    0x9349_cb97,
    0xeb2f_9837,
    0xdcb7_7404,
    0xd98a_525c,
    0x874e_fb98,
    0x1d28_0025,
    0xbbb4_00af,
    0x560a_00a0,
    0xd70b_00b0,
    0x9781_8018,
    0xb44e_40e4,
    0x44ac_e0ce,
    0x7cf7_3073,
    0x6b2f_9879,
    0x9cb7_7437,
    0xf98a_5205,
    0x774e_fb5f,
    0x2528_0018,
    0xafb4_00e4,
    0xa00a_00ce,
    0xb00b_0073,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0xf000_0000,
    0x6800_0000,
    0x6400_0000,
    0x3600_0000,
    0x6d00_0000,
    0x4180_0000,
    0xe040_0000,
    0xd2e0_0000,
    0x9bf0_0000,
    0x0ce8_0000,
    0x52fc_0000,
    0x5b6a_0000,
    0x2fb3_0000,
    0xa00c_8000,
    0x3005_4000,
    0x4807_e000,
    0x940f_9000,
    0x5e01_f800,
    0x090e_9400,
    0x778a_5600,
    0x8d41_6b00,
    0x9369_f880,
    0x7bb2_94c0,
    0xde00_5620,
    0xc902_6bf0,
    0x578d_78e8,
    0x7d4b_d4a4,
    0xfb6d_b616,
    0x1fbe_fb9d,
    0xe800_00a9,
    0xa400_0044,
    0x1600_00c4,
    0x9d00_0006,
    0x2980_0025,
    0x8440_00d6,
    0xe4e0_00bf,
    0xf6f0_00d9,
    0x4d68_00ed,
    0xb2bc_0082,
    0x898a_00c1,
    0xb443_0020,
    0xace4_80f2,
    0x62f9_406b,
    0x136d_e064,
    0xbbbc_9036,
    0xfe0d_786d,
    0x390b_d442,
    0x3f8d_b6e1,
    0x194e_fbd0,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x5000_0000,
    0x9800_0000,
    0xf400_0000,
    0xae00_0000,
    0xbb00_0000,
    0xe780_0000,
    0x95c0_0000,
    0x1c20_0000,
    0xd030_0000,
    0xdba8_0000,
    0x55f4_0000,
    0xff82_0000,
    0x21c1_0000,
    0x1223_8000,
    0x3b3a_4000,
    0xa42b_6000,
    0x3430_f000,
    0x4da6_9800,
    0x4af3_ec00,
    0x2e04_3a00,
    0xfb0a_1f00,
    0x4785_1880,
    0xc5c9_ac40,
    0x842f_5aa0,
    0x243a_ef50,
    0x75a3_8018,
    0xeefa_40b4,
    0x180b_600e,
    0xb400_f0eb,
    0x0e0e_987f,
    0xeb07_ec61,
    0x7f86_3ab2,
    0x61cb_1f6b,
    0xb226_98bc,
    0x6b33_ec80,
    0x3c24_3a43,
    0xc03a_1fa1,
    0xe3ad_18d1,
    0xf1fd_acda,
    0xc98d_5a55,
    0x6ecb_effe,
    0x5ba8_00a0,
    0x15f4_0050,
    0x5f82_0098,
    0x71c1_00f4,
    0x8a23_80ae,
    0xcf3a_40bb,
    0x0a2b_60e7,
    0x8f30_f095,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0xb000_0000,
    0xb800_0000,
    0x3c00_0000,
    0xce00_0000,
    0x4100_0000,
    0x2180_0000,
    0x51c0_0000,
    0x0960_0000,
    0x8570_0000,
    0xf278_0000,
    0x8e9c_0000,
    0x6002_0000,
    0x7003_0000,
    0x5803_8000,
    0x8c02_c000,
    0x7602_e000,
    0x7d00_f000,
    0xef83_3800,
    0x10c1_0400,
    0x28e0_8600,
    0xd4b1_4700,
    0xfb18_2580,
    0x0bee_15c0,
    0x9279_c9e0,
    0xfe9d_3a70,
    0x3800_0008,
    0xfc00_000c,
    0x2e00_000e,
    0xf100_000b,
    0x9980_000b,
    0x6dc0_0003,
    0xc760_000c,
    0xc470_0004,
    0xd3f8_0002,
    0xdf5c_0005,
    0x6962_0000,
    0xf573_0008,
    0xaa7b_800f,
    0x029e_c008,
    0x1600_e006,
    0x0d03_f007,
    0xb780_b805,
    0x9cc3_c408,
    0x5ee2_6607,
    0xa9b1_b707,
    0x149b_1d8e,
    0x1b2f_11c1,
    0xba99_4fe2,
    0x2a2c_7d7d,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0xd000_0000,
    0x6800_0000,
    0x3c00_0000,
    0x8a00_0000,
    0x5100_0000,
    0xa980_0000,
    0xddc0_0000,
    0x5ba0_0000,
    0x39d0_0000,
    0x95f8_0000,
    0x56d4_0000,
    0x0a02_0000,
    0x9103_0000,
    0x4983_8000,
    0x0dc3_4000,
    0x33a1_a000,
    0x05d0_f000,
    0x1ffa_2800,
    0x07d5_4400,
    0xa380_a600,
    0x4cc0_7700,
    0x1222_ee80,
    0x3413_a740,
    0xa65b_f7e0,
    0x5305_ab50,
    0x15f8_0008,
    0x96d4_000c,
    0xea02_000e,
    0x4103_000d,
    0x2183_8006,
    0x31c3_4003,
    0xb9a1_a008,
    0x54d0_f005,
    0xb67a_280a,
    0xda15_440d,
    0xf820_a605,
    0x7510_7703,
    0x87da_ee89,
    0x62c7_a745,
    0xac59_f7e0,
    0xc206_ab59,
    0x5c7b_800c,
    0x9b17_400c,
    0xd9a3_a00d,
    0x44d3_f00d,
    0x3e79_a807,
    0x3616_0403,
    0x1a21_0602,
    0x1810_8701,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0xd000_0000,
    0x3800_0000,
    0x8c00_0000,
    0x7e00_0000,
    0x7100_0000,
    0xc880_0000,
    0x04c0_0000,
    0x1ba0_0000,
    0xbb70_0000,
    0x4a98_0000,
    0xc3bc_0000,
    0xa602_0000,
    0x6d01_0000,
    0xee81_8000,
    0x29c3_4000,
    0x9520_e000,
    0x42b2_3000,
    0xe7b9_f800,
    0x0d0d_c400,
    0x3fb9_2200,
    0x110d_1300,
    0x19bb_ee80,
    0x3c0c_adc0,
    0x973a_4a60,
    0xc5cf_7ef0,
    0x3a18_0008,
    0x0b7c_0004,
    0xa3a2_0006,
    0x7771_000d,
    0x5499_8003,
    0x62bf_4008,
    0x5682_e007,
    0xe5c3_3007,
    0x8b20_780c,
    0xe3b2_8400,
    0x173b_c201,
    0x85ce_230b,
    0x5a1b_9684,
    0xdb7e_29cc,
    0x9ba1_886a,
    0xfb71_5df6,
    0x2a9b_9686,
    0x13be_29c6,
    0x9e01_886f,
    0xe101_5df9,
    0x9083_9685,
    0x58c2_29cc,
    0x5da3_8862,
    0x4670_5dfb,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x9000_0000,
    0x0800_0000,
    0x6400_0000,
    0x6a00_0000,
    0x8900_0000,
    0xa580_0000,
    0xcb40_0000,
    0x1820_0000,
    0xad90_0000,
    0xaf88_0000,
    0x72f4_0000,
    0x2582_0000,
    0x0b43_0000,
    0xb822_8000,
    0x3d92_4000,
    0xa788_2000,
    0x16f5_9000,
    0x4f83_a800,
    0x8241_2400,
    0x1da0_1600,
    0xf6d1_6d00,
    0xbfa8_4080,
    0xbb67_2640,
    0xe009_1620,
    0xf0b4_efd0,
    0x3822_8008,
    0xfd92_400c,
    0x0788_200a,
    0x86f5_9009,
    0x4783_a800,
    0xe641_2406,
    0x77a0_1606,
    0x7fd1_6d08,
    0x1a28_408a,
    0x7027_264c,
    0xf829_1621,
    0x5d24_efda,
    0x97aa_8002,
    0x8f66_400b,
    0x220a_2008,
    0x8db6_9009,
    0xffa1_280b,
    0xdbd3_6405,
    0xd028_360c,
    0x6924_fd09,
    0x55ab_e88e,
    0xf266_0244,
    0xe589_0020,
    0xabf5_82d5,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0xd000_0000,
    0x4800_0000,
    0x8c00_0000,
    0xd600_0000,
    0x3900_0000,
    0xd580_0000,
    0x3240_0000,
    0xb2a0_0000,
    0x7210_0000,
    0x53d8_0000,
    0x82cc_0000,
    0xcb82_0000,
    0x4743_0000,
    0x9120_8000,
    0xa953_4000,
    0x7cf9_2000,
    0x4e9e_3000,
    0xfcf9_5800,
    0x8e9f_e400,
    0xdcf9_d600,
    0x5e9c_8900,
    0x94f9_6a80,
    0xd29f_b840,
    0x42f9_b760,
    0xeb9c_9f30,
    0x9778_8008,
    0xd9df_400c,
    0x25db_2002,
    0xabcd_300d,
    0x7601_d804,
    0x2900_a408,
    0xbd82_f60d,
    0x6e41_b903,
    0x2ca0_b28d,
    0xc713_1c43,
    0x5059_416b,
    0x898e_2637,
    0xaca0_b28d,
    0x0713_1c44,
    0x7059_416e,
    0x598e_2639,
    0xe4a0_b285,
    0x8b13_1c4e,
    0xa659_4168,
    0x608e_263a,
    0x3120_b28e,
    0xb953_1c4f,
    0x14f9_4169,
    0x129e_263c,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x5000_0000,
    0xd800_0000,
    0xf400_0000,
    0x3e00_0000,
    0x9500_0000,
    0x8f80_0000,
    0x3d40_0000,
    0xf320_0000,
    0x2ef0_0000,
    0xadc8_0000,
    0x0a0c_0000,
    0x8b22_0000,
    0x4af3_0000,
    0x6bc8_8000,
    0x3b0d_4000,
    0xe2a1_6000,
    0x16b0_d000,
    0x2968_7800,
    0xbdbf_1400,
    0x33cb_5e00,
    0x0f0c_2500,
    0xfca1_b480,
    0xd3b0_afc0,
    0x7eeb_6920,
    0x74fe_4d30,
    0xfee8_7808,
    0xb4ff_140c,
    0xdeeb_5e02,
    0xe4fc_2505,
    0x06e9_b48d,
    0x10fc_afcf,
    0x38e9_6923,
    0x85fd_4d39,
    0xb768_f800,
    0xb8be_540f,
    0x4448_3e0d,
    0x964f_f507,
    0xe981_4c87,
    0x9c42_fbcf,
    0x62a1_572b,
    0xd6b2_b83d,
    0x0969_b486,
    0xedbc_afcc,
    0xebc9_6923,
    0xfb0d_4d36,
    0xc2a0_f80d,
    0x46b2_5408,
    0xf16a_3e0a,
    0x49bc_f508,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0xb000_0000,
    0x9800_0000,
    0xa400_0000,
    0x7a00_0000,
    0xd500_0000,
    0x0280_0000,
    0x6040_0000,
    0x51e0_0000,
    0x8870_0000,
    0x8c28_0000,
    0x47c4_0000,
    0x0be2_0000,
    0xad71_0000,
    0xb6aa_8000,
    0x3386_c000,
    0xb800_6000,
    0x5403_9000,
    0x4203_6800,
    0xc101_9400,
    0xe082_6a00,
    0x1143_1100,
    0x2960_af80,
    0x3d31_75c0,
    0xdf4a_3aa0,
    0xaff4_9e10,
    0xd62b_6808,
    0x62c5_9404,
    0x3160_6a0a,
    0xd932_110b,
    0x054a_2f89,
    0xcaf7_b5ca,
    0x4caa_5aa7,
    0xa687_0e1d,
    0x1a80_0008,
    0x8440_0002,
    0x8be0_000f,
    0xed70_0003,
    0x16a8_0001,
    0x8384_000e,
    0x2002_0007,
    0xf001_0007,
    0x3802_800b,
    0x1402_c005,
    0xe202_600e,
    0x7102_900d,
    0x7881_e80c,
    0xb543_5408,
    0x5360_0a0e,
    0xe831_810b,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x3000_0000,
    0x1800_0000,
    0x3400_0000,
    0x8a00_0000,
    0x9d00_0000,
    0x6780_0000,
    0x8240_0000,
    0x40e0_0000,
    0x60f0_0000,
    0x9148_0000,
    0x2944_0000,
    0x2d62_0000,
    0xbfb3_0000,
    0x162a_8000,
    0xfbf4_c000,
    0xe4ca_6000,
    0xc207_d000,
    0x2002_a800,
    0xf001_b400,
    0xb803_7e00,
    0x0402_1900,
    0x9203_4b80,
    0xa903_27c0,
    0xed81_f320,
    0x1f40_d810,
    0x2760_2808,
    0xe2b1_740c,
    0xd1ab_1e0a,
    0x49b6_c903,
    0xbc2b_6381,
    0x96f6_53c3,
    0x3b48_ed28,
    0x4445_1119,
    0xf2e1_cb8e,
    0x39f3_e7c4,
    0xc4c9_932e,
    0x3204_0815,
    0x9800_0000,
    0xf400_000d,
    0x2a00_0000,
    0xad00_0001,
    0x7f80_0006,
    0xb640_0004,
    0xcae0_0002,
    0xfdf0_0003,
    0xf6c8_000d,
    0xab04_0005,
    0x6d82_000d,
    0xdf43_000d,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0xd000_0000,
    0x0800_0000,
    0x4c00_0000,
    0x0200_0000,
    0xb500_0000,
    0x3680_0000,
    0xc2c0_0000,
    0x1420_0000,
    0x0750_0000,
    0x1bf8_0000,
    0x5034_0000,
    0x48a2_0000,
    0xac91_0000,
    0xd35b_8000,
    0xbca7_4000,
    0x7bfa_2000,
    0xc034_3000,
    0xa0a1_8800,
    0x3090_9400,
    0xd95b_7a00,
    0x45a5_7b00,
    0x4f7a_7880,
    0xb7f6_f940,
    0x8201_3de0,
    0xf502_dfd0,
    0xd682_0808,
    0x12c3_d404,
    0x1c23_5a0e,
    0x4b50_4b0d,
    0x19f8_7080,
    0xe535_2d44,
    0x7e22_67e0,
    0x6e52_94db,
    0xc77a_788b,
    0xbbf6_f948,
    0x6001_3def,
    0x9002_dfdd,
    0xe802_0809,
    0x9c03_d405,
    0x0a03_5a0a,
    0xf900_4b0c,
    0x3480_708e,
    0x77c1_2d43,
    0x22a0_67e6,
    0xc593_94d7,
    0x0fd9_f880,
    0x5765_b94e,
    0x5359_1de6,
    0xfca7_efd3,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x5000_0000,
    0x6800_0000,
    0x4c00_0000,
    0x7600_0000,
    0xf700_0000,
    0x3680_0000,
    0xd740_0000,
    0x87e0_0000,
    0xef30_0000,
    0xa3a8_0000,
    0xd544_0000,
    0x23aa_0000,
    0x1547_0000,
    0xc3a9_8000,
    0x4546_4000,
    0xaba8_2000,
    0x0947_7000,
    0xdda9_f800,
    0xfe44_ac00,
    0xeb29_2200,
    0x2907_f100,
    0x6ccb_3d80,
    0xc634_4dc0,
    0xcf61_b320,
    0x1373_18d0,
    0xeccb_3d88,
    0x0634_4dcc,
    0x2f61_b32e,
    0x4373_18d5,
    0x84cb_3d8e,
    0x4a34_4dc8,
    0x5961_b329,
    0xb473_18da,
    0xb24b_3d8d,
    0x9d74_4dc5,
    0xde81_b321,
    0x5b43_18d4,
    0x11e3_3d87,
    0x4830_4dc8,
    0xfd2b_b323,
    0x4e04_18d5,
    0xd24a_bd8b,
    0x0d76_0dcc,
    0x5683_9329,
    0x4743_68d5,
    0x0fe3_4586,
    0xf332_a1c3,
    0xbdaa_b127,
    0x6e44_99d7,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x9000_0000,
    0xc800_0000,
    0x7400_0000,
    0x5200_0000,
    0x0300_0000,
    0xeb80_0000,
    0x6f40_0000,
    0x6460_0000,
    0xdaf0_0000,
    0x1798_0000,
    0x297c_0000,
    0xa59a_0000,
    0xfa7d_0000,
    0xe61b_8000,
    0x713f_4000,
    0x1878_a000,
    0xdcce_9000,
    0xb661_e800,
    0x99f2_9c00,
    0x9c18_4600,
    0xd63e_2100,
    0x09fa_5780,
    0x548e_0ac0,
    0xa380_a9e0,
    0x5b41_3f30,
    0x5662_5788,
    0x49f2_0ac4,
    0x341a_a9e6,
    0x323c_3f39,
    0x93f9_d784,
    0x238d_4ac3,
    0x1a02_09e3,
    0x3702_af39,
    0xd980_3f8a,
    0xfc43_d6c5,
    0x47e0_4fe5,
    0xc1b1_8e34,
    0x21f9_e80b,
    0xf08e_9c07,
    0x5982_460f,
    0xbc43_210b,
    0x27e1_d78d,
    0x51b1_4ac4,
    0xe9f8_09e8,
    0x848f_af3f,
    0x0b83_bf82,
    0xbf40_96ce,
    0xcc62_efe2,
    0x3ef2_1e3b,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0xd000_0000,
    0xb800_0000,
    0x0400_0000,
    0x6e00_0000,
    0x9700_0000,
    0xf280_0000,
    0xedc0_0000,
    0x1360_0000,
    0x5c90_0000,
    0xdb58_0000,
    0x31e4_0000,
    0x09da_0000,
    0xcc27_0000,
    0x02b8_8000,
    0x44b4_4000,
    0x0fe2_6000,
    0xe650_5000,
    0x9ab9_d800,
    0x50b5_0c00,
    0x79e2_9200,
    0xa552_fb00,
    0xbe38_bf80,
    0x2e77_d940,
    0xf600_0ae0,
    0x8301_12d0,
    0x8480_3f88,
    0xaec3_994c,
    0x37e2_6aea,
    0x2251_42dd,
    0x54b9_e783,
    0x17b6_954c,
    0x3360_f8ec,
    0x4c93_b9d4,
    0xc359_580c,
    0xe5e5_4c02,
    0xdfda_f20d,
    0x5f25_ab01,
    0x9e39_e789,
    0x3e76_954d,
    0xee00_f8e7,
    0x5703_b9d0,
    0x5281_580a,
    0x3dc1_4c05,
    0xab60_f20b,
    0x5892_ab0a,
    0xb559_678f,
    0xa6e6_d542,
    0xfb58_98e1,
    0x21e4_e9d1,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x3000_0000,
    0x6800_0000,
    0xec00_0000,
    0x2200_0000,
    0x2b00_0000,
    0x3680_0000,
    0x9d40_0000,
    0x6a20_0000,
    0x1670_0000,
    0x4de8_0000,
    0x330c_0000,
    0x936a_0000,
    0x824f_0000,
    0x3b49_8000,
    0x8f3f_c000,
    0x2820_2000,
    0xcd70_7000,
    0xf36a_a800,
    0x724f_dc00,
    0xb34b_f200,
    0x533e_6900,
    0x6220_7a80,
    0x0a71_40c0,
    0xe7ea_6520,
    0xc40d_90f0,
    0xefe9_fa88,
    0xd80e_80cc,
    0x45ea_452e,
    0x2f0d_e0f3,
    0x396b_528e,
    0x754d_5cc2,
    0x47cb_b72c,
    0xd57c_89f1,
    0x5682_a80d,
    0x6d43_dc0b,
    0xe221_f20a,
    0xca71_6900,
    0x07e9_fa81,
    0xf40e_80c4,
    0x87ea_452d,
    0x340d_e0fb,
    0x67eb_528c,
    0x040d_5cce,
    0x0feb_b723,
    0xe80c_89f6,
    0x2dea_a806,
    0xc30f_dc0e,
    0x1b6b_f20c,
    0x5e4e_6900,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x3000_0000,
    0x2800_0000,
    0xd400_0000,
    0x8a00_0000,
    0xff00_0000,
    0x8480_0000,
    0x73c0_0000,
    0x1320_0000,
    0xc2b0_0000,
    0xfb38_0000,
    0x361c_0000,
    0x401a_0000,
    0xe0af_0000,
    0x1122_8000,
    0x19b3_c000,
    0xfdb8_2000,
    0x5edf_9000,
    0x75b8_8800,
    0x7adf_ac00,
    0xf7ba_ba00,
    0x61dd_f300,
    0xd138_7e80,
    0x391e_55c0,
    0xcc9b_a860,
    0x776c_beb0,
    0xa000_f688,
    0xf001_f9cc,
    0x0801_1262,
    0xe401_4db3,
    0xa200_880a,
    0x2b03_ac01,
    0x0e80_ba0a,
    0x8cc2_f30c,
    0x97a2_fe8a,
    0xb171_95ca,
    0xe819_8869,
    0xf4ac_2eb3,
    0xbb22_fe8f,
    0xd6b1_95c8,
    0x5139_8867,
    0xf91c_2eb1,
    0xec9a_fe84,
    0x476d_95c3,
    0x8803_8861,
    0x2403_2eb7,
    0x8200_7e84,
    0x1b02_55c0,
    0x2681_a86b,
    0x58c3_beb3,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x5000_0000,
    0xb800_0000,
    0x8400_0000,
    0x1a00_0000,
    0xaf00_0000,
    0xbd80_0000,
    0xdfc0_0000,
    0x14e0_0000,
    0x4350_0000,
    0xda38_0000,
    0x4e1c_0000,
    0x4cda_0000,
    0x364d_0000,
    0x2960_8000,
    0xdc90_4000,
    0x6ed8_6000,
    0x5d4f_5000,
    0x2ee0_8800,
    0xfc51_ac00,
    0x7fb8_1e00,
    0x45dc_8300,
    0xfa3a_4580,
    0x5e1d_6240,
    0x54db_d360,
    0xe24e_c930,
    0x8b62_cd88,
    0xf790_ce44,
    0xc959_cd6a,
    0x2d8f_4a35,
    0x8780_0803,
    0x60c1_ec0c,
    0xb160_7e0b,
    0x4893_d30f,
    0x6cda_cd80,
    0x264c_ce45,
    0x3163_cd60,
    0x0892_4a3e,
    0xccd8_880e,
    0x764d_ac0d,
    0x8962_1e0f,
    0x8c91_8302,
    0xd6da_c584,
    0xd94d_2241,
    0x34e3_b363,
    0x5351_993c,
    0xc23a_4583,
    0x9a1d_624b,
    0xeedb_d36a,
    0x1d4e_c930,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x7000_0000,
    0x0800_0000,
    0xf400_0000,
    0xf600_0000,
    0x8b00_0000,
    0xc980_0000,
    0x5540_0000,
    0x6720_0000,
    0xf3f0_0000,
    0x3478_0000,
    0x5744_0000,
    0x1ada_0000,
    0xb1f5_0000,
    0xa981_8000,
    0x6540_c000,
    0x8f23_a000,
    0x77f2_1000,
    0xca7b_f800,
    0x2845_fc00,
    0x255a_fe00,
    0x6fb6_7900,
    0x0723_3a80,
    0xc3f2_5ac0,
    0xdc7a_ed60,
    0xd344_82d0,
    0xe4d9_4288,
    0xcef7_66c4,
    0x9603_b36e,
    0xbb00_ebd7,
    0x2181_8008,
    0xd140_c00b,
    0x9923_a001,
    0x8cf2_100f,
    0x0bfb_f80c,
    0x8905_fc0a,
    0xb47a_fe09,
    0x1746_7907,
    0xfadb_3a8f,
    0xc1f6_5ac0,
    0xa180_ed67,
    0x9141_82d4,
    0x7920_c281,
    0xfcf3_a6c7,
    0x03fa_1367,
    0x7d07_fbdb,
    0x427b_f80e,
    0x9c45_fc0f,
    0x335a_fe0b,
    0x94b6_790e,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x9000_0000,
    0x6800_0000,
    0xf400_0000,
    0x6200_0000,
    0xdf00_0000,
    0x7980_0000,
    0xdd40_0000,
    0x76e0_0000,
    0x2cf0_0000,
    0xcfb8_0000,
    0x51ec_0000,
    0xc8da_0000,
    0x845d_0000,
    0x9b81_8000,
    0x4243_4000,
    0xef62_2000,
    0x61b1_9000,
    0xd158_2800,
    0x891c_ac00,
    0x6562_6e00,
    0x0ab1_0900,
    0x2adb_bd80,
    0x1b5d_86c0,
    0x0201_4560,
    0x0f03_2470,
    0xf182_1588,
    0xb942_6ac4,
    0x7ce1_0b6e,
    0x07f3_bd79,
    0xd439_800e,
    0x53af_400b,
    0xc7b8_2008,
    0x75ec_9004,
    0x22d9_a801,
    0x3f5f_ec02,
    0xe800_4e01,
    0xb400_990f,
    0x8203_958b,
    0x4f01_2ac8,
    0x1183_2b6b,
    0x2942_2d7a,
    0x14e1_a80d,
    0xf3f3_ec05,
    0xb63a_4e0c,
    0x8cad_9907,
    0xbe3a_1582,
    0xa8ae_6ac3,
    0x543b_0b6e,
    0x13ae_bd7b,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x5000_0000,
    0x1800_0000,
    0xdc00_0000,
    0x4200_0000,
    0x3700_0000,
    0x2080_0000,
    0xf140_0000,
    0x2860_0000,
    0x9490_0000,
    0x8788_0000,
    0xa83c_0000,
    0x556a_0000,
    0xe6ef_0000,
    0xf803_8000,
    0x4c02_4000,
    0x3a01_e000,
    0xbb02_3000,
    0x7a81_6800,
    0x1a43_ac00,
    0x4ae1_8a00,
    0x52d3_1900,
    0x8f68_2380,
    0xcded_9740,
    0xfa80_bfa0,
    0xda43_f2b0,
    0x2ae2_cb88,
    0x02d0_7b4c,
    0x976a_d5a6,
    0x11ed_dbb5,
    0xb880_0009,
    0xed40_0001,
    0x0a60_0002,
    0xf390_0006,
    0xbf08_0003,
    0x857c_0002,
    0x3f0a_0006,
    0x457f_000a,
    0x5f0b_800a,
    0x157e_4005,
    0x470b_e007,
    0xc97d_3007,
    0x050a_e807,
    0xfe7d_ec0e,
    0x258a_6a06,
    0x0f3e_2905,
    0x0dea_cb88,
    0x9bac_7b45,
    0x8a60_d5a7,
    0x3392_dbbe,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0xf000_0000,
    0xf800_0000,
    0x3400_0000,
    0x6200_0000,
    0xf500_0000,
    0xa880_0000,
    0xfcc0_0000,
    0x8e20_0000,
    0x53f0_0000,
    0xc778_0000,
    0x9574_0000,
    0xb802_0000,
    0xd4e5_0000,
    0xb280_8000,
    0xfdc0_c000,
    0x64a0_2000,
    0xaa30_f000,
    0x19d8_f800,
    0x0e44_3400,
    0x935a_6200,
    0xe761_f500,
    0x657a_2880,
    0x4091_3cc0,
    0xe002_2e20,
    0xd0e5_63f0,
    0x0880_9f78,
    0xccc0_9174,
    0x5620_0202,
    0x97f0_e5e5,
    0x5d78_8000,
    0x5474_c000,
    0x7282_2000,
    0xdd25_f000,
    0x9420_7800,
    0x52f0_f400,
    0x2df8_4200,
    0x6cb4_0500,
    0x66a2_5080,
    0x4fd5_c8c0,
    0x99d8_6c20,
    0xce44_66f0,
    0xb35a_4ff8,
    0x1761_99b4,
    0x9d7a_4e22,
    0x7491_7315,
    0x8202_b7f8,
    0x25e5_adb4,
    0xa000_2c22,
    0x3000_8615,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0xf000_0000,
    0xf800_0000,
    0xec00_0000,
    0x7e00_0000,
    0x6100_0000,
    0x5c80_0000,
    0xe6c0_0000,
    0xdda0_0000,
    0x2a70_0000,
    0x9338_0000,
    0x13cc_0000,
    0xd3ce_0000,
    0x7379_0000,
    0x83a0_8000,
    0x7b70_c000,
    0x97b8_a000,
    0xe90c_f000,
    0x886e_f800,
    0xd409_ec00,
    0x3218_fe00,
    0xef7c_a100,
    0xc556_fc80,
    0x56c5_16c0,
    0x4556_a5a0,
    0x96c5_0670,
    0xe556_cd38,
    0x66c5_42cc,
    0x1d56_574e,
    0x8ac5_49b9,
    0x6356_f800,
    0xebc5_ec00,
    0x3fd6_fe00,
    0x0d05_a100,
    0xe276_7c80,
    0x2775_d6c0,
    0x714e_05a0,
    0x34b9_f670,
    0xa280_3538,
    0x47c0_aecc,
    0x2120_a94e,
    0x3cb0_e8b9,
    0xb698_8480,
    0xd5bc_3ac0,
    0x3ef6_fba0,
    0x01b5_5770,
    0x0cee_c9b8,
    0xeec9_b80c,
    0xc9b8_0cee,
    0xb80c_eec9,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0xb000_0000,
    0x5800_0000,
    0x2c00_0000,
    0x9a00_0000,
    0xf900_0000,
    0x3c80_0000,
    0xb2c0_0000,
    0xad20_0000,
    0x3a30_0000,
    0x8998_0000,
    0x448c_0000,
    0x2eea_0000,
    0x6f81_0000,
    0xef20_8000,
    0x2f30_c000,
    0x0f18_2000,
    0xbf4c_b000,
    0xe74a_5800,
    0xcb71_2c00,
    0x5198_1a00,
    0xa88c_3900,
    0x94ea_1c80,
    0x2681_02c0,
    0x8ba0_7520,
    0xb1f0_d630,
    0x3838_3398,
    0x7c7c_0d8c,
    0x5252_4a6a,
    0x3d3d_f141,
    0xd252_5800,
    0xfd3d_2c00,
    0xf252_1a00,
    0x4d3d_3900,
    0xaa52_9c80,
    0x613d_c2c0,
    0x3052_5520,
    0x983d_6630,
    0x0cd2_eb98,
    0x2afd_e18c,
    0xa1f2_706a,
    0x10cd_7841,
    0x286a_1c80,
    0x5441_02c0,
    0x0680_7520,
    0x3bc0_d630,
    0xe9a0_3398,
    0x14f0_0d8c,
    0xe6b8_4a6a,
    0xabbc_f141,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0xb000_0000,
    0xd800_0000,
    0xac00_0000,
    0x8e00_0000,
    0x0900_0000,
    0x9e80_0000,
    0xa1c0_0000,
    0xcaa0_0000,
    0x3370_0000,
    0x9578_0000,
    0x085c_0000,
    0x24b6_0000,
    0x6a35_0000,
    0x4378_8000,
    0x6d5c_c000,
    0x1436_2000,
    0x72f5_b000,
    0xcf58_5800,
    0x53ec_6c00,
    0xc5ee_ae00,
    0x40d9_b900,
    0xe016_c680,
    0x9045_cdc0,
    0x6880_e4a0,
    0x74c0_4a70,
    0x2220_f3f8,
    0x87b0_b59c,
    0x9758_b816,
    0x3fec_fc45,
    0x6bee_c680,
    0xf9d9_cdc0,
    0xa696_e4a0,
    0x9d85_4a70,
    0x2c20_73f8,
    0x4eb0_759c,
    0x29d8_9816,
    0x2e2c_4c45,
    0x794e_1e80,
    0x66a9_61c0,
    0xbdee_6aa0,
    0x9cd9_4370,
    0x9616_ed78,
    0x8545_d45c,
    0xa000_d2b6,
    0x7000_bf35,
    0xf800_abf8,
    0x1c00_d99c,
    0x5600_1616,
    0xa500_4545,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0xf000_0000,
    0xa800_0000,
    0x2c00_0000,
    0xa200_0000,
    0x2d00_0000,
    0xda80_0000,
    0xf940_0000,
    0xec60_0000,
    0x02b0_0000,
    0x3d48_0000,
    0x825c_0000,
    0x7d4a_0000,
    0x6261_0000,
    0x8dc8_8000,
    0xca1c_4000,
    0xa1aa_e000,
    0x6891_f000,
    0x8c60_2800,
    0xb2b0_6c00,
    0x7548_4200,
    0x5e5c_dd00,
    0x774a_7280,
    0x6361_d540,
    0xf548_ce60,
    0x1e5c_6fb0,
    0x974a_07c8,
    0x9361_8b1c,
    0x5d48_b92a,
    0x325c_0cd1,
    0x354a_f280,
    0xbe61_9540,
    0x87c8_2e60,
    0xcb1c_9fb0,
    0xd92a_afc8,
    0xbcd1_a71c,
    0xba80_1b2a,
    0x4940_21d1,
    0xa460_2800,
    0xdeb0_6c00,
    0x3748_4200,
    0x835c_dd00,
    0x05ca_7280,
    0xb621_d540,
    0xbb28_ce60,
    0x31ec_6fb0,
    0x7082_07c8,
    0xe87d_8b1c,
    0xcc62_b92a,
    0x528d_0cd1,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x3000_0000,
    0xc800_0000,
    0x7c00_0000,
    0x8200_0000,
    0x4f00_0000,
    0xbe80_0000,
    0xedc0_0000,
    0x2160_0000,
    0xab70_0000,
    0x7868_0000,
    0x746c_0000,
    0x1e9a_0000,
    0xfdcb_0000,
    0x3908_8000,
    0x2f1c_c000,
    0x4ef2_e000,
    0xc5a7_3000,
    0x6d92_4800,
    0xe1d7_bc00,
    0x4b7a_e200,
    0x487b_bf00,
    0xbc80_1680,
    0x62c0_61c0,
    0x7fe0_8b60,
    0x76b0_a870,
    0x9108_8ce8,
    0xa31c_aaac,
    0xe4f2_037a,
    0xc6a7_f47b,
    0x9912_5e80,
    0x3f17_ddc0,
    0x569a_6960,
    0x41cb_1770,
    0x5b08_9a68,
    0x501c_cb6c,
    0x3872_881a,
    0x5467_5c0b,
    0xcef2_d268,
    0x05a7_776c,
    0x8d92_6a1a,
    0xd1d7_e30b,
    0x837a_44e8,
    0x347b_d6ac,
    0x3e80_017a,
    0x2dc0_7b7b,
    0xc160_8000,
    0x9b70_c000,
    0xb068_e000,
    0x086c_3000,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x1000_0000,
    0x9800_0000,
    0x2c00_0000,
    0x0600_0000,
    0xcd00_0000,
    0x8a80_0000,
    0x1bc0_0000,
    0xffa0_0000,
    0xad50_0000,
    0x7af8_0000,
    0xb3dc_0000,
    0x5b2e_0000,
    0x1f29_0000,
    0x9d58_8000,
    0xf28c_c000,
    0x07d6_2000,
    0x71f5_1000,
    0xd4f6_1800,
    0xda65_ec00,
    0x632e_a600,
    0xe329_1d00,
    0x2358_b280,
    0x038c_e7c0,
    0x1356_41a0,
    0x8b35_5c50,
    0xa7d6_ee78,
    0xa1f5_891c,
    0x6cf6_880e,
    0xe665_b4b9,
    0xfd2e_aa80,
    0x0229_0bc0,
    0xafd8_e7a0,
    0xd54c_4150,
    0x6676_5cf8,
    0x3da5_6edc,
    0x228e_c9ae,
    0xbf79_e8e9,
    0x4d20_c4f8,
    0x4a90_42dc,
    0x3b58_4fae,
    0xef8c_e5e9,
    0x3556_ee78,
    0x5635_891c,
    0xb556_880e,
    0x9635_b4b9,
    0x9556_aa80,
    0x8635_0bc0,
    0x0d56_e7a0,
    0xaa35_4150,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x9000_0000,
    0x9800_0000,
    0x5400_0000,
    0x3a00_0000,
    0x9d00_0000,
    0x7e80_0000,
    0x7f40_0000,
    0x1720_0000,
    0xab50_0000,
    0x6df8_0000,
    0x96a4_0000,
    0x83d2_0000,
    0x71e1_0000,
    0xc0d8_8000,
    0xe0f4_4000,
    0x30aa_a000,
    0x0805_9000,
    0xcc2a_1800,
    0x6e45_1400,
    0xa78a_1a00,
    0xe355_4d00,
    0x01d2_c680,
    0x68e1_fb40,
    0xbc58_9520,
    0xc6b4_b250,
    0xfb0a_1178,
    0x1515_b0e4,
    0xf272_c872,
    0xb1f1_2cf1,
    0x2000_de80,
    0xd000_ef40,
    0x3800_8f20,
    0xc400_ff50,
    0xa200_57f8,
    0xc900_0ba4,
    0x4480_fd52,
    0xe240_0ea1,
    0x69a0_d7f8,
    0xd410_4ba4,
    0x7ad8_5d52,
    0x3df4_9ea1,
    0xee2a_4ff8,
    0xe745_1fa4,
    0x430a_e752,
    0x9115_43a1,
    0xf072_1178,
    0xe8f1_b0e4,
    0xfc80_c872,
    0x6640_2cf1,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0xb000_0000,
    0x0800_0000,
    0x8400_0000,
    0xb200_0000,
    0xb900_0000,
    0xbe80_0000,
    0x4fc0_0000,
    0x5560_0000,
    0xf8f0_0000,
    0xac28_0000,
    0x66d4_0000,
    0xb30a_0000,
    0x8bb5_0000,
    0xc7c8_8000,
    0x11e4_c000,
    0xaa42_e000,
    0xa591_b000,
    0xd0ea_8800,
    0x7885_4400,
    0x6c80_d200,
    0x86c0_c900,
    0x03e0_5680,
    0x8330_7bc0,
    0x4348_ef60,
    0xa324_c5f0,
    0x13a2_a0a8,
    0x1ba1_9014,
    0x9f22_d8ea,
    0x2d61_fc85,
    0x94c2_5e80,
    0x2a51_ffc0,
    0x658a_dd60,
    0x3075_bcf0,
    0xc8a8_7e28,
    0x6414_afd4,
    0x02ea_e58a,
    0xb185_f075,
    0x3a00_a8a8,
    0xfd00_1414,
    0xec80_eaea,
    0x46c0_8585,
    0xe3e0_8000,
    0x3330_c000,
    0x4b48_e000,
    0x2724_b000,
    0xa1a2_0800,
    0xa2a1_8400,
    0x21a2_3200,
    0x62a1_7900,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x3000_0000,
    0x7800_0000,
    0x2400_0000,
    0x9e00_0000,
    0x4700_0000,
    0x6780_0000,
    0xf740_0000,
    0xdf20_0000,
    0xb310_0000,
    0x7168_0000,
    0x8c4c_0000,
    0x3252_0000,
    0xe5d5_0000,
    0xaa52_8000,
    0x31d5_c000,
    0x2c52_e000,
    0x62d5_f000,
    0xadd2_9800,
    0xf695_d400,
    0x8b72_0600,
    0xf5c5_9300,
    0x42ba_6180,
    0x3dd9_6440,
    0xdea0_bea0,
    0xe750_d750,
    0x37c8_4fc8,
    0xbf1c_9b1c,
    0x839a_1d9a,
    0x09c9_4ec9,
    0xa848_4fc8,
    0xac5c_9b1c,
    0xa2ba_1d9a,
    0xcdd9_4ec9,
    0xc6a0_4fc8,
    0xf350_9b1c,
    0xd1c8_1d9a,
    0xdc1c_4ec9,
    0x7a1a_cfc8,
    0xb989_5b1c,
    0x10e8_fd9a,
    0xe80c_bec9,
    0x0cf2_d7c8,
    0xf285_4f1c,
    0x859a_1b9a,
    0x9ac9_ddc9,
    0x49c8_ae48,
    0x081c_3f5c,
    0xfc1a_433a,
    0xea89_6999,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0xb000_0000,
    0x7800_0000,
    0x9c00_0000,
    0xee00_0000,
    0x1b00_0000,
    0xcb80_0000,
    0xc340_0000,
    0xc7a0_0000,
    0x0510_0000,
    0x8868_0000,
    0xc474_0000,
    0x225a_0000,
    0x3da1_0000,
    0x345a_8000,
    0x7aa1_c000,
    0xf1da_6000,
    0x12e1_7000,
    0x85fa_1800,
    0x48b1_ec00,
    0x2432_f600,
    0x92d5_f700,
    0x4580_3d80,
    0xa840_3440,
    0x9420_7a20,
    0xea50_f150,
    0xd9c8_1248,
    0x4664_8524,
    0x8fb2_4812,
    0x2195_2485,
    0x1a20_1248,
    0x8150_8524,
    0x8a48_4812,
    0xa924_2485,
    0xde12_9248,
    0xa385_4524,
    0xb7c8_2812,
    0x9d64_5485,
    0xa432_0a48,
    0x52d5_6924,
    0xa580_be12,
    0x1840_d385,
    0xec20_2fc8,
    0x7650_b164,
    0x37c8_3232,
    0x5d64_d5d5,
    0x4432_8000,
    0xe2d5_c000,
    0xdd80_6000,
    0x8440_7000,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x1000_0000,
    0x5800_0000,
    0x7c00_0000,
    0xc200_0000,
    0xe100_0000,
    0x0d80_0000,
    0xd7c0_0000,
    0x2aa0_0000,
    0xf530_0000,
    0x9ba8_0000,
    0xc0f4_0000,
    0x20c6_0000,
    0x702f_0000,
    0x4866_8000,
    0x241f_4000,
    0xbe4e_e000,
    0x232b_5000,
    0xec28_b800,
    0xda34_2c00,
    0xfde6_fa00,
    0xdfdf_8d00,
    0x6eee_1780,
    0x5b1b_0ac0,
    0xe000_0520,
    0x5000_93f0,
    0x3800_8488,
    0x6c00_8e04,
    0x9a00_0bce,
    0x9d00_d8eb,
    0xcf80_3c88,
    0x36c0_a204,
    0x2720_f1ce,
    0x22f0_55eb,
    0xb108_ab08,
    0x35c4_e8c4,
    0xbb6e_14ee,
    0xb0db_961b,
    0x68a0_9780,
    0x5430_4ac0,
    0xf628_e520,
    0x0734_c3f0,
    0x5266_bc88,
    0xf91f_e204,
    0x11ce_11ce,
    0x05eb_05eb,
    0x9308_1308,
    0x84c4_c4c4,
    0x8eee_eeee,
    0x0b1b_1b1b,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x3000_0000,
    0xb800_0000,
    0xac00_0000,
    0x7200_0000,
    0xb100_0000,
    0x0380_0000,
    0xd2c0_0000,
    0xc160_0000,
    0x9b90_0000,
    0x4e48_0000,
    0x0b74_0000,
    0x864e_0000,
    0x3f0b_0000,
    0x6806_8000,
    0x447f_4000,
    0x7648_a000,
    0xe774_7000,
    0xd44e_9800,
    0xbe0b_9c00,
    0xd386_4a00,
    0x3abf_5d00,
    0xc528_d180,
    0xcde4_13c0,
    0x9986_5ae0,
    0x67bf_d550,
    0x94a8_c528,
    0x9e24_cde4,
    0xe366_9986,
    0x82ef_67bf,
    0x6980_14a8,
    0xbfc0_de24,
    0x28e0_c366,
    0x6450_b2ef,
    0x46a8_d180,
    0x5f24_13c0,
    0x78e6_5ae0,
    0xcc2f_d550,
    0x62e0_c528,
    0x3950_cde4,
    0x1728_9986,
    0x0ce4_67bf,
    0x0206_94a8,
    0x297f_9e24,
    0x9fc8_6366,
    0x18b4_c2ef,
    0xdcae_4980,
    0xea5b_8fc0,
    0x2d2e_10e0,
    0xc99b_8850,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x7000_0000,
    0x8800_0000,
    0x4400_0000,
    0x4a00_0000,
    0x4700_0000,
    0xdd80_0000,
    0x4240_0000,
    0xc320_0000,
    0x7710_0000,
    0x75b8_0000,
    0x966c_0000,
    0x715e_0000,
    0xfc95_0000,
    0xa6e6_8000,
    0xd9f9_c000,
    0x2838_6000,
    0x142c_b000,
    0x527e_6800,
    0xfb85_3400,
    0x5b5e_4200,
    0x0b95_c300,
    0x1366_f780,
    0xafb9_b540,
    0x2918_f6a0,
    0x603c_c150,
    0xb046_9498,
    0x68a9_927c,
    0x34a0_9b66,
    0xc250_ebb9,
    0x0318_6318,
    0x973c_273c,
    0x05c6_6dc6,
    0x1ee9_2ae9,
    0x3580_7780,
    0xb640_7540,
    0xe120_96a0,
    0x0410_7150,
    0x6a38_fc98,
    0xd72c_a67c,
    0x25fe_d966,
    0x8ec5_28b9,
    0xcdfe_9498,
    0x7ac5_927c,
    0xeffe_9b66,
    0x09c5_ebb9,
    0xf07e_e318,
    0x4885_e73c,
    0xa4de_0dc6,
    0x3ad5_9ae9,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x5000_0000,
    0xd800_0000,
    0xfc00_0000,
    0xf600_0000,
    0xd500_0000,
    0xbf80_0000,
    0x2c40_0000,
    0xeee0_0000,
    0x0970_0000,
    0x1908_0000,
    0x2164_0000,
    0xad6a_0000,
    0xd313_0000,
    0x2282_8000,
    0x9707_c000,
    0x98e0_a000,
    0x1c70_9000,
    0x8688_f800,
    0x5d24_ac00,
    0x9b8a_2e00,
    0x2663_2900,
    0xcd8a_c980,
    0x6363_3940,
    0x8a0a_f160,
    0xe323_b530,
    0x4aea_8fe8,
    0xc353_4414,
    0x1a62_3a62,
    0x1b77_4b77,
    0xe668_be68,
    0xed54_d154,
    0x3302_e502,
    0x5247_d747,
    0x1f80_f800,
    0xbc40_ac00,
    0x16e0_2e00,
    0xa570_2900,
    0x3708_4980,
    0x0864_f940,
    0xe4ea_5160,
    0x2a53_2530,
    0x73e2_77e8,
    0xb237_e814,
    0x6f08_1462,
    0x3464_6277,
    0x32ea_77e8,
    0xaf53_e814,
    0x1462_1462,
    0x6277_6277,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x5000_0000,
    0x5800_0000,
    0xac00_0000,
    0x6a00_0000,
    0x8500_0000,
    0xfb80_0000,
    0xa8c0_0000,
    0x8420_0000,
    0xae30_0000,
    0x4b08_0000,
    0xe074_0000,
    0x1086_0000,
    0x388f_0000,
    0xfc2e_8000,
    0x320b_4000,
    0x2980_e000,
    0x91c0_1000,
    0x2da0_3800,
    0x7ff0_fc00,
    0x06a8_3200,
    0xcf84_2900,
    0x4e2e_9180,
    0x5b0b_2dc0,
    0xd800_ffa0,
    0xec00_46f0,
    0x0a00_af28,
    0xd500_1e44,
    0xa380_038e,
    0x04c0_74fb,
    0xee20_86a8,
    0x2b30_8f84,
    0xb088_2e2e,
    0x48b4_0b0b,
    0x94a6_8000,
    0x96bf_4000,
    0xb726_e000,
    0xd27f_1000,
    0x3906_b800,
    0xa94f_bc00,
    0xd18e_d200,
    0x4dfb_3900,
    0x2f28_2980,
    0x5e44_91c0,
    0x638e_2da0,
    0x24fb_7ff0,
    0xdea8_86a8,
    0x2384_8f84,
    0x442e_2e2e,
    0x8e0b_0b0b,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x5000_0000,
    0xe800_0000,
    0x4400_0000,
    0x5e00_0000,
    0xad00_0000,
    0xef80_0000,
    0x6840_0000,
    0x8460_0000,
    0xfe50_0000,
    0xfd28_0000,
    0x07f4_0000,
    0x2c62_0000,
    0xda4f_0000,
    0x5306_8000,
    0x12df_c000,
    0x6f80_2000,
    0xa840_3000,
    0x2460_2800,
    0xae50_1400,
    0x1528_3a00,
    0x43f4_1100,
    0x7262_1780,
    0x774f_2b40,
    0xbc86_bbe0,
    0x7a9f_da10,
    0xebe0_0118,
    0x5610_0f94,
    0xd948_174a,
    0xa9a4_15fd,
    0x394a_3118,
    0x99bb_2793,
    0x2164_8341,
    0x6590_eff7,
    0xd306_8000,
    0xd2df_c000,
    0xcf80_2000,
    0xf840_3000,
    0xcc60_2800,
    0xea50_1400,
    0x4b28_3a00,
    0xeef4_1100,
    0x9de2_1780,
    0x1f0f_2b40,
    0x38e6_bbe0,
    0x84cf_da10,
    0x16c8_0118,
    0x51e4_0f94,
    0xf52a_174a,
    0x73eb_15fd,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0xb000_0000,
    0x1800_0000,
    0x0400_0000,
    0xda00_0000,
    0x0900_0000,
    0x2280_0000,
    0xe840_0000,
    0xbc60_0000,
    0x0e30_0000,
    0x7b58_0000,
    0x378c_0000,
    0x14c2_0000,
    0x874d_0000,
    0x99d4_8000,
    0xbfb9_4000,
    0x1880_2000,
    0x9140_3000,
    0xe6e0_1800,
    0x5270_2c00,
    0x0538_0600,
    0x34bc_0100,
    0x971a_3680,
    0x5181_0240,
    0x13f6_88a0,
    0xde84_7a10,
    0x466c_8f18,
    0x1745_738c,
    0x91fa_26d6,
    0x73f1_11e3,
    0x6ece_9b30,
    0x5e38_4cd3,
    0x1376_b6f5,
    0x4bc4_5cae,
    0x7a8c_8000,
    0x4c35_4000,
    0xb642_2000,
    0xaf0d_3000,
    0x45b4_9800,
    0x0189_6c00,
    0x7bd8_2600,
    0xa2cc_3100,
    0x2822_2e80,
    0xdc3d_2e40,
    0xbe6c_8ea0,
    0x6345_7b10,
    0x33fa_3998,
    0xcef1_31cc,
    0x8e4e_8e76,
    0xbb78_5bf3,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x5000_0000,
    0x8800_0000,
    0x9c00_0000,
    0x2e00_0000,
    0x0500_0000,
    0xab80_0000,
    0x1c40_0000,
    0x6e20_0000,
    0x2510_0000,
    0xfba8_0000,
    0x9404_0000,
    0xf26e_0000,
    0x0b07_0000,
    0xfeaa_8000,
    0x3fd1_c000,
    0xee20_2000,
    0x6510_1000,
    0xdba8_0800,
    0xc404_1400,
    0x7a6e_2200,
    0x9707_2700,
    0xd0aa_8b80,
    0x3ad1_c140,
    0x45a0_0ae0,
    0x7950_1710,
    0xb588_1388,
    0xe114_1d44,
    0x81c6_1cea,
    0x0303_0201,
    0x22c4_b71b,
    0x31d6_c381,
    0xbb0a_b54a,
    0x4681_d8e4,
    0x5ba8_0800,
    0x8404_1400,
    0x5a6e_2200,
    0xc707_2700,
    0x58aa_8b80,
    0xa6d1_c140,
    0x6ba0_0ae0,
    0x7c50_1710,
    0x1e08_1388,
    0xfd54_1d44,
    0xefe6_1cea,
    0x2613_0201,
    0xd96c_b71b,
    0xa5d2_c381,
    0x4964_b54a,
    0x4d86_d8e4,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x5000_0000,
    0xc800_0000,
    0x3c00_0000,
    0x3e00_0000,
    0x6700_0000,
    0xf980_0000,
    0xcc40_0000,
    0x6660_0000,
    0xb310_0000,
    0xaba8_0000,
    0x5d24_0000,
    0xc4fe_0000,
    0xb8cf_0000,
    0x66bb_8000,
    0x71a8_c000,
    0x1060_2000,
    0x2810_3000,
    0x4c28_0800,
    0xa664_1400,
    0x931e_3200,
    0xfb9f_0f00,
    0x9573_8f80,
    0xf89c_d9c0,
    0x86b6_1e60,
    0x01bb_0310,
    0x880d_9198,
    0xdc13_f8c4,
    0x4e6d_b8ea,
    0xff03_e849,
    0x0dc5_96bf,
    0xce27_d3f3,
    0x3f3b_bdce,
    0x2de8_c47a,
    0x9e00_0800,
    0xf700_1400,
    0x1180_3200,
    0xa040_0f00,
    0x9060_0f80,
    0xe810_19c0,
    0x6c28_3e60,
    0xf664_3310,
    0x5b1e_1998,
    0xc79f_2cc4,
    0xab73_aaea,
    0x9f9c_d749,
    0x7f36_113f,
    0xcdfb_1e33,
    0xee6d_91ae,
    0x6f03_c86a,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xb000_0000,
    0x5800_0000,
    0x4400_0000,
    0x7e00_0000,
    0x6900_0000,
    0x5b80_0000,
    0xdc40_0000,
    0x5a20_0000,
    0x8710_0000,
    0xdad8_0000,
    0x9bec_0000,
    0xbc42_0000,
    0xca0f_0000,
    0x6f7c_8000,
    0xc6d9_c000,
    0xa1a0_2000,
    0xab50_1000,
    0xf8f8_0800,
    0xe8fc_2c00,
    0x409a_1600,
    0x7ce3_1100,
    0xf6be_9f80,
    0xb996_da40,
    0xcf7c_b6e0,
    0x36d9_e710,
    0xd9a0_3e88,
    0x5f50_1dc4,
    0xdef8_28b6,
    0xc5fc_1bfb,
    0x651a_2690,
    0xc9a3_39c3,
    0xf71e_92bf,
    0xe2c6_dce6,
    0x4f84_8800,
    0x2a25_ec00,
    0xbf3a_3600,
    0x0eb3_0100,
    0x0dc6_9780,
    0xc92a_f640,
    0xabc6_a0e0,
    0xa42a_f610,
    0xae46_a108,
    0xa16a_c784,
    0xf7e6_9e56,
    0xbe3a_fceb,
    0x091e_9818,
    0xcbc6_e407,
    0x3404_9a09,
    0x4665_d71d,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0xb000_0000,
    0x4800_0000,
    0x7400_0000,
    0xc200_0000,
    0xe700_0000,
    0xb580_0000,
    0xba40_0000,
    0x9b20_0000,
    0xa3d0_0000,
    0x2f18_0000,
    0x8184_0000,
    0xd82a_0000,
    0xcc19_0000,
    0x5e07_8000,
    0xe138_c000,
    0xd898_2000,
    0x9cc4_1000,
    0x568a_2800,
    0x6589_2c00,
    0xa23f_9200,
    0xb76c_dd00,
    0xedaa_1080,
    0x3659_29c0,
    0x6527_8560,
    0xf2e8_c290,
    0xbf80_14c8,
    0x6940_25f4,
    0x4ca0_1346,
    0x4e90_35a1,
    0x49b8_096a,
    0xec14_0096,
    0xae12_01c9,
    0x094d_297a,
    0x1cb5_9080,
    0x16e5_e9c0,
    0xc595_a560,
    0x1235_d290,
    0xff0d_bcc8,
    0x99f1_c9f4,
    0xf407_a146,
    0x8238_f8a1,
    0x4718_31ea,
    0x0584_0556,
    0xf22a_16a9,
    0xef19_36ea,
    0x6187_94c8,
    0xc878_e5f4,
    0x3438_3346,
    0x6254_25a1,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0xf000_0000,
    0x9800_0000,
    0xb400_0000,
    0x5200_0000,
    0x0700_0000,
    0xbf80_0000,
    0x5a40_0000,
    0x3b20_0000,
    0x91d0_0000,
    0xd338_0000,
    0xfdec_0000,
    0x954a_0000,
    0x58f1_0000,
    0xb5df_8000,
    0x091d_c000,
    0x86b8_2000,
    0xa4ac_1000,
    0x7bea_2800,
    0xd061_3c00,
    0x2847_a600,
    0x8c61_ed00,
    0x166a_3480,
    0xcd21_11c0,
    0x0ce7_87e0,
    0xb7f1_ea90,
    0x6672_08c8,
    0x151d_1974,
    0x1895_884e,
    0x15ec_c2bb,
    0xf967_8cb2,
    0x1eb1_fdac,
    0x10d2_3f3f,
    0x298d_0bf3,
    0xd70d_b480,
    0x9790_d1c0,
    0xd635_a7e0,
    0x2d7c_fa90,
    0x5cff_a0c8,
    0xdfcd_e574,
    0x4a00_0e4e,
    0xf300_3fbb,
    0x4d80_1032,
    0xad40_106c,
    0x1ca0_3edf,
    0x7f90_1c63,
    0xba18_20c8,
    0x6b3c_2574,
    0xf9f2_2e4e,
    0xff5d_2fbb,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x7000_0000,
    0xf800_0000,
    0x4c00_0000,
    0xa600_0000,
    0x8900_0000,
    0x6e80_0000,
    0x1a40_0000,
    0x1760_0000,
    0x4bf0_0000,
    0xa2f8_0000,
    0x7c5c_0000,
    0x7e36_0000,
    0x551b_0000,
    0x4080_8000,
    0x272d_4000,
    0x9398_2000,
    0x7eac_3000,
    0x524e_3800,
    0x4307_1c00,
    0xd1d6_be00,
    0x75c6_5300,
    0xd7e0_8980,
    0xacdd_5240,
    0xd160_03a0,
    0x72f0_2a90,
    0xd478_03d8,
    0x5a1c_1dfc,
    0x3756_3f3e,
    0xdbeb_2e57,
    0x2af8_adad,
    0xc831_7196,
    0x944e_2e58,
    0x7a07_2da7,
    0xa756_b180,
    0x5386_4e40,
    0x9e80_bda0,
    0x222d_7990,
    0xbb18_0a58,
    0x9dec_0fbc,
    0xd3ae_1c9e,
    0x5eb7_34c7,
    0xc24e_9675,
    0xcb6a_706a,
    0x65ae_af66,
    0x9fda_50f0,
    0xf8b6_95ad,
    0x4b36_6d96,
    0xa598_9058,
    0x7fc1_7ea7,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x3000_0000,
    0xb800_0000,
    0x3c00_0000,
    0xde00_0000,
    0xdf00_0000,
    0x2980_0000,
    0x3240_0000,
    0xe920_0000,
    0x6290_0000,
    0x71d8_0000,
    0x5e3c_0000,
    0x9f2e_0000,
    0x09e7_0000,
    0x026b_8000,
    0x5176_c000,
    0x5ef8_2000,
    0xafac_1000,
    0x8176_0800,
    0xb69b_0c00,
    0x3be5_ae00,
    0xeb41_cf00,
    0x33eb_9780,
    0x2f36_e7c0,
    0xf1d8_2260,
    0x1e3c_1090,
    0xbf2e_1c48,
    0x39e7_1ba4,
    0xba6b_85f6,
    0x6d76_ef4f,
    0x80f8_3a2b,
    0x70ac_2929,
    0xa8f6_38b2,
    0x84db_0c69,
    0xd2c5_9f80,
    0x89d1_ebc0,
    0x4233_8c60,
    0x710a_df90,
    0x6ef6_0bc8,
    0x17db_3c64,
    0xbd45_8796,
    0x6891_efdf,
    0xe493_ae63,
    0xc2da_fe8d,
    0x018e_3344,
    0xc637_3c26,
    0x9313_ba2b,
    0x6f9a_e929,
    0xe12e_18b2,
    0xa6e7_1c69,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0xd000_0000,
    0xf800_0000,
    0x3c00_0000,
    0x6e00_0000,
    0x1900_0000,
    0x5080_0000,
    0xca40_0000,
    0x7b20_0000,
    0xafd0_0000,
    0x97a8_0000,
    0x4b9c_0000,
    0x55ae_0000,
    0x64ef_0000,
    0xf028_8000,
    0x6852_4000,
    0x6408_2000,
    0x820c_1000,
    0x8f26_2800,
    0x75a3_3400,
    0xf4ae_be00,
    0xa861_4f00,
    0x842e_bb80,
    0xf221_5640,
    0xa70e_9c20,
    0xb1f1_5690,
    0xa6a6_a8c8,
    0xdf6d_40f4,
    0xcd88_886a,
    0x68c2_7fa7,
    0x1600_2ccb,
    0x6500_06eb,
    0x9e80_3b62,
    0x0340_3e30,
    0xd3a0_1380,
    0x5990_2240,
    0x8288_0220,
    0xfd4c_0990,
    0x9286_3b48,
    0xe533_22b4,
    0xdea6_aa4a,
    0xa36d_6637,
    0x0388_bf83,
    0xa1c2_505f,
    0xbe80_0f28,
    0x9340_0707,
    0x8ba0_3f83,
    0xb590_105f,
    0x1488_2f28,
    0xd84c_1707,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0xd000_0000,
    0xc800_0000,
    0xbc00_0000,
    0x4e00_0000,
    0x5700_0000,
    0x8080_0000,
    0x0a40_0000,
    0xfd20_0000,
    0x8db0_0000,
    0xffa8_0000,
    0xa684_0000,
    0x110e_0000,
    0x4bdf_0000,
    0x74d7_8000,
    0xb872_4000,
    0x8408_2000,
    0x8a74_1000,
    0xbd06_1800,
    0xedab_3400,
    0x2fd1_b200,
    0x6ed9_6f00,
    0xad59_b380,
    0x05ed_45c0,
    0x23ff_9820,
    0x38b6_6690,
    0x8e26_3548,
    0x771b_286c,
    0x30f9_866a,
    0x121d_6761,
    0x8977_a5e3,
    0x7f82_7aa7,
    0xe680_29dd,
    0x7140_3e20,
    0x9ba0_2b80,
    0xbcf0_31c0,
    0x0408_0a20,
    0xca74_1990,
    0xdd06_1ec8,
    0x3dab_19ac,
    0xe7d1_8c4a,
    0xd2d9_7ef1,
    0xe359_bb2b,
    0x52ed_630b,
    0xa37f_a597,
    0x32f6_40d1,
    0x7306_10ab,
    0xfaab_12cb,
    0xcf51_8fb7,
    0xb499_4941,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xb000_0000,
    0xa800_0000,
    0xd400_0000,
    0xfa00_0000,
    0xf900_0000,
    0x9280_0000,
    0x1940_0000,
    0x42a0_0000,
    0x2150_0000,
    0x8ef8_0000,
    0xa704_0000,
    0x5992_0000,
    0x36f9_0000,
    0x2b2e_8000,
    0xffd0_4000,
    0x5192_2000,
    0x12f9_1000,
    0x592e_8800,
    0x62d0_6c00,
    0x9112_0a00,
    0x26b9_2500,
    0x730e_b680,
    0xa3c0_5240,
    0xcfca_2ea0,
    0xb9ad_2350,
    0xe6c4_a628,
    0x136d_5a14,
    0x338e_8d1e,
    0xd780_4a91,
    0xc5ea_104c,
    0xc8bd_07aa,
    0x101c_afd5,
    0x5879_4965,
    0x5c44_a628,
    0x9e2d_5a14,
    0xab2e_8d1e,
    0xbfd0_4a91,
    0x7192_104c,
    0xa2f9_07aa,
    0xf12e_afd5,
    0xb6d0_4965,
    0x6b12_2628,
    0xdfb9_1a14,
    0xe18e_ad1e,
    0xba80_5a91,
    0x8d6a_184c,
    0x98fd_2baa,
    0x683c_85d5,
    0xb469_7c65,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0xb000_0000,
    0x5800_0000,
    0x1c00_0000,
    0x7200_0000,
    0x4f00_0000,
    0xa180_0000,
    0x7740_0000,
    0x4da0_0000,
    0xbd30_0000,
    0xaef8_0000,
    0x369c_0000,
    0x8ab6_0000,
    0xa885_0000,
    0x0fe1_8000,
    0xea0d_c000,
    0xf336_2000,
    0x83c5_1000,
    0xd041_b800,
    0xa83d_ec00,
    0xa44e_3600,
    0xde19_1700,
    0x6557_a480,
    0xf288_ffc0,
    0xa4d7_9e60,
    0x75c8_cad0,
    0x5177_97e8,
    0x64f8_c08c,
    0xd58f_8dde,
    0x0164_eb77,
    0x8cb9_a345,
    0x91a1_edad,
    0x6f78_12a6,
    0xb1dc_0234,
    0x7f16_17e8,
    0xb9b5_008c,
    0x8b19_adde,
    0x8f91_fb77,
    0xaa00_1b45,
    0x1300_01ad,
    0x3380_24a6,
    0x8840_1534,
    0xb420_3368,
    0xd670_3f4c,
    0x9158_13be,
    0xc4ac_21a7,
    0x85ce_34ad,
    0xe959_2d21,
    0xc8f7_9f78,
    0xffb8_e943,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x5000_0000,
    0x8800_0000,
    0x3400_0000,
    0xa200_0000,
    0x0300_0000,
    0x4180_0000,
    0xf740_0000,
    0x03a0_0000,
    0x0410_0000,
    0x9a08_0000,
    0x4f14_0000,
    0x0fb2_0000,
    0xea55_0000,
    0xd73b_8000,
    0x13a1_c000,
    0x2c12_2000,
    0xfe45_1000,
    0x6533_a800,
    0x38b5_d400,
    0x09a0_0200,
    0x2310_1d00,
    0x5188_0080,
    0xdf54_14c0,
    0x6792_3260,
    0x2e05_30d0,
    0xad13_a868,
    0xace5_c1c4,
    0xfb88_16e2,
    0xa854_3e15,
    0x2412_2b04,
    0x8a45_2f91,
    0x6733_b14c,
    0x6bb5_da2d,
    0xc020_0068,
    0xe050_15c4,
    0xf028_14e2,
    0xd844_2315,
    0xbc1a_2b84,
    0x9651_3b51,
    0xa101_832c,
    0x42a0_eafd,
    0xb6bb_a800,
    0xf4e1_d400,
    0x07b2_0200,
    0x9e55_1d00,
    0xd53b_8080,
    0x40a1_d4c0,
    0xe592_1260,
    0x3d05_20d0,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0xd000_0000,
    0xb800_0000,
    0x1c00_0000,
    0x8200_0000,
    0xfb00_0000,
    0xed80_0000,
    0x8740_0000,
    0xffa0_0000,
    0x2430_0000,
    0xde48_0000,
    0x992c_0000,
    0xc6e6_0000,
    0xd2dd_0000,
    0x6493_8000,
    0x59a7_c000,
    0x0146_2000,
    0xaaed_1000,
    0xd8db_b800,
    0xeb8b_f400,
    0x9220_0e00,
    0xe370_1700,
    0xc1e8_1880,
    0x6d1c_0ac0,
    0xa0ae_1560,
    0x57f1_26d0,
    0x2075_9f68,
    0x707a_f7cc,
    0x8855_acf2,
    0x740a_d79b,
    0x263d_9651,
    0x6556_d9bb,
    0x94b3_98b6,
    0x91d7_d322,
    0x952e_2768,
    0x5cb1_03cc,
    0x05d5_a2f2,
    0x634a_c09b,
    0x819d_8ed1,
    0x8d66_d37b,
    0x70fb_8dd6,
    0xeffb_f5f2,
    0x3c48_3800,
    0xf22c_3400,
    0x7366_2e00,
    0x999d_0700,
    0xa133_a080,
    0x9a97_fec0,
    0xb08e_1b60,
    0x4f81_31d0,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x1000_0000,
    0x4800_0000,
    0xac00_0000,
    0x0600_0000,
    0x9500_0000,
    0x0580_0000,
    0xc940_0000,
    0x3be0_0000,
    0x0810_0000,
    0xcc68_0000,
    0xb674_0000,
    0xcd5e_0000,
    0xe1a7_0000,
    0x635c_8000,
    0xa8e1_c000,
    0x98be_2000,
    0x00b7_3000,
    0x44b4_a800,
    0xfed5_c400,
    0x2580_3200,
    0x1940_1b00,
    0xd3e0_2980,
    0xb410_2140,
    0x8268_1360,
    0x8f74_1950,
    0xcede_0f78,
    0xbde7_2744,
    0x5d3c_b27a,
    0x69b1_dfcd,
    0x6f36_1daf,
    0xbed3_0a6d,
    0x4582_83cd,
    0xa906_c3a5,
    0x8b82_a778,
    0x5006_e344,
    0x2802_807a,
    0x1c46_c4cd,
    0x5e62_b42f,
    0x7116_eb2d,
    0xafea_b0ad,
    0x5a72_eaf5,
    0xab5c_8000,
    0xc4e1_c000,
    0x3ebe_2000,
    0x85b7_3000,
    0x0934_a800,
    0x9b95_c400,
    0x1860_3200,
    0x8450_1b00,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0xd000_0000,
    0xf800_0000,
    0x3400_0000,
    0x1a00_0000,
    0xff00_0000,
    0xf380_0000,
    0x9340_0000,
    0x2da0_0000,
    0x3e70_0000,
    0x3d48_0000,
    0x88cc_0000,
    0x52b2_0000,
    0x8d91_0000,
    0xce35_8000,
    0x750c_c000,
    0x9492_2000,
    0x84a1_1000,
    0x5cdd_9800,
    0xd8b0_f400,
    0xeae8_1e00,
    0xd9bc_1d00,
    0x047a_1e80,
    0x721d_0bc0,
    0x5327_82e0,
    0x0ded_e9d0,
    0x8e6f_ade8,
    0x1521_e05c,
    0x44dd_8bb2,
    0x7cb0_e2e3,
    0x68e8_19c4,
    0xc2bc_05f8,
    0x15fa_1c5f,
    0x2a5d_39b0,
    0x9707_b5e8,
    0x5fdd_d45c,
    0x6d07_b5b2,
    0x30dd_efe3,
    0x0687_9f44,
    0x479d_fa38,
    0xc927_80bf,
    0xb2ed_cd60,
    0x1def_8680,
    0x5661_ffc0,
    0x917d_9ce0,
    0x76c0_f4d0,
    0x4fa0_3368,
    0xb570_2b9c,
    0xb4c8_2952,
    0x348c_1b33,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x1000_0000,
    0x2800_0000,
    0xfc00_0000,
    0xb200_0000,
    0x5b00_0000,
    0x3f80_0000,
    0x7f40_0000,
    0x89e0_0000,
    0x2270_0000,
    0xb368_0000,
    0xa3a4_0000,
    0xdd36_0000,
    0xfaad_0000,
    0xe1a3_8000,
    0x7e6e_c000,
    0x7156_2000,
    0xc09d_3000,
    0x36ab_9800,
    0xcbfa_c400,
    0x8168_2a00,
    0x38a4_0f00,
    0x82b6_3480,
    0x95ed_12c0,
    0x4043_85e0,
    0xa01e_e0d0,
    0x703e_2ef8,
    0x3839_2e5c,
    0xd41d_bb3a,
    0x4e17_f339,
    0xe92b_bf35,
    0x64ba_f937,
    0x4088_0032,
    0xf6d4_15b2,
    0xabde_36f8,
    0x9149_2a5c,
    0x10f5_b13a,
    0x7ef3_cc39,
    0x27fd_93b5,
    0x1b67_eff7,
    0x9fc3_8fd2,
    0x0f5e_ca62,
    0xb1de_3480,
    0xf649_12c0,
    0xfd75_85e0,
    0x4ab3_e0d0,
    0xb99d_aef8,
    0xba57_ee5c,
    0x174b_9b3a,
    0xd58a_c339,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x3000_0000,
    0x0800_0000,
    0x4c00_0000,
    0xf600_0000,
    0x7f00_0000,
    0x7680_0000,
    0x1940_0000,
    0x11a0_0000,
    0x7bf0_0000,
    0x8af8_0000,
    0xa754_0000,
    0x42ae_0000,
    0xcb17_0000,
    0xe4a5_8000,
    0x8c12_4000,
    0xd656_2000,
    0x2f43_1000,
    0x4e8b_9800,
    0x5d45_4c00,
    0xabd3_a200,
    0xf2e1_4300,
    0x8305_8580,
    0xc8e2_43c0,
    0x4a2e_27a0,
    0xa157_0950,
    0x1585_a3e8,
    0xa1a2_5e3c,
    0x338e_209e,
    0xa6a7_3345,
    0x617d_ace3,
    0x35f6_79a9,
    0xf1a0_205f,
    0x0bf0_117d,
    0xe2f8_2668,
    0xdb54_1dfc,
    0xbcae_073e,
    0xf817_3a15,
    0x6425_8f0b,
    0xea52_6795,
    0xb176_20c1,
    0x4df3_3238,
    0xd5d3_928b,
    0x81e1_6855,
    0x6385_a561,
    0x9ea2_7868,
    0x250e_34e3,
    0x8fe7_35a9,
    0x78dd_825f,
    0x0206_527d,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x7000_0000,
    0xb800_0000,
    0x7c00_0000,
    0x4a00_0000,
    0xf300_0000,
    0x9080_0000,
    0x8140_0000,
    0x5fa0_0000,
    0xfb90_0000,
    0x5dd8_0000,
    0x8cec_0000,
    0x5b36_0000,
    0xc4b1_0000,
    0xdf33_8000,
    0x5297_4000,
    0x166e_2000,
    0x891d_1000,
    0x7ba5_a800,
    0x1db6_5c00,
    0x2c85_8e00,
    0x2b66_4f00,
    0x7cfd_9a80,
    0xa31a_70c0,
    0x1893_8220,
    0xe507_7350,
    0x19b6_2368,
    0xfaf1_1124,
    0x4213_a7d6,
    0xd747_7cab,
    0x7696_3985,
    0xf021_1c58,
    0xf86b_a9f2,
    0xdc3b_49ea,
    0x3a78_39e8,
    0x4b7c_21e4,
    0xecee_05f6,
    0xcb5d_1ffb,
    0xac85_b2ed,
    0x6b66_517c,
    0xdcfd_8024,
    0xd31a_7a41,
    0xa093_9aed,
    0x9907_4d7c,
    0x53b6_2e24,
    0x09f1_2541,
    0xd293_a86d,
    0x5607_61bc,
    0x2936_2204,
    0x0bb1_1911,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0xb000_0000,
    0x8800_0000,
    0xd400_0000,
    0xea00_0000,
    0xb700_0000,
    0xf580_0000,
    0xa540_0000,
    0xfea0_0000,
    0x7e90_0000,
    0x3eb8_0000,
    0x9ef4_0000,
    0x2e82_0000,
    0xa6d9_0000,
    0x729d_8000,
    0x98c9_c000,
    0x2fba_2000,
    0xda6d_1000,
    0x7f3f_a800,
    0x81c0_ec00,
    0xff3f_8200,
    0xc1c0_e500,
    0x5f3f_b280,
    0x71c0_d1c0,
    0xd73f_9760,
    0xa5c0_e050,
    0x3d3f_af28,
    0x12c0_fb64,
    0xc8bf_a24e,
    0xb780_ea2d,
    0x361f_99e8,
    0xc910_fb82,
    0x08a7_8141,
    0x57e4_d3bb,
    0x2625_9da8,
    0xf13d_eaa4,
    0x54b8_152e,
    0x69f4_1a7d,
    0x7b02_1ec0,
    0xb399_2ce6,
    0x043d_810f,
    0x3259_cc96,
    0xfb02_1ec0,
    0xf399_2ce6,
    0xa43d_810f,
    0x8259_cc96,
    0x7302_1ec0,
    0x2799_2ce6,
    0x4e3d_810f,
    0x3559_cc96,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x5000_0000,
    0x0800_0000,
    0x3400_0000,
    0x1a00_0000,
    0xd100_0000,
    0xac80_0000,
    0x5740_0000,
    0x43a0_0000,
    0x18d0_0000,
    0x0d48_0000,
    0xb2b4_0000,
    0xe462_0000,
    0x5201_0000,
    0xc566_8000,
    0xe6e9_4000,
    0x8e0a_2000,
    0xdb25_1000,
    0x55ec_8800,
    0x9f8c_5400,
    0x06c6_a200,
    0xbe39_5d00,
    0xa342_2e80,
    0x3991_3040,
    0xb98e_a120,
    0xf98d_4cd0,
    0xd9a0_3468,
    0x89d0_2f74,
    0x81c8_26f2,
    0xb5f4_193d,
    0xafc2_00d0,
    0x7ed1_0a64,
    0xd22e_a463,
    0x855d_6763,
    0xc6e8_12e8,
    0xde64_0b34,
    0xd32a_05d2,
    0x61b5_18ed,
    0x8584_9238,
    0xd7a8_4150,
    0x12cc_81b1,
    0xf41c_6f8e,
    0x7a2e_88d0,
    0xa15d_5e64,
    0xf4e8_0663,
    0x6b64_3a63,
    0x6daa_3c68,
    0xd3f5_3b74,
    0x70a4_a4f2,
    0x4938_543d,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0xf000_0000,
    0x0800_0000,
    0xe400_0000,
    0xe600_0000,
    0x0700_0000,
    0x1080_0000,
    0x7d40_0000,
    0x5da0_0000,
    0x08f0_0000,
    0x2118_0000,
    0x3794_0000,
    0xfdfa_0000,
    0xd8ef_0000,
    0xb925_8000,
    0x2be1_4000,
    0xf7c2_2000,
    0xddcb_1000,
    0x48e7_9800,
    0x412a_7c00,
    0xc7a5_a200,
    0xf5a1_6900,
    0x3ce2_0180,
    0x5f7b_2dc0,
    0x2cdf_9e20,
    0xe70e_5a50,
    0xa0e7_8ce8,
    0x152a_6afc,
    0x49a5_8de6,
    0xe6a1_7f75,
    0xc262_1636,
    0xc13b_3e57,
    0x87ff_92e7,
    0x95be_41e1,
    0xccdf_9568,
    0x570e_7b3c,
    0xc8e7_91c6,
    0x012a_5c25,
    0xa7a5_835e,
    0x05a1_456b,
    0x34e2_0321,
    0xbb7b_1dc4,
    0xcadf_9636,
    0xe00e_7e57,
    0xb067_b2e7,
    0x686a_51e1,
    0x1405_8d68,
    0xee51_473c,
    0xe37a_13c6,
    0xf6af_2525,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0xb000_0000,
    0x3800_0000,
    0xac00_0000,
    0xa200_0000,
    0xcf00_0000,
    0x5780_0000,
    0x2fc0_0000,
    0x63a0_0000,
    0x51b0_0000,
    0x16e8_0000,
    0xd574_0000,
    0xf4e2_0000,
    0xfa13_0000,
    0x3344_8000,
    0x5dc7_4000,
    0xc4c4_a000,
    0x0207_7000,
    0xbf64_a800,
    0x4fb7_5c00,
    0x338c_a600,
    0xf9c3_7700,
    0x32ee_8e80,
    0xe310_44c0,
    0x358a_1b60,
    0xc0a7_0f30,
    0x8406_a388,
    0x4664_6b5c,
    0xd968_0e32,
    0x26b4_0201,
    0x2d42_150a,
    0x78a3_0b85,
    0xe82c_b75b,
    0xc473_6834,
    0xa606_950a,
    0x4964_4b85,
    0xaee8_175b,
    0xb974_1834,
    0x76e2_3d0a,
    0x8513_1785,
    0x5cc4_b15b,
    0xde07_6f34,
    0x0564_b38a,
    0x9cb7_5345,
    0xfe0c_aa3b,
    0xb503_6004,
    0xa4ce_9002,
    0x5260_7819,
    0x1742_0409,
    0x6ba3_1205,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x1000_0000,
    0x7800_0000,
    0x6c00_0000,
    0x7e00_0000,
    0xff00_0000,
    0x1880_0000,
    0xc0c0_0000,
    0x7ca0_0000,
    0x5ab0_0000,
    0xd9b8_0000,
    0xc704_0000,
    0x94f2_0000,
    0x8eed_0000,
    0xebe2_8000,
    0x5676_c000,
    0x0b62_a000,
    0x3ab6_f000,
    0x29c2_a800,
    0x8f06_f400,
    0x90fa_b600,
    0xe4c2_ef00,
    0x06a8_a980,
    0xcf9f_d0c0,
    0x2c72_2fa0,
    0x9e2d_20f0,
    0xcf42_9088,
    0x70c6_c65c,
    0xd4da_8ee6,
    0x6eb2_c39d,
    0xdbb0_bdda,
    0x3e2b_ff26,
    0x1f38_06a2,
    0x28c4_0e7b,
    0xa8d2_3dda,
    0x689d_3f26,
    0x48fa_a6a2,
    0x58c2_fe7b,
    0x20a8_95da,
    0x4c9f_cb26,
    0x32f2_10a2,
    0xcded_117b,
    0xd562_bc5a,
    0x15b6_dbe6,
    0x6942_9f02,
    0x33c6_c18b,
    0xea5a_84d2,
    0x2d72_e9ba,
    0xb990_a7e4,
    0x375b_ed16,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x3000_0000,
    0xd800_0000,
    0xf400_0000,
    0xd200_0000,
    0xab00_0000,
    0x9880_0000,
    0x90c0_0000,
    0xeca0_0000,
    0x82f0_0000,
    0xe7e8_0000,
    0x2a04_0000,
    0xaf3e_0000,
    0x32b7_0000,
    0xfff2_8000,
    0x7e46_c000,
    0x4d72_a000,
    0x4186_f000,
    0x9352_8800,
    0x3cb6_fc00,
    0x0a9a_be00,
    0x5b82_c100,
    0xe46c_8a80,
    0xfa01_ebc0,
    0x2768_2ca0,
    0x8ec4_0ff0,
    0x319e_3788,
    0x2b47_1f4c,
    0x589a_a672,
    0x3082_d9cd,
    0xdcec_9bbd,
    0x5ac1_d860,
    0x13c8_38c1,
    0xf834_2131,
    0x0476_1bbd,
    0xaa43_1860,
    0x6f24_98c1,
    0x92f5_d131,
    0xcfbe_13bd,
    0xa677_2460,
    0xb952_86c1,
    0x93b6_e031,
    0x381a_913d,
    0xa442_f3a0,
    0x9a4c_b461,
    0xb731_dec1,
    0x66a0_2435,
    0x1df0_3b2c,
    0x0d68_20b3,
    0x21c4_39fc,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x3000_0000,
    0x0800_0000,
    0x0c00_0000,
    0x7200_0000,
    0xf900_0000,
    0x4a80_0000,
    0x86c0_0000,
    0x14e0_0000,
    0x7db0_0000,
    0x0f28_0000,
    0x8dec_0000,
    0xe70a_0000,
    0x1183_0000,
    0xad57_8000,
    0xecde_c000,
    0x99b7_a000,
    0xe16e_d000,
    0x3e9f_8800,
    0x5082_dc00,
    0xa395_8a00,
    0xb401_df00,
    0x3642_1680,
    0x271f_2140,
    0xf195_a420,
    0x3d01_d0f0,
    0xd4c2_2918,
    0x9ddf_139c,
    0x9f75_a0d2,
    0xb5b1_efe7,
    0xe36a_0f90,
    0x6ff3_0ac7,
    0x261f_a0e5,
    0x5f42_f100,
    0x55f5_8790,
    0x7371_d6c7,
    0x578a_2ae5,
    0x2243_2e00,
    0x2137_9110,
    0xdeae_f787,
    0xc0ff_8ec5,
    0x9bf2_fef0,
    0xb05d_b808,
    0x485d_e41b,
    0xac60_2e17,
    0x4270_1117,
    0xf148_3798,
    0x469c_2edc,
    0xf4c2_2ef2,
    0xeddf_3017,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x5000_0000,
    0x2800_0000,
    0xe400_0000,
    0x1e00_0000,
    0x0d00_0000,
    0x4f80_0000,
    0x03c0_0000,
    0xb9e0_0000,
    0xcad0_0000,
    0xd878_0000,
    0xbc2c_0000,
    0xe27e_0000,
    0x8f41_0000,
    0x90ef_8000,
    0xbb1c_4000,
    0xe68f_a000,
    0x320c_5000,
    0xe717_b800,
    0x14f0_4400,
    0xf511_b200,
    0xc39d_7d00,
    0x9980_3580,
    0xfac0_3e40,
    0xa060_0660,
    0x7010_2eb0,
    0x1818_3018,
    0x9c3c_0804,
    0xd266_0c06,
    0xf77d_1e0f,
    0x5c89_b319,
    0x4161_7e9f,
    0xf586_24c2,
    0x70ad_00a8,
    0xab71_8b19,
    0xae8d_7a9f,
    0x8618_36c2,
    0xd13c_2da8,
    0xfde6_0699,
    0xa4bd_00df,
    0xcd69_82a2,
    0x6fb1_7e18,
    0x33fe_0301,
    0xc181_369b,
    0x068f_88c4,
    0x220c_4ea7,
    0xaf17_8000,
    0xa0f0_4000,
    0xc311_a000,
    0x2a9d_5000,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xb000_0000,
    0x3800_0000,
    0x2c00_0000,
    0xd200_0000,
    0x8d00_0000,
    0x7080_0000,
    0x14c0_0000,
    0xb2e0_0000,
    0x51f0_0000,
    0xf628_0000,
    0x0b74_0000,
    0x23c2_0000,
    0x8b7b_0000,
    0x6385_8000,
    0xab51_c000,
    0xd3e5_a000,
    0x9361_d000,
    0xffad_a800,
    0x4125_fc00,
    0x72a7_a600,
    0x31da_f700,
    0x6648_1280,
    0x8344_1440,
    0x378a_2ea0,
    0x753f_0170,
    0x3c8f_8a18,
    0x56ae_f90c,
    0xb78a_1992,
    0x353f_20d1,
    0x1c8f_8de2,
    0xe6ae_dd4f,
    0x8f8a_2f23,
    0x193f_05ab,
    0xce8f_a5e2,
    0x6bae_e14f,
    0xff0a_2923,
    0x0dff_22ab,
    0x7c6f_9f62,
    0x3a5e_c90f,
    0x0922_0183,
    0x068b_04db,
    0x5fad_affa,
    0xb125_d843,
    0x6aa7_90b1,
    0xadda_d27a,
    0x8c48_3a80,
    0x2244_2840,
    0x950a_28a0,
    0xecff_2670,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x5000_0000,
    0xd800_0000,
    0xec00_0000,
    0xf200_0000,
    0x6500_0000,
    0x8780_0000,
    0x05c0_0000,
    0x48a0_0000,
    0xcb10_0000,
    0x58f8_0000,
    0xb334_0000,
    0x84d2_0000,
    0xc913_0000,
    0xd5f5_8000,
    0x5094_4000,
    0x470d_a000,
    0xfaa0_7000,
    0x0e5f_b800,
    0xef73_6400,
    0x3e8a_0e00,
    0xf837_1f00,
    0x1c5f_9280,
    0x1a73_7640,
    0x010a_0b60,
    0x41f7_1330,
    0x7eff_9748,
    0x5863_7ef4,
    0x2c72_33f6,
    0x9203_1479,
    0x350d_81a2,
    0x5fa0_610d,
    0xe9df_b597,
    0xbab3_40dc,
    0xae2a_1322,
    0xdf27_174d,
    0xb6a7_bef7,
    0xcc47_53ec,
    0x0258_046a,
    0x8d24_29b9,
    0xe3aa_2d01,
    0xc3e7_3795,
    0x3387_bdc8,
    0xdb97_6cb4,
    0xbf80_3696,
    0x79c0_1849,
    0x02a0_046a,
    0x1210_29b9,
    0xf578_2d01,
    0x3ff4_3795,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x9000_0000,
    0x5800_0000,
    0xc400_0000,
    0x6600_0000,
    0x3b00_0000,
    0x3980_0000,
    0xd7c0_0000,
    0x10a0_0000,
    0xbb70_0000,
    0xf9f8_0000,
    0x77f4_0000,
    0x80a6_0000,
    0xe30d_0000,
    0x3db4_8000,
    0x11c6_4000,
    0xbbcc_a000,
    0xdaf2_7000,
    0xea4a_8800,
    0x014f_5400,
    0x00a6_1e00,
    0x230d_2500,
    0x9db4_a780,
    0x81c6_5bc0,
    0xe3cc_a1e0,
    0x1ef2_7a30,
    0x8c4a_9bc8,
    0x3a4f_41ec,
    0x3926_2a36,
    0xf4cd_23d1,
    0x8d14_bdff,
    0x3ab6_5022,
    0x1a34_b0da,
    0x6906_5b7f,
    0x0cec_9a7f,
    0xd942_4be2,
    0x0492_b13a,
    0xe50b_514f,
    0x36d8_09b7,
    0xe044_1e0e,
    0xf07e_250c,
    0x6849_279e,
    0x0c4a_9bc8,
    0xfa4f_41ec,
    0x9926_2a36,
    0x64cd_23d1,
    0xd514_bdff,
    0xfeb6_5022,
    0x7c34_b0da,
    0x5206_5b7f,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x1000_0000,
    0xb800_0000,
    0xb400_0000,
    0xfa00_0000,
    0x4700_0000,
    0xd180_0000,
    0x1fc0_0000,
    0xe2e0_0000,
    0x9410_0000,
    0x4a58_0000,
    0x0f24_0000,
    0xcd8e_0000,
    0xe9bb_0000,
    0xebe4_8000,
    0xf8a6_4000,
    0xc35c_a000,
    0x2392_5000,
    0xa48a_9800,
    0xd50d_5400,
    0x3ae0_3600,
    0x7010_3900,
    0xe858_2880,
    0xec24_38c0,
    0x5e0e_24e0,
    0x057b_3b30,
    0x2284_b258,
    0x3476_7334,
    0xba64_be4e,
    0xa766_713d,
    0xc1bc_814d,
    0xa782_48a3,
    0x56d2_ad0c,
    0x6e29_7e8e,
    0x0d6e_31cd,
    0xdeab_2463,
    0xd23c_bfec,
    0x0b42_7cbe,
    0x7fb2_ab15,
    0xb2f9_6f97,
    0xcc56_2542,
    0xee5f_36b3,
    0x4d0a_9800,
    0x3ecd_5400,
    0xc200_3600,
    0xb300_3900,
    0xcb80_2880,
    0x48c0_38c0,
    0x8b60_24e0,
    0x3fd0_3b30,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x5000_0000,
    0xb800_0000,
    0x1400_0000,
    0xd200_0000,
    0x6d00_0000,
    0x2580_0000,
    0x73c0_0000,
    0x54e0_0000,
    0x3850_0000,
    0x5438_0000,
    0xb244_0000,
    0x3d7e_0000,
    0x9dbf_0000,
    0x6795_8000,
    0x86ad_4000,
    0x554d_a000,
    0x71b9_5000,
    0xc18b_b800,
    0x6982_4400,
    0xa580_1600,
    0x33c0_0100,
    0x34e0_0280,
    0x6850_0a40,
    0xec38_13e0,
    0xa644_02b0,
    0xef7e_28d8,
    0xf0bf_09a4,
    0x4215_8956,
    0xf56d_7e75,
    0x01ad_af69,
    0x49e9_55ea,
    0x95b3_bbb4,
    0xdbc6_6e55,
    0x98fe_15e9,
    0xae7f_1baa,
    0x5375_be54,
    0xeefd_6de5,
    0xb975_bfb1,
    0xd7fd_584e,
    0x2ef5_84e2,
    0x993d_4120,
    0xe795_8000,
    0xc6ad_4000,
    0x354d_a000,
    0x21b9_5000,
    0x798b_b800,
    0x7d82_4400,
    0x7780_1600,
    0x5ec0_0100,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0xf000_0000,
    0x3800_0000,
    0x2c00_0000,
    0x8600_0000,
    0x7900_0000,
    0xe280_0000,
    0xd8c0_0000,
    0xafe0_0000,
    0xc010_0000,
    0xa028_0000,
    0x1014_0000,
    0xc872_0000,
    0x1449_0000,
    0xaa69_8000,
    0xff0e_c000,
    0x9ba1_a000,
    0x3a0a_d000,
    0x777b_9800,
    0x6f97_ec00,
    0x6000_1600,
    0xb000_2700,
    0xd800_1780,
    0xdc00_2940,
    0xbe00_1720,
    0x5500_2370,
    0x6480_32d8,
    0xa1c0_1874,
    0x4d60_3b52,
    0x18d0_0231,
    0x0fc8_31ee,
    0xd004_3113,
    0x685a_308c,
    0x045d_3ed4,
    0x621b_be6e,
    0xeb47_f453,
    0x31c8_31ac,
    0xc504_3aa4,
    0xecda_1b36,
    0x559d_0567,
    0x177b_bdde,
    0xdf97_cbe5,
    0xb800_0000,
    0x6c00_0000,
    0x6600_0000,
    0x8900_0000,
    0xda80_0000,
    0xf4c0_0000,
    0x29e0_0000,
    0xb910_0000,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x3000_0000,
    0x4800_0000,
    0x3400_0000,
    0x3e00_0000,
    0x1b00_0000,
    0xe080_0000,
    0xe2c0_0000,
    0xd3a0_0000,
    0xc650_0000,
    0xa708_0000,
    0x0acc_0000,
    0xf7e6_0000,
    0x6001_0000,
    0xf018_8000,
    0xa80a_c000,
    0x0430_a000,
    0x7656_f000,
    0x2f7e_9800,
    0xdecb_fc00,
    0xf988_0a00,
    0x330c_3100,
    0x24c6_2580,
    0x7491_07c0,
    0xccb0_a5a0,
    0x5096_f370,
    0x6ade_a348,
    0x079b_ffe4,
    0xc800_3d0a,
    0xf400_3797,
    0xde00_0ad3,
    0x2b00_2a27,
    0xa880_35bd,
    0xd6c0_3b71,
    0xeda0_3753,
    0xdd50_11e7,
    0x4788_3a1d,
    0xe80c_0901,
    0x2446_299b,
    0xa651_15c3,
    0x5710_a8b7,
    0xa2c6_fce6,
    0xf3d6_a580,
    0x1657_c7c0,
    0xdf66_05a0,
    0x76c1_0370,
    0xfdb8_bb48,
    0x455a_c3e4,
    0x0bb8_970a,
    0xaa5a_f697,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0xf000_0000,
    0x9800_0000,
    0x9c00_0000,
    0x4e00_0000,
    0x5900_0000,
    0x0780_0000,
    0xddc0_0000,
    0xdea0_0000,
    0x1a30_0000,
    0x2308_0000,
    0x34a4_0000,
    0xa13a_0000,
    0x8bc5_0000,
    0xdb95_8000,
    0x73d0_4000,
    0x57bd_a000,
    0x7584_7000,
    0xfaaf_a800,
    0x3815_4c00,
    0xac28_0e00,
    0xf654_2b00,
    0x3512_3d80,
    0xd191_0d40,
    0x1887_b460,
    0x9741_4630,
    0x9eba_05c8,
    0xfa05_17bc,
    0xf335_b68a,
    0x5ce0_40d5,
    0xa535_9124,
    0x59e0_7e54,
    0xccb5_ade9,
    0x2d20_696c,
    0x8d95_84a4,
    0x76d0_7f14,
    0x3e3d_b789,
    0x0144_745c,
    0xbb8f_94ec,
    0x63e5_69e8,
    0x1f80_1b63,
    0x81c0_29b9,
    0xb0a0_1580,
    0xb330_0140,
    0xbc88_1a60,
    0x7564_1d30,
    0x319a_1048,
    0xc8f5_16fc,
    0xff1d_acea,
    0x9ab4_5de5,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x1000_0000,
    0x0800_0000,
    0x8400_0000,
    0x9200_0000,
    0x9100_0000,
    0xbd80_0000,
    0x8cc0_0000,
    0x6160_0000,
    0xc5b0_0000,
    0x30d8_0000,
    0x6f6c_0000,
    0x4af6_0000,
    0x0a53_0000,
    0x5d2d_8000,
    0x8bc0_4000,
    0x9fdb_a000,
    0x4593_5000,
    0x70f6_2800,
    0x4f53_1400,
    0x5aad_8a00,
    0x0200_6500,
    0xd93b_8680,
    0x19e3_5540,
    0x0ece_23e0,
    0xf84f_1370,
    0xfc63_bd38,
    0x2e4f_775c,
    0x9f58_12ee,
    0x32ac_3ff7,
    0xb616_1d6b,
    0x5323_1a3f,
    0x0495_b0ce,
    0xa51c_5338,
    0x77f5_a053,
    0xb1ac_6d63,
    0xdaad_a220,
    0x4200_6ccf,
    0xf93b_bd38,
    0x09e3_775c,
    0x06ce_12ee,
    0x7c4f_3ff7,
    0x6e63_9d6b,
    0xbf4f_5a3f,
    0x22d8_10ce,
    0xbe6c_0338,
    0xd776_0853,
    0x9693_3963,
    0x344d_8820,
    0xca70_59cf,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0xf000_0000,
    0x7800_0000,
    0xac00_0000,
    0x3a00_0000,
    0x0d00_0000,
    0xf180_0000,
    0x6cc0_0000,
    0xf520_0000,
    0x9df0_0000,
    0x76a8_0000,
    0x0864_0000,
    0x141a_0000,
    0xb623_0000,
    0xc75f_8000,
    0x8494_4000,
    0x3145_a000,
    0xa3b7_7000,
    0x659a_2800,
    0x1ae3_0c00,
    0x127f_9600,
    0xe964_5700,
    0x3fed_b080,
    0x07d3_5840,
    0x4b80_1ae0,
    0xa1c0_1470,
    0x24a0_1728,
    0x0130_2b4c,
    0xfb88_3062,
    0x3994_0d25,
    0x58b2_2a4c,
    0xb347_37e1,
    0x22c5_b5f9,
    0x5e77_70e1,
    0x033a_3d64,
    0xbad3_1cad,
    0x2277_859b,
    0xb130_7dc4,
    0x63ff_9728,
    0x45a4_6b4c,
    0xeacd_9062,
    0x6a23_7d25,
    0x4528_024c,
    0x05a4_3be1,
    0x0aba_23f9,
    0xba13_27e1,
    0xcd57_8de4,
    0xd1c0_44ed,
    0x9cd7_9f7b,
    0x8d00_69b4,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x3000_0000,
    0x9800_0000,
    0x6c00_0000,
    0xaa00_0000,
    0x8300_0000,
    0xd780_0000,
    0xc0c0_0000,
    0xa160_0000,
    0x30d0_0000,
    0x9928_0000,
    0x8cf4_0000,
    0x9b4a_0000,
    0xfbdb_0000,
    0x8ae8_8000,
    0x1264_4000,
    0x7f42_a000,
    0x35af_5000,
    0x87e2_1800,
    0x28ef_1c00,
    0xb542_9e00,
    0xc6af_5700,
    0x2862_2c80,
    0xb42f_2bc0,
    0x2622_a760,
    0x197f_5cf0,
    0xccca_1bb8,
    0x7b1b_3704,
    0xcb88_9c92,
    0x12b4_43c9,
    0x7e6a_b378,
    0xd55b_66fb,
    0xb6a8_1eb0,
    0x5034_0a9b,
    0xe82a_30c0,
    0x140b_0dff,
    0xf640_bc22,
    0xb150_4e52,
    0x38e8_b738,
    0xbd64_5cc4,
    0xe2c2_9bf2,
    0x466f_4f39,
    0x6902_30c0,
    0xb4ff_0dff,
    0x270a_bc22,
    0xf98b_4e52,
    0xfd80_3738,
    0x03c0_1cc4,
    0x96e0_3bf2,
    0xc010_1f39,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x3000_0000,
    0x2800_0000,
    0x8c00_0000,
    0x2e00_0000,
    0xc300_0000,
    0xae80_0000,
    0x79c0_0000,
    0x9d20_0000,
    0xe5d0_0000,
    0x0b68_0000,
    0xd2ec_0000,
    0x1fa2_0000,
    0xe269_0000,
    0x4d32_8000,
    0x3dd8_c000,
    0xcf30_a000,
    0x40a1_f000,
    0xdaca_3800,
    0x0385_3c00,
    0xb410_9200,
    0x1a71_ef00,
    0x1922_2180,
    0xd7a9_23c0,
    0x9e12_b820,
    0x2b08_e2b0,
    0x42d8_a6e8,
    0x678d_f404,
    0x7648_1612,
    0xc73c_010f,
    0x5cca_3c92,
    0x8c85_3d51,
    0x5490_b26c,
    0x90b1_dd58,
    0x0282_227a,
    0xc7b9_3555,
    0x265a_967e,
    0xdf34_c357,
    0xf892_8768,
    0x2ec8_d7c4,
    0xb9f8_ae32,
    0xfd5d_e3bf,
    0xd5a0_1a7a,
    0x2310_0955,
    0x5ec8_047e,
    0x31fc_2c57,
    0x216a_26e8,
    0xe395_3404,
    0x4458_b612,
    0x524d_f10f,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x7000_0000,
    0x4800_0000,
    0x6c00_0000,
    0x4e00_0000,
    0x3b00_0000,
    0x9480_0000,
    0xc1c0_0000,
    0xbe20_0000,
    0xb350_0000,
    0x9888_0000,
    0xffdc_0000,
    0xcd32_0000,
    0x4bc1_0000,
    0x1772_8000,
    0x7aab_c000,
    0xeac8_a000,
    0x12b6_f000,
    0x5688_3800,
    0x04dc_2c00,
    0x39b2_0a00,
    0xfa01_0700,
    0xe152_8180,
    0xa5fb_d5c0,
    0x3c40_96a0,
    0xd66a_ceb0,
    0x0f3a_32a8,
    0x8edd_30a4,
    0x90e0_83aa,
    0x33fa_d423,
    0x9312_34ee,
    0x4891_08c7,
    0xa7fa_9830,
    0x9977_eeea,
    0x21fa_87c6,
    0x0e77_eda3,
    0x9b7a_8d3a,
    0x84b7_f479,
    0xf9da_8180,
    0x9a27_d5c0,
    0x9172_96a0,
    0xedab_ceb0,
    0x5048_b2a8,
    0x9876_f0a4,
    0x3428_23aa,
    0x1a4c_2423,
    0x511a_0cee,
    0x8d8d_24c7,
    0x2068_9230,
    0xd026_e9ea,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x9000_0000,
    0x5800_0000,
    0x4400_0000,
    0x1a00_0000,
    0xf100_0000,
    0x4e80_0000,
    0xf5c0_0000,
    0x3260_0000,
    0x3d10_0000,
    0x28f8_0000,
    0xcaa4_0000,
    0xcfee_0000,
    0x337f_0000,
    0xbbad_8000,
    0xc14b_c000,
    0xa6bb_a000,
    0x1990_d000,
    0xa478_3800,
    0xca64_3400,
    0xc90e_0e00,
    0x9aaf_3500,
    0xb7b5_9080,
    0x873f_ed40,
    0x69cd_b520,
    0x2c5b_d130,
    0xb643_a738,
    0x0734_c634,
    0x2996_28a6,
    0x4c1b_18ed,
    0x2623_b145,
    0x5f24_f736,
    0x6dee_3e30,
    0x567f_3cbd,
    0xd72d_86fd,
    0x118b_dc42,
    0x985b_a3b6,
    0x6440_f560,
    0xea60_1080,
    0x3910_2d40,
    0x52f8_1520,
    0xaba4_0130,
    0xd96e_1f38,
    0x82bf_3234,
    0x93cd_86a6,
    0x0d5b_fded,
    0xc0c3_99c5,
    0x26f4_ee76,
    0x59f6_2510,
    0xc40b_088d,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0xf000_0000,
    0xc800_0000,
    0xe400_0000,
    0x4200_0000,
    0xbd00_0000,
    0x6a80_0000,
    0x05c0_0000,
    0x2a20_0000,
    0x8910_0000,
    0xf088_0000,
    0x64dc_0000,
    0x2eb6_0000,
    0x9783_0000,
    0x4f57_8000,
    0x3fe7_c000,
    0x9b69_a000,
    0x55b8_f000,
    0x3208_1800,
    0xb51c_0c00,
    0x6e96_0a00,
    0xb793_0500,
    0x5f5f_a280,
    0x07fb_d640,
    0xb77f_aa20,
    0xf3eb_de30,
    0xcd77_8828,
    0x62f7_ef34,
    0x01e1_9caa,
    0x9864_ce73,
    0xfc3e_0d0f,
    0x7e5f_2697,
    0x2361_9858,
    0xb9a4_c129,
    0x741e_27a7,
    0xba4f_1fe3,
    0x7169_aed2,
    0x3cb8_d16a,
    0x3288_2280,
    0x19dc_1640,
    0xa436_0a20,
    0x6243_2e30,
    0xad77_9028,
    0x52f7_e334,
    0x29e1_96aa,
    0x8c64_cb73,
    0x763e_2f8f,
    0x275f_30d7,
    0x0be1_9278,
    0x0164_ef19,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x1000_0000,
    0x4800_0000,
    0xdc00_0000,
    0x9200_0000,
    0x5300_0000,
    0x6c80_0000,
    0x85c0_0000,
    0x3660_0000,
    0xe550_0000,
    0xc9f8_0000,
    0xac6c_0000,
    0x8a6a_0000,
    0x2757_0000,
    0x32e8_8000,
    0x0cfb_c000,
    0xd5fa_a000,
    0x9e00_d000,
    0x2918_1800,
    0x13fc_1400,
    0x2372_2a00,
    0x74ab_3300,
    0xf19a_b680,
    0x6850_e3c0,
    0x6c60_1fa0,
    0x2a50_25b0,
    0xd778_2eb8,
    0x6aac_1c24,
    0x988a_2de6,
    0x9bc7_254f,
    0x5f70_b464,
    0x16c7_f60e,
    0xfae8_9500,
    0x90fb_fb9b,
    0xa7fa_ac5c,
    0xdd00_c9ea,
    0x0d98_0746,
    0x4a3c_2b64,
    0x8712_2e80,
    0xc2fb_37c0,
    0x54e2_95a0,
    0x41fc_c6b0,
    0xd06a_0038,
    0xe857_2be4,
    0x2c68_b846,
    0xca3b_e3ff,
    0xc71a_b45c,
    0x2290_ddea,
    0x4480_2d46,
    0x09c0_1864,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0xd000_0000,
    0x9800_0000,
    0x6c00_0000,
    0x2e00_0000,
    0x7100_0000,
    0x7c80_0000,
    0xebc0_0000,
    0xd220_0000,
    0x6750_0000,
    0xd1d8_0000,
    0xf164_0000,
    0xbc9a_0000,
    0x8bd1_0000,
    0x0267_8000,
    0xff1a_c000,
    0xbda5_a000,
    0xdf6f_f000,
    0xcdf8_3800,
    0xf734_0400,
    0xe9c2_3e00,
    0x2d75_2f00,
    0xdadd_ad80,
    0x0e9b_c740,
    0x3c9a_34a0,
    0x4bd1_16b0,
    0x6267_b3a8,
    0x2f1a_d724,
    0x25a5_86fe,
    0xb36f_ce8d,
    0xe3f8_28d0,
    0x8634_06ed,
    0x9542_0e9f,
    0xc6b5_08c2,
    0x08fd_b6f8,
    0x69cb_d689,
    0xed42_1cc1,
    0xbab5_20ff,
    0xdefd_9580,
    0xa4cb_c340,
    0x27c2_0aa0,
    0x4c75_39b0,
    0x5e5d_9e28,
    0x595b_d064,
    0x58ba_125e,
    0x3181_283d,
    0xe13f_a378,
    0x44be_d5c9,
    0x379f_b661,
    0xb42e_e94f,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x3000_0000,
    0xb800_0000,
    0xac00_0000,
    0x0600_0000,
    0xfd00_0000,
    0xef80_0000,
    0xf8c0_0000,
    0x8c20_0000,
    0xf630_0000,
    0xe548_0000,
    0x73c4_0000,
    0x46ca_0000,
    0xdd75_0000,
    0x1fcd_8000,
    0xe081_4000,
    0x106f_a000,
    0x4800_7000,
    0xb420_0800,
    0x9a30_3c00,
    0x4348_0600,
    0xbec4_2700,
    0x114a_2f80,
    0x89b5_1440,
    0x95ed_ba60,
    0xebb1_4170,
    0x1aa7_b8e8,
    0xc304_73bc,
    0x7eca_125a,
    0xb175_1d7d,
    0xb9cd_aee0,
    0x2d81_4cac,
    0x47ef_99c1,
    0x1cc0_6b3d,
    0x3e00_3188,
    0x9100_1750,
    0x4980_37fb,
    0x35c0_1030,
    0xdba0_0800,
    0xa2f0_3c00,
    0x6f68_0600,
    0x78f4_2700,
    0x4c02_2f80,
    0x5671_1440,
    0xd527_ba60,
    0xcbc4_4170,
    0xeaea_38e8,
    0xdb45_33bc,
    0xe285_b25a,
    0x0f45_6d7d,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x5000_0000,
    0x5800_0000,
    0x1400_0000,
    0x5a00_0000,
    0x7500_0000,
    0x6c80_0000,
    0x87c0_0000,
    0xdc60_0000,
    0xf670_0000,
    0xcb78_0000,
    0x4b84_0000,
    0xd266_0000,
    0x7907_0000,
    0x82c7_8000,
    0xf8e4_c000,
    0x9db9_a000,
    0x0917_d000,
    0xcae0_0800,
    0x14b0_0400,
    0x8398_3e00,
    0x7e34_1100,
    0xc77e_0080,
    0xa5f3_1840,
    0xad59_8da0,
    0x38a7_fcb0,
    0x7df8_0c38,
    0xf944_0c6c,
    0xc286_2dc6,
    0x58b7_3b7d,
    0xcddf_9047,
    0x5110_c9a0,
    0xdea7_a2a8,
    0x4e94_ed38,
    0xf6c1_94ff,
    0x1293_d98c,
    0x4086_3cce,
    0x79b7_3bf5,
    0x5b5f_8800,
    0xf3d0_c400,
    0x3647_9e00,
    0x2b24_c100,
    0xbbd9_8880,
    0xda67_dc40,
    0x3518_13a0,
    0xccf4_3db0,
    0xd79e_04b8,
    0x8443_102c,
    0xe241_9e66,
    0x9153_d6cd,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x7000_0000,
    0xe800_0000,
    0x9400_0000,
    0x4200_0000,
    0x7b00_0000,
    0x4980_0000,
    0x3cc0_0000,
    0x9020_0000,
    0x5850_0000,
    0x1c08_0000,
    0xa64c_0000,
    0xd13e_0000,
    0xa6eb_0000,
    0x375c_8000,
    0xd7f9_4000,
    0x81ca_a000,
    0x78ce_7000,
    0x2a00_3800,
    0x2f00_2c00,
    0x6b80_2200,
    0x37c0_3900,
    0x31a0_2a80,
    0xf090_3bc0,
    0xce28_02e0,
    0x851c_11f0,
    0x84b6_3668,
    0x3c67_1924,
    0x7642_a30a,
    0x2942_7f87,
    0xaa9e_134d,
    0x097b_3029,
    0x7af4_a198,
    0xf125_4044,
    0x76dc_b7a5,
    0xcf39_7ecd,
    0xdbea_8272,
    0xbf9e_6733,
    0xd588_0000,
    0x5a8c_0000,
    0x211e_0000,
    0x8ebb_0000,
    0xc354_8000,
    0xe5b5_4000,
    0x12f4_a000,
    0xa525_7000,
    0x54dc_b800,
    0xc439_6c00,
    0x7a6a_8200,
    0x175e_4900,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0xf000_0000,
    0x2800_0000,
    0x1400_0000,
    0x4a00_0000,
    0xe300_0000,
    0x6f80_0000,
    0x72c0_0000,
    0x7020_0000,
    0xe830_0000,
    0x3408_0000,
    0xba3c_0000,
    0xcb0a_0000,
    0x7b85_0000,
    0x38d2_8000,
    0x9318_c000,
    0x87ab_e000,
    0x46d4_b000,
    0xca00_0800,
    0x2300_0c00,
    0x4f80_0200,
    0x82c0_0f00,
    0x5820_0280,
    0xfc30_0140,
    0x7e08_04a0,
    0x593c_0e30,
    0xa48a_06f8,
    0x0945_072c,
    0x48f2_8702,
    0x7b28_ce83,
    0xb3a3_e340,
    0xfce8_bba3,
    0x010a_04b0,
    0x5885_0bb8,
    0x7752_818d,
    0x11d8_c631,
    0xdf8b_eafa,
    0xbae4_b52d,
    0xb408_0000,
    0x7a3c_0000,
    0xeb0a_0000,
    0x8b85_0000,
    0x10d2_8000,
    0x8718_c000,
    0xcdab_e000,
    0xa5d4_b000,
    0xa580_0800,
    0x51c0_0c00,
    0x3fa0_0200,
    0x6af0_0f00,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x5000_0000,
    0x2800_0000,
    0x9c00_0000,
    0x7e00_0000,
    0xff00_0000,
    0x4380_0000,
    0x79c0_0000,
    0xb820_0000,
    0x1410_0000,
    0x5238_0000,
    0xf914_0000,
    0x088a_0000,
    0xd867_0000,
    0x40ff_8000,
    0x108f_c000,
    0x7c78_e000,
    0x6ad2_7000,
    0x5d80_0800,
    0x96c0_0400,
    0x33a0_0e00,
    0xa1d0_0500,
    0xbc18_0280,
    0x8e04_09c0,
    0x6732_07e0,
    0xa7b3_0ff0,
    0xb3d5_8438,
    0xa538_c79c,
    0xd69f_6b82,
    0x9759_b141,
    0x7b4a_ed23,
    0xdd61_7b91,
    0x2655_8688,
    0xfff8_cc86,
    0xb33f_688f,
    0x5589_bdc8,
    0xfad2_eaa7,
    0xd5a5_749d,
    0xbac7_8000,
    0x359b_c000,
    0xeaf2_e000,
    0x1db5_7000,
    0x76ff_8800,
    0x638f_c400,
    0x89f8_ee00,
    0x2012_7500,
    0xf020_0a80,
    0x9810_0dc0,
    0xe438_09e0,
    0xca14_0af0,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x7000_0000,
    0x4800_0000,
    0x1c00_0000,
    0xae00_0000,
    0xf900_0000,
    0x6c80_0000,
    0x95c0_0000,
    0x7c20_0000,
    0x3e30_0000,
    0xe108_0000,
    0x489c_0000,
    0x6fd2_0000,
    0x3727_0000,
    0x059b_8000,
    0xe176_4000,
    0xcde7_2000,
    0xb827_7000,
    0x9420_0800,
    0x9230_0c00,
    0x2708_0200,
    0xdd9c_0700,
    0xe552_0480,
    0x47e7_01c0,
    0xbb3b_8ae0,
    0xb386_4f90,
    0x3c4f_26c8,
    0x5b4b_795c,
    0x66da_0fc2,
    0xd3bb_0fe3,
    0xac49_8c10,
    0x4351_4389,
    0x42fc_a27d,
    0x2991_32b2,
    0xe767_22b9,
    0x78e7_7d87,
    0x4280_0016,
    0xacc0_09de,
    0x30a0_0800,
    0xdbf0_0c00,
    0xd528_0200,
    0x6aac_0700,
    0x20da_0480,
    0x86bb_01c0,
    0x06c9_8ae0,
    0x4391_4f90,
    0xb45c_a6c8,
    0x6761_395c,
    0xb8cf_2fc2,
    0x628b_7fe3,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0xd000_0000,
    0x4800_0000,
    0xbc00_0000,
    0x0e00_0000,
    0xe100_0000,
    0xb580_0000,
    0x3dc0_0000,
    0x8c20_0000,
    0xd610_0000,
    0x7518_0000,
    0xd7b4_0000,
    0x9ad2_0000,
    0x648f_0000,
    0x5053_8000,
    0x25c0_4000,
    0x3829_6000,
    0x0415_7000,
    0x4a20_0800,
    0xcb10_0400,
    0xae98_0600,
    0xdb74_0d00,
    0xeb72_0480,
    0x335f_0bc0,
    0xa76b_80e0,
    0xc564_4e10,
    0x6263_6b58,
    0x8aee_73dc,
    0x0c81_80c2,
    0x5c4f_4961,
    0xb3fa_e151,
    0x2d15_307b,
    0x03a9_652d,
    0x98d5_7988,
    0x1380_0be5,
    0xf0c0_054c,
    0x1fa0_0a5a,
    0x66d0_055d,
    0x0ab8_0800,
    0x6164_0400,
    0xd86a_0600,
    0xb9eb_0d00,
    0x8639_8480,
    0x7d2b_4bc0,
    0x0b90_e0e0,
    0x44fe_3e10,
    0xcd90_e358,
    0x59fe_37dc,
    0x1610_e6c2,
    0x553e_3461,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0xd000_0000,
    0x9800_0000,
    0x3400_0000,
    0x1200_0000,
    0x4300_0000,
    0x0480_0000,
    0xb840_0000,
    0x4620_0000,
    0x4130_0000,
    0x3fb8_0000,
    0x58f4_0000,
    0x7446_0000,
    0x701d_0000,
    0x680c_8000,
    0x9c1c_c000,
    0x6e13_2000,
    0xfd05_1000,
    0x6198_0800,
    0xedc4_0c00,
    0xb9fe_0e00,
    0xbbe9_0d00,
    0x80ca_8980,
    0x6041_c340,
    0x523f_a120,
    0x6329_d430,
    0x34b3_2848,
    0xf075_1784,
    0xea00_0262,
    0x6700_0513,
    0x6e80_047b,
    0x1f40_0bcf,
    0xc8a0_0fe4,
    0x8e70_0071,
    0x6f18_07e8,
    0xe284_0675,
    0x095e_02cb,
    0xd199_0047,
    0x65d2_8180,
    0xf5c5_cf40,
    0x4de1_af20,
    0x49f0_d930,
    0x13c1_a1c8,
    0xfcc0_d4c4,
    0xde79_a342,
    0x3734_d123,
    0x36bf_ac33,
    0xcb69_dc4b,
    0x0a93_2d86,
    0x5545_1562,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x5000_0000,
    0x9800_0000,
    0xec00_0000,
    0x0e00_0000,
    0x2900_0000,
    0x9f80_0000,
    0xa940_0000,
    0x5220_0000,
    0x8f30_0000,
    0x32a8_0000,
    0x1cd4_0000,
    0xa846_0000,
    0x89ab_0000,
    0xac5b_8000,
    0x6396_4000,
    0x5f65_e000,
    0x673f_5000,
    0xd688_0800,
    0xc6e4_0c00,
    0x336e_0a00,
    0xa93f_0500,
    0x5fbd_8980,
    0x094d_4ec0,
    0x0236_60e0,
    0x170d_1290,
    0xdea3_e1f8,
    0x12d4_5694,
    0x8173_8722,
    0x1602_41f3,
    0x0503_e0aa,
    0x31a4_5a0d,
    0xd07b_8be4,
    0x55a6_48ca,
    0xca4d_e9dd,
    0x6eab_5b3d,
    0xbaee_08ac,
    0x057f_06d4,
    0x3c1d_8180,
    0x563d_42c0,
    0x653e_6ae0,
    0xc1a9_1790,
    0x186d_e878,
    0x219b_5854,
    0x2846_07c2,
    0x49ab_0363,
    0x0c5b_8952,
    0x3396_4099,
    0xc765_e6c6,
    0x8b3f_5c39,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x3000_0000,
    0xf800_0000,
    0xfc00_0000,
    0x1e00_0000,
    0x2b00_0000,
    0x6780_0000,
    0xc540_0000,
    0xab20_0000,
    0x2790_0000,
    0x6568_0000,
    0x9b2c_0000,
    0xdfae_0000,
    0x9957_0000,
    0x852b_8000,
    0xf4a4_c000,
    0xfece_e000,
    0x405a_d000,
    0x5fae_0800,
    0xd957_0400,
    0x252b_8a00,
    0xc4a4_c300,
    0x06ce_ef80,
    0xbc5a_dfc0,
    0x41ae_09e0,
    0xf257_06b0,
    0x42ab_8c78,
    0x01e4_cf54,
    0xadee_e532,
    0x9bca_ddb9,
    0x24c6_0fb6,
    0x697b_0f02,
    0x9d05_8182,
    0x98b3_c6c1,
    0x28c5_6d60,
    0x6f6e_12f3,
    0xda08_e05a,
    0x2921_db07,
    0xc2ab_8c78,
    0x41e4_cf54,
    0x0dee_e532,
    0xabca_ddb9,
    0xdcc6_0fb6,
    0x957b_0f02,
    0x8305_8182,
    0xb3b3_c6c1,
    0x4f45_6d60,
    0xaa2e_12f3,
    0x7128_e05a,
    0x0eb1_db07,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x9000_0000,
    0x6800_0000,
    0x9c00_0000,
    0x0600_0000,
    0x2f00_0000,
    0xf880_0000,
    0x2a40_0000,
    0x7f20_0000,
    0x3090_0000,
    0xc678_0000,
    0x8104_0000,
    0xeb8a_0000,
    0xa4df_0000,
    0x8245_8000,
    0x4321_c000,
    0x46b1_2000,
    0x1157_1000,
    0x8d8a_0800,
    0x5bdf_0400,
    0xf2c5_8e00,
    0x6561_c900,
    0x5791_2680,
    0x92c7_19c0,
    0xb572_0860,
    0xdf9b_06f0,
    0x9eef_8188,
    0xdb6e_cba4,
    0x6c8c_a172,
    0x6072_dac9,
    0xde31_2407,
    0xeb17_1ee0,
    0x7aaa_0730,
    0x674f_05e9,
    0x5abd_8756,
    0x5765_c7fb,
    0x429b_2eec,
    0x3358_1235,
    0xb097_8188,
    0x866a_cba4,
    0x6106_a172,
    0x7bad_dac9,
    0xccf4_a407,
    0x1e76_dee0,
    0x453b_2730,
    0x6988_15e9,
    0xe9cf_8f56,
    0xa7fe_c3fb,
    0x24f4_a0ec,
    0xc276_db35,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x7000_0000,
    0xa800_0000,
    0x4400_0000,
    0xc200_0000,
    0x1300_0000,
    0xcf80_0000,
    0xe240_0000,
    0x7120_0000,
    0x6cb0_0000,
    0xa5c8_0000,
    0xa77c_0000,
    0x77ba_0000,
    0x9e69_0000,
    0x0f04_8000,
    0x2182_c000,
    0x5740_e000,
    0x1fa5_1000,
    0xfa72_0800,
    0xbd15_0c00,
    0x9abe_8200,
    0xdceb_c700,
    0x3fc4_6a80,
    0x9867_d440,
    0x1e12_e420,
    0xdd00_1d30,
    0x0a84_86f8,
    0x24c2_c524,
    0xa3e0_ef92,
    0xb655_158b,
    0x8b1a_04fc,
    0xc399_0307,
    0x346c_85a3,
    0x780e_c1f2,
    0x5c12_e19a,
    0x0e00_1eb7,
    0xe504_8c1a,
    0xb682_c076,
    0x7ac0_ec78,
    0x9ee5_1164,
    0xecd2_0bb2,
    0x77e5_08bb,
    0x8c56_8204,
    0x0427_c623,
    0x2236_6a31,
    0x4332_d479,
    0x178c_6566,
    0x0e5b_ddb0,
    0xf708_e9b9,
    0xbd99_1184,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x1000_0000,
    0x1800_0000,
    0x7c00_0000,
    0x8e00_0000,
    0x6f00_0000,
    0x5280_0000,
    0x1fc0_0000,
    0x5920_0000,
    0x71b0_0000,
    0x2b78_0000,
    0x5de4_0000,
    0x9016_0000,
    0xd817_0000,
    0x9c1f_8000,
    0x9e19_c000,
    0x770d_a000,
    0x2ebb_7000,
    0x91ee_0800,
    0x3633_0c00,
    0x2329_8e00,
    0x34be_c100,
    0x04ea_2180,
    0xe186_b7c0,
    0xf355_a0e0,
    0xc1ef_7af0,
    0x0e00_0328,
    0xaf00_0cfc,
    0xb280_0a12,
    0x0fc0_01db,
    0x4120_0bd7,
    0x0db0_04ee,
    0xa578_04c9,
    0x32e4_0a8d,
    0xc296_097b,
    0xc7d7_0f06,
    0xc53f_8055,
    0xefa9_c02e,
    0x5c75_a2a8,
    0x735f_7b3c,
    0x01f8_0af2,
    0xee24_0b2b,
    0xbf36_00ff,
    0xaaa7_0412,
    0x73e7_80db,
    0xcf3d_ca56,
    0x62bb_a32c,
    0xf7dc_7c28,
    0x2d29_847c,
    0x9bbe_c053,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0xb000_0000,
    0x0800_0000,
    0xf400_0000,
    0xa600_0000,
    0x7700_0000,
    0x6580_0000,
    0xd3c0_0000,
    0x4520_0000,
    0xe490_0000,
    0xd968_0000,
    0xbf4c_0000,
    0x2872_0000,
    0x5de5_0000,
    0x361d_8000,
    0x8f0b_c000,
    0x39a2_6000,
    0x31ce_7000,
    0x9c3a_0800,
    0x0239_0400,
    0xc907_8a00,
    0x5ea2_cb00,
    0xec4d_e080,
    0xb3e0_bf40,
    0x1525_e260,
    0xfcac_b370,
    0x9557_e458,
    0xe549_b23c,
    0x0d4a_66d2,
    0xe942_7e09,
    0xf768_0576,
    0x7c4c_0cc4,
    0x4bf2_043f,
    0x4925_0bd2,
    0x1ebd_8b8b,
    0x4c5b_c3b5,
    0x03ea_6666,
    0x1d12_7ced,
    0x08a0_0cd8,
    0x3350_097c,
    0x9248_0eb2,
    0x68dc_0679,
    0x3a9a_01ae,
    0xb269_01b8,
    0x98cf_808d,
    0x92be_c6ab,
    0xf677_eaa5,
    0x36d9_bd4d,
    0x11a2_648b,
    0x35ce_7936,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0xd000_0000,
    0x4800_0000,
    0xf400_0000,
    0x2600_0000,
    0x6100_0000,
    0x1780_0000,
    0x08c0_0000,
    0xbb20_0000,
    0x04b0_0000,
    0xe858_0000,
    0x5d54_0000,
    0x1cc2_0000,
    0x8d35_0000,
    0x4d95_8000,
    0xdbe6_4000,
    0x3bbe_e000,
    0x32d4_b000,
    0xb83a_0800,
    0xcc11_0c00,
    0x2a2f_8600,
    0x2b37_4d00,
    0xecb1_6480,
    0xac53_ff40,
    0xe353_6a60,
    0xc1d6_fa10,
    0x489e_ef78,
    0x0264_b18c,
    0x1662_0132,
    0x2045_0e0b,
    0x696d_8e65,
    0x5ac2_4185,
    0x3c04_e654,
    0x1205_b10f,
    0x2735_8473,
    0xa696_4769,
    0x5746_e1f4,
    0x47f0_bb3f,
    0x9980_03f8,
    0x8dc0_02cc,
    0xa2a0_0d52,
    0x4970_091b,
    0x2af8_0d9d,
    0xc424_0349,
    0x7e3a_0b06,
    0xbd11_0814,
    0x15af_81ee,
    0x07f7_4820,
    0x3991_6cf2,
    0x3de3_fe2b,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x7000_0000,
    0x7800_0000,
    0x7400_0000,
    0x7e00_0000,
    0x5f00_0000,
    0xd080_0000,
    0x7540_0000,
    0x7d20_0000,
    0x2d90_0000,
    0x18f8_0000,
    0x85fc_0000,
    0xd86e_0000,
    0xb895_0000,
    0x496b_8000,
    0xef0d_c000,
    0x08bb_2000,
    0x9179_d000,
    0x0b36_0800,
    0x7eb9_0400,
    0xc25d_8e00,
    0xd1b4_c700,
    0x2ae6_a780,
    0x30cd_1740,
    0x59d0_afe0,
    0x3a74_11f0,
    0xe58d_2b08,
    0xb4c0_d454,
    0x1feb_8652,
    0xf14d_c699,
    0x3b1b_2fef,
    0xe6a9_ddef,
    0xc66e_08ee,
    0xd795_0a6d,
    0x01eb_87ac,
    0x9e4d_c98d,
    0x739b_2c5e,
    0x97e9_d385,
    0xbd4e_0488,
    0xd105_0714,
    0xb793_87b2,
    0x31f1_c069,
    0x0655_2b67,
    0x77ac_dafb,
    0x91fd_8f5c,
    0x9664_ca04,
    0x7fbe_accb,
    0x9de1_1376,
    0x9c66_a302,
    0x5e8d_1981,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x9000_0000,
    0xc800_0000,
    0x2400_0000,
    0x8e00_0000,
    0x3900_0000,
    0x6a80_0000,
    0x6040_0000,
    0x5aa0_0000,
    0xf870_0000,
    0x96a8_0000,
    0xc254_0000,
    0xe99a_0000,
    0xb5dd_0000,
    0x6d79_8000,
    0xb633_4000,
    0xa533_2000,
    0xb8b3_5000,
    0xab79_8800,
    0x6b33_4c00,
    0x61b3_2200,
    0x71f3_5900,
    0x5359_8480,
    0xd703_4e40,
    0x23bb_2ae0,
    0x72d7_5a90,
    0x46eb_8228,
    0xc0ca_4844,
    0xfdf8_af4a,
    0x8949_1517,
    0x1809_2b42,
    0x0c1e_5461,
    0x1a28_09d3,
    0xef14_024a,
    0xbfba_0795,
    0xa0ed_0a02,
    0x8df1_8500,
    0xf157_4e81,
    0x6421_2b42,
    0x6e0a_5461,
    0x8912_09d3,
    0x32b9_024a,
    0x8c6b_8795,
    0xf08a_4a02,
    0x4f58_a500,
    0xc539_1e81,
    0xc8a1_2342,
    0xd34a_5861,
    0x1732_0bd3,
    0x0389_0b4a,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0xd000_0000,
    0xf800_0000,
    0xbc00_0000,
    0xca00_0000,
    0x3900_0000,
    0x1380_0000,
    0x5540_0000,
    0xbba0_0000,
    0xd170_0000,
    0x6d88_0000,
    0xf244_0000,
    0xbf36_0000,
    0x08ab_0000,
    0x9be4_8000,
    0x5b75_4000,
    0x3498_6000,
    0x91ec_1000,
    0xc264_8800,
    0xf735_4c00,
    0x3cb8_6a00,
    0xc5dc_1d00,
    0xec4c_8780,
    0x6801_47c0,
    0x2406_66a0,
    0x0633_1e90,
    0xdb1e_06b8,
    0x6e9f_0294,
    0x30da_8d1a,
    0x1dda_4387,
    0x406a_e860,
    0xfa02_51b0,
    0x7130_64e9,
    0x2798_120d,
    0x0b7a_8c5e,
    0x0caa_4ec7,
    0x8de2_e680,
    0xd846_5243,
    0x3606_6860,
    0x9333_11b0,
    0x5a9e_04e9,
    0x6edf_020d,
    0xaafa_845e,
    0x1cea_42c7,
    0x4fc2_ec80,
    0xb576_5f43,
    0x0bae_67e0,
    0x5947_1a70,
    0xf980_0849,
    0x7c40_019d,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x3000_0000,
    0xf800_0000,
    0xe400_0000,
    0xfa00_0000,
    0xad00_0000,
    0xb680_0000,
    0x89c0_0000,
    0x92a0_0000,
    0x53d0_0000,
    0x6fb8_0000,
    0x2d5c_0000,
    0xfa46_0000,
    0xa1c5_0000,
    0xfea8_8000,
    0xd5d6_4000,
    0xec99_2000,
    0x34d2_3000,
    0x8c08_8800,
    0xf606_4400,
    0x1b21_2600,
    0xcd8e_3300,
    0x744e_8780,
    0x1ec3_4a40,
    0xa909_a9a0,
    0x3c98_79d0,
    0xbcf7_ace8,
    0xf001_72dc,
    0xd819_288a,
    0xb412_38ed,
    0x3228_8c13,
    0xb116_4309,
    0xa8b9_20ae,
    0xdec2_38b1,
    0x8910_8a59,
    0x6c8a_4784,
    0x74df_2a8f,
    0xec17_3d20,
    0xc620_0413,
    0xe310_0709,
    0x2998_06ae,
    0x8e4c_0bb1,
    0xb3de_0dd9,
    0x1f89_0dc4,
    0xb576_832f,
    0x2e5f_44f0,
    0xa3ef_a8fb,
    0xb78d_75d5,
    0x9967_2e24,
    0xc84b_335c,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x1000_0000,
    0x6800_0000,
    0xe400_0000,
    0x8600_0000,
    0x9d00_0000,
    0xe180_0000,
    0xb0c0_0000,
    0xeda0_0000,
    0x12f0_0000,
    0x1698_0000,
    0x7e74_0000,
    0x2fc2_0000,
    0xc72d_0000,
    0x56b3_8000,
    0x5e62_4000,
    0xdfe7_e000,
    0xbf38_7000,
    0xda93_8800,
    0x3c52_4c00,
    0xc4df_ee00,
    0xc3bc_7100,
    0x8bc9_8e80,
    0x610b_4240,
    0x3bae_6660,
    0xc7f3_38d0,
    0xe31d_e098,
    0x3091_794c,
    0xd37a_00ba,
    0x5669_05ff,
    0xebc9_87f1,
    0xb10b_43ab,
    0xb3ae_62c6,
    0x33f3_3acd,
    0x0d1d_ea7a,
    0x4991_7cdd,
    0xb4fa_09c0,
    0x7ba9_00a2,
    0xe7e9_8ff1,
    0x133b_4fab,
    0x4896_6cc6,
    0x5f77_3bcd,
    0x3447_ecfa,
    0xf0c8_729d,
    0xcd8b_81a0,
    0xe2e6_4972,
    0x6ebd_e1e9,
    0xf261_74a7,
    0x4de2_0a1c,
    0xdc1d_06e2,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x7000_0000,
    0xa800_0000,
    0x3400_0000,
    0xd200_0000,
    0x5900_0000,
    0xd680_0000,
    0xf140_0000,
    0x9aa0_0000,
    0x8f50_0000,
    0xada8_0000,
    0x96cc_0000,
    0xa942_0000,
    0x46a1_0000,
    0x4946_8000,
    0x56af_4000,
    0xb167_2000,
    0xbaa5_1000,
    0xff66_8800,
    0x05bf_4400,
    0xa2ef_2200,
    0x7b79_1700,
    0x1fac_8280,
    0x9fc2_4740,
    0xa7e3_af20,
    0x2beb_5290,
    0x35e7_2fe8,
    0x52e5_1854,
    0x9346_8e8a,
    0x0baf_4e65,
    0x3de7_2f32,
    0x56e5_1238,
    0xc946_8c9e,
    0x16af_4e4f,
    0x9167_2c06,
    0xcaa5_1182,
    0x5766_87c0,
    0x31bf_4f61,
    0x70ef_2732,
    0x2279_1638,
    0xc92c_8e9e,
    0x6e82_494f,
    0x3d43_a686,
    0xa4bb_52c2,
    0x984f_2ae0,
    0xc429_1af1,
    0x3a04_825a,
    0x4d0e_4d2c,
    0x74a1_ad34,
    0x004a_52ba,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x9000_0000,
    0x8800_0000,
    0xcc00_0000,
    0x5a00_0000,
    0x7700_0000,
    0x4e80_0000,
    0x2340_0000,
    0xd4a0_0000,
    0xb450_0000,
    0xaa08_0000,
    0x8f34_0000,
    0x3a8a_0000,
    0xad57_0000,
    0xbd94_8000,
    0x1bfe_c000,
    0xeacd_2000,
    0x4141_1000,
    0x379c_8800,
    0x44ca_c400,
    0xf847_2a00,
    0xb016_1900,
    0x5808_0080,
    0xe434_08c0,
    0x060a_0fa0,
    0xa517_0e70,
    0xf5b4_8c68,
    0x37ee_cef4,
    0x80e5_28ea,
    0x2e65_1c35,
    0x3d3e_8648,
    0xf1b9_cec7,
    0x01f1_a4e2,
    0x3ddb_d890,
    0x9fd3_a1f9,
    0x9ce8_d18c,
    0x5c45_2aa4,
    0x1635_14b1,
    0x6d36_86c8,
    0x998d_c607,
    0xfdfb_ab42,
    0x7fcc_d6e0,
    0xace7_2d91,
    0x4446_1f78,
    0x5200_024e,
    0xfb00_0884,
    0xb480_0080,
    0xc440_08c0,
    0x1220_0fa0,
    0x5b10_0e70,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x7000_0000,
    0x6800_0000,
    0xb400_0000,
    0xb600_0000,
    0x0900_0000,
    0x4080_0000,
    0xb940_0000,
    0x3ea0_0000,
    0x5470_0000,
    0x3018_0000,
    0x482c_0000,
    0x2422_0000,
    0xae31_0000,
    0xd537_8000,
    0x42af_4000,
    0x067d_a000,
    0x770c_1000,
    0xadaf_8800,
    0xb7c3_4c00,
    0x22ff_ae00,
    0x404d_1700,
    0xd600_0e80,
    0xb900_0740,
    0xc880_0560,
    0x7d40_0790,
    0xe0a0_0288,
    0xe970_00d4,
    0xc698_088a,
    0xf86c_05d7,
    0x5a02_0709,
    0x4301_0f16,
    0xdb8f_81a8,
    0x5ef3_4fa4,
    0x1247_ae52,
    0x9111_10a8,
    0x5cba_0a25,
    0x5b5d_0193,
    0xf1b5_8989,
    0x75ee_4856,
    0x7dd2_24c8,
    0x79cf_5834,
    0x47d0_24da,
    0x8ace_5c7c,
    0x145f_acaf,
    0x103d_1344,
    0xd818_0000,
    0x3c2c_0000,
    0x7222_0000,
    0xd731_0000,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x1000_0000,
    0xb800_0000,
    0xe400_0000,
    0x8600_0000,
    0x8d00_0000,
    0x4b80_0000,
    0x8ec0_0000,
    0x79a0_0000,
    0x1df0_0000,
    0xab18_0000,
    0xf6b4_0000,
    0x8d56_0000,
    0xbb5d_0000,
    0xbe5f_8000,
    0x59f2_4000,
    0x1d1f_6000,
    0x33a2_f000,
    0x8ae7_8800,
    0xefb6_4c00,
    0x28d1_6e00,
    0x048b_f100,
    0xfe4e_0380,
    0x79e9_0240,
    0xed09_8660,
    0x9baf_49d0,
    0xd6c0_ef38,
    0x8d90_b6ac,
    0x23d8_e7fa,
    0xc224_b50f,
    0x3b0e_e809,
    0x8eb9_ba87,
    0x8971_62cf,
    0x2d7b_f92a,
    0x8b56_04b4,
    0xf65d_0164,
    0x15df_805c,
    0xc732_47f3,
    0xdcbf_6389,
    0xca52_f4c7,
    0xa7ff_8aaf,
    0x9402_41fa,
    0xee07_680c,
    0x3116_f588,
    0x39b1_81c6,
    0x3deb_4b2c,
    0x5b0e_ecb8,
    0x5eb9_b4ec,
    0xd171_619a,
    0xd97b_fcdf,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0xb000_0000,
    0x8800_0000,
    0xbc00_0000,
    0xba00_0000,
    0x6b00_0000,
    0xbb80_0000,
    0x2740_0000,
    0x30a0_0000,
    0x6cd0_0000,
    0xfff8_0000,
    0x505c_0000,
    0xa10a_0000,
    0x788b_0000,
    0xf0f8_8000,
    0x95db_c000,
    0x037d_6000,
    0x2eba_9000,
    0x59f2_8800,
    0x1150_c400,
    0x2985_e600,
    0x6061_5b00,
    0x690f_e080,
    0xa4aa_5fc0,
    0xfad7_65a0,
    0x76e1_99b0,
    0x04f2_0d38,
    0xb3d7_06b4,
    0x0272_862a,
    0xc610_c0bd,
    0xf125_e767,
    0x00b1_5a01,
    0xa4f7_e102,
    0x23f6_5181,
    0x5a5d_6642,
    0x422a_97e1,
    0x7f2a_8052,
    0x6d9c_c26b,
    0xce57_ea5f,
    0xd426_5cb5,
    0xf625_6728,
    0x3936_913c,
    0xdc80_8125,
    0xaec7_cde0,
    0xc0d7_6150,
    0x5de1_93ea,
    0xdf72_0c1d,
    0x2497_0b54,
    0xbad2_877a,
    0x16c0_c357,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x5000_0000,
    0x5800_0000,
    0x5400_0000,
    0x5600_0000,
    0x3300_0000,
    0x5480_0000,
    0xe4c0_0000,
    0x17a0_0000,
    0x1870_0000,
    0xcf78_0000,
    0x05c4_0000,
    0xbe1e_0000,
    0xaf29_0000,
    0x6e8f_8000,
    0x85db_c000,
    0x7e23_a000,
    0xcf05_7000,
    0x3e91_8800,
    0xddf2_cc00,
    0x2a2c_2600,
    0x991e_b500,
    0x0d92_2d80,
    0x8947_b940,
    0xcee5_ab60,
    0x8e98_7a30,
    0x15f8_0ec8,
    0x4604_020c,
    0xcb3e_079a,
    0x3099_02f7,
    0xbad7_895f,
    0x28af_c860,
    0x4ee5_aab3,
    0x4e98_7609,
    0x75f8_062d,
    0x1604_0bca,
    0x933e_078e,
    0x6499_02d9,
    0xecd7_8797,
    0x1baf_ca6c,
    0x1a65_ad29,
    0xaa58_74fe,
    0x6258_0f72,
    0x0e74_03aa,
    0x5c46_0d3d,
    0x615d_04d0,
    0x52c9_89ba,
    0xb486_cda6,
    0x74ea_2ca7,
    0x2f83_b327,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x3000_0000,
    0x7800_0000,
    0xdc00_0000,
    0xca00_0000,
    0x4300_0000,
    0xe380_0000,
    0x9c40_0000,
    0xb8a0_0000,
    0x73d0_0000,
    0x06c8_0000,
    0x1c7c_0000,
    0xf886_0000,
    0xd3c3_0000,
    0x36e8_8000,
    0x6445_c000,
    0x24bb_6000,
    0x19c6_5000,
    0x75ee_8800,
    0x87c6_c400,
    0xb8f3_ea00,
    0xa153_9300,
    0x061d_ef80,
    0x813c_99c0,
    0xa4bb_6ea0,
    0x59c6_5330,
    0xd5ee_8bb8,
    0xb7c6_c304,
    0xc0f3_eaaa,
    0x7d53_9dcd,
    0xcc1d_ed74,
    0xc23c_95f3,
    0x473b_649a,
    0xc586_50f5,
    0x6d4e_8330,
    0xc416_c3ba,
    0xc63b_e705,
    0x612f_90aa,
    0x349b_e6cc,
    0x11ff_96f7,
    0x71d3_ee30,
    0xa1c3_9d38,
    0x49f5_e644,
    0xddd0_9249,
    0xb3d5_699f,
    0xe6e9_535f,
    0x8c68_0a7c,
    0xb0ac_0c8d,
    0x77ce_0795,
    0x20ff_0ea2,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x9000_0000,
    0x0800_0000,
    0x5c00_0000,
    0x3a00_0000,
    0x2f00_0000,
    0xac80_0000,
    0x94c0_0000,
    0x5fa0_0000,
    0xc270_0000,
    0x4448_0000,
    0xa174_0000,
    0x1afa_0000,
    0xe68b_0000,
    0x43f0_8000,
    0x9732_c000,
    0xa8a4_a000,
    0x5add_7000,
    0x86aa_8800,
    0x73c9_cc00,
    0x0f1c_2a00,
    0xfc9b_b900,
    0x3cf4_2880,
    0x939f_b9c0,
    0xf046_21a0,
    0x3760_b7f0,
    0x37cc_a848,
    0xa119_798c,
    0x15b8_84da,
    0x1546_ce17,
    0x8cde_a7ac,
    0xcb96_7d6b,
    0x047a_05bd,
    0xc14b_0033,
    0x2ad0_86e9,
    0x7e82_cdff,
    0x17cc_a0d3,
    0xf119_7179,
    0xbdb8_87e4,
    0xd946_c8e7,
    0xbede_ab67,
    0xb896_7724,
    0x92fa_09c5,
    0x7a8b_0954,
    0xd9f0_84ce,
    0x2832_c6ba,
    0x0c24_a945,
    0x921d_7c94,
    0xe30a_8f6e,
    0x9eb9_c84a,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x7000_0000,
    0x2800_0000,
    0xc400_0000,
    0x3a00_0000,
    0x9b00_0000,
    0xa180_0000,
    0x9340_0000,
    0xa0a0_0000,
    0xf9f0_0000,
    0x2a58_0000,
    0x560c_0000,
    0xa502_0000,
    0xe095_0000,
    0xd9d8_8000,
    0xba7d_c000,
    0x0e07_e000,
    0x4904_9000,
    0x1e82_8800,
    0x78e4_cc00,
    0x80dd_6e00,
    0x3cec_5700,
    0x7add_ea80,
    0x47dd_9040,
    0xab78_05a0,
    0xfcbc_02b0,
    0xcffa_0698,
    0x3f69_0274,
    0x7e82_8b2a,
    0xc8e4_ca6f,
    0x48dd_6b1d,
    0x88ec_55e4,
    0x68dd_e242,
    0x18dd_94a2,
    0x30f8_0332,
    0xf4fc_0a58,
    0xceda_0495,
    0x55d9_04b9,
    0xf47a_8705,
    0x6718_c7d0,
    0xc787_6cc8,
    0x3e75_5c7d,
    0x1407_6eb7,
    0x4235_5dc8,
    0xe727_6dfd,
    0x0785_5a74,
    0xde5f_6f2a,
    0x6439_586c,
    0x6a25_6a1f,
    0x2310_5c66,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x7000_0000,
    0x2800_0000,
    0xa400_0000,
    0xfe00_0000,
    0x3d00_0000,
    0x8280_0000,
    0xb340_0000,
    0x05a0_0000,
    0x42f0_0000,
    0x4178_0000,
    0xa28c_0000,
    0x6362_0000,
    0x3d8d_0000,
    0xbed9_8000,
    0x3354_4000,
    0xc5ba_2000,
    0x22fe_1000,
    0x3163_8800,
    0x8aa5_4c00,
    0xc779_a600,
    0xc3ab_5700,
    0x83e2_2a80,
    0xb1c2_1640,
    0x76d9_81e0,
    0x2754_48d0,
    0x73ba_2ca8,
    0xcbfe_1674,
    0x65e3_853a,
    0xa0e5_41bf,
    0xbe59_a5df,
    0x0f1b_55cc,
    0x45ba_24c4,
    0xe2fe_1a83,
    0x5163_8e40,
    0xfaa5_45e2,
    0xef79_a2d2,
    0x67ab_5dab,
    0x7de2_2bf7,
    0x8cc2_19f8,
    0xf459_861e,
    0x9414_44ec,
    0x761a_2db7,
    0x890e_101a,
    0x249b_82cc,
    0x0269_4e47,
    0xdd3b_acc0,
    0x3296_5fa2,
    0xfb63_a532,
    0xd1aa_527b,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x7000_0000,
    0x8800_0000,
    0x5c00_0000,
    0xea00_0000,
    0x4300_0000,
    0x4080_0000,
    0xfc40_0000,
    0x9da0_0000,
    0x19f0_0000,
    0x9058_0000,
    0xdf8c_0000,
    0x96ea_0000,
    0xc2d3_0000,
    0xb4d4_8000,
    0xfdcd_c000,
    0x8e49_a000,
    0xba83_5000,
    0x8746_8800,
    0xe922_cc00,
    0x238f_2e00,
    0x2ce1_9700,
    0x99e9_a080,
    0x5073_59c0,
    0x3f9e_88a0,
    0xe6ee_cf30,
    0x4ac5_2288,
    0xe8c2_9d04,
    0x17e5_27fa,
    0xcd72_9c6f,
    0xfa1d_25ad,
    0x7b0e_9d0c,
    0x74af_2a3c,
    0x3a51_9cb6,
    0xbc91_abb2,
    0x464f_594b,
    0xc68c_8ca7,
    0xfd41_cf49,
    0x5223_afa5,
    0xb710_55c8,
    0x66b2_0b66,
    0xad5f_08e9,
    0x4a3e_8417,
    0x131e_cc83,
    0x589d_27c1,
    0x584e_97a0,
    0xa38f_23b2,
    0xece1_954b,
    0x79e9_a2a7,
    0x2073_5849,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0xd000_0000,
    0x5800_0000,
    0x9c00_0000,
    0x2a00_0000,
    0xcf00_0000,
    0x3d80_0000,
    0x4c40_0000,
    0x0ca0_0000,
    0x70d0_0000,
    0xb478_0000,
    0x6084_0000,
    0xb2de_0000,
    0x6f6b_0000,
    0xb318_8000,
    0x878a_c000,
    0xbb4e_e000,
    0x7d28_5000,
    0x4e9e_8800,
    0xebf5_c400,
    0x07d0_6600,
    0x85dd_9d00,
    0x3ece_ed80,
    0x3d68_5dc0,
    0x503e_8ca0,
    0x1825_c5f0,
    0xfc28_6058,
    0xfa19_9004,
    0x9730_efea,
    0xa193_563d,
    0x667e_043f,
    0xc3bb_073c,
    0x4d60_8bbf,
    0xf80e_c1ff,
    0x6c10_e79c,
    0xc203_5c4d,
    0xdb26_02a6,
    0xd3af_0b18,
    0x3566_81e7,
    0xd431_cef8,
    0xce2e_6ef5,
    0xc926_9f32,
    0x508e_667b,
    0x7af6_92b5,
    0xcb76_6c53,
    0xd532_942a,
    0x3a88_679c,
    0xd5c9_9c4d,
    0x26c8_e2a6,
    0xc157_5b18,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x9000_0000,
    0xe800_0000,
    0x0c00_0000,
    0xbe00_0000,
    0x2f00_0000,
    0x7380_0000,
    0x1240_0000,
    0x3a60_0000,
    0x1670_0000,
    0x5868_0000,
    0x0f4c_0000,
    0x98f6_0000,
    0x38b5_0000,
    0x93fa_8000,
    0xd901_4000,
    0xe0b5_a000,
    0xc7dd_3000,
    0x7335_a800,
    0x059d_3400,
    0xc155_ae00,
    0x8fed_3d00,
    0xcf3d_a080,
    0xa3a1_3dc0,
    0x9a4b_ab60,
    0xa654_3f30,
    0x4051_2c58,
    0x7b65_7e14,
    0xc2ec_8ffe,
    0xa584_4f73,
    0x7147_2278,
    0x97e0_7b87,
    0xbb1e_05f7,
    0xf9b9_050c,
    0x076c_8c48,
    0x44c4_455c,
    0x0ea7_2123,
    0x20d0_7211,
    0xfc96_0c48,
    0xd1c5_055c,
    0x3012_8123,
    0x580d_4211,
    0x1423_a448,
    0xca18_315c,
    0x7527_2f23,
    0xee90_7f11,
    0xf0f6_04c8,
    0x74b5_0c9c,
    0x4dfa_8443,
    0x6601_4021,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x9000_0000,
    0x0800_0000,
    0x7400_0000,
    0xea00_0000,
    0x1500_0000,
    0xdc80_0000,
    0x40c0_0000,
    0xe8e0_0000,
    0xccd0_0000,
    0x0ed8_0000,
    0xfffc_0000,
    0xc17e_0000,
    0xe0a3_0000,
    0x3ef9_8000,
    0xa7ec_c000,
    0x9d63_e000,
    0xee9f_d000,
    0xc9e3_e800,
    0x1a5f_dc00,
    0xeb03_ea00,
    0x538f_d500,
    0x315b_ea80,
    0x98b3_d240,
    0xf2c5_e420,
    0xa1c0_d310,
    0x1e64_69e8,
    0xb910_171c,
    0xaa99_8766,
    0x7bfc_cbd1,
    0x535b_ef8b,
    0x39b3_d82e,
    0xe445_e99c,
    0x6400_d324,
    0x2204_68f3,
    0x4100_171a,
    0xa6a1_8f05,
    0x5dd0_cfe3,
    0x407d_e8f3,
    0x662c_d71a,
    0xf322_6f05,
    0xef9f_1fe3,
    0x8f46_00f3,
    0xf78f_0b1a,
    0x335f_8505,
    0x49b3_cae3,
    0x5c64_6a73,
    0x8810_195a,
    0xb419_8125,
    0xca3c_c9f3,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0xd000_0000,
    0xa800_0000,
    0x9c00_0000,
    0xfa00_0000,
    0xd300_0000,
    0xdb80_0000,
    0xb4c0_0000,
    0x88e0_0000,
    0x62d0_0000,
    0x39d8_0000,
    0xae6c_0000,
    0x4886_0000,
    0x8f41_0000,
    0xcc2f_8000,
    0x9203_4000,
    0x6f39_a000,
    0xf182_9000,
    0xcfd9_a800,
    0xcf52_9c00,
    0x2c01_aa00,
    0x623e_9100,
    0x1707_a080,
    0xc5bf_98c0,
    0xa9c8_2f20,
    0xe66c_d5f0,
    0x24a9_8298,
    0x0d42_4ebc,
    0x2b16_2216,
    0x2f81_d491,
    0xf2e0_0b8b,
    0x71d0_0f77,
    0xc258_0f83,
    0xcaac_0f43,
    0x6866_0461,
    0x7191_0f93,
    0x0ff7_8a0a,
    0xef6f_4f37,
    0xfc3f_ac61,
    0xca03_9393,
    0x8b16_200a,
    0x3f81_de37,
    0x7ae0_0ce1,
    0x3dd0_0b53,
    0x9058_0f2a,
    0x85ac_0bc7,
    0x49e6_0e79,
    0x1651_05ef,
    0x5c97_8d3c,
    0x397f_4f56,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x3000_0000,
    0x8800_0000,
    0xfc00_0000,
    0xe600_0000,
    0x5900_0000,
    0x1880_0000,
    0xc140_0000,
    0x9560_0000,
    0x1f70_0000,
    0xf848_0000,
    0xfdc4_0000,
    0xb626_0000,
    0xa139_0000,
    0x8c90_8000,
    0xeb7e_c000,
    0xa254_e000,
    0xa2d6_b000,
    0xc7b4_e800,
    0xf0e6_b400,
    0x249c_e600,
    0x8752_b700,
    0x1c72_ee80,
    0xbfef_b8c0,
    0x4d24_60e0,
    0x7298_7d50,
    0x1648_0168,
    0x18c4_0144,
    0xa8a6_003e,
    0x0979_04b3,
    0x8970_81ba,
    0xc94e_c86f,
    0x297c_e258,
    0x1962_bdbc,
    0x915a_ecf1,
    0x6d5b_b29b,
    0x8b4a_695c,
    0xd265_77a2,
    0xcafe_84f1,
    0x0b83_c69b,
    0x9ee2_6f5c,
    0x8191_70a2,
    0x79f0_8271,
    0x840e_ca5b,
    0x321c_e9bc,
    0x9312_baf2,
    0x1f92_ed99,
    0xf4df_b3df,
    0x568c_6962,
    0xf46c_7311,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0xd000_0000,
    0x5800_0000,
    0x8400_0000,
    0xca00_0000,
    0x6b00_0000,
    0x1f80_0000,
    0x1240_0000,
    0x9860_0000,
    0xd350_0000,
    0xfce8_0000,
    0x669c_0000,
    0x22ea_0000,
    0xbf9b_0000,
    0xe241_8000,
    0xf047_4000,
    0xdf6a_a000,
    0xead5_3000,
    0x4382_a800,
    0x9c49_3c00,
    0xd968_a600,
    0x77d2_3100,
    0xa929_2380,
    0x6895_7940,
    0xa3c3_8f20,
    0xfb00_4ff0,
    0x67a1_26d8,
    0xa659_72d4,
    0xda41_895e,
    0x6447_4ee1,
    0xad6a_a510,
    0xd5d5_31c8,
    0xce02_a81e,
    0x6109_35c1,
    0x9488_a0e2,
    0xddc2_3811,
    0xd221_2c4a,
    0xcf19_745d,
    0xe5a1_8362,
    0xf157_4151,
    0x5be2_a36a,
    0x8f19_3bad,
    0xc580_a5ba,
    0xc14e_3385,
    0xd3c3_2a34,
    0x530e_754c,
    0x8b82_00aa,
    0x6047_024d,
    0xa74b_822a,
    0x5ecc_408d,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x5000_0000,
    0x6800_0000,
    0xe400_0000,
    0x7e00_0000,
    0x8700_0000,
    0xda80_0000,
    0x2c40_0000,
    0x6260_0000,
    0x3d70_0000,
    0x9bd8_0000,
    0x158c_0000,
    0x02f6_0000,
    0xf83f_0000,
    0x6c38_8000,
    0x6a35_4000,
    0xc125_e000,
    0xd199_f000,
    0x6cfd_e800,
    0xb715_f400,
    0x028b_e200,
    0x506a_f100,
    0xc053_6480,
    0x486f_bf40,
    0x5c4e_8360,
    0x1a4a_4730,
    0x117d_66c8,
    0x51dc_b1f4,
    0x8480_02ee,
    0xbb40_0323,
    0x70e0_0fd3,
    0xa530_0d3b,
    0xefb8_049c,
    0x4bfc_0188,
    0x3dae_0e97,
    0x46f3_03df,
    0xd62e_8eeb,
    0x833a_47a5,
    0x54a5_6a17,
    0x9350_bc9f,
    0x34f6_0d8b,
    0x8b3f_0095,
    0x00b8_8cdf,
    0x7575_4d6b,
    0x6fc5_ef65,
    0xa3a9_f3b6,
    0x31c5_eb0c,
    0x34a9_f450,
    0x2345_e9f9,
    0xace9_f33e,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x7000_0000,
    0xd800_0000,
    0xfc00_0000,
    0xba00_0000,
    0x2f00_0000,
    0xd080_0000,
    0x78c0_0000,
    0xaae0_0000,
    0x81f0_0000,
    0x0768_0000,
    0x42b4_0000,
    0x33e2_0000,
    0x5c6d_0000,
    0x1c0b_8000,
    0x8a24_4000,
    0x972a_6000,
    0x5ca5_5000,
    0x1ac2_6800,
    0x79d1_5400,
    0xeb40_6e00,
    0x508c_5300,
    0x38c3_e380,
    0xcaec_1cc0,
    0xf1e3_8820,
    0xdf50_4e30,
    0xbea8_6d28,
    0x89f8_5dbc,
    0x7341_e986,
    0xccb1_16a3,
    0xf2e0_0270,
    0x3df0_0a48,
    0xdd68_0f6e,
    0x1db4_06be,
    0x3b62_0e06,
    0xd8ad_0c60,
    0x0ceb_8d52,
    0x24d4_49f9,
    0x40c2_6d86,
    0x66d1_50a0,
    0x83c0_6572,
    0xa44c_57c9,
    0xf023_e8ae,
    0x981c_191c,
    0x9c0b_82f4,
    0xca24_426a,
    0xf72a_615e,
    0x2ca5_5b94,
    0xc2c2_6bba,
    0x85d1_59e4,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x1000_0000,
    0xb800_0000,
    0x7400_0000,
    0x0200_0000,
    0xbf00_0000,
    0x1880_0000,
    0x05c0_0000,
    0x5be0_0000,
    0x6af0_0000,
    0xdb68_0000,
    0x6b2c_0000,
    0x2aa2_0000,
    0x72ef_0000,
    0x9f57_8000,
    0xa12c_4000,
    0x49bc_6000,
    0xa474_1000,
    0x53b4_6800,
    0x5f68_1400,
    0x811e_6e00,
    0x399b_1500,
    0x0c63_e580,
    0x9f84_5240,
    0x2942_05a0,
    0x3c1f_09b0,
    0x9e3f_8c28,
    0x1100_4dec,
    0xc19e_6f96,
    0x185b_1a43,
    0x8d83_e1a0,
    0x2e74_5fb1,
    0x50aa_052a,
    0x99f3_026f,
    0xf5fd_8ed7,
    0xb3df_4b61,
    0xc6c1_e9d2,
    0xbd6b_5d79,
    0x6e15_8357,
    0xf933_4d21,
    0x6d83_e272,
    0x7e74_51c9,
    0x88aa_02ff,
    0xfdf3_068d,
    0x4ffd_8644,
    0x78df_473a,
    0xdc41_e2f7,
    0x07ab_5290,
    0x2d75_8758,
    0x9603_43a6,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0xf000_0000,
    0xc800_0000,
    0xdc00_0000,
    0x1200_0000,
    0x6500_0000,
    0x6d80_0000,
    0x97c0_0000,
    0xc1e0_0000,
    0x72f0_0000,
    0xec68_0000,
    0x8514_0000,
    0xdd86_0000,
    0x3fe1_0000,
    0xeddd_8000,
    0xa8e8_c000,
    0x5559_a000,
    0xfab7_5000,
    0x2f51_a800,
    0x9393_5400,
    0x08df_ae00,
    0x8556_5b00,
    0xa28c_2280,
    0xcb7b_96c0,
    0x9586_03a0,
    0xa3e1_0090,
    0x9fdd_8d78,
    0x3de8_cdec,
    0xf0d9_a766,
    0xb177_55c3,
    0xfcb1_ad20,
    0x8463_5452,
    0x8937_a7d8,
    0x9782_5efc,
    0xbeea_235d,
    0x866a_90ce,
    0x9433_8b36,
    0x8e1d_ce1a,
    0x1702_29dd,
    0xf8be_920e,
    0x3255_8696,
    0x8a0c_c58a,
    0xa137_ae25,
    0xfb82_5d22,
    0x04ea_2c50,
    0xcf6a_9bd9,
    0x23b3_84fd,
    0xa0dd_c65c,
    0xa962_214e,
    0x788e_9b76,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x7000_0000,
    0x3800_0000,
    0x4c00_0000,
    0x6600_0000,
    0xfb00_0000,
    0xc480_0000,
    0x4cc0_0000,
    0x47e0_0000,
    0x7b50_0000,
    0x5b98_0000,
    0x0a64_0000,
    0xb23a_0000,
    0x6131_0000,
    0x418c_8000,
    0x4f68_4000,
    0x91b8_6000,
    0xc77f_d000,
    0xc582_6800,
    0x9d4e_dc00,
    0x608e_ea00,
    0xeee6_9b00,
    0x8ed6_8980,
    0x1ec9_4fc0,
    0x76cc_e7e0,
    0x72e3_9c70,
    0x60f8_01a8,
    0xb1f4_03bc,
    0xe842_0c56,
    0x9b05_0bc9,
    0x54ae_8e0f,
    0x24fd_471f,
    0x43ee_ec84,
    0x6976_9eb0,
    0x8aae_8eca,
    0x53fd_4a8f,
    0xc16e_e05e,
    0xaeb6_9e27,
    0x31ce_8f62,
    0x286d_4933,
    0xbb16_ec08,
    0x2482_95ee,
    0x1cec_816d,
    0x0ff8_4e2c,
    0x0f40_608c,
    0x718b_db5e,
    0x9740_67a7,
    0x8d8b_d8a3,
    0xe940_6ad2,
    0x4a8b_de79,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x3000_0000,
    0xc800_0000,
    0xdc00_0000,
    0x2200_0000,
    0x4b00_0000,
    0xa880_0000,
    0x00c0_0000,
    0xbfe0_0000,
    0x1950_0000,
    0xd888_0000,
    0x68e4_0000,
    0x33c6_0000,
    0xc359_0000,
    0x8785_8000,
    0x3e49_4000,
    0x5a36_6000,
    0x9f01_d000,
    0x3690_6800,
    0x59c8_dc00,
    0x947d_ee00,
    0x6d35_9f00,
    0x4585_8280,
    0x8549_42c0,
    0x5ab6_68a0,
    0x73c1_da70,
    0x6370_6c28,
    0xd798_d57c,
    0xc675_ed56,
    0x4e11_9a29,
    0x6123_8e7e,
    0x5f80_45d7,
    0xba5b_edea,
    0x3c3c_915e,
    0xd208_0ae4,
    0xe324_0c23,
    0x44a6_0bb1,
    0xeac9_0008,
    0x28ed_8ecc,
    0x93fd_455f,
    0x9378_68e7,
    0x7fbc_d521,
    0x2a53_ea32,
    0xa418_9e48,
    0xf62e_03ad,
    0xd52d_010f,
    0xf1ab_8e7e,
    0x2b64_45d7,
    0xcb9d_edea,
    0x8465_915e,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xd000_0000,
    0xc800_0000,
    0x4400_0000,
    0x8200_0000,
    0x2d00_0000,
    0xef80_0000,
    0x6740_0000,
    0x4860_0000,
    0xcaf0_0000,
    0x6238_0000,
    0x9d2c_0000,
    0xd78e_0000,
    0x3b57_0000,
    0x4663_8000,
    0x21ca_c000,
    0x22a8_2000,
    0x38c5_7000,
    0x171e_2800,
    0xdebe_7400,
    0xa6f3_aa00,
    0x1423_b900,
    0x0a38_0680,
    0x492c_0d40,
    0xbd8e_06a0,
    0x8257_0b90,
    0xe3e3_8a58,
    0x2f8a_c0e4,
    0x0748_225e,
    0xb875_780b,
    0xd2c6_245d,
    0xee22_7709,
    0x5b25_a5dd,
    0x78a8_bfc8,
    0xf9ed_89bd,
    0xce9d_c53b,
    0x0ecb_ad94,
    0xa00f_b9b5,
    0x9036_0565,
    0xe83b_089f,
    0x940d_896a,
    0x4a2d_ca2e,
    0x6913_ab60,
    0x6d93_bf72,
    0x4a60_0ee9,
    0xa7f0_0ded,
    0xadb8_0680,
    0x2a6c_0d40,
    0x57ee_06a0,
    0xb5a7_0b90,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x7000_0000,
    0xd800_0000,
    0xc400_0000,
    0xc600_0000,
    0xa100_0000,
    0x6a80_0000,
    0xb5c0_0000,
    0xcae0_0000,
    0x6570_0000,
    0xec08_0000,
    0x9a34_0000,
    0x4312_0000,
    0x7d9b_0000,
    0xa676_8000,
    0xd188_c000,
    0xdc53_6000,
    0xe287_9000,
    0x79c9_6800,
    0x80e8_9400,
    0x6e4d_e600,
    0xfd8b_5300,
    0xe660_0b80,
    0x31b0_0f40,
    0xac68_0fe0,
    0x3a84_0150,
    0xbdfa_0748,
    0x46df_0d0c,
    0xcf6c_8666,
    0x9727_c71b,
    0x53b7_e4c6,
    0xfb54_54a8,
    0xc90c_8e5f,
    0xd697_cc2d,
    0x27df_ee96,
    0x05d0_5462,
    0xb2f6_8613,
    0x3148_cca9,
    0x8233_625e,
    0x2737_962e,
    0x2ba1_6f95,
    0xaf6c_9ae2,
    0xa737_e9d0,
    0x6b94_5b8a,
    0x4f6c_81ac,
    0xd727_c2d4,
    0xb3b7_e800,
    0x8b54_5400,
    0x110c_8600,
    0x1297_c300,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x1000_0000,
    0xb800_0000,
    0x1400_0000,
    0x5600_0000,
    0x2900_0000,
    0x7d80_0000,
    0xd640_0000,
    0xe160_0000,
    0x69d0_0000,
    0x8838_0000,
    0x7c1c_0000,
    0x5a02_0000,
    0x7b2f_0000,
    0xbabe_8000,
    0x96da_c000,
    0x1ca0_a000,
    0x77d0_b000,
    0x7d1a_a800,
    0x4ba3_bc00,
    0x4f46_2200,
    0x34c6_7d00,
    0x1380_0980,
    0x2b40_0c40,
    0x6ae0_04e0,
    0x8690_02d0,
    0xacd8_0938,
    0xd78c_0eb4,
    0x655a_0cae,
    0x47e3_0969,
    0x1504_814d,
    0x47a9_cc38,
    0x1d7c_2335,
    0xf3f5_76ee,
    0x533c_8e88,
    0xd6b5_c51e,
    0x74fe_25c1,
    0x739a_78a2,
    0x9b62_0e30,
    0xc2ff_07ea,
    0x2a86_8d8f,
    0xeec6_c31b,
    0xa8a2_ae45,
    0x31ff_b966,
    0xec24_2014,
    0x2239_719c,
    0xcf06_8000,
    0xfc86_c000,
    0x07c2_a000,
    0x752f_b000,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x7000_0000,
    0x5800_0000,
    0xf400_0000,
    0x4e00_0000,
    0x5700_0000,
    0xbf80_0000,
    0xd0c0_0000,
    0xf5e0_0000,
    0x4f50_0000,
    0xf508_0000,
    0xf2b4_0000,
    0x6652_0000,
    0xe597_0000,
    0x79c8_8000,
    0x2543_4000,
    0xa425_a000,
    0xc630_1000,
    0xeb1f_a800,
    0x2d83_1c00,
    0x65ed_2e00,
    0xa773_5b00,
    0x393a_0b80,
    0x38b3_0440,
    0x2772_8760,
    0xf930_4d30,
    0x58b7_2a98,
    0x5750_573c,
    0xa120_8846,
    0xaca7_4089,
    0x197f_adf6,
    0xf613_11d2,
    0x1305_2beb,
    0xc997_56c7,
    0x03e0_0449,
    0x5c50_0d56,
    0x3c88_03c3,
    0xf174_0522,
    0x3a32_0d51,
    0xd907_022a,
    0x88a0_82e5,
    0x1f67_439b,
    0x7d1f_a9bf,
    0x4e83_1c84,
    0xf46d_2828,
    0x50b3_53e5,
    0x2b5a_0918,
    0x5323_0f7c,
    0x699a_8126,
    0x13d4_46b9,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0xf000_0000,
    0x6800_0000,
    0x1c00_0000,
    0x3a00_0000,
    0x0700_0000,
    0xfc80_0000,
    0xe6c0_0000,
    0xd260_0000,
    0xf8b0_0000,
    0xe8c8_0000,
    0x9344_0000,
    0xc916_0000,
    0x9d95_0000,
    0x476d_8000,
    0x3f09_4000,
    0x58b3_e000,
    0x38d7_1000,
    0x6b5e_6800,
    0x4d1e_5400,
    0xd38d_8e00,
    0x6679_4b00,
    0xfe9b_e080,
    0x45e3_1ec0,
    0xf0e0_6d20,
    0xa77f_55b0,
    0x8f3e_0268,
    0x50a1_051c,
    0xd4d3_826e,
    0x3968_4f27,
    0x5600_668a,
    0x150f_570f,
    0x8796_0675,
    0xd055_0af1,
    0x5b8d_8c09,
    0xca79_44ce,
    0xcc9b_e4d7,
    0xaee3_1702,
    0x5e60_6a83,
    0x5abf_53c1,
    0x9bde_02a2,
    0x49d1_0df3,
    0x12fb_8e8a,
    0xb45c_430f,
    0xa5be_6875,
    0xe36e_51f1,
    0xe125_8489,
    0xe18d_4e0e,
    0x8d45_e7f7,
    0x5032_19b2,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x1000_0000,
    0x2800_0000,
    0x7c00_0000,
    0x5e00_0000,
    0x9d00_0000,
    0xde80_0000,
    0x7d40_0000,
    0xfbe0_0000,
    0x0290_0000,
    0x1348_0000,
    0xbedc_0000,
    0x981e_0000,
    0x641d_0000,
    0xfa34_8000,
    0x873e_c000,
    0x4985_e000,
    0x1ce0_7000,
    0x9b31_6800,
    0xc79e_bc00,
    0x49d4_8600,
    0x29ae_cd00,
    0xcccd_ec80,
    0x533c_76c0,
    0xabaf_6f60,
    0x3fc3_b210,
    0xc880_0e08,
    0x4c40_0304,
    0xb360_0ed6,
    0x8ed0_013d,
    0x4028_09ea,
    0x200c_05d4,
    0xf036_00bd,
    0x3811_03a8,
    0x5402_8474,
    0x222f_c9cf,
    0xc307_65b1,
    0x438f_b279,
    0xa3d6_0d9e,
    0x8681_0c1b,
    0xf94a_850c,
    0x11f3_c1d1,
    0xad99_61ea,
    0x26d2_b9d4,
    0xfc02_86bd,
    0x9e2f_cea8,
    0x7d07_68f4,
    0xce8f_bf0f,
    0x5556_0ad1,
    0x87c1_0069,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x7000_0000,
    0x0800_0000,
    0xac00_0000,
    0x1200_0000,
    0x9300_0000,
    0x3980_0000,
    0x9740_0000,
    0x82e0_0000,
    0x47b0_0000,
    0x3648_0000,
    0x3864_0000,
    0x916e_0000,
    0x87c1_0000,
    0x431b_8000,
    0x61b6_4000,
    0x2347_a000,
    0x44fa_3000,
    0x62bc_2800,
    0x22fc_7400,
    0x17b3_8e00,
    0x2e62_4300,
    0xec61_a680,
    0x275f_3dc0,
    0xaac9_a9a0,
    0xfb8b_37f0,
    0x5c6f_acb8,
    0x0f6e_3344,
    0x16fa_2536,
    0x91a9_74cf,
    0x6b6e_04ea,
    0x88c1_070d,
    0x009b_8e4a,
    0xb9f6_467e,
    0x8227_a731,
    0xab0a_3098,
    0xfd94_27f7,
    0x5968_71ed,
    0x0bf5_8bdb,
    0x4137_4395,
    0x8abc_27bd,
    0xbefc_7493,
    0x6db3_8a6a,
    0x6162_4ecd,
    0xcfe1_a9ea,
    0x8f1f_328e,
    0x03a9_ad09,
    0xb87b_3e1c,
    0xd147_ab61,
    0xe7fa_32d2,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0xd000_0000,
    0x2800_0000,
    0x0400_0000,
    0xee00_0000,
    0xd300_0000,
    0xe380_0000,
    0xfa40_0000,
    0x65e0_0000,
    0x9d90_0000,
    0xa168_0000,
    0x324c_0000,
    0x71ee_0000,
    0x3b83_0000,
    0xa666_8000,
    0x17c9_4000,
    0x5ca3_2000,
    0x53de_f000,
    0x12a5_a800,
    0x30c7_bc00,
    0x090e_8e00,
    0xe685_4100,
    0x86cd_2480,
    0x461d_fd40,
    0x1723_2460,
    0x6d9e_f170,
    0xf945_aed8,
    0xae57_b394,
    0x63e6_84e6,
    0x2a89_473d,
    0x7cc3_2628,
    0x330e_fa8d,
    0xf3ad_a750,
    0xb25b_be48,
    0xb1e8_85fe,
    0x5b9a_4889,
    0x764d_a95c,
    0x3fcb_bc58,
    0x5880_8bd6,
    0xbdd6_4e04,
    0xc1a3_a00c,
    0xd348_b310,
    0xf366_02a8,
    0x835f_07cd,
    0x1b60_8330,
    0xe746_4f38,
    0x254b_ab26,
    0x1c44_bb1d,
    0xc2e8_0dba,
    0x080c_0b65,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x5000_0000,
    0x6800_0000,
    0x4c00_0000,
    0x0600_0000,
    0xf300_0000,
    0x2580_0000,
    0xd2c0_0000,
    0x5160_0000,
    0x00b0_0000,
    0x2c48_0000,
    0x8a2c_0000,
    0xd51e_0000,
    0xe691_0000,
    0xcf46_8000,
    0xa787_4000,
    0x1bf6_a000,
    0xd9c4_5000,
    0x70f8_2800,
    0xa86f_1400,
    0xb010_8e00,
    0x783a_4100,
    0x442e_2080,
    0x1a12_11c0,
    0x9d28_0ee0,
    0x9a9c_0ff0,
    0xf156_0438,
    0x70bd_071c,
    0x7458_81ce,
    0xfe16_49e7,
    0xf730_27b2,
    0x5f83_1799,
    0x1fee_85cd,
    0xa3db_4fe7,
    0xbdc0_a2b3,
    0x5ac9_511a,
    0x0d68_a10f,
    0x0e95_5f86,
    0xc35e_a581,
    0xc198_5743,
    0xb8ce_2a22,
    0x9462_1f91,
    0xee00_030a,
    0xff00_0145,
    0x4380_0ae3,
    0x71c0_09f0,
    0x1ce0_0139,
    0x9e70_019f,
    0x7b28_050c,
    0x799c_0986,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x7000_0000,
    0x0800_0000,
    0x4c00_0000,
    0xb600_0000,
    0xf900_0000,
    0xb280_0000,
    0x9340_0000,
    0x87e0_0000,
    0x5590_0000,
    0xc4c8_0000,
    0x8804_0000,
    0x8c2e_0000,
    0x5629_0000,
    0x8922_8000,
    0xba91_c000,
    0xdf41_e000,
    0x31c5_f000,
    0xacab_6800,
    0x7650_3c00,
    0x1b44_8600,
    0x0bfc_cb00,
    0x03ad_6e80,
    0x4ded_33c0,
    0x3280_03e0,
    0x5340_0750,
    0x67e0_0e48,
    0x2590_01a4,
    0xccc8_03d6,
    0xc404_08ad,
    0x3a2e_0f52,
    0xaf29_0249,
    0x3ba2_8fa6,
    0x29d1_c4d6,
    0x58a1_e82e,
    0x6455_fb92,
    0x6863_612a,
    0xfe54_3c35,
    0x976a_89fc,
    0x5dd5_ca1b,
    0x8a8f_ed6c,
    0xf77c_ffb3,
    0xedc1_ef9a,
    0x6285_f02d,
    0xcb4b_6f90,
    0x53c0_3b2b,
    0xd78c_8134,
    0xcff8_c47f,
    0x3983_6b5a,
    0xe2c4_3b4e,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x9000_0000,
    0x0800_0000,
    0x6400_0000,
    0xda00_0000,
    0xc500_0000,
    0x8b80_0000,
    0x66c0_0000,
    0x9f60_0000,
    0x88b0_0000,
    0x6e58_0000,
    0xb10c_0000,
    0x19b6_0000,
    0xe7d3_0000,
    0x5eeb_8000,
    0x2375_c000,
    0x1eb2_a000,
    0x8571_d000,
    0x2d81_2800,
    0x55c8_1400,
    0x4fe5_8a00,
    0xeada_cd00,
    0xd157_2280,
    0x2fab_1f40,
    0xdcd6_0520,
    0xea63_0e10,
    0x9b33_8718,
    0x64b9_c33c,
    0x9064_a1ce,
    0x8e12_d8a7,
    0xc732_aab3,
    0x02b1_dbcb,
    0xc361_25c6,
    0xeeb8_1e01,
    0x3d5d_8703,
    0xd1a6_cf81,
    0xe3d9_2dc0,
    0x34c4_1260,
    0x7e53_8f30,
    0xf909_cb0a,
    0x5dbc_ad26,
    0xadde_d271,
    0x93e4_a72b,
    0xccd2_d3b7,
    0xa252_ab28,
    0xdf01_d5b6,
    0x2eb9_2028,
    0x5d74_1c36,
    0x618b_86e8,
    0x7bc5_c7d6,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0xf000_0000,
    0xb800_0000,
    0xe400_0000,
    0x7600_0000,
    0x8700_0000,
    0x5f80_0000,
    0x12c0_0000,
    0xf360_0000,
    0xfa90_0000,
    0xe478_0000,
    0x0d14_0000,
    0x7aa2_0000,
    0x245f_0000,
    0x2d38_8000,
    0x8aa2_4000,
    0x9c47_2000,
    0xc912_d000,
    0xfc87_a800,
    0x1b64_9c00,
    0x9682_8a00,
    0xee79_4300,
    0xe825_a980,
    0x6c3b_9140,
    0x0a3a_04e0,
    0xe51b_0a30,
    0x1682_8098,
    0x2e79_465c,
    0xc825_a14e,
    0x9c3b_90c5,
    0xb23a_0e11,
    0x011b_0b08,
    0x6082_8e15,
    0xa979_4cb8,
    0x97a5_a1cf,
    0x8efb_9b06,
    0x415a_0a30,
    0xfb8b_009a,
    0x84fa_865e,
    0xa46d_414e,
    0xed07_a0c5,
    0xaaa4_9612,
    0x6c62_8f09,
    0x7129_4014,
    0x18bd_a1bb,
    0x6d7f_954d,
    0x1180_06c6,
    0xb1c0_0712,
    0xfae0_018b,
    0x9f50_06d7,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0xf000_0000,
    0xe800_0000,
    0x5400_0000,
    0x4e00_0000,
    0xfd00_0000,
    0xbf80_0000,
    0x5740_0000,
    0x32e0_0000,
    0x36b0_0000,
    0x16f8_0000,
    0xd0b4_0000,
    0x1fd6_0000,
    0xd127_0000,
    0x5daa_8000,
    0x087e_c000,
    0x7259_a000,
    0xd163_b000,
    0x2beb_2800,
    0x8f19_7400,
    0x189c_8200,
    0xfbe9_cb00,
    0xd70b_2480,
    0x04a9_7a40,
    0x11e4_8260,
    0x8c1d_ce90,
    0x123d_2518,
    0xb73e_75a4,
    0x14b6_0e56,
    0xa9d7_075f,
    0xc032_8ca1,
    0xe03a_ceb0,
    0x5017_a5ea,
    0x1800_b02d,
    0xbc0f_abe9,
    0x1a04_b52e,
    0xb321_aa68,
    0x4297_beee,
    0xe8dd_2bc8,
    0x658e_75de,
    0x044e_0fe2,
    0x2063_0b53,
    0xc664_81b9,
    0xcf5d_cf14,
    0xcedd_29bc,
    0x8c8e_7c72,
    0x55ce_03c8,
    0x7a23_01de,
    0xa304_8de2,
    0xfaad_c053,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x5000_0000,
    0x9800_0000,
    0xb400_0000,
    0x7a00_0000,
    0x9700_0000,
    0x6380_0000,
    0xf540_0000,
    0x70e0_0000,
    0xd490_0000,
    0x66e8_0000,
    0x2dac_0000,
    0xd842_0000,
    0xe473_0000,
    0x1277_8000,
    0x7b55_4000,
    0x3dcc_2000,
    0x1001_3000,
    0x3833_a800,
    0x8428_7c00,
    0xb235_8e00,
    0xbb26_4900,
    0xadbb_af80,
    0x1854_7e40,
    0x847f_8620,
    0x4269_4e30,
    0xe366_2798,
    0x89de_3324,
    0x6a06_20b6,
    0xaf0e_355d,
    0xe78e_28c0,
    0x4772_3fe3,
    0xcbc4_2a52,
    0x793d_3189,
    0x7e99_ab8d,
    0xa9f7_7f8b,
    0x9a00_028d,
    0x0700_000b,
    0x9b80_04cd,
    0x1140_0228,
    0x92e0_00ff,
    0xf790_06b2,
    0x7f68_0f58,
    0x4fec_0cc7,
    0xcb22_0ae4,
    0xc5a3_04d4,
    0x047f_834d,
    0x8269_4068,
    0x8366_28df,
    0xd9de_3182,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0xd000_0000,
    0x4800_0000,
    0xf400_0000,
    0xd600_0000,
    0x8d00_0000,
    0x4680_0000,
    0x0040_0000,
    0x3be0_0000,
    0x2510_0000,
    0x0298_0000,
    0xee5c_0000,
    0xdac6_0000,
    0x09bf_0000,
    0xadd0_8000,
    0xc82a_c000,
    0x3424_e000,
    0x7616_b000,
    0x5d32_6800,
    0x0e83_7c00,
    0xf446_0200,
    0xedff_0100,
    0xa830_8e80,
    0x443a_c240,
    0xee3c_e9e0,
    0xe10a_b790,
    0x2c94_6108,
    0xaf6c_74d4,
    0x266e_85d6,
    0xeed9_c355,
    0x7faa_6d17,
    0xf0df_7ef4,
    0xc680_0c65,
    0xc040_05ee,
    0x9be0_0479,
    0xf510_09cd,
    0x4a98_0ac9,
    0x1a5c_06f6,
    0x0cc6_0866,
    0x84bf_03ed,
    0xeb50_837a,
    0xc86a_c04d,
    0x0fc4_e108,
    0x5306_b4d4,
    0x5faa_65d6,
    0xe0df_7355,
    0x2e80_0517,
    0xe440_02f4,
    0x05e0_0e65,
    0x8c10_04ee,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0xb000_0000,
    0xd800_0000,
    0x6400_0000,
    0xaa00_0000,
    0x6900_0000,
    0x9a80_0000,
    0xf4c0_0000,
    0x9f60_0000,
    0x7510_0000,
    0x24b8_0000,
    0xcfe4_0000,
    0xb8fa_0000,
    0x697f_0000,
    0x422b_8000,
    0x1524_c000,
    0x74ae_e000,
    0x87d8_9000,
    0xb4ff_6800,
    0x7f43_5c00,
    0xe51a_0a00,
    0x4caf_0700,
    0x73f3_8f80,
    0x76d0_cd40,
    0xaa6c_e720,
    0xb183_90d0,
    0x7b4e_eb08,
    0x1f08_95dc,
    0x6da7_6a5e,
    0xe577_5f1d,
    0x9438_0c3d,
    0x9224_0aef,
    0x9d1a_0ce4,
    0x58af_01b9,
    0x21f3_8125,
    0xcbd0_c859,
    0x42ec_e996,
    0x4843_97a2,
    0xd4ae_e610,
    0xf7d8_976a,
    0x4cff_6f2c,
    0xab43_5906,
    0x971a_0308,
    0x41af_09dc,
    0x4373_805e,
    0xeb10_c81d,
    0xaf8c_ebbd,
    0x3053_9baf,
    0xc096_e1c4,
    0xa5fc_9669,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0xb000_0000,
    0x9800_0000,
    0x1c00_0000,
    0xe600_0000,
    0xdf00_0000,
    0xae80_0000,
    0x0ac0_0000,
    0x7f60_0000,
    0xe110_0000,
    0xcda8_0000,
    0x9274_0000,
    0x82aa_0000,
    0xb4d1_0000,
    0xdc46_8000,
    0x19b2_4000,
    0x8052_6000,
    0x5fba_1000,
    0x8f5e_e800,
    0xd909_5c00,
    0x0182_0e00,
    0x5c65_0700,
    0xd98c_8f80,
    0xe073_4ac0,
    0xefbc_e7e0,
    0x177c_5c30,
    0xc526_8c88,
    0xe7a2_415c,
    0x837a_6b1e,
    0x770e_15bd,
    0xea94_eaac,
    0x90c8_5af6,
    0xf66c_8490,
    0x08a3_489a,
    0x75f4_e086,
    0x01d8_50ba,
    0xc3c4_8dd7,
    0x36d7_4a41,
    0x895e_eea2,
    0x7609_5710,
    0x5702_0c59,
    0xfaa5_0066,
    0xd8ec_8308,
    0xc263_4b9c,
    0x6a94_ecfe,
    0x50c8_598d,
    0x966c_8e24,
    0xb8a3_47aa,
    0xedf4_e18e,
    0x1dd8_5a27,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x9000_0000,
    0xa800_0000,
    0x9c00_0000,
    0xf600_0000,
    0x1500_0000,
    0x8980_0000,
    0xe7c0_0000,
    0x7560_0000,
    0x9a30_0000,
    0x9b28_0000,
    0x489c_0000,
    0x944e_0000,
    0xd9ad_0000,
    0xefca_8000,
    0x9960_c000,
    0x5433_2000,
    0xba19_9000,
    0xab1f_a800,
    0x9088_5400,
    0x3048_0600,
    0x1bac_0d00,
    0x90e6_0480,
    0xf3f1_00c0,
    0x2f64_85e0,
    0xa13d_c890,
    0xa3b1_a7f8,
    0xe4d5_5f2c,
    0x79ca_87ce,
    0x5c60_c3df,
    0x95b3_20e4,
    0x51d9_942a,
    0x807f_a276,
    0x83b8_54d3,
    0xd4e0_0ed8,
    0xa1f0_085c,
    0xf848_07a7,
    0x57ac_0c8b,
    0x2ee6_0d44,
    0xeaf1_039a,
    0xf8e4_87ff,
    0xcffd_c317,
    0xa951_ac80,
    0x8c25_54c0,
    0x1e02_83e0,
    0x690c_c590,
    0xefb5_2378,
    0x5ad8_9fec,
    0x60d3_222e,
    0x8be9_9b4f,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0xd000_0000,
    0x7800_0000,
    0xa400_0000,
    0x5e00_0000,
    0xf300_0000,
    0x9780_0000,
    0x6d40_0000,
    0x4be0_0000,
    0x1830_0000,
    0x3428_0000,
    0xc60c_0000,
    0x872a_0000,
    0xb1b7_0000,
    0x3a7e_8000,
    0x824b_4000,
    0x8669_2000,
    0xe876_b000,
    0xb375_a800,
    0xf8f6_f400,
    0x6f80_0600,
    0x8940_0900,
    0xf5e0_0980,
    0x3b30_0740,
    0xdba8_0260,
    0x0f4c_0570,
    0x92ca_0c98,
    0x5a87_09e4,
    0x99d6_8dc6,
    0x2907_4757,
    0x4aa3_27fc,
    0x41f1_bde3,
    0xbd23_2330,
    0xbcb1_b37b,
    0x6ec3_2dd5,
    0xd081_ba3f,
    0x7ceb_2a41,
    0x418d_b5e3,
    0x3241_2731,
    0x6e7a_bd78,
    0xd45f_a0d7,
    0x9941_fdbf,
    0x2dfe_8000,
    0xaf0b_4000,
    0x2d89_2000,
    0x2046_b000,
    0xff5d_a800,
    0x9afa_f400,
    0xb6aa_0600,
    0xcbf7_0900,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x7000_0000,
    0x3800_0000,
    0x0c00_0000,
    0x1e00_0000,
    0x6300_0000,
    0xcc80_0000,
    0xb3c0_0000,
    0xc660_0000,
    0xb030_0000,
    0x5818_0000,
    0x5c14_0000,
    0x5612_0000,
    0x570d_0000,
    0xde84_8000,
    0xcedf_4000,
    0x69cb_e000,
    0xcf6f_d000,
    0x2da5_6800,
    0x2a59_9400,
    0xbe00_0a00,
    0x5300_0300,
    0xd480_0180,
    0xcfc0_07c0,
    0xe060_0260,
    0xdf30_06f0,
    0x8a98_0d28,
    0x8cd4_0d0c,
    0x5cf2_00ae,
    0x54fd_003f,
    0x40fc_89e7,
    0x22fb_4ec2,
    0x67c1_e0e0,
    0xc476_d0b1,
    0xa533_e089,
    0xb38b_dd9d,
    0x094f_6174,
    0x52b0_931b,
    0x90ee_8dc6,
    0x2af6_4d93,
    0x73c5_695a,
    0xa669_9665,
    0xe018_0000,
    0x1014_0000,
    0x6812_0000,
    0x440d_0000,
    0x2a04_8000,
    0x711f_4000,
    0xb1ab_e000,
    0x1c5f_d000,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0xf000_0000,
    0xd800_0000,
    0xc400_0000,
    0xe200_0000,
    0x7b00_0000,
    0x3880_0000,
    0x10c0_0000,
    0x3aa0_0000,
    0xe010_0000,
    0x3018_0000,
    0xb80c_0000,
    0x341e_0000,
    0x3a1b_0000,
    0xbf18_8000,
    0xda9c_4000,
    0x6bcf_6000,
    0x0227_1000,
    0xf0d2_1800,
    0x0abf_5400,
    0x5800_0200,
    0x0400_0300,
    0x8200_0180,
    0x8b00_03c0,
    0xe080_0360,
    0xd4c0_0310,
    0xd8a0_0388,
    0x9b10_01ec,
    0x0898_00e2,
    0xa8cc_0043,
    0x0ebe_00ea,
    0xda0b_0380,
    0x8f00_80c0,
    0x6290_42e0,
    0x5fd1_60d0,
    0x383c_10e8,
    0x4fca_9afc,
    0xd023_176a,
    0x33cf_63af,
    0x0627_1308,
    0x72d2_1a43,
    0x81bf_57ea,
    0xb880_0000,
    0xd0c0_0000,
    0x5aa0_0000,
    0x1010_0000,
    0xe818_0000,
    0x7c0c_0000,
    0xd61e_0000,
    0x411b_0000,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0xb000_0000,
    0x1800_0000,
    0x5c00_0000,
    0xae00_0000,
    0xa900_0000,
    0x3b80_0000,
    0x78c0_0000,
    0x18e0_0000,
    0xb810_0000,
    0xcc18_0000,
    0xe61c_0000,
    0x5d16_0000,
    0xd183_0000,
    0x23cb_8000,
    0x2475_c000,
    0x5245_2000,
    0x97bf_7000,
    0x3e23_1800,
    0x31fd_1c00,
    0x4380_0200,
    0x54c0_0300,
    0x4ee0_0380,
    0xfd10_02c0,
    0x4198_0060,
    0x6bdc_0170,
    0xd076_02b8,
    0xb853_02a4,
    0xccb3_80ee,
    0x02b9_c1e3,
    0xdbab_2063,
    0x1830_72e0,
    0x8ce6_9b30,
    0x2217_df98,
    0x6f18_a374,
    0x3689_b046,
    0x014d_bb0f,
    0x7f27_ae51,
    0x6e7e_3b29,
    0x995e_6c2e,
    0xe335_1bc0,
    0x207e_1fa3,
    0x804b_8000,
    0xc0b5_c000,
    0x04a5_2000,
    0x36af_7000,
    0xd1bb_1800,
    0xf321_1c00,
    0xa876_0200,
    0x9453_0300,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0xf000_0000,
    0x3800_0000,
    0x4400_0000,
    0xda00_0000,
    0xe500_0000,
    0x5980_0000,
    0x3540_0000,
    0x5ca0_0000,
    0x7410_0000,
    0x0208_0000,
    0xf114_0000,
    0x4b9e_0000,
    0xac47_0000,
    0x9b28_8000,
    0x7e4b_4000,
    0xe234_a000,
    0xe9cf_3000,
    0x2070_a800,
    0x75e8_9400,
    0xa6a0_0200,
    0x2110_0100,
    0xc388_0280,
    0x7054_03c0,
    0xf53e_00e0,
    0x7957_0110,
    0x1aa0_8368,
    0x5f1f_4394,
    0xac8a_a166,
    0x04d8_30d5,
    0xe5f0_2972,
    0x8ea7_d5d0,
    0x0d02_a208,
    0x958c_32c4,
    0x334e_2bae,
    0xd7b0_d571,
    0x2a82_208c,
    0xcfc3_71e9,
    0x1b6c_8a60,
    0xb36c_e7f3,
    0xdf64_0b07,
    0x2977_a512,
    0x9a78_a800,
    0x80fc_9400,
    0x973e_0200,
    0x9857_0100,
    0x3920_8280,
    0x7f5f_43c0,
    0x91aa_a0e0,
    0x0188_3110,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0xd000_0000,
    0x5800_0000,
    0x4400_0000,
    0x3200_0000,
    0x8700_0000,
    0xc980_0000,
    0x8b40_0000,
    0xb320_0000,
    0xb410_0000,
    0xfa08_0000,
    0x3b14_0000,
    0x6f9a_0000,
    0x664b_0000,
    0xb9a8_8000,
    0xc4d6_4000,
    0x4578_e000,
    0xf5bd_3000,
    0xaad3_6800,
    0x1461_6400,
    0x5920_0200,
    0x3710_0100,
    0xa188_0280,
    0xe754_0340,
    0x4d3a_0160,
    0x1d1b_0110,
    0xc280_80c8,
    0xccd2_421c,
    0x196a_e326,
    0x23a2_322d,
    0xcfc1_eacc,
    0x02ec_26d0,
    0x5ff8_61e8,
    0x3d6f_71ec,
    0x21b9_8b3e,
    0x60c3_56d9,
    0x0761_e986,
    0xfabc_2703,
    0x7f50_615d,
    0xe92b_738a,
    0x5f0b_8a6d,
    0xcd8c_542c,
    0x195b_6800,
    0xe435_6400,
    0x259a_0200,
    0x354b_0100,
    0xba28_8280,
    0x5c96_4340,
    0x55d8_e160,
    0x09ed_3110,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x1000_0000,
    0x0800_0000,
    0xf400_0000,
    0x8600_0000,
    0xd700_0000,
    0x5e80_0000,
    0xec40_0000,
    0x9b60_0000,
    0xe610_0000,
    0x2718_0000,
    0x6684_0000,
    0x0042_0000,
    0xe161_0000,
    0x430e_8000,
    0x2888_c000,
    0x035e_e000,
    0x29e9_d000,
    0x704c_8800,
    0x1975_ec00,
    0x8f18_0200,
    0x4284_0300,
    0xae42_0080,
    0xd261_0040,
    0x938e_8020,
    0xe7c8_c3d0,
    0x40be_e218,
    0xf4b9_d35c,
    0x92b4_897a,
    0x75a1_efb1,
    0x3322_006d,
    0x2371_0098,
    0xca16_801c,
    0x7d0c_c1da,
    0xd39c_e021,
    0x07c8_d055,
    0x70a2_0b14,
    0xecad_2ffe,
    0x6ebe_e377,
    0x07b9_d016,
    0x6234_8b2c,
    0xaae1_efbd,
    0x78c2_0080,
    0x0a21_0040,
    0xaeee_8020,
    0xc6d8_c3d0,
    0x3126_e218,
    0x8a7d_d35c,
    0x8f96_897a,
    0xa5d0_efb1,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0xd000_0000,
    0x8800_0000,
    0x8400_0000,
    0x1200_0000,
    0xdd00_0000,
    0xd680_0000,
    0x3640_0000,
    0xd1e0_0000,
    0x5610_0000,
    0x6f08_0000,
    0x3b9c_0000,
    0xb8da_0000,
    0xebb1_0000,
    0x11e0_8000,
    0xf61a_4000,
    0x5f0f_a000,
    0x639c_d000,
    0xb4cd_c800,
    0x7dbb_bc00,
    0xdee8_0200,
    0xfd8c_0100,
    0xbfd2_0380,
    0x842d_0340,
    0x333a_8220,
    0x44ab_4210,
    0x8a6f_2048,
    0x7ec6_9374,
    0xeca2_6b5a,
    0x7e77_6cd9,
    0xd4cd_c947,
    0xedbb_bc58,
    0xb6e8_003c,
    0xa98c_02ae,
    0x25d2_0343,
    0xdd2d_02fe,
    0xf7ba_822f,
    0xafeb_42bc,
    0x8d0f_226e,
    0x1e96_9223,
    0x524a_6ace,
    0x13fb_6c77,
    0x031f_cb80,
    0x3d96_bf40,
    0x1fd2_8020,
    0xb427_4310,
    0x6b3d_23c8,
    0x48ab_9034,
    0x1c78_e97a,
    0xb1cc_2ec9,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0xb000_0000,
    0xd800_0000,
    0x0c00_0000,
    0x1e00_0000,
    0x5d00_0000,
    0x2e80_0000,
    0xd840_0000,
    0x8320_0000,
    0xf210_0000,
    0xb308_0000,
    0xcb8c_0000,
    0x4ad6_0000,
    0x9d7b_0000,
    0x2031_8000,
    0x719b_c000,
    0xfdcf_a000,
    0x2cff_d000,
    0xfde6_0800,
    0x8d72_e400,
    0x6828_0200,
    0x759c_0100,
    0x87de_0180,
    0xbbf7_02c0,
    0x9c67_8360,
    0x38a0_c030,
    0x40de_2078,
    0xf274_1174,
    0x9da1_a8ba,
    0xb241_3761,
    0x5c38_080c,
    0x9785_e6c8,
    0x7ccf_814c,
    0x747c_c0ee,
    0xaca0_23cb,
    0x32d3_1085,
    0x016e_2b98,
    0x363d_f482,
    0x4898_2935,
    0x1956_f7a6,
    0xbba1_aac1,
    0x1341_355c,
    0xd4b8_0980,
    0xaec5_e6c0,
    0x176f_8160,
    0x0f2c_c130,
    0xac08_21f8,
    0x8e0f_13b4,
    0x5510_2bda,
    0x4a9a_f751,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x7000_0000,
    0xc800_0000,
    0xa400_0000,
    0xf200_0000,
    0x2300_0000,
    0xba80_0000,
    0x5ec0_0000,
    0xc160_0000,
    0x1e10_0000,
    0xb518_0000,
    0x8b9c_0000,
    0xb74e_0000,
    0xed39_0000,
    0x25a4_8000,
    0x9876_4000,
    0x0390_6000,
    0x335d_5000,
    0x8f20_d800,
    0xbeab_ac00,
    0x4ef8_0200,
    0x0b4c_0300,
    0x2336_0380,
    0x08b5_01c0,
    0xeff2_8320,
    0x5ad3_4290,
    0x637a_e3c8,
    0x6512_108c,
    0x1394_3aea,
    0x4b40_bd7b,
    0x0328_b905,
    0x98aa_ff78,
    0x57f6_db54,
    0x36ce_acee,
    0x3572_807d,
    0xb413_43e4,
    0x8a1a_e3fe,
    0xaf02_11bd,
    0x9c8c_3a0c,
    0x47dc_bfaa,
    0xfce6_ba1b,
    0x0853_fc75,
    0x09b2_5b80,
    0xee68_edc0,
    0x429a_e120,
    0x12c2_1190,
    0x076c_3848,
    0x770c_bd4c,
    0x409e_bbca,
    0x39df_fceb,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x9000_0000,
    0x5800_0000,
    0x8c00_0000,
    0x5a00_0000,
    0xcd00_0000,
    0x7880_0000,
    0x0240_0000,
    0x0760_0000,
    0x5e10_0000,
    0xe318_0000,
    0x938c_0000,
    0x25d2_0000,
    0x64ab_0000,
    0xf5a1_8000,
    0x2f23_4000,
    0x9c7d_a000,
    0x7199_1000,
    0x34cd_4800,
    0x7e24_6c00,
    0x26f8_0200,
    0x52dc_0300,
    0x812a_0180,
    0xb777_0240,
    0x360b_8160,
    0xc714_4230,
    0x8d96_2168,
    0x66dd_5334,
    0x0723_69e2,
    0x1865_3c09,
    0x9f91_6a1d,
    0xbfde_3e78,
    0xc9a8_e80c,
    0x1d31_7f0e,
    0x7567_4a77,
    0x1713_6ee2,
    0x7593_805e,
    0x1ad8_40f8,
    0x9524_221b,
    0x0166_528b,
    0x311a_e924,
    0x2a8a_7d8d,
    0x7b5e_c980,
    0x39fc_2e40,
    0x935c_2360,
    0xddfa_5130,
    0xed50_e8e8,
    0x0eed_7d74,
    0xd6cd_4a82,
    0x6f24_6d39,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x7000_0000,
    0x1800_0000,
    0xcc00_0000,
    0x0e00_0000,
    0xb100_0000,
    0x1a80_0000,
    0xf3c0_0000,
    0x0b20_0000,
    0x6110_0000,
    0xb298_0000,
    0x07c4_0000,
    0xb92e_0000,
    0xc613_0000,
    0xd501_8000,
    0xe085_c000,
    0xf0d8_2000,
    0xb6a0_5000,
    0xf557_f800,
    0x5ef8_a400,
    0x2f2e_0200,
    0x7b13_0300,
    0xe181_8080,
    0xd245_c1c0,
    0xf978_2060,
    0xe870_5330,
    0x42ef_f838,
    0x892c_a6c4,
    0x3e18_026a,
    0x4904_00cf,
    0x868e_00ac,
    0x95c3_0044,
    0x6e39_82aa,
    0xb991_c32f,
    0xfe4e_22dc,
    0xa767_51dc,
    0x3160_7b3e,
    0x8c6a_644d,
    0xb8f9_a1ef,
    0x8a35_905e,
    0x8397_d99f,
    0xdd5c_f4a4,
    0x6af7_f838,
    0xbd28_a6c4,
    0xac16_026a,
    0x9e07_00cf,
    0xf917_80ac,
    0xbe82_c044,
    0x29cf_a2aa,
    0x7822_932f,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x5000_0000,
    0xd800_0000,
    0x0400_0000,
    0xe200_0000,
    0xe700_0000,
    0x9580_0000,
    0xbdc0_0000,
    0x6ba0_0000,
    0xdf10_0000,
    0x8188_0000,
    0xe7cc_0000,
    0xd8aa_0000,
    0x708b_0000,
    0xdf48_8000,
    0xfbf0_4000,
    0x5d66_e000,
    0x0f31_b000,
    0x5a43_3800,
    0xc97f_3400,
    0x152a_0200,
    0x894b_0100,
    0x36e8_8180,
    0x93e0_4140,
    0x916e_e360,
    0x513d_b010,
    0x0b49_3b88,
    0x81e4_379c,
    0xde6a_8056,
    0x28b7_43f7,
    0xd884_602e,
    0x334a_f23c,
    0x95ed_5966,
    0x847e_c78f,
    0x9baf_daea,
    0x7715_875e,
    0x6d89_baab,
    0x89d8_7558,
    0x01a6_603b,
    0xe40d_f310,
    0xf20f_da07,
    0x5f05_8676,
    0xc181_bb88,
    0x87d4_779c,
    0x88ac_6056,
    0xa896_f3f7,
    0xdb4f_582e,
    0x19f9_c63c,
    0xba6d_5b66,
    0x9abe_c68f,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0xf000_0000,
    0xc800_0000,
    0x7400_0000,
    0x0a00_0000,
    0xff00_0000,
    0x4580_0000,
    0xdec0_0000,
    0xfde0_0000,
    0xe710_0000,
    0xa998_0000,
    0xf8cc_0000,
    0x44fe_0000,
    0xeb89_0000,
    0xb3d6_8000,
    0x6b6d_4000,
    0x3a51_e000,
    0xc3a9_b000,
    0x26a9_5800,
    0x6428_fc00,
    0x237e_0200,
    0x8e49_0300,
    0xa9b6_8180,
    0x29bd_43c0,
    0xe9a9_e320,
    0x89b5_b1d0,
    0x79af_5828,
    0xb1bd_fffc,
    0xc5ae_8316,
    0xcfb1_407b,
    0x30b7_e277,
    0x752c_b05c,
    0xabe1_d986,
    0x561c_be33,
    0xb101_633b,
    0x1891_f352,
    0xe048_3a59,
    0xa4a9_0d16,
    0x4f2e_3a3e,
    0xfcec_0e42,
    0x9786_b994,
    0xadc8_4d4f,
    0x6e61_d828,
    0x48dc_bffc,
    0x2ce1_6316,
    0x0f81_f07b,
    0x81d0_3a77,
    0x2865_0c5c,
    0x01d0_3b86,
    0xe865_0d33,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x1000_0000,
    0x6800_0000,
    0x2400_0000,
    0xda00_0000,
    0xc100_0000,
    0xd180_0000,
    0x17c0_0000,
    0x0220_0000,
    0x7510_0000,
    0xa398_0000,
    0xd2c4_0000,
    0x19a2_0000,
    0xcbdd_0000,
    0x543c_8000,
    0x6a0f_4000,
    0x7902_2000,
    0xbd93_3000,
    0xf9c4_7800,
    0x7136_0400,
    0x4182_0200,
    0xbfcd_0300,
    0x0624_8080,
    0xbf0b_4040,
    0x0a80_21a0,
    0x275e_3090,
    0xd460_fb68,
    0x08fd_4704,
    0xf0a2_2146,
    0xde43_335f,
    0xa9fc_7888,
    0xd122_0594,
    0x9198_012e,
    0xf7c4_00db,
    0x3222_038e,
    0x0d1d_006b,
    0xef9c_83b6,
    0x2cdf_4167,
    0x02ba_2284,
    0xdb47_3026,
    0x927e_7a2f,
    0x7fef_06d0,
    0x0e3c_8368,
    0x6b0f_4304,
    0x8882_2346,
    0xba53_305f,
    0x93e4_7808,
    0x2026_05d4,
    0x381a_008e,
    0xac09_004b,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x9000_0000,
    0x1800_0000,
    0x1c00_0000,
    0x3a00_0000,
    0x2900_0000,
    0x4380_0000,
    0xd1c0_0000,
    0x6c60_0000,
    0xad10_0000,
    0x2588_0000,
    0x22dc_0000,
    0x96f2_0000,
    0x2753_0000,
    0x842b_8000,
    0xd9ab_4000,
    0x376f_2000,
    0x638f_7000,
    0xe1df_b800,
    0x0467_cc00,
    0x3912_0200,
    0x1b83_0100,
    0x2dc3_8380,
    0xc667_4240,
    0x9c15_2060,
    0x7a00_7070,
    0xc906_38e8,
    0xd39f_8ca4,
    0xc9d6_a30e,
    0x7067_3247,
    0x9713_1a31,
    0x0c9f_fcf4,
    0x6150_9af6,
    0x4738_bdfb,
    0x4b25_bb33,
    0x2928_cf79,
    0xfc2b_82fe,
    0x15ab_4311,
    0xf56f_2264,
    0xc68f_71ae,
    0x805f_ba97,
    0xe0a7_cf09,
    0x2cf2_00e8,
    0x4e53_00a4,
    0x27ab_810e,
    0x986b_4347,
    0x430f_21b1,
    0xd29f_72b4,
    0xfe57_b896,
    0x0fbb_cc8b,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x9000_0000,
    0xc800_0000,
    0xc400_0000,
    0xf600_0000,
    0xd900_0000,
    0x3880_0000,
    0xe340_0000,
    0x1ae0_0000,
    0x9f10_0000,
    0x1988_0000,
    0xa7dc_0000,
    0x93b2_0000,
    0xa6e9_0000,
    0x5500_8000,
    0x4a8a_c000,
    0x2c55_2000,
    0x6b6c_1000,
    0x8ccd_e800,
    0x242d_1c00,
    0xd43a_0200,
    0xcc35_0100,
    0x2032_8380,
    0x8223_c240,
    0x6535_a320,
    0x40b6_d310,
    0x6d70_cbd8,
    0x4dcd_0f64,
    0xf0ad_eae2,
    0x957d_1e8d,
    0x31d2_01eb,
    0x9ab9_013c,
    0xb668_80c6,
    0xe246_c3cf,
    0x6e6f_22b6,
    0xae59_12ef,
    0xbc7f_6a6e,
    0x114e_ddc3,
    0x95ef_a238,
    0x0e93_d15c,
    0x9a4a_49be,
    0x5272_ce33,
    0x244a_4858,
    0x0f72_cd24,
    0x0aca_49c2,
    0xa532_cd9d,
    0xe0aa_4a33,
    0x1d62_ce58,
    0x15c2_4a24,
    0xfcae_cd42,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x3000_0000,
    0xb800_0000,
    0x3c00_0000,
    0x5600_0000,
    0x8500_0000,
    0x6c80_0000,
    0x51c0_0000,
    0x70a0_0000,
    0xeb10_0000,
    0x9588_0000,
    0x8b5c_0000,
    0x9466_0000,
    0x4f27_0000,
    0x135f_8000,
    0x387e_c000,
    0x713a_a000,
    0x2244_9000,
    0x86ee_b800,
    0xcfe9_5400,
    0xed6e_0200,
    0xd5bb_0100,
    0x1799_8380,
    0xac49_c0c0,
    0x4fed_22e0,
    0xad66_50f0,
    0x35b2_1958,
    0x278a_c614,
    0x145f_3bb2,
    0x73ec_9447,
    0xfb6d_2042,
    0xb0a6_526c,
    0x4b12_1b36,
    0x459a_c61d,
    0x0357_3be9,
    0x1070_96d8,
    0x252b_2127,
    0xc051_5272,
    0xd1e5_98d4,
    0x4c68_0652,
    0x0323_9837,
    0x1d5f_055a,
    0xb174_1ad8,
    0xf3bd_c6d4,
    0xca88_b952,
    0xccce_54b7,
    0xf031_811a,
    0x64c5_c078,
    0xe423_2284,
    0x66cd_535a,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x3000_0000,
    0x6800_0000,
    0xd400_0000,
    0x7e00_0000,
    0x7b00_0000,
    0xee80_0000,
    0xb1c0_0000,
    0xad60_0000,
    0x5110_0000,
    0xab88_0000,
    0x444c_0000,
    0xc226_0000,
    0x25bd_0000,
    0x83e2_8000,
    0xc0db_c000,
    0x56ed_6000,
    0x4d4a_d000,
    0xd5af_b800,
    0xcbf1_ec00,
    0x44ce_0200,
    0x70e1_0100,
    0x8a4c_8180,
    0x912a_c0c0,
    0x7f29_e1a0,
    0x7c2c_1350,
    0x7ea0_59f8,
    0x3d60_fdec,
    0x290c_d9ba,
    0x479a_3fc7,
    0xb64d_3935,
    0x7b2a_2c84,
    0x1a23_608e,
    0xd9ab_d381,
    0x49e3_3ad0,
    0xf5db_2eea,
    0xab67_e3ed,
    0xc60d_1278,
    0xb70c_d82c,
    0x4c9a_3f9a,
    0x50cd_3b57,
    0x2eea_2fed,
    0xa143_6078,
    0x27bb_d12c,
    0x72eb_3a1a,
    0x7b57_2d97,
    0x2aa1_e14d,
    0x0360_11a8,
    0x3206_5894,
    0x991d_ff16,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0xf000_0000,
    0x3800_0000,
    0x7400_0000,
    0x9600_0000,
    0x7700_0000,
    0x5a80_0000,
    0xef40_0000,
    0x1ee0_0000,
    0x3510_0000,
    0x6b88_0000,
    0x6acc_0000,
    0x173e_0000,
    0x1eb7_0000,
    0xd576_8000,
    0x8fc6_c000,
    0xd4b4_e000,
    0xc86e_5000,
    0x1852_6800,
    0x047c_9c00,
    0xba56_0200,
    0x856b_0100,
    0x67c0_8180,
    0x08bd_c3c0,
    0xe27c_60e0,
    0xb55f_91d0,
    0xcbf0_0a58,
    0xee84_0ddc,
    0x5958_8b6a,
    0xf9e5_cebd,
    0xa792_ebfb,
    0xc8c1_5e14,
    0x962a_62ce,
    0xc334_92bb,
    0x58b0_8b64,
    0x0a79_cfb6,
    0x6944_ea87,
    0xe1ea_5c8e,
    0x438a_e39b,
    0x96d9_5354,
    0xad24_e9be,
    0x7bba_5cc3,
    0x56e2_e3d8,
    0x3905_521c,
    0xe992_e98a,
    0x7bc1_5e6d,
    0x02aa_6023,
    0xdf74_9008,
    0xb2d0_8944,
    0xd329_cdd6,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xb000_0000,
    0xd800_0000,
    0x6400_0000,
    0xda00_0000,
    0x9700_0000,
    0x8580_0000,
    0x18c0_0000,
    0xb6a0_0000,
    0x5910_0000,
    0x7088_0000,
    0xfe44_0000,
    0x99f6_0000,
    0xdc6b_0000,
    0xa4b4_8000,
    0x8207_4000,
    0xb308_e000,
    0x7f99_b000,
    0x3fc2_9800,
    0xeb3a_1400,
    0x25de_0200,
    0x1c3f_0100,
    0x304a_8080,
    0x6ce8_42c0,
    0x3aea_6360,
    0x8be5_f190,
    0x0776_fb68,
    0x6720_e65c,
    0x03c2_7816,
    0x1527_a563,
    0x48ca_985a,
    0xbebe_16a4,
    0x7508_0022,
    0xa684_01a9,
    0x0f56_02ef,
    0x357b_027d,
    0x0c3c_808c,
    0x1843_41a7,
    0xf0fe_e168,
    0x34f2_b2a5,
    0x1ef6_19f1,
    0x71fd_5552,
    0x2076_e3e8,
    0x3ab6_b09c,
    0x7f00_1976,
    0x7996_55f3,
    0x86c2_63b2,
    0x4bb1_f238,
    0x9388_fb54,
    0x89cf_e55a,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0xf000_0000,
    0x2800_0000,
    0x1400_0000,
    0x6a00_0000,
    0x9100_0000,
    0x0580_0000,
    0xb540_0000,
    0xbba0_0000,
    0xa710_0000,
    0xda98_0000,
    0x83dc_0000,
    0x7e7e_0000,
    0xee75_0000,
    0xf66a_8000,
    0x2a79_4000,
    0xa478_2000,
    0x776f_b000,
    0xf7fb_2800,
    0x2d37_b400,
    0xb2c6_0200,
    0xabf9_0300,
    0x632c_8380,
    0x81c0_43c0,
    0xdb74_a0a0,
    0x91ff_f050,
    0x0a37_89a8,
    0xa844_4644,
    0xc837_8a16,
    0xed44_45d5,
    0x47b7_8b6e,
    0x3904_465c,
    0xd197_8a4a,
    0x3f54_469f,
    0xdaaf_8971,
    0x8a98_456d,
    0x7bc9_8b47,
    0x5271_44a8,
    0x487d_08e1,
    0x316d_0740,
    0xc0f7_aac5,
    0xefa7_f426,
    0xed0a_a228,
    0x5b8a_f184,
    0x5e5d_08b6,
    0xf73d_0685,
    0x2bcf_a946,
    0xaa6b_f7d8,
    0x646c_a2fc,
    0x9763_f01a,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x1000_0000,
    0x4800_0000,
    0xac00_0000,
    0x8e00_0000,
    0xe500_0000,
    0x4e80_0000,
    0x97c0_0000,
    0xe560_0000,
    0x3e90_0000,
    0x0fd8_0000,
    0xe17c_0000,
    0x0c92_0000,
    0x2cd1_0000,
    0xe6e9_8000,
    0x5bc3_c000,
    0xbb6d_a000,
    0x7390_5000,
    0xfd59_3800,
    0xb0b5_0c00,
    0xa0e9_8200,
    0xd2c3_c300,
    0x9bed_a380,
    0x1150_5040,
    0x1eb9_3920,
    0xb5e5_0eb0,
    0xc451_8038,
    0xe82f_c094,
    0xd627_a2ba,
    0x4b3d_521f,
    0x11a2_bab5,
    0xfc67_ce4a,
    0x960d_a007,
    0x2100_5311,
    0x9c81_3a88,
    0xa4c9_0eac,
    0xaafb_832e,
    0xc5d2_c025,
    0x1664_236a,
    0x9103_919f,
    0xe48c_9bdd,
    0xb0c9_5e9e,
    0xd0fa_bab5,
    0x4adb_ce4a,
    0x9fff_a007,
    0x2341_5311,
    0x3db0_ba88,
    0xb276_ceac,
    0x9304_232e,
    0x7f93_9025,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0xd000_0000,
    0xc800_0000,
    0x0400_0000,
    0x0a00_0000,
    0x1b00_0000,
    0xeb80_0000,
    0x5740_0000,
    0x0fe0_0000,
    0x6390_0000,
    0xf358_0000,
    0xb5ec_0000,
    0x608a_0000,
    0xd4c1_0000,
    0xecac_8000,
    0x7e6b_4000,
    0x47d2_6000,
    0xa329_f000,
    0x932d_a800,
    0x4b29_9c00,
    0xe72c_8200,
    0x392b_4300,
    0xe032_6180,
    0x14b9_f340,
    0xa275_ab20,
    0xe1c5_9c10,
    0x6626_8228,
    0xa1aa_436c,
    0xe8fe_e22e,
    0x5e02_b21d,
    0x191f_cb1f,
    0x9490_6d9e,
    0x66d9_29e5,
    0x8bae_ddbb,
    0x83f4_e1ac,
    0xcd83_b24e,
    0x5253_492d,
    0x5d6b_2f27,
    0x1053_4bda,
    0x826b_2f27,
    0x91d3_4bc8,
    0x1e2b_2f0e,
    0xbdb3_4b1f,
    0x2efb_2d9e,
    0x4b0b_49e5,
    0xe387_2dbb,
    0x3359_49ac,
    0xd5ea_2e4e,
    0xb09f_cb2d,
    0x1cd0_6c27,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x1000_0000,
    0xb800_0000,
    0x9400_0000,
    0x1200_0000,
    0xdd00_0000,
    0x8680_0000,
    0xe040_0000,
    0xd2a0_0000,
    0xb290_0000,
    0xa248_0000,
    0x97a4_0000,
    0xb012_0000,
    0xe81f_0000,
    0x0c16_8000,
    0x9600_4000,
    0x770c_a000,
    0xcf82_5000,
    0x74de_4800,
    0xefe1_f400,
    0xe6b6_8200,
    0xf090_4100,
    0xe744_a080,
    0x9526_5040,
    0xfa4c_4ae0,
    0x73be_f650,
    0x2a00_0248,
    0x0900_0274,
    0xb480_029a,
    0x2d40_03c1,
    0xec20_01aa,
    0xc6d0_009a,
    0x62e8_02c1,
    0xf834_012a,
    0x94da_00da,
    0x9ffb_0021,
    0x6ea4_837a,
    0xcc8f_4092,
    0xd952_2355,
    0xce26_1160,
    0xb3c0_eb13,
    0xc87c_a41f,
    0x9e7e_49aa,
    0x8971_f49a,
    0x76fe_80c1,
    0xaa34_402a,
    0x69d6_a05a,
    0x0979_5061,
    0x36fa_c99a,
    0x8a2e_b6c2,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x3000_0000,
    0xf800_0000,
    0x7400_0000,
    0x6600_0000,
    0x1300_0000,
    0x9b80_0000,
    0x8a40_0000,
    0xf620_0000,
    0x5f90_0000,
    0x5448_0000,
    0xf12c_0000,
    0x9216_0000,
    0x3517_0000,
    0xe882_8000,
    0x21ca_c000,
    0x847d_6000,
    0xddad_f000,
    0x6dc5_8800,
    0xb678_a400,
    0xf8a2_8200,
    0x2d5a_c100,
    0x2bb5_6180,
    0x96c1_f0c0,
    0xf1f3_8be0,
    0xa8ff_a5d0,
    0x2268_0398,
    0xeebc_014c,
    0xa65e_03ee,
    0xf43b_02e9,
    0x8294_8038,
    0x60dd_c0ae,
    0x0aff_e0c9,
    0xef67_3388,
    0x7238_e826,
    0xe195_56fd,
    0x6347_0a7a,
    0xc4b2_64f9,
    0x875f_e0c0,
    0x4ab7_3172,
    0x4850_e99f,
    0x0b29_571d,
    0x3b19_0838,
    0x6789_64ae,
    0x004b_62c9,
    0xc72a_f288,
    0x490f_09a6,
    0x229e_663d,
    0x70c9_e19a,
    0xa2e0_3129,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x5000_0000,
    0x2800_0000,
    0xdc00_0000,
    0x2200_0000,
    0x2700_0000,
    0xed80_0000,
    0xa7c0_0000,
    0xbf20_0000,
    0x0990_0000,
    0x51d8_0000,
    0xd63c_0000,
    0x991a_0000,
    0xc89d_0000,
    0xdd47_8000,
    0x8d6e_4000,
    0xe571_e000,
    0x196e_3000,
    0x8b64_b800,
    0xd46d_0400,
    0xcde7_8200,
    0x943e_4300,
    0x2e09_e380,
    0xed02_3140,
    0xf686_b8a0,
    0x385c_0770,
    0x17e2_0288,
    0x8731_039c,
    0xdd85_8036,
    0x1fcf_43df,
    0xab2c_625c,
    0xa79d_7356,
    0x7cd2_d9cf,
    0xc0ad_77c4,
    0xf152_dbd2,
    0xf76d_76bd,
    0x8672_d809,
    0x72fd_7453,
    0xddaa_dbf2,
    0x5fc1_760d,
    0x8b30_d9e1,
    0x179c_75df,
    0x04d7_5a5c,
    0x34a2_3756,
    0x0f5e_bbcf,
    0xf260_04c4,
    0x4cf8_0052,
    0x38ac_03fd,
    0xc542_02a9,
    0xe961_0023,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x1000_0000,
    0x0800_0000,
    0x8c00_0000,
    0x5e00_0000,
    0x1b00_0000,
    0xda80_0000,
    0x62c0_0000,
    0xcc60_0000,
    0x2e90_0000,
    0xe8c8_0000,
    0xed7c_0000,
    0x2d12_0000,
    0x1d89_0000,
    0x0e4d_8000,
    0x29a9_c000,
    0x6e72_6000,
    0x3392_d000,
    0x4d53_9800,
    0x9724_ec00,
    0xcead_8200,
    0xb2f9_c100,
    0x2e5a_6380,
    0x99be_d040,
    0x9669_9820,
    0xa781_ee30,
    0x975a_0378,
    0x5e35_016c,
    0x513f_80ea,
    0x11b0_c1cb,
    0x5a77_e311,
    0x1987_128a,
    0x9c53_fadb,
    0x8caf_3fd9,
    0xbffb_99de,
    0x83c8_ecfd,
    0x6ff7_8288,
    0x2bcc_c15c,
    0x13e5_e1ba,
    0x6dce_110b,
    0x8cfe_78d9,
    0x6556_fc76,
    0xab21_fb11,
    0x68b6_3e8a,
    0x3dfe_18db,
    0x2edd_2ed9,
    0x3277_e25e,
    0xc587_10bd,
    0x2a53_f8a8,
    0x0baf_3e6c,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x3000_0000,
    0x6800_0000,
    0x5c00_0000,
    0x5600_0000,
    0x8700_0000,
    0xa380_0000,
    0x22c0_0000,
    0x30a0_0000,
    0x9590_0000,
    0xd5c8_0000,
    0x1b3c_0000,
    0xdb56_0000,
    0xdb65_0000,
    0x55a7_8000,
    0xfb14_c000,
    0x6589_e000,
    0x1dc5_f000,
    0x9725_9800,
    0xd540_7400,
    0x686f_8200,
    0xfc28_c100,
    0x08df_e380,
    0x71a0_f0c0,
    0x0902_19a0,
    0x5094_b570,
    0x6b46_6358,
    0xf37d_331c,
    0xe9b2_790e,
    0x9d1c_844b,
    0x8a9b_9b62,
    0xe249_7626,
    0xe3f6_038f,
    0x62f5_03b0,
    0x5e6f_83c3,
    0x0b28_c256,
    0x235f_e16c,
    0x3f60_f2d6,
    0x07a2_1917,
    0x1e04_b68c,
    0x4b0e_617d,
    0x4d81_33e5,
    0xa1c4_78e2,
    0xf129_86e6,
    0x3a54_1a2f,
    0x97f1_b6c0,
    0x88e1_e09b,
    0xbf69_f14a,
    0x47bb_9862,
    0xfe19_769d,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x3000_0000,
    0x4800_0000,
    0x6400_0000,
    0xb600_0000,
    0x1900_0000,
    0xd680_0000,
    0x36c0_0000,
    0x4020_0000,
    0xd090_0000,
    0xa7d8_0000,
    0x12bc_0000,
    0x6056_0000,
    0xb6f1_0000,
    0x70a0_8000,
    0x4758_c000,
    0xfd6e_2000,
    0x16fc_5000,
    0x60b7_1800,
    0xdf5a_a400,
    0xe178_8200,
    0x8ce4_c300,
    0xabb8_2380,
    0xa6cd_50c0,
    0x1837_9920,
    0x2c92_6590,
    0x0dce_a0d8,
    0x91a4_9364,
    0x7dd9_38da,
    0xf9a6_f41b,
    0xc9cf_9a20,
    0x37be_65d2,
    0xfcc0_a1c7,
    0x3329_93ee,
    0x650f_b87b,
    0xbc9f_3750,
    0x55d9_393a,
    0x6da6_f4ab,
    0xd7cf_9968,
    0x7abe_676e,
    0xd440_a2f9,
    0x78e9_906f,
    0x45af_b9a0,
    0x43cf_3512,
    0x64a1_38e7,
    0x994a_f67e,
    0x5061_98a3,
    0x0e63_6434,
    0x636e_21e0,
    0x9bfc_50b0,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x5000_0000,
    0x6800_0000,
    0x7400_0000,
    0xee00_0000,
    0xc900_0000,
    0x8a80_0000,
    0x2740_0000,
    0xff60_0000,
    0x8c90_0000,
    0xda48_0000,
    0xfbec_0000,
    0x32da_0000,
    0xc7a5_0000,
    0x2432_8000,
    0xf9ef_c000,
    0x79c0_2000,
    0x4631_d000,
    0xe2e2_2800,
    0x9057_4c00,
    0xf4fa_8200,
    0x6543_c100,
    0xd47a_2180,
    0x5d04_d140,
    0x7498_a9a0,
    0xe654_8dd0,
    0x51e0_a1b8,
    0x2dd7_1224,
    0x982a_8baa,
    0x13fc_5ddd,
    0x06c2_085d,
    0x49b6_9ee2,
    0xbd30_ab51,
    0x1b68_8c8b,
    0x2a92_a0c1,
    0x574e_1213,
    0xa76a_08f5,
    0xc08a_9e61,
    0x2842_a8bc,
    0xa8f1_8d9e,
    0x9f52_22af,
    0xa378_d094,
    0x768a_a9dd,
    0xad5d_8fa2,
    0xd068_22f1,
    0xeb0d_d15b,
    0xf190_2979,
    0x9ece_4c37,
    0x25ba_015f,
    0x7f35_02bc,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x3000_0000,
    0xe800_0000,
    0xe400_0000,
    0x1a00_0000,
    0x1100_0000,
    0x5380_0000,
    0xb8c0_0000,
    0x80e0_0000,
    0xd190_0000,
    0xc5d8_0000,
    0xbd74_0000,
    0xba56_0000,
    0x0ba5_0000,
    0x79b8_8000,
    0x4cad_4000,
    0xa523_2000,
    0x3cec_f000,
    0x0793_5800,
    0x8ad9_bc00,
    0xd5e0_8200,
    0xa819_4300,
    0x8415_2280,
    0x8a19_f0c0,
    0xc913_dba0,
    0x5f90_ff90,
    0x46cd_a268,
    0x8be4_b344,
    0x9308_fbce,
    0x2e98_0e23,
    0x8550_fba3,
    0xeb2c_0fd6,
    0x1fe6_fbff,
    0x0119_0d71,
    0x4b86_7887,
    0x14c0_4e9d,
    0x4ef3_58ad,
    0x3289_be60,
    0x6358_8385,
    0x4c3d_40f1,
    0x937b_20f2,
    0x0958_f0b4,
    0xd525_5923,
    0xb4ec_bf16,
    0x7380_005f,
    0x48c0_02e1,
    0xc8e0_02ef,
    0x0590_01d9,
    0x37d8_0163,
    0x4874_0343,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x5000_0000,
    0xe800_0000,
    0x5400_0000,
    0xbe00_0000,
    0x1b00_0000,
    0x7f80_0000,
    0xa9c0_0000,
    0xbf60_0000,
    0x3d90_0000,
    0xf8d8_0000,
    0x55ec_0000,
    0x48da_0000,
    0x2de5_0000,
    0x94d6_8000,
    0x97e5_c000,
    0xd9c2_6000,
    0xa777_7000,
    0xb183_f800,
    0xaacc_0c00,
    0x4cee_8200,
    0xc659_c300,
    0x5ea0_6180,
    0xe6ee_7140,
    0xc357_7ba0,
    0x0a20_cd50,
    0x88a0_60f8,
    0x69ee_736c,
    0x62d7_787e,
    0xe8e0_cfe7,
    0xa040_635d,
    0xa9be_72a6,
    0x9b6f_789b,
    0x9b9c_cc7b,
    0x6fc2_617d,
    0x7877_7040,
    0xf803_fbd6,
    0x1c0c_0f85,
    0xda0e_80da,
    0x1d09_c33d,
    0xd898_6260,
    0x3c52_73c6,
    0xb3b5_7add,
    0xe679_cfe6,
    0x1314_e13b,
    0xbb92_b22b,
    0x9fc1_9805,
    0xa07b_7e6c,
    0x140d_7a08,
    0x1e05_ce32,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0xf000_0000,
    0x4800_0000,
    0x1400_0000,
    0x2a00_0000,
    0x4700_0000,
    0x1e80_0000,
    0xf040_0000,
    0x9620_0000,
    0x0890_0000,
    0xb958_0000,
    0x4dbc_0000,
    0x454e_0000,
    0xa3b1_0000,
    0x704e_8000,
    0x5623_4000,
    0xe88d_e000,
    0x4947_5000,
    0x05ae_4800,
    0x5156_a400,
    0x89b6_8200,
    0x374f_4300,
    0x48bb_e380,
    0x18da_53c0,
    0xdf76_c920,
    0x0d38_e450,
    0xe81b_e2a8,
    0xc40a_521c,
    0x720e_cbfa,
    0xeb14_e401,
    0x688d_e178,
    0x8947_5372,
    0xe5ae_49cd,
    0xa156_a7ea,
    0xc1b6_824f,
    0x234f_421f,
    0x62bb_e0b1,
    0x5fda_53a6,
    0xc1f6_c81d,
    0xfd78_e782,
    0x7e3b_e1f3,
    0xcc9a_51f5,
    0xcb56_caf8,
    0xa6a8_e4b2,
    0x2dc3_e2ed,
    0x2af6_50ba,
    0x95e0_cb67,
    0xf775_e7c3,
    0x293b_606b,
    0x6a08_10f7,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0xd000_0000,
    0x7800_0000,
    0xe400_0000,
    0x4200_0000,
    0x5d00_0000,
    0xe580_0000,
    0xd8c0_0000,
    0x1be0_0000,
    0x0b90_0000,
    0xebd8_0000,
    0x0d74_0000,
    0x65ca_0000,
    0x4e77_0000,
    0xdb58_8000,
    0xbc2a_4000,
    0xd8e0_a000,
    0x7512_3000,
    0xb990_5800,
    0xdeda_5c00,
    0xd4e0_8200,
    0xcb0e_4300,
    0x3292_a280,
    0x8c41_3340,
    0x28ba_d9e0,
    0x4ba3_1f90,
    0xe52a_a308,
    0xcf65_3274,
    0xf8c8_d916,
    0x0bf0_1c23,
    0xd380_238f,
    0xdfdc_70be,
    0x3762_f827,
    0xdccb_6e01,
    0xe9e2_59e1,
    0x5e89_5eca,
    0x424a_028a,
    0x0bb7_03ea,
    0x8538_803a,
    0xbf7a_4252,
    0x50d8_a3f6,
    0x97f6_3088,
    0x7582_590f,
    0xc0d9_5ffe,
    0x8ff2_03c7,
    0xe193_0291,
    0x2aca_8069,
    0x4ee9_43fe,
    0xa212_207c,
    0xed1f_7359,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xf000_0000,
    0x8800_0000,
    0xac00_0000,
    0xfe00_0000,
    0xbf00_0000,
    0x2180_0000,
    0x2c40_0000,
    0x8620_0000,
    0x5e90_0000,
    0x6dc8_0000,
    0x7a64_0000,
    0xa0ae_0000,
    0x1749_0000,
    0x45b9_8000,
    0x9bd5_c000,
    0x2970_e000,
    0x5f34_b000,
    0x7409_c800,
    0x6a05_e400,
    0x4517_8200,
    0x3c9c_c100,
    0xc4c9_6080,
    0x98e1_73c0,
    0x2b79_2a20,
    0x2631_56b0,
    0xee9e_49f8,
    0xc5d9_27fc,
    0x267e_e206,
    0xd6ad_b271,
    0x0458_48b8,
    0x9a24_240a,
    0x0881_626f,
    0x8ec5_70a5,
    0x2df7_297c,
    0x9fe8_55d0,
    0x4eef_cba8,
    0x8868_e414,
    0x51a0_0272,
    0x21d0_01d3,
    0x1468_00c3,
    0x47b4_01dd,
    0xe2c6_0140,
    0xb3fd_03f6,
    0xf0ff_8069,
    0x1768_c2d4,
    0x802f_61c4,
    0x858c_71da,
    0x3e4e_a9c7,
    0xe73d_94b1,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xf000_0000,
    0xb800_0000,
    0x1c00_0000,
    0x2a00_0000,
    0xc700_0000,
    0x2580_0000,
    0x4940_0000,
    0xc960_0000,
    0xf290_0000,
    0x44c8_0000,
    0xf424_0000,
    0x45ee_0000,
    0xff4f_0000,
    0x646f_8000,
    0x300f_4000,
    0xd819_e000,
    0xcc14_3000,
    0x6211_e800,
    0x6313_8c00,
    0x1381_8200,
    0xa440_4100,
    0x2bf6_6080,
    0x9e5b_73c0,
    0xc4e8_0ae0,
    0xcfd7_bc70,
    0xf3b8_6aa8,
    0x4fa7_ce1c,
    0xd5b1_e216,
    0x8aa0_33e5,
    0x4337_e945,
    0x9878_8c7a,
    0x8a00_015b,
    0x7700_01bc,
    0xbd80_01a9,
    0xa540_0204,
    0x5b60_00c2,
    0x2990_025f,
    0x4b48_01fe,
    0x7a64_0036,
    0xa90e_011a,
    0x449f_0084,
    0xe9c7_83ed,
    0x36bb_4266,
    0xd93f_e34d,
    0xc77f_3259,
    0x4390_68ec,
    0xac53_ce7e,
    0xaff7_e199,
    0x585b_33e3,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0xd000_0000,
    0x7800_0000,
    0x9c00_0000,
    0x2a00_0000,
    0x9500_0000,
    0x2080_0000,
    0xb940_0000,
    0x27e0_0000,
    0xb990_0000,
    0xebd8_0000,
    0xa7bc_0000,
    0x3cea_0000,
    0x9a07_0000,
    0xfd17_8000,
    0x2483_4000,
    0xdf47_a000,
    0xe0f8_9000,
    0x9011_e800,
    0x580b_1c00,
    0xac1d_8200,
    0x8214_4300,
    0x7108_2380,
    0x9687_d340,
    0x065c_49e0,
    0x9264_8e70,
    0x2043_eaa8,
    0x7560_1d54,
    0x39d8_0102,
    0x6ebc_02a5,
    0xd66a_02ff,
    0x6647_03d6,
    0x8277_82e7,
    0xb853_42ba,
    0x397f_a0d9,
    0x6bd4_92d9,
    0x67a3_ebe9,
    0xdcf0_1c91,
    0x4a00_024d,
    0x8500_00fb,
    0xb880_029c,
    0xf540_02d6,
    0x75e0_0057,
    0xb090_0282,
    0xe158_01e5,
    0x8bfc_031f,
    0x3b8a_01a6,
    0x9ad7_024f,
    0x312f_80ee,
    0x3aaf_405b,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0xb000_0000,
    0xb800_0000,
    0x3400_0000,
    0xca00_0000,
    0x5900_0000,
    0x8a80_0000,
    0x81c0_0000,
    0x58e0_0000,
    0x3790_0000,
    0x0958_0000,
    0xec3c_0000,
    0xabe6_0000,
    0x941f_0000,
    0x5a02_8000,
    0xb113_4000,
    0xb68a_2000,
    0xc7c0_d000,
    0xffef_f800,
    0x2e09_7c00,
    0x5b04_8200,
    0xbf9c_4300,
    0x4550_a380,
    0xf22f_92c0,
    0x88e3_dae0,
    0xff86_acd0,
    0x6551_f928,
    0xa22a_7e64,
    0x80e0_03aa,
    0x7390_03c7,
    0x9b58_0003,
    0x313c_02ce,
    0x5366_01ed,
    0x78df_0204,
    0x4262_83ad,
    0x5e43_4133,
    0x6db2_2221,
    0x9dac_d01d,
    0x05b1_fb9c,
    0x61ba_7c71,
    0xa3b8_0375,
    0x76ac_0258,
    0x023e_012b,
    0x10e3_00aa,
    0x9b84_8047,
    0xa75c_42c3,
    0x7730_a02e,
    0xf47f_913d,
    0x615b_d92c,
    0x102a_aec9,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0xf000_0000,
    0x9800_0000,
    0x6c00_0000,
    0xaa00_0000,
    0xcb00_0000,
    0xdc80_0000,
    0x1840_0000,
    0xece0_0000,
    0x9390_0000,
    0x5ad8_0000,
    0x19bc_0000,
    0x32ee_0000,
    0x5e9b_0000,
    0x0749_8000,
    0xe677_4000,
    0x82c4_6000,
    0x55bd_1000,
    0x88f7_c800,
    0xfd87_bc00,
    0x2fc7_8200,
    0x383c_4300,
    0x0f35_e380,
    0xd1a6_53c0,
    0x16e5_aa60,
    0x108d_adb0,
    0x624f_c8a8,
    0xafeb_bc2c,
    0x4b11_82f2,
    0x1c8b_40a1,
    0xf84a_6253,
    0x1cf6_103e,
    0x0b86_49a3,
    0x36dc_fefa,
    0xb3b5_e311,
    0xf9e6_5137,
    0x8205_ab5c,
    0x1f1d_ae76,
    0x0a97_c8b3,
    0x1157_bdce,
    0x0f7f_80ab,
    0x9150_4106,
    0xcf63_e2fb,
    0x7151_5012,
    0x3f7a_2951,
    0xe94d_ed5b,
    0x5374_2ac2,
    0x4346_eec9,
    0x9865_aa9f,
    0x9fcd_ae3c,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x3000_0000,
    0xe800_0000,
    0x6400_0000,
    0x2a00_0000,
    0x9b00_0000,
    0x0580_0000,
    0x2fc0_0000,
    0x18a0_0000,
    0xd490_0000,
    0x6158_0000,
    0xcae4_0000,
    0x5ff6_0000,
    0x0b75_0000,
    0xaa20_8000,
    0x40cf_4000,
    0x2f34_6000,
    0xcc43_3000,
    0x026f_3800,
    0x68b0_b400,
    0xdc8e_8200,
    0x155e_4300,
    0x38e2_e080,
    0x48f9_70c0,
    0x40fb_dba0,
    0x34fc_c590,
    0xc6f5_daa8,
    0xd1fd_c56c,
    0x9a7b_5a96,
    0x04a3_877f,
    0x8299_b942,
    0x7c5a_f502,
    0x2a62_600d,
    0x2ca6_3317,
    0xc697_bae1,
    0x665b_f7ae,
    0x596c_e3d4,
    0x4d38_7212,
    0xc355_5965,
    0xe5f2_855b,
    0x886f_3927,
    0x03b0_b7d9,
    0x110e_836a,
    0x6e9e_40ae,
    0xe242_e13b,
    0x6369_71f8,
    0x0e23_d90b,
    0x4ad8_c7c0,
    0x8423_d94f,
    0x21d8_c67a,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x5000_0000,
    0xd800_0000,
    0x2c00_0000,
    0xa200_0000,
    0x6500_0000,
    0xe480_0000,
    0xa8c0_0000,
    0xd2e0_0000,
    0x2b90_0000,
    0x9d48_0000,
    0xf0bc_0000,
    0xc6ba_0000,
    0x3da3_0000,
    0x2621_8000,
    0x737a_4000,
    0x97d9_a000,
    0x8f7c_1000,
    0xadd9_d800,
    0x267e_3c00,
    0xbb53_8200,
    0x33a5_4100,
    0xa122_2380,
    0x12f5_5140,
    0x8b89_fb60,
    0x2d54_6cb0,
    0x78a1_f888,
    0x32b8_6c94,
    0xb3b3_fa12,
    0xe137_6ee3,
    0xf2e0_79ab,
    0xdb92_2c5e,
    0xf542_5a1d,
    0x54a7_7ea6,
    0x90ab_a0e0,
    0xd6a3_1331,
    0x05a2_5a29,
    0x5a37_7fa4,
    0x0963_a31b,
    0xdedf_13d6,
    0xc9f8_5a09,
    0x6004_7d74,
    0x100a_22a3,
    0x3819_518a,
    0x7c1b_fb6f,
    0x7a1b_6cf5,
    0x4912_79c3,
    0x468d_2ffb,
    0xcdd9_d826,
    0x367e_3ee1,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x5000_0000,
    0xc800_0000,
    0x1400_0000,
    0x8200_0000,
    0xc100_0000,
    0x1480_0000,
    0x8dc0_0000,
    0x61a0_0000,
    0xe390_0000,
    0x4a58_0000,
    0xd1e4_0000,
    0x5f7a_0000,
    0x0fb1_0000,
    0xcc8e_8000,
    0xb1c6_4000,
    0x87af_2000,
    0x3883_1000,
    0x43c2_7800,
    0xdea2_d400,
    0xf00c_8200,
    0x5803_4300,
    0xfc03_a080,
    0xc610_5140,
    0x8b19_db20,
    0xc196_8450,
    0x1b4f_5808,
    0x2d74_c404,
    0x96ba_7ad2,
    0x2416_d477,
    0xfa0e_8026,
    0x6d06_419e,
    0x1a8f_2081,
    0x12d3_1153,
    0x223a_7807,
    0x39d6_d55d,
    0x73ae_82ee,
    0xca96_437a,
    0x1ad7_2263,
    0x1637_135c,
    0xebc0_7bfd,
    0x7aa7_d7dd,
    0xca00_00ae,
    0x1500_00da,
    0xb680_0373,
    0x1cc0_0274,
    0xbd20_00a9,
    0x7a50_0187,
    0xa9f8_039d,
    0xf374_020e,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x5000_0000,
    0x5800_0000,
    0x3c00_0000,
    0xe200_0000,
    0x4d00_0000,
    0xcd80_0000,
    0xadc0_0000,
    0x8ae0_0000,
    0x6690_0000,
    0x4358_0000,
    0x6da4_0000,
    0xf53a_0000,
    0x4963_0000,
    0xfc4b_8000,
    0x552a_4000,
    0xd97c_a000,
    0x8457_3000,
    0x3939_7800,
    0x637d_3c00,
    0xf549_8200,
    0x16bd_4300,
    0x83b5_2080,
    0xb22a_7140,
    0xddec_5960,
    0x4a07_4cf0,
    0xb91d_d988,
    0x6b8e_0e34,
    0x6eca_f9b6,
    0xb063_7cf7,
    0x77d7_21cb,
    0x4bed_732a,
    0x611d_db65,
    0x978e_0d32,
    0xacca_f80a,
    0xad63_7d56,
    0xe257_23e4,
    0xda2d_710d,
    0x09fd_da95,
    0xbc1e_0d3a,
    0x2212_f8fe,
    0x6d07_7e40,
    0x9d8d_20c3,
    0xf5de_705e,
    0xb6ee_59b3,
    0x8490_4e35,
    0x0e54_58c9,
    0xa033_4d08,
    0x58ff_da57,
    0xc389_0f38,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x9000_0000,
    0x5800_0000,
    0xd400_0000,
    0xee00_0000,
    0xab00_0000,
    0x1b80_0000,
    0x4a40_0000,
    0x3fa0_0000,
    0xca50_0000,
    0x7fa8_0000,
    0xaa5c_0000,
    0xefba_0000,
    0xf257_0000,
    0x3ba0_8000,
    0x1c4a_c000,
    0x90b5_e000,
    0x07c9_b000,
    0xdafc_a800,
    0x386e_4400,
    0x10b5_e200,
    0x47c9_b100,
    0xbafc_a980,
    0xa86e_4640,
    0x48b5_e360,
    0x93c9_b250,
    0x54fc_aa38,
    0x036e_44ec,
    0x5335_e30e,
    0xd989_b379,
    0x6b5c_aac6,
    0xc93e_47c5,
    0x2c9d_e2f0,
    0x73d5_b1d0,
    0x84e6_a978,
    0x3b69_440c,
    0x173d_621e,
    0x6f9f_71a1,
    0x1453_4b3a,
    0x3ca0_f413,
    0xcdc1_c975,
    0x57f1_3540,
    0x04e6_a978,
    0x7b69_440c,
    0x773d_621e,
    0xff9f_71a1,
    0x4c53_4b3a,
    0xe8a0_f413,
    0x23c1_c975,
    0xfcf1_3540,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x1000_0000,
    0x5800_0000,
    0x9c00_0000,
    0xe200_0000,
    0x8b00_0000,
    0x5280_0000,
    0x56c0_0000,
    0x4a60_0000,
    0xb6d0_0000,
    0x3a68_0000,
    0xded4_0000,
    0xee6a_0000,
    0xf8df_0000,
    0x1b79_8000,
    0xc343_4000,
    0x9428_e000,
    0x8d69_1000,
    0x3e52_3800,
    0x4bb8_5c00,
    0x6c28_e200,
    0x4169_1100,
    0xa452_3880,
    0x4cb8_5c40,
    0x84a8_e360,
    0x00a9_1370,
    0x5eb2_3b08,
    0x27a8_5e6c,
    0xa620_e22a,
    0x3e6d_122b,
    0xc0d0_3a21,
    0xb773_5cb7,
    0x695b_62c3,
    0xdb25_5150,
    0xa1eb_5998,
    0x0186_0f54,
    0xd858_3aae,
    0xdeb7_5e5d,
    0x67b9_61c8,
    0x863e_5061,
    0x2e70_d8d7,
    0x98de_4e33,
    0x2b6b_5998,
    0x8b46_0f54,
    0x5038_3aae,
    0xf367_5e5d,
    0x5751_61c8,
    0x922a_5061,
    0x687a_d8d7,
    0x5dd1_4e33,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0xb000_0000,
    0x4800_0000,
    0x4400_0000,
    0xca00_0000,
    0x0d00_0000,
    0x2880_0000,
    0x5140_0000,
    0xd8a0_0000,
    0x5950_0000,
    0xbcb8_0000,
    0xc34c_0000,
    0x49ae_0000,
    0xe7c5_0000,
    0x96e6_8000,
    0xf87c_4000,
    0xea37_2000,
    0x3d01_5000,
    0xa091_0800,
    0xf544_4400,
    0xa2b7_2200,
    0x1c41_5300,
    0xd031_0b80,
    0x5814_46c0,
    0x9c0f_2320,
    0x960d_5210,
    0x7b1f_08a8,
    0xe391_46f4,
    0xfac9_a382,
    0x6661_1355,
    0xf530_2bca,
    0x448c_1791,
    0xaf4e_a970,
    0xb7ac_5458,
    0x88cf_88ec,
    0x4774_070e,
    0x03ae_00ab,
    0x2ac5_0179,
    0x5e66_8064,
    0x193c_41ea,
    0x7a97_2081,
    0x2051_5358,
    0xd629_08ec,
    0x3b08_470e,
    0xc399_20ab,
    0xaac4_5179,
    0x9e77_8864,
    0xf938_05ea,
    0xca80_0281,
    0x6840_0058,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x1000_0000,
    0xa800_0000,
    0xac00_0000,
    0xe600_0000,
    0x0900_0000,
    0x3880_0000,
    0xe2c0_0000,
    0x50a0_0000,
    0xead0_0000,
    0x2cb8_0000,
    0x84d4_0000,
    0x99ba_0000,
    0xf241_0000,
    0xde6f_8000,
    0x7c7d_c000,
    0xdf7e_a000,
    0x38e2_d000,
    0x53a6_f800,
    0xdd4a_c400,
    0xcffe_a200,
    0xb622_d300,
    0xc506_f880,
    0x2e9a_c440,
    0x73c6_a0a0,
    0x7c36_d1b0,
    0xea1c_fb18,
    0x3f0b_c464,
    0xb991_2042,
    0x665f_123b,
    0xfc78_5a5a,
    0x1f78_17cf,
    0x18e0_58f0,
    0x43bc_1428,
    0x7542_5a3c,
    0x63f9_1706,
    0x502f_db09,
    0xcc11_d599,
    0x1604_fbe1,
    0x910f_c555,
    0x2c93_21df,
    0x00ca_12c8,
    0x13ad_da3c,
    0x3d44_d706,
    0xfff1_7b09,
    0x0e23_0599,
    0xc11a_03e1,
    0x6491_0155,
    0x9cd7_83df,
    0x4da9_c1c8,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x3000_0000,
    0x4800_0000,
    0x6400_0000,
    0xea00_0000,
    0xc500_0000,
    0x4f80_0000,
    0x75c0_0000,
    0x3b60_0000,
    0xa1d0_0000,
    0xd968_0000,
    0xe0cc_0000,
    0x4cee_0000,
    0x1805_0000,
    0x5c02_8000,
    0x2608_4000,
    0x7b12_2000,
    0x289d_b000,
    0x9b5a_9800,
    0xeb33_dc00,
    0x2a72_2200,
    0x0c4d_b100,
    0xedb2_9b80,
    0x4e3f_dcc0,
    0x15fc_2320,
    0xd198_b090,
    0x82d8_1828,
    0x4dfb_9fd4,
    0x6d80_021e,
    0x94c0_0147,
    0x7ee0_00c5,
    0x2110_0153,
    0xe588_037b,
    0x50dc_03c4,
    0x44e6_0276,
    0x9c19_01f3,
    0x8604_832b,
    0xab01_42cc,
    0x509e_a032,
    0xb740_f245,
    0x6522_3878,
    0x056a_2cb7,
    0x86d4_9a76,
    0xd7e6_ddf3,
    0x0098_a12b,
    0x8f49_f3cc,
    0xa92e_bbb2,
    0xbb77_6e85,
    0xe1cc_3b58,
    0x396f_2c27,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x9000_0000,
    0x5800_0000,
    0x5400_0000,
    0x7200_0000,
    0xcf00_0000,
    0xf280_0000,
    0x9940_0000,
    0xcfa0_0000,
    0xfb50_0000,
    0x98b8_0000,
    0x7dd4_0000,
    0xe3ea_0000,
    0x257f_0000,
    0xbe30_8000,
    0x5689_4000,
    0xc35d_6000,
    0xbcad_1000,
    0xe7c9_4800,
    0xb0f0_6400,
    0xa9e5_6200,
    0xce79_1300,
    0xd6a3_4880,
    0x9ccf_6640,
    0x8075_e360,
    0x37a0_5250,
    0xff46_2948,
    0x92b6_757c,
    0x76d6_a8aa,
    0x3b6f_3435,
    0x2733_c876,
    0xf116_2591,
    0xfb90_8248,
    0x66d9_4382,
    0xa365_6099,
    0x5339_1354,
    0x1303_4bf8,
    0x6c9f_64a4,
    0xc04d_e3be,
    0x4834_53d3,
    0x538c_2b71,
    0x1ad9_75a6,
    0x6d7e_2819,
    0x7222_7514,
    0x509c_a898,
    0xee40_36f4,
    0xd93b_4af6,
    0xd80b_66af,
    0x9407_e3db,
    0x521b_5193,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x7000_0000,
    0xd800_0000,
    0xdc00_0000,
    0x6200_0000,
    0xdf00_0000,
    0x2c80_0000,
    0x1540_0000,
    0xbe60_0000,
    0x2b50_0000,
    0x4368_0000,
    0x38cc_0000,
    0x0aa6_0000,
    0x4bf7_0000,
    0x438d_8000,
    0x41c3_4000,
    0xe732_6000,
    0x5f2c_d000,
    0xb321_c800,
    0xe921_9c00,
    0x9a3a_6200,
    0x0cb0_d100,
    0x1aef_cb80,
    0xea1a_9dc0,
    0x0b11_e160,
    0xda84_9270,
    0xdc50_2a08,
    0x2bf5_0ebc,
    0x7382_49d2,
    0x79c9_de25,
    0x4b2b_82f1,
    0xe534_4311,
    0xb03f_e15f,
    0xa7af_9206,
    0x5073_a83b,
    0x9e5d_4d8e,
    0x24f3_ab39,
    0x171d_4fcd,
    0x1893_a87d,
    0x934d_4c6b,
    0xaf7b_aad6,
    0x62c1_4d5d,
    0x79bd_abbb,
    0xdd66_4c4e,
    0x55d8_2859,
    0xb129_0cbd,
    0x062c_49f5,
    0x8ea2_df17,
    0xb5e8_0264,
    0x1e8c_0108,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x3000_0000,
    0x9800_0000,
    0xa400_0000,
    0x5a00_0000,
    0x3300_0000,
    0xdf80_0000,
    0x4ac0_0000,
    0xa960_0000,
    0xa4d0_0000,
    0x2868_0000,
    0xd444_0000,
    0x732e_0000,
    0xc6f7_0000,
    0x360a_8000,
    0x8504_4000,
    0x1a80_e000,
    0xf045_b000,
    0x6928_b800,
    0x55e1_1c00,
    0xd988_e200,
    0x57d1_b100,
    0x17ee_ba80,
    0x0e92_1cc0,
    0x724c_6060,
    0x5e32_f390,
    0xe06c_dbe8,
    0x3847_ec0c,
    0x8522_3b1e,
    0xa3e5_5ebb,
    0xbc88_034d,
    0xdd54_039f,
    0x4fa6_033f,
    0x5ba3_002a,
    0xd9ac_8061,
    0xeea7_43d4,
    0x5b2c_626f,
    0xbae2_f0a2,
    0x6804_d87d,
    0xdc03_ef62,
    0x6e0c_3978,
    0xc112_5f81,
    0xd082_82e1,
    0x6b50_4314,
    0x8aa6_e00f,
    0xe126_b232,
    0x19e4_3915,
    0x1f96_5fae,
    0xaacc_8206,
    0x3977_42aa,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0xd000_0000,
    0x0800_0000,
    0x8400_0000,
    0xea00_0000,
    0x8f00_0000,
    0x9c80_0000,
    0x2ec0_0000,
    0x8620_0000,
    0x18d0_0000,
    0xaf38_0000,
    0x4554_0000,
    0xa862_0000,
    0xf635_0000,
    0x00c2_8000,
    0x0320_4000,
    0xfb4f_6000,
    0xc56d_d000,
    0x61b1_b800,
    0x589c_9400,
    0x24d7_6200,
    0xf929_d300,
    0x5c4b_b880,
    0x0ded_9740,
    0xad6f_e220,
    0xd5b8_9110,
    0x4a9c_5b28,
    0xf7c1_057c,
    0x03b1_b852,
    0x939c_95ab,
    0x7257_6330,
    0x88e9_d21f,
    0x4eeb_b86e,
    0xbffd_94fe,
    0x6e77_e131,
    0x073c_9097,
    0xd146_5be5,
    0x6a60_04de,
    0x2d31_3b06,
    0x7e59_d505,
    0x26e2_8009,
    0x0bf0_4264,
    0x7c77_61b1,
    0xd439_d3d7,
    0x2bd3_bbc5,
    0xa5a9_96ce,
    0x5295_e0ae,
    0x5bc9_9339,
    0xbda4_d87b,
    0xfe90_45df,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x7000_0000,
    0x2800_0000,
    0x2c00_0000,
    0x8200_0000,
    0x6100_0000,
    0xbc80_0000,
    0x5e40_0000,
    0xbba0_0000,
    0x8850_0000,
    0x8ca8_0000,
    0x43cc_0000,
    0xf966_0000,
    0xfda9_0000,
    0xe753_8000,
    0x4321_4000,
    0x980b_a000,
    0xa404_d000,
    0x3e1b_6800,
    0xbb1b_2400,
    0xd983_a200,
    0x4cd8_d100,
    0x06f5_6b80,
    0xee6e_25c0,
    0xe63e_22a0,
    0x2a8c_91b0,
    0x8943_4988,
    0x003e_b444,
    0xd593_6852,
    0x1ec7_24c9,
    0xdfed_a166,
    0x26ed_d365,
    0x3e68_ebe0,
    0x5e2a_6506,
    0x5e80_01a3,
    0x0f40_01e3,
    0xcf20_02d5,
    0x8a10_013e,
    0x9d08_0139,
    0x869c_028e,
    0x4b4e_01b1,
    0x8125_014a,
    0x1915_8223,
    0x6898_4023,
    0x4850_2275,
    0x2cb9_918e,
    0xd3de_cb31,
    0xa17a_f70a,
    0xf9ad_4943,
    0x494b_b533,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x1000_0000,
    0xa800_0000,
    0x8c00_0000,
    0xbe00_0000,
    0x4100_0000,
    0x3180_0000,
    0x05c0_0000,
    0x9ae0_0000,
    0xe4d0_0000,
    0x7b78_0000,
    0x6914_0000,
    0x7d9a_0000,
    0x9bd1_0000,
    0xcbf3_8000,
    0x7d52_c000,
    0xf2a1_a000,
    0x4de5_f000,
    0xd842_9800,
    0xd13c_6c00,
    0xa73b_a200,
    0x9a34_f300,
    0x8db1_1880,
    0xfd6e_ac40,
    0xcc1a_00a0,
    0x5e11_0130,
    0x7113_8278,
    0x8982_c144,
    0x21d9_a266,
    0xa8f1_f227,
    0x1bd8_9893,
    0x0bed_6e97,
    0x5d48_232b,
    0xe2a6_32b3,
    0xe5f0_bb1d,
    0x545b_5dbc,
    0x6f20_9a62,
    0xe639_6d61,
    0xabb2_2244,
    0x8867_311c,
    0x679b_3aa8,
    0x28cd_9cd6,
    0x2563_3965,
    0x1819_9cf8,
    0xf419_3804,
    0xba18_9f46,
    0x6312_bad7,
    0x669e_5f8b,
    0xf949_1983,
    0x10ba_ae65,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x9000_0000,
    0x1800_0000,
    0x9400_0000,
    0xbe00_0000,
    0xa700_0000,
    0x3980_0000,
    0x6a40_0000,
    0x6c60_0000,
    0x5550_0000,
    0x81e8_0000,
    0x2104_0000,
    0xda9a_0000,
    0x55d7_0000,
    0xa520_8000,
    0xa6a4_c000,
    0x8dfe_6000,
    0x4b1c_f000,
    0x6397_a800,
    0x5b4f_bc00,
    0xeee4_6200,
    0x348b_f100,
    0x0ad7_2a80,
    0x38bb_7e40,
    0xfaf2_0260,
    0xca93_0350,
    0x0dda_8078,
    0x9123_c0dc,
    0x88b6_e086,
    0x32fc_33f9,
    0xe693_cb49,
    0xb7d4_4fc9,
    0x903b_48e1,
    0x8224_8c2d,
    0xdf37_2a5b,
    0x47ab_7f42,
    0xb77a_0073,
    0x2ec7_030e,
    0x4ea8_8145,
    0x71f0_c2f7,
    0x490c_6164,
    0x668f_f292,
    0xf7cd_2a23,
    0x302c_7f9e,
    0x1232_80f5,
    0xc727_c0f7,
    0xd3ac_e20c,
    0x096b_313e,
    0x89d3_4b85,
    0x7720_8fbf,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0xd000_0000,
    0x0800_0000,
    0x9400_0000,
    0x3600_0000,
    0xbd00_0000,
    0x2880_0000,
    0xa9c0_0000,
    0x60a0_0000,
    0x2cd0_0000,
    0xc438_0000,
    0x4f1c_0000,
    0x6b82_0000,
    0xc84d_0000,
    0x07e8_8000,
    0x50b7_c000,
    0x34cd_2000,
    0x3837_d000,
    0x3d04_9800,
    0xe88a_0400,
    0xc9cf_2200,
    0xb0ba_d300,
    0x24cc_1980,
    0x502d_c740,
    0x791a_0220,
    0xd681_0150,
    0xe0d2_8158,
    0xae26_c1b4,
    0x3007_a082,
    0x181d_10f7,
    0xfc19_395a,
    0x7216_1647,
    0x8304_99b2,
    0x018a_049b,
    0xb74f_23ac,
    0x747a_d3d2,
    0x64ec_1aaf,
    0x413d_c56e,
    0xeb82_0385,
    0x084d_0065,
    0x67e8_8111,
    0x80b7_c1f3,
    0x3ccd_22f4,
    0xac37_d266,
    0x0b04_9a2d,
    0x558a_0599,
    0xe14f_22df,
    0x197a_d222,
    0x446c_1aa3,
    0x7cfd_c668,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0xb000_0000,
    0x0800_0000,
    0xf400_0000,
    0xc600_0000,
    0xe900_0000,
    0xd680_0000,
    0xf240_0000,
    0x0620_0000,
    0x4f50_0000,
    0x86a8_0000,
    0x8c1c_0000,
    0x1a1e_0000,
    0x0b0d_0000,
    0x4188_8000,
    0x31d9_c000,
    0x10e3_a000,
    0x9432_1000,
    0xf05b_6800,
    0x613e_1400,
    0xe4dd_a200,
    0xd46f_1100,
    0x997b_e980,
    0x71fb_d6c0,
    0xf6a0_0220,
    0xa410_02d0,
    0x3e08_0298,
    0x750c_0164,
    0x5496_037a,
    0xd541_0019,
    0xcdbe_8300,
    0xad88_c299,
    0x9bd5_2140,
    0x13f6_d1f9,
    0x21b8_4870,
    0x0799_c511,
    0x98d3_691c,
    0xa672_17f7,
    0xd66b_a3ab,
    0xfe7e_11bc,
    0xda6d_6b67,
    0xa46f_1453,
    0xb16b_22e8,
    0x55eb_d075,
    0x88b8_c866,
    0xb10c_06ee,
    0xda86_c92b,
    0xa851_05e5,
    0x6d26_4807,
    0xbed4_c77a,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x7000_0000,
    0xc800_0000,
    0xfc00_0000,
    0xc600_0000,
    0xa500_0000,
    0x7a80_0000,
    0xc640_0000,
    0x8ee0_0000,
    0x2f50_0000,
    0x9a68_0000,
    0xe014_0000,
    0x1006_0000,
    0x981d_0000,
    0x4411_8000,
    0xf201_c000,
    0x9f0b_2000,
    0x1997_9000,
    0x19cc_6800,
    0x323e_8c00,
    0x67ed_2200,
    0x3bda_9100,
    0x5535_e880,
    0x6a6b_4dc0,
    0x6800_0120,
    0xcc00_02f0,
    0x2e00_0398,
    0x2900_0354,
    0x7480_02ca,
    0x9f40_00e9,
    0x3260_0123,
    0x4c10_0229,
    0x6e08_0383,
    0x0904_0099,
    0x048e_027b,
    0x5759_02dd,
    0xce7f_8379,
    0x8a08_c048,
    0xcb1c_a23c,
    0x738b_5206,
    0xc2d6_c977,
    0xd9a8_df00,
    0xe12a_69e3,
    0x1073_8d89,
    0x2b14_a3b3,
    0x638f_51a1,
    0x5ad8_cb9f,
    0x9db1_ddef,
    0x1335_ebd4,
    0x8f6b_4d69,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0xb000_0000,
    0x5800_0000,
    0xac00_0000,
    0x6e00_0000,
    0x4100_0000,
    0x2380_0000,
    0x46c0_0000,
    0x2220_0000,
    0x33d0_0000,
    0x23a8_0000,
    0x4a04_0000,
    0x8b1e_0000,
    0xe89f_0000,
    0x0e43_8000,
    0x9c66_c000,
    0xf7ad_a000,
    0x7811_b000,
    0x5c1c_f800,
    0x9602_3400,
    0x5d13_a200,
    0x159e_b100,
    0xabd7_7a80,
    0x6fb0_f6c0,
    0x3408_0360,
    0x2214_03b0,
    0x3f16_0338,
    0x8a8b_03c4,
    0x9155_81ee,
    0xa6ed_c3ab,
    0x3ef8_2130,
    0x72fc_71cb,
    0x0ce4_d800,
    0xa5fe_4433,
    0x7277_78a4,
    0xf6a0_f66d,
    0xfb80_0037,
    0xaac0_0099,
    0xec20_0212,
    0xc2d0_0232,
    0x5828_0191,
    0xa0c4_039d,
    0xc73e_039c,
    0x9a4f_01a9,
    0x0e6b_83d9,
    0x90a2_c232,
    0x5e93_a1a2,
    0xa35e_b139,
    0x71f7_78f1,
    0x4060_f51e,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x5000_0000,
    0x4800_0000,
    0x0c00_0000,
    0xca00_0000,
    0xfb00_0000,
    0xb180_0000,
    0x5ec0_0000,
    0xc960_0000,
    0xc1d0_0000,
    0xaee8_0000,
    0x4604_0000,
    0x7102_0000,
    0xea9d_0000,
    0xbf4b_8000,
    0xdfb0_4000,
    0x04ae_e000,
    0xa537_7000,
    0x13f8_b800,
    0x8689_1c00,
    0xc54c_e200,
    0x9cba_7100,
    0xa13b_3a80,
    0x75ed_5d40,
    0xe788_0320,
    0xc7d4_0130,
    0x7fea_01a8,
    0xfc99_02ac,
    0x8649_83e6,
    0x392d_414b,
    0x71e5_600d,
    0x8187_30eb,
    0xa6d6_587d,
    0x7d7e_6c63,
    0x1fd4_58e1,
    0xdbe3_6dad,
    0xca9f_d8c6,
    0xaf53_2e26,
    0x37b1_3876,
    0x58a4_5d4e,
    0x2729_803a,
    0xe4fd_42f8,
    0xfd0d_6149,
    0x6083_3301,
    0xe454_5920,
    0x3e23_6e6d,
    0x127f_dafb,
    0x6043_2ce5,
    0x1839_3967,
    0xd370_5eab,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xf000_0000,
    0xa800_0000,
    0xfc00_0000,
    0xaa00_0000,
    0x6300_0000,
    0x1880_0000,
    0xbb40_0000,
    0xa6e0_0000,
    0x7a50_0000,
    0x9168_0000,
    0xfb94_0000,
    0xe3d6_0000,
    0x3db1_0000,
    0x2cb1_8000,
    0x4338_4000,
    0x96ef_e000,
    0xb254_5000,
    0xbd7c_0800,
    0x0997_4c00,
    0xd4d1_e200,
    0x7331_5100,
    0x5efb_8880,
    0x9e4e_0fc0,
    0x4f67_80a0,
    0x3e89_42f0,
    0x9a5e_6228,
    0x016c_124c,
    0x8393_eac2,
    0x47c3_1d1d,
    0xc3ad_ea33,
    0x19a6_1d65,
    0x92aa_68a7,
    0x563f_5fc3,
    0xb77c_0934,
    0xda97_4c2f,
    0x4451_e07f,
    0xc471_525e,
    0xfa1b_893e,
    0x7b1e_0d6e,
    0x6c8f_82b6,
    0x1d5d_4152,
    0xc7e8_639c,
    0xfdcd_11a3,
    0x98aa_6a1d,
    0x853f_5db3,
    0x27fc_0925,
    0x6dd7_4e47,
    0xe0b1_e2d3,
    0x2121_528c,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0xd000_0000,
    0xd800_0000,
    0x2400_0000,
    0xf200_0000,
    0x2b00_0000,
    0x7f80_0000,
    0xb2c0_0000,
    0x2420_0000,
    0x03d0_0000,
    0xbca8_0000,
    0xb084_0000,
    0xdf52_0000,
    0xcdef_0000,
    0x506e_8000,
    0xf1bd_4000,
    0xfe0d_e000,
    0xb517_b000,
    0xfa86_3800,
    0xe04e_f400,
    0xe877_e200,
    0xe5bc_b100,
    0xa41a_ba80,
    0xb20c_b740,
    0x8b1c_8160,
    0xaf82_4190,
    0x6acb_6148,
    0x002e_f3ec,
    0xf1d9_da9e,
    0x97b6_465b,
    0xcf1f_5958,
    0x6d8f_05a3,
    0xe9c0_bb8c,
    0x53b7_b649,
    0x4d08_000d,
    0x4e94_01e8,
    0x6a5a_019b,
    0x377b_0278,
    0xb034_81d3,
    0x19c6_4314,
    0x1bb9_600d,
    0x1111_f22f,
    0x489f_5bc5,
    0x6b4f_0544,
    0x47e0_ba65,
    0x8f67_b5b3,
    0xa420_01c3,
    0x43d0_015b,
    0x1ca8_031f,
    0x6084_033d,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x5000_0000,
    0xd800_0000,
    0x4c00_0000,
    0x2200_0000,
    0xdf00_0000,
    0x2680_0000,
    0x8ec0_0000,
    0xb0e0_0000,
    0xefd0_0000,
    0x7378_0000,
    0xf494_0000,
    0x19d2_0000,
    0x227f_0000,
    0x5f13_8000,
    0xe687_4000,
    0xaed6_6000,
    0xe0ea_9000,
    0x37c1_3800,
    0x3f63_4c00,
    0xd69c_6200,
    0xc6d1_9300,
    0x04f8_b880,
    0xd1cf_0d40,
    0x566b_8160,
    0x4113_4230,
    0x9384_6008,
    0xc355_923c,
    0x26b2_bbfa,
    0xf4f4_0f0b,
    0x99d2_004b,
    0xe27f_03c3,
    0x7f13_81d7,
    0xb687_40a9,
    0x76d6_61c4,
    0xacea_9206,
    0x15c1_3839,
    0xe063_4f34,
    0xf01c_6046,
    0x4811_9231,
    0xb418_bbe0,
    0x3e1f_0d98,
    0x2513_814c,
    0xb587_417a,
    0x8a56_60a3,
    0xe12a_910f,
    0x79a1_3885,
    0x1273_4e8e,
    0x3704_60ad,
    0x0295_900a,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x3000_0000,
    0x6800_0000,
    0xec00_0000,
    0xfa00_0000,
    0xfb00_0000,
    0x6180_0000,
    0x89c0_0000,
    0xd920_0000,
    0x34d0_0000,
    0x01a8_0000,
    0x3384_0000,
    0x7ece_0000,
    0xd2b9_0000,
    0x1e0b_8000,
    0x3d1a_4000,
    0x9896_e000,
    0xa755_7000,
    0x4f63_5800,
    0x893a_9400,
    0x8cd0_e200,
    0x15b8_7100,
    0x7d8e_da80,
    0xfbdd_d4c0,
    0x5e23_83a0,
    0xf75e_42b0,
    0xf778_e168,
    0x9d3c_732c,
    0xc2c0_d826,
    0x90a4_d597,
    0xf108_028c,
    0x1294_023f,
    0x9446_0300,
    0xf2ed_0229,
    0x92ed_833f,
    0x42e7_4029,
    0xbaf3_6396,
    0x0ee6_33d6,
    0x70f6_3a1f,
    0x9de1_a7f0,
    0xfd63_5821,
    0xee3a_9703,
    0xdf50_e0d7,
    0xbb78_73c5,
    0x572e_da10,
    0x51cd_d5f1,
    0x1d2b_837b,
    0x82ca_4223,
    0x30be_e0a7,
    0xc111_720d,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0xf000_0000,
    0x6800_0000,
    0x6c00_0000,
    0x6200_0000,
    0x6900_0000,
    0xc280_0000,
    0xf2c0_0000,
    0x5e60_0000,
    0x7dd0_0000,
    0x3bf8_0000,
    0x269c_0000,
    0xccc6_0000,
    0x5d61_0000,
    0x4a43_8000,
    0x01b9_4000,
    0x8f3c_a000,
    0x4fe2_1000,
    0x809a_7800,
    0xcbd4_1c00,
    0x64e2_a200,
    0x7b0f_1300,
    0x0387_f980,
    0x3c40_5fc0,
    0x3ea3_83a0,
    0x22a9_42b0,
    0xe8a4_a008,
    0x8dae_1264,
    0xdd24_7aaa,
    0x2ee9_1e7b,
    0xde07_22f1,
    0x3307_5353,
    0x3f80_da65,
    0xa647_0c91,
    0xa3a3_59ea,
    0x862e_4e32,
    0x7d67_fbce,
    0x1a50_5df8,
    0xf9bb_8025,
    0x7b25_42f1,
    0x29fa_a3fa,
    0xe783_110a,
    0x0259_f862,
    0x3dad_5f96,
    0x153e_00c4,
    0xd2fd_0233,
    0x2405_835c,
    0x5e18_4006,
    0xf31f_2295,
    0x5f8b_5250,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0xf000_0000,
    0xb800_0000,
    0xac00_0000,
    0x4600_0000,
    0x6b00_0000,
    0xdf80_0000,
    0xbec0_0000,
    0x1fa0_0000,
    0x37d0_0000,
    0x9938_0000,
    0x8784_0000,
    0x82c6_0000,
    0xb1a3_0000,
    0xb8db_8000,
    0x14a7_c000,
    0xb85c_e000,
    0x6ff5_3000,
    0x8c29_b800,
    0x5f1b_8400,
    0x0582_e200,
    0x8bc2_3300,
    0xf72c_3a80,
    0xa88b_47c0,
    0xff5b_80e0,
    0x3667_c1b0,
    0xf9fc_e398,
    0x6f25_326c,
    0x3491_b99e,
    0xa15f_844b,
    0x0164_e366,
    0xd871_3273,
    0x16ef_bb9a,
    0xb2b8_8725,
    0x4359_6295,
    0x5865_f3a9,
    0xd6f0_db1f,
    0x12be_7420,
    0xb352_3b74,
    0xe06c_4432,
    0x7ae6_0135,
    0x54b3_009d,
    0xd843_838d,
    0x3ff3_c205,
    0xc422_e061,
    0x4b12_32db,
    0xef94_390a,
    0xa6cf_47ed,
    0x43bd_81d1,
    0xc9d4_c143,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0xb000_0000,
    0xa800_0000,
    0x0c00_0000,
    0x2200_0000,
    0x2700_0000,
    0xf880_0000,
    0x65c0_0000,
    0x4c60_0000,
    0xdd50_0000,
    0x49b8_0000,
    0x8124_0000,
    0x8cfe_0000,
    0x6c89_0000,
    0x23db_8000,
    0xe573_4000,
    0x90d6_6000,
    0x5bf7_d000,
    0x5c09_9800,
    0x5a18_3c00,
    0x930d_e200,
    0xce84_9300,
    0xc4df_fa80,
    0xbdef_eec0,
    0x4504_78a0,
    0xbf9c_af30,
    0x8d52_1808,
    0x31ab_7d5c,
    0x353b_81c2,
    0xbae3_4067,
    0xcd8e_6199,
    0xd243_d119,
    0x7d2f_98ec,
    0x66e5_3f3f,
    0x5790_6268,
    0xe15a_d0cc,
    0x03ac_19fa,
    0x0a22_7db3,
    0xe660_00c7,
    0x8650_029c,
    0x9b38_00e2,
    0x7fe4_0317,
    0xb21e_03f1,
    0xff19_01d5,
    0xfc83_8116,
    0xfbc7_428c,
    0xe170_62af,
    0x0eca_d250,
    0xf6f4_1918,
    0x8f96_7ea4,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0xd000_0000,
    0x7800_0000,
    0x7c00_0000,
    0xe200_0000,
    0x1100_0000,
    0x0b80_0000,
    0x7ec0_0000,
    0xf960_0000,
    0x2550_0000,
    0xbfa8_0000,
    0x402c_0000,
    0xa8e2_0000,
    0x968b_0000,
    0x9f41_8000,
    0xa2b5_4000,
    0xe1a8_a000,
    0x1325_b000,
    0x827a_3800,
    0x4bde_3c00,
    0x1ce9_2200,
    0xe090_f100,
    0x8852_9b80,
    0xf63b_8f40,
    0x1ff3_1be0,
    0xf21e_ccf0,
    0xc913_ba08,
    0x4787_7e04,
    0x34c3_804e,
    0xec6e_424b,
    0xb0c1_220d,
    0x327c_f261,
    0xa3d0_98b8,
    0xf8e0_8d4f,
    0xae9a_98e0,
    0x0347_8e70,
    0x90b9_1ac8,
    0x88b9_cca4,
    0x64b0_385e,
    0x1eb9_3c33,
    0xa3aa_a3c1,
    0x323e_b30b,
    0x21f3_baed,
    0x3117_7c11,
    0x7b8b_8270,
    0x36d2_41eb,
    0x2d6b_20be,
    0xc34b_f243,
    0x30bb_1909,
    0xb8a2_cfaf,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0xf000_0000,
    0x1800_0000,
    0x3c00_0000,
    0x3e00_0000,
    0x9900_0000,
    0xd380_0000,
    0x13c0_0000,
    0x3ee0_0000,
    0x5850_0000,
    0x5128_0000,
    0xb8ac_0000,
    0x6066_0000,
    0x2207_0000,
    0xf70d_8000,
    0x4286_c000,
    0x1449_a000,
    0x3739_3000,
    0xfda1_1800,
    0x7df1_4c00,
    0xb0c4_2200,
    0x267f_f100,
    0x3708_bb80,
    0xe298_7fc0,
    0x044d_3a60,
    0xdf22_bdf0,
    0xd9aa_9978,
    0x7fe0_8ca4,
    0x17c8_02ae,
    0x6cfc_027f,
    0xf74e_03e3,
    0xcfab_0035,
    0x62eb_8292,
    0xd641_c039,
    0x3024_22cc,
    0xa72f_f3c2,
    0x55a0_b92d,
    0xb9f4_7ec6,
    0x42cb_3a6f,
    0x9975_bed7,
    0x418f_196f,
    0x1cca_4c57,
    0xb067_a12f,
    0x6a02_33f7,
    0xc302_9bbf,
    0xa88c_8eff,
    0x974e_00a3,
    0x7fab_0115,
    0x9aeb_8242,
    0x1a41_c391,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x9000_0000,
    0x9800_0000,
    0x6400_0000,
    0x2e00_0000,
    0xab00_0000,
    0xfc80_0000,
    0xe6c0_0000,
    0xf8a0_0000,
    0x2650_0000,
    0xf468_0000,
    0x2bec_0000,
    0x8daa_0000,
    0x39d7_0000,
    0xf22a_8000,
    0xef88_c000,
    0x4e50_e000,
    0xd879_d000,
    0x19e2_f800,
    0xfcbb_2400,
    0xd85a_6200,
    0x2761_1100,
    0x237a_1b80,
    0xdd7e_f640,
    0x0e7a_9860,
    0x06e1_3490,
    0x5620_f938,
    0x6180_25ec,
    0x955a_e012,
    0x2cfe_d14b,
    0x0320_7aba,
    0x4e1f_e5e5,
    0x7b00_80fb,
    0x849f_c108,
    0x12da_611e,
    0x4ea1_1309,
    0xe95a_1a69,
    0x26ee_f583,
    0x6632_9984,
    0x899d_341c,
    0xf942_f83a,
    0xfeeb_24df,
    0xe232_63a4,
    0x378d_12ec,
    0xca50_1892,
    0x6669_f58b,
    0x2af0_1b1a,
    0x6439_f555,
    0x1098_1833,
    0x74d5_f4cc,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x9000_0000,
    0xa800_0000,
    0x6c00_0000,
    0xf200_0000,
    0xdf00_0000,
    0x4280_0000,
    0x15c0_0000,
    0x5720_0000,
    0x6350_0000,
    0x04e8_0000,
    0xed64_0000,
    0x5c2a_0000,
    0x57d9_0000,
    0xf023_8000,
    0x45dd_4000,
    0x1f39_6000,
    0x3f4a_9000,
    0xcef0_9800,
    0xf676_1400,
    0x80ba_e200,
    0x6f07_d100,
    0x3a81_fa80,
    0x71c8_8640,
    0x5928_78a0,
    0xe65c_c4b0,
    0xf57a_9b48,
    0x483f_143c,
    0xc1d1_632a,
    0x212e_92a7,
    0x825a_9ab4,
    0xfb6f_1501,
    0xcd39_6271,
    0x304a_902e,
    0x8470_986e,
    0x1fb6_15b9,
    0x8d9a_e325,
    0xbf57_d3c8,
    0x8ee9_f90b,
    0x566c_86a6,
    0x10a2_7832,
    0xc715_c4c3,
    0x5691_1ada,
    0x83d6_54b8,
    0x862a_0354,
    0xa4d9_02e6,
    0xe0a3_83e5,
    0x1f1d_415f,
    0xa299_61b7,
    0x25da_92bb,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x5000_0000,
    0x4800_0000,
    0x4c00_0000,
    0xd600_0000,
    0x6300_0000,
    0x9f80_0000,
    0xbf40_0000,
    0xb6a0_0000,
    0x76d0_0000,
    0x2ae8_0000,
    0xffe4_0000,
    0xb372_0000,
    0x2ba5_0000,
    0x764f_8000,
    0x6425_c000,
    0xc102_e000,
    0x3e8b_b000,
    0x31d5_c800,
    0x3f70_0400,
    0x1da5_6200,
    0xe54a_7100,
    0xe3a5_2a80,
    0x7a5e_b540,
    0x123f_2b20,
    0xf21f_b430,
    0xe902_abd8,
    0xc29f_75cc,
    0x5fcf_cbde,
    0x0871_078d,
    0x5038_e022,
    0xa31a_b127,
    0x7f80_4a2d,
    0x4f54_c4fe,
    0xaeba_0211,
    0x72d1_0234,
    0xb0f5_800e,
    0x4af4_c185,
    0x4ff7_60e6,
    0x0b7f_71bd,
    0x7fa2_aafa,
    0xa44f_766b,
    0x9d27_c8b3,
    0xeb95_0653,
    0x7d4a_e103,
    0xa7bf_b14b,
    0x404f_c92f,
    0xf731_0645,
    0x4698_e12a,
    0x85ca_b063,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x3000_0000,
    0x9800_0000,
    0x6400_0000,
    0x0600_0000,
    0x6500_0000,
    0x5580_0000,
    0xb640_0000,
    0x1760_0000,
    0x15d0_0000,
    0x7c28_0000,
    0x633c_0000,
    0x71be_0000,
    0x9167_0000,
    0x30de_8000,
    0x49b1_c000,
    0xe569_2000,
    0xfecb_f000,
    0xe0a1_2800,
    0x4af2_bc00,
    0x4f9f_a200,
    0xc146_3100,
    0xd9f6_0980,
    0xc71e_4cc0,
    0x1680_0860,
    0xd6d5_4c90,
    0x5ca8_8b98,
    0x48ef_8c54,
    0x1c89_28b6,
    0x69ce_be89,
    0x5e21_a1a5,
    0x6021_3193,
    0x7128_8b5e,
    0xeaaf_8f91,
    0xf5e9_28b5,
    0x4d1e_bdcf,
    0xe989_a3a0,
    0xb45d_3270,
    0x4476_8948,
    0xbd58_8fec,
    0xfbff_ab52,
    0xc403_7e97,
    0x1616_8090,
    0xad1d_c09c,
    0x999f_209e,
    0x4c40_f171,
    0x1069_aa65,
    0x2358_7e77,
    0xfaf6_0044,
    0x978b_026e,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x1000_0000,
    0x6800_0000,
    0x5c00_0000,
    0xaa00_0000,
    0x5d00_0000,
    0x9180_0000,
    0x3440_0000,
    0x04a0_0000,
    0xf7d0_0000,
    0x19e8_0000,
    0xf4fc_0000,
    0x3d7a_0000,
    0x4d39_0000,
    0xc79d_8000,
    0xf35e_4000,
    0xd023_2000,
    0x7613_f000,
    0xb716_e800,
    0xac8b_c400,
    0xb5d6_a200,
    0x58f1_b100,
    0xaf6f_c980,
    0x4431_3440,
    0xb015_cba0,
    0x5808_3470,
    0x4408_4928,
    0x8e16_7434,
    0xc30b_6866,
    0x3a95_84e1,
    0x52d5_809a,
    0xfc72_429b,
    0x56b1_20a9,
    0xded6_f346,
    0x1e71_69a9,
    0x27ac_863e,
    0x9d48_0185,
    0x432c_0364,
    0x4492_0006,
    0xa9c5_0071,
    0x92e7_80e2,
    0xe267_4137,
    0xbdbe_a0b3,
    0xd84d_b0e5,
    0xf6b5_ca8c,
    0xeed8_3452,
    0x0660_4887,
    0x03aa_767b,
    0x0351_6b01,
    0xe83c_87b2,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xf000_0000,
    0xc800_0000,
    0x6400_0000,
    0x9a00_0000,
    0xfd00_0000,
    0xa680_0000,
    0xecc0_0000,
    0x8620_0000,
    0x0850_0000,
    0xabe8_0000,
    0xcef4_0000,
    0x7466_0000,
    0x8ea5_0000,
    0xfb8e_8000,
    0xfa58_4000,
    0x82f0_2000,
    0x1a7c_1000,
    0xf1bc_f800,
    0xfc18_7400,
    0x8616_a200,
    0xeb10_5100,
    0x558a_d880,
    0xe551_67c0,
    0x556c_d920,
    0x5e34_6490,
    0x3442_58e8,
    0x4dfc_2534,
    0xf5fa_7b3a,
    0x19e4_34e3,
    0xc7e8_81d0,
    0x50fd_4085,
    0xc37e_a1fd,
    0xed24_512c,
    0x1dcc_d81b,
    0x6ea4_67cc,
    0x6b8a_59ab,
    0xe258_25b4,
    0xdef4_7b77,
    0x2c75_343a,
    0xf2a0_00ee,
    0x3d90_0269,
    0x3148_014b,
    0x2764_0089,
    0x372e_0176,
    0xc0c1_0008,
    0x3820_8384,
    0x4f59_42c2,
    0x0070_a07f,
    0x4cb5_523e,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x9000_0000,
    0x8800_0000,
    0x7400_0000,
    0x6e00_0000,
    0x2f00_0000,
    0x7f80_0000,
    0x4c40_0000,
    0xfea0_0000,
    0xc9d0_0000,
    0x23e8_0000,
    0x8ffc_0000,
    0x3dea_0000,
    0xf8e5_0000,
    0xde68_8000,
    0x3eba_c000,
    0xe9dc_6000,
    0xd3eb_b000,
    0x97f0_2800,
    0xc1ed_8400,
    0xe2fc_e200,
    0x9f7d_7100,
    0x6e2e_4980,
    0xda1f_3640,
    0x610e_4820,
    0xa08f_34d0,
    0x2bc6_4a38,
    0x4ee3_37fc,
    0x2d64_485e,
    0xab2a_37a1,
    0xfc8e_cbe2,
    0x81c9_f50b,
    0x77f0_2969,
    0x11ed_8522,
    0x0afc_e2eb,
    0x7b7d_73d9,
    0x882e_4bea,
    0x811f_37ff,
    0x708e_4843,
    0xc3cf_34e9,
    0xaae6_4962,
    0xcb73_37cb,
    0xf02c_4889,
    0xed06_3492,
    0xe28c_c8a3,
    0xf6d0_f70d,
    0x9472_a910,
    0xd7b2_468c,
    0x3d48_02f6,
    0x962c_0345,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x9000_0000,
    0xe800_0000,
    0xfc00_0000,
    0x1200_0000,
    0x6700_0000,
    0xf480_0000,
    0xeac0_0000,
    0xbe60_0000,
    0x4050_0000,
    0xf9b8_0000,
    0x89bc_0000,
    0x31ba_0000,
    0x45b9_0000,
    0x3ba9_8000,
    0xa6a9_4000,
    0xc938_6000,
    0xc568_5000,
    0xf6c7_7800,
    0xfc63_7c00,
    0xaf49_e200,
    0x612d_1300,
    0x997d_1980,
    0x14ce_2e40,
    0xe37d_19a0,
    0x4fce_2cf0,
    0x65fd_1bc8,
    0x520e_2cdc,
    0xc71d_1bf2,
    0x049e_2d1b,
    0x92c5_1a91,
    0xaa72_2e2d,
    0xae47_185c,
    0x8cb7_2ea1,
    0x1a34_9985,
    0x2ff7_6c90,
    0x111d_7a4b,
    0xc58a_7d3a,
    0x1f58_6147,
    0xb938_51a3,
    0x7d7f_7b56,
    0x82df_7cdd,
    0x8273_e294,
    0x3254_10fd,
    0x0eb4_99b7,
    0x9537_6c6b,
    0x277d_7a8a,
    0xe9da_7faf,
    0x1ce0_634f,
    0xab84_500c,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0xf000_0000,
    0x3800_0000,
    0x7c00_0000,
    0xb200_0000,
    0xaf00_0000,
    0xb880_0000,
    0x54c0_0000,
    0x4a60_0000,
    0x8a50_0000,
    0x77b8_0000,
    0xc1ac_0000,
    0x80b6_0000,
    0x3533_0000,
    0xbe65_8000,
    0x5c5b_4000,
    0x06a7_6000,
    0xac3b_d000,
    0x87f7_b800,
    0x5d01_7c00,
    0x379a_e200,
    0xfc5c_9300,
    0xd6be_db80,
    0x8435_afc0,
    0x33e6_dae0,
    0xab09_aef0,
    0x5688_db48,
    0x59c6_ae7c,
    0x95e3_5b82,
    0x2202_ec63,
    0xa717_ba81,
    0x1c91_7da5,
    0x6ac2_e094,
    0x6f60_91d9,
    0xe1d0_d861,
    0x29fa_af22,
    0x700d_58c4,
    0xf80d_ed41,
    0x9c1c_3b45,
    0x4205_3c64,
    0x970e_0191,
    0xc49f_019d,
    0xe6d3_8160,
    0xe568_4147,
    0x32c2_e0b0,
    0x2360_9168,
    0x8bd0_dbec,
    0x0afa_aefa,
    0x428d_5a37,
    0x7fcd_ed4f,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0xd000_0000,
    0xc800_0000,
    0x1400_0000,
    0x8e00_0000,
    0xcf00_0000,
    0x7d80_0000,
    0x5bc0_0000,
    0x5320_0000,
    0x4950_0000,
    0x8578_0000,
    0xb9ac_0000,
    0x9312_0000,
    0x279d_0000,
    0xfac4_8000,
    0x31b2_c000,
    0xa712_6000,
    0x9984_f000,
    0x2ddf_5800,
    0x9026_3400,
    0x66c4_e200,
    0x8bab_3300,
    0xd609_bb80,
    0x3310_0740,
    0xd789_d920,
    0x02c9_f750,
    0x3db2_03b8,
    0xf50d_037c,
    0xcc9c_8156,
    0x114e_c27f,
    0x7978_6054,
    0x13b5_f249,
    0xca09_d9db,
    0x4909_f4b5,
    0x4692_00f6,
    0x785d_03d4,
    0x0fe4_8332,
    0x73e2_c045,
    0x19ea_61e5,
    0xa0e8_f04e,
    0x1e6d_5b28,
    0x6a2b_3524,
    0x37d8_631a,
    0x1125_f2e1,
    0x3451_dbbf,
    0x7df5_f68f,
    0x16f8_0147,
    0x3d6c_01d3,
    0x95b2_01c1,
    0xf10d_01d4,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x3000_0000,
    0xa800_0000,
    0x6400_0000,
    0x9600_0000,
    0x2300_0000,
    0x0f80_0000,
    0x5040_0000,
    0xc860_0000,
    0x0cd0_0000,
    0x9fb8_0000,
    0xa0fc_0000,
    0x550e_0000,
    0xdc81_0000,
    0x97c6_8000,
    0xcc21_c000,
    0xfaad_e000,
    0xd477_b000,
    0xa6d8_a800,
    0x86ae_9c00,
    0x4e65_6200,
    0x17d7_7300,
    0x0c33_c980,
    0x9ab8_ecc0,
    0xe470_28a0,
    0x0ede_5e90,
    0xe2b6_01d8,
    0xd87d_034c,
    0x34c8_831e,
    0x03a0_c011,
    0xcaeb_63d9,
    0x2c16_712f,
    0x0215_4818,
    0x7d09_2f4e,
    0x7885_c84b,
    0x61c5_ed00,
    0xdf38_a880,
    0x5d3e_9e40,
    0xe03d_61e0,
    0xf8bb_70f0,
    0xa965_c8e8,
    0xde55_ef84,
    0xe760_aa4a,
    0x9152_9f63,
    0x4aeb_6386,
    0xec16_711f,
    0x6215_4a72,
    0x4d09_2cdf,
    0xd085_c870,
    0x05c5_ee8a,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x9000_0000,
    0x5800_0000,
    0x0400_0000,
    0x8200_0000,
    0x0500_0000,
    0x0580_0000,
    0x5240_0000,
    0x42e0_0000,
    0xcad0_0000,
    0x7128_0000,
    0xe874_0000,
    0x340a_0000,
    0x0a07_0000,
    0x7916_8000,
    0x1389_4000,
    0x8d4b_2000,
    0x4670_7000,
    0x1f0a_a800,
    0x6480_4c00,
    0x65d7_a200,
    0xddbe_3100,
    0xd1b7_0880,
    0x6fa9_7e40,
    0x5cbe_2b60,
    0x163a_0d10,
    0x18e0_0088,
    0x8bd0_0354,
    0xd6a8_01f6,
    0x2f34_0319,
    0x2b6a_0263,
    0x9697_032f,
    0xc8de_83da,
    0x342d_42fc,
    0xcde9_21cd,
    0xf643_724a,
    0x10f6_292b,
    0xb7de_0cc4,
    0xe0a2_0121,
    0x6033_0390,
    0x77fc_81c8,
    0x475e_43b4,
    0x5f75_a326,
    0xbc8d_3231,
    0x21cb_8b07,
    0x7fb7_3d21,
    0x44ab_8a8f,
    0x3227_3ef5,
    0x0ae3_8939,
    0xd6c3_3c8c,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x3000_0000,
    0x9800_0000,
    0x3400_0000,
    0x2200_0000,
    0x2b00_0000,
    0xbd80_0000,
    0x7940_0000,
    0x2fe0_0000,
    0x57d0_0000,
    0xaf28_0000,
    0x1b64_0000,
    0xf81e_0000,
    0xe40f_0000,
    0x2a14_8000,
    0xb711_4000,
    0x3390_e000,
    0x4455_7000,
    0x9b6e_0800,
    0xb807_2c00,
    0x441a_6200,
    0x1a0b_3100,
    0x2f0a_6a80,
    0x0793_1cc0,
    0x664c_8860,
    0xb07d_6dd0,
    0x0580_0008,
    0x3d40_016c,
    0x35e0_0216,
    0x78d0_01f5,
    0xa8a8_0257,
    0x7d24_0123,
    0x487e_00c2,
    0xe19f_0124,
    0x175c_81a9,
    0x82e5_432a,
    0x4b46_e2ab,
    0xecee_73ee,
    0xe64c_8992,
    0xf07d_6eec,
    0xa580_0325,
    0x0d40_02ac,
    0xade0_03f6,
    0x4cd0_0365,
    0x8aa8_007f,
    0x5624_033f,
    0xf5fe_026c,
    0x98df_00e5,
    0x38bc_834c,
    0xd535_4166,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0xd000_0000,
    0x6800_0000,
    0x2400_0000,
    0xaa00_0000,
    0x9300_0000,
    0xf480_0000,
    0xc4c0_0000,
    0x8da0_0000,
    0xb750_0000,
    0xcff8_0000,
    0x5124_0000,
    0x3792_0000,
    0x9841_0000,
    0xcd6a_8000,
    0x40f2_4000,
    0x83b3_e000,
    0x4e53_5000,
    0x0869_b800,
    0xb16e_4400,
    0x16eb_6200,
    0x86b0_1300,
    0x1fc8_da80,
    0x4d2b_5740,
    0x1183_3ba0,
    0x255c_0790,
    0xd0f8_8228,
    0x8bb3_420c,
    0x1a59_60f2,
    0x1a61_10c3,
    0x6e7a_593e,
    0x6c6d_1401,
    0x7b7a_d845,
    0xf5fa_571b,
    0xca31_b9ba,
    0x971a_47ef,
    0x4e81_631c,
    0x9fd5_124a,
    0x8d30_5867,
    0xb198_1780,
    0xf55a_5910,
    0xb8fd_1768,
    0xafa2_daac,
    0xb04e_55e2,
    0x897b_b9ab,
    0x9aef_4692,
    0xa8a1_e263,
    0xf6d2_532e,
    0x42a3_39e9,
    0x05cc_05a9,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x1000_0000,
    0x2800_0000,
    0xcc00_0000,
    0x4a00_0000,
    0x8100_0000,
    0x6180_0000,
    0x4a40_0000,
    0xdee0_0000,
    0x2ed0_0000,
    0x8338_0000,
    0x6974_0000,
    0x678a_0000,
    0x4159_0000,
    0x1e7f_8000,
    0x151e_4000,
    0x3f94_a000,
    0x5558_f000,
    0x8072_2800,
    0x2a12_cc00,
    0x7101_2200,
    0x798f_b300,
    0xbe41_0880,
    0x70f0_7c40,
    0x29d5_aaa0,
    0x29a8_8c30,
    0xc3a7_83a8,
    0x92ba_4144,
    0xfb26_a1a6,
    0x6d75_f259,
    0xd187_aaf3,
    0xb255_8d8f,
    0x1aea_00a2,
    0xb8c9_0188,
    0x6027_83e3,
    0x45fa_40d7,
    0x0646_a1ae,
    0x54e5_f27a,
    0x8fdf_aa44,
    0xf2b1_8ff1,
    0x0b38_0060,
    0x7574_03d0,
    0x258a_02b8,
    0x1c59_001c,
    0x1dff_82aa,
    0x125e_42ab,
    0xcaf4_a3d4,
    0xb0c8_f2e9,
    0xbc2a_29cc,
    0x27f6_cf12,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0xf000_0000,
    0x9800_0000,
    0xe400_0000,
    0x7600_0000,
    0xb500_0000,
    0xe380_0000,
    0xae40_0000,
    0xfe20_0000,
    0x94d0_0000,
    0x09e8_0000,
    0x1bbc_0000,
    0x5786_0000,
    0x9057_0000,
    0xa72e_8000,
    0x8d53_c000,
    0x18b1_2000,
    0x2112_3000,
    0x4d9b_a800,
    0x9f4a_1400,
    0x9bb9_a200,
    0x1786_f100,
    0xf04c_0980,
    0x5727_e7c0,
    0x155d_2860,
    0xfca5_d690,
    0x570e_8258,
    0xf883_c014,
    0x7cd9_206e,
    0x35ee_32e9,
    0xe9bd_a840,
    0x648d_1717,
    0x5edf_2071,
    0x0ef9_3103,
    0xab33_28a8,
    0xc74e_d56b,
    0x5fa6_0123,
    0xf187_0298,
    0x2d46_8143,
    0xc8af_c3bf,
    0x2917_231a,
    0xc195_3320,
    0x955d_2ab0,
    0xbca5_d668,
    0x370e_833c,
    0x0883_c072,
    0xe4d9_202b,
    0xd1ee_3203,
    0x9fbd_a828,
    0xd18d_172b,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x1000_0000,
    0xd800_0000,
    0x2400_0000,
    0x8200_0000,
    0x9100_0000,
    0xa280_0000,
    0x2f40_0000,
    0x1920_0000,
    0x0ed0_0000,
    0x1df8_0000,
    0x5e2c_0000,
    0xb74a_0000,
    0x1d3f_0000,
    0x7cca_8000,
    0x44f1_4000,
    0x00a1_a000,
    0x3e0a_9000,
    0x1718_8800,
    0x419f_d400,
    0xd4d9_2200,
    0x68e8_d300,
    0x9eb9_ab80,
    0x191b_0440,
    0x7e8a_8960,
    0x795c_d790,
    0xc221_a388,
    0xc14a_9104,
    0x3638_8a6a,
    0x7b4f_d46d,
    0x9321_230c,
    0x83c4_d1ef,
    0x0973_ab75,
    0xba64_07c1,
    0xb9e0_0953,
    0x1c3d_9762,
    0xc658_0268,
    0xafbc_0154,
    0x8b92_00c2,
    0x79c3_0199,
    0x8c78_827e,
    0xb2e2_428e,
    0xeba1_2257,
    0xd984_d3c9,
    0xd0d3_aa17,
    0x1af4_0568,
    0xc7b8_0915,
    0x4781_9610,
    0xf7ca_0109,
    0x737f_0076,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0xf000_0000,
    0xf800_0000,
    0x5c00_0000,
    0x2600_0000,
    0x0500_0000,
    0xf280_0000,
    0x9140_0000,
    0x4360_0000,
    0x08d0_0000,
    0x61b8_0000,
    0x8274_0000,
    0x9056_0000,
    0xfbe3_0000,
    0x6281_8000,
    0x795d_c000,
    0x3770_2000,
    0x7adf_1000,
    0xe6b1_4800,
    0x0fe9_1c00,
    0xd09f_a200,
    0xde55_d300,
    0x4af6_e880,
    0xc218_cfc0,
    0x9f07_49e0,
    0x019a_1e70,
    0x6ec6_2218,
    0x84ac_10d4,
    0xa0e8_c8aa,
    0x0910_dcf5,
    0x1c81_8075,
    0x105d_c247,
    0x3bf0_2254,
    0x429f_1398,
    0x8951_4b66,
    0xcf79_1cf9,
    0x26c7_a399,
    0xc0b1_d0db,
    0x0af8_e850,
    0x221f_cd88,
    0x4f08_c8bc,
    0x0980_dc66,
    0xcad9_818b,
    0xfeb9_c1aa,
    0x83fe_2087,
    0xfe98_11c6,
    0x7f5e_c95b,
    0xc263_dfe2,
    0x7058_03db,
    0x2be4_00d0,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0xd000_0000,
    0x5800_0000,
    0x3c00_0000,
    0x8200_0000,
    0x5300_0000,
    0x5c80_0000,
    0xd3c0_0000,
    0x67e0_0000,
    0xb650_0000,
    0x4fa8_0000,
    0x58ec_0000,
    0x70c2_0000,
    0x137f_0000,
    0x3191_8000,
    0x1e49_4000,
    0x5bba_e000,
    0x8ef6_5000,
    0x15d3_5800,
    0xfafe_8c00,
    0x53c1_6200,
    0x27ec_1100,
    0x565a_3b80,
    0x9fae_9f40,
    0x00f1_5b60,
    0x4cd1_8df0,
    0x9178_e388,
    0x6289_530c,
    0x42c2_db92,
    0x8877_ccff,
    0xe91b_80f7,
    0xa38a_4265,
    0xb541_61c4,
    0x0b2c_1020,
    0x573a_384e,
    0x453e_9d2b,
    0xae39_586f,
    0x1ead_8f8f,
    0x1772_e161,
    0x1f8a_521a,
    0x7759_5a2d,
    0xb83d_8eb6,
    0xdbba_e0b1,
    0xcef6_5302,
    0xf5d3_5959,
    0x2afe_8ea0,
    0x0bc1_6250,
    0x1bec_1258,
    0xd45a_3a14,
    0xccae_9ce6,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x7000_0000,
    0x3800_0000,
    0xdc00_0000,
    0x9200_0000,
    0x0f00_0000,
    0x9780_0000,
    0x7fc0_0000,
    0xee20_0000,
    0x4950_0000,
    0x8b78_0000,
    0xa824_0000,
    0x5046_0000,
    0x8deb_0000,
    0x9571_8000,
    0xbd33_4000,
    0x8cc1_6000,
    0x5bb9_3000,
    0xa191_5800,
    0x5ec4_5400,
    0x34ae_e200,
    0xe615_7300,
    0x691f_ba80,
    0x3e81_25c0,
    0xe149_5ae0,
    0x7f70_5470,
    0x0e30_e2c8,
    0x594a_72fc,
    0x6370_383e,
    0x3c2d_674f,
    0x2647_bb10,
    0xccf5_2569,
    0x9ff7_5abb,
    0x5a7f_55a3,
    0x8aa7_60c7,
    0x8302_335d,
    0x8d98_dbe8,
    0x34d3_17fd,
    0x47a9_83a9,
    0x9387_404a,
    0x21df_60bc,
    0x9b26_309e,
    0x45de_db9f,
    0x1538_1508,
    0x78d8_018d,
    0xfdb4_0261,
    0xa89e_0036,
    0xb05f_0142,
    0x9def_8331,
    0x7d6c_41ff,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x9000_0000,
    0x3800_0000,
    0x5400_0000,
    0x5a00_0000,
    0x0f00_0000,
    0xc680_0000,
    0x6040_0000,
    0x4aa0_0000,
    0x17d0_0000,
    0xd178_0000,
    0x38a4_0000,
    0xb4da_0000,
    0xb9eb_0000,
    0x9dfc_8000,
    0x0ff6_4000,
    0x5cf0_6000,
    0x3c77_1000,
    0x652f_a800,
    0xe813_e400,
    0x0c0e_e200,
    0x3e1e_5300,
    0xfd01_4a80,
    0xa59d_b640,
    0xa8d7_aae0,
    0x7ff7_e650,
    0x94f4_e1e8,
    0x6065_517c,
    0xc325_c97a,
    0xd11f_f691,
    0xcb85_caa2,
    0xcdcf_f633,
    0x1e7d_c9b7,
    0x5e2b_f41f,
    0x4487_c883,
    0xcb50_f729,
    0xde23_4910,
    0x8492_b4ae,
    0x6b51_2af7,
    0x4e3a_a759,
    0xbc80_0208,
    0x3f40_008a,
    0x1420_0149,
    0xb390_0226,
    0xf9d8_013d,
    0x7474_0370,
    0xf922_03be,
    0xee0f_017f,
    0xa506_8135,
    0xc18d_40fa,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x3000_0000,
    0xb800_0000,
    0x3400_0000,
    0x9200_0000,
    0xdd00_0000,
    0xff80_0000,
    0xdcc0_0000,
    0x9e20_0000,
    0xee30_0000,
    0x7628_0000,
    0x9234_0000,
    0x8832_0000,
    0xd925_0000,
    0x80a3_8000,
    0x1371_c000,
    0xafca_6000,
    0x62a5_9000,
    0x5676_0800,
    0xb441_cc00,
    0xa476_0a00,
    0x9941_cf00,
    0x03f6_0980,
    0x4181_cfc0,
    0xb7d6_0b60,
    0x46b1_cf10,
    0xac7e_0928,
    0xd545_cc64,
    0x45ec_0ad6,
    0x3e90_cf17,
    0x2d47_88ae,
    0x51e5_0caf,
    0x7c97_e976,
    0x7851_9ee7,
    0x2270_6356,
    0x0644_9183,
    0xa96f_8b54,
    0xeed1_0ece,
    0x5325_e86b,
    0x79b4_9c84,
    0x16f3_e052,
    0x1205_5245,
    0x1d0d_e86b,
    0x1f80_9c84,
    0xecc1_e052,
    0x2620_5245,
    0xda2e_686b,
    0xe431_5c84,
    0x4f2b_8052,
    0x77b5_c245,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0xb000_0000,
    0x0800_0000,
    0xcc00_0000,
    0x9200_0000,
    0xb900_0000,
    0x1080_0000,
    0xf3c0_0000,
    0xb420_0000,
    0xe430_0000,
    0x1c38_0000,
    0xb834_0000,
    0x5622_0000,
    0x7523_0000,
    0x10ba_8000,
    0x61e8_c000,
    0x9f1f_e000,
    0xdf8d_f000,
    0xd45b_8800,
    0xc461_0c00,
    0xce5b_8a00,
    0xf161_0d00,
    0x2cdb_8b80,
    0x0ba1_0fc0,
    0x807b_8ba0,
    0xd051_0cf0,
    0xba63_89e8,
    0x3555_0e14,
    0xe0f9_89aa,
    0x0b82_0ddb,
    0x1241_0b7a,
    0xfb79_ce4b,
    0x81dc_6b0a,
    0xfd28_fcab,
    0x9cba_0252,
    0x93e7_017f,
    0x9600_8010,
    0xc70f_c1f8,
    0xeb9f_63ec,
    0xe242_3046,
    0x9364_e89d,
    0xfdd3_3c67,
    0x6727_63ec,
    0xe9b6_3046,
    0x1166_e89d,
    0xdcc0_3c67,
    0x63a5_e3ec,
    0xfc6a_f046,
    0x4a5b_089d,
    0xcf6e_cc67,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x9000_0000,
    0x9800_0000,
    0xec00_0000,
    0x2a00_0000,
    0x2700_0000,
    0xa980_0000,
    0x0940_0000,
    0x11e0_0000,
    0x99f0_0000,
    0x2de8_0000,
    0x8be4_0000,
    0x16f6_0000,
    0x0065_0000,
    0x4cb8_8000,
    0x7e1d_c000,
    0xd109_2000,
    0xcc84_1000,
    0x63c9_3800,
    0xef39_0400,
    0x6049_3a00,
    0x0179_0700,
    0xb829_3b80,
    0x01c9_0540,
    0x1c21_39e0,
    0xffdd_06f0,
    0x0d3f_3948,
    0x535c_066c,
    0xfef1_bbee,
    0x2464_c649,
    0x72a0_1ba9,
    0x0f0d_142e,
    0xed88_031e,
    0xa754_0201,
    0xf8fe_0145,
    0x4971_0100,
    0x6c26_81f7,
    0x37dc_c2b8,
    0x1927_a0d3,
    0x054c_d23a,
    0x6bf0_99f4,
    0x46f4_d51a,
    0xf877_20d3,
    0x30b5_123a,
    0xcc0f_b9f4,
    0x1a15_c51a,
    0x4f06_98d3,
    0x4d91_d63a,
    0x574f_a3f4,
    0xf0e8_d21a,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x1000_0000,
    0xf800_0000,
    0x8400_0000,
    0x2600_0000,
    0xa700_0000,
    0x3a80_0000,
    0x9ec0_0000,
    0x4fe0_0000,
    0x87f0_0000,
    0x4bf8_0000,
    0xe1e4_0000,
    0x0ce6_0000,
    0xcb79_0000,
    0x6a29_8000,
    0x008d_4000,
    0xcbc9_a000,
    0xec66_f000,
    0x10b9_2800,
    0x7e5a_d400,
    0x9439_2a00,
    0x939a_d500,
    0xdf59_2980,
    0xb9aa_d540,
    0x3fc1_2a60,
    0x627e_d750,
    0x2bbf_2af8,
    0xf6d3_d5cc,
    0x73e8_aa12,
    0xc5f3_97b7,
    0xdaf6_8b2d,
    0x8475_25a8,
    0x2cb1_8202,
    0x3c59_422f,
    0x0537_a031,
    0xf60b_f002,
    0xff0e_aa19,
    0x4e8a_9440,
    0x50df_08d6,
    0x94f8_64e1,
    0x1f78_238c,
    0x543f_b3c4,
    0x338e_88d6,
    0x2f51_24e1,
    0x51b7_838c,
    0x43d0_43c4,
    0xc066_20d6,
    0xaaa2_b0e1,
    0x6b41_098c,
    0xd7a5_66c4,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x3000_0000,
    0x2800_0000,
    0x3400_0000,
    0x7600_0000,
    0x5300_0000,
    0xb180_0000,
    0x5740_0000,
    0xf5e0_0000,
    0x4bf0_0000,
    0x7cf8_0000,
    0x837c_0000,
    0xab3a_0000,
    0x855f_0000,
    0x88e9_8000,
    0x957f_4000,
    0xe839_2000,
    0x2ccd_1000,
    0xc3b4_f800,
    0x2291_c400,
    0x86cc_fa00,
    0xb2ad_c500,
    0xa616_fa80,
    0x2b02_c5c0,
    0xbd87_7a20,
    0x0d41_8510,
    0xcce4_5bf8,
    0xeb63_945c,
    0xbf21_213e,
    0xc341_1101,
    0xf3f6_f8e9,
    0x10f2_c52e,
    0xc97f_7b9a,
    0x8a3d_86e3,
    0x39de_5916,
    0x093c_94e6,
    0xf048_a24d,
    0x527e_532f,
    0x5faf_d8f3,
    0x208f_d68d,
    0x83d3_806c,
    0x6020_43b5,
    0x68d0_a273,
    0xbdb2_534d,
    0x758d_da4c,
    0x695c_d6a5,
    0x82f8_018b,
    0x947c_0311,
    0x64ba_0172,
    0x851f_02a4,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x5000_0000,
    0x9800_0000,
    0x0c00_0000,
    0x6a00_0000,
    0x8500_0000,
    0x3080_0000,
    0xd7c0_0000,
    0x7ae0_0000,
    0x9cf0_0000,
    0x33f8_0000,
    0xa67c_0000,
    0x1136_0000,
    0x2405_0000,
    0xce14_8000,
    0x0b11_c000,
    0x1b85_6000,
    0x9c49_7000,
    0x7ea0_8800,
    0xee5e_5400,
    0xb7b8_8a00,
    0x94d2_5500,
    0xb576_8a80,
    0x46ab_5440,
    0xf254_08e0,
    0x65bf_9470,
    0x4dc5_e948,
    0x77e7_2664,
    0x1860_018a,
    0xd230_013b,
    0xab98_0261,
    0x344c_0248,
    0x9aae_022e,
    0x4049_0191,
    0xccba_800a,
    0x4758_c131,
    0xbd3f_e29a,
    0x5e11_b309,
    0xf31f_6a36,
    0x678f_e627,
    0x3e47_e027,
    0x6fad_b2ed,
    0xb8c9_68b6,
    0x8f7a_e667,
    0x5bab_62c7,
    0xcec0_739d,
    0xd87a_0b7e,
    0xb236_9443,
    0xdb9f_6bad,
    0xfc4f_e6d6,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0xd000_0000,
    0x4800_0000,
    0xa400_0000,
    0xb600_0000,
    0x6900_0000,
    0x5680_0000,
    0x1840_0000,
    0x4e20_0000,
    0xcc30_0000,
    0xbb28_0000,
    0xd0ac_0000,
    0xb076_0000,
    0x631f_0000,
    0xa59b_8000,
    0x15d5_4000,
    0x0ffc_6000,
    0xeddc_b000,
    0xd3fe_b800,
    0x47cf_fc00,
    0x30f6_ba00,
    0x2253_ff00,
    0x0528_ba80,
    0xfda0_fc40,
    0xa0e5_3ba0,
    0x8a5a_bed0,
    0x512a_d978,
    0xd3bf_4f74,
    0x25fe_0022,
    0xcec3_0315,
    0x9665_831a,
    0xa216_4325,
    0xa719_e176,
    0x238a_f327,
    0xc4c7_5a97,
    0x6575_0c3b,
    0xaf99_e0d9,
    0xe6ca_f2c8,
    0x0267_5b3c,
    0xac05_0d5e,
    0xf211_e2eb,
    0x2f16_f1a1,
    0xa799_59bc,
    0xa2c6_0d1e,
    0x4474_634b,
    0x5d00_b071,
    0x4880_ba44,
    0x254c_fe2a,
    0x36b3_38c9,
    0x5175_bdb4,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x3000_0000,
    0x3800_0000,
    0xc400_0000,
    0xe600_0000,
    0x8500_0000,
    0x2380_0000,
    0x39c0_0000,
    0x84e0_0000,
    0x5ef0_0000,
    0x19f8_0000,
    0xc96c_0000,
    0x5e2a_0000,
    0x3c8d_0000,
    0xfd45_8000,
    0x5db1_4000,
    0x7545_e000,
    0xe1bf_9000,
    0xf753_a800,
    0xb2b1_b400,
    0x69cb_aa00,
    0x6ced_b500,
    0x32f9_a880,
    0x33fc_b5c0,
    0x566e_2860,
    0xdaac_f6d0,
    0x45c4_4bf8,
    0xe6ef_24c4,
    0x9df7_8376,
    0x8f60_4023,
    0xeb32_6365,
    0x271f_d058,
    0x0081_c982,
    0x3f5e_67bd,
    0xaeb2_621a,
    0xdbdf_d15f,
    0x07e1_caf7,
    0x686e_67fd,
    0x0baa_63cc,
    0x8843_d24c,
    0xa633_c9fa,
    0x188f_6539,
    0x8b45_e34c,
    0xd0bf_938c,
    0xaad3_ab9a,
    0xfa71_b6e9,
    0x10ab_a834,
    0x4add_b688,
    0x6a61_aa8c,
    0x18a0_b51a,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x5000_0000,
    0x8800_0000,
    0xac00_0000,
    0x5e00_0000,
    0x2d00_0000,
    0xf880_0000,
    0x88c0_0000,
    0x5ea0_0000,
    0x13b0_0000,
    0xfb38_0000,
    0x1be4_0000,
    0xb94e_0000,
    0x7cef_0000,
    0x06c2_8000,
    0xbbad_4000,
    0xa726_e000,
    0x7df6_f000,
    0xe055_6800,
    0xfe6b_fc00,
    0x511b_6a00,
    0x6e84_fd00,
    0xe9d9_e980,
    0xa829_bc40,
    0x3e7f_0ba0,
    0xf11f_4ef0,
    0xde8a_62d8,
    0x31c4_b244,
    0x8c29_0b3a,
    0xcc64_4d67,
    0x821e_e3c0,
    0x0b12_f169,
    0x419b_6b8c,
    0x5a44_fff6,
    0x8179_ebb1,
    0x6a99_bc41,
    0xebc7_0890,
    0xe33b_4fc8,
    0x9fe4_63cc,
    0xfb5b_b256,
    0xd7f3_8a41,
    0xf75d_0e19,
    0x39ee_0114,
    0x025f_0012,
    0xe57a_817b,
    0x7889_437e,
    0xc8c8_e2d4,
    0xbea9_f17b,
    0x43af_eaf7,
    0x7322_bc88,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0xf000_0000,
    0xa800_0000,
    0xf400_0000,
    0xf600_0000,
    0xbf00_0000,
    0x7c80_0000,
    0x07c0_0000,
    0x4ee0_0000,
    0x81f0_0000,
    0x9568_0000,
    0xc6bc_0000,
    0x8e42_0000,
    0x18a7_0000,
    0x0551_8000,
    0x3233_4000,
    0x4d86_a000,
    0xa85e_3000,
    0x3fa7_4800,
    0x85c1_d400,
    0xc7e5_4a00,
    0xe266_d700,
    0x1e34_c880,
    0x2795_94c0,
    0xb552_6a20,
    0xfa3b_a710,
    0xe99d_21f8,
    0x0646_71ec,
    0xdcba_6a0a,
    0xfb47_a6f3,
    0x893f_23b1,
    0x6f11_7034,
    0xe483_ebc4,
    0xfbc8_e43e,
    0xbcfb_8005,
    0x60e8_41b0,
    0xa2f5_201a,
    0x4bfa_708b,
    0x7878_6a1d,
    0xab20_a6de,
    0x160e_a307,
    0x2f12_33e7,
    0x848d_4be5,
    0xabda_d732,
    0xe4f6_c90d,
    0x3cf2_9514,
    0xa0e3_e854,
    0x02f8_e706,
    0xbbf3_82c9,
    0xd064_412a,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x9000_0000,
    0x8800_0000,
    0x1c00_0000,
    0x1600_0000,
    0xb900_0000,
    0x3f80_0000,
    0x2a40_0000,
    0xf3e0_0000,
    0x62f0_0000,
    0xf168_0000,
    0x3534_0000,
    0x7bc6_0000,
    0xa4a7_0000,
    0xcc8c_8000,
    0x9ada_4000,
    0x2f3b_6000,
    0x9cd3_9000,
    0xde3e_5800,
    0x5f44_6400,
    0x7278_5a00,
    0x9da3_6700,
    0x3314_d980,
    0x5089_2540,
    0x4cc7_bba0,
    0x762e_b530,
    0x335f_e3f8,
    0x7c7d_d3d4,
    0xb0a3_3906,
    0x0680_f47d,
    0xd5c2_8349,
    0x39b9_40b6,
    0x0119_e32c,
    0x1b9a_d152,
    0xd84f_bb3b,
    0x58ea_b714,
    0x6671_e08f,
    0x57ae_d042,
    0x7c09_bada,
    0x460d_b4b7,
    0xd11d_62f6,
    0xb384_910c,
    0xb45a_d922,
    0x56ea_2763,
    0x4b65_3bf0,
    0x6227_f571,
    0xf94e_026b,
    0x3363_03d5,
    0xa622_82dc,
    0x9b49_4323,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0xd000_0000,
    0x5800_0000,
    0x2c00_0000,
    0x1200_0000,
    0x3100_0000,
    0x0e80_0000,
    0x1f40_0000,
    0x62e0_0000,
    0x1bf0_0000,
    0x8178_0000,
    0xd02c_0000,
    0x19d6_0000,
    0x49ad_0000,
    0xe710_8000,
    0x699e_c000,
    0x36de_e000,
    0xf43a_3000,
    0x3fdd_5800,
    0xe6a5_c400,
    0x1a8b_5a00,
    0x1148_c500,
    0x69fb_d880,
    0x8066_0640,
    0xf6bd_39e0,
    0xa280_36f0,
    0x4d4e_61a8,
    0xf3e4_f234,
    0xc563_bb92,
    0xc62f_f749,
    0x9ece_0299,
    0x1031_0166,
    0xf9de_817c,
    0x39af_c0d6,
    0x6f00_62b3,
    0x1d95_f2c4,
    0x08dd_383d,
    0xd730_376b,
    0x0056_631f,
    0xf778_f16d,
    0x672d_b8d4,
    0x685e_f7e5,
    0xf370_82b7,
    0xd12e_c359,
    0x3f46_e346,
    0xf2e6_30ac,
    0xe3f3_582e,
    0x7d64_c63f,
    0x9a2d_d83a,
    0x04cb_057a,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xf000_0000,
    0xf800_0000,
    0xa400_0000,
    0x1a00_0000,
    0xa700_0000,
    0x8880_0000,
    0x6b40_0000,
    0x0720_0000,
    0x0830_0000,
    0x6cb8_0000,
    0x61fc_0000,
    0x8fc2_0000,
    0x4a6d_0000,
    0xc601_8000,
    0x591e_c000,
    0x1598_2000,
    0xb4cc_3000,
    0x1cf4_d800,
    0xc04c_fc00,
    0x79b6_da00,
    0xa261_fd00,
    0x0a17_5a80,
    0xcf0f_3ec0,
    0x0497_7960,
    0xdd4f_0c50,
    0xe639_a108,
    0x99a2_f2cc,
    0x3274_f92a,
    0x220c_ce61,
    0x6318_03b6,
    0x428c_0081,
    0xc45a_0364,
    0xd3a1_0156,
    0xdd7b_8253,
    0xd68f_c3b3,
    0x465b_a0e1,
    0x00bf_f376,
    0x47ed_7ae1,
    0x46de_0eb4,
    0x77fa_231e,
    0xded1_30bf,
    0x03ed_5be9,
    0xccde_3c78,
    0xf8f4_fa34,
    0xfa4c_cede,
    0x2eb8_005f,
    0xd2fc_00f9,
    0xc542_0350,
    0xd22d_0288,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x3000_0000,
    0xd800_0000,
    0x1c00_0000,
    0x4600_0000,
    0xd100_0000,
    0x2080_0000,
    0x4240_0000,
    0xae20_0000,
    0xfb30_0000,
    0xe1a8_0000,
    0xa4fc_0000,
    0x135a_0000,
    0x4eb1_0000,
    0x197a_8000,
    0x7f9e_4000,
    0x87c6_6000,
    0xeee7_7000,
    0xac53_b800,
    0xdb23_3c00,
    0x11a9_ba00,
    0xdce2_3f00,
    0x3f5b_3880,
    0xd0b0_7fc0,
    0xd46f_5be0,
    0x191a_0fb0,
    0x149c_62f8,
    0x6056_70f4,
    0x1529_387a,
    0x94bd_7efd,
    0x4e6f_da42,
    0x2e05_4ed1,
    0xd508_8024,
    0xda93_40f2,
    0xe546_e011,
    0x87b8_31fc,
    0x85e7_5b6e,
    0x4bd6_0e8f,
    0x20ee_622b,
    0x295b_70a1,
    0x49a9_b83c,
    0x00e2_3e36,
    0xd95b_38d3,
    0x31b0_7c55,
    0x2cef_5a46,
    0x475a_0fcb,
    0xfcbc_6211,
    0x4a66_7144,
    0xd401_3b82,
    0x7201_7f89,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0xd000_0000,
    0xf800_0000,
    0x4c00_0000,
    0x6a00_0000,
    0x8f00_0000,
    0x4380_0000,
    0x0240_0000,
    0x7fa0_0000,
    0xf4b0_0000,
    0x5928_0000,
    0xfa6c_0000,
    0x4756_0000,
    0xa339_0000,
    0x6d78_8000,
    0xb8c9_c000,
    0xe376_2000,
    0x29d3_5000,
    0x29e9_9800,
    0x5d14_ac00,
    0x609f_9a00,
    0xdbdd_af00,
    0xdaef_1a80,
    0x7c88_6c40,
    0x89c7_3960,
    0x39fe_3d70,
    0x8508_20c8,
    0xfc86_534c,
    0x49c7_1bc6,
    0x19e4_6c45,
    0x5511_38b8,
    0x0487_3fd7,
    0x05d0_a2bc,
    0x73ff_924e,
    0xda19_3be9,
    0x471b_3cce,
    0x078e_a07a,
    0x0c5a_9058,
    0x2ebf_ba67,
    0x1e37_fe54,
    0xfdfe_0292,
    0x4b15_0057,
    0x8d8e_82af,
    0x7340_c118,
    0x4526_a354,
    0xa876_9312,
    0xa449_b897,
    0x5abe_fe8f,
    0x182e_8288,
    0xc8f0_c32c,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0xd000_0000,
    0xf800_0000,
    0x1400_0000,
    0xe600_0000,
    0x9900_0000,
    0x4780_0000,
    0xef40_0000,
    0x4de0_0000,
    0x12f0_0000,
    0xbc78_0000,
    0xdca4_0000,
    0x421e_0000,
    0x1711_0000,
    0xd29b_8000,
    0x8adb_4000,
    0x25b2_6000,
    0x9595_9000,
    0xe052_f800,
    0x5b73_8400,
    0x8634_fa00,
    0x14c6_8500,
    0xe8b1_7980,
    0xd40c_c640,
    0x4618_9a60,
    0xa902_1610,
    0x6f98_01f8,
    0x0354_0074,
    0xbfe6_02e6,
    0x6df5_02c9,
    0x62e5_8051,
    0x747a_41c2,
    0xe0b1_e140,
    0x481a_d2e0,
    0x7c06_9bd0,
    0xea13_14d8,
    0xbb03_8384,
    0xc08f_404e,
    0x25d4_63a5,
    0x0320_9013,
    0x2957_7ab5,
    0xa4f9_c51c,
    0x9d7d_1bdd,
    0x6f38_5627,
    0x9b49_e233,
    0x3bfe_d1c5,
    0x93f8_9a74,
    0x3ff2_1791,
    0x2de0_0195,
    0x82f0_01ec,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0xb000_0000,
    0xc800_0000,
    0x4c00_0000,
    0x3a00_0000,
    0x1f00_0000,
    0x9480_0000,
    0xebc0_0000,
    0x3760_0000,
    0x8270_0000,
    0x31f8_0000,
    0x6aac_0000,
    0x701a_0000,
    0x2813_0000,
    0x5c12_8000,
    0x4201_c000,
    0x9b14_2000,
    0xe29f_b000,
    0xcecb_4800,
    0xbcea_e400,
    0xfd29_4a00,
    0xed55_e500,
    0xdfa1_c880,
    0xc387_27c0,
    0x7347_6ba0,
    0x46a9_56f0,
    0x1a00_0348,
    0xef00_028c,
    0xfc80_031a,
    0x17c0_0023,
    0xc560_0147,
    0xd170_00ea,
    0x9f78_02a0,
    0x9e6c_0070,
    0xd3fa_0388,
    0x41a3_00ac,
    0x5a8a_80aa,
    0xaadd_c20b,
    0xdaf6_221b,
    0xa020_b388,
    0xe2c3_c9e7,
    0xd6f8_24d1,
    0x3a2f_e9d3,
    0x4dcb_96c4,
    0x8a7e_a15d,
    0x9df2_7202,
    0x40a5_6bdc,
    0x1716_54a2,
    0x3888_80e7,
    0xc1d2_c251,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x5000_0000,
    0xa800_0000,
    0x2c00_0000,
    0xfe00_0000,
    0x5100_0000,
    0xef80_0000,
    0x0640_0000,
    0x5760_0000,
    0x1070_0000,
    0x22e8_0000,
    0x0524_0000,
    0xfd0e_0000,
    0xd18b_0000,
    0x3756_8000,
    0xe8e5_4000,
    0xbe35_6000,
    0x5985_9000,
    0xeb5c_d800,
    0x8efb_f400,
    0x3b3a_da00,
    0xcc14_f700,
    0x6e02_5b80,
    0x990a_b640,
    0x9389_b920,
    0x504e_66f0,
    0x2a6e_02d8,
    0x01fb_03b4,
    0x75be_8366,
    0xbdc1_40ad,
    0xeb3b_63bb,
    0xa40e_91ac,
    0x220a_5990,
    0x371e_b508,
    0x6a8f_bb9c,
    0x93d1_640a,
    0xd23e_817f,
    0x0781_42f0,
    0x8a5b_627a,
    0x997e_9067,
    0xb962_5b24,
    0x497a_b64c,
    0xd161_bb22,
    0x056a_6593,
    0x7f60_0162,
    0xfc70_0011,
    0xbce8_0241,
    0x0424_038b,
    0xba8e_0194,
    0xfbcb_02b4,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0xb000_0000,
    0xc800_0000,
    0x7c00_0000,
    0xc200_0000,
    0x1300_0000,
    0x6180_0000,
    0xc340_0000,
    0x5820_0000,
    0xa130_0000,
    0x5fb8_0000,
    0x9774_0000,
    0xd302_0000,
    0x418b_0000,
    0x134c_8000,
    0x2038_c000,
    0x153c_a000,
    0xe1a1_9000,
    0x467a_7800,
    0xa19f_3c00,
    0xe340_7a00,
    0x8820_3d00,
    0xd92e_fb80,
    0xeba3_ffc0,
    0x2966_d8a0,
    0x020e_ae30,
    0x3302_03a8,
    0xb18b_027c,
    0xbb4c_802e,
    0xec38_c071,
    0x1f3c_a0ce,
    0x8ea1_9035,
    0xe5fa_7a90,
    0x71df_3f98,
    0xdae0_78d4,
    0xea50_3fd2,
    0xdeb6_f89f,
    0xdde7_fe9f,
    0xa5dc_da8b,
    0xd4f1_ae6d,
    0xf34c_81e4,
    0xd038_c2fa,
    0xbd3c_a2a3,
    0x2da1_93d1,
    0x4c7a_796a,
    0xce9f_3cbb,
    0x40c0_79c5,
    0x5860_3d98,
    0xe08e_f9d4,
    0x89d3_fe52,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x5000_0000,
    0xf800_0000,
    0x2c00_0000,
    0x9600_0000,
    0xcf00_0000,
    0x6280_0000,
    0xdd40_0000,
    0xfea0_0000,
    0x4bb0_0000,
    0x9038_0000,
    0x10ec_0000,
    0xf986_0000,
    0x45c9_0000,
    0xdae4_8000,
    0x4892_4000,
    0x9c59_a000,
    0x8f36_f000,
    0xca66_d800,
    0xa8d6_cc00,
    0x7d78_da00,
    0xa643_cd00,
    0x9622_5880,
    0xc7f4_8c40,
    0x4719_7b60,
    0xa699_3cf0,
    0x3f42_8138,
    0xdbab_43cc,
    0x8825_22b2,
    0xccf8_b1b9,
    0xc781_7bc8,
    0x5ec5_3dd7,
    0x027c_8068,
    0xccce_4024,
    0xcf67_a156,
    0x7b53_f24f,
    0x79a4_5ad7,
    0x0d3d_8de8,
    0x5f7d_f8e4,
    0x634b_7c76,
    0xa5bb_20df,
    0x332d_b39f,
    0x447b_f95c,
    0xbbc2_7ffa,
    0x21ff_a30d,
    0x600f_f3d6,
    0xb01a_5b2c,
    0x0818_8da1,
    0x841f_7ab7,
    0x4210_3ebb,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xb000_0000,
    0x4800_0000,
    0x5c00_0000,
    0x3a00_0000,
    0xe700_0000,
    0x9980_0000,
    0x0440_0000,
    0xbb20_0000,
    0x0a30_0000,
    0x46b8_0000,
    0x407c_0000,
    0xec8a_0000,
    0xf6d3_0000,
    0xc4f0_8000,
    0xf643_c000,
    0x4031_2000,
    0x89b7_1000,
    0x15e6_1800,
    0x2acd_3c00,
    0xbef4_1a00,
    0x3152_3d00,
    0x69b6_9a80,
    0xc5fe_ffc0,
    0xf2dd_3ba0,
    0x1ae9_2eb0,
    0x1f42_8348,
    0xe8ac_c12c,
    0x816b_a32e,
    0x8817_d03d,
    0x3c1f_b942,
    0xaa05_eed5,
    0x1f09_2378,
    0x8d8b_13a4,
    0x624c_1aa2,
    0x662e_3c23,
    0x74bc_9877,
    0xdb6d_fd5b,
    0xff0d_bad3,
    0x5d9a_ef79,
    0xba4b_a030,
    0xc227_d02e,
    0x5aa7_bb1b,
    0x5a79_ed95,
    0xbb83_22be,
    0x2758_13a3,
    0x9cbc_9b91,
    0x776d_fdac,
    0xad0d_b948,
    0x569a_ee8a,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0xb000_0000,
    0x5800_0000,
    0xac00_0000,
    0xde00_0000,
    0xe900_0000,
    0x9980_0000,
    0x82c0_0000,
    0x9d60_0000,
    0x3e70_0000,
    0x6cf8_0000,
    0x08ac_0000,
    0x239a_0000,
    0xb1c1_0000,
    0x67fc_8000,
    0x0e23_4000,
    0x85c0_6000,
    0xf5fc_5000,
    0x2937_8800,
    0x1d48_e400,
    0x1ab5_8a00,
    0x4495_e500,
    0x894b_0880,
    0x38ab_a7c0,
    0x3b95_e9e0,
    0xbdd9_b570,
    0x09e4_8298,
    0xbf3f_42d4,
    0xb042_62fe,
    0xa921_51df,
    0x5d49_0a0b,
    0xbab6_a7e6,
    0xf48b_68d8,
    0xd157_f474,
    0x94a2_61ae,
    0xe591_53d7,
    0x54d1_0937,
    0x906a_a654,
    0x3de9_6aad,
    0x2d3a_f51e,
    0x9744_e23c,
    0x31b3_1332,
    0xb20d_e8b5,
    0xd705_b40a,
    0x6086_8322,
    0xf352_429d,
    0xeba4_e0a6,
    0xd103_12f8,
    0x6595_eae4,
    0x14d9_b746,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x5000_0000,
    0x0800_0000,
    0x5400_0000,
    0xd600_0000,
    0xe500_0000,
    0xab80_0000,
    0xe940_0000,
    0x1b20_0000,
    0x70b0_0000,
    0x39f8_0000,
    0x92c4_0000,
    0xba7e_0000,
    0xdf87_0000,
    0xcf49_8000,
    0x462d_4000,
    0xd736_e000,
    0x5aaa_1000,
    0xeefa_7800,
    0x525f_fc00,
    0x41b3_fa00,
    0x0472_bd00,
    0x7e85_1980,
    0x5ad8_ac40,
    0x4e7f_61a0,
    0xb987_5110,
    0x724c_98f8,
    0xb1b5_ef84,
    0xbc69_83d6,
    0x729d_4061,
    0xd0ce_e21a,
    0x296e_10b3,
    0x2104_7a05,
    0xd598_fd7c,
    0xe85a_7b3a,
    0x3eaf_fe63,
    0x20eb_fa1d,
    0x0b46_bfc8,
    0x3823_1b44,
    0xd62b_afde,
    0x7f30_e1c5,
    0xbea9_11f4,
    0x60ed_f95e,
    0xeb45_bf6d,
    0x6834_9bc0,
    0xde31_ec88,
    0x2b37_8264,
    0x68aa_410e,
    0x85ff_61dd,
    0x40c7_5340,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xb000_0000,
    0x1800_0000,
    0x5400_0000,
    0xfa00_0000,
    0x8300_0000,
    0xca80_0000,
    0x95c0_0000,
    0xb7a0_0000,
    0x2d30_0000,
    0x70f8_0000,
    0x1b5c_0000,
    0x307a_0000,
    0x7581_0000,
    0x8957_8000,
    0x9f72_c000,
    0x8103_a000,
    0xcd9d_7000,
    0x2d55_0800,
    0x5d74_5c00,
    0xe602_8a00,
    0xe506_9d00,
    0x6f81_2a80,
    0xda5b_efc0,
    0xddf4_22e0,
    0xe8df_b290,
    0xcc2e_ab08,
    0x2d75_2d9c,
    0x9e0d_82a2,
    0x2103_c00b,
    0x3d8c_229c,
    0x1543_b22f,
    0xb974_a857,
    0x0404_2fde,
    0x3202_0234,
    0x5f1d_0203,
    0xcc8d_808d,
    0xa0c3_c351,
    0x502c_225e,
    0x0b73_b179,
    0x1b0c_aabf,
    0xde98_2e5f,
    0x4fd8_00c2,
    0x84ac_0356,
    0xffa2_02e8,
    0xb12d_0181,
    0x56f5_82f6,
    0x9e5f_c155,
    0xcff6_2265,
    0x07c2_b2d0,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x5000_0000,
    0x4800_0000,
    0x9c00_0000,
    0x4200_0000,
    0x5100_0000,
    0xc280_0000,
    0x25c0_0000,
    0x6560_0000,
    0x9ff0_0000,
    0xfe28_0000,
    0xad5c_0000,
    0xeda6_0000,
    0x8a07_0000,
    0x0d08_8000,
    0x2086_c000,
    0x24db_e000,
    0xeff3_3000,
    0x2635_4800,
    0xd950_0400,
    0x63bd_ca00,
    0xd116_c700,
    0x0286_2880,
    0x85d5_f640,
    0x357b_61a0,
    0xd7e9_f030,
    0x6228_aaa8,
    0xef54_3674,
    0xbca8_0122,
    0x489c_00a3,
    0x28c6_0117,
    0x45f7_02ec,
    0xbb20_8047,
    0x11da_c22d,
    0x8b7d_e0d3,
    0x34f4_33a6,
    0xe9bd_cb70,
    0xdc16_c488,
    0x2206_2884,
    0xa115_f46a,
    0xda9b_6347,
    0xf1d9_f0ad,
    0xbb60_a993,
    0x8cf8_3686,
    0x6da6_0300,
    0x4a07_0280,
    0xad08_8140,
    0x7086_c120,
    0x6cdb_e270,
    0x73f3_3108,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x7000_0000,
    0x3800_0000,
    0x0400_0000,
    0x7600_0000,
    0xdf00_0000,
    0x8480_0000,
    0x8440_0000,
    0xfca0_0000,
    0x5c30_0000,
    0x7e78_0000,
    0xf5c4_0000,
    0x617a_0000,
    0xd145_0000,
    0x7521_8000,
    0x65e5_4000,
    0x1503_a000,
    0x6996_b000,
    0x49c9_7800,
    0x5378_4c00,
    0x9848_fa00,
    0x5ead_0d00,
    0x5d33_5980,
    0x69ff_bcc0,
    0xbf00_2160,
    0xb482_f0d0,
    0x5c49_5ab8,
    0x88ba_beac,
    0x1221_a12a,
    0xa567_b07d,
    0x074a_fbb8,
    0x3a2c_0ddd,
    0xa968_daf9,
    0xad5f_fda6,
    0xe722_03d6,
    0xbcf1_025e,
    0x7683_80da,
    0x6d54_42c4,
    0x4720_22cf,
    0x2cf2_f168,
    0x3e91_5a94,
    0x514e_bfc6,
    0x3523_a177,
    0x85e6_b0b5,
    0x6511_7a6d,
    0x518c_4f60,
    0x4dca_fb21,
    0x256c_0e2b,
    0x4748_dbd7,
    0xda2f_fd74,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x3000_0000,
    0x4800_0000,
    0x5c00_0000,
    0xaa00_0000,
    0xb500_0000,
    0x1780_0000,
    0x4240_0000,
    0x0620_0000,
    0xddb0_0000,
    0x8de8_0000,
    0x0acc_0000,
    0x06fa_0000,
    0x9e5b_0000,
    0x6c3c_8000,
    0x48a3_c000,
    0xaa66_6000,
    0x0084_1000,
    0x5ccd_9800,
    0xe9f4_3c00,
    0x54d1_1a00,
    0x55e7_ff00,
    0xeedf_7a80,
    0x98ef_efc0,
    0xed48_e3a0,
    0x2cb0_d2b0,
    0xf46d_7b08,
    0x5388_ef64,
    0x2c46_61d6,
    0x1d34_11ad,
    0xf125_9a6e,
    0xd338_3c6b,
    0x1a2b_1951,
    0x97bc_fc24,
    0x28e3_fa1c,
    0x654c_2c30,
    0x50ae_8062,
    0x6e74_c0c9,
    0xae80_e012,
    0x67cc_d34b,
    0xf57f_7b8b,
    0x421f_ec01,
    0x1900_e27c,
    0xd58c_d320,
    0x9b5f_78da,
    0xf3af_ef25,
    0x76e8_e2e0,
    0x3640_d0d0,
    0x2025_7b18,
    0x9ab4_ed5c,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0xb000_0000,
    0x9800_0000,
    0x5c00_0000,
    0x1200_0000,
    0x0700_0000,
    0x4e80_0000,
    0x4ac0_0000,
    0xf7e0_0000,
    0x2b70_0000,
    0xa6a8_0000,
    0xbfdc_0000,
    0x6e7a_0000,
    0xa721_0000,
    0x6f86_8000,
    0xb556_c000,
    0xaaab_2000,
    0xe5de_7000,
    0xbd60_e800,
    0x8fb3_b400,
    0xf44e_6a00,
    0x4539_7700,
    0x909f_4880,
    0xb7c6_05c0,
    0xda79_22e0,
    0xd123_70b0,
    0x969c_68a8,
    0x76c4_77ac,
    0xf5e3_c912,
    0x0471_c747,
    0x2c34_822d,
    0xbb1b_c05a,
    0x8c9f_a09f,
    0xc5c5_b0c9,
    0xcd7f_4ad4,
    0xb7b6_05a2,
    0x1851_21ef,
    0xcf3f_7081,
    0xcb86_6ac8,
    0xeb55_7498,
    0x97ad_48c4,
    0x684b_075e,
    0xf72d_a065,
    0x2788_b102,
    0x614b_cabb,
    0xccad_c727,
    0x34ce_8219,
    0xbafa_c30c,
    0x9ef9_2246,
    0x00e3_70e1,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x5000_0000,
    0x7800_0000,
    0x1400_0000,
    0x2a00_0000,
    0x6900_0000,
    0x0e80_0000,
    0x54c0_0000,
    0x8220_0000,
    0xc6b0_0000,
    0x4b68_0000,
    0xcfcc_0000,
    0x61b6_0000,
    0xeef1_0000,
    0xb08f_8000,
    0xd7d4_c000,
    0xc5a4_e000,
    0xccfc_b000,
    0xe583_e800,
    0x9f40_cc00,
    0xc664_6a00,
    0x0358_0f00,
    0x1076_8a80,
    0x0c55_be40,
    0x19fa_e360,
    0x6d01_b210,
    0xbc9a_69c8,
    0x59d5_0cb4,
    0x8ea7_0b72,
    0x977c_7fa7,
    0xf9c7_801a,
    0x1ea8_c1ad,
    0xcf7a_e27f,
    0xbdc1_b066,
    0x4cba_6beb,
    0xb265_0e6a,
    0x994f_08fb,
    0x7170_7c2c,
    0x3ed1_80e0,
    0x0b29_c3de,
    0xb83d_6007,
    0x37a9_7324,
    0x21e0_8a7a,
    0x9914_bc33,
    0xe69d_6118,
    0x18d9_7152,
    0xec28_8859,
    0xfda8_beed,
    0x38e3_6291,
    0xbf94_72d9,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x1000_0000,
    0x2800_0000,
    0x8400_0000,
    0x8200_0000,
    0x5500_0000,
    0x3780_0000,
    0xb040_0000,
    0x3be0_0000,
    0x0670_0000,
    0x3738_0000,
    0xb15c_0000,
    0xc66e_0000,
    0x5733_0000,
    0x814f_8000,
    0xfe69_c000,
    0xfb3c_6000,
    0x8743_1000,
    0x2963_d800,
    0x99a1_4400,
    0x0094_5a00,
    0xa2d4_8500,
    0xa426_3a80,
    0x31d4_9540,
    0x24b2_6220,
    0xd300_1350,
    0xa094_5a28,
    0xf2d4_8704,
    0xac26_3876,
    0xa5d4_9485,
    0x8eb2_60b9,
    0x0200_12cc,
    0x1514_58cd,
    0x1794_864d,
    0xa046_3b82,
    0x13e4_95c4,
    0x826a_6196,
    0xb52c_12b5,
    0xe442_5ae1,
    0xf1fb_8430,
    0xe767_b9d7,
    0xbabe_571a,
    0xf819_80d8,
    0xcc06_c3bc,
    0x361d_e33a,
    0xef19_d207,
    0xce90_3972,
    0x81cb_957c,
    0x5cab_e0da,
    0x5f06_d137,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x7000_0000,
    0x4800_0000,
    0x8c00_0000,
    0x9a00_0000,
    0x5700_0000,
    0x4b80_0000,
    0x5040_0000,
    0x0ca0_0000,
    0x6530_0000,
    0xe678_0000,
    0x975c_0000,
    0x1f22_0000,
    0xa173_0000,
    0xc4ce_8000,
    0xfb67_c000,
    0xf3d2_2000,
    0xe0ff_d000,
    0x9b85_1800,
    0x2846_2c00,
    0xe8b3_9a00,
    0x033d_ed00,
    0x6363_ba80,
    0x07c1_3cc0,
    0x9ef0_23a0,
    0xaa8c_d2f0,
    0xe6cb_9bc8,
    0x2861_eeac,
    0x8e41_b866,
    0x0db2_3f2d,
    0xc3be_a1f4,
    0xdaab_1149,
    0xc839_bb25,
    0xaaee_3d78,
    0xb49c_a29f,
    0x87d8_1320,
    0xdef7_3b30,
    0x8a89_fee8,
    0x96ce_829c,
    0x6067_c10e,
    0x0252_23f1,
    0x97bf_d39a,
    0x94a5_19e8,
    0x9136_2c87,
    0x986b_9b74,
    0xa651_ec12,
    0xd1b9_b8bf,
    0x61ae_3d0b,
    0x49bc_a222,
    0x95a8_10d7,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x7000_0000,
    0x8800_0000,
    0x0400_0000,
    0x6600_0000,
    0xc500_0000,
    0x5780_0000,
    0xcac0_0000,
    0x99a0_0000,
    0x6c30_0000,
    0xe5f8_0000,
    0x3ecc_0000,
    0x37b2_0000,
    0x0d3b_0000,
    0xa467_8000,
    0xb911_4000,
    0xfd86_e000,
    0xcdd5_9000,
    0x1d34_8800,
    0xbc6d_dc00,
    0xe50b_0a00,
    0x6780_9d00,
    0xe2c7_e880,
    0xeda2_0cc0,
    0x8226_e2a0,
    0x24e5_90d0,
    0x0f4c_8938,
    0x3861_dec4,
    0xc319_08e6,
    0x028b_9d2f,
    0xc558_6a20,
    0xaf7f_4d4f,
    0x1f92_020f,
    0x2ecb_02b0,
    0x2fbf_8017,
    0x512d_43bb,
    0x3e6c_e33e,
    0x9612_9204,
    0x0d19_0b19,
    0xf38b_9c68,
    0xdcd8_6bbc,
    0xd4bf_4c42,
    0x3fb2_01b9,
    0x493b_01e7,
    0x6267_8113,
    0x0c11_4322,
    0x2206_e016,
    0x0315_9058,
    0xe294_886b,
    0x155d_dcd9,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0xf000_0000,
    0xb800_0000,
    0x9400_0000,
    0xaa00_0000,
    0xb900_0000,
    0x7780_0000,
    0x87c0_0000,
    0x5b60_0000,
    0xc2f0_0000,
    0xbe28_0000,
    0x97c4_0000,
    0xd36a_0000,
    0x8ef5_0000,
    0x7033_8000,
    0x3cd4_c000,
    0x89fa_e000,
    0xd4b9_9000,
    0x159a_a800,
    0xd2d1_a400,
    0x72e1_2a00,
    0xa631_6700,
    0x93d9_cb80,
    0x3179_f4c0,
    0x1bfa_e160,
    0x39b9_9290,
    0xa81a_a9c8,
    0x1c11_a774,
    0xe601_2b96,
    0x7701_65ab,
    0xdc91_c99b,
    0xdd4d_f730,
    0x0138_e32b,
    0xa748_91db,
    0x5023_2910,
    0x6cc0_641b,
    0xa1e0_4be3,
    0x08a8_353c,
    0x939b_8131,
    0x55d0_c2aa,
    0x1670_e29a,
    0xef7c_9231,
    0x38e1_2b2a,
    0x2f31_655a,
    0x3c59_cad1,
    0xd2b9_f67a,
    0x529a_e072,
    0xd649_92f5,
    0xcbb2_abc4,
    0xb515_a47d,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x7000_0000,
    0x3800_0000,
    0xdc00_0000,
    0xde00_0000,
    0x6d00_0000,
    0x9080_0000,
    0x6dc0_0000,
    0x1e60_0000,
    0x34f0_0000,
    0xf628_0000,
    0xebcc_0000,
    0x3f72_0000,
    0x127d_0000,
    0x62fa_8000,
    0x5f2b_4000,
    0x094f_e000,
    0xd9b1_7000,
    0x2d94_8800,
    0x754d_2400,
    0xb7a6_0a00,
    0x589a_6700,
    0x49d3_ea80,
    0x3c6a_16c0,
    0xf7e7_e260,
    0x33bd_71b0,
    0xca86_8b18,
    0x92c0_2704,
    0x55f4_8bda,
    0x30bd_2473,
    0x2f0e_0bc3,
    0xc396_6610,
    0xc041_eb83,
    0xab27_177b,
    0xa355_6244,
    0xdeaa_3331,
    0x9a13_6bf4,
    0xdf00_5429,
    0x3b88_82f0,
    0x3c56_42f3,
    0x0535_6303,
    0xf65a_3170,
    0x923b_6bb3,
    0x29cc_5623,
    0xac7a_80e0,
    0x9feb_40bb,
    0xa7af_e06f,
    0xf081_70d6,
    0xfddc_88ae,
    0x7671_2651,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0xb000_0000,
    0x8800_0000,
    0xd400_0000,
    0x4600_0000,
    0xd900_0000,
    0x8180_0000,
    0xd540_0000,
    0xd060_0000,
    0xc0f0_0000,
    0xe038_0000,
    0xf304_0000,
    0x0282_0000,
    0xffdb_0000,
    0xabbd_8000,
    0x1553_4000,
    0x7061_6000,
    0x90ef_d000,
    0xd83f_b800,
    0xaf05_9400,
    0x9080_3a00,
    0x60cd_d500,
    0xf33c_d980,
    0x4181_47c0,
    0x755a_03a0,
    0x806f_0090,
    0xf8e7_80b8,
    0xbc3c_42f4,
    0x6106_e13e,
    0x9d93_9361,
    0xa759_585f,
    0xff66_0732,
    0x1061_60c7,
    0x60ef_d29a,
    0xb03f_bb4b,
    0xcb05_95f0,
    0x5e80_3904,
    0x6dcd_d636,
    0x34bc_dbfd,
    0x4dc1_454d,
    0x24ba_01a9,
    0x95df_036f,
    0xc8bf_831a,
    0x8fc8_408b,
    0x83bc_e050,
    0x914c_9294,
    0x0e66_d80e,
    0x15ee_4649,
    0xcbbd_8393,
    0xe553_4338,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x9000_0000,
    0x0800_0000,
    0xfc00_0000,
    0xae00_0000,
    0x1100_0000,
    0x2480_0000,
    0x8d40_0000,
    0x8860_0000,
    0x45f0_0000,
    0x6828_0000,
    0x870c_0000,
    0x918e_0000,
    0xd3d7_0000,
    0xd62c_8000,
    0x5e1b_4000,
    0x6910_6000,
    0x6097_7000,
    0x4745_1800,
    0xc365_3400,
    0x2267_9a00,
    0x7ee9_7700,
    0xb7bb_7a80,
    0xf5d5_4540,
    0xfb26_02a0,
    0xf49b_02b0,
    0x6542_8218,
    0xc47c_41f4,
    0x73f4_e20a,
    0x8d30_3181,
    0xf193_780b,
    0xa3d9_4766,
    0x6e28_0113,
    0x3a0c_023e,
    0x330e_0147,
    0x2397_0204,
    0xdccc_809e,
    0x7bab_43db,
    0x03d8_6202,
    0x3e2b_73f1,
    0x1203_1b73,
    0x5f0e_35c2,
    0x858d_1811,
    0x31d9_3563,
    0xf121_986a,
    0x9f82_767d,
    0x92d1_f95d,
    0xdaa5_0401,
    0xbf5c_e3e7,
    0x477c_3098,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x3000_0000,
    0x5800_0000,
    0xa400_0000,
    0x0200_0000,
    0x3900_0000,
    0x9380_0000,
    0x41c0_0000,
    0x80a0_0000,
    0x3e30_0000,
    0xf678_0000,
    0xca14_0000,
    0xd502_0000,
    0x3d81_0000,
    0xb6d9_8000,
    0xd43f_c000,
    0x7363_e000,
    0x9f8d_1000,
    0x9fd9_6800,
    0x4fa0_5c00,
    0xfea2_ea00,
    0xe12e_9d00,
    0x3ee0_8b80,
    0x1148_4dc0,
    0xdff8_02e0,
    0x66d4_0350,
    0xfc22_00e8,
    0xef71_02b4,
    0x0981_8326,
    0xfcdb_c373,
    0x4139_e044,
    0x2ee8_111b,
    0x195a_eb95,
    0x13fa_9ed7,
    0x98c2_888f,
    0x6339_4e26,
    0x47f9_81d6,
    0xe2cf_c14e,
    0xae3b_e0a2,
    0xbe69_1388,
    0x6603_6801,
    0x1b05_5e64,
    0xfa81_680e,
    0xba44_5c27,
    0x3d78_eab2,
    0x188b_9ec0,
    0xf343_0b45,
    0x96e2_8eda,
    0xcd40_6211,
    0x29e7_d209,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x1000_0000,
    0xd800_0000,
    0xb400_0000,
    0xda00_0000,
    0xa100_0000,
    0xcd80_0000,
    0x6940_0000,
    0xae60_0000,
    0x7ef0_0000,
    0x8c38_0000,
    0x340c_0000,
    0x9a1e_0000,
    0x010d_0000,
    0xdd8f_8000,
    0xb156_c000,
    0x1a79_e000,
    0xa4e6_d000,
    0x2d38_b800,
    0xf98d_5400,
    0xf349_3a00,
    0xaf66_9500,
    0xa367_5880,
    0x3d6a_8540,
    0x2e60_03e0,
    0x3ef0_0390,
    0x2c38_0288,
    0x240c_0014,
    0x421e_033e,
    0xb50d_01f1,
    0x078f_82e7,
    0x1056_c2da,
    0xd7f9_e3bf,
    0xcda6_d08e,
    0x8358_bae1,
    0x877d_552f,
    0x7f71_392e,
    0x9b6a_9711,
    0x3979_59f7,
    0x3c67_8512,
    0xf3ef_804b,
    0x8fa6_c020,
    0x3641_e198,
    0x80ea_d3dc,
    0x6f26_baca,
    0x4c80_545f,
    0xf4c6_b91e,
    0xbf30_5569,
    0x749e_b9bb,
    0xf0cc_5550,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0xb000_0000,
    0xc800_0000,
    0x8c00_0000,
    0x5e00_0000,
    0xbf00_0000,
    0xa980_0000,
    0x6840_0000,
    0xd7e0_0000,
    0x1570_0000,
    0xbea8_0000,
    0x041c_0000,
    0xb21a_0000,
    0xf11b_0000,
    0x6e9e_8000,
    0x85c3_4000,
    0x6dad_a000,
    0x2399_1000,
    0xbd57_d800,
    0x7b76_c400,
    0x09b3_5a00,
    0x819e_8700,
    0x3448_7880,
    0x51e8_d5c0,
    0x5e60_03a0,
    0x0d30_03f0,
    0x0148_00d8,
    0x2d6c_020c,
    0x9ab2_00fe,
    0xc607_016d,
    0x2b04_8081,
    0xa398_4308,
    0x7d53_2303,
    0xdb6a_51e4,
    0xb9b2_7b6d,
    0x4983_d781,
    0xb856_8388,
    0x0fef_42c3,
    0xe17f_a044,
    0xa4ae_139d,
    0x691b_59d9,
    0xfa82_8544,
    0x8fd2_781d,
    0x78b3_d699,
    0x2f1e_8024,
    0x1183_42cd,
    0x8c4d_a371,
    0xb5e9_13d0,
    0x3c7f_d90f,
    0x242a_c51a,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0xf000_0000,
    0xa800_0000,
    0x0400_0000,
    0xba00_0000,
    0xfb00_0000,
    0xaf80_0000,
    0x3640_0000,
    0xdce0_0000,
    0x4270_0000,
    0xc8b8_0000,
    0x298c_0000,
    0xcb42_0000,
    0xce7f_0000,
    0xc6bb_8000,
    0x609a_c000,
    0x6bd4_a000,
    0x45b7_d000,
    0xd317_5800,
    0xeb95_2400,
    0x2c56_da00,
    0xd7fc_e500,
    0x45fb_f880,
    0xfaee_f6c0,
    0x4f63_8220,
    0x7226_c2d0,
    0xa94e_a2c8,
    0xd974_d03c,
    0x7736_daf6,
    0xe7cc_e725,
    0x4ba3_f925,
    0x9a12_f73c,
    0x4b19_826f,
    0xa795_c3b6,
    0xc257_235c,
    0xcee1_1146,
    0xbd61_fb5d,
    0xdd2d_f5e1,
    0xe4c2_03ce,
    0xb83f_0198,
    0xba5b_82b4,
    0xd2ea_c12a,
    0x0b6c_a0a3,
    0x683b_d058,
    0xa255_580d,
    0xdeea_2769,
    0x456d_5812,
    0x8126_261e,
    0xf2cf_5bc9,
    0xfd29_261b,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0xb000_0000,
    0x1800_0000,
    0x1c00_0000,
    0x9600_0000,
    0x9b00_0000,
    0x9c80_0000,
    0x34c0_0000,
    0x3d60_0000,
    0x94f0_0000,
    0xaba8_0000,
    0x6084_0000,
    0xd2c2_0000,
    0xde79_0000,
    0xa466_8000,
    0x117a_4000,
    0xdae6_2000,
    0x4ca0_3000,
    0xda17_6800,
    0x6510_2400,
    0x639b_ea00,
    0x9257_6700,
    0x1cb9_4b80,
    0xb204_15c0,
    0x0106_83e0,
    0x598a_41b0,
    0x874e_23b8,
    0x0724_30dc,
    0x8c55_684a,
    0x93a9_26cf,
    0x6c9d_6adf,
    0x8cdd_27ec,
    0xf177_6ba9,
    0xaae0_26c2,
    0x34b3_eaf0,
    0x7613_6518,
    0xeb1b_4acc,
    0xe48d_1562,
    0x98c8_017b,
    0xb374_0101,
    0x13ea_03ad,
    0xa13d_02bf,
    0xcf44_839c,
    0x7333_43f1,
    0x7e48_a3ae,
    0x32ae_7302,
    0xe51b_480b,
    0xa38d_15d9,
    0xf248_0081,
    0xacb4_016d,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x5000_0000,
    0x5800_0000,
    0x2400_0000,
    0xca00_0000,
    0xa100_0000,
    0xe280_0000,
    0xe440_0000,
    0x8560_0000,
    0x44f0_0000,
    0x3f28_0000,
    0x6284_0000,
    0x245e_0000,
    0xe56d_0000,
    0x14f5_8000,
    0x673e_c000,
    0x468d_e000,
    0xee4f_3000,
    0x4479_f800,
    0xf665_f400,
    0x837a_7a00,
    0xc3f2_3700,
    0xaabc_1b80,
    0x7b5e_c640,
    0x94f5_82e0,
    0xa73e_c2d0,
    0x268d_e3c8,
    0xbe4f_3354,
    0x1c79_f9c2,
    0xd265_f585,
    0x497a_78b7,
    0x62f2_3706,
    0x483c_1ae3,
    0x9f1e_c548,
    0x1195_8098,
    0xe3ce_c1dc,
    0x19a5_e3f6,
    0xdccb_30d7,
    0x3827_f81a,
    0x3708_f435,
    0x5d8f_f8ef,
    0x05cc_f6fa,
    0x0eb1_f8e5,
    0x7151_f627,
    0x55ec_792e,
    0x15ab_34e7,
    0x9adf_9b02,
    0x1f39_07a9,
    0x929b_e3f9,
    0x4c56_33fd,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x1000_0000,
    0x7800_0000,
    0xb400_0000,
    0xfe00_0000,
    0x8d00_0000,
    0x5180_0000,
    0xb5c0_0000,
    0xc7a0_0000,
    0xd130_0000,
    0x0678_0000,
    0xc894_0000,
    0x2a46_0000,
    0xf761_0000,
    0x9b0b_8000,
    0x508e_4000,
    0xce54_e000,
    0x1166_5000,
    0xb212_2800,
    0x871a_fc00,
    0x4287_aa00,
    0x7951_bd00,
    0x5be6_cb80,
    0x174c_ad40,
    0xeeed_8260,
    0x92df_4390,
    0xb527_6398,
    0xa07c_10a4,
    0x8180_cb5e,
    0xeddd_ae33,
    0x03be_03a0,
    0x4735_02a7,
    0x476d_83c1,
    0xd31f_42f1,
    0xec87_624e,
    0xec4c_116b,
    0xae78_c924,
    0x2489_af89,
    0x1058_02ba,
    0xec64_010d,
    0x8b9e_0103,
    0xfec5_001f,
    0xcf35_8102,
    0xdb7b_424e,
    0x8119_61fc,
    0x3b89_124d,
    0xb6cd_48f4,
    0x7332_ec66,
    0xf961_6227,
    0x3e1d_1296,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x7000_0000,
    0x0800_0000,
    0x8400_0000,
    0x7e00_0000,
    0x4900_0000,
    0x2480_0000,
    0x5540_0000,
    0xd360_0000,
    0x64f0_0000,
    0xf228_0000,
    0x0184_0000,
    0x3bda_0000,
    0xd923_0000,
    0x2e0f_8000,
    0x9106_4000,
    0xb89a_6000,
    0xd74c_7000,
    0x6866_1800,
    0xf374_d400,
    0xb4fb_9a00,
    0xea25_9700,
    0xfd9c_7b80,
    0xc9c8_a6c0,
    0x6a35_83a0,
    0x3d95_40d0,
    0xa9dd_e058,
    0x1a3e_32f4,
    0x358e_794a,
    0x2ddf_a661,
    0x6428_0027,
    0x7c84_02e2,
    0x095a_0197,
    0x3163_0100,
    0xafef_804a,
    0x6db6_40e1,
    0xc352_6267,
    0xae78_7002,
    0x5674_1a27,
    0x1a63_d728,
    0x8066_1ab6,
    0xc774_d447,
    0xa2fb_99d8,
    0x5725_95fe,
    0xaf1c_7bcb,
    0x5188_a4f6,
    0xe3d5_826d,
    0x4525_43c9,
    0xac15_e2d1,
    0x2a0a_3345,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0xd000_0000,
    0x7800_0000,
    0x9c00_0000,
    0x6a00_0000,
    0xeb00_0000,
    0x2680_0000,
    0x18c0_0000,
    0x76a0_0000,
    0x1530_0000,
    0x2668_0000,
    0x379c_0000,
    0xcd56_0000,
    0xa4e1_0000,
    0xb956_8000,
    0x4ae9_c000,
    0xd447_a000,
    0x4576_f000,
    0xe511_a800,
    0xfb98_9c00,
    0x1f59_2a00,
    0x73fc_5f00,
    0x25d6_0880,
    0xc12e_6c40,
    0x1868_8160,
    0x2294_c230,
    0x5ec7_22c8,
    0xffbe_329c,
    0xeca0_88d2,
    0x9637_adbf,
    0x44e7_22e8,
    0x094e_309b,
    0x42e8_8b59,
    0xe05b_afa9,
    0xcb79_2196,
    0xf803_3369,
    0x5c00_0a61,
    0xca0f_6f8a,
    0x3b1e_01fb,
    0x5e8d_03be,
    0x84c8_80d2,
    0x1ca4_c368,
    0xfe2f_215b,
    0x00e2_31f9,
    0x2f56_8839,
    0xbbe6_ac4e,
    0xb1d9_a06d,
    0x9f3b_f0d7,
    0x7d79_2ab3,
    0x190c_5ce2,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0xd000_0000,
    0xf800_0000,
    0x4400_0000,
    0xc200_0000,
    0x0d00_0000,
    0x6b80_0000,
    0x4b40_0000,
    0xf0e0_0000,
    0x9bb0_0000,
    0xfb58_0000,
    0x38fc_0000,
    0x57be_0000,
    0x555d_0000,
    0x4beb_8000,
    0xb72e_c000,
    0xba84_e000,
    0x96c7_5000,
    0xfcba_d800,
    0x61db_9400,
    0x3e3e_3a00,
    0xf31c_c500,
    0xa084_e080,
    0x4fc7_5240,
    0x0d3a_d960,
    0xb39b_9650,
    0x9f5e_3ae8,
    0x6aec_c424,
    0x02bc_e226,
    0xaacb_5359,
    0x3abc_db0d,
    0x0eca_9513,
    0x88b3_bac6,
    0x2bd3_06a9,
    0x5f35_8095,
    0xe683_c2ef,
    0x60d7_637c,
    0x1ba5_929a,
    0xbb58_3b03,
    0x98fd_c72e,
    0x87b1_630d,
    0xad44_9273,
    0x0fed_bb96,
    0x753e_05c1,
    0xb786_0071,
    0xfd51_00e9,
    0xb7ed_8095,
    0x913f_c2ef,
    0xa589_637c,
    0x0848_929a,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x1000_0000,
    0x0800_0000,
    0x9400_0000,
    0xb600_0000,
    0x5d00_0000,
    0xdc80_0000,
    0x3ec0_0000,
    0x8d60_0000,
    0xcbb0_0000,
    0x8ad8_0000,
    0x8b74_0000,
    0x6eae_0000,
    0xda5b_0000,
    0x9fa7_8000,
    0x9cca_4000,
    0x2676_6000,
    0xaa2f_b000,
    0x7882_0800,
    0x30de_1400,
    0xbc74_6a00,
    0x2d31_a500,
    0xc316_6180,
    0xa59f_b140,
    0xac5a_0ba0,
    0x62aa_1610,
    0xb05a_68f8,
    0x00aa_a624,
    0xbb51_e02a,
    0x9125_f0cf,
    0x5114_6ae7,
    0xb681_a5c5,
    0xa1ce_60e6,
    0xaaeb_b327,
    0x7cf4_09bb,
    0x71f1_148b,
    0x457d_e8a3,
    0xffa0_e59f,
    0xccc7_81a1,
    0xce7a_41ec,
    0x2e2e_6238,
    0xc69b_b1c4,
    0xf9cc_081a,
    0xd6f5_1567,
    0x4eeb_ea9b,
    0x92ff_e45b,
    0x50f6_01bb,
    0xabef_008b,
    0x2269_82a3,
    0x5421_409f,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x9000_0000,
    0xc800_0000,
    0x1400_0000,
    0xd200_0000,
    0x4500_0000,
    0x2880_0000,
    0xebc0_0000,
    0xb660_0000,
    0xc9b0_0000,
    0x6dc8_0000,
    0x0164_0000,
    0xd43e_0000,
    0xf683_0000,
    0x80df_8000,
    0x6df6_c000,
    0xc5e9_e000,
    0x81fe_3000,
    0x7bf4_a800,
    0xbaff_5400,
    0x887d_4a00,
    0x32b1_6700,
    0x7e41_e180,
    0x192a_3140,
    0xea02_a8a0,
    0xc918_5610,
    0xc69c_ca68,
    0xf8c4_a644,
    0xc1f7_826a,
    0x5be2_c3fb,
    0xcaff_e2db,
    0xd069_3299,
    0xeebd_2b06,
    0xb85e_9667,
    0x8e3d_2b0d,
    0x879e_9664,
    0x0a5d_2aa8,
    0x9b2e_97a4,
    0x8715_28da,
    0x658a_9583,
    0x374b_29f7,
    0x1fb9_9737,
    0xf2dc_abd7,
    0x98eb_57e7,
    0x556b_495f,
    0x2626_6793,
    0xc388_628d,
    0xf04b_f324,
    0x5a22_c808,
    0xb587_a6b4,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0xb000_0000,
    0xf800_0000,
    0xac00_0000,
    0x1a00_0000,
    0xd100_0000,
    0x0d80_0000,
    0xfe40_0000,
    0x3ea0_0000,
    0xccf0_0000,
    0x7848_0000,
    0xcda4_0000,
    0x5c7a_0000,
    0x2181_0000,
    0x244e_8000,
    0x0fbc_c000,
    0x7160_6000,
    0x7e19_1000,
    0x5f0c_b800,
    0x8a8b_7c00,
    0x88cc_da00,
    0xe462_6f00,
    0xad88_6180,
    0x6e4d_11c0,
    0x96be_b860,
    0x28ee_7c70,
    0x3658_5988,
    0xaaaf_aef4,
    0x9aee_81de,
    0x034c_c17d,
    0xe928_60ac,
    0x03bd_10ba,
    0xfb76_ba93,
    0x070a_7df1,
    0xb682_5ace,
    0x3ade_ac0d,
    0xd168_00ac,
    0xee14_01b2,
    0xf712_002f,
    0x6e95_01b3,
    0xc6dc_83a1,
    0x8369_c196,
    0x6b1c_e2e1,
    0x4c80_d1be,
    0x5bd8_590d,
    0x24ef_af24,
    0xbc4e_834e,
    0xd3bc_c1cd,
    0x7360_62cc,
    0xb319_12c2,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0xf000_0000,
    0x0800_0000,
    0x8400_0000,
    0x3e00_0000,
    0xe900_0000,
    0x5080_0000,
    0x7ec0_0000,
    0x3060_0000,
    0xfab0_0000,
    0x5cd8_0000,
    0xdb74_0000,
    0x1132_0000,
    0xd187_0000,
    0x1a45_8000,
    0x98b5_4000,
    0x57d5_e000,
    0xc0ee_b000,
    0x947e_8800,
    0x94b5_3400,
    0xadcb_6a00,
    0xf7eb_8500,
    0xdded_e180,
    0xb2ea_b2c0,
    0x6774_8ba0,
    0x0336_35d0,
    0x9284_ead8,
    0x65dd_c4b4,
    0xd3f7_803a,
    0xf3f2_409f,
    0xa3f0_6223,
    0xbbeb_f3c1,
    0xc7f3_696a,
    0x75ef_8533,
    0x26e7_e28d,
    0xa169_b374,
    0x663b_0a2e,
    0x7800_74f5,
    0xcc1e_8aa4,
    0x5a05_36f6,
    0x2713_6b41,
    0xb19f_841e,
    0xaa5f_e029,
    0x70ad_b182,
    0x23d1_0b6f,
    0xf6f3_75eb,
    0xf969_0b0d,
    0xfa37_75b4,
    0x3a03_0b8e,
    0x9704_7425,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x5000_0000,
    0x2800_0000,
    0xd400_0000,
    0x4200_0000,
    0xb100_0000,
    0xfb80_0000,
    0x9cc0_0000,
    0xf0e0_0000,
    0xd030_0000,
    0x16c8_0000,
    0x05f4_0000,
    0x21b6_0000,
    0xbf07_0000,
    0x648b_8000,
    0x0854_c000,
    0xe0b1_6000,
    0x9c86_d000,
    0x3446_2800,
    0x16bf_e400,
    0x3f97_4a00,
    0x56c9_3700,
    0xa5f9_6380,
    0x11b2_d240,
    0xc710_2920,
    0x9888_e610,
    0x9e54_cba8,
    0x13a9_f694,
    0xd61e_0166,
    0x5303_02f7,
    0x7a95_810d,
    0x1f57_c323,
    0x9024_e230,
    0xb6d1_12c3,
    0x35e2_ca3b,
    0x59ae_f65c,
    0x4315_8339,
    0xf297_c0ee,
    0xfb44_e008,
    0xaa21_1044,
    0xfbca_cb2e,
    0x586a_f793,
    0x366b_8233,
    0xf964_c218,
    0x45f9_6217,
    0x81b2_d07d,
    0x8f10_29bb,
    0x1c88_e41c,
    0xf454_ca19,
    0x76a9_f6fe,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0xb000_0000,
    0x3800_0000,
    0xf400_0000,
    0xee00_0000,
    0x1f00_0000,
    0xe480_0000,
    0x3940_0000,
    0xea60_0000,
    0x2f30_0000,
    0xa758_0000,
    0x6d74_0000,
    0x6fba_0000,
    0xf809_0000,
    0x540d_8000,
    0xbe09_4000,
    0x970f_2000,
    0x2886_f000,
    0x2358_f800,
    0x1b64_4400,
    0xd4b7_da00,
    0x7a92_b500,
    0xbe57_2180,
    0xaaf2_f3c0,
    0x7062_fb60,
    0x9e2d_4510,
    0xbcda_5958,
    0x00ab_f6ac,
    0x8480_01aa,
    0xc940_0359,
    0x3260_035b,
    0x6b30_0149,
    0x7158_026c,
    0x8674_02a5,
    0x653a_0309,
    0xde49_02cc,
    0x5aed_80d5,
    0xa879_4141,
    0xda37_2238,
    0x6ac2_f353,
    0xebba_f9f2,
    0x8e19_469a,
    0xef00_5931,
    0x3c92_f59f,
    0x7d55_8327,
    0x3c7d_42db,
    0xc435_2289,
    0xadcf_f10c,
    0x4b35_7bb5,
    0x615d_0451,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0xf000_0000,
    0x9800_0000,
    0x1400_0000,
    0x6a00_0000,
    0xc900_0000,
    0x4e80_0000,
    0xdd40_0000,
    0x8420_0000,
    0x5370_0000,
    0x0e58_0000,
    0xdbbc_0000,
    0x74ba_0000,
    0xcd35_0000,
    0x5dfd_8000,
    0x731d_c000,
    0xaf85_6000,
    0xbfcb_7000,
    0xd770_b800,
    0xec5e_cc00,
    0xcead_da00,
    0x2c29_bd00,
    0x3f67_6080,
    0x2042_72c0,
    0x10b7_38e0,
    0x7f36_0f90,
    0x20f5_39c8,
    0xa78f_0e74,
    0x23ca_b812,
    0x616b_ce91,
    0x3350_59ca,
    0xaf34_7ca8,
    0x08e2_0161,
    0x8b89_0397,
    0xadc7_8199,
    0x5a68_c39b,
    0xa0d8_e047,
    0x56e6_b3b4,
    0x988d_d972,
    0x1259_bd41,
    0x2dbf_6122,
    0x0bbe_722c,
    0x5cad_386b,
    0xe133_0c1a,
    0xd3f0_b985,
    0x481e_ce08,
    0x3c0d_d8d1,
    0x4619_bf2f,
    0x471f_60b5,
    0x758e_72b5,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x9000_0000,
    0x0800_0000,
    0x8c00_0000,
    0x6600_0000,
    0x7100_0000,
    0x7c80_0000,
    0x6a40_0000,
    0x7e20_0000,
    0xa270_0000,
    0x8548_0000,
    0xa7a4_0000,
    0xb6be_0000,
    0x9a3b_0000,
    0x1864_8000,
    0x7a5b_4000,
    0xb635_e000,
    0xce6f_3000,
    0x7344_9800,
    0xdeb4_ec00,
    0x4639_7a00,
    0x967f_df00,
    0x1743_e180,
    0xa4b0_3140,
    0x593e_1ba0,
    0x17e4_ac70,
    0x6780_1bb8,
    0xc1df_acf4,
    0xf9e4_99ea,
    0x5a84_ed2d,
    0x3b51_79aa,
    0x72ab_dc50,
    0x5035_e3d5,
    0x7f6f_32a3,
    0xefc4_9b05,
    0x24f4_eceb,
    0x3019_7909,
    0xb80f_dc55,
    0xf40b_e0be,
    0x7214_33ea,
    0x9300_1870,
    0xe79f_afe5,
    0x01c4_9a3b,
    0x19f4_ee41,
    0xca99_7ad9,
    0x334f_dfc0,
    0xfeab_e13d,
    0x3624_315f,
    0x0e68_1b43,
    0x934b_ad08,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x7000_0000,
    0xa800_0000,
    0xd400_0000,
    0x4a00_0000,
    0x9b00_0000,
    0x3b80_0000,
    0x5640_0000,
    0x4ee0_0000,
    0xdab0_0000,
    0x6b48_0000,
    0xc86c_0000,
    0xca6a_0000,
    0x9573_0000,
    0x9cf3_8000,
    0x5da1_c000,
    0x1edd_2000,
    0x9739_9000,
    0x5801_7800,
    0xbc00_b400,
    0x3e14_5a00,
    0xa115_2700,
    0x089f_2080,
    0xb9d6_92c0,
    0x52b0_f820,
    0x0f4e_7690,
    0x8a78_f988,
    0xf562_763c,
    0x4cf2_f946,
    0x85a1_75f5,
    0x62c9_7bf5,
    0x092c_b7a3,
    0x891e_5b9e,
    0x1c96_27b7,
    0x53c4_a162,
    0xb9ab_53d1,
    0x9ccf_d987,
    0x0828_e5ec,
    0xf180_03f8,
    0x0d40_0004,
    0xd560_01e2,
    0xfcf0_0047,
    0x8da8_021a,
    0xc6dc_0115,
    0xeb22_0045,
    0xc61f_033b,
    0x6d19_806a,
    0x9e92_c32d,
    0xccce_a2e1,
    0x1028_5189,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x7000_0000,
    0x7800_0000,
    0x7c00_0000,
    0xda00_0000,
    0x4500_0000,
    0xfb80_0000,
    0x94c0_0000,
    0xeae0_0000,
    0x4c30_0000,
    0xf7c8_0000,
    0x4e6c_0000,
    0xc66a_0000,
    0x0269_0000,
    0x047c_8000,
    0xeb66_c000,
    0x2dee_e000,
    0x3ea5_5000,
    0x9a84_2800,
    0x795e_a400,
    0x3922_ca00,
    0x1457_f700,
    0x76ac_e080,
    0xfe90_52c0,
    0x0f5a_ab60,
    0xae3d_6430,
    0xaeda_a888,
    0xbffd_67e4,
    0x1fba_a806,
    0x170d_6587,
    0x7a92_a925,
    0x6951_6453,
    0x9130_aa7c,
    0x6054_662d,
    0xa8a6_2920,
    0x1d9b_a547,
    0x6bd4_4945,
    0x8468_36e3,
    0x2b76_8134,
    0x8dff_c329,
    0x4eba_6256,
    0xe29f_9268,
    0x0548_c894,
    0xe33e_f4ae,
    0x5150_6073,
    0x8d36_90bb,
    0x6a54_4928,
    0xe5a8_3463,
    0xe216_8023,
    0x590f_c054,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x1000_0000,
    0xc800_0000,
    0x8c00_0000,
    0x8200_0000,
    0x8300_0000,
    0xc980_0000,
    0xb040_0000,
    0x3ee0_0000,
    0xc8b0_0000,
    0xbb48_0000,
    0xdb74_0000,
    0x8afe_0000,
    0xdeb3_0000,
    0x9e4c_8000,
    0x8ff7_c000,
    0x3a27_2000,
    0x968b_d000,
    0x93c3_f800,
    0xf1ae_7400,
    0x65cc_da00,
    0x04a1_a700,
    0x9959_2380,
    0x2878_d340,
    0x9b6f_7aa0,
    0x2ae9_b670,
    0xaea3_fb28,
    0x465e_773c,
    0xcbe4_daae,
    0x3425_a78d,
    0x978f_237d,
    0xd94f_d093,
    0x8875_fabe,
    0xeb69_7433,
    0xf2fe_58c8,
    0xeaa5_65ea,
    0x4852_8207,
    0xcaf4_c1ea,
    0x7ea3_a101,
    0xee48_109b,
    0x57fa_dbb2,
    0x7e26_a695,
    0x988b_a249,
    0x92cc_1231,
    0xbb2c_d915,
    0x1c11_a60f,
    0x8a11_23e0,
    0x6f0c_d2d6,
    0x5b91_78a9,
    0xfb5a_b667,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x7000_0000,
    0x9800_0000,
    0x8400_0000,
    0x1600_0000,
    0x9900_0000,
    0x1680_0000,
    0x9e40_0000,
    0x3e60_0000,
    0x9a30_0000,
    0x1748_0000,
    0x00e4_0000,
    0xf862_0000,
    0xcb35_0000,
    0x8dd7_8000,
    0xe4b8_4000,
    0x5500_e000,
    0x4c84_7000,
    0x9d4c_5800,
    0xcbfb_6400,
    0x81e4_ba00,
    0xaaeb_1700,
    0xa362_e180,
    0x5ab1_72c0,
    0xf01b_d9e0,
    0x5803_27d0,
    0x6404_5838,
    0x661f_6774,
    0x0106_b982,
    0x929e_16dd,
    0x8855_6343,
    0xa779_30c1,
    0x8cb3_391c,
    0x8913_57df,
    0x3e82_03de,
    0x6245_0222,
    0xdc7f_82ad,
    0x8d2c_430b,
    0x1cca_e1fd,
    0x9e25_70a2,
    0xc151_d83c,
    0x79e2_253e,
    0x9ef9_dba3,
    0xcd76_2440,
    0x37b3_d971,
    0x6897_26e5,
    0xdb4e_5be6,
    0x5afe_6556,
    0xfb7b_3b2f,
    0x3eb7_55d6,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x5000_0000,
    0x5800_0000,
    0x0c00_0000,
    0x3a00_0000,
    0x5d00_0000,
    0xf380_0000,
    0x0840_0000,
    0x57e0_0000,
    0x81b0_0000,
    0x7548_0000,
    0x5474_0000,
    0xe1f6_0000,
    0x26a9_0000,
    0xbbce_8000,
    0xffb8_c000,
    0xe651_e000,
    0xfced_5000,
    0x752e_b800,
    0x8384_9400,
    0xa057_5a00,
    0x33ed_c700,
    0xbfa7_e380,
    0x4644_5240,
    0xcce0_38e0,
    0x7d3c_5570,
    0xd786_bb88,
    0x9640_9644,
    0x54e9_58a6,
    0x1130_c715,
    0xbd9f_6071,
    0x9355_9057,
    0xab7f_5882,
    0x2369_c753,
    0xb779_e214,
    0xe169_53ae,
    0xd670_ba91,
    0x20e9_9577,
    0xd727_d952,
    0xb288_044b,
    0x39ce_8228,
    0x3eb8_c104,
    0x17d1_e0c6,
    0xf5ad_51a5,
    0xb34e_ba59,
    0x5b74_9603,
    0x4b7f_599c,
    0xb369_c5ea,
    0x8f79_e237,
    0xbd69_5262,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0xf000_0000,
    0xa800_0000,
    0xd400_0000,
    0xd600_0000,
    0xb300_0000,
    0xc180_0000,
    0xe7c0_0000,
    0xdba0_0000,
    0x0f70_0000,
    0x5558_0000,
    0xdde4_0000,
    0xa302_0000,
    0xd983_0000,
    0xfbc3_8000,
    0x29be_4000,
    0xc269_a000,
    0xf3cc_d000,
    0x2dba_0800,
    0x2c73_ec00,
    0xccd1_aa00,
    0x463c_3d00,
    0x7aa8_2380,
    0xb3f1_92c0,
    0xdc10_2b20,
    0xd201_7c90,
    0x5d02_03f8,
    0xfe83_009c,
    0x8c43_81de,
    0x8d7e_4293,
    0x7049_a2c8,
    0xcf7c_d0f2,
    0x7542_0963,
    0x4de7_ed86,
    0xfb0b_aadf,
    0xa59b_3e8e,
    0xf9c9_a18d,
    0x4cbc_d13d,
    0xb0e2_0a93,
    0xd597_ec8e,
    0x11d3_aacb,
    0xf8bf_3c84,
    0x96eb_a3b4,
    0xce8f_d29c,
    0x0459_8a98,
    0xc97d_af2a,
    0xfe40_0bef,
    0x0064_eee0,
    0xb6c8_2930,
    0xcf25_7e28,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x7000_0000,
    0xa800_0000,
    0xb400_0000,
    0x6600_0000,
    0x9300_0000,
    0x5780_0000,
    0x4f40_0000,
    0x2d20_0000,
    0x9970_0000,
    0x77d8_0000,
    0xd7e4_0000,
    0xc612_0000,
    0xc313_0000,
    0xef8f_8000,
    0x2354_4000,
    0x572b_a000,
    0xd87e_1000,
    0xd557_d800,
    0x5c3a_2c00,
    0xf3ee_7a00,
    0x3817_3d00,
    0x2c16_2380,
    0x1a09_50c0,
    0x310b_fb20,
    0x0a84_7f10,
    0x3fd8_0138,
    0x53e4_019c,
    0x6812_0146,
    0x9413_02b1,
    0x760f_834a,
    0x4b14_4188,
    0x4b8b_a0f3,
    0x9d4e_1376,
    0xd82f_db99,
    0x5dee_2d6e,
    0x6f04_7a12,
    0xb590_3ce4,
    0x7253_a0bd,
    0x2daa_1073,
    0x4fbd_da31,
    0x32bd_2e0d,
    0x522b_fa1c,
    0xf4f4_7c81,
    0x1980_0165,
    0x2840_0058,
    0x7ca0_01eb,
    0x3530_017a,
    0xa578_01a7,
    0xb5d4_0023,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x7000_0000,
    0x3800_0000,
    0x3400_0000,
    0x1e00_0000,
    0xf300_0000,
    0x8680_0000,
    0xc6c0_0000,
    0xf5a0_0000,
    0x6870_0000,
    0x0758_0000,
    0xebec_0000,
    0x881a_0000,
    0x6c01_0000,
    0x7a05_8000,
    0xa50b_4000,
    0x799a_a000,
    0x6a48_3000,
    0xde6b_c800,
    0xe848_0c00,
    0x2f6b_6a00,
    0xdfc1_3d00,
    0xfe25_2280,
    0x8b32_70c0,
    0xfaac_e860,
    0xbce7_7d10,
    0x3880_0298,
    0x05c0_021c,
    0x6b20_02e2,
    0xeab0_0117,
    0xd4f8_012c,
    0x449c_026a,
    0x17c2_03b3,
    0xb22d_01c2,
    0x813f_8027,
    0x67ba_4104,
    0xf167_201e,
    0x4cdf_7285,
    0x28b3_6813,
    0x05ed_3c92,
    0x031f_22bf,
    0xfe83_72b8,
    0xd2d1_6aac,
    0x9bb0_3f8a,
    0xa378_a043,
    0xb5d5_312a,
    0x332c_4b93,
    0x8eae_4d72,
    0x82ee_4b4f,
    0xbb83_4f50,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x5000_0000,
    0x9800_0000,
    0x8400_0000,
    0x7200_0000,
    0x7300_0000,
    0xdd80_0000,
    0x8640_0000,
    0x4e60_0000,
    0xff30_0000,
    0x3ed8_0000,
    0x04a4_0000,
    0x6196_0000,
    0x0051_0000,
    0xe76f_8000,
    0x1da4_c000,
    0x0b0b_2000,
    0x4981_5000,
    0x0c43_3800,
    0xe96e_6400,
    0xc8be_1a00,
    0x4f8e_3500,
    0xe54a_a380,
    0x6be0_9040,
    0xad69_9be0,
    0x9abe_f750,
    0x0c8f_81a8,
    0xf0d4_c2dc,
    0xf1b3_233e,
    0x1515_5295,
    0x648d_382f,
    0x9cdb_67f5,
    0xafa7_9a0a,
    0x580b_f722,
    0xa416_018b,
    0x4211_024a,
    0xbb0f_80c2,
    0xc194_c0db,
    0x7053_20e2,
    0x4f65_529e,
    0x51b5_3b25,
    0x650f_6557,
    0xcc89_98c1,
    0xd0ce_f608,
    0xc1b7_82d9,
    0xdd00_c219,
    0x789d_238c,
    0x6ad0_5323,
    0xaeac_b816,
    0xf68a_a73c,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x9000_0000,
    0x1800_0000,
    0x9c00_0000,
    0x3200_0000,
    0x3d00_0000,
    0x5c80_0000,
    0xb340_0000,
    0x8320_0000,
    0x5970_0000,
    0x90c8_0000,
    0x19f4_0000,
    0xd18e_0000,
    0xc7c9_0000,
    0x447c_8000,
    0xfc57_c000,
    0x42ba_e000,
    0x46a3_b000,
    0x28a1_b800,
    0x47a6_ac00,
    0xb635_5a00,
    0x41fc_1f00,
    0xed80_6380,
    0x05c9_7140,
    0xf169_d9e0,
    0x24db_dc30,
    0x5ff2_82a8,
    0xca9e_c184,
    0x1046_603a,
    0x38b4_7079,
    0x9fbb_5b1e,
    0x4a35_1dd8,
    0xe3fc_e287,
    0xc89e_b2f6,
    0xc553_39f7,
    0x7038_6ff5,
    0x9af3_3a3b,
    0x5a08_6cfb,
    0xe91b_3910,
    0x8a8c_6f38,
    0xb05d_387c,
    0xc8b1_6ee6,
    0x17af_ba4f,
    0xce2f_ad49,
    0x4de9_d87d,
    0xc79b_dd64,
    0xa4d2_83c1,
    0x9fee_c2e9,
    0xaa8e_6166,
    0x8040_7244,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x3000_0000,
    0x3800_0000,
    0x9400_0000,
    0xd600_0000,
    0x9900_0000,
    0x0380_0000,
    0x4340_0000,
    0xc5a0_0000,
    0x59f0_0000,
    0x2ec8_0000,
    0x4be4_0000,
    0xa9ca_0000,
    0x9d79_0000,
    0x9b19_8000,
    0x6c96_4000,
    0x09d2_e000,
    0x8d67_d000,
    0x7305_d800,
    0xf089_7c00,
    0x73d5_3a00,
    0x5673_af00,
    0x3f83_6180,
    0x2955_93c0,
    0xf6bd_3b60,
    0x8967_ae90,
    0x8d01_61b8,
    0x1588_9334,
    0x3a4e_b8d6,
    0xf638_efa9,
    0x22a2_01f8,
    0x7f6d_013a,
    0xc41b_8375,
    0x1e0b_42ec,
    0xd501_62f2,
    0x7188_9007,
    0x344e_b885,
    0xcb38_ecc4,
    0xcf22_00fe,
    0x312d_00a5,
    0xd43b_83da,
    0x9dbb_4225,
    0x3de9_6234,
    0x20dc_9056,
    0x76ec_b8e9,
    0x4455_efd8,
    0xd339_828a,
    0x8b26_42fd,
    0xef3a_e090,
    0xe133_d0b8,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x3000_0000,
    0x3800_0000,
    0xa400_0000,
    0xb600_0000,
    0x2900_0000,
    0x4880_0000,
    0x7a40_0000,
    0x9ba0_0000,
    0x16f0_0000,
    0x00d8_0000,
    0xeef4_0000,
    0x04ca_0000,
    0x88e9_0000,
    0x25df_8000,
    0x5c6c_4000,
    0x4d98_e000,
    0x58d6_b000,
    0x3aeb_9800,
    0x6adb_9c00,
    0x35e1_7a00,
    0xe350_2d00,
    0xab3f_6180,
    0x28be_f1c0,
    0x1d61_7b60,
    0xe910_2e50,
    0xe89f_6038,
    0xaa4e_f334,
    0x93b9_787a,
    0x8ae4_2d8d,
    0x12d5_61ac,
    0x71e7_f222,
    0x6546_fb35,
    0xba38_6f84,
    0xc435_83d2,
    0xd135_43e1,
    0x5bbf_63b2,
    0xb6fe_f36d,
    0xd0c1_7860,
    0xe6e0_2cd0,
    0x98c7_6378,
    0x9afa_f314,
    0xbad3_7a0a,
    0x3dfd_2dc5,
    0x7f52_e3d0,
    0xb93f_b3a4,
    0xb7b4_1bfe,
    0x7cf7_dc03,
    0xdbd9_99e7,
    0x0976_9fb9,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x9000_0000,
    0x3800_0000,
    0x1c00_0000,
    0xd200_0000,
    0x5100_0000,
    0xc980_0000,
    0x65c0_0000,
    0x2360_0000,
    0x21b0_0000,
    0xb458_0000,
    0x8abc_0000,
    0x48d6_0000,
    0x48fd_0000,
    0x1d60_8000,
    0xeab3_c000,
    0x38db_6000,
    0x40fe_9000,
    0xa97e_c800,
    0x1cac_7400,
    0xa7cb_aa00,
    0x0a63_e500,
    0x543b_e080,
    0x938d_5340,
    0xc0c5_aa60,
    0xbce2_e630,
    0x4b6d_61a8,
    0xe5b3_9034,
    0x4a46_4aee,
    0xa1a3_b693,
    0xf446_c94b,
    0x2aa0_7461,
    0xd8c5_a994,
    0x70e2_e4a8,
    0x016d_60b4,
    0x38b3_91ae,
    0x69c6_48f3,
    0x8963_b57b,
    0xcca6_c8c9,
    0x3fd0_7520,
    0x867d_ab06,
    0xbe2e_e747,
    0xde83_6155,
    0xdb42_93fa,
    0x8828_c97b,
    0xa191_779f,
    0xa1cb_29ff,
    0xdd60_25cf,
    0x0ab8_8167,
    0x08cf_c1d3,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x9000_0000,
    0xd800_0000,
    0xdc00_0000,
    0x3a00_0000,
    0x4d00_0000,
    0x6080_0000,
    0xf0c0_0000,
    0x76a0_0000,
    0xe570_0000,
    0xc058_0000,
    0xfe74_0000,
    0x3fde_0000,
    0x5721_0000,
    0x772c_8000,
    0x4736_c000,
    0xef31_e000,
    0x7b28_3000,
    0x4538_4800,
    0xee2f_ec00,
    0xf9af_aa00,
    0x24e2_dd00,
    0xc21d_6180,
    0xa11e_f340,
    0xf289_a8e0,
    0x29c7_dd30,
    0x2837_e188,
    0xbebd_3344,
    0xa16a_caea,
    0xc648_2cb7,
    0x196a_c938,
    0xca48_2e26,
    0x1b6a_cbb3,
    0xcb48_2e18,
    0x99ea_c89c,
    0xaa88_2d56,
    0xb5ca_caf1,
    0xf238_2ed1,
    0x63b2_caeb,
    0x19fc_2dce,
    0xea94_c807,
    0x55d9_2e5a,
    0x623e_4a7f,
    0xbbba_ec9c,
    0xc5fd_2afc,
    0xd085_1c0c,
    0x18d8_01a4,
    0x02b4_0370,
    0x4b7e_0142,
    0xb351_00c9,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x3000_0000,
    0xc800_0000,
    0xcc00_0000,
    0xd600_0000,
    0x3f00_0000,
    0xc980_0000,
    0xe540_0000,
    0x65e0_0000,
    0xb930_0000,
    0x1198_0000,
    0x915c_0000,
    0x17f2_0000,
    0xac2f_0000,
    0xf918_8000,
    0x4e9f_4000,
    0x88cf_2000,
    0xaaa1_d000,
    0xfdd5_1800,
    0x923b_5400,
    0x7a02_ba00,
    0x3905_c500,
    0xae98_8080,
    0x18df_41c0,
    0x52af_21a0,
    0xf9d1_d3f0,
    0x882d_1878,
    0x9317_57cc,
    0xcf88_ba7e,
    0x8246_c669,
    0x986a_0231,
    0x8e73_00b1,
    0x516a_8071,
    0x08f0_4351,
    0x15b7_a061,
    0x744e_9339,
    0xd762_3bc5,
    0x2ff6_84e3,
    0x483d_a176,
    0x730d_93e1,
    0x5f90_ba85,
    0x7a5a_c483,
    0x9c78_0326,
    0x946c_0069,
    0xb86a_0131,
    0xfe73_0331,
    0x396a_8231,
    0xf4f0_40b1,
    0x0bb7_a071,
    0x874e_9351,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x3000_0000,
    0x3800_0000,
    0xf400_0000,
    0x2600_0000,
    0x3300_0000,
    0xe480_0000,
    0x95c0_0000,
    0x42e0_0000,
    0xbbb0_0000,
    0xe098_0000,
    0x2bd4_0000,
    0x55fa_0000,
    0x7131_0000,
    0x8a41_8000,
    0x5fae_4000,
    0x6e88_a000,
    0x04d3_f000,
    0x6b6b_a800,
    0x3df6_a400,
    0xcd22_8a00,
    0x804b_1500,
    0x8ea1_8180,
    0xa71e_41c0,
    0xb290_a360,
    0x7ec7_f310,
    0x6271_a878,
    0x3077_a71c,
    0x657b_090a,
    0x52f1_579b,
    0x13b3_2319,
    0xfc8c_b179,
    0xf1c2_89e9,
    0x8cfb_1551,
    0x74b9_80ad,
    0xee0a_4377,
    0x5f0a_a3f4,
    0xe686_f2e1,
    0x88c8_29ea,
    0x597d_e604,
    0x18f1_a806,
    0x22b7_a769,
    0x051b_0a5e,
    0x7f81_540a,
    0x6d4b_221b,
    0x0d28_b0d9,
    0x2040_8b19,
    0x5eae_1579,
    0xaf1a_03e9,
    0x7e81_0051,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x1000_0000,
    0xb800_0000,
    0xcc00_0000,
    0xd200_0000,
    0x9900_0000,
    0x7780_0000,
    0x35c0_0000,
    0xe6e0_0000,
    0x50b0_0000,
    0x5d88_0000,
    0x40c4_0000,
    0xb37e_0000,
    0x5465_0000,
    0xb8e6_8000,
    0x3bb7_c000,
    0x431f_6000,
    0xaa8c_d000,
    0x1458_c800,
    0xfc2c_a400,
    0xfec1_2a00,
    0xc867_b700,
    0xf2ee_8180,
    0x9eb3_c340,
    0x4e81_6160,
    0x7259_d370,
    0x9b36_49a8,
    0xd25f_6554,
    0xab20_4896,
    0x9a4e_65b3,
    0xcf30_cbc5,
    0x3c58_a6d5,
    0x4837_298d,
    0x00c6_b431,
    0x9376_0393,
    0xa461_0246,
    0x10f8_83d8,
    0x4fa2_c07c,
    0x5d11_e002,
    0xe18f_1285,
    0xfad1_a926,
    0xbe71_77a8,
    0x2de9_6054,
    0x7e2d_d216,
    0xffc0_4973,
    0x83fe_64e5,
    0xbd38_ca45,
    0x955c_a595,
    0x77a9_28ed,
    0x5113_b741,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x5000_0000,
    0xd800_0000,
    0x5c00_0000,
    0x9e00_0000,
    0x3100_0000,
    0xf780_0000,
    0x0b40_0000,
    0xf1e0_0000,
    0x2930_0000,
    0x6198_0000,
    0xfe44_0000,
    0xa466_0000,
    0xdd61_0000,
    0x8ee8_8000,
    0x77ac_4000,
    0xa14b_e000,
    0xcaed_d000,
    0x95b9_1800,
    0x3e4e_1400,
    0x847a_7a00,
    0xed7f_8500,
    0x06f0_8380,
    0xf3a8_4040,
    0x634d_e2e0,
    0x65fc_d030,
    0x5329_9918,
    0xc296_55b4,
    0x7ecf_9ba6,
    0x35b7_55e9,
    0x4e47_1b99,
    0x6c6b_14c9,
    0x3974_faa1,
    0x1cf2_c66d,
    0x00b3_e18f,
    0x3bd9_d178,
    0xa827_1bec,
    0x5e1b_1672,
    0x110c_fbbf,
    0xc786_c6c8,
    0x834d_e0b4,
    0x75fc_d026,
    0xeb29_99a9,
    0xce96_5779,
    0x38cf_9bf9,
    0x58b7_5539,
    0x27c7_1819,
    0x562b_1489,
    0x3f14_f841,
    0x3e82_c65d,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xb000_0000,
    0x5800_0000,
    0xbc00_0000,
    0x6e00_0000,
    0x8500_0000,
    0xf780_0000,
    0xf9c0_0000,
    0xb6a0_0000,
    0x9ef0_0000,
    0x4098_0000,
    0x354c_0000,
    0xf5f2_0000,
    0x720d_0000,
    0x1b14_8000,
    0x0a9e_4000,
    0x024b_6000,
    0x7965_5000,
    0x1146_4800,
    0x47ec_2c00,
    0x0901_aa00,
    0x819b_3d00,
    0xe0de_8280,
    0x9f2f_43c0,
    0xba35_e1e0,
    0xbdba_1030,
    0x3c6b_a8d8,
    0x86da_3ce4,
    0x2e38_0066,
    0x57bc_00f3,
    0xfb6a_0184,
    0x7241_035c,
    0x4166_82b8,
    0x3d53_405e,
    0xc1ff_e36d,
    0x680b_1309,
    0xa415_2865,
    0xf205_7e05,
    0x5b15_e0bf,
    0x2a8a_12b4,
    0xb253_a9ce,
    0x2166_3eef,
    0xad52_00d6,
    0x29fd_0121,
    0x8c0c_82f3,
    0x7612_4084,
    0x1919_63dc,
    0x2998_5078,
    0x24ca_c93e,
    0xfd3e_6d9d,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0xf000_0000,
    0xd800_0000,
    0xcc00_0000,
    0xba00_0000,
    0x1100_0000,
    0xb180_0000,
    0xbec0_0000,
    0xd160_0000,
    0x9830_0000,
    0xa498_0000,
    0x1144_0000,
    0xb0b2_0000,
    0x6fd5_0000,
    0x40ea_8000,
    0xb6f2_c000,
    0x5df3_6000,
    0x9d7b_1000,
    0x6232_6800,
    0xd58b_b400,
    0x50d3_8a00,
    0xd676_6500,
    0x72b8_8380,
    0x62d7_c2c0,
    0x0361_e2e0,
    0xfd3d_d0f0,
    0x930b_0988,
    0xdc91_a774,
    0x0d41_622e,
    0x42ae_13bf,
    0x9ad8_e803,
    0x5f79_775b,
    0x6f20_e8b7,
    0x960d_7415,
    0x1b0a_e938,
    0x189c_777e,
    0x3352_69e7,
    0x0dbb_b46f,
    0x944b_8939,
    0x3732_677a,
    0x1a0a_82a3,
    0xc102_c229,
    0xf98b_6382,
    0x5acf_119f,
    0x7f78_6b13,
    0xff2a_b7a3,
    0xbe13_098b,
    0x0f15_a42f,
    0x6e93_6099,
    0x984b_12aa,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x3000_0000,
    0x0800_0000,
    0x0c00_0000,
    0x9e00_0000,
    0x7700_0000,
    0xf980_0000,
    0x0440_0000,
    0x7c60_0000,
    0x83b0_0000,
    0xea88_0000,
    0xbfdc_0000,
    0x8922_0000,
    0x4557_0000,
    0x0ef8_8000,
    0xc866_4000,
    0xd9b3_2000,
    0x2f9c_d000,
    0x9f44_3800,
    0x0bff_c400,
    0xc8e7_9a00,
    0x6b69_5700,
    0xaa3a_8280,
    0xf6c1_43c0,
    0xf7a3_a0a0,
    0x9096_90f0,
    0x4add_1a58,
    0xa1a8_15ec,
    0xcb99_239e,
    0x1d57_d2cd,
    0xdafe_ba97,
    0x427e_86df,
    0x04a4_387b,
    0x3b0f_c7c1,
    0x878f_9976,
    0x6345_55f6,
    0xbdf0_8359,
    0x83fa_41d5,
    0x04f1_2074,
    0xd57b_d0bd,
    0xed34_bb0f,
    0x0745_8793,
    0xfff6_b915,
    0x72e2_8454,
    0xbe66_3a8d,
    0xb2a8_c677,
    0x701f_18cf,
    0xe80f_1733,
    0x1c09_a1e5,
    0xa61d_920c,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x1000_0000,
    0x7800_0000,
    0xac00_0000,
    0x5a00_0000,
    0x1100_0000,
    0x5380_0000,
    0xf340_0000,
    0x63e0_0000,
    0xed30_0000,
    0xca98_0000,
    0x04cc_0000,
    0x2ea6_0000,
    0x01dd_0000,
    0xeb32_8000,
    0x898a_c000,
    0xa243_6000,
    0x1063_5000,
    0x0e73_9800,
    0xd16e_5400,
    0x45fa_7a00,
    0xbe3b_c500,
    0x1414_8280,
    0x9617_c140,
    0x7b11_e160,
    0x2a99_92f0,
    0x74c8_f888,
    0x66b1_06f4,
    0xc5d7_e226,
    0x6534_9289,
    0x6e82_7841,
    0xbac7_c439,
    0xa1aa_8145,
    0xcd46_c017,
    0xace5_6278,
    0x01be_5010,
    0x9d41_1bb8,
    0xf4e4_975c,
    0xbdb9_1bc2,
    0xbf58_9497,
    0x49e7_1a54,
    0xb439_959a,
    0x5d0b_9b7b,
    0x7992_55fe,
    0xaa44_7bc9,
    0xf46a_c521,
    0x9060_00c9,
    0x4e70_02cd,
    0xf178_0363,
    0x55fc_029e,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x3000_0000,
    0xd800_0000,
    0xc400_0000,
    0xb200_0000,
    0x1d00_0000,
    0xf180_0000,
    0xe440_0000,
    0xfce0_0000,
    0x3430_0000,
    0xbd18_0000,
    0x818c_0000,
    0x1c42_0000,
    0x08fd_0000,
    0x5e33_8000,
    0x6416_c000,
    0xc219_e000,
    0xe51f_9000,
    0x059f_b800,
    0x8e40_9400,
    0x25f7_da00,
    0x77b4_c500,
    0x4442_0280,
    0x8cfd_01c0,
    0xcc33_83e0,
    0x4916_c3d0,
    0xeb99_e1a8,
    0xc55f_9364,
    0x4b7f_b90e,
    0xa770_97e5,
    0x696f_da35,
    0x1278_c641,
    0xa4e0_0387,
    0xb030_0316,
    0x2f18_0165,
    0xac8c_01f5,
    0x35c2_00a1,
    0x28bd_02d7,
    0x10d3_837e,
    0x4d26_c1e1,
    0x8e81_e32b,
    0x80d3_92ec,
    0xe53d_b986,
    0xb28d_9531,
    0xc6dc_5903,
    0x922e_04c8,
    0x9a19_e1a8,
    0x611f_9364,
    0x979f_b90e,
    0xa340_97e5,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x3000_0000,
    0x2800_0000,
    0x2c00_0000,
    0x9600_0000,
    0x0700_0000,
    0x1480_0000,
    0xd4c0_0000,
    0x4c60_0000,
    0x2330_0000,
    0xc318_0000,
    0x8e84_0000,
    0x15ca_0000,
    0x47e3_0000,
    0xe770_8000,
    0xe1af_4000,
    0x70c6_2000,
    0xe660_7000,
    0xca27_0800,
    0xe48d_9400,
    0xdcdb_aa00,
    0x3061_a500,
    0xad2a_0380,
    0xc013_01c0,
    0x2008_8120,
    0x501b_4070,
    0x1814_22f8,
    0x0407_70ac,
    0xba1d_8a0a,
    0x9101_d74f,
    0x138d_0b63,
    0xc05e_96df,
    0x98b3_29bd,
    0x6f4a_e776,
    0xe026_207b,
    0x4d90_7255,
    0x9b5f_08b2,
    0x5239_96f5,
    0xa089_aaf4,
    0x06c6_a6e0,
    0x9170_8250,
    0x96af_4208,
    0x2c46_2314,
    0x2ea0_72c6,
    0x3847_0955,
    0xecbd_94c4,
    0x9d43_aaf8,
    0x6d25_a4ac,
    0xe000_000a,
    0x7000_024f,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x3000_0000,
    0x3800_0000,
    0xe400_0000,
    0x4e00_0000,
    0x7b00_0000,
    0x8080_0000,
    0x46c0_0000,
    0x3f60_0000,
    0xda30_0000,
    0x1708_0000,
    0xd29c_0000,
    0xb7c2_0000,
    0xbae1_0000,
    0x5f6b_8000,
    0x0a3d_4000,
    0x3f0a_a000,
    0x3e85_7000,
    0x25dd_c800,
    0x6bf2_b400,
    0xeafe_ea00,
    0xb76b_8700,
    0xc622_0280,
    0x9d11_03c0,
    0xd783_8060,
    0x7451_4350,
    0x98a0_a1d8,
    0x68c8_727c,
    0x947c_4b3a,
    0x72b2_f4f7,
    0xbddd_c8ff,
    0x7ff2_b573,
    0xbcfe_ea21,
    0x186b_87e2,
    0x30a2_00e3,
    0x44d1_01f1,
    0x2663_82fa,
    0x93a1_407f,
    0x3048_a25b,
    0x26a4_73b5,
    0x0bd6_4bac,
    0xc0ff_f6ca,
    0x427c_4b9f,
    0x1db2_f54b,
    0x6b5d_c84d,
    0x9632_b5a0,
    0x751e_e9d8,
    0x1b9b_867c,
    0xd64a_013a,
    0x71bd_03f7,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0xb000_0000,
    0xd800_0000,
    0x5c00_0000,
    0xe200_0000,
    0xe500_0000,
    0x5d80_0000,
    0x4ac0_0000,
    0x10a0_0000,
    0xcaf0_0000,
    0xe908_0000,
    0x1794_0000,
    0x4bda_0000,
    0x432d_0000,
    0x5f20_8000,
    0x1d3f_c000,
    0x2824_e000,
    0x1da5_1000,
    0xd36b_e800,
    0x7dc9_cc00,
    0xb035_8a00,
    0xe1be_1f00,
    0xe17a_0380,
    0xf0dd_01c0,
    0x69a8_82e0,
    0x156b_c3b0,
    0xf6de_e0e8,
    0x82b8_12e4,
    0x97e3_6afe,
    0x5892_0ebf,
    0x6743_6b34,
    0xe262_0d00,
    0x364b_6866,
    0x19f6_0eb5,
    0x4791_6a6b,
    0xe3db_0de2,
    0xa731_eb3b,
    0x5124_ce5c,
    0xc235_0bc2,
    0xccb1_de0d,
    0xe8f6_e1b1,
    0x6c1c_10a5,
    0xfa11_6a75,
    0xd91b_0c0b,
    0x0f91_e812,
    0x77d4_cef3,
    0x113d_08e8,
    0x6225_dee4,
    0x1cac_e0fe,
    0x80f1_11bf,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0xd000_0000,
    0x4800_0000,
    0xfc00_0000,
    0xca00_0000,
    0x4d00_0000,
    0xe180_0000,
    0x2a40_0000,
    0x2a20_0000,
    0xf0f0_0000,
    0x2b18_0000,
    0x6e84_0000,
    0x1ad6_0000,
    0xfbf3_0000,
    0xf586_8000,
    0xec4e_c000,
    0x553c_e000,
    0x387f_9000,
    0x9ec8_7800,
    0x15fb_8c00,
    0xa684_1a00,
    0xa6c9_dd00,
    0x51ee_0380,
    0x6887_0240,
    0x45c8_80a0,
    0x8379_c0b0,
    0xd84c_6208,
    0x2332_52c4,
    0xdf6a_18ae,
    0xe24e_dd9d,
    0x9626_812e,
    0x5afe_c26a,
    0xb604_e184,
    0xc70b_9139,
    0xcc86_79e7,
    0x1bcc_8da5,
    0x4874_9a95,
    0x26c4_1c6a,
    0x11ec_6284,
    0x0882_51b9,
    0x95d2_1b27,
    0xcb7a_dfc5,
    0x2448_8045,
    0xe939_c0b2,
    0x926c_6298,
    0x03c2_520b,
    0xbc72_1988,
    0x70ca_dc84,
    0x46f0_820e,
    0xec0d_c02d,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x3000_0000,
    0x1800_0000,
    0xec00_0000,
    0x5a00_0000,
    0xc300_0000,
    0x7280_0000,
    0x67c0_0000,
    0x3320_0000,
    0x5970_0000,
    0xcd08_0000,
    0x1784_0000,
    0x445a_0000,
    0x2165_0000,
    0xd10e_8000,
    0xb58e_c000,
    0x5b4f_2000,
    0x11f0_3000,
    0x99d1_a800,
    0xae2f_1c00,
    0xa6ea_0a00,
    0x9d44_ef00,
    0xb0f2_0180,
    0x1451_03c0,
    0xc97c_83e0,
    0xc51f_c370,
    0x3393_a108,
    0xda5f_f0bc,
    0x4c6a_08a2,
    0xd684_ee93,
    0x39d2_0306,
    0xbe21_03fa,
    0x6ef4_8078,
    0x595b_c1fb,
    0x1ee9_a245,
    0x614a_f36b,
    0x22ec_8b3d,
    0x134e_2d5f,
    0x15e7_21e3,
    0xd7c4_300e,
    0xeb23_a846,
    0x557e_1f5a,
    0xa716_89a8,
    0xcc9b_2c23,
    0xdac1_a1a1,
    0x1cbe_f26d,
    0x213e_8888,
    0x9e6f_2f7c,
    0xf193_a142,
    0x355f_f2e3,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x3000_0000,
    0x5800_0000,
    0x4c00_0000,
    0x8e00_0000,
    0x5d00_0000,
    0x1580_0000,
    0xd640_0000,
    0x2e20_0000,
    0x84f0_0000,
    0x5b08_0000,
    0x0c8c_0000,
    0xc9d2_0000,
    0x0f6d_0000,
    0x7852_8000,
    0x8320_4000,
    0x697e_6000,
    0xf147_1000,
    0xf4bf_7800,
    0x5c34_8c00,
    0xcfe1_9a00,
    0xff8e_df00,
    0x715a_0080,
    0x34a1_03c0,
    0xfc20_83e0,
    0xfffd_41f0,
    0xa784_e358,
    0x3d5b_5044,
    0xbabb_1a6e,
    0xa122_9e2d,
    0xea76_62ee,
    0x71cb_124a,
    0x136d_7b54,
    0x3e59_8ee1,
    0xfa33_192b,
    0xe6ee_9e3f,
    0xb804_607e,
    0x1c16_1085,
    0x4617_fbf2,
    0x7905_cf60,
    0x8f97_7b97,
    0x4948_8fe2,
    0xe8bb_9b6f,
    0x1a2f_df51,
    0xb6fa_80d3,
    0x701c_40ab,
    0x3804_63d8,
    0xdc16_1384,
    0xe617_f98e,
    0x4905_cfdd,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x9000_0000,
    0x9800_0000,
    0x8400_0000,
    0xe600_0000,
    0x1300_0000,
    0x7880_0000,
    0xafc0_0000,
    0x1ee0_0000,
    0xccb0_0000,
    0xde08_0000,
    0x2704_0000,
    0x768e_0000,
    0x30c1_0000,
    0x9c63_8000,
    0x127c_4000,
    0x4d76_a000,
    0x2ff9_7000,
    0x613c_e800,
    0x6a43_2400,
    0xe6af_ca00,
    0x1703_1700,
    0x5e88_0180,
    0x5cc4_0140,
    0xf66e_01e0,
    0xfb71_0050,
    0x44eb_81f8,
    0x0db8_425c,
    0xbb98_a27a,
    0x6f48_72f3,
    0x4537_6999,
    0x3c4b_658d,
    0x1dbf_6903,
    0xe38f_64ae,
    0x0b51_6b22,
    0x333e_651f,
    0xb75a_e84b,
    0xe136_27da,
    0xaa4a_4b3c,
    0x06ba_57ea,
    0x8713_212b,
    0xc680_30b5,
    0xd8c7_c9ff,
    0x1077_1464,
    0xe86e_03f9,
    0x3c71_0162,
    0xa26b_8180,
    0xa578_4140,
    0xa3f8_a1e0,
    0x9b38_7050,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0xb000_0000,
    0x2800_0000,
    0x8c00_0000,
    0x2a00_0000,
    0x9b00_0000,
    0xe780_0000,
    0xfb40_0000,
    0x8620_0000,
    0x43f0_0000,
    0xae08_0000,
    0x4d0c_0000,
    0xde82_0000,
    0xbbd3_0000,
    0x98f4_8000,
    0x2984_c000,
    0xa64e_2000,
    0xc0bb_9000,
    0x5c25_9800,
    0x90e2_ac00,
    0xd595_3a00,
    0x0442_ff00,
    0x67a8_0080,
    0xb9bc_01c0,
    0x7caa_0220,
    0x9e2f_00f0,
    0x27fe_8008,
    0xa81b_c05c,
    0x4c18_a336,
    0x8a1c_5181,
    0x2b17_3986,
    0xcf91_fee2,
    0x775c_82a0,
    0xac38_c33b,
    0xd8e4_2342,
    0x4994_911b,
    0xb65b_19b9,
    0x58b9_6c79,
    0xf82d_9a52,
    0x36ee_aec8,
    0x6497_38f7,
    0x78d1_ff6c,
    0x7b7c_801e,
    0xc4c8_c0ad,
    0xb96c_22f8,
    0x73d8_915f,
    0xc4f9_1880,
    0x3b9a_6dc0,
    0x2951_1820,
    0xa926_6ff0,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x3000_0000,
    0xc800_0000,
    0x3c00_0000,
    0xda00_0000,
    0x5300_0000,
    0x2e80_0000,
    0x1140_0000,
    0x94a0_0000,
    0x7e70_0000,
    0xac08_0000,
    0x0204_0000,
    0x771a_0000,
    0x309f_0000,
    0x6c5e_8000,
    0x0f3c_c000,
    0xc8a1_2000,
    0x5467_b000,
    0xd713_f800,
    0x2092_bc00,
    0x745e_5a00,
    0xcb22_cf00,
    0xe6a0_0180,
    0xe170_03c0,
    0x7088_00a0,
    0x4c44_0030,
    0xdf3a_0048,
    0x30af_01bc,
    0xa076_83d2,
    0x3108_c109,
    0xa993_22e8,
    0x09cc_b1bc,
    0xf4ff_78e2,
    0x6345_7df1,
    0x0bb3_f96c,
    0xa2e2_bfca,
    0xe256_59ed,
    0xaa26_cf3e,
    0x773a_0033,
    0xfcaf_025d,
    0x5276_83b6,
    0x6e08_c0af,
    0x9513_227f,
    0x778c_b257,
    0x94df_7bcb,
    0x5f75_7c59,
    0x1d9b_f800,
    0xcfd6_bc00,
    0xade4_5a00,
    0xe6cd_cf00,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x7000_0000,
    0x2800_0000,
    0x5400_0000,
    0xba00_0000,
    0x8500_0000,
    0x4380_0000,
    0x29c0_0000,
    0x70e0_0000,
    0x81b0_0000,
    0x4c08_0000,
    0xa60c_0000,
    0xbb1a_0000,
    0x248b_0000,
    0x934f_8000,
    0xf4bd_c000,
    0xe797_e000,
    0x7bc0_d000,
    0x01f9_4800,
    0x0835_2400,
    0xc8d3_2a00,
    0xc17f_3700,
    0xa960_0080,
    0x9d70_02c0,
    0xf768_0220,
    0x2a7c_0090,
    0x15f2_0248,
    0xd237_0344,
    0x9ddd_83e6,
    0xdafa_c2b3,
    0xfca2_60cd,
    0x0386_12a1,
    0x49c9_28f3,
    0xa0f4_349e,
    0xd9af_81dc,
    0x300d_c10a,
    0x481f_e221,
    0x840c_d280,
    0xe203_4973,
    0xf90e_276d,
    0xad94_ab71,
    0x16ce_f4db,
    0xb66d_e2aa,
    0xebfb_d142,
    0x153e_ca65,
    0x5744_e7e6,
    0x76be_c800,
    0xce84_e400,
    0x8e5e_ca00,
    0x6b34_e700,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x7000_0000,
    0x1800_0000,
    0xec00_0000,
    0xf200_0000,
    0xa100_0000,
    0x8e80_0000,
    0xcbc0_0000,
    0xdd20_0000,
    0xe790_0000,
    0x2a08_0000,
    0xed04_0000,
    0xec8e_0000,
    0x02c7_0000,
    0xa7a1_8000,
    0x325e_c000,
    0xa427_2000,
    0x251e_1000,
    0x83ce_e800,
    0xf92f_bc00,
    0x7192_5200,
    0xfd0f_b900,
    0xc488_0080,
    0x16c4_0040,
    0xc9ae_00e0,
    0x7957_0070,
    0x67a9_8018,
    0x925a_c0ec,
    0x3429_20f2,
    0x4d19_10a1,
    0x77cf_688e,
    0xe721_7ccb,
    0x229d_72dd,
    0xd285_a9e7,
    0x81c0_e8aa,
    0x0028_bcad,
    0xf313_d20c,
    0xb4c1_7972,
    0xa0a7_203f,
    0x93de_109e,
    0xda6e_e8b6,
    0xe87f_bcf4,
    0xe23a_5215,
    0x715b_b9de,
    0xa3ae_00de,
    0x7457_00fb,
    0xfb29_8080,
    0x889a_c040,
    0x7f89_20e0,
    0x8d49_1070,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x1000_0000,
    0x1800_0000,
    0xbc00_0000,
    0xce00_0000,
    0xab00_0000,
    0xbe80_0000,
    0x9840_0000,
    0x1720_0000,
    0x1750_0000,
    0xe208_0000,
    0xbd0c_0000,
    0x8982_0000,
    0xf8c1_0000,
    0x3c61_8000,
    0x02fb_c000,
    0xa314_e000,
    0xe32e_b000,
    0x9d55_e800,
    0x0b02_8400,
    0x6e8d_f200,
    0xa049_3500,
    0xbb28_0080,
    0xc15c_00c0,
    0xf50a_0020,
    0xcd8d_0010,
    0xbac3_8018,
    0x516a_c0bc,
    0xb37d_60ce,
    0xf7d9_70ab,
    0x0943_08be,
    0x88ad_3498,
    0xd899_9a17,
    0xbee0_7117,
    0x94b9_1262,
    0x3f37_857d,
    0x5af5_e829,
    0xff12_8428,
    0x1d25_f204,
    0x3e55_35ae,
    0x1182_00f5,
    0x84c1_0034,
    0xd261_80cd,
    0xb9fb_c028,
    0x0594_e0df,
    0xc76e_b093,
    0x4475_e880,
    0xb752_84c0,
    0x3205_f220,
    0x8505_3510,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0xf000_0000,
    0xb800_0000,
    0x8400_0000,
    0xd600_0000,
    0x8300_0000,
    0xdc80_0000,
    0x6f40_0000,
    0x5620_0000,
    0x80b0_0000,
    0x5a08_0000,
    0xc90c_0000,
    0x9d86_0000,
    0xaecf_0000,
    0x5aeb_8000,
    0x3758_4000,
    0xb6d5_6000,
    0x1a1c_3000,
    0x3dff_c800,
    0x992b_f400,
    0x763b_e200,
    0x844a_cb00,
    0xe6a8_0080,
    0x95fc_00c0,
    0x952e_0060,
    0xfc33_00f0,
    0xa545_80b8,
    0xd72b_4084,
    0x2130_e0d6,
    0xa6c7_7083,
    0xc6e7_28dc,
    0xf550_846f,
    0xabd2_ca56,
    0x7999_4f80,
    0xdc37_4ada,
    0xf542_0f09,
    0xff2f_aa7d,
    0xed39_7f9e,
    0x4cc6_8202,
    0x17ea_fb83,
    0x7cd9_c838,
    0x9b14_f42d,
    0x9c78_62ef,
    0x65ee_8b01,
    0x79d3_6012,
    0xec93_30ac,
    0xe3b4_4880,
    0xb683_b4c0,
    0x7e46_8260,
    0xbfaa_fbf0,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0xb000_0000,
    0x3800_0000,
    0xd400_0000,
    0xca00_0000,
    0xa700_0000,
    0xd980_0000,
    0xc8c0_0000,
    0x9ce0_0000,
    0xec50_0000,
    0x7608_0000,
    0xf10c_0000,
    0x3886_0000,
    0x184b_0000,
    0xd8a3_8000,
    0x12fd_4000,
    0xddf4_a000,
    0x987e_7000,
    0x16bf_9800,
    0x8355_8c00,
    0xe383_4e00,
    0xf7c1_0500,
    0x4168_0080,
    0x669c_00c0,
    0xa1ee_0060,
    0xdad7_00b0,
    0xeb4d_8038,
    0x0b2a_40d4,
    0x1d39_20ca,
    0x2894_30a7,
    0x84e6_b8d9,
    0x2851_bcc8,
    0x540d_f69c,
    0x0a0c_b9ec,
    0xc70b_f6f6,
    0x6987_b931,
    0xf0c8_76d8,
    0x48ea_f968,
    0x2654_d600,
    0xd108_89b6,
    0x2885_4ecf,
    0xf04a_059b,
    0x84ab_80dd,
    0x34f1_4048,
    0x64f2_a034,
    0x2cf5_7010,
    0xa0fc_1880,
    0x0ef8_ccc0,
    0x5bff_ee60,
    0xf173_75b0,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0xb000_0000,
    0x7800_0000,
    0xec00_0000,
    0x5200_0000,
    0x1300_0000,
    0x4380_0000,
    0xd0c0_0000,
    0x9de0_0000,
    0x1f90_0000,
    0x5b08_0000,
    0x9784_0000,
    0xceca_0000,
    0x6ceb_0000,
    0x3717_8000,
    0x2446_c000,
    0x88a1_2000,
    0x5fbb_3000,
    0x6bf7_3800,
    0x2b56_8c00,
    0xe0e1_1e00,
    0x3511_d900,
    0x5f4a_0080,
    0xef2b_0040,
    0x4977_80a0,
    0x5b16_c0b0,
    0x3649_2078,
    0x3baf_30ec,
    0xac35_3852,
    0xc339_8c13,
    0x5abc_9e43,
    0xad7c_19d0,
    0x7d1c_a01d,
    0x8b46_f05f,
    0xf129_98fb,
    0xb87f_7c27,
    0x7395_06b6,
    0x4903_6580,
    0x2489_a6e5,
    0x3d45_9577,
    0xc420_3eeb,
    0x46fa_e97f,
    0x69d5_38ae,
    0xc0a9_8c28,
    0x8bb4_9e31,
    0x75f8_19ed,
    0xda56_a078,
    0xc86d_f0ec,
    0x4a5e_1852,
    0x4069_bc13,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0xb000_0000,
    0xa800_0000,
    0xc400_0000,
    0x2e00_0000,
    0xdb00_0000,
    0x3f80_0000,
    0xf040_0000,
    0x8520_0000,
    0x1810_0000,
    0xdd08_0000,
    0x6084_0000,
    0x01ce_0000,
    0x1e6b_0000,
    0x0aba_8000,
    0xf154_4000,
    0x16ae_e000,
    0xa257_b000,
    0xfd2e_f800,
    0x841a_8400,
    0x7f08_9200,
    0xe180_2100,
    0x6346_0080,
    0xceaf_0040,
    0x6e54_80e0,
    0x472f_40b0,
    0x691c_60a8,
    0xf787_f0c4,
    0xc44e_182e,
    0xe326_34db,
    0xb71c_ea3f,
    0x648e_e5f0,
    0x8fc0_7205,
    0x9568_9158,
    0x2d34_78bd,
    0x6d1e_c490,
    0x798e_7249,
    0x4f43_916a,
    0xc4ae_f80c,
    0x2b5a_84ae,
    0x0ba8_92e7,
    0x62d0_2139,
    0xacee_006f,
    0x827b_00e8,
    0x19b2_80e9,
    0xfad0_40f2,
    0x80e0_e028,
    0x887c_b084,
    0x5cb4_78ce,
    0xb65e_c46b,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0xf000_0000,
    0x3800_0000,
    0xbc00_0000,
    0xea00_0000,
    0xd900_0000,
    0x1680_0000,
    0xb6c0_0000,
    0xcce0_0000,
    0x2dd0_0000,
    0x3f08_0000,
    0x7d8c_0000,
    0x954a_0000,
    0x4eaf_0000,
    0x0af3_8000,
    0x9eb3_c000,
    0xea9a_a000,
    0xd4a3_9000,
    0x2bf8_6800,
    0x9435_ec00,
    0x465f_8e00,
    0xf94a_3d00,
    0xaca2_0080,
    0xf7f3_00c0,
    0x2e31_80a0,
    0x5750_c0f0,
    0x6bc3_2038,
    0x4c6f_50bc,
    0x0819_48ea,
    0xcc69_bcd9,
    0xc817_4616,
    0x6c63_41b6,
    0x381e_664c,
    0x5463_11ed,
    0x8414_ae1f,
    0xbe69_6d4d,
    0x5d11_488d,
    0xa8e5_bcc2,
    0xebdd_4678,
    0x640c_410b,
    0xc60d_e6ae,
    0x5b00_d1c7,
    0xbb86_0e3b,
    0xce46_fde6,
    0xf523_20bb,
    0xc4bf_5093,
    0x6b91_48b8,
    0x2e25_bc7c,
    0xbf3d_464a,
    0x05dc_4129,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0xb000_0000,
    0xd800_0000,
    0xe400_0000,
    0xb600_0000,
    0x5700_0000,
    0x2880_0000,
    0x08c0_0000,
    0x9ea0_0000,
    0x3ef0_0000,
    0x0888_0000,
    0x18c4_0000,
    0x16ae_0000,
    0xb2fb_0000,
    0x8285_8000,
    0x1dca_4000,
    0xdf25_6000,
    0xc5be_7000,
    0x3c67_0800,
    0xb55a_cc00,
    0x77f4_8a00,
    0xeb01_9f00,
    0x3a85_8080,
    0x09ca_4040,
    0x5125_60e0,
    0xc6be_70b0,
    0x7ae7_08d8,
    0x0e9a_cce4,
    0x77d4_8ab6,
    0x8a31_9f57,
    0x842d_80a8,
    0x273e_4048,
    0xd1a3_607e,
    0x5271_708e,
    0xe644_88d0,
    0xb96f_8cfc,
    0x3cda_6aa0,
    0xe0be_afe5,
    0xe5ea_682a,
    0x4a10_bc55,
    0x4515_82a1,
    0xc994_534b,
    0x9752_8a6c,
    0xeefe_9f09,
    0x208e_00b7,
    0xc4cb_00fe,
    0xf4ad_80a8,
    0x8bfe_4048,
    0x1903_607e,
    0x8b81_708e,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0xb000_0000,
    0x7800_0000,
    0x9400_0000,
    0x6a00_0000,
    0xdb00_0000,
    0x6080_0000,
    0xea40_0000,
    0xed60_0000,
    0xe950_0000,
    0x0888_0000,
    0x9644_0000,
    0xbb66_0000,
    0x045b_0000,
    0x350f_8000,
    0x398d_4000,
    0x6dc0_a000,
    0x51a6_b000,
    0xb371_8800,
    0x493f_e400,
    0x4c54_7600,
    0x9909_2500,
    0xa78f_8080,
    0x6ccd_4040,
    0x9220_a060,
    0xadb6_b0b0,
    0x2419_8878,
    0x936b_e494,
    0x185a_766a,
    0xd306_25db,
    0xac8e_00e0,
    0xc44f_00aa,
    0x9461_808d,
    0xbed2_4059,
    0x7c49_2070,
    0x2060_f002,
    0x04d6_a8d1,
    0x6f40_14df,
    0xaceb_5e55,
    0x109f_71d3,
    0x332b_fe00,
    0xfe39_c1f8,
    0x92da_765b,
    0xa246_252f,
    0x416e_006f,
    0x775f_00f9,
    0x0989_80e0,
    0x55c6_40aa,
    0xa5a7_208d,
    0x697f_f059,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x3000_0000,
    0x6800_0000,
    0x2c00_0000,
    0x3600_0000,
    0x1300_0000,
    0x6380_0000,
    0x6240_0000,
    0x78a0_0000,
    0x8930_0000,
    0x0f88_0000,
    0x344c_0000,
    0xfbaa_0000,
    0xb2b3_0000,
    0x29ce_8000,
    0x56ee_c000,
    0x5799_6000,
    0xcdba_3000,
    0x1c44_b800,
    0xb7a2_e400,
    0x14bd_ea00,
    0x62c4_2300,
    0x716e_8080,
    0x2fde_c0c0,
    0x9011_60a0,
    0xe5f6_3030,
    0xb9ee_b868,
    0x3a11_e42c,
    0x68f3_6a36,
    0x456a_e313,
    0x3dd7_e0e3,
    0x0914_f0a2,
    0xfb7d_d8d8,
    0xef28_d4b9,
    0x5971_5267,
    0xde2a_c718,
    0xcbf9_6a4d,
    0x8ee9_e361,
    0xd391_606a,
    0x77b6_30c4,
    0x094e_b8e7,
    0xaf21_e458,
    0x397b_6a4d,
    0x4e26_e3bc,
    0x93fd_e03a,
    0xcae7_f061,
    0xc993_58e3,
    0x52b6_14a2,
    0x79c0_32d8,
    0xaeec_f7b9,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x3000_0000,
    0x2800_0000,
    0x0400_0000,
    0x4a00_0000,
    0xad00_0000,
    0xce80_0000,
    0xffc0_0000,
    0x4520_0000,
    0x1990_0000,
    0x9288_0000,
    0x79cc_0000,
    0xb622_0000,
    0x2813_0000,
    0x22ca_8000,
    0x43ac_4000,
    0xf256_a000,
    0x85a1_d000,
    0xe152_6800,
    0xa425_bc00,
    0x491f_f200,
    0xb243_c900,
    0x436a_8080,
    0xf8fc_40c0,
    0xe37e_a020,
    0x2e3d_d030,
    0xe2d8_6828,
    0x456a_bc04,
    0xcbff_724a,
    0xf2f0_89ad,
    0xae74_a04e,
    0xf0b2_d03f,
    0x0518_e865,
    0x2c49_fc29,
    0x9c69_52ba,
    0x8772_197d,
    0xb430_e87c,
    0x77d5_fc45,
    0x97e3_52cc,
    0x523d_198c,
    0x54d0_681f,
    0x9e66_bc58,
    0xfe7d_7219,
    0x08b3_8940,
    0x3916_2099,
    0x7a42_90a1,
    0x5764_484e,
    0xaaf7_2c3f,
    0x6273_ba65,
    0xaeb8_e529,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x7000_0000,
    0x7800_0000,
    0x7400_0000,
    0xf600_0000,
    0x5f00_0000,
    0x7f80_0000,
    0x5d40_0000,
    0xe0e0_0000,
    0xf010_0000,
    0x9988_0000,
    0xea4c_0000,
    0xc362_0000,
    0x2757_0000,
    0xdc6f_8000,
    0xb8db_4000,
    0xd125_6000,
    0x503e_f000,
    0x2d3a_7800,
    0x4bb1_9400,
    0x6e70_ee00,
    0xa85c_b100,
    0x6be7_8080,
    0xc997_40c0,
    0xc3c7_6020,
    0x7129_f070,
    0xe035_f878,
    0x753a_d474,
    0x4fbd_8ef6,
    0xe07e_415f,
    0x8357_f8ff,
    0xe26d_d49d,
    0xcbd2_0ec0,
    0x5ca5_0180,
    0xdc72_9861,
    0x9953_245e,
    0x6f68_7615,
    0x1554_9508,
    0x2d62_765b,
    0x9c5f_9551,
    0x7de7_f667,
    0xc69f_d54f,
    0xb44f_1613,
    0x206d_6538,
    0x82df_8e63,
    0x2c29_41e4,
    0xf6b8_787f,
    0x28f6_945d,
    0xfd97_6ee0,
    0xd5cb_f1f0,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0xd000_0000,
    0xa800_0000,
    0xe400_0000,
    0x6600_0000,
    0x1100_0000,
    0xff80_0000,
    0x30c0_0000,
    0x90a0_0000,
    0x7270_0000,
    0xd188_0000,
    0x75cc_0000,
    0xd12a_0000,
    0xcfbd_0000,
    0x94a2_8000,
    0xa472_4000,
    0x1884_6000,
    0x1640_1000,
    0xcbef_7800,
    0xcc10_4c00,
    0x6e5d_ea00,
    0xabbc_7700,
    0x32aa_8080,
    0x157e_40c0,
    0x370e_60a0,
    0x8e8d_10d0,
    0xbf45_f8a8,
    0xd86e_0ce4,
    0xaed3_8a66,
    0x21f1_6711,
    0xd34f_787f,
    0x4a60_4cf0,
    0xd1d5_ea30,
    0xfb70_77a2,
    0xd200_80f9,
    0x1f03_4051,
    0xaa8c_e017,
    0x794f_500e,
    0x1969_98c3,
    0xf952_1c70,
    0xf53e_f2ee,
    0x25e0_2b75,
    0x2912_1265,
    0xffdf_7b49,
    0xbe73_8a0f,
    0x9381_6706,
    0xa2c7_78ff,
    0xefac_4c30,
    0xa8ff_ea90,
    0xd0cd_7772,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xf000_0000,
    0xe800_0000,
    0x4c00_0000,
    0x0e00_0000,
    0x4900_0000,
    0x9380_0000,
    0x81c0_0000,
    0x4960_0000,
    0xdc30_0000,
    0x5188_0000,
    0x86c4_0000,
    0xb3e2_0000,
    0x3e7f_0000,
    0x7126_8000,
    0x5f90_c000,
    0x305a_e000,
    0xa037_9000,
    0xd789_b800,
    0x53c5_dc00,
    0x3667_f600,
    0x52bc_1300,
    0xe9ce_8080,
    0x4564_c040,
    0xf230_e020,
    0xe88c_90f0,
    0xfd4d_38e8,
    0x7e2a_1c4c,
    0x791b_960e,
    0xe41b_4349,
    0x9d9d_d813,
    0x3756_8cc1,
    0x5abe_ae69,
    0x35c5_5f2c,
    0x736c_4e39,
    0xef36_cf8a,
    0xd107_f61d,
    0x778c_13c7,
    0xe3c6_80aa,
    0xfe60_c022,
    0xeeb2_e0bf,
    0x0fc3_9089,
    0x4063_b8f3,
    0x6fbe_dc51,
    0x2043_7651,
    0x27a3_d378,
    0x23da_e093,
    0x61f7_9081,
    0xbee9_b849,
    0x7ff5_dcdc,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0xd000_0000,
    0x6800_0000,
    0x8c00_0000,
    0xe600_0000,
    0xbf00_0000,
    0x3d80_0000,
    0x85c0_0000,
    0x59a0_0000,
    0x67d0_0000,
    0x4788_0000,
    0x54c4_0000,
    0x272a_0000,
    0x819d_0000,
    0xc0ee_8000,
    0x3d3c_c000,
    0xdbbc_6000,
    0x49fa_f000,
    0x6c93_5800,
    0x006b_9c00,
    0xf07e_7a00,
    0xb35c_cd00,
    0x18c6_8080,
    0x2128_c040,
    0x4e9e_60a0,
    0x4563_f0d0,
    0x5cf7_d868,
    0xe81a_5c8c,
    0x7724_9ae6,
    0xa99e_fdbf,
    0xece3_b8bd,
    0x0b34_acc5,
    0x0cb5_c2f9,
    0xf87c_61b7,
    0x0f51_42af,
    0xe6cd_a198,
    0xaa2b_a2e1,
    0x711f_91ae,
    0x15a6_9ab5,
    0x61d7_fda4,
    0x888f_382c,
    0xd141_6c8d,
    0x46e5_2238,
    0xb233_5132,
    0xfe32_fabd,
    0xf839_0da3,
    0x373e_603d,
    0xb2b3_f085,
    0xd37f_d859,
    0xe0de_5c67,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x5000_0000,
    0xb800_0000,
    0x5400_0000,
    0x5e00_0000,
    0xfb00_0000,
    0xbd80_0000,
    0xe640_0000,
    0x8be0_0000,
    0x1290_0000,
    0xa688_0000,
    0xcbcc_0000,
    0xb5a6_0000,
    0x9d75_0000,
    0x5213_8000,
    0xc241_4000,
    0x9def_e000,
    0x359c_b000,
    0xf90d_5800,
    0x648c_a400,
    0x72ce_1e00,
    0x712e_7900,
    0xdfb5_8080,
    0xcb34_40c0,
    0xf1fc_6060,
    0x5cdd_f050,
    0x6162_b8b8,
    0xe350_1454,
    0x5e23_465e,
    0xfc32_ddfb,
    0xb673_9e3d,
    0x9796_3926,
    0x100f_e06b,
    0x180c_b082,
    0x6405_587e,
    0xb600_a4cf,
    0x1708_1e53,
    0xb78b_7932,
    0x434e_0031,
    0xcd69_001f,
    0x495d_80cb,
    0xcb28_4091,
    0x52b2_606c,
    0x01b4_f0e9,
    0xf03f_383f,
    0x2c78_54dc,
    0xea91_2685,
    0x5286_2d72,
    0xa5cc_a635,
    0xa6ae_6d79,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x9000_0000,
    0xe800_0000,
    0xd400_0000,
    0xf200_0000,
    0xc900_0000,
    0x4380_0000,
    0x3040_0000,
    0x4160_0000,
    0xb7f0_0000,
    0xf688_0000,
    0xf5cc_0000,
    0xba26_0000,
    0x0419_0000,
    0x0eb6_8000,
    0x5469_4000,
    0x8275_2000,
    0x75cb_9000,
    0x7a2f_b800,
    0x6416_c400,
    0x9eb7_7600,
    0xbc62_4f00,
    0x5670_8080,
    0x87c0_40c0,
    0xb32b_a060,
    0x279e_d090,
    0xaef4_98e8,
    0xfd08_54d4,
    0xe188_4ef2,
    0x7144_cbc9,
    0x46e4_56c3,
    0x9db0_dff0,
    0xaae9_b8a1,
    0xf3bf_c4e7,
    0xb5e9_f67e,
    0xf337_0fb1,
    0x332b_a020,
    0xe79e_d0d9,
    0xcef4_98df,
    0x6d08_543d,
    0x0988_4e68,
    0xa544_cb26,
    0xb4e4_56bf,
    0x54b0_df2f,
    0xe969_b871,
    0xc3ff_c42d,
    0xf489_f62b,
    0x44c7_0f24,
    0xc5a3_a053,
    0x1252_d02e,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x7000_0000,
    0xe800_0000,
    0xb400_0000,
    0xfa00_0000,
    0x0900_0000,
    0x3180_0000,
    0xd8c0_0000,
    0x3520_0000,
    0x2590_0000,
    0xda88_0000,
    0xfc44_0000,
    0xb262_0000,
    0x4b77_0000,
    0x1ab6_8000,
    0x5e17_4000,
    0x8341_a000,
    0x1ce1_9000,
    0x2d38_9800,
    0xf1d7_4c00,
    0xbce5_3200,
    0x1d30_2900,
    0x39dc_8080,
    0x78e4_4040,
    0x0f35_2020,
    0x84d1_d070,
    0xb367_b8e8,
    0xdef5_9cb4,
    0x8076_0afa,
    0x4e35_f509,
    0x3155_aab1,
    0x59a3_6598,
    0x26db_b295,
    0x8663_6915,
    0xf17f_2092,
    0x33b2_d078,
    0x1f9b_3880,
    0xb381_dc86,
    0x9dcb_2a39,
    0xf2a0_253b,
    0x2250_12fd,
    0x7121_f9a8,
    0x779b_3853,
    0x4781_dcc0,
    0x47cb_2a29,
    0x8ba0_254b,
    0xfbd0_12d9,
    0x1de1_f96c,
    0xb8bb_384f,
    0x6b11_dc6c,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x9000_0000,
    0x6800_0000,
    0x3c00_0000,
    0x8600_0000,
    0xb500_0000,
    0x3680_0000,
    0x4940_0000,
    0xa320_0000,
    0xc070_0000,
    0x9d88_0000,
    0xeecc_0000,
    0xbee2_0000,
    0xdd19_0000,
    0xaf5e_8000,
    0xc3f7_c000,
    0x224e_6000,
    0x24ac_5000,
    0x4dbe_e800,
    0xe8e0_d400,
    0xe01b_1200,
    0x15d6_f700,
    0xf4b4_8080,
    0x6062_c0c0,
    0x6852_e020,
    0xaa72_9090,
    0x2686_0868,
    0xe147_443c,
    0xbf21_9a86,
    0xd67f_73b5,
    0x4085_fab6,
    0xe446_2389,
    0x71a7_9203,
    0xcb38_3790,
    0x59a4_6055,
    0x1739_5082,
    0x6fa2_6870,
    0x5a3e_14c4,
    0x0d23_f277,
    0xa971_6703,
    0x9d0e_08b1,
    0xea8b_44d8,
    0x7f43_9a65,
    0xee26_731f,
    0xa2fb_7a88,
    0x6ec1_e31a,
    0x7ee1_f25e,
    0xfd18_6775,
    0x3f58_88a5,
    0xabf0_84b5,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x9000_0000,
    0x2800_0000,
    0x8c00_0000,
    0x1e00_0000,
    0xd100_0000,
    0x9880_0000,
    0x15c0_0000,
    0x5fe0_0000,
    0xaeb0_0000,
    0x65c8_0000,
    0x27ec_0000,
    0x6ab6_0000,
    0x67c1_0000,
    0xc0ee_8000,
    0xaf3e_c000,
    0xf480_e000,
    0x5bc3_9000,
    0xc6e7_4800,
    0x2a39_bc00,
    0x4602_6e00,
    0x2507_a300,
    0x4280_e080,
    0xc6c3_90c0,
    0x2067_4860,
    0x7ef9_bc90,
    0xa962_6e28,
    0x1277_a38c,
    0x66a8_e09e,
    0x9e9f_9011,
    0xb799_48f8,
    0x2b14_bc85,
    0x5cda_ee77,
    0x7438_6322,
    0x370e_80fb,
    0x4d8e_c036,
    0xef48_e092,
    0x3d2f_90e2,
    0x1cd1_48b7,
    0xd438_bc8d,
    0xc70c_ee8f,
    0xf589_63ad,
    0x4b48_00b4,
    0xaf2c_0098,
    0xd3d6_00b9,
    0x9db1_00b4,
    0x4a46_80fb,
    0xbfa2_c036,
    0xba1e_e092,
    0x645e_90e2,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0xb000_0000,
    0xd800_0000,
    0xe400_0000,
    0xe200_0000,
    0x7b00_0000,
    0x5980_0000,
    0xa0c0_0000,
    0x12a0_0000,
    0x20b0_0000,
    0xbcc8_0000,
    0x04ac_0000,
    0xb1b6_0000,
    0x1243_0000,
    0x23e1_8000,
    0x7ed8_4000,
    0xe0dd_2000,
    0x3dde_3000,
    0x2d59_d800,
    0xc71d_2c00,
    0x10f2_1a00,
    0x842d_5300,
    0x93fd_2080,
    0x29ae_30c0,
    0xd931_d860,
    0xcc01_2cb0,
    0x7e0c_1ad8,
    0xad02_53e4,
    0xa88a_a062,
    0xbe45_70bb,
    0xede5_7839,
    0x0bdb_5c10,
    0xac56_e2ca,
    0x619e_4fc4,
    0xbbbe_e2de,
    0x9542_4fbf,
    0x1c60_e208,
    0xf71d_4fc2,
    0x08ff_6209,
    0x002a_0fca,
    0xc1f5_c286,
    0x8aaf_7fd6,
    0x64b0_ba1f,
    0x8ec4_239a,
    0x17ae_58a2,
    0xd436_6c95,
    0xb486_bade,
    0xa847_23bf,
    0x7cef_d808,
    0xa55e_2cc2,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0xf000_0000,
    0x5800_0000,
    0x4400_0000,
    0x8600_0000,
    0xdf00_0000,
    0x1f80_0000,
    0xa440_0000,
    0x29e0_0000,
    0xced0_0000,
    0xa848_0000,
    0x03e4_0000,
    0xebd6_0000,
    0x5ac7_0000,
    0xb921_8000,
    0xe2f2_4000,
    0x803f_6000,
    0x8d14_7000,
    0xb1ef_b800,
    0xaadf_2400,
    0xbe4b_ee00,
    0x74e7_d500,
    0xe85f_6080,
    0x3c84_7040,
    0xc9c7_b860,
    0xecab_24f0,
    0x93b5_ee58,
    0x0354_d544,
    0xbd00_e006,
    0x9685_309f,
    0xacc7_587f,
    0x7e2e_1454,
    0xd972_b671,
    0x527a_c18a,
    0x23f2_56ae,
    0x24bf_f19c,
    0x20d5_0e14,
    0x4b41_e54e,
    0x4e6f_b828,
    0xbe9f_24d8,
    0xafab_ee96,
    0x0e37_d5e5,
    0x9e17_601b,
    0xa460_708f,
    0xbb91_b8d7,
    0xcd2c_24d3,
    0x1cf4_6eae,
    0x8b36_959c,
    0xbc97_8014,
    0xd6a5_404e,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x9000_0000,
    0xc800_0000,
    0x7400_0000,
    0xda00_0000,
    0x9f00_0000,
    0x1380_0000,
    0x8040_0000,
    0x4760_0000,
    0x6e10_0000,
    0xce48_0000,
    0xf264_0000,
    0x9a92_0000,
    0x7181_0000,
    0x5348_8000,
    0x82e5_4000,
    0x8754_a000,
    0x63ad_7000,
    0x3eb2_7800,
    0xc57f_a400,
    0xa658_8600,
    0xbd25_5900,
    0x667c_a080,
    0x5bd9_7040,
    0x5868_7820,
    0x3d9a_a490,
    0x6e02_06c8,
    0x2501_1974,
    0x3c80_805a,
    0xcbc1_40df,
    0x7b26_a033,
    0x877c_7010,
    0xe552_f88f,
    0xb0ae_e41a,
    0xfb36_2614,
    0x2c3d_296d,
    0x0bbc_5809,
    0x71f6_94b1,
    0x3996_de34,
    0x8c02_cd7c,
    0xb60a_fe01,
    0xd90a_fda5,
    0xb28c_26de,
    0x1ec8_29fb,
    0x3fae_d88e,
    0x60b6_d41b,
    0xf878_fe94,
    0x06db_fd2d,
    0x48ec_a629,
    0x9059_6921,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x1000_0000,
    0x2800_0000,
    0xfc00_0000,
    0x9600_0000,
    0x1300_0000,
    0xe380_0000,
    0x9640_0000,
    0x0f60_0000,
    0x2b30_0000,
    0x1448_0000,
    0x5664_0000,
    0x3db6_0000,
    0x4a89_0000,
    0xf8c6_8000,
    0xe5a9_c000,
    0xff98_6000,
    0x615b_b000,
    0xeffd_f800,
    0x47ea_0400,
    0xcaf2_c600,
    0x8761_0b00,
    0xe730_6080,
    0xda4f_b040,
    0x8163_f860,
    0x9c37_0410,
    0xa5ca_4628,
    0x9125_cbfc,
    0xa858_8016,
    0x9174_c053,
    0x8520_e083,
    0xe25f_7086,
    0x6475_1827,
    0x4da1_74d7,
    0x4399_de82,
    0x975d_7f45,
    0xecf1_3e5e,
    0x8c66_0f9c,
    0xa0b2_2617,
    0x1e0e_7b9e,
    0xdf0d_7823,
    0x2d8a_c49b,
    0x414c_260c,
    0xaee3_7bf2,
    0xc47d_f8ef,
    0x7daa_045b,
    0x1b92_c602,
    0x5351_0b05,
    0xaef8_603e,
    0xf56b_b08c,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x3000_0000,
    0xa800_0000,
    0x1400_0000,
    0x5a00_0000,
    0xa900_0000,
    0xbc80_0000,
    0x8040_0000,
    0xf3e0_0000,
    0xa050_0000,
    0xb648_0000,
    0xece4_0000,
    0x43d2_0000,
    0xf58b_0000,
    0x6cce_8000,
    0xcba3_4000,
    0xdfb6_a000,
    0xf018_1000,
    0xbda6_8800,
    0xe0bb_a400,
    0x239c_ae00,
    0x5664_4d00,
    0x749e_a080,
    0xf1ec_1040,
    0xd55c_8820,
    0x54c4_a430,
    0x07a8_2ea8,
    0x19b8_0d14,
    0x271c_80da,
    0x5a28_40e9,
    0x6178_209c,
    0xb6bb_50b0,
    0x2c90_285b,
    0x2de3_b4b4,
    0x8b5a_26ec,
    0x3fcf_e945,
    0xae2a_0e7f,
    0x6b7c_5d35,
    0xa7b8_283f,
    0x1c17_b41b,
    0x4ba0_26e1,
    0x9fb0_e938,
    0xd01e_8e8c,
    0x8da0_1de8,
    0x48ba_0809,
    0x3793_e4c4,
    0x0c64_8e6c,
    0xdd9f_1d05,
    0x4d6e_885f,
    0x551f_a405,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0xb000_0000,
    0x1800_0000,
    0x8400_0000,
    0xee00_0000,
    0x4500_0000,
    0x7e80_0000,
    0xe2c0_0000,
    0x64a0_0000,
    0x5a90_0000,
    0x0bc8_0000,
    0x2824_0000,
    0xf756_0000,
    0x0ae3_0000,
    0xb3f5_8000,
    0x8076_4000,
    0x1039_e000,
    0x345f_d000,
    0x8d6e_a800,
    0x95b8_4c00,
    0x051e_da00,
    0x8982_6100,
    0x934f_e080,
    0x83ec_d040,
    0x4f73_2860,
    0x35ba_0cb0,
    0x9519_3a18,
    0x418a_b184,
    0xbf4a_c86e,
    0xf1e5_dc05,
    0x6077_921e,
    0xe032_fd52,
    0x4c54_12fc,
    0xb967_bd9e,
    0x63b8_7205,
    0xc41e_2d9d,
    0x1907_3a71,
    0x348d_b19c,
    0x99c9_48c1,
    0xf720_9ceb,
    0x5ad3_f2f3,
    0xe7af_6d8f,
    0xbd1d_5a16,
    0x9d87_21a6,
    0xb54b_80a9,
    0xeae1_402c,
    0x43f2_601d,
    0xf87e_9019,
    0x243c_c81f,
    0xc256_dc99,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0xd000_0000,
    0xf800_0000,
    0x3c00_0000,
    0x2200_0000,
    0x0700_0000,
    0xf980_0000,
    0x0f40_0000,
    0x55e0_0000,
    0x74b0_0000,
    0xaa48_0000,
    0xeb64_0000,
    0x227a_0000,
    0x20e5_0000,
    0x323b_8000,
    0xc081_c000,
    0x43cb_2000,
    0xfc25_f000,
    0x3b91_5800,
    0x5e55_5400,
    0x5b7a_ee00,
    0xcc6c_f300,
    0x4bf9_2080,
    0x77a4_f040,
    0x8bd0_d8a0,
    0x6e31_94d0,
    0xd28a_4ef8,
    0xccc8_c33c,
    0x11a3_58a2,
    0xd2d4_5447,
    0x12bb_6e59,
    0xf348_33df,
    0x97e9_802d,
    0x03b0_c008,
    0x7bc2_a028,
    0x2025_303c,
    0x699b_f823,
    0x7154_6413,
    0x66fb_1645,
    0xdd2d_97b3,
    0x3b11_b690,
    0xfd9c_a758,
    0xd758_4e6c,
    0xdff9_c39a,
    0xd1aa_d81b,
    0x32d4_944b,
    0x62b1_ce50,
    0xdb49_0340,
    0x53e8_7821,
    0x1db1_a484,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0xb000_0000,
    0x8800_0000,
    0x8400_0000,
    0x9200_0000,
    0x4d00_0000,
    0x9580_0000,
    0x3cc0_0000,
    0x5020_0000,
    0x9290_0000,
    0x13c8_0000,
    0x20ac_0000,
    0xefde_0000,
    0xd523_0000,
    0xa314_8000,
    0xed0e_4000,
    0x058e_2000,
    0xe4c2_5000,
    0xec2a_1800,
    0x0c92_6c00,
    0x48c1_9200,
    0x6a25_5100,
    0x0b98_2080,
    0x2c4d_50c0,
    0x5d60_98e0,
    0x3c7f_2cb0,
    0xa47b_3288,
    0x3879_4184,
    0xf674_1812,
    0x9571_6c8d,
    0xd3f5_1275,
    0x21bb_118c,
    0x07de_0058,
    0x2123_00d6,
    0x5914_8061,
    0x940e_40dd,
    0x8a0e_20f2,
    0x1102_506d,
    0xbb8a_1861,
    0xefc2_6c32,
    0x9ea9_9283,
    0xe4d9_51f8,
    0xa7ae_20d3,
    0x4b52_508b,
    0x0262_1818,
    0x24fe_6c17,
    0xed3f_9269,
    0xe496_5199,
    0xbcc4_a000,
    0x902f_1050,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0xb000_0000,
    0x4800_0000,
    0x8c00_0000,
    0x3e00_0000,
    0xeb00_0000,
    0xb380_0000,
    0xa1c0_0000,
    0x2f60_0000,
    0x4890_0000,
    0x8248_0000,
    0xd6a4_0000,
    0xf3fe_0000,
    0x80d3_0000,
    0x45e8_8000,
    0xcfd2_c000,
    0xb46e_e000,
    0x1315_3000,
    0xff81_7800,
    0x3fce_3c00,
    0x9465_2600,
    0x0312_c100,
    0xe786_6080,
    0x4bc7_f040,
    0x6e6f_98e0,
    0x5a1b_0cb0,
    0x8104_5e48,
    0xb28c_fd8c,
    0x534b_46be,
    0x9c21_31ab,
    0x64bf_f8d3,
    0xaefb_fc51,
    0xf455_4687,
    0x39a2_3174,
    0x527f_7874,
    0xa41d_3cf1,
    0xca0d_a69e,
    0x5100_017a,
    0x0a88_8011,
    0x7742_c0ea,
    0x9e26_e0c7,
    0xf9b1_30d6,
    0x7a7f_7875,
    0xd81d_3c44,
    0x5c0d_a633,
    0x8600_01ef,
    0xcf08_80a7,
    0xb182_c0a0,
    0x3cc6_e019,
    0xfbe1_300e,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0xf000_0000,
    0xf800_0000,
    0x6400_0000,
    0x0a00_0000,
    0x4300_0000,
    0x1080_0000,
    0x0b40_0000,
    0x36a0_0000,
    0xfe30_0000,
    0xf3c8_0000,
    0x91ec_0000,
    0x3e96_0000,
    0xd0f7_0000,
    0xc3ab_8000,
    0x93bc_4000,
    0xc901_a000,
    0x9388_b000,
    0x7bce_c800,
    0xcde9_5400,
    0x3098_7a00,
    0x69f4_9b00,
    0x682a_2080,
    0xec74_f0c0,
    0xfeef_6860,
    0x1811_e4f0,
    0x66be_b2f8,
    0xa481_cf64,
    0xa94c_5a8a,
    0x79ab_6b83,
    0x88b0_c8f0,
    0x2d82_543b,
    0x9acd_faae,
    0x9263_db6a,
    0x4d5e_0081,
    0x811b_0076,
    0x9d3d_8044,
    0xb34b_4068,
    0xf2aa_201d,
    0x6434_f002,
    0xb8cf_6806,
    0x1d61_e4bf,
    0x5bd6_b2a6,
    0xaf5d_cf87,
    0x6e12_5a7b,
    0x7bb0_6b14,
    0x650d_4871,
    0x6589_144d,
    0xa6c7_daea,
    0x6c67_2b02,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0xb000_0000,
    0x3800_0000,
    0x4400_0000,
    0x4a00_0000,
    0x5700_0000,
    0xa680_0000,
    0x3f40_0000,
    0xbda0_0000,
    0xb690_0000,
    0x5dc8_0000,
    0x88e4_0000,
    0x3c36_0000,
    0xfdd3_0000,
    0xd26f_8000,
    0x4d76_4000,
    0x3d71_a000,
    0x2571_f000,
    0xb177_a800,
    0x7372_1400,
    0x5878_8a00,
    0xf0f2_b100,
    0xd2be_2080,
    0x9e97_b040,
    0xb1ce_0860,
    0x6ee7_e4b0,
    0xed39_2238,
    0x3a53_a544,
    0x12a9_2aca,
    0x7413_4117,
    0xf881_8846,
    0xea41_a4cf,
    0x5020_82e5,
    0x9156_5542,
    0xfa20_82af,
    0x3656_55db,
    0x04a0_8230,
    0xfd16_5565,
    0xcb00_8211,
    0x5886_5570,
    0x7a48_824f,
    0xb822_55f8,
    0x5d5e_82e4,
    0xcc21_55da,
    0x6f59_023f,
    0xbf23_152a,
    0x33d6_a2e9,
    0xef65_e514,
    0x6cf8_8ad5,
    0x2cb2_b127,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0xf000_0000,
    0x3800_0000,
    0x3c00_0000,
    0xd600_0000,
    0xbd00_0000,
    0x4c80_0000,
    0xc040_0000,
    0xbe20_0000,
    0xd630_0000,
    0xf8c8_0000,
    0xec64_0000,
    0xdf1e_0000,
    0xf977_0000,
    0x1d6f_8000,
    0x3d99_c000,
    0x5834_6000,
    0xc9cb_5000,
    0xaeee_8800,
    0x6e53_a400,
    0xe5d9_d200,
    0x8a1e_3b00,
    0xe1fb_e080,
    0x1f22_9040,
    0x1cb2_e8e0,
    0xad8c_f4f0,
    0xeac1_5a38,
    0x1b6e_9f3c,
    0xe89b_b256,
    0x00b6_6bfd,
    0x2b8c_e82c,
    0x7fcb_f470,
    0xa3e6_da66,
    0xfad3_5f1a,
    0xe991_d296,
    0xda3a_3b2d,
    0xb6c5_e025,
    0x7d65_9034,
    0x8d95_6837,
    0x8031_34e7,
    0x05cb_3af0,
    0x40e2_cf72,
    0xef52_ba93,
    0x7f58_0f46,
    0xf75f_5ab5,
    0x1359_9fe8,
    0x0954_32ba,
    0x5a5f_ab5d,
    0x97d0_8843,
    0xcd14_a42e,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0xd000_0000,
    0x2800_0000,
    0xf400_0000,
    0xe200_0000,
    0x2500_0000,
    0x9280_0000,
    0x6240_0000,
    0x0e20_0000,
    0x02b0_0000,
    0x1cc8_0000,
    0xe26c_0000,
    0x679a_0000,
    0x47f5_0000,
    0x1566_8000,
    0x4819_4000,
    0x1b31_2000,
    0x9709_d000,
    0x5f82_e800,
    0xa4c0_4400,
    0x5e63_1200,
    0x0196_9300,
    0x78f7_a080,
    0x7ee0_90c0,
    0xaedb_c8a0,
    0xb055_94d0,
    0x2c13_fa28,
    0xb13f_d7f4,
    0x3600_3262,
    0xd706_43e5,
    0x3f89_c8b2,
    0xd4cc_9472,
    0xa66f_7a86,
    0xdd93_9726,
    0x6ef7_9256,
    0xb9e6_d3f3,
    0x1952_0037,
    0x4099_0010,
    0x407c_8001,
    0xbdac_400c,
    0x2877_a0c3,
    0x29a0_90a6,
    0xba7b_c854,
    0xf4a5_9446,
    0xf4fb_fab0,
    0x80e3_d76e,
    0x3dd2_32e4,
    0x35df_4381,
    0xd1d5_48b1,
    0xbbd0_d436,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xf000_0000,
    0xe800_0000,
    0xac00_0000,
    0xd600_0000,
    0x1f00_0000,
    0x5380_0000,
    0x24c0_0000,
    0x25a0_0000,
    0x3fd0_0000,
    0xf148_0000,
    0x4664_0000,
    0x2df2_0000,
    0x6057_0000,
    0xb382_8000,
    0xb4cc_c000,
    0x1da0_6000,
    0x8bd0_7000,
    0x6349_7800,
    0x2361_ec00,
    0xb77c_ca00,
    0x0810_3500,
    0xe16a_e080,
    0x8a78_b040,
    0xf69b_1820,
    0x0326_9cf0,
    0xf997_32e8,
    0x28ad_19ac,
    0x495e_4a56,
    0x6f0c_f55f,
    0xfb82_80f3,
    0xa8cc_c094,
    0x03a0_60ed,
    0xc8d0_7063,
    0x0ec9_78cf,
    0xb4a1_ecf5,
    0x175c_caa8,
    0x0c00_355b,
    0x6602_e045,
    0xd70c_b0ef,
    0x0f81_18e9,
    0x1ac5_9c02,
    0x96af_b257,
    0xba52_d9a9,
    0xca8e_aa7f,
    0x3047_4583,
    0x36e9_18bc,
    0xb4b1_9c21,
    0xca35_b265,
    0x6871_d9c8,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xd000_0000,
    0x1800_0000,
    0x0400_0000,
    0x4600_0000,
    0x5d00_0000,
    0x6180_0000,
    0x2d40_0000,
    0xfd60_0000,
    0x5d30_0000,
    0x96c8_0000,
    0x8f24_0000,
    0xfad2_0000,
    0x0a35_0000,
    0xb04d_8000,
    0xfce6_4000,
    0x807b_6000,
    0xa3a1_5000,
    0xce13_d800,
    0x2e1c_f400,
    0x9e1f_6600,
    0x7619_9b00,
    0xba1e_e080,
    0xe013_1040,
    0xff12_b820,
    0x859c_a4d0,
    0x945b_3e18,
    0x25f2_2f04,
    0xa8e5_66c6,
    0x9e78_9b1d,
    0xdaa9_60c1,
    0x3994_50bd,
    0x465e_58c5,
    0x06fa_b489,
    0x4064_06c8,
    0x8cb8_cbd6,
    0x538d_385d,
    0xbe4f_e43a,
    0xfded_de0c,
    0x83f5_3f5c,
    0x45ed_de73,
    0x17f5_3f35,
    0x3bed_de44,
    0x9ef5_3f66,
    0x046d_de0d,
    0xeab5_3f39,
    0xde8d_de89,
    0xc7c5_3f2b,
    0xd4a5_deb8,
    0x3891_3f63,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x3000_0000,
    0x6800_0000,
    0x8400_0000,
    0x9a00_0000,
    0xc700_0000,
    0x4c80_0000,
    0x3740_0000,
    0xd460_0000,
    0xe570_0000,
    0x64c8_0000,
    0x83ac_0000,
    0x7856_0000,
    0x38db_0000,
    0xe192_8000,
    0x60fa_4000,
    0xba08_a000,
    0x5703_f000,
    0x748f_0800,
    0xeb47_1400,
    0xa266_5600,
    0x3c77_0f00,
    0x754c_2080,
    0x3f62_b0c0,
    0xd7f5_2860,
    0x3e8e_a430,
    0xb449_fe68,
    0x62ef_eb84,
    0x253b_7e1a,
    0x9425_ab07,
    0xd59b_deac,
    0x52fa_5bc7,
    0x990a_d65c,
    0xb18a_4f91,
    0xecc8_0076,
    0xf7ac_0030,
    0xea56_00a6,
    0x4bdb_007c,
    0x5f12_808b,
    0x14ba_40f1,
    0xb8e8_a0dc,
    0x4233_f0c1,
    0x88a7_08f0,
    0xbadb_1482,
    0x6a98_568b,
    0x6270_0f02,
    0x8840_a0b2,
    0xe4ef_f073,
    0xf439_08e0,
    0x31ac_14ea,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0xd000_0000,
    0x3800_0000,
    0xc400_0000,
    0xf600_0000,
    0x9b00_0000,
    0xf780_0000,
    0xaa40_0000,
    0x6660_0000,
    0x3290_0000,
    0x42c8_0000,
    0xadac_0000,
    0x15ba_0000,
    0x09b5_0000,
    0x8bb7_8000,
    0xaeb2_4000,
    0xee3c_6000,
    0xb9f9_3000,
    0xdcd3_b800,
    0x12a9_0400,
    0xa434_7600,
    0x70fa_4100,
    0x3651_e080,
    0x3c6e_70c0,
    0x6390_58a0,
    0xbc4e_74d0,
    0x4d61_ae38,
    0x8d1f_75c4,
    0xc481_ae76,
    0xc1cf_755b,
    0x8e29_aed7,
    0xd1f3_75ba,
    0xe0db_ae7e,
    0x80aa_75e6,
    0x1936_2eac,
    0x247d_35e2,
    0xaf95_ce0c,
    0x064a_45ec,
    0xac68_16f4,
    0x3b93_7179,
    0x084a_58d3,
    0x536b_74c3,
    0xea1e_2e74,
    0x0101_35a1,
    0x0687_cea7,
    0x84c3_457d,
    0xbead_9643,
    0x6e38_319c,
    0x79fb_b804,
    0x7cd5_0451,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0xf000_0000,
    0xd800_0000,
    0xf400_0000,
    0xea00_0000,
    0xbd00_0000,
    0x5b80_0000,
    0xddc0_0000,
    0x4d20_0000,
    0xfd50_0000,
    0xbf48_0000,
    0x396c_0000,
    0x84ba_0000,
    0x4eb7_0000,
    0xc3b9_8000,
    0xe031_4000,
    0x39ff_a000,
    0x46d7_5000,
    0xf286_7800,
    0xfc48_bc00,
    0xa5e6_6200,
    0x37f2_dd00,
    0x59dc_2080,
    0x6801_10c0,
    0x4c08_58a0,
    0x4e02_acf0,
    0x7f05_bad8,
    0xca8a_31f4,
    0x984d_ba6a,
    0xc7e6_317d,
    0x56f7_ba7b,
    0xc451_31ed,
    0x16ce_3ab5,
    0x0da0_7139,
    0x8811_9aad,
    0x0b27_2140,
    0x9e5f_e2cd,
    0x13c3_9dea,
    0xf223_80c7,
    0x97d6_40b9,
    0xd70e_2002,
    0x268a_10e6,
    0x2643_d8ed,
    0x60e8_ece2,
    0x6879_9aa1,
    0xb61b_213d,
    0x6c2d_e20e,
    0x00d8_9d59,
    0x9180_0012,
    0x50c0_00ae,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x7000_0000,
    0xf800_0000,
    0xec00_0000,
    0xfa00_0000,
    0xeb00_0000,
    0xc280_0000,
    0x5c40_0000,
    0x37e0_0000,
    0x40f0_0000,
    0xd7e8_0000,
    0x50f4_0000,
    0x7fea_0000,
    0x34f3_0000,
    0x91e5_8000,
    0xc9fd_c000,
    0x426a_2000,
    0xbc33_7000,
    0xeb46_0800,
    0x9766_b400,
    0x4bbd_7600,
    0x508e_bb00,
    0xb346_0880,
    0x4b66_b440,
    0x69bd_7620,
    0x278e_bb70,
    0x73c6_0878,
    0x1026_b4ac,
    0x66dd_76da,
    0xd03e_bb9b,
    0x514e_08ba,
    0x5c62_b4f0,
    0xf93f_76ed,
    0xf4c9_bbdb,
    0x68a9_886d,
    0xf198_74a0,
    0x555a_d692,
    0xb5f4_0bef,
    0x5060_20fc,
    0x1330_7069,
    0xb7cb_88d0,
    0xce2f_7453,
    0x43dd_5697,
    0x9fbe_cbbe,
    0x268d_803b,
    0xf249_c033,
    0xeae0_20fc,
    0xe370_7069,
    0x5a2b_88d0,
    0x15df_7453,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x1000_0000,
    0x2800_0000,
    0x9c00_0000,
    0xe600_0000,
    0x5900_0000,
    0x7c80_0000,
    0x5e40_0000,
    0x35e0_0000,
    0xea30_0000,
    0x01e8_0000,
    0x503c_0000,
    0x1ee2_0000,
    0x65bd_0000,
    0x1420_8000,
    0x9214_c000,
    0x2dfe_e000,
    0x20c9_5000,
    0x00ad_2800,
    0x3052_b400,
    0x4e11_7600,
    0xabf1_9700,
    0xc9cd_2880,
    0x4422_b4c0,
    0xda19_76a0,
    0x01fd_9710,
    0xfec7_28a8,
    0xeda3_b45c,
    0x36db_f646,
    0xaf54_5749,
    0xbb99_48d4,
    0x013e_2402,
    0x2e68_3e73,
    0x55ff_b3a3,
    0xf4cd_16d5,
    0xcaa1_0752,
    0xb756_60ed,
    0xdf91_9006,
    0xf339_c8e1,
    0x1d6a_e410,
    0xbe76_dec8,
    0x1306_e36a,
    0x3b88_3e0f,
    0x6fcf_b335,
    0x7d25_1614,
    0x169d_078a,
    0x67b4_60e1,
    0x7f2c_9010,
    0x7d99_48c8,
    0x883e_246a,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x5000_0000,
    0x3800_0000,
    0xbc00_0000,
    0x7600_0000,
    0x9d00_0000,
    0x2680_0000,
    0x6f40_0000,
    0x5760_0000,
    0xd6f0_0000,
    0x3368_0000,
    0x2cf4_0000,
    0x906a_0000,
    0x4371_0000,
    0x2ba9_8000,
    0x2c5a_c000,
    0x67be_e000,
    0x1d0b_1000,
    0x6680_8800,
    0x4f43_e400,
    0x0766_fe00,
    0xeefa_0b00,
    0x8f60_8880,
    0x5af3_e440,
    0x0d6e_fe20,
    0x65fe_0b50,
    0x44e2_88b8,
    0x7b36_e4fc,
    0xb14d_7e56,
    0x2e65_cbcd,
    0x4a7d_e89e,
    0xdf23_3493,
    0x4411_1601,
    0xc558_3f1b,
    0xa330_1ead,
    0x3d45_1bbf,
    0x106a_0011,
    0x0371_0018,
    0x0ba9_8026,
    0x7c5a_c083,
    0x5fbe_e0ee,
    0xa10b_10a9,
    0x1080_882e,
    0xd243_e4bd,
    0x21e6_fe81,
    0x81ba_0b09,
    0xd800_8826,
    0x8c03_e483,
    0x3e06_feee,
    0x490a_0ba9,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x5000_0000,
    0x5800_0000,
    0x5400_0000,
    0x2600_0000,
    0x4b00_0000,
    0x0580_0000,
    0x95c0_0000,
    0xc4e0_0000,
    0x2df0_0000,
    0x12e8_0000,
    0x4ef4_0000,
    0x2b6e_0000,
    0xa131_0000,
    0x8e8b_8000,
    0xb044_4000,
    0x6121_e000,
    0xe114_f000,
    0x331f_b800,
    0x2e14_ac00,
    0x0894_7600,
    0xc4d0_3300,
    0xbff7_b880,
    0x6fe0_ac40,
    0x387a_7660,
    0xbf21_3350,
    0x8e1c_38d8,
    0x7894_ec14,
    0xacd3_9646,
    0xe3f1_c31b,
    0x45e5_80dd,
    0x0175_4081,
    0xd7aa_6082,
    0x5550_b036,
    0x2c3e_584f,
    0xd000_5c8f,
    0x180b_cec9,
    0x3404_9fc7,
    0x7603_ce19,
    0x1300_9f2b,
    0x5185_ce6e,
    0xb3c5_9f7d,
    0x8fe0_4e17,
    0x2870_df94,
    0x872a_2edc,
    0x8a10_6f8b,
    0x069c_7699,
    0xb3d4_336b,
    0xc071_b80e,
    0x9b25_ac2d,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x3000_0000,
    0x9800_0000,
    0x3400_0000,
    0x5200_0000,
    0x4500_0000,
    0x6380_0000,
    0x23c0_0000,
    0xdc20_0000,
    0xc8f0_0000,
    0x0628_0000,
    0xd1fc_0000,
    0x3ba2_0000,
    0xe13f_0000,
    0x0b0b_8000,
    0x188c_4000,
    0xc346_a000,
    0xbb64_1000,
    0x899a_9800,
    0x66bd_2c00,
    0xb2ca_da00,
    0xbdac_e300,
    0xa632_9880,
    0x2581_2cc0,
    0xc4c8_daa0,
    0xc2a3_e330,
    0x8cb1_1818,
    0x33c1_6cf4,
    0xb424_7af2,
    0xc4f4_f375,
    0x502a_007b,
    0x5ef3_00d7,
    0x2921_802e,
    0xf37f_40bd,
    0xb1e7_20fd,
    0x6fdb_50c6,
    0x2e5d_b8b5,
    0xb096_7c6c,
    0xab3f_626e,
    0xba06_9fea,
    0x890f_faa4,
    0x9588_b352,
    0x9cc4_a0a4,
    0x56ab_105f,
    0xeeb9_1872,
    0xeecd_6ce3,
    0xe3ae_7aee,
    0xb537_f32a,
    0xc903_8004,
    0xf580_4062,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x7000_0000,
    0x9800_0000,
    0xac00_0000,
    0x3200_0000,
    0x2900_0000,
    0x1480_0000,
    0x02c0_0000,
    0xcde0_0000,
    0xadf0_0000,
    0xb3e8_0000,
    0xa6fc_0000,
    0xc662_0000,
    0xf4bb_0000,
    0x0f4b_8000,
    0x23a1_c000,
    0x1ed0_a000,
    0x09f7_5000,
    0xa5ef_e800,
    0x59fe_7c00,
    0x8deb_b600,
    0xcdfa_e300,
    0x63e7_e880,
    0x4ef2_7cc0,
    0xf261_b6a0,
    0x6abd_e370,
    0x144e_6818,
    0x1e28_bc6c,
    0x089a_9692,
    0xc6db_7359,
    0xc5f9_200c,
    0x47ed_906e,
    0x98f4_c85f,
    0xad68_ecf4,
    0x5134_fe3f,
    0xb503_cf08,
    0xde8b_b6b9,
    0x57ca_e3b0,
    0x036f_e888,
    0xb23e_7c37,
    0xf48b_b62d,
    0x12ca_e38c,
    0x85ef_e833,
    0xe9fe_7c99,
    0xb5eb_b6d3,
    0x11fa_e36b,
    0xc9e7_e808,
    0xcbf2_7cf7,
    0xd4e1_b68d,
    0x417d_e3fc,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x9000_0000,
    0x9800_0000,
    0xb400_0000,
    0xde00_0000,
    0x6100_0000,
    0xca80_0000,
    0x63c0_0000,
    0x3920_0000,
    0xc930_0000,
    0x6b28_0000,
    0x923c_0000,
    0xa6aa_0000,
    0x7e75_0000,
    0x70c3_8000,
    0x38ae_4000,
    0xff76_6000,
    0x0a4c_5000,
    0x5364_c800,
    0xea59_6c00,
    0xa973_da00,
    0x8741_3f00,
    0xd3ec_c880,
    0xa695_6cc0,
    0xa3d1_da20,
    0x5338_3f90,
    0x3c2d_4818,
    0xa5b2_2c74,
    0x6dee_3afe,
    0xb79f_2ff1,
    0x4154_60d2,
    0x8cf5_5017,
    0xf705_48c7,
    0x678e_2c38,
    0x7344_3a39,
    0xedea_2f45,
    0x7797_e0c1,
    0x615b_1016,
    0x1cf3_28f1,
    0x6f02_7c59,
    0xd380_f2f8,
    0xad43_4309,
    0x8cec_3a16,
    0xbd16_2fe1,
    0x029d_e09a,
    0x25de_10c0,
    0xa638_a871,
    0xb8a0_3c99,
    0x3f74_92d8,
    0x2a46_1399,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x1000_0000,
    0xb800_0000,
    0x3c00_0000,
    0x8200_0000,
    0x7900_0000,
    0x1d80_0000,
    0xf640_0000,
    0x67a0_0000,
    0x8d30_0000,
    0x82a8_0000,
    0x22b4_0000,
    0xc5ee_0000,
    0xcc95_0000,
    0xb895_8000,
    0xee9e_c000,
    0xf199_a000,
    0x3b1f_5000,
    0x93d9_7800,
    0x5abb_b400,
    0xd9ec_c200,
    0x3e93_4700,
    0x6997_7880,
    0x771e_b440,
    0xb9d1_4260,
    0xa7b9_8710,
    0x7a60_d838,
    0x33d4_e47c,
    0x6abd_bae2,
    0x11ec_f369,
    0xaa9d_ba25,
    0x6f9c_f38a,
    0xb015_ba05,
    0x5f58_f3a4,
    0x3573_bac7,
    0xf609_f3b8,
    0x2f00_3a78,
    0x0286_3354,
    0x3cca_1afd,
    0xcf66_a32f,
    0x4451_4294,
    0x01f9_8799,
    0xc5c0_d809,
    0x92e4_e4f8,
    0xd215_ba4f,
    0x7658_f3c5,
    0xf0f3_bac5,
    0x2c49_f353,
    0x72a0_3a76,
    0xcab6_33f0,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x7000_0000,
    0x8800_0000,
    0x3400_0000,
    0xd600_0000,
    0xe500_0000,
    0x2580_0000,
    0x89c0_0000,
    0xa260_0000,
    0x93b0_0000,
    0xe368_0000,
    0xd834_0000,
    0x53ae_0000,
    0xcdd3_0000,
    0xf2d6_8000,
    0x7858_4000,
    0xc31f_e000,
    0x0630_1000,
    0xc2aa_b800,
    0x5e58_0c00,
    0xee17_de00,
    0x77b2_5700,
    0xed64_b880,
    0x913b_0c40,
    0x6c29_5e60,
    0xcb1e_1770,
    0x7235_5808,
    0x74a8_1c74,
    0xcb5d_66b6,
    0x439a_5b95,
    0xca7b_662d,
    0x990d_5bfd,
    0xe78b_e694,
    0xaac2_1b46,
    0x9ae4_86ae,
    0x83fd_4b55,
    0x2ac1_5e4f,
    0xdaea_17bf,
    0xe3fb_588a,
    0x5acb_1cc8,
    0x52e3_e629,
    0xd7f6_1b70,
    0x8cca_868a,
    0xb7ee_4b75,
    0xf277_de2c,
    0x0502_57ab,
    0x158c_b882,
    0x61cf_0cbc,
    0xe667_5e9f,
    0xcdbd_17e5,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x5000_0000,
    0xa800_0000,
    0xe400_0000,
    0x2e00_0000,
    0xc700_0000,
    0xfe80_0000,
    0x22c0_0000,
    0xfae0_0000,
    0xf230_0000,
    0x7be8_0000,
    0xcfb4_0000,
    0x79a2_0000,
    0x2891_0000,
    0xc3f8_8000,
    0x4987_4000,
    0x6446_6000,
    0x342d_3000,
    0x92d2_8800,
    0xc8d2_9c00,
    0x69d0_e600,
    0x4455_9f00,
    0x4e18_8880,
    0x1d37_9c40,
    0x216a_66a0,
    0x6373_df50,
    0x144e_6828,
    0x8c29_eca4,
    0x7edc_8e8e,
    0x52dd_7397,
    0x28d4_86d6,
    0x99d9_af86,
    0xbc5a_80f4,
    0x0216_4025,
    0xd73e_e08d,
    0xc86a_7059,
    0x5af4_e805,
    0xc80f_acf9,
    0x540a_6e68,
    0x7603_0363,
    0xdb02_6e99,
    0x9c87_038c,
    0x2fc8_6ef0,
    0xed62_03ac,
    0xe972_ee87,
    0x5d44_4363,
    0xe5a4_0ec0,
    0x0a9a_3387,
    0x6ef2_e6b7,
    0x0e04_9f4b,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0xb000_0000,
    0x9800_0000,
    0xd400_0000,
    0x1e00_0000,
    0xe500_0000,
    0x6b80_0000,
    0xb940_0000,
    0x56e0_0000,
    0x3370_0000,
    0xed68_0000,
    0x423c_0000,
    0x678a_0000,
    0x9347_0000,
    0x3deb_8000,
    0x95f6_4000,
    0x73a0_6000,
    0x679f_1000,
    0xf91d_5800,
    0xc3da_c400,
    0x407c_5600,
    0x5fe8_e300,
    0xe2f6_d880,
    0x172c_84c0,
    0xfe5c_3620,
    0x0037_f3b0,
    0xa08b_8018,
    0x6fc6_4014,
    0x7028_603e,
    0x72d3_1055,
    0xf5ff_58f3,
    0x23a1_c46d,
    0x6f9d_d648,
    0x0519_a3d6,
    0x91dd_3806,
    0x6f75_d43b,
    0xcf69_0e11,
    0xd53e_2710,
    0x9308_8ec8,
    0x228f_67c3,
    0x88c3_6eaa,
    0x3ca6_3761,
    0xa71e_5697,
    0xc6d3_e34b,
    0xbbf7_5843,
    0xcead_c44a,
    0xf81f_d63b,
    0xee52_a3ae,
    0xe834_b8e2,
    0xcc88_94b7,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x1000_0000,
    0xe800_0000,
    0x0c00_0000,
    0x2200_0000,
    0xa300_0000,
    0xd080_0000,
    0x8bc0_0000,
    0x44a0_0000,
    0x13f0_0000,
    0x0c28_0000,
    0xac3c_0000,
    0x6e86_0000,
    0x22cd_0000,
    0xdb20_8000,
    0x7ab1_c000,
    0x8844_a000,
    0x27e6_f000,
    0xd891_2800,
    0x657b_8c00,
    0xdae3_c200,
    0xb11b_4300,
    0x9931_a880,
    0xfb0a_4cc0,
    0x0487_62e0,
    0xbdcd_b310,
    0x31a8_8068,
    0xa67d_c0cc,
    0xda6a_a0c2,
    0x32d7_f0b3,
    0xc197_a838,
    0x22f7_4c87,
    0xa7af_e266,
    0xe370_73b0,
    0x77e2_205c,
    0x109a_30e7,
    0x9975_08ca,
    0x00ec_bc21,
    0xf616_4a3f,
    0x67b6_3fda,
    0xf1cb_4244,
    0x33a6_8366,
    0xf57b_08b3,
    0xf2ed_bc44,
    0x5d18_ca1e,
    0xab36_ff99,
    0xb009_6207,
    0xd80c_b35d,
    0x1406_0022,
    0xd60d_00d6,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0xd000_0000,
    0x8800_0000,
    0x2400_0000,
    0x5e00_0000,
    0x8500_0000,
    0xb680_0000,
    0x01c0_0000,
    0xf220_0000,
    0x42f0_0000,
    0x6aa8_0000,
    0x5e3c_0000,
    0xa20a_0000,
    0xb701_0000,
    0x698a_8000,
    0xbc4f_4000,
    0x486d_6000,
    0x239a_1000,
    0x85b6_8800,
    0x014c_4c00,
    0x62ea_4a00,
    0x205b_3300,
    0xd094_0880,
    0x823f_0cc0,
    0x400d_2a20,
    0xe000_23d0,
    0xf008_0008,
    0x580c_00e4,
    0xac02_007e,
    0x7a0d_0055,
    0xdb08_803e,
    0x3382_4025,
    0xb745_e0ac,
    0xf3e8_50c7,
    0xb0db_68dc,
    0x2858_1c5f,
    0x349b_2250,
    0xfc32_2ff5,
    0x150d_aa83,
    0xde8e_6322,
    0xd5cf_e04a,
    0xf429_5084,
    0x6bf1_e844,
    0xa627_5c49,
    0x84fe_42fc,
    0x63a4_3fa2,
    0x42b9_223d,
    0xf0cf_2fc7,
    0x52ad_2ac6,
    0xc230_2393,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x7000_0000,
    0x9800_0000,
    0x9400_0000,
    0x6e00_0000,
    0xa300_0000,
    0x9680_0000,
    0x3e40_0000,
    0x5620_0000,
    0x9170_0000,
    0xbba8_0000,
    0xcdbc_0000,
    0x6dc2_0000,
    0x41eb_0000,
    0xdd93_8000,
    0xf3b6_4000,
    0xe6cb_6000,
    0x7b65_7000,
    0x69d2_8800,
    0xf09f_5400,
    0xd638_ca00,
    0x060b_5300,
    0x6f03_0880,
    0xcc82_14c0,
    0x8340_2aa0,
    0xfba8_6370,
    0xadb2_e018,
    0xbdc4_3054,
    0xa9e8_68ce,
    0xd197_64d3,
    0x09ba_a20e,
    0x2bcb_37aa,
    0x4ee8_2ab8,
    0xc114_63f2,
    0x98f0_e00d,
    0x116f_3043,
    0x2cdb_e803,
    0x1911_2434,
    0x6cf9_c290,
    0xaf62_4709,
    0x67d0_a2f3,
    0x839c_3767,
    0xa8b9_aa54,
    0x3449_231c,
    0xc328_0065,
    0x90fc_0005,
    0x0d62_0086,
    0x9edb_00f7,
    0xa81b_8085,
    0x3b7a_4046,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0xd000_0000,
    0x5800_0000,
    0x5c00_0000,
    0x7a00_0000,
    0xcd00_0000,
    0x8080_0000,
    0x5e40_0000,
    0x4ce0_0000,
    0x5b10_0000,
    0x5b68_0000,
    0x58dc_0000,
    0x3142_0000,
    0x9d61_0000,
    0x5fdf_8000,
    0x54c0_c000,
    0x97ae_2000,
    0x3373_1000,
    0xa83a_a800,
    0xa058_b400,
    0x2307_0600,
    0x538c_f500,
    0x45cf_2880,
    0xad25_74c0,
    0x0034_a6a0,
    0xb45e_25d0,
    0xfd04_20d8,
    0x688e_109c,
    0x2a47_28da,
    0xe2e9_741d,
    0xe81e_a6d8,
    0x30e3_2502,
    0x3119_a0b6,
    0x6e6f_d056,
    0x5456_887b,
    0x4d0a_a4d6,
    0x4082_2e25,
    0xfe44_819a,
    0x9cee_0efe,
    0x0316_9101,
    0x076b_2606,
    0x22de_e5e0,
    0xfc4a_00c3,
    0x1ded_00e3,
    0x0195_806d,
    0x182d_c079,
    0xccbb_a07e,
    0x681e_d05f,
    0xf0e1_08ca,
    0x9116_647b,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x1000_0000,
    0xb800_0000,
    0x9400_0000,
    0x1a00_0000,
    0x4b00_0000,
    0xa580_0000,
    0x7bc0_0000,
    0x4860_0000,
    0xd270_0000,
    0xe4e8_0000,
    0xa33c_0000,
    0x60c2_0000,
    0x35ed_0000,
    0x8db1_8000,
    0x1e80_4000,
    0x1646_2000,
    0xafa7_f000,
    0xbc1a_f800,
    0x4b90_8c00,
    0x2753_9e00,
    0x4cb5_3b00,
    0x8801_7880,
    0xfc01_ccc0,
    0x9606_3ea0,
    0xd50f_8b10,
    0x4c84_2038,
    0x014a_f054,
    0x8c2b_78ba,
    0xaad0_cc5b,
    0xdb75_be1d,
    0xee62_cbef,
    0x6f73_80d2,
    0x246d_4059,
    0x3c77_a0e1,
    0x05e7_b0c8,
    0xe5bc_d890,
    0x9287_7c73,
    0x8841_6673,
    0x46a9_b7f6,
    0xc698_e653,
    0x8fd5_f721,
    0x5ffc_c659,
    0x732f_0757,
    0xc55f_be4d,
    0xf3b3_cb04,
    0x8780_00d6,
    0x64c0_008d,
    0x57e0_009b,
    0xf2b0_0033,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x9000_0000,
    0x0800_0000,
    0x5c00_0000,
    0x6200_0000,
    0x8100_0000,
    0xed80_0000,
    0x87c0_0000,
    0x6e60_0000,
    0x9e30_0000,
    0x58e8_0000,
    0xf174_0000,
    0x4aca_0000,
    0xa9ed_0000,
    0xe4f2_8000,
    0x2904_c000,
    0x6182_a000,
    0xcdcf_d000,
    0x2361_f800,
    0x19b0_ec00,
    0x0225_fe00,
    0x1093_bf00,
    0xd231_7880,
    0x72ed_2c40,
    0x0c7f_de20,
    0x5545_af90,
    0xa728_a088,
    0x3b12_d01c,
    0x52fb_7842,
    0xd600_2c11,
    0x4f0d_5ee5,
    0xb681_6fdb,
    0x2f4a_008c,
    0x322d_005f,
    0xc892_8095,
    0xa634_c0e6,
    0xdcea_a02c,
    0xe77b_d06b,
    0x65cb_f8de,
    0xaf6d_ec59,
    0x53bf_7ec6,
    0x4f23_7fe3,
    0x9719_d829,
    0x88ff_fcee,
    0x9304_a61b,
    0x9485_83bc,
    0x8e45_fe33,
    0x4fa3_bfde,
    0x4759_7828,
    0x9459_2c3d,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x5000_0000,
    0xb800_0000,
    0xec00_0000,
    0x6600_0000,
    0x2300_0000,
    0xab80_0000,
    0xadc0_0000,
    0x1b60_0000,
    0x1710_0000,
    0x09e8_0000,
    0x0c5c_0000,
    0xabca_0000,
    0x8869_0000,
    0x7499_8000,
    0xa023_c000,
    0x2531_e000,
    0x15d6_f000,
    0x6f0d_d800,
    0x5d8d_6c00,
    0x16c2_ce00,
    0x0ce3_4d00,
    0x64d6_5880,
    0xdd8b_acc0,
    0xd6c8_ae20,
    0x2ce3_7d50,
    0x34d9_e038,
    0x658a_f02c,
    0x3ac7_d846,
    0x4ae4_6c73,
    0x17db_4e13,
    0xce00_8d41,
    0x9707_b8fd,
    0x518d_5cf4,
    0x00cd_7682,
    0xc7e2_11f1,
    0x9b59_2e88,
    0xfa4c_bdb3,
    0x88aa_00bb,
    0xb379_001f,
    0x3b71_80bd,
    0xdf7f_c08c,
    0x9d7b_e0de,
    0xdc7f_f025,
    0x66f4_58f7,
    0xc9be_ac9b,
    0x919b_2e10,
    0xb8a9_bdb2,
    0xbb71_8026,
    0x1f7f_c05b,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x1000_0000,
    0xd800_0000,
    0x4400_0000,
    0x7e00_0000,
    0x6100_0000,
    0x2380_0000,
    0x7ec0_0000,
    0xf120_0000,
    0x2650_0000,
    0x1fe8_0000,
    0xcf7c_0000,
    0x1dbe_0000,
    0xbe95_0000,
    0x6bcf_8000,
    0xc4af_4000,
    0xd59d_6000,
    0x3f46_d000,
    0x14e0_1800,
    0x8bf4_5c00,
    0x15f5_da00,
    0xa4f8_2100,
    0x3f7d_7880,
    0x15b2_8cc0,
    0x4295_c260,
    0x41cc_7d10,
    0x03a8_a258,
    0xd31a_ad84,
    0x1c00_ba9e,
    0xfa02_f1b1,
    0x7f03_601b,
    0x5283_d0ea,
    0x8547_9837,
    0xcbe7_1c13,
    0xa976_ba9a,
    0x58bb_f194,
    0xf31a_e031,
    0xac05_9047,
    0x520b_78c6,
    0xf30b_8c43,
    0xb08c_42fe,
    0xde4a_3d2c,
    0xf764_4283,
    0x9536_3d9f,
    0xf4da_4275,
    0x5aa3_3d4f,
    0x6495_c25c,
    0xa4cc_7dd7,
    0x3e28_a2cf,
    0xdcda_ad6b,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x1000_0000,
    0xa800_0000,
    0x7c00_0000,
    0x1600_0000,
    0x6d00_0000,
    0x7b80_0000,
    0x6640_0000,
    0xe320_0000,
    0x87d0_0000,
    0xf368_0000,
    0xf9f4_0000,
    0x1732_0000,
    0xa8dd_0000,
    0xcfec_8000,
    0x3f38_c000,
    0x94d8_e000,
    0x79e6_9000,
    0x4235_9800,
    0x4755_1400,
    0x63a9_ba00,
    0xb71c_3100,
    0xad85_7880,
    0xeb47_8440,
    0x28ae_22a0,
    0x5994_2510,
    0xc440_4228,
    0x1423_753c,
    0x9f53_ba36,
    0x47a5_313d,
    0xc513_f8f3,
    0x1286_444a,
    0x3fc0_42fd,
    0x3263_7586,
    0xdc73_bab6,
    0xd075_31ce,
    0x9e7b_f8b9,
    0x9772_4474,
    0x3ef2_42ac,
    0xf7be_754b,
    0x681f_3aad,
    0x890d_f1fe,
    0xe983_1824,
    0x6944_d472,
    0x8faf_dabf,
    0x491f_61d4,
    0x1c84_809a,
    0x96cc_c0c5,
    0x8bea_e0b4,
    0xbd3b_909a,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0xf000_0000,
    0xb800_0000,
    0x2400_0000,
    0x0e00_0000,
    0xd100_0000,
    0x9680_0000,
    0x05c0_0000,
    0x1260_0000,
    0x69b0_0000,
    0x41a8_0000,
    0x3ed4_0000,
    0x689e_0000,
    0x7fb3_0000,
    0x64a1_8000,
    0x8e5f_4000,
    0xd05a_6000,
    0x6957_d000,
    0xf3da_4800,
    0x941a_ec00,
    0xc57b_3e00,
    0xc14e_7f00,
    0xcca8_2880,
    0xa259_3c40,
    0x225f_7660,
    0x6257_93f0,
    0x025a_9638,
    0xf25c_0364,
    0x4a53_3eee,
    0x6e5a_7f61,
    0x6056_28ce,
    0xb15a_3c91,
    0x27d6_f6c4,
    0x221c_d36c,
    0x307e_f6e1,
    0x59c8_d38e,
    0x1860_f602,
    0x26bb_d372,
    0x4e21_76f9,
    0x3194_9348,
    0x5533_16bd,
    0xdb67_4304,
    0x0b3f_5e7e,
    0x626a_af1b,
    0x91b3_e0cb,
    0x05ac_9070,
    0xc0d6_2898,
    0x019a_3c86,
    0xcd36_f6df,
    0x6f6c_d386,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x5000_0000,
    0x2800_0000,
    0x4c00_0000,
    0x4a00_0000,
    0xe500_0000,
    0x7c80_0000,
    0x4540_0000,
    0x8b60_0000,
    0x9050_0000,
    0x7c28_0000,
    0xda34_0000,
    0x76f6_0000,
    0x1c59_0000,
    0x9620_8000,
    0x8f3b_c000,
    0x7275_2000,
    0x3d11_1000,
    0x1b47_2800,
    0xb065_6400,
    0x97dc_0e00,
    0xdeef_8900,
    0xa39a_0880,
    0xb700_7440,
    0xed8d_26e0,
    0xf7c3_ed50,
    0x7d2e_86a8,
    0xe0b0_3d0c,
    0x7cbc_0e2a,
    0x5ebf_89f5,
    0x17b2_0834,
    0x7134_7419,
    0xf97b_2609,
    0x429a_ed69,
    0xdd8e_06e2,
    0xcfcb_fd76,
    0xf929_2eab,
    0xb6be_993c,
    0xfbbd_2055,
    0x8b35_10dc,
    0x6479_2871,
    0x5a18_6492,
    0x9ec2_8e99,
    0xeba9_4915,
    0xf0f1_a838,
    0xf357_a400,
    0xefa1_ae37,
    0xe6f1_59ea,
    0x945e_003a,
    0x6a2d_00fe,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x5000_0000,
    0x2800_0000,
    0xfc00_0000,
    0x0a00_0000,
    0xf900_0000,
    0x8e80_0000,
    0x6bc0_0000,
    0x2ae0_0000,
    0x9a30_0000,
    0xe428_0000,
    0x2454_0000,
    0xe4da_0000,
    0xc819_0000,
    0x137c_8000,
    0xe704_c000,
    0xe181_2000,
    0x6645_d000,
    0x4ea0_0800,
    0x8194_cc00,
    0xc932_b600,
    0x83a4_c700,
    0xc91b_2880,
    0x09f8_1c40,
    0x5ac6_3e20,
    0x6860_cb50,
    0xa3f2_bea8,
    0xb3c0_0bbc,
    0xeee1_9eaa,
    0x6438_dbe9,
    0xbb2f_1606,
    0x71d5_d787,
    0x0492_00a8,
    0x0dbd_008f,
    0x316e_8068,
    0x3d79_c01a,
    0xd00f_a062,
    0x680c_103c,
    0xdc07_a859,
    0x5a0c_dccb,
    0xd10f_1e45,
    0x7281_1b7b,
    0x61c0_b6f7,
    0xd3e9_c750,
    0x14bd_a89b,
    0x8fe5_dcfe,
    0x0ebb_9e99,
    0x7ee1_db6d,
    0x2c33_968d,
    0x3721_17ae,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xb000_0000,
    0x3800_0000,
    0xb400_0000,
    0x4600_0000,
    0x4b00_0000,
    0xfc80_0000,
    0x8640_0000,
    0x03a0_0000,
    0xb670_0000,
    0x52e8_0000,
    0x7354_0000,
    0xc3da_0000,
    0xd797_0000,
    0x493d_8000,
    0xc0ce_4000,
    0x64ea_e000,
    0x6055_7000,
    0x1b50_6800,
    0x9fdc_7400,
    0x8d9a_6200,
    0x7839_1b00,
    0xbd40_8880,
    0xa72e_0440,
    0x143f_8a20,
    0x9f4f_2fb0,
    0x0222_0ab8,
    0x9fb1_6ff4,
    0x2f80_eae6,
    0x3ec0_1fbb,
    0xdbe2_8264,
    0xfadf_6bc2,
    0x661f_60dd,
    0x58ff_30b9,
    0x09a8_88f0,
    0x6f7a_04ba,
    0x3365_8a42,
    0xca98_2f18,
    0x36bf_8a22,
    0x160f_2f88,
    0xa302_0aaa,
    0xe081_6f04,
    0xfc48_ea58,
    0x82a4_1f09,
    0xf3f0_82ef,
    0x252c_6b73,
    0x4130_e06a,
    0x0cc2_70c6,
    0xb6ed_e80e,
    0xdd52_34a7,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0xf000_0000,
    0x5800_0000,
    0x9c00_0000,
    0x1e00_0000,
    0x3f00_0000,
    0x8380_0000,
    0x0240_0000,
    0x18e0_0000,
    0x1bd0_0000,
    0xe128_0000,
    0xad7c_0000,
    0x0412_0000,
    0x048b_0000,
    0x8dc3_8000,
    0x0cac_c000,
    0x083b_6000,
    0xa377_b000,
    0xf314_1800,
    0x130c_3400,
    0xa583_4600,
    0xf149_2100,
    0x2d6c_f880,
    0xe297_44c0,
    0xf84c_3ea0,
    0x95e2_a5f0,
    0x4153_a6d8,
    0x33ee_515c,
    0x7251_803e,
    0xa667_c00f,
    0x7b18_e07b,
    0xe70b_706e,
    0xdf87_785e,
    0xbc47_84b8,
    0xd7e5_5e7c,
    0xc05e_1590,
    0x7f64_3e1f,
    0xab9e_a5dd,
    0x20c1_a654,
    0x6625_518a,
    0x22f2_0095,
    0x105b_00a6,
    0x176b_809c,
    0xcf90_c048,
    0x52c9_60e5,
    0x1f2c_b0ff,
    0x027f_9853,
    0x8f9c_f474,
    0x32ca_26d4,
    0x4f25_91c3,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x3000_0000,
    0xd800_0000,
    0xfc00_0000,
    0x6a00_0000,
    0xab00_0000,
    0x7180_0000,
    0x0fc0_0000,
    0x8320_0000,
    0x33b0_0000,
    0x9568_0000,
    0x5b5c_0000,
    0xd3fe_0000,
    0x0c87_0000,
    0x1f47_8000,
    0x066a_c000,
    0x26d8_2000,
    0x0e30_f000,
    0xe8aa_7800,
    0xef76_ec00,
    0xcbc8_9a00,
    0xe526_5f00,
    0x4ab5_d880,
    0x83ec_dcc0,
    0x971a_c260,
    0x0810_4330,
    0xa79f_3a58,
    0x1d50_6f3c,
    0x3af1_808a,
    0x9201_c05b,
    0xc709_a0c9,
    0x9381_30c3,
    0xb0cb_d831,
    0xbcab_dc64,
    0x017d_428e,
    0xa6ca_83ff,
    0xbdaf_1aa1,
    0xbbfc_9ff0,
    0xe885_f8e9,
    0xe940_2c9e,
    0xf76e_bad8,
    0x2451_af95,
    0x8c78_2016,
    0x0e40_f072,
    0xf4e2_7889,
    0x1c9a_ec79,
    0x24de_9aae,
    0x413d_5fa2,
    0x6f2c_5848,
    0x11b1_1c01,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0xd000_0000,
    0x3800_0000,
    0x2c00_0000,
    0xe600_0000,
    0xb700_0000,
    0x5980_0000,
    0xea40_0000,
    0xdf20_0000,
    0x17d0_0000,
    0x4ae8_0000,
    0xb5b4_0000,
    0x6b9e_0000,
    0xeac1_0000,
    0x5fe1_8000,
    0xe939_c000,
    0xc558_e000,
    0x0726_3000,
    0xabdb_3800,
    0xf4e8_b400,
    0xfeb9_9a00,
    0xec15_0100,
    0x9b8a_5880,
    0x3f43_4440,
    0xa3a4_4260,
    0x091a_85d0,
    0x4f09_7ab8,
    0x5587_316c,
    0xbc4f_6006,
    0x802a_f027,
    0x5a5c_5801,
    0x6aa6_4416,
    0x3b93_c201,
    0x92c6_458c,
    0x13e6_1a75,
    0xdf3d_c1a8,
    0x4a5b_380d,
    0x72a8_b487,
    0xa799_9a92,
    0x9cc5_01b7,
    0xb0e2_58ba,
    0x4cb7_4483,
    0xf11a_4240,
    0x430b_857a,
    0x0380_fa5a,
    0xe34a_f193,
    0xcda9_8066,
    0x7a1d_c049,
    0xe48e_e0d6,
    0xc2c3_3058,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0xb000_0000,
    0x6800_0000,
    0x3c00_0000,
    0xd600_0000,
    0x5100_0000,
    0x1a80_0000,
    0x49c0_0000,
    0xdf20_0000,
    0xead0_0000,
    0xfa68_0000,
    0x5d3c_0000,
    0x9d1a_0000,
    0x884f_0000,
    0x5b68_8000,
    0xcfba_c000,
    0x78d8_e000,
    0x5964_5000,
    0xb4b1_0800,
    0xc55d_ec00,
    0xeb20_ca00,
    0x50d0_d900,
    0x8569_6880,
    0xf2bf_7cc0,
    0x4c53_2220,
    0xa5a6_65b0,
    0xf310_2ae8,
    0xdd48_89fc,
    0x53e2_6076,
    0xe57d_9021,
    0x6e73_6852,
    0x5bf0_7cc5,
    0x45bb_a261,
    0xafdc_a587,
    0xeae8_cab6,
    0x03fc_d985,
    0xd1bb_68f8,
    0x65dc_7c5b,
    0xdde9_a236,
    0x207f_a5f4,
    0xbef2_4a21,
    0x2535_1921,
    0xb911_081e,
    0x2a4d_ecea,
    0x5068_ca45,
    0x3a3c_d9e9,
    0x469b_6852,
    0x030c_7c74,
    0x9981_a298,
    0x1043_a54d,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0xd000_0000,
    0x5800_0000,
    0x1400_0000,
    0xda00_0000,
    0xf300_0000,
    0x0180_0000,
    0x7e40_0000,
    0x2860_0000,
    0x55d0_0000,
    0x21a8_0000,
    0x2efc_0000,
    0x4c9e_0000,
    0x1249_0000,
    0x966f_8000,
    0x94da_4000,
    0x4f2d_2000,
    0xc737_f000,
    0x27b2_f800,
    0x477c_7400,
    0x6eda_2e00,
    0xcc2c_e100,
    0x2eb8_5880,
    0xc5fd_c4c0,
    0xf913_f660,
    0x0602_65d0,
    0xc509_0ed8,
    0x8c82_11d4,
    0xdecd_203a,
    0xe8a7_f0e3,
    0xcc7a_f839,
    0x0b50_74ba,
    0x806c_2eaa,
    0x69d9_e1b2,
    0x07a9_d87a,
    0x9bfe_8463,
    0x2819_5605,
    0x5083_d5e9,
    0xe8c0_d647,
    0x65ac_953b,
    0x6cfc_7618,
    0xcb98_2518,
    0x19c4_2e44,
    0x4325_e1bb,
    0xa937_d8fd,
    0xbeb7_843d,
    0x3df6_d684,
    0x5d19_9522,
    0x540d_f6d7,
    0x7a0b_6593,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0xb000_0000,
    0xa800_0000,
    0xcc00_0000,
    0x2200_0000,
    0xb100_0000,
    0xbe80_0000,
    0xea40_0000,
    0x9de0_0000,
    0xf310_0000,
    0x4828_0000,
    0x523c_0000,
    0x609e_0000,
    0xe6ef_0000,
    0x9090_8000,
    0xeee9_c000,
    0x8c9f_a000,
    0xd4e3_5000,
    0x5992_0800,
    0x8463_1400,
    0x20d2_e600,
    0x160c_dd00,
    0x8703_2880,
    0x2986_84c0,
    0xbbcf_ce60,
    0xf225_59b0,
    0x473c_6628,
    0x501a_1d0c,
    0x2fa4_08c2,
    0xaaf0_14c1,
    0x853c_6676,
    0x911a_1d96,
    0x5924_0897,
    0x3cb0_144e,
    0x92dc_66b4,
    0x1f0a_1db9,
    0x8d8c_086b,
    0x35cc_14f3,
    0xd122_6607,
    0xe0b5_1d4e,
    0xc8d4_8832,
    0x7a09_d486,
    0x750b_c676,
    0x8085_4d7e,
    0x6148_00e2,
    0xf66c_0098,
    0x49d6_00ed,
    0xac83_006d,
    0x3346_800c,
    0x8f6a_c0fa,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x9000_0000,
    0xd800_0000,
    0x6400_0000,
    0xaa00_0000,
    0xc100_0000,
    0x4780_0000,
    0x8f40_0000,
    0x94a0_0000,
    0xbb30_0000,
    0x4968_0000,
    0xc55c_0000,
    0x34b2_0000,
    0xba2d_0000,
    0x3ffb_8000,
    0x748d_4000,
    0xadc2_2000,
    0x566d_d000,
    0xf1d1_9800,
    0xf97b_c400,
    0xdc43_6200,
    0x862b_9f00,
    0x31fa_3880,
    0xbf86_54c0,
    0xbb43_5aa0,
    0x46ac_cb90,
    0x8e38_e258,
    0x7ce6_dfa4,
    0xef18_188a,
    0x4d9b_8491,
    0x4f5a_c23f,
    0xa5bb_0f7b,
    0x85a1_8066,
    0x44bc_40de,
    0x922b_a004,
    0xb3fd_901b,
    0xf280_383f,
    0x7ac7_54ea,
    0x1ee2_da48,
    0x5210_8bcb,
    0x6413_4217,
    0x3b1b_4f66,
    0x6f98_204e,
    0x925c_d0dc,
    0xbc38_187f,
    0xb9eb_8495,
    0x3292_c22b,
    0x4bd7_0f0f,
    0x207b_80c4,
    0x5fcd_40c3,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0xb000_0000,
    0x6800_0000,
    0x2400_0000,
    0xa200_0000,
    0x1500_0000,
    0x4f80_0000,
    0xee40_0000,
    0x0b60_0000,
    0x6d70_0000,
    0xb3a8_0000,
    0x21dc_0000,
    0x9cf2_0000,
    0x76ef_0000,
    0x8e30_8000,
    0x1b4b_4000,
    0x94eb_a000,
    0xfb3f_9000,
    0x44cf_9800,
    0xa2af_1400,
    0xbc5d_5e00,
    0xafb5_eb00,
    0xa606_b880,
    0xc704_c4c0,
    0x9281_e6a0,
    0x35c2_2fb0,
    0x2f25_dee8,
    0x5712_abe4,
    0x3357_1882,
    0x6938_5465,
    0xf9c4_fe87,
    0x6925_7b7a,
    0x4019_a041,
    0xd9d0_909c,
    0xa0ff_18fe,
    0x38e4_546a,
    0xad36_feb0,
    0x8bca_7bd1,
    0x0429_2014,
    0xf39b_d082,
    0xd994_b854,
    0x389b_c4f2,
    0xad19_6635,
    0xaa55_6f86,
    0x00bc_7e37,
    0x1082_3bbb,
    0x50c8_0085,
    0xa8ac_0076,
    0x2d5a_0027,
    0xf233_00da,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x3000_0000,
    0xd800_0000,
    0xf400_0000,
    0x1600_0000,
    0xfd00_0000,
    0xc380_0000,
    0x5340_0000,
    0x8a20_0000,
    0x27b0_0000,
    0x5be8_0000,
    0x1754_0000,
    0x323e_0000,
    0xd5af_0000,
    0x0eff_8000,
    0xaec2_4000,
    0x286b_e000,
    0xdc1b_1000,
    0x2c19_1800,
    0xd41a_0400,
    0x701e_0a00,
    0x8e13_1700,
    0x5f13_7880,
    0x7e9c_5440,
    0xc6db_7260,
    0x7274_4330,
    0xc509_8a58,
    0x4785_57b4,
    0xfd46_98f6,
    0xb328_448d,
    0x2a3d_ea7b,
    0x01ac_0797,
    0x48fc_60c4,
    0xbbcd_506e,
    0xc7ec_f8ee,
    0x6d5e_1489,
    0x4d30_92a3,
    0xcd2f_5355,
    0xbb30_9249,
    0x402f_5323,
    0xc0b0_9262,
    0xd76f_533d,
    0x8490_92a2,
    0xf9df_530c,
    0x0af8_9223,
    0x40cb_5392,
    0x7166_9284,
    0xe194_5389,
    0xae51_12f3,
    0x7fb2_138b,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0xf000_0000,
    0x4800_0000,
    0xe400_0000,
    0xbe00_0000,
    0x5100_0000,
    0xd180_0000,
    0xb7c0_0000,
    0x1f60_0000,
    0x4750_0000,
    0x1628_0000,
    0xaf7c_0000,
    0x485e_0000,
    0xa6ab_0000,
    0xe13e_8000,
    0xf4ff_4000,
    0x0894_6000,
    0x054d_d000,
    0x222d_b800,
    0x0978_0c00,
    0x2554_3e00,
    0x9527_3100,
    0x15f1_5880,
    0x311d_9cc0,
    0xc68d_6660,
    0x3b46_adf0,
    0xb322_3ec8,
    0xb8f0_3124,
    0x6291_d85e,
    0xc249_dc61,
    0xb6a7_86f9,
    0x9934_3da3,
    0x38fb_e669,
    0xa295_ed32,
    0xa240_5e99,
    0x46aa_e179,
    0xd13c_e02e,
    0xdcf5_9082,
    0x1c91_587e,
    0xf34d_9c59,
    0x9725_6671,
    0x66fa_ad0e,
    0xc39c_3e7b,
    0x5bcb_313a,
    0xe567_58f4,
    0x385a_9c0b,
    0x2ea5_e656,
    0x653e_ed67,
    0xbafe_de08,
    0x1195_a12f,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x9000_0000,
    0xf800_0000,
    0x9c00_0000,
    0x7600_0000,
    0x0d00_0000,
    0x9f80_0000,
    0xc9c0_0000,
    0x9b20_0000,
    0x9810_0000,
    0x7618_0000,
    0x971c_0000,
    0xb696_0000,
    0x865f_0000,
    0x90f0_8000,
    0x2629_4000,
    0x2f96_2000,
    0x7bda_f000,
    0x763d_0800,
    0xad82_9400,
    0xfec5_a600,
    0x27ae_6700,
    0xcf5d_a680,
    0x3572_6740,
    0xcceb_a620,
    0x2a3d_67d0,
    0x3b83_26d8,
    0xc3c8_274c,
    0xd023_06ae,
    0x629d_d741,
    0x4456_8e31,
    0x2ffa_0388,
    0xceab_08aa,
    0xfadd_9410,
    0x27b5_265c,
    0x5547_27c7,
    0x1c6b_86ca,
    0x8378_9791,
    0x21ee_ae02,
    0x85b3_f3bb,
    0x9a48_80a3,
    0x3ce5_4051,
    0xa238_20bc,
    0x6f89_f078,
    0x41c3_88e6,
    0xcf28_d49e,
    0x1a15_063c,
    0x6912_d738,
    0xef9e_0ec6,
    0x9bdf_434e,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x5000_0000,
    0xd800_0000,
    0x3400_0000,
    0xd600_0000,
    0x8d00_0000,
    0xd380_0000,
    0xea40_0000,
    0xfd60_0000,
    0xca10_0000,
    0x7418_0000,
    0x8514_0000,
    0x0c92_0000,
    0xd9d7_0000,
    0x743a_8000,
    0x3ee9_c000,
    0x585c_a000,
    0x8d70_7000,
    0x1107_4800,
    0x1982_ec00,
    0x6d49_ba00,
    0xc9ed_db00,
    0x44d1_ba80,
    0xdfb9_dbc0,
    0xd0a3_bae0,
    0xfb3e_db90,
    0x2661_3a38,
    0x5493_1ba4,
    0x2dd7_9aee,
    0xc230_6b29,
    0xe3e0_523d,
    0x53d8_47c3,
    0x533d_c8c0,
    0x3a6b_2c09,
    0x5e95_1a34,
    0xcadd_ab4c,
    0xa6b6_f2d8,
    0xb52b_3705,
    0xcc72_0014,
    0xd087_005f,
    0x40c2_80c2,
    0x72ad_c0ab,
    0x0036_a0b6,
    0x48e3_7085,
    0xe557_c82d,
    0xd6f8_2c58,
    0x1745_9a36,
    0x06e7_6b45,
    0xfc5a_d2cd,
    0xe371_87c8,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x9000_0000,
    0x4800_0000,
    0x6400_0000,
    0xfa00_0000,
    0x1700_0000,
    0xdd80_0000,
    0xd0c0_0000,
    0x9ba0_0000,
    0x34f0_0000,
    0xebf8_0000,
    0x9274_0000,
    0xd8b2_0000,
    0xc41b_0000,
    0x656f_8000,
    0x3a51_c000,
    0xc98a_6000,
    0x32c9_1000,
    0xc0a7_c800,
    0xe771_4400,
    0x9e3b_3e00,
    0xa759_1100,
    0x1b09_3e80,
    0x7382_11c0,
    0x85c6_bee0,
    0xed23_d150,
    0xefb4_dea8,
    0x299e_c134,
    0x0da1_1652,
    0x1df4_8523,
    0x2b75_a88f,
    0x503c_54f3,
    0x6256_f694,
    0x2587_5507,
    0xcccf_809f,
    0xbda1_c0c5,
    0x65f2_60ef,
    0xf77d_1035,
    0x1635_c858,
    0xa35a_44ec,
    0x710c_befe,
    0x2c8c_d17d,
    0x3c49_5e02,
    0xc7e4_01a9,
    0x631c_f651,
    0xc0e8_55e8,
    0x3692_00aa,
    0x142b_009d,
    0xc737_8003,
    0x7fd5_c0cb,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0xf000_0000,
    0x8800_0000,
    0x4400_0000,
    0xa600_0000,
    0x6b00_0000,
    0xcd80_0000,
    0x4740_0000,
    0x69e0_0000,
    0x6230_0000,
    0xa138_0000,
    0x78bc_0000,
    0x01f2_0000,
    0x3f1d_0000,
    0xfaa5_8000,
    0x95d9_c000,
    0x840f_a000,
    0x060b_1000,
    0x7b02_c800,
    0xb58f_3c00,
    0x8b4a_6200,
    0x8bea_e100,
    0xaf38_6280,
    0x07b7_e140,
    0xf27d_e260,
    0x2f5e_21b0,
    0x34ca_42e8,
    0x39a9_31f4,
    0x4c5a_8a4e,
    0xfd4b_0d9f,
    0x38ed_6883,
    0xbeb4_2cd8,
    0xdaf0_aa6a,
    0x9a99_ddfa,
    0x09e0_00ab,
    0xd230_0032,
    0xc938_0042,
    0xccbc_00f9,
    0x2ff2_0076,
    0x101d_00b3,
    0x9125_8011,
    0xb999_c0dd,
    0x206f_a068,
    0x237b_1026,
    0xb3da_c8e6,
    0xaf03_3cf0,
    0x2b80_6280,
    0xcc4b_e1d2,
    0x546f_e2a8,
    0xad73_216f,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0xd000_0000,
    0xe800_0000,
    0xf400_0000,
    0x4a00_0000,
    0x5100_0000,
    0xae80_0000,
    0xb5c0_0000,
    0xb5a0_0000,
    0x7a50_0000,
    0x6758_0000,
    0xdfdc_0000,
    0xe51a_0000,
    0x3537_0000,
    0xed29_8000,
    0xd09e_c000,
    0x3f76_6000,
    0x23c1_7000,
    0x7aa8_9800,
    0x7fd4_4400,
    0x1510_de00,
    0x6d35_9b00,
    0x212a_de80,
    0x8692_9b40,
    0xd07b_5ee0,
    0x9640_5b90,
    0x30ef_3e08,
    0xd13a_2b64,
    0x6f2c_2642,
    0xc59b_af35,
    0xe3f9_18ec,
    0xdb06_8480,
    0xdf84_bed9,
    0xab4f_ebba,
    0x3869_c65e,
    0xd3f3_1ff5,
    0xa30e_6033,
    0xa38d_70e4,
    0xc54a_98fc,
    0xcb6f_44d1,
    0xd87b_5e47,
    0xf240_5bc6,
    0xf2ef_3e4e,
    0xa43a_2bc2,
    0x63ac_26a3,
    0xd55b_af8b,
    0xb2d9_1846,
    0x4596_84a6,
    0xa3fc_bee1,
    0xbb03_ebbe,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0xb000_0000,
    0xf800_0000,
    0x3400_0000,
    0x7600_0000,
    0x4d00_0000,
    0x8880_0000,
    0x93c0_0000,
    0x9e20_0000,
    0x5fd0_0000,
    0x40d8_0000,
    0x9b54_0000,
    0x511a_0000,
    0xde71_0000,
    0x7b4e_8000,
    0x7de5_c000,
    0xd9fe_a000,
    0x9b0c_7000,
    0x558b_f800,
    0xb34f_4400,
    0x71e0_e600,
    0x7bf6_fb00,
    0x1002_e680,
    0x6803_fbc0,
    0x9c0e_6660,
    0x0a03_3b70,
    0xf704_4698,
    0x878b_8b44,
    0x2047_9eee,
    0xc869_7f09,
    0xdab0_2066,
    0x12e9_b09a,
    0x1a75_5878,
    0xd543_3405,
    0x54eb_1ed8,
    0x6f79_bf2e,
    0x89c2_00f1,
    0x0125_0004,
    0x4454_809c,
    0x6a94_c044,
    0xa430_20d5,
    0x0c29_b0c8,
    0xecd5_5890,
    0xa953_345d,
    0x7213_1e5f,
    0x9ffd_bf63,
    0xee00_0088,
    0x0900_00d9,
    0xe680_00d1,
    0x5ac0_001a,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x7000_0000,
    0x6800_0000,
    0x4400_0000,
    0x3200_0000,
    0x1900_0000,
    0x5d80_0000,
    0x5240_0000,
    0x2b60_0000,
    0x5c10_0000,
    0xd998_0000,
    0x07dc_0000,
    0xcab2_0000,
    0xa5a5_0000,
    0x14bb_8000,
    0x6aa3_c000,
    0xf232_e000,
    0x6466_7000,
    0xfa90_2800,
    0x3752_cc00,
    0x7f7c_9a00,
    0xf180_2b00,
    0x6447_1a80,
    0xe063_eb40,
    0x6895_fa60,
    0xbe55_9b30,
    0x3afd_d208,
    0x8fcb_5774,
    0x392b_483a,
    0x9772_7c6d,
    0xf585_d2e7,
    0xb647_577f,
    0x8961_48ac,
    0x5d1b_7c13,
    0xa814_527d,
    0x239d_9760,
    0xcada_288d,
    0xbd3b_cca8,
    0xc2ed_1afe,
    0x145a_ebfd,
    0x4ffc_7a40,
    0x4443_5bfa,
    0x306c_b2af,
    0x9092_e7e9,
    0xe25b_80ef,
    0x24f3_c0e9,
    0xe0ca_e048,
    0x4faa_7096,
    0x81ba_2843,
    0xd12b_ccfa,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x7000_0000,
    0x2800_0000,
    0xcc00_0000,
    0x4a00_0000,
    0x6300_0000,
    0x6e80_0000,
    0x2640_0000,
    0x3ee0_0000,
    0xa170_0000,
    0x4bf8_0000,
    0x5bb4_0000,
    0x845a_0000,
    0x94ad_0000,
    0xf597_8000,
    0x198f_4000,
    0x26c1_e000,
    0x1da2_d000,
    0xa81f_b800,
    0xe94c_9c00,
    0xaa61_9200,
    0x2c37_d500,
    0xa796_1280,
    0xbe88_95c0,
    0x5e4f_f260,
    0x4aee_45b0,
    0x7f72_4a48,
    0x86fb_d97c,
    0xd03e_5802,
    0xe59e_4c1f,
    0x8186_2aec,
    0x22cf_49f9,
    0xebad_80b2,
    0xa912_40e8,
    0x28ce_60b1,
    0xa8a9_90cf,
    0x579c_58b7,
    0x5687_4c84,
    0x724b_aa4e,
    0x70ed_0914,
    0x347b_e0f2,
    0x247f_d02d,
    0xbc70_3821,
    0xb877_dca8,
    0x4e7a_72b2,
    0x4f78_0556,
    0x8efe_2acd,
    0x8c3b_4951,
    0xf797_8000,
    0x068f_40be,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0xd000_0000,
    0x9800_0000,
    0x6c00_0000,
    0x1600_0000,
    0x4500_0000,
    0x5a80_0000,
    0x77c0_0000,
    0x93e0_0000,
    0xc9d0_0000,
    0x0558_0000,
    0xf794_0000,
    0x1ef6_0000,
    0x70eb_0000,
    0x7e5a_8000,
    0x2c18_4000,
    0x21b7_2000,
    0xe3cc_7000,
    0xd9e5_5800,
    0xf2d1_6400,
    0x3ed5_fa00,
    0x38dd_5700,
    0xc5d7_7a80,
    0x2351_17c0,
    0xda96_5aa0,
    0x6076_6710,
    0xe529_8238,
    0xd2bf_437c,
    0xec4b_582e,
    0x4cae_6439,
    0xaaf9_7af4,
    0xeaee_178e,
    0xdd5a_dac7,
    0x7b95_2757,
    0xf8fc_227a,
    0x7def_731c,
    0xd0d7_20ea,
    0x21dc_7045,
    0xe15d_5858,
    0x3595_649b,
    0xf1fb_fa90,
    0xe162_5716,
    0x7a1b_fac7,
    0x84b2_5776,
    0x4943_fad4,
    0xe626_575c,
    0x9535_fab3,
    0x8d0d_5738,
    0x6e8f_7ab3,
    0x2dc5_171b,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0xd000_0000,
    0xb800_0000,
    0x5400_0000,
    0xce00_0000,
    0x9300_0000,
    0xa180_0000,
    0xe340_0000,
    0x7660_0000,
    0x13b0_0000,
    0xc838_0000,
    0x6674_0000,
    0xfa92_0000,
    0x2fef_0000,
    0x04fc_8000,
    0xc05d_c000,
    0x8ecb_2000,
    0x7f21_1000,
    0x30d1_8800,
    0xd50f_7c00,
    0xce88_ba00,
    0x00cd_d100,
    0x4c2c_3a80,
    0x2154_11c0,
    0x5e4d_1ae0,
    0x54ee_0110,
    0x8972_1258,
    0xd913_bd44,
    0x75ad_0896,
    0xe612_bcd7,
    0xee23_9ab7,
    0xe85c_c1f4,
    0xc2c5_b221,
    0x552f_6df7,
    0x05d7_a031,
    0x0b8c_d015,
    0x1642_a83d,
    0xc8ea_6c3d,
    0x1b73_3236,
    0xb819_ad5d,
    0x652a_0057,
    0xaddb_0046,
    0x878e_80f7,
    0x5c42_c065,
    0x2def_a072,
    0x7df8_d04b,
    0x34d0_a8c0,
    0x6305_6c51,
    0x698f_b2b3,
    0xbf44_6dac,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x3000_0000,
    0xb800_0000,
    0x0400_0000,
    0x3e00_0000,
    0x3b00_0000,
    0x2e80_0000,
    0x8040_0000,
    0x05a0_0000,
    0x8df0_0000,
    0x5178_0000,
    0x8834_0000,
    0xb216_0000,
    0x1c25_0000,
    0x6136_8000,
    0xf592_c000,
    0x1bef_2000,
    0x4355_9000,
    0x6a0b_f800,
    0x6d0e_3c00,
    0xb980_c600,
    0x1cc2_c900,
    0x3cee_4680,
    0xa7d4_09c0,
    0x774f_66a0,
    0x4920_99f0,
    0x1cbc_1e18,
    0xf75d_65f4,
    0x2c0b_7826,
    0x7209_fccf,
    0x9901_6688,
    0x1f81_998f,
    0x13c4_9e2d,
    0x946e_a5f2,
    0x189c_d8e4,
    0x626f_ac4e,
    0x7f9d_3e50,
    0x66e9_f5ad,
    0x72d8_0081,
    0xcac4_0013,
    0x6bee_00a9,
    0x1b51_00a9,
    0x7e00_8031,
    0xdb07_c0ce,
    0x3e81_a0c3,
    0x0843_50f9,
    0xb9aa_d839,
    0xb7fa_ac81,
    0x5473_be4e,
    0x9dbf_35fb,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x1000_0000,
    0x3800_0000,
    0xac00_0000,
    0xda00_0000,
    0x3b00_0000,
    0x7380_0000,
    0x0a40_0000,
    0xbd60_0000,
    0x9510_0000,
    0x8d98_0000,
    0xac54_0000,
    0x077e_0000,
    0xdd0f_0000,
    0x6a84_8000,
    0x4ec2_4000,
    0x0ea5_e000,
    0x2137_5000,
    0x7a6b_e800,
    0x6495_8c00,
    0xa0dd_fa00,
    0x90b0_1b00,
    0x3727_7a80,
    0xe87d_5bc0,
    0xb886_1a20,
    0x31c8_4bd0,
    0x9328_1218,
    0x767a_977c,
    0x6d86_00c2,
    0x1f4b_0047,
    0x33e2_8031,
    0x25d9_408d,
    0xe63f_602c,
    0x8bea_1008,
    0x49d2_8899,
    0x9c34_9c08,
    0xa0ed_f244,
    0x025d_c7ee,
    0x3a75_e8dd,
    0xc78a_8c6a,
    0xac41_7a4e,
    0xc466_5b0e,
    0x619c_9aa1,
    0x1655_0bba,
    0x8c71_7244,
    0x868b_8770,
    0xf4ce_0888,
    0x85a2_dc4b,
    0x7ab6_12aa,
    0xe425_973f,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x5000_0000,
    0xf800_0000,
    0xe400_0000,
    0x6200_0000,
    0xdf00_0000,
    0x8d80_0000,
    0xfd40_0000,
    0x0160_0000,
    0x2bd0_0000,
    0xe558_0000,
    0xd394_0000,
    0xb2b6_0000,
    0x9a83_0000,
    0xdcc4_8000,
    0xf226_c000,
    0xdbb2_e000,
    0xe202_1000,
    0x1f01_4800,
    0xad8e_dc00,
    0xad4f_ea00,
    0xf96a_2700,
    0xcfdd_6a80,
    0x875f_e7c0,
    0x0c93_0aa0,
    0x3f3f_3790,
    0x67ce_a258,
    0xdda4_fb74,
    0xd9f2_803a,
    0x3ee5_c0ab,
    0x3196_6037,
    0xadb4_d096,
    0x370b_a816,
    0x7188_cced,
    0x0b40_a20b,
    0x1463_fbda,
    0x6558_005b,
    0x1394_005f,
    0x92b6_00aa,
    0xca83_00c0,
    0x24c4_80a8,
    0x1626_c0bd,
    0xb9b2_e0c8,
    0x3d02_10f8,
    0x9281_4838,
    0x50ce_dcb9,
    0xac2f_eaa7,
    0xd2ba_271a,
    0x2a85_6a14,
    0x54cb_e7ff,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x1000_0000,
    0x9800_0000,
    0xd400_0000,
    0x6e00_0000,
    0x1f00_0000,
    0x0f80_0000,
    0x4ac0_0000,
    0x3de0_0000,
    0x2b50_0000,
    0x47d8_0000,
    0x709c_0000,
    0x9ab6_0000,
    0x3687_0000,
    0xf646_8000,
    0x72af_c000,
    0xa573_2000,
    0x0deb_d000,
    0xe35e_a800,
    0xabd1_4400,
    0xda9b_7a00,
    0x73ba_bf00,
    0xf20b_fa80,
    0xdd02_7f40,
    0x1a86_5a20,
    0xbc4a_6f50,
    0x2ba5_d2b8,
    0xe9fb_fb84,
    0x6aa8_80d6,
    0x3174_c09b,
    0xc3e3_a059,
    0xec53_1091,
    0x3c53_08c4,
    0x4459_54aa,
    0x2058_f21b,
    0xc65b_2b0e,
    0x955e_a86f,
    0x20d1_4467,
    0x1b1b_7ab6,
    0x367a_bf0f,
    0x586b_fa96,
    0x6892_7fad,
    0x0ebe_5a64,
    0xf886_6fad,
    0xf94b_d2dd,
    0xe520_fb69,
    0x3bb8_0085,
    0x5e0c_00b8,
    0xd70e_00cf,
    0xe38b_0058,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x9000_0000,
    0x2800_0000,
    0x8400_0000,
    0x9a00_0000,
    0xfd00_0000,
    0xd580_0000,
    0xc5c0_0000,
    0x5b60_0000,
    0x3fb0_0000,
    0x9d38_0000,
    0x9874_0000,
    0x3752_0000,
    0x9c4b_0000,
    0xb0a1_8000,
    0xdbd5_c000,
    0xb602_6000,
    0x2300_b000,
    0xd285_6800,
    0x7d4e_7400,
    0x6329_e200,
    0x251f_0900,
    0x63e2_6280,
    0xc7f5_c9c0,
    0xe793_82e0,
    0xf6ab_b950,
    0x40d5_0ac8,
    0xc880_bdd4,
    0x4043_e052,
    0xd6a5_7029,
    0x70df_0807,
    0x108a_c42c,
    0x7c46_8a3c,
    0xe0ae_7d83,
    0x93d8_0009,
    0xa204_005f,
    0x910a_0044,
    0xab8f_006e,
    0x32cb_8069,
    0x5bea_c064,
    0xabf1_e036,
    0x999e_7001,
    0x01a6_8836,
    0x405b_04dc,
    0x5cce_eaec,
    0x44e1_cd9f,
    0x4f76_e879,
    0x07d0_b4e4,
    0xd00a_0262,
    0x880a_7965,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0xb000_0000,
    0x0800_0000,
    0x2400_0000,
    0xee00_0000,
    0xcb00_0000,
    0x1a80_0000,
    0xdb40_0000,
    0xd560_0000,
    0xdab0_0000,
    0xf538_0000,
    0x67f4_0000,
    0x0f5a_0000,
    0xa9c1_0000,
    0x5a29_8000,
    0x09d7_c000,
    0x708f_2000,
    0x6e4c_9000,
    0x5cef_b800,
    0x8775_4c00,
    0x3915_7a00,
    0x692a_a100,
    0x1f5e_fa80,
    0x31c8_61c0,
    0x2622_5a60,
    0x7bd2_3170,
    0x798b_4268,
    0x75cc_2d54,
    0xb826_a086,
    0x58db_509f,
    0xf700_981c,
    0x4889_dc84,
    0x8242_c229,
    0x76eb_edee,
    0x1271_8054,
    0xe093_c06d,
    0x8ced_20d5,
    0xff79_907f,
    0xf51c_387d,
    0x1323_8c39,
    0x3253_da3e,
    0xc441_f162,
    0x09e6_62e3,
    0xbef5_bd52,
    0x6cda_98fa,
    0x8108_dc23,
    0xff8b_4217,
    0xeacc_2d42,
    0xa4a6_a035,
    0xdc9b_5022,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x7000_0000,
    0x6800_0000,
    0x9c00_0000,
    0x6e00_0000,
    0x9f00_0000,
    0xd380_0000,
    0x1c40_0000,
    0xcea0_0000,
    0xd7f0_0000,
    0xc978_0000,
    0xa7bc_0000,
    0x41da_0000,
    0x134d_0000,
    0x4523_8000,
    0x5fbe_4000,
    0x85d6_a000,
    0xe94c_5000,
    0x5829_e800,
    0x1532_ec00,
    0x4910_6600,
    0x862e_2900,
    0xc231_e680,
    0x1691_6940,
    0xec66_c6e0,
    0x6792_7930,
    0xe0e0_0e88,
    0xc85f_85ac,
    0x420c_a0e6,
    0xb901_5033,
    0xc08a_68b5,
    0xb9cc_ac6f,
    0xb9e6_c61b,
    0x38d2_79c8,
    0xf3c0_0e3a,
    0xecef_85b3,
    0xfe54_a075,
    0x490d_504f,
    0xe888_680b,
    0x45cd_acd0,
    0xa7e7_464e,
    0xcfdd_3901,
    0xbc4f_2ee4,
    0x9ea0_9573,
    0xaff0_682c,
    0x4d71_acde,
    0x3dbd_4659,
    0x2cd0_39f0,
    0x31cc_ae31,
    0x15ee_d515,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x5000_0000,
    0xa800_0000,
    0xbc00_0000,
    0x6600_0000,
    0x3b00_0000,
    0x1b80_0000,
    0x66c0_0000,
    0x7460_0000,
    0x0fb0_0000,
    0x5178_0000,
    0x111c_0000,
    0xf4aa_0000,
    0x00d7_0000,
    0x2541_8000,
    0x76a0_4000,
    0x39d1_2000,
    0x47c3_1000,
    0x12ea_e800,
    0x79f9_a400,
    0xa05b_f200,
    0x1804_e100,
    0x040a_d280,
    0x1207_f140,
    0xb100_3ae0,
    0xee8e_5510,
    0xfa43_c848,
    0x6f26_b4ac,
    0x261b_1aae,
    0x312a_45d7,
    0x2910_a055,
    0xc0a3_50a1,
    0xeadb_c869,
    0x804a_b402,
    0x4229_1a96,
    0x9e91_45c4,
    0x0863_2037,
    0x49b8_1065,
    0x5a79_68fb,
    0xf292_e451,
    0x8661_5234,
    0xaeb0_b182,
    0x77f0_9ab9,
    0x075d_0522,
    0x5580_0084,
    0xa1c0_0050,
    0x69e0_002f,
    0x0270_00e6,
    0x9698_00b3,
    0xc46c_0035,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x3000_0000,
    0xf800_0000,
    0x6400_0000,
    0xa200_0000,
    0x7300_0000,
    0xca80_0000,
    0x3bc0_0000,
    0x5ca0_0000,
    0x1c70_0000,
    0x33b8_0000,
    0x1514_0000,
    0xce6a_0000,
    0x5d51_0000,
    0x9c8a_8000,
    0x02c6_c000,
    0xa92d_e000,
    0xe338_5000,
    0x19d6_3800,
    0x2a4a_6400,
    0xc1e2_fe00,
    0xa51d_8100,
    0xf66f_1e80,
    0xd955_d1c0,
    0x0e81_2660,
    0x89cb_b5f0,
    0x07a9_d898,
    0x7af7_3494,
    0x3674_46ba,
    0xfcb0_2527,
    0xc992_8010,
    0xeca2_c0ec,
    0x247f_e0d4,
    0xb7bd_5064,
    0x8716_b85d,
    0x456d_a456,
    0xf3dd_9e03,
    0x0547_1127,
    0x2d66_c62b,
    0x7fd2_e5b1,
    0xeb4d_60c7,
    0x506f_9050,
    0xf851_5807,
    0xaf04_f48a,
    0x2c81_26e5,
    0x3acb_b526,
    0x2d29_d85a,
    0x7137_34dc,
    0x92d4_46e6,
    0x84c0_2501,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x1000_0000,
    0xf800_0000,
    0x0c00_0000,
    0xca00_0000,
    0x5300_0000,
    0xef80_0000,
    0x7ac0_0000,
    0xde60_0000,
    0x8b10_0000,
    0xc5d8_0000,
    0x3dbc_0000,
    0x9fa6_0000,
    0x0eff_0000,
    0x520c_8000,
    0xaf0a_4000,
    0x6d89_e000,
    0xcdc8_5000,
    0x0fe8_e800,
    0x64dc_a400,
    0x6d30_1200,
    0x70eb_cb00,
    0x1159_f280,
    0x1cf3_9b40,
    0x5d09_1a20,
    0xd283_3f50,
    0x5847_08d8,
    0xce2b_f45c,
    0xa134_7a92,
    0x5aed_2f4f,
    0xf258_005d,
    0x1b7c_0065,
    0xd3c6_005b,
    0xcaef_00b2,
    0x4a54_800c,
    0xb776_40c0,
    0x09cf_e04e,
    0x61e7_50eb,
    0xa9dc_68e7,
    0x07ba_e4e6,
    0x84a7_f27e,
    0x0570_9be7,
    0x16c3_9a75,
    0xe466_7f7b,
    0x901a_68b0,
    0xce55_e487,
    0x7973_7279,
    0xd4c6_dbbb,
    0xf36c_7afe,
    0x5191_2f6c,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x3000_0000,
    0x4800_0000,
    0x9400_0000,
    0xd600_0000,
    0xa100_0000,
    0x6580_0000,
    0x7dc0_0000,
    0x5fe0_0000,
    0xd6b0_0000,
    0x5978_0000,
    0xf994_0000,
    0x1fa2_0000,
    0xb899_0000,
    0x8a29_8000,
    0xed52_c000,
    0x71ce_a000,
    0xa5e1_3000,
    0x1db3_a800,
    0xeff9_d400,
    0xded9_9a00,
    0x6d0e_1900,
    0xff8f_3a80,
    0x86cb_29c0,
    0xa166_92e0,
    0x65ff_fdf0,
    0xfdd4_88a8,
    0x1f8a_2464,
    0x76c4_92fe,
    0x8966_fd05,
    0xc1fd_087b,
    0x63d8_e488,
    0x2a8a_328c,
    0xc547_cd3a,
    0x55ae_a0ab,
    0xfb91_3006,
    0xc8ab_a8af,
    0x2c1d_d406,
    0xea63_9ae1,
    0x1373_1945,
    0xba9c_baed,
    0x5d24_e947,
    0x79db_b23a,
    0x1181_0dd3,
    0x5bc2_005a,
    0xd6e9_002d,
    0x1731_8011,
    0xbab6_c015,
    0x9374_a015,
    0x7a9c_30db,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x9000_0000,
    0x0800_0000,
    0x6c00_0000,
    0x7a00_0000,
    0x7700_0000,
    0x7480_0000,
    0x09c0_0000,
    0xabe0_0000,
    0xff90_0000,
    0x5158_0000,
    0xa634_0000,
    0x4c6a_0000,
    0x54db_0000,
    0x1e7f_8000,
    0x61cb_4000,
    0x97e3_e000,
    0x6d91_1000,
    0xda56_1800,
    0xa0b2_e400,
    0x5ea6_0a00,
    0xf1be_0b00,
    0x9f2f_ea80,
    0xeff4_1bc0,
    0xc786_7260,
    0xdb4d_bf50,
    0xd723_9868,
    0xa3f2_a43c,
    0xcd82_6a92,
    0x3440_5b8b,
    0xc7a8_1286,
    0xbc38_efd2,
    0x6b63_e0c5,
    0xc851_10d1,
    0xebb6_1866,
    0xb822_e4ac,
    0x737e_0ac4,
    0x324a_0b16,
    0x02a5_ea8d,
    0x33bf_1b2d,
    0xfc21_f27a,
    0x1572_fffe,
    0xa74a_78c1,
    0x6528_b4c9,
    0x58f3_f29c,
    0x530d_ff45,
    0x4287_f8cf,
    0x74cc_f459,
    0x3065_92ca,
    0xe6dc_afd8,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x9000_0000,
    0x0800_0000,
    0x7c00_0000,
    0x5a00_0000,
    0x3300_0000,
    0xb880_0000,
    0x92c0_0000,
    0x2fe0_0000,
    0xafd0_0000,
    0xdc18_0000,
    0x447c_0000,
    0x3be6_0000,
    0xf9d7_0000,
    0x8d1b_8000,
    0x2bf2_4000,
    0x3fa4_e000,
    0x51f6_5000,
    0xdca6_9800,
    0x417b_d400,
    0xa260_ba00,
    0x3c9d_7f00,
    0x42ba_5a80,
    0x0200_2f40,
    0xa701_4220,
    0xae8e_bbd0,
    0x63c6_9828,
    0xd06b_d4ac,
    0xa398_baf2,
    0x0831_7fdf,
    0x4fc4_5a6a,
    0x626b_2f9d,
    0xdc9c_c2ed,
    0x72bb_fbde,
    0x9a01_f863,
    0xd303_c4d5,
    0x8884_c23a,
    0x0ac7_fbcd,
    0x5be7_f800,
    0x89d4_c40b,
    0xb51f_42e4,
    0xcff5_bb1d,
    0x11a3_18ad,
    0x44f2_947e,
    0x0d21_da73,
    0x5832_6f9d,
    0xa7c5_a266,
    0x2e68_eb47,
    0x1e98_009b,
    0x35bc_005f,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x5000_0000,
    0xf800_0000,
    0x1c00_0000,
    0x6200_0000,
    0x7700_0000,
    0xf380_0000,
    0x93c0_0000,
    0xcb60_0000,
    0x0350_0000,
    0x1998_0000,
    0xf474_0000,
    0x006a_0000,
    0xe2d7_0000,
    0xb55c_8000,
    0x789f_4000,
    0x16f2_6000,
    0x392f_9000,
    0xa4f6_e800,
    0x762c_3400,
    0xab7b_d200,
    0xd7ec_af00,
    0xef1b_b280,
    0x3b30_3fc0,
    0x0743_da60,
    0x7320_4b90,
    0xf7fc_e898,
    0x1bab_348c,
    0x7dbf_527a,
    0x6007_ef3b,
    0x9003_d2e9,
    0x1808_af38,
    0x4c09_b23a,
    0x9a03_3f77,
    0x6b0d_5ab9,
    0x918c_0be8,
    0xe4c0_0828,
    0x38e8_e4ee,
    0x9095_5a25,
    0xd2f8_0bc6,
    0xf72a_0881,
    0x19ff_e498,
    0x16a9_daa4,
    0xb537_4b74,
    0x9a40_6840,
    0xa3a4_74c2,
    0x41b5_3205,
    0xb20c_7fd0,
    0x4f07_3a72,
    0x0f87_9b87,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x1000_0000,
    0x4800_0000,
    0xbc00_0000,
    0x0200_0000,
    0xdf00_0000,
    0xb880_0000,
    0xb1c0_0000,
    0xc860_0000,
    0x77d0_0000,
    0x8f18_0000,
    0xcefc_0000,
    0xc562_0000,
    0xf85b_0000,
    0xca53_8000,
    0xed52_4000,
    0x51dd_6000,
    0x0615_1000,
    0xe771_d800,
    0x4921_2400,
    0x1278_7200,
    0xc2a5_7700,
    0xb13f_1280,
    0xc807_6740,
    0xfc07_4a60,
    0xe203_0350,
    0xcf0b_d828,
    0xf086_24ec,
    0x0dc9_f2aa,
    0xca6c_3773,
    0xa8d1_f272,
    0x3790_3792,
    0x7f33_f212,
    0x0d0b_3749,
    0x8f80_72d7,
    0x4549_77e4,
    0x23a5_12a8,
    0x94b0_6772,
    0xfe4e_ca12,
    0x2d26_4359,
    0xa47f_3804,
    0x43a6_74e6,
    0xc4b4_ca29,
    0x5641_43d9,
    0x812e_b854,
    0xee7f_345e,
    0x20a2_2a56,
    0x7e3a_1391,
    0x3880_0036,
    0xf1c0_000f,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x3000_0000,
    0xa800_0000,
    0x9400_0000,
    0xde00_0000,
    0x1100_0000,
    0xf180_0000,
    0xb8c0_0000,
    0x9520_0000,
    0xad70_0000,
    0x9438_0000,
    0x71d4_0000,
    0x4d8e_0000,
    0x32c5_0000,
    0xfa23_8000,
    0x7df0_c000,
    0x7576_2000,
    0xc831_b000,
    0xabdd_e800,
    0x1a88_8400,
    0xee42_4600,
    0xf962_c900,
    0x9f17_e680,
    0xada3_b9c0,
    0xb83c_2e20,
    0x63da_8df0,
    0x1e83_8088,
    0xa840_c064,
    0xd46e_20d6,
    0x2495_b0b5,
    0xda6b_e887,
    0xcd99_843d,
    0x87ef_c6ba,
    0xa757_0904,
    0xe1c2_4670,
    0xa0a2_c9a4,
    0xf3b7_e66c,
    0x1c13_b91e,
    0xcf24_2eab,
    0x3a7e_8d5a,
    0xe8b5_8094,
    0x4291_c0f2,
    0x0763_a003,
    0x7e10_70a2,
    0x5426_4822,
    0xa4fc_f4bb,
    0x80f2_0ef4,
    0x36ff_3d3b,
    0x13f0_68f4,
    0x0c7d_44a1,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x7000_0000,
    0x8800_0000,
    0x2c00_0000,
    0x6600_0000,
    0x7500_0000,
    0xe380_0000,
    0x2fc0_0000,
    0xbaa0_0000,
    0xeed0_0000,
    0xea98_0000,
    0xf3f4_0000,
    0xd182_0000,
    0x58cd_0000,
    0x0629_8000,
    0x419d_4000,
    0x6174_2000,
    0x47c7_f000,
    0x26a5_0800,
    0x60da_9400,
    0xc390_ee00,
    0xfe79_fb00,
    0xa74d_4e80,
    0x67e3_4bc0,
    0xb23c_66e0,
    0xf22e_2fb0,
    0x5391_8068,
    0xc679_409c,
    0x634e_208e,
    0x5dee_f029,
    0x2936_880d,
    0x48ae_d476,
    0xf9d7_4e3f,
    0x261a_4bb4,
    0xd4b7_e633,
    0x766e_6ff2,
    0x8af4_2061,
    0x8407_f0f5,
    0x9a05_08d5,
    0x8b0a_94b6,
    0x4288_ee58,
    0x0e4d_fb07,
    0xaa6f_4e44,
    0xa4fe_4bfc,
    0xbd0d_e63d,
    0x6f87_6fa8,
    0x59c7_a07a,
    0x37a3_b078,
    0xa95a_a863,
    0x8f5d_24e9,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x9000_0000,
    0xb800_0000,
    0x9c00_0000,
    0xc600_0000,
    0xb500_0000,
    0xab80_0000,
    0x7940_0000,
    0x0c60_0000,
    0x78b0_0000,
    0xe278_0000,
    0xc35c_0000,
    0x6586_0000,
    0x3847_0000,
    0xe5e8_8000,
    0x7efb_4000,
    0x8e96_2000,
    0x4022_f000,
    0x9f53_8800,
    0x438d_7c00,
    0xbd4b_6a00,
    0x6668_9900,
    0x23b5_ca80,
    0xd8f1_2940,
    0x4b90_6220,
    0x63ae_a5d0,
    0x5210_8098,
    0xade7_404c,
    0x2af0_20de,
    0x5c95_f0b9,
    0x8723_08d5,
    0x63da_3c50,
    0x7e43_4a61,
    0x10e1_69b4,
    0x7570_c2c5,
    0x67dc_1582,
    0xf443_a8ab,
    0x7be8_8c53,
    0x67f0_627a,
    0xcb1e_a589,
    0xa868_80f0,
    0x62bb_406f,
    0x3176_2039,
    0x4dd2_f021,
    0x0f4b_88b3,
    0xd161_7cf8,
    0x5735_6a29,
    0x5133_99f3,
    0x043b_4a79,
    0x9fbd_691f,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x7000_0000,
    0xe800_0000,
    0xc400_0000,
    0x3e00_0000,
    0x4700_0000,
    0xf480_0000,
    0x83c0_0000,
    0xdc60_0000,
    0xb5d0_0000,
    0x7498_0000,
    0x3834_0000,
    0x2306_0000,
    0x7a89_0000,
    0x0ccb_8000,
    0x9ce5_c000,
    0xe011_2000,
    0x2bf3_d000,
    0x476c_d800,
    0x935d_0400,
    0x6a57_b200,
    0x19d3_2700,
    0x4e95_1280,
    0x6131_37c0,
    0xe08e_eaa0,
    0xe5c6_e3b0,
    0x9766_0048,
    0xcb59_0074,
    0x6653_80f6,
    0x93d1_c0f3,
    0xdf97_2022,
    0x16ba_d000,
    0xa9c7_5816,
    0xfd68_c471,
    0x0a5e_925c,
    0x89d4_f70e,
    0xf69f_ca0b,
    0x3d35_3337,
    0xf28a_d8fb,
    0x58c4_046e,
    0x1ae4_3207,
    0xfb12_e779,
    0xcd7a_32fd,
    0x79af_e767,
    0xc2b7_b2a7,
    0xefc3_27d5,
    0xc66d_1203,
    0x9cd5_37a9,
    0x5f10_ea1a,
    0x637b_e323,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0xb000_0000,
    0x2800_0000,
    0x1400_0000,
    0x9200_0000,
    0xbd00_0000,
    0xa080_0000,
    0x0e40_0000,
    0x94e0_0000,
    0xe650_0000,
    0x5d98_0000,
    0x33bc_0000,
    0x7d46_0000,
    0x5f65_0000,
    0x5f93_8000,
    0x56b0_c000,
    0x41c6_e000,
    0x672d_b000,
    0xcc79_f800,
    0xb960_bc00,
    0x2094_6200,
    0x733d_af00,
    0x6307_0280,
    0x5385_df40,
    0x85cb_9a20,
    0x8d28_13f0,
    0x5d78_e008,
    0x07e4_b0e4,
    0x3dd4_781a,
    0x7c59_7c19,
    0x049f_021a,
    0x8939_dfa7,
    0x6a0d_9a26,
    0xd10d_1315,
    0x1e8b_6049,
    0xad44_702b,
    0x276a_983c,
    0x7398_cc2e,
    0x48b8_fac5,
    0x52c0_6393,
    0xfcac_78d1,
    0x4db5_7c9d,
    0x3e41_0246,
    0xfce0_dfd0,
    0x5258_1acc,
    0x7f98_d32c,
    0xa6be_001d,
    0xc9c9_00b8,
    0xc32d_80cc,
    0x7679_c00e,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0xf000_0000,
    0x6800_0000,
    0xb400_0000,
    0xfa00_0000,
    0xcf00_0000,
    0xb980_0000,
    0x67c0_0000,
    0x2760_0000,
    0x3d70_0000,
    0xf838_0000,
    0xeb1c_0000,
    0x61c6_0000,
    0x1661_0000,
    0x79f3_8000,
    0xad7a_c000,
    0x803e_6000,
    0x671e_1000,
    0xb7c1_c800,
    0xff66_9400,
    0x4177_5200,
    0x4632_bd00,
    0xb61c_b280,
    0xa347_6d40,
    0x3228_9a20,
    0xf659_29b0,
    0x0ee6_6048,
    0x22b2_1004,
    0x535f_c832,
    0x006b_948b,
    0x70fa_d22b,
    0xc5f5_7d1c,
    0xf377_52e4,
    0x8d32_bdd5,
    0x3d9c_b246,
    0x4f87_6d01,
    0x3ec8_9af6,
    0xd7e9_29c4,
    0x923e_6052,
    0x5c1e_109b,
    0x5441_c813,
    0xa7a6_9430,
    0xb797_5242,
    0xa882_bd14,
    0x9344_b26a,
    0xba2b_6de0,
    0x1256_9a67,
    0x6ce4_290d,
    0x31b3_e04a,
    0xa4d9_d07a,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x5000_0000,
    0xc800_0000,
    0xec00_0000,
    0x4200_0000,
    0x1f00_0000,
    0x7780_0000,
    0xe5c0_0000,
    0xe860_0000,
    0xa950_0000,
    0x7018_0000,
    0x9c34_0000,
    0x71c2_0000,
    0x1e6f_0000,
    0xb05f_8000,
    0xe69f_4000,
    0x9b72_6000,
    0xf8e9_1000,
    0x8f1d_a800,
    0x7bbf_5400,
    0x3c04_e200,
    0x4a06_2f00,
    0x930b_0280,
    0x658f_7fc0,
    0x32c3_4ae0,
    0x73e2_7b90,
    0x0e92_6028,
    0x8779_107c,
    0x42e5_a8ea,
    0xe41b_54a3,
    0x6a3e_e2fd,
    0x68cd_2f16,
    0x88ee_825d,
    0xb71b_3f93,
    0x6fb4_aa0f,
    0x0a0f_2b40,
    0x3300_28c1,
    0x558f_1457,
    0xaac9_025b,
    0x57e0_7fc7,
    0xa09c_ca27,
    0xda7d_3bd6,
    0x2a60_0099,
    0x7650_00a6,
    0x6798_006f,
    0x29f4_00a5,
    0x51a2_0043,
    0x5b3f_008c,
    0x8247_8019,
    0x65ab_40c2,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0xd000_0000,
    0xd800_0000,
    0xf400_0000,
    0x2e00_0000,
    0x7300_0000,
    0x1e80_0000,
    0x6740_0000,
    0x9f60_0000,
    0xde70_0000,
    0x7ab8_0000,
    0x2f14_0000,
    0xb7ce_0000,
    0x3b2b_0000,
    0xf79a_8000,
    0x3f87_c000,
    0xc8cc_2000,
    0xefa0_9000,
    0xb5d9_3800,
    0xe965_2c00,
    0x997d_2a00,
    0xea32_8500,
    0xeb5d_8a80,
    0xee2a_d5c0,
    0x761c_1220,
    0x3c43_a910,
    0xbdee_a0f8,
    0x1b33_50e4,
    0x9cdb_1856,
    0x6aee_bc57,
    0x33be_92e8,
    0xdc90_69e0,
    0x150c_802f,
    0x2188_c00a,
    0xd3c0_a05b,
    0xad28_5046,
    0x0099_988a,
    0x070d_7c3e,
    0xf084_b214,
    0xb44f_f958,
    0x51e1_3816,
    0x6131_2c4c,
    0x11d3_2ab5,
    0xdf69_8537,
    0xbe7f_0ac6,
    0x0ab9_15f7,
    0x271e_327e,
    0x9bc8_39b5,
    0xe12d_1815,
    0xaa91_bc84,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0xf000_0000,
    0x2800_0000,
    0xec00_0000,
    0xca00_0000,
    0x5100_0000,
    0x1780_0000,
    0xf1c0_0000,
    0x6520_0000,
    0xc750_0000,
    0xd218_0000,
    0xcc74_0000,
    0x524a_0000,
    0x5aed_0000,
    0x3573_8000,
    0x69cb_4000,
    0x812c_e000,
    0xf159_7000,
    0x911f_c800,
    0x4efd_f400,
    0x920c_f600,
    0x5504_9b00,
    0xd181_9680,
    0x9acf_abc0,
    0x0bab_3e60,
    0xcd1d_6f30,
    0x8cff_6048,
    0x3f02_30dc,
    0x508b_2802,
    0xb540_844d,
    0xce61_3ef5,
    0xa630_6f4c,
    0x3cac_e038,
    0x6199_70a7,
    0x2bbf_c840,
    0x646d_f40a,
    0xc734_f6cd,
    0xe320_9bbd,
    0x8c53_96ff,
    0xac96_ab6e,
    0x1e32_be91,
    0xc8ab_2f03,
    0x8f98_0008,
    0xacb4_00cd,
    0xc0ea_0052,
    0x9c7d_006b,
    0xaa4b_8075,
    0x8eef_4097,
    0xcb7e_e0c5,
    0x36c0_700c,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0xb000_0000,
    0xf800_0000,
    0x3c00_0000,
    0x4e00_0000,
    0x1900_0000,
    0x5680_0000,
    0x7e40_0000,
    0x6520_0000,
    0xa750_0000,
    0xe278_0000,
    0xb52c_0000,
    0x0f5e_0000,
    0x3679_0000,
    0x8f28_8000,
    0x9c52_4000,
    0x0bfe_2000,
    0xf0ed_f000,
    0xc8b6_b800,
    0xe14c_ac00,
    0xaea4_4600,
    0x5d9e_9f00,
    0x1e12_fe80,
    0xc0d2_3340,
    0x5eb6_b820,
    0x344c_acf0,
    0xee24_4658,
    0xb6de_9f8c,
    0x9bb2_fe36,
    0x3cc2_3365,
    0xc16e_b838,
    0x4170_ac97,
    0x30a2_466b,
    0xec9b_9f55,
    0x9c9c_7eb1,
    0x8495_7377,
    0xa89e_18d5,
    0xae9a_1c14,
    0x739c_5eeb,
    0x5711_83ff,
    0x7e58_2035,
    0x54f8_f01b,
    0xdb60_3896,
    0x2277_ec45,
    0x552a_e62d,
    0x1f5d_2ff3,
    0x7e7c_667d,
    0x4b26_6fba,
    0xee52_c618,
    0x5cf5_dfe8,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x9000_0000,
    0x9800_0000,
    0x3400_0000,
    0xbe00_0000,
    0x5900_0000,
    0xff80_0000,
    0x1fc0_0000,
    0xae60_0000,
    0xb770_0000,
    0x0118_0000,
    0xc26c_0000,
    0xdd7e_0000,
    0xd61b_0000,
    0x6cec_8000,
    0x9134_c000,
    0xedb3_a000,
    0x92f2_f000,
    0x81d6_a800,
    0xce89_a400,
    0x3c4b_ea00,
    0x93a2_3900,
    0xc21d_4280,
    0x02eb_9d40,
    0xf036_a820,
    0xb639_a4d0,
    0xab33_ea38,
    0x42be_39a4,
    0x387b_42a6,
    0x7b9c_9d2d,
    0x0024_2861,
    0xb7d6_6496,
    0x7b8c_ca69,
    0xe9c8_090c,
    0xfb66_4a09,
    0x52fb_c958,
    0x61df_6abd,
    0xfe8a_f982,
    0x3448_e258,
    0x3fae_6d0b,
    0x4812_8028,
    0xe5ef_c0cb,
    0x56bf_20c9,
    0x5676_30aa,
    0x1a9d_087b,
    0x5ba7_54df,
    0x8e1b_4291,
    0xb8ec_9da1,
    0x1f3c_2853,
    0xbcba_6414,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x5000_0000,
    0xf800_0000,
    0xb400_0000,
    0x1200_0000,
    0x3900_0000,
    0x2d80_0000,
    0x4bc0_0000,
    0xa1e0_0000,
    0xc8f0_0000,
    0xf118_0000,
    0x3dec_0000,
    0xd6fe_0000,
    0xce17_0000,
    0x6b66_8000,
    0x71ba_c000,
    0xbdbd_6000,
    0x5bb4_3000,
    0xd0b3_8800,
    0x943f_0400,
    0x0a70_9200,
    0x5450_1900,
    0x2f43_1a80,
    0x2faf_1d40,
    0xced3_8820,
    0x6e0f_0410,
    0xd708_9258,
    0xba8c_19e4,
    0x5145_1a6a,
    0xa0a4_1dcd,
    0x9053_081f,
    0xd54e_c462,
    0xfaad_72d4,
    0x1555_e967,
    0xf6cd_723a,
    0xd665_e938,
    0x0635_7238,
    0x7379_e991,
    0xd9d3_72e9,
    0x3482_e998,
    0x764b_f24c,
    0xb22f_2942,
    0x8d10_12ad,
    0xd3e1_d9ea,
    0x41fe_fa21,
    0xd49a_ed61,
    0x6a25_e044,
    0x2919_f072,
    0x99e8_686d,
    0x9cf1_f423,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x3000_0000,
    0x9800_0000,
    0x3c00_0000,
    0xe200_0000,
    0xbb00_0000,
    0x6c80_0000,
    0x7a40_0000,
    0xa0a0_0000,
    0x70b0_0000,
    0xcc18_0000,
    0xcea4_0000,
    0x71ba_0000,
    0x479d_0000,
    0x0a6e_8000,
    0x8850_4000,
    0xc700_e000,
    0x2e83_1000,
    0x9141_3800,
    0x642f_8c00,
    0xaef1_be00,
    0xb2bb_b900,
    0xe710_8680,
    0x6a24_35c0,
    0x9ff9_38e0,
    0xa13b_8cf0,
    0x1fd3_bef8,
    0x71c2_b90c,
    0xa464_06fa,
    0xe959_7547,
    0x7c8f_586e,
    0x724c_dc31,
    0x54a8_6634,
    0x06b3_2506,
    0x311a_0096,
    0xc72d_00f9,
    0x3e76_8053,
    0x4af4_4078,
    0xccba_e02f,
    0xee1e_10f9,
    0x15af_b843,
    0x2d3f_cca3,
    0xa5d1_5e87,
    0x96c8_a9b9,
    0x1ae9_be64,
    0xb01f_b9a9,
    0x8caa_86a8,
    0x9ab9_3540,
    0x8317_b827,
    0xd42b_cc0a,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x1000_0000,
    0x6800_0000,
    0x7400_0000,
    0x7200_0000,
    0x8b00_0000,
    0x7f80_0000,
    0x3140_0000,
    0x4320_0000,
    0x8870_0000,
    0x4958_0000,
    0x722c_0000,
    0x38f2_0000,
    0x6d9f_0000,
    0x874b_8000,
    0xe223_c000,
    0x10f7_6000,
    0x7990_1000,
    0xe542_8800,
    0x0126_8c00,
    0x1b7f_b600,
    0x3adc_7d00,
    0x2d65_3e80,
    0xf6d6_f140,
    0x6368_88e0,
    0x0bd5_8c50,
    0x9de6_3608,
    0xd210_bd64,
    0x9601_de9a,
    0xd109_21bf,
    0xe08f_60ed,
    0x2ccc_10ea,
    0x9168_8834,
    0xc0d5_8cdd,
    0x8266_3610,
    0xf350_bd05,
    0xbd21_defc,
    0x2d79_21e5,
    0xdbd7_6063,
    0xd5e0_1066,
    0xd61a_8895,
    0x9c0a_8c05,
    0x460d_b69e,
    0x9903_7d98,
    0xe48e_becc,
    0x26c5_314e,
    0x0667_e87d,
    0xb959_9cbe,
    0x4a2e_beb9,
    0x44f5_311b,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0xf000_0000,
    0x5800_0000,
    0x1c00_0000,
    0x6a00_0000,
    0xff00_0000,
    0xe980_0000,
    0x0240_0000,
    0x5ea0_0000,
    0xc5f0_0000,
    0x0458_0000,
    0x3824_0000,
    0xb63e_0000,
    0x64b5_0000,
    0x397e_8000,
    0xd092_4000,
    0xad4e_6000,
    0xdf2d_d000,
    0xa3b8_2800,
    0xdcfb_5c00,
    0x30dc_de00,
    0xb8e9_bd00,
    0xdd5a_f680,
    0x2ca7_e1c0,
    0xc6f8_a8a0,
    0x57dc_1c30,
    0x6d6c_3e78,
    0x4516_2dec,
    0xd50c_beb2,
    0xf681_6d23,
    0x3bc4_5e23,
    0xf4ea_fdcd,
    0xdf54_164f,
    0xb7ad_71eb,
    0xa970_60c8,
    0x9898_d02e,
    0x3946_a849,
    0x0129_1c4d,
    0x72b2_be0a,
    0xbc74_6d90,
    0x4e1a_decd,
    0xf288_bdcf,
    0xadc2_76ab,
    0xb1e4_a1a8,
    0x61d6_48be,
    0x1866_8c01,
    0x839c_f6d9,
    0x96c6_e1d4,
    0xee60_28c1,
    0xd69f_5ced,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0xf000_0000,
    0xa800_0000,
    0x3400_0000,
    0x1200_0000,
    0xbd00_0000,
    0xb380_0000,
    0x50c0_0000,
    0x0620_0000,
    0x14d0_0000,
    0xd7f8_0000,
    0xbca4_0000,
    0x259a_0000,
    0x5c11_0000,
    0xedd1_8000,
    0x1e7b_c000,
    0x056f_6000,
    0x7235_7000,
    0x0d08_2800,
    0xbb85_d400,
    0xf4c0_5e00,
    0x4c2c_a700,
    0x35d2_7680,
    0x4278_73c0,
    0x4363_a8e0,
    0x2d3f_1430,
    0xab86_bec8,
    0x6cc6_17c4,
    0xb02f_3e3a,
    0xe3d9_d749,
    0x457a_5e41,
    0x79ed_a7dd,
    0xdc7b_f6fd,
    0x4067_b340,
    0xcdb6_c88b,
    0x23cb_6411,
    0x8ea7_169b,
    0xc89c_03c9,
    0xd79a_0047,
    0xd111_004f,
    0x9651_80f8,
    0x8abb_c0d9,
    0xb94f_60e7,
    0xefe5_7059,
    0x7b70_28f2,
    0xeae1_d4a0,
    0x64fa_5e68,
    0x542d_a7d2,
    0x09db_f630,
    0xf477_b330,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0xb000_0000,
    0x3800_0000,
    0x9400_0000,
    0x2a00_0000,
    0x7700_0000,
    0xc880_0000,
    0x2740_0000,
    0xcf60_0000,
    0x42d0_0000,
    0x0eb8_0000,
    0xdee4_0000,
    0x5812_0000,
    0xa51d_0000,
    0x8a9c_8000,
    0x0d50_c000,
    0xf97a_e000,
    0xf2c7_5000,
    0x77a8_3800,
    0x3273_9c00,
    0x2c42_9200,
    0xf1e7_4300,
    0x7498_aa80,
    0x7059_dfc0,
    0x16fe_b860,
    0x950a_5c70,
    0x338e_f2d8,
    0x01c9_d324,
    0x3d24_f292,
    0x9e30_d323,
    0x1daa_7282,
    0x657d_1320,
    0xb4cc_125f,
    0x5eaa_8381,
    0x17fe_cab3,
    0x8c8e_4f0f,
    0x454c_60ec,
    0xf46e_90cf,
    0x845c_5827,
    0x4cf9_0c9e,
    0x3a0c_ca68,
    0xdf03_4fa7,
    0x3488_e075,
    0x114a_5069,
    0x3e6c_b860,
    0x4357_5c60,
    0xbc72_728a,
    0x8949_13d3,
    0x3a66_129a,
    0x0153_83e4,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x7000_0000,
    0x8800_0000,
    0x8400_0000,
    0xe600_0000,
    0xe500_0000,
    0x4a80_0000,
    0x25c0_0000,
    0xfd60_0000,
    0x1170_0000,
    0xb518_0000,
    0xe4ec_0000,
    0x233e_0000,
    0x8b35_0000,
    0x3f33_8000,
    0xf136_c000,
    0xe037_2000,
    0xc4b9_b000,
    0x807b_3800,
    0xd199_5400,
    0x002c_7a00,
    0x02d3_9900,
    0xd289_4280,
    0xb9cf_cd40,
    0xc76e_b820,
    0x6e76_9430,
    0xf096_da28,
    0x0ca9_e9f4,
    0xb216_daee,
    0xed69_e921,
    0x0976_da8c,
    0x6919_e9f0,
    0x7eee_da1f,
    0x2c35_e980,
    0x46b0_da06,
    0x5370_e9a4,
    0x861b_5a92,
    0x636a_291b,
    0xb872_7ae5,
    0x3d96_991f,
    0xb222_c293,
    0xf9d5_0db4,
    0x7107_980f,
    0xb48a_241f,
    0x1cc6_6250,
    0x2dea_7d68,
    0x3bb3_80c2,
    0x85f6_c0f4,
    0x99d7_202d,
    0xe109_b0fd,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0xf000_0000,
    0x2800_0000,
    0xc400_0000,
    0x9a00_0000,
    0x9b00_0000,
    0xbf80_0000,
    0x6040_0000,
    0xf820_0000,
    0x3b10_0000,
    0xe238_0000,
    0x4dac_0000,
    0xf85e_0000,
    0x199d_0000,
    0x90f1_8000,
    0x0f48_c000,
    0x15a4_e000,
    0x5457_9000,
    0xe79b_8800,
    0x61f6_9c00,
    0x03c3_d600,
    0x0e66_db00,
    0x563e_5e80,
    0xbfa1_4740,
    0x0752_0820,
    0xcc12_5cb0,
    0x43b9_3688,
    0x8cec_4b34,
    0xd4f4_5632,
    0xd54f_1b1f,
    0x2ead_3e05,
    0x1bdf_174b,
    0xafda_e04f,
    0x5dda_902f,
    0xa2d2_0808,
    0x7752_5cd9,
    0xa419_3617,
    0x27bc_4b6b,
    0xe6ec_5635,
    0x67f3_1b96,
    0xaecb_3e00,
    0xd4ee_17fd,
    0x78f5_6018,
    0x2b4f_502e,
    0xdfa7_687c,
    0x175d_0c9b,
    0xb41e_5e25,
    0x5fb1_47cc,
    0xfaea_086e,
    0x11fe_5cc9,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x3000_0000,
    0x3800_0000,
    0xdc00_0000,
    0xaa00_0000,
    0x2900_0000,
    0xb280_0000,
    0x83c0_0000,
    0xd660_0000,
    0x6530_0000,
    0x8058_0000,
    0x86e4_0000,
    0x0bf2_0000,
    0x42b5_0000,
    0xeb14_8000,
    0x2244_4000,
    0xe626_6000,
    0xb616_b000,
    0xcecc_f800,
    0xd2eb_f400,
    0x85fe_aa00,
    0xfdb3_2d00,
    0xea98_5280,
    0x0209_d9c0,
    0xdd00_7860,
    0x2c8b_b4f0,
    0xd4ca_cad8,
    0x03e0_9dec,
    0x0b78_2a12,
    0xe472_6d35,
    0x2df2_b278,
    0x09bf_295a,
    0x7498_e03c,
    0x5503_f0ca,
    0x088c_1824,
    0x42cc_0426,
    0xb0e0_b2ab,
    0xa8fa_29b2,
    0x0934_60ae,
    0xd253_b06f,
    0x93e0_7809,
    0x237b_b4c4,
    0xd072_ca4d,
    0x53f4_9d19,
    0x6eb2_2a01,
    0x9913_6d20,
    0xe74c_32bb,
    0xc6aa_695a,
    0xc0d8_007a,
    0x0024_0021,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x1000_0000,
    0xa800_0000,
    0xb400_0000,
    0xe600_0000,
    0x1500_0000,
    0x6380_0000,
    0xf1c0_0000,
    0xc5a0_0000,
    0xedf0_0000,
    0x6b58_0000,
    0x682c_0000,
    0xfd32_0000,
    0x4b7f_0000,
    0x7117_8000,
    0x984b_c000,
    0x8b66_2000,
    0xc4d2_b000,
    0x43ef_a800,
    0x0f92_8400,
    0x8e09_3600,
    0x810e_8d00,
    0xf58c_9e80,
    0x5ccf_0940,
    0xba20_28e0,
    0x4e35_4450,
    0x5dfd_16c8,
    0xf353_3da4,
    0x042c_b6ce,
    0x173a_4de1,
    0xa47d_3e65,
    0x5596_79b4,
    0xf909_a0ee,
    0xc985_70f8,
    0x7ec3_8880,
    0xf123_3434,
    0x24bb_1ebb,
    0x9db4_c973,
    0x343e_084c,
    0x5afb_f49a,
    0x03d8_be57,
    0x9362_b938,
    0xe8d8_00b3,
    0xc9ec_00f1,
    0xf092_00ac,
    0x028f_0030,
    0x544f_80b7,
    0x5167_c08f,
    0xf3d4_20d5,
    0x6b6d_b0b9,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x7000_0000,
    0xa800_0000,
    0x9c00_0000,
    0xea00_0000,
    0xbf00_0000,
    0x5480_0000,
    0x1240_0000,
    0x33a0_0000,
    0xd590_0000,
    0x4738_0000,
    0x2f2c_0000,
    0x6bd2_0000,
    0x5699_0000,
    0xa9b1_8000,
    0x3a69_4000,
    0x48f2_6000,
    0x4f46_d000,
    0x142e_f800,
    0xc15f_8c00,
    0x9dd1_8e00,
    0x4398_fb00,
    0x2235_7680,
    0x0ca2_7740,
    0xc11f_78e0,
    0x3576_cc30,
    0x6c83_eec8,
    0x164e_2bec,
    0x8da3_8ec2,
    0x6c91_fb63,
    0xeebc_f65e,
    0x4ae7_379d,
    0xf4bf_182f,
    0x1de9_1c6b,
    0x5c3c_9656,
    0x95a8_e7a9,
    0x7898_60ba,
    0x88b3_d008,
    0xc7ed_782f,
    0x2b3f_cc64,
    0x2d2a_6e69,
    0x28db_6b01,
    0x981b_ee29,
    0xacf2_2bdd,
    0xc149_8eb8,
    0x6524_fbe3,
    0x84df_764e,
    0xba17_7715,
    0xfffc_f8f3,
    0xd7c6_8cb1,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xd000_0000,
    0x0800_0000,
    0x7c00_0000,
    0x7200_0000,
    0xc300_0000,
    0x7380_0000,
    0x5040_0000,
    0x2de0_0000,
    0x4030_0000,
    0xfe58_0000,
    0x5e2c_0000,
    0x7596_0000,
    0xcf87_0000,
    0x4249_8000,
    0x1ee5_4000,
    0xebbd_e000,
    0xda13_9000,
    0x7dc0_c800,
    0x84a3_1c00,
    0x8154_ea00,
    0x3fa4_6500,
    0x16dd_a280,
    0x49e2_3940,
    0x2634_a8a0,
    0xc355_cc90,
    0x44a9_c228,
    0xe154_e9ac,
    0xcfa9_80fa,
    0xced5_40ff,
    0x3de5_e021,
    0x283f_9043,
    0x7256_c856,
    0xf424_1c6c,
    0xc29d_6aa1,
    0xb201_25dd,
    0xa300_4278,
    0x8381_a981,
    0x884c_60ba,
    0x59ea_d001,
    0x4e33_287f,
    0x4f5b_8c36,
    0xeeab_a299,
    0x5655_392e,
    0xb225_283f,
    0x2f9c_8c76,
    0xa082_2202,
    0x4bc0_796c,
    0xf1a0_c816,
    0xc7d3_1c2c,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x3000_0000,
    0x5800_0000,
    0x7400_0000,
    0x5e00_0000,
    0xa100_0000,
    0x2380_0000,
    0x68c0_0000,
    0xd720_0000,
    0x1b50_0000,
    0xdbf8_0000,
    0xd664_0000,
    0xabb2_0000,
    0x2d05_0000,
    0x198a_8000,
    0x1fcc_c000,
    0x49a1_a000,
    0x221a_7000,
    0xef17_6800,
    0xc695_5400,
    0x815b_ee00,
    0xbcf7_ff00,
    0xc0e6_0680,
    0x8efe_6bc0,
    0x6be4_4860,
    0x8277_e4f0,
    0xe9a7_26b8,
    0x3219_db44,
    0x6712_0086,
    0xda95_0015,
    0xf352_809d,
    0x37f8_c0f9,
    0x1c6b_a0ac,
    0x64bb_7007,
    0xf78f_e852,
    0x26cc_946c,
    0xfe28_ce53,
    0x24d5_4f93,
    0xc13a_cee5,
    0x8a40_4fe9,
    0x6c68_4eeb,
    0x1cb8_8f1b,
    0x5383_ee35,
    0x10c3_ff4d,
    0x732c_0611,
    0x2d5f_6b40,
    0x56fc_c84d,
    0xdfee_245d,
    0x3c74_0656,
    0x78ab_6b5c,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x3000_0000,
    0x5800_0000,
    0x2400_0000,
    0x5600_0000,
    0x4100_0000,
    0x4e80_0000,
    0x0040_0000,
    0xe760_0000,
    0x3370_0000,
    0x0c98_0000,
    0xdeac_0000,
    0xabda_0000,
    0x2e45_0000,
    0x1262_8000,
    0xa3f9_c000,
    0x01dc_2000,
    0x5d48_f000,
    0xabe8_b800,
    0x9c3c_8c00,
    0xf074_e200,
    0xad12_6900,
    0x2566_da80,
    0x3c7b_2540,
    0xc714_1860,
    0xf664_bc70,
    0x55f8_fab8,
    0x90da_d514,
    0x7bc4_208e,
    0xd7a4_f025,
    0x0952_b8f8,
    0xd409_8c71,
    0xae0e_62f1,
    0xb507_a917,
    0x7080_fa3d,
    0x3d46_d5ec,
    0xdbe6_2089,
    0x243d_f080,
    0xe472_38e6,
    0xa319_4caa,
    0x406a_c211,
    0x24f3_9945,
    0x8656_e299,
    0x5f8b_69ee,
    0x66c6_5a80,
    0x7b2b_e5d1,
    0x9610_b807,
    0x70e0_8c75,
    0xf9b6_e200,
    0x6dbb_69f3,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x5000_0000,
    0xa800_0000,
    0x3c00_0000,
    0x3e00_0000,
    0x6500_0000,
    0x9280_0000,
    0x4ac0_0000,
    0x0fe0_0000,
    0x5290_0000,
    0xd9f8_0000,
    0xd8ac_0000,
    0x8236_0000,
    0x77cf_0000,
    0x196b_8000,
    0x925b_4000,
    0xe11d_2000,
    0xebb3_3000,
    0xda82_b800,
    0x46cd_6400,
    0xe9ef_8200,
    0xf390_bf00,
    0xe17e_ba80,
    0xf56a_9b40,
    0x445a_18a0,
    0x9816_1410,
    0x1735_9a88,
    0x5d46_ab6c,
    0xe7ab_2016,
    0xcfbc_3019,
    0x4089_388c,
    0xf9c6_247f,
    0xe46a_a235,
    0xe4df_8f24,
    0x51d2_0268,
    0x2b54_ffaf,
    0x7d90_1a69,
    0x1c7e_ebf5,
    0x83eb_809c,
    0xf49b_409b,
    0x58fd_2097,
    0xb023_30a8,
    0x07fa_b8bd,
    0x8da1_64c9,
    0xc8b9_8289,
    0xf90f_bf5a,
    0xbc8d_3a2d,
    0xa7cd_db6d,
    0xf169_388b,
    0x8e56_24c6,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x1000_0000,
    0xd800_0000,
    0x0400_0000,
    0x1600_0000,
    0xe500_0000,
    0x7880_0000,
    0xb040_0000,
    0x0560_0000,
    0x5c30_0000,
    0x3fd8_0000,
    0x4aac_0000,
    0xea9a_0000,
    0x7747_0000,
    0xe6e8_8000,
    0x5df3_c000,
    0x2878_2000,
    0x8cbe_b000,
    0x039b_9800,
    0x65ce_ec00,
    0x51a3_8200,
    0x1b10_dd00,
    0x8588_9a80,
    0x6cc1_f140,
    0x5329_3860,
    0x7458_9c50,
    0xc76a_ba38,
    0xd738_4114,
    0x565a_204e,
    0x5c65_b0a1,
    0x66b1_188e,
    0x4496_2c45,
    0xc649_22a5,
    0xb06a_ade8,
    0x1cbb_a2ac,
    0x9b9e_6db3,
    0x81cb_02cd,
    0x57a3_1ddd,
    0x2610_bab1,
    0xf90f_4122,
    0xca8a_a05f,
    0xb34a_702a,
    0x50eb_3897,
    0x48f3_9cdf,
    0x98f8_3a07,
    0xe0fc_812e,
    0x14f2_8028,
    0xcaf4_c0f8,
    0xf3f0_a09d,
    0x997d_70bc,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x1000_0000,
    0x2800_0000,
    0x3c00_0000,
    0x9200_0000,
    0xb700_0000,
    0x6080_0000,
    0x0dc0_0000,
    0xa820_0000,
    0x0310_0000,
    0x2db8_0000,
    0xea64_0000,
    0xe272_0000,
    0xfd47_0000,
    0x4def_8000,
    0x773f_4000,
    0xaca3_e000,
    0x58dc_d000,
    0x5498_b800,
    0x80fa_f400,
    0xaf89_ae00,
    0x594c_7b00,
    0xfbe6_9680,
    0xb63d_cfc0,
    0xed26_d860,
    0x049e_64d0,
    0x88fd_76c8,
    0x6385_1f2c,
    0xf34c_603a,
    0x58e3_904b,
    0x78bb_5812,
    0xc5e6_24aa,
    0x7b31_16e0,
    0xe6a6_8f32,
    0xebd7_3897,
    0xb215_b49e,
    0x9432_4e4f,
    0x4224_ab0a,
    0x8014_2eaf,
    0x1334_3b75,
    0xfaaa_f63e,
    0x89de_5fa2,
    0x3d1d_8032,
    0xe0b8_40c4,
    0xe1ec_6044,
    0x0d33_9036,
    0xc7a3_580f,
    0xba52_24db,
    0xc65b_16fa,
    0x7455_8f76,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x3000_0000,
    0x9800_0000,
    0x0c00_0000,
    0x6e00_0000,
    0x1500_0000,
    0x5480_0000,
    0xa5c0_0000,
    0xd160_0000,
    0x0890_0000,
    0x7878_0000,
    0x71a4_0000,
    0x857a_0000,
    0x112d_0000,
    0x12b6_8000,
    0x1347_4000,
    0xcfa9_2000,
    0xf878_3000,
    0xb1af_d800,
    0xe57c_7400,
    0x2128_da00,
    0x8ab1_3700,
    0x1f4b_8280,
    0xa1a7_03c0,
    0xed7c_f8e0,
    0xe529_44f0,
    0x40b1_82f8,
    0xf04a_033c,
    0x822a_7876,
    0x673e_04d9,
    0xd000_a25a,
    0x6806_3380,
    0xf407_a09d,
    0x520b_7061,
    0xe304_f8a7,
    0x4d8d_445c,
    0x9f4b_8231,
    0x61a7_03c9,
    0x8d7c_f8a8,
    0xd529_44df,
    0xd8b1_8291,
    0xfc4a_030f,
    0xec2a_7832,
    0x723e_04c8,
    0x8480_a2f4,
    0xcdc6_3328,
    0x2567_a038,
    0x5a9b_70ab,
    0x9b7c_f88e,
    0x3c29_449f,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xd000_0000,
    0x3800_0000,
    0x5400_0000,
    0x8a00_0000,
    0x4300_0000,
    0xba80_0000,
    0xf140_0000,
    0x9f20_0000,
    0x8e70_0000,
    0xb8d8_0000,
    0x056c_0000,
    0xa7d6_0000,
    0xe9e7_0000,
    0x039a_8000,
    0xb94c_c000,
    0x6324_e000,
    0x487d_1000,
    0xf5df_d800,
    0x4ee3_9c00,
    0xfb11_9600,
    0xb705_1d00,
    0xa082_ce80,
    0xaa4d_4140,
    0xa1ad_38a0,
    0xcd39_8c90,
    0x30f4_ce18,
    0xbb9a_4184,
    0xad4f_b832,
    0xc929_4c57,
    0xdb7e_2e10,
    0x775c_5162,
    0xeba4_e09d,
    0xee3d_106b,
    0x7a7f_d88d,
    0xa2d3_9c18,
    0x5e69_969d,
    0x9959_1d49,
    0xaaac_ce31,
    0x8bb6_41dd,
    0x07b9_b8c2,
    0x69be_4c95,
    0x68bc_aeb6,
    0x2d3c_91e5,
    0x80f6_0087,
    0x7397_0012,
    0x1142_808f,
    0x2f20_c0de,
    0x4672_e0ea,
    0x04da_10bb,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x7000_0000,
    0xa800_0000,
    0x5c00_0000,
    0x2200_0000,
    0x2b00_0000,
    0xaa80_0000,
    0xd340_0000,
    0x3a20_0000,
    0xd1b0_0000,
    0xf0d8_0000,
    0x774c_0000,
    0x3c2a_0000,
    0xbcb9_0000,
    0xd755_8000,
    0xf383_4000,
    0x2acd_e000,
    0x27e9_9000,
    0x9ed5_9800,
    0xe640_dc00,
    0xa9ad_7600,
    0xcb70_2900,
    0x9f35_0e80,
    0xc599_6540,
    0x506d_e060,
    0x6219_9030,
    0x94ad_9848,
    0x94fc_dc2c,
    0x7fff_768a,
    0x7575_2977,
    0x3632_8e08,
    0xd41f_25b8,
    0xf1a7_80f0,
    0x7f76_4032,
    0x0132_6082,
    0xbc93_d08a,
    0x79ed_f846,
    0x47da_0cbc,
    0x5fcd_0e63,
    0x5465_65b7,
    0xf41f_e0ed,
    0x21ac_9096,
    0x4772_189e,
    0x8536_9c17,
    0x6a9f_1653,
    0x2ce3_f9ba,
    0xe458_f67f,
    0x0d03_692a,
    0x1780_eef8,
    0xcccc_f590,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x5000_0000,
    0xc800_0000,
    0x1400_0000,
    0xa200_0000,
    0x6500_0000,
    0x7480_0000,
    0x22c0_0000,
    0x2ce0_0000,
    0x8090_0000,
    0x96b8_0000,
    0x26c4_0000,
    0x26e6_0000,
    0x019f_0000,
    0xd831_8000,
    0xbd09_c000,
    0xc88d_6000,
    0x64c3_7000,
    0x73e8_9800,
    0x4d18_a400,
    0x76f3_8200,
    0xefe2_b700,
    0x9b16_7a80,
    0x41f9_63c0,
    0x666d_6020,
    0x1153_7090,
    0xf9d0_9868,
    0x0d1c_a444,
    0x16f5_826a,
    0x1fed_b771,
    0x031f_fa56,
    0x9df4_a387,
    0xd066_0078,
    0xd65f_0032,
    0xe851_80d2,
    0x5b59_c0e2,
    0x18d5_60da,
    0xb397_7056,
    0x1536_9828,
    0x2d83_a4fb,
    0xd044_0248,
    0xf124_777b,
    0x31f2_9a81,
    0x3e67_d34f,
    0x6d56_9895,
    0x1fd3_a415,
    0x021c_027b,
    0x1370_7756,
    0xebac_9a07,
    0x683c_d338,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0xb000_0000,
    0x7800_0000,
    0x9c00_0000,
    0x6e00_0000,
    0x0300_0000,
    0xeb80_0000,
    0xbf40_0000,
    0x8ee0_0000,
    0xf650_0000,
    0x4bf8_0000,
    0xb54c_0000,
    0x3fe2_0000,
    0x10dd_0000,
    0xac34_8000,
    0x1762_4000,
    0x641d_2000,
    0x4d93_d000,
    0xa7de_0800,
    0x3db1_0c00,
    0x412d_3a00,
    0x407f_db00,
    0xfa0e_1280,
    0xa90d_0740,
    0xca85_20e0,
    0xf1cf_d0f0,
    0x3d24_0818,
    0xde70_0c2c,
    0xe103_ba16,
    0x6e8c_9b9f,
    0x63c5_b205,
    0xe021_97fc,
    0x4ef2_8885,
    0x29cf_4cb9,
    0x312a_1add,
    0x187d_0b6f,
    0xb606_9ae2,
    0x0f03_4b7a,
    0x2d81_baf6,
    0xe841_9b4b,
    0xef69_3235,
    0xb81f_d77f,
    0x4395_a8f0,
    0x14dd_9c5c,
    0xae3a_920f,
    0x626f_4748,
    0xa098_00db,
    0x0f5c_0078,
    0x097a_00d8,
    0xc081_004d,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0xf000_0000,
    0x4800_0000,
    0xe400_0000,
    0xa200_0000,
    0x4f00_0000,
    0x6b80_0000,
    0x6c40_0000,
    0x29a0_0000,
    0xf0f0_0000,
    0x7718_0000,
    0x514c_0000,
    0x152a_0000,
    0x4b31_0000,
    0xccf3_8000,
    0xc916_c000,
    0xf046_6000,
    0x87ab_d000,
    0xe9f7_c800,
    0x499d_bc00,
    0xb588_be00,
    0x7d47_0500,
    0x1321_1680,
    0x463d_6940,
    0x1874_6060,
    0x86d6_d0b0,
    0x51ae_48a8,
    0xfcfa_7c14,
    0x211d_5eea,
    0x044a_15ab,
    0x9da8_be49,
    0x0af7_0563,
    0x6419_1622,
    0x34c1_692c,
    0x7066_6076,
    0xe41b_d0f5,
    0x74cf_c868,
    0x9061_bc41,
    0x141a_be58,
    0x3cca_0545,
    0x7460_965c,
    0xb616_a9dd,
    0x73cb_804c,
    0x1fea_c0b3,
    0xda54_60bf,
    0x5a66_d0ca,
    0xef16_48e2,
    0xad46_7c43,
    0x0b2f_5eeb,
    0xfa37_15e6,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x5000_0000,
    0x9800_0000,
    0xb400_0000,
    0xa600_0000,
    0x1f00_0000,
    0x6880_0000,
    0x5ac0_0000,
    0x57a0_0000,
    0x5170_0000,
    0xe218_0000,
    0x0fcc_0000,
    0xd22e_0000,
    0x2a3f_0000,
    0x50f4_8000,
    0x175e_c000,
    0x7e27_2000,
    0x7830_9000,
    0x49f9_f800,
    0x30d8_e400,
    0xd46e_7600,
    0xc15b_bd00,
    0xe928_ae80,
    0x9cbf_c940,
    0x5131_2020,
    0x4673_9010,
    0x469b_7838,
    0xb705_24e4,
    0xf48b_d63e,
    0x20c6_edab,
    0x92ac_f64e,
    0xacf6_7d05,
    0xdd55_0e1f,
    0xd32e_991b,
    0xf9bb_780d,
    0xfcb5_24fa,
    0xe133_d6ae,
    0x2e7a_edde,
    0x3a9a_f654,
    0x3d05_7d8c,
    0xf98f_8e97,
    0xf14f_596b,
    0xbfe8_d852,
    0xc91b_74e8,
    0x814d_0e64,
    0x37e2_997e,
    0x4515_788b,
    0xc34a_24de,
    0x16e7_567d,
    0x8694_2ddb,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x5000_0000,
    0x0800_0000,
    0x3400_0000,
    0x6e00_0000,
    0xa300_0000,
    0xd980_0000,
    0xc9c0_0000,
    0x23e0_0000,
    0x7ef0_0000,
    0x6ed8_0000,
    0x8ec4_0000,
    0x5c62_0000,
    0xc03b_0000,
    0xaabd_8000,
    0x92f7_c000,
    0xfcdf_a000,
    0x97c3_d000,
    0x18e0_2800,
    0x7b79_c400,
    0xad16_8200,
    0x682e_c100,
    0x6c11_0a80,
    0xd0a0_d5c0,
    0x6d5d_a060,
    0x4a08_d090,
    0xe505_a8e8,
    0xfe8a_0464,
    0x264b_2266,
    0x7526_1197,
    0xde94_a237,
    0x14ea_d1aa,
    0xb976_829a,
    0xbc1e_c127,
    0x18a9_0a25,
    0xb954_d554,
    0x7407_a034,
    0x4e07_d049,
    0x1302_28a9,
    0x8182_c45c,
    0xf5cb_02ca,
    0x79e9_0125,
    0xb3f6_aa9e,
    0x1457_05b6,
    0x9e87_881d,
    0xb64e_147a,
    0x9d2c_aa92,
    0xba98_057e,
    0x72e0_0883,
    0x2e76_d486,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x7000_0000,
    0x1800_0000,
    0x0c00_0000,
    0x2200_0000,
    0xc500_0000,
    0x1380_0000,
    0x2a40_0000,
    0x3d20_0000,
    0x6e90_0000,
    0x0ff8_0000,
    0x1744_0000,
    0x92aa_0000,
    0x1ed1_0000,
    0x8bde_8000,
    0x5055_4000,
    0x7e10_e000,
    0x053b_7000,
    0x98a9_e800,
    0x6fdf_dc00,
    0xa65b_1600,
    0xf519_0b00,
    0x81ba_1e80,
    0x7c69_a7c0,
    0x673a_e0e0,
    0xfdaa_70b0,
    0x6c57_6878,
    0xe41a_9c7c,
    0xdc33_f63a,
    0xc126_7bc9,
    0x9499_f6b1,
    0xa6f7_7b2f,
    0x56c7_76ce,
    0x65e2_3bf4,
    0x3c77_96ca,
    0xed09_4bc5,
    0xa786_7e47,
    0x1442_9770,
    0xb22f_68d0,
    0xac1e_9c1d,
    0x1839_f681,
    0xe727_7ba8,
    0x179f_767d,
    0x4676_3b30,
    0x8405_964f,
    0x860c_4ba2,
    0x930a_fee7,
    0x8882_d728,
    0xc6cb_0869,
    0xcde1_acca,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x5000_0000,
    0xe800_0000,
    0xac00_0000,
    0xae00_0000,
    0xa100_0000,
    0x9080_0000,
    0x54c0_0000,
    0x9a20_0000,
    0x9310_0000,
    0x0cf8_0000,
    0x0d4c_0000,
    0xb262_0000,
    0x93f3_0000,
    0xf4c3_8000,
    0xea20_4000,
    0x4b16_2000,
    0x18fd_f000,
    0xe741_9800,
    0x1164_8400,
    0x0c75_0e00,
    0x9189_0300,
    0xb440_b680,
    0x16e3_7740,
    0x1d37_a0e0,
    0x75ee_b010,
    0xa2b4_3888,
    0x20a9_34fc,
    0x44da_b646,
    0x395c_770d,
    0x4316_20be,
    0xa4fd_f0b5,
    0xc141_986a,
    0x4c64_8497,
    0xdaf5_0e7e,
    0xc849_0332,
    0x10e0_b690,
    0x7033_777f,
    0x1b6f_a036,
    0xbf72_b03d,
    0x860e_38ad,
    0x2d06_349d,
    0x0e83_36e6,
    0x4dc3_3709,
    0x4ea1_80e7,
    0xc5d3_40a6,
    0x99d5_a026,
    0xafdd_b0fa,
    0x7ad7_b89c,
    0x5059_7449,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x9000_0000,
    0xa800_0000,
    0x2400_0000,
    0x9a00_0000,
    0x0100_0000,
    0xe280_0000,
    0x29c0_0000,
    0xcd60_0000,
    0x8b30_0000,
    0x9098_0000,
    0x0f44_0000,
    0x2eaa_0000,
    0x8f5f_0000,
    0x4d2b_8000,
    0x8414_c000,
    0xc985_e000,
    0x524c_b000,
    0x7a22_b800,
    0xe997_f400,
    0xc1c5_6a00,
    0x496a_3500,
    0xe130_3280,
    0xa99a_71c0,
    0x61ce_60e0,
    0xb968_7050,
    0xd93f_58c8,
    0x259f_44b4,
    0xdfcd_d232,
    0x2262_c125,
    0x3abe_d8f8,
    0xeed4_84e8,
    0x3b63_b24f,
    0x643a_b132,
    0x2119_8075,
    0x710f_c060,
    0x1a84_6044,
    0xc5c7_7011,
    0xe36c_d829,
    0xb83f_8406,
    0x571a_32d3,
    0x5e05_715c,
    0xcb05_e041,
    0x2b8c_b05d,
    0x7f42_b838,
    0xd6a7_f434,
    0x635d_6a55,
    0x632e_354f,
    0xb71a_327d,
    0x0e05_710c,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x1000_0000,
    0x7800_0000,
    0x1c00_0000,
    0x8600_0000,
    0x2100_0000,
    0x6080_0000,
    0x3c40_0000,
    0x80e0_0000,
    0x9230_0000,
    0xb618_0000,
    0xc48c_0000,
    0x064a_0000,
    0xd7ef_0000,
    0xbbb6_8000,
    0x8ede_4000,
    0xe225_a000,
    0xb390_7000,
    0xb243_1800,
    0x95e7_4c00,
    0xf0b3_8a00,
    0x2151_8d00,
    0xfbe3_b280,
    0xf5b8_f140,
    0x3bd6_8060,
    0x70ae_4050,
    0x4cdd_a098,
    0xe92c_700c,
    0xfc11_18fe,
    0xbb84_4c3d,
    0xabcf_0ae6,
    0x6520_cd1d,
    0x4210_9260,
    0x6686_c1ee,
    0x5d48_3856,
    0x0065_7c06,
    0xbe7f_3228,
    0x4ef9_b11f,
    0x4abd_a0c3,
    0x365c_7024,
    0x3269_185f,
    0xdd78_4c30,
    0x657d_0ac8,
    0xd973_cd94,
    0xaf74_1272,
    0xe67b_8183,
    0xe2f1_18bb,
    0x44b4_4cab,
    0x6357_0a65,
    0xb0ec_cd42,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0xb000_0000,
    0x0800_0000,
    0xfc00_0000,
    0x5a00_0000,
    0x4100_0000,
    0x8480_0000,
    0xa540_0000,
    0x6a20_0000,
    0x7bb0_0000,
    0xc858_0000,
    0x6884_0000,
    0x874e_0000,
    0xff29_0000,
    0xe93b_8000,
    0x7e17_4000,
    0x3b2e_6000,
    0x873f_b000,
    0xb91d_5800,
    0x14ad_9c00,
    0xeffd_b600,
    0x0efa_7900,
    0xfa75_0e80,
    0x773f_15c0,
    0x511b_80a0,
    0x78a7_4070,
    0x0df6_6028,
    0xbbfb_b04c,
    0xd8f3_5852,
    0xc974_9cbd,
    0xfebe_36de,
    0x22d9_39e4,
    0x0acd_6e6e,
    0xc2ed_a51e,
    0xec53_5802,
    0x9684_9c63,
    0xf846_3667,
    0x24ad_39db,
    0x27fb_6ebc,
    0xd2f0_a5fc,
    0x107e_d8ac,
    0x3e3e_dc6d,
    0x299d_d644,
    0x87ec_c901,
    0x26d3_d626,
    0x44c5_c974,
    0xb5e8_5624,
    0xcbd2_897a,
    0x0246_3683,
    0x15ad_39dc,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0xd000_0000,
    0x9800_0000,
    0xc400_0000,
    0x0600_0000,
    0x0b00_0000,
    0x4f80_0000,
    0x3540_0000,
    0x5260_0000,
    0xb170_0000,
    0x3dd8_0000,
    0xdd84_0000,
    0x604e_0000,
    0xf2ef_0000,
    0x1db4_8000,
    0xc9fd_c000,
    0xb518_2000,
    0xdfa6_d000,
    0x4bd7_4800,
    0x5e89_2c00,
    0x53c2_b200,
    0xd5a9_9100,
    0xdad9_5a80,
    0xf80b_adc0,
    0xf40c_80a0,
    0x6e09_c010,
    0x870e_20b8,
    0x158d_d014,
    0xfc4d_c89e,
    0x10eb_eccf,
    0xc0b6_1249,
    0x1576_813e,
    0x0bd8_329d,
    0xbe8b_5144,
    0xa3cd_facf,
    0x9da4_bd7c,
    0x86d5_e865,
    0x3a0d_3cfb,
    0xf901_5ac3,
    0x2a8f_ad24,
    0xfdc2_80f9,
    0x72a6_c02c,
    0x1f5a_a0c5,
    0x9c40_10de,
    0x20ed_e8a0,
    0xa8b9_3c16,
    0x9977_5a80,
    0x51d4_adb8,
    0x7780_00a1,
    0xe140_0085,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0xb000_0000,
    0x4800_0000,
    0x7400_0000,
    0x3600_0000,
    0xe300_0000,
    0x7e80_0000,
    0x7040_0000,
    0xaf60_0000,
    0xd630_0000,
    0xfd98_0000,
    0x9584_0000,
    0x1ac6_0000,
    0xf921_0000,
    0x625f_8000,
    0x692b_c000,
    0x5a58_2000,
    0xf52f_5000,
    0xa85e_d800,
    0x6826_6c00,
    0x41dd_b200,
    0x50e2_7500,
    0x7dfc_ca80,
    0x5734_89c0,
    0x2619_8020,
    0x904a_c070,
    0x7f67_a0e8,
    0x8e34_90c4,
    0x719e_f87e,
    0x9f8d_3c97,
    0xbbc5_6a48,
    0x52a5_1993,
    0x8f9e_f851,
    0xc88d_3c66,
    0x5345_6af2,
    0x71e5_19f3,
    0x167e_f82f,
    0x1afd_3cd8,
    0x37bd_6aee,
    0xd151_19c3,
    0x8fa0_f88e,
    0x0618_3c58,
    0xe044_eacb,
    0x976b_d918,
    0x4a3f_58a2,
    0x0f98_ac69,
    0x0884_121f,
    0xf343_e57b,
    0xc1e3_b272,
    0x5e77_75ff,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x1000_0000,
    0x3800_0000,
    0x0c00_0000,
    0x9a00_0000,
    0x8f00_0000,
    0x8a80_0000,
    0xc2c0_0000,
    0xbb60_0000,
    0x1db0_0000,
    0xc998_0000,
    0x530c_0000,
    0x0882_0000,
    0x31c7_0000,
    0x83e2_8000,
    0x6473_4000,
    0x6e71_6000,
    0x997d_5000,
    0x7ffa_5800,
    0x373f_8400,
    0x3b5f_1a00,
    0xa062_2d00,
    0x3134_a280,
    0x5654_b940,
    0xc9e2_00e0,
    0xf377_0050,
    0x98fa_8058,
    0xe9bf_401c,
    0x7f93_60a2,
    0x360a_5083,
    0x2500_d810,
    0x4d80_c44d,
    0x6c4c_7a31,
    0xd7a8_7ddf,
    0xbfd4_7af2,
    0x4ba4_7d0e,
    0x5dd6_7a21,
    0xa8a3_7d32,
    0x5d54_fa53,
    0xdd60_3d09,
    0x60bd_9aaf,
    0x9811_6d2e,
    0x9d45_c2d9,
    0x5c29_e9bf,
    0x9e98_5837,
    0x8588_849b,
    0x0845_9a30,
    0x19ad_6de9,
    0xb6df_c22a,
    0xec22_e9db,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x5000_0000,
    0x5800_0000,
    0x5c00_0000,
    0xae00_0000,
    0x8300_0000,
    0xc480_0000,
    0xd440_0000,
    0x1820_0000,
    0xc750_0000,
    0xd8b8_0000,
    0xdd0c_0000,
    0x0f86_0000,
    0x34c7_0000,
    0x6e60_8000,
    0xaa70_4000,
    0x0467_2000,
    0xbb76_d000,
    0x9dee_7800,
    0x20b0_0c00,
    0x9103_4600,
    0xd989_3700,
    0xbbcc_9e80,
    0x5ce8_ab40,
    0xa13e_00a0,
    0x76cb_0010,
    0x2b66_8078,
    0x99f7_400c,
    0xeea7_a0f6,
    0x5e16_90df,
    0xf711_586a,
    0x029a_dc57,
    0x1f53_3edc,
    0xc4b2_3b13,
    0x5309_5840,
    0xdc86_dc5a,
    0xa84d_3ef7,
    0xe629_3bb9,
    0x1c57_d8b9,
    0x403d_9c82,
    0xa74c_9ee4,
    0x94a8_abc2,
    0x371e_0085,
    0x629b_0053,
    0x6f5e_809a,
    0xccbb_40ed,
    0x5701_a06e,
    0x2e81_90d0,
    0x8549_d8a3,
    0xa1a6_9c5a,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0xb000_0000,
    0x1800_0000,
    0x0c00_0000,
    0xb200_0000,
    0x0900_0000,
    0xe080_0000,
    0x3cc0_0000,
    0xbba0_0000,
    0x6cb0_0000,
    0x8658_0000,
    0x5b04_0000,
    0x3986_0000,
    0xd441_0000,
    0x236a_8000,
    0x7111_4000,
    0x5de3_e000,
    0x86d7_b000,
    0xb7cc_9800,
    0x8a2a_c400,
    0x1cf3_f600,
    0x033e_b100,
    0x9d10_0e80,
    0x3fe3_85c0,
    0x87de_0020,
    0xf345_0070,
    0x10ec_80b8,
    0x1050_40bc,
    0x3409_60aa,
    0xce06_f005,
    0x030f_7852,
    0x558d_7435,
    0x7647_6e5b,
    0x8260_7550,
    0x859d_f8bd,
    0xdf28_34f7,
    0x867a_8e1f,
    0x32f2_c53f,
    0xd03d_e082,
    0xc092_b069,
    0xeda0_186c,
    0xa3ba_844e,
    0xc1da_9612,
    0x9448_413c,
    0x4367_7622,
    0x611a_f12c,
    0xf5e7_6ec7,
    0x92d0_752b,
    0x09c5_f8a0,
    0x312c_3408,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x9000_0000,
    0xe800_0000,
    0x7400_0000,
    0xe200_0000,
    0x0f00_0000,
    0x2080_0000,
    0x98c0_0000,
    0x10e0_0000,
    0xe670_0000,
    0xb3d8_0000,
    0xda04_0000,
    0x730e_0000,
    0x068b_0000,
    0x0dc7_8000,
    0xa369_c000,
    0xc839_6000,
    0xd6f6_d000,
    0x0316_f800,
    0x9eed_8400,
    0xe77f_8200,
    0x5252_e900,
    0x8341_9a80,
    0xaaaf_7dc0,
    0xd158_00a0,
    0x1dc4_0050,
    0x8b6e_00c8,
    0x9c3b_00e4,
    0xa4ff_800a,
    0xe41d_c07b,
    0xca6f_60c2,
    0x9db9_d097,
    0x4dbf_7830,
    0x45bf_447e,
    0x81b9_62a3,
    0x1bb9_f93c,
    0x88b8_0240,
    0x3e3b_291c,
    0x4bf8_fade,
    0x7499_adf5,
    0x2aae_f88d,
    0x1159_8451,
    0x3dc9_82e1,
    0x1b6d_e9a3,
    0x7430_1a4e,
    0xd0f9_bdef,
    0x0610_e016,
    0xc564_10d9,
    0xbd30_1819,
    0xd576_94f7,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x9000_0000,
    0xa800_0000,
    0x4c00_0000,
    0x4e00_0000,
    0x9700_0000,
    0xc580_0000,
    0x7d40_0000,
    0xa760_0000,
    0x3bf0_0000,
    0x5528_0000,
    0xf804_0000,
    0x8402_0000,
    0xb201_0000,
    0xe104_8000,
    0xb685_4000,
    0xbac2_6000,
    0x0322_7000,
    0xce14_b800,
    0xd61e_2c00,
    0x770f_ea00,
    0xe093_3b00,
    0x58da_df80,
    0xfe2b_2940,
    0x2b80_0020,
    0x3a40_0010,
    0xeae0_0008,
    0x9ab0_0024,
    0x1448_002a,
    0x18f4_0013,
    0x5aaa_0013,
    0xa045_0025,
    0x07e6_8031,
    0x4234_401f,
    0xa98e_e029,
    0x7653_300e,
    0xa5fc_d815,
    0x9f39_5c3e,
    0xdc1d_d221,
    0x3209_572c,
    0x7413_d5b8,
    0xab1f_226d,
    0x078c_078e,
    0x1157_7550,
    0x787b_521b,
    0x967d_1701,
    0xd17d_35bf,
    0x9cfc_124f,
    0x3db8_df8f,
    0x7cda_2959,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x1000_0000,
    0x3800_0000,
    0x8c00_0000,
    0x5a00_0000,
    0x2100_0000,
    0x3b80_0000,
    0x3840_0000,
    0xcbe0_0000,
    0x69f0_0000,
    0x2d98_0000,
    0x2c04_0000,
    0x6a06_0000,
    0xe907_0000,
    0x9f80_8000,
    0xd641_c000,
    0x3ce4_6000,
    0x2972_d000,
    0x0f59_0800,
    0xe425_dc00,
    0xf057_c200,
    0x6689_5f00,
    0xf7ef_cf80,
    0xbdda_acc0,
    0x93e0_0020,
    0x35f0_0030,
    0xaf98_0038,
    0x9104_0004,
    0x3386_000e,
    0x7c47_0023,
    0x35e0_8016,
    0xa6f1_c008,
    0xe11c_600e,
    0x54c6_d00e,
    0x8327_0832,
    0x48d6_dc1a,
    0x2849_420b,
    0x75cb_9f0b,
    0x3e8d_2f9a,
    0xabee_bcfa,
    0x3fdd_e807,
    0x2ee6_cc05,
    0x6c72_aa37,
    0x3ada_530e,
    0x3b67_058d,
    0x4331_2fda,
    0xa1b8_8d8a,
    0x4852_33e1,
    0x2a8b_afab,
    0x4de8_7cd5,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x3000_0000,
    0xc800_0000,
    0xdc00_0000,
    0x4a00_0000,
    0x4f00_0000,
    0x5380_0000,
    0xe2c0_0000,
    0x8660_0000,
    0x10f0_0000,
    0x7ed8_0000,
    0xb404_0000,
    0xe602_0000,
    0xed01_0000,
    0xf081_8000,
    0x3346_4000,
    0xf7a6_e000,
    0x8f12_5000,
    0xc3ea_7800,
    0x1f3e_9c00,
    0xa031_1600,
    0xf3bf_3300,
    0xb974_0780,
    0x5b1e_36c0,
    0x9de0_0020,
    0x6e30_0010,
    0x92b8_0008,
    0xdbf4_000c,
    0x035a_0032,
    0x67c5_0037,
    0xdae3_8012,
    0x81b7_4013,
    0x2a7f_6014,
    0xea90_1038,
    0x542e_9821,
    0x6ddd_cc04,
    0xed82_ee1f,
    0x6bc3_ef2d,
    0x08e1_f1b9,
    0xcab2_55fb,
    0x17ff_ff9c,
    0x1956_eadc,
    0x58cf_f615,
    0xc969_633f,
    0xeb7c_7f8a,
    0xf811_aafc,
    0xe468_9628,
    0x7bfd_7308,
    0xdb50_e7a0,
    0xebcd_66f1,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0xd000_0000,
    0x2800_0000,
    0x3400_0000,
    0x6a00_0000,
    0xa500_0000,
    0xda80_0000,
    0x10c0_0000,
    0xd520_0000,
    0xc690_0000,
    0xfcf8_0000,
    0x0204_0000,
    0xf106_0000,
    0xc085_0000,
    0x4dc6_8000,
    0x13a1_4000,
    0x8851_a000,
    0xe6db_5000,
    0xbb11_2800,
    0xc7b8_d400,
    0x0761_8600,
    0xaf76_2900,
    0xe94a_7480,
    0x3b6c_c7c0,
    0x0678_0020,
    0x02c4_0030,
    0xac26_0028,
    0xe215_0034,
    0xf33e_800a,
    0x80a5_400d,
    0xc9d7_a01a,
    0x939e_5029,
    0xf977_a836,
    0x0249_9404,
    0xa6e8_2635,
    0x8d39_7931,
    0x5fa5_5cbf,
    0x3e55_13c0,
    0xbdd9_061c,
    0x7e96_6900,
    0x80fb_54bb,
    0x2c03_d7f0,
    0xc606_0808,
    0xa302_c404,
    0xd981_0e1c,
    0x1945_ad2c,
    0xe462_dabd,
    0x16f6_3ae2,
    0x800d_f2b5,
    0x270f_eee6,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0xd000_0000,
    0xd800_0000,
    0xe400_0000,
    0xbe00_0000,
    0x3700_0000,
    0xdd80_0000,
    0x3d40_0000,
    0xf320_0000,
    0x6bd0_0000,
    0x3c48_0000,
    0xba04_0000,
    0x9906_0000,
    0x5283_0000,
    0xd4c6_8000,
    0xa866_c000,
    0x4bf7_2000,
    0x341d_f000,
    0x8c0d_b800,
    0x0da4_ec00,
    0x9d14_ea00,
    0x492a_1900,
    0xad77_1e80,
    0x46de_0240,
    0x9768_0020,
    0xf5d4_0030,
    0x7b4e_0018,
    0x0f87_0034,
    0x4840_8036,
    0x23a5_c039,
    0xd211_a02f,
    0xc0ab_300d,
    0x2632_9837,
    0xbefd_1c0f,
    0x7b3f_523c,
    0x7ddd_f51a,
    0xd8ed_748f,
    0x1d96_db6e,
    0xe8ee_3e86,
    0xd594_f264,
    0xb4ed_380d,
    0x5f91_2c2e,
    0xe5ed_4a3c,
    0x5115_2900,
    0xbb2b_86ba,
    0xa874_1e77,
    0xfe5f_d21f,
    0xc2a8_3520,
    0x8b34_d4b8,
    0x8a79_eb70,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x9000_0000,
    0x2800_0000,
    0x8400_0000,
    0xda00_0000,
    0x2300_0000,
    0x3180_0000,
    0xcec0_0000,
    0x2aa0_0000,
    0x9610_0000,
    0x4b58_0000,
    0xae04_0000,
    0xa106_0000,
    0x0e81_0000,
    0x1944_8000,
    0xb161_4000,
    0xf034_2000,
    0xdb0e_d000,
    0x13bd_1800,
    0x4cf3_8c00,
    0x96a9_7600,
    0x4e28_d500,
    0x7a6b_7080,
    0x0b8c_3ac0,
    0x33f8_0020,
    0xcf14_0030,
    0x09de_0008,
    0x5945_0024,
    0x5162_800a,
    0x4030_4021,
    0x6308_a036,
    0xbfbb_9008,
    0x12f7_380c,
    0x6fa8_5c33,
    0x5cae_ee0a,
    0x852f_1925,
    0xefec_a692,
    0x8f4e_7feb,
    0x1258_c888,
    0xec85_26f3,
    0x5642_ce2e,
    0xfee5_c938,
    0x57f7_bebe,
    0xcb2c_f3f3,
    0xfeed_3e98,
    0x39c8_b3ca,
    0xa71b_9eb7,
    0x03e6_23fc,
    0x5f76_26ba,
    0x376a_3fe1,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x9000_0000,
    0x3800_0000,
    0x8400_0000,
    0x5600_0000,
    0x2700_0000,
    0x2b80_0000,
    0xc7c0_0000,
    0x4f60_0000,
    0xd990_0000,
    0xdfb8_0000,
    0x7704_0000,
    0xf382_0000,
    0x73c5_0000,
    0xb164_8000,
    0x4291_c000,
    0x263c_2000,
    0xc1c6_b000,
    0xb063_3800,
    0x4614_5c00,
    0xe67a_be00,
    0xa367_bb00,
    0xd390_ec80,
    0x1ab9_4dc0,
    0x8582_0020,
    0x84c5_0010,
    0x02e4_8028,
    0x9151_c024,
    0x075c_200e,
    0xbb56_b021,
    0x125b_3815,
    0xd1d0_5c09,
    0x7118_be0a,
    0xcef2_bb31,
    0xf22c_6c93,
    0xf6bc_8df6,
    0x8f84_2017,
    0x41c2_b00d,
    0xf061_3814,
    0xe611_5c38,
    0x767e_3e22,
    0x9b66_7b31,
    0x5794_cc9c,
    0x4cbb_fdf9,
    0xa283_3806,
    0xaf44_5c30,
    0xc522_be02,
    0xde33_bb3a,
    0xdeca_ec8d,
    0x64e8_4dfa,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x1000_0000,
    0xf800_0000,
    0x3c00_0000,
    0x5a00_0000,
    0x1b00_0000,
    0xa880_0000,
    0x1c40_0000,
    0x7b60_0000,
    0x8110_0000,
    0x4f08_0000,
    0xab04_0000,
    0x8086_0000,
    0xf841_0000,
    0x0d60_8000,
    0x3817_c000,
    0xc089_e000,
    0x45c6_d000,
    0xfca6_d800,
    0xaab4_4400,
    0xdf38_6200,
    0xa778_1b00,
    0x6a1f_e880,
    0x720b_a840,
    0xa286_0020,
    0x1f41_0030,
    0xdfe0_8008,
    0x2f57_c004,
    0xeb69_e03e,
    0xe496_d00f,
    0x92ce_d816,
    0x9ba0_4406,
    0xb836_622a,
    0xe87d_1b07,
    0x9c99_689e,
    0x334d_6860,
    0x2067_6033,
    0xc994_101a,
    0x6349_b828,
    0x3864_543a,
    0xc597_da3d,
    0xd14d_4f01,
    0xe760_b2a6,
    0x0b15_2757,
    0x8c09_52b5,
    0x2f83_f75d,
    0x3ec7_8a81,
    0xa423_b37d,
    0x7ef1_e89f,
    0x705e_a84d,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x9000_0000,
    0x2800_0000,
    0x3c00_0000,
    0xd200_0000,
    0x7b00_0000,
    0xef80_0000,
    0x4840_0000,
    0xc920_0000,
    0x8810_0000,
    0x90a8_0000,
    0xa304_0000,
    0x8b82_0000,
    0xbe45_0000,
    0xe424_8000,
    0xda91_4000,
    0xa269_e000,
    0x64e2_9000,
    0x1671_d800,
    0xc81a_7c00,
    0xdefa_c200,
    0x2389_0900,
    0x2c16_a080,
    0x86a9_9540,
    0xbe02_0020,
    0x6105_0010,
    0x9884_8028,
    0xcdc1_4024,
    0xee61_e00a,
    0x40b6_900f,
    0xf9fb_d834,
    0x6e0b_7c1e,
    0x0754_423b,
    0x2409_4912,
    0xb851_c0b2,
    0xad8b_4562,
    0xf514_b804,
    0x0a2d_ac38,
    0x9dc0_fa0a,
    0x2664_e50b,
    0x4cb1_3ab3,
    0x93ff_a079,
    0x010d_82bc,
    0x06d6_0c57,
    0xc54f_78b6,
    0xe5f7_e954,
    0x825a_c207,
    0xe4d9_0911,
    0xe81e_a0b9,
    0x0efd_957c,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0xb000_0000,
    0xf800_0000,
    0xbc00_0000,
    0xc200_0000,
    0x5700_0000,
    0xc080_0000,
    0x30c0_0000,
    0x8220_0000,
    0x28b0_0000,
    0x6638_0000,
    0xcb04_0000,
    0x7286_0000,
    0x3fc5_0000,
    0x4ea5_8000,
    0x2277_c000,
    0x0f1d_e000,
    0xe132_1000,
    0x737c_b800,
    0xb667_0400,
    0x2452_0600,
    0xf9ae_d100,
    0xa20d_2580,
    0xd7f8_e1c0,
    0x88a6_0020,
    0x6b75_0030,
    0x4a9d_8028,
    0x0e73_c02c,
    0x451b_e03e,
    0x5237_102f,
    0x7df9_3830,
    0xeba0_c415,
    0x8df7_e630,
    0xe358_c10c,
    0x21d7_9da0,
    0x76ea_e5ca,
    0x8469_8639,
    0x7ba8_1102,
    0x950b_45b4,
    0x077c_31e3,
    0xf064_d80d,
    0xad52_d417,
    0x1c2b_5e1b,
    0xfd4f_c501,
    0x199d_9b92,
    0xd0f0_34ce,
    0xf0da_a3b9,
    0x0f91_f0d1,
    0xe10e_c589,
    0x417b_f1d7,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x7000_0000,
    0x8800_0000,
    0x0c00_0000,
    0xca00_0000,
    0x3700_0000,
    0x2b80_0000,
    0x9d40_0000,
    0xd2e0_0000,
    0x56b0_0000,
    0x55c8_0000,
    0xeb04_0000,
    0x3982_0000,
    0x3e43_0000,
    0xc763_8000,
    0xb2f4_4000,
    0x5da8_6000,
    0xf672_5000,
    0x3f6b_b800,
    0xe7d6_5c00,
    0xb23d_6a00,
    0xb62d_d700,
    0x4b37_5580,
    0xfd89_be40,
    0x4962_0020,
    0x63f3_0010,
    0x9b2b_8018,
    0x8fb0_401c,
    0xdf4a_6022,
    0x38c1_5003,
    0x9ea0_3832,
    0x42d6_1c0d,
    0x7abf_0a0a,
    0x5ee8_8727,
    0x0d95_6db4,
    0x2b5c_a255,
    0x0dde_8a35,
    0x441f_c72a,
    0x4c3e_8d96,
    0xef2a_b253,
    0x81b5_5233,
    0x4e4f_cb3f,
    0x9e42_5fbd,
    0x9766_396c,
    0x2af6_ed87,
    0xa9a8_e24d,
    0xb876_ea12,
    0xce6d_9739,
    0x3155_35b7,
    0x33fc_ee7d,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x5000_0000,
    0x3800_0000,
    0x5400_0000,
    0x1200_0000,
    0xed00_0000,
    0x9c80_0000,
    0x8940_0000,
    0x8a60_0000,
    0x0750_0000,
    0xc138_0000,
    0x9104_0000,
    0x8286_0000,
    0xd245_0000,
    0x81e2_8000,
    0x9391_c000,
    0x189a_a000,
    0x6a74_9000,
    0xbf09_6800,
    0x90ed_e400,
    0x507c_ca00,
    0xdf62_9300,
    0x0fd3_1a80,
    0xfa78_d9c0,
    0xa666_0020,
    0x2155_0030,
    0xce3a_8028,
    0x8885_c014,
    0xfb44_a00e,
    0x9765_9015,
    0xf3d5_e804,
    0x247d_243b,
    0x5d62_ea27,
    0x7ad2_c322,
    0x62fa_52a2,
    0x0524_6dc1,
    0x1237_0210,
    0x47ef_e714,
    0x2df8_b888,
    0x7ca6_aee0,
    0x9bf5_508e,
    0x6acf_8ac1,
    0x33c9_ba8a,
    0x8d4c_49c5,
    0x210f_680e,
    0x0be8_e437,
    0xfbfe_4a14,
    0x1ba3_530c,
    0xee71_ba9e,
    0x5508_49d6,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x9000_0000,
    0x4800_0000,
    0x1400_0000,
    0x6e00_0000,
    0xc900_0000,
    0xf380_0000,
    0xd4c0_0000,
    0x89e0_0000,
    0xbb10_0000,
    0x7eb8_0000,
    0xe504_0000,
    0x1182_0000,
    0x4fc3_0000,
    0x5964_8000,
    0x7352_4000,
    0x0d18_a000,
    0x9eb7_7000,
    0x400c_4800,
    0x1508_9c00,
    0xbc8c_2600,
    0x3f4b_0f00,
    0x542c_f880,
    0x947b_45c0,
    0xcde2_0020,
    0xbd13_0010,
    0x53bc_8018,
    0xa086_4024,
    0x5042_a012,
    0x4fa0_7005,
    0x91b2_c81b,
    0xbe8d_dc32,
    0x744a_063c,
    0xaca9_3f35,
    0xd83e_90a2,
    0x9845_e9ee,
    0x1ba6_4e3f,
    0x9fb1_a329,
    0xe78a_b69c,
    0xcfca_e6f7,
    0x6c68_b6a4,
    0x3fd9_e6c9,
    0xea54_36a0,
    0x969f_a6e1,
    0xae76_9686,
    0x7fef_d6c1,
    0x3b1c_5ebc,
    0x4bb6_0ae2,
    0xa98c_5887,
    0xf6c8_35ea,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x9000_0000,
    0xf800_0000,
    0x4c00_0000,
    0x7600_0000,
    0x0700_0000,
    0xb580_0000,
    0x5f40_0000,
    0x91e0_0000,
    0x8090_0000,
    0xb298_0000,
    0xb104_0000,
    0x5282_0000,
    0xdac5_0000,
    0xa6a4_8000,
    0xa577_c000,
    0x080a_6000,
    0x729f_b000,
    0x5106_3800,
    0x6282_ac00,
    0xb2c3_7a00,
    0x12a7_cf00,
    0x9f71_a480,
    0x790c_44c0,
    0xc01a_0020,
    0xbbc1_0010,
    0xac26_8028,
    0xa3b2_c024,
    0x20ae_e03e,
    0x9ce8_7013,
    0x9a8c_581d,
    0x485d_1c01,
    0xc7a5_422d,
    0xaff5_6317,
    0x0eca_dea4,
    0x5a3f_8be0,
    0xbf71_a48c,
    0xa90c_44fc,
    0x981a_001c,
    0x67c1_0002,
    0x2226_803f,
    0xe8b2_c01e,
    0xe32e_e021,
    0xc4a8_700e,
    0xbeec_5824,
    0x978d_1c0e,
    0xe4dd_4225,
    0x9e61_6333,
    0xeed0_deaf,
    0x31fe_8bd2,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0xf000_0000,
    0xb800_0000,
    0xfc00_0000,
    0x2600_0000,
    0xe300_0000,
    0xc180_0000,
    0xcec0_0000,
    0x3ce0_0000,
    0x4190_0000,
    0xe978_0000,
    0xb504_0000,
    0x5a86_0000,
    0x9343_0000,
    0x2427_8000,
    0x2675_c000,
    0x956f_e000,
    0xb4bd_3000,
    0x3065_1800,
    0x49d3_0c00,
    0x90da_f600,
    0x8bb7_a700,
    0xa80e_2c80,
    0x5bee_9bc0,
    0x15fe_0020,
    0x0547_0030,
    0xdf21_8018,
    0x8bf6_c03c,
    0x35a8_602e,
    0x2f58_f03f,
    0x6a72_f809,
    0xab6a_3c38,
    0x3bb9_ee30,
    0x9fe7_ab33,
    0x2013_5a8f,
    0xb7bc_fcd0,
    0xc1e7_cc9a,
    0x5f10_abdd,
    0xa03c_982e,
    0x5421_cc28,
    0x5e74_963f,
    0x096c_570a,
    0x62bb_5482,
    0x6b61_67ea,
    0x7450_0e15,
    0x7819_9b29,
    0x5451_c283,
    0x281a_30fd,
    0x7c52_da91,
    0x9c1a_3ce4,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x5000_0000,
    0xb800_0000,
    0x6400_0000,
    0x7a00_0000,
    0xf500_0000,
    0xb580_0000,
    0xd7c0_0000,
    0x7860_0000,
    0xdff0_0000,
    0xca58_0000,
    0x6b04_0000,
    0xfa86_0000,
    0xb741_0000,
    0x4a22_8000,
    0xc855_c000,
    0x09cb_2000,
    0x04af_d000,
    0xaedd_a800,
    0x9346_ac00,
    0xd023_3e00,
    0x4d55_8300,
    0x544a_9f80,
    0x0f6f_62c0,
    0xc8be_0020,
    0xc3b5_0030,
    0x5afc_8008,
    0x4410_c014,
    0x016f_a02e,
    0x1fbb_1019,
    0x9734_081e,
    0xaabc_bc3d,
    0xc2b5_b62d,
    0x0d7c_ff35,
    0x52d4_099e,
    0x0e8c_4df7,
    0x868f_a192,
    0xea8b_e1ea,
    0x3c8e_1f96,
    0x3f8b_a2c9,
    0xd90f_a014,
    0x504b_100f,
    0xc56c_083a,
    0xf5b8_bc31,
    0xfa33_b636,
    0x2b3d_ff35,
    0xd776_8999,
    0xe419_8dec,
    0x42a4_81b4,
    0xe614_31eb,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x1000_0000,
    0x2800_0000,
    0x6c00_0000,
    0xa200_0000,
    0x5500_0000,
    0x8980_0000,
    0x0c40_0000,
    0x1d60_0000,
    0xcdb0_0000,
    0x2558_0000,
    0x7304_0000,
    0xf282_0000,
    0xc2c5_0000,
    0xf5a0_8000,
    0x1111_4000,
    0x37cb_6000,
    0x7189_1000,
    0xb5ec_a800,
    0xe3df_4c00,
    0xa7c3_e200,
    0x0426_2b00,
    0xf951_cd80,
    0xf4ae_9ac0,
    0x633a_0020,
    0x2031_0010,
    0xb71a_8028,
    0x1160_4004,
    0x9fb1_e00a,
    0xe859_501b,
    0xae85_4828,
    0x18c2_1c15,
    0x44a4_aa22,
    0x4691_3703,
    0xe48d_e787,
    0xdc6a_edf3,
    0x5f9e_87a9,
    0x82a7_fdcc,
    0x8d90_2fb4,
    0x120d_b1e4,
    0x70ab_4dbf,
    0x4d3e_dacb,
    0x6733_e027,
    0x539c_5006,
    0xd0a5_c805,
    0x4093_5c31,
    0xcf8f_ca2e,
    0x9ae8_273f,
    0xcb59_4fba,
    0xd401_a1c4,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x7000_0000,
    0xb800_0000,
    0xd400_0000,
    0xaa00_0000,
    0x6b00_0000,
    0xff80_0000,
    0xc2c0_0000,
    0x9e20_0000,
    0x4450_0000,
    0xf598_0000,
    0xaf84_0000,
    0x4ac2_0000,
    0x5225_0000,
    0x4a53_8000,
    0x8c9d_c000,
    0xef02_a000,
    0xdd87_5000,
    0x65c6_5800,
    0x6fa4_7c00,
    0xff93_d600,
    0x2b3a_5100,
    0x7c93_7280,
    0x88be_f4c0,
    0xd853_8020,
    0x739d_c010,
    0x1a82_a028,
    0x0447_501c,
    0xbc66_582e,
    0x3d34_7c35,
    0x3e2b_d62a,
    0xabee_511a,
    0x3c49_72bf,
    0xb7df_f4f0,
    0x46e2_0007,
    0xe975_0001,
    0x4a4b_8015,
    0xfad9_c037,
    0x7c60_a03c,
    0xdd32_5021,
    0xee2d_d838,
    0x63ed_bc39,
    0x504b_7604,
    0xc9dc_0107,
    0x87e4_aabe,
    0x7df2_48ca,
    0x7709_7622,
    0xa639_0131,
    0xa617_2aa5,
    0x6cff_88ea,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x1000_0000,
    0x4800_0000,
    0x5400_0000,
    0x9600_0000,
    0xdb00_0000,
    0x1d80_0000,
    0x7940_0000,
    0xd960_0000,
    0xf050_0000,
    0x22a8_0000,
    0xb584_0000,
    0xfd46_0000,
    0x6763_0000,
    0x6f50_8000,
    0xe12a_4000,
    0x43c6_a000,
    0xafa2_b000,
    0x3575_d800,
    0x8918_6c00,
    0xddbd_8a00,
    0x454e_6b00,
    0x8d12_3280,
    0x85ca_4d40,
    0xbad0_8020,
    0x0c6a_4030,
    0x6ca6_a018,
    0x94f2_b004,
    0x425d_d812,
    0x11dc_6c15,
    0x6f9b_8a25,
    0x097d_6b36,
    0xdd6a_b287,
    0xa824_0d5e,
    0xdd30_2016,
    0x34fb_f00c,
    0x142b_f810,
    0x4944_9c29,
    0x2160_f22d,
    0x9c53_b70c,
    0xb8ac_e0be,
    0xe485_0a4e,
    0xf9c1_18b7,
    0x4ea2_9645,
    0x09f1_6a83,
    0xacdb_616a,
    0x311b_2a15,
    0x11bc_db1d,
    0xaf4f_eab3,
    0x8416_215f,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x1000_0000,
    0x6800_0000,
    0xa400_0000,
    0x2600_0000,
    0x8f00_0000,
    0x9280_0000,
    0x61c0_0000,
    0xfce0_0000,
    0x6ff0_0000,
    0x8978_0000,
    0xa684_0000,
    0xefc6_0000,
    0x77e5_0000,
    0xcb70_8000,
    0x0fbb_4000,
    0x6ce1_2000,
    0xc7f7_3000,
    0x8d79_7800,
    0x9080_1400,
    0x08c6_4e00,
    0x4167_c700,
    0x8cb2_cf80,
    0x7c5b_73c0,
    0x9190_8020,
    0x2f4b_4030,
    0xd719_2028,
    0x10b3_3004,
    0xf65f_781a,
    0x2c95_1429,
    0x6cce_ce09,
    0x6758_8723,
    0x9d15_efa4,
    0xad89_43d8,
    0x2b79_781f,
    0xdf80_142b,
    0x3a46_4e0a,
    0x30a7_c72d,
    0x1852_cfa1,
    0xb7ab_73f4,
    0x3ee8_801b,
    0x06cf_4010,
    0xaa5f_2017,
    0x0696_302d,
    0xc1cf_f806,
    0x4cde_5416,
    0x8957_ee29,
    0x062b_b71a,
    0xffaa_97bc,
    0x4aec_57da,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0xf000_0000,
    0xa800_0000,
    0x3400_0000,
    0x2a00_0000,
    0xc300_0000,
    0x6b80_0000,
    0x6740_0000,
    0x4160_0000,
    0x8330_0000,
    0x4928_0000,
    0x0f84_0000,
    0x3546_0000,
    0x0e67_0000,
    0xaeb7_8000,
    0x5b6d_4000,
    0xf865_a000,
    0x53b7_5000,
    0xc9e9_1800,
    0x6fa0_dc00,
    0x8210_7a00,
    0x72fc_ab00,
    0x0dde_c980,
    0xef0b_1140,
    0x0dd7_8020,
    0x1f5d_4030,
    0xb8cd_a038,
    0x3c73_503c,
    0x544f_182a,
    0x72b7_dc0d,
    0x656f_fa0a,
    0x0165_eb30,
    0xa335_699a,
    0x592f_4159,
    0x5787_1830,
    0xa943_dc10,
    0x1061_fa2a,
    0x47b6_eb3f,
    0xf3ec_e9a7,
    0xf4a1_014e,
    0x7593_3801,
    0x0bbe_cc16,
    0xa5ba_c21c,
    0xc4bc_2731,
    0x4838_2b88,
    0x36fe_2676,
    0x4fda_9398,
    0xf80a_aa5f,
    0xbc52_718c,
    0x131c_9d6d,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x3000_0000,
    0xe800_0000,
    0xcc00_0000,
    0x5e00_0000,
    0x3900_0000,
    0x4380_0000,
    0x8fc0_0000,
    0x75e0_0000,
    0x6890_0000,
    0x10e8_0000,
    0x9784_0000,
    0x95c2_0000,
    0xcee1_0000,
    0x9411_8000,
    0xc1af_4000,
    0xbc22_6000,
    0x6070_f000,
    0xb9f8_c800,
    0xb7af_9c00,
    0x2925_3e00,
    0x6df6_cf00,
    0xd739_3480,
    0xa5cb_8f40,
    0x5c71_8020,
    0x6fff_4010,
    0x52aa_6008,
    0xeca4_f00c,
    0xff32_c83a,
    0x735a_9c33,
    0x259e_be17,
    0x43fc_8f0e,
    0x5ca8_d490,
    0x2da5_3f63,
    0xa8b2_a83d,
    0x869b_6c0a,
    0xfb7f_f60c,
    0x0fe8_5329,
    0xb905_8a9f,
    0x0386_0040,
    0xafc0_d492,
    0x45e1_3f6e,
    0x8090_a817,
    0xdcea_6c27,
    0xc986_7601,
    0xacc3_1308,
    0x8d65_eaa3,
    0x1bd7_f043,
    0xb449_9cb7,
    0xd4b1_e367,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x1000_0000,
    0x4800_0000,
    0x3400_0000,
    0xe200_0000,
    0xaf00_0000,
    0xdf80_0000,
    0x1cc0_0000,
    0x5220_0000,
    0xfed0_0000,
    0xbaa8_0000,
    0x7d84_0000,
    0xd3c6_0000,
    0x3da5_0000,
    0xba10_8000,
    0x948a_4000,
    0x5555_a000,
    0x2469_1000,
    0x30a4_7800,
    0xaa90_7c00,
    0xe7cf_a600,
    0x43b7_b100,
    0xf49c_a680,
    0xa2d8_0d40,
    0x20b8_8020,
    0x390e_4030,
    0x6e93_a028,
    0x3dcc_1004,
    0x20b4_f812,
    0xa51a_3c0d,
    0x8f1a_0638,
    0xd41e_a12b,
    0x4998_deb7,
    0xea58_7147,
    0x2fff_2634,
    0xf9ed_f10f,
    0xf361_0686,
    0xdf35_1d5b,
    0x69da_f806,
    0x353b_3c32,
    0x0ecc_863e,
    0x5931_e10a,
    0x0cdd_feb0,
    0xc1bb_2143,
    0x778e_fe00,
    0xc4d4_9d0e,
    0xa9aa_d888,
    0xd402_d04c,
    0x9201_f8af,
    0x5700_8065,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xb000_0000,
    0x8800_0000,
    0xa400_0000,
    0x4a00_0000,
    0x5f00_0000,
    0x9480_0000,
    0x90c0_0000,
    0x71e0_0000,
    0x89f0_0000,
    0x4a98_0000,
    0x9a84_0000,
    0x55c2_0000,
    0xa261_0000,
    0x11b5_8000,
    0xcdbc_4000,
    0xd391_2000,
    0x1728_5000,
    0x293f_f800,
    0xab57_2400,
    0x52cb_c600,
    0xd2ce_2f00,
    0x92c9_df80,
    0xb2ce_ccc0,
    0x02cd_8020,
    0x8ac8_4010,
    0x2ecb_2008,
    0x64cd_502c,
    0x3bc8_7822,
    0xaf4a_6429,
    0x3f8f_6612,
    0x4e6a_3f17,
    0xc79f_07a5,
    0x8d05_b8e4,
    0x1783_be3c,
    0x4244_4b32,
    0xe026_b99a,
    0xf194_f3ca,
    0x3c2a_8797,
    0xefb9_f8d1,
    0xf892_9e3e,
    0xd1ac_1b18,
    0x7af9_41bb,
    0x2833_d7e4,
    0xfaf9_4186,
    0x6833_d7e6,
    0xdaf9_4199,
    0xd833_d7dd,
    0x52f9_4182,
    0x7c33_d7d7,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x3000_0000,
    0xb800_0000,
    0x2c00_0000,
    0x2e00_0000,
    0xe700_0000,
    0x2e80_0000,
    0xa6c0_0000,
    0x58e0_0000,
    0x61b0_0000,
    0xf8c8_0000,
    0x5c84_0000,
    0xb7c6_0000,
    0x2d65_0000,
    0x4ff1_8000,
    0x75ed_c000,
    0x4955_6000,
    0x417f_7000,
    0x184e_3800,
    0x4d42_f400,
    0xe9a3_f600,
    0x4e17_2700,
    0x55de_3d80,
    0xadd8_5e40,
    0xe1d9_8020,
    0x5fd9_c030,
    0x30db_6028,
    0x8a5e_700c,
    0x2e99_b82e,
    0xbf7a_340b,
    0x174f_160b,
    0x67c1_9739,
    0xc563_658b,
    0x4bf0_da69,
    0xffed_ce36,
    0x1455_d328,
    0x8afd_cb96,
    0x590f_795b,
    0x7ae7_bda3,
    0x58b1_9e70,
    0x294a_e010,
    0xc8c3_b018,
    0xdfe4_d81f,
    0xdf31_443e,
    0xd60f_2e35,
    0x9062_6339,
    0xd477_1384,
    0x1caf_3d54,
    0xdaf7_1385,
    0x4a6f_3d61,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x3000_0000,
    0x8800_0000,
    0xec00_0000,
    0x1a00_0000,
    0xb500_0000,
    0x4680_0000,
    0xf7c0_0000,
    0xe320_0000,
    0x1c90_0000,
    0x3578_0000,
    0x8884_0000,
    0x7cc2_0000,
    0x06a7_0000,
    0x32d1_8000,
    0x5a1c_4000,
    0x2a73_6000,
    0x5bca_d000,
    0xf1ee_a800,
    0xa9fd_b400,
    0x6a42_fe00,
    0x0964_f900,
    0x55f2_f480,
    0x808e_a3c0,
    0x3809_8020,
    0xccc8_4010,
    0x2669_6038,
    0x0eb9_d00c,
    0xe1a5_2822,
    0x8d52_f43b,
    0x215a_1e06,
    0x3391_692d,
    0x86fc_bc91,
    0xd9c2_87fd,
    0x5827_3618,
    0x7117_9d17,
    0xf73c_a2b5,
    0xfde0_eeee,
    0x6b30_0a9d,
    0x672a_5aea,
    0x325b_7492,
    0x2216_e3e7,
    0x06b8_e021,
    0x4da5_900c,
    0x7756_4818,
    0xa458_2437,
    0xfd14_b622,
    0x9d3c_dd0b,
    0x20e6_42a5,
    0xf1b2_7ef6,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x5000_0000,
    0xf800_0000,
    0xec00_0000,
    0xa200_0000,
    0xcd00_0000,
    0x7a80_0000,
    0x8640_0000,
    0x8320_0000,
    0x3e50_0000,
    0x38b8_0000,
    0x6784_0000,
    0xc4c6_0000,
    0x8963_0000,
    0x4f72_8000,
    0x33ef_c000,
    0xc9bb_6000,
    0x8707_1000,
    0x0383_6800,
    0x82c2_5400,
    0xc261_7200,
    0x1ef4_b900,
    0xb42b_8280,
    0x355e_bdc0,
    0xa9b4_8020,
    0xb78c_c030,
    0x9c49_e018,
    0x62a8_d014,
    0xb118_083e,
    0xd795_443b,
    0x5b5a_1a28,
    0x36b2_ed33,
    0xc80c_f09e,
    0x2489_04e1,
    0xd1cd_8280,
    0x8f6d_bdff,
    0xc4fe_0036,
    0x35a7_003d,
    0xea14_8017,
    0xbe9c_c00d,
    0x6751_e005,
    0xcc3c_d004,
    0xeec6_0804,
    0xa062_4433,
    0xb3f6_9a3e,
    0x9eaa_2d0e,
    0x4b1b_109e,
    0xc696_d4d1,
    0x2bd9_0ab2,
    0x69f0_39c6,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x5000_0000,
    0x8800_0000,
    0x3400_0000,
    0x1200_0000,
    0x4f00_0000,
    0x0880_0000,
    0x2e40_0000,
    0x00a0_0000,
    0x8a30_0000,
    0xc3b8_0000,
    0x6f84_0000,
    0x62c6_0000,
    0x04e7_0000,
    0x2992_8000,
    0xef0c_4000,
    0xeb7d_a000,
    0x5862_9000,
    0x85d3_7800,
    0xc8ad_c400,
    0x0dcb_b200,
    0x2f9f_e500,
    0x91f0_6180,
    0x3adf_75c0,
    0xabd4_8020,
    0x61ab_4030,
    0xb84f_2038,
    0x165e_d014,
    0x3f96_d822,
    0xaa0b_540d,
    0xf0fe_ca04,
    0x08a5_2113,
    0x7e31_5382,
    0x31b8_d0cb,
    0x7087_41a0,
    0xe245_a5d2,
    0x1ea4_5828,
    0x3b37_143f,
    0x2a3b_6a02,
    0x2043_b118,
    0x19a4_2bac,
    0xe7b2_14e5,
    0x467e_739c,
    0xe7e6_00fe,
    0xaf11_99bb,
    0x184e_f1ff,
    0x665a_9209,
    0x0792_351b,
    0x460a_3992,
    0x5efb_61de,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0xd000_0000,
    0x3800_0000,
    0xd400_0000,
    0x7a00_0000,
    0x9100_0000,
    0x0680_0000,
    0x4740_0000,
    0x9660_0000,
    0x3b30_0000,
    0x5ba8_0000,
    0x1f84_0000,
    0xbdc6_0000,
    0xa727_0000,
    0x4256_8000,
    0xb519_c000,
    0x40ea_a000,
    0x0fe1_d000,
    0x61f5_8800,
    0x1509_b400,
    0xcf11_7a00,
    0x9a7d_d300,
    0x715f_a980,
    0x6d09_0540,
    0x3b10_8020,
    0xd07e_c030,
    0x085c_2038,
    0x8788_1034,
    0xd257_280e,
    0xad1c_6435,
    0xa4ea_f21e,
    0x9de7_6724,
    0x1cf6_5381,
    0xbd8e_1651,
    0x6355_0985,
    0x9b98_d57e,
    0x0bad_080e,
    0xe783_7403,
    0x89c3_5a19,
    0x0d26_c328,
    0xeb50_0180,
    0x679f_a17c,
    0x7da8_522f,
    0x0882_b706,
    0x5c45_db84,
    0x09e0_a26e,
    0x46f2_f3ae,
    0x1c8c_c66a,
    0x8dd0_01a3,
    0x30df_a155,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x3000_0000,
    0xf800_0000,
    0x4c00_0000,
    0x8a00_0000,
    0xd900_0000,
    0x1780_0000,
    0x6e40_0000,
    0xeca0_0000,
    0x2a10_0000,
    0x8b18_0000,
    0x6a84_0000,
    0xd7c2_0000,
    0xb5e7_0000,
    0x0631_8000,
    0x3fcf_c000,
    0x6bfe_6000,
    0x5132_5000,
    0x8f4b_c800,
    0xed3a_3c00,
    0xa753_3200,
    0x113f_c500,
    0x9555_e080,
    0x643a_80c0,
    0x38d3_8020,
    0x2b78_c010,
    0x8ff7_e038,
    0xe529_900c,
    0x314f_a83e,
    0xb23b_6c13,
    0x03d3_7a22,
    0x81f9_3936,
    0xf833_3285,
    0x80cb_d5db,
    0xff78_489b,
    0x39f6_ecda,
    0xae29_7a3a,
    0x83ca_3906,
    0xb9f8_b2b3,
    0x1437_15f2,
    0xdacd_a8bd,
    0xee78_7cfa,
    0x9a77_5225,
    0x066e_9525,
    0x3c6d_a89b,
    0x5d68_7cf5,
    0xe6ef_520c,
    0x32aa_9521,
    0xff0f_a8ad,
    0x8e9f_7ccf,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x1000_0000,
    0xc800_0000,
    0x2400_0000,
    0x2e00_0000,
    0xe100_0000,
    0xc080_0000,
    0x9d40_0000,
    0x4b60_0000,
    0xea30_0000,
    0x8488_0000,
    0x8f84_0000,
    0xfcc2_0000,
    0x36a1_0000,
    0x2c10_8000,
    0xedde_4000,
    0xc53d_2000,
    0xd9cf_7000,
    0xa4e0_0800,
    0x26f5_8400,
    0x6a2b_2a00,
    0x4f91_bb00,
    0x1b1b_4180,
    0x3c9e_7c40,
    0xd45a_8020,
    0x14fb_4010,
    0x35ef_a008,
    0x12b0_3004,
    0x85cd_a832,
    0x36e4_b409,
    0x25f6_020b,
    0x51ab_4f38,
    0x1550_63b0,
    0xc8ba_4367,
    0xee0a_ebb2,
    0x8dc4_876a,
    0x7e26_6189,
    0xb551_0c77,
    0x98ba_8825,
    0x060e_c410,
    0xb9c4_8a3a,
    0x9821_8b0e,
    0x7056_e9b8,
    0x763a_c860,
    0x7a4c_8220,
    0x3220_0f3c,
    0xef57_c391,
    0xbfbe_7369,
    0x138d_4398,
    0x0205_3342,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x9000_0000,
    0x2800_0000,
    0x9400_0000,
    0x3e00_0000,
    0xed00_0000,
    0xd780_0000,
    0x13c0_0000,
    0xbe20_0000,
    0x1cb0_0000,
    0x4ed8_0000,
    0x6484_0000,
    0x5946_0000,
    0xe261_0000,
    0x9d54_8000,
    0x6e49_4000,
    0x71e8_a000,
    0x779b_f000,
    0xf6e4_6800,
    0x5c15_3c00,
    0xa02c_5e00,
    0x6eb8_9100,
    0x5ed6_f580,
    0x838f_4ec0,
    0x02ca_8020,
    0x2cac_4030,
    0x83fa_2008,
    0x12b3_b024,
    0xdbd8_480a,
    0x2f07_8c25,
    0x7080_960f,
    0xa746_5d3b,
    0x2f66_c3b5,
    0xdad6_e3c4,
    0x558e_2b8f,
    0x5bce_9ff7,
    0x552c_d5bb,
    0x553c_fecd,
    0xef12_c834,
    0xeaab_cc09,
    0x32fa_b62a,
    0xdf35_ed21,
    0xa31e_8bac,
    0x17a1_6fc7,
    0x0276_bd88,
    0x977c_c2df,
    0xd3f4_1609,
    0x15bf_1d15,
    0x3056_63bf,
    0x59c9_13c7,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x3000_0000,
    0x4800_0000,
    0xac00_0000,
    0xd200_0000,
    0xb300_0000,
    0x0280_0000,
    0x3840_0000,
    0x63e0_0000,
    0x6f10_0000,
    0x98e8_0000,
    0x3384_0000,
    0x31c6_0000,
    0x5d27_0000,
    0x7ab1_8000,
    0xbd1a_4000,
    0xd9f9_6000,
    0x726c_9000,
    0xb7c0_9800,
    0x1820_9400,
    0x5535_0200,
    0xd6dd_bf00,
    0x7bde_c880,
    0xe858_af40,
    0xc99f_8020,
    0x0cb9_4030,
    0xa20e_e038,
    0x2911_d00c,
    0x3de8_7812,
    0x2c06_442b,
    0x1204_fa34,
    0x5305_bb2c,
    0x3285_5280,
    0x7046_844e,
    0xcfe3_cab8,
    0xbd11_106b,
    0x2bef_48be,
    0x3102_ef70,
    0x0986_e006,
    0x3ec5_d000,
    0x15a6_7800,
    0x25f5_4424,
    0xea7b_7a10,
    0x43ac_fb15,
    0xeae3_b281,
    0x6293_547f,
    0xe82d_b28b,
    0x0f20_545c,
    0x09b2_32b4,
    0x5f99_1446,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x1000_0000,
    0xe800_0000,
    0xb400_0000,
    0x3a00_0000,
    0x9f00_0000,
    0x8580_0000,
    0x3dc0_0000,
    0x38e0_0000,
    0x34f0_0000,
    0x7a28_0000,
    0x7884_0000,
    0x4b42_0000,
    0x96a3_0000,
    0xd8d0_8000,
    0x0abf_4000,
    0x9f19_a000,
    0x6c4f_d000,
    0x8e31_f800,
    0xcb4d_ac00,
    0x77b1_2e00,
    0x0889_a700,
    0x1255_9780,
    0x7af9_d940,
    0x5e3a_8020,
    0xa258_4010,
    0x03eb_2018,
    0xc263_9004,
    0xdcb0_d83a,
    0xf709_3c2d,
    0xd093_760e,
    0xd79c_db27,
    0xbf0f_c1a1,
    0x5495_924f,
    0x759d_19ae,
    0x6c0f_ae5d,
    0xb716_efa6,
    0x5958_354a,
    0x746a_8e10,
    0xa4a5_771c,
    0xa3d4_ef9a,
    0x3d3b_354c,
    0x99da_0e12,
    0x032a_370e,
    0xac05_4f9a,
    0x3600_e553,
    0x9901_f636,
    0x8480_9b23,
    0xf546_e190,
    0xaba5_024b,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x7000_0000,
    0xc800_0000,
    0x5400_0000,
    0xf200_0000,
    0x3900_0000,
    0xe980_0000,
    0x44c0_0000,
    0x59e0_0000,
    0x5f10_0000,
    0xe4b8_0000,
    0xb684_0000,
    0x4642_0000,
    0xdda3_0000,
    0x13b3_8000,
    0x3a8e_4000,
    0xf2ce_a000,
    0x8069_9000,
    0x195c_c800,
    0x9391_cc00,
    0xaffe_e600,
    0x00a2_af00,
    0xe030_0880,
    0x034e_9dc0,
    0x08a9_8020,
    0x3eb9_4010,
    0xeb87_2018,
    0xf5c0_d01c,
    0x8463_e832,
    0x99d5_1c15,
    0x4c5f_0e3c,
    0x5414_b30e,
    0x143c_86ba,
    0x0bc4_6ed1,
    0xe363_a6b6,
    0x4750_bec7,
    0x0e1a_4e81,
    0xa3b2_a2e1,
    0xd28c_c09b,
    0xb6cf_51ee,
    0xca6f_6632,
    0xbc5f_ef19,
    0xdc15_2890,
    0x203d_4df6,
    0x89c1_e804,
    0x1266_1c29,
    0xfad4_8e1a,
    0xb8de_f339,
    0xc350_268e,
    0x641e_fec9,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x3000_0000,
    0x5800_0000,
    0x8c00_0000,
    0xee00_0000,
    0x7b00_0000,
    0x2880_0000,
    0xf4c0_0000,
    0x9460_0000,
    0xe270_0000,
    0x8628_0000,
    0xe984_0000,
    0x0546_0000,
    0xfd21_0000,
    0xe151_8000,
    0x747a_c000,
    0x6178_6000,
    0xf2fd_7000,
    0x0eb8_d800,
    0x5e1b_c400,
    0x700f_e600,
    0x9850_8300,
    0x19f8_4380,
    0x8e3a_b940,
    0x5edf_8020,
    0xb66f_c030,
    0xb727_e008,
    0x4052_b00c,
    0x55ff_3816,
    0x4039_7423,
    0x15d8_de3b,
    0xc6ed_f71e,
    0xcfe6_9d8a,
    0x3a36_4e7d,
    0xcc88_9d85,
    0xee93_4e48,
    0x089f_1d89,
    0x57c8_8e46,
    0xd0b6_fdbf,
    0x5d4f_3e60,
    0x5176_45bd,
    0x8aa9_8a5c,
    0x0741_7b97,
    0xb822_cd40,
    0xfad6_de29,
    0x4c38_f713,
    0x3bd9_1db7,
    0x9de9_8e68,
    0xd767_7d84,
    0x96f5_fe6e,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x7000_0000,
    0x7800_0000,
    0x6400_0000,
    0xf200_0000,
    0xeb00_0000,
    0x0c80_0000,
    0x79c0_0000,
    0x6d20_0000,
    0x6fb0_0000,
    0x3dc8_0000,
    0xb984_0000,
    0x1042_0000,
    0x3561_0000,
    0x66d3_8000,
    0xbd1b_c000,
    0x659f_2000,
    0xf659_9000,
    0x4478_5800,
    0xdd4c_e400,
    0x6e44_8e00,
    0x2063_0900,
    0x3f56_8d80,
    0xbd5a_4640,
    0x78f9_8020,
    0xfc8e_c010,
    0x1766_a008,
    0xc5d7_501c,
    0x8d9e_f81e,
    0xfa5b_b419,
    0xfa7a_763c,
    0xa848_bd3a,
    0x67c4_fb83,
    0x2826_fb5e,
    0x3e37_7bbb,
    0x218d_3b4b,
    0x32e0_5ba7,
    0x0390_ab62,
    0x81fa_03b2,
    0x0b0d_4f58,
    0x4a25_0d93,
    0xbd31_8640,
    0x610e_a010,
    0xd523_500c,
    0x6bb4_f823,
    0x9fce_b40d,
    0x5a83_f62e,
    0x00c6_7d00,
    0xdaa2_5ba0,
    0x12f1_ab73,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xb000_0000,
    0x1800_0000,
    0x1c00_0000,
    0x2200_0000,
    0x8700_0000,
    0xac80_0000,
    0x5840_0000,
    0x2fe0_0000,
    0xfab0_0000,
    0x5068_0000,
    0x7044_0000,
    0x6be2_0000,
    0xe4b1_0000,
    0x456d_8000,
    0x43c4_c000,
    0x8322_e000,
    0xb110_1000,
    0x1739_b800,
    0x4599_a400,
    0xfb4c_2200,
    0x8557_6f00,
    0x62dd_6d80,
    0xb42f_a740,
    0x8da2_e020,
    0x2e50_1010,
    0xb459_b808,
    0x5769_a42c,
    0x9cc4_2206,
    0x13a3_6f07,
    0x7b57_6d88,
    0xa7da_a761,
    0x0fad_600b,
    0xd165_d006,
    0x5df6_d803,
    0x5f0d_7412,
    0x58b7_7a12,
    0x976e_db1b,
    0xfcc0_f792,
    0x83a5_6c58,
    0xd351_af9a,
    0xa3d9_d856,
    0x31ab_b583,
    0x7462_d36e,
    0x7675_9a3f,
    0xabce_cb36,
    0x2f11_4fa2,
    0x4238_c852,
    0x561f_8d8c,
    0xa38f_b75d,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0xf000_0000,
    0xd800_0000,
    0x3400_0000,
    0xc200_0000,
    0x7b00_0000,
    0x2080_0000,
    0xa8c0_0000,
    0x76e0_0000,
    0x5050_0000,
    0xccf8_0000,
    0xfcc4_0000,
    0x84e6_0000,
    0x1357_0000,
    0x287f_8000,
    0x4e02_c000,
    0xbd07_a000,
    0xa181_1000,
    0x3744_5800,
    0xe4a7_c400,
    0xc174_e600,
    0x08cd_a700,
    0xb3ad_5a80,
    0xe2bd_63c0,
    0x93e7_a020,
    0x05d1_1030,
    0xd9bc_5838,
    0x9363_c43c,
    0xbd12_e636,
    0x875a_a70d,
    0x2f32_dab0,
    0x87ef_a3de,
    0xc298_0028,
    0xf054_001a,
    0x1cfe_0025,
    0x34c3_0028,
    0x98e1_8005,
    0x3d51_c032,
    0xa57e_2011,
    0xd784_d01a,
    0x4e44_7802,
    0x5f20_1439,
    0xb931_1e32,
    0x0eec_733c,
    0xa11a_64be,
    0xbc11_c0c6,
    0xd8df_bcb1,
    0x5d77_c4f6,
    0xe6cd_7abe,
    0xdeaa_b3e7,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x3000_0000,
    0x3800_0000,
    0x0400_0000,
    0x8e00_0000,
    0x1300_0000,
    0xa280_0000,
    0xbf40_0000,
    0x2a20_0000,
    0x4ad0_0000,
    0x5448_0000,
    0x2344_0000,
    0xb026_0000,
    0x3fd7_0000,
    0xe9c9_8000,
    0x8c85_c000,
    0xbc46_2000,
    0x60a3_7000,
    0xf991_1800,
    0xcc6c_d400,
    0xf091_da00,
    0xdbeb_2100,
    0x1251_ce80,
    0x6e08_3640,
    0x6ce6_2020,
    0x6133_7030,
    0xd1f9_1838,
    0x82f8_d40c,
    0x007f_da0e,
    0x6f38_2101,
    0x4d1e_4ea3,
    0x3bca_f644,
    0xe581_8008,
    0x5bc1_c01f,
    0x5a60_2032,
    0x7874_701e,
    0x04d8_981b,
    0xe8a9_1409,
    0x4a77_fa0f,
    0x5dd8_510b,
    0x3728_d692,
    0x74b0_e24c,
    0x5239_fa05,
    0xec9b_513a,
    0xce0f_5693,
    0x7ce6_2277,
    0x8930_5a3e,
    0xddfa_e108,
    0x30f9_eea5,
    0x9978_4670,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x1000_0000,
    0xf800_0000,
    0x9400_0000,
    0x1600_0000,
    0x4700_0000,
    0x5480_0000,
    0x46c0_0000,
    0x0a60_0000,
    0xed90_0000,
    0xdd58_0000,
    0x1ac4_0000,
    0xa066_0000,
    0x7095_0000,
    0x5cd8_8000,
    0xa183_c000,
    0x6b42_a000,
    0x9325_b000,
    0x67b2_b800,
    0xd56d_6400,
    0xa7ea_9600,
    0x8e2a_e300,
    0x1cca_5480,
    0x259b_cec0,
    0x5ba2_a020,
    0x2b75_b030,
    0x520a_b828,
    0x33f9_6404,
    0x7c34_963e,
    0xdb2b_e325,
    0x214c_d485,
    0x44d9_0ed1,
    0x4586_8035,
    0x3542_c021,
    0xa824_202a,
    0x4937_703f,
    0x56ae_9809,
    0xa80e_1423,
    0x36fa_0e2d,
    0xd9b5_f70d,
    0x9e6e_da82,
    0xc168_f9f9,
    0x71ee_5ab8,
    0x692f_39ef,
    0x584a_faa6,
    0x9b5f_89c7,
    0xc5c0_c2b7,
    0xd0e1_2dee,
    0xc850_f4a3,
    0x7dba_7ee1,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0xf000_0000,
    0x8800_0000,
    0x7400_0000,
    0xa600_0000,
    0x4100_0000,
    0x8980_0000,
    0xa9c0_0000,
    0xdaa0_0000,
    0xfa70_0000,
    0xf228_0000,
    0xcfc4_0000,
    0xbba2_0000,
    0xe3f3_0000,
    0x23ef_8000,
    0xe960_4000,
    0x93d1_a000,
    0xf6de_3000,
    0x24a9_8800,
    0x7286_0c00,
    0x0347_ee00,
    0xf5e7_6500,
    0xc596_1b80,
    0xdcbc_3d40,
    0x81f9_a020,
    0x891a_3010,
    0x770b_8818,
    0x1575_0c3c,
    0x0ea8_6e22,
    0x2987_251d,
    0x79c7_bba9,
    0xc2a2_0d50,
    0xf670_2802,
    0xa82c_3c3a,
    0x5cc4_662e,
    0xd526_6902,
    0x82b4_759e,
    0xd90c_186e,
    0x6073_9ba7,
    0x412b_7d78,
    0x3145_8012,
    0xa2e7_403c,
    0xe514_2028,
    0x78f9_7022,
    0xdc9d_a83e,
    0x9ccf_7c22,
    0x50d2_4625,
    0xc05c_193f,
    0x29ee_5dad,
    0x2267_2459,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x1000_0000,
    0xa800_0000,
    0x2c00_0000,
    0x5200_0000,
    0x5f00_0000,
    0x7680_0000,
    0x5a40_0000,
    0xe360_0000,
    0xadf0_0000,
    0x4a78_0000,
    0x7044_0000,
    0x1862_0000,
    0xd573_0000,
    0xa538_8000,
    0x3ea1_4000,
    0xe753_6000,
    0x2b29_9000,
    0xb26e_7800,
    0xed88_f400,
    0xb13e_b200,
    0xa8a0_0b00,
    0xa653_5780,
    0x40ae_47c0,
    0x69ab_6020,
    0x0e2d_9010,
    0xf7ec_7818,
    0xf34b_f404,
    0x471e_322a,
    0x38b5_4b0b,
    0x379a_3794,
    0xcbf0_d7d7,
    0xf37f_983d,
    0xffc7_2406,
    0xada1_2a20,
    0x93d7_2f2f,
    0xe66a_7db8,
    0x1b8d_68d7,
    0xe03b_1db2,
    0x6b27_f8f2,
    0x5195_e58c,
    0xf10a_4ccd,
    0x707a_3793,
    0x2340_d7fe,
    0x4ce7_9838,
    0x6833_242f,
    0xb4db_2a11,
    0xb710_2f11,
    0x4348_fd9b,
    0xdf1b_28fe,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0xb000_0000,
    0xe800_0000,
    0xe400_0000,
    0xde00_0000,
    0xbb00_0000,
    0xe880_0000,
    0x2440_0000,
    0x4ba0_0000,
    0x7c30_0000,
    0xfd68_0000,
    0xc244_0000,
    0x8ca6_0000,
    0xa6b7_0000,
    0xe82d_8000,
    0xec63_4000,
    0x6351_2000,
    0x02b9_f000,
    0x82bc_5800,
    0x42ba_0400,
    0xa2bb_0200,
    0x12bc_2d00,
    0xfab9_f980,
    0x1eb8_4f40,
    0xc0b9_2020,
    0x7bbd_f030,
    0x933a_5838,
    0xb77d_042c,
    0xfcde_823a,
    0x80eb_6d39,
    0x7d86_d9b7,
    0xbfc2_bf6e,
    0x3366_f81a,
    0x95d7_b439,
    0x7dfb_fa2a,
    0x919c_9933,
    0xf2cf_8385,
    0xf077_9649,
    0x72cf_83b4,
    0x3077_9677,
    0x92cf_8398,
    0x8077_966e,
    0x7acf_83a8,
    0x6477_967a,
    0xa4cf_838a,
    0xdf77_966b,
    0x4c4f_83a4,
    0xfb37_966f,
    0x07ef_83b9,
    0x8707_9661,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x3000_0000,
    0x9800_0000,
    0x3c00_0000,
    0x6e00_0000,
    0x5300_0000,
    0xb280_0000,
    0xfa40_0000,
    0x5060_0000,
    0x5ed0_0000,
    0xcc08_0000,
    0x8044_0000,
    0x8962_0000,
    0x8d53_0000,
    0x89c9_8000,
    0x53e0_c000,
    0xf313_e000,
    0xdba8_7000,
    0x9837_1800,
    0x7a9b_5400,
    0x4129_3200,
    0x8676_7300,
    0x18fd_ae80,
    0x12fc_9440,
    0x33fb_e020,
    0xec7c_7010,
    0x5fbd_1818,
    0xe31c_540c,
    0x45ea_b226,
    0xba51_b30f,
    0x494d_ce9b,
    0xc4a3_2454,
    0xeaf4_980c,
    0x69bc_942e,
    0xac19_520c,
    0xc969_c31b,
    0xbb12_d695,
    0x0fac_706f,
    0x3237_aa19,
    0x4b9d_e727,
    0x56af_7c96,
    0xa1b6_9766,
    0x6e5b_56ae,
    0xb50c_b07e,
    0x43c4_4a36,
    0x04a5_9736,
    0xcaf0_64a0,
    0x39b9_c37f,
    0x0418_64ad,
    0x6d6d_c34c,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x5000_0000,
    0xe800_0000,
    0x8c00_0000,
    0x9200_0000,
    0x1700_0000,
    0x2680_0000,
    0x9ac0_0000,
    0xbe60_0000,
    0x6bd0_0000,
    0xfe88_0000,
    0x5cc4_0000,
    0xef66_0000,
    0xdc51_0000,
    0xf3ca_8000,
    0xbfe3_4000,
    0x8f92_6000,
    0xce2d_9000,
    0x2f76_3800,
    0x9b38_7400,
    0x519d_b600,
    0x7929_e300,
    0x99f7_a680,
    0xc9ff_2040,
    0x33fa_6020,
    0x68f9_9030,
    0xfc78_3808,
    0x21bd_7414,
    0x5159_363a,
    0x2c4f_a323,
    0xfea1_46a4,
    0xdeb4_f045,
    0xe9da_b829,
    0xf38a_3416,
    0x5145_5627,
    0x5927_330e,
    0xdbf3_fe85,
    0xf6fa_c474,
    0xb979_ee3f,
    0x303c_0702,
    0xbd1c_28bd,
    0xe0ee_b75d,
    0xa710_7096,
    0xd9ef_537a,
    0x5c95_feb8,
    0x66ab_c450,
    0xf8b3_6e34,
    0xc8df_4708,
    0xfc0e_48a3,
    0x3803_2775,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x5000_0000,
    0x9800_0000,
    0x5c00_0000,
    0x0e00_0000,
    0xc500_0000,
    0xe080_0000,
    0x5440_0000,
    0x59a0_0000,
    0xb690_0000,
    0x09d8_0000,
    0x4144_0000,
    0x6122_0000,
    0x1ed5_0000,
    0x0e7a_8000,
    0xaad0_c000,
    0xd478_e000,
    0x05d1_7000,
    0xf3fe_a800,
    0xe212_c400,
    0x8798_c200,
    0xb7e7_7d00,
    0xf031_fc80,
    0xf0ce_fac0,
    0x3b5a_e020,
    0x9e04_7010,
    0xbd04_2828,
    0x4c82_0414,
    0x9240_2226,
    0x58a6_0d17,
    0x0417_5483,
    0x9698_3ef1,
    0x3d60_2218,
    0x6376_0d05,
    0x1aef_54be,
    0xa00c_3ef9,
    0x74ba_2204,
    0x8237_0d17,
    0x2bcf_d4b3,
    0x26dd_fee2,
    0x26c2_423d,
    0x26e7_bd38,
    0x3ab1_1c88,
    0xc38b_8ac9,
    0x817e_4800,
    0x9d57_b43a,
    0x0bbc_6a04,
    0x7db4_b922,
    0x3009_bea3,
    0x0cb8_47c4,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x9000_0000,
    0x3800_0000,
    0xfc00_0000,
    0xea00_0000,
    0x6100_0000,
    0x3080_0000,
    0xcb40_0000,
    0xf0a0_0000,
    0xb010_0000,
    0x3158_0000,
    0x7244_0000,
    0xcc26_0000,
    0x9955_0000,
    0xf4fc_8000,
    0xdcd5_c000,
    0x4139_e000,
    0xa036_5000,
    0x1209_8800,
    0x7fb9_4400,
    0x4c77_3a00,
    0xc12a_1500,
    0x396c_e880,
    0xa448_1ec0,
    0xa59f_e020,
    0x5e23_5030,
    0x6455_0828,
    0x1e7c_8424,
    0xde96_da0e,
    0x4518_453f,
    0xcd63_60ba,
    0x58f4_5ad8,
    0xec6c_5a2c,
    0x4ac8_8502,
    0x11de_0094,
    0x4103_cac8,
    0x6082_3222,
    0x5346_9113,
    0x9ca2_32a1,
    0x6214_5bda,
    0xac5a_809f,
    0xa8c2_0aca,
    0x6665_d21e,
    0x5971_c108,
    0x8fa9_3aa2,
    0x1d29_dfea,
    0x836e_da88,
    0x5d4e_8fed,
    0xf91d_d281,
    0x4767_0bfc,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xb000_0000,
    0xf800_0000,
    0x1c00_0000,
    0x3200_0000,
    0xeb00_0000,
    0x7380_0000,
    0x2140_0000,
    0x7de0_0000,
    0x55b0_0000,
    0x3088_0000,
    0x4244_0000,
    0x8a62_0000,
    0xcaf1_0000,
    0xdc6d_8000,
    0x6b73_c000,
    0xc62a_e000,
    0x0d14_9000,
    0xe6d8_d800,
    0x9679_5c00,
    0x342a_6a00,
    0x8612_bf00,
    0x055b_9580,
    0xff3c_c840,
    0xadc8_e020,
    0xfda5_9010,
    0xecd5_5808,
    0x25fa_9c2c,
    0x7568_8a3e,
    0x6bf2_2f07,
    0x18e9_4d8c,
    0x2bb0_947a,
    0xc18d_0a3c,
    0xaec5_ef18,
    0xbea1_ad97,
    0xab55_0479,
    0x42b8_5212,
    0x858f_7307,
    0x70c1_27a6,
    0xbfa3_2b64,
    0x9fd3_1fb5,
    0xda7e_e745,
    0x2e29_ad8a,
    0x1911_0450,
    0x10da_523f,
    0xe37e_7306,
    0x66ac_a78a,
    0x23d0_eb57,
    0x1879_ffb4,
    0x1d2a_7750,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x5000_0000,
    0x9800_0000,
    0x1c00_0000,
    0x5e00_0000,
    0xab00_0000,
    0x8580_0000,
    0x3cc0_0000,
    0xa660_0000,
    0x2370_0000,
    0xbc88_0000,
    0xd3c4_0000,
    0xc1e2_0000,
    0x5ab7_0000,
    0xfc6a_8000,
    0xcdf0_c000,
    0xa5ca_e000,
    0xf961_f000,
    0x8cf5_d800,
    0x414f_ec00,
    0xd127_8600,
    0x2ad1_0300,
    0x101b_a380,
    0xe6fd_b840,
    0x27c8_e020,
    0xac66_f010,
    0x1277_5838,
    0x300b_2c14,
    0xcf87_6626,
    0xedc3_f307,
    0x7ae6_fb97,
    0xa735_946a,
    0x8caf_0601,
    0xad96_c31f,
    0x31bb_c391,
    0x9e6c_885c,
    0xc8f7_d829,
    0xa348_ec23,
    0x9425_061f,
    0xcc55_c328,
    0x2d5b_43b8,
    0x3e5f_487b,
    0x57dd_b837,
    0x1d1a_dc0c,
    0xc47a_be15,
    0xb888_1f3f,
    0xd1c3_7d8b,
    0xd4e3_9753,
    0x2436_25a3,
    0xdd2f_bb44,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x1000_0000,
    0x3800_0000,
    0xc400_0000,
    0x6e00_0000,
    0x5900_0000,
    0x3680_0000,
    0xb7c0_0000,
    0xb5e0_0000,
    0xc790_0000,
    0xc2f8_0000,
    0x62c4_0000,
    0xe162_0000,
    0x0b55_0000,
    0x9a98_8000,
    0xef15_c000,
    0xe43c_2000,
    0xada2_7000,
    0x1330_4800,
    0xb74d_7400,
    0xfa4f_1e00,
    0x7ac9_1f00,
    0xe009_d480,
    0x256f_53c0,
    0xf03e_2020,
    0x1ba7_7010,
    0x3e30_c828,
    0xc7cc_b404,
    0xe889_3e0e,
    0x53aa_6f31,
    0xa75b_1c9b,
    0x3df6_e7d6,
    0xd42f_9e2d,
    0x3a18_df3d,
    0x25d7_f485,
    0xb958_23f5,
    0xacf6_e81e,
    0xaeaf_c439,
    0x0fdb_f60b,
    0x5b33_db10,
    0xbb4a_a2a5,
    0xd849_48e7,
    0xa1c8_a2af,
    0x1d8c_48dc,
    0x5728_22b1,
    0xf39d_88cc,
    0xb196_02ad,
    0x0ffa_f8c8,
    0xa246_cab3,
    0xdba6_4cd9,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x7000_0000,
    0x0800_0000,
    0xf400_0000,
    0x1200_0000,
    0x6700_0000,
    0x0180_0000,
    0xe840_0000,
    0xb920_0000,
    0xb6f0_0000,
    0x5c68_0000,
    0x4d44_0000,
    0xe7a2_0000,
    0x8331_0000,
    0x9b0b_8000,
    0x3f94_4000,
    0x9fbd_a000,
    0x69dd_9000,
    0x078e_b800,
    0x5557_4c00,
    0x8558_6200,
    0x654b_9900,
    0xbbb4_ef80,
    0x9bce_9f40,
    0xbe77_a020,
    0x74a8_9010,
    0x48a7_3808,
    0x16b2_0c1c,
    0x314e_4202,
    0x99b2_493d,
    0xd4cf_f784,
    0x3bf0_4359,
    0x86eb_7a20,
    0x6281_452a,
    0xb3c2_35a6,
    0xe262_4a71,
    0x6c53_2db5,
    0x6dd9_967e,
    0x5d8e_7795,
    0xe651_0375,
    0xe6df_5a0c,
    0xe209_9504,
    0xf712_ad87,
    0xd778_d64f,
    0x3c3a_57b0,
    0x8e99_d348,
    0x1b2f_c21a,
    0x61e3_093b,
    0xfb13_d7bb,
    0x797c_934c,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0xd000_0000,
    0x8800_0000,
    0x5400_0000,
    0x9600_0000,
    0x3100_0000,
    0x7f80_0000,
    0xfec0_0000,
    0x9120_0000,
    0x8550_0000,
    0x24c8_0000,
    0xbdc4_0000,
    0xf1a2_0000,
    0x9915_0000,
    0xaeae_8000,
    0x2c70_4000,
    0x4d98_a000,
    0xa30d_b000,
    0xe761_0800,
    0x6c30_bc00,
    0x45fe_d600,
    0x35be_f900,
    0xc5dd_4280,
    0x5f6f_ca40,
    0x37d2_a020,
    0xf78c_b010,
    0x5d25_8828,
    0x2f51_fc34,
    0xa7ca_f622,
    0x3d46_0915,
    0x9de2_6aa5,
    0x4b76_864c,
    0xe31f_de3f,
    0x524e_452f,
    0xd083_948c,
    0xa441_3355,
    0x2667_e28b,
    0x0bb7_7a6a,
    0xc73d_2811,
    0xb69c_4c0e,
    0x6f8b_fe3e,
    0x6126_b515,
    0x9d54_bcb0,
    0x58cc_7f50,
    0xafc0_9caa,
    0xdea4_8f57,
    0x8397_b49e,
    0xb9e9_c351,
    0x7290_ca9d,
    0x266a_3663,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x3000_0000,
    0x6800_0000,
    0x3c00_0000,
    0x5200_0000,
    0xf700_0000,
    0x6980_0000,
    0x6640_0000,
    0x9160_0000,
    0x20b0_0000,
    0x5258_0000,
    0xf744_0000,
    0xb1e6_0000,
    0xf271_0000,
    0x5ff9_8000,
    0x4f57_4000,
    0xad2f_e000,
    0x2a3f_9000,
    0x9374_3800,
    0x377f_0c00,
    0x9196_5200,
    0x9a8a_db00,
    0x5929_1d80,
    0xb439_2ec0,
    0x7e71_e020,
    0xa5fa_9030,
    0xa453_b808,
    0xa6ad_4c0c,
    0xd37e_321a,
    0x5797_0b0f,
    0x238d_4594,
    0xa5af_f2fd,
    0x24fd_ea3a,
    0xdcd3_9729,
    0x2069_2fac,
    0xb0db_25c4,
    0x4a83_25ae,
    0xa1c3_22c2,
    0x7220_3210,
    0x1f52_0b3d,
    0x152a_c59f,
    0x6e3d_b2c9,
    0xa575_8a21,
    0xc67e_4700,
    0x6115_77b6,
    0x3049_f9d8,
    0x3089_2f8c,
    0x0a2b_25f4,
    0xfbbb_258d,
    0xb137_22ca,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x7000_0000,
    0xa800_0000,
    0xec00_0000,
    0xb600_0000,
    0x9500_0000,
    0xef80_0000,
    0x61c0_0000,
    0x5520_0000,
    0x9070_0000,
    0xc348_0000,
    0x36c4_0000,
    0xfda6_0000,
    0x4137_0000,
    0xe32b_8000,
    0xacd1_4000,
    0x2ff9_6000,
    0x332e_b000,
    0x54d5_2800,
    0xfbfb_3c00,
    0xb12c_ee00,
    0x33d3_d900,
    0xdb7b_0b80,
    0x1c6b_3640,
    0x7db7_6020,
    0x906d_b030,
    0x7bb0_a838,
    0x4d69_7c1c,
    0x0830_0e2a,
    0x32af_293b,
    0x2412_c3ad,
    0xfb5c_fa65,
    0x139a_461b,
    0x773d_a528,
    0x1f88_85ad,
    0xa061_5f78,
    0x5a12_c3ba,
    0x325c_fa46,
    0x021a_460a,
    0x1ffd_a519,
    0xbb28_8591,
    0x28d1_5f54,
    0x95fa_c3b9,
    0x6028_fa46,
    0x8654_462b,
    0x99be_a522,
    0x33cd_05af,
    0x6383_1f47,
    0x67c6_238c,
    0x8824_0a6b,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0xb000_0000,
    0xd800_0000,
    0xd400_0000,
    0x2a00_0000,
    0xd300_0000,
    0x6280_0000,
    0xcbc0_0000,
    0x59e0_0000,
    0x6450_0000,
    0x07f8_0000,
    0x8944_0000,
    0x6222_0000,
    0x45b5_0000,
    0x07ad_8000,
    0x7cba_c000,
    0xec60_a000,
    0x6f16_5000,
    0x5ade_1800,
    0x4074_5400,
    0x3f4c_3e00,
    0xdd6c_3f00,
    0xd8df_6a80,
    0x7f70_73c0,
    0xb3cd_2020,
    0x87ac_9010,
    0x3cbe_b828,
    0x4c62_042c,
    0xdf12_2636,
    0x82d8_6b35,
    0x9473_548a,
    0x154c_4cf4,
    0x0e6a_4ab8,
    0xba58_e3e2,
    0xb4b1_981e,
    0xea2b_9425,
    0xe3f9_1e1f,
    0x3b44_af3b,
    0xc523_d2a4,
    0xbd37_77d0,
    0xc76a_8633,
    0x93da_3b09,
    0x69f7_4c9d,
    0xe209_18dc,
    0xd549_f497,
    0xee6b_1cce,
    0xaa5b_d294,
    0xdcb3_77cc,
    0xe628_8609,
    0x1dff_3b2a,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x3000_0000,
    0x4800_0000,
    0x8400_0000,
    0x7600_0000,
    0x0300_0000,
    0xa180_0000,
    0x0040_0000,
    0x0ca0_0000,
    0x46f0_0000,
    0xfd48_0000,
    0x85c4_0000,
    0x6ae2_0000,
    0x5153_0000,
    0xe639_8000,
    0xc2ce_4000,
    0x1282_2000,
    0xa9c2_b000,
    0xe8e2_9800,
    0x0c56_cc00,
    0xf0be_6200,
    0x5d0b_f500,
    0x9967_9f80,
    0x3413_fe40,
    0x501b_a020,
    0xd9fc_f010,
    0x5928_b818,
    0x9750_7c0c,
    0xed3e_fa12,
    0x874e_3921,
    0x54c0_7d9d,
    0xee66_4b40,
    0x8b96_1f88,
    0x8759_be50,
    0x7adb_803b,
    0xd09d_400d,
    0x353b_a035,
    0x5b4c_f00c,
    0xbec0_b815,
    0x6764_7c35,
    0x9314_fa0c,
    0xd799_3930,
    0xa2bb_fdaf,
    0x380b_0b7b,
    0x23e5_bfa6,
    0x69d1_4e63,
    0xe6f9_3821,
    0x62aa_3c3e,
    0x3616_da0f,
    0x4d1b_8904,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x1000_0000,
    0xe800_0000,
    0x1400_0000,
    0x2200_0000,
    0x8d00_0000,
    0x1980_0000,
    0xf7c0_0000,
    0x6920_0000,
    0x1470_0000,
    0x7898_0000,
    0xaa44_0000,
    0xf4e6_0000,
    0x9453_0000,
    0xaf68_8000,
    0x541b_4000,
    0x1802_a000,
    0x2c04_1000,
    0xbe07_e800,
    0xab07_0c00,
    0x5e80_5e00,
    0x7742_f900,
    0xa565_db80,
    0x0797_60c0,
    0x1c4a_2020,
    0x316f_5030,
    0x4f1d_4818,
    0xde87_1c04,
    0xb741_b63a,
    0xc566_f505,
    0x1795_0588,
    0xf44a_d9e3,
    0x256b_5ba6,
    0x6d1f_20cd,
    0x5380_0022,
    0xaec0_0031,
    0x32a0_003c,
    0x7eb0_002b,
    0xe038_000f,
    0x5df4_0003,
    0xc75e_0025,
    0xa767_000b,
    0x3a96_801a,
    0x9dcc_4033,
    0x2aac_202b,
    0xf83c_5005,
    0x71f5_c834,
    0x795c_5c12,
    0x0c63_163f,
    0x6412_e531,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x5000_0000,
    0x5800_0000,
    0x4c00_0000,
    0x2e00_0000,
    0x5900_0000,
    0x5780_0000,
    0x2b40_0000,
    0x14a0_0000,
    0xb410_0000,
    0x3ac8_0000,
    0x32c4_0000,
    0xd6e6_0000,
    0xdf31_0000,
    0xe19a_8000,
    0x26ae_c000,
    0x6b30_6000,
    0x139e_7000,
    0x29ad_4800,
    0x79b0_fc00,
    0x195e_fa00,
    0x034c_3500,
    0xa084_5880,
    0xe5c6_0240,
    0x4862_e020,
    0xdbf4_b030,
    0xc27b_2808,
    0xf01f_8c14,
    0xf0e9_3216,
    0x6212_0913,
    0xbfca_c28b,
    0x3344_4756,
    0xb8a3_f0b5,
    0xea16_4e7a,
    0x6bc9_322d,
    0x7142_0909,
    0x9fa2_c290,
    0xbc90_474b,
    0x5b0d_f088,
    0x60a3_4e42,
    0x6615_b20e,
    0x65cd_c931,
    0x7840_2294,
    0x9024_f764,
    0xdbd6_d8bc,
    0x61ac_c24a,
    0x8db4_800b,
    0x0b5b_c003,
    0x7c4c_e02b,
    0xba01_b027,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xf000_0000,
    0x6800_0000,
    0xcc00_0000,
    0xae00_0000,
    0x2700_0000,
    0xf780_0000,
    0x98c0_0000,
    0xa7a0_0000,
    0x5fb0_0000,
    0xdba8_0000,
    0x0944_0000,
    0x6462_0000,
    0xe991_0000,
    0x07df_8000,
    0x44cf_4000,
    0x4150_6000,
    0xa87e_7000,
    0x077b_b800,
    0xacfd_7c00,
    0x223e_e600,
    0xf69e_ad00,
    0x54ad_7580,
    0x52c5_f940,
    0x82a7_e020,
    0xf135_3010,
    0x0be9_d808,
    0x65a2_0c3c,
    0x66b2_de1a,
    0x4328_9133,
    0x5a01_f3ab,
    0x9d04_2449,
    0xfa86_ad9d,
    0xda46_f576,
    0x29e2_be01,
    0x7c56_e13b,
    0xe2fa_4ba4,
    0x9539_584d,
    0xb918_4b88,
    0x9868_5850,
    0xff67_cbbf,
    0x9817_1852,
    0x541f_abb6,
    0x4aed_6844,
    0xc926_1387,
    0xeff1_1468,
    0x674f_7583,
    0x9394_f975,
    0x6ad8_6000,
    0xd64a_7018,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0xb000_0000,
    0x6800_0000,
    0xdc00_0000,
    0x9600_0000,
    0xb900_0000,
    0x1c80_0000,
    0x0f40_0000,
    0xefa0_0000,
    0x8030_0000,
    0xba68_0000,
    0xddc4_0000,
    0xade2_0000,
    0x5913_0000,
    0xaa1d_8000,
    0x458f_4000,
    0x3fd0_e000,
    0x387d_b000,
    0xf85f_4800,
    0x64a8_2400,
    0x4ba0_da00,
    0x3231_ad00,
    0xf168_b980,
    0xea44_df40,
    0x2525_6020,
    0x5676_f010,
    0xf94d_a818,
    0x3ab6_942c,
    0x242a_121a,
    0x92e2_c937,
    0x0492_83a5,
    0xdddf_c26e,
    0x376d_11a7,
    0xcb46_4b53,
    0xeda5_7203,
    0xa333_391c,
    0x51e8_abac,
    0xc301_166c,
    0x1b80_63b4,
    0x16c1_725f,
    0xda67_d9b0,
    0xb1d5_2f40,
    0x157f_4811,
    0x7ed8_2426,
    0x9ce8_da0c,
    0xb585_ad3b,
    0xebc2_b9af,
    0x84e3_df77,
    0xfd92_e004,
    0xa15e_b020,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x5000_0000,
    0x3800_0000,
    0xd400_0000,
    0x1600_0000,
    0xd900_0000,
    0x6a80_0000,
    0xe940_0000,
    0x7320_0000,
    0xe170_0000,
    0xa1b8_0000,
    0x71c4_0000,
    0xdd62_0000,
    0x3dd5_0000,
    0x690a_8000,
    0x691d_c000,
    0x4f70_a000,
    0xecbf_b000,
    0xad45_4800,
    0xbd22_1400,
    0x1c75_2a00,
    0xb53f_0900,
    0xad84_b380,
    0x06c4_31c0,
    0xfae2_2020,
    0x0816_7010,
    0x7a6f_e828,
    0xa9cc_a414,
    0x32f8_e20e,
    0x59e5_dd35,
    0x3993_b985,
    0x96ad_48f6,
    0xd029_7bba,
    0x1b6e_e5ea,
    0x574d_2a14,
    0x6dbb_093c,
    0xa3c6_b38e,
    0x8a61_31fd,
    0x0a50_a01c,
    0xc4cf_b01c,
    0xfe7d_482d,
    0xa1a6_1402,
    0x9c37_2a1b,
    0x649a_090c,
    0x19b6_339a,
    0x2e5d_f1fd,
    0x7150_8022,
    0xd14c_c014,
    0x6cb8_2032,
    0xed47_7038,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x5000_0000,
    0x8800_0000,
    0xd400_0000,
    0xce00_0000,
    0xfb00_0000,
    0xb880_0000,
    0xc340_0000,
    0xa4e0_0000,
    0xe850_0000,
    0x8ab8_0000,
    0x69c4_0000,
    0x46a6_0000,
    0xa133_0000,
    0xb22a_8000,
    0xb458_4000,
    0x7494_a000,
    0xef9b_7000,
    0xe332_5800,
    0x1b2d_0400,
    0x8ddb_fa00,
    0x6a55_7700,
    0x43bf_aa80,
    0x0045_69c0,
    0xd066_2020,
    0xd917_3030,
    0x9f58_f818,
    0x8411_7414,
    0x98dd_2222,
    0xd9d7_3335,
    0x807c_70b3,
    0x6be0_2efe,
    0x0ed5_f28e,
    0x5afc_6dc0,
    0xf1a3_da11,
    0x2bb5_471e,
    0xa06b_d298,
    0x453f_5dfb,
    0x4005_2220,
    0xa003_3313,
    0x3002_70a9,
    0xd807_2ef7,
    0x5c01_7298,
    0x1a03_2df4,
    0x3503_fa38,
    0x4381_773c,
    0x7bc1_aa84,
    0x67a2_69f9,
    0x4cb2_a035,
    0x62e8_7004,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0xd000_0000,
    0x0800_0000,
    0x9c00_0000,
    0x3200_0000,
    0xeb00_0000,
    0xa080_0000,
    0xc140_0000,
    0x1f60_0000,
    0xc270_0000,
    0xc7e8_0000,
    0x37c4_0000,
    0x8326_0000,
    0x9095_0000,
    0xf15e_8000,
    0x5f8c_4000,
    0x7f36_e000,
    0x5a8a_9000,
    0x66b0_d800,
    0xa04d_c400,
    0xc013_aa00,
    0x281d_0b00,
    0x74e9_9b80,
    0xc344_0340,
    0x4c60_6020,
    0x86f2_d030,
    0x70a8_3828,
    0x65a6_5434,
    0xa4d3_f202,
    0xefbd_8f27,
    0x533c_518c,
    0x607e_d87a,
    0x341f_4388,
    0x86ec_c740,
    0x8845_4a0f,
    0x3ce7_9b34,
    0x4fb1_439b,
    0xf3cd_c75e,
    0x95d5_ca0e,
    0x883a_db09,
    0x78ff_23b0,
    0x115e_1769,
    0xef8d_7212,
    0x0731_cf01,
    0x1e8a_b18b,
    0xc0b4_485b,
    0xe54f_9bab,
    0xb991_0344,
    0xa2de_e002,
    0x0a4e_900d,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x3000_0000,
    0xf800_0000,
    0x1400_0000,
    0x3200_0000,
    0x1d00_0000,
    0xa280_0000,
    0x6040_0000,
    0xa420_0000,
    0x07f0_0000,
    0x9308_0000,
    0xffc4_0000,
    0xf6e2_0000,
    0xeb97_0000,
    0xecd9_8000,
    0xb53b_c000,
    0xa12e_a000,
    0x6f30_9000,
    0x2e6c_6800,
    0xd490_5400,
    0x3b5f_e200,
    0x4bf8_d100,
    0x8b4e_6780,
    0x0fe6_3440,
    0x2315_2020,
    0x559c_5010,
    0x499b_4838,
    0x379b_040c,
    0xdc9d_2a3e,
    0x9918_1505,
    0xaadd_ed8c,
    0xea3e_b147,
    0x06ac_a588,
    0x89f6_b548,
    0x200a_0fb1,
    0x7e42_605d,
    0x3f20_c202,
    0x5a77_8126,
    0x84ce_afb7,
    0x7521_f074,
    0x1377_2a01,
    0xf44b_1527,
    0x3866_6d9d,
    0xedd2_7149,
    0x87fb_85b0,
    0x3d4d_e546,
    0x08e0_c7aa,
    0x4096_a44d,
    0x4959_480e,
    0xb6fc_042a,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0xf000_0000,
    0x7800_0000,
    0x6c00_0000,
    0x1e00_0000,
    0x5500_0000,
    0x7780_0000,
    0x3cc0_0000,
    0xcc20_0000,
    0xd910_0000,
    0x51e8_0000,
    0xce44_0000,
    0x4f62_0000,
    0x9df5_0000,
    0xc6df_8000,
    0x75bf_c000,
    0x9e4d_6000,
    0x4993_f000,
    0xb1aa_2800,
    0x4c26_fc00,
    0x9914_c600,
    0xf1eb_3100,
    0x3e44_7080,
    0x3762_ab40,
    0xf1f0_e020,
    0xd8d9_3010,
    0x20b8_c828,
    0xe9ca_cc3c,
    0x7553_8e1e,
    0x7d8e_3d1b,
    0x9532_9e87,
    0xc8fb_6655,
    0x3faa_56bd,
    0x7121_aa5f,
    0xaa91_d8bb,
    0x372b_975a,
    0xad61_4602,
    0xbef5_f104,
    0xa05c_90a2,
    0xc4ff_9b55,
    0x31aa_2815,
    0x0c26_fc0c,
    0x3914_c626,
    0x01eb_3102,
    0x4644_7088,
    0x5b62_ab42,
    0xeff0_e035,
    0x8dd9_301b,
    0x5738_c80c,
    0xd50a_cc37,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x3000_0000,
    0x4800_0000,
    0x4c00_0000,
    0xe200_0000,
    0x0d00_0000,
    0x4480_0000,
    0x2940_0000,
    0x0320_0000,
    0xb8d0_0000,
    0xebe8_0000,
    0xc8c4_0000,
    0xd2e6_0000,
    0x58b3_0000,
    0x2119_8000,
    0x757e_4000,
    0x9988_6000,
    0xe736_1000,
    0x37dc_e800,
    0xa09e_e400,
    0x94ba_ea00,
    0x31ee_2900,
    0x61c0_5e80,
    0x6864_c340,
    0xe6f7_e020,
    0x6fbb_5030,
    0x0e6d_0818,
    0xb706_b40c,
    0xdd86_6212,
    0xdbc2_dd13,
    0xf160_5cb8,
    0x1477_0e43,
    0x9dfc_d4b1,
    0xa2cb_fa7a,
    0xc114_d6b8,
    0xb78c_3752,
    0xc831_e210,
    0x1e5b_9d1d,
    0xfd5f_bc86,
    0xf6d8_5e4a,
    0xc61f_dc93,
    0xd0fa_4e77,
    0x464d_34b7,
    0xb853_aa62,
    0xcca8_5e8c,
    0x74e0_c351,
    0x5bb1_e039,
    0xda98_502a,
    0x6dbc_883d,
    0xf36c_f435,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x3000_0000,
    0x5800_0000,
    0x5400_0000,
    0x0600_0000,
    0x6100_0000,
    0xd080_0000,
    0x2dc0_0000,
    0x96a0_0000,
    0x59d0_0000,
    0x07b8_0000,
    0x8844_0000,
    0x8de6_0000,
    0x93b1_0000,
    0x7049_8000,
    0xf7ee_c000,
    0xc6b8_a000,
    0xa8c3_3000,
    0xd825_8800,
    0x6114_c400,
    0x7798_8e00,
    0xc550_e500,
    0x987d_5680,
    0x69e0_81c0,
    0x0db7_2020,
    0x654c_f030,
    0x116c_a808,
    0xd27d_340c,
    0xbae3_a616,
    0xaa36_1115,
    0x9109_d081,
    0x768a_60d8,
    0x62ca_5894,
    0x152f_a4fb,
    0xcd9b_568d,
    0x6e51_81ea,
    0x5bfe_a03f,
    0xc3a2_300b,
    0x5f54_083c,
    0x037e_0425,
    0xf266_2e3f,
    0xf3f2_d53b,
    0x31a9_5ea1,
    0x165e_85ef,
    0xe1f1_0e06,
    0xb6ae_2517,
    0xb7dd_f692,
    0x74b7_b1ed,
    0x01cc_a82e,
    0x2aad_3404,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x3000_0000,
    0x8800_0000,
    0x5400_0000,
    0xfa00_0000,
    0x3700_0000,
    0x2180_0000,
    0x60c0_0000,
    0x3020_0000,
    0x9130_0000,
    0x1bb8_0000,
    0x9244_0000,
    0x4362_0000,
    0x42d7_0000,
    0x5129_8000,
    0xc708_4000,
    0x8f3c_a000,
    0x9806_d000,
    0x4c05_3800,
    0xf603_cc00,
    0x2104_6600,
    0x3080_b100,
    0xd840_4180,
    0xbc67_b9c0,
    0xd757_2020,
    0xfbe9_9010,
    0x4828_1838,
    0x6b89_5c0c,
    0x197f_fe22,
    0xd962_ad15,
    0x05d0_9fbe,
    0x18a8_84cd,
    0xc3cd_a7a8,
    0xcd1f_48c8,
    0x6a33_c194,
    0x8c3c_f9f8,
    0x3380_003c,
    0x73c0_002d,
    0x83a0_0034,
    0xa2f0_0004,
    0x7818_0000,
    0x00b4_0031,
    0xb37a_0019,
    0x1663_0017,
    0x1853_8011,
    0xe66b_4025,
    0xb6ef_2012,
    0x1ead_901c,
    0xcaca_1834,
    0x799e_5c2a,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x5000_0000,
    0xe800_0000,
    0x2c00_0000,
    0xce00_0000,
    0xdf00_0000,
    0x7480_0000,
    0xa040_0000,
    0x10a0_0000,
    0x19f0_0000,
    0x2888_0000,
    0x4fc4_0000,
    0xe666_0000,
    0x1815_0000,
    0xda5a_8000,
    0x427b_4000,
    0x1dcb_6000,
    0x76e1_7000,
    0xca57_7800,
    0x93fb_6400,
    0x8c0d_a200,
    0xc782_d500,
    0x7ac2_2780,
    0x9fe5_e840,
    0xc5d7_e020,
    0x553f_3030,
    0x95ee_9828,
    0xa155_5414,
    0x7d7f_ba3a,
    0x5949_c10b,
    0xcea4_7db3,
    0x4ef2_1977,
    0x8009_85bd,
    0x9982_3d58,
    0xedc7_478c,
    0x9765_9862,
    0x4394_1838,
    0xb69e_143c,
    0x369c_da18,
    0xf69c_b12e,
    0x569d_05a2,
    0x0698_7d44,
    0xee98_a78d,
    0xc29e_a874,
    0x0c9c_8029,
    0xd39e_403d,
    0xa719_e006,
    0x075e_303d,
    0x17fa_1812,
    0x0e0f_141e,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0xb000_0000,
    0x0800_0000,
    0x2400_0000,
    0x0a00_0000,
    0xbd00_0000,
    0x7580_0000,
    0xfbc0_0000,
    0xaa60_0000,
    0xf910_0000,
    0x1bc8_0000,
    0x3f44_0000,
    0x1a26_0000,
    0xc7b3_0000,
    0x1c3d_8000,
    0x75dc_4000,
    0xfc0b_2000,
    0x7321_5000,
    0x1035_6800,
    0xaefd_6c00,
    0x183f_3e00,
    0x6fde_6300,
    0x990a_5080,
    0x9aa2_4a40,
    0xcdf0_a020,
    0x979e_1030,
    0x23ab_c818,
    0x4754_7c2c,
    0x826f_7602,
    0x2835_5f09,
    0x42fb_8682,
    0x563e_056f,
    0x68db_6ebd,
    0x598b_294e,
    0x30e1_7092,
    0x9653_1a62,
    0x79ed_c83c,
    0xb4f7_7c1a,
    0x981a_f61e,
    0x0d6d_1f3b,
    0x0cb6_a69a,
    0x82bc_5545,
    0x009b_86aa,
    0xfb2e_0543,
    0x1113_6e8d,
    0x4fcf_2978,
    0x5d47_7096,
    0x3320_1a4e,
    0xb030_4819,
    0x7efb_3c3f,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x9000_0000,
    0xb800_0000,
    0x4c00_0000,
    0x2600_0000,
    0xb700_0000,
    0x8680_0000,
    0x64c0_0000,
    0xcd60_0000,
    0xde70_0000,
    0xa228_0000,
    0x7144_0000,
    0xdd26_0000,
    0xdad7_0000,
    0x8ebc_8000,
    0xac59_c000,
    0x4b68_6000,
    0x9064_3000,
    0x09f0_3800,
    0x176a_7400,
    0xce64_0600,
    0x12f6_fb00,
    0x27ef_1b80,
    0xa5a5_2d40,
    0x1512_e020,
    0xbb5a_f030,
    0x7dec_d838,
    0x3ca3_8424,
    0xa092_5e2e,
    0x1b1b_bf13,
    0xb149_a589,
    0x7433_626d,
    0xaf8b_1d81,
    0x5053_d669,
    0xec7d_fbab,
    0xa63f_dd63,
    0x3b9e_381e,
    0xa289_741b,
    0xdfd6_8628,
    0x853c_3b2c,
    0x871d_fba5,
    0x0f4f_dd4c,
    0xff36_3829,
    0x270d_7417,
    0x7790_8600,
    0xcd9b_3b13,
    0x8d89_7bb1,
    0x6552_1d4a,
    0xeff8_581c,
    0x097e_4435,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x3000_0000,
    0xe800_0000,
    0xb400_0000,
    0x2200_0000,
    0x4500_0000,
    0xed80_0000,
    0x2540_0000,
    0xa160_0000,
    0xa810_0000,
    0xee48_0000,
    0x9bc4_0000,
    0xcea6_0000,
    0x64b7_0000,
    0x1ff9_8000,
    0xb1bb_4000,
    0x065f_a000,
    0x558c_1000,
    0x8566_a800,
    0x7210_ac00,
    0x274d_4a00,
    0x3843_7b00,
    0xd0e2_9880,
    0xfb51_8640,
    0x1828_2020,
    0x7354_5030,
    0x5c2e_8838,
    0x5954_fc0c,
    0x9d2b_c23a,
    0x7ed3_872d,
    0x496f_5a88,
    0x1035_0151,
    0x813e_fa9b,
    0xb29a_1179,
    0x97af_d2b0,
    0x3312_fd56,
    0xc0ca_b899,
    0x0c05_d677,
    0x8e06_a819,
    0xdb00_ac19,
    0x0e85_4a36,
    0x47c7_7b15,
    0x98a4_98a0,
    0xe3b6_864a,
    0x8779_a021,
    0x917b_1038,
    0x367f_282a,
    0x7efb_ec1e,
    0x863a_ea29,
    0xea1b_6b2a,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x3000_0000,
    0xd800_0000,
    0x9400_0000,
    0x5200_0000,
    0x4900_0000,
    0x7e80_0000,
    0xfa40_0000,
    0x35e0_0000,
    0x4570_0000,
    0xf678_0000,
    0x5bc4_0000,
    0x8226_0000,
    0x1157_0000,
    0xf429_8000,
    0xe46a_c000,
    0xfc8e_a000,
    0xad7f_9000,
    0x4c46_c800,
    0xd6e5_b400,
    0x36f3_3200,
    0xc8b8_df00,
    0x9164_9380,
    0x4a36_3fc0,
    0x4319_2020,
    0x5bf6_5030,
    0xfc3f_e838,
    0x5623_e40c,
    0x6354_da36,
    0x6d2f_3b25,
    0x72ee_4994,
    0x4aca_04d2,
    0x5e98_e9bf,
    0x1231_94ce,
    0x1718_2195,
    0xe9f3_20ed,
    0x853a_9393,
    0xf0a5_3fcf,
    0x0d16_a01a,
    0x0acb_900f,
    0x7e98_c838,
    0xc236_b43c,
    0xff1c_b20f,
    0xa5f5_1f33,
    0x433b_b3a8,
    0xeba7_6fde,
    0x3a97_4822,
    0x8e0b_743f,
    0xb13b_9231,
    0xb2a0_4f24,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x5000_0000,
    0x1800_0000,
    0x1c00_0000,
    0xae00_0000,
    0x8f00_0000,
    0x9080_0000,
    0x7bc0_0000,
    0x4ee0_0000,
    0xbc30_0000,
    0xc038_0000,
    0x1e44_0000,
    0xc0a2_0000,
    0xc497_0000,
    0xa8aa_8000,
    0x50ec_c000,
    0x1b4e_e000,
    0xfd5c_7000,
    0x0f37_f800,
    0x0ebb_c400,
    0x4282_7e00,
    0x4ac7_a700,
    0xa963_c980,
    0x1b71_edc0,
    0x431e_6020,
    0x7f93_b010,
    0x8229_9838,
    0xee28_7414,
    0xa82b_e606,
    0x932f_d307,
    0xf9a8_2fab,
    0xa76e_3ee3,
    0x440e_4f84,
    0x3279_8ece,
    0xd8e5_d78b,
    0xdf36_faeb,
    0x56bc_b1ae,
    0xbe81_e9c4,
    0xb4c0_7e05,
    0x3e60_a711,
    0x97f1_499b,
    0x96d9_2dfa,
    0xbe72_803c,
    0xae98_c03a,
    0x55d4_e017,
    0xf88f_7002,
    0xefbf_7821,
    0xfd00_0412,
    0x1186_1e38,
    0xd447_1728,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xd000_0000,
    0x2800_0000,
    0xb400_0000,
    0x2200_0000,
    0xa700_0000,
    0x0b80_0000,
    0xf3c0_0000,
    0x6420_0000,
    0x7b70_0000,
    0xd588_0000,
    0x7424_0000,
    0x3372_0000,
    0x9189_0000,
    0xae22_8000,
    0x0873_4000,
    0x0c0c_a000,
    0xd8e3_9000,
    0xc0d6_7800,
    0x8f3c_fc00,
    0x9a8c_0e00,
    0xaba1_5900,
    0x12b5_2780,
    0xaaaf_a240,
    0x42d6_7820,
    0xb83c_fc10,
    0x990c_0e08,
    0x3c61_5934,
    0x7c95_278a,
    0xc2df_a26d,
    0xbede_7828,
    0x98d8_fc39,
    0xc5de_0e0a,
    0x2558_5908,
    0x631f_a793,
    0xc5f8_e273,
    0x5428_d81d,
    0xa596_6c24,
    0x9858_f606,
    0x339e_e52c,
    0x5bbd_89b8,
    0xbec9_6b71,
    0x8a47_279e,
    0x58e6_a252,
    0x80d4_f816,
    0xaf3f_bc1f,
    0x4a88_ae16,
    0x83a6_c92f,
    0xa6b1_5fb0,
    0x88aa_5e45,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0xb000_0000,
    0x3800_0000,
    0x5400_0000,
    0x4e00_0000,
    0x1700_0000,
    0x6a80_0000,
    0x6b40_0000,
    0xa2a0_0000,
    0x80b0_0000,
    0x0628_0000,
    0xdaa4_0000,
    0x34b6_0000,
    0xd829_0000,
    0x45a1_8000,
    0x3237_c000,
    0xa96b_a000,
    0xbe03_f000,
    0xcf07_7800,
    0xae80_f400,
    0xad44_aa00,
    0xd9a4_6d00,
    0xf035_f180,
    0x3469_1b40,
    0x0587_7820,
    0xb5c0_f430,
    0x17e4_aa08,
    0xbd14_6d2c,
    0x801d_f18e,
    0xadcd_1b55,
    0x15b1_7833,
    0x11a9_f435,
    0x9a65_2a12,
    0x64d3_ad36,
    0x8dfe_51a6,
    0x49da_eb75,
    0xe828_0032,
    0xbda4_0003,
    0x4636_001f,
    0x5769_0000,
    0x9101_8037,
    0xf187_c039,
    0x8bc3_a038,
    0x18e7_f01c,
    0x3391_7824,
    0x9d59_f407,
    0x4c6d_2a12,
    0xb187_ad1a,
    0x6bc0_5197,
    0x88e7_eb54,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0xf000_0000,
    0x1800_0000,
    0xe400_0000,
    0xf200_0000,
    0x8500_0000,
    0x0e80_0000,
    0xb1c0_0000,
    0xf520_0000,
    0x9c10_0000,
    0x05e8_0000,
    0x3d24_0000,
    0x3016_0000,
    0x9beb_0000,
    0x4623_8000,
    0xb596_c000,
    0xb7ac_2000,
    0x7b44_1000,
    0xe6e2_e800,
    0x6434_5400,
    0x9b7d_9e00,
    0x870f_4100,
    0x6b11_b480,
    0x4e6f_3140,
    0xe262_e820,
    0x84f4_5430,
    0xeadd_9e18,
    0x3bdf_413c,
    0x7f59_b486,
    0x3f9b_3179,
    0xde3c_e81c,
    0x8aeb_5411,
    0x62a0_1e1b,
    0x0556_8110,
    0x4e08_14bb,
    0xcb96_e15e,
    0xfcaf_a01d,
    0x86c2_d01e,
    0xdea6_c817,
    0xb354_4436,
    0xa909_762a,
    0xa810_1533,
    0xbfef_aa90,
    0xd426_b070,
    0xc097_7c96,
    0xa12b_7563,
    0x2e83_9e32,
    0xe1c0_4127,
    0x7d24_34a8,
    0x9012_f147,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x5000_0000,
    0x5800_0000,
    0xdc00_0000,
    0xe600_0000,
    0x8900_0000,
    0x7480_0000,
    0xa840_0000,
    0x7b20_0000,
    0xb210_0000,
    0xb8b8_0000,
    0x4724_0000,
    0x4412_0000,
    0x09bb_0000,
    0xbfa6_8000,
    0x5250_c000,
    0x279d_e000,
    0x9f31_b000,
    0xcbac_8800,
    0x6f1a_4400,
    0xc176_f200,
    0x018c_5100,
    0x258d_5480,
    0x6f89_f7c0,
    0x688c_8820,
    0x410a_4410,
    0xffce_f218,
    0x9fa8_5114,
    0x4d1f_5496,
    0x1272_f7f7,
    0x4a0a_0819,
    0x284a_8432,
    0x146b_1205,
    0xeffd_e13e,
    0xb981_dc88,
    0xc6c3_b3db,
    0x8c62_7a37,
    0x3cb2_1523,
    0x5269_a694,
    0x16fe_a6fc,
    0xa507_5c87,
    0xba83_73df,
    0x9547_9a26,
    0x3da7_a510,
    0xf157_2eb0,
    0x041f_e2d0,
    0x46f7_2e8e,
    0xd24f_e2fd,
    0x5b6f_2eb2,
    0x227b_e2e1,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0xf000_0000,
    0xe800_0000,
    0xb400_0000,
    0x0200_0000,
    0xf100_0000,
    0xa480_0000,
    0x50c0_0000,
    0x73a0_0000,
    0xb050_0000,
    0x6818_0000,
    0xb7a4_0000,
    0x1a52_0000,
    0xcd1f_0000,
    0xe123_8000,
    0x5395_4000,
    0xae3a_a000,
    0x03b3_9000,
    0xb92a_c800,
    0x0d4b_8400,
    0x213b_1600,
    0xb032_5500,
    0x466f_8680,
    0xd7aa_16c0,
    0x488a_c820,
    0x0c1b_8410,
    0x0da3_1638,
    0xa756_553c,
    0xc79d_86ba,
    0x1ee5_16ed,
    0xc3b1_4820,
    0x192a_c42c,
    0x1d4b_b611,
    0x393a_c528,
    0xec34_cea6,
    0xf06b_d2c1,
    0x24a8_fe3a,
    0x1d0f_0101,
    0xf85c_f897,
    0x2ec4_57db,
    0x64a6_90be,
    0x1fd7_43c5,
    0xc15e_cea9,
    0x6e40_d2fd,
    0xce61_7e23,
    0x3171_4125,
    0x8b8f_d8ae,
    0x1199_87f9,
    0x5de7_7893,
    0x9e35_17cd,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x7000_0000,
    0x6800_0000,
    0x7c00_0000,
    0xa200_0000,
    0x6900_0000,
    0x6380_0000,
    0x2440_0000,
    0x1860_0000,
    0x5550_0000,
    0x9ff8_0000,
    0x5c64_0000,
    0xd352_0000,
    0xe0fd_0000,
    0xf8e7_8000,
    0x3791_4000,
    0xaa5e_e000,
    0x5012_9000,
    0xa81a_0800,
    0x4771_fc00,
    0x31cd_b200,
    0x4049_cb00,
    0x850f_d680,
    0x52e8_8dc0,
    0x99fa_0820,
    0x6361_fc10,
    0xd7d5_b228,
    0x743d_cb1c,
    0xda45_d69a,
    0xe361_8ddf,
    0x97d7_8808,
    0xd439_bc0a,
    0xaa46_d230,
    0x8b67_1b15,
    0xebd4_be9c,
    0x763e_a1ca,
    0xc341_522f,
    0xe8e6_5b1d,
    0xcf92_5e84,
    0x6e58_31ed,
    0x9611_5a02,
    0x771e_a717,
    0x93f2_6c8d,
    0xbd09_bac5,
    0x76ed_ecbc,
    0x8ffc_faef,
    0xa461_0c94,
    0x1753_6ade,
    0x26fc_84a6,
    0x27e3_d6cd,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0xb000_0000,
    0x1800_0000,
    0xdc00_0000,
    0x1600_0000,
    0x1f00_0000,
    0x3a80_0000,
    0x55c0_0000,
    0x9e20_0000,
    0x72d0_0000,
    0x4c98_0000,
    0x1024_0000,
    0x71d6_0000,
    0x801f_0000,
    0xeae1_8000,
    0xcd76_c000,
    0x7b09_e000,
    0x2e59_3000,
    0xb082_3800,
    0x7cc6_3400,
    0xeba0_9e00,
    0xb591_4900,
    0x437c_6280,
    0x36d2_9ac0,
    0x469a_3820,
    0xf922_3430,
    0xe456_9e38,
    0xf75e_492c,
    0xfd05_e286,
    0x3780_5af7,
    0x5a45_d825,
    0x4864_0437,
    0x84b5_2636,
    0x132e_bd39,
    0xf38c_9ca1,
    0xde98_23eb,
    0xe523_82b6,
    0x1254_aaf3,
    0x5859_800a,
    0xdf82_c029,
    0xbe47_e023,
    0xd262_3034,
    0x25b5_b80e,
    0xf2af_f43f,
    0x56c8_fe3b,
    0x1c7e_b92d,
    0x2c57_baa9,
    0x435d_9ed7,
    0xcf00_9e1a,
    0x5281_492e,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x7000_0000,
    0xe800_0000,
    0xe400_0000,
    0x7a00_0000,
    0xb300_0000,
    0xd680_0000,
    0x93c0_0000,
    0x1620_0000,
    0x7990_0000,
    0x4378_0000,
    0x2424_0000,
    0x7e92_0000,
    0x17fb_0000,
    0x78e7_8000,
    0xc835_4000,
    0xd0ac_2000,
    0x323c_5000,
    0x63c4_d800,
    0xbe20_9400,
    0xfd97_ce00,
    0x4979_e900,
    0x7f21_1880,
    0x4c10_75c0,
    0xfe3c_d820,
    0xddc4_9410,
    0x6725_ce18,
    0x0012_e91c,
    0x003e_98ba,
    0x64c1_35f9,
    0xeaa2_f83e,
    0xa153_c43c,
    0xffde_962d,
    0xb873_3d38,
    0x06cf_76bf,
    0x55cb_8ce7,
    0xb34a_b8ae,
    0xa889_65f5,
    0x2aac_2012,
    0xc13c_502d,
    0xd544_d839,
    0x5de0_9409,
    0x03b7_ce00,
    0xd4e9_e910,
    0x4659_18ac,
    0xdb34_75e2,
    0x562e_d831,
    0x59ff_940a,
    0x09e2_4e26,
    0xb1b7_a914,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0xb000_0000,
    0xb800_0000,
    0xc400_0000,
    0xca00_0000,
    0x8900_0000,
    0xa980_0000,
    0x50c0_0000,
    0x8160_0000,
    0x6d50_0000,
    0xf1c8_0000,
    0x0f64_0000,
    0xee56_0000,
    0x714d_0000,
    0x4621_8000,
    0x87f3_c000,
    0x597b_2000,
    0x10bf_d000,
    0xf05b_8800,
    0x11cc_6c00,
    0xdf66_5600,
    0x4653_0300,
    0xbd4d_4680,
    0xf021_3840,
    0x00f3_8820,
    0xb3f8_6c30,
    0x60f8_5628,
    0x887a_032c,
    0xad3a_c6ae,
    0xc29f_f871,
    0xd5a9_2812,
    0xadb4_7c12,
    0x6058_fe02,
    0xd9c9_bf38,
    0x0367_188e,
    0xf850_976a,
    0x464a_38ae,
    0x14a2_4751,
    0x33b0_3099,
    0xeb5d_eb54,
    0x254d_4697,
    0x4421_3857,
    0xd2f3_883e,
    0x4ef8_6c08,
    0xbb78_5619,
    0x95ba_0333,
    0x4fda_c6b0,
    0x760f_f86c,
    0x0c81_281d,
    0x9f40_7c26,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0xd000_0000,
    0xa800_0000,
    0x8c00_0000,
    0x6e00_0000,
    0x4f00_0000,
    0x0980_0000,
    0x4340_0000,
    0x83e0_0000,
    0xa5b0_0000,
    0xdd58_0000,
    0x11e4_0000,
    0x3cb6_0000,
    0x9fd9_0000,
    0x6922_8000,
    0x7513_4000,
    0x730d_6000,
    0x3509_f000,
    0x360d_3800,
    0x718f_2c00,
    0xadcc_ea00,
    0x8fae_a700,
    0xe559_c180,
    0xd5e3_20c0,
    0x2eb5_3820,
    0xc6db_2c30,
    0x0ba2_ea08,
    0xddd3_a734,
    0x92ad_41aa,
    0x55d9_60e3,
    0x0422_d83b,
    0x7d95_9c23,
    0xa6cc_b20a,
    0x5428_7b24,
    0xdf18_138a,
    0xe482_abca,
    0x8bc0_138c,
    0x7626_abe7,
    0x1496_13a5,
    0x9c4f_abf3,
    0x08ec_93b8,
    0x74b8_ebd3,
    0x2957_f3b2,
    0x9168_1bfd,
    0x7ff8_4b99,
    0xd6b4_77df,
    0x22d9_c18a,
    0xc9a3_20f3,
    0x2cd5_3829,
    0x7c2b_2c31,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0xb000_0000,
    0x4800_0000,
    0x2400_0000,
    0xbe00_0000,
    0xa700_0000,
    0xda80_0000,
    0x5a40_0000,
    0x9420_0000,
    0xff30_0000,
    0x12d8_0000,
    0xd624_0000,
    0x9a36_0000,
    0x6d5b_0000,
    0x93e1_8000,
    0xfbd4_4000,
    0xbb8a_2000,
    0x73ec_7000,
    0x73fd_7800,
    0x0e96_f400,
    0x712f_a200,
    0xb899_5900,
    0xaa05_cd80,
    0x9101_d4c0,
    0x3985_7820,
    0x8ec2_f430,
    0x2161_a218,
    0x9596_592c,
    0x09aa_4d92,
    0xf7da_94c9,
    0x69a0_d80f,
    0xbff5_c419,
    0xbcb9_7a2e,
    0x0d37_9d3a,
    0x3fdd_37b7,
    0x8da2_09f6,
    0x61f2_6f8b,
    0xabbc_8dec,
    0x9fb6_b5a8,
    0x4198_20d1,
    0xa785_5a2b,
    0x39c0_ed14,
    0x63e1_cf8f,
    0x13d0_bde5,
    0x4f8f_ed91,
    0x35ed_a4de,
    0xb8f8_003c,
    0x4e14_000c,
    0x326e_0019,
    0x513f_0001,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x7000_0000,
    0xf800_0000,
    0xf400_0000,
    0x9a00_0000,
    0x4100_0000,
    0xf480_0000,
    0xa440_0000,
    0x5660_0000,
    0x9770_0000,
    0x8198_0000,
    0xd764_0000,
    0x03f2_0000,
    0x75d9_0000,
    0x0907_8000,
    0x9885_c000,
    0x9a46_a000,
    0x0567_5000,
    0x2ef5_c800,
    0xbf58_0400,
    0xfe45_f200,
    0x7762_bb00,
    0x33f2_1f80,
    0xadda_aec0,
    0x8d07_c820,
    0xfa81_0410,
    0x2f42_7208,
    0x6be7_7b1c,
    0xcbb4_bfbe,
    0x1dbd_fefd,
    0xcd72_0006,
    0xa099_0000,
    0x73e7_8035,
    0x2fb5_c035,
    0x2fbe_a02b,
    0xf073_5018,
    0xc21f_c806,
    0xf8a5_0425,
    0x5650_723d,
    0xa90e_7b34,
    0x774b_3f97,
    0x702c_3ec3,
    0xbbde_a026,
    0xe203_5024,
    0xf507_c803,
    0x4e81_042e,
    0x9542_7203,
    0x5ae7_7b06,
    0xc734_bf8c,
    0x4dfd_fefa,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x7000_0000,
    0xa800_0000,
    0x9400_0000,
    0xae00_0000,
    0xbf00_0000,
    0x9b80_0000,
    0x7140_0000,
    0xfba0_0000,
    0x33d0_0000,
    0x51d8_0000,
    0xdca4_0000,
    0xf456_0000,
    0xca9d_0000,
    0xee07_8000,
    0xdf03_4000,
    0x4b81_a000,
    0xa946_f000,
    0xc7a0_b800,
    0x09d0_7c00,
    0x40de_fa00,
    0xf826_2500,
    0x1e93_4280,
    0x407c_04c0,
    0x2676_b820,
    0xbd0d_7c30,
    0xc6f9_7a28,
    0x81b5_651c,
    0xf96a_e2aa,
    0x2d4e_f4e5,
    0x71d8_000b,
    0x6ca4_001f,
    0xfc56_000e,
    0x2e9d_0000,
    0xe807_8014,
    0xf403_4029,
    0x7e01_a03f,
    0x6706_f018,
    0xa780_b81b,
    0x4b40_7c2e,
    0xeaa6_fa05,
    0x1752_253b,
    0xbb1d_4286,
    0x5645_04dd,
    0x3c27_382c,
    0xa893_3c00,
    0x637f_5a03,
    0xf7f0_d515,
    0x754b_fabf,
    0x8dd8_78df,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x9000_0000,
    0x8800_0000,
    0xbc00_0000,
    0x4600_0000,
    0x6500_0000,
    0x0280_0000,
    0xcb40_0000,
    0x90a0_0000,
    0x4ff0_0000,
    0xe628_0000,
    0xcda4_0000,
    0xa972_0000,
    0xff6d_0000,
    0x5200_8000,
    0x4f06_4000,
    0x0980_e000,
    0x80c6_b000,
    0x9767_6800,
    0xcd15_f400,
    0x7dfc_6a00,
    0xca3b_ad00,
    0x10dc_6b80,
    0x1f0a_6b40,
    0x7295_6820,
    0x6038_f410,
    0x5bdc_ea28,
    0xf48d_ed24,
    0xe554_8ba2,
    0x6ad8_db6f,
    0x7c08_0031,
    0xb514_0009,
    0x39fa_0028,
    0x8839_0016,
    0x97da_8006,
    0x0a8f_403c,
    0x2452_6028,
    0x1a5d_f02a,
    0x284f_082a,
    0x0431_040d,
    0xdac9_e230,
    0x3775_e900,
    0x4e6f_e9bb,
    0x9a86_7253,
    0xbf47_89af,
    0xcaa2_825c,
    0xfcf2_0183,
    0x09ac_c655,
    0xb861_83ac,
    0xb490_df7c,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x3000_0000,
    0x5800_0000,
    0x8c00_0000,
    0xe200_0000,
    0xc700_0000,
    0xb880_0000,
    0xb440_0000,
    0x70a0_0000,
    0x5bf0_0000,
    0xf3c8_0000,
    0x43a4_0000,
    0xfd72_0000,
    0x9a8d_0000,
    0xf085_8000,
    0x1040_c000,
    0xe6a1_6000,
    0xc2f6_9000,
    0x364c_f800,
    0x0465_a400,
    0x6310_b200,
    0xc298_bd00,
    0x909a_9b80,
    0x4f9e_fc40,
    0xdb1e_f820,
    0xbd58_a410,
    0x52fd_3228,
    0x3d8c_7d0c,
    0x9801_fb96,
    0x6c01_6c63,
    0x7205_8018,
    0xaf00_c021,
    0x6c81_6006,
    0xda46_9021,
    0x55a4_f80a,
    0x2471_a435,
    0xff0a_b204,
    0x8741_bd21,
    0xd625_1b91,
    0x32b7_3c4b,
    0x40e8_1800,
    0xae93_f402,
    0x815d_2a2d,
    0xa8fb_892c,
    0xd68e_d1a4,
    0xf287_e544,
    0x4746_d1bc,
    0x3623_e555,
    0xa2b4_d1bb,
    0x28ee_e552,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x5000_0000,
    0x4800_0000,
    0xf400_0000,
    0xa600_0000,
    0x9d00_0000,
    0xc380_0000,
    0xb8c0_0000,
    0xf4a0_0000,
    0x84b0_0000,
    0x87a8_0000,
    0xe5a4_0000,
    0xed36_0000,
    0xc869_0000,
    0x0586_8000,
    0x95c4_4000,
    0x0f26_a000,
    0xd077_b000,
    0x690e_a800,
    0xae15_bc00,
    0x921e_f600,
    0xcb8e_4d00,
    0x6752_b980,
    0x957c_bb40,
    0xfd18_a820,
    0xa30c_bc30,
    0xe910_7608,
    0xbe9e_0d14,
    0xdbca_1992,
    0x3db6_0b7d,
    0x6a2e_8009,
    0x1460_4017,
    0x2c10_a038,
    0x211e_b03a,
    0x4108_282f,
    0xea11_fc1c,
    0x0c18_5608,
    0xba89_fd1e,
    0xbed4_118b,
    0xe2bd_075c,
    0xf138_5e1c,
    0xc1ff_f134,
    0xe15a_4faa,
    0x93eb_f659,
    0xc144_9193,
    0x1360_4754,
    0xe090_7e24,
    0x4158_0114,
    0x03ec_47b0,
    0xa944_fa56,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0xb000_0000,
    0x9800_0000,
    0x4c00_0000,
    0xde00_0000,
    0xe100_0000,
    0xbf80_0000,
    0x36c0_0000,
    0x7ca0_0000,
    0x2cd0_0000,
    0xea88_0000,
    0xc3a4_0000,
    0xb256_0000,
    0xc3cd_0000,
    0x39c1_8000,
    0x7a22_c000,
    0x4997_6000,
    0xceeb_7000,
    0xead7_c800,
    0x8789_9c00,
    0x0226_4600,
    0xd597_6d00,
    0x98ed_5a80,
    0x6fd5_0240,
    0x3209_c820,
    0x47e0_9c30,
    0x29b1_c628,
    0xdc78_ad2c,
    0x70bb_baa6,
    0x971c_b253,
    0x4f49_6017,
    0xef82_7008,
    0x7ec0_4807,
    0xb8a6_5c21,
    0x96d0_a639,
    0x018e_dd18,
    0x0f25_f28d,
    0x0413_ee48,
    0xd72e_4623,
    0xe0f3_6d0d,
    0xf61b_5ab9,
    0x30c8_0279,
    0x7940_482e,
    0xb266_5c20,
    0x0c70_a609,
    0x305e_dd05,
    0x1c2d_f287,
    0x5c77_ee75,
    0x7858_463c,
    0xd82e_6d2b,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0xb000_0000,
    0x6800_0000,
    0xfc00_0000,
    0x4600_0000,
    0x7f00_0000,
    0x6880_0000,
    0xcfc0_0000,
    0x3ea0_0000,
    0xbc90_0000,
    0x6d98_0000,
    0x67a4_0000,
    0xfb16_0000,
    0x32d9_0000,
    0xb2c1_8000,
    0xab25_4000,
    0x26d6_e000,
    0xe97f_b000,
    0xefd4_b800,
    0x76fa_a400,
    0x2491_4e00,
    0x1999_8d00,
    0x4da0_e080,
    0x1a11_72c0,
    0xb15a_b820,
    0xaf87_a430,
    0x6346_ce08,
    0xb365_cd2c,
    0x9f37_809a,
    0x148b_82ff,
    0x6878_e031,
    0x3c52_b02f,
    0x93bb_3812,
    0xc8f2_e41f,
    0x5e28_2e15,
    0xfeee_7d10,
    0xb0cd_388a,
    0x779c_26c6,
    0x2ea6_2e04,
    0xa493_7d0f,
    0xd99a_b8ab,
    0x6da0_66e9,
    0xaa11_4e28,
    0xd959_8d2c,
    0x5380_e09c,
    0x2541_72e2,
    0xcc62_b805,
    0xf7b3_a410,
    0xdb48_ce0c,
    0x56d8_cd20,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x9000_0000,
    0xe800_0000,
    0x1c00_0000,
    0x1600_0000,
    0xa300_0000,
    0x2880_0000,
    0x8cc0_0000,
    0xb4a0_0000,
    0xc8f0_0000,
    0xc748_0000,
    0xd1a4_0000,
    0x8b76_0000,
    0x0f0f_0000,
    0x87c0_8000,
    0xa021_4000,
    0x2237_e000,
    0xa8ec_3000,
    0xc5d6_5800,
    0xcaff_a400,
    0xdf0f_d600,
    0x4fc6_3d00,
    0xcc21_4380,
    0x4c31_3c40,
    0xffe8_5820,
    0xe754_a430,
    0xf339_5638,
    0xe028_7d24,
    0x2376_23ba,
    0x330c_4c47,
    0xe1c1_e025,
    0x7b23_3018,
    0xfeb6_d832,
    0x2e2e_e407,
    0xc470_3617,
    0x898e_0d35,
    0xbc01_1bb4,
    0xa601_985c,
    0x3b07_0e08,
    0x4c83_d910,
    0x6ec7_f5b4,
    0x1da1_717e,
    0x5576_23a3,
    0xc00c_4c69,
    0xc141_e00e,
    0x7be3_300d,
    0xb416_d81e,
    0x59de_e43b,
    0x3db8_3629,
    0x77ea_0d24,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0xb000_0000,
    0xc800_0000,
    0x0c00_0000,
    0x4e00_0000,
    0xc300_0000,
    0xf580_0000,
    0x0b40_0000,
    0x68e0_0000,
    0xfb50_0000,
    0x9918_0000,
    0xa9e4_0000,
    0xa3d6_0000,
    0xf4df_0000,
    0x47c1_8000,
    0xff20_4000,
    0xbc77_6000,
    0x016f_f000,
    0x5a8c_5800,
    0xbc5d_cc00,
    0x7207_2a00,
    0x8501_df00,
    0xda84_b680,
    0x00c7_32c0,
    0x68a2_5820,
    0x6a36_cc30,
    0x2708_aa38,
    0x9b1a_9f2c,
    0x04e4_56b2,
    0xc557_82c3,
    0x7218_e033,
    0xe064_b000,
    0x2e94_b805,
    0x5339_7c2e,
    0x0713_9228,
    0xae78_a33d,
    0x88f7_24b5,
    0x52af_91da,
    0x5fad_7cb5,
    0xa92d_5dcf,
    0xb7eb_d693,
    0x644c_c2dd,
    0x3ff8_0023,
    0x51b4_0035,
    0x2f4e_0027,
    0xe67b_000d,
    0x44f7_8011,
    0xfcaf_402f,
    0x2cae_e02d,
    0x94ab_b00c,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0xf000_0000,
    0x6800_0000,
    0x1400_0000,
    0x8600_0000,
    0x8f00_0000,
    0x3a80_0000,
    0x7e40_0000,
    0xa020_0000,
    0xe5f0_0000,
    0xb1f8_0000,
    0xeaa4_0000,
    0x33b6_0000,
    0xe5df_0000,
    0x7953_8000,
    0x654d_4000,
    0x21fb_a000,
    0xb2a1_b000,
    0xafb6_3800,
    0x87d9_f400,
    0x1857_0200,
    0xc4cc_9900,
    0xe339_6b80,
    0xe3c3_b5c0,
    0xd0e5_b820,
    0xad94_b430,
    0xe32c_a238,
    0xf82d_293c,
    0x84af_539a,
    0x95ea_41c5,
    0xff4a_ba01,
    0x0cfc_2d13,
    0x0923_c9b6,
    0x8071_9ce3,
    0x8d39_6b92,
    0xb8c3_b5cc,
    0x8c65_b815,
    0xacd4_b415,
    0x118c_a220,
    0x779d_291f,
    0x1377_538d,
    0x15be_41c6,
    0x4784_ba2b,
    0x7dc7_2d1a,
    0xe3e6_49b9,
    0xe513_dcc2,
    0x6469_4ba6,
    0x858b_45de,
    0x319e_2029,
    0x7c73_f038,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x9000_0000,
    0x4800_0000,
    0x4c00_0000,
    0x2a00_0000,
    0xdd00_0000,
    0x4980_0000,
    0xbec0_0000,
    0x5560_0000,
    0x8a30_0000,
    0x1268_0000,
    0xf4e4_0000,
    0xc8f6_0000,
    0x550f_0000,
    0x37d0_8000,
    0xbd1c_4000,
    0xa429_6000,
    0x14c7_d000,
    0x4865_a800,
    0x23b3_ac00,
    0x3caa_6600,
    0xe980_6300,
    0x0ec3_2d80,
    0x6d65_dd40,
    0x1e35_2820,
    0x3c6f_ec30,
    0x4fe3_0638,
    0x7677_b324,
    0x7f4e_8592,
    0x95f2_7153,
    0xdc89_4e2a,
    0x6910_8f07,
    0x7878_abaa,
    0x661a_2e4b,
    0x4aac_cda7,
    0x9681_4d41,
    0x3641_6016,
    0x2023_d01e,
    0x6093_a80a,
    0xe6bc_ac0d,
    0x437a_e600,
    0x189c_2329,
    0x80ea_4db5,
    0xa4a2_0d60,
    0x1fd0_8007,
    0xa11c_4020,
    0x2629_602b,
    0x15c7_d02e,
    0x63e5_a80e,
    0x0c73_ac25,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x5000_0000,
    0xa800_0000,
    0xbc00_0000,
    0x6a00_0000,
    0x6d00_0000,
    0x9580_0000,
    0xc9c0_0000,
    0x9020_0000,
    0x4b90_0000,
    0xf8c8_0000,
    0x1da4_0000,
    0x8652_0000,
    0x76eb_0000,
    0xbd36_8000,
    0x441f_4000,
    0xe60a_e000,
    0x9d07_d000,
    0x4d87_2800,
    0xedc0_cc00,
    0xbe22_de00,
    0x5897_4900,
    0xd648_4080,
    0x46e5_b040,
    0x2731_a820,
    0xf11f_8c10,
    0x5788_3e18,
    0x7ac0_9914,
    0xcea7_68aa,
    0x88d1_7c6f,
    0x1da9_763a,
    0xe457_c50b,
    0xd7ec_febd,
    0xdab5_6966,
    0xa4d8_a0ae,
    0x9dad_606d,
    0xa452_001c,
    0xb7eb_0018,
    0x8ab6_8036,
    0x0cdf_4014,
    0x21aa_e03b,
    0xce57_d037,
    0xdaef_2838,
    0x1f34_cc09,
    0xc518_de33,
    0xb188_4906,
    0x85c4_c09a,
    0x2225_f052,
    0x0297_c833,
    0x4348_1c3c,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0xb000_0000,
    0x4800_0000,
    0x7c00_0000,
    0x5a00_0000,
    0x2b00_0000,
    0xfc80_0000,
    0xa1c0_0000,
    0x8ce0_0000,
    0xa790_0000,
    0x99a8_0000,
    0x8c64_0000,
    0x9c56_0000,
    0xde4f_0000,
    0x6771_8000,
    0xec3c_4000,
    0xa2c8_e000,
    0x06b5_5000,
    0x80da_1800,
    0xb55a_8400,
    0xd71a_1e00,
    0x70b9_9f00,
    0x730b_6880,
    0x2250_8b40,
    0xeb4b_9820,
    0x3ef6_c430,
    0x0c7a_fe38,
    0x4a68_cf2c,
    0x2787_7092,
    0x3545_0f5f,
    0x0120_0636,
    0x8973_1b3a,
    0x2139_7687,
    0xcf4d_1444,
    0xc0f6_f091,
    0x1979_4f46,
    0x43e8_e628,
    0x3fc6_4b35,
    0xe9e3_6eb2,
    0x0617_906c,
    0x4dec_ee9e,
    0x42c0_d077,
    0xcc63_8ebf,
    0xbc56_c05c,
    0x8e48_f691,
    0x9f71_5458,
    0xd83e_10b5,
    0x84cc_1f64,
    0x77b2_fe16,
    0x575c_cf3c,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0xf000_0000,
    0xf800_0000,
    0xa400_0000,
    0x7e00_0000,
    0x7100_0000,
    0xc780_0000,
    0xb5c0_0000,
    0x5420_0000,
    0xa1b0_0000,
    0xa458_0000,
    0xe7a4_0000,
    0x2272_0000,
    0x7d7d_0000,
    0xab93_8000,
    0xc4ed_c000,
    0xdc7c_2000,
    0x2412_7000,
    0x8d2b_4800,
    0xa25d_9c00,
    0x72a0_1e00,
    0x3bf4_c900,
    0x49bf_6180,
    0xc034_b4c0,
    0x7498_c820,
    0x5200_5c10,
    0x1304_3e28,
    0xcc82_b93c,
    0x8d46_29be,
    0xaf64_28e9,
    0x23d3_563f,
    0x9a0d_550c,
    0xc76d_7f99,
    0x07bd_7dd1,
    0xa934_298b,
    0x4719_28d1,
    0x91c0_d63e,
    0x6a20_9509,
    0x70b1_5faf,
    0x93df_0de7,
    0xaa67_61be,
    0xd250_b4fc,
    0xa2ca_c838,
    0x7ecd_5c2d,
    0xe4cf_be19,
    0x4bcb_7927,
    0x0d48_09ab,
    0x870b_58db,
    0xc2eb_9e0a,
    0x497d_093e,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xd000_0000,
    0x8800_0000,
    0xd400_0000,
    0x4600_0000,
    0x6300_0000,
    0x1c80_0000,
    0x3cc0_0000,
    0xb4e0_0000,
    0x77f0_0000,
    0x5878_0000,
    0xa464_0000,
    0x1132_0000,
    0x3d99_0000,
    0x3a12_8000,
    0x820e_4000,
    0xd95b_a000,
    0x92f2_b000,
    0x47fc_5800,
    0x7425_c400,
    0xc113_1600,
    0xa28d_5f00,
    0x879d_4b80,
    0x5b10_4dc0,
    0x138e_d820,
    0x9e1b_8410,
    0xc850_b608,
    0x0f2b_ef34,
    0xb5cb_13a2,
    0x1538_89f5,
    0xe7c5_4e31,
    0x4465_9b08,
    0xa136_dd8f,
    0x459e_52fb,
    0xb610_b3af,
    0x980a_39f8,
    0x2859_162f,
    0xab70_5f15,
    0x04bd_cba9,
    0xe087_0dc1,
    0x3ec7_f830,
    0x39e7_7400,
    0x0c77_4e3e,
    0xb63c_9b2e,
    0x9b44_5d9d,
    0x88a0_12f5,
    0x4dd3_13b4,
    0x6e6c_89f4,
    0x7c6f_4e2a,
    0x1968_9b3f,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0xb000_0000,
    0xb800_0000,
    0xcc00_0000,
    0x1a00_0000,
    0x0900_0000,
    0x1880_0000,
    0x7040_0000,
    0x7ca0_0000,
    0xc010_0000,
    0x89b8_0000,
    0x8624_0000,
    0x5556_0000,
    0xa79f_0000,
    0x3771_8000,
    0xcccb_c000,
    0x47ed_6000,
    0x843f_5000,
    0x3ce0_8800,
    0xc4b2_2400,
    0x65ac_1200,
    0xa599_8d00,
    0x6277_b480,
    0x2648_37c0,
    0xfaa9_0820,
    0x8e1d_e430,
    0x53b7_7238,
    0x3a29_dd2c,
    0x425e_bcae,
    0x6d15_d3f3,
    0x8f3e_7a26,
    0x7164_3932,
    0x5e71_cebe,
    0xa448_0ef0,
    0x6fae_c691,
    0x849a_eaf3,
    0x5ef0_34bc,
    0x880c_f7ff,
    0xe10d_e825,
    0x898d_741a,
    0xa1cc_9a02,
    0xa16b_a91e,
    0xc37b_a69d,
    0x8fc1_baed,
    0x0b66_bca5,
    0x2771_d3c6,
    0xe4c8_7a37,
    0x63eb_390b,
    0x5a38_4eb7,
    0x5be7_cecf,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x7000_0000,
    0xb800_0000,
    0x8400_0000,
    0xb200_0000,
    0x2900_0000,
    0xcf80_0000,
    0x0d40_0000,
    0x5720_0000,
    0x4590_0000,
    0x2e88_0000,
    0xb2a4_0000,
    0x55d6_0000,
    0x1c2d_0000,
    0x2777_8000,
    0xe9fb_c000,
    0x4b5d_2000,
    0x768c_1000,
    0x26a3_8800,
    0x8fd2_dc00,
    0x792e_ba00,
    0x66f5_9100,
    0xfbbe_2080,
    0x48f8_e640,
    0xd8dc_0820,
    0x9dcd_1c30,
    0x2285_9a28,
    0x10c4_811c,
    0xa362_28ae,
    0x1535_fa61,
    0x5a59_920c,
    0xfd09_9d3a,
    0x39e7_b29b,
    0x81f1_7b5f,
    0x4b3b_ba9b,
    0xc13c_6740,
    0xac3e_20af,
    0x71b8_e64a,
    0x25fc_0800,
    0x055d_1c09,
    0xc98d_9a36,
    0x0220_811c,
    0xdc14_28a8,
    0x68c8_fa59,
    0xcb06_1236,
    0xee86_5d0c,
    0x5ec4_9292,
    0x1c64_6b41,
    0x31b1_b2a9,
    0x099c_7b64,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x7000_0000,
    0x0800_0000,
    0x3400_0000,
    0x3a00_0000,
    0x0d00_0000,
    0x7f80_0000,
    0xbb40_0000,
    0x09a0_0000,
    0xd870_0000,
    0x3708_0000,
    0xb824_0000,
    0x7432_0000,
    0x5c2b_0000,
    0xdc97_8000,
    0xcdda_4000,
    0x3bde_a000,
    0x70dc_5000,
    0x6c5d_2800,
    0xef9c_dc00,
    0x27fa_ca00,
    0x06ef_4500,
    0x6173_8f80,
    0x328e_ba40,
    0x6e62_a820,
    0x7212_9c10,
    0x371e_6a18,
    0xd63c_151c,
    0x978b_2782,
    0x75e3_264d,
    0xeb51_422e,
    0x7fbb_c913,
    0x77ce_6d87,
    0x18c2_2372,
    0x8ce6_6da0,
    0x8ed6_236b,
    0xd9fc_6dbb,
    0x79e9_2361,
    0x47f1_edb8,
    0xbc4c_6378,
    0xd982_cd81,
    0xe845_7347,
    0x5924_c5a8,
    0x5db4_bf5e,
    0xfc6a_07af,
    0xd1b1_3676,
    0xda68_ca1a,
    0xc2b4_4506,
    0xeaec_0f8f,
    0x3770_fa63,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x7000_0000,
    0x6800_0000,
    0x3c00_0000,
    0xba00_0000,
    0xbf00_0000,
    0x9a80_0000,
    0xd940_0000,
    0x5c60_0000,
    0x4110_0000,
    0x5f68_0000,
    0xa8e4_0000,
    0x6156_0000,
    0xfc8b_0000,
    0x6537_8000,
    0x499d_4000,
    0xac5e_e000,
    0xfc7c_5000,
    0xbc8f_b800,
    0xc537_b400,
    0x599e_da00,
    0xb459_3b00,
    0xa878_2c80,
    0x3a8f_b940,
    0xc030_3820,
    0x7c1e_f430,
    0xf79e_3a18,
    0x2d5a_6b1c,
    0x27fe_149a,
    0xde4a_4d4f,
    0x8b91_820e,
    0x3e2d_df1f,
    0xb080_cebe,
    0xbe43_766a,
    0xf2e1_aead,
    0x6e56_666f,
    0x6e0e_f681,
    0xf072_8269,
    0xc7fe_149c,
    0x6e4a_4d6a,
    0x8391_8202,
    0x722d_df0e,
    0x6280_ceb6,
    0x3d43_765f,
    0xd261_ae92,
    0x0816_6678,
    0xa8ee_f6bf,
    0x6822_8270,
    0xc4f6_149d,
    0x87be_4d61,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0xd000_0000,
    0x2800_0000,
    0x4c00_0000,
    0xda00_0000,
    0xd300_0000,
    0xad80_0000,
    0xd1c0_0000,
    0x6fa0_0000,
    0xb830_0000,
    0xf1b8_0000,
    0x9c24_0000,
    0x9cf6_0000,
    0x629d_0000,
    0x3f52_8000,
    0xc0af_4000,
    0xbdeb_6000,
    0x210a_5000,
    0xd8d8_d800,
    0x6036_8c00,
    0x85bc_9e00,
    0x8221_4500,
    0x09f5_dd80,
    0xee1f_6bc0,
    0xdc12_5820,
    0x094d_cc30,
    0x68b9_fe28,
    0xaaa2_1534,
    0xdcb1_858a,
    0xfeff_a7d3,
    0x5fc1_2616,
    0xb2a4_9904,
    0x08b5_1b83,
    0x30fa_e2c0,
    0xe2c2_fbb1,
    0x7226_f2cd,
    0x31f5_c382,
    0x2a18_6ed7,
    0x9a10_658e,
    0x284e_b7fb,
    0x5a3c_9e20,
    0x0ce1_453d,
    0xb1d5_ddac,
    0x84ef_6bc8,
    0xc78a_583d,
    0xb099_cc0d,
    0xb057_fe3c,
    0x3f2b_152d,
    0x232d_058c,
    0x1129_e7c5,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0xd000_0000,
    0xd800_0000,
    0x0c00_0000,
    0xee00_0000,
    0x9d00_0000,
    0xf280_0000,
    0x18c0_0000,
    0xd4e0_0000,
    0xf370_0000,
    0x11e8_0000,
    0xdb64_0000,
    0x2936_0000,
    0xf5c9_0000,
    0xf8f2_8000,
    0xf1a8_c000,
    0x4045_6000,
    0x8b27_f000,
    0x5a13_2800,
    0x73d9_7400,
    0xbd2d_7600,
    0xdd80_2f00,
    0x8140_7f80,
    0x8fa3_2140,
    0xf3d7_a820,
    0x6bb8_b430,
    0x139a_9608,
    0xe60f_1f34,
    0x5f96_37b6,
    0xfe9d_a543,
    0xdc89_f61b,
    0xb351_ef17,
    0x187f_9fb4,
    0x84f8_1172,
    0xc13f_e023,
    0xc75b_300f,
    0xfce8_4837,
    0xe1e3_8425,
    0xc5f2_de00,
    0x132c_9b38,
    0xa084_e9b0,
    0x83c1_3e67,
    0x9f65_1f88,
    0xf334_d162,
    0x7acc_8001,
    0x7175_c019,
    0x52e9_e02b,
    0x9ce2_300a,
    0xc772_c837,
    0x03ef_4418,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0xb000_0000,
    0x0800_0000,
    0x5c00_0000,
    0xf600_0000,
    0x6900_0000,
    0x0f80_0000,
    0x59c0_0000,
    0x2260_0000,
    0x6ef0_0000,
    0x7328_0000,
    0xb4e4_0000,
    0x10b6_0000,
    0x048f_0000,
    0xb671_8000,
    0x306e_4000,
    0x66c1_e000,
    0xd4e4_3000,
    0x60b4_0800,
    0xec8f_1c00,
    0x5a71_3e00,
    0xce6e_bb00,
    0x53c7_bb80,
    0x2d61_9f40,
    0x5073_8820,
    0xc16e_5c30,
    0x6d41_5e38,
    0x9f24_cb2c,
    0x89d2_5382,
    0x4efa_b357,
    0xe01e_be1d,
    0x67ab_fb2a,
    0x59a1_dbbb,
    0x4f94_ef7a,
    0x6d5f_e02a,
    0x488f_303c,
    0xd873_8819,
    0x5d6e_5c1b,
    0x7b41_5e05,
    0x4624_cb00,
    0x8e52_5398,
    0x4b3a_b34d,
    0x347e_be26,
    0x605b_fb3e,
    0x2509_dbac,
    0xa2b0_ef4d,
    0x5f89_e005,
    0x22f0_3035,
    0x1d2a_080c,
    0xd9e4_1c09,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x5000_0000,
    0xd800_0000,
    0x2c00_0000,
    0xfa00_0000,
    0x0300_0000,
    0xce80_0000,
    0x31c0_0000,
    0xff60_0000,
    0xb4f0_0000,
    0x5c08_0000,
    0x0ae4_0000,
    0xf7b6_0000,
    0xd0ab_0000,
    0x3e76_8000,
    0xf3c8_c000,
    0x9886_6000,
    0x08c3_5000,
    0x52e5_d800,
    0x1bb5_9400,
    0x4aa8_9e00,
    0x6d72_8300,
    0xe54a_0380,
    0x8544_7640,
    0x0da5_5820,
    0xe516_5430,
    0x8938_7e18,
    0x7189_1314,
    0x65a1_bbb6,
    0x8116_b24b,
    0xe73e_1e1e,
    0xf48a_4330,
    0x8a24_63ab,
    0x5153_2658,
    0x1d1e_8029,
    0x8ddc_c016,
    0x5338_6031,
    0x828c_5016,
    0x4325_5838,
    0x14d6_5433,
    0x1658_7e0e,
    0x9579_1311,
    0xe1a9_bb82,
    0xa7f2_b24c,
    0xea88_1e36,
    0x2721_432f,
    0x7ad2_e392,
    0x935b_e671,
    0x7af8_e034,
    0x31ef_902c,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x3000_0000,
    0x7800_0000,
    0xc400_0000,
    0xf200_0000,
    0x9f00_0000,
    0x7480_0000,
    0x87c0_0000,
    0x1820_0000,
    0xfa70_0000,
    0x0a08_0000,
    0x3ba4_0000,
    0x7536_0000,
    0xc3eb_0000,
    0x84f5_8000,
    0x16cd_c000,
    0xc501_2000,
    0xa780_1000,
    0xdd44_3800,
    0x06e4_0400,
    0x83d0_6e00,
    0x583a_1900,
    0x28cf_e780,
    0xb402_9640,
    0x2a07_b820,
    0x0b02_c430,
    0xce84_ce18,
    0xa4c7_c90c,
    0x5aa2_ff9e,
    0x10b2_8271,
    0xf9ad_ee1c,
    0x3293_d917,
    0xe0d8_c785,
    0x1a19_866d,
    0x01be_0038,
    0xe48f_003f,
    0x0f63_8026,
    0x0796_c025,
    0x5f5c_a01e,
    0x3359_d020,
    0x8d5b_181b,
    0x3c5b_141c,
    0xd1df_d62e,
    0x379c_dd06,
    0x87fd_29ac,
    0x64ee_5f4f,
    0x9470_c7a3,
    0x330d_866d,
    0x0a20_001e,
    0x9570_0008,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x5000_0000,
    0x4800_0000,
    0xbc00_0000,
    0xae00_0000,
    0x0100_0000,
    0x1980_0000,
    0xfcc0_0000,
    0xc760_0000,
    0x8bf0_0000,
    0xca18_0000,
    0x67e4_0000,
    0xeab2_0000,
    0x9bbb_0000,
    0x2076_8000,
    0xe9d8_4000,
    0xc002_e000,
    0x2005_f000,
    0x3001_4800,
    0x1807_ac00,
    0xf400_d600,
    0x1203_d300,
    0xaf01_e380,
    0x1881_bec0,
    0xe545_c820,
    0x3ba4_ec10,
    0x4c94_b618,
    0x41ee_6314,
    0xadfa_4b92,
    0x8d57_e2ef,
    0x710e_560b,
    0xbbcf_9310,
    0xc9a9_039e,
    0x29db_4eeb,
    0xe000_0003,
    0x1000_001d,
    0x2800_0001,
    0xec00_000d,
    0xe600_002e,
    0xbd00_0036,
    0xb780_0012,
    0xfdc0_0018,
    0xdee0_0004,
    0x7730_002e,
    0x0d78_0007,
    0xec14_0002,
    0x20aa_0007,
    0xfc5f_0027,
    0xcac4_8021,
    0x7263_4028,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x9000_0000,
    0x0800_0000,
    0x8400_0000,
    0xae00_0000,
    0x8900_0000,
    0xea80_0000,
    0xbb40_0000,
    0xb0a0_0000,
    0x3250_0000,
    0xd508_0000,
    0x6724_0000,
    0x7596_0000,
    0xabef_0000,
    0xbd50_8000,
    0x828e_4000,
    0xe0e7_2000,
    0xeb77_f000,
    0xe19b_0800,
    0x424b_f400,
    0x4d82_ea00,
    0x18c4_ed00,
    0x0160_3680,
    0xa9b3_fa40,
    0x5ffd_8820,
    0x047a_b430,
    0x69bd_4a38,
    0x3059_5d24,
    0x89aa_1e82,
    0x2f70_fe61,
    0x6f9c_ea0b,
    0xbb4f_ed12,
    0x3f06_b682,
    0x2f82_ba4a,
    0x9bc2_280e,
    0xbce7_041d,
    0xe977_6226,
    0x329a_591f,
    0x17cb_7ca5,
    0x1945_a765,
    0xd3a7_1688,
    0x1fd4_0a7e,
    0x9dce_802f,
    0x8e45_4019,
    0xc821_a033,
    0x5216_b033,
    0xb42c_a820,
    0xafb2_443c,
    0xe2fe_c234,
    0x38f8_e936,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0xd000_0000,
    0x9800_0000,
    0xb400_0000,
    0xbe00_0000,
    0xe300_0000,
    0x0e80_0000,
    0xa940_0000,
    0x9f60_0000,
    0xd430_0000,
    0x8b18_0000,
    0x2ee4_0000,
    0xf1f6_0000,
    0xec39_0000,
    0x5232_8000,
    0xcc1a_c000,
    0x2660_a000,
    0xdfb5_7000,
    0x5bda_d800,
    0x7847_5400,
    0x68e2_7a00,
    0x96f7_4300,
    0x34bd_a580,
    0xe476_cac0,
    0xcffe_5820,
    0xb214_9430,
    0x9848_5a08,
    0xe5cc_f334,
    0x3a09_dda6,
    0x4829_eeed,
    0xf57a_7a0f,
    0x6553_4308,
    0xc42b_a58b,
    0xef7f_cade,
    0x8054_d821,
    0x4daa_5428,
    0x6ebe_fa05,
    0xe170_8307,
    0xb679_8599,
    0x7bd0_7afc,
    0xd56e_a03c,
    0x1418_700e,
    0x7266_5820,
    0x91b0_9422,
    0xf0de_5a2b,
    0x5ac5_f33d,
    0xcba3_5d83,
    0x5497_2ee5,
    0x0d0c_da1b,
    0xc8af_332f,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x5000_0000,
    0x3800_0000,
    0xfc00_0000,
    0x4200_0000,
    0x4700_0000,
    0xdd80_0000,
    0x8c40_0000,
    0xa3e0_0000,
    0xbfd0_0000,
    0xd8f8_0000,
    0x1b64_0000,
    0xb912_0000,
    0xf2df_0000,
    0x2716_8000,
    0x07db_c000,
    0x3594_e000,
    0xc21a_9000,
    0x9c30_f800,
    0x2729_8c00,
    0x239c_b200,
    0xf274_4700,
    0x73cd_c280,
    0x29ce_fdc0,
    0x62cc_7820,
    0x7549_4c10,
    0x2a0c_d238,
    0xd26a_1714,
    0x18ff_5a8e,
    0xbb66_21ff,
    0x0914_d230,
    0x9ade_1701,
    0xe315_5a8f,
    0xb9dd_21f7,
    0x3090_5206,
    0x589a_d700,
    0xcdf7_3a9e,
    0x088c_71c3,
    0x3fac_4a37,
    0x955d_cb30,
    0xb051_7089,
    0x8bba_baeb,
    0x2901_baa2,
    0xa087_b1fa,
    0x0ac0_aa29,
    0xe023_5b0f,
    0xef73_88b6,
    0xe54c_36f3,
    0xb20b_88a9,
    0x9e68_36d7,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xd000_0000,
    0x4800_0000,
    0x9400_0000,
    0x2e00_0000,
    0x4500_0000,
    0x0680_0000,
    0x67c0_0000,
    0xb8e0_0000,
    0x4ad0_0000,
    0x1ae8_0000,
    0xe564_0000,
    0x9692_0000,
    0xef49_0000,
    0x5292_8000,
    0xc948_4000,
    0xa391_a000,
    0x31cd_f000,
    0xc955_6800,
    0x1ba8_1400,
    0xca45_0e00,
    0xfca7_cf00,
    0x6370_5280,
    0x171b_e140,
    0xd1bd_e820,
    0x99cd_5410,
    0xed54_2e08,
    0x8dab_7f34,
    0x8346_1a92,
    0x0826_4565,
    0xfbb4_2e2b,
    0xc27b_7f01,
    0xbf2e_1a89,
    0x5a82_456d,
    0x9dc6_2e1c,
    0xf3e2_7f27,
    0xd954_9a85,
    0x33ae_055c,
    0xae45_8e16,
    0x4aa6_8f17,
    0xfa73_72b9,
    0xab9e_5145,
    0xdd79_201d,
    0x62a8_b019,
    0xc6c4_483a,
    0x4864_a40a,
    0x9413_4633,
    0xce8a_6b08,
    0xeb71_94b0,
    0xe319_ca71,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0xd000_0000,
    0xd800_0000,
    0x5400_0000,
    0x1a00_0000,
    0xe900_0000,
    0x3480_0000,
    0xc240_0000,
    0x2b20_0000,
    0x98b0_0000,
    0x2288_0000,
    0x14a4_0000,
    0xa376_0000,
    0x8d6b_0000,
    0xd072_8000,
    0x90e8_c000,
    0x46b5_a000,
    0xa988_5000,
    0x2d26_8800,
    0x47b3_8400,
    0x010b_0200,
    0x1966_3100,
    0x1b95_7180,
    0x8639_ee40,
    0x702a_0820,
    0xc8d4_4430,
    0xbd9a_2218,
    0x58dd_a134,
    0x747c_d9b6,
    0x930e_fa55,
    0xbc64_2226,
    0x0112_a10a,
    0x6778_5995,
    0x5e8d_3a44,
    0xf2a3_021c,
    0x6c72_3103,
    0x16eb_7196,
    0x59b6_ee4b,
    0xea0e_8833,
    0xf0e7_8436,
    0x2755_0220,
    0x5e59_310c,
    0xa339_f1a2,
    0xaaae_2e4a,
    0x4993_280f,
    0x433b_d41e,
    0xbaad_8a29,
    0xf195_b523,
    0xc73e_7383,
    0x78af_df5b,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0xb000_0000,
    0xb800_0000,
    0x3400_0000,
    0x2a00_0000,
    0x9300_0000,
    0x6e80_0000,
    0x8940_0000,
    0x0920_0000,
    0xaa90_0000,
    0xc438_0000,
    0x9aa4_0000,
    0xec52_0000,
    0xdddf_0000,
    0xfcd1_8000,
    0x1d9f_c000,
    0x5072_a000,
    0xd4ce_d000,
    0x862a_5800,
    0x4ad9_5400,
    0x4051_da00,
    0xd3dd_f100,
    0xadd4_3080,
    0xdc1d_13c0,
    0x11b1_d820,
    0xd9ad_9410,
    0xf218_fa38,
    0x50b7_e12c,
    0xf02f_48ae,
    0x8fda_57cd,
    0xfbd1_7a2a,
    0x091c_2134,
    0x4237_e8a3,
    0x3f6f_87ce,
    0xbbf8_a20c,
    0x3ec5_b537,
    0x8de5_1283,
    0x1c73_66ee,
    0x6acc_6aae,
    0x6f2b_22c8,
    0xbf5d_48af,
    0x2b95_57f5,
    0x4db8_fa08,
    0xb767_e100,
    0x4f37_4884,
    0xa8ee_57ca,
    0x2f3b_7a01,
    0x6027_210e,
    0x1f14_68af,
    0x4fff_47f5,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x7000_0000,
    0xc800_0000,
    0x6c00_0000,
    0x1e00_0000,
    0x2d00_0000,
    0x7180_0000,
    0x09c0_0000,
    0x0960_0000,
    0x4a70_0000,
    0x6f58_0000,
    0xc0a4_0000,
    0xe312_0000,
    0xb52f_0000,
    0x17ff_8000,
    0x87b0_4000,
    0x243e_6000,
    0x91d0_7000,
    0xccce_a800,
    0xdbcd_ac00,
    0xb54e_5e00,
    0x1e0e_9300,
    0x3229_5780,
    0xc17c_88c0,
    0x88f0_c820,
    0x7a1d_dc10,
    0x5180_f638,
    0xd9c3_3f1c,
    0x5167_09b2,
    0x9e72_1bdb,
    0xd559_9fa7,
    0x9fa1_54db,
    0xa190_3e04,
    0xe06e_e30e,
    0x66df_ff88,
    0xcd65_24d5,
    0x0874_960e,
    0x7458_4f30,
    0x8024_219b,
    0x4d50_f7f8,
    0xf48e_2189,
    0x3b6b_f7fa,
    0x865b_a18f,
    0xf320_b7c1,
    0xf1d0_41a6,
    0xfccb_87fe,
    0xf3cd_09bf,
    0xa949_1bc5,
    0xc80c_1faa,
    0x732a_14db,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x7000_0000,
    0x6800_0000,
    0xc400_0000,
    0xc600_0000,
    0xa700_0000,
    0x7180_0000,
    0x0340_0000,
    0x2c20_0000,
    0x4170_0000,
    0xfc58_0000,
    0x0f64_0000,
    0x5d52_0000,
    0x752d_0000,
    0x473f_8000,
    0xfc35_4000,
    0x4b79_2000,
    0x8594_b000,
    0x1f4f_f800,
    0xeaef_ec00,
    0x8cdd_8a00,
    0x4aa2_2900,
    0xbbb6_1f80,
    0xc73f_84c0,
    0xbc36_d820,
    0xeb7b_5c10,
    0xf592_7228,
    0x774d_c51c,
    0x2eeb_959a,
    0x4add_adf1,
    0xeda0_c791,
    0xca34_d8f9,
    0xc47c_aa14,
    0x9012_990c,
    0xaa0b_e7b9,
    0x09cd_68fd,
    0x782c_d234,
    0x73b8_350b,
    0x3ff7_4d92,
    0xaa9f_f1e8,
    0x3607_35bc,
    0x8f05_5dce,
    0x1583_9f9f,
    0xb543_c4d7,
    0xe322_7821,
    0xf4f7_ac19,
    0x391b_2a2d,
    0x8443_d924,
    0x6da0_c7a5,
    0x8a34_d8f4,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0xd000_0000,
    0xf800_0000,
    0x2400_0000,
    0x3600_0000,
    0x0700_0000,
    0xe680_0000,
    0xb840_0000,
    0xc2e0_0000,
    0xcab0_0000,
    0x01a8_0000,
    0x02a4_0000,
    0x6c52_0000,
    0x9d1b_0000,
    0xd40a_8000,
    0x7071_c000,
    0x6d08_2000,
    0xbdf0_3000,
    0x69cb_7800,
    0xfa56_d400,
    0x6a19_d200,
    0x7a8f_5f00,
    0xc430_f980,
    0x45ed_8b40,
    0x6243_5820,
    0xbfe6_e410,
    0xa132_aa18,
    0x9a69_8b34,
    0x5781_2bbe,
    0x19c6_d449,
    0xfc21_a1ad,
    0x6010_6f51,
    0xf1fb_7201,
    0xedbe_af0a,
    0x595b_a196,
    0xf4ef_6f4f,
    0xc3c3_f213,
    0x8124_6f18,
    0x0b91_01b7,
    0x6a3a_9f7c,
    0xb89a_aa22,
    0x2ccd_8b19,
    0x95d3_2bbe,
    0x77dd_d468,
    0x00ab_21a6,
    0x8b21_af6e,
    0x8e93_5231,
    0x25be_9f32,
    0x1558_d980,
    0x7eed_bb71,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x1000_0000,
    0xa800_0000,
    0xa400_0000,
    0xc200_0000,
    0xa500_0000,
    0x5580_0000,
    0xcd40_0000,
    0x4960_0000,
    0x8590_0000,
    0x47a8_0000,
    0x9024_0000,
    0x76f6_0000,
    0x4b39_0000,
    0xf40c_8000,
    0xe497_4000,
    0x202a_2000,
    0x6063_9000,
    0x7616_e800,
    0xcdeb_cc00,
    0x39c1_da00,
    0xc3a2_3300,
    0x2cb7_8880,
    0x6ad8_6b40,
    0xf55c_c820,
    0xe918_5c30,
    0xbfff_3208,
    0xe62d_ff04,
    0xd760_52aa,
    0x0e93_5869,
    0xe12f_c090,
    0xd7e3_7759,
    0x0e57_da3d,
    0x790b_3307,
    0xd513_08b0,
    0x0f6b_2b4c,
    0x9c00_e82b,
    0x0e02_cc14,
    0xe305_5a30,
    0x2281_730c,
    0x95c3_a890,
    0x75a6_fb42,
    0xc3b0_a01b,
    0x2e5d_d004,
    0x0798_480c,
    0x6c3b_1c32,
    0xe48b_1216,
    0x4c53_6f13,
    0x1c0c_3a9f,
    0xa096_d476,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0xb000_0000,
    0x8800_0000,
    0xa400_0000,
    0x3a00_0000,
    0xbb00_0000,
    0x2b80_0000,
    0x95c0_0000,
    0xb760_0000,
    0x5730_0000,
    0xb958_0000,
    0xdea4_0000,
    0xa656_0000,
    0xd369_0000,
    0x5179_8000,
    0x6bb6_4000,
    0x591a_2000,
    0x5d01_5000,
    0x6682_1800,
    0x0b41_3c00,
    0xb025_de00,
    0xc915_f300,
    0x794b_1d80,
    0x936d_e8c0,
    0xb178_3820,
    0xfbb0_6c30,
    0x611f_c608,
    0x7100_cf2c,
    0xf880_c3a2,
    0x8a45_1be9,
    0x20a4_a5ae,
    0x7756_c4de,
    0x5bea_5e22,
    0x733a_b339,
    0x5f10_bd87,
    0x9c4e_f8d0,
    0x19ee_0022,
    0x043d_0000,
    0x7a97_8025,
    0xb08b_4013,
    0x120d_a011,
    0x734a_1003,
    0x606f_b81b,
    0x1efb_2c1b,
    0xe472_6614,
    0xe57a_df24,
    0xa9b7_7bbc,
    0xee1a_37c9,
    0x5880_c392,
    0xfa45_1bee,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x9000_0000,
    0x4800_0000,
    0xc400_0000,
    0xb200_0000,
    0xcd00_0000,
    0xcc80_0000,
    0x7140_0000,
    0x07a0_0000,
    0x7830_0000,
    0x2748_0000,
    0x94e4_0000,
    0x9a92_0000,
    0xe7f9_0000,
    0xa8e8_8000,
    0x48d4_4000,
    0xbfdd_2000,
    0x661c_1000,
    0x72fe_a800,
    0xa86d_0400,
    0x6f93_ba00,
    0x577e_0500,
    0x57ae_2d80,
    0x2c77_a440,
    0xf86b_8820,
    0x4795_1410,
    0x237f_1208,
    0x3daa_0124,
    0x6d75_1792,
    0x42ed_e171,
    0x49d0_858c,
    0x255a_a063,
    0xf858_321b,
    0x3cdb_1128,
    0xa999_3f9b,
    0x8c39_a54b,
    0x710c_9f97,
    0x5ec1_f577,
    0x0967_1791,
    0x5954_e162,
    0x0a18_05a2,
    0xf4fe_e055,
    0x2f6d_1231,
    0x7213_0114,
    0xd4bd_97b6,
    0x9a49_a14c,
    0xe065_a5bb,
    0xd7d2_b06e,
    0x4e5c_9a2f,
    0x23db_1520,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x3000_0000,
    0x4800_0000,
    0xac00_0000,
    0xb200_0000,
    0x8f00_0000,
    0xd780_0000,
    0x14c0_0000,
    0x9b60_0000,
    0x7030_0000,
    0x7078_0000,
    0x35a4_0000,
    0xe856_0000,
    0xb5cf_0000,
    0xa61d_8000,
    0x7510_4000,
    0x276c_6000,
    0xc5cf_1000,
    0xce1d_b800,
    0x0914_9c00,
    0xed68_d600,
    0xaecd_f300,
    0x079d_e580,
    0x20d2_29c0,
    0x2e89_d820,
    0x1dbf_8c30,
    0xf843_6e38,
    0xfe26_6f0c,
    0xc690_b392,
    0xedab_9aeb,
    0x83ae_5d8c,
    0xd6ad_b5d3,
    0xf22a_8e2d,
    0xfb6d_3f39,
    0x1fcf_6b8c,
    0x3d1b_16fb,
    0x1490_b382,
    0x92ab_9af5,
    0xfc2e_5dbb,
    0x5e6d_b5f7,
    0x934a_8e30,
    0xa85d_3f13,
    0x0a37_6bb5,
    0x937f_16e4,
    0xb026_b3be,
    0x4394_9adf,
    0xb12b_dd8f,
    0x6ee9_f5dd,
    0x2c08_ee24,
    0xedf9_2f27,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0xd000_0000,
    0x1800_0000,
    0x6400_0000,
    0x7600_0000,
    0xdb00_0000,
    0x1580_0000,
    0x37c0_0000,
    0x63a0_0000,
    0xa5b0_0000,
    0xbbf8_0000,
    0x6a64_0000,
    0xa116_0000,
    0xb9cd_0000,
    0x9b5a_8000,
    0x7e52_c000,
    0xfb28_2000,
    0xbb0c_3000,
    0x927a_9800,
    0x2fa4_4c00,
    0x1fb4_ae00,
    0x1afd_3500,
    0x7ee2_3980,
    0x5252_9dc0,
    0x312a_b820,
    0xd20c_7c30,
    0xfaf8_3628,
    0xcee4_7934,
    0x3a54_1786,
    0x9d29_68d9,
    0xd80e_a1bd,
    0x33fb_d1c6,
    0x7664_960d,
    0xc313_8909,
    0xdcca_2fb6,
    0x29de_d4c4,
    0x4e12_3795,
    0x024c_58c5,
    0xb398_b9b8,
    0xae70_5dd1,
    0xaa5a_9835,
    0x12d4_4c26,
    0x1c6c_ae3b,
    0x8de9_3506,
    0x7c2c_39bc,
    0xac8b_9ddd,
    0xb0be_3829,
    0x3687_bc15,
    0xf644_961c,
    0x4a63_892f,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0xf000_0000,
    0x3800_0000,
    0xdc00_0000,
    0x8200_0000,
    0xcf00_0000,
    0x6a80_0000,
    0x4dc0_0000,
    0xa0e0_0000,
    0x4f50_0000,
    0xca18_0000,
    0xc324_0000,
    0xdab2_0000,
    0x5ccd_0000,
    0x5c7b_8000,
    0x03b7_c000,
    0xdf49_e000,
    0x4a3a_9000,
    0x3916_3800,
    0xe0bb_7400,
    0x94d6_1e00,
    0x105b_2f00,
    0x1381_7680,
    0x3e40_1ac0,
    0x8ea7_d820,
    0xa9f5_e410,
    0x77ea_2628,
    0xd2c9_5b3c,
    0x997e_e88e,
    0xe231_f5f7,
    0x560c_ce80,
    0xd21c_aee3,
    0xaf20_2612,
    0xc0b0_5b3f,
    0xbfcf_688e,
    0x8cff_35d8,
    0x5d74_aebc,
    0x9728_fee4,
    0x87ae_7e04,
    0x396f_7f1b,
    0x210f_2e83,
    0x249f_3ecb,
    0xc0e7_9e23,
    0x5f55_ef25,
    0xa219_1698,
    0xd724_4ac3,
    0xbcb1_8018,
    0xcdce_c034,
    0x7bf8_6036,
    0xebf4_5031,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0xb000_0000,
    0xa800_0000,
    0xe400_0000,
    0x3e00_0000,
    0xb700_0000,
    0xaf80_0000,
    0xd640_0000,
    0x71e0_0000,
    0x6930_0000,
    0xdf98_0000,
    0x75a4_0000,
    0xe5d6_0000,
    0x682f_0000,
    0x98f9_8000,
    0xea57_4000,
    0x2e6e_2000,
    0x111f_7000,
    0x7f67_7800,
    0x83f6_1c00,
    0x09ba_e200,
    0xbc33_0700,
    0x251f_ed80,
    0x9960_e2c0,
    0x98f1_5820,
    0xcc3d_6c30,
    0x4b73_9a38,
    0xa87e_1b2c,
    0xb792_8faa,
    0x57cf_a5f9,
    0x0ecf_15af,
    0xce4a_bedd,
    0x1b8a_1a33,
    0xd629_5b29,
    0xeffc_af8e,
    0xa5d0_d5cf,
    0x4828_6db2,
    0xc8fc_a2f9,
    0xf250_f805,
    0x626a_5c1e,
    0xcb1b_4203,
    0xf664_3700,
    0x9b77_3585,
    0x707a_ced7,
    0x1b94_e215,
    0x3dc8_070f,
    0x2fc8_6d92,
    0x32cc_a2cc,
    0x5c48_f805,
    0xc68e_5c16,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0xb000_0000,
    0xd800_0000,
    0x0400_0000,
    0x2a00_0000,
    0x2f00_0000,
    0xc180_0000,
    0x5fc0_0000,
    0xc720_0000,
    0x0730_0000,
    0x76e8_0000,
    0x9ee4_0000,
    0x7916_0000,
    0xa15d_0000,
    0x1b49_8000,
    0x4d94_c000,
    0xa81b_2000,
    0x562d_d000,
    0x9040_3800,
    0xede3_ec00,
    0x5693_0e00,
    0x5b9d_5100,
    0x82ed_ad80,
    0x0ce4_3540,
    0x4213_1820,
    0x22da_3c30,
    0xb78d_3628,
    0x6537_bd2c,
    0xf5e9_23b6,
    0x0964_a441,
    0x97d2_15aa,
    0x7afe_197b,
    0xa93a_b638,
    0x481a_7d0b,
    0x862d_83af,
    0x5840_b46c,
    0x81e0_8d81,
    0xa094_e55d,
    0x5a9a_a02c,
    0x466d_1028,
    0xbda5_1819,
    0x1b77_3c28,
    0xbd0c_b63a,
    0x0177_7d39,
    0x8a0c_039d,
    0x64f0_7468,
    0x4fcd_adac,
    0x54d4_354b,
    0x8d7b_1828,
    0x57fe_3c3f,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x1000_0000,
    0x6800_0000,
    0x5c00_0000,
    0xae00_0000,
    0xad00_0000,
    0x5a80_0000,
    0x9ac0_0000,
    0xcea0_0000,
    0xf5b0_0000,
    0xbdc8_0000,
    0x9964_0000,
    0x9196_0000,
    0x8ab9_0000,
    0xce0c_8000,
    0x6741_4000,
    0xf9e5_e000,
    0x8454_f000,
    0x559e_a800,
    0x1aff_7400,
    0x1269_4600,
    0x3055_6d00,
    0x679f_9180,
    0x39fd_2c40,
    0xf5ed_4820,
    0x9812_8430,
    0x6ffb_6e08,
    0xaceb_5904,
    0x1093_379a,
    0xe63c_b157,
    0xfdcc_718b,
    0x7960_dc5b,
    0xa197_603e,
    0xf2b8_b012,
    0xfa09_c821,
    0x9547_c42e,
    0xfae0_8e1e,
    0x73d2_a91a,
    0x95df_1f99,
    0x4e9f_856f,
    0x297a_57b6,
    0x7829_0172,
    0x4337_398a,
    0x310b_584e,
    0xeec0_8e2c,
    0xdca2_a921,
    0xc6b7_1faa,
    0x324b_854f,
    0x6d24_5793,
    0x37f4_015c,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x5000_0000,
    0x8800_0000,
    0xac00_0000,
    0x4a00_0000,
    0x3d00_0000,
    0x9980_0000,
    0x9b40_0000,
    0xdf20_0000,
    0x0370_0000,
    0x0398_0000,
    0x3164_0000,
    0x49d2_0000,
    0x61af_0000,
    0x08de_8000,
    0xc642_4000,
    0x56a0_6000,
    0xf037_d000,
    0x20bf_2800,
    0xf011_ec00,
    0xdb49_ea00,
    0x834e_4100,
    0xe749_bf80,
    0xe14d_4ac0,
    0xc64d_4820,
    0xeac9_3c10,
    0x4408_4238,
    0x4a6d_ed14,
    0xab38_35a2,
    0x3250_dbeb,
    0x9be9_dfb2,
    0x3c7a_9adf,
    0x1772_603e,
    0x7d98_d022,
    0x8261_a82d,
    0x5b53_ac3f,
    0x9c69_8a30,
    0x4439_9128,
    0x52d6_97a6,
    0x2f2c_a6f1,
    0x871c_a233,
    0xc3a3_7d07,
    0x35b3_fd9a,
    0xc9ff_a7e4,
    0x6633_fd98,
    0x2fbf_a7d3,
    0xc093_fdac,
    0xe78f_a7c2,
    0x942b_fdb2,
    0x799b_a7fc,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0xf000_0000,
    0xc800_0000,
    0xf400_0000,
    0xf600_0000,
    0x0f00_0000,
    0x7680_0000,
    0xa7c0_0000,
    0xb820_0000,
    0x1d30_0000,
    0x3b98_0000,
    0xa8e4_0000,
    0x2f96_0000,
    0x636f_0000,
    0x225b_8000,
    0x2bc4_4000,
    0x5226_a000,
    0x0037_3000,
    0x8c19_b800,
    0x4aa6_5400,
    0x44f3_2e00,
    0x98bd_0900,
    0xc550_a580,
    0x74cf_16c0,
    0xf129_1820,
    0x413e_6430,
    0xc411_1638,
    0xb32f_1d3c,
    0x983d_2bb2,
    0xad91_2ffd,
    0x5a6e_059d,
    0xbbdc_26f3,
    0x0a86_a005,
    0x85c7_3025,
    0x5121_b824,
    0x5cb2_5406,
    0xd6dd_2e01,
    0xb506_0914,
    0x7385_25ab,
    0x3c40_56f2,
    0x6062_381b,
    0xb352_1414,
    0xbbcd_8e0c,
    0x67ae_3911,
    0x16ff_1d94,
    0xb436_42dd,
    0x5a19_b60f,
    0x55a3_2d07,
    0x0a71_1388,
    0x0378_3bc2,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x5000_0000,
    0xe800_0000,
    0xe400_0000,
    0x9600_0000,
    0xed00_0000,
    0x2a80_0000,
    0xaec0_0000,
    0x13e0_0000,
    0xdf90_0000,
    0x9518_0000,
    0xdc24_0000,
    0xd4f2_0000,
    0x7f4f_0000,
    0xcd5e_8000,
    0xbb01_4000,
    0x6782_2000,
    0x3441_3000,
    0x0522_a800,
    0xc071_3400,
    0x388e_e600,
    0x323f_4700,
    0xcf56_c080,
    0x2ffd_8ac0,
    0x0f32_8820,
    0xba2f_0410,
    0x960a_ce38,
    0x1afb_3314,
    0x39b0_06ba,
    0x6ee8_fdf9,
    0x4aea_6085,
    0x7ced_faeb,
    0x21ea_0012,
    0xb36b_002f,
    0x11ac_8006,
    0x704e_401a,
    0xd4dc_a03a,
    0x8640_7035,
    0xde20_881a,
    0xb7f0_040f,
    0x04cc_4e3d,
    0x831e_7332,
    0x7120_26b8,
    0x1e76_cdcd,
    0x818e_48b1,
    0x36b9_8ec8,
    0x8094_c610,
    0x649a_7739,
    0x0566_689b,
    0xfb53_bec5,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xb000_0000,
    0xc800_0000,
    0x4c00_0000,
    0x6600_0000,
    0x0100_0000,
    0x4980_0000,
    0x07c0_0000,
    0x6fe0_0000,
    0xa390_0000,
    0x1388_0000,
    0x0d24_0000,
    0x7ff2_0000,
    0x88d9_0000,
    0x0dc9_8000,
    0x7d00_4000,
    0xa781_6000,
    0x6ac7_b000,
    0xf063_c800,
    0x6d56_6c00,
    0x79e9_6e00,
    0xcf74_4700,
    0x029d_5880,
    0x6fef_ee40,
    0x6670_a820,
    0x9718_dc10,
    0x762b_2608,
    0x8c96_6b2c,
    0x570f_56b2,
    0x0561_1953,
    0xa6d5_b8b9,
    0xc528_1e50,
    0xf612_003a,
    0x6a49_003d,
    0x77c1_8021,
    0xc7e4_4017,
    0x7f93_602f,
    0x0d8e_b010,
    0x8822_4814,
    0x1c72_2c23,
    0xe81a_0e0a,
    0x2aaa_f736,
    0x90d7_10b6,
    0xdc29_c271,
    0xab90_a607,
    0x3f8f_2b2a,
    0xfb27_b68a,
    0x06f6_e962,
    0x455f_10b8,
    0x200d_c25d,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x5000_0000,
    0xe800_0000,
    0x3c00_0000,
    0xe600_0000,
    0xaf00_0000,
    0xc580_0000,
    0x61c0_0000,
    0x8ea0_0000,
    0x7230_0000,
    0x24e8_0000,
    0xa464_0000,
    0x9b16_0000,
    0x4a1f_0000,
    0xeeae_8000,
    0x4805_4000,
    0x4c00_e000,
    0xbe02_b000,
    0x2b00_b800,
    0xf780_8c00,
    0x14c5_de00,
    0x0226_3d00,
    0x7970_c580,
    0x0e0c_0540,
    0x3936_5820,
    0x436d_3c30,
    0xb8a3_e638,
    0xf537_f114,
    0x3d6b_fbba,
    0x73a3_884f,
    0x52b6_a599,
    0xc1af_f55b,
    0x4d80_0029,
    0xcdc0_003c,
    0x60a0_0021,
    0xb130_0007,
    0xef68_000a,
    0x56a4_000d,
    0x3636_002e,
    0xf6ef_0021,
    0x8166_8029,
    0xff91_4016,
    0x7d5e_e039,
    0x2249_b01a,
    0x7a50_3825,
    0x51fe_cc06,
    0x2d7d_be18,
    0xbe3e_cd00,
    0xf0de_1db6,
    0x0f8b_797e,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x7000_0000,
    0x8800_0000,
    0x1c00_0000,
    0x1600_0000,
    0xc100_0000,
    0x2c80_0000,
    0x3cc0_0000,
    0x4620_0000,
    0xecb0_0000,
    0x8e38_0000,
    0xede4_0000,
    0x2716_0000,
    0xa2cd_0000,
    0xe13f_8000,
    0xf466_4000,
    0xed53_e000,
    0xf72e_3000,
    0x322d_c800,
    0x8caf_c400,
    0x236e_b600,
    0x7ac8_0900,
    0xc538_c980,
    0xd664_d3c0,
    0x5650_2820,
    0x84a8_f430,
    0xff6a_fe28,
    0xcccc_8d1c,
    0x743a_1fa2,
    0x72e4_aac7,
    0x7696_c9a5,
    0xd48d_d3c0,
    0xd2d9_a803,
    0x6e73_b423,
    0xa51e_9e1b,
    0x13d0_fd20,
    0x38ea_3784,
    0xbb8c_5ecc,
    0xcb5c_37a7,
    0xa431_5ee7,
    0xf0fb_b7aa,
    0xc0c3_1ee5,
    0x4026_57a3,
    0x75b4_2ed6,
    0x46ba_1f89,
    0x5324_aaeb,
    0xaa36_c99d,
    0xb5fd_d3df,
    0xbe41_a807,
    0x4fe7_b41a,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0xb000_0000,
    0x3800_0000,
    0xe400_0000,
    0x0e00_0000,
    0x7d00_0000,
    0xc980_0000,
    0xecc0_0000,
    0x9da0_0000,
    0x1990_0000,
    0xfc98_0000,
    0x1664_0000,
    0xe6b6_0000,
    0xc949_0000,
    0xd419_8000,
    0x3923_c000,
    0x74d0_2000,
    0x71fc_f000,
    0xc853_a800,
    0x48be_ac00,
    0x7335_3600,
    0x0f8c_f500,
    0x1ab9_a880,
    0x2436_6ec0,
    0x950d_8820,
    0xf2ff_5c30,
    0xa4d1_1e08,
    0x19fc_992c,
    0x8453_3e8e,
    0x2abc_abf9,
    0xdc36_28a3,
    0x510c_aeef,
    0x4cfc_281a,
    0xe1d4_6c27,
    0x347c_9621,
    0x6693_c513,
    0xca1a_20b2,
    0x0c24_32e3,
    0x4153_1628,
    0xc739_0526,
    0x1ef3_80a8,
    0x01ab_02df,
    0xa4e8_9e2b,
    0x158f_5916,
    0xb1bb_1ebf,
    0xe4b4_5bd6,
    0x364b_808c,
    0x229f_02cd,
    0x0366_9e22,
    0x6332_591e,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0xd000_0000,
    0xa800_0000,
    0xfc00_0000,
    0xe600_0000,
    0xe900_0000,
    0x7380_0000,
    0xe640_0000,
    0xda60_0000,
    0xe330_0000,
    0x4eb8_0000,
    0x4724_0000,
    0x29d2_0000,
    0x3f4d_0000,
    0x833a_8000,
    0x8c63_4000,
    0x9230_e000,
    0x193c_b000,
    0xc360_8800,
    0xa8b3_3c00,
    0x5cfa_e200,
    0x5744_2b00,
    0x6de4_8d80,
    0x1774_3bc0,
    0xb7da_6820,
    0x7096_8c10,
    0xe7aa_ea28,
    0xd1cd_5734,
    0x9cfe_0faa,
    0xb746_e0ff,
    0x1de6_0d99,
    0x6f73_7bea,
    0xe3d8_8814,
    0x6a97_3c1d,
    0xe8a8_e234,
    0x4b49_2b33,
    0x093e_0d80,
    0x8b67_7bd4,
    0x24b2_880f,
    0xc2fe_3c1c,
    0xea40_6222,
    0x0467_6b16,
    0xfe34_6dab,
    0xf738_8bd0,
    0x0662_e030,
    0x9531_b01e,
    0xafba_0809,
    0x18a0_7c34,
    0x8192_0203,
    0xf02c_9b27,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0xb000_0000,
    0x1800_0000,
    0x6c00_0000,
    0x1e00_0000,
    0x5b00_0000,
    0xfc80_0000,
    0x93c0_0000,
    0xb560_0000,
    0xf290_0000,
    0x5da8_0000,
    0x0224_0000,
    0x5832_0000,
    0x145d_0000,
    0x5e19_8000,
    0x8f3e_c000,
    0xaf88_6000,
    0xe216_7000,
    0x9068_9800,
    0x4c40_c400,
    0xe620_4e00,
    0xc231_2300,
    0x855c_b880,
    0x3b9f_7f40,
    0xbd79_7820,
    0x42a8_7410,
    0xd4a0_b628,
    0x42f7_972c,
    0xa8bc_6e86,
    0x80ca_985b,
    0x64b7_8ea7,
    0x679b_2846,
    0xfb7c_f6b7,
    0xd5ae_5c58,
    0x8625_c0a3,
    0x9237_0b5b,
    0x8d59_ce1e,
    0xff9f_e331,
    0xd77c_d880,
    0x6bad_0f40,
    0x6d23_e024,
    0x76b5_b026,
    0x7299_7801,
    0x54f8_741a,
    0x7ee8_b631,
    0xca83_9715,
    0xfcc6_6e85,
    0x9be3_987c,
    0x9454_0e83,
    0x574c_e864,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0xb000_0000,
    0xa800_0000,
    0x2400_0000,
    0xda00_0000,
    0x9900_0000,
    0x9e80_0000,
    0x8540_0000,
    0x4a20_0000,
    0xf7f0_0000,
    0x5768_0000,
    0x45e4_0000,
    0x0a92_0000,
    0x37bb_0000,
    0x11f9_8000,
    0xac5b_4000,
    0x886c_2000,
    0x8466_5000,
    0x0e55_0800,
    0x195e_1400,
    0x78ef_1a00,
    0x3a22_2900,
    0x7ff1_7380,
    0xa36e_fd40,
    0x87e0_a820,
    0x1f93_0410,
    0x573e_3218,
    0xd7be_6d2c,
    0xe1f9_61aa,
    0x6459_c049,
    0x1c6f_4196,
    0xf660_9076,
    0xb351_c99f,
    0x5dde_c45d,
    0x64ab_7380,
    0xee81_fd48,
    0x0d43_2831,
    0xbe27_4402,
    0x35f1_9221,
    0x426c_7d2f,
    0x2563_c9ad,
    0xccd5_c458,
    0x7a1a_f394,
    0xfdce_bd5a,
    0x3455_0819,
    0x705e_143a,
    0x2e6f_1a2d,
    0x2b62_2921,
    0x47d1_73b2,
    0xe99e_fd51,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0xd000_0000,
    0x4800_0000,
    0xe400_0000,
    0xf200_0000,
    0xf500_0000,
    0x6d80_0000,
    0xd8c0_0000,
    0x78e0_0000,
    0x3170_0000,
    0xddb8_0000,
    0xf1a4_0000,
    0x6f56_0000,
    0xc72b_0000,
    0xefea_8000,
    0xaf08_4000,
    0x827e_2000,
    0xd1c0_1000,
    0x8b66_6800,
    0x6ab3_8c00,
    0x1fda_b600,
    0xc892_9f00,
    0x9b4b_ff80,
    0x55dc_7fc0,
    0xe192_c820,
    0x18cb_dc30,
    0xf61a_fe18,
    0x5ff5_0334,
    0x7ff9_2192,
    0xe102_6cf9,
    0xa787_019c,
    0x31c2_7ccd,
    0x9b61_69a3,
    0x42b1_f0f2,
    0x2bdb_dfb4,
    0x7293_6ff1,
    0x8a48_2021,
    0xca5b_103c,
    0xcc54_e836,
    0x0daf_cc37,
    0x1faa_9610,
    0xfaad_8f15,
    0xbf29_17ae,
    0x53e8_b3cf,
    0x910a_de2b,
    0xb17a_131d,
    0xf343_c996,
    0x2f22_a0ec,
    0x5511_17a3,
    0x7b8c_b3ce,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x9000_0000,
    0xe800_0000,
    0x5400_0000,
    0xc600_0000,
    0x2300_0000,
    0xbb80_0000,
    0xefc0_0000,
    0x2920_0000,
    0xff70_0000,
    0xe018_0000,
    0xcb64_0000,
    0x0292_0000,
    0x81c9_0000,
    0xd1c8_8000,
    0x59c9_4000,
    0xbdcd_a000,
    0x03cd_b000,
    0x9ccd_d800,
    0xb54b_bc00,
    0xbf8f_2e00,
    0x0e28_0100,
    0xa51b_6f80,
    0x83e4_eac0,
    0x9ed0_f820,
    0x832b_4c10,
    0x299d_5608,
    0x31a7_0d24,
    0xeb31_19ba,
    0x06fe_17d5,
    0x8d31_1991,
    0xf5fe_17d8,
    0xfeb1_1986,
    0xde3e_17cf,
    0xf991_1998,
    0x564e_17de,
    0x6409_199b,
    0x51ea_17db,
    0xf43b_198d,
    0xc093_17f2,
    0xeccb_99b3,
    0xad4e_57fb,
    0xb38c_3990,
    0xe42e_e7df,
    0xfc1b_6198,
    0x8965_1bd2,
    0x2f91_6fa4,
    0xdd49_eaea,
    0xab8a_780d,
    0xe82b_0c09,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x9000_0000,
    0x5800_0000,
    0x4400_0000,
    0x2200_0000,
    0x6100_0000,
    0x2c80_0000,
    0x21c0_0000,
    0x4ee0_0000,
    0xee10_0000,
    0x65a8_0000,
    0xd9a4_0000,
    0x5432_0000,
    0x23d9_0000,
    0x9ed8_8000,
    0xb45c_c000,
    0x669d_2000,
    0xadfa_9000,
    0x52aa_4800,
    0x3e22_0400,
    0x0477_7e00,
    0x967d_0f00,
    0x04ec_6c80,
    0x7887_bf40,
    0x1bc7_e820,
    0x4be0_5410,
    0x7092_1608,
    0x7d6c_9b24,
    0xffc1_da96,
    0xb9e0_7451,
    0x6993_daa8,
    0x85e9_7448,
    0xa403_5aa3,
    0xd201_b47c,
    0x8904_7aad,
    0xa086_245e,
    0x1fc4_b2af,
    0x49e1_e04b,
    0x8196_6ca8,
    0x09ea_bf7d,
    0x9a05_6809,
    0xd501_9423,
    0xe685_b60e,
    0xccc3_cb03,
    0x5c66_329e,
    0xc8d0_204b,
    0x44c9_cc9a,
    0x5bf1_ef4d,
    0x7238_8003,
    0x7b4c_c021,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xf000_0000,
    0xa800_0000,
    0xcc00_0000,
    0xb600_0000,
    0xf900_0000,
    0xe580_0000,
    0xc840_0000,
    0x5ea0_0000,
    0x9310_0000,
    0x3f88_0000,
    0x3d64_0000,
    0x28f2_0000,
    0xe5b9_0000,
    0x2abb_8000,
    0x763b_4000,
    0x7bf9_6000,
    0x1d1d_3000,
    0x78aa_0800,
    0x1834_8c00,
    0xacdc_5200,
    0x4049_2d00,
    0x6883_6c80,
    0x6fc2_ca40,
    0x6de0_e820,
    0xf336_fc10,
    0xaa5d_3a08,
    0xf289_913c,
    0xbae6_b6aa,
    0xebb0_2b73,
    0x2d9c_b68d,
    0x736d_2b6e,
    0x0fd5_3691,
    0x10ef_6b5e,
    0xf697_d695,
    0xb7c9_1b7b,
    0x43c4_bea0,
    0x4be0_a76e,
    0x7232_e49c,
    0xdbdd_066a,
    0xe8cd_da0b,
    0x6746_e12a,
    0xd226_5eb0,
    0xc6d6_d76f,
    0x3d69_8c92,
    0x22d0_ba7b,
    0x0769_800f,
    0x4dd2_403f,
    0xebea_e007,
    0xc812_702e,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x9000_0000,
    0xb800_0000,
    0x7400_0000,
    0x9a00_0000,
    0x3500_0000,
    0xc780_0000,
    0xbfc0_0000,
    0xe320_0000,
    0x87b0_0000,
    0x32e8_0000,
    0xa564_0000,
    0xac56_0000,
    0xe0fd_0000,
    0xda78_8000,
    0x9e3f_c000,
    0xa4dc_a000,
    0x334f_5000,
    0x2297_e800,
    0x165f_dc00,
    0x2b0a_ce00,
    0x4e72_8100,
    0x5aca_1980,
    0x5251_0d40,
    0x37fb_c820,
    0xfcfb_4c30,
    0xec7f_8628,
    0x753b_0d24,
    0xe459_bfae,
    0xb20e_905d,
    0x57f7_3f86,
    0x620c_507d,
    0x8ff3_1fb9,
    0x260c_c07b,
    0x3df0_579e,
    0xdf08_4c68,
    0x1473_718c,
    0xcfcc_116d,
    0x05d5_261a,
    0x3039_5d13,
    0x6bde_d79f,
    0xf1ca_8c5d,
    0x72d7_5184,
    0x86bc_814b,
    0xa19e_6e08,
    0x5429_d103,
    0x3fc3_f194,
    0x2327_d152,
    0x27b7_863e,
    0xa2ef_0d2f,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x5000_0000,
    0xe800_0000,
    0x1400_0000,
    0x5600_0000,
    0x7900_0000,
    0x0880_0000,
    0xd6c0_0000,
    0xb8e0_0000,
    0xec90_0000,
    0xcf88_0000,
    0x0ca4_0000,
    0x99b2_0000,
    0x8c7b_0000,
    0x30fe_8000,
    0xc039_4000,
    0xd9dd_a000,
    0x91cd_3000,
    0x2283_0800,
    0xadc4_2400,
    0xff62_6600,
    0x1bd1_df00,
    0x4129_b880,
    0x9a15_5640,
    0x5448_2820,
    0xdac4_5410,
    0x62e6_ce18,
    0x0f97_cb14,
    0x440c_56ba,
    0x01e6_ed45,
    0xc412_d6b5,
    0x294f_ad4e,
    0x0c47_76ba,
    0x8926_9d71,
    0x01f6_7eac,
    0x1359_b97a,
    0x280a_98a4,
    0x8be1_265c,
    0xcf16_8033,
    0xb6cd_4009,
    0x5707_a017,
    0xad82_3031,
    0xac47_8806,
    0xf922_6432,
    0xd9f3_4624,
    0xbf5e_af1b,
    0x8209_908a,
    0xb0e5_0258,
    0xe894_e631,
    0x118c_9f39,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x7000_0000,
    0x3800_0000,
    0xf400_0000,
    0x5a00_0000,
    0x6d00_0000,
    0xb980_0000,
    0xd040_0000,
    0x0b60_0000,
    0x0990_0000,
    0x8e48_0000,
    0x04a4_0000,
    0x69b2_0000,
    0x963b_0000,
    0xadbf_8000,
    0xd4ff_c000,
    0x641a_a000,
    0x54cc_5000,
    0x0a64_2800,
    0x4e11_2c00,
    0x410a_b200,
    0x6740_0300,
    0x9fe0_5880,
    0x0052_2440,
    0x2569_0820,
    0x3e56_bc10,
    0x1a6e_3a18,
    0x46d2_7f1c,
    0xadab_428e,
    0x92f3_cb7d,
    0x8fdc_c2b6,
    0x26e8_0b4b,
    0xb314_6296,
    0xf08f_5b78,
    0x1b07_cab4,
    0x4a85_b773,
    0x06c5_d883,
    0x8ba2_e46b,
    0x0936_2814,
    0xc5fa_2c3b,
    0x6b9d_3207,
    0x578b_c339,
    0xc780_f88e,
    0x8f41_7444,
    0x03e0_a021,
    0x8653_500a,
    0xae69_a836,
    0x7cd5_ec22,
    0xb0af_9220,
    0x1373_933b,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0xb000_0000,
    0x3800_0000,
    0xdc00_0000,
    0xa200_0000,
    0x7b00_0000,
    0xc280_0000,
    0x22c0_0000,
    0xf1a0_0000,
    0x37b0_0000,
    0x37e8_0000,
    0xaae4_0000,
    0x0652_0000,
    0x033b_0000,
    0xd319_8000,
    0x48ef_c000,
    0xe663_e000,
    0xa591_9000,
    0x271c_9800,
    0x9ee8_b400,
    0x0b65_2600,
    0xea16_a500,
    0xfa5f_e180,
    0x8a0d_2540,
    0xf434_f820,
    0x80ad_e410,
    0x4103_de18,
    0xf580_412c,
    0xaa45_bf8e,
    0xfc62_a477,
    0x4292_a788,
    0x279e_d04e,
    0x772d_e188,
    0x0046_2574,
    0x2365_780a,
    0x9e16_2406,
    0x6c5a_3e33,
    0x070e_d12f,
    0x0bb2_a797,
    0x65ee_d061,
    0x89e5_e1b0,
    0xa8d2_2559,
    0xbbff_7800,
    0x85b9_243a,
    0x1fd9_be2f,
    0x884e_111b,
    0x3c52_c79c,
    0x343f_806b,
    0x5b99_198a,
    0x452b_c15f,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0xf000_0000,
    0xc800_0000,
    0x4400_0000,
    0xba00_0000,
    0xa500_0000,
    0xfb80_0000,
    0xb340_0000,
    0xc220_0000,
    0x5c30_0000,
    0x32d8_0000,
    0x67e4_0000,
    0x52d6_0000,
    0x458f_0000,
    0x9e2b_8000,
    0x685c_4000,
    0xb527_2000,
    0x96b3_5000,
    0x181b_e800,
    0xcf80_3c00,
    0x0142_2a00,
    0xc323_c900,
    0xedb2_4580,
    0xec98_b8c0,
    0x1a41_4820,
    0x07a0_2c30,
    0x1075_6238,
    0x5e7c_e53c,
    0xbb14_a7b2,
    0x556c_1dd1,
    0x067c_cf8e,
    0x0714_61d9,
    0x836f_c5a6,
    0xad7b_f8e0,
    0x2b95_e81a,
    0x2aab_3c0a,
    0x9d9f_aa28,
    0xa3c0_891d,
    0x7de6_e5b6,
    0x27d3_a8c5,
    0x660b_8027,
    0x516c_4038,
    0x9c7f_2017,
    0xb217_503b,
    0x40ed_e81c,
    0x923f_3c3d,
    0x17b1_aa11,
    0x699b_890b,
    0xf1c3_659b,
    0x8ce4_e8f9,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xd000_0000,
    0x6800_0000,
    0xfc00_0000,
    0x1a00_0000,
    0xe100_0000,
    0xb280_0000,
    0x8ec0_0000,
    0x0420_0000,
    0xfe90_0000,
    0x7698_0000,
    0xa564_0000,
    0x9cf2_0000,
    0xc3e9_0000,
    0x4bca_8000,
    0x575d_4000,
    0x74c0_e000,
    0x5525_5000,
    0xd413_c800,
    0xbc5f_b400,
    0x2f44_0600,
    0x6562_1900,
    0xfcf4_b880,
    0x33eb_dec0,
    0xf3cb_a820,
    0xc35e_a410,
    0x92c5_ae08,
    0xae21_bd34,
    0x8791_969a,
    0x801a_23ff,
    0xa5a2_5ea6,
    0x9fd5_97e8,
    0x74fe_5884,
    0xe013_8ec7,
    0xca58_e033,
    0x9c41_5024,
    0x1ae1_c809,
    0xb2b6_b41a,
    0xa40e_8617,
    0xa1ff_5914,
    0x2494_58b9,
    0xf79e_8ef1,
    0xe7e0_600d,
    0xaa35_1030,
    0x53cb_a806,
    0x535e_a43d,
    0xdac5_ae39,
    0x8221_bd2a,
    0xf591_9691,
    0x9d1a_23c4,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0xb000_0000,
    0x0800_0000,
    0x7c00_0000,
    0xd600_0000,
    0x9100_0000,
    0xcb80_0000,
    0xf040_0000,
    0x3ea0_0000,
    0xbab0_0000,
    0x0338_0000,
    0xd064_0000,
    0x5dd2_0000,
    0x2c6b_0000,
    0x6bc9_8000,
    0x96fe_4000,
    0xdb86_e000,
    0x6842_3000,
    0x9aa2_4800,
    0xa8b0_7c00,
    0x303a_9200,
    0x20e4_2d00,
    0x2113_b180,
    0xb80e_4fc0,
    0xd41f_2820,
    0xe197_0c10,
    0x8ccf_ba18,
    0x5c7c_212c,
    0x3847_8b82,
    0x62a7_2edf,
    0xbcb7_c395,
    0x2a3c_52f4,
    0x6fe4_d18a,
    0x0796_3fc0,
    0x55c9_8035,
    0x8bfe_400d,
    0xae06_e02f,
    0xc502_3023,
    0xb182_4812,
    0x0f40_7c0c,
    0x1022_9212,
    0x2b70_2d13,
    0x8ad9_b18b,
    0x0ef1_4ffc,
    0xdf9c_a81e,
    0x31d6_4c2b,
    0x626a_da19,
    0x5ecf_513e,
    0x4f78_a3b1,
    0x18c0_22c5,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x1000_0000,
    0xb800_0000,
    0xfc00_0000,
    0x6200_0000,
    0xc100_0000,
    0x5680_0000,
    0x4640_0000,
    0x0320_0000,
    0x9a10_0000,
    0xb938_0000,
    0x90e4_0000,
    0xf8f2_0000,
    0x78cf_0000,
    0xa2ac_8000,
    0x6e1b_c000,
    0x6cf6_e000,
    0xfece_9000,
    0x0da8_4800,
    0x339e_1400,
    0xf932_0200,
    0x732f_6100,
    0x71dd_3c80,
    0x8417_e7c0,
    0x5a38_2820,
    0xe760_4410,
    0xf832_2a38,
    0x85ab_2504,
    0xc79d_16ae,
    0x2f33_c2ff,
    0x8429_beb8,
    0xc058_46e0,
    0xcbd5_748d,
    0xead9_f3c5,
    0xaf92_2a36,
    0xc8fb_250d,
    0x7305_16a0,
    0x8f87_c2ef,
    0x1cc3_bebd,
    0x8f63_46d0,
    0x1c33_f4bd,
    0xeba9_33c8,
    0xcc9a_4a16,
    0xfcb1_7507,
    0x0aef_3e9d,
    0x2638_86db,
    0xc565_1485,
    0xd937_a3f3,
    0xc32a_0204,
    0x39db_6108,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x1000_0000,
    0x0800_0000,
    0x0400_0000,
    0xaa00_0000,
    0x4d00_0000,
    0x8880_0000,
    0xad40_0000,
    0x2ba0_0000,
    0x4d70_0000,
    0x8cb8_0000,
    0x3964_0000,
    0xa612_0000,
    0x3baf_0000,
    0xcc4c_8000,
    0x341e_4000,
    0x4391_2000,
    0xae68_d000,
    0xb2a9_a800,
    0x4eca_a400,
    0x2459_5a00,
    0xf8b7_c500,
    0x425c_d780,
    0xbbb4_c3c0,
    0xddde_0820,
    0xcb77_3410,
    0xdfbf_5238,
    0xaee4_f104,
    0xd2d1_8582,
    0x93cf_32c1,
    0xe4db_0d8a,
    0xb1f2_46c3,
    0xd3ff_7fba,
    0xb3c5_67ff,
    0xdde1_d210,
    0xf555_b106,
    0x1f0c_25b3,
    0x50b9_a2d8,
    0x3f63_8583,
    0xb510_32e7,
    0x4c2f_8da9,
    0xa888_06f2,
    0x947c_5f81,
    0x6f02_b7c8,
    0x8184_fa1c,
    0x6fc1_5506,
    0xdbe4_5f82,
    0xe656_b7ce,
    0x688e_fa3a,
    0x347a_553c,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0xb000_0000,
    0x3800_0000,
    0xf400_0000,
    0x1200_0000,
    0x7900_0000,
    0x0c80_0000,
    0x5940_0000,
    0xb460_0000,
    0x1950_0000,
    0xf498_0000,
    0x62a4_0000,
    0x1df2_0000,
    0xc26d_0000,
    0x7549_8000,
    0x8d7f_c000,
    0x9a34_a000,
    0xb64a_1000,
    0xc4fe_8800,
    0xb1f5_8400,
    0x746b_3a00,
    0x364d_db00,
    0x84f9_b680,
    0x11f3_a2c0,
    0xc469_a820,
    0x0e49_5410,
    0x70fa_9228,
    0x03f0_8f2c,
    0xbd69_248e,
    0x02ca_2dfd,
    0x29bb_0ca4,
    0xb791_b9ce,
    0xa43c_be8b,
    0xf654_e6ea,
    0x4b1f_b22b,
    0xaa61_5f07,
    0x6651_0c9f,
    0x8318_b9d7,
    0xc667_3eae,
    0x3056_26d5,
    0xd01a_923f,
    0x47e0_8f11,
    0x7791_2493,
    0x443e_2df4,
    0xe651_0c8c,
    0xc318_b9f1,
    0x6667_3eb5,
    0x8056_26f2,
    0xe81a_9235,
    0xb3e0_8f2b,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0xd000_0000,
    0x5800_0000,
    0xd400_0000,
    0x1600_0000,
    0xcf00_0000,
    0x4880_0000,
    0x34c0_0000,
    0xd4e0_0000,
    0x4390_0000,
    0x4228_0000,
    0x55a4_0000,
    0x1a32_0000,
    0xda1f_0000,
    0xb6ba_8000,
    0xfb0c_c000,
    0x0557_a000,
    0x87cb_3000,
    0xfdb1_3800,
    0x365a_a400,
    0xee9e_7600,
    0x687e_4f00,
    0x4aed_5080,
    0x8b46_ab40,
    0xeca6_1820,
    0x0db6_5410,
    0x1e58_6e38,
    0x5298_1b34,
    0x227d_3e96,
    0x1fea_b075,
    0xcec1_26a5,
    0x49e7_e463,
    0x6a11_c88a,
    0xf56c_3f69,
    0xb301_d63b,
    0xa281_7f01,
    0x51c6_68bb,
    0x1967_0f67,
    0x6ad0_ee27,
    0xe78b_db2d,
    0x6790_1eb7,
    0x7c2d_4064,
    0x26a7_be80,
    0x18b6_704c,
    0xbbde_8681,
    0x27d8_d469,
    0x1dda_f09c,
    0x20dd_9b5b,
    0x395f_2006,
    0x0618_f039,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0xb000_0000,
    0xd800_0000,
    0x5c00_0000,
    0x2600_0000,
    0x0900_0000,
    0x9480_0000,
    0x45c0_0000,
    0xb920_0000,
    0x8e10_0000,
    0xc798_0000,
    0x4364_0000,
    0xd572_0000,
    0x6eeb_0000,
    0xdb89_8000,
    0x6ff8_c000,
    0x1197_e000,
    0xf5dd_b000,
    0x0c04_0800,
    0x0e07_0400,
    0xed04_3e00,
    0x5e83_d100,
    0xb2c7_6c80,
    0x78a2_1ec0,
    0x7950_6820,
    0x327d_7410,
    0xe0d4_5618,
    0xd93e_a52c,
    0x5333_3ab6,
    0xc38c_bbd7,
    0x13fb_52a9,
    0xe795_cfd2,
    0x94dd_049d,
    0x1c80_6aed,
    0x31c7_be20,
    0x7b24_1108,
    0x4d13_0c96,
    0xa418_6ee9,
    0xc720_000f,
    0x9b10_000f,
    0x1518_002c,
    0xbfa4_0007,
    0x20d2_0008,
    0xf93b_0008,
    0x8331_8020,
    0xab8c_c029,
    0x97fd_e02c,
    0x9d92_b016,
    0xbbdf_8805,
    0x8104_c400,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x5000_0000,
    0x7800_0000,
    0xb400_0000,
    0x0600_0000,
    0x2900_0000,
    0x9880_0000,
    0x15c0_0000,
    0xe2e0_0000,
    0xd850_0000,
    0xa728_0000,
    0xf854_0000,
    0x572e_0000,
    0xb057_0000,
    0xcb2c_8000,
    0x7a54_c000,
    0x5029_2000,
    0xcdd4_f000,
    0xf468_6800,
    0xa270_3400,
    0xdb18_c600,
    0x3fef_2300,
    0x5c32_0480,
    0x37b8_1a40,
    0x4318_c620,
    0x1bef_2330,
    0x4232_0498,
    0xfab8_1a54,
    0xa598_c63e,
    0x932f_231d,
    0x3e52_0499,
    0x1e28_1a5e,
    0x78d0_c618,
    0xa6eb_2318,
    0x2cb4_04a1,
    0x8e7b_1a68,
    0x43fa_4631,
    0x94bc_e326,
    0xe09f_a4b4,
    0x89ac_2a44,
    0x2c97_8e03,
    0x814c_e738,
    0x9fc6_2aa0,
    0xd9e7_cd77,
    0x5fd5_24be,
    0x2b6b_ea50,
    0x5bf4_2e36,
    0xca5f_d708,
    0x02cd_e291,
    0xfd84_c979,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0xd000_0000,
    0x4800_0000,
    0x9400_0000,
    0x9e00_0000,
    0x7d00_0000,
    0x8180_0000,
    0x8c40_0000,
    0x87e0_0000,
    0xffb0_0000,
    0x18c8_0000,
    0xe7b4_0000,
    0x04ce_0000,
    0x8db7_0000,
    0x37c8_8000,
    0x3935_4000,
    0xae0c_2000,
    0xac91_b000,
    0xab5f_c800,
    0xca6d_bc00,
    0xd867_aa00,
    0xaef3_8300,
    0xaea9_5780,
    0x0c44_c540,
    0x47e7_aa20,
    0x9fb3_8330,
    0xc8c9_5798,
    0xafb4_c574,
    0x90cf_aa32,
    0x13b7_8315,
    0x4acf_57bf,
    0xb8b7_c56b,
    0x2249_2a12,
    0x2b75_c336,
    0x54eb_f79e,
    0xd2a3_3554,
    0x3fd2_c214,
    0xaa3d_cf0f,
    0x231d_959f,
    0x3b8a_0a77,
    0x7ed4_bf99,
    0x31bf_c941,
    0x645f_4814,
    0x04ec_fc2c,
    0x5aa5_8a0b,
    0xcbd5_3337,
    0xe43e_1f88,
    0x161c_3966,
    0x2e0c_202d,
    0x6c91_b00a,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x7000_0000,
    0xf800_0000,
    0xdc00_0000,
    0x0e00_0000,
    0x9100_0000,
    0xad80_0000,
    0xe840_0000,
    0x49a0_0000,
    0xadf0_0000,
    0xb888_0000,
    0xc5f4_0000,
    0x8c8e_0000,
    0x3ff1_0000,
    0x478d_8000,
    0x2976_c000,
    0x414b_6000,
    0xba16_b000,
    0x71df_e800,
    0xa30b_dc00,
    0x00b4_aa00,
    0xb6ab_9100,
    0x6342_c580,
    0x3f20_d540,
    0x7b34_aa20,
    0xa3eb_9130,
    0xd162_c5a8,
    0x4790_d55c,
    0xd19c_aa1e,
    0x6eaf_9107,
    0x0f44_c5ab,
    0x6925_d578,
    0x4637_2a35,
    0xf86c_513d,
    0x7424_25b9,
    0xadb0_a553,
    0x0528_221b,
    0x3202_fd0c,
    0x8f07_879a,
    0x1481_985c,
    0x11c7_458a,
    0x8be2_1546,
    0xa751_ca2a,
    0x27fc_2102,
    0xa9b8_ad9e,
    0x4519_c942,
    0xbf6d_603c,
    0x24a3_b004,
    0xbe74_683b,
    0x99c8_1c1e,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0xf000_0000,
    0x1800_0000,
    0x6400_0000,
    0x0200_0000,
    0xb500_0000,
    0x0680_0000,
    0x3cc0_0000,
    0x51a0_0000,
    0x8bb0_0000,
    0xe8a8_0000,
    0x2fb4_0000,
    0x4aaa_0000,
    0x8ab3_0000,
    0xa42d_8000,
    0xca73_c000,
    0x938e_a000,
    0xf6c3_d000,
    0xc8a3_0800,
    0xe337_e400,
    0xef68_ee00,
    0xb396_6900,
    0x2859_3380,
    0xbefe_ec40,
    0xdec8_ee20,
    0x8826_6910,
    0x38f1_33b8,
    0x054a_ec7c,
    0x8e62_ee26,
    0xd395_6909,
    0x985c_b3b8,
    0x46f9_2c51,
    0x4acc_4e27,
    0x9226_b906,
    0xe9f7_bbac,
    0x01ca_c873,
    0x07a6_a01d,
    0x84b7_d00d,
    0x2f29_083e,
    0xfff4_e411,
    0xeecd_6e14,
    0x3021_a92f,
    0x4cf5_93a2,
    0xef4a_3c50,
    0x4764_6600,
    0xb315_4d1e,
    0x1398_fda1,
    0xa4db_956d,
    0xfb39_f58d,
    0x17eb_7167,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x5000_0000,
    0x8800_0000,
    0xd400_0000,
    0x8200_0000,
    0x0700_0000,
    0x1080_0000,
    0x91c0_0000,
    0xaa60_0000,
    0x5210_0000,
    0x4878_0000,
    0x8e14_0000,
    0xde7e_0000,
    0xab11_0000,
    0x99fc_8000,
    0xa255_4000,
    0x765a_2000,
    0xd821_5000,
    0x6b32_1800,
    0x0ecd_d400,
    0xaa9c_9600,
    0xd1c7_8700,
    0xca63_8680,
    0xa214_04c0,
    0x907c_9620,
    0xd217_8730,
    0x887b_86a8,
    0x2e10_04d4,
    0x8e7a_9602,
    0x2312_8705,
    0x4df9_0688,
    0x2054_44d5,
    0x715c_3606,
    0xc8a6_9721,
    0xfaf1_3ea2,
    0xa4a8_c0c1,
    0xf88a_b814,
    0x99b8_c402,
    0x4470_2e15,
    0x7c6a_432b,
    0x3b69_2892,
    0x4bee_07da,
    0x2a2d_1e80,
    0x584c_90f9,
    0x565a_2022,
    0x4821_5008,
    0x4332_1820,
    0x8acd_d41d,
    0xa09c_961e,
    0x02c7_8714,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x7000_0000,
    0xd800_0000,
    0xbc00_0000,
    0xc200_0000,
    0xc900_0000,
    0x5d80_0000,
    0x5040_0000,
    0x07e0_0000,
    0x5eb0_0000,
    0xf768_0000,
    0x0ab4_0000,
    0xf16e_0000,
    0xadb7_0000,
    0x0fed_8000,
    0x0d71_c000,
    0x7bc8_6000,
    0x0f67_d000,
    0x4176_2800,
    0xa1c9_3c00,
    0x1a66_aa00,
    0xaef4_0300,
    0xe088_df80,
    0xfc04_f840,
    0x6206_aa20,
    0xd904_0330,
    0xf580_df98,
    0x3440_f85c,
    0x79e0_aa16,
    0x55b7_031f,
    0x63eb_5fa8,
    0x0772_386e,
    0xa6cb_4a01,
    0xf4e6_130b,
    0xa630_97a9,
    0xf0a9_1479,
    0x8015_a83c,
    0x53bf_fc09,
    0xe32b_4a15,
    0xa356_1312,
    0x6cd8_979f,
    0xda5d_147a,
    0xae9b_a833,
    0x1cb8_fc3d,
    0xd9ae_ca21,
    0x6d93_d321,
    0xbbfe_f793,
    0x28cd_c47b,
    0xe7e0_0006,
    0xeeb0_0014,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x5000_0000,
    0xb800_0000,
    0x2400_0000,
    0x0600_0000,
    0xa500_0000,
    0x1e80_0000,
    0x04c0_0000,
    0xdfa0_0000,
    0xec70_0000,
    0x5ee8_0000,
    0xc074_0000,
    0xd4ea_0000,
    0x9f77_0000,
    0x1d68_8000,
    0x9e32_c000,
    0x5989_a000,
    0xb1a2_f000,
    0x9574_8800,
    0x026e_0400,
    0x37b2_ae00,
    0x08c9_f900,
    0x4d44_4d80,
    0x9ee4_4e40,
    0xc892_ae20,
    0x2179_f910,
    0xb48c_4d98,
    0x4320_4e54,
    0x3bb0_ae0e,
    0xb2ca_f919,
    0xfa46_cd99,
    0xcb61_8e7d,
    0xebd3_8e09,
    0xc699_c918,
    0x2099_65ae,
    0x9598_ba46,
    0x531c_881e,
    0x23da_0428,
    0x4278_ae1b,
    0x2f0e_f921,
    0x6964_cdb9,
    0x08d2_8e5f,
    0x1d19_0e35,
    0x6ad8_0909,
    0xf6fa_45aa,
    0x44cb_8a42,
    0x9743_2017,
    0x79e3_302b,
    0x2517_a83f,
    0x263d_340d,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0xd000_0000,
    0x7800_0000,
    0xac00_0000,
    0xfa00_0000,
    0xbf00_0000,
    0x2180_0000,
    0x4440_0000,
    0xc1e0_0000,
    0x8b30_0000,
    0xa428_0000,
    0xd134_0000,
    0x0b2e_0000,
    0xa8b5_0000,
    0x3368_8000,
    0xeb56_c000,
    0xab5d_e000,
    0x94f9_1000,
    0x812c_1800,
    0x7fb6_1c00,
    0xe6eb_3a00,
    0x2910_9300,
    0x57bd_a380,
    0x2d4e_5240,
    0xbac3_3a20,
    0x9424_9330,
    0x8693_a388,
    0xeafb_5274,
    0xd02b_ba3e,
    0x9732_531b,
    0x162e_43b6,
    0x4a32_425b,
    0xd4af_a236,
    0x7df0_4f0a,
    0x3a0b_7986,
    0x40a7_d179,
    0x1452_819f,
    0x6adc_dd7e,
    0x20bb_a3a4,
    0xe8cf_5263,
    0x2085_ba1b,
    0x14c7_5330,
    0xbd26_c3b0,
    0xc214_825d,
    0xe03a_420d,
    0x0c0d_5f34,
    0x35a1_619f,
    0x02d0_cd6d,
    0x0b1f_3b96,
    0x8b1f_8e72,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xd000_0000,
    0xc800_0000,
    0xd400_0000,
    0xd600_0000,
    0x2100_0000,
    0x9580_0000,
    0x3e40_0000,
    0xb860_0000,
    0x8b90_0000,
    0x1c58_0000,
    0x6994_0000,
    0x5b5a_0000,
    0xe515_0000,
    0x3c9c_8000,
    0xa933_4000,
    0x2c6a_2000,
    0x5c7d_f000,
    0xd367_2800,
    0x7d17_5c00,
    0x6099_da00,
    0x8b33_1f00,
    0x0b6e_4680,
    0x20fc_9dc0,
    0xaca1_da20,
    0x2d37_1f10,
    0x726c_4688,
    0x897d_9df4,
    0x40e7_5a12,
    0xaa51_5f25,
    0x997a_e6bd,
    0xe8e3_2dfc,
    0x8e52_5237,
    0x577f_f32a,
    0xd5e6_1493,
    0x19d6_6ede,
    0x9e3b_4eb0,
    0xd902_31f0,
    0x3985_2825,
    0x0446_5c37,
    0x8367_5a17,
    0xf511_5f3e,
    0x949a_e6b4,
    0x8d33_2df1,
    0xe26a_520c,
    0x617b_f338,
    0x44e4_1486,
    0xb457_6ed5,
    0x6c7d_ce82,
    0xab64_71e0,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x1000_0000,
    0xb800_0000,
    0x9400_0000,
    0xaa00_0000,
    0x1100_0000,
    0x6780_0000,
    0xa0c0_0000,
    0x5320_0000,
    0xb750_0000,
    0xa278_0000,
    0x1154_0000,
    0x5d7e_0000,
    0xd5d1_0000,
    0x0f3e_8000,
    0x53b4_c000,
    0xce8a_2000,
    0xd839_9000,
    0x7b36_a800,
    0x02c8_ac00,
    0xf558_ae00,
    0x7403_b500,
    0xda02_5480,
    0x1900_c6c0,
    0x5b80_ae20,
    0x26c7_b530,
    0x7c24_54a8,
    0x6bd5_c6c4,
    0x7438_2e0e,
    0x8536_7515,
    0x19ce_f482,
    0x93d9_96c0,
    0x0b42_2617,
    0xbde7_893d,
    0x5774_d296,
    0x5faa_1fed,
    0xf268_f4bf,
    0x90cc_96f9,
    0xb05a_a621,
    0x1986_4928,
    0x7bc6_72b4,
    0x95a2_4fd9,
    0xd814_fc94,
    0x7d98_6aff,
    0xcb20_000e,
    0xf350_0008,
    0x1078_0012,
    0x8454_003a,
    0x28fe_0013,
    0xf011_001a,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x7000_0000,
    0xc800_0000,
    0xe400_0000,
    0x7600_0000,
    0x2900_0000,
    0x0780_0000,
    0xbbc0_0000,
    0x5de0_0000,
    0x6d50_0000,
    0xdc68_0000,
    0x2454_0000,
    0xebea_0000,
    0xb793_0000,
    0x2209_8000,
    0x64c5_4000,
    0x3366_a000,
    0x3112_f000,
    0x4a4d_e800,
    0xdce1_cc00,
    0xbed1_b600,
    0x39ae_6300,
    0xc4b0_7c80,
    0x3f38_7040,
    0x1d3b_b620,
    0x2a3d_6310,
    0x70b9_fcb8,
    0x02fd_305c,
    0xe1dd_1612,
    0x44ef_9329,
    0x1114_14a5,
    0x9a4c_fc56,
    0x84e4_a013,
    0xe2d5_f007,
    0x63ae_6832,
    0x7fb7_8c0d,
    0x67be_9604,
    0x8879_d31e,
    0xcb9b_34b0,
    0xfbcb_4c7c,
    0xee27_e81e,
    0x74b2_cc2e,
    0x5738_3619,
    0x693b_2326,
    0xe43e_dc9f,
    0x75be_805e,
    0x977c_5e24,
    0x051f_af35,
    0x3789_ca92,
    0xc002_1353,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x1000_0000,
    0x6800_0000,
    0x6400_0000,
    0xfe00_0000,
    0x5d00_0000,
    0x8c80_0000,
    0x9940_0000,
    0x6d60_0000,
    0x8af0_0000,
    0xc648_0000,
    0xe3f4_0000,
    0x7cce_0000,
    0x33b7_0000,
    0x1b2e_8000,
    0x7104_4000,
    0xa685_a000,
    0x2247_b000,
    0xa0e1_4800,
    0x6d30_d400,
    0xf56d_0200,
    0x2be4_ff00,
    0x78b4_7580,
    0x6eaa_3d40,
    0xfac3_0220,
    0x1fa3_ff30,
    0x2152_f598,
    0x111a_7d44,
    0xdbe8_a23a,
    0xbda3_4f29,
    0x2e55_3da7,
    0x2a9a_e953,
    0x152e_0019,
    0x9407_000f,
    0x4606_803c,
    0x3100_4031,
    0x0683_a008,
    0x5244_b007,
    0xd8e1_c83b,
    0x6133_9439,
    0x6f6e_2214,
    0x88e3_0f02,
    0xa936_9dad,
    0x7b6e_5966,
    0x0ee7_c83f,
    0xf830_940f,
    0x6dee_a213,
    0x34a0_4f0a,
    0x44d5_bdaa,
    0xf2d9_a945,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x3000_0000,
    0xe800_0000,
    0xdc00_0000,
    0x9e00_0000,
    0xf900_0000,
    0x1580_0000,
    0x4f40_0000,
    0x42a0_0000,
    0x3e30_0000,
    0x3e38_0000,
    0x0b34_0000,
    0x2dba_0000,
    0x2971_0000,
    0x089b_8000,
    0xd706_4000,
    0x4485_6000,
    0x26c6_b000,
    0xa3e0_a800,
    0x6d93_1c00,
    0xc98b_5200,
    0xe44a_4900,
    0x9d2a_4380,
    0x2f78_48c0,
    0x5091_5220,
    0x960b_4910,
    0x8009_c3a8,
    0x750a_08cc,
    0x868e_321a,
    0x34cc_f927,
    0xc9ea_eb8f,
    0x039b_54f2,
    0x0d82_001f,
    0x9b45_0034,
    0x90a1_801f,
    0x8137_403d,
    0xe6be_e030,
    0x13f0_f026,
    0x475d_c83c,
    0xb961_ac3b,
    0x5251_fa08,
    0xefe8_5524,
    0x1e9a_918a,
    0x2204_41cc,
    0xb706_7185,
    0x9481_b1fc,
    0x5ec2_39a0,
    0xa7e3_5de6,
    0xc797_23bf,
    0x728a_f8ce,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0xf000_0000,
    0x8800_0000,
    0xc400_0000,
    0x9e00_0000,
    0x1f00_0000,
    0x6080_0000,
    0x3a40_0000,
    0xb3a0_0000,
    0xa370_0000,
    0x1998_0000,
    0x2074_0000,
    0xfb1e_0000,
    0x4737_0000,
    0x1539_8000,
    0x7383_4000,
    0xa0c7_a000,
    0x98e3_b000,
    0x1751_5800,
    0xac2b_b400,
    0xea0b_0a00,
    0x4ab8_6900,
    0x7945_3180,
    0x3124_d5c0,
    0x3435_0a20,
    0x7fbf_6930,
    0xd0c4_b198,
    0xd0e3_95fc,
    0xb354_aa02,
    0xc22f_d901,
    0x7d0a_69bf,
    0xee38_61fb,
    0xdd07_801a,
    0x9d84_400f,
    0xf7c6_2013,
    0x5c64_f013,
    0x4310_f83c,
    0x888b_0437,
    0xedfd_d235,
    0xf767_9d3e,
    0xf590_1b9b,
    0x09cc_4cda,
    0x50de_c39a,
    0xf957_b8ef,
    0xfb2d_e9be,
    0x2e8c_21f3,
    0x1ef9_a036,
    0x5de4_b018,
    0x36d0_d803,
    0x89ec_f431,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0xf000_0000,
    0xc800_0000,
    0x0c00_0000,
    0xf600_0000,
    0x9100_0000,
    0xbc80_0000,
    0x0240_0000,
    0x38e0_0000,
    0x4a70_0000,
    0x7b88_0000,
    0xfd74_0000,
    0x2e0a_0000,
    0x27b1_0000,
    0x1ead_8000,
    0xfa27_4000,
    0x0ed5_e000,
    0x341c_f000,
    0x760f_6800,
    0xf3b2_1400,
    0x7cab_fa00,
    0xa925_1300,
    0x1155_0980,
    0xe1dc_df40,
    0x9729_fa20,
    0xaee0_1310,
    0xcb72_89a8,
    0x5f0a_9f7c,
    0xcb31_9a12,
    0x24eb_a313,
    0x06c0_0195,
    0xbea0_7b58,
    0x2897_083d,
    0xa6f9_a413,
    0x6379_721b,
    0x61bf_f70a,
    0xc51b_9b83,
    0xda8a_d87c,
    0x69f2_8998,
    0x704a_9f6f,
    0xd151_9a3e,
    0x01db_a32d,
    0xc728_019c,
    0x96e4_7b69,
    0x0f75_082b,
    0xa50c_a40a,
    0xac36_f22d,
    0x096d_b736,
    0xb801_fb8d,
    0x8404_686b,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x3000_0000,
    0x7800_0000,
    0x4c00_0000,
    0x5200_0000,
    0xe700_0000,
    0x2880_0000,
    0x6240_0000,
    0x0060_0000,
    0x0130_0000,
    0x4b48_0000,
    0xec34_0000,
    0x38ce_0000,
    0x2cf1_0000,
    0xc1ef_8000,
    0x2f22_c000,
    0x42d5_e000,
    0xf2bc_5000,
    0x1258_d800,
    0x852a_1400,
    0x7001_4a00,
    0x1801_5700,
    0xdc03_6380,
    0x1a03_3d40,
    0xd307_4a20,
    0x3684_5730,
    0xd742_e3a8,
    0xcfe0_fd4c,
    0x4bf5_2a3e,
    0x296e_c723,
    0xed61_dbbc,
    0x72b7_b975,
    0x8b8b_3834,
    0x1513_443b,
    0x3b18_123c,
    0xafc8_8335,
    0x1c70_4986,
    0x7fa8_fa70,
    0x3547_11ba,
    0x90e0_2e42,
    0x8f73_bba0,
    0x292d_2954,
    0x7200_0008,
    0x1700_0018,
    0xf080_0004,
    0x1e40_0037,
    0x2a60_0002,
    0xaa30_0003,
    0x31c8_001d,
    0x6974_000d,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x1000_0000,
    0xd800_0000,
    0xac00_0000,
    0xe200_0000,
    0xb300_0000,
    0x0380_0000,
    0xd540_0000,
    0x7660_0000,
    0xaab0_0000,
    0x0948_0000,
    0x93b4_0000,
    0xfdca_0000,
    0xa377_0000,
    0x6bea_8000,
    0x5921_c000,
    0xe3d7_e000,
    0x327a_d000,
    0x34bc_7800,
    0x6f9f_cc00,
    0x6f4b_5200,
    0xe6b1_3f00,
    0xbb49_2780,
    0x98b7_c540,
    0x4249_5220,
    0x4c32_3f10,
    0x0289_a798,
    0x1211_0544,
    0x8cdc_3216,
    0xd42d_2f3b,
    0xb680_3fa0,
    0xb3c7_1968,
    0x3da3_9816,
    0x4b11_1c0e,
    0x685d_2a3d,
    0x3ce9_f302,
    0x8ca0_f5b4,
    0xab93_3a7a,
    0x069d_95ba,
    0x23c8_2a7e,
    0x6a76_0da0,
    0x176d_3653,
    0x7de1_2794,
    0x2bf3_c571,
    0x412b_5223,
    0xa001_3f3a,
    0x3001_278a,
    0xa803_c56b,
    0x6403_520a,
    0x9605_3f23,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xb000_0000,
    0xe800_0000,
    0x9c00_0000,
    0x6a00_0000,
    0xbf00_0000,
    0xdd80_0000,
    0xac40_0000,
    0x4220_0000,
    0xd010_0000,
    0xe838_0000,
    0x5914_0000,
    0x80ba_0000,
    0x07d5_0000,
    0xeb5f_8000,
    0x4da2_4000,
    0x6753_6000,
    0xf99d_1000,
    0x3440_9800,
    0x5620_fc00,
    0xb615_7a00,
    0x653a_2d00,
    0x4f95_5a80,
    0x077d_5cc0,
    0x3cb7_7a20,
    0x1beb_2d10,
    0x0448_da88,
    0x381e_1cec,
    0xb201_9a1a,
    0x8b01_7d37,
    0x0b84_a292,
    0xc941_b0c3,
    0xc8a7_182d,
    0x3dd6_bc1c,
    0x6c5c_1a02,
    0x7422_3d37,
    0x6512_42b7,
    0x1abb_e0da,
    0x70d3_600a,
    0x1add_100a,
    0x63e0_983f,
    0x0670_fc02,
    0x9e0d_7a13,
    0xcf3e_2d2c,
    0x9097_5a97,
    0x4afc_5cff,
    0xc8f2_fa03,
    0x2dcc_6d1d,
    0x225c_3abc,
    0x0525_4cdf,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x5000_0000,
    0x1800_0000,
    0x7400_0000,
    0x2600_0000,
    0x4300_0000,
    0xdc80_0000,
    0x1c40_0000,
    0x76a0_0000,
    0xad10_0000,
    0x8248_0000,
    0x6c14_0000,
    0xe3ce_0000,
    0x7bd3_0000,
    0x23ac_8000,
    0xe723_c000,
    0xd2d7_2000,
    0x9e2e_f000,
    0xeae7_3800,
    0x1bb1_1400,
    0xcf5e_5a00,
    0xbe5a_e100,
    0x97dd_5280,
    0xec1f_e340,
    0x7e78_5a20,
    0x878d_e130,
    0xe977_d2b8,
    0x50bb_2354,
    0x026d_fa26,
    0x5c43_d12d,
    0x56a3_4ab1,
    0x1d13_0744,
    0xca4d_b811,
    0x0015_d42a,
    0xb1cb_fa2c,
    0x1ed4_d12f,
    0xbc29_ca91,
    0x27e7_c741,
    0xb830_180c,
    0x459f_e415,
    0xc5b9_6227,
    0xf5eb_f531,
    0x4083_0897,
    0x2645_024f,
    0xcfa5_08bb,
    0x2892_0244,
    0x4b8f_8890,
    0xcb76_c275,
    0x9dba_2894,
    0xa1e8_f256,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0xb000_0000,
    0x5800_0000,
    0xdc00_0000,
    0xaa00_0000,
    0xa900_0000,
    0x6b80_0000,
    0xcbc0_0000,
    0x6460_0000,
    0x9290_0000,
    0x7bf8_0000,
    0xe594_0000,
    0xf77e_0000,
    0x8ad1_0000,
    0xd85b_8000,
    0xf163_c000,
    0x8315_6000,
    0x513a_9000,
    0xde72_2800,
    0x802a_cc00,
    0x4a4c_f600,
    0xc7da_af00,
    0x74a2_4280,
    0x2873_c0c0,
    0x432a_f620,
    0x28cf_af30,
    0xd79f_c2a8,
    0x8305_00ec,
    0x0282_1636,
    0x0043_ff07,
    0x1fa5_0a82,
    0xaef3_9cc6,
    0x356c_282c,
    0x346b_cc35,
    0xbbef_761b,
    0x162d_6f22,
    0x9949_2292,
    0x4d58_50fc,
    0xe0e3_5e2e,
    0xa9d6_a31c,
    0x6ade_549a,
    0xa921_3fdb,
    0x40b4_7cb2,
    0x55cf_f3d5,
    0x421e_8abd,
    0xdfc0_5cd3,
    0x3a61_480b,
    0xb595_5c1e,
    0x7f7b_5e11,
    0x1ed2_a303,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x9000_0000,
    0x2800_0000,
    0xb400_0000,
    0xde00_0000,
    0x0500_0000,
    0xd180_0000,
    0x5dc0_0000,
    0x25e0_0000,
    0x6bd0_0000,
    0x8c48_0000,
    0xaa54_0000,
    0xb98a_0000,
    0xdbb3_0000,
    0x9c5e_8000,
    0x7afa_4000,
    0x538f_2000,
    0x40b6_b000,
    0xa8dc_0800,
    0x66be_bc00,
    0x03ac_a600,
    0xba84_b300,
    0x9143_4880,
    0x45a7_d940,
    0xc1f2_2620,
    0x857e_f310,
    0xf34c_68b8,
    0xc8d1_6964,
    0x64ce_2e2a,
    0x3c10_4f3d,
    0xa2a8_ce8f,
    0xdd01_da65,
    0x9d87_669e,
    0xffc4_966a,
    0xdae4_68a6,
    0x4955_696f,
    0xb10c_2e05,
    0xddf7_4f24,
    0xaf7c_4ea2,
    0xc848_9a64,
    0x8c56_c6ad,
    0xc088_665f,
    0xf037_40a8,
    0x329d_655e,
    0x3f9c_8001,
    0x6a1d_4039,
    0xb1db_a015,
    0x9d3f_f030,
    0x656d_a82d,
    0xdbe2_4c31,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0xf000_0000,
    0xe800_0000,
    0xac00_0000,
    0x9e00_0000,
    0x1300_0000,
    0x0b80_0000,
    0x6840_0000,
    0x2fa0_0000,
    0x21d0_0000,
    0x99d8_0000,
    0x3a54_0000,
    0x899e_0000,
    0x01f1_0000,
    0x8249_8000,
    0x512e_4000,
    0x9298_e000,
    0x3674_b000,
    0xcc09_7800,
    0xd98d_6c00,
    0x62cc_7a00,
    0xe6e8_f100,
    0x5f7b_c480,
    0x0106_47c0,
    0xb685_fa20,
    0x38c6_b130,
    0x1063_24a8,
    0x1032_f7fc,
    0x28ac_821a,
    0x17db_dd1b,
    0x5157_5e8f,
    0x961e_06f8,
    0x43b1_4698,
    0x64e8_9ac1,
    0x5a7d_24a4,
    0xe583_f7c0,
    0x5345_0216,
    0x2825_9d33,
    0x2797_be9c,
    0x4d7e_b6db,
    0xbc06_3eb9,
    0xe604_f6df,
    0x0700_dea0,
    0x2181_46d7,
    0xa140_268e,
    0x0522_6ad9,
    0xcf14_bca6,
    0xc6be_2bd1,
    0x57e6_0017,
    0x7675_0015,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0xf000_0000,
    0x1800_0000,
    0x7c00_0000,
    0xea00_0000,
    0x2700_0000,
    0x3a80_0000,
    0x4c40_0000,
    0x9960_0000,
    0x4c70_0000,
    0x0478_0000,
    0xeef4_0000,
    0x743a_0000,
    0xfd97_0000,
    0xef4d_8000,
    0xdb6f_c000,
    0x31fa_6000,
    0xdc32_9000,
    0xa71c_5800,
    0x0d86_c400,
    0xdec5_fa00,
    0xd122_6f00,
    0xb312_0980,
    0x9d0b_94c0,
    0x8b08_7a20,
    0x060d_af10,
    0x7b88_6998,
    0xfd49_04fc,
    0x306c_2226,
    0x997f_6b0f,
    0x3b77_93a2,
    0xf6fc_6bf5,
    0x56b3_aba8,
    0x935b_3fdc,
    0x18e5_89a4,
    0x60b3_54f6,
    0x8e5f_9a31,
    0x8d60_ff1b,
    0x8276_519f,
    0xd579_50c6,
    0xe977_8028,
    0x3df8_c018,
    0x6e37_e01b,
    0x9c1d_503d,
    0x2d06_383d,
    0xad84_5411,
    0x0ec1_a23b,
    0x5920_ab1d,
    0x2715_f3ac,
    0x130a_fbc5,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x9000_0000,
    0x2800_0000,
    0xbc00_0000,
    0xae00_0000,
    0xef00_0000,
    0x5a80_0000,
    0x5840_0000,
    0xc320_0000,
    0xcf10_0000,
    0x3c08_0000,
    0xed94_0000,
    0x104a_0000,
    0x0cb1_0000,
    0x265e_8000,
    0x1138_4000,
    0xdb0f_6000,
    0xdb17_3000,
    0x6e09_1800,
    0x0c93_6400,
    0x35cf_9a00,
    0x2674_1d00,
    0x013d_d280,
    0xb30f_6540,
    0xc711_1a20,
    0x500c_5d10,
    0xcb92_b2a8,
    0xd348_5564,
    0xd030_022a,
    0x2d1b_393f,
    0x269f_2883,
    0xa359_485f,
    0x7eb9_50bc,
    0x14cd_1c69,
    0xe3f7_d293,
    0x1bfe_657c,
    0x2c6f_9a1b,
    0xf124_1d36,
    0x5e15_d2bd,
    0x018b_6540,
    0xc353_1a11,
    0x0d29_5d2d,
    0x5386_3297,
    0x21c1_154f,
    0x77e1_e211,
    0xbf74_4926,
    0x50b9_5083,
    0xbbcd_1c6b,
    0x1977_d2a5,
    0xd3be_657a,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x1000_0000,
    0x1800_0000,
    0x3c00_0000,
    0x6a00_0000,
    0xdd00_0000,
    0xdc80_0000,
    0xf6c0_0000,
    0xf9a0_0000,
    0x9e10_0000,
    0xfbd8_0000,
    0x2e94_0000,
    0xdf1e_0000,
    0x4637_0000,
    0xff8e_8000,
    0xb22f_c000,
    0xa23b_6000,
    0xb2e2_9000,
    0xe7f2_8800,
    0xd7ae_f400,
    0x7e7c_fe00,
    0x7a81_5900,
    0x89c2_1e80,
    0xbc20_cfc0,
    0xf252_7e20,
    0x5bbe_9930,
    0x74a1_7e98,
    0xfa96_5fc4,
    0x411e_f626,
    0xb537_6d3f,
    0xb80b_0082,
    0x376c_c6f3,
    0x90d9_8891,
    0x9512_32c2,
    0x505d_769c,
    0xb9d7_6be4,
    0x1cf9_6837,
    0xcf44_a40d,
    0x5fe3_960d,
    0x9376_fd0a,
    0x7569_08aa,
    0xd9da_f2e2,
    0x7790_96ac,
    0x259e_3be0,
    0x0ff6_8009,
    0x23ab_c03c,
    0x507d_601e,
    0xe181_9004,
    0xfa42_0831,
    0x7766_3414,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0xb000_0000,
    0x7800_0000,
    0xe400_0000,
    0xde00_0000,
    0x8b00_0000,
    0x4480_0000,
    0xdcc0_0000,
    0xeb20_0000,
    0xb070_0000,
    0xb0e8_0000,
    0x08f4_0000,
    0xa62a_0000,
    0x2ed3_0000,
    0x8ddf_8000,
    0xa078_c000,
    0xddcc_a000,
    0xc784_3000,
    0xa443_f800,
    0x5de5_9400,
    0xc653_de00,
    0x531f_6d00,
    0x1a5a_ed80,
    0xcc3c_5240,
    0x1c2c_5e20,
    0x3bd7_ad10,
    0xa25e_4db8,
    0x883c_626c,
    0x922d_a63e,
    0x78d5_3929,
    0x7ad8_138f,
    0x6ef8_cf4e,
    0x2c0c_6baf,
    0x0721_9b5e,
    0x5271_1595,
    0x51ed_c672,
    0xd175_803b,
    0x296b_c030,
    0x67b3_2002,
    0x5f4c_f010,
    0x8447_5837,
    0x4de5_a406,
    0xee52_2602,
    0x7f1d_f903,
    0x585c_b38d,
    0x7d38_ff66,
    0x0dad_9399,
    0x2893_0f50,
    0xd13f_4b91,
    0x0fad_6b79,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x5000_0000,
    0xa800_0000,
    0x2c00_0000,
    0x0a00_0000,
    0x0d00_0000,
    0x0d80_0000,
    0xf340_0000,
    0x4960_0000,
    0x5330_0000,
    0x2ae8_0000,
    0x6ab4_0000,
    0x67ae_0000,
    0x50d1_0000,
    0xea1c_8000,
    0x07fc_4000,
    0x1c09_e000,
    0x83c2_1000,
    0x8fa0_8800,
    0xcd12_fc00,
    0x46b9_5200,
    0xbc6a_5700,
    0x0b76_5b80,
    0xa908_4840,
    0x6a45_d220,
    0xaae6_1730,
    0x7b77_bba8,
    0x910e_5854,
    0x4e43_5a0a,
    0xdce1_eb3b,
    0xd474_69aa,
    0xbd8d_4f57,
    0xba86_6189,
    0x6bc2_f347,
    0xc3a2_5398,
    0x3712_f473,
    0xb3bb_602b,
    0x35ef_5009,
    0xde35_e80b,
    0xe76c_ac1c,
    0x39f0_3a1b,
    0x7eca_bb2f,
    0xabe7_818d,
    0xecf4_e35f,
    0x674c_dba2,
    0x76a1_0870,
    0xde96_b21f,
    0x96fd_4731,
    0x838c_538a,
    0x0983_f449,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0xb000_0000,
    0xe800_0000,
    0xcc00_0000,
    0xba00_0000,
    0x1d00_0000,
    0x6c80_0000,
    0x3740_0000,
    0x06e0_0000,
    0x9ad0_0000,
    0x3dd8_0000,
    0xcc54_0000,
    0x579a_0000,
    0x4633_0000,
    0x4a0f_8000,
    0x950c_4000,
    0xd08d_e000,
    0x454b_9000,
    0x47ea_0800,
    0x345d_7400,
    0xa394_f200,
    0xa83f_2300,
    0xe907_f480,
    0x0281_25c0,
    0x5443_7220,
    0xb167_6310,
    0x8e10_14b8,
    0xb1f9_b5ec,
    0xb1a6_fa1a,
    0xdc36_5723,
    0x4709_0696,
    0x418d_06eb,
    0x73cb_0681,
    0xddaa_06ee,
    0xb63e_86b7,
    0xc205_46dd,
    0x2904_e6b6,
    0xa286_96f1,
    0x0441_0e98,
    0xe967_72ff,
    0xaa12_748a,
    0xc7fe_65d3,
    0x16a1_1237,
    0xadb0_b323,
    0x1ccf_fcba,
    0x702b_51e8,
    0xeffa_0028,
    0x7aa3_0016,
    0x47b7_802f,
    0x59c8_400a,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0xd000_0000,
    0x1800_0000,
    0x2c00_0000,
    0x6200_0000,
    0x4b00_0000,
    0xbd80_0000,
    0x5cc0_0000,
    0xb420_0000,
    0x3190_0000,
    0xee88_0000,
    0x7e14_0000,
    0x414e_0000,
    0xebb7_0000,
    0x8618_8000,
    0xce1f_c000,
    0x3a1d_e000,
    0x141a_d000,
    0xed1c_b800,
    0x0399_bc00,
    0xcede_9e00,
    0x443d_7d00,
    0x8a8c_0280,
    0xe810_5140,
    0x244e_1e20,
    0xaf36_bd30,
    0x345f_e298,
    0xb77d_8174,
    0x816a_2626,
    0x3420_c13b,
    0xf194_9c80,
    0x8e8e_2c66,
    0xae14_9c89,
    0x594e_2c6c,
    0xc7b4_9c8d,
    0xe41e_2c5a,
    0x851c_9caa,
    0x879a_2c47,
    0x48da_9c9b,
    0x5939_2c6b,
    0x320c_1c93,
    0x2051_ec66,
    0x3a29_7cba,
    0xcbc4_fc79,
    0x03a0_2485,
    0xa253_906a,
    0x612c_02b2,
    0x0e40_5177,
    0xa366_1e37,
    0x6c72_bd2a,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xd000_0000,
    0x9800_0000,
    0xb400_0000,
    0xb200_0000,
    0xf900_0000,
    0x2d80_0000,
    0xa240_0000,
    0xd3e0_0000,
    0x3930_0000,
    0xaf98_0000,
    0x9eb4_0000,
    0xd0da_0000,
    0x6ad5_0000,
    0xd6ac_8000,
    0x1129_c000,
    0x9e6d_2000,
    0x220e_5000,
    0x087b_e800,
    0x7581_bc00,
    0x7646_3a00,
    0x91e4_8300,
    0x8831_6380,
    0xae19_b7c0,
    0x3af2_ba20,
    0x4839_4310,
    0x8766_4388,
    0xf6f2_e7f4,
    0xfe3d_d206,
    0xa465_3f3d,
    0xde77_59a4,
    0xeffd_34ca,
    0x2ac3_d98d,
    0x5220_f4d5,
    0x0f94_f9b0,
    0x47cb_a4d4,
    0x54db_91ae,
    0xf0d7_d8c6,
    0xf3aa_8ba2,
    0x72a8_0be3,
    0x5b2c_8037,
    0x2369_c03c,
    0xf58d_202e,
    0x7f3e_5013,
    0x8de3_e829,
    0xa635_bc0b,
    0x391c_3a36,
    0xa071_8309,
    0xa0fd_e3b5,
    0x2440_77e9,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x7000_0000,
    0x3800_0000,
    0x7400_0000,
    0x0200_0000,
    0x4d00_0000,
    0x9c80_0000,
    0xdfc0_0000,
    0x40e0_0000,
    0x3030_0000,
    0x0938_0000,
    0x82b4_0000,
    0x7dfe_0000,
    0x79d5_0000,
    0x7f8d_8000,
    0x3d4c_c000,
    0x692a_2000,
    0xeada_d000,
    0xa501_4800,
    0x6081_b400,
    0xb1c4_7600,
    0x0be7_1300,
    0xdbb7_6780,
    0x737f_72c0,
    0x8311_f620,
    0x9fef_d330,
    0x9cbb_4788,
    0x1bf4_a2dc,
    0x8bdb_3e2e,
    0xdf83_a72d,
    0x9846_9188,
    0x1ca0_a1cf,
    0x3692_b189,
    0x76af_71da,
    0x529e_79b8,
    0xc9a2_05f3,
    0x6e10_2f83,
    0xb36f_c6e6,
    0x5b7e_0029,
    0x5f15_0030,
    0x81ed_803c,
    0xefbc_c00a,
    0x8472_203c,
    0xf39e_d011,
    0x9327_4803,
    0xe6d0_b41f,
    0x260f_f61c,
    0x120a_d33d,
    0xf00e_c78d,
    0xed0c_62f9,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0xf000_0000,
    0x2800_0000,
    0x0c00_0000,
    0x0200_0000,
    0x3900_0000,
    0xa580_0000,
    0x1b40_0000,
    0x3ca0_0000,
    0xb250_0000,
    0xd578_0000,
    0x61d4_0000,
    0xe13e_0000,
    0xc7f5_0000,
    0x2aa9_8000,
    0x83ec_4000,
    0x4e4d_e000,
    0x859a_5000,
    0x91a5_2800,
    0xd1d4_fc00,
    0x293e_b200,
    0x1bf6_7900,
    0xf0ab_b080,
    0x9eee_dac0,
    0xe5cf_3220,
    0xa5de_3930,
    0x3180_5088,
    0xdd45_8afc,
    0xdba5_9a2a,
    0xf4d7_8533,
    0x76bc_8288,
    0xedb4_e3f2,
    0x4f89_6283,
    0x00fa_b3f5,
    0x9292_4aa7,
    0xf19b_4fee,
    0x87a5_78be,
    0xeed1_76d1,
    0x4bbb_2815,
    0xb631_fc1c,
    0x47cf_3214,
    0xacde_390f,
    0x9c00_5087,
    0x3a05_8af7,
    0xcd05_9a1d,
    0x7387_8518,
    0x0444_82ba,
    0xae20_e3d8,
    0x3797_62ba,
    0x6e1f_b3c5,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xf000_0000,
    0x8800_0000,
    0x0c00_0000,
    0x4600_0000,
    0x6300_0000,
    0x7a80_0000,
    0xf2c0_0000,
    0x68e0_0000,
    0x9cd0_0000,
    0x5798_0000,
    0x0554_0000,
    0x9fda_0000,
    0xbf75_0000,
    0x9bed_8000,
    0xfc39_4000,
    0xc521_e000,
    0x20b5_7000,
    0x868d_f800,
    0x7eae_2400,
    0x139e_ae00,
    0x2f55_c300,
    0x6ade_d880,
    0xdef7_f7c0,
    0x97a9_2e20,
    0x2c19_8310,
    0x1412_b888,
    0xf27b_c7fc,
    0x5c05_3602,
    0x7e02_d713,
    0xc701_ee99,
    0xc080_20e4,
    0x5fc5_409c,
    0x7d60_e3ef,
    0x5296_1823,
    0xaebe_5413,
    0x8be6_d621,
    0xa656_a702,
    0x855b_968e,
    0x9db2_44d3,
    0x8b0f_8e9c,
    0xe4ed_10ca,
    0xd8be_d8ba,
    0x00e7_f7d0,
    0x00d1_2e02,
    0x499d_8329,
    0x1250_b8bc,
    0x275a_c7ca,
    0x64b2_b637,
    0xac8e_970f,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x3000_0000,
    0x4800_0000,
    0x9400_0000,
    0x7200_0000,
    0xfb00_0000,
    0xa280_0000,
    0x4f40_0000,
    0x4220_0000,
    0x5210_0000,
    0xc758_0000,
    0x0394_0000,
    0x1e9e_0000,
    0x2cf7_0000,
    0x8daf_8000,
    0xc73d_4000,
    0xe027_2000,
    0x1114_d000,
    0xd9d9_f800,
    0x9ad1_4400,
    0x9dbd_4200,
    0xb367_3500,
    0xd533_2280,
    0x32cf_a7c0,
    0x4c0c_c220,
    0xe7ed_7530,
    0xd29b_8298,
    0x12f6_37cc,
    0x88aa_1a32,
    0x00bc_e115,
    0x58e1_3884,
    0xa3f7_46f2,
    0xad2b_fa9a,
    0x5b79_33c6,
    0xa481_f834,
    0x3645_4416,
    0x33a3_4213,
    0x1bd0_353a,
    0xf03c_a299,
    0x7ca2_e7c4,
    0x5b53_e206,
    0x5c7d_a52c,
    0x7004_7a9f,
    0xe804_73c4,
    0xc406_d806,
    0x0a01_9416,
    0x2702_ba2d,
    0x4485_7111,
    0xc647_e09d,
    0x1ba6_d2e6,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xf000_0000,
    0xc800_0000,
    0xec00_0000,
    0x0200_0000,
    0x7700_0000,
    0x2f80_0000,
    0x03c0_0000,
    0x6360_0000,
    0x9470_0000,
    0xc9f8_0000,
    0x14f4_0000,
    0x51ba_0000,
    0x8255_0000,
    0x07ad_8000,
    0xa15b_4000,
    0x6fe6_e000,
    0xde35_5000,
    0x105a_5800,
    0x4964_ac00,
    0x9f70_8600,
    0xfc7c_1700,
    0xb434_9580,
    0x3b5b_d0c0,
    0x8ce7_0620,
    0xf7b2_5710,
    0x7a9f_f588,
    0xb885_c0fc,
    0xbc43_be12,
    0x78a7_ab2b,
    0x2317_2b88,
    0x7b8c_7be1,
    0x4408_2d99,
    0x1fca_2ceb,
    0x88ad_d830,
    0xcada_ec14,
    0x5223_e603,
    0xf056_0702,
    0xf8aa_2dbe,
    0x42db_2ce3,
    0x9e22_5818,
    0x0250_ac20,
    0x47aa_8614,
    0x8159_170e,
    0x9fe1_159d,
    0x1634_90e1,
    0xfc5b_e63a,
    0x4b62_0720,
    0xe870_2dbf,
    0xd3fe_2ce8,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x5000_0000,
    0x0800_0000,
    0xc400_0000,
    0xea00_0000,
    0x1500_0000,
    0x1780_0000,
    0x2cc0_0000,
    0x6be0_0000,
    0x0550_0000,
    0x3428_0000,
    0xf3d4_0000,
    0x5d6e_0000,
    0x1df5_0000,
    0x525c_8000,
    0x334d_4000,
    0xd2c6_a000,
    0x5ce0_1000,
    0xe3d5_0800,
    0xb56d_2c00,
    0xa9f3_ae00,
    0xe05c_9300,
    0xea4b_b480,
    0xeb42_6a40,
    0x8f21_2e20,
    0x8ab4_d330,
    0x8b79_9488,
    0xdafb_3a54,
    0x7d3c_8622,
    0x865c_ef01,
    0x314b_b2b2,
    0x73c3_c551,
    0xf964_3ca7,
    0x1613_064a,
    0xe70e_a008,
    0x7f64_1020,
    0xbd13_0802,
    0x278c_2c12,
    0xc521_2e35,
    0x0fb4_d332,
    0xb4f9_94a6,
    0x623b_3a7e,
    0xf4dc_861c,
    0x520c_ef2a,
    0xf8e3_b2b3,
    0xb9d7_c548,
    0xd86a_3ca6,
    0x2276_0655,
    0xea9a_2013,
    0xbaad_503d,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x3000_0000,
    0x4800_0000,
    0x9400_0000,
    0x2600_0000,
    0xdd00_0000,
    0xe380_0000,
    0xf340_0000,
    0x4760_0000,
    0x5930_0000,
    0x1988_0000,
    0x1bb4_0000,
    0xab4e_0000,
    0xcc93_0000,
    0x679f_8000,
    0x66e9_4000,
    0xbe87_2000,
    0xd0c2_7000,
    0x5424_c800,
    0x2e55_ec00,
    0x08bf_9200,
    0x963c_b700,
    0x96f8_8b80,
    0xbade_0340,
    0x488e_1220,
    0xf236_f730,
    0x9f08_2bb8,
    0x3771_334c,
    0x9d6b_fa32,
    0x61c6_6b15,
    0x8da2_f1b1,
    0x5212_287b,
    0x675c_438a,
    0x4acb_ef69,
    0x4cd1_8000,
    0x6a7a_401d,
    0x3918_a014,
    0x862b_3013,
    0xa2a3_e820,
    0x6a97_9c37,
    0x7a9b_5a2e,
    0x6569_5b14,
    0x7dc7_19ac,
    0xdfa2_b46d,
    0x9916_99bb,
    0x11d8_f472,
    0xce0e_3999,
    0xdef3_c458,
    0xa92d_d189,
    0x9a24_5856,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xf000_0000,
    0x8800_0000,
    0x2400_0000,
    0x8600_0000,
    0xd500_0000,
    0x3f80_0000,
    0xddc0_0000,
    0xa260_0000,
    0xb610_0000,
    0xe8d8_0000,
    0xa094_0000,
    0x909a_0000,
    0x0035_0000,
    0x3c6d_8000,
    0x67b9_4000,
    0xc500_a000,
    0x2783_7000,
    0xa1c1_0800,
    0x7866_0c00,
    0x4915_2600,
    0xa059_ff00,
    0x11d5_c680,
    0x05bf_01c0,
    0xf602_a620,
    0x1d05_bf10,
    0x3b80_e688,
    0xabc1_31fc,
    0xff61_0e02,
    0xad91_c319,
    0xb31b_48a9,
    0xd7f6_82c9,
    0x190e_ce8d,
    0x352c_0dee,
    0x3e9a_0021,
    0x4135_0034,
    0x2ded_801f,
    0xbb79_402a,
    0x56e0_a00f,
    0xbd53_7011,
    0x52f9_081b,
    0x6622_0c33,
    0xacb7_2632,
    0x6b28_ff13,
    0xf79a_46b5,
    0x74b7_41c2,
    0x772d_861d,
    0xfd9e_8f19,
    0xf3b6_ce8f,
    0x93a8_0dfa,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0xd000_0000,
    0xd800_0000,
    0x6c00_0000,
    0x5200_0000,
    0x2b00_0000,
    0x5580_0000,
    0x9bc0_0000,
    0x5660_0000,
    0x1870_0000,
    0x98a8_0000,
    0x74f4_0000,
    0x9dee_0000,
    0x1cd5_0000,
    0x4038_8000,
    0x7e6b_c000,
    0x8a17_e000,
    0x76db_5000,
    0x0159_b800,
    0x799a_7c00,
    0xee7b_2600,
    0x83cc_6f00,
    0xec04_9580,
    0x9201_a240,
    0x0b05_a620,
    0x8586_af30,
    0x43c5_f588,
    0x3a64_3274,
    0x4a73_7e16,
    0xb3ac_432b,
    0x2170_8b9c,
    0x0629_717e,
    0x4ab5_7583,
    0x584b_f24d,
    0xe6c2_9e29,
    0xfee6_1308,
    0xeb37_b38d,
    0x1d89_cd54,
    0x39a7_33b0,
    0x9016_0d60,
    0x09de_d39f,
    0x9ad8_5d6a,
    0x935f_eb9b,
    0x7299_e165,
    0x6bfb_2da9,
    0xc00a_de4f,
    0xd660_0007,
    0xd870_0014,
    0xb8a8_0026,
    0xa4f4_0027,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0xd000_0000,
    0x8800_0000,
    0x4400_0000,
    0xf600_0000,
    0xef00_0000,
    0x4780_0000,
    0x38c0_0000,
    0x8fe0_0000,
    0x2070_0000,
    0xcc78_0000,
    0x96f4_0000,
    0x283e_0000,
    0xe855_0000,
    0x4c68_8000,
    0xf639_4000,
    0x5356_a000,
    0x55ec_f000,
    0xb5fe_d800,
    0xe535_4c00,
    0xe65f_de00,
    0x47e0_5300,
    0x8474_cd80,
    0xca78_38c0,
    0x21f1_5e20,
    0xa3b8_1330,
    0x6294_ed88,
    0xda88_88f4,
    0x7ec9_a602,
    0xe06c_ef21,
    0x743d_4bb5,
    0x3254_67cf,
    0xe16c_ed93,
    0xf0bc_88ef,
    0x0f17_a636,
    0x1749_ef37,
    0x3bad_cb88,
    0x2e59_27ce,
    0xe3e4_4d96,
    0x8275_78e8,
    0x7d79_fe24,
    0xaa71_e329,
    0x297a_b586,
    0xf470_84cc,
    0x527e_d811,
    0xcdf5_4c33,
    0xc1bf_de30,
    0xf390_531a,
    0x360c_cd85,
    0xf78c_38db,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x5000_0000,
    0x3800_0000,
    0xfc00_0000,
    0xc200_0000,
    0x2700_0000,
    0x3280_0000,
    0x8ac0_0000,
    0x8420_0000,
    0x17d0_0000,
    0xf698_0000,
    0x4454_0000,
    0x77de_0000,
    0x2d33_0000,
    0x136c_8000,
    0x341a_c000,
    0x8697_6000,
    0x87fe_d000,
    0x6ce7_5800,
    0xc4f2_c400,
    0x5bcc_4e00,
    0xac0a_c500,
    0xb1a8_0080,
    0x5439_d9c0,
    0x1f46_ce20,
    0xfc67_0530,
    0xf935_e0b8,
    0x356a_c9d4,
    0x9d1c_762e,
    0x3916_d10f,
    0xdcbb_1688,
    0x6e85_d8dd,
    0x38c4_80a2,
    0x2b23_19ed,
    0xb151_ae09,
    0x7a59_d528,
    0xd972_b887,
    0xb788_0dd8,
    0x44e8_3822,
    0x6b58_1408,
    0x5af5_163d,
    0xcecb_0123,
    0x3188_ce9f,
    0x9de9_dcf2,
    0x5cd9_ae93,
    0x95b0_0cd1,
    0xcaac_7683,
    0xd4bb_08d6,
    0x3a83_d899,
    0xdec1_ddfc,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x1000_0000,
    0x1800_0000,
    0x6c00_0000,
    0xaa00_0000,
    0x8100_0000,
    0x5080_0000,
    0xdac0_0000,
    0xf320_0000,
    0xdd50_0000,
    0x15b8_0000,
    0xf2d4_0000,
    0x08fe_0000,
    0x18b1_0000,
    0x51ce_8000,
    0x1b39_c000,
    0xaf11_e000,
    0x205e_9000,
    0xdea6_e800,
    0x2511_9400,
    0x715c_7e00,
    0x3627_ad00,
    0x83d7_a480,
    0x307f_d8c0,
    0x0674_fe20,
    0x6ceb_6d30,
    0x996e_c4a8,
    0xad2d_88c4,
    0x73cb_7626,
    0x2e38_a92b,
    0x9995_3282,
    0xc19d_e1e4,
    0xe401_24b2,
    0x1e02_18dd,
    0xe703_1e1e,
    0x6b80_fd23,
    0x1340_acbf,
    0x1560_dcd5,
    0x5eb6_6832,
    0xbac9_543a,
    0x6abb_1e07,
    0x3554_fd28,
    0x11be_ac87,
    0x9cd1_dcd4,
    0x47f8_e810,
    0x1730_9414,
    0x9c8a_fe0c,
    0x495a_6d0d,
    0x8a20_44bb,
    0x91d4_48e9,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x5000_0000,
    0xa800_0000,
    0xec00_0000,
    0x3200_0000,
    0xb700_0000,
    0x1180_0000,
    0x0640_0000,
    0x7b60_0000,
    0x5b30_0000,
    0x05a8_0000,
    0x1d74_0000,
    0xdece_0000,
    0x7647_0000,
    0x2364_8000,
    0x2f36_4000,
    0x23ad_e000,
    0xdc70_d000,
    0xa64c_d800,
    0xe486_1c00,
    0xf8c1_0a00,
    0x18a5_1700,
    0x0017_0b80,
    0xe4ff_2640,
    0x3b6c_ea20,
    0x54d5_c730,
    0x6e5b_d398,
    0xbc79_3a54,
    0x59ad_e00a,
    0x1770_d00b,
    0x4dcc_d814,
    0xe9c6_1c39,
    0x0821_0a2e,
    0x1ed5_173a,
    0x5d5f_0b92,
    0x13fb_267b,
    0x8aea_ea25,
    0x6296_c736,
    0xed39_53b1,
    0xa34c_7a5f,
    0x8202_8003,
    0x8f05_4007,
    0x3587_602b,
    0x8841_9013,
    0x5665_b80f,
    0x11b0_8c08,
    0x2068_3224,
    0xd757_db0a,
    0xef1c_d9ac,
    0x2e9f_2d46,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0xd000_0000,
    0x0800_0000,
    0x3c00_0000,
    0xfe00_0000,
    0xed00_0000,
    0xae80_0000,
    0x5440_0000,
    0xba60_0000,
    0x94f0_0000,
    0xf418_0000,
    0xf0b4_0000,
    0xf67e_0000,
    0x2041_0000,
    0x1860_8000,
    0xf7f5_4000,
    0x6f9f_6000,
    0x3e73_b000,
    0xda58_8800,
    0x1dd3_8400,
    0x3b0d_4a00,
    0x0999_e700,
    0x8773_6580,
    0xc6de_c3c0,
    0x8292_2a20,
    0xf6ea_5730,
    0xa5ab_eda8,
    0x8e4d_47f4,
    0x5b7f_6022,
    0xeec3_b03f,
    0x3c20_8817,
    0x9597_840f,
    0xcf6b_4a29,
    0x086c_e71a,
    0x39ed_e591,
    0xa82a_83de,
    0xe18d_ca36,
    0xffdc_a719,
    0x5e14_05bb,
    0xc9a9_73d9,
    0xb84c_a219,
    0x2a7c_d33e,
    0x6e40_27b1,
    0x8d64_e0c8,
    0xbd75_e5b9,
    0xf1de_83d0,
    0xab13_ca0c,
    0xf32d_a717,
    0xfe0c_85ab,
    0x8b18_33e4,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x5000_0000,
    0xf800_0000,
    0x1400_0000,
    0xda00_0000,
    0x3300_0000,
    0xcc80_0000,
    0xb740_0000,
    0xae60_0000,
    0xc870_0000,
    0xbd08_0000,
    0xf734_0000,
    0x6f6e_0000,
    0xa941_0000,
    0x7f64_8000,
    0x83f2_c000,
    0x4cca_2000,
    0x2515_1000,
    0xd1ff_3800,
    0xb179_b400,
    0xa83c_a200,
    0x1f5b_d700,
    0x80ae_d980,
    0xaa64_0b40,
    0x8a76_8220,
    0x6a0e_c730,
    0x49b1_e1a8,
    0x072d_bf54,
    0x05a2_201e,
    0xe951_1035,
    0x6f19_381e,
    0x084c_b418,
    0xee56_220d,
    0xe998_1728,
    0xd408_799d,
    0xc8b7_db7e,
    0xb4ad_9a3c,
    0xe063_6320,
    0xe176_fb98,
    0xe28d_1c4c,
    0xdcf2_7bae,
    0x8e4f_dc68,
    0xdb50_5bb6,
    0xd01e_cc4b,
    0xfac9_63ae,
    0x1812_7840,
    0x547f_4192,
    0xa9ba_6f51,
    0x859f_3808,
    0xda09_b43b,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x7000_0000,
    0x6800_0000,
    0x8c00_0000,
    0xe200_0000,
    0x1900_0000,
    0x8380_0000,
    0x6140_0000,
    0x2560_0000,
    0x9d90_0000,
    0x37b8_0000,
    0xf0d4_0000,
    0xb0da_0000,
    0xd441_0000,
    0x74e1_8000,
    0x2dd6_4000,
    0x6d5f_e000,
    0x8600_5000,
    0x3706_a800,
    0xd886_0c00,
    0x8bc0_4200,
    0xafa6_7700,
    0x55b3_8680,
    0x6d4f_86c0,
    0x43ff_a220,
    0xf436_2710,
    0xf50d_2ea8,
    0x351d_8adc,
    0x10e5_e03a,
    0x03d1_5033,
    0x365f_2810,
    0x6c84_4c1a,
    0xbdc5_a23a,
    0x10a7_273b,
    0xd134_aeb1,
    0x1c8f_cae1,
    0x1158_000d,
    0x4c04_0034,
    0x0202_000d,
    0xc905_000e,
    0x9b83_800a,
    0x8543_4014,
    0x4b64_600f,
    0x6697_1012,
    0xad38_c830,
    0x1210_1c25,
    0xf4f9_0a30,
    0x6cb0_2b2d,
    0xdecd_6c95,
    0xeabb_fdd1,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0xb000_0000,
    0x7800_0000,
    0xbc00_0000,
    0xc200_0000,
    0x4900_0000,
    0x1b80_0000,
    0x12c0_0000,
    0x0e20_0000,
    0xa870_0000,
    0x1ff8_0000,
    0x3eb4_0000,
    0x4fde_0000,
    0x4dc3_0000,
    0xcaa3_8000,
    0xbe34_c000,
    0xe798_6000,
    0xdea1_d000,
    0xc831_a800,
    0x4899_cc00,
    0x4223_5e00,
    0x3275_6d00,
    0xbaff_3580,
    0x2f37_1ec0,
    0xd01b_3e20,
    0x2664_bd30,
    0xfb16_9db8,
    0xfd6a_d2ec,
    0x781e_603e,
    0x9266_d01f,
    0x1d14_2808,
    0x7a6a_0c3e,
    0x909e_be18,
    0x6e27_7d2b,
    0xd873_7db3,
    0x87fc_c2f8,
    0x32b4_2821,
    0xf5da_0c3b,
    0xb8c6_be28,
    0x1323_7d15,
    0xe5f5_7dab,
    0xf23b_c2cf,
    0x6411_a83a,
    0xd9e9_cc06,
    0xde5b_5e3e,
    0x1201_6d15,
    0x4101_35b4,
    0x3f84_1efe,
    0xdcc0_be0b,
    0xfd24_7d34,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x1000_0000,
    0x1800_0000,
    0x3400_0000,
    0x8a00_0000,
    0xd300_0000,
    0x9080_0000,
    0x78c0_0000,
    0xa6e0_0000,
    0x3130_0000,
    0x1528_0000,
    0xc5f4_0000,
    0xddce_0000,
    0x95c5_0000,
    0xaf66_8000,
    0x2a71_c000,
    0x4b89_2000,
    0x32e0_9000,
    0x6b31_3800,
    0xfe29_d400,
    0x7171_de00,
    0x370f_7300,
    0xd426_ef80,
    0x84d7_4e40,
    0x9498_fe20,
    0xb81f_e330,
    0xa6df_d788,
    0x4d3a_9a44,
    0xa58f_2026,
    0x93e1_903d,
    0x2cb1_b82a,
    0x9469_1430,
    0x5050_7e22,
    0x8e5b_2313,
    0xd1f8_778b,
    0xb16f_ca78,
    0x55d1_3801,
    0x3b19_d41f,
    0xce59_de16,
    0x31fb_732d,
    0x8168_efa8,
    0x5dd2_4e76,
    0x171e_7e27,
    0x705e_232d,
    0x68fe_f79d,
    0xc2ee_0a6f,
    0xb590_1801,
    0xc93d_4430,
    0xe78e_e600,
    0x4ce3_a71f,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x3000_0000,
    0x8800_0000,
    0x1c00_0000,
    0x4a00_0000,
    0x4d00_0000,
    0xfc80_0000,
    0x2240_0000,
    0x8b20_0000,
    0x1590_0000,
    0x5cf8_0000,
    0xadd4_0000,
    0x62da_0000,
    0xb0c7_0000,
    0x7a63_8000,
    0x1937_4000,
    0xa0a9_6000,
    0x61ca_1000,
    0x937c_8800,
    0x7810_b400,
    0xe83b_fa00,
    0x19b1_7d00,
    0xb8ee_9e80,
    0x4fef_4ec0,
    0x566a_9a20,
    0xc4af_6d10,
    0x9fc8_1698,
    0xd878_facc,
    0x3b92_e002,
    0xeff9_5017,
    0x1a57_e80a,
    0x0319_a41f,
    0x3c26_f21d,
    0x6c15_890f,
    0xfe3d_84b0,
    0x7eb0_63d6,
    0x3968_6c88,
    0x192a_c7f3,
    0xe30f_1e82,
    0x101b_0ef5,
    0x9ba2_7a13,
    0xd5d1_3d36,
    0xd6dc_7e98,
    0xb6c6_1eec,
    0xc565_7215,
    0x3cb2_c914,
    0x286c_e485,
    0xcfae_73cc,
    0xbc4e_e482,
    0xefbd_73fc,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xd000_0000,
    0x1800_0000,
    0x2c00_0000,
    0xbe00_0000,
    0xc700_0000,
    0xe280_0000,
    0x1b40_0000,
    0x3be0_0000,
    0xe8d0_0000,
    0x0778_0000,
    0x3194_0000,
    0x1d9a_0000,
    0xf0c5_0000,
    0x8d24_8000,
    0x3ef1_c000,
    0x8d0f_e000,
    0x84d9_3000,
    0xca21_5800,
    0x9c71_e400,
    0xb649_6200,
    0x6f3c_8b00,
    0x3af0_3c80,
    0xb70e_74c0,
    0x39de_8220,
    0xb5a1_bb10,
    0x28b3_6488,
    0x216e_90f4,
    0x3cc9_6026,
    0xd079_f01b,
    0xab10_3827,
    0xdadc_1405,
    0xbd23_5a3e,
    0x96f5_9f0d,
    0x490f_e6a1,
    0xdede_2bcb,
    0x8724_8499,
    0x2bf3_a0da,
    0x368a_3821,
    0x6a19_1422,
    0x1007_da2c,
    0x7804_5f3c,
    0xdc00_068d,
    0x7607_1be7,
    0xf305_dca6,
    0x7082_44cf,
    0x6243_5a10,
    0x1e65_9f22,
    0x1117_e6bd,
    0x27da_2bc3,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0xf000_0000,
    0x9800_0000,
    0xd400_0000,
    0x0600_0000,
    0x9100_0000,
    0xb380_0000,
    0xd7c0_0000,
    0x2b60_0000,
    0xef90_0000,
    0x5f18_0000,
    0x3a54_0000,
    0x2b7a_0000,
    0xab43_0000,
    0xaa25_8000,
    0xb6b3_c000,
    0xb529_2000,
    0x5e38_f000,
    0xa464_2800,
    0x5910_ac00,
    0xdd5a_b600,
    0xa7f3_8700,
    0xc409_a280,
    0x180e_33c0,
    0xe20b_9620,
    0xd90f_7710,
    0xd98f_8ab8,
    0xb2c9_9ffc,
    0xb8ee_a006,
    0x1e5c_3025,
    0xc372_8839,
    0xd148_9c18,
    0xa72a_3e0a,
    0x693c_1b00,
    0x96e4_1c8b,
    0x5556_e8df,
    0x6df9_2a9b,
    0xb101_afeb,
    0xe386_2818,
    0x5fc7_ac3d,
    0x9765_3623,
    0xa593_472a,
    0x1c1d_0280,
    0x1ed1_03ec,
    0xde3c_9e0e,
    0xe464_2b3a,
    0xb914_9484,
    0x2d59_74cc,
    0x3ff4_9483,
    0x1009_74c0,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0xf000_0000,
    0xc800_0000,
    0xfc00_0000,
    0xfe00_0000,
    0x8100_0000,
    0x3e80_0000,
    0x30c0_0000,
    0x1360_0000,
    0x8a30_0000,
    0xfec8_0000,
    0xf0f4_0000,
    0x2eaa_0000,
    0xdb43_0000,
    0xaf25_8000,
    0xfe91_4000,
    0xd418_6000,
    0xbc4d_b000,
    0x7e35_e800,
    0x5ccb_0400,
    0x9ff1_0e00,
    0xa92a_af00,
    0xe107_7780,
    0x8e82_fd40,
    0x18c1_6e20,
    0x1f63_1f10,
    0xbc30_9fb8,
    0x83ce_f97c,
    0x3077_e012,
    0x9f6f_f02f,
    0xf6a0_0807,
    0x15d3_f41c,
    0x133e_863d,
    0xaedb_1b33,
    0x6c2c_11bb,
    0x5581_1642,
    0xdd42_f790,
    0xba23_bd60,
    0xd211_0e17,
    0xa3da_af38,
    0x24af_779e,
    0xf846_fd40,
    0xfea3_6e13,
    0x49d4_1f16,
    0xfd3f_1fbc,
    0x17dc_b978,
    0x66aa_000b,
    0x6743_0004,
    0xb125_801b,
    0x8f91_4036,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0xd000_0000,
    0x4800_0000,
    0xc400_0000,
    0xf200_0000,
    0x7300_0000,
    0x2480_0000,
    0x1dc0_0000,
    0xe760_0000,
    0x2d70_0000,
    0x0178_0000,
    0x5eb4_0000,
    0x4b1a_0000,
    0x2243_0000,
    0x6a24_8000,
    0x5dd5_4000,
    0xe468_a000,
    0x2839_d000,
    0x4c13_b800,
    0x750b_b400,
    0x644e_f600,
    0xcaec_df00,
    0x5afc_e580,
    0x11f1_00c0,
    0xd0be_5620,
    0x6fd1_0f10,
    0x376d_5db8,
    0x3cbd_b4f4,
    0xc9d6_2032,
    0x1e6f_9021,
    0x7f3f_9804,
    0x4a97_2428,
    0x53cd_ee1b,
    0x63aa_bb36,
    0x085b_ab85,
    0xcfe5_6bd7,
    0x46b0_c5a9,
    0x871d_90c0,
    0xf445_4e33,
    0x3b23_6b27,
    0x4250_13b0,
    0x192a_dfc5,
    0x209c_33a5,
    0xf506_4fff,
    0x7d87_2ba4,
    0x2644_2bf5,
    0x3822_659a,
    0x1ed7_40e1,
    0x58ea_760a,
    0xb9f9_9f0c,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0xd000_0000,
    0x6800_0000,
    0x2c00_0000,
    0x8e00_0000,
    0x0700_0000,
    0x1680_0000,
    0x93c0_0000,
    0x10a0_0000,
    0x9670_0000,
    0xadd8_0000,
    0xffb4_0000,
    0x607e_0000,
    0xd247_0000,
    0x3de0_8000,
    0x5910_4000,
    0x750f_e000,
    0xab1b_3000,
    0x0893_5800,
    0x5049_c400,
    0x987d_2600,
    0x3647_f100,
    0x2fe7_0d80,
    0x6815_7bc0,
    0x208a_c620,
    0x8c58_c130,
    0x02f2_5598,
    0xc71f_bff4,
    0x2691_603a,
    0xe74c_703b,
    0x36fc_383b,
    0xe182_b435,
    0x9d41_9e1f,
    0x7765_052f,
    0x9cd1_73a7,
    0xf6af_4ee4,
    0xe1ee_ed8e,
    0x938d_4beb,
    0x20df_1e24,
    0xec32_4515,
    0xdc3e_13a6,
    0xf8a4_3ed6,
    0x7a72_559c,
    0x43df_bfe4,
    0x28b1_6013,
    0x1efc_7023,
    0x6d84_3838,
    0xa346_b419,
    0xc867_9e1f,
    0xce56_051e,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xd000_0000,
    0xb800_0000,
    0x7400_0000,
    0xae00_0000,
    0x5900_0000,
    0xfa80_0000,
    0x11c0_0000,
    0xdbe0_0000,
    0x45f0_0000,
    0x1578_0000,
    0xd934_0000,
    0x0a1a_0000,
    0x4c05_0000,
    0x9a04_8000,
    0xd704_c000,
    0x7385_2000,
    0x5340_b000,
    0xbe21_6800,
    0x3012_a400,
    0x098a_4600,
    0x36cd_0b00,
    0xc2ec_a180,
    0x9df9_74c0,
    0x93f5_6620,
    0x5878_bb10,
    0x7db1_4988,
    0x2adb_10f4,
    0xa160_000e,
    0x1430_000d,
    0xee98_0023,
    0x4cc4_0022,
    0xa762_0010,
    0xe131_0019,
    0x3e1e_801d,
    0xc201_c007,
    0x1301_a03b,
    0x9584_7032,
    0x1644_4834,
    0x26a2_1402,
    0xa2d3_2e23,
    0xdfeb_af03,
    0xc17c_e79e,
    0xe731_7fc7,
    0xcb1d_47a9,
    0x1285_0fe9,
    0x9dc1_0fb6,
    0x21e3_1bfd,
    0x62f0_2199,
    0x0ef9_b4d2,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x7000_0000,
    0x6800_0000,
    0x1c00_0000,
    0x1a00_0000,
    0xb700_0000,
    0x1a80_0000,
    0xedc0_0000,
    0xeaa0_0000,
    0xf970_0000,
    0xd398_0000,
    0x4fb4_0000,
    0x11ba_0000,
    0x1003_0000,
    0x5801_8000,
    0x9404_4000,
    0x7603_6000,
    0xc503_9000,
    0xb185_5800,
    0xed40_0400,
    0xb062_d600,
    0x0957_8100,
    0xc728_a580,
    0x768d_c9c0,
    0xa77b_b620,
    0xd227_1110,
    0x07b4_7db8,
    0xddbd_8ddc,
    0xf200_003a,
    0xeb00_0017,
    0xe080_003e,
    0x2ac0_0031,
    0x9820_001c,
    0x08b0_003c,
    0x2338_003c,
    0x01c4_0013,
    0xd8a2_0032,
    0xb277_0028,
    0xa31b_803e,
    0x7d77_403a,
    0xfd9a_e022,
    0x1eb3_d036,
    0xd63c_3819,
    0x3840_9435,
    0x59e6_0e3a,
    0x7013_c51e,
    0x0149_13b1,
    0xbad9_d8f3,
    0xd1d6_4bbd,
    0x49ea_dcf6,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0xb000_0000,
    0x3800_0000,
    0x0400_0000,
    0x3600_0000,
    0x2f00_0000,
    0x1e80_0000,
    0x0540_0000,
    0x72e0_0000,
    0x3c10_0000,
    0x2218_0000,
    0xaa54_0000,
    0xbc7e_0000,
    0x6a03_0000,
    0x6d03_8000,
    0xdf86_c000,
    0x80c5_a000,
    0x6720_7000,
    0x60b1_5800,
    0x4469_4400,
    0x9e1d_5200,
    0x5851_6300,
    0x4578_ca80,
    0xeb84_07c0,
    0x4ec6_f220,
    0xac22_1330,
    0xf832_12b8,
    0x562f_83ec,
    0xf678_002e,
    0x5704_0031,
    0x3a86_0035,
    0x6347_0027,
    0xd5e5_8009,
    0x1e91_c000,
    0x1558_2011,
    0xc1b5_b004,
    0xb1ef_780f,
    0x53db_f42b,
    0xb0f7_aa33,
    0x2d0b_5715,
    0xf4cf_4093,
    0x826e_e0dd,
    0xa918_caaf,
    0x12d4_07f3,
    0xfe3e_f21b,
    0x8a66_133a,
    0x5e54_12b1,
    0x9278_83e2,
    0x1105_802a,
    0xcd81_c011,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x5000_0000,
    0x0800_0000,
    0x6c00_0000,
    0x0200_0000,
    0x0500_0000,
    0x1f80_0000,
    0x2740_0000,
    0xa220_0000,
    0x4190_0000,
    0xb828_0000,
    0x41d4_0000,
    0x908e_0000,
    0x9081_0000,
    0x91c4_8000,
    0x38e5_4000,
    0x91f1_e000,
    0x4c18_5000,
    0xf32f_4800,
    0xc952_ec00,
    0x054a_1200,
    0x3666_6d00,
    0x5f37_f680,
    0x0a7e_f040,
    0x341d_f220,
    0x072b_3d30,
    0x0f52_3ea8,
    0x3e48_5c54,
    0x26e2_8022,
    0x0ef0_402b,
    0x929b_6028,
    0xf5ec_1015,
    0x4332_2805,
    0x907b_fc12,
    0xf51a_ba28,
    0x26ad_d111,
    0x2716_2ca9,
    0xeaef_3159,
    0x5db1_f6ac,
    0x36bb_f044,
    0x2f7f_7202,
    0xbb9b_7d3a,
    0x8869_5eaa,
    0x9174_4c78,
    0x75d8_a83a,
    0xf7cf_bc16,
    0x52a7_da0a,
    0x2054_c102,
    0xd8ce_8486,
    0xb420_8d72,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x9000_0000,
    0x9800_0000,
    0x8400_0000,
    0x2200_0000,
    0x8500_0000,
    0xd480_0000,
    0xc740_0000,
    0xd720_0000,
    0x0990_0000,
    0x03b8_0000,
    0x51d4_0000,
    0xb11e_0000,
    0x8183_0000,
    0xabc2_8000,
    0xe463_c000,
    0xf4b0_a000,
    0x932d_d000,
    0x20ec_0800,
    0x808d_b400,
    0xb63f_1200,
    0x3011_9d00,
    0x5c7f_3680,
    0x9fb1_c4c0,
    0xdca9_b220,
    0x602b_4d30,
    0xeb6f_beb8,
    0xe24c_b0e4,
    0x58dc_8006,
    0xb0e0_c011,
    0xf3f2_2030,
    0xa40e_1005,
    0xb97c_a813,
    0x1b30_6410,
    0x63eb_1a3d,
    0xa308_2923,
    0x58fe_24b5,
    0xe0f3_59e5,
    0xff8c_04b9,
    0x43bd_49d2,
    0x71d0_acb2,
    0xc11d_2df9,
    0x8983_b6af,
    0xb7c1_04f1,
    0x4263_9214,
    0x53b1_5d0d,
    0xc2ad_16b3,
    0x332f_d4fd,
    0x90ed_1a11,
    0x688f_2904,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x7000_0000,
    0x6800_0000,
    0x9400_0000,
    0x0200_0000,
    0xd700_0000,
    0xfe80_0000,
    0xfac0_0000,
    0x07a0_0000,
    0x9310_0000,
    0xeab8_0000,
    0xe4d4_0000,
    0x989e_0000,
    0xf587_0000,
    0x4245_8000,
    0x5060_4000,
    0x3137_2000,
    0x83eb_5000,
    0xb20e_1800,
    0xc37d_e400,
    0xc7f0_6e00,
    0xba49_4900,
    0x001c_8e80,
    0x7241_08c0,
    0x9861_4e20,
    0xb531_1930,
    0x99e9_1698,
    0x990b_acdc,
    0xabfb_803a,
    0xe837_4015,
    0x946a_a018,
    0x974f_1029,
    0x659f_3825,
    0xe805_b41b,
    0x5405_f601,
    0x6203_ed11,
    0xa706_4085,
    0x9687_51c7,
    0x6ec2_f887,
    0x05a5_a5e9,
    0x4415_ae92,
    0x143d_58c1,
    0x1e12_d608,
    0x9f38_bd14,
    0x6690_58be,
    0xa8fe_b5e8,
    0xb4b4_96b8,
    0xa9af_ecd0,
    0x766a_a02a,
    0xf04f_102f,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x1000_0000,
    0xe800_0000,
    0x4c00_0000,
    0x3e00_0000,
    0x4f00_0000,
    0x6380_0000,
    0x8ac0_0000,
    0x9720_0000,
    0x6430_0000,
    0xbe48_0000,
    0x03f4_0000,
    0x73ea_0000,
    0x7d83_0000,
    0x75c2_8000,
    0xeca0_4000,
    0x5af2_e000,
    0xb36e_b000,
    0x5ac4_1800,
    0xdf20_ec00,
    0xd831_2e00,
    0x784f_2500,
    0xe8f4_3780,
    0x6269_2b40,
    0x8641_ce20,
    0xce66_9510,
    0x61d0_afb8,
    0xf95e_8744,
    0x438a_801a,
    0xf354_4003,
    0x1f18_e037,
    0xdded_b017,
    0x9a86_9822,
    0xba40_ac31,
    0x4863_ce2a,
    0x6ad1_950a,
    0xf8d8_2fb7,
    0x504d_c762,
    0x04f2_e019,
    0xac6e_b016,
    0x3144_180a,
    0x09e0_ec3f,
    0x9911_2e30,
    0x1f7f_2520,
    0x0b3c_3784,
    0xa45d_2b5f,
    0x010b_ce18,
    0x5d15_9500,
    0x3d7a_2fb1,
    0x723a_c772,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x1000_0000,
    0x2800_0000,
    0x7c00_0000,
    0xde00_0000,
    0x7f00_0000,
    0xa680_0000,
    0x6b40_0000,
    0xe8e0_0000,
    0xf550_0000,
    0xa918_0000,
    0x2b14_0000,
    0xda7e_0000,
    0x8285_0000,
    0x1146_8000,
    0x2de0_4000,
    0xb6d3_6000,
    0x91df_b000,
    0xd334_1800,
    0xab0d_c400,
    0x84ed_a200,
    0x4338_f300,
    0x0366_b080,
    0x7196_6fc0,
    0xaf38_c220,
    0x3566_4330,
    0x5292_2888,
    0xc7ba_ebc4,
    0x0926_802a,
    0x60f0_402f,
    0x87ab_603f,
    0x37db_b01b,
    0x1832_1823,
    0x9f8c_c405,
    0x76ad_220d,
    0x2659_b322,
    0x99f5_5083,
    0xfa28_9fd0,
    0x401f_3a2c,
    0x7e95_772d,
    0xd1b8_72a6,
    0x3a21_2cc5,
    0x2072_6ab1,
    0xc7e9_e8eb,
    0xdbb9_48af,
    0x2721_5bca,
    0x07f4_9807,
    0x652c_8405,
    0xd69e_423b,
    0x2dd6_030f,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x5000_0000,
    0x2800_0000,
    0x1400_0000,
    0xf600_0000,
    0xbf00_0000,
    0x1780_0000,
    0xf840_0000,
    0x21a0_0000,
    0xfd30_0000,
    0x41f8_0000,
    0x92f4_0000,
    0xd81a_0000,
    0xae63_0000,
    0x34d0_8000,
    0x556e_4000,
    0x6a3e_2000,
    0xd510_f000,
    0x4f88_5800,
    0xa32e_8c00,
    0x889f_fa00,
    0x3da1_5100,
    0xef30_bb80,
    0x90fd_8ac0,
    0x5671_5a20,
    0xfddf_e110,
    0x2a86_c3b8,
    0xb6c3_f6d4,
    0xb966_f82a,
    0x7750_3c15,
    0xbb29_8205,
    0xa49f_2d3b,
    0x17a7_198f,
    0xe232_57fb,
    0xe67e_1b95,
    0x12b3_3ac0,
    0xc5bf_220d,
    0xb155_9d1e,
    0x3c2b_618c,
    0x6f1f_2bc5,
    0x5de1_398a,
    0xa296_a7cb,
    0xa7cc_438c,
    0x4a8e_b6cb,
    0x31a8_5801,
    0xa25e_8c3d,
    0xd6c7_fa2f,
    0xa965_511f,
    0xbf52_bbbc,
    0xff2a_8ad7,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0xf000_0000,
    0x0800_0000,
    0x2400_0000,
    0xae00_0000,
    0x0500_0000,
    0x1780_0000,
    0x73c0_0000,
    0x6c20_0000,
    0x7150_0000,
    0xe5e8_0000,
    0x3d14_0000,
    0x6e0a_0000,
    0x2661_0000,
    0x2bb5_8000,
    0x4f1d_4000,
    0x2a6a_a000,
    0xd2d3_3000,
    0x202e_0800,
    0x2833_4c00,
    0x7ade_7600,
    0x374b_bd00,
    0xe205_c480,
    0x9f06_5640,
    0xe481_5620,
    0xbd45_cd10,
    0x8a61_6ca8,
    0xe1b6_2a7c,
    0x4419_2822,
    0xc8e9_3c19,
    0xbe90_de03,
    0x1bca_c13d,
    0x9b40_3a87,
    0xeb63_e755,
    0xf830_4490,
    0xc2db_164d,
    0xbb4b_f634,
    0x9806_fd3f,
    0x3c07_64aa,
    0xd201_6660,
    0x7705_5e3a,
    0x9087_8104,
    0xeb42_9a97,
    0xa364_d75c,
    0x7c34_4cbe,
    0x9cd9_5a40,
    0xb648_0015,
    0xab84_0007,
    0xe1c2_003d,
    0xbb25_0002,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x3000_0000,
    0xb800_0000,
    0xfc00_0000,
    0xf600_0000,
    0x5300_0000,
    0xff80_0000,
    0xc240_0000,
    0x07e0_0000,
    0x5050_0000,
    0x8dc8_0000,
    0xd194_0000,
    0x5e6e_0000,
    0xc525_0000,
    0xf477_8000,
    0x1f3c_c000,
    0x766a_6000,
    0x7120_7000,
    0x6672_7800,
    0x7638_cc00,
    0x94ec_ca00,
    0xe3e7_e300,
    0xaa53_c080,
    0xb0c9_f940,
    0xb111_2a20,
    0x2dab_5330,
    0xaf83_d888,
    0xaa45_454c,
    0x53e1_980e,
    0xd251_7c0f,
    0x6ccb_5235,
    0x7717_9f18,
    0xc6a9_1291,
    0xac03_a64f,
    0x9e03_d89c,
    0x0705_4570,
    0x7d81_9834,
    0x2341_7c38,
    0xa163_5230,
    0xc893_9f16,
    0xe4ef_128d,
    0xbbe2_a658,
    0x4652_58a8,
    0xcec8_8579,
    0xa612_7832,
    0xd828_cc02,
    0xc8c4_ca3c,
    0x0123_e337,
    0x3e75_c094,
    0x9a38_f95f,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x7000_0000,
    0xd800_0000,
    0x6400_0000,
    0x3e00_0000,
    0x4100_0000,
    0xdc80_0000,
    0x8440_0000,
    0xe2e0_0000,
    0x7650_0000,
    0x0a18_0000,
    0xaa94_0000,
    0xe2be_0000,
    0xc727_0000,
    0x5675_8000,
    0x05ed_c000,
    0xd9bc_a000,
    0xb4a5_3000,
    0x87b4_2800,
    0x73cf_9400,
    0x4b4f_6a00,
    0x310e_1300,
    0xf2ec_4080,
    0x283e_3fc0,
    0x7e66_4a20,
    0x5216_e330,
    0xf8fc_c898,
    0x74c0_9bdc,
    0x54a3_0816,
    0x37b0_6429,
    0xcbca_6217,
    0x5f4d_770c,
    0xd70d_a281,
    0xd7e9_88f8,
    0xcaba_c897,
    0xbb23_9bfd,
    0x6c70_880d,
    0x0aee_a427,
    0x9c3d_422e,
    0x8862_8729,
    0xdf10_aaae,
    0xa67e_ece2,
    0xeb85_2a96,
    0x15c3_2cdd,
    0x5821_8a83,
    0x7bf2_1ccd,
    0xe52b_a290,
    0xab1a_88e3,
    0xc611_48a6,
    0xdef9_5be8,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x5000_0000,
    0x5800_0000,
    0x4c00_0000,
    0x0e00_0000,
    0x0500_0000,
    0xc680_0000,
    0xcac0_0000,
    0x5e60_0000,
    0xb430_0000,
    0x83c8_0000,
    0x0474_0000,
    0x316e_0000,
    0x4f23_0000,
    0x8a14_8000,
    0x1d5d_c000,
    0x60ec_e000,
    0xd060_b000,
    0x7133_4800,
    0xa54b_c400,
    0x9eb2_3e00,
    0x370a_6700,
    0xb712_e780,
    0x07da_3540,
    0x1c2a_5e20,
    0x9707_1730,
    0x5585_4fb8,
    0xa545_4154,
    0x0c25_2836,
    0x7d95_b423,
    0xe319_163b,
    0xf74c_d315,
    0xedb7_71a7,
    0x088f_2661,
    0xbd57_cfb4,
    0x827f_815c,
    0x72fb_4809,
    0x613f_c417,
    0x4fdc_3e35,
    0x2829_6739,
    0x6506_6797,
    0x5687_f554,
    0x72c6_be06,
    0x4267_a724,
    0xe236_07a0,
    0xcace_8565,
    0xccf7_163e,
    0xfeaf_d336,
    0xd7c3_f1a6,
    0xf4e2_e66f,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0xd000_0000,
    0x4800_0000,
    0x5400_0000,
    0x1a00_0000,
    0x0700_0000,
    0x8780_0000,
    0x86c0_0000,
    0xdd20_0000,
    0xcab0_0000,
    0xa668_0000,
    0xb7f4_0000,
    0x838e_0000,
    0x0565_0000,
    0xa3d0_8000,
    0x13bb_4000,
    0x8548_2000,
    0x1840_9000,
    0x4965_9800,
    0x65d3_6c00,
    0x7ab8_ce00,
    0xcfce_3500,
    0x5602_1380,
    0xc104_3240,
    0xee80_6e20,
    0xcc45_e530,
    0x9367_ab88,
    0x42d3_ce74,
    0x2d3b_3832,
    0x0109_bc25,
    0xdf23_f60e,
    0x11b7_8935,
    0x4fe9_e5b3,
    0xfc37_bb74,
    0x962f_8b91,
    0x9a93_5e43,
    0x445e_a020,
    0xb4da_d008,
    0xed9b_380d,
    0x8a79_bc12,
    0x03eb_f615,
    0x3a33_893d,
    0xff2f_e5a6,
    0xd016_bb67,
    0x0a19_0b8c,
    0x3cb9_1e7e,
    0x66c8_0009,
    0x3c84_002e,
    0x5f46_0014,
    0x2ee1_0024,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x1000_0000,
    0xf800_0000,
    0x3400_0000,
    0x5e00_0000,
    0x8300_0000,
    0x5a80_0000,
    0x7240_0000,
    0xc2e0_0000,
    0xa670_0000,
    0xcfe8_0000,
    0x10b4_0000,
    0x5c4a_0000,
    0xdea3_0000,
    0xaf92_8000,
    0x0f18_c000,
    0x2f1d_2000,
    0x9f1b_3000,
    0x971c_b800,
    0x4b19_a400,
    0xd919_ca00,
    0x301b_2300,
    0xb79b_b180,
    0x1c59_6040,
    0xf67e_6a20,
    0xe0ac_d310,
    0x4bd0_29b8,
    0x32f8_f444,
    0xb1e9_981e,
    0x23b6_941d,
    0x0ecf_722f,
    0x70e1_8724,
    0xff70_fba8,
    0x406a_8351,
    0x6770_fb87,
    0x246a_8359,
    0x2170_fbbd,
    0x836a_834c,
    0xddf0_fb81,
    0x462a_8347,
    0x1b90_fba9,
    0x111a_837e,
    0x4c18_fbbb,
    0xd59e_8375,
    0x1d5a_fb99,
    0xbdf9_835d,
    0x216a_7b99,
    0x7cf6_4363,
    0xfdaf_dbbb,
    0x3256_b36a,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x7000_0000,
    0xe800_0000,
    0xdc00_0000,
    0x3200_0000,
    0xcb00_0000,
    0xd180_0000,
    0x16c0_0000,
    0x36a0_0000,
    0x4870_0000,
    0xb1d8_0000,
    0x4d34_0000,
    0x72be_0000,
    0x5e67_0000,
    0xdfd5_8000,
    0xb72c_4000,
    0xa5a9_6000,
    0x0eec_d000,
    0x9489_b800,
    0x8d5d_9c00,
    0x7f73_2e00,
    0x8258_1900,
    0x68f6_4580,
    0xd19f_d3c0,
    0x06d7_ce20,
    0x7dac_8930,
    0x9ae8_9d98,
    0x6a89_9fdc,
    0xec58_d81a,
    0x51f5_4c07,
    0xab1c_9614,
    0xb196_852e,
    0xb5ce_eb8e,
    0x383c_8af2,
    0xa125_6ba1,
    0xdbb7_cad0,
    0xbff9_8ba0,
    0x9107_5afa,
    0x0681_5393,
    0x9542_16de,
    0x9b65_c595,
    0x4750_93d7,
    0x336d_2e0f,
    0xf84f_1938,
    0xbcfb_c585,
    0x4c87_93c0,
    0xda40_ae35,
    0x2ce7_5912,
    0x0494_a5a2,
    0xc548_43ea,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0xd000_0000,
    0xe800_0000,
    0x4c00_0000,
    0x8e00_0000,
    0xd900_0000,
    0xa880_0000,
    0x5240_0000,
    0x3ea0_0000,
    0x3ab0_0000,
    0x44e8_0000,
    0x3274_0000,
    0x070a_0000,
    0x83e7_0000,
    0x9194_8000,
    0x269c_4000,
    0x9d78_e000,
    0xa8ed_3000,
    0x4c71_a800,
    0x860e_b400,
    0x5f62_9a00,
    0xe9d5_1100,
    0x0339_1780,
    0x5849_8a40,
    0xcfc6_fa20,
    0xba60_6110,
    0xd752_5f98,
    0x9c79_0e74,
    0x346b_481a,
    0x5430_8403,
    0x73ad_b23b,
    0x7250_e502,
    0xc2ff_ed90,
    0x7b29_eb47,
    0xd014_a58c,
    0xa459_6f68,
    0x3599_1783,
    0xbef9_8a7c,
    0x8d2e_fa0c,
    0xcd14_6119,
    0x1ed8_5fb4,
    0xd8de_0e54,
    0xbddf_c835,
    0xc35c_c42b,
    0x3c1d_5229,
    0x8039_d530,
    0xf3cc_45be,
    0x7604_5f55,
    0x5d00_bf8f,
    0xda83_3e73,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x1000_0000,
    0x0800_0000,
    0x6c00_0000,
    0x2200_0000,
    0xc900_0000,
    0x3080_0000,
    0x4740_0000,
    0x9ea0_0000,
    0xfcb0_0000,
    0x44f8_0000,
    0x7d74_0000,
    0x221a_0000,
    0xd0e7_0000,
    0x7292_8000,
    0x8f0b_4000,
    0xbf2f_e000,
    0xc7df_5000,
    0xf800_2800,
    0x3401_1400,
    0x2607_b200,
    0x9706_d100,
    0xd387_ef80,
    0xd2c2_eac0,
    0xcb62_d220,
    0xec56_c110,
    0x166a_2798,
    0x827f_aec4,
    0x8535_c822,
    0x7339_440b,
    0xc495_1a10,
    0x500c_8536,
    0x60af_bd8e,
    0x271b_6bca,
    0xf265_158f,
    0x84d5_3fdd,
    0x552f_47a5,
    0x42df_beda,
    0x9a80_0015,
    0xa240_0004,
    0xec20_001f,
    0x62f0_0011,
    0xe2d8_0021,
    0xaa84_003d,
    0xda42_0001,
    0x9823_0032,
    0x24f0_801c,
    0x65d8_4025,
    0x7107_6034,
    0x6483_102d,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x1000_0000,
    0x1800_0000,
    0xa400_0000,
    0x1a00_0000,
    0xc700_0000,
    0x4680_0000,
    0x2040_0000,
    0xbd60_0000,
    0xc390_0000,
    0xba88_0000,
    0xc254_0000,
    0x312a_0000,
    0xa4e5_0000,
    0x4152_8000,
    0x1da9_c000,
    0x6ba1_a000,
    0x16b2_1000,
    0x587a_1800,
    0x154e_6400,
    0x8cf1_fa00,
    0x7219_ff00,
    0xa85a_4e80,
    0xa238_4740,
    0x0f28_da20,
    0x39e7_2f10,
    0xe0d3_7688,
    0x6b6d_f344,
    0xee82_9826,
    0xcc42_a439,
    0x3b62_da0e,
    0xaa92_2f35,
    0x3909_f697,
    0xc790_3361,
    0xf089_3809,
    0x3d55_b411,
    0xc3aa_4237,
    0x86a5_8b3c,
    0x9f31_aca5,
    0x82bf_dc70,
    0x366b_6e98,
    0x2f02_9756,
    0x8a83_e22f,
    0xb643_9b30,
    0xcc61_b4a7,
    0xe414_b85f,
    0xa548_14b7,
    0xc4f2_a861,
    0xee18_0c8f,
    0x0659_cc69,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x9000_0000,
    0x1800_0000,
    0x4400_0000,
    0xee00_0000,
    0x2900_0000,
    0x8780_0000,
    0xe940_0000,
    0x6da0_0000,
    0x2bd0_0000,
    0x44a8_0000,
    0x5414_0000,
    0x33ce_0000,
    0xfd27_0000,
    0xd412_8000,
    0xf3cb_c000,
    0x9d22_a000,
    0x4411_b000,
    0xebc8_6800,
    0xd923_cc00,
    0xaa10_c200,
    0xc2ce_7100,
    0x5ea1_e480,
    0x4356_c040,
    0xaf6e_e220,
    0x7573_0130,
    0x07f9_ac98,
    0xfb7f_7c64,
    0x46bc_e826,
    0xfadb_0c21,
    0x2f6e_e223,
    0xb573_012e,
    0x67f9_aca7,
    0x6b7f_7c6b,
    0x5ebc_e800,
    0xbedb_0c30,
    0xc16e_e228,
    0x9c73_010b,
    0xe079_ac91,
    0x823f_7c64,
    0x331c_e83f,
    0x950b_0c13,
    0x85c6_e212,
    0xc867_0130,
    0xd3b7_ac92,
    0x7f18_7c51,
    0xe70e_6807,
    0x66c0_cc0e,
    0x18e4_4218,
    0x8c76_b107,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x7000_0000,
    0x7800_0000,
    0xbc00_0000,
    0x0600_0000,
    0xc300_0000,
    0x3980_0000,
    0xcd40_0000,
    0x5aa0_0000,
    0x34b0_0000,
    0xbdb8_0000,
    0xcb74_0000,
    0xb7da_0000,
    0x8225_0000,
    0xa971_8000,
    0xfeda_c000,
    0x26a2_6000,
    0x52b1_f000,
    0x2eba_f800,
    0xfaf6_7c00,
    0xbe99_b200,
    0x6283_f900,
    0x58c6_7f80,
    0xb9e3_e0c0,
    0x1910_5220,
    0x728d_c910,
    0xc28f_6788,
    0xda8e_acdc,
    0x3689_783e,
    0x388d_bc3f,
    0x3f88_5209,
    0xbc09_c92c,
    0xb44d_6790,
    0x146f_acdc,
    0xd41a_f837,
    0xfe46_7c2d,
    0x5b21_b229,
    0x65f7_f91d,
    0x911c_7fa5,
    0x44c6_e0c2,
    0x8fe1_d224,
    0x8217_092d,
    0x870d_07a2,
    0x71cf_5cdb,
    0xff2b_8009,
    0x3dbf_c033,
    0x8b73_e000,
    0x97db_3012,
    0xf220_9820,
    0xd173_8c2c,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0xf000_0000,
    0x8800_0000,
    0x8400_0000,
    0xaa00_0000,
    0x4100_0000,
    0x9480_0000,
    0x8ec0_0000,
    0x8c60_0000,
    0xab70_0000,
    0xb2f8_0000,
    0xa434_0000,
    0x36de_0000,
    0xe0e1_0000,
    0xe9b1_8000,
    0xb099_4000,
    0x1447_a000,
    0xd9a7_1000,
    0xda93_2800,
    0x77ce_7400,
    0x366e_3e00,
    0x70fe_e700,
    0xf133_7d80,
    0xd05f_7cc0,
    0xd326_1e20,
    0x5751_b730,
    0xfa2e_75a8,
    0x555b_58fc,
    0x8da2_a802,
    0xc897_3411,
    0x9ac9_9e02,
    0x7ce9_f72c,
    0x9d38_5587,
    0x2cd5_08c2,
    0xcb6e_2029,
    0x227a_500a,
    0x40f2_8821,
    0x5bbc_6436,
    0x2f12_960c,
    0x5d88_d333,
    0x1ccb_63bc,
    0x23ef_cbd5,
    0xcab9_eb8d,
    0x0393_afdd,
    0x7f4b_7da7,
    0x4eab_7cd7,
    0xeb98_1e0e,
    0x29c0_b72e,
    0x17e7_f5a7,
    0x0a36_18dc,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0xb000_0000,
    0xd800_0000,
    0x3c00_0000,
    0x4a00_0000,
    0xeb00_0000,
    0xcf80_0000,
    0x4940_0000,
    0xb3e0_0000,
    0xab30_0000,
    0x8258_0000,
    0xe2f4_0000,
    0x217a_0000,
    0x0261_0000,
    0xf777_8000,
    0xab3b_c000,
    0x3a00_6000,
    0xd306_9000,
    0xe383_b800,
    0x6b41_ac00,
    0xbce3_d200,
    0x12b2_0300,
    0x6a1d_4380,
    0x7592_d5c0,
    0x0c8e_3220,
    0x7a9e_5310,
    0x0d51_1ba8,
    0xa32a_29ec,
    0x58cc_3816,
    0xe7fe_6c1f,
    0x6ba1_b23a,
    0xa451_9316,
    0x33ab_7b85,
    0x600d_b9dd,
    0xe858_001e,
    0xf9f4_0000,
    0x96fa_003b,
    0xc721_0006,
    0xd697_8012,
    0xd70b_c025,
    0x3dd8_600f,
    0x93b2_9028,
    0xbe99_b835,
    0x8b50_ac26,
    0x7a2c_5229,
    0xf04d_c31a,
    0xf33f_2381,
    0x4601_45c8,
    0x3900_0a0a,
    0xb885_3f17,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x7000_0000,
    0x0800_0000,
    0xdc00_0000,
    0x8e00_0000,
    0x2300_0000,
    0x9980_0000,
    0x02c0_0000,
    0x3220_0000,
    0x7590_0000,
    0x1d28_0000,
    0xbbd4_0000,
    0x834e_0000,
    0xd523_0000,
    0x0615_8000,
    0x86ef_4000,
    0x1171_6000,
    0xc89a_3000,
    0x9e6c_f800,
    0xef31_3c00,
    0x7ef8_4e00,
    0xbc9b_3d00,
    0x9c6e_0a80,
    0xda33_c040,
    0x607a_ae20,
    0x7dd9_4d30,
    0xdd88_12b8,
    0xa904_8c5c,
    0xb082_f822,
    0x7242_3c07,
    0xa065_ce1b,
    0xa5f0_7d14,
    0xb0d9_6aa4,
    0xd70e_f077,
    0xda45_d60f,
    0x2c60_3125,
    0xb3f2_bc99,
    0x37dd_c172,
    0x148a_ea8e,
    0xa986_b06f,
    0x2ac7_363d,
    0x7e22_412b,
    0x8394_a4b8,
    0xea2a_8d6c,
    0x7052_bcab,
    0x2c8d_c148,
    0x5d82_ea81,
    0xe8c2_b057,
    0xab21_3610,
    0xed15_413e,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0xb000_0000,
    0xa800_0000,
    0x9400_0000,
    0x0600_0000,
    0xb100_0000,
    0x3b80_0000,
    0x54c0_0000,
    0x45e0_0000,
    0xf970_0000,
    0x6b68_0000,
    0x1534_0000,
    0x86ce_0000,
    0xffe5_0000,
    0x1a73_8000,
    0xc7ec_4000,
    0x7b75_2000,
    0x046b_7000,
    0x83b4_2800,
    0xcb8a_6c00,
    0xf1c7_6e00,
    0xb864_d300,
    0x3cb1_1d80,
    0xa50d_dc40,
    0x1087_ce20,
    0x3c42_e330,
    0x15a5_9588,
    0x46d1_806c,
    0x16bc_280a,
    0xb30e_6c15,
    0x7981_6e09,
    0x1bc5_d300,
    0x6364_9da4,
    0x1c30_9c70,
    0xf14f_6e30,
    0xb120_d322,
    0xcc97_1d9c,
    0x1a1c_dc7c,
    0x5a5a_4e3a,
    0x3dfb_a314,
    0x5c2b_3595,
    0xd812_b074,
    0x385b_203b,
    0xc2fe_703e,
    0xd2af_a83e,
    0xa952_2c3d,
    0xa47c_4e1c,
    0xd7ea_a31a,
    0xa376_b59e,
    0x186b_f076,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x9000_0000,
    0x8800_0000,
    0x4400_0000,
    0xc200_0000,
    0x7700_0000,
    0x9680_0000,
    0x2a40_0000,
    0x13a0_0000,
    0xcc30_0000,
    0x46a8_0000,
    0x79f4_0000,
    0xc0ce_0000,
    0x03a7_0000,
    0x8432_8000,
    0x62af_4000,
    0x2bf2_a000,
    0x3fcc_5000,
    0xd126_9800,
    0x6c70_2400,
    0x060d_aa00,
    0x7146_8900,
    0x5323_6380,
    0xbb70_3040,
    0x608b_8a20,
    0x4306_9930,
    0x8c83_db98,
    0xf140_0464,
    0x9326_9802,
    0xdb70_2421,
    0xf08d_aa28,
    0xcb06_8939,
    0xc883_6387,
    0x3340_305b,
    0xe423_8a14,
    0x4df2_991e,
    0xdacd_dbac,
    0xd8a7_0470,
    0x04b4_1836,
    0x75ef_6412,
    0x9dd7_0a18,
    0x8d3e_d93f,
    0xd96b_fbbd,
    0x5c97_1454,
    0x661c_a001,
    0x5e1b_501d,
    0xa21c_1827,
    0x5c1b_6423,
    0xb519_0a36,
    0x5a99_d917,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x9000_0000,
    0xe800_0000,
    0x0c00_0000,
    0xde00_0000,
    0x6500_0000,
    0xb180_0000,
    0xd940_0000,
    0x2ee0_0000,
    0xa310_0000,
    0xe688_0000,
    0x3df4_0000,
    0x9d9e_0000,
    0xcf7f_0000,
    0x0a6e_8000,
    0x0de6_4000,
    0xc391_e000,
    0xd44e_3000,
    0xed54_8800,
    0xf2ea_5c00,
    0x8b24_7200,
    0x4933_a300,
    0x9c39_3680,
    0x4b8d_e540,
    0xb070_fa20,
    0x82d9_ff30,
    0xf09d_4498,
    0x22fe_4664,
    0x8529_cc9a,
    0xda04_1a73,
    0xe705_be8f,
    0x8283_b94d,
    0x91c2_882e,
    0x7021_5c21,
    0x3db4_f21e,
    0x04fa_e316,
    0xc42e_5698,
    0xd981_9563,
    0x1543_9217,
    0x90e6_9304,
    0x5615_3e84,
    0xbf0a_f976,
    0xe8b5_e83f,
    0x6d7d_2c12,
    0x096f_9a08,
    0x5d61_8f3e,
    0xe950_2ca1,
    0x70ee_2a62,
    0xb827_36b2,
    0x01b2_e559,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x9000_0000,
    0x3800_0000,
    0x5400_0000,
    0xf600_0000,
    0x6300_0000,
    0xab80_0000,
    0xad40_0000,
    0xf0e0_0000,
    0x6450_0000,
    0x99d8_0000,
    0x40b4_0000,
    0xcb8e_0000,
    0x1a69_0000,
    0xb0be_8000,
    0x44a6_c000,
    0x0e35_2000,
    0x664f_f000,
    0xb048_f800,
    0x834b_8c00,
    0xb0cc_6200,
    0xd98d_f300,
    0xe76a_4c80,
    0xb43b_9fc0,
    0x7064_9a20,
    0xfe96_7f30,
    0x6e7e_2ea8,
    0xbd02_6ce4,
    0x6480_d6ae,
    0x04c4_e0e5,
    0x58a4_34b5,
    0x6432_d3cc,
    0xaf4b_d82c,
    0x72c9_7c2a,
    0x7c8c_1a27,
    0x87ed_bf30,
    0xdefb_8ebf,
    0x8fc2_5cf6,
    0xff23_8eb9,
    0x5b76_5cdc,
    0x62ad_8e94,
    0xb21f_5ce7,
    0x4193_0ead,
    0x0ff9_9cd7,
    0x4946_2eaf,
    0x6ee6_6cfe,
    0xcb56_d6a0,
    0x0059_e0ca,
    0x40f4_b497,
    0xa7ed_13ee,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x5000_0000,
    0x6800_0000,
    0x7c00_0000,
    0xc600_0000,
    0x1100_0000,
    0x2580_0000,
    0x6040_0000,
    0xc060_0000,
    0x6110_0000,
    0xdd28_0000,
    0x4d74_0000,
    0x323a_0000,
    0xcd5f_0000,
    0xa4cc_8000,
    0x9a26_4000,
    0x3670_6000,
    0xe8bc_f000,
    0x859e_a800,
    0xb769_bc00,
    0x2213_5a00,
    0x13aa_1700,
    0xbfb7_6e80,
    0xf69a_e440,
    0x41ed_f220,
    0xc4d3_ab10,
    0x6d0c_3498,
    0xe404_f354,
    0xa200_9cba,
    0xf306_4f4f,
    0xb685_4689,
    0x86c5_1840,
    0x2ea6_c82b,
    0x33b1_4c03,
    0x289f_f203,
    0x74e8_ab17,
    0x6352_b495,
    0xce49_b350,
    0xaae6_7ca4,
    0x51d3_ff67,
    0xba8f_0e9f,
    0x1f42_1471,
    0xa8e1_5a24,
    0xd2d1_1719,
    0x5409_ee80,
    0xdd87_a464,
    0x5443_1222,
    0x4a62_1b38,
    0x8e14_7cba,
    0xfda8_ff5c,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x5000_0000,
    0xf800_0000,
    0x8c00_0000,
    0xd600_0000,
    0x0b00_0000,
    0xcb80_0000,
    0xfec0_0000,
    0xa4a0_0000,
    0xe090_0000,
    0xe118_0000,
    0x7834_0000,
    0xbf8e_0000,
    0x862f_0000,
    0x0638_8000,
    0xe266_c000,
    0x6833_e000,
    0xe788_f000,
    0x3a2d_7800,
    0x7839_4c00,
    0x9d64_7e00,
    0xf9b2_1100,
    0xc448_b680,
    0x5e0e_a7c0,
    0xade9_0620,
    0x261b_5d30,
    0xc5b4_c898,
    0x7a48_b6d4,
    0x410f_b09e,
    0x6c6a_fad3,
    0xfddd_4e8d,
    0x2d91_2be6,
    0x799e_9834,
    0xf171_bc38,
    0x9be9_063a,
    0xbd1b_5d0d,
    0x9634_c881,
    0x5888_b6c0,
    0xcbaf_b0a1,
    0x0bfa_fad4,
    0x0145_4e9a,
    0xa065_2bc5,
    0xa930_9822,
    0x690e_bc39,
    0xd869_860b,
    0xc7d9_9d2c,
    0xa091_28aa,
    0x411b_46c0,
    0x4834_48aa,
    0x178a_76fd,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0xd000_0000,
    0x8800_0000,
    0x8400_0000,
    0xc600_0000,
    0xf500_0000,
    0xc880_0000,
    0xef40_0000,
    0x13a0_0000,
    0x79d0_0000,
    0x3118_0000,
    0x9674_0000,
    0xf2ce_0000,
    0x286f_0000,
    0x433c_8000,
    0xc265_4000,
    0xe837_a000,
    0xffef_f000,
    0xa3fd_4800,
    0xfd02_1400,
    0x8c87_c200,
    0x4942_c100,
    0x36a7_9880,
    0x3950_4bc0,
    0x5a5a_8a20,
    0x43d0_d530,
    0x7e18_5a98,
    0xd1f6_8af4,
    0x3a0b_1282,
    0x230b_9ed1,
    0xb988_5089,
    0x8dc8_1ff9,
    0xf7ee_6828,
    0xe7fc_a41e,
    0x5b03_2a0f,
    0xa980_2536,
    0x09c1_92ad,
    0x5de5_dec2,
    0xecf5_709b,
    0xd689_afe2,
    0xba4e_0012,
    0x072f_0034,
    0x309c_8034,
    0x6bb5_401b,
    0x512f_a01b,
    0xed9b_f03c,
    0x9733_4836,
    0x206d_1411,
    0x073b_4239,
    0x6467_811b,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0xb000_0000,
    0xd800_0000,
    0x3c00_0000,
    0x1600_0000,
    0x6d00_0000,
    0xd680_0000,
    0x4cc0_0000,
    0xeee0_0000,
    0xa8d0_0000,
    0x1ae8_0000,
    0xd034_0000,
    0x1f3e_0000,
    0x3c5d_0000,
    0x33cf_8000,
    0x1585_c000,
    0x9b43_6000,
    0x2aa2_f000,
    0x33f1_c800,
    0x7859_2400,
    0x69cc_5e00,
    0x9680_1b00,
    0xacc5_fc80,
    0x7ee7_f240,
    0xc0d5_9620,
    0xfeed_3f30,
    0xfa37_a288,
    0x643a_e96c,
    0x87df_ea96,
    0xa98f_0d7f,
    0xb7a1_54ad,
    0xdd75_2647,
    0x9899_802b,
    0xf92c_c000,
    0xb752_e000,
    0x4aaa_3012,
    0x9915_2800,
    0x8a8a_1433,
    0xf020_f60c,
    0x7136_cf2d,
    0xe7bf_ea84,
    0xb19f_0d48,
    0x75a9_54bc,
    0x7891_266b,
    0x93cf_8029,
    0x6585_c03c,
    0x6343_6009,
    0xa6a2_f006,
    0xfdf1_c83e,
    0x2959_241a,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0xd000_0000,
    0x6800_0000,
    0x8c00_0000,
    0x6e00_0000,
    0xff00_0000,
    0x9b80_0000,
    0xef40_0000,
    0xe160_0000,
    0xa710_0000,
    0xa258_0000,
    0xd874_0000,
    0x024a_0000,
    0xa5a9_0000,
    0x0778_8000,
    0xbf80_4000,
    0xed45_e000,
    0x0063_b000,
    0x7b96_5800,
    0x3298_8c00,
    0x3453_9200,
    0xd53d_5f00,
    0xc460_6680,
    0x0995_3fc0,
    0x6b9d_ca20,
    0x0cd1_d310,
    0xa7f9_f4a8,
    0xb941_60f4,
    0xba65_2cba,
    0x7e94_acf3,
    0x0c19_de93,
    0x3597_03db,
    0x5d98_8034,
    0x67d0_403c,
    0x667d_e011,
    0x2307_b001,
    0xdd84_580f,
    0x3c45_8c11,
    0xc4e1_1205,
    0xdf54_1f04,
    0x54bd_06b7,
    0xfe26_cfcb,
    0xbe76_720b,
    0x414e_ef26,
    0x482e_3e9f,
    0x2339_b3c8,
    0x4f64_580d,
    0xb815_8c00,
    0x49d9_1226,
    0x8f30_1f2a,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xb000_0000,
    0x9800_0000,
    0x0c00_0000,
    0xb200_0000,
    0x2500_0000,
    0x6980_0000,
    0xc3c0_0000,
    0xa960_0000,
    0xdef0_0000,
    0xdef8_0000,
    0xd194_0000,
    0xdb0a_0000,
    0xd1ed_0000,
    0x35db_8000,
    0x91c3_c000,
    0x5c66_e000,
    0xbf75_d000,
    0x3938_0800,
    0x5ef6_7c00,
    0x9ef8_c600,
    0xf197_bf00,
    0x6b0d_0d80,
    0x49ef_2ec0,
    0x39d8_ce20,
    0x23c5_c310,
    0x7967_cb88,
    0xd6f1_91ec,
    0xfafc_4386,
    0xf790_2dd3,
    0x4008_6584,
    0x2f6f_42f5,
    0xba9e_e014,
    0x92e1_d00f,
    0xe832_0828,
    0x161b_7c11,
    0xe8a3_4627,
    0x8a94_7f0e,
    0x458b_edaa,
    0xceaa_fefa,
    0x1ef8_c62a,
    0xb197_bf07,
    0x4b0d_0db4,
    0xf9ef_2ef4,
    0xa1d8_ce04,
    0x2fc5_c320,
    0xcb67_cbaf,
    0xf3f1_91e6,
    0x937c_4392,
    0x3450_2ded,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x5000_0000,
    0xa800_0000,
    0xc400_0000,
    0x9e00_0000,
    0x1100_0000,
    0xfe80_0000,
    0x52c0_0000,
    0x16e0_0000,
    0xef70_0000,
    0x1ab8_0000,
    0x7894_0000,
    0x434a_0000,
    0x04e9_0000,
    0x4b3c_8000,
    0xd5d6_4000,
    0xf1eb_a000,
    0x3bba_3000,
    0x9e17_6800,
    0x8d8f_6400,
    0xb00b_4e00,
    0x474a_fb00,
    0x7aea_f180,
    0xaa3e_50c0,
    0xd356_2620,
    0xcf2c_9f10,
    0x775d_3fa8,
    0xfe62_ebd4,
    0x78b7_778a,
    0x64d8_ffe1,
    0x4024_71af,
    0x8795_10c0,
    0x14cb_061d,
    0x64a9_ef21,
    0x051d_77a0,
    0x0b41_ffda,
    0x2fa0_f194,
    0x6bd7_50ef,
    0xf0ea_a605,
    0xcd3a_df2e,
    0x58d6_9fac,
    0xad68_dbe1,
    0x8a78_1f82,
    0x3d73_9bcf,
    0x41bd_3fb3,
    0x0112_ebdd,
    0x6a0f_778a,
    0x884c_fff1,
    0x356e_7191,
    0x567c_10e6,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x5000_0000,
    0xe800_0000,
    0x4c00_0000,
    0xaa00_0000,
    0x6d00_0000,
    0x3480_0000,
    0x82c0_0000,
    0x69a0_0000,
    0xd390_0000,
    0xe9a8_0000,
    0xe734_0000,
    0x76be_0000,
    0xc85b_0000,
    0x4e28_8000,
    0x4272_4000,
    0x7a59_e000,
    0xf72b_9000,
    0xc8f6_c800,
    0xcb98_d400,
    0xc909_ce00,
    0x2623_1100,
    0x3ad4_6680,
    0x4f4b_0240,
    0xb541_0620,
    0xc4e0_c530,
    0xc375_28b8,
    0x94da_5354,
    0x40ec_809a,
    0x61d0_5763,
    0x94ca_e6b2,
    0xc206_427f,
    0xe106_662f,
    0x7e86_1517,
    0xbfc4_80b2,
    0xb524_5768,
    0x1d54_e687,
    0x2a0d_4261,
    0x59a6_e638,
    0xab90_5519,
    0xadab_60bc,
    0x5130_c77a,
    0x59bc_ae93,
    0xddd8_d67a,
    0x5268_4839,
    0xc415_9436,
    0xf4ee_ae37,
    0x4fd5_c105,
    0xafcd_ce81,
    0x8981_0649,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x7000_0000,
    0xc800_0000,
    0x4400_0000,
    0xfa00_0000,
    0x8300_0000,
    0x1a80_0000,
    0xbd40_0000,
    0x1fa0_0000,
    0xbad0_0000,
    0x5bd8_0000,
    0x4e74_0000,
    0x8f8a_0000,
    0xbaed_0000,
    0x695d_8000,
    0xa731_4000,
    0xf22a_a000,
    0x7f3f_1000,
    0x5e05_f800,
    0x6900_6400,
    0x0186_8200,
    0x5bc6_2100,
    0xd4e0_9080,
    0x9872_edc0,
    0x8289_7a20,
    0x316b_4510,
    0x799b_9288,
    0x2d55_8cdc,
    0x2d1b_4a92,
    0x6112_b8c1,
    0xcf3d_1096,
    0xf603_adec,
    0x7d03_da1c,
    0x4384_5532,
    0x54c6_6a83,
    0x7061_e8c3,
    0x5c37_c8bc,
    0x04a9_99dd,
    0x2c78_0034,
    0x80a4_0003,
    0xc652_0037,
    0x4399_0036,
    0xce57_8002,
    0x679c_403d,
    0x6457_2000,
    0x5c9e_5001,
    0xf2d7_5804,
    0x5fdb_740f,
    0x9471_7a15,
    0x7c8f_4537,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x9000_0000,
    0x9800_0000,
    0x5c00_0000,
    0xd200_0000,
    0x2700_0000,
    0xaf80_0000,
    0xa940_0000,
    0x1a60_0000,
    0x1910_0000,
    0xfd38_0000,
    0x3874_0000,
    0x39ae_0000,
    0xbb0f_0000,
    0xbc3e_8000,
    0xf6f5_c000,
    0x6e6b_6000,
    0x9ea9_d000,
    0xd489_9800,
    0x757c_cc00,
    0x7c95_8200,
    0xef7f_4700,
    0x3f94_6680,
    0x3efd_3cc0,
    0x6bd2_1a20,
    0x681c_8b30,
    0xfa07_6498,
    0xd303_bbe4,
    0x4983_1c86,
    0x0847_67e7,
    0x84e2_668c,
    0xb6d6_3cdd,
    0x149a_9a35,
    0x1ac2_4b29,
    0xc124_848c,
    0xd474_abfc,
    0x43a9_64a6,
    0xa80c_bbca,
    0x95bd_9caf,
    0x6eb2_a7df,
    0x7289_06a3,
    0x747f_ecdc,
    0x1213_0206,
    0x48be_870b,
    0x1231_068a,
    0x924b_ecd0,
    0x665d_023a,
    0x8fe1_870d,
    0x0357_86b0,
    0x3eda_2cc7,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x1000_0000,
    0x2800_0000,
    0x2c00_0000,
    0x2200_0000,
    0x0300_0000,
    0xca80_0000,
    0x7540_0000,
    0xc420_0000,
    0xb310_0000,
    0x61e8_0000,
    0xa834_0000,
    0x627e_0000,
    0x0b99_0000,
    0xf2ea_8000,
    0x8ab6_4000,
    0x9b3a_e000,
    0xfdb9_d000,
    0x6afa_b800,
    0x0dd8_6400,
    0x644c_4200,
    0x58e7_bd00,
    0x18f3_de80,
    0xeb9c_6040,
    0x82e8_fa20,
    0x12b6_d930,
    0x8f3d_1ca8,
    0xdbb9_9d44,
    0x67ff_c4aa,
    0xe65a_697b,
    0xd88d_de80,
    0x2305_6074,
    0x1a82_7a30,
    0xfd40_9922,
    0xf827_fc9b,
    0xb910_4d63,
    0x4eed_7c88,
    0x40b6_0d4c,
    0x143f_9c9b,
    0x053b_dd47,
    0x34bb_24a5,
    0x2f7a_b946,
    0x801d_e69d,
    0xfe2b_4444,
    0xc954_d81e,
    0x9d4e_f42b,
    0xe566_9a32,
    0x3130_4937,
    0x6fff_c49f,
    0x1a5a_6974,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0xd000_0000,
    0x7800_0000,
    0x1400_0000,
    0xea00_0000,
    0xb300_0000,
    0x4580_0000,
    0x2440_0000,
    0x3ba0_0000,
    0x4710_0000,
    0x4f48_0000,
    0x93b4_0000,
    0x5bda_0000,
    0xadbf_0000,
    0x2b48_8000,
    0xf1b6_c000,
    0x34df_2000,
    0xbe3d_1000,
    0x3a0e_7800,
    0xc293_1c00,
    0x4b0c_ca00,
    0x1813_7900,
    0xb4cb_4e80,
    0x8ef3_9940,
    0x46f8_b220,
    0xf36f_6510,
    0x6fe7_0498,
    0xf4b2_2074,
    0xd45e_dcbe,
    0x8afa_ec55,
    0xfd6b_4e82,
    0xfee3_9948,
    0xbe30_b237,
    0x339b_6528,
    0xd81d_04b2,
    0x9d5d_204c,
    0x247e_5c86,
    0x38a8_2c54,
    0xa306_6e8b,
    0x1d85_897b,
    0x8044_4a20,
    0x79a5_b921,
    0x9814_6eba,
    0xf4ce_896c,
    0xeef6_ca14,
    0x96fc_7933,
    0x8b6b_cebe,
    0x7be1_597e,
    0x1eb5_9216,
    0x6759_7529,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x9000_0000,
    0x2800_0000,
    0x5400_0000,
    0x1200_0000,
    0x5d00_0000,
    0x6980_0000,
    0xf0c0_0000,
    0x96e0_0000,
    0xd0f0_0000,
    0x9978_0000,
    0x6914_0000,
    0xad0a_0000,
    0xa12b_0000,
    0x663a_8000,
    0x7030_4000,
    0x879b_2000,
    0x9de6_5000,
    0x9e77_8800,
    0xe93f_3c00,
    0xe4b7_de00,
    0x6ede_c300,
    0x43c1_0580,
    0xa462_a6c0,
    0xe6b2_5620,
    0x5bde_ff10,
    0x9e46_5bb8,
    0xd6a7_25e4,
    0x0552_f3aa,
    0xb6aa_49c5,
    0xe5f8_a59c,
    0x7450_b6e3,
    0x112c_fe08,
    0x7e38_931d,
    0x7c36_8d93,
    0x799d_9ad2,
    0xaee5_8812,
    0xecf0_3c34,
    0x3f7f_5e28,
    0xb611_8313,
    0xb18a_a58a,
    0x6c6f_b6db,
    0x121c_7e2d,
    0x6b23_d326,
    0xa797_2d91,
    0x9d4b_8acc,
    0xcc89_2025,
    0x35e9_5039,
    0xbadf_0815,
    0x11c0_7c01,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x9000_0000,
    0x6800_0000,
    0xac00_0000,
    0x2200_0000,
    0x3500_0000,
    0x2880_0000,
    0xc640_0000,
    0xc460_0000,
    0x9db0_0000,
    0x7318_0000,
    0xa6d4_0000,
    0x1f2a_0000,
    0x390d_0000,
    0x1eda_8000,
    0x3f74_4000,
    0xa33a_e000,
    0x1203_d000,
    0x8d01_0800,
    0xcc87_7400,
    0xd847_6a00,
    0xbb64_9f00,
    0x2c37_5380,
    0xbfdb_ddc0,
    0x91f4_6220,
    0x6e7a_eb10,
    0x11e0_b988,
    0x0f76_02e4,
    0x1b3b_51ba,
    0xf602_a6fb,
    0x9305_33a0,
    0xb385_4df9,
    0x69c7_0a38,
    0x77a3_0f2e,
    0x1b14_bbab,
    0xce8b_79e5,
    0xb918_0024,
    0x7fd4_002e,
    0x35aa_003c,
    0x5a4d_0031,
    0x9a3a_803a,
    0xc884_401b,
    0x3642_e00a,
    0x1c67_d009,
    0xc9b3_0835,
    0x951e_742a,
    0x1dd7_ea2f,
    0x20ad_df0c,
    0xe2cf_339b,
    0x3478_4dfe,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0xd000_0000,
    0xc800_0000,
    0x5400_0000,
    0x0a00_0000,
    0x3b00_0000,
    0xf480_0000,
    0xf6c0_0000,
    0xf2a0_0000,
    0x0ab0_0000,
    0xbbc8_0000,
    0x2114_0000,
    0x5afe_0000,
    0xea9f_0000,
    0x088c_8000,
    0x2af7_4000,
    0xc0a9_2000,
    0x8f87_9000,
    0xa245_b800,
    0xb460_1400,
    0xe012_1e00,
    0x2d7f_f900,
    0xc4df_3f80,
    0x4ae8_0940,
    0x7fe1_a620,
    0xe054_ed30,
    0x261f_a198,
    0x124f_b074,
    0xfe53_3992,
    0xb718_3465,
    0x6dcc_9fba,
    0xe413_d94a,
    0x2f7f_be37,
    0xcbdb_292c,
    0x646d_a794,
    0x7a20_8d6d,
    0xb272_8003,
    0xd068_401e,
    0x6025_a00d,
    0x2170_d03f,
    0xa0ec_981f,
    0x54e7_8428,
    0xbcd7_a636,
    0x54df_ed1d,
    0x22ed_21af,
    0x9be7_f068,
    0xf256_9980,
    0x8118_e46a,
    0xb8c8_07bd,
    0x3990_5d5a,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x7000_0000,
    0x0800_0000,
    0x9c00_0000,
    0xb200_0000,
    0xab00_0000,
    0xc980_0000,
    0x74c0_0000,
    0xdce0_0000,
    0xd5f0_0000,
    0x5738_0000,
    0x0c14_0000,
    0x924e_0000,
    0x2d6f_0000,
    0x8ff9_8000,
    0xcaf1_4000,
    0x60ba_6000,
    0x79d1_5000,
    0xc82c_7800,
    0x63d8_7c00,
    0xf5e6_0e00,
    0x1f75_2300,
    0x667a_7d80,
    0x6e33_e4c0,
    0xa45c_7620,
    0x4826_5f30,
    0xb913_f398,
    0xeacc_87dc,
    0xb72b_eba2,
    0x245a_abd7,
    0x8820_1d94,
    0xd912_b4c6,
    0x9ac8_0e08,
    0xbf2a_2316,
    0xb85b_fd81,
    0x3a26_a4e4,
    0x7210_1629,
    0x534c_0f23,
    0xcbe8_0b95,
    0x64ba_bbd5,
    0xefd6_0591,
    0x252b_98ce,
    0x5f5a_780a,
    0x59a3_7c25,
    0x49d1_8e08,
    0x602b_6304,
    0xefd9_9dbb,
    0x3fe3_f4d8,
    0x2072_6e3b,
    0x81fb_732b,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x9000_0000,
    0x9800_0000,
    0xc400_0000,
    0xb600_0000,
    0x7d00_0000,
    0x5180_0000,
    0xfd40_0000,
    0x0b20_0000,
    0xb210_0000,
    0xd408_0000,
    0x1634_0000,
    0x4c9a_0000,
    0x7bff_0000,
    0x314a_8000,
    0x9911_c000,
    0x288b_a000,
    0x42f2_f000,
    0xeeff_8800,
    0xecca_dc00,
    0xee55_1200,
    0xbca9_4d00,
    0xf266_be80,
    0x2f34_6f40,
    0xeb18_9a20,
    0x9bb8_9110,
    0xfbeb_2c98,
    0x4e47_e264,
    0x33a5_0486,
    0x50d0_ce61,
    0x0b6d_1e95,
    0xd086_9f6b,
    0x6ec7_120a,
    0x5562_4d3a,
    0x59b6_3e91,
    0x20da_af66,
    0x3b59_ba0a,
    0x791b_a104,
    0x80bf_04b0,
    0x2f6f_ce76,
    0xb687_9ea9,
    0xebc7_5f51,
    0x50e4_b23b,
    0x8af4_bd0c,
    0x92fb_b6bb,
    0x6ecb_736c,
    0x2d54_2807,
    0xcc28_2c15,
    0x2ca2_9a15,
    0x1257_9107,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x9000_0000,
    0x4800_0000,
    0x2c00_0000,
    0x1e00_0000,
    0xf100_0000,
    0x1580_0000,
    0x4a40_0000,
    0xd6e0_0000,
    0x6050_0000,
    0x38e8_0000,
    0x25b4_0000,
    0x0a3a_0000,
    0xaf99_0000,
    0x60aa_8000,
    0xcc51_4000,
    0x66ea_e000,
    0x74b7_3000,
    0x8fba_2800,
    0xadda_7c00,
    0x9a4e_ca00,
    0xb200_2300,
    0xaf04_9480,
    0x4486_be40,
    0xcfc6_e220,
    0xd4a7_5f10,
    0x9ab2_dea8,
    0x46ba_dd64,
    0xec58_16b2,
    0x3a0e_915b,
    0xefe6_748f,
    0x19d5_8e48,
    0xccae_ca1f,
    0x9250_232d,
    0x37ec_9488,
    0xf132_be4b,
    0x8dfc_e23e,
    0x573e_5f3c,
    0xe418_5e9d,
    0x7beb_9d79,
    0x9f32_f694,
    0x04f9_a16b,
    0xb6bc_5caf,
    0xd45f_f26f,
    0x6e08_0028,
    0x05e4_0017,
    0x92d2_002d,
    0x1a2d_0022,
    0x2290_8017,
    0x4fc8_4038,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0xf000_0000,
    0xe800_0000,
    0x5c00_0000,
    0xce00_0000,
    0xef00_0000,
    0x5f80_0000,
    0x0840_0000,
    0x8260_0000,
    0xe410_0000,
    0xcd98_0000,
    0xa9f4_0000,
    0xf9ce_0000,
    0xb20b_0000,
    0xd62d_8000,
    0x4f5a_4000,
    0x2150_6000,
    0xf97f_b000,
    0xb926_5800,
    0x37f0_ac00,
    0x2ecb_ea00,
    0x498e_8700,
    0x5469_d680,
    0x5838_59c0,
    0xe7c0_3220,
    0x4224_6b30,
    0x2a72_5cb8,
    0xff89_6efc,
    0x3f6f_bc9a,
    0x9dbc_9ee7,
    0x6281_84ab,
    0x56c7_82f7,
    0x2aa2_36b5,
    0x29b2_a9d9,
    0x17ad_8a31,
    0x901e_3719,
    0x58b4_0e95,
    0x9f2d_b5f8,
    0x63d8_3820,
    0x5894_1c0b,
    0x6c58_323a,
    0x68d0_6b05,
    0x4a3c_5c88,
    0x06c2_6ed4,
    0x12a2_3ca5,
    0x8db6_deea,
    0x9da9_e4b4,
    0x051c_32f7,
    0x7a32_6eba,
    0xe9ed_05f8,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x9000_0000,
    0xa800_0000,
    0xcc00_0000,
    0xf600_0000,
    0x3700_0000,
    0x6f80_0000,
    0xa140_0000,
    0xb6e0_0000,
    0xfb50_0000,
    0xb818_0000,
    0x9a34_0000,
    0x460e_0000,
    0xcecf_0000,
    0x766e_8000,
    0xc05c_4000,
    0x2053_e000,
    0x119b_7000,
    0x5471_1800,
    0x6b6d_6c00,
    0x06df_2200,
    0x7590_2300,
    0x0fbf_e480,
    0x2782_59c0,
    0x3d40_ba20,
    0x88e1_0f30,
    0x9053_2698,
    0x8999_0ae4,
    0xc076_468a,
    0x696a_3ac3,
    0xa3da_be85,
    0x1713_26d9,
    0x007a_0489,
    0x68a2_29cf,
    0xbe31_2202,
    0xdc0f_2314,
    0xffc9_64ba,
    0x16ea_19d4,
    0x6a9d_5a10,
    0x0df5_7f2b,
    0x9d2c_bea0,
    0x4fb8_26e9,
    0x8782_848b,
    0xcd45_69c4,
    0xb0e2_421f,
    0xf457_1318,
    0xb39d_1c82,
    0x0174_45c3,
    0x31ee_8008,
    0x6d1c_4024,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x7000_0000,
    0x1800_0000,
    0xa400_0000,
    0x3600_0000,
    0xeb00_0000,
    0xc380_0000,
    0x4bc0_0000,
    0xfca0_0000,
    0xc730_0000,
    0xedb8_0000,
    0xac14_0000,
    0x0f4a_0000,
    0x5209_0000,
    0xe1ed_8000,
    0x083b_c000,
    0x84d5_a000,
    0x5c6d_f000,
    0x24f8_3800,
    0x91f7_cc00,
    0xd99e_5600,
    0x3360_b100,
    0x3d95_d380,
    0x798b_72c0,
    0x562b_ee20,
    0xc69c_bd10,
    0xeee6_25a8,
    0x8152_33dc,
    0xa4ac_05a6,
    0x1fd9_03f9,
    0x5b06_1d85,
    0x3b81_fff6,
    0x3fc0_53be,
    0xa2a4_b2f7,
    0x9034_4e3c,
    0xbc38_4d2e,
    0x3ad3_9da8,
    0xdb6e_3ff6,
    0x1d7f_f3a7,
    0xbb30_42f4,
    0x9fb9_f609,
    0xa110_413c,
    0x4fca_6bb8,
    0x664e_7efe,
    0xc48d_981d,
    0xeeaa_3c2b,
    0x86de_6e02,
    0x9583_7d12,
    0x30c1_8595,
    0xf722_c3f1,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x9000_0000,
    0x2800_0000,
    0xc400_0000,
    0x6200_0000,
    0x1d00_0000,
    0xbc80_0000,
    0x3ec0_0000,
    0xebe0_0000,
    0x3f90_0000,
    0x28a8_0000,
    0xdcf4_0000,
    0x93fa_0000,
    0x5ebd_0000,
    0xd21a_8000,
    0x482e_4000,
    0xbc35_a000,
    0xcb1d_d000,
    0xf6ae_0800,
    0x2ff3_1400,
    0x247e_6e00,
    0x1bfe_e300,
    0x4abd_d680,
    0xb81a_8040,
    0x012a_e620,
    0x4ab3_b710,
    0x2cde_1888,
    0xc3cd_b364,
    0x33a3_38aa,
    0x5bb7_2361,
    0xc658_10b0,
    0x1a0a_a773,
    0x05c7_568d,
    0x6864_c04a,
    0x80d7_4600,
    0xd10a_670d,
    0x1e42_10bf,
    0xab27_a76a,
    0xf775_d683,
    0xa8be_8071,
    0xe518_e61b,
    0x9daa_b716,
    0xe476_9896,
    0xef3a_f347,
    0x385e_18af,
    0x790d_b350,
    0x9a43_38a3,
    0xe927_237a,
    0x7a70_10a7,
    0x3c3e_a757,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x3000_0000,
    0x6800_0000,
    0xa400_0000,
    0x3600_0000,
    0x2f00_0000,
    0x6f80_0000,
    0x05c0_0000,
    0x40a0_0000,
    0xc9b0_0000,
    0xd258_0000,
    0x8a94_0000,
    0x9c2a_0000,
    0x396f_0000,
    0x638f_8000,
    0xe75e_4000,
    0x2811_a000,
    0xe76a_7000,
    0xa889_9800,
    0xdedb_2c00,
    0x32d3_8600,
    0xa04c_1100,
    0xc0f8_1780,
    0x7a27_5dc0,
    0x5ef5_9e20,
    0x81b9_7d10,
    0x76c2_3198,
    0xc525_3ccc,
    0x4976_11ba,
    0x187e_0cf9,
    0xfc61_a9b5,
    0xd991_10d7,
    0x49aa_17b9,
    0xe1ac_5df4,
    0x65a8_1e3f,
    0x03ac_3d0c,
    0x74ae_11a0,
    0xd72a_0ccd,
    0x40eb_a99b,
    0x194e_10cf,
    0x907d_9792,
    0x2866_1dff,
    0xe793_be30,
    0xf2a9_4d13,
    0xd028_09be,
    0xeb6f_60fe,
    0x1a89_8fa1,
    0x97d8_71f7,
    0x2a54_1811,
    0x060e_6c03,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x1000_0000,
    0xf800_0000,
    0x6400_0000,
    0x5e00_0000,
    0x0900_0000,
    0xff80_0000,
    0x9bc0_0000,
    0xffe0_0000,
    0x4ef0_0000,
    0x2f38_0000,
    0x0294_0000,
    0x980a_0000,
    0x114b_0000,
    0x94ee_8000,
    0x573e_c000,
    0x2692_a000,
    0x2608_b000,
    0x084f_2800,
    0x936f_6c00,
    0xa8fb_8600,
    0x8770_1b00,
    0x61f9_ad80,
    0xd8f2_8cc0,
    0x0a3a_2e20,
    0xcf11_b710,
    0xd8c8_8bb8,
    0xda2e_27c4,
    0x8d5e_ab9e,
    0xb4a3_57c9,
    0xf855_a38f,
    0x446e_4bd6,
    0x1e79_ad99,
    0x0332_8ceb,
    0x15da_2e0e,
    0x91e1_b71c,
    0x0ff0_8ba5,
    0xbcba_27f9,
    0x4b54_abaf,
    0xace8_57fa,
    0x933b_23a1,
    0x8890_8bf6,
    0xc70b_0d82,
    0x6bca_3cf5,
    0x32ad_0604,
    0x001a_db29,
    0x3f01_0d85,
    0x2a81_3cc0,
    0xbe43_8619,
    0x2324_1b34,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0xf000_0000,
    0x7800_0000,
    0x5c00_0000,
    0x6a00_0000,
    0x0100_0000,
    0x8280_0000,
    0x94c0_0000,
    0x0aa0_0000,
    0x0f10_0000,
    0xdc38_0000,
    0x0d34_0000,
    0xf6ea_0000,
    0x412f_0000,
    0xcc09_8000,
    0x735e_c000,
    0xd200_6000,
    0x7d06_1000,
    0x7885_a800,
    0x1dc1_e400,
    0xac26_de00,
    0xadd5_f900,
    0xbd9b_9280,
    0x81a2_0ec0,
    0x3c92_f620,
    0xd27e_dd10,
    0x3f57_2c98,
    0xe15e_e7fc,
    0xcf05_4cbe,
    0xf583_f7c7,
    0x1d43_64a2,
    0xede3_d3ec,
    0x6bf4_5a86,
    0x114a_fade,
    0xbeb8_003e,
    0x29f4_0038,
    0xe44a_000b,
    0xe23f_000d,
    0x0231_801b,
    0x236a_c021,
    0xcc6a_603c,
    0xa9e9_1039,
    0x3cac_281c,
    0xf54f_242a,
    0xa8be_be25,
    0xd2f7_e90b,
    0xefcc_3aa6,
    0xd078_eafb,
    0xaa57_a82b,
    0x4dda_e424,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0xb000_0000,
    0x8800_0000,
    0x1400_0000,
    0xa200_0000,
    0x4900_0000,
    0x4a80_0000,
    0xc340_0000,
    0xfe60_0000,
    0xc5b0_0000,
    0x84b8_0000,
    0xab54_0000,
    0xf74e_0000,
    0xfd0f_0000,
    0x89ef_8000,
    0xef1d_4000,
    0x25c4_2000,
    0xc321_d000,
    0xa4d0_2800,
    0x508e_2400,
    0x6729_a200,
    0x3fb8_5f00,
    0x50d4_3b80,
    0x828d_50c0,
    0xc62e_0a20,
    0xd13f_3b30,
    0xb997_b998,
    0x21eb_dfec,
    0xeb1d_9982,
    0xdfc5_0ff5,
    0xa622_3190,
    0xd056_6bce,
    0x6ccf_b388,
    0x38cf_e4e9,
    0x3acb_a00d,
    0xa3cc_903a,
    0xd14c_0821,
    0x8e0b_f421,
    0xc66f_8a1a,
    0xe8dd_7b29,
    0x6fe4_1986,
    0x4d73_4fc2,
    0x871f_9198,
    0x41c1_fbd4,
    0x8922_3b90,
    0x49d6_50d7,
    0x300f_8a34,
    0xf96d_7b08,
    0x295c_19b9,
    0x1f27_4ffb,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x7000_0000,
    0xe800_0000,
    0xec00_0000,
    0x6200_0000,
    0x4f00_0000,
    0xc680_0000,
    0xe140_0000,
    0x8a20_0000,
    0x88f0_0000,
    0xc428_0000,
    0xea54_0000,
    0xd09e_0000,
    0x55db_0000,
    0xe1f9_8000,
    0x4c0a_4000,
    0x9da1_e000,
    0xda36_d000,
    0xc2ce_d800,
    0x3142_8400,
    0x3220_4200,
    0x1cf3_6d00,
    0xd22f_9180,
    0xc352_7640,
    0xd71f_1a20,
    0x5f1f_a930,
    0x0318_33b8,
    0x6918_cb5c,
    0xba19_d39a,
    0xf69e_1b4b,
    0xb4df_0b80,
    0x9a78_9f7f,
    0xbcc9_4993,
    0x3444_f26f,
    0xb7a1_5818,
    0x2937_c426,
    0x1e4e_221a,
    0xeb00_fd36,
    0x1887_2985,
    0xb447_6267,
    0x77a1_e022,
    0xc936_d010,
    0x6e4e_d809,
    0x0302_841f,
    0xf480_4215,
    0xd643_6d29,
    0x38a7_918e,
    0x0fb6_765e,
    0x8f09_1a3e,
    0x8920_a904,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0xb000_0000,
    0x6800_0000,
    0x6c00_0000,
    0x3200_0000,
    0xad00_0000,
    0x3580_0000,
    0x1240_0000,
    0x9e20_0000,
    0x2490_0000,
    0xa418_0000,
    0x5934_0000,
    0x11ce_0000,
    0xc18f_0000,
    0x3aaf_8000,
    0x97ba_4000,
    0xcbe7_e000,
    0xa5f2_5000,
    0xfb2b_c800,
    0x13f9_9c00,
    0x76c6_4a00,
    0xf3e7_c500,
    0xd1f2_6280,
    0xad2b_47c0,
    0x50fa_0220,
    0xb440_1930,
    0x1525_c898,
    0x5a15_d2ec,
    0xa8da_28ba,
    0x7bd3_82eb,
    0x7fbf_e0b4,
    0x67e5_1ef7,
    0xf7f6_2aaf,
    0xe628_9bc3,
    0x4e7b_a809,
    0x0885_8c25,
    0x5fc4_622a,
    0x5863_090e,
    0x3cb0_60b8,
    0x1b8f_5ecd,
    0x3ba9_caa1,
    0xf03e_cbe5,
    0xc4a6_600d,
    0x6657_101e,
    0xa1fb_a838,
    0x1bc5_8c39,
    0xa664_621a,
    0x73b3_0926,
    0x5b08_60b3,
    0x186b_5efc,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0xf000_0000,
    0xe800_0000,
    0x5c00_0000,
    0x9200_0000,
    0xe500_0000,
    0x7580_0000,
    0xddc0_0000,
    0xb7a0_0000,
    0xfe90_0000,
    0x50f8_0000,
    0xa9b4_0000,
    0xae2a_0000,
    0x2f2b_0000,
    0x2ca9_8000,
    0x226e_4000,
    0xd34c_6000,
    0x469d_5000,
    0x2284_0800,
    0x1d40_1c00,
    0xe7e0_7600,
    0xd0f7_8900,
    0x3fcc_ae80,
    0x2cdf_20c0,
    0x55e7_fe20,
    0x65f2_d510,
    0xb249_38b8,
    0xb51b_b9fc,
    0xc443_389a,
    0xb060_b9c7,
    0xe032_b8bc,
    0x51ea_f9d5,
    0x758c_d8bf,
    0x0bb8_a9cc,
    0xd553_50ab,
    0x7459_f5fd,
    0xf1a4_c68f,
    0x6592_6cdf,
    0x5a7b_801d,
    0x48f1_4001,
    0xcbcf_e009,
    0x02d8_1038,
    0xd2e1_e825,
    0x1d73_0c16,
    0x4608_1e28,
    0x4d7a_c51f,
    0x6870_d089,
    0x6b8c_b5c4,
    0xc4b9_268a,
    0xe1d5_7cdb,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x9000_0000,
    0x8800_0000,
    0x3c00_0000,
    0xa600_0000,
    0xad00_0000,
    0x6780_0000,
    0xdbc0_0000,
    0xd4a0_0000,
    0x5e50_0000,
    0x0058_0000,
    0x7074_0000,
    0xda4a_0000,
    0x3b4f_0000,
    0xa2ca_8000,
    0x0009_4000,
    0xb928_6000,
    0xbfb8_f000,
    0x9dc1_4800,
    0xa9a6_2c00,
    0xd1d4_a600,
    0x779c_e100,
    0x8ad6_e880,
    0x1518_fdc0,
    0xfa95_6e20,
    0xa47c_8d10,
    0x6960_ae98,
    0x07f5_ace4,
    0xc98a_ae82,
    0xb3ea_acdf,
    0xca98_2e91,
    0x2557_ecdf,
    0x92da_4e83,
    0x1830_1ccd,
    0xdf29_8686,
    0x32bb_70c7,
    0x0a47_40aa,
    0x6a64_61fa,
    0xb170_6029,
    0xb3cc_f03f,
    0x818b_4817,
    0xafe9_2c3d,
    0x9c9e_263f,
    0x9055_a138,
    0x415e_88bc,
    0x59f0_0df2,
    0x008c_2608,
    0xa66e_a111,
    0xb65e_0898,
    0x1576_4de1,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x5000_0000,
    0x2800_0000,
    0x9400_0000,
    0x8200_0000,
    0xa100_0000,
    0x1380_0000,
    0x6940_0000,
    0x9020_0000,
    0x7d70_0000,
    0xa758_0000,
    0x6bd4_0000,
    0x52ea_0000,
    0x8cef_0000,
    0x2bec_8000,
    0x536c_4000,
    0x4cab_2000,
    0x0c4a_d000,
    0xbd5f_6800,
    0x66d6_ec00,
    0x1f6c_3200,
    0x02ad_6500,
    0xa348_4580,
    0x61db_95c0,
    0x8315_da20,
    0x4288_c910,
    0xb63b_d798,
    0x3284_60d4,
    0x3ac3_d7aa,
    0x9960_60f5,
    0xbd51_d798,
    0xf22b_60ec,
    0x588f_57b6,
    0xbb3c_20fb,
    0x7f02_f7b6,
    0xb485_b0d6,
    0x11c2_3fbf,
    0x8fe1_ccc9,
    0x3d90_45a6,
    0x164f_95ef,
    0xb05f_da11,
    0x2b57_c902,
    0x912f_57bc,
    0x8a0c_20e6,
    0x91fa_f7b2,
    0xae61_b0ec,
    0xcdd0_3f9b,
    0x49ea_ccc7,
    0xe26e_c5b1,
    0x1728_d5cb,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0xb000_0000,
    0xb800_0000,
    0x9400_0000,
    0x0a00_0000,
    0x0b00_0000,
    0x0480_0000,
    0x7cc0_0000,
    0x0220_0000,
    0x09d0_0000,
    0xb398_0000,
    0xe074_0000,
    0xd00a_0000,
    0xe20b_0000,
    0x3d0b_8000,
    0xd38c_c000,
    0x1448_2000,
    0xaae9_1000,
    0x4bfd_b800,
    0xf045_9400,
    0x12e2_0e00,
    0x75f3_dd00,
    0x0b4f_6480,
    0xe46b_27c0,
    0xdc3e_3620,
    0x46e1_8910,
    0xdff6_cab8,
    0x5049_2aec,
    0xe8ee_ca8e,
    0x8cfd_2af5,
    0xdac4_ca9a,
    0xd726_2afe,
    0xec57_4ab7,
    0x70de_eac6,
    0x2215_6ab4,
    0x333c_fad9,
    0x5063_5299,
    0x6c35_aefc,
    0x54e9_7c81,
    0xbaff_63fe,
    0xa7c3_a016,
    0x4ea5_d00a,
    0xb915_9808,
    0x9fbc_843c,
    0x50a7_b628,
    0xf812_4932,
    0x703f_6a95,
    0x98e7_fadc,
    0x3ef0_d2a3,
    0xefcd_6ed6,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0xd000_0000,
    0xc800_0000,
    0x2400_0000,
    0x6200_0000,
    0x0700_0000,
    0x1380_0000,
    0xec40_0000,
    0xa8a0_0000,
    0x6df0_0000,
    0x2d08_0000,
    0x5dd4_0000,
    0xe93e_0000,
    0x793b_0000,
    0x913c_8000,
    0x853b_4000,
    0xff3a_a000,
    0x143e_d000,
    0x41bc_d800,
    0xc8ff_6c00,
    0x74d8_aa00,
    0xe6ea_1100,
    0x8f03_5980,
    0x1780_1b40,
    0xbe46_f220,
    0xb7a5_3d30,
    0x9275_d3b8,
    0x874b_9a74,
    0x9075_d392,
    0x904b_9a79,
    0xabf5_d380,
    0x880b_9a45,
    0xa955_d3ae,
    0xc6fb_9a76,
    0xf5dd_d398,
    0x706f_9a57,
    0xa7c3_d3bd,
    0x88e4_9a60,
    0xb357_53a6,
    0x3dfb_da72,
    0x885b_f3b3,
    0x0d2a_0a5a,
    0xb1e5_ab92,
    0x39d5_2660,
    0xab3b_2199,
    0x4e3a_a776,
    0x9abe_002b,
    0x857b_0038,
    0x119c_8025,
    0x1ccb_4006,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x3000_0000,
    0xa800_0000,
    0x3c00_0000,
    0xe200_0000,
    0x5100_0000,
    0x8480_0000,
    0xd140_0000,
    0x29a0_0000,
    0xe290_0000,
    0xbfa8_0000,
    0x00b4_0000,
    0x5bfa_0000,
    0x0279_0000,
    0x5dbf_8000,
    0x685e_4000,
    0xf5eb_6000,
    0x8090_d000,
    0xaea8_a800,
    0x2437_1400,
    0xbabc_3200,
    0x83dd_5100,
    0x832e_4280,
    0x35f5_c640,
    0xa459_1a20,
    0x5fe9_0510,
    0x7d94_90a8,
    0x502b_074c,
    0x3071_108a,
    0xc99c_475f,
    0x030d_f0b0,
    0xc0a6_d748,
    0x8214_3883,
    0xb8e8_1367,
    0x9617_2290,
    0x26e8_167f,
    0x8514_3214,
    0xc369_5133,
    0x78d4_4287,
    0x078c_c65b,
    0x51e6_9a21,
    0x0bb7_451d,
    0x6a7f_f0bf,
    0x81bb_d774,
    0x1a59_b8a4,
    0x3ceb_5340,
    0x9011_c287,
    0xa1eb_866a,
    0xbe92_7a1b,
    0x8da9_d519,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0xb000_0000,
    0x6800_0000,
    0x6c00_0000,
    0x9200_0000,
    0x6d00_0000,
    0x9480_0000,
    0x51c0_0000,
    0x2560_0000,
    0xcb50_0000,
    0xd968_0000,
    0x01b4_0000,
    0x847e_0000,
    0xe7fd_0000,
    0x73bf_8000,
    0xf998_4000,
    0x9f6d_e000,
    0xaab1_5000,
    0x7bf9_c800,
    0x69b8_9400,
    0x689a_d600,
    0x41e9_5700,
    0x9272_6880,
    0x341f_f240,
    0x0c2a_9e20,
    0x6d10_8330,
    0x4e4c_de88,
    0xbbc6_b56c,
    0x3c65_5eba,
    0xe9d7_f56b,
    0xaba9_3e8c,
    0x2753_e547,
    0x8b6a_9697,
    0x4cb6_6153,
    0xa0fa_689f,
    0xde3b_f26e,
    0x3adc_9e05,
    0xa0c9_8308,
    0x2b05_5ebb,
    0x3f87_f573,
    0xae41_3e98,
    0xab27_e568,
    0xd074_9690,
    0x611b_6172,
    0x0cad_e88b,
    0x1ad7_b27c,
    0x902f_7e29,
    0x7715_d313,
    0xdf4b_1685,
    0x6543_2142,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0xd000_0000,
    0x9800_0000,
    0x9c00_0000,
    0xf600_0000,
    0x4900_0000,
    0x2080_0000,
    0x0140_0000,
    0x84a0_0000,
    0x88b0_0000,
    0x9df8_0000,
    0xa794_0000,
    0x1f8a_0000,
    0x440f_0000,
    0x66c8_8000,
    0xcca9_c000,
    0xe07f_6000,
    0x5450_f000,
    0x096d_e800,
    0x9f9f_1400,
    0x1f45_5200,
    0x39a1_f900,
    0xea31_d380,
    0xf7be_7cc0,
    0xb8b2_3a20,
    0x95fc_2d10,
    0xc391_6198,
    0xa58d_b5f4,
    0x630b_e186,
    0x934f_75f7,
    0x1b6e_0185,
    0x2c9d_45f6,
    0x78c6_0996,
    0x1d60_61c3,
    0x2153_5382,
    0x2fe8_bcf3,
    0xffdd_da0c,
    0x6f61_1d38,
    0x4251_e9ad,
    0xd069_51f2,
    0x4719_dbac,
    0x5203_58dd,
    0xd307_6034,
    0xb784_f039,
    0xbcc7_e82c,
    0x5760_141d,
    0x2e55_d23c,
    0x0e6c_3907,
    0xda1c_b38c,
    0x8085_8cd6,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x1000_0000,
    0x5800_0000,
    0x7c00_0000,
    0x2a00_0000,
    0x7300_0000,
    0xe280_0000,
    0xd640_0000,
    0x58e0_0000,
    0x1ef0_0000,
    0x1128_0000,
    0x3054_0000,
    0x673a_0000,
    0x178f_0000,
    0x7246_8000,
    0x4ee3_c000,
    0x27f0_6000,
    0x90ab_1000,
    0x5c96_b800,
    0x959f_a400,
    0x7b9b_7a00,
    0x0e98_cb00,
    0x8d1e_9180,
    0xa6da_9c40,
    0xb8fd_a220,
    0x27ac_7f10,
    0xb813_5398,
    0x22dd_f344,
    0xdef8_49b6,
    0x56ae_284f,
    0x1d90_6032,
    0x181b_1008,
    0x755e_b836,
    0xab3b_a42e,
    0x5589_7a0a,
    0x5543_cb04,
    0xb262_11b6,
    0x8cb6_5c65,
    0x0fcb_4217,
    0x2fa4_af27,
    0x9b95_8b96,
    0x3919_475c,
    0xe8dd_8ba2,
    0xfdfd_4762,
    0x8c2f_8ba0,
    0xa7d6_477b,
    0x32fb_0b9d,
    0x64ae_874a,
    0x7297_eb8f,
    0xc099_5778,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x7000_0000,
    0x7800_0000,
    0x7400_0000,
    0x9e00_0000,
    0x6700_0000,
    0x1780_0000,
    0xb240_0000,
    0xd8e0_0000,
    0xc310_0000,
    0xc588_0000,
    0x91b4_0000,
    0x8a7e_0000,
    0x992b_0000,
    0xb141_8000,
    0x9962_c000,
    0xfa57_2000,
    0x90ec_b000,
    0x61e7_5800,
    0x9391_ec00,
    0xf04d_5a00,
    0xf312_c300,
    0x9d8e_f680,
    0x75b5_d940,
    0x1c7d_2220,
    0xf22f_9f30,
    0x4cc4_f4b8,
    0xd226_f65c,
    0x5236_8ebe,
    0xf63c_856d,
    0xcec9_203f,
    0x19d7_b035,
    0x7cae_d823,
    0x3e07_2c2d,
    0x3704_7a0f,
    0xff85_7334,
    0xce40_2e93,
    0x4ae2_f551,
    0x4e11_5831,
    0x2b0e_ec0a,
    0x5372_da13,
    0xf75b_032e,
    0x3098_56b3,
    0x6f3b_a97b,
    0x0e4d_5a11,
    0x2412_c30d,
    0x120e_f693,
    0xc3f5_d94e,
    0x229d_2209,
    0x223f_9f00,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x5000_0000,
    0xe800_0000,
    0x2400_0000,
    0xc200_0000,
    0x2100_0000,
    0xeb80_0000,
    0xb040_0000,
    0x2920_0000,
    0x5dd0_0000,
    0x2a28_0000,
    0x0cb4_0000,
    0x6ada_0000,
    0xf149_0000,
    0x1944_8000,
    0x56a0_4000,
    0x3796_a000,
    0xbe0b_d000,
    0xb4e3_6800,
    0x37b2_6c00,
    0xdc5f_9a00,
    0x5489_9d00,
    0xff21_7080,
    0xe6d3_ba40,
    0xdcaa_5220,
    0x0970_2110,
    0xdcbd_82a8,
    0xa938_4b54,
    0xd67c_b89a,
    0x23de_0659,
    0x7ecc_a038,
    0xcb02_d00c,
    0x0e87_e828,
    0x69c2_2c31,
    0x0061_3a00,
    0x5376_4d16,
    0x21b8_1880,
    0xecb8_d667,
    0xf139_480a,
    0xea7d_fc17,
    0x7dd8_522e,
    0x51cd_2115,
    0xe783_02a7,
    0xb641_0b59,
    0x3a26_98a1,
    0x2f51_967c,
    0xbdeb_680e,
    0x73d6_6c07,
    0xfd2d_9a07,
    0x4c34_9d11,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x1000_0000,
    0xa800_0000,
    0x2400_0000,
    0xde00_0000,
    0xd100_0000,
    0x2380_0000,
    0x0bc0_0000,
    0x3d60_0000,
    0x85f0_0000,
    0x3828_0000,
    0x0754_0000,
    0x36be_0000,
    0x2f8f_0000,
    0xe442_8000,
    0x6ca0_4000,
    0xc792_a000,
    0xf75b_3000,
    0x9b3e_e800,
    0xfd4c_cc00,
    0xaea1_2600,
    0x8493_ff00,
    0x9fdb_ad80,
    0xac78_9440,
    0x916d_6e20,
    0x1a74_0330,
    0xd1ec_6398,
    0xc933_a744,
    0x03c9_e58a,
    0xbce0_6879,
    0xdd30_200f,
    0xc5cb_7000,
    0x91e4_483a,
    0xbcb3_fc0f,
    0x4d09_ce12,
    0xa404_331c,
    0x1e06_0bb1,
    0xb104_2b77,
    0x3386_e3aa,
    0xa3c7_e758,
    0x1965_4580,
    0x5bf4_584f,
    0xe92c_4820,
    0x24d7_fc0a,
    0x3d7f_ce17,
    0x12ef_3316,
    0x61b2_8bb6,
    0x548f_6b78,
    0xc0c0_c3a0,
    0xc1e7_974e,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x3000_0000,
    0x5800_0000,
    0x9c00_0000,
    0x2a00_0000,
    0x8700_0000,
    0xde80_0000,
    0x40c0_0000,
    0x4be0_0000,
    0xee30_0000,
    0xaa48_0000,
    0x7f14_0000,
    0x109e_0000,
    0x19ef_0000,
    0x9f03_8000,
    0xe287_c000,
    0x3ac6_6000,
    0xa4e2_1000,
    0xf4b2_1800,
    0x5c8b_4400,
    0x99f3_6e00,
    0xa72e_9300,
    0x2de4_8380,
    0xeb32_8b40,
    0x57cf_1620,
    0x6753_c730,
    0xeebb_f598,
    0x79b8_5c4c,
    0x6f3b_7bb6,
    0xbbf8_1f57,
    0x2e1e_0032,
    0xa92f_001d,
    0xece3_8039,
    0xa0b7_c03b,
    0xe28e_600e,
    0xc0f6_103d,
    0x10ac_1817,
    0x82a4_442e,
    0x9390_ee21,
    0xeb59_532d,
    0xf68a_e39f,
    0xdef4_9b5c,
    0x19ab_0e00,
    0x5d23_8300,
    0xf8d5_1b86,
    0x25fe_0f65,
    0xe71a_1839,
    0x16af_442f,
    0xb7a5_6e2a,
    0x3615_9329,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x9000_0000,
    0x5800_0000,
    0x6400_0000,
    0xe200_0000,
    0xfb00_0000,
    0xc580_0000,
    0x4f40_0000,
    0x27a0_0000,
    0x05b0_0000,
    0x3dd8_0000,
    0x3f54_0000,
    0x8cca_0000,
    0x8ebb_0000,
    0x8f02_8000,
    0x3f87_c000,
    0x3040_a000,
    0x9021_5000,
    0xe9f6_3800,
    0xbbfa_1c00,
    0x97a6_b200,
    0x6db2_c900,
    0x71db_7b80,
    0x7152_29c0,
    0xa9c8_2a20,
    0x363d_8510,
    0x1cc1_f1b8,
    0x69e1_fce4,
    0x9897_63b6,
    0xc0aa_a5c9,
    0xc96a_0020,
    0x300b_000a,
    0x975a_801f,
    0xdf93_c02e,
    0xc32a_a027,
    0x7f2a_5026,
    0xb92c_b806,
    0x4029_dc22,
    0xeeac_121b,
    0x3c68_9931,
    0x308f_c3a5,
    0xf09f_f5c1,
    0x33f6_3800,
    0xf4fa_1c18,
    0x0826_b202,
    0x2df2_c926,
    0x29fb_7b9c,
    0xa4a2_29e9,
    0x9430_2a32,
    0xb899_8538,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x9000_0000,
    0x1800_0000,
    0x5400_0000,
    0xce00_0000,
    0x8500_0000,
    0xc280_0000,
    0xebc0_0000,
    0x9a60_0000,
    0x6d50_0000,
    0xdcb8_0000,
    0x1af4_0000,
    0x028e_0000,
    0x439d_0000,
    0xec06_8000,
    0xca07_c000,
    0x7307_2000,
    0x8382_3000,
    0xff46_4800,
    0xa0a2_c400,
    0xfbb5_0600,
    0xdf2e_ef00,
    0x9eae_2080,
    0x9eef_68c0,
    0x07cc_6e20,
    0xd83a_1b30,
    0xf833_6e88,
    0xe06e_43e4,
    0x1e09_c8a6,
    0xf558_5ce5,
    0xc0e0_001b,
    0x1290_0035,
    0xa8d8_003e,
    0x62a4_000b,
    0x04b6_0013,
    0xe6a9_002f,
    0xbae8_8034,
    0x61ca_c01d,
    0x8139_a016,
    0xb8b1_f031,
    0x14af_682a,
    0x0ded_f42f,
    0x344d_ce2b,
    0xaf7f_eb36,
    0x1492_0684,
    0x81de_b7ca,
    0x8a22_86b9,
    0x2c70_77d5,
    0x774d_26ac,
    0x64f8_87fb,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x7000_0000,
    0x0800_0000,
    0x2c00_0000,
    0x0a00_0000,
    0x0f00_0000,
    0xf880_0000,
    0x7740_0000,
    0x3be0_0000,
    0xc070_0000,
    0xd9c8_0000,
    0x1ed4_0000,
    0x395a_0000,
    0xb1ef_0000,
    0xd005_8000,
    0x5801_4000,
    0x3401_e000,
    0x5e03_9000,
    0x2101_5800,
    0xd186_f400,
    0x8ac3_9200,
    0xbb26_6300,
    0x7452_7d80,
    0x551c_ab40,
    0x3c8b_2a20,
    0x3e37_0710,
    0x4faa_b798,
    0x4663_3c5c,
    0x00b7_45a2,
    0x0de8_8f5b,
    0xe200_003a,
    0x1300_000f,
    0x9a80_0024,
    0x2440_000a,
    0xc160_000e,
    0x9430_0038,
    0x10a8_000a,
    0xa6e4_0019,
    0x23f2_003e,
    0x180b_0001,
    0x0b77_800c,
    0x374a_4021,
    0x0496_6035,
    0xa939_d03c,
    0xfc5f_3832,
    0x666b_240e,
    0x4fc6_aa1b,
    0x6ca2_472f,
    0xeb91_5798,
    0x61bf_ac76,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x3000_0000,
    0x7800_0000,
    0x9c00_0000,
    0xd200_0000,
    0x8300_0000,
    0xed80_0000,
    0x7440_0000,
    0x16a0_0000,
    0x3610_0000,
    0x7728_0000,
    0x9af4_0000,
    0x469a_0000,
    0xd54f_0000,
    0x0287_8000,
    0x13c2_c000,
    0x2de6_6000,
    0x5734_d000,
    0x527b_3800,
    0x58f9_1c00,
    0xcf3f_2a00,
    0x9cde_c100,
    0xe2e9_fe80,
    0x4217_ee40,
    0x512a_7220,
    0x7ff7_0d10,
    0x2e1f_ec98,
    0xf98b_334c,
    0x40e1_26be,
    0xfbb3_e277,
    0x60bd_800c,
    0x039d_c03c,
    0xadc9_e03d,
    0x0642_1036,
    0x85a7_582f,
    0xf392_cc0a,
    0xd76b_9212,
    0xba51_1d1b,
    0xbd8a_b4af,
    0x1ee2_ff65,
    0x82b7_34b8,
    0xda3f_3f7f,
    0xac5e_d4bf,
    0x022d_2f5a,
    0x9a71_8ca3,
    0xde5b_e35c,
    0x9128_1eaa,
    0x5ff1_fe6d,
    0x7e1f_2a0e,
    0xb18e_c115,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x9000_0000,
    0x9800_0000,
    0xfc00_0000,
    0xf600_0000,
    0x8300_0000,
    0xcf80_0000,
    0x8340_0000,
    0x3920_0000,
    0x9a70_0000,
    0x61f8_0000,
    0x7a14_0000,
    0x8faa_0000,
    0x411b_0000,
    0x2682_8000,
    0xe9c1_c000,
    0x8ee4_6000,
    0x8397_f000,
    0x2fef_3800,
    0xc7ba_2c00,
    0x37b1_b200,
    0xd51e_ad00,
    0x6481_3580,
    0x18c4_9cc0,
    0x5862_ea20,
    0x2257_7110,
    0x250d_bfb8,
    0xde2f_1de4,
    0xf55a_ed86,
    0xa227_80ef,
    0xe9f0_8025,
    0xf4be_c014,
    0x5034_e02d,
    0x4259_303b,
    0x5fa3_d815,
    0x93b7_1c39,
    0x7f18_6a16,
    0x6182_b11e,
    0x5c43_df9e,
    0x70a3_edd6,
    0x9237_55bf,
    0xf35c_6cd2,
    0x6925_5200,
    0xa277_9d1a,
    0xedfa_edbf,
    0x8417_80c0,
    0x68a8_801c,
    0x849a_c020,
    0xd0c6_e007,
    0x9c66_3033,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0xf000_0000,
    0xc800_0000,
    0x8c00_0000,
    0xf600_0000,
    0x2d00_0000,
    0xaa80_0000,
    0xc940_0000,
    0x3ca0_0000,
    0xfd10_0000,
    0xdcc8_0000,
    0x75f4_0000,
    0xaffe_0000,
    0xc96b_0000,
    0x7865_8000,
    0x7177_4000,
    0x3fbc_e000,
    0x0d4a_7000,
    0xeb31_4800,
    0x289f_8400,
    0x759c_1200,
    0xd71e_1900,
    0x725b_d680,
    0x48f8_1940,
    0x50ef_ba20,
    0xaaa0_ed30,
    0xe013_0cb8,
    0x5e4e_c47c,
    0xc0b4_9e92,
    0xad5c_9d53,
    0x957e_2825,
    0xf82d_b407,
    0xe0c2_3a20,
    0x0663_ad2d,
    0xf071_ec80,
    0x733f_b457,
    0xd108_5680,
    0x3910_5954,
    0x66c8_da16,
    0x4ef6_dd33,
    0xd87b_24ac,
    0x62ac_7061,
    0x0185_24bc,
    0x46c7_7074,
    0x3360_a480,
    0x0ef0_3051,
    0xf87c_4483,
    0x72aa_4048,
    0x3985_0c86,
    0x02c1_c45d,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x5000_0000,
    0xe800_0000,
    0x2400_0000,
    0x5e00_0000,
    0xe300_0000,
    0x1980_0000,
    0xd8c0_0000,
    0xea20_0000,
    0x6390_0000,
    0x46f8_0000,
    0xda74_0000,
    0xb2ca_0000,
    0x59dd_0000,
    0x7764_8000,
    0xa374_4000,
    0x264a_a000,
    0xe39b_3000,
    0xc007_7800,
    0x6000_1c00,
    0x7000_ae00,
    0xb805_4500,
    0xcc03_7680,
    0x7a00_70c0,
    0xbd07_7620,
    0xfa83_6910,
    0xc140_2088,
    0x32e1_69d4,
    0x89b6_0e9a,
    0x2569_6cd9,
    0x9c89_583f,
    0x68bf_6c3c,
    0xeb15_7634,
    0x2eba_692b,
    0xd416_a097,
    0x853c_29e9,
    0xc5d2_2ea0,
    0x239b_1ce8,
    0xa000_0038,
    0x1000_003c,
    0xc800_0004,
    0x7400_001b,
    0xb600_0019,
    0xc700_0029,
    0x4780_0010,
    0x3bc0_0028,
    0xf3a0_0034,
    0xbb50_0010,
    0xacd8_0021,
    0xb9e4_0010,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0xf000_0000,
    0xf800_0000,
    0x2400_0000,
    0x8e00_0000,
    0x7500_0000,
    0x8e80_0000,
    0xb1c0_0000,
    0x68a0_0000,
    0x59b0_0000,
    0xc418_0000,
    0x2dd4_0000,
    0x0f8a_0000,
    0x67bb_0000,
    0xd7e1_8000,
    0xc0d2_c000,
    0x1509_a000,
    0x4078_3000,
    0x1e43_4800,
    0x61e4_2400,
    0x31d2_d600,
    0x058c_d900,
    0x8cb9_d780,
    0x2463_bbc0,
    0x2392_3e20,
    0x666b_cd10,
    0x8a69_c9b8,
    0x7869_86fc,
    0xb768_9f9e,
    0xcae8_9fd9,
    0x5cab_683b,
    0xa14e_d431,
    0xda98_3e25,
    0xd410_cd19,
    0x5b28_4987,
    0x640b_46c2,
    0x10f9_3f91,
    0x3284_afea,
    0xabc2_2022,
    0x8ba1_f00f,
    0x7633_6818,
    0x8d5a_d418,
    0xa5b2_3e2a,
    0x3e1b_cd16,
    0x3ed1_c9b1,
    0xd80d_86c0,
    0x0afa_9fa5,
    0xd187_9fcb,
    0x8440_e812,
    0xc2e7_1430,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x1000_0000,
    0x2800_0000,
    0x4c00_0000,
    0x9e00_0000,
    0x1900_0000,
    0x9680_0000,
    0x67c0_0000,
    0xe9e0_0000,
    0x2850_0000,
    0x6598_0000,
    0x2774_0000,
    0x86ae_0000,
    0xd77d_0000,
    0xf6a2_8000,
    0x6776_4000,
    0x66ab_e000,
    0xe779_3000,
    0xcea1_e800,
    0x0375_2400,
    0xb4ae_8600,
    0x607e_f300,
    0x4127_e880,
    0xf236_cdc0,
    0x3a8a_8e20,
    0xa1cf_e730,
    0x0cea_0688,
    0xb0db_5ac4,
    0x9b50_00aa,
    0xf01a_e9e3,
    0x2d30_880f,
    0x210e_5432,
    0x9a8a_8e27,
    0x71cf_e70e,
    0x04ea_0697,
    0xecdb_5adf,
    0x2d50_00bb,
    0xa51a_e9e6,
    0x25b0_8816,
    0x5fce_5412,
    0xe5ea_8e1c,
    0x3e5f_e70d,
    0x8892_068c,
    0xe3ff_5ad0,
    0xce66_008d,
    0x5513_e9c3,
    0x55bc_083e,
    0xefc5_141f,
    0x75e3_ee1b,
    0xbe50_9711,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x3000_0000,
    0x8800_0000,
    0xcc00_0000,
    0xc600_0000,
    0xb900_0000,
    0xdf80_0000,
    0x0ac0_0000,
    0x4160_0000,
    0x0db0_0000,
    0x0d68_0000,
    0x4314_0000,
    0x303e_0000,
    0x2c0d_0000,
    0x9ea3_8000,
    0xa553_4000,
    0x1b1e_e000,
    0x2c9f_f000,
    0x3a5d_e800,
    0x253d_ac00,
    0xe589_2e00,
    0xb567_ff00,
    0x4fb2_6780,
    0x9e6e_a640,
    0xd394_2620,
    0xd478_a330,
    0x742d_2188,
    0x1eb3_b54c,
    0x5def_8f82,
    0x8753_0a43,
    0x581d_0819,
    0x241f_5c12,
    0xaa1f_461d,
    0xff1d_133d,
    0xd69b_a983,
    0xed5b_a95e,
    0xbfb8_29a5,
    0x7ec8_e94c,
    0x8bc6_c983,
    0x1ae7_1976,
    0x2d73_21be,
    0x030e_b575,
    0xa024_0fb2,
    0x2414_4a71,
    0xe2bd_e829,
    0x5b4d_ac08,
    0x5601_2e24,
    0xc103_ff1f,
    0xbb84_67ac,
    0x30c7_a669,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0xd000_0000,
    0xe800_0000,
    0x3400_0000,
    0x6600_0000,
    0x5d00_0000,
    0x0380_0000,
    0xf8c0_0000,
    0x5ea0_0000,
    0xbc90_0000,
    0xd688_0000,
    0xdbf4_0000,
    0x853e_0000,
    0x822d_0000,
    0xb064_8000,
    0x4730_4000,
    0x959e_2000,
    0x77be_f000,
    0xd36e_0800,
    0xd101_8c00,
    0x7987_9e00,
    0xd7c0_c100,
    0xb622_5e80,
    0xf2d6_5740,
    0x4769_b620,
    0xa702_bd30,
    0xec87_4888,
    0x3043_5a74,
    0xc0e4_569a,
    0xc573_db7d,
    0x9e78_2831,
    0xd44b_7c13,
    0x6a57_9632,
    0xf12c_4d07,
    0xcae1_40b4,
    0x1276_d675,
    0x8afd_c88c,
    0x180e_1a6f,
    0x28b6_f69e,
    0xe759_6b75,
    0x3e1e_001c,
    0x5b7d_0001,
    0x1bcc_801a,
    0x0894_4025,
    0x7088_201a,
    0xa6f7_f021,
    0x56bc_8819,
    0x92e8_cc3f,
    0xdac3_3e1e,
    0x9da3_7132,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0xf000_0000,
    0x3800_0000,
    0x6400_0000,
    0x9600_0000,
    0x1100_0000,
    0x4d80_0000,
    0xf540_0000,
    0x99e0_0000,
    0x4cd0_0000,
    0x3e58_0000,
    0x1d74_0000,
    0x2cea_0000,
    0x19bf_0000,
    0xaca1_8000,
    0xf530_c000,
    0xe28f_a000,
    0xeb2e_f000,
    0x6d9c_6800,
    0xc750_fc00,
    0x321d_1200,
    0x0517_6b00,
    0xaf78_c080,
    0x6503_c7c0,
    0x5384_da20,
    0xd846_6710,
    0xd660_3a98,
    0x0690_90fc,
    0x9f3c_a8ae,
    0x7f67_3bc9,
    0x6f13_c81d,
    0x9c7e_0c28,
    0x0781_7a05,
    0x5647_9718,
    0x3365_d28d,
    0x1514_acce,
    0x277c_1a99,
    0x5905_a0ee,
    0x5184_e086,
    0x6746_f7c4,
    0xeee4_9234,
    0x2853_ab1c,
    0xe29d_608f,
    0xe7d2_37da,
    0xe8d9_3223,
    0x26b6_5b3a,
    0x7aca_8897,
    0x5d4d_0bd0,
    0x9b0a_001c,
    0x606f_0032,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x3000_0000,
    0xd800_0000,
    0xb400_0000,
    0x8e00_0000,
    0x4900_0000,
    0x7080_0000,
    0xbec0_0000,
    0x2f20_0000,
    0x4730_0000,
    0x5978_0000,
    0x19d4_0000,
    0x34ee_0000,
    0xbbd9_0000,
    0x7ea3_8000,
    0x2575_c000,
    0x5299_2000,
    0x86c7_3000,
    0xcb27_2800,
    0x8137_5400,
    0x4c7a_4e00,
    0x8b52_7500,
    0xf92f_eb80,
    0x237b_34c0,
    0xbed2_4620,
    0x9d6f_1130,
    0x9d9f_0da8,
    0x8342_d5cc,
    0x7765_4396,
    0x8bd0_a0dd,
    0xffea_a82b,
    0x285b_942e,
    0x9fe0_ee02,
    0xe110_850e,
    0xcec9_e39e,
    0xce6f_50ee,
    0xda19_2009,
    0x7c07_300b,
    0x1207_2832,
    0x0b07_541c,
    0x3382_4e34,
    0xd146_7533,
    0x1c61_ebac,
    0x2852_34db,
    0xc6a9_c61c,
    0x583e_d118,
    0x8db0_2dbb,
    0xe0b8_e5d7,
    0xaf77_eb98,
    0x8d9f_34d2,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x1000_0000,
    0x0800_0000,
    0x9c00_0000,
    0x8a00_0000,
    0x7100_0000,
    0x0e80_0000,
    0x5cc0_0000,
    0x8360_0000,
    0x3190_0000,
    0x7528_0000,
    0x5134_0000,
    0x865a_0000,
    0x50cf_0000,
    0x9066_8000,
    0x8211_4000,
    0xc56f_6000,
    0x7390_9000,
    0xb82d_2800,
    0xa5b7_c400,
    0xb39f_be00,
    0x4928_a700,
    0xeb31_7e80,
    0x8f58_4440,
    0xda4f_f620,
    0xd2a4_f310,
    0x6677_6898,
    0x017d_6744,
    0x25fa_d6a2,
    0x383e_c077,
    0xcddf_281a,
    0x248c_c408,
    0xccc3_3e19,
    0xcb66_e734,
    0xcd90_9e80,
    0xef2d_9477,
    0x2837_be1c,
    0x14dc_a70f,
    0x860b_7e9a,
    0x6207_444b,
    0xbd01_763b,
    0xec81_b30f,
    0xa1c2_08b7,
    0x0fe2_f744,
    0x8051_7e8a,
    0x72c8_447d,
    0x4d67_f603,
    0x7e90_f32a,
    0x6cad_68a1,
    0xe072_6776,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0xd000_0000,
    0xb800_0000,
    0xf400_0000,
    0x3600_0000,
    0xb700_0000,
    0x9980_0000,
    0x6bc0_0000,
    0xa820_0000,
    0xac50_0000,
    0x7df8_0000,
    0x92b4_0000,
    0xbd0a_0000,
    0x1c5f_0000,
    0xad20_8000,
    0xfcd4_c000,
    0xc4ba_2000,
    0x62d6_f000,
    0x1fbd_d800,
    0x8955_dc00,
    0x9d7b_d600,
    0x43f6_f500,
    0x0169_d080,
    0x7cee_80c0,
    0xb92e_2e20,
    0xe20e_d910,
    0x89dd_5e98,
    0x64e2_69f4,
    0x05f4_888e,
    0xfe6f_9ced,
    0x196f_d835,
    0x78ee_dc09,
    0x8729_5610,
    0xc909_3513,
    0x6a59_7089,
    0x7a23_b0fb,
    0xb551_5614,
    0x177d_3503,
    0x3ef3_70bb,
    0x85ec_b0c2,
    0x43a9_d610,
    0x964d_f51d,
    0x953b_5094,
    0xb511_40e2,
    0x7d9e_8e2b,
    0x3803_e92d,
    0xb402_2682,
    0x5601_85c5,
    0x6702_a681,
    0x2185_45f6,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x5000_0000,
    0x2800_0000,
    0xec00_0000,
    0xea00_0000,
    0xc500_0000,
    0x9780_0000,
    0xb440_0000,
    0x6da0_0000,
    0x2d30_0000,
    0x3208_0000,
    0x0354_0000,
    0x56de_0000,
    0xb9cb_0000,
    0xf6b0_8000,
    0x1c48_4000,
    0x33f6_e000,
    0x786a_9000,
    0x1183_0800,
    0x5b40_0c00,
    0xdf22_9a00,
    0x5ef4_1900,
    0xc3ee_6780,
    0xafc2_1740,
    0xa3e7_f220,
    0x4d96_c530,
    0x34b9_15b8,
    0x471c_9254,
    0x1128_07aa,
    0xbfa0_c74b,
    0x0c32_1a22,
    0x138c_5915,
    0xe010_8797,
    0xadfc_8742,
    0xb13a_fa0b,
    0x325d_c931,
    0x0d0b_0fab,
    0x59d0_cb48,
    0x2918_8001,
    0xf22c_4003,
    0xb720_e028,
    0x92f5_9029,
    0x99ed_883a,
    0x12c3_4c26,
    0xf064_fa0d,
    0xffd6_c905,
    0x761b_8faf,
    0x38a8_8b63,
    0x00e6_6016,
    0x6512_d036,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x1000_0000,
    0xd800_0000,
    0x8400_0000,
    0xc600_0000,
    0xed00_0000,
    0xf280_0000,
    0xb1c0_0000,
    0x5320_0000,
    0xc050_0000,
    0x9f88_0000,
    0x4034_0000,
    0xa53e_0000,
    0x68c9_0000,
    0x6cd2_8000,
    0x274d_c000,
    0x9795_a000,
    0xf1ae_7000,
    0x0ae4_8800,
    0x1f73_0400,
    0x65df_1600,
    0x60ba_c500,
    0xe48e_e880,
    0xe7b7_a340,
    0xd27c_be20,
    0x842a_7130,
    0x4ea0_d6a8,
    0xc810_1244,
    0xd2e9_c896,
    0x5804_1351,
    0x4405_9639,
    0x6603_050f,
    0xfd05_48a2,
    0x2a80_d349,
    0x35c2_b633,
    0x9520_b51a,
    0x2d54_6082,
    0x6d0d_a743,
    0xf1f1_2817,
    0xf61d_7417,
    0xa89b_9e31,
    0xf359_c116,
    0x6779_fea1,
    0x32a9_667b,
    0x9964_56b5,
    0x6630_d26f,
    0x3838_e8b4,
    0xf24a_a365,
    0x9110_3e1d,
    0xee6e_b13d,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x1000_0000,
    0x6800_0000,
    0x2400_0000,
    0xce00_0000,
    0xc900_0000,
    0x0b80_0000,
    0xedc0_0000,
    0xfda0_0000,
    0x0a50_0000,
    0x4168_0000,
    0xf9b4_0000,
    0x3f5a_0000,
    0xe12f_0000,
    0x54d6_8000,
    0x052a_4000,
    0xbad6_a000,
    0xbc2f_b000,
    0xc953_2800,
    0x1ded_8c00,
    0xdef3_1600,
    0x10ba_5900,
    0x5d1d_5080,
    0x0f4b_6040,
    0x7220_1e20,
    0x1992_2510,
    0x6dcb_ce98,
    0xa463_0544,
    0x11f5_70ba,
    0xc63a_9059,
    0x6d5f_960b,
    0x8a2f_1926,
    0x0c55_7080,
    0x9c6a_9076,
    0x2437_9636,
    0x479b_1929,
    0x950f_70b9,
    0x9045_9073,
    0xb561_1608,
    0x6671_5918,
    0xd9f9_d091,
    0xcbfa_204b,
    0xc0fa_3e09,
    0x8878_d50b,
    0x7938_c6bc,
    0xc3db_794a,
    0xf66b_eea4,
    0x6336_f576,
    0xe518_f8b0,
    0x634c_ac77,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0xd000_0000,
    0x2800_0000,
    0x7400_0000,
    0x6e00_0000,
    0x5500_0000,
    0x6e80_0000,
    0xa940_0000,
    0x4c60_0000,
    0xe1d0_0000,
    0x8eb8_0000,
    0xa274_0000,
    0x4e4e_0000,
    0xb779_0000,
    0x5a54_8000,
    0x897a_4000,
    0xe754_2000,
    0x33fa_b000,
    0xf011_4800,
    0x029b_2400,
    0x0b44_d200,
    0x4b60_9f00,
    0xb056_0080,
    0x8a7c_d4c0,
    0x20d5_3a20,
    0x3e3b_4b30,
    0x0637_baa8,
    0xe0ad_dff4,
    0xcdee_a0aa,
    0xd788_24ed,
    0x9f5e_5213,
    0xb563_df11,
    0xad56_a0b9,
    0xe0fc_24c3,
    0x1f90_5222,
    0x7b5a_df00,
    0x9362_208b,
    0xfc56_64e3,
    0x187c_7231,
    0xbfd4_6f12,
    0x43bd_6895,
    0xe0f4_40d3,
    0x050c_2038,
    0x9c1e_b00e,
    0x9a07_4819,
    0xfb06_2416,
    0x9b86_521f,
    0x17c7_df23,
    0xcd20_a0b2,
    0xd9b1_24ee,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x1000_0000,
    0x3800_0000,
    0xf400_0000,
    0x1200_0000,
    0xe900_0000,
    0x8280_0000,
    0x8c40_0000,
    0x7720_0000,
    0xfb70_0000,
    0x4c58_0000,
    0xbe94_0000,
    0xe24a_0000,
    0x799d_0000,
    0x4e76_8000,
    0x50da_c000,
    0x1dd2_2000,
    0xfceb_d000,
    0x5d2c_2800,
    0x8fcd_a400,
    0xfc5d_7a00,
    0xd690_c500,
    0x0e4d_7d80,
    0x8f99_11c0,
    0x8d75_f220,
    0xcf5c_7110,
    0x0116_0f88,
    0xee8b_a0c4,
    0x53fb_ddae,
    0xb4a1_01ed,
    0x79b7_7a2c,
    0x713d_c52e,
    0xd9c3_fda6,
    0x06e7_d1da,
    0x7195_d237,
    0xfbce_a129,
    0xae5e_a7bf,
    0x1f95_c4f2,
    0x9cc8_07ab,
    0x3bdd_d4ee,
    0x0e52_8fb1,
    0x2628_60eb,
    0xa44d_7daa,
    0xd299_11c4,
    0x3df5_f203,
    0xba1c_7104,
    0xccb6_0f9a,
    0x6dbb_a0d1,
    0x7a83_ddbc,
    0x1845_01eb,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0xd000_0000,
    0x0800_0000,
    0x4400_0000,
    0xce00_0000,
    0x4700_0000,
    0x6f80_0000,
    0x3540_0000,
    0x6820_0000,
    0x6d30_0000,
    0xdab8_0000,
    0x11d4_0000,
    0x6dee_0000,
    0xc1ff_0000,
    0x2ef4_8000,
    0x075d_4000,
    0xba03_a000,
    0x9106_b000,
    0x0483_5800,
    0x00c1_ac00,
    0xdc65_a200,
    0x6990_2500,
    0x234f_cf80,
    0xd10a_06c0,
    0x16a9_da20,
    0x2ede_7930,
    0x4c44_9598,
    0x38a2_3ff4,
    0xcbf4_6fa2,
    0xd5d8_b6e1,
    0xd1c4_820b,
    0x78e0_d515,
    0xd955_b781,
    0x272f_5ae8,
    0xf498_000b,
    0xbfe4_002b,
    0x76d6_0006,
    0x726b_002c,
    0x4cba_8018,
    0xdad2_4037,
    0xe86f_2014,
    0xadbf_f00f,
    0x6656_f818,
    0x74ac_1c1d,
    0xf3dc_7a0b,
    0xc2c3_c92a,
    0xb165_4da4,
    0x3f15_d3fb,
    0xe688_ed9c,
    0xafec_63d0,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0xf000_0000,
    0xc800_0000,
    0xd400_0000,
    0x7200_0000,
    0xbb00_0000,
    0x0c80_0000,
    0xadc0_0000,
    0x96e0_0000,
    0xff90_0000,
    0x59e8_0000,
    0x0a34_0000,
    0x8e5e_0000,
    0xb229_0000,
    0xc5d5_8000,
    0x5e4d_4000,
    0xa680_2000,
    0x9ac4_5000,
    0xa460_3800,
    0x7752_d400,
    0x168d_6600,
    0x49e3_ab00,
    0x2917_6680,
    0xcb2b_ce40,
    0xda50_fe20,
    0x7b0c_6f30,
    0xd7a4_18a8,
    0x54b7_e17c,
    0xa89f_4692,
    0x404b_9e45,
    0xb386_c614,
    0x2b43_bb22,
    0x3c22_fe99,
    0x33f0_0a62,
    0x0abd_802b,
    0xa6b9_4014,
    0xa8be_2021,
    0xe5bd_503b,
    0x183d_b837,
    0x1e7b_940d,
    0x8fdb_461e,
    0x826a_fb04,
    0x0574_de9f,
    0x0879_5a63,
    0xeede_383e,
    0xb1eb_d429,
    0xee30_e623,
    0x945a_eb1d,
    0x2d29_469b,
    0x7356_9e50,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x1000_0000,
    0x3800_0000,
    0x7c00_0000,
    0xae00_0000,
    0x8100_0000,
    0xf680_0000,
    0x81c0_0000,
    0xc260_0000,
    0x4830_0000,
    0x90e8_0000,
    0x2314_0000,
    0x727a_0000,
    0x6b2b_0000,
    0xca76_8000,
    0x7fcc_c000,
    0xb380_6000,
    0xe546_3000,
    0x8ca1_2800,
    0xedd1_a400,
    0x979c_b600,
    0x8c5a_4f00,
    0x753a_8b80,
    0x408b_9240,
    0xe423_7e20,
    0x6515_1b10,
    0x177d_75b8,
    0xbfad_4944,
    0x4cb2_ebae,
    0x8e29_a24f,
    0x5ef0_5633,
    0x190b_bf34,
    0x5265_438b,
    0x3034_c67b,
    0x0cec_8035,
    0x9d17_c03d,
    0xcb7e_e00a,
    0xe1ae_f00c,
    0xe5b3_481f,
    0x3ca8_9437,
    0x0d31_1e0d,
    0xf46c_2b25,
    0x6dd0_dda9,
    0xd79b_2d4b,
    0x6c58_bd9d,
    0x6539_1d7c,
    0x788b_9587,
    0x9827_b959,
    0xcb13_a398,
    0x967e_3643,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xf000_0000,
    0xa800_0000,
    0x4400_0000,
    0x2e00_0000,
    0x1d00_0000,
    0x0980_0000,
    0x3fc0_0000,
    0x73e0_0000,
    0x6ff0_0000,
    0x60a8_0000,
    0xdc54_0000,
    0xf27a_0000,
    0xe36d_0000,
    0xddb1_8000,
    0x628e_4000,
    0x0d40_a000,
    0xaca1_b000,
    0x8c56_8800,
    0xea7c_9c00,
    0x2f69_2600,
    0x47b7_1b00,
    0xf988_bd80,
    0x5dc3_0c40,
    0xb4e6_8e20,
    0xdd70_7710,
    0xffed_b388,
    0x1ff4_3b7c,
    0x88a8_1d8a,
    0xb852_bc41,
    0x2c78_0623,
    0x5668_eb2b,
    0x9036_95a0,
    0x734a_2062,
    0x63a3_201d,
    0xcad6_f01d,
    0xd33d_a819,
    0x45ce_6c03,
    0xb2e6_8e08,
    0xc470_773d,
    0xf86d_b3b8,
    0xcd34_3b73,
    0x5ac8_1d85,
    0xac62_bc7b,
    0x1130_061c,
    0xf8cc_eb2d,
    0x0b64_9585,
    0x73b3_2078,
    0x3f88_a023,
    0x24c5_b038,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x9000_0000,
    0x8800_0000,
    0x8400_0000,
    0xbe00_0000,
    0x8100_0000,
    0x5780_0000,
    0x7340_0000,
    0x23e0_0000,
    0xa490_0000,
    0x48a8_0000,
    0xa5b4_0000,
    0x819a_0000,
    0x7fef_0000,
    0x1852_8000,
    0x540d_4000,
    0x78c7_a000,
    0xc2a7_3000,
    0xcc77_6800,
    0x9cbf_ec00,
    0x44da_2200,
    0x190d_8b00,
    0x3544_f280,
    0x7ee1_4840,
    0x2110_6a20,
    0x10ec_1710,
    0x66d4_1898,
    0x04cb_1f64,
    0x8e63_5282,
    0xc8d6_7871,
    0x4dcf_0217,
    0x3de7_fb14,
    0x9594_3aaf,
    0x6729_9459,
    0x4af5_2025,
    0x107a_7038,
    0x6078_c830,
    0x387c_dc31,
    0x547f_4a1f,
    0xfe79_670b,
    0x497e_50b3,
    0x1bfa_8375,
    0x813b_b899,
    0x5098_2f4a,
    0x806e_3aa5,
    0x1f16_9470,
    0xd1ef_a001,
    0x5153_301f,
    0xe78d_6815,
    0x2580_ec32,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x7000_0000,
    0xb800_0000,
    0x4c00_0000,
    0x7e00_0000,
    0xd100_0000,
    0x7c80_0000,
    0x91c0_0000,
    0xaba0_0000,
    0x7f70_0000,
    0x4588_0000,
    0x2b94_0000,
    0x1f9e_0000,
    0x0f49_0000,
    0xdfb1_8000,
    0x82ae_c000,
    0xad20_e000,
    0x75b3_b000,
    0xd1ac_2800,
    0x66a5_f400,
    0x75f2_3600,
    0x514f_5100,
    0xbeb0_e180,
    0xe62e_b740,
    0x00e7_7e20,
    0x1813_d530,
    0x33d8_1fa8,
    0x21aa_a25c,
    0x1ea6_018e,
    0x99f0_0763,
    0x5f4c_d617,
    0xd7b5_e118,
    0xd6ad_4999,
    0xef25_836b,
    0x62b5_a83b,
    0x302f_3408,
    0xf5e4_d639,
    0x9e91_e106,
    0xf91b_499c,
    0x1588_836b,
    0x2392_2833,
    0x4b9c_f431,
    0x4d4b_b60a,
    0xc8b5_912c,
    0x632e_0180,
    0x3e64_0776,
    0x9ed2_d62f,
    0x79fc_e127,
    0xcd9c_c980,
    0xb04b_4346,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x5000_0000,
    0x2800_0000,
    0x4c00_0000,
    0x9e00_0000,
    0xf100_0000,
    0xe580_0000,
    0x58c0_0000,
    0xb5e0_0000,
    0xcf10_0000,
    0x71b8_0000,
    0xc5b4_0000,
    0xd48e_0000,
    0xf67f_0000,
    0xdcd0_8000,
    0xa2dc_4000,
    0xe8e7_e000,
    0x2491_3000,
    0x907f_a800,
    0x89d7_3c00,
    0xf55e_fe00,
    0x8f20_6b00,
    0xadf3_e280,
    0xae29_2cc0,
    0x8b4e_3620,
    0xbb1e_2730,
    0x0083_5498,
    0xb744_4bd4,
    0xd622_02aa,
    0xc473_1ce3,
    0x08ef_1e1f,
    0x9faa_5b18,
    0xb98a_caab,
    0x65f9_50d1,
    0x5911_a820,
    0x3cb8_3c2c,
    0xa636_7e1a,
    0x4948_2b0f,
    0x5c1a_02ab,
    0x6807_1ccb,
    0xec01_1e01,
    0xae05_5b26,
    0x8902_4ab2,
    0x8181_10c7,
    0x8ac0_4821,
    0xdae2_0c27,
    0xdb97_5613,
    0xccfc_571b,
    0x2893_9cb3,
    0xae7a_07f8,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x9000_0000,
    0xa800_0000,
    0xa400_0000,
    0xc200_0000,
    0x7700_0000,
    0x4080_0000,
    0xc040_0000,
    0xc0a0_0000,
    0xda70_0000,
    0xf1e8_0000,
    0x2514_0000,
    0x1ffa_0000,
    0x846b_0000,
    0x92d2_8000,
    0xbf98_4000,
    0xcefa_a000,
    0xd1e9_d000,
    0x1512_d800,
    0xc7f8_b400,
    0x1869_6a00,
    0x5cd5_5900,
    0xae99_a580,
    0x3b78_8040,
    0x2629_9220,
    0x5577_7d10,
    0x1d6a_37b8,
    0xf354_fd64,
    0x5259_258a,
    0x659f_c079,
    0x85fb_b228,
    0x2f6d_ed29,
    0xfc50_cf82,
    0xfedd_d97d,
    0x53d8_378a,
    0x585b_fd52,
    0x6699_a584,
    0x4f78_8050,
    0xac29_9215,
    0x1677_7d3a,
    0x37ea_378a,
    0xe014_fd40,
    0x1079_25a2,
    0x08af_c048,
    0xf433_b22e,
    0x1049_ed10,
    0xd2e2_cf9f,
    0x85d2_d94e,
    0x2f18_b7ac,
    0x46bc_bd71,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0xb000_0000,
    0x4800_0000,
    0x7400_0000,
    0x4600_0000,
    0xff00_0000,
    0x4680_0000,
    0xea40_0000,
    0xdc60_0000,
    0x0290_0000,
    0x2b88_0000,
    0x9934_0000,
    0xefba_0000,
    0xd10b_0000,
    0x0173_8000,
    0x6adf_4000,
    0xda1d_2000,
    0xce3b_f000,
    0xb1cf_1800,
    0xad57_2400,
    0xc928_5a00,
    0x4484_4f00,
    0x5b41_2280,
    0xf1e3_c540,
    0x5853_e220,
    0xaaac_db10,
    0x7540_c0b8,
    0x6ae0_1e6c,
    0x40d2_a2b2,
    0x33ec_854d,
    0x95a6_c209,
    0x4f33_2b03,
    0x48bd_d8bb,
    0xfb88_3a4b,
    0x2133_7894,
    0x33bc_8a72,
    0x5309_4092,
    0xf074_5e5f,
    0xa75c_0297,
    0x30d8_356f,
    0x071c_fa26,
    0x29bb_ff22,
    0x6e08_9aad,
    0xa7f4_5155,
    0x309b_8012,
    0x4e7b_400d,
    0xb8af_2001,
    0xdc44_f037,
    0xcb66_9809,
    0x6013_6411,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x1000_0000,
    0x6800_0000,
    0xcc00_0000,
    0x7a00_0000,
    0x9d00_0000,
    0x5880_0000,
    0xd3c0_0000,
    0xe4a0_0000,
    0xdd30_0000,
    0x08e8_0000,
    0x53d4_0000,
    0x983e_0000,
    0x786b_0000,
    0x6c12_8000,
    0xf69a_4000,
    0x405d_e000,
    0x987a_1000,
    0xc08c_c800,
    0xdbc2_f400,
    0xf8a3_6600,
    0x2f33_a900,
    0x49ec_c380,
    0x1957_e440,
    0x1afe_ce20,
    0xbe4a_0d30,
    0xffe4_0db8,
    0x4252_e944,
    0x1d7e_43ba,
    0xec0d_a443,
    0x3603_2e06,
    0x2700_1d13,
    0x2580_c5b4,
    0x9b44_1d43,
    0x5f63_259d,
    0xf595_0d53,
    0xafdd_6d92,
    0xc63d_b973,
    0x936b_eb8b,
    0x3390_005a,
    0xf0dd_e03c,
    0x47ba_103e,
    0xbe2c_c81e,
    0x8bf2_f408,
    0xc0cb_6626,
    0x6327_a902,
    0x4f72_c386,
    0x210c_e460,
    0x2684_4e19,
    0xc8c4_4d2f,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xf000_0000,
    0xa800_0000,
    0x3400_0000,
    0x1200_0000,
    0x3700_0000,
    0xc680_0000,
    0x04c0_0000,
    0xbae0_0000,
    0x4e70_0000,
    0xe218_0000,
    0x1dd4_0000,
    0xb2ca_0000,
    0x0a9d_0000,
    0xb811_8000,
    0x63ae_4000,
    0x75ab_2000,
    0x98ac_5000,
    0x8d2a_5800,
    0x056f_8400,
    0x104c_ce00,
    0x045e_3b00,
    0x89f0_9180,
    0x3d5b_a9c0,
    0x1e76_3620,
    0xfa1e_af10,
    0xa1d4_a788,
    0x64cc_06fc,
    0x8799_118a,
    0x7d91_e9dd,
    0xb3ef_162c,
    0xfc8b_ff21,
    0xaabd_7f93,
    0x2584_c2f0,
    0x4045_7fa0,
    0xf120_c2c3,
    0x5e17_7fa5,
    0x26a9_c2e7,
    0x542c_ffb1,
    0x02ea_82f1,
    0xaf0e_5fbe,
    0xd7fc_92e0,
    0x9925_27be,
    0x0a12_46ce,
    0xe4aa_31b8,
    0x3b29_b9e5,
    0x586f_4e16,
    0x8dc9_7b06,
    0x4818_31b1,
    0x26d0_b9c3,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x7000_0000,
    0xc800_0000,
    0x9400_0000,
    0x6a00_0000,
    0xed00_0000,
    0x9f80_0000,
    0x3140_0000,
    0x21a0_0000,
    0x4b50_0000,
    0x2e68_0000,
    0x1334_0000,
    0x1f5a_0000,
    0x356b_0000,
    0x3fb5_8000,
    0xa69b_4000,
    0xef0c_2000,
    0xa780_9000,
    0x2d40_8800,
    0x3fa7_8c00,
    0xbc50_7200,
    0x94e8_7900,
    0x29f4_dc80,
    0x65bf_cc40,
    0xb29b_5a20,
    0xc50b_2510,
    0xaa87_86b8,
    0xc2c0_e95c,
    0xc6e6_dc92,
    0x09f0_cc75,
    0xb5bc_da02,
    0xea9f_6537,
    0xe90c_26ad,
    0x9c84_3975,
    0xd1c5_f480,
    0xde67_905c,
    0x4a35_802e,
    0x3adb_403f,
    0xb12c_2022,
    0xad90_902a,
    0xea88_8824,
    0xf3c3_8c21,
    0xe762_720a,
    0x5fb7_7917,
    0x969b_5cac,
    0xc70f_8c75,
    0x4382_fa38,
    0x8f40_f523,
    0x46a3_2e8e,
    0x49d3_f56a,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0xf000_0000,
    0xb800_0000,
    0x4400_0000,
    0x4600_0000,
    0xf700_0000,
    0xa180_0000,
    0xc9c0_0000,
    0x1d20_0000,
    0xe610_0000,
    0x89b8_0000,
    0x4a74_0000,
    0xa1ca_0000,
    0x4ab9_0000,
    0x55f1_8000,
    0x7b0a_c000,
    0x401c_a000,
    0x3526_7000,
    0x0a17_5800,
    0x63bf_9c00,
    0xf775_8600,
    0x4d4f_bd00,
    0xd7fd_6280,
    0x9196_e2c0,
    0x1f7d_fe20,
    0x5ad1_9110,
    0xc418_9ca8,
    0x9323_73fc,
    0xad17_628e,
    0x8a3f_e2c1,
    0xc2b4_7e19,
    0x526f_5111,
    0x80ee_3cae,
    0x4eac_03df,
    0x3d49_ba98,
    0x2ffe_bec5,
    0x7597_5813,
    0xa97f_9c31,
    0x15d5_8601,
    0x219f_bd34,
    0x1ce5_628f,
    0x4732_e2d9,
    0xcdaf_fe03,
    0x82cc_9112,
    0x053b_1cb8,
    0xc734_b3e3,
    0x8da8_4293,
    0x22ce_52ea,
    0xf53c_0634,
    0x7f31_7d20,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x7000_0000,
    0x4800_0000,
    0xec00_0000,
    0xaa00_0000,
    0x6900_0000,
    0xf680_0000,
    0xbec0_0000,
    0xcce0_0000,
    0x1870_0000,
    0x2d58_0000,
    0x13d4_0000,
    0x228a_0000,
    0x935f_0000,
    0x54d5_8000,
    0xeb0b_4000,
    0x201b_e000,
    0x1d72_9000,
    0x31df_6800,
    0xa411_0400,
    0x68e8_2e00,
    0x7de8_bb00,
    0x596d_3180,
    0x4aab_a3c0,
    0x46cb_2620,
    0x6b7b_6f10,
    0xf946_1798,
    0x10a0_ccdc,
    0x0455_31b2,
    0xa6cf_a3eb,
    0x5b79_2612,
    0xd140_6f16,
    0x8ca1_97b7,
    0xe650_8cc8,
    0x23c9_51ab,
    0x07fd_73f7,
    0x0682_2e24,
    0xb6c7_bb3d,
    0x40e0_b18c,
    0xc274_e3ea,
    0x0c5a_c635,
    0x0956_ff09,
    0x364c_ff84,
    0x36ba_88ce,
    0xba26_ffad,
    0x7895_88f5,
    0xff2b_7fad,
    0x278a_c8f6,
    0x8fda_9f86,
    0xe317_58c4,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x9000_0000,
    0x7800_0000,
    0x8400_0000,
    0x0a00_0000,
    0xfd00_0000,
    0x4080_0000,
    0x9c40_0000,
    0xbee0_0000,
    0xae90_0000,
    0xbd48_0000,
    0xcfb4_0000,
    0xaefe_0000,
    0xdf4f_0000,
    0x0eb6_8000,
    0x007e_c000,
    0x240f_a000,
    0x75d5_1000,
    0xf62d_0800,
    0xb1e5_f400,
    0x5712_1a00,
    0x0b8c_fb00,
    0x8017_6280,
    0x860e_8740,
    0xd4d0_3220,
    0xc8a9_df30,
    0x32a7_5098,
    0xa877_5864,
    0xf7df_62be,
    0xe8fa_8751,
    0xe44e_323a,
    0xb536_df2b,
    0x47b9_d096,
    0x4d2d_9862,
    0xca66_c293,
    0x70d4_9745,
    0xf2ab_ba05,
    0x47a2_eb3f,
    0x84f2_ea92,
    0x9d9a_b37e,
    0x251b_083f,
    0xfd5e_f436,
    0x29ba_9a07,
    0xea2d_3b25,
    0x6fe6_42b4,
    0xb811_5776,
    0xa20c_9a3d,
    0x2ed6_3b08,
    0xddae_c298,
    0x8e20_9757,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x1000_0000,
    0x3800_0000,
    0xbc00_0000,
    0x2a00_0000,
    0xa100_0000,
    0x7580_0000,
    0x14c0_0000,
    0x31a0_0000,
    0xdeb0_0000,
    0xba08_0000,
    0x2154_0000,
    0xd35e_0000,
    0x860d_0000,
    0xcb52_8000,
    0x525e_c000,
    0xe388_6000,
    0xe792_1000,
    0xdffe_2800,
    0x173a_9c00,
    0xfc9f_be00,
    0x8b28_0900,
    0xd0a2_cf80,
    0x4b36_e340,
    0x9ecd_7620,
    0x38f7_4530,
    0x89ef_b988,
    0xaa01_a644,
    0x6102_cfae,
    0x5586_e35f,
    0x04c5_7622,
    0x09a3_451c,
    0x62b1_b99b,
    0x900c_a66e,
    0x8050_4fa8,
    0xa6d8_2340,
    0x92cd_1611,
    0xfaf1_5511,
    0x8cef_91a3,
    0x5986_3a78,
    0xc6c7_f1b4,
    0x0ca4_2a5c,
    0x9131_d99d,
    0x37ca_b649,
    0xd970_6786,
    0x332f_bf59,
    0xaca0_283b,
    0x4137_9c03,
    0x2fcd_3e30,
    0x7576_c901,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0xb000_0000,
    0x1800_0000,
    0xa400_0000,
    0x3200_0000,
    0x7500_0000,
    0xbb80_0000,
    0xc2c0_0000,
    0xa220_0000,
    0xe830_0000,
    0xfda8_0000,
    0xd854_0000,
    0xa5fe_0000,
    0xbdab_0000,
    0xf857_8000,
    0xf5f9_c000,
    0x15ab_a000,
    0x4456_d000,
    0x63ff_4800,
    0x52af_ec00,
    0x8ad3_6e00,
    0x1abf_8500,
    0x324e_bb80,
    0xc0c1_9240,
    0x0f26_0620,
    0x17b0_7930,
    0xbd68_bdb8,
    0x1771_eb6c,
    0x524e_bba6,
    0xb0c1_9259,
    0xf726_0614,
    0x03b0_7901,
    0x9768_bd90,
    0xc671_eb75,
    0xdbce_bb82,
    0x0701_927e,
    0xee86_0605,
    0x2940_7907,
    0xc8e0_bd91,
    0xf615_eb60,
    0x8398_bb83,
    0x62fe_9275,
    0xb32f_8629,
    0x6112_b939,
    0x251c_9db7,
    0x47ba_fb49,
    0xf5cc_53a4,
    0x7407_ae62,
    0x5a03_a03d,
    0x2902_d01d,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x7000_0000,
    0xf800_0000,
    0x4c00_0000,
    0xce00_0000,
    0xad00_0000,
    0xed80_0000,
    0x2f40_0000,
    0xfe60_0000,
    0xb690_0000,
    0x2298_0000,
    0x829c_0000,
    0xd29e_0000,
    0x3a9d_0000,
    0xfe9e_8000,
    0x8499_4000,
    0xab9b_2000,
    0x251d_5000,
    0x4ad8_3800,
    0x767f_5400,
    0x11ce_2e00,
    0x7ba1_dd00,
    0x6d30_6980,
    0x1fab_7d40,
    0x7530_69a0,
    0x63ab_7d50,
    0x2330_69b8,
    0xf2ab_7d4c,
    0xf8b0_6986,
    0x3ceb_7d5f,
    0x2550_69b5,
    0x083b_7d74,
    0x1428_698e,
    0x1377_7d7f,
    0x1a4e_69b1,
    0x1de6_7d52,
    0x14d6_e9b9,
    0x217e_3d72,
    0x934d_498d,
    0xba67_2d7c,
    0x8c90_d1b2,
    0x6d9c_695d,
    0x7c1d_e798,
    0x455f_b054,
    0x4a3b_980a,
    0x572a_4409,
    0x43f5_b62e,
    0x508b_9907,
    0x78c5_dfad,
    0xde20_e45c,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x3000_0000,
    0xc800_0000,
    0x1c00_0000,
    0xba00_0000,
    0xff00_0000,
    0x9980_0000,
    0x1c40_0000,
    0xeca0_0000,
    0x8b90_0000,
    0xd838_0000,
    0x703c_0000,
    0x1c3e_0000,
    0x8e39_0000,
    0x5d38_8000,
    0xb6be_c000,
    0x49fe_2000,
    0x86db_f000,
    0xee0c_0800,
    0x4310_c400,
    0xa4fc_2600,
    0x8c5d_4300,
    0xf9cc_1f80,
    0x60f4_5e40,
    0x284c_1fa0,
    0x20b4_5e50,
    0x9eec_1f98,
    0x6424_5e5c,
    0x1754_1faa,
    0x1458_5e5b,
    0x5dca_1f84,
    0xeef1_5e64,
    0x414a_9fa2,
    0x3433_9e63,
    0xf82a_bf99,
    0xb741_6e41,
    0x9326_37af,
    0x32d3_6a5d,
    0x621a_31a8,
    0xb66c_d97e,
    0x28e2_a63f,
    0x2336_8313,
    0xedac_bf8d,
    0x0904_6e62,
    0x6480_b7ae,
    0x4ec4_aa6e,
    0xff64_918d,
    0xf675_e946,
    0xc58e_8e2f,
    0x1c54_b726,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0xf000_0000,
    0x4800_0000,
    0xe400_0000,
    0x9e00_0000,
    0x8f00_0000,
    0x5280_0000,
    0x0140_0000,
    0xada0_0000,
    0x0c10_0000,
    0x15a8_0000,
    0x2dac_0000,
    0x41aa_0000,
    0x9baf_0000,
    0x7aa8_8000,
    0xef2a_c000,
    0x58ed_e000,
    0x6a09_1000,
    0x44bd_6800,
    0x0f87_fc00,
    0x36c3_f600,
    0xf760_9b00,
    0x2175_fb80,
    0xd5da_d6c0,
    0x6df5_fba0,
    0x9b9a_d6f0,
    0x32d5_fb88,
    0x66ca_d6cc,
    0xc2dd_fb9a,
    0xa376_d6f5,
    0x08df_fbbd,
    0x9a75_d6d6,
    0x615d_7ba9,
    0xefb0_16d6,
    0xeeb8_1b82,
    0x6683_c6d5,
    0xe740_9387,
    0x2ea1_2ade,
    0xd494_0d97,
    0x4de9_4df8,
    0xb98a_8009,
    0x8079_c003,
    0xade7_603f,
    0xa430_d029,
    0xb67a_0806,
    0x56e7_2c16,
    0x70b1_fe19,
    0x643b_b712,
    0x9bc6_05b6,
    0x88e2_61c4,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x1000_0000,
    0xe800_0000,
    0xb400_0000,
    0xb600_0000,
    0x3100_0000,
    0x5e80_0000,
    0x7340_0000,
    0x36e0_0000,
    0x5030_0000,
    0xf4d8_0000,
    0xb0dc_0000,
    0x9eda_0000,
    0x43df_0000,
    0xe75f_8000,
    0x4f18_c000,
    0x147d_6000,
    0xee88_d000,
    0x3071_5800,
    0xcbbf_ac00,
    0xb42e_3600,
    0xd524_8100,
    0xb897_8080,
    0x6e89_e640,
    0xf077_80a0,
    0x6bb9_e670,
    0xa42f_8088,
    0x3d25_e674,
    0x0c95_80b2,
    0xd88a_e659,
    0xc172_009f,
    0x353e_2655,
    0xd76d_6088,
    0x0bc5_f649,
    0x5ca1_b885,
    0x2c51_9a5d,
    0x71af_6eb8,
    0xabe6_0b71,
    0x94b1_561f,
    0xec9f_5121,
    0x13bb_5886,
    0x382d_8a42,
    0x9f21_568b,
    0x9b92_774d,
    0x5f0b_b815,
    0x58b3_bc16,
    0xc698_0e0f,
    0x80bc_fd32,
    0xf1af_6eb3,
    0x6be6_0b7d,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0xd000_0000,
    0x5800_0000,
    0xf400_0000,
    0x5200_0000,
    0xe700_0000,
    0xba80_0000,
    0xadc0_0000,
    0x3160_0000,
    0x3930_0000,
    0xa888_0000,
    0xaa8c_0000,
    0x558e_0000,
    0x7b0d_0000,
    0x54cb_8000,
    0xdaa9_4000,
    0xad1e_e000,
    0xfa54_7000,
    0x86bf_4800,
    0x5084_9c00,
    0x2ec4_f200,
    0xe1e2_f900,
    0x57f4_7080,
    0x296a_d4c0,
    0x2d7c_70a0,
    0x24e6_d4d0,
    0xa272_70b8,
    0x222b_d4e4,
    0x9fd9_f0ae,
    0x35b2_94d9,
    0xc84f_10ba,
    0x826a_e4e0,
    0xa1fe_5894,
    0x0423_78cb,
    0xea91_2a98,
    0x0658_c1c5,
    0xb8f3_ba32,
    0x7fea_652f,
    0x46be_8287,
    0x7085_2de1,
    0x9ec3_802a,
    0x69e5_4033,
    0xfbf0_e02f,
    0x8f69_7014,
    0x987c_c814,
    0x7961_dc30,
    0xb534_1233,
    0xbe8b_8927,
    0x9788_b890,
    0xa40b_08f1,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0xb000_0000,
    0x2800_0000,
    0xcc00_0000,
    0x8600_0000,
    0x3500_0000,
    0xf180_0000,
    0x17c0_0000,
    0xf2e0_0000,
    0x0f70_0000,
    0xb0a8_0000,
    0x26ac_0000,
    0xabaa_0000,
    0xee2d_0000,
    0x2be8_8000,
    0x8e09_c000,
    0x0fff_a000,
    0xea13_9000,
    0xed1e_3800,
    0x5d63_b400,
    0xe9b6_0a00,
    0xa9cd_1d00,
    0x151a_a680,
    0xc963_83c0,
    0x6bb2_a6a0,
    0x66cf_83f0,
    0x7f98_a698,
    0xd622_83dc,
    0xf910_2692,
    0xb99b_43ef,
    0xc327_86b3,
    0x5894_d3e2,
    0x365b_be8f,
    0xd5c6_67e7,
    0x1de7_34b3,
    0x35f3_bae4,
    0x37e8_b21f,
    0x500b_692d,
    0x3ef9_0c95,
    0xe190_0ee6,
    0x61de_b807,
    0xa706_7419,
    0x8683_aa16,
    0xc943_8d0c,
    0x3fa4_1ebe,
    0xcad5_f7c9,
    0xe179_0cb3,
    0xcf50_0ee8,
    0x04be_b82f,
    0x3ab6_743d,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x5000_0000,
    0x2800_0000,
    0xe400_0000,
    0x5a00_0000,
    0xeb00_0000,
    0x4480_0000,
    0xc640_0000,
    0x85a0_0000,
    0x67d0_0000,
    0x30a8_0000,
    0x2eac_0000,
    0xefaa_0000,
    0xd82d_0000,
    0xc6ef_8000,
    0x130e_c000,
    0xa479_e000,
    0x0683_3000,
    0x7140_6800,
    0xb724_4c00,
    0xa495_7e00,
    0x688b_d300,
    0xc4bd_ad80,
    0x8265_08c0,
    0x39b5_ada0,
    0xbf19_08f0,
    0x74b7_ad98,
    0x1698_08e4,
    0x6b72_2d92,
    0x14fb_c8dd,
    0x92c4_4d84,
    0x4be6_38e7,
    0xb675_c595,
    0x757d_44d6,
    0x3902_d3b4,
    0x3b83_dbcf,
    0x40c7_8038,
    0x34e2_c004,
    0x30f3_e023,
    0xc43e_3002,
    0x6e27_e82a,
    0xcf16_8c12,
    0x004e_9e09,
    0x1459_e32a,
    0xe890_4583,
    0x168e_84fd,
    0x95bc_b39b,
    0x7de2_2be6,
    0x9374_0833,
    0x18f8_bc0b,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x3000_0000,
    0xc800_0000,
    0xdc00_0000,
    0xce00_0000,
    0xb100_0000,
    0x2880_0000,
    0xd740_0000,
    0x8fe0_0000,
    0x08f0_0000,
    0xef38_0000,
    0x853c_0000,
    0x2e3a_0000,
    0x05bf_0000,
    0xb57e_8000,
    0xbc58_c000,
    0x188e_2000,
    0x69e0_5000,
    0x35f1_d800,
    0x51be_9c00,
    0xc779_2600,
    0x535a_d900,
    0x7909_de80,
    0x8221_c740,
    0x7f51_dea0,
    0xa9ad_c770,
    0xb933_de88,
    0xc69e_c77c,
    0x8aaf_5eba,
    0x2eb5_074b,
    0x285d_fe89,
    0xca8e_9767,
    0xb6e6_8683,
    0x9c77_9b52,
    0x667e_d8a0,
    0x43db_4e50,
    0x1a49_d81b,
    0x2fc2_9c31,
    0xc0a3_2630,
    0x0315_d900,
    0x0dcf_5eb5,
    0x0105_0763,
    0x2085_fea1,
    0xab42_977e,
    0x71e4_86b7,
    0x71f4_9b4a,
    0x1bba_58be,
    0x9c7c_8e5c,
    0x10d9_7830,
    0x25ca_0c12,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x1000_0000,
    0xa800_0000,
    0xa400_0000,
    0x8600_0000,
    0x8300_0000,
    0x7e80_0000,
    0x6bc0_0000,
    0x9ea0_0000,
    0xc6d0_0000,
    0x6b28_0000,
    0x512c_0000,
    0x682e_0000,
    0x6fad_0000,
    0x63ed_8000,
    0xe108_c000,
    0x0d3d_e000,
    0x2e21_d000,
    0xda11_c800,
    0xc508_3c00,
    0xcb3c_6200,
    0xcd22_1700,
    0xb496_6180,
    0x06ca_98c0,
    0xf19e_61a0,
    0x8df6_98d0,
    0x5cb8_61b8,
    0x2967_98d4,
    0xf273_e192,
    0x7cfe_58fd,
    0xf985_81b3,
    0xa346_48dd,
    0xae62_29ac,
    0x3af6_64c7,
    0x4c39_e38b,
    0x05a4_5ff6,
    0x8454_4811,
    0xfaec_fc22,
    0xd68f_822b,
    0xd97e_c729,
    0xb0c2_29ab,
    0xbc26_64d5,
    0x4711_e3a2,
    0x4488_5fe7,
    0x447a_482d,
    0x3141_fc32,
    0x3362_020a,
    0xbb76_0722,
    0xc37f_c9b9,
    0xf9c7_b4f6,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x1000_0000,
    0xa800_0000,
    0x1c00_0000,
    0x9a00_0000,
    0xdd00_0000,
    0x8080_0000,
    0xa5c0_0000,
    0x08e0_0000,
    0xb850_0000,
    0x4d88_0000,
    0xb88c_0000,
    0xe40a_0000,
    0xfbcb_0000,
    0x3e2b_8000,
    0xaefe_c000,
    0x5ab6_2000,
    0x70de_f000,
    0xf182_1800,
    0xc745_1c00,
    0xe427_b200,
    0xa633_3500,
    0xbf1b_d780,
    0xbc64_cbc0,
    0x5b91_d7a0,
    0x226f_cbf0,
    0x4d5a_57a8,
    0x24c1_0bf4,
    0xf264_7782,
    0xf093_fbf3,
    0x7dec_6fa4,
    0x111d_e7c4,
    0x2760_5d84,
    0xbc10_12ed,
    0xca2d_aa06,
    0xc8fa_2903,
    0x2db6_65b5,
    0x955c_fedd,
    0x60c1_8024,
    0xec65_c017,
    0x1395_a029,
    0x0e6c_300f,
    0x6f5e_383b,
    0x4dc0_ec27,
    0xf4e6_2a2b,
    0x1254_e90f,
    0x2888_4596,
    0x8c0e_0ed6,
    0xc7c9_9828,
    0xb42b_dc20,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x3000_0000,
    0x1800_0000,
    0x5c00_0000,
    0x5a00_0000,
    0x6b00_0000,
    0x9580_0000,
    0xb8c0_0000,
    0x7ea0_0000,
    0x0030_0000,
    0x62e8_0000,
    0xd5ec_0000,
    0xda6a_0000,
    0xa9af_0000,
    0x728e_8000,
    0xd27e_4000,
    0x9234_a000,
    0x1dea_7000,
    0xce6b_2800,
    0x27ac_8400,
    0x378d_c200,
    0x32ff_7700,
    0xd275_5680,
    0x7f0a_71c0,
    0xf6bf_56a0,
    0x1695_71f0,
    0x46d9_d688,
    0x2107_31fc,
    0x1687_768e,
    0xc942_41eb,
    0xf062_de98,
    0x5790_85f1,
    0xc05b_bcbd,
    0xc045_82df,
    0xa2e5_c222,
    0x98d3_771f,
    0x013f_569a,
    0x6955_71da,
    0x4ff9_d6a4,
    0x9ef7_31cc,
    0xdd4f_7696,
    0x935e_41e3,
    0xf9c0_dea2,
    0xf823_85e9,
    0xe177_3ca2,
    0xd688_c2d4,
    0x847d_e215,
    0x2b34_4736,
    0x976c_5e86,
    0xfd2e_c5ec,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x1000_0000,
    0x1800_0000,
    0x9400_0000,
    0xda00_0000,
    0x2500_0000,
    0x7980_0000,
    0xf5c0_0000,
    0x98a0_0000,
    0x69b0_0000,
    0x78e8_0000,
    0xf1ec_0000,
    0x966e_0000,
    0x24ab_0000,
    0x648b_8000,
    0x437b_4000,
    0xe7f7_e000,
    0x448d_3000,
    0x137a_1800,
    0x5ff6_d400,
    0xc088_fa00,
    0xd17a_7f00,
    0xeef2_5280,
    0x630a_65c0,
    0x01bc_52a0,
    0x0fd1_65d0,
    0xff7f_d288,
    0xe1f6_25d4,
    0x978e_328e,
    0x11fc_15f1,
    0x34b1_aab8,
    0x656a_81f8,
    0x762d_30a6,
    0xb7ca_8ec5,
    0x629c_9a00,
    0x82a0_0f1f,
    0xacb1_aabe,
    0xb16a_81f3,
    0x0c2d_3093,
    0x82ca_8eee,
    0x031c_9a24,
    0xe360_0f1f,
    0xee11_aa8d,
    0xfdda_81f2,
    0x0d45_30a9,
    0x86e6_8ec5,
    0x0dd2_9a0f,
    0xae7b_0f37,
    0xf272_2a9c,
    0x4f4d_c1f5,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x5000_0000,
    0xf800_0000,
    0x1c00_0000,
    0x0a00_0000,
    0xc100_0000,
    0xc680_0000,
    0xd8c0_0000,
    0xbae0_0000,
    0xd6b0_0000,
    0xe888_0000,
    0xfd8c_0000,
    0x650e_0000,
    0x62cb_0000,
    0x61a9_8000,
    0x865e_4000,
    0x1d76_a000,
    0x59ea_f000,
    0x677a_f800,
    0x62a3_cc00,
    0xc796_8a00,
    0x3f5c_1d00,
    0x87f4_8880,
    0x2b2f_fcc0,
    0x4c9a_88a0,
    0x8a94_fcd0,
    0xebdb_0888,
    0x7236_bcc4,
    0xf54b_a8b6,
    0x67eb_4cc3,
    0x087e_d0b4,
    0xd321_c0f3,
    0x42d1_7a85,
    0xa2fe_6dc5,
    0xe9e6_2a2b,
    0x7d31_ed30,
    0xf4c9_f0b1,
    0xeaa9_70df,
    0x21db_22a0,
    0x5330_51c3,
    0xc3cd_d82e,
    0x172b_7c31,
    0x569c_d235,
    0x1392_2100,
    0x615f_7ab7,
    0x58f5_6dca,
    0x92af_aa07,
    0x7ddf_ad11,
    0xf937_50b8,
    0x52cf_80e5,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x1000_0000,
    0x8800_0000,
    0xec00_0000,
    0xc200_0000,
    0xe900_0000,
    0xc280_0000,
    0x9540_0000,
    0x7ea0_0000,
    0x65f0_0000,
    0x0f18_0000,
    0xa41c_0000,
    0xcf9e_0000,
    0xb85f_0000,
    0x43bf_8000,
    0xd0eb_c000,
    0x5604_a000,
    0x3f06_b000,
    0xbd83_f800,
    0x08c4_ec00,
    0x6660_c600,
    0x8b97_7300,
    0x688b_3c80,
    0x0e91_5440,
    0x280d_3ca0,
    0x52d2_5450,
    0x842c_bca8,
    0x2a66_9454,
    0x1997_9c8a,
    0x298b_e46f,
    0x3010_c4ba,
    0xf749_b855,
    0x2973_fa8a,
    0xe15a_2770,
    0x5938_0015,
    0x01ac_0029,
    0x16a6_0036,
    0xf9f3_0010,
    0x7519_800d,
    0x3918_c03a,
    0xab1d_203f,
    0xea1e_7035,
    0xd49e_d81a,
    0x0bda_9c00,
    0x707e_1e05,
    0x150d_ef27,
    0x6655_2283,
    0x7e6c_bb5c,
    0x4140_1e3a,
    0x88a2_ef26,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xb000_0000,
    0x3800_0000,
    0xa400_0000,
    0xd600_0000,
    0x3500_0000,
    0x3780_0000,
    0x1f40_0000,
    0xbd20_0000,
    0x7810_0000,
    0xeef8_0000,
    0xf5fc_0000,
    0x337e_0000,
    0x5dbf_0000,
    0x42da_8000,
    0x2c6b_4000,
    0xd7c6_6000,
    0x92e4_d000,
    0x2ef7_7800,
    0x860f_c400,
    0xcef6_be00,
    0x560c_9700,
    0x66f5_7780,
    0x7a0e_3040,
    0x2cf3_77a0,
    0x3d0d_3050,
    0xf877_f7a8,
    0x20c9_707c,
    0x6d93_17a6,
    0xfaba_e055,
    0x465c_0f93,
    0x99ae_f458,
    0x6e27_499e,
    0x0296_e75f,
    0x423a_e031,
    0x319c_9001,
    0xfb4d_982a,
    0x58d3_542c,
    0x909b_262e,
    0x62cf_c317,
    0xf696_51b0,
    0x7c3d_f375,
    0x089b_2610,
    0x36cf_c30c,
    0x3896_51be,
    0x5d3d_f356,
    0xd11b_2604,
    0xb88f_c308,
    0x6436_51b5,
    0x0f6d_f373,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x3000_0000,
    0xf800_0000,
    0x7400_0000,
    0xea00_0000,
    0x0300_0000,
    0xb680_0000,
    0xf2c0_0000,
    0x8e60_0000,
    0x84b0_0000,
    0xb8c8_0000,
    0x19cc_0000,
    0xe04a_0000,
    0x5a09_0000,
    0xffa8_8000,
    0xb8ff_4000,
    0xb4c4_e000,
    0x8367_b000,
    0x7331_a800,
    0x438f_1c00,
    0xb5ed_0a00,
    0x8558_b900,
    0xb794_3c80,
    0x9d5b_2ac0,
    0x3396_3ca0,
    0xef5e_2af0,
    0x7494_bcb8,
    0x4bd8_6afc,
    0xf150_dc86,
    0x993c_9ae1,
    0x8427_94bc,
    0x1911_36e1,
    0xeb99_b691,
    0xcff0_d3dd,
    0x2cec_e032,
    0x68db_b03c,
    0xd7d3_a83c,
    0xc3fa_1c0a,
    0xb647_8a1c,
    0xfba2_f910,
    0xce52_5c9d,
    0x89ba_dae3,
    0x8be3_f4aa,
    0xf8f5_c6f3,
    0xd06e_fe83,
    0xc91d_7fd3,
    0x2732_c233,
    0x398a_550e,
    0x1eee_feaa,
    0x8fdd_7fdf,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xd000_0000,
    0xb800_0000,
    0x0c00_0000,
    0x0200_0000,
    0xa700_0000,
    0xed80_0000,
    0x9fc0_0000,
    0xe260_0000,
    0xf010_0000,
    0x6048_0000,
    0x694c_0000,
    0xb1ce_0000,
    0xfc8f_0000,
    0xb0a9_8000,
    0x871c_4000,
    0x5e24_2000,
    0x48b0_3000,
    0xc8bf_0800,
    0xe355_6400,
    0x7169_1a00,
    0x387c_c900,
    0xc8b6_a980,
    0x88bb_fbc0,
    0xc350_a9a0,
    0xa168_fbd0,
    0x807f_29a8,
    0xc4b7_bbe4,
    0x8abc_8986,
    0x6454_cbe7,
    0x4cee_2186,
    0x1fbd_dfce,
    0x26d4_13bd,
    0x7aa8_42e9,
    0x041a_a805,
    0x25a5_1415,
    0xae74_323d,
    0xda5a_9d1f,
    0xca07_3b99,
    0x8301_16d4,
    0x7b82_ba3b,
    0xe6c3_b926,
    0x12e2_0184,
    0x2951_eff9,
    0xf26d_1b8b,
    0x43fe_26c1,
    0x2e74_3209,
    0x9a5a_9d2d,
    0xea07_3b96,
    0x5301_16c8,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x3000_0000,
    0x2800_0000,
    0xbc00_0000,
    0x8200_0000,
    0x7b00_0000,
    0x8980_0000,
    0xc3c0_0000,
    0x0be0_0000,
    0x0770_0000,
    0xed38_0000,
    0xf83c_0000,
    0x70be_0000,
    0x45fb_0000,
    0x225a_8000,
    0x800b_c000,
    0xad26_2000,
    0x0c16_3000,
    0x530f_e800,
    0xd8a2_a400,
    0xedd3_3a00,
    0x13ed_2500,
    0x7e50_7e80,
    0x7f2d_c740,
    0x6236_7ea0,
    0x729a_c750,
    0x5e6a_fe88,
    0x7b96_075c,
    0x89c8_5e82,
    0xb1c0_f773,
    0xb8e3_16a2,
    0xa2f3_a36d,
    0xb4ff_e480,
    0x1cdd_125d,
    0xc04f_c802,
    0x9203_941c,
    0x2300_5219,
    0xbd83_4132,
    0xcdc1_e4ad,
    0xdae6_126f,
    0x49f5_480f,
    0x2578_5430,
    0x4b1e_720c,
    0xf5a9_7131,
    0x6c70_0c98,
    0x3cbf_b654,
    0x0ffc_f22b,
    0x755e_b130,
    0x9388_2c85,
    0x81e2_8663,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0xf000_0000,
    0x6800_0000,
    0x8400_0000,
    0xba00_0000,
    0xed00_0000,
    0xe980_0000,
    0x6bc0_0000,
    0x5820_0000,
    0xfad0_0000,
    0x7e18_0000,
    0x379c_0000,
    0x6c5a_0000,
    0x7c7b_0000,
    0xf2ac_8000,
    0x5eb7_c000,
    0x002f_e000,
    0x3ff0_3000,
    0xc54c_5800,
    0x8647_9400,
    0x49e3_0a00,
    0x6ff6_2b00,
    0x9d4d_cd80,
    0x4a40_6540,
    0x87e1_4da0,
    0x50f7_a570,
    0x1dce_ada8,
    0x7207_954c,
    0x5902_f5b2,
    0x1b80_016d,
    0xf2c1_ff9c,
    0x63a6_2a56,
    0xf814_3226,
    0x75ba_4f0c,
    0x4b8f_7f90,
    0xa3e6_ea42,
    0xdaf5_5227,
    0xb8ca_bf03,
    0xef82_478e,
    0xe0c1_8e71,
    0x2aa3_602e,
    0x5b97_f030,
    0x9b7b_b808,
    0x7e2b_a433,
    0x88f5_5229,
    0x11ca_bf10,
    0x9c02_47bc,
    0x9601_8e78,
    0xf303_603d,
    0x4e87_f017,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x1000_0000,
    0x9800_0000,
    0x1c00_0000,
    0xca00_0000,
    0xe700_0000,
    0x4d80_0000,
    0xb840_0000,
    0xaca0_0000,
    0xd0f0_0000,
    0x4018_0000,
    0xfd9c_0000,
    0xadda_0000,
    0x357f_0000,
    0xbb8f_8000,
    0x5293_4000,
    0xd38f_a000,
    0xa693_f000,
    0x2d8b_c800,
    0x1f96_2400,
    0xc908_a600,
    0xdb56_6300,
    0xbd6d_1480,
    0xb5c5_dc40,
    0x74e2_94a0,
    0xcc56_9c70,
    0x18ed_3488,
    0x3985_6c74,
    0x8646_fcae,
    0xb5a3_4873,
    0x2476_5a9c,
    0x1cd9_2b4a,
    0x95f9_4e0f,
    0x094f_f724,
    0x1bf6_5a84,
    0x8f99_2b60,
    0x86d9_4e1c,
    0x8aff_f72b,
    0xe8ce_5a99,
    0xe1b5_2b55,
    0x403b_4e2b,
    0xcdac_f70b,
    0x5fa3_da90,
    0x1375_6b46,
    0x6959_6e3f,
    0x21bf_4711,
    0xf7ea_32b9,
    0x3000_ff48,
    0x4800_2009,
    0x2400_b007,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x9000_0000,
    0x7800_0000,
    0xc400_0000,
    0x5a00_0000,
    0xa300_0000,
    0xd880_0000,
    0xbf40_0000,
    0xfde0_0000,
    0x0c90_0000,
    0x50e8_0000,
    0x146c_0000,
    0xe52e_0000,
    0x39cb_0000,
    0x1adf_8000,
    0x0ff4_4000,
    0x3e3e_6000,
    0xa8e2_b000,
    0xd114_a800,
    0xaa29_ec00,
    0xe74a_5600,
    0xa89e_d900,
    0x3b94_8d80,
    0x4a6f_62c0,
    0xfc2b_0da0,
    0x724b_22d0,
    0x951d_6d88,
    0xf155_92f4,
    0x514f_c596,
    0x0d9b_7ec5,
    0xee14_1380,
    0x3caa_e7ed,
    0x7909_7e36,
    0x7aff_7502,
    0x72c6_bba9,
    0x3f24_0bd1,
    0x9bb2_a835,
    0xd75e_ec20,
    0xcd33_d61a,
    0xa91d_992b,
    0x2f53_6dbc,
    0x084e_92d5,
    0xe618_45ad,
    0xf1d3_3ed9,
    0xba0c_73ae,
    0xd27f_57d3,
    0x8584_5614,
    0xeec5_d921,
    0x7123_0dbe,
    0xbab7_22c3,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x9000_0000,
    0x9800_0000,
    0xa400_0000,
    0x3e00_0000,
    0x5900_0000,
    0x2e80_0000,
    0x9bc0_0000,
    0x0d20_0000,
    0x2e90_0000,
    0x89c8_0000,
    0x394c_0000,
    0x4b8a_0000,
    0x802d_0000,
    0x9979_8000,
    0x1f95_4000,
    0xcb4c_6000,
    0x408f_9000,
    0x15ac_5800,
    0x7f3e_ac00,
    0x58f2_3200,
    0xa0bf_bb00,
    0x61b0_1f80,
    0x445a_69c0,
    0x8901_9fa0,
    0x9683_29f0,
    0x4fc7_ff98,
    0x3b21_b9d4,
    0x4b92_27be,
    0x3d4a_55fd,
    0xc58c_75b1,
    0x312a_7eeb,
    0x1bf8_323a,
    0x8652_bb0d,
    0x0569_9f99,
    0x279f_29f6,
    0x7025_ffa3,
    0xfe10_b9ec,
    0xab09_a7af,
    0x8aee_15c1,
    0x66db_95a0,
    0xa0c1_aef9,
    0xb0a3_8a16,
    0x84d7_c719,
    0x5ca8_15bb,
    0x09b9_eedb,
    0x8736_6a14,
    0x039d_1722,
    0x8e20_2d82,
    0x4714_d2e0,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x1000_0000,
    0x5800_0000,
    0xb400_0000,
    0xfe00_0000,
    0x5500_0000,
    0xc280_0000,
    0x6dc0_0000,
    0x67a0_0000,
    0x1dd0_0000,
    0xf8e8_0000,
    0xf46c_0000,
    0xc4ae_0000,
    0x2d8b_0000,
    0x079b_8000,
    0x6bd1_4000,
    0xa1e8_e000,
    0xcce9_1000,
    0x4a6c_b800,
    0x31af_2c00,
    0xff0e_0200,
    0x325a_5f00,
    0xb870_e180,
    0x423e_7ec0,
    0x6103_61a0,
    0x7c83_3ed0,
    0x98c5_8188,
    0xb521_2ed4,
    0x2812_b99e,
    0x2b4f_42f9,
    0x17bc_5ba1,
    0x6940_0dec,
    0x1b66_0211,
    0xaef6_5f37,
    0x21fe_e1a8,
    0xbba5_7ee0,
    0x5fd0_e19e,
    0x1fee_7ec9,
    0x39eb_6191,
    0x98ef_3eeb,
    0x046b_81b9,
    0x2caa_2ec9,
    0xd189_399e,
    0x159e_02f4,
    0x74d4_bba5,
    0xc869_1de4,
    0x36aa_ba3d,
    0x8289_7312,
    0x2618_e3bc,
    0x7d93_21e4,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0xf000_0000,
    0x6800_0000,
    0xa400_0000,
    0x0200_0000,
    0xcf00_0000,
    0xd980_0000,
    0x9240_0000,
    0x26e0_0000,
    0x6bd0_0000,
    0x5588_0000,
    0x360c_0000,
    0xf74a_0000,
    0x5629_0000,
    0x5ebe_8000,
    0xf555_c000,
    0x8a4c_e000,
    0x88ae_f000,
    0x217d_8800,
    0xdbf7_c400,
    0xc47b_9600,
    0xc976_c100,
    0x1db9_af80,
    0x2ad3_ebc0,
    0x450f_2fa0,
    0x20ca_2bf0,
    0xcd69_cfb8,
    0x9cdd_dbcc,
    0x7242_c7a2,
    0x16e3_dfe5,
    0x63d7_b1a2,
    0x018e_eed6,
    0x5c0f_1614,
    0x9c4a_0132,
    0x8dab_cfbd,
    0x03f8_dbd8,
    0x0a36_4790,
    0x73df_1fd9,
    0xfbc5_d1af,
    0x7ca5_ded9,
    0x7936_7e22,
    0xa45f_353e,
    0x6087_d196,
    0xbec0_defb,
    0xfe22_fe19,
    0x38f3_f53f,
    0x8bfd_b196,
    0x9e37_eeff,
    0x79d9_961b,
    0x60c3_c13b,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x3000_0000,
    0x6800_0000,
    0xc400_0000,
    0x2a00_0000,
    0x1f00_0000,
    0x6280_0000,
    0xc7c0_0000,
    0xb060_0000,
    0xb8f0_0000,
    0xdee8_0000,
    0x126c_0000,
    0x40aa_0000,
    0xdd49_0000,
    0x98f8_8000,
    0x9db3_c000,
    0x6949_e000,
    0x7afa_b000,
    0x16b7_4800,
    0x79ca_dc00,
    0x0e3c_2200,
    0x2a51_c100,
    0x33fd_f680,
    0x1d32_69c0,
    0x258d_76a0,
    0xda1d_a9f0,
    0xda86_96b8,
    0x9bc2_19fc,
    0x5663_5ea2,
    0x79f2_05cd,
    0xe16e_1ca8,
    0x6c2a_b4ca,
    0x7f8d_4230,
    0x0d18_b13b,
    0x2c03_5ebc,
    0x2e02_05e5,
    0x5506_1cb3,
    0x4d86_b4dd,
    0xcd47_4221,
    0xb3a1_b117,
    0x2293_deb7,
    0x791d_c5f6,
    0xae05_fc87,
    0x9505_04e2,
    0x2d80_8a34,
    0xfd44_ad1e,
    0xdba4_1c9c,
    0xe693_b4f8,
    0x531d_c21d,
    0xb107_7106,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x3000_0000,
    0x3800_0000,
    0xac00_0000,
    0x1200_0000,
    0x8d00_0000,
    0x4280_0000,
    0x90c0_0000,
    0x8460_0000,
    0x05d0_0000,
    0x1de8_0000,
    0x596c_0000,
    0x3aaa_0000,
    0x434b_0000,
    0x29da_8000,
    0x5a13_4000,
    0xbe0a_2000,
    0x0af8_b000,
    0x85e3_d800,
    0x9095_4c00,
    0x7acf_8a00,
    0x109a_0900,
    0x2f30_5780,
    0x7af8_80c0,
    0x5de2_d7a0,
    0x2c97_c0f0,
    0x60ca_f7a8,
    0x0998_70fc,
    0xd3b1_afa6,
    0x7539_7cd7,
    0x1604_85a2,
    0xfb03_85f4,
    0x6987_aa32,
    0xd145_b910,
    0xf123_0fb3,
    0x72f5_8ce1,
    0x5c1d_fd9c,
    0xd8f6_39cb,
    0xbd1b_5814,
    0xa871_0c3c,
    0x90dd_2a34,
    0x5696_f912,
    0xa9c9_2f87,
    0xdd1d_3cdb,
    0x7876_25b9,
    0xb8df_75c1,
    0xf296_d20d,
    0x2fcc_053d,
    0xee1d_fdb1,
    0xa5f6_39da,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x1000_0000,
    0x7800_0000,
    0xcc00_0000,
    0x2e00_0000,
    0xd500_0000,
    0xbe80_0000,
    0xd4c0_0000,
    0x5760_0000,
    0x8d50_0000,
    0x6ad8_0000,
    0x1e5c_0000,
    0xa59a_0000,
    0x8b7d_0000,
    0xff6d_8000,
    0xc996_4000,
    0x85bc_2000,
    0xbf0f_5000,
    0xf140_f800,
    0x3826_8c00,
    0x2875_6a00,
    0xb82d_7100,
    0xf8b2_8b80,
    0x454f_c540,
    0xcae7_0ba0,
    0xce15_8570,
    0xf1f9_2b98,
    0x61ab_d574,
    0x31f6_5386,
    0x916a_1947,
    0x3c90_998d,
    0xcb3f_7872,
    0x03c9_4a22,
    0x1222_2107,
    0x5772_7397,
    0xb9a9_4954,
    0xcdf2_6195,
    0x3768_f467,
    0x4d93_a01a,
    0xefb8_1032,
    0xe00b_5810,
    0x00c2_9c36,
    0x6564_322d,
    0xee52_ed1d,
    0xdd5b_39b5,
    0x221b_6876,
    0x3f38_121b,
    0xc1cd_bd39,
    0x1923_c1a1,
    0x54f1_e44c,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x9000_0000,
    0xc800_0000,
    0x8c00_0000,
    0x8600_0000,
    0x8d00_0000,
    0x1180_0000,
    0x6640_0000,
    0xb1e0_0000,
    0x16d0_0000,
    0x3368_0000,
    0x63ec_0000,
    0xf22a_0000,
    0x988f_0000,
    0x763b_8000,
    0x71c5_c000,
    0x9aa5_a000,
    0x16b7_9000,
    0xd3fe_f800,
    0x2966_f400,
    0x0b11_8600,
    0xdfcb_6900,
    0x005a_6f80,
    0xe453_5cc0,
    0x15ab_efa0,
    0x4bc9_9cf0,
    0xa25d_cf88,
    0x5357_ccd4,
    0x572c_97ba,
    0xf509_a8f7,
    0x6e78_699b,
    0x9921_f5d4,
    0x5ff6_201f,
    0xc49e_500d,
    0x1b71_5813,
    0x375e_6438,
    0x66d4_fe37,
    0x0b68_5d04,
    0x17ee_49b9,
    0xa02f_a5c1,
    0xd78f_7825,
    0xe0bc_340e,
    0x0d07_a60f,
    0xd185_3906,
    0xc643_378d,
    0x21e1_38ce,
    0xded5_11b0,
    0xbf6e_c1d1,
    0xe5e8_0601,
    0x7f2d_a910,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0xb000_0000,
    0x7800_0000,
    0x8400_0000,
    0x3600_0000,
    0xb500_0000,
    0x2e80_0000,
    0x15c0_0000,
    0xdc20_0000,
    0xdb70_0000,
    0x2a48_0000,
    0x05cc_0000,
    0xb08a_0000,
    0x2869_0000,
    0x87bc_8000,
    0xae47_4000,
    0xf767_6000,
    0xba90_d000,
    0x611e_7800,
    0x3ef6_8c00,
    0x980f_e200,
    0x30ac_2300,
    0x911b_c880,
    0xe6f2_72c0,
    0xcc0d_48a0,
    0xceac_32f0,
    0xd81e_a8b8,
    0x7a77_a2dc,
    0x5acd_b0a6,
    0x8908_fefd,
    0x3828_aaab,
    0x99d9_11d0,
    0x5851_e020,
    0xc8be_9015,
    0x3fc5_9837,
    0xab21_1c13,
    0x6ef6_fa25,
    0x900a_7f3e,
    0xacaa_5297,
    0x9318_ddd5,
    0x1df1_621b,
    0xd38e_6323,
    0xc3ea_2895,
    0xa4fc_e2d4,
    0x53a0_d09c,
    0xbe31_2ed0,
    0x7aaa_52bb,
    0x5618_ddfd,
    0x2b71_622b,
    0xf24e_6307,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x3000_0000,
    0xc800_0000,
    0xfc00_0000,
    0xde00_0000,
    0x8900_0000,
    0xa080_0000,
    0xccc0_0000,
    0x5820_0000,
    0x60b0_0000,
    0xe338_0000,
    0x1ebc_0000,
    0x00fa_0000,
    0x9b1f_0000,
    0x8e0e_8000,
    0x8bc0_c000,
    0x49a3_2000,
    0x98f3_d000,
    0x65da_9800,
    0xb92a_1c00,
    0x56f4_3a00,
    0xd4d8_1b00,
    0x8dae_6e80,
    0x8830_7f40,
    0x13fa_eea0,
    0x389f_bf70,
    0xd94f_4e88,
    0x10a0_af7c,
    0xa074_f6ba,
    0x0d1a_6343,
    0x3b0e_d48d,
    0x5547_a461,
    0x3c61_2025,
    0xa850_d012,
    0x35ae_1813,
    0xdc35_dc3a,
    0xa1f9_9a03,
    0x979b_0b31,
    0xc4cf_d6b1,
    0x5ee5_b368,
    0x6396_4c85,
    0x1c0e_b858,
    0xd4c1_9a17,
    0x3c27_0b01,
    0x1ab5_d68a,
    0xb03a_b378,
    0xdd38_cc98,
    0xc7be_7854,
    0xf87a_ba09,
    0x53d8_db10,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x1000_0000,
    0x2800_0000,
    0xe400_0000,
    0xc600_0000,
    0x3b00_0000,
    0xcd80_0000,
    0xbd40_0000,
    0xab60_0000,
    0xf710_0000,
    0x7378_0000,
    0xe3fc_0000,
    0x783a_0000,
    0xab9b_0000,
    0xbeab_8000,
    0x7fa2_c000,
    0xc731_e000,
    0x2409_d000,
    0x9215_0800,
    0x99f9_e400,
    0xb93e_4e00,
    0x671b_b500,
    0xef6a_fd80,
    0x9506_5e40,
    0xf283_7da0,
    0x86c3_9e70,
    0x1523_1da8,
    0x5df3_8e74,
    0x1b2c_75a2,
    0xc6e1_7a4d,
    0x9a56_d393,
    0xd01a_fb43,
    0xe0ef_6820,
    0xe542_f42c,
    0x9762_a62a,
    0xcd17_8121,
    0x527b_bbbe,
    0x1f7f_0f5d,
    0x11fc_4e0a,
    0x8d3c_b53e,
    0xa91b_7dbc,
    0x206f_9e5b,
    0xb681_1d9c,
    0x90c4_8e70,
    0x2625_f5a1,
    0x6474_ba58,
    0x486e_b39b,
    0xb286_eb61,
    0x66c2_0016,
    0x2527_0032,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0xb000_0000,
    0x5800_0000,
    0x5400_0000,
    0x3200_0000,
    0x9300_0000,
    0x7780_0000,
    0x71c0_0000,
    0x58a0_0000,
    0x3b90_0000,
    0xe038_0000,
    0x06bc_0000,
    0x0bfa_0000,
    0xa11f_0000,
    0x31ea_8000,
    0x79e0_4000,
    0x8776_e000,
    0x29c9_7000,
    0x4e34_e800,
    0x9928_d400,
    0xe1c6_9a00,
    0x70a4_7f00,
    0x9790_7380,
    0x363b_0a40,
    0xffb8_f3a0,
    0xbb78_4a70,
    0x955e_9388,
    0x8b8e_7a5c,
    0x6d56_1b9e,
    0x2d1f_9e49,
    0x97ea_8992,
    0x78e6_456d,
    0xd3f2_880f,
    0x778e_e431,
    0x3356_1239,
    0xc819_9b0f,
    0xa96e_e1a9,
    0xe1a1_d162,
    0xeb10_721d,
    0xc47f_ab2f,
    0x54de_6995,
    0x134c_3549,
    0x6d76_e037,
    0x2ec9_7016,
    0xabb4_e820,
    0xcbe8_d413,
    0x96e6_9a0f,
    0x6ef4_7f0f,
    0x1d08_73b9,
    0x9817_0a49,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0xf000_0000,
    0x2800_0000,
    0xd400_0000,
    0xb600_0000,
    0xcd00_0000,
    0xaa80_0000,
    0x0fc0_0000,
    0x5a60_0000,
    0x61d0_0000,
    0xdef8_0000,
    0x977c_0000,
    0xa33a_0000,
    0xae19_0000,
    0x396e_8000,
    0x47a7_c000,
    0xa8b5_6000,
    0x6cae_d000,
    0xaac7_b800,
    0x84e7_6c00,
    0x4813_5200,
    0x919b_a100,
    0xa02f_df80,
    0x1006_a040,
    0x1803_5fa0,
    0x9c04_6070,
    0x9202_bfb8,
    0x5304_704c,
    0xb386_e7b2,
    0x1346_0c79,
    0x98a5_6d9f,
    0x9131_114a,
    0xb0ea_d835,
    0x13e5_bc09,
    0x5596_ea03,
    0xd3d9_cd21,
    0x0008_0dac,
    0xddf3_c178,
    0x410f_602e,
    0xfd77_d016,
    0x81c9_3835,
    0x8690_ac38,
    0xa05e_3227,
    0x7349_7129,
    0xb552_67bc,
    0xf838_cc56,
    0x999e_8dbe,
    0x2428_0157,
    0x1e00_001a,
    0xd900_001f,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0xf000_0000,
    0x5800_0000,
    0x5400_0000,
    0xc600_0000,
    0x4f00_0000,
    0x1f80_0000,
    0x9440_0000,
    0xfae0_0000,
    0xe2d0_0000,
    0xa4b8_0000,
    0xe63c_0000,
    0xa4fe_0000,
    0x7ad9_0000,
    0x192e_8000,
    0x69e4_4000,
    0x6752_e000,
    0xa5fe_d000,
    0x765f_a800,
    0x48ea_d400,
    0x7243_b600,
    0xe5e5_4100,
    0xb554_a780,
    0xccfe_5a40,
    0xd6dc_27a0,
    0x9b2f_1a50,
    0x48e6_4798,
    0x3bd0_8a6c,
    0xbc3b_8f8e,
    0x91f9_ce79,
    0x005b_f1bf,
    0xbfec_cb6a,
    0xc9c1_a838,
    0xefa3_d40f,
    0x54b5_3626,
    0xf7ad_0127,
    0xa920_47b7,
    0x9875_8a62,
    0x9a8b_0fa8,
    0x1f54_8e79,
    0xa1ff_91a7,
    0xf85a_5b4c,
    0xfbea_e02f,
    0xa7c2_d015,
    0xaca1_a81d,
    0xd933_d43c,
    0xeaed_3617,
    0x0341_0125,
    0xf166_47bb,
    0x5090_8a65,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x1000_0000,
    0x4800_0000,
    0x5400_0000,
    0x5a00_0000,
    0xaf00_0000,
    0xe280_0000,
    0x6cc0_0000,
    0xe7e0_0000,
    0xa590_0000,
    0xd978_0000,
    0xcafc_0000,
    0x59ba_0000,
    0xbb19_0000,
    0x7529_8000,
    0x31e3_c000,
    0x8c95_6000,
    0xfaf9_b000,
    0xa1bb_c800,
    0xd71a_5c00,
    0x2328_7a00,
    0xd8e5_6500,
    0xcf14_d980,
    0x81bb_ca40,
    0x671f_59a0,
    0x1b2d_0a70,
    0xd4e1_b9b8,
    0x8912_7a74,
    0x20bc_91aa,
    0x709b_5661,
    0x3a6b_c3bc,
    0xbd42_1f4a,
    0xa7a3_c804,
    0xbbb6_5c11,
    0xc68a_7a1d,
    0x7050_6508,
    0x951f_59b3,
    0x302d_0a7e,
    0x4461_b997,
    0x0ed2_7a75,
    0x37dc_9184,
    0x42cb_5656,
    0xbc73_c38d,
    0x11ee_1f66,
    0x2201_c80a,
    0x0303_5c11,
    0xd481_fa2c,
    0x95c6_a53e,
    0xec61_b9a8,
    0x8ad2_7a5d,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0xf000_0000,
    0x7800_0000,
    0x8400_0000,
    0xf200_0000,
    0x7900_0000,
    0x7d80_0000,
    0x6bc0_0000,
    0x8ce0_0000,
    0xce90_0000,
    0x8338_0000,
    0xe1bc_0000,
    0xb4fe_0000,
    0xcb5d_0000,
    0x196a_8000,
    0x40e1_4000,
    0xe091_6000,
    0x1c3c_f000,
    0x9f38_3800,
    0x27be_5400,
    0x27fd_ca00,
    0xbbda_0d00,
    0x8528_2980,
    0x5ac3_d840,
    0x2d64_a9a0,
    0x4353_9850,
    0x0cd9_49b8,
    0xd7af_286c,
    0x5784_91a6,
    0x46c1_cc4d,
    0xeb62_839a,
    0xd054_2553,
    0x7c58_3805,
    0x4bee_5409,
    0x4da5_ca06,
    0x8b36_0d2a,
    0xb40e_29be,
    0x43b2_d86e,
    0x8c48_29ad,
    0x3b93_d86d,
    0xb0bc_a98f,
    0xe57f_985f,
    0x3e9f_49b6,
    0x128e_2863,
    0x84f0_118e,
    0x7aed_8c47,
    0xec21_63b8,
    0x06f5_954b,
    0x3bef_6017,
    0x75a1_f01c,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x9000_0000,
    0xf800_0000,
    0x3c00_0000,
    0x8e00_0000,
    0x1d00_0000,
    0xac80_0000,
    0x61c0_0000,
    0x90e0_0000,
    0xaf90_0000,
    0x0ac8_0000,
    0x314c_0000,
    0x330e_0000,
    0x4daf_0000,
    0xca9b_8000,
    0xf664_4000,
    0x2151_a000,
    0x85af_d000,
    0xde9a_3800,
    0x9c61_dc00,
    0x1e50_1200,
    0x422b_f500,
    0x32d8_3980,
    0x4fc7_e7c0,
    0x5de5_b9a0,
    0xdb10_a7d0,
    0xc709_99a8,
    0xd7a8_37f4,
    0xbd9f_8196,
    0x65e1_7bfb,
    0x8711_8bb5,
    0xf90f_c2fc,
    0xa2a9_b81e,
    0xd519_9c24,
    0xb627_b21a,
    0x84f7_251f,
    0xe71f_8190,
    0x6521_7bf7,
    0x1571_8b82,
    0xba5f_c2fb,
    0x6c01_b81b,
    0x1605_9c25,
    0x9101_b226,
    0x4a84_2503,
    0xb8c2_019e,
    0x8e66_3bec,
    0x5d55_abae,
    0x2bab_52f7,
    0x5399_a021,
    0xc8e3_d03f,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x1000_0000,
    0xb800_0000,
    0x7400_0000,
    0xbe00_0000,
    0x9700_0000,
    0xa380_0000,
    0xb5c0_0000,
    0x50e0_0000,
    0x6570_0000,
    0x5cd8_0000,
    0xaa5c_0000,
    0x691a_0000,
    0x3abd_0000,
    0xec6d_8000,
    0x7660_4000,
    0xfe37_e000,
    0x6b7c_1000,
    0x7a8b_a800,
    0x1010_3400,
    0xaf6b_5a00,
    0x5be0_fd00,
    0x94f6_e680,
    0x441a_9840,
    0xd839_66a0,
    0x412b_d870,
    0xeac1_0698,
    0xef66_8874,
    0x42b2_ceb6,
    0x413b_ec69,
    0xfdaa_5c99,
    0xc086_754c,
    0x6844_2831,
    0x9221_7421,
    0x8613_3a05,
    0x346d_ad08,
    0xd265_2eaa,
    0x1837_fc66,
    0x9879_f4be,
    0xdf0a_4145,
    0x46d5_7212,
    0xe20c_8939,
    0x1c50_5c8b,
    0x3b4b_7563,
    0x3ef1_a836,
    0xbd1d_342f,
    0xb4be_da14,
    0x336c_bd17,
    0x09e3_0686,
    0x39f7_886d,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x7000_0000,
    0x4800_0000,
    0x7400_0000,
    0x9e00_0000,
    0x5b00_0000,
    0x3f80_0000,
    0xe340_0000,
    0xa1a0_0000,
    0x5230_0000,
    0xa618_0000,
    0xb55c_0000,
    0x1cfe_0000,
    0xdac9_0000,
    0x92d2_8000,
    0x348c_c000,
    0x63f1_6000,
    0xc47c_9000,
    0xac0c_c800,
    0xf531_f400,
    0xd39f_8e00,
    0x031a_1300,
    0xe1da_4a80,
    0x683f_8e40,
    0x9c2b_2aa0,
    0xb743_1e50,
    0xefa7_e298,
    0xd132_ea4c,
    0xd598_6c8a,
    0xf418_f951,
    0x0c5a_262d,
    0x727b_7707,
    0xb30f_0c82,
    0xfcb1_696f,
    0x6fda_6e32,
    0x4b3f_4337,
    0x7fab_6291,
    0xce07_2a4b,
    0xc303_8cbb,
    0x9384_a97a,
    0x3141_8e1d,
    0x58a3_1318,
    0xdcb0_cab7,
    0xbfdf_4e5e,
    0x933c_4aad,
    0x33aa_8e78,
    0x6c07_aaba,
    0x7206_de4e,
    0x6904_0295,
    0xb682_ba5d,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0xb000_0000,
    0x6800_0000,
    0x9400_0000,
    0xb200_0000,
    0x4900_0000,
    0x4a80_0000,
    0x7740_0000,
    0xeea0_0000,
    0xd0f0_0000,
    0x1068_0000,
    0xb72c_0000,
    0x618e_0000,
    0x5d7b_0000,
    0xb316_8000,
    0x0339_c000,
    0x4733_6000,
    0xdc8d_f000,
    0xf5f9_3800,
    0xf552_ac00,
    0xeb1a_7600,
    0xae84_f300,
    0x4d41_4c80,
    0x23a2_63c0,
    0xf072_2ca0,
    0xd22f_93d0,
    0x350b_1488,
    0x3d3d_3ffc,
    0xa031_6292,
    0xe909_ccd9,
    0xeb38_2e3e,
    0x9337_af0b,
    0xce8c_028c,
    0x0cff_3cc6,
    0xd7d7_963f,
    0x085c_c30e,
    0xf225_14a9,
    0xd4b6_3ffa,
    0x794f_e28f,
    0x301c_0ce6,
    0x5d05_4e2f,
    0xb881_5f20,
    0x9e43_ba81,
    0x1424_50d9,
    0xcfb6_8035,
    0x6ac9_c00e,
    0xd5db_6028,
    0x38e1_f02f,
    0xa0d7_382e,
    0xa5d9_ac32,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x7000_0000,
    0x2800_0000,
    0xec00_0000,
    0x6e00_0000,
    0xff00_0000,
    0x6f80_0000,
    0x72c0_0000,
    0xfd60_0000,
    0x0ed0_0000,
    0x8368_0000,
    0x89ac_0000,
    0x00ca_0000,
    0x041f_0000,
    0x8a74_8000,
    0xd559_c000,
    0xdbd4_a000,
    0x51e8_d000,
    0xa5eb_a800,
    0x6fe9_1400,
    0xc2ea_2200,
    0x646b_1900,
    0x4229_c780,
    0x200d_48c0,
    0x307d_67a0,
    0xd025_98f0,
    0xc976_cf88,
    0x4cdc_8cec,
    0x3214_ed82,
    0x310b_95d7,
    0x60ff_2a19,
    0x6d65_dd28,
    0x36d4_cda2,
    0x976a_85c4,
    0x53a8_2215,
    0x55c8_192b,
    0x169f_47b7,
    0x0637_88de,
    0xca7f_47ae,
    0x3527_88f7,
    0x53f7_47ae,
    0x5c9b_88c6,
    0x6b35_47ad,
    0xccf8_88c9,
    0x6363_c79b,
    0x19d2_48d0,
    0xa0e9_e7af,
    0xe56c_58f5,
    0x2aaa_6f82,
    0x8948_5ce8,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x7000_0000,
    0xd800_0000,
    0x2c00_0000,
    0xbe00_0000,
    0x4100_0000,
    0xa280_0000,
    0xd0c0_0000,
    0x7160_0000,
    0xed90_0000,
    0x7658_0000,
    0x6a9c_0000,
    0xb5fe_0000,
    0x916f_0000,
    0xc1b4_8000,
    0x31ee_4000,
    0x2671_2000,
    0x070b_d000,
    0x83a5_5800,
    0xdbf2_0c00,
    0x044b_aa00,
    0x7884_f100,
    0xcbc6_4580,
    0x88e3_bb40,
    0xe4d7_65a0,
    0x7e78_6b50,
    0x572a_3da8,
    0xd216_674c,
    0x221f_979e,
    0x863d_9647,
    0x458d_5231,
    0x4360_6d17,
    0x2293_17b9,
    0x6ddf_d673,
    0x44da_720d,
    0x7258_bd04,
    0x609c_cf8e,
    0x46fc_9a59,
    0xbcec_7812,
    0x2af5_dc2a,
    0x1ec8_f23b,
    0xd445_fd05,
    0xaca7_6f97,
    0xd076_0a4c,
    0xa20c_8027,
    0x3b22_4024,
    0x7037_2025,
    0xdca8_d017,
    0x3457_d81d,
    0x41bf_4c1f,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xb000_0000,
    0xd800_0000,
    0x8400_0000,
    0xc600_0000,
    0xaf00_0000,
    0x1980_0000,
    0xe440_0000,
    0x2960_0000,
    0x73b0_0000,
    0x8128_0000,
    0x096c_0000,
    0xfa0e_0000,
    0x44bf_0000,
    0x0512_8000,
    0x86b8_4000,
    0x2c12_6000,
    0x103b_5000,
    0x61d4_a800,
    0x0518_2400,
    0xbf07_6600,
    0x3180_7d00,
    0x9844_c880,
    0xdb65_25c0,
    0xc2b6_a8a0,
    0xb3ae_75d0,
    0x32aa_00a8,
    0x982a_51fc,
    0x07eb_669e,
    0x13c9_2cdd,
    0x279b_2e2f,
    0xacc7_4936,
    0x2fa3_6689,
    0x2915_2cdf,
    0x7cbd_2e2b,
    0x5114_493f,
    0x08bf_e695,
    0x6f12_6ce0,
    0x93bd_ce04,
    0x6897_5907,
    0x5cf9_2eac,
    0x9e71_18e9,
    0x640e_0004,
    0x2fbf_003e,
    0xfa92_801f,
    0x7df8_402e,
    0xc4f2_602d,
    0x03cb_5032,
    0x0f9c_a81f,
    0xd0c4_2419,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x5000_0000,
    0x6800_0000,
    0x9400_0000,
    0x3e00_0000,
    0x6300_0000,
    0x8880_0000,
    0x6640_0000,
    0xe460_0000,
    0xf050_0000,
    0xab98_0000,
    0xe3dc_0000,
    0x6cba_0000,
    0x706f_0000,
    0xbbb5_8000,
    0x230a_c000,
    0x9d64_6000,
    0x7dd2_9000,
    0x2a58_0800,
    0x7b7c_8c00,
    0xbfcc_de00,
    0x8e40_ed00,
    0xb067_a780,
    0x6e51_1740,
    0x989b_c7a0,
    0x035f_8770,
    0x9ef9_cf88,
    0xaa0c_0b64,
    0x28e0_9192,
    0x0016_2641,
    0x18fb_561d,
    0xf509_a119,
    0xaa62_999f,
    0x6b55_aa70,
    0x7f1a_082e,
    0x7f9f_8c28,
    0xbddb_5e16,
    0xffb9_2d11,
    0xc0ec_47b0,
    0x21f6_4764,
    0x6d6a_2f89,
    0x3037_5b78,
    0x3dcb_7992,
    0x2741_fa4e,
    0x95e4_6033,
    0xdb92_9028,
    0x6e38_083b,
    0xdb2c_8c3b,
    0x7c54_de02,
    0xf99c_ed01,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x7000_0000,
    0xb800_0000,
    0x4c00_0000,
    0xd600_0000,
    0x5500_0000,
    0x8d80_0000,
    0x82c0_0000,
    0x3fa0_0000,
    0x1c30_0000,
    0x0d28_0000,
    0x21ec_0000,
    0x274e_0000,
    0x70fd_0000,
    0x6216_8000,
    0x05df_4000,
    0x2663_2000,
    0xe710_9000,
    0x6058_b800,
    0x40a5_9400,
    0x8ab3_a200,
    0x0b6a_4f00,
    0x0f08_5680,
    0x271c_0bc0,
    0x49c3_76a0,
    0x5320_9bd0,
    0xe975_ceb8,
    0x4348_0fcc,
    0x62f8_ec96,
    0x7511_00df,
    0x375d_9a23,
    0x1220_9b0a,
    0xcef0_d4a0,
    0x9a8a_d4fa,
    0xb9dd_9817,
    0x0864_0431,
    0x9e13_9a02,
    0x4bdd_9b26,
    0x2f66_5488,
    0x7495_94e0,
    0x439e_b808,
    0x6884_9417,
    0x9743_2220,
    0xe164_0f10,
    0x3d93_f6a1,
    0xb01e_dbe0,
    0x3b46_6ebd,
    0x0766_dfe7,
    0xb093_f4a2,
    0x019a_44d2,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x7000_0000,
    0x6800_0000,
    0x2400_0000,
    0x6600_0000,
    0x5100_0000,
    0x2b80_0000,
    0x9ac0_0000,
    0x07a0_0000,
    0xaf30_0000,
    0xa4b8_0000,
    0xc07c_0000,
    0x1ada_0000,
    0x7c6f_0000,
    0x0514_8000,
    0xd04b_c000,
    0xf0e0_e000,
    0xd354_d000,
    0xefae_d800,
    0x0536_4400,
    0x77b9_7200,
    0x7cff_1f00,
    0x8a9a_7e80,
    0xa28a_7f40,
    0x1342_9ea0,
    0xba62_af70,
    0x6a16_4688,
    0x86cb_eb6c,
    0xd3a3_b492,
    0x6133_3465,
    0x71bb_2a0b,
    0xfdfe_9b31,
    0xb919_eca1,
    0x744e_b067,
    0x56e2_b828,
    0x2255_5420,
    0xb42d_4a13,
    0xf7f2_8b35,
    0x5419_54be,
    0xb5c8_e46b,
    0x7f21_7216,
    0x4973_1f14,
    0x9358_7eb0,
    0xc1a9_7f55,
    0xc034_1ebb,
    0xf23a_6f4c,
    0xe338_26a3,
    0xa8bb_fb56,
    0xe279_0ca6,
    0xfdda_605e,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xf000_0000,
    0x4800_0000,
    0xb400_0000,
    0x4600_0000,
    0xdb00_0000,
    0xc880_0000,
    0x43c0_0000,
    0x7720_0000,
    0x2890_0000,
    0xd5f8_0000,
    0xc43c_0000,
    0x9e1e_0000,
    0xcd0f_0000,
    0xd7b0_8000,
    0x296e_c000,
    0x87c5_6000,
    0x3920_5000,
    0x6792_0800,
    0xab78_8c00,
    0x14fe_f200,
    0x95ba_9b00,
    0xe05b_9780,
    0xae68_1440,
    0x0d46_f7a0,
    0x8fe4_4450,
    0x4732_ffa8,
    0x06af_c86c,
    0x9ae2_8dba,
    0x80b4_9341,
    0x1bec_fa2b,
    0xcd02_1737,
    0xeb85_65b9,
    0x5742_8f77,
    0x36e5_600c,
    0x8ab0_5011,
    0x5aea_0803,
    0xdc84_8c21,
    0xb5c0_f22f,
    0xc425_9b35,
    0xa413_17ab,
    0x983a_d474,
    0xdc1d_9794,
    0x380b_1446,
    0x8030_779f,
    0xac29_847b,
    0xdc21_1f87,
    0xe812_587b,
    0x023b_6589,
    0x051d_8f6e,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0xb000_0000,
    0x4800_0000,
    0xb400_0000,
    0x2200_0000,
    0xdb00_0000,
    0x5480_0000,
    0xd140_0000,
    0xb960_0000,
    0x6450_0000,
    0x5aa8_0000,
    0xd0ec_0000,
    0x7d0e_0000,
    0x2819_0000,
    0x7bd4_8000,
    0x876a_c000,
    0x14c9_6000,
    0xce3d_7000,
    0x13e1_2800,
    0xe810_4c00,
    0x564b_2600,
    0xa679_5d00,
    0xc502_3780,
    0xb985_dec0,
    0x2cc5_57a0,
    0x1fa1_aed0,
    0xa4f0_ff98,
    0xc0db_22fc,
    0xae72_b98a,
    0x1c9f_0fd1,
    0x5a91_a602,
    0x960a_9d27,
    0x749f_d7b7,
    0xfe92_6ec3,
    0xac0d_1f81,
    0xe39c_92e6,
    0x7412_f1bd,
    0x304e_33d3,
    0xf77d_a838,
    0x4e86_8c02,
    0x5644_461b,
    0x2be1_2d31,
    0xb411_9f9d,
    0x904a_52c3,
    0xa77d_9193,
    0xb686_43e9,
    0xaa46_003f,
    0xbde5_0024,
    0x4d12_8028,
    0x1fcf_c028,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x7000_0000,
    0xa800_0000,
    0xac00_0000,
    0x4a00_0000,
    0x2100_0000,
    0x9180_0000,
    0x59c0_0000,
    0x08e0_0000,
    0xb530_0000,
    0xdbe8_0000,
    0xcb2c_0000,
    0x5e4e_0000,
    0x68b9_0000,
    0x42b2_8000,
    0xa92b_c000,
    0x9348_a000,
    0x533f_f000,
    0x4a72_7800,
    0x984c_3400,
    0xd3b8_da00,
    0xca32_ad00,
    0x156c_dc80,
    0x8c6f_47c0,
    0x29ea_7ca0,
    0xde29_b7d0,
    0x61ca_8498,
    0x867e_43cc,
    0x18d2_feb2,
    0x595f_1ee7,
    0xc202_5a20,
    0x5d05_6d2f,
    0xe382_7ca4,
    0x0cc5_b7e9,
    0xd764_84be,
    0x2bf7_43c8,
    0x2988_7e9a,
    0x9758_decd,
    0x4504_fa35,
    0x4783_9d34,
    0x7ac2_84b3,
    0x6462_43d0,
    0x9f74_fea9,
    0x07ca_1ef3,
    0xad7e_da1d,
    0x4857_ad3d,
    0xe118_5c90,
    0x3b21_87d4,
    0x4cd6_5cbc,
    0xc758_87d5,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0xd000_0000,
    0xf800_0000,
    0xd400_0000,
    0x4a00_0000,
    0x0f00_0000,
    0x4a80_0000,
    0xed40_0000,
    0x44e0_0000,
    0xd750_0000,
    0xaa78_0000,
    0xe03c_0000,
    0x025a_0000,
    0xc649_0000,
    0xbdd7_8000,
    0x373c_4000,
    0xecd8_e000,
    0x290f_b000,
    0x0a32_4800,
    0xcced_5c00,
    0x3ae1_5600,
    0x8256_8100,
    0x77f9_9380,
    0x43f8_ac40,
    0x19fb_73a0,
    0x8efe_1c70,
    0xc07e_bbb8,
    0x9f3f_0044,
    0x00df_0d86,
    0xd70a_3171,
    0x9f36_d614,
    0x716a_c132,
    0x4921_73a6,
    0x61f7_1c79,
    0xeb49_3b8f,
    0x7453_4048,
    0xbeff_ed83,
    0x2879_8171,
    0xd33e_9e2f,
    0x4ede_9d36,
    0x6a0f_a5a0,
    0x0eb1_dd73,
    0x9caa_4820,
    0xef81_5c33,
    0xb8c3_561f,
    0x7b23_813c,
    0x7af4_138f,
    0x8bcd_ec57,
    0x4614_13a3,
    0x489d_ec46,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x5000_0000,
    0x9800_0000,
    0xb400_0000,
    0xa200_0000,
    0xdf00_0000,
    0x6080_0000,
    0x6dc0_0000,
    0xffe0_0000,
    0xf270_0000,
    0x18a8_0000,
    0x026c_0000,
    0x010a_0000,
    0x60bb_0000,
    0x86f1_8000,
    0x4769_4000,
    0x9a8e_e000,
    0x77fc_f000,
    0x2fd1_8800,
    0x1078_cc00,
    0x7690_c200,
    0x505c_8d00,
    0x6c01_7680,
    0xf601_0fc0,
    0x0d05_96a0,
    0x7786_fff0,
    0x2145_9ea8,
    0x8427_73e4,
    0x7093_bc8e,
    0x555b_0ec9,
    0x1781_4226,
    0x9145_cd3e,
    0x6c27_969e,
    0x0c91_ffd5,
    0xdb5e_1e89,
    0xde85_33cd,
    0x8cc4_dca1,
    0xbe62_bef4,
    0xfe34_2a2f,
    0xbb0a_f136,
    0xcbbf_5c9e,
    0x6470_fefb,
    0xa5ab_4a37,
    0x9def_4125,
    0x5c48_348b,
    0x6a98_c2d4,
    0x3f60_0036,
    0x0fb0_0026,
    0x5f48_0032,
    0x141c_0037,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x3000_0000,
    0x5800_0000,
    0xfc00_0000,
    0x4600_0000,
    0x3d00_0000,
    0x7f80_0000,
    0x8cc0_0000,
    0x3960_0000,
    0xbaf0_0000,
    0x68f8_0000,
    0x953c_0000,
    0x8dde_0000,
    0x9ae9_0000,
    0xc2f0_8000,
    0x04fe_4000,
    0x5b3f_a000,
    0x24d8_9000,
    0x076f_f800,
    0xc937_4400,
    0x391a_0200,
    0x2f88_1900,
    0x8603_1680,
    0x9d00_c540,
    0xaf82_b6a0,
    0xe4c1_5550,
    0x9d65_ce98,
    0x00f4_515c,
    0x13fe_6c8e,
    0xd7bd_d863,
    0x7e9a_021f,
    0x2f48_192c,
    0x4163_16a0,
    0xd6f0_c55f,
    0xa6fa_b6b6,
    0x3c3d_556d,
    0x105b_ce82,
    0x912d_517b,
    0xff16_eca6,
    0x704f_986d,
    0xf9e3_a218,
    0xbeb5_8900,
    0x61da_6ebf,
    0x14ec_c154,
    0x8bf1_94b2,
    0xa97a_9c71,
    0x08f8_002b,
    0xe53c_000a,
    0x35de_003e,
    0x56e9_002a,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x9000_0000,
    0x6800_0000,
    0xc400_0000,
    0x5e00_0000,
    0xb900_0000,
    0x7780_0000,
    0x3740_0000,
    0xbfa0_0000,
    0xe330_0000,
    0x3fe8_0000,
    0x7dac_0000,
    0x5f8e_0000,
    0x34fb_0000,
    0x4637_8000,
    0x6a68_c000,
    0xa1e8_e000,
    0x24ad_1000,
    0x1809_5800,
    0xfbbd_2400,
    0x5591_fe00,
    0x135c_d300,
    0x7902_f280,
    0x9786_79c0,
    0x0744_12a0,
    0x47a0_69d0,
    0x4f32_ca88,
    0xa5e9_8df4,
    0x9aad_d492,
    0x910f_4ec5,
    0x743f_fe05,
    0xced7_d32b,
    0x36fd_72b8,
    0x7d32_b9f6,
    0x66ea_f29f,
    0x3a2a_79fa,
    0x90ca_12a2,
    0x275b_69f0,
    0x3f05_4ab8,
    0xb281_4de2,
    0x12c5_34a3,
    0x3be2_5edb,
    0xa416_a639,
    0xe11a_f727,
    0xe324_8cbf,
    0xf0f2_6aee,
    0x7f8e_003a,
    0xe4fb_000c,
    0x8e37_8030,
    0x3e68_c03b,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x3000_0000,
    0xc800_0000,
    0x9400_0000,
    0xfe00_0000,
    0xdf00_0000,
    0x1980_0000,
    0x5940_0000,
    0x3c60_0000,
    0xefd0_0000,
    0xd6c8_0000,
    0x7c8c_0000,
    0xdb6a_0000,
    0x08fd_0000,
    0x22d4_8000,
    0x724e_c000,
    0x6948_6000,
    0xb6ce_9000,
    0x8c8e_e800,
    0xf369_e400,
    0xacf9_ce00,
    0x14d3_7d00,
    0x3949_0b80,
    0x8ecb_89c0,
    0x308b_6ba0,
    0xa968_19f0,
    0x45f9_0398,
    0x4653_3dfc,
    0x878a_adaa,
    0x34ef_d0d9,
    0xfabb_ce15,
    0xc932_7d2e,
    0xd3df_8bb3,
    0x0e64_49c8,
    0x82d5_8ba4,
    0x6249_49cf,
    0x7149_0b9b,
    0xdacb_89f9,
    0x2e8b_6ba0,
    0x4668_19e9,
    0x9479_0391,
    0x8b13_3dd4,
    0x45ea_ad82,
    0x043f_d0d4,
    0x35f3_ce1b,
    0xecfe_7d0c,
    0x34d5_8b93,
    0xe949_49e4,
    0x76c9_0bbb,
    0x6c8b_89e5,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x9000_0000,
    0xf800_0000,
    0x9400_0000,
    0xe200_0000,
    0x1f00_0000,
    0xc180_0000,
    0xd040_0000,
    0x9b60_0000,
    0x6070_0000,
    0xacf8_0000,
    0x41bc_0000,
    0xa45e_0000,
    0xa5e9_0000,
    0x2a35_8000,
    0xfc9e_4000,
    0xe24c_e000,
    0x57e6_f000,
    0x46b1_8800,
    0xaa5e_c400,
    0x8ce8_2600,
    0xf6b1_cd00,
    0x6259_e680,
    0x90ec_5540,
    0xe8b3_06a0,
    0xf35f_a550,
    0x3869_0e98,
    0x0476_2174,
    0x66f8_48a6,
    0xd2bf_5c51,
    0x83dc_c61e,
    0x70ab_3d16,
    0xfbd6_6e8e,
    0x6f2b_9172,
    0x1a96_a0b0,
    0x2ccc_285e,
    0xfe22_081d,
    0x7995_840f,
    0x234f_4612,
    0xa760_7d14,
    0x4e71_0ea8,
    0xb5fa_217c,
    0x153e_4898,
    0xc69a_5c70,
    0x594f_4604,
    0xfc60_7d31,
    0x75f1_0e8b,
    0x7eba_2174,
    0x55de_48b6,
    0xfdaa_5c6d,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x9000_0000,
    0xb800_0000,
    0xec00_0000,
    0xee00_0000,
    0xdd00_0000,
    0x2480_0000,
    0x2e40_0000,
    0xfae0_0000,
    0xb450_0000,
    0x5018_0000,
    0x955c_0000,
    0x0a3a_0000,
    0x52ab_0000,
    0xcf17_8000,
    0x8a7e_4000,
    0x954b_2000,
    0xefc3_5000,
    0xdc24_3800,
    0xaef2_5c00,
    0x53a8_8e00,
    0xed97_c900,
    0x0d3c_3380,
    0xd92d_1f40,
    0xfed5_13a0,
    0x6359_4f70,
    0x6b3c_aba8,
    0x002e_5354,
    0x4050_8586,
    0x0218_8a6f,
    0x3e59_ae3d,
    0x8fbf_9918,
    0x0e6f_8b94,
    0x2ab1_0363,
    0x0e4e_bd82,
    0x8241_d65a,
    0xf4e6_a030,
    0xd956_1020,
    0x5c98_9807,
    0xef1f_4c08,
    0xf2df_960e,
    0xd5fa_c532,
    0x668a_85b2,
    0x15e3_8a54,
    0x4bd6_2e34,
    0xf3dd_d930,
    0xf77e_ab97,
    0xe1c9_5365,
    0x5985_059d,
    0x5ac1_ca67,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xd000_0000,
    0x3800_0000,
    0x8400_0000,
    0x6a00_0000,
    0xb300_0000,
    0x2180_0000,
    0x2e40_0000,
    0xc0a0_0000,
    0x70f0_0000,
    0x9198_0000,
    0x4edc_0000,
    0xc0fe_0000,
    0xa1cf_0000,
    0xefb1_8000,
    0x3fbc_4000,
    0xffee_6000,
    0xb686_3000,
    0xf5c0_2800,
    0x45e4_6400,
    0xc5d1_f600,
    0x9d2e_0300,
    0x28e6_8c80,
    0xb554_b440,
    0x6dee_eca0,
    0xe181_8450,
    0x4e41_44a8,
    0x30a6_a064,
    0x98f7_52a6,
    0x2d9e_d345,
    0xa0d9_963c,
    0x19fb_3329,
    0x3349_2494,
    0xe073_9072,
    0xd158_fa8c,
    0x4fb9_f74a,
    0x57ef_802e,
    0x2a83_400c,
    0xcbc7_e02a,
    0xa4e6_7039,
    0xd350_480b,
    0xf8ed_5425,
    0x7500_5e02,
    0x2486_273e,
    0xa2c1_1ab1,
    0xfe60_874c,
    0xb096_483c,
    0xc00e_540b,
    0x9857_de25,
    0x3d69_6739,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0xb000_0000,
    0xf800_0000,
    0x9400_0000,
    0x2e00_0000,
    0xd700_0000,
    0x8680_0000,
    0x5940_0000,
    0x19e0_0000,
    0x2850_0000,
    0x83d8_0000,
    0xd79c_0000,
    0xe1fa_0000,
    0xa96b_0000,
    0x3096_8000,
    0xcdfd_4000,
    0xf36b_e000,
    0x5995_9000,
    0xd47b_a800,
    0x40af_dc00,
    0xa331_7600,
    0x1ccc_e900,
    0xbaa2_2380,
    0x28b4_d140,
    0x6a0b_c3a0,
    0xc386_4170,
    0x1ac4_eba8,
    0xc323_dd5c,
    0xcb72_fd96,
    0xf8ac_e479,
    0xd736_161d,
    0xa2cf_390c,
    0x25a4_eb9c,
    0xc233_dd6a,
    0x894a_fdb2,
    0x2360_e47c,
    0x6314_1624,
    0x9f38_3900,
    0x5c48_6b89,
    0x28e5_9d4a,
    0xd5d7_9d87,
    0xc618_3446,
    0xde3c_5e2a,
    0x79ce_7505,
    0x4920_b5ac,
    0x0a71_a84a,
    0x1d28_481e,
    0x96f6_4c2d,
    0xcd68_de35,
    0x0694_351b,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0xd000_0000,
    0x9800_0000,
    0x6c00_0000,
    0xd600_0000,
    0x3700_0000,
    0x2d80_0000,
    0x11c0_0000,
    0xd3e0_0000,
    0x7170_0000,
    0x02c8_0000,
    0x1e8c_0000,
    0xacaa_0000,
    0x2639_0000,
    0x7187_8000,
    0x4fc7_4000,
    0x70e2_2000,
    0x36f7_9000,
    0x6a08_a800,
    0xbbe9_0400,
    0x379c_ea00,
    0xd1d7_c500,
    0xe01f_7680,
    0x8110_ccc0,
    0x997a_d6a0,
    0x8420_1cf0,
    0xad90_5eb8,
    0x823e_88c4,
    0x9384_1c9e,
    0xa2c0_49df,
    0x6c67_802b,
    0xa5b7_4012,
    0xe9aa_2000,
    0xdebb_9026,
    0xa0c2_a82c,
    0x9160_040e,
    0x4133_6a0a,
    0xc6ec_8512,
    0x131f_5694,
    0x9e92_5cd6,
    0xfdbf_fea3,
    0x2747_58f1,
    0x99a1_1493,
    0x3455_9dd4,
    0xc5db_e22f,
    0x88f7_1126,
    0xd90e_949c,
    0x046e_dde6,
    0xe35b_c20b,
    0x3ab5_8115,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0xf000_0000,
    0x1800_0000,
    0x4c00_0000,
    0x4600_0000,
    0xf700_0000,
    0x1880_0000,
    0x8440_0000,
    0xbe60_0000,
    0xcf50_0000,
    0xc038_0000,
    0xa4fc_0000,
    0x62de_0000,
    0x2ded_0000,
    0x6982_8000,
    0x4bc6_4000,
    0xb2a6_2000,
    0x1d77_1000,
    0xe50f_2800,
    0xa193_2c00,
    0xb71b_6e00,
    0x0449_ad00,
    0xba76_ef80,
    0x3588_6a40,
    0xe1d2_4fa0,
    0xeb79_3a50,
    0x2e1b_47b8,
    0x9fcd_066c,
    0xbcb7_01be,
    0x56ab_877f,
    0x2b64_802f,
    0x72d7_4002,
    0xc1fa_a009,
    0xc75c_5033,
    0x602b_883e,
    0x4c22_7c3c,
    0xbe32_6608,
    0xcbed_9106,
    0x4e82_a981,
    0xdb42_eb70,
    0x92e7_ce3d,
    0xb114_fd13,
    0xd759_e786,
    0xc82d_564b,
    0x7822_89b1,
    0x4434_fb75,
    0x62ec_660b,
    0xed00_912d,
    0x0180_298e,
    0x5fc4_ab6d,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x7000_0000,
    0xb800_0000,
    0x6400_0000,
    0xd600_0000,
    0x8b00_0000,
    0xf180_0000,
    0x7dc0_0000,
    0x9fa0_0000,
    0x0f30_0000,
    0xf638_0000,
    0x4e7c_0000,
    0x121e_0000,
    0x4589_0000,
    0x3702_8000,
    0x7383_4000,
    0x78c2_6000,
    0xf123_d000,
    0xed74_0800,
    0xfb5e_4400,
    0xf96a_8a00,
    0x1dd2_c700,
    0x93ed_e680,
    0x1990_5b40,
    0x4d8d_06a0,
    0x4b00_cb50,
    0x5183_6e98,
    0xedc1_5f4c,
    0x57a3_ecb6,
    0xd334_dc55,
    0x443e_0003,
    0x1379_0037,
    0x689a_801f,
    0xc9cf_4038,
    0xd564_6000,
    0xe316_d027,
    0x81c8_8813,
    0x4964_042d,
    0xb112_6a22,
    0xacce_571e,
    0x8be5_8e93,
    0x5954_cf5d,
    0x98a9_048a,
    0x9073_0872,
    0x51d8_6234,
    0x5d29_1303,
    0x53b5_8480,
    0x0979_485c,
    0xd998_8204,
    0x5949_8328,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0xd000_0000,
    0x1800_0000,
    0x3c00_0000,
    0x1600_0000,
    0xc500_0000,
    0x4380_0000,
    0xd1c0_0000,
    0x7b20_0000,
    0x1130_0000,
    0xacb8_0000,
    0xb0fc_0000,
    0x231a_0000,
    0x7c89_0000,
    0x05c7_8000,
    0x3923_4000,
    0x5634_a000,
    0xc83f_1000,
    0xd5bb_b800,
    0x257f_6400,
    0x57db_0a00,
    0x942e_e300,
    0xdd30_8280,
    0xd2ba_1b40,
    0xe1fb_a2a0,
    0x829a_4b70,
    0x5a4e_bab8,
    0xd263_3f44,
    0x6951_88be,
    0xd6ed_f84b,
    0x8094_a03b,
    0xe1cf_103a,
    0x2fa3_b80b,
    0x7c73_643e,
    0xeed9_0a0d,
    0x61ab_e30e,
    0x79f5_02a0,
    0x221c_5b6d,
    0x050a_828d,
    0x7f03_1b73,
    0x2884_2284,
    0xdb45_0b7d,
    0x3760_1a89,
    0x5ad5_2f44,
    0xaf2d_b092,
    0x0fb1_dc50,
    0xc2fb_0a1f,
    0x6c1e_e31e,
    0x5c08_8297,
    0x9a86_1b50,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x3000_0000,
    0xc800_0000,
    0xbc00_0000,
    0xbe00_0000,
    0x1500_0000,
    0x3880_0000,
    0x4cc0_0000,
    0x7d20_0000,
    0xbf90_0000,
    0x0938_0000,
    0x1b7c_0000,
    0xbb9a_0000,
    0x2baf_0000,
    0xf6c6_8000,
    0xc224_c000,
    0x0017_2000,
    0x2e7f_d000,
    0x731a_f800,
    0x0f6b_7c00,
    0x07e1_fa00,
    0x0bb2_6300,
    0xa02f_7780,
    0xb382_1a40,
    0x9146_d7a0,
    0x6165_0a70,
    0x0271_0f88,
    0xbd8e_a67c,
    0x04d4_8dba,
    0x2f5f_7953,
    0xd28f_2015,
    0x2353_d016,
    0xec18_f83b,
    0x40e8_7c35,
    0x48a5_7a0c,
    0xefd5_a316,
    0x62dc_d7bc,
    0x36ca_0a7f,
    0xeab7_8f9d,
    0x5aaa_6640,
    0xf443_ad86,
    0xf1e0_a96f,
    0x62b5_d82b,
    0x86a8_ac24,
    0xda41_023a,
    0x1ce6_1f14,
    0x2e30_0db3,
    0xc868_b943,
    0x0c64_802b,
    0x8ef7_c02f,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x9000_0000,
    0x9800_0000,
    0x4c00_0000,
    0xc600_0000,
    0xd500_0000,
    0xb580_0000,
    0x7040_0000,
    0x5be0_0000,
    0xb230_0000,
    0x4ec8_0000,
    0x790c_0000,
    0xddae_0000,
    0x6afd_0000,
    0x5ac1_8000,
    0xad21_4000,
    0x0911_2000,
    0x6adc_1000,
    0x7a52_3800,
    0x89bd_5400,
    0x21a1_b600,
    0xbad4_d900,
    0xfc7e_a080,
    0x6204_5ac0,
    0x1706_00a0,
    0x1285_0ad0,
    0x0ac3_18b8,
    0x1525_4ef4,
    0xb517_169e,
    0xa4dc_83e7,
    0x7b56_a02f,
    0xb63c_5012,
    0x42e4_9822,
    0x81b1_041e,
    0x8b8d_2e2c,
    0x0769_dd16,
    0x87dd_8e99,
    0x33d0_87db,
    0x57fa_0e3f,
    0xeb44_cd24,
    0xaf60_36bc,
    0x9df1_93e7,
    0xe66b_1836,
    0x685d_4436,
    0xa895_8e14,
    0xb098_8d18,
    0xc2b0_9689,
    0x530c_c3f2,
    0x7ea8_002c,
    0x627c_0007,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x9000_0000,
    0x2800_0000,
    0xc400_0000,
    0x7e00_0000,
    0x3d00_0000,
    0x4e80_0000,
    0xd640_0000,
    0x3e20_0000,
    0xaf10_0000,
    0xda58_0000,
    0xf79c_0000,
    0x257e_0000,
    0xc40d_0000,
    0xce61_8000,
    0x9034_c000,
    0xc9c8_e000,
    0xec84_1000,
    0xc947_7800,
    0x2fa5_4c00,
    0x08d2_5e00,
    0xd3bd_9f00,
    0x796a_6f80,
    0xb5d1_1940,
    0xdd3d_0fa0,
    0xcf2c_c950,
    0x1bf3_17b8,
    0x5a29_5574,
    0xd176_d1b2,
    0x9269_9645,
    0x4257_982d,
    0x5bfd_5c0a,
    0x8a4b_261e,
    0xec45_d32f,
    0x3d21_b189,
    0xbc94_4660,
    0xd299_8015,
    0x37f8_c03c,
    0x704e_e03b,
    0xcf45_1036,
    0xdea0_f809,
    0x0c50_8c32,
    0xfefd_3e21,
    0xd8cc_4f1c,
    0x3802_77a9,
    0xac05_8550,
    0xda07_499e,
    0xd305_ca5b,
    0x5b83_3e12,
    0x5cc1_4f20,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x9000_0000,
    0x0800_0000,
    0xa400_0000,
    0xda00_0000,
    0x7700_0000,
    0xf980_0000,
    0xeac0_0000,
    0x6c60_0000,
    0xe5b0_0000,
    0xfab8_0000,
    0xc6fc_0000,
    0x75de_0000,
    0xd8cf_0000,
    0x9ea3_8000,
    0x65d7_c000,
    0x4108_e000,
    0x0143_3000,
    0x35a2_0800,
    0x1a56_8400,
    0x1ac9_7200,
    0x05a4_0100,
    0xc253_f480,
    0x96cb_1d40,
    0xeba6_94a0,
    0x6750_ed50,
    0xbc4f_fca8,
    0x22e2_9974,
    0x96f4_66aa,
    0xcc1f_2c5d,
    0xd72a_e81c,
    0xc6d5_b400,
    0x9a8b_7a02,
    0x8082_852a,
    0x4642_8691,
    0x1423_1c77,
    0x7c93_600d,
    0x98a8_f03f,
    0x4514_e80e,
    0x126a_b420,
    0x9970_fa1d,
    0x6fd9_450e,
    0xcfcc_66a2,
    0xd723_2c43,
    0x1714_e839,
    0x816a_b403,
    0x9af0_fa2f,
    0x6219_4503,
    0x522c_6697,
    0x7c53_2c7a,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x1000_0000,
    0x6800_0000,
    0x8400_0000,
    0xda00_0000,
    0x7b00_0000,
    0x9080_0000,
    0x00c0_0000,
    0x9ee0_0000,
    0xad50_0000,
    0x8548_0000,
    0xba0c_0000,
    0xe6aa_0000,
    0x1adb_0000,
    0x9ea3_8000,
    0x9b74_c000,
    0x12fe_e000,
    0x5815_3000,
    0xcaec_6800,
    0x52f8_ac00,
    0xb813_0a00,
    0xfaef_ed00,
    0x2afc_bf80,
    0x5412_a1c0,
    0xa4eb_dfa0,
    0x8bf8_51f0,
    0xbf92_d7a8,
    0x34ad_0df4,
    0x15d9_55b2,
    0x8c24_7cd5,
    0x1cb1_0804,
    0x2a99_5c0b,
    0xd081_8200,
    0xe0c2_713b,
    0xaee3_ddaf,
    0xd555_e0d4,
    0x694c_6a34,
    0xe409_1d2b,
    0x47af_b793,
    0xf15c_fdc7,
    0x0ee3_dda2,
    0x0555_e0f4,
    0x214c_6a25,
    0x7009_1d32,
    0xf5af_b79e,
    0x0e5c_fdc7,
    0x4463_dd94,
    0x7e95_e0fe,
    0x2f2c_6a09,
    0xdd99_1d2d,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0xb000_0000,
    0x4800_0000,
    0xe400_0000,
    0xa600_0000,
    0xdd00_0000,
    0x2f80_0000,
    0x0ac0_0000,
    0x94a0_0000,
    0x1c90_0000,
    0xdee8_0000,
    0xbaac_0000,
    0xc14a_0000,
    0xfcbb_0000,
    0x4ee6_8000,
    0x8670_c000,
    0x7699_e000,
    0xd531_d000,
    0x2df8_b800,
    0x4e80_8400,
    0x5f41_7200,
    0x6960_2700,
    0x88b7_cb80,
    0xd43d_90c0,
    0xeca2_aba0,
    0x7097_80f0,
    0xbced_73a8,
    0x71aa_14dc,
    0x7bcf_59ba,
    0x3dfc_67e5,
    0x7685_d813,
    0xd346_9412,
    0x9b64_aa38,
    0xbbb6_b320,
    0xc2bb_6195,
    0x6fe7_23cb,
    0x33f3_ca10,
    0x1b5b_a32c,
    0xb910_39a1,
    0x8b2d_77f8,
    0x5a8c_8003,
    0x959b_c03e,
    0xdbb7_6028,
    0x92bd_101e,
    0xb7e3_582c,
    0x2ff6_5403,
    0x115d_4a1e,
    0x2617_632d,
    0xdfab_d99f,
    0xa2cb_a7e5,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x3000_0000,
    0x5800_0000,
    0xc400_0000,
    0x4200_0000,
    0xdb00_0000,
    0x7280_0000,
    0x4840_0000,
    0x55a0_0000,
    0xd1f0_0000,
    0x8c78_0000,
    0xafbc_0000,
    0x5bde_0000,
    0x0549_0000,
    0x7520_8000,
    0x8ab6_4000,
    0xe75a_6000,
    0xd80b_7000,
    0x8706_2800,
    0x5484_7c00,
    0x0143_9e00,
    0x9426_e300,
    0x7731_1480,
    0x179e_3340,
    0xb2ed_f4a0,
    0xafd6_0350,
    0x1c4f_3c98,
    0x9ca6_4f5c,
    0x5070_6a8e,
    0xcab9_e06d,
    0x045e_a81e,
    0x1e8e_3c1b,
    0x3547_fe22,
    0x2e24_9319,
    0xb837_bc8f,
    0x4f1c_0f61,
    0xbdac_0a9a,
    0x0ef7_906b,
    0x1cfe_0024,
    0xecf9_0010,
    0x14f8_8013,
    0x00fa_4001,
    0x2afc_6017,
    0x6dfe_7039,
    0x9978_a81f,
    0x483b_3c24,
    0xb419_7e0c,
    0x5f2b_d302,
    0xceb5_5cb3,
    0xe55d_3f5c,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x3000_0000,
    0x9800_0000,
    0xac00_0000,
    0x8600_0000,
    0xc100_0000,
    0x1480_0000,
    0xc0c0_0000,
    0x32e0_0000,
    0x0510_0000,
    0x7998_0000,
    0x8adc_0000,
    0x7d7a_0000,
    0x16cb_0000,
    0x9c62_8000,
    0xead2_4000,
    0x8af9_2000,
    0x4188_1000,
    0x29c1_9800,
    0xd260_fc00,
    0xcfd4_1a00,
    0x3c7c_7d00,
    0xc24a_bd80,
    0x7ca7_2540,
    0xe833_1da0,
    0x17ea_7570,
    0x9413_25a8,
    0x251b_d97c,
    0x6e1d_078e,
    0xcd9d_0857,
    0x60db_182f,
    0x1a7e_bc27,
    0xf34f_3a0a,
    0xd023_6d27,
    0xb4f3_a58e,
    0x3b0e_996a,
    0xfc04_a796,
    0xce00_5853,
    0xe503_2020,
    0x9683_102a,
    0xb3c3_1804,
    0xcd62_bc3b,
    0x9655_3a03,
    0x5e38_6d16,
    0x6969_25b4,
    0xf3d0_d95b,
    0xd27f_8795,
    0x174f_4850,
    0x7222_3811,
    0xf7f6_ac2b,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0xb000_0000,
    0x2800_0000,
    0x7400_0000,
    0x6600_0000,
    0xaf00_0000,
    0x9480_0000,
    0x86c0_0000,
    0x0020_0000,
    0x8c50_0000,
    0xc938_0000,
    0x5a7c_0000,
    0x631e_0000,
    0x5329_0000,
    0xfba4_8000,
    0x3e11_c000,
    0x1fd8_6000,
    0x4e08_5000,
    0x7a72_a800,
    0xd26c_4c00,
    0x0bc0_5a00,
    0x35a3_2b00,
    0xa511_1180,
    0x0d5b_0c40,
    0xd7cb_f1a0,
    0xc6d7_9c50,
    0xacfb_b998,
    0xa4db_407c,
    0x4c8d_ab92,
    0x9bb1_b761,
    0x82c8_280b,
    0x4f54_8c0a,
    0x27bc_ba0e,
    0x81ba_bb3b,
    0x8ebb_d9b6,
    0x4a3f_1074,
    0x54f9_03ae,
    0x08d8_fb6f,
    0x968a_f217,
    0x96b3_673c,
    0xf74f_4ba6,
    0x8611_275f,
    0x53de_6020,
    0x240d_5038,
    0x5f70_283b,
    0xd3e8_8c1a,
    0xa482_ba0a,
    0xeec3_bb3a,
    0x9427_5999,
    0x5a52_d077,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0xf000_0000,
    0xa800_0000,
    0x8400_0000,
    0xea00_0000,
    0xb700_0000,
    0xff80_0000,
    0x7a40_0000,
    0xa060_0000,
    0xcd10_0000,
    0xbad8_0000,
    0xa61c_0000,
    0xfeba_0000,
    0xb10d_0000,
    0xbb62_8000,
    0x9c93_c000,
    0x7d99_e000,
    0xbefd_b000,
    0x1e69_8800,
    0x55f4_3400,
    0x9a08_4600,
    0xa2e5_5500,
    0x2fd7_a580,
    0x277c_5f40,
    0x6d2e_c5a0,
    0xef13_2f70,
    0xb9de_2d98,
    0xfb98_6b4c,
    0x47fe_83b2,
    0xacea_7a6d,
    0x3f33_8808,
    0x93a9_3400,
    0xdbd2_c617,
    0xa57a_952e,
    0xbe2c_4587,
    0x0a90_ef61,
    0xdc9f_cda3,
    0x2079_db59,
    0x1aad_0b9e,
    0x0153_4e64,
    0xabb9_4e25,
    0xad8f_a13c,
    0x6ca4_8388,
    0x2db7_7a7d,
    0x2969_0806,
    0x6a76_f413,
    0x0049_2605,
    0xf286_2509,
    0x4ac5_4da6,
    0x19a6_1b7e,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x5000_0000,
    0x4800_0000,
    0x0c00_0000,
    0xfa00_0000,
    0x9300_0000,
    0xb380_0000,
    0x8940_0000,
    0x2e20_0000,
    0xbe90_0000,
    0x4b28_0000,
    0x74ec_0000,
    0x990a_0000,
    0x087d_0000,
    0xb527_8000,
    0x2111_c000,
    0x886f_a000,
    0xd1cb_7000,
    0xd01b_6800,
    0x3c13_b400,
    0x86e9_1e00,
    0x260f_ff00,
    0xf1ff_f380,
    0xb762_66c0,
    0xf8b5_d3a0,
    0x49b9_d6f0,
    0xddc4_9b98,
    0x3ae1_d2e4,
    0xd4f4_cd8a,
    0x5d1a_29e7,
    0x9a91_6834,
    0x2d2e_b403,
    0xb5ee_9e38,
    0xe58e_3f11,
    0x80b8_538b,
    0x8d45_16ea,
    0xf824_bbab,
    0x6797_62c4,
    0x73aa_058b,
    0x0a2f_edf6,
    0xc86c_9e18,
    0xf1cf_3f1f,
    0x601d_d3af,
    0x2415_d6d0,
    0xc2ee_9bbd,
    0xd00c_d2c4,
    0x98fb_4d9b,
    0x97e7_e9f7,
    0xc274_c834,
    0xeed8_c428,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x7000_0000,
    0x9800_0000,
    0x1400_0000,
    0x8200_0000,
    0x6100_0000,
    0xf180_0000,
    0x5e40_0000,
    0xbe60_0000,
    0x5b10_0000,
    0x5d98_0000,
    0x7d5c_0000,
    0x8bfa_0000,
    0x6a4f_0000,
    0xe064_8000,
    0x8414_4000,
    0x631a_e000,
    0x559f_f000,
    0xe159_7800,
    0x55ff_3400,
    0x754e_e600,
    0x7ee3_c500,
    0xdcd6_b580,
    0x91b9_c540,
    0x7e2a_d5a0,
    0xf671_7570,
    0xce0f_cd88,
    0x3b06_f16c,
    0xe484_33ae,
    0xfdc2_b069,
    0x6921_780e,
    0x98f3_3431,
    0xcecc_e612,
    0x7da0_c516,
    0x3d30_3595,
    0x13ee_855c,
    0x1756_b584,
    0x0af9_c576,
    0x8bca_d5ae,
    0xf621_7568,
    0xc677_cd8c,
    0x360a_f15b,
    0xff06_339b,
    0x8e81_b040,
    0x10c7_f808,
    0x0ea4_741d,
    0x25b0_8638,
    0xe028_753e,
    0x8975_2d88,
    0x8089_0178,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x1000_0000,
    0x5800_0000,
    0x5400_0000,
    0x5200_0000,
    0x7100_0000,
    0x8a80_0000,
    0x20c0_0000,
    0xb860_0000,
    0x4130_0000,
    0x49f8_0000,
    0x1cbc_0000,
    0xc19e_0000,
    0x558b_0000,
    0x2463_8000,
    0x5f35_4000,
    0x9efd_e000,
    0xa53e_7000,
    0x42df_7800,
    0x13ac_ec00,
    0xaff7_ca00,
    0x9e9e_5900,
    0x000b_7880,
    0x1120_f340,
    0x7213_18a0,
    0xe2ec_c350,
    0xc8d4_0088,
    0x678c_1f54,
    0xa564_d29e,
    0x3db2_9a41,
    0xa23f_780a,
    0x435c_ec1d,
    0x74ef_ca08,
    0xf3d2_5905,
    0x680d_788e,
    0x4d27_f351,
    0x8c16_98aa,
    0x85ee_8353,
    0x3954_60a6,
    0xe8cc_2f5e,
    0xe545_ca9b,
    0x9525_4654,
    0x9812_2a06,
    0x77ec_2931,
    0x5852_0086,
    0x3a4b_1f6a,
    0x9181_52bb,
    0x7f40_da5c,
    0xa827_181e,
    0xb490_dc19,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x1000_0000,
    0x7800_0000,
    0x4400_0000,
    0xca00_0000,
    0x4500_0000,
    0xdd80_0000,
    0xd840_0000,
    0x6620_0000,
    0x58d0_0000,
    0xa378_0000,
    0x555c_0000,
    0xb58a_0000,
    0x32f1_0000,
    0xbdad_8000,
    0x3524_4000,
    0x9e57_6000,
    0x31bc_b000,
    0x27ba_d800,
    0x3cbb_5400,
    0x7639_2600,
    0x62fc_cf00,
    0xb31f_5d80,
    0x54aa_6040,
    0xdea5_85a0,
    0xed11_3470,
    0x151c_a3b8,
    0x47ad_fb74,
    0xb823_fe26,
    0x0fd7_9b25,
    0x0ffe_7bb4,
    0xf29a_af44,
    0x72e8_d83b,
    0x5f86_5406,
    0x1146_a604,
    0x3da5_8f35,
    0x2397_bd98,
    0xabdf_9064,
    0xc34f_bd8e,
    0xfa13_906e,
    0x199d_bda5,
    0x906e_9056,
    0x1742_3d9a,
    0x5ea7_d07e,
    0x2d12_ddbd,
    0x751e_206f,
    0x57aa_e5bd,
    0xc021_8455,
    0x4bd4_7bad,
    0xc5fb_af5b,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x3000_0000,
    0x1800_0000,
    0xdc00_0000,
    0xbe00_0000,
    0x6300_0000,
    0x2580_0000,
    0x30c0_0000,
    0xf120_0000,
    0xf5b0_0000,
    0xb6f8_0000,
    0xafdc_0000,
    0xbe6e_0000,
    0x3a95_0000,
    0x6048_8000,
    0x5ca6_4000,
    0x1175_a000,
    0x6dd8_d000,
    0x736d_8800,
    0x3411_0400,
    0x810c_5200,
    0xe744_5300,
    0x14e1_fa80,
    0xd611_9f40,
    0x1c0c_72a0,
    0xc1c0_9b50,
    0x31a0_20b8,
    0x0ff4_c85c,
    0xc499_da3e,
    0x3c89_572b,
    0x4b83_a8b1,
    0x3bc0_cc63,
    0x70a5_0800,
    0x9777_4433,
    0x82d9_f202,
    0xc0ec_8325,
    0xa3d4_729e,
    0x37ac_9b6d,
    0xff36_20b1,
    0x15bd_c850,
    0x993f_5a2b,
    0xd57a_1722,
    0x501e_8891,
    0xacce_5c44,
    0x70e5_2024,
    0xa412_9015,
    0x890e_2829,
    0x7340_d439,
    0x5ee7_5a12,
    0xcf16_1710,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x3000_0000,
    0x9800_0000,
    0x5c00_0000,
    0xba00_0000,
    0xd500_0000,
    0x7880_0000,
    0x89c0_0000,
    0xa360_0000,
    0x2490_0000,
    0xf188_0000,
    0x6eec_0000,
    0x207a_0000,
    0x8cf3_0000,
    0x6e9e_8000,
    0xb920_4000,
    0xa5b1_a000,
    0xf83a_f000,
    0x94d4_1800,
    0x0daa_7c00,
    0xdbde_c200,
    0xb584_c100,
    0x6d45_1980,
    0xb0a2_17c0,
    0x62f1_01a0,
    0x3598_6bf0,
    0x4aa7_c3a8,
    0x57f0_aafc,
    0x5d18_da0e,
    0x6b61_bd2b,
    0x3097_5b80,
    0x9f89_96ee,
    0xf5e9_3836,
    0xf3ff_cc30,
    0x4eb7_fa10,
    0x53bb_0d12,
    0x1a92_e3ac,
    0x2289_1ae7,
    0x696b_e212,
    0xac3d_7134,
    0x1ad6_21b9,
    0x86ae_dbf8,
    0xa058_7b94,
    0xb3c3_26dd,
    0xb664_802d,
    0x7c13_4001,
    0x484f_2002,
    0x558a_b00a,
    0x58ed_b833,
    0xc77c_8c07,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0xb000_0000,
    0xb800_0000,
    0x3c00_0000,
    0x6a00_0000,
    0xf900_0000,
    0xe980_0000,
    0x81c0_0000,
    0x0be0_0000,
    0x2e50_0000,
    0x0cc8_0000,
    0xed2c_0000,
    0xfa7a_0000,
    0x3f33_0000,
    0xe3da_8000,
    0xaa45_4000,
    0x8727_a000,
    0x0236_7000,
    0xbc58_f800,
    0x2882_1400,
    0x9443_6a00,
    0xc021_4d00,
    0x6cb7_6b80,
    0x731b_c7c0,
    0x5c27_93a0,
    0x76b5_d3f0,
    0x121e_f9a8,
    0x39a7_9edc,
    0x2573_1206,
    0xdcf9_1913,
    0x9473_21bc,
    0x517a_badd,
    0xd3b5_202e,
    0xc19f_3021,
    0x6965_582a,
    0xf317_6439,
    0x9d69_1215,
    0x3c5a_191f,
    0xe881_a1a5,
    0xb443_fac1,
    0x7020_801f,
    0xd4b6_400e,
    0x4f1d_202d,
    0x3623_3002,
    0x8fb7_581b,
    0xfb98_6414,
    0xb861_920f,
    0x2e90_590b,
    0xf2ae_8193,
    0x98bf_caec,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xf000_0000,
    0xe800_0000,
    0x9400_0000,
    0x5600_0000,
    0xcb00_0000,
    0x7480_0000,
    0xdb40_0000,
    0x09a0_0000,
    0x78d0_0000,
    0x5548_0000,
    0x5aec_0000,
    0xb13e_0000,
    0xccf7_0000,
    0x7f5c_8000,
    0xb2c5_c000,
    0x2d66_6000,
    0xfeb0_5000,
    0x0f7f_c800,
    0x96d4_0c00,
    0x524d_8600,
    0x246a_8300,
    0x937a_8980,
    0xc4d2_c5c0,
    0xf74d_41a0,
    0x17ea_c9d0,
    0x16be_c7a8,
    0x1f37_4aec,
    0x6fb8_ce12,
    0x5eb0_4f09,
    0xbf7b_efa7,
    0x5ed6_d6eb,
    0x364c_e012,
    0x9a6e_9031,
    0xcc7b_2802,
    0xe656_9c26,
    0xe708_ae30,
    0x6acb_1f1b,
    0xb52e_a7ae,
    0x43dc_1ac9,
    0x4d85_861b,
    0xbac6_832f,
    0x2964_89b2,
    0x90b5_c5c2,
    0x4879_c198,
    0xc853_09d5,
    0x800e_a78d,
    0xc44c_1afe,
    0x8f6d_8623,
    0x37fa_830e,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0xb000_0000,
    0xd800_0000,
    0x9c00_0000,
    0x5600_0000,
    0xa100_0000,
    0x7f80_0000,
    0x03c0_0000,
    0xb6e0_0000,
    0x3410_0000,
    0x0f78_0000,
    0x279c_0000,
    0x668a_0000,
    0x5475_0000,
    0x732c_8000,
    0x6fc0_4000,
    0x18e1_a000,
    0x5917_9000,
    0x4efe_d800,
    0xc15e_8400,
    0x65e8_0a00,
    0x94a1_e500,
    0x1435_8180,
    0x000b_d040,
    0xc433_59a0,
    0xa809_5470,
    0x6031_5398,
    0xd20d_b15c,
    0x4f30_522e,
    0x908a_213b,
    0x6570_ab9b,
    0x84ad_e563,
    0x9801_a01c,
    0xbc07_903f,
    0x0606_d81f,
    0xc902_8409,
    0x3b82_0a07,
    0xc9c4_e523,
    0x41e1_01a2,
    0xea97_9079,
    0x7338_f9b9,
    0x92bb_c477,
    0xe47b_0bb6,
    0x6f1f_7549,
    0x5bcb_f824,
    0x2ed5_540f,
    0x2a1d_720e,
    0x7e4d_f135,
    0x5217_d3af,
    0xb678_f141,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0xb000_0000,
    0x1800_0000,
    0xd400_0000,
    0xa200_0000,
    0x4300_0000,
    0xbb80_0000,
    0xcdc0_0000,
    0xede0_0000,
    0xbf50_0000,
    0x0c58_0000,
    0xa7bc_0000,
    0xa1ee_0000,
    0x6131_0000,
    0xa2c8_8000,
    0x7806_4000,
    0x2401_e000,
    0x5a04_7000,
    0x2704_2800,
    0x0182_1400,
    0x5ac7_0a00,
    0xf461_cd00,
    0x3196_e380,
    0x5a3f_2b40,
    0xd52a_cba0,
    0x4051_3f50,
    0x79db_c198,
    0x0f7d_f27c,
    0xbe8b_a21e,
    0x2725_9909,
    0x4330_0996,
    0xa1ca_9649,
    0x2380_0020,
    0x59c0_0006,
    0xafe0_0005,
    0x4c50_0020,
    0xafd8_0010,
    0xbe7c_0000,
    0xee0e_0038,
    0x9d61_000e,
    0x1510_802d,
    0x127a_401c,
    0x680f_e032,
    0x8465_703f,
    0x8994_a82b,
    0xde38_5421,
    0xdf28_ea3e,
    0xcf54_bd33,
    0xb45a_4bbb,
    0x23bb_7f75,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x1000_0000,
    0x7800_0000,
    0x9400_0000,
    0xba00_0000,
    0xe900_0000,
    0x7b80_0000,
    0x7d40_0000,
    0xa520_0000,
    0xccb0_0000,
    0xa908_0000,
    0xba2c_0000,
    0xc19e_0000,
    0x0817_0000,
    0xa1fb_8000,
    0x9586_4000,
    0x4e45_e000,
    0x07a3_b000,
    0xa276_b800,
    0x9d6a_8400,
    0xfdbf_de00,
    0xf726_cf00,
    0x89b4_ee80,
    0xdc8c_58c0,
    0x846a_56a0,
    0x8e3a_dcd0,
    0x5663_88a8,
    0x6a97_13d4,
    0xaf3a_e636,
    0x91e6_0b31,
    0x61d0_d0b8,
    0xdd1e_27db,
    0x0dd3_800e,
    0xb31a_4010,
    0x7ed3_e011,
    0x3198_b012,
    0x0013_3803,
    0x7dfb_c427,
    0xd381_be1d,
    0xf143_3f25,
    0xbb27_b6ac,
    0xf7b5_6cd6,
    0xd78b_3082,
    0x92ea_97c5,
    0x4afe_b811,
    0xf306_8439,
    0xc281_de22,
    0x5ec1_cf38,
    0x5c67_6ead,
    0xab96_18d7,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x7000_0000,
    0x3800_0000,
    0x2c00_0000,
    0x0a00_0000,
    0x6900_0000,
    0x4580_0000,
    0xf5c0_0000,
    0x9ae0_0000,
    0x2130_0000,
    0x7948_0000,
    0xcdac_0000,
    0x3b9a_0000,
    0x5851_0000,
    0x0ebe_8000,
    0x6285_4000,
    0x1745_2000,
    0x4da3_f000,
    0x0c91_f800,
    0x05d8_f400,
    0xf073_aa00,
    0xe7ef_0500,
    0xb5be_3880,
    0xd205_b8c0,
    0xf507_c0a0,
    0x1781_4cf0,
    0xc0c6_6ab8,
    0xed63_49ec,
    0x91f4_d236,
    0xac2e_b127,
    0x705a_b294,
    0x9db4_4dcd,
    0x410c_803d,
    0xd688_401c,
    0xd649_a02d,
    0x5b2b_b033,
    0xbad8_5827,
    0x2ef3_440d,
    0x72ab_f234,
    0xe51c_4137,
    0xcd15_ca82,
    0x5e19_f9c0,
    0x7d92_0a0e,
    0xbc58_b525,
    0x27b4_6083,
    0x700b_fce5,
    0xcf08_b29a,
    0x1189_4dc6,
    0x84c8_002b,
    0xd46c_0022,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x3000_0000,
    0x9800_0000,
    0xc400_0000,
    0xd600_0000,
    0xe300_0000,
    0xb480_0000,
    0x1940_0000,
    0x2c60_0000,
    0xa590_0000,
    0xe6b8_0000,
    0x49dc_0000,
    0x88ce_0000,
    0x7f33_0000,
    0x768e_8000,
    0xd1d4_4000,
    0xb959_6000,
    0x078d_5000,
    0x1050_0800,
    0x579f_cc00,
    0xb62c_d600,
    0x18e1_fd00,
    0xfcd6_7d80,
    0x6ada_ce40,
    0xdc48_75a0,
    0xf676_0250,
    0xf2ea_2388,
    0x2843_bf5c,
    0x4de5_3e2e,
    0x7b54_212d,
    0xcf1d_43bb,
    0x856d_ef45,
    0xf583_b61e,
    0x40c3_ad1f,
    0x06a6_f5bb,
    0xc232_425b,
    0x0d0b_4399,
    0x5612_ef5c,
    0x4d7b_362d,
    0x97f8_ed00,
    0xd9bf_15a5,
    0xaf58_5242,
    0x048c_aba9,
    0x34d4_335a,
    0xe6de_881e,
    0xc64b_8c10,
    0xaf75_b60d,
    0x2f6c_ad1f,
    0x7486_75aa,
    0xf945_024f,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x5000_0000,
    0xc800_0000,
    0xa400_0000,
    0xca00_0000,
    0x7900_0000,
    0x6880_0000,
    0x4940_0000,
    0xf220_0000,
    0x8d30_0000,
    0xada8_0000,
    0x2e8c_0000,
    0xcf3e_0000,
    0x51d1_0000,
    0x6c7f_8000,
    0x2af7_c000,
    0xf1cb_e000,
    0xf21e_3000,
    0x8b64_3800,
    0xa715_9c00,
    0xac9a_6600,
    0xbd20_0f00,
    0x9ab3_1a80,
    0x2b69_a1c0,
    0xd669_22a0,
    0x84ed_3dd0,
    0xccac_c498,
    0x6a0a_f2c4,
    0x087c_3e2a,
    0x40f1_632d,
    0x38cf_24b8,
    0x0298_c2e3,
    0xae26_063a,
    0x3b35_ff35,
    0x92aa_c2ac,
    0x010f_0dfb,
    0x95fe_fc9f,
    0x5f32_6ec3,
    0xf8af_d80e,
    0xc80b_ac26,
    0x657e_5e13,
    0x7a75_933a,
    0x6489_7ca8,
    0xf639_aef6,
    0xd952_3826,
    0x7538_9c08,
    0x10d3_e618,
    0xd8fa_cf0b,
    0x95b1_7a91,
    0xdced_51c7,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x7000_0000,
    0x3800_0000,
    0x0400_0000,
    0x1200_0000,
    0x0d00_0000,
    0xe780_0000,
    0xfec0_0000,
    0x7c60_0000,
    0xc570_0000,
    0x0358_0000,
    0xba3c_0000,
    0xe4ce_0000,
    0x6f55_0000,
    0xc60a_8000,
    0x3535_4000,
    0x4478_6000,
    0xa8ee_7000,
    0xcd05_5800,
    0xc787_0400,
    0xeec0_0200,
    0x3461_f900,
    0xf973_b680,
    0x155a_5e40,
    0xa538_eea0,
    0x0e48_5a50,
    0x7612_6cb8,
    0x44ac_e34c,
    0x8c21_ba36,
    0x8254_cd0d,
    0x118a_0c92,
    0x93f2_935e,
    0x4c1c_e213,
    0x479f_c92d,
    0xc75c_0eba,
    0x883a_6a51,
    0xf9cb_d488,
    0xc0d5_d771,
    0x04ce_001a,
    0x5f55_000b,
    0x9e0a_8027,
    0x4135_401a,
    0x6e78_600c,
    0xa1ee_700f,
    0x3885_582e,
    0x3447_0404,
    0x7520_0206,
    0x0fd1_f903,
    0x864b_b698,
    0x6a16_5e6b,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0xb000_0000,
    0x2800_0000,
    0x8c00_0000,
    0xfe00_0000,
    0x6100_0000,
    0x8280_0000,
    0xc540_0000,
    0x64e0_0000,
    0x3270_0000,
    0xc388_0000,
    0x6a6c_0000,
    0x549a_0000,
    0xbb57_0000,
    0x0b5e_8000,
    0x7ef5_c000,
    0x8fce_a000,
    0xa00b_d000,
    0xedaf_1800,
    0x553e_ac00,
    0x5dc7_d600,
    0xd2a1_2900,
    0x5b12_3680,
    0x4f3f_ecc0,
    0x2ec7_2ea0,
    0xdf26_40f0,
    0xe5d6_7888,
    0xc81e_a9dc,
    0xcf10_ee02,
    0xd53d_953f,
    0x9dc6_589d,
    0x72a0_b9d7,
    0xeb11_5635,
    0x6738_e93a,
    0xa2c6_96ae,
    0x2123_3cc9,
    0x84d6_b6a3,
    0x4a9d_2cf4,
    0x0a57_0e8b,
    0xb1d8_50fc,
    0xafb7_c085,
    0xb12b_d5e5,
    0x8178_2010,
    0x33a2_1032,
    0x1993_b817,
    0x2a7e_7c1e,
    0xfa24_4e16,
    0xc551_4521,
    0xaa5f_c08e,
    0x5c77_d5d2,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x5000_0000,
    0x5800_0000,
    0x3400_0000,
    0x5a00_0000,
    0x5b00_0000,
    0xd080_0000,
    0x1940_0000,
    0xf6a0_0000,
    0xe3d0_0000,
    0x41d8_0000,
    0xb07c_0000,
    0xa52e_0000,
    0x70b1_0000,
    0x83ef_8000,
    0x55d3_4000,
    0x34db_e000,
    0x81fa_b000,
    0x67ed_2800,
    0x17d5_4c00,
    0xbbda_b600,
    0x5b78_6b00,
    0x7dad_5980,
    0x05f4_9140,
    0x1b4e_71a0,
    0xb700_dd50,
    0xfe83_4798,
    0xf847_f644,
    0x2d23_fe0e,
    0x7214_d709,
    0x9a39_27b8,
    0xff0f_064f,
    0x5c22_b614,
    0x5194_6b0d,
    0x8ffb_59a7,
    0x76e9_917c,
    0x2457_f1af,
    0x161e_9d4f,
    0xb699_278a,
    0x07df_065a,
    0x2d7a_b623,
    0xa8a8_6b2a,
    0x8475_5981,
    0xd188_915e,
    0xbc60_71b0,
    0xa8b1_dd51,
    0xf7ec_c794,
    0xefd4_b643,
    0x3fd8_1e1f,
    0x097e_671c,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x7000_0000,
    0x2800_0000,
    0xfc00_0000,
    0x7200_0000,
    0x3100_0000,
    0x6580_0000,
    0x2740_0000,
    0x0e60_0000,
    0x5710_0000,
    0xfda8_0000,
    0x40cc_0000,
    0x2b5e_0000,
    0x0835_0000,
    0x63da_8000,
    0x08f5_c000,
    0x33ff_2000,
    0xb802_3000,
    0xe404_7800,
    0xc603_7400,
    0xcf07_fe00,
    0x0e80_b500,
    0x8fc5_9980,
    0x3ea5_9ac0,
    0x4f37_e1a0,
    0xc15f_eed0,
    0xcd34_9fb8,
    0x985f_9bcc,
    0x34b4_a632,
    0xbd1d_f133,
    0x23d0_1f8e,
    0x738f_5bef,
    0x8b39_062f,
    0x0c26_012a,
    0x92f5_479e,
    0xdefb_1fcc,
    0xbf80_000f,
    0xaa40_0023,
    0x79e0_0032,
    0x3150_0017,
    0xbe48_003e,
    0xcc9c_0026,
    0xaa96_0001,
    0x2ee9_0037,
    0xd0ac_800b,
    0x674c_c004,
    0x751b_a00f,
    0xefd2_f00b,
    0x4989_d80e,
    0x3638_842f,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x5000_0000,
    0x1800_0000,
    0xac00_0000,
    0x1e00_0000,
    0x9b00_0000,
    0x3f80_0000,
    0x7a40_0000,
    0x91a0_0000,
    0xe750_0000,
    0x9818_0000,
    0x84bc_0000,
    0x136a_0000,
    0x8cb7_0000,
    0x2ee9_8000,
    0x5bf3_4000,
    0x5fc9_2000,
    0x0364_5000,
    0x1d35_c800,
    0xe7a8_1400,
    0xb1d5_1600,
    0x38d8_9300,
    0x3bd8_dd80,
    0x685e_fb40,
    0xac1f_15a0,
    0xf6bd_ef70,
    0x3669_8388,
    0x7831_3c64,
    0x7329_fe0e,
    0x1c14_d70f,
    0x3738_03a9,
    0xe72e_7c59,
    0x3e12_de2e,
    0x0a3b_8723,
    0xbfae_4b84,
    0x7dd2_2855,
    0xd6df_682b,
    0xe8d8_041d,
    0xe3d8_7e29,
    0x645b_9709,
    0xe21b_23a0,
    0x75bd_2c61,
    0xa5ee_961b,
    0x1c70_d31a,
    0x798a_7d9a,
    0xc4c2_eb44,
    0xd560_7dba,
    0xf235_eb76,
    0xca29_fd87,
    0x1e96_ab58,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x7000_0000,
    0xe800_0000,
    0x7400_0000,
    0x8a00_0000,
    0xd700_0000,
    0xcf80_0000,
    0x5bc0_0000,
    0x2e60_0000,
    0x76d0_0000,
    0xbdd8_0000,
    0x9abc_0000,
    0xaeee_0000,
    0x2871_0000,
    0xe4ee_8000,
    0x5f77_c000,
    0xbb6d_6000,
    0x9cb3_b000,
    0x0908_c800,
    0x1460_d400,
    0xe9d0_3a00,
    0x9659_c100,
    0xd37a_8380,
    0xcb8c_4740,
    0x6f24_4ba0,
    0x5ff1_9350,
    0xf32c_f198,
    0xf712_924c,
    0x7cbb_9222,
    0x2feb_a511,
    0x2ef4_f1a0,
    0x5dae_9274,
    0xda55_920b,
    0x039a_a52e,
    0xa81a_71a2,
    0xa1d9_5262,
    0x24b8_f20d,
    0x13e9_1520,
    0x40f2_b995,
    0x98a9_8658,
    0x5ed0_c814,
    0x69dc_d420,
    0x80be_3a2d,
    0xe1e8_c10e,
    0x7bf4_03b3,
    0x412b_8758,
    0x2c11_2bb4,
    0xd53e_2375,
    0xb52a_39b1,
    0xe613_4679,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x3000_0000,
    0x5800_0000,
    0x8400_0000,
    0xb200_0000,
    0x9500_0000,
    0xd880_0000,
    0xb040_0000,
    0xb3a0_0000,
    0x63d0_0000,
    0x0fc8_0000,
    0xf76c_0000,
    0xf73e_0000,
    0x1337_0000,
    0x283a_8000,
    0xaab6_4000,
    0x8afd_6000,
    0x8856_7000,
    0x680e_9800,
    0x4508_3c00,
    0x498c_4e00,
    0x03ce_8b00,
    0xc96d_0980,
    0x1c39_e9c0,
    0x00b5_91a0,
    0xbbfa_d5d0,
    0xd2d5_5fa8,
    0x1549_1edc,
    0xaa29_b63e,
    0x281b_c73d,
    0x2aa3_5fb2,
    0x8552_1ec8,
    0x548d_362c,
    0x574a_8738,
    0x072c_bfbe,
    0x649e_2edd,
    0x40e0_ce2f,
    0x7ff3_cb38,
    0xd9dc_e9b6,
    0xcfc2_d9c8,
    0x0e62_e9b4,
    0x98b5_d9ce,
    0x5ff8_69bd,
    0x70d3_99ed,
    0xe84d_09b9,
    0xaea9_e9f5,
    0xae5d_91a9,
    0xbe06_d5f7,
    0xab03_5f97,
    0x3382_1ef5,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x1000_0000,
    0x6800_0000,
    0x9400_0000,
    0x2600_0000,
    0x7700_0000,
    0x0280_0000,
    0x9140_0000,
    0xfea0_0000,
    0x6610_0000,
    0x4198_0000,
    0x8dbc_0000,
    0xc2ea_0000,
    0x21d7_0000,
    0x687b_8000,
    0xd20a_c000,
    0x9fe5_6000,
    0x80b5_d000,
    0x6b8b_a800,
    0x0625_5c00,
    0xe256_c600,
    0x24bb_fb00,
    0x8b6e_4780,
    0xa014_2540,
    0x469e_6fa0,
    0x573b_b970,
    0xbfad_c988,
    0x0575_9274,
    0xcb68_2612,
    0xc014_eb11,
    0xf698_8fbb,
    0x2f38_a97c,
    0x43a9_01b3,
    0xb772_1e6c,
    0x9a6e_c83e,
    0xb590_8c14,
    0x655d_6e1d,
    0x40de_a73f,
    0xdb18_818c,
    0x90ff_de4a,
    0x5648_2813,
    0xfac3_9c16,
    0x8661_a61a,
    0x0975_2b25,
    0x616c_6f92,
    0xdd10_b94a,
    0x491c_498c,
    0x11f8_526e,
    0xebce_c622,
    0xed07_fb0c,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0xd000_0000,
    0x2800_0000,
    0xc400_0000,
    0xce00_0000,
    0xf500_0000,
    0x6b80_0000,
    0x80c0_0000,
    0x10a0_0000,
    0x7d70_0000,
    0x3c68_0000,
    0x1f4c_0000,
    0xfefa_0000,
    0xc035_0000,
    0xa50f_8000,
    0xdb1c_c000,
    0x1023_e000,
    0x8b30_1000,
    0xe38e_7800,
    0xec59_4400,
    0x7245_9200,
    0x31e6_8f00,
    0x3617_3080,
    0x1f39_b9c0,
    0x9d16_c8a0,
    0x89bc_3df0,
    0x8250_ba98,
    0x2fda_a2c4,
    0xf681_f212,
    0x0f46_5f35,
    0x6e60_a881,
    0x60d5_edf8,
    0xc69a_a283,
    0xa9e3_36dc,
    0xca13_f835,
    0xdd3c_8406,
    0xb213_f223,
    0xf13f_5f3d,
    0x5815_288d,
    0x1a3c_2de4,
    0xee96_c290,
    0x357f_e6ec,
    0xb0f6_6014,
    0xada9_d01f,
    0x9a6a_182c,
    0x0e49_9432,
    0x6b7a_0a29,
    0x4df6_db2e,
    0x3229_5a96,
    0x2caf_b2eb,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x9000_0000,
    0x0800_0000,
    0x0c00_0000,
    0x3200_0000,
    0xc500_0000,
    0x7e80_0000,
    0x60c0_0000,
    0xd260_0000,
    0x8db0_0000,
    0x06e8_0000,
    0x060c_0000,
    0x897a_0000,
    0xb0f3_0000,
    0xd9cb_8000,
    0x0c99_c000,
    0xa106_a000,
    0x3086_b000,
    0x2fc2_5800,
    0xfde0_8c00,
    0xa5f6_fa00,
    0x4f4f_9100,
    0xd05a_4080,
    0xd965_15c0,
    0x7c33_98a0,
    0x69ac_59f0,
    0x6c2b_c2a8,
    0x4569_78d4,
    0x6c49_da2a,
    0xbddf_e117,
    0x8c27_3886,
    0xdf15_e9d6,
    0xe938_1ab1,
    0x1553_34da,
    0x8d9a_000f,
    0x0183_001e,
    0x1743_8020,
    0xde25_c01d,
    0x6a14_a019,
    0x2fb9_b03c,
    0xe193_d806,
    0x69fa_4c07,
    0x7733_da17,
    0x982c_e118,
    0x036c_b8a0,
    0x2f4c_29d2,
    0xa05e_ba89,
    0x6165_84fd,
    0xe830_582a,
    0x5faf_8c21,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0xf000_0000,
    0xa800_0000,
    0x2400_0000,
    0x9200_0000,
    0xc900_0000,
    0xca80_0000,
    0xf9c0_0000,
    0x36a0_0000,
    0xf250_0000,
    0xbce8_0000,
    0x4ccc_0000,
    0x315a_0000,
    0x4017_0000,
    0x0d0c_8000,
    0x1bfb_c000,
    0xfc41_e000,
    0x96e3_f000,
    0x4ab1_7800,
    0x815e_4c00,
    0x8817_b200,
    0x790b_9f00,
    0xd1fa_3180,
    0xb946_5cc0,
    0xea67_c9a0,
    0xe873_d0f0,
    0xb479_9b88,
    0x4907_bfcc,
    0x0a80_d222,
    0x59c4_af05,
    0xc6a6_29a6,
    0x5a50_20c7,
    0x98e8_e39c,
    0xdec9_f3f5,
    0xf85f_6013,
    0x8a93_303c,
    0xf4ce_1812,
    0x2d5d_7c24,
    0x0e11_aa20,
    0x2a0a_e304,
    0x0679_9bb6,
    0xb007_bfc9,
    0xc800_d22f,
    0x7404_af01,
    0xca06_29a4,
    0x4500_20d0,
    0x7c80_e3a6,
    0xa2c5_f3e1,
    0x3525_6027,
    0xc114_3038,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x1000_0000,
    0xf800_0000,
    0xdc00_0000,
    0x3200_0000,
    0x5300_0000,
    0xd280_0000,
    0x62c0_0000,
    0xe1e0_0000,
    0x8510_0000,
    0xf3a8_0000,
    0x44cc_0000,
    0x7d1e_0000,
    0x8655_0000,
    0xf209_8000,
    0xdaf8_4000,
    0x2647_a000,
    0x7e21_b000,
    0xb776_6800,
    0x85fa_dc00,
    0x1ec2_3a00,
    0xe3e7_fd00,
    0x5e10_3980,
    0x1528_36c0,
    0x300f_d1a0,
    0x21fa_aad0,
    0xb0c2_4bb8,
    0xe2e0_e7d4,
    0xcf92_1a06,
    0x5d6b_0d23,
    0x6f28_71aa,
    0x770b_1ae7,
    0x957c_23a6,
    0x8706_3beb,
    0x9486_2038,
    0x47c5_f039,
    0x9e67_c816,
    0xac52_6c1b,
    0x2d0b_d229,
    0xa27c_6132,
    0xdb82_23a7,
    0x8743_3bca,
    0xdfa7_a006,
    0x7731_b021,
    0xeede_6804,
    0x5e36_dc3c,
    0x7b5c_3a3e,
    0x8872_fd01,
    0xad79_b992,
    0x7b00_76df,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x1000_0000,
    0xb800_0000,
    0x5400_0000,
    0xf200_0000,
    0xb700_0000,
    0x3e80_0000,
    0x56c0_0000,
    0x11e0_0000,
    0xe650_0000,
    0x86e8_0000,
    0xbb8c_0000,
    0xec1e_0000,
    0x9d95_0000,
    0xd289_8000,
    0xe39a_4000,
    0xc0d1_e000,
    0xb429_f000,
    0x906f_0800,
    0x4148_9c00,
    0x3bfc_9a00,
    0x2ec3_7d00,
    0x65e3_6380,
    0x6453_26c0,
    0x99ed_eba0,
    0x690d_fad0,
    0x1cde_91b8,
    0xc972_77d4,
    0xbd5b_7a16,
    0x0d33_8d01,
    0x3c7b_eb8a,
    0xaf84_fafc,
    0x6d41_11bd,
    0xaea1_37fd,
    0x8ff5_1a0f,
    0x9f99_3d15,
    0x9ed2_839c,
    0xc52a_d6d3,
    0xfbea_e3ac,
    0x2609_66d8,
    0x165c_0ba5,
    0x7db4_0add,
    0xa3b9_99a2,
    0x81e6_ebdf,
    0x1e51_e02f,
    0xb2e9_f03e,
    0x598f_0805,
    0xe318_9c16,
    0xf714_9a25,
    0x764f_7d09,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x3000_0000,
    0x8800_0000,
    0xb400_0000,
    0x2200_0000,
    0xdf00_0000,
    0x8580_0000,
    0xc6c0_0000,
    0xe2e0_0000,
    0x51d0_0000,
    0x04d8_0000,
    0x51bc_0000,
    0x01aa_0000,
    0x0e11_0000,
    0xe6bc_8000,
    0xc02a_c000,
    0x02d2_6000,
    0x5f5d_f000,
    0xbe7c_c800,
    0xabcc_0400,
    0x4b84_0200,
    0xf7c5_3d00,
    0xc662_8780,
    0x6b97_0b40,
    0xd07a_cfa0,
    0xcacd_cf70,
    0xd706_adb8,
    0xf184_027c,
    0x84c4_621a,
    0x0de5_cd11,
    0x5c50_cfb2,
    0x761c_cf56,
    0x915a_2dab,
    0x8f7e_c25b,
    0x8f4e_0229,
    0x71c4_3d2e,
    0x2366_07a2,
    0x5d11_cb50,
    0xbd3a_afb3,
    0x2fed_3f69,
    0xa8b4_e5a9,
    0x1acf_c65d,
    0xaf04_803a,
    0xad86_c010,
    0x22c0_601d,
    0x78e0_f01b,
    0xb2d2_4837,
    0x175b_c43c,
    0x6a78_e224,
    0xb9cf_0d2c,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xf000_0000,
    0x8800_0000,
    0xec00_0000,
    0x0a00_0000,
    0x8500_0000,
    0x0780_0000,
    0xb2c0_0000,
    0xbbe0_0000,
    0x0990_0000,
    0x5a38_0000,
    0x345c_0000,
    0xde0e_0000,
    0x7657_0000,
    0x6a5c_8000,
    0x550e_c000,
    0xc2d2_a000,
    0x2818_7000,
    0xbaa9_9800,
    0x23e1_8400,
    0xfd91_a200,
    0xe439_c500,
    0x2f5b_bd80,
    0x328e_7640,
    0xa016_a5a0,
    0xebfd_3250,
    0xd73b_a7a8,
    0x9fdb_876c,
    0x46cd_020a,
    0xb8b6_b517,
    0xec4e_a5a8,
    0x51f1_3266,
    0x476d_a781,
    0x7a80_8766,
    0x9147_8205,
    0xcf23_7523,
    0xcd76_8593,
    0x592c_8264,
    0x3724_1f8f,
    0xe970_b358,
    0x9f29_9810,
    0x4821_8424,
    0xe3f1_a218,
    0xc669_c52b,
    0x4b03_bd9c,
    0xd482_7642,
    0x9240_a5a3,
    0x97a6_3276,
    0x8531_27b0,
    0x338e_4777,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x1000_0000,
    0xd800_0000,
    0x3400_0000,
    0xee00_0000,
    0x4d00_0000,
    0x7980_0000,
    0xf8c0_0000,
    0xe760_0000,
    0xe870_0000,
    0x92b8_0000,
    0x665c_0000,
    0x5dee_0000,
    0xd0b7_0000,
    0x15db_8000,
    0xbe2b_4000,
    0x0751_e000,
    0x5aeb_1000,
    0x9231_3800,
    0xcd9a_9400,
    0x260c_0200,
    0x6583_6100,
    0x8ac7_6680,
    0x9865_6940,
    0xcef5_dea0,
    0x5cf8_bd50,
    0x977e_3ca8,
    0x70bb_cc54,
    0x815d_e21e,
    0x6f68_7119,
    0xe0f6_5e85,
    0x71ff_fd5a,
    0xdef9_dcb3,
    0x407b_dc70,
    0x8a39_5a34,
    0x5d1e_a503,
    0xd148_3cbd,
    0x2320_cc54,
    0x0250_6227,
    0x8f68_3119,
    0x90f2_3e9b,
    0x99f8_ad6b,
    0x22fa_84a2,
    0x427d_1854,
    0x1d3b_802e,
    0x879b_402e,
    0x1d09_e03f,
    0x4507_1026,
    0xf587_3829,
    0x12c1_9433,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x5000_0000,
    0xf800_0000,
    0xc400_0000,
    0x5600_0000,
    0xa500_0000,
    0x1880_0000,
    0x9840_0000,
    0x9e20_0000,
    0x4750_0000,
    0x0fc8_0000,
    0xa36c_0000,
    0xab7a_0000,
    0xa113_0000,
    0xc8ed_8000,
    0x4eb8_4000,
    0x9ff1_6000,
    0xd9dc_5000,
    0x6006_3800,
    0xb004_1c00,
    0x8801_ce00,
    0x6c06_e700,
    0x6a02_5180,
    0x3705_79c0,
    0xeb81_e9a0,
    0x25c5_25f0,
    0x1ee3_47a8,
    0x4130_92e4,
    0xd6b8_ae16,
    0xebf6_b715,
    0x07de_69a3,
    0xa902_65cc,
    0xc285_a78d,
    0x2747_82ce,
    0x19a2_761c,
    0x0896_bb3a,
    0x2628_ff94,
    0x09dc_cefa,
    0x5800_0005,
    0x5400_0039,
    0x8e00_0000,
    0x3100_0008,
    0xb680_0020,
    0xf940_000b,
    0xd0a0_003c,
    0x7a10_0019,
    0x8968_0032,
    0x7c7c_0027,
    0x3a92_001f,
    0x452f_0010,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0xd000_0000,
    0x5800_0000,
    0xfc00_0000,
    0x2a00_0000,
    0xfd00_0000,
    0x7280_0000,
    0x9240_0000,
    0xc0e0_0000,
    0xe870_0000,
    0x8168_0000,
    0x4d0c_0000,
    0x343e_0000,
    0x4431_0000,
    0xa28b_8000,
    0x44ff_4000,
    0xae95_a000,
    0xa619_7000,
    0x5fe4_d800,
    0x63f3_6c00,
    0x87aa_ce00,
    0x40ad_3100,
    0x372f_ae80,
    0x1bef_d3c0,
    0xeb48_f6a0,
    0x9adf_ffd0,
    0x5741_9898,
    0xde66_bee4,
    0xe837_6e0e,
    0x9088_411b,
    0xa5fd_76a4,
    0x2611_bff4,
    0x915f_b8a0,
    0x1180_8ef4,
    0x33c6_163e,
    0x3b22_5d05,
    0x9753_60a2,
    0x103f_e2c6,
    0xd232_d821,
    0x958e_6c28,
    0x1b7f_4e2b,
    0x1653_713c,
    0x08b9_8eb4,
    0x5d75_e3c8,
    0xf7ef_8eae,
    0x3948_e3e6,
    0xabda_0eb4,
    0x87c6_a3e3,
    0x1524_2ea0,
    0x8c50_93ef,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0xb000_0000,
    0xb800_0000,
    0x6c00_0000,
    0x2200_0000,
    0x8300_0000,
    0x9380_0000,
    0xdfc0_0000,
    0xbaa0_0000,
    0x5830_0000,
    0x6578_0000,
    0xa75c_0000,
    0x172a_0000,
    0x0135_0000,
    0x39fc_8000,
    0x991b_4000,
    0xf949_2000,
    0xa422_b000,
    0x9572_e800,
    0x409e_d400,
    0x0189_5a00,
    0x9b02_0700,
    0x6f86_8280,
    0x15c7_2b40,
    0x5da2_eaa0,
    0x3db7_bf70,
    0x77be_1098,
    0x2f7c_485c,
    0x805b_5a36,
    0x92ab_0707,
    0xa3f0_029e,
    0x09d9_6b57,
    0x626f_4aa2,
    0x48d2_4f7c,
    0xbd2f_d89a,
    0x9635_2c5d,
    0x047c_6825,
    0x57dc_940f,
    0xeb6e_fa2c,
    0xdc52_f728,
    0xb76b_ca90,
    0x8655_0f43,
    0xb86c_f897,
    0x87d2_9c7e,
    0x5caa_001e,
    0xc2f5_000b,
    0xf95c_803f,
    0x9e2b_4017,
    0x95b1_200a,
    0x33be_b007,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x9000_0000,
    0xe800_0000,
    0x1c00_0000,
    0xc200_0000,
    0x0f00_0000,
    0x3880_0000,
    0x6f40_0000,
    0x6b60_0000,
    0x5cb0_0000,
    0x2308_0000,
    0xe3ec_0000,
    0x6a9e_0000,
    0xe2b3_0000,
    0x9e0b_8000,
    0x0c6a_c000,
    0x595d_2000,
    0xd092_b000,
    0x78dd_0800,
    0x8655_6c00,
    0xc17b_e600,
    0x6541_5500,
    0xa862_cc80,
    0xee35_4ac0,
    0xcf4a_44a0,
    0x9a09_e6d0,
    0x4a6f_0288,
    0x505c_c3f4,
    0x4113_e632,
    0x161d_5533,
    0x6bf4_cca2,
    0x6c6a_4ae0,
    0x295f_c4a4,
    0x0890_26cf,
    0x1cd9_a2ac,
    0xb054_b3fb,
    0x107b_ce2e,
    0x90c6_8907,
    0xf0a4_22aa,
    0xd291_73f7,
    0x97db_6e11,
    0x8ed1_f90c,
    0xd639_8aa7,
    0xfa23_6fe4,
    0x2ad5_2029,
    0x003e_b035,
    0x1b23_0828,
    0xa756_6c3c,
    0xacf8_6605,
    0xf987_951c,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x9000_0000,
    0x6800_0000,
    0xc400_0000,
    0xc600_0000,
    0x6b00_0000,
    0xa180_0000,
    0x3240_0000,
    0x5520_0000,
    0xbff0_0000,
    0xa508_0000,
    0x86ac_0000,
    0x009a_0000,
    0x8bf3_0000,
    0x7b0b_8000,
    0xf1aa_c000,
    0x5b1b_e000,
    0xb8b0_5000,
    0xe6a8_c800,
    0x709a_a400,
    0x53f4_2600,
    0x470a_6700,
    0x9bac_0c80,
    0x321f_dac0,
    0xb435_44a0,
    0x1e6c_bef0,
    0xb679_02a8,
    0x8b60_49d4,
    0x08d4_2632,
    0x07fa_6725,
    0x1124_0ca3,
    0xb9f3_dacf,
    0xee0f_44a3,
    0xb72f_bed7,
    0x5ada_82a4,
    0x1ad6_89ed,
    0x02fd_c626,
    0x3fa5_3727,
    0x7c35_449f,
    0x8a6c_bee3,
    0x3879_0294,
    0xb460_49e8,
    0x0754_262c,
    0x9aba_671d,
    0x2384_0cb7,
    0x5f43_dad9,
    0xbfa7_448c,
    0xbc33_bed4,
    0xaa68_828d,
    0xa879_89fc,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xf000_0000,
    0x4800_0000,
    0x4c00_0000,
    0x7a00_0000,
    0xa100_0000,
    0x0380_0000,
    0x15c0_0000,
    0x4960_0000,
    0x8970_0000,
    0x57d8_0000,
    0x963c_0000,
    0x500e_0000,
    0x7cf7_0000,
    0xf91c_8000,
    0xadd8_c000,
    0x7739_a000,
    0x738c_f000,
    0x9934_3800,
    0xf878_0400,
    0x68af_1a00,
    0x5ae0_8900,
    0x44b3_5680,
    0xcabe_9a40,
    0x914d_eea0,
    0xd8d5_5e50,
    0x7e49_d4a8,
    0x6456_e76c,
    0x2f0b_9a3a,
    0x5874_493f,
    0x5c5c_f684,
    0xeff9_6a47,
    0x936b_56ac,
    0x1c82_9a6e,
    0xe143_eea4,
    0x5422_5e63,
    0xcf55_54bd,
    0x858e_277d,
    0x2232_3a37,
    0x8af8_b90f,
    0xc6e8_cebb,
    0x0241_6e53,
    0xb2a4_4c89,
    0xcf12_1364,
    0xf228_b834,
    0x08a0_c40f,
    0x0e16_ba28,
    0x21ac_7906,
    0xa567_6e8c,
    0x4376_9e52,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0xf000_0000,
    0x7800_0000,
    0x4c00_0000,
    0xbe00_0000,
    0x2d00_0000,
    0x9580_0000,
    0xcf40_0000,
    0x7aa0_0000,
    0xd970_0000,
    0x0f38_0000,
    0xeb1c_0000,
    0x39aa_0000,
    0xb0f1_0000,
    0xa67a_8000,
    0x60bb_4000,
    0x435c_2000,
    0x698d_5000,
    0x5040_7800,
    0xdc21_7400,
    0x3eb6_9e00,
    0xa75a_d300,
    0xb38a_5c80,
    0x6745_3340,
    0x1ea2_a4a0,
    0xc372_0770,
    0x5838_9ab8,
    0xd99f_c44c,
    0xbc6c_1e26,
    0x0391_931f,
    0x726e_7ca9,
    0x9694_6364,
    0xcbe8_dcb4,
    0x17d2_735b,
    0xe44c_84ac,
    0x1722_5742,
    0x9a30_629e,
    0xab98_f060,
    0xef6e_201a,
    0xdb10_5034,
    0xd8a8_f828,
    0x5b77_3419,
    0x243a_3e3d,
    0x7f9d_c333,
    0x2d6c_84ba,
    0x5012_5741,
    0xdc28_629d,
    0xc7b4_f067,
    0xf0dc_2035,
    0xf7cd_5033,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x9000_0000,
    0x1800_0000,
    0x9400_0000,
    0x0e00_0000,
    0x1300_0000,
    0x7180_0000,
    0x0340_0000,
    0x31a0_0000,
    0x2010_0000,
    0x2748_0000,
    0x726c_0000,
    0xffbe_0000,
    0x2197_0000,
    0xcc0f_8000,
    0x7fc9_4000,
    0xcdae_e000,
    0x97db_1000,
    0x46e7_c800,
    0xefb4_2400,
    0xbc5a_ee00,
    0x38a6_8b00,
    0x0c96_1f80,
    0x668f_73c0,
    0xa108_57a0,
    0xf549_17d0,
    0x836d_d9a8,
    0xb73a_ccf4,
    0xc655_6e2e,
    0x106f_cb11,
    0x86b8_ff8d,
    0xe514_63c5,
    0xb1cf_9fb9,
    0xbead_33f1,
    0x565f_37bb,
    0xcda0_47f8,
    0x5215_71b7,
    0x064b_b8c5,
    0x02e9_2817,
    0x1c7f_3409,
    0xebf5_2614,
    0xb27e_af0e,
    0x28f2_f1aa,
    0xfbfe_f8db,
    0x2fb1_c82b,
    0xdc5f_2401,
    0x88a3_6e23,
    0x8494_cb28,
    0xea89_7fb2,
    0x3b0a_23ca,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0xf000_0000,
    0x7800_0000,
    0x3400_0000,
    0x2200_0000,
    0x6f00_0000,
    0x4380_0000,
    0xe840_0000,
    0x8f20_0000,
    0x32b0_0000,
    0x3848_0000,
    0x4dec_0000,
    0x799e_0000,
    0x5a33_0000,
    0x8988_8000,
    0xd18d_4000,
    0x558b_e000,
    0xaf88_7000,
    0x048f_4800,
    0x1d0f_3400,
    0xae48_c600,
    0x40ee_d700,
    0xf51e_2680,
    0x01f2_bac0,
    0x96ef_eea0,
    0x581f_ced0,
    0x7d72_4888,
    0xb52b_29ec,
    0x737e_4616,
    0xd6e0_9721,
    0xf2d5_46be,
    0x2a5b_8aea,
    0x4955_46a6,
    0xb61b_8afc,
    0x4475_46b3,
    0x1bab_8ac1,
    0x47bd_46ab,
    0x8a07_8ac4,
    0x9303_46ad,
    0x8d84_8af3,
    0x6143_c6bc,
    0xf9a5_caf1,
    0xc276_2684,
    0x3eae_bac5,
    0x7739_ee95,
    0xbfc0_cec7,
    0xf564_c882,
    0x0a95_69f5,
    0x8d7d_2608,
    0xc7e5_a72a,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x3000_0000,
    0xd800_0000,
    0xe400_0000,
    0x3e00_0000,
    0x1300_0000,
    0x8b80_0000,
    0x19c0_0000,
    0x56a0_0000,
    0x2770_0000,
    0x6a88_0000,
    0xceac_0000,
    0x4e9a_0000,
    0x37f3_0000,
    0x14ce_8000,
    0x93ca_4000,
    0x1e4a_6000,
    0xe08b_1000,
    0xebac_c800,
    0xfa19_7400,
    0x97b7_6a00,
    0x4aa8_b700,
    0xa09f_4880,
    0xecf7_8ec0,
    0x934f_00a0,
    0x880b_baf0,
    0x81ee_8aa8,
    0x617d_5dfc,
    0x0063_ea1e,
    0xf051_f705,
    0xb13b_a8b1,
    0x6606_def1,
    0x3701_a8bb,
    0x9585_decb,
    0x3ac7_2890,
    0x0523_9ef7,
    0xdab7_48b3,
    0x022b_8ef9,
    0xfadd_008d,
    0xaf94_baf6,
    0xe09a_0abf,
    0x0cf4_1ddd,
    0x834f_0a37,
    0x600c_a71f,
    0xbdef_00a4,
    0xbb7b_baef,
    0x2d66_8abf,
    0x68d1_5de8,
    0x2379_ea2b,
    0x2962_f73a,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x1000_0000,
    0x7800_0000,
    0x3400_0000,
    0x8600_0000,
    0x5300_0000,
    0x0b80_0000,
    0xc7c0_0000,
    0xd8e0_0000,
    0x80f0_0000,
    0x6918_0000,
    0xab7c_0000,
    0x3ace_0000,
    0x6877_0000,
    0x8d5b_8000,
    0xd85e_4000,
    0xc0dc_e000,
    0x2c99_5000,
    0x23b8_8800,
    0x03aa_b400,
    0xde41_1a00,
    0x9a25_7500,
    0x5891_b680,
    0x01ad_9c40,
    0x2344_bea0,
    0xaea2_6850,
    0x36d4_c4a8,
    0xb38b_0d54,
    0x17d4_9a36,
    0x0d0c_3519,
    0xb896_d6b7,
    0x71aa_8c5d,
    0x6b40_d69d,
    0xf2a1_8c78,
    0xfcd5_56bd,
    0x5288_cc51,
    0xc952_3698,
    0x924f_dc62,
    0xac36_5eb5,
    0xee7c_385d,
    0x5a4f_cca2,
    0xb033_f97a,
    0x047f_603e,
    0xab4b_103b,
    0x16b2_6802,
    0xaf38_e41b,
    0x39ec_1210,
    0xda66_8115,
    0x95b7_cc8b,
    0xbcbf_f965,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x7000_0000,
    0x1800_0000,
    0x0400_0000,
    0x7a00_0000,
    0x1f00_0000,
    0x1480_0000,
    0x8540_0000,
    0xfd20_0000,
    0xfe30_0000,
    0xd998_0000,
    0x21fc_0000,
    0xe2ea_0000,
    0xa541_0000,
    0x2d26_8000,
    0xf630_4000,
    0xb59b_6000,
    0x47ff_3000,
    0x83e9_0800,
    0xd4c2_8c00,
    0xa3e2_f600,
    0x9ad3_2700,
    0x33cf_5280,
    0x9d71_e440,
    0x85bd_3aa0,
    0xce4c_5870,
    0xc5b6_c4b8,
    0xf05d_f36c,
    0x4d9b_603e,
    0xf3ff_302d,
    0x81e9_0800,
    0xbfc2_8c1a,
    0xd562_f61d,
    0x0493_2727,
    0xa06f_52a4,
    0xf901_e459,
    0xb585_3aac,
    0x94c0_5866,
    0x03e4_c489,
    0x8ad0_f372,
    0x5bcf_e03b,
    0x8172_7031,
    0xfbbe_e81e,
    0xab4c_fc1f,
    0xce36_1e1b,
    0x619e_db3e,
    0x35ff_cc81,
    0xf0ef_7f5b,
    0xa641_9628,
    0x47a0_1712,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x7000_0000,
    0x8800_0000,
    0x6c00_0000,
    0xa200_0000,
    0x4f00_0000,
    0x3580_0000,
    0x3340_0000,
    0x03a0_0000,
    0x0610_0000,
    0x9898_0000,
    0x187c_0000,
    0x75ce_0000,
    0x5743_0000,
    0x8da4_8000,
    0x4b12_c000,
    0x921c_a000,
    0x96be_3000,
    0x292a_0800,
    0xf0f5_c400,
    0x5c2e_ce00,
    0xfe76_eb00,
    0xccef_1780,
    0xb797_d940,
    0xf5d9_bfa0,
    0xaedc_2d50,
    0x9d5d_7988,
    0x8f1f_024c,
    0x243c_a02a,
    0xe3ee_3017,
    0x1212_0822,
    0x9e99_c414,
    0x3978_ce07,
    0xdd49_eb04,
    0x9685_97a5,
    0xe4c6_195e,
    0xdfe1_9f8b,
    0x4030_dd5b,
    0x25cb_d1b3,
    0xef44_f65e,
    0xc9a0_6632,
    0xf511_1f16,
    0xf71d_d1b8,
    0x803b_f676,
    0x8dea_e62a,
    0x8f10_df1f,
    0x6c1d_f1b4,
    0x53bb_0664,
    0x4faa_4e07,
    0xdc34_2b2e,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x5000_0000,
    0x9800_0000,
    0xc400_0000,
    0xb600_0000,
    0xc900_0000,
    0x8d80_0000,
    0xed40_0000,
    0x5160_0000,
    0xeeb0_0000,
    0x9e88_0000,
    0x0aac_0000,
    0xd97e_0000,
    0x3347_0000,
    0xd461_8000,
    0xa937_4000,
    0x98c8_6000,
    0x314b_5000,
    0x5a0b_d800,
    0x2a68_9400,
    0x4558_ce00,
    0xdc90_cd00,
    0x3c59_f480,
    0xf911_dac0,
    0xfd1a_4ca0,
    0x1272_1ed0,
    0x30a9_5aa8,
    0xba7a_47c4,
    0x25c0_600e,
    0x9ba7_5035,
    0xc995_d803,
    0x83df_9417,
    0x4b51_4e28,
    0xb8fb_8d38,
    0x0407_949a,
    0xd601_8af2,
    0xb906_14b0,
    0x4586_cad2,
    0xb146_74ad,
    0x2361_9af1,
    0x91b3_acaa,
    0xda0e_0ed1,
    0x6a6a_e286,
    0x6559_83ed,
    0x8c93_7605,
    0xa45f_0910,
    0x3d14_e295,
    0x4b1e_83e6,
    0xdb72_f633,
    0xbd28_4912,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x9000_0000,
    0x5800_0000,
    0x3400_0000,
    0x9200_0000,
    0xc500_0000,
    0x1280_0000,
    0x36c0_0000,
    0xf160_0000,
    0xd290_0000,
    0xbc08_0000,
    0x2fac_0000,
    0x4e5e_0000,
    0x5dc1_0000,
    0x78e1_8000,
    0xe5d1_4000,
    0xf62f_e000,
    0x811b_f000,
    0x53e5_1800,
    0x8c57_2c00,
    0x516c_8a00,
    0x933c_e900,
    0xc955_c980,
    0x03ec_cfc0,
    0x45ff_31a0,
    0xa830_13d0,
    0x897e_a398,
    0xcdf7_d6f4,
    0x1599_e00e,
    0x0226_f039,
    0x82b2_980a,
    0x5bbb_6c18,
    0x1694_ea36,
    0xa60b_5931,
    0x66a8_b19c,
    0x6adc_53c8,
    0x6406_c3b7,
    0x6a00_66e2,
    0x8104_9818,
    0x4886_6c1c,
    0x9fc3_6a0c,
    0x45e7_190c,
    0xb350_d182,
    0x9aeb_e3f2,
    0xd97b_bbb7,
    0x35f0_fad6,
    0x519d_6a1d,
    0x5826_192a,
    0x2bb1_518f,
    0xef3a_a3d1,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0xf000_0000,
    0x5800_0000,
    0x1c00_0000,
    0x9600_0000,
    0xcd00_0000,
    0x0380_0000,
    0xccc0_0000,
    0x31e0_0000,
    0x2950_0000,
    0xcab8_0000,
    0xfb9c_0000,
    0x7d2e_0000,
    0x07c1_0000,
    0x1762_8000,
    0x4212_4000,
    0x4d9d_a000,
    0xe02a_9000,
    0x4c44_3800,
    0x6fa7_c400,
    0xa1f0_9200,
    0x23ca_b500,
    0x7210_8380,
    0xb598_c040,
    0xec29_1ba0,
    0x7245_9450,
    0xe6a5_b198,
    0x2874_e56c,
    0xb40b_a00e,
    0x8d77_902b,
    0x5388_b80b,
    0xdbb4_8408,
    0x916f_b233,
    0x7862_6507,
    0x1e91_1ba9,
    0x25d9_944a,
    0xb58b_b19e,
    0x0eb5_e557,
    0x6ee9_2039,
    0xd2a5_d019,
    0xba75_1806,
    0x130e_1414,
    0x25f3_8a3a,
    0x09c9_a11d,
    0x3917_89a0,
    0xd31e_2173,
    0x676f_b204,
    0x0562_6502,
    0xa511_1ba1,
    0x0519_9476,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x3000_0000,
    0xd800_0000,
    0x9400_0000,
    0xbe00_0000,
    0x2900_0000,
    0x9980_0000,
    0x2940_0000,
    0x86a0_0000,
    0xd9d0_0000,
    0x1198_0000,
    0x827c_0000,
    0x8f0a_0000,
    0x1441_0000,
    0x6124_8000,
    0xb994_4000,
    0x3ebb_e000,
    0xaaeb_9000,
    0x8c32_1800,
    0xf1ed_7400,
    0xd6b2_4e00,
    0xb628_f300,
    0xf9d6_d180,
    0x819c_a740,
    0x0a7f_29a0,
    0xf30a_4370,
    0xe647_7fb8,
    0x6223_c47c,
    0xb711_e00e,
    0xa77a_9019,
    0x9c8e_9801,
    0xfa05_3423,
    0xbf03_ae3f,
    0x9c82_6325,
    0xaac0_49a8,
    0xe0e5_9376,
    0x7bf6_87a3,
    0xc689_206c,
    0x1503_b63e,
    0xcb82_172f,
    0x7a44_8791,
    0x6024_2062,
    0x0c15_360d,
    0x0dfb_571e,
    0x6349_e7a5,
    0x7166_f074,
    0xeeb2_4e08,
    0xd228_f312,
    0xffd6_d1ba,
    0x0c9c_a761,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x3000_0000,
    0xa800_0000,
    0xc400_0000,
    0x7200_0000,
    0xb300_0000,
    0x3680_0000,
    0x9cc0_0000,
    0xdfa0_0000,
    0x1af0_0000,
    0x5be8_0000,
    0xda8c_0000,
    0xc4da_0000,
    0xd747_0000,
    0x88e2_8000,
    0x5211_c000,
    0xa9fa_e000,
    0x4374_f000,
    0x2fae_2800,
    0x3cee_bc00,
    0xc60b_4a00,
    0x2719_ef00,
    0xb862_6c80,
    0x67d0_a5c0,
    0x97de_a4a0,
    0xb1c6_e9f0,
    0x2c21_c688,
    0xd1b6_bafc,
    0xad0a_6022,
    0x1d9e_300d,
    0x02a4_481e,
    0xe170_8c11,
    0x64af_023b,
    0xf669_633a,
    0x74cd_6ea6,
    0x55b9_c6cd,
    0x9113_ca0c,
    0x577f_2f27,
    0x8bb2_0cb8,
    0x1a09_95c9,
    0xf918_6c8f,
    0x1d67_a5d6,
    0xa054_24ad,
    0x269b_29e1,
    0x0021_26ac,
    0x07b5_4ae1,
    0xfc0e_c819,
    0x001d_4c31,
    0xc4e7_e211,
    0x1416_931f,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x5000_0000,
    0x5800_0000,
    0x4c00_0000,
    0x5600_0000,
    0x8900_0000,
    0x4a80_0000,
    0xa9c0_0000,
    0xc0e0_0000,
    0x0f50_0000,
    0x2b28_0000,
    0xcc0c_0000,
    0x86be_0000,
    0x5e41_0000,
    0xc9a7_8000,
    0x5177_4000,
    0x631a_2000,
    0x4936_1000,
    0x9bbe_9800,
    0x4ec7_ac00,
    0x5f63_d200,
    0x0214_dd00,
    0xd70b_d380,
    0x473b_54c0,
    0xce07_6ba0,
    0x6506_e8d0,
    0xac84_2198,
    0x28c4_99c4,
    0x9e63_a00e,
    0xbc90_5017,
    0x34cb_383b,
    0x00da_fc25,
    0x4ed1_6a11,
    0xfb68_611b,
    0x80af_19b7,
    0x2b4e_65cb,
    0x4d9a_ca08,
    0x52f4_310a,
    0x205a_21a3,
    0x9015_99f3,
    0x5c0c_202f,
    0x7ebb_1033,
    0xa247_1826,
    0x97a1_ec27,
    0xcc76_7208,
    0x3399_8d2c,
    0x3ff1_6b8c,
    0x98db_e8e0,
    0xa2d5_a1bc,
    0x1d6e_d9cb,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x5000_0000,
    0x7800_0000,
    0x0c00_0000,
    0x8a00_0000,
    0x5100_0000,
    0x4380_0000,
    0x27c0_0000,
    0xaa60_0000,
    0xd490_0000,
    0xc698_0000,
    0xa93c_0000,
    0x92ca_0000,
    0xb547_0000,
    0x0e21_8000,
    0xf934_4000,
    0xe869_2000,
    0xc333_f000,
    0xf168_b800,
    0x04b5_c400,
    0x78ad_2a00,
    0x01d4_b100,
    0x38be_2980,
    0x780b_5340,
    0x0ea7_b1a0,
    0xf071_6770,
    0x2448_2388,
    0xef07_1264,
    0xf482_a016,
    0x4f40_b027,
    0xb720_1814,
    0x6eb2_7403,
    0x19ac_b22c,
    0xca52_851e,
    0x3b7b_bb98,
    0x2c6a_2668,
    0x0d34_b22b,
    0xae6e_8526,
    0xb831_bb97,
    0xb3ed_2666,
    0x18f5_3228,
    0xf90a_c50a,
    0xf520_9b97,
    0x7bb2_d663,
    0x542f_8a2b,
    0x1294_0135,
    0x7d9e_31b8,
    0x4bb9_2744,
    0xde8b_03b3,
    0x4ce3_e24f,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x1000_0000,
    0x4800_0000,
    0xf400_0000,
    0x6200_0000,
    0x3500_0000,
    0x9f80_0000,
    0x0640_0000,
    0xcde0_0000,
    0x5110_0000,
    0x1338_0000,
    0x469c_0000,
    0x196a_0000,
    0x23c7_0000,
    0x82a3_8000,
    0x3577_c000,
    0x036d_6000,
    0x7ac2_f000,
    0x6323_1800,
    0x8033_4400,
    0x4e0d_e600,
    0x7314_e100,
    0x463d_7580,
    0x691e_6e40,
    0x472b_0da0,
    0x5223_da70,
    0x45b7_f388,
    0x714f_7f74,
    0xef76_e01a,
    0xfa69_3009,
    0x8b44_7822,
    0x9e66_b434,
    0x3955_7e2d,
    0x25dc_6531,
    0x630f_f38c,
    0x3093_7f58,
    0x667c_e030,
    0xabfe_3034,
    0x00bf_f819,
    0x4edd_7409,
    0x9f8a_1e30,
    0x5e55_9529,
    0x175d_6bbe,
    0xe6cc_fb56,
    0x7d35_e63f,
    0xe588_e102,
    0xb757_7590,
    0xaed9_6e72,
    0xef88_8dac,
    0xa654_1a7a,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0xb000_0000,
    0xf800_0000,
    0xac00_0000,
    0x1200_0000,
    0x6500_0000,
    0x2380_0000,
    0xe5c0_0000,
    0x29e0_0000,
    0xc4b0_0000,
    0xb5f8_0000,
    0x1fdc_0000,
    0x598a_0000,
    0x2447_0000,
    0x3126_8000,
    0x72d7_4000,
    0xce8f_2000,
    0xb2c6_3000,
    0x1f60_d800,
    0x5af7_a400,
    0x65d8_9a00,
    0x188c_bd00,
    0xe1c7_2480,
    0xbfe1_5540,
    0xf7b0_dca0,
    0x057c_c170,
    0xfa9a_9e88,
    0x6d2c_d85c,
    0x7851_a036,
    0xcacd_7037,
    0xf3e5_f812,
    0x35b6_941e,
    0x887e_c232,
    0x3d1c_590b,
    0xcee8_9e86,
    0x8ab7_d851,
    0x5afd_200f,
    0xe55d_303f,
    0xc5cc_5819,
    0xd967_e413,
    0x41f1_3a09,
    0x915d_cd39,
    0x0bc8_dcad,
    0xf660_c160,
    0x1b70_9e90,
    0xbd1b_d86f,
    0x0eef_202f,
    0x2ab6_3011,
    0xeaf8_d81d,
    0x1d5b_a43f,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x1000_0000,
    0x7800_0000,
    0x1400_0000,
    0x3a00_0000,
    0x6d00_0000,
    0xff80_0000,
    0xec40_0000,
    0x6c60_0000,
    0xe5d0_0000,
    0xd818_0000,
    0xcd3c_0000,
    0x6f0a_0000,
    0xa483_0000,
    0xa0c7_8000,
    0x60a2_4000,
    0x8b73_e000,
    0x146a_b000,
    0x33d6_1800,
    0x5b1b_4400,
    0x45be_f600,
    0x01c9_7d00,
    0xa323_ef80,
    0xd135_ad40,
    0x0b0c_17a0,
    0x1687_5970,
    0x91c3_79a8,
    0xd927_2074,
    0x5c35_8036,
    0xc48d_4031,
    0x92c6_6018,
    0x91a7_f01a,
    0x12f0_782f,
    0xd32c_b425,
    0x9b36_8e2a,
    0xee09_c919,
    0xb507_6192,
    0x3b83_6471,
    0x8e46_f616,
    0x0565_7d13,
    0x5851_ef8d,
    0x4d5a_ad46,
    0x64d9_97af,
    0x0b9a_1941,
    0xef7d_19a0,
    0x646c_d064,
    0xbbd7_f836,
    0x071e_f419,
    0x03bd_6e36,
    0x3acf_7901,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0xf000_0000,
    0x8800_0000,
    0xc400_0000,
    0xb600_0000,
    0x6f00_0000,
    0x6b80_0000,
    0x0740_0000,
    0xeae0_0000,
    0x0610_0000,
    0x4e48_0000,
    0xf4ec_0000,
    0x9f9a_0000,
    0x3281_0000,
    0xc3c2_8000,
    0xe620_c000,
    0x1bb5_e000,
    0x2abf_d000,
    0x78b4_e800,
    0x933b_9400,
    0x36f7_1e00,
    0x055d_b100,
    0x1024_1d80,
    0xd4b2_b5c0,
    0xd13f_15a0,
    0x07f7_f1f0,
    0x35de_63b8,
    0x42e1_14cc,
    0x9210_801a,
    0xe04d_c03d,
    0x27ed_6017,
    0x0e1e_1016,
    0x28c3_8815,
    0x9ba4_842b,
    0xe3f6_160d,
    0xd3d9_f51b,
    0x35e7_ebb3,
    0x4594_90fd,
    0x1d0c_162e,
    0xd008_f500,
    0xba8d_6b9c,
    0x6548_50f4,
    0xe96b_f613,
    0x97da_253e,
    0x43e1_039d,
    0x4a92_04f0,
    0x868b_880d,
    0x5f48_842f,
    0x946c_1618,
    0xd558_f536,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0xd000_0000,
    0x9800_0000,
    0xf400_0000,
    0x1600_0000,
    0x6f00_0000,
    0x5180_0000,
    0xc240_0000,
    0x42a0_0000,
    0x4590_0000,
    0xa6d8_0000,
    0xa13c_0000,
    0x8b8a_0000,
    0xf083_0000,
    0xe8c1_8000,
    0x3763_4000,
    0xe275_e000,
    0x9c6b_d000,
    0x6230_6800,
    0xb7cf_4400,
    0xa122_e600,
    0xa6d6_0b00,
    0x0efb_eb80,
    0xb168_2f40,
    0x5ab4_63a0,
    0xf30f_bb70,
    0x5447_6da8,
    0xeda5_b444,
    0x3413_800e,
    0xb49c_4039,
    0x7b9e_602b,
    0x3a1b_9012,
    0x405c_0837,
    0x26fb_d416,
    0xed6d_6e01,
    0xd0b1_9f3a,
    0x3608_e5ad,
    0x10c2_2049,
    0xf360_8e3b,
    0x9c76_4f35,
    0x4f6a_8db9,
    0x49b2_646d,
    0xf889_e826,
    0xcb00_041b,
    0x1f85_0617,
    0x7942_db28,
    0xd520_03ba,
    0x70d7_2b6e,
    0x41fa_e586,
    0x30ed_2052,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x9000_0000,
    0x8800_0000,
    0xdc00_0000,
    0xea00_0000,
    0x5b00_0000,
    0xe380_0000,
    0x4840_0000,
    0x45a0_0000,
    0x3910_0000,
    0x8b38_0000,
    0xf1dc_0000,
    0xdcee_0000,
    0xc981_0000,
    0xb341_8000,
    0xd627_c000,
    0x6956_2000,
    0x9a9d_f000,
    0xfecf_6800,
    0xe6d4_9400,
    0x80da_8600,
    0xc468_f300,
    0x1247_6780,
    0xa6a0_1c40,
    0xfe90_2fa0,
    0xed78_7850,
    0x517c_4198,
    0x6b7f_df74,
    0x5879_803a,
    0xf7fb_c003,
    0xddb8_2020,
    0x1f1c_f005,
    0x2f8e_e820,
    0xb7f3_5433,
    0xe00c_a613,
    0x4db5_030a,
    0x4aa8_0f8b,
    0x3124_8860,
    0xb0d2_a9a4,
    0xe1dc_8b50,
    0x14ed_2621,
    0xf582_c30f,
    0xc946_2f9b,
    0x0525_7872,
    0x56d3_c1b1,
    0x38d9_1f5b,
    0xe06e_201f,
    0x3c41_f01e,
    0x43a1_6828,
    0x7015_942e,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x7000_0000,
    0xc800_0000,
    0x4c00_0000,
    0xf600_0000,
    0x2500_0000,
    0x0080_0000,
    0x4540_0000,
    0x59a0_0000,
    0xb950_0000,
    0x8ba8_0000,
    0x744c_0000,
    0x993a_0000,
    0xf203_0000,
    0x5f04_8000,
    0xf384_c000,
    0x10c7_a000,
    0xd463_9000,
    0xe9b4_f800,
    0x9d5e_9c00,
    0x63b7_0600,
    0x665e_e300,
    0x5a30_2d80,
    0x6d9e_dac0,
    0xe7d1_75a0,
    0x37ec_d6f0,
    0x436c_0ba8,
    0xb42b_69ec,
    0x5288_001a,
    0x485c_003f,
    0x6b32_0007,
    0x4f1f_0006,
    0x8596_800f,
    0x39cb_c00b,
    0x20f9_202b,
    0xf0e4_5036,
    0xa6f7_d834,
    0xfff9_cc22,
    0xc364_5e12,
    0x9633_ef0f,
    0x5b9b_d393,
    0xe2d2_a5dd,
    0x476c_5e15,
    0xce2f_ef05,
    0xa189_d3a1,
    0x1ddd_a5f2,
    0xe6f2_de34,
    0x1ff8_2f28,
    0x9362_f381,
    0x2e36_f5f0,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x3000_0000,
    0x9800_0000,
    0x5c00_0000,
    0xae00_0000,
    0xeb00_0000,
    0x6880_0000,
    0x7240_0000,
    0xff20_0000,
    0xb4d0_0000,
    0x3868_0000,
    0x280c_0000,
    0x9c7a_0000,
    0x7405_0000,
    0xaa00_8000,
    0xf902_4000,
    0x1d87_a000,
    0x69c3_5000,
    0xb9e0_c800,
    0x97b1_6c00,
    0x989f_8e00,
    0xcc33_2f00,
    0xfe5f_cd80,
    0x3f50_9cc0,
    0xf6aa_a5a0,
    0x1f6b_a0f0,
    0x668f_6398,
    0x113e_a3fc,
    0xb9a0_003e,
    0xed90_002b,
    0x4fc8_0035,
    0xde9c_0021,
    0xc332_0017,
    0xb4d9_0031,
    0xa012_800e,
    0x4e0b_400b,
    0x437d_202b,
    0x9684_103b,
    0xf147_e816,
    0xb3a0_7c3a,
    0x0490_e603,
    0x1a4d_1329,
    0x435a_8b8a,
    0x10d7_dff9,
    0x3a6a_6623,
    0x150a_5331,
    0x73fd_abb7,
    0x58c6_cfc0,
    0x9065_0e31,
    0x7474_6f3e,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x5000_0000,
    0x2800_0000,
    0xac00_0000,
    0x2e00_0000,
    0x3d00_0000,
    0xaf80_0000,
    0xc5c0_0000,
    0x0760_0000,
    0x7d90_0000,
    0x5ae8_0000,
    0x434c_0000,
    0x973a_0000,
    0xbc01_0000,
    0xa607_8000,
    0xa100_c000,
    0xf986_a000,
    0x7cc5_5000,
    0x2ae5_f800,
    0xab55_e400,
    0xcf0a_ba00,
    0x549f_6900,
    0x0f77_f980,
    0x85bc_00c0,
    0x1646_a1a0,
    0x04a1_b4f0,
    0x8bf4_63b8,
    0xf6fa_f9e4,
    0xc960_0032,
    0xd090_000f,
    0xbd68_0019,
    0x7a8c_0030,
    0x965a_002a,
    0x5091_0015,
    0x7d6f_8021,
    0x1a8c_c021,
    0xc65c_a03c,
    0x7894_503e,
    0xd16a_7832,
    0x3489_2420,
    0xfb5e_1a1a,
    0xd717_3917,
    0x14af_81b2,
    0x33e8_24d8,
    0x86cd_3bbd,
    0x8dfb_4ded,
    0x57e0_c23f,
    0xa4d6_4d04,
    0x3ac9_e3a8,
    0x2bfb_39e1,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x7000_0000,
    0x2800_0000,
    0x0400_0000,
    0x3600_0000,
    0xe700_0000,
    0xc080_0000,
    0x4040_0000,
    0x9da0_0000,
    0xa8d0_0000,
    0x3878_0000,
    0xf09c_0000,
    0xf46e_0000,
    0x1305_0000,
    0x9e82_8000,
    0xc341_c000,
    0x1b22_e000,
    0x2790_d000,
    0x615e_a800,
    0x2e0c_8c00,
    0xb6b5_3e00,
    0x8bc9_eb00,
    0x12d7_2980,
    0xbd78_a840,
    0xd91d_61a0,
    0xcfad_f450,
    0x1462_77b8,
    0x3eb0_534c,
    0xdfce_0032,
    0x1cd5_000d,
    0x067a_801f,
    0x039d_c024,
    0x5aec_e037,
    0x9845_d028,
    0xf1a4_281a,
    0xfad1_4c03,
    0x9979_de19,
    0xff1c_3b06,
    0x70ab_0194,
    0xf8e5_e452,
    0x4cf2_bfb4,
    0x9368_cf58,
    0x9385_f624,
    0xbec1_7731,
    0x2ee4_dfab,
    0x9bf0_df6f,
    0x1bed_3e14,
    0xa7c5_eb08,
    0x3d61_2994,
    0x6531_a873,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x1000_0000,
    0xd800_0000,
    0x4c00_0000,
    0xae00_0000,
    0xfd00_0000,
    0x4180_0000,
    0xab40_0000,
    0xd9e0_0000,
    0xf8f0_0000,
    0x52d8_0000,
    0x4f7c_0000,
    0x54ea_0000,
    0x4d03_0000,
    0x4987_8000,
    0x1f47_4000,
    0x2be4_2000,
    0x73f1_d000,
    0xa258_f800,
    0x0bbc_9400,
    0xdb4a_be00,
    0x2d92_9900,
    0x48eb_d280,
    0xdb00_de40,
    0xc885_0aa0,
    0x38c2_9a70,
    0xe9a2_cca8,
    0x0994_d774,
    0xa2ea_001e,
    0x3c03_0027,
    0x8607_8015,
    0x5907_4028,
    0x6b84_200d,
    0x6c41_d006,
    0x8760_f80d,
    0x4130_942b,
    0x9cf8_be32,
    0x84ad_9907,
    0x8c66_52b7,
    0x71b4_9e7e,
    0xf83e_aab3,
    0x1b08_0a77,
    0x34f4_14a5,
    0x3cda_937c,
    0x927f_c62e,
    0x056a_4d3e,
    0x3e42_cc81,
    0xdc64_d77d,
    0x49b2_0021,
    0x843f_0009,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0xb000_0000,
    0xa800_0000,
    0x4400_0000,
    0x1600_0000,
    0x5100_0000,
    0x5f80_0000,
    0xa040_0000,
    0xe3a0_0000,
    0xbbd0_0000,
    0xe298_0000,
    0x9efc_0000,
    0x16ca_0000,
    0xe425_0000,
    0xd794_8000,
    0x033f_c000,
    0x7a2e_e000,
    0x16d5_d000,
    0xd719_1800,
    0xc5be_4400,
    0xb1ef_b600,
    0x0b32_8300,
    0x2a69_d180,
    0x7d74_2f40,
    0x78ca_a9a0,
    0x2920_7b70,
    0x9212_e798,
    0x1079_6c5c,
    0x290d_9832,
    0x47c1_840d,
    0x3fe1_5617,
    0xf277_5329,
    0x4248_c9b8,
    0x88e6_6b6d,
    0x74f7_1f8a,
    0xa98b_f862,
    0xc505_b60f,
    0x9187_833d,
    0xfd45_5197,
    0x5e27_ef4d,
    0xf496_4987,
    0x4bbc_ab6b,
    0xcced_7fa4,
    0xe6b1_e85c,
    0x7d2a_4e03,
    0x3850_173f,
    0x78d9_ff90,
    0x9e5e_2856,
    0x059c_ae36,
    0x0079_c72f,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x5000_0000,
    0x7800_0000,
    0x7c00_0000,
    0x5200_0000,
    0xd500_0000,
    0x1b80_0000,
    0xe8c0_0000,
    0xf420_0000,
    0x0310_0000,
    0xbca8_0000,
    0xcbcc_0000,
    0x5c3a_0000,
    0x23a1_0000,
    0x51d7_8000,
    0xf98a_4000,
    0xad5e_a000,
    0xf750_b000,
    0xaeca_d800,
    0xafb9_6400,
    0xaf62_7200,
    0xdbf5_1b00,
    0x0598_0f80,
    0xa373_24c0,
    0x9ddb_f7a0,
    0x3b10_b0f0,
    0x60ad_fdb8,
    0xa9cc_7fe4,
    0xa13d_5826,
    0x3c23_243b,
    0x9714_d212,
    0x8aa9_ab3e,
    0x60c8_d78c,
    0xb8bb_40d0,
    0x79e6_058f,
    0x04b3_ebff,
    0x3379_522c,
    0xfd42_eb2c,
    0x6be1_f783,
    0x71b1_b0f1,
    0x18fa_7d86,
    0x3d86_3fde,
    0x9bc3_f802,
    0x5ca3_9420,
    0x2356_0a29,
    0x38cc_cf19,
    0x34b8_a5b3,
    0x63e3_5bf8,
    0x85b3_8a0b,
    0x7efb_8f30,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0xf000_0000,
    0x3800_0000,
    0x6c00_0000,
    0x8200_0000,
    0xdf00_0000,
    0x3880_0000,
    0x13c0_0000,
    0xea60_0000,
    0x38f0_0000,
    0xaa28_0000,
    0x630c_0000,
    0x565e_0000,
    0xd0e1_0000,
    0xb432_8000,
    0x98c9_4000,
    0xb839_2000,
    0x2e10_b000,
    0xe71c_8800,
    0xca47_ac00,
    0xf423_e200,
    0x62d3_a900,
    0x75fe_fa80,
    0x0174_edc0,
    0x4469_d2a0,
    0x012a_b1d0,
    0xe58f_9898,
    0x309e_04ec,
    0x7906_0816,
    0x7182_ec37,
    0xfa44_c216,
    0x6c22_1910,
    0x1ed0_f2a0,
    0x3ffa_01e8,
    0x8a73_10b4,
    0x92e9_a8ed,
    0x4fed_ea06,
    0xe86d_453e,
    0x232c_38b3,
    0x2a8b_f4c5,
    0xc01d_a01c,
    0x3ec4_f036,
    0x75e1_2800,
    0x9fb3_5c16,
    0x218a_ca00,
    0x569c_f50e,
    0x9002_309a,
    0x8805_18c0,
    0xb407_6208,
    0x1e07_e912,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x7000_0000,
    0xb800_0000,
    0xdc00_0000,
    0x6600_0000,
    0xa700_0000,
    0xf780_0000,
    0x0640_0000,
    0xc620_0000,
    0xd770_0000,
    0x18f8_0000,
    0x731c_0000,
    0xc20a_0000,
    0x8ca5_0000,
    0xb7b2_8000,
    0xa019_4000,
    0x878c_a000,
    0xcfe2_1000,
    0xeb11_e800,
    0xffad_3400,
    0xd390_f600,
    0x3a6c_9f00,
    0x81f6_6880,
    0xfe3b_c540,
    0x1cf9_a0a0,
    0x791d_a170,
    0x5b0c_1e98,
    0x7022_1a6c,
    0x9871_6836,
    0x1b7d_741b,
    0x075c_d60f,
    0xa12e_cf02,
    0xb153_a08a,
    0x9f88_a15f,
    0x43e6_9eb5,
    0xa517_5a6d,
    0x4caf_c812,
    0x2616_6404,
    0x212d_be11,
    0x7153_bb21,
    0x7f8f_76ac,
    0x33e6_6e49,
    0x1d15_3e38,
    0x90af_fb20,
    0x4011_5682,
    0x862d_3e4c,
    0x86d0_7616,
    0x79cc_df2c,
    0xf5c2_48b9,
    0xca65_9544,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x7000_0000,
    0xd800_0000,
    0x3c00_0000,
    0xbe00_0000,
    0xc100_0000,
    0xa880_0000,
    0x67c0_0000,
    0x79e0_0000,
    0xc0d0_0000,
    0x1e38_0000,
    0x049c_0000,
    0x8c6e_0000,
    0x6e65_0000,
    0xee92_8000,
    0xb89e_4000,
    0x7268_a000,
    0xcf64_d000,
    0x3613_1800,
    0x075e_3c00,
    0x3789_3200,
    0xb1b4_9500,
    0xe92b_e780,
    0xab42_4040,
    0xdc22_dfa0,
    0xa636_ec50,
    0xc768_55b8,
    0x0de4_954c,
    0xaad7_980e,
    0xe539_7c03,
    0x9f1d_1201,
    0xe42b_0523,
    0x25c2_dfb3,
    0x26e6_ec66,
    0xb950_55bb,
    0x7978_9549,
    0xfeb9_980b,
    0xb75c_7c24,
    0xcf8f_9214,
    0x9db5_4539,
    0xff2a_7f86,
    0x8e42_3c4b,
    0xf6a3_4da1,
    0xbef6_a97f,
    0xd708_aa26,
    0x0274_e939,
    0xaaca_75ab,
    0x5892_057c,
    0xcd9a_2027,
    0x90ea_9032,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0xf000_0000,
    0x9800_0000,
    0x1c00_0000,
    0xba00_0000,
    0x2900_0000,
    0xd880_0000,
    0x89c0_0000,
    0x3220_0000,
    0xc610_0000,
    0x7c18_0000,
    0xeb7c_0000,
    0xe88e_0000,
    0x0fa1_0000,
    0xe552_8000,
    0x7afc_4000,
    0x09cf_a000,
    0xcc47_f000,
    0xfd61_7800,
    0xe2f2_dc00,
    0xaba8_8200,
    0xad33_3b00,
    0xba8c_df80,
    0xe2a3_d940,
    0x7bd0_87a0,
    0x903a_b550,
    0x526e_dd98,
    0x4710_a26c,
    0x809d_f83e,
    0xd4bf_9c2b,
    0x21ad_a230,
    0xbc34_8b31,
    0x6e0c_07be,
    0xb967_f56f,
    0xe4f3_fdb4,
    0x28ab_1249,
    0x34b3_203d,
    0x6fca_b005,
    0xff44_5837,
    0x1ce5_6c33,
    0xdbb0_5a14,
    0x944b_172a,
    0xff01_a599,
    0x9383_7e46,
    0x8447_fa1e,
    0x2960_e716,
    0xccf6_ddbc,
    0x4cac_a257,
    0x62b3_f818,
    0x64ce_9c05,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0xb000_0000,
    0x6800_0000,
    0x3c00_0000,
    0x6a00_0000,
    0x4500_0000,
    0xd880_0000,
    0x0ec0_0000,
    0x8ba0_0000,
    0xd1f0_0000,
    0xc2b8_0000,
    0x755c_0000,
    0x24ce_0000,
    0x84a1_0000,
    0x5c70_8000,
    0x2cf9_c000,
    0x143b_2000,
    0x409f_f000,
    0x84e9_9800,
    0x1c13_3c00,
    0xee2f_5a00,
    0xe9b6_cf00,
    0xccdc_d480,
    0x6c8c_1f40,
    0x42c6_eca0,
    0x29a5_1350,
    0xf8f5_0e98,
    0xa83e_107c,
    0x6a9f_9802,
    0x21ee_3c33,
    0x7491_da38,
    0x88ee_0f32,
    0x5e17_74b6,
    0x772a_2f5d,
    0xeb34_54ae,
    0xef19_df76,
    0x03ab_ccbc,
    0xf7f7_e356,
    0x25ba_1699,
    0x84d9_ec7b,
    0x408d_6236,
    0x10c3_c315,
    0x88a1_3695,
    0x1e76_1c4b,
    0xb5fc_fa07,
    0x16bc_ff25,
    0x6358_6c99,
    0xebcd_d37a,
    0xa926_aebe,
    0xe234_2072,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x3000_0000,
    0xb800_0000,
    0x1400_0000,
    0xe600_0000,
    0xc900_0000,
    0x7080_0000,
    0x1b40_0000,
    0xede0_0000,
    0xf390_0000,
    0xc3c8_0000,
    0x83ec_0000,
    0xdfde_0000,
    0x1ae1_0000,
    0x2e14_8000,
    0x160b_4000,
    0x9848_e000,
    0xef2c_5000,
    0xecf8_d800,
    0x1552_7c00,
    0x6bec_5600,
    0x03db_d100,
    0xb0e5_f980,
    0x2517_f5c0,
    0xf189_41a0,
    0x2e8e_99d0,
    0x8f0b_2f98,
    0x20ca_64dc,
    0xb86e_d836,
    0xc31f_7c19,
    0x71c6_d62f,
    0x05a1_913b,
    0x0df1_998b,
    0x509c_e5f1,
    0x5107_79be,
    0xf481_b5d8,
    0x9543_218f,
    0xb8e4_89c6,
    0xc911_978a,
    0xe38e_08c3,
    0x318e_3603,
    0x8e8d_c108,
    0x5f09_41a9,
    0xa8ce_99c5,
    0x146b_2f86,
    0x311a_64e6,
    0x5ec6_d831,
    0xbc23_7c0a,
    0x6630_d63b,
    0xa63c_9119,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xb000_0000,
    0x8800_0000,
    0x0400_0000,
    0x4e00_0000,
    0x8f00_0000,
    0xb480_0000,
    0xa4c0_0000,
    0x8a20_0000,
    0x0170_0000,
    0x99d8_0000,
    0x05bc_0000,
    0xc12e_0000,
    0xb927_0000,
    0x37f6_8000,
    0xd818_c000,
    0x4a1d_e000,
    0xd718_1000,
    0xbe99_2800,
    0x53d9_2c00,
    0x84ba_3a00,
    0xdaaa_3300,
    0x1965_ec80,
    0x9114_7c40,
    0x574f_a4a0,
    0x9cb1_8050,
    0xc47f_56a8,
    0xce8d_8f7c,
    0x8f17_280a,
    0x804e_2c3d,
    0x3434_ba39,
    0x12be_f30e,
    0x09ae_0c9c,
    0xffe7_6c4b,
    0xc8d6_0cbc,
    0x24eb_6c5a,
    0x4880_0c81,
    0x06c0_6c54,
    0xdf20_8cbe,
    0x4cf3_ac52,
    0x8a9d_ec82,
    0xd5d8_7c47,
    0x2fb9_a49b,
    0x902a_805a,
    0xbaa7_d6a6,
    0xabb2_4f60,
    0xbcfc_482c,
    0x004e_fc21,
    0x7430_7228,
    0x32bf_cf0e,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x9000_0000,
    0xd800_0000,
    0xe400_0000,
    0xaa00_0000,
    0xe300_0000,
    0x8280_0000,
    0x1dc0_0000,
    0xeb20_0000,
    0xf7d0_0000,
    0xdab8_0000,
    0xb8dc_0000,
    0x54ee_0000,
    0x7927_0000,
    0x00d7_8000,
    0x9a3b_4000,
    0xea19_6000,
    0xab4a_b000,
    0x3e32_6800,
    0xfac9_dc00,
    0xa974_a200,
    0x102c_c300,
    0x6b81_b980,
    0xac45_da40,
    0x8c65_31a0,
    0x7531_f650,
    0xb44c_9ba8,
    0x92b5_5974,
    0x1e0a_681e,
    0x6bd5_dc0d,
    0x44ba_a214,
    0x09db_c325,
    0x416e_39bc,
    0x9462_9a46,
    0xf132_5190,
    0xae4c_4652,
    0x39b1_7384,
    0xa08b_c560,
    0x3811_aa07,
    0xe698_af00,
    0x9f88_f3b7,
    0x0497_8573,
    0xda5f_4a33,
    0xb929_5f04,
    0xfa03_fb8d,
    0x5b04_e954,
    0xd681_8025,
    0xffc0_402d,
    0x3420_e004,
    0x3b56_f000,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x7000_0000,
    0x7800_0000,
    0x1c00_0000,
    0xd600_0000,
    0x1100_0000,
    0x9d80_0000,
    0x0c40_0000,
    0xc6e0_0000,
    0x3890_0000,
    0xf368_0000,
    0xb64c_0000,
    0xcf7a_0000,
    0x70e5_0000,
    0x9992_8000,
    0xf6ef_4000,
    0xd60c_a000,
    0xa79f_9000,
    0x4573_d800,
    0x2178_5400,
    0x5de7_4600,
    0x4214_1900,
    0xe3ad_0180,
    0xe969_30c0,
    0x5948_f9a0,
    0xb7fd_b4f0,
    0x2322_c798,
    0xf037_69ec,
    0x4e1b_d806,
    0x4b34_542b,
    0xa49d_4613,
    0x53f1_191f,
    0x9fbf_818c,
    0x0fc6_70c0,
    0x9fa4_5983,
    0x39f2_24f9,
    0x08b9_1fb2,
    0x6b43_3dcc,
    0x1a66_9e38,
    0x4155_4d14,
    0x2dca_c7ba,
    0xfa3b_69d3,
    0xdf81_d80c,
    0x6f41_5438,
    0x6067_c619,
    0x1e52_5909,
    0xcd49_2187,
    0xc5fc_e0d6,
    0x1825_0195,
    0xdab5_30e9,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x7000_0000,
    0xe800_0000,
    0x0c00_0000,
    0x5e00_0000,
    0xed00_0000,
    0x4e80_0000,
    0xc040_0000,
    0x68e0_0000,
    0xc7f0_0000,
    0x63d8_0000,
    0x58fc_0000,
    0x712a_0000,
    0x21a3_0000,
    0x7394_8000,
    0xf76d_c000,
    0x8040_a000,
    0x88e3_d000,
    0x97f4_f800,
    0xfbdc_6c00,
    0xbcf8_5e00,
    0x232d_5100,
    0x92a2_8a80,
    0xd015_8e40,
    0x79a8_52a0,
    0x28e4_f270,
    0x27f0_d4a8,
    0x33db_df6c,
    0xc0fe_5812,
    0x952c_bc2f,
    0x73a0_2625,
    0xc090_fd24,
    0x54e8_74be,
    0x0e84_0f48,
    0x2040_a03e,
    0x38e3_d00a,
    0x5ff4_f819,
    0x87dc_6c0b,
    0x0af8_5e24,
    0xc22d_512c,
    0x8222_8a8f,
    0xfd55_8e58,
    0x5fc8_5293,
    0x2f54_f257,
    0x2cc8_d4ab,
    0xacd7_df7c,
    0xd20c_5820,
    0xec73_bc2d,
    0x711e_a617,
    0x165e_3d2e,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0xf000_0000,
    0xc800_0000,
    0x9c00_0000,
    0x7e00_0000,
    0x0f00_0000,
    0x3780_0000,
    0xd640_0000,
    0x6e20_0000,
    0x5e10_0000,
    0xefb8_0000,
    0x475c_0000,
    0xbaae_0000,
    0x6565_0000,
    0x9eb6_8000,
    0x536a_c000,
    0x6101_2000,
    0x4083_5000,
    0xd5c4_6800,
    0xaa65_b400,
    0x8931_3600,
    0x1528_9f00,
    0x3720_c380,
    0x4a94_8440,
    0xd87d_0ba0,
    0x9c3d_a050,
    0x0b1f_f5b8,
    0x9189_1b6c,
    0x11f3_480a,
    0x29cf_e40b,
    0x08d5_de35,
    0x745e_eb18,
    0x2328_55a0,
    0xe420_8b51,
    0x6316_0029,
    0xf139_0031,
    0x0d98_8035,
    0x1f4f_c00f,
    0x6e17_a03c,
    0x07b9_9038,
    0x4b5d_482d,
    0xfcaa_e41f,
    0x3e63_5e1c,
    0x4b34_2b28,
    0xf429_7591,
    0x37a3_db79,
    0xff52_6814,
    0x821c_b43e,
    0xdd09_b62c,
    0x8237_5f18,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x1000_0000,
    0x1800_0000,
    0x8c00_0000,
    0x5200_0000,
    0xd700_0000,
    0x3180_0000,
    0xdfc0_0000,
    0x8020_0000,
    0x5cb0_0000,
    0x9318_0000,
    0xa27c_0000,
    0x44ae_0000,
    0xeae1_0000,
    0x9215_8000,
    0x45ef_4000,
    0xb880_2000,
    0x2b44_3000,
    0x5967_4800,
    0x22d5_2400,
    0x8849_0a00,
    0x61f3_1300,
    0x7b78_8a80,
    0x482f_c440,
    0xafa4_62a0,
    0xa670_9050,
    0x05bf_8098,
    0x188d_d754,
    0x1c51_681e,
    0x4a0c_1437,
    0x9c15_c22a,
    0x78e8_7712,
    0x2204_209e,
    0x9f07_a761,
    0x4583_8018,
    0x11c2_4005,
    0x1d23_a030,
    0x3636_700c,
    0x2f5c_e813,
    0x2a9f_5426,
    0xa9bb_e205,
    0xfa8d_4736,
    0x2356_e897,
    0xff8d_c356,
    0x85d2_aa1c,
    0xf1c9_6314,
    0xca32_6286,
    0x355d_9076,
    0x899c_009d,
    0x563f_974b,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x1000_0000,
    0x0800_0000,
    0x7c00_0000,
    0x3200_0000,
    0xf700_0000,
    0x3880_0000,
    0xd240_0000,
    0x31a0_0000,
    0x7210_0000,
    0xd9c8_0000,
    0xc9ac_0000,
    0x32da_0000,
    0x3de7_0000,
    0x4eb3_8000,
    0xb85d_c000,
    0xd8a7_2000,
    0xe794_3000,
    0x0808_c800,
    0x38cb_6c00,
    0x202a_ae00,
    0xd11a_3b00,
    0x3b82_9f80,
    0x64c0_abc0,
    0x86e4_f7a0,
    0x9c35_37f0,
    0x491a_3188,
    0x8f81_90f4,
    0x8ac7_e80a,
    0x53e3_5c2b,
    0x5bb0_6626,
    0xdfda_5726,
    0x5e61_b180,
    0x3e70_50d6,
    0xc0ba_c82e,
    0x9990_6c25,
    0x150b_2e1c,
    0x234c_fb1e,
    0x94ec_3fb4,
    0xfffe_5bfe,
    0xcbb0_9f85,
    0x17db_abde,
    0x8265_77af,
    0x1c73_f7d8,
    0x3fbc_91a1,
    0xdd13_60ee,
    0xf549_800c,
    0xe5ea_c027,
    0xde7c_a020,
    0xf475_f03e,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x5000_0000,
    0x9800_0000,
    0xa400_0000,
    0x6200_0000,
    0xf300_0000,
    0x7080_0000,
    0xf340_0000,
    0x1e20_0000,
    0x0af0_0000,
    0x2088_0000,
    0xcc6c_0000,
    0xb87e_0000,
    0xf7e5_0000,
    0x0893_8000,
    0xb2dd_4000,
    0x4c57_6000,
    0xf538_f000,
    0xccc6_a800,
    0x1be7_8c00,
    0x1694_4600,
    0xe7db_4f00,
    0xfdd4_ec80,
    0x1df9_1ac0,
    0xf520_a4a0,
    0x9e72_26d0,
    0xd1c8_aab8,
    0x714e_55c4,
    0x5a0a_481e,
    0x802e_3c2d,
    0xb8db_8e26,
    0xf351_3301,
    0xebbd_82a2,
    0xc284_99e9,
    0xd841_6e23,
    0xaaa1_8312,
    0xcbb7_ca8b,
    0x55aa_a5d9,
    0x121a_e027,
    0x09b0_b035,
    0xd6aa_4824,
    0xca9e_3c0a,
    0x96f3_8e05,
    0x968d_3339,
    0xf56b_82bd,
    0x57fd_99e9,
    0x2a24_ee11,
    0xd0f5_c31d,
    0x478d_2ab8,
    0x16ea_15d3,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x7000_0000,
    0x7800_0000,
    0x3c00_0000,
    0xd200_0000,
    0x8d00_0000,
    0x2980_0000,
    0x12c0_0000,
    0xd160_0000,
    0xdc30_0000,
    0xa318_0000,
    0x863c_0000,
    0x552e_0000,
    0xd427_0000,
    0x0890_8000,
    0x6ec9_4000,
    0x5c55_a000,
    0x94ae_b000,
    0x92e6_1800,
    0x1ff2_3400,
    0xd9ff_7200,
    0xcdc9_3100,
    0x4ad3_ac80,
    0x72eb_fa40,
    0x70c6_94a0,
    0x4465_3e50,
    0x99b4_dea8,
    0x6bde_cb4c,
    0x9e5b_3836,
    0x4e99_c403,
    0x3afa_ca22,
    0xfb4e_b530,
    0xdc94_46a0,
    0xe8ce_bf68,
    0x1757_6a2a,
    0xd62c_0500,
    0xb2a4_5e9e,
    0x96d7_8b4e,
    0xb0ee_9837,
    0xd5c7_743c,
    0x59e4_d203,
    0x1d70_8130,
    0xd9bd_3494,
    0x34ec_8e40,
    0x5bc2_4691,
    0x56e5_bf7d,
    0xb1f1_ea0f,
    0xa6fe_4538,
    0x194f_7eb7,
    0x0997_7b79,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x5000_0000,
    0x6800_0000,
    0x6c00_0000,
    0x5e00_0000,
    0xc700_0000,
    0xde80_0000,
    0xd240_0000,
    0x77e0_0000,
    0x4850_0000,
    0x4508_0000,
    0x4f2c_0000,
    0x975e_0000,
    0x5f21_0000,
    0x2ff7_8000,
    0x3bbe_c000,
    0x0ff6_a000,
    0xcbb8_d000,
    0xd7f4_a800,
    0x9fba_bc00,
    0x8df6_1e00,
    0x6ab8_3900,
    0xca75_df80,
    0xa17e_0dc0,
    0xb156_57a0,
    0x4c8f_a1d0,
    0xcbeb_c198,
    0x0efa_34c4,
    0x5695_8802,
    0x89ac_ac1f,
    0xb11c_1635,
    0xc2c6_553e,
    0xaaa1_69ba,
    0x3d31_88de,
    0xb91c_161d,
    0xbec6_5507,
    0x7ca1_6983,
    0xc631_88e1,
    0x519c_1613,
    0xc786_551d,
    0x8bc1_6990,
    0x9b21_88ef,
    0xbdf4_1620,
    0x12ba_5514,
    0x2e77_698f,
    0xc37c_88ec,
    0x4055_9609,
    0x3909_9523,
    0x9928_49b3,
    0x6c5b_98f5,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0xf000_0000,
    0xb800_0000,
    0x7c00_0000,
    0x3e00_0000,
    0x5100_0000,
    0x2a80_0000,
    0x0840_0000,
    0x6220_0000,
    0xa4f0_0000,
    0xf3b8_0000,
    0x845c_0000,
    0xdd4a_0000,
    0x1ce7_0000,
    0xc094_8000,
    0x7c6f_4000,
    0x7595_a000,
    0x24e9_d000,
    0x0ad1_9800,
    0xb14b_ac00,
    0x0ae7_5e00,
    0x0590_6700,
    0x5cef_4480,
    0xd6d3_4340,
    0x7f4d_fca0,
    0xe3e5_7f70,
    0x5310_1a88,
    0x6aaf_244c,
    0xe5f0_b826,
    0xf13d_3c13,
    0x181b_6609,
    0xb56e_1b37,
    0x1313_82ab,
    0x0aaf_8849,
    0xb5f1_663d,
    0xb939_1b0f,
    0xdc1f_0286,
    0xf76c_c876,
    0x7c16_c61d,
    0x712b_cb20,
    0x9730_1a9c,
    0xd35f_2451,
    0x1ac8_b81e,
    0xa021_3c3c,
    0x0bf1_6610,
    0x2839_1b3b,
    0x569f_0285,
    0x0f2c_c858,
    0xa636_c617,
    0xa9db_cb12,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0xd000_0000,
    0xa800_0000,
    0x0c00_0000,
    0x5e00_0000,
    0x6300_0000,
    0x7580_0000,
    0xebc0_0000,
    0xd860_0000,
    0x9a30_0000,
    0xf698_0000,
    0xd5bc_0000,
    0x5eae_0000,
    0x2e23_0000,
    0x4591_8000,
    0x9ace_c000,
    0xa217_a000,
    0xac0d_d000,
    0x1cf0_8800,
    0xd07e_c400,
    0x7dcb_aa00,
    0x1592_d100,
    0x72cd_fc80,
    0x0e11_5e40,
    0x220d_54a0,
    0xd7f3_8a50,
    0xa9fe_5688,
    0xc80f_8f64,
    0xaef6_a822,
    0x9d7d_d427,
    0x134c_8215,
    0x2fd1_c52f,
    0x136e_dea0,
    0x7141_4b61,
    0x5825_021c,
    0x6a93_0514,
    0x114f_7ebe,
    0xfad3_9b5d,
    0xa9ea_0a16,
    0x6100_010b,
    0xa082_f484,
    0x5142_5a74,
    0xc820_deb9,
    0x6292_4b6f,
    0xcd4c_8217,
    0x0cd1_c523,
    0xc6ee_de92,
    0x4a81_4b62,
    0x2845_0238,
    0xfca3_0514,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x3000_0000,
    0x8800_0000,
    0xd400_0000,
    0xaa00_0000,
    0xdb00_0000,
    0x2480_0000,
    0x20c0_0000,
    0xa760_0000,
    0x36b0_0000,
    0x2538_0000,
    0xa31c_0000,
    0x078e_0000,
    0x4c27_0000,
    0x6f92_8000,
    0xd72c_c000,
    0x5f77_6000,
    0x61dd_b000,
    0xcfe8_2800,
    0xe415_2c00,
    0x0969_ba00,
    0xabd7_3900,
    0x308f_1880,
    0xdea4_9f40,
    0xca54_d0a0,
    0x15cb_c350,
    0x3e86_a2a8,
    0x33c3_a65c,
    0x77e3_c80a,
    0x8c73_5c29,
    0xd15c_7200,
    0x652f_650f,
    0xa877_ea81,
    0x935c_3a4b,
    0x7a28_da2a,
    0x9ef1_8923,
    0x349b_b0a1,
    0x87ca_7361,
    0xf980_8aa3,
    0x4941_8a53,
    0x1620_f211,
    0x5c94_a524,
    0x37aa_0aae,
    0x6db1_4a4f,
    0x41b9_923e,
    0xa3de_150a,
    0x90e8_a284,
    0xf294_a651,
    0x9ea9_481e,
    0xde33_9c17,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x7000_0000,
    0x8800_0000,
    0xfc00_0000,
    0xe200_0000,
    0x0700_0000,
    0x5c80_0000,
    0x8b40_0000,
    0x5da0_0000,
    0xdeb0_0000,
    0x9b68_0000,
    0x400c_0000,
    0xedde_0000,
    0x1763_0000,
    0x67d4_8000,
    0x71ba_c000,
    0x4634_2000,
    0x662e_b000,
    0xd4a9_c800,
    0x72e8_4c00,
    0x28c9_c600,
    0xb3bb_3300,
    0x7133_9280,
    0x12af_dbc0,
    0xd3ec_faa0,
    0x454c_e7d0,
    0x0d7a_5488,
    0x9654_e8cc,
    0xbd7f_682a,
    0xfe53_3c33,
    0x917e_ae32,
    0xe454_0f22,
    0xe27b_3c8d,
    0xa6d4_d4dc,
    0x8c3d_4618,
    0xa0f1_f304,
    0x854f_b28e,
    0xed7d_6bd9,
    0x4653_3288,
    0x457b_abcd,
    0x8a51_12b4,
    0x8f7a_1bc4,
    0x0152_5a8e,
    0xb9fb_97d1,
    0x7113_3cb8,
    0x5ad8_d4dc,
    0x23e3_460d,
    0xc092_f329,
    0x361b_32aa,
    0xeb87_abc6,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0xf000_0000,
    0x7800_0000,
    0x5400_0000,
    0x5600_0000,
    0x6f00_0000,
    0x4d80_0000,
    0xac40_0000,
    0x2b20_0000,
    0x1a70_0000,
    0x7068_0000,
    0x2a1c_0000,
    0xfa72_0000,
    0x406d_0000,
    0x3218_8000,
    0x5e76_4000,
    0x6e6c_6000,
    0x0918_9000,
    0x45f7_8800,
    0xad2d_7400,
    0x6fbf_9e00,
    0xf3c3_b300,
    0xf664_fe80,
    0x5fd0_cec0,
    0x79db_60a0,
    0x9c13_7df0,
    0x97bf_9e38,
    0x67c3_b30c,
    0xc064_fe86,
    0xc0d0_cee9,
    0x4c5b_60ab,
    0x6453_7dfe,
    0xea9f_9e3e,
    0x12b3_b33c,
    0xfd8c_fe9f,
    0x468c_cec4,
    0x9d09_60bd,
    0x3e4e_7df2,
    0xa8ef_1e1c,
    0x66d9_f326,
    0x6992_9ead,
    0x0ff9_5ec3,
    0xeae6_68aa,
    0xcd15_49e7,
    0xa93c_e016,
    0x9c02_d00f,
    0xda01_e827,
    0xfd04_e414,
    0xfc82_962c,
    0xa2c5_873c,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x1000_0000,
    0x7800_0000,
    0x7400_0000,
    0xba00_0000,
    0x0500_0000,
    0xb480_0000,
    0xb240_0000,
    0x56e0_0000,
    0xf610_0000,
    0x0d48_0000,
    0xdb5c_0000,
    0x8616_0000,
    0x854f_0000,
    0x6759_8000,
    0x2015_4000,
    0x364f_6000,
    0x18df_f000,
    0x99d0_b800,
    0x636a_ec00,
    0xbeef_c600,
    0x862f_9d00,
    0x158b_eb80,
    0x18fa_1cc0,
    0x5364_2da0,
    0xaad5_81d0,
    0x5cef_c608,
    0xa72f_9d14,
    0xc30b_ebb6,
    0xcbba_1cd9,
    0x7304_2d90,
    0x9f85_81cc,
    0x09c7_c60b,
    0x3d23_9d39,
    0xaa35_eb8e,
    0xd1f9_1cc8,
    0xc9e3_ad86,
    0x1793_c1c7,
    0xd38f_2629,
    0x5bfa_2d2e,
    0xe4e5_b3b6,
    0x0f16_40e1,
    0xbfca_3392,
    0xca1c_00c9,
    0xd774_d382,
    0xbe9a_b0f0,
    0x8535_0b9f,
    0x587c_acc8,
    0x1b25_f590,
    0x5933_9dea,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x7000_0000,
    0x6800_0000,
    0xa400_0000,
    0xe600_0000,
    0xaf00_0000,
    0x9d80_0000,
    0xea40_0000,
    0x0f60_0000,
    0xb190_0000,
    0x8b48_0000,
    0xf2dc_0000,
    0x8d92_0000,
    0x6149_0000,
    0xffd8_8000,
    0x2912_c000,
    0xd18f_6000,
    0x237a_9000,
    0x9ba0_8800,
    0x4b36_f400,
    0x76fd_2e00,
    0x85e1_a100,
    0x5a54_0380,
    0xd46f_78c0,
    0xb929_2da0,
    0xafce_d9f0,
    0x821d_2e18,
    0xb131_a12c,
    0xa3fc_03a2,
    0x0d63_78f5,
    0xd893_2d83,
    0x29cb_d9f2,
    0x9d1f_ae06,
    0xa4b6_613d,
    0x9db9_e386,
    0x8c02_28e3,
    0x6204_45a2,
    0xd905_7de2,
    0x2a85_6807,
    0xbbc7_a419,
    0xa722_461a,
    0xf7f3_0531,
    0x085c_c589,
    0x0e57_bdd0,
    0x9a6a_082d,
    0x522d_341f,
    0xa44a_ce3b,
    0xaf59_f12b,
    0x87d3_ebbb,
    0x1e2f_1cef,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0xb000_0000,
    0xc800_0000,
    0x1400_0000,
    0xce00_0000,
    0x3500_0000,
    0xd380_0000,
    0xcac0_0000,
    0x5220_0000,
    0x18f0_0000,
    0xe2c8_0000,
    0x623c_0000,
    0xacf6_0000,
    0xbcc9_0000,
    0x4f3a_8000,
    0x1375_c000,
    0x640f_e000,
    0xf21c_5000,
    0x2302_1800,
    0xaa80_d400,
    0xdb40_9a00,
    0x0fe0_df00,
    0xbe53_8280,
    0x0c79_cbc0,
    0x3093_18a0,
    0xa859_14d0,
    0xa160_9a38,
    0xf310_df3c,
    0x3a9b_82aa,
    0xff45_cbe9,
    0x49e5_18a1,
    0xff50_14d8,
    0xa1fa_1a3f,
    0x0755_1f03,
    0x3dfc_628a,
    0xbd55_9bdd,
    0x76f9_008d,
    0x93d5_c0c6,
    0x7bbe_002c,
    0xc535_0034,
    0x046c_8032,
    0xec8c_c036,
    0x4e5d_6027,
    0x7065_902e,
    0x4693_f805,
    0x6159_841e,
    0x78e6_0226,
    0xbad0_cb36,
    0x5238_78bf,
    0x24f5_84e6,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x1000_0000,
    0x0800_0000,
    0x3400_0000,
    0xca00_0000,
    0xd300_0000,
    0xbf80_0000,
    0x5140_0000,
    0x0c20_0000,
    0x6a70_0000,
    0x8a68_0000,
    0x341c_0000,
    0x0476_0000,
    0xdb6b_0000,
    0x4c9d_8000,
    0x30b6_c000,
    0x5d0a_e000,
    0xa14a_7000,
    0x4bee_0800,
    0x3c5d_8400,
    0x44d7_0600,
    0x4fd9_e300,
    0x9394_3680,
    0x56fd_46c0,
    0x7363_30a0,
    0x1754_a5d0,
    0x889f_0628,
    0x82b5_e314,
    0x820a_368a,
    0xf8ca_46c9,
    0x3fa8_b090,
    0xa2f9_65e9,
    0xd960_6635,
    0xf455_5334,
    0x2f18_dea6,
    0xeff6_b2c7,
    0x702c_3eb1,
    0x8bbb_c2fe,
    0xd941_b696,
    0x7827_86cf,
    0x8077_d094,
    0x4969_d5ed,
    0x839a_8e3d,
    0x6135_a71e,
    0x1d4a_50b1,
    0xf5ef_15f5,
    0x0558_6e2d,
    0x3853_d701,
    0xa91a_5885,
    0xfaf5_91d1,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x9000_0000,
    0xf800_0000,
    0xb400_0000,
    0xa600_0000,
    0x9d00_0000,
    0xfe80_0000,
    0xaf40_0000,
    0x6920_0000,
    0x4510_0000,
    0x71d8_0000,
    0x38cc_0000,
    0x7b12_0000,
    0x08d9_0000,
    0x784f_8000,
    0x6d51_4000,
    0xc17b_6000,
    0xbb1f_1000,
    0x2d28_9800,
    0x8ee4_7c00,
    0x2677_9e00,
    0xf76b_ab00,
    0x9540_9d80,
    0x3e22_7840,
    0x4497_03a0,
    0x7319_d370,
    0xd12f_9e18,
    0x14e7_ab14,
    0xc172_9d86,
    0x7eeb_7849,
    0x4b80_83b7,
    0x3dc4_937a,
    0xa466_fe0e,
    0x7f31_bb18,
    0x1b4d_85a3,
    0x0ad2_4473,
    0xbebe_7db1,
    0x3c79_2865,
    0x1599_7b8c,
    0x9a6a_ff54,
    0xc3c4_7803,
    0x3d66_2c1a,
    0xafb6_6607,
    0xf509_c704,
    0x7770_1b91,
    0xdbec_ef60,
    0xe103_602e,
    0xa483_102a,
    0xa842_9803,
    0x70a1_7c17,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x7000_0000,
    0x0800_0000,
    0x2400_0000,
    0x8a00_0000,
    0x1100_0000,
    0x4080_0000,
    0x4640_0000,
    0x9120_0000,
    0xb810_0000,
    0xf068_0000,
    0x727c_0000,
    0xfb16_0000,
    0xbdeb_0000,
    0xf2be_8000,
    0xe375_c000,
    0x475a_6000,
    0x8903_f000,
    0x7c85_1800,
    0xb042_ec00,
    0x5626_c600,
    0x4f92_2300,
    0x49aa_e580,
    0x7e9a_25c0,
    0xc5e4_23a0,
    0x6274_06d0,
    0x1fd8_c628,
    0xb345_230c,
    0x3ba2_658a,
    0xbf54_e5d5,
    0x59c8_c380,
    0xa02e_36dd,
    0x3459_be1a,
    0xec83_3f19,
    0xa841_3bbe,
    0x2a26_eaea,
    0x9996_0018,
    0xfeab_002f,
    0x811e_8038,
    0x5825_c03a,
    0xe492_6034,
    0x302f_f021,
    0x2c5b_1817,
    0x9085_ec2c,
    0x7e46_461c,
    0x9d20_e32c,
    0x6610_05ac,
    0x636b_15c6,
    0x07fb_dbb6,
    0x77d7_dada,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x1000_0000,
    0x5800_0000,
    0x7400_0000,
    0x6600_0000,
    0x8f00_0000,
    0x2680_0000,
    0x6c40_0000,
    0xd760_0000,
    0x90d0_0000,
    0xb048_0000,
    0x8e9c_0000,
    0x5dd2_0000,
    0x07c9_0000,
    0xcf5b_8000,
    0xee70_4000,
    0x8f38_6000,
    0x0c23_1000,
    0xc533_0800,
    0x92db_2c00,
    0x02b6_4600,
    0x5b1e_5100,
    0x7d17_d180,
    0xd1ee_e2c0,
    0x0f69_97a0,
    0x272c_b3f0,
    0x3e4c_4618,
    0x1d9b_5134,
    0xc156_51ae,
    0xbe8b_a2d9,
    0xfbb8_77af,
    0xa966_e3ce,
    0x4bd4_ae08,
    0x00cf_2d0c,
    0x25d9_7f92,
    0x8034_cfe6,
    0xe959_6836,
    0x4171_3c09,
    0x59be_ce13,
    0x2865_3d1e,
    0x3e51_f78e,
    0x100f_a3d8,
    0x5bff_4e30,
    0x7c00_7d2c,
    0x6a00_1798,
    0x6d05_f3da,
    0x8787_a616,
    0xe9c4_0101,
    0x8fa7_3982,
    0xc2f6_9ede,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x1000_0000,
    0xa800_0000,
    0xac00_0000,
    0x1a00_0000,
    0x4300_0000,
    0x5880_0000,
    0x7e40_0000,
    0xcba0_0000,
    0x4f30_0000,
    0x98a8_0000,
    0xf19c_0000,
    0xd836_0000,
    0xbe2b_0000,
    0x4add_8000,
    0xaa13_c000,
    0x90db_2000,
    0x8910_3000,
    0xf85d_0800,
    0x4f55_fc00,
    0x37fe_0600,
    0xb667_2700,
    0xf653_1880,
    0x5c7b_1ac0,
    0x08a5_1ea0,
    0x57b0_3dd0,
    0xc6e8_0628,
    0x2a3c_2714,
    0x3f06_98a2,
    0x8a84_daef,
    0xa140_3e8c,
    0x3127_0deb,
    0x7676_8e38,
    0xbd8d_1b1b,
    0x99e8_3e86,
    0x90bb_0de3,
    0x2640_8e18,
    0xbfa6_1b04,
    0x6135_be88,
    0xd5a8_cdd8,
    0xf41b_ae0a,
    0x0bf6_2b32,
    0x0a48_b6ac,
    0xab8d_31f3,
    0x90ed_a816,
    0x033d_0c06,
    0xbc85_ae2b,
    0xb841_2b3c,
    0x0aa3_369c,
    0x40b5_f1fa,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0xb000_0000,
    0xd800_0000,
    0xfc00_0000,
    0xde00_0000,
    0x2f00_0000,
    0x7480_0000,
    0xc340_0000,
    0x38a0_0000,
    0x68f0_0000,
    0x6448_0000,
    0x76bc_0000,
    0x5ff6_0000,
    0xccc9_0000,
    0xbbfa_8000,
    0x2055_4000,
    0xf4b8_2000,
    0x3ef3_9000,
    0x9f4e_c800,
    0x983c_fc00,
    0x21b7_2e00,
    0xa9ef_9700,
    0xb7cd_3e80,
    0x157e_6bc0,
    0x3e12_10a0,
    0x219d_fcd0,
    0xeac1_2e38,
    0x5666_973c,
    0x8c97_beae,
    0x11db_2bd3,
    0xa8e2_30a1,
    0xbad2_6ce4,
    0x80f9_e612,
    0xeed3_6b07,
    0x5afa_10bd,
    0x33d1_fcf9,
    0xb77f_2e36,
    0x8f13_9723,
    0x1a1b_3ebc,
    0xed07_6bf9,
    0x7580_90bc,
    0x20c4_bcfe,
    0xc367_0e0b,
    0x9510_0737,
    0xe71d_f6a7,
    0xd087_97e4,
    0xa141_beb9,
    0xa9a2_2bc9,
    0x8370_b0bd,
    0x0b8b_2cf2,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0xd000_0000,
    0xe800_0000,
    0x6c00_0000,
    0xee00_0000,
    0x8d00_0000,
    0xf680_0000,
    0xf2c0_0000,
    0x39a0_0000,
    0x4870_0000,
    0x13c8_0000,
    0x7abc_0000,
    0x51f6_0000,
    0xe489_0000,
    0x4259_8000,
    0x9867_c000,
    0x7255_2000,
    0xbbf9_9000,
    0xf016_d800,
    0xd19d_fc00,
    0xf943_3200,
    0x25e1_c300,
    0xb714_1280,
    0xd81f_1fc0,
    0xc601_20a0,
    0xc107_dcd0,
    0xa884_b238,
    0x47c3_0324,
    0x4b26_b2a2,
    0x38b4_4fef,
    0x496d_58a1,
    0x494d_70e8,
    0x467d_f83e,
    0x5551_6c3b,
    0x627a_6a11,
    0x2752_ff01,
    0x597b_808b,
    0x08d0_8cf4,
    0x373e_ca36,
    0xccb0_af28,
    0xd36e_78af,
    0x1e4d_e0c5,
    0x87fa_a01c,
    0xb617_500f,
    0x509a_7813,
    0x31c3_ac2a,
    0xb220_ca01,
    0x1435_af05,
    0x8ca9_f8aa,
    0x616f_20c6,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0xf000_0000,
    0xb800_0000,
    0x1400_0000,
    0x9e00_0000,
    0xd700_0000,
    0x5180_0000,
    0x2540_0000,
    0xe1a0_0000,
    0x95f0_0000,
    0x01e8_0000,
    0x6f1c_0000,
    0xf576_0000,
    0x9629_0000,
    0xf478_8000,
    0x3b64_4000,
    0x1e14_6000,
    0xa038_d000,
    0x0844_0800,
    0x0123_5400,
    0x4234_f600,
    0xfa8b_ef00,
    0x510e_5680,
    0xc549_a6c0,
    0xd66c_a0a0,
    0x595b_49d0,
    0xf352_7638,
    0xad9a_af2c,
    0x77b4_b6b6,
    0xb9cc_36f9,
    0x13ac_48a9,
    0x6f38_8de0,
    0x9dc0_e80b,
    0x9263_c410,
    0x2892_9e1a,
    0x0cf9_6b15,
    0x28a6_28b1,
    0x5375_5dce,
    0x152a_602e,
    0x5bfd_d012,
    0x3922_8834,
    0x1632_143b,
    0x048e_162c,
    0x760e_7f1d,
    0x2cce_be9f,
    0xe72a_62e3,
    0x26fe_3ea6,
    0xb1a2_22cc,
    0xfdf4_5ebe,
    0x3def_f2e0,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0xd000_0000,
    0x9800_0000,
    0x1400_0000,
    0x0200_0000,
    0x2700_0000,
    0xcc80_0000,
    0x8c40_0000,
    0x58a0_0000,
    0x33d0_0000,
    0x2a68_0000,
    0x22bc_0000,
    0x2a52_0000,
    0xc5ab_0000,
    0x16df_8000,
    0x0b60_4000,
    0x39b7_6000,
    0xd25b_3000,
    0x6b27_6800,
    0x0715_3c00,
    0x8c8f_b600,
    0x26cd_0f00,
    0x736a_c780,
    0x573d_6bc0,
    0x6397_71a0,
    0x3ccb_64f0,
    0x806a_3608,
    0x39ba_4f04,
    0x18d0_278e,
    0x30ed_1bf1,
    0x2bf8_f986,
    0x4975_28fc,
    0x2ebd_883b,
    0xfc55_4c2e,
    0x40a8_3e2b,
    0x2d5f_431e,
    0xd3a7_79ba,
    0xf955_68c8,
    0xbb2a_e813,
    0x559e_7c23,
    0xc347_5602,
    0x0826_7f28,
    0x9192_cfb1,
    0x93cf_67f7,
    0x60ed_afb4,
    0x73f8_57f5,
    0xfd70_c78d,
    0xfcba_6bdc,
    0x4352_f18c,
    0x982c_24e7,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0xd000_0000,
    0x9800_0000,
    0xac00_0000,
    0x1200_0000,
    0xb100_0000,
    0xe080_0000,
    0x6fc0_0000,
    0x0920_0000,
    0x83b0_0000,
    0xb128_0000,
    0xc19c_0000,
    0x7932_0000,
    0xfbed_0000,
    0x2639_8000,
    0x7e40_4000,
    0x2664_a000,
    0x5550_7000,
    0x73bf_5800,
    0xc707_2c00,
    0xb787_8a00,
    0xe045_2f00,
    0xf560_5880,
    0x2cd1_2ec0,
    0x18fd_d2a0,
    0x87e5_01f0,
    0x3216_0a38,
    0x9159_6f04,
    0xbb96_f8be,
    0x121c_5edf,
    0x7f73_0a82,
    0x618e_6df7,
    0x996f_2004,
    0xc0fd_3033,
    0x8be2_7804,
    0x9017_1c24,
    0x685c_720c,
    0x6f12_7317,
    0xc3d8_8a8e,
    0xd553_2df9,
    0xb3ba_000d,
    0xa701_002a,
    0x6783_8036,
    0x7841_402e,
    0x5967_2001,
    0x3ed1_3001,
    0xa9f8_7822,
    0x6766_1c04,
    0x5dd7_f228,
    0x987f_3322,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x1000_0000,
    0xb800_0000,
    0x3400_0000,
    0x7e00_0000,
    0x6d00_0000,
    0x6580_0000,
    0x9440_0000,
    0x67a0_0000,
    0xfb10_0000,
    0xd708_0000,
    0xcf1c_0000,
    0xd892_0000,
    0xda4b_0000,
    0x1339_8000,
    0xcac7_4000,
    0xb767_6000,
    0x8777_d000,
    0xdcfd_d800,
    0x3420_2400,
    0xfe53_de00,
    0x972a_0700,
    0x2f48_2180,
    0x92b9_2ec0,
    0x3881_ffa0,
    0x99c4_29f0,
    0xdfe2_5e08,
    0xc6b1_4734,
    0x871d_4186,
    0x2495_fec9,
    0x984d_a791,
    0x9c3f_4de6,
    0x3044_e00e,
    0x61a7_900a,
    0x0211_3806,
    0xdc8b_b412,
    0x8e58_e61d,
    0xeeb6_b31b,
    0xcb1b_4785,
    0xce93_ddfb,
    0x9b4c_5812,
    0x2cbb_642f,
    0xf586_be2d,
    0xec46_d71a,
    0xf3a4_79b7,
    0x9512_4ae4,
    0x020f_4185,
    0x9e9e_fec7,
    0x32d4_278c,
    0xd0e8_0dc3,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x7000_0000,
    0x1800_0000,
    0x2400_0000,
    0x6a00_0000,
    0xaf00_0000,
    0xc380_0000,
    0x2a40_0000,
    0xa060_0000,
    0xed10_0000,
    0x8b18_0000,
    0x070c_0000,
    0xca96_0000,
    0x2b5f_0000,
    0xd86a_8000,
    0x8c05_4000,
    0xb606_e000,
    0x3104_f000,
    0x6e85_6800,
    0x7ac2_8400,
    0x07a5_3e00,
    0xa232_7900,
    0xaae9_0f80,
    0x88c0_7e40,
    0xcca2_31a0,
    0xabb1_0750,
    0x5faf_be08,
    0xf327_390c,
    0x2ff7_efae,
    0xeac8_8e55,
    0x1ab1_59bc,
    0x712c_8372,
    0x29e0_0022,
    0x5850_002d,
    0x50f8_0036,
    0x945c_0024,
    0x93ee_0016,
    0x4a43_0018,
    0x3064_803a,
    0x2516_402a,
    0xc71a_601c,
    0x510e_b018,
    0x2b91_0811,
    0x2ddf_3415,
    0x9ea8_b626,
    0xc5a7_0d19,
    0xd135_d99e,
    0xf76a_c35f,
    0x0f82_6010,
    0x3c42_b035,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x7000_0000,
    0xe800_0000,
    0xac00_0000,
    0x1200_0000,
    0x0500_0000,
    0x6880_0000,
    0x1340_0000,
    0x73e0_0000,
    0xb7d0_0000,
    0xfe88_0000,
    0xda5c_0000,
    0x1756_0000,
    0x71cf_0000,
    0xf3ba_8000,
    0x7982_c000,
    0x1dc5_2000,
    0x93a3_7000,
    0x67b4_7800,
    0xcd99_4c00,
    0x85f2_2e00,
    0x60f9_bd00,
    0x4a64_4d80,
    0x0a10_14c0,
    0x1d28_63a0,
    0x55ea_a9d0,
    0x76c8_ae08,
    0xe63b_7d0c,
    0x9641_6d92,
    0x5b63_64f7,
    0x0494_1b9e,
    0xfd6f_e5fa,
    0x858c_8016,
    0x45dd_c009,
    0xb997_a014,
    0xe1ed_b01e,
    0x60cf_581d,
    0xfd39_3c31,
    0x99c2_d624,
    0xcda1_312f,
    0xa0b7_c3bf,
    0x381b_19eb,
    0xba31_f638,
    0xbe5d_4131,
    0x9951_3b8c,
    0x2ecc_95e1,
    0x4238_f81b,
    0xf844_8c12,
    0xd465_8e24,
    0x2d14_0d3d,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0xf000_0000,
    0x8800_0000,
    0xc400_0000,
    0x0a00_0000,
    0x8f00_0000,
    0x4180_0000,
    0xc0c0_0000,
    0xd2a0_0000,
    0x39d0_0000,
    0x43f8_0000,
    0xc32c_0000,
    0xc852_0000,
    0x6b3b_0000,
    0x858e_8000,
    0x8381_c000,
    0xebc1_6000,
    0xc924_f000,
    0x0e17_e800,
    0x9cdc_1400,
    0xf43e_7a00,
    0xdc0e_bb00,
    0x5f46_2f80,
    0x8f63_5b40,
    0x39f2_55a0,
    0x4d6a_e070,
    0x5bb0_fa08,
    0xe08f_7b0c,
    0xdd07_4f8a,
    0xb287_ab4d,
    0x6745_bd80,
    0xa366_f462,
    0xa7f6_801a,
    0xb06d_c01f,
    0xd933_602e,
    0xafcf_f033,
    0x4a61_6804,
    0x9771_d42c,
    0x9c2d_1a30,
    0x31d1_4b39,
    0x47ff_47b7,
    0x692e_8f44,
    0xb755_4f9f,
    0xa2bc_ab5c,
    0x814b_3d93,
    0x5b27_3473,
    0x5d17_e007,
    0xcb59_3017,
    0x0dfc_8839,
    0x862f_e428,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0xb000_0000,
    0xd800_0000,
    0x6c00_0000,
    0x3600_0000,
    0x9f00_0000,
    0x5080_0000,
    0xfdc0_0000,
    0xc660_0000,
    0xfd10_0000,
    0x3df8_0000,
    0x106c_0000,
    0x9056_0000,
    0x2659_0000,
    0xfb1a_8000,
    0x38bd_4000,
    0xbfc8_a000,
    0x2122_5000,
    0x27b7_0800,
    0xad0d_5c00,
    0x4fc0_fa00,
    0x9b63_3500,
    0x0896_7780,
    0x89bb_a540,
    0x3c4c_0da0,
    0x6a65_d050,
    0xeb12_da38,
    0x72fc_253c,
    0x28e9_dfae,
    0xd994_a977,
    0xba3b_ff9b,
    0xaf0b_b96c,
    0xcac4_57a1,
    0x02e4_b564,
    0x8ad3_a5ab,
    0x3a9a_dc67,
    0x96fd_283d,
    0x5aee_4c3b,
    0xa491_521c,
    0x9fb9_3922,
    0x734d_0584,
    0x52e1_8c7b,
    0xa2d0_a016,
    0xee9e_5035,
    0x7cf9_0830,
    0x2be8_5c02,
    0x0714_7a08,
    0x04fb_752a,
    0xd7ea_57a6,
    0x3911_b568,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x3000_0000,
    0xb800_0000,
    0xe400_0000,
    0xee00_0000,
    0x4300_0000,
    0xf080_0000,
    0x9040_0000,
    0x30a0_0000,
    0xcf70_0000,
    0xa668_0000,
    0xf99c_0000,
    0x1fb2_0000,
    0x7e8f_0000,
    0xc24c_8000,
    0xa8ae_4000,
    0xda79_e000,
    0x30e2_d000,
    0xb7d6_2800,
    0x151f_fc00,
    0x65f3_1600,
    0xf32c_8f00,
    0x36bf_3280,
    0x3206_a6c0,
    0x8900_a4a0,
    0x7d84_69f0,
    0x13c6_7628,
    0xe860_1f3c,
    0x8b90_faa6,
    0xb7bb_8af5,
    0xd385_9ab5,
    0xb0c7_1ad9,
    0x08e2_52af,
    0x93d6_36c8,
    0xdb1d_6cb6,
    0x16f6_45d2,
    0xbbaf_c818,
    0x42fd_2c18,
    0xeca5_3e0f,
    0x0573_7320,
    0x2b6c_2492,
    0x7a1a_29cb,
    0xc777_9604,
    0x3a6e_cf2f,
    0xd39c_d28d,
    0x82b7_76f3,
    0x7508_0ca8,
    0x468a_d5c8,
    0xe648_002f,
    0x66ac_001b,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x1000_0000,
    0x9800_0000,
    0x9c00_0000,
    0xae00_0000,
    0x3d00_0000,
    0xa480_0000,
    0xa440_0000,
    0xdda0_0000,
    0x01f0_0000,
    0x3558_0000,
    0xc02c_0000,
    0xa932_0000,
    0x98bb_0000,
    0x1679_8000,
    0x829e_4000,
    0xc24f_2000,
    0xdea6_1000,
    0xc073_d800,
    0x0999_6c00,
    0x07c9_d600,
    0xd065_7700,
    0x9490_be80,
    0xe948_bb40,
    0x0b20_e8a0,
    0x56b3_8c70,
    0xc17f_7608,
    0x491d_2734,
    0xe18c_468e,
    0xb6c7_c763,
    0x18e2_e6ad,
    0x76d3_9758,
    0xbdec_1e8a,
    0x1457_eb52,
    0x50af_90b0,
    0x7775_b07a,
    0x7219_d83f,
    0xac0e_6c2c,
    0xbc02_562b,
    0x7e00_3713,
    0x0506_1ebc,
    0x2880_eb47,
    0x9244_10ad,
    0x7ca0_f071,
    0x0b77_7831,
    0xac1a_3c3e,
    0xb90c_ae2a,
    0x0c84_4b23,
    0x7045_90bb,
    0xd7a2_b067,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x1000_0000,
    0x2800_0000,
    0x6400_0000,
    0x1e00_0000,
    0xf100_0000,
    0x4180_0000,
    0xcbc0_0000,
    0xdae0_0000,
    0xbd50_0000,
    0xfb38_0000,
    0xefec_0000,
    0x9b16_0000,
    0xc019_0000,
    0x2f5f_8000,
    0x19ff_c000,
    0x688f_6000,
    0xdf86_5000,
    0x7ac7_b800,
    0xfb64_6400,
    0x6696_4200,
    0x09dd_9100,
    0x36b9_6980,
    0x7e2f_1940,
    0xdef0_aba0,
    0xf5cd_4850,
    0x1226_a238,
    0x9d34_0114,
    0x7b29_b192,
    0xe971_2d5d,
    0xcb0f_51ad,
    0x8741_bd75,
    0x32a0_09af,
    0x7f70_495a,
    0x6e08_9394,
    0x80c6_ec50,
    0x5467_803d,
    0xb613_c025,
    0x9399_601d,
    0x0f9f_5018,
    0x7d98_3806,
    0x869b_a40e,
    0x1019_220e,
    0x275b_c12b,
    0x0dfe_d1ba,
    0x4e8b_7d5f,
    0x6286_e982,
    0x4140_d94e,
    0xdfa7_cba5,
    0x0cf7_1873,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0xd000_0000,
    0xd800_0000,
    0x3400_0000,
    0x9a00_0000,
    0x5700_0000,
    0xda80_0000,
    0x0e40_0000,
    0x4da0_0000,
    0x4070_0000,
    0xf698_0000,
    0x006c_0000,
    0x96b2_0000,
    0x767d_0000,
    0xfd39_8000,
    0x711a_4000,
    0xfbae_6000,
    0x8bd2_f000,
    0xe7eb_2800,
    0xbd72_8c00,
    0xb31d_9600,
    0x58ac_1700,
    0xab55_f280,
    0x6eae_b940,
    0xf251_e4a0,
    0xc928_ee70,
    0x7992_7638,
    0xbc48_a704,
    0xd402_baae,
    0x8a03_c579,
    0xef06_dab0,
    0x3e80_3568,
    0x4c46_72a8,
    0x2ea5_f952,
    0x00f4_04ab,
    0xafdd_5e5a,
    0x974e_be06,
    0xd882_9b0c,
    0xcd42_64a6,
    0xbd23_ae72,
    0x1137_960f,
    0x8dbd_173a,
    0xe05e_72a7,
    0xe089_f94c,
    0xbbe6_04ac,
    0x49d0_5e7e,
    0x44ef_3e3f,
    0x9df4_db39,
    0x3a5e_0487,
    0x178c_5e54,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0xd000_0000,
    0xb800_0000,
    0xcc00_0000,
    0xea00_0000,
    0x2500_0000,
    0xa580_0000,
    0xba40_0000,
    0x4ba0_0000,
    0xc6b0_0000,
    0x9348_0000,
    0xaa7c_0000,
    0x2e72_0000,
    0xee2f_0000,
    0xf2ab_8000,
    0x7f69_4000,
    0x4788_a000,
    0x551c_b000,
    0x27a6_3800,
    0x3cb6_2400,
    0x2e4b_8e00,
    0x13f8_d700,
    0xc636_9c80,
    0x4c8d_49c0,
    0x7b9e_92a0,
    0x7360_def0,
    0x03d2_ae28,
    0x079e_2704,
    0x1161_84a6,
    0xa2d1_9dc7,
    0xec18_04b4,
    0x1027_ddca,
    0x4ff3_24bb,
    0xfa6e_2de3,
    0xf20f_bcbd,
    0x775b_b9e8,
    0x7001_8a8a,
    0xa800_0ae5,
    0x5406_383a,
    0xf606_2401,
    0x7703_8e10,
    0x4c84_d735,
    0xf5c4_9ca6,
    0xd4e2_49c5,
    0x2895_1296,
    0xefb9_9eed,
    0x7292_0e02,
    0x42be_971e,
    0x5315_bc8c,
    0xb6f8_b9fa,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x5000_0000,
    0x9800_0000,
    0x4400_0000,
    0xc600_0000,
    0xa700_0000,
    0x2b80_0000,
    0xb440_0000,
    0x5c20_0000,
    0x3150_0000,
    0x43a8_0000,
    0xbb7c_0000,
    0x9d96_0000,
    0x9e4f_0000,
    0x214b_8000,
    0x0ec8_4000,
    0xdc8d_e000,
    0x77ad_9000,
    0xf57e_4800,
    0x4693_0400,
    0x67c9_ae00,
    0x6c09_2b00,
    0x9a6b_5f80,
    0xb419_81c0,
    0x7b61_71a0,
    0x08f4_ead0,
    0x1db9_ce08,
    0x5d73_fb04,
    0x5afb_778e,
    0xd4d3_55c5,
    0x6ced_77b7,
    0xbedc_55e8,
    0xb186_f7b3,
    0xd144_15c0,
    0xb6a3_17b3,
    0x5995_85f4,
    0x184b_5f98,
    0x2649_81de,
    0x7549_71a2,
    0xf0c8_ead8,
    0x6f8f_ce2d,
    0x022c_fb39,
    0xa238_f78d,
    0xf737_15fd,
    0x45de_9797,
    0x5802_c5cc,
    0xa405_3fbf,
    0x3600_51cc,
    0x6f04_d984,
    0xf785_7ed5,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0xd000_0000,
    0x0800_0000,
    0xcc00_0000,
    0xee00_0000,
    0xd300_0000,
    0x5280_0000,
    0x4ac0_0000,
    0xa5e0_0000,
    0xbed0_0000,
    0x6878_0000,
    0x562c_0000,
    0x5192_0000,
    0x47db_0000,
    0x42df_8000,
    0xb75c_c000,
    0xf519_2000,
    0x3338_9000,
    0x8388_2800,
    0xbc63_ac00,
    0x0294_1200,
    0xd55b_3100,
    0xa81f_0580,
    0xc2bb_bf40,
    0x43cc_97a0,
    0x9740_4e70,
    0x3ba0_b208,
    0x3ef4_6104,
    0x17c9_8daa,
    0xdd40_4347,
    0xbaa3_8d99,
    0x8977_4377,
    0x188e_0da7,
    0x42e0_8362,
    0xd650_adb7,
    0x7bb8_d34a,
    0x804b_a582,
    0xc204_ef79,
    0x8d02_1fab,
    0xf987_b255,
    0x0c45_a808,
    0xc524_6c02,
    0xea32_b21b,
    0xb92f_613a,
    0xf516_0d97,
    0xba1c_835d,
    0x47ba_ad98,
    0x764f_d34a,
    0x7506_25bc,
    0x2d83_2f59,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0xf000_0000,
    0xe800_0000,
    0xb400_0000,
    0x2200_0000,
    0x8100_0000,
    0x2180_0000,
    0x5640_0000,
    0xc220_0000,
    0xa910_0000,
    0xe648_0000,
    0x2fdc_0000,
    0x5e56_0000,
    0xb5ef_0000,
    0x988e_8000,
    0x3e3e_c000,
    0xf921_e000,
    0x1594_3000,
    0xa788_d800,
    0xe8bc_6400,
    0x7de6_4e00,
    0x3973_1b00,
    0xe77d_cd80,
    0xa581_0cc0,
    0x7c43_03a0,
    0xa723_d7d0,
    0xb291_ae08,
    0x6d08_2b2c,
    0x5a7b_9592,
    0x0203_a8d1,
    0x3104_ad92,
    0x6984_fcdd,
    0x1244_bb88,
    0x0825_43d9,
    0x9c16_d80a,
    0xe5cf_643e,
    0xf89e_ce13,
    0xbdf2_db10,
    0x4aba_ad94,
    0xbce7_fcfe,
    0xb8f4_3ba1,
    0x4138_83ed,
    0x8fa7_b811,
    0x6156_9412,
    0x636f_761b,
    0x1c4b_4f22,
    0x12db_5b8c,
    0xb9d2_73d0,
    0x58ae_8009,
    0xa62e_c025,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x9000_0000,
    0xb800_0000,
    0x1c00_0000,
    0x1a00_0000,
    0xd100_0000,
    0x0380_0000,
    0x65c0_0000,
    0x27a0_0000,
    0xc050_0000,
    0xe3b8_0000,
    0x516c_0000,
    0x0496_0000,
    0x8f9b_0000,
    0xe0f9_8000,
    0xee8f_4000,
    0x71a2_2000,
    0xd357_b000,
    0x9d3e_1800,
    0x052b_3400,
    0x33f0_c200,
    0x6def_ab00,
    0x6dd0_fb80,
    0xa97f_e540,
    0x824f_b9a0,
    0xf984_0e50,
    0x44c4_e228,
    0x2c23_1b34,
    0x9197_63a6,
    0x7a1b_9163,
    0x463d_5b88,
    0x2fac_1563,
    0x69b2_01ae,
    0xa58b_ca59,
    0xe326_180f,
    0x9517_341a,
    0x4f5e_c211,
    0x5ad8_ab33,
    0x0c1f_7b91,
    0xc53b_a55d,
    0xe92c_1996,
    0x21f0_fe55,
    0x88ee_da3d,
    0xd054_9f06,
    0x1bb8_39ad,
    0x6d6c_4e51,
    0x8e91_4222,
    0xe69c_eb35,
    0xff7c_dbbc,
    0x914f_5554,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x5000_0000,
    0x4800_0000,
    0xec00_0000,
    0xb200_0000,
    0x0300_0000,
    0xf380_0000,
    0x70c0_0000,
    0x3f20_0000,
    0x9c30_0000,
    0xec58_0000,
    0x28ec_0000,
    0x9bf6_0000,
    0x76fb_0000,
    0xb91f_8000,
    0x5a0e_c000,
    0x0a62_2000,
    0x9ed3_7000,
    0x65cc_4800,
    0x64c4_2400,
    0x1926_aa00,
    0xf931_9700,
    0x5add_8c80,
    0xbea9_c140,
    0x7a92_a6a0,
    0xe7ad_9650,
    0x7612_8a28,
    0xbee9_e704,
    0x86f6_449a,
    0x147f_256f,
    0x6958_2c9e,
    0xae68_716b,
    0x35b2_ceb8,
    0x639d_c258,
    0x3e49_e809,
    0xc805_9404,
    0xac06_c202,
    0x9201_c302,
    0x5306_ee9f,
    0xbb85_b270,
    0x9cc2_2037,
    0x8d23_7020,
    0x9f34_482c,
    0x1fd8_2414,
    0x5828_aa1b,
    0xa4d6_9735,
    0xeacc_0c80,
    0x5540_0166,
    0x72e1_0686,
    0x9197_2671,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x7000_0000,
    0xa800_0000,
    0x0400_0000,
    0x2a00_0000,
    0xcb00_0000,
    0x3280_0000,
    0x6840_0000,
    0xada0_0000,
    0xabf0_0000,
    0x2ba8_0000,
    0xfddc_0000,
    0x66b2_0000,
    0xb58f_0000,
    0x97ee_8000,
    0x627c_c000,
    0x8a46_6000,
    0xf2a5_f000,
    0x4b70_c800,
    0x54e9_2c00,
    0xe4fa_e600,
    0x4003_0700,
    0xe001_ae80,
    0x5002_0cc0,
    0xd807_c8a0,
    0xac02_cbf0,
    0x2e06_8628,
    0xe105_f72c,
    0xf985_e6a2,
    0x5ac4_e0dd,
    0xc5e7_ce80,
    0x0657_fcc3,
    0x805f_00ae,
    0xd677_e7c4,
    0x9b6e_6025,
    0xd339_f01d,
    0x2262_c809,
    0xf596_2c3a,
    0xe83c_663f,
    0x78e3_c73b,
    0xb9d5_ce91,
    0x1f98_fcf7,
    0xb011_808a,
    0xa4fb_27db,
    0xa000_0020,
    0xb000_003d,
    0x8800_003f,
    0x7400_0012,
    0x8200_003f,
    0xcf00_003e,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0xd000_0000,
    0x3800_0000,
    0x7c00_0000,
    0x0600_0000,
    0xf700_0000,
    0xae80_0000,
    0x7940_0000,
    0x9d60_0000,
    0x2250_0000,
    0xc588_0000,
    0x625c_0000,
    0x8612_0000,
    0xff69_0000,
    0xfccd_8000,
    0xdf3d_4000,
    0x9447_2000,
    0xd2e4_5000,
    0xda97_c800,
    0x232e_6c00,
    0x9a28_ae00,
    0x77a9_4900,
    0xd26a_0580,
    0x534d_b8c0,
    0xf7fd_2ba0,
    0x4ae0_b1f0,
    0x5695_8e18,
    0x2d28_1904,
    0xf92a_4db6,
    0x9b2b_94eb,
    0x262d_25af,
    0x91a9_e8d2,
    0xf56a_e3b2,
    0xc5ce_dde7,
    0xf2bd_201a,
    0xd181_500d,
    0x83c0_4821,
    0x4626_2c06,
    0xe230_0e34,
    0x8059_591b,
    0xfb17_6d93,
    0xa8ea_c4e3,
    0x480d_6d87,
    0xd79f_c4fd,
    0xdf32_edbc,
    0xf7db_84d7,
    0x7fd0_4da9,
    0x484e_94de,
    0x477a_a5be,
    0x88a1_a8d3,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x7000_0000,
    0xd800_0000,
    0x8400_0000,
    0xd600_0000,
    0xc500_0000,
    0x9280_0000,
    0xb640_0000,
    0xdb20_0000,
    0xa0b0_0000,
    0x0338_0000,
    0x600c_0000,
    0x79f6_0000,
    0x0d9d_0000,
    0xbf78_8000,
    0x6c2b_4000,
    0xb8c3_e000,
    0x9f64_1000,
    0xf892_d800,
    0x5c0b_dc00,
    0x1bf1_7600,
    0x269d_d300,
    0x1cfc_d080,
    0x46ef_9240,
    0x94a3_26a0,
    0xa074_0150,
    0x285c_9618,
    0x7698_c30c,
    0x14f8_888e,
    0x8aee_0e7d,
    0x6ea7_30a3,
    0xef77_8240,
    0x2ddf_fe89,
    0x415e_dd50,
    0x2e1b_603c,
    0xd5bf_5028,
    0xa049_380d,
    0xf7d3_cc3c,
    0x97ad_ae39,
    0x5607_0f26,
    0x8503_2696,
    0x7284_016c,
    0xc644_9633,
    0x0324_c331,
    0x24b6_8880,
    0xd53f_0e5f,
    0xa509_b09f,
    0xeb71_c26f,
    0xbbdc_9eb3,
    0x645d_8d5a,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x9000_0000,
    0xc800_0000,
    0x8c00_0000,
    0x0a00_0000,
    0xfd00_0000,
    0x4480_0000,
    0x3540_0000,
    0xff20_0000,
    0xd3b0_0000,
    0x3888_0000,
    0x88bc_0000,
    0x94f2_0000,
    0x2eab_0000,
    0xf18d_8000,
    0x7238_c000,
    0x22b5_2000,
    0xb60b_b000,
    0xe0fc_7800,
    0xbf51_6c00,
    0x005a_fe00,
    0xba20_0b00,
    0x2330_3880,
    0x73cc_1fc0,
    0x549d_46a0,
    0xb0c3_d4f0,
    0x1ce7_de08,
    0x00d7_bb14,
    0x469e_409a,
    0x69c6_73c7,
    0xee62_3890,
    0x9a97_1fec,
    0x4438_c69b,
    0x4db7_14e6,
    0xeb88_fe14,
    0x873b_0b0e,
    0x4a35_b8a9,
    0x1948_dfee,
    0x2ada_66aa,
    0xa463_64c8,
    0x0796_263d,
    0x30be_1705,
    0x20f1_9e8e,
    0x50ad_c8ed,
    0xd28e_7834,
    0x85ba_6c33,
    0x2877_7e14,
    0xcfe8_cb22,
    0x40ad_1885,
    0xda8b_afd2,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0xd000_0000,
    0x7800_0000,
    0x8c00_0000,
    0x8600_0000,
    0x5300_0000,
    0x9380_0000,
    0x2bc0_0000,
    0x68e0_0000,
    0xb0f0_0000,
    0x1a38_0000,
    0x5c4c_0000,
    0x4536_0000,
    0xdddd_0000,
    0xb13d_8000,
    0x03cb_4000,
    0x08f6_a000,
    0x363b_d000,
    0xea48_e800,
    0xbe31_2400,
    0xba5b_5200,
    0x90fd_5100,
    0xbe2f_b480,
    0x7884_ac40,
    0x9447_66a0,
    0xf523_bd50,
    0x2315_f218,
    0xcd4a_8124,
    0x67b1_5ca6,
    0xa498_8857,
    0xe899_b49f,
    0xce99_ac67,
    0xad9a_e69d,
    0x9618_fd7a,
    0x49db_5238,
    0x2b3d_5121,
    0x4ecf_b49b,
    0x9474_ac78,
    0x707f_66ac,
    0x766f_bd4d,
    0x73a3_f23a,
    0x6857_8121,
    0x2dec_dcb0,
    0x3c63_c86b,
    0x92b7_14aa,
    0x141e_7c49,
    0x18dc_0eb2,
    0xa9b8_d951,
    0x078b_8006,
    0x65d6_4021,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0xb000_0000,
    0x1800_0000,
    0x4400_0000,
    0x6e00_0000,
    0x8d00_0000,
    0x7b80_0000,
    0xf7c0_0000,
    0x0ea0_0000,
    0xed70_0000,
    0x2628_0000,
    0x0bdc_0000,
    0xc8b2_0000,
    0xff8d_0000,
    0x062a_8000,
    0x1bdf_4000,
    0x00b3_e000,
    0x1389_d000,
    0x342d_5800,
    0xbcda_d400,
    0x9834_f200,
    0x12ca_7300,
    0xb6c9_9a80,
    0xa8cb_30c0,
    0x5dcd_e8a0,
    0xd24f_03f0,
    0x538f_1238,
    0x942f_a31c,
    0x6cde_c29e,
    0x3030_e4fd,
    0x4ec9_9abd,
    0x9ccb_30c2,
    0x4bcd_e8bd,
    0xab4f_03c2,
    0x5e0f_1223,
    0xaaef_a30b,
    0x77fe_c28f,
    0xa780_e4e7,
    0x1dc1_9a98,
    0x8da7_30c2,
    0xabf7_e88d,
    0xb26e_03c0,
    0xb6bf_922b,
    0x4561_e30b,
    0xb9d5_a2b0,
    0x505b_74f3,
    0x2f75_a2b2,
    0x392b_74ef,
    0x075d_a286,
    0x0ff7_74ea,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x1000_0000,
    0x5800_0000,
    0x9400_0000,
    0xae00_0000,
    0xe900_0000,
    0xe480_0000,
    0xa340_0000,
    0x7060_0000,
    0xb750_0000,
    0x6108_0000,
    0x91dc_0000,
    0x5816_0000,
    0x6b6f_0000,
    0xc189_8000,
    0x249c_4000,
    0xe575_6000,
    0xdebe_5000,
    0x26c1_7800,
    0x1ba4_8c00,
    0xee74_2e00,
    0xa938_8100,
    0x8605_e580,
    0xd505_64c0,
    0x3686_4ba0,
    0x3842_a5d0,
    0x1fe1_4e08,
    0x2396_d114,
    0x11ac_9dbe,
    0xf82d_e8e1,
    0xb9ec_659d,
    0xffc9_24cf,
    0xae7b_2b9a,
    0x5060_f5c6,
    0xe756_363b,
    0x990d_5d34,
    0x15d9_3391,
    0xae15_29d2,
    0x166a_e02a,
    0x8b0d_1019,
    0x6edd_9800,
    0x7196_9c28,
    0xcaa8_3622,
    0x37ae_5d3a,
    0x3d2e_b389,
    0xd76a_69d8,
    0x5388_0015,
    0x1f9c_0023,
    0x9af6_0031,
    0x127f_0012,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0xf000_0000,
    0x1800_0000,
    0x7c00_0000,
    0x8600_0000,
    0xa700_0000,
    0xda80_0000,
    0x0240_0000,
    0x5160_0000,
    0x4550_0000,
    0x2398_0000,
    0x594c_0000,
    0x2f16_0000,
    0x56f9_0000,
    0x8618_8000,
    0xdd89_4000,
    0x6a36_2000,
    0x0dc9_5000,
    0x5e51_4800,
    0x5f1d_4c00,
    0x6c0e_d600,
    0x4cf1_f100,
    0x75ee_bd80,
    0x0ee3_a840,
    0xe096_eba0,
    0x1b3e_1950,
    0xdab8_f638,
    0xa478_a12c,
    0xc05f_f59e,
    0xe6ee_e463,
    0xe660_3d87,
    0x37d3_e866,
    0x25d8_4baf,
    0x022e_0945,
    0x5347_9e1c,
    0x74e0_bd22,
    0x8196_6ba3,
    0x06bb_594d,
    0xf278_d632,
    0xef58_f125,
    0xa86e_3db1,
    0x0626_e866,
    0x3bb6_cbb7,
    0x9b0e_497c,
    0x5e71_3e03,
    0x83ac_ad03,
    0x4d87_0386,
    0xe0c6_4553,
    0xbf27_c825,
    0x7a31_0c06,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x1000_0000,
    0x3800_0000,
    0xfc00_0000,
    0x8600_0000,
    0x1100_0000,
    0x0580_0000,
    0xdcc0_0000,
    0xe7e0_0000,
    0x7950_0000,
    0x9478_0000,
    0x4bac_0000,
    0x0596_0000,
    0x4399_0000,
    0x7aff_8000,
    0x45ef_4000,
    0x4a33_2000,
    0x146a_5000,
    0x94f2_f800,
    0xf88c_0400,
    0x6f23_da00,
    0x9cb0_0100,
    0xe62a_a180,
    0x5d52_4b40,
    0xbe78_fba0,
    0x84a8_0a50,
    0xfd10_fa38,
    0x24da_5114,
    0xacd8_5996,
    0x58de_4f7b,
    0x6adb_218f,
    0x29d8_0b6b,
    0x7f5a_5b98,
    0xcd18_1a67,
    0x64b8_a20e,
    0x324a_4502,
    0xe1c5_dbab,
    0x7c67_5a73,
    0x3893_822a,
    0xd81c_151e,
    0x3b39_239e,
    0x098e_5e68,
    0x3aa1_d83f,
    0x1876_5400,
    0xedc9_2213,
    0x9a00_0527,
    0xc707_7b8b,
    0x4c87_4a42,
    0x3543_da17,
    0x8520_013e,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x9000_0000,
    0x9800_0000,
    0x8400_0000,
    0xe200_0000,
    0x7500_0000,
    0xf780_0000,
    0x09c0_0000,
    0xe060_0000,
    0xa010_0000,
    0xac78_0000,
    0xa5ac_0000,
    0x59b2_0000,
    0xb409_0000,
    0xcdc7_8000,
    0x2266_4000,
    0xa517_e000,
    0x53ff_b000,
    0xb06c_7800,
    0xdfd2_3400,
    0x8319_e200,
    0xe33b_6500,
    0x798f_ff80,
    0x1505_cd40,
    0xa781_fda0,
    0x71c1_1870,
    0xf462_7a18,
    0xda16_e114,
    0x5d7a_659e,
    0xb02c_9c45,
    0x2577_e03e,
    0xa3ef_b00c,
    0x6414_783d,
    0x6e7e_343b,
    0xa0ab_e223,
    0xa632_650b,
    0xa1c8_7fab,
    0x4ba3_8d5c,
    0x1576_1da0,
    0x8bee_a876,
    0x0816_0205,
    0x0078_d519,
    0x2ba9_87af,
    0x42b2_f970,
    0xc88d_9fad,
    0x2085_3d42,
    0xab45_e5a2,
    0x6e26_dc4c,
    0x41b2_002c,
    0xf009_0036,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x5000_0000,
    0x0800_0000,
    0x0c00_0000,
    0xce00_0000,
    0x2500_0000,
    0x6480_0000,
    0x37c0_0000,
    0x89a0_0000,
    0x36d0_0000,
    0xca98_0000,
    0x178c_0000,
    0xd2b6_0000,
    0x3aed_0000,
    0xd841_8000,
    0xefe0_c000,
    0x0437_2000,
    0x1e2c_9000,
    0xa463_1800,
    0x1070_6c00,
    0x9fcb_ea00,
    0x3552_5b00,
    0x32dc_9f80,
    0x086d_3c40,
    0x6e80_55a0,
    0x70c3_f750,
    0xb627_d218,
    0x1892_a704,
    0x147a_6dba,
    0x5d3e_0b57,
    0x4c58_a011,
    0x90ad_501a,
    0x84a3_b812,
    0xae51_3c10,
    0x8b5e_5239,
    0xef2e_6703,
    0x4ae3_4da3,
    0x20b3_9b41,
    0xc9ec_383f,
    0x7dc0_fc16,
    0x2ea6_f218,
    0x5953_372c,
    0xecd8_f587,
    0xc56e_a77a,
    0x5604_6a0f,
    0x8103_9b14,
    0x1684_3f99,
    0x84c0_6c6b,
    0xcc23_edaa,
    0xa792_cb56,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x9000_0000,
    0xe800_0000,
    0xc400_0000,
    0x6600_0000,
    0x2100_0000,
    0xdb80_0000,
    0xe540_0000,
    0x6ba0_0000,
    0x5290_0000,
    0x42b8_0000,
    0xc16c_0000,
    0x1676_0000,
    0xb88f_0000,
    0xedc5_8000,
    0x1a61_c000,
    0xd2f4_6000,
    0x5b49_9000,
    0x52a1_7800,
    0xd513_f400,
    0xddff_c600,
    0x51cd_ff00,
    0xf466_5580,
    0x47f6_8b40,
    0x3ecd_f3a0,
    0x2ae2_e450,
    0x2f32_de08,
    0xe92b_9b34,
    0xe456_eb92,
    0x785b_8055,
    0x465f_e003,
    0x9b5b_5029,
    0xaade_9807,
    0x5c98_a415,
    0x43b9_5e16,
    0xcae9_5b1c,
    0xbb31_0b93,
    0x872c_d06c,
    0x3157_7803,
    0xbddc_f437,
    0xae1a_460c,
    0x897c_3f18,
    0x5a0a_35a5,
    0x8f03_1b51,
    0xee82_8b9c,
    0x10c2_1055,
    0xfbe6_9826,
    0x6cb4_a42a,
    0x106f_5e36,
    0x55f6_5b12,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x3000_0000,
    0x0800_0000,
    0x1400_0000,
    0x2200_0000,
    0x5d00_0000,
    0x6c80_0000,
    0x9ac0_0000,
    0x4ca0_0000,
    0x54d0_0000,
    0xbe78_0000,
    0xbc6c_0000,
    0x00b6_0000,
    0xeb09_0000,
    0x6246_8000,
    0xb463_c000,
    0x2573_e000,
    0xb628_3000,
    0x90d7_b800,
    0xe47b_2c00,
    0x9d69_a200,
    0x6a33_db00,
    0x06ca_e780,
    0x0b65_a340,
    0x34f0_a5a0,
    0x106e_4850,
    0x7eb5_fa38,
    0xe00c_c71c,
    0x41c2_fd9a,
    0x1724_5449,
    0x8b95_602a,
    0x169b_f002,
    0x6bdc_580b,
    0xde3f_1c3d,
    0x0508_1a0a,
    0x7141_f736,
    0xdbe5_c5b4,
    0x8835_b86d,
    0x7bc9_a214,
    0x37e3_db23,
    0x9632_e793,
    0x40c9_a34e,
    0x1c66_a59c,
    0x2177_487a,
    0xcc2b_7a1d,
    0xe1d3_0725,
    0xb6ff_1d9a,
    0x6ca9_6461,
    0x3512_5816,
    0xf95a_1c22,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0xb000_0000,
    0x1800_0000,
    0x5400_0000,
    0x0a00_0000,
    0x2900_0000,
    0x0780_0000,
    0x2bc0_0000,
    0x6960_0000,
    0xb790_0000,
    0xd608_0000,
    0xd85c_0000,
    0xda32_0000,
    0x987f_0000,
    0x2680_8000,
    0x1043_4000,
    0x24a3_6000,
    0x19f7_7000,
    0x5d19_d800,
    0x5f17_d400,
    0x4d4f_3200,
    0x9e7e_5d00,
    0xb181_4b80,
    0xa4c5_92c0,
    0x89e5_19a0,
    0x10d0_bff0,
    0xf62f_8a28,
    0x74ed_f91c,
    0xda0d_218e,
    0x665c_5bf9,
    0x6932_8024,
    0x1efc_402f,
    0x46c3_e00b,
    0x0ce4_302c,
    0xd952_b81d,
    0x56ec_a432,
    0x7f0c_ea2d,
    0x1fda_8911,
    0xd1f4_f982,
    0x411b_8fda,
    0x8915_b205,
    0x924e_1d3f,
    0xf6f8_abbd,
    0xeac2_a2d8,
    0xc2e5_218e,
    0x5250_5bd2,
    0x3468_8027,
    0x0d4f_4022,
    0x7e79_6039,
    0x2184_703b,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x7000_0000,
    0x4800_0000,
    0xe400_0000,
    0x6e00_0000,
    0x7f00_0000,
    0x2780_0000,
    0x47c0_0000,
    0x37a0_0000,
    0x89d0_0000,
    0xf9a8_0000,
    0x81bc_0000,
    0x2cb2_0000,
    0xa15d_0000,
    0xb684_8000,
    0xdf47_c000,
    0x37e6_6000,
    0x89b7_d000,
    0x0fda_c800,
    0x15c1_e400,
    0x3aa6_7200,
    0x7353_7b00,
    0x1cef_4f80,
    0x8f5f_fdc0,
    0x6987_5da0,
    0xe8c7_56f0,
    0x4820_da38,
    0x1214_4f2c,
    0x0c0d_758a,
    0xfd6b_a2e5,
    0xe39e_8029,
    0x3fa6_c016,
    0xcdd0_e00a,
    0x87ad_1012,
    0xc6b8_2816,
    0xa731_f40a,
    0x6c9a_da28,
    0x9025_4f1d,
    0x0e13_f5bc,
    0xae0d_62d9,
    0x786e_600b,
    0x9d1b_d00d,
    0xc4e0_c806,
    0xf430_e429,
    0x0118_f217,
    0xa6e5_bb36,
    0x1137_afbb,
    0x0f9e_edf1,
    0x15a5_75ad,
    0xccd7_a2fc,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0xd000_0000,
    0xb800_0000,
    0x4400_0000,
    0xba00_0000,
    0x8100_0000,
    0x4e80_0000,
    0x21c0_0000,
    0xda60_0000,
    0x7150_0000,
    0x82b8_0000,
    0xac2c_0000,
    0x8ff6_0000,
    0x7d0d_0000,
    0xcf05_8000,
    0x5d81_4000,
    0xf240_e000,
    0x9b21_7000,
    0x09f4_1800,
    0xa20c_5c00,
    0x8a82_aa00,
    0xdbc1_d500,
    0xbb60_2d80,
    0xefd0_1140,
    0x1b7a_67a0,
    0x324c_b450,
    0x44a0_5218,
    0x7eb1_f924,
    0x2dab_1f96,
    0xf3b0_d865,
    0x552e_0020,
    0x2571_0021,
    0xd6cb_8005,
    0xfc60_401c,
    0x9e53_600b,
    0xaf3d_3005,
    0xd669_7838,
    0x38d0_6c17,
    0x32f8_5210,
    0x120d_f93c,
    0xa285_1fa6,
    0xc7c1_d854,
    0x9565_800f,
    0x6cd1_400a,
    0x90f8_e025,
    0xe70d_7025,
    0x3e02_183d,
    0x9b01_5c18,
    0xff87_2a1e,
    0x0740_950b,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x5000_0000,
    0xf800_0000,
    0xec00_0000,
    0xc600_0000,
    0x2100_0000,
    0xd480_0000,
    0x5240_0000,
    0x6ee0_0000,
    0x16f0_0000,
    0x3708_0000,
    0xb9bc_0000,
    0x3756_0000,
    0xe59b_0000,
    0x2707_8000,
    0x9587_4000,
    0xf6c1_a000,
    0x94a3_d000,
    0x6c10_f800,
    0x0bf8_cc00,
    0x69b6_0600,
    0x7b6a_ed00,
    0x5408_6480,
    0xfe3f_1dc0,
    0xca97_c2a0,
    0x42ba_20d0,
    0xecd1_5e28,
    0x765a_f104,
    0xb521_1ab6,
    0xa0d6_7cef,
    0xa05e_002f,
    0x4c27_0023,
    0xc851_800c,
    0xcc1c_4008,
    0xefc6_2010,
    0xcc24_902a,
    0x8851_5827,
    0xec1b_1c23,
    0xbfc6_fe35,
    0x3422_2103,
    0x6456_629f,
    0x2a19_f0d9,
    0x9ec1_a619,
    0xe0a2_3d3e,
    0x3617_1ca3,
    0x44fc_91ca,
    0x8836_6496,
    0xd7a8_1dd2,
    0x8fae_42ab,
    0x73aa_60c8,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x9000_0000,
    0x8800_0000,
    0xd400_0000,
    0x9a00_0000,
    0x8b00_0000,
    0xd980_0000,
    0x60c0_0000,
    0x0620_0000,
    0xe410_0000,
    0x3768_0000,
    0xb5bc_0000,
    0xe1f6_0000,
    0x08dd_0000,
    0xf407_8000,
    0xaa02_c000,
    0x7305_e000,
    0x1586_f000,
    0xa6c4_c800,
    0xc324_3400,
    0x2c91_1a00,
    0x052f_6f00,
    0x0add_dd80,
    0x6303_9dc0,
    0xdd81_27a0,
    0x92c6_02d0,
    0xc926_3218,
    0x2f90_ab34,
    0x08af_8f9a,
    0xf01a_06d1,
    0xee20_0024,
    0xe010_0007,
    0xc568_0028,
    0x7abc_001e,
    0x2a76_0015,
    0x371d_0014,
    0xb1a7_802a,
    0xa5d2_c036,
    0x9bcd_e003,
    0x24ea_f037,
    0x767a_c804,
    0x9a55_3411,
    0x0e08_9a2c,
    0x124c_af02,
    0x6c29_bd8d,
    0xd45a_adf7,
    0xfc47_8fbf,
    0xee66_06cb,
    0x3076_000d,
    0xfc1d_0028,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0xf000_0000,
    0xa800_0000,
    0xe400_0000,
    0x5a00_0000,
    0xa100_0000,
    0xa580_0000,
    0xb3c0_0000,
    0x2220_0000,
    0xd970_0000,
    0x8268_0000,
    0x1edc_0000,
    0x9192_0000,
    0xc0bd_0000,
    0x7000_8000,
    0x6804_c000,
    0x8401_6000,
    0xaa02_7000,
    0x0902_9800,
    0x4187_0400,
    0xe9c2_6200,
    0x8321_8700,
    0x7cf2_f680,
    0x31af_46c0,
    0x3cf9_f4a0,
    0x48e0_b1f0,
    0x42d3_9a38,
    0x6ed9_f30c,
    0xf992_8cb2,
    0x44bd_05c5,
    0xda00_001c,
    0x6100_0021,
    0xc580_0027,
    0x43c0_0038,
    0x8a20_000b,
    0x3d70_0023,
    0xd868_003e,
    0xbfdc_0019,
    0x3412_002d,
    0x737d_001b,
    0x5220_8030,
    0xb174_c01c,
    0x0669_601d,
    0xb4de_7037,
    0x9890_9807,
    0x813a_040a,
    0x99c2_e224,
    0xeb25_472a,
    0xf8f3_9684,
    0x9bad_36c6,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x9000_0000,
    0x1800_0000,
    0x0c00_0000,
    0xd200_0000,
    0xc900_0000,
    0xba80_0000,
    0xdb40_0000,
    0x72e0_0000,
    0x4ef0_0000,
    0xcfc8_0000,
    0x837c_0000,
    0xdcd6_0000,
    0xa619_0000,
    0x85e3_8000,
    0x3f76_4000,
    0x1f0b_a000,
    0x0c5e_7000,
    0xf186_1800,
    0x90c2_fc00,
    0xef22_1e00,
    0xbd57_4500,
    0x2edc_9480,
    0x66c0_23c0,
    0x5023_2aa0,
    0xf8d0_16d0,
    0xd01a_2638,
    0x7ae4_8934,
    0x1af0_b29e,
    0x71cd_aae7,
    0x0878_1812,
    0xb757_fc21,
    0xcbdf_9e02,
    0xfe44_0520,
    0xca62_b4b4,
    0x24b1_13e6,
    0x9bad_12bb,
    0xdcca_dad1,
    0xa4fd_8012,
    0x0313_400b,
    0x84be_2014,
    0xd271_3012,
    0xd38e_3827,
    0x281a_cc1d,
    0xa6e7_a616,
    0xb0f7_c90a,
    0x24ce_9294,
    0x78fc_9ae1,
    0xa916_2038,
    0xd1bd_3016,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0xf000_0000,
    0x6800_0000,
    0xac00_0000,
    0x1a00_0000,
    0x6300_0000,
    0x2480_0000,
    0x28c0_0000,
    0x2c20_0000,
    0xdf10_0000,
    0xaf08_0000,
    0x8fdc_0000,
    0x3672_0000,
    0xbb7f_0000,
    0xa3a2_8000,
    0x4f52_c000,
    0xf9ef_2000,
    0x43ee_3000,
    0x10ea_8800,
    0x7c6c_5c00,
    0x08ac_3200,
    0x568c_ff00,
    0x469c_1d80,
    0xd710_b6c0,
    0x130d_0fa0,
    0x2ddd_79f0,
    0x6171_1a28,
    0x41ff_530c,
    0x5e65_0792,
    0x3ef3_e5d7,
    0x49ba_083c,
    0xcc81_9c03,
    0x44c1_9207,
    0x1620_0f2e,
    0x4c11_b598,
    0xe38e_dad6,
    0x0b19_b586,
    0x0052_dafc,
    0x076b_b587,
    0x282d_dacb,
    0xe849_359c,
    0xe3bf_1aed,
    0x2786_1589,
    0x1c41_2adf,
    0xbce4_9d8a,
    0xc731_76d4,
    0xae1a_af98,
    0xf5d2_89db,
    0xe42c_3230,
    0xe24c_ff11,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x3000_0000,
    0x2800_0000,
    0x2400_0000,
    0x8a00_0000,
    0xb100_0000,
    0xe080_0000,
    0x0bc0_0000,
    0x61a0_0000,
    0x4650_0000,
    0x84a8_0000,
    0xe43c_0000,
    0x77b2_0000,
    0x3919_0000,
    0x4c22_8000,
    0x0b16_c000,
    0x21cf_6000,
    0x0048_f000,
    0xe30a_9800,
    0x7d6e_ac00,
    0xc89f_8a00,
    0xb763_1b00,
    0x9976_db80,
    0x3a3c_f9c0,
    0x44b4_31a0,
    0x9c9e_12f0,
    0x3562_f218,
    0xdc76_873c,
    0x48bc_29b2,
    0xf276_7ec5,
    0xb3ba_1808,
    0x43f1_6c15,
    0x68fa_6a22,
    0x0191_2b22,
    0x6b09_23aa,
    0x496f_a5da,
    0xba99_a3bb,
    0x3a60_65f4,
    0xfff4_439c,
    0x2efe_55c9,
    0xfe91_bb84,
    0x8088_09e8,
    0x3b2c_a98a,
    0x1479_bee2,
    0x9c57_f825,
    0xedaf_5c0a,
    0xe8bf_9229,
    0xe277_770a,
    0x4bbc_31b5,
    0x7ff2_12ec,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0x5000_0000,
    0x1800_0000,
    0xb400_0000,
    0x0200_0000,
    0x7b00_0000,
    0xcc80_0000,
    0xe1c0_0000,
    0x19a0_0000,
    0x8090_0000,
    0xeea8_0000,
    0x06fc_0000,
    0x4e76_0000,
    0x695b_0000,
    0xd7e7_8000,
    0x4070_4000,
    0xb45c_6000,
    0x5a63_3000,
    0xf231_0800,
    0x9ab9_1c00,
    0xed97_fa00,
    0x4b2e_db00,
    0x68ba_0d80,
    0x9e90_efc0,
    0x0baf_97a0,
    0x6f7a_04d0,
    0xe635_1228,
    0x88b8_b704,
    0xae96_9f8e,
    0x63af_18f9,
    0x937c_e826,
    0x4831_6c23,
    0x45bd_123b,
    0x1b14_b732,
    0x35e8_9fb3,
    0xa798_18f5,
    0x30c5_681d,
    0x3226_2c2f,
    0x73d0_f213,
    0x93cc_c737,
    0x864a_77a6,
    0xc00e_74c7,
    0xcce9_fa03,
    0x5019_db09,
    0x3d83_8db9,
    0x9a47_afc6,
    0xf2e2_7792,
    0x49f2_74f9,
    0x6c1f_fa1f,
    0xf382_db38,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x9000_0000,
    0x9800_0000,
    0xbc00_0000,
    0xae00_0000,
    0x8700_0000,
    0xf080_0000,
    0xc7c0_0000,
    0x0ca0_0000,
    0xd510_0000,
    0x4608_0000,
    0xa5dc_0000,
    0x44f2_0000,
    0x9d7b_0000,
    0xdbe5_8000,
    0xee76_4000,
    0x37bc_2000,
    0x82c0_1000,
    0x2d23_8800,
    0xe953_5c00,
    0xdbe8_4a00,
    0x18aa_a300,
    0x39ce_a980,
    0x4578_d6c0,
    0x07e0_c3a0,
    0x7075_65f0,
    0xb8ba_6208,
    0x5643_af14,
    0xf8e3_4b8e,
    0xccf6_39cb,
    0x797a_282d,
    0x69e5_0c3e,
    0x5777_e23f,
    0xd839_ef34,
    0x0985_6b99,
    0x4841_29eb,
    0xb7e6_2019,
    0xb877_100d,
    0x3cbc_0814,
    0xd442_1c1b,
    0x49e3_ea02,
    0x0777_f306,
    0xe03c_8181,
    0x2581_dad3,
    0x7e45_218b,
    0x8ce7_8afc,
    0xe6f2_8980,
    0x7c78_c6e6,
    0x2863_4b8a,
    0x5b36_39e5,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0xd000_0000,
    0x1800_0000,
    0x6400_0000,
    0x1e00_0000,
    0x1b00_0000,
    0x5a80_0000,
    0xf1c0_0000,
    0x53a0_0000,
    0xa110_0000,
    0xe288_0000,
    0x0f5c_0000,
    0x8bf2_0000,
    0xa8ff_0000,
    0xcce3_8000,
    0xc570_4000,
    0x4f3a_e000,
    0xd841_5000,
    0x94e6_e800,
    0x4170_2c00,
    0xa13b_2a00,
    0x0b41_0b00,
    0xb260_6180,
    0xcab4_62c0,
    0xf79b_aba0,
    0xebd7_39f0,
    0xfbac_a228,
    0x678c_3704,
    0x8edd_438e,
    0x00b7_15ed,
    0xda9f_8821,
    0x2651_3c2f,
    0xe2ef_2219,
    0xbcec_770e,
    0x47ef_a384,
    0xed6a_45cd,
    0xd4ab_600b,
    0xfb0e_101d,
    0x201f_8804,
    0xc791_3c21,
    0x894f_2203,
    0xa9fc_772a,
    0xa367_a39f,
    0x9d36_45c2,
    0x1bd9_6022,
    0xb931_1000,
    0xe5dc_0822,
    0x5231_7c3f,
    0x775d_c229,
    0xdff1_271c,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0x3000_0000,
    0xf800_0000,
    0x1400_0000,
    0xce00_0000,
    0x3500_0000,
    0x0080_0000,
    0xe3c0_0000,
    0x9720_0000,
    0xe710_0000,
    0xd0e8_0000,
    0xc73c_0000,
    0xc976_0000,
    0xf81d_0000,
    0xb262_8000,
    0xeaf4_4000,
    0xaa58_6000,
    0x2003_5000,
    0x9002_1800,
    0x2806_0c00,
    0xdc00_ea00,
    0x2205_cf00,
    0xef03_2580,
    0xfb80_d1c0,
    0xd645_afa0,
    0x7467_4ed0,
    0x93f0_1218,
    0xa0d8_d31c,
    0xf0c7_b786,
    0xdea1_42c9,
    0xf650_f82d,
    0x830d_1c18,
    0xa08c_920b,
    0xf2cd_9339,
    0x60ab_579b,
    0x1a5b_52c4,
    0x9800_0002,
    0x6400_0015,
    0xd600_003e,
    0x1100_003b,
    0x3680_0005,
    0xc2c0_0038,
    0x59a0_0001,
    0x31d0_000e,
    0x4748_003c,
    0xc3ec_0004,
    0x8ebe_001a,
    0xd831_0001,
    0xabfc_8012,
    0xd5d5_400f,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x1000_0000,
    0x2800_0000,
    0x1400_0000,
    0x6200_0000,
    0x8700_0000,
    0x8c80_0000,
    0xbac0_0000,
    0x5f20_0000,
    0xb9d0_0000,
    0xf8d8_0000,
    0xeacc_0000,
    0x74b6_0000,
    0xdee9_0000,
    0x3fe7_8000,
    0x1df3_c000,
    0xdb8a_e000,
    0x5dd7_3000,
    0xe2dc_6800,
    0x31cf_fc00,
    0x9e34_2200,
    0xa92b_5700,
    0x7f44_7380,
    0xf067_0e40,
    0x41b4_b1a0,
    0xdd6e_6950,
    0x6da5_2a38,
    0xa210_5b14,
    0x867e_d992,
    0xe658_9541,
    0xaf0e_8832,
    0xfb14_cc34,
    0xbbfe_4a23,
    0x551d_ab0b,
    0x516f_d1be,
    0x03a3_9945,
    0x0b14_2211,
    0xc3fb_5725,
    0x091c_7398,
    0x376b_0e67,
    0xcea2_b1af,
    0x1497_694b,
    0x97ba_aa27,
    0x6bff_9b1f,
    0x5d1a_39a2,
    0x356a_a543,
    0x59a3_6035,
    0xb011_f03b,
    0x397f_0813,
    0x56de_0c30,
    0x8000_0000,
    0xc000_0000,
    0x6000_0000,
    0x5000_0000,
    0x9800_0000,
    0xf400_0000,
    0xfa00_0000,
    0xc700_0000,
    0x9580_0000,
    0x80c0_0000,
    0xaaa0_0000,
    0x1710_0000,
    0xdb98_0000,
    0x554c_0000,
    0xd4f2_0000,
    0xd0ed_0000,
    0xca65_8000,
    0x2db0_4000,
    0x3488_6000,
    0x2ad6_f000,
    0xe3bb_2800,
    0x371a_3400,
    0x750f_fa00,
    0xa012_ab00,
    0x2619_6180,
    0x898c_f240,
    0xb854_fba0,
    0x96f9_a970,
    0x4d79_3238,
    0x50be_2f24,
    0x989d_d3be,
    0x52ce_9d69,
    0xcf33_4838,
    0x29cc_c43c,
    0x0cb4_d203,
    0x0008_9f05,
    0x5e96_9ba9,
    0x5d5e_5958,
    0xceed_9a02,
    0xcf65_5b11,
    0xbb35_c9be,
    0x13cb_8655,
    0xabb6_e1ab,
    0xc58d_b277,
    0x4653_1b8f,
    0x03fe_1941,
    0x23fd_fa3b,
    0xd3ff_ab0a,
    0x7bfc_e1bd,
    0x47fc_b273,
    0xd1fc_9bb2,
    0x18ff_5949,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x7000_0000,
    0x2800_0000,
    0xa400_0000,
    0x7e00_0000,
    0xe500_0000,
    0x8d80_0000,
    0x8ec0_0000,
    0x1260_0000,
    0x1bf0_0000,
    0x1488_0000,
    0xa6bc_0000,
    0xdad2_0000,
    0x0bdf_0000,
    0x17a6_8000,
    0xd914_c000,
    0xd03d_6000,
    0xac91_5000,
    0x62fb_9800,
    0x6cf3_6400,
    0x360e_6a00,
    0x46ff_8d00,
    0xd2f0_8080,
    0xf309_bdc0,
    0xbb79_8aa0,
    0x7434_60f0,
    0x456e_1228,
    0xde89_792c,
    0x85b8_1282,
    0x6e54_04f5,
    0x8a9c_f835,
    0x9c01_3420,
    0x6201_7234,
    0x4707_2906,
    0xea85_0aad,
    0x1443_a0cc,
    0x2e27_f23e,
    0x91d3_e926,
    0xfb58_6a98,
    0xb8e2_f0d4,
    0xefb4_6a1d,
    0x6aac_8d2b,
    0x6f6c_00a3,
    0xad8e_7dd1,
    0x6938_6a93,
    0x6312_f0c8,
    0xdb3c_6a23,
    0xbc10_8d2f,
    0x9dbe_00a9,
    0x0251_7df9,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0xb000_0000,
    0x2800_0000,
    0x3c00_0000,
    0x6e00_0000,
    0x0700_0000,
    0x8180_0000,
    0x0f40_0000,
    0x0360_0000,
    0x5950_0000,
    0xaff8_0000,
    0xd06c_0000,
    0x8fb2_0000,
    0x4bef_0000,
    0x85f0_8000,
    0x180a_c000,
    0xf165_a000,
    0x4051_1000,
    0x217b_0800,
    0xd2ac_5400,
    0xc594_4600,
    0x2ade_b900,
    0x9cdd_2d80,
    0x6fd9_3740,
    0x2c5c_4ba0,
    0xd21c_5e70,
    0x43ff_ce28,
    0xc668_2d1c,
    0x0cb4_cb82,
    0x006a_9e63,
    0xf7b0_6e31,
    0xcfea_3d3e,
    0x4ff5_43b3,
    0x650f_0a6e,
    0x25e3_080a,
    0xa790_542a,
    0xabde_4638,
    0x065d_b90f,
    0x3f1f_ada2,
    0x0f7c_f76a,
    0x35a9_6bb9,
    0xd417_8e73,
    0xbd99_663e,
    0x8bb9_693d,
    0x6489_8595,
    0xeaa7_7343,
    0x84f1_8582,
    0x428b_7372,
    0x81a3_859a,
    0xd374_734d,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0x1000_0000,
    0x1800_0000,
    0xd400_0000,
    0x6600_0000,
    0xfd00_0000,
    0x4d80_0000,
    0x8a40_0000,
    0xa1a0_0000,
    0xe970_0000,
    0xcd38_0000,
    0xe78c_0000,
    0x9f56_0000,
    0xa90f_0000,
    0x3191_8000,
    0x096a_4000,
    0x1e07_6000,
    0xd907_1000,
    0x8381_1800,
    0xab43_a400,
    0x4625_ce00,
    0x2c30_1700,
    0xba1b_1a80,
    0x343e_9840,
    0x3408_34a0,
    0x8c13_df50,
    0x2b2d_5608,
    0x63a5_f314,
    0x9a77_b4ae,
    0x01ba_9f71,
    0x9a4d_b63f,
    0xe3b7_a31a,
    0xe358_4ca2,
    0x4918_6b59,
    0xb8b8_001d,
    0xe9cc_003d,
    0xe0f6_002a,
    0x797f_0038,
    0xcf29_8001,
    0x4da6_4004,
    0x0b71_601a,
    0xee38_102d,
    0x9308_982b,
    0x2695_e42f,
    0xabec_ae28,
    0x52c4_070c,
    0x5a65_828e,
    0xd894_7c5a,
    0xc2ed_1abf,
    0xd941_984a,
    0x8000_0000,
    0xc000_0000,
    0xa000_0000,
    0x9000_0000,
    0x2800_0000,
    0xa400_0000,
    0x2a00_0000,
    0x9f00_0000,
    0x3280_0000,
    0xc440_0000,
    0xf7a0_0000,
    0xed70_0000,
    0xf068_0000,
    0xffdc_0000,
    0x6e52_0000,
    0x385b_0000,
    0x6795_8000,
    0x093b_c000,
    0x0105_6000,
    0x6f86_f000,
    0x6dc1_e800,
    0xbb64_cc00,
    0x6997_a600,
    0x7c38_4700,
    0x0c84_1280,
    0x0944_32c0,
    0x7623_54a0,
    0x05b1_45f0,
    0x5e8b_ce08,
    0xec8b_4b14,
    0xaf8c_d4a2,
    0x9b0d_85cd,
    0xde49_2e20,
    0x866d_7b3e,
    0xa6dd_dcae,
    0x7dd4_79f2,
    0xc39a_001b,
    0x75f7_0013,
    0x6b2f_8023,
    0x9afc_c007,
    0xd762_e021,
    0x1796_3029,
    0xd139_0835,
    0xbd05_fc10,
    0x5981_2e29,
    0x54c1_7b17,
    0x98e7_dcbd,
    0x2a53_79c0,
    0xe25d_8004,
    0xe097_c03c,
    0x27bf_602a,
    0x6341_f02c,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0x7000_0000,
    0x4800_0000,
    0x0c00_0000,
    0xbe00_0000,
    0x6900_0000,
    0x4080_0000,
    0x3540_0000,
    0x97e0_0000,
    0x4030_0000,
    0xb218_0000,
    0xa3ec_0000,
    0xb152_0000,
    0xba69_0000,
    0xac90_8000,
    0x84cf_c000,
    0xfd41_2000,
    0x5be0_1000,
    0x1e33_f800,
    0xab1a_ac00,
    0xab68_1e00,
    0x8814_3d00,
    0x9388_4a80,
    0x85a5_f340,
    0x7651_f4a0,
    0x6bee_1e70,
    0x7d53_6618,
    0xe46d_512c,
    0xb593_74aa,
    0x8c48_de5f,
    0xc402_c61d,
    0x7202_8129,
    0x3701_ac87,
    0x5982_624b,
    0x3dc1_2007,
    0xaea0_102e,
    0x69d3_f81e,
    0x9b2a_ac3e,
    0x5170_1e02,
    0x27f8_3d08,
    0x9cda_4a8d,
    0x56cc_f345,
    0x9a41_7488,
    0xda61_de62,
    0x17f2_4629,
    0xffbd_412e,
    0x19b8_8c80,
    0x84be_725e,
    0xde38_d800,
    0x407f_bc12,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0x3000_0000,
    0xe800_0000,
    0x3400_0000,
    0x1200_0000,
    0xfd00_0000,
    0xe080_0000,
    0x5040_0000,
    0x2aa0_0000,
    0xb3f0_0000,
    0x0558_0000,
    0x4a6c_0000,
    0xebd6_0000,
    0x5be9_0000,
    0xe516_8000,
    0x720c_c000,
    0x77c1_e000,
    0x7362_b000,
    0x6b93_3800,
    0xe948_cc00,
    0xeae6_5600,
    0x6157_9f00,
    0x3aa8_5e80,
    0xb135_5f40,
    0x92b9_68a0,
    0x8bbc_b050,
    0xe13b_ee38,
    0xf07f_931c,
    0x2c59_e8a2,
    0xc8e9_7041,
    0xce94_8e1e,
    0x95cd_e322,
    0xfca5_30a4,
    0x94f6_0c67,
    0x7cd9_6028,
    0x30ab_7025,
    0xb032_5817,
    0x043f_bc0d,
    0xecfa_0e39,
    0x0a1d_231d,
    0xd54a_d08d,
    0xbce1_bc59,
    0x0652_d83d,
    0x232a_7c16,
    0xfbf5_6e2f,
    0x215f_5310,
    0xe06e_08a2,
    0xfad2_c061,
    0x7569_3637,
    0x6e55_ef11,
    0x8000_0000,
    0xc000_0000,
    0xe000_0000,
    0xb000_0000,
    0xa800_0000,
    0x2c00_0000,
    0x9600_0000,
    0x2300_0000,
    0x1580_0000,
    0xf140_0000,
    0x5460_0000,
    0x8a90_0000,
    0xe038_0000,
    0xf06c_0000,
    0x9a72_0000,
    0x6769_0000,
    0x5df6_8000,
    0xef2e_c000,
    0x1917_2000,
    0x0a7e_5000,
    0x658b_e800,
    0x43a7_5400,
    0xe237_d600,
    0xab8f_d100,
    0xc4a6_2b80,
    0x1db7_e740,
    0xf7c8_5da0,
    0x2244_a670,
    0xc9e0_be18,
    0x07d3_451c,
    0x3a5a_5d92,
    0xddfd_a667,
    0xd5ce_3e2f,
    0xd341_8533,
    0xa567_7d98,
    0xe616_f658,
    0x01f9_561a,
    0xcbcd_1125,
    0x8c43_0bb0,
    0x3ee0_b77a,
    0xb055_3591,
    0xfa1d_3262,
    0x0518_4819,
    0x0e9e_c414,
    0xa0dd_9e3e,
    0x6f38_151e,
    0xb3ed_35a3,
    0xa831_326a,
    0x968a_480e,
    0x8e27_c439,
    0x7773_1e01,
    0xf5ea_d504,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0xf000_0000,
    0xf800_0000,
    0x1400_0000,
    0x3a00_0000,
    0x8900_0000,
    0x9b80_0000,
    0xbbc0_0000,
    0x05e0_0000,
    0x5570_0000,
    0xb908_0000,
    0x7e3c_0000,
    0x5c16_0000,
    0x673f_0000,
    0x2f96_8000,
    0x60fa_4000,
    0x0c76_6000,
    0x6a8c_f000,
    0x89fb_5800,
    0x87f1_b400,
    0x7948_1200,
    0x901f_9900,
    0x0481_c880,
    0x6746_95c0,
    0xc6a1_3aa0,
    0xf1d3_bcd0,
    0x25db_ca08,
    0x0267_6d2c,
    0x78b7_3a96,
    0xbbec_bcf9,
    0xf3cd_4a10,
    0xb45d_2d37,
    0x28a1_5a80,
    0xa2d0_4cf0,
    0x675e_1239,
    0x2a20_992e,
    0x2a97_4889,
    0xc57c_d5d4,
    0xacb7_5a81,
    0x61ef_4cfd,
    0x2ac8_921b,
    0x27da_d91a,
    0x7f61_2896,
    0x8930_25ca,
    0x812c_02a7,
    0x81ae_f8c0,
    0x74e8_8039,
    0x2749_4022,
    0x9b1e_e03a,
    0xa205_b03c,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0xf000_0000,
    0x8800_0000,
    0x0400_0000,
    0x5a00_0000,
    0x4500_0000,
    0x1b80_0000,
    0xa240_0000,
    0x6860_0000,
    0x2390_0000,
    0xedf8_0000,
    0xe9ac_0000,
    0xf176_0000,
    0x9da9_0000,
    0x6370_8000,
    0xbca9_c000,
    0xd2f3_6000,
    0xd3ef_7000,
    0xa513_b800,
    0x083f_5400,
    0x658c_5e00,
    0xd985_d900,
    0xdb45_1380,
    0xc5e5_e940,
    0x6ad2_ada0,
    0x091a_8050,
    0x32f9_6638,
    0x972a_4d2c,
    0xd8b2_adba,
    0x2f8a_807d,
    0xa481_6614,
    0x2cc6_4d00,
    0xc9a4_ad88,
    0x95b3_8045,
    0x7009_e61e,
    0x3cc3_8d31,
    0xf1a1_cdaf,
    0x79b5_f05f,
    0xde0a_de03,
    0xabc5_1924,
    0xab26_f3b0,
    0x9a73_596d,
    0x512a_7593,
    0xfbb6_a458,
    0xc708_8015,
    0xf645_c024,
    0x6a65_602f,
    0x7a96_7034,
    0xd07b_3809,
    0xd8ea_940c,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0xd000_0000,
    0xf800_0000,
    0x1c00_0000,
    0x2e00_0000,
    0x0f00_0000,
    0xc380_0000,
    0x2440_0000,
    0xe6a0_0000,
    0x7210_0000,
    0x2bd8_0000,
    0x2c0c_0000,
    0xf432_0000,
    0x580f_0000,
    0xde33_8000,
    0x950f_4000,
    0x14b2_2000,
    0x99c9_1000,
    0x27d3_c800,
    0x083e_0400,
    0x543c_8e00,
    0x9a3a_0f00,
    0x653f_0980,
    0x8ebe_f440,
    0x4efa_27a0,
    0x9a5e_ab70,
    0xc94e_c628,
    0x2e14_4b04,
    0xe5da_27b6,
    0xd30e_ab73,
    0x1fb6_c615,
    0x9848_4b34,
    0x0a90_27b3,
    0xc61d_ab7e,
    0xf3ef_4617,
    0x5204_0b22,
    0x1103_87b0,
    0xc484_fb60,
    0xd3c5_2e19,
    0x08e0_5f23,
    0xa9b4_e1b0,
    0xbb4a_e058,
    0xef14_e196,
    0xd95a_e076,
    0x1ccc_e1ab,
    0x3956_e069,
    0x3efe_e187,
    0x7259_e040,
    0x0d4d_6190,
    0xcc16_a069,
    0x8000_0000,
    0x4000_0000,
    0x6000_0000,
    0xf000_0000,
    0x2800_0000,
    0x2400_0000,
    0x9e00_0000,
    0x4d00_0000,
    0x3480_0000,
    0x63c0_0000,
    0xf1a0_0000,
    0x9c70_0000,
    0x9568_0000,
    0xb45c_0000,
    0x9856_0000,
    0xa459_0000,
    0x0050_8000,
    0xc85c_c000,
    0x4a57_6000,
    0x3358_5000,
    0x17d0_d800,
    0xfa1f_6c00,
    0xc8b0_0a00,
    0xa34a_5b00,
    0xa268_7a80,
    0x73d9_9ec0,
    0x1217_90a0,
    0xdabb_55d0,
    0x0246_5238,
    0x8ae0_f72c,
    0x2417_9092,
    0xf3bb_55f5,
    0xc8c6_520d,
    0x5420_f70a,
    0xc937_90b2,
    0x280b_55f7,
    0x320e_521b,
    0x310c_f726,
    0xf089_90a6,
    0x5bce_55e5,
    0x5ba8_d224,
    0xc179_3705,
    0x2fe6_70a5,
    0x1496_c5d3,
    0x9e79_6a10,
    0xac67_0b12,
    0xf0d6_22b2,
    0x859f_32d3,
    0xbef6_7ab5,
    0x4fac_9ec8,
    0x5779_108d,
    0xd6e2_95c9,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x3000_0000,
    0x8800_0000,
    0xbc00_0000,
    0x2600_0000,
    0x0d00_0000,
    0x3580_0000,
    0x76c0_0000,
    0x5ee0_0000,
    0xb750_0000,
    0x7588_0000,
    0x139c_0000,
    0x1932_0000,
    0xdd9f_0000,
    0x7834_8000,
    0x561b_c000,
    0x07f4_a000,
    0x2f7b_5000,
    0x5160_1800,
    0x1a93_a400,
    0xbbee_6a00,
    0x6b89_4900,
    0xea99_9180,
    0x96b3_28c0,
    0xb05f_dba0,
    0x9656_f1f0,
    0x1e08_f228,
    0x7c5e_2d3c,
    0xd857_dbaa,
    0xbf0a_f1e3,
    0xd7da_f20b,
    0x9791_2d1c,
    0x4e6b_5b8c,
    0x3d4d_31d2,
    0x847c_5218,
    0xa9e5_7d2f,
    0x79d7_c38b,
    0xa3c9_55e6,
    0x0a3c_9814,
    0x9444_6431,
    0xd6a0_ca0e,
    0xb7f1_1900,
    0x677f_09ad,
    0xcd64_4ce8,
    0x0c91_91ad,
    0x3eef_28e4,
    0xe20d_db9c,
    0xba59_f1ec,
    0xc554_720e,
    0x3289_ed3d,
    0x8000_0000,
    0x4000_0000,
    0xe000_0000,
    0xb000_0000,
    0x1800_0000,
    0x1c00_0000,
    0xf200_0000,
    0xd100_0000,
    0xc680_0000,
    0xdb40_0000,
    0x24a0_0000,
    0x34f0_0000,
    0xdbf8_0000,
    0x24cc_0000,
    0x2fd6_0000,
    0xb6cd_0000,
    0x0ed6_8000,
    0x884f_4000,
    0x7993_2000,
    0x46e8_f000,
    0x8062_d800,
    0xa997_dc00,
    0xaee8_be00,
    0x6460_1700,
    0xf793_e680,
    0x95e8_ca40,
    0x6fe6_f8a0,
    0x1853_6d50,
    0xbb0a_e618,
    0xb935_8b3c,
    0x2c1e_f8be,
    0x609f_6d6b,
    0x86dc_e61a,
    0x6ef8_8b23,
    0xfc48_78b5,
    0x2f90_2d6e,
    0x29ef_c61e,
    0xcde0_7b2c,
    0x6152_a0bb,
    0x798b_f15c,
    0x8c71_782a,
    0x2bbd_6c05,
    0x43ef_c605,
    0x40e0_7b1a,
    0xb5d2_a09c,
    0xc3cb_f14b,
    0x7651_7820,
    0xd80d_6c3f,
    0x4eb7_c637,
    0x81dc_7b02,
    0x877c_a08c,
    0x8a8a_f14a,
    0x8000_0000,
    0x4000_0000,
    0x2000_0000,
    0xf000_0000,
    0xe800_0000,
    0xb400_0000,
    0x0a00_0000,
    0x6d00_0000,
    0xa780_0000,
    0x7340_0000,
    0x11e0_0000,
    0x3a30_0000,
    0x7e68_0000,
    0xcd9c_0000,
    0xfed6_0000,
    0x0fdb_0000,
    0xb6b2_8000,
    0x01aa_c000,
    0xe3bf_e000,
    0xcac4_7000,
    0xb5a7_7800,
    0x2955_7400,
    0xd49e_3600,
    0x3356_9d00,
    0xc19b_9280,
    0x18d7_80c0,
    0x14de_c4a0,
    0x3234_add0,
    0x5a6f_4e28,
    0xff98_e92c,
    0x3fd7_24b2,
    0xfe5b_ddd1,
    0x16f2_b618,
    0xd0cb_5d26,
    0x6048_f2a3,
    0x718e_30fb,
    0x20aa_dcb7,
    0x8238_69ef,
    0x5285_6031,
    0xc8c2_b00a,
    0xfca6_983b,
    0xbcd6_043d,
    0x66dd_ce2e,
    0xd332_293b,
    0x5be8_c4a1,
    0xb7df_adc6,
    0x5ab5_ce27,
    0x77ae_2939,
    0xc0be_c4a6,
    0xe244_adc7,
    0xb867_4e07,
    0xe674_e935,
    0x8000_0000,
    0xc000_0000,
    0x2000_0000,
    0x7000_0000,
    0x5800_0000,
    0xe400_0000,
    0x9200_0000,
    0x5900_0000,
    0x6480_0000,
    0x2b40_0000,
    0x6460_0000,
    0xf710_0000,
    0xa2a8_0000,
    0xeb7c_0000,
    0x1e72_0000,
    0x1b3f_0000,
    0x8f96_8000,
    0x4fef_4000,
    0x3c18_e000,
    0x40e2_3000,
    0x3c53_9800,
    0x96cc_4c00,
    0x346b_ae00,
    0x00df_5100,
    0x8647_0f80,
    0x5ae1_2fc0,
    0x6950_c1a0,
    0xfc4c_0ef0,
    0x402a_3628,
    0x933c_1d2c,
    0x8392_219e,
    0x41ed_3ee5,
    0x631d_2e12,
    0xb760_111f,
    0xce97_efb5,
    0x2f6f_1fc0,
    0xd559_59b6,
    0x5583_42fe,
    0x13c5_183d,
    0x6923_0c3d,
    0x7073_4e28,
    0xd43d_6113,
    0x7014_978f,
    0x712d_63c7,
    0xabbb_6f99,
    0x8ed3_5fd5,
    0xc68d_39af,
    0x158d_32e8,
    0x2c0a_e02e,
    0xa1cd_3024,
    0x9fed_1836,
    0xd41f_0c09,
    0x8000_0000,
    0x4000_0000,
    0xa000_0000,
    0xb000_0000,
    0x5800_0000,
    0x8400_0000,
    0x4a00_0000,
    0x1d00_0000,
    0x8380_0000,
    0xfec0_0000,
    0x5220_0000,
    0x5ad0_0000,
    0xf3f8_0000,
    0x6d6c_0000,
    0x0bf6_0000,
    0x75af_0000,
    0x32d4_8000,
    0x6ffd_4000,
    0x036f_e000,
    0xecf5_f000,
    0xb32f_7800,
    0xcb94_5400,
    0x891c_fa00,
    0x169a_6f00,
    0xc659_ab80,
    0xd379_c740,
    0xff28_31a0,
    0xad94_1850,
    0xa21d_8208,
    0xf61d_3b3c,
    0xb41f_d1be,
    0x651d_e84d,
    0xc09c_fa24,
    0xb55a_6f36,
    0xb7f9_ab9a,
    0xc769_c754,
    0x06f0_3182,
    0x1e28_1858,
    0x1013_8232,
    0xf3de_3b36,
    0x0ebd_51a0,
    0x818f_a874,
    0xa307_9a3e,
    0x6c82_df26,
    0xf441_33aa,
    0x8d64_636f,
    0x3735_b3ac,
    0xb689_234c,
    0x6d82_53b0,
    0x59c0_d35a,
    0x34a3_2b93,
    0x1397_876e,
];
const M1: [u64; 50] = [
    0x1_u64, 0x1_u64, 0x1_u64, 0x1_u64, 0x1_u64, 0x1_u64, 0x1_u64, 0x1_u64, 0x1_u64, 0x1_u64,
    0x1_u64, 0x1_u64, 0x1_u64, 0x1_u64, 0x1_u64, 0x1_u64, 0x1_u64, 0x1_u64, 0x1_u64, 0x1_u64,
    0x1_u64, 0x1_u64, 0x1_u64, 0x1_u64, 0x1_u64, 0x1_u64, 0x1_u64, 0x1_u64, 0x1_u64, 0x1_u64,
    0x1_u64, 0x1_u64, 0x1_u64, 0x1_u64, 0x1_u64, 0x1_u64, 0x1_u64, 0x1_u64, 0x1_u64, 0x1_u64,
    0x1_u64, 0x1_u64, 0x1_u64, 0x1_u64, 0x1_u64, 0x1_u64, 0x1_u64, 0x1_u64, 0x1_u64, 0x1_u64,
];
const M2: [u64; 48] = [
    0x2_u64, 0x3_u64, 0x2_u64, 0x3_u64, 0x2_u64, 0x3_u64, 0x2_u64, 0x3_u64, 0x2_u64, 0x3_u64,
    0x2_u64, 0x3_u64, 0x2_u64, 0x3_u64, 0x2_u64, 0x3_u64, 0x2_u64, 0x3_u64, 0x2_u64, 0x3_u64,
    0x2_u64, 0x3_u64, 0x2_u64, 0x3_u64, 0x2_u64, 0x3_u64, 0x2_u64, 0x3_u64, 0x2_u64, 0x3_u64,
    0x2_u64, 0x3_u64, 0x2_u64, 0x3_u64, 0x2_u64, 0x3_u64, 0x2_u64, 0x3_u64, 0x2_u64, 0x3_u64,
    0x2_u64, 0x3_u64, 0x2_u64, 0x3_u64, 0x2_u64, 0x3_u64, 0x2_u64, 0x3_u64,
];
const M3: [u64; 46] = [
    0x5_u64, 0x7_u64, 0x4_u64, 0x6_u64, 0x5_u64, 0x7_u64, 0x4_u64, 0x6_u64, 0x5_u64, 0x7_u64,
    0x4_u64, 0x6_u64, 0x5_u64, 0x7_u64, 0x4_u64, 0x6_u64, 0x5_u64, 0x7_u64, 0x4_u64, 0x6_u64,
    0x5_u64, 0x7_u64, 0x4_u64, 0x6_u64, 0x5_u64, 0x7_u64, 0x4_u64, 0x6_u64, 0x5_u64, 0x7_u64,
    0x4_u64, 0x6_u64, 0x5_u64, 0x7_u64, 0x4_u64, 0x6_u64, 0x5_u64, 0x7_u64, 0x4_u64, 0x6_u64,
    0x5_u64, 0x7_u64, 0x4_u64, 0x6_u64, 0x5_u64, 0x7_u64,
];
const M4: [u64; 44] = [
    0x8_u64, 0xc_u64, 0xa_u64, 0xf_u64, 0x8_u64, 0xc_u64, 0xa_u64, 0xf_u64, 0x8_u64, 0xc_u64,
    0xa_u64, 0xf_u64, 0x8_u64, 0xc_u64, 0xa_u64, 0xf_u64, 0x8_u64, 0xc_u64, 0xa_u64, 0xf_u64,
    0x8_u64, 0xc_u64, 0xa_u64, 0xf_u64, 0x8_u64, 0xc_u64, 0xa_u64, 0xf_u64, 0x8_u64, 0xc_u64,
    0xa_u64, 0xf_u64, 0x8_u64, 0xc_u64, 0xa_u64, 0xf_u64, 0x8_u64, 0xc_u64, 0xa_u64, 0xf_u64,
    0x8_u64, 0xc_u64, 0xa_u64, 0xf_u64,
];
const M5: [u64; 42] = [
    0x14_u64, 0x1e_u64, 0x11_u64, 0x19_u64, 0x15_u64, 0x1f_u64, 0x10_u64, 0x18_u64, 0x14_u64,
    0x1e_u64, 0x11_u64, 0x19_u64, 0x15_u64, 0x1f_u64, 0x10_u64, 0x18_u64, 0x14_u64, 0x1e_u64,
    0x11_u64, 0x19_u64, 0x15_u64, 0x1f_u64, 0x10_u64, 0x18_u64, 0x14_u64, 0x1e_u64, 0x11_u64,
    0x19_u64, 0x15_u64, 0x1f_u64, 0x10_u64, 0x18_u64, 0x14_u64, 0x1e_u64, 0x11_u64, 0x19_u64,
    0x15_u64, 0x1f_u64, 0x10_u64, 0x18_u64, 0x14_u64, 0x1e_u64,
];
const M6: [u64; 40] = [
    0x22_u64, 0x33_u64, 0x2a_u64, 0x3f_u64, 0x20_u64, 0x30_u64, 0x28_u64, 0x3c_u64, 0x22_u64,
    0x33_u64, 0x2a_u64, 0x3f_u64, 0x20_u64, 0x30_u64, 0x28_u64, 0x3c_u64, 0x22_u64, 0x33_u64,
    0x2a_u64, 0x3f_u64, 0x20_u64, 0x30_u64, 0x28_u64, 0x3c_u64, 0x22_u64, 0x33_u64, 0x2a_u64,
    0x3f_u64, 0x20_u64, 0x30_u64, 0x28_u64, 0x3c_u64, 0x22_u64, 0x33_u64, 0x2a_u64, 0x3f_u64,
    0x20_u64, 0x30_u64, 0x28_u64, 0x3c_u64,
];
const M7: [u64; 38] = [
    0x55_u64, 0x7f_u64, 0x40_u64, 0x60_u64, 0x50_u64, 0x78_u64, 0x44_u64, 0x66_u64, 0x55_u64,
    0x7f_u64, 0x40_u64, 0x60_u64, 0x50_u64, 0x78_u64, 0x44_u64, 0x66_u64, 0x55_u64, 0x7f_u64,
    0x40_u64, 0x60_u64, 0x50_u64, 0x78_u64, 0x44_u64, 0x66_u64, 0x55_u64, 0x7f_u64, 0x40_u64,
    0x60_u64, 0x50_u64, 0x78_u64, 0x44_u64, 0x66_u64, 0x55_u64, 0x7f_u64, 0x40_u64, 0x60_u64,
    0x50_u64, 0x78_u64,
];
const M8: [u64; 36] = [
    0x80_u64, 0xc0_u64, 0xa0_u64, 0xf0_u64, 0x88_u64, 0xcc_u64, 0xaa_u64, 0xff_u64, 0x80_u64,
    0xc0_u64, 0xa0_u64, 0xf0_u64, 0x88_u64, 0xcc_u64, 0xaa_u64, 0xff_u64, 0x80_u64, 0xc0_u64,
    0xa0_u64, 0xf0_u64, 0x88_u64, 0xcc_u64, 0xaa_u64, 0xff_u64, 0x80_u64, 0xc0_u64, 0xa0_u64,
    0xf0_u64, 0x88_u64, 0xcc_u64, 0xaa_u64, 0xff_u64, 0x80_u64, 0xc0_u64, 0xa0_u64, 0xf0_u64,
];
const M9: [u64; 34] = [
    0x140_u64, 0x1e0_u64, 0x110_u64, 0x198_u64, 0x154_u64, 0x1fe_u64, 0x101_u64, 0x181_u64,
    0x141_u64, 0x1e1_u64, 0x111_u64, 0x199_u64, 0x155_u64, 0x1ff_u64, 0x100_u64, 0x180_u64,
    0x140_u64, 0x1e0_u64, 0x110_u64, 0x198_u64, 0x154_u64, 0x1fe_u64, 0x101_u64, 0x181_u64,
    0x141_u64, 0x1e1_u64, 0x111_u64, 0x199_u64, 0x155_u64, 0x1ff_u64, 0x100_u64, 0x180_u64,
    0x140_u64, 0x1e0_u64,
];
const M10: [u64; 32] = [
    0x220_u64, 0x330_u64, 0x2a8_u64, 0x3fc_u64, 0x202_u64, 0x303_u64, 0x282_u64, 0x3c3_u64,
    0x222_u64, 0x333_u64, 0x2aa_u64, 0x3ff_u64, 0x200_u64, 0x300_u64, 0x280_u64, 0x3c0_u64,
    0x220_u64, 0x330_u64, 0x2a8_u64, 0x3fc_u64, 0x202_u64, 0x303_u64, 0x282_u64, 0x3c3_u64,
    0x222_u64, 0x333_u64, 0x2aa_u64, 0x3ff_u64, 0x200_u64, 0x300_u64, 0x280_u64, 0x3c0_u64,
];
const M11: [u64; 30] = [
    0x550_u64, 0x7f8_u64, 0x404_u64, 0x606_u64, 0x505_u64, 0x787_u64, 0x444_u64, 0x666_u64,
    0x555_u64, 0x7ff_u64, 0x400_u64, 0x600_u64, 0x500_u64, 0x780_u64, 0x440_u64, 0x660_u64,
    0x550_u64, 0x7f8_u64, 0x404_u64, 0x606_u64, 0x505_u64, 0x787_u64, 0x444_u64, 0x666_u64,
    0x555_u64, 0x7ff_u64, 0x400_u64, 0x600_u64, 0x500_u64, 0x780_u64,
];
const M12: [u64; 28] = [
    0x808_u64, 0xc0c_u64, 0xa0a_u64, 0xf0f_u64, 0x888_u64, 0xccc_u64, 0xaaa_u64, 0xfff_u64,
    0x800_u64, 0xc00_u64, 0xa00_u64, 0xf00_u64, 0x880_u64, 0xcc0_u64, 0xaa0_u64, 0xff0_u64,
    0x808_u64, 0xc0c_u64, 0xa0a_u64, 0xf0f_u64, 0x888_u64, 0xccc_u64, 0xaaa_u64, 0xfff_u64,
    0x800_u64, 0xc00_u64, 0xa00_u64, 0xf00_u64,
];
const M13: [u64; 26] = [
    0x1414_u64, 0x1e1e_u64, 0x1111_u64, 0x1999_u64, 0x1555_u64, 0x1fff_u64, 0x1000_u64, 0x1800_u64,
    0x1400_u64, 0x1e00_u64, 0x1100_u64, 0x1980_u64, 0x1540_u64, 0x1fe0_u64, 0x1010_u64, 0x1818_u64,
    0x1414_u64, 0x1e1e_u64, 0x1111_u64, 0x1999_u64, 0x1555_u64, 0x1fff_u64, 0x1000_u64, 0x1800_u64,
    0x1400_u64, 0x1e00_u64,
];
const M14: [u64; 24] = [
    0x2222_u64, 0x3333_u64, 0x2aaa_u64, 0x3fff_u64, 0x2000_u64, 0x3000_u64, 0x2800_u64, 0x3c00_u64,
    0x2200_u64, 0x3300_u64, 0x2a80_u64, 0x3fc0_u64, 0x2020_u64, 0x3030_u64, 0x2828_u64, 0x3c3c_u64,
    0x2222_u64, 0x3333_u64, 0x2aaa_u64, 0x3fff_u64, 0x2000_u64, 0x3000_u64, 0x2800_u64, 0x3c00_u64,
];
const M15: [u64; 22] = [
    0x5555_u64, 0x7fff_u64, 0x4000_u64, 0x6000_u64, 0x5000_u64, 0x7800_u64, 0x4400_u64, 0x6600_u64,
    0x5500_u64, 0x7f80_u64, 0x4040_u64, 0x6060_u64, 0x5050_u64, 0x7878_u64, 0x4444_u64, 0x6666_u64,
    0x5555_u64, 0x7fff_u64, 0x4000_u64, 0x6000_u64, 0x5000_u64, 0x7800_u64,
];
const M16: [u64; 20] = [
    0x8000_u64, 0xc000_u64, 0xa000_u64, 0xf000_u64, 0x8800_u64, 0xcc00_u64, 0xaa00_u64, 0xff00_u64,
    0x8080_u64, 0xc0c0_u64, 0xa0a0_u64, 0xf0f0_u64, 0x8888_u64, 0xcccc_u64, 0xaaaa_u64, 0xffff_u64,
    0x8000_u64, 0xc000_u64, 0xa000_u64, 0xf000_u64,
];
const M17: [u64; 18] = [
    0x14000_u64,
    0x1e000_u64,
    0x11000_u64,
    0x19800_u64,
    0x15400_u64,
    0x1fe00_u64,
    0x10100_u64,
    0x18180_u64,
    0x14140_u64,
    0x1e1e0_u64,
    0x11110_u64,
    0x19998_u64,
    0x15554_u64,
    0x1fffe_u64,
    0x10001_u64,
    0x18001_u64,
    0x14001_u64,
    0x1e001_u64,
];
const M18: [u64; 16] = [
    0x22000_u64,
    0x33000_u64,
    0x2a800_u64,
    0x3fc00_u64,
    0x20200_u64,
    0x30300_u64,
    0x28280_u64,
    0x3c3c0_u64,
    0x22220_u64,
    0x33330_u64,
    0x2aaa8_u64,
    0x3fffc_u64,
    0x20002_u64,
    0x30003_u64,
    0x28002_u64,
    0x3c003_u64,
];
const M19: [u64; 14] = [
    0x55000_u64,
    0x7f800_u64,
    0x40400_u64,
    0x60600_u64,
    0x50500_u64,
    0x78780_u64,
    0x44440_u64,
    0x66660_u64,
    0x55550_u64,
    0x7fff8_u64,
    0x40004_u64,
    0x60006_u64,
    0x50005_u64,
    0x78007_u64,
];
const M20: [u64; 12] = [
    0x80800_u64,
    0xc0c00_u64,
    0xa0a00_u64,
    0xf0f00_u64,
    0x88880_u64,
    0xcccc0_u64,
    0xaaaa0_u64,
    0xffff0_u64,
    0x80008_u64,
    0xc000c_u64,
    0xa000a_u64,
    0xf000f_u64,
];
const M21: [u64; 10] = [
    0x0014_1400_u64,
    0x001e_1e00_u64,
    0x0011_1100_u64,
    0x0019_9980_u64,
    0x0015_5540_u64,
    0x001f_ffe0_u64,
    0x0010_0010_u64,
    0x0018_0018_u64,
    0x0014_0014_u64,
    0x001e_001e_u64,
];
const M22: [u64; 8] = [
    0x0022_2200_u64,
    0x0033_3300_u64,
    0x002a_aa80_u64,
    0x003f_ffc0_u64,
    0x0020_0020_u64,
    0x0030_0030_u64,
    0x0028_0028_u64,
    0x003c_003c_u64,
];
const M23: [u64; 6] = [
    0x0055_5500_u64,
    0x007f_ff80_u64,
    0x0040_0040_u64,
    0x0060_0060_u64,
    0x0050_0050_u64,
    0x0078_0078_u64,
];
const M24: [u64; 4] = [
    0x0080_0080_u64,
    0x00c0_00c0_u64,
    0x00a0_00a0_u64,
    0x00f0_00f0_u64,
];
const M25: [u64; 2] = [0x0140_0140_u64, 0x01e0_01e0_u64];
pub const VD_C_SOBOL_MATRICES: [&[u64]; 25] = [
    &M1, &M2, &M3, &M4, &M5, &M6, &M7, &M8, &M9, &M10, &M11, &M12, &M13, &M14, &M15, &M16, &M17,
    &M18, &M19, &M20, &M21, &M22, &M23, &M24, &M25,
];
const MI1: [u64; 2] = [0x2_u64, 0x3_u64];
const MI2: [u64; 4] = [0xc_u64, 0x4_u64, 0xa_u64, 0x5_u64];
const MI3: [u64; 6] = [0x28_u64, 0x30_u64, 0x10_u64, 0x3c_u64, 0x22_u64, 0x11_u64];
const MI4: [u64; 8] = [
    0xf0_u64, 0x50_u64, 0x30_u64, 0x10_u64, 0x88_u64, 0x44_u64, 0x22_u64, 0x11_u64,
];
const MI5: [u64; 10] = [
    0x220_u64, 0x3c0_u64, 0x360_u64, 0x300_u64, 0x100_u64, 0x330_u64, 0x2a8_u64, 0x264_u64,
    0x202_u64, 0x101_u64,
];
const MI6: [u64; 12] = [
    0xcc0_u64, 0x440_u64, 0xf00_u64, 0x500_u64, 0x300_u64, 0x100_u64, 0xaa0_u64, 0x550_u64,
    0x808_u64, 0x404_u64, 0x202_u64, 0x101_u64,
];
const MI7: [u64; 14] = [
    0x2a80_u64, 0x3300_u64, 0x1100_u64, 0xf00_u64, 0x500_u64, 0x300_u64, 0x100_u64, 0x3fc0_u64,
    0x2020_u64, 0x1010_u64, 0x808_u64, 0x404_u64, 0x202_u64, 0x101_u64,
];
const MI8: [u64; 16] = [
    0xff00_u64, 0x5500_u64, 0x3300_u64, 0x1100_u64, 0xf00_u64, 0x500_u64, 0x300_u64, 0x100_u64,
    0x8080_u64, 0x4040_u64, 0x2020_u64, 0x1010_u64, 0x808_u64, 0x404_u64, 0x202_u64, 0x101_u64,
];
const MI9: [u64; 18] = [
    0x20200_u64,
    0x3fc00_u64,
    0x35600_u64,
    0x33000_u64,
    0x31200_u64,
    0x30c00_u64,
    0x30600_u64,
    0x30000_u64,
    0x10000_u64,
    0x30300_u64,
    0x28280_u64,
    0x24240_u64,
    0x22220_u64,
    0x21210_u64,
    0x20a08_u64,
    0x20604_u64,
    0x20002_u64,
    0x10001_u64,
];
const MI10: [u64; 20] = [
    0xc0c00_u64,
    0x40400_u64,
    0xff000_u64,
    0x55000_u64,
    0xf3c00_u64,
    0x51400_u64,
    0xf0000_u64,
    0x50000_u64,
    0x30000_u64,
    0x10000_u64,
    0xa0a00_u64,
    0x50500_u64,
    0x88880_u64,
    0x44440_u64,
    0x82820_u64,
    0x41410_u64,
    0x80008_u64,
    0x40004_u64,
    0x20002_u64,
    0x10001_u64,
];
const MI11: [u64; 22] = [
    0x0028_2800_u64,
    0x0030_3000_u64,
    0x0010_1000_u64,
    0xff000_u64,
    0x002d_7800_u64,
    0x0033_0000_u64,
    0x0011_0000_u64,
    0xf0000_u64,
    0x50000_u64,
    0x30000_u64,
    0x10000_u64,
    0x003c_3c00_u64,
    0x0022_2200_u64,
    0x0011_1100_u64,
    0x88880_u64,
    0x0038_7840_u64,
    0x0020_0020_u64,
    0x0010_0010_u64,
    0x80008_u64,
    0x40004_u64,
    0x20002_u64,
    0x10001_u64,
];
const MI12: [u64; 24] = [
    0x00f0_f000_u64,
    0x0050_5000_u64,
    0x0030_3000_u64,
    0x0010_1000_u64,
    0x00ff_0000_u64,
    0x0055_0000_u64,
    0x0033_0000_u64,
    0x0011_0000_u64,
    0xf0000_u64,
    0x50000_u64,
    0x30000_u64,
    0x10000_u64,
    0x0088_8800_u64,
    0x0044_4400_u64,
    0x0022_2200_u64,
    0x0011_1100_u64,
    0x0080_0080_u64,
    0x0040_0040_u64,
    0x0020_0020_u64,
    0x0010_0010_u64,
    0x80008_u64,
    0x40004_u64,
    0x20002_u64,
    0x10001_u64,
];
const MI13: [u64; 26] = [
    0x0222_2000_u64,
    0x03c3_c000_u64,
    0x0363_6000_u64,
    0x0303_0000_u64,
    0x0101_0000_u64,
    0x00ff_0000_u64,
    0x0055_0000_u64,
    0x0033_0000_u64,
    0x0011_0000_u64,
    0xf0000_u64,
    0x50000_u64,
    0x30000_u64,
    0x10000_u64,
    0x0333_3000_u64,
    0x02aa_a800_u64,
    0x0266_6400_u64,
    0x0200_0200_u64,
    0x0100_0100_u64,
    0x0080_0080_u64,
    0x0040_0040_u64,
    0x0020_0020_u64,
    0x0010_0010_u64,
    0x80008_u64,
    0x40004_u64,
    0x20002_u64,
    0x10001_u64,
];
const MI14: [u64; 28] = [
    0x0ccc_c000_u64,
    0x0444_4000_u64,
    0x0f0f_0000_u64,
    0x0505_0000_u64,
    0x0303_0000_u64,
    0x0101_0000_u64,
    0x00ff_0000_u64,
    0x0055_0000_u64,
    0x0033_0000_u64,
    0x0011_0000_u64,
    0xf0000_u64,
    0x50000_u64,
    0x30000_u64,
    0x10000_u64,
    0x0aaa_a000_u64,
    0x0555_5000_u64,
    0x0800_0800_u64,
    0x0400_0400_u64,
    0x0200_0200_u64,
    0x0100_0100_u64,
    0x0080_0080_u64,
    0x0040_0040_u64,
    0x0020_0020_u64,
    0x0010_0010_u64,
    0x80008_u64,
    0x40004_u64,
    0x20002_u64,
    0x10001_u64,
];
const MI15: [u64; 30] = [
    0x2aaa_8000_u64,
    0x3333_0000_u64,
    0x1111_0000_u64,
    0x0f0f_0000_u64,
    0x0505_0000_u64,
    0x0303_0000_u64,
    0x0101_0000_u64,
    0x00ff_0000_u64,
    0x0055_0000_u64,
    0x0033_0000_u64,
    0x0011_0000_u64,
    0xf0000_u64,
    0x50000_u64,
    0x30000_u64,
    0x10000_u64,
    0x3fff_c000_u64,
    0x2000_2000_u64,
    0x1000_1000_u64,
    0x0800_0800_u64,
    0x0400_0400_u64,
    0x0200_0200_u64,
    0x0100_0100_u64,
    0x0080_0080_u64,
    0x0040_0040_u64,
    0x0020_0020_u64,
    0x0010_0010_u64,
    0x80008_u64,
    0x40004_u64,
    0x20002_u64,
    0x10001_u64,
];
const MI16: [u64; 32] = [
    0xffff_0000_u64,
    0x5555_0000_u64,
    0x3333_0000_u64,
    0x1111_0000_u64,
    0x0f0f_0000_u64,
    0x0505_0000_u64,
    0x0303_0000_u64,
    0x0101_0000_u64,
    0x00ff_0000_u64,
    0x0055_0000_u64,
    0x0033_0000_u64,
    0x0011_0000_u64,
    0xf0000_u64,
    0x50000_u64,
    0x30000_u64,
    0x10000_u64,
    0x8000_8000_u64,
    0x4000_4000_u64,
    0x2000_2000_u64,
    0x1000_1000_u64,
    0x0800_0800_u64,
    0x0400_0400_u64,
    0x0200_0200_u64,
    0x0100_0100_u64,
    0x0080_0080_u64,
    0x0040_0040_u64,
    0x0020_0020_u64,
    0x0010_0010_u64,
    0x80008_u64,
    0x40004_u64,
    0x20002_u64,
    0x10001_u64,
];
const MI17: [u64; 34] = [
    0x2000_20000_u64,
    0x3fff_c0000_u64,
    0x3555_60000_u64,
    0x3333_00000_u64,
    0x3111_20000_u64,
    0x30f0_c0000_u64,
    0x3050_60000_u64,
    0x3030_00000_u64,
    0x3010_20000_u64,
    0x300f_c0000_u64,
    0x3005_60000_u64,
    0x3003_00000_u64,
    0x3001_20000_u64,
    0x3000_c0000_u64,
    0x3000_60000_u64,
    0x3000_00000_u64,
    0x1000_00000_u64,
    0x3000_30000_u64,
    0x2800_28000_u64,
    0x2400_24000_u64,
    0x2200_22000_u64,
    0x2100_21000_u64,
    0x2080_20800_u64,
    0x2040_20400_u64,
    0x2020_20200_u64,
    0x2010_20100_u64,
    0x2008_20080_u64,
    0x2004_20040_u64,
    0x2002_20020_u64,
    0x2001_20010_u64,
    0x2000_a0008_u64,
    0x2000_60004_u64,
    0x2000_00002_u64,
    0x1000_00001_u64,
];
const MI18: [u64; 36] = [
    0xc000_c0000_u64,
    0x4000_40000_u64,
    0xffff_00000_u64,
    0x5555_00000_u64,
    0xf333_c0000_u64,
    0x5111_40000_u64,
    0xf0f0_00000_u64,
    0x5050_00000_u64,
    0xf030_c0000_u64,
    0x5010_40000_u64,
    0xf00f_00000_u64,
    0x5005_00000_u64,
    0xf003_c0000_u64,
    0x5001_40000_u64,
    0xf000_00000_u64,
    0x5000_00000_u64,
    0x3000_00000_u64,
    0x1000_00000_u64,
    0xa000_a0000_u64,
    0x5000_50000_u64,
    0x8800_88000_u64,
    0x4400_44000_u64,
    0x8200_82000_u64,
    0x4100_41000_u64,
    0x8080_80800_u64,
    0x4040_40400_u64,
    0x8020_80200_u64,
    0x4010_40100_u64,
    0x8008_80080_u64,
    0x4004_40040_u64,
    0x8002_80020_u64,
    0x4001_40010_u64,
    0x8000_00008_u64,
    0x4000_00004_u64,
    0x2000_00002_u64,
    0x1000_00001_u64,
];
const MI19: [u64; 38] = [
    0x2800_280000_u64,
    0x3000_300000_u64,
    0x1000_100000_u64,
    0xffff_00000_u64,
    0x2d55_780000_u64,
    0x3333_000000_u64,
    0x1111_000000_u64,
    0xf0f0_00000_u64,
    0x2d05_280000_u64,
    0x3303_300000_u64,
    0x1101_100000_u64,
    0xf00f_00000_u64,
    0x2d00_780000_u64,
    0x3300_000000_u64,
    0x1100_000000_u64,
    0xf000_00000_u64,
    0x5000_00000_u64,
    0x3000_00000_u64,
    0x1000_00000_u64,
    0x3c00_3c0000_u64,
    0x2200_220000_u64,
    0x1100_110000_u64,
    0x8800_88000_u64,
    0x3840_384000_u64,
    0x2020_202000_u64,
    0x1010_101000_u64,
    0x8080_80800_u64,
    0x3804_380400_u64,
    0x2002_200200_u64,
    0x1001_100100_u64,
    0x8008_80080_u64,
    0x3800_780040_u64,
    0x2000_000020_u64,
    0x1000_000010_u64,
    0x8000_00008_u64,
    0x4000_00004_u64,
    0x2000_00002_u64,
    0x1000_00001_u64,
];
const MI20: [u64; 40] = [
    0xf000_f00000_u64,
    0x5000_500000_u64,
    0x3000_300000_u64,
    0x1000_100000_u64,
    0xffff_000000_u64,
    0x5555_000000_u64,
    0x3333_000000_u64,
    0x1111_000000_u64,
    0xff0f_f00000_u64,
    0x5505_500000_u64,
    0x3303_300000_u64,
    0x1101_100000_u64,
    0xff00_000000_u64,
    0x5500_000000_u64,
    0x3300_000000_u64,
    0x1100_000000_u64,
    0xf000_00000_u64,
    0x5000_00000_u64,
    0x3000_00000_u64,
    0x1000_00000_u64,
    0x8800_880000_u64,
    0x4400_440000_u64,
    0x2200_220000_u64,
    0x1100_110000_u64,
    0x8080_808000_u64,
    0x4040_404000_u64,
    0x2020_202000_u64,
    0x1010_101000_u64,
    0x8008_800800_u64,
    0x4004_400400_u64,
    0x2002_200200_u64,
    0x1001_100100_u64,
    0x8000_000080_u64,
    0x4000_000040_u64,
    0x2000_000020_u64,
    0x1000_000010_u64,
    0x8000_00008_u64,
    0x4000_00004_u64,
    0x2000_00002_u64,
    0x1000_00001_u64,
];
const MI21: [u64; 42] = [
    0x2200_2200000_u64,
    0x3c00_3c00000_u64,
    0x3600_3600000_u64,
    0x3000_3000000_u64,
    0x1000_1000000_u64,
    0xffff_000000_u64,
    0x5555_000000_u64,
    0x3333_000000_u64,
    0x2311_3200000_u64,
    0x3cf0_cc00000_u64,
    0x3650_6600000_u64,
    0x3030_0000000_u64,
    0x1010_0000000_u64,
    0xff00_000000_u64,
    0x5500_000000_u64,
    0x3300_000000_u64,
    0x1100_000000_u64,
    0xf000_00000_u64,
    0x5000_00000_u64,
    0x3000_00000_u64,
    0x1000_00000_u64,
    0x3300_3300000_u64,
    0x2a80_2a80000_u64,
    0x2640_2640000_u64,
    0x2020_2020000_u64,
    0x1010_1010000_u64,
    0x8080_808000_u64,
    0x4040_404000_u64,
    0x2020_202000_u64,
    0x3201_3201000_u64,
    0x2a00_aa00800_u64,
    0x2600_6600400_u64,
    0x2000_0000200_u64,
    0x1000_0000100_u64,
    0x8000_000080_u64,
    0x4000_000040_u64,
    0x2000_000020_u64,
    0x1000_000010_u64,
    0x8000_00008_u64,
    0x4000_00004_u64,
    0x2000_00002_u64,
    0x1000_00001_u64,
];
const MI22: [u64; 44] = [
    0xcc00_cc00000_u64,
    0x4400_4400000_u64,
    0xf000_f000000_u64,
    0x5000_5000000_u64,
    0x3000_3000000_u64,
    0x1000_1000000_u64,
    0xffff_000000_u64,
    0x5555_000000_u64,
    0xcf33_fc00000_u64,
    0x4511_5400000_u64,
    0xf0f0_0000000_u64,
    0x5050_0000000_u64,
    0x3030_0000000_u64,
    0x1010_0000000_u64,
    0xff00_000000_u64,
    0x5500_000000_u64,
    0x3300_000000_u64,
    0x1100_000000_u64,
    0xf000_00000_u64,
    0x5000_00000_u64,
    0x3000_00000_u64,
    0x1000_00000_u64,
    0xaa00_aa00000_u64,
    0x5500_5500000_u64,
    0x8080_8080000_u64,
    0x4040_4040000_u64,
    0x2020_2020000_u64,
    0x1010_1010000_u64,
    0x8080_808000_u64,
    0x4040_404000_u64,
    0xa802_a802000_u64,
    0x5401_5401000_u64,
    0x8000_0000800_u64,
    0x4000_0000400_u64,
    0x2000_0000200_u64,
    0x1000_0000100_u64,
    0x8000_000080_u64,
    0x4000_000040_u64,
    0x2000_000020_u64,
    0x1000_000010_u64,
    0x8000_00008_u64,
    0x4000_00004_u64,
    0x2000_00002_u64,
    0x1000_00001_u64,
];
const MI23: [u64; 46] = [
    0x2a80_2a80_0000_u64,
    0x3300_3300_0000_u64,
    0x1100_1100_0000_u64,
    0xf000_f000000_u64,
    0x5000_5000000_u64,
    0x3000_3000000_u64,
    0x1000_1000000_u64,
    0xffff_000000_u64,
    0x2ad5_7f80_0000_u64,
    0x3333_0000_0000_u64,
    0x1111_0000_0000_u64,
    0xf0f0_0000000_u64,
    0x5050_0000000_u64,
    0x3030_0000000_u64,
    0x1010_0000000_u64,
    0xff00_000000_u64,
    0x5500_000000_u64,
    0x3300_000000_u64,
    0x1100_000000_u64,
    0xf000_00000_u64,
    0x5000_00000_u64,
    0x3000_00000_u64,
    0x1000_00000_u64,
    0x3fc0_3fc0_0000_u64,
    0x2020_2020_0000_u64,
    0x1010_1010_0000_u64,
    0x8080_8080000_u64,
    0x4040_4040000_u64,
    0x2020_2020000_u64,
    0x1010_1010000_u64,
    0x8080_808000_u64,
    0x3f80_7f80_4000_u64,
    0x2000_0000_2000_u64,
    0x1000_0000_1000_u64,
    0x8000_0000800_u64,
    0x4000_0000400_u64,
    0x2000_0000200_u64,
    0x1000_0000100_u64,
    0x8000_000080_u64,
    0x4000_000040_u64,
    0x2000_000020_u64,
    0x1000_000010_u64,
    0x8000_00008_u64,
    0x4000_00004_u64,
    0x2000_00002_u64,
    0x1000_00001_u64,
];
const MI24: [u64; 48] = [
    0xff00_ff00_0000_u64,
    0x5500_5500_0000_u64,
    0x3300_3300_0000_u64,
    0x1100_1100_0000_u64,
    0xf000_f000000_u64,
    0x5000_5000000_u64,
    0x3000_3000000_u64,
    0x1000_1000000_u64,
    0xffff_0000_0000_u64,
    0x5555_0000_0000_u64,
    0x3333_0000_0000_u64,
    0x1111_0000_0000_u64,
    0xf0f0_0000000_u64,
    0x5050_0000000_u64,
    0x3030_0000000_u64,
    0x1010_0000000_u64,
    0xff00_000000_u64,
    0x5500_000000_u64,
    0x3300_000000_u64,
    0x1100_000000_u64,
    0xf000_00000_u64,
    0x5000_00000_u64,
    0x3000_00000_u64,
    0x1000_00000_u64,
    0x8080_8080_0000_u64,
    0x4040_4040_0000_u64,
    0x2020_2020_0000_u64,
    0x1010_1010_0000_u64,
    0x8080_8080000_u64,
    0x4040_4040000_u64,
    0x2020_2020000_u64,
    0x1010_1010000_u64,
    0x8000_0000_8000_u64,
    0x4000_0000_4000_u64,
    0x2000_0000_2000_u64,
    0x1000_0000_1000_u64,
    0x8000_0000800_u64,
    0x4000_0000400_u64,
    0x2000_0000200_u64,
    0x1000_0000100_u64,
    0x8000_000080_u64,
    0x4000_000040_u64,
    0x2000_000020_u64,
    0x1000_000010_u64,
    0x8000_00008_u64,
    0x4000_00004_u64,
    0x2000_00002_u64,
    0x1000_00001_u64,
];
const MI25: [u64; 50] = [
    0x0002_0202_0200_0000_u64,
    0x0003_fc03_fc00_0000_u64,
    0x0003_5603_5600_0000_u64,
    0x0003_3003_3000_0000_u64,
    0x0003_1203_1200_0000_u64,
    0x0003_0c03_0c00_0000_u64,
    0x0003_0603_0600_0000_u64,
    0x0003_0003_0000_0000_u64,
    0x0001_0001_0000_0000_u64,
    0xffff_0000_0000_u64,
    0x5555_0000_0000_u64,
    0x3333_0000_0000_u64,
    0x1111_0000_0000_u64,
    0xf0f0_0000000_u64,
    0x5050_0000000_u64,
    0x3030_0000000_u64,
    0x1010_0000000_u64,
    0xff00_000000_u64,
    0x5500_000000_u64,
    0x3300_000000_u64,
    0x1100_000000_u64,
    0xf000_00000_u64,
    0x5000_00000_u64,
    0x3000_00000_u64,
    0x1000_00000_u64,
    0x0003_0303_0300_0000_u64,
    0x0002_8282_8280_0000_u64,
    0x0002_4242_4240_0000_u64,
    0x0002_2222_2220_0000_u64,
    0x0002_1212_1210_0000_u64,
    0x0002_0a0a_0a08_0000_u64,
    0x0002_0606_0604_0000_u64,
    0x0002_0000_0002_0000_u64,
    0x0001_0000_0001_0000_u64,
    0x8000_0000_8000_u64,
    0x4000_0000_4000_u64,
    0x2000_0000_2000_u64,
    0x1000_0000_1000_u64,
    0x8000_0000800_u64,
    0x4000_0000400_u64,
    0x2000_0000200_u64,
    0x1000_0000100_u64,
    0x8000_000080_u64,
    0x4000_000040_u64,
    0x2000_000020_u64,
    0x1000_000010_u64,
    0x8000_00008_u64,
    0x4000_00004_u64,
    0x2000_00002_u64,
    0x1000_00001_u64,
];
const MI26: [u64; 52] = [
    0x000c_0c0c_0c00_0000_u64,
    0x0004_0404_0400_0000_u64,
    0x000f_f00f_f000_0000_u64,
    0x0005_5005_5000_0000_u64,
    0x000f_3c0f_3c00_0000_u64,
    0x0005_1405_1400_0000_u64,
    0x000f_000f_0000_0000_u64,
    0x0005_0005_0000_0000_u64,
    0x0003_0003_0000_0000_u64,
    0x0001_0001_0000_0000_u64,
    0xffff_0000_0000_u64,
    0x5555_0000_0000_u64,
    0x3333_0000_0000_u64,
    0x1111_0000_0000_u64,
    0xf0f0_0000000_u64,
    0x5050_0000000_u64,
    0x3030_0000000_u64,
    0x1010_0000000_u64,
    0xff00_000000_u64,
    0x5500_000000_u64,
    0x3300_000000_u64,
    0x1100_000000_u64,
    0xf000_00000_u64,
    0x5000_00000_u64,
    0x3000_00000_u64,
    0x1000_00000_u64,
    0x000a_0a0a_0a00_0000_u64,
    0x0005_0505_0500_0000_u64,
    0x0008_8888_8880_0000_u64,
    0x0004_4444_4440_0000_u64,
    0x0008_2828_2820_0000_u64,
    0x0004_1414_1410_0000_u64,
    0x0008_0000_0008_0000_u64,
    0x0004_0000_0004_0000_u64,
    0x0002_0000_0002_0000_u64,
    0x0001_0000_0001_0000_u64,
    0x8000_0000_8000_u64,
    0x4000_0000_4000_u64,
    0x2000_0000_2000_u64,
    0x1000_0000_1000_u64,
    0x8000_0000800_u64,
    0x4000_0000400_u64,
    0x2000_0000200_u64,
    0x1000_0000100_u64,
    0x8000_000080_u64,
    0x4000_000040_u64,
    0x2000_000020_u64,
    0x1000_000010_u64,
    0x8000_00008_u64,
    0x4000_00004_u64,
    0x2000_00002_u64,
    0x1000_00001_u64,
];
pub const VD_C_SOBOL_MATRICES_INV: [&[u64]; 26] = [
    &MI1, &MI2, &MI3, &MI4, &MI5, &MI6, &MI7, &MI8, &MI9, &MI10, &MI11, &MI12, &MI13, &MI14, &MI15,
    &MI16, &MI17, &MI18, &MI19, &MI20, &MI21, &MI22, &MI23, &MI24, &MI25, &MI26,
];
