/*
 * Copyright (c) 2021 Frank Fischer <frank-fischer@shadow-soft.de>
 *
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see  <http://www.gnu.org/licenses/>
 */

struct PtrNode {}

struct PtrEdge {}

struct PtrGraph {
    nodes: Vec<PtrNode>,
    edges: Vec<PtrNode>,
}

impl<'a> PartialEq for &'a PtrNode {
    fn eq(&self, other: &Self) -> bool {
        *self as *const PtrNode == *other as *const PtrNode
    }
}

impl<'a> Eq for &'a PtrNode {}

impl<'a> PartialEq for &'a PtrEdge {
    fn eq(&self, other: &Self) -> bool {
        *self as *const PtrEdge == *other as *const PtrEdge
    }
}

impl<'a> Eq for &'a PtrEdge {}

impl<'a> GraphType<'a> for PtrGraph {
    type Node = &'a PtrNode;
    type Edge = &'a PtrEdge;
}

struct PtrIt<'a, T>(std::slice::Iter<'a, T>);

impl<'a, T> Clone for PtrIt<'a, T> {
    fn clone(&self) -> Self {
        PtrIt(self.0.clone())
    }
}

impl<'a, T> GraphIterator<PtrGraph> for PtrIt<'a, T> {
    type Item = &'a T;

    fn next(&mut self, g: &PtrGraph) -> Option<Self::Item> {
        todo!()
    }
}

impl<'a> GraphSize<'a> for PtrGraph {
    type NodeIt = PtrIt<'a, PtrNode>;

    type EdgeIt = PtrIt<'a, PtrEdge>;

    fn num_nodes(&self) -> usize {
        self.nodes.len()
    }

    fn num_edges(&self) -> usize {
        todo!()
    }

    fn nodes_iter(&'a self) -> Self::NodeIt {
        todo!()
    }

    fn edges_iter(&'a self) -> Self::EdgeIt {
        todo!()
    }
}

#[derive(Clone)]
struct PtrNeighIt<'a>(std::marker::PhantomData<&'a usize>);

impl<'a> GraphIterator<PtrGraph> for PtrNeighIt<'a> {
    type Item = (&'a PtrEdge, &'a PtrNode);

    fn next(&mut self, g: &PtrGraph) -> Option<Self::Item> {
        todo!()
    }
}

impl<'a> Undirected<'a> for PtrGraph {
    type NeighIt = PtrNeighIt<'a>;

    fn enodes(&'a self, e: Self::Edge) -> (Self::Node, Self::Node) {
        todo!()
    }

    fn neigh_iter(&'a self, u: Self::Node) -> Self::NeighIt {
        todo!()
    }
}

impl<'a> IndexGraph<'a> for PtrGraph {
    fn node_id(&self, u: Self::Node) -> usize {
        todo!()
    }

    fn id2node<'s>(&'s self, id: usize) -> Self::Node
    where
        'a: 's,
    {
        let u: &'s PtrNode = &self.nodes[id];
        u
    }

    fn edge_id(&self, e: Self::Edge) -> usize {
        todo!()
    }

    fn id2edge(&self, id: usize) -> Self::Edge {
        todo!()
    }
}

impl PtrGraph {
    fn new() -> Self {
        todo!()
    }
}

fn test() {
    let g = PtrGraph::new();
    for i in 0..g.num_nodes() {
        let u = g.id2node(i);
        assert_eq!(i, g.node_id(u));
    }
}
