// Copyright (c) 2016 Frank Fischer <frank-fischer@shadow-soft.de>
//
// This program is free software: you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation, either version 3 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see  <http://www.gnu.org/licenses/>
//

/// Interface for heap data-structures.
pub trait Heap {
    /// Type of items on the heap.
    type Item;

    /// Type of keys.
    type Key;

    /// Return a newly allocated heap.
    fn new() -> Self;

    /// Remove all elements from the heap.
    fn clear(&mut self);

    /// Return true if heap is empty.
    fn is_empty(&self) -> bool;

    /// Insert a new item into the heap.
    fn insert(&mut self, key: Self::Key) -> Self::Item;

    /// Decrease the key of an item.
    fn decrease(&mut self, item: Self::Item);

    /// Return the minimal key.
    fn pop_min(&mut self) -> Option<Self::Key>;

    /// Returns the current key of an item.
    fn key(&mut self, _: Self::Item) -> &mut Self::Key;
}
