use clap::Parser;

mod dog;

#[derive(Parser, Debug)]
#[clap(author, version, about)]
pub struct Args {
    /// Enable debug mode
    #[clap(short, long)]
    debug: bool,

    /// Number all nonempty output lines, starting with 1.
    #[clap(short = 'b', long)]
    number_nonblank: bool,

    /// Display a ‘$’ after the end of each line.
    #[clap(short = 'E', long)]
    show_ends: bool,

    /// Number all output lines, starting with 1. This option is ignored if -b is in effect.
    #[clap(short, long)]
    number: bool,

    /// Prints each file to stdout.
    inputs: Vec<String>,
}

fn main() {
    let args: Args = Args::parse();
    dog::dog(args);
}
