use crate::Args;

use std::process;
use std::fs;

pub fn dog(args: Args) {
    if args.debug {
        println!("{:?}", args);
    }

    // Load files / stdin
    let mut filedata: Vec<String> = Vec::new();
    if args.inputs.len() == 0 {
        eprintln!("No inputs given");
        process::exit(1);
    } else {
        // Iter over inputs and read to string
        for filepath in args.inputs {
            filedata.push(match fs::read_to_string(filepath.clone()) {
                Ok(v) => v,
                Err(e) => {
                    eprintln!("{e}: {}", filepath);
                    process::exit(2);
                }
            })
        }
    }

    // Print each file
    let mut ln: u64 = 0; // Used for line numbering
    for data in filedata {
        for token in data.split('\n') {
            // Increment ln
            ln += 1;

            // Handle numbered line cases
            if (args.number_nonblank && token.len() != 0 ) || (!args.number_nonblank && args.number) {
                print!("|{ln}| ");
            }
                
            print!("{token}");

            // Handle the $ end case
            if args.show_ends {
                print!("$");
            }
            
            println!();
        }
    }
}