use crate::args::{Local, Steam};
use crate::utils::*;
use rrm_installer::Installer;
use rrm_locals::Filtrable;

pub fn search_locally(i: Installer, args: Local) {
    let d_type = rrm_locals::DisplayType::from(args.display.large);
    let mods = GameMods::from(i.rim_install.unwrap()).with_display(d_type);

    let filtered = mods.filter_by(args.to_filter_obj(), &args.string);

    if !filtered.is_empty() {
        if args.display.pager || i.use_more && !args.display.no_pager {
            filtered.more_display(&i.with_paging)
        } else {
            filtered.display()
        }
    } else {
        println!("No results found")
    }
}

pub async fn search_steam(i: Installer, args: Steam) {
    let mods = SteamMods::search(&args.r#mod)
        .await
        .with_display(rrm_locals::DisplayType::from(args.display.large));

    if !mods.is_empty() {
        if args.display.pager || i.use_more && !args.display.no_pager {
            mods.more_display(&i.with_paging)
        } else {
            mods.display()
        }
    } else {
        println!("No results found")
    }
}
