# Rrise-Headers

[![Crates.io](https://img.shields.io/crates/v/rrise-headers.svg)](https://crates.io/crates/rrise-headers)
[![MIT/Apache 2.0](https://img.shields.io/badge/license-MIT%2FApache-blue.svg)](./LICENSE)
[![Crates.io](https://img.shields.io/crates/d/rrise-headers.svg)](https://crates.io/crates/rrise-headers)

## What is Rrise-Headers?
This crate is essentially a build script that generates a file of constants. This crate is meant to be used along 
the [rrise](/README.md) crate.

Once soundbanks are generated by [Wwise](https://www.audiokinetic.com/en/products/wwise), you will usually find a 
companion .txt file containing the soundbank definition: all the events, states, RTPCs, switches, triggers 
etc by name and by ID.

Rrise-Headers will parse this definition file and generate a rust file replicating it with constants usable in code.

This will allow you to fail early when your Wwise project gets updated. For instance, if some events are going missing, 
your code won't compile without fixing those stale events it still posts.

## Usage

### Configuration
The following environment variables are available:

| Variable       | Description                                                                                                                   |
|----------------|:------------------------------------------------------------------------------------------------------------------------------|
| `BANK_PATH`    | Your generated soundbank folder                                                                                               |

### Getting started
1. Set the `BANK_PATH` environment variable to your generated soundbank folder. Don't include the platform 
folder, but rather just the folder that will contain the per-platform directories of your soundbanks.
2. Make sure the soundbank paths in your Wwise project settings end with `Linux` and `Windows`. If they 
   don't, this crate will expect the soundbanks to be directly in `BANK_PATH`.
3. Add this crate as a dependency of your project.
4. Add `use rrise_headers::rr` to the files where you need to refer to Wwise generated resources like events or RTPCs.
5. You can now use constants like `rr::ev::MyEvent` and benefit from your IDE's autocompletion when you type `rr::`.

### About identifiers
When translating Wwise identifiers,
- The case of the resulting Rust identifiers is identical to the one in the Wwise project.
- Spaces and other [invalid](https://doc.rust-lang.org/beta/reference/identifiers.html) characters are replaced with `_`.
- Would an identifier start with a number, it is prepended with `_`.
- Unicode characters are [allowed](https://doc.rust-lang.org/beta/reference/identifiers.html).

### Namespacing
Here is how rrise-headers structures your Wwise resources in the `rr` module:

```
rr
|-- bnk   // Init + your soundbanks defined as string constants
|-- ev    // Events
|-- d_ev  // Dialog events
|-- rtpc  // Game parameters
|-- trg   // Triggers
|-- bus   // Busses
|-- xbus  // Auxiliary busses
|-- dev   // Audio Devices
|
|-- st                                                   // States
|---- <... YourStateGroup ...>                           // State group ID *and* module
|------ <... states available in YourStateGroup ...>     // State values are namespaced in their group
|
|-- sw                                                   // Switches
|---- <... YourSwitchGroup ...>                          // Switch group ID *and* module
|------ <... switches available in YourSwitchGroup ...>  // Switch values are namespaced in their group
```

### Legal stuff
Wwise and the Wwise logo are trademarks of Audiokinetic Inc., registered in the U.S. and other countries.

This project is in no way affiliated to Audiokinetic.
