//! ## Description
//! **rplaid** is an async client for the [Plaid API](https://plaid.com/docs/api/).
//! With minimal features, the client is meant to be extensible and lightweight.
//! Additional features can be enabled to improve ergonomics of the API at the
//! cost of additional dependencies.
//!
//! ## Features
//! * Idiomatic futures generator for easily reading multiple pages of transactions.
//! * Extensible HttpClient interfaces supports multiple HTTP clients with minimal
//!   effort (surf, H1, and reqwest). The trait can also be implemented to have full
//!   control over the client used.
pub mod client;
pub mod model;

pub use http_client::HttpClient;

