use std::fmt;
use std::fmt::Debug;
use std::fmt::Display;
use serde::{Deserialize, Serialize};
use std::ops::{Add, AddAssign, Div, DivAssign, Mul, MulAssign, Neg, Rem, RemAssign, Sub, SubAssign};
extern crate num;

#[derive(Debug, Clone, Copy, PartialEq, Eq, Deserialize, Serialize)]
pub enum Equation<T:Copy 
                 + Default
                 + Display
                 + AddAssign
                 + Add<Output = T>
                 + Div<Output = T>
                 + DivAssign
                 + Mul<Output = T>
                 + MulAssign
                 + Neg<Output = T>
                 + Rem<Output = T>
                 + RemAssign
                 + Sub<Output = T>
                 + SubAssign
                 + std::cmp::PartialOrd
                 + std::cmp::PartialEq
                 + num::NumCast> {
    AddRight(Operation<T>, T),
    AddLeft(T, Operation<T>),
    Subtract(T, T),
    Multiply(T, T),
    Divide(T, T),
    Power(T, T),
}
impl<T:Copy 
    + Default
    + Display
    + AddAssign
    + Add<Output = T>
    + Div<Output = T>
    + DivAssign
    + Mul<Output = T>
    + MulAssign
    + Neg<Output = T>
    + Rem<Output = T>
    + RemAssign
    + Sub<Output = T>
    + SubAssign
    + std::cmp::PartialOrd
    + std::cmp::PartialEq
    + num::NumCast> Equation<T> {
    /// 
    #[allow(dead_code)]
    pub fn result(&self) -> T {
        match *self {
            Equation::AddRight(op, val) => {
                op.result() + val
            },
            _=> Default::default(),
        }
    }
}
impl<T:Copy 
    + Default
    + Display
    + AddAssign
    + Add<Output = T>
    + Div<Output = T>
    + DivAssign
    + Mul<Output = T>
    + MulAssign
    + Neg<Output = T>
    + Rem<Output = T>
    + RemAssign
    + Sub<Output = T>
    + SubAssign
    + std::cmp::PartialOrd
    + std::cmp::PartialEq
    + num::NumCast> fmt::Display for Equation<T> {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
match *self {
            Equation::AddRight(op, val) => write!(f, "({}) + {}", op, val),
            Equation::AddLeft(val, op) => write!(f, "{} + ({})", val, op),
            _=> write!(f, ""),
        }
    }
}
#[derive(Debug, Clone, Copy, PartialEq, Eq, Deserialize, Serialize)]
pub enum Operation<T:Copy 
                 + Default
                 + Display
                 + AddAssign
                 + Add<Output = T>
                 + Div<Output = T>
                 + DivAssign
                 + Mul<Output = T>
                 + MulAssign
                 + Neg<Output = T>
                 + Rem<Output = T>
                 + RemAssign
                 + Sub<Output = T>
                 + SubAssign
                 + std::cmp::PartialOrd
                 + std::cmp::PartialEq
                 + num::NumCast> {
    Add(T, T),
    Subtract(T, T),
    Multiply(T, T),
    Divide(T, T),
    Power(T, T),
    None(T),
}
impl<T:Copy 
    + Default
    + Display
    + AddAssign
    + Add<Output = T>
    + Div<Output = T>
    + DivAssign
    + Mul<Output = T>
    + MulAssign
    + Neg<Output = T>
    + Rem<Output = T>
    + RemAssign
    + Sub<Output = T>
    + SubAssign
    + std::cmp::PartialOrd
    + std::cmp::PartialEq
    + num::NumCast> Default for Operation<T> {
    fn default() -> Self {
        Self::None(Default::default())
    }
}
impl<T:Copy 
    + Default
    + Display
    + AddAssign
    + Add<Output = T>
    + Div<Output = T>
    + DivAssign
    + Mul<Output = T>
    + MulAssign
    + Neg<Output = T>
    + Rem<Output = T>
    + RemAssign
    + Sub<Output = T>
    + SubAssign
    + std::cmp::PartialOrd
    + std::cmp::PartialEq
    + num::NumCast> Operation<T> {
    /// 
    #[allow(dead_code)]
    pub fn result(&self) -> T {
        match *self {
            Operation::Add(a, b) => {
                a + b
            },
            Operation::Subtract(a, b) => {
                a - b
            },
            Operation::Multiply(a, b) => {
                a * b
            },
            Operation::Divide(a, b) => {
                a / b
            },
            Operation::Power(a, b) => {
                let mut result:T = a;
                let mut iter:T = b;
                iter -= num::cast(1).unwrap();
                let nada:T = num::cast(0).unwrap();
                while iter > nada {
                    result *= a;
                    iter -= num::cast(1).unwrap();
                }
                result
            },
            Operation::None(a) => a,
        }
    }
}
impl<T:Copy 
    + Default
    + Display
    + AddAssign
    + Add<Output = T>
    + Div<Output = T>
    + DivAssign
    + Mul<Output = T>
    + MulAssign
    + Neg<Output = T>
    + Rem<Output = T>
    + RemAssign
    + Sub<Output = T>
    + SubAssign
    + std::cmp::PartialOrd
    + std::cmp::PartialEq
    + num::NumCast> fmt::Display for Operation<T> {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        let v:String;
        let first:T;
        let second:T;
        match *self {
            Operation::Add(a, b) => {
                first = a;
                second = b;
                v = String::from("+");
            },
            Operation::Subtract(a, b) => {
                first = a;
                second = b;
                v = String::from("-");
            },
            Operation::Multiply(a, b) => {
                first = a;
                second = b;
                v = String::from("*");
            },
            Operation::Divide(a, b) => {
                first = a;
                second = b;
                v = String::from("/");
            },
            Operation::Power(a, b) => {
                first = a;
                second = b;
                v = String::from("^");
            },
            Operation::None(a) => {
                first = a;
                return write!(f, "{}", first)
            },
            //Operation::(a, b) => {first = a;second = b;v = String::from("");},
            

        }
        write!(f, "{} {} {}", first, v.as_str(), second)
    }
}
#[allow(unused)]
pub struct Math <T:Copy 
                 + Default
                 + AddAssign
                 + Add<Output = T>
                 + Div<Output = T>
                 + DivAssign
                 + Mul<Output = T>
                 + MulAssign
                 + Neg<Output = T>
                 + Rem<Output = T>
                 + RemAssign
                 + Sub<Output = T>
                 + SubAssign
                 + std::cmp::PartialOrd
                 + std::cmp::PartialEq
                 + num::NumCast> {
    pub answer:T,
    pub question:String,
}
impl <T:Copy 
    + Default
    + AddAssign
    + Add<Output = T>
    + Div<Output = T>
    + DivAssign
    + Mul<Output = T>
    + MulAssign
    + Neg<Output = T>
    + Rem<Output = T>
    + RemAssign
    + Sub<Output = T>
    + SubAssign
    + std::cmp::PartialOrd
    + std::cmp::PartialEq
    + num::NumCast> Math<T> {
    /// einstien math
    /// `e = m * (c * c)` is fun, so...
    #[allow(unused)]
    pub fn e_mc2 (m:T, c:T) -> T {
        m * (c * c)
    }
/*

*/
    #[allow(unused)]
    pub fn patterns(begin:T, end:T, number_of_entries:usize) -> Vec<T> {
        //30% digit one is 1
        // exponentially less for each number
        let mut ret_vec:Vec<T> = vec![];
        /*let mut tracker = begin;
        for 0..number_of_entries {
            if value < num::cast(30).unwrap() {
                
            }
        }*/
        ret_vec
    }
/*
Divide a number in half
*/
    #[allow(unused)]
    pub fn half(number: T) -> T {
        let two = num::cast(2).unwrap();
        number / two
    }
/*
Used to start the square root
*/
    #[allow(unused)]
    pub fn estimate_start(number: T) -> T {
        let mut num = number;
        let mut return_value = Math::half(number);
        let one_hundred:T = num::cast(100).unwrap();
        while num > one_hundred {
            return_value = Math::half(return_value);
            num /= one_hundred;
        }
        return_value
    }
/*
Not sure if this is the best equation to use, but it works...
*/
    #[allow(unused)]
    pub fn sqrt(number: T) -> T {
        let starter:u32 = num::cast(Math::estimate_start(number)).unwrap();
        let total:u32 = num::cast(number).unwrap();
        for num in starter..total {
            if num * num == num::cast(number).unwrap() {
                return num::cast(num).unwrap()
            }
        }
        T::default()
    }
    #[allow(unused)]
    pub fn population_standard_deviation(numbers:Vec<T>) -> T {
        Math::sqrt(Math::variance(numbers))
    }

    #[allow(unused)]
    pub fn variance(numbers:Vec<T>) -> T {
        let mean:T = Math::mean(numbers.clone());
        let mut total:T = T::default();
        let mut counter:T = T::default();
        for number in numbers {
            counter += num::cast(1).unwrap();
            let result:T = number - mean;
            total += result * result
        }
        total / counter
    }
    #[allow(unused)]
    pub fn mean(numbers:Vec<T>) -> T {
        let mut total:T = num::cast(0).unwrap();
        let mut total_count:T = num::cast(0).unwrap();
        for number in numbers {
            total += number;
            total_count += num::cast(1).unwrap();
        }
        total / total_count
    }
    
}
