#![doc = "Peripheral access API for RP2040 microcontrollers (generated using svd2rust v0.19.0 ( ))  

You can find an overview of the generated API [here].  

API features to be included in the [next]
svd2rust release can be generated by cloning the svd2rust [repository], checking out the above commit, and running `cargo doc --open`.  

[here]: https://docs.rs/svd2rust/0.19.0/svd2rust/#peripheral-api  
[next]: https://github.com/rust-embedded/svd2rust/blob/master/CHANGELOG.md#unreleased  
[repository]: https://github.com/rust-embedded/svd2rust"]
#![deny(const_err)]
#![deny(dead_code)]
#![deny(improper_ctypes)]
#![deny(missing_docs)]
#![deny(no_mangle_generic_items)]
#![deny(non_shorthand_field_patterns)]
#![deny(overflowing_literals)]
#![deny(path_statements)]
#![deny(patterns_in_fns_without_body)]
#![deny(private_in_public)]
#![deny(unconditional_recursion)]
#![deny(unused_allocation)]
#![deny(unused_comparisons)]
#![deny(unused_parens)]
#![deny(while_true)]
#![allow(non_camel_case_types)]
#![allow(non_snake_case)]
#![no_std]
use core::marker::PhantomData;
use core::ops::Deref;
#[doc = r"Number available in the NVIC for configuring priority"]
pub const NVIC_PRIO_BITS: u8 = 2;
#[cfg(feature = "rt")]
pub use self::Interrupt as interrupt;
pub use cortex_m::peripheral::Peripherals as CorePeripherals;
pub use cortex_m::peripheral::{CBP, CPUID, DCB, DWT, FPB, ITM, MPU, NVIC, SCB, SYST, TPIU};
#[cfg(feature = "rt")]
pub use cortex_m_rt::interrupt;
#[allow(unused_imports)]
use generic::*;
#[doc = r"Common register and bit access and modify traits"]
pub mod generic;
#[cfg(feature = "rt")]
extern "C" {
    fn TIMER_IRQ_0();
    fn TIMER_IRQ_1();
    fn TIMER_IRQ_2();
    fn TIMER_IRQ_3();
    fn PWM_IRQ_WRAP();
    fn USBCTRL_IRQ();
    fn XIP_IRQ();
    fn PIO0_IRQ_0();
    fn PIO0_IRQ_1();
    fn PIO1_IRQ_0();
    fn PIO1_IRQ_1();
    fn DMA_IRQ_0();
    fn DMA_IRQ_1();
    fn IO_IRQ_BANK0();
    fn IO_IRQ_QSPI();
    fn SIO_IRQ_PROC0();
    fn SIO_IRQ_PROC1();
    fn CLOCKS_IRQ();
    fn SPI0_IRQ();
    fn SPI1_IRQ();
    fn UART0_IRQ();
    fn UART1_IRQ();
    fn ADC_IRQ_FIFO();
    fn I2C0_IRQ();
    fn I2C1_IRQ();
    fn RTC_IRQ();
}
#[doc(hidden)]
pub union Vector {
    _handler: unsafe extern "C" fn(),
    _reserved: u32,
}
#[cfg(feature = "rt")]
#[doc(hidden)]
#[link_section = ".vector_table.interrupts"]
#[no_mangle]
pub static __INTERRUPTS: [Vector; 26] = [
    Vector {
        _handler: TIMER_IRQ_0,
    },
    Vector {
        _handler: TIMER_IRQ_1,
    },
    Vector {
        _handler: TIMER_IRQ_2,
    },
    Vector {
        _handler: TIMER_IRQ_3,
    },
    Vector {
        _handler: PWM_IRQ_WRAP,
    },
    Vector {
        _handler: USBCTRL_IRQ,
    },
    Vector { _handler: XIP_IRQ },
    Vector {
        _handler: PIO0_IRQ_0,
    },
    Vector {
        _handler: PIO0_IRQ_1,
    },
    Vector {
        _handler: PIO1_IRQ_0,
    },
    Vector {
        _handler: PIO1_IRQ_1,
    },
    Vector {
        _handler: DMA_IRQ_0,
    },
    Vector {
        _handler: DMA_IRQ_1,
    },
    Vector {
        _handler: IO_IRQ_BANK0,
    },
    Vector {
        _handler: IO_IRQ_QSPI,
    },
    Vector {
        _handler: SIO_IRQ_PROC0,
    },
    Vector {
        _handler: SIO_IRQ_PROC1,
    },
    Vector {
        _handler: CLOCKS_IRQ,
    },
    Vector { _handler: SPI0_IRQ },
    Vector { _handler: SPI1_IRQ },
    Vector {
        _handler: UART0_IRQ,
    },
    Vector {
        _handler: UART1_IRQ,
    },
    Vector {
        _handler: ADC_IRQ_FIFO,
    },
    Vector { _handler: I2C0_IRQ },
    Vector { _handler: I2C1_IRQ },
    Vector { _handler: RTC_IRQ },
];
#[doc = r"Enumeration of all the interrupts."]
#[derive(Copy, Clone, Debug, PartialEq, Eq)]
#[repr(u16)]
pub enum Interrupt {
    #[doc = "0 - TIMER_IRQ_0"]
    TIMER_IRQ_0 = 0,
    #[doc = "1 - TIMER_IRQ_1"]
    TIMER_IRQ_1 = 1,
    #[doc = "2 - TIMER_IRQ_2"]
    TIMER_IRQ_2 = 2,
    #[doc = "3 - TIMER_IRQ_3"]
    TIMER_IRQ_3 = 3,
    #[doc = "4 - PWM_IRQ_WRAP"]
    PWM_IRQ_WRAP = 4,
    #[doc = "5 - USBCTRL_IRQ"]
    USBCTRL_IRQ = 5,
    #[doc = "6 - XIP_IRQ"]
    XIP_IRQ = 6,
    #[doc = "7 - PIO0_IRQ_0"]
    PIO0_IRQ_0 = 7,
    #[doc = "8 - PIO0_IRQ_1"]
    PIO0_IRQ_1 = 8,
    #[doc = "9 - PIO1_IRQ_0"]
    PIO1_IRQ_0 = 9,
    #[doc = "10 - PIO1_IRQ_1"]
    PIO1_IRQ_1 = 10,
    #[doc = "11 - DMA_IRQ_0"]
    DMA_IRQ_0 = 11,
    #[doc = "12 - DMA_IRQ_1"]
    DMA_IRQ_1 = 12,
    #[doc = "13 - IO_IRQ_BANK0"]
    IO_IRQ_BANK0 = 13,
    #[doc = "14 - IO_IRQ_QSPI"]
    IO_IRQ_QSPI = 14,
    #[doc = "15 - SIO_IRQ_PROC0"]
    SIO_IRQ_PROC0 = 15,
    #[doc = "16 - SIO_IRQ_PROC1"]
    SIO_IRQ_PROC1 = 16,
    #[doc = "17 - CLOCKS_IRQ"]
    CLOCKS_IRQ = 17,
    #[doc = "18 - SPI0_IRQ"]
    SPI0_IRQ = 18,
    #[doc = "19 - SPI1_IRQ"]
    SPI1_IRQ = 19,
    #[doc = "20 - UART0_IRQ"]
    UART0_IRQ = 20,
    #[doc = "21 - UART1_IRQ"]
    UART1_IRQ = 21,
    #[doc = "22 - ADC_IRQ_FIFO"]
    ADC_IRQ_FIFO = 22,
    #[doc = "23 - I2C0_IRQ"]
    I2C0_IRQ = 23,
    #[doc = "24 - I2C1_IRQ"]
    I2C1_IRQ = 24,
    #[doc = "25 - RTC_IRQ"]
    RTC_IRQ = 25,
}
unsafe impl cortex_m::interrupt::InterruptNumber for Interrupt {
    #[inline(always)]
    fn number(self) -> u16 {
        self as u16
    }
}
#[doc = "QSPI flash execute-in-place block"]
pub struct XIP_CTRL {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for XIP_CTRL {}
impl XIP_CTRL {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const xip_ctrl::RegisterBlock = 0x1400_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const xip_ctrl::RegisterBlock {
        Self::PTR
    }
}
impl Deref for XIP_CTRL {
    type Target = xip_ctrl::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for XIP_CTRL {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("XIP_CTRL").finish()
    }
}
#[doc = "QSPI flash execute-in-place block"]
pub mod xip_ctrl;
#[doc = "DW_apb_ssi has the following features:  
 * APB interface – Allows for easy integration into a DesignWare Synthesizable Components for AMBA 2 implementation.  
 * APB3 and APB4 protocol support.  
 * Scalable APB data bus width – Supports APB data bus widths of 8, 16, and 32 bits.  
 * Serial-master or serial-slave operation – Enables serial communication with serial-master or serial-slave peripheral devices.  
 * Programmable Dual/Quad/Octal SPI support in Master Mode.  
 * Dual Data Rate (DDR) and Read Data Strobe (RDS) Support - Enables the DW_apb_ssi master to perform operations with the device in DDR and RDS modes when working in Dual/Quad/Octal mode of operation.  
 * Data Mask Support - Enables the DW_apb_ssi to selectively update the bytes in the device. This feature is applicable only in enhanced SPI modes.  
 * eXecute-In-Place (XIP) support - Enables the DW_apb_ssi master to behave as a memory mapped I/O and fetches the data from the device based on the APB read request. This feature is applicable only in enhanced SPI modes.  
 * DMA Controller Interface – Enables the DW_apb_ssi to interface to a DMA controller over the bus using a handshaking interface for transfer requests.  
 * Independent masking of interrupts – Master collision, transmit FIFO overflow, transmit FIFO empty, receive FIFO full, receive FIFO underflow, and receive FIFO overflow interrupts can all be masked independently.  
 * Multi-master contention detection – Informs the processor of multiple serial-master accesses on the serial bus.  
 * Bypass of meta-stability flip-flops for synchronous clocks – When the APB clock (pclk) and the DW_apb_ssi serial clock (ssi_clk) are synchronous, meta-stable flip-flops are not used when transferring control signals across these clock domains.  
 * Programmable delay on the sample time of the received serial data bit (rxd); enables programmable control of routing delays resulting in higher serial data-bit rates.  
 * Programmable features:  
 - Serial interface operation – Choice of Motorola SPI, Texas Instruments Synchronous Serial Protocol or National Semiconductor Microwire.  
 - Clock bit-rate – Dynamic control of the serial bit rate of the data transfer; used in only serial-master mode of operation.  
 - Data Item size (4 to 32 bits) – Item size of each data transfer under the control of the programmer.  
 * Configured features:  
 - FIFO depth – 16 words deep. The FIFO width is fixed at 32 bits.  
 - 1 slave select output.  
 - Hardware slave-select – Dedicated hardware slave-select line.  
 - Combined interrupt line - one combined interrupt line from the DW_apb_ssi to the interrupt controller.  
 - Interrupt polarity – active high interrupt lines.  
 - Serial clock polarity – low serial-clock polarity directly after reset.  
 - Serial clock phase – capture on first edge of serial-clock directly after reset."]
pub struct XIP_SSI {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for XIP_SSI {}
impl XIP_SSI {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const xip_ssi::RegisterBlock = 0x1800_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const xip_ssi::RegisterBlock {
        Self::PTR
    }
}
impl Deref for XIP_SSI {
    type Target = xip_ssi::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for XIP_SSI {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("XIP_SSI").finish()
    }
}
#[doc = "DW_apb_ssi has the following features:  
 * APB interface – Allows for easy integration into a DesignWare Synthesizable Components for AMBA 2 implementation.  
 * APB3 and APB4 protocol support.  
 * Scalable APB data bus width – Supports APB data bus widths of 8, 16, and 32 bits.  
 * Serial-master or serial-slave operation – Enables serial communication with serial-master or serial-slave peripheral devices.  
 * Programmable Dual/Quad/Octal SPI support in Master Mode.  
 * Dual Data Rate (DDR) and Read Data Strobe (RDS) Support - Enables the DW_apb_ssi master to perform operations with the device in DDR and RDS modes when working in Dual/Quad/Octal mode of operation.  
 * Data Mask Support - Enables the DW_apb_ssi to selectively update the bytes in the device. This feature is applicable only in enhanced SPI modes.  
 * eXecute-In-Place (XIP) support - Enables the DW_apb_ssi master to behave as a memory mapped I/O and fetches the data from the device based on the APB read request. This feature is applicable only in enhanced SPI modes.  
 * DMA Controller Interface – Enables the DW_apb_ssi to interface to a DMA controller over the bus using a handshaking interface for transfer requests.  
 * Independent masking of interrupts – Master collision, transmit FIFO overflow, transmit FIFO empty, receive FIFO full, receive FIFO underflow, and receive FIFO overflow interrupts can all be masked independently.  
 * Multi-master contention detection – Informs the processor of multiple serial-master accesses on the serial bus.  
 * Bypass of meta-stability flip-flops for synchronous clocks – When the APB clock (pclk) and the DW_apb_ssi serial clock (ssi_clk) are synchronous, meta-stable flip-flops are not used when transferring control signals across these clock domains.  
 * Programmable delay on the sample time of the received serial data bit (rxd); enables programmable control of routing delays resulting in higher serial data-bit rates.  
 * Programmable features:  
 - Serial interface operation – Choice of Motorola SPI, Texas Instruments Synchronous Serial Protocol or National Semiconductor Microwire.  
 - Clock bit-rate – Dynamic control of the serial bit rate of the data transfer; used in only serial-master mode of operation.  
 - Data Item size (4 to 32 bits) – Item size of each data transfer under the control of the programmer.  
 * Configured features:  
 - FIFO depth – 16 words deep. The FIFO width is fixed at 32 bits.  
 - 1 slave select output.  
 - Hardware slave-select – Dedicated hardware slave-select line.  
 - Combined interrupt line - one combined interrupt line from the DW_apb_ssi to the interrupt controller.  
 - Interrupt polarity – active high interrupt lines.  
 - Serial clock polarity – low serial-clock polarity directly after reset.  
 - Serial clock phase – capture on first edge of serial-clock directly after reset."]
pub mod xip_ssi;
#[doc = "SYSINFO"]
pub struct SYSINFO {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SYSINFO {}
impl SYSINFO {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const sysinfo::RegisterBlock = 0x4000_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const sysinfo::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SYSINFO {
    type Target = sysinfo::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SYSINFO {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SYSINFO").finish()
    }
}
#[doc = "SYSINFO"]
pub mod sysinfo;
#[doc = "Register block for various chip control signals"]
pub struct SYSCFG {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SYSCFG {}
impl SYSCFG {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const syscfg::RegisterBlock = 0x4000_4000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const syscfg::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SYSCFG {
    type Target = syscfg::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SYSCFG {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SYSCFG").finish()
    }
}
#[doc = "Register block for various chip control signals"]
pub mod syscfg;
#[doc = "CLOCKS"]
pub struct CLOCKS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CLOCKS {}
impl CLOCKS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const clocks::RegisterBlock = 0x4000_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const clocks::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CLOCKS {
    type Target = clocks::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CLOCKS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CLOCKS").finish()
    }
}
#[doc = "CLOCKS"]
pub mod clocks;
#[doc = "RESETS"]
pub struct RESETS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for RESETS {}
impl RESETS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const resets::RegisterBlock = 0x4000_c000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const resets::RegisterBlock {
        Self::PTR
    }
}
impl Deref for RESETS {
    type Target = resets::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for RESETS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("RESETS").finish()
    }
}
#[doc = "RESETS"]
pub mod resets;
#[doc = "PSM"]
pub struct PSM {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PSM {}
impl PSM {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const psm::RegisterBlock = 0x4001_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const psm::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PSM {
    type Target = psm::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PSM {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PSM").finish()
    }
}
#[doc = "PSM"]
pub mod psm;
#[doc = "IO_BANK0"]
pub struct IO_BANK0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for IO_BANK0 {}
impl IO_BANK0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const io_bank0::RegisterBlock = 0x4001_4000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const io_bank0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for IO_BANK0 {
    type Target = io_bank0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for IO_BANK0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("IO_BANK0").finish()
    }
}
#[doc = "IO_BANK0"]
pub mod io_bank0;
#[doc = "IO_QSPI"]
pub struct IO_QSPI {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for IO_QSPI {}
impl IO_QSPI {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const io_qspi::RegisterBlock = 0x4001_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const io_qspi::RegisterBlock {
        Self::PTR
    }
}
impl Deref for IO_QSPI {
    type Target = io_qspi::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for IO_QSPI {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("IO_QSPI").finish()
    }
}
#[doc = "IO_QSPI"]
pub mod io_qspi;
#[doc = "PADS_BANK0"]
pub struct PADS_BANK0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PADS_BANK0 {}
impl PADS_BANK0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pads_bank0::RegisterBlock = 0x4001_c000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pads_bank0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PADS_BANK0 {
    type Target = pads_bank0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PADS_BANK0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PADS_BANK0").finish()
    }
}
#[doc = "PADS_BANK0"]
pub mod pads_bank0;
#[doc = "PADS_QSPI"]
pub struct PADS_QSPI {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PADS_QSPI {}
impl PADS_QSPI {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pads_qspi::RegisterBlock = 0x4002_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pads_qspi::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PADS_QSPI {
    type Target = pads_qspi::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PADS_QSPI {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PADS_QSPI").finish()
    }
}
#[doc = "PADS_QSPI"]
pub mod pads_qspi;
#[doc = "Controls the crystal oscillator"]
pub struct XOSC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for XOSC {}
impl XOSC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const xosc::RegisterBlock = 0x4002_4000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const xosc::RegisterBlock {
        Self::PTR
    }
}
impl Deref for XOSC {
    type Target = xosc::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for XOSC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("XOSC").finish()
    }
}
#[doc = "Controls the crystal oscillator"]
pub mod xosc;
#[doc = "PLL_SYS"]
pub struct PLL_SYS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PLL_SYS {}
impl PLL_SYS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pll_sys::RegisterBlock = 0x4002_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pll_sys::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PLL_SYS {
    type Target = pll_sys::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PLL_SYS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PLL_SYS").finish()
    }
}
#[doc = "PLL_SYS"]
pub mod pll_sys;
#[doc = "PLL_USB"]
pub struct PLL_USB {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PLL_USB {}
impl PLL_USB {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pll_sys::RegisterBlock = 0x4002_c000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pll_sys::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PLL_USB {
    type Target = pll_sys::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PLL_USB {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PLL_USB").finish()
    }
}
#[doc = "Register block for busfabric control signals and performance counters"]
pub struct BUSCTRL {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for BUSCTRL {}
impl BUSCTRL {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const busctrl::RegisterBlock = 0x4003_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const busctrl::RegisterBlock {
        Self::PTR
    }
}
impl Deref for BUSCTRL {
    type Target = busctrl::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for BUSCTRL {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("BUSCTRL").finish()
    }
}
#[doc = "Register block for busfabric control signals and performance counters"]
pub mod busctrl;
#[doc = "UART0"]
pub struct UART0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for UART0 {}
impl UART0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const uart0::RegisterBlock = 0x4003_4000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const uart0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for UART0 {
    type Target = uart0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for UART0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("UART0").finish()
    }
}
#[doc = "UART0"]
pub mod uart0;
#[doc = "UART1"]
pub struct UART1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for UART1 {}
impl UART1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const uart0::RegisterBlock = 0x4003_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const uart0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for UART1 {
    type Target = uart0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for UART1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("UART1").finish()
    }
}
#[doc = "SPI0"]
pub struct SPI0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPI0 {}
impl SPI0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spi0::RegisterBlock = 0x4003_c000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spi0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPI0 {
    type Target = spi0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPI0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPI0").finish()
    }
}
#[doc = "SPI0"]
pub mod spi0;
#[doc = "SPI1"]
pub struct SPI1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPI1 {}
impl SPI1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spi0::RegisterBlock = 0x4004_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spi0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPI1 {
    type Target = spi0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPI1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPI1").finish()
    }
}
#[doc = "DW_apb_i2c address block"]
pub struct I2C0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2C0 {}
impl I2C0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2c0::RegisterBlock = 0x4004_4000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2c0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2C0 {
    type Target = i2c0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2C0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2C0").finish()
    }
}
#[doc = "DW_apb_i2c address block"]
pub mod i2c0;
#[doc = "DW_apb_i2c address block"]
pub struct I2C1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2C1 {}
impl I2C1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2c0::RegisterBlock = 0x4004_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2c0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2C1 {
    type Target = i2c0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2C1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2C1").finish()
    }
}
#[doc = "Control and data interface to SAR ADC"]
pub struct ADC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for ADC {}
impl ADC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const adc::RegisterBlock = 0x4004_c000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const adc::RegisterBlock {
        Self::PTR
    }
}
impl Deref for ADC {
    type Target = adc::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for ADC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("ADC").finish()
    }
}
#[doc = "Control and data interface to SAR ADC"]
pub mod adc;
#[doc = "Simple PWM"]
pub struct PWM {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PWM {}
impl PWM {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pwm::RegisterBlock = 0x4005_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pwm::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PWM {
    type Target = pwm::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PWM {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PWM").finish()
    }
}
#[doc = "Simple PWM"]
pub mod pwm;
#[doc = "Controls time and alarms  
 time is a 64 bit value indicating the time in usec since power-on  
 timeh is the top 32 bits of time & timel is the bottom 32 bits  
 to change time write to timelw before timehw  
 to read time read from timelr before timehr  
 An alarm is set by setting alarm_enable and writing to the corresponding alarm register  
 When an alarm is pending, the corresponding alarm_running signal will be high  
 An alarm can be cancelled before it has finished by clearing the alarm_enable  
 When an alarm fires, the corresponding alarm_irq is set and alarm_running is cleared  
 To clear the interrupt write a 1 to the corresponding alarm_irq"]
pub struct TIMER {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIMER {}
impl TIMER {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const timer::RegisterBlock = 0x4005_4000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const timer::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIMER {
    type Target = timer::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIMER {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIMER").finish()
    }
}
#[doc = "Controls time and alarms  
 time is a 64 bit value indicating the time in usec since power-on  
 timeh is the top 32 bits of time & timel is the bottom 32 bits  
 to change time write to timelw before timehw  
 to read time read from timelr before timehr  
 An alarm is set by setting alarm_enable and writing to the corresponding alarm register  
 When an alarm is pending, the corresponding alarm_running signal will be high  
 An alarm can be cancelled before it has finished by clearing the alarm_enable  
 When an alarm fires, the corresponding alarm_irq is set and alarm_running is cleared  
 To clear the interrupt write a 1 to the corresponding alarm_irq"]
pub mod timer;
#[doc = "WATCHDOG"]
pub struct WATCHDOG {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for WATCHDOG {}
impl WATCHDOG {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const watchdog::RegisterBlock = 0x4005_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const watchdog::RegisterBlock {
        Self::PTR
    }
}
impl Deref for WATCHDOG {
    type Target = watchdog::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for WATCHDOG {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("WATCHDOG").finish()
    }
}
#[doc = "WATCHDOG"]
pub mod watchdog;
#[doc = "Register block to control RTC"]
pub struct RTC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for RTC {}
impl RTC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const rtc::RegisterBlock = 0x4005_c000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const rtc::RegisterBlock {
        Self::PTR
    }
}
impl Deref for RTC {
    type Target = rtc::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for RTC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("RTC").finish()
    }
}
#[doc = "Register block to control RTC"]
pub mod rtc;
#[doc = "ROSC"]
pub struct ROSC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for ROSC {}
impl ROSC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const rosc::RegisterBlock = 0x4006_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const rosc::RegisterBlock {
        Self::PTR
    }
}
impl Deref for ROSC {
    type Target = rosc::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for ROSC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("ROSC").finish()
    }
}
#[doc = "ROSC"]
pub mod rosc;
#[doc = "control and status for on-chip voltage regulator and chip level reset subsystem"]
pub struct VREG_AND_CHIP_RESET {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for VREG_AND_CHIP_RESET {}
impl VREG_AND_CHIP_RESET {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const vreg_and_chip_reset::RegisterBlock = 0x4006_4000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const vreg_and_chip_reset::RegisterBlock {
        Self::PTR
    }
}
impl Deref for VREG_AND_CHIP_RESET {
    type Target = vreg_and_chip_reset::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for VREG_AND_CHIP_RESET {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("VREG_AND_CHIP_RESET").finish()
    }
}
#[doc = "control and status for on-chip voltage regulator and chip level reset subsystem"]
pub mod vreg_and_chip_reset;
#[doc = "Testbench manager. Allows the programmer to know what platform their software is running on."]
pub struct TBMAN {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TBMAN {}
impl TBMAN {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tbman::RegisterBlock = 0x4006_c000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tbman::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TBMAN {
    type Target = tbman::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TBMAN {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TBMAN").finish()
    }
}
#[doc = "Testbench manager. Allows the programmer to know what platform their software is running on."]
pub mod tbman;
#[doc = "DMA with separate read and write masters"]
pub struct DMA {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for DMA {}
impl DMA {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const dma::RegisterBlock = 0x5000_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const dma::RegisterBlock {
        Self::PTR
    }
}
impl Deref for DMA {
    type Target = dma::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for DMA {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("DMA").finish()
    }
}
#[doc = "DMA with separate read and write masters"]
pub mod dma;
#[doc = "DPRAM layout for USB device."]
pub struct USBCTRL_DPRAM {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for USBCTRL_DPRAM {}
impl USBCTRL_DPRAM {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const usbctrl_dpram::RegisterBlock = 0x5010_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const usbctrl_dpram::RegisterBlock {
        Self::PTR
    }
}
impl Deref for USBCTRL_DPRAM {
    type Target = usbctrl_dpram::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for USBCTRL_DPRAM {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("USBCTRL_DPRAM").finish()
    }
}
#[doc = "DPRAM layout for USB device."]
pub mod usbctrl_dpram;
#[doc = "USB FS/LS controller device registers"]
pub struct USBCTRL_REGS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for USBCTRL_REGS {}
impl USBCTRL_REGS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const usbctrl_regs::RegisterBlock = 0x5011_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const usbctrl_regs::RegisterBlock {
        Self::PTR
    }
}
impl Deref for USBCTRL_REGS {
    type Target = usbctrl_regs::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for USBCTRL_REGS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("USBCTRL_REGS").finish()
    }
}
#[doc = "USB FS/LS controller device registers"]
pub mod usbctrl_regs;
#[doc = "Programmable IO block"]
pub struct PIO0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PIO0 {}
impl PIO0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pio0::RegisterBlock = 0x5020_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pio0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PIO0 {
    type Target = pio0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PIO0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PIO0").finish()
    }
}
#[doc = "Programmable IO block"]
pub mod pio0;
#[doc = "Programmable IO block"]
pub struct PIO1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PIO1 {}
impl PIO1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pio0::RegisterBlock = 0x5030_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pio0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PIO1 {
    type Target = pio0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PIO1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PIO1").finish()
    }
}
#[doc = "Single-cycle IO block  
 Provides core-local and inter-core hardware for the two processors, with single-cycle access."]
pub struct SIO {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SIO {}
impl SIO {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const sio::RegisterBlock = 0xd000_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const sio::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SIO {
    type Target = sio::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SIO {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SIO").finish()
    }
}
#[doc = "Single-cycle IO block  
 Provides core-local and inter-core hardware for the two processors, with single-cycle access."]
pub mod sio;
#[doc = "PPB"]
pub struct PPB {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PPB {}
impl PPB {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const ppb::RegisterBlock = 0xe000_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const ppb::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PPB {
    type Target = ppb::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PPB {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PPB").finish()
    }
}
#[doc = "PPB"]
pub mod ppb;
#[no_mangle]
static mut DEVICE_PERIPHERALS: bool = false;
#[doc = r"All the peripherals"]
#[allow(non_snake_case)]
pub struct Peripherals {
    #[doc = "ADC"]
    pub ADC: ADC,
    #[doc = "BUSCTRL"]
    pub BUSCTRL: BUSCTRL,
    #[doc = "CLOCKS"]
    pub CLOCKS: CLOCKS,
    #[doc = "DMA"]
    pub DMA: DMA,
    #[doc = "I2C0"]
    pub I2C0: I2C0,
    #[doc = "I2C1"]
    pub I2C1: I2C1,
    #[doc = "IO_BANK0"]
    pub IO_BANK0: IO_BANK0,
    #[doc = "IO_QSPI"]
    pub IO_QSPI: IO_QSPI,
    #[doc = "PADS_BANK0"]
    pub PADS_BANK0: PADS_BANK0,
    #[doc = "PADS_QSPI"]
    pub PADS_QSPI: PADS_QSPI,
    #[doc = "PIO0"]
    pub PIO0: PIO0,
    #[doc = "PIO1"]
    pub PIO1: PIO1,
    #[doc = "PLL_SYS"]
    pub PLL_SYS: PLL_SYS,
    #[doc = "PLL_USB"]
    pub PLL_USB: PLL_USB,
    #[doc = "PPB"]
    pub PPB: PPB,
    #[doc = "PSM"]
    pub PSM: PSM,
    #[doc = "PWM"]
    pub PWM: PWM,
    #[doc = "RESETS"]
    pub RESETS: RESETS,
    #[doc = "ROSC"]
    pub ROSC: ROSC,
    #[doc = "RTC"]
    pub RTC: RTC,
    #[doc = "SIO"]
    pub SIO: SIO,
    #[doc = "SPI0"]
    pub SPI0: SPI0,
    #[doc = "SPI1"]
    pub SPI1: SPI1,
    #[doc = "SYSCFG"]
    pub SYSCFG: SYSCFG,
    #[doc = "SYSINFO"]
    pub SYSINFO: SYSINFO,
    #[doc = "TBMAN"]
    pub TBMAN: TBMAN,
    #[doc = "TIMER"]
    pub TIMER: TIMER,
    #[doc = "UART0"]
    pub UART0: UART0,
    #[doc = "UART1"]
    pub UART1: UART1,
    #[doc = "USBCTRL_DPRAM"]
    pub USBCTRL_DPRAM: USBCTRL_DPRAM,
    #[doc = "USBCTRL_REGS"]
    pub USBCTRL_REGS: USBCTRL_REGS,
    #[doc = "VREG_AND_CHIP_RESET"]
    pub VREG_AND_CHIP_RESET: VREG_AND_CHIP_RESET,
    #[doc = "WATCHDOG"]
    pub WATCHDOG: WATCHDOG,
    #[doc = "XIP_CTRL"]
    pub XIP_CTRL: XIP_CTRL,
    #[doc = "XIP_SSI"]
    pub XIP_SSI: XIP_SSI,
    #[doc = "XOSC"]
    pub XOSC: XOSC,
}
impl Peripherals {
    #[doc = r"Returns all the peripherals *once*"]
    #[inline]
    pub fn take() -> Option<Self> {
        cortex_m::interrupt::free(|_| {
            if unsafe { DEVICE_PERIPHERALS } {
                None
            } else {
                Some(unsafe { Peripherals::steal() })
            }
        })
    }
    #[doc = r"Unchecked version of `Peripherals::take`"]
    #[inline]
    pub unsafe fn steal() -> Self {
        DEVICE_PERIPHERALS = true;
        Peripherals {
            XIP_CTRL: XIP_CTRL {
                _marker: PhantomData,
            },
            XIP_SSI: XIP_SSI {
                _marker: PhantomData,
            },
            SYSINFO: SYSINFO {
                _marker: PhantomData,
            },
            SYSCFG: SYSCFG {
                _marker: PhantomData,
            },
            CLOCKS: CLOCKS {
                _marker: PhantomData,
            },
            RESETS: RESETS {
                _marker: PhantomData,
            },
            PSM: PSM {
                _marker: PhantomData,
            },
            IO_BANK0: IO_BANK0 {
                _marker: PhantomData,
            },
            IO_QSPI: IO_QSPI {
                _marker: PhantomData,
            },
            PADS_BANK0: PADS_BANK0 {
                _marker: PhantomData,
            },
            PADS_QSPI: PADS_QSPI {
                _marker: PhantomData,
            },
            XOSC: XOSC {
                _marker: PhantomData,
            },
            PLL_SYS: PLL_SYS {
                _marker: PhantomData,
            },
            PLL_USB: PLL_USB {
                _marker: PhantomData,
            },
            BUSCTRL: BUSCTRL {
                _marker: PhantomData,
            },
            UART0: UART0 {
                _marker: PhantomData,
            },
            UART1: UART1 {
                _marker: PhantomData,
            },
            SPI0: SPI0 {
                _marker: PhantomData,
            },
            SPI1: SPI1 {
                _marker: PhantomData,
            },
            I2C0: I2C0 {
                _marker: PhantomData,
            },
            I2C1: I2C1 {
                _marker: PhantomData,
            },
            ADC: ADC {
                _marker: PhantomData,
            },
            PWM: PWM {
                _marker: PhantomData,
            },
            TIMER: TIMER {
                _marker: PhantomData,
            },
            WATCHDOG: WATCHDOG {
                _marker: PhantomData,
            },
            RTC: RTC {
                _marker: PhantomData,
            },
            ROSC: ROSC {
                _marker: PhantomData,
            },
            VREG_AND_CHIP_RESET: VREG_AND_CHIP_RESET {
                _marker: PhantomData,
            },
            TBMAN: TBMAN {
                _marker: PhantomData,
            },
            DMA: DMA {
                _marker: PhantomData,
            },
            USBCTRL_DPRAM: USBCTRL_DPRAM {
                _marker: PhantomData,
            },
            USBCTRL_REGS: USBCTRL_REGS {
                _marker: PhantomData,
            },
            PIO0: PIO0 {
                _marker: PhantomData,
            },
            PIO1: PIO1 {
                _marker: PhantomData,
            },
            SIO: SIO {
                _marker: PhantomData,
            },
            PPB: PPB {
                _marker: PhantomData,
            },
        }
    }
}
