# Secure transports for RPKI-RTR

[RFC6810](https://tools.ietf.org/html/rfc6810#page-17) defines a number of
secure transports for RPKI-RTR that can be used to secure communication
between a router and a RPKI relying party.

Subsequent survey in the form of [RFC7128](https://tools.ietf.org/html/rfc7128#page-7)
suggests these secure transport have not been widely implemented.
Implementations, however, do exist, and a secure transport could be valuable
in situations where the RPKI relying party is provided as a public service,
or across a non-trusted network.

## SSH transport for RPKI-RTR

SSH transport for RPKI-RTR can be configured with the help of [netcat](http://netcat.sourceforge.net/)
and [OpenSSH](https://www.openssh.com/).

Begin by installing the `openssh-server` and `netcat` packages.

Install Routinator and ensure it is running in RTR listener mode on localhost:

```bash
routinator server --rtr 127.0.0.1:3323
```

Create a username and a password for the router to log into the host with,
such as `rpki`.

Configure OpenSSH to expose an `rpki-rtr` subsystem that acts as a proxy
into Routinator by editing the `/etc/ssh/sshd_config` file or equivalent to
include the following line:

```text
# Define an `rpki-rtr` subsystem which is actually `netcat` used to proxy STDIN/STDOUT to a running `routinator server --rtr 127.0.0.1:3323`
Subsystem       rpki-rtr        /bin/nc 127.0.0.1 3323

# Certain routers may use old KEX algos and Ciphers which are no longer enabled by default.
# These examples are required in IOS-XR 5.3 but no longer enabled by default in OpenSSH 7.3
Ciphers +3des-cbc
KexAlgorithms +diffie-hellman-group1-sha1
```

Restart the OpenSSH server daemon.

An example router-side configuration for a device running IOS-XR:

```text
router bgp 65534
 rpki server 192.168.0.100
  username rpki
  password rpki
  transport ssh port 22
```

## TLS transport for RPKI-RTR

TLS transport for RPKI-RTR can be configured with the help of [stunnel](https://www.stunnel.org/).

Begin by installing the `stunnel` package.

Install Routinator and ensure it is running in RTR listener mode on localhost:

```bash
routinator server --rtr 127.0.0.1:3323
```

Acquire (via for example [letsencrypt](https://letsencrypt.org/)) or generate
an SSL certificate. In the example below, an SSL certificate for
the domain `example.com` generated by `letsencrypt` is used.

Create an stunnel configuration file by editing `/etc/stunnel/rpki.conf`
or equivalent:

```text
[rpki]
; Use a letsencrypt certificate for example.com
cert = /etc/letsencrypt/live/example.com/fullchain.pem
key = /etc/letsencrypt/live/example.com/privkey.pem

; Listen for TLS rpki-rtr on port 323 and proxy to port 3323 on localhost
accept = 323
connect = 127.0.0.1:3323
```

Restart stunnel.
