use routinator_ui::endpoints::{get_endpoints, UiResource};

fn print_endpoint(endpoint: std::io::Result<UiResource>) -> std::io::Result<String> {
    let e = endpoint?;
    Ok(format!(
        "{} ({} bytes) {}",
        e.endpoint,
        e.content.len(),
        String::from_utf8_lossy(&e.content_type)
    ))
}

fn main() {
    println!("Files included in rs file generated by this crate: ");
    for e in get_endpoints() {
        print_endpoint(e).map_or_else(
            |e| {
                println!("routinator-ui: failed to print endpoint: {}", e);
            },
            |v| {
                println!("{}", v);
            },
        );
    }
}
