extern crate alloc;

use alloc::rc::Rc;
use core::cell::RefCell;

use crate::module::bcm_module::BcmModuleConfig;
use crate::module::button_module::ButtonModuleConfig;
use crate::module::config_module::ConfigModuleConfig;
use crate::module::hello_module::HelloModuleConfig;
use crate::module::relay_module::RelayModuleConfig;
use crate::module::programmer_module::ProgrammerModuleConfig;

pub mod bcm_module;
pub mod button_module;
pub mod config_module;
pub mod hello_module;
pub mod relay_module;
pub mod programmer_module;

pub enum ModuleConfig<'a, 'b> {
    ProgrammerModule(ProgrammerModuleConfig<'a>),
    HelloModule(HelloModuleConfig<'a>),
    BcmModule(BcmModuleConfig<'a, 'b>),
    ButtonModule(ButtonModuleConfig<'a>),
    RelayModule(RelayModuleConfig<'a>),
    ConfigModule(ConfigModuleConfig<'a, 'b>),
}

pub trait Module<'a> {
    fn new<'b>(config: ModuleConfig<'a, 'b>) -> Rc<RefCell<Self>>;
    fn tick(module: Rc<RefCell<Self>>, current_time: &mut u32);
}
