use eeprom24x::addr_size::TwoBytes;
use eeprom24x::page_size::B32;
use eeprom24x::{Eeprom24x, SlaveAddr};
use stm32f1xx_hal_bxcan::afio;
use stm32f1xx_hal_bxcan::i2c::{BlockingI2c, Mode};
use stm32f1xx_hal_bxcan::pac::I2C1;
use stm32f1xx_hal_bxcan::prelude::*;
use stm32f1xx_hal_bxcan::rcc::{Clocks, APB1};

use ross_eeprom::Eeprom;

use crate::config::EepromConfig;
use crate::helper::type_helper::*;

pub fn setup_eeprom(
    eeprom_config: &EepromConfig,
    clocks: Clocks,
    scl: EepromSclPin,
    sda: EepromSdaPin,
    i2c1: I2C1,
    apb1: &mut APB1,
    mapr: &mut afio::MAPR,
) -> Eeprom<EepromI2c, B32, TwoBytes> {
    let i2c1 = {
        // TODO: Put better values in the last 4 arguments
        BlockingI2c::i2c1(
            i2c1,
            (scl, sda),
            mapr,
            Mode::standard(eeprom_config.bitrate.hz()),
            clocks,
            apb1,
            10,
            10,
            10,
            10,
        )
    };

    let eeprom = Eeprom24x::new_24x32(i2c1, SlaveAddr::Alternative(false, false, false));

    Eeprom::new(eeprom, eeprom_config.device_info_address)
}
