#[derive(Debug)]
pub struct HeapConfig {
    pub size: usize,
}

#[derive(Debug)]
pub struct EepromConfig {
    pub bitrate: u32,
    pub device_info_address: u32,
}

#[derive(Debug)]
pub struct CanConfig {
    pub bitrate: u32,
    pub tseg1: u32,
    pub tseg2: u32,
    pub sjw: u32,
}

#[derive(Debug)]
pub struct UsartConfig {
    pub baudrate: u32,
}

#[derive(Debug)]
pub struct Config {
    pub heap_config: Option<HeapConfig>,
    pub eeprom_config: Option<EepromConfig>,
    pub can_config: Option<CanConfig>,
    pub usart_config: Option<UsartConfig>,
}

impl Config {
    pub fn unwrap_heap_config(&self) -> &HeapConfig {
        self.heap_config.as_ref().unwrap()
    }

    pub fn unwrap_eeprom_config(&self) -> &EepromConfig {
        self.eeprom_config.as_ref().unwrap()
    }

    pub fn unwrap_can_config(&self) -> &CanConfig {
        self.can_config.as_ref().unwrap()
    }

    pub fn unwrap_usart_config(&self) -> &UsartConfig {
        self.usart_config.as_ref().unwrap()
    }
}
