use stm32f1xx_hal_bxcan::can::Can as HalCan;
use stm32f1xx_hal_bxcan::gpio::gpioa::{PA10, PA11, PA12, PA9};
use stm32f1xx_hal_bxcan::gpio::gpiob::{PB13, PB14, PB15, PB6, PB7};
use stm32f1xx_hal_bxcan::gpio::{Alternate, Floating, Input, OpenDrain, Output, PushPull};
use stm32f1xx_hal_bxcan::i2c::BlockingI2c;
use stm32f1xx_hal_bxcan::pac::{CAN1, I2C1, SPI2, USART1};
use stm32f1xx_hal_bxcan::serial::Serial;
use stm32f1xx_hal_bxcan::spi::{NoMiso, Spi, Spi2NoRemap};

use ross_protocol::interface::can::Can;
use ross_protocol::interface::usart::Usart;
use ross_protocol::protocol::Protocol;

pub type CanProtocol<'a> = Protocol<'a, Can<HalCan<CAN1>>>;
pub type UsartProtocol<'a> =
    Protocol<'a, Usart<Serial<USART1, (PA9<Alternate<PushPull>>, PA10<Input<Floating>>)>>>;

pub type CanRxPin = PA11<Input<Floating>>;
pub type CanTxPin = PA12<Alternate<PushPull>>;

pub type EepromSclPin = PB6<Alternate<OpenDrain>>;
pub type EepromSdaPin = PB7<Alternate<OpenDrain>>;
pub type EepromI2c = BlockingI2c<I2C1, (EepromSclPin, EepromSdaPin)>;

pub type BcmClockPin = PB13<Alternate<PushPull>>;
pub type BcmLatchPin = PB14<Output<PushPull>>;
pub type BcmDataPin = PB15<Alternate<PushPull>>;
pub type BcmSpi =
    Spi<SPI2, Spi2NoRemap, (PB13<Alternate<PushPull>>, NoMiso, PB15<Alternate<PushPull>>), u8>;
