extern crate alloc;

use alloc::rc::Rc;
use core::cell::RefCell;

use crate::module::bcm_module::BcmModuleConfig;
use crate::module::button_module::ButtonModuleConfig;
use crate::module::config_module::ConfigModuleConfig;
use crate::module::hello_module::HelloModuleConfig;
use crate::module::programmer_module::ProgrammerModuleConfig;

pub mod bcm_module;
pub mod button_module;
pub mod config_module;
pub mod hello_module;
pub mod programmer_module;

pub enum ModuleConfig<'a> {
    ProgrammerModule(ProgrammerModuleConfig<'a>),
    HelloModule(HelloModuleConfig<'a>),
    BcmModule(BcmModuleConfig<'a>),
    ButtonModule(ButtonModuleConfig<'a>),
    ConfigModule(ConfigModuleConfig<'a>),
}

pub trait Module<'a> {
    fn new(config: ModuleConfig<'a>) -> Rc<RefCell<Self>>;
    fn tick(&mut self);
}
